(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    200279,      11992]*)
(*NotebookOutlinePosition[    211231,      12309]*)
(*  CellTagsIndexPosition[    210246,      12269]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "OrderStar",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.91.1", "1.1"}],

Cell["\<\
Analysis of the stability of numerical methods for solving differential \
equations is a considerably more difficult task than finding the order of \
approximation. This difficulty is reflected in the fact that there are many \
different ways of defining stability. This package assists in the \
determination of stability regions for numerical methods. \
\>", "Text",
 CellTags->{"S5.91.1", "1.2"}],

Cell["\<\
Stability regions are important because they reflect the rate at which errors \
are propagated in the approximate solution. Just as there are absolute and \
relative errors in numerical analysis, there are also absolute and relative \
measures of stability. This package renders order stars, which are useful in \
examining the relative stability of a method. Furthermore, by specifying the \
comparison function to be identically 1, you can also draw regions of \
absolute stability. \
\>", "Text",
 CellTags->{"S5.91.1", "1.3"}],

Cell["\<\
A given numerical method for a problem can be recast into the framework of \
approximation theory. The goal is then to study how well this approximant \
behaves when compared with the solution. There is a kind of paradox here, for \
if the solution were known then you would have no need to resort to a \
numerical approximation. However, you want to establish a framework which \
applies to any problem in a given class. Since generically analytic solutions \
to problems cannot be found, it is common to study how a numerical method \
behaves when it is applied to a linearized system. In the area of ordinary \
differential equations, for example, you might be interested in solutions to \
the system of equations: \
\>", "Text",
 CellTags->{"S5.91.1", "1.4"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    StyleBox["y",
     "TB"], "\[Prime]"], 
   RowBox[{"(", 
    StyleBox["t",
     "TI"], ")"}], "=", 
   StyleBox["f",
    "TB"], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["y",
      "TB"], 
     RowBox[{"(", 
      StyleBox["t",
       "TI"], ")"}], ",", 
     StyleBox["t",
      "TI"]}], ")"}]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.91.1", "1.5"}],

Cell[TextData[{
 "for a generally nonlinear ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". It is common to replace this system by a scalar linear problem that you \
can solve, namely, "
}], "Text",
 CellTags->{"S5.91.1", "1.6"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    StyleBox["y",
     "TI"], "\[Prime]"], 
   RowBox[{"(", 
    StyleBox["t",
     "TI"], ")"}], "=", 
   RowBox[{"\[Lambda]", " "}], 
   StyleBox["y",
    "TI"], 
   RowBox[{"(", 
    StyleBox["t",
     "TI"], ")"}], 
   RowBox[{",", "  "}], 
   StyleBox["y",
    "TI"], 
   RowBox[{"(", 
    SubscriptBox[
     StyleBox["t",
      "TI"], "0"], ")"}], "=", 
   SubscriptBox[
    StyleBox["y",
     "TI"], "0"], " "}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.91.1", "1.7"}],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is considered to be a complex constant and you have fixed an initial \
condition so that the equation is uniquely determined. Stability analysis is \
now a study of how well a numerical solution behaves when applied to the \
simplified differential equation (",
 ButtonBox["1",
  ButtonStyle->"AddOnsLink",
  ButtonData->{"NumericalMath`OrderStar`", "1.7"}],
 " ). Equation (",
 ButtonBox["1",
  ButtonStyle->"AddOnsLink",
  ButtonData->{"NumericalMath`OrderStar`", "1.7"}],
 " ) is often referred to as the scalar linear test problem, or Dahlquist\
\[CloseCurlyQuote]s equation. "
}], "Text",
 CellTags->{"S5.91.1", "1.8"}],

Cell["\<\
The discussion which follows concentrates on how to use the package. You \
should keep in mind that although the focus is on the behavior of an \
approximant, our underlying interest is in the numerical method from which \
the approximant arose when applied to some problem. For more information on \
this correspondence, stability analysis, and the theory of order stars, see \
the references at the end of this section. \
\>", "Text",
 CellTags->{"S5.91.1", "1.9"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["OrderStar[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["draw the order star depicting the region where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[VerticalSeparator]", 
         StyleBox["r",
          "TI"], "/", 
         StyleBox["f",
          "TI"], "\[VerticalSeparator]", "<", "1"}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", for the functions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderStar[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["draw the region in the complex ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]plane where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[VerticalSeparator]", 
         StyleBox["r",
          "TI"], "/", 
         StyleBox["f",
          "TI"], "\[VerticalSeparator]", "<", "1"}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["r",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" are functions of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["z",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderStar[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", OrderStarKind -> Second]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["draw the order star depicting the region where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"Re", " ", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["r",
            "TI"], "-", 
           StyleBox["f",
            "TI"]}], ")"}], "<", "0"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.91.1"],

Cell["Drawing order stars. ", "Caption",
 CellTags->"S5.91.1"],

Cell["\<\
Pad\[EAcute] approximations are rational polynomial approximants where all \
parameters are chosen to maximize order at some local expansion point. \
Certain numerical methods such as Runge\[Hyphen]Kutta methods are related to \
Pad\[EAcute] approximants to the exponential.   \
\>", "Text",
 CellTags->{"S5.91.1", "1.10"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.91.1", "1.11"}],

Cell["<<NumericalMath`OrderStar`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.91.1"],

Cell[TextData[{
 "This constructs a Pad\[EAcute] approximant to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", 
    RowBox[{"(", 
     StyleBox["z",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The package for doing this is loaded automatically. This approximant \
corresponds to the forward Euler method. "
}], "MathCaption",
 CellTags->{"S5.91.1", "1.12"}],

Cell[CellGroupData[{

Cell["approx = Pade[ Exp[z], {z, 0, 1, 0} ]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.91.1"],

Cell[BoxData[
 RowBox[{"1", "+", "z"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.91.1"]
}, Open  ]],

Cell["\<\
This is the relative stability region, or order star of the first kind, for \
the forward Euler method. The pole of the approximant is highlighted. \
\>", "MathCaption",
 CellTags->{"S5.91.1", "1.13"}],

Cell[CellGroupData[{

Cell["OrderStar[ approx, E^z ]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.91.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .60606 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.606061 [
[ 0 0 0 0 ]
[ 1 .60606 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .60606 L
0 .60606 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.606061 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.651515 0.30303 0.30303 0.30303 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .60606 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .60606 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .60606 L
s
0 .60606 m
1 .60606 L
s
1 0 m
1 .60606 L
s
0 .30303 m
1 .30303 L
s
.65152 0 m
.65152 .60606 L
s
0 0 m
1 0 L
1 .60606 L
0 .60606 L
closepath
clip
newpath
.5 g
0 .60606 m
1 .60606 L
1 0 L
0 0 L
F
1 g
.8524 .60606 m
.84873 .59839 L
.8481 .59709 L
.84501 .59072 L
.84125 .58305 L
.83743 .57537 L
.83544 .5714 L
.83357 .5677 L
.82966 .56003 L
.8257 .55236 L
.82278 .54678 L
.82168 .54469 L
.81761 .53702 L
.81348 .52934 L
.81013 .52319 L
.8093 .52167 L
.80505 .514 L
.80074 .50633 L
.79747 .50059 L
.79636 .49866 L
.79192 .49099 L
.7874 .48331 L
.78481 .47896 L
.78282 .47564 L
.77816 .46797 L
.77342 .4603 L
.77215 .45826 L
.76861 .45263 L
.7637 .44496 L
.75949 .43847 L
.75871 .43728 L
.75363 .42961 L
.74846 .42194 L
.74684 .41956 L
.74319 .41427 L
.73781 .4066 L
.73418 .40151 L
.73232 .39893 L
.72672 .39125 L
.72152 .38428 L
.72099 .38358 L
.71515 .37591 L
.70916 .36824 L
.70886 .36786 L
.70306 .36057 L
.69676 .3529 L
.6962 .35223 L
.69041 .34522 L
.68372 .33755 L
.68354 .33736 L
.67738 .32988 L
.67089 .32328 L
.66994 .32221 L
.66275 .31454 L
.65823 .30984 L
.64557 .3089 L
.6397 .31454 L
.63291 .32116 L
.6311 .32221 L
.62194 .32988 L
.62025 .33221 L
.61362 .33755 L
.60759 .34282 L
.6045 .34522 L
.59494 .35276 L
.59476 .3529 L
.58434 .36057 L
.58228 .36208 L
.57332 .36824 L
.56962 .37074 L
.56154 .37591 L
.55696 .37877 L
.54881 .38358 L
.5443 .38616 L
.53486 .39125 L
.53165 .39292 L
.51926 .39893 L
.51899 .39905 L
.50633 .40456 L
.50122 .4066 L
.49367 .40943 L
.48101 .41366 L
.47901 .41427 L
.46835 .41725 L
.4557 .42017 L
.44615 .42194 L
.44304 .42243 L
.43038 .42398 L
.41772 .42482 L
.40506 .4249 L
.39241 .42418 L
.37975 .4226 L
.37548 .42194 L
.36709 .4201 L
.35443 .41656 L
.34768 .41427 L
.34177 .41186 L
.33057 .4066 L
.32911 .4058 L
.31768 .39893 L
.31646 .39808 L
.30733 .39125 L
.3038 .38821 L
.2988 .38358 L
.29165 .37591 L
.29114 .3753 L
.28559 .36824 L
.28048 .36057 L
.27848 .35715 L
.27619 .3529 L
.27263 .34522 L
.26975 .33755 L
.26749 .32988 L
.26582 .32224 L
.26582 .32221 L
.26472 .31454 L
.26417 .30687 L
.26417 .29919 L
.26472 .29152 L
.26582 .28385 L
.26582 .28382 L
.26749 .27618 L
.26975 .26851 L
.27263 .26084 L
.27619 .25316 L
.27848 .24891 L
.28048 .24549 L
.28559 .23782 L
.29114 .23076 L
.29165 .23015 L
.2988 .22248 L
.3038 .21785 L
.30733 .21481 L
.31646 .20798 L
.31768 .20713 L
.32911 .20026 L
.33057 .19946 L
.34177 .1942 L
.34768 .19179 L
.35443 .1895 L
.36709 .18596 L
.37548 .18412 L
.37975 .18346 L
.39241 .18188 L
.40506 .18116 L
.41772 .18124 L
.43038 .18208 L
.44304 .18363 L
.44615 .18412 L
.4557 .18589 L
.46835 .18881 L
.47901 .19179 L
.48101 .1924 L
.49367 .19663 L
.50122 .19946 L
.50633 .2015 L
.51899 .20701 L
.51926 .20713 L
.53165 .21314 L
.53486 .21481 L
.5443 .2199 L
.54881 .22248 L
.55696 .22729 L
.56154 .23015 L
.56962 .23532 L
.57332 .23782 L
.58228 .24398 L
.58434 .24549 L
.59476 .25316 L
.59494 .2533 L
.6045 .26084 L
.60759 .26324 L
.61362 .26851 L
.62025 .27385 L
.62194 .27618 L
.6311 .28385 L
.63291 .2849 L
.6397 .29152 L
.64557 .29716 L
.65823 .29622 L
.66275 .29152 L
.66994 .28385 L
.67089 .28278 L
.67738 .27618 L
.68354 .2687 L
.68372 .26851 L
.69041 .26084 L
.6962 .25383 L
.69676 .25316 L
.70306 .24549 L
.70886 .2382 L
.70916 .23782 L
.71515 .23015 L
.72099 .22248 L
.72152 .22178 L
.72672 .21481 L
.73232 .20713 L
.73418 .20455 L
.73781 .19946 L
.74319 .19179 L
.74684 .1865 L
.74846 .18412 L
.75363 .17645 L
.75871 .16878 L
.75949 .16759 L
.7637 .1611 L
.76861 .15343 L
.77215 .1478 L
.77342 .14576 L
.77816 .13809 L
.78282 .13042 L
.78481 .1271 L
.7874 .12275 L
.79192 .11507 L
.79636 .1074 L
.79747 .10547 L
.80074 .09973 L
.80505 .09206 L
.8093 .08439 L
.81013 .08287 L
.81348 .07672 L
.81761 .06904 L
.82168 .06137 L
.82278 .05928 L
.8257 .0537 L
.82966 .04603 L
.83357 .03836 L
.83544 .03466 L
.83743 .03069 L
.84125 .02301 L
.84501 .01534 L
.8481 .00897 L
.84873 .00767 L
.8524 0 L
1 0 L
1 .60606 L
F
0 g
.5 Mabswid
.8524 .60606 m
.84873 .59839 L
.8481 .59709 L
.84501 .59072 L
.84125 .58305 L
.83743 .57537 L
.83544 .5714 L
.83357 .5677 L
.82966 .56003 L
.8257 .55236 L
.82278 .54678 L
.82168 .54469 L
.81761 .53702 L
.81348 .52934 L
.81013 .52319 L
.8093 .52167 L
.80505 .514 L
.80074 .50633 L
.79747 .50059 L
.79636 .49866 L
.79192 .49099 L
.7874 .48331 L
.78481 .47896 L
.78282 .47564 L
.77816 .46797 L
.77342 .4603 L
.77215 .45826 L
.76861 .45263 L
.7637 .44496 L
.75949 .43847 L
.75871 .43728 L
.75363 .42961 L
.74846 .42194 L
.74684 .41956 L
.74319 .41427 L
.73781 .4066 L
.73418 .40151 L
.73232 .39893 L
.72672 .39125 L
.72152 .38428 L
.72099 .38358 L
.71515 .37591 L
.70916 .36824 L
.70886 .36786 L
.70306 .36057 L
.69676 .3529 L
.6962 .35223 L
.69041 .34522 L
.68372 .33755 L
.68354 .33736 L
Mistroke
.67738 .32988 L
.67089 .32328 L
.66994 .32221 L
.66275 .31454 L
.65823 .30984 L
.64557 .3089 L
.6397 .31454 L
.63291 .32116 L
.6311 .32221 L
.62194 .32988 L
.62025 .33221 L
.61362 .33755 L
.60759 .34282 L
.6045 .34522 L
.59494 .35276 L
.59476 .3529 L
.58434 .36057 L
.58228 .36208 L
.57332 .36824 L
.56962 .37074 L
.56154 .37591 L
.55696 .37877 L
.54881 .38358 L
.5443 .38616 L
.53486 .39125 L
.53165 .39292 L
.51926 .39893 L
.51899 .39905 L
.50633 .40456 L
.50122 .4066 L
.49367 .40943 L
.48101 .41366 L
.47901 .41427 L
.46835 .41725 L
.4557 .42017 L
.44615 .42194 L
.44304 .42243 L
.43038 .42398 L
.41772 .42482 L
.40506 .4249 L
.39241 .42418 L
.37975 .4226 L
.37548 .42194 L
.36709 .4201 L
.35443 .41656 L
.34768 .41427 L
.34177 .41186 L
.33057 .4066 L
.32911 .4058 L
.31768 .39893 L
Mistroke
.31646 .39808 L
.30733 .39125 L
.3038 .38821 L
.2988 .38358 L
.29165 .37591 L
.29114 .3753 L
.28559 .36824 L
.28048 .36057 L
.27848 .35715 L
.27619 .3529 L
.27263 .34522 L
.26975 .33755 L
.26749 .32988 L
.26582 .32224 L
.26582 .32221 L
.26472 .31454 L
.26417 .30687 L
.26417 .29919 L
.26472 .29152 L
.26582 .28385 L
.26582 .28382 L
.26749 .27618 L
.26975 .26851 L
.27263 .26084 L
.27619 .25316 L
.27848 .24891 L
.28048 .24549 L
.28559 .23782 L
.29114 .23076 L
.29165 .23015 L
.2988 .22248 L
.3038 .21785 L
.30733 .21481 L
.31646 .20798 L
.31768 .20713 L
.32911 .20026 L
.33057 .19946 L
.34177 .1942 L
.34768 .19179 L
.35443 .1895 L
.36709 .18596 L
.37548 .18412 L
.37975 .18346 L
.39241 .18188 L
.40506 .18116 L
.41772 .18124 L
.43038 .18208 L
.44304 .18363 L
.44615 .18412 L
.4557 .18589 L
Mistroke
.46835 .18881 L
.47901 .19179 L
.48101 .1924 L
.49367 .19663 L
.50122 .19946 L
.50633 .2015 L
.51899 .20701 L
.51926 .20713 L
.53165 .21314 L
.53486 .21481 L
.5443 .2199 L
.54881 .22248 L
.55696 .22729 L
.56154 .23015 L
.56962 .23532 L
.57332 .23782 L
.58228 .24398 L
.58434 .24549 L
.59476 .25316 L
.59494 .2533 L
.6045 .26084 L
.60759 .26324 L
.61362 .26851 L
.62025 .27385 L
.62194 .27618 L
.6311 .28385 L
.63291 .2849 L
.6397 .29152 L
.64557 .29716 L
.65823 .29622 L
.66275 .29152 L
.66994 .28385 L
.67089 .28278 L
.67738 .27618 L
.68354 .2687 L
.68372 .26851 L
.69041 .26084 L
.6962 .25383 L
.69676 .25316 L
.70306 .24549 L
.70886 .2382 L
.70916 .23782 L
.71515 .23015 L
.72099 .22248 L
.72152 .22178 L
.72672 .21481 L
.73232 .20713 L
.73418 .20455 L
.73781 .19946 L
.74319 .19179 L
Mistroke
.74684 .1865 L
.74846 .18412 L
.75363 .17645 L
.75871 .16878 L
.75949 .16759 L
.7637 .1611 L
.76861 .15343 L
.77215 .1478 L
.77342 .14576 L
.77816 .13809 L
.78282 .13042 L
.78481 .1271 L
.7874 .12275 L
.79192 .11507 L
.79636 .1074 L
.79747 .10547 L
.80074 .09973 L
.80505 .09206 L
.8093 .08439 L
.81013 .08287 L
.81348 .07672 L
.81761 .06904 L
.82168 .06137 L
.82278 .05928 L
.8257 .0537 L
.82966 .04603 L
.83357 .03836 L
.83544 .03466 L
.83743 .03069 L
.84125 .02301 L
.84501 .01534 L
.8481 .00897 L
.84873 .00767 L
.8524 0 L
Mfstroke
1 g
.58636 .33333 m
.68636 .33333 L
.68636 .27273 L
.58636 .27273 L
F
.5 g
.68 .27273 m
.67867 .27423 L
.67862 .27428 L
.67723 .27584 L
.67611 .27709 L
.67584 .27739 L
.67443 .27894 L
.67354 .27992 L
.67302 .2805 L
.6716 .28205 L
.67098 .28272 L
.67017 .28361 L
.66873 .28516 L
.66841 .2855 L
.66728 .28671 L
.66585 .28824 L
.66582 .28827 L
.66436 .28982 L
.66329 .29095 L
.66289 .29138 L
.66141 .29293 L
.66072 .29363 L
.65993 .29448 L
.65841 .29604 L
.65816 .29628 L
.65701 .29759 L
.65559 .2989 L
.65537 .29915 L
.65383 .3007 L
.65303 .30151 L
.65047 .30198 L
.64917 .3007 L
.6479 .29938 L
.64753 .29915 L
.64584 .29759 L
.64534 .29693 L
.64437 .29604 L
.6428 .29448 L
.64277 .29446 L
.64116 .29293 L
.64021 .292 L
.63954 .29138 L
.6379 .28982 L
.63765 .28958 L
.63624 .28827 L
.63508 .28719 L
.63457 .28671 L
.63289 .28516 L
.63252 .28482 L
.63119 .28361 L
.62995 .28248 L
.62948 .28205 L
.62775 .2805 L
.62739 .28017 L
.62602 .27894 L
.62483 .27789 L
.62426 .27739 L
.6225 .27584 L
.62226 .27563 L
.62071 .27428 L
.6197 .2734 L
.61891 .27273 L
F
0 g
.68 .27273 m
.67867 .27423 L
.67862 .27428 L
.67723 .27584 L
.67611 .27709 L
.67584 .27739 L
.67443 .27894 L
.67354 .27992 L
.67302 .2805 L
.6716 .28205 L
.67098 .28272 L
.67017 .28361 L
.66873 .28516 L
.66841 .2855 L
.66728 .28671 L
.66585 .28824 L
.66582 .28827 L
.66436 .28982 L
.66329 .29095 L
.66289 .29138 L
.66141 .29293 L
.66072 .29363 L
.65993 .29448 L
.65841 .29604 L
.65816 .29628 L
.65701 .29759 L
.65559 .2989 L
.65537 .29915 L
.65383 .3007 L
.65303 .30151 L
.65047 .30198 L
.64917 .3007 L
.6479 .29938 L
.64753 .29915 L
.64584 .29759 L
.64534 .29693 L
.64437 .29604 L
.6428 .29448 L
.64277 .29446 L
.64116 .29293 L
.64021 .292 L
.63954 .29138 L
.6379 .28982 L
.63765 .28958 L
.63624 .28827 L
.63508 .28719 L
.63457 .28671 L
.63289 .28516 L
.63252 .28482 L
.63119 .28361 L
Mistroke
.62995 .28248 L
.62948 .28205 L
.62775 .2805 L
.62739 .28017 L
.62602 .27894 L
.62483 .27789 L
.62426 .27739 L
.6225 .27584 L
.62226 .27563 L
.62071 .27428 L
.6197 .2734 L
.61891 .27273 L
Mfstroke
.5 g
.68 .33333 m
.67867 .33183 L
.67862 .33178 L
.67723 .33023 L
.67611 .32897 L
.67584 .32867 L
.67443 .32712 L
.67354 .32614 L
.67302 .32556 L
.6716 .32401 L
.67098 .32334 L
.67017 .32246 L
.66873 .3209 L
.66841 .32056 L
.66728 .31935 L
.66585 .31782 L
.66582 .31779 L
.66436 .31624 L
.66329 .31511 L
.66289 .31469 L
.66141 .31313 L
.66072 .31243 L
.65993 .31158 L
.65841 .31002 L
.65816 .30978 L
.65701 .30847 L
.65559 .30716 L
.65537 .30692 L
.65383 .30536 L
.65303 .30455 L
.65047 .30408 L
.64917 .30536 L
.6479 .30668 L
.64753 .30692 L
.64584 .30847 L
.64534 .30913 L
.64437 .31002 L
.6428 .31158 L
.64277 .3116 L
.64116 .31313 L
.64021 .31406 L
.63954 .31469 L
.6379 .31624 L
.63765 .31648 L
.63624 .31779 L
.63508 .31888 L
.63457 .31935 L
.63289 .3209 L
.63252 .32124 L
.63119 .32246 L
.62995 .32358 L
.62948 .32401 L
.62775 .32556 L
.62739 .32589 L
.62602 .32712 L
.62483 .32818 L
.62426 .32867 L
.6225 .33023 L
.62226 .33043 L
.62071 .33178 L
.6197 .33266 L
.61891 .33333 L
F
0 g
.68 .33333 m
.67867 .33183 L
.67862 .33178 L
.67723 .33023 L
.67611 .32897 L
.67584 .32867 L
.67443 .32712 L
.67354 .32614 L
.67302 .32556 L
.6716 .32401 L
.67098 .32334 L
.67017 .32246 L
.66873 .3209 L
.66841 .32056 L
.66728 .31935 L
.66585 .31782 L
.66582 .31779 L
.66436 .31624 L
.66329 .31511 L
.66289 .31469 L
.66141 .31313 L
.66072 .31243 L
.65993 .31158 L
.65841 .31002 L
.65816 .30978 L
.65701 .30847 L
.65559 .30716 L
.65537 .30692 L
.65383 .30536 L
.65303 .30455 L
.65047 .30408 L
.64917 .30536 L
.6479 .30668 L
.64753 .30692 L
.64584 .30847 L
.64534 .30913 L
.64437 .31002 L
.6428 .31158 L
.64277 .3116 L
.64116 .31313 L
.64021 .31406 L
.63954 .31469 L
.6379 .31624 L
.63765 .31648 L
.63624 .31779 L
.63508 .31888 L
.63457 .31935 L
.63289 .3209 L
.63252 .32124 L
.63119 .32246 L
Mistroke
.62995 .32358 L
.62948 .32401 L
.62775 .32556 L
.62739 .32589 L
.62602 .32712 L
.62483 .32818 L
.62426 .32867 L
.6225 .33023 L
.62226 .33043 L
.62071 .33178 L
.6197 .33266 L
.61891 .33333 L
Mfstroke
1 g
.33848 .29303 m
.35848 .29303 L
.35848 .31303 L
.33848 .31303 L
.33848 .29303 L
F
0 g
.003 w
.33848 .29303 m
.35848 .29303 L
.35848 .31303 L
.33848 .31303 L
.33848 .29303 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.606061 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.651515 0.30303 0.30303 0.30303 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .60606 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .60606 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .60606 L
s
0 .60606 m
1 .60606 L
s
1 0 m
1 .60606 L
s
0 .30303 m
1 .30303 L
s
.65152 0 m
.65152 .60606 L
s
0 0 m
1 0 L
1 .60606 L
0 .60606 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.91.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.91.1"]
}, Open  ]],

Cell["\<\
This is the absolute stability region for the forward Euler method, obtained \
as a relative comparison with 1. \
\>", "MathCaption",
 CellTags->{"S5.91.1", "1.14"}],

Cell[CellGroupData[{

Cell["OrderStar[ approx, 1 ]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.91.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .60606 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.606061 [
[ 0 0 0 0 ]
[ 1 .60606 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .60606 L
0 .60606 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.606061 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.651515 0.30303 0.30303 0.30303 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .60606 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .60606 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .60606 L
s
0 .60606 m
1 .60606 L
s
1 0 m
1 .60606 L
s
0 .30303 m
1 .30303 L
s
.65152 0 m
.65152 .60606 L
s
0 0 m
1 0 L
1 .60606 L
0 .60606 L
closepath
clip
newpath
.5 g
0 .60606 m
1 .60606 L
1 0 L
0 0 L
F
1 g
.29114 .00548 m
.3038 .00331 L
.31646 .0017 L
.32911 .00062 L
.34177 7e-05 L
.35443 6e-05 L
.36709 .00057 L
.37975 .00162 L
.39241 .0032 L
.40506 .00533 L
.41625 .00767 L
.41772 .00802 L
.43038 .01128 L
.44304 .01513 L
.44369 .01534 L
.4557 .0196 L
.46433 .02301 L
.46835 .02472 L
.48101 .03052 L
.48136 .03069 L
.49367 .03704 L
.49605 .03836 L
.50633 .04436 L
.50904 .04603 L
.51899 .05252 L
.52071 .0537 L
.53132 .06137 L
.53165 .06162 L
.54104 .06904 L
.5443 .07177 L
.55 .07672 L
.55696 .08311 L
.5583 .08439 L
.56601 .09206 L
.56962 .09584 L
.5732 .09973 L
.57991 .1074 L
.58228 .11024 L
.58618 .11507 L
.59205 .12275 L
.59494 .12671 L
.59755 .13042 L
.60269 .13809 L
.60751 .14576 L
.60759 .1459 L
.61201 .15343 L
.61622 .1611 L
.62015 .16878 L
.62025 .16898 L
.62381 .17645 L
.62721 .18412 L
.63036 .19179 L
.63291 .19849 L
.63327 .19946 L
.63594 .20713 L
.63839 .21481 L
.64061 .22248 L
.64262 .23015 L
.64442 .23782 L
.64557 .24329 L
.646 .24549 L
.64738 .25316 L
.64856 .26084 L
.64954 .26851 L
.65032 .27618 L
.65091 .28385 L
.6513 .29152 L
.65149 .29919 L
.65149 .30687 L
.6513 .31454 L
.65091 .32221 L
.65032 .32988 L
.64954 .33755 L
.64856 .34522 L
.64738 .3529 L
.646 .36057 L
.64557 .36277 L
.64442 .36824 L
.64262 .37591 L
.64061 .38358 L
.63839 .39125 L
.63594 .39893 L
.63327 .4066 L
.63291 .40757 L
.63036 .41427 L
.62721 .42194 L
.62381 .42961 L
.62025 .43708 L
.62015 .43728 L
.61622 .44496 L
.61201 .45263 L
.60759 .46016 L
.60751 .4603 L
.60269 .46797 L
.59755 .47564 L
.59494 .47935 L
.59205 .48331 L
.58618 .49099 L
.58228 .49582 L
.57991 .49866 L
.5732 .50633 L
.56962 .51022 L
.56601 .514 L
.5583 .52167 L
.55696 .52295 L
.55 .52934 L
.5443 .53429 L
.54104 .53702 L
.53165 .54444 L
.53132 .54469 L
.52071 .55236 L
.51899 .55354 L
.50904 .56003 L
.50633 .5617 L
.49605 .5677 L
.49367 .56902 L
.48136 .57537 L
.48101 .57554 L
.46835 .58134 L
.46433 .58305 L
.4557 .58646 L
.44369 .59072 L
.44304 .59093 L
.43038 .59478 L
.41772 .59804 L
.41625 .59839 L
.40506 .60073 L
.39241 .60286 L
.37975 .60444 L
.36709 .60549 L
.35443 .606 L
.34177 .60599 L
.32911 .60544 L
.31646 .60436 L
.3038 .60275 L
.29114 .60059 L
.28071 .59839 L
.27848 .59786 L
.26582 .59457 L
.25328 .59072 L
.25316 .59068 L
.24051 .58617 L
.23264 .58305 L
.22785 .58101 L
.21561 .57537 L
.21519 .57517 L
.20253 .5686 L
.20092 .5677 L
.18987 .56124 L
.18793 .56003 L
.17722 .55302 L
.17626 .55236 L
.16565 .54469 L
.16456 .54386 L
.15593 .53702 L
.1519 .53364 L
.14697 .52934 L
.13924 .52222 L
.13867 .52167 L
.13096 .514 L
.12658 .5094 L
.12377 .50633 L
.11706 .49866 L
.11392 .49489 L
.11079 .49099 L
.10492 .48331 L
.10127 .47827 L
.09942 .47564 L
.09428 .46797 L
.08946 .4603 L
.08861 .45889 L
.08495 .45263 L
.08075 .44496 L
.07682 .43728 L
.07595 .43551 L
.07316 .42961 L
.06976 .42194 L
.06661 .41427 L
.0637 .4066 L
.06329 .40546 L
.06103 .39893 L
.05858 .39125 L
.05636 .38358 L
.05435 .37591 L
.05255 .36824 L
.05097 .36057 L
.05063 .35882 L
.04959 .3529 L
.04841 .34522 L
.04743 .33755 L
.04665 .32988 L
.04606 .32221 L
.04567 .31454 L
.04548 .30687 L
.04548 .29919 L
.04567 .29152 L
.04606 .28385 L
.04665 .27618 L
.04743 .26851 L
.04841 .26084 L
.04959 .25316 L
.05063 .24724 L
.05097 .24549 L
.05255 .23782 L
.05435 .23015 L
.05636 .22248 L
.05858 .21481 L
.06103 .20713 L
.06329 .2006 L
.0637 .19946 L
.06661 .19179 L
.06976 .18412 L
.07316 .17645 L
.07595 .17055 L
.07682 .16878 L
.08075 .1611 L
.08495 .15343 L
.08861 .14717 L
.08946 .14576 L
.09428 .13809 L
.09942 .13042 L
.10127 .12779 L
.10492 .12275 L
.11079 .11507 L
.11392 .11117 L
.11706 .1074 L
.12377 .09973 L
.12658 .09666 L
.13096 .09206 L
.13867 .08439 L
.13924 .08384 L
.14697 .07672 L
.1519 .07242 L
.15593 .06904 L
.16456 .0622 L
.16565 .06137 L
.17626 .0537 L
.17722 .05304 L
.18793 .04603 L
.18987 .04483 L
.20092 .03836 L
.20253 .03746 L
.21519 .03089 L
.21561 .03069 L
.22785 .02505 L
.23264 .02301 L
.24051 .01989 L
.25316 .01538 L
.25328 .01534 L
.26582 .01149 L
.27848 .0082 L
.28071 .00767 L
F
0 g
.5 Mabswid
.29114 .00548 m
.3038 .00331 L
.31646 .0017 L
.32911 .00062 L
.34177 7e-05 L
.35443 6e-05 L
.36709 .00057 L
.37975 .00162 L
.39241 .0032 L
.40506 .00533 L
.41625 .00767 L
.41772 .00802 L
.43038 .01128 L
.44304 .01513 L
.44369 .01534 L
.4557 .0196 L
.46433 .02301 L
.46835 .02472 L
.48101 .03052 L
.48136 .03069 L
.49367 .03704 L
.49605 .03836 L
.50633 .04436 L
.50904 .04603 L
.51899 .05252 L
.52071 .0537 L
.53132 .06137 L
.53165 .06162 L
.54104 .06904 L
.5443 .07177 L
.55 .07672 L
.55696 .08311 L
.5583 .08439 L
.56601 .09206 L
.56962 .09584 L
.5732 .09973 L
.57991 .1074 L
.58228 .11024 L
.58618 .11507 L
.59205 .12275 L
.59494 .12671 L
.59755 .13042 L
.60269 .13809 L
.60751 .14576 L
.60759 .1459 L
.61201 .15343 L
.61622 .1611 L
.62015 .16878 L
.62025 .16898 L
.62381 .17645 L
Mistroke
.62721 .18412 L
.63036 .19179 L
.63291 .19849 L
.63327 .19946 L
.63594 .20713 L
.63839 .21481 L
.64061 .22248 L
.64262 .23015 L
.64442 .23782 L
.64557 .24329 L
.646 .24549 L
.64738 .25316 L
.64856 .26084 L
.64954 .26851 L
.65032 .27618 L
.65091 .28385 L
.6513 .29152 L
.65149 .29919 L
.65149 .30687 L
.6513 .31454 L
.65091 .32221 L
.65032 .32988 L
.64954 .33755 L
.64856 .34522 L
.64738 .3529 L
.646 .36057 L
.64557 .36277 L
.64442 .36824 L
.64262 .37591 L
.64061 .38358 L
.63839 .39125 L
.63594 .39893 L
.63327 .4066 L
.63291 .40757 L
.63036 .41427 L
.62721 .42194 L
.62381 .42961 L
.62025 .43708 L
.62015 .43728 L
.61622 .44496 L
.61201 .45263 L
.60759 .46016 L
.60751 .4603 L
.60269 .46797 L
.59755 .47564 L
.59494 .47935 L
.59205 .48331 L
.58618 .49099 L
.58228 .49582 L
.57991 .49866 L
Mistroke
.5732 .50633 L
.56962 .51022 L
.56601 .514 L
.5583 .52167 L
.55696 .52295 L
.55 .52934 L
.5443 .53429 L
.54104 .53702 L
.53165 .54444 L
.53132 .54469 L
.52071 .55236 L
.51899 .55354 L
.50904 .56003 L
.50633 .5617 L
.49605 .5677 L
.49367 .56902 L
.48136 .57537 L
.48101 .57554 L
.46835 .58134 L
.46433 .58305 L
.4557 .58646 L
.44369 .59072 L
.44304 .59093 L
.43038 .59478 L
.41772 .59804 L
.41625 .59839 L
.40506 .60073 L
.39241 .60286 L
.37975 .60444 L
.36709 .60549 L
.35443 .606 L
.34177 .60599 L
.32911 .60544 L
.31646 .60436 L
.3038 .60275 L
.29114 .60059 L
.28071 .59839 L
.27848 .59786 L
.26582 .59457 L
.25328 .59072 L
.25316 .59068 L
.24051 .58617 L
.23264 .58305 L
.22785 .58101 L
.21561 .57537 L
.21519 .57517 L
.20253 .5686 L
.20092 .5677 L
.18987 .56124 L
.18793 .56003 L
Mistroke
.17722 .55302 L
.17626 .55236 L
.16565 .54469 L
.16456 .54386 L
.15593 .53702 L
.1519 .53364 L
.14697 .52934 L
.13924 .52222 L
.13867 .52167 L
.13096 .514 L
.12658 .5094 L
.12377 .50633 L
.11706 .49866 L
.11392 .49489 L
.11079 .49099 L
.10492 .48331 L
.10127 .47827 L
.09942 .47564 L
.09428 .46797 L
.08946 .4603 L
.08861 .45889 L
.08495 .45263 L
.08075 .44496 L
.07682 .43728 L
.07595 .43551 L
.07316 .42961 L
.06976 .42194 L
.06661 .41427 L
.0637 .4066 L
.06329 .40546 L
.06103 .39893 L
.05858 .39125 L
.05636 .38358 L
.05435 .37591 L
.05255 .36824 L
.05097 .36057 L
.05063 .35882 L
.04959 .3529 L
.04841 .34522 L
.04743 .33755 L
.04665 .32988 L
.04606 .32221 L
.04567 .31454 L
.04548 .30687 L
.04548 .29919 L
.04567 .29152 L
.04606 .28385 L
.04665 .27618 L
.04743 .26851 L
.04841 .26084 L
Mistroke
.04959 .25316 L
.05063 .24724 L
.05097 .24549 L
.05255 .23782 L
.05435 .23015 L
.05636 .22248 L
.05858 .21481 L
.06103 .20713 L
.06329 .2006 L
.0637 .19946 L
.06661 .19179 L
.06976 .18412 L
.07316 .17645 L
.07595 .17055 L
.07682 .16878 L
.08075 .1611 L
.08495 .15343 L
.08861 .14717 L
.08946 .14576 L
.09428 .13809 L
.09942 .13042 L
.10127 .12779 L
.10492 .12275 L
.11079 .11507 L
.11392 .11117 L
.11706 .1074 L
.12377 .09973 L
.12658 .09666 L
.13096 .09206 L
.13867 .08439 L
.13924 .08384 L
.14697 .07672 L
.1519 .07242 L
.15593 .06904 L
.16456 .0622 L
.16565 .06137 L
.17626 .0537 L
.17722 .05304 L
.18793 .04603 L
.18987 .04483 L
.20092 .03836 L
.20253 .03746 L
.21519 .03089 L
.21561 .03069 L
.22785 .02505 L
.23264 .02301 L
.24051 .01989 L
.25316 .01538 L
.25328 .01534 L
.26582 .01149 L
Mistroke
.27848 .0082 L
.28071 .00767 L
.29114 .00548 L
Mfstroke
1 g
.58636 .33333 m
.68636 .33333 L
.68636 .27273 L
.58636 .27273 L
F
.5 g
.65 .33333 m
.65015 .33178 L
.65029 .33023 L
.65043 .32867 L
.65047 .32822 L
.65056 .32712 L
.65068 .32556 L
.65079 .32401 L
.65089 .32246 L
.65099 .3209 L
.65108 .31935 L
.65116 .31779 L
.65123 .31624 L
.65129 .31469 L
.65135 .31313 L
.65139 .31158 L
.65143 .31002 L
.65147 .30847 L
.65149 .30692 L
.65151 .30536 L
.65151 .30381 L
.65151 .30225 L
.65151 .3007 L
.65149 .29915 L
.65147 .29759 L
.65143 .29604 L
.65139 .29448 L
.65135 .29293 L
.65129 .29138 L
.65123 .28982 L
.65116 .28827 L
.65108 .28671 L
.65099 .28516 L
.65089 .28361 L
.65079 .28205 L
.65068 .2805 L
.65056 .27894 L
.65047 .27784 L
.65043 .27739 L
.65029 .27584 L
.65015 .27428 L
.65 .27273 L
.68636 .27273 L
.68636 .33333 L
F
0 g
.65 .33333 m
.65015 .33178 L
.65029 .33023 L
.65043 .32867 L
.65047 .32822 L
.65056 .32712 L
.65068 .32556 L
.65079 .32401 L
.65089 .32246 L
.65099 .3209 L
.65108 .31935 L
.65116 .31779 L
.65123 .31624 L
.65129 .31469 L
.65135 .31313 L
.65139 .31158 L
.65143 .31002 L
.65147 .30847 L
.65149 .30692 L
.65151 .30536 L
.65151 .30381 L
.65151 .30225 L
.65151 .3007 L
.65149 .29915 L
.65147 .29759 L
.65143 .29604 L
.65139 .29448 L
.65135 .29293 L
.65129 .29138 L
.65123 .28982 L
.65116 .28827 L
.65108 .28671 L
.65099 .28516 L
.65089 .28361 L
.65079 .28205 L
.65068 .2805 L
.65056 .27894 L
.65047 .27784 L
.65043 .27739 L
.65029 .27584 L
.65015 .27428 L
.65 .27273 L
s
1 g
.33848 .29303 m
.35848 .29303 L
.35848 .31303 L
.33848 .31303 L
.33848 .29303 L
F
0 g
.003 w
.33848 .29303 m
.35848 .29303 L
.35848 .31303 L
.33848 .31303 L
.33848 .29303 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.606061 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.651515 0.30303 0.30303 0.30303 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .60606 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .60606 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .60606 L
s
0 .60606 m
1 .60606 L
s
1 0 m
1 .60606 L
s
0 .30303 m
1 .30303 L
s
.65152 0 m
.65152 .60606 L
s
0 0 m
1 0 L
1 .60606 L
0 .60606 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.91.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.91.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["OrderStarInterpolation", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["specifies whether to display points where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" are equal",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderStarKind", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["specifies which kind (",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["First", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" or ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Second", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[") of order star to draw",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderStarLegend", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies whether to include a plot legend containing the various \
symbols used",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderStarPoles", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies whether to indicate the poles of the approximant and/or the \
function",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderStarZeros", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies whether to indicate the zeros of the approximant and/or the \
function",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderStarSubPlots", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies subplot ranges and the number of points to be used in \
subplots",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderStarSymbolSize", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies the size of the symbols used to indicate zeros, poles, and \
interpolation points",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OrderStarSymbolThickness", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies the line thickness for the symbols used to indicate zeros, \
poles, and interpolation points",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.91.1"],

Cell[TextData[{
 "Options unique to ",
 StyleBox["OrderStar", "MR"],
 "."
}], "Caption",
 CellTags->"S5.91.1"],

Cell[TextData[{
 "When you ask for certain features to be displayed and ",
 StyleBox["Mathematica", "TI"],
 " is unable to find these features, you will obtain the message ",
 StyleBox["OrderStar::sols", "MR"],
 " containing more specific information relating to the problem. ",
 StyleBox["Solve", "MR"],
 " may also issue messages such as when inverse functions are being used. "
}], "Text",
 CellTags->{"S5.91.1", "1.15"}],

Cell[TextData[{
 StyleBox["OrderStar", "MR"],
 " uses heuristics in order to determine what the independent variable is. \
You can save time in a very complicated expression by specifying the variable \
to use explicitly. If there is any ambiguity in the variable choice, then \
input returns unevaluated and an appropriate warning message is issued, since \
the function will not evaluate numerically.   "
}], "Text",
 CellTags->{"S5.91.1", "1.16"}],

Cell[TextData[{
 "This indicates the variable to use and highlights points where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", 
    StyleBox["z",
     "TI"], "=", "exp", 
    RowBox[{"(", 
     StyleBox["z",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This may not be possible in general if the relationship is nonalgebraic. \
"
}], "MathCaption",
 CellTags->{"S5.91.1", "1.17"}],

Cell[CellGroupData[{

Cell["\<\
OrderStar[approx, Exp[z], z,
         OrderStarInterpolation->True]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.91.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .60606 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.606061 [
[ 0 0 0 0 ]
[ 1 .60606 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .60606 L
0 .60606 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.606061 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.651515 0.30303 0.30303 0.30303 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .60606 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .60606 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .60606 L
s
0 .60606 m
1 .60606 L
s
1 0 m
1 .60606 L
s
0 .30303 m
1 .30303 L
s
.65152 0 m
.65152 .60606 L
s
0 0 m
1 0 L
1 .60606 L
0 .60606 L
closepath
clip
newpath
.5 g
0 .60606 m
1 .60606 L
1 0 L
0 0 L
F
1 g
.8524 .60606 m
.84873 .59839 L
.8481 .59709 L
.84501 .59072 L
.84125 .58305 L
.83743 .57537 L
.83544 .5714 L
.83357 .5677 L
.82966 .56003 L
.8257 .55236 L
.82278 .54678 L
.82168 .54469 L
.81761 .53702 L
.81348 .52934 L
.81013 .52319 L
.8093 .52167 L
.80505 .514 L
.80074 .50633 L
.79747 .50059 L
.79636 .49866 L
.79192 .49099 L
.7874 .48331 L
.78481 .47896 L
.78282 .47564 L
.77816 .46797 L
.77342 .4603 L
.77215 .45826 L
.76861 .45263 L
.7637 .44496 L
.75949 .43847 L
.75871 .43728 L
.75363 .42961 L
.74846 .42194 L
.74684 .41956 L
.74319 .41427 L
.73781 .4066 L
.73418 .40151 L
.73232 .39893 L
.72672 .39125 L
.72152 .38428 L
.72099 .38358 L
.71515 .37591 L
.70916 .36824 L
.70886 .36786 L
.70306 .36057 L
.69676 .3529 L
.6962 .35223 L
.69041 .34522 L
.68372 .33755 L
.68354 .33736 L
.67738 .32988 L
.67089 .32328 L
.66994 .32221 L
.66275 .31454 L
.65823 .30984 L
.64557 .3089 L
.6397 .31454 L
.63291 .32116 L
.6311 .32221 L
.62194 .32988 L
.62025 .33221 L
.61362 .33755 L
.60759 .34282 L
.6045 .34522 L
.59494 .35276 L
.59476 .3529 L
.58434 .36057 L
.58228 .36208 L
.57332 .36824 L
.56962 .37074 L
.56154 .37591 L
.55696 .37877 L
.54881 .38358 L
.5443 .38616 L
.53486 .39125 L
.53165 .39292 L
.51926 .39893 L
.51899 .39905 L
.50633 .40456 L
.50122 .4066 L
.49367 .40943 L
.48101 .41366 L
.47901 .41427 L
.46835 .41725 L
.4557 .42017 L
.44615 .42194 L
.44304 .42243 L
.43038 .42398 L
.41772 .42482 L
.40506 .4249 L
.39241 .42418 L
.37975 .4226 L
.37548 .42194 L
.36709 .4201 L
.35443 .41656 L
.34768 .41427 L
.34177 .41186 L
.33057 .4066 L
.32911 .4058 L
.31768 .39893 L
.31646 .39808 L
.30733 .39125 L
.3038 .38821 L
.2988 .38358 L
.29165 .37591 L
.29114 .3753 L
.28559 .36824 L
.28048 .36057 L
.27848 .35715 L
.27619 .3529 L
.27263 .34522 L
.26975 .33755 L
.26749 .32988 L
.26582 .32224 L
.26582 .32221 L
.26472 .31454 L
.26417 .30687 L
.26417 .29919 L
.26472 .29152 L
.26582 .28385 L
.26582 .28382 L
.26749 .27618 L
.26975 .26851 L
.27263 .26084 L
.27619 .25316 L
.27848 .24891 L
.28048 .24549 L
.28559 .23782 L
.29114 .23076 L
.29165 .23015 L
.2988 .22248 L
.3038 .21785 L
.30733 .21481 L
.31646 .20798 L
.31768 .20713 L
.32911 .20026 L
.33057 .19946 L
.34177 .1942 L
.34768 .19179 L
.35443 .1895 L
.36709 .18596 L
.37548 .18412 L
.37975 .18346 L
.39241 .18188 L
.40506 .18116 L
.41772 .18124 L
.43038 .18208 L
.44304 .18363 L
.44615 .18412 L
.4557 .18589 L
.46835 .18881 L
.47901 .19179 L
.48101 .1924 L
.49367 .19663 L
.50122 .19946 L
.50633 .2015 L
.51899 .20701 L
.51926 .20713 L
.53165 .21314 L
.53486 .21481 L
.5443 .2199 L
.54881 .22248 L
.55696 .22729 L
.56154 .23015 L
.56962 .23532 L
.57332 .23782 L
.58228 .24398 L
.58434 .24549 L
.59476 .25316 L
.59494 .2533 L
.6045 .26084 L
.60759 .26324 L
.61362 .26851 L
.62025 .27385 L
.62194 .27618 L
.6311 .28385 L
.63291 .2849 L
.6397 .29152 L
.64557 .29716 L
.65823 .29622 L
.66275 .29152 L
.66994 .28385 L
.67089 .28278 L
.67738 .27618 L
.68354 .2687 L
.68372 .26851 L
.69041 .26084 L
.6962 .25383 L
.69676 .25316 L
.70306 .24549 L
.70886 .2382 L
.70916 .23782 L
.71515 .23015 L
.72099 .22248 L
.72152 .22178 L
.72672 .21481 L
.73232 .20713 L
.73418 .20455 L
.73781 .19946 L
.74319 .19179 L
.74684 .1865 L
.74846 .18412 L
.75363 .17645 L
.75871 .16878 L
.75949 .16759 L
.7637 .1611 L
.76861 .15343 L
.77215 .1478 L
.77342 .14576 L
.77816 .13809 L
.78282 .13042 L
.78481 .1271 L
.7874 .12275 L
.79192 .11507 L
.79636 .1074 L
.79747 .10547 L
.80074 .09973 L
.80505 .09206 L
.8093 .08439 L
.81013 .08287 L
.81348 .07672 L
.81761 .06904 L
.82168 .06137 L
.82278 .05928 L
.8257 .0537 L
.82966 .04603 L
.83357 .03836 L
.83544 .03466 L
.83743 .03069 L
.84125 .02301 L
.84501 .01534 L
.8481 .00897 L
.84873 .00767 L
.8524 0 L
1 0 L
1 .60606 L
F
0 g
.5 Mabswid
.8524 .60606 m
.84873 .59839 L
.8481 .59709 L
.84501 .59072 L
.84125 .58305 L
.83743 .57537 L
.83544 .5714 L
.83357 .5677 L
.82966 .56003 L
.8257 .55236 L
.82278 .54678 L
.82168 .54469 L
.81761 .53702 L
.81348 .52934 L
.81013 .52319 L
.8093 .52167 L
.80505 .514 L
.80074 .50633 L
.79747 .50059 L
.79636 .49866 L
.79192 .49099 L
.7874 .48331 L
.78481 .47896 L
.78282 .47564 L
.77816 .46797 L
.77342 .4603 L
.77215 .45826 L
.76861 .45263 L
.7637 .44496 L
.75949 .43847 L
.75871 .43728 L
.75363 .42961 L
.74846 .42194 L
.74684 .41956 L
.74319 .41427 L
.73781 .4066 L
.73418 .40151 L
.73232 .39893 L
.72672 .39125 L
.72152 .38428 L
.72099 .38358 L
.71515 .37591 L
.70916 .36824 L
.70886 .36786 L
.70306 .36057 L
.69676 .3529 L
.6962 .35223 L
.69041 .34522 L
.68372 .33755 L
.68354 .33736 L
Mistroke
.67738 .32988 L
.67089 .32328 L
.66994 .32221 L
.66275 .31454 L
.65823 .30984 L
.64557 .3089 L
.6397 .31454 L
.63291 .32116 L
.6311 .32221 L
.62194 .32988 L
.62025 .33221 L
.61362 .33755 L
.60759 .34282 L
.6045 .34522 L
.59494 .35276 L
.59476 .3529 L
.58434 .36057 L
.58228 .36208 L
.57332 .36824 L
.56962 .37074 L
.56154 .37591 L
.55696 .37877 L
.54881 .38358 L
.5443 .38616 L
.53486 .39125 L
.53165 .39292 L
.51926 .39893 L
.51899 .39905 L
.50633 .40456 L
.50122 .4066 L
.49367 .40943 L
.48101 .41366 L
.47901 .41427 L
.46835 .41725 L
.4557 .42017 L
.44615 .42194 L
.44304 .42243 L
.43038 .42398 L
.41772 .42482 L
.40506 .4249 L
.39241 .42418 L
.37975 .4226 L
.37548 .42194 L
.36709 .4201 L
.35443 .41656 L
.34768 .41427 L
.34177 .41186 L
.33057 .4066 L
.32911 .4058 L
.31768 .39893 L
Mistroke
.31646 .39808 L
.30733 .39125 L
.3038 .38821 L
.2988 .38358 L
.29165 .37591 L
.29114 .3753 L
.28559 .36824 L
.28048 .36057 L
.27848 .35715 L
.27619 .3529 L
.27263 .34522 L
.26975 .33755 L
.26749 .32988 L
.26582 .32224 L
.26582 .32221 L
.26472 .31454 L
.26417 .30687 L
.26417 .29919 L
.26472 .29152 L
.26582 .28385 L
.26582 .28382 L
.26749 .27618 L
.26975 .26851 L
.27263 .26084 L
.27619 .25316 L
.27848 .24891 L
.28048 .24549 L
.28559 .23782 L
.29114 .23076 L
.29165 .23015 L
.2988 .22248 L
.3038 .21785 L
.30733 .21481 L
.31646 .20798 L
.31768 .20713 L
.32911 .20026 L
.33057 .19946 L
.34177 .1942 L
.34768 .19179 L
.35443 .1895 L
.36709 .18596 L
.37548 .18412 L
.37975 .18346 L
.39241 .18188 L
.40506 .18116 L
.41772 .18124 L
.43038 .18208 L
.44304 .18363 L
.44615 .18412 L
.4557 .18589 L
Mistroke
.46835 .18881 L
.47901 .19179 L
.48101 .1924 L
.49367 .19663 L
.50122 .19946 L
.50633 .2015 L
.51899 .20701 L
.51926 .20713 L
.53165 .21314 L
.53486 .21481 L
.5443 .2199 L
.54881 .22248 L
.55696 .22729 L
.56154 .23015 L
.56962 .23532 L
.57332 .23782 L
.58228 .24398 L
.58434 .24549 L
.59476 .25316 L
.59494 .2533 L
.6045 .26084 L
.60759 .26324 L
.61362 .26851 L
.62025 .27385 L
.62194 .27618 L
.6311 .28385 L
.63291 .2849 L
.6397 .29152 L
.64557 .29716 L
.65823 .29622 L
.66275 .29152 L
.66994 .28385 L
.67089 .28278 L
.67738 .27618 L
.68354 .2687 L
.68372 .26851 L
.69041 .26084 L
.6962 .25383 L
.69676 .25316 L
.70306 .24549 L
.70886 .2382 L
.70916 .23782 L
.71515 .23015 L
.72099 .22248 L
.72152 .22178 L
.72672 .21481 L
.73232 .20713 L
.73418 .20455 L
.73781 .19946 L
.74319 .19179 L
Mistroke
.74684 .1865 L
.74846 .18412 L
.75363 .17645 L
.75871 .16878 L
.75949 .16759 L
.7637 .1611 L
.76861 .15343 L
.77215 .1478 L
.77342 .14576 L
.77816 .13809 L
.78282 .13042 L
.78481 .1271 L
.7874 .12275 L
.79192 .11507 L
.79636 .1074 L
.79747 .10547 L
.80074 .09973 L
.80505 .09206 L
.8093 .08439 L
.81013 .08287 L
.81348 .07672 L
.81761 .06904 L
.82168 .06137 L
.82278 .05928 L
.8257 .0537 L
.82966 .04603 L
.83357 .03836 L
.83544 .03466 L
.83743 .03069 L
.84125 .02301 L
.84501 .01534 L
.8481 .00897 L
.84873 .00767 L
.8524 0 L
Mfstroke
1 g
.58636 .33333 m
.68636 .33333 L
.68636 .27273 L
.58636 .27273 L
F
.5 g
.68 .27273 m
.67867 .27423 L
.67862 .27428 L
.67723 .27584 L
.67611 .27709 L
.67584 .27739 L
.67443 .27894 L
.67354 .27992 L
.67302 .2805 L
.6716 .28205 L
.67098 .28272 L
.67017 .28361 L
.66873 .28516 L
.66841 .2855 L
.66728 .28671 L
.66585 .28824 L
.66582 .28827 L
.66436 .28982 L
.66329 .29095 L
.66289 .29138 L
.66141 .29293 L
.66072 .29363 L
.65993 .29448 L
.65841 .29604 L
.65816 .29628 L
.65701 .29759 L
.65559 .2989 L
.65537 .29915 L
.65383 .3007 L
.65303 .30151 L
.65047 .30198 L
.64917 .3007 L
.6479 .29938 L
.64753 .29915 L
.64584 .29759 L
.64534 .29693 L
.64437 .29604 L
.6428 .29448 L
.64277 .29446 L
.64116 .29293 L
.64021 .292 L
.63954 .29138 L
.6379 .28982 L
.63765 .28958 L
.63624 .28827 L
.63508 .28719 L
.63457 .28671 L
.63289 .28516 L
.63252 .28482 L
.63119 .28361 L
.62995 .28248 L
.62948 .28205 L
.62775 .2805 L
.62739 .28017 L
.62602 .27894 L
.62483 .27789 L
.62426 .27739 L
.6225 .27584 L
.62226 .27563 L
.62071 .27428 L
.6197 .2734 L
.61891 .27273 L
F
0 g
.68 .27273 m
.67867 .27423 L
.67862 .27428 L
.67723 .27584 L
.67611 .27709 L
.67584 .27739 L
.67443 .27894 L
.67354 .27992 L
.67302 .2805 L
.6716 .28205 L
.67098 .28272 L
.67017 .28361 L
.66873 .28516 L
.66841 .2855 L
.66728 .28671 L
.66585 .28824 L
.66582 .28827 L
.66436 .28982 L
.66329 .29095 L
.66289 .29138 L
.66141 .29293 L
.66072 .29363 L
.65993 .29448 L
.65841 .29604 L
.65816 .29628 L
.65701 .29759 L
.65559 .2989 L
.65537 .29915 L
.65383 .3007 L
.65303 .30151 L
.65047 .30198 L
.64917 .3007 L
.6479 .29938 L
.64753 .29915 L
.64584 .29759 L
.64534 .29693 L
.64437 .29604 L
.6428 .29448 L
.64277 .29446 L
.64116 .29293 L
.64021 .292 L
.63954 .29138 L
.6379 .28982 L
.63765 .28958 L
.63624 .28827 L
.63508 .28719 L
.63457 .28671 L
.63289 .28516 L
.63252 .28482 L
.63119 .28361 L
Mistroke
.62995 .28248 L
.62948 .28205 L
.62775 .2805 L
.62739 .28017 L
.62602 .27894 L
.62483 .27789 L
.62426 .27739 L
.6225 .27584 L
.62226 .27563 L
.62071 .27428 L
.6197 .2734 L
.61891 .27273 L
Mfstroke
.5 g
.68 .33333 m
.67867 .33183 L
.67862 .33178 L
.67723 .33023 L
.67611 .32897 L
.67584 .32867 L
.67443 .32712 L
.67354 .32614 L
.67302 .32556 L
.6716 .32401 L
.67098 .32334 L
.67017 .32246 L
.66873 .3209 L
.66841 .32056 L
.66728 .31935 L
.66585 .31782 L
.66582 .31779 L
.66436 .31624 L
.66329 .31511 L
.66289 .31469 L
.66141 .31313 L
.66072 .31243 L
.65993 .31158 L
.65841 .31002 L
.65816 .30978 L
.65701 .30847 L
.65559 .30716 L
.65537 .30692 L
.65383 .30536 L
.65303 .30455 L
.65047 .30408 L
.64917 .30536 L
.6479 .30668 L
.64753 .30692 L
.64584 .30847 L
.64534 .30913 L
.64437 .31002 L
.6428 .31158 L
.64277 .3116 L
.64116 .31313 L
.64021 .31406 L
.63954 .31469 L
.6379 .31624 L
.63765 .31648 L
.63624 .31779 L
.63508 .31888 L
.63457 .31935 L
.63289 .3209 L
.63252 .32124 L
.63119 .32246 L
.62995 .32358 L
.62948 .32401 L
.62775 .32556 L
.62739 .32589 L
.62602 .32712 L
.62483 .32818 L
.62426 .32867 L
.6225 .33023 L
.62226 .33043 L
.62071 .33178 L
.6197 .33266 L
.61891 .33333 L
F
0 g
.68 .33333 m
.67867 .33183 L
.67862 .33178 L
.67723 .33023 L
.67611 .32897 L
.67584 .32867 L
.67443 .32712 L
.67354 .32614 L
.67302 .32556 L
.6716 .32401 L
.67098 .32334 L
.67017 .32246 L
.66873 .3209 L
.66841 .32056 L
.66728 .31935 L
.66585 .31782 L
.66582 .31779 L
.66436 .31624 L
.66329 .31511 L
.66289 .31469 L
.66141 .31313 L
.66072 .31243 L
.65993 .31158 L
.65841 .31002 L
.65816 .30978 L
.65701 .30847 L
.65559 .30716 L
.65537 .30692 L
.65383 .30536 L
.65303 .30455 L
.65047 .30408 L
.64917 .30536 L
.6479 .30668 L
.64753 .30692 L
.64584 .30847 L
.64534 .30913 L
.64437 .31002 L
.6428 .31158 L
.64277 .3116 L
.64116 .31313 L
.64021 .31406 L
.63954 .31469 L
.6379 .31624 L
.63765 .31648 L
.63624 .31779 L
.63508 .31888 L
.63457 .31935 L
.63289 .3209 L
.63252 .32124 L
.63119 .32246 L
Mistroke
.62995 .32358 L
.62948 .32401 L
.62775 .32556 L
.62739 .32589 L
.62602 .32712 L
.62483 .32818 L
.62426 .32867 L
.6225 .33023 L
.62226 .33043 L
.62071 .33178 L
.6197 .33266 L
.61891 .33333 L
Mfstroke
1 g
.65152 .30303 m
.65152 .30303 .01 0 365.73 arc
F
.33848 .29303 m
.35848 .29303 L
.35848 .31303 L
.33848 .31303 L
.33848 .29303 L
F
0 g
.003 w
newpath
.65152 .30303 .01 0 365.73 arc
s
.33848 .29303 m
.35848 .29303 L
.35848 .31303 L
.33848 .31303 L
.33848 .29303 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.606061 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.651515 0.30303 0.30303 0.30303 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .60606 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .60606 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .60606 L
s
0 .60606 m
1 .60606 L
s
1 0 m
1 .60606 L
s
0 .30303 m
1 .30303 L
s
.65152 0 m
.65152 .60606 L
s
0 0 m
1 0 L
1 .60606 L
0 .60606 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.91.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.91.1"]
}, Open  ]],

Cell[TextData[{
 "In addition to ",
 StyleBox["True", "MR"],
 " and ",
 StyleBox["False", "MR"],
 ", the options ",
 StyleBox["OrderStarInterpolation", "MR"],
 ", ",
 StyleBox["OrderStarLegend", "MR"],
 ", ",
 StyleBox["OrderStarPoles", "MR"],
 ", and ",
 StyleBox["OrderStarZeros", "MR"],
 " can take on lists of coordinate pairs to specify points that cannot be \
found automatically. As well as resizing the plot legend by specifying scaled \
coordinates, you can specify information to the legend such as the style and \
size of the font to use. "
}], "Text",
 CellTags->{"S5.91.1", "1.18"}],

Cell[TextData[{
 "The position of the legend is given in scaled coordinates using the same \
syntax as that of ",
 StyleBox["Rectangle", "MR"],
 ". Font style and size information is also specified and the symbols used to \
represent zeros and poles are increased in size. "
}], "MathCaption",
 CellTags->{"S5.91.1", "1.19"}],

Cell[CellGroupData[{

Cell["\<\
OrderStar[ Pade[ Sinh[z-1], {z, 0, 3, 3}], Sinh[z-1],
         OrderStarLegend -> {{.6, .6}, {.98, .98}},
         TextStyle -> {\"FontSize\" -> 6},
         OrderStarSymbolSize -> 0.02 ]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.91.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .73114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.731144 [
[ 0 0 0 0 ]
[ 1 .73114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .73114 L
0 .73114 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.731144 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.504054 0.073011 0.365572 0.073011 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .73114 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .73114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .73114 L
s
0 .73114 m
1 .73114 L
s
1 0 m
1 .73114 L
s
0 .36557 m
1 .36557 L
s
.50405 0 m
.50405 .73114 L
s
0 0 m
1 0 L
1 .73114 L
0 .73114 L
closepath
clip
newpath
1 g
0 .73114 m
1 .73114 L
1 0 L
0 0 L
F
.5 g
.3754 .73114 m
.37672 .72189 L
.3781 .71263 L
.37953 .70338 L
.37975 .70203 L
.38101 .69412 L
.38254 .68487 L
.38412 .67561 L
.38573 .66636 L
.3874 .6571 L
.38911 .64785 L
.39088 .63859 L
.39241 .63079 L
.39269 .62934 L
.39457 .62008 L
.3965 .61083 L
.39851 .60157 L
.4006 .59232 L
.40277 .58306 L
.40504 .57381 L
.40506 .57373 L
.40739 .56455 L
.40984 .5553 L
.41242 .54604 L
.41514 .53679 L
.41772 .52849 L
.41799 .52753 L
.42081 .51828 L
.42385 .50902 L
.42714 .49977 L
.43038 .49127 L
.43054 .49051 L
.43335 .48126 L
.43705 .472 L
.44127 .46275 L
.44304 .45904 L
.44541 .45349 L
.44951 .44424 L
.45271 .43498 L
.4557 .43062 L
.45812 .42573 L
.463 .41647 L
.46784 .40722 L
.46835 .40627 L
.47437 .39796 L
.48059 .38871 L
.48101 .388 L
.49174 .37945 L
.48101 .37115 L
.46835 .37561 L
.46 .37945 L
.4557 .38205 L
.4473 .38871 L
.44304 .39281 L
.43784 .39796 L
.43038 .40536 L
.42845 .40722 L
.41866 .41647 L
.41772 .41762 L
.40856 .42573 L
.40506 .4296 L
.39828 .43498 L
.39241 .4409 L
.38785 .44424 L
.37975 .45178 L
.37674 .45349 L
.36709 .46243 L
.36657 .46275 L
.35503 .472 L
.35443 .47319 L
.34393 .48126 L
.34177 .48374 L
.3327 .49051 L
.32911 .49391 L
.321 .49977 L
.31646 .50362 L
.30866 .50902 L
.3038 .51279 L
.29542 .51828 L
.29114 .52132 L
.28093 .52753 L
.27848 .5291 L
.26582 .53607 L
.26435 .53679 L
.25316 .5421 L
.24332 .54604 L
.24051 .5471 L
.22785 .55095 L
.21519 .55355 L
.20253 .55472 L
.18987 .55425 L
.17722 .55177 L
.16456 .54674 L
.16316 .54604 L
.1519 .5376 L
.15107 .53679 L
.14399 .52753 L
.13958 .51828 L
.13924 .51729 L
.13765 .50902 L
.13741 .49977 L
.13878 .49051 L
.13924 .48857 L
.14216 .48126 L
.14748 .472 L
.1519 .46636 L
.15505 .46275 L
.16456 .45456 L
.16574 .45349 L
.17722 .44623 L
.18024 .44424 L
.18987 .43979 L
.20123 .43498 L
.20253 .43454 L
.21519 .43012 L
.22785 .42622 L
.22898 .42573 L
.24051 .42272 L
.25316 .41946 L
.2652 .41647 L
.26582 .41634 L
.27848 .41334 L
.29114 .41037 L
.3038 .40739 L
.3045 .40722 L
.31646 .40444 L
.32911 .40143 L
.34177 .39835 L
.34331 .39796 L
.35443 .39531 L
.36709 .39213 L
.37975 .38878 L
.37998 .38871 L
.39241 .3857 L
.40506 .38178 L
.41078 .37945 L
.41772 .37684 L
.42738 .3702 L
.42738 .36094 L
.41772 .35431 L
.41078 .35169 L
.40506 .34936 L
.39241 .34544 L
.37998 .34243 L
.37975 .34237 L
.36709 .33901 L
.35443 .33583 L
.34331 .33318 L
.34177 .3328 L
.32911 .32972 L
.31646 .32671 L
.3045 .32392 L
.3038 .32376 L
.29114 .32078 L
.27848 .3178 L
.26582 .3148 L
.2652 .31467 L
.25316 .31168 L
.24051 .30842 L
.22898 .30541 L
.22785 .30492 L
.21519 .30103 L
.20253 .29661 L
.20123 .29616 L
.18987 .29135 L
.18024 .2869 L
.17722 .28491 L
.16574 .27765 L
.16456 .27658 L
.15505 .26839 L
.1519 .26478 L
.14748 .25914 L
.14216 .24988 L
.13924 .24258 L
.13878 .24063 L
.13741 .23137 L
.13765 .22212 L
.13924 .21385 L
.13958 .21286 L
.14399 .20361 L
.15107 .19435 L
.1519 .19354 L
.16316 .1851 L
.16456 .1844 L
.17722 .17937 L
.18987 .17689 L
.20253 .17642 L
.21519 .1776 L
.22785 .18019 L
.24051 .18405 L
.24332 .1851 L
.25316 .18904 L
.26435 .19435 L
.26582 .19508 L
.27848 .20204 L
.28093 .20361 L
.29114 .20983 L
.29542 .21286 L
.3038 .21836 L
.30866 .22212 L
.31646 .22752 L
.321 .23137 L
.32911 .23724 L
.3327 .24063 L
.34177 .2474 L
.34393 .24988 L
.35443 .25795 L
.35503 .25914 L
.36657 .26839 L
.36709 .26871 L
.37674 .27765 L
.37975 .27936 L
.38785 .2869 L
.39241 .29024 L
.39828 .29616 L
.40506 .30154 L
.40856 .30541 L
.41772 .31353 L
.41866 .31467 L
.42845 .32392 L
.43038 .32578 L
.43784 .33318 L
.44304 .33834 L
.4473 .34243 L
.4557 .3491 L
.46 .35169 L
.46835 .35553 L
.48101 .36 L
.48242 .36094 L
.48242 .3702 L
.49367 .37303 L
.50633 .3702 L
.50633 .36094 L
.49367 .35811 L
.49174 .35169 L
.48101 .34315 L
.48059 .34243 L
.47437 .33318 L
.46835 .32487 L
.46784 .32392 L
.463 .31467 L
.45812 .30541 L
.4557 .30052 L
.45271 .29616 L
.44951 .2869 L
.44541 .27765 L
.44304 .2721 L
.44127 .26839 L
.43705 .25914 L
.43335 .24988 L
.43054 .24063 L
.43038 .23988 L
.42714 .23137 L
.42385 .22212 L
.42081 .21286 L
.41799 .20361 L
.41772 .20265 L
.41514 .19435 L
.41242 .1851 L
.40984 .17584 L
.40739 .16659 L
.40506 .15742 L
.40504 .15733 L
.40277 .14808 L
.4006 .13882 L
.39851 .12957 L
.3965 .12031 L
.39457 .11106 L
.39269 .1018 L
.39241 .10035 L
.39088 .09255 L
.38911 .08329 L
.3874 .07404 L
.38573 .06478 L
.38412 .05553 L
.38254 .04627 L
.38101 .03702 L
.37975 .02911 L
.37953 .02776 L
.3781 .01851 L
.37672 .00925 L
.3754 0 L
1 0 L
1 .73114 L
F
0 g
.5 Mabswid
.3754 .73114 m
.37672 .72189 L
.3781 .71263 L
.37953 .70338 L
.37975 .70203 L
.38101 .69412 L
.38254 .68487 L
.38412 .67561 L
.38573 .66636 L
.3874 .6571 L
.38911 .64785 L
.39088 .63859 L
.39241 .63079 L
.39269 .62934 L
.39457 .62008 L
.3965 .61083 L
.39851 .60157 L
.4006 .59232 L
.40277 .58306 L
.40504 .57381 L
.40506 .57373 L
.40739 .56455 L
.40984 .5553 L
.41242 .54604 L
.41514 .53679 L
.41772 .52849 L
.41799 .52753 L
.42081 .51828 L
.42385 .50902 L
.42714 .49977 L
.43038 .49127 L
.43054 .49051 L
.43335 .48126 L
.43705 .472 L
.44127 .46275 L
.44304 .45904 L
.44541 .45349 L
.44951 .44424 L
.45271 .43498 L
.4557 .43062 L
.45812 .42573 L
.463 .41647 L
.46784 .40722 L
.46835 .40627 L
.47437 .39796 L
.48059 .38871 L
.48101 .388 L
.49174 .37945 L
.48101 .37115 L
.46835 .37561 L
Mistroke
.46 .37945 L
.4557 .38205 L
.4473 .38871 L
.44304 .39281 L
.43784 .39796 L
.43038 .40536 L
.42845 .40722 L
.41866 .41647 L
.41772 .41762 L
.40856 .42573 L
.40506 .4296 L
.39828 .43498 L
.39241 .4409 L
.38785 .44424 L
.37975 .45178 L
.37674 .45349 L
.36709 .46243 L
.36657 .46275 L
.35503 .472 L
.35443 .47319 L
.34393 .48126 L
.34177 .48374 L
.3327 .49051 L
.32911 .49391 L
.321 .49977 L
.31646 .50362 L
.30866 .50902 L
.3038 .51279 L
.29542 .51828 L
.29114 .52132 L
.28093 .52753 L
.27848 .5291 L
.26582 .53607 L
.26435 .53679 L
.25316 .5421 L
.24332 .54604 L
.24051 .5471 L
.22785 .55095 L
.21519 .55355 L
.20253 .55472 L
.18987 .55425 L
.17722 .55177 L
.16456 .54674 L
.16316 .54604 L
.1519 .5376 L
.15107 .53679 L
.14399 .52753 L
.13958 .51828 L
.13924 .51729 L
.13765 .50902 L
Mistroke
.13741 .49977 L
.13878 .49051 L
.13924 .48857 L
.14216 .48126 L
.14748 .472 L
.1519 .46636 L
.15505 .46275 L
.16456 .45456 L
.16574 .45349 L
.17722 .44623 L
.18024 .44424 L
.18987 .43979 L
.20123 .43498 L
.20253 .43454 L
.21519 .43012 L
.22785 .42622 L
.22898 .42573 L
.24051 .42272 L
.25316 .41946 L
.2652 .41647 L
.26582 .41634 L
.27848 .41334 L
.29114 .41037 L
.3038 .40739 L
.3045 .40722 L
.31646 .40444 L
.32911 .40143 L
.34177 .39835 L
.34331 .39796 L
.35443 .39531 L
.36709 .39213 L
.37975 .38878 L
.37998 .38871 L
.39241 .3857 L
.40506 .38178 L
.41078 .37945 L
.41772 .37684 L
.42738 .3702 L
.42738 .36094 L
.41772 .35431 L
.41078 .35169 L
.40506 .34936 L
.39241 .34544 L
.37998 .34243 L
.37975 .34237 L
.36709 .33901 L
.35443 .33583 L
.34331 .33318 L
.34177 .3328 L
.32911 .32972 L
Mistroke
.31646 .32671 L
.3045 .32392 L
.3038 .32376 L
.29114 .32078 L
.27848 .3178 L
.26582 .3148 L
.2652 .31467 L
.25316 .31168 L
.24051 .30842 L
.22898 .30541 L
.22785 .30492 L
.21519 .30103 L
.20253 .29661 L
.20123 .29616 L
.18987 .29135 L
.18024 .2869 L
.17722 .28491 L
.16574 .27765 L
.16456 .27658 L
.15505 .26839 L
.1519 .26478 L
.14748 .25914 L
.14216 .24988 L
.13924 .24258 L
.13878 .24063 L
.13741 .23137 L
.13765 .22212 L
.13924 .21385 L
.13958 .21286 L
.14399 .20361 L
.15107 .19435 L
.1519 .19354 L
.16316 .1851 L
.16456 .1844 L
.17722 .17937 L
.18987 .17689 L
.20253 .17642 L
.21519 .1776 L
.22785 .18019 L
.24051 .18405 L
.24332 .1851 L
.25316 .18904 L
.26435 .19435 L
.26582 .19508 L
.27848 .20204 L
.28093 .20361 L
.29114 .20983 L
.29542 .21286 L
.3038 .21836 L
.30866 .22212 L
Mistroke
.31646 .22752 L
.321 .23137 L
.32911 .23724 L
.3327 .24063 L
.34177 .2474 L
.34393 .24988 L
.35443 .25795 L
.35503 .25914 L
.36657 .26839 L
.36709 .26871 L
.37674 .27765 L
.37975 .27936 L
.38785 .2869 L
.39241 .29024 L
.39828 .29616 L
.40506 .30154 L
.40856 .30541 L
.41772 .31353 L
.41866 .31467 L
.42845 .32392 L
.43038 .32578 L
.43784 .33318 L
.44304 .33834 L
.4473 .34243 L
.4557 .3491 L
.46 .35169 L
.46835 .35553 L
.48101 .36 L
.48242 .36094 L
.48242 .3702 L
.49367 .37303 L
.50633 .3702 L
.50633 .36094 L
.49367 .35811 L
.49174 .35169 L
.48101 .34315 L
.48059 .34243 L
.47437 .33318 L
.46835 .32487 L
.46784 .32392 L
.463 .31467 L
.45812 .30541 L
.4557 .30052 L
.45271 .29616 L
.44951 .2869 L
.44541 .27765 L
.44304 .2721 L
.44127 .26839 L
.43705 .25914 L
.43335 .24988 L
Mistroke
.43054 .24063 L
.43038 .23988 L
.42714 .23137 L
.42385 .22212 L
.42081 .21286 L
.41799 .20361 L
.41772 .20265 L
.41514 .19435 L
.41242 .1851 L
.40984 .17584 L
.40739 .16659 L
.40506 .15742 L
.40504 .15733 L
.40277 .14808 L
.4006 .13882 L
.39851 .12957 L
.3965 .12031 L
.39457 .11106 L
.39269 .1018 L
.39241 .10035 L
.39088 .09255 L
.38911 .08329 L
.3874 .07404 L
.38573 .06478 L
.38412 .05553 L
.38254 .04627 L
.38101 .03702 L
.37975 .02911 L
.37953 .02776 L
.3781 .01851 L
.37672 .00925 L
.3754 0 L
Mfstroke
1 g
.72277 .73114 m
.72152 .72731 L
.71971 .72189 L
.71654 .71263 L
.7133 .70338 L
.71001 .69412 L
.70886 .69091 L
.7067 .68487 L
.70339 .67561 L
.70011 .66636 L
.69691 .6571 L
.6962 .65504 L
.69379 .64785 L
.69077 .63859 L
.68786 .62934 L
.68504 .62008 L
.68354 .61511 L
.68227 .61083 L
.6795 .60157 L
.67667 .59232 L
.67371 .58306 L
.67089 .57478 L
.67054 .57381 L
.66709 .56455 L
.6633 .5553 L
.65908 .54604 L
.65823 .54431 L
.65443 .53679 L
.64924 .52753 L
.64557 .52167 L
.64354 .51828 L
.63722 .50902 L
.63291 .50353 L
.63049 .49977 L
.62262 .49051 L
.62025 .48819 L
.61508 .48126 L
.60759 .47459 L
.60516 .472 L
.59571 .46275 L
.59494 .46234 L
.58537 .45349 L
.58228 .45151 L
.57472 .44424 L
.56962 .44112 L
.56384 .43498 L
.55696 .42913 L
.55309 .42573 L
.5443 .41786 L
.54286 .41647 L
.53353 .40722 L
.53165 .40527 L
.52488 .39796 L
.51899 .39016 L
.51768 .38871 L
.50643 .37945 L
.51899 .37158 L
.52878 .37945 L
.53165 .38307 L
.54224 .38871 L
.5443 .39012 L
.55696 .39468 L
.56962 .39742 L
.57425 .39796 L
.58228 .39864 L
.59494 .39939 L
.60759 .40059 L
.62025 .40246 L
.63291 .40484 L
.64425 .40722 L
.64557 .40752 L
.65823 .41043 L
.67089 .41342 L
.68354 .4164 L
.6839 .41647 L
.6962 .41933 L
.70886 .4221 L
.72152 .42462 L
.72783 .42573 L
.73418 .42682 L
.74684 .42858 L
.75949 .42981 L
.77215 .43037 L
.78481 .43011 L
.79747 .42887 L
.81013 .42642 L
.81328 .42573 L
.82278 .42238 L
.83517 .41647 L
.83544 .41625 L
.8477 .40722 L
.8481 .40682 L
.85597 .39796 L
.86076 .39031 L
.86152 .38871 L
.8648 .37945 L
.86638 .3702 L
.86638 .36094 L
.8648 .35169 L
.86152 .34243 L
.86076 .34083 L
.85597 .33318 L
.8481 .32433 L
.8477 .32392 L
.83544 .31489 L
.83517 .31467 L
.82278 .30877 L
.81328 .30541 L
.81013 .30473 L
.79747 .30227 L
.78481 .30103 L
.77215 .30078 L
.75949 .30134 L
.74684 .30256 L
.73418 .30433 L
.72783 .30541 L
.72152 .30652 L
.70886 .30905 L
.6962 .31182 L
.6839 .31467 L
.68354 .31474 L
.67089 .31773 L
.65823 .32072 L
.64557 .32363 L
.64425 .32392 L
.63291 .32631 L
.62025 .32868 L
.60759 .33056 L
.59494 .33175 L
.58228 .3325 L
.57425 .33318 L
.56962 .33372 L
.55696 .33646 L
.5443 .34103 L
.54224 .34243 L
.53165 .34807 L
.52878 .35169 L
.53165 .36004 L
.5443 .35817 L
.55696 .35688 L
.56962 .35675 L
.57107 .36094 L
.57107 .3702 L
.56962 .3744 L
.55696 .37427 L
.5443 .37297 L
.53165 .3711 L
.53075 .3702 L
.53075 .36094 L
.51899 .35956 L
.50643 .35169 L
.51768 .34243 L
.50633 .33703 L
.49367 .33465 L
.49324 .33318 L
.49161 .32392 L
.49037 .31467 L
.49042 .30541 L
.48907 .29616 L
.48868 .2869 L
.48856 .27765 L
.48863 .26839 L
.48886 .25914 L
.48928 .24988 L
.48988 .24063 L
.49067 .23137 L
.49167 .22212 L
.49289 .21286 L
.49367 .20756 L
.49441 .20361 L
.49641 .19435 L
.49886 .1851 L
.50181 .17584 L
.50523 .16659 L
.50633 .16321 L
.50961 .15733 L
.5153 .14808 L
.51899 .14202 L
.52255 .13882 L
.53165 .13048 L
.53358 .12957 L
.5443 .1249 L
.55696 .12532 L
.56184 .12957 L
.56962 .1348 L
.57119 .13882 L
.57342 .14808 L
.57378 .15733 L
.57233 .16659 L
.57008 .17584 L
.56962 .17742 L
.56888 .1851 L
.56531 .19435 L
.56121 .20361 L
.55699 .21286 L
.55696 .21293 L
.5543 .22212 L
.54963 .23137 L
.54479 .24063 L
.5443 .24156 L
.54044 .24988 L
.53751 .25914 L
.53216 .26839 L
.53165 .26933 L
.52786 .27765 L
.52382 .2869 L
.52079 .29616 L
.51899 .29905 L
.51642 .30541 L
.51276 .31467 L
.50962 .32392 L
.50747 .33318 L
.51899 .34098 L
.52488 .33318 L
.53165 .32587 L
.53353 .32392 L
.54286 .31467 L
.5443 .31328 L
.55309 .30541 L
.55696 .30201 L
.56384 .29616 L
.56962 .29002 L
.57472 .2869 L
.58228 .27963 L
.58537 .27765 L
.59494 .26881 L
.59571 .26839 L
.60516 .25914 L
.60759 .25655 L
.61508 .24988 L
.62025 .24295 L
.62262 .24063 L
.63049 .23137 L
.63291 .22762 L
.63722 .22212 L
.64354 .21286 L
.64557 .20948 L
.64924 .20361 L
.65443 .19435 L
.65823 .18683 L
.65908 .1851 L
.6633 .17584 L
.66709 .16659 L
.67054 .15733 L
.67089 .15637 L
.67371 .14808 L
.67667 .13882 L
.6795 .12957 L
.68227 .12031 L
.68354 .11603 L
.68504 .11106 L
.68786 .1018 L
.69077 .09255 L
.69379 .08329 L
.6962 .0761 L
.69691 .07404 L
.70011 .06478 L
.70339 .05553 L
.7067 .04627 L
.70886 .04024 L
.71001 .03702 L
.7133 .02776 L
.71654 .01851 L
.71971 .00925 L
.72152 .00383 L
.72277 0 L
1 0 L
1 .73114 L
F
0 g
.72277 .73114 m
.72152 .72731 L
.71971 .72189 L
.71654 .71263 L
.7133 .70338 L
.71001 .69412 L
.70886 .69091 L
.7067 .68487 L
.70339 .67561 L
.70011 .66636 L
.69691 .6571 L
.6962 .65504 L
.69379 .64785 L
.69077 .63859 L
.68786 .62934 L
.68504 .62008 L
.68354 .61511 L
.68227 .61083 L
.6795 .60157 L
.67667 .59232 L
.67371 .58306 L
.67089 .57478 L
.67054 .57381 L
.66709 .56455 L
.6633 .5553 L
.65908 .54604 L
.65823 .54431 L
.65443 .53679 L
.64924 .52753 L
.64557 .52167 L
.64354 .51828 L
.63722 .50902 L
.63291 .50353 L
.63049 .49977 L
.62262 .49051 L
.62025 .48819 L
.61508 .48126 L
.60759 .47459 L
.60516 .472 L
.59571 .46275 L
.59494 .46234 L
.58537 .45349 L
.58228 .45151 L
.57472 .44424 L
.56962 .44112 L
.56384 .43498 L
.55696 .42913 L
.55309 .42573 L
.5443 .41786 L
.54286 .41647 L
Mistroke
.53353 .40722 L
.53165 .40527 L
.52488 .39796 L
.51899 .39016 L
.51768 .38871 L
.50643 .37945 L
.51899 .37158 L
.52878 .37945 L
.53165 .38307 L
.54224 .38871 L
.5443 .39012 L
.55696 .39468 L
.56962 .39742 L
.57425 .39796 L
.58228 .39864 L
.59494 .39939 L
.60759 .40059 L
.62025 .40246 L
.63291 .40484 L
.64425 .40722 L
.64557 .40752 L
.65823 .41043 L
.67089 .41342 L
.68354 .4164 L
.6839 .41647 L
.6962 .41933 L
.70886 .4221 L
.72152 .42462 L
.72783 .42573 L
.73418 .42682 L
.74684 .42858 L
.75949 .42981 L
.77215 .43037 L
.78481 .43011 L
.79747 .42887 L
.81013 .42642 L
.81328 .42573 L
.82278 .42238 L
.83517 .41647 L
.83544 .41625 L
.8477 .40722 L
.8481 .40682 L
.85597 .39796 L
.86076 .39031 L
.86152 .38871 L
.8648 .37945 L
.86638 .3702 L
.86638 .36094 L
.8648 .35169 L
.86152 .34243 L
Mistroke
.86076 .34083 L
.85597 .33318 L
.8481 .32433 L
.8477 .32392 L
.83544 .31489 L
.83517 .31467 L
.82278 .30877 L
.81328 .30541 L
.81013 .30473 L
.79747 .30227 L
.78481 .30103 L
.77215 .30078 L
.75949 .30134 L
.74684 .30256 L
.73418 .30433 L
.72783 .30541 L
.72152 .30652 L
.70886 .30905 L
.6962 .31182 L
.6839 .31467 L
.68354 .31474 L
.67089 .31773 L
.65823 .32072 L
.64557 .32363 L
.64425 .32392 L
.63291 .32631 L
.62025 .32868 L
.60759 .33056 L
.59494 .33175 L
.58228 .3325 L
.57425 .33318 L
.56962 .33372 L
.55696 .33646 L
.5443 .34103 L
.54224 .34243 L
.53165 .34807 L
.52878 .35169 L
.53165 .36004 L
.5443 .35817 L
.55696 .35688 L
.56962 .35675 L
.57107 .36094 L
.57107 .3702 L
.56962 .3744 L
.55696 .37427 L
.5443 .37297 L
.53165 .3711 L
.53075 .3702 L
.53075 .36094 L
.51899 .35956 L
Mistroke
.50643 .35169 L
.51768 .34243 L
.50633 .33703 L
.49367 .33465 L
.49324 .33318 L
.49161 .32392 L
.49037 .31467 L
.49042 .30541 L
.48907 .29616 L
.48868 .2869 L
.48856 .27765 L
.48863 .26839 L
.48886 .25914 L
.48928 .24988 L
.48988 .24063 L
.49067 .23137 L
.49167 .22212 L
.49289 .21286 L
.49367 .20756 L
.49441 .20361 L
.49641 .19435 L
.49886 .1851 L
.50181 .17584 L
.50523 .16659 L
.50633 .16321 L
.50961 .15733 L
.5153 .14808 L
.51899 .14202 L
.52255 .13882 L
.53165 .13048 L
.53358 .12957 L
.5443 .1249 L
.55696 .12532 L
.56184 .12957 L
.56962 .1348 L
.57119 .13882 L
.57342 .14808 L
.57378 .15733 L
.57233 .16659 L
.57008 .17584 L
.56962 .17742 L
.56888 .1851 L
.56531 .19435 L
.56121 .20361 L
.55699 .21286 L
.55696 .21293 L
.5543 .22212 L
.54963 .23137 L
.54479 .24063 L
.5443 .24156 L
Mistroke
.54044 .24988 L
.53751 .25914 L
.53216 .26839 L
.53165 .26933 L
.52786 .27765 L
.52382 .2869 L
.52079 .29616 L
.51899 .29905 L
.51642 .30541 L
.51276 .31467 L
.50962 .32392 L
.50747 .33318 L
.51899 .34098 L
.52488 .33318 L
.53165 .32587 L
.53353 .32392 L
.54286 .31467 L
.5443 .31328 L
.55309 .30541 L
.55696 .30201 L
.56384 .29616 L
.56962 .29002 L
.57472 .2869 L
.58228 .27963 L
.58537 .27765 L
.59494 .26881 L
.59571 .26839 L
.60516 .25914 L
.60759 .25655 L
.61508 .24988 L
.62025 .24295 L
.62262 .24063 L
.63049 .23137 L
.63291 .22762 L
.63722 .22212 L
.64354 .21286 L
.64557 .20948 L
.64924 .20361 L
.65443 .19435 L
.65823 .18683 L
.65908 .1851 L
.6633 .17584 L
.66709 .16659 L
.67054 .15733 L
.67089 .15637 L
.67371 .14808 L
.67667 .13882 L
.6795 .12957 L
.68227 .12031 L
.68354 .11603 L
Mistroke
.68504 .11106 L
.68786 .1018 L
.69077 .09255 L
.69379 .08329 L
.6962 .0761 L
.69691 .07404 L
.70011 .06478 L
.70339 .05553 L
.7067 .04627 L
.70886 .04024 L
.71001 .03702 L
.7133 .02776 L
.71654 .01851 L
.71971 .00925 L
.72152 .00383 L
.72277 0 L
Mfstroke
1 g
.49367 .3965 m
.50633 .39412 L
.50747 .39796 L
.50962 .40722 L
.51276 .41647 L
.51642 .42573 L
.51899 .43209 L
.52079 .43498 L
.52382 .44424 L
.52786 .45349 L
.53165 .46181 L
.53216 .46275 L
.53751 .472 L
.54044 .48126 L
.5443 .48959 L
.54479 .49051 L
.54963 .49977 L
.5543 .50902 L
.55696 .51822 L
.55699 .51828 L
.56121 .52753 L
.56531 .53679 L
.56888 .54604 L
.56962 .55373 L
.57008 .5553 L
.57233 .56455 L
.57378 .57381 L
.57342 .58306 L
.57119 .59232 L
.56962 .59635 L
.56184 .60157 L
.55696 .60582 L
.5443 .60624 L
.53358 .60157 L
.53165 .60067 L
.52255 .59232 L
.51899 .58913 L
.5153 .58306 L
.50961 .57381 L
.50633 .56793 L
.50523 .56455 L
.50181 .5553 L
.49886 .54604 L
.49641 .53679 L
.49441 .52753 L
.49367 .52359 L
.49289 .51828 L
.49167 .50902 L
.49067 .49977 L
.48988 .49051 L
.48928 .48126 L
.48886 .472 L
.48863 .46275 L
.48856 .45349 L
.48868 .44424 L
.48907 .43498 L
.49042 .42573 L
.49037 .41647 L
.49161 .40722 L
.49324 .39796 L
F
0 g
.49367 .3965 m
.50633 .39412 L
.50747 .39796 L
.50962 .40722 L
.51276 .41647 L
.51642 .42573 L
.51899 .43209 L
.52079 .43498 L
.52382 .44424 L
.52786 .45349 L
.53165 .46181 L
.53216 .46275 L
.53751 .472 L
.54044 .48126 L
.5443 .48959 L
.54479 .49051 L
.54963 .49977 L
.5543 .50902 L
.55696 .51822 L
.55699 .51828 L
.56121 .52753 L
.56531 .53679 L
.56888 .54604 L
.56962 .55373 L
.57008 .5553 L
.57233 .56455 L
.57378 .57381 L
.57342 .58306 L
.57119 .59232 L
.56962 .59635 L
.56184 .60157 L
.55696 .60582 L
.5443 .60624 L
.53358 .60157 L
.53165 .60067 L
.52255 .59232 L
.51899 .58913 L
.5153 .58306 L
.50961 .57381 L
.50633 .56793 L
.50523 .56455 L
.50181 .5553 L
.49886 .54604 L
.49641 .53679 L
.49441 .52753 L
.49367 .52359 L
.49289 .51828 L
.49167 .50902 L
.49067 .49977 L
.48988 .49051 L
Mistroke
.48928 .48126 L
.48886 .472 L
.48863 .46275 L
.48856 .45349 L
.48868 .44424 L
.48907 .43498 L
.49042 .42573 L
.49037 .41647 L
.49161 .40722 L
.49324 .39796 L
.49367 .3965 L
Mfstroke
.5 g
.45365 .40213 m
.55365 .40213 L
.55365 .32901 L
.45365 .32901 L
F
1 g
.45365 .3835 m
.45412 .38338 L
.45621 .38175 L
.45654 .38151 L
.45878 .3802 L
.4597 .37963 L
.46134 .37882 L
.4635 .37776 L
.46391 .37759 L
.46647 .37647 L
.46777 .37588 L
.46903 .37545 L
.4716 .37451 L
.47272 .37401 L
.47416 .37362 L
.47673 .37279 L
.47881 .37213 L
.47929 .37199 L
.48185 .37125 L
.48442 .37051 L
.48525 .37026 L
.48698 .36986 L
.48955 .36918 L
.49211 .36845 L
.49232 .36838 L
.49467 .36778 L
.49724 .36712 L
.4998 .36655 L
.50035 .36838 L
.50237 .36978 L
.50361 .37026 L
.50406 .37213 L
.50426 .37401 L
.50444 .37588 L
.50463 .37776 L
.50484 .37963 L
.50493 .38046 L
.50504 .38151 L
.50532 .38338 L
.50562 .38526 L
.50594 .38713 L
.50628 .38901 L
.50663 .39088 L
.50698 .39276 L
.50734 .39463 L
.5075 .39564 L
.50774 .39651 L
.50819 .39838 L
.50866 .40025 L
.50914 .40213 L
.45365 .40213 L
F
0 g
.45365 .3835 m
.45412 .38338 L
.45621 .38175 L
.45654 .38151 L
.45878 .3802 L
.4597 .37963 L
.46134 .37882 L
.4635 .37776 L
.46391 .37759 L
.46647 .37647 L
.46777 .37588 L
.46903 .37545 L
.4716 .37451 L
.47272 .37401 L
.47416 .37362 L
.47673 .37279 L
.47881 .37213 L
.47929 .37199 L
.48185 .37125 L
.48442 .37051 L
.48525 .37026 L
.48698 .36986 L
.48955 .36918 L
.49211 .36845 L
.49232 .36838 L
.49467 .36778 L
.49724 .36712 L
.4998 .36655 L
.50035 .36838 L
.50237 .36978 L
.50361 .37026 L
.50406 .37213 L
.50426 .37401 L
.50444 .37588 L
.50463 .37776 L
.50484 .37963 L
.50493 .38046 L
.50504 .38151 L
.50532 .38338 L
.50562 .38526 L
.50594 .38713 L
.50628 .38901 L
.50663 .39088 L
.50698 .39276 L
.50734 .39463 L
.5075 .39564 L
.50774 .39651 L
.50819 .39838 L
.50866 .40025 L
.50914 .40213 L
Mistroke
Mfstroke
1 g
.45365 .34764 m
.45412 .34776 L
.45621 .3494 L
.45654 .34964 L
.45878 .35095 L
.4597 .35151 L
.46134 .35232 L
.4635 .35339 L
.46391 .35356 L
.46647 .35467 L
.46777 .35526 L
.46903 .35569 L
.4716 .35664 L
.47272 .35714 L
.47416 .35752 L
.47673 .35835 L
.47881 .35901 L
.47929 .35915 L
.48185 .35989 L
.48442 .36064 L
.48525 .36089 L
.48698 .36128 L
.48955 .36196 L
.49211 .36269 L
.49232 .36276 L
.49467 .36336 L
.49724 .36403 L
.4998 .3646 L
.49985 .36463 L
.49985 .36651 L
.50237 .36654 L
.50493 .36651 L
.50493 .36463 L
.50237 .3646 L
.50035 .36276 L
.4998 .36217 L
.49833 .36089 L
.49724 .35988 L
.49625 .35901 L
.49467 .35758 L
.4942 .35714 L
.4922 .35526 L
.49211 .35515 L
.49027 .35339 L
.48955 .35247 L
.48841 .35151 L
.48698 .34985 L
.4865 .34964 L
.48489 .34776 L
.48442 .34719 L
.48299 .34589 L
.48185 .34423 L
.4816 .34401 L
.47993 .34214 L
.47929 .34108 L
.47856 .34026 L
.47712 .33839 L
.47673 .33773 L
.47578 .33651 L
.47447 .33464 L
.47416 .33411 L
.47321 .33276 L
.47198 .33089 L
.4716 .33031 L
.4708 .32901 L
.45365 .32901 L
F
0 g
.45365 .34764 m
.45412 .34776 L
.45621 .3494 L
.45654 .34964 L
.45878 .35095 L
.4597 .35151 L
.46134 .35232 L
.4635 .35339 L
.46391 .35356 L
.46647 .35467 L
.46777 .35526 L
.46903 .35569 L
.4716 .35664 L
.47272 .35714 L
.47416 .35752 L
.47673 .35835 L
.47881 .35901 L
.47929 .35915 L
.48185 .35989 L
.48442 .36064 L
.48525 .36089 L
.48698 .36128 L
.48955 .36196 L
.49211 .36269 L
.49232 .36276 L
.49467 .36336 L
.49724 .36403 L
.4998 .3646 L
.49985 .36463 L
.49985 .36651 L
.50237 .36654 L
.50493 .36651 L
.50493 .36463 L
.50237 .3646 L
.50035 .36276 L
.4998 .36217 L
.49833 .36089 L
.49724 .35988 L
.49625 .35901 L
.49467 .35758 L
.4942 .35714 L
.4922 .35526 L
.49211 .35515 L
.49027 .35339 L
.48955 .35247 L
.48841 .35151 L
.48698 .34985 L
.4865 .34964 L
.48489 .34776 L
.48442 .34719 L
Mistroke
.48299 .34589 L
.48185 .34423 L
.4816 .34401 L
.47993 .34214 L
.47929 .34108 L
.47856 .34026 L
.47712 .33839 L
.47673 .33773 L
.47578 .33651 L
.47447 .33464 L
.47416 .33411 L
.47321 .33276 L
.47198 .33089 L
.4716 .33031 L
.4708 .32901 L
Mfstroke
.5 g
.49241 .40213 m
.49275 .40025 L
.49311 .39838 L
.49351 .39651 L
.49393 .39463 L
.49438 .39276 L
.49467 .39173 L
.49482 .39088 L
.49523 .38901 L
.49573 .38713 L
.49631 .38526 L
.49696 .38338 L
.49724 .38262 L
.49761 .38151 L
.49827 .37963 L
.49895 .37776 L
.49944 .37588 L
.4998 .37542 L
.50045 .37401 L
.50143 .37213 L
.50217 .37026 L
.4998 .36897 L
.49833 .37026 L
.49724 .37126 L
.49625 .37213 L
.49467 .37357 L
.4942 .37401 L
.4922 .37588 L
.49211 .37599 L
.49027 .37776 L
.48955 .37867 L
.48841 .37963 L
.48698 .38129 L
.4865 .38151 L
.48489 .38338 L
.48442 .38396 L
.48299 .38526 L
.48185 .38691 L
.4816 .38713 L
.47993 .38901 L
.47929 .39006 L
.47856 .39088 L
.47712 .39276 L
.47673 .39342 L
.47578 .39463 L
.47447 .39651 L
.47416 .39703 L
.47321 .39838 L
.47198 .40025 L
.4716 .40083 L
.4708 .40213 L
F
0 g
.49241 .40213 m
.49275 .40025 L
.49311 .39838 L
.49351 .39651 L
.49393 .39463 L
.49438 .39276 L
.49467 .39173 L
.49482 .39088 L
.49523 .38901 L
.49573 .38713 L
.49631 .38526 L
.49696 .38338 L
.49724 .38262 L
.49761 .38151 L
.49827 .37963 L
.49895 .37776 L
.49944 .37588 L
.4998 .37542 L
.50045 .37401 L
.50143 .37213 L
.50217 .37026 L
.4998 .36897 L
.49833 .37026 L
.49724 .37126 L
.49625 .37213 L
.49467 .37357 L
.4942 .37401 L
.4922 .37588 L
.49211 .37599 L
.49027 .37776 L
.48955 .37867 L
.48841 .37963 L
.48698 .38129 L
.4865 .38151 L
.48489 .38338 L
.48442 .38396 L
.48299 .38526 L
.48185 .38691 L
.4816 .38713 L
.47993 .38901 L
.47929 .39006 L
.47856 .39088 L
.47712 .39276 L
.47673 .39342 L
.47578 .39463 L
.47447 .39651 L
.47416 .39703 L
.47321 .39838 L
.47198 .40025 L
.4716 .40083 L
Mistroke
.4708 .40213 L
Mfstroke
1 g
.50914 .32901 m
.50866 .33089 L
.50819 .33276 L
.50774 .33464 L
.5075 .3355 L
.50734 .33651 L
.50698 .33839 L
.50663 .34026 L
.50628 .34214 L
.50594 .34401 L
.50562 .34589 L
.50532 .34776 L
.50504 .34964 L
.50493 .35068 L
.50484 .35151 L
.50463 .35339 L
.50444 .35526 L
.50426 .35714 L
.50406 .35901 L
.50361 .36089 L
.50237 .36137 L
.50217 .36089 L
.50143 .35901 L
.50045 .35714 L
.4998 .35573 L
.49944 .35526 L
.49895 .35339 L
.49827 .35151 L
.49761 .34964 L
.49724 .34852 L
.49696 .34776 L
.49631 .34589 L
.49573 .34401 L
.49523 .34214 L
.49482 .34026 L
.49467 .33942 L
.49438 .33839 L
.49393 .33651 L
.49351 .33464 L
.49311 .33276 L
.49275 .33089 L
.49241 .32901 L
F
0 g
.50914 .32901 m
.50866 .33089 L
.50819 .33276 L
.50774 .33464 L
.5075 .3355 L
.50734 .33651 L
.50698 .33839 L
.50663 .34026 L
.50628 .34214 L
.50594 .34401 L
.50562 .34589 L
.50532 .34776 L
.50504 .34964 L
.50493 .35068 L
.50484 .35151 L
.50463 .35339 L
.50444 .35526 L
.50426 .35714 L
.50406 .35901 L
.50361 .36089 L
.50237 .36137 L
.50217 .36089 L
.50143 .35901 L
.50045 .35714 L
.4998 .35573 L
.49944 .35526 L
.49895 .35339 L
.49827 .35151 L
.49761 .34964 L
.49724 .34852 L
.49696 .34776 L
.49631 .34589 L
.49573 .34401 L
.49523 .34214 L
.49482 .34026 L
.49467 .33942 L
.49438 .33839 L
.49393 .33651 L
.49351 .33464 L
.49311 .33276 L
.49275 .33089 L
.49241 .32901 L
s
1 g
.50493 .36651 m
.50493 .36463 L
% vacuous filled polygon
newpath
0 g
.50493 .36651 m
.50493 .36463 L
.50493 .36651 L
s
1 g
.55365 .37389 m
.55108 .37372 L
.54852 .37349 L
.54596 .37322 L
.54339 .37291 L
.54083 .37257 L
.53826 .3722 L
.53786 .37213 L
.5357 .37181 L
.53314 .3714 L
.53057 .37096 L
.52801 .3705 L
.52678 .37026 L
.52544 .37005 L
.52288 .3696 L
.52032 .36909 L
.51775 .36853 L
.5172 .36838 L
.51519 .36798 L
.51262 .36741 L
.51006 .36685 L
.5096 .36651 L
.5096 .36463 L
.5075 .36292 L
.50497 .36276 L
.50546 .36089 L
.50741 .35901 L
.5075 .35884 L
.50833 .35714 L
.50952 .35526 L
.51006 .35438 L
.51064 .35339 L
.51181 .35151 L
.51262 .35025 L
.51301 .34964 L
.51424 .34776 L
.51519 .34638 L
.51563 .34589 L
.51683 .34401 L
.51775 .34273 L
.51827 .34214 L
.51957 .34026 L
.52032 .33915 L
.52111 .33839 L
.52266 .33651 L
.52288 .33596 L
.52411 .33464 L
.52544 .33286 L
.52555 .33276 L
.52726 .33089 L
.52801 .33019 L
.52884 .32901 L
.55365 .32901 L
F
0 g
.55365 .37389 m
.55108 .37372 L
.54852 .37349 L
.54596 .37322 L
.54339 .37291 L
.54083 .37257 L
.53826 .3722 L
.53786 .37213 L
.5357 .37181 L
.53314 .3714 L
.53057 .37096 L
.52801 .3705 L
.52678 .37026 L
.52544 .37005 L
.52288 .3696 L
.52032 .36909 L
.51775 .36853 L
.5172 .36838 L
.51519 .36798 L
.51262 .36741 L
.51006 .36685 L
.5096 .36651 L
.5096 .36463 L
.5075 .36292 L
.50497 .36276 L
.50546 .36089 L
.50741 .35901 L
.5075 .35884 L
.50833 .35714 L
.50952 .35526 L
.51006 .35438 L
.51064 .35339 L
.51181 .35151 L
.51262 .35025 L
.51301 .34964 L
.51424 .34776 L
.51519 .34638 L
.51563 .34589 L
.51683 .34401 L
.51775 .34273 L
.51827 .34214 L
.51957 .34026 L
.52032 .33915 L
.52111 .33839 L
.52266 .33651 L
.52288 .33596 L
.52411 .33464 L
.52544 .33286 L
.52555 .33276 L
.52726 .33089 L
Mistroke
.52801 .33019 L
.52884 .32901 L
Mfstroke
1 g
.55365 .39373 m
.55108 .39287 L
.55083 .39276 L
.54852 .39195 L
.54596 .39094 L
.54588 .39088 L
.54339 .38988 L
.54155 .38901 L
.54083 .38873 L
.53826 .38752 L
.53749 .38713 L
.5357 .38626 L
.53401 .38526 L
.53314 .38492 L
.53057 .3835 L
.53038 .38338 L
.52801 .38206 L
.52713 .38151 L
.52544 .38059 L
.52403 .37963 L
.52288 .37911 L
.52106 .37776 L
.52032 .37729 L
.5182 .37588 L
.51775 .3756 L
.51544 .37401 L
.51519 .37385 L
.51277 .37213 L
.51262 .37204 L
.51023 .37026 L
.51006 .37017 L
.50787 .36838 L
.5075 .36822 L
.50497 .36838 L
.50546 .37026 L
.50741 .37213 L
.5075 .37231 L
.50833 .37401 L
.50952 .37588 L
.51006 .37676 L
.51064 .37776 L
.51181 .37963 L
.51262 .38089 L
.51301 .38151 L
.51424 .38338 L
.51519 .38477 L
.51563 .38526 L
.51683 .38713 L
.51775 .38842 L
.51827 .38901 L
.51957 .39088 L
.52032 .39199 L
.52111 .39276 L
.52266 .39463 L
.52288 .39519 L
.52411 .39651 L
.52544 .39828 L
.52555 .39838 L
.52726 .40025 L
.52801 .40095 L
.52884 .40213 L
.55365 .40213 L
F
0 g
.55365 .39373 m
.55108 .39287 L
.55083 .39276 L
.54852 .39195 L
.54596 .39094 L
.54588 .39088 L
.54339 .38988 L
.54155 .38901 L
.54083 .38873 L
.53826 .38752 L
.53749 .38713 L
.5357 .38626 L
.53401 .38526 L
.53314 .38492 L
.53057 .3835 L
.53038 .38338 L
.52801 .38206 L
.52713 .38151 L
.52544 .38059 L
.52403 .37963 L
.52288 .37911 L
.52106 .37776 L
.52032 .37729 L
.5182 .37588 L
.51775 .3756 L
.51544 .37401 L
.51519 .37385 L
.51277 .37213 L
.51262 .37204 L
.51023 .37026 L
.51006 .37017 L
.50787 .36838 L
.5075 .36822 L
.50497 .36838 L
.50546 .37026 L
.50741 .37213 L
.5075 .37231 L
.50833 .37401 L
.50952 .37588 L
.51006 .37676 L
.51064 .37776 L
.51181 .37963 L
.51262 .38089 L
.51301 .38151 L
.51424 .38338 L
.51519 .38477 L
.51563 .38526 L
.51683 .38713 L
.51775 .38842 L
.51827 .38901 L
Mistroke
.51957 .39088 L
.52032 .39199 L
.52111 .39276 L
.52266 .39463 L
.52288 .39519 L
.52411 .39651 L
.52544 .39828 L
.52555 .39838 L
.52726 .40025 L
.52801 .40095 L
.52884 .40213 L
Mfstroke
.5 g
.55365 .35725 m
.55108 .35743 L
.54852 .35765 L
.54596 .35792 L
.54339 .35823 L
.54083 .35858 L
.53826 .35895 L
.53786 .35901 L
.5357 .35933 L
.53314 .35975 L
.53057 .36019 L
.52801 .36065 L
.52678 .36089 L
.52544 .36109 L
.52288 .36154 L
.52032 .36206 L
.51775 .36261 L
.5172 .36276 L
.51519 .36316 L
.51262 .36373 L
.51006 .36429 L
.50787 .36276 L
.51006 .36097 L
.51023 .36089 L
.51262 .3591 L
.51277 .35901 L
.51519 .3573 L
.51544 .35714 L
.51775 .35555 L
.5182 .35526 L
.52032 .35386 L
.52106 .35339 L
.52288 .35204 L
.52403 .35151 L
.52544 .35055 L
.52713 .34964 L
.52801 .34908 L
.53038 .34776 L
.53057 .34765 L
.53314 .34622 L
.53401 .34589 L
.5357 .34489 L
.53749 .34401 L
.53826 .34362 L
.54083 .34241 L
.54155 .34214 L
.54339 .34127 L
.54588 .34026 L
.54596 .3402 L
.54852 .3392 L
.55083 .33839 L
.55108 .33827 L
.55365 .33741 L
F
0 g
.55365 .35725 m
.55108 .35743 L
.54852 .35765 L
.54596 .35792 L
.54339 .35823 L
.54083 .35858 L
.53826 .35895 L
.53786 .35901 L
.5357 .35933 L
.53314 .35975 L
.53057 .36019 L
.52801 .36065 L
.52678 .36089 L
.52544 .36109 L
.52288 .36154 L
.52032 .36206 L
.51775 .36261 L
.5172 .36276 L
.51519 .36316 L
.51262 .36373 L
.51006 .36429 L
.50787 .36276 L
.51006 .36097 L
.51023 .36089 L
.51262 .3591 L
.51277 .35901 L
.51519 .3573 L
.51544 .35714 L
.51775 .35555 L
.5182 .35526 L
.52032 .35386 L
.52106 .35339 L
.52288 .35204 L
.52403 .35151 L
.52544 .35055 L
.52713 .34964 L
.52801 .34908 L
.53038 .34776 L
.53057 .34765 L
.53314 .34622 L
.53401 .34589 L
.5357 .34489 L
.53749 .34401 L
.53826 .34362 L
.54083 .34241 L
.54155 .34214 L
.54339 .34127 L
.54588 .34026 L
.54596 .3402 L
.54852 .3392 L
Mistroke
.55083 .33839 L
.55108 .33827 L
.55365 .33741 L
Mfstroke
1 g
.14355 .22501 m
.17155 .19701 L
.19955 .22501 L
.17155 .25301 L
.14355 .22501 L
F
.14355 .50614 m
.17155 .47814 L
.19955 .50614 L
.17155 .53414 L
.14355 .50614 L
F
.80045 .36557 m
.82845 .33757 L
.85645 .36557 L
.82845 .39357 L
.80045 .36557 L
F
.54576 .12053 m
.58576 .12053 L
.58576 .16053 L
.54576 .16053 L
.54576 .12053 L
F
.54576 .57062 m
.58576 .57062 L
.58576 .61062 L
.54576 .61062 L
.54576 .57062 L
F
.55706 .34557 m
.59706 .34557 L
.59706 .38557 L
.55706 .38557 L
.55706 .34557 L
F
0 g
.003 w
.14355 .22501 m
.17155 .19701 L
.19955 .22501 L
.17155 .25301 L
.14355 .22501 L
s
.14355 .50614 m
.17155 .47814 L
.19955 .50614 L
.17155 .53414 L
.14355 .50614 L
s
.80045 .36557 m
.82845 .33757 L
.85645 .36557 L
.82845 .39357 L
.80045 .36557 L
s
.57707 .34557 m
.57707 .38557 L
s
.55707 .36557 m
.59707 .36557 L
s
.54576 .12053 m
.58576 .12053 L
.58576 .16053 L
.54576 .16053 L
.54576 .12053 L
s
.54576 .57062 m
.58576 .57062 L
.58576 .61062 L
.54576 .61062 L
.54576 .57062 L
s
.55706 .34557 m
.59706 .34557 L
.59706 .38557 L
.55706 .38557 L
.55706 .34557 L
s
1 g
.6 .43869 m
.6 .71652 L
.98 .71652 L
.98 .43869 L
F
0 g
.6 .43869 m
.6 .71652 L
.98 .71652 L
.98 .43869 L
.6 .43869 L
s
% Start of sub-graphic
p
0.6 0.438686 0.98 0.716521 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0174082 0.696328 [
[ 0 0 0 0 ]
[ 1 .73114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .73114 L
0 .73114 L
closepath
clip
newpath
1 g
.05038 .6441 m
.12406 .57042 L
.19774 .6441 L
.12406 .71779 L
.05038 .6441 L
F
0 g
.00789 w
[ ] 0 setdash
.05038 .6441 m
.12406 .57042 L
.19774 .6441 L
.12406 .71779 L
.05038 .6441 L
s
gsave
.31579 .65803 -61 -7.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 14.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
66.562 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Poles) show
87.938 8.938 moveto
(of) show
98.625 8.938 moveto
(approximant) show
137.812 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 g
.07143 .45221 m
.17669 .45221 L
.17669 .55747 L
.07143 .55747 L
.07143 .45221 L
F
0 g
.07143 .45221 m
.17669 .45221 L
.17669 .55747 L
.07143 .55747 L
.07143 .45221 L
s
gsave
.31579 .5118 -61 -7.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 14.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
66.562 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Zeros) show
87.938 8.938 moveto
(of) show
98.625 8.938 moveto
(approximant) show
137.812 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.07143 .4182 m
.17669 .31294 L
s
.07143 .31294 m
.17669 .4182 L
s
gsave
.31579 .36557 -61 -7.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 14.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
66.562 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Poles) show
87.938 8.938 moveto
(of) show
98.625 8.938 moveto
(function) show
127.125 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.12406 .17367 m
.12406 .27894 L
s
.07143 .22631 m
.17669 .22631 L
s
gsave
.31579 .21934 -61 -7.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 14.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
66.562 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Zeros) show
87.938 8.938 moveto
(of) show
98.625 8.938 moveto
(function) show
127.125 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 g
.12406 .08704 m
.12406 .08704 .05263 0 365.73 arc
F
0 g
newpath
.12406 .08704 .05263 0 365.73 arc
s
gsave
.31579 .07311 -61 -7.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 14.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
66.562 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Interpolation) show
116.438 8.938 moveto
(points) show
137.812 8.938 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 6.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.731144 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.504054 0.073011 0.365572 0.073011 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .73114 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .73114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .73114 L
s
0 .73114 m
1 .73114 L
s
1 0 m
1 .73114 L
s
0 .36557 m
1 .36557 L
s
.50405 0 m
.50405 .73114 L
s
0 0 m
1 0 L
1 .73114 L
0 .73114 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.91.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.91.1"]
}, Open  ]],

Cell[TextData[{
 "In addition to the many options unique to ",
 StyleBox["OrderStar", "MR"],
 ", there are several that are simply passed to ",
 StyleBox["ContourPlot", "MR"],
 " and used to produce the plot. "
}], "Text",
 CellTags->{"S5.91.1", "1.20"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["AspectRatio", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies the aspect ratio of the plot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Axes", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies whether to draw axes",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AxesOrigin", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies the intersection of the axes",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ColorFunction", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies a function to apply to color the stability and instability \
regions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FrameTicks", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies whether or where to place tick marks around the frame",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotPoints", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies the number of sample points to use in constructing the \
contour plot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotRange", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies the plot range to be used in the plot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Ticks", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specifies whether or where to place tick marks along the axes",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.91.1"],

Cell["Options common to many graphics functions.", "Caption",
 CellTags->"S5.91.1"],

Cell[TextData[{
 "An important issue is whether an order star crosses the imaginary axis. \
Additionally, it may be interesting to illustrate symmetry around the real \
axis. In order to facilitate these comparisons ",
 StyleBox["OrderStar", "MR"],
 " uses graphics options to render axes which pass through the origin. "
}], "Text",
 CellTags->{"S5.91.1", "1.21"}],

Cell[TextData[{
 "The default plot region and subdivision are determined from essential \
features of the order star. However, this default can be overridden using \
standard ",
 StyleBox["Graphics", "MR"],
 " options. "
}], "Text",
 CellTags->{"S5.91.1", "1.22"}],

Cell["This defines a function. ", "MathCaption",
 CellTags->{"S5.91.1", "1.23"}],

Cell["fun = Exp[Cos[z]+ I Cosh[z]];", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.91.1"],

Cell["This constructs a Pad\[EAcute] approximant to the function. ", \
"MathCaption",
 CellTags->{"S5.91.1", "1.24"}],

Cell["approx = Pade[ fun, {z, 0, 2, 3}];", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.91.1"],

Cell[TextData[{
 "You can change the default plot region and plot density using standard \
options. However, in doing so you can make the plot quite jagged. Increasing \
",
 StyleBox["PlotPoints", "MR"],
 " can resolve this issue. "
}], "MathCaption",
 CellTags->{"S5.91.1", "1.25"}],

Cell[CellGroupData[{

Cell["\<\
OrderStar[approx, fun,
              PlotRange -> {{-5, 5},{-5, 5}},
              PlotPoints -> 40 ]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.91.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.1 0.5 0.1 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 g
0 1 m
1 1 L
1 0 L
0 0 L
F
1 g
0 .48718 m
.02564 .48718 L
.05128 .48718 L
.07692 .48719 L
.10256 .48728 L
.12821 .48764 L
.15385 .48869 L
.15642 .51282 L
.17949 .514 L
.20513 .51675 L
.23077 .52155 L
.25641 .52811 L
.28205 .53398 L
.30769 .53756 L
.31771 .53846 L
.33333 .53906 L
.3584 .53846 L
.35897 .53842 L
.38462 .53532 L
.41026 .52969 L
.4359 .52148 L
.46154 .51338 L
.46927 .53846 L
.46154 .54825 L
.44802 .5641 L
.4359 .57991 L
.42852 .58974 L
.41308 .61538 L
.41026 .62037 L
.40414 .64103 L
.40779 .66667 L
.41026 .67196 L
.4359 .69168 L
.46154 .68624 L
.48012 .66667 L
.48338 .64103 L
.48448 .61538 L
.48692 .58974 L
.48718 .58794 L
.49052 .5641 L
.50528 .53846 L
.48718 .51379 L
.46253 .51282 L
.46154 .50794 L
.4359 .48832 L
.42309 .48718 L
.41026 .48244 L
.38462 .4737 L
.36504 .46154 L
.35897 .45863 L
.34663 .4359 L
.35897 .4176 L
.38462 .41709 L
.41026 .42977 L
.41912 .4359 L
.4359 .44883 L
.45205 .46154 L
.46154 .46991 L
.48699 .48718 L
.48718 .48881 L
.48836 .51282 L
.51282 .53724 L
.51345 .53846 L
.52271 .5641 L
.5361 .58974 L
.53846 .59447 L
.54893 .61538 L
.56227 .64103 L
.5641 .64653 L
.5773 .66667 L
.58974 .69115 L
.5914 .69231 L
.60687 .71795 L
.61538 .73787 L
.62526 .74359 L
.63471 .76923 L
.64038 .79487 L
.64103 .79727 L
.66264 .82051 L
.66489 .84615 L
.66604 .87179 L
.6665 .89744 L
.66664 .92308 L
.66666 .94872 L
.66667 .97436 L
.66667 1 L
0 1 L
F
0 g
.5 Mabswid
0 .48718 m
.02564 .48718 L
.05128 .48718 L
.07692 .48719 L
.10256 .48728 L
.12821 .48764 L
.15385 .48869 L
.15642 .51282 L
.17949 .514 L
.20513 .51675 L
.23077 .52155 L
.25641 .52811 L
.28205 .53398 L
.30769 .53756 L
.31771 .53846 L
.33333 .53906 L
.3584 .53846 L
.35897 .53842 L
.38462 .53532 L
.41026 .52969 L
.4359 .52148 L
.46154 .51338 L
.46927 .53846 L
.46154 .54825 L
.44802 .5641 L
.4359 .57991 L
.42852 .58974 L
.41308 .61538 L
.41026 .62037 L
.40414 .64103 L
.40779 .66667 L
.41026 .67196 L
.4359 .69168 L
.46154 .68624 L
.48012 .66667 L
.48338 .64103 L
.48448 .61538 L
.48692 .58974 L
.48718 .58794 L
.49052 .5641 L
.50528 .53846 L
.48718 .51379 L
.46253 .51282 L
.46154 .50794 L
.4359 .48832 L
.42309 .48718 L
.41026 .48244 L
.38462 .4737 L
.36504 .46154 L
.35897 .45863 L
Mistroke
.34663 .4359 L
.35897 .4176 L
.38462 .41709 L
.41026 .42977 L
.41912 .4359 L
.4359 .44883 L
.45205 .46154 L
.46154 .46991 L
.48699 .48718 L
.48718 .48881 L
.48836 .51282 L
.51282 .53724 L
.51345 .53846 L
.52271 .5641 L
.5361 .58974 L
.53846 .59447 L
.54893 .61538 L
.56227 .64103 L
.5641 .64653 L
.5773 .66667 L
.58974 .69115 L
.5914 .69231 L
.60687 .71795 L
.61538 .73787 L
.62526 .74359 L
.63471 .76923 L
.64038 .79487 L
.64103 .79727 L
.66264 .82051 L
.66489 .84615 L
.66604 .87179 L
.6665 .89744 L
.66664 .92308 L
.66666 .94872 L
.66667 .97436 L
.66667 1 L
Mfstroke
.5 g
0 .82051 m
.02564 .82051 L
.05128 .82051 L
.07692 .82051 L
.09704 .79487 L
.10256 .79486 L
.12821 .79483 L
.14268 .76923 L
.15385 .76907 L
.17949 .76879 L
.18838 .74359 L
.20513 .74234 L
.23077 .74015 L
.24314 .71795 L
.25641 .71473 L
.28205 .70757 L
.30769 .701 L
.33333 .70512 L
.34691 .71795 L
.35396 .74359 L
.35693 .76923 L
.34503 .79487 L
.33724 .82051 L
.33453 .84615 L
.33364 .87179 L
.33339 .89744 L
.33334 .92308 L
.33333 .94872 L
.33333 .97436 L
.33333 1 L
0 1 L
F
0 g
0 .82051 m
.02564 .82051 L
.05128 .82051 L
.07692 .82051 L
.09704 .79487 L
.10256 .79486 L
.12821 .79483 L
.14268 .76923 L
.15385 .76907 L
.17949 .76879 L
.18838 .74359 L
.20513 .74234 L
.23077 .74015 L
.24314 .71795 L
.25641 .71473 L
.28205 .70757 L
.30769 .701 L
.33333 .70512 L
.34691 .71795 L
.35396 .74359 L
.35693 .76923 L
.34503 .79487 L
.33724 .82051 L
.33453 .84615 L
.33364 .87179 L
.33339 .89744 L
.33334 .92308 L
.33333 .94872 L
.33333 .97436 L
.33333 1 L
s
1 g
0 .20513 m
.02564 .20513 L
.04981 .17949 L
.05128 .17949 L
.07692 .17944 L
.10174 .15385 L
.10252 .12821 L
.10256 .12649 L
.12808 .10256 L
.10256 .07744 L
.10256 .07692 L
.10256 .05128 L
.10256 .02564 L
.07692 .0214 L
.07692 0 L
0 0 L
F
0 g
0 .20513 m
.02564 .20513 L
.04981 .17949 L
.05128 .17949 L
.07692 .17944 L
.10174 .15385 L
.10252 .12821 L
.10256 .12649 L
.12808 .10256 L
.10256 .07744 L
.10256 .07692 L
.10256 .05128 L
.10256 .02564 L
.07692 .0214 L
.07692 0 L
s
1 g
1 .51282 m
.97436 .51282 L
.94872 .51282 L
.92308 .51281 L
.89744 .51272 L
.87179 .51236 L
.84615 .51131 L
.84358 .48718 L
.82051 .486 L
.79487 .48325 L
.76923 .47845 L
.74359 .47189 L
.71795 .46602 L
.69231 .46244 L
.68229 .46154 L
.66667 .46094 L
.6416 .46154 L
.64103 .46158 L
.61538 .46468 L
.58974 .47031 L
.5641 .47852 L
.53846 .48662 L
.53073 .46154 L
.53846 .45175 L
.55198 .4359 L
.5641 .42009 L
.57148 .41026 L
.58692 .38462 L
.58974 .37963 L
.59586 .35897 L
.59221 .33333 L
.58974 .32804 L
.5641 .30832 L
.53846 .31376 L
.51988 .33333 L
.51662 .35897 L
.51552 .38462 L
.51308 .41026 L
.51282 .41206 L
.50948 .4359 L
.49472 .46154 L
.51282 .48621 L
.53747 .48718 L
.53846 .49206 L
.5641 .51168 L
.57691 .51282 L
.58974 .51756 L
.61538 .5263 L
.63496 .53846 L
.64103 .54137 L
.65337 .5641 L
.64103 .5824 L
.61538 .58291 L
.58974 .57023 L
.58088 .5641 L
.5641 .55117 L
.54795 .53846 L
.53846 .53009 L
.51301 .51282 L
.51282 .51119 L
.51164 .48718 L
.48718 .46276 L
.48655 .46154 L
.47729 .4359 L
.4639 .41026 L
.46154 .40553 L
.45107 .38462 L
.43773 .35897 L
.4359 .35347 L
.4227 .33333 L
.41026 .30885 L
.4086 .30769 L
.39313 .28205 L
.38462 .26213 L
.37474 .25641 L
.36529 .23077 L
.35962 .20513 L
.35897 .20273 L
.33736 .17949 L
.33511 .15385 L
.33396 .12821 L
.3335 .10256 L
.33336 .07692 L
.33334 .05128 L
.33333 .02564 L
.33333 0 L
1 0 L
F
0 g
1 .51282 m
.97436 .51282 L
.94872 .51282 L
.92308 .51281 L
.89744 .51272 L
.87179 .51236 L
.84615 .51131 L
.84358 .48718 L
.82051 .486 L
.79487 .48325 L
.76923 .47845 L
.74359 .47189 L
.71795 .46602 L
.69231 .46244 L
.68229 .46154 L
.66667 .46094 L
.6416 .46154 L
.64103 .46158 L
.61538 .46468 L
.58974 .47031 L
.5641 .47852 L
.53846 .48662 L
.53073 .46154 L
.53846 .45175 L
.55198 .4359 L
.5641 .42009 L
.57148 .41026 L
.58692 .38462 L
.58974 .37963 L
.59586 .35897 L
.59221 .33333 L
.58974 .32804 L
.5641 .30832 L
.53846 .31376 L
.51988 .33333 L
.51662 .35897 L
.51552 .38462 L
.51308 .41026 L
.51282 .41206 L
.50948 .4359 L
.49472 .46154 L
.51282 .48621 L
.53747 .48718 L
.53846 .49206 L
.5641 .51168 L
.57691 .51282 L
.58974 .51756 L
.61538 .5263 L
.63496 .53846 L
.64103 .54137 L
Mistroke
.65337 .5641 L
.64103 .5824 L
.61538 .58291 L
.58974 .57023 L
.58088 .5641 L
.5641 .55117 L
.54795 .53846 L
.53846 .53009 L
.51301 .51282 L
.51282 .51119 L
.51164 .48718 L
.48718 .46276 L
.48655 .46154 L
.47729 .4359 L
.4639 .41026 L
.46154 .40553 L
.45107 .38462 L
.43773 .35897 L
.4359 .35347 L
.4227 .33333 L
.41026 .30885 L
.4086 .30769 L
.39313 .28205 L
.38462 .26213 L
.37474 .25641 L
.36529 .23077 L
.35962 .20513 L
.35897 .20273 L
.33736 .17949 L
.33511 .15385 L
.33396 .12821 L
.3335 .10256 L
.33336 .07692 L
.33334 .05128 L
.33333 .02564 L
.33333 0 L
Mfstroke
.5 g
1 .17949 m
.97436 .17949 L
.94872 .17949 L
.92308 .17949 L
.90296 .20513 L
.89744 .20514 L
.87179 .20517 L
.85732 .23077 L
.84615 .23093 L
.82051 .23121 L
.81162 .25641 L
.79487 .25766 L
.76923 .25985 L
.75686 .28205 L
.74359 .28527 L
.71795 .29243 L
.69231 .299 L
.66667 .29488 L
.65309 .28205 L
.64604 .25641 L
.64307 .23077 L
.65497 .20513 L
.66276 .17949 L
.66547 .15385 L
.66636 .12821 L
.66661 .10256 L
.66666 .07692 L
.66667 .05128 L
.66667 .02564 L
.66667 0 L
1 0 L
F
0 g
1 .17949 m
.97436 .17949 L
.94872 .17949 L
.92308 .17949 L
.90296 .20513 L
.89744 .20514 L
.87179 .20517 L
.85732 .23077 L
.84615 .23093 L
.82051 .23121 L
.81162 .25641 L
.79487 .25766 L
.76923 .25985 L
.75686 .28205 L
.74359 .28527 L
.71795 .29243 L
.69231 .299 L
.66667 .29488 L
.65309 .28205 L
.64604 .25641 L
.64307 .23077 L
.65497 .20513 L
.66276 .17949 L
.66547 .15385 L
.66636 .12821 L
.66661 .10256 L
.66666 .07692 L
.66667 .05128 L
.66667 .02564 L
.66667 0 L
s
1 g
1 .79487 m
.97436 .79487 L
.95019 .82051 L
.94872 .82051 L
.92308 .82056 L
.89826 .84615 L
.89748 .87179 L
.89744 .87351 L
.87192 .89744 L
.89744 .92256 L
.89744 .92308 L
.89744 .94872 L
.89744 .97436 L
.92308 .9786 L
.92308 1 L
1 1 L
F
0 g
1 .79487 m
.97436 .79487 L
.95019 .82051 L
.94872 .82051 L
.92308 .82056 L
.89826 .84615 L
.89748 .87179 L
.89744 .87351 L
.87192 .89744 L
.89744 .92256 L
.89744 .92308 L
.89744 .94872 L
.89744 .97436 L
.92308 .9786 L
.92308 1 L
s
.5 g
.45 .55 m
.55 .55 L
.55 .45 L
.45 .45 L
F
1 g
.45 .45846 m
.4523 .46053 L
.45526 .46253 L
.4582 .46579 L
.46053 .46729 L
.46509 .47105 L
.46579 .47163 L
.47105 .47586 L
.47145 .47632 L
.47632 .48036 L
.47778 .48158 L
.48158 .48475 L
.48408 .48684 L
.48684 .48918 L
.49027 .49211 L
.49211 .49369 L
.4973 .49737 L
.49737 .49765 L
.49765 .50263 L
.50263 .50767 L
.50276 .50789 L
.50449 .51316 L
.50675 .51842 L
.50789 .52146 L
.50929 .52368 L
.51078 .52895 L
.51284 .53421 L
.51316 .53506 L
.51509 .53947 L
.51724 .54474 L
.51842 .54838 L
.51909 .55 L
.45 .55 L
F
0 g
.45 .45846 m
.4523 .46053 L
.45526 .46253 L
.4582 .46579 L
.46053 .46729 L
.46509 .47105 L
.46579 .47163 L
.47105 .47586 L
.47145 .47632 L
.47632 .48036 L
.47778 .48158 L
.48158 .48475 L
.48408 .48684 L
.48684 .48918 L
.49027 .49211 L
.49211 .49369 L
.4973 .49737 L
.49737 .49765 L
.49765 .50263 L
.50263 .50767 L
.50276 .50789 L
.50449 .51316 L
.50675 .51842 L
.50789 .52146 L
.50929 .52368 L
.51078 .52895 L
.51284 .53421 L
.51316 .53506 L
.51509 .53947 L
.51724 .54474 L
.51842 .54838 L
.51909 .55 L
s
.5 g
.45 .49094 m
.45526 .49201 L
.45574 .49211 L
.46053 .49282 L
.46579 .49364 L
.47105 .49453 L
.47632 .49558 L
.48158 .49686 L
.48377 .49737 L
.48684 .49786 L
.49211 .50137 L
.49233 .50263 L
.49737 .50271 L
.50134 .50789 L
.49788 .51316 L
.49737 .51631 L
.4969 .51842 L
.49578 .52368 L
.49483 .52895 L
.49405 .53421 L
.49333 .53947 L
.49262 .54474 L
.49211 .54861 L
.49191 .55 L
.45 .55 L
F
0 g
.45 .49094 m
.45526 .49201 L
.45574 .49211 L
.46053 .49282 L
.46579 .49364 L
.47105 .49453 L
.47632 .49558 L
.48158 .49686 L
.48377 .49737 L
.48684 .49786 L
.49211 .50137 L
.49233 .50263 L
.49737 .50271 L
.50134 .50789 L
.49788 .51316 L
.49737 .51631 L
.4969 .51842 L
.49578 .52368 L
.49483 .52895 L
.49405 .53421 L
.49333 .53947 L
.49262 .54474 L
.49211 .54861 L
.49191 .55 L
s
1 g
.45 .51801 m
.45526 .51634 L
.46053 .51443 L
.46382 .51316 L
.46579 .51247 L
.47105 .51181 L
.47632 .50906 L
.47833 .50789 L
.48158 .50669 L
.48684 .50448 L
.49211 .50276 L
.49369 .50789 L
.49211 .50973 L
.48917 .51316 L
.48684 .51592 L
.48475 .51842 L
.48158 .52222 L
.48036 .52368 L
.47632 .52856 L
.47589 .52895 L
.47164 .53421 L
.47105 .53515 L
.46666 .53947 L
.46579 .54174 L
.46266 .54474 L
.46053 .54774 L
.45855 .55 L
.45 .55 L
F
0 g
.45 .51801 m
.45526 .51634 L
.46053 .51443 L
.46382 .51316 L
.46579 .51247 L
.47105 .51181 L
.47632 .50906 L
.47833 .50789 L
.48158 .50669 L
.48684 .50448 L
.49211 .50276 L
.49369 .50789 L
.49211 .50973 L
.48917 .51316 L
.48684 .51592 L
.48475 .51842 L
.48158 .52222 L
.48036 .52368 L
.47632 .52856 L
.47589 .52895 L
.47164 .53421 L
.47105 .53515 L
.46666 .53947 L
.46579 .54174 L
.46266 .54474 L
.46053 .54774 L
.45855 .55 L
s
1 g
.55 .54154 m
.5477 .53947 L
.54474 .53747 L
.5418 .53421 L
.53947 .53271 L
.53491 .52895 L
.53421 .52837 L
.52895 .52414 L
.52855 .52368 L
.52368 .51964 L
.52222 .51842 L
.51842 .51525 L
.51592 .51316 L
.51316 .51082 L
.50973 .50789 L
.50789 .50631 L
.5027 .50263 L
.50263 .50235 L
.50235 .49737 L
.49737 .49233 L
.49724 .49211 L
.49551 .48684 L
.49325 .48158 L
.49211 .47854 L
.49071 .47632 L
.48922 .47105 L
.48716 .46579 L
.48684 .46494 L
.48491 .46053 L
.48276 .45526 L
.48158 .45162 L
.48091 .45 L
.55 .45 L
F
0 g
.55 .54154 m
.5477 .53947 L
.54474 .53747 L
.5418 .53421 L
.53947 .53271 L
.53491 .52895 L
.53421 .52837 L
.52895 .52414 L
.52855 .52368 L
.52368 .51964 L
.52222 .51842 L
.51842 .51525 L
.51592 .51316 L
.51316 .51082 L
.50973 .50789 L
.50789 .50631 L
.5027 .50263 L
.50263 .50235 L
.50235 .49737 L
.49737 .49233 L
.49724 .49211 L
.49551 .48684 L
.49325 .48158 L
.49211 .47854 L
.49071 .47632 L
.48922 .47105 L
.48716 .46579 L
.48684 .46494 L
.48491 .46053 L
.48276 .45526 L
.48158 .45162 L
.48091 .45 L
s
.5 g
.55 .50906 m
.54474 .50799 L
.54426 .50789 L
.53947 .50718 L
.53421 .50636 L
.52895 .50547 L
.52368 .50442 L
.51842 .50314 L
.51623 .50263 L
.51316 .50214 L
.50789 .49863 L
.50767 .49737 L
.50263 .49729 L
.49866 .49211 L
.50212 .48684 L
.50263 .48369 L
.5031 .48158 L
.50422 .47632 L
.50517 .47105 L
.50595 .46579 L
.50667 .46053 L
.50738 .45526 L
.50789 .45139 L
.50809 .45 L
.55 .45 L
F
0 g
.55 .50906 m
.54474 .50799 L
.54426 .50789 L
.53947 .50718 L
.53421 .50636 L
.52895 .50547 L
.52368 .50442 L
.51842 .50314 L
.51623 .50263 L
.51316 .50214 L
.50789 .49863 L
.50767 .49737 L
.50263 .49729 L
.49866 .49211 L
.50212 .48684 L
.50263 .48369 L
.5031 .48158 L
.50422 .47632 L
.50517 .47105 L
.50595 .46579 L
.50667 .46053 L
.50738 .45526 L
.50789 .45139 L
.50809 .45 L
s
1 g
.55 .48199 m
.54474 .48366 L
.53947 .48557 L
.53618 .48684 L
.53421 .48753 L
.52895 .48819 L
.52368 .49094 L
.52167 .49211 L
.51842 .49331 L
.51316 .49552 L
.50789 .49724 L
.50631 .49211 L
.50789 .49027 L
.51083 .48684 L
.51316 .48408 L
.51525 .48158 L
.51842 .47778 L
.51964 .47632 L
.52368 .47144 L
.52411 .47105 L
.52836 .46579 L
.52895 .46485 L
.53334 .46053 L
.53421 .45826 L
.53734 .45526 L
.53947 .45226 L
.54145 .45 L
.55 .45 L
F
0 g
.55 .48199 m
.54474 .48366 L
.53947 .48557 L
.53618 .48684 L
.53421 .48753 L
.52895 .48819 L
.52368 .49094 L
.52167 .49211 L
.51842 .49331 L
.51316 .49552 L
.50789 .49724 L
.50631 .49211 L
.50789 .49027 L
.51083 .48684 L
.51316 .48408 L
.51525 .48158 L
.51842 .47778 L
.51964 .47632 L
.52368 .47144 L
.52411 .47105 L
.52836 .46579 L
.52895 .46485 L
.53334 .46053 L
.53421 .45826 L
.53734 .45526 L
.53947 .45226 L
.54145 .45 L
s
1 g
.43313 .67461 m
.44713 .66061 L
.46113 .67461 L
.44713 .68861 L
.43313 .67461 L
F
.53887 .32539 m
.55287 .31139 L
.56687 .32539 L
.55287 .33939 L
.53887 .32539 L
F
.35144 .42072 m
.37144 .42072 L
.37144 .44072 L
.35144 .44072 L
.35144 .42072 L
F
.62856 .55928 m
.64856 .55928 L
.64856 .57928 L
.62856 .57928 L
.62856 .55928 L
F
0 g
.003 w
.43313 .67461 m
.44713 .66061 L
.46113 .67461 L
.44713 .68861 L
.43313 .67461 L
s
.53887 .32539 m
.55287 .31139 L
.56687 .32539 L
.55287 .33939 L
.53887 .32539 L
s
.35144 .42072 m
.37144 .42072 L
.37144 .44072 L
.35144 .44072 L
.35144 .42072 L
s
.62856 .55928 m
.64856 .55928 L
.64856 .57928 L
.62856 .57928 L
.62856 .55928 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 1 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.1 0.5 0.1 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.91.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.91.1"]
}, Open  ]],

Cell["\<\
Order stars of the second kind are useful in the study of stability for \
linear multistep methods.   \
\>", "Text",
 CellTags->{"S5.91.1", "1.26"}],

Cell[TextData[{
 "You can also plot the order star of the second kind. Note the poor \
resolution near the point of expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"1", ",", "0"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". There is not a similar problem near the origin because extra work is done \
there by default. "
}], "MathCaption",
 CellTags->{"S5.91.1", "1.27"}],

Cell[CellGroupData[{

Cell["\<\
OrderStar[ Pade[ Log[1+z], {z, 1, 3, 2}], Log[1+z],
              OrderStarKind -> Second,
              PlotPoints -> 50,
           PlotRange -> {{-.5, 2},{-1, 1}} ]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.91.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.8 [
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.8 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.2 0.4 0.4 0.4 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .8 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .8 L
s
0 .8 m
1 .8 L
s
1 0 m
1 .8 L
s
0 .4 m
1 .4 L
s
.2 0 m
.2 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
.5 g
0 .8 m
1 .8 L
1 0 L
0 0 L
F
1 g
0 .12632 m
.02041 .12605 L
.04082 .12651 L
.06122 .12767 L
.08163 .12953 L
.09083 .13061 L
.10204 .13206 L
.12245 .13523 L
.14286 .13907 L
.16327 .14355 L
.17666 .14694 L
.18367 .14866 L
.20408 .15438 L
.22449 .16078 L
.23112 .16327 L
.2449 .16775 L
.26531 .17539 L
.27484 .17959 L
.28571 .18363 L
.30612 .19257 L
.31196 .19592 L
.32653 .20203 L
.34663 .21224 L
.34694 .21238 L
.36735 .2231 L
.37468 .22857 L
.38776 .23448 L
.4038 .2449 L
.40816 .24672 L
.42857 .25994 L
.43039 .26122 L
.44898 .27328 L
.45446 .27755 L
.46939 .28709 L
.47713 .29388 L
.4898 .30104 L
.49855 .3102 L
.5102 .31938 L
.51887 .32653 L
.53061 .33624 L
.53818 .34286 L
.55102 .35402 L
.55653 .35918 L
.57143 .37298 L
.57393 .37551 L
.59184 .39184 L
.59184 .40816 L
.57393 .42449 L
.59184 .43492 L
.60804 .44082 L
.61224 .4533 L
.61316 .45714 L
.61614 .47347 L
.62061 .4898 L
.62269 .50612 L
.62432 .52245 L
.62574 .53878 L
.62699 .5551 L
.62803 .57143 L
.62882 .58776 L
.62935 .60408 L
.6296 .62041 L
.62957 .63673 L
.62924 .65306 L
.62862 .66939 L
.6277 .68571 L
.62649 .70204 L
.62499 .71837 L
.6232 .73469 L
.62111 .75102 L
.61873 .76735 L
.61606 .78367 L
.6131 .8 L
0 .8 L
F
0 g
.5 Mabswid
0 .12632 m
.02041 .12605 L
.04082 .12651 L
.06122 .12767 L
.08163 .12953 L
.09083 .13061 L
.10204 .13206 L
.12245 .13523 L
.14286 .13907 L
.16327 .14355 L
.17666 .14694 L
.18367 .14866 L
.20408 .15438 L
.22449 .16078 L
.23112 .16327 L
.2449 .16775 L
.26531 .17539 L
.27484 .17959 L
.28571 .18363 L
.30612 .19257 L
.31196 .19592 L
.32653 .20203 L
.34663 .21224 L
.34694 .21238 L
.36735 .2231 L
.37468 .22857 L
.38776 .23448 L
.4038 .2449 L
.40816 .24672 L
.42857 .25994 L
.43039 .26122 L
.44898 .27328 L
.45446 .27755 L
.46939 .28709 L
.47713 .29388 L
.4898 .30104 L
.49855 .3102 L
.5102 .31938 L
.51887 .32653 L
.53061 .33624 L
.53818 .34286 L
.55102 .35402 L
.55653 .35918 L
.57143 .37298 L
.57393 .37551 L
.59184 .39184 L
.59184 .40816 L
.57393 .42449 L
.59184 .43492 L
.60804 .44082 L
Mistroke
.61224 .4533 L
.61316 .45714 L
.61614 .47347 L
.62061 .4898 L
.62269 .50612 L
.62432 .52245 L
.62574 .53878 L
.62699 .5551 L
.62803 .57143 L
.62882 .58776 L
.62935 .60408 L
.6296 .62041 L
.62957 .63673 L
.62924 .65306 L
.62862 .66939 L
.6277 .68571 L
.62649 .70204 L
.62499 .71837 L
.6232 .73469 L
.62111 .75102 L
.61873 .76735 L
.61606 .78367 L
.6131 .8 L
Mfstroke
.5 g
0 .67368 m
.02041 .67395 L
.04082 .67349 L
.06122 .67233 L
.08163 .67047 L
.09083 .66939 L
.10204 .66794 L
.12245 .66477 L
.14286 .66093 L
.16327 .65645 L
.17666 .65306 L
.18367 .65134 L
.20408 .64562 L
.22449 .63922 L
.23112 .63673 L
.2449 .63225 L
.26531 .62461 L
.27484 .62041 L
.28571 .61637 L
.30612 .60743 L
.31196 .60408 L
.32653 .59797 L
.34663 .58776 L
.34694 .58762 L
.36735 .5769 L
.37468 .57143 L
.38776 .56552 L
.4038 .5551 L
.40816 .55328 L
.42857 .54006 L
.43039 .53878 L
.44898 .52672 L
.45446 .52245 L
.46939 .51291 L
.47713 .50612 L
.4898 .49896 L
.49855 .4898 L
.5102 .48062 L
.51887 .47347 L
.53061 .46376 L
.53818 .45714 L
.55102 .44598 L
.55653 .44082 L
.57143 .42702 L
.58939 .44082 L
.58378 .45714 L
.57715 .47347 L
.57143 .48751 L
.57007 .4898 L
.56406 .50612 L
.55694 .52245 L
.55102 .53534 L
.54912 .53878 L
.53966 .5551 L
.53157 .57143 L
.53061 .57766 L
.52367 .58776 L
.51396 .60408 L
.5102 .61356 L
.50486 .62041 L
.49416 .63673 L
.4898 .64516 L
.4836 .65306 L
.47203 .66939 L
.46939 .67379 L
.45983 .68571 L
.44898 .70027 L
.44731 .70204 L
.43345 .71837 L
.42857 .72459 L
.41912 .73469 L
.40816 .74701 L
.40405 .75102 L
.388 .76735 L
.38776 .76761 L
.37065 .78367 L
.36735 .78672 L
.35228 .8 L
0 .8 L
F
0 g
0 .67368 m
.02041 .67395 L
.04082 .67349 L
.06122 .67233 L
.08163 .67047 L
.09083 .66939 L
.10204 .66794 L
.12245 .66477 L
.14286 .66093 L
.16327 .65645 L
.17666 .65306 L
.18367 .65134 L
.20408 .64562 L
.22449 .63922 L
.23112 .63673 L
.2449 .63225 L
.26531 .62461 L
.27484 .62041 L
.28571 .61637 L
.30612 .60743 L
.31196 .60408 L
.32653 .59797 L
.34663 .58776 L
.34694 .58762 L
.36735 .5769 L
.37468 .57143 L
.38776 .56552 L
.4038 .5551 L
.40816 .55328 L
.42857 .54006 L
.43039 .53878 L
.44898 .52672 L
.45446 .52245 L
.46939 .51291 L
.47713 .50612 L
.4898 .49896 L
.49855 .4898 L
.5102 .48062 L
.51887 .47347 L
.53061 .46376 L
.53818 .45714 L
.55102 .44598 L
.55653 .44082 L
.57143 .42702 L
.58939 .44082 L
.58378 .45714 L
.57715 .47347 L
.57143 .48751 L
.57007 .4898 L
.56406 .50612 L
Mistroke
.55694 .52245 L
.55102 .53534 L
.54912 .53878 L
.53966 .5551 L
.53157 .57143 L
.53061 .57766 L
.52367 .58776 L
.51396 .60408 L
.5102 .61356 L
.50486 .62041 L
.49416 .63673 L
.4898 .64516 L
.4836 .65306 L
.47203 .66939 L
.46939 .67379 L
.45983 .68571 L
.44898 .70027 L
.44731 .70204 L
.43345 .71837 L
.42857 .72459 L
.41912 .73469 L
.40816 .74701 L
.40405 .75102 L
.388 .76735 L
.38776 .76761 L
.37065 .78367 L
.36735 .78672 L
.35228 .8 L
Mfstroke
.5 g
0 .48145 m
.02041 .48228 L
.04082 .48273 L
.06122 .48282 L
.08163 .48257 L
.10204 .48202 L
.12245 .48116 L
.14286 .48003 L
.16327 .47864 L
.18367 .47699 L
.20408 .4751 L
.21924 .47347 L
.22449 .47298 L
.2449 .47065 L
.26531 .46811 L
.28571 .46534 L
.30612 .46236 L
.32653 .45918 L
.33883 .45714 L
.34694 .45585 L
.36735 .45238 L
.38776 .44867 L
.40816 .44472 L
.42727 .44082 L
.42857 .44061 L
.44898 .43685 L
.46939 .4325 L
.4898 .42761 L
.50099 .42449 L
.5102 .42256 L
.53061 .41744 L
.55102 .41218 L
.55782 .40816 L
.55782 .39184 L
.55102 .38782 L
.53061 .38256 L
.5102 .37744 L
.50099 .37551 L
.4898 .37239 L
.46939 .3675 L
.44898 .36315 L
.42857 .35939 L
.42727 .35918 L
.40816 .35528 L
.38776 .35133 L
.36735 .34762 L
.34694 .34415 L
.33883 .34286 L
.32653 .34082 L
.30612 .33764 L
.28571 .33466 L
.26531 .33189 L
.2449 .32935 L
.22449 .32702 L
.21924 .32653 L
.20408 .3249 L
.18367 .32301 L
.16327 .32136 L
.14286 .31997 L
.12245 .31884 L
.10204 .31798 L
.08163 .31743 L
.06122 .31718 L
.04082 .31727 L
.02041 .31772 L
0 .31855 L
F
0 g
0 .48145 m
.02041 .48228 L
.04082 .48273 L
.06122 .48282 L
.08163 .48257 L
.10204 .48202 L
.12245 .48116 L
.14286 .48003 L
.16327 .47864 L
.18367 .47699 L
.20408 .4751 L
.21924 .47347 L
.22449 .47298 L
.2449 .47065 L
.26531 .46811 L
.28571 .46534 L
.30612 .46236 L
.32653 .45918 L
.33883 .45714 L
.34694 .45585 L
.36735 .45238 L
.38776 .44867 L
.40816 .44472 L
.42727 .44082 L
.42857 .44061 L
.44898 .43685 L
.46939 .4325 L
.4898 .42761 L
.50099 .42449 L
.5102 .42256 L
.53061 .41744 L
.55102 .41218 L
.55782 .40816 L
.55782 .39184 L
.55102 .38782 L
.53061 .38256 L
.5102 .37744 L
.50099 .37551 L
.4898 .37239 L
.46939 .3675 L
.44898 .36315 L
.42857 .35939 L
.42727 .35918 L
.40816 .35528 L
.38776 .35133 L
.36735 .34762 L
.34694 .34415 L
.33883 .34286 L
.32653 .34082 L
.30612 .33764 L
Mistroke
.28571 .33466 L
.26531 .33189 L
.2449 .32935 L
.22449 .32702 L
.21924 .32653 L
.20408 .3249 L
.18367 .32301 L
.16327 .32136 L
.14286 .31997 L
.12245 .31884 L
.10204 .31798 L
.08163 .31743 L
.06122 .31718 L
.04082 .31727 L
.02041 .31772 L
0 .31855 L
Mfstroke
1 g
.6131 0 m
.61606 .01633 L
.61873 .03265 L
.62111 .04898 L
.6232 .06531 L
.62499 .08163 L
.62649 .09796 L
.6277 .11429 L
.62862 .13061 L
.62924 .14694 L
.62957 .16327 L
.6296 .17959 L
.62935 .19592 L
.62882 .21224 L
.62803 .22857 L
.62699 .2449 L
.62574 .26122 L
.62432 .27755 L
.62269 .29388 L
.62061 .3102 L
.61614 .32653 L
.61316 .34286 L
.61224 .3467 L
.60804 .35918 L
.59184 .36508 L
.58939 .35918 L
.58378 .34286 L
.57715 .32653 L
.57143 .31249 L
.57007 .3102 L
.56406 .29388 L
.55694 .27755 L
.55102 .26466 L
.54912 .26122 L
.53966 .2449 L
.53157 .22857 L
.53061 .22234 L
.52367 .21224 L
.51396 .19592 L
.5102 .18644 L
.50486 .17959 L
.49416 .16327 L
.4898 .15484 L
.4836 .14694 L
.47203 .13061 L
.46939 .12621 L
.45983 .11429 L
.44898 .09973 L
.44731 .09796 L
.43345 .08163 L
.42857 .07541 L
.41912 .06531 L
.40816 .05299 L
.40405 .04898 L
.388 .03265 L
.38776 .03239 L
.37065 .01633 L
.36735 .01328 L
.35228 0 L
F
0 g
.6131 0 m
.61606 .01633 L
.61873 .03265 L
.62111 .04898 L
.6232 .06531 L
.62499 .08163 L
.62649 .09796 L
.6277 .11429 L
.62862 .13061 L
.62924 .14694 L
.62957 .16327 L
.6296 .17959 L
.62935 .19592 L
.62882 .21224 L
.62803 .22857 L
.62699 .2449 L
.62574 .26122 L
.62432 .27755 L
.62269 .29388 L
.62061 .3102 L
.61614 .32653 L
.61316 .34286 L
.61224 .3467 L
.60804 .35918 L
.59184 .36508 L
.58939 .35918 L
.58378 .34286 L
.57715 .32653 L
.57143 .31249 L
.57007 .3102 L
.56406 .29388 L
.55694 .27755 L
.55102 .26466 L
.54912 .26122 L
.53966 .2449 L
.53157 .22857 L
.53061 .22234 L
.52367 .21224 L
.51396 .19592 L
.5102 .18644 L
.50486 .17959 L
.49416 .16327 L
.4898 .15484 L
.4836 .14694 L
.47203 .13061 L
.46939 .12621 L
.45983 .11429 L
.44898 .09973 L
.44731 .09796 L
.43345 .08163 L
Mistroke
.42857 .07541 L
.41912 .06531 L
.40816 .05299 L
.40405 .04898 L
.388 .03265 L
.38776 .03239 L
.37065 .01633 L
.36735 .01328 L
.35228 0 L
Mfstroke
1 g
1 .53293 m
.97959 .52498 L
.97334 .52245 L
.95918 .51716 L
.93878 .50944 L
.9304 .50612 L
.91837 .50186 L
.89796 .49439 L
.8859 .4898 L
.87755 .48706 L
.85714 .47985 L
.83921 .47347 L
.83673 .47273 L
.81633 .46582 L
.79592 .45893 L
.79063 .45714 L
.77551 .45236 L
.7551 .44575 L
.74009 .44082 L
.73469 .43946 L
.71429 .4336 L
.69388 .42693 L
.68723 .42449 L
.67347 .4205 L
.65306 .41428 L
.63265 .40871 L
.6318 .40816 L
.6318 .39184 L
.61224 .39047 L
.59207 .39184 L
.59207 .40816 L
.61224 .40952 L
.62252 .42449 L
.63265 .43427 L
.63843 .44082 L
.65306 .45667 L
.65347 .45714 L
.66747 .47347 L
.67347 .48055 L
.68107 .4898 L
.69388 .50563 L
.69438 .50612 L
.70694 .52245 L
.71429 .53376 L
.72001 .53878 L
.73241 .5551 L
.73469 .56055 L
.74327 .57143 L
.75407 .58776 L
.7551 .58975 L
.76501 .60408 L
.77517 .62041 L
.77551 .62102 L
.78551 .63673 L
.7952 .65306 L
.79592 .65437 L
.80484 .66939 L
.81406 .68571 L
.81633 .68996 L
.82306 .70204 L
.83178 .71837 L
.83673 .72805 L
.84022 .73469 L
.84845 .75102 L
.85638 .76735 L
.85714 .76897 L
.86412 .78367 L
.8716 .8 L
1 .8 L
F
0 g
1 .53293 m
.97959 .52498 L
.97334 .52245 L
.95918 .51716 L
.93878 .50944 L
.9304 .50612 L
.91837 .50186 L
.89796 .49439 L
.8859 .4898 L
.87755 .48706 L
.85714 .47985 L
.83921 .47347 L
.83673 .47273 L
.81633 .46582 L
.79592 .45893 L
.79063 .45714 L
.77551 .45236 L
.7551 .44575 L
.74009 .44082 L
.73469 .43946 L
.71429 .4336 L
.69388 .42693 L
.68723 .42449 L
.67347 .4205 L
.65306 .41428 L
.63265 .40871 L
.6318 .40816 L
.6318 .39184 L
.61224 .39047 L
.59207 .39184 L
.59207 .40816 L
.61224 .40952 L
.62252 .42449 L
.63265 .43427 L
.63843 .44082 L
.65306 .45667 L
.65347 .45714 L
.66747 .47347 L
.67347 .48055 L
.68107 .4898 L
.69388 .50563 L
.69438 .50612 L
.70694 .52245 L
.71429 .53376 L
.72001 .53878 L
.73241 .5551 L
.73469 .56055 L
.74327 .57143 L
.75407 .58776 L
.7551 .58975 L
Mistroke
.76501 .60408 L
.77517 .62041 L
.77551 .62102 L
.78551 .63673 L
.7952 .65306 L
.79592 .65437 L
.80484 .66939 L
.81406 .68571 L
.81633 .68996 L
.82306 .70204 L
.83178 .71837 L
.83673 .72805 L
.84022 .73469 L
.84845 .75102 L
.85638 .76735 L
.85714 .76897 L
.86412 .78367 L
.8716 .8 L
Mfstroke
1 g
1 .26707 m
.97959 .27502 L
.97334 .27755 L
.95918 .28284 L
.93878 .29056 L
.9304 .29388 L
.91837 .29814 L
.89796 .30561 L
.8859 .3102 L
.87755 .31294 L
.85714 .32015 L
.83921 .32653 L
.83673 .32727 L
.81633 .33418 L
.79592 .34107 L
.79063 .34286 L
.77551 .34764 L
.7551 .35425 L
.74009 .35918 L
.73469 .36054 L
.71429 .3664 L
.69388 .37307 L
.68723 .37551 L
.67347 .3795 L
.65306 .38572 L
.63265 .39129 L
.62252 .37551 L
.63265 .36573 L
.63843 .35918 L
.65306 .34333 L
.65347 .34286 L
.66747 .32653 L
.67347 .31945 L
.68107 .3102 L
.69388 .29437 L
.69438 .29388 L
.70694 .27755 L
.71429 .26624 L
.72001 .26122 L
.73241 .2449 L
.73469 .23945 L
.74327 .22857 L
.75407 .21224 L
.7551 .21025 L
.76501 .19592 L
.77517 .17959 L
.77551 .17898 L
.78551 .16327 L
.7952 .14694 L
.79592 .14563 L
.80484 .13061 L
.81406 .11429 L
.81633 .11004 L
.82306 .09796 L
.83178 .08163 L
.83673 .07195 L
.84022 .06531 L
.84845 .04898 L
.85638 .03265 L
.85714 .03103 L
.86412 .01633 L
.8716 0 L
1 0 L
F
0 g
1 .26707 m
.97959 .27502 L
.97334 .27755 L
.95918 .28284 L
.93878 .29056 L
.9304 .29388 L
.91837 .29814 L
.89796 .30561 L
.8859 .3102 L
.87755 .31294 L
.85714 .32015 L
.83921 .32653 L
.83673 .32727 L
.81633 .33418 L
.79592 .34107 L
.79063 .34286 L
.77551 .34764 L
.7551 .35425 L
.74009 .35918 L
.73469 .36054 L
.71429 .3664 L
.69388 .37307 L
.68723 .37551 L
.67347 .3795 L
.65306 .38572 L
.63265 .39129 L
.62252 .37551 L
.63265 .36573 L
.63843 .35918 L
.65306 .34333 L
.65347 .34286 L
.66747 .32653 L
.67347 .31945 L
.68107 .3102 L
.69388 .29437 L
.69438 .29388 L
.70694 .27755 L
.71429 .26624 L
.72001 .26122 L
.73241 .2449 L
.73469 .23945 L
.74327 .22857 L
.75407 .21224 L
.7551 .21025 L
.76501 .19592 L
.77517 .17959 L
.77551 .17898 L
.78551 .16327 L
.7952 .14694 L
.79592 .14563 L
Mistroke
.80484 .13061 L
.81406 .11429 L
.81633 .11004 L
.82306 .09796 L
.83178 .08163 L
.83673 .07195 L
.84022 .06531 L
.84845 .04898 L
.85638 .03265 L
.85714 .03103 L
.86412 .01633 L
.8716 0 L
Mfstroke
.5 g
.18 .44 m
.28 .44 L
.28 .36 L
.18 .36 L
F
1 g
-1.6672 .4 m
-1.6532 .386 L
-1.6392 .4 L
-1.6532 .414 L
-1.6672 .4 L
F
-0.3608 .4 m
-0.3468 .386 L
-0.3328 .4 L
-0.3468 .414 L
-0.3608 .4 L
F
-19.4742 .39 m
-19.4542 .39 L
-19.4542 .41 L
-19.4742 .41 L
-19.4742 .39 L
F
-0.73636 .39 m
-0.71636 .39 L
-0.71636 .41 L
-0.73636 .41 L
-0.73636 .39 L
F
.18993 .39 m
.20993 .39 L
.20993 .41 L
.18993 .41 L
.18993 .39 L
F
0 g
.003 w
.2 .39 m
.2 .41 L
s
.19 .4 m
.21 .4 L
s
.18993 .39 m
.20993 .39 L
.20993 .41 L
.18993 .41 L
.18993 .39 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.8 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.2 0.4 0.4 0.4 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .8 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .8 L
s
0 .8 m
1 .8 L
s
1 0 m
1 .8 L
s
0 .4 m
1 .4 L
s
.2 0 m
.2 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.91.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.91.1"]
}, Open  ]],

Cell[TextData[{
 "By default ",
 StyleBox["OrderStar", "MR"],
 " resolves fine features at the origin by overlaying a subplot. However, \
there may be times when you wish to disable this feature, or to resolve fine \
features in other specified regions. Increasing the overall ",
 StyleBox["PlotPoints", "MR"],
 " setting is an inefficient solution to this problem. The option ",
 StyleBox["OrderStarSubPlots", "MR"],
 " provides a mechanism for doing this.   "
}], "Text",
 CellTags->{"S5.91.1", "1.28"}],

Cell[TextData[{
 "By overlaying smaller contour plots in regions of poor resolution the \
figure is much improved. If no ",
 StyleBox["PlotPoints", "MR"],
 " option is specified for a particular subplot, a fraction of the value for \
the main plot is used. "
}], "MathCaption",
 CellTags->{"S5.91.1", "1.29"}],

Cell[CellGroupData[{

Cell["\<\
OrderStar[ Pade[ Log[1+z], {z, 1, 3, 2}], Log[1+z],
              OrderStarKind -> Second,
              PlotPoints -> 50,
           PlotRange -> {{-.5, 2},{-1, 1}},
              OrderStarSubPlots ->
                {{PlotRange ->  {{0.9, 1.1},{-0.1, 0.1}},
                  PlotPoints -> {20, 20}}} ]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.91.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.8 [
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.8 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.2 0.4 0.4 0.4 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .8 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .8 L
s
0 .8 m
1 .8 L
s
1 0 m
1 .8 L
s
0 .4 m
1 .4 L
s
.2 0 m
.2 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
.5 g
0 .8 m
1 .8 L
1 0 L
0 0 L
F
1 g
0 .12632 m
.02041 .12605 L
.04082 .12651 L
.06122 .12767 L
.08163 .12953 L
.09083 .13061 L
.10204 .13206 L
.12245 .13523 L
.14286 .13907 L
.16327 .14355 L
.17666 .14694 L
.18367 .14866 L
.20408 .15438 L
.22449 .16078 L
.23112 .16327 L
.2449 .16775 L
.26531 .17539 L
.27484 .17959 L
.28571 .18363 L
.30612 .19257 L
.31196 .19592 L
.32653 .20203 L
.34663 .21224 L
.34694 .21238 L
.36735 .2231 L
.37468 .22857 L
.38776 .23448 L
.4038 .2449 L
.40816 .24672 L
.42857 .25994 L
.43039 .26122 L
.44898 .27328 L
.45446 .27755 L
.46939 .28709 L
.47713 .29388 L
.4898 .30104 L
.49855 .3102 L
.5102 .31938 L
.51887 .32653 L
.53061 .33624 L
.53818 .34286 L
.55102 .35402 L
.55653 .35918 L
.57143 .37298 L
.57393 .37551 L
.59184 .39184 L
.59184 .40816 L
.57393 .42449 L
.59184 .43492 L
.60804 .44082 L
.61224 .4533 L
.61316 .45714 L
.61614 .47347 L
.62061 .4898 L
.62269 .50612 L
.62432 .52245 L
.62574 .53878 L
.62699 .5551 L
.62803 .57143 L
.62882 .58776 L
.62935 .60408 L
.6296 .62041 L
.62957 .63673 L
.62924 .65306 L
.62862 .66939 L
.6277 .68571 L
.62649 .70204 L
.62499 .71837 L
.6232 .73469 L
.62111 .75102 L
.61873 .76735 L
.61606 .78367 L
.6131 .8 L
0 .8 L
F
0 g
.5 Mabswid
0 .12632 m
.02041 .12605 L
.04082 .12651 L
.06122 .12767 L
.08163 .12953 L
.09083 .13061 L
.10204 .13206 L
.12245 .13523 L
.14286 .13907 L
.16327 .14355 L
.17666 .14694 L
.18367 .14866 L
.20408 .15438 L
.22449 .16078 L
.23112 .16327 L
.2449 .16775 L
.26531 .17539 L
.27484 .17959 L
.28571 .18363 L
.30612 .19257 L
.31196 .19592 L
.32653 .20203 L
.34663 .21224 L
.34694 .21238 L
.36735 .2231 L
.37468 .22857 L
.38776 .23448 L
.4038 .2449 L
.40816 .24672 L
.42857 .25994 L
.43039 .26122 L
.44898 .27328 L
.45446 .27755 L
.46939 .28709 L
.47713 .29388 L
.4898 .30104 L
.49855 .3102 L
.5102 .31938 L
.51887 .32653 L
.53061 .33624 L
.53818 .34286 L
.55102 .35402 L
.55653 .35918 L
.57143 .37298 L
.57393 .37551 L
.59184 .39184 L
.59184 .40816 L
.57393 .42449 L
.59184 .43492 L
.60804 .44082 L
Mistroke
.61224 .4533 L
.61316 .45714 L
.61614 .47347 L
.62061 .4898 L
.62269 .50612 L
.62432 .52245 L
.62574 .53878 L
.62699 .5551 L
.62803 .57143 L
.62882 .58776 L
.62935 .60408 L
.6296 .62041 L
.62957 .63673 L
.62924 .65306 L
.62862 .66939 L
.6277 .68571 L
.62649 .70204 L
.62499 .71837 L
.6232 .73469 L
.62111 .75102 L
.61873 .76735 L
.61606 .78367 L
.6131 .8 L
Mfstroke
.5 g
0 .67368 m
.02041 .67395 L
.04082 .67349 L
.06122 .67233 L
.08163 .67047 L
.09083 .66939 L
.10204 .66794 L
.12245 .66477 L
.14286 .66093 L
.16327 .65645 L
.17666 .65306 L
.18367 .65134 L
.20408 .64562 L
.22449 .63922 L
.23112 .63673 L
.2449 .63225 L
.26531 .62461 L
.27484 .62041 L
.28571 .61637 L
.30612 .60743 L
.31196 .60408 L
.32653 .59797 L
.34663 .58776 L
.34694 .58762 L
.36735 .5769 L
.37468 .57143 L
.38776 .56552 L
.4038 .5551 L
.40816 .55328 L
.42857 .54006 L
.43039 .53878 L
.44898 .52672 L
.45446 .52245 L
.46939 .51291 L
.47713 .50612 L
.4898 .49896 L
.49855 .4898 L
.5102 .48062 L
.51887 .47347 L
.53061 .46376 L
.53818 .45714 L
.55102 .44598 L
.55653 .44082 L
.57143 .42702 L
.58939 .44082 L
.58378 .45714 L
.57715 .47347 L
.57143 .48751 L
.57007 .4898 L
.56406 .50612 L
.55694 .52245 L
.55102 .53534 L
.54912 .53878 L
.53966 .5551 L
.53157 .57143 L
.53061 .57766 L
.52367 .58776 L
.51396 .60408 L
.5102 .61356 L
.50486 .62041 L
.49416 .63673 L
.4898 .64516 L
.4836 .65306 L
.47203 .66939 L
.46939 .67379 L
.45983 .68571 L
.44898 .70027 L
.44731 .70204 L
.43345 .71837 L
.42857 .72459 L
.41912 .73469 L
.40816 .74701 L
.40405 .75102 L
.388 .76735 L
.38776 .76761 L
.37065 .78367 L
.36735 .78672 L
.35228 .8 L
0 .8 L
F
0 g
0 .67368 m
.02041 .67395 L
.04082 .67349 L
.06122 .67233 L
.08163 .67047 L
.09083 .66939 L
.10204 .66794 L
.12245 .66477 L
.14286 .66093 L
.16327 .65645 L
.17666 .65306 L
.18367 .65134 L
.20408 .64562 L
.22449 .63922 L
.23112 .63673 L
.2449 .63225 L
.26531 .62461 L
.27484 .62041 L
.28571 .61637 L
.30612 .60743 L
.31196 .60408 L
.32653 .59797 L
.34663 .58776 L
.34694 .58762 L
.36735 .5769 L
.37468 .57143 L
.38776 .56552 L
.4038 .5551 L
.40816 .55328 L
.42857 .54006 L
.43039 .53878 L
.44898 .52672 L
.45446 .52245 L
.46939 .51291 L
.47713 .50612 L
.4898 .49896 L
.49855 .4898 L
.5102 .48062 L
.51887 .47347 L
.53061 .46376 L
.53818 .45714 L
.55102 .44598 L
.55653 .44082 L
.57143 .42702 L
.58939 .44082 L
.58378 .45714 L
.57715 .47347 L
.57143 .48751 L
.57007 .4898 L
.56406 .50612 L
Mistroke
.55694 .52245 L
.55102 .53534 L
.54912 .53878 L
.53966 .5551 L
.53157 .57143 L
.53061 .57766 L
.52367 .58776 L
.51396 .60408 L
.5102 .61356 L
.50486 .62041 L
.49416 .63673 L
.4898 .64516 L
.4836 .65306 L
.47203 .66939 L
.46939 .67379 L
.45983 .68571 L
.44898 .70027 L
.44731 .70204 L
.43345 .71837 L
.42857 .72459 L
.41912 .73469 L
.40816 .74701 L
.40405 .75102 L
.388 .76735 L
.38776 .76761 L
.37065 .78367 L
.36735 .78672 L
.35228 .8 L
Mfstroke
.5 g
0 .48145 m
.02041 .48228 L
.04082 .48273 L
.06122 .48282 L
.08163 .48257 L
.10204 .48202 L
.12245 .48116 L
.14286 .48003 L
.16327 .47864 L
.18367 .47699 L
.20408 .4751 L
.21924 .47347 L
.22449 .47298 L
.2449 .47065 L
.26531 .46811 L
.28571 .46534 L
.30612 .46236 L
.32653 .45918 L
.33883 .45714 L
.34694 .45585 L
.36735 .45238 L
.38776 .44867 L
.40816 .44472 L
.42727 .44082 L
.42857 .44061 L
.44898 .43685 L
.46939 .4325 L
.4898 .42761 L
.50099 .42449 L
.5102 .42256 L
.53061 .41744 L
.55102 .41218 L
.55782 .40816 L
.55782 .39184 L
.55102 .38782 L
.53061 .38256 L
.5102 .37744 L
.50099 .37551 L
.4898 .37239 L
.46939 .3675 L
.44898 .36315 L
.42857 .35939 L
.42727 .35918 L
.40816 .35528 L
.38776 .35133 L
.36735 .34762 L
.34694 .34415 L
.33883 .34286 L
.32653 .34082 L
.30612 .33764 L
.28571 .33466 L
.26531 .33189 L
.2449 .32935 L
.22449 .32702 L
.21924 .32653 L
.20408 .3249 L
.18367 .32301 L
.16327 .32136 L
.14286 .31997 L
.12245 .31884 L
.10204 .31798 L
.08163 .31743 L
.06122 .31718 L
.04082 .31727 L
.02041 .31772 L
0 .31855 L
F
0 g
0 .48145 m
.02041 .48228 L
.04082 .48273 L
.06122 .48282 L
.08163 .48257 L
.10204 .48202 L
.12245 .48116 L
.14286 .48003 L
.16327 .47864 L
.18367 .47699 L
.20408 .4751 L
.21924 .47347 L
.22449 .47298 L
.2449 .47065 L
.26531 .46811 L
.28571 .46534 L
.30612 .46236 L
.32653 .45918 L
.33883 .45714 L
.34694 .45585 L
.36735 .45238 L
.38776 .44867 L
.40816 .44472 L
.42727 .44082 L
.42857 .44061 L
.44898 .43685 L
.46939 .4325 L
.4898 .42761 L
.50099 .42449 L
.5102 .42256 L
.53061 .41744 L
.55102 .41218 L
.55782 .40816 L
.55782 .39184 L
.55102 .38782 L
.53061 .38256 L
.5102 .37744 L
.50099 .37551 L
.4898 .37239 L
.46939 .3675 L
.44898 .36315 L
.42857 .35939 L
.42727 .35918 L
.40816 .35528 L
.38776 .35133 L
.36735 .34762 L
.34694 .34415 L
.33883 .34286 L
.32653 .34082 L
.30612 .33764 L
Mistroke
.28571 .33466 L
.26531 .33189 L
.2449 .32935 L
.22449 .32702 L
.21924 .32653 L
.20408 .3249 L
.18367 .32301 L
.16327 .32136 L
.14286 .31997 L
.12245 .31884 L
.10204 .31798 L
.08163 .31743 L
.06122 .31718 L
.04082 .31727 L
.02041 .31772 L
0 .31855 L
Mfstroke
1 g
.6131 0 m
.61606 .01633 L
.61873 .03265 L
.62111 .04898 L
.6232 .06531 L
.62499 .08163 L
.62649 .09796 L
.6277 .11429 L
.62862 .13061 L
.62924 .14694 L
.62957 .16327 L
.6296 .17959 L
.62935 .19592 L
.62882 .21224 L
.62803 .22857 L
.62699 .2449 L
.62574 .26122 L
.62432 .27755 L
.62269 .29388 L
.62061 .3102 L
.61614 .32653 L
.61316 .34286 L
.61224 .3467 L
.60804 .35918 L
.59184 .36508 L
.58939 .35918 L
.58378 .34286 L
.57715 .32653 L
.57143 .31249 L
.57007 .3102 L
.56406 .29388 L
.55694 .27755 L
.55102 .26466 L
.54912 .26122 L
.53966 .2449 L
.53157 .22857 L
.53061 .22234 L
.52367 .21224 L
.51396 .19592 L
.5102 .18644 L
.50486 .17959 L
.49416 .16327 L
.4898 .15484 L
.4836 .14694 L
.47203 .13061 L
.46939 .12621 L
.45983 .11429 L
.44898 .09973 L
.44731 .09796 L
.43345 .08163 L
.42857 .07541 L
.41912 .06531 L
.40816 .05299 L
.40405 .04898 L
.388 .03265 L
.38776 .03239 L
.37065 .01633 L
.36735 .01328 L
.35228 0 L
F
0 g
.6131 0 m
.61606 .01633 L
.61873 .03265 L
.62111 .04898 L
.6232 .06531 L
.62499 .08163 L
.62649 .09796 L
.6277 .11429 L
.62862 .13061 L
.62924 .14694 L
.62957 .16327 L
.6296 .17959 L
.62935 .19592 L
.62882 .21224 L
.62803 .22857 L
.62699 .2449 L
.62574 .26122 L
.62432 .27755 L
.62269 .29388 L
.62061 .3102 L
.61614 .32653 L
.61316 .34286 L
.61224 .3467 L
.60804 .35918 L
.59184 .36508 L
.58939 .35918 L
.58378 .34286 L
.57715 .32653 L
.57143 .31249 L
.57007 .3102 L
.56406 .29388 L
.55694 .27755 L
.55102 .26466 L
.54912 .26122 L
.53966 .2449 L
.53157 .22857 L
.53061 .22234 L
.52367 .21224 L
.51396 .19592 L
.5102 .18644 L
.50486 .17959 L
.49416 .16327 L
.4898 .15484 L
.4836 .14694 L
.47203 .13061 L
.46939 .12621 L
.45983 .11429 L
.44898 .09973 L
.44731 .09796 L
.43345 .08163 L
Mistroke
.42857 .07541 L
.41912 .06531 L
.40816 .05299 L
.40405 .04898 L
.388 .03265 L
.38776 .03239 L
.37065 .01633 L
.36735 .01328 L
.35228 0 L
Mfstroke
1 g
1 .53293 m
.97959 .52498 L
.97334 .52245 L
.95918 .51716 L
.93878 .50944 L
.9304 .50612 L
.91837 .50186 L
.89796 .49439 L
.8859 .4898 L
.87755 .48706 L
.85714 .47985 L
.83921 .47347 L
.83673 .47273 L
.81633 .46582 L
.79592 .45893 L
.79063 .45714 L
.77551 .45236 L
.7551 .44575 L
.74009 .44082 L
.73469 .43946 L
.71429 .4336 L
.69388 .42693 L
.68723 .42449 L
.67347 .4205 L
.65306 .41428 L
.63265 .40871 L
.6318 .40816 L
.6318 .39184 L
.61224 .39047 L
.59207 .39184 L
.59207 .40816 L
.61224 .40952 L
.62252 .42449 L
.63265 .43427 L
.63843 .44082 L
.65306 .45667 L
.65347 .45714 L
.66747 .47347 L
.67347 .48055 L
.68107 .4898 L
.69388 .50563 L
.69438 .50612 L
.70694 .52245 L
.71429 .53376 L
.72001 .53878 L
.73241 .5551 L
.73469 .56055 L
.74327 .57143 L
.75407 .58776 L
.7551 .58975 L
.76501 .60408 L
.77517 .62041 L
.77551 .62102 L
.78551 .63673 L
.7952 .65306 L
.79592 .65437 L
.80484 .66939 L
.81406 .68571 L
.81633 .68996 L
.82306 .70204 L
.83178 .71837 L
.83673 .72805 L
.84022 .73469 L
.84845 .75102 L
.85638 .76735 L
.85714 .76897 L
.86412 .78367 L
.8716 .8 L
1 .8 L
F
0 g
1 .53293 m
.97959 .52498 L
.97334 .52245 L
.95918 .51716 L
.93878 .50944 L
.9304 .50612 L
.91837 .50186 L
.89796 .49439 L
.8859 .4898 L
.87755 .48706 L
.85714 .47985 L
.83921 .47347 L
.83673 .47273 L
.81633 .46582 L
.79592 .45893 L
.79063 .45714 L
.77551 .45236 L
.7551 .44575 L
.74009 .44082 L
.73469 .43946 L
.71429 .4336 L
.69388 .42693 L
.68723 .42449 L
.67347 .4205 L
.65306 .41428 L
.63265 .40871 L
.6318 .40816 L
.6318 .39184 L
.61224 .39047 L
.59207 .39184 L
.59207 .40816 L
.61224 .40952 L
.62252 .42449 L
.63265 .43427 L
.63843 .44082 L
.65306 .45667 L
.65347 .45714 L
.66747 .47347 L
.67347 .48055 L
.68107 .4898 L
.69388 .50563 L
.69438 .50612 L
.70694 .52245 L
.71429 .53376 L
.72001 .53878 L
.73241 .5551 L
.73469 .56055 L
.74327 .57143 L
.75407 .58776 L
.7551 .58975 L
Mistroke
.76501 .60408 L
.77517 .62041 L
.77551 .62102 L
.78551 .63673 L
.7952 .65306 L
.79592 .65437 L
.80484 .66939 L
.81406 .68571 L
.81633 .68996 L
.82306 .70204 L
.83178 .71837 L
.83673 .72805 L
.84022 .73469 L
.84845 .75102 L
.85638 .76735 L
.85714 .76897 L
.86412 .78367 L
.8716 .8 L
Mfstroke
1 g
1 .26707 m
.97959 .27502 L
.97334 .27755 L
.95918 .28284 L
.93878 .29056 L
.9304 .29388 L
.91837 .29814 L
.89796 .30561 L
.8859 .3102 L
.87755 .31294 L
.85714 .32015 L
.83921 .32653 L
.83673 .32727 L
.81633 .33418 L
.79592 .34107 L
.79063 .34286 L
.77551 .34764 L
.7551 .35425 L
.74009 .35918 L
.73469 .36054 L
.71429 .3664 L
.69388 .37307 L
.68723 .37551 L
.67347 .3795 L
.65306 .38572 L
.63265 .39129 L
.62252 .37551 L
.63265 .36573 L
.63843 .35918 L
.65306 .34333 L
.65347 .34286 L
.66747 .32653 L
.67347 .31945 L
.68107 .3102 L
.69388 .29437 L
.69438 .29388 L
.70694 .27755 L
.71429 .26624 L
.72001 .26122 L
.73241 .2449 L
.73469 .23945 L
.74327 .22857 L
.75407 .21224 L
.7551 .21025 L
.76501 .19592 L
.77517 .17959 L
.77551 .17898 L
.78551 .16327 L
.7952 .14694 L
.79592 .14563 L
.80484 .13061 L
.81406 .11429 L
.81633 .11004 L
.82306 .09796 L
.83178 .08163 L
.83673 .07195 L
.84022 .06531 L
.84845 .04898 L
.85638 .03265 L
.85714 .03103 L
.86412 .01633 L
.8716 0 L
1 0 L
F
0 g
1 .26707 m
.97959 .27502 L
.97334 .27755 L
.95918 .28284 L
.93878 .29056 L
.9304 .29388 L
.91837 .29814 L
.89796 .30561 L
.8859 .3102 L
.87755 .31294 L
.85714 .32015 L
.83921 .32653 L
.83673 .32727 L
.81633 .33418 L
.79592 .34107 L
.79063 .34286 L
.77551 .34764 L
.7551 .35425 L
.74009 .35918 L
.73469 .36054 L
.71429 .3664 L
.69388 .37307 L
.68723 .37551 L
.67347 .3795 L
.65306 .38572 L
.63265 .39129 L
.62252 .37551 L
.63265 .36573 L
.63843 .35918 L
.65306 .34333 L
.65347 .34286 L
.66747 .32653 L
.67347 .31945 L
.68107 .3102 L
.69388 .29437 L
.69438 .29388 L
.70694 .27755 L
.71429 .26624 L
.72001 .26122 L
.73241 .2449 L
.73469 .23945 L
.74327 .22857 L
.75407 .21224 L
.7551 .21025 L
.76501 .19592 L
.77517 .17959 L
.77551 .17898 L
.78551 .16327 L
.7952 .14694 L
.79592 .14563 L
Mistroke
.80484 .13061 L
.81406 .11429 L
.81633 .11004 L
.82306 .09796 L
.83178 .08163 L
.83673 .07195 L
.84022 .06531 L
.84845 .04898 L
.85638 .03265 L
.85714 .03103 L
.86412 .01633 L
.8716 0 L
Mfstroke
.5 g
.56 .44 m
.64 .44 L
.64 .36 L
.56 .36 L
F
1 g
.56 .38955 m
.56421 .39049 L
.56842 .39154 L
.57263 .39271 L
.57598 .39368 L
.57684 .39389 L
.58105 .39503 L
.58526 .3962 L
.58947 .3973 L
.59368 .39789 L
.59368 .40211 L
.59368 .40211 L
.59368 .40211 L
.59368 .39789 L
.59368 .39789 L
.59363 .39368 L
.58947 .38961 L
.58933 .38947 L
.58526 .38552 L
.58499 .38526 L
.58105 .38148 L
.5806 .38105 L
.57684 .37748 L
.57617 .37684 L
.57263 .37352 L
.57142 .37263 L
.56842 .36902 L
.5669 .36842 L
.56421 .36538 L
.56256 .36421 L
.56 .36188 L
F
0 g
.56 .38955 m
.56421 .39049 L
.56842 .39154 L
.57263 .39271 L
.57598 .39368 L
.57684 .39389 L
.58105 .39503 L
.58526 .3962 L
.58947 .3973 L
.59368 .39789 L
.59368 .40211 L
.59368 .40211 L
.59368 .40211 L
.59368 .39789 L
.59368 .39789 L
.59363 .39368 L
.58947 .38961 L
.58933 .38947 L
.58526 .38552 L
.58499 .38526 L
.58105 .38148 L
.5806 .38105 L
.57684 .37748 L
.57617 .37684 L
.57263 .37352 L
.57142 .37263 L
.56842 .36902 L
.5669 .36842 L
.56421 .36538 L
.56256 .36421 L
.56 .36188 L
s
1 g
.56 .43812 m
.56256 .43579 L
.56421 .43462 L
.5669 .43158 L
.56842 .43098 L
.57142 .42737 L
.57263 .42648 L
.57617 .42316 L
.57684 .42252 L
.5806 .41895 L
.58105 .41852 L
.58499 .41474 L
.58526 .41448 L
.58933 .41053 L
.58947 .41039 L
.59363 .40632 L
.58947 .4027 L
.58526 .4038 L
.58105 .40497 L
.57684 .40611 L
.57598 .40632 L
.57263 .40729 L
.56842 .40846 L
.56421 .40951 L
.56 .41045 L
F
0 g
.56 .43812 m
.56256 .43579 L
.56421 .43462 L
.5669 .43158 L
.56842 .43098 L
.57142 .42737 L
.57263 .42648 L
.57617 .42316 L
.57684 .42252 L
.5806 .41895 L
.58105 .41852 L
.58499 .41474 L
.58526 .41448 L
.58933 .41053 L
.58947 .41039 L
.59363 .40632 L
.58947 .4027 L
.58526 .4038 L
.58105 .40497 L
.57684 .40611 L
.57598 .40632 L
.57263 .40729 L
.56842 .40846 L
.56421 .40951 L
.56 .41045 L
s
1 g
.63817 .44 m
.63579 .4374 L
.63459 .43579 L
.63158 .43304 L
.6309 .43158 L
.62737 .42853 L
.62649 .42737 L
.62316 .42382 L
.62253 .42316 L
.61895 .41939 L
.61852 .41895 L
.61474 .41501 L
.61448 .41474 L
.61053 .41067 L
.61039 .41053 L
.60632 .40644 L
.60618 .40632 L
.60211 .40211 L
.60211 .40211 L
.60211 .39789 L
.60211 .39789 L
.60618 .39368 L
.60211 .39085 L
.59789 .39079 L
.59727 .38947 L
.59603 .38526 L
.59473 .38105 L
.59368 .37759 L
.59341 .37684 L
.59194 .37263 L
.59059 .36842 L
.58953 .36421 L
.58947 .36393 L
.58817 .36 L
.64 .36 L
.64 .44 L
F
0 g
.63817 .44 m
.63579 .4374 L
.63459 .43579 L
.63158 .43304 L
.6309 .43158 L
.62737 .42853 L
.62649 .42737 L
.62316 .42382 L
.62253 .42316 L
.61895 .41939 L
.61852 .41895 L
.61474 .41501 L
.61448 .41474 L
.61053 .41067 L
.61039 .41053 L
.60632 .40644 L
.60618 .40632 L
.60211 .40211 L
.60211 .40211 L
.60211 .39789 L
.60211 .39789 L
.60618 .39368 L
.60211 .39085 L
.59789 .39079 L
.59727 .38947 L
.59603 .38526 L
.59473 .38105 L
.59368 .37759 L
.59341 .37684 L
.59194 .37263 L
.59059 .36842 L
.58953 .36421 L
.58947 .36393 L
.58817 .36 L
s
1 g
.60975 .44 m
.60887 .43579 L
.60791 .43158 L
.60689 .42737 L
.60632 .42517 L
.60585 .42316 L
.6048 .41895 L
.60372 .41474 L
.60268 .41053 L
.60211 .40915 L
.59789 .40921 L
.59727 .41053 L
.59603 .41474 L
.59473 .41895 L
.59368 .42241 L
.59341 .42316 L
.59194 .42737 L
.59059 .43158 L
.58953 .43579 L
.58947 .43607 L
.58817 .44 L
F
0 g
.60975 .44 m
.60887 .43579 L
.60791 .43158 L
.60689 .42737 L
.60632 .42517 L
.60585 .42316 L
.6048 .41895 L
.60372 .41474 L
.60268 .41053 L
.60211 .40915 L
.59789 .40921 L
.59727 .41053 L
.59603 .41474 L
.59473 .41895 L
.59368 .42241 L
.59341 .42316 L
.59194 .42737 L
.59059 .43158 L
.58953 .43579 L
.58947 .43607 L
.58817 .44 L
s
.5 g
.63817 .36 m
.63579 .3626 L
.63459 .36421 L
.63158 .36696 L
.6309 .36842 L
.62737 .37147 L
.62649 .37263 L
.62316 .37618 L
.62253 .37684 L
.61895 .38061 L
.61852 .38105 L
.61474 .38499 L
.61448 .38526 L
.61053 .38933 L
.61039 .38947 L
.60632 .39356 L
.60268 .38947 L
.60372 .38526 L
.6048 .38105 L
.60585 .37684 L
.60632 .37483 L
.60689 .37263 L
.60791 .36842 L
.60887 .36421 L
.60975 .36 L
F
0 g
.63817 .36 m
.63579 .3626 L
.63459 .36421 L
.63158 .36696 L
.6309 .36842 L
.62737 .37147 L
.62649 .37263 L
.62316 .37618 L
.62253 .37684 L
.61895 .38061 L
.61852 .38105 L
.61474 .38499 L
.61448 .38526 L
.61053 .38933 L
.61039 .38947 L
.60632 .39356 L
.60268 .38947 L
.60372 .38526 L
.6048 .38105 L
.60585 .37684 L
.60632 .37483 L
.60689 .37263 L
.60791 .36842 L
.60887 .36421 L
.60975 .36 L
s
.5 g
.64 .41101 m
.63831 .41053 L
.63579 .40992 L
.63158 .40882 L
.62737 .40759 L
.62323 .40632 L
.62316 .4063 L
.61895 .4051 L
.61474 .40388 L
.61053 .40272 L
.60632 .40211 L
.60632 .39789 L
.61053 .39728 L
.61474 .39612 L
.61895 .3949 L
.62316 .3937 L
.62323 .39368 L
.62737 .39241 L
.63158 .39118 L
.63579 .39008 L
.63831 .38947 L
.64 .38899 L
F
0 g
.64 .41101 m
.63831 .41053 L
.63579 .40992 L
.63158 .40882 L
.62737 .40759 L
.62323 .40632 L
.62316 .4063 L
.61895 .4051 L
.61474 .40388 L
.61053 .40272 L
.60632 .40211 L
.60632 .39789 L
.61053 .39728 L
.61474 .39612 L
.61895 .3949 L
.62316 .3937 L
.62323 .39368 L
.62737 .39241 L
.63158 .39118 L
.63579 .39008 L
.63831 .38947 L
.64 .38899 L
s
1 g
-1.6672 .4 m
-1.6532 .386 L
-1.6392 .4 L
-1.6532 .414 L
-1.6672 .4 L
F
-0.3608 .4 m
-0.3468 .386 L
-0.3328 .4 L
-0.3468 .414 L
-0.3608 .4 L
F
-19.4742 .39 m
-19.4542 .39 L
-19.4542 .41 L
-19.4742 .41 L
-19.4742 .39 L
F
-0.73636 .39 m
-0.71636 .39 L
-0.71636 .41 L
-0.73636 .41 L
-0.73636 .39 L
F
.18993 .39 m
.20993 .39 L
.20993 .41 L
.18993 .41 L
.18993 .39 L
F
0 g
.003 w
.2 .39 m
.2 .41 L
s
.19 .4 m
.21 .4 L
s
.18993 .39 m
.20993 .39 L
.20993 .41 L
.18993 .41 L
.18993 .39 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.8 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.2 0.4 0.4 0.4 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .8 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .8 L
s
0 .8 m
1 .8 L
s
1 0 m
1 .8 L
s
0 .4 m
1 .4 L
s
.2 0 m
.2 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.91.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.91.1"]
}, Open  ]],

Cell["\<\
Order stars provide a means of determining, at a glance, many important \
features of interest such as A\[Hyphen]stability. Furthermore, by considering \
a relative comparison with a function, order stars manage to encrypt the \
order of accuracy of a numerical scheme into the stability region.   \
\>", "Text",
 CellTags->{"S5.91.1", "1.30"}],

Cell[TextData[{
 "Here are only the zeros and poles of the approximant, since there are no \
finite zeros or poles of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", 
    RowBox[{"(", 
     StyleBox["z",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The numerical method corresponding to this approximant is \
A\[Hyphen]stable since the approximant has no poles in the left \
half\[Hyphen]plane. Furthermore a count of the sectors adjoining the origin \
tells you that the order of approximation is 5 (one less than the number of \
sectors). "
}], "MathCaption",
 CellTags->{"S5.91.1", "1.31"}],

Cell[CellGroupData[{

Cell["\<\
OrderStar[ Pade[ Exp[z], {z, 0, 2, 3}], Exp[z],
              OrderStarPoles -> {True, False},
              OrderStarZeros -> {True, False} ]\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.91.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .83251 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.832506 [
[ 0 0 0 0 ]
[ 1 .83251 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .83251 L
0 .83251 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.832506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.51518 0.083828 0.416253 0.083828 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .83251 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .83251 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .83251 L
s
0 .83251 m
1 .83251 L
s
1 0 m
1 .83251 L
s
0 .41625 m
1 .41625 L
s
.51518 0 m
.51518 .83251 L
s
0 0 m
1 0 L
1 .83251 L
0 .83251 L
closepath
clip
newpath
.5 g
0 .83251 m
1 .83251 L
1 0 L
0 0 L
F
1 g
.46835 .42884 m
.48101 .4252 L
.49367 .42191 L
.49984 .43206 L
.49367 .43809 L
.48935 .4426 L
.48101 .45108 L
.47903 .45314 L
.46882 .46367 L
.46835 .46416 L
.45866 .47421 L
.4557 .47728 L
.44847 .48475 L
.44304 .49169 L
.43677 .49529 L
.43038 .50413 L
.42748 .50583 L
.41772 .51619 L
.41743 .51636 L
.40629 .5269 L
.40506 .52873 L
.39546 .53744 L
.39241 .54098 L
.38443 .54798 L
.37975 .55279 L
.37301 .55852 L
.36709 .56412 L
.36107 .56905 L
.35443 .57492 L
.34848 .57959 L
.34177 .58514 L
.33507 .59013 L
.32911 .59471 L
.32054 .60067 L
.31646 .60356 L
.30447 .61121 L
.3038 .61164 L
.29114 .61894 L
.28571 .62175 L
.27848 .62534 L
.26582 .6308 L
.26189 .63228 L
.25316 .63528 L
.24051 .63869 L
.22785 .64094 L
.21519 .64193 L
.20253 .6415 L
.18987 .63941 L
.17722 .63529 L
.17008 .63228 L
.16456 .62842 L
.15596 .62175 L
.1519 .61704 L
.1475 .61121 L
.14216 .60067 L
.13929 .59013 L
.13924 .58983 L
.13844 .57959 L
.13924 .57061 L
.13951 .56905 L
.14242 .55852 L
.14746 .54798 L
.1519 .54139 L
.15474 .53744 L
.16456 .52747 L
.16509 .5269 L
.17722 .51757 L
.17874 .51636 L
.18987 .50986 L
.19733 .50583 L
.20253 .50354 L
.21519 .49819 L
.22251 .49529 L
.22785 .49353 L
.24051 .48936 L
.25316 .48555 L
.2555 .48475 L
.26582 .48199 L
.27848 .4786 L
.29114 .47532 L
.29484 .47421 L
.3038 .47211 L
.31646 .46894 L
.32911 .46575 L
.33664 .46367 L
.34177 .46256 L
.35443 .45937 L
.36709 .45611 L
.37809 .45314 L
.37975 .45281 L
.39241 .44957 L
.40506 .4462 L
.41772 .44272 L
.41815 .4426 L
.43038 .43971 L
.44304 .43624 L
.4557 .43245 L
.45684 .43206 L
F
0 g
.5 Mabswid
.46835 .42884 m
.48101 .4252 L
.49367 .42191 L
.49984 .43206 L
.49367 .43809 L
.48935 .4426 L
.48101 .45108 L
.47903 .45314 L
.46882 .46367 L
.46835 .46416 L
.45866 .47421 L
.4557 .47728 L
.44847 .48475 L
.44304 .49169 L
.43677 .49529 L
.43038 .50413 L
.42748 .50583 L
.41772 .51619 L
.41743 .51636 L
.40629 .5269 L
.40506 .52873 L
.39546 .53744 L
.39241 .54098 L
.38443 .54798 L
.37975 .55279 L
.37301 .55852 L
.36709 .56412 L
.36107 .56905 L
.35443 .57492 L
.34848 .57959 L
.34177 .58514 L
.33507 .59013 L
.32911 .59471 L
.32054 .60067 L
.31646 .60356 L
.30447 .61121 L
.3038 .61164 L
.29114 .61894 L
.28571 .62175 L
.27848 .62534 L
.26582 .6308 L
.26189 .63228 L
.25316 .63528 L
.24051 .63869 L
.22785 .64094 L
.21519 .64193 L
.20253 .6415 L
.18987 .63941 L
.17722 .63529 L
.17008 .63228 L
Mistroke
.16456 .62842 L
.15596 .62175 L
.1519 .61704 L
.1475 .61121 L
.14216 .60067 L
.13929 .59013 L
.13924 .58983 L
.13844 .57959 L
.13924 .57061 L
.13951 .56905 L
.14242 .55852 L
.14746 .54798 L
.1519 .54139 L
.15474 .53744 L
.16456 .52747 L
.16509 .5269 L
.17722 .51757 L
.17874 .51636 L
.18987 .50986 L
.19733 .50583 L
.20253 .50354 L
.21519 .49819 L
.22251 .49529 L
.22785 .49353 L
.24051 .48936 L
.25316 .48555 L
.2555 .48475 L
.26582 .48199 L
.27848 .4786 L
.29114 .47532 L
.29484 .47421 L
.3038 .47211 L
.31646 .46894 L
.32911 .46575 L
.33664 .46367 L
.34177 .46256 L
.35443 .45937 L
.36709 .45611 L
.37809 .45314 L
.37975 .45281 L
.39241 .44957 L
.40506 .4462 L
.41772 .44272 L
.41815 .4426 L
.43038 .43971 L
.44304 .43624 L
.4557 .43245 L
.45684 .43206 L
.46835 .42884 L
Mfstroke
1 g
.44101 .83251 m
.44232 .82197 L
.44304 .81628 L
.44365 .81143 L
.445 .80089 L
.44637 .79035 L
.44776 .77982 L
.44917 .76928 L
.45061 .75874 L
.45206 .7482 L
.45354 .73766 L
.45504 .72713 L
.4557 .7226 L
.45657 .71659 L
.45812 .70605 L
.45969 .69551 L
.46129 .68497 L
.46293 .67444 L
.46458 .6639 L
.46627 .65336 L
.468 .64282 L
.46835 .64074 L
.46974 .63228 L
.47152 .62175 L
.47333 .61121 L
.47518 .60067 L
.47707 .59013 L
.47901 .57959 L
.48099 .56905 L
.48101 .56897 L
.48295 .55852 L
.48495 .54798 L
.48702 .53744 L
.48916 .5269 L
.4914 .51636 L
.49367 .50603 L
.49369 .50583 L
.4947 .49529 L
.49587 .48475 L
.49779 .47421 L
.50113 .46367 L
.50582 .45314 L
.50633 .45136 L
.50961 .4426 L
.51849 .43206 L
.50633 .42313 L
.4943 .42152 L
.4943 .41098 L
.49367 .4106 L
.48101 .4073 L
.46835 .40366 L
.45684 .40045 L
.4557 .40006 L
.44304 .39626 L
.43038 .3928 L
.41815 .38991 L
.41772 .38979 L
.40506 .38631 L
.39241 .38294 L
.37975 .3797 L
.37809 .37937 L
.36709 .3764 L
.35443 .37314 L
.34177 .36994 L
.33664 .36883 L
.32911 .36676 L
.31646 .36357 L
.3038 .36039 L
.29484 .35829 L
.29114 .35719 L
.27848 .3539 L
.26582 .35051 L
.2555 .34776 L
.25316 .34696 L
.24051 .34314 L
.22785 .33898 L
.22251 .33722 L
.21519 .33432 L
.20253 .32897 L
.19733 .32668 L
.18987 .32265 L
.17874 .31614 L
.17722 .31494 L
.16509 .3056 L
.16456 .30503 L
.15474 .29507 L
.1519 .29112 L
.14746 .28453 L
.14242 .27399 L
.13951 .26345 L
.13924 .2619 L
.13844 .25291 L
.13924 .24268 L
.13929 .24238 L
.14216 .23184 L
.1475 .2213 L
.1519 .21547 L
.15596 .21076 L
.16456 .20409 L
.17008 .20022 L
.17722 .19721 L
.18987 .19309 L
.20253 .19101 L
.21519 .19058 L
.22785 .19157 L
.24051 .19382 L
.25316 .19723 L
.26189 .20022 L
.26582 .2017 L
.27848 .20717 L
.28571 .21076 L
.29114 .21357 L
.3038 .22087 L
.30447 .2213 L
.31646 .22895 L
.32054 .23184 L
.32911 .2378 L
.33507 .24238 L
.34177 .24737 L
.34848 .25291 L
.35443 .25758 L
.36107 .26345 L
.36709 .26839 L
.37301 .27399 L
.37975 .27972 L
.38443 .28453 L
.39241 .29153 L
.39546 .29507 L
.40506 .30378 L
.40629 .3056 L
.41743 .31614 L
.41772 .31632 L
.42748 .32668 L
.43038 .32837 L
.43677 .33722 L
.44304 .34082 L
.44847 .34776 L
.4557 .35523 L
.45866 .35829 L
.46835 .36835 L
.46882 .36883 L
.47903 .37937 L
.48101 .38143 L
.48935 .38991 L
.49367 .39441 L
.49984 .40045 L
.50633 .40938 L
.51838 .41098 L
.51838 .42152 L
.51899 .4316 L
.519 .42152 L
.519 .41098 L
.51899 .4009 L
.51849 .40045 L
.50961 .38991 L
.50633 .38115 L
.50582 .37937 L
.50113 .36883 L
.49779 .35829 L
.49587 .34776 L
.4947 .33722 L
.49369 .32668 L
.49367 .32648 L
.4914 .31614 L
.48916 .3056 L
.48702 .29507 L
.48495 .28453 L
.48295 .27399 L
.48101 .26354 L
.48099 .26345 L
.47901 .25291 L
.47707 .24238 L
.47518 .23184 L
.47333 .2213 L
.47152 .21076 L
.46974 .20022 L
.46835 .19177 L
.468 .18968 L
.46627 .17915 L
.46458 .16861 L
.46293 .15807 L
.46129 .14753 L
.45969 .13699 L
.45812 .12646 L
.45657 .11592 L
.4557 .10991 L
.45504 .10538 L
.45354 .09484 L
.45206 .0843 L
.45061 .07377 L
.44917 .06323 L
.44776 .05269 L
.44637 .04215 L
.445 .03161 L
.44365 .02108 L
.44304 .01622 L
.44232 .01054 L
.44101 0 L
1 0 L
1 .83251 L
F
0 g
.44101 .83251 m
.44232 .82197 L
.44304 .81628 L
.44365 .81143 L
.445 .80089 L
.44637 .79035 L
.44776 .77982 L
.44917 .76928 L
.45061 .75874 L
.45206 .7482 L
.45354 .73766 L
.45504 .72713 L
.4557 .7226 L
.45657 .71659 L
.45812 .70605 L
.45969 .69551 L
.46129 .68497 L
.46293 .67444 L
.46458 .6639 L
.46627 .65336 L
.468 .64282 L
.46835 .64074 L
.46974 .63228 L
.47152 .62175 L
.47333 .61121 L
.47518 .60067 L
.47707 .59013 L
.47901 .57959 L
.48099 .56905 L
.48101 .56897 L
.48295 .55852 L
.48495 .54798 L
.48702 .53744 L
.48916 .5269 L
.4914 .51636 L
.49367 .50603 L
.49369 .50583 L
.4947 .49529 L
.49587 .48475 L
.49779 .47421 L
.50113 .46367 L
.50582 .45314 L
.50633 .45136 L
.50961 .4426 L
.51849 .43206 L
.50633 .42313 L
.4943 .42152 L
.4943 .41098 L
.49367 .4106 L
.48101 .4073 L
Mistroke
.46835 .40366 L
.45684 .40045 L
.4557 .40006 L
.44304 .39626 L
.43038 .3928 L
.41815 .38991 L
.41772 .38979 L
.40506 .38631 L
.39241 .38294 L
.37975 .3797 L
.37809 .37937 L
.36709 .3764 L
.35443 .37314 L
.34177 .36994 L
.33664 .36883 L
.32911 .36676 L
.31646 .36357 L
.3038 .36039 L
.29484 .35829 L
.29114 .35719 L
.27848 .3539 L
.26582 .35051 L
.2555 .34776 L
.25316 .34696 L
.24051 .34314 L
.22785 .33898 L
.22251 .33722 L
.21519 .33432 L
.20253 .32897 L
.19733 .32668 L
.18987 .32265 L
.17874 .31614 L
.17722 .31494 L
.16509 .3056 L
.16456 .30503 L
.15474 .29507 L
.1519 .29112 L
.14746 .28453 L
.14242 .27399 L
.13951 .26345 L
.13924 .2619 L
.13844 .25291 L
.13924 .24268 L
.13929 .24238 L
.14216 .23184 L
.1475 .2213 L
.1519 .21547 L
.15596 .21076 L
.16456 .20409 L
.17008 .20022 L
Mistroke
.17722 .19721 L
.18987 .19309 L
.20253 .19101 L
.21519 .19058 L
.22785 .19157 L
.24051 .19382 L
.25316 .19723 L
.26189 .20022 L
.26582 .2017 L
.27848 .20717 L
.28571 .21076 L
.29114 .21357 L
.3038 .22087 L
.30447 .2213 L
.31646 .22895 L
.32054 .23184 L
.32911 .2378 L
.33507 .24238 L
.34177 .24737 L
.34848 .25291 L
.35443 .25758 L
.36107 .26345 L
.36709 .26839 L
.37301 .27399 L
.37975 .27972 L
.38443 .28453 L
.39241 .29153 L
.39546 .29507 L
.40506 .30378 L
.40629 .3056 L
.41743 .31614 L
.41772 .31632 L
.42748 .32668 L
.43038 .32837 L
.43677 .33722 L
.44304 .34082 L
.44847 .34776 L
.4557 .35523 L
.45866 .35829 L
.46835 .36835 L
.46882 .36883 L
.47903 .37937 L
.48101 .38143 L
.48935 .38991 L
.49367 .39441 L
.49984 .40045 L
.50633 .40938 L
.51838 .41098 L
.51838 .42152 L
.51899 .4316 L
Mistroke
.519 .42152 L
.519 .41098 L
.51899 .4009 L
.51849 .40045 L
.50961 .38991 L
.50633 .38115 L
.50582 .37937 L
.50113 .36883 L
.49779 .35829 L
.49587 .34776 L
.4947 .33722 L
.49369 .32668 L
.49367 .32648 L
.4914 .31614 L
.48916 .3056 L
.48702 .29507 L
.48495 .28453 L
.48295 .27399 L
.48101 .26354 L
.48099 .26345 L
.47901 .25291 L
.47707 .24238 L
.47518 .23184 L
.47333 .2213 L
.47152 .21076 L
.46974 .20022 L
.46835 .19177 L
.468 .18968 L
.46627 .17915 L
.46458 .16861 L
.46293 .15807 L
.46129 .14753 L
.45969 .13699 L
.45812 .12646 L
.45657 .11592 L
.4557 .10991 L
.45504 .10538 L
.45354 .09484 L
.45206 .0843 L
.45061 .07377 L
.44917 .06323 L
.44776 .05269 L
.44637 .04215 L
.445 .03161 L
.44365 .02108 L
.44304 .01622 L
.44232 .01054 L
.44101 0 L
Mfstroke
.5 g
.72152 .11554 m
.72777 .11592 L
.73418 .11689 L
.74684 .12101 L
.75684 .12646 L
.75949 .12888 L
.76712 .13699 L
.77215 .14494 L
.77318 .14753 L
.77609 .15807 L
.77695 .16861 L
.7759 .17915 L
.77296 .18968 L
.77215 .19175 L
.76803 .20022 L
.76115 .21076 L
.75949 .21287 L
.75243 .2213 L
.74684 .22682 L
.74179 .23184 L
.73418 .23818 L
.7294 .24238 L
.72152 .24819 L
.7156 .25291 L
.70886 .25747 L
.70083 .26345 L
.6962 .26641 L
.68558 .27399 L
.68354 .27524 L
.67089 .28414 L
.67052 .28453 L
.65823 .29306 L
.65628 .29507 L
.64557 .30218 L
.64225 .3056 L
.63291 .31156 L
.62864 .31614 L
.62025 .32119 L
.61388 .32668 L
.60759 .33108 L
.60097 .33722 L
.59494 .34112 L
.58849 .34776 L
.58228 .35312 L
.57642 .35829 L
.56962 .36435 L
.5647 .36883 L
.55696 .37593 L
.5533 .37937 L
.5443 .38786 L
.5422 .38991 L
.53165 .40009 L
.52147 .38991 L
.52496 .37937 L
.52857 .36883 L
.53165 .35957 L
.53219 .35829 L
.53661 .34776 L
.54089 .33722 L
.54388 .32668 L
.5443 .3221 L
.54667 .31614 L
.55089 .3056 L
.55493 .29507 L
.55696 .28786 L
.55896 .28453 L
.5636 .27399 L
.56822 .26345 L
.56962 .25979 L
.57315 .25291 L
.57843 .24238 L
.58228 .23436 L
.58385 .23184 L
.5898 .2213 L
.59494 .21225 L
.59596 .21076 L
.60277 .20022 L
.60759 .19281 L
.60996 .18968 L
.6179 .17915 L
.62025 .17603 L
.62664 .16861 L
.63291 .16151 L
.63637 .15807 L
.64557 .1492 L
.64754 .14753 L
.65823 .13889 L
.66094 .13699 L
.67089 .1305 L
.67838 .12646 L
.68354 .12397 L
.6962 .11927 L
.70886 .11641 L
.71272 .11592 L
F
0 g
.72152 .11554 m
.72777 .11592 L
.73418 .11689 L
.74684 .12101 L
.75684 .12646 L
.75949 .12888 L
.76712 .13699 L
.77215 .14494 L
.77318 .14753 L
.77609 .15807 L
.77695 .16861 L
.7759 .17915 L
.77296 .18968 L
.77215 .19175 L
.76803 .20022 L
.76115 .21076 L
.75949 .21287 L
.75243 .2213 L
.74684 .22682 L
.74179 .23184 L
.73418 .23818 L
.7294 .24238 L
.72152 .24819 L
.7156 .25291 L
.70886 .25747 L
.70083 .26345 L
.6962 .26641 L
.68558 .27399 L
.68354 .27524 L
.67089 .28414 L
.67052 .28453 L
.65823 .29306 L
.65628 .29507 L
.64557 .30218 L
.64225 .3056 L
.63291 .31156 L
.62864 .31614 L
.62025 .32119 L
.61388 .32668 L
.60759 .33108 L
.60097 .33722 L
.59494 .34112 L
.58849 .34776 L
.58228 .35312 L
.57642 .35829 L
.56962 .36435 L
.5647 .36883 L
.55696 .37593 L
.5533 .37937 L
.5443 .38786 L
Mistroke
.5422 .38991 L
.53165 .40009 L
.52147 .38991 L
.52496 .37937 L
.52857 .36883 L
.53165 .35957 L
.53219 .35829 L
.53661 .34776 L
.54089 .33722 L
.54388 .32668 L
.5443 .3221 L
.54667 .31614 L
.55089 .3056 L
.55493 .29507 L
.55696 .28786 L
.55896 .28453 L
.5636 .27399 L
.56822 .26345 L
.56962 .25979 L
.57315 .25291 L
.57843 .24238 L
.58228 .23436 L
.58385 .23184 L
.5898 .2213 L
.59494 .21225 L
.59596 .21076 L
.60277 .20022 L
.60759 .19281 L
.60996 .18968 L
.6179 .17915 L
.62025 .17603 L
.62664 .16861 L
.63291 .16151 L
.63637 .15807 L
.64557 .1492 L
.64754 .14753 L
.65823 .13889 L
.66094 .13699 L
.67089 .1305 L
.67838 .12646 L
.68354 .12397 L
.6962 .11927 L
.70886 .11641 L
.71272 .11592 L
.72152 .11554 L
Mfstroke
.5 g
.53165 .43242 m
.5422 .4426 L
.5443 .44465 L
.5533 .45314 L
.55696 .45658 L
.5647 .46367 L
.56962 .46816 L
.57642 .47421 L
.58228 .47939 L
.58849 .48475 L
.59494 .49139 L
.60097 .49529 L
.60759 .50143 L
.61388 .50583 L
.62025 .51131 L
.62864 .51636 L
.63291 .52095 L
.64225 .5269 L
.64557 .53032 L
.65628 .53744 L
.65823 .53945 L
.67052 .54798 L
.67089 .54837 L
.68354 .55726 L
.68558 .55852 L
.6962 .5661 L
.70083 .56905 L
.70886 .57503 L
.7156 .57959 L
.72152 .58432 L
.7294 .59013 L
.73418 .59432 L
.74179 .60067 L
.74684 .60568 L
.75243 .61121 L
.75949 .61964 L
.76115 .62175 L
.76803 .63228 L
.77215 .64075 L
.77296 .64282 L
.7759 .65336 L
.77695 .6639 L
.77609 .67444 L
.77318 .68497 L
.77215 .68757 L
.76712 .69551 L
.75949 .70363 L
.75684 .70605 L
.74684 .71149 L
.73418 .71562 L
.72777 .71659 L
.72152 .71697 L
.71272 .71659 L
.70886 .71609 L
.6962 .71324 L
.68354 .70853 L
.67838 .70605 L
.67089 .702 L
.66094 .69551 L
.65823 .69361 L
.64754 .68497 L
.64557 .6833 L
.63637 .67444 L
.63291 .671 L
.62664 .6639 L
.62025 .65648 L
.6179 .65336 L
.60996 .64282 L
.60759 .63969 L
.60277 .63228 L
.59596 .62175 L
.59494 .62026 L
.5898 .61121 L
.58385 .60067 L
.58228 .59815 L
.57843 .59013 L
.57315 .57959 L
.56962 .57271 L
.56822 .56905 L
.5636 .55852 L
.55896 .54798 L
.55696 .54464 L
.55493 .53744 L
.55089 .5269 L
.54667 .51636 L
.5443 .51041 L
.54388 .50583 L
.54089 .49529 L
.53661 .48475 L
.53219 .47421 L
.53165 .47294 L
.52857 .46367 L
.52496 .45314 L
.52147 .4426 L
F
0 g
.53165 .43242 m
.5422 .4426 L
.5443 .44465 L
.5533 .45314 L
.55696 .45658 L
.5647 .46367 L
.56962 .46816 L
.57642 .47421 L
.58228 .47939 L
.58849 .48475 L
.59494 .49139 L
.60097 .49529 L
.60759 .50143 L
.61388 .50583 L
.62025 .51131 L
.62864 .51636 L
.63291 .52095 L
.64225 .5269 L
.64557 .53032 L
.65628 .53744 L
.65823 .53945 L
.67052 .54798 L
.67089 .54837 L
.68354 .55726 L
.68558 .55852 L
.6962 .5661 L
.70083 .56905 L
.70886 .57503 L
.7156 .57959 L
.72152 .58432 L
.7294 .59013 L
.73418 .59432 L
.74179 .60067 L
.74684 .60568 L
.75243 .61121 L
.75949 .61964 L
.76115 .62175 L
.76803 .63228 L
.77215 .64075 L
.77296 .64282 L
.7759 .65336 L
.77695 .6639 L
.77609 .67444 L
.77318 .68497 L
.77215 .68757 L
.76712 .69551 L
.75949 .70363 L
.75684 .70605 L
.74684 .71149 L
.73418 .71562 L
Mistroke
.72777 .71659 L
.72152 .71697 L
.71272 .71659 L
.70886 .71609 L
.6962 .71324 L
.68354 .70853 L
.67838 .70605 L
.67089 .702 L
.66094 .69551 L
.65823 .69361 L
.64754 .68497 L
.64557 .6833 L
.63637 .67444 L
.63291 .671 L
.62664 .6639 L
.62025 .65648 L
.6179 .65336 L
.60996 .64282 L
.60759 .63969 L
.60277 .63228 L
.59596 .62175 L
.59494 .62026 L
.5898 .61121 L
.58385 .60067 L
.58228 .59815 L
.57843 .59013 L
.57315 .57959 L
.56962 .57271 L
.56822 .56905 L
.5636 .55852 L
.55896 .54798 L
.55696 .54464 L
.55493 .53744 L
.55089 .5269 L
.54667 .51636 L
.5443 .51041 L
.54388 .50583 L
.54089 .49529 L
.53661 .48475 L
.53219 .47421 L
.53165 .47294 L
.52857 .46367 L
.52496 .45314 L
.52147 .4426 L
.53165 .43242 L
Mfstroke
.5 g
.73418 .36785 m
.74684 .36651 L
.75949 .36564 L
.77215 .36541 L
.78481 .366 L
.79747 .3677 L
.80276 .36883 L
.81013 .37094 L
.82278 .37644 L
.82826 .37937 L
.83544 .38572 L
.83933 .38991 L
.84558 .40045 L
.8481 .40789 L
.84854 .41098 L
.84854 .42152 L
.8481 .42462 L
.84558 .43206 L
.83933 .4426 L
.83544 .44679 L
.82826 .45314 L
.82278 .45606 L
.81013 .46157 L
.80276 .46367 L
.79747 .46481 L
.78481 .4665 L
.77215 .4671 L
.75949 .46686 L
.74684 .466 L
.73418 .46465 L
.72712 .46367 L
.72152 .46295 L
.70886 .46097 L
.6962 .45878 L
.68354 .45639 L
.67089 .45386 L
.66743 .45314 L
.65823 .45128 L
.64557 .44858 L
.63291 .44573 L
.62025 .44277 L
.61956 .4426 L
.60759 .44014 L
.59494 .43714 L
.58228 .43379 L
.57654 .43206 L
.56962 .43041 L
.55696 .42703 L
.5443 .42362 L
.54065 .42152 L
.54065 .41098 L
.5443 .40888 L
.55696 .40548 L
.56962 .40209 L
.57654 .40045 L
.58228 .39871 L
.59494 .39536 L
.60759 .39237 L
.61956 .38991 L
.62025 .38974 L
.63291 .38677 L
.64557 .38393 L
.65823 .38123 L
.66743 .37937 L
.67089 .37865 L
.68354 .37611 L
.6962 .37373 L
.70886 .37153 L
.72152 .36956 L
.72712 .36883 L
F
0 g
.73418 .36785 m
.74684 .36651 L
.75949 .36564 L
.77215 .36541 L
.78481 .366 L
.79747 .3677 L
.80276 .36883 L
.81013 .37094 L
.82278 .37644 L
.82826 .37937 L
.83544 .38572 L
.83933 .38991 L
.84558 .40045 L
.8481 .40789 L
.84854 .41098 L
.84854 .42152 L
.8481 .42462 L
.84558 .43206 L
.83933 .4426 L
.83544 .44679 L
.82826 .45314 L
.82278 .45606 L
.81013 .46157 L
.80276 .46367 L
.79747 .46481 L
.78481 .4665 L
.77215 .4671 L
.75949 .46686 L
.74684 .466 L
.73418 .46465 L
.72712 .46367 L
.72152 .46295 L
.70886 .46097 L
.6962 .45878 L
.68354 .45639 L
.67089 .45386 L
.66743 .45314 L
.65823 .45128 L
.64557 .44858 L
.63291 .44573 L
.62025 .44277 L
.61956 .4426 L
.60759 .44014 L
.59494 .43714 L
.58228 .43379 L
.57654 .43206 L
.56962 .43041 L
.55696 .42703 L
.5443 .42362 L
.54065 .42152 L
Mistroke
.54065 .41098 L
.5443 .40888 L
.55696 .40548 L
.56962 .40209 L
.57654 .40045 L
.58228 .39871 L
.59494 .39536 L
.60759 .39237 L
.61956 .38991 L
.62025 .38974 L
.63291 .38677 L
.64557 .38393 L
.65823 .38123 L
.66743 .37937 L
.67089 .37865 L
.68354 .37611 L
.6962 .37373 L
.70886 .37153 L
.72152 .36956 L
.72712 .36883 L
.73418 .36785 L
Mfstroke
1 g
.46366 .45788 m
.56366 .45788 L
.56366 .37463 L
.46366 .37463 L
F
.5 g
.46366 .40227 m
.46455 .40238 L
.46623 .40297 L
.46879 .40367 L
.47135 .40437 L
.47177 .40451 L
.47392 .40507 L
.47648 .40577 L
.47905 .40647 L
.47948 .40665 L
.48161 .40716 L
.48417 .40786 L
.48674 .40856 L
.48752 .40878 L
.4893 .40925 L
.49187 .40994 L
.49443 .41065 L
.49537 .41092 L
.497 .41129 L
.49956 .41196 L
.50212 .4127 L
.50318 .41305 L
.50469 .41344 L
.50725 .41417 L
.50982 .41488 L
.51033 .41519 L
.51033 .41732 L
.51238 .4191 L
.51473 .41945 L
.51405 .42159 L
.51331 .42372 L
.51266 .42586 L
.51238 .42693 L
.51202 .42799 L
.51134 .43013 L
.51074 .43226 L
.51025 .4344 L
.50986 .43653 L
.50982 .43683 L
.50933 .43867 L
.50878 .4408 L
.50825 .44294 L
.50773 .44507 L
.50725 .44714 L
.50722 .44721 L
.50669 .44934 L
.50616 .45147 L
.50564 .45361 L
.50512 .45574 L
.50469 .45706 L
.50462 .45788 L
.46366 .45788 L
F
0 g
.46366 .40227 m
.46455 .40238 L
.46623 .40297 L
.46879 .40367 L
.47135 .40437 L
.47177 .40451 L
.47392 .40507 L
.47648 .40577 L
.47905 .40647 L
.47948 .40665 L
.48161 .40716 L
.48417 .40786 L
.48674 .40856 L
.48752 .40878 L
.4893 .40925 L
.49187 .40994 L
.49443 .41065 L
.49537 .41092 L
.497 .41129 L
.49956 .41196 L
.50212 .4127 L
.50318 .41305 L
.50469 .41344 L
.50725 .41417 L
.50982 .41488 L
.51033 .41519 L
.51033 .41732 L
.51238 .4191 L
.51473 .41945 L
.51405 .42159 L
.51331 .42372 L
.51266 .42586 L
.51238 .42693 L
.51202 .42799 L
.51134 .43013 L
.51074 .43226 L
.51025 .4344 L
.50986 .43653 L
.50982 .43683 L
.50933 .43867 L
.50878 .4408 L
.50825 .44294 L
.50773 .44507 L
.50725 .44714 L
.50722 .44721 L
.50669 .44934 L
.50616 .45147 L
.50564 .45361 L
.50512 .45574 L
.50469 .45706 L
Mistroke
.50462 .45788 L
Mfstroke
1 g
.46366 .43023 m
.46455 .43013 L
.46623 .42953 L
.46879 .42884 L
.47135 .42813 L
.47177 .42799 L
.47392 .42744 L
.47648 .42674 L
.47905 .42604 L
.47948 .42586 L
.48161 .42534 L
.48417 .42465 L
.48674 .42394 L
.48752 .42372 L
.4893 .42326 L
.49187 .42257 L
.49443 .42186 L
.49537 .42159 L
.497 .42122 L
.49956 .42055 L
.50212 .4198 L
.50318 .41945 L
.50469 .41906 L
.50725 .41834 L
.50982 .41763 L
.5121 .41945 L
.50986 .42159 L
.50982 .42164 L
.50774 .42372 L
.50725 .42422 L
.50563 .42586 L
.50469 .42682 L
.50353 .42799 L
.50212 .42942 L
.50142 .43013 L
.49956 .43203 L
.49927 .43226 L
.49723 .4344 L
.497 .43467 L
.4949 .43653 L
.49443 .43732 L
.49291 .43867 L
.49187 .43995 L
.4909 .4408 L
.4893 .44256 L
.48887 .44294 L
.48681 .44507 L
.48674 .44516 L
.4847 .44721 L
.48417 .44781 L
.48264 .44934 L
.48161 .45046 L
.48058 .45147 L
.47905 .4531 L
.47853 .45361 L
.47648 .45574 L
.47648 .45574 L
.4744 .45788 L
.46366 .45788 L
F
0 g
.46366 .43023 m
.46455 .43013 L
.46623 .42953 L
.46879 .42884 L
.47135 .42813 L
.47177 .42799 L
.47392 .42744 L
.47648 .42674 L
.47905 .42604 L
.47948 .42586 L
.48161 .42534 L
.48417 .42465 L
.48674 .42394 L
.48752 .42372 L
.4893 .42326 L
.49187 .42257 L
.49443 .42186 L
.49537 .42159 L
.497 .42122 L
.49956 .42055 L
.50212 .4198 L
.50318 .41945 L
.50469 .41906 L
.50725 .41834 L
.50982 .41763 L
.5121 .41945 L
.50986 .42159 L
.50982 .42164 L
.50774 .42372 L
.50725 .42422 L
.50563 .42586 L
.50469 .42682 L
.50353 .42799 L
.50212 .42942 L
.50142 .43013 L
.49956 .43203 L
.49927 .43226 L
.49723 .4344 L
.497 .43467 L
.4949 .43653 L
.49443 .43732 L
.49291 .43867 L
.49187 .43995 L
.4909 .4408 L
.4893 .44256 L
.48887 .44294 L
.48681 .44507 L
.48674 .44516 L
.4847 .44721 L
.48417 .44781 L
Mistroke
.48264 .44934 L
.48161 .45046 L
.48058 .45147 L
.47905 .4531 L
.47853 .45361 L
.47648 .45574 L
.47648 .45574 L
.4744 .45788 L
Mfstroke
.5 g
.50462 .37463 m
.50469 .37544 L
.50512 .37676 L
.50564 .3789 L
.50616 .38103 L
.50669 .38317 L
.50722 .3853 L
.50725 .38537 L
.50773 .38744 L
.50825 .38957 L
.50878 .3917 L
.50933 .39384 L
.50982 .39567 L
.50986 .39597 L
.51025 .39811 L
.51074 .40024 L
.51134 .40238 L
.51202 .40451 L
.51238 .40558 L
.51266 .40665 L
.51331 .40878 L
.51405 .41092 L
.51473 .41305 L
.51238 .4134 L
.5121 .41305 L
.50986 .41092 L
.50982 .41087 L
.50774 .40878 L
.50725 .40828 L
.50563 .40665 L
.50469 .40569 L
.50353 .40451 L
.50212 .40309 L
.50142 .40238 L
.49956 .40048 L
.49927 .40024 L
.49723 .39811 L
.497 .39784 L
.4949 .39597 L
.49443 .39519 L
.49291 .39384 L
.49187 .39256 L
.4909 .3917 L
.4893 .38995 L
.48887 .38957 L
.48681 .38744 L
.48674 .38735 L
.4847 .3853 L
.48417 .38469 L
.48264 .38317 L
.48161 .38205 L
.48058 .38103 L
.47905 .3794 L
.47853 .3789 L
.47648 .37676 L
.47648 .37676 L
.4744 .37463 L
F
0 g
.50462 .37463 m
.50469 .37544 L
.50512 .37676 L
.50564 .3789 L
.50616 .38103 L
.50669 .38317 L
.50722 .3853 L
.50725 .38537 L
.50773 .38744 L
.50825 .38957 L
.50878 .3917 L
.50933 .39384 L
.50982 .39567 L
.50986 .39597 L
.51025 .39811 L
.51074 .40024 L
.51134 .40238 L
.51202 .40451 L
.51238 .40558 L
.51266 .40665 L
.51331 .40878 L
.51405 .41092 L
.51473 .41305 L
.51238 .4134 L
.5121 .41305 L
.50986 .41092 L
.50982 .41087 L
.50774 .40878 L
.50725 .40828 L
.50563 .40665 L
.50469 .40569 L
.50353 .40451 L
.50212 .40309 L
.50142 .40238 L
.49956 .40048 L
.49927 .40024 L
.49723 .39811 L
.497 .39784 L
.4949 .39597 L
.49443 .39519 L
.49291 .39384 L
.49187 .39256 L
.4909 .3917 L
.4893 .38995 L
.48887 .38957 L
.48681 .38744 L
.48674 .38735 L
.4847 .3853 L
.48417 .38469 L
.48264 .38317 L
Mistroke
.48161 .38205 L
.48058 .38103 L
.47905 .3794 L
.47853 .3789 L
.47648 .37676 L
.47648 .37676 L
.4744 .37463 L
Mfstroke
.5 g
.51494 .41732 m
.51494 .41732 L
.51494 .41519 L
F
0 g
.51494 .41732 m
.51494 .41732 L
.51494 .41519 L
.51494 .41732 L
s
.5 g
.51494 .41732 m
.51494 .41519 L
% vacuous filled polygon
newpath
0 g
.51494 .41732 m
.51494 .41519 L
.51494 .41732 L
s
.5 g
.55834 .45788 m
.55603 .45574 L
.55597 .45569 L
.55374 .45361 L
.55341 .45331 L
.55147 .45147 L
.55084 .45092 L
.54922 .44934 L
.54828 .44851 L
.54698 .44721 L
.54571 .44608 L
.54475 .44507 L
.54315 .44364 L
.54253 .44294 L
.54058 .44118 L
.5403 .4408 L
.53802 .4387 L
.53801 .43867 L
.53582 .43653 L
.53546 .4363 L
.53372 .4344 L
.53289 .43391 L
.53138 .43226 L
.53033 .4315 L
.5292 .43013 L
.52776 .42872 L
.52702 .42799 L
.5252 .4262 L
.52485 .42586 L
.52269 .42372 L
.52264 .42367 L
.52052 .42159 L
.52007 .42113 L
.51827 .41945 L
.51751 .41856 L
.51521 .41945 L
.51626 .42159 L
.51715 .42372 L
.51751 .42497 L
.5179 .42586 L
.51883 .42799 L
.51958 .43013 L
.51956 .43226 L
.52007 .43407 L
.52017 .4344 L
.52082 .43653 L
.52144 .43867 L
.52204 .4408 L
.52261 .44294 L
.52264 .44307 L
.52323 .44507 L
.52387 .44721 L
.52449 .44934 L
.5251 .45147 L
.5252 .45184 L
.52574 .45361 L
.52638 .45574 L
.52703 .45788 L
F
0 g
.55834 .45788 m
.55603 .45574 L
.55597 .45569 L
.55374 .45361 L
.55341 .45331 L
.55147 .45147 L
.55084 .45092 L
.54922 .44934 L
.54828 .44851 L
.54698 .44721 L
.54571 .44608 L
.54475 .44507 L
.54315 .44364 L
.54253 .44294 L
.54058 .44118 L
.5403 .4408 L
.53802 .4387 L
.53801 .43867 L
.53582 .43653 L
.53546 .4363 L
.53372 .4344 L
.53289 .43391 L
.53138 .43226 L
.53033 .4315 L
.5292 .43013 L
.52776 .42872 L
.52702 .42799 L
.5252 .4262 L
.52485 .42586 L
.52269 .42372 L
.52264 .42367 L
.52052 .42159 L
.52007 .42113 L
.51827 .41945 L
.51751 .41856 L
.51521 .41945 L
.51626 .42159 L
.51715 .42372 L
.51751 .42497 L
.5179 .42586 L
.51883 .42799 L
.51958 .43013 L
.51956 .43226 L
.52007 .43407 L
.52017 .4344 L
.52082 .43653 L
.52144 .43867 L
.52204 .4408 L
.52261 .44294 L
.52264 .44307 L
Mistroke
.52323 .44507 L
.52387 .44721 L
.52449 .44934 L
.5251 .45147 L
.5252 .45184 L
.52574 .45361 L
.52638 .45574 L
.52703 .45788 L
Mfstroke
.5 g
.56366 .42895 m
.5611 .4283 L
.56001 .42799 L
.55853 .42764 L
.55597 .42699 L
.55341 .42632 L
.55173 .42586 L
.55084 .42566 L
.54828 .425 L
.54571 .42433 L
.54347 .42372 L
.54315 .42366 L
.54058 .42301 L
.53802 .42233 L
.53546 .42164 L
.53527 .42159 L
.53289 .42104 L
.53033 .42037 L
.52776 .41962 L
.52725 .41945 L
.5252 .41891 L
.52264 .41819 L
.52007 .41751 L
.51976 .41732 L
.51976 .41519 L
.51751 .41395 L
.51521 .41305 L
.51626 .41092 L
.51715 .40878 L
.51751 .40754 L
.5179 .40665 L
.51883 .40451 L
.51958 .40238 L
.51956 .40024 L
.52007 .39843 L
.52017 .39811 L
.52082 .39597 L
.52144 .39384 L
.52204 .3917 L
.52261 .38957 L
.52264 .38943 L
.52323 .38744 L
.52387 .3853 L
.52449 .38317 L
.5251 .38103 L
.5252 .38067 L
.52574 .3789 L
.52638 .37676 L
.52703 .37463 L
.56366 .37463 L
F
0 g
.56366 .42895 m
.5611 .4283 L
.56001 .42799 L
.55853 .42764 L
.55597 .42699 L
.55341 .42632 L
.55173 .42586 L
.55084 .42566 L
.54828 .425 L
.54571 .42433 L
.54347 .42372 L
.54315 .42366 L
.54058 .42301 L
.53802 .42233 L
.53546 .42164 L
.53527 .42159 L
.53289 .42104 L
.53033 .42037 L
.52776 .41962 L
.52725 .41945 L
.5252 .41891 L
.52264 .41819 L
.52007 .41751 L
.51976 .41732 L
.51976 .41519 L
.51751 .41395 L
.51521 .41305 L
.51626 .41092 L
.51715 .40878 L
.51751 .40754 L
.5179 .40665 L
.51883 .40451 L
.51958 .40238 L
.51956 .40024 L
.52007 .39843 L
.52017 .39811 L
.52082 .39597 L
.52144 .39384 L
.52204 .3917 L
.52261 .38957 L
.52264 .38943 L
.52323 .38744 L
.52387 .3853 L
.52449 .38317 L
.5251 .38103 L
.5252 .38067 L
.52574 .3789 L
.52638 .37676 L
.52703 .37463 L
s
1 g
.56366 .40355 m
.5611 .40421 L
.56001 .40451 L
.55853 .40486 L
.55597 .40552 L
.55341 .40618 L
.55173 .40665 L
.55084 .40684 L
.54828 .4075 L
.54571 .40817 L
.54347 .40878 L
.54315 .40884 L
.54058 .4095 L
.53802 .41017 L
.53546 .41086 L
.53527 .41092 L
.53289 .41146 L
.53033 .41214 L
.52776 .41288 L
.52725 .41305 L
.5252 .4136 L
.52264 .41432 L
.52007 .415 L
.51827 .41305 L
.52007 .41137 L
.52052 .41092 L
.52264 .40884 L
.52269 .40878 L
.52485 .40665 L
.5252 .40631 L
.52702 .40451 L
.52776 .40378 L
.5292 .40238 L
.53033 .40101 L
.53138 .40024 L
.53289 .39859 L
.53372 .39811 L
.53546 .3962 L
.53582 .39597 L
.53801 .39384 L
.53802 .39381 L
.5403 .3917 L
.54058 .39133 L
.54253 .38957 L
.54315 .38887 L
.54475 .38744 L
.54571 .38642 L
.54698 .3853 L
.54828 .384 L
.54922 .38317 L
.55084 .38159 L
.55147 .38103 L
.55341 .3792 L
.55374 .3789 L
.55597 .37681 L
.55603 .37676 L
.55834 .37463 L
.56366 .37463 L
F
0 g
.56366 .40355 m
.5611 .40421 L
.56001 .40451 L
.55853 .40486 L
.55597 .40552 L
.55341 .40618 L
.55173 .40665 L
.55084 .40684 L
.54828 .4075 L
.54571 .40817 L
.54347 .40878 L
.54315 .40884 L
.54058 .4095 L
.53802 .41017 L
.53546 .41086 L
.53527 .41092 L
.53289 .41146 L
.53033 .41214 L
.52776 .41288 L
.52725 .41305 L
.5252 .4136 L
.52264 .41432 L
.52007 .415 L
.51827 .41305 L
.52007 .41137 L
.52052 .41092 L
.52264 .40884 L
.52269 .40878 L
.52485 .40665 L
.5252 .40631 L
.52702 .40451 L
.52776 .40378 L
.5292 .40238 L
.53033 .40101 L
.53138 .40024 L
.53289 .39859 L
.53372 .39811 L
.53546 .3962 L
.53582 .39597 L
.53801 .39384 L
.53802 .39381 L
.5403 .3917 L
.54058 .39133 L
.54253 .38957 L
.54315 .38887 L
.54475 .38744 L
.54571 .38642 L
.54698 .3853 L
.54828 .384 L
.54922 .38317 L
Mistroke
.55084 .38159 L
.55147 .38103 L
.55341 .3792 L
.55374 .3789 L
.55597 .37681 L
.55603 .37676 L
.55834 .37463 L
Mfstroke
1 g
.72593 .16054 m
.73993 .14654 L
.75393 .16054 L
.73993 .17454 L
.72593 .16054 L
F
.72593 .67196 m
.73993 .65796 L
.75393 .67196 L
.73993 .68596 L
.72593 .67196 L
F
.80613 .41625 m
.82013 .40225 L
.83413 .41625 L
.82013 .43025 L
.80613 .41625 L
F
.16987 .2386 m
.18987 .2386 L
.18987 .2586 L
.16987 .2586 L
.16987 .2386 L
F
.16987 .57391 m
.18987 .57391 L
.18987 .59391 L
.16987 .59391 L
.16987 .57391 L
F
0 g
.003 w
.72593 .16054 m
.73993 .14654 L
.75393 .16054 L
.73993 .17454 L
.72593 .16054 L
s
.72593 .67196 m
.73993 .65796 L
.75393 .67196 L
.73993 .68596 L
.72593 .67196 L
s
.80613 .41625 m
.82013 .40225 L
.83413 .41625 L
.82013 .43025 L
.80613 .41625 L
s
.16987 .2386 m
.18987 .2386 L
.18987 .2586 L
.16987 .2586 L
.16987 .2386 L
s
.16987 .57391 m
.18987 .57391 L
.18987 .59391 L
.16987 .59391 L
.16987 .57391 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.832506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.51518 0.083828 0.416253 0.083828 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .83251 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .83251 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .83251 L
s
0 .83251 m
1 .83251 L
s
1 0 m
1 .83251 L
s
0 .41625 m
1 .41625 L
s
.51518 0 m
.51518 .83251 L
s
0 0 m
1 0 L
1 .83251 L
0 .83251 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.91.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.91.1"]
}, Open  ]],

Cell[TextData[{
 "Expositions of the theory of stability of numerical methods can be found in \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "1", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "2", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "3", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". More examples of applications of the package are provided in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "4", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.91.1", "1.32"}],

Cell[CellGroupData[{

Cell["References", "Subsubsection",
 CellTags->{"S5.91.1", "1.33"}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "1", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " E. Hairer and G. Wanner, ",
 StyleBox["Solving Ordinary Differential Equations II: Stiff and Differential\
\[Hyphen]Algebraic Problems", "TI"],
 ", Springer, Berlin, 1991.\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "2", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " A. Iserles and S. P. N\[OSlash]rsett, ",
 StyleBox["Order Stars", "TI"],
 ", Chapman and Hall, London, 1991.\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "3", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " J. D. Lambert, ",
 StyleBox["Numerical Methods for Ordinary Differential Equations: The Initial \
Value Problem", "TI"],
 ", John Wiley and Sons, Chichester, 1991.\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", "4", "]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " M. Sofroniou, \[OpenCurlyDoubleQuote]Order Stars and Linear Stability \
Theory\[CloseCurlyDoubleQuote], ",
 StyleBox["Journal of Symbolic Computation", "TI"],
 ", 1996, ",
 StyleBox["11", "TB"],
 ", pp. 1\[Dash]31. "
}], "Text",
 CellTags->{"S5.91.1", "1.34"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.91.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.91.1", "1.1"}],
    Cell[1918, 61, 409, 7, 72, "Text",
      CellTags->{"S5.91.1", "1.2"}],
    Cell[2330, 70, 540, 9, 88, "Text",
      CellTags->{"S5.91.1", "1.3"}],
    Cell[2873, 81, 773, 12, 136, "Text",
      CellTags->{"S5.91.1", "1.4"}],
    Cell[3649, 95, 525, 22, 30, "DisplayFormula",
      CellTags->{"S5.91.1", "1.5"}],
    Cell[4177, 119, 324, 10, 40, "Text",
      CellTags->{"S5.91.1", "1.6"}],
    Cell[4504, 131, 640, 27, 32, "DisplayFormula",
      CellTags->{"S5.91.1", "1.7"}],
    Cell[5147, 160, 774, 19, 72, "Text",
      CellTags->{"S5.91.1", "1.8"}],
    Cell[5924, 181, 477, 8, 88, "Text",
      CellTags->{"S5.91.1", "1.9"}],
    Cell[6404, 191, 6060, 186, 142, "DefinitionBox",
      CellTags->"S5.91.1"],
    Cell[12467, 379, 62, 1, 70, "Caption",
      CellTags->"S5.91.1"],
    Cell[12532, 382, 333, 6, 70, "Text",
      CellTags->{"S5.91.1", "1.10"}],
    Cell[12868, 390, 79, 1, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.11"}],
    Cell[12950, 393, 89, 2, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[13042, 397, 421, 12, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.12"}],
    Cell[13488, 413, 100, 2, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[13591, 417, 96, 3, 70, "Output",
      CellTags->"S5.91.1"],
    Cell[13702, 423, 211, 4, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.13"}],
    Cell[13938, 431, 87, 2, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[14028, 435, 13611, 905, 70, 13540, 902, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.91.1"],
    Cell[27642, 1342, 180, 6, 70, "Output",
      CellTags->"S5.91.1"],
    Cell[27837, 1351, 175, 4, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.14"}],
    Cell[28037, 1359, 85, 2, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[28125, 1363, 11614, 773, 70, 11543, 770, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.91.1"],
    Cell[39742, 2138, 180, 6, 70, "Output",
      CellTags->"S5.91.1"],
    Cell[39937, 2147, 5238, 158, 70, "DefinitionBox",
      CellTags->"S5.91.1"],
    Cell[45178, 2307, 110, 5, 70, "Caption",
      CellTags->"S5.91.1"],
    Cell[45291, 2314, 424, 9, 70, "Text",
      CellTags->{"S5.91.1", "1.15"}],
    Cell[45718, 2325, 450, 8, 70, "Text",
      CellTags->{"S5.91.1", "1.16"}],
    Cell[46171, 2335, 447, 14, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.17"}],
    Cell[46643, 2353, 138, 5, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[46784, 2360, 13701, 911, 70, 13630, 908, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.91.1"],
    Cell[60488, 3273, 180, 6, 70, "Output",
      CellTags->"S5.91.1"],
    Cell[60683, 3282, 595, 18, 70, "Text",
      CellTags->{"S5.91.1", "1.18"}],
    Cell[61281, 3302, 325, 7, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.19"}],
    Cell[61631, 3313, 258, 7, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[61892, 3322, 42644, 2622, 70, 42573, 2619, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.91.1"],
    Cell[104539, 5946, 180, 6, 70, "Output",
      CellTags->"S5.91.1"],
    Cell[104734, 5955, 254, 7, 70, "Text",
      CellTags->{"S5.91.1", "1.20"}],
    Cell[104991, 5964, 4238, 128, 70, "DefinitionBox",
      CellTags->"S5.91.1"],
    Cell[109232, 6094, 83, 1, 70, "Caption",
      CellTags->"S5.91.1"],
    Cell[109318, 6097, 365, 7, 70, "Text",
      CellTags->{"S5.91.1", "1.21"}],
    Cell[109686, 6106, 264, 7, 70, "Text",
      CellTags->{"S5.91.1", "1.22"}],
    Cell[109953, 6115, 80, 1, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.23"}],
    Cell[110036, 6118, 92, 2, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[110131, 6122, 117, 2, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.24"}],
    Cell[110251, 6126, 97, 2, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[110351, 6130, 283, 7, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.25"}],
    Cell[110659, 6141, 172, 6, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[110834, 6149, 16149, 1123, 70, 16078, 1120, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.91.1"],
    Cell[126986, 7274, 180, 6, 70, "Output",
      CellTags->"S5.91.1"],
    Cell[127181, 7283, 158, 4, 70, "Text",
      CellTags->{"S5.91.1", "1.26"}],
    Cell[127342, 7289, 440, 11, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.27"}],
    Cell[127807, 7304, 239, 7, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[128049, 7313, 15244, 1045, 70, 15173, 1042, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.91.1"],
    Cell[143296, 8360, 181, 6, 70, "Output",
      CellTags->"S5.91.1"],
    Cell[143492, 8369, 505, 11, 70, "Text",
      CellTags->{"S5.91.1", "1.28"}],
    Cell[144000, 8382, 309, 7, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.29"}],
    Cell[144334, 8393, 376, 10, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[144713, 8405, 20286, 1387, 70, 20215, 1384, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.91.1"],
    Cell[165002, 9794, 181, 6, 70, "Output",
      CellTags->"S5.91.1"],
    Cell[165198, 9803, 354, 6, 70, "Text",
      CellTags->{"S5.91.1", "1.30"}],
    Cell[165555, 9811, 655, 16, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.31"}],
    Cell[166235, 9831, 214, 6, 70, "Input",
      CellTags->"S5.91.1"],
    Cell[166452, 9839, 31438, 2072, 70, 31367, 2069, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.91.1"],
    Cell[197893, 11913, 181, 6, 70, "Output",
      CellTags->"S5.91.1"],
    Cell[198089, 11922, 778, 24, 70, "Text",
      CellTags->{"S5.91.1", "1.32"}],
    Cell[198892, 11950, 67, 1, 70, "Subsubsection",
      CellTags->{"S5.91.1", "1.33"}],
    Cell[198962, 11953, 1289, 35, 70, "Text",
      CellTags->{"S5.91.1", "1.34"}]},
  "1.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.91.1", "1.1"}]},
  "1.2"->{
    Cell[1918, 61, 409, 7, 72, "Text",
      CellTags->{"S5.91.1", "1.2"}]},
  "1.3"->{
    Cell[2330, 70, 540, 9, 88, "Text",
      CellTags->{"S5.91.1", "1.3"}]},
  "1.4"->{
    Cell[2873, 81, 773, 12, 136, "Text",
      CellTags->{"S5.91.1", "1.4"}]},
  "1.5"->{
    Cell[3649, 95, 525, 22, 30, "DisplayFormula",
      CellTags->{"S5.91.1", "1.5"}]},
  "1.6"->{
    Cell[4177, 119, 324, 10, 40, "Text",
      CellTags->{"S5.91.1", "1.6"}]},
  "1.7"->{
    Cell[4504, 131, 640, 27, 32, "DisplayFormula",
      CellTags->{"S5.91.1", "1.7"}]},
  "1.8"->{
    Cell[5147, 160, 774, 19, 72, "Text",
      CellTags->{"S5.91.1", "1.8"}]},
  "1.9"->{
    Cell[5924, 181, 477, 8, 88, "Text",
      CellTags->{"S5.91.1", "1.9"}]},
  "1.10"->{
    Cell[12532, 382, 333, 6, 70, "Text",
      CellTags->{"S5.91.1", "1.10"}]},
  "1.11"->{
    Cell[12868, 390, 79, 1, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.11"}]},
  "1.12"->{
    Cell[13042, 397, 421, 12, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.12"}]},
  "1.13"->{
    Cell[13702, 423, 211, 4, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.13"}]},
  "1.14"->{
    Cell[27837, 1351, 175, 4, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.14"}]},
  "1.15"->{
    Cell[45291, 2314, 424, 9, 70, "Text",
      CellTags->{"S5.91.1", "1.15"}]},
  "1.16"->{
    Cell[45718, 2325, 450, 8, 70, "Text",
      CellTags->{"S5.91.1", "1.16"}]},
  "1.17"->{
    Cell[46171, 2335, 447, 14, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.17"}]},
  "1.18"->{
    Cell[60683, 3282, 595, 18, 70, "Text",
      CellTags->{"S5.91.1", "1.18"}]},
  "1.19"->{
    Cell[61281, 3302, 325, 7, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.19"}]},
  "1.20"->{
    Cell[104734, 5955, 254, 7, 70, "Text",
      CellTags->{"S5.91.1", "1.20"}]},
  "1.21"->{
    Cell[109318, 6097, 365, 7, 70, "Text",
      CellTags->{"S5.91.1", "1.21"}]},
  "1.22"->{
    Cell[109686, 6106, 264, 7, 70, "Text",
      CellTags->{"S5.91.1", "1.22"}]},
  "1.23"->{
    Cell[109953, 6115, 80, 1, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.23"}]},
  "1.24"->{
    Cell[110131, 6122, 117, 2, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.24"}]},
  "1.25"->{
    Cell[110351, 6130, 283, 7, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.25"}]},
  "1.26"->{
    Cell[127181, 7283, 158, 4, 70, "Text",
      CellTags->{"S5.91.1", "1.26"}]},
  "1.27"->{
    Cell[127342, 7289, 440, 11, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.27"}]},
  "1.28"->{
    Cell[143492, 8369, 505, 11, 70, "Text",
      CellTags->{"S5.91.1", "1.28"}]},
  "1.29"->{
    Cell[144000, 8382, 309, 7, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.29"}]},
  "1.30"->{
    Cell[165198, 9803, 354, 6, 70, "Text",
      CellTags->{"S5.91.1", "1.30"}]},
  "1.31"->{
    Cell[165555, 9811, 655, 16, 70, "MathCaption",
      CellTags->{"S5.91.1", "1.31"}]},
  "1.32"->{
    Cell[198089, 11922, 778, 24, 70, "Text",
      CellTags->{"S5.91.1", "1.32"}]},
  "1.33"->{
    Cell[198892, 11950, 67, 1, 70, "Subsubsection",
      CellTags->{"S5.91.1", "1.33"}]},
  "1.34"->{
    Cell[198962, 11953, 1289, 35, 70, "Text",
      CellTags->{"S5.91.1", "1.34"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.91.1", 200902, 12008},
  {"1.1", 206966, 12163},
  {"1.2", 207060, 12166},
  {"1.3", 207148, 12169},
  {"1.4", 207236, 12172},
  {"1.5", 207326, 12175},
  {"1.6", 207425, 12178},
  {"1.7", 207515, 12181},
  {"1.8", 207615, 12184},
  {"1.9", 207705, 12187},
  {"1.10", 207795, 12190},
  {"1.11", 207887, 12193},
  {"1.12", 207985, 12196},
  {"1.13", 208085, 12199},
  {"1.14", 208184, 12202},
  {"1.15", 208284, 12205},
  {"1.16", 208377, 12208},
  {"1.17", 208470, 12211},
  {"1.18", 208571, 12214},
  {"1.19", 208665, 12217},
  {"1.20", 208765, 12220},
  {"1.21", 208859, 12223},
  {"1.22", 208953, 12226},
  {"1.23", 209047, 12229},
  {"1.24", 209147, 12232},
  {"1.25", 209248, 12235},
  {"1.26", 209349, 12238},
  {"1.27", 209443, 12241},
  {"1.28", 209545, 12244},
  {"1.29", 209640, 12247},
  {"1.30", 209741, 12250},
  {"1.31", 209835, 12253},
  {"1.32", 209937, 12256},
  {"1.33", 210033, 12259},
  {"1.34", 210136, 12262}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 139, 6, 36, "Subsection",
  CellTags->{"S5.91.1", "1.1"}],
Cell[1918, 61, 409, 7, 72, "Text",
  CellTags->{"S5.91.1", "1.2"}],
Cell[2330, 70, 540, 9, 88, "Text",
  CellTags->{"S5.91.1", "1.3"}],
Cell[2873, 81, 773, 12, 136, "Text",
  CellTags->{"S5.91.1", "1.4"}],
Cell[3649, 95, 525, 22, 30, "DisplayFormula",
  CellTags->{"S5.91.1", "1.5"}],
Cell[4177, 119, 324, 10, 40, "Text",
  CellTags->{"S5.91.1", "1.6"}],
Cell[4504, 131, 640, 27, 32, "DisplayFormula",
  CellTags->{"S5.91.1", "1.7"}],
Cell[5147, 160, 774, 19, 72, "Text",
  CellTags->{"S5.91.1", "1.8"}],
Cell[5924, 181, 477, 8, 88, "Text",
  CellTags->{"S5.91.1", "1.9"}],
Cell[6404, 191, 6060, 186, 142, "DefinitionBox",
  CellTags->"S5.91.1"],
Cell[12467, 379, 62, 1, 70, "Caption",
  CellTags->"S5.91.1"],
Cell[12532, 382, 333, 6, 70, "Text",
  CellTags->{"S5.91.1", "1.10"}],
Cell[12868, 390, 79, 1, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.11"}],
Cell[12950, 393, 89, 2, 70, "Input",
  CellTags->"S5.91.1"],
Cell[13042, 397, 421, 12, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.12"}],

Cell[CellGroupData[{
Cell[13488, 413, 100, 2, 70, "Input",
  CellTags->"S5.91.1"],
Cell[13591, 417, 96, 3, 70, "Output",
  CellTags->"S5.91.1"]
}, Open  ]],
Cell[13702, 423, 211, 4, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.13"}],

Cell[CellGroupData[{
Cell[13938, 431, 87, 2, 70, "Input",
  CellTags->"S5.91.1"],
Cell[14028, 435, 13611, 905, 70, 13540, 902, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.91.1"],
Cell[27642, 1342, 180, 6, 70, "Output",
  CellTags->"S5.91.1"]
}, Open  ]],
Cell[27837, 1351, 175, 4, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.14"}],

Cell[CellGroupData[{
Cell[28037, 1359, 85, 2, 70, "Input",
  CellTags->"S5.91.1"],
Cell[28125, 1363, 11614, 773, 70, 11543, 770, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.91.1"],
Cell[39742, 2138, 180, 6, 70, "Output",
  CellTags->"S5.91.1"]
}, Open  ]],
Cell[39937, 2147, 5238, 158, 70, "DefinitionBox",
  CellTags->"S5.91.1"],
Cell[45178, 2307, 110, 5, 70, "Caption",
  CellTags->"S5.91.1"],
Cell[45291, 2314, 424, 9, 70, "Text",
  CellTags->{"S5.91.1", "1.15"}],
Cell[45718, 2325, 450, 8, 70, "Text",
  CellTags->{"S5.91.1", "1.16"}],
Cell[46171, 2335, 447, 14, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.17"}],

Cell[CellGroupData[{
Cell[46643, 2353, 138, 5, 70, "Input",
  CellTags->"S5.91.1"],
Cell[46784, 2360, 13701, 911, 70, 13630, 908, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.91.1"],
Cell[60488, 3273, 180, 6, 70, "Output",
  CellTags->"S5.91.1"]
}, Open  ]],
Cell[60683, 3282, 595, 18, 70, "Text",
  CellTags->{"S5.91.1", "1.18"}],
Cell[61281, 3302, 325, 7, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.19"}],

Cell[CellGroupData[{
Cell[61631, 3313, 258, 7, 70, "Input",
  CellTags->"S5.91.1"],
Cell[61892, 3322, 42644, 2622, 70, 42573, 2619, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.91.1"],
Cell[104539, 5946, 180, 6, 70, "Output",
  CellTags->"S5.91.1"]
}, Open  ]],
Cell[104734, 5955, 254, 7, 70, "Text",
  CellTags->{"S5.91.1", "1.20"}],
Cell[104991, 5964, 4238, 128, 70, "DefinitionBox",
  CellTags->"S5.91.1"],
Cell[109232, 6094, 83, 1, 70, "Caption",
  CellTags->"S5.91.1"],
Cell[109318, 6097, 365, 7, 70, "Text",
  CellTags->{"S5.91.1", "1.21"}],
Cell[109686, 6106, 264, 7, 70, "Text",
  CellTags->{"S5.91.1", "1.22"}],
Cell[109953, 6115, 80, 1, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.23"}],
Cell[110036, 6118, 92, 2, 70, "Input",
  CellTags->"S5.91.1"],
Cell[110131, 6122, 117, 2, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.24"}],
Cell[110251, 6126, 97, 2, 70, "Input",
  CellTags->"S5.91.1"],
Cell[110351, 6130, 283, 7, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.25"}],

Cell[CellGroupData[{
Cell[110659, 6141, 172, 6, 70, "Input",
  CellTags->"S5.91.1"],
Cell[110834, 6149, 16149, 1123, 70, 16078, 1120, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.91.1"],
Cell[126986, 7274, 180, 6, 70, "Output",
  CellTags->"S5.91.1"]
}, Open  ]],
Cell[127181, 7283, 158, 4, 70, "Text",
  CellTags->{"S5.91.1", "1.26"}],
Cell[127342, 7289, 440, 11, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.27"}],

Cell[CellGroupData[{
Cell[127807, 7304, 239, 7, 70, "Input",
  CellTags->"S5.91.1"],
Cell[128049, 7313, 15244, 1045, 70, 15173, 1042, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.91.1"],
Cell[143296, 8360, 181, 6, 70, "Output",
  CellTags->"S5.91.1"]
}, Open  ]],
Cell[143492, 8369, 505, 11, 70, "Text",
  CellTags->{"S5.91.1", "1.28"}],
Cell[144000, 8382, 309, 7, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.29"}],

Cell[CellGroupData[{
Cell[144334, 8393, 376, 10, 70, "Input",
  CellTags->"S5.91.1"],
Cell[144713, 8405, 20286, 1387, 70, 20215, 1384, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.91.1"],
Cell[165002, 9794, 181, 6, 70, "Output",
  CellTags->"S5.91.1"]
}, Open  ]],
Cell[165198, 9803, 354, 6, 70, "Text",
  CellTags->{"S5.91.1", "1.30"}],
Cell[165555, 9811, 655, 16, 70, "MathCaption",
  CellTags->{"S5.91.1", "1.31"}],

Cell[CellGroupData[{
Cell[166235, 9831, 214, 6, 70, "Input",
  CellTags->"S5.91.1"],
Cell[166452, 9839, 31438, 2072, 70, 31367, 2069, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.91.1"],
Cell[197893, 11913, 181, 6, 70, "Output",
  CellTags->"S5.91.1"]
}, Open  ]],
Cell[198089, 11922, 778, 24, 70, "Text",
  CellTags->{"S5.91.1", "1.32"}],

Cell[CellGroupData[{
Cell[198892, 11950, 67, 1, 70, "Subsubsection",
  CellTags->{"S5.91.1", "1.33"}],
Cell[198962, 11953, 1289, 35, 70, "Text",
  CellTags->{"S5.91.1", "1.34"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

