(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25054,        850]*)
(*NotebookOutlinePosition[     30874,       1025]*)
(*  CellTagsIndexPosition[     30426,       1003]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "LinearAlgebra",
 StyleBox["`", "MB"],
 "Orthogonalization",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.49.1", "1.1"}],

Cell[TextData[{
 "For most purposes, the most convenient type of basis for a vector space is \
orthonormal (",
 StyleBox["i.e.", "TI"],
 ", the vectors are unit length and are pairwise orthogonal). The Gram\
\[Hyphen]Schmidt procedure takes an arbitrary basis and generates an \
orthonormal one. It does this by sequentially processing the list of vectors \
and generating a vector perpendicular to the previous vectors in the list. \
For the process to succeed in producing an orthonormal set, the given vectors \
must be linearly independent. The function ",
 StyleBox["GramSchmidt", "MR"],
 " assumes that this is the case. If the given vectors are not linearly \
independent, indeterminate or zero vectors may be produced. The ",
 StyleBox["Householder", "MR"],
 " method of orthogonalization is restricted to numeric matrices and a dot \
inner product, but is numerically stable, unlike ",
 StyleBox["GramSchmidt", "MR"],
 ", which may have problems with vectors that are nearly linearly dependent. \
"
}], "Text",
 CellTags->{"S5.49.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["GramSchmidt[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "generate an orthonormal set from the given list of real vectors ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Normalize[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vect", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["normalize ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vect", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Projection[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the orthogonal projection of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" onto ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.49.1"],

Cell["Vector operations using the usual inner product. ", "Caption",
 CellTags->"S5.49.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.49.1", "1.3"}],

Cell["<<LinearAlgebra`Orthogonalization`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.49.1"],

Cell["\<\
This applies the Gram\[Hyphen]Schmidt procedure to the given list of three\
\[Hyphen]dimensional vectors. \
\>", "MathCaption",
 CellTags->{"S5.49.1", "1.4"}],

Cell[CellGroupData[{

Cell["\<\
{w1, w2, w3} = GramSchmidt[
              {{3,4,2}, {2,5,2}, {1,2,6}}]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.49.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", 
      SqrtBox["29"]], ",", 
     FractionBox["4", 
      SqrtBox["29"]], ",", 
     FractionBox["2", 
      SqrtBox["29"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["32", 
       SqrtBox["1653"]]}], ",", 
     FractionBox["25", 
      SqrtBox["1653"]], ",", 
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox["1653"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox["57"]]}], ",", 
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox["57"]]}], ",", 
     FractionBox["7", 
      SqrtBox["57"]]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.49.1"]
}, Open  ]],

Cell["\<\
The result is an orthonormal basis, so the dot product of each pair of \
vectors is zero and each vector has unit length. \
\>", "MathCaption",
 CellTags->{"S5.49.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
{w1 . w2, w2 . w3, w1 . w3,
            w1 . w1, w2 . w2, w3 . w3}\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.49.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.49.1"]
}, Open  ]],

Cell[TextData[{
 "A vector space is a generalization of the familiar notions of one\[Hyphen], \
two\[Hyphen], and three\[Hyphen]dimensional space. In these familiar spaces \
we know how to compute lengths of vectors and the angle between two vectors. \
The usual way of doing this uses the dot product. The length of a vector is \
simply ",
 StyleBox["Sqrt[", "MR"],
 StyleBox["v", "TI"],
 StyleBox[".", "MR"],
 StyleBox["v", "TI"],
 StyleBox["]", "MR"],
 " and two vectors are perpendicular (or orthogonal) if ",
 StyleBox["v", "TI"],
 StyleBox[".", "MR"],
 StyleBox["w", "TI"],
 " is zero. In a more general vector space, the dot product is replaced by an \
inner product. By setting the option ",
 StyleBox["InnerProduct", "MR"],
 ", you can use ",
 StyleBox["GramSchmidt", "MR"],
 " to produce a collection of vectors that are orthonormal with respect to \
your specified inner product. "
}], "Text",
 CellTags->{"S5.49.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["GramSchmidt[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, InnerProduct -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["func", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "generate an orthonormal set using the inner product given by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["func", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Normalize[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vect", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", InnerProduct -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["func", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["normalize ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vect", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using the inner product given by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["func", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Projection[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", InnerProduct -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["func", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the orthogonal projection of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" onto ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using the inner product given by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["func", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.49.1"],

Cell["Vector operations using a specified inner product. ", "Caption",
 CellTags->"S5.49.1"],

Cell[TextData[{
 "The function you specify as the ",
 StyleBox["InnerProduct", "MR"],
 " can be a pure function of two variables, with the variables given as ",
 StyleBox["#1", "MR"],
 " and ",
 StyleBox["#2", "MR"],
 ". For example, the default ",
 StyleBox["InnerProduct", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["Dot", "MR"],
 " could be expressed as ",
 StyleBox["InnerProduct", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["(#1.#2&)", "MR"],
 ". The parentheses around the formula for the function guarantee that ",
 StyleBox["Mathematica", "TI"],
 " treats it as a single unit. For more information on pure functions, see ",
 StyleBox["The Mathematica Book.", "TI"],
 " "
}], "Text",
 CellTags->{"S5.49.1", "1.7"}],

Cell[TextData[{
 "The vectors here are functions, and the inner product is the integral of \
the product of two functions over the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.49.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
GramSchmidt[{1, x, x^2, x^3, x^4},
  InnerProduct ->
     (Integrate[#1 #2,{x,-1,1}]&)]  //Simplify\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.49.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   RowBox[{
    SqrtBox[
     FractionBox["3", "2"]], " ", "x"}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     FractionBox["5", "2"]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     FractionBox["7", "2"]], " ", "x", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"30", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"35", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}]}], 
    RowBox[{"8", " ", 
     SqrtBox["2"]}]]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.49.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the second Legendre polynomial normalized with respect to the same \
inner product. It is the same as the third element in the basis found using \
",
 StyleBox["GramSchmidt", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.49.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
Normalize[LegendreP[2,x],
 InnerProduct ->
     (Integrate[#1 #2,{x,-1,1}]&)]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.49.1"],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["5", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"]}], "2"]}], ")"}]}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.49.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["GramSchmidt[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, Normalized -> False]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "generate an orthogonal set, but do not normalize",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.49.1"],

Cell["Generating orthogonal sets without normalizing. ", "Caption",
 CellTags->"S5.49.1"],

Cell[TextData[{
 "The option ",
 StyleBox["Normalized", "MR"],
 " is set to ",
 StyleBox["False.", "MR"],
 " "
}], "MathCaption",
 CellTags->{"S5.49.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
{w1, w2} = GramSchmidt[{{3,4,3}, {2,3,6}},
 Normalized -> False]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.49.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["20", "17"]}], ",", 
     RowBox[{"-", 
      FractionBox["21", "17"]}], ",", 
     FractionBox["48", "17"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.49.1"]
}, Open  ]],

Cell["\<\
The resulting vectors are orthogonal, but they are not normalized. \
\>", "MathCaption",
 CellTags->{"S5.49.1", "1.11"}],

Cell[CellGroupData[{

Cell["{w1 . w1, w1 . w2}", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.49.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"34", ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.49.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Householder[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "generate an orthonormal set from the given list of real numeric vectors \
",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.49.1"],

Cell["Housholder orthogonalization. ", "Caption",
 CellTags->"S5.49.1"],

Cell[TextData[{
 "For the particular case of numeric vectors using ",
 StyleBox["Dot", "MR"],
 " as the inner product, you may find Householder orthogonalization to be \
numerically more stable. Also, since this can be implemented in terms of the \
internal ",
 StyleBox["QRDecomposition", "MR"],
 " routine, it may be much faster, even though the Householder method may \
theoretically take twice as many operations as the Gram\[Hyphen]Schmidt \
method. "
}], "Text",
 CellTags->{"S5.49.1", "1.12"}],

Cell["Here is a numeric matrix that is linearly dependent. ", "MathCaption",
 CellTags->{"S5.49.1", "1.13"}],

Cell["\<\
dat = {{0, 0, 1.},
       {1., 0, 0},
       {-0.12988785514152842, 0.3997814966837186,
            0.5468181006215335},
       {1.013982920708332, -0.02721531177817664,
           -0.18567966396292607}};\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.49.1"],

Cell["\<\
The Gram\[Hyphen]Schmidt routine doesn\[CloseCurlyQuote]t catch the \
dependency. \
\>", "MathCaption",
 CellTags->{"S5.49.1", "1.14"}],

Cell[CellGroupData[{

Cell["GramSchmidt[dat]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.49.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1.`"}], ",", "0.`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.49.1"]
}, Open  ]],

Cell["The Householder routine works as desired. ", "MathCaption",
 CellTags->{"S5.49.1", "1.15"}],

Cell[CellGroupData[{

Cell["Householder[dat]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.49.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.49.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Householder", "MR"],
 " function is restricted to numeric input, and returns only an orthonormal \
basis. It is not as flexible as ",
 StyleBox["GramSchmidt", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.49.1", "1.16"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.49.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S5.49.1", "1.1"}],
    Cell[1926, 61, 1050, 20, 152, "Text",
      CellTags->{"S5.49.1", "1.2"}],
    Cell[2979, 83, 4075, 125, 106, "DefinitionBox",
      CellTags->"S5.49.1"],
    Cell[7057, 210, 90, 1, 15, "Caption",
      CellTags->"S5.49.1"],
    Cell[7150, 213, 78, 1, 40, "MathCaption",
      CellTags->{"S5.49.1", "1.3"}],
    Cell[7231, 216, 97, 2, 28, "Input",
      CellTags->"S5.49.1"],
    Cell[7331, 220, 168, 4, 40, "MathCaption",
      CellTags->{"S5.49.1", "1.4"}],
    Cell[7524, 228, 141, 5, 45, "Input",
      CellTags->"S5.49.1"],
    Cell[7668, 235, 775, 32, 83, "Output",
      CellTags->"S5.49.1"],
    Cell[8458, 270, 184, 4, 56, "MathCaption",
      CellTags->{"S5.49.1", "1.5"}],
    Cell[8667, 278, 137, 5, 45, "Input",
      CellTags->"S5.49.1"],
    Cell[8807, 285, 162, 5, 70, "Output",
      CellTags->"S5.49.1"],
    Cell[8984, 293, 935, 23, 70, "Text",
      CellTags->{"S5.49.1", "1.6"}],
    Cell[9922, 318, 5247, 160, 70, "DefinitionBox",
      CellTags->"S5.49.1"],
    Cell[15172, 480, 92, 1, 70, "Caption",
      CellTags->"S5.49.1"],
    Cell[15267, 483, 739, 25, 70, "Text",
      CellTags->{"S5.49.1", "1.7"}],
    Cell[16009, 510, 450, 13, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.8"}],
    Cell[16484, 527, 170, 6, 70, "Input",
      CellTags->"S5.49.1"],
    Cell[16657, 535, 973, 37, 70, "Output",
      CellTags->"S5.49.1"],
    Cell[17645, 575, 263, 7, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.9"}],
    Cell[17933, 586, 148, 6, 70, "Input",
      CellTags->"S5.49.1"],
    Cell[18084, 594, 298, 12, 70, "Output",
      CellTags->"S5.49.1"],
    Cell[18397, 609, 1453, 43, 70, "DefinitionBox",
      CellTags->"S5.49.1"],
    Cell[19853, 654, 89, 1, 70, "Caption",
      CellTags->"S5.49.1"],
    Cell[19945, 657, 161, 7, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.10"}],
    Cell[20131, 668, 135, 5, 70, "Input",
      CellTags->"S5.49.1"],
    Cell[20269, 675, 359, 13, 70, "Output",
      CellTags->"S5.49.1"],
    Cell[20643, 691, 130, 3, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.11"}],
    Cell[20798, 698, 81, 2, 70, "Input",
      CellTags->"S5.49.1"],
    Cell[20882, 702, 120, 4, 70, "Output",
      CellTags->"S5.49.1"],
    Cell[21017, 709, 1458, 44, 70, "DefinitionBox",
      CellTags->"S5.49.1"],
    Cell[22478, 755, 71, 1, 70, "Caption",
      CellTags->"S5.49.1"],
    Cell[22552, 758, 500, 11, 70, "Text",
      CellTags->{"S5.49.1", "1.12"}],
    Cell[23055, 771, 108, 1, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.13"}],
    Cell[23166, 774, 275, 9, 70, "Input",
      CellTags->"S5.49.1"],
    Cell[23444, 785, 145, 4, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.14"}],
    Cell[23614, 793, 79, 2, 70, "Input",
      CellTags->"S5.49.1"],
    Cell[23696, 797, 414, 13, 70, "Output",
      CellTags->"S5.49.1"],
    Cell[24125, 813, 97, 1, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.15"}],
    Cell[24247, 818, 80, 2, 70, "Input",
      CellTags->"S5.49.1"],
    Cell[24330, 822, 442, 14, 70, "Output",
      CellTags->"S5.49.1"],
    Cell[24787, 839, 251, 8, 70, "Text",
      CellTags->{"S5.49.1", "1.16"}]},
  "1.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S5.49.1", "1.1"}]},
  "1.2"->{
    Cell[1926, 61, 1050, 20, 152, "Text",
      CellTags->{"S5.49.1", "1.2"}]},
  "1.3"->{
    Cell[7150, 213, 78, 1, 40, "MathCaption",
      CellTags->{"S5.49.1", "1.3"}]},
  "1.4"->{
    Cell[7331, 220, 168, 4, 40, "MathCaption",
      CellTags->{"S5.49.1", "1.4"}]},
  "1.5"->{
    Cell[8458, 270, 184, 4, 56, "MathCaption",
      CellTags->{"S5.49.1", "1.5"}]},
  "1.6"->{
    Cell[8984, 293, 935, 23, 70, "Text",
      CellTags->{"S5.49.1", "1.6"}]},
  "1.7"->{
    Cell[15267, 483, 739, 25, 70, "Text",
      CellTags->{"S5.49.1", "1.7"}]},
  "1.8"->{
    Cell[16009, 510, 450, 13, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.8"}]},
  "1.9"->{
    Cell[17645, 575, 263, 7, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.9"}]},
  "1.10"->{
    Cell[19945, 657, 161, 7, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.10"}]},
  "1.11"->{
    Cell[20643, 691, 130, 3, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.11"}]},
  "1.12"->{
    Cell[22552, 758, 500, 11, 70, "Text",
      CellTags->{"S5.49.1", "1.12"}]},
  "1.13"->{
    Cell[23055, 771, 108, 1, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.13"}]},
  "1.14"->{
    Cell[23444, 785, 145, 4, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.14"}]},
  "1.15"->{
    Cell[24125, 813, 97, 1, 70, "MathCaption",
      CellTags->{"S5.49.1", "1.15"}]},
  "1.16"->{
    Cell[24787, 839, 251, 8, 70, "Text",
      CellTags->{"S5.49.1", "1.16"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.49.1", 25677, 866},
  {"1.1", 28885, 951},
  {"1.2", 28979, 954},
  {"1.3", 29070, 957},
  {"1.4", 29165, 960},
  {"1.5", 29261, 963},
  {"1.6", 29357, 966},
  {"1.7", 29447, 969},
  {"1.8", 29538, 972},
  {"1.9", 29636, 975},
  {"1.10", 29734, 978},
  {"1.11", 29833, 981},
  {"1.12", 29932, 984},
  {"1.13", 30025, 987},
  {"1.14", 30124, 990},
  {"1.15", 30223, 993},
  {"1.16", 30321, 996}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 147, 6, 36, "Subsection",
  CellTags->{"S5.49.1", "1.1"}],
Cell[1926, 61, 1050, 20, 152, "Text",
  CellTags->{"S5.49.1", "1.2"}],
Cell[2979, 83, 4075, 125, 106, "DefinitionBox",
  CellTags->"S5.49.1"],
Cell[7057, 210, 90, 1, 15, "Caption",
  CellTags->"S5.49.1"],
Cell[7150, 213, 78, 1, 40, "MathCaption",
  CellTags->{"S5.49.1", "1.3"}],
Cell[7231, 216, 97, 2, 28, "Input",
  CellTags->"S5.49.1"],
Cell[7331, 220, 168, 4, 40, "MathCaption",
  CellTags->{"S5.49.1", "1.4"}],

Cell[CellGroupData[{
Cell[7524, 228, 141, 5, 45, "Input",
  CellTags->"S5.49.1"],
Cell[7668, 235, 775, 32, 83, "Output",
  CellTags->"S5.49.1"]
}, Open  ]],
Cell[8458, 270, 184, 4, 56, "MathCaption",
  CellTags->{"S5.49.1", "1.5"}],

Cell[CellGroupData[{
Cell[8667, 278, 137, 5, 45, "Input",
  CellTags->"S5.49.1"],
Cell[8807, 285, 162, 5, 70, "Output",
  CellTags->"S5.49.1"]
}, Open  ]],
Cell[8984, 293, 935, 23, 70, "Text",
  CellTags->{"S5.49.1", "1.6"}],
Cell[9922, 318, 5247, 160, 70, "DefinitionBox",
  CellTags->"S5.49.1"],
Cell[15172, 480, 92, 1, 70, "Caption",
  CellTags->"S5.49.1"],
Cell[15267, 483, 739, 25, 70, "Text",
  CellTags->{"S5.49.1", "1.7"}],
Cell[16009, 510, 450, 13, 70, "MathCaption",
  CellTags->{"S5.49.1", "1.8"}],

Cell[CellGroupData[{
Cell[16484, 527, 170, 6, 70, "Input",
  CellTags->"S5.49.1"],
Cell[16657, 535, 973, 37, 70, "Output",
  CellTags->"S5.49.1"]
}, Open  ]],
Cell[17645, 575, 263, 7, 70, "MathCaption",
  CellTags->{"S5.49.1", "1.9"}],

Cell[CellGroupData[{
Cell[17933, 586, 148, 6, 70, "Input",
  CellTags->"S5.49.1"],
Cell[18084, 594, 298, 12, 70, "Output",
  CellTags->"S5.49.1"]
}, Open  ]],
Cell[18397, 609, 1453, 43, 70, "DefinitionBox",
  CellTags->"S5.49.1"],
Cell[19853, 654, 89, 1, 70, "Caption",
  CellTags->"S5.49.1"],
Cell[19945, 657, 161, 7, 70, "MathCaption",
  CellTags->{"S5.49.1", "1.10"}],

Cell[CellGroupData[{
Cell[20131, 668, 135, 5, 70, "Input",
  CellTags->"S5.49.1"],
Cell[20269, 675, 359, 13, 70, "Output",
  CellTags->"S5.49.1"]
}, Open  ]],
Cell[20643, 691, 130, 3, 70, "MathCaption",
  CellTags->{"S5.49.1", "1.11"}],

Cell[CellGroupData[{
Cell[20798, 698, 81, 2, 70, "Input",
  CellTags->"S5.49.1"],
Cell[20882, 702, 120, 4, 70, "Output",
  CellTags->"S5.49.1"]
}, Open  ]],
Cell[21017, 709, 1458, 44, 70, "DefinitionBox",
  CellTags->"S5.49.1"],
Cell[22478, 755, 71, 1, 70, "Caption",
  CellTags->"S5.49.1"],
Cell[22552, 758, 500, 11, 70, "Text",
  CellTags->{"S5.49.1", "1.12"}],
Cell[23055, 771, 108, 1, 70, "MathCaption",
  CellTags->{"S5.49.1", "1.13"}],
Cell[23166, 774, 275, 9, 70, "Input",
  CellTags->"S5.49.1"],
Cell[23444, 785, 145, 4, 70, "MathCaption",
  CellTags->{"S5.49.1", "1.14"}],

Cell[CellGroupData[{
Cell[23614, 793, 79, 2, 70, "Input",
  CellTags->"S5.49.1"],
Cell[23696, 797, 414, 13, 70, "Output",
  CellTags->"S5.49.1"]
}, Open  ]],
Cell[24125, 813, 97, 1, 70, "MathCaption",
  CellTags->{"S5.49.1", "1.15"}],

Cell[CellGroupData[{
Cell[24247, 818, 80, 2, 70, "Input",
  CellTags->"S5.49.1"],
Cell[24330, 822, 442, 14, 70, "Output",
  CellTags->"S5.49.1"]
}, Open  ]],
Cell[24787, 839, 251, 8, 70, "Text",
  CellTags->{"S5.49.1", "1.16"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

