(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12004,        408]*)
(*NotebookOutlinePosition[     15406,        513]*)
(*  CellTagsIndexPosition[     15149,        499]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Utilities",
 StyleBox["`", "MB"],
 "Package",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.14.1", "1.1"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FindPackages[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["path", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of files ending in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\".m\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" for each directory in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["path", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" (",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["path", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" may be a single directory of a list of directories)",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FindPackages[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["path", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pattern", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give a list of packages containing the given string pattern (the \
string pattern should not look for the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\".m\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[")",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.14.1"],

Cell[TextData[{
 "The ",
 StyleBox["FindPackages", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " function. "
}], "Caption",
 CellTags->"S6.14.1"],

Cell[TextData[{
 "The functions in this package are for searching and maintaining ",
 StyleBox["Mathematica", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " packages. ",
 StyleBox["FindPackages", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " will give a list of the packages available, in their context form (",
 StyleBox["e.g.", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", ",
 StyleBox["\"Utilities`Package`\"", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ") or in a full path name form (",
 StyleBox["e.g.", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", ",
 StyleBox["\"/usr/local/Wolfram/Mathematica/AddOns/StandardPackages/Utilities/\
Package.m\"", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ".) You can specify a list of directories to search. You can also specify a \
string pattern, or a list of patterns, to be matched. Note that a pattern \
should not try to match the ",
 StyleBox["\".m\"", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 "; the function handles this. "
}], "Text",
 CellTags->{"S6.14.1", "1.2"}],

Cell["This loads the package.", "MathCaption",
 CellTags->{"S6.14.1", "1.3"}],

Cell["<<Utilities`Package`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.14.1"],

Cell[TextData[{
 "This gives all packages whose names end in ",
 StyleBox["\"ca\"", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " for each directory in ",
 StyleBox["$Path", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". Directories containing no packages fitting the pattern give empty lists. \
"
}], "MathCaption",
 CellTags->{"S6.14.1", "1.4"}],

Cell[CellGroupData[{

Cell["FindPackages[$Path, \"*ca\"]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.14.1"],

Cell["{{}, {}, {}, {DiscreteMath`Combinatorica`}, {}}", "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S6.14.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FullPath -> True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["return full path names",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.14.1"],

Cell[TextData[{
 "Option for ",
 StyleBox["FindPackages", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". "
}], "Caption",
 CellTags->"S6.14.1"],

Cell["\<\
Here the same search is performed, but full path names are returned. \
\>", "MathCaption",
 CellTags->{"S6.14.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
FindPackages[$Path, \"*ca\",
 FullPath -> True]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.14.1"],

Cell["\<\
{{}, {}, {},
 {/usr/local/Wolfram/Mathematica/AddOns/StandardPackages/
 DiscreteMath/Combinatorica.m},
 {}}\
\>", "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S6.14.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Annotation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["package", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "return a list of the keywords (as strings) in the annotation comment \
fields of the given package",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Annotation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["package", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["keyword", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["return the annotation comments that are tagged by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["keyword", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.14.1"],

Cell[TextData[{
 "The ",
 StyleBox["Annotation", "MR"],
 " function. "
}], "Caption",
 CellTags->"S6.14.1"],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 " packages contain various annotative comments tagged with keywords. The ",
 StyleBox["Annotation", "MR"],
 " function allows you to discover what keywords are present in a package (or \
list of packages), then retrieve the actual annotation comments containing \
the keywords. This function recognizes a package name in either context form \
or as an explicit file name. "
}], "Text",
 CellTags->{"S6.14.1", "1.6"}],

Cell[TextData[{
 "This finds the annotative keywords in the ",
 StyleBox["Statistics`NonlinearFit`", "MR"],
 " package."
}], "MathCaption",
 CellTags->{"S6.14.1", "1.7"}],

Cell[CellGroupData[{

Cell["Annotation[\"Statistics`NonlinearFit`\"]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.14.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Title\"\>", ",", "\<\"Context\"\>", ",", "\<\"Name\"\>", 
   ",", "\<\"Author\"\>", ",", "\<\"Summary\"\>", ",", "\<\"Copyright\"\>", 
   ",", "\<\"Package Version\"\>", ",", "\<\"Mathematica Version\"\>", 
   ",", "\<\"History\"\>", ",", "\<\"Keywords\"\>", ",", "\<\"Sources\"\>", 
   ",", "\<\"Discussion\"\>", ",", "\<\"Warning\"\>", ",", "\<\"Example\"\>", 
   ",", "\<\"Example\"\>", ",", "\<\"Example\"\>"}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.14.1"]
}, Open  ]],

Cell[TextData[{
 "The string ",
 StyleBox["\"Mathematica", "MR"],
 " ",
 StyleBox["Version\"", "MR"],
 " is a useful keyword; it generally indicates the minimum release of ",
 StyleBox["Mathematica", "TI"],
 " required for a particular package."
}], "MathCaption",
 CellTags->{"S6.14.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
Annotation[\"Statistics`NonlinearFit`\",
   \"Mathematica Version\"]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.14.1"],

Cell[BoxData[
 RowBox[{"{", "\<\"(* :Mathematica Version: 5.0 *)\"\>", "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S6.14.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.14.1"->{
    Cell[1776, 53, 133, 6, 36, "Subsection",
      CellTags->{"S6.14.1", "1.1"}],
    Cell[1912, 61, 2661, 82, 102, "DefinitionBox",
      CellTags->"S6.14.1"],
    Cell[4576, 145, 166, 7, 15, "Caption",
      CellTags->"S6.14.1"],
    Cell[4745, 154, 1170, 34, 104, "Text",
      CellTags->{"S6.14.1", "1.2"}],
    Cell[5918, 190, 77, 1, 40, "MathCaption",
      CellTags->{"S6.14.1", "1.3"}],
    Cell[5998, 193, 83, 2, 28, "Input",
      CellTags->"S6.14.1"],
    Cell[6084, 197, 389, 12, 56, "MathCaption",
      CellTags->{"S6.14.1", "1.4"}],
    Cell[6498, 213, 91, 2, 28, "Input",
      CellTags->"S6.14.1"],
    Cell[6592, 217, 111, 2, 27, "Output",
      CellTags->"S6.14.1"],
    Cell[6718, 222, 663, 20, 46, "DefinitionBox",
      CellTags->"S6.14.1"],
    Cell[7384, 244, 164, 7, 15, "Caption",
      CellTags->"S6.14.1"],
    Cell[7551, 253, 131, 3, 40, "MathCaption",
      CellTags->{"S6.14.1", "1.5"}],
    Cell[7707, 260, 118, 5, 45, "Input",
      CellTags->"S6.14.1"],
    Cell[7828, 267, 179, 7, 78, "Output",
      CellTags->"S6.14.1"],
    Cell[8022, 277, 1938, 59, 70, "DefinitionBox",
      CellTags->"S6.14.1"],
    Cell[9963, 338, 107, 5, 70, "Caption",
      CellTags->"S6.14.1"],
    Cell[10073, 345, 465, 9, 70, "Text",
      CellTags->{"S6.14.1", "1.6"}],
    Cell[10541, 356, 170, 5, 70, "MathCaption",
      CellTags->{"S6.14.1", "1.7"}],
    Cell[10736, 365, 103, 2, 70, "Input",
      CellTags->"S6.14.1"],
    Cell[10842, 369, 523, 9, 70, "Output",
      CellTags->"S6.14.1"],
    Cell[11380, 381, 295, 9, 70, "MathCaption",
      CellTags->{"S6.14.1", "1.8"}],
    Cell[11700, 394, 139, 5, 70, "Input",
      CellTags->"S6.14.1"],
    Cell[11842, 401, 134, 3, 70, "Output",
      CellTags->"S6.14.1"]},
  "1.1"->{
    Cell[1776, 53, 133, 6, 36, "Subsection",
      CellTags->{"S6.14.1", "1.1"}]},
  "1.2"->{
    Cell[4745, 154, 1170, 34, 104, "Text",
      CellTags->{"S6.14.1", "1.2"}]},
  "1.3"->{
    Cell[5918, 190, 77, 1, 40, "MathCaption",
      CellTags->{"S6.14.1", "1.3"}]},
  "1.4"->{
    Cell[6084, 197, 389, 12, 56, "MathCaption",
      CellTags->{"S6.14.1", "1.4"}]},
  "1.5"->{
    Cell[7551, 253, 131, 3, 40, "MathCaption",
      CellTags->{"S6.14.1", "1.5"}]},
  "1.6"->{
    Cell[10073, 345, 465, 9, 70, "Text",
      CellTags->{"S6.14.1", "1.6"}]},
  "1.7"->{
    Cell[10541, 356, 170, 5, 70, "MathCaption",
      CellTags->{"S6.14.1", "1.7"}]},
  "1.8"->{
    Cell[11380, 381, 295, 9, 70, "MathCaption",
      CellTags->{"S6.14.1", "1.8"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.14.1", 12627, 424},
  {"1.1", 14377, 471},
  {"1.2", 14471, 474},
  {"1.3", 14563, 477},
  {"1.4", 14658, 480},
  {"1.5", 14755, 483},
  {"1.6", 14851, 486},
  {"1.7", 14941, 489},
  {"1.8", 15038, 492}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 133, 6, 36, "Subsection",
  CellTags->{"S6.14.1", "1.1"}],
Cell[1912, 61, 2661, 82, 102, "DefinitionBox",
  CellTags->"S6.14.1"],
Cell[4576, 145, 166, 7, 15, "Caption",
  CellTags->"S6.14.1"],
Cell[4745, 154, 1170, 34, 104, "Text",
  CellTags->{"S6.14.1", "1.2"}],
Cell[5918, 190, 77, 1, 40, "MathCaption",
  CellTags->{"S6.14.1", "1.3"}],
Cell[5998, 193, 83, 2, 28, "Input",
  CellTags->"S6.14.1"],
Cell[6084, 197, 389, 12, 56, "MathCaption",
  CellTags->{"S6.14.1", "1.4"}],

Cell[CellGroupData[{
Cell[6498, 213, 91, 2, 28, "Input",
  CellTags->"S6.14.1"],
Cell[6592, 217, 111, 2, 27, "Output",
  CellTags->"S6.14.1"]
}, Open  ]],
Cell[6718, 222, 663, 20, 46, "DefinitionBox",
  CellTags->"S6.14.1"],
Cell[7384, 244, 164, 7, 15, "Caption",
  CellTags->"S6.14.1"],
Cell[7551, 253, 131, 3, 40, "MathCaption",
  CellTags->{"S6.14.1", "1.5"}],

Cell[CellGroupData[{
Cell[7707, 260, 118, 5, 45, "Input",
  CellTags->"S6.14.1"],
Cell[7828, 267, 179, 7, 78, "Output",
  CellTags->"S6.14.1"]
}, Open  ]],
Cell[8022, 277, 1938, 59, 70, "DefinitionBox",
  CellTags->"S6.14.1"],
Cell[9963, 338, 107, 5, 70, "Caption",
  CellTags->"S6.14.1"],
Cell[10073, 345, 465, 9, 70, "Text",
  CellTags->{"S6.14.1", "1.6"}],
Cell[10541, 356, 170, 5, 70, "MathCaption",
  CellTags->{"S6.14.1", "1.7"}],

Cell[CellGroupData[{
Cell[10736, 365, 103, 2, 70, "Input",
  CellTags->"S6.14.1"],
Cell[10842, 369, 523, 9, 70, "Output",
  CellTags->"S6.14.1"]
}, Open  ]],
Cell[11380, 381, 295, 9, 70, "MathCaption",
  CellTags->{"S6.14.1", "1.8"}],

Cell[CellGroupData[{
Cell[11700, 394, 139, 5, 70, "Input",
  CellTags->"S6.14.1"],
Cell[11842, 401, 134, 3, 70, "Output",
  CellTags->"S6.14.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

