(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     35040,       1632]*)
(*NotebookOutlinePosition[     40817,       1805]*)
(*  CellTagsIndexPosition[     40352,       1783]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Calculus",
 StyleBox["`", "MB"],
 "Pade",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.14.1", "1.1"}],

Cell["\<\
A rational function is the ratio of polynomials. Because these functions only \
use the elementary arithmetic operations, they are very easy to evaluate \
numerically. The polynomial in the denominator allows one to approximate \
functions that have rational singularities. For these reasons it is \
frequently useful in numerical work to approximate a given function by a \
rational function. \
\>", "Text",
 CellTags->{"S5.14.1", "1.2"}],

Cell[TextData[{
 "There are various methods to perform this approximation. The methods differ \
in how they interpret the notion of the goodness of the approximation. Each \
method is useful for certain classes of problems. This package computes Pad\
\[EAcute] approximations and economized rational approximations. The package \
",
 StyleBox["NumericalMath`Approximations`", "MR"],
 " contains functions that perform general rational and minimax \
approximations. "
}], "Text",
 CellTags->{"S5.14.1", "1.3"}],

Cell[TextData[{
 "There is a related class of approximation questions that involve the \
interpolation or fitting of a set of data points by an approximating \
function. In this type of situation you can use the built\[Hyphen]in \
functions ",
 StyleBox["Fit", "MR"],
 ", ",
 StyleBox["InterpolatingPolynomial", "MR"],
 ", and ",
 StyleBox["Interpolation", "MR"],
 ". For more information, see the section covering numerical operations on \
data in ",
 StyleBox["The Mathematica Book", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.14.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Pade[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the Pad\[EAcute] approximation to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" centered at ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" of degree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["m",
           "TI"], ",", 
          StyleBox["k",
           "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.14.1"],

Cell["Pad\[EAcute] approximations. ", "Caption",
 CellTags->"S5.14.1"],

Cell[TextData[{
 "The Pad\[EAcute] approximation can be thought of as a generalization of a \
Taylor polynomial. More precisely, a Pad\[EAcute] approximation of degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["m",
      "TI"], ",", 
     StyleBox["k",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at a point ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the rational function ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     StyleBox["p",
      "TI"], 
     RowBox[{"(", 
      StyleBox["x",
       "TI"], ")"}]}], 
    RowBox[{
     StyleBox["q",
      "TI"], 
     RowBox[{"(", 
      StyleBox["x",
       "TI"], ")"}]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a polynomial of degree ",
 Cell[BoxData[
  FormBox[
   StyleBox["m",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["q",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a polynomial of degree ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and the formal power series of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], 
    StyleBox["q",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "-", 
    StyleBox["p",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " about the point ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " begins with the term ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["x",
     "TI"], 
    RowBox[{
     StyleBox["m",
      "TI"], "+", 
     StyleBox["k",
      "TI"], "+", "1"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.14.1", "1.5"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.14.1", "1.6"}],

Cell["<< Calculus`Pade`;", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.14.1"],

Cell[TextData[{
 "Here is the Pad\[EAcute] approximation of degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "4"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.14.1", "1.7"}],

Cell[CellGroupData[{

Cell["Pade[Cos[x], {x, 0, 2, 4}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.14.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"61", " ", 
     SuperscriptBox["x", "2"]}], "150"]}], 
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "2"]}], "75"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "200"]}]]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.14.1"]
}, Open  ]],

Cell["This gives another Pad\[EAcute] approximation of the same degree. ", \
"MathCaption",
 CellTags->{"S5.14.1", "1.8"}],

Cell[CellGroupData[{

Cell["pd = Pade[Exp[x], {x, 1, 2, 4}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.14.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ExponentialE]", "+", 
   RowBox[{
    FractionBox["1", "3"], " ", "\[ExponentialE]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "30"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "30"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]}]}]]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.14.1"]
}, Open  ]],

Cell["\<\
The initial terms of this series vanish. This is the property that \
characterizes the Pad\[EAcute] approximation. \
\>", "MathCaption",
 CellTags->{"S5.14.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
Series[Exp[x] Denominator[pd] -
         Numerator[pd], {x, 1, 8}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.14.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "7"]}], "75600"], "+", 
   FractionBox[
    RowBox[{"\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "8"]}], "120960"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "9"],
    SeriesData[x, 1, {}, 7, 9, 1],
    Editable->False]}],
  SeriesData[x, 1, {Rational[1, 75600] E, Rational[1, 120960] E}, 7, 9, 1],
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.14.1"]
}, Open  ]],

Cell["\<\
This plots the difference between the approximation and the true function. \
Notice that the approximation is very good near the center of expansion, but \
the error increases very rapidly as you move away. \
\>", "MathCaption",
 CellTags->{"S5.14.1", "1.10"}],

Cell[CellGroupData[{

Cell["Plot[pd - Exp[x], {x, 0, 2}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.14.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.377177 9.9737e+06 [
[.2619 .36468 -9 -9 ]
[.2619 .36468 9 0 ]
[.5 .36468 -3 -9 ]
[.5 .36468 3 0 ]
[.7381 .36468 -9 -9 ]
[.7381 .36468 9 0 ]
[.97619 .36468 -3 -9 ]
[.97619 .36468 3 0 ]
[.01131 .07797 -39 -6.25 ]
[.01131 .07797 0 6.25 ]
[.01131 .1777 -39 -6.25 ]
[.01131 .1777 0 6.25 ]
[.01131 .27744 -39 -6.25 ]
[.01131 .27744 0 6.25 ]
[.01131 .47691 -33 -6.25 ]
[.01131 .47691 0 6.25 ]
[.01131 .57665 -33 -6.25 ]
[.01131 .57665 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .37718 m
.2619 .38343 L
s
[(0.5)] .2619 .36468 0 1 Mshowa
.5 .37718 m
.5 .38343 L
s
[(1)] .5 .36468 0 1 Mshowa
.7381 .37718 m
.7381 .38343 L
s
[(1.5)] .7381 .36468 0 1 Mshowa
.97619 .37718 m
.97619 .38343 L
s
[(2)] .97619 .36468 0 1 Mshowa
.125 Mabswid
.07143 .37718 m
.07143 .38093 L
s
.11905 .37718 m
.11905 .38093 L
s
.16667 .37718 m
.16667 .38093 L
s
.21429 .37718 m
.21429 .38093 L
s
.30952 .37718 m
.30952 .38093 L
s
.35714 .37718 m
.35714 .38093 L
s
.40476 .37718 m
.40476 .38093 L
s
.45238 .37718 m
.45238 .38093 L
s
.54762 .37718 m
.54762 .38093 L
s
.59524 .37718 m
.59524 .38093 L
s
.64286 .37718 m
.64286 .38093 L
s
.69048 .37718 m
.69048 .38093 L
s
.78571 .37718 m
.78571 .38093 L
s
.83333 .37718 m
.83333 .38093 L
s
.88095 .37718 m
.88095 .38093 L
s
.92857 .37718 m
.92857 .38093 L
s
.25 Mabswid
0 .37718 m
1 .37718 L
s
.02381 .07797 m
.03006 .07797 L
s
gsave
.01131 .07797 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-3) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .1777 m
.03006 .1777 L
s
gsave
.01131 .1777 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .27744 m
.03006 .27744 L
s
gsave
.01131 .27744 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .47691 m
.03006 .47691 L
s
gsave
.01131 .47691 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.02381 .57665 m
.03006 .57665 L
s
gsave
.01131 .57665 -33 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-8) show
grestore
.125 Mabswid
.02381 .09791 m
.02756 .09791 L
s
.02381 .11786 m
.02756 .11786 L
s
.02381 .13781 m
.02756 .13781 L
s
.02381 .15776 m
.02756 .15776 L
s
.02381 .19765 m
.02756 .19765 L
s
.02381 .2176 m
.02756 .2176 L
s
.02381 .23755 m
.02756 .23755 L
s
.02381 .25749 m
.02756 .25749 L
s
.02381 .29739 m
.02756 .29739 L
s
.02381 .31733 m
.02756 .31733 L
s
.02381 .33728 m
.02756 .33728 L
s
.02381 .35723 m
.02756 .35723 L
s
.02381 .39712 m
.02756 .39712 L
s
.02381 .41707 m
.02756 .41707 L
s
.02381 .43702 m
.02756 .43702 L
s
.02381 .45697 m
.02756 .45697 L
s
.02381 .49686 m
.02756 .49686 L
s
.02381 .51681 m
.02756 .51681 L
s
.02381 .53676 m
.02756 .53676 L
s
.02381 .5567 m
.02756 .5567 L
s
.02381 .05802 m
.02756 .05802 L
s
.02381 .03807 m
.02756 .03807 L
s
.02381 .01812 m
.02756 .01812 L
s
.02381 .5966 m
.02756 .5966 L
s
.02381 .61655 m
.02756 .61655 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.32036 .61803 m
.32042 .61738 L
.32989 .54577 L
.33881 .49559 L
.34857 .45565 L
.35349 .44028 L
.35889 .42641 L
.3635 .41667 L
.36844 .40809 L
.37736 .39655 L
.38265 .39161 L
.38754 .38803 L
.3929 .385 L
.3986 .38259 L
.40353 .38105 L
.40817 .37995 L
.41325 .37907 L
.41589 .37871 L
.41872 .37839 L
.42132 .37815 L
.42368 .37797 L
.42829 .3777 L
.43088 .37758 L
.43368 .37748 L
.43631 .37741 L
.43876 .37735 L
.4413 .37731 L
.4441 .37727 L
.44682 .37724 L
.44974 .37722 L
.45245 .37721 L
.45503 .3772 L
.45734 .37719 L
.45986 .37719 L
.4612 .37718 L
.46243 .37718 L
.46375 .37718 L
.46519 .37718 L
.46763 .37718 L
.46897 .37718 L
.47021 .37718 L
.47142 .37718 L
.47258 .37718 L
.47362 .37718 L
.47473 .37718 L
.47594 .37718 L
.47705 .37718 L
.47837 .37718 L
.47957 .37718 L
.48078 .37718 L
Mistroke
.48206 .37718 L
.48333 .37718 L
.48473 .37718 L
.48594 .37718 L
.48723 .37718 L
.48845 .37718 L
.48956 .37718 L
.49024 .37718 L
.49097 .37718 L
.49228 .37718 L
.493 .37718 L
.49368 .37718 L
.49442 .37718 L
.49522 .37718 L
.49591 .37718 L
.49665 .37718 L
.49736 .37718 L
.49801 .37718 L
.49925 .37718 L
.50056 .37718 L
.50512 .37718 L
.50632 .37718 L
.5076 .37718 L
.50881 .37718 L
.50991 .37718 L
.51121 .37718 L
.51243 .37718 L
.51375 .37718 L
.51449 .37718 L
.51518 .37718 L
.51639 .37718 L
.51752 .37718 L
.51871 .37718 L
.52001 .37718 L
.52114 .37718 L
.52237 .37718 L
.52353 .37718 L
.52461 .37718 L
.52566 .37718 L
.52664 .37718 L
.52778 .37718 L
.52881 .37718 L
.52996 .37718 L
.53118 .37718 L
.53336 .37717 L
.53457 .37717 L
.53571 .37717 L
.53828 .37717 L
.53954 .37717 L
.54088 .37716 L
Mistroke
.54329 .37716 L
.54463 .37715 L
.54588 .37715 L
.54874 .37713 L
.55123 .37711 L
.55351 .37708 L
.55601 .37705 L
.55865 .377 L
.56087 .37694 L
.56324 .37687 L
.56751 .37668 L
.57013 .37653 L
.57259 .37634 L
.57721 .37587 L
.5796 .37555 L
.58184 .37519 L
.58451 .37467 L
.58694 .3741 L
.5919 .37258 L
.59464 .37149 L
.59724 .37026 L
.60182 .3675 L
.60607 .36415 L
.61073 .35934 L
.61569 .3526 L
.62107 .34289 L
.62602 .33119 L
.63144 .31448 L
.63716 .29135 L
.64215 .26546 L
.64679 .23544 L
.65185 .19497 L
.65735 .13993 L
.6628 .07147 L
Mfstroke
.6628 .07147 m
.66742 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.14.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.14.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["EconomizedRationalApproximation[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the economized rational approximation to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" that is good in the range ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and has degree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"(", 
         RowBox[{
          StyleBox["m",
           "TI"], ",", 
          StyleBox["k",
           "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.14.1"],

Cell["Economized rational approximations. ", "Caption",
 CellTags->"S5.14.1"],

Cell["\<\
A Pad\[EAcute] approximation is very accurate near the center of expansion, \
but the error increases rapidly as you get farther away. If one is willing to \
sacrifice some of the goodness of fit near the center of expansion it is \
possible to obtain a better fit over the entire interval under consideration. \
This is what the other types of approximation do. \
\>", "Text",
 CellTags->{"S5.14.1", "1.11"}],

Cell[TextData[{
 "With an economized rational approximation, the idea is to start with a Pad\
\[EAcute] approximation and perturb it with a Chebyshev polynomial in such a \
way as to reduce the leading coefficient in the error. This perturbation does \
cause the vanished terms to reappear. However, the magnitude of the error \
does not increase very much near the center of expansion and this small \
increase is compensated for by a decrease in the error farther away. With ",
 StyleBox["EconomizedRationalApproximation", "MR"],
 " you specify the interval over which the approximation is to work rather \
than the center of expansion. In the limit as the length of the interval goes \
to zero, the economized rational approximation approaches the Pad\[EAcute] \
approximation. "
}], "Text",
 CellTags->{"S5.14.1", "1.12"}],

Cell[TextData[{
 "Here is the economized rational approximation of degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", ",", "4"}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " over the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", 
    StyleBox["x",
     "TI"], "\[LessEqual]", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.14.1", "1.13"}],

Cell[CellGroupData[{

Cell["\<\
era =
EconomizedRationalApproximation[Exp[x],
   {x, {0, 2}, 2, 4}]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.14.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   FractionBox[
    RowBox[{"679583", " ", "\[ExponentialE]"}], "691200"], "+", 
   FractionBox[
    RowBox[{"4679", " ", "\[ExponentialE]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "14400"], "+", 
   RowBox[{
    FractionBox["23", "720"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}]}], 
  RowBox[{
   FractionBox["679583", "691200"], "-", 
   FractionBox[
    RowBox[{"9479", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "14400"], "+", 
   RowBox[{
    FractionBox["143", "720"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "30"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]}]}]]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.14.1"]
}, Open  ]],

Cell["\<\
This gives the difference between the true function and the economized \
rational approximation. In general you may even get a small nonvanishing \
constant term. \
\>", "MathCaption",
 CellTags->{"S5.14.1", "1.14"}],

Cell[CellGroupData[{

Cell["Series[era - Exp[x], {x, 1, 2}]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.14.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[ExponentialE]", " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}]}], "679583"], "+", 
   FractionBox[
    RowBox[{"1589567", " ", "\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "2"]}], "923666107778"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "3"],
    SeriesData[x, 1, {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[
  x, 1, {Rational[1, 679583] E, Rational[1589567, 923666107778] E}, 1, 3, 1],
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.14.1"]
}, Open  ]],

Cell["\<\
The error has been spread out when compared to the Pad\[EAcute] approximation \
plotted above. \
\>", "MathCaption",
 CellTags->{"S5.14.1", "1.15"}],

Cell[CellGroupData[{

Cell["Plot[era - Exp[x], {x, 0, 2}]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.14.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.527129 101000 [
[.2619 .51463 -9 -9 ]
[.2619 .51463 9 0 ]
[.5 .51463 -3 -9 ]
[.5 .51463 3 0 ]
[.7381 .51463 -9 -9 ]
[.7381 .51463 9 0 ]
[.97619 .51463 -3 -9 ]
[.97619 .51463 3 0 ]
[.01131 .02213 -39 -6.25 ]
[.01131 .02213 0 6.25 ]
[.01131 .12313 -39 -6.25 ]
[.01131 .12313 0 6.25 ]
[.01131 .22413 -39 -6.25 ]
[.01131 .22413 0 6.25 ]
[.01131 .32513 -39 -6.25 ]
[.01131 .32513 0 6.25 ]
[.01131 .42613 -39 -6.25 ]
[.01131 .42613 0 6.25 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .52713 m
.2619 .53338 L
s
[(0.5)] .2619 .51463 0 1 Mshowa
.5 .52713 m
.5 .53338 L
s
[(1)] .5 .51463 0 1 Mshowa
.7381 .52713 m
.7381 .53338 L
s
[(1.5)] .7381 .51463 0 1 Mshowa
.97619 .52713 m
.97619 .53338 L
s
[(2)] .97619 .51463 0 1 Mshowa
.125 Mabswid
.07143 .52713 m
.07143 .53088 L
s
.11905 .52713 m
.11905 .53088 L
s
.16667 .52713 m
.16667 .53088 L
s
.21429 .52713 m
.21429 .53088 L
s
.30952 .52713 m
.30952 .53088 L
s
.35714 .52713 m
.35714 .53088 L
s
.40476 .52713 m
.40476 .53088 L
s
.45238 .52713 m
.45238 .53088 L
s
.54762 .52713 m
.54762 .53088 L
s
.59524 .52713 m
.59524 .53088 L
s
.64286 .52713 m
.64286 .53088 L
s
.69048 .52713 m
.69048 .53088 L
s
.78571 .52713 m
.78571 .53088 L
s
.83333 .52713 m
.83333 .53088 L
s
.88095 .52713 m
.88095 .53088 L
s
.92857 .52713 m
.92857 .53088 L
s
.25 Mabswid
0 .52713 m
1 .52713 L
s
.02381 .02213 m
.03006 .02213 L
s
gsave
.01131 .02213 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-5) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.02381 .12313 m
.03006 .12313 L
s
gsave
.01131 .12313 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-4) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.02381 .22413 m
.03006 .22413 L
s
gsave
.01131 .22413 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-3) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.02381 .32513 m
.03006 .32513 L
s
gsave
.01131 .32513 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-2) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.02381 .42613 m
.03006 .42613 L
s
gsave
.01131 .42613 -39 -4.25 Mabsadd m
1 1 Mabs scale
/Courier findfont 10 scalefont setfont
(-1) show
/Math1Mono findfont 10 scalefont setfont
(\\264) show
/Courier findfont 10 scalefont setfont
(10) show
0 5.25 rmoveto
/Courier findfont 7.5 scalefont setfont
(-6) show
grestore
.125 Mabswid
.02381 .04233 m
.02756 .04233 L
s
.02381 .06253 m
.02756 .06253 L
s
.02381 .08273 m
.02756 .08273 L
s
.02381 .10293 m
.02756 .10293 L
s
.02381 .14333 m
.02756 .14333 L
s
.02381 .16353 m
.02756 .16353 L
s
.02381 .18373 m
.02756 .18373 L
s
.02381 .20393 m
.02756 .20393 L
s
.02381 .24433 m
.02756 .24433 L
s
.02381 .26453 m
.02756 .26453 L
s
.02381 .28473 m
.02756 .28473 L
s
.02381 .30493 m
.02756 .30493 L
s
.02381 .34533 m
.02756 .34533 L
s
.02381 .36553 m
.02756 .36553 L
s
.02381 .38573 m
.02756 .38573 L
s
.02381 .40593 m
.02756 .40593 L
s
.02381 .44633 m
.02756 .44633 L
s
.02381 .46653 m
.02756 .46653 L
s
.02381 .48673 m
.02756 .48673 L
s
.02381 .50693 m
.02756 .50693 L
s
.02381 .00193 m
.02756 .00193 L
s
.02381 .54733 m
.02756 .54733 L
s
.02381 .56753 m
.02756 .56753 L
s
.02381 .58773 m
.02756 .58773 L
s
.02381 .60793 m
.02756 .60793 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .40487 m
.02605 .40533 L
.02846 .40599 L
.03279 .40759 L
.03793 .41012 L
.04262 .41296 L
.06244 .42949 L
.10458 .47655 L
.12534 .49961 L
.14451 .51827 L
.16316 .53292 L
.17268 .53885 L
.18292 .54399 L
.18815 .5461 L
.19312 .54779 L
.19796 .54914 L
.20246 .55013 L
.20669 .55083 L
.20906 .55113 L
.21121 .55134 L
.21236 .55144 L
.21357 .55152 L
.2142 .55155 L
.2149 .55158 L
.21613 .55163 L
.21728 .55165 L
.21852 .55166 L
.21969 .55165 L
.22076 .55163 L
.22194 .5516 L
.22304 .55155 L
.22426 .55148 L
.22557 .55138 L
.22823 .55114 L
.23067 .55084 L
.23514 .55015 L
.23984 .5492 L
.24976 .54651 L
.2606 .54263 L
.30117 .52212 L
.34021 .50032 L
.35045 .49537 L
.36156 .49069 L
.37115 .48734 L
.37624 .48586 L
.38171 .48451 L
.38707 .48345 L
.39198 .48272 L
.39433 .48245 L
.39691 .48221 L
Mistroke
.39808 .48213 L
.39933 .48205 L
.40051 .482 L
.40158 .48196 L
.40291 .48193 L
.40357 .48192 L
.4043 .48192 L
.40559 .48192 L
.4068 .48194 L
.40753 .48196 L
.40822 .48199 L
.40951 .48205 L
.41091 .48213 L
.41243 .48224 L
.415 .48249 L
.41773 .48283 L
.42263 .48364 L
.42753 .4847 L
.43202 .4859 L
.44214 .48939 L
.46043 .49831 L
.47939 .51075 L
.50011 .52722 L
.54072 .56312 L
.55949 .57853 L
.57982 .59214 L
.58523 .59501 L
.59095 .59764 L
.59625 .59966 L
.6012 .60117 L
.60584 .60224 L
.60844 .60268 L
.61081 .60299 L
.61216 .60312 L
.61341 .60321 L
.61406 .60325 L
.61477 .60328 L
.61552 .6033 L
.61623 .60332 L
.61752 .60332 L
.6187 .60329 L
.62 .60324 L
.62065 .6032 L
.62137 .60314 L
.6239 .60288 L
.62532 .60268 L
.62664 .60246 L
.63162 .60132 L
.63615 .59987 L
.64095 .59789 L
Mistroke
.65092 .59231 L
.6619 .58387 L
.68132 .56323 L
.7022 .53385 L
.74345 .46286 L
.76405 .42754 L
.78318 .39936 L
.7927 .38788 L
.80168 .37896 L
.80664 .37486 L
.81202 .3711 L
.81654 .36848 L
.82139 .36621 L
.82631 .36443 L
.8309 .36319 L
.83371 .36262 L
.83636 .36219 L
.84134 .3616 L
.84661 .36117 L
.85156 .36078 L
.85404 .36053 L
.85672 .36018 L
.85969 .35965 L
.86241 .35898 L
.86481 .35821 L
.86705 .35731 L
.86971 .35597 L
.87212 .35444 L
.87706 .35023 L
.87977 .34718 L
.88234 .34372 L
.88694 .33589 L
.89118 .32651 L
.89583 .31335 L
.90076 .29555 L
.91021 .24755 L
.91551 .21074 L
.92035 .16958 L
.92975 .06491 L
Mfstroke
.92975 .06491 m
.93399 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.14.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.14.1"]
}, Open  ]],

Cell[TextData[{
 "Even though the error at the endpoint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "=", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not particularly small, it is considerably smaller than what ",
 StyleBox["Pade", "MR"],
 " gives. "
}], "MathCaption",
 CellTags->{"S5.14.1", "1.16"}],

Cell[CellGroupData[{

Cell["N[(pd - Exp[x])/(era - Exp[x]) /. x -> 2]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.14.1"],

Cell[BoxData["7.535120171246252`"], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.14.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.14.1"->{
    Cell[1776, 53, 129, 6, 36, "Subsection",
      CellTags->{"S5.14.1", "1.1"}],
    Cell[1908, 61, 449, 8, 72, "Text",
      CellTags->{"S5.14.1", "1.2"}],
    Cell[2360, 71, 509, 10, 88, "Text",
      CellTags->{"S5.14.1", "1.3"}],
    Cell[2872, 83, 541, 15, 72, "Text",
      CellTags->{"S5.14.1", "1.4"}],
    Cell[3416, 100, 2705, 85, 60, "DefinitionBox",
      CellTags->"S5.14.1"],
    Cell[6124, 187, 70, 1, 15, "Caption",
      CellTags->"S5.14.1"],
    Cell[6197, 190, 2887, 119, 78, "Text",
      CellTags->{"S5.14.1", "1.5"}],
    Cell[9087, 311, 78, 1, 40, "MathCaption",
      CellTags->{"S5.14.1", "1.6"}],
    Cell[9168, 314, 81, 2, 28, "Input",
      CellTags->"S5.14.1"],
    Cell[9252, 318, 652, 24, 40, "MathCaption",
      CellTags->{"S5.14.1", "1.7"}],
    Cell[9929, 346, 89, 2, 27, "Input",
      CellTags->"S5.14.1"],
    Cell[10021, 350, 352, 13, 73, "Output",
      CellTags->"S5.14.1"],
    Cell[10388, 366, 122, 2, 40, "MathCaption",
      CellTags->{"S5.14.1", "1.8"}],
    Cell[10535, 372, 94, 2, 70, "Input",
      CellTags->"S5.14.1"],
    Cell[10632, 376, 1082, 39, 70, "Output",
      CellTags->"S5.14.1"],
    Cell[11729, 418, 177, 4, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.9"}],
    Cell[11931, 426, 137, 5, 70, "Input",
      CellTags->"S5.14.1"],
    Cell[12071, 433, 681, 22, 70, "Output",
      CellTags->"S5.14.1"],
    Cell[12767, 458, 270, 5, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.10"}],
    Cell[13062, 467, 91, 2, 70, "Input",
      CellTags->"S5.14.1"],
    Cell[13156, 471, 6612, 430, 70, 6541, 427, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.14.1"],
    Cell[19771, 903, 180, 6, 70, "Output",
      CellTags->"S5.14.1"],
    Cell[19966, 912, 2798, 87, 70, "DefinitionBox",
      CellTags->"S5.14.1"],
    Cell[22767, 1001, 77, 1, 70, "Caption",
      CellTags->"S5.14.1"],
    Cell[22847, 1004, 419, 7, 70, "Text",
      CellTags->{"S5.14.1", "1.11"}],
    Cell[23269, 1013, 826, 13, 70, "Text",
      CellTags->{"S5.14.1", "1.12"}],
    Cell[24098, 1028, 710, 25, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.13"}],
    Cell[24833, 1057, 138, 6, 70, "Input",
      CellTags->"S5.14.1"],
    Cell[24974, 1065, 1197, 42, 70, "Output",
      CellTags->"S5.14.1"],
    Cell[26186, 1110, 226, 5, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.14"}],
    Cell[26437, 1119, 94, 2, 70, "Input",
      CellTags->"S5.14.1"],
    Cell[26534, 1123, 691, 22, 70, "Output",
      CellTags->"S5.14.1"],
    Cell[27240, 1148, 158, 4, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.15"}],
    Cell[27423, 1156, 92, 2, 70, "Input",
      CellTags->"S5.14.1"],
    Cell[27518, 1160, 6695, 435, 70, 6624, 432, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.14.1"],
    Cell[34216, 1597, 180, 6, 70, "Output",
      CellTags->"S5.14.1"],
    Cell[34411, 1606, 378, 12, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.16"}],
    Cell[34814, 1622, 104, 2, 70, "Input",
      CellTags->"S5.14.1"],
    Cell[34921, 1626, 91, 2, 70, "Output",
      CellTags->"S5.14.1"]},
  "1.1"->{
    Cell[1776, 53, 129, 6, 36, "Subsection",
      CellTags->{"S5.14.1", "1.1"}]},
  "1.2"->{
    Cell[1908, 61, 449, 8, 72, "Text",
      CellTags->{"S5.14.1", "1.2"}]},
  "1.3"->{
    Cell[2360, 71, 509, 10, 88, "Text",
      CellTags->{"S5.14.1", "1.3"}]},
  "1.4"->{
    Cell[2872, 83, 541, 15, 72, "Text",
      CellTags->{"S5.14.1", "1.4"}]},
  "1.5"->{
    Cell[6197, 190, 2887, 119, 78, "Text",
      CellTags->{"S5.14.1", "1.5"}]},
  "1.6"->{
    Cell[9087, 311, 78, 1, 40, "MathCaption",
      CellTags->{"S5.14.1", "1.6"}]},
  "1.7"->{
    Cell[9252, 318, 652, 24, 40, "MathCaption",
      CellTags->{"S5.14.1", "1.7"}]},
  "1.8"->{
    Cell[10388, 366, 122, 2, 40, "MathCaption",
      CellTags->{"S5.14.1", "1.8"}]},
  "1.9"->{
    Cell[11729, 418, 177, 4, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.9"}]},
  "1.10"->{
    Cell[12767, 458, 270, 5, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.10"}]},
  "1.11"->{
    Cell[22847, 1004, 419, 7, 70, "Text",
      CellTags->{"S5.14.1", "1.11"}]},
  "1.12"->{
    Cell[23269, 1013, 826, 13, 70, "Text",
      CellTags->{"S5.14.1", "1.12"}]},
  "1.13"->{
    Cell[24098, 1028, 710, 25, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.13"}]},
  "1.14"->{
    Cell[26186, 1110, 226, 5, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.14"}]},
  "1.15"->{
    Cell[27240, 1148, 158, 4, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.15"}]},
  "1.16"->{
    Cell[34411, 1606, 378, 12, 70, "MathCaption",
      CellTags->{"S5.14.1", "1.16"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.14.1", 35663, 1648},
  {"1.1", 38812, 1731},
  {"1.2", 38906, 1734},
  {"1.3", 38994, 1737},
  {"1.4", 39083, 1740},
  {"1.5", 39172, 1743},
  {"1.6", 39264, 1746},
  {"1.7", 39359, 1749},
  {"1.8", 39456, 1752},
  {"1.9", 39553, 1755},
  {"1.10", 39651, 1758},
  {"1.11", 39750, 1761},
  {"1.12", 39843, 1764},
  {"1.13", 39937, 1767},
  {"1.14", 40038, 1770},
  {"1.15", 40138, 1773},
  {"1.16", 40238, 1776}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 129, 6, 36, "Subsection",
  CellTags->{"S5.14.1", "1.1"}],
Cell[1908, 61, 449, 8, 72, "Text",
  CellTags->{"S5.14.1", "1.2"}],
Cell[2360, 71, 509, 10, 88, "Text",
  CellTags->{"S5.14.1", "1.3"}],
Cell[2872, 83, 541, 15, 72, "Text",
  CellTags->{"S5.14.1", "1.4"}],
Cell[3416, 100, 2705, 85, 60, "DefinitionBox",
  CellTags->"S5.14.1"],
Cell[6124, 187, 70, 1, 15, "Caption",
  CellTags->"S5.14.1"],
Cell[6197, 190, 2887, 119, 78, "Text",
  CellTags->{"S5.14.1", "1.5"}],
Cell[9087, 311, 78, 1, 40, "MathCaption",
  CellTags->{"S5.14.1", "1.6"}],
Cell[9168, 314, 81, 2, 28, "Input",
  CellTags->"S5.14.1"],
Cell[9252, 318, 652, 24, 40, "MathCaption",
  CellTags->{"S5.14.1", "1.7"}],

Cell[CellGroupData[{
Cell[9929, 346, 89, 2, 27, "Input",
  CellTags->"S5.14.1"],
Cell[10021, 350, 352, 13, 73, "Output",
  CellTags->"S5.14.1"]
}, Open  ]],
Cell[10388, 366, 122, 2, 40, "MathCaption",
  CellTags->{"S5.14.1", "1.8"}],

Cell[CellGroupData[{
Cell[10535, 372, 94, 2, 70, "Input",
  CellTags->"S5.14.1"],
Cell[10632, 376, 1082, 39, 70, "Output",
  CellTags->"S5.14.1"]
}, Open  ]],
Cell[11729, 418, 177, 4, 70, "MathCaption",
  CellTags->{"S5.14.1", "1.9"}],

Cell[CellGroupData[{
Cell[11931, 426, 137, 5, 70, "Input",
  CellTags->"S5.14.1"],
Cell[12071, 433, 681, 22, 70, "Output",
  CellTags->"S5.14.1"]
}, Open  ]],
Cell[12767, 458, 270, 5, 70, "MathCaption",
  CellTags->{"S5.14.1", "1.10"}],

Cell[CellGroupData[{
Cell[13062, 467, 91, 2, 70, "Input",
  CellTags->"S5.14.1"],
Cell[13156, 471, 6612, 430, 70, 6541, 427, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.14.1"],
Cell[19771, 903, 180, 6, 70, "Output",
  CellTags->"S5.14.1"]
}, Open  ]],
Cell[19966, 912, 2798, 87, 70, "DefinitionBox",
  CellTags->"S5.14.1"],
Cell[22767, 1001, 77, 1, 70, "Caption",
  CellTags->"S5.14.1"],
Cell[22847, 1004, 419, 7, 70, "Text",
  CellTags->{"S5.14.1", "1.11"}],
Cell[23269, 1013, 826, 13, 70, "Text",
  CellTags->{"S5.14.1", "1.12"}],
Cell[24098, 1028, 710, 25, 70, "MathCaption",
  CellTags->{"S5.14.1", "1.13"}],

Cell[CellGroupData[{
Cell[24833, 1057, 138, 6, 70, "Input",
  CellTags->"S5.14.1"],
Cell[24974, 1065, 1197, 42, 70, "Output",
  CellTags->"S5.14.1"]
}, Open  ]],
Cell[26186, 1110, 226, 5, 70, "MathCaption",
  CellTags->{"S5.14.1", "1.14"}],

Cell[CellGroupData[{
Cell[26437, 1119, 94, 2, 70, "Input",
  CellTags->"S5.14.1"],
Cell[26534, 1123, 691, 22, 70, "Output",
  CellTags->"S5.14.1"]
}, Open  ]],
Cell[27240, 1148, 158, 4, 70, "MathCaption",
  CellTags->{"S5.14.1", "1.15"}],

Cell[CellGroupData[{
Cell[27423, 1156, 92, 2, 70, "Input",
  CellTags->"S5.14.1"],
Cell[27518, 1160, 6695, 435, 70, 6624, 432, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.14.1"],
Cell[34216, 1597, 180, 6, 70, "Output",
  CellTags->"S5.14.1"]
}, Open  ]],
Cell[34411, 1606, 378, 12, 70, "MathCaption",
  CellTags->{"S5.14.1", "1.16"}],

Cell[CellGroupData[{
Cell[34814, 1622, 104, 2, 70, "Input",
  CellTags->"S5.14.1"],
Cell[34921, 1626, 91, 2, 70, "Output",
  CellTags->"S5.14.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

