(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    484108,      25534]*)
(*NotebookOutlinePosition[    488581,      25665]*)
(*  CellTagsIndexPosition[    488271,      25650]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "ParametricPlot3D",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.38.1", "1.1"}],

Cell[TextData[{
 StyleBox["ParametricPlot3D", "MR"],
 " is a built\[Hyphen]in function for producing three\[Hyphen]dimensional \
space curves and surfaces, parameterized by one or two coordinates \
respectively. The option ",
 StyleBox["PlotPoints", "MR"],
 " allows you to specify the number of sample points used. This package \
extends ",
 StyleBox["ParametricPlot3D", "MR"],
 " by providing an alternative to the ",
 StyleBox["PlotPoints", "MR"],
 " option where the sampling may be specified by giving a step size in each \
coordinate. The package also introduces ",
 StyleBox["PointParametricPlot3D", "MR"],
 " for plotting either one\[Hyphen] or two\[Hyphen]parameter sets of points \
in space. "
}], "Text",
 CellTags->{"S5.38.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ParametricPlot3D[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["z",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["du", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["v", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dv", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "generate a parametric plot of a surface in three dimensions using \
increments ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["du", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dv", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PointParametricPlot3D[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["z",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["du", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot a one\[Hyphen]parameter set of points in three dimensions",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PointParametricPlot3D[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["z",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["du", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["v", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dv", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot a two\[Hyphen]parameter set of points",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.38.1"],

Cell["Parametric plots in three dimensions. ", "Caption",
 CellTags->"S5.38.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.38.1", "1.3"}],

Cell["<<Graphics`ParametricPlot3D`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.38.1"],

Cell["\<\
This gives the plot of a sphere using a mesh of long, thin rectangles. \
\>", "MathCaption",
 CellTags->{"S5.38.1", "1.4"}],

Cell[CellGroupData[{

Cell["\<\
ParametricPlot3D[
  {Cos[u] Cos[v], Sin[u] Cos[v], Sin[v]},
    {u, 0, 2Pi, Pi/20},
    {v, -Pi/2, Pi/2, Pi/10}]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.38.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 6.45642e-17 1.16608 [
[.09072 .22988 -11.8315 -9 ]
[.09072 .22988 .16848 0 ]
[.21906 .17566 -22.6146 -9 ]
[.21906 .17566 1.38537 0 ]
[.3545 .11847 -5.39155 -9 ]
[.3545 .11847 .60845 0 ]
[.49765 .05807 -15.3884 -9 ]
[.49765 .05807 2.61165 0 ]
[.64919 -0.00583 -4.86734 -9 ]
[.64919 -0.00583 1.13266 0 ]
[.00955 .82643 -6.92724 0 ]
[.00955 .82643 5.07276 9 ]
[.12079 .90442 -13.4221 0 ]
[.12079 .90442 10.5779 9 ]
[.22056 .97437 -3.26269 0 ]
[.22056 .97437 2.73731 9 ]
[.31055 1.03745 -9.54626 0 ]
[.31055 1.03745 8.45374 9 ]
[.39213 1.09464 -3.11145 0 ]
[.39213 1.09464 2.88855 9 ]
[.07325 .26228 -12 -2.6177 ]
[.07325 .26228 0 6.3823 ]
[.05474 .37813 -24 -2.72059 ]
[.05474 .37813 0 6.27941 ]
[.03462 .5041 -6 -2.83339 ]
[.03462 .5041 0 6.16661 ]
[.01266 .64157 -18 -2.95759 ]
[.01266 .64157 0 6.04241 ]
[-0.01139 .79218 -6 -3.09501 ]
[-0.01139 .79218 0 5.90499 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(-1)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(-0.5)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(0)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(0.5)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(1)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.01178 .81203 m
.01289 .80482 L
s
[(-1)] .00955 .82643 .15454 -1 Mshowa
.1225 .88995 m
.12336 .88271 L
s
[(-0.5)] .12079 .90442 .11851 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(0)] .22056 .97437 .08756 -1 Mshowa
.31143 1.0229 m
.31187 1.01563 L
s
[(0.5)] .31055 1.03745 .0607 -1 Mshowa
.39267 1.08007 m
.39294 1.07279 L
s
[(1)] .39213 1.09464 .03715 -1 Mshowa
.125 Mabswid
.03493 .82832 m
.03556 .82399 L
s
.05756 .84424 m
.05816 .83991 L
s
.07969 .85982 m
.08026 .85548 L
s
.10133 .87505 m
.10187 .87071 L
s
.14322 .90453 m
.14371 .90018 L
s
.1635 .9188 m
.16396 .91445 L
s
.18335 .93277 m
.18378 .92842 L
s
.20279 .94645 m
.2032 .9421 L
s
.24048 .97297 m
.24084 .96861 L
s
.25875 .98583 m
.25909 .98147 L
s
.27666 .99844 m
.27697 .99407 L
s
.29422 1.01079 m
.29451 1.00643 L
s
.32831 1.03478 m
.32855 1.03041 L
s
.34486 1.04643 m
.34508 1.04206 L
s
.3611 1.05786 m
.3613 1.05349 L
s
.37703 1.06907 m
.37721 1.0647 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.0867 .25665 m
.09342 .25384 L
s
[(-1)] .07325 .26228 1 -0.41829 Mshowa
.0683 .37277 m
.07507 .37009 L
s
[(-0.5)] .05474 .37813 1 -0.39542 Mshowa
.04829 .49904 m
.05512 .49651 L
s
[(0)] .03462 .5041 1 -0.37036 Mshowa
.02645 .63684 m
.03334 .63448 L
s
[(0.5)] .01266 .64157 1 -0.34276 Mshowa
.00252 .78784 m
.00948 .78567 L
s
[(1)] -0.01139 .79218 1 -0.31222 Mshowa
.125 Mabswid
.08314 .27912 m
.08718 .27745 L
s
.07952 .30196 m
.08356 .30031 L
s
.07584 .32518 m
.07989 .32354 L
s
.0721 .34878 m
.07616 .34715 L
s
.06443 .39717 m
.0685 .39558 L
s
.0605 .42199 m
.06458 .42042 L
s
.0565 .44723 m
.06058 .44568 L
s
.05243 .47291 m
.05652 .47137 L
s
.04407 .52563 m
.04818 .52413 L
s
.03978 .55269 m
.0439 .55121 L
s
.03542 .58024 m
.03954 .57878 L
s
.03097 .60828 m
.0351 .60685 L
s
.02184 .66593 m
.02598 .66453 L
s
.01714 .69556 m
.0213 .69418 L
s
.01236 .72574 m
.01652 .72439 L
s
.00749 .7565 m
.01165 .75517 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.715 .56 .677 r
.49101 .66997 m .53307 .67123 L .53203 .58413 L p F P
0 g
s
.715 .56 .677 r
.53203 .58413 m .49647 .58301 L .49101 .66997 L p F P
0 g
s
.689 .539 .677 r
.56747 .58195 m .53203 .58413 L .53307 .67123 L p F P
0 g
s
.714 .606 .735 r
.49647 .58301 m .53203 .58413 L .53049 .49697 L p F P
0 g
s
.693 .589 .735 r
.53203 .58413 m .56747 .58195 L .55638 .4953 L p F P
0 g
s
.693 .589 .735 r
.55638 .4953 m .53049 .49697 L .53203 .58413 L p F P
0 g
s
.741 .582 .677 r
.44958 .66502 m .49101 .66997 L .49647 .58301 L p F P
0 g
s
.741 .582 .677 r
.49647 .58301 m .46148 .5786 L .44958 .66502 L p F P
0 g
s
.734 .623 .736 r
.46148 .5786 m .49647 .58301 L .50451 .49611 L p F P
0 g
s
.714 .606 .735 r
.53049 .49697 m .50451 .49611 L .49647 .58301 L p F P
0 g
s
.689 .539 .677 r
.53307 .67123 m .57501 .66878 L .56747 .58195 L p F P
0 g
s
.662 .518 .678 r
.60214 .5765 m .56747 .58195 L .57501 .66878 L p F P
0 g
s
.671 .573 .737 r
.56747 .58195 m .60214 .5765 L .58166 .49111 L p F P
0 g
s
.671 .573 .737 r
.58166 .49111 m .55638 .4953 L .56747 .58195 L p F P
0 g
s
.766 .605 .68 r
.40952 .65645 m .44958 .66502 L .46148 .5786 L p F P
0 g
s
.766 .605 .68 r
.46148 .5786 m .42772 .57097 L .40952 .65645 L p F P
0 g
s
.753 .643 .739 r
.42772 .57097 m .46148 .5786 L .47898 .49272 L p F P
0 g
s
.734 .623 .736 r
.50451 .49611 m .47898 .49272 L .46148 .5786 L p F P
0 g
s
.662 .518 .678 r
.57501 .66878 m .61608 .66266 L .60214 .5765 L p F P
0 g
s
.633 .498 .68 r
.63537 .56785 m .60214 .5765 L .61608 .66266 L p F P
0 g
s
.649 .559 .74 r
.60214 .5765 m .63537 .56785 L .60581 .48448 L p F P
0 g
s
.649 .559 .74 r
.60581 .48448 m .58166 .49111 L .60214 .5765 L p F P
0 g
s
.706 .65 .792 r
.50451 .49611 m .53049 .49697 L .52855 .4153 L p F P
0 g
s
.692 .639 .792 r
.53049 .49697 m .55638 .4953 L .5424 .41436 L p F P
0 g
s
.692 .639 .792 r
.5424 .41436 m .52855 .4153 L .53049 .49697 L p F P
0 g
s
.712 .506 .609 r
.48852 .75142 m .53355 .7527 L .53307 .67123 L p F P
0 g
s
.712 .506 .609 r
.53307 .67123 m .49101 .66997 L .48852 .75142 L p F P
0 g
s
.68 .48 .609 r
.57501 .66878 m .53307 .67123 L .53355 .7527 L p F P
0 g
s
.72 .663 .793 r
.47898 .49272 m .50451 .49611 L .51465 .41481 L p F P
0 g
s
.706 .65 .792 r
.52855 .4153 m .51465 .41481 L .50451 .49611 L p F P
0 g
s
.677 .629 .794 r
.55638 .4953 m .58166 .49111 L .55589 .41202 L p F P
0 g
s
.677 .629 .794 r
.55589 .41202 m .5424 .41436 L .55638 .4953 L p F P
0 g
s
.742 .532 .609 r
.44415 .7464 m .48852 .75142 L .49101 .66997 L p F P
0 g
s
.742 .532 .609 r
.49101 .66997 m .44958 .66502 L .44415 .7464 L p F P
0 g
s
.68 .48 .609 r
.53355 .7527 m .57845 .75022 L .57501 .66878 L p F P
0 g
s
.647 .454 .609 r
.61608 .66266 m .57501 .66878 L .57845 .75022 L p F P
0 g
s
.791 .631 .683 r
.37158 .64433 m .40952 .65645 L .42772 .57097 L p F P
0 g
s
.791 .631 .683 r
.42772 .57097 m .39585 .5602 L .37158 .64433 L p F P
0 g
s
.773 .664 .743 r
.39585 .5602 m .42772 .57097 L .45441 .48687 L p F P
0 g
s
.753 .643 .739 r
.47898 .49272 m .45441 .48687 L .42772 .57097 L p F P
0 g
s
.733 .677 .796 r
.45441 .48687 m .47898 .49272 L .50101 .41292 L p F P
0 g
s
.72 .663 .793 r
.51465 .41481 m .50101 .41292 L .47898 .49272 L p F P
0 g
s
.661 .619 .797 r
.58166 .49111 m .60581 .48448 L .56871 .40832 L p F P
0 g
s
.661 .619 .797 r
.56871 .40832 m .55589 .41202 L .58166 .49111 L p F P
0 g
s
.633 .498 .68 r
.61608 .66266 m .65555 .65294 L .63537 .56785 L p F P
0 g
s
.601 .478 .684 r
.6665 .55611 m .63537 .56785 L .65555 .65294 L p F P
0 g
s
.624 .546 .745 r
.63537 .56785 m .6665 .55611 L .6283 .47552 L p F P
0 g
s
.624 .546 .745 r
.6283 .47552 m .60581 .48448 L .63537 .56785 L p F P
0 g
s
.773 .558 .609 r
.4012 .73768 m .44415 .7464 L .44958 .66502 L p F P
0 g
s
.773 .558 .609 r
.44958 .66502 m .40952 .65645 L .4012 .73768 L p F P
0 g
s
.647 .454 .609 r
.57845 .75022 m .62245 .744 L .61608 .66266 L p F P
0 g
s
.61 .427 .609 r
.65555 .65294 m .61608 .66266 L .62245 .744 L p F P
0 g
s
.773 .664 .743 r
.45441 .48687 m .43133 .47864 L .39585 .5602 L p F P
0 g
s
.746 .692 .8 r
.43133 .47864 m .45441 .48687 L .48794 .40965 L p F P
0 g
s
.733 .677 .796 r
.50101 .41292 m .48794 .40965 L .45441 .48687 L p F P
0 g
s
.645 .612 .802 r
.60581 .48448 m .6283 .47552 L .58058 .40335 L p F P
0 g
s
.645 .612 .802 r
.58058 .40335 m .56871 .40832 L .60581 .48448 L p F P
0 g
s
.817 .659 .687 r
.33652 .62883 m .37158 .64433 L .39585 .5602 L p F P
0 g
s
.817 .659 .687 r
.39585 .5602 m .36653 .54647 L .33652 .62883 L p F P
0 g
s
.791 .688 .75 r
.36653 .54647 m .39585 .5602 L .43133 .47864 L p F P
0 g
s
.803 .587 .609 r
.36047 .72536 m .4012 .73768 L .40952 .65645 L p F P
0 g
s
.803 .587 .609 r
.40952 .65645 m .37158 .64433 L .36047 .72536 L p F P
0 g
s
.791 .688 .75 r
.43133 .47864 m .41024 .46818 L .36653 .54647 L p F P
0 g
s
.758 .709 .806 r
.41024 .46818 m .43133 .47864 L .47574 .40508 L p F P
0 g
s
.746 .692 .8 r
.48794 .40965 m .47574 .40508 L .43133 .47864 L p F P
0 g
s
.601 .478 .684 r
.65555 .65294 m .69265 .63972 L .6665 .55611 L p F P
0 g
s
.565 .457 .689 r
.69485 .54146 m .6665 .55611 L .69265 .63972 L p F P
0 g
s
.598 .533 .752 r
.6665 .55611 m .69485 .54146 L .64865 .46438 L p F P
0 g
s
.598 .533 .752 r
.64865 .46438 m .6283 .47552 L .6665 .55611 L p F P
0 g
s
.61 .427 .609 r
.62245 .744 m .66477 .73412 L .65555 .65294 L p F P
0 g
s
.57 .397 .609 r
.69265 .63972 m .65555 .65294 L .66477 .73412 L p F P
0 g
s
.628 .606 .808 r
.6283 .47552 m .64865 .46438 L .59121 .3972 L p F P
0 g
s
.628 .606 .808 r
.59121 .3972 m .58058 .40335 L .6283 .47552 L p F P
0 g
s
.81 .713 .758 r
.34042 .52996 m .36653 .54647 L .41024 .46818 L p F P
0 g
s
.81 .713 .758 r
.41024 .46818 m .39164 .45567 L .34042 .52996 L p F P
0 g
s
.769 .726 .814 r
.39164 .45567 m .41024 .46818 L .46468 .39929 L p F P
0 g
s
.758 .709 .806 r
.47574 .40508 m .46468 .39929 L .41024 .46818 L p F P
0 g
s
.843 .691 .693 r
.3051 .61014 m .33652 .62883 L .36653 .54647 L p F P
0 g
s
.843 .691 .693 r
.36653 .54647 m .34042 .52996 L .3051 .61014 L p F P
0 g
s
.836 .618 .609 r
.32275 .70957 m .36047 .72536 L .37158 .64433 L p F P
0 g
s
.836 .618 .609 r
.37158 .64433 m .33652 .62883 L .32275 .70957 L p F P
0 g
s
.689 .7 .855 r
.52632 .34495 m .51465 .41481 L .52855 .4153 L closepath p F P
0 g
s
.683 .695 .855 r
.52632 .34495 m .52855 .4153 L .5424 .41436 L closepath p F P
0 g
s
.694 .705 .856 r
.52632 .34495 m .50101 .41292 L .51465 .41481 L closepath p F P
0 g
s
.677 .691 .856 r
.52632 .34495 m .5424 .41436 L .55589 .41202 L closepath p F P
0 g
s
.699 .431 .515 r
.48933 .8215 m .53339 .82269 L .53355 .7527 L p F P
0 g
s
.699 .431 .515 r
.53355 .7527 m .48852 .75142 L .48933 .8215 L p F P
0 g
s
.661 .4 .515 r
.57845 .75022 m .53355 .7527 L .53339 .82269 L p F P
0 g
s
.57 .521 .761 r
.66636 .45126 m .64865 .46438 L .69485 .54146 L p F P
0 g
s
.611 .601 .816 r
.64865 .46438 m .66636 .45126 L .60035 .39 L p F P
0 g
s
.611 .601 .816 r
.60035 .39 m .59121 .3972 L .64865 .46438 L p F P
0 g
s
.7 .711 .857 r
.52632 .34495 m .48794 .40965 L .50101 .41292 L closepath p F P
0 g
s
.735 .461 .514 r
.44592 .81682 m .48933 .8215 L .48852 .75142 L p F P
0 g
s
.735 .461 .514 r
.48852 .75142 m .44415 .7464 L .44592 .81682 L p F P
0 g
s
.67 .688 .858 r
.52632 .34495 m .55589 .41202 L .56871 .40832 L closepath p F P
0 g
s
.565 .457 .689 r
.69265 .63972 m .72662 .62317 L .69485 .54146 L p F P
0 g
s
.524 .434 .696 r
.7198 .52412 m .69485 .54146 L .72662 .62317 L p F P
0 g
s
.57 .521 .761 r
.69485 .54146 m .7198 .52412 L .66636 .45126 L p F P
0 g
s
.661 .4 .515 r
.53339 .82269 m .57733 .82038 L .57845 .75022 L p F P
0 g
s
.62 .367 .513 r
.62245 .744 m .57845 .75022 L .57733 .82038 L p F P
0 g
s
.57 .397 .609 r
.66477 .73412 m .70462 .72067 L .69265 .63972 L p F P
0 g
s
.522 .364 .608 r
.72662 .62317 m .69265 .63972 L .70462 .72067 L p F P
0 g
s
.704 .717 .859 r
.52632 .34495 m .47574 .40508 L .48794 .40965 L closepath p F P
0 g
s
.664 .685 .86 r
.52632 .34495 m .56871 .40832 L .58058 .40335 L closepath p F P
0 g
s
.771 .49 .51 r
.40391 .80869 m .44592 .81682 L .44415 .7464 L p F P
0 g
s
.771 .49 .51 r
.44415 .7464 m .4012 .73768 L .40391 .80869 L p F P
0 g
s
.708 .724 .862 r
.52632 .34495 m .46468 .39929 L .47574 .40508 L closepath p F P
0 g
s
.828 .742 .769 r
.31816 .51095 m .34042 .52996 L .39164 .45567 L p F P
0 g
s
.828 .742 .769 r
.39164 .45567 m .37597 .44134 L .31816 .51095 L p F P
0 g
s
.778 .745 .823 r
.37597 .44134 m .39164 .45567 L .45503 .39242 L p F P
0 g
s
.769 .726 .814 r
.46468 .39929 m .45503 .39242 L .39164 .45567 L p F P
0 g
s
.62 .367 .513 r
.57733 .82038 m .62037 .81458 L .62245 .744 L p F P
0 g
s
.575 .33 .508 r
.66477 .73412 m .62245 .744 L .62037 .81458 L p F P
0 g
s
.657 .684 .863 r
.52632 .34495 m .58058 .40335 L .59121 .3972 L closepath p F P
0 g
s
.539 .51 .773 r
.68099 .43641 m .66636 .45126 L .7198 .52412 L p F P
0 g
s
.593 .598 .826 r
.66636 .45126 m .68099 .43641 L .60777 .38191 L p F P
0 g
s
.593 .598 .826 r
.60777 .38191 m .60035 .39 L .66636 .45126 L p F P
0 g
s
.87 .727 .701 r
.2781 .58852 m .3051 .61014 L .34042 .52996 L p F P
0 g
s
.87 .727 .701 r
.34042 .52996 m .31816 .51095 L .2781 .58852 L p F P
0 g
s
.711 .731 .866 r
.52632 .34495 m .45503 .39242 L .46468 .39929 L closepath p F P
0 g
s
.869 .653 .608 r
.28886 .69051 m .32275 .70957 L .33652 .62883 L p F P
0 g
s
.869 .653 .608 r
.33652 .62883 m .3051 .61014 L .28886 .69051 L p F P
0 g
s
.651 .683 .867 r
.52632 .34495 m .59121 .3972 L .60035 .39 L closepath p F P
0 g
s
.807 .519 .503 r
.36409 .79721 m .40391 .80869 L .4012 .73768 L p F P
0 g
s
.807 .519 .503 r
.4012 .73768 m .36047 .72536 L .36409 .79721 L p F P
0 g
s
.524 .434 .696 r
.72662 .62317 m .7567 .60351 L .7198 .52412 L p F P
0 g
s
.476 .41 .704 r
.74069 .50437 m .7198 .52412 L .7567 .60351 L p F P
0 g
s
.539 .51 .773 r
.7198 .52412 m .74069 .50437 L .68099 .43641 L p F P
0 g
s
.778 .745 .823 r
.45503 .39242 m .44704 .38459 L .37597 .44134 L p F P
0 g
s
.714 .738 .87 r
.52632 .34495 m .44704 .38459 L .45503 .39242 L closepath p F P
0 g
s
.522 .364 .608 r
.70462 .72067 m .7412 .70381 L .72662 .62317 L p F P
0 g
s
.465 .326 .607 r
.7567 .60351 m .72662 .62317 L .7412 .70381 L p F P
0 g
s
.575 .33 .508 r
.62037 .81458 m .66176 .80537 L .66477 .73412 L p F P
0 g
s
.521 .286 .499 r
.70462 .72067 m .66477 .73412 L .66176 .80537 L p F P
0 g
s
.845 .773 .782 r
.30036 .48975 m .31816 .51095 L .37597 .44134 L p F P
0 g
s
.845 .773 .782 r
.37597 .44134 m .36367 .42547 L .30036 .48975 L p F P
0 g
s
.786 .765 .834 r
.36367 .42547 m .37597 .44134 L .44704 .38459 L p F P
0 g
s
.645 .683 .871 r
.52632 .34495 m .60035 .39 L .60777 .38191 L closepath p F P
0 g
s
.503 .501 .787 r
.69214 .42011 m .68099 .43641 L .74069 .50437 L p F P
0 g
s
.574 .597 .838 r
.68099 .43641 m .69214 .42011 L .61327 .37311 L p F P
0 g
s
.574 .597 .838 r
.61327 .37311 m .60777 .38191 L .68099 .43641 L p F P
0 g
s
.786 .765 .834 r
.44704 .38459 m .44091 .376 L .36367 .42547 L p F P
0 g
s
.715 .745 .875 r
.52632 .34495 m .44091 .376 L .44704 .38459 L closepath p F P
0 g
s
.639 .684 .876 r
.52632 .34495 m .60777 .38191 L .61327 .37311 L closepath p F P
0 g
s
.844 .55 .491 r
.32725 .7825 m .36409 .79721 L .36047 .72536 L p F P
0 g
s
.844 .55 .491 r
.36047 .72536 m .32275 .70957 L .32725 .7825 L p F P
0 g
s
.897 .768 .71 r
.25624 .56432 m .2781 .58852 L .31816 .51095 L p F P
0 g
s
.897 .768 .71 r
.31816 .51095 m .30036 .48975 L .25624 .56432 L p F P
0 g
s
.905 .693 .605 r
.25961 .66843 m .28886 .69051 L .3051 .61014 L p F P
0 g
s
.905 .693 .605 r
.3051 .61014 m .2781 .58852 L .25961 .66843 L p F P
0 g
s
.792 .786 .847 r
.3551 .4084 m .36367 .42547 L .44091 .376 L p F P
0 g
s
.792 .786 .847 r
.44091 .376 m .4368 .36683 L .3551 .4084 L p F P
0 g
s
.716 .751 .88 r
.52632 .34495 m .4368 .36683 L .44091 .376 L closepath p F P
0 g
s
.521 .286 .499 r
.66176 .80537 m .70071 .79283 L .70462 .72067 L p F P
0 g
s
.456 .234 .486 r
.7412 .70381 m .70462 .72067 L .70071 .79283 L p F P
0 g
s
.86 .808 .798 r
.28759 .46678 m .30036 .48975 L .36367 .42547 L p F P
0 g
s
.86 .808 .798 r
.36367 .42547 m .3551 .4084 L .28759 .46678 L p F P
0 g
s
.554 .598 .852 r
.61669 .3638 m .61327 .37311 L .69214 .42011 L p F P
0 g
s
.634 .687 .882 r
.52632 .34495 m .61327 .37311 L .61669 .3638 L closepath p F P
0 g
s
.476 .41 .704 r
.7567 .60351 m .78214 .58102 L .74069 .50437 L p F P
0 g
s
.417 .383 .713 r
.75694 .48256 m .74069 .50437 L .78214 .58102 L p F P
0 g
s
.503 .501 .787 r
.74069 .50437 m .75694 .48256 L .69214 .42011 L p F P
0 g
s
.465 .326 .607 r
.7412 .70381 m .77369 .68374 L .7567 .60351 L p F P
0 g
s
.392 .278 .603 r
.78214 .58102 m .7567 .60351 L .77369 .68374 L p F P
0 g
s
.462 .492 .803 r
.69944 .40272 m .69214 .42011 L .75694 .48256 L p F P
0 g
s
.554 .598 .852 r
.69214 .42011 m .69944 .40272 L .61669 .3638 L p F P
0 g
s
.795 .807 .862 r
.35057 .39048 m .3551 .4084 L .4368 .36683 L p F P
0 g
s
.795 .807 .862 r
.4368 .36683 m .43486 .3573 L .35057 .39048 L p F P
0 g
s
.715 .758 .886 r
.52632 .34495 m .43486 .3573 L .4368 .36683 L closepath p F P
0 g
s
.535 .601 .867 r
.61792 .3542 m .61669 .3638 L .69944 .40272 L p F P
0 g
s
.629 .69 .888 r
.52632 .34495 m .61669 .3638 L .61792 .3542 L closepath p F P
0 g
s
.62 .712 .912 r
.52632 .34495 m .60809 .326 L .60047 .3176 L closepath p F P
0 g
s
.621 .72 .917 r
.52632 .34495 m .60047 .3176 L .59093 .3101 L closepath p F P
0 g
s
.623 .728 .922 r
.52632 .34495 m .59093 .3101 L .57968 .3037 L closepath p F P
0 g
s
.626 .736 .926 r
.52632 .34495 m .57968 .3037 L .56701 .29859 L closepath p F P
0 g
s
.631 .744 .929 r
.52632 .34495 m .56701 .29859 L .55325 .2949 L closepath p F P
0 g
s
.637 .752 .931 r
.52632 .34495 m .55325 .2949 L .53876 .29275 L closepath p F P
0 g
s
.644 .759 .932 r
.52632 .34495 m .53876 .29275 L .52393 .2922 L closepath p F P
0 g
s
.652 .765 .932 r
.52632 .34495 m .52393 .2922 L .50917 .29327 L closepath p F P
0 g
s
.661 .77 .931 r
.52632 .34495 m .50917 .29327 L .49488 .29592 L closepath p F P
0 g
s
.67 .774 .928 r
.52632 .34495 m .49488 .29592 L .48143 .30008 L closepath p F P
0 g
s
.678 .777 .925 r
.52632 .34495 m .48143 .30008 L .46918 .30562 L closepath p F P
0 g
s
.687 .778 .921 r
.52632 .34495 m .46918 .30562 L .45845 .3124 L closepath p F P
0 g
s
.694 .778 .916 r
.52632 .34495 m .45845 .3124 L .4495 .32021 L closepath p F P
0 g
s
.701 .776 .91 r
.52632 .34495 m .4495 .32021 L .44254 .32884 L closepath p F P
0 g
s
.706 .773 .904 r
.52632 .34495 m .44254 .32884 L .43774 .33806 L closepath p F P
0 g
s
.71 .769 .898 r
.52632 .34495 m .43774 .33806 L .43517 .34763 L closepath p F P
0 g
s
.713 .763 .892 r
.52632 .34495 m .43517 .34763 L .43486 .3573 L closepath p F P
0 g
s
.626 .694 .894 r
.52632 .34495 m .61792 .3542 L .61689 .34454 L closepath p F P
0 g
s
.623 .699 .9 r
.52632 .34495 m .61689 .34454 L .61359 .33505 L closepath p F P
0 g
s
.621 .706 .906 r
.52632 .34495 m .61359 .33505 L .60809 .326 L closepath p F P
0 g
s
.884 .583 .473 r
.29417 .76474 m .32725 .7825 L .32275 .70957 L p F P
0 g
s
.884 .583 .473 r
.32275 .70957 m .28886 .69051 L .29417 .76474 L p F P
0 g
s
.661 .304 .357 r
.49367 .87392 m .53256 .87493 L .53339 .82269 L p F P
0 g
s
.661 .304 .357 r
.53339 .82269 m .48933 .8215 L .49367 .87392 L p F P
0 g
s
.615 .266 .356 r
.57733 .82038 m .53339 .82269 L .53256 .87493 L p F P
0 g
s
.703 .337 .351 r
.45538 .86994 m .49367 .87392 L .48933 .8215 L p F P
0 g
s
.703 .337 .351 r
.48933 .8215 m .44592 .81682 L .45538 .86994 L p F P
0 g
s
.615 .266 .356 r
.53256 .87493 m .57133 .87296 L .57733 .82038 L p F P
0 g
s
.563 .221 .347 r
.62037 .81458 m .57733 .82038 L .57133 .87296 L p F P
0 g
s
.795 .829 .878 r
.35032 .37213 m .35057 .39048 L .43486 .3573 L p F P
0 g
s
.795 .829 .878 r
.43486 .3573 m .43517 .34763 L .35032 .37213 L p F P
0 g
s
.924 .815 .72 r
.24024 .53796 m .25624 .56432 L .30036 .48975 L p F P
0 g
s
.924 .815 .72 r
.30036 .48975 m .28759 .46678 L .24024 .53796 L p F P
0 g
s
.872 .846 .816 r
.28034 .4425 m .28759 .46678 L .3551 .4084 L p F P
0 g
s
.872 .846 .816 r
.3551 .4084 m .35057 .39048 L .28034 .4425 L p F P
0 g
s
.535 .601 .867 r
.69944 .40272 m .70261 .38462 L .61792 .3542 L p F P
0 g
s
.514 .608 .884 r
.61689 .34454 m .61792 .3542 L .70261 .38462 L p F P
0 g
s
.456 .234 .486 r
.70071 .79283 m .73644 .77712 L .7412 .70381 L p F P
0 g
s
.372 .166 .466 r
.77369 .68374 m .7412 .70381 L .73644 .77712 L p F P
0 g
s
.743 .365 .337 r
.41839 .86304 m .45538 .86994 L .44592 .81682 L p F P
0 g
s
.743 .365 .337 r
.44592 .81682 m .40391 .80869 L .41839 .86304 L p F P
0 g
s
.943 .739 .598 r
.23581 .64365 m .25961 .66843 L .2781 .58852 L p F P
0 g
s
.943 .739 .598 r
.2781 .58852 m .25624 .56432 L .23581 .64365 L p F P
0 g
s
.563 .221 .347 r
.57133 .87296 m .60929 .86804 L .62037 .81458 L p F P
0 g
s
.501 .166 .331 r
.66176 .80537 m .62037 .81458 L .60929 .86804 L p F P
0 g
s
.462 .492 .803 r
.75694 .48256 m .76799 .45911 L .69944 .40272 L p F P
0 g
s
.415 .484 .822 r
.70261 .38462 m .69944 .40272 L .76799 .45911 L p F P
0 g
s
.417 .383 .713 r
.78214 .58102 m .8022 .55608 L .75694 .48256 L p F P
0 g
s
.342 .35 .723 r
.76799 .45911 m .75694 .48256 L .8022 .55608 L p F P
0 g
s
.789 .849 .896 r
.35448 .35381 m .35032 .37213 L .43517 .34763 L p F P
0 g
s
.789 .849 .896 r
.43517 .34763 m .43774 .33806 L .35448 .35381 L p F P
0 g
s
.514 .608 .884 r
.70261 .38462 m .70146 .36623 L .61689 .34454 L p F P
0 g
s
.495 .617 .902 r
.61359 .33505 m .61689 .34454 L .70146 .36623 L p F P
0 g
s
.392 .278 .603 r
.77369 .68374 m .80128 .66076 L .78214 .58102 L p F P
0 g
s
.296 .217 .595 r
.8022 .55608 m .78214 .58102 L .80128 .66076 L p F P
0 g
s
.782 .391 .313 r
.38342 .8533 m .41839 .86304 L .40391 .80869 L p F P
0 g
s
.782 .391 .313 r
.40391 .80869 m .36409 .79721 L .38342 .8533 L p F P
0 g
s
.501 .166 .331 r
.60929 .86804 m .64571 .86022 L .66176 .80537 L p F P
0 g
s
.426 .097 .303 r
.70071 .79283 m .66176 .80537 L .64571 .86022 L p F P
0 g
s
.778 .868 .915 r
.36307 .33599 m .35448 .35381 L .43774 .33806 L p F P
0 g
s
.778 .868 .915 r
.43774 .33806 m .44254 .32884 L .36307 .33599 L p F P
0 g
s
.924 .618 .445 r
.26566 .74419 m .29417 .76474 L .28886 .69051 L p F P
0 g
s
.924 .618 .445 r
.28886 .69051 m .25961 .66843 L .26566 .74419 L p F P
0 g
s
.877 .887 .837 r
.27901 .41744 m .28034 .4425 L .35057 .39048 L p F P
0 g
s
.877 .887 .837 r
.35057 .39048 m .35032 .37213 L .27901 .41744 L p F P
0 g
s
.495 .617 .902 r
.70146 .36623 m .69588 .34802 L .61359 .33505 L p F P
0 g
s
.476 .63 .921 r
.60809 .326 m .61359 .33505 L .69588 .34802 L p F P
0 g
s
.415 .484 .822 r
.76799 .45911 m .77338 .43452 L .70261 .38462 L p F P
0 g
s
.359 .477 .844 r
.70146 .36623 m .70261 .38462 L .77338 .43452 L p F P
0 g
s
.946 .868 .729 r
.23075 .50995 m .24024 .53796 L .28759 .46678 L p F P
0 g
s
.946 .868 .729 r
.28759 .46678 m .28034 .4425 L .23075 .50995 L p F P
0 g
s
.372 .166 .466 r
.73644 .77712 m .76814 .75844 L .77369 .68374 L p F P
0 g
s
.259 .076 .432 r
.80128 .66076 m .77369 .68374 L .76814 .75844 L p F P
0 g
s
.761 .883 .933 r
.37598 .31917 m .36307 .33599 L .44254 .32884 L p F P
0 g
s
.761 .883 .933 r
.44254 .32884 m .4495 .32021 L .37598 .31917 L p F P
0 g
s
.819 .412 .276 r
.35118 .84086 m .38342 .8533 L .36409 .79721 L p F P
0 g
s
.819 .412 .276 r
.36409 .79721 m .32725 .7825 L .35118 .84086 L p F P
0 g
s
.459 .647 .939 r
.60047 .3176 m .60809 .326 L .68589 .33047 L p F P
0 g
s
.476 .63 .921 r
.69588 .34802 m .68589 .33047 L .60809 .326 L p F P
0 g
s
.978 .79 .584 r
.21824 .6166 m .23581 .64365 L .25624 .56432 L p F P
0 g
s
.978 .79 .584 r
.25624 .56432 m .24024 .53796 L .21824 .6166 L p F P
0 g
s
.342 .35 .723 r
.8022 .55608 m .81618 .52913 L .76799 .45911 L p F P
0 g
s
.244 .309 .731 r
.77338 .43452 m .76799 .45911 L .81618 .52913 L p F P
0 g
s
.426 .097 .303 r
.64571 .86022 m .67988 .8496 L .70071 .79283 L p F P
0 g
s
.328 .007 .26 r
.73644 .77712 m .70071 .79283 L .67988 .8496 L p F P
0 g
s
.735 .893 .951 r
.39297 .30381 m .37598 .31917 L .4495 .32021 L p F P
0 g
s
.735 .893 .951 r
.4495 .32021 m .45845 .3124 L .39297 .30381 L p F P
0 g
s
.872 .928 .858 r
.28389 .39222 m .27901 .41744 L .35032 .37213 L p F P
0 g
s
.872 .928 .858 r
.35032 .37213 m .35448 .35381 L .28389 .39222 L p F P
0 g
s
.459 .647 .939 r
.68589 .33047 m .67164 .31406 L .60047 .3176 L p F P
0 g
s
.446 .667 .956 r
.59093 .3101 m .60047 .3176 L .67164 .31406 L p F P
0 g
s
.296 .217 .595 r
.80128 .66076 m .82317 .6352 L .8022 .55608 L p F P
0 g
s
.162 .133 .576 r
.81618 .52913 m .8022 .55608 L .82317 .6352 L p F P
0 g
s
.359 .477 .844 r
.77338 .43452 m .77274 .40934 L .70146 .36623 L p F P
0 g
s
.293 .472 .865 r
.69588 .34802 m .70146 .36623 L .77274 .40934 L p F P
0 g
s
.702 .896 .967 r
.41368 .2904 m .39297 .30381 L .45845 .3124 L p F P
0 g
s
.702 .896 .967 r
.45845 .3124 m .46918 .30562 L .41368 .2904 L p F P
0 g
s
.961 .652 .396 r
.24249 .72114 m .26566 .74419 L .25961 .66843 L p F P
0 g
s
.961 .652 .396 r
.25961 .66843 m .23581 .64365 L .24249 .72114 L p F P
0 g
s
.446 .667 .956 r
.67164 .31406 m .6534 .29928 L .59093 .3101 L p F P
0 g
s
.439 .69 .971 r
.57968 .3037 m .59093 .3101 L .6534 .29928 L p F P
0 g
s
.851 .426 .217 r
.32237 .82588 m .35118 .84086 L .32725 .7825 L p F P
0 g
s
.851 .426 .217 r
.32725 .7825 m .29417 .76474 L .32237 .82588 L p F P
0 g
s
.663 .892 .98 r
.43758 .27935 m .41368 .2904 L .46918 .30562 L p F P
0 g
s
.663 .892 .98 r
.46918 .30562 m .48143 .30008 L .43758 .27935 L p F P
0 g
s
.955 .924 .733 r
.22832 .48089 m .23075 .50995 L .28034 .4425 L p F P
0 g
s
.955 .924 .733 r
.28034 .4425 m .27901 .41744 L .22832 .48089 L p F P
0 g
s
.439 .69 .971 r
.6534 .29928 m .63161 .28658 L .57968 .3037 L p F P
0 g
s
.438 .717 .983 r
.56701 .29859 m .57968 .3037 L .63161 .28658 L p F P
0 g
s
.259 .076 .432 r
.76814 .75844 m .79502 .73705 L .80128 .66076 L p F P
0 g
s
.097 0 .374 r
.82317 .6352 m .80128 .66076 L .79502 .73705 L p F P
0 g
s
.328 .007 .26 r
.67988 .8496 m .7111 .83632 L .73644 .77712 L p F P
0 g
s
.194 0 .192 r
.76814 .75844 m .73644 .77712 L .7111 .83632 L p F P
0 g
s
.85 .964 .877 r
.29511 .3675 m .28389 .39222 L .35448 .35381 L p F P
0 g
s
.85 .964 .877 r
.35448 .35381 m .36307 .33599 L .29511 .3675 L p F P
0 g
s
.619 .88 .99 r
.46403 .27103 m .43758 .27935 L .48143 .30008 L p F P
0 g
s
.619 .88 .99 r
.48143 .30008 m .49488 .29592 L .46403 .27103 L p F P
0 g
s
.438 .717 .983 r
.63161 .28658 m .60682 .27637 L .56701 .29859 L p F P
0 g
s
.447 .746 .992 r
.55325 .2949 m .56701 .29859 L .60682 .27637 L p F P
0 g
s
.244 .309 .731 r
.81618 .52913 m .82346 .50071 L .77338 .43452 L p F P
0 g
s
.112 .254 .732 r
.77274 .40934 m .77338 .43452 L .82346 .50071 L p F P
0 g
s
.573 .86 .996 r
.49231 .2657 m .46403 .27103 L .49488 .29592 L p F P
0 g
s
.573 .86 .996 r
.49488 .29592 m .50917 .29327 L .49231 .2657 L p F P
0 g
s
.447 .746 .992 r
.60682 .27637 m .57969 .26898 L .55325 .2949 L p F P
0 g
s
.465 .776 .997 r
.53876 .29275 m .55325 .2949 L .57969 .26898 L p F P
0 g
s
.998 .841 .55 r
.20761 .58778 m .21824 .6166 L .24024 .53796 L p F P
0 g
s
.998 .841 .55 r
.24024 .53796 m .23075 .50995 L .20761 .58778 L p F P
0 g
s
.293 .472 .865 r
.77274 .40934 m .76583 .38421 L .69588 .34802 L p F P
0 g
s
.216 .466 .882 r
.68589 .33047 m .69588 .34802 L .76583 .38421 L p F P
0 g
s
.531 .835 .999 r
.52159 .26355 m .49231 .2657 L .50917 .29327 L p F P
0 g
s
.531 .835 .999 r
.50917 .29327 m .52393 .2922 L .52159 .26355 L p F P
0 g
s
.465 .776 .997 r
.57969 .26898 m .551 .26466 L .53876 .29275 L p F P
0 g
s
.494 .806 1 r
.52393 .2922 m .53876 .29275 L .551 .26466 L p F P
0 g
s
.494 .806 1 r
.551 .26466 m .52159 .26355 L .52393 .2922 L p F P
0 g
s
.519 .016 0 r
.50157 .90215 m .53105 .90291 L .53256 .87493 L p F P
0 g
s
.519 .016 0 r
.53256 .87493 m .49367 .87392 L .50157 .90215 L p F P
0 g
s
.461 0 0 r
.57133 .87296 m .53256 .87493 L .53105 .90291 L p F P
0 g
s
.565 .049 0 r
.47258 .8992 m .50157 .90215 L .49367 .87392 L p F P
0 g
s
.565 .049 0 r
.49367 .87392 m .45538 .86994 L .47258 .8992 L p F P
0 g
s
.461 0 0 r
.53105 .90291 m .56044 .90145 L .57133 .87296 L p F P
0 g
s
.387 0 0 r
.60929 .86804 m .57133 .87296 L .56044 .90145 L p F P
0 g
s
.869 .427 .125 r
.29771 .8086 m .32237 .82588 L .29417 .76474 L p F P
0 g
s
.869 .427 .125 r
.29417 .76474 m .26566 .74419 L .29771 .8086 L p F P
0 g
s
.162 .133 .576 r
.82317 .6352 m .83859 .60753 L .81618 .52913 L p F P
0 g
s
0 .014 .532 r
.82346 .50071 m .81618 .52913 L .83859 .60753 L p F P
0 g
s
.6 .068 0 r
.44466 .89409 m .47258 .8992 L .45538 .86994 L p F P
0 g
s
.6 .068 0 r
.45538 .86994 m .41839 .86304 L .44466 .89409 L p F P
0 g
s
.801 .987 .888 r
.31261 .34397 m .29511 .3675 L .36307 .33599 L p F P
0 g
s
.801 .987 .888 r
.36307 .33599 m .37598 .31917 L .31261 .34397 L p F P
0 g
s
.976 .675 .311 r
.22544 .696 m .24249 .72114 L .23581 .64365 L p F P
0 g
s
.976 .675 .311 r
.23581 .64365 m .21824 .6166 L .22544 .696 L p F P
0 g
s
.387 0 0 r
.56044 .90145 m .58914 .89779 L .60929 .86804 L p F P
0 g
s
.294 0 0 r
.64571 .86022 m .60929 .86804 L .58914 .89779 L p F P
0 g
s
.933 .97 .72 r
.23337 .45147 m .22832 .48089 L .27901 .41744 L p F P
0 g
s
.933 .97 .72 r
.27901 .41744 m .28389 .39222 L .23337 .45147 L p F P
0 g
s
.194 0 .192 r
.7111 .83632 m .73865 .82058 L .76814 .75844 L p F P
0 g
s
.006 0 .085 r
.79502 .73705 m .76814 .75844 L .73865 .82058 L p F P
0 g
s
.216 .466 .882 r
.76583 .38421 m .75258 .35979 L .68589 .33047 L p F P
0 g
s
.129 .46 .888 r
.67164 .31406 m .68589 .33047 L .75258 .35979 L p F P
0 g
s
.621 .072 0 r
.41839 .8869 m .44466 .89409 L .41839 .86304 L p F P
0 g
s
.621 .072 0 r
.41839 .86304 m .38342 .8533 L .41839 .8869 L p F P
0 g
s
.097 0 .374 r
.79502 .73705 m .81631 .71329 L .82317 .6352 L p F P
0 g
s
0 0 .272 r
.83859 .60753 m .82317 .6352 L .81631 .71329 L p F P
0 g
s
.112 .254 .732 r
.82346 .50071 m .82352 .47146 L .77274 .40934 L p F P
0 g
s
0 .179 .709 r
.76583 .38421 m .77274 .40934 L .82352 .47146 L p F P
0 g
s
.294 0 0 r
.58914 .89779 m .6166 .89201 L .64571 .86022 L p F P
0 g
s
.173 0 0 r
.67988 .8496 m .64571 .86022 L .6166 .89201 L p F P
0 g
s
.716 .986 .883 r
.33613 .32236 m .31261 .34397 L .37598 .31917 L p F P
0 g
s
.716 .986 .883 r
.37598 .31917 m .39297 .30381 L .33613 .32236 L p F P
0 g
s
.969 .868 .474 r
.20457 .55781 m .20761 .58778 L .23075 .50995 L p F P
0 g
s
.969 .868 .474 r
.23075 .50995 m .22832 .48089 L .20457 .55781 L p F P
0 g
s
.62 .056 0 r
.39432 .87775 m .41839 .8869 L .38342 .8533 L p F P
0 g
s
.62 .056 0 r
.38342 .8533 m .35118 .84086 L .39432 .87775 L p F P
0 g
s
.129 .46 .888 r
.75258 .35979 m .73311 .3368 L .67164 .31406 L p F P
0 g
s
.038 .454 .877 r
.6534 .29928 m .67164 .31406 L .73311 .3368 L p F P
0 g
s
.846 .398 0 r
.27786 .78929 m .29771 .8086 L .26566 .74419 L p F P
0 g
s
.846 .398 0 r
.26566 .74419 m .24249 .72114 L .27786 .78929 L p F P
0 g
s
.173 0 0 r
.6166 .89201 m .64223 .88418 L .67988 .8496 L p F P
0 g
s
.014 0 0 r
.7111 .83632 m .67988 .8496 L .64223 .88418 L p F P
0 g
s
0 .014 .532 r
.83859 .60753 m .84685 .57827 L .82346 .50071 L p F P
0 g
s
0 0 .435 r
.82352 .47146 m .82346 .50071 L .84685 .57827 L p F P
0 g
s
.843 .974 .667 r
.24615 .42246 m .23337 .45147 L .28389 .39222 L p F P
0 g
s
.843 .974 .667 r
.28389 .39222 m .29511 .3675 L .24615 .42246 L p F P
0 g
s
.593 .949 .856 r
.36519 .30336 m .33613 .32236 L .39297 .30381 L p F P
0 g
s
.593 .949 .856 r
.39297 .30381 m .41368 .2904 L .36519 .30336 L p F P
0 g
s
.006 0 .085 r
.73865 .82058 m .76185 .80261 L .79502 .73705 L p F P
0 g
s
0 0 0 r
.81631 .71329 m .79502 .73705 L .76185 .80261 L p F P
0 g
s
.919 .652 .162 r
.21519 .66924 m .22544 .696 L .21824 .6166 L p F P
0 g
s
.919 .652 .162 r
.21824 .6166 m .20761 .58778 L .21519 .66924 L p F P
0 g
s
.038 .454 .877 r
.73311 .3368 m .70775 .31595 L .6534 .29928 L p F P
0 g
s
0 .447 .843 r
.63161 .28658 m .6534 .29928 L .70775 .31595 L p F P
0 g
s
0 .179 .709 r
.82352 .47146 m .81601 .44208 L .76583 .38421 L p F P
0 g
s
0 .082 .637 r
.75258 .35979 m .76583 .38421 L .81601 .44208 L p F P
0 g
s
.585 .015 0 r
.37301 .86679 m .39432 .87775 L .35118 .84086 L p F P
0 g
s
.585 .015 0 r
.35118 .84086 m .32237 .82588 L .37301 .86679 L p F P
0 g
s
0 0 .272 r
.81631 .71329 m .83125 .68757 L .83859 .60753 L p F P
0 g
s
0 0 .098 r
.84685 .57827 m .83859 .60753 L .83125 .68757 L p F P
0 g
s
.014 0 0 r
.64223 .88418 m .66547 .87443 L .7111 .83632 L p F P
0 g
s
0 0 0 r
.73865 .82058 m .7111 .83632 L .66547 .87443 L p F P
0 g
s
.442 .876 .809 r
.39907 .28762 m .36519 .30336 L .41368 .2904 L p F P
0 g
s
.442 .876 .809 r
.41368 .2904 m .43758 .27935 L .39907 .28762 L p F P
0 g
s
0 .447 .843 r
.70775 .31595 m .67706 .29792 L .63161 .28658 L p F P
0 g
s
0 .445 .792 r
.60682 .27637 m .63161 .28658 L .67706 .29792 L p F P
0 g
s
.82 .81 .322 r
.20961 .52739 m .20457 .55781 L .22832 .48089 L p F P
0 g
s
.82 .81 .322 r
.22832 .48089 m .23337 .45147 L .20961 .52739 L p F P
0 g
s
.733 .314 0 r
.26347 .76831 m .27786 .78929 L .24249 .72114 L p F P
0 g
s
.733 .314 0 r
.24249 .72114 m .22544 .696 L .26347 .76831 L p F P
0 g
s
.651 .892 .551 r
.26667 .39471 m .24615 .42246 L .29511 .3675 L p F P
0 g
s
.651 .892 .551 r
.29511 .3675 m .31261 .34397 L .26667 .39471 L p F P
0 g
s
.284 .781 .754 r
.43684 .2757 m .39907 .28762 L .43758 .27935 L p F P
0 g
s
.284 .781 .754 r
.43758 .27935 m .46403 .27103 L .43684 .2757 L p F P
0 g
s
0 .445 .792 r
.67706 .29792 m .64182 .28336 L .60682 .27637 L p F P
0 g
s
0 .454 .737 r
.57969 .26898 m .60682 .27637 L .64182 .28336 L p F P
0 g
s
.497 0 0 r
.35499 .85421 m .37301 .86679 L .32237 .82588 L p F P
0 g
s
.497 0 0 r
.32237 .82588 m .29771 .8086 L .35499 .85421 L p F P
0 g
s
0 0 .435 r
.84685 .57827 m .84734 .54807 L .82352 .47146 L p F P
0 g
s
0 0 .257 r
.81601 .44208 m .82352 .47146 L .84734 .54807 L p F P
0 g
s
0 .082 .637 r
.81601 .44208 m .80074 .41339 L .75258 .35979 L p F P
0 g
s
0 0 .501 r
.73311 .3368 m .75258 .35979 L .80074 .41339 L p F P
0 g
s
0 0 0 r
.76185 .80261 m .78001 .78273 L .81631 .71329 L p F P
0 g
s
0 0 0 r
.83125 .68757 m .81631 .71329 L .78001 .78273 L p F P
0 g
s
.14 .682 .705 r
.47741 .26806 m .43684 .2757 L .46403 .27103 L p F P
0 g
s
.14 .682 .705 r
.46403 .27103 m .49231 .2657 L .47741 .26806 L p F P
0 g
s
0 .454 .737 r
.64182 .28336 m .60303 .27277 L .57969 .26898 L p F P
0 g
s
.112 0 0 r
.551 .26466 m .57969 .26898 L .60303 .27277 L p F P
0 g
s
0 0 0 r
.66547 .87443 m .68578 .86292 L .73865 .82058 L p F P
0 g
s
0 0 0 r
.76185 .80261 m .73865 .82058 L .68578 .86292 L p F P
0 g
s
.713 .527 0 r
.21236 .64143 m .21519 .66924 L .20761 .58778 L p F P
0 g
s
.713 .527 0 r
.20761 .58778 m .20457 .55781 L .21236 .64143 L p F P
0 g
s
0 0 0 r
.51951 .26497 m .47741 .26806 L .49231 .2657 L p F P
0 g
s
0 0 0 r
.49231 .2657 m .52159 .26355 L .51951 .26497 L p F P
0 g
s
.112 0 0 r
.60303 .27277 m .56183 .26656 L .551 .26466 L p F P
0 g
s
.062 0 0 r
.52159 .26355 m .551 .26466 L .56183 .26656 L p F P
0 g
s
.062 0 0 r
.56183 .26656 m .51951 .26497 L .52159 .26355 L p F P
0 g
s
.033 .603 .755 r
.51272 .90026 m .52892 .90067 L .53105 .90291 L p F P
0 g
s
.033 .603 .755 r
.53105 .90291 m .50157 .90215 L .51272 .90026 L p F P
0 g
s
.087 .646 .758 r
.56044 .90145 m .53105 .90291 L .52892 .90067 L p F P
0 g
s
.001 .573 .769 r
.49682 .89864 m .51272 .90026 L .50157 .90215 L p F P
0 g
s
.001 .573 .769 r
.50157 .90215 m .47258 .8992 L .49682 .89864 L p F P
0 g
s
.087 .646 .758 r
.52892 .90067 m .54506 .89987 L .56044 .90145 L p F P
0 g
s
.163 .702 .777 r
.58914 .89779 m .56044 .90145 L .54506 .89987 L p F P
0 g
s
0 0 .098 r
.83125 .68757 m .83918 .66041 L .84685 .57827 L p F P
0 g
s
.787 .681 .134 r
.84734 .54807 m .84685 .57827 L .83918 .66041 L p F P
0 g
s
0 0 0 r
.29468 .36909 m .26667 .39471 L .31261 .34397 L p F P
0 g
s
0 0 0 r
.31261 .34397 m .33613 .32236 L .29468 .36909 L p F P
0 g
s
0 .556 .797 r
.48157 .89584 m .49682 .89864 L .47258 .8992 L p F P
0 g
s
0 .556 .797 r
.47258 .8992 m .44466 .89409 L .48157 .89584 L p F P
0 g
s
.163 .702 .777 r
.54506 .89987 m .56079 .89787 L .58914 .89779 L p F P
0 g
s
.255 .767 .808 r
.6166 .89201 m .58914 .89779 L .56079 .89787 L p F P
0 g
s
0 0 0 r
.22303 .49732 m .20961 .52739 L .23337 .45147 L p F P
0 g
s
0 0 0 r
.23337 .45147 m .24615 .42246 L .22303 .49732 L p F P
0 g
s
0 .145 .638 r
.34074 .84025 m .35499 .85421 L .29771 .8086 L p F P
0 g
s
0 .145 .638 r
.29771 .8086 m .27786 .78929 L .34074 .84025 L p F P
0 g
s
0 0 .428 r
.25511 .74607 m .26347 .76831 L .22544 .696 L p F P
0 g
s
0 0 .428 r
.22544 .696 m .21519 .66924 L .25511 .74607 L p F P
0 g
s
0 0 .501 r
.80074 .41339 m .77777 .38622 L .73311 .3368 L p F P
0 g
s
.641 .113 0 r
.70775 .31595 m .73311 .3368 L .77777 .38622 L p F P
0 g
s
.005 .55 .834 r
.46731 .89191 m .48157 .89584 L .44466 .89409 L p F P
0 g
s
.005 .55 .834 r
.44466 .89409 m .41839 .8869 L .46731 .89191 L p F P
0 g
s
.255 .767 .808 r
.56079 .89787 m .57576 .8947 L .6166 .89201 L p F P
0 g
s
.36 .833 .847 r
.64223 .88418 m .6166 .89201 L .57576 .8947 L p F P
0 g
s
0 0 0 r
.68578 .86292 m .70264 .84987 L .76185 .80261 L p F P
0 g
s
.637 .933 .679 r
.78001 .78273 m .76185 .80261 L .70264 .84987 L p F P
0 g
s
0 0 .257 r
.84734 .54807 m .83964 .51767 L .81601 .44208 L p F P
0 g
s
.841 .482 0 r
.80074 .41339 m .81601 .44208 L .83964 .51767 L p F P
0 g
s
0 0 0 r
.78001 .78273 m .79252 .76129 L .83125 .68757 L p F P
0 g
s
.829 .9 .485 r
.83918 .66041 m .83125 .68757 L .79252 .76129 L p F P
0 g
s
.041 .553 .874 r
.45437 .88694 m .46731 .89191 L .41839 .8869 L p F P
0 g
s
.041 .553 .874 r
.41839 .8869 m .39432 .87775 L .45437 .88694 L p F P
0 g
s
.36 .833 .847 r
.57576 .8947 m .58963 .89043 L .64223 .88418 L p F P
0 g
s
.469 .892 .886 r
.66547 .87443 m .64223 .88418 L .58963 .89043 L p F P
0 g
s
0 0 0 r
.32965 .34646 m .29468 .36909 L .33613 .32236 L p F P
0 g
s
0 0 0 r
.33613 .32236 m .36519 .30336 L .32965 .34646 L p F P
0 g
s
0 0 .277 r
.21741 .61322 m .21236 .64143 L .20457 .55781 L p F P
0 g
s
0 0 .277 r
.20457 .55781 m .20961 .52739 L .21741 .61322 L p F P
0 g
s
.641 .113 0 r
.77777 .38622 m .74746 .36146 L .70775 .31595 L p F P
0 g
s
.701 .16 0 r
.67706 .29792 m .70775 .31595 L .74746 .36146 L p F P
0 g
s
0 .238 .748 r
.33071 .82518 m .34074 .84025 L .27786 .78929 L p F P
0 g
s
0 .238 .748 r
.27786 .78929 m .26347 .76831 L .33071 .82518 L p F P
0 g
s
.094 .559 .908 r
.44306 .88103 m .45437 .88694 L .39432 .87775 L p F P
0 g
s
.094 .559 .908 r
.39432 .87775 m .37301 .86679 L .44306 .88103 L p F P
0 g
s
.787 .681 .134 r
.83918 .66041 m .83953 .63239 L .84734 .54807 L p F P
0 g
s
.963 .773 .331 r
.83964 .51767 m .84734 .54807 L .83953 .63239 L p F P
0 g
s
0 0 .096 r
.24489 .46847 m .22303 .49732 L .24615 .42246 L p F P
0 g
s
0 0 .096 r
.24615 .42246 m .26667 .39471 L .24489 .46847 L p F P
0 g
s
.469 .892 .886 r
.58963 .89043 m .60207 .88514 L .66547 .87443 L p F P
0 g
s
.571 .936 .917 r
.68578 .86292 m .66547 .87443 L .60207 .88514 L p F P
0 g
s
.637 .933 .679 r
.70264 .84987 m .71559 .83552 L .78001 .78273 L p F P
0 g
s
.794 .995 .771 r
.79252 .76129 m .78001 .78273 L .71559 .83552 L p F P
0 g
s
0 .007 .577 r
.25326 .72306 m .25511 .74607 L .21519 .66924 L p F P
0 g
s
0 .007 .577 r
.21519 .66924 m .21236 .64143 L .25326 .72306 L p F P
0 g
s
.112 0 0 r
.37072 .32764 m .32965 .34646 L .36519 .30336 L p F P
0 g
s
.112 0 0 r
.36519 .30336 m .39907 .28762 L .37072 .32764 L p F P
0 g
s
.841 .482 0 r
.83964 .51767 m .82351 .48789 L .80074 .41339 L p F P
0 g
s
.92 .532 .147 r
.77777 .38622 m .80074 .41339 L .82351 .48789 L p F P
0 g
s
.157 .567 .931 r
.43366 .8743 m .44306 .88103 L .37301 .86679 L p F P
0 g
s
.157 .567 .931 r
.37301 .86679 m .35499 .85421 L .43366 .8743 L p F P
0 g
s
.701 .16 0 r
.74746 .36146 m .71043 .33997 L .67706 .29792 L p F P
0 g
s
.702 .173 0 r
.64182 .28336 m .67706 .29792 L .71043 .33997 L p F P
0 g
s
.829 .9 .485 r
.79252 .76129 m .79884 .73875 L .83918 .66041 L p F P
0 g
s
.956 .935 .607 r
.83953 .63239 m .83918 .66041 L .79884 .73875 L p F P
0 g
s
.571 .936 .917 r
.60207 .88514 m .6128 .87895 L .68578 .86292 L p F P
0 g
s
.657 .959 .936 r
.70264 .84987 m .68578 .86292 L .6128 .87895 L p F P
0 g
s
.275 0 .001 r
.41676 .31335 m .37072 .32764 L .39907 .28762 L p F P
0 g
s
.275 0 .001 r
.39907 .28762 m .43684 .2757 L .41676 .31335 L p F P
0 g
s
.022 .315 .803 r
.32526 .80932 m .33071 .82518 L .26347 .76831 L p F P
0 g
s
.022 .315 .803 r
.26347 .76831 m .25511 .74607 L .32526 .80932 L p F P
0 g
s
0 0 .418 r
.23063 .58537 m .21741 .61322 L .20961 .52739 L p F P
0 g
s
0 0 .418 r
.20961 .52739 m .22303 .49732 L .23063 .58537 L p F P
0 g
s
.702 .173 0 r
.71043 .33997 m .66762 .32253 L .64182 .28336 L p F P
0 g
s
.672 .162 .022 r
.60303 .27277 m .64182 .28336 L .66762 .32253 L p F P
0 g
s
.225 .573 .941 r
.42642 .86689 m .43366 .8743 L .35499 .85421 L p F P
0 g
s
.225 .573 .941 r
.35499 .85421 m .34074 .84025 L .42642 .86689 L p F P
0 g
s
.082 0 .232 r
.27496 .44178 m .24489 .46847 L .26667 .39471 L p F P
0 g
s
.082 0 .232 r
.26667 .39471 m .29468 .36909 L .27496 .44178 L p F P
0 g
s
.794 .995 .771 r
.71559 .83552 m .72419 .82016 L .79252 .76129 L p F P
0 g
s
.877 .99 .812 r
.79884 .73875 m .79252 .76129 L .72419 .82016 L p F P
0 g
s
.397 0 .054 r
.46638 .30416 m .41676 .31335 L .43684 .2757 L p F P
0 g
s
.397 0 .054 r
.43684 .2757 m .47741 .26806 L .46638 .30416 L p F P
0 g
s
.963 .773 .331 r
.83953 .63239 m .83188 .60421 L .83964 .51767 L p F P
0 g
s
.996 .764 .447 r
.82351 .48789 m .83964 .51767 L .83188 .60421 L p F P
0 g
s
.657 .959 .936 r
.6128 .87895 m .62154 .87199 L .70264 .84987 L p F P
0 g
s
.723 .963 .941 r
.71559 .83552 m .70264 .84987 L .62154 .87199 L p F P
0 g
s
.672 .162 .022 r
.66762 .32253 m .62027 .30983 L .60303 .27277 L p F P
0 g
s
.624 .133 .065 r
.56183 .26656 m .60303 .27277 L .62027 .30983 L p F P
0 g
s
.039 .145 .647 r
.25827 .69982 m .25326 .72306 L .21236 .64143 L p F P
0 g
s
.039 .145 .647 r
.21236 .64143 m .21741 .61322 L .25827 .69982 L p F P
0 g
s
.92 .532 .147 r
.82351 .48789 m .79897 .45963 L .77777 .38622 L p F P
0 g
s
.913 .526 .263 r
.74746 .36146 m .77777 .38622 L .79897 .45963 L p F P
0 g
s
.49 .027 .08 r
.51797 .30045 m .46638 .30416 L .47741 .26806 L p F P
0 g
s
.49 .027 .08 r
.47741 .26806 m .51951 .26497 L .51797 .30045 L p F P
0 g
s
.624 .133 .065 r
.62027 .30983 m .56984 .30236 L .56183 .26656 L p F P
0 g
s
.564 .088 .084 r
.51951 .26497 m .56183 .26656 L .56984 .30236 L p F P
0 g
s
.564 .088 .084 r
.56984 .30236 m .51797 .30045 L .51951 .26497 L p F P
0 g
s
.541 .809 .995 r
.52892 .90067 m .51272 .90026 L .52632 .86433 L closepath p F P
0 g
s
.554 .819 .995 r
.54506 .89987 m .52892 .90067 L .52632 .86433 L closepath p F P
0 g
s
.531 .799 .995 r
.51272 .90026 m .49682 .89864 L .52632 .86433 L closepath p F P
0 g
s
.569 .828 .994 r
.56079 .89787 m .54506 .89987 L .52632 .86433 L closepath p F P
0 g
s
.291 .577 .939 r
.42153 .85897 m .42642 .86689 L .34074 .84025 L p F P
0 g
s
.291 .577 .939 r
.34074 .84025 m .33071 .82518 L .42153 .85897 L p F P
0 g
s
.956 .935 .607 r
.79884 .73875 m .79853 .7156 L .83953 .63239 L p F P
0 g
s
.981 .896 .659 r
.83188 .60421 m .83953 .63239 L .79853 .7156 L p F P
0 g
s
.524 .788 .993 r
.49682 .89864 m .48157 .89584 L .52632 .86433 L closepath p F P
0 g
s
.586 .836 .992 r
.57576 .8947 m .56079 .89787 L .52632 .86433 L closepath p F P
0 g
s
.174 .372 .819 r
.32469 .79305 m .32526 .80932 L .25511 .74607 L p F P
0 g
s
.174 .372 .819 r
.25511 .74607 m .25326 .72306 L .32469 .79305 L p F P
0 g
s
.52 .777 .99 r
.48157 .89584 m .46731 .89191 L .52632 .86433 L closepath p F P
0 g
s
.603 .842 .989 r
.58963 .89043 m .57576 .8947 L .52632 .86433 L closepath p F P
0 g
s
.723 .963 .941 r
.62154 .87199 m .62805 .86439 L .71559 .83552 L p F P
0 g
s
.767 .95 .936 r
.72419 .82016 m .71559 .83552 L .62805 .86439 L p F P
0 g
s
.266 .002 .313 r
.31268 .41814 m .27496 .44178 L .29468 .36909 L p F P
0 g
s
.266 .002 .313 r
.29468 .36909 m .32965 .34646 L .31268 .41814 L p F P
0 g
s
.162 .067 .491 r
.25205 .55867 m .23063 .58537 L .22303 .49732 L p F P
0 g
s
.162 .067 .491 r
.22303 .49732 m .24489 .46847 L .25205 .55867 L p F P
0 g
s
.519 .767 .987 r
.46731 .89191 m .45437 .88694 L .52632 .86433 L closepath p F P
0 g
s
.877 .99 .812 r
.72419 .82016 m .7281 .80413 L .79884 .73875 L p F P
0 g
s
.906 .95 .818 r
.79853 .7156 m .79884 .73875 L .7281 .80413 L p F P
0 g
s
.62 .846 .985 r
.60207 .88514 m .58963 .89043 L .52632 .86433 L closepath p F P
0 g
s
.913 .526 .263 r
.79897 .45963 m .76637 .43382 L .74746 .36146 L p F P
0 g
s
.875 .501 .332 r
.71043 .33997 m .74746 .36146 L .76637 .43382 L p F P
0 g
s
.521 .757 .982 r
.45437 .88694 m .44306 .88103 L .52632 .86433 L closepath p F P
0 g
s
.996 .764 .447 r
.83188 .60421 m .81602 .57664 L .82351 .48789 L p F P
0 g
s
.968 .72 .506 r
.79897 .45963 m .82351 .48789 L .81602 .57664 L p F P
0 g
s
.637 .847 .981 r
.6128 .87895 m .60207 .88514 L .52632 .86433 L closepath p F P
0 g
s
.351 .58 .928 r
.41917 .85072 m .42153 .85897 L .33071 .82518 L p F P
0 g
s
.351 .58 .928 r
.33071 .82518 m .32526 .80932 L .41917 .85072 L p F P
0 g
s
.217 .242 .673 r
.27031 .67699 m .25827 .69982 L .21741 .61322 L p F P
0 g
s
.217 .242 .673 r
.21741 .61322 m .23063 .58537 L .27031 .67699 L p F P
0 g
s
.526 .748 .977 r
.44306 .88103 m .43366 .8743 L .52632 .86433 L closepath p F P
0 g
s
.767 .95 .936 r
.62805 .86439 m .63214 .85635 L .72419 .82016 L p F P
0 g
s
.794 .927 .923 r
.7281 .80413 m .72419 .82016 L .63214 .85635 L p F P
0 g
s
.652 .847 .975 r
.62154 .87199 m .6128 .87895 L .52632 .86433 L closepath p F P
0 g
s
.395 .112 .362 r
.35716 .39846 m .31268 .41814 L .32965 .34646 L p F P
0 g
s
.395 .112 .362 r
.32965 .34646 m .37072 .32764 L .35716 .39846 L p F P
0 g
s
.291 .413 .814 r
.32917 .77674 m .32469 .79305 L .25326 .72306 L p F P
0 g
s
.291 .413 .814 r
.25326 .72306 m .25827 .69982 L .32917 .77674 L p F P
0 g
s
.981 .896 .659 r
.79853 .7156 m .79127 .69243 L .83188 .60421 L p F P
0 g
s
.961 .838 .676 r
.81602 .57664 m .83188 .60421 L .79127 .69243 L p F P
0 g
s
.532 .74 .971 r
.43366 .8743 m .42642 .86689 L .52632 .86433 L closepath p F P
0 g
s
.875 .501 .332 r
.76637 .43382 m .72637 .41136 L .71043 .33997 L p F P
0 g
s
.828 .468 .373 r
.66762 .32253 m .71043 .33997 L .72637 .41136 L p F P
0 g
s
.665 .844 .969 r
.62805 .86439 m .62154 .87199 L .52632 .86433 L closepath p F P
0 g
s
.315 .177 .529 r
.28145 .53398 m .25205 .55867 L .24489 .46847 L p F P
0 g
s
.315 .177 .529 r
.24489 .46847 m .27496 .44178 L .28145 .53398 L p F P
0 g
s
.906 .95 .818 r
.7281 .80413 m .72706 .7878 L .79853 .7156 L p F P
0 g
s
.905 .899 .81 r
.79127 .69243 m .79853 .7156 L .72706 .7878 L p F P
0 g
s
.405 .583 .913 r
.41943 .84234 m .41917 .85072 L .32526 .80932 L p F P
0 g
s
.405 .583 .913 r
.32526 .80932 m .32469 .79305 L .41943 .84234 L p F P
0 g
s
.541 .733 .964 r
.42642 .86689 m .42153 .85897 L .52632 .86433 L closepath p F P
0 g
s
.794 .927 .923 r
.63214 .85635 m .63367 .84804 L .7281 .80413 L p F P
0 g
s
.806 .899 .908 r
.72706 .7878 m .7281 .80413 L .63367 .84804 L p F P
0 g
s
.968 .72 .506 r
.81602 .57664 m .792 .5505 L .79897 .45963 L p F P
0 g
s
.924 .671 .536 r
.76637 .43382 m .79897 .45963 L .792 .5505 L p F P
0 g
s
.676 .839 .962 r
.63214 .85635 m .62805 .86439 L .52632 .86433 L closepath p F P
0 g
s
.49 .194 .391 r
.40714 .38349 m .35716 .39846 L .37072 .32764 L p F P
0 g
s
.49 .194 .391 r
.37072 .32764 m .41676 .31335 L .40714 .38349 L p F P
0 g
s
.828 .468 .373 r
.72637 .41136 m .67998 .39311 L .66762 .32253 L p F P
0 g
s
.78 .433 .397 r
.62027 .30983 m .66762 .32253 L .67998 .39311 L p F P
0 g
s
.342 .311 .679 r
.28937 .65519 m .27031 .67699 L .23063 .58537 L p F P
0 g
s
.342 .311 .679 r
.23063 .58537 m .25205 .55867 L .28937 .65519 L p F P
0 g
s
.551 .727 .957 r
.42153 .85897 m .41917 .85072 L .52632 .86433 L closepath p F P
0 g
s
.685 .833 .954 r
.63367 .84804 m .63214 .85635 L .52632 .86433 L closepath p F P
0 g
s
.38 .444 .801 r
.33876 .76084 m .32917 .77674 L .25827 .69982 L p F P
0 g
s
.38 .444 .801 r
.25827 .69982 m .27031 .67699 L .33876 .76084 L p F P
0 g
s
.452 .586 .896 r
.42235 .83403 m .41943 .84234 L .32469 .79305 L p F P
0 g
s
.452 .586 .896 r
.32469 .79305 m .32917 .77674 L .42235 .83403 L p F P
0 g
s
.564 .258 .408 r
.46108 .37385 m .40714 .38349 L .41676 .31335 L p F P
0 g
s
.564 .258 .408 r
.41676 .31335 m .46638 .30416 L .46108 .37385 L p F P
0 g
s
.961 .838 .676 r
.79127 .69243 m .77697 .66985 L .81602 .57664 L p F P
0 g
s
.927 .78 .679 r
.792 .5505 m .81602 .57664 L .77697 .66985 L p F P
0 g
s
.78 .433 .397 r
.67998 .39311 m .62855 .37979 L .62027 .30983 L p F P
0 g
s
.732 .396 .411 r
.56984 .30236 m .62027 .30983 L .62855 .37979 L p F P
0 g
s
.423 .256 .548 r
.31827 .51214 m .28145 .53398 L .27496 .44178 L p F P
0 g
s
.423 .256 .548 r
.27496 .44178 m .31268 .41814 L .31827 .51214 L p F P
0 g
s
.561 .723 .949 r
.41917 .85072 m .41943 .84234 L .52632 .86433 L closepath p F P
0 g
s
.806 .899 .908 r
.63367 .84804 m .63256 .83966 L .72706 .7878 L p F P
0 g
s
.809 .868 .891 r
.72094 .77158 m .72706 .7878 L .63256 .83966 L p F P
0 g
s
.905 .899 .81 r
.72706 .7878 m .72094 .77158 L .79127 .69243 L p F P
0 g
s
.89 .849 .797 r
.77697 .66985 m .79127 .69243 L .72094 .77158 L p F P
0 g
s
.691 .825 .947 r
.63256 .83966 m .63367 .84804 L .52632 .86433 L closepath p F P
0 g
s
.626 .311 .416 r
.51723 .36995 m .46108 .37385 L .46638 .30416 L p F P
0 g
s
.626 .311 .416 r
.46638 .30416 m .51797 .30045 L .51723 .36995 L p F P
0 g
s
.732 .396 .411 r
.62855 .37979 m .57369 .37196 L .56984 .30236 L p F P
0 g
s
.681 .355 .417 r
.51797 .30045 m .56984 .30236 L .57369 .37196 L p F P
0 g
s
.681 .355 .417 r
.57369 .37196 m .51723 .36995 L .51797 .30045 L p F P
0 g
s
.924 .671 .536 r
.792 .5505 m .76015 .52663 L .76637 .43382 L p F P
0 g
s
.878 .625 .552 r
.72637 .41136 m .76637 .43382 L .76015 .52663 L p F P
0 g
s
.697 .797 .926 r
.61351 .81623 m .62239 .82354 L .52632 .86433 L closepath p F P
0 g
s
.696 .787 .921 r
.60234 .80968 m .61351 .81623 L .52632 .86433 L closepath p F P
0 g
s
.692 .777 .916 r
.58914 .80409 m .60234 .80968 L .52632 .86433 L closepath p F P
0 g
s
.688 .767 .912 r
.57425 .79961 m .58914 .80409 L .52632 .86433 L closepath p F P
0 g
s
.682 .758 .909 r
.55805 .79639 m .57425 .79961 L .52632 .86433 L closepath p F P
0 g
s
.675 .75 .907 r
.54098 .7945 m .55805 .79639 L .52632 .86433 L closepath p F P
0 g
s
.667 .742 .906 r
.52351 .79402 m .54098 .7945 L .52632 .86433 L closepath p F P
0 g
s
.659 .736 .907 r
.50611 .79496 m .52351 .79402 L .52632 .86433 L closepath p F P
0 g
s
.649 .73 .908 r
.48927 .79728 m .50611 .79496 L .52632 .86433 L closepath p F P
0 g
s
.639 .725 .91 r
.47345 .80092 m .48927 .79728 L .52632 .86433 L closepath p F P
0 g
s
.629 .721 .913 r
.45906 .80577 m .47345 .80092 L .52632 .86433 L closepath p F P
0 g
s
.618 .718 .918 r
.44647 .81169 m .45906 .80577 L .52632 .86433 L closepath p F P
0 g
s
.607 .717 .923 r
.43601 .8185 m .44647 .81169 L .52632 .86433 L closepath p F P
0 g
s
.595 .716 .928 r
.42791 .82602 m .43601 .8185 L .52632 .86433 L closepath p F P
0 g
s
.584 .717 .935 r
.42235 .83403 m .42791 .82602 L .52632 .86433 L closepath p F P
0 g
s
.572 .719 .942 r
.41943 .84234 m .42235 .83403 L .52632 .86433 L closepath p F P
0 g
s
.695 .816 .94 r
.62878 .83142 m .63256 .83966 L .52632 .86433 L closepath p F P
0 g
s
.697 .806 .933 r
.62239 .82354 m .62878 .83142 L .52632 .86433 L closepath p F P
0 g
s
.809 .868 .891 r
.63256 .83966 m .62878 .83142 L .72094 .77158 L p F P
0 g
s
.493 .59 .88 r
.42791 .82602 m .42235 .83403 L .32917 .77674 L p F P
0 g
s
.493 .59 .88 r
.32917 .77674 m .33876 .76084 L .42791 .82602 L p F P
0 g
s
.433 .362 .678 r
.31519 .63512 m .28937 .65519 L .25205 .55867 L p F P
0 g
s
.433 .362 .678 r
.25205 .55867 m .28145 .53398 L .31519 .63512 L p F P
0 g
s
.45 .469 .788 r
.35337 .74579 m .33876 .76084 L .27031 .67699 L p F P
0 g
s
.45 .469 .788 r
.27031 .67699 m .28937 .65519 L .35337 .74579 L p F P
0 g
s
.805 .837 .875 r
.70973 .7559 m .72094 .77158 L .62878 .83142 L p F P
0 g
s
.89 .849 .797 r
.72094 .77158 m .70973 .7559 L .77697 .66985 L p F P
0 g
s
.503 .316 .559 r
.36163 .49396 m .31827 .51214 L .31268 .41814 L p F P
0 g
s
.503 .316 .559 r
.31268 .41814 m .35716 .39846 L .36163 .49396 L p F P
0 g
s
.805 .837 .875 r
.62878 .83142 m .62239 .82354 L .70973 .7559 L p F P
0 g
s
.927 .78 .679 r
.77697 .66985 m .7557 .64854 L .792 .5505 L p F P
0 g
s
.89 .73 .677 r
.76015 .52663 m .792 .5505 L .7557 .64854 L p F P
0 g
s
.868 .802 .783 r
.7557 .64854 m .77697 .66985 L .70973 .7559 L p F P
0 g
s
.878 .625 .552 r
.76015 .52663 m .72112 .50588 L .72637 .41136 L p F P
0 g
s
.834 .584 .561 r
.67998 .39311 m .72637 .41136 L .72112 .50588 L p F P
0 g
s
.529 .596 .865 r
.43601 .8185 m .42791 .82602 L .33876 .76084 L p F P
0 g
s
.797 .808 .861 r
.62239 .82354 m .61351 .81623 L .69356 .74121 L p F P
0 g
s
.797 .808 .861 r
.69356 .74121 m .70973 .7559 L .62239 .82354 L p F P
0 g
s
.529 .596 .865 r
.33876 .76084 m .35337 .74579 L .43601 .8185 L p F P
0 g
s
.561 .603 .852 r
.44647 .81169 m .43601 .8185 L .35337 .74579 L p F P
0 g
s
.868 .802 .783 r
.70973 .7559 m .69356 .74121 L .7557 .64854 L p F P
0 g
s
.567 .364 .565 r
.41031 .48014 m .36163 .49396 L .35716 .39846 L p F P
0 g
s
.567 .364 .565 r
.35716 .39846 m .40714 .38349 L .41031 .48014 L p F P
0 g
s
.502 .403 .675 r
.34725 .61743 m .31519 .63512 L .28145 .53398 L p F P
0 g
s
.502 .403 .675 r
.28145 .53398 m .31827 .51214 L .34725 .61743 L p F P
0 g
s
.785 .78 .848 r
.61351 .81623 m .60234 .80968 L .67274 .72794 L p F P
0 g
s
.785 .78 .848 r
.67274 .72794 m .69356 .74121 L .61351 .81623 L p F P
0 g
s
.506 .492 .775 r
.37273 .73201 m .35337 .74579 L .28937 .65519 L p F P
0 g
s
.506 .492 .775 r
.28937 .65519 m .31519 .63512 L .37273 .73201 L p F P
0 g
s
.834 .584 .561 r
.72112 .50588 m .67591 .48902 L .67998 .39311 L p F P
0 g
s
.792 .547 .566 r
.62855 .37979 m .67998 .39311 L .67591 .48902 L p F P
0 g
s
.59 .611 .841 r
.45906 .80577 m .44647 .81169 L .37273 .73201 L p F P
0 g
s
.561 .603 .852 r
.35337 .74579 m .37273 .73201 L .44647 .81169 L p F P
0 g
s
.89 .73 .677 r
.7557 .64854 m .72781 .62916 L .76015 .52663 L p F P
0 g
s
.853 .686 .674 r
.72112 .50588 m .76015 .52663 L .72781 .62916 L p F P
0 g
s
.771 .755 .838 r
.60234 .80968 m .58914 .80409 L .64776 .71652 L p F P
0 g
s
.771 .755 .838 r
.64776 .71652 m .67274 .72794 L .60234 .80968 L p F P
0 g
s
.844 .761 .771 r
.72781 .62916 m .7557 .64854 L .69356 .74121 L p F P
0 g
s
.616 .621 .833 r
.47345 .80092 m .45906 .80577 L .39644 .71996 L p F P
0 g
s
.59 .611 .841 r
.37273 .73201 m .39644 .71996 L .45906 .80577 L p F P
0 g
s
.62 .405 .568 r
.46283 .47125 m .41031 .48014 L .40714 .38349 L p F P
0 g
s
.62 .405 .568 r
.40714 .38349 m .46108 .37385 L .46283 .47125 L p F P
0 g
s
.844 .761 .771 r
.69356 .74121 m .67274 .72794 L .72781 .62916 L p F P
0 g
s
.756 .732 .83 r
.58914 .80409 m .57425 .79961 L .61923 .70732 L p F P
0 g
s
.756 .732 .83 r
.61923 .70732 m .64776 .71652 L .58914 .80409 L p F P
0 g
s
.792 .547 .566 r
.67591 .48902 m .62582 .47673 L .62855 .37979 L p F P
0 g
s
.751 .512 .569 r
.57369 .37196 m .62855 .37979 L .62582 .47673 L p F P
0 g
s
.64 .632 .826 r
.48927 .79728 m .47345 .80092 L .42391 .71001 L p F P
0 g
s
.616 .621 .833 r
.39644 .71996 m .42391 .71001 L .47345 .80092 L p F P
0 g
s
.739 .711 .824 r
.57425 .79961 m .55805 .79639 L .58796 .70065 L p F P
0 g
s
.739 .711 .824 r
.58796 .70065 m .61923 .70732 L .57425 .79961 L p F P
0 g
s
.558 .438 .672 r
.38477 .60276 m .34725 .61743 L .31827 .51214 L p F P
0 g
s
.558 .438 .672 r
.31827 .51214 m .36163 .49396 L .38477 .60276 L p F P
0 g
s
.667 .442 .57 r
.51748 .46765 m .46283 .47125 L .46108 .37385 L p F P
0 g
s
.667 .442 .57 r
.46108 .37385 m .51723 .36995 L .51748 .46765 L p F P
0 g
s
.552 .512 .764 r
.39644 .71996 m .37273 .73201 L .31519 .63512 L p F P
0 g
s
.552 .512 .764 r
.31519 .63512 m .34725 .61743 L .39644 .71996 L p F P
0 g
s
.662 .644 .822 r
.50611 .79496 m .48927 .79728 L .4544 .70249 L p F P
0 g
s
.64 .632 .826 r
.42391 .71001 m .4544 .70249 L .48927 .79728 L p F P
0 g
s
.751 .512 .569 r
.62582 .47673 m .57242 .4695 L .57369 .37196 L p F P
0 g
s
.71 .477 .57 r
.51723 .36995 m .57369 .37196 L .57242 .4695 L p F P
0 g
s
.722 .692 .821 r
.55805 .79639 m .54098 .7945 L .55484 .69674 L p F P
0 g
s
.722 .692 .821 r
.55484 .69674 m .58796 .70065 L .55805 .79639 L p F P
0 g
s
.71 .477 .57 r
.57242 .4695 m .51748 .46765 L .51723 .36995 L p F P
0 g
s
.683 .659 .819 r
.52351 .79402 m .50611 .79496 L .48703 .69768 L p F P
0 g
s
.662 .644 .822 r
.4544 .70249 m .48703 .69768 L .50611 .79496 L p F P
0 g
s
.703 .674 .819 r
.54098 .7945 m .52351 .79402 L .52085 .69574 L p F P
0 g
s
.703 .674 .819 r
.52085 .69574 m .55484 .69674 L .54098 .7945 L p F P
0 g
s
.683 .659 .819 r
.48703 .69768 m .52085 .69574 L .52351 .79402 L p F P
0 g
s
.853 .686 .674 r
.72781 .62916 m .6939 .61237 L .72112 .50588 L p F P
0 g
s
.818 .648 .671 r
.67591 .48902 m .72112 .50588 L .6939 .61237 L p F P
0 g
s
.819 .725 .762 r
.6939 .61237 m .72781 .62916 L .67274 .72794 L p F P
0 g
s
.819 .725 .762 r
.67274 .72794 m .64776 .71652 L .6939 .61237 L p F P
0 g
s
.592 .532 .756 r
.42391 .71001 m .39644 .71996 L .34725 .61743 L p F P
0 g
s
.605 .469 .669 r
.42672 .59163 m .38477 .60276 L .36163 .49396 L p F P
0 g
s
.605 .469 .669 r
.36163 .49396 m .41031 .48014 L .42672 .59163 L p F P
0 g
s
.592 .532 .756 r
.34725 .61743 m .38477 .60276 L .42391 .71001 L p F P
0 g
s
.793 .693 .754 r
.64776 .71652 m .61923 .70732 L .65483 .59878 L p F P
0 g
s
.793 .693 .754 r
.65483 .59878 m .6939 .61237 L .64776 .71652 L p F P
0 g
s
.818 .648 .671 r
.6939 .61237 m .65483 .59878 L .67591 .48902 L p F P
0 g
s
.784 .614 .669 r
.62582 .47673 m .67591 .48902 L .65483 .59878 L p F P
0 g
s
.627 .552 .75 r
.4544 .70249 m .42391 .71001 L .38477 .60276 L p F P
0 g
s
.768 .664 .748 r
.61923 .70732 m .58796 .70065 L .61172 .58888 L p F P
0 g
s
.768 .664 .748 r
.61172 .58888 m .65483 .59878 L .61923 .70732 L p F P
0 g
s
.646 .498 .667 r
.47185 .58448 m .42672 .59163 L .41031 .48014 L p F P
0 g
s
.646 .498 .667 r
.41031 .48014 m .46283 .47125 L .47185 .58448 L p F P
0 g
s
.784 .614 .669 r
.65483 .59878 m .61172 .58888 L .62582 .47673 L p F P
0 g
s
.751 .583 .667 r
.57242 .4695 m .62582 .47673 L .61172 .58888 L p F P
0 g
s
.627 .552 .75 r
.38477 .60276 m .42672 .59163 L .4544 .70249 L p F P
0 g
s
.659 .572 .746 r
.48703 .69768 m .4544 .70249 L .42672 .59163 L p F P
0 g
s
.742 .638 .745 r
.58796 .70065 m .55484 .69674 L .56587 .58308 L p F P
0 g
s
.742 .638 .745 r
.56587 .58308 m .61172 .58888 L .58796 .70065 L p F P
0 g
s
.683 .526 .666 r
.51874 .58159 m .47185 .58448 L .46283 .47125 L p F P
0 g
s
.683 .526 .666 r
.46283 .47125 m .51748 .46765 L .51874 .58159 L p F P
0 g
s
.751 .583 .667 r
.61172 .58888 m .56587 .58308 L .57242 .4695 L p F P
0 g
s
.718 .554 .666 r
.51748 .46765 m .57242 .4695 L .56587 .58308 L p F P
0 g
s
.688 .592 .744 r
.52085 .69574 m .48703 .69768 L .47185 .58448 L p F P
0 g
s
.659 .572 .746 r
.42672 .59163 m .47185 .58448 L .48703 .69768 L p F P
0 g
s
.715 .614 .743 r
.55484 .69674 m .52085 .69574 L .51874 .58159 L p F P
0 g
s
.715 .614 .743 r
.51874 .58159 m .56587 .58308 L .55484 .69674 L p F P
0 g
s
.718 .554 .666 r
.56587 .58308 m .51874 .58159 L .51748 .46765 L p F P
0 g
s
.688 .592 .744 r
.47185 .58448 m .51874 .58159 L .52085 .69574 L p F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(-1)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(-0.5)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(0)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(0.5)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(1)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.01178 .81203 m
.01289 .80482 L
s
[(-1)] .00955 .82643 .15454 -1 Mshowa
.1225 .88995 m
.12336 .88271 L
s
[(-0.5)] .12079 .90442 .11851 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(0)] .22056 .97437 .08756 -1 Mshowa
.31143 1.0229 m
.31187 1.01563 L
s
[(0.5)] .31055 1.03745 .0607 -1 Mshowa
.39267 1.08007 m
.39294 1.07279 L
s
[(1)] .39213 1.09464 .03715 -1 Mshowa
.125 Mabswid
.03493 .82832 m
.03556 .82399 L
s
.05756 .84424 m
.05816 .83991 L
s
.07969 .85982 m
.08026 .85548 L
s
.10133 .87505 m
.10187 .87071 L
s
.14322 .90453 m
.14371 .90018 L
s
.1635 .9188 m
.16396 .91445 L
s
.18335 .93277 m
.18378 .92842 L
s
.20279 .94645 m
.2032 .9421 L
s
.24048 .97297 m
.24084 .96861 L
s
.25875 .98583 m
.25909 .98147 L
s
.27666 .99844 m
.27697 .99407 L
s
.29422 1.01079 m
.29451 1.00643 L
s
.32831 1.03478 m
.32855 1.03041 L
s
.34486 1.04643 m
.34508 1.04206 L
s
.3611 1.05786 m
.3613 1.05349 L
s
.37703 1.06907 m
.37721 1.0647 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.38.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.38.1"]
}, Open  ]],

Cell[TextData[{
 "Only a collection of points is shown when you use ",
 StyleBox["PointParametricPlot3D", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.38.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
PointParametricPlot3D[
   {Cos[u] Cos[v], Sin[u] Cos[v], Sin[v]},
            {u, 0, 2Pi }, {v, -Pi/2, Pi/2 }]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.38.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08617 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0570982 1.16395 -4.15792e-17 1.16395 [
[ 0 0 0 0 ]
[ 1 1.08617 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08799 .24648 m
0 .80912 L
s
0 .80912 m
.39369 1.08617 L
s
.39369 1.08617 m
.41208 .57696 L
s
.41208 .57696 m
.08799 .24648 L
s
.6763 0 m
.92673 .40807 L
s
.92673 .40807 m
1 .94683 L
s
1 .94683 m
.71139 .59026 L
s
.71139 .59026 m
.6763 0 L
s
.08799 .24648 m
0 .80912 L
s
0 .80912 m
.71139 .59026 L
s
.71139 .59026 m
.6763 0 L
s
.6763 0 m
.08799 .24648 L
s
.41208 .57696 m
.92673 .40807 L
s
.92673 .40807 m
1 .94683 L
s
1 .94683 m
.39369 1.08617 L
s
.39369 1.08617 m
.41208 .57696 L
s
0 0 m
1 0 L
1 1.08617 L
0 1.08617 L
closepath
clip
newpath
.01 w
.48594 .56837 Mdot
.58447 .56557 Mdot
.47991 .63143 Mdot
.4937 .5058 Mdot
.59372 .62831 Mdot
.57257 .50348 Mdot
.47581 .69294 Mdot
.6 .68967 Mdot
.39344 .54513 Mdot
.50296 .44575 Mdot
.41992 .48656 Mdot
.55839 .44407 Mdot
.37276 .60553 Mdot
.67372 .53704 Mdot
.64361 .47989 Mdot
.45135 .43181 Mdot
.69727 .59649 Mdot
.60797 .427 Mdot
.47384 .75084 Mdot
.60302 .74756 Mdot
.35867 .66571 Mdot
.51346 .39032 Mdot
.54233 .38941 Mdot
.71333 .65619 Mdot
.48671 .38286 Mdot
.56795 .3803 Mdot
.36389 .44832 Mdot
.41281 .40437 Mdot
.64266 .3972 Mdot
.32215 .49857 Mdot
.46712 .36834 Mdot
.69437 .43824 Mdot
.35186 .72354 Mdot
.58546 .36458 Mdot
.47415 .80293 Mdot
.60255 .79979 Mdot
.73861 .48621 Mdot
.72109 .71399 Mdot
.28925 .55332 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.52488 .3417 Mdot
.45861 .3494 Mdot
.59129 .34514 Mdot
.39507 .36797 Mdot
.77359 .53938 Mdot
.65525 .35969 Mdot
.46317 .32964 Mdot
.26667 .61058 Mdot
.35292 .77674 Mdot
.58393 .32572 Mdot
.58393 .32572 Mdot
.3368 .39682 Mdot
.71988 .76757 Mdot
.47686 .84693 Mdot
.59839 .84404 Mdot
.48026 .31306 Mdot
.79763 .59581 Mdot
.71415 .38498 Mdot
.56452 .31031 Mdot
.50662 .30319 Mdot
.53683 .30219 Mdot
.28628 .43504 Mdot
.4028 .32925 Mdot
.25572 .66815 Mdot
.64194 .32149 Mdot
.64194 .32149 Mdot
.76539 .42031 Mdot
.36227 .8229 Mdot
.8093 .65328 Mdot
.24593 .48135 Mdot
.70923 .8145 Mdot
.43586 .29617 Mdot
.34635 .34107 Mdot
.48204 .88042 Mdot
.60408 .29061 Mdot
.25743 .7236 Mdot
.59045 .87791 Mdot
.69639 .32976 Mdot
.69639 .32976 Mdot
.80645 .46454 Mdot
.48827 .27619 Mdot
.54886 .27418 Mdot
.80748 .70934 Mdot
.21797 .53405 Mdot
.38007 .85953 Mdot
.29657 .36521 Mdot
.68894 .85225 Mdot
.83498 .51608 Mdot
.27245 .7743 Mdot
.39366 .2926 Mdot
.74458 .35091 Mdot
.74458 .35091 Mdot
.64178 .28439 Mdot
.20432 .591 Mdot
.48966 .90102 Mdot
.79147 .7613 Mdot
.57876 .89899 Mdot
.47066 .26296 Mdot
.25622 .40126 Mdot
.56042 .25995 Mdot
.84891 .57285 Mdot
.40617 .88415 Mdot
.30092 .81752 Mdot
.65924 .8783 Mdot
.78375 .38473 Mdot
.78375 .38473 Mdot
.20645 .64963 Mdot
.35588 .30357 Mdot
.76117 .80633 Mdot
.67562 .29304 Mdot
.84673 .63223 Mdot
.22795 .44815 Mdot
.49959 .9065 Mdot
.56355 .90505 Mdot
.22515 .70698 Mdot
.34227 .8505 Mdot
.45474 .26544 Mdot
.81126 .43032 Mdot
.81126 .43032 Mdot
.43993 .89448 Mdot
.57087 .26155 Mdot
.71727 .84159 Mdot
.62092 .89032 Mdot
.32486 .32969 Mdot
.82765 .69119 Mdot
.21406 .50405 Mdot
.70346 .31738 Mdot
.2603 .75981 Mdot
.3951 .87074 Mdot
.8248 .48595 Mdot
.8248 .48595 Mdot
.66136 .86451 Mdot
.79182 .74637 Mdot
.5115 .89509 Mdot
.54533 .89431 Mdot
.48012 .8887 Mdot
.31073 .80486 Mdot
.21624 .56632 Mdot
.5754 .88651 Mdot
.44157 .28501 Mdot
.57953 .28043 Mdot
.30292 .37073 Mdot
.74057 .79432 Mdot
.45706 .87624 Mdot
.72319 .35735 Mdot
.82268 .54899 Mdot
.82268 .54899 Mdot
.59604 .87301 Mdot
.3741 .83906 Mdot
.23524 .63157 Mdot
.67642 .83183 Mdot
.44693 .85994 Mdot
.60302 .85626 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.52488 .86585 Mdot
.80417 .61594 Mdot
.80417 .61594 Mdot
.29207 .42535 Mdot
.27065 .69588 Mdot
.43219 .32208 Mdot
.58569 .31708 Mdot
.45217 .84287 Mdot
.73296 .41172 Mdot
.32076 .75506 Mdot
.59449 .83948 Mdot
.59449 .83948 Mdot
.76973 .68271 Mdot
.76973 .68271 Mdot
.3826 .80517 Mdot
.66141 .79834 Mdot
.66141 .79834 Mdot
.72114 .74491 Mdot
.72114 .74491 Mdot
.47222 .8285 Mdot
.57167 .82611 Mdot
.29377 .49096 Mdot
.50331 .81992 Mdot
.539 .81906 Mdot
.73143 .47791 Mdot
.42754 .37573 Mdot
.58875 .37062 Mdot
.42083 .77602 Mdot
.30859 .56376 Mdot
.61749 .77111 Mdot
.37431 .71143 Mdot
.336 .63899 Mdot
.71809 .55206 Mdot
.48202 .75835 Mdot
.6591 .70401 Mdot
.55296 .75656 Mdot
.69346 .62923 Mdot
.42827 .44347 Mdot
.58827 .43859 Mdot
.46252 .68459 Mdot
.43462 .52122 Mdot
.56576 .68186 Mdot
.5841 .51685 Mdot
.44631 .6036 Mdot
.57641 .59998 Mdot
.25 Mabswid
.6763 0 m
.92673 .40807 L
s
.92673 .40807 m
1 .94683 L
s
1 .94683 m
.71139 .59026 L
s
.71139 .59026 m
.6763 0 L
s
.08799 .24648 m
0 .80912 L
s
0 .80912 m
.71139 .59026 L
s
.71139 .59026 m
.6763 0 L
s
.6763 0 m
.08799 .24648 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.38.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.38.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["CylindricalPlot3D", "MR"],
 " and ",
 StyleBox["SphericalPlot3D", "MR"],
 " plot functions given in cylindrical and spherical coordinates, \
respectively. The names given to the variables in spherical coordinates vary \
in the literature. The convention used here is that the angle ",
 StyleBox["theta", "MR"],
 " is measured from the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis, and the angle ",
 StyleBox["phi", "MR"],
 " is measured in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " plane from the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis. "
}], "Text",
 CellTags->{"S5.38.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SphericalPlot3D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["phi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["phimin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["phimax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["generate a plot in three dimensions of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" as a function of the angles ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["phi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CylindricalPlot3D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["rmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" as a function of the radius ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the angle ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.38.1"],

Cell["Functions for plotting in three dimensions. ", "Caption",
 CellTags->"S5.38.1"],

Cell["\<\
Here is a sphere of radius 2. It is very simple to represent in spherical \
coordinates. \
\>", "MathCaption",
 CellTags->{"S5.38.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
SphericalPlot3D[ 2,
  {theta, 0, Pi}, {phi, 0, 2Pi}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.38.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08777 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0576738 1.16792 -2.79724e-17 1.16792 [
[.08885 .23035 -11.8346 -9 ]
[.08885 .23035 .16541 0 ]
[.21763 .17597 -11.3104 -9 ]
[.21763 .17597 .68962 0 ]
[.35353 .11861 -5.39309 -9 ]
[.35353 .11861 .60691 0 ]
[.49716 .05803 -5.13098 -9 ]
[.49716 .05803 .86902 0 ]
[.6492 -0.00605 -4.86888 -9 ]
[.6492 -0.00605 1.13112 0 ]
[.00886 .82785 -6.92493 0 ]
[.00886 .82785 5.07507 9 ]
[.12049 .90619 -6.70884 0 ]
[.12049 .90619 5.29116 9 ]
[.22061 .97645 -3.26163 0 ]
[.22061 .97645 2.73837 9 ]
[.3109 1.03981 -3.18107 0 ]
[.3109 1.03981 2.81893 9 ]
[.39276 1.09724 -3.11047 0 ]
[.39276 1.09724 2.88953 9 ]
[.07322 .26204 -12 -2.61848 ]
[.07322 .26204 0 6.38152 ]
[.05471 .37835 -12 -2.72137 ]
[.05471 .37835 0 6.27863 ]
[.03459 .50481 -6 -2.83416 ]
[.03459 .50481 0 6.16584 ]
[.01263 .64281 -6 -2.95834 ]
[.01263 .64281 0 6.04166 ]
[-0.01142 .794 -6 -3.09573 ]
[-0.01142 .794 0 5.90427 ]
[ 0 0 0 0 ]
[ 1 1.08777 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08845 .24527 m
.67201 0 L
s
.09903 .24082 m
.10412 .24605 L
s
[(-2)] .08885 .23035 .97243 1 Mshowa
.22731 .1869 m
.23214 .19237 L
s
[(-1)] .21763 .17597 .88506 1 Mshowa
.36263 .13003 m
.36719 .13573 L
s
[(0)] .35353 .11861 .7977 1 Mshowa
.50562 .06993 m
.50984 .07588 L
s
[(1)] .49716 .05803 .71033 1 Mshowa
.65692 .00634 m
.66078 .01254 L
s
[(2)] .6492 -0.00605 .62296 1 Mshowa
.125 Mabswid
.12415 .23026 m
.12717 .23343 L
s
.14953 .21959 m
.15253 .22279 L
s
.17518 .20881 m
.17815 .21204 L
s
.2011 .19792 m
.20404 .20117 L
s
.25379 .17577 m
.25666 .17908 L
s
.28056 .16452 m
.28339 .16786 L
s
.30762 .15315 m
.31042 .15652 L
s
.33498 .14165 m
.33774 .14505 L
s
.3906 .11827 m
.39329 .12173 L
s
.41887 .10639 m
.42153 .10987 L
s
.44746 .09437 m
.45008 .09789 L
s
.47638 .08222 m
.47895 .08576 L
s
.53519 .0575 m
.53768 .0611 L
s
.5651 .04493 m
.56755 .04856 L
s
.59535 .03222 m
.59776 .03588 L
s
.62596 .01935 m
.62832 .02304 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-2)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-1)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(1)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(2)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
.08669 .25641 m
.09342 .25359 L
s
[(-2)] .07322 .26204 1 -0.41811 Mshowa
.06829 .37298 m
.07508 .3703 L
s
[(-1)] .05471 .37835 1 -0.39525 Mshowa
.04828 .49974 m
.05513 .4972 L
s
[(0)] .03459 .50481 1 -0.37019 Mshowa
.02644 .63807 m
.03335 .63571 L
s
[(1)] .01263 .64281 1 -0.34259 Mshowa
.00252 .78966 m
.00949 .78748 L
s
[(2)] -0.01142 .794 1 -0.31206 Mshowa
.125 Mabswid
.08313 .27897 m
.08717 .27729 L
s
.07951 .3019 m
.08356 .30024 L
s
.07583 .3252 m
.07989 .32356 L
s
.07209 .34889 m
.07616 .34727 L
s
.06442 .39748 m
.0685 .39588 L
s
.06049 .42239 m
.06458 .42081 L
s
.05649 .44773 m
.06058 .44617 L
s
.05242 .47351 m
.05652 .47197 L
s
.04407 .52643 m
.04818 .52493 L
s
.03978 .5536 m
.0439 .55211 L
s
.03541 .58125 m
.03954 .57979 L
s
.03097 .60941 m
.03511 .60796 L
s
.02184 .66727 m
.02599 .66588 L
s
.01714 .69701 m
.0213 .69564 L
s
.01236 .72731 m
.01652 .72596 L
s
.00749 .75819 m
.01166 .75686 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
.41815 .58175 m
.08845 .24527 L
s
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.41815 .58175 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
0 0 m
1 0 L
1 1.08777 L
0 1.08777 L
closepath
clip
newpath
.5 Mabswid
.737 .605 .711 r
.45864 .55763 m .45288 .58767 L .50244 .59379 L p F P
0 g
s
.737 .605 .711 r
.50244 .59379 m .50427 .56337 L .45864 .55763 L p F P
0 g
s
.739 .591 .691 r
.50085 .62415 m .50244 .59379 L .45288 .58767 L p F P
0 g
s
.706 .578 .71 r
.50427 .56337 m .50244 .59379 L .55282 .59353 L p F P
0 g
s
.705 .562 .69 r
.50244 .59379 m .50085 .62415 L .55469 .62387 L p F P
0 g
s
.705 .562 .69 r
.55469 .62387 m .55282 .59353 L .50244 .59379 L p F P
0 g
s
.706 .578 .71 r
.55282 .59353 m .55067 .56312 L .50427 .56337 L p F P
0 g
s
.673 .554 .711 r
.55067 .56312 m .55282 .59353 L .60223 .58688 L p F P
0 g
s
.67 .535 .691 r
.55282 .59353 m .55469 .62387 L .60753 .61689 L p F P
0 g
s
.67 .535 .691 r
.60753 .61689 m .60223 .58688 L .55282 .59353 L p F P
0 g
s
.734 .619 .731 r
.4651 .52783 m .45864 .55763 L .50427 .56337 L p F P
0 g
s
.734 .619 .731 r
.50427 .56337 m .50632 .53311 L .4651 .52783 L p F P
0 g
s
.706 .595 .729 r
.50632 .53311 m .50427 .56337 L .55067 .56312 L p F P
0 g
s
.706 .595 .729 r
.55067 .56312 m .54825 .53288 L .50632 .53311 L p F P
0 g
s
.676 .572 .731 r
.54825 .53288 m .55067 .56312 L .59615 .55689 L p F P
0 g
s
.673 .554 .711 r
.60223 .58688 m .59615 .55689 L .55067 .56312 L p F P
0 g
s
.739 .591 .691 r
.45288 .58767 m .44786 .61772 L .50085 .62415 L p F P
0 g
s
.741 .576 .67 r
.49951 .65421 m .50085 .62415 L .44786 .61772 L p F P
0 g
s
.705 .545 .669 r
.50085 .62415 m .49951 .65421 L .55627 .65392 L p F P
0 g
s
.705 .545 .669 r
.55627 .65392 m .55469 .62387 L .50085 .62415 L p F P
0 g
s
.667 .516 .67 r
.55469 .62387 m .55627 .65392 L .61199 .6467 L p F P
0 g
s
.667 .516 .67 r
.61199 .6467 m .60753 .61689 L .55469 .62387 L p F P
0 g
s
.731 .633 .75 r
.47221 .49849 m .4651 .52783 L .50632 .53311 L p F P
0 g
s
.731 .633 .75 r
.50632 .53311 m .50857 .50323 L .47221 .49849 L p F P
0 g
s
.705 .61 .749 r
.50857 .50323 m .50632 .53311 L .54825 .53288 L p F P
0 g
s
.705 .61 .749 r
.54825 .53288 m .54559 .50303 L .50857 .50323 L p F P
0 g
s
.678 .59 .75 r
.54559 .50303 m .54825 .53288 L .58933 .52715 L p F P
0 g
s
.676 .572 .731 r
.59615 .55689 m .58933 .52715 L .54825 .53288 L p F P
0 g
s
.762 .647 .735 r
.42615 .51718 m .41546 .54604 L .45864 .55763 L p F P
0 g
s
.762 .647 .735 r
.45864 .55763 m .4651 .52783 L .42615 .51718 L p F P
0 g
s
.767 .635 .715 r
.45288 .58767 m .45864 .55763 L .41546 .54604 L p F P
0 g
s
.767 .635 .715 r
.41546 .54604 m .40592 .5753 L .45288 .58767 L p F P
0 g
s
.772 .623 .694 r
.44786 .61772 m .45288 .58767 L .40592 .5753 L p F P
0 g
s
.741 .576 .67 r
.44786 .61772 m .44362 .64756 L .49951 .65421 L p F P
0 g
s
.742 .559 .647 r
.49843 .68375 m .49951 .65421 L .44362 .64756 L p F P
0 g
s
.703 .527 .647 r
.49951 .65421 m .49843 .68375 L .55754 .68346 L p F P
0 g
s
.703 .527 .647 r
.55754 .68346 m .55627 .65392 L .49951 .65421 L p F P
0 g
s
.644 .551 .736 r
.58933 .52715 m .59615 .55689 L .63904 .54483 L p F P
0 g
s
.638 .53 .716 r
.59615 .55689 m .60223 .58688 L .64889 .57401 L p F P
0 g
s
.638 .53 .716 r
.64889 .57401 m .63904 .54483 L .59615 .55689 L p F P
0 g
s
.663 .495 .647 r
.55627 .65392 m .55754 .68346 L .61559 .67607 L p F P
0 g
s
.663 .495 .647 r
.61559 .67607 m .61199 .6467 L .55627 .65392 L p F P
0 g
s
.632 .509 .695 r
.60223 .58688 m .60753 .61689 L .65748 .60337 L p F P
0 g
s
.632 .509 .695 r
.65748 .60337 m .64889 .57401 L .60223 .58688 L p F P
0 g
s
.755 .659 .755 r
.43791 .48894 m .42615 .51718 L .4651 .52783 L p F P
0 g
s
.755 .659 .755 r
.4651 .52783 m .47221 .49849 L .43791 .48894 L p F P
0 g
s
.726 .647 .77 r
.47992 .46984 m .47221 .49849 L .50857 .50323 L p F P
0 g
s
.726 .647 .77 r
.50857 .50323 m .51102 .47397 L .47992 .46984 L p F P
0 g
s
.703 .626 .768 r
.51102 .47397 m .50857 .50323 L .54559 .50303 L p F P
0 g
s
.703 .626 .768 r
.54559 .50303 m .54269 .47379 L .51102 .47397 L p F P
0 g
s
.679 .609 .77 r
.54269 .47379 m .54559 .50303 L .58183 .49788 L p F P
0 g
s
.678 .59 .75 r
.58933 .52715 m .58183 .49788 L .54559 .50303 L p F P
0 g
s
.772 .623 .694 r
.40592 .5753 m .39759 .60473 L .44786 .61772 L p F P
0 g
s
.776 .609 .673 r
.44362 .64756 m .44786 .61772 L .39759 .60473 L p F P
0 g
s
.649 .572 .755 r
.58183 .49788 m .58933 .52715 L .62801 .51607 L p F P
0 g
s
.644 .551 .736 r
.63904 .54483 m .62801 .51607 L .58933 .52715 L p F P
0 g
s
.625 .487 .673 r
.60753 .61689 m .61199 .6467 L .66473 .63269 L p F P
0 g
s
.625 .487 .673 r
.66473 .63269 m .65748 .60337 L .60753 .61689 L p F P
0 g
s
.748 .67 .774 r
.45064 .46155 m .43791 .48894 L .47221 .49849 L p F P
0 g
s
.748 .67 .774 r
.47221 .49849 m .47992 .46984 L .45064 .46155 L p F P
0 g
s
.679 .609 .77 r
.58183 .49788 m .57369 .46931 L .54269 .47379 L p F P
0 g
s
.654 .593 .775 r
.57369 .46931 m .58183 .49788 L .61589 .48795 L p F P
0 g
s
.649 .572 .755 r
.62801 .51607 m .61589 .48795 L .58183 .49788 L p F P
0 g
s
.742 .559 .647 r
.44362 .64756 m .44021 .67695 L .49843 .68375 L p F P
0 g
s
.742 .542 .623 r
.49761 .71254 m .49843 .68375 L .44021 .67695 L p F P
0 g
s
.701 .507 .623 r
.49843 .68375 m .49761 .71254 L .55849 .71224 L p F P
0 g
s
.701 .507 .623 r
.55849 .71224 m .55754 .68346 L .49843 .68375 L p F P
0 g
s
.776 .609 .673 r
.39759 .60473 m .39056 .6341 L .44362 .64756 L p F P
0 g
s
.78 .595 .649 r
.44021 .67695 m .44362 .64756 L .39056 .6341 L p F P
0 g
s
.658 .473 .623 r
.55754 .68346 m .55849 .71224 L .61828 .70477 L p F P
0 g
s
.658 .473 .623 r
.61828 .70477 m .61559 .67607 L .55754 .68346 L p F P
0 g
s
.618 .463 .65 r
.61199 .6467 m .61559 .67607 L .67058 .66174 L p F P
0 g
s
.618 .463 .65 r
.67058 .66174 m .66473 .63269 L .61199 .6467 L p F P
0 g
s
.721 .661 .789 r
.48818 .44212 m .47992 .46984 L .51102 .47397 L p F P
0 g
s
.721 .661 .789 r
.51102 .47397 m .51364 .44555 L .48818 .44212 L p F P
0 g
s
.701 .643 .788 r
.51364 .44555 m .51102 .47397 L .54269 .47379 L p F P
0 g
s
.701 .643 .788 r
.54269 .47379 m .53959 .4454 L .51364 .44555 L p F P
0 g
s
.68 .628 .79 r
.53959 .4454 m .54269 .47379 L .57369 .46931 L p F P
0 g
s
.789 .679 .743 r
.39102 .50148 m .37641 .52893 L .41546 .54604 L p F P
0 g
s
.789 .679 .743 r
.41546 .54604 m .42615 .51718 L .39102 .50148 L p F P
0 g
s
.797 .669 .722 r
.40592 .5753 m .41546 .54604 L .37641 .52893 L p F P
0 g
s
.779 .687 .762 r
.40706 .47489 m .39102 .50148 L .42615 .51718 L p F P
0 g
s
.779 .687 .762 r
.42615 .51718 m .43791 .48894 L .40706 .47489 L p F P
0 g
s
.797 .669 .722 r
.37641 .52893 m .36334 .557 L .40592 .5753 L p F P
0 g
s
.805 .659 .701 r
.39759 .60473 m .40592 .5753 L .36334 .557 L p F P
0 g
s
.609 .532 .743 r
.62801 .51607 m .63904 .54483 L .67766 .52728 L p F P
0 g
s
.599 .508 .723 r
.63904 .54483 m .64889 .57401 L .69101 .55524 L p F P
0 g
s
.599 .508 .723 r
.69101 .55524 m .67766 .52728 L .63904 .54483 L p F P
0 g
s
.618 .556 .763 r
.61589 .48795 m .62801 .51607 L .66275 .49998 L p F P
0 g
s
.609 .532 .743 r
.67766 .52728 m .66275 .49998 L .62801 .51607 L p F P
0 g
s
.739 .681 .794 r
.46425 .43523 m .45064 .46155 L .47992 .46984 L p F P
0 g
s
.739 .681 .794 r
.47992 .46984 m .48818 .44212 L .46425 .43523 L p F P
0 g
s
.589 .483 .701 r
.64889 .57401 m .65748 .60337 L .70267 .58364 L p F P
0 g
s
.589 .483 .701 r
.70267 .58364 m .69101 .55524 L .64889 .57401 L p F P
0 g
s
.68 .628 .79 r
.57369 .46931 m .56496 .44168 L .53959 .4454 L p F P
0 g
s
.658 .615 .794 r
.56496 .44168 m .57369 .46931 L .60276 .46069 L p F P
0 g
s
.654 .593 .775 r
.61589 .48795 m .60276 .46069 L .57369 .46931 L p F P
0 g
s
.78 .595 .649 r
.39056 .6341 m .38488 .66318 L .44021 .67695 L p F P
0 g
s
.782 .578 .624 r
.43765 .70566 m .44021 .67695 L .38488 .66318 L p F P
0 g
s
.742 .542 .623 r
.44021 .67695 m .43765 .70566 L .49761 .71254 L p F P
0 g
s
.61 .438 .624 r
.61559 .67607 m .61828 .70477 L .67495 .69028 L p F P
0 g
s
.61 .438 .624 r
.67495 .69028 m .67058 .66174 L .61559 .67607 L p F P
0 g
s
.769 .696 .782 r
.42438 .44937 m .40706 .47489 L .43791 .48894 L p F P
0 g
s
.769 .696 .782 r
.43791 .48894 m .45064 .46155 L .42438 .44937 L p F P
0 g
s
.805 .659 .701 r
.36334 .557 m .35192 .58549 L .39759 .60473 L p F P
0 g
s
.812 .647 .678 r
.39056 .6341 m .39759 .60473 L .35192 .58549 L p F P
0 g
s
.741 .522 .596 r
.49708 .74033 m .49761 .71254 L .43765 .70566 L p F P
0 g
s
.698 .486 .597 r
.49761 .71254 m .49708 .74033 L .55911 .74004 L p F P
0 g
s
.698 .486 .597 r
.55911 .74004 m .55849 .71224 L .49761 .71254 L p F P
0 g
s
.626 .58 .783 r
.60276 .46069 m .61589 .48795 L .64638 .47354 L p F P
0 g
s
.618 .556 .763 r
.66275 .49998 m .64638 .47354 L .61589 .48795 L p F P
0 g
s
.652 .449 .596 r
.55849 .71224 m .55911 .74004 L .62003 .73256 L p F P
0 g
s
.652 .449 .596 r
.62003 .73256 m .61828 .70477 L .55849 .71224 L p F P
0 g
s
.578 .457 .678 r
.65748 .60337 m .66473 .63269 L .71253 .61223 L p F P
0 g
s
.578 .457 .678 r
.71253 .61223 m .70267 .58364 L .65748 .60337 L p F P
0 g
s
.714 .675 .81 r
.49693 .41555 m .48818 .44212 L .51364 .44555 L p F P
0 g
s
.714 .675 .81 r
.51364 .44555 m .51642 .41822 L .49693 .41555 L p F P
0 g
s
.698 .66 .809 r
.51642 .41822 m .51364 .44555 L .53959 .4454 L p F P
0 g
s
.698 .66 .809 r
.53959 .4454 m .5363 .4181 L .51642 .41822 L p F P
0 g
s
.68 .647 .81 r
.5363 .4181 m .53959 .4454 L .56496 .44168 L p F P
0 g
s
.757 .703 .801 r
.44288 .42513 m .42438 .44937 L .45064 .46155 L p F P
0 g
s
.757 .703 .801 r
.45064 .46155 m .46425 .43523 L .44288 .42513 L p F P
0 g
s
.812 .647 .678 r
.35192 .58549 m .34225 .61415 L .39056 .6341 L p F P
0 g
s
.819 .634 .653 r
.38488 .66318 m .39056 .6341 L .34225 .61415 L p F P
0 g
s
.658 .615 .794 r
.60276 .46069 m .58871 .43451 L .56496 .44168 L p F P
0 g
s
.635 .604 .802 r
.58871 .43451 m .60276 .46069 L .62869 .4482 L p F P
0 g
s
.626 .58 .783 r
.64638 .47354 m .62869 .4482 L .60276 .46069 L p F P
0 g
s
.729 .691 .814 r
.47866 .4102 m .46425 .43523 L .48818 .44212 L p F P
0 g
s
.729 .691 .814 r
.48818 .44212 m .49693 .41555 L .47866 .4102 L p F P
0 g
s
.566 .429 .653 r
.66473 .63269 m .67058 .66174 L .72049 .64079 L p F P
0 g
s
.566 .429 .653 r
.72049 .64079 m .71253 .61223 L .66473 .63269 L p F P
0 g
s
.68 .647 .81 r
.56496 .44168 m .55572 .41521 L .5363 .4181 L p F P
0 g
s
.662 .637 .814 r
.55572 .41521 m .56496 .44168 L .58871 .43451 L p F P
0 g
s
.782 .578 .624 r
.38488 .66318 m .38063 .69174 L .43765 .70566 L p F P
0 g
s
.784 .56 .596 r
.43599 .73345 m .43765 .70566 L .38063 .69174 L p F P
0 g
s
.741 .522 .596 r
.43765 .70566 m .43599 .73345 L .49708 .74033 L p F P
0 g
s
.6 .41 .596 r
.61828 .70477 m .62003 .73256 L .67779 .71806 L p F P
0 g
s
.6 .41 .596 r
.67779 .71806 m .67495 .69028 L .61828 .70477 L p F P
0 g
s
.802 .72 .774 r
.38099 .4568 m .3612 .48122 L .39102 .50148 L p F P
0 g
s
.802 .72 .774 r
.39102 .50148 m .40706 .47489 L .38099 .4568 L p F P
0 g
s
.815 .715 .754 r
.37641 .52893 m .39102 .50148 L .3612 .48122 L p F P
0 g
s
.74 .5 .566 r
.49685 .76689 m .49708 .74033 L .43599 .73345 L p F P
0 g
s
.693 .461 .567 r
.49708 .74033 m .49685 .76689 L .55937 .7666 L p F P
0 g
s
.693 .461 .567 r
.55937 .7666 m .55911 .74004 L .49708 .74033 L p F P
0 g
s
.815 .715 .754 r
.3612 .48122 m .34312 .50679 L .37641 .52893 L p F P
0 g
s
.828 .708 .733 r
.36334 .557 m .37641 .52893 L .34312 .50679 L p F P
0 g
s
.644 .422 .566 r
.55911 .74004 m .55937 .7666 L .62079 .7592 L p F P
0 g
s
.644 .422 .566 r
.62079 .7592 m .62003 .73256 L .55911 .74004 L p F P
0 g
s
.583 .543 .775 r
.64638 .47354 m .66275 .49998 L .69205 .47936 L p F P
0 g
s
.569 .515 .755 r
.66275 .49998 m .67766 .52728 L .71039 .50475 L p F P
0 g
s
.569 .515 .755 r
.71039 .50475 m .69205 .47936 L .66275 .49998 L p F P
0 g
s
.743 .71 .82 r
.46239 .40238 m .44288 .42513 L .46425 .43523 L p F P
0 g
s
.743 .71 .82 r
.46425 .43523 m .47866 .4102 L .46239 .40238 L p F P
0 g
s
.788 .725 .793 r
.40231 .43372 m .38099 .4568 L .40706 .47489 L p F P
0 g
s
.788 .725 .793 r
.40706 .47489 m .42438 .44937 L .40231 .43372 L p F P
0 g
s
.819 .634 .653 r
.34225 .61415 m .33445 .64276 L .38488 .66318 L p F P
0 g
s
.824 .619 .625 r
.38063 .69174 m .38488 .66318 L .33445 .64276 L p F P
0 g
s
.554 .486 .734 r
.67766 .52728 m .69101 .55524 L .72684 .53111 L p F P
0 g
s
.554 .486 .734 r
.72684 .53111 m .71039 .50475 L .67766 .52728 L p F P
0 g
s
.662 .637 .814 r
.58871 .43451 m .57385 .40965 L .55572 .41521 L p F P
0 g
s
.643 .629 .821 r
.57385 .40965 m .58871 .43451 L .60982 .42416 L p F P
0 g
s
.635 .604 .802 r
.62869 .4482 m .60982 .42416 L .58871 .43451 L p F P
0 g
s
.597 .57 .794 r
.62869 .4482 m .64638 .47354 L .67198 .45514 L p F P
0 g
s
.583 .543 .775 r
.69205 .47936 m .67198 .45514 L .64638 .47354 L p F P
0 g
s
.553 .399 .625 r
.67058 .66174 m .67495 .69028 L .72646 .66907 L p F P
0 g
s
.553 .399 .625 r
.72646 .66907 m .72049 .64079 L .67058 .66174 L p F P
0 g
s
.828 .708 .733 r
.34312 .50679 m .32691 .53329 L .36334 .557 L p F P
0 g
s
.839 .7 .71 r
.35192 .58549 m .36334 .557 L .32691 .53329 L p F P
0 g
s
.706 .689 .831 r
.50612 .39038 m .49693 .41555 L .51642 .41822 L p F P
0 g
s
.706 .689 .831 r
.51642 .41822 m .51934 .39222 L .50612 .39038 L p F P
0 g
s
.693 .678 .83 r
.51934 .39222 m .51642 .41822 L .5363 .4181 L p F P
0 g
s
.693 .678 .83 r
.5363 .4181 m .53284 .39214 L .51934 .39222 L p F P
0 g
s
.68 .668 .832 r
.53284 .39214 m .5363 .4181 L .55572 .41521 L p F P
0 g
s
.539 .457 .711 r
.69101 .55524 m .70267 .58364 L .74124 .55821 L p F P
0 g
s
.539 .457 .711 r
.74124 .55821 m .72684 .53111 L .69101 .55524 L p F P
0 g
s
.772 .728 .811 r
.425 .41219 m .40231 .43372 L .42438 .44937 L p F P
0 g
s
.772 .728 .811 r
.42438 .44937 m .44288 .42513 L .425 .41219 L p F P
0 g
s
.61 .597 .813 r
.60982 .42416 m .62869 .4482 L .65036 .43229 L p F P
0 g
s
.597 .57 .794 r
.67198 .45514 m .65036 .43229 L .62869 .4482 L p F P
0 g
s
.717 .702 .835 r
.49375 .38671 m .47866 .4102 L .49693 .41555 L p F P
0 g
s
.717 .702 .835 r
.49693 .41555 m .50612 .39038 L .49375 .38671 L p F P
0 g
s
.68 .668 .832 r
.55572 .41521 m .54601 .39015 L .53284 .39214 L p F P
0 g
s
.666 .661 .835 r
.54601 .39015 m .55572 .41521 L .57385 .40965 L p F P
0 g
s
.839 .7 .71 r
.32691 .53329 m .31271 .5605 L .35192 .58549 L p F P
0 g
s
.85 .691 .685 r
.34225 .61415 m .35192 .58549 L .31271 .5605 L p F P
0 g
s
.784 .56 .596 r
.38063 .69174 m .37787 .71952 L .43599 .73345 L p F P
0 g
s
.785 .539 .564 r
.43525 .76008 m .43599 .73345 L .37787 .71952 L p F P
0 g
s
.74 .5 .566 r
.43599 .73345 m .43525 .76008 L .49685 .76689 L p F P
0 g
s
.588 .378 .564 r
.62003 .73256 m .62079 .7592 L .67904 .74483 L p F P
0 g
s
.588 .378 .564 r
.67904 .74483 m .67779 .71806 L .62003 .73256 L p F P
0 g
s
.522 .425 .686 r
.70267 .58364 m .71253 .61223 L .75344 .58582 L p F P
0 g
s
.522 .425 .686 r
.75344 .58582 m .74124 .55821 L .70267 .58364 L p F P
0 g
s
.755 .73 .83 r
.44886 .39239 m .425 .41219 L .44288 .42513 L p F P
0 g
s
.755 .73 .83 r
.44288 .42513 m .46239 .40238 L .44886 .39239 L p F P
0 g
s
.727 .716 .84 r
.48278 .38134 m .46239 .40238 L .47866 .4102 L p F P
0 g
s
.727 .716 .84 r
.47866 .4102 m .49375 .38671 L .48278 .38134 L p F P
0 g
s
.824 .619 .625 r
.33445 .64276 m .32861 .67106 L .38063 .69174 L p F P
0 g
s
.829 .602 .594 r
.37787 .71952 m .38063 .69174 L .32861 .67106 L p F P
0 g
s
.643 .629 .821 r
.60982 .42416 m .58991 .40164 L .57385 .40965 L p F P
0 g
s
.624 .624 .83 r
.58991 .40164 m .60982 .42416 L .62736 .41101 L p F P
0 g
s
.61 .597 .813 r
.65036 .43229 m .62736 .41101 L .60982 .42416 L p F P
0 g
s
.666 .661 .835 r
.57385 .40965 m .55829 .38633 L .54601 .39015 L p F P
0 g
s
.652 .655 .84 r
.55829 .38633 m .57385 .40965 L .58991 .40164 L p F P
0 g
s
.538 .365 .594 r
.67495 .69028 m .67779 .71806 L .73033 .69683 L p F P
0 g
s
.538 .365 .594 r
.73033 .69683 m .72646 .66907 L .67495 .69028 L p F P
0 g
s
.736 .474 .532 r
.49691 .79197 m .49685 .76689 L .43525 .76008 L p F P
0 g
s
.688 .434 .533 r
.49685 .76689 m .49691 .79197 L .55928 .79168 L p F P
0 g
s
.688 .434 .533 r
.55928 .79168 m .55937 .7666 L .49685 .76689 L p F P
0 g
s
.635 .391 .531 r
.55937 .7666 m .55928 .79168 L .62055 .78442 L p F P
0 g
s
.635 .391 .531 r
.62055 .78442 m .62079 .7592 L .55937 .7666 L p F P
0 g
s
.85 .691 .685 r
.31271 .5605 m .30068 .58821 L .34225 .61415 L p F P
0 g
s
.86 .68 .658 r
.33445 .64276 m .34225 .61415 L .30068 .58821 L p F P
0 g
s
.503 .39 .658 r
.71253 .61223 m .72049 .64079 L .7633 .61371 L p F P
0 g
s
.503 .39 .658 r
.7633 .61371 m .75344 .58582 L .71253 .61223 L p F P
0 g
s
.695 .704 .854 r
.51567 .36686 m .50612 .39038 L .51934 .39222 L p F P
0 g
s
.695 .704 .854 r
.51934 .39222 m .52239 .3678 L .51567 .36686 L p F P
0 g
s
.687 .697 .854 r
.52239 .3678 m .51934 .39222 L .53284 .39214 L p F P
0 g
s
.687 .697 .854 r
.53284 .39214 m .52924 .36776 L .52239 .3678 L p F P
0 g
s
.678 .69 .854 r
.52924 .36776 m .53284 .39214 L .54601 .39015 L p F P
0 g
s
.735 .731 .847 r
.47371 .37452 m .44886 .39239 L .46239 .40238 L p F P
0 g
s
.735 .731 .847 r
.46239 .40238 m .48278 .38134 L .47371 .37452 L p F P
0 g
s
.805 .757 .808 r
.38547 .41519 m .36094 .43529 L .38099 .4568 L p F P
0 g
s
.805 .757 .808 r
.38099 .4568 m .40231 .43372 L .38547 .41519 L p F P
0 g
s
.824 .757 .79 r
.3612 .48122 m .38099 .4568 L .36094 .43529 L p F P
0 g
s
.652 .655 .84 r
.58991 .40164 m .56911 .38083 L .55829 .38633 L p F P
0 g
s
.637 .652 .848 r
.56911 .38083 m .58991 .40164 L .60318 .39149 L p F P
0 g
s
.624 .624 .83 r
.62736 .41101 m .60318 .39149 L .58991 .40164 L p F P
0 g
s
.824 .757 .79 r
.36094 .43529 m .3381 .45706 L .3612 .48122 L p F P
0 g
s
.841 .756 .769 r
.34312 .50679 m .3612 .48122 L .3381 .45706 L p F P
0 g
s
.786 .755 .825 r
.41147 .39692 m .38547 .41519 L .40231 .43372 L p F P
0 g
s
.786 .755 .825 r
.40231 .43372 m .425 .41219 L .41147 .39692 L p F P
0 g
s
.702 .712 .856 r
.50941 .36497 m .49375 .38671 L .50612 .39038 L p F P
0 g
s
.702 .712 .856 r
.50612 .39038 m .51567 .36686 L .50941 .36497 L p F P
0 g
s
.678 .69 .854 r
.54601 .39015 m .53592 .36673 L .52924 .36776 L p F P
0 g
s
.669 .686 .857 r
.53592 .36673 m .54601 .39015 L .55829 .38633 L p F P
0 g
s
.565 .562 .81 r
.65036 .43229 m .67198 .45514 L .69147 .43339 L p F P
0 g
s
.544 .531 .791 r
.67198 .45514 m .69205 .47936 L .71452 .45492 L p F P
0 g
s
.544 .531 .791 r
.71452 .45492 m .69147 .43339 L .67198 .45514 L p F P
0 g
s
.584 .592 .827 r
.62736 .41101 m .65036 .43229 L .66672 .41355 L p F P
0 g
s
.565 .562 .81 r
.69147 .43339 m .66672 .41355 L .65036 .43229 L p F P
0 g
s
.523 .499 .771 r
.69205 .47936 m .71039 .50475 L .73565 .47797 L p F P
0 g
s
.523 .499 .771 r
.73565 .47797 m .71452 .45492 L .69205 .47936 L p F P
0 g
s
.785 .539 .564 r
.37787 .71952 m .37665 .74627 L .43525 .76008 L p F P
0 g
s
.784 .514 .527 r
.43547 .78528 m .43525 .76008 L .37665 .74627 L p F P
0 g
s
.736 .474 .532 r
.43525 .76008 m .43547 .78528 L .49691 .79197 L p F P
0 g
s
.841 .756 .769 r
.3381 .45706 m .31717 .48032 L .34312 .50679 L p F P
0 g
s
.858 .754 .747 r
.32691 .53329 m .34312 .50679 L .31717 .48032 L p F P
0 g
s
.764 .752 .842 r
.43871 .38065 m .41147 .39692 L .425 .41219 L p F P
0 g
s
.764 .752 .842 r
.425 .41219 m .44886 .39239 L .43871 .38065 L p F P
0 g
s
.575 .342 .526 r
.62079 .7592 m .62055 .78442 L .67865 .77033 L p F P
0 g
s
.575 .342 .526 r
.67865 .77033 m .67904 .74483 L .62079 .7592 L p F P
0 g
s
.86 .68 .658 r
.30068 .58821 m .29095 .61616 L .33445 .64276 L p F P
0 g
s
.869 .666 .626 r
.32861 .67106 m .33445 .64276 L .29095 .61616 L p F P
0 g
s
.708 .722 .86 r
.50388 .36222 m .48278 .38134 L .49375 .38671 L p F P
0 g
s
.708 .722 .86 r
.49375 .38671 m .50941 .36497 L .50388 .36222 L p F P
0 g
s
.829 .602 .594 r
.32861 .67106 m .3248 .69882 L .37787 .71952 L p F P
0 g
s
.832 .581 .559 r
.37665 .74627 m .37787 .71952 L .3248 .69882 L p F P
0 g
s
.669 .686 .857 r
.55829 .38633 m .54213 .36477 L .53592 .36673 L p F P
0 g
s
.66 .683 .86 r
.54213 .36477 m .55829 .38633 L .56911 .38083 L p F P
0 g
s
.604 .622 .843 r
.60318 .39149 m .62736 .41101 L .64049 .39557 L p F P
0 g
s
.584 .592 .827 r
.66672 .41355 m .64049 .39557 L .62736 .41101 L p F P
0 g
s
.501 .465 .749 r
.71039 .50475 m .72684 .53111 L .75466 .50234 L p F P
0 g
s
.501 .465 .749 r
.75466 .50234 m .73565 .47797 L .71039 .50475 L p F P
0 g
s
.521 .327 .558 r
.67779 .71806 m .67904 .74483 L .73204 .72379 L p F P
0 g
s
.521 .327 .558 r
.73204 .72379 m .73033 .69683 L .67779 .71806 L p F P
0 g
s
.483 .352 .626 r
.72049 .64079 m .72646 .66907 L .7707 .64164 L p F P
0 g
s
.483 .352 .626 r
.7707 .64164 m .7633 .61371 L .72049 .64079 L p F P
0 g
s
.858 .754 .747 r
.31717 .48032 m .29834 .50487 L .32691 .53329 L p F P
0 g
s
.874 .75 .723 r
.31271 .5605 m .32691 .53329 L .29834 .50487 L p F P
0 g
s
.742 .748 .857 r
.46697 .36652 m .43871 .38065 L .44886 .39239 L p F P
0 g
s
.742 .748 .857 r
.44886 .39239 m .47371 .37452 L .46697 .36652 L p F P
0 g
s
.713 .731 .865 r
.49933 .35873 m .47371 .37452 L .48278 .38134 L p F P
0 g
s
.713 .731 .865 r
.48278 .38134 m .50388 .36222 L .49933 .35873 L p F P
0 g
s
.637 .652 .848 r
.60318 .39149 m .578 .3739 L .56911 .38083 L p F P
0 g
s
.623 .652 .858 r
.578 .3739 m .60318 .39149 L .61301 .37961 L p F P
0 g
s
.604 .622 .843 r
.64049 .39557 m .61301 .37961 L .60318 .39149 L p F P
0 g
s
.66 .683 .86 r
.56911 .38083 m .54759 .36196 L .54213 .36477 L p F P
0 g
s
.651 .681 .866 r
.54759 .36196 m .56911 .38083 L .578 .3739 L p F P
0 g
s
.477 .428 .724 r
.72684 .53111 m .74124 .55821 L .77134 .52783 L p F P
0 g
s
.477 .428 .724 r
.77134 .52783 m .75466 .50234 L .72684 .53111 L p F P
0 g
s
.731 .443 .491 r
.49728 .81531 m .49691 .79197 L .43547 .78528 L p F P
0 g
s
.679 .401 .493 r
.49691 .79197 m .49728 .81531 L .55883 .81503 L p F P
0 g
s
.679 .401 .493 r
.55883 .81503 m .55928 .79168 L .49691 .79197 L p F P
0 g
s
.623 .355 .49 r
.55928 .79168 m .55883 .81503 L .61927 .80798 L p F P
0 g
s
.623 .355 .49 r
.61927 .80798 m .62055 .78442 L .55928 .79168 L p F P
0 g
s
.874 .75 .723 r
.29834 .50487 m .28181 .5305 L .31271 .5605 L p F P
0 g
s
.889 .744 .695 r
.30068 .58821 m .31271 .5605 L .28181 .5305 L p F P
0 g
s
.869 .666 .626 r
.29095 .61616 m .28366 .64412 L .32861 .67106 L p F P
0 g
s
.877 .65 .591 r
.3248 .69882 m .32861 .67106 L .28366 .64412 L p F P
0 g
s
.716 .741 .871 r
.49599 .35466 m .46697 .36652 L .47371 .37452 L p F P
0 g
s
.716 .741 .871 r
.47371 .37452 m .49933 .35873 L .49599 .35466 L p F P
0 g
s
.681 .72 .879 r
.52239 .3678 m .52552 .34522 L .51567 .36686 L closepath p F P
0 g
s
.678 .717 .878 r
.52924 .36776 m .52552 .34522 L .52239 .3678 L closepath p F P
0 g
s
.675 .715 .879 r
.53592 .36673 m .52552 .34522 L .52924 .36776 L closepath p F P
0 g
s
.651 .681 .866 r
.578 .3739 m .55204 .35842 L .54759 .36196 L p F P
0 g
s
.642 .682 .872 r
.55204 .35842 m .578 .3739 L .58453 .36581 L p F P
0 g
s
.623 .652 .858 r
.61301 .37961 m .58453 .36581 L .578 .3739 L p F P
0 g
s
.45 .388 .696 r
.74124 .55821 m .75344 .58582 L .78551 .55421 L p F P
0 g
s
.45 .388 .696 r
.78551 .55421 m .77134 .52783 L .74124 .55821 L p F P
0 g
s
.684 .723 .879 r
.51567 .36686 m .52552 .34522 L .50941 .36497 L closepath p F P
0 g
s
.672 .713 .879 r
.54213 .36477 m .52552 .34522 L .53592 .36673 L closepath p F P
0 g
s
.459 .31 .59 r
.72646 .66907 m .73033 .69683 L .77552 .66935 L p F P
0 g
s
.459 .31 .59 r
.77552 .66935 m .7707 .64164 L .72646 .66907 L p F P
0 g
s
.771 .775 .856 r
.43247 .36763 m .40299 .37993 L .41147 .39692 L p F P
0 g
s
.771 .775 .856 r
.41147 .39692 m .43871 .38065 L .43247 .36763 L p F P
0 g
s
.795 .785 .843 r
.38547 .41519 m .41147 .39692 L .40299 .37993 L p F P
0 g
s
.795 .785 .843 r
.40299 .37993 m .37475 .39449 L .38547 .41519 L p F P
0 g
s
.819 .793 .828 r
.36094 .43529 m .38547 .41519 L .37475 .39449 L p F P
0 g
s
.686 .726 .881 r
.50941 .36497 m .52552 .34522 L .50388 .36222 L closepath p F P
0 g
s
.668 .712 .881 r
.54759 .36196 m .52552 .34522 L .54213 .36477 L closepath p F P
0 g
s
.832 .581 .559 r
.3248 .69882 m .32312 .72577 L .37665 .74627 L p F P
0 g
s
.834 .556 .517 r
.37701 .77175 m .37665 .74627 L .32312 .72577 L p F P
0 g
s
.784 .514 .527 r
.37665 .74627 m .37701 .77175 L .43547 .78528 L p F P
0 g
s
.782 .483 .483 r
.43667 .80881 m .43547 .78528 L .37701 .77175 L p F P
0 g
s
.731 .443 .491 r
.43547 .78528 m .43667 .80881 L .49728 .81531 L p F P
0 g
s
.583 .624 .858 r
.61301 .37961 m .64049 .39557 L .6485 .37848 L p F P
0 g
s
.557 .592 .845 r
.64049 .39557 m .66672 .41355 L .67688 .39272 L p F P
0 g
s
.557 .592 .845 r
.67688 .39272 m .6485 .37848 L .64049 .39557 L p F P
0 g
s
.745 .764 .868 r
.4629 .35769 m .43247 .36763 L .43871 .38065 L p F P
0 g
s
.745 .764 .868 r
.43871 .38065 m .46697 .36652 L .4629 .35769 L p F P
0 g
s
.529 .558 .829 r
.66672 .41355 m .69147 .43339 L .70377 .40912 L p F P
0 g
s
.529 .558 .829 r
.70377 .40912 m .67688 .39272 L .66672 .41355 L p F P
0 g
s
.557 .3 .482 r
.62055 .78442 m .61927 .80798 L .67657 .7943 L p F P
0 g
s
.557 .3 .482 r
.67657 .7943 m .67865 .77033 L .62055 .78442 L p F P
0 g
s
.819 .793 .828 r
.37475 .39449 m .34799 .41119 L .36094 .43529 L p F P
0 g
s
.842 .799 .81 r
.3381 .45706 m .36094 .43529 L .34799 .41119 L p F P
0 g
s
.5 .283 .516 r
.67904 .74483 m .67865 .77033 L .7315 .7497 L p F P
0 g
s
.5 .283 .516 r
.7315 .7497 m .73204 .72379 L .67904 .74483 L p F P
0 g
s
.609 .654 .869 r
.58453 .36581 m .61301 .37961 L .61891 .36652 L p F P
0 g
s
.583 .624 .858 r
.6485 .37848 m .61891 .36652 L .61301 .37961 L p F P
0 g
s
.687 .73 .883 r
.50388 .36222 m .52552 .34522 L .49933 .35873 L closepath p F P
0 g
s
.665 .712 .883 r
.55204 .35842 m .52552 .34522 L .54759 .36196 L closepath p F P
0 g
s
.5 .523 .812 r
.69147 .43339 m .71452 .45492 L .7289 .42756 L p F P
0 g
s
.5 .523 .812 r
.7289 .42756 m .70377 .40912 L .69147 .43339 L p F P
0 g
s
.889 .744 .695 r
.28181 .5305 m .26778 .55699 L .30068 .58821 L p F P
0 g
s
.903 .735 .663 r
.29095 .61616 m .30068 .58821 L .26778 .55699 L p F P
0 g
s
.717 .751 .879 r
.49401 .3502 m .4629 .35769 L .46697 .36652 L p F P
0 g
s
.717 .751 .879 r
.46697 .36652 m .49599 .35466 L .49401 .3502 L p F P
0 g
s
.642 .682 .872 r
.58453 .36581 m .55528 .35431 L .55204 .35842 L p F P
0 g
s
.635 .684 .879 r
.55528 .35431 m .58453 .36581 L .58836 .35694 L p F P
0 g
s
.609 .654 .869 r
.61891 .36652 m .58836 .35694 L .58453 .36581 L p F P
0 g
s
.842 .799 .81 r
.34799 .41119 m .32298 .4299 L .3381 .45706 L p F P
0 g
s
.864 .804 .79 r
.31717 .48032 m .3381 .45706 L .32298 .4299 L p F P
0 g
s
.688 .733 .885 r
.49933 .35873 m .52552 .34522 L .49599 .35466 L closepath p F P
0 g
s
.662 .712 .885 r
.55528 .35431 m .52552 .34522 L .55204 .35842 L closepath p F P
0 g
s
.421 .343 .663 r
.75344 .58582 m .7633 .61371 L .79699 .58126 L p F P
0 g
s
.421 .343 .663 r
.79699 .58126 m .78551 .55421 L .75344 .58582 L p F P
0 g
s
.468 .484 .792 r
.71452 .45492 m .73565 .47797 L .75203 .44788 L p F P
0 g
s
.468 .484 .792 r
.75203 .44788 m .7289 .42756 L .71452 .45492 L p F P
0 g
s
.877 .65 .591 r
.28366 .64412 m .2789 .67183 L .3248 .69882 L p F P
0 g
s
.883 .629 .549 r
.32312 .72577 m .3248 .69882 L .2789 .67183 L p F P
0 g
s
.688 .736 .888 r
.49599 .35466 m .52552 .34522 L .49401 .3502 L closepath p F P
0 g
s
.66 .713 .888 r
.55714 .34982 m .52552 .34522 L .55528 .35431 L closepath p F P
0 g
s
.635 .684 .879 r
.58836 .35694 m .55714 .34982 L .55528 .35431 L p F P
0 g
s
.864 .804 .79 r
.32298 .4299 m .29998 .45046 L .31717 .48032 L p F P
0 g
s
.886 .808 .767 r
.29834 .50487 m .31717 .48032 L .29998 .45046 L p F P
0 g
s
.723 .405 .441 r
.49797 .83664 m .49728 .81531 L .43667 .80881 L p F P
0 g
s
.668 .361 .445 r
.49728 .81531 m .49797 .83664 L .55799 .83637 L p F P
0 g
s
.668 .361 .445 r
.55799 .83637 m .55883 .81503 L .49728 .81531 L p F P
0 g
s
.607 .311 .44 r
.55883 .81503 m .55799 .83637 L .61693 .8296 L p F P
0 g
s
.607 .311 .44 r
.61693 .8296 m .61927 .80798 L .55883 .81503 L p F P
0 g
s
.432 .261 .547 r
.73033 .69683 m .73204 .72379 L .77764 .69656 L p F P
0 g
s
.432 .261 .547 r
.77764 .69656 m .77552 .66935 L .73033 .69683 L p F P
0 g
s
.716 .76 .887 r
.49349 .34553 m .46172 .34844 L .4629 .35769 L p F P
0 g
s
.716 .76 .887 r
.4629 .35769 m .49401 .3502 L .49349 .34553 L p F P
0 g
s
.745 .78 .881 r
.43247 .36763 m .4629 .35769 L .46172 .34844 L p F P
0 g
s
.434 .442 .768 r
.73565 .47797 m .75466 .50234 L .77289 .46993 L p F P
0 g
s
.434 .442 .768 r
.77289 .46993 m .75203 .44788 L .73565 .47797 L p F P
0 g
s
.745 .78 .881 r
.46172 .34844 m .43049 .35393 L .43247 .36763 L p F P
0 g
s
.772 .798 .874 r
.40299 .37993 m .43247 .36763 L .43049 .35393 L p F P
0 g
s
.628 .689 .887 r
.55714 .34982 m .58836 .35694 L .58929 .34767 L p F P
0 g
s
.596 .66 .883 r
.58836 .35694 m .61891 .36652 L .62051 .35279 L p F P
0 g
s
.596 .66 .883 r
.62051 .35279 m .58929 .34767 L .58836 .35694 L p F P
0 g
s
.687 .739 .89 r
.49401 .3502 m .52552 .34522 L .49349 .34553 L closepath p F P
0 g
s
.658 .715 .891 r
.55753 .34515 m .52552 .34522 L .55714 .34982 L closepath p F P
0 g
s
.628 .689 .887 r
.58929 .34767 m .55753 .34515 L .55714 .34982 L p F P
0 g
s
.903 .735 .663 r
.26778 .55699 m .25641 .58412 L .29095 .61616 L p F P
0 g
s
.917 .723 .626 r
.28366 .64412 m .29095 .61616 L .25641 .58412 L p F P
0 g
s
.563 .63 .875 r
.61891 .36652 m .6485 .37848 L .65091 .36046 L p F P
0 g
s
.563 .63 .875 r
.65091 .36046 m .62051 .35279 L .61891 .36652 L p F P
0 g
s
.772 .798 .874 r
.43049 .35393 m .4001 .36197 L .40299 .37993 L p F P
0 g
s
.8 .815 .864 r
.37475 .39449 m .40299 .37993 L .4001 .36197 L p F P
0 g
s
.656 .717 .893 r
.55642 .34052 m .52552 .34522 L .55753 .34515 L closepath p F P
0 g
s
.656 .724 .899 r
.54994 .33226 m .52552 .34522 L .55385 .33615 L closepath p F P
0 g
s
.657 .727 .901 r
.54486 .32902 m .52552 .34522 L .54994 .33226 L closepath p F P
0 g
s
.658 .731 .903 r
.53885 .32659 m .52552 .34522 L .54486 .32902 L closepath p F P
0 g
s
.661 .734 .904 r
.5322 .32511 m .52552 .34522 L .53885 .32659 L closepath p F P
0 g
s
.664 .738 .905 r
.52522 .32463 m .52552 .34522 L .5322 .32511 L closepath p F P
0 g
s
.667 .74 .905 r
.51826 .32519 m .52552 .34522 L .52522 .32463 L closepath p F P
0 g
s
.671 .742 .904 r
.51166 .32676 m .52552 .34522 L .51826 .32519 L closepath p F P
0 g
s
.674 .744 .903 r
.50572 .32925 m .52552 .34522 L .51166 .32676 L closepath p F P
0 g
s
.678 .744 .901 r
.50073 .33256 m .52552 .34522 L .50572 .32925 L closepath p F P
0 g
s
.681 .744 .899 r
.49692 .3365 m .52552 .34522 L .50073 .33256 L closepath p F P
0 g
s
.684 .743 .896 r
.49447 .3409 m .52552 .34522 L .49692 .3365 L closepath p F P
0 g
s
.686 .741 .893 r
.49349 .34553 m .52552 .34522 L .49447 .3409 L closepath p F P
0 g
s
.656 .72 .896 r
.55385 .33615 m .52552 .34522 L .55642 .34052 L closepath p F P
0 g
s
.834 .556 .517 r
.32312 .72577 m .32363 .75164 L .37701 .77175 L p F P
0 g
s
.834 .524 .466 r
.37901 .79568 m .37701 .77175 L .32363 .75164 L p F P
0 g
s
.782 .483 .483 r
.37701 .77175 m .37901 .79568 L .43667 .80881 L p F P
0 g
s
.388 .293 .626 r
.7633 .61371 m .7707 .64164 L .80561 .60873 L p F P
0 g
s
.388 .293 .626 r
.80561 .60873 m .79699 .58126 L .7633 .61371 L p F P
0 g
s
.528 .596 .866 r
.6485 .37848 m .67688 .39272 L .68018 .37066 L p F P
0 g
s
.528 .596 .866 r
.68018 .37066 m .65091 .36046 L .6485 .37848 L p F P
0 g
s
.886 .808 .767 r
.29998 .45046 m .27923 .47271 L .29834 .50487 L p F P
0 g
s
.907 .809 .739 r
.28181 .5305 m .29834 .50487 L .27923 .47271 L p F P
0 g
s
.713 .768 .895 r
.46172 .34844 m .49349 .34553 L .49447 .3409 L p F P
0 g
s
.474 .23 .464 r
.67865 .77033 m .67657 .7943 L .72867 .77428 L p F P
0 g
s
.474 .23 .464 r
.72867 .77428 m .7315 .7497 L .67865 .77033 L p F P
0 g
s
.623 .695 .896 r
.55753 .34515 m .58929 .34767 L .58722 .33844 L p F P
0 g
s
.623 .695 .896 r
.58722 .33844 m .55642 .34052 L .55753 .34515 L p F P
0 g
s
.775 .445 .429 r
.43887 .8304 m .43667 .80881 L .37901 .79568 L p F P
0 g
s
.723 .405 .441 r
.43667 .80881 m .43887 .8304 L .49797 .83664 L p F P
0 g
s
.8 .815 .864 r
.4001 .36197 m .37085 .37251 L .37475 .39449 L p F P
0 g
s
.827 .831 .851 r
.34799 .41119 m .37475 .39449 L .37085 .37251 L p F P
0 g
s
.535 .249 .427 r
.61927 .80798 m .61693 .8296 L .67278 .81647 L p F P
0 g
s
.535 .249 .427 r
.67278 .81647 m .67657 .7943 L .61927 .80798 L p F P
0 g
s
.396 .395 .741 r
.75466 .50234 m .77134 .52783 L .79126 .49351 L p F P
0 g
s
.396 .395 .741 r
.79126 .49351 m .77289 .46993 L .75466 .50234 L p F P
0 g
s
.49 .559 .854 r
.67688 .39272 m .70377 .40912 L .70803 .38332 L p F P
0 g
s
.49 .559 .854 r
.70803 .38332 m .68018 .37066 L .67688 .39272 L p F P
0 g
s
.713 .768 .895 r
.49447 .3409 m .46352 .33919 L .46172 .34844 L p F P
0 g
s
.74 .794 .896 r
.43049 .35393 m .46172 .34844 L .46352 .33919 L p F P
0 g
s
.586 .669 .897 r
.58929 .34767 m .62051 .35279 L .61766 .33904 L p F P
0 g
s
.586 .669 .897 r
.61766 .33904 m .58722 .33844 L .58929 .34767 L p F P
0 g
s
.707 .774 .904 r
.46352 .33919 m .49447 .3409 L .49692 .3365 L p F P
0 g
s
.619 .703 .905 r
.55642 .34052 m .58722 .33844 L .58222 .32969 L p F P
0 g
s
.619 .703 .905 r
.58222 .32969 m .55385 .33615 L .55642 .34052 L p F P
0 g
s
.883 .629 .549 r
.2789 .67183 m .2768 .69902 L .32312 .72577 L p F P
0 g
s
.888 .602 .498 r
.32363 .75164 m .32312 .72577 L .2768 .69902 L p F P
0 g
s
.827 .831 .851 r
.37085 .37251 m .34301 .38548 L .34799 .41119 L p F P
0 g
s
.854 .846 .835 r
.32298 .4299 m .34799 .41119 L .34301 .38548 L p F P
0 g
s
.74 .794 .896 r
.46352 .33919 m .43296 .34016 L .43049 .35393 L p F P
0 g
s
.768 .82 .893 r
.4001 .36197 m .43049 .35393 L .43296 .34016 L p F P
0 g
s
.917 .723 .626 r
.25641 .58412 m .24787 .61163 L .28366 .64412 L p F P
0 g
s
.929 .707 .582 r
.2789 .67183 m .28366 .64412 L .24787 .61163 L p F P
0 g
s
.398 .203 .496 r
.73204 .72379 m .7315 .7497 L .77698 .723 L p F P
0 g
s
.398 .203 .496 r
.77698 .723 m .77764 .69656 L .73204 .72379 L p F P
0 g
s
.699 .778 .913 r
.46828 .33039 m .49692 .3365 L .50073 .33256 L p F P
0 g
s
.707 .774 .904 r
.49692 .3365 m .46828 .33039 L .46352 .33919 L p F P
0 g
s
.907 .809 .739 r
.27923 .47271 m .26096 .49646 L .28181 .5305 L p F P
0 g
s
.928 .807 .706 r
.26778 .55699 m .28181 .5305 L .26096 .49646 L p F P
0 g
s
.618 .713 .913 r
.55385 .33615 m .58222 .32969 L .57449 .32185 L p F P
0 g
s
.618 .713 .913 r
.57449 .32185 m .54994 .33226 L .55385 .33615 L p F P
0 g
s
.447 .518 .838 r
.70377 .40912 m .7289 .42756 L .73418 .39836 L p F P
0 g
s
.447 .518 .838 r
.73418 .39836 m .70803 .38332 L .70377 .40912 L p F P
0 g
s
.545 .64 .895 r
.62051 .35279 m .65091 .36046 L .64742 .34235 L p F P
0 g
s
.545 .64 .895 r
.64742 .34235 m .61766 .33904 L .62051 .35279 L p F P
0 g
s
.349 .235 .58 r
.7707 .64164 m .77552 .66935 L .81122 .63635 L p F P
0 g
s
.349 .235 .58 r
.81122 .63635 m .80561 .60873 L .7707 .64164 L p F P
0 g
s
.353 .342 .707 r
.77134 .52783 m .78551 .55421 L .80691 .51844 L p F P
0 g
s
.353 .342 .707 r
.80691 .51844 m .79126 .49351 L .77134 .52783 L p F P
0 g
s
.732 .806 .91 r
.43296 .34016 m .46352 .33919 L .46828 .33039 L p F P
0 g
s
.689 .78 .92 r
.47579 .32245 m .50073 .33256 L .50572 .32925 L p F P
0 g
s
.699 .778 .913 r
.50073 .33256 m .47579 .32245 L .46828 .33039 L p F P
0 g
s
.62 .724 .921 r
.54994 .33226 m .57449 .32185 L .56437 .3153 L p F P
0 g
s
.62 .724 .921 r
.56437 .3153 m .54486 .32902 L .54994 .33226 L p F P
0 g
s
.577 .682 .912 r
.58722 .33844 m .61766 .33904 L .61038 .32595 L p F P
0 g
s
.577 .682 .912 r
.61038 .32595 m .58222 .32969 L .58722 .33844 L p F P
0 g
s
.709 .357 .379 r
.49898 .8557 m .49797 .83664 L .43887 .8304 L p F P
0 g
s
.651 .311 .384 r
.49797 .83664 m .49898 .8557 L .55678 .85544 L p F P
0 g
s
.651 .311 .384 r
.55678 .85544 m .55799 .83637 L .49797 .83664 L p F P
0 g
s
.585 .256 .378 r
.55799 .83637 m .55678 .85544 L .61352 .84901 L p F P
0 g
s
.585 .256 .378 r
.61352 .84901 m .61693 .8296 L .55799 .83637 L p F P
0 g
s
.854 .846 .835 r
.34301 .38548 m .3169 .40081 L .32298 .4299 L p F P
0 g
s
.881 .859 .815 r
.29998 .45046 m .32298 .4299 L .3169 .40081 L p F P
0 g
s
.768 .82 .893 r
.43296 .34016 m .40308 .34383 L .4001 .36197 L p F P
0 g
s
.796 .846 .888 r
.37085 .37251 m .4001 .36197 L .40308 .34383 L p F P
0 g
s
.677 .778 .926 r
.48573 .31579 m .50572 .32925 L .51166 .32676 L p F P
0 g
s
.689 .78 .92 r
.50572 .32925 m .48573 .31579 L .47579 .32245 L p F P
0 g
s
.624 .736 .927 r
.54486 .32902 m .56437 .3153 L .55233 .3104 L p F P
0 g
s
.624 .736 .927 r
.55233 .3104 m .53885 .32659 L .54486 .32902 L p F P
0 g
s
.499 .606 .89 r
.65091 .36046 m .68018 .37066 L .67621 .3484 L p F P
0 g
s
.499 .606 .89 r
.67621 .3484 m .64742 .34235 L .65091 .36046 L p F P
0 g
s
.4 .471 .818 r
.7289 .42756 m .75203 .44788 L .75833 .41567 L p F P
0 g
s
.4 .471 .818 r
.75833 .41567 m .73418 .39836 L .7289 .42756 L p F P
0 g
s
.834 .524 .466 r
.32363 .75164 m .32638 .77616 L .37901 .79568 L p F P
0 g
s
.829 .484 .404 r
.38267 .81778 m .37901 .79568 L .32638 .77616 L p F P
0 g
s
.775 .445 .429 r
.37901 .79568 m .38267 .81778 L .43887 .8304 L p F P
0 g
s
.665 .774 .931 r
.49763 .31073 m .51166 .32676 L .51826 .32519 L p F P
0 g
s
.677 .778 .926 r
.51166 .32676 m .49763 .31073 L .48573 .31579 L p F P
0 g
s
.631 .747 .931 r
.53885 .32659 m .55233 .3104 L .53896 .30738 L p F P
0 g
s
.631 .747 .931 r
.53896 .30738 m .5322 .32511 L .53885 .32659 L p F P
0 g
s
.441 .167 .4 r
.67657 .7943 m .67278 .81647 L .7235 .79725 L p F P
0 g
s
.441 .167 .4 r
.7235 .79725 m .72867 .77428 L .67657 .7943 L p F P
0 g
s
.652 .767 .933 r
.51091 .30755 m .51826 .32519 L .52522 .32463 L p F P
0 g
s
.665 .774 .931 r
.51826 .32519 m .51091 .30755 L .49763 .31073 L p F P
0 g
s
.928 .807 .706 r
.26096 .49646 m .24541 .52151 L .26778 .55699 L p F P
0 g
s
.947 .802 .667 r
.25641 .58412 m .26778 .55699 L .24541 .52151 L p F P
0 g
s
.641 .758 .933 r
.5322 .32511 m .53896 .30738 L .52492 .30641 L p F P
0 g
s
.641 .758 .933 r
.52492 .30641 m .52522 .32463 L .5322 .32511 L p F P
0 g
s
.652 .767 .933 r
.52522 .32463 m .52492 .30641 L .51091 .30755 L p F P
0 g
s
.718 .815 .925 r
.43987 .32699 m .46828 .33039 L .47579 .32245 L p F P
0 g
s
.732 .806 .91 r
.46828 .33039 m .43987 .32699 L .43296 .34016 L p F P
0 g
s
.573 .698 .926 r
.58222 .32969 m .61038 .32595 L .59895 .31416 L p F P
0 g
s
.573 .698 .926 r
.59895 .31416 m .57449 .32185 L .58222 .32969 L p F P
0 g
s
.764 .397 .36 r
.44208 .84977 m .43887 .8304 L .38267 .81778 L p F P
0 g
s
.709 .357 .379 r
.43887 .8304 m .44208 .84977 L .49898 .8557 L p F P
0 g
s
.757 .839 .914 r
.40308 .34383 m .43296 .34016 L .43987 .32699 L p F P
0 g
s
.929 .707 .582 r
.24787 .61163 m .24231 .63926 L .2789 .67183 L p F P
0 g
s
.938 .685 .528 r
.2768 .69902 m .2789 .67183 L .24231 .63926 L p F P
0 g
s
.304 .28 .667 r
.78551 .55421 m .79699 .58126 L .8196 .54447 L p F P
0 g
s
.304 .28 .667 r
.8196 .54447 m .80691 .51844 L .78551 .55421 L p F P
0 g
s
.505 .185 .358 r
.61693 .8296 m .61352 .84901 L .66724 .83654 L p F P
0 g
s
.505 .185 .358 r
.66724 .83654 m .67278 .81647 L .61693 .8296 L p F P
0 g
s
.528 .655 .916 r
.61766 .33904 m .64742 .34235 L .63804 .32502 L p F P
0 g
s
.528 .655 .916 r
.63804 .32502 m .61038 .32595 L .61766 .33904 L p F P
0 g
s
.796 .846 .888 r
.40308 .34383 m .37419 .35022 L .37085 .37251 L p F P
0 g
s
.825 .871 .879 r
.34301 .38548 m .37085 .37251 L .37419 .35022 L p F P
0 g
s
.881 .859 .815 r
.3169 .40081 m .29278 .41837 L .29998 .45046 L p F P
0 g
s
.908 .871 .79 r
.27923 .47271 m .29998 .45046 L .29278 .41837 L p F P
0 g
s
.888 .602 .498 r
.2768 .69902 m .27744 .72542 L .32363 .75164 L p F P
0 g
s
.888 .568 .436 r
.32638 .77616 m .32363 .75164 L .27744 .72542 L p F P
0 g
s
.446 .565 .882 r
.68018 .37066 m .70803 .38332 L .70373 .35717 L p F P
0 g
s
.446 .565 .882 r
.70373 .35717 m .67621 .3484 L .68018 .37066 L p F P
0 g
s
.303 .167 .525 r
.77552 .66935 m .77764 .69656 L .8137 .66385 L p F P
0 g
s
.303 .167 .525 r
.8137 .66385 m .81122 .63635 L .77552 .66935 L p F P
0 g
s
.358 .134 .432 r
.7315 .7497 m .72867 .77428 L .77346 .74838 L p F P
0 g
s
.358 .134 .432 r
.77346 .74838 m .77698 .723 L .7315 .7497 L p F P
0 g
s
.346 .417 .792 r
.75203 .44788 m .77289 .46993 L .7802 .43512 L p F P
0 g
s
.346 .417 .792 r
.7802 .43512 m .75833 .41567 L .75203 .44788 L p F P
0 g
s
.699 .818 .939 r
.45096 .31507 m .47579 .32245 L .48573 .31579 L p F P
0 g
s
.718 .815 .925 r
.47579 .32245 m .45096 .31507 L .43987 .32699 L p F P
0 g
s
.573 .716 .94 r
.57449 .32185 m .59895 .31416 L .58387 .30429 L p F P
0 g
s
.573 .716 .94 r
.58387 .30429 m .56437 .3153 L .57449 .32185 L p F P
0 g
s
.947 .802 .667 r
.24541 .52151 m .23278 .54763 L .25641 .58412 L p F P
0 g
s
.965 .792 .618 r
.24787 .61163 m .25641 .58412 L .23278 .54763 L p F P
0 g
s
.757 .839 .914 r
.43987 .32699 m .41197 .3264 L .40308 .34383 L p F P
0 g
s
.782 .873 .914 r
.37419 .35022 m .40308 .34383 L .41197 .3264 L p F P
0 g
s
.825 .871 .879 r
.37419 .35022 m .34658 .35931 L .34301 .38548 L p F P
0 g
s
.854 .896 .865 r
.3169 .40081 m .34301 .38548 L .34658 .35931 L p F P
0 g
s
.908 .871 .79 r
.29278 .41837 m .27095 .43805 L .27923 .47271 L p F P
0 g
s
.934 .879 .757 r
.26096 .49646 m .27923 .47271 L .27095 .43805 L p F P
0 g
s
.47 .622 .917 r
.64742 .34235 m .67621 .3484 L .66492 .32699 L p F P
0 g
s
.47 .622 .917 r
.66492 .32699 m .63804 .32502 L .64742 .34235 L p F P
0 g
s
.737 .853 .935 r
.41197 .3264 m .43987 .32699 L .45096 .31507 L p F P
0 g
s
.677 .816 .95 r
.46576 .30502 m .48573 .31579 L .49763 .31073 L p F P
0 g
s
.699 .818 .939 r
.48573 .31579 m .46576 .30502 L .45096 .31507 L p F P
0 g
s
.385 .517 .868 r
.70803 .38332 m .73418 .39836 L .72967 .36863 L p F P
0 g
s
.385 .517 .868 r
.72967 .36863 m .70373 .35717 L .70803 .38332 L p F P
0 g
s
.247 .209 .617 r
.79699 .58126 m .80561 .60873 L .82915 .57136 L p F P
0 g
s
.247 .209 .617 r
.82915 .57136 m .8196 .54447 L .79699 .58126 L p F P
0 g
s
.578 .737 .951 r
.56437 .3153 m .58387 .30429 L .56584 .29687 L p F P
0 g
s
.578 .737 .951 r
.56584 .29687 m .55233 .3104 L .56437 .3153 L p F P
0 g
s
.516 .676 .937 r
.61038 .32595 m .63804 .32502 L .62309 .30936 L p F P
0 g
s
.516 .676 .937 r
.62309 .30936 m .59895 .31416 L .61038 .32595 L p F P
0 g
s
.284 .353 .758 r
.77289 .46993 m .79126 .49351 L .79951 .45656 L p F P
0 g
s
.284 .353 .758 r
.79951 .45656 m .7802 .43512 L .77289 .46993 L p F P
0 g
s
.687 .295 .297 r
.50032 .87222 m .49898 .8557 L .44208 .84977 L p F P
0 g
s
.626 .247 .305 r
.49898 .8557 m .50032 .87222 L .55519 .87198 L p F P
0 g
s
.626 .247 .305 r
.55519 .87198 m .55678 .85544 L .49898 .8557 L p F P
0 g
s
.554 .185 .296 r
.55678 .85544 m .55519 .87198 L .60903 .86594 L p F P
0 g
s
.554 .185 .296 r
.60903 .86594 m .61352 .84901 L .55678 .85544 L p F P
0 g
s
.829 .484 .404 r
.32638 .77616 m .33143 .79905 L .38267 .81778 L p F P
0 g
s
.817 .431 .323 r
.38802 .83779 m .38267 .81778 L .33143 .79905 L p F P
0 g
s
.764 .397 .36 r
.38267 .81778 m .38802 .83779 L .44208 .84977 L p F P
0 g
s
.938 .685 .528 r
.24231 .63926 m .23984 .66673 L .2768 .69902 L p F P
0 g
s
.943 .654 .461 r
.27744 .72542 m .2768 .69902 L .23984 .66673 L p F P
0 g
s
.653 .808 .958 r
.48357 .29738 m .49763 .31073 L .51091 .30755 L p F P
0 g
s
.677 .816 .95 r
.49763 .31073 m .48357 .29738 L .46576 .30502 L p F P
0 g
s
.397 .087 .319 r
.67278 .81647 m .66724 .83654 L .71597 .81832 L p F P
0 g
s
.397 .087 .319 r
.71597 .81832 m .7235 .79725 L .67278 .81647 L p F P
0 g
s
.59 .758 .958 r
.55233 .3104 m .56584 .29687 L .54575 .2923 L p F P
0 g
s
.59 .758 .958 r
.54575 .2923 m .53896 .30738 L .55233 .3104 L p F P
0 g
s
.248 .086 .456 r
.77764 .69656 m .77698 .723 L .81293 .69093 L p F P
0 g
s
.248 .086 .456 r
.81293 .69093 m .8137 .66385 L .77764 .69656 L p F P
0 g
s
.888 .568 .436 r
.27744 .72542 m .28088 .75073 L .32638 .77616 L p F P
0 g
s
.882 .521 .357 r
.33143 .79905 m .32638 .77616 L .28088 .75073 L p F P
0 g
s
.629 .795 .962 r
.50353 .29256 m .51091 .30755 L .52492 .30641 L p F P
0 g
s
.653 .808 .958 r
.51091 .30755 m .50353 .29256 L .48357 .29738 L p F P
0 g
s
.607 .778 .962 r
.53896 .30738 m .54575 .2923 L .52461 .29083 L p F P
0 g
s
.607 .778 .962 r
.52461 .29083 m .52492 .30641 L .53896 .30738 L p F P
0 g
s
.854 .896 .865 r
.34658 .35931 m .32056 .37107 L .3169 .40081 L p F P
0 g
s
.883 .918 .844 r
.29278 .41837 m .3169 .40081 L .32056 .37107 L p F P
0 g
s
.629 .795 .962 r
.52492 .30641 m .52461 .29083 L .50353 .29256 L p F P
0 g
s
.306 .049 .351 r
.72867 .77428 m .7235 .79725 L .76705 .77241 L p F P
0 g
s
.306 .049 .351 r
.76705 .77241 m .77346 .74838 L .72867 .77428 L p F P
0 g
s
.743 .332 .271 r
.44631 .86666 m .44208 .84977 L .38802 .83779 L p F P
0 g
s
.687 .295 .297 r
.44208 .84977 m .44631 .86666 L .50032 .87222 L p F P
0 g
s
.782 .873 .914 r
.41197 .3264 m .38486 .3287 L .37419 .35022 L p F P
0 g
s
.808 .908 .909 r
.34658 .35931 m .37419 .35022 L .38486 .3287 L p F P
0 g
s
.934 .879 .757 r
.27095 .43805 m .25167 .45967 L .26096 .49646 L p F P
0 g
s
.959 .883 .715 r
.24541 .52151 m .26096 .49646 L .25167 .45967 L p F P
0 g
s
.965 .792 .618 r
.23278 .54763 m .22328 .57458 L .24787 .61163 L p F P
0 g
s
.979 .774 .558 r
.24231 .63926 m .24787 .61163 L .22328 .57458 L p F P
0 g
s
.463 .102 .267 r
.61352 .84901 m .60903 .86594 L .65996 .85426 L p F P
0 g
s
.463 .102 .267 r
.65996 .85426 m .66724 .83654 L .61352 .84901 L p F P
0 g
s
.708 .86 .954 r
.42647 .31056 m .45096 .31507 L .46576 .30502 L p F P
0 g
s
.737 .853 .935 r
.45096 .31507 m .42647 .31056 L .41197 .3264 L p F P
0 g
s
.313 .458 .846 r
.73418 .39836 m .75833 .41567 L .75372 .38275 L p F P
0 g
s
.313 .458 .846 r
.75372 .38275 m .72967 .36863 L .73418 .39836 L p F P
0 g
s
.511 .701 .956 r
.59895 .31416 m .62309 .30936 L .60318 .29619 L p F P
0 g
s
.511 .701 .956 r
.60318 .29619 m .58387 .30429 L .59895 .31416 L p F P
0 g
s
.399 .578 .912 r
.67621 .3484 m .70373 .35717 L .69072 .33192 L p F P
0 g
s
.399 .578 .912 r
.69072 .33192 m .66492 .32699 L .67621 .3484 L p F P
0 g
s
.211 .278 .715 r
.79126 .49351 m .80691 .51844 L .81599 .47981 L p F P
0 g
s
.211 .278 .715 r
.81599 .47981 m .79951 .45656 L .79126 .49351 L p F P
0 g
s
.179 .124 .554 r
.80561 .60873 m .81122 .63635 L .83538 .59885 L p F P
0 g
s
.179 .124 .554 r
.83538 .59885 m .82915 .57136 L .80561 .60873 L p F P
0 g
s
.754 .894 .941 r
.38486 .3287 m .41197 .3264 L .42647 .31056 L p F P
0 g
s
.445 .644 .943 r
.63804 .32502 m .66492 .32699 L .64662 .30756 L p F P
0 g
s
.445 .644 .943 r
.64662 .30756 m .62309 .30936 L .63804 .32502 L p F P
0 g
s
.943 .654 .461 r
.23984 .66673 m .24059 .69376 L .27744 .72542 L p F P
0 g
s
.941 .61 .376 r
.28088 .75073 m .27744 .72542 L .24059 .69376 L p F P
0 g
s
.671 .857 .97 r
.44599 .29716 m .46576 .30502 L .48357 .29738 L p F P
0 g
s
.708 .86 .954 r
.46576 .30502 m .44599 .29716 L .42647 .31056 L p F P
0 g
s
.883 .918 .844 r
.32056 .37107 m .29644 .38545 L .29278 .41837 L p F P
0 g
s
.911 .938 .813 r
.27095 .43805 m .29278 .41837 L .29644 .38545 L p F P
0 g
s
.514 .731 .972 r
.58387 .30429 m .60318 .29619 L .57925 .28625 L p F P
0 g
s
.514 .731 .972 r
.57925 .28625 m .56584 .29687 L .58387 .30429 L p F P
0 g
s
.959 .883 .715 r
.25167 .45967 m .23522 .48307 L .24541 .52151 L p F P
0 g
s
.98 .88 .66 r
.23278 .54763 m .24541 .52151 L .23522 .48307 L p F P
0 g
s
.179 0 .368 r
.77698 .723 m .77346 .74838 L .80883 .71729 L p F P
0 g
s
.179 0 .368 r
.80883 .71729 m .81293 .69093 L .77698 .723 L p F P
0 g
s
.808 .908 .909 r
.38486 .3287 m .35886 .33393 L .34658 .35931 L p F P
0 g
s
.833 .941 .896 r
.32056 .37107 m .34658 .35931 L .35886 .33393 L p F P
0 g
s
.226 .386 .814 r
.75833 .41567 m .7802 .43512 L .77558 .39943 L p F P
0 g
s
.226 .386 .814 r
.77558 .39943 m .75372 .38275 L .75833 .41567 L p F P
0 g
s
.817 .431 .323 r
.33143 .79905 m .33878 .82003 L .38802 .83779 L p F P
0 g
s
.792 .358 .217 r
.39505 .85543 m .38802 .83779 L .33878 .82003 L p F P
0 g
s
.743 .332 .271 r
.38802 .83779 m .39505 .85543 L .44631 .86666 L p F P
0 g
s
.979 .774 .558 r
.22328 .57458 m .21708 .60209 L .24231 .63926 L p F P
0 g
s
.987 .746 .48 r
.23984 .66673 m .24231 .63926 L .21708 .60209 L p F P
0 g
s
.311 .521 .898 r
.70373 .35717 m .72967 .36863 L .71513 .33983 L p F P
0 g
s
.311 .521 .898 r
.71513 .33983 m .69072 .33192 L .70373 .35717 L p F P
0 g
s
.125 .187 .657 r
.80691 .51844 m .8196 .54447 L .8294 .50466 L p F P
0 g
s
.125 .187 .657 r
.8294 .50466 m .81599 .47981 L .80691 .51844 L p F P
0 g
s
.651 .209 .188 r
.50197 .88592 m .50032 .87222 L .44631 .86666 L p F P
0 g
s
.587 .16 .199 r
.50032 .87222 m .50197 .88592 L .55321 .8857 L p F P
0 g
s
.587 .16 .199 r
.55321 .8857 m .55519 .87198 L .50032 .87222 L p F P
0 g
s
.507 .091 .186 r
.55519 .87198 m .55321 .8857 L .60347 .88012 L p F P
0 g
s
.507 .091 .186 r
.60347 .88012 m .60903 .86594 L .55519 .87198 L p F P
0 g
s
.337 0 .211 r
.66724 .83654 m .65996 .85426 L .70607 .83719 L p F P
0 g
s
.337 0 .211 r
.70607 .83719 m .71597 .81832 L .66724 .83654 L p F P
0 g
s
.882 .521 .357 r
.28088 .75073 m .28719 .77466 L .33143 .79905 L p F P
0 g
s
.865 .457 .254 r
.33878 .82003 m .33143 .79905 L .28719 .77466 L p F P
0 g
s
.63 .844 .982 r
.46963 .28693 m .48357 .29738 L .50353 .29256 L p F P
0 g
s
.671 .857 .97 r
.48357 .29738 m .46963 .28693 L .44599 .29716 L p F P
0 g
s
.529 .762 .983 r
.56584 .29687 m .57925 .28625 L .55249 .28012 L p F P
0 g
s
.529 .762 .983 r
.55249 .28012 m .54575 .2923 L .56584 .29687 L p F P
0 g
s
.098 .022 .473 r
.81122 .63635 m .8137 .66385 L .83813 .62666 L p F P
0 g
s
.098 .022 .473 r
.83813 .62666 m .83538 .59885 L .81122 .63635 L p F P
0 g
s
.238 0 .246 r
.7235 .79725 m .71597 .81832 L .75771 .79478 L p F P
0 g
s
.238 0 .246 r
.75771 .79478 m .76705 .77241 L .7235 .79725 L p F P
0 g
s
.711 .903 .964 r
.40259 .30907 m .42647 .31056 L .44599 .29716 L p F P
0 g
s
.754 .894 .941 r
.42647 .31056 m .40259 .30907 L .38486 .3287 L p F P
0 g
s
.769 .935 .938 r
.35886 .33393 m .38486 .3287 L .40259 .30907 L p F P
0 g
s
.427 .674 .966 r
.62309 .30936 m .64662 .30756 L .62207 .29118 L p F P
0 g
s
.427 .674 .966 r
.62207 .29118 m .60318 .29619 L .62309 .30936 L p F P
0 g
s
.589 .822 .988 r
.49619 .28047 m .50353 .29256 L .52461 .29083 L p F P
0 g
s
.63 .844 .982 r
.50353 .29256 m .49619 .28047 L .46963 .28693 L p F P
0 g
s
.352 .599 .94 r
.66492 .32699 m .69072 .33192 L .6693 .30891 L p F P
0 g
s
.352 .599 .94 r
.6693 .30891 m .64662 .30756 L .66492 .32699 L p F P
0 g
s
.554 .794 .988 r
.54575 .2923 m .55249 .28012 L .52431 .27816 L p F P
0 g
s
.554 .794 .988 r
.52431 .27816 m .52461 .29083 L .54575 .2923 L p F P
0 g
s
.705 .242 .15 r
.45156 .88078 m .44631 .86666 L .39505 .85543 L p F P
0 g
s
.651 .209 .188 r
.44631 .86666 m .45156 .88078 L .50197 .88592 L p F P
0 g
s
.589 .822 .988 r
.52461 .29083 m .52431 .27816 L .49619 .28047 L p F P
0 g
s
.911 .938 .813 r
.29644 .38545 m .27453 .40237 L .27095 .43805 L p F P
0 g
s
.935 .952 .768 r
.25167 .45967 m .27095 .43805 L .27453 .40237 L p F P
0 g
s
.402 0 .145 r
.60903 .86594 m .60347 .88012 L .65094 .86933 L p F P
0 g
s
.402 0 .145 r
.65094 .86933 m .65996 .85426 L .60903 .86594 L p F P
0 g
s
.98 .88 .66 r
.23522 .48307 m .22183 .50802 L .23278 .54763 L p F P
0 g
s
.995 .866 .586 r
.22328 .57458 m .23278 .54763 L .22183 .50802 L p F P
0 g
s
.122 .295 .767 r
.7802 .43512 m .79951 .45656 L .79494 .41856 L p F P
0 g
s
.122 .295 .767 r
.79494 .41856 m .77558 .39943 L .7802 .43512 L p F P
0 g
s
.833 .941 .896 r
.35886 .33393 m .33425 .34213 L .32056 .37107 L p F P
0 g
s
.854 .971 .869 r
.29644 .38545 m .32056 .37107 L .33425 .34213 L p F P
0 g
s
.941 .61 .376 r
.24059 .69376 m .24463 .72003 L .28088 .75073 L p F P
0 g
s
.926 .548 .267 r
.28719 .77466 m .28088 .75073 L .24463 .72003 L p F P
0 g
s
.022 .077 .581 r
.8196 .54447 m .82915 .57136 L .83951 .53088 L p F P
0 g
s
.022 .077 .581 r
.83951 .53088 m .8294 .50466 L .8196 .54447 L p F P
0 g
s
.201 .446 .87 r
.72967 .36863 m .75372 .38275 L .73785 .35074 L p F P
0 g
s
.201 .446 .87 r
.73785 .35074 m .71513 .33983 L .72967 .36863 L p F P
0 g
s
.987 .746 .48 r
.21708 .60209 m .21434 .62987 L .23984 .66673 L p F P
0 g
s
.984 .702 .38 r
.24059 .69376 m .23984 .66673 L .21434 .62987 L p F P
0 g
s
.093 0 .255 r
.77346 .74838 m .76705 .77241 L .80135 .74262 L p F P
0 g
s
.093 0 .255 r
.80135 .74262 m .80883 .71729 L .77346 .74838 L p F P
0 g
s
.653 .896 .982 r
.42665 .29239 m .44599 .29716 L .46963 .28693 L p F P
0 g
s
.711 .903 .964 r
.44599 .29716 m .42665 .29239 L .40259 .30907 L p F P
0 g
s
.422 .711 .983 r
.60318 .29619 m .62207 .29118 L .5924 .27878 L p F P
0 g
s
.422 .711 .983 r
.5924 .27878 m .57925 .28625 L .60318 .29619 L p F P
0 g
s
0 0 .37 r
.8137 .66385 m .81293 .69093 L .83727 .65447 L p F P
0 g
s
0 0 .37 r
.83727 .65447 m .83813 .62666 L .8137 .66385 L p F P
0 g
s
.769 .935 .938 r
.40259 .30907 m .37958 .31069 L .35886 .33393 L p F P
0 g
s
.777 .971 .919 r
.33425 .34213 m .35886 .33393 L .37958 .31069 L p F P
0 g
s
.865 .457 .254 r
.28719 .77466 m .29637 .79691 L .33878 .82003 L p F P
0 g
s
.827 .366 .119 r
.34846 .83879 m .33878 .82003 L .29637 .79691 L p F P
0 g
s
.792 .358 .217 r
.33878 .82003 m .34846 .83879 L .39505 .85543 L p F P
0 g
s
.935 .952 .768 r
.27453 .40237 m .25512 .42169 L .25167 .45967 L p F P
0 g
s
.951 .955 .702 r
.23522 .48307 m .25167 .45967 L .25512 .42169 L p F P
0 g
s
.745 .256 .075 r
.40377 .87041 m .39505 .85543 L .34846 .83879 L p F P
0 g
s
.705 .242 .15 r
.39505 .85543 m .40377 .87041 L .45156 .88078 L p F P
0 g
s
.703 .943 .96 r
.37958 .31069 m .40259 .30907 L .42665 .29239 L p F P
0 g
s
.229 .531 .921 r
.69072 .33192 m .71513 .33983 L .69084 .31348 L p F P
0 g
s
.229 .531 .921 r
.69084 .31348 m .6693 .30891 L .69072 .33192 L p F P
0 g
s
.253 0 .066 r
.65996 .85426 m .65094 .86933 L .69383 .85359 L p F P
0 g
s
.253 0 .066 r
.69383 .85359 m .70607 .83719 L .65996 .85426 L p F P
0 g
s
.149 0 .107 r
.71597 .81832 m .70607 .83719 L .74546 .81519 L p F P
0 g
s
.149 0 .107 r
.74546 .81519 m .75771 .79478 L .71597 .81832 L p F P
0 g
s
.31 .627 .961 r
.64662 .30756 m .6693 .30891 L .64033 .28944 L p F P
0 g
s
.31 .627 .961 r
.64033 .28944 m .62207 .29118 L .64662 .30756 L p F P
0 g
s
0 .182 .698 r
.79951 .45656 m .81599 .47981 L .81151 .43999 L p F P
0 g
s
0 .182 .698 r
.81151 .43999 m .79494 .41856 L .79951 .45656 L p F P
0 g
s
.995 .866 .586 r
.22183 .50802 m .21174 .5343 L .22328 .57458 L p F P
0 g
s
.997 .836 .49 r
.21708 .60209 m .22328 .57458 L .21174 .5343 L p F P
0 g
s
.586 .874 .994 r
.45594 .27963 m .46963 .28693 L .49619 .28047 L p F P
0 g
s
.653 .896 .982 r
.46963 .28693 m .45594 .27963 L .42665 .29239 L p F P
0 g
s
.589 .09 .036 r
.50394 .89654 m .50197 .88592 L .45156 .88078 L p F P
0 g
s
.522 .04 .052 r
.50197 .88592 m .50394 .89654 L .55086 .89634 L p F P
0 g
s
.522 .04 .052 r
.55086 .89634 m .55321 .8857 L .50197 .88592 L p F P
0 g
s
.433 0 .033 r
.55321 .8857 m .55086 .89634 L .59685 .89128 L p F P
0 g
s
.433 0 .033 r
.59685 .89128 m .60347 .88012 L .55321 .8857 L p F P
0 g
s
.435 .752 .994 r
.57925 .28625 m .5924 .27878 L .55912 .27111 L p F P
0 g
s
.435 .752 .994 r
.55912 .27111 m .55249 .28012 L .57925 .28625 L p F P
0 g
s
.854 .971 .869 r
.33425 .34213 m .31136 .3533 L .29644 .38545 L p F P
0 g
s
.867 .992 .821 r
.27453 .40237 m .29644 .38545 L .31136 .3533 L p F P
0 g
s
0 0 .479 r
.82915 .57136 m .83538 .59885 L .84611 .5582 L p F P
0 g
s
0 0 .479 r
.84611 .5582 m .83951 .53088 L .82915 .57136 L p F P
0 g
s
.063 .344 .82 r
.75372 .38275 m .77558 .39943 L .75856 .3646 L p F P
0 g
s
.063 .344 .82 r
.75856 .3646 m .73785 .35074 L .75372 .38275 L p F P
0 g
s
.926 .548 .267 r
.24463 .72003 m .25201 .74524 L .28719 .77466 L p F P
0 g
s
.888 .459 .125 r
.29637 .79691 m .28719 .77466 L .25201 .74524 L p F P
0 g
s
.522 .839 .999 r
.48898 .27155 m .49619 .28047 L .52431 .27816 L p F P
0 g
s
.586 .874 .994 r
.49619 .28047 m .48898 .27155 L .45594 .27963 L p F P
0 g
s
.984 .702 .38 r
.21434 .62987 m .21517 .65762 L .24059 .69376 L p F P
0 g
s
.961 .634 .252 r
.24463 .72003 m .24059 .69376 L .21517 .65762 L p F P
0 g
s
.469 .796 .999 r
.55249 .28012 m .55912 .27111 L .52401 .26865 L p F P
0 g
s
.469 .796 .999 r
.52401 .26865 m .52431 .27816 L .55249 .28012 L p F P
0 g
s
.637 .115 0 r
.45781 .89188 m .45156 .88078 L .40377 .87041 L p F P
0 g
s
.589 .09 .036 r
.45156 .88078 m .45781 .89188 L .50394 .89654 L p F P
0 g
s
.31 0 0 r
.60347 .88012 m .59685 .89128 L .64022 .88149 L p F P
0 g
s
.31 0 0 r
.64022 .88149 m .65094 .86933 L .60347 .88012 L p F P
0 g
s
.522 .839 .999 r
.52431 .27816 m .52401 .26865 L .48898 .27155 L p F P
0 g
s
0 0 .109 r
.76705 .77241 m .75771 .79478 L .79048 .7666 L p F P
0 g
s
0 0 .109 r
.79048 .7666 m .80135 .74262 L .76705 .77241 L p F P
0 g
s
0 0 .236 r
.81293 .69093 m .80883 .71729 L .83273 .68197 L p F P
0 g
s
0 0 .236 r
.83273 .68197 m .83727 .65447 L .81293 .69093 L p F P
0 g
s
.951 .955 .702 r
.25512 .42169 m .23851 .44328 L .23522 .48307 L p F P
0 g
s
.952 .938 .608 r
.22183 .50802 m .23522 .48307 L .23851 .44328 L p F P
0 g
s
.611 .925 .971 r
.40796 .29088 m .42665 .29239 L .45594 .27963 L p F P
0 g
s
.703 .943 .96 r
.42665 .29239 m .40796 .29088 L .37958 .31069 L p F P
0 g
s
.777 .971 .919 r
.37958 .31069 m .35774 .31553 L .33425 .34213 L p F P
0 g
s
.768 .994 .873 r
.31136 .3533 m .33425 .34213 L .35774 .31553 L p F P
0 g
s
.285 .664 .971 r
.62207 .29118 m .64033 .28944 L .60514 .27466 L p F P
0 g
s
.285 .664 .971 r
.60514 .27466 m .5924 .27878 L .62207 .29118 L p F P
0 g
s
0 .04 .6 r
.81599 .47981 m .8294 .50466 L .82503 .46355 L p F P
0 g
s
0 .04 .6 r
.82503 .46355 m .81151 .43999 L .81599 .47981 L p F P
0 g
s
.997 .836 .49 r
.21174 .5343 m .20515 .56163 L .21708 .60209 L p F P
0 g
s
.977 .78 .362 r
.21434 .62987 m .21708 .60209 L .20515 .56163 L p F P
0 g
s
.067 .43 .871 r
.71513 .33983 m .73785 .35074 L .71096 .32135 L p F P
0 g
s
.067 .43 .871 r
.71096 .32135 m .69084 .31348 L .71513 .33983 L p F P
0 g
s
.867 .992 .821 r
.31136 .3533 m .29049 .3674 L .27453 .40237 L p F P
0 g
s
.861 .992 .741 r
.25512 .42169 m .27453 .40237 L .29049 .3674 L p F P
0 g
s
.673 .967 .925 r
.35774 .31553 m .37958 .31069 L .40796 .29088 L p F P
0 g
s
.827 .366 .119 r
.29637 .79691 m .30842 .81718 L .34846 .83879 L p F P
0 g
s
.755 .239 0 r
.36042 .85507 m .34846 .83879 L .30842 .81718 L p F P
0 g
s
.745 .256 .075 r
.34846 .83879 m .36042 .85507 L .40377 .87041 L p F P
0 g
s
0 0 .345 r
.83538 .59885 m .83813 .62666 L .84902 .58632 L p F P
0 g
s
0 0 .345 r
.84902 .58632 m .84611 .5582 L .83538 .59885 L p F P
0 g
s
.147 .545 .924 r
.6693 .30891 m .69084 .31348 L .65773 .29111 L p F P
0 g
s
.147 .545 .924 r
.65773 .29111 m .64033 .28944 L .6693 .30891 L p F P
0 g
s
.029 0 0 r
.70607 .83719 m .69383 .85359 L .73033 .83334 L p F P
0 g
s
.029 0 0 r
.73033 .83334 m .74546 .81519 L .70607 .83719 L p F P
0 g
s
0 .209 .735 r
.77558 .39943 m .79494 .41856 L .77697 .38137 L p F P
0 g
s
0 .209 .735 r
.77697 .38137 m .75856 .3646 L .77558 .39943 L p F P
0 g
s
.658 .111 0 r
.41414 .88247 m .40377 .87041 L .36042 .85507 L p F P
0 g
s
.637 .115 0 r
.40377 .87041 m .41414 .88247 L .45781 .89188 L p F P
0 g
s
.134 0 0 r
.65094 .86933 m .64022 .88149 L .67929 .86723 L p F P
0 g
s
.134 0 0 r
.67929 .86723 m .69383 .85359 L .65094 .86933 L p F P
0 g
s
.961 .634 .252 r
.21517 .65762 m .21967 .68501 L .24463 .72003 L p F P
0 g
s
.906 .533 .088 r
.25201 .74524 m .24463 .72003 L .21967 .68501 L p F P
0 g
s
.504 .882 .972 r
.44269 .27568 m .45594 .27963 L .48898 .27155 L p F P
0 g
s
.611 .925 .971 r
.45594 .27963 m .44269 .27568 L .40796 .29088 L p F P
0 g
s
.888 .459 .125 r
.25201 .74524 m .26275 .76908 L .29637 .79691 L p F P
0 g
s
.812 .333 0 r
.30842 .81718 m .29637 .79691 L .26275 .76908 L p F P
0 g
s
.289 .709 .971 r
.5924 .27878 m .60514 .27466 L .56555 .26551 L p F P
0 g
s
.289 .709 .971 r
.56555 .26551 m .55912 .27111 L .5924 .27878 L p F P
0 g
s
0 0 .067 r
.80883 .71729 m .80135 .74262 L .82444 .70882 L p F P
0 g
s
0 0 .067 r
.82444 .70882 m .83273 .68197 L .80883 .71729 L p F P
0 g
s
.952 .938 .608 r
.23851 .44328 m .22496 .46694 L .22183 .50802 L p F P
0 g
s
.925 .89 .478 r
.21174 .5343 m .22183 .50802 L .22496 .46694 L p F P
0 g
s
.48 0 0 r
.50623 .90383 m .50394 .89654 L .45781 .89188 L p F P
0 g
s
.413 0 0 r
.50394 .89654 m .50623 .90383 L .54814 .90365 L p F P
0 g
s
.413 0 0 r
.54814 .90365 m .55086 .89634 L .50394 .89654 L p F P
0 g
s
.314 0 0 r
.55086 .89634 m .54814 .90365 L .58919 .89916 L p F P
0 g
s
.314 0 0 r
.58919 .89916 m .59685 .89128 L .55086 .89634 L p F P
0 g
s
0 0 0 r
.75771 .79478 m .74546 .81519 L .77625 .78889 L p F P
0 g
s
0 0 0 r
.77625 .78889 m .79048 .7666 L .75771 .79478 L p F P
0 g
s
0 0 .462 r
.8294 .50466 m .83951 .53088 L .83523 .489 L p F P
0 g
s
0 0 .462 r
.83523 .489 m .82503 .46355 L .8294 .50466 L p F P
0 g
s
.977 .78 .362 r
.20515 .56163 m .20223 .58973 L .21434 .62987 L p F P
0 g
s
.924 .689 .199 r
.21517 .65762 m .21434 .62987 L .20223 .58973 L p F P
0 g
s
.404 .824 .969 r
.48198 .26603 m .48898 .27155 L .52401 .26865 L p F P
0 g
s
.504 .882 .972 r
.48898 .27155 m .48198 .26603 L .44269 .27568 L p F P
0 g
s
.768 .994 .873 r
.35774 .31553 m .33734 .32363 L .31136 .3533 L p F P
0 g
s
.727 .984 .781 r
.29049 .3674 m .31136 .3533 L .33734 .32363 L p F P
0 g
s
.328 .763 .969 r
.55912 .27111 m .56555 .26551 L .52372 .26257 L p F P
0 g
s
.328 .763 .969 r
.52372 .26257 m .52401 .26865 L .55912 .27111 L p F P
0 g
s
.515 0 0 r
.46504 .89969 m .45781 .89188 L .41414 .88247 L p F P
0 g
s
.48 0 0 r
.45781 .89188 m .46504 .89969 L .50623 .90383 L p F P
0 g
s
.172 0 0 r
.59685 .89128 m .58919 .89916 L .62784 .89047 L p F P
0 g
s
.172 0 0 r
.62784 .89047 m .64022 .88149 L .59685 .89128 L p F P
0 g
s
.861 .992 .741 r
.29049 .3674 m .27194 .38436 L .25512 .42169 L p F P
0 g
s
.823 .956 .617 r
.23851 .44328 m .25512 .42169 L .27194 .38436 L p F P
0 g
s
0 0 .176 r
.83813 .62666 m .83727 .65447 L .84812 .61493 L p F P
0 g
s
0 0 .176 r
.84812 .61493 m .84902 .58632 L .83813 .62666 L p F P
0 g
s
.404 .824 .969 r
.52401 .26865 m .52372 .26257 L .48198 .26603 L p F P
0 g
s
0 .285 .773 r
.73785 .35074 m .75856 .3646 L .72936 .33254 L p F P
0 g
s
0 .285 .773 r
.72936 .33254 m .71096 .32135 L .73785 .35074 L p F P
0 g
s
.524 .917 .907 r
.39016 .29277 m .40796 .29088 L .44269 .27568 L p F P
0 g
s
.673 .967 .925 r
.40796 .29088 m .39016 .29277 L .35774 .31553 L p F P
0 g
s
0 .037 .604 r
.79494 .41856 m .81151 .43999 L .79277 .40093 L p F P
0 g
s
0 .037 .604 r
.79277 .40093 m .77697 .38137 L .79494 .41856 L p F P
0 g
s
.088 .565 .904 r
.64033 .28944 m .65773 .29111 L .61731 .27409 L p F P
0 g
s
.088 .565 .904 r
.61731 .27409 m .60514 .27466 L .64033 .28944 L p F P
0 g
s
.601 .951 .835 r
.33734 .32363 m .35774 .31553 L .39016 .29277 L p F P
0 g
s
.755 .239 0 r
.30842 .81718 m .32331 .83517 L .36042 .85507 L p F P
0 g
s
.626 .064 0 r
.37464 .86857 m .36042 .85507 L .32331 .83517 L p F P
0 g
s
.658 .111 0 r
.36042 .85507 m .37464 .86857 L .41414 .88247 L p F P
0 g
s
0 .41 .829 r
.69084 .31348 m .71096 .32135 L .67402 .29632 L p F P
0 g
s
0 .41 .829 r
.67402 .29632 m .65773 .29111 L .69084 .31348 L p F P
0 g
s
.906 .533 .088 r
.21967 .68501 m .22789 .71173 L .25201 .74524 L p F P
0 g
s
.806 .391 0 r
.26275 .76908 m .25201 .74524 L .22789 .71173 L p F P
0 g
s
0 0 0 r
.69383 .85359 m .67929 .86723 L .71241 .84893 L p F P
0 g
s
0 0 0 r
.71241 .84893 m .73033 .83334 L .69383 .85359 L p F P
0 g
s
.925 .89 .478 r
.22496 .46694 m .21473 .49246 L .21174 .5343 L p F P
0 g
s
.858 .799 .308 r
.20515 .56163 m .21174 .5343 L .21473 .49246 L p F P
0 g
s
0 0 0 r
.80135 .74262 m .79048 .7666 L .81241 .73467 L p F P
0 g
s
0 0 0 r
.81241 .73467 m .82444 .70882 L .80135 .74262 L p F P
0 g
s
.506 0 0 r
.42612 .89134 m .41414 .88247 L .37464 .86857 L p F P
0 g
s
.515 0 0 r
.41414 .88247 m .42612 .89134 L .46504 .89969 L p F P
0 g
s
.812 .333 0 r
.26275 .76908 m .27682 .7912 L .30842 .81718 L p F P
0 g
s
.682 .164 0 r
.32331 .83517 m .30842 .81718 L .27682 .7912 L p F P
0 g
s
0 0 .284 r
.83951 .53088 m .84611 .5582 L .8419 .51609 L p F P
0 g
s
0 0 .284 r
.8419 .51609 m .83523 .489 L .83951 .53088 L p F P
0 g
s
0 0 0 r
.64022 .88149 m .62784 .89047 L .66255 .87785 L p F P
0 g
s
0 0 0 r
.66255 .87785 m .67929 .86723 L .64022 .88149 L p F P
0 g
s
.924 .689 .199 r
.20223 .58973 m .20311 .61827 L .21517 .65762 L p F P
0 g
s
.825 .555 .004 r
.21967 .68501 m .21517 .65762 L .20311 .61827 L p F P
0 g
s
0 0 0 r
.74546 .81519 m .73033 .83334 L .75871 .80919 L p F P
0 g
s
0 0 0 r
.75871 .80919 m .77625 .78889 L .74546 .81519 L p F P
0 g
s
.359 .83 .873 r
.43003 .27526 m .44269 .27568 L .48198 .26603 L p F P
0 g
s
.524 .917 .907 r
.44269 .27568 m .43003 .27526 L .39016 .29277 L p F P
0 g
s
0 0 0 r
.83727 .65447 m .83273 .68197 L .8433 .64369 L p F P
0 g
s
0 0 0 r
.8433 .64369 m .84812 .61493 L .83727 .65447 L p F P
0 g
s
.072 .599 .871 r
.60514 .27466 m .61731 .27409 L .5717 .26353 L p F P
0 g
s
.072 .599 .871 r
.5717 .26353 m .56555 .26551 L .60514 .27466 L p F P
0 g
s
.823 .956 .617 r
.27194 .38436 m .25603 .40407 L .23851 .44328 L p F P
0 g
s
.739 .866 .442 r
.22496 .46694 m .23851 .44328 L .25603 .40407 L p F P
0 g
s
.727 .984 .781 r
.33734 .32363 m .31869 .33503 L .29049 .3674 L p F P
0 g
s
.638 .915 .624 r
.27194 .38436 m .29049 .3674 L .31869 .33503 L p F P
0 g
s
.299 0 0 r
.50881 .90755 m .50623 .90383 L .46504 .89969 L p F P
0 g
s
.237 0 0 r
.50623 .90383 m .50881 .90755 L .54506 .9074 L p F P
0 g
s
.237 0 0 r
.54506 .9074 m .54814 .90365 L .50623 .90383 L p F P
0 g
s
.132 0 0 r
.54814 .90365 m .54506 .9074 L .58055 .90352 L p F P
0 g
s
.132 0 0 r
.58055 .90352 m .58919 .89916 L .54814 .90365 L p F P
0 g
s
0 .094 .609 r
.75856 .3646 m .77697 .38137 L .74575 .34703 L p F P
0 g
s
0 .094 .609 r
.74575 .34703 m .72936 .33254 L .75856 .3646 L p F P
0 g
s
0 0 .42 r
.81151 .43999 m .82503 .46355 L .80568 .42313 L p F P
0 g
s
0 0 .42 r
.80568 .42313 m .79277 .40093 L .81151 .43999 L p F P
0 g
s
.858 .799 .308 r
.21473 .49246 m .20804 .51957 L .20515 .56163 L p F P
0 g
s
.743 .659 .104 r
.20223 .58973 m .20515 .56163 L .20804 .51957 L p F P
0 g
s
.214 .735 .848 r
.47529 .26414 m .48198 .26603 L .52372 .26257 L p F P
0 g
s
.359 .83 .873 r
.48198 .26603 m .47529 .26414 L .43003 .27526 L p F P
0 g
s
.316 0 0 r
.4732 .90398 m .46504 .89969 L .42612 .89134 L p F P
0 g
s
.299 0 0 r
.46504 .89969 m .4732 .90398 L .50881 .90755 L p F P
0 g
s
.114 .655 .847 r
.56555 .26551 m .5717 .26353 L .52344 .26014 L p F P
0 g
s
.114 .655 .847 r
.52344 .26014 m .52372 .26257 L .56555 .26551 L p F P
0 g
s
.806 .391 0 r
.22789 .71173 m .23983 .73741 L .26275 .76908 L p F P
0 g
s
.651 .211 0 r
.27682 .7912 m .26275 .76908 L .23983 .73741 L p F P
0 g
s
0 0 0 r
.58919 .89916 m .58055 .90352 L .61389 .89604 L p F P
0 g
s
0 0 0 r
.61389 .89604 m .62784 .89047 L .58919 .89916 L p F P
0 g
s
.374 .833 .752 r
.37348 .29818 m .39016 .29277 L .43003 .27526 L p F P
0 g
s
.601 .951 .835 r
.39016 .29277 m .37348 .29818 L .33734 .32363 L p F P
0 g
s
.471 .861 .663 r
.31869 .33503 m .33734 .32363 L .37348 .29818 L p F P
0 g
s
0 .395 .744 r
.65773 .29111 m .67402 .29632 L .62873 .27724 L p F P
0 g
s
0 .395 .744 r
.62873 .27724 m .61731 .27409 L .65773 .29111 L p F P
0 g
s
.214 .735 .848 r
.52372 .26257 m .52344 .26014 L .47529 .26414 L p F P
0 g
s
0 0 .076 r
.84611 .5582 m .84902 .58632 L .84484 .54453 L p F P
0 g
s
0 0 .076 r
.84484 .54453 m .8419 .51609 L .84611 .5582 L p F P
0 g
s
0 0 0 r
.79048 .7666 m .77625 .78889 L .79668 .75916 L p F P
0 g
s
0 0 0 r
.79668 .75916 m .81241 .73467 L .79048 .7666 L p F P
0 g
s
0 .216 .65 r
.71096 .32135 m .72936 .33254 L .68896 .30515 L p F P
0 g
s
0 .216 .65 r
.68896 .30515 m .67402 .29632 L .71096 .32135 L p F P
0 g
s
.626 .064 0 r
.32331 .83517 m .34094 .85058 L .37464 .86857 L p F P
0 g
s
.428 0 0 r
.39101 .87903 m .37464 .86857 L .34094 .85058 L p F P
0 g
s
.506 0 0 r
.37464 .86857 m .39101 .87903 L .42612 .89134 L p F P
0 g
s
.825 .555 .004 r
.20311 .61827 m .2079 .64692 L .21967 .68501 L p F P
0 g
s
.677 .383 0 r
.22789 .71173 m .21967 .68501 L .2079 .64692 L p F P
0 g
s
0 0 0 r
.67929 .86723 m .66255 .87785 L .69183 .86169 L p F P
0 g
s
0 0 0 r
.69183 .86169 m .71241 .84893 L .67929 .86723 L p F P
0 g
s
.682 .164 0 r
.27682 .7912 m .29416 .81131 L .32331 .83517 L p F P
0 g
s
.491 0 0 r
.34094 .85058 m .32331 .83517 L .29416 .81131 L p F P
0 g
s
.71 .744 .234 r
.83273 .68197 m .82444 .70882 L .83452 .67223 L p F P
0 g
s
.71 .744 .234 r
.83452 .67223 m .8433 .64369 L .83273 .68197 L p F P
0 g
s
0 0 0 r
.73033 .83334 m .71241 .84893 L .738 .82716 L p F P
0 g
s
0 0 0 r
.738 .82716 m .75871 .80919 L .73033 .83334 L p F P
0 g
s
.739 .866 .442 r
.25603 .40407 m .24302 .42638 L .22496 .46694 L p F P
0 g
s
0 0 0 r
.21473 .49246 m .22496 .46694 L .24302 .42638 L p F P
0 g
s
.279 0 0 r
.43962 .89679 m .42612 .89134 L .39101 .87903 L p F P
0 g
s
.316 0 0 r
.42612 .89134 m .43962 .89679 L .4732 .90398 L p F P
0 g
s
.638 .915 .624 r
.31869 .33503 m .30206 .34971 L .27194 .38436 L p F P
0 g
s
0 0 0 r
.25603 .40407 m .27194 .38436 L .30206 .34971 L p F P
0 g
s
0 0 0 r
.62784 .89047 m .61389 .89604 L .64373 .88519 L p F P
0 g
s
0 0 0 r
.64373 .88519 m .66255 .87785 L .62784 .89047 L p F P
0 g
s
.724 .363 0 r
.82503 .46355 m .83523 .489 L .81545 .44776 L p F P
0 g
s
.724 .363 0 r
.81545 .44776 m .80568 .42313 L .82503 .46355 L p F P
0 g
s
.606 .121 0 r
.77697 .38137 m .79277 .40093 L .75986 .36477 L p F P
0 g
s
.606 .121 0 r
.75986 .36477 m .74575 .34703 L .77697 .38137 L p F P
0 g
s
.743 .659 .104 r
.20804 .51957 m .20507 .54798 L .20223 .58973 L p F P
0 g
s
0 0 .109 r
.20311 .61827 m .20223 .58973 L .20507 .54798 L p F P
0 g
s
.374 .833 .752 r
.43003 .27526 m .41815 .27855 L .37348 .29818 L p F P
0 g
s
0 0 0 r
.41815 .27855 m .43003 .27526 L .47529 .26414 L p F P
0 g
s
.193 0 0 r
.61731 .27409 m .62873 .27724 L .57748 .26537 L p F P
0 g
s
.193 0 0 r
.57748 .26537 m .5717 .26353 L .61731 .27409 L p F P
0 g
s
.651 .211 0 r
.23983 .73741 m .25544 .76172 L .27682 .7912 L p F P
0 g
s
0 0 .532 r
.29416 .81131 m .27682 .7912 L .25544 .76172 L p F P
0 g
s
.838 .676 .136 r
.84902 .58632 m .84812 .61493 L .84393 .57397 L p F P
0 g
s
.838 .676 .136 r
.84393 .57397 m .84484 .54453 L .84902 .58632 L p F P
0 g
s
.667 .897 .552 r
.77625 .78889 m .75871 .80919 L .77736 .78196 L p F P
0 g
s
.667 .897 .552 r
.77736 .78196 m .79668 .75916 L .77625 .78889 L p F P
0 g
s
.677 .383 0 r
.2079 .64692 m .21664 .67532 L .22789 .71173 L p F P
0 g
s
0 0 .407 r
.23983 .73741 m .22789 .71173 L .21664 .67532 L p F P
0 g
s
0 .537 .727 r
.51168 .90748 m .50881 .90755 L .4732 .90398 L p F P
0 g
s
.007 .583 .711 r
.50881 .90755 m .51168 .90748 L .54166 .90735 L p F P
0 g
s
.007 .583 .711 r
.54166 .90735 m .54506 .9074 L .50881 .90755 L p F P
0 g
s
.102 .657 .73 r
.54506 .9074 m .54166 .90735 L .57098 .90415 L p F P
0 g
s
.102 .657 .73 r
.57098 .90415 m .58055 .90352 L .54506 .9074 L p F P
0 g
s
.471 .861 .663 r
.37348 .29818 m .35819 .30719 L .31869 .33503 L p F P
0 g
s
0 0 0 r
.30206 .34971 m .31869 .33503 L .35819 .30719 L p F P
0 g
s
0 0 0 r
.35819 .30719 m .37348 .29818 L .41815 .27855 L p F P
0 g
s
.812 .87 .43 r
.82444 .70882 m .81241 .73467 L .8218 .70017 L p F P
0 g
s
.812 .87 .43 r
.8218 .70017 m .83452 .67223 L .82444 .70882 L p F P
0 g
s
.565 .009 0 r
.72936 .33254 m .74575 .34703 L .70231 .31763 L p F P
0 g
s
.565 .009 0 r
.70231 .31763 m .68896 .30515 L .72936 .33254 L p F P
0 g
s
.426 0 0 r
.67402 .29632 m .68896 .30515 L .63923 .28422 L p F P
0 g
s
.426 0 0 r
.63923 .28422 m .62873 .27724 L .67402 .29632 L p F P
0 g
s
0 0 0 r
.24302 .42638 m .23318 .45108 L .21473 .49246 L p F P
0 g
s
0 0 0 r
.20804 .51957 m .21473 .49246 L .23318 .45108 L p F P
0 g
s
0 .518 .773 r
.48225 .90453 m .4732 .90398 L .43962 .89679 L p F P
0 g
s
0 .537 .727 r
.4732 .90398 m .48225 .90453 L .51168 .90748 L p F P
0 g
s
.031 0 0 r
.469 .26605 m .47529 .26414 L .52344 .26014 L p F P
0 g
s
0 0 0 r
.47529 .26414 m .469 .26605 L .41815 .27855 L p F P
0 g
s
.428 0 0 r
.34094 .85058 m .36121 .86314 L .39101 .87903 L p F P
0 g
s
.279 0 0 r
.39101 .87903 m .40944 .88621 L .43962 .89679 L p F P
0 g
s
0 .364 .749 r
.40944 .88621 m .39101 .87903 L .36121 .86314 L p F P
0 g
s
.235 .753 .778 r
.58055 .90352 m .57098 .90415 L .59847 .89798 L p F P
0 g
s
.235 .753 .778 r
.59847 .89798 m .61389 .89604 L .58055 .90352 L p F P
0 g
s
.146 0 0 r
.5717 .26353 m .57748 .26537 L .52317 .26155 L p F P
0 g
s
.146 0 0 r
.52317 .26155 m .52344 .26014 L .5717 .26353 L p F P
0 g
s
.491 0 0 r
.29416 .81131 m .31465 .82907 L .34094 .85058 L p F P
0 g
s
0 .246 .705 r
.36121 .86314 m .34094 .85058 L .31465 .82907 L p F P
0 g
s
.443 .87 .759 r
.66255 .87785 m .64373 .88519 L .66876 .87135 L p F P
0 g
s
.443 .87 .759 r
.66876 .87135 m .69183 .86169 L .66255 .87785 L p F P
0 g
s
.568 .918 .718 r
.71241 .84893 m .69183 .86169 L .71428 .84252 L p F P
0 g
s
.568 .918 .718 r
.71428 .84252 m .738 .82716 L .71241 .84893 L p F P
0 g
s
.867 .534 .022 r
.83523 .489 m .8419 .51609 L .82184 .47459 L p F P
0 g
s
.867 .534 .022 r
.82184 .47459 m .81545 .44776 L .83523 .489 L p F P
0 g
s
.031 0 0 r
.52344 .26014 m .52317 .26155 L .469 .26605 L p F P
0 g
s
0 0 0 r
.30206 .34971 m .28776 .36759 L .25603 .40407 L p F P
0 g
s
0 0 0 r
.24302 .42638 m .25603 .40407 L .28776 .36759 L p F P
0 g
s
0 0 .109 r
.20507 .54798 m .20597 .57736 L .20311 .61827 L p F P
0 g
s
0 0 .305 r
.2079 .64692 m .20311 .61827 L .20597 .57736 L p F P
0 g
s
.782 .318 0 r
.79277 .40093 m .80568 .42313 L .77141 .38564 L p F P
0 g
s
.782 .318 0 r
.77141 .38564 m .75986 .36477 L .79277 .40093 L p F P
0 g
s
.926 .796 .327 r
.84812 .61493 m .8433 .64369 L .83905 .60406 L p F P
0 g
s
.926 .796 .327 r
.83905 .60406 m .84393 .57397 L .84812 .61493 L p F P
0 g
s
0 .522 .836 r
.45455 .89859 m .43962 .89679 L .40944 .88621 L p F P
0 g
s
0 .518 .773 r
.43962 .89679 m .45455 .89859 L .48225 .90453 L p F P
0 g
s
0 0 .532 r
.25544 .76172 m .27462 .78429 L .29416 .81131 L p F P
0 g
s
0 .179 .699 r
.31465 .82907 m .29416 .81131 L .27462 .78429 L p F P
0 g
s
.393 .852 .842 r
.61389 .89604 m .59847 .89798 L .62298 .88905 L p F P
0 g
s
.393 .852 .842 r
.62298 .88905 m .64373 .88519 L .61389 .89604 L p F P
0 g
s
0 0 .407 r
.21664 .67532 m .2293 .70308 L .23983 .73741 L p F P
0 g
s
0 0 .574 r
.25544 .76172 m .23983 .73741 L .2293 .70308 L p F P
0 g
s
.738 .971 .712 r
.75871 .80919 m .738 .82716 L .75461 .8027 L p F P
0 g
s
.738 .971 .712 r
.75461 .8027 m .77736 .78196 L .75871 .80919 L p F P
0 g
s
.87 .948 .59 r
.81241 .73467 m .79668 .75916 L .80521 .72712 L p F P
0 g
s
.87 .948 .59 r
.80521 .72712 m .8218 .70017 L .81241 .73467 L p F P
0 g
s
.079 0 0 r
.40723 .28566 m .41815 .27855 L .469 .26605 L p F P
0 g
s
0 0 0 r
.41815 .27855 m .40723 .28566 L .35819 .30719 L p F P
0 g
s
0 0 0 r
.23318 .45108 m .22673 .47794 L .20804 .51957 L p F P
0 g
s
0 0 .195 r
.20507 .54798 m .20804 .51957 L .22673 .47794 L p F P
0 g
s
.433 0 0 r
.62873 .27724 m .63923 .28422 L .58279 .27118 L p F P
0 g
s
.433 0 0 r
.58279 .27118 m .57748 .26537 L .62873 .27724 L p F P
0 g
s
0 0 0 r
.35819 .30719 m .34453 .31982 L .30206 .34971 L p F P
0 g
s
0 0 0 r
.28776 .36759 m .30206 .34971 L .34453 .31982 L p F P
0 g
s
.735 .211 0 r
.74575 .34703 m .75986 .36477 L .71382 .33375 L p F P
0 g
s
.735 .211 0 r
.71382 .33375 m .70231 .31763 L .74575 .34703 L p F P
0 g
s
.951 .66 .216 r
.8419 .51609 m .84484 .54453 L .82467 .50331 L p F P
0 g
s
.951 .66 .216 r
.82467 .50331 m .82184 .47459 L .8419 .51609 L p F P
0 g
s
0 .246 .705 r
.31465 .82907 m .33813 .8442 L .36121 .86314 L p F P
0 g
s
0 .422 .847 r
.38395 .87259 m .36121 .86314 L .33813 .8442 L p F P
0 g
s
0 .364 .749 r
.36121 .86314 m .38395 .87259 L .40944 .88621 L p F P
0 g
s
0 0 .305 r
.20597 .57736 m .21084 .60734 L .2079 .64692 L p F P
0 g
s
0 0 .466 r
.21664 .67532 m .2079 .64692 L .21084 .60734 L p F P
0 g
s
.031 0 0 r
.34453 .31982 m .35819 .30719 L .40723 .28566 L p F P
0 g
s
.211 .706 .917 r
.5148 .90345 m .51168 .90748 L .48225 .90453 L p F P
0 g
s
.252 .746 .911 r
.51168 .90748 m .5148 .90345 L .53795 .90335 L p F P
0 g
s
.252 .746 .911 r
.53795 .90335 m .54166 .90735 L .51168 .90748 L p F P
0 g
s
0 0 0 r
.28776 .36759 m .27605 .38856 L .24302 .42638 L p F P
0 g
s
0 0 .053 r
.23318 .45108 m .24302 .42638 L .27605 .38856 L p F P
0 g
s
.322 .796 .918 r
.54166 .90735 m .53795 .90335 L .56057 .90087 L p F P
0 g
s
.322 .796 .918 r
.56057 .90087 m .57098 .90415 L .54166 .90735 L p F P
0 g
s
.642 .967 .853 r
.69183 .86169 m .66876 .87135 L .68779 .85498 L p F P
0 g
s
.642 .967 .853 r
.68779 .85498 m .71428 .84252 L .69183 .86169 L p F P
0 g
s
.062 .537 .894 r
.42975 .88988 m .40944 .88621 L .38395 .87259 L p F P
0 g
s
0 .522 .836 r
.40944 .88621 m .42975 .88988 L .45455 .89859 L p F P
0 g
s
.621 .055 0 r
.68896 .30515 m .70231 .31763 L .64862 .29511 L p F P
0 g
s
.621 .055 0 r
.64862 .29511 m .63923 .28422 L .68896 .30515 L p F P
0 g
s
.549 .929 .899 r
.64373 .88519 m .62298 .88905 L .64341 .87768 L p F P
0 g
s
.549 .929 .899 r
.64341 .87768 m .66876 .87135 L .64373 .88519 L p F P
0 g
s
.968 .873 .481 r
.8433 .64369 m .83452 .67223 L .83019 .6344 L p F P
0 g
s
.968 .873 .481 r
.83019 .6344 m .83905 .60406 L .8433 .64369 L p F P
0 g
s
.889 .47 .073 r
.80568 .42313 m .81545 .44776 L .78017 .40946 L p F P
0 g
s
.889 .47 .073 r
.78017 .40946 m .77141 .38564 L .80568 .42313 L p F P
0 g
s
.201 .679 .934 r
.49209 .90117 m .48225 .90453 L .45455 .89859 L p F P
0 g
s
.211 .706 .917 r
.48225 .90453 m .49209 .90117 L .5148 .90345 L p F P
0 g
s
.413 .85 .935 r
.57098 .90415 m .56057 .90087 L .58173 .8961 L p F P
0 g
s
.413 .85 .935 r
.58173 .8961 m .59847 .89798 L .57098 .90415 L p F P
0 g
s
.257 0 0 r
.46321 .27193 m .469 .26605 L .52317 .26155 L p F P
0 g
s
.079 0 0 r
.469 .26605 m .46321 .27193 L .40723 .28566 L p F P
0 g
s
0 0 .574 r
.2293 .70308 m .24583 .72982 L .25544 .76172 L p F P
0 g
s
0 .162 .701 r
.27462 .78429 m .25544 .76172 L .24583 .72982 L p F P
0 g
s
.373 0 0 r
.57748 .26537 m .58279 .27118 L .52293 .26699 L p F P
0 g
s
.373 0 0 r
.52293 .26699 m .52317 .26155 L .57748 .26537 L p F P
0 g
s
0 .179 .699 r
.27462 .78429 m .29722 .8048 L .31465 .82907 L p F P
0 g
s
0 .341 .818 r
.33813 .8442 m .31465 .82907 L .29722 .8048 L p F P
0 g
s
.769 .997 .823 r
.738 .82716 m .71428 .84252 L .72865 .82106 L p F P
0 g
s
.769 .997 .823 r
.72865 .82106 m .75461 .8027 L .738 .82716 L p F P
0 g
s
.889 .984 .71 r
.79668 .75916 m .77736 .78196 L .78489 .75269 L p F P
0 g
s
.889 .984 .71 r
.78489 .75269 m .80521 .72712 L .79668 .75916 L p F P
0 g
s
.257 0 0 r
.52317 .26155 m .52293 .26699 L .46321 .27193 L p F P
0 g
s
0 0 .195 r
.22673 .47794 m .22387 .50664 L .20507 .54798 L p F P
0 g
s
0 0 .357 r
.20597 .57736 m .20507 .54798 L .22387 .50664 L p F P
0 g
s
.22 .662 .953 r
.47078 .89658 m .45455 .89859 L .42975 .88988 L p F P
0 g
s
.201 .679 .934 r
.45455 .89859 m .47078 .89658 L .49209 .90117 L p F P
0 g
s
.512 .897 .954 r
.59847 .89798 m .58173 .8961 L .6005 .88922 L p F P
0 g
s
.512 .897 .954 r
.6005 .88922 m .62298 .88905 L .59847 .89798 L p F P
0 g
s
0 0 .466 r
.21084 .60734 m .2197 .63753 L .21664 .67532 L p F P
0 g
s
0 .047 .591 r
.2293 .70308 m .21664 .67532 L .2197 .63753 L p F P
0 g
s
.99 .743 .372 r
.84484 .54453 m .84393 .57397 L .82379 .53359 L p F P
0 g
s
.99 .743 .372 r
.82379 .53359 m .82467 .50331 L .84484 .54453 L p F P
0 g
s
0 0 0 r
.34453 .31982 m .33275 .33606 L .28776 .36759 L p F P
0 g
s
.057 0 .056 r
.27605 .38856 m .28776 .36759 L .33275 .33606 L p F P
0 g
s
.977 .915 .6 r
.83452 .67223 m .8218 .70017 L .81736 .66457 L p F P
0 g
s
.977 .915 .6 r
.81736 .66457 m .83019 .6344 L .83452 .67223 L p F P
0 g
s
0 .422 .847 r
.33813 .8442 m .36436 .85641 L .38395 .87259 L p F P
0 g
s
.161 .552 .929 r
.40893 .8787 m .38395 .87259 L .36436 .85641 L p F P
0 g
s
.062 .537 .894 r
.38395 .87259 m .40893 .8787 L .42975 .88988 L p F P
0 g
s
0 0 .053 r
.27605 .38856 m .26717 .41245 L .23318 .45108 L p F P
0 g
s
0 0 .231 r
.22673 .47794 m .23318 .45108 L .26717 .41245 L p F P
0 g
s
.833 .364 .07 r
.75986 .36477 m .77141 .38564 L .72326 .35341 L p F P
0 g
s
.833 .364 .07 r
.72326 .35341 m .71382 .33375 L .75986 .36477 L p F P
0 g
s
.259 0 0 r
.39746 .29667 m .40723 .28566 L .46321 .27193 L p F P
0 g
s
.031 0 0 r
.40723 .28566 m .39746 .29667 L .34453 .31982 L p F P
0 g
s
.675 .966 .93 r
.66876 .87135 m .64341 .87768 L .65879 .8643 L p F P
0 g
s
.675 .966 .93 r
.65879 .8643 m .68779 .85498 L .66876 .87135 L p F P
0 g
s
.593 .048 0 r
.63923 .28422 m .64862 .29511 L .58756 .28107 L p F P
0 g
s
.593 .048 0 r
.58756 .28107 m .58279 .27118 L .63923 .28422 L p F P
0 g
s
0 .162 .701 r
.24583 .72982 m .2661 .75515 L .27462 .78429 L p F P
0 g
s
.026 .299 .791 r
.29722 .8048 m .27462 .78429 L .2661 .75515 L p F P
0 g
s
.942 .576 .245 r
.81545 .44776 m .82184 .47459 L .7859 .43601 L p F P
0 g
s
.942 .576 .245 r
.7859 .43601 m .78017 .40946 L .81545 .44776 L p F P
0 g
s
0 .341 .818 r
.29722 .8048 m .32302 .8229 L .33813 .8442 L p F P
0 g
s
.124 .467 .892 r
.36436 .85641 m .33813 .8442 L .32302 .8229 L p F P
0 g
s
.19 0 .006 r
.33275 .33606 m .34453 .31982 L .39746 .29667 L p F P
0 g
s
.261 .65 .965 r
.45176 .88986 m .42975 .88988 L .40893 .8787 L p F P
0 g
s
.22 .662 .953 r
.42975 .88988 m .45176 .88986 L .47078 .89658 L p F P
0 g
s
.884 .99 .795 r
.77736 .78196 m .75461 .8027 L .76104 .7765 L p F P
0 g
s
.884 .99 .795 r
.76104 .7765 m .78489 .75269 L .77736 .78196 L p F P
0 g
s
.606 .928 .966 r
.62298 .88905 m .6005 .88922 L .61605 .88049 L p F P
0 g
s
.606 .928 .966 r
.61605 .88049 m .64341 .87768 L .62298 .88905 L p F P
0 g
s
.772 .989 .894 r
.71428 .84252 m .68779 .85498 L .69977 .83673 L p F P
0 g
s
.772 .989 .894 r
.69977 .83673 m .72865 .82106 L .71428 .84252 L p F P
0 g
s
.735 .228 .016 r
.70231 .31763 m .71382 .33375 L .65673 .30994 L p F P
0 g
s
.735 .228 .016 r
.65673 .30994 m .64862 .29511 L .70231 .31763 L p F P
0 g
s
0 0 .357 r
.22387 .50664 m .22474 .53684 L .20597 .57736 L p F P
0 g
s
.004 0 .482 r
.21084 .60734 m .20597 .57736 L .22474 .53684 L p F P
0 g
s
.403 .783 .992 r
.51815 .89533 m .5148 .90345 L .49209 .90117 L p F P
0 g
s
.431 .811 .991 r
.5148 .90345 m .51815 .89533 L .53397 .89526 L p F P
0 g
s
.431 .811 .991 r
.53397 .89526 m .53795 .90335 L .5148 .90345 L p F P
0 g
s
.473 .839 .992 r
.53795 .90335 m .53397 .89526 L .54941 .89356 L p F P
0 g
s
.473 .839 .992 r
.54941 .89356 m .56057 .90087 L .53795 .90335 L p F P
0 g
s
0 .047 .591 r
.2197 .63753 m .23253 .66751 L .2293 .70308 L p F P
0 g
s
.034 .179 .684 r
.24583 .72982 m .2293 .70308 L .23253 .66751 L p F P
0 g
s
.391 .758 .992 r
.50264 .89376 m .49209 .90117 L .47078 .89658 L p F P
0 g
s
.403 .783 .992 r
.49209 .90117 m .50264 .89376 L .51815 .89533 L p F P
0 g
s
.999 .795 .491 r
.84393 .57397 m .83905 .60406 L .81912 .56502 L p F P
0 g
s
.999 .795 .491 r
.81912 .56502 m .82379 .53359 L .84393 .57397 L p F P
0 g
s
.524 .865 .993 r
.56057 .90087 m .54941 .89356 L .56382 .89029 L p F P
0 g
s
.524 .865 .993 r
.56382 .89029 m .58173 .8961 L .56057 .90087 L p F P
0 g
s
.414 0 0 r
.45802 .28188 m .46321 .27193 L .52293 .26699 L p F P
0 g
s
.259 0 0 r
.46321 .27193 m .45802 .28188 L .39746 .29667 L p F P
0 g
s
.522 0 0 r
.58279 .27118 m .58756 .28107 L .52271 .27655 L p F P
0 g
s
.522 0 0 r
.52271 .27655 m .52293 .26699 L .58279 .27118 L p F P
0 g
s
.967 .933 .688 r
.8218 .70017 m .80521 .72712 L .80067 .69414 L p F P
0 g
s
.967 .933 .688 r
.80067 .69414 m .81736 .66457 L .8218 .70017 L p F P
0 g
s
.026 .299 .791 r
.2661 .75515 m .28989 .7787 L .29722 .8048 L p F P
0 g
s
.155 .409 .852 r
.32302 .8229 m .29722 .8048 L .28989 .7787 L p F P
0 g
s
.414 0 0 r
.52293 .26699 m .52271 .27655 L .45802 .28188 L p F P
0 g
s
.394 .736 .992 r
.48812 .89061 m .47078 .89658 L .45176 .88986 L p F P
0 g
s
.391 .758 .992 r
.47078 .89658 m .48812 .89061 L .50264 .89376 L p F P
0 g
s
0 0 .231 r
.26717 .41245 m .26135 .43902 L .22673 .47794 L p F P
0 g
s
.106 0 .367 r
.22387 .50664 m .22673 .47794 L .26135 .43902 L p F P
0 g
s
.057 0 .056 r
.33275 .33606 m .32309 .35582 L .27605 .38856 L p F P
0 g
s
.177 0 .224 r
.26717 .41245 m .27605 .38856 L .32309 .35582 L p F P
0 g
s
.579 .885 .991 r
.58173 .8961 m .56382 .89029 L .57655 .88558 L p F P
0 g
s
.579 .885 .991 r
.57655 .88558 m .6005 .88922 L .58173 .8961 L p F P
0 g
s
.161 .552 .929 r
.36436 .85641 m .39308 .86546 L .40893 .8787 L p F P
0 g
s
.315 .642 .967 r
.4359 .88127 m .40893 .8787 L .39308 .86546 L p F P
0 g
s
.261 .65 .965 r
.40893 .8787 m .4359 .88127 L .45176 .88986 L p F P
0 g
s
.863 .979 .853 r
.75461 .8027 m .72865 .82106 L .73393 .79817 L p F P
0 g
s
.863 .979 .853 r
.73393 .79817 m .76104 .7765 L .75461 .8027 L p F P
0 g
s
.681 .936 .966 r
.64341 .87768 m .61605 .88049 L .62764 .87025 L p F P
0 g
s
.681 .936 .966 r
.62764 .87025 m .65879 .8643 L .64341 .87768 L p F P
0 g
s
.124 .467 .892 r
.32302 .8229 m .35174 .83829 L .36436 .85641 L p F P
0 g
s
.262 .563 .935 r
.39308 .86546 m .36436 .85641 L .35174 .83829 L p F P
0 g
s
.88 .47 .235 r
.77141 .38564 m .78017 .40946 L .73043 .3765 L p F P
0 g
s
.88 .47 .235 r
.73043 .3765 m .72326 .35341 L .77141 .38564 L p F P
0 g
s
.962 .647 .376 r
.82184 .47459 m .82467 .50331 L .78844 .46498 L p F P
0 g
s
.962 .647 .376 r
.78844 .46498 m .7859 .43601 L .82184 .47459 L p F P
0 g
s
.757 .962 .934 r
.68779 .85498 m .65879 .8643 L .6683 .84944 L p F P
0 g
s
.757 .962 .934 r
.6683 .84944 m .69977 .83673 L .68779 .85498 L p F P
0 g
s
.004 0 .482 r
.22474 .53684 m .22943 .56817 L .21084 .60734 L p F P
0 g
s
.107 .109 .577 r
.2197 .63753 m .21084 .60734 L .22943 .56817 L p F P
0 g
s
.034 .179 .684 r
.23253 .66751 m .24923 .69686 L .24583 .72982 L p F P
0 g
s
.141 .287 .753 r
.2661 .75515 m .24583 .72982 L .24923 .69686 L p F P
0 g
s
.381 0 .098 r
.38901 .31159 m .39746 .29667 L .45802 .28188 L p F P
0 g
s
.19 0 .006 r
.39746 .29667 m .38901 .31159 L .33275 .33606 L p F P
0 g
s
.409 .717 .987 r
.47523 .88602 m .45176 .88986 L .4359 .88127 L p F P
0 g
s
.394 .736 .992 r
.45176 .88986 m .47523 .88602 L .48812 .89061 L p F P
0 g
s
.683 .203 .103 r
.64862 .29511 m .65673 .30994 L .59167 .29508 L p F P
0 g
s
.683 .203 .103 r
.59167 .29508 m .58756 .28107 L .64862 .29511 L p F P
0 g
s
.991 .827 .582 r
.83905 .60406 m .83019 .6344 L .81062 .59718 L p F P
0 g
s
.991 .827 .582 r
.81062 .59718 m .81912 .56502 L .83905 .60406 L p F P
0 g
s
.301 0 .182 r
.32309 .35582 m .33275 .33606 L .38901 .31159 L p F P
0 g
s
.945 .937 .755 r
.80521 .72712 m .78489 .75269 L .78028 .72267 L p F P
0 g
s
.945 .937 .755 r
.78028 .72267 m .80067 .69414 L .80521 .72712 L p F P
0 g
s
.63 .895 .986 r
.6005 .88922 m .57655 .88558 L .58701 .87963 L p F P
0 g
s
.63 .895 .986 r
.58701 .87963 m .61605 .88049 L .6005 .88922 L p F P
0 g
s
.795 .35 .19 r
.71382 .33375 m .72326 .35341 L .6634 .32866 L p F P
0 g
s
.795 .35 .19 r
.6634 .32866 m .65673 .30994 L .71382 .33375 L p F P
0 g
s
.155 .409 .852 r
.28989 .7787 m .31694 .80009 L .32302 .8229 L p F P
0 g
s
.262 .498 .894 r
.35174 .83829 m .32302 .8229 L .31694 .80009 L p F P
0 g
s
.834 .958 .893 r
.72865 .82106 m .69977 .83673 L .70389 .81735 L p F P
0 g
s
.834 .958 .893 r
.70389 .81735 m .73393 .79817 L .72865 .82106 L p F P
0 g
s
.106 0 .367 r
.26135 .43902 m .25876 .46798 L .22387 .50664 L p F P
0 g
s
.195 .068 .47 r
.22474 .53684 m .22387 .50664 L .25876 .46798 L p F P
0 g
s
.525 .799 .996 r
.52169 .88304 m .51815 .89533 L .50264 .89376 L p F P
0 g
s
.54 .814 .997 r
.51815 .89533 m .52169 .88304 L .52976 .88301 L p F P
0 g
s
.54 .814 .997 r
.52976 .88301 m .53397 .89526 L .51815 .89533 L p F P
0 g
s
.561 .828 .996 r
.53397 .89526 m .52976 .88301 L .53764 .88213 L p F P
0 g
s
.561 .828 .996 r
.53764 .88213 m .54941 .89356 L .53397 .89526 L p F P
0 g
s
.262 .563 .935 r
.35174 .83829 m .38304 .85071 L .39308 .86546 L p F P
0 g
s
.372 .635 .956 r
.42395 .87114 m .39308 .86546 L .38304 .85071 L p F P
0 g
s
.315 .642 .967 r
.39308 .86546 m .42395 .87114 L .4359 .88127 L p F P
0 g
s
.141 .287 .753 r
.24923 .69686 m .26965 .72514 L .2661 .75515 L p F P
0 g
s
.229 .377 .805 r
.28989 .7787 m .2661 .75515 L .26965 .72514 L p F P
0 g
s
.516 .784 .993 r
.51379 .88224 m .50264 .89376 L .48812 .89061 L p F P
0 g
s
.525 .799 .996 r
.50264 .89376 m .51379 .88224 L .52169 .88304 L p F P
0 g
s
.107 .109 .577 r
.22943 .56817 m .23795 .60018 L .2197 .63753 L p F P
0 g
s
.191 .21 .65 r
.23253 .66751 m .2197 .63753 L .23795 .60018 L p F P
0 g
s
.585 .839 .993 r
.54941 .89356 m .53764 .88213 L .54496 .88045 L p F P
0 g
s
.585 .839 .993 r
.54496 .88045 m .56382 .89029 L .54941 .89356 L p F P
0 g
s
.433 .702 .978 r
.46455 .88016 m .4359 .88127 L .42395 .87114 L p F P
0 g
s
.409 .717 .987 r
.4359 .88127 m .46455 .88016 L .47523 .88602 L p F P
0 g
s
.734 .925 .955 r
.65879 .8643 m .62764 .87025 L .63466 .85894 L p F P
0 g
s
.734 .925 .955 r
.63466 .85894 m .6683 .84944 L .65879 .8643 L p F P
0 g
s
.177 0 .224 r
.32309 .35582 m .31575 .37896 L .26717 .41245 L p F P
0 g
s
.266 .025 .349 r
.26135 .43902 m .26717 .41245 L .31575 .37896 L p F P
0 g
s
.963 .694 .476 r
.82467 .50331 m .82379 .53359 L .78765 .49603 L p F P
0 g
s
.963 .694 .476 r
.78765 .49603 m .78844 .46498 L .82467 .50331 L p F P
0 g
s
.673 .895 .977 r
.61605 .88049 m .58701 .87963 L .59473 .87268 L p F P
0 g
s
.673 .895 .977 r
.59473 .87268 m .62764 .87025 L .61605 .88049 L p F P
0 g
s
.511 .071 .139 r
.45354 .29594 m .45802 .28188 L .52271 .27655 L p F P
0 g
s
.381 0 .098 r
.45802 .28188 m .45354 .29594 L .38901 .31159 L p F P
0 g
s
.608 .15 .14 r
.58756 .28107 m .59167 .29508 L .52251 .29029 L p F P
0 g
s
.608 .15 .14 r
.52251 .29029 m .52271 .27655 L .58756 .28107 L p F P
0 g
s
.916 .932 .805 r
.78489 .75269 m .76104 .7765 L .75642 .74971 L p F P
0 g
s
.916 .932 .805 r
.75642 .74971 m .78028 .72267 L .78489 .75269 L p F P
0 g
s
.9 .542 .356 r
.78017 .40946 m .7859 .43601 L .73512 .40277 L p F P
0 g
s
.9 .542 .356 r
.73512 .40277 m .73043 .3765 L .78017 .40946 L p F P
0 g
s
.974 .845 .653 r
.83019 .6344 m .81736 .66457 L .79836 .62962 L p F P
0 g
s
.974 .845 .653 r
.79836 .62962 m .81062 .59718 L .83019 .6344 L p F P
0 g
s
.513 .768 .989 r
.5064 .88062 m .48812 .89061 L .47523 .88602 L p F P
0 g
s
.516 .784 .993 r
.48812 .89061 m .5064 .88062 L .51379 .88224 L p F P
0 g
s
.61 .847 .988 r
.56382 .89029 m .54496 .88045 L .5514 .87804 L p F P
0 g
s
.61 .847 .988 r
.5514 .87804 m .57655 .88558 L .56382 .89029 L p F P
0 g
s
.262 .498 .894 r
.31694 .80009 m .34692 .81897 L .35174 .83829 L p F P
0 g
s
.351 .57 .921 r
.38304 .85071 m .35174 .83829 L .34692 .81897 L p F P
0 g
s
.511 .071 .139 r
.52271 .27655 m .52251 .29029 L .45354 .29594 L p F P
0 g
s
.8 .931 .919 r
.69977 .83673 m .6683 .84944 L .67132 .83374 L p F P
0 g
s
.8 .931 .919 r
.67132 .83374 m .70389 .81735 L .69977 .83673 L p F P
0 g
s
.516 .755 .983 r
.49988 .87826 m .47523 .88602 L .46455 .88016 L p F P
0 g
s
.513 .768 .989 r
.47523 .88602 m .49988 .87826 L .5064 .88062 L p F P
0 g
s
.635 .85 .982 r
.57655 .88558 m .5514 .87804 L .55665 .875 L p F P
0 g
s
.635 .85 .982 r
.55665 .875 m .58701 .87963 L .57655 .88558 L p F P
0 g
s
.229 .377 .805 r
.26965 .72514 m .29354 .75191 L .28989 .7787 L p F P
0 g
s
.305 .453 .845 r
.31694 .80009 m .28989 .7787 L .29354 .75191 L p F P
0 g
s
.301 0 .182 r
.38901 .31159 m .38208 .33037 L .32309 .35582 L p F P
0 g
s
.379 .07 .311 r
.31575 .37896 m .32309 .35582 L .38208 .33037 L p F P
0 g
s
.459 .088 .247 r
.38208 .33037 m .38901 .31159 L .45354 .29594 L p F P
0 g
s
.191 .21 .65 r
.23795 .60018 m .25028 .63243 L .23253 .66751 L p F P
0 g
s
.26 .294 .708 r
.24923 .69686 m .23253 .66751 L .25028 .63243 L p F P
0 g
s
.195 .068 .47 r
.25876 .46798 m .25955 .49896 L .22474 .53684 L p F P
0 g
s
.264 .164 .549 r
.22943 .56817 m .22474 .53684 L .25955 .49896 L p F P
0 g
s
.372 .635 .956 r
.38304 .85071 m .41652 .8599 L .42395 .87114 L p F P
0 g
s
.462 .689 .965 r
.45658 .87329 m .42395 .87114 L .41652 .8599 L p F P
0 g
s
.433 .702 .978 r
.42395 .87114 m .45658 .87329 L .46455 .88016 L p F P
0 g
s
.884 .921 .843 r
.76104 .7765 m .73393 .79817 L .72942 .77486 L p F P
0 g
s
.884 .921 .843 r
.72942 .77486 m .75642 .74971 L .76104 .7765 L p F P
0 g
s
.731 .311 .25 r
.65673 .30994 m .6634 .32866 L .59506 .31319 L p F P
0 g
s
.731 .311 .25 r
.59506 .31319 m .59167 .29508 L .65673 .30994 L p F P
0 g
s
.823 .434 .316 r
.72326 .35341 m .73043 .3765 L .66846 .35114 L p F P
0 g
s
.823 .434 .316 r
.66846 .35114 m .6634 .32866 L .72326 .35341 L p F P
0 g
s
.705 .885 .964 r
.62764 .87025 m .59473 .87268 L .59929 .86505 L p F P
0 g
s
.705 .885 .964 r
.59929 .86505 m .63466 .85894 L .62764 .87025 L p F P
0 g
s
.952 .855 .708 r
.81736 .66457 m .80067 .69414 L .78243 .66184 L p F P
0 g
s
.952 .855 .708 r
.78243 .66184 m .79836 .62962 L .81736 .66457 L p F P
0 g
s
.955 .727 .553 r
.82379 .53359 m .81912 .56502 L .78345 .52874 L p F P
0 g
s
.955 .727 .553 r
.78345 .52874 m .78765 .49603 L .82379 .53359 L p F P
0 g
s
.524 .742 .975 r
.49451 .87527 m .46455 .88016 L .45658 .87329 L p F P
0 g
s
.516 .755 .983 r
.46455 .88016 m .49451 .87527 L .49988 .87826 L p F P
0 g
s
.351 .57 .921 r
.34692 .81897 m .37945 .83505 L .38304 .85071 L p F P
0 g
s
.427 .63 .939 r
.41652 .8599 m .38304 .85071 L .37945 .83505 L p F P
0 g
s
.656 .849 .974 r
.58701 .87963 m .55665 .875 L .56048 .87148 L p F P
0 g
s
.656 .849 .974 r
.56048 .87148 m .59473 .87268 L .58701 .87963 L p F P
0 g
s
.266 .025 .349 r
.31575 .37896 m .31094 .40525 L .26135 .43902 L p F P
0 g
s
.332 .126 .444 r
.25876 .46798 m .26135 .43902 L .31094 .40525 L p F P
0 g
s
.764 .901 .937 r
.6683 .84944 m .63466 .85894 L .63667 .84705 L p F P
0 g
s
.764 .901 .937 r
.63667 .84705 m .67132 .83374 L .6683 .84944 L p F P
0 g
s
.305 .453 .845 r
.29354 .75191 m .3206 .77677 L .31694 .80009 L p F P
0 g
s
.369 .518 .875 r
.34692 .81897 m .31694 .80009 L .3206 .77677 L p F P
0 g
s
.904 .594 .448 r
.7859 .43601 m .78844 .46498 L .7372 .43195 L p F P
0 g
s
.904 .594 .448 r
.7372 .43195 m .73512 .40277 L .7859 .43601 L p F P
0 g
s
.599 .789 .972 r
.52538 .86658 m .52169 .88304 L .51379 .88224 L closepath p F P
0 g
s
.604 .794 .972 r
.52538 .86658 m .52976 .88301 L .52169 .88304 L closepath p F P
0 g
s
.61 .798 .971 r
.52538 .86658 m .53764 .88213 L .52976 .88301 L closepath p F P
0 g
s
.85 .906 .873 r
.73393 .79817 m .70389 .81735 L .69963 .79771 L p F P
0 g
s
.85 .906 .873 r
.69963 .79771 m .72942 .77486 L .73393 .79817 L p F P
0 g
s
.26 .294 .708 r
.25028 .63243 m .2663 .66443 L .24923 .69686 L p F P
0 g
s
.319 .366 .754 r
.26965 .72514 m .24923 .69686 L .2663 .66443 L p F P
0 g
s
.596 .784 .97 r
.52538 .86658 m .51379 .88224 L .5064 .88062 L closepath p F P
0 g
s
.616 .801 .97 r
.52538 .86658 m .54496 .88045 L .53764 .88213 L closepath p F P
0 g
s
.57 .186 .274 r
.44984 .31408 m .45354 .29594 L .52251 .29029 L p F P
0 g
s
.459 .088 .247 r
.45354 .29594 m .44984 .31408 L .38208 .33037 L p F P
0 g
s
.462 .689 .965 r
.41652 .8599 m .45174 .86569 L .45658 .87329 L p F P
0 g
s
.535 .732 .965 r
.49055 .87178 m .45658 .87329 L .45174 .86569 L p F P
0 g
s
.524 .742 .975 r
.45658 .87329 m .49055 .87178 L .49451 .87527 L p F P
0 g
s
.594 .779 .969 r
.52538 .86658 m .5064 .88062 L .49988 .87826 L closepath p F P
0 g
s
.623 .803 .968 r
.52538 .86658 m .5514 .87804 L .54496 .88045 L closepath p F P
0 g
s
.657 .257 .275 r
.59167 .29508 m .59506 .31319 L .52235 .30819 L p F P
0 g
s
.657 .257 .275 r
.52235 .30819 m .52251 .29029 L .59167 .29508 L p F P
0 g
s
.674 .844 .964 r
.59473 .87268 m .56048 .87148 L .56269 .86762 L p F P
0 g
s
.674 .844 .964 r
.56269 .86762 m .59929 .86505 L .59473 .87268 L p F P
0 g
s
.264 .164 .549 r
.25955 .49896 m .26378 .53157 L .22943 .56817 L p F P
0 g
s
.32 .244 .612 r
.23795 .60018 m .22943 .56817 L .26378 .53157 L p F P
0 g
s
.927 .859 .753 r
.80067 .69414 m .78028 .72267 L .76302 .69335 L p F P
0 g
s
.927 .859 .753 r
.76302 .69335 m .78243 .66184 L .80067 .69414 L p F P
0 g
s
.427 .63 .939 r
.37945 .83505 m .41407 .84804 L .41652 .8599 L p F P
0 g
s
.492 .68 .949 r
.45174 .86569 m .41652 .8599 L .41407 .84804 L p F P
0 g
s
.726 .869 .948 r
.63466 .85894 m .59929 .86505 L .60044 .85706 L p F P
0 g
s
.726 .869 .948 r
.60044 .85706 m .63667 .84705 L .63466 .85894 L p F P
0 g
s
.594 .774 .966 r
.52538 .86658 m .49988 .87826 L .49451 .87527 L closepath p F P
0 g
s
.63 .803 .966 r
.52538 .86658 m .55665 .875 L .5514 .87804 L closepath p F P
0 g
s
.369 .518 .875 r
.3206 .77677 m .35046 .79932 L .34692 .81897 L p F P
0 g
s
.426 .576 .899 r
.37945 .83505 m .34692 .81897 L .35046 .79932 L p F P
0 g
s
.942 .749 .613 r
.81912 .56502 m .81062 .59718 L .77583 .56264 L p F P
0 g
s
.942 .749 .613 r
.77583 .56264 m .78345 .52874 L .81912 .56502 L p F P
0 g
s
.57 .186 .274 r
.52251 .29029 m .52235 .30819 L .44984 .31408 L p F P
0 g
s
.814 .889 .897 r
.70389 .81735 m .67132 .83374 L .66748 .8179 L p F P
0 g
s
.814 .889 .897 r
.66748 .8179 m .69963 .79771 L .70389 .81735 L p F P
0 g
s
.379 .07 .311 r
.38208 .33037 m .3768 .35289 L .31575 .37896 L p F P
0 g
s
.433 .165 .407 r
.31094 .40525 m .31575 .37896 L .3768 .35289 L p F P
0 g
s
.595 .77 .963 r
.52538 .86658 m .49451 .87527 L .49055 .87178 L closepath p F P
0 g
s
.636 .803 .963 r
.52538 .86658 m .56048 .87148 L .55665 .875 L closepath p F P
0 g
s
.319 .366 .754 r
.2663 .66443 m .28582 .6957 L .26965 .72514 L p F P
0 g
s
.369 .429 .792 r
.29354 .75191 m .26965 .72514 L .28582 .6957 L p F P
0 g
s
.835 .494 .41 r
.73043 .3765 m .73512 .40277 L .67178 .37719 L p F P
0 g
s
.835 .494 .41 r
.67178 .37719 m .66846 .35114 L .73043 .3765 L p F P
0 g
s
.51 .186 .354 r
.3768 .35289 m .38208 .33037 L .44984 .31408 L p F P
0 g
s
.492 .68 .949 r
.41407 .84804 m .45029 .85772 L .45174 .86569 L p F P
0 g
s
.55 .724 .955 r
.4882 .86795 m .45174 .86569 L .45029 .85772 L p F P
0 g
s
.535 .732 .965 r
.45174 .86569 m .4882 .86795 L .49055 .87178 L p F P
0 g
s
.332 .126 .444 r
.31094 .40525 m .3088 .43442 L .25876 .46798 L p F P
0 g
s
.382 .207 .516 r
.25955 .49896 m .25876 .46798 L .3088 .43442 L p F P
0 g
s
.756 .388 .356 r
.6634 .32866 m .66846 .35114 L .59763 .33528 L p F P
0 g
s
.756 .388 .356 r
.59763 .33528 m .59506 .31319 L .6634 .32866 L p F P
0 g
s
.687 .835 .954 r
.59929 .86505 m .56269 .86762 L .56316 .86361 L p F P
0 g
s
.687 .835 .954 r
.56316 .86361 m .60044 .85706 L .59929 .86505 L p F P
0 g
s
.426 .576 .899 r
.35046 .79932 m .3827 .81919 L .37945 .83505 L p F P
0 g
s
.477 .627 .918 r
.41407 .84804 m .37945 .83505 L .3827 .81919 L p F P
0 g
s
.901 .859 .791 r
.78028 .72267 m .75642 .74971 L .7404 .72365 L p F P
0 g
s
.901 .859 .791 r
.7404 .72365 m .76302 .69335 L .78028 .72267 L p F P
0 g
s
.597 .766 .96 r
.52538 .86658 m .49055 .87178 L .4882 .86795 L closepath p F P
0 g
s
.642 .801 .96 r
.52538 .86658 m .56269 .86762 L .56048 .87148 L closepath p F P
0 g
s
.777 .869 .916 r
.67132 .83374 m .63667 .84705 L .63346 .83511 L p F P
0 g
s
.777 .869 .916 r
.63346 .83511 m .66748 .8179 L .67132 .83374 L p F P
0 g
s
.901 .631 .519 r
.78844 .46498 m .78765 .49603 L .73655 .46367 L p F P
0 g
s
.901 .631 .519 r
.73655 .46367 m .7372 .43195 L .78844 .46498 L p F P
0 g
s
.32 .244 .612 r
.26378 .53157 m .27148 .56534 L .23795 .60018 L p F P
0 g
s
.366 .311 .663 r
.25028 .63243 m .23795 .60018 L .27148 .56534 L p F P
0 g
s
.477 .627 .918 r
.3827 .81919 m .41683 .83609 L .41407 .84804 L p F P
0 g
s
.523 .674 .933 r
.45029 .85772 m .41407 .84804 L .41683 .83609 L p F P
0 g
s
.55 .724 .955 r
.45029 .85772 m .48758 .86394 L .4882 .86795 L p F P
0 g
s
.601 .763 .956 r
.52538 .86658 m .4882 .86795 L .48758 .86394 L closepath p F P
0 g
s
.369 .429 .792 r
.28582 .6957 m .30859 .72574 L .29354 .75191 L p F P
0 g
s
.412 .484 .824 r
.3206 .77677 m .29354 .75191 L .30859 .72574 L p F P
0 g
s
.646 .799 .956 r
.52538 .86658 m .56316 .86361 L .56269 .86762 L closepath p F P
0 g
s
.926 .766 .663 r
.81062 .59718 m .79836 .62962 L .76485 .59724 L p F P
0 g
s
.926 .766 .663 r
.76485 .59724 m .77583 .56264 L .81062 .59718 L p F P
0 g
s
.737 .847 .932 r
.63667 .84705 m .60044 .85706 L .59808 .84909 L p F P
0 g
s
.737 .847 .932 r
.59808 .84909 m .63346 .83511 L .63667 .84705 L p F P
0 g
s
.873 .856 .822 r
.75642 .74971 m .72942 .77486 L .71488 .75228 L p F P
0 g
s
.873 .856 .822 r
.71488 .75228 m .7404 .72365 L .75642 .74971 L p F P
0 g
s
.523 .674 .933 r
.41683 .83609 m .45235 .84974 L .45029 .85772 L p F P
0 g
s
.565 .718 .944 r
.48758 .86394 m .45029 .85772 L .45235 .84974 L p F P
0 g
s
.695 .823 .944 r
.60044 .85706 m .56316 .86361 L .56187 .85963 L p F P
0 g
s
.695 .823 .944 r
.56187 .85963 m .59808 .84909 L .60044 .85706 L p F P
0 g
s
.652 .787 .946 r
.52538 .86658 m .55424 .85251 L .55885 .85586 L closepath p F P
0 g
s
.652 .782 .943 r
.52538 .86658 m .54824 .84971 L .55424 .85251 L closepath p F P
0 g
s
.65 .777 .941 r
.52538 .86658 m .54114 .84762 L .54824 .84971 L closepath p F P
0 g
s
.647 .772 .94 r
.52538 .86658 m .53328 .84634 L .54114 .84762 L closepath p F P
0 g
s
.644 .768 .939 r
.52538 .86658 m .52503 .84593 L .53328 .84634 L closepath p F P
0 g
s
.639 .765 .939 r
.52538 .86658 m .5168 .84641 L .52503 .84593 L closepath p F P
0 g
s
.634 .762 .94 r
.52538 .86658 m .50899 .84776 L .5168 .84641 L closepath p F P
0 g
s
.628 .759 .941 r
.52538 .86658 m .50197 .84992 L .50899 .84776 L closepath p F P
0 g
s
.622 .758 .943 r
.52538 .86658 m .49608 .85276 L .50197 .84992 L closepath p F P
0 g
s
.617 .758 .946 r
.52538 .86658 m .4916 .85616 L .49608 .85276 L closepath p F P
0 g
s
.611 .758 .949 r
.52538 .86658 m .48872 .85995 L .4916 .85616 L closepath p F P
0 g
s
.606 .76 .953 r
.52538 .86658 m .48758 .86394 L .48872 .85995 L closepath p F P
0 g
s
.65 .795 .952 r
.52538 .86658 m .56187 .85963 L .56316 .86361 L closepath p F P
0 g
s
.652 .791 .949 r
.52538 .86658 m .55885 .85586 L .56187 .85963 L closepath p F P
0 g
s
.565 .718 .944 r
.45235 .84974 m .48872 .85995 L .48758 .86394 L p F P
0 g
s
.412 .484 .824 r
.30859 .72574 m .33428 .75408 L .3206 .77677 L p F P
0 g
s
.452 .535 .852 r
.35046 .79932 m .3206 .77677 L .33428 .75408 L p F P
0 g
s
.607 .269 .372 r
.44704 .3362 m .44984 .31408 L .52235 .30819 L p F P
0 g
s
.51 .186 .354 r
.44984 .31408 m .44704 .3362 L .3768 .35289 L p F P
0 g
s
.686 .334 .373 r
.59506 .31319 m .59763 .33528 L .52223 .33016 L p F P
0 g
s
.686 .334 .373 r
.52223 .33016 m .52235 .30819 L .59506 .31319 L p F P
0 g
s
.433 .165 .407 r
.3768 .35289 m .37334 .37896 L .31094 .40525 L p F P
0 g
s
.473 .24 .479 r
.3088 .43442 m .31094 .40525 L .37334 .37896 L p F P
0 g
s
.366 .311 .663 r
.27148 .56534 m .28259 .59976 L .25028 .63243 L p F P
0 g
s
.404 .368 .705 r
.2663 .66443 m .25028 .63243 L .28259 .59976 L p F P
0 g
s
.843 .851 .85 r
.72942 .77486 m .69963 .79771 L .68685 .77876 L p F P
0 g
s
.843 .851 .85 r
.68685 .77876 m .71488 .75228 L .72942 .77486 L p F P
0 g
s
.382 .207 .516 r
.3088 .43442 m .30944 .46608 L .25955 .49896 L p F P
0 g
s
.421 .274 .574 r
.26378 .53157 m .25955 .49896 L .30944 .46608 L p F P
0 g
s
.582 .715 .934 r
.4579 .84212 m .4916 .85616 L .48872 .85995 L p F P
0 g
s
.582 .715 .934 r
.48872 .85995 m .45235 .84974 L .4579 .84212 L p F P
0 g
s
.699 .81 .934 r
.59808 .84909 m .56187 .85963 L .55885 .85586 L p F P
0 g
s
.839 .539 .482 r
.73512 .40277 m .7372 .43195 L .67324 .40652 L p F P
0 g
s
.839 .539 .482 r
.67324 .40652 m .67178 .37719 L .73512 .40277 L p F P
0 g
s
.452 .535 .852 r
.33428 .75408 m .36251 .78027 L .35046 .79932 L p F P
0 g
s
.487 .583 .876 r
.3827 .81919 m .35046 .79932 L .36251 .78027 L p F P
0 g
s
.908 .778 .705 r
.79836 .62962 m .78243 .66184 L .75061 .63198 L p F P
0 g
s
.908 .778 .705 r
.75061 .63198 m .76485 .59724 L .79836 .62962 L p F P
0 g
s
.894 .659 .576 r
.78765 .49603 m .78345 .52874 L .73311 .49749 L p F P
0 g
s
.894 .659 .576 r
.73311 .49749 m .73655 .46367 L .78765 .49603 L p F P
0 g
s
.607 .269 .372 r
.52235 .30819 m .52223 .33016 L .44704 .3362 L p F P
0 g
s
.812 .844 .874 r
.69963 .79771 m .66748 .8179 L .65675 .8027 L p F P
0 g
s
.812 .844 .874 r
.65675 .8027 m .68685 .77876 L .69963 .79771 L p F P
0 g
s
.552 .672 .917 r
.42481 .82462 m .4579 .84212 L .45235 .84974 L p F P
0 g
s
.552 .672 .917 r
.45235 .84974 m .41683 .83609 L .42481 .82462 L p F P
0 g
s
.546 .261 .434 r
.37334 .37896 m .3768 .35289 L .44704 .3362 L p F P
0 g
s
.487 .583 .876 r
.36251 .78027 m .39285 .80391 L .3827 .81919 L p F P
0 g
s
.521 .628 .898 r
.41683 .83609 m .3827 .81919 L .39285 .80391 L p F P
0 g
s
.741 .824 .916 r
.63346 .83511 m .59808 .84909 L .59224 .84152 L p F P
0 g
s
.699 .81 .934 r
.55885 .85586 m .59224 .84152 L .59808 .84909 L p F P
0 g
s
.521 .628 .898 r
.39285 .80391 m .42481 .82462 L .41683 .83609 L p F P
0 g
s
.598 .714 .925 r
.46671 .83525 m .49608 .85276 L .4916 .85616 L p F P
0 g
s
.598 .714 .925 r
.4916 .85616 m .4579 .84212 L .46671 .83525 L p F P
0 g
s
.699 .795 .925 r
.59224 .84152 m .55885 .85586 L .55424 .85251 L p F P
0 g
s
.769 .444 .436 r
.66846 .35114 m .67178 .37719 L .59931 .36118 L p F P
0 g
s
.769 .444 .436 r
.59931 .36118 m .59763 .33528 L .66846 .35114 L p F P
0 g
s
.778 .835 .896 r
.66748 .8179 m .63346 .83511 L .62505 .82372 L p F P
0 g
s
.778 .835 .896 r
.62505 .82372 m .65675 .8027 L .66748 .8179 L p F P
0 g
s
.741 .824 .916 r
.59224 .84152 m .62505 .82372 L .63346 .83511 L p F P
0 g
s
.404 .368 .705 r
.28259 .59976 m .29699 .63431 L .2663 .66443 L p F P
0 g
s
.437 .42 .742 r
.28582 .6957 m .2663 .66443 L .29699 .63431 L p F P
0 g
s
.615 .716 .918 r
.47841 .82947 m .50197 .84992 L .49608 .85276 L p F P
0 g
s
.615 .716 .918 r
.49608 .85276 m .46671 .83525 L .47841 .82947 L p F P
0 g
s
.699 .795 .925 r
.55424 .85251 m .58316 .83472 L .59224 .84152 L p F P
0 g
s
.696 .781 .917 r
.58316 .83472 m .55424 .85251 L .54824 .84971 L p F P
0 g
s
.889 .786 .741 r
.78243 .66184 m .76302 .69335 L .73331 .66633 L p F P
0 g
s
.889 .786 .741 r
.73331 .66633 m .75061 .63198 L .78243 .66184 L p F P
0 g
s
.421 .274 .574 r
.30944 .46608 m .31294 .49983 L .26378 .53157 L p F P
0 g
s
.453 .33 .622 r
.27148 .56534 m .26378 .53157 L .31294 .49983 L p F P
0 g
s
.63 .72 .912 r
.49244 .82508 m .50899 .84776 L .50197 .84992 L p F P
0 g
s
.63 .72 .912 r
.50197 .84992 m .47841 .82947 L .49244 .82508 L p F P
0 g
s
.579 .673 .903 r
.43774 .81423 m .46671 .83525 L .4579 .84212 L p F P
0 g
s
.579 .673 .903 r
.4579 .84212 m .42481 .82462 L .43774 .81423 L p F P
0 g
s
.696 .781 .917 r
.54824 .84971 m .57125 .82905 L .58316 .83472 L p F P
0 g
s
.69 .768 .911 r
.57125 .82905 m .54824 .84971 L .54114 .84762 L p F P
0 g
s
.738 .8 .902 r
.62505 .82372 m .59224 .84152 L .58316 .83472 L p F P
0 g
s
.437 .42 .742 r
.29699 .63431 m .3145 .66843 L .28582 .6957 L p F P
0 g
s
.466 .467 .774 r
.30859 .72574 m .28582 .6957 L .3145 .66843 L p F P
0 g
s
.645 .726 .907 r
.50812 .82231 m .5168 .84641 L .50899 .84776 L p F P
0 g
s
.645 .726 .907 r
.50899 .84776 m .49244 .82508 L .50812 .82231 L p F P
0 g
s
.884 .681 .623 r
.78345 .52874 m .77583 .56264 L .72687 .53293 L p F P
0 g
s
.884 .681 .623 r
.72687 .53293 m .73311 .49749 L .78345 .52874 L p F P
0 g
s
.69 .768 .911 r
.54114 .84762 m .55705 .82478 L .57125 .82905 L p F P
0 g
s
.681 .755 .907 r
.55705 .82478 m .54114 .84762 L .53328 .84634 L p F P
0 g
s
.473 .24 .479 r
.37334 .37896 m .3718 .40828 L .3088 .43442 L p F P
0 g
s
.502 .3 .537 r
.30944 .46608 m .3088 .43442 L .3718 .40828 L p F P
0 g
s
.658 .734 .905 r
.52467 .82132 m .52503 .84593 L .5168 .84641 L p F P
0 g
s
.658 .734 .905 r
.5168 .84641 m .50812 .82231 L .52467 .82132 L p F P
0 g
s
.681 .755 .907 r
.53328 .84634 m .54126 .82216 L .55705 .82478 L p F P
0 g
s
.671 .744 .905 r
.54126 .82216 m .53328 .84634 L .52503 .84593 L p F P
0 g
s
.671 .744 .905 r
.52503 .84593 m .52467 .82132 L .54126 .82216 L p F P
0 g
s
.869 .793 .773 r
.76302 .69335 m .7404 .72365 L .71321 .69972 L p F P
0 g
s
.869 .793 .773 r
.71321 .69972 m .73331 .66633 L .76302 .69335 L p F P
0 g
s
.838 .573 .538 r
.7372 .43195 m .73655 .46367 L .67278 .43875 L p F P
0 g
s
.838 .573 .538 r
.67278 .43875 m .67324 .40652 L .7372 .43195 L p F P
0 g
s
.559 .632 .88 r
.40962 .78998 m .43774 .81423 L .42481 .82462 L p F P
0 g
s
.559 .632 .88 r
.42481 .82462 m .39285 .80391 L .40962 .78998 L p F P
0 g
s
.631 .333 .446 r
.44519 .3621 m .44704 .3362 L .52223 .33016 L p F P
0 g
s
.546 .261 .434 r
.44704 .3362 m .44519 .3621 L .37334 .37896 L p F P
0 g
s
.771 .802 .879 r
.65675 .8027 m .62505 .82372 L .61172 .81344 L p F P
0 g
s
.738 .8 .902 r
.58316 .83472 m .61172 .81344 L .62505 .82372 L p F P
0 g
s
.703 .391 .447 r
.59763 .33528 m .59931 .36118 L .52214 .35601 L p F P
0 g
s
.703 .391 .447 r
.52214 .35601 m .52223 .33016 L .59763 .33528 L p F P
0 g
s
.466 .467 .774 r
.3145 .66843 m .33486 .70158 L .30859 .72574 L p F P
0 g
s
.492 .51 .804 r
.33428 .75408 m .30859 .72574 L .33486 .70158 L p F P
0 g
s
.605 .676 .891 r
.45507 .80545 m .47841 .82947 L .46671 .83525 L p F P
0 g
s
.605 .676 .891 r
.46671 .83525 m .43774 .81423 L .45507 .80545 L p F P
0 g
s
.73 .777 .891 r
.61172 .81344 m .58316 .83472 L .57125 .82905 L p F P
0 g
s
.538 .592 .856 r
.38281 .76284 m .40962 .78998 L .39285 .80391 L p F P
0 g
s
.538 .592 .856 r
.39285 .80391 m .36251 .78027 L .38281 .76284 L p F P
0 g
s
.848 .798 .802 r
.7404 .72365 m .71488 .75228 L .69061 .73162 L p F P
0 g
s
.848 .798 .802 r
.69061 .73162 m .71321 .69972 L .7404 .72365 L p F P
0 g
s
.492 .51 .804 r
.33486 .70158 m .35775 .73322 L .33428 .75408 L p F P
0 g
s
.516 .551 .831 r
.36251 .78027 m .33428 .75408 L .35775 .73322 L p F P
0 g
s
.571 .32 .497 r
.3718 .40828 m .37334 .37896 L .44519 .3621 L p F P
0 g
s
.799 .802 .854 r
.68685 .77876 m .65675 .8027 L .63944 .78891 L p F P
0 g
s
.771 .802 .879 r
.61172 .81344 m .63944 .78891 L .65675 .8027 L p F P
0 g
s
.516 .551 .831 r
.35775 .73322 m .38281 .76284 L .36251 .78027 L p F P
0 g
s
.453 .33 .622 r
.31294 .49983 m .31931 .53515 L .27148 .56534 L p F P
0 g
s
.479 .378 .663 r
.28259 .59976 m .27148 .56534 L .31931 .53515 L p F P
0 g
s
.631 .333 .446 r
.52223 .33016 m .52214 .35601 L .44519 .3621 L p F P
0 g
s
.776 .487 .498 r
.67178 .37719 m .67324 .40652 L .60006 .3906 L p F P
0 g
s
.776 .487 .498 r
.60006 .3906 m .59931 .36118 L .67178 .37719 L p F P
0 g
s
.825 .801 .829 r
.71488 .75228 m .68685 .77876 L .66589 .7615 L p F P
0 g
s
.825 .801 .829 r
.66589 .7615 m .69061 .73162 L .71488 .75228 L p F P
0 g
s
.799 .802 .854 r
.63944 .78891 m .66589 .7615 L .68685 .77876 L p F P
0 g
s
.873 .699 .663 r
.77583 .56264 m .76485 .59724 L .71788 .56943 L p F P
0 g
s
.873 .699 .663 r
.71788 .56943 m .72687 .53293 L .77583 .56264 L p F P
0 g
s
.629 .683 .882 r
.47599 .79876 m .49244 .82508 L .47841 .82947 L p F P
0 g
s
.629 .683 .882 r
.47841 .82947 m .45507 .80545 L .47599 .79876 L p F P
0 g
s
.73 .777 .891 r
.57125 .82905 m .59405 .80481 L .61172 .81344 L p F P
0 g
s
.719 .756 .882 r
.59405 .80481 m .57125 .82905 L .55705 .82478 L p F P
0 g
s
.502 .3 .537 r
.3718 .40828 m .37226 .44048 L .30944 .46608 L p F P
0 g
s
.526 .349 .585 r
.31294 .49983 m .30944 .46608 L .37226 .44048 L p F P
0 g
s
.594 .639 .865 r
.43233 .77816 m .45507 .80545 L .43774 .81423 L p F P
0 g
s
.594 .639 .865 r
.43774 .81423 m .40962 .78998 L .43233 .77816 L p F P
0 g
s
.758 .772 .864 r
.63944 .78891 m .61172 .81344 L .59405 .80481 L p F P
0 g
s
.479 .378 .663 r
.31931 .53515 m .32848 .5715 L .28259 .59976 L p F P
0 g
s
.501 .422 .698 r
.29699 .63431 m .28259 .59976 L .32848 .5715 L p F P
0 g
s
.834 .601 .585 r
.73655 .46367 m .73311 .49749 L .67034 .47345 L p F P
0 g
s
.834 .601 .585 r
.67034 .47345 m .67278 .43875 L .73655 .46367 L p F P
0 g
s
.65 .693 .876 r
.49948 .79453 m .50812 .82231 L .49244 .82508 L p F P
0 g
s
.65 .693 .876 r
.49244 .82508 m .47599 .79876 L .49948 .79453 L p F P
0 g
s
.719 .756 .882 r
.55705 .82478 m .57286 .79831 L .59405 .80481 L p F P
0 g
s
.705 .737 .876 r
.57286 .79831 m .55705 .82478 L .54126 .82216 L p F P
0 g
s
.861 .714 .698 r
.76485 .59724 m .75061 .63198 L .70626 .6064 L p F P
0 g
s
.861 .714 .698 r
.70626 .6064 m .71788 .56943 L .76485 .59724 L p F P
0 g
s
.67 .705 .873 r
.52432 .79302 m .52467 .82132 L .50812 .82231 L p F P
0 g
s
.67 .705 .873 r
.50812 .82231 m .49948 .79453 L .52432 .79302 L p F P
0 g
s
.705 .737 .876 r
.54126 .82216 m .54921 .7943 L .57286 .79831 L p F P
0 g
s
.689 .72 .873 r
.54921 .7943 m .54126 .82216 L .52467 .82132 L p F P
0 g
s
.689 .72 .873 r
.52467 .82132 m .52432 .79302 L .54921 .7943 L p F P
0 g
s
.647 .382 .504 r
.44436 .39151 m .44519 .3621 L .52214 .35601 L p F P
0 g
s
.571 .32 .497 r
.44519 .3621 m .44436 .39151 L .3718 .40828 L p F P
0 g
s
.581 .603 .84 r
.41056 .74799 m .43233 .77816 L .40962 .78998 L p F P
0 g
s
.581 .603 .84 r
.40962 .78998 m .38281 .76284 L .41056 .74799 L p F P
0 g
s
.714 .436 .504 r
.59931 .36118 m .60006 .3906 L .5221 .38546 L p F P
0 g
s
.714 .436 .504 r
.5221 .38546 m .52214 .35601 L .59931 .36118 L p F P
0 g
s
.781 .765 .838 r
.66589 .7615 m .63944 .78891 L .61627 .7773 L p F P
0 g
s
.758 .772 .864 r
.59405 .80481 m .61627 .7773 L .63944 .78891 L p F P
0 g
s
.501 .422 .698 r
.32848 .5715 m .34034 .60831 L .29699 .63431 L p F P
0 g
s
.521 .461 .73 r
.3145 .66843 m .29699 .63431 L .34034 .60831 L p F P
0 g
s
.589 .367 .547 r
.37226 .44048 m .3718 .40828 L .44436 .39151 L p F P
0 g
s
.624 .649 .854 r
.45992 .76913 m .47599 .79876 L .45507 .80545 L p F P
0 g
s
.624 .649 .854 r
.45507 .80545 m .43233 .77816 L .45992 .76913 L p F P
0 g
s
.779 .522 .548 r
.67324 .40652 m .67278 .43875 L .59982 .42316 L p F P
0 g
s
.779 .522 .548 r
.59982 .42316 m .60006 .3906 L .67324 .40652 L p F P
0 g
s
.741 .744 .854 r
.61627 .7773 m .59405 .80481 L .57286 .79831 L p F P
0 g
s
.848 .726 .729 r
.75061 .63198 m .73331 .66633 L .69216 .64324 L p F P
0 g
s
.848 .726 .729 r
.69216 .64324 m .70626 .6064 L .75061 .63198 L p F P
0 g
s
.526 .349 .585 r
.37226 .44048 m .37477 .47512 L .31294 .49983 L p F P
0 g
s
.545 .392 .625 r
.31931 .53515 m .31294 .49983 L .37477 .47512 L p F P
0 g
s
.568 .568 .813 r
.39015 .71538 m .41056 .74799 L .38281 .76284 L p F P
0 g
s
.568 .568 .813 r
.38281 .76284 m .35775 .73322 L .39015 .71538 L p F P
0 g
s
.647 .382 .504 r
.52214 .35601 m .5221 .38546 L .44436 .39151 L p F P
0 g
s
.521 .461 .73 r
.34034 .60831 m .35474 .64496 L .3145 .66843 L p F P
0 g
s
.538 .498 .759 r
.33486 .70158 m .3145 .66843 L .35474 .64496 L p F P
0 g
s
.801 .757 .812 r
.69061 .73162 m .66589 .7615 L .63755 .74691 L p F P
0 g
s
.781 .765 .838 r
.61627 .7773 m .63755 .74691 L .66589 .7615 L p F P
0 g
s
.829 .624 .625 r
.73311 .49749 m .72687 .53293 L .66593 .51009 L p F P
0 g
s
.829 .624 .625 r
.66593 .51009 m .67034 .47345 L .73311 .49749 L p F P
0 g
s
.554 .534 .787 r
.37143 .68085 m .39015 .71538 L .35775 .73322 L p F P
0 g
s
.554 .534 .787 r
.35775 .73322 m .33486 .70158 L .37143 .68085 L p F P
0 g
s
.538 .498 .759 r
.35474 .64496 m .37143 .68085 L .33486 .70158 L p F P
0 g
s
.834 .738 .758 r
.73331 .66633 m .71321 .69972 L .67582 .67933 L p F P
0 g
s
.834 .738 .758 r
.67582 .67933 m .69216 .64324 L .73331 .66633 L p F P
0 g
s
.818 .748 .786 r
.71321 .69972 m .69061 .73162 L .65751 .71408 L p F P
0 g
s
.801 .757 .812 r
.63755 .74691 m .65751 .71408 L .69061 .73162 L p F P
0 g
s
.818 .748 .786 r
.65751 .71408 m .67582 .67933 L .71321 .69972 L p F P
0 g
s
.652 .662 .847 r
.49102 .76341 m .49948 .79453 L .47599 .79876 L p F P
0 g
s
.652 .662 .847 r
.47599 .79876 m .45992 .76913 L .49102 .76341 L p F P
0 g
s
.741 .744 .854 r
.57286 .79831 m .58832 .76852 L .61627 .7773 L p F P
0 g
s
.722 .719 .847 r
.58832 .76852 m .57286 .79831 L .54921 .7943 L p F P
0 g
s
.619 .617 .827 r
.4445 .7366 m .45992 .76913 L .43233 .77816 L p F P
0 g
s
.619 .617 .827 r
.43233 .77816 m .41056 .74799 L .4445 .7366 L p F P
0 g
s
.759 .731 .826 r
.63755 .74691 m .61627 .7773 L .58832 .76852 L p F P
0 g
s
.678 .678 .843 r
.52397 .76136 m .52432 .79302 L .49948 .79453 L p F P
0 g
s
.678 .678 .843 r
.49948 .79453 m .49102 .76341 L .52397 .76136 L p F P
0 g
s
.545 .392 .625 r
.37477 .47512 m .37934 .51167 L .31931 .53515 L p F P
0 g
s
.56 .43 .66 r
.32848 .5715 m .31931 .53515 L .37934 .51167 L p F P
0 g
s
.722 .719 .847 r
.54921 .7943 m .557 .7631 L .58832 .76852 L p F P
0 g
s
.701 .697 .843 r
.557 .7631 m .54921 .7943 L .52432 .79302 L p F P
0 g
s
.589 .367 .547 r
.44436 .39151 m .4446 .42406 L .37226 .44048 L p F P
0 g
s
.604 .408 .589 r
.37477 .47512 m .37226 .44048 L .4446 .42406 L p F P
0 g
s
.659 .423 .551 r
.4446 .42406 m .44436 .39151 L .5221 .38546 L p F P
0 g
s
.701 .697 .843 r
.52432 .79302 m .52397 .76136 L .557 .7631 L p F P
0 g
s
.823 .643 .66 r
.72687 .53293 m .71788 .56943 L .65958 .54808 L p F P
0 g
s
.823 .643 .66 r
.65958 .54808 m .66593 .51009 L .72687 .53293 L p F P
0 g
s
.72 .473 .551 r
.60006 .3906 m .59982 .42316 L .5221 .41813 L p F P
0 g
s
.72 .473 .551 r
.5221 .41813 m .5221 .38546 L .60006 .3906 L p F P
0 g
s
.779 .55 .589 r
.67278 .43875 m .67034 .47345 L .59857 .45841 L p F P
0 g
s
.779 .55 .589 r
.59857 .45841 m .59982 .42316 L .67278 .43875 L p F P
0 g
s
.612 .587 .801 r
.42999 .70165 m .4445 .7366 L .41056 .74799 L p F P
0 g
s
.612 .587 .801 r
.41056 .74799 m .39015 .71538 L .42999 .70165 L p F P
0 g
s
.659 .423 .551 r
.5221 .38546 m .5221 .41813 L .4446 .42406 L p F P
0 g
s
.774 .718 .8 r
.65751 .71408 m .63755 .74691 L .60316 .73583 L p F P
0 g
s
.759 .731 .826 r
.58832 .76852 m .60316 .73583 L .63755 .74691 L p F P
0 g
s
.56 .43 .66 r
.37934 .51167 m .38593 .54956 L .32848 .5715 L p F P
0 g
s
.574 .464 .691 r
.34034 .60831 m .32848 .5715 L .38593 .54956 L p F P
0 g
s
.652 .634 .819 r
.48288 .72937 m .49102 .76341 L .45992 .76913 L p F P
0 g
s
.652 .634 .819 r
.45992 .76913 m .4445 .7366 L .48288 .72937 L p F P
0 g
s
.735 .702 .819 r
.60316 .73583 m .58832 .76852 L .557 .7631 L p F P
0 g
s
.815 .661 .691 r
.71788 .56943 m .70626 .6064 L .65138 .5868 L p F P
0 g
s
.815 .661 .691 r
.65138 .5868 m .65958 .54808 L .71788 .56943 L p F P
0 g
s
.604 .557 .775 r
.41665 .66485 m .42999 .70165 L .39015 .71538 L p F P
0 g
s
.604 .557 .775 r
.39015 .71538 m .37143 .68085 L .41665 .66485 L p F P
0 g
s
.574 .464 .691 r
.38593 .54956 m .39443 .58815 L .34034 .60831 L p F P
0 g
s
.585 .496 .72 r
.35474 .64496 m .34034 .60831 L .39443 .58815 L p F P
0 g
s
.604 .408 .589 r
.4446 .42406 m .44594 .45928 L .37477 .47512 L p F P
0 g
s
.615 .442 .625 r
.37934 .51167 m .37477 .47512 L .44594 .45928 L p F P
0 g
s
.787 .705 .774 r
.67582 .67933 m .65751 .71408 L .61713 .70073 L p F P
0 g
s
.774 .718 .8 r
.60316 .73583 m .61713 .70073 L .65751 .71408 L p F P
0 g
s
.777 .575 .625 r
.67034 .47345 m .66593 .51009 L .59632 .49581 L p F P
0 g
s
.777 .575 .625 r
.59632 .49581 m .59857 .45841 L .67034 .47345 L p F P
0 g
s
.682 .653 .815 r
.52364 .72678 m .52397 .76136 L .49102 .76341 L p F P
0 g
s
.682 .653 .815 r
.49102 .76341 m .48288 .72937 L .52364 .72678 L p F P
0 g
s
.807 .676 .72 r
.70626 .6064 m .69216 .64324 L .64145 .62559 L p F P
0 g
s
.807 .676 .72 r
.64145 .62559 m .65138 .5868 L .70626 .6064 L p F P
0 g
s
.595 .527 .748 r
.40473 .6268 m .41665 .66485 L .37143 .68085 L p F P
0 g
s
.595 .527 .748 r
.37143 .68085 m .35474 .64496 L .40473 .6268 L p F P
0 g
s
.735 .702 .819 r
.557 .7631 m .56449 .72898 L .60316 .73583 L p F P
0 g
s
.71 .676 .815 r
.56449 .72898 m .557 .7631 L .52397 .76136 L p F P
0 g
s
.585 .496 .72 r
.39443 .58815 m .40473 .6268 L .35474 .64496 L p F P
0 g
s
.668 .457 .591 r
.44594 .45928 m .4446 .42406 L .5221 .41813 L p F P
0 g
s
.797 .691 .747 r
.69216 .64324 m .67582 .67933 L .62997 .66378 L p F P
0 g
s
.787 .705 .774 r
.61713 .70073 m .62997 .66378 L .67582 .67933 L p F P
0 g
s
.724 .504 .591 r
.59982 .42316 m .59857 .45841 L .52215 .45356 L p F P
0 g
s
.724 .504 .591 r
.52215 .45356 m .5221 .41813 L .59982 .42316 L p F P
0 g
s
.71 .676 .815 r
.52397 .76136 m .52364 .72678 L .56449 .72898 L p F P
0 g
s
.797 .691 .747 r
.62997 .66378 m .64145 .62559 L .69216 .64324 L p F P
0 g
s
.65 .607 .793 r
.47522 .69293 m .48288 .72937 L .4445 .7366 L p F P
0 g
s
.65 .607 .793 r
.4445 .7366 m .42999 .70165 L .47522 .69293 L p F P
0 g
s
.746 .685 .792 r
.61713 .70073 m .60316 .73583 L .56449 .72898 L p F P
0 g
s
.668 .457 .591 r
.5221 .41813 m .52215 .45356 L .44594 .45928 L p F P
0 g
s
.615 .442 .625 r
.44594 .45928 m .44837 .49663 L .37934 .51167 L p F P
0 g
s
.624 .474 .657 r
.38593 .54956 m .37934 .51167 L .44837 .49663 L p F P
0 g
s
.775 .596 .657 r
.66593 .51009 m .65958 .54808 L .59309 .53475 L p F P
0 g
s
.775 .596 .657 r
.59309 .53475 m .59632 .49581 L .66593 .51009 L p F P
0 g
s
.647 .581 .767 r
.46816 .65466 m .47522 .69293 L .42999 .70165 L p F P
0 g
s
.647 .581 .767 r
.42999 .70165 m .41665 .66485 L .46816 .65466 L p F P
0 g
s
.684 .63 .789 r
.52332 .68979 m .52364 .72678 L .48288 .72937 L p F P
0 g
s
.684 .63 .789 r
.48288 .72937 m .47522 .69293 L .52332 .68979 L p F P
0 g
s
.746 .685 .792 r
.56449 .72898 m .57155 .69245 L .61713 .70073 L p F P
0 g
s
.716 .656 .788 r
.57155 .69245 m .56449 .72898 L .52364 .72678 L p F P
0 g
s
.754 .668 .766 r
.62997 .66378 m .61713 .70073 L .57155 .69245 L p F P
0 g
s
.674 .487 .625 r
.44837 .49663 m .44594 .45928 L .52215 .45356 L p F P
0 g
s
.727 .53 .625 r
.59857 .45841 m .59632 .49581 L .52224 .4912 L p F P
0 g
s
.727 .53 .625 r
.52224 .4912 m .52215 .45356 L .59857 .45841 L p F P
0 g
s
.624 .474 .657 r
.44837 .49663 m .45186 .53552 L .38593 .54956 L p F P
0 g
s
.632 .502 .687 r
.39443 .58815 m .38593 .54956 L .45186 .53552 L p F P
0 g
s
.716 .656 .788 r
.52364 .72678 m .52332 .68979 L .57155 .69245 L p F P
0 g
s
.771 .616 .686 r
.65958 .54808 m .65138 .5868 L .58892 .57457 L p F P
0 g
s
.771 .616 .686 r
.58892 .57457 m .59309 .53475 L .65958 .54808 L p F P
0 g
s
.643 .555 .741 r
.46185 .61522 m .46816 .65466 L .41665 .66485 L p F P
0 g
s
.643 .555 .741 r
.41665 .66485 m .40473 .6268 L .46185 .61522 L p F P
0 g
s
.761 .651 .74 r
.64145 .62559 m .62997 .66378 L .57805 .65411 L p F P
0 g
s
.754 .668 .766 r
.57155 .69245 m .57805 .65411 L .62997 .66378 L p F P
0 g
s
.632 .502 .687 r
.45186 .53552 m .45638 .57527 L .39443 .58815 L p F P
0 g
s
.638 .529 .714 r
.40473 .6268 m .39443 .58815 L .45638 .57527 L p F P
0 g
s
.674 .487 .625 r
.52215 .45356 m .52224 .4912 L .44837 .49663 L p F P
0 g
s
.638 .529 .714 r
.45638 .57527 m .46185 .61522 L .40473 .6268 L p F P
0 g
s
.767 .634 .714 r
.65138 .5868 m .64145 .62559 L .58388 .61459 L p F P
0 g
s
.767 .634 .714 r
.58388 .61459 m .58892 .57457 L .65138 .5868 L p F P
0 g
s
.761 .651 .74 r
.57805 .65411 m .58388 .61459 L .64145 .62559 L p F P
0 g
s
.685 .607 .763 r
.52304 .651 m .52332 .68979 L .47522 .69293 L p F P
0 g
s
.685 .607 .763 r
.47522 .69293 m .46816 .65466 L .52304 .651 L p F P
0 g
s
.721 .636 .762 r
.57805 .65411 m .57155 .69245 L .52332 .68979 L p F P
0 g
s
.678 .514 .656 r
.45186 .53552 m .44837 .49663 L .52224 .4912 L p F P
0 g
s
.727 .554 .656 r
.59632 .49581 m .59309 .53475 L .52238 .53045 L p F P
0 g
s
.727 .554 .656 r
.52238 .53045 m .52224 .4912 L .59632 .49581 L p F P
0 g
s
.721 .636 .762 r
.52332 .68979 m .52304 .651 L .57805 .65411 L p F P
0 g
s
.678 .514 .656 r
.52224 .4912 m .52238 .53045 L .45186 .53552 L p F P
0 g
s
.685 .585 .737 r
.52278 .61105 m .52304 .651 L .46816 .65466 L p F P
0 g
s
.685 .585 .737 r
.46816 .65466 m .46185 .61522 L .52278 .61105 L p F P
0 g
s
.682 .539 .684 r
.45638 .57527 m .45186 .53552 L .52238 .53045 L p F P
0 g
s
.724 .616 .737 r
.58388 .61459 m .57805 .65411 L .52304 .651 L p F P
0 g
s
.727 .576 .684 r
.59309 .53475 m .58892 .57457 L .52256 .57063 L p F P
0 g
s
.727 .576 .684 r
.52256 .57063 m .52238 .53045 L .59309 .53475 L p F P
0 g
s
.684 .562 .711 r
.52256 .57063 m .52278 .61105 L .46185 .61522 L p F P
0 g
s
.684 .562 .711 r
.46185 .61522 m .45638 .57527 L .52256 .57063 L p F P
0 g
s
.682 .539 .684 r
.52238 .53045 m .52256 .57063 L .45638 .57527 L p F P
0 g
s
.724 .616 .737 r
.52304 .651 m .52278 .61105 L .58388 .61459 L p F P
0 g
s
.726 .596 .711 r
.58892 .57457 m .58388 .61459 L .52278 .61105 L p F P
0 g
s
.726 .596 .711 r
.52278 .61105 m .52256 .57063 L .58892 .57457 L p F P
0 g
s
.25 Mabswid
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.08845 .24527 m
.67201 0 L
s
.09903 .24082 m
.10412 .24605 L
s
[(-2)] .08885 .23035 .97243 1 Mshowa
.22731 .1869 m
.23214 .19237 L
s
[(-1)] .21763 .17597 .88506 1 Mshowa
.36263 .13003 m
.36719 .13573 L
s
[(0)] .35353 .11861 .7977 1 Mshowa
.50562 .06993 m
.50984 .07588 L
s
[(1)] .49716 .05803 .71033 1 Mshowa
.65692 .00634 m
.66078 .01254 L
s
[(2)] .6492 -0.00605 .62296 1 Mshowa
.125 Mabswid
.12415 .23026 m
.12717 .23343 L
s
.14953 .21959 m
.15253 .22279 L
s
.17518 .20881 m
.17815 .21204 L
s
.2011 .19792 m
.20404 .20117 L
s
.25379 .17577 m
.25666 .17908 L
s
.28056 .16452 m
.28339 .16786 L
s
.30762 .15315 m
.31042 .15652 L
s
.33498 .14165 m
.33774 .14505 L
s
.3906 .11827 m
.39329 .12173 L
s
.41887 .10639 m
.42153 .10987 L
s
.44746 .09437 m
.45008 .09789 L
s
.47638 .08222 m
.47895 .08576 L
s
.53519 .0575 m
.53768 .0611 L
s
.5651 .04493 m
.56755 .04856 L
s
.59535 .03222 m
.59776 .03588 L
s
.62596 .01935 m
.62832 .02304 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-2)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-1)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(1)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(2)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.38.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.38.1"]
}, Open  ]],

Cell[TextData[{
 "In this plot, the height is given by ",
 StyleBox["(1 + Sin[phi])r^2", "MR"],
 ". Polar coordinates are used in the plane. "
}], "MathCaption",
 CellTags->{"S5.38.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
CylindricalPlot3D[ (1 + Sin[phi]) r^2,
               {r, 0, 1}, {phi, 0, 2Pi}]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.38.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08661 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.057187 1.16706 -3.84892e-18 1.16706 [
[.08924 .23032 -11.8354 -9 ]
[.08924 .23032 .16463 0 ]
[.21784 .176 -22.6215 -9 ]
[.21784 .176 1.37845 0 ]
[.35356 .1187 -5.39309 -9 ]
[.35356 .1187 .60691 0 ]
[.497 .05818 -15.3924 -9 ]
[.497 .05818 2.60762 0 ]
[.64886 -0.00584 -4.8685 -9 ]
[.64886 -0.00584 1.1315 0 ]
[.00921 .82699 -6.92643 0 ]
[.00921 .82699 5.07357 9 ]
[.12071 .9052 -13.4202 0 ]
[.12071 .9052 10.5798 9 ]
[.22071 .97534 -3.26216 0 ]
[.22071 .97534 2.73784 9 ]
[.31089 1.03859 -9.54457 0 ]
[.31089 1.03859 8.45543 9 ]
[.39264 1.09592 -3.11086 0 ]
[.39264 1.09592 2.88914 9 ]
[.07325 .26213 -6 -2.61789 ]
[.07325 .26213 0 6.38211 ]
[.05472 .37827 -18 -2.72087 ]
[.05472 .37827 0 6.27913 ]
[.03458 .50456 -6 -2.83376 ]
[.03458 .50456 0 6.16624 ]
[.0126 .64239 -18 -2.95807 ]
[.0126 .64239 0 6.04193 ]
[-0.01148 .7934 -6 -3.09562 ]
[-0.01148 .7934 0 5.90438 ]
[ 0 0 0 0 ]
[ 1 1.08661 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24538 m
.67212 0 L
s
.09942 .24078 m
.1045 .24601 L
s
[(-1)] .08924 .23032 .97256 1 Mshowa
.22751 .18692 m
.23234 .19239 L
s
[(-0.5)] .21784 .176 .88513 1 Mshowa
.36266 .13011 m
.3672 .13581 L
s
[(0)] .35356 .1187 .7977 1 Mshowa
.50545 .07007 m
.50968 .07602 L
s
[(0.5)] .497 .05818 .71026 1 Mshowa
.65657 .00654 m
.66042 .01273 L
s
[(1)] .64886 -0.00584 .62283 1 Mshowa
.125 Mabswid
.1245 .23023 m
.12752 .2334 L
s
.14984 .21958 m
.15284 .22277 L
s
.17546 .20881 m
.17842 .21203 L
s
.20134 .19792 m
.20428 .20117 L
s
.25396 .17581 m
.25682 .17911 L
s
.28069 .16457 m
.28352 .1679 L
s
.30771 .1532 m
.31051 .15657 L
s
.33503 .14172 m
.3378 .14511 L
s
.39058 .11836 m
.39327 .12182 L
s
.41882 .10649 m
.42147 .10997 L
s
.44737 .09449 m
.44999 .098 L
s
.47625 .08235 m
.47882 .08589 L
s
.53499 .05765 m
.53748 .06125 L
s
.56486 .04509 m
.56731 .04872 L
s
.59508 .03239 m
.59748 .03605 L
s
.62564 .01954 m
.628 .02322 L
s
.25 Mabswid
0 .80452 m
.40066 1.08661 L
s
.01144 .81257 m
.01255 .80536 L
s
[(-1)] .00921 .82699 .1544 -1 Mshowa
.12243 .89072 m
.12328 .88347 L
s
[(-0.5)] .12071 .9052 .11835 -1 Mshowa
.22198 .9608 m
.22261 .95354 L
s
[(0)] .22071 .97534 .08739 -1 Mshowa
.31177 1.02403 m
.31221 1.01674 L
s
[(0.5)] .31089 1.03859 .06051 -1 Mshowa
.39317 1.08134 m
.39344 1.07405 L
s
[(1)] .39264 1.09592 .03695 -1 Mshowa
.125 Mabswid
.03464 .82891 m
.03528 .82458 L
s
.05733 .84488 m
.05793 .84055 L
s
.07951 .8605 m
.08008 .85616 L
s
.1012 .87577 m
.10175 .87143 L
s
.14319 .90534 m
.14368 .90099 L
s
.16352 .91965 m
.16397 .91529 L
s
.18341 .93365 m
.18384 .9293 L
s
.20289 .94737 m
.2033 .94301 L
s
.24067 .97396 m
.24102 .9696 L
s
.25898 .98686 m
.25931 .9825 L
s
.27693 .9995 m
.27724 .99513 L
s
.29452 1.01188 m
.29481 1.00751 L
s
.32868 1.03593 m
.32892 1.03156 L
s
.34527 1.04761 m
.34549 1.04324 L
s
.36154 1.05907 m
.36174 1.0547 L
s
.37751 1.07031 m
.37769 1.06594 L
s
.25 Mabswid
.08846 .24538 m
0 .80452 L
s
.08671 .2565 m
.09343 .25369 L
s
[(0)] .07325 .26213 1 -0.41825 Mshowa
.06829 .37291 m
.07507 .37023 L
s
[(0.5)] .05472 .37827 1 -0.39536 Mshowa
.04826 .49949 m
.0551 .49696 L
s
[(1)] .03458 .50456 1 -0.37028 Mshowa
.0264 .63766 m
.0333 .63529 L
s
[(1.5)] .0126 .64239 1 -0.34265 Mshowa
.00245 .78906 m
.00941 .78689 L
s
[(2)] -0.01148 .7934 1 -0.31208 Mshowa
.125 Mabswid
.08314 .27903 m
.08719 .27735 L
s
.07952 .30192 m
.08357 .30026 L
s
.07584 .32519 m
.07989 .32355 L
s
.07209 .34885 m
.07616 .34723 L
s
.06442 .39737 m
.06849 .39578 L
s
.06048 .42225 m
.06457 .42067 L
s
.05648 .44755 m
.06057 .446 L
s
.0524 .4733 m
.0565 .47176 L
s
.04404 .52615 m
.04815 .52465 L
s
.03975 .55328 m
.04387 .5518 L
s
.03538 .5809 m
.03951 .57944 L
s
.03093 .60902 m
.03506 .60758 L
s
.02179 .66682 m
.02593 .66542 L
s
.01709 .69653 m
.02124 .69515 L
s
.0123 .72679 m
.01646 .72544 L
s
.00742 .75763 m
.01159 .7563 L
s
.25 Mabswid
.08846 .24538 m
0 .80452 L
s
0 .80452 m
.40066 1.08661 L
s
.40066 1.08661 m
.41824 .5818 L
s
.41824 .5818 m
.08846 .24538 L
s
.67212 0 m
.92713 .41525 L
s
.92713 .41525 m
1 .94931 L
s
1 .94931 m
.70601 .5864 L
s
.70601 .5864 m
.67212 0 L
s
.08846 .24538 m
0 .80452 L
s
0 .80452 m
.70601 .5864 L
s
.70601 .5864 m
.67212 0 L
s
.67212 0 m
.08846 .24538 L
s
.41824 .5818 m
.92713 .41525 L
s
.92713 .41525 m
1 .94931 L
s
1 .94931 m
.40066 1.08661 L
s
.40066 1.08661 m
.41824 .5818 L
s
0 0 m
1 0 L
1 1.08661 L
0 1.08661 L
closepath
clip
newpath
.5 Mabswid
.711 .576 .701 r
.48826 .48492 m .49137 .4685 L .51467 .47615 L p F P
0 g
s
.711 .576 .701 r
.51467 .47615 m .51367 .49371 L .48826 .48492 L p F P
0 g
s
.71 .582 .71 r
.51566 .45957 m .51467 .47615 L .49137 .4685 L p F P
0 g
s
.685 .552 .697 r
.51367 .49371 m .51467 .47615 L .53849 .47931 L p F P
0 g
s
.686 .559 .706 r
.51467 .47615 m .51566 .45957 L .53731 .46215 L p F P
0 g
s
.686 .559 .706 r
.53731 .46215 m .53849 .47931 L .51467 .47615 L p F P
0 g
s
.71 .582 .71 r
.49137 .4685 m .49448 .45299 L .51566 .45957 L p F P
0 g
s
.71 .589 .719 r
.51665 .44395 m .51566 .45957 L .49448 .45299 L p F P
0 g
s
.686 .567 .715 r
.51566 .45957 m .51665 .44395 L .53614 .44603 L p F P
0 g
s
.686 .567 .715 r
.53614 .44603 m .53731 .46215 L .51566 .45957 L p F P
0 g
s
.734 .601 .709 r
.46449 .47152 m .46958 .45671 L .49137 .4685 L p F P
0 g
s
.734 .601 .709 r
.49137 .4685 m .48826 .48492 L .46449 .47152 L p F P
0 g
s
.733 .607 .717 r
.49448 .45299 m .49137 .4685 L .46958 .45671 L p F P
0 g
s
.711 .57 .694 r
.48513 .50226 m .48826 .48492 L .51367 .49371 L p F P
0 g
s
.711 .57 .694 r
.51367 .49371 m .51267 .51228 L .48513 .50226 L p F P
0 g
s
.684 .545 .69 r
.51267 .51228 m .51367 .49371 L .53967 .49752 L p F P
0 g
s
.685 .552 .697 r
.53849 .47931 m .53967 .49752 L .51367 .49371 L p F P
0 g
s
.735 .596 .701 r
.45937 .48716 m .46449 .47152 L .48826 .48492 L p F P
0 g
s
.735 .596 .701 r
.48826 .48492 m .48513 .50226 L .45937 .48716 L p F P
0 g
s
.733 .607 .717 r
.46958 .45671 m .47466 .4427 L .49448 .45299 L p F P
0 g
s
.731 .613 .726 r
.49757 .43836 m .49448 .45299 L .47466 .4427 L p F P
0 g
s
.71 .589 .719 r
.49448 .45299 m .49757 .43836 L .51665 .44395 L p F P
0 g
s
.709 .597 .729 r
.51764 .4293 m .51665 .44395 L .49757 .43836 L p F P
0 g
s
.687 .576 .725 r
.51665 .44395 m .51764 .4293 L .53498 .43092 L p F P
0 g
s
.687 .576 .725 r
.53498 .43092 m .53614 .44603 L .51665 .44395 L p F P
0 g
s
.735 .591 .695 r
.45423 .50364 m .45937 .48716 L .48513 .50226 L p F P
0 g
s
.735 .591 .695 r
.48513 .50226 m .48198 .52054 L .45423 .50364 L p F P
0 g
s
.711 .564 .687 r
.48198 .52054 m .48513 .50226 L .51267 .51228 L p F P
0 g
s
.711 .564 .687 r
.51267 .51228 m .51167 .53187 L .48198 .52054 L p F P
0 g
s
.684 .539 .683 r
.51167 .53187 m .51267 .51228 L .54085 .51679 L p F P
0 g
s
.684 .545 .69 r
.53967 .49752 m .54085 .51679 L .51267 .51228 L p F P
0 g
s
.731 .613 .726 r
.47466 .4427 m .47973 .42949 L .49757 .43836 L p F P
0 g
s
.729 .62 .736 r
.50067 .42461 m .49757 .43836 L .47973 .42949 L p F P
0 g
s
.709 .597 .729 r
.49757 .43836 m .50067 .42461 L .51764 .4293 L p F P
0 g
s
.659 .537 .705 r
.53849 .47931 m .53731 .46215 L .5585 .46063 L p F P
0 g
s
.661 .546 .714 r
.53731 .46215 m .53614 .44603 L .55521 .44448 L p F P
0 g
s
.661 .546 .714 r
.55521 .44448 m .5585 .46063 L .53731 .46215 L p F P
0 g
s
.657 .529 .697 r
.53967 .49752 m .53849 .47931 L .5618 .47784 L p F P
0 g
s
.659 .537 .705 r
.5585 .46063 m .5618 .47784 L .53849 .47931 L p F P
0 g
s
.709 .606 .74 r
.51862 .41558 m .51764 .4293 L .50067 .42461 L p F P
0 g
s
.688 .586 .736 r
.51764 .4293 m .51862 .41558 L .53381 .41681 L p F P
0 g
s
.688 .586 .736 r
.53381 .41681 m .53498 .43092 L .51764 .4293 L p F P
0 g
s
.663 .556 .724 r
.53614 .44603 m .53498 .43092 L .55193 .42939 L p F P
0 g
s
.663 .556 .724 r
.55193 .42939 m .55521 .44448 L .53614 .44603 L p F P
0 g
s
.736 .586 .688 r
.44907 .52096 m .45423 .50364 L .48198 .52054 L p F P
0 g
s
.736 .586 .688 r
.48198 .52054 m .47882 .53977 L .44907 .52096 L p F P
0 g
s
.711 .56 .681 r
.47882 .53977 m .48198 .52054 L .51167 .53187 L p F P
0 g
s
.656 .522 .689 r
.54085 .51679 m .53967 .49752 L .56513 .49615 L p F P
0 g
s
.657 .529 .697 r
.5618 .47784 m .56513 .49615 L .53967 .49752 L p F P
0 g
s
.711 .56 .681 r
.51167 .53187 m .51065 .55251 L .47882 .53977 L p F P
0 g
s
.683 .534 .677 r
.51065 .55251 m .51167 .53187 L .54204 .53716 L p F P
0 g
s
.684 .539 .683 r
.54085 .51679 m .54204 .53716 L .51167 .53187 L p F P
0 g
s
.729 .62 .736 r
.47973 .42949 m .4848 .41707 L .50067 .42461 L p F P
0 g
s
.727 .628 .748 r
.50376 .41173 m .50067 .42461 L .4848 .41707 L p F P
0 g
s
.709 .606 .74 r
.50067 .42461 m .50376 .41173 L .51862 .41558 L p F P
0 g
s
.754 .628 .72 r
.44339 .45406 m .45025 .44124 L .46958 .45671 L p F P
0 g
s
.754 .628 .72 r
.46958 .45671 m .46449 .47152 L .44339 .45406 L p F P
0 g
s
.752 .633 .728 r
.47466 .4427 m .46958 .45671 L .45025 .44124 L p F P
0 g
s
.665 .567 .736 r
.53498 .43092 m .53381 .41681 L .54865 .41534 L p F P
0 g
s
.665 .567 .736 r
.54865 .41534 m .55193 .42939 L .53498 .43092 L p F P
0 g
s
.756 .623 .712 r
.43651 .4676 m .44339 .45406 L .46449 .47152 L p F P
0 g
s
.756 .623 .712 r
.46449 .47152 m .45937 .48716 L .43651 .4676 L p F P
0 g
s
.752 .633 .728 r
.45025 .44124 m .45709 .42912 L .47466 .4427 L p F P
0 g
s
.749 .638 .738 r
.47973 .42949 m .47466 .4427 L .45709 .42912 L p F P
0 g
s
.757 .619 .705 r
.42959 .48186 m .43651 .4676 L .45937 .48716 L p F P
0 g
s
.757 .619 .705 r
.45937 .48716 m .45423 .50364 L .42959 .48186 L p F P
0 g
s
.708 .616 .753 r
.51961 .4028 m .51862 .41558 L .50376 .41173 L p F P
0 g
s
.688 .597 .749 r
.51862 .41558 m .51961 .4028 L .53264 .40369 L p F P
0 g
s
.688 .597 .749 r
.53264 .40369 m .53381 .41681 L .51862 .41558 L p F P
0 g
s
.654 .516 .682 r
.54204 .53716 m .54085 .51679 L .56847 .51558 L p F P
0 g
s
.656 .522 .689 r
.56513 .49615 m .56847 .51558 L .54085 .51679 L p F P
0 g
s
.736 .582 .683 r
.44387 .53915 m .44907 .52096 L .47882 .53977 L p F P
0 g
s
.736 .582 .683 r
.47882 .53977 m .47563 .55997 L .44387 .53915 L p F P
0 g
s
.711 .555 .676 r
.47563 .55997 m .47882 .53977 L .51065 .55251 L p F P
0 g
s
.749 .638 .738 r
.45709 .42912 m .46392 .4177 L .47973 .42949 L p F P
0 g
s
.746 .645 .748 r
.4848 .41707 m .47973 .42949 L .46392 .4177 L p F P
0 g
s
.727 .628 .748 r
.4848 .41707 m .48986 .40542 L .50376 .41173 L p F P
0 g
s
.725 .637 .76 r
.50685 .39971 m .50376 .41173 L .48986 .40542 L p F P
0 g
s
.708 .616 .753 r
.50376 .41173 m .50685 .39971 L .51961 .4028 L p F P
0 g
s
.667 .58 .749 r
.53381 .41681 m .53264 .40369 L .54537 .40232 L p F P
0 g
s
.667 .58 .749 r
.54537 .40232 m .54865 .41534 L .53381 .41681 L p F P
0 g
s
.759 .614 .699 r
.42265 .49685 m .42959 .48186 L .45423 .50364 L p F P
0 g
s
.759 .614 .699 r
.45423 .50364 m .44907 .52096 L .42265 .49685 L p F P
0 g
s
.711 .555 .676 r
.51065 .55251 m .50963 .57421 L .47563 .55997 L p F P
0 g
s
.682 .529 .672 r
.50963 .57421 m .51065 .55251 L .54324 .55864 L p F P
0 g
s
.683 .534 .677 r
.54204 .53716 m .54324 .55864 L .51065 .55251 L p F P
0 g
s
.746 .645 .748 r
.46392 .4177 m .47074 .40697 L .4848 .41707 L p F P
0 g
s
.743 .651 .759 r
.48986 .40542 m .4848 .41707 L .47074 .40697 L p F P
0 g
s
.633 .528 .717 r
.5585 .46063 m .55521 .44448 L .57301 .43936 L p F P
0 g
s
.636 .539 .727 r
.55521 .44448 m .55193 .42939 L .56774 .42478 L p F P
0 g
s
.636 .539 .727 r
.56774 .42478 m .57301 .43936 L .55521 .44448 L p F P
0 g
s
.63 .518 .707 r
.5618 .47784 m .5585 .46063 L .5783 .45502 L p F P
0 g
s
.633 .528 .717 r
.57301 .43936 m .5783 .45502 L .5585 .46063 L p F P
0 g
s
.653 .51 .676 r
.54324 .55864 m .54204 .53716 L .57183 .53614 L p F P
0 g
s
.654 .516 .682 r
.56847 .51558 m .57183 .53614 L .54204 .53716 L p F P
0 g
s
.64 .551 .739 r
.55193 .42939 m .54865 .41534 L .56248 .41125 L p F P
0 g
s
.64 .551 .739 r
.56248 .41125 m .56774 .42478 L .55193 .42939 L p F P
0 g
s
.627 .509 .699 r
.56513 .49615 m .5618 .47784 L .58361 .47178 L p F P
0 g
s
.63 .518 .707 r
.5783 .45502 m .58361 .47178 L .5618 .47784 L p F P
0 g
s
.706 .628 .767 r
.5206 .39094 m .51961 .4028 L .50685 .39971 L p F P
0 g
s
.688 .61 .764 r
.51961 .4028 m .5206 .39094 L .53148 .39154 L p F P
0 g
s
.688 .61 .764 r
.53148 .39154 m .53264 .40369 L .51961 .4028 L p F P
0 g
s
.76 .611 .693 r
.41567 .51259 m .42265 .49685 L .44907 .52096 L p F P
0 g
s
.76 .611 .693 r
.44907 .52096 m .44387 .53915 L .41567 .51259 L p F P
0 g
s
.737 .578 .677 r
.43864 .55822 m .44387 .53915 L .47563 .55997 L p F P
0 g
s
.737 .578 .677 r
.47563 .55997 m .47242 .58117 L .43864 .55822 L p F P
0 g
s
.711 .551 .671 r
.47242 .58117 m .47563 .55997 L .50963 .57421 L p F P
0 g
s
.669 .595 .764 r
.53264 .40369 m .53148 .39154 L .5421 .39032 L p F P
0 g
s
.669 .595 .764 r
.5421 .39032 m .54537 .40232 L .53264 .40369 L p F P
0 g
s
.725 .637 .76 r
.48986 .40542 m .49492 .39455 L .50685 .39971 L p F P
0 g
s
.721 .647 .774 r
.50994 .38854 m .50685 .39971 L .49492 .39455 L p F P
0 g
s
.706 .628 .767 r
.50685 .39971 m .50994 .38854 L .5206 .39094 L p F P
0 g
s
.743 .651 .759 r
.47074 .40697 m .47755 .39692 L .48986 .40542 L p F P
0 g
s
.739 .659 .771 r
.49492 .39455 m .48986 .40542 L .47755 .39692 L p F P
0 g
s
.644 .566 .752 r
.54865 .41534 m .54537 .40232 L .55723 .39877 L p F P
0 g
s
.644 .566 .752 r
.55723 .39877 m .56248 .41125 L .54865 .41534 L p F P
0 g
s
.625 .501 .691 r
.56847 .51558 m .56513 .49615 L .58896 .48964 L p F P
0 g
s
.627 .509 .699 r
.58361 .47178 m .58896 .48964 L .56513 .49615 L p F P
0 g
s
.711 .551 .671 r
.50963 .57421 m .5086 .59701 L .47242 .58117 L p F P
0 g
s
.682 .525 .667 r
.5086 .59701 m .50963 .57421 L .54445 .58127 L p F P
0 g
s
.682 .529 .672 r
.54324 .55864 m .54445 .58127 L .50963 .57421 L p F P
0 g
s
.77 .655 .735 r
.42589 .43325 m .43422 .42274 L .45025 .44124 L p F P
0 g
s
.77 .655 .735 r
.45025 .44124 m .44339 .45406 L .42589 .43325 L p F P
0 g
s
.767 .659 .743 r
.45709 .42912 m .45025 .44124 L .43422 .42274 L p F P
0 g
s
.767 .659 .743 r
.43422 .42274 m .44253 .41282 L .45709 .42912 L p F P
0 g
s
.764 .664 .752 r
.46392 .4177 m .45709 .42912 L .44253 .41282 L p F P
0 g
s
.773 .651 .727 r
.41753 .44436 m .42589 .43325 L .44339 .45406 L p F P
0 g
s
.773 .651 .727 r
.44339 .45406 m .43651 .4676 L .41753 .44436 L p F P
0 g
s
.761 .607 .688 r
.40865 .5291 m .41567 .51259 L .44387 .53915 L p F P
0 g
s
.761 .607 .688 r
.44387 .53915 m .43864 .55822 L .40865 .5291 L p F P
0 g
s
.652 .505 .671 r
.54445 .58127 m .54324 .55864 L .57522 .55788 L p F P
0 g
s
.653 .51 .676 r
.57183 .53614 m .57522 .55788 L .54324 .55864 L p F P
0 g
s
.764 .664 .752 r
.44253 .41282 m .45083 .40349 L .46392 .4177 L p F P
0 g
s
.759 .669 .762 r
.47074 .40697 m .46392 .4177 L .45083 .40349 L p F P
0 g
s
.776 .647 .72 r
.40914 .45608 m .41753 .44436 L .43651 .4676 L p F P
0 g
s
.776 .647 .72 r
.43651 .4676 m .42959 .48186 L .40914 .45608 L p F P
0 g
s
.648 .582 .767 r
.54537 .40232 m .5421 .39032 L .55199 .38732 L p F P
0 g
s
.648 .582 .767 r
.55199 .38732 m .55723 .39877 L .54537 .40232 L p F P
0 g
s
.737 .575 .673 r
.43336 .5782 m .43864 .55822 L .47242 .58117 L p F P
0 g
s
.737 .575 .673 r
.47242 .58117 m .46919 .60339 L .43336 .5782 L p F P
0 g
s
.71 .547 .666 r
.46919 .60339 m .47242 .58117 L .5086 .59701 L p F P
0 g
s
.703 .641 .784 r
.52159 .38 m .5206 .39094 L .50994 .38854 L p F P
0 g
s
.688 .625 .781 r
.5206 .39094 m .52159 .38 L .53031 .38037 L p F P
0 g
s
.688 .625 .781 r
.53031 .38037 m .53148 .39154 L .5206 .39094 L p F P
0 g
s
.623 .494 .684 r
.57183 .53614 m .56847 .51558 L .59434 .50864 L p F P
0 g
s
.625 .501 .691 r
.58896 .48964 m .59434 .50864 L .56847 .51558 L p F P
0 g
s
.739 .659 .771 r
.47755 .39692 m .48437 .38754 L .49492 .39455 L p F P
0 g
s
.733 .666 .784 r
.49999 .38445 m .49492 .39455 L .48437 .38754 L p F P
0 g
s
.721 .647 .774 r
.49492 .39455 m .49999 .38445 L .50994 .38854 L p F P
0 g
s
.671 .612 .78 r
.53148 .39154 m .53031 .38037 L .53882 .37932 L p F P
0 g
s
.671 .612 .78 r
.53882 .37932 m .5421 .39032 L .53148 .39154 L p F P
0 g
s
.759 .669 .762 r
.45083 .40349 m .45911 .39475 L .47074 .40697 L p F P
0 g
s
.754 .674 .773 r
.47755 .39692 m .47074 .40697 L .45911 .39475 L p F P
0 g
s
.778 .644 .714 r
.40071 .46841 m .40914 .45608 L .42959 .48186 L p F P
0 g
s
.778 .644 .714 r
.42959 .48186 m .42265 .49685 L .40071 .46841 L p F P
0 g
s
.717 .658 .79 r
.51305 .37822 m .50994 .38854 L .49999 .38445 L p F P
0 g
s
.703 .641 .784 r
.50994 .38854 m .51305 .37822 L .52159 .38 L p F P
0 g
s
.609 .524 .734 r
.57301 .43936 m .56774 .42478 L .58171 .41725 L p F P
0 g
s
.614 .538 .745 r
.56774 .42478 m .56248 .41125 L .57469 .40469 L p F P
0 g
s
.614 .538 .745 r
.57469 .40469 m .58171 .41725 L .56774 .42478 L p F P
0 g
s
.604 .512 .723 r
.5783 .45502 m .57301 .43936 L .58876 .43087 L p F P
0 g
s
.609 .524 .734 r
.58171 .41725 m .58876 .43087 L .57301 .43936 L p F P
0 g
s
.762 .604 .683 r
.40157 .54638 m .40865 .5291 L .43864 .55822 L p F P
0 g
s
.762 .604 .683 r
.43864 .55822 m .43336 .5782 L .40157 .54638 L p F P
0 g
s
.71 .547 .666 r
.5086 .59701 m .50756 .62094 L .46919 .60339 L p F P
0 g
s
.681 .521 .662 r
.50756 .62094 m .5086 .59701 L .54567 .60508 L p F P
0 g
s
.682 .525 .667 r
.54445 .58127 m .54567 .60508 L .5086 .59701 L p F P
0 g
s
.754 .674 .773 r
.45911 .39475 m .46739 .38658 L .47755 .39692 L p F P
0 g
s
.749 .68 .784 r
.48437 .38754 m .47755 .39692 L .46739 .38658 L p F P
0 g
s
.62 .554 .759 r
.56248 .41125 m .55723 .39877 L .56769 .39316 L p F P
0 g
s
.62 .554 .759 r
.56769 .39316 m .57469 .40469 L .56248 .41125 L p F P
0 g
s
.78 .64 .707 r
.39224 .48137 m .40071 .46841 L .42265 .49685 L p F P
0 g
s
.78 .64 .707 r
.42265 .49685 m .41567 .51259 L .39224 .48137 L p F P
0 g
s
.6 .501 .713 r
.58361 .47178 m .5783 .45502 L .59583 .44555 L p F P
0 g
s
.604 .512 .723 r
.58876 .43087 m .59583 .44555 L .5783 .45502 L p F P
0 g
s
.653 .601 .784 r
.5421 .39032 m .53882 .37932 L .54674 .37689 L p F P
0 g
s
.653 .601 .784 r
.54674 .37689 m .55199 .38732 L .5421 .39032 L p F P
0 g
s
.651 .5 .666 r
.54567 .60508 m .54445 .58127 L .57865 .5808 L p F P
0 g
s
.652 .505 .671 r
.57522 .55788 m .57865 .5808 L .54445 .58127 L p F P
0 g
s
.621 .487 .678 r
.57522 .55788 m .57183 .53614 L .59976 .52881 L p F P
0 g
s
.623 .494 .684 r
.59434 .50864 m .59976 .52881 L .57183 .53614 L p F P
0 g
s
.733 .666 .784 r
.48437 .38754 m .49119 .37884 L .49999 .38445 L p F P
0 g
s
.727 .675 .799 r
.50507 .37511 m .49999 .38445 L .49119 .37884 L p F P
0 g
s
.717 .658 .79 r
.49999 .38445 m .50507 .37511 L .51305 .37822 L p F P
0 g
s
.627 .572 .773 r
.55723 .39877 m .55199 .38732 L .56069 .38266 L p F P
0 g
s
.627 .572 .773 r
.56069 .38266 m .56769 .39316 L .55723 .39877 L p F P
0 g
s
.738 .572 .668 r
.42805 .5991 m .43336 .5782 L .46919 .60339 L p F P
0 g
s
.738 .572 .668 r
.46919 .60339 m .46592 .62666 L .42805 .5991 L p F P
0 g
s
.71 .544 .662 r
.46592 .62666 m .46919 .60339 L .50756 .62094 L p F P
0 g
s
.596 .491 .705 r
.58896 .48964 m .58361 .47178 L .60294 .46132 L p F P
0 g
s
.6 .501 .713 r
.59583 .44555 m .60294 .46132 L .58361 .47178 L p F P
0 g
s
.7 .656 .803 r
.52258 .36997 m .52159 .38 L .51305 .37822 L p F P
0 g
s
.687 .642 .8 r
.52159 .38 m .52258 .36997 L .52913 .37017 L p F P
0 g
s
.687 .642 .8 r
.52913 .37017 m .53031 .38037 L .52159 .38 L p F P
0 g
s
.673 .631 .8 r
.53031 .38037 m .52913 .37017 L .53553 .36933 L p F P
0 g
s
.673 .631 .8 r
.53553 .36933 m .53882 .37932 L .53031 .38037 L p F P
0 g
s
.749 .68 .784 r
.46739 .38658 m .47567 .37898 L .48437 .38754 L p F P
0 g
s
.742 .686 .797 r
.49119 .37884 m .48437 .38754 L .47567 .37898 L p F P
0 g
s
.781 .637 .702 r
.38373 .49497 m .39224 .48137 L .41567 .51259 L p F P
0 g
s
.781 .637 .702 r
.41567 .51259 m .40865 .5291 L .38373 .49497 L p F P
0 g
s
.711 .67 .808 r
.51616 .36874 m .51305 .37822 L .50507 .37511 L p F P
0 g
s
.7 .656 .803 r
.51305 .37822 m .51616 .36874 L .52258 .36997 L p F P
0 g
s
.762 .601 .678 r
.39445 .56446 m .40157 .54638 L .43336 .5782 L p F P
0 g
s
.762 .601 .678 r
.43336 .5782 m .42805 .5991 L .39445 .56446 L p F P
0 g
s
.634 .593 .79 r
.55199 .38732 m .54674 .37689 L .5537 .37318 L p F P
0 g
s
.634 .593 .79 r
.5537 .37318 m .56069 .38266 L .55199 .38732 L p F P
0 g
s
.658 .622 .803 r
.53882 .37932 m .53553 .36933 L .54148 .36748 L p F P
0 g
s
.658 .622 .803 r
.54148 .36748 m .54674 .37689 L .53882 .37932 L p F P
0 g
s
.592 .482 .697 r
.59434 .50864 m .58896 .48964 L .6101 .4782 L p F P
0 g
s
.596 .491 .705 r
.60294 .46132 m .6101 .4782 L .58896 .48964 L p F P
0 g
s
.71 .544 .662 r
.50756 .62094 m .50651 .64602 L .46592 .62666 L p F P
0 g
s
.681 .517 .658 r
.50651 .64602 m .50756 .62094 L .54691 .63009 L p F P
0 g
s
.681 .521 .662 r
.54567 .60508 m .54691 .63009 L .50756 .62094 L p F P
0 g
s
.778 .685 .762 r
.42225 .40198 m .43168 .39449 L .44253 .41282 L p F P
0 g
s
.778 .685 .762 r
.44253 .41282 m .43422 .42274 L .42225 .40198 L p F P
0 g
s
.773 .689 .771 r
.45083 .40349 m .44253 .41282 L .43168 .39449 L p F P
0 g
s
.619 .481 .673 r
.57865 .5808 m .57522 .55788 L .60523 .55016 L p F P
0 g
s
.621 .487 .678 r
.59976 .52881 m .60523 .55016 L .57522 .55788 L p F P
0 g
s
.782 .682 .754 r
.4128 .40995 m .42225 .40198 L .43422 .42274 L p F P
0 g
s
.782 .682 .754 r
.43422 .42274 m .42589 .43325 L .4128 .40995 L p F P
0 g
s
.773 .689 .771 r
.43168 .39449 m .44108 .38747 L .45083 .40349 L p F P
0 g
s
.767 .693 .78 r
.45911 .39475 m .45083 .40349 L .44108 .38747 L p F P
0 g
s
.727 .675 .799 r
.49119 .37884 m .49803 .37081 L .50507 .37511 L p F P
0 g
s
.719 .685 .816 r
.51017 .36653 m .50507 .37511 L .49803 .37081 L p F P
0 g
s
.711 .67 .808 r
.50507 .37511 m .51017 .36653 L .51616 .36874 L p F P
0 g
s
.742 .686 .797 r
.47567 .37898 m .48395 .37196 L .49119 .37884 L p F P
0 g
s
.734 .692 .811 r
.49803 .37081 m .49119 .37884 L .48395 .37196 L p F P
0 g
s
.783 .634 .696 r
.37516 .50921 m .38373 .49497 L .40865 .5291 L p F P
0 g
s
.783 .634 .696 r
.40865 .5291 m .40157 .54638 L .37516 .50921 L p F P
0 g
s
.65 .496 .661 r
.54691 .63009 m .54567 .60508 L .58211 .60496 L p F P
0 g
s
.651 .5 .666 r
.57865 .5808 m .58211 .60496 L .54567 .60508 L p F P
0 g
s
.786 .679 .746 r
.40332 .41841 m .4128 .40995 L .42589 .43325 L p F P
0 g
s
.786 .679 .746 r
.42589 .43325 m .41753 .44436 L .40332 .41841 L p F P
0 g
s
.767 .693 .78 r
.44108 .38747 m .45047 .38093 L .45911 .39475 L p F P
0 g
s
.761 .696 .79 r
.46739 .38658 m .45911 .39475 L .45047 .38093 L p F P
0 g
s
.738 .569 .664 r
.42268 .62095 m .42805 .5991 L .46592 .62666 L p F P
0 g
s
.738 .569 .664 r
.46592 .62666 m .46261 .65101 L .42268 .62095 L p F P
0 g
s
.71 .541 .658 r
.46261 .65101 m .46592 .62666 L .50651 .64602 L p F P
0 g
s
.789 .676 .739 r
.39381 .42736 m .40332 .41841 L .41753 .44436 L p F P
0 g
s
.789 .676 .739 r
.41753 .44436 m .40914 .45608 L .39381 .42736 L p F P
0 g
s
.761 .696 .79 r
.45047 .38093 m .45985 .37486 L .46739 .38658 L p F P
0 g
s
.754 .7 .801 r
.47567 .37898 m .46739 .38658 L .45985 .37486 L p F P
0 g
s
.588 .529 .756 r
.58171 .41725 m .57469 .40469 L .58471 .39593 L p F P
0 g
s
.597 .547 .769 r
.57469 .40469 m .56769 .39316 L .57625 .38574 L p F P
0 g
s
.597 .547 .769 r
.57625 .38574 m .58471 .39593 L .57469 .40469 L p F P
0 g
s
.642 .616 .808 r
.54674 .37689 m .54148 .36748 L .5467 .36471 L p F P
0 g
s
.642 .616 .808 r
.5467 .36471 m .5537 .37318 L .54674 .37689 L p F P
0 g
s
.581 .513 .744 r
.58876 .43087 m .58171 .41725 L .5932 .40712 L p F P
0 g
s
.588 .529 .756 r
.58471 .39593 m .5932 .40712 L .58171 .41725 L p F P
0 g
s
.695 .672 .824 r
.52357 .36085 m .52258 .36997 L .51616 .36874 L p F P
0 g
s
.685 .662 .822 r
.52258 .36997 m .52357 .36085 L .52796 .36093 L p F P
0 g
s
.685 .662 .822 r
.52796 .36093 m .52913 .37017 L .52258 .36997 L p F P
0 g
s
.589 .473 .69 r
.59976 .52881 m .59434 .50864 L .61732 .49621 L p F P
0 g
s
.592 .482 .697 r
.6101 .4782 m .61732 .49621 L .59434 .50864 L p F P
0 g
s
.763 .598 .673 r
.38726 .58334 m .39445 .56446 L .42805 .5991 L p F P
0 g
s
.763 .598 .673 r
.42805 .5991 m .42268 .62095 L .38726 .58334 L p F P
0 g
s
.674 .654 .822 r
.52913 .37017 m .52796 .36093 L .53223 .36033 L p F P
0 g
s
.674 .654 .822 r
.53223 .36033 m .53553 .36933 L .52913 .37017 L p F P
0 g
s
.606 .566 .784 r
.56769 .39316 m .56069 .38266 L .56781 .37656 L p F P
0 g
s
.606 .566 .784 r
.56781 .37656 m .57625 .38574 L .56769 .39316 L p F P
0 g
s
.792 .673 .733 r
.38425 .43681 m .39381 .42736 L .40914 .45608 L p F P
0 g
s
.792 .673 .733 r
.40914 .45608 m .40071 .46841 L .38425 .43681 L p F P
0 g
s
.703 .684 .828 r
.51928 .36009 m .51616 .36874 L .51017 .36653 L p F P
0 g
s
.695 .672 .824 r
.51616 .36874 m .51928 .36009 L .52357 .36085 L p F P
0 g
s
.574 .499 .733 r
.59583 .44555 m .58876 .43087 L .60172 .41933 L p F P
0 g
s
.581 .513 .744 r
.5932 .40712 m .60172 .41933 L .58876 .43087 L p F P
0 g
s
.754 .7 .801 r
.45985 .37486 m .46923 .36925 L .47567 .37898 L p F P
0 g
s
.746 .704 .812 r
.48395 .37196 m .47567 .37898 L .46923 .36925 L p F P
0 g
s
.734 .692 .811 r
.48395 .37196 m .49224 .3655 L .49803 .37081 L p F P
0 g
s
.724 .699 .826 r
.50488 .36344 m .49803 .37081 L .49224 .3655 L p F P
0 g
s
.719 .685 .816 r
.49803 .37081 m .50488 .36344 L .51017 .36653 L p F P
0 g
s
.662 .647 .824 r
.53553 .36933 m .53223 .36033 L .5362 .35908 L p F P
0 g
s
.662 .647 .824 r
.5362 .35908 m .54148 .36748 L .53553 .36933 L p F P
0 g
s
.784 .631 .691 r
.36653 .52411 m .37516 .50921 L .40157 .54638 L p F P
0 g
s
.784 .631 .691 r
.40157 .54638 m .39445 .56446 L .36653 .52411 L p F P
0 g
s
.616 .588 .799 r
.56069 .38266 m .5537 .37318 L .55938 .36836 L p F P
0 g
s
.616 .588 .799 r
.55938 .36836 m .56781 .37656 L .56069 .38266 L p F P
0 g
s
.617 .476 .667 r
.58211 .60496 m .57865 .5808 L .61076 .57273 L p F P
0 g
s
.619 .481 .673 r
.60523 .55016 m .61076 .57273 L .57865 .5808 L p F P
0 g
s
.709 .695 .835 r
.51528 .3587 m .51017 .36653 L .50488 .36344 L p F P
0 g
s
.703 .684 .828 r
.51017 .36653 m .51528 .3587 L .51928 .36009 L p F P
0 g
s
.567 .486 .723 r
.60294 .46132 m .59583 .44555 L .61029 .43258 L p F P
0 g
s
.574 .499 .733 r
.60172 .41933 m .61029 .43258 L .59583 .44555 L p F P
0 g
s
.71 .541 .658 r
.50651 .64602 m .50544 .67229 L .46261 .65101 L p F P
0 g
s
.68 .514 .654 r
.50544 .67229 m .50651 .64602 L .54816 .65634 L p F P
0 g
s
.681 .517 .658 r
.54691 .63009 m .54816 .65634 L .50651 .64602 L p F P
0 g
s
.795 .67 .726 r
.37466 .44675 m .38425 .43681 L .40071 .46841 L p F P
0 g
s
.795 .67 .726 r
.40071 .46841 m .39224 .48137 L .37466 .44675 L p F P
0 g
s
.746 .704 .812 r
.46923 .36925 m .4786 .36411 L .48395 .37196 L p F P
0 g
s
.737 .708 .824 r
.49224 .3655 m .48395 .37196 L .4786 .36411 L p F P
0 g
s
.651 .643 .829 r
.54148 .36748 m .5362 .35908 L .53968 .35724 L p F P
0 g
s
.651 .643 .829 r
.53968 .35724 m .5467 .36471 L .54148 .36748 L p F P
0 g
s
.627 .613 .817 r
.5537 .37318 m .5467 .36471 L .55095 .36114 L p F P
0 g
s
.627 .613 .817 r
.55095 .36114 m .55938 .36836 L .5537 .37318 L p F P
0 g
s
.649 .492 .657 r
.54816 .65634 m .54691 .63009 L .5856 .63038 L p F P
0 g
s
.65 .496 .661 r
.58211 .60496 m .5856 .63038 L .54691 .63009 L p F P
0 g
s
.586 .466 .683 r
.60523 .55016 m .59976 .52881 L .62459 .51537 L p F P
0 g
s
.589 .473 .69 r
.61732 .49621 m .62459 .51537 L .59976 .52881 L p F P
0 g
s
.738 .566 .66 r
.41725 .64377 m .42268 .62095 L .46261 .65101 L p F P
0 g
s
.738 .566 .66 r
.46261 .65101 m .45927 .67646 L .41725 .64377 L p F P
0 g
s
.71 .538 .654 r
.45927 .67646 m .46261 .65101 L .50544 .67229 L p F P
0 g
s
.797 .668 .72 r
.36501 .45721 m .37466 .44675 L .39224 .48137 L p F P
0 g
s
.797 .668 .72 r
.39224 .48137 m .38373 .49497 L .36501 .45721 L p F P
0 g
s
.562 .475 .714 r
.6101 .4782 m .60294 .46132 L .6189 .44688 L p F P
0 g
s
.567 .486 .723 r
.61029 .43258 m .6189 .44688 L .60294 .46132 L p F P
0 g
s
.764 .595 .669 r
.38001 .60306 m .38726 .58334 L .42268 .62095 L p F P
0 g
s
.764 .595 .669 r
.42268 .62095 m .41725 .64377 L .38001 .60306 L p F P
0 g
s
.724 .699 .826 r
.49224 .3655 m .50054 .35961 L .50488 .36344 L p F P
0 g
s
.712 .706 .842 r
.51175 .35674 m .50488 .36344 L .50054 .35961 L p F P
0 g
s
.709 .695 .835 r
.50488 .36344 m .51175 .35674 L .51528 .3587 L p F P
0 g
s
.785 .629 .687 r
.35785 .53968 m .36653 .52411 L .39445 .56446 L p F P
0 g
s
.785 .629 .687 r
.39445 .56446 m .38726 .58334 L .35785 .53968 L p F P
0 g
s
.737 .708 .824 r
.4786 .36411 m .48797 .35943 L .49224 .3655 L p F P
0 g
s
.726 .712 .837 r
.50054 .35961 m .49224 .3655 L .48797 .35943 L p F P
0 g
s
.688 .692 .848 r
.52457 .35263 m .52357 .36085 L .51928 .36009 L p F P
0 g
s
.681 .685 .847 r
.52357 .36085 m .52457 .35263 L .52677 .35264 L p F P
0 g
s
.681 .685 .847 r
.52677 .35264 m .52796 .36093 L .52357 .36085 L p F P
0 g
s
.674 .68 .847 r
.52796 .36093 m .52677 .35264 L .52891 .35233 L p F P
0 g
s
.674 .68 .847 r
.52891 .35233 m .53223 .36033 L .52796 .36093 L p F P
0 g
s
.693 .699 .851 r
.52242 .35229 m .51928 .36009 L .51528 .3587 L p F P
0 g
s
.688 .692 .848 r
.51928 .36009 m .52242 .35229 L .52457 .35263 L p F P
0 g
s
.64 .641 .836 r
.5467 .36471 m .53968 .35724 L .54251 .35489 L p F P
0 g
s
.64 .641 .836 r
.54251 .35489 m .55095 .36114 L .5467 .36471 L p F P
0 g
s
.667 .676 .849 r
.53223 .36033 m .52891 .35233 L .5309 .3517 L p F P
0 g
s
.667 .676 .849 r
.5309 .3517 m .5362 .35908 L .53223 .36033 L p F P
0 g
s
.574 .544 .783 r
.58471 .39593 m .57625 .38574 L .58252 .37683 L p F P
0 g
s
.586 .565 .797 r
.57625 .38574 m .56781 .37656 L .57301 .36927 L p F P
0 g
s
.586 .565 .797 r
.57301 .36927 m .58252 .37683 L .57625 .38574 L p F P
0 g
s
.769 .713 .8 r
.43516 .37033 m .44524 .36612 L .45047 .38093 L p F P
0 g
s
.769 .713 .8 r
.45047 .38093 m .44108 .38747 L .43516 .37033 L p F P
0 g
s
.762 .715 .809 r
.45985 .37486 m .45047 .38093 L .44524 .36612 L p F P
0 g
s
.776 .711 .792 r
.42506 .37491 m .43516 .37033 L .44108 .38747 L p F P
0 g
s
.776 .711 .792 r
.44108 .38747 m .43168 .39449 L .42506 .37491 L p F P
0 g
s
.6 .589 .812 r
.56781 .37656 m .55938 .36836 L .56352 .36263 L p F P
0 g
s
.6 .589 .812 r
.56352 .36263 m .57301 .36927 L .56781 .37656 L p F P
0 g
s
.799 .665 .715 r
.35531 .46818 m .36501 .45721 L .38373 .49497 L p F P
0 g
s
.799 .665 .715 r
.38373 .49497 m .37516 .50921 L .35531 .46818 L p F P
0 g
s
.696 .706 .855 r
.52042 .35163 m .51528 .3587 L .51175 .35674 L p F P
0 g
s
.693 .699 .851 r
.51528 .3587 m .52042 .35163 L .52242 .35229 L p F P
0 g
s
.615 .471 .663 r
.5856 .63038 m .58211 .60496 L .61635 .59656 L p F P
0 g
s
.617 .476 .667 r
.61076 .57273 m .61635 .59656 L .58211 .60496 L p F P
0 g
s
.762 .715 .809 r
.44524 .36612 m .45531 .36226 L .45985 .37486 L p F P
0 g
s
.754 .717 .818 r
.46923 .36925 m .45985 .37486 L .45531 .36226 L p F P
0 g
s
.563 .524 .771 r
.5932 .40712 m .58471 .39593 L .59207 .38534 L p F P
0 g
s
.574 .544 .783 r
.58252 .37683 m .59207 .38534 L .58471 .39593 L p F P
0 g
s
.781 .709 .784 r
.41493 .37985 m .42506 .37491 L .43168 .39449 L p F P
0 g
s
.781 .709 .784 r
.43168 .39449 m .42225 .40198 L .41493 .37985 L p F P
0 g
s
.66 .673 .852 r
.5362 .35908 m .5309 .3517 L .53265 .35078 L p F P
0 g
s
.66 .673 .852 r
.53265 .35078 m .53968 .35724 L .5362 .35908 L p F P
0 g
s
.556 .465 .706 r
.61732 .49621 m .6101 .4782 L .62759 .46225 L p F P
0 g
s
.562 .475 .714 r
.6189 .44688 m .62759 .46225 L .6101 .4782 L p F P
0 g
s
.754 .717 .818 r
.45531 .36226 m .46536 .35877 L .46923 .36925 L p F P
0 g
s
.745 .719 .828 r
.4786 .36411 m .46923 .36925 L .46536 .35877 L p F P
0 g
s
.726 .712 .837 r
.48797 .35943 m .49735 .35521 L .50054 .35961 L p F P
0 g
s
.713 .715 .85 r
.50886 .35428 m .50054 .35961 L .49735 .35521 L p F P
0 g
s
.712 .706 .842 r
.50054 .35961 m .50886 .35428 L .51175 .35674 L p F P
0 g
s
.614 .614 .828 r
.55938 .36836 m .55095 .36114 L .55404 .35692 L p F P
0 g
s
.614 .614 .828 r
.55404 .35692 m .56352 .36263 L .55938 .36836 L p F P
0 g
s
.787 .707 .776 r
.40477 .38517 m .41493 .37985 L .42225 .40198 L p F P
0 g
s
.787 .707 .776 r
.42225 .40198 m .4128 .40995 L .40477 .38517 L p F P
0 g
s
.71 .538 .654 r
.50544 .67229 m .50436 .69979 L .45927 .67646 L p F P
0 g
s
.68 .511 .651 r
.50436 .69979 m .50544 .67229 L .54942 .68388 L p F P
0 g
s
.68 .514 .654 r
.54816 .65634 m .54942 .68388 L .50544 .67229 L p F P
0 g
s
.583 .459 .677 r
.61076 .57273 m .60523 .55016 L .63194 .53572 L p F P
0 g
s
.586 .466 .683 r
.62459 .51537 m .63194 .53572 L .60523 .55016 L p F P
0 g
s
.552 .507 .759 r
.60172 .41933 m .5932 .40712 L .60165 .3948 L p F P
0 g
s
.563 .524 .771 r
.59207 .38534 m .60165 .3948 L .5932 .40712 L p F P
0 g
s
.698 .713 .86 r
.51865 .3507 m .51175 .35674 L .50886 .35428 L p F P
0 g
s
.696 .706 .855 r
.51175 .35674 m .51865 .3507 L .52042 .35163 L p F P
0 g
s
.745 .719 .828 r
.46536 .35877 m .4754 .35564 L .4786 .36411 L p F P
0 g
s
.735 .721 .838 r
.48797 .35943 m .4786 .36411 L .4754 .35564 L p F P
0 g
s
.786 .626 .682 r
.34909 .55593 m .35785 .53968 L .38726 .58334 L p F P
0 g
s
.786 .626 .682 r
.38726 .58334 m .38001 .60306 L .34909 .55593 L p F P
0 g
s
.792 .705 .769 r
.39458 .39085 m .40477 .38517 L .4128 .40995 L p F P
0 g
s
.792 .705 .769 r
.4128 .40995 m .40332 .41841 L .39458 .39085 L p F P
0 g
s
.648 .488 .653 r
.54942 .68388 m .54816 .65634 L .58915 .65711 L p F P
0 g
s
.649 .492 .657 r
.5856 .63038 m .58915 .65711 L .54816 .65634 L p F P
0 g
s
.653 .673 .857 r
.53968 .35724 m .53265 .35078 L .53406 .34962 L p F P
0 g
s
.653 .673 .857 r
.53406 .34962 m .54251 .35489 L .53968 .35724 L p F P
0 g
s
.63 .643 .845 r
.55095 .36114 m .54251 .35489 L .54456 .35214 L p F P
0 g
s
.63 .643 .845 r
.54456 .35214 m .55404 .35692 L .55095 .36114 L p F P
0 g
s
.764 .593 .666 r
.37269 .62362 m .38001 .60306 L .41725 .64377 L p F P
0 g
s
.764 .593 .666 r
.41725 .64377 m .41177 .66759 L .37269 .62362 L p F P
0 g
s
.738 .563 .657 r
.41177 .66759 m .41725 .64377 L .45927 .67646 L p F P
0 g
s
.801 .663 .71 r
.34555 .47967 m .35531 .46818 L .37516 .50921 L p F P
0 g
s
.801 .663 .71 r
.37516 .50921 m .36653 .52411 L .34555 .47967 L p F P
0 g
s
.738 .563 .657 r
.45927 .67646 m .45589 .70306 L .41177 .66759 L p F P
0 g
s
.71 .535 .651 r
.45589 .70306 m .45927 .67646 L .50436 .69979 L p F P
0 g
s
.735 .721 .838 r
.4754 .35564 m .48543 .35286 L .48797 .35943 L p F P
0 g
s
.724 .722 .848 r
.49735 .35521 m .48797 .35943 L .48543 .35286 L p F P
0 g
s
.543 .491 .748 r
.61029 .43258 m .60172 .41933 L .61128 .40523 L p F P
0 g
s
.552 .507 .759 r
.60165 .3948 m .61128 .40523 L .60172 .41933 L p F P
0 g
s
.796 .703 .762 r
.38435 .39691 m .39458 .39085 L .40332 .41841 L p F P
0 g
s
.796 .703 .762 r
.40332 .41841 m .39381 .42736 L .38435 .39691 L p F P
0 g
s
.713 .715 .85 r
.49735 .35521 m .50674 .35145 L .50886 .35428 L p F P
0 g
s
.698 .719 .865 r
.51721 .34952 m .50886 .35428 L .50674 .35145 L p F P
0 g
s
.698 .713 .86 r
.50886 .35428 m .51721 .34952 L .51865 .3507 L p F P
0 g
s
.552 .455 .699 r
.62459 .51537 m .61732 .49621 L .63634 .47872 L p F P
0 g
s
.556 .465 .706 r
.62759 .46225 m .63634 .47872 L .61732 .49621 L p F P
0 g
s
.677 .713 .876 r
.52558 .34532 m .52457 .35263 L .52242 .35229 L closepath p F P
0 g
s
.675 .712 .876 r
.52558 .34532 m .52677 .35264 L .52457 .35263 L closepath p F P
0 g
s
.673 .71 .876 r
.52558 .34532 m .52891 .35233 L .52677 .35264 L closepath p F P
0 g
s
.724 .722 .848 r
.48543 .35286 m .49546 .35044 L .49735 .35521 L p F P
0 g
s
.711 .723 .859 r
.50674 .35145 m .49735 .35521 L .49546 .35044 L p F P
0 g
s
.647 .674 .862 r
.54251 .35489 m .53406 .34962 L .53508 .34827 L p F P
0 g
s
.647 .674 .862 r
.53508 .34827 m .54456 .35214 L .54251 .35489 L p F P
0 g
s
.678 .715 .877 r
.52558 .34532 m .52242 .35229 L .52042 .35163 L closepath p F P
0 g
s
.671 .709 .877 r
.52558 .34532 m .5309 .3517 L .52891 .35233 L closepath p F P
0 g
s
.8 .701 .756 r
.37408 .40335 m .38435 .39691 L .39381 .42736 L p F P
0 g
s
.8 .701 .756 r
.39381 .42736 m .38425 .43681 L .37408 .40335 L p F P
0 g
s
.68 .717 .877 r
.52558 .34532 m .52042 .35163 L .51865 .3507 L closepath p F P
0 g
s
.669 .709 .877 r
.52558 .34532 m .53265 .35078 L .5309 .3517 L closepath p F P
0 g
s
.534 .476 .738 r
.6189 .44688 m .61029 .43258 L .62097 .41663 L p F P
0 g
s
.543 .491 .748 r
.61128 .40523 m .62097 .41663 L .61029 .43258 L p F P
0 g
s
.614 .467 .658 r
.58915 .65711 m .5856 .63038 L .622 .62168 L p F P
0 g
s
.615 .471 .663 r
.61635 .59656 m .622 .62168 L .5856 .63038 L p F P
0 g
s
.586 .593 .827 r
.57301 .36927 m .56352 .36263 L .56591 .35626 L p F P
0 g
s
.603 .62 .84 r
.56352 .36263 m .55404 .35692 L .55581 .35226 L p F P
0 g
s
.603 .62 .84 r
.55581 .35226 m .56591 .35626 L .56352 .36263 L p F P
0 g
s
.58 .453 .672 r
.61635 .59656 m .61076 .57273 L .63936 .55728 L p F P
0 g
s
.583 .459 .677 r
.63194 .53572 m .63936 .55728 L .61076 .57273 L p F P
0 g
s
.681 .719 .879 r
.52558 .34532 m .51865 .3507 L .51721 .34952 L closepath p F P
0 g
s
.569 .569 .814 r
.58252 .37683 m .57301 .36927 L .57603 .36112 L p F P
0 g
s
.586 .593 .827 r
.56591 .35626 m .57603 .36112 L .57301 .36927 L p F P
0 g
s
.803 .66 .705 r
.33573 .4917 m .34555 .47967 L .36653 .52411 L p F P
0 g
s
.803 .66 .705 r
.36653 .52411 m .35785 .53968 L .33573 .4917 L p F P
0 g
s
.622 .648 .854 r
.55404 .35692 m .54456 .35214 L .54573 .34911 L p F P
0 g
s
.622 .648 .854 r
.54573 .34911 m .55581 .35226 L .55404 .35692 L p F P
0 g
s
.787 .624 .678 r
.34026 .57288 m .34909 .55593 L .38001 .60306 L p F P
0 g
s
.787 .624 .678 r
.38001 .60306 m .37269 .62362 L .34026 .57288 L p F P
0 g
s
.667 .708 .879 r
.52558 .34532 m .53406 .34962 L .53265 .35078 L closepath p F P
0 g
s
.711 .723 .859 r
.49546 .35044 m .5055 .34838 L .50674 .35145 L p F P
0 g
s
.697 .724 .87 r
.51615 .34816 m .50674 .35145 L .5055 .34838 L p F P
0 g
s
.698 .719 .865 r
.50674 .35145 m .51615 .34816 L .51721 .34952 L p F P
0 g
s
.804 .699 .75 r
.36377 .41017 m .37408 .40335 L .38425 .43681 L p F P
0 g
s
.804 .699 .75 r
.38425 .43681 m .37466 .44675 L .36377 .41017 L p F P
0 g
s
.553 .547 .801 r
.59207 .38534 m .58252 .37683 L .58618 .36682 L p F P
0 g
s
.569 .569 .814 r
.57603 .36112 m .58618 .36682 L .58252 .37683 L p F P
0 g
s
.642 .678 .868 r
.54456 .35214 m .53508 .34827 L .53566 .34679 L p F P
0 g
s
.642 .678 .868 r
.53566 .34679 m .54573 .34911 L .54456 .35214 L p F P
0 g
s
.681 .722 .88 r
.52558 .34532 m .51721 .34952 L .51615 .34816 L closepath p F P
0 g
s
.71 .535 .651 r
.50436 .69979 m .50327 .72855 L .45589 .70306 L p F P
0 g
s
.679 .508 .647 r
.50327 .72855 m .50436 .69979 L .5507 .71274 L p F P
0 g
s
.68 .511 .651 r
.54942 .68388 m .5507 .71274 L .50436 .69979 L p F P
0 g
s
.665 .709 .88 r
.52558 .34532 m .53508 .34827 L .53406 .34962 L closepath p F P
0 g
s
.739 .73 .843 r
.46428 .34803 m .47453 .34694 L .4754 .35564 L p F P
0 g
s
.739 .73 .843 r
.4754 .35564 m .46536 .35877 L .46428 .34803 L p F P
0 g
s
.729 .73 .851 r
.48543 .35286 m .4754 .35564 L .47453 .34694 L p F P
0 g
s
.764 .591 .662 r
.36529 .64505 m .37269 .62362 L .41177 .66759 L p F P
0 g
s
.764 .591 .662 r
.41177 .66759 m .40622 .69244 L .36529 .64505 L p F P
0 g
s
.738 .561 .653 r
.40622 .69244 m .41177 .66759 L .45589 .70306 L p F P
0 g
s
.729 .73 .851 r
.47453 .34694 m .48476 .3461 L .48543 .35286 L p F P
0 g
s
.719 .73 .859 r
.49546 .35044 m .48543 .35286 L .48476 .3461 L p F P
0 g
s
.748 .731 .836 r
.454 .34937 m .46428 .34803 L .46536 .35877 L p F P
0 g
s
.748 .731 .836 r
.46536 .35877 m .45531 .36226 L .454 .34937 L p F P
0 g
s
.647 .485 .649 r
.5507 .71274 m .54942 .68388 L .59273 .68518 L p F P
0 g
s
.648 .488 .653 r
.58915 .65711 m .59273 .68518 L .54942 .68388 L p F P
0 g
s
.719 .73 .859 r
.48476 .3461 m .49498 .34553 L .49546 .35044 L p F P
0 g
s
.707 .729 .867 r
.5055 .34838 m .49546 .35044 L .49498 .34553 L p F P
0 g
s
.697 .724 .87 r
.5055 .34838 m .51553 .34667 L .51615 .34816 L p F P
0 g
s
.681 .724 .882 r
.52558 .34532 m .51615 .34816 L .51553 .34667 L closepath p F P
0 g
s
.547 .447 .692 r
.63194 .53572 m .62459 .51537 L .64518 .49632 L p F P
0 g
s
.552 .455 .699 r
.63634 .47872 m .64518 .49632 L .62459 .51537 L p F P
0 g
s
.757 .73 .828 r
.44371 .35097 m .454 .34937 L .45531 .36226 L p F P
0 g
s
.757 .73 .828 r
.45531 .36226 m .44524 .36612 L .44371 .35097 L p F P
0 g
s
.539 .526 .789 r
.60165 .3948 m .59207 .38534 L .59638 .3734 L p F P
0 g
s
.553 .547 .801 r
.58618 .36682 m .59638 .3734 L .59207 .38534 L p F P
0 g
s
.526 .463 .728 r
.62759 .46225 m .6189 .44688 L .63072 .42903 L p F P
0 g
s
.534 .476 .738 r
.62097 .41663 m .63072 .42903 L .6189 .44688 L p F P
0 g
s
.663 .709 .882 r
.52558 .34532 m .53566 .34679 L .53508 .34827 L closepath p F P
0 g
s
.807 .697 .744 r
.35341 .41738 m .36377 .41017 L .37466 .44675 L p F P
0 g
s
.807 .697 .744 r
.37466 .44675 m .36501 .45721 L .35341 .41738 L p F P
0 g
s
.707 .729 .867 r
.49498 .34553 m .50519 .3452 L .5055 .34838 L p F P
0 g
s
.695 .727 .875 r
.51553 .34667 m .5055 .34838 L .50519 .3452 L p F P
0 g
s
.738 .561 .653 r
.45589 .70306 m .45247 .73082 L .40622 .69244 L p F P
0 g
s
.71 .533 .648 r
.45247 .73082 m .45589 .70306 L .50327 .72855 L p F P
0 g
s
.764 .73 .821 r
.43339 .35283 m .44371 .35097 L .44524 .36612 L p F P
0 g
s
.764 .73 .821 r
.44524 .36612 m .43516 .37033 L .43339 .35283 L p F P
0 g
s
.805 .658 .7 r
.32584 .50427 m .33573 .4917 L .35785 .53968 L p F P
0 g
s
.805 .658 .7 r
.35785 .53968 m .34909 .55593 L .32584 .50427 L p F P
0 g
s
.695 .727 .875 r
.50519 .3452 m .51539 .34513 L .51553 .34667 L p F P
0 g
s
.681 .725 .883 r
.52558 .34532 m .51553 .34667 L .51539 .34513 L closepath p F P
0 g
s
.618 .655 .864 r
.55581 .35226 m .54573 .34911 L .54596 .34594 L p F P
0 g
s
.64 .682 .874 r
.54573 .34911 m .53566 .34679 L .53576 .34526 L p F P
0 g
s
.64 .682 .874 r
.53576 .34526 m .54596 .34594 L .54573 .34911 L p F P
0 g
s
.771 .73 .814 r
.42305 .35495 m .43339 .35283 L .43516 .37033 L p F P
0 g
s
.771 .73 .814 r
.43516 .37033 m .42506 .37491 L .42305 .35495 L p F P
0 g
s
.662 .71 .883 r
.52558 .34532 m .53576 .34526 L .53566 .34679 L closepath p F P
0 g
s
.596 .629 .854 r
.56591 .35626 m .55581 .35226 L .55618 .34737 L p F P
0 g
s
.618 .655 .864 r
.54596 .34594 m .55618 .34737 L .55581 .35226 L p F P
0 g
s
.526 .506 .778 r
.61128 .40523 m .60165 .3948 L .60663 .38084 L p F P
0 g
s
.539 .526 .789 r
.59638 .3734 m .60663 .38084 L .60165 .3948 L p F P
0 g
s
.661 .716 .889 r
.52558 .34532 m .53331 .34101 L .53456 .34229 L closepath p F P
0 g
s
.662 .718 .89 r
.52558 .34532 m .5317 .33993 L .53331 .34101 L closepath p F P
0 g
s
.663 .72 .891 r
.52558 .34532 m .52979 .33912 L .5317 .33993 L closepath p F P
0 g
s
.665 .722 .892 r
.52558 .34532 m .52769 .33861 L .52979 .33912 L closepath p F P
0 g
s
.666 .724 .892 r
.52558 .34532 m .52549 .33843 L .52769 .33861 L closepath p F P
0 g
s
.668 .726 .892 r
.52558 .34532 m .52329 .33859 L .52549 .33843 L closepath p F P
0 g
s
.671 .727 .892 r
.52558 .34532 m .5212 .33907 L .52329 .33859 L closepath p F P
0 g
s
.673 .728 .891 r
.52558 .34532 m .51931 .33986 L .5212 .33907 L closepath p F P
0 g
s
.675 .728 .89 r
.52558 .34532 m .51773 .34091 L .51931 .33986 L closepath p F P
0 g
s
.677 .728 .889 r
.52558 .34532 m .51651 .34219 L .51773 .34091 L closepath p F P
0 g
s
.679 .728 .887 r
.52558 .34532 m .51572 .34361 L .51651 .34219 L closepath p F P
0 g
s
.68 .727 .885 r
.52558 .34532 m .51539 .34513 L .51572 .34361 L closepath p F P
0 g
s
.662 .712 .885 r
.52558 .34532 m .53539 .34373 L .53576 .34526 L closepath p F P
0 g
s
.661 .714 .887 r
.52558 .34532 m .53456 .34229 L .53539 .34373 L closepath p F P
0 g
s
.778 .729 .807 r
.41267 .35733 m .42305 .35495 L .42506 .37491 L p F P
0 g
s
.778 .729 .807 r
.42506 .37491 m .41493 .37985 L .41267 .35733 L p F P
0 g
s
.788 .622 .675 r
.33134 .59054 m .34026 .57288 L .37269 .62362 L p F P
0 g
s
.788 .622 .675 r
.37269 .62362 m .36529 .64505 L .33134 .59054 L p F P
0 g
s
.576 .603 .843 r
.57603 .36112 m .56591 .35626 L .56642 .34955 L p F P
0 g
s
.596 .629 .854 r
.55618 .34737 m .56642 .34955 L .56591 .35626 L p F P
0 g
s
.691 .729 .88 r
.50583 .34207 m .51572 .34361 L .51539 .34513 L p F P
0 g
s
.691 .729 .88 r
.51539 .34513 m .50519 .3452 L .50583 .34207 L p F P
0 g
s
.81 .695 .738 r
.34299 .42498 m .35341 .41738 L .36501 .45721 L p F P
0 g
s
.81 .695 .738 r
.36501 .45721 m .35531 .46818 L .34299 .42498 L p F P
0 g
s
.639 .688 .88 r
.54596 .34594 m .53576 .34526 L .53539 .34373 L p F P
0 g
s
.578 .448 .667 r
.622 .62168 m .61635 .59656 L .64688 .58009 L p F P
0 g
s
.58 .453 .672 r
.63936 .55728 m .64688 .58009 L .61635 .59656 L p F P
0 g
s
.701 .732 .874 r
.49593 .34069 m .50583 .34207 L .50519 .3452 L p F P
0 g
s
.701 .732 .874 r
.50519 .3452 m .49498 .34553 L .49593 .34069 L p F P
0 g
s
.613 .463 .654 r
.59273 .68518 m .58915 .65711 L .62773 .64814 L p F P
0 g
s
.614 .467 .658 r
.622 .62168 m .62773 .64814 L .58915 .65711 L p F P
0 g
s
.784 .728 .801 r
.40226 .35998 m .41267 .35733 L .41493 .37985 L p F P
0 g
s
.784 .728 .801 r
.41493 .37985 m .40477 .38517 L .40226 .35998 L p F P
0 g
s
.519 .451 .719 r
.63634 .47872 m .62759 .46225 L .64055 .44244 L p F P
0 g
s
.526 .463 .728 r
.63072 .42903 m .64055 .44244 L .62759 .46225 L p F P
0 g
s
.711 .734 .869 r
.486 .33947 m .49593 .34069 L .49498 .34553 L p F P
0 g
s
.711 .734 .869 r
.49498 .34553 m .48476 .3461 L .486 .33947 L p F P
0 g
s
.556 .579 .832 r
.58618 .36682 m .57603 .36112 L .5767 .35248 L p F P
0 g
s
.576 .603 .843 r
.56642 .34955 m .5767 .35248 L .57603 .36112 L p F P
0 g
s
.687 .73 .884 r
.5074 .33913 m .51651 .34219 L .51572 .34361 L p F P
0 g
s
.687 .73 .884 r
.51572 .34361 m .50583 .34207 L .5074 .33913 L p F P
0 g
s
.616 .664 .874 r
.55618 .34737 m .54596 .34594 L .54523 .34278 L p F P
0 g
s
.639 .688 .88 r
.53539 .34373 m .54523 .34278 L .54596 .34594 L p F P
0 g
s
.64 .695 .885 r
.54523 .34278 m .53539 .34373 L .53456 .34229 L p F P
0 g
s
.513 .489 .767 r
.62097 .41663 m .61128 .40523 L .61694 .38917 L p F P
0 g
s
.526 .506 .778 r
.60663 .38084 m .61694 .38917 L .61128 .40523 L p F P
0 g
s
.544 .439 .685 r
.63936 .55728 m .63194 .53572 L .6541 .51506 L p F P
0 g
s
.547 .447 .692 r
.64518 .49632 m .6541 .51506 L .63194 .53572 L p F P
0 g
s
.721 .736 .863 r
.47604 .33841 m .486 .33947 L .48476 .3461 L p F P
0 g
s
.721 .736 .863 r
.48476 .3461 m .47453 .34694 L .47604 .33841 L p F P
0 g
s
.806 .656 .696 r
.31588 .51738 m .32584 .50427 L .34909 .55593 L p F P
0 g
s
.806 .656 .696 r
.34909 .55593 m .34026 .57288 L .31588 .51738 L p F P
0 g
s
.789 .727 .794 r
.39181 .36289 m .40226 .35998 L .40477 .38517 L p F P
0 g
s
.789 .727 .794 r
.40477 .38517 m .39458 .39085 L .39181 .36289 L p F P
0 g
s
.765 .588 .659 r
.35781 .66738 m .36529 .64505 L .40622 .69244 L p F P
0 g
s
.765 .588 .659 r
.40622 .69244 m .40061 .71835 L .35781 .66738 L p F P
0 g
s
.738 .559 .65 r
.40061 .71835 m .40622 .69244 L .45247 .73082 L p F P
0 g
s
.71 .533 .648 r
.50327 .72855 m .50216 .75863 L .45247 .73082 L p F P
0 g
s
.679 .505 .644 r
.50216 .75863 m .50327 .72855 L .552 .74297 L p F P
0 g
s
.679 .508 .647 r
.5507 .71274 m .552 .74297 L .50327 .72855 L p F P
0 g
s
.682 .73 .887 r
.50984 .33652 m .51773 .34091 L .51651 .34219 L p F P
0 g
s
.682 .73 .887 r
.51651 .34219 m .5074 .33913 L .50984 .33652 L p F P
0 g
s
.813 .693 .733 r
.33252 .43297 m .34299 .42498 L .35531 .46818 L p F P
0 g
s
.813 .693 .733 r
.35531 .46818 m .34555 .47967 L .33252 .43297 L p F P
0 g
s
.642 .701 .889 r
.54358 .33978 m .53456 .34229 L .53331 .34101 L p F P
0 g
s
.64 .695 .885 r
.53456 .34229 m .54358 .33978 L .54523 .34278 L p F P
0 g
s
.594 .641 .867 r
.56642 .34955 m .55618 .34737 L .55511 .34246 L p F P
0 g
s
.616 .664 .874 r
.54523 .34278 m .55511 .34246 L .55618 .34737 L p F P
0 g
s
.729 .737 .858 r
.46606 .33751 m .47604 .33841 L .47453 .34694 L p F P
0 g
s
.729 .737 .858 r
.47453 .34694 m .46428 .34803 L .46606 .33751 L p F P
0 g
s
.538 .556 .821 r
.59638 .3734 m .58618 .36682 L .58703 .35617 L p F P
0 g
s
.556 .579 .832 r
.5767 .35248 m .58703 .35617 L .58618 .36682 L p F P
0 g
s
.695 .733 .88 r
.49827 .33616 m .5074 .33913 L .50583 .34207 L p F P
0 g
s
.695 .733 .88 r
.50583 .34207 m .49593 .34069 L .49827 .33616 L p F P
0 g
s
.646 .482 .646 r
.552 .74297 m .5507 .71274 L .59638 .71465 L p F P
0 g
s
.647 .485 .649 r
.59273 .68518 m .59638 .71465 L .5507 .71274 L p F P
0 g
s
.678 .73 .889 r
.51301 .33437 m .51931 .33986 L .51773 .34091 L p F P
0 g
s
.678 .73 .889 r
.51773 .34091 m .50984 .33652 L .51301 .33437 L p F P
0 g
s
.642 .701 .889 r
.53331 .34101 m .54108 .33708 L .54358 .33978 L p F P
0 g
s
.646 .707 .892 r
.54108 .33708 m .53331 .34101 L .5317 .33993 L p F P
0 g
s
.618 .675 .882 r
.55511 .34246 m .54523 .34278 L .54358 .33978 L p F P
0 g
s
.795 .726 .788 r
.38132 .36606 m .39181 .36289 L .39458 .39085 L p F P
0 g
s
.795 .726 .788 r
.39458 .39085 m .38435 .39691 L .38132 .36606 L p F P
0 g
s
.738 .559 .65 r
.45247 .73082 m .44899 .75981 L .40061 .71835 L p F P
0 g
s
.709 .53 .645 r
.44899 .75981 m .45247 .73082 L .50216 .75863 L p F P
0 g
s
.738 .739 .852 r
.45605 .33677 m .46606 .33751 L .46428 .34803 L p F P
0 g
s
.738 .739 .852 r
.46428 .34803 m .454 .34937 L .45605 .33677 L p F P
0 g
s
.673 .728 .891 r
.51679 .33278 m .5212 .33907 L .51931 .33986 L p F P
0 g
s
.673 .728 .891 r
.51931 .33986 m .51301 .33437 L .51679 .33278 L p F P
0 g
s
.789 .62 .671 r
.32234 .60893 m .33134 .59054 L .36529 .64505 L p F P
0 g
s
.789 .62 .671 r
.36529 .64505 m .35781 .66738 L .32234 .60893 L p F P
0 g
s
.646 .707 .892 r
.5317 .33993 m .53785 .33482 L .54108 .33708 L p F P
0 g
s
.65 .713 .894 r
.53785 .33482 m .5317 .33993 L .52979 .33912 L p F P
0 g
s
.572 .618 .859 r
.5767 .35248 m .56642 .34955 L .56502 .34279 L p F P
0 g
s
.594 .641 .867 r
.55511 .34246 m .56502 .34279 L .56642 .34955 L p F P
0 g
s
.502 .472 .756 r
.63072 .42903 m .62097 .41663 L .62731 .3984 L p F P
0 g
s
.513 .489 .767 r
.61694 .38917 m .62731 .3984 L .62097 .41663 L p F P
0 g
s
.513 .44 .711 r
.64518 .49632 m .63634 .47872 L .65048 .45689 L p F P
0 g
s
.519 .451 .719 r
.64055 .44244 m .65048 .45689 L .63634 .47872 L p F P
0 g
s
.702 .735 .877 r
.4891 .33327 m .49827 .33616 L .49593 .34069 L p F P
0 g
s
.702 .735 .877 r
.49593 .34069 m .486 .33947 L .4891 .33327 L p F P
0 g
s
.669 .727 .893 r
.52098 .33183 m .52329 .33859 L .5212 .33907 L p F P
0 g
s
.669 .727 .893 r
.5212 .33907 m .51679 .33278 L .52098 .33183 L p F P
0 g
s
.746 .74 .847 r
.446 .3362 m .45605 .33677 L .454 .34937 L p F P
0 g
s
.746 .74 .847 r
.454 .34937 m .44371 .35097 L .446 .3362 L p F P
0 g
s
.52 .534 .811 r
.60663 .38084 m .59638 .3734 L .59741 .36063 L p F P
0 g
s
.538 .556 .821 r
.58703 .35617 m .59741 .36063 L .59638 .3734 L p F P
0 g
s
.65 .713 .894 r
.52979 .33912 m .53403 .33309 L .53785 .33482 L p F P
0 g
s
.655 .717 .894 r
.53403 .33309 m .52979 .33912 L .52769 .33861 L p F P
0 g
s
.688 .733 .885 r
.50191 .33215 m .50984 .33652 L .5074 .33913 L p F P
0 g
s
.688 .733 .885 r
.5074 .33913 m .49827 .33616 L .50191 .33215 L p F P
0 g
s
.815 .691 .728 r
.32198 .44137 m .33252 .43297 L .34555 .47967 L p F P
0 g
s
.815 .691 .728 r
.34555 .47967 m .33573 .4917 L .32198 .44137 L p F P
0 g
s
.664 .724 .894 r
.52539 .33156 m .52549 .33843 L .52329 .33859 L p F P
0 g
s
.664 .724 .894 r
.52329 .33859 m .52098 .33183 L .52539 .33156 L p F P
0 g
s
.799 .725 .782 r
.37079 .3695 m .38132 .36606 L .38435 .39691 L p F P
0 g
s
.799 .725 .782 r
.38435 .39691 m .37408 .40335 L .37079 .3695 L p F P
0 g
s
.655 .717 .894 r
.52769 .33861 m .52981 .33199 L .53403 .33309 L p F P
0 g
s
.66 .721 .894 r
.52981 .33199 m .52769 .33861 L .52549 .33843 L p F P
0 g
s
.66 .721 .894 r
.52549 .33843 m .52539 .33156 L .52981 .33199 L p F P
0 g
s
.576 .442 .662 r
.62773 .64814 m .622 .62168 L .65449 .60419 L p F P
0 g
s
.578 .448 .667 r
.64688 .58009 m .65449 .60419 L .622 .62168 L p F P
0 g
s
.808 .654 .692 r
.30584 .53106 m .31588 .51738 L .34026 .57288 L p F P
0 g
s
.808 .654 .692 r
.34026 .57288 m .33134 .59054 L .30584 .53106 L p F P
0 g
s
.622 .686 .889 r
.55265 .33779 m .54358 .33978 L .54108 .33708 L p F P
0 g
s
.618 .675 .882 r
.54358 .33978 m .55265 .33779 L .55511 .34246 L p F P
0 g
s
.596 .655 .879 r
.56502 .34279 m .55511 .34246 L .55265 .33779 L p F P
0 g
s
.753 .741 .841 r
.43593 .33579 m .446 .3362 L .44371 .35097 L p F P
0 g
s
.753 .741 .841 r
.44371 .35097 m .43339 .35283 L .43593 .33579 L p F P
0 g
s
.71 .738 .873 r
.4799 .33045 m .4891 .33327 L .486 .33947 L p F P
0 g
s
.71 .738 .873 r
.486 .33947 m .47604 .33841 L .4799 .33045 L p F P
0 g
s
.54 .432 .679 r
.64688 .58009 m .63936 .55728 L .66313 .53497 L p F P
0 g
s
.544 .439 .685 r
.6541 .51506 m .66313 .53497 L .63936 .55728 L p F P
0 g
s
.612 .459 .65 r
.59638 .71465 m .59273 .68518 L .63355 .67597 L p F P
0 g
s
.613 .463 .654 r
.62773 .64814 m .63355 .67597 L .59273 .68518 L p F P
0 g
s
.55 .595 .851 r
.58703 .35617 m .5767 .35248 L .57498 .34375 L p F P
0 g
s
.572 .618 .859 r
.56502 .34279 m .57498 .34375 L .5767 .35248 L p F P
0 g
s
.681 .731 .888 r
.50667 .32886 m .51301 .33437 L .50984 .33652 L p F P
0 g
s
.681 .731 .888 r
.50984 .33652 m .50191 .33215 L .50667 .32886 L p F P
0 g
s
.804 .724 .777 r
.36021 .37321 m .37079 .3695 L .37408 .40335 L p F P
0 g
s
.804 .724 .777 r
.37408 .40335 m .36377 .41017 L .36021 .37321 L p F P
0 g
s
.503 .514 .8 r
.61694 .38917 m .60663 .38084 L .60785 .36586 L p F P
0 g
s
.52 .534 .811 r
.59741 .36063 m .60785 .36586 L .60663 .38084 L p F P
0 g
s
.765 .586 .656 r
.35025 .69062 m .35781 .66738 L .40061 .71835 L p F P
0 g
s
.765 .586 .656 r
.40061 .71835 m .39492 .74534 L .35025 .69062 L p F P
0 g
s
.738 .557 .647 r
.39492 .74534 m .40061 .71835 L .44899 .75981 L p F P
0 g
s
.622 .686 .889 r
.54108 .33708 m .5489 .33356 L .55265 .33779 L p F P
0 g
s
.629 .696 .893 r
.5489 .33356 m .54108 .33708 L .53785 .33482 L p F P
0 g
s
.76 .741 .836 r
.42582 .33554 m .43593 .33579 L .43339 .35283 L p F P
0 g
s
.76 .741 .836 r
.43339 .35283 m .42305 .35495 L .42582 .33554 L p F P
0 g
s
.491 .457 .747 r
.64055 .44244 m .63072 .42903 L .63777 .40853 L p F P
0 g
s
.502 .472 .756 r
.62731 .3984 m .63777 .40853 L .63072 .42903 L p F P
0 g
s
.693 .735 .883 r
.49394 .3278 m .50191 .33215 L .49827 .33616 L p F P
0 g
s
.693 .735 .883 r
.49827 .33616 m .4891 .33327 L .49394 .3278 L p F P
0 g
s
.818 .689 .723 r
.31138 .45017 m .32198 .44137 L .33573 .4917 L p F P
0 g
s
.818 .689 .723 r
.33573 .4917 m .32584 .50427 L .31138 .45017 L p F P
0 g
s
.717 .74 .869 r
.47066 .32772 m .4799 .33045 L .47604 .33841 L p F P
0 g
s
.717 .74 .869 r
.47604 .33841 m .46606 .33751 L .47066 .32772 L p F P
0 g
s
.709 .53 .645 r
.50216 .75863 m .50104 .79005 L .44899 .75981 L p F P
0 g
s
.679 .503 .641 r
.50104 .79005 m .50216 .75863 L .55332 .77462 L p F P
0 g
s
.679 .505 .644 r
.552 .74297 m .55332 .77462 L .50216 .75863 L p F P
0 g
s
.507 .43 .704 r
.6541 .51506 m .64518 .49632 L .6605 .47239 L p F P
0 g
s
.513 .44 .711 r
.65048 .45689 m .6605 .47239 L .64518 .49632 L p F P
0 g
s
.674 .729 .891 r
.51234 .32645 m .51679 .33278 L .51301 .33437 L p F P
0 g
s
.674 .729 .891 r
.51301 .33437 m .50667 .32886 L .51234 .32645 L p F P
0 g
s
.574 .635 .874 r
.57498 .34375 m .56502 .34279 L .56175 .33631 L p F P
0 g
s
.596 .655 .879 r
.55265 .33779 m .56175 .33631 L .56502 .34279 L p F P
0 g
s
.789 .618 .668 r
.31325 .62806 m .32234 .60893 L .35781 .66738 L p F P
0 g
s
.789 .618 .668 r
.35781 .66738 m .35025 .69062 L .31325 .62806 L p F P
0 g
s
.602 .67 .888 r
.56175 .33631 m .55265 .33779 L .5489 .33356 L p F P
0 g
s
.629 .696 .893 r
.53785 .33482 m .54404 .32998 L .5489 .33356 L p F P
0 g
s
.637 .705 .896 r
.54404 .32998 m .53785 .33482 L .53403 .33309 L p F P
0 g
s
.529 .572 .843 r
.59741 .36063 m .58703 .35617 L .58499 .34536 L p F P
0 g
s
.55 .595 .851 r
.57498 .34375 m .58499 .34536 L .58703 .35617 L p F P
0 g
s
.808 .723 .771 r
.34958 .3772 m .36021 .37321 L .36377 .41017 L p F P
0 g
s
.808 .723 .771 r
.36377 .41017 m .35341 .41738 L .34958 .3772 L p F P
0 g
s
.766 .742 .831 r
.41567 .33546 m .42582 .33554 L .42305 .35495 L p F P
0 g
s
.766 .742 .831 r
.42305 .35495 m .41267 .35733 L .41567 .33546 L p F P
0 g
s
.809 .652 .688 r
.29571 .54531 m .30584 .53106 L .33134 .59054 L p F P
0 g
s
.809 .652 .688 r
.33134 .59054 m .32234 .60893 L .29571 .54531 L p F P
0 g
s
.646 .479 .643 r
.55332 .77462 m .552 .74297 L .60007 .74555 L p F P
0 g
s
.646 .482 .646 r
.59638 .71465 m .60007 .74555 L .552 .74297 L p F P
0 g
s
.738 .557 .647 r
.44899 .75981 m .44547 .79004 L .39492 .74534 L p F P
0 g
s
.709 .528 .642 r
.44547 .79004 m .44899 .75981 L .50104 .79005 L p F P
0 g
s
.667 .726 .893 r
.51865 .32504 m .52098 .33183 L .51679 .33278 L p F P
0 g
s
.667 .726 .893 r
.51679 .33278 m .51234 .32645 L .51865 .32504 L p F P
0 g
s
.724 .742 .866 r
.46139 .32507 m .47066 .32772 L .46606 .33751 L p F P
0 g
s
.724 .742 .866 r
.46606 .33751 m .45605 .33677 L .46139 .32507 L p F P
0 g
s
.637 .705 .896 r
.53403 .33309 m .5383 .32723 L .54404 .32998 L p F P
0 g
s
.645 .712 .897 r
.5383 .32723 m .53403 .33309 L .52981 .33199 L p F P
0 g
s
.488 .494 .79 r
.62731 .3984 m .61694 .38917 L .61836 .37187 L p F P
0 g
s
.503 .514 .8 r
.60785 .36586 m .61836 .37187 L .61694 .38917 L p F P
0 g
s
.698 .737 .881 r
.48594 .32346 m .49394 .3278 L .4891 .33327 L p F P
0 g
s
.698 .737 .881 r
.4891 .33327 m .4799 .33045 L .48594 .32346 L p F P
0 g
s
.684 .732 .887 r
.5003 .32333 m .50667 .32886 L .50191 .33215 L p F P
0 g
s
.684 .732 .887 r
.50191 .33215 m .49394 .3278 L .5003 .32333 L p F P
0 g
s
.66 .722 .895 r
.52529 .3247 m .52539 .33156 L .52098 .33183 L p F P
0 g
s
.66 .722 .895 r
.52098 .33183 m .51865 .32504 L .52529 .3247 L p F P
0 g
s
.773 .742 .825 r
.40549 .33554 m .41567 .33546 L .41267 .35733 L p F P
0 g
s
.773 .742 .825 r
.41267 .35733 m .40226 .35998 L .40549 .33554 L p F P
0 g
s
.645 .712 .897 r
.52981 .33199 m .53195 .32544 L .5383 .32723 L p F P
0 g
s
.653 .718 .896 r
.53195 .32544 m .52981 .33199 L .52539 .33156 L p F P
0 g
s
.82 .688 .718 r
.30071 .45938 m .31138 .45017 L .32584 .50427 L p F P
0 g
s
.82 .688 .718 r
.32584 .50427 m .31588 .51738 L .30071 .45938 L p F P
0 g
s
.653 .718 .896 r
.52539 .33156 m .52529 .3247 L .53195 .32544 L p F P
0 g
s
.574 .438 .658 r
.63355 .67597 m .62773 .64814 L .6622 .62962 L p F P
0 g
s
.576 .442 .662 r
.65449 .60419 m .6622 .62962 L .62773 .64814 L p F P
0 g
s
.481 .443 .738 r
.65048 .45689 m .64055 .44244 L .64832 .4196 L p F P
0 g
s
.491 .457 .747 r
.63777 .40853 m .64832 .4196 L .64055 .44244 L p F P
0 g
s
.812 .722 .766 r
.33891 .38146 m .34958 .3772 L .35341 .41738 L p F P
0 g
s
.812 .722 .766 r
.35341 .41738 m .34299 .42498 L .33891 .38146 L p F P
0 g
s
.537 .425 .674 r
.65449 .60419 m .64688 .58009 L .67227 .5561 L p F P
0 g
s
.54 .432 .679 r
.66313 .53497 m .67227 .5561 L .64688 .58009 L p F P
0 g
s
.602 .67 .888 r
.5489 .33356 m .55676 .33042 L .56175 .33631 L p F P
0 g
s
.612 .685 .894 r
.55676 .33042 m .5489 .33356 L .54404 .32998 L p F P
0 g
s
.551 .615 .869 r
.58499 .34536 m .57498 .34375 L .57091 .33535 L p F P
0 g
s
.574 .635 .874 r
.56175 .33631 m .57091 .33535 L .57498 .34375 L p F P
0 g
s
.73 .743 .862 r
.45207 .3225 m .46139 .32507 L .45605 .33677 L p F P
0 g
s
.73 .743 .862 r
.45605 .33677 m .446 .3362 L .45207 .3225 L p F P
0 g
s
.509 .551 .834 r
.60785 .36586 m .59741 .36063 L .59507 .34763 L p F P
0 g
s
.529 .572 .843 r
.58499 .34536 m .59507 .34763 L .59741 .36063 L p F P
0 g
s
.61 .456 .647 r
.60007 .74555 m .59638 .71465 L .63945 .70523 L p F P
0 g
s
.612 .459 .65 r
.63355 .67597 m .63945 .70523 L .59638 .71465 L p F P
0 g
s
.778 .743 .82 r
.39526 .33579 m .40549 .33554 L .40226 .35998 L p F P
0 g
s
.778 .743 .82 r
.40226 .35998 m .39181 .36289 L .39526 .33579 L p F P
0 g
s
.581 .654 .887 r
.57091 .33535 m .56175 .33631 L .55676 .33042 L p F P
0 g
s
.675 .729 .891 r
.50787 .32008 m .51234 .32645 L .50667 .32886 L p F P
0 g
s
.675 .729 .891 r
.50667 .32886 m .5003 .32333 L .50787 .32008 L p F P
0 g
s
.765 .584 .653 r
.34258 .71481 m .35025 .69062 L .39492 .74534 L p F P
0 g
s
.765 .584 .653 r
.39492 .74534 m .38914 .77346 L .34258 .71481 L p F P
0 g
s
.738 .555 .645 r
.38914 .77346 m .39492 .74534 L .44547 .79004 L p F P
0 g
s
.501 .42 .697 r
.66313 .53497 m .6541 .51506 L .67062 .48897 L p F P
0 g
s
.507 .43 .704 r
.6605 .47239 m .67062 .48897 L .6541 .51506 L p F P
0 g
s
.703 .738 .879 r
.47789 .31914 m .48594 .32346 L .4799 .33045 L p F P
0 g
s
.703 .738 .879 r
.4799 .33045 m .47066 .32772 L .47789 .31914 L p F P
0 g
s
.81 .65 .684 r
.28549 .56014 m .29571 .54531 L .32234 .60893 L p F P
0 g
s
.81 .65 .684 r
.32234 .60893 m .31325 .62806 L .28549 .56014 L p F P
0 g
s
.815 .721 .761 r
.32817 .38599 m .33891 .38146 L .34299 .42498 L p F P
0 g
s
.815 .721 .761 r
.34299 .42498 m .33252 .43297 L .32817 .38599 L p F P
0 g
s
.473 .476 .78 r
.63777 .40853 m .62731 .3984 L .62895 .37868 L p F P
0 g
s
.488 .494 .79 r
.61836 .37187 m .62895 .37868 L .62731 .3984 L p F P
0 g
s
.79 .616 .665 r
.30406 .64796 m .31325 .62806 L .35025 .69062 L p F P
0 g
s
.79 .616 .665 r
.35025 .69062 m .34258 .71481 L .30406 .64796 L p F P
0 g
s
.612 .685 .894 r
.54404 .32998 m .55028 .32541 L .55676 .33042 L p F P
0 g
s
.623 .697 .898 r
.55028 .32541 m .54404 .32998 L .5383 .32723 L p F P
0 g
s
.737 .745 .858 r
.44272 .32001 m .45207 .3225 L .446 .3362 L p F P
0 g
s
.737 .745 .858 r
.446 .3362 m .43593 .33579 L .44272 .32001 L p F P
0 g
s
.822 .686 .714 r
.28997 .46901 m .30071 .45938 L .31588 .51738 L p F P
0 g
s
.822 .686 .714 r
.31588 .51738 m .30584 .53106 L .28997 .46901 L p F P
0 g
s
.687 .734 .886 r
.49389 .31777 m .5003 .32333 L .49394 .3278 L p F P
0 g
s
.687 .734 .886 r
.49394 .3278 m .48594 .32346 L .49389 .31777 L p F P
0 g
s
.784 .743 .815 r
.38499 .33621 m .39526 .33579 L .39181 .36289 L p F P
0 g
s
.784 .743 .815 r
.39181 .36289 m .38132 .36606 L .38499 .33621 L p F P
0 g
s
.666 .725 .894 r
.51631 .31822 m .51865 .32504 L .51234 .32645 L p F P
0 g
s
.666 .725 .894 r
.51234 .32645 m .50787 .32008 L .51631 .31822 L p F P
0 g
s
.709 .528 .642 r
.50104 .79005 m .49989 .82288 L .44547 .79004 L p F P
0 g
s
.678 .501 .639 r
.49989 .82288 m .50104 .79005 L .55466 .80773 L p F P
0 g
s
.679 .503 .641 r
.55332 .77462 m .55466 .80773 L .50104 .79005 L p F P
0 g
s
.529 .595 .864 r
.59507 .34763 m .58499 .34536 L .58013 .33492 L p F P
0 g
s
.551 .615 .869 r
.57091 .33535 m .58013 .33492 L .58499 .34536 L p F P
0 g
s
.489 .53 .825 r
.61836 .37187 m .60785 .36586 L .60521 .35055 L p F P
0 g
s
.509 .551 .834 r
.59507 .34763 m .60521 .35055 L .60785 .36586 L p F P
0 g
s
.472 .43 .729 r
.6605 .47239 m .65048 .45689 L .65897 .43161 L p F P
0 g
s
.481 .443 .738 r
.64832 .4196 m .65897 .43161 L .65048 .45689 L p F P
0 g
s
.623 .697 .898 r
.5383 .32723 m .54261 .32153 L .55028 .32541 L p F P
0 g
s
.635 .707 .899 r
.54261 .32153 m .5383 .32723 L .53195 .32544 L p F P
0 g
s
.738 .555 .645 r
.44547 .79004 m .44188 .82158 L .38914 .77346 L p F P
0 g
s
.709 .526 .639 r
.44188 .82158 m .44547 .79004 L .49989 .82288 L p F P
0 g
s
.708 .74 .876 r
.46981 .31483 m .47789 .31914 L .47066 .32772 L p F P
0 g
s
.708 .74 .876 r
.47066 .32772 m .46139 .32507 L .46981 .31483 L p F P
0 g
s
.656 .721 .896 r
.5252 .31784 m .52529 .3247 L .51865 .32504 L p F P
0 g
s
.656 .721 .896 r
.51865 .32504 m .51631 .31822 L .5252 .31784 L p F P
0 g
s
.581 .654 .887 r
.55676 .33042 m .56468 .32768 L .57091 .33535 L p F P
0 g
s
.594 .673 .895 r
.56468 .32768 m .55676 .33042 L .55028 .32541 L p F P
0 g
s
.645 .476 .64 r
.55466 .80773 m .55332 .77462 L .60383 .77795 L p F P
0 g
s
.646 .479 .643 r
.60007 .74555 m .60383 .77795 L .55332 .77462 L p F P
0 g
s
.819 .72 .756 r
.31738 .39081 m .32817 .38599 L .33252 .43297 L p F P
0 g
s
.819 .72 .756 r
.33252 .43297 m .32198 .44137 L .31738 .39081 L p F P
0 g
s
.743 .746 .855 r
.43333 .3176 m .44272 .32001 L .43593 .33579 L p F P
0 g
s
.743 .746 .855 r
.43593 .33579 m .42582 .33554 L .43333 .3176 L p F P
0 g
s
.635 .707 .899 r
.53195 .32544 m .53411 .31896 L .54261 .32153 L p F P
0 g
s
.646 .715 .898 r
.53411 .31896 m .53195 .32544 L .52529 .3247 L p F P
0 g
s
.56 .638 .884 r
.58013 .33492 m .57091 .33535 L .56468 .32768 L p F P
0 g
s
.646 .715 .898 r
.52529 .3247 m .5252 .31784 L .53411 .31896 L p F P
0 g
s
.789 .743 .81 r
.37468 .33679 m .38499 .33621 L .38132 .36606 L p F P
0 g
s
.789 .743 .81 r
.38132 .36606 m .37079 .3695 L .37468 .33679 L p F P
0 g
s
.534 .419 .669 r
.6622 .62962 m .65449 .60419 L .68153 .57848 L p F P
0 g
s
.537 .425 .674 r
.67227 .5561 m .68153 .57848 L .65449 .60419 L p F P
0 g
s
.572 .433 .654 r
.63945 .70523 m .63355 .67597 L .67004 .65642 L p F P
0 g
s
.574 .438 .658 r
.6622 .62962 m .67004 .65642 L .63355 .67597 L p F P
0 g
s
.675 .729 .891 r
.50337 .31367 m .50787 .32008 L .5003 .32333 L p F P
0 g
s
.675 .729 .891 r
.5003 .32333 m .49389 .31777 L .50337 .31367 L p F P
0 g
s
.823 .684 .71 r
.27914 .47906 m .28997 .46901 L .30584 .53106 L p F P
0 g
s
.823 .684 .71 r
.30584 .53106 m .29571 .54531 L .27914 .47906 L p F P
0 g
s
.459 .458 .77 r
.64832 .4196 m .63777 .40853 L .63963 .3863 L p F P
0 g
s
.473 .476 .78 r
.62895 .37868 m .63963 .3863 L .63777 .40853 L p F P
0 g
s
.689 .735 .885 r
.48744 .31218 m .49389 .31777 L .48594 .32346 L p F P
0 g
s
.689 .735 .885 r
.48594 .32346 m .47789 .31914 L .48744 .31218 L p F P
0 g
s
.811 .648 .681 r
.27517 .57556 m .28549 .56014 L .31325 .62806 L p F P
0 g
s
.811 .648 .681 r
.31325 .62806 m .30406 .64796 L .27517 .57556 L p F P
0 g
s
.496 .412 .691 r
.67227 .5561 m .66313 .53497 L .68087 .50667 L p F P
0 g
s
.501 .42 .697 r
.67062 .48897 m .68087 .50667 L .66313 .53497 L p F P
0 g
s
.749 .748 .851 r
.4239 .31527 m .43333 .3176 L .42582 .33554 L p F P
0 g
s
.749 .748 .851 r
.42582 .33554 m .41567 .33546 L .4239 .31527 L p F P
0 g
s
.794 .743 .806 r
.36432 .33755 m .37468 .33679 L .37079 .3695 L p F P
0 g
s
.794 .743 .806 r
.37079 .3695 m .36021 .37321 L .36432 .33755 L p F P
0 g
s
.713 .742 .874 r
.46169 .31054 m .46981 .31483 L .46139 .32507 L p F P
0 g
s
.713 .742 .874 r
.46139 .32507 m .45207 .3225 L .46169 .31054 L p F P
0 g
s
.508 .574 .858 r
.60521 .35055 m .59507 .34763 L .58941 .33501 L p F P
0 g
s
.529 .595 .864 r
.58013 .33492 m .58941 .33501 L .59507 .34763 L p F P
0 g
s
.594 .673 .895 r
.55028 .32541 m .55656 .32112 L .56468 .32768 L p F P
0 g
s
.609 .689 .9 r
.55656 .32112 m .55028 .32541 L .54261 .32153 L p F P
0 g
s
.822 .719 .751 r
.30653 .39591 m .31738 .39081 L .32198 .44137 L p F P
0 g
s
.822 .719 .751 r
.32198 .44137 m .31138 .45017 L .30653 .39591 L p F P
0 g
s
.47 .509 .816 r
.62895 .37868 m .61836 .37187 L .61542 .35414 L p F P
0 g
s
.489 .53 .825 r
.60521 .35055 m .61542 .35414 L .61836 .37187 L p F P
0 g
s
.766 .583 .65 r
.33482 .73996 m .34258 .71481 L .38914 .77346 L p F P
0 g
s
.766 .583 .65 r
.38914 .77346 m .38328 .80274 L .33482 .73996 L p F P
0 g
s
.738 .553 .642 r
.38328 .80274 m .38914 .77346 L .44188 .82158 L p F P
0 g
s
.791 .614 .662 r
.29476 .66865 m .30406 .64796 L .34258 .71481 L p F P
0 g
s
.791 .614 .662 r
.34258 .71481 m .33482 .73996 L .29476 .66865 L p F P
0 g
s
.609 .452 .644 r
.60383 .77795 m .60007 .74555 L .64545 .73596 L p F P
0 g
s
.61 .456 .647 r
.63945 .70523 m .64545 .73596 L .60007 .74555 L p F P
0 g
s
.664 .725 .894 r
.51395 .31138 m .51631 .31822 L .50787 .32008 L p F P
0 g
s
.664 .725 .894 r
.50787 .32008 m .50337 .31367 L .51395 .31138 L p F P
0 g
s
.464 .417 .721 r
.67062 .48897 m .6605 .47239 L .66973 .44458 L p F P
0 g
s
.472 .43 .729 r
.65897 .43161 m .66973 .44458 L .6605 .47239 L p F P
0 g
s
.56 .638 .884 r
.56468 .32768 m .57265 .32534 L .58013 .33492 L p F P
0 g
s
.576 .66 .895 r
.57265 .32534 m .56468 .32768 L .55656 .32112 L p F P
0 g
s
.539 .621 .882 r
.58941 .33501 m .58013 .33492 L .57265 .32534 L p F P
0 g
s
.754 .749 .848 r
.41443 .31302 m .4239 .31527 L .41567 .33546 L p F P
0 g
s
.754 .749 .848 r
.41567 .33546 m .40549 .33554 L .41443 .31302 L p F P
0 g
s
.609 .689 .9 r
.54261 .32153 m .54694 .316 L .55656 .32112 L p F P
0 g
s
.624 .702 .901 r
.54694 .316 m .54261 .32153 L .53411 .31896 L p F P
0 g
s
.799 .743 .801 r
.35391 .33847 m .36432 .33755 L .36021 .37321 L p F P
0 g
s
.799 .743 .801 r
.36021 .37321 m .34958 .3772 L .35391 .33847 L p F P
0 g
s
.825 .683 .706 r
.26824 .48954 m .27914 .47906 L .29571 .54531 L p F P
0 g
s
.825 .683 .706 r
.29571 .54531 m .28549 .56014 L .26824 .48954 L p F P
0 g
s
.692 .736 .885 r
.48095 .30657 m .48744 .31218 L .47789 .31914 L p F P
0 g
s
.692 .736 .885 r
.47789 .31914 m .46981 .31483 L .48095 .30657 L p F P
0 g
s
.652 .719 .897 r
.5251 .311 m .5252 .31784 L .51631 .31822 L p F P
0 g
s
.652 .719 .897 r
.51631 .31822 m .51395 .31138 L .5251 .311 L p F P
0 g
s
.676 .73 .891 r
.49884 .30722 m .50337 .31367 L .49389 .31777 L p F P
0 g
s
.676 .73 .891 r
.49389 .31777 m .48744 .31218 L .49884 .30722 L p F P
0 g
s
.718 .744 .872 r
.45352 .30627 m .46169 .31054 L .45207 .3225 L p F P
0 g
s
.718 .744 .872 r
.45207 .3225 m .44272 .32001 L .45352 .30627 L p F P
0 g
s
.709 .526 .639 r
.49989 .82288 m .49873 .85717 L .44188 .82158 L p F P
0 g
s
.678 .499 .636 r
.49873 .85717 m .49989 .82288 L .55602 .84238 L p F P
0 g
s
.678 .501 .639 r
.55466 .80773 m .55602 .84238 L .49989 .82288 L p F P
0 g
s
.825 .717 .746 r
.29561 .40129 m .30653 .39591 L .31138 .45017 L p F P
0 g
s
.825 .717 .746 r
.31138 .45017 m .30071 .45938 L .29561 .40129 L p F P
0 g
s
.446 .442 .761 r
.65897 .43161 m .64832 .4196 L .65041 .39473 L p F P
0 g
s
.459 .458 .77 r
.63963 .3863 m .65041 .39473 L .64832 .4196 L p F P
0 g
s
.624 .702 .901 r
.53411 .31896 m .53628 .31257 L .54694 .316 L p F P
0 g
s
.639 .712 .9 r
.53628 .31257 m .53411 .31896 L .5252 .31784 L p F P
0 g
s
.639 .712 .9 r
.5252 .31784 m .5251 .311 L .53628 .31257 L p F P
0 g
s
.738 .553 .642 r
.44188 .82158 m .43824 .85446 L .38328 .80274 L p F P
0 g
s
.709 .524 .637 r
.43824 .85446 m .44188 .82158 L .49873 .85717 L p F P
0 g
s
.812 .646 .677 r
.26476 .59159 m .27517 .57556 L .30406 .64796 L p F P
0 g
s
.812 .646 .677 r
.30406 .64796 m .29476 .66865 L .26476 .59159 L p F P
0 g
s
.486 .554 .851 r
.61542 .35414 m .60521 .35055 L .59876 .33564 L p F P
0 g
s
.508 .574 .858 r
.58941 .33501 m .59876 .33564 L .60521 .35055 L p F P
0 g
s
.452 .489 .807 r
.63963 .3863 m .62895 .37868 L .62572 .3584 L p F P
0 g
s
.47 .509 .816 r
.61542 .35414 m .62572 .3584 L .62895 .37868 L p F P
0 g
s
.531 .413 .664 r
.67004 .65642 m .6622 .62962 L .69093 .60214 L p F P
0 g
s
.534 .419 .669 r
.68153 .57848 m .69093 .60214 L .6622 .62962 L p F P
0 g
s
.644 .474 .637 r
.55602 .84238 m .55466 .80773 L .60766 .81191 L p F P
0 g
s
.645 .476 .64 r
.60383 .77795 m .60766 .81191 L .55466 .80773 L p F P
0 g
s
.76 .75 .844 r
.40491 .31086 m .41443 .31302 L .40549 .33554 L p F P
0 g
s
.76 .75 .844 r
.40549 .33554 m .39526 .33579 L .40491 .31086 L p F P
0 g
s
.803 .743 .796 r
.34345 .33956 m .35391 .33847 L .34958 .3772 L p F P
0 g
s
.803 .743 .796 r
.34958 .3772 m .33891 .38146 L .34345 .33956 L p F P
0 g
s
.491 .404 .685 r
.68153 .57848 m .67227 .5561 L .69125 .5255 L p F P
0 g
s
.496 .412 .691 r
.68087 .50667 m .69125 .5255 L .67227 .5561 L p F P
0 g
s
.571 .43 .65 r
.64545 .73596 m .63945 .70523 L .67799 .68464 L p F P
0 g
s
.572 .433 .654 r
.67004 .65642 m .67799 .68464 L .63945 .70523 L p F P
0 g
s
.576 .66 .895 r
.55656 .32112 m .56289 .31711 L .57265 .32534 L p F P
0 g
s
.594 .68 .901 r
.56289 .31711 m .55656 .32112 L .54694 .316 L p F P
0 g
s
.722 .745 .87 r
.44531 .30201 m .45352 .30627 L .44272 .32001 L p F P
0 g
s
.722 .745 .87 r
.44272 .32001 m .43333 .3176 L .44531 .30201 L p F P
0 g
s
.662 .724 .895 r
.51157 .3045 m .51395 .31138 L .50337 .31367 L p F P
0 g
s
.662 .724 .895 r
.50337 .31367 m .49884 .30722 L .51157 .3045 L p F P
0 g
s
.791 .612 .659 r
.28535 .69014 m .29476 .66865 L .33482 .73996 L p F P
0 g
s
.791 .612 .659 r
.33482 .73996 m .32695 .76612 L .28535 .69014 L p F P
0 g
s
.766 .581 .648 r
.32695 .76612 m .33482 .73996 L .38328 .80274 L p F P
0 g
s
.827 .716 .742 r
.28462 .40697 m .29561 .40129 L .30071 .45938 L p F P
0 g
s
.827 .716 .742 r
.30071 .45938 m .28997 .46901 L .28462 .40697 L p F P
0 g
s
.695 .737 .884 r
.47442 .30094 m .48095 .30657 L .46981 .31483 L p F P
0 g
s
.695 .737 .884 r
.46981 .31483 m .46169 .31054 L .47442 .30094 L p F P
0 g
s
.518 .603 .878 r
.59876 .33564 m .58941 .33501 L .58068 .3234 L p F P
0 g
s
.539 .621 .882 r
.57265 .32534 m .58068 .3234 L .58941 .33501 L p F P
0 g
s
.456 .406 .713 r
.68087 .50667 m .67062 .48897 L .68061 .45854 L p F P
0 g
s
.464 .417 .721 r
.66973 .44458 m .68061 .45854 L .67062 .48897 L p F P
0 g
s
.827 .681 .702 r
.25724 .50047 m .26824 .48954 L .28549 .56014 L p F P
0 g
s
.827 .681 .702 r
.28549 .56014 m .27517 .57556 L .25724 .50047 L p F P
0 g
s
.557 .647 .895 r
.58068 .3234 m .57265 .32534 L .56289 .31711 L p F P
0 g
s
.766 .581 .648 r
.38328 .80274 m .37733 .83322 L .32695 .76612 L p F P
0 g
s
.738 .551 .64 r
.37733 .83322 m .38328 .80274 L .43824 .85446 L p F P
0 g
s
.765 .751 .84 r
.39535 .30878 m .40491 .31086 L .39526 .33579 L p F P
0 g
s
.765 .751 .84 r
.39526 .33579 m .38499 .33621 L .39535 .30878 L p F P
0 g
s
.676 .73 .891 r
.49428 .30072 m .49884 .30722 L .48744 .31218 L p F P
0 g
s
.676 .73 .891 r
.48744 .31218 m .48095 .30657 L .49428 .30072 L p F P
0 g
s
.807 .742 .792 r
.33293 .34083 m .34345 .33956 L .33891 .38146 L p F P
0 g
s
.807 .742 .792 r
.33891 .38146 m .32817 .38599 L .33293 .34083 L p F P
0 g
s
.594 .68 .901 r
.54694 .316 m .55131 .31063 L .56289 .31711 L p F P
0 g
s
.613 .696 .903 r
.55131 .31063 m .54694 .316 L .53628 .31257 L p F P
0 g
s
.608 .449 .641 r
.60766 .81191 m .60383 .77795 L .65155 .76823 L p F P
0 g
s
.609 .452 .644 r
.64545 .73596 m .65155 .76823 L .60383 .77795 L p F P
0 g
s
.434 .427 .752 r
.66973 .44458 m .65897 .43161 L .66129 .404 L p F P
0 g
s
.446 .442 .761 r
.65041 .39473 m .66129 .404 L .65897 .43161 L p F P
0 g
s
.648 .717 .899 r
.525 .30417 m .5251 .311 L .51395 .31138 L p F P
0 g
s
.648 .717 .899 r
.51395 .31138 m .51157 .3045 L .525 .30417 L p F P
0 g
s
.465 .534 .844 r
.62572 .3584 m .61542 .35414 L .60818 .33681 L p F P
0 g
s
.486 .554 .851 r
.59876 .33564 m .60818 .33681 L .61542 .35414 L p F P
0 g
s
.435 .471 .798 r
.65041 .39473 m .63963 .3863 L .63611 .36334 L p F P
0 g
s
.452 .489 .807 r
.62572 .3584 m .63611 .36334 L .63963 .3863 L p F P
0 g
s
.727 .747 .868 r
.43706 .29777 m .44531 .30201 L .43333 .3176 L p F P
0 g
s
.727 .747 .868 r
.43333 .3176 m .4239 .31527 L .43706 .29777 L p F P
0 g
s
.613 .696 .903 r
.53628 .31257 m .53847 .30625 L .55131 .31063 L p F P
0 g
s
.632 .708 .901 r
.53847 .30625 m .53628 .31257 L .5251 .311 L p F P
0 g
s
.813 .645 .674 r
.25423 .60824 m .26476 .59159 L .29476 .66865 L p F P
0 g
s
.813 .645 .674 r
.29476 .66865 m .28535 .69014 L .25423 .60824 L p F P
0 g
s
.632 .708 .901 r
.5251 .311 m .525 .30417 L .53847 .30625 L p F P
0 g
s
.77 .752 .837 r
.38574 .30678 m .39535 .30878 L .38499 .33621 L p F P
0 g
s
.77 .752 .837 r
.38499 .33621 m .37468 .33679 L .38574 .30678 L p F P
0 g
s
.83 .715 .738 r
.27357 .41293 m .28462 .40697 L .28997 .46901 L p F P
0 g
s
.83 .715 .738 r
.28997 .46901 m .27914 .47906 L .27357 .41293 L p F P
0 g
s
.698 .738 .883 r
.46786 .29527 m .47442 .30094 L .46169 .31054 L p F P
0 g
s
.698 .738 .883 r
.46169 .31054 m .45352 .30627 L .46786 .29527 L p F P
0 g
s
.811 .742 .787 r
.32237 .34227 m .33293 .34083 L .32817 .38599 L p F P
0 g
s
.811 .742 .787 r
.32817 .38599 m .31738 .39081 L .32237 .34227 L p F P
0 g
s
.557 .647 .895 r
.56289 .31711 m .56927 .31338 L .58068 .3234 L p F P
0 g
s
.579 .671 .902 r
.56927 .31338 m .56289 .31711 L .55131 .31063 L p F P
0 g
s
.709 .524 .637 r
.49873 .85717 m .49754 .89297 L .43824 .85446 L p F P
0 g
s
.678 .497 .634 r
.49754 .89297 m .49873 .85717 L .55741 .87861 L p F P
0 g
s
.678 .499 .636 r
.55602 .84238 m .55741 .87861 L .49873 .85717 L p F P
0 g
s
.828 .68 .699 r
.24615 .51184 m .25724 .50047 L .27517 .57556 L p F P
0 g
s
.828 .68 .699 r
.27517 .57556 m .26476 .59159 L .24615 .51184 L p F P
0 g
s
.66 .723 .896 r
.50918 .29759 m .51157 .3045 L .49884 .30722 L p F P
0 g
s
.66 .723 .896 r
.49884 .30722 m .49428 .30072 L .50918 .29759 L p F P
0 g
s
.738 .551 .64 r
.43824 .85446 m .43453 .88875 L .37733 .83322 L p F P
0 g
s
.709 .523 .635 r
.43453 .88875 m .43824 .85446 L .49754 .89297 L p F P
0 g
s
.496 .586 .874 r
.60818 .33681 m .59876 .33564 L .58877 .32187 L p F P
0 g
s
.518 .603 .878 r
.58068 .3234 m .58877 .32187 L .59876 .33564 L p F P
0 g
s
.529 .408 .66 r
.67799 .68464 m .67004 .65642 L .70048 .62713 L p F P
0 g
s
.531 .413 .664 r
.69093 .60214 m .70048 .62713 L .67004 .65642 L p F P
0 g
s
.487 .397 .679 r
.69093 .60214 m .68153 .57848 L .70178 .5455 L p F P
0 g
s
.491 .404 .685 r
.69125 .5255 m .70178 .5455 L .68153 .57848 L p F P
0 g
s
.677 .73 .89 r
.48969 .29418 m .49428 .30072 L .48095 .30657 L p F P
0 g
s
.677 .73 .89 r
.48095 .30657 m .47442 .30094 L .48969 .29418 L p F P
0 g
s
.538 .634 .894 r
.58877 .32187 m .58068 .3234 L .56927 .31338 L p F P
0 g
s
.731 .748 .866 r
.42877 .29354 m .43706 .29777 L .4239 .31527 L p F P
0 g
s
.731 .748 .866 r
.4239 .31527 m .41443 .31302 L .42877 .29354 L p F P
0 g
s
.449 .396 .706 r
.69125 .5255 m .68087 .50667 L .69162 .47352 L p F P
0 g
s
.456 .406 .713 r
.68061 .45854 m .69162 .47352 L .68087 .50667 L p F P
0 g
s
.644 .471 .635 r
.55741 .87861 m .55602 .84238 L .61156 .84748 L p F P
0 g
s
.644 .474 .637 r
.60766 .81191 m .61156 .84748 L .55602 .84238 L p F P
0 g
s
.791 .611 .656 r
.27582 .71245 m .28535 .69014 L .32695 .76612 L p F P
0 g
s
.791 .611 .656 r
.32695 .76612 m .31896 .79332 L .27582 .71245 L p F P
0 g
s
.766 .579 .645 r
.31896 .79332 m .32695 .76612 L .37733 .83322 L p F P
0 g
s
.775 .753 .833 r
.37609 .30486 m .38574 .30678 L .37468 .33679 L p F P
0 g
s
.775 .753 .833 r
.37468 .33679 m .36432 .33755 L .37609 .30486 L p F P
0 g
s
.569 .426 .647 r
.65155 .76823 m .64545 .73596 L .68609 .71433 L p F P
0 g
s
.571 .43 .65 r
.67799 .68464 m .68609 .71433 L .64545 .73596 L p F P
0 g
s
.815 .742 .783 r
.31174 .34389 m .32237 .34227 L .31738 .39081 L p F P
0 g
s
.815 .742 .783 r
.31738 .39081 m .30653 .39591 L .31174 .34389 L p F P
0 g
s
.422 .412 .743 r
.68061 .45854 m .66973 .44458 L .67229 .41411 L p F P
0 g
s
.434 .427 .752 r
.66129 .404 m .67229 .41411 L .66973 .44458 L p F P
0 g
s
.832 .714 .734 r
.26243 .4192 m .27357 .41293 L .27914 .47906 L p F P
0 g
s
.832 .714 .734 r
.27914 .47906 m .26824 .48954 L .26243 .4192 L p F P
0 g
s
.579 .671 .902 r
.55131 .31063 m .55571 .30544 L .56927 .31338 L p F P
0 g
s
.602 .69 .904 r
.55571 .30544 m .55131 .31063 L .53847 .30625 L p F P
0 g
s
.444 .515 .837 r
.63611 .36334 m .62572 .3584 L .61769 .33852 L p F P
0 g
s
.465 .534 .844 r
.60818 .33681 m .61769 .33852 L .62572 .3584 L p F P
0 g
s
.643 .715 .9 r
.5249 .29734 m .525 .30417 L .51157 .3045 L p F P
0 g
s
.643 .715 .9 r
.51157 .3045 m .50918 .29759 L .5249 .29734 L p F P
0 g
s
.766 .579 .645 r
.37733 .83322 m .37128 .86495 L .31896 .79332 L p F P
0 g
s
.738 .55 .638 r
.37128 .86495 m .37733 .83322 L .43453 .88875 L p F P
0 g
s
.7 .739 .882 r
.46125 .28958 m .46786 .29527 L .45352 .30627 L p F P
0 g
s
.7 .739 .882 r
.45352 .30627 m .44531 .30201 L .46125 .28958 L p F P
0 g
s
.418 .452 .789 r
.66129 .404 m .65041 .39473 L .6466 .36898 L p F P
0 g
s
.435 .471 .798 r
.63611 .36334 m .6466 .36898 L .65041 .39473 L p F P
0 g
s
.814 .643 .671 r
.24359 .62553 m .25423 .60824 L .28535 .69014 L p F P
0 g
s
.814 .643 .671 r
.28535 .69014 m .27582 .71245 L .24359 .62553 L p F P
0 g
s
.602 .69 .904 r
.53847 .30625 m .54068 .3 L .55571 .30544 L p F P
0 g
s
.624 .704 .903 r
.54068 .3 m .53847 .30625 L .525 .30417 L p F P
0 g
s
.624 .704 .903 r
.525 .30417 m .5249 .29734 L .54068 .3 L p F P
0 g
s
.735 .749 .864 r
.42044 .28934 m .42877 .29354 L .41443 .31302 L p F P
0 g
s
.735 .749 .864 r
.41443 .31302 m .40491 .31086 L .42044 .28934 L p F P
0 g
s
.779 .754 .83 r
.36639 .30303 m .37609 .30486 L .36432 .33755 L p F P
0 g
s
.779 .754 .83 r
.36432 .33755 m .35391 .33847 L .36639 .30303 L p F P
0 g
s
.829 .678 .695 r
.23496 .52366 m .24615 .51184 L .26476 .59159 L p F P
0 g
s
.829 .678 .695 r
.26476 .59159 m .25423 .60824 L .23496 .52366 L p F P
0 g
s
.608 .447 .638 r
.61156 .84748 m .60766 .81191 L .65777 .8021 L p F P
0 g
s
.608 .449 .641 r
.65155 .76823 m .65777 .8021 L .60766 .81191 L p F P
0 g
s
.659 .723 .896 r
.50677 .29065 m .50918 .29759 L .49428 .30072 L p F P
0 g
s
.659 .723 .896 r
.49428 .30072 m .48969 .29418 L .50677 .29065 L p F P
0 g
s
.538 .634 .894 r
.56927 .31338 m .5757 .30992 L .58877 .32187 L p F P
0 g
s
.564 .661 .903 r
.5757 .30992 m .56927 .31338 L .55571 .30544 L p F P
0 g
s
.474 .568 .87 r
.61769 .33852 m .60818 .33681 L .59693 .32074 L p F P
0 g
s
.496 .586 .874 r
.58877 .32187 m .59693 .32074 L .60818 .33681 L p F P
0 g
s
.677 .731 .89 r
.48507 .2876 m .48969 .29418 L .47442 .30094 L p F P
0 g
s
.677 .731 .89 r
.47442 .30094 m .46786 .29527 L .48507 .2876 L p F P
0 g
s
.819 .741 .779 r
.30106 .34568 m .31174 .34389 L .30653 .39591 L p F P
0 g
s
.819 .741 .779 r
.30653 .39591 m .29561 .40129 L .30106 .34568 L p F P
0 g
s
.834 .713 .73 r
.25122 .42576 m .26243 .4192 L .26824 .48954 L p F P
0 g
s
.834 .713 .73 r
.26824 .48954 m .25724 .50047 L .25122 .42576 L p F P
0 g
s
.518 .62 .892 r
.59693 .32074 m .58877 .32187 L .5757 .30992 L p F P
0 g
s
.703 .741 .881 r
.45461 .28386 m .46125 .28958 L .44531 .30201 L p F P
0 g
s
.703 .741 .881 r
.44531 .30201 m .43706 .29777 L .45461 .28386 L p F P
0 g
s
.483 .39 .674 r
.70048 .62713 m .69093 .60214 L .71246 .56671 L p F P
0 g
s
.487 .397 .679 r
.70178 .5455 m .71246 .56671 L .69093 .60214 L p F P
0 g
s
.784 .754 .826 r
.35663 .30128 m .36639 .30303 L .35391 .33847 L p F P
0 g
s
.784 .754 .826 r
.35391 .33847 m .34345 .33956 L .35663 .30128 L p F P
0 g
s
.442 .386 .7 r
.70178 .5455 m .69125 .5255 L .70278 .48952 L p F P
0 g
s
.449 .396 .706 r
.69162 .47352 m .70278 .48952 L .69125 .5255 L p F P
0 g
s
.739 .751 .861 r
.41206 .28514 m .42044 .28934 L .40491 .31086 L p F P
0 g
s
.739 .751 .861 r
.40491 .31086 m .39535 .30878 L .41206 .28514 L p F P
0 g
s
.424 .495 .829 r
.6466 .36898 m .63611 .36334 L .62728 .34078 L p F P
0 g
s
.444 .515 .837 r
.61769 .33852 m .62728 .34078 L .63611 .36334 L p F P
0 g
s
.526 .404 .656 r
.68609 .71433 m .67799 .68464 L .71018 .65349 L p F P
0 g
s
.529 .408 .66 r
.70048 .62713 m .71018 .65349 L .67799 .68464 L p F P
0 g
s
.709 .523 .635 r
.49754 .89297 m .49633 .93035 L .43453 .88875 L p F P
0 g
s
.677 .495 .632 r
.49633 .93035 m .49754 .89297 L .55883 .9165 L p F P
0 g
s
.678 .497 .634 r
.55741 .87861 m .55883 .9165 L .49754 .89297 L p F P
0 g
s
.738 .55 .638 r
.43453 .88875 m .43076 .92448 L .37128 .86495 L p F P
0 g
s
.709 .521 .633 r
.43076 .92448 m .43453 .88875 L .49633 .93035 L p F P
0 g
s
.412 .399 .735 r
.69162 .47352 m .68061 .45854 L .68341 .4251 L p F P
0 g
s
.422 .412 .743 r
.67229 .41411 m .68341 .4251 L .68061 .45854 L p F P
0 g
s
.639 .713 .901 r
.52481 .29053 m .5249 .29734 L .50918 .29759 L p F P
0 g
s
.639 .713 .901 r
.50918 .29759 m .50677 .29065 L .52481 .29053 L p F P
0 g
s
.564 .661 .903 r
.55571 .30544 m .56015 .30042 L .5757 .30992 L p F P
0 g
s
.591 .684 .906 r
.56015 .30042 m .55571 .30544 L .54068 .3 L p F P
0 g
s
.402 .435 .78 r
.67229 .41411 m .66129 .404 L .65719 .37533 L p F P
0 g
s
.418 .452 .789 r
.6466 .36898 m .65719 .37533 L .66129 .404 L p F P
0 g
s
.822 .741 .775 r
.29031 .34765 m .30106 .34568 L .29561 .40129 L p F P
0 g
s
.822 .741 .775 r
.29561 .40129 m .28462 .40697 L .29031 .34765 L p F P
0 g
s
.831 .677 .692 r
.22367 .53594 m .23496 .52366 L .25423 .60824 L p F P
0 g
s
.831 .677 .692 r
.25423 .60824 m .24359 .62553 L .22367 .53594 L p F P
0 g
s
.568 .423 .644 r
.65777 .8021 m .65155 .76823 L .69433 .74555 L p F P
0 g
s
.569 .426 .647 r
.68609 .71433 m .69433 .74555 L .65155 .76823 L p F P
0 g
s
.643 .469 .633 r
.55883 .9165 m .55741 .87861 L .61553 .88473 L p F P
0 g
s
.644 .471 .635 r
.61156 .84748 m .61553 .88473 L .55741 .87861 L p F P
0 g
s
.678 .731 .89 r
.48042 .28098 m .48507 .2876 L .46786 .29527 L p F P
0 g
s
.678 .731 .89 r
.46786 .29527 m .46125 .28958 L .48042 .28098 L p F P
0 g
s
.616 .701 .905 r
.5429 .29384 m .54068 .3 L .5249 .29734 L p F P
0 g
s
.616 .701 .905 r
.5249 .29734 m .52481 .29053 L .5429 .29384 L p F P
0 g
s
.591 .684 .906 r
.54068 .3 m .5429 .29384 L .56015 .30042 L p F P
0 g
s
.836 .711 .726 r
.23992 .43263 m .25122 .42576 L .25724 .50047 L p F P
0 g
s
.836 .711 .726 r
.25724 .50047 m .24615 .51184 L .23992 .43263 L p F P
0 g
s
.788 .755 .823 r
.34683 .29962 m .35663 .30128 L .34345 .33956 L p F P
0 g
s
.788 .755 .823 r
.34345 .33956 m .33293 .34083 L .34683 .29962 L p F P
0 g
s
.657 .722 .897 r
.50434 .28367 m .50677 .29065 L .48969 .29418 L p F P
0 g
s
.657 .722 .897 r
.48969 .29418 m .48507 .2876 L .50434 .28367 L p F P
0 g
s
.706 .742 .88 r
.44793 .27812 m .45461 .28386 L .43706 .29777 L p F P
0 g
s
.706 .742 .88 r
.43706 .29777 m .42877 .29354 L .44793 .27812 L p F P
0 g
s
.453 .55 .865 r
.62728 .34078 m .61769 .33852 L .60517 .32003 L p F P
0 g
s
.474 .568 .87 r
.59693 .32074 m .60517 .32003 L .61769 .33852 L p F P
0 g
s
.744 .752 .859 r
.40363 .28097 m .41206 .28514 L .39535 .30878 L p F P
0 g
s
.744 .752 .859 r
.39535 .30878 m .38574 .30678 L .40363 .28097 L p F P
0 g
s
.518 .62 .892 r
.5757 .30992 m .58218 .30675 L .59693 .32074 L p F P
0 g
s
.548 .651 .903 r
.58218 .30675 m .5757 .30992 L .56015 .30042 L p F P
0 g
s
.498 .605 .89 r
.60517 .32003 m .59693 .32074 L .58218 .30675 L p F P
0 g
s
.825 .74 .771 r
.2795 .3498 m .29031 .34765 L .28462 .40697 L p F P
0 g
s
.825 .74 .771 r
.28462 .40697 m .27357 .41293 L .2795 .3498 L p F P
0 g
s
.404 .476 .821 r
.65719 .37533 m .6466 .36898 L .63696 .3436 L p F P
0 g
s
.424 .495 .829 r
.62728 .34078 m .63696 .3436 L .6466 .36898 L p F P
0 g
s
.607 .444 .636 r
.61553 .88473 m .61156 .84748 L .66412 .83762 L p F P
0 g
s
.608 .447 .638 r
.65777 .8021 m .66412 .83762 L .61156 .84748 L p F P
0 g
s
.792 .755 .819 r
.33698 .29804 m .34683 .29962 L .33293 .34083 L p F P
0 g
s
.792 .755 .819 r
.33293 .34083 m .32237 .34227 L .33698 .29804 L p F P
0 g
s
.634 .711 .902 r
.5247 .28372 m .52481 .29053 L .50677 .29065 L p F P
0 g
s
.634 .711 .902 r
.50677 .29065 m .50434 .28367 L .5247 .28372 L p F P
0 g
s
.748 .753 .857 r
.39516 .27681 m .40363 .28097 L .38574 .30678 L p F P
0 g
s
.748 .753 .857 r
.38574 .30678 m .37609 .30486 L .39516 .27681 L p F P
0 g
s
.436 .377 .693 r
.71246 .56671 m .70178 .5455 L .71409 .5066 L p F P
0 g
s
.442 .386 .7 r
.70278 .48952 m .71409 .5066 L .70178 .5455 L p F P
0 g
s
.387 .418 .771 r
.68341 .4251 m .67229 .41411 L .6679 .38239 L p F P
0 g
s
.402 .435 .78 r
.65719 .37533 m .6679 .38239 L .67229 .41411 L p F P
0 g
s
.548 .651 .903 r
.56015 .30042 m .56463 .29556 L .58218 .30675 L p F P
0 g
s
.579 .677 .907 r
.56463 .29556 m .56015 .30042 L .5429 .29384 L p F P
0 g
s
.838 .71 .722 r
.22854 .43981 m .23992 .43263 L .24615 .51184 L p F P
0 g
s
.838 .71 .722 r
.24615 .51184 m .23496 .52366 L .22854 .43981 L p F P
0 g
s
.402 .386 .727 r
.70278 .48952 m .69162 .47352 L .69468 .43697 L p F P
0 g
s
.412 .399 .735 r
.68341 .4251 m .69468 .43697 L .69162 .47352 L p F P
0 g
s
.679 .732 .89 r
.47573 .27431 m .48042 .28098 L .46125 .28958 L p F P
0 g
s
.679 .732 .89 r
.46125 .28958 m .45461 .28386 L .47573 .27431 L p F P
0 g
s
.708 .743 .879 r
.4412 .27235 m .44793 .27812 L .42877 .29354 L p F P
0 g
s
.708 .743 .879 r
.42877 .29354 m .42044 .28934 L .4412 .27235 L p F P
0 g
s
.48 .384 .669 r
.71018 .65349 m .70048 .62713 L .72331 .58917 L p F P
0 g
s
.483 .39 .674 r
.71246 .56671 m .72331 .58917 L .70048 .62713 L p F P
0 g
s
.828 .74 .767 r
.26862 .35213 m .2795 .3498 L .27357 .41293 L p F P
0 g
s
.828 .74 .767 r
.27357 .41293 m .26243 .4192 L .26862 .35213 L p F P
0 g
s
.655 .721 .897 r
.50189 .27667 m .50434 .28367 L .48507 .2876 L p F P
0 g
s
.655 .721 .897 r
.48507 .2876 m .48042 .28098 L .50189 .27667 L p F P
0 g
s
.524 .399 .652 r
.69433 .74555 m .68609 .71433 L .72005 .68128 L p F P
0 g
s
.526 .404 .656 r
.71018 .65349 m .72005 .68128 L .68609 .71433 L p F P
0 g
s
.609 .697 .906 r
.54515 .28775 m .5429 .29384 L .52481 .29053 L p F P
0 g
s
.609 .697 .906 r
.52481 .29053 m .5247 .28372 L .54515 .28775 L p F P
0 g
s
.579 .677 .907 r
.5429 .29384 m .54515 .28775 L .56463 .29556 L p F P
0 g
s
.431 .532 .859 r
.63696 .3436 m .62728 .34078 L .61347 .31973 L p F P
0 g
s
.453 .55 .865 r
.60517 .32003 m .61347 .31973 L .62728 .34078 L p F P
0 g
s
.709 .521 .633 r
.49633 .93035 m .4951 .96937 L .43076 .92448 L p F P
0 g
s
.796 .756 .816 r
.32707 .29655 m .33698 .29804 L .32237 .34227 L p F P
0 g
s
.796 .756 .816 r
.32237 .34227 m .31174 .34389 L .32707 .29655 L p F P
0 g
s
.677 .493 .63 r
.4951 .96937 m .49633 .93035 L .56027 .95611 L p F P
0 g
s
.677 .495 .632 r
.55883 .9165 m .56027 .95611 L .49633 .93035 L p F P
0 g
s
.498 .605 .89 r
.58218 .30675 m .58873 .30387 L .60517 .32003 L p F P
0 g
s
.531 .641 .903 r
.58873 .30387 m .58218 .30675 L .56463 .29556 L p F P
0 g
s
.751 .754 .855 r
.38665 .27266 m .39516 .27681 L .37609 .30486 L p F P
0 g
s
.751 .754 .855 r
.37609 .30486 m .36639 .30303 L .38665 .27266 L p F P
0 g
s
.478 .591 .888 r
.61347 .31973 m .60517 .32003 L .58873 .30387 L p F P
0 g
s
.711 .744 .878 r
.43444 .26655 m .4412 .27235 L .42044 .28934 L p F P
0 g
s
.711 .744 .878 r
.42044 .28934 m .41206 .28514 L .43444 .26655 L p F P
0 g
s
.567 .419 .641 r
.66412 .83762 m .65777 .8021 L .70274 .77836 L p F P
0 g
s
.568 .423 .644 r
.69433 .74555 m .70274 .77836 L .65777 .8021 L p F P
0 g
s
.84 .709 .719 r
.21707 .4473 m .22854 .43981 L .23496 .52366 L p F P
0 g
s
.84 .709 .719 r
.23496 .52366 m .22367 .53594 L .21707 .4473 L p F P
0 g
s
.643 .467 .631 r
.56027 .95611 m .55883 .9165 L .61959 .92374 L p F P
0 g
s
.643 .469 .633 r
.61553 .88473 m .61959 .92374 L .55883 .9165 L p F P
0 g
s
.679 .732 .89 r
.47102 .26759 m .47573 .27431 L .45461 .28386 L p F P
0 g
s
.679 .732 .89 r
.45461 .28386 m .44793 .27812 L .47102 .26759 L p F P
0 g
s
.385 .458 .813 r
.6679 .38239 m .65719 .37533 L .64674 .34699 L p F P
0 g
s
.404 .476 .821 r
.63696 .3436 m .64674 .34699 L .65719 .37533 L p F P
0 g
s
.831 .739 .763 r
.25767 .35465 m .26862 .35213 L .26243 .4192 L p F P
0 g
s
.831 .739 .763 r
.26243 .4192 m .25122 .42576 L .25767 .35465 L p F P
0 g
s
.63 .709 .903 r
.5246 .27692 m .5247 .28372 L .50434 .28367 L p F P
0 g
s
.63 .709 .903 r
.50434 .28367 m .50189 .27667 L .5246 .27692 L p F P
0 g
s
.8 .756 .812 r
.31711 .29514 m .32707 .29655 L .31174 .34389 L p F P
0 g
s
.8 .756 .812 r
.31174 .34389 m .30106 .34568 L .31711 .29514 L p F P
0 g
s
.531 .641 .903 r
.56463 .29556 m .56915 .29088 L .58873 .30387 L p F P
0 g
s
.567 .671 .908 r
.56915 .29088 m .56463 .29556 L .54515 .28775 L p F P
0 g
s
.373 .403 .763 r
.69468 .43697 m .68341 .4251 L .67874 .39019 L p F P
0 g
s
.387 .418 .771 r
.6679 .38239 m .67874 .39019 L .68341 .4251 L p F P
0 g
s
.653 .721 .898 r
.49942 .26963 m .50189 .27667 L .48042 .28098 L p F P
0 g
s
.653 .721 .898 r
.48042 .28098 m .47573 .27431 L .49942 .26963 L p F P
0 g
s
.755 .755 .852 r
.37808 .26853 m .38665 .27266 L .36639 .30303 L p F P
0 g
s
.755 .755 .852 r
.36639 .30303 m .35663 .30128 L .37808 .26853 L p F P
0 g
s
.392 .374 .72 r
.71409 .5066 m .70278 .48952 L .70609 .44976 L p F P
0 g
s
.402 .386 .727 r
.69468 .43697 m .70609 .44976 L .70278 .48952 L p F P
0 g
s
.431 .369 .687 r
.72331 .58917 m .71246 .56671 L .72558 .52477 L p F P
0 g
s
.436 .377 .693 r
.71409 .5066 m .72558 .52477 L .71246 .56671 L p F P
0 g
s
.601 .693 .908 r
.54741 .28174 m .54515 .28775 L .5247 .28372 L p F P
0 g
s
.601 .693 .908 r
.5247 .28372 m .5246 .27692 L .54741 .28174 L p F P
0 g
s
.567 .671 .908 r
.54515 .28775 m .54741 .28174 L .56915 .29088 L p F P
0 g
s
.713 .745 .877 r
.42763 .26072 m .43444 .26655 L .41206 .28514 L p F P
0 g
s
.713 .745 .877 r
.41206 .28514 m .40363 .28097 L .42763 .26072 L p F P
0 g
s
.41 .514 .853 r
.64674 .34699 m .63696 .3436 L .62187 .31986 L p F P
0 g
s
.431 .532 .859 r
.61347 .31973 m .62187 .31986 L .63696 .3436 L p F P
0 g
s
.476 .378 .664 r
.72005 .68128 m .71018 .65349 L .73434 .61291 L p F P
0 g
s
.48 .384 .669 r
.72331 .58917 m .73434 .61291 L .71018 .65349 L p F P
0 g
s
.606 .442 .633 r
.61959 .92374 m .61553 .88473 L .67059 .87488 L p F P
0 g
s
.607 .444 .636 r
.66412 .83762 m .67059 .87488 L .61553 .88473 L p F P
0 g
s
.834 .739 .759 r
.24665 .35735 m .25767 .35465 L .25122 .42576 L p F P
0 g
s
.834 .739 .759 r
.25122 .42576 m .23992 .43263 L .24665 .35735 L p F P
0 g
s
.478 .591 .888 r
.58873 .30387 m .59533 .30127 L .61347 .31973 L p F P
0 g
s
.515 .63 .903 r
.59533 .30127 m .58873 .30387 L .56915 .29088 L p F P
0 g
s
.804 .756 .809 r
.30709 .29381 m .31711 .29514 L .30106 .34568 L p F P
0 g
s
.804 .756 .809 r
.30106 .34568 m .29031 .34765 L .30709 .29381 L p F P
0 g
s
.68 .732 .89 r
.46627 .26083 m .47102 .26759 L .44793 .27812 L p F P
0 g
s
.68 .732 .89 r
.44793 .27812 m .4412 .27235 L .46627 .26083 L p F P
0 g
s
.458 .576 .885 r
.62187 .31986 m .61347 .31973 L .59533 .30127 L p F P
0 g
s
.522 .395 .648 r
.70274 .77836 m .69433 .74555 L .73011 .71054 L p F P
0 g
s
.524 .399 .652 r
.72005 .68128 m .73011 .71054 L .69433 .74555 L p F P
0 g
s
.759 .756 .85 r
.36947 .26442 m .37808 .26853 L .35663 .30128 L p F P
0 g
s
.759 .756 .85 r
.35663 .30128 m .34683 .29962 L .36947 .26442 L p F P
0 g
s
.625 .707 .904 r
.5245 .27013 m .5246 .27692 L .50189 .27667 L p F P
0 g
s
.625 .707 .904 r
.50189 .27667 m .49942 .26963 L .5245 .27013 L p F P
0 g
s
.366 .44 .804 r
.67874 .39019 m .6679 .38239 L .65663 .35096 L p F P
0 g
s
.385 .458 .813 r
.64674 .34699 m .65663 .35096 L .6679 .38239 L p F P
0 g
s
.652 .72 .899 r
.49694 .26256 m .49942 .26963 L .47573 .27431 L p F P
0 g
s
.652 .72 .899 r
.47573 .27431 m .47102 .26759 L .49694 .26256 L p F P
0 g
s
.677 .493 .63 r
.56027 .95611 m .56175 .99753 L .4951 .96937 L p F P
0 g
s
.716 .746 .875 r
.42079 .25487 m .42763 .26072 L .40363 .28097 L p F P
0 g
s
.716 .746 .875 r
.40363 .28097 m .39516 .27681 L .42079 .25487 L p F P
0 g
s
.515 .63 .903 r
.56915 .29088 m .57371 .28637 L .59533 .30127 L p F P
0 g
s
.555 .664 .909 r
.57371 .28637 m .56915 .29088 L .54741 .28174 L p F P
0 g
s
.807 .757 .806 r
.29701 .29258 m .30709 .29381 L .29031 .34765 L p F P
0 g
s
.807 .757 .806 r
.29031 .34765 m .2795 .3498 L .29701 .29258 L p F P
0 g
s
.836 .738 .756 r
.23556 .36023 m .24665 .35735 L .23992 .43263 L p F P
0 g
s
.836 .738 .756 r
.23992 .43263 m .22854 .43981 L .23556 .36023 L p F P
0 g
s
.359 .388 .755 r
.70609 .44976 m .69468 .43697 L .6897 .39873 L p F P
0 g
s
.373 .403 .763 r
.67874 .39019 m .6897 .39873 L .69468 .43697 L p F P
0 g
s
.566 .417 .638 r
.67059 .87488 m .66412 .83762 L .71131 .81283 L p F P
0 g
s
.567 .419 .641 r
.70274 .77836 m .71131 .81283 L .66412 .83762 L p F P
0 g
s
.593 .689 .909 r
.54969 .2758 m .54741 .28174 L .5246 .27692 L p F P
0 g
s
.593 .689 .909 r
.5246 .27692 m .5245 .27013 L .54969 .2758 L p F P
0 g
s
.763 .757 .848 r
.36081 .26033 m .36947 .26442 L .34683 .29962 L p F P
0 g
s
.763 .757 .848 r
.34683 .29962 m .33698 .29804 L .36081 .26033 L p F P
0 g
s
.68 .733 .89 r
.46149 .25403 m .46627 .26083 L .4412 .27235 L p F P
0 g
s
.68 .733 .89 r
.4412 .27235 m .43444 .26655 L .46149 .25403 L p F P
0 g
s
.555 .664 .909 r
.54741 .28174 m .54969 .2758 L .57371 .28637 L p F P
0 g
s
.384 .363 .713 r
.72558 .52477 m .71409 .5066 L .71766 .46347 L p F P
0 g
s
.392 .374 .72 r
.70609 .44976 m .71766 .46347 L .71409 .5066 L p F P
0 g
s
.643 .466 .629 r
.56175 .99753 m .56027 .95611 L .62374 .96458 L p F P
0 g
s
.643 .467 .631 r
.61959 .92374 m .62374 .96458 L .56027 .95611 L p F P
0 g
s
.388 .495 .847 r
.65663 .35096 m .64674 .34699 L .63034 .32041 L p F P
0 g
s
.41 .514 .853 r
.62187 .31986 m .63034 .32041 L .64674 .34699 L p F P
0 g
s
.425 .361 .682 r
.73434 .61291 m .72331 .58917 L .73724 .54407 L p F P
0 g
s
.431 .369 .687 r
.72558 .52477 m .73724 .54407 L .72331 .58917 L p F P
0 g
s
.458 .576 .885 r
.59533 .30127 m .602 .29897 L .62187 .31986 L p F P
0 g
s
.498 .619 .902 r
.602 .29897 m .59533 .30127 L .57371 .28637 L p F P
0 g
s
.437 .56 .881 r
.63034 .32041 m .62187 .31986 L .602 .29897 L p F P
0 g
s
.718 .747 .874 r
.4139 .24898 m .42079 .25487 L .39516 .27681 L p F P
0 g
s
.718 .747 .874 r
.39516 .27681 m .38665 .27266 L .4139 .24898 L p F P
0 g
s
.81 .757 .803 r
.28688 .29143 m .29701 .29258 L .2795 .3498 L p F P
0 g
s
.81 .757 .803 r
.2795 .3498 m .26862 .35213 L .28688 .29143 L p F P
0 g
s
.621 .705 .905 r
.5244 .26334 m .5245 .27013 L .49942 .26963 L p F P
0 g
s
.621 .705 .905 r
.49942 .26963 m .49694 .26256 L .5244 .26334 L p F P
0 g
s
.65 .719 .899 r
.49444 .25545 m .49694 .26256 L .47102 .26759 L p F P
0 g
s
.65 .719 .899 r
.47102 .26759 m .46627 .26083 L .49444 .25545 L p F P
0 g
s
.473 .373 .66 r
.73011 .71054 m .72005 .68128 L .74557 .63799 L p F P
0 g
s
.476 .378 .664 r
.73434 .61291 m .74557 .63799 L .72005 .68128 L p F P
0 g
s
.839 .737 .752 r
.22439 .36331 m .23556 .36023 L .22854 .43981 L p F P
0 g
s
.839 .737 .752 r
.22854 .43981 m .21707 .4473 L .22439 .36331 L p F P
0 g
s
.766 .758 .846 r
.3521 .25625 m .36081 .26033 L .33698 .29804 L p F P
0 g
s
.766 .758 .846 r
.33698 .29804 m .32707 .29655 L .3521 .25625 L p F P
0 g
s
.348 .422 .796 r
.6897 .39873 m .67874 .39019 L .66663 .35551 L p F P
0 g
s
.366 .44 .804 r
.65663 .35096 m .66663 .35551 L .67874 .39019 L p F P
0 g
s
.605 .44 .631 r
.62374 .96458 m .61959 .92374 L .67721 .91394 L p F P
0 g
s
.606 .442 .633 r
.67059 .87488 m .67721 .91394 L .61959 .92374 L p F P
0 g
s
.681 .733 .89 r
.45667 .24717 m .46149 .25403 L .43444 .26655 L p F P
0 g
s
.681 .733 .89 r
.43444 .26655 m .42763 .26072 L .45667 .24717 L p F P
0 g
s
.498 .619 .902 r
.57371 .28637 m .57831 .28203 L .602 .29897 L p F P
0 g
s
.542 .657 .91 r
.57831 .28203 m .57371 .28637 L .54969 .2758 L p F P
0 g
s
.52 .392 .645 r
.71131 .81283 m .70274 .77836 L .74037 .74135 L p F P
0 g
s
.522 .395 .648 r
.73011 .71054 m .74037 .74135 L .70274 .77836 L p F P
0 g
s
.584 .685 .91 r
.552 .26994 m .54969 .2758 L .5245 .27013 L p F P
0 g
s
.584 .685 .91 r
.5245 .27013 m .5244 .26334 L .552 .26994 L p F P
0 g
s
.814 .757 .799 r
.27668 .29037 m .28688 .29143 L .26862 .35213 L p F P
0 g
s
.814 .757 .799 r
.26862 .35213 m .25767 .35465 L .27668 .29037 L p F P
0 g
s
.721 .748 .873 r
.40697 .24307 m .4139 .24898 L .38665 .27266 L p F P
0 g
s
.721 .748 .873 r
.38665 .27266 m .37808 .26853 L .40697 .24307 L p F P
0 g
s
.346 .373 .746 r
.71766 .46347 m .70609 .44976 L .70082 .40804 L p F P
0 g
s
.359 .388 .755 r
.6897 .39873 m .70082 .40804 L .70609 .44976 L p F P
0 g
s
.542 .657 .91 r
.54969 .2758 m .552 .26994 L .57831 .28203 L p F P
0 g
s
.77 .759 .843 r
.34334 .25218 m .3521 .25625 L .32707 .29655 L p F P
0 g
s
.77 .759 .843 r
.32707 .29655 m .31711 .29514 L .34334 .25218 L p F P
0 g
s
.367 .477 .84 r
.66663 .35551 m .65663 .35096 L .63891 .32139 L p F P
0 g
s
.388 .495 .847 r
.63034 .32041 m .63891 .32139 L .65663 .35096 L p F P
0 g
s
.437 .56 .881 r
.602 .29897 m .60873 .29695 L .63034 .32041 L p F P
0 g
s
.48 .608 .901 r
.60873 .29695 m .602 .29897 L .57831 .28203 L p F P
0 g
s
.375 .353 .706 r
.73724 .54407 m .72558 .52477 L .72941 .47815 L p F P
0 g
s
.384 .363 .713 r
.71766 .46347 m .72941 .47815 L .72558 .52477 L p F P
0 g
s
.648 .718 .9 r
.49191 .24831 m .49444 .25545 L .46627 .26083 L p F P
0 g
s
.648 .718 .9 r
.46627 .26083 m .46149 .25403 L .49191 .24831 L p F P
0 g
s
.616 .703 .907 r
.52429 .25657 m .5244 .26334 L .49694 .26256 L p F P
0 g
s
.616 .703 .907 r
.49694 .26256 m .49444 .25545 L .52429 .25657 L p F P
0 g
s
.416 .544 .877 r
.63891 .32139 m .63034 .32041 L .60873 .29695 L p F P
0 g
s
.681 .733 .89 r
.45183 .24028 m .45667 .24717 L .42763 .26072 L p F P
0 g
s
.681 .733 .89 r
.42763 .26072 m .42079 .25487 L .45183 .24028 L p F P
0 g
s
.564 .414 .635 r
.67721 .91394 m .67059 .87488 L .72008 .84902 L p F P
0 g
s
.566 .417 .638 r
.71131 .81283 m .72008 .84902 L .67059 .87488 L p F P
0 g
s
.421 .354 .677 r
.74557 .63799 m .73434 .61291 L .7491 .56454 L p F P
0 g
s
.425 .361 .682 r
.73724 .54407 m .7491 .56454 L .73434 .61291 L p F P
0 g
s
.817 .757 .796 r
.26642 .2894 m .27668 .29037 L .25767 .35465 L p F P
0 g
s
.817 .757 .796 r
.25767 .35465 m .24665 .35735 L .26642 .2894 L p F P
0 g
s
.723 .749 .872 r
.39999 .23712 m .40697 .24307 L .37808 .26853 L p F P
0 g
s
.723 .749 .872 r
.37808 .26853 m .36947 .26442 L .39999 .23712 L p F P
0 g
s
.643 .466 .629 r
.62374 .96458 m .62799 1.00734 L .56175 .99753 L p F P
0 g
s
.773 .76 .841 r
.33453 .24813 m .34334 .25218 L .31711 .29514 L p F P
0 g
s
.773 .76 .841 r
.31711 .29514 m .30709 .29381 L .33453 .24813 L p F P
0 g
s
.33 .405 .788 r
.70082 .40804 m .6897 .39873 L .67676 .36066 L p F P
0 g
s
.348 .422 .796 r
.66663 .35551 m .67676 .36066 L .6897 .39873 L p F P
0 g
s
.48 .608 .901 r
.57831 .28203 m .58296 .27787 L .60873 .29695 L p F P
0 g
s
.53 .649 .911 r
.58296 .27787 m .57831 .28203 L .552 .26994 L p F P
0 g
s
.576 .68 .911 r
.55432 .26416 m .552 .26994 L .5244 .26334 L p F P
0 g
s
.576 .68 .911 r
.5244 .26334 m .52429 .25657 L .55432 .26416 L p F P
0 g
s
.47 .368 .656 r
.74037 .74135 m .73011 .71054 L .75701 .66445 L p F P
0 g
s
.473 .373 .66 r
.74557 .63799 m .75701 .66445 L .73011 .71054 L p F P
0 g
s
.53 .649 .911 r
.552 .26994 m .55432 .26416 L .58296 .27787 L p F P
0 g
s
.646 .718 .9 r
.48937 .24114 m .49191 .24831 L .46149 .25403 L p F P
0 g
s
.646 .718 .9 r
.46149 .25403 m .45667 .24717 L .48937 .24114 L p F P
0 g
s
.682 .734 .89 r
.44695 .23333 m .45183 .24028 L .42079 .25487 L p F P
0 g
s
.682 .734 .89 r
.42079 .25487 m .4139 .24898 L .44695 .23333 L p F P
0 g
s
.82 .757 .793 r
.2561 .28851 m .26642 .2894 L .24665 .35735 L p F P
0 g
s
.82 .757 .793 r
.24665 .35735 m .23556 .36023 L .2561 .28851 L p F P
0 g
s
.334 .359 .739 r
.72941 .47815 m .71766 .46347 L .71208 .41813 L p F P
0 g
s
.346 .373 .746 r
.70082 .40804 m .71208 .41813 L .71766 .46347 L p F P
0 g
s
.726 .75 .871 r
.39297 .23115 m .39999 .23712 L .36947 .26442 L p F P
0 g
s
.726 .75 .871 r
.36947 .26442 m .36081 .26033 L .39297 .23115 L p F P
0 g
s
.611 .7 .908 r
.52419 .2498 m .52429 .25657 L .49444 .25545 L p F P
0 g
s
.611 .7 .908 r
.49444 .25545 m .49191 .24831 L .52419 .2498 L p F P
0 g
s
.347 .459 .833 r
.67676 .36066 m .66663 .35551 L .64757 .32282 L p F P
0 g
s
.367 .477 .84 r
.63891 .32139 m .64757 .32282 L .66663 .35551 L p F P
0 g
s
.776 .761 .839 r
.32567 .2441 m .33453 .24813 L .30709 .29381 L p F P
0 g
s
.776 .761 .839 r
.30709 .29381 m .29701 .29258 L .32567 .2441 L p F P
0 g
s
.416 .544 .877 r
.60873 .29695 m .61553 .29524 L .63891 .32139 L p F P
0 g
s
.463 .596 .9 r
.61553 .29524 m .60873 .29695 L .58296 .27787 L p F P
0 g
s
.605 .438 .629 r
.62799 1.00734 m .62374 .96458 L .68398 .9549 L p F P
0 g
s
.605 .44 .631 r
.67721 .91394 m .68398 .9549 L .62374 .96458 L p F P
0 g
s
.519 .388 .642 r
.72008 .84902 m .71131 .81283 L .75084 .77375 L p F P
0 g
s
.52 .392 .645 r
.74037 .74135 m .75084 .77375 L .71131 .81283 L p F P
0 g
s
.396 .529 .873 r
.64757 .32282 m .63891 .32139 L .61553 .29524 L p F P
0 g
s
.368 .343 .7 r
.7491 .56454 m .73724 .54407 L .74133 .4938 L p F P
0 g
s
.375 .353 .706 r
.72941 .47815 m .74133 .4938 L .73724 .54407 L p F P
0 g
s
.823 .757 .79 r
.24571 .28772 m .2561 .28851 L .23556 .36023 L p F P
0 g
s
.823 .757 .79 r
.23556 .36023 m .22439 .36331 L .24571 .28772 L p F P
0 g
s
.567 .676 .912 r
.55666 .25846 m .55432 .26416 L .52429 .25657 L p F P
0 g
s
.567 .676 .912 r
.52429 .25657 m .52419 .2498 L .55666 .25846 L p F P
0 g
s
.728 .75 .87 r
.38591 .22515 m .39297 .23115 L .36081 .26033 L p F P
0 g
s
.728 .75 .87 r
.36081 .26033 m .3521 .25625 L .38591 .22515 L p F P
0 g
s
.463 .596 .9 r
.58296 .27787 m .58765 .27388 L .61553 .29524 L p F P
0 g
s
.516 .641 .911 r
.58765 .27388 m .58296 .27787 L .55432 .26416 L p F P
0 g
s
.683 .734 .889 r
.44203 .22634 m .44695 .23333 L .4139 .24898 L p F P
0 g
s
.683 .734 .889 r
.4139 .24898 m .40697 .24307 L .44203 .22634 L p F P
0 g
s
.779 .761 .837 r
.31675 .24008 m .32567 .2441 L .29701 .29258 L p F P
0 g
s
.779 .761 .837 r
.29701 .29258 m .28688 .29143 L .31675 .24008 L p F P
0 g
s
.644 .717 .901 r
.48681 .23393 m .48937 .24114 L .45667 .24717 L p F P
0 g
s
.644 .717 .901 r
.45667 .24717 m .45183 .24028 L .48681 .23393 L p F P
0 g
s
.314 .388 .779 r
.71208 .41813 m .70082 .40804 L .68701 .36641 L p F P
0 g
s
.33 .405 .788 r
.67676 .36066 m .68701 .36641 L .70082 .40804 L p F P
0 g
s
.416 .347 .672 r
.75701 .66445 m .74557 .63799 L .76118 .58621 L p F P
0 g
s
.421 .354 .677 r
.7491 .56454 m .76118 .58621 L .74557 .63799 L p F P
0 g
s
.516 .641 .911 r
.55432 .26416 m .55666 .25846 L .58765 .27388 L p F P
0 g
s
.564 .411 .633 r
.68398 .9549 m .67721 .91394 L .72904 .88702 L p F P
0 g
s
.564 .414 .635 r
.72008 .84902 m .72904 .88702 L .67721 .91394 L p F P
0 g
s
.606 .698 .909 r
.52408 .24304 m .52419 .2498 L .49191 .24831 L p F P
0 g
s
.606 .698 .909 r
.49191 .24831 m .48937 .24114 L .52408 .24304 L p F P
0 g
s
.326 .442 .825 r
.68701 .36641 m .67676 .36066 L .65634 .32468 L p F P
0 g
s
.347 .459 .833 r
.64757 .32282 m .65634 .32468 L .67676 .36066 L p F P
0 g
s
.396 .529 .873 r
.61553 .29524 m .62241 .29382 L .64757 .32282 L p F P
0 g
s
.445 .584 .898 r
.62241 .29382 m .61553 .29524 L .58765 .27388 L p F P
0 g
s
.468 .363 .652 r
.75084 .77375 m .74037 .74135 L .76868 .69235 L p F P
0 g
s
.47 .368 .656 r
.75701 .66445 m .76868 .69235 L .74037 .74135 L p F P
0 g
s
.322 .346 .731 r
.74133 .4938 m .72941 .47815 L .72351 .42901 L p F P
0 g
s
.334 .359 .739 r
.71208 .41813 m .72351 .42901 L .72941 .47815 L p F P
0 g
s
.783 .762 .835 r
.30778 .23608 m .31675 .24008 L .28688 .29143 L p F P
0 g
s
.783 .762 .835 r
.28688 .29143 m .27668 .29037 L .30778 .23608 L p F P
0 g
s
.73 .751 .869 r
.37881 .21912 m .38591 .22515 L .3521 .25625 L p F P
0 g
s
.73 .751 .869 r
.3521 .25625 m .34334 .25218 L .37881 .21912 L p F P
0 g
s
.375 .512 .868 r
.65634 .32468 m .64757 .32282 L .62241 .29382 L p F P
0 g
s
.683 .734 .889 r
.43708 .2193 m .44203 .22634 L .40697 .24307 L p F P
0 g
s
.683 .734 .889 r
.40697 .24307 m .39999 .23712 L .43708 .2193 L p F P
0 g
s
.642 .716 .901 r
.48422 .22668 m .48681 .23393 L .45183 .24028 L p F P
0 g
s
.642 .716 .901 r
.45183 .24028 m .44695 .23333 L .48422 .22668 L p F P
0 g
s
.559 .671 .913 r
.55903 .25284 m .55666 .25846 L .52419 .2498 L p F P
0 g
s
.559 .671 .913 r
.52419 .2498 m .52408 .24304 L .55903 .25284 L p F P
0 g
s
.361 .334 .694 r
.76118 .58621 m .7491 .56454 L .75346 .51048 L p F P
0 g
s
.368 .343 .7 r
.74133 .4938 m .75346 .51048 L .7491 .56454 L p F P
0 g
s
.445 .584 .898 r
.58765 .27388 m .59239 .27007 L .62241 .29382 L p F P
0 g
s
.503 .633 .911 r
.59239 .27007 m .58765 .27388 L .55666 .25846 L p F P
0 g
s
.605 .438 .629 r
.68398 .9549 m .69092 .99784 L .62799 1.00734 L p F P
0 g
s
.517 .385 .639 r
.72904 .88702 m .72008 .84902 L .76154 .80782 L p F P
0 g
s
.519 .388 .642 r
.75084 .77375 m .76154 .80782 L .72008 .84902 L p F P
0 g
s
.601 .696 .91 r
.52398 .23628 m .52408 .24304 L .48937 .24114 L p F P
0 g
s
.601 .696 .91 r
.48937 .24114 m .48681 .23393 L .52398 .23628 L p F P
0 g
s
.503 .633 .911 r
.55666 .25846 m .55903 .25284 L .59239 .27007 L p F P
0 g
s
.786 .763 .832 r
.29876 .23209 m .30778 .23608 L .27668 .29037 L p F P
0 g
s
.786 .763 .832 r
.27668 .29037 m .26642 .2894 L .29876 .23209 L p F P
0 g
s
.297 .372 .771 r
.72351 .42901 m .71208 .41813 L .6974 .37279 L p F P
0 g
s
.314 .388 .779 r
.68701 .36641 m .6974 .37279 L .71208 .41813 L p F P
0 g
s
.733 .752 .868 r
.37166 .21305 m .37881 .21912 L .34334 .25218 L p F P
0 g
s
.733 .752 .868 r
.34334 .25218 m .33453 .24813 L .37166 .21305 L p F P
0 g
s
.684 .735 .889 r
.4321 .21221 m .43708 .2193 L .39999 .23712 L p F P
0 g
s
.684 .735 .889 r
.39999 .23712 m .39297 .23115 L .4321 .21221 L p F P
0 g
s
.412 .341 .667 r
.76868 .69235 m .75701 .66445 L .77347 .60913 L p F P
0 g
s
.416 .347 .672 r
.76118 .58621 m .77347 .60913 L .75701 .66445 L p F P
0 g
s
.375 .512 .868 r
.62241 .29382 m .62937 .29271 L .65634 .32468 L p F P
0 g
s
.427 .571 .895 r
.62937 .29271 m .62241 .29382 L .59239 .27007 L p F P
0 g
s
.64 .715 .902 r
.48162 .2194 m .48422 .22668 L .44695 .23333 L p F P
0 g
s
.64 .715 .902 r
.44695 .23333 m .44203 .22634 L .48162 .2194 L p F P
0 g
s
.307 .424 .818 r
.6974 .37279 m .68701 .36641 L .66521 .32701 L p F P
0 g
s
.326 .442 .825 r
.65634 .32468 m .66521 .32701 L .68701 .36641 L p F P
0 g
s
.354 .496 .863 r
.66521 .32701 m .65634 .32468 L .62937 .29271 L p F P
0 g
s
.789 .763 .83 r
.28969 .22812 m .29876 .23209 L .26642 .2894 L p F P
0 g
s
.789 .763 .83 r
.26642 .2894 m .2561 .28851 L .28969 .22812 L p F P
0 g
s
.312 .334 .724 r
.75346 .51048 m .74133 .4938 L .73511 .44073 L p F P
0 g
s
.322 .346 .731 r
.72351 .42901 m .73511 .44073 L .74133 .4938 L p F P
0 g
s
.55 .666 .914 r
.56142 .24729 m .55903 .25284 L .52408 .24304 L p F P
0 g
s
.55 .666 .914 r
.52408 .24304 m .52398 .23628 L .56142 .24729 L p F P
0 g
s
.735 .753 .867 r
.36446 .20696 m .37166 .21305 L .33453 .24813 L p F P
0 g
s
.735 .753 .867 r
.33453 .24813 m .32567 .2441 L .36446 .20696 L p F P
0 g
s
.563 .409 .631 r
.69092 .99784 m .68398 .9549 L .73821 .92692 L p F P
0 g
s
.564 .411 .633 r
.72904 .88702 m .73821 .92692 L .68398 .9549 L p F P
0 g
s
.596 .693 .91 r
.52387 .22953 m .52398 .23628 L .48681 .23393 L p F P
0 g
s
.596 .693 .91 r
.48681 .23393 m .48422 .22668 L .52387 .22953 L p F P
0 g
s
.466 .359 .649 r
.76154 .80782 m .75084 .77375 L .7806 .72175 L p F P
0 g
s
.468 .363 .652 r
.76868 .69235 m .7806 .72175 L .75084 .77375 L p F P
0 g
s
.427 .571 .895 r
.59239 .27007 m .59718 .26644 L .62937 .29271 L p F P
0 g
s
.489 .625 .911 r
.59718 .26644 m .59239 .27007 L .55903 .25284 L p F P
0 g
s
.684 .735 .889 r
.42708 .20507 m .4321 .21221 L .39297 .23115 L p F P
0 g
s
.684 .735 .889 r
.39297 .23115 m .38591 .22515 L .42708 .20507 L p F P
0 g
s
.489 .625 .911 r
.55903 .25284 m .56142 .24729 L .59718 .26644 L p F P
0 g
s
.354 .325 .688 r
.77347 .60913 m .76118 .58621 L .76579 .5282 L p F P
0 g
s
.361 .334 .694 r
.75346 .51048 m .76579 .5282 L .76118 .58621 L p F P
0 g
s
.639 .715 .902 r
.479 .21208 m .48162 .2194 L .44203 .22634 L p F P
0 g
s
.639 .715 .902 r
.44203 .22634 m .43708 .2193 L .479 .21208 L p F P
0 g
s
.791 .764 .828 r
.28055 .22417 m .28969 .22812 L .2561 .28851 L p F P
0 g
s
.791 .764 .828 r
.2561 .28851 m .24571 .28772 L .28055 .22417 L p F P
0 g
s
.282 .357 .763 r
.73511 .44073 m .72351 .42901 L .70794 .3798 L p F P
0 g
s
.297 .372 .771 r
.6974 .37279 m .70794 .3798 L .72351 .42901 L p F P
0 g
s
.737 .754 .866 r
.35722 .20083 m .36446 .20696 L .32567 .2441 L p F P
0 g
s
.737 .754 .866 r
.32567 .2441 m .31675 .24008 L .35722 .20083 L p F P
0 g
s
.354 .496 .863 r
.62937 .29271 m .6364 .2919 L .66521 .32701 L p F P
0 g
s
.408 .559 .893 r
.6364 .2919 m .62937 .29271 L .59718 .26644 L p F P
0 g
s
.516 .382 .637 r
.73821 .92692 m .72904 .88702 L .77249 .84364 L p F P
0 g
s
.517 .385 .639 r
.76154 .80782 m .77249 .84364 L .72904 .88702 L p F P
0 g
s
.685 .735 .889 r
.42202 .19788 m .42708 .20507 L .38591 .22515 L p F P
0 g
s
.685 .735 .889 r
.38591 .22515 m .37881 .21912 L .42202 .19788 L p F P
0 g
s
.541 .662 .915 r
.56384 .24183 m .56142 .24729 L .52398 .23628 L p F P
0 g
s
.541 .662 .915 r
.52398 .23628 m .52387 .22953 L .56384 .24183 L p F P
0 g
s
.287 .407 .81 r
.70794 .3798 m .6974 .37279 L .67419 .32979 L p F P
0 g
s
.307 .424 .818 r
.66521 .32701 m .67419 .32979 L .6974 .37279 L p F P
0 g
s
.591 .691 .911 r
.52376 .22278 m .52387 .22953 L .48422 .22668 L p F P
0 g
s
.591 .691 .911 r
.48422 .22668 m .48162 .2194 L .52376 .22278 L p F P
0 g
s
.333 .48 .857 r
.67419 .32979 m .66521 .32701 L .6364 .2919 L p F P
0 g
s
.408 .335 .663 r
.7806 .72175 m .76868 .69235 L .78601 .63334 L p F P
0 g
s
.412 .341 .667 r
.77347 .60913 m .78601 .63334 L .76868 .69235 L p F P
0 g
s
.408 .559 .893 r
.59718 .26644 m .60202 .26299 L .6364 .2919 L p F P
0 g
s
.476 .617 .91 r
.60202 .26299 m .59718 .26644 L .56142 .24729 L p F P
0 g
s
.739 .755 .865 r
.34993 .19468 m .35722 .20083 L .31675 .24008 L p F P
0 g
s
.739 .755 .865 r
.31675 .24008 m .30778 .23608 L .34993 .19468 L p F P
0 g
s
.301 .322 .716 r
.76579 .5282 m .75346 .51048 L .7469 .45328 L p F P
0 g
s
.312 .334 .724 r
.73511 .44073 m .7469 .45328 L .75346 .51048 L p F P
0 g
s
.637 .714 .903 r
.47635 .20472 m .479 .21208 L .43708 .2193 L p F P
0 g
s
.637 .714 .903 r
.43708 .2193 m .4321 .21221 L .47635 .20472 L p F P
0 g
s
.476 .617 .91 r
.56142 .24729 m .56384 .24183 L .60202 .26299 L p F P
0 g
s
.685 .736 .889 r
.41693 .19065 m .42202 .19788 L .37881 .21912 L p F P
0 g
s
.685 .736 .889 r
.37881 .21912 m .37166 .21305 L .41693 .19065 L p F P
0 g
s
.563 .409 .631 r
.73821 .92692 m .74762 .96879 L .69092 .99784 L p F P
0 g
s
.463 .355 .646 r
.77249 .84364 m .76154 .80782 L .79277 .7527 L p F P
0 g
s
.466 .359 .649 r
.7806 .72175 m .79277 .7527 L .76154 .80782 L p F P
0 g
s
.267 .342 .755 r
.7469 .45328 m .73511 .44073 L .71863 .38746 L p F P
0 g
s
.282 .357 .763 r
.70794 .3798 m .71863 .38746 L .73511 .44073 L p F P
0 g
s
.586 .689 .912 r
.52365 .21604 m .52376 .22278 L .48162 .2194 L p F P
0 g
s
.586 .689 .912 r
.48162 .2194 m .479 .21208 L .52365 .21604 L p F P
0 g
s
.532 .657 .915 r
.56627 .23644 m .56384 .24183 L .52387 .22953 L p F P
0 g
s
.532 .657 .915 r
.52387 .22953 m .52376 .22278 L .56627 .23644 L p F P
0 g
s
.333 .48 .857 r
.6364 .2919 m .64352 .29141 L .67419 .32979 L p F P
0 g
s
.39 .546 .89 r
.64352 .29141 m .6364 .2919 L .60202 .26299 L p F P
0 g
s
.742 .755 .864 r
.3426 .18849 m .34993 .19468 L .30778 .23608 L p F P
0 g
s
.742 .755 .864 r
.30778 .23608 m .29876 .23209 L .3426 .18849 L p F P
0 g
s
.348 .317 .682 r
.78601 .63334 m .77347 .60913 L .77836 .547 L p F P
0 g
s
.354 .325 .688 r
.76579 .5282 m .77836 .547 L .77347 .60913 L p F P
0 g
s
.635 .713 .904 r
.47369 .19732 m .47635 .20472 L .4321 .21221 L p F P
0 g
s
.635 .713 .904 r
.4321 .21221 m .42708 .20507 L .47369 .19732 L p F P
0 g
s
.268 .39 .802 r
.71863 .38746 m .70794 .3798 L .68329 .33305 L p F P
0 g
s
.287 .407 .81 r
.67419 .32979 m .68329 .33305 L .70794 .3798 L p F P
0 g
s
.312 .463 .851 r
.68329 .33305 m .67419 .32979 L .64352 .29141 L p F P
0 g
s
.686 .736 .889 r
.41181 .18336 m .41693 .19065 L .37166 .21305 L p F P
0 g
s
.686 .736 .889 r
.37166 .21305 m .36446 .20696 L .41181 .18336 L p F P
0 g
s
.461 .608 .91 r
.60691 .25972 m .60202 .26299 L .56384 .24183 L p F P
0 g
s
.461 .608 .91 r
.56384 .24183 m .56627 .23644 L .60691 .25972 L p F P
0 g
s
.39 .546 .89 r
.60202 .26299 m .60691 .25972 L .64352 .29141 L p F P
0 g
s
.744 .756 .863 r
.33522 .18227 m .3426 .18849 L .29876 .23209 L p F P
0 g
s
.744 .756 .863 r
.29876 .23209 m .28969 .22812 L .33522 .18227 L p F P
0 g
s
.515 .379 .634 r
.74762 .96879 m .73821 .92692 L .78371 .88128 L p F P
0 g
s
.516 .382 .637 r
.77249 .84364 m .78371 .88128 L .73821 .92692 L p F P
0 g
s
.292 .311 .71 r
.77836 .547 m .76579 .5282 L .75888 .4667 L p F P
0 g
s
.301 .322 .716 r
.7469 .45328 m .75888 .4667 L .76579 .5282 L p F P
0 g
s
.405 .33 .659 r
.79277 .7527 m .7806 .72175 L .79881 .6589 L p F P
0 g
s
.408 .335 .663 r
.78601 .63334 m .79881 .6589 L .7806 .72175 L p F P
0 g
s
.581 .686 .913 r
.52354 .2093 m .52365 .21604 L .479 .21208 L p F P
0 g
s
.581 .686 .913 r
.479 .21208 m .47635 .20472 L .52354 .2093 L p F P
0 g
s
.522 .651 .916 r
.56874 .23113 m .56627 .23644 L .52376 .22278 L p F P
0 g
s
.522 .651 .916 r
.52376 .22278 m .52365 .21604 L .56874 .23113 L p F P
0 g
s
.633 .712 .904 r
.471 .18988 m .47369 .19732 L .42708 .20507 L p F P
0 g
s
.633 .712 .904 r
.42708 .20507 m .42202 .19788 L .471 .18988 L p F P
0 g
s
.687 .736 .889 r
.40664 .17602 m .41181 .18336 L .36446 .20696 L p F P
0 g
s
.687 .736 .889 r
.36446 .20696 m .35722 .20083 L .40664 .17602 L p F P
0 g
s
.312 .463 .851 r
.64352 .29141 m .65072 .29124 L .68329 .33305 L p F P
0 g
s
.371 .532 .886 r
.65072 .29124 m .64352 .29141 L .60691 .25972 L p F P
0 g
s
.253 .327 .747 r
.75888 .4667 m .7469 .45328 L .72948 .39579 L p F P
0 g
s
.267 .342 .755 r
.71863 .38746 m .72948 .39579 L .7469 .45328 L p F P
0 g
s
.746 .757 .861 r
.32779 .17601 m .33522 .18227 L .28969 .22812 L p F P
0 g
s
.746 .757 .861 r
.28969 .22812 m .28055 .22417 L .32779 .17601 L p F P
0 g
s
.447 .599 .909 r
.61186 .25664 m .60691 .25972 L .56627 .23644 L p F P
0 g
s
.447 .599 .909 r
.56627 .23644 m .56874 .23113 L .61186 .25664 L p F P
0 g
s
.268 .39 .802 r
.68329 .33305 m .69252 .33678 L .71863 .38746 L p F P
0 g
s
.292 .447 .844 r
.69252 .33678 m .68329 .33305 L .65072 .29124 L p F P
0 g
s
.249 .373 .794 r
.72948 .39579 m .71863 .38746 L .69252 .33678 L p F P
0 g
s
.371 .532 .886 r
.60691 .25972 m .61186 .25664 L .65072 .29124 L p F P
0 g
s
.342 .309 .677 r
.79881 .6589 m .78601 .63334 L .79116 .56692 L p F P
0 g
s
.348 .317 .682 r
.77836 .547 m .79116 .56692 L .78601 .63334 L p F P
0 g
s
.461 .351 .643 r
.78371 .88128 m .77249 .84364 L .80523 .78528 L p F P
0 g
s
.463 .355 .646 r
.79277 .7527 m .80523 .78528 L .77249 .84364 L p F P
0 g
s
.576 .683 .914 r
.52343 .20257 m .52354 .2093 L .47635 .20472 L p F P
0 g
s
.576 .683 .914 r
.47635 .20472 m .47369 .19732 L .52343 .20257 L p F P
0 g
s
.631 .712 .905 r
.46829 .18241 m .471 .18988 L .42202 .19788 L p F P
0 g
s
.631 .712 .905 r
.42202 .19788 m .41693 .19065 L .46829 .18241 L p F P
0 g
s
.687 .737 .888 r
.40144 .16863 m .40664 .17602 L .35722 .20083 L p F P
0 g
s
.687 .737 .888 r
.35722 .20083 m .34993 .19468 L .40144 .16863 L p F P
0 g
s
.513 .646 .916 r
.57122 .2259 m .56874 .23113 L .52365 .21604 L p F P
0 g
s
.513 .646 .916 r
.52365 .21604 m .52354 .2093 L .57122 .2259 L p F P
0 g
s
.282 .301 .703 r
.79116 .56692 m .77836 .547 L .77108 .48102 L p F P
0 g
s
.292 .311 .71 r
.75888 .4667 m .77108 .48102 L .77836 .547 L p F P
0 g
s
.292 .447 .844 r
.65072 .29124 m .65802 .29139 L .69252 .33678 L p F P
0 g
s
.352 .519 .882 r
.65802 .29139 m .65072 .29124 L .61186 .25664 L p F P
0 g
s
.401 .325 .655 r
.80523 .78528 m .79277 .7527 L .81189 .68586 L p F P
0 g
s
.405 .33 .659 r
.79881 .6589 m .81189 .68586 L .79277 .7527 L p F P
0 g
s
.432 .59 .907 r
.61686 .25375 m .61186 .25664 L .56874 .23113 L p F P
0 g
s
.432 .59 .907 r
.56874 .23113 m .57122 .2259 L .61686 .25375 L p F P
0 g
s
.688 .737 .888 r
.3962 .16118 m .40144 .16863 L .34993 .19468 L p F P
0 g
s
.688 .737 .888 r
.34993 .19468 m .3426 .18849 L .3962 .16118 L p F P
0 g
s
.629 .711 .905 r
.46556 .17489 m .46829 .18241 L .41693 .19065 L p F P
0 g
s
.629 .711 .905 r
.41693 .19065 m .41181 .18336 L .46556 .17489 L p F P
0 g
s
.515 .379 .634 r
.78371 .88128 m .79521 .92084 L .74762 .96879 L p F P
0 g
s
.57 .681 .915 r
.52332 .19584 m .52343 .20257 L .47369 .19732 L p F P
0 g
s
.57 .681 .915 r
.47369 .19732 m .471 .18988 L .52332 .19584 L p F P
0 g
s
.352 .519 .882 r
.61186 .25664 m .61686 .25375 L .65802 .29139 L p F P
0 g
s
.239 .314 .739 r
.77108 .48102 m .75888 .4667 L .7405 .4048 L p F P
0 g
s
.253 .327 .747 r
.72948 .39579 m .7405 .4048 L .75888 .4667 L p F P
0 g
s
.249 .373 .794 r
.69252 .33678 m .70188 .341 L .72948 .39579 L p F P
0 g
s
.271 .43 .837 r
.70188 .341 m .69252 .33678 L .65802 .29139 L p F P
0 g
s
.231 .357 .785 r
.7405 .4048 m .72948 .39579 L .70188 .341 L p F P
0 g
s
.503 .641 .917 r
.57374 .22075 m .57122 .2259 L .52354 .2093 L p F P
0 g
s
.503 .641 .917 r
.52354 .2093 m .52343 .20257 L .57374 .22075 L p F P
0 g
s
.337 .302 .672 r
.81189 .68586 m .79881 .6589 L .80421 .58801 L p F P
0 g
s
.342 .309 .677 r
.79116 .56692 m .80421 .58801 L .79881 .6589 L p F P
0 g
s
.688 .737 .888 r
.39093 .15369 m .3962 .16118 L .3426 .18849 L p F P
0 g
s
.688 .737 .888 r
.3426 .18849 m .33522 .18227 L .39093 .15369 L p F P
0 g
s
.627 .71 .906 r
.4628 .16733 m .46556 .17489 L .41181 .18336 L p F P
0 g
s
.627 .71 .906 r
.41181 .18336 m .40664 .17602 L .4628 .16733 L p F P
0 g
s
.46 .348 .64 r
.79521 .92084 m .78371 .88128 L .81799 .81955 L p F P
0 g
s
.461 .351 .643 r
.80523 .78528 m .81799 .81955 L .78371 .88128 L p F P
0 g
s
.565 .678 .915 r
.5232 .18911 m .52332 .19584 L .471 .18988 L p F P
0 g
s
.565 .678 .915 r
.471 .18988 m .46829 .18241 L .5232 .18911 L p F P
0 g
s
.271 .43 .837 r
.65802 .29139 m .66541 .29186 L .70188 .341 L p F P
0 g
s
.333 .505 .878 r
.66541 .29186 m .65802 .29139 L .61686 .25375 L p F P
0 g
s
.418 .58 .906 r
.62192 .25104 m .61686 .25375 L .57122 .2259 L p F P
0 g
s
.418 .58 .906 r
.57122 .2259 m .57374 .22075 L .62192 .25104 L p F P
0 g
s
.274 .291 .697 r
.80421 .58801 m .79116 .56692 L .78349 .49626 L p F P
0 g
s
.282 .301 .703 r
.77108 .48102 m .78349 .49626 L .79116 .56692 L p F P
0 g
s
.333 .505 .878 r
.61686 .25375 m .62192 .25104 L .66541 .29186 L p F P
0 g
s
.493 .635 .917 r
.57628 .21568 m .57374 .22075 L .52343 .20257 L p F P
0 g
s
.493 .635 .917 r
.52343 .20257 m .52332 .19584 L .57628 .21568 L p F P
0 g
s
.689 .738 .888 r
.38562 .14614 m .39093 .15369 L .33522 .18227 L p F P
0 g
s
.689 .738 .888 r
.33522 .18227 m .32779 .17601 L .38562 .14614 L p F P
0 g
s
.231 .357 .785 r
.70188 .341 m .71138 .34572 L .7405 .4048 L p F P
0 g
s
.251 .414 .83 r
.71138 .34572 m .70188 .341 L .66541 .29186 L p F P
0 g
s
.226 .3 .731 r
.78349 .49626 m .77108 .48102 L .7517 .41451 L p F P
0 g
s
.239 .314 .739 r
.7405 .4048 m .7517 .41451 L .77108 .48102 L p F P
0 g
s
.625 .709 .906 r
.46003 .15973 m .4628 .16733 L .40664 .17602 L p F P
0 g
s
.625 .709 .906 r
.40664 .17602 m .40144 .16863 L .46003 .15973 L p F P
0 g
s
.398 .32 .651 r
.81799 .81955 m .80523 .78528 L .82526 .71428 L p F P
0 g
s
.401 .325 .655 r
.81189 .68586 m .82526 .71428 L .80523 .78528 L p F P
0 g
s
.214 .341 .777 r
.7517 .41451 m .7405 .4048 L .71138 .34572 L p F P
0 g
s
.559 .675 .916 r
.52309 .18239 m .5232 .18911 L .46829 .18241 L p F P
0 g
s
.559 .675 .916 r
.46829 .18241 m .46556 .17489 L .52309 .18239 L p F P
0 g
s
.403 .57 .904 r
.62705 .24853 m .62192 .25104 L .57374 .22075 L p F P
0 g
s
.403 .57 .904 r
.57374 .22075 m .57628 .21568 L .62705 .24853 L p F P
0 g
s
.251 .414 .83 r
.66541 .29186 m .6729 .29267 L .71138 .34572 L p F P
0 g
s
.314 .491 .874 r
.6729 .29267 m .66541 .29186 L .62192 .25104 L p F P
0 g
s
.483 .629 .917 r
.57884 .2107 m .57628 .21568 L .52332 .19584 L p F P
0 g
s
.483 .629 .917 r
.52332 .19584 m .5232 .18911 L .57884 .2107 L p F P
0 g
s
.332 .296 .667 r
.82526 .71428 m .81189 .68586 L .81755 .61029 L p F P
0 g
s
.337 .302 .672 r
.80421 .58801 m .81755 .61029 L .81189 .68586 L p F P
0 g
s
.623 .708 .907 r
.45722 .15209 m .46003 .15973 L .40144 .16863 L p F P
0 g
s
.623 .708 .907 r
.40144 .16863 m .3962 .16118 L .45722 .15209 L p F P
0 g
s
.314 .491 .874 r
.62192 .25104 m .62705 .24853 L .6729 .29267 L p F P
0 g
s
.554 .672 .917 r
.52297 .17567 m .52309 .18239 L .46556 .17489 L p F P
0 g
s
.554 .672 .917 r
.46556 .17489 m .4628 .16733 L .52297 .17567 L p F P
0 g
s
.46 .348 .64 r
.81799 .81955 m .83107 .8556 L .79521 .92084 L p F P
0 g
s
.214 .341 .777 r
.71138 .34572 m .72102 .35096 L .7517 .41451 L p F P
0 g
s
.231 .398 .823 r
.72102 .35096 m .71138 .34572 L .6729 .29267 L p F P
0 g
s
.266 .282 .691 r
.81755 .61029 m .80421 .58801 L .79615 .51246 L p F P
0 g
s
.274 .291 .697 r
.78349 .49626 m .79615 .51246 L .80421 .58801 L p F P
0 g
s
.214 .288 .724 r
.79615 .51246 m .78349 .49626 L .7631 .42493 L p F P
0 g
s
.226 .3 .731 r
.7517 .41451 m .7631 .42493 L .78349 .49626 L p F P
0 g
s
.197 .325 .769 r
.7631 .42493 m .7517 .41451 L .72102 .35096 L p F P
0 g
s
.621 .708 .907 r
.4544 .1444 m .45722 .15209 L .3962 .16118 L p F P
0 g
s
.621 .708 .907 r
.3962 .16118 m .39093 .15369 L .4544 .1444 L p F P
0 g
s
.387 .56 .902 r
.63224 .24621 m .62705 .24853 L .57628 .21568 L p F P
0 g
s
.387 .56 .902 r
.57628 .21568 m .57884 .2107 L .63224 .24621 L p F P
0 g
s
.473 .623 .917 r
.58144 .20579 m .57884 .2107 L .5232 .18911 L p F P
0 g
s
.473 .623 .917 r
.5232 .18911 m .52309 .18239 L .58144 .20579 L p F P
0 g
s
.231 .398 .823 r
.6729 .29267 m .68049 .29382 L .72102 .35096 L p F P
0 g
s
.295 .477 .869 r
.68049 .29382 m .6729 .29267 L .62705 .24853 L p F P
0 g
s
.396 .315 .648 r
.83107 .8556 m .81799 .81955 L .83895 .74421 L p F P
0 g
s
.398 .32 .651 r
.82526 .71428 m .83895 .74421 L .81799 .81955 L p F P
0 g
s
.295 .477 .869 r
.62705 .24853 m .63224 .24621 L .68049 .29382 L p F P
0 g
s
.548 .67 .917 r
.52286 .16895 m .52297 .17567 L .4628 .16733 L p F P
0 g
s
.548 .67 .917 r
.4628 .16733 m .46003 .15973 L .52286 .16895 L p F P
0 g
s
.619 .707 .908 r
.45155 .13667 m .4544 .1444 L .39093 .15369 L p F P
0 g
s
.619 .707 .908 r
.39093 .15369 m .38562 .14614 L .45155 .13667 L p F P
0 g
s
.327 .289 .663 r
.83895 .74421 m .82526 .71428 L .83117 .63382 L p F P
0 g
s
.332 .296 .667 r
.81755 .61029 m .83117 .63382 L .82526 .71428 L p F P
0 g
s
.197 .325 .769 r
.72102 .35096 m .73081 .35671 L .7631 .42493 L p F P
0 g
s
.212 .382 .815 r
.73081 .35671 m .72102 .35096 L .68049 .29382 L p F P
0 g
s
.372 .55 .9 r
.63749 .24408 m .63224 .24621 L .57884 .2107 L p F P
0 g
s
.372 .55 .9 r
.57884 .2107 m .58144 .20579 L .63749 .24408 L p F P
0 g
s
.463 .617 .916 r
.58407 .20097 m .58144 .20579 L .52309 .18239 L p F P
0 g
s
.463 .617 .916 r
.52309 .18239 m .52297 .17567 L .58407 .20097 L p F P
0 g
s
.258 .273 .685 r
.83117 .63382 m .81755 .61029 L .80905 .52963 L p F P
0 g
s
.266 .282 .691 r
.79615 .51246 m .80905 .52963 L .81755 .61029 L p F P
0 g
s
.543 .667 .918 r
.52274 .16223 m .52286 .16895 L .46003 .15973 L p F P
0 g
s
.543 .667 .918 r
.46003 .15973 m .45722 .15209 L .52274 .16223 L p F P
0 g
s
.214 .288 .724 r
.7631 .42493 m .7747 .4361 L .79615 .51246 L p F P
0 g
s
.181 .31 .761 r
.7747 .4361 m .7631 .42493 L .73081 .35671 L p F P
0 g
s
.202 .276 .717 r
.80905 .52963 m .79615 .51246 L .7747 .4361 L p F P
0 g
s
.212 .382 .815 r
.68049 .29382 m .68819 .29531 L .73081 .35671 L p F P
0 g
s
.276 .463 .863 r
.68819 .29531 m .68049 .29382 L .63224 .24621 L p F P
0 g
s
.276 .463 .863 r
.63224 .24621 m .63749 .24408 L .68819 .29531 L p F P
0 g
s
.452 .611 .916 r
.58672 .19623 m .58407 .20097 L .52297 .17567 L p F P
0 g
s
.452 .611 .916 r
.52297 .17567 m .52286 .16895 L .58672 .19623 L p F P
0 g
s
.357 .54 .897 r
.64281 .24216 m .63749 .24408 L .58144 .20579 L p F P
0 g
s
.357 .54 .897 r
.58144 .20579 m .58407 .20097 L .64281 .24216 L p F P
0 g
s
.396 .315 .648 r
.83895 .74421 m .85298 .77573 L .83107 .8556 L p F P
0 g
s
.537 .664 .918 r
.52262 .15551 m .52274 .16223 L .45722 .15209 L p F P
0 g
s
.537 .664 .918 r
.45722 .15209 m .4544 .1444 L .52262 .15551 L p F P
0 g
s
.181 .31 .761 r
.73081 .35671 m .74076 .363 L .7747 .4361 L p F P
0 g
s
.193 .366 .808 r
.74076 .363 m .73081 .35671 L .68819 .29531 L p F P
0 g
s
.323 .283 .659 r
.85298 .77573 m .83895 .74421 L .8451 .65866 L p F P
0 g
s
.327 .289 .663 r
.83117 .63382 m .8451 .65866 L .83895 .74421 L p F P
0 g
s
.257 .449 .858 r
.69601 .29715 m .68819 .29531 L .63749 .24408 L p F P
0 g
s
.257 .449 .858 r
.63749 .24408 m .64281 .24216 L .69601 .29715 L p F P
0 g
s
.193 .366 .808 r
.68819 .29531 m .69601 .29715 L .74076 .363 L p F P
0 g
s
.202 .276 .717 r
.7747 .4361 m .78651 .44803 L .80905 .52963 L p F P
0 g
s
.165 .296 .753 r
.78651 .44803 m .7747 .4361 L .74076 .363 L p F P
0 g
s
.251 .264 .679 r
.8451 .65866 m .83117 .63382 L .82222 .54783 L p F P
0 g
s
.258 .273 .685 r
.80905 .52963 m .82222 .54783 L .83117 .63382 L p F P
0 g
s
.191 .264 .71 r
.82222 .54783 m .80905 .52963 L .78651 .44803 L p F P
0 g
s
.442 .605 .916 r
.58941 .19157 m .58672 .19623 L .52286 .16895 L p F P
0 g
s
.442 .605 .916 r
.52286 .16895 m .52274 .16223 L .58941 .19157 L p F P
0 g
s
.531 .661 .919 r
.5225 .14879 m .52262 .15551 L .4544 .1444 L p F P
0 g
s
.531 .661 .919 r
.4544 .1444 m .45155 .13667 L .5225 .14879 L p F P
0 g
s
.341 .529 .895 r
.6482 .24043 m .64281 .24216 L .58407 .20097 L p F P
0 g
s
.341 .529 .895 r
.58407 .20097 m .58672 .19623 L .6482 .24043 L p F P
0 g
s
.165 .296 .753 r
.74076 .363 m .75088 .36984 L .78651 .44803 L p F P
0 g
s
.174 .35 .8 r
.75088 .36984 m .74076 .363 L .69601 .29715 L p F P
0 g
s
.238 .434 .852 r
.70394 .29935 m .69601 .29715 L .64281 .24216 L p F P
0 g
s
.238 .434 .852 r
.64281 .24216 m .6482 .24043 L .70394 .29935 L p F P
0 g
s
.431 .598 .915 r
.59213 .18699 m .58941 .19157 L .52274 .16223 L p F P
0 g
s
.431 .598 .915 r
.52274 .16223 m .52262 .15551 L .59213 .18699 L p F P
0 g
s
.174 .35 .8 r
.69601 .29715 m .70394 .29935 L .75088 .36984 L p F P
0 g
s
.191 .264 .71 r
.78651 .44803 m .79855 .46075 L .82222 .54783 L p F P
0 g
s
.15 .281 .745 r
.79855 .46075 m .78651 .44803 L .75088 .36984 L p F P
0 g
s
.325 .519 .892 r
.65367 .23891 m .6482 .24043 L .58672 .19623 L p F P
0 g
s
.325 .519 .892 r
.58672 .19623 m .58941 .19157 L .65367 .23891 L p F P
0 g
s
.323 .283 .659 r
.8451 .65866 m .85936 .68484 L .85298 .77573 L p F P
0 g
s
.251 .264 .679 r
.82222 .54783 m .83568 .56709 L .8451 .65866 L p F P
0 g
s
.181 .253 .703 r
.83568 .56709 m .82222 .54783 L .79855 .46075 L p F P
0 g
s
.244 .256 .674 r
.85936 .68484 m .8451 .65866 L .83568 .56709 L p F P
0 g
s
.42 .592 .914 r
.59488 .1825 m .59213 .18699 L .52262 .15551 L p F P
0 g
s
.42 .592 .914 r
.52262 .15551 m .5225 .14879 L .59488 .1825 L p F P
0 g
s
.15 .281 .745 r
.75088 .36984 m .76118 .37725 L .79855 .46075 L p F P
0 g
s
.156 .334 .792 r
.76118 .37725 m .75088 .36984 L .70394 .29935 L p F P
0 g
s
.219 .42 .846 r
.712 .30192 m .70394 .29935 L .6482 .24043 L p F P
0 g
s
.219 .42 .846 r
.6482 .24043 m .65367 .23891 L .712 .30192 L p F P
0 g
s
.156 .334 .792 r
.70394 .29935 m .712 .30192 L .76118 .37725 L p F P
0 g
s
.309 .508 .888 r
.65921 .2376 m .65367 .23891 L .58941 .19157 L p F P
0 g
s
.309 .508 .888 r
.58941 .19157 m .59213 .18699 L .65921 .2376 L p F P
0 g
s
.135 .268 .736 r
.81083 .47427 m .79855 .46075 L .76118 .37725 L p F P
0 g
s
.181 .253 .703 r
.79855 .46075 m .81083 .47427 L .83568 .56709 L p F P
0 g
s
.244 .256 .674 r
.83568 .56709 m .84943 .58744 L .85936 .68484 L p F P
0 g
s
.171 .242 .696 r
.84943 .58744 m .83568 .56709 L .81083 .47427 L p F P
0 g
s
.2 .406 .839 r
.72018 .30487 m .712 .30192 L .65367 .23891 L p F P
0 g
s
.2 .406 .839 r
.65367 .23891 m .65921 .2376 L .72018 .30487 L p F P
0 g
s
.294 .497 .885 r
.66483 .2365 m .65921 .2376 L .59213 .18699 L p F P
0 g
s
.294 .497 .885 r
.59213 .18699 m .59488 .1825 L .66483 .2365 L p F P
0 g
s
.135 .268 .736 r
.76118 .37725 m .77166 .38523 L .81083 .47427 L p F P
0 g
s
.138 .319 .784 r
.77166 .38523 m .76118 .37725 L .712 .30192 L p F P
0 g
s
.138 .319 .784 r
.712 .30192 m .72018 .30487 L .77166 .38523 L p F P
0 g
s
.121 .254 .729 r
.82336 .48864 m .81083 .47427 L .77166 .38523 L p F P
0 g
s
.171 .242 .696 r
.81083 .47427 m .82336 .48864 L .84943 .58744 L p F P
0 g
s
.182 .391 .833 r
.7285 .3082 m .72018 .30487 L .65921 .2376 L p F P
0 g
s
.182 .391 .833 r
.65921 .2376 m .66483 .2365 L .7285 .3082 L p F P
0 g
s
.121 .254 .729 r
.77166 .38523 m .78233 .39381 L .82336 .48864 L p F P
0 g
s
.12 .304 .775 r
.78233 .39381 m .77166 .38523 L .72018 .30487 L p F P
0 g
s
.12 .304 .775 r
.72018 .30487 m .7285 .3082 L .78233 .39381 L p F P
0 g
s
.25 Mabswid
.67212 0 m
.92713 .41525 L
s
.92713 .41525 m
1 .94931 L
s
1 .94931 m
.70601 .5864 L
s
.70601 .5864 m
.67212 0 L
s
.08846 .24538 m
0 .80452 L
s
0 .80452 m
.70601 .5864 L
s
.70601 .5864 m
.67212 0 L
s
.67212 0 m
.08846 .24538 L
s
.08846 .24538 m
.67212 0 L
s
.09942 .24078 m
.1045 .24601 L
s
[(-1)] .08924 .23032 .97256 1 Mshowa
.22751 .18692 m
.23234 .19239 L
s
[(-0.5)] .21784 .176 .88513 1 Mshowa
.36266 .13011 m
.3672 .13581 L
s
[(0)] .35356 .1187 .7977 1 Mshowa
.50545 .07007 m
.50968 .07602 L
s
[(0.5)] .497 .05818 .71026 1 Mshowa
.65657 .00654 m
.66042 .01273 L
s
[(1)] .64886 -0.00584 .62283 1 Mshowa
.125 Mabswid
.1245 .23023 m
.12752 .2334 L
s
.14984 .21958 m
.15284 .22277 L
s
.17546 .20881 m
.17842 .21203 L
s
.20134 .19792 m
.20428 .20117 L
s
.25396 .17581 m
.25682 .17911 L
s
.28069 .16457 m
.28352 .1679 L
s
.30771 .1532 m
.31051 .15657 L
s
.33503 .14172 m
.3378 .14511 L
s
.39058 .11836 m
.39327 .12182 L
s
.41882 .10649 m
.42147 .10997 L
s
.44737 .09449 m
.44999 .098 L
s
.47625 .08235 m
.47882 .08589 L
s
.53499 .05765 m
.53748 .06125 L
s
.56486 .04509 m
.56731 .04872 L
s
.59508 .03239 m
.59748 .03605 L
s
.62564 .01954 m
.628 .02322 L
s
.25 Mabswid
0 .80452 m
.40066 1.08661 L
s
.01144 .81257 m
.01255 .80536 L
s
[(-1)] .00921 .82699 .1544 -1 Mshowa
.12243 .89072 m
.12328 .88347 L
s
[(-0.5)] .12071 .9052 .11835 -1 Mshowa
.22198 .9608 m
.22261 .95354 L
s
[(0)] .22071 .97534 .08739 -1 Mshowa
.31177 1.02403 m
.31221 1.01674 L
s
[(0.5)] .31089 1.03859 .06051 -1 Mshowa
.39317 1.08134 m
.39344 1.07405 L
s
[(1)] .39264 1.09592 .03695 -1 Mshowa
.125 Mabswid
.03464 .82891 m
.03528 .82458 L
s
.05733 .84488 m
.05793 .84055 L
s
.07951 .8605 m
.08008 .85616 L
s
.1012 .87577 m
.10175 .87143 L
s
.14319 .90534 m
.14368 .90099 L
s
.16352 .91965 m
.16397 .91529 L
s
.18341 .93365 m
.18384 .9293 L
s
.20289 .94737 m
.2033 .94301 L
s
.24067 .97396 m
.24102 .9696 L
s
.25898 .98686 m
.25931 .9825 L
s
.27693 .9995 m
.27724 .99513 L
s
.29452 1.01188 m
.29481 1.00751 L
s
.32868 1.03593 m
.32892 1.03156 L
s
.34527 1.04761 m
.34549 1.04324 L
s
.36154 1.05907 m
.36174 1.0547 L
s
.37751 1.07031 m
.37769 1.06594 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.38.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.38.1"]
}, Open  ]],

Cell[TextData[{
 "You can use any option that can be given for ",
 StyleBox["Graphics3D", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.38.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
CylindricalPlot3D[ (1 + Sin[phi]) r^2,
  {r, 0, 1}, {phi, 0, 2Pi},
     Boxed -> False, Axes -> False,
       ViewPoint ->  {1.5, -0.5, .2}]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.38.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.17394 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.240596 1.28645 -5.49691e-17 1.28645 [
[ 0 0 0 0 ]
[ 1 1.17394 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.17394 L
0 1.17394 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.656 .619 .801 r
.34733 .68421 m .34569 .70506 L .2897 .64535 L p F P
0 g
s
.604 .564 .782 r
.34569 .70506 m .34733 .68421 L .40322 .73759 L p F P
0 g
s
.604 .564 .782 r
.40322 .73759 m .40325 .76201 L .34569 .70506 L p F P
0 g
s
.542 .505 .764 r
.40325 .76201 m .40322 .73759 L .45973 .78725 L p F P
0 g
s
.542 .505 .764 r
.45973 .78725 m .46149 .81531 L .40325 .76201 L p F P
0 g
s
.656 .619 .801 r
.2897 .64535 m .29298 .628 L .34733 .68421 L p F P
0 g
s
.656 .623 .805 r
.34899 .66383 m .34733 .68421 L .29298 .628 L p F P
0 g
s
.604 .567 .786 r
.34733 .68421 m .34899 .66383 L .4032 .71375 L p F P
0 g
s
.604 .567 .786 r
.4032 .71375 m .40322 .73759 L .34733 .68421 L p F P
0 g
s
.541 .508 .768 r
.40322 .73759 m .4032 .71375 L .45795 .7599 L p F P
0 g
s
.541 .508 .768 r
.45795 .7599 m .45973 .78725 L .40322 .73759 L p F P
0 g
s
.698 .673 .822 r
.29298 .628 m .2897 .64535 L .23628 .58381 L p F P
0 g
s
.656 .623 .805 r
.29298 .628 m .29629 .61103 L .34899 .66383 L p F P
0 g
s
.655 .626 .809 r
.35067 .64394 m .34899 .66383 L .29629 .61103 L p F P
0 g
s
.603 .57 .79 r
.34899 .66383 m .35067 .64394 L .40317 .6905 L p F P
0 g
s
.603 .57 .79 r
.40317 .6905 m .4032 .71375 L .34899 .66383 L p F P
0 g
s
.541 .511 .772 r
.4032 .71375 m .40317 .6905 L .45617 .73327 L p F P
0 g
s
.541 .511 .772 r
.45617 .73327 m .45795 .7599 L .4032 .71375 L p F P
0 g
s
.468 .441 .745 r
.46149 .81531 m .45973 .78725 L .51587 .83218 L p F P
0 g
s
.468 .441 .745 r
.51587 .83218 m .51946 .86394 L .46149 .81531 L p F P
0 g
s
.698 .673 .822 r
.23628 .58381 m .24117 .56987 L .29298 .628 L p F P
0 g
s
.696 .676 .827 r
.29629 .61103 m .29298 .628 L .24117 .56987 L p F P
0 g
s
.467 .444 .749 r
.45973 .78725 m .45795 .7599 L .51227 .8013 L p F P
0 g
s
.467 .444 .749 r
.51227 .8013 m .51587 .83218 L .45973 .78725 L p F P
0 g
s
.655 .626 .809 r
.29629 .61103 m .29964 .59444 L .35067 .64394 L p F P
0 g
s
.654 .63 .814 r
.35236 .62452 m .35067 .64394 L .29964 .59444 L p F P
0 g
s
.603 .574 .795 r
.35067 .64394 m .35236 .62452 L .40314 .66785 L p F P
0 g
s
.603 .574 .795 r
.40314 .66785 m .40317 .6905 L .35067 .64394 L p F P
0 g
s
.54 .515 .776 r
.40317 .6905 m .40314 .66785 L .45437 .70736 L p F P
0 g
s
.54 .515 .776 r
.45437 .70736 m .45617 .73327 L .40317 .6905 L p F P
0 g
s
.696 .676 .827 r
.24117 .56987 m .24611 .55622 L .29629 .61103 L p F P
0 g
s
.695 .68 .831 r
.29964 .59444 m .29629 .61103 L .24611 .55622 L p F P
0 g
s
.467 .448 .753 r
.45795 .7599 m .45617 .73327 L .50866 .7713 L p F P
0 g
s
.467 .448 .753 r
.50866 .7713 m .51227 .8013 L .45795 .7599 L p F P
0 g
s
.654 .63 .814 r
.29964 .59444 m .30301 .57823 L .35236 .62452 L p F P
0 g
s
.653 .634 .819 r
.35407 .60559 m .35236 .62452 L .30301 .57823 L p F P
0 g
s
.602 .578 .799 r
.35236 .62452 m .35407 .60559 L .40311 .64578 L p F P
0 g
s
.602 .578 .799 r
.40311 .64578 m .40314 .66785 L .35236 .62452 L p F P
0 g
s
.54 .519 .781 r
.40314 .66785 m .40311 .64578 L .45256 .68218 L p F P
0 g
s
.54 .519 .781 r
.45256 .68218 m .45437 .70736 L .40314 .66785 L p F P
0 g
s
.695 .68 .831 r
.24611 .55622 m .2511 .54287 L .29964 .59444 L p F P
0 g
s
.694 .684 .836 r
.30301 .57823 m .29964 .59444 L .2511 .54287 L p F P
0 g
s
.467 .451 .757 r
.45617 .73327 m .45437 .70736 L .50502 .74217 L p F P
0 g
s
.467 .451 .757 r
.50502 .74217 m .50866 .7713 L .45617 .73327 L p F P
0 g
s
.601 .582 .804 r
.40309 .62432 m .40311 .64578 L .35407 .60559 L p F P
0 g
s
.539 .523 .786 r
.40311 .64578 m .40309 .62432 L .45073 .65773 L p F P
0 g
s
.539 .523 .786 r
.45073 .65773 m .45256 .68218 L .40311 .64578 L p F P
0 g
s
.653 .634 .819 r
.30301 .57823 m .30642 .56241 L .35407 .60559 L p F P
0 g
s
.652 .639 .824 r
.35579 .58715 m .35407 .60559 L .30642 .56241 L p F P
0 g
s
.601 .582 .804 r
.35407 .60559 m .35579 .58715 L .40309 .62432 L p F P
0 g
s
.726 .725 .849 r
.24117 .56987 m .23628 .58381 L .18654 .52145 L p F P
0 g
s
.694 .684 .836 r
.2511 .54287 m .25613 .52983 L .30301 .57823 L p F P
0 g
s
.692 .688 .842 r
.30642 .56241 m .30301 .57823 L .25613 .52983 L p F P
0 g
s
.466 .455 .762 r
.45437 .70736 m .45256 .68218 L .50137 .71391 L p F P
0 g
s
.466 .455 .762 r
.50137 .71391 m .50502 .74217 L .45437 .70736 L p F P
0 g
s
.381 .371 .723 r
.51946 .86394 m .51587 .83218 L .57053 .87121 L p F P
0 g
s
.381 .371 .723 r
.57053 .87121 m .57603 .90665 L .51946 .86394 L p F P
0 g
s
.726 .725 .849 r
.18654 .52145 m .19305 .51081 L .24117 .56987 L p F P
0 g
s
.725 .728 .853 r
.24611 .55622 m .24117 .56987 L .19305 .51081 L p F P
0 g
s
.6 .587 .81 r
.40306 .60347 m .40309 .62432 L .35579 .58715 L p F P
0 g
s
.539 .527 .791 r
.40309 .62432 m .40306 .60347 L .44889 .63401 L p F P
0 g
s
.539 .527 .791 r
.44889 .63401 m .45073 .65773 L .40309 .62432 L p F P
0 g
s
.652 .639 .824 r
.30642 .56241 m .30986 .54699 L .35579 .58715 L p F P
0 g
s
.651 .643 .83 r
.35754 .5692 m .35579 .58715 L .30986 .54699 L p F P
0 g
s
.6 .587 .81 r
.35579 .58715 m .35754 .5692 L .40306 .60347 L p F P
0 g
s
.466 .459 .766 r
.45256 .68218 m .45073 .65773 L .49769 .68654 L p F P
0 g
s
.466 .459 .766 r
.49769 .68654 m .50137 .71391 L .45256 .68218 L p F P
0 g
s
.381 .374 .727 r
.51587 .83218 m .51227 .8013 L .56501 .83683 L p F P
0 g
s
.381 .374 .727 r
.56501 .83683 m .57053 .87121 L .51587 .83218 L p F P
0 g
s
.692 .688 .842 r
.25613 .52983 m .2612 .51709 L .30642 .56241 L p F P
0 g
s
.691 .693 .847 r
.30986 .54699 m .30642 .56241 L .2612 .51709 L p F P
0 g
s
.725 .728 .853 r
.19305 .51081 m .19961 .5004 L .24611 .55622 L p F P
0 g
s
.723 .732 .858 r
.2511 .54287 m .24611 .55622 L .19961 .5004 L p F P
0 g
s
.6 .592 .815 r
.40303 .58322 m .40306 .60347 L .35754 .5692 L p F P
0 g
s
.539 .532 .796 r
.40306 .60347 m .40303 .58322 L .44703 .61102 L p F P
0 g
s
.539 .532 .796 r
.44703 .61102 m .44889 .63401 L .40306 .60347 L p F P
0 g
s
.651 .643 .83 r
.30986 .54699 m .31334 .53197 L .35754 .5692 L p F P
0 g
s
.649 .648 .836 r
.3593 .55175 m .35754 .5692 L .31334 .53197 L p F P
0 g
s
.6 .592 .815 r
.35754 .5692 m .3593 .55175 L .40303 .58322 L p F P
0 g
s
.38 .377 .731 r
.51227 .8013 m .50866 .7713 L .55949 .8035 L p F P
0 g
s
.38 .377 .731 r
.55949 .8035 m .56501 .83683 L .51227 .8013 L p F P
0 g
s
.466 .463 .771 r
.45073 .65773 m .44889 .63401 L .49399 .66004 L p F P
0 g
s
.466 .463 .771 r
.49399 .66004 m .49769 .68654 L .45073 .65773 L p F P
0 g
s
.691 .693 .847 r
.2612 .51709 m .26633 .50466 L .30986 .54699 L p F P
0 g
s
.689 .697 .853 r
.31334 .53197 m .30986 .54699 L .26633 .50466 L p F P
0 g
s
.723 .732 .858 r
.19961 .5004 m .20622 .49021 L .2511 .54287 L p F P
0 g
s
.72 .736 .863 r
.25613 .52983 m .2511 .54287 L .20622 .49021 L p F P
0 g
s
.38 .381 .735 r
.50866 .7713 m .50502 .74217 L .55394 .77123 L p F P
0 g
s
.38 .381 .735 r
.55394 .77123 m .55949 .8035 L .50866 .7713 L p F P
0 g
s
.599 .597 .821 r
.403 .56359 m .40303 .58322 L .3593 .55175 L p F P
0 g
s
.538 .538 .802 r
.40303 .58322 m .403 .56359 L .44515 .58878 L p F P
0 g
s
.538 .538 .802 r
.44515 .58878 m .44703 .61102 L .40303 .58322 L p F P
0 g
s
.649 .648 .836 r
.31334 .53197 m .31685 .51735 L .3593 .55175 L p F P
0 g
s
.648 .653 .842 r
.36108 .53481 m .3593 .55175 L .31685 .51735 L p F P
0 g
s
.599 .597 .821 r
.3593 .55175 m .36108 .53481 L .403 .56359 L p F P
0 g
s
.465 .468 .777 r
.44889 .63401 m .44703 .61102 L .49026 .63442 L p F P
0 g
s
.465 .468 .777 r
.49026 .63442 m .49399 .66004 L .44889 .63401 L p F P
0 g
s
.689 .697 .853 r
.26633 .50466 m .27151 .49255 L .31334 .53197 L p F P
0 g
s
.687 .702 .859 r
.31685 .51735 m .31334 .53197 L .27151 .49255 L p F P
0 g
s
.72 .736 .863 r
.20622 .49021 m .21288 .48026 L .25613 .52983 L p F P
0 g
s
.718 .74 .869 r
.2612 .51709 m .25613 .52983 L .21288 .48026 L p F P
0 g
s
.379 .384 .739 r
.50502 .74217 m .50137 .71391 L .54839 .74001 L p F P
0 g
s
.379 .384 .739 r
.54839 .74001 m .55394 .77123 L .50502 .74217 L p F P
0 g
s
.598 .603 .828 r
.40297 .54458 m .403 .56359 L .36108 .53481 L p F P
0 g
s
.538 .543 .809 r
.403 .56359 m .40297 .54458 L .44326 .56729 L p F P
0 g
s
.538 .543 .809 r
.44326 .56729 m .44515 .58878 L .403 .56359 L p F P
0 g
s
.648 .653 .842 r
.31685 .51735 m .32041 .50313 L .36108 .53481 L p F P
0 g
s
.646 .659 .848 r
.36288 .51838 m .36108 .53481 L .32041 .50313 L p F P
0 g
s
.598 .603 .828 r
.36108 .53481 m .36288 .51838 L .40297 .54458 L p F P
0 g
s
.465 .474 .783 r
.44703 .61102 m .44515 .58878 L .48651 .60969 L p F P
0 g
s
.465 .474 .783 r
.48651 .60969 m .49026 .63442 L .44703 .61102 L p F P
0 g
s
.379 .389 .744 r
.50137 .71391 m .49769 .68654 L .54281 .70983 L p F P
0 g
s
.379 .389 .744 r
.54281 .70983 m .54839 .74001 L .50137 .71391 L p F P
0 g
s
.718 .74 .869 r
.21288 .48026 m .2196 .47054 L .2612 .51709 L p F P
0 g
s
.715 .744 .874 r
.26633 .50466 m .2612 .51709 L .2196 .47054 L p F P
0 g
s
.687 .702 .859 r
.27151 .49255 m .27674 .48075 L .31685 .51735 L p F P
0 g
s
.684 .707 .865 r
.32041 .50313 m .31685 .51735 L .27674 .48075 L p F P
0 g
s
.739 .775 .882 r
.19305 .51081 m .18654 .52145 L .14192 .45955 L p F P
0 g
s
.379 .393 .749 r
.49769 .68654 m .49399 .66004 L .53721 .6807 L p F P
0 g
s
.379 .393 .749 r
.53721 .6807 m .54281 .70983 L .49769 .68654 L p F P
0 g
s
.597 .609 .834 r
.40294 .5262 m .40297 .54458 L .36288 .51838 L p F P
0 g
s
.537 .55 .815 r
.40297 .54458 m .40294 .5262 L .44135 .54655 L p F P
0 g
s
.537 .55 .815 r
.44135 .54655 m .44326 .56729 L .40297 .54458 L p F P
0 g
s
.465 .48 .789 r
.44515 .58878 m .44326 .56729 L .48272 .58585 L p F P
0 g
s
.465 .48 .789 r
.48272 .58585 m .48651 .60969 L .44515 .58878 L p F P
0 g
s
.646 .659 .848 r
.32041 .50313 m .324 .48933 L .36288 .51838 L p F P
0 g
s
.644 .665 .855 r
.3647 .50246 m .36288 .51838 L .324 .48933 L p F P
0 g
s
.597 .609 .834 r
.36288 .51838 m .3647 .50246 L .40294 .5262 L p F P
0 g
s
.715 .744 .874 r
.2196 .47054 m .22638 .46105 L .26633 .50466 L p F P
0 g
s
.713 .748 .88 r
.27151 .49255 m .26633 .50466 L .22638 .46105 L p F P
0 g
s
.684 .707 .865 r
.27674 .48075 m .28202 .46927 L .32041 .50313 L p F P
0 g
s
.682 .712 .871 r
.324 .48933 m .32041 .50313 L .28202 .46927 L p F P
0 g
s
.739 .775 .882 r
.14192 .45955 m .15003 .45208 L .19305 .51081 L p F P
0 g
s
.736 .778 .886 r
.19961 .5004 m .19305 .51081 L .15003 .45208 L p F P
0 g
s
.379 .398 .755 r
.49399 .66004 m .49026 .63442 L .53159 .65261 L p F P
0 g
s
.379 .398 .755 r
.53159 .65261 m .53721 .6807 L .49399 .66004 L p F P
0 g
s
.279 .292 .696 r
.57603 .90665 m .57053 .87121 L .62229 .90287 L p F P
0 g
s
.279 .292 .696 r
.62229 .90287 m .62981 .94193 L .57603 .90665 L p F P
0 g
s
.465 .486 .796 r
.44326 .56729 m .44135 .54655 L .47891 .5629 L p F P
0 g
s
.465 .486 .796 r
.47891 .5629 m .48272 .58585 L .44326 .56729 L p F P
0 g
s
.595 .615 .842 r
.40291 .50846 m .40294 .5262 L .3647 .50246 L p F P
0 g
s
.536 .556 .823 r
.40294 .5262 m .40291 .50846 L .43942 .52657 L p F P
0 g
s
.536 .556 .823 r
.43942 .52657 m .44135 .54655 L .40294 .5262 L p F P
0 g
s
.713 .748 .88 r
.22638 .46105 m .23322 .4518 L .27151 .49255 L p F P
0 g
s
.709 .753 .886 r
.27674 .48075 m .27151 .49255 L .23322 .4518 L p F P
0 g
s
.644 .665 .855 r
.324 .48933 m .32764 .47594 L .3647 .50246 L p F P
0 g
s
.642 .671 .862 r
.36655 .48707 m .3647 .50246 L .32764 .47594 L p F P
0 g
s
.595 .615 .842 r
.3647 .50246 m .36655 .48707 L .40291 .50846 L p F P
0 g
s
.736 .778 .886 r
.15003 .45208 m .15819 .44478 L .19961 .5004 L p F P
0 g
s
.733 .781 .891 r
.20622 .49021 m .19961 .5004 L .15819 .44478 L p F P
0 g
s
.278 .295 .699 r
.57053 .87121 m .56501 .83683 L .61478 .8651 L p F P
0 g
s
.278 .295 .699 r
.61478 .8651 m .62229 .90287 L .57053 .87121 L p F P
0 g
s
.682 .712 .871 r
.28202 .46927 m .28737 .45812 L .324 .48933 L p F P
0 g
s
.679 .718 .878 r
.32764 .47594 m .324 .48933 L .28737 .45812 L p F P
0 g
s
.379 .404 .761 r
.49026 .63442 m .48651 .60969 L .52593 .62557 L p F P
0 g
s
.379 .404 .761 r
.52593 .62557 m .53159 .65261 L .49026 .63442 L p F P
0 g
s
.277 .298 .703 r
.56501 .83683 m .55949 .8035 L .60727 .82859 L p F P
0 g
s
.277 .298 .703 r
.60727 .82859 m .61478 .8651 L .56501 .83683 L p F P
0 g
s
.733 .781 .891 r
.15819 .44478 m .1664 .43765 L .20622 .49021 L p F P
0 g
s
.73 .785 .896 r
.21288 .48026 m .20622 .49021 L .1664 .43765 L p F P
0 g
s
.709 .753 .886 r
.23322 .4518 m .24011 .44279 L .27674 .48075 L p F P
0 g
s
.706 .757 .892 r
.28202 .46927 m .27674 .48075 L .24011 .44279 L p F P
0 g
s
.465 .493 .803 r
.44135 .54655 m .43942 .52657 L .47507 .54086 L p F P
0 g
s
.465 .493 .803 r
.47507 .54086 m .47891 .5629 L .44135 .54655 L p F P
0 g
s
.594 .622 .85 r
.40288 .49136 m .40291 .50846 L .36655 .48707 L p F P
0 g
s
.536 .564 .83 r
.40291 .50846 m .40288 .49136 L .43747 .50736 L p F P
0 g
s
.536 .564 .83 r
.43747 .50736 m .43942 .52657 L .40291 .50846 L p F P
0 g
s
.277 .302 .707 r
.55949 .8035 m .55394 .77123 L .59977 .79333 L p F P
0 g
s
.277 .302 .707 r
.59977 .79333 m .60727 .82859 L .55949 .8035 L p F P
0 g
s
.642 .671 .862 r
.32764 .47594 m .33131 .46298 L .36655 .48707 L p F P
0 g
s
.639 .677 .87 r
.36841 .47221 m .36655 .48707 L .33131 .46298 L p F P
0 g
s
.594 .622 .85 r
.36655 .48707 m .36841 .47221 L .40288 .49136 L p F P
0 g
s
.379 .41 .767 r
.48651 .60969 m .48272 .58585 L .52025 .59959 L p F P
0 g
s
.379 .41 .767 r
.52025 .59959 m .52593 .62557 L .48651 .60969 L p F P
0 g
s
.679 .718 .878 r
.28737 .45812 m .29276 .44729 L .32764 .47594 L p F P
0 g
s
.675 .723 .886 r
.33131 .46298 m .32764 .47594 L .29276 .44729 L p F P
0 g
s
.73 .785 .896 r
.1664 .43765 m .17466 .43067 L .21288 .48026 L p F P
0 g
s
.726 .788 .901 r
.2196 .47054 m .21288 .48026 L .17466 .43067 L p F P
0 g
s
.277 .306 .712 r
.55394 .77123 m .54839 .74001 L .59226 .75933 L p F P
0 g
s
.277 .306 .712 r
.59226 .75933 m .59977 .79333 L .55394 .77123 L p F P
0 g
s
.706 .757 .892 r
.24011 .44279 m .24707 .43402 L .28202 .46927 L p F P
0 g
s
.702 .762 .898 r
.28737 .45812 m .28202 .46927 L .24707 .43402 L p F P
0 g
s
.465 .501 .811 r
.43942 .52657 m .43747 .50736 L .47119 .51972 L p F P
0 g
s
.465 .501 .811 r
.47119 .51972 m .47507 .54086 L .43942 .52657 L p F P
0 g
s
.379 .417 .774 r
.48272 .58585 m .47891 .5629 L .51454 .57465 L p F P
0 g
s
.379 .417 .774 r
.51454 .57465 m .52025 .59959 L .48272 .58585 L p F P
0 g
s
.592 .63 .858 r
.40285 .47491 m .40288 .49136 L .36841 .47221 L p F P
0 g
s
.535 .572 .839 r
.40288 .49136 m .40285 .47491 L .43549 .48893 L p F P
0 g
s
.535 .572 .839 r
.43549 .48893 m .43747 .50736 L .40288 .49136 L p F P
0 g
s
.276 .31 .717 r
.54839 .74001 m .54281 .70983 L .58475 .72656 L p F P
0 g
s
.276 .31 .717 r
.58475 .72656 m .59226 .75933 L .54839 .74001 L p F P
0 g
s
.639 .677 .87 r
.33131 .46298 m .33504 .45044 L .36841 .47221 L p F P
0 g
s
.637 .684 .878 r
.3703 .45788 m .36841 .47221 L .33504 .45044 L p F P
0 g
s
.592 .63 .858 r
.36841 .47221 m .3703 .45788 L .40285 .47491 L p F P
0 g
s
.726 .788 .901 r
.17466 .43067 m .18298 .42387 L .2196 .47054 L p F P
0 g
s
.722 .792 .907 r
.22638 .46105 m .2196 .47054 L .18298 .42387 L p F P
0 g
s
.675 .723 .886 r
.29276 .44729 m .29822 .43679 L .33131 .46298 L p F P
0 g
s
.671 .729 .893 r
.33504 .45044 m .33131 .46298 L .29822 .43679 L p F P
0 g
s
.702 .762 .898 r
.24707 .43402 m .25409 .4255 L .28737 .45812 L p F P
0 g
s
.698 .767 .905 r
.29276 .44729 m .28737 .45812 L .25409 .4255 L p F P
0 g
s
.276 .315 .722 r
.54281 .70983 m .53721 .6807 L .57724 .69503 L p F P
0 g
s
.276 .315 .722 r
.57724 .69503 m .58475 .72656 L .54281 .70983 L p F P
0 g
s
.38 .424 .782 r
.47891 .5629 m .47507 .54086 L .50879 .55076 L p F P
0 g
s
.38 .424 .782 r
.50879 .55076 m .51454 .57465 L .47891 .5629 L p F P
0 g
s
.465 .509 .819 r
.43747 .50736 m .43549 .48893 L .46727 .4995 L p F P
0 g
s
.465 .509 .819 r
.46727 .4995 m .47119 .51972 L .43747 .50736 L p F P
0 g
s
.722 .792 .907 r
.18298 .42387 m .19135 .41723 L .22638 .46105 L p F P
0 g
s
.718 .795 .912 r
.23322 .4518 m .22638 .46105 L .19135 .41723 L p F P
0 g
s
.59 .638 .867 r
.40282 .45912 m .40285 .47491 L .3703 .45788 L p F P
0 g
s
.534 .58 .848 r
.40285 .47491 m .40282 .45912 L .43349 .47129 L p F P
0 g
s
.534 .58 .848 r
.43349 .47129 m .43549 .48893 L .40285 .47491 L p F P
0 g
s
.276 .32 .727 r
.53721 .6807 m .53159 .65261 L .56971 .66473 L p F P
0 g
s
.276 .32 .727 r
.56971 .66473 m .57724 .69503 L .53721 .6807 L p F P
0 g
s
.637 .684 .878 r
.33504 .45044 m .33881 .43834 L .3703 .45788 L p F P
0 g
s
.633 .692 .887 r
.37222 .44411 m .3703 .45788 L .33881 .43834 L p F P
0 g
s
.59 .638 .867 r
.3703 .45788 m .37222 .44411 L .40282 .45912 L p F P
0 g
s
.671 .729 .893 r
.29822 .43679 m .30374 .42664 L .33504 .45044 L p F P
0 g
s
.667 .735 .901 r
.33881 .43834 m .33504 .45044 L .30374 .42664 L p F P
0 g
s
.698 .767 .905 r
.25409 .4255 m .26118 .41723 L .29276 .44729 L p F P
0 g
s
.693 .771 .912 r
.29822 .43679 m .29276 .44729 L .26118 .41723 L p F P
0 g
s
.381 .433 .79 r
.47507 .54086 m .47119 .51972 L .503 .52794 L p F P
0 g
s
.381 .433 .79 r
.503 .52794 m .50879 .55076 L .47507 .54086 L p F P
0 g
s
.718 .795 .912 r
.19135 .41723 m .19978 .41076 L .23322 .4518 L p F P
0 g
s
.713 .799 .918 r
.24011 .44279 m .23322 .4518 L .19978 .41076 L p F P
0 g
s
.277 .326 .734 r
.53159 .65261 m .52593 .62557 L .56217 .63565 L p F P
0 g
s
.277 .326 .734 r
.56217 .63565 m .56971 .66473 L .53159 .65261 L p F P
0 g
s
.465 .519 .829 r
.43549 .48893 m .43349 .47129 L .46331 .48021 L p F P
0 g
s
.465 .519 .829 r
.46331 .48021 m .46727 .4995 L .43549 .48893 L p F P
0 g
s
.588 .647 .876 r
.40279 .44401 m .40282 .45912 L .37222 .44411 L p F P
0 g
s
.533 .59 .857 r
.40282 .45912 m .40279 .44401 L .43147 .45445 L p F P
0 g
s
.533 .59 .857 r
.43147 .45445 m .43349 .47129 L .40282 .45912 L p F P
0 g
s
.667 .735 .901 r
.30374 .42664 m .30932 .41682 L .33881 .43834 L p F P
0 g
s
.662 .742 .909 r
.34263 .42669 m .33881 .43834 L .30932 .41682 L p F P
0 g
s
.633 .692 .887 r
.33881 .43834 m .34263 .42669 L .37222 .44411 L p F P
0 g
s
.629 .7 .896 r
.37416 .43088 m .37222 .44411 L .34263 .42669 L p F P
0 g
s
.588 .647 .876 r
.37222 .44411 m .37416 .43088 L .40279 .44401 L p F P
0 g
s
.713 .799 .918 r
.19978 .41076 m .20827 .40446 L .24011 .44279 L p F P
0 g
s
.708 .802 .923 r
.24707 .43402 m .24011 .44279 L .20827 .40446 L p F P
0 g
s
.693 .771 .912 r
.26118 .41723 m .26834 .4092 L .29822 .43679 L p F P
0 g
s
.687 .776 .919 r
.30374 .42664 m .29822 .43679 L .26834 .4092 L p F P
0 g
s
.277 .333 .74 r
.52593 .62557 m .52025 .59959 L .55462 .60779 L p F P
0 g
s
.277 .333 .74 r
.55462 .60779 m .56217 .63565 L .52593 .62557 L p F P
0 g
s
.382 .442 .799 r
.47119 .51972 m .46727 .4995 L .49717 .50617 L p F P
0 g
s
.382 .442 .799 r
.49717 .50617 m .503 .52794 L .47119 .51972 L p F P
0 g
s
.728 .819 .921 r
.15003 .45208 m .14192 .45955 L .10421 .39978 L p F P
0 g
s
.465 .529 .839 r
.43349 .47129 m .43147 .45445 L .45931 .46184 L p F P
0 g
s
.465 .529 .839 r
.45931 .46184 m .46331 .48021 L .43349 .47129 L p F P
0 g
s
.278 .34 .748 r
.52025 .59959 m .51454 .57465 L .54704 .58115 L p F P
0 g
s
.278 .34 .748 r
.54704 .58115 m .55462 .60779 L .52025 .59959 L p F P
0 g
s
.708 .802 .923 r
.20827 .40446 m .21681 .39833 L .24707 .43402 L p F P
0 g
s
.703 .806 .929 r
.25409 .4255 m .24707 .43402 L .21681 .39833 L p F P
0 g
s
.728 .819 .921 r
.10421 .39978 m .11389 .39531 L .15003 .45208 L p F P
0 g
s
.724 .822 .925 r
.15819 .44478 m .15003 .45208 L .11389 .39531 L p F P
0 g
s
.585 .656 .886 r
.40275 .42958 m .40279 .44401 L .37416 .43088 L p F P
0 g
s
.532 .6 .868 r
.40279 .44401 m .40275 .42958 L .42942 .43841 L p F P
0 g
s
.532 .6 .868 r
.42942 .43841 m .43147 .45445 L .40279 .44401 L p F P
0 g
s
.687 .776 .919 r
.26834 .4092 m .27556 .40143 L .30374 .42664 L p F P
0 g
s
.681 .781 .926 r
.30932 .41682 m .30374 .42664 L .27556 .40143 L p F P
0 g
s
.662 .742 .909 r
.30932 .41682 m .31497 .40735 L .34263 .42669 L p F P
0 g
s
.657 .749 .918 r
.3465 .41548 m .34263 .42669 L .31497 .40735 L p F P
0 g
s
.629 .7 .896 r
.34263 .42669 m .3465 .41548 L .37416 .43088 L p F P
0 g
s
.383 .452 .808 r
.46727 .4995 m .46331 .48021 L .4913 .48548 L p F P
0 g
s
.383 .452 .808 r
.4913 .48548 m .49717 .50617 L .46727 .4995 L p F P
0 g
s
.625 .708 .906 r
.37613 .41822 m .37416 .43088 L .3465 .41548 L p F P
0 g
s
.585 .656 .886 r
.37416 .43088 m .37613 .41822 L .40275 .42958 L p F P
0 g
s
.724 .822 .925 r
.11389 .39531 m .1236 .39094 L .15819 .44478 L p F P
0 g
s
.72 .824 .93 r
.1664 .43765 m .15819 .44478 L .1236 .39094 L p F P
0 g
s
.28 .348 .756 r
.51454 .57465 m .50879 .55076 L .53943 .55573 L p F P
0 g
s
.28 .348 .756 r
.53943 .55573 m .54704 .58115 L .51454 .57465 L p F P
0 g
s
.158 .203 .659 r
.62981 .94193 m .62229 .90287 L .66937 .92538 L p F P
0 g
s
.158 .203 .659 r
.66937 .92538 m .67898 .96784 L .62981 .94193 L p F P
0 g
s
.703 .806 .929 r
.21681 .39833 m .22542 .39238 L .25409 .4255 L p F P
0 g
s
.697 .809 .935 r
.26118 .41723 m .25409 .4255 L .22542 .39238 L p F P
0 g
s
.465 .541 .85 r
.43147 .45445 m .42942 .43841 L .45527 .44443 L p F P
0 g
s
.465 .541 .85 r
.45527 .44443 m .45931 .46184 L .43147 .45445 L p F P
0 g
s
.157 .206 .663 r
.62229 .90287 m .61478 .8651 L .65981 .88444 L p F P
0 g
s
.157 .206 .663 r
.65981 .88444 m .66937 .92538 L .62229 .90287 L p F P
0 g
s
.72 .824 .93 r
.1236 .39094 m .13335 .38668 L .1664 .43765 L p F P
0 g
s
.715 .826 .934 r
.17466 .43067 m .1664 .43765 L .13335 .38668 L p F P
0 g
s
.681 .781 .926 r
.27556 .40143 m .28286 .39392 L .30932 .41682 L p F P
0 g
s
.675 .787 .933 r
.31497 .40735 m .30932 .41682 L .28286 .39392 L p F P
0 g
s
.156 .209 .667 r
.61478 .8651 m .60727 .82859 L .65028 .84501 L p F P
0 g
s
.156 .209 .667 r
.65028 .84501 m .65981 .88444 L .61478 .8651 L p F P
0 g
s
.384 .464 .819 r
.46331 .48021 m .45931 .46184 L .48538 .46587 L p F P
0 g
s
.384 .464 .819 r
.48538 .46587 m .4913 .48548 L .46331 .48021 L p F P
0 g
s
.281 .358 .764 r
.50879 .55076 m .503 .52794 L .5318 .53153 L p F P
0 g
s
.281 .358 .764 r
.5318 .53153 m .53943 .55573 L .50879 .55076 L p F P
0 g
s
.581 .666 .897 r
.40272 .41583 m .40275 .42958 L .37613 .41822 L p F P
0 g
s
.53 .612 .879 r
.40275 .42958 m .40272 .41583 L .42735 .4232 L p F P
0 g
s
.53 .612 .879 r
.42735 .4232 m .42942 .43841 L .40275 .42958 L p F P
0 g
s
.657 .749 .918 r
.31497 .40735 m .32069 .39823 L .3465 .41548 L p F P
0 g
s
.65 .756 .927 r
.35042 .40472 m .3465 .41548 L .32069 .39823 L p F P
0 g
s
.625 .708 .906 r
.3465 .41548 m .35042 .40472 L .37613 .41822 L p F P
0 g
s
.156 .213 .671 r
.60727 .82859 m .59977 .79333 L .6408 .80707 L p F P
0 g
s
.156 .213 .671 r
.6408 .80707 m .65028 .84501 L .60727 .82859 L p F P
0 g
s
.62 .717 .916 r
.37813 .40614 m .37613 .41822 L .35042 .40472 L p F P
0 g
s
.581 .666 .897 r
.37613 .41822 m .37813 .40614 L .40272 .41583 L p F P
0 g
s
.697 .809 .935 r
.22542 .39238 m .23408 .3866 L .26118 .41723 L p F P
0 g
s
.691 .813 .941 r
.26834 .4092 m .26118 .41723 L .23408 .3866 L p F P
0 g
s
.715 .826 .934 r
.13335 .38668 m .14314 .38252 L .17466 .43067 L p F P
0 g
s
.71 .829 .938 r
.18298 .42387 m .17466 .43067 L .14314 .38252 L p F P
0 g
s
.155 .217 .676 r
.59977 .79333 m .59226 .75933 L .63135 .77059 L p F P
0 g
s
.155 .217 .676 r
.63135 .77059 m .6408 .80707 L .59977 .79333 L p F P
0 g
s
.466 .553 .861 r
.42942 .43841 m .42735 .4232 L .45118 .42797 L p F P
0 g
s
.466 .553 .861 r
.45118 .42797 m .45527 .44443 L .42942 .43841 L p F P
0 g
s
.283 .368 .774 r
.503 .52794 m .49717 .50617 L .52413 .50854 L p F P
0 g
s
.283 .368 .774 r
.52413 .50854 m .5318 .53153 L .503 .52794 L p F P
0 g
s
.155 .221 .681 r
.59226 .75933 m .58475 .72656 L .62193 .73557 L p F P
0 g
s
.155 .221 .681 r
.62193 .73557 m .63135 .77059 L .59226 .75933 L p F P
0 g
s
.675 .787 .933 r
.28286 .39392 m .29023 .38666 L .31497 .40735 L p F P
0 g
s
.667 .792 .941 r
.32069 .39823 m .31497 .40735 L .29023 .38666 L p F P
0 g
s
.386 .476 .83 r
.45931 .46184 m .45527 .44443 L .4794 .44734 L p F P
0 g
s
.386 .476 .83 r
.4794 .44734 m .48538 .46587 L .45931 .46184 L p F P
0 g
s
.71 .829 .938 r
.14314 .38252 m .15296 .37847 L .18298 .42387 L p F P
0 g
s
.705 .831 .943 r
.19135 .41723 m .18298 .42387 L .15296 .37847 L p F P
0 g
s
.691 .813 .941 r
.23408 .3866 m .24281 .38099 L .26834 .4092 L p F P
0 g
s
.683 .816 .946 r
.27556 .40143 m .26834 .4092 L .24281 .38099 L p F P
0 g
s
.155 .226 .686 r
.58475 .72656 m .57724 .69503 L .61253 .70198 L p F P
0 g
s
.155 .226 .686 r
.61253 .70198 m .62193 .73557 L .58475 .72656 L p F P
0 g
s
.65 .756 .927 r
.32069 .39823 m .32648 .38947 L .35042 .40472 L p F P
0 g
s
.643 .763 .936 r
.35439 .39443 m .35042 .40472 L .32648 .38947 L p F P
0 g
s
.62 .717 .916 r
.35042 .40472 m .35439 .39443 L .37813 .40614 L p F P
0 g
s
.577 .677 .908 r
.40269 .4028 m .40272 .41583 L .37813 .40614 L p F P
0 g
s
.528 .624 .891 r
.40272 .41583 m .40269 .4028 L .42525 .40882 L p F P
0 g
s
.528 .624 .891 r
.42525 .40882 m .42735 .4232 L .40272 .41583 L p F P
0 g
s
.613 .726 .926 r
.38015 .39464 m .37813 .40614 L .35439 .39443 L p F P
0 g
s
.577 .677 .908 r
.37813 .40614 m .38015 .39464 L .40269 .4028 L p F P
0 g
s
.705 .831 .943 r
.15296 .37847 m .16283 .37453 L .19135 .41723 L p F P
0 g
s
.699 .833 .947 r
.19978 .41076 m .19135 .41723 L .16283 .37453 L p F P
0 g
s
.285 .379 .784 r
.49717 .50617 m .4913 .48548 L .51643 .48678 L p F P
0 g
s
.285 .379 .784 r
.51643 .48678 m .52413 .50854 L .49717 .50617 L p F P
0 g
s
.156 .232 .692 r
.57724 .69503 m .56971 .66473 L .60314 .66983 L p F P
0 g
s
.156 .232 .692 r
.60314 .66983 m .61253 .70198 L .57724 .69503 L p F P
0 g
s
.466 .568 .874 r
.42735 .4232 m .42525 .40882 L .44704 .41247 L p F P
0 g
s
.466 .568 .874 r
.44704 .41247 m .45118 .42797 L .42735 .4232 L p F P
0 g
s
.667 .792 .941 r
.29023 .38666 m .29767 .37967 L .32069 .39823 L p F P
0 g
s
.659 .797 .949 r
.32648 .38947 m .32069 .39823 L .29767 .37967 L p F P
0 g
s
.683 .816 .946 r
.24281 .38099 m .25161 .37557 L .27556 .40143 L p F P
0 g
s
.676 .82 .952 r
.28286 .39392 m .27556 .40143 L .25161 .37557 L p F P
0 g
s
.156 .239 .699 r
.56971 .66473 m .56217 .63565 L .59378 .63908 L p F P
0 g
s
.156 .239 .699 r
.59378 .63908 m .60314 .66983 L .56971 .66473 L p F P
0 g
s
.388 .491 .843 r
.45527 .44443 m .45118 .42797 L .47337 .4299 L p F P
0 g
s
.388 .491 .843 r
.47337 .4299 m .4794 .44734 L .45527 .44443 L p F P
0 g
s
.699 .833 .947 r
.16283 .37453 m .17274 .37069 L .19978 .41076 L p F P
0 g
s
.693 .835 .951 r
.20827 .40446 m .19978 .41076 L .17274 .37069 L p F P
0 g
s
.288 .392 .795 r
.4913 .48548 m .48538 .46587 L .50869 .46623 L p F P
0 g
s
.288 .392 .795 r
.50869 .46623 m .51643 .48678 L .4913 .48548 L p F P
0 g
s
.158 .246 .706 r
.56217 .63565 m .55462 .60779 L .58442 .60974 L p F P
0 g
s
.158 .246 .706 r
.58442 .60974 m .59378 .63908 L .56217 .63565 L p F P
0 g
s
.643 .763 .936 r
.32648 .38947 m .33233 .38107 L .35439 .39443 L p F P
0 g
s
.634 .77 .945 r
.35842 .38461 m .35439 .39443 L .33233 .38107 L p F P
0 g
s
.613 .726 .926 r
.35439 .39443 m .35842 .38461 L .38015 .39464 L p F P
0 g
s
.572 .689 .92 r
.40265 .39048 m .40269 .4028 L .38015 .39464 L p F P
0 g
s
.525 .638 .904 r
.40269 .4028 m .40265 .39048 L .42311 .39529 L p F P
0 g
s
.525 .638 .904 r
.42311 .39529 m .42525 .40882 L .40269 .4028 L p F P
0 g
s
.693 .835 .951 r
.17274 .37069 m .18268 .36696 L .20827 .40446 L p F P
0 g
s
.687 .837 .956 r
.21681 .39833 m .20827 .40446 L .18268 .36696 L p F P
0 g
s
.606 .736 .937 r
.38221 .38373 m .38015 .39464 L .35842 .38461 L p F P
0 g
s
.572 .689 .92 r
.38015 .39464 m .38221 .38373 L .40265 .39048 L p F P
0 g
s
.676 .82 .952 r
.25161 .37557 m .26047 .37032 L .28286 .39392 L p F P
0 g
s
.667 .823 .958 r
.29023 .38666 m .28286 .39392 L .26047 .37032 L p F P
0 g
s
.159 .254 .714 r
.55462 .60779 m .54704 .58115 L .57507 .58179 L p F P
0 g
s
.159 .254 .714 r
.57507 .58179 m .58442 .60974 L .55462 .60779 L p F P
0 g
s
.659 .797 .949 r
.29767 .37967 m .30519 .37294 L .32648 .38947 L p F P
0 g
s
.649 .802 .956 r
.33233 .38107 m .32648 .38947 L .30519 .37294 L p F P
0 g
s
.465 .583 .888 r
.42525 .40882 m .42311 .39529 L .44285 .39796 L p F P
0 g
s
.465 .583 .888 r
.44285 .39796 m .44704 .41247 L .42525 .40882 L p F P
0 g
s
.39 .507 .856 r
.45118 .42797 m .44704 .41247 L .46729 .41358 L p F P
0 g
s
.39 .507 .856 r
.46729 .41358 m .47337 .4299 L .45118 .42797 L p F P
0 g
s
.292 .407 .808 r
.48538 .46587 m .4794 .44734 L .5009 .44692 L p F P
0 g
s
.292 .407 .808 r
.5009 .44692 m .50869 .46623 L .48538 .46587 L p F P
0 g
s
.161 .264 .722 r
.54704 .58115 m .53943 .55573 L .56572 .55523 L p F P
0 g
s
.161 .264 .722 r
.56572 .55523 m .57507 .58179 L .54704 .58115 L p F P
0 g
s
.687 .837 .956 r
.18268 .36696 m .19267 .36333 L .21681 .39833 L p F P
0 g
s
.68 .839 .96 r
.22542 .39238 m .21681 .39833 L .19267 .36333 L p F P
0 g
s
.634 .77 .945 r
.33233 .38107 m .33827 .37304 L .35842 .38461 L p F P
0 g
s
.624 .777 .954 r
.36251 .37527 m .35842 .38461 L .33827 .37304 L p F P
0 g
s
.606 .736 .937 r
.35842 .38461 m .36251 .37527 L .38221 .38373 L p F P
0 g
s
.667 .823 .958 r
.26047 .37032 m .26939 .36526 L .29023 .38666 L p F P
0 g
s
.658 .826 .964 r
.29767 .37967 m .29023 .38666 L .26939 .36526 L p F P
0 g
s
.566 .702 .932 r
.40262 .37889 m .40265 .39048 L .38221 .38373 L p F P
0 g
s
.522 .653 .917 r
.40265 .39048 m .40262 .37889 L .42095 .38262 L p F P
0 g
s
.522 .653 .917 r
.42095 .38262 m .42311 .39529 L .40265 .39048 L p F P
0 g
s
.164 .274 .732 r
.53943 .55573 m .5318 .53153 L .55637 .53005 L p F P
0 g
s
.164 .274 .732 r
.55637 .53005 m .56572 .55523 L .53943 .55573 L p F P
0 g
s
.68 .839 .96 r
.19267 .36333 m .2027 .35982 L .22542 .39238 L p F P
0 g
s
.672 .841 .964 r
.23408 .3866 m .22542 .39238 L .2027 .35982 L p F P
0 g
s
.649 .802 .956 r
.30519 .37294 m .31279 .36649 L .33233 .38107 L p F P
0 g
s
.639 .806 .964 r
.33827 .37304 m .33233 .38107 L .31279 .36649 L p F P
0 g
s
.597 .746 .948 r
.3843 .37343 m .38221 .38373 L .36251 .37527 L p F P
0 g
s
.566 .702 .932 r
.38221 .38373 m .3843 .37343 L .40262 .37889 L p F P
0 g
s
.296 .423 .821 r
.4794 .44734 m .47337 .4299 L .49307 .42885 L p F P
0 g
s
.296 .423 .821 r
.49307 .42885 m .5009 .44692 L .4794 .44734 L p F P
0 g
s
.393 .525 .871 r
.44704 .41247 m .44285 .39796 L .46114 .39837 L p F P
0 g
s
.393 .525 .871 r
.46114 .39837 m .46729 .41358 L .44704 .41247 L p F P
0 g
s
.465 .601 .902 r
.42311 .39529 m .42095 .38262 L .43861 .38445 L p F P
0 g
s
.465 .601 .902 r
.43861 .38445 m .44285 .39796 L .42311 .39529 L p F P
0 g
s
.167 .286 .742 r
.5318 .53153 m .52413 .50854 L .54701 .50624 L p F P
0 g
s
.167 .286 .742 r
.54701 .50624 m .55637 .53005 L .5318 .53153 L p F P
0 g
s
.658 .826 .964 r
.26939 .36526 m .27839 .36037 L .29767 .37967 L p F P
0 g
s
.648 .828 .97 r
.30519 .37294 m .29767 .37967 L .27839 .36037 L p F P
0 g
s
.672 .841 .964 r
.2027 .35982 m .21278 .35641 L .23408 .3866 L p F P
0 g
s
.664 .843 .968 r
.24281 .38099 m .23408 .3866 L .21278 .35641 L p F P
0 g
s
.624 .777 .954 r
.33827 .37304 m .34428 .36538 L .36251 .37527 L p F P
0 g
s
.613 .784 .963 r
.36666 .36642 m .36251 .37527 L .34428 .36538 L p F P
0 g
s
.597 .746 .948 r
.36251 .37527 m .36666 .36642 L .3843 .37343 L p F P
0 g
s
.171 .299 .754 r
.52413 .50854 m .51643 .48678 L .53764 .4838 L p F P
0 g
s
.171 .299 .754 r
.53764 .4838 m .54701 .50624 L .52413 .50854 L p F P
0 g
s
.301 .441 .836 r
.47337 .4299 m .46729 .41358 L .48518 .41201 L p F P
0 g
s
.301 .441 .836 r
.48518 .41201 m .49307 .42885 L .47337 .4299 L p F P
0 g
s
.639 .806 .964 r
.31279 .36649 m .32047 .36031 L .33827 .37304 L p F P
0 g
s
.626 .811 .971 r
.34428 .36538 m .33827 .37304 L .32047 .36031 L p F P
0 g
s
.559 .715 .945 r
.40258 .36805 m .40262 .37889 L .3843 .37343 L p F P
0 g
s
.518 .669 .932 r
.40262 .37889 m .40258 .36805 L .41875 .37083 L p F P
0 g
s
.518 .669 .932 r
.41875 .37083 m .42095 .38262 L .40262 .37889 L p F P
0 g
s
.664 .843 .968 r
.21278 .35641 m .22289 .35312 L .24281 .38099 L p F P
0 g
s
.656 .844 .972 r
.25161 .37557 m .24281 .38099 L .22289 .35312 L p F P
0 g
s
.395 .545 .887 r
.44285 .39796 m .43861 .38445 L .45492 .38429 L p F P
0 g
s
.395 .545 .887 r
.45492 .38429 m .46114 .39837 L .44285 .39796 L p F P
0 g
s
.586 .756 .959 r
.38642 .36375 m .3843 .37343 L .36666 .36642 L p F P
0 g
s
.559 .715 .945 r
.3843 .37343 m .38642 .36375 L .40258 .36805 L p F P
0 g
s
.648 .828 .97 r
.27839 .36037 m .28746 .35568 L .30519 .37294 L p F P
0 g
s
.637 .831 .975 r
.31279 .36649 m .30519 .37294 L .28746 .35568 L p F P
0 g
s
.464 .62 .918 r
.42095 .38262 m .41875 .37083 L .43431 .37195 L p F P
0 g
s
.464 .62 .918 r
.43431 .37195 m .43861 .38445 L .42095 .38262 L p F P
0 g
s
.176 .314 .766 r
.51643 .48678 m .50869 .46623 L .52825 .46273 L p F P
0 g
s
.176 .314 .766 r
.52825 .46273 m .53764 .4838 L .51643 .48678 L p F P
0 g
s
.685 .852 .963 r
.11389 .39531 m .10421 .39978 L .07568 .34439 L p F P
0 g
s
.656 .844 .972 r
.22289 .35312 m .23305 .34993 L .25161 .37557 L p F P
0 g
s
.647 .845 .976 r
.26047 .37032 m .25161 .37557 L .23305 .34993 L p F P
0 g
s
.306 .462 .852 r
.46729 .41358 m .46114 .39837 L .47723 .39642 L p F P
0 g
s
.306 .462 .852 r
.47723 .39642 m .48518 .41201 L .46729 .41358 L p F P
0 g
s
.613 .784 .963 r
.34428 .36538 m .35037 .35811 L .36666 .36642 L p F P
0 g
s
.6 .791 .972 r
.37087 .35807 m .36666 .36642 L .35037 .35811 L p F P
0 g
s
.586 .756 .959 r
.36666 .36642 m .37087 .35807 L .38642 .36375 L p F P
0 g
s
.685 .852 .963 r
.07568 .34439 m .08682 .34263 L .11389 .39531 L p F P
0 g
s
.679 .853 .966 r
.1236 .39094 m .11389 .39531 L .08682 .34263 L p F P
0 g
s
.182 .331 .78 r
.50869 .46623 m .5009 .44692 L .51883 .44303 L p F P
0 g
s
.182 .331 .78 r
.51883 .44303 m .52825 .46273 L .50869 .46623 L p F P
0 g
s
.626 .811 .971 r
.32047 .36031 m .32824 .3544 L .34428 .36538 L p F P
0 g
s
.613 .815 .978 r
.35037 .35811 m .34428 .36538 L .32824 .3544 L p F P
0 g
s
.637 .831 .975 r
.28746 .35568 m .29659 .35117 L .31279 .36649 L p F P
0 g
s
.624 .833 .98 r
.32047 .36031 m .31279 .36649 L .29659 .35117 L p F P
0 g
s
.398 .567 .904 r
.43861 .38445 m .43431 .37195 L .44864 .37136 L p F P
0 g
s
.398 .567 .904 r
.44864 .37136 m .45492 .38429 L .43861 .38445 L p F P
0 g
s
.647 .845 .976 r
.23305 .34993 m .24326 .34686 L .26047 .37032 L p F P
0 g
s
.637 .846 .98 r
.26939 .36526 m .26047 .37032 L .24326 .34686 L p F P
0 g
s
.679 .853 .966 r
.08682 .34263 m .09797 .34092 L .1236 .39094 L p F P
0 g
s
.674 .854 .968 r
.13335 .38668 m .1236 .39094 L .09797 .34092 L p F P
0 g
s
.549 .729 .958 r
.40255 .35797 m .40258 .36805 L .38642 .36375 L p F P
0 g
s
.512 .687 .946 r
.40258 .36805 m .40255 .35797 L .41652 .35993 L p F P
0 g
s
.512 .687 .946 r
.41652 .35993 m .41875 .37083 L .40258 .36805 L p F P
0 g
s
.573 .766 .97 r
.38857 .3547 m .38642 .36375 L .37087 .35807 L p F P
0 g
s
.549 .729 .958 r
.38642 .36375 m .38857 .3547 L .40255 .35797 L p F P
0 g
s
.674 .854 .968 r
.09797 .34092 m .10913 .33927 L .13335 .38668 L p F P
0 g
s
.668 .854 .971 r
.14314 .38252 m .13335 .38668 L .10913 .33927 L p F P
0 g
s
.188 .35 .795 r
.5009 .44692 m .49307 .42885 L .50939 .42469 L p F P
0 g
s
.188 .35 .795 r
.50939 .42469 m .51883 .44303 L .5009 .44692 L p F P
0 g
s
.462 .641 .934 r
.41875 .37083 m .41652 .35993 L .42995 .36048 L p F P
0 g
s
.462 .641 .934 r
.42995 .36048 m .43431 .37195 L .41875 .37083 L p F P
0 g
s
.313 .486 .869 r
.46114 .39837 m .45492 .38429 L .46922 .3821 L p F P
0 g
s
.313 .486 .869 r
.46922 .3821 m .47723 .39642 L .46114 .39837 L p F P
0 g
s
.637 .846 .98 r
.24326 .34686 m .25351 .34389 L .26939 .36526 L p F P
0 g
s
.627 .847 .984 r
.27839 .36037 m .26939 .36526 L .25351 .34389 L p F P
0 g
s
.668 .854 .971 r
.10913 .33927 m .12029 .33766 L .14314 .38252 L p F P
0 g
s
.662 .855 .974 r
.15296 .37847 m .14314 .38252 L .12029 .33766 L p F P
0 g
s
.624 .833 .98 r
.29659 .35117 m .3058 .34685 L .32047 .36031 L p F P
0 g
s
.611 .834 .985 r
.32824 .3544 m .32047 .36031 L .3058 .34685 L p F P
0 g
s
.014 .104 .613 r
.66937 .92538 m .65981 .88444 L .69788 .89292 L p F P
0 g
s
.014 .107 .617 r
.65981 .88444 m .65028 .84501 L .68639 .85101 L p F P
0 g
s
.014 .107 .617 r
.68639 .85101 m .69788 .89292 L .65981 .88444 L p F P
0 g
s
.013 .111 .622 r
.65028 .84501 m .6408 .80707 L .67498 .81084 L p F P
0 g
s
.013 .111 .622 r
.67498 .81084 m .68639 .85101 L .65028 .84501 L p F P
0 g
s
.015 .1 .609 r
.67898 .96784 m .66937 .92538 L .70947 .93659 L p F P
0 g
s
.014 .104 .613 r
.69788 .89292 m .70947 .93659 L .66937 .92538 L p F P
0 g
s
.013 .116 .627 r
.6408 .80707 m .63135 .77059 L .66366 .77237 L p F P
0 g
s
.013 .116 .627 r
.66366 .77237 m .67498 .81084 L .6408 .80707 L p F P
0 g
s
.015 .1 .609 r
.70947 .93659 m .72117 .98207 L .67898 .96784 L p F P
0 g
s
.613 .815 .978 r
.32824 .3544 m .33609 .34878 L .35037 .35811 L p F P
0 g
s
.597 .818 .984 r
.35654 .35122 m .35037 .35811 L .33609 .34878 L p F P
0 g
s
.6 .791 .972 r
.35037 .35811 m .35654 .35122 L .37087 .35807 L p F P
0 g
s
.013 .121 .632 r
.63135 .77059 m .62193 .73557 L .65242 .73558 L p F P
0 g
s
.013 .121 .632 r
.65242 .73558 m .66366 .77237 L .63135 .77059 L p F P
0 g
s
.584 .798 .981 r
.37515 .35023 m .37087 .35807 L .35654 .35122 L p F P
0 g
s
.573 .766 .97 r
.37087 .35807 m .37515 .35023 L .38857 .3547 L p F P
0 g
s
.013 .127 .638 r
.62193 .73557 m .61253 .70198 L .64125 .70045 L p F P
0 g
s
.013 .127 .638 r
.64125 .70045 m .65242 .73558 L .62193 .73557 L p F P
0 g
s
.197 .371 .811 r
.49307 .42885 m .48518 .41201 L .49992 .40772 L p F P
0 g
s
.197 .371 .811 r
.49992 .40772 m .50939 .42469 L .49307 .42885 L p F P
0 g
s
.662 .855 .974 r
.12029 .33766 m .13146 .33611 L .15296 .37847 L p F P
0 g
s
.656 .856 .976 r
.16283 .37453 m .15296 .37847 L .13146 .33611 L p F P
0 g
s
.014 .133 .645 r
.61253 .70198 m .60314 .66983 L .63015 .66694 L p F P
0 g
s
.014 .133 .645 r
.63015 .66694 m .64125 .70045 L .61253 .70198 L p F P
0 g
s
.401 .593 .922 r
.43431 .37195 m .42995 .36048 L .44228 .3596 L p F P
0 g
s
.401 .593 .922 r
.44228 .3596 m .44864 .37136 L .43431 .37195 L p F P
0 g
s
.016 .141 .652 r
.60314 .66983 m .59378 .63908 L .6191 .63505 L p F P
0 g
s
.016 .141 .652 r
.6191 .63505 m .63015 .66694 L .60314 .66983 L p F P
0 g
s
.627 .847 .984 r
.25351 .34389 m .26381 .34104 L .27839 .36037 L p F P
0 g
s
.616 .847 .987 r
.28746 .35568 m .27839 .36037 L .26381 .34104 L p F P
0 g
s
.018 .149 .66 r
.59378 .63908 m .58442 .60974 L .60811 .60473 L p F P
0 g
s
.018 .149 .66 r
.60811 .60473 m .6191 .63505 L .59378 .63908 L p F P
0 g
s
.32 .512 .888 r
.45492 .38429 m .44864 .37136 L .46115 .36904 L p F P
0 g
s
.32 .512 .888 r
.46115 .36904 m .46922 .3821 L .45492 .38429 L p F P
0 g
s
.656 .856 .976 r
.13146 .33611 m .14264 .33461 L .16283 .37453 L p F P
0 g
s
.649 .856 .979 r
.17274 .37069 m .16283 .37453 L .14264 .33461 L p F P
0 g
s
.537 .743 .971 r
.40251 .34867 m .40255 .35797 L .38857 .3547 L p F P
0 g
s
.504 .705 .961 r
.40255 .35797 m .40251 .34867 L .41426 .34995 L p F P
0 g
s
.504 .705 .961 r
.41426 .34995 m .41652 .35993 L .40255 .35797 L p F P
0 g
s
.02 .159 .669 r
.58442 .60974 m .57507 .58179 L .59717 .57599 L p F P
0 g
s
.02 .159 .669 r
.59717 .57599 m .60811 .60473 L .58442 .60974 L p F P
0 g
s
.558 .776 .98 r
.39077 .34629 m .38857 .3547 L .37515 .35023 L p F P
0 g
s
.537 .743 .971 r
.38857 .3547 m .39077 .34629 L .40251 .34867 L p F P
0 g
s
.611 .834 .985 r
.3058 .34685 m .31509 .34271 L .32824 .3544 L p F P
0 g
s
.596 .835 .99 r
.33609 .34878 m .32824 .3544 L .31509 .34271 L p F P
0 g
s
.46 .664 .951 r
.41652 .35993 m .41426 .34995 L .42552 .35007 L p F P
0 g
s
.46 .664 .951 r
.42552 .35007 m .42995 .36048 L .41652 .35993 L p F P
0 g
s
.206 .395 .829 r
.48518 .41201 m .47723 .39642 L .49041 .39211 L p F P
0 g
s
.206 .395 .829 r
.49041 .39211 m .49992 .40772 L .48518 .41201 L p F P
0 g
s
.649 .856 .979 r
.14264 .33461 m .15382 .33316 L .17274 .37069 L p F P
0 g
s
.642 .856 .981 r
.18268 .36696 m .17274 .37069 L .15382 .33316 L p F P
0 g
s
.024 .169 .678 r
.57507 .58179 m .56572 .55523 L .58628 .54879 L p F P
0 g
s
.024 .169 .678 r
.58628 .54879 m .59717 .57599 L .57507 .58179 L p F P
0 g
s
.616 .847 .987 r
.26381 .34104 m .27416 .3383 L .28746 .35568 L p F P
0 g
s
.604 .847 .99 r
.29659 .35117 m .28746 .35568 L .27416 .3383 L p F P
0 g
s
.597 .818 .984 r
.33609 .34878 m .34403 .34344 L .35654 .35122 L p F P
0 g
s
.58 .821 .99 r
.3628 .34473 m .35654 .35122 L .34403 .34344 L p F P
0 g
s
.584 .798 .981 r
.35654 .35122 m .3628 .34473 L .37515 .35023 L p F P
0 g
s
.028 .182 .689 r
.56572 .55523 m .55637 .53005 L .57542 .52314 L p F P
0 g
s
.028 .182 .689 r
.57542 .52314 m .58628 .54879 L .56572 .55523 L p F P
0 g
s
.642 .856 .981 r
.15382 .33316 m .16502 .33176 L .18268 .36696 L p F P
0 g
s
.635 .856 .984 r
.19267 .36333 m .18268 .36696 L .16502 .33176 L p F P
0 g
s
.566 .803 .988 r
.37949 .3429 m .37515 .35023 L .3628 .34473 L p F P
0 g
s
.558 .776 .98 r
.37515 .35023 m .37949 .3429 L .39077 .34629 L p F P
0 g
s
.033 .195 .701 r
.55637 .53005 m .54701 .50624 L .56459 .499 L p F P
0 g
s
.033 .195 .701 r
.56459 .499 m .57542 .52314 L .55637 .53005 L p F P
0 g
s
.404 .621 .94 r
.42995 .36048 m .42552 .35007 L .43585 .34901 L p F P
0 g
s
.404 .621 .94 r
.43585 .34901 m .44228 .3596 L .42995 .36048 L p F P
0 g
s
.329 .542 .908 r
.44864 .37136 m .44228 .3596 L .453 .35727 L p F P
0 g
s
.329 .542 .908 r
.453 .35727 m .46115 .36904 L .44864 .37136 L p F P
0 g
s
.217 .423 .849 r
.47723 .39642 m .46922 .3821 L .48086 .37789 L p F P
0 g
s
.217 .423 .849 r
.48086 .37789 m .49041 .39211 L .47723 .39642 L p F P
0 g
s
.635 .856 .984 r
.16502 .33176 m .17622 .33042 L .19267 .36333 L p F P
0 g
s
.627 .856 .986 r
.2027 .35982 m .19267 .36333 L .17622 .33042 L p F P
0 g
s
.596 .835 .99 r
.31509 .34271 m .32445 .33878 L .33609 .34878 L p F P
0 g
s
.58 .836 .993 r
.34403 .34344 m .33609 .34878 L .32445 .33878 L p F P
0 g
s
.039 .211 .714 r
.54701 .50624 m .53764 .4838 L .55379 .47637 L p F P
0 g
s
.039 .211 .714 r
.55379 .47637 m .56459 .499 L .54701 .50624 L p F P
0 g
s
.604 .847 .99 r
.27416 .3383 m .28456 .33567 L .29659 .35117 L p F P
0 g
s
.592 .847 .993 r
.3058 .34685 m .29659 .35117 L .28456 .33567 L p F P
0 g
s
.627 .856 .986 r
.17622 .33042 m .18743 .32912 L .2027 .35982 L p F P
0 g
s
.62 .856 .988 r
.21278 .35641 m .2027 .35982 L .18743 .32912 L p F P
0 g
s
.522 .758 .982 r
.40248 .34017 m .40251 .34867 L .39077 .34629 L p F P
0 g
s
.494 .725 .975 r
.40251 .34867 m .40248 .34017 L .41195 .3409 L p F P
0 g
s
.494 .725 .975 r
.41195 .3409 m .41426 .34995 L .40251 .34867 L p F P
0 g
s
.046 .228 .728 r
.53764 .4838 m .52825 .46273 L .54301 .45523 L p F P
0 g
s
.046 .228 .728 r
.54301 .45523 m .55379 .47637 L .53764 .4838 L p F P
0 g
s
.539 .786 .989 r
.393 .33855 m .39077 .34629 L .37949 .3429 L p F P
0 g
s
.522 .758 .982 r
.39077 .34629 m .393 .33855 L .40248 .34017 L p F P
0 g
s
.455 .689 .967 r
.41426 .34995 m .41195 .3409 L .42103 .34072 L p F P
0 g
s
.455 .689 .967 r
.42103 .34072 m .42552 .35007 L .41426 .34995 L p F P
0 g
s
.58 .821 .99 r
.34403 .34344 m .35206 .3384 L .3628 .34473 L p F P
0 g
s
.56 .823 .995 r
.36915 .33864 m .3628 .34473 L .35206 .3384 L p F P
0 g
s
.566 .803 .988 r
.3628 .34473 m .36915 .33864 L .37949 .3429 L p F P
0 g
s
.62 .856 .988 r
.18743 .32912 m .19865 .32788 L .21278 .35641 L p F P
0 g
s
.611 .856 .99 r
.22289 .35312 m .21278 .35641 L .19865 .32788 L p F P
0 g
s
.231 .454 .87 r
.46922 .3821 m .46115 .36904 L .47127 .36504 L p F P
0 g
s
.231 .454 .87 r
.47127 .36504 m .48086 .37789 L .46922 .3821 L p F P
0 g
s
.055 .248 .743 r
.52825 .46273 m .51883 .44303 L .53225 .43559 L p F P
0 g
s
.055 .248 .743 r
.53225 .43559 m .54301 .45523 L .52825 .46273 L p F P
0 g
s
.592 .847 .993 r
.28456 .33567 m .295 .33316 L .3058 .34685 L p F P
0 g
s
.579 .846 .995 r
.31509 .34271 m .3058 .34685 L .295 .33316 L p F P
0 g
s
.338 .575 .928 r
.44228 .3596 m .43585 .34901 L .44478 .3468 L p F P
0 g
s
.338 .575 .928 r
.44478 .3468 m .453 .35727 L .44228 .3596 L p F P
0 g
s
.544 .808 .995 r
.38391 .33611 m .37949 .3429 L .36915 .33864 L p F P
0 g
s
.539 .786 .989 r
.37949 .3429 m .38391 .33611 L .393 .33855 L p F P
0 g
s
.58 .836 .993 r
.32445 .33878 m .33389 .33503 L .34403 .34344 L p F P
0 g
s
.562 .835 .996 r
.35206 .3384 m .34403 .34344 L .33389 .33503 L p F P
0 g
s
.611 .856 .99 r
.19865 .32788 m .20988 .32669 L .22289 .35312 L p F P
0 g
s
.603 .855 .992 r
.23305 .34993 m .22289 .35312 L .20988 .32669 L p F P
0 g
s
.406 .651 .958 r
.42552 .35007 m .42103 .34072 L .42933 .33962 L p F P
0 g
s
.406 .651 .958 r
.42933 .33962 m .43585 .34901 L .42552 .35007 L p F P
0 g
s
.066 .271 .761 r
.51883 .44303 m .50939 .42469 L .52149 .41742 L p F P
0 g
s
.066 .271 .761 r
.52149 .41742 m .53225 .43559 L .51883 .44303 L p F P
0 g
s
.603 .855 .992 r
.20988 .32669 m .22111 .32555 L .23305 .34993 L p F P
0 g
s
.594 .854 .993 r
.24326 .34686 m .23305 .34993 L .22111 .32555 L p F P
0 g
s
.579 .846 .995 r
.295 .33316 m .30549 .33077 L .31509 .34271 L p F P
0 g
s
.564 .844 .997 r
.32445 .33878 m .31509 .34271 L .30549 .33077 L p F P
0 g
s
.246 .49 .892 r
.46115 .36904 m .453 .35727 L .46162 .35358 L p F P
0 g
s
.246 .49 .892 r
.46162 .35358 m .47127 .36504 L .46115 .36904 L p F P
0 g
s
.078 .296 .78 r
.50939 .42469 m .49992 .40772 L .51075 .40073 L p F P
0 g
s
.078 .296 .78 r
.51075 .40073 m .52149 .41742 L .50939 .42469 L p F P
0 g
s
.56 .823 .995 r
.35206 .3384 m .36019 .33365 L .36915 .33864 L p F P
0 g
s
.538 .823 .998 r
.37559 .33295 m .36915 .33864 L .36019 .33365 L p F P
0 g
s
.544 .808 .995 r
.36915 .33864 m .37559 .33295 L .38391 .33611 L p F P
0 g
s
.503 .771 .992 r
.40244 .33248 m .40248 .34017 L .393 .33855 L p F P
0 g
s
.481 .745 .987 r
.40248 .34017 m .40244 .33248 L .40961 .33281 L p F P
0 g
s
.481 .745 .987 r
.40961 .33281 m .41195 .3409 L .40248 .34017 L p F P
0 g
s
.594 .854 .993 r
.22111 .32555 m .23236 .32447 L .24326 .34686 L p F P
0 g
s
.585 .853 .995 r
.25351 .34389 m .24326 .34686 L .23236 .32447 L p F P
0 g
s
.516 .793 .996 r
.39526 .33148 m .393 .33855 L .38391 .33611 L p F P
0 g
s
.503 .771 .992 r
.393 .33855 m .39526 .33148 L .40244 .33248 L p F P
0 g
s
.562 .835 .996 r
.33389 .33503 m .34341 .33149 L .35206 .3384 L p F P
0 g
s
.543 .834 .999 r
.36019 .33365 m .35206 .3384 L .34341 .33149 L p F P
0 g
s
.449 .716 .981 r
.41195 .3409 m .40961 .33281 L .41647 .33246 L p F P
0 g
s
.449 .716 .981 r
.41647 .33246 m .42103 .34072 L .41195 .3409 L p F P
0 g
s
.093 .325 .8 r
.49992 .40772 m .49041 .39211 L .5 .38551 L p F P
0 g
s
.093 .325 .8 r
.5 .38551 m .51075 .40073 L .49992 .40772 L p F P
0 g
s
.349 .612 .949 r
.43585 .34901 m .42933 .33962 L .43647 .33764 L p F P
0 g
s
.349 .612 .949 r
.43647 .33764 m .44478 .3468 L .43585 .34901 L p F P
0 g
s
.564 .844 .997 r
.30549 .33077 m .31604 .32849 L .32445 .33878 L p F P
0 g
s
.549 .842 .998 r
.33389 .33503 m .32445 .33878 L .31604 .32849 L p F P
0 g
s
.585 .853 .995 r
.23236 .32447 m .24361 .32344 L .25351 .34389 L p F P
0 g
s
.575 .852 .996 r
.26381 .34104 m .25351 .34389 L .24361 .32344 L p F P
0 g
s
.519 .811 .999 r
.38839 .32986 m .38391 .33611 L .37559 .33295 L p F P
0 g
s
.516 .793 .996 r
.38391 .33611 m .38839 .32986 L .39526 .33148 L p F P
0 g
s
.263 .529 .915 r
.453 .35727 m .44478 .3468 L .45191 .34351 L p F P
0 g
s
.263 .529 .915 r
.45191 .34351 m .46162 .35358 L .453 .35727 L p F P
0 g
s
.408 .684 .975 r
.42103 .34072 m .41647 .33246 L .42272 .33145 L p F P
0 g
s
.408 .684 .975 r
.42272 .33145 m .42933 .33962 L .42103 .34072 L p F P
0 g
s
.11 .358 .823 r
.49041 .39211 m .48086 .37789 L .48924 .37175 L p F P
0 g
s
.11 .358 .823 r
.48924 .37175 m .5 .38551 L .49041 .39211 L p F P
0 g
s
.575 .852 .996 r
.24361 .32344 m .25488 .32246 L .26381 .34104 L p F P
0 g
s
.565 .851 .997 r
.27416 .3383 m .26381 .34104 L .25488 .32246 L p F P
0 g
s
.549 .842 .998 r
.31604 .32849 m .32663 .32632 L .33389 .33503 L p F P
0 g
s
.533 .839 .999 r
.34341 .33149 m .33389 .33503 L .32663 .32632 L p F P
0 g
s
.543 .834 .999 r
.34341 .33149 m .35302 .32814 L .36019 .33365 L p F P
0 g
s
.522 .831 1 r
.36841 .3292 m .36019 .33365 L .35302 .32814 L p F P
0 g
s
.538 .823 .998 r
.36019 .33365 m .36841 .3292 L .37559 .33295 L p F P
0 g
s
.13 .395 .847 r
.48086 .37789 m .47127 .36504 L .47848 .35945 L p F P
0 g
s
.13 .395 .847 r
.47848 .35945 m .48924 .37175 L .48086 .37789 L p F P
0 g
s
.513 .822 1 r
.38212 .32769 m .37559 .33295 L .36841 .3292 L p F P
0 g
s
.519 .811 .999 r
.37559 .33295 m .38212 .32769 L .38839 .32986 L p F P
0 g
s
.565 .851 .997 r
.25488 .32246 m .26616 .32153 L .27416 .3383 L p F P
0 g
s
.555 .849 .998 r
.28456 .33567 m .27416 .3383 L .26616 .32153 L p F P
0 g
s
.36 .653 .967 r
.42933 .33962 m .42272 .33145 L .42808 .32981 L p F P
0 g
s
.36 .653 .967 r
.42808 .32981 m .43647 .33764 L .42933 .33962 L p F P
0 g
s
.283 .573 .938 r
.44478 .3468 m .43647 .33764 L .44214 .33485 L p F P
0 g
s
.283 .573 .938 r
.44214 .33485 m .45191 .34351 L .44478 .3468 L p F P
0 g
s
.479 .783 .998 r
.4024 .32562 m .40244 .33248 L .39526 .33148 L p F P
0 g
s
.463 .764 .995 r
.40244 .33248 m .4024 .32562 L .40723 .32569 L p F P
0 g
s
.463 .764 .995 r
.40723 .32569 m .40961 .33281 L .40244 .33248 L p F P
0 g
s
.488 .799 .999 r
.39757 .3251 m .39526 .33148 L .38839 .32986 L p F P
0 g
s
.479 .783 .998 r
.39526 .33148 m .39757 .3251 L .4024 .32562 L p F P
0 g
s
.555 .849 .998 r
.26616 .32153 m .27744 .32065 L .28456 .33567 L p F P
0 g
s
.544 .847 .998 r
.295 .33316 m .28456 .33567 L .27744 .32065 L p F P
0 g
s
.438 .742 .992 r
.40961 .33281 m .40723 .32569 L .41183 .32532 L p F P
0 g
s
.438 .742 .992 r
.41183 .32532 m .41647 .33246 L .40961 .33281 L p F P
0 g
s
.154 .437 .872 r
.47127 .36504 m .46162 .35358 L .46769 .34862 L p F P
0 g
s
.154 .437 .872 r
.46769 .34862 m .47848 .35945 L .47127 .36504 L p F P
0 g
s
.533 .839 .999 r
.32663 .32632 m .33728 .32427 L .34341 .33149 L p F P
0 g
s
.516 .836 .999 r
.35302 .32814 m .34341 .33149 L .33728 .32427 L p F P
0 g
s
.49 .811 1 r
.39296 .32417 m .38839 .32986 L .38212 .32769 L p F P
0 g
s
.488 .799 .999 r
.38839 .32986 m .39296 .32417 L .39757 .3251 L p F P
0 g
s
.407 .719 .988 r
.41647 .33246 m .41183 .32532 L .41602 .32452 L p F P
0 g
s
.407 .719 .988 r
.41602 .32452 m .42272 .33145 L .41647 .33246 L p F P
0 g
s
.544 .847 .998 r
.27744 .32065 m .28874 .31983 L .295 .33316 L p F P
0 g
s
.532 .844 .999 r
.30549 .33077 m .295 .33316 L .28874 .31983 L p F P
0 g
s
.522 .831 1 r
.35302 .32814 m .3627 .325 L .36841 .3292 L p F P
0 g
s
.498 .827 .999 r
.37673 .32505 m .36841 .3292 L .3627 .325 L p F P
0 g
s
.513 .822 1 r
.36841 .3292 m .37673 .32505 L .38212 .32769 L p F P
0 g
s
.182 .484 .899 r
.46162 .35358 m .45191 .34351 L .45689 .33925 L p F P
0 g
s
.182 .484 .899 r
.45689 .33925 m .46769 .34862 L .46162 .35358 L p F P
0 g
s
.306 .622 .959 r
.43647 .33764 m .42808 .32981 L .43231 .3276 L p F P
0 g
s
.306 .622 .959 r
.43231 .3276 m .44214 .33485 L .43647 .33764 L p F P
0 g
s
.532 .844 .999 r
.28874 .31983 m .30004 .31906 L .30549 .33077 L p F P
0 g
s
.521 .841 .999 r
.31604 .32849 m .30549 .33077 L .30004 .31906 L p F P
0 g
s
.484 .818 .999 r
.38875 .32285 m .38212 .32769 L .37673 .32505 L p F P
0 g
s
.49 .811 1 r
.38212 .32769 m .38875 .32285 L .39296 .32417 L p F P
0 g
s
.516 .836 .999 r
.33728 .32427 m .34798 .32234 L .35302 .32814 L p F P
0 g
s
.498 .832 .999 r
.3627 .325 m .35302 .32814 L .34798 .32234 L p F P
0 g
s
.371 .696 .983 r
.42272 .33145 m .41602 .32452 L .4196 .32333 L p F P
0 g
s
.371 .696 .983 r
.4196 .32333 m .42808 .32981 L .42272 .33145 L p F P
0 g
s
.521 .841 .999 r
.30004 .31906 m .31136 .31834 L .31604 .32849 L p F P
0 g
s
.509 .838 .998 r
.32663 .32632 m .31604 .32849 L .31136 .31834 L p F P
0 g
s
.213 .536 .925 r
.45191 .34351 m .44214 .33485 L .44605 .33135 L p F P
0 g
s
.213 .536 .925 r
.44605 .33135 m .45689 .33925 L .45191 .34351 L p F P
0 g
s
0 .098 .646 r
.57542 .52314 m .56459 .499 L .57566 .48668 L p F P
0 g
s
0 .116 .661 r
.56459 .499 m .55379 .47637 L .56378 .46441 L p F P
0 g
s
0 .116 .661 r
.56378 .46441 m .57566 .48668 L .56459 .499 L p F P
0 g
s
0 .081 .632 r
.58628 .54879 m .57542 .52314 L .58761 .51056 L p F P
0 g
s
0 .098 .646 r
.57566 .48668 m .58761 .51056 L .57542 .52314 L p F P
0 g
s
0 .137 .678 r
.55379 .47637 m .54301 .45523 L .55198 .44375 L p F P
0 g
s
0 .137 .678 r
.55198 .44375 m .56378 .46441 L .55379 .47637 L p F P
0 g
s
.449 .792 .998 r
.40236 .31962 m .4024 .32562 L .39757 .3251 L p F P
0 g
s
.438 .78 .998 r
.4024 .32562 m .40236 .31962 L .4048 .31958 L p F P
0 g
s
.438 .78 .998 r
.4048 .31958 m .40723 .32569 L .4024 .32562 L p F P
0 g
s
0 .067 .62 r
.59717 .57599 m .58628 .54879 L .59964 .53609 L p F P
0 g
s
0 .081 .632 r
.58761 .51056 m .59964 .53609 L .58628 .54879 L p F P
0 g
s
0 .161 .696 r
.54301 .45523 m .53225 .43559 L .54025 .42468 L p F P
0 g
s
0 .161 .696 r
.54025 .42468 m .55198 .44375 L .54301 .45523 L p F P
0 g
s
.454 .801 .998 r
.39993 .31944 m .39757 .3251 L .39296 .32417 L p F P
0 g
s
.449 .792 .998 r
.39757 .3251 m .39993 .31944 L .40236 .31962 L p F P
0 g
s
0 .054 .609 r
.60811 .60473 m .59717 .57599 L .61177 .56329 L p F P
0 g
s
0 .067 .62 r
.59964 .53609 m .61177 .56329 L .59717 .57599 L p F P
0 g
s
.498 .827 .999 r
.3627 .325 m .37247 .32206 L .37673 .32505 L p F P
0 g
s
.473 .821 .998 r
.38516 .32122 m .37673 .32505 L .37247 .32206 L p F P
0 g
s
.484 .818 .999 r
.37673 .32505 m .38516 .32122 L .38875 .32285 L p F P
0 g
s
.423 .767 .996 r
.40723 .32569 m .4048 .31958 L .40712 .31933 L p F P
0 g
s
.423 .767 .996 r
.40712 .31933 m .41183 .32532 L .40723 .32569 L p F P
0 g
s
0 .188 .717 r
.53225 .43559 m .52149 .41742 L .52857 .40716 L p F P
0 g
s
0 .188 .717 r
.52857 .40716 m .54025 .42468 L .53225 .43559 L p F P
0 g
s
0 .043 .598 r
.6191 .63505 m .60811 .60473 L .624 .59219 L p F P
0 g
s
0 .054 .609 r
.61177 .56329 m .624 .59219 L .60811 .60473 L p F P
0 g
s
.498 .832 .999 r
.34798 .32234 m .35874 .32053 L .3627 .325 L p F P
0 g
s
.478 .827 .997 r
.37247 .32206 m .3627 .325 L .35874 .32053 L p F P
0 g
s
.33 .673 .977 r
.42808 .32981 m .4196 .32333 L .42239 .32178 L p F P
0 g
s
.33 .673 .977 r
.42239 .32178 m .43231 .3276 L .42808 .32981 L p F P
0 g
s
.509 .838 .998 r
.31136 .31834 m .32269 .31768 L .32663 .32632 L p F P
0 g
s
.496 .835 .998 r
.33728 .32427 m .32663 .32632 L .32269 .31768 L p F P
0 g
s
0 .219 .739 r
.52149 .41742 m .51075 .40073 L .51695 .3912 L p F P
0 g
s
0 .219 .739 r
.51695 .3912 m .52857 .40716 L .52149 .41742 L p F P
0 g
s
.455 .808 .997 r
.3976 .31904 m .39296 .32417 L .38875 .32285 L p F P
0 g
s
.454 .801 .998 r
.39296 .32417 m .3976 .31904 L .39993 .31944 L p F P
0 g
s
0 .033 .589 r
.63015 .66694 m .6191 .63505 L .63633 .62281 L p F P
0 g
s
0 .043 .598 r
.624 .59219 m .63633 .62281 L .6191 .63505 L p F P
0 g
s
.403 .753 .994 r
.41183 .32532 m .40712 .31933 L .40922 .31886 L p F P
0 g
s
.403 .753 .994 r
.40922 .31886 m .41602 .32452 L .41183 .32532 L p F P
0 g
s
0 .253 .763 r
.51075 .40073 m .5 .38551 L .50537 .37677 L p F P
0 g
s
0 .253 .763 r
.50537 .37677 m .51695 .3912 L .51075 .40073 L p F P
0 g
s
.249 .593 .949 r
.44214 .33485 m .43231 .3276 L .43519 .32492 L p F P
0 g
s
.249 .593 .949 r
.43519 .32492 m .44605 .33135 L .44214 .33485 L p F P
0 g
s
0 .024 .581 r
.64125 .70045 m .63015 .66694 L .64878 .65519 L p F P
0 g
s
0 .033 .589 r
.63633 .62281 m .64878 .65519 L .63015 .66694 L p F P
0 g
s
0 .293 .79 r
.5 .38551 m .48924 .37175 L .49384 .36387 L p F P
0 g
s
0 .293 .79 r
.49384 .36387 m .50537 .37677 L .5 .38551 L p F P
0 g
s
0 .016 .574 r
.65242 .73558 m .64125 .70045 L .66135 .68936 L p F P
0 g
s
0 .024 .581 r
.64878 .65519 m .66135 .68936 L .64125 .70045 L p F P
0 g
s
.496 .835 .998 r
.32269 .31768 m .33403 .31706 L .33728 .32427 L p F P
0 g
s
.483 .831 .997 r
.34798 .32234 m .33728 .32427 L .33403 .31706 L p F P
0 g
s
.452 .812 .996 r
.39549 .31845 m .38875 .32285 L .38516 .32122 L p F P
0 g
s
.455 .808 .997 r
.38875 .32285 m .39549 .31845 L .3976 .31904 L p F P
0 g
s
.024 .337 .818 r
.48924 .37175 m .47848 .35945 L .48234 .35248 L p F P
0 g
s
.024 .337 .818 r
.48234 .35248 m .49384 .36387 L .48924 .37175 L p F P
0 g
s
.381 .739 .991 r
.41602 .32452 m .40922 .31886 L .41101 .31822 L p F P
0 g
s
.381 .739 .991 r
.41101 .31822 m .4196 .32333 L .41602 .32452 L p F P
0 g
s
0 .009 .567 r
.66366 .77237 m .65242 .73558 L .67404 .72535 L p F P
0 g
s
0 .016 .574 r
.66135 .68936 m .67404 .72535 L .65242 .73558 L p F P
0 g
s
.058 .387 .848 r
.47848 .35945 m .46769 .34862 L .47086 .34259 L p F P
0 g
s
.058 .387 .848 r
.47086 .34259 m .48234 .35248 L .47848 .35945 L p F P
0 g
s
.595 .86 .993 r
.08682 .34263 m .07568 .34439 L .05908 .29635 L p F P
0 g
s
.478 .827 .997 r
.35874 .32053 m .36955 .31884 L .37247 .32206 L p F P
0 g
s
.458 .821 .995 r
.38233 .31933 m .37247 .32206 L .36955 .31884 L p F P
0 g
s
.473 .821 .998 r
.37247 .32206 m .38233 .31933 L .38516 .32122 L p F P
0 g
s
.595 .86 .993 r
.05908 .29635 m .07147 .29686 L .08682 .34263 L p F P
0 g
s
.59 .859 .994 r
.09797 .34092 m .08682 .34263 L .07147 .29686 L p F P
0 g
s
.483 .831 .997 r
.33403 .31706 m .34538 .3165 L .34798 .32234 L p F P
0 g
s
.469 .827 .996 r
.35874 .32053 m .34798 .32234 L .34538 .3165 L p F P
0 g
s
0 .003 .561 r
.67498 .81084 m .66366 .77237 L .68688 .7632 L p F P
0 g
s
0 .009 .567 r
.67404 .72535 m .68688 .7632 L .66366 .77237 L p F P
0 g
s
.59 .859 .994 r
.07147 .29686 m .08382 .29738 L .09797 .34092 L p F P
0 g
s
.585 .858 .995 r
.10913 .33927 m .09797 .34092 L .08382 .29738 L p F P
0 g
s
.289 .653 .969 r
.43231 .3276 m .42239 .32178 L .42428 .31996 L p F P
0 g
s
.289 .653 .969 r
.42428 .31996 m .43519 .32492 L .43231 .3276 L p F P
0 g
s
.445 .814 .994 r
.39369 .3177 m .38516 .32122 L .38233 .31933 L p F P
0 g
s
.452 .812 .996 r
.38516 .32122 m .39369 .3177 L .39549 .31845 L p F P
0 g
s
.585 .858 .995 r
.08382 .29738 m .09613 .29791 L .10913 .33927 L p F P
0 g
s
.579 .857 .996 r
.12029 .33766 m .10913 .33927 L .09613 .29791 L p F P
0 g
s
.097 .442 .879 r
.46769 .34862 m .45689 .33925 L .45942 .33419 L p F P
0 g
s
.097 .442 .879 r
.45942 .33419 m .47086 .34259 L .46769 .34862 L p F P
0 g
s
.356 .726 .987 r
.4196 .32333 m .41101 .31822 L .4124 .31741 L p F P
0 g
s
.356 .726 .987 r
.4124 .31741 m .42239 .32178 L .4196 .32333 L p F P
0 g
s
.579 .857 .996 r
.09613 .29791 m .10839 .29844 L .12029 .33766 L p F P
0 g
s
.574 .857 .996 r
.13146 .33611 m .12029 .33766 L .10839 .29844 L p F P
0 g
s
.574 .857 .996 r
.10839 .29844 m .12061 .29898 L .13146 .33611 L p F P
0 g
s
.568 .856 .997 r
.14264 .33461 m .13146 .33611 L .12061 .29898 L p F P
0 g
s
0 0 .556 r
.68639 .85101 m .67498 .81084 L .69985 .80296 L p F P
0 g
s
0 .003 .561 r
.68688 .7632 m .69985 .80296 L .67498 .81084 L p F P
0 g
s
.568 .856 .997 r
.12061 .29898 m .1328 .29954 L .14264 .33461 L p F P
0 g
s
.563 .854 .997 r
.15382 .33316 m .14264 .33461 L .1328 .29954 L p F P
0 g
s
.563 .854 .997 r
.1328 .29954 m .14494 .3001 L .15382 .33316 L p F P
0 g
s
.557 .853 .998 r
.16502 .33176 m .15382 .33316 L .14494 .3001 L p F P
0 g
s
.142 .503 .909 r
.45689 .33925 m .44605 .33135 L .44799 .32729 L p F P
0 g
s
.142 .503 .909 r
.44799 .32729 m .45942 .33419 L .45689 .33925 L p F P
0 g
s
.469 .827 .996 r
.34538 .3165 m .35675 .316 L .35874 .32053 L p F P
0 g
s
.455 .822 .994 r
.36955 .31884 m .35874 .32053 L .35675 .316 L p F P
0 g
s
.557 .853 .998 r
.14494 .3001 m .15704 .30067 L .16502 .33176 L p F P
0 g
s
.551 .852 .998 r
.17622 .33042 m .16502 .33176 L .15704 .30067 L p F P
0 g
s
.551 .852 .998 r
.15704 .30067 m .1691 .30124 L .17622 .33042 L p F P
0 g
s
.545 .851 .998 r
.18743 .32912 m .17622 .33042 L .1691 .30124 L p F P
0 g
s
.411 .795 .99 r
.40232 .3145 m .40236 .31962 L .39993 .31944 L closepath p F P
0 g
s
.406 .791 .99 r
.40232 .3145 m .4048 .31958 L .40236 .31962 L closepath p F P
0 g
s
0 0 .551 r
.69788 .89292 m .68639 .85101 L .71299 .84466 L p F P
0 g
s
0 0 .556 r
.69985 .80296 m .71299 .84466 L .68639 .85101 L p F P
0 g
s
.545 .851 .998 r
.1691 .30124 m .18113 .30183 L .18743 .32912 L p F P
0 g
s
.539 .849 .998 r
.19865 .32788 m .18743 .32912 L .18113 .30183 L p F P
0 g
s
.414 .798 .99 r
.40232 .3145 m .39993 .31944 L .3976 .31904 L closepath p F P
0 g
s
.401 .788 .99 r
.40232 .3145 m .40712 .31933 L .4048 .31958 L closepath p F P
0 g
s
.458 .821 .995 r
.36955 .31884 m .38042 .31727 L .38233 .31933 L p F P
0 g
s
.436 .814 .992 r
.39228 .31681 m .38233 .31933 L .38042 .31727 L p F P
0 g
s
.445 .814 .994 r
.38233 .31933 m .39228 .31681 L .39369 .3177 L p F P
0 g
s
.539 .849 .998 r
.18113 .30183 m .19311 .30242 L .19865 .32788 L p F P
0 g
s
.532 .848 .998 r
.20988 .32669 m .19865 .32788 L .19311 .30242 L p F P
0 g
s
.193 .568 .937 r
.44605 .33135 m .43519 .32492 L .43657 .32187 L p F P
0 g
s
.193 .568 .937 r
.43657 .32187 m .44799 .32729 L .44605 .33135 L p F P
0 g
s
.416 .801 .99 r
.40232 .3145 m .3976 .31904 L .39549 .31845 L closepath p F P
0 g
s
.395 .784 .989 r
.40232 .3145 m .40922 .31886 L .40712 .31933 L closepath p F P
0 g
s
.331 .715 .983 r
.42239 .32178 m .4124 .31741 L .41333 .31648 L p F P
0 g
s
.331 .715 .983 r
.41333 .31648 m .42428 .31996 L .42239 .32178 L p F P
0 g
s
.532 .848 .998 r
.19311 .30242 m .20505 .30303 L .20988 .32669 L p F P
0 g
s
.526 .846 .998 r
.22111 .32555 m .20988 .32669 L .20505 .30303 L p F P
0 g
s
.526 .846 .998 r
.20505 .30303 m .21696 .30364 L .22111 .32555 L p F P
0 g
s
.519 .844 .998 r
.23236 .32447 m .22111 .32555 L .21696 .30364 L p F P
0 g
s
.455 .822 .994 r
.35675 .316 m .36812 .31554 L .36955 .31884 L p F P
0 g
s
.441 .817 .992 r
.38042 .31727 m .36955 .31884 L .36812 .31554 L p F P
0 g
s
.416 .804 .989 r
.40232 .3145 m .39549 .31845 L .39369 .3177 L closepath p F P
0 g
s
.519 .844 .998 r
.21696 .30364 m .22883 .30426 L .23236 .32447 L p F P
0 g
s
.512 .842 .998 r
.24361 .32344 m .23236 .32447 L .22883 .30426 L p F P
0 g
s
.389 .78 .988 r
.40232 .3145 m .41101 .31822 L .40922 .31886 L closepath p F P
0 g
s
0 0 .546 r
.70947 .93659 m .69788 .89292 L .72628 .88835 L p F P
0 g
s
0 0 .551 r
.71299 .84466 m .72628 .88835 L .69788 .89292 L p F P
0 g
s
.512 .842 .998 r
.22883 .30426 m .24065 .30488 L .24361 .32344 L p F P
0 g
s
.506 .84 .998 r
.25488 .32246 m .24361 .32344 L .24065 .30488 L p F P
0 g
s
.248 .637 .961 r
.43519 .32492 m .42428 .31996 L .42515 .31793 L p F P
0 g
s
.248 .637 .961 r
.42515 .31793 m .43657 .32187 L .43519 .32492 L p F P
0 g
s
.506 .84 .998 r
.24065 .30488 m .25244 .30552 L .25488 .32246 L p F P
0 g
s
.499 .838 .997 r
.26616 .32153 m .25488 .32246 L .25244 .30552 L p F P
0 g
s
.416 .805 .988 r
.40232 .3145 m .39369 .3177 L .39228 .31681 L closepath p F P
0 g
s
.499 .838 .997 r
.25244 .30552 m .26419 .30616 L .26616 .32153 L p F P
0 g
s
.492 .836 .997 r
.27744 .32065 m .26616 .32153 L .26419 .30616 L p F P
0 g
s
.382 .777 .987 r
.40232 .3145 m .4124 .31741 L .41101 .31822 L closepath p F P
0 g
s
.492 .836 .997 r
.26419 .30616 m .27591 .30681 L .27744 .32065 L p F P
0 g
s
.484 .834 .996 r
.28874 .31983 m .27744 .32065 L .27591 .30681 L p F P
0 g
s
0 0 .542 r
.72117 .98207 m .70947 .93659 L .73974 .93408 L p F P
0 g
s
0 0 .546 r
.72628 .88835 m .73974 .93408 L .70947 .93659 L p F P
0 g
s
.484 .834 .996 r
.27591 .30681 m .28758 .30747 L .28874 .31983 L p F P
0 g
s
.477 .832 .996 r
.30004 .31906 m .28874 .31983 L .28758 .30747 L p F P
0 g
s
.441 .817 .992 r
.36812 .31554 m .37951 .31514 L .38042 .31727 L p F P
0 g
s
.426 .812 .989 r
.39134 .31582 m .38042 .31727 L .37951 .31514 L p F P
0 g
s
.436 .814 .992 r
.38042 .31727 m .39134 .31582 L .39228 .31681 L p F P
0 g
s
.308 .706 .978 r
.42428 .31996 m .41333 .31648 L .41374 .31548 L p F P
0 g
s
.308 .706 .978 r
.41374 .31548 m .42515 .31793 L .42428 .31996 L p F P
0 g
s
.477 .832 .996 r
.28758 .30747 m .29922 .30814 L .30004 .31906 L p F P
0 g
s
.47 .829 .995 r
.31136 .31834 m .30004 .31906 L .29922 .30814 L p F P
0 g
s
.414 .806 .987 r
.40232 .3145 m .39228 .31681 L .39134 .31582 L closepath p F P
0 g
s
.375 .774 .986 r
.40232 .3145 m .41333 .31648 L .4124 .31741 L closepath p F P
0 g
s
.47 .829 .995 r
.29922 .30814 m .31082 .30881 L .31136 .31834 L p F P
0 g
s
.462 .826 .994 r
.32269 .31768 m .31136 .31834 L .31082 .30881 L p F P
0 g
s
.462 .826 .994 r
.31082 .30881 m .32239 .3095 L .32269 .31768 L p F P
0 g
s
.454 .824 .993 r
.33403 .31706 m .32269 .31768 L .32239 .3095 L p F P
0 g
s
0 0 .542 r
.73974 .93408 m .75339 .9819 L .72117 .98207 L p F P
0 g
s
.454 .824 .993 r
.32239 .3095 m .33392 .31019 L .33403 .31706 L p F P
0 g
s
.446 .821 .992 r
.34538 .3165 m .33403 .31706 L .33392 .31019 L p F P
0 g
s
.446 .821 .992 r
.33392 .31019 m .34541 .31089 L .34538 .3165 L p F P
0 g
s
.439 .818 .991 r
.35675 .316 m .34538 .3165 L .34541 .31089 L p F P
0 g
s
.426 .812 .989 r
.37951 .31514 m .39091 .31479 L .39134 .31582 L p F P
0 g
s
.41 .806 .986 r
.40232 .3145 m .39134 .31582 L .39091 .31479 L closepath p F P
0 g
s
.369 .772 .984 r
.40232 .3145 m .41374 .31548 L .41333 .31648 L closepath p F P
0 g
s
.439 .818 .991 r
.34541 .31089 m .35686 .31159 L .35675 .316 L p F P
0 g
s
.43 .815 .989 r
.36812 .31554 m .35675 .316 L .35686 .31159 L p F P
0 g
s
.43 .815 .989 r
.35686 .31159 m .36828 .31231 L .36812 .31554 L p F P
0 g
s
.422 .812 .988 r
.37951 .31514 m .36812 .31554 L .36828 .31231 L p F P
0 g
s
.422 .812 .988 r
.36828 .31231 m .37966 .31303 L .37951 .31514 L p F P
0 g
s
.414 .808 .986 r
.39091 .31479 m .37951 .31514 L .37966 .31303 L p F P
0 g
s
.141 .55 .924 r
.44799 .32729 m .43657 .32187 L .43636 .3186 L p F P
0 g
s
.213 .626 .952 r
.43657 .32187 m .42515 .31793 L .42497 .3158 L p F P
0 g
s
.213 .626 .952 r
.42497 .3158 m .43636 .3186 L .43657 .32187 L p F P
0 g
s
.288 .7 .973 r
.42515 .31793 m .41374 .31548 L .41362 .31444 L p F P
0 g
s
.288 .7 .973 r
.41362 .31444 m .42497 .3158 L .42515 .31793 L p F P
0 g
s
.075 .477 .892 r
.45942 .33419 m .44799 .32729 L .4478 .32285 L p F P
0 g
s
.141 .55 .924 r
.43636 .3186 m .4478 .32285 L .44799 .32729 L p F P
0 g
s
.414 .808 .986 r
.37966 .31303 m .39101 .31376 L .39091 .31479 L p F P
0 g
s
.405 .805 .984 r
.40232 .3145 m .39091 .31479 L .39101 .31376 L closepath p F P
0 g
s
.364 .77 .983 r
.40232 .3145 m .41362 .31444 L .41374 .31548 L closepath p F P
0 g
s
.016 .407 .856 r
.47086 .34259 m .45942 .33419 L .4593 .32855 L p F P
0 g
s
.075 .477 .892 r
.4478 .32285 m .4593 .32855 L .45942 .33419 L p F P
0 g
s
.358 .778 .977 r
.40232 .3145 m .40353 .3101 L .40597 .3104 L closepath p F P
0 g
s
.362 .782 .977 r
.40232 .3145 m .40103 .31003 L .40353 .3101 L closepath p F P
0 g
s
.367 .785 .977 r
.40232 .3145 m .3986 .31018 L .40103 .31003 L closepath p F P
0 g
s
.373 .789 .978 r
.40232 .3145 m .39634 .31056 L .3986 .31018 L closepath p F P
0 g
s
.38 .793 .979 r
.40232 .3145 m .39437 .31113 L .39634 .31056 L closepath p F P
0 g
s
.387 .797 .98 r
.40232 .3145 m .39278 .31189 L .39437 .31113 L closepath p F P
0 g
s
.394 .8 .981 r
.40232 .3145 m .39164 .31278 L .39278 .31189 L closepath p F P
0 g
s
.4 .803 .983 r
.40232 .3145 m .39101 .31376 L .39164 .31278 L closepath p F P
0 g
s
.36 .77 .981 r
.40232 .3145 m .41297 .31341 L .41362 .31444 L closepath p F P
0 g
s
.357 .77 .98 r
.40232 .3145 m .41182 .31246 L .41297 .31341 L closepath p F P
0 g
s
.355 .771 .979 r
.40232 .3145 m .41022 .31161 L .41182 .31246 L closepath p F P
0 g
s
.354 .772 .978 r
.40232 .3145 m .40824 .31091 L .41022 .31161 L closepath p F P
0 g
s
.356 .775 .977 r
.40232 .3145 m .40597 .3104 L .40824 .31091 L closepath p F P
0 g
s
0 .343 .82 r
.48234 .35248 m .47086 .34259 L .47088 .33571 L p F P
0 g
s
.016 .407 .856 r
.4593 .32855 m .47088 .33571 L .47086 .34259 L p F P
0 g
s
0 .285 .784 r
.49384 .36387 m .48234 .35248 L .48252 .34437 L p F P
0 g
s
0 .343 .82 r
.47088 .33571 m .48252 .34437 L .48234 .35248 L p F P
0 g
s
0 .232 .75 r
.50537 .37677 m .49384 .36387 L .49424 .35452 L p F P
0 g
s
0 .285 .784 r
.48252 .34437 m .49424 .35452 L .49384 .36387 L p F P
0 g
s
.402 .804 .983 r
.38089 .31104 m .39164 .31278 L .39101 .31376 L p F P
0 g
s
.402 .804 .983 r
.39101 .31376 m .37966 .31303 L .38089 .31104 L p F P
0 g
s
.273 .698 .967 r
.42497 .3158 m .41362 .31444 L .41297 .31341 L p F P
0 g
s
0 .186 .718 r
.51695 .3912 m .50537 .37677 L .50605 .3662 L p F P
0 g
s
0 .232 .75 r
.49424 .35452 m .50605 .3662 L .50537 .37677 L p F P
0 g
s
.403 .805 .984 r
.37005 .3093 m .38089 .31104 L .37966 .31303 L p F P
0 g
s
.403 .805 .984 r
.37966 .31303 m .36828 .31231 L .37005 .3093 L p F P
0 g
s
0 .144 .689 r
.52857 .40716 m .51695 .3912 L .51794 .37941 L p F P
0 g
s
0 .186 .718 r
.50605 .3662 m .51794 .37941 L .51695 .3912 L p F P
0 g
s
.185 .621 .944 r
.43636 .3186 m .42497 .3158 L .42371 .31366 L p F P
0 g
s
.273 .698 .967 r
.41297 .31341 m .42371 .31366 L .42497 .3158 L p F P
0 g
s
.389 .798 .98 r
.38313 .30927 m .39278 .31189 L .39164 .31278 L p F P
0 g
s
.389 .798 .98 r
.39164 .31278 m .38089 .31104 L .38313 .30927 L p F P
0 g
s
.264 .701 .963 r
.42371 .31366 m .41297 .31341 L .41182 .31246 L p F P
0 g
s
.405 .805 .984 r
.35914 .30754 m .37005 .3093 L .36828 .31231 L p F P
0 g
s
.405 .805 .984 r
.36828 .31231 m .35686 .31159 L .35914 .30754 L p F P
0 g
s
0 .107 .662 r
.54025 .42468 m .52857 .40716 L .52994 .39418 L p F P
0 g
s
0 .144 .689 r
.51794 .37941 m .52994 .39418 L .52857 .40716 L p F P
0 g
s
.375 .792 .977 r
.3863 .30781 m .39437 .31113 L .39278 .31189 L p F P
0 g
s
.375 .792 .977 r
.39278 .31189 m .38313 .30927 L .3863 .30781 L p F P
0 g
s
.1 .541 .911 r
.4478 .32285 m .43636 .3186 L .43453 .31526 L p F P
0 g
s
.185 .621 .944 r
.42371 .31366 m .43453 .31526 L .43636 .3186 L p F P
0 g
s
.264 .701 .963 r
.41182 .31246 m .42143 .31162 L .42371 .31366 L p F P
0 g
s
.263 .707 .96 r
.42143 .31162 m .41182 .31246 L .41022 .31161 L p F P
0 g
s
0 .075 .637 r
.55198 .44375 m .54025 .42468 L .54204 .41054 L p F P
0 g
s
0 .107 .662 r
.52994 .39418 m .54204 .41054 L .54025 .42468 L p F P
0 g
s
.407 .806 .984 r
.34814 .30577 m .35914 .30754 L .35686 .31159 L p F P
0 g
s
.407 .806 .984 r
.35686 .31159 m .34541 .31089 L .34814 .30577 L p F P
0 g
s
.36 .785 .974 r
.39026 .30673 m .39634 .31056 L .39437 .31113 L p F P
0 g
s
.36 .785 .974 r
.39437 .31113 m .3863 .30781 L .39026 .30673 L p F P
0 g
s
.384 .796 .979 r
.37338 .30666 m .38313 .30927 L .38089 .31104 L p F P
0 g
s
.384 .796 .979 r
.38089 .31104 m .37005 .3093 L .37338 .30666 L p F P
0 g
s
.263 .707 .96 r
.41022 .31161 m .41823 .30976 L .42143 .31162 L p F P
0 g
s
.267 .716 .958 r
.41823 .30976 m .41022 .31161 L .40824 .31091 L p F P
0 g
s
.169 .624 .936 r
.43453 .31526 m .42371 .31366 L .42143 .31162 L p F P
0 g
s
0 .046 .615 r
.56378 .46441 m .55198 .44375 L .55426 .4285 L p F P
0 g
s
0 .075 .637 r
.54204 .41054 m .55426 .4285 L .55198 .44375 L p F P
0 g
s
.02 .461 .874 r
.4593 .32855 m .4478 .32285 L .44545 .31822 L p F P
0 g
s
.1 .541 .911 r
.43453 .31526 m .44545 .31822 L .4478 .32285 L p F P
0 g
s
.409 .807 .985 r
.33706 .30399 m .34814 .30577 L .34541 .31089 L p F P
0 g
s
.409 .807 .985 r
.34541 .31089 m .33392 .31019 L .33706 .30399 L p F P
0 g
s
.344 .776 .97 r
.3948 .30609 m .3986 .31018 L .39634 .31056 L p F P
0 g
s
.344 .776 .97 r
.39634 .31056 m .39026 .30673 L .3948 .30609 L p F P
0 g
s
.267 .716 .958 r
.40824 .31091 m .41425 .3082 L .41823 .30976 L p F P
0 g
s
.278 .728 .958 r
.41425 .3082 m .40824 .31091 L .40597 .3104 L p F P
0 g
s
.327 .765 .966 r
.39972 .30591 m .40103 .31003 L .3986 .31018 L p F P
0 g
s
.327 .765 .966 r
.3986 .31018 m .3948 .30609 L .39972 .30591 L p F P
0 g
s
.292 .741 .96 r
.40969 .307 m .40597 .3104 L .40353 .3101 L p F P
0 g
s
.278 .728 .958 r
.40597 .3104 m .40969 .307 L .41425 .3082 L p F P
0 g
s
.41 .808 .985 r
.3259 .3022 m .33706 .30399 L .33392 .31019 L p F P
0 g
s
.41 .808 .985 r
.33392 .31019 m .32239 .3095 L .3259 .3022 L p F P
0 g
s
0 .021 .594 r
.57566 .48668 m .56378 .46441 L .56659 .4481 L p F P
0 g
s
0 .046 .615 r
.55426 .4285 m .56659 .4481 L .56378 .46441 L p F P
0 g
s
.309 .754 .963 r
.40476 .30622 m .40353 .3101 L .40103 .31003 L p F P
0 g
s
.309 .754 .963 r
.40103 .31003 m .39972 .30591 L .40476 .30622 L p F P
0 g
s
.292 .741 .96 r
.40353 .3101 m .40476 .30622 L .40969 .307 L p F P
0 g
s
0 .384 .832 r
.47088 .33571 m .4593 .32855 L .45647 .32256 L p F P
0 g
s
.02 .461 .874 r
.44545 .31822 m .45647 .32256 L .4593 .32855 L p F P
0 g
s
.379 .794 .978 r
.36351 .30405 m .37338 .30666 L .37005 .3093 L p F P
0 g
s
.379 .794 .978 r
.37005 .3093 m .35914 .30754 L .36351 .30405 L p F P
0 g
s
.412 .809 .985 r
.31466 .3004 m .3259 .3022 L .32239 .3095 L p F P
0 g
s
.412 .809 .985 r
.32239 .3095 m .31082 .30881 L .31466 .3004 L p F P
0 g
s
.363 .787 .974 r
.37812 .30453 m .3863 .30781 L .38313 .30927 L p F P
0 g
s
.363 .787 .974 r
.38313 .30927 m .37338 .30666 L .37812 .30453 L p F P
0 g
s
.169 .624 .936 r
.42143 .31162 m .43115 .312 L .43453 .31526 L p F P
0 g
s
.166 .635 .931 r
.43115 .312 m .42143 .31162 L .41823 .30976 L p F P
0 g
s
0 0 .576 r
.58761 .51056 m .57566 .48668 L .57906 .46937 L p F P
0 g
s
0 .021 .594 r
.56659 .4481 m .57906 .46937 L .57566 .48668 L p F P
0 g
s
.075 .543 .9 r
.44545 .31822 m .43453 .31526 L .43115 .312 L p F P
0 g
s
.414 .81 .986 r
.30333 .29858 m .31466 .3004 L .31082 .30881 L p F P
0 g
s
.414 .81 .986 r
.31082 .30881 m .29922 .30814 L .30333 .29858 L p F P
0 g
s
0 .312 .789 r
.48252 .34437 m .47088 .33571 L .4676 .3283 L p F P
0 g
s
0 .384 .832 r
.45647 .32256 m .4676 .3283 L .47088 .33571 L p F P
0 g
s
0 0 .56 r
.59964 .53609 m .58761 .51056 L .59166 .49234 L p F P
0 g
s
0 0 .576 r
.57906 .46937 m .59166 .49234 L .58761 .51056 L p F P
0 g
s
.416 .81 .986 r
.29192 .29675 m .30333 .29858 L .29922 .30814 L p F P
0 g
s
.416 .81 .986 r
.29922 .30814 m .28758 .30747 L .29192 .29675 L p F P
0 g
s
.34 .775 .968 r
.38407 .30302 m .39026 .30673 L .3863 .30781 L p F P
0 g
s
.34 .775 .968 r
.3863 .30781 m .37812 .30453 L .38407 .30302 L p F P
0 g
s
.374 .792 .976 r
.35353 .30143 m .36351 .30405 L .35914 .30754 L p F P
0 g
s
.374 .792 .976 r
.35914 .30754 m .34814 .30577 L .35353 .30143 L p F P
0 g
s
.166 .635 .931 r
.41823 .30976 m .42636 .30899 L .43115 .312 L p F P
0 g
s
.175 .652 .93 r
.42636 .30899 m .41823 .30976 L .41425 .3082 L p F P
0 g
s
0 .245 .747 r
.49424 .35452 m .48252 .34437 L .47885 .33547 L p F P
0 g
s
0 .312 .789 r
.4676 .3283 m .47885 .33547 L .48252 .34437 L p F P
0 g
s
.418 .811 .986 r
.28043 .29491 m .29192 .29675 L .28758 .30747 L p F P
0 g
s
.418 .811 .986 r
.28758 .30747 m .27591 .30681 L .28043 .29491 L p F P
0 g
s
0 0 .545 r
.61177 .56329 m .59964 .53609 L .6044 .51703 L p F P
0 g
s
0 0 .56 r
.59166 .49234 m .6044 .51703 L .59964 .53609 L p F P
0 g
s
0 .46 .858 r
.45647 .32256 m .44545 .31822 L .441 .31362 L p F P
0 g
s
.075 .543 .9 r
.43115 .312 m .441 .31362 L .44545 .31822 L p F P
0 g
s
.351 .781 .97 r
.36981 .30129 m .37812 .30453 L .37338 .30666 L p F P
0 g
s
.351 .781 .97 r
.37338 .30666 m .36351 .30405 L .36981 .30129 L p F P
0 g
s
.314 .761 .961 r
.39093 .30222 m .3948 .30609 L .39026 .30673 L p F P
0 g
s
.314 .761 .961 r
.39026 .30673 m .38407 .30302 L .39093 .30222 L p F P
0 g
s
.175 .652 .93 r
.41425 .3082 m .42038 .30637 L .42636 .30899 L p F P
0 g
s
.195 .674 .932 r
.42038 .30637 m .41425 .3082 L .40969 .307 L p F P
0 g
s
.419 .812 .986 r
.26884 .29306 m .28043 .29491 L .27591 .30681 L p F P
0 g
s
.419 .812 .986 r
.27591 .30681 m .26419 .30616 L .26884 .29306 L p F P
0 g
s
.068 .557 .894 r
.441 .31362 m .43115 .312 L .42636 .30899 L p F P
0 g
s
.369 .79 .975 r
.34344 .29881 m .35353 .30143 L .34814 .30577 L p F P
0 g
s
.369 .79 .975 r
.34814 .30577 m .33706 .30399 L .34344 .29881 L p F P
0 g
s
0 .184 .706 r
.50605 .3662 m .49424 .35452 L .49022 .3441 L p F P
0 g
s
0 .245 .747 r
.47885 .33547 m .49022 .3441 L .49424 .35452 L p F P
0 g
s
0 0 .531 r
.624 .59219 m .61177 .56329 L .6173 .5435 L p F P
0 g
s
0 0 .545 r
.6044 .51703 m .6173 .5435 L .61177 .56329 L p F P
0 g
s
.284 .743 .953 r
.39838 .30217 m .39972 .30591 L .3948 .30609 L p F P
0 g
s
.284 .743 .953 r
.3948 .30609 m .39093 .30222 L .39838 .30217 L p F P
0 g
s
.421 .813 .987 r
.25717 .29119 m .26884 .29306 L .26419 .30616 L p F P
0 g
s
.421 .813 .987 r
.26419 .30616 m .25244 .30552 L .25717 .29119 L p F P
0 g
s
.222 .698 .937 r
.41348 .3043 m .40969 .307 L .40476 .30622 L p F P
0 g
s
.195 .674 .932 r
.40969 .307 m .41348 .3043 L .42038 .30637 L p F P
0 g
s
.253 .721 .945 r
.40602 .30287 m .40476 .30622 L .39972 .30591 L p F P
0 g
s
.253 .721 .945 r
.39972 .30591 m .39838 .30217 L .40602 .30287 L p F P
0 g
s
.222 .698 .937 r
.40476 .30622 m .40602 .30287 L .41348 .3043 L p F P
0 g
s
0 .378 .811 r
.4676 .3283 m .45647 .32256 L .45098 .31652 L p F P
0 g
s
0 .46 .858 r
.441 .31362 m .45098 .31652 L .45647 .32256 L p F P
0 g
s
.423 .814 .987 r
.24541 .28931 m .25717 .29119 L .25244 .30552 L p F P
0 g
s
.423 .814 .987 r
.25244 .30552 m .24065 .30488 L .24541 .28931 L p F P
0 g
s
0 0 .519 r
.63633 .62281 m .624 .59219 L .63036 .57177 L p F P
0 g
s
0 0 .531 r
.6173 .5435 m .63036 .57177 L .624 .59219 L p F P
0 g
s
0 .13 .667 r
.51794 .37941 m .50605 .3662 L .50172 .35419 L p F P
0 g
s
0 .184 .706 r
.49022 .3441 m .50172 .35419 L .50605 .3662 L p F P
0 g
s
.319 .765 .961 r
.37777 .29943 m .38407 .30302 L .37812 .30453 L p F P
0 g
s
.319 .765 .961 r
.37812 .30453 m .36981 .30129 L .37777 .29943 L p F P
0 g
s
.364 .788 .973 r
.33323 .29619 m .34344 .29881 L .33706 .30399 L p F P
0 g
s
.364 .788 .973 r
.33706 .30399 m .3259 .3022 L .33323 .29619 L p F P
0 g
s
.425 .814 .987 r
.23356 .28741 m .24541 .28931 L .24065 .30488 L p F P
0 g
s
.425 .814 .987 r
.24065 .30488 m .22883 .30426 L .23356 .28741 L p F P
0 g
s
.338 .775 .966 r
.36138 .2981 m .36981 .30129 L .36351 .30405 L p F P
0 g
s
.338 .775 .966 r
.36351 .30405 m .35353 .30143 L .36138 .2981 L p F P
0 g
s
.068 .557 .894 r
.42636 .30899 m .43463 .3093 L .441 .31362 L p F P
0 g
s
.08 .581 .893 r
.43463 .3093 m .42636 .30899 L .42038 .30637 L p F P
0 g
s
0 .474 .848 r
.45098 .31652 m .441 .31362 L .43463 .3093 L p F P
0 g
s
.426 .815 .988 r
.22161 .28551 m .23356 .28741 L .22883 .30426 L p F P
0 g
s
.426 .815 .988 r
.22883 .30426 m .21696 .30364 L .22161 .28551 L p F P
0 g
s
0 0 .509 r
.64878 .65519 m .63633 .62281 L .64358 .60189 L p F P
0 g
s
0 0 .519 r
.63036 .57177 m .64358 .60189 L .63633 .62281 L p F P
0 g
s
0 .081 .631 r
.52994 .39418 m .51794 .37941 L .51335 .3658 L p F P
0 g
s
0 .13 .667 r
.50172 .35419 m .51335 .3658 L .51794 .37941 L p F P
0 g
s
0 .299 .762 r
.47885 .33547 m .4676 .3283 L .46109 .3207 L p F P
0 g
s
0 .378 .811 r
.45098 .31652 m .46109 .3207 L .4676 .3283 L p F P
0 g
s
.428 .816 .988 r
.20958 .28359 m .22161 .28551 L .21696 .30364 L p F P
0 g
s
.428 .816 .988 r
.21696 .30364 m .20505 .30303 L .20958 .28359 L p F P
0 g
s
.359 .786 .972 r
.3229 .29357 m .33323 .29619 L .3259 .3022 L p F P
0 g
s
.359 .786 .972 r
.3259 .3022 m .31466 .3004 L .3229 .29357 L p F P
0 g
s
.282 .744 .95 r
.38699 .29859 m .39093 .30222 L .38407 .30302 L p F P
0 g
s
.282 .744 .95 r
.38407 .30302 m .37777 .29943 L .38699 .29859 L p F P
0 g
s
.08 .581 .893 r
.42038 .30637 m .42661 .30547 L .43463 .3093 L p F P
0 g
s
.108 .613 .898 r
.42661 .30547 m .42038 .30637 L .41348 .3043 L p F P
0 g
s
0 0 .499 r
.66135 .68936 m .64878 .65519 L .65699 .6339 L p F P
0 g
s
0 0 .509 r
.64358 .60189 m .65699 .6339 L .64878 .65519 L p F P
0 g
s
.43 .817 .988 r
.19745 .28165 m .20958 .28359 L .20505 .30303 L p F P
0 g
s
.43 .817 .988 r
.20505 .30303 m .19311 .30242 L .19745 .28165 L p F P
0 g
s
.326 .769 .962 r
.35283 .29494 m .36138 .2981 L .35353 .30143 L p F P
0 g
s
.326 .769 .962 r
.35353 .30143 m .34344 .29881 L .35283 .29494 L p F P
0 g
s
0 .038 .598 r
.54204 .41054 m .52994 .39418 L .52513 .37893 L p F P
0 g
s
0 .081 .631 r
.51335 .3658 m .52513 .37893 L .52994 .39418 L p F P
0 g
s
.24 .717 .936 r
.39701 .2988 m .39838 .30217 L .39093 .30222 L p F P
0 g
s
.24 .717 .936 r
.39093 .30222 m .38699 .29859 L .39701 .2988 L p F P
0 g
s
.432 .817 .988 r
.18523 .2797 m .19745 .28165 L .19311 .30242 L p F P
0 g
s
.432 .817 .988 r
.19311 .30242 m .18113 .30183 L .18523 .2797 L p F P
0 g
s
.108 .613 .898 r
.41348 .3043 m .41735 .30233 L .42661 .30547 L p F P
0 g
s
.148 .649 .909 r
.41735 .30233 m .41348 .3043 L .40602 .30287 L p F P
0 g
s
.297 .754 .954 r
.37135 .29597 m .37777 .29943 L .36981 .30129 L p F P
0 g
s
.297 .754 .954 r
.36981 .30129 m .36138 .2981 L .37135 .29597 L p F P
0 g
s
.354 .784 .97 r
.31245 .29095 m .3229 .29357 L .31466 .3004 L p F P
0 g
s
.354 .784 .97 r
.31466 .3004 m .30333 .29858 L .31245 .29095 L p F P
0 g
s
0 .225 .712 r
.49022 .3441 m .47885 .33547 L .47135 .32621 L p F P
0 g
s
0 .299 .762 r
.46109 .3207 m .47135 .32621 L .47885 .33547 L p F P
0 g
s
0 .391 .797 r
.46109 .3207 m .45098 .31652 L .44303 .31073 L p F P
0 g
s
0 .474 .848 r
.43463 .3093 m .44303 .31073 L .45098 .31652 L p F P
0 g
s
.194 .685 .922 r
.40731 .30007 m .40602 .30287 L .39838 .30217 L p F P
0 g
s
.194 .685 .922 r
.39838 .30217 m .39701 .2988 L .40731 .30007 L p F P
0 g
s
0 .504 .848 r
.44303 .31073 m .43463 .3093 L .42661 .30547 L p F P
0 g
s
.148 .649 .909 r
.40602 .30287 m .40731 .30007 L .41735 .30233 L p F P
0 g
s
0 0 .49 r
.67404 .72535 m .66135 .68936 L .67059 .66785 L p F P
0 g
s
0 0 .499 r
.65699 .6339 m .67059 .66785 L .66135 .68936 L p F P
0 g
s
.434 .818 .989 r
.17291 .27774 m .18523 .2797 L .18113 .30183 L p F P
0 g
s
.434 .818 .989 r
.18113 .30183 m .1691 .30124 L .17291 .27774 L p F P
0 g
s
0 0 .568 r
.55426 .4285 m .54204 .41054 L .53706 .39363 L p F P
0 g
s
0 .038 .598 r
.52513 .37893 m .53706 .39363 L .54204 .41054 L p F P
0 g
s
.435 .819 .989 r
.1605 .27576 m .17291 .27774 L .1691 .30124 L p F P
0 g
s
.435 .819 .989 r
.1691 .30124 m .15704 .30067 L .1605 .27576 L p F P
0 g
s
.349 .781 .969 r
.30188 .28832 m .31245 .29095 L .30333 .29858 L p F P
0 g
s
.349 .781 .969 r
.30333 .29858 m .29192 .29675 L .30188 .28832 L p F P
0 g
s
.437 .82 .989 r
.14798 .27377 m .1605 .27576 L .15704 .30067 L p F P
0 g
s
.437 .82 .989 r
.15704 .30067 m .14494 .3001 L .14798 .27377 L p F P
0 g
s
.313 .763 .958 r
.34414 .29183 m .35283 .29494 L .34344 .29881 L p F P
0 g
s
.313 .763 .958 r
.34344 .29881 m .33323 .29619 L .34414 .29183 L p F P
0 g
s
0 0 .482 r
.68688 .7632 m .67404 .72535 L .68439 .70379 L p F P
0 g
s
0 0 .49 r
.67059 .66785 m .68439 .70379 L .67404 .72535 L p F P
0 g
s
.249 .726 .937 r
.38296 .29519 m .38699 .29859 L .37777 .29943 L p F P
0 g
s
.249 .726 .937 r
.37777 .29943 m .37135 .29597 L .38296 .29519 L p F P
0 g
s
0 .157 .664 r
.50172 .35419 m .49022 .3441 L .48176 .33307 L p F P
0 g
s
0 .225 .712 r
.47135 .32621 m .48176 .33307 L .49022 .3441 L p F P
0 g
s
.439 .82 .99 r
.13537 .27177 m .14798 .27377 L .14494 .3001 L p F P
0 g
s
.439 .82 .99 r
.14494 .3001 m .1328 .29954 L .13537 .27177 L p F P
0 g
s
0 .504 .848 r
.42661 .30547 m .43297 .3055 L .44303 .31073 L p F P
0 g
s
.02 .547 .857 r
.43297 .3055 m .42661 .30547 L .41735 .30233 L p F P
0 g
s
0 0 .541 r
.56659 .4481 m .55426 .4285 L .54916 .40993 L p F P
0 g
s
0 0 .568 r
.53706 .39363 m .54916 .40993 L .55426 .4285 L p F P
0 g
s
.275 .742 .945 r
.36482 .29263 m .37135 .29597 L .36138 .2981 L p F P
0 g
s
.275 .742 .945 r
.36138 .2981 m .35283 .29494 L .36482 .29263 L p F P
0 g
s
0 .31 .743 r
.47135 .32621 m .46109 .3207 L .45157 .3133 L p F P
0 g
s
0 .391 .797 r
.44303 .31073 m .45157 .3133 L .46109 .3207 L p F P
0 g
s
.344 .779 .967 r
.29119 .2857 m .30188 .28832 L .29192 .29675 L p F P
0 g
s
.344 .779 .967 r
.29192 .29675 m .28043 .29491 L .29119 .2857 L p F P
0 g
s
.441 .821 .99 r
.12266 .26975 m .13537 .27177 L .1328 .29954 L p F P
0 g
s
.441 .821 .99 r
.1328 .29954 m .12061 .29898 L .12266 .26975 L p F P
0 g
s
0 0 .475 r
.69985 .80296 m .68688 .7632 L .6984 .74178 L p F P
0 g
s
0 0 .482 r
.68439 .70379 m .6984 .74178 L .68688 .7632 L p F P
0 g
s
0 .425 .796 r
.45157 .3133 m .44303 .31073 L .43297 .3055 L p F P
0 g
s
.193 .689 .917 r
.39561 .29582 m .39701 .2988 L .38699 .29859 L p F P
0 g
s
.193 .689 .917 r
.38699 .29859 m .38296 .29519 L .39561 .29582 L p F P
0 g
s
.442 .822 .99 r
.10985 .26771 m .12266 .26975 L .12061 .29898 L p F P
0 g
s
.442 .822 .99 r
.12061 .29898 m .10839 .29844 L .10985 .26771 L p F P
0 g
s
.072 .596 .874 r
.4213 .30112 m .41735 .30233 L .40731 .30007 L p F P
0 g
s
.02 .547 .857 r
.41735 .30233 m .4213 .30112 L .43297 .3055 L p F P
0 g
s
.3 .756 .953 r
.33532 .28877 m .34414 .29183 L .33323 .29619 L p F P
0 g
s
.3 .756 .953 r
.33323 .29619 m .3229 .29357 L .33532 .28877 L p F P
0 g
s
0 0 .516 r
.57906 .46937 m .56659 .4481 L .56142 .42787 L p F P
0 g
s
0 0 .541 r
.54916 .40993 m .56142 .42787 L .56659 .4481 L p F P
0 g
s
0 .096 .618 r
.51335 .3658 m .50172 .35419 L .49233 .34131 L p F P
0 g
s
0 .157 .664 r
.48176 .33307 m .49233 .34131 L .50172 .35419 L p F P
0 g
s
.444 .823 .99 r
.09694 .26566 m .10985 .26771 L .10839 .29844 L p F P
0 g
s
.444 .823 .99 r
.10839 .29844 m .09613 .29791 L .09694 .26566 L p F P
0 g
s
.132 .645 .895 r
.40862 .29783 m .40731 .30007 L .39701 .2988 L p F P
0 g
s
.132 .645 .895 r
.39701 .2988 m .39561 .29582 L .40862 .29783 L p F P
0 g
s
.072 .596 .874 r
.40731 .30007 m .40862 .29783 L .4213 .30112 L p F P
0 g
s
.338 .776 .966 r
.28037 .28307 m .29119 .2857 L .28043 .29491 L p F P
0 g
s
.338 .776 .966 r
.28043 .29491 m .26884 .29306 L .28037 .28307 L p F P
0 g
s
0 0 .469 r
.71299 .84466 m .69985 .80296 L .71264 .78186 L p F P
0 g
s
0 0 .475 r
.6984 .74178 m .71264 .78186 L .69985 .80296 L p F P
0 g
s
.446 .823 .991 r
.08392 .2636 m .09694 .26566 L .09613 .29791 L p F P
0 g
s
.446 .823 .991 r
.09613 .29791 m .08382 .29738 L .08392 .2636 L p F P
0 g
s
0 .232 .688 r
.48176 .33307 m .47135 .32621 L .46026 .31705 L p F P
0 g
s
0 .31 .743 r
.45157 .3133 m .46026 .31705 L .47135 .32621 L p F P
0 g
s
.215 .706 .923 r
.37885 .29204 m .38296 .29519 L .37135 .29597 L p F P
0 g
s
.215 .706 .923 r
.37135 .29597 m .36482 .29263 L .37885 .29204 L p F P
0 g
s
0 0 .494 r
.59166 .49234 m .57906 .46937 L .57386 .44748 L p F P
0 g
s
0 0 .516 r
.56142 .42787 m .57386 .44748 L .57906 .46937 L p F P
0 g
s
.448 .824 .991 r
.0708 .26152 m .08392 .2636 L .08382 .29738 L p F P
0 g
s
.448 .824 .991 r
.08382 .29738 m .07147 .29686 L .0708 .26152 L p F P
0 g
s
.253 .73 .936 r
.35818 .28942 m .36482 .29263 L .35283 .29494 L p F P
0 g
s
.253 .73 .936 r
.35283 .29494 m .34414 .29183 L .35818 .28942 L p F P
0 g
s
.333 .774 .964 r
.26941 .28044 m .28037 .28307 L .26884 .29306 L p F P
0 g
s
.333 .774 .964 r
.26884 .29306 m .25717 .29119 L .26941 .28044 L p F P
0 g
s
0 .425 .796 r
.43297 .3055 m .43945 .3065 L .45157 .3133 L p F P
0 g
s
0 .476 .809 r
.43945 .3065 m .43297 .3055 L .4213 .30112 L p F P
0 g
s
0 0 .464 r
.72628 .88835 m .71299 .84466 L .7271 .82411 L p F P
0 g
s
0 0 .469 r
.71264 .78186 m .7271 .82411 L .71299 .84466 L p F P
0 g
s
.286 .749 .948 r
.32636 .28576 m .33532 .28877 L .3229 .29357 L p F P
0 g
s
.286 .749 .948 r
.3229 .29357 m .31245 .29095 L .32636 .28576 L p F P
0 g
s
.449 .825 .991 r
.05757 .25942 m .0708 .26152 L .07147 .29686 L p F P
0 g
s
.449 .825 .991 r
.07147 .29686 m .05908 .29635 L .05757 .25942 L p F P
0 g
s
0 .04 .575 r
.52513 .37893 m .51335 .3658 L .50306 .35096 L p F P
0 g
s
0 .096 .618 r
.49233 .34131 m .50306 .35096 L .51335 .3658 L p F P
0 g
s
0 .346 .741 r
.46026 .31705 m .45157 .3133 L .43945 .3065 L p F P
0 g
s
0 0 .474 r
.6044 .51703 m .59166 .49234 L .58649 .46881 L p F P
0 g
s
0 0 .494 r
.57386 .44748 m .58649 .46881 L .59166 .49234 L p F P
0 g
s
.328 .772 .962 r
.25833 .27781 m .26941 .28044 L .25717 .29119 L p F P
0 g
s
.328 .772 .962 r
.25717 .29119 m .24541 .28931 L .25833 .27781 L p F P
0 g
s
.145 .659 .895 r
.39418 .29324 m .39561 .29582 L .38296 .29519 L p F P
0 g
s
.145 .659 .895 r
.38296 .29519 m .37885 .29204 L .39418 .29324 L p F P
0 g
s
0 .476 .809 r
.4213 .30112 m .42533 .30068 L .43945 .3065 L p F P
0 g
s
0 .538 .833 r
.42533 .30068 m .4213 .30112 L .40862 .29783 L p F P
0 g
s
0 0 .459 r
.73974 .93408 m .72628 .88835 L .74182 .86858 L p F P
0 g
s
0 0 .464 r
.7271 .82411 m .74182 .86858 L .72628 .88835 L p F P
0 g
s
0 .159 .634 r
.49233 .34131 m .48176 .33307 L .46911 .322 L p F P
0 g
s
0 .232 .688 r
.46026 .31705 m .46911 .322 L .48176 .33307 L p F P
0 g
s
.069 .601 .864 r
.40996 .29617 m .40862 .29783 L .39561 .29582 L p F P
0 g
s
.069 .601 .864 r
.39561 .29582 m .39418 .29324 L .40996 .29617 L p F P
0 g
s
0 0 .536 r
.53706 .39363 m .52513 .37893 L .51397 .36207 L p F P
0 g
s
0 .04 .575 r
.50306 .35096 m .51397 .36207 L .52513 .37893 L p F P
0 g
s
.273 .742 .943 r
.31726 .28279 m .32636 .28576 L .31245 .29095 L p F P
0 g
s
.273 .742 .943 r
.31245 .29095 m .30188 .28832 L .31726 .28279 L p F P
0 g
s
0 .538 .833 r
.40862 .29783 m .40996 .29617 L .42533 .30068 L p F P
0 g
s
.229 .717 .926 r
.35141 .28635 m .35818 .28942 L .34414 .29183 L p F P
0 g
s
.229 .717 .926 r
.34414 .29183 m .33532 .28877 L .35141 .28635 L p F P
0 g
s
.322 .769 .96 r
.24711 .27518 m .25833 .27781 L .24541 .28931 L p F P
0 g
s
.322 .769 .96 r
.24541 .28931 m .23356 .28741 L .24711 .27518 L p F P
0 g
s
.18 .685 .907 r
.37466 .28915 m .37885 .29204 L .36482 .29263 L p F P
0 g
s
.18 .685 .907 r
.36482 .29263 m .35818 .28942 L .37466 .28915 L p F P
0 g
s
0 0 .456 r
.6173 .5435 m .6044 .51703 L .59932 .4919 L p F P
0 g
s
0 0 .474 r
.58649 .46881 m .59932 .4919 L .6044 .51703 L p F P
0 g
s
0 0 .454 r
.75339 .9819 m .73974 .93408 L .75679 .91534 L p F P
0 g
s
0 0 .459 r
.74182 .86858 m .75679 .91534 L .73974 .93408 L p F P
0 g
s
0 .346 .741 r
.43945 .3065 m .44606 .30849 L .46026 .31705 L p F P
0 g
s
0 .404 .756 r
.44606 .30849 m .43945 .3065 L .42533 .30068 L p F P
0 g
s
0 .268 .683 r
.46911 .322 m .46026 .31705 L .44606 .30849 L p F P
0 g
s
.317 .766 .958 r
.23576 .27254 m .24711 .27518 L .23356 .28741 L p F P
0 g
s
.317 .766 .958 r
.23356 .28741 m .22161 .28551 L .23576 .27254 L p F P
0 g
s
0 0 .499 r
.54916 .40993 m .53706 .39363 L .52506 .37466 L p F P
0 g
s
0 0 .536 r
.51397 .36207 m .52506 .37466 L .53706 .39363 L p F P
0 g
s
.259 .735 .937 r
.30802 .27987 m .31726 .28279 L .30188 .28832 L p F P
0 g
s
.259 .735 .937 r
.30188 .28832 m .29119 .2857 L .30802 .27987 L p F P
0 g
s
0 0 .44 r
.63036 .57177 m .6173 .5435 L .61236 .5168 L p F P
0 g
s
0 0 .456 r
.59932 .4919 m .61236 .5168 L .6173 .5435 L p F P
0 g
s
0 .031 .532 r
.4873 .33566 m .49667 .34444 L .5004 .34824 L p F P
0 g
s
0 .092 .581 r
.50306 .35096 m .49233 .34131 L .49024 .33939 L p F P
0 g
s
0 .092 .581 r
.49326 .34202 m .50306 .35096 L .49024 .33939 L F
.47812 .3282 m .4873 .33566 L .50306 .35096 L p F P
0 g
s
0 .031 .532 r
.51397 .36207 m .50306 .35096 L .49942 .34743 L p F P
0 g
s
0 .031 .532 r
.49942 .34743 m .4873 .33566 L p .50288 .35109 L F P
0 g
s
0 .031 .532 r
.50288 .35109 m .51397 .36207 L .49942 .34743 L F
.5004 .34824 m .51397 .36207 L p .49712 .34538 L F P
0 g
s
0 .031 .532 r
.4873 .33566 m .5004 .34824 L .49712 .34538 L F
0 0 .486 r
.52506 .37466 m .51397 .36207 L .50878 .35679 L p F P
0 g
s
0 0 .486 r
.50878 .35679 m .49667 .34444 L p .51266 .36147 L F P
0 g
s
0 0 .486 r
.51266 .36147 m .52506 .37466 L .50878 .35679 L F
.49667 .34444 m .50622 .35458 L .51153 .36024 L p F P
0 g
s
0 0 .486 r
.49667 .34444 m .51153 .36024 L .50776 .35625 L F
.553 .073 0 r
.50622 .35458 m .51597 .3661 L .52286 .37378 L p F P
0 g
s
0 0 .499 r
.52506 .37466 m .53634 .38879 L .54916 .40993 L p F P
0 g
s
.553 .073 0 r
.52286 .37378 m .53634 .38879 L p .51863 .36867 L F P
0 g
s
.553 .073 0 r
.50622 .35458 m .52286 .37378 L .51863 .36867 L F
0 0 .486 r
.51153 .36024 m .52506 .37466 L p .50776 .35625 L F P
0 g
s
0 .092 .581 r
.49024 .33939 m .47812 .3282 L p .49326 .34202 L F P
0 g
s
0 .159 .634 r
.46911 .322 m .47812 .3282 L .49233 .34131 L p F P
0 g
s
0 0 .454 r
.75679 .91534 m .77204 .96447 L .75339 .9819 L p F P
0 g
s
.096 .626 .87 r
.39272 .29107 m .39418 .29324 L .37885 .29204 L p F P
0 g
s
.096 .626 .87 r
.37885 .29204 m .37466 .28915 L .39272 .29107 L p F P
0 g
s
.206 .703 .916 r
.34451 .28341 m .35141 .28635 L .33532 .28877 L p F P
0 g
s
.206 .703 .916 r
.33532 .28877 m .32636 .28576 L .34451 .28341 L p F P
0 g
s
0 .404 .756 r
.42533 .30068 m .42945 .30103 L .44606 .30849 L p F P
0 g
s
0 .477 .787 r
.42945 .30103 m .42533 .30068 L .40996 .29617 L p F P
0 g
s
.312 .764 .956 r
.22426 .2699 m .23576 .27254 L .22161 .28551 L p F P
0 g
s
.312 .764 .956 r
.22161 .28551 m .20958 .28359 L .22426 .2699 L p F P
0 g
s
.145 .662 .889 r
.37038 .28652 m .37466 .28915 L .35818 .28942 L p F P
0 g
s
.145 .662 .889 r
.35818 .28942 m .35141 .28635 L .37038 .28652 L p F P
0 g
s
.005 .554 .828 r
.41133 .29511 m .40996 .29617 L .39418 .29324 L p F P
0 g
s
.005 .554 .828 r
.39418 .29324 m .39272 .29107 L .41133 .29511 L p F P
0 g
s
0 .477 .787 r
.40996 .29617 m .41133 .29511 L .42945 .30103 L p F P
0 g
s
0 0 .425 r
.64358 .60189 m .63036 .57177 L .62562 .54356 L p F P
0 g
s
0 0 .44 r
.61236 .5168 m .62562 .54356 L .63036 .57177 L p F P
0 g
s
0 0 .467 r
.56142 .42787 m .54916 .40993 L .53634 .38879 L p F P
0 g
s
.245 .727 .931 r
.29863 .277 m .30802 .27987 L .29119 .2857 L p F P
0 g
s
.245 .727 .931 r
.29119 .2857 m .28037 .28307 L .29863 .277 L p F P
0 g
s
0 .268 .683 r
.44606 .30849 m .45281 .31151 L .46911 .322 L p F P
0 g
s
0 .194 .625 r
.47812 .3282 m .46911 .322 L .45281 .31151 L p F P
0 g
s
.306 .761 .954 r
.21262 .26726 m .22426 .2699 L .20958 .28359 L p F P
0 g
s
.306 .761 .954 r
.20958 .28359 m .19745 .28165 L .21262 .26726 L p F P
0 g
s
0 .331 .7 r
.45281 .31151 m .44606 .30849 L .42945 .30103 L p F P
0 g
s
.181 .688 .904 r
.33748 .28061 m .34451 .28341 L .32636 .28576 L p F P
0 g
s
.181 .688 .904 r
.32636 .28576 m .31726 .28279 L .33748 .28061 L p F P
0 g
s
0 0 .412 r
.65699 .6339 m .64358 .60189 L .63911 .57223 L p F P
0 g
s
0 0 .425 r
.62562 .54356 m .63911 .57223 L .64358 .60189 L p F P
0 g
s
.301 .758 .952 r
.20084 .26462 m .21262 .26726 L .19745 .28165 L p F P
0 g
s
.301 .758 .952 r
.19745 .28165 m .18523 .2797 L .20084 .26462 L p F P
0 g
s
.046 .591 .842 r
.39122 .28933 m .39272 .29107 L .37466 .28915 L p F P
0 g
s
.046 .591 .842 r
.37466 .28915 m .37038 .28652 L .39122 .28933 L p F P
0 g
s
.231 .719 .925 r
.28909 .27418 m .29863 .277 L .28037 .28307 L p F P
0 g
s
.231 .719 .925 r
.28037 .28307 m .26941 .28044 L .28909 .27418 L p F P
0 g
s
0 0 .437 r
.57386 .44748 m .56142 .42787 L .54783 .40448 L p F P
0 g
s
0 0 .467 r
.53634 .38879 m .54783 .40448 L .56142 .42787 L p F P
0 g
s
0 .331 .7 r
.42945 .30103 m .43366 .30221 L .45281 .31151 L p F P
0 g
s
0 .414 .738 r
.43366 .30221 m .42945 .30103 L .41133 .29511 L p F P
0 g
s
.108 .638 .87 r
.36601 .28415 m .37038 .28652 L .35141 .28635 L p F P
0 g
s
.108 .638 .87 r
.35141 .28635 m .34451 .28341 L .36601 .28415 L p F P
0 g
s
.295 .755 .95 r
.18891 .26198 m .20084 .26462 L .18523 .2797 L p F P
0 g
s
.295 .755 .95 r
.18523 .2797 m .17291 .27774 L .18891 .26198 L p F P
0 g
s
0 .194 .625 r
.45281 .31151 m .45969 .31559 L .47812 .3282 L p F P
0 g
s
.42 0 0 r
.4873 .33566 m .47812 .3282 L .45969 .31559 L p F P
0 g
s
0 .505 .789 r
.41273 .29467 m .41133 .29511 L .39272 .29107 L p F P
0 g
s
0 .505 .789 r
.39272 .29107 m .39122 .28933 L .41273 .29467 L p F P
0 g
s
0 0 .4 r
.67059 .66785 m .65699 .6339 L .65285 .60287 L p F P
0 g
s
0 0 .412 r
.63911 .57223 m .65285 .60287 L .65699 .6339 L p F P
0 g
s
0 .414 .738 r
.41133 .29511 m .41273 .29467 L .43366 .30221 L p F P
0 g
s
0 .26 .643 r
.45969 .31559 m .45281 .31151 L .43366 .30221 L p F P
0 g
s
.216 .711 .918 r
.2794 .27141 m .28909 .27418 L .26941 .28044 L p F P
0 g
s
.216 .711 .918 r
.26941 .28044 m .25833 .27781 L .2794 .27141 L p F P
0 g
s
.157 .673 .892 r
.33032 .27795 m .33748 .28061 L .31726 .28279 L p F P
0 g
s
.157 .673 .892 r
.31726 .28279 m .30802 .27987 L .33032 .27795 L p F P
0 g
s
0 0 .41 r
.58649 .46881 m .57386 .44748 L .55953 .42179 L p F P
0 g
s
0 0 .437 r
.54783 .40448 m .55953 .42179 L .57386 .44748 L p F P
0 g
s
.289 .753 .948 r
.17683 .25933 m .18891 .26198 L .17291 .27774 L p F P
0 g
s
.289 .753 .948 r
.17291 .27774 m .1605 .27576 L .17683 .25933 L p F P
0 g
s
0 0 .39 r
.68439 .70379 m .67059 .66785 L .66684 .63555 L p F P
0 g
s
0 0 .4 r
.65285 .60287 m .66684 .63555 L .67059 .66785 L p F P
0 g
s
0 .554 .812 r
.38969 .28803 m .39122 .28933 L .37038 .28652 L p F P
0 g
s
0 .554 .812 r
.37038 .28652 m .36601 .28415 L .38969 .28803 L p F P
0 g
s
.284 .75 .945 r
.16459 .25668 m .17683 .25933 L .1605 .27576 L p F P
0 g
s
.284 .75 .945 r
.1605 .27576 m .14798 .27377 L .16459 .25668 L p F P
0 g
s
.553 .073 0 r
.53634 .38879 m .52506 .37466 L .50622 .35458 L p F P
0 g
s
.071 .613 .849 r
.36155 .28207 m .36601 .28415 L .34451 .28341 L p F P
0 g
s
.071 .613 .849 r
.34451 .28341 m .33748 .28061 L .36155 .28207 L p F P
0 g
s
.202 .702 .911 r
.26954 .26869 m .2794 .27141 L .25833 .27781 L p F P
0 g
s
.202 .702 .911 r
.25833 .27781 m .24711 .27518 L .26954 .26869 L p F P
0 g
s
0 .26 .643 r
.43366 .30221 m .43797 .30424 L .45969 .31559 L p F P
0 g
s
0 .351 .686 r
.43797 .30424 m .43366 .30221 L .41273 .29467 L p F P
0 g
s
.478 0 0 r
.49667 .34444 m .4873 .33566 L .46673 .32076 L p F P
0 g
s
.42 0 0 r
.45969 .31559 m .46673 .32076 L .4873 .33566 L p F P
0 g
s
0 0 .385 r
.59932 .4919 m .58649 .46881 L .57145 .44078 L p F P
0 g
s
0 0 .41 r
.55953 .42179 m .57145 .44078 L .58649 .46881 L p F P
0 g
s
.132 .657 .878 r
.32301 .27545 m .33032 .27795 L .30802 .27987 L p F P
0 g
s
.132 .657 .878 r
.30802 .27987 m .29863 .277 L .32301 .27545 L p F P
0 g
s
.278 .747 .943 r
.1522 .25403 m .16459 .25668 L .14798 .27377 L p F P
0 g
s
.278 .747 .943 r
.14798 .27377 m .13537 .27177 L .1522 .25403 L p F P
0 g
s
0 .454 .747 r
.39122 .28933 m .38969 .28803 L .41417 .29486 L p F P
0 g
s
0 .454 .747 r
.41417 .29486 m .41273 .29467 L .39883 .29122 L p F P
0 g
s
0 .454 .747 r
.40002 .29145 m .41417 .29486 L .39883 .29122 L F
0 .351 .686 r
.41273 .29467 m .41417 .29486 L .43797 .30424 L p F P
0 g
s
0 .402 .702 r
.41564 .29572 m .41417 .29486 L .39739 .29018 L p F P
0 g
s
0 .402 .702 r
.39739 .29018 m .38969 .28803 L p .399 .29079 L F P
0 g
s
0 .402 .702 r
.399 .29079 m .41564 .29572 L .39739 .29018 L F
.38969 .28803 m .38813 .28719 L .40509 .29245 L p F P
0 g
s
0 .402 .702 r
.38969 .28803 m .40509 .29245 L .40363 .29216 L F
0 .515 .779 r
.38813 .28719 m .38969 .28803 L .36601 .28415 L p F P
0 g
s
0 .515 .779 r
.36601 .28415 m .36155 .28207 L .38813 .28719 L p F P
0 g
s
0 .475 .745 r
.38653 .28682 m .38813 .28719 L .36719 .28315 L p F P
0 g
s
0 .475 .745 r
.36719 .28315 m .36155 .28207 L p .36844 .28338 L F P
0 g
s
0 .475 .745 r
.36844 .28338 m .38653 .28682 L .36719 .28315 L F
.36155 .28207 m .35699 .28027 L .38653 .28682 L p F P
0 g
s
0 .435 .709 r
.38489 .28693 m .38653 .28682 L .36268 .28153 L p F P
0 g
s
0 .435 .709 r
.36268 .28153 m .35699 .28027 L p .3642 .28199 L F P
0 g
s
0 .435 .709 r
.3642 .28199 m .38489 .28693 L .36268 .28153 L F
.35699 .28027 m .35232 .27876 L .37635 .28479 L p F P
0 g
s
0 .435 .709 r
.35699 .28027 m .37635 .28479 L .37465 .28448 L F
0 .559 .803 r
.35232 .27876 m .35699 .28027 L .33032 .27795 L p F P
0 g
s
0 .559 .803 r
.33032 .27795 m .32301 .27545 L .35232 .27876 L p F P
0 g
s
0 .531 .778 r
.34755 .27756 m .35232 .27876 L .32301 .27545 L p F P
0 g
s
.199 0 0 r
.35232 .27876 m .34755 .27756 L .37457 .28513 L p F P
0 g
s
.199 0 0 r
.37457 .28513 m .38321 .28755 L p .37248 .2845 L F P
0 g
s
.199 0 0 r
.35232 .27876 m .37457 .28513 L .37248 .2845 L F
0 .435 .709 r
.37635 .28479 m .38489 .28693 L p .37465 .28448 L F P
0 g
s
.241 0 0 r
.38813 .28719 m .38653 .28682 L .40647 .29363 L p F P
0 g
s
.241 0 0 r
.40647 .29363 m .41714 .29727 L p .40447 .29286 L F P
0 g
s
.241 0 0 r
.38813 .28719 m .40647 .29363 L .40447 .29286 L F
0 .402 .702 r
.40509 .29245 m .41564 .29572 L p .40363 .29216 L F P
0 g
s
0 .454 .747 r
.39883 .29122 m .39122 .28933 L p .40002 .29145 L F P
0 g
s
0 0 .381 r
.6984 .74178 m .68439 .70379 L .6811 .67032 L p F P
0 g
s
0 0 .39 r
.66684 .63555 m .6811 .67032 L .68439 .70379 L p F P
0 g
s
.379 0 0 r
.46673 .32076 m .45969 .31559 L .43797 .30424 L p F P
0 g
s
.187 .693 .904 r
.25953 .26603 m .26954 .26869 L .24711 .27518 L p F P
0 g
s
.187 .693 .904 r
.24711 .27518 m .23576 .27254 L .25953 .26603 L p F P
0 g
s
.272 .744 .941 r
.13965 .25138 m .1522 .25403 L .13537 .27177 L p F P
0 g
s
.272 .744 .941 r
.13537 .27177 m .12266 .26975 L .13965 .25138 L p F P
0 g
s
.588 .117 0 r
.54783 .40448 m .53634 .38879 L .51597 .3661 L p F P
0 g
s
0 0 .344 r
.59602 .48395 m .60868 .50826 L .61577 .52303 L p F P
0 g
s
0 0 .364 r
.61236 .5168 m .59932 .4919 L .59319 .48002 L p F P
0 g
s
0 0 .364 r
.59909 .49126 m .61236 .5168 L .59319 .48002 L F
.58361 .46148 m .59602 .48395 L .61236 .5168 L p F P
0 g
s
0 0 .344 r
.62562 .54356 m .61236 .5168 L .60544 .5029 L p F P
0 g
s
0 0 .344 r
.60544 .5029 m .59602 .48395 L p .61157 .51527 L F P
0 g
s
0 0 .344 r
.61157 .51527 m .62562 .54356 L .60544 .5029 L F
0 0 .326 r
.60868 .50826 m .62162 .53447 L .62947 .55141 L p F P
0 g
s
0 0 .344 r
.61577 .52303 m .62562 .54356 L p .6094 .51089 L F P
0 g
s
0 0 .344 r
.59602 .48395 m .61577 .52303 L .6094 .51089 L F
0 0 .326 r
.63911 .57223 m .62562 .54356 L .61796 .52759 L p F P
0 g
s
0 0 .326 r
.61796 .52759 m .60868 .50826 L p .6243 .54108 L F P
0 g
s
0 0 .326 r
.6243 .54108 m .63911 .57223 L .61796 .52759 L F
.62947 .55141 m .63911 .57223 L p .62286 .53806 L F P
0 g
s
0 0 .326 r
.60868 .50826 m .62947 .55141 L .62286 .53806 L F
0 0 .31 r
.65285 .60287 m .63911 .57223 L .63074 .55415 L p F P
0 g
s
0 0 .31 r
.63074 .55415 m .62162 .53447 L p .63728 .56877 L F P
0 g
s
0 0 .31 r
.64492 .58551 m .65285 .60287 L .64379 .5829 L F
.63728 .56877 m .64492 .58551 L .63074 .55415 L F
.64492 .58551 m .64379 .5829 L .63074 .55415 L F
.62162 .53447 m .63485 .56265 L .64342 .58179 L p F P
0 g
s
0 0 .31 r
.64342 .58179 m .65285 .60287 L p .63658 .56725 L F P
0 g
s
0 0 .31 r
.62162 .53447 m .64342 .58179 L .63658 .56725 L F
0 0 .296 r
.66684 .63555 m .65285 .60287 L .63485 .56265 L p F P
0 g
s
0 0 .296 r
.63485 .56265 m .64838 .59286 L .65762 .61424 L p F P
0 g
s
0 0 .296 r
.65762 .61424 m .66684 .63555 L p .65058 .5985 L F P
0 g
s
0 0 .296 r
.63485 .56265 m .65762 .61424 L .65058 .5985 L F
0 0 .283 r
.6811 .67032 m .66684 .63555 L .65716 .61317 L p F P
0 g
s
0 0 .283 r
.65716 .61317 m .64838 .59286 L p .66407 .63001 L F P
0 g
s
0 0 .283 r
.66407 .63001 m .6811 .67032 L .65716 .61317 L F
.64838 .59286 m .66223 .62519 L .6627 .62632 L p F P
0 g
s
0 0 .283 r
.6627 .62632 m .6811 .67032 L p .65653 .61215 L F P
0 g
s
0 0 .283 r
.64838 .59286 m .6627 .62632 L .65653 .61215 L F
0 0 .381 r
.6811 .67032 m .69564 .70726 L .6984 .74178 L p F P
0 g
s
0 0 .272 r
.69564 .70726 m .6811 .67032 L .67083 .64577 L p F P
0 g
s
0 0 .272 r
.67083 .64577 m .66223 .62519 L p .67792 .66372 L F P
0 g
s
0 0 .272 r
.67792 .66372 m .69564 .70726 L .67083 .64577 L F
.66223 .62519 m .67641 .65972 L .68688 .6856 L p F P
0 g
s
0 0 .272 r
.68688 .6856 m .69564 .70726 L p .67946 .6675 L F P
0 g
s
0 0 .272 r
.66223 .62519 m .68688 .6856 L .67946 .6675 L F
0 0 .372 r
.71264 .78186 m .6984 .74178 L .69564 .70726 L p F P
0 g
s
0 0 .372 r
.69564 .70726 m .71049 .74644 L .71264 .78186 L p F P
0 g
s
0 0 .261 r
.71049 .74644 m .69564 .70726 L .68484 .68054 L p F P
0 g
s
0 0 .261 r
.68484 .68054 m .67641 .65972 L p .69208 .6996 L F P
0 g
s
0 0 .261 r
.69208 .6996 m .71049 .74644 L .68484 .68054 L F
.67641 .65972 m .69095 .69653 L .70196 .72466 L p F P
0 g
s
0 0 .261 r
.67641 .65972 m .70196 .72466 L .69436 .70539 L F
0 0 .365 r
.7271 .82411 m .71264 .78186 L .71049 .74644 L p F P
0 g
s
0 0 .365 r
.71049 .74644 m .72564 .78794 L .7271 .82411 L p F P
0 g
s
0 0 .261 r
.70196 .72466 m .71049 .74644 L p .69436 .70539 L F P
0 g
s
0 0 .252 r
.72564 .78794 m .71049 .74644 L .69918 .71756 L p F P
0 g
s
0 0 .252 r
.69918 .71756 m .69095 .69653 L p .70659 .73773 L F P
0 g
s
0 0 .252 r
.70659 .73773 m .72564 .78794 L .69918 .71756 L F
.69095 .69653 m .70586 .73573 L .71736 .76608 L p F P
0 g
s
0 0 .252 r
.69095 .69653 m .71736 .76608 L .70959 .74565 L F
0 0 .358 r
.74182 .86858 m .7271 .82411 L .72564 .78794 L p F P
0 g
s
0 0 .358 r
.72564 .78794 m .74113 .83184 L .74182 .86858 L p F P
0 g
s
0 0 .252 r
.71736 .76608 m .72564 .78794 L p .70959 .74565 L F P
0 g
s
0 0 .244 r
.74113 .83184 m .72564 .78794 L .7139 .75693 L p F P
0 g
s
0 0 .244 r
.7139 .75693 m .70586 .73573 L p .72145 .7782 L F P
0 g
s
0 0 .244 r
.72145 .7782 m .74113 .83184 L .7139 .75693 L F
.70586 .73573 m .72117 .77741 L .7331 .80995 L p F P
0 g
s
0 0 .244 r
.70586 .73573 m .7331 .80995 L .72518 .78836 L F
0 0 .352 r
.75679 .91534 m .74182 .86858 L .74113 .83184 L p F P
0 g
s
0 0 .352 r
.74113 .83184 m .75697 .87824 L .75679 .91534 L p F P
0 g
s
0 0 .244 r
.7331 .80995 m .74113 .83184 L p .72518 .78836 L F P
0 g
s
0 0 .237 r
.75697 .87824 m .74113 .83184 L .72899 .79874 L p F P
0 g
s
0 0 .237 r
.72899 .79874 m .72117 .77741 L p .73668 .82111 L F P
0 g
s
0 0 .237 r
.73668 .82111 m .75697 .87824 L .72899 .79874 L F
.72117 .77741 m .73689 .82168 L .7492 .85635 L p F P
0 g
s
0 0 .237 r
.72117 .77741 m .7492 .85635 L .74113 .83362 L F
0 0 .347 r
.77204 .96447 m .75679 .91534 L .75697 .87824 L p F P
0 g
s
0 0 .347 r
.75697 .87824 m .77317 .92723 L .77204 .96447 L p F P
0 g
s
0 0 .237 r
.7492 .85635 m .75697 .87824 L p .74113 .83362 L F P
0 g
s
0 0 .23 r
.77317 .92723 m .75697 .87824 L .73689 .82168 L p F P
0 g
s
0 0 .23 r
.73689 .82168 m .75305 .86866 L .76567 .9054 L p F P
0 g
s
0 0 .23 r
.76567 .9054 m .77317 .92723 L p .75746 .88152 L F P
0 g
s
0 0 .23 r
.73689 .82168 m .76567 .9054 L .75746 .88152 L F
0 0 .364 r
.59319 .48002 m .58361 .46148 L p .59909 .49126 L F P
0 g
s
0 0 .385 r
.57145 .44078 m .58361 .46148 L .59932 .4919 L p F P
0 g
s
.034 .586 .827 r
.35699 .28027 m .36155 .28207 L .33748 .28061 L p F P
0 g
s
.034 .586 .827 r
.33748 .28061 m .33032 .27795 L .35699 .28027 L p F P
0 g
s
.107 .64 .864 r
.31556 .27309 m .32301 .27545 L .29863 .277 L p F P
0 g
s
.107 .64 .864 r
.29863 .277 m .28909 .27418 L .31556 .27309 L p F P
0 g
s
.53 0 0 r
.50622 .35458 m .49667 .34444 L .47392 .32706 L p F P
0 g
s
.478 0 0 r
.46673 .32076 m .47392 .32706 L .49667 .34444 L p F P
0 g
s
.266 .74 .938 r
.12693 .24872 m .13965 .25138 L .12266 .26975 L p F P
0 g
s
.266 .74 .938 r
.12266 .26975 m .10985 .26771 L .12693 .24872 L p F P
0 g
s
.296 0 0 r
.44238 .30716 m .43797 .30424 L .41417 .29486 L p F P
0 g
s
.379 0 0 r
.43797 .30424 m .44238 .30716 L .46673 .32076 L p F P
0 g
s
.172 .684 .896 r
.24934 .26342 m .25953 .26603 L .23576 .27254 L p F P
0 g
s
.172 .684 .896 r
.23576 .27254 m .22426 .2699 L .24934 .26342 L p F P
0 g
s
.441 0 0 r
.47392 .32706 m .46673 .32076 L .44238 .30716 L p F P
0 g
s
.26 .737 .936 r
.11404 .24606 m .12693 .24872 L .10985 .26771 L p F P
0 g
s
.26 .737 .936 r
.10985 .26771 m .09694 .26566 L .11404 .24606 L p F P
0 g
s
.296 0 0 r
.41417 .29486 m .41564 .29572 L .44238 .30716 L p F P
0 g
s
.618 .156 0 r
.55953 .42179 m .54783 .40448 L .52593 .37907 L p F P
0 g
s
.588 .117 0 r
.51597 .3661 m .52593 .37907 L .54783 .40448 L p F P
0 g
s
.081 .623 .85 r
.30796 .27089 m .31556 .27309 L .28909 .27418 L p F P
0 g
s
.081 .623 .85 r
.28909 .27418 m .2794 .27141 L .30796 .27089 L p F P
0 g
s
.157 .674 .889 r
.23898 .26087 m .24934 .26342 L .22426 .2699 L p F P
0 g
s
.157 .674 .889 r
.22426 .2699 m .21262 .26726 L .23898 .26087 L p F P
0 g
s
.254 .734 .933 r
.10099 .2434 m .11404 .24606 L .09694 .26566 L p F P
0 g
s
.254 .734 .933 r
.09694 .26566 m .08392 .2636 L .10099 .2434 L p F P
0 g
s
.575 .052 0 r
.51597 .3661 m .50622 .35458 L .48128 .33452 L p F P
0 g
s
.53 0 0 r
.47392 .32706 m .48128 .33452 L .50622 .35458 L p F P
0 g
s
.248 .731 .93 r
.08776 .24073 m .10099 .2434 L .08392 .2636 L p F P
0 g
s
.248 .731 .93 r
.08392 .2636 m .0708 .26152 L .08776 .24073 L p F P
0 g
s
.441 0 0 r
.44238 .30716 m .44689 .31098 L .47392 .32706 L p F P
0 g
s
.359 0 0 r
.44689 .31098 m .44238 .30716 L .41564 .29572 L p F P
0 g
s
.643 .191 0 r
.57145 .44078 m .55953 .42179 L .5361 .39353 L p F P
0 g
s
.618 .156 0 r
.52593 .37907 m .5361 .39353 L .55953 .42179 L p F P
0 g
s
.496 0 0 r
.48128 .33452 m .47392 .32706 L .44689 .31098 L p F P
0 g
s
.141 .665 .88 r
.22844 .25838 m .23898 .26087 L .21262 .26726 L p F P
0 g
s
.141 .665 .88 r
.21262 .26726 m .20084 .26462 L .22844 .25838 L p F P
0 g
s
.241 0 0 r
.41714 .29727 m .41564 .29572 L .38813 .28719 L p F P
0 g
s
.056 .605 .834 r
.30021 .26885 m .30796 .27089 L .2794 .27141 L p F P
0 g
s
.056 .605 .834 r
.2794 .27141 m .26954 .26869 L .30021 .26885 L p F P
0 g
s
.242 .728 .928 r
.07436 .23806 m .08776 .24073 L .0708 .26152 L p F P
0 g
s
.242 .728 .928 r
.0708 .26152 m .05757 .25942 L .07436 .23806 L p F P
0 g
s
.359 0 0 r
.41564 .29572 m .41714 .29727 L .44689 .31098 L p F P
0 g
s
0 .531 .778 r
.32301 .27545 m .31556 .27309 L .34755 .27756 L p F P
0 g
s
.614 .1 0 r
.52593 .37907 m .51597 .3661 L .48881 .34319 L p F P
0 g
s
.575 .052 0 r
.48128 .33452 m .48881 .34319 L .51597 .3661 L p F P
0 g
s
.126 .655 .872 r
.21773 .25595 m .22844 .25838 L .20084 .26462 L p F P
0 g
s
.126 .655 .872 r
.20084 .26462 m .18891 .26198 L .21773 .25595 L p F P
0 g
s
.665 .223 0 r
.58361 .46148 m .57145 .44078 L .54651 .40953 L p F P
0 g
s
.643 .191 0 r
.5361 .39353 m .54651 .40953 L .57145 .44078 L p F P
0 g
s
.496 0 0 r
.44689 .31098 m .45151 .31575 L .48128 .33452 L p F P
0 g
s
.416 0 0 r
.45151 .31575 m .44689 .31098 L .41714 .29727 L p F P
0 g
s
.03 .586 .818 r
.2923 .26698 m .30021 .26885 L .26954 .26869 L p F P
0 g
s
.03 .586 .818 r
.26954 .26869 m .25953 .26603 L .2923 .26698 L p F P
0 g
s
.545 0 0 r
.48881 .34319 m .48128 .33452 L .45151 .31575 L p F P
0 g
s
.111 .645 .863 r
.20682 .25358 m .21773 .25595 L .18891 .26198 L p F P
0 g
s
.111 .645 .863 r
.18891 .26198 m .17683 .25933 L .20682 .25358 L p F P
0 g
s
.296 0 0 r
.41869 .29953 m .41714 .29727 L .38653 .28682 L p F P
0 g
s
.296 0 0 r
.38653 .28682 m .38489 .28693 L .41869 .29953 L p F P
0 g
s
0 .502 .752 r
.31556 .27309 m .30796 .27089 L .34267 .27668 L p F P
0 g
s
0 .502 .752 r
.34267 .27668 m .34755 .27756 L .32294 .27412 L p F P
0 g
s
0 .502 .752 r
.32294 .27412 m .31924 .27361 L p .32278 .27407 L F P
0 g
s
0 .502 .752 r
.32278 .27407 m .34267 .27668 L .32294 .27412 L F
.32028 .27372 m .34267 .27668 L .31924 .27361 L F
0 .472 .725 r
.33768 .27612 m .34267 .27668 L .31167 .27151 L p F P
0 g
s
0 .472 .725 r
.31167 .27151 m .30796 .27089 L p .31285 .27175 L F P
0 g
s
0 .472 .725 r
.31285 .27175 m .33768 .27612 L .31167 .27151 L F
.30796 .27089 m .30021 .26885 L .33131 .27489 L p F P
0 g
s
0 .472 .725 r
.30796 .27089 m .33131 .27489 L .32967 .27471 L F
.33131 .27489 m .33768 .27612 L p .32967 .27471 L F P
0 g
s
0 .442 .697 r
.33257 .27591 m .33768 .27612 L .30021 .26885 L p F P
0 g
s
0 .442 .697 r
.30021 .26885 m .2923 .26698 L .31974 .27306 L p F P
0 g
s
0 .442 .697 r
.31974 .27306 m .33257 .27591 L p .32016 .2732 L F P
0 g
s
0 .442 .697 r
.30021 .26885 m .31974 .27306 L .32016 .2732 L F
0 .502 .752 r
.31924 .27361 m .31556 .27309 L p .32028 .27372 L F P
0 g
s
.416 0 0 r
.41714 .29727 m .41869 .29953 L .45151 .31575 L p F P
0 g
s
.648 .143 0 r
.5361 .39353 m .52593 .37907 L .49651 .35311 L p F P
0 g
s
.614 .1 0 r
.48881 .34319 m .49651 .35311 L .52593 .37907 L p F P
0 g
s
.199 0 0 r
.38321 .28755 m .38489 .28693 L .35232 .27876 L p F P
0 g
s
.685 .251 0 r
.59602 .48395 m .58361 .46148 L .55716 .42713 L p F P
0 g
s
.665 .223 0 r
.54651 .40953 m .55716 .42713 L .58361 .46148 L p F P
0 g
s
.004 .567 .801 r
.28423 .26528 m .2923 .26698 L .25953 .26603 L p F P
0 g
s
.004 .567 .801 r
.25953 .26603 m .24934 .26342 L .28423 .26528 L p F P
0 g
s
.095 .634 .854 r
.19572 .25127 m .20682 .25358 L .17683 .25933 L p F P
0 g
s
.095 .634 .854 r
.17683 .25933 m .16459 .25668 L .19572 .25127 L p F P
0 g
s
.545 0 0 r
.45151 .31575 m .45625 .3215 L .48881 .34319 L p F P
0 g
s
.468 0 0 r
.45625 .3215 m .45151 .31575 L .41869 .29953 L p F P
0 g
s
.589 .039 0 r
.49651 .35311 m .48881 .34319 L .45625 .3215 L p F P
0 g
s
.348 0 0 r
.42027 .30252 m .41869 .29953 L .38489 .28693 L p F P
0 g
s
.348 0 0 r
.38489 .28693 m .38321 .28755 L .42027 .30252 L p F P
0 g
s
.677 .181 0 r
.54651 .40953 m .5361 .39353 L .50441 .36432 L p F P
0 g
s
.648 .143 0 r
.49651 .35311 m .50441 .36432 L .5361 .39353 L p F P
0 g
s
.08 .623 .844 r
.18442 .24903 m .19572 .25127 L .16459 .25668 L p F P
0 g
s
.08 .623 .844 r
.16459 .25668 m .1522 .25403 L .18442 .24903 L p F P
0 g
s
.701 .276 0 r
.60868 .50826 m .59602 .48395 L .56806 .44639 L p F P
0 g
s
.685 .251 0 r
.55716 .42713 m .56806 .44639 L .59602 .48395 L p F P
0 g
s
.468 0 0 r
.41869 .29953 m .42027 .30252 L .45625 .3215 L p F P
0 g
s
0 .548 .783 r
.27598 .26375 m .28423 .26528 L .24934 .26342 L p F P
0 g
s
0 .548 .783 r
.24934 .26342 m .23898 .26087 L .27598 .26375 L p F P
0 g
s
.244 0 0 r
.38149 .28869 m .38321 .28755 L .34755 .27756 L p F P
0 g
s
.244 0 0 r
.34755 .27756 m .34267 .27668 L .38149 .28869 L p F P
0 g
s
.064 .612 .835 r
.17292 .24685 m .18442 .24903 L .1522 .25403 L p F P
0 g
s
.064 .612 .835 r
.1522 .25403 m .13965 .25138 L .17292 .24685 L p F P
0 g
s
.627 .085 0 r
.50441 .36432 m .49651 .35311 L .46111 .32827 L p F P
0 g
s
.589 .039 0 r
.45625 .3215 m .46111 .32827 L .49651 .35311 L p F P
0 g
s
.515 0 0 r
.46111 .32827 m .45625 .3215 L .42027 .30252 L p F P
0 g
s
0 .528 .765 r
.26756 .26241 m .27598 .26375 L .23898 .26087 L p F P
0 g
s
0 .528 .765 r
.23898 .26087 m .22844 .25838 L .26756 .26241 L p F P
0 g
s
.703 .216 0 r
.55716 .42713 m .54651 .40953 L .5125 .37689 L p F P
0 g
s
.677 .181 0 r
.50441 .36432 m .5125 .37689 L .54651 .40953 L p F P
0 g
s
.716 .298 0 r
.62162 .53447 m .60868 .50826 L .57923 .46737 L p F P
0 g
s
.701 .276 0 r
.56806 .44639 m .57923 .46737 L .60868 .50826 L p F P
0 g
s
.397 0 0 r
.42189 .30628 m .42027 .30252 L .38321 .28755 L p F P
0 g
s
.397 0 0 r
.38321 .28755 m .38149 .28869 L .42189 .30628 L p F P
0 g
s
.048 .601 .824 r
.16121 .24473 m .17292 .24685 L .13965 .25138 L p F P
0 g
s
.048 .601 .824 r
.13965 .25138 m .12693 .24872 L .16121 .24473 L p F P
0 g
s
.515 0 0 r
.42027 .30252 m .42189 .30628 L .46111 .32827 L p F P
0 g
s
.287 0 0 r
.37973 .29038 m .38149 .28869 L .34267 .27668 L p F P
0 g
s
.287 0 0 r
.34267 .27668 m .33768 .27612 L .37973 .29038 L p F P
0 g
s
.146 0 0 r
.19572 .25127 m .18442 .24903 L .21945 .25634 L p F P
0 g
s
0 .508 .746 r
.23422 .25898 m .22844 .25838 L p .23361 .25887 L F P
0 g
s
0 .508 .746 r
.22844 .25838 m .21773 .25595 L .25895 .26125 L p F P
0 g
s
.146 0 0 r
.21945 .25634 m .23197 .25896 L p .22063 .25655 L F P
0 g
s
0 .488 .727 r
.25016 .26029 m .25895 .26125 L .21964 .2562 L p F P
0 g
s
0 .488 .727 r
.21964 .2562 m .21773 .25595 L p .22033 .2563 L F P
0 g
s
0 .488 .727 r
.22033 .2563 m .25016 .26029 L .21964 .2562 L F
.21773 .25595 m .20682 .25358 L .25016 .26029 L p F P
0 g
s
0 .467 .708 r
.24116 .25952 m .25016 .26029 L .20682 .25358 L p F P
0 g
s
0 .467 .708 r
.20682 .25358 m .19572 .25127 L .23697 .25876 L p F P
0 g
s
0 .467 .708 r
.23697 .25876 m .24116 .25952 L p .23555 .25855 L F P
0 g
s
0 .467 .708 r
.20682 .25358 m .23697 .25876 L .23555 .25855 L F
.146 0 0 r
.19572 .25127 m .21945 .25634 L .22063 .25655 L F
0 .508 .746 r
.25895 .26125 m .26756 .26241 L .23422 .25898 L p F P
0 g
s
0 .508 .746 r
.23361 .25887 m .25895 .26125 L .23422 .25898 L F
.183 0 0 r
.32733 .27603 m .33257 .27591 L .2923 .26698 L p F P
0 g
s
.183 0 0 r
.2923 .26698 m .28423 .26528 L .32733 .27603 L p F P
0 g
s
.032 .59 .814 r
.14928 .24269 m .16121 .24473 L .12693 .24872 L p F P
0 g
s
.032 .59 .814 r
.12693 .24872 m .11404 .24606 L .14928 .24269 L p F P
0 g
s
.66 .127 0 r
.5125 .37689 m .50441 .36432 L .46609 .33609 L p F P
0 g
s
.627 .085 0 r
.46111 .32827 m .46609 .33609 L .50441 .36432 L p F P
0 g
s
.728 .318 0 r
.63485 .56265 m .62162 .53447 L .59067 .49013 L p F P
0 g
s
.716 .298 0 r
.57923 .46737 m .59067 .49013 L .62162 .53447 L p F P
0 g
s
.557 0 0 r
.46609 .33609 m .46111 .32827 L .42189 .30628 L p F P
0 g
s
.725 .247 0 r
.56806 .44639 m .55716 .42713 L .52081 .39085 L p F P
0 g
s
.703 .216 0 r
.5125 .37689 m .52081 .39085 L .55716 .42713 L p F P
0 g
s
.441 0 0 r
.42355 .31083 m .42189 .30628 L .38149 .28869 L p F P
0 g
s
.441 0 0 r
.38149 .28869 m .37973 .29038 L .42355 .31083 L p F P
0 g
s
.328 0 0 r
.37792 .29263 m .37973 .29038 L .33768 .27612 L p F P
0 g
s
.328 0 0 r
.33768 .27612 m .33257 .27591 L .37792 .29263 L p F P
0 g
s
.557 0 0 r
.42189 .30628 m .42355 .31083 L .46609 .33609 L p F P
0 g
s
.017 .578 .804 r
.13713 .24072 m .14928 .24269 L .11404 .24606 L p F P
0 g
s
.017 .578 .804 r
.11404 .24606 m .10099 .2434 L .13713 .24072 L p F P
0 g
s
.217 0 0 r
.32197 .27653 m .32733 .27603 L .28423 .26528 L p F P
0 g
s
.217 0 0 r
.28423 .26528 m .27598 .26375 L .32197 .27653 L p F P
0 g
s
.739 .337 0 r
.64838 .59286 m .63485 .56265 L .60242 .51476 L p F P
0 g
s
.728 .318 0 r
.59067 .49013 m .60242 .51476 L .63485 .56265 L p F P
0 g
s
.689 .165 0 r
.52081 .39085 m .5125 .37689 L .4712 .34501 L p F P
0 g
s
.66 .127 0 r
.46609 .33609 m .4712 .34501 L .5125 .37689 L p F P
0 g
s
.744 .276 0 r
.57923 .46737 m .56806 .44639 L .52933 .40627 L p F P
0 g
s
.725 .247 0 r
.52081 .39085 m .52933 .40627 L .56806 .44639 L p F P
0 g
s
.001 .567 .793 r
.12475 .23882 m .13713 .24072 L .10099 .2434 L p F P
0 g
s
.001 .567 .793 r
.10099 .2434 m .08776 .24073 L .12475 .23882 L p F P
0 g
s
.594 .029 0 r
.4712 .34501 m .46609 .33609 L .42355 .31083 L p F P
0 g
s
.482 0 0 r
.42526 .31621 m .42355 .31083 L .37973 .29038 L p F P
0 g
s
.482 0 0 r
.37973 .29038 m .37792 .29263 L .42526 .31621 L p F P
0 g
s
.367 0 0 r
.37606 .29547 m .37792 .29263 L .33257 .27591 L p F P
0 g
s
.367 0 0 r
.33257 .27591 m .32733 .27603 L .37606 .29547 L p F P
0 g
s
.594 .029 0 r
.42355 .31083 m .42526 .31621 L .4712 .34501 L p F P
0 g
s
.25 0 0 r
.31647 .27739 m .32197 .27653 L .27598 .26375 L p F P
0 g
s
.25 0 0 r
.27598 .26375 m .26756 .26241 L .31647 .27739 L p F P
0 g
s
0 .555 .782 r
.11214 .237 m .12475 .23882 L .08776 .24073 L p F P
0 g
s
0 .555 .782 r
.08776 .24073 m .07436 .23806 L .11214 .237 L p F P
0 g
s
.748 .353 0 r
.66223 .62519 m .64838 .59286 L .61447 .54132 L p F P
0 g
s
.739 .337 0 r
.60242 .51476 m .61447 .54132 L .64838 .59286 L p F P
0 g
s
.761 .301 0 r
.59067 .49013 m .57923 .46737 L .53808 .42321 L p F P
0 g
s
.744 .276 0 r
.52933 .40627 m .53808 .42321 L .57923 .46737 L p F P
0 g
s
.715 .2 0 r
.52933 .40627 m .52081 .39085 L .47646 .35507 L p F P
0 g
s
.689 .165 0 r
.4712 .34501 m .47646 .35507 L .52081 .39085 L p F P
0 g
s
.146 0 0 r
.23197 .25896 m .24116 .25952 L .19572 .25127 L p F P
0 g
s
.628 .07 0 r
.47646 .35507 m .4712 .34501 L .42526 .31621 L p F P
0 g
s
.52 0 0 r
.42702 .32245 m .42526 .31621 L .37792 .29263 L p F P
0 g
s
.52 0 0 r
.37792 .29263 m .37606 .29547 L .42702 .32245 L p F P
0 g
s
.403 0 0 r
.37415 .29891 m .37606 .29547 L .32733 .27603 L p F P
0 g
s
.403 0 0 r
.32733 .27603 m .32197 .27653 L .37415 .29891 L p F P
0 g
s
.281 0 0 r
.31083 .27865 m .31647 .27739 L .26756 .26241 L p F P
0 g
s
.281 0 0 r
.26756 .26241 m .25895 .26125 L .31083 .27865 L p F P
0 g
s
.757 .368 0 r
.67641 .65972 m .66223 .62519 L .62686 .56991 L p F P
0 g
s
.748 .353 0 r
.61447 .54132 m .62686 .56991 L .66223 .62519 L p F P
0 g
s
.628 .07 0 r
.42526 .31621 m .42702 .32245 L .47646 .35507 L p F P
0 g
s
.17 0 0 r
.22256 .25861 m .23197 .25896 L .18442 .24903 L p F P
0 g
s
.17 0 0 r
.18442 .24903 m .17292 .24685 L .22256 .25861 L p F P
0 g
s
.776 .324 0 r
.60242 .51476 m .59067 .49013 L .54708 .44173 L p F P
0 g
s
.761 .301 0 r
.53808 .42321 m .54708 .44173 L .59067 .49013 L p F P
0 g
s
.737 .231 0 r
.53808 .42321 m .52933 .40627 L .48186 .36633 L p F P
0 g
s
.715 .2 0 r
.47646 .35507 m .48186 .36633 L .52933 .40627 L p F P
0 g
s
.658 .108 0 r
.48186 .36633 m .47646 .35507 L .42702 .32245 L p F P
0 g
s
.312 0 0 r
.30505 .28031 m .31083 .27865 L .25895 .26125 L p F P
0 g
s
.312 0 0 r
.25895 .26125 m .25016 .26029 L .30505 .28031 L p F P
0 g
s
.764 .381 0 r
.69095 .69653 m .67641 .65972 L .63959 .6006 L p F P
0 g
s
.757 .368 0 r
.62686 .56991 m .63959 .6006 L .67641 .65972 L p F P
0 g
s
.437 0 0 r
.37219 .30299 m .37415 .29891 L .32197 .27653 L p F P
0 g
s
.437 0 0 r
.32197 .27653 m .31647 .27739 L .37219 .30299 L p F P
0 g
s
.554 0 0 r
.42882 .32959 m .42702 .32245 L .37606 .29547 L p F P
0 g
s
.554 0 0 r
.37606 .29547 m .37415 .29891 L .42882 .32959 L p F P
0 g
s
.194 0 0 r
.21294 .25848 m .22256 .25861 L .17292 .24685 L p F P
0 g
s
.194 0 0 r
.17292 .24685 m .16121 .24473 L .21294 .25848 L p F P
0 g
s
.658 .108 0 r
.42702 .32245 m .42882 .32959 L .48186 .36633 L p F P
0 g
s
.789 .344 0 r
.61447 .54132 m .60242 .51476 L .55633 .4619 L p F P
0 g
s
.776 .324 0 r
.54708 .44173 m .55633 .4619 L .60242 .51476 L p F P
0 g
s
.757 .259 0 r
.54708 .44173 m .53808 .42321 L .48742 .37883 L p F P
0 g
s
.737 .231 0 r
.48186 .36633 m .48742 .37883 L .53808 .42321 L p F P
0 g
s
.217 0 0 r
.20309 .25858 m .21294 .25848 L .16121 .24473 L p F P
0 g
s
.217 0 0 r
.16121 .24473 m .14928 .24269 L .20309 .25858 L p F P
0 g
s
.341 0 0 r
.29911 .28239 m .30505 .28031 L .25016 .26029 L p F P
0 g
s
.341 0 0 r
.25016 .26029 m .24116 .25952 L .29911 .28239 L p F P
0 g
s
.77 .393 0 r
.70586 .73573 m .69095 .69653 L .65268 .63351 L p F P
0 g
s
.764 .381 0 r
.63959 .6006 m .65268 .63351 L .69095 .69653 L p F P
0 g
s
.684 .143 0 r
.48742 .37883 m .48186 .36633 L .42882 .32959 L p F P
0 g
s
.469 0 0 r
.37017 .30773 m .37219 .30299 L .31647 .27739 L p F P
0 g
s
.469 0 0 r
.31647 .27739 m .31083 .27865 L .37017 .30773 L p F P
0 g
s
.585 .01 0 r
.43068 .33767 m .42882 .32959 L .37415 .29891 L p F P
0 g
s
.585 .01 0 r
.37415 .29891 m .37219 .30299 L .43068 .33767 L p F P
0 g
s
.684 .143 0 r
.42882 .32959 m .43068 .33767 L .48742 .37883 L p F P
0 g
s
.801 .363 0 r
.62686 .56991 m .61447 .54132 L .56585 .4838 L p F P
0 g
s
.789 .344 0 r
.55633 .4619 m .56585 .4838 L .61447 .54132 L p F P
0 g
s
.24 0 0 r
.193 .25892 m .20309 .25858 L .14928 .24269 L p F P
0 g
s
.24 0 0 r
.14928 .24269 m .13713 .24072 L .193 .25892 L p F P
0 g
s
.775 .285 0 r
.55633 .4619 m .54708 .44173 L .49314 .39264 L p F P
0 g
s
.757 .259 0 r
.48742 .37883 m .49314 .39264 L .54708 .44173 L p F P
0 g
s
.368 0 0 r
.29302 .2849 m .29911 .28239 L .24116 .25952 L p F P
0 g
s
.368 0 0 r
.24116 .25952 m .23197 .25896 L .29302 .2849 L p F P
0 g
s
.775 .404 0 r
.72117 .77741 m .70586 .73573 L .66616 .66872 L p F P
0 g
s
.77 .393 0 r
.65268 .63351 m .66616 .66872 L .70586 .73573 L p F P
0 g
s
.708 .174 0 r
.49314 .39264 m .48742 .37883 L .43068 .33767 L p F P
0 g
s
.499 0 0 r
.3681 .31316 m .37017 .30773 L .31083 .27865 L p F P
0 g
s
.499 0 0 r
.31083 .27865 m .30505 .28031 L .3681 .31316 L p F P
0 g
s
.613 .045 0 r
.43259 .34672 m .43068 .33767 L .37219 .30299 L p F P
0 g
s
.613 .045 0 r
.37219 .30299 m .37017 .30773 L .43259 .34672 L p F P
0 g
s
.262 0 0 r
.18267 .2595 m .193 .25892 L .13713 .24072 L p F P
0 g
s
.262 0 0 r
.13713 .24072 m .12475 .23882 L .18267 .2595 L p F P
0 g
s
.811 .38 0 r
.63959 .6006 m .62686 .56991 L .57566 .5075 L p F P
0 g
s
.801 .363 0 r
.56585 .4838 m .57566 .5075 L .62686 .56991 L p F P
0 g
s
.708 .174 0 r
.43068 .33767 m .43259 .34672 L .49314 .39264 L p F P
0 g
s
.395 0 0 r
.28676 .28787 m .29302 .2849 L .23197 .25896 L p F P
0 g
s
.395 0 0 r
.23197 .25896 m .22256 .25861 L .28676 .28787 L p F P
0 g
s
.78 .414 0 r
.73689 .82168 m .72117 .77741 L .68005 .70635 L p F P
0 g
s
.775 .404 0 r
.66616 .66872 m .68005 .70635 L .72117 .77741 L p F P
0 g
s
.79 .309 0 r
.56585 .4838 m .55633 .4619 L .49903 .4078 L p F P
0 g
s
.775 .285 0 r
.49314 .39264 m .49903 .4078 L .55633 .4619 L p F P
0 g
s
.526 0 0 r
.36596 .31931 m .3681 .31316 L .30505 .28031 L p F P
0 g
s
.526 0 0 r
.30505 .28031 m .29911 .28239 L .36596 .31931 L p F P
0 g
s
.283 0 0 r
.17208 .26033 m .18267 .2595 L .12475 .23882 L p F P
0 g
s
.283 0 0 r
.12475 .23882 m .11214 .237 L .17208 .26033 L p F P
0 g
s
.729 .203 0 r
.49903 .4078 m .49314 .39264 L .43259 .34672 L p F P
0 g
s
.638 .077 0 r
.43456 .3568 m .43259 .34672 L .37017 .30773 L p F P
0 g
s
.638 .077 0 r
.37017 .30773 m .3681 .31316 L .43456 .3568 L p F P
0 g
s
.82 .396 0 r
.65268 .63351 m .63959 .6006 L .58577 .5331 L p F P
0 g
s
.811 .38 0 r
.57566 .5075 m .58577 .5331 L .63959 .6006 L p F P
0 g
s
.42 0 0 r
.28033 .29131 m .28676 .28787 L .22256 .25861 L p F P
0 g
s
.42 0 0 r
.22256 .25861 m .21294 .25848 L .28033 .29131 L p F P
0 g
s
.729 .203 0 r
.43259 .34672 m .43456 .3568 L .49903 .4078 L p F P
0 g
s
.784 .423 0 r
.75305 .86866 m .73689 .82168 L .69438 .74651 L p F P
0 g
s
.78 .414 0 r
.68005 .70635 m .69438 .74651 L .73689 .82168 L p F P
0 g
s
.804 .33 0 r
.57566 .5075 m .56585 .4838 L .5051 .42438 L p F P
0 g
s
.79 .309 0 r
.49903 .4078 m .5051 .42438 L .56585 .4838 L p F P
0 g
s
.551 0 0 r
.36377 .3262 m .36596 .31931 L .29911 .28239 L p F P
0 g
s
.551 0 0 r
.29911 .28239 m .29302 .2849 L .36377 .3262 L p F P
0 g
s
.748 .23 0 r
.5051 .42438 m .49903 .4078 L .43456 .3568 L p F P
0 g
s
.661 .107 0 r
.43659 .36794 m .43456 .3568 L .3681 .31316 L p F P
0 g
s
.661 .107 0 r
.3681 .31316 m .36596 .31931 L .43659 .36794 L p F P
0 g
s
.444 0 0 r
.27372 .29524 m .28033 .29131 L .21294 .25848 L p F P
0 g
s
.444 0 0 r
.21294 .25848 m .20309 .25858 L .27372 .29524 L p F P
0 g
s
.828 .41 0 r
.66616 .66872 m .65268 .63351 L .5962 .56068 L p F P
0 g
s
.82 .396 0 r
.58577 .5331 m .5962 .56068 L .65268 .63351 L p F P
0 g
s
.784 .423 0 r
.69438 .74651 m .70916 .78935 L .75305 .86866 L p F P
0 g
s
.748 .23 0 r
.43456 .3568 m .43659 .36794 L .5051 .42438 L p F P
0 g
s
.817 .35 0 r
.58577 .5331 m .57566 .5075 L .51136 .44246 L p F P
0 g
s
.804 .33 0 r
.5051 .42438 m .51136 .44246 L .57566 .5075 L p F P
0 g
s
.575 0 0 r
.3615 .33389 m .36377 .3262 L .29302 .2849 L p F P
0 g
s
.575 0 0 r
.29302 .2849 m .28676 .28787 L .3615 .33389 L p F P
0 g
s
.467 0 0 r
.26691 .29969 m .27372 .29524 L .20309 .25858 L p F P
0 g
s
.467 0 0 r
.20309 .25858 m .193 .25892 L .26691 .29969 L p F P
0 g
s
.764 .254 0 r
.51136 .44246 m .5051 .42438 L .43659 .36794 L p F P
0 g
s
.682 .135 0 r
.43869 .3802 m .43659 .36794 L .36596 .31931 L p F P
0 g
s
.682 .135 0 r
.36596 .31931 m .36377 .3262 L .43869 .3802 L p F P
0 g
s
.835 .423 0 r
.68005 .70635 m .66616 .66872 L .60696 .59035 L p F P
0 g
s
.828 .41 0 r
.5962 .56068 m .60696 .59035 L .66616 .66872 L p F P
0 g
s
.764 .254 0 r
.43659 .36794 m .43869 .3802 L .51136 .44246 L p F P
0 g
s
.828 .367 0 r
.5962 .56068 m .58577 .5331 L .51782 .46209 L p F P
0 g
s
.817 .35 0 r
.51136 .44246 m .51782 .46209 L .58577 .5331 L p F P
0 g
s
.597 .024 0 r
.35917 .34239 m .3615 .33389 L .28676 .28787 L p F P
0 g
s
.597 .024 0 r
.28676 .28787 m .28033 .29131 L .35917 .34239 L p F P
0 g
s
.488 0 0 r
.25991 .30467 m .26691 .29969 L .193 .25892 L p F P
0 g
s
.488 0 0 r
.193 .25892 m .18267 .2595 L .25991 .30467 L p F P
0 g
s
.78 .277 0 r
.51782 .46209 m .51136 .44246 L .43869 .3802 L p F P
0 g
s
.841 .434 0 r
.69438 .74651 m .68005 .70635 L .61808 .62221 L p F P
0 g
s
.835 .423 0 r
.60696 .59035 m .61808 .62221 L .68005 .70635 L p F P
0 g
s
.701 .161 0 r
.44085 .39364 m .43869 .3802 L .36377 .3262 L p F P
0 g
s
.701 .161 0 r
.36377 .3262 m .3615 .33389 L .44085 .39364 L p F P
0 g
s
.78 .277 0 r
.43869 .3802 m .44085 .39364 L .51782 .46209 L p F P
0 g
s
.617 .05 0 r
.35676 .35176 m .35917 .34239 L .28033 .29131 L p F P
0 g
s
.617 .05 0 r
.28033 .29131 m .27372 .29524 L .35676 .35176 L p F P
0 g
s
.508 0 0 r
.2527 .31021 m .25991 .30467 L .18267 .2595 L p F P
0 g
s
.508 0 0 r
.18267 .2595 m .17208 .26033 L .2527 .31021 L p F P
0 g
s
.837 .384 0 r
.60696 .59035 m .5962 .56068 L .5245 .48338 L p F P
0 g
s
.828 .367 0 r
.51782 .46209 m .5245 .48338 L .5962 .56068 L p F P
0 g
s
.847 .445 0 r
.70916 .78935 m .69438 .74651 L .62958 .65638 L p F P
0 g
s
.841 .434 0 r
.61808 .62221 m .62958 .65638 L .69438 .74651 L p F P
0 g
s
.793 .298 0 r
.5245 .48338 m .51782 .46209 L .44085 .39364 L p F P
0 g
s
.718 .185 0 r
.44308 .40831 m .44085 .39364 L .3615 .33389 L p F P
0 g
s
.718 .185 0 r
.3615 .33389 m .35917 .34239 L .44308 .40831 L p F P
0 g
s
.636 .074 0 r
.35428 .36202 m .35676 .35176 L .27372 .29524 L p F P
0 g
s
.636 .074 0 r
.27372 .29524 m .26691 .29969 L .35428 .36202 L p F P
0 g
s
.793 .298 0 r
.44085 .39364 m .44308 .40831 L .5245 .48338 L p F P
0 g
s
.846 .399 0 r
.61808 .62221 m .60696 .59035 L .5314 .50639 L p F P
0 g
s
.837 .384 0 r
.5245 .48338 m .5314 .50639 L .60696 .59035 L p F P
0 g
s
.847 .445 0 r
.62958 .65638 m .64149 .69298 L .70916 .78935 L p F P
0 g
s
.734 .207 0 r
.44538 .42427 m .44308 .40831 L .35917 .34239 L p F P
0 g
s
.734 .207 0 r
.35917 .34239 m .35676 .35176 L .44538 .42427 L p F P
0 g
s
.805 .317 0 r
.5314 .50639 m .5245 .48338 L .44308 .40831 L p F P
0 g
s
.653 .097 0 r
.35171 .37323 m .35428 .36202 L .26691 .29969 L p F P
0 g
s
.653 .097 0 r
.26691 .29969 m .25991 .30467 L .35171 .37323 L p F P
0 g
s
.805 .317 0 r
.44308 .40831 m .44538 .42427 L .5314 .50639 L p F P
0 g
s
.854 .413 0 r
.62958 .65638 m .61808 .62221 L .53854 .53122 L p F P
0 g
s
.846 .399 0 r
.5314 .50639 m .53854 .53122 L .61808 .62221 L p F P
0 g
s
.748 .228 0 r
.44777 .4416 m .44538 .42427 L .35676 .35176 L p F P
0 g
s
.748 .228 0 r
.35676 .35176 m .35428 .36202 L .44777 .4416 L p F P
0 g
s
.816 .334 0 r
.53854 .53122 m .5314 .50639 L .44538 .42427 L p F P
0 g
s
.669 .118 0 r
.34906 .38544 m .35171 .37323 L .25991 .30467 L p F P
0 g
s
.669 .118 0 r
.25991 .30467 m .2527 .31021 L .34906 .38544 L p F P
0 g
s
.816 .334 0 r
.44538 .42427 m .44777 .4416 L .53854 .53122 L p F P
0 g
s
.861 .425 .009 r
.64149 .69298 m .62958 .65638 L .54593 .55797 L p F P
0 g
s
.854 .413 0 r
.53854 .53122 m .54593 .55797 L .62958 .65638 L p F P
0 g
s
.761 .247 0 r
.45024 .46036 m .44777 .4416 L .35428 .36202 L p F P
0 g
s
.761 .247 0 r
.35428 .36202 m .35171 .37323 L .45024 .46036 L p F P
0 g
s
.826 .351 0 r
.54593 .55797 m .53854 .53122 L .44777 .4416 L p F P
0 g
s
.826 .351 0 r
.44777 .4416 m .45024 .46036 L .54593 .55797 L p F P
0 g
s
.861 .425 .009 r
.54593 .55797 m .55359 .58674 L .64149 .69298 L p F P
0 g
s
.773 .265 0 r
.45279 .48063 m .45024 .46036 L .35171 .37323 L p F P
0 g
s
.773 .265 0 r
.35171 .37323 m .34906 .38544 L .45279 .48063 L p F P
0 g
s
.835 .366 .009 r
.55359 .58674 m .54593 .55797 L .45024 .46036 L p F P
0 g
s
.835 .366 .009 r
.45024 .46036 m .45279 .48063 L .55359 .58674 L p F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.38.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.38.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.38.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.38.1", "1.1"}],
    Cell[1920, 61, 746, 17, 104, "Text",
      CellTags->{"S5.38.1", "1.2"}],
    Cell[2669, 80, 11190, 350, 184, "DefinitionBox",
      CellTags->"S5.38.1"],
    Cell[13862, 432, 79, 1, 15, "Caption",
      CellTags->"S5.38.1"],
    Cell[13944, 435, 78, 1, 40, "MathCaption",
      CellTags->{"S5.38.1", "1.3"}],
    Cell[14025, 438, 91, 2, 28, "Input",
      CellTags->"S5.38.1"],
    Cell[14119, 442, 133, 3, 40, "MathCaption",
      CellTags->{"S5.38.1", "1.4"}],
    Cell[14277, 449, 183, 7, 79, "Input",
      CellTags->"S5.38.1"],
    Cell[14463, 458, 62119, 3390, 186, 62048, 3387, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.38.1"],
    Cell[76585, 3850, 182, 6, 70, "Output",
      CellTags->"S5.38.1"],
    Cell[76782, 3859, 168, 5, 70, "MathCaption",
      CellTags->{"S5.38.1", "1.5"}],
    Cell[76975, 3868, 181, 6, 70, "Input",
      CellTags->"S5.38.1"],
    Cell[77159, 3876, 5655, 341, 70, 5584, 338, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.38.1"],
    Cell[82817, 4219, 182, 6, 70, "Output",
      CellTags->"S5.38.1"],
    Cell[83014, 4228, 1090, 36, 70, "Text",
      CellTags->{"S5.38.1", "1.6"}],
    Cell[84107, 4266, 4880, 152, 70, "DefinitionBox",
      CellTags->"S5.38.1"],
    Cell[88990, 4420, 85, 1, 70, "Caption",
      CellTags->"S5.38.1"],
    Cell[89078, 4423, 151, 4, 70, "MathCaption",
      CellTags->{"S5.38.1", "1.7"}],
    Cell[89254, 4431, 123, 5, 70, "Input",
      CellTags->"S5.38.1"],
    Cell[89380, 4438, 130133, 7006, 70, 130062, 7003, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.38.1"],
    Cell[219516, 11446, 182, 6, 70, "Output",
      CellTags->"S5.38.1"],
    Cell[219713, 11455, 192, 5, 70, "MathCaption",
      CellTags->{"S5.38.1", "1.8"}],
    Cell[219930, 11464, 150, 5, 70, "Input",
      CellTags->"S5.38.1"],
    Cell[220083, 11471, 132975, 7122, 70, 132904, 7119, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.38.1"],
    Cell[353061, 18595, 182, 6, 70, "Output",
      CellTags->"S5.38.1"],
    Cell[353258, 18604, 152, 5, 70, "MathCaption",
      CellTags->{"S5.38.1", "1.9"}],
    Cell[353435, 18613, 211, 7, 70, "Input",
      CellTags->"S5.38.1"],
    Cell[353649, 18622, 130246, 6900, 70, 130175, 6897, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.38.1"],
    Cell[483898, 25524, 182, 6, 70, "Output",
      CellTags->"S5.38.1"]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.38.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 746, 17, 104, "Text",
      CellTags->{"S5.38.1", "1.2"}]},
  "1.3"->{
    Cell[13944, 435, 78, 1, 40, "MathCaption",
      CellTags->{"S5.38.1", "1.3"}]},
  "1.4"->{
    Cell[14119, 442, 133, 3, 40, "MathCaption",
      CellTags->{"S5.38.1", "1.4"}]},
  "1.5"->{
    Cell[76782, 3859, 168, 5, 70, "MathCaption",
      CellTags->{"S5.38.1", "1.5"}]},
  "1.6"->{
    Cell[83014, 4228, 1090, 36, 70, "Text",
      CellTags->{"S5.38.1", "1.6"}]},
  "1.7"->{
    Cell[89078, 4423, 151, 4, 70, "MathCaption",
      CellTags->{"S5.38.1", "1.7"}]},
  "1.8"->{
    Cell[219713, 11455, 192, 5, 70, "MathCaption",
      CellTags->{"S5.38.1", "1.8"}]},
  "1.9"->{
    Cell[353258, 18604, 152, 5, 70, "MathCaption",
      CellTags->{"S5.38.1", "1.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.38.1", 484731, 25550},
  {"1.1", 487391, 25619},
  {"1.2", 487485, 25622},
  {"1.3", 487575, 25625},
  {"1.4", 487671, 25628},
  {"1.5", 487768, 25631},
  {"1.6", 487866, 25634},
  {"1.7", 487959, 25637},
  {"1.8", 488057, 25640},
  {"1.9", 488157, 25643}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 36, "Subsection",
  CellTags->{"S5.38.1", "1.1"}],
Cell[1920, 61, 746, 17, 104, "Text",
  CellTags->{"S5.38.1", "1.2"}],
Cell[2669, 80, 11190, 350, 184, "DefinitionBox",
  CellTags->"S5.38.1"],
Cell[13862, 432, 79, 1, 15, "Caption",
  CellTags->"S5.38.1"],
Cell[13944, 435, 78, 1, 40, "MathCaption",
  CellTags->{"S5.38.1", "1.3"}],
Cell[14025, 438, 91, 2, 28, "Input",
  CellTags->"S5.38.1"],
Cell[14119, 442, 133, 3, 40, "MathCaption",
  CellTags->{"S5.38.1", "1.4"}],

Cell[CellGroupData[{
Cell[14277, 449, 183, 7, 79, "Input",
  CellTags->"S5.38.1"],
Cell[14463, 458, 62119, 3390, 186, 62048, 3387, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.38.1"],
Cell[76585, 3850, 182, 6, 70, "Output",
  CellTags->"S5.38.1"]
}, Open  ]],
Cell[76782, 3859, 168, 5, 70, "MathCaption",
  CellTags->{"S5.38.1", "1.5"}],

Cell[CellGroupData[{
Cell[76975, 3868, 181, 6, 70, "Input",
  CellTags->"S5.38.1"],
Cell[77159, 3876, 5655, 341, 70, 5584, 338, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.38.1"],
Cell[82817, 4219, 182, 6, 70, "Output",
  CellTags->"S5.38.1"]
}, Open  ]],
Cell[83014, 4228, 1090, 36, 70, "Text",
  CellTags->{"S5.38.1", "1.6"}],
Cell[84107, 4266, 4880, 152, 70, "DefinitionBox",
  CellTags->"S5.38.1"],
Cell[88990, 4420, 85, 1, 70, "Caption",
  CellTags->"S5.38.1"],
Cell[89078, 4423, 151, 4, 70, "MathCaption",
  CellTags->{"S5.38.1", "1.7"}],

Cell[CellGroupData[{
Cell[89254, 4431, 123, 5, 70, "Input",
  CellTags->"S5.38.1"],
Cell[89380, 4438, 130133, 7006, 70, 130062, 7003, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.38.1"],
Cell[219516, 11446, 182, 6, 70, "Output",
  CellTags->"S5.38.1"]
}, Open  ]],
Cell[219713, 11455, 192, 5, 70, "MathCaption",
  CellTags->{"S5.38.1", "1.8"}],

Cell[CellGroupData[{
Cell[219930, 11464, 150, 5, 70, "Input",
  CellTags->"S5.38.1"],
Cell[220083, 11471, 132975, 7122, 70, 132904, 7119, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.38.1"],
Cell[353061, 18595, 182, 6, 70, "Output",
  CellTags->"S5.38.1"]
}, Open  ]],
Cell[353258, 18604, 152, 5, 70, "MathCaption",
  CellTags->{"S5.38.1", "1.9"}],

Cell[CellGroupData[{
Cell[353435, 18613, 211, 7, 70, "Input",
  CellTags->"S5.38.1"],
Cell[353649, 18622, 130246, 6900, 70, 130175, 6897, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.38.1"],
Cell[483898, 25524, 182, 6, 70, "Output",
  CellTags->"S5.38.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

