(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18678,        531]*)
(*NotebookOutlinePosition[     21039,        606]*)
(*  CellTagsIndexPosition[     20851,        595]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "PhysicalConstants",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.58.1", "1.1"}],

Cell[TextData[{
 "In addition to providing a comprehensive environment for calculations and a \
programming language, ",
 StyleBox["Mathematica", "TI"],
 " is also a system for representing and presenting scientific and technical \
knowledge. Certain packages are included with ",
 StyleBox["Mathematica", "TI"],
 " to provide easy access to commonly used scientific data, such as the value \
of physical constants and conversion factors for various systems of units. "
}], "Text",
 CellTags->{"S5.58.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SpeedOfLight", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the speed of light is ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["299792458", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" meter/second ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AvogadroConstant", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Avogadro\[CloseCurlyQuote]s constant is approximately ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"6.02214199", "\[Cross]", 
         SuperscriptBox["10", "23"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["mole", 
         RowBox[{"-", "1"}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ElectronMass", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the mass of an electron is approximately ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"9.10938188", "\[Cross]", 
         SuperscriptBox["10", 
          RowBox[{"-", "31"}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" kilograms",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FineStructureConstant", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the fine structure constant is approximately ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"7.297352533", "\[Cross]", 
         SuperscriptBox["10", 
          RowBox[{"-", "3"}]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EarthMass", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the mass of the earth is approximately ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"5.9742", "\[Cross]", 
         SuperscriptBox["10", "24"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" kilograms",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AccelerationDueToGravity", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the acceleration due to gravity is ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["9.80665", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         RowBox[{"meters", "/", "second"}], "2"], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.58.1"],

Cell["Some common physical constants. ", "Caption",
 CellTags->"S5.58.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.58.1", "1.3"}],

Cell["<<Miscellaneous`PhysicalConstants`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.58.1"],

Cell["This gives the mass of a proton. ", "MathCaption",
 CellTags->{"S5.58.1", "1.4"}],

Cell[CellGroupData[{

Cell["ProtonMass", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.58.1"],

Cell[BoxData[
 RowBox[{"1.67262158`*^-27", " ", "Kilogram"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.58.1"]
}, Open  ]],

Cell["\<\
Here is the distance that light could travel in the age of the universe. \
\>", "MathCaption",
 CellTags->{"S5.58.1", "1.5"}],

Cell[CellGroupData[{

Cell["SpeedOfLight AgeOfUniverse", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.58.1"],

Cell[BoxData[
 RowBox[{"1.4090245526`*^26", " ", "Meter"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.58.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["AccelerationDueToGravity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["AgeOfUniverse",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["AvogadroConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["BohrRadius",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["BoltzmannConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ClassicalElectronRadius",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["CosmicBackgroundTemperature",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DeuteronMagneticMoment",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["DeuteronMass",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EarthMass",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["EarthRadius",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ElectronCharge",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ElectronComptonWavelength",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ElectronGFactor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ElectronMagneticMoment",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ElectronMass",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FaradayConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["FineStructureConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GalacticUnit",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GravitationalConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["HubbleConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["IcePoint",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MagneticFluxQuantum",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MolarGasConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MolarVolume",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MuonGFactor",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MuonMagneticMoment",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MuonMass",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NeutronComptonWavelength",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NeutronMagneticMoment",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NeutronMass",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PlanckConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PlanckConstantReduced",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PlanckMass",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ProtonComptonWavelength",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ProtonMagneticMoment",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ProtonMass",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["QuantizedHallConductance",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["RydbergConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SackurTetrodeConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SolarConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SolarLuminosity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SolarRadius",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SolarSchwarzschildRadius",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SpeedOfLight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SpeedOfSound",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["StefanConstant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ThomsonCrossSection",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["VacuumPermeability",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["VacuumPermittivity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["WeakMixingAngle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.58.1"],

Cell["Physical constants.", "Caption",
 CellTags->"S5.58.1"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.58.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S5.58.1", "1.1"}],
    Cell[1926, 61, 512, 10, 72, "Text",
      CellTags->{"S5.58.1", "1.2"}],
    Cell[2441, 73, 5855, 172, 214, "DefinitionBox",
      CellTags->"S5.58.1"],
    Cell[8299, 247, 73, 1, 15, "Caption",
      CellTags->"S5.58.1"],
    Cell[8375, 250, 78, 1, 40, "MathCaption",
      CellTags->{"S5.58.1", "1.3"}],
    Cell[8456, 253, 97, 2, 28, "Input",
      CellTags->"S5.58.1"],
    Cell[8556, 257, 87, 1, 40, "MathCaption",
      CellTags->{"S5.58.1", "1.4"}],
    Cell[8668, 262, 73, 2, 28, "Input",
      CellTags->"S5.58.1"],
    Cell[8744, 266, 118, 3, 27, "Output",
      CellTags->"S5.58.1"],
    Cell[8877, 272, 135, 3, 40, "MathCaption",
      CellTags->{"S5.58.1", "1.5"}],
    Cell[9037, 279, 89, 2, 28, "Input",
      CellTags->"S5.58.1"],
    Cell[9129, 283, 116, 3, 27, "Output",
      CellTags->"S5.58.1"],
    Cell[9260, 289, 9339, 236, 570, "DefinitionBox",
      CellTags->"S5.58.1"],
    Cell[18602, 527, 60, 1, 70, "Caption",
      CellTags->"S5.58.1"]},
  "1.1"->{
    Cell[1776, 53, 147, 6, 36, "Subsection",
      CellTags->{"S5.58.1", "1.1"}]},
  "1.2"->{
    Cell[1926, 61, 512, 10, 72, "Text",
      CellTags->{"S5.58.1", "1.2"}]},
  "1.3"->{
    Cell[8375, 250, 78, 1, 40, "MathCaption",
      CellTags->{"S5.58.1", "1.3"}]},
  "1.4"->{
    Cell[8556, 257, 87, 1, 40, "MathCaption",
      CellTags->{"S5.58.1", "1.4"}]},
  "1.5"->{
    Cell[8877, 272, 135, 3, 40, "MathCaption",
      CellTags->{"S5.58.1", "1.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.58.1", 19301, 547},
  {"1.1", 20368, 576},
  {"1.2", 20462, 579},
  {"1.3", 20551, 582},
  {"1.4", 20646, 585},
  {"1.5", 20741, 588}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 147, 6, 36, "Subsection",
  CellTags->{"S5.58.1", "1.1"}],
Cell[1926, 61, 512, 10, 72, "Text",
  CellTags->{"S5.58.1", "1.2"}],
Cell[2441, 73, 5855, 172, 214, "DefinitionBox",
  CellTags->"S5.58.1"],
Cell[8299, 247, 73, 1, 15, "Caption",
  CellTags->"S5.58.1"],
Cell[8375, 250, 78, 1, 40, "MathCaption",
  CellTags->{"S5.58.1", "1.3"}],
Cell[8456, 253, 97, 2, 28, "Input",
  CellTags->"S5.58.1"],
Cell[8556, 257, 87, 1, 40, "MathCaption",
  CellTags->{"S5.58.1", "1.4"}],

Cell[CellGroupData[{
Cell[8668, 262, 73, 2, 28, "Input",
  CellTags->"S5.58.1"],
Cell[8744, 266, 118, 3, 27, "Output",
  CellTags->"S5.58.1"]
}, Open  ]],
Cell[8877, 272, 135, 3, 40, "MathCaption",
  CellTags->{"S5.58.1", "1.5"}],

Cell[CellGroupData[{
Cell[9037, 279, 89, 2, 28, "Input",
  CellTags->"S5.58.1"],
Cell[9129, 283, 116, 3, 27, "Output",
  CellTags->"S5.58.1"]
}, Open  ]],
Cell[9260, 289, 9339, 236, 570, "DefinitionBox",
  CellTags->"S5.58.1"],
Cell[18602, 527, 60, 1, 70, "Caption",
  CellTags->"S5.58.1"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

