(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    254269,      12165]*)
(*NotebookOutlinePosition[    263117,      12418]*)
(*  CellTagsIndexPosition[    262456,      12390]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "PlotField",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.39.1", "1.1"}],

Cell["\<\
Anything that assigns a magnitude and direction at each point gives a vector \
field. Examples include the electromagnetic field and the velocity field of a \
fluid. Any ordinary differential equation can be used to define a vector \
field. These vector fields can be visualized by drawing arrows representing \
the vectors. The direction of the arrow is equal to the direction of the \
vector field at its base point. The magnitude of the arrow is proportional to \
the magnitude of the vector field. \
\>", "Text",
 CellTags->{"S5.39.1", "1.2"}],

Cell[TextData[{
 "This package plots two\[Hyphen]dimensional vector fields. For vector field \
plots in three dimensions, use the package ",
 StyleBox["Graphics`PlotField3D`", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.39.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PlotVectorField[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the vector field given by the vector\[Hyphen]valued function in \
the range specified",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotGradientField[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the gradient vector field of the scalar\[Hyphen]valued function ",
       
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotHamiltonianField[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the Hamiltonian vector field of the scalar\[Hyphen]valued \
function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.39.1"],

Cell["Plotting vector fields in two dimensions. ", "Caption",
 CellTags->"S5.39.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.39.1", "1.4"}],

Cell["<<Graphics`PlotField`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.39.1"],

Cell[TextData[{
 "The two components of this vector field are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", 
     StyleBox["y",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.39.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
PlotVectorField[{Sin[x], Cos[y]},
             {x, 0, Pi}, {y, 0, Pi}]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.39.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.303152 0.0238095 0.303152 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
0 0 Mdot
grestore
} def
% End of user PostScript
0 g
.0001 w
[ ] 0 setdash
.02381 .02381 m
.02381 .07191 L
s
% Start of user PostScript
0 0 0 0.158674 MAarrowhead1
% End of user PostScript
.02381 .09184 m
.02381 .13873 L
s
% Start of user PostScript
0 0.224399 0 0.379096 MAarrowhead1
% End of user PostScript
.02381 .15986 m
.02381 .2032 L
s
% Start of user PostScript
0 0.448799 0 0.59176 MAarrowhead1
% End of user PostScript
.02381 .22789 m
.02381 .2655 L
s
% Start of user PostScript
0 0.673198 0 0.797255 MAarrowhead1
% End of user PostScript
.02381 .29592 m
.02381 .32591 L
s
% Start of user PostScript
0 0.897598 0 0.99653 MAarrowhead1
% End of user PostScript
.02381 .36395 m
.02381 .38482 L
s
% Start of user PostScript
0 1.122 0 1.19084 MAarrowhead1
% End of user PostScript
.02381 .43197 m
.02381 .44268 L
s
% Start of user PostScript
0 1.3464 0 1.38171 MAarrowhead1
% End of user PostScript
.02381 .5 m
.02381 .5 L
s
% Start of user PostScript
0 1.5708 MAarrowzero1
% End of user PostScript
.02381 .56803 m
.02381 .55732 L
s
% Start of user PostScript
0 1.7952 0 1.75989 MAarrowhead1
% End of user PostScript
.02381 .63605 m
.02381 .61518 L
s
% Start of user PostScript
0 2.0196 0 1.95075 MAarrowhead1
% End of user PostScript
.02381 .70408 m
.02381 .67409 L
s
% Start of user PostScript
0 2.24399 0 2.14506 MAarrowhead1
% End of user PostScript
.02381 .77211 m
.02381 .7345 L
s
% Start of user PostScript
0 2.46839 0 2.34434 MAarrowhead1
% End of user PostScript
.02381 .84014 m
.02381 .7968 L
s
% Start of user PostScript
0 2.69279 0 2.54983 MAarrowhead1
% End of user PostScript
.02381 .90816 m
.02381 .86127 L
s
% Start of user PostScript
0 2.91719 0 2.7625 MAarrowhead1
% End of user PostScript
.02381 .97619 m
.02381 .92809 L
s
% Start of user PostScript
0 3.14159 0 2.98292 MAarrowhead1
% End of user PostScript
.09184 .02381 m
.10254 .07191 L
s
% Start of user PostScript
0.224399 0 0.259708 0.158674 MAarrowhead1
% End of user PostScript
.09184 .09184 m
.10254 .13873 L
s
% Start of user PostScript
0.224399 0.224399 0.259708 0.379096 MAarrowhead1
% End of user PostScript
.09184 .15986 m
.10254 .2032 L
s
% Start of user PostScript
0.224399 0.448799 0.259708 0.59176 MAarrowhead1
% End of user PostScript
.09184 .22789 m
.10254 .2655 L
s
% Start of user PostScript
0.224399 0.673198 0.259708 0.797255 MAarrowhead1
% End of user PostScript
.09184 .29592 m
.10254 .32591 L
s
% Start of user PostScript
0.224399 0.897598 0.259708 0.99653 MAarrowhead1
% End of user PostScript
.09184 .36395 m
.10254 .38482 L
s
% Start of user PostScript
0.224399 1.122 0.259708 1.19084 MAarrowhead1
% End of user PostScript
.09184 .43197 m
.10254 .44268 L
s
% Start of user PostScript
0.224399 1.3464 0.259708 1.38171 MAarrowhead1
% End of user PostScript
.09184 .5 m
.10254 .5 L
s
% Start of user PostScript
0.224399 1.5708 0.259708 1.5708 MAarrowhead1
% End of user PostScript
.09184 .56803 m
.10254 .55732 L
s
% Start of user PostScript
0.224399 1.7952 0.259708 1.75989 MAarrowhead1
% End of user PostScript
.09184 .63605 m
.10254 .61518 L
s
% Start of user PostScript
0.224399 2.0196 0.259708 1.95075 MAarrowhead1
% End of user PostScript
.09184 .70408 m
.10254 .67409 L
s
% Start of user PostScript
0.224399 2.24399 0.259708 2.14506 MAarrowhead1
% End of user PostScript
.09184 .77211 m
.10254 .7345 L
s
% Start of user PostScript
0.224399 2.46839 0.259708 2.34434 MAarrowhead1
% End of user PostScript
.09184 .84014 m
.10254 .7968 L
s
% Start of user PostScript
0.224399 2.69279 0.259708 2.54983 MAarrowhead1
% End of user PostScript
.09184 .90816 m
.10254 .86127 L
s
% Start of user PostScript
0.224399 2.91719 0.259708 2.7625 MAarrowhead1
% End of user PostScript
.09184 .97619 m
.10254 .92809 L
s
% Start of user PostScript
0.224399 3.14159 0.259708 2.98292 MAarrowhead1
% End of user PostScript
.15986 .02381 m
.18073 .07191 L
s
% Start of user PostScript
0.448799 0 0.517645 0.158674 MAarrowhead1
% End of user PostScript
.15986 .09184 m
.18073 .13873 L
s
% Start of user PostScript
0.448799 0.224399 0.517645 0.379096 MAarrowhead1
% End of user PostScript
.15986 .15986 m
.18073 .2032 L
s
% Start of user PostScript
0.448799 0.448799 0.517645 0.59176 MAarrowhead1
% End of user PostScript
.15986 .22789 m
.18073 .2655 L
s
% Start of user PostScript
0.448799 0.673198 0.517645 0.797255 MAarrowhead1
% End of user PostScript
.15986 .29592 m
.18073 .32591 L
s
% Start of user PostScript
0.448799 0.897598 0.517645 0.99653 MAarrowhead1
% End of user PostScript
.15986 .36395 m
.18073 .38482 L
s
% Start of user PostScript
0.448799 1.122 0.517645 1.19084 MAarrowhead1
% End of user PostScript
.15986 .43197 m
.18073 .44268 L
s
% Start of user PostScript
0.448799 1.3464 0.517645 1.38171 MAarrowhead1
% End of user PostScript
.15986 .5 m
.18073 .5 L
s
% Start of user PostScript
0.448799 1.5708 0.517645 1.5708 MAarrowhead1
% End of user PostScript
.15986 .56803 m
.18073 .55732 L
s
% Start of user PostScript
0.448799 1.7952 0.517645 1.75989 MAarrowhead1
% End of user PostScript
.15986 .63605 m
.18073 .61518 L
s
% Start of user PostScript
0.448799 2.0196 0.517645 1.95075 MAarrowhead1
% End of user PostScript
.15986 .70408 m
.18073 .67409 L
s
% Start of user PostScript
0.448799 2.24399 0.517645 2.14506 MAarrowhead1
% End of user PostScript
.15986 .77211 m
.18073 .7345 L
s
% Start of user PostScript
0.448799 2.46839 0.517645 2.34434 MAarrowhead1
% End of user PostScript
.15986 .84014 m
.18073 .7968 L
s
% Start of user PostScript
0.448799 2.69279 0.517645 2.54983 MAarrowhead1
% End of user PostScript
.15986 .90816 m
.18073 .86127 L
s
% Start of user PostScript
0.448799 2.91719 0.517645 2.7625 MAarrowhead1
% End of user PostScript
.15986 .97619 m
.18073 .92809 L
s
% Start of user PostScript
0.448799 3.14159 0.517645 2.98292 MAarrowhead1
% End of user PostScript
.22789 .02381 m
.25788 .07191 L
s
% Start of user PostScript
0.673198 0 0.77213 0.158674 MAarrowhead1
% End of user PostScript
.22789 .09184 m
.25788 .13873 L
s
% Start of user PostScript
0.673198 0.224399 0.77213 0.379096 MAarrowhead1
% End of user PostScript
.22789 .15986 m
.25788 .2032 L
s
% Start of user PostScript
0.673198 0.448799 0.77213 0.59176 MAarrowhead1
% End of user PostScript
.22789 .22789 m
.25788 .2655 L
s
% Start of user PostScript
0.673198 0.673198 0.77213 0.797255 MAarrowhead1
% End of user PostScript
.22789 .29592 m
.25788 .32591 L
s
% Start of user PostScript
0.673198 0.897598 0.77213 0.99653 MAarrowhead1
% End of user PostScript
.22789 .36395 m
.25788 .38482 L
s
% Start of user PostScript
0.673198 1.122 0.77213 1.19084 MAarrowhead1
% End of user PostScript
.22789 .43197 m
.25788 .44268 L
s
% Start of user PostScript
0.673198 1.3464 0.77213 1.38171 MAarrowhead1
% End of user PostScript
.22789 .5 m
.25788 .5 L
s
% Start of user PostScript
0.673198 1.5708 0.77213 1.5708 MAarrowhead1
% End of user PostScript
.22789 .56803 m
.25788 .55732 L
s
% Start of user PostScript
0.673198 1.7952 0.77213 1.75989 MAarrowhead1
% End of user PostScript
.22789 .63605 m
.25788 .61518 L
s
% Start of user PostScript
0.673198 2.0196 0.77213 1.95075 MAarrowhead1
% End of user PostScript
.22789 .70408 m
.25788 .67409 L
s
% Start of user PostScript
0.673198 2.24399 0.77213 2.14506 MAarrowhead1
% End of user PostScript
.22789 .77211 m
.25788 .7345 L
s
% Start of user PostScript
0.673198 2.46839 0.77213 2.34434 MAarrowhead1
% End of user PostScript
.22789 .84014 m
.25788 .7968 L
s
% Start of user PostScript
0.673198 2.69279 0.77213 2.54983 MAarrowhead1
% End of user PostScript
.22789 .90816 m
.25788 .86127 L
s
% Start of user PostScript
0.673198 2.91719 0.77213 2.7625 MAarrowhead1
% End of user PostScript
.22789 .97619 m
.25788 .92809 L
s
% Start of user PostScript
0.673198 3.14159 0.77213 2.98292 MAarrowhead1
% End of user PostScript
.29592 .02381 m
.33353 .07191 L
s
% Start of user PostScript
0.897598 0 1.02165 0.158674 MAarrowhead1
% End of user PostScript
.29592 .09184 m
.33353 .13873 L
s
% Start of user PostScript
0.897598 0.224399 1.02165 0.379096 MAarrowhead1
% End of user PostScript
.29592 .15986 m
.33353 .2032 L
s
% Start of user PostScript
0.897598 0.448799 1.02165 0.59176 MAarrowhead1
% End of user PostScript
.29592 .22789 m
.33353 .2655 L
s
% Start of user PostScript
0.897598 0.673198 1.02165 0.797255 MAarrowhead1
% End of user PostScript
.29592 .29592 m
.33353 .32591 L
s
% Start of user PostScript
0.897598 0.897598 1.02165 0.99653 MAarrowhead1
% End of user PostScript
.29592 .36395 m
.33353 .38482 L
s
% Start of user PostScript
0.897598 1.122 1.02165 1.19084 MAarrowhead1
% End of user PostScript
.29592 .43197 m
.33353 .44268 L
s
% Start of user PostScript
0.897598 1.3464 1.02165 1.38171 MAarrowhead1
% End of user PostScript
.29592 .5 m
.33353 .5 L
s
% Start of user PostScript
0.897598 1.5708 1.02165 1.5708 MAarrowhead1
% End of user PostScript
.29592 .56803 m
.33353 .55732 L
s
% Start of user PostScript
0.897598 1.7952 1.02165 1.75989 MAarrowhead1
% End of user PostScript
.29592 .63605 m
.33353 .61518 L
s
% Start of user PostScript
0.897598 2.0196 1.02165 1.95075 MAarrowhead1
% End of user PostScript
.29592 .70408 m
.33353 .67409 L
s
% Start of user PostScript
0.897598 2.24399 1.02165 2.14506 MAarrowhead1
% End of user PostScript
.29592 .77211 m
.33353 .7345 L
s
% Start of user PostScript
0.897598 2.46839 1.02165 2.34434 MAarrowhead1
% End of user PostScript
.29592 .84014 m
.33353 .7968 L
s
% Start of user PostScript
0.897598 2.69279 1.02165 2.54983 MAarrowhead1
% End of user PostScript
.29592 .90816 m
.33353 .86127 L
s
% Start of user PostScript
0.897598 2.91719 1.02165 2.7625 MAarrowhead1
% End of user PostScript
.29592 .97619 m
.33353 .92809 L
s
% Start of user PostScript
0.897598 3.14159 1.02165 2.98292 MAarrowhead1
% End of user PostScript
.36395 .02381 m
.40728 .07191 L
s
% Start of user PostScript
1.122 0 1.26496 0.158674 MAarrowhead1
% End of user PostScript
.36395 .09184 m
.40728 .13873 L
s
% Start of user PostScript
1.122 0.224399 1.26496 0.379096 MAarrowhead1
% End of user PostScript
.36395 .15986 m
.40728 .2032 L
s
% Start of user PostScript
1.122 0.448799 1.26496 0.59176 MAarrowhead1
% End of user PostScript
.36395 .22789 m
.40728 .2655 L
s
% Start of user PostScript
1.122 0.673198 1.26496 0.797255 MAarrowhead1
% End of user PostScript
.36395 .29592 m
.40728 .32591 L
s
% Start of user PostScript
1.122 0.897598 1.26496 0.99653 MAarrowhead1
% End of user PostScript
.36395 .36395 m
.40728 .38482 L
s
% Start of user PostScript
1.122 1.122 1.26496 1.19084 MAarrowhead1
% End of user PostScript
.36395 .43197 m
.40728 .44268 L
s
% Start of user PostScript
1.122 1.3464 1.26496 1.38171 MAarrowhead1
% End of user PostScript
.36395 .5 m
.40728 .5 L
s
% Start of user PostScript
1.122 1.5708 1.26496 1.5708 MAarrowhead1
% End of user PostScript
.36395 .56803 m
.40728 .55732 L
s
% Start of user PostScript
1.122 1.7952 1.26496 1.75989 MAarrowhead1
% End of user PostScript
.36395 .63605 m
.40728 .61518 L
s
% Start of user PostScript
1.122 2.0196 1.26496 1.95075 MAarrowhead1
% End of user PostScript
.36395 .70408 m
.40728 .67409 L
s
% Start of user PostScript
1.122 2.24399 1.26496 2.14506 MAarrowhead1
% End of user PostScript
.36395 .77211 m
.40728 .7345 L
s
% Start of user PostScript
1.122 2.46839 1.26496 2.34434 MAarrowhead1
% End of user PostScript
.36395 .84014 m
.40728 .7968 L
s
% Start of user PostScript
1.122 2.69279 1.26496 2.54983 MAarrowhead1
% End of user PostScript
.36395 .90816 m
.40728 .86127 L
s
% Start of user PostScript
1.122 2.91719 1.26496 2.7625 MAarrowhead1
% End of user PostScript
.36395 .97619 m
.40728 .92809 L
s
% Start of user PostScript
1.122 3.14159 1.26496 2.98292 MAarrowhead1
% End of user PostScript
.43197 .02381 m
.47887 .07191 L
s
% Start of user PostScript
1.3464 0 1.50109 0.158674 MAarrowhead1
% End of user PostScript
.43197 .09184 m
.47887 .13873 L
s
% Start of user PostScript
1.3464 0.224399 1.50109 0.379096 MAarrowhead1
% End of user PostScript
.43197 .15986 m
.47887 .2032 L
s
% Start of user PostScript
1.3464 0.448799 1.50109 0.59176 MAarrowhead1
% End of user PostScript
.43197 .22789 m
.47887 .2655 L
s
% Start of user PostScript
1.3464 0.673198 1.50109 0.797255 MAarrowhead1
% End of user PostScript
.43197 .29592 m
.47887 .32591 L
s
% Start of user PostScript
1.3464 0.897598 1.50109 0.99653 MAarrowhead1
% End of user PostScript
.43197 .36395 m
.47887 .38482 L
s
% Start of user PostScript
1.3464 1.122 1.50109 1.19084 MAarrowhead1
% End of user PostScript
.43197 .43197 m
.47887 .44268 L
s
% Start of user PostScript
1.3464 1.3464 1.50109 1.38171 MAarrowhead1
% End of user PostScript
.43197 .5 m
.47887 .5 L
s
% Start of user PostScript
1.3464 1.5708 1.50109 1.5708 MAarrowhead1
% End of user PostScript
.43197 .56803 m
.47887 .55732 L
s
% Start of user PostScript
1.3464 1.7952 1.50109 1.75989 MAarrowhead1
% End of user PostScript
.43197 .63605 m
.47887 .61518 L
s
% Start of user PostScript
1.3464 2.0196 1.50109 1.95075 MAarrowhead1
% End of user PostScript
.43197 .70408 m
.47887 .67409 L
s
% Start of user PostScript
1.3464 2.24399 1.50109 2.14506 MAarrowhead1
% End of user PostScript
.43197 .77211 m
.47887 .7345 L
s
% Start of user PostScript
1.3464 2.46839 1.50109 2.34434 MAarrowhead1
% End of user PostScript
.43197 .84014 m
.47887 .7968 L
s
% Start of user PostScript
1.3464 2.69279 1.50109 2.54983 MAarrowhead1
% End of user PostScript
.43197 .90816 m
.47887 .86127 L
s
% Start of user PostScript
1.3464 2.91719 1.50109 2.7625 MAarrowhead1
% End of user PostScript
.43197 .97619 m
.47887 .92809 L
s
% Start of user PostScript
1.3464 3.14159 1.50109 2.98292 MAarrowhead1
% End of user PostScript
.5 .02381 m
.5481 .07191 L
s
% Start of user PostScript
1.5708 0 1.72947 0.158674 MAarrowhead1
% End of user PostScript
.5 .09184 m
.5481 .13873 L
s
% Start of user PostScript
1.5708 0.224399 1.72947 0.379096 MAarrowhead1
% End of user PostScript
.5 .15986 m
.5481 .2032 L
s
% Start of user PostScript
1.5708 0.448799 1.72947 0.59176 MAarrowhead1
% End of user PostScript
.5 .22789 m
.5481 .2655 L
s
% Start of user PostScript
1.5708 0.673198 1.72947 0.797255 MAarrowhead1
% End of user PostScript
.5 .29592 m
.5481 .32591 L
s
% Start of user PostScript
1.5708 0.897598 1.72947 0.99653 MAarrowhead1
% End of user PostScript
.5 .36395 m
.5481 .38482 L
s
% Start of user PostScript
1.5708 1.122 1.72947 1.19084 MAarrowhead1
% End of user PostScript
.5 .43197 m
.5481 .44268 L
s
% Start of user PostScript
1.5708 1.3464 1.72947 1.38171 MAarrowhead1
% End of user PostScript
.5 .5 m
.5481 .5 L
s
% Start of user PostScript
1.5708 1.5708 1.72947 1.5708 MAarrowhead1
% End of user PostScript
.5 .56803 m
.5481 .55732 L
s
% Start of user PostScript
1.5708 1.7952 1.72947 1.75989 MAarrowhead1
% End of user PostScript
.5 .63605 m
.5481 .61518 L
s
% Start of user PostScript
1.5708 2.0196 1.72947 1.95075 MAarrowhead1
% End of user PostScript
.5 .70408 m
.5481 .67409 L
s
% Start of user PostScript
1.5708 2.24399 1.72947 2.14506 MAarrowhead1
% End of user PostScript
.5 .77211 m
.5481 .7345 L
s
% Start of user PostScript
1.5708 2.46839 1.72947 2.34434 MAarrowhead1
% End of user PostScript
.5 .84014 m
.5481 .7968 L
s
% Start of user PostScript
1.5708 2.69279 1.72947 2.54983 MAarrowhead1
% End of user PostScript
.5 .90816 m
.5481 .86127 L
s
% Start of user PostScript
1.5708 2.91719 1.72947 2.7625 MAarrowhead1
% End of user PostScript
.5 .97619 m
.5481 .92809 L
s
% Start of user PostScript
1.5708 3.14159 1.72947 2.98292 MAarrowhead1
% End of user PostScript
.56803 .02381 m
.61492 .07191 L
s
% Start of user PostScript
1.7952 0 1.94989 0.158674 MAarrowhead1
% End of user PostScript
.56803 .09184 m
.61492 .13873 L
s
% Start of user PostScript
1.7952 0.224399 1.94989 0.379096 MAarrowhead1
% End of user PostScript
.56803 .15986 m
.61492 .2032 L
s
% Start of user PostScript
1.7952 0.448799 1.94989 0.59176 MAarrowhead1
% End of user PostScript
.56803 .22789 m
.61492 .2655 L
s
% Start of user PostScript
1.7952 0.673198 1.94989 0.797255 MAarrowhead1
% End of user PostScript
.56803 .29592 m
.61492 .32591 L
s
% Start of user PostScript
1.7952 0.897598 1.94989 0.99653 MAarrowhead1
% End of user PostScript
.56803 .36395 m
.61492 .38482 L
s
% Start of user PostScript
1.7952 1.122 1.94989 1.19084 MAarrowhead1
% End of user PostScript
.56803 .43197 m
.61492 .44268 L
s
% Start of user PostScript
1.7952 1.3464 1.94989 1.38171 MAarrowhead1
% End of user PostScript
.56803 .5 m
.61492 .5 L
s
% Start of user PostScript
1.7952 1.5708 1.94989 1.5708 MAarrowhead1
% End of user PostScript
.56803 .56803 m
.61492 .55732 L
s
% Start of user PostScript
1.7952 1.7952 1.94989 1.75989 MAarrowhead1
% End of user PostScript
.56803 .63605 m
.61492 .61518 L
s
% Start of user PostScript
1.7952 2.0196 1.94989 1.95075 MAarrowhead1
% End of user PostScript
.56803 .70408 m
.61492 .67409 L
s
% Start of user PostScript
1.7952 2.24399 1.94989 2.14506 MAarrowhead1
% End of user PostScript
.56803 .77211 m
.61492 .7345 L
s
% Start of user PostScript
1.7952 2.46839 1.94989 2.34434 MAarrowhead1
% End of user PostScript
.56803 .84014 m
.61492 .7968 L
s
% Start of user PostScript
1.7952 2.69279 1.94989 2.54983 MAarrowhead1
% End of user PostScript
.56803 .90816 m
.61492 .86127 L
s
% Start of user PostScript
1.7952 2.91719 1.94989 2.7625 MAarrowhead1
% End of user PostScript
.56803 .97619 m
.61492 .92809 L
s
% Start of user PostScript
1.7952 3.14159 1.94989 2.98292 MAarrowhead1
% End of user PostScript
.63605 .02381 m
.67939 .07191 L
s
% Start of user PostScript
2.0196 0 2.16256 0.158674 MAarrowhead1
% End of user PostScript
.63605 .09184 m
.67939 .13873 L
s
% Start of user PostScript
2.0196 0.224399 2.16256 0.379096 MAarrowhead1
% End of user PostScript
.63605 .15986 m
.67939 .2032 L
s
% Start of user PostScript
2.0196 0.448799 2.16256 0.59176 MAarrowhead1
% End of user PostScript
.63605 .22789 m
.67939 .2655 L
s
% Start of user PostScript
2.0196 0.673198 2.16256 0.797255 MAarrowhead1
% End of user PostScript
.63605 .29592 m
.67939 .32591 L
s
% Start of user PostScript
2.0196 0.897598 2.16256 0.99653 MAarrowhead1
% End of user PostScript
.63605 .36395 m
.67939 .38482 L
s
% Start of user PostScript
2.0196 1.122 2.16256 1.19084 MAarrowhead1
% End of user PostScript
.63605 .43197 m
.67939 .44268 L
s
% Start of user PostScript
2.0196 1.3464 2.16256 1.38171 MAarrowhead1
% End of user PostScript
.63605 .5 m
.67939 .5 L
s
% Start of user PostScript
2.0196 1.5708 2.16256 1.5708 MAarrowhead1
% End of user PostScript
.63605 .56803 m
.67939 .55732 L
s
% Start of user PostScript
2.0196 1.7952 2.16256 1.75989 MAarrowhead1
% End of user PostScript
.63605 .63605 m
.67939 .61518 L
s
% Start of user PostScript
2.0196 2.0196 2.16256 1.95075 MAarrowhead1
% End of user PostScript
.63605 .70408 m
.67939 .67409 L
s
% Start of user PostScript
2.0196 2.24399 2.16256 2.14506 MAarrowhead1
% End of user PostScript
.63605 .77211 m
.67939 .7345 L
s
% Start of user PostScript
2.0196 2.46839 2.16256 2.34434 MAarrowhead1
% End of user PostScript
.63605 .84014 m
.67939 .7968 L
s
% Start of user PostScript
2.0196 2.69279 2.16256 2.54983 MAarrowhead1
% End of user PostScript
.63605 .90816 m
.67939 .86127 L
s
% Start of user PostScript
2.0196 2.91719 2.16256 2.7625 MAarrowhead1
% End of user PostScript
.63605 .97619 m
.67939 .92809 L
s
% Start of user PostScript
2.0196 3.14159 2.16256 2.98292 MAarrowhead1
% End of user PostScript
.70408 .02381 m
.74169 .07191 L
s
% Start of user PostScript
2.24399 0 2.36805 0.158674 MAarrowhead1
% End of user PostScript
.70408 .09184 m
.74169 .13873 L
s
% Start of user PostScript
2.24399 0.224399 2.36805 0.379096 MAarrowhead1
% End of user PostScript
.70408 .15986 m
.74169 .2032 L
s
% Start of user PostScript
2.24399 0.448799 2.36805 0.59176 MAarrowhead1
% End of user PostScript
.70408 .22789 m
.74169 .2655 L
s
% Start of user PostScript
2.24399 0.673198 2.36805 0.797255 MAarrowhead1
% End of user PostScript
.70408 .29592 m
.74169 .32591 L
s
% Start of user PostScript
2.24399 0.897598 2.36805 0.99653 MAarrowhead1
% End of user PostScript
.70408 .36395 m
.74169 .38482 L
s
% Start of user PostScript
2.24399 1.122 2.36805 1.19084 MAarrowhead1
% End of user PostScript
.70408 .43197 m
.74169 .44268 L
s
% Start of user PostScript
2.24399 1.3464 2.36805 1.38171 MAarrowhead1
% End of user PostScript
.70408 .5 m
.74169 .5 L
s
% Start of user PostScript
2.24399 1.5708 2.36805 1.5708 MAarrowhead1
% End of user PostScript
.70408 .56803 m
.74169 .55732 L
s
% Start of user PostScript
2.24399 1.7952 2.36805 1.75989 MAarrowhead1
% End of user PostScript
.70408 .63605 m
.74169 .61518 L
s
% Start of user PostScript
2.24399 2.0196 2.36805 1.95075 MAarrowhead1
% End of user PostScript
.70408 .70408 m
.74169 .67409 L
s
% Start of user PostScript
2.24399 2.24399 2.36805 2.14506 MAarrowhead1
% End of user PostScript
.70408 .77211 m
.74169 .7345 L
s
% Start of user PostScript
2.24399 2.46839 2.36805 2.34434 MAarrowhead1
% End of user PostScript
.70408 .84014 m
.74169 .7968 L
s
% Start of user PostScript
2.24399 2.69279 2.36805 2.54983 MAarrowhead1
% End of user PostScript
.70408 .90816 m
.74169 .86127 L
s
% Start of user PostScript
2.24399 2.91719 2.36805 2.7625 MAarrowhead1
% End of user PostScript
.70408 .97619 m
.74169 .92809 L
s
% Start of user PostScript
2.24399 3.14159 2.36805 2.98292 MAarrowhead1
% End of user PostScript
.77211 .02381 m
.8021 .07191 L
s
% Start of user PostScript
2.46839 0 2.56733 0.158674 MAarrowhead1
% End of user PostScript
.77211 .09184 m
.8021 .13873 L
s
% Start of user PostScript
2.46839 0.224399 2.56733 0.379096 MAarrowhead1
% End of user PostScript
.77211 .15986 m
.8021 .2032 L
s
% Start of user PostScript
2.46839 0.448799 2.56733 0.59176 MAarrowhead1
% End of user PostScript
.77211 .22789 m
.8021 .2655 L
s
% Start of user PostScript
2.46839 0.673198 2.56733 0.797255 MAarrowhead1
% End of user PostScript
.77211 .29592 m
.8021 .32591 L
s
% Start of user PostScript
2.46839 0.897598 2.56733 0.99653 MAarrowhead1
% End of user PostScript
.77211 .36395 m
.8021 .38482 L
s
% Start of user PostScript
2.46839 1.122 2.56733 1.19084 MAarrowhead1
% End of user PostScript
.77211 .43197 m
.8021 .44268 L
s
% Start of user PostScript
2.46839 1.3464 2.56733 1.38171 MAarrowhead1
% End of user PostScript
.77211 .5 m
.8021 .5 L
s
% Start of user PostScript
2.46839 1.5708 2.56733 1.5708 MAarrowhead1
% End of user PostScript
.77211 .56803 m
.8021 .55732 L
s
% Start of user PostScript
2.46839 1.7952 2.56733 1.75989 MAarrowhead1
% End of user PostScript
.77211 .63605 m
.8021 .61518 L
s
% Start of user PostScript
2.46839 2.0196 2.56733 1.95075 MAarrowhead1
% End of user PostScript
.77211 .70408 m
.8021 .67409 L
s
% Start of user PostScript
2.46839 2.24399 2.56733 2.14506 MAarrowhead1
% End of user PostScript
.77211 .77211 m
.8021 .7345 L
s
% Start of user PostScript
2.46839 2.46839 2.56733 2.34434 MAarrowhead1
% End of user PostScript
.77211 .84014 m
.8021 .7968 L
s
% Start of user PostScript
2.46839 2.69279 2.56733 2.54983 MAarrowhead1
% End of user PostScript
.77211 .90816 m
.8021 .86127 L
s
% Start of user PostScript
2.46839 2.91719 2.56733 2.7625 MAarrowhead1
% End of user PostScript
.77211 .97619 m
.8021 .92809 L
s
% Start of user PostScript
2.46839 3.14159 2.56733 2.98292 MAarrowhead1
% End of user PostScript
.84014 .02381 m
.86101 .07191 L
s
% Start of user PostScript
2.69279 0 2.76164 0.158674 MAarrowhead1
% End of user PostScript
.84014 .09184 m
.86101 .13873 L
s
% Start of user PostScript
2.69279 0.224399 2.76164 0.379096 MAarrowhead1
% End of user PostScript
.84014 .15986 m
.86101 .2032 L
s
% Start of user PostScript
2.69279 0.448799 2.76164 0.59176 MAarrowhead1
% End of user PostScript
.84014 .22789 m
.86101 .2655 L
s
% Start of user PostScript
2.69279 0.673198 2.76164 0.797255 MAarrowhead1
% End of user PostScript
.84014 .29592 m
.86101 .32591 L
s
% Start of user PostScript
2.69279 0.897598 2.76164 0.99653 MAarrowhead1
% End of user PostScript
.84014 .36395 m
.86101 .38482 L
s
% Start of user PostScript
2.69279 1.122 2.76164 1.19084 MAarrowhead1
% End of user PostScript
.84014 .43197 m
.86101 .44268 L
s
% Start of user PostScript
2.69279 1.3464 2.76164 1.38171 MAarrowhead1
% End of user PostScript
.84014 .5 m
.86101 .5 L
s
% Start of user PostScript
2.69279 1.5708 2.76164 1.5708 MAarrowhead1
% End of user PostScript
.84014 .56803 m
.86101 .55732 L
s
% Start of user PostScript
2.69279 1.7952 2.76164 1.75989 MAarrowhead1
% End of user PostScript
.84014 .63605 m
.86101 .61518 L
s
% Start of user PostScript
2.69279 2.0196 2.76164 1.95075 MAarrowhead1
% End of user PostScript
.84014 .70408 m
.86101 .67409 L
s
% Start of user PostScript
2.69279 2.24399 2.76164 2.14506 MAarrowhead1
% End of user PostScript
.84014 .77211 m
.86101 .7345 L
s
% Start of user PostScript
2.69279 2.46839 2.76164 2.34434 MAarrowhead1
% End of user PostScript
.84014 .84014 m
.86101 .7968 L
s
% Start of user PostScript
2.69279 2.69279 2.76164 2.54983 MAarrowhead1
% End of user PostScript
.84014 .90816 m
.86101 .86127 L
s
% Start of user PostScript
2.69279 2.91719 2.76164 2.7625 MAarrowhead1
% End of user PostScript
.84014 .97619 m
.86101 .92809 L
s
% Start of user PostScript
2.69279 3.14159 2.76164 2.98292 MAarrowhead1
% End of user PostScript
.90816 .02381 m
.91887 .07191 L
s
% Start of user PostScript
2.91719 0 2.9525 0.158674 MAarrowhead1
% End of user PostScript
.90816 .09184 m
.91887 .13873 L
s
% Start of user PostScript
2.91719 0.224399 2.9525 0.379096 MAarrowhead1
% End of user PostScript
.90816 .15986 m
.91887 .2032 L
s
% Start of user PostScript
2.91719 0.448799 2.9525 0.59176 MAarrowhead1
% End of user PostScript
.90816 .22789 m
.91887 .2655 L
s
% Start of user PostScript
2.91719 0.673198 2.9525 0.797255 MAarrowhead1
% End of user PostScript
.90816 .29592 m
.91887 .32591 L
s
% Start of user PostScript
2.91719 0.897598 2.9525 0.99653 MAarrowhead1
% End of user PostScript
.90816 .36395 m
.91887 .38482 L
s
% Start of user PostScript
2.91719 1.122 2.9525 1.19084 MAarrowhead1
% End of user PostScript
.90816 .43197 m
.91887 .44268 L
s
% Start of user PostScript
2.91719 1.3464 2.9525 1.38171 MAarrowhead1
% End of user PostScript
.90816 .5 m
.91887 .5 L
s
% Start of user PostScript
2.91719 1.5708 2.9525 1.5708 MAarrowhead1
% End of user PostScript
.90816 .56803 m
.91887 .55732 L
s
% Start of user PostScript
2.91719 1.7952 2.9525 1.75989 MAarrowhead1
% End of user PostScript
.90816 .63605 m
.91887 .61518 L
s
% Start of user PostScript
2.91719 2.0196 2.9525 1.95075 MAarrowhead1
% End of user PostScript
.90816 .70408 m
.91887 .67409 L
s
% Start of user PostScript
2.91719 2.24399 2.9525 2.14506 MAarrowhead1
% End of user PostScript
.90816 .77211 m
.91887 .7345 L
s
% Start of user PostScript
2.91719 2.46839 2.9525 2.34434 MAarrowhead1
% End of user PostScript
.90816 .84014 m
.91887 .7968 L
s
% Start of user PostScript
2.91719 2.69279 2.9525 2.54983 MAarrowhead1
% End of user PostScript
.90816 .90816 m
.91887 .86127 L
s
% Start of user PostScript
2.91719 2.91719 2.9525 2.7625 MAarrowhead1
% End of user PostScript
.90816 .97619 m
.91887 .92809 L
s
% Start of user PostScript
2.91719 3.14159 2.9525 2.98292 MAarrowhead1
% End of user PostScript
.97619 .02381 m
.97619 .07191 L
s
% Start of user PostScript
3.14159 0 3.14159 0.158674 MAarrowhead1
% End of user PostScript
.97619 .09184 m
.97619 .13873 L
s
% Start of user PostScript
3.14159 0.224399 3.14159 0.379096 MAarrowhead1
% End of user PostScript
.97619 .15986 m
.97619 .2032 L
s
% Start of user PostScript
3.14159 0.448799 3.14159 0.59176 MAarrowhead1
% End of user PostScript
.97619 .22789 m
.97619 .2655 L
s
% Start of user PostScript
3.14159 0.673198 3.14159 0.797255 MAarrowhead1
% End of user PostScript
.97619 .29592 m
.97619 .32591 L
s
% Start of user PostScript
3.14159 0.897598 3.14159 0.99653 MAarrowhead1
% End of user PostScript
.97619 .36395 m
.97619 .38482 L
s
% Start of user PostScript
3.14159 1.122 3.14159 1.19084 MAarrowhead1
% End of user PostScript
.97619 .43197 m
.97619 .44268 L
s
% Start of user PostScript
3.14159 1.3464 3.14159 1.38171 MAarrowhead1
% End of user PostScript
.97619 .5 m
.97619 .5 L
s
% Start of user PostScript
3.14159 1.5708 MAarrowzero1
% End of user PostScript
.97619 .56803 m
.97619 .55732 L
s
% Start of user PostScript
3.14159 1.7952 3.14159 1.75989 MAarrowhead1
% End of user PostScript
.97619 .63605 m
.97619 .61518 L
s
% Start of user PostScript
3.14159 2.0196 3.14159 1.95075 MAarrowhead1
% End of user PostScript
.97619 .70408 m
.97619 .67409 L
s
% Start of user PostScript
3.14159 2.24399 3.14159 2.14506 MAarrowhead1
% End of user PostScript
.97619 .77211 m
.97619 .7345 L
s
% Start of user PostScript
3.14159 2.46839 3.14159 2.34434 MAarrowhead1
% End of user PostScript
.97619 .84014 m
.97619 .7968 L
s
% Start of user PostScript
3.14159 2.69279 3.14159 2.54983 MAarrowhead1
% End of user PostScript
.97619 .90816 m
.97619 .86127 L
s
% Start of user PostScript
3.14159 2.91719 3.14159 2.7625 MAarrowhead1
% End of user PostScript
.97619 .97619 m
.97619 .92809 L
s
% Start of user PostScript
3.14159 3.14159 3.14159 2.98292 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.39.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.39.1"]
}, Open  ]],

Cell[TextData[{
 "Given a scalar\[Hyphen]valued function ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " on the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " plane, there are two common ways of constructing a vector field. The \
function\[CloseCurlyQuote]s gradient vector field has first and second \
components given by ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"\[PartialD]", 
     StyleBox["f",
      "TI"]}], 
    RowBox[{"\[PartialD]", 
     StyleBox["x",
      "TI"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"\[PartialD]", 
     StyleBox["f",
      "TI"]}], 
    RowBox[{"\[PartialD]", 
     StyleBox["y",
      "TI"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", respectively. The two components of the function\[CloseCurlyQuote]s \
Hamiltonian vector field are ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"\[PartialD]", 
     StyleBox["f",
      "TI"]}], 
    RowBox[{"\[PartialD]", 
     StyleBox["y",
      "TI"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[PartialD]", 
      StyleBox["f",
       "TI"]}], 
     RowBox[{"\[PartialD]", 
      StyleBox["x",
       "TI"]}]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The gradient field gives the direction in which the function is \
increasing most rapidly. If one treats the function as the Hamiltonian of a \
mechanical system, the Hamiltonian vector field gives the equations of motion \
in phase space. "
}], "Text",
 CellTags->{"S5.39.1", "1.6"}],

Cell[TextData[{
 StyleBox["PlotGradientField", "MR"],
 " and ",
 StyleBox["PlotHamiltonianField", "MR"],
 " compute formulas for the partial derivatives of the scalar\[Hyphen]valued \
function given as an argument. This means that the functions you give must be \
such that ",
 StyleBox["Mathematica", "TI"],
 " can compute their derivatives. "
}], "Text",
 CellTags->{"S5.39.1", "1.7"}],

Cell[TextData[{
 "Here is the gradient field of the potential ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    SuperscriptBox[
     StyleBox["y",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.39.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
PlotGradientField[x^2 +  y^2,
             {x, -3, 3}, {y, -3, 3}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.39.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.144167 0.5 0.144167 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
0 0 Mdot
grestore
} def
% End of user PostScript
0 g
.0001 w
[ ] 0 setdash
.0675 .0675 m
.02381 .02381 L
s
% Start of user PostScript
-3. -3. -3.30305 -3.30305 MAarrowhead1
% End of user PostScript
.0675 .12928 m
.02381 .09184 L
s
% Start of user PostScript
-3. -2.57143 -3.30305 -2.83118 MAarrowhead1
% End of user PostScript
.0675 .19107 m
.02381 .15986 L
s
% Start of user PostScript
-3. -2.14286 -3.30305 -2.35932 MAarrowhead1
% End of user PostScript
.0675 .25286 m
.02381 .22789 L
s
% Start of user PostScript
-3. -1.71429 -3.30305 -1.88745 MAarrowhead1
% End of user PostScript
.0675 .31464 m
.02381 .29592 L
s
% Start of user PostScript
-3. -1.28571 -3.30305 -1.41559 MAarrowhead1
% End of user PostScript
.0675 .37643 m
.02381 .36395 L
s
% Start of user PostScript
-3. -0.857143 -3.30305 -0.943727 MAarrowhead1
% End of user PostScript
.0675 .43821 m
.02381 .43197 L
s
% Start of user PostScript
-3. -0.428571 -3.30305 -0.471864 MAarrowhead1
% End of user PostScript
.0675 .5 m
.02381 .5 L
s
% Start of user PostScript
-3. 0 -3.30305 0 MAarrowhead1
% End of user PostScript
.0675 .56179 m
.02381 .56803 L
s
% Start of user PostScript
-3. 0.428571 -3.30305 0.471864 MAarrowhead1
% End of user PostScript
.0675 .62357 m
.02381 .63605 L
s
% Start of user PostScript
-3. 0.857143 -3.30305 0.943727 MAarrowhead1
% End of user PostScript
.0675 .68536 m
.02381 .70408 L
s
% Start of user PostScript
-3. 1.28571 -3.30305 1.41559 MAarrowhead1
% End of user PostScript
.0675 .74714 m
.02381 .77211 L
s
% Start of user PostScript
-3. 1.71429 -3.30305 1.88745 MAarrowhead1
% End of user PostScript
.0675 .80893 m
.02381 .84014 L
s
% Start of user PostScript
-3. 2.14286 -3.30305 2.35932 MAarrowhead1
% End of user PostScript
.0675 .87072 m
.02381 .90816 L
s
% Start of user PostScript
-3. 2.57143 -3.30305 2.83118 MAarrowhead1
% End of user PostScript
.0675 .9325 m
.02381 .97619 L
s
% Start of user PostScript
-3. 3. -3.30305 3.30305 MAarrowhead1
% End of user PostScript
.12928 .0675 m
.09184 .02381 L
s
% Start of user PostScript
-2.57143 -3. -2.83118 -3.30305 MAarrowhead1
% End of user PostScript
.12928 .12928 m
.09184 .09184 L
s
% Start of user PostScript
-2.57143 -2.57143 -2.83118 -2.83118 MAarrowhead1
% End of user PostScript
.12928 .19107 m
.09184 .15986 L
s
% Start of user PostScript
-2.57143 -2.14286 -2.83118 -2.35932 MAarrowhead1
% End of user PostScript
.12928 .25286 m
.09184 .22789 L
s
% Start of user PostScript
-2.57143 -1.71429 -2.83118 -1.88745 MAarrowhead1
% End of user PostScript
.12928 .31464 m
.09184 .29592 L
s
% Start of user PostScript
-2.57143 -1.28571 -2.83118 -1.41559 MAarrowhead1
% End of user PostScript
.12928 .37643 m
.09184 .36395 L
s
% Start of user PostScript
-2.57143 -0.857143 -2.83118 -0.943727 MAarrowhead1
% End of user PostScript
.12928 .43821 m
.09184 .43197 L
s
% Start of user PostScript
-2.57143 -0.428571 -2.83118 -0.471864 MAarrowhead1
% End of user PostScript
.12928 .5 m
.09184 .5 L
s
% Start of user PostScript
-2.57143 0 -2.83118 0 MAarrowhead1
% End of user PostScript
.12928 .56179 m
.09184 .56803 L
s
% Start of user PostScript
-2.57143 0.428571 -2.83118 0.471864 MAarrowhead1
% End of user PostScript
.12928 .62357 m
.09184 .63605 L
s
% Start of user PostScript
-2.57143 0.857143 -2.83118 0.943727 MAarrowhead1
% End of user PostScript
.12928 .68536 m
.09184 .70408 L
s
% Start of user PostScript
-2.57143 1.28571 -2.83118 1.41559 MAarrowhead1
% End of user PostScript
.12928 .74714 m
.09184 .77211 L
s
% Start of user PostScript
-2.57143 1.71429 -2.83118 1.88745 MAarrowhead1
% End of user PostScript
.12928 .80893 m
.09184 .84014 L
s
% Start of user PostScript
-2.57143 2.14286 -2.83118 2.35932 MAarrowhead1
% End of user PostScript
.12928 .87072 m
.09184 .90816 L
s
% Start of user PostScript
-2.57143 2.57143 -2.83118 2.83118 MAarrowhead1
% End of user PostScript
.12928 .9325 m
.09184 .97619 L
s
% Start of user PostScript
-2.57143 3. -2.83118 3.30305 MAarrowhead1
% End of user PostScript
.19107 .0675 m
.15986 .02381 L
s
% Start of user PostScript
-2.14286 -3. -2.35932 -3.30305 MAarrowhead1
% End of user PostScript
.19107 .12928 m
.15986 .09184 L
s
% Start of user PostScript
-2.14286 -2.57143 -2.35932 -2.83118 MAarrowhead1
% End of user PostScript
.19107 .19107 m
.15986 .15986 L
s
% Start of user PostScript
-2.14286 -2.14286 -2.35932 -2.35932 MAarrowhead1
% End of user PostScript
.19107 .25286 m
.15986 .22789 L
s
% Start of user PostScript
-2.14286 -1.71429 -2.35932 -1.88745 MAarrowhead1
% End of user PostScript
.19107 .31464 m
.15986 .29592 L
s
% Start of user PostScript
-2.14286 -1.28571 -2.35932 -1.41559 MAarrowhead1
% End of user PostScript
.19107 .37643 m
.15986 .36395 L
s
% Start of user PostScript
-2.14286 -0.857143 -2.35932 -0.943727 MAarrowhead1
% End of user PostScript
.19107 .43821 m
.15986 .43197 L
s
% Start of user PostScript
-2.14286 -0.428571 -2.35932 -0.471864 MAarrowhead1
% End of user PostScript
.19107 .5 m
.15986 .5 L
s
% Start of user PostScript
-2.14286 0 -2.35932 0 MAarrowhead1
% End of user PostScript
.19107 .56179 m
.15986 .56803 L
s
% Start of user PostScript
-2.14286 0.428571 -2.35932 0.471864 MAarrowhead1
% End of user PostScript
.19107 .62357 m
.15986 .63605 L
s
% Start of user PostScript
-2.14286 0.857143 -2.35932 0.943727 MAarrowhead1
% End of user PostScript
.19107 .68536 m
.15986 .70408 L
s
% Start of user PostScript
-2.14286 1.28571 -2.35932 1.41559 MAarrowhead1
% End of user PostScript
.19107 .74714 m
.15986 .77211 L
s
% Start of user PostScript
-2.14286 1.71429 -2.35932 1.88745 MAarrowhead1
% End of user PostScript
.19107 .80893 m
.15986 .84014 L
s
% Start of user PostScript
-2.14286 2.14286 -2.35932 2.35932 MAarrowhead1
% End of user PostScript
.19107 .87072 m
.15986 .90816 L
s
% Start of user PostScript
-2.14286 2.57143 -2.35932 2.83118 MAarrowhead1
% End of user PostScript
.19107 .9325 m
.15986 .97619 L
s
% Start of user PostScript
-2.14286 3. -2.35932 3.30305 MAarrowhead1
% End of user PostScript
.25286 .0675 m
.22789 .02381 L
s
% Start of user PostScript
-1.71429 -3. -1.88745 -3.30305 MAarrowhead1
% End of user PostScript
.25286 .12928 m
.22789 .09184 L
s
% Start of user PostScript
-1.71429 -2.57143 -1.88745 -2.83118 MAarrowhead1
% End of user PostScript
.25286 .19107 m
.22789 .15986 L
s
% Start of user PostScript
-1.71429 -2.14286 -1.88745 -2.35932 MAarrowhead1
% End of user PostScript
.25286 .25286 m
.22789 .22789 L
s
% Start of user PostScript
-1.71429 -1.71429 -1.88745 -1.88745 MAarrowhead1
% End of user PostScript
.25286 .31464 m
.22789 .29592 L
s
% Start of user PostScript
-1.71429 -1.28571 -1.88745 -1.41559 MAarrowhead1
% End of user PostScript
.25286 .37643 m
.22789 .36395 L
s
% Start of user PostScript
-1.71429 -0.857143 -1.88745 -0.943727 MAarrowhead1
% End of user PostScript
.25286 .43821 m
.22789 .43197 L
s
% Start of user PostScript
-1.71429 -0.428571 -1.88745 -0.471864 MAarrowhead1
% End of user PostScript
.25286 .5 m
.22789 .5 L
s
% Start of user PostScript
-1.71429 0 -1.88745 0 MAarrowhead1
% End of user PostScript
.25286 .56179 m
.22789 .56803 L
s
% Start of user PostScript
-1.71429 0.428571 -1.88745 0.471864 MAarrowhead1
% End of user PostScript
.25286 .62357 m
.22789 .63605 L
s
% Start of user PostScript
-1.71429 0.857143 -1.88745 0.943727 MAarrowhead1
% End of user PostScript
.25286 .68536 m
.22789 .70408 L
s
% Start of user PostScript
-1.71429 1.28571 -1.88745 1.41559 MAarrowhead1
% End of user PostScript
.25286 .74714 m
.22789 .77211 L
s
% Start of user PostScript
-1.71429 1.71429 -1.88745 1.88745 MAarrowhead1
% End of user PostScript
.25286 .80893 m
.22789 .84014 L
s
% Start of user PostScript
-1.71429 2.14286 -1.88745 2.35932 MAarrowhead1
% End of user PostScript
.25286 .87072 m
.22789 .90816 L
s
% Start of user PostScript
-1.71429 2.57143 -1.88745 2.83118 MAarrowhead1
% End of user PostScript
.25286 .9325 m
.22789 .97619 L
s
% Start of user PostScript
-1.71429 3. -1.88745 3.30305 MAarrowhead1
% End of user PostScript
.31464 .0675 m
.29592 .02381 L
s
% Start of user PostScript
-1.28571 -3. -1.41559 -3.30305 MAarrowhead1
% End of user PostScript
.31464 .12928 m
.29592 .09184 L
s
% Start of user PostScript
-1.28571 -2.57143 -1.41559 -2.83118 MAarrowhead1
% End of user PostScript
.31464 .19107 m
.29592 .15986 L
s
% Start of user PostScript
-1.28571 -2.14286 -1.41559 -2.35932 MAarrowhead1
% End of user PostScript
.31464 .25286 m
.29592 .22789 L
s
% Start of user PostScript
-1.28571 -1.71429 -1.41559 -1.88745 MAarrowhead1
% End of user PostScript
.31464 .31464 m
.29592 .29592 L
s
% Start of user PostScript
-1.28571 -1.28571 -1.41559 -1.41559 MAarrowhead1
% End of user PostScript
.31464 .37643 m
.29592 .36395 L
s
% Start of user PostScript
-1.28571 -0.857143 -1.41559 -0.943727 MAarrowhead1
% End of user PostScript
.31464 .43821 m
.29592 .43197 L
s
% Start of user PostScript
-1.28571 -0.428571 -1.41559 -0.471864 MAarrowhead1
% End of user PostScript
.31464 .5 m
.29592 .5 L
s
% Start of user PostScript
-1.28571 0 -1.41559 0 MAarrowhead1
% End of user PostScript
.31464 .56179 m
.29592 .56803 L
s
% Start of user PostScript
-1.28571 0.428571 -1.41559 0.471864 MAarrowhead1
% End of user PostScript
.31464 .62357 m
.29592 .63605 L
s
% Start of user PostScript
-1.28571 0.857143 -1.41559 0.943727 MAarrowhead1
% End of user PostScript
.31464 .68536 m
.29592 .70408 L
s
% Start of user PostScript
-1.28571 1.28571 -1.41559 1.41559 MAarrowhead1
% End of user PostScript
.31464 .74714 m
.29592 .77211 L
s
% Start of user PostScript
-1.28571 1.71429 -1.41559 1.88745 MAarrowhead1
% End of user PostScript
.31464 .80893 m
.29592 .84014 L
s
% Start of user PostScript
-1.28571 2.14286 -1.41559 2.35932 MAarrowhead1
% End of user PostScript
.31464 .87072 m
.29592 .90816 L
s
% Start of user PostScript
-1.28571 2.57143 -1.41559 2.83118 MAarrowhead1
% End of user PostScript
.31464 .9325 m
.29592 .97619 L
s
% Start of user PostScript
-1.28571 3. -1.41559 3.30305 MAarrowhead1
% End of user PostScript
.37643 .0675 m
.36395 .02381 L
s
% Start of user PostScript
-0.857143 -3. -0.943727 -3.30305 MAarrowhead1
% End of user PostScript
.37643 .12928 m
.36395 .09184 L
s
% Start of user PostScript
-0.857143 -2.57143 -0.943727 -2.83118 MAarrowhead1
% End of user PostScript
.37643 .19107 m
.36395 .15986 L
s
% Start of user PostScript
-0.857143 -2.14286 -0.943727 -2.35932 MAarrowhead1
% End of user PostScript
.37643 .25286 m
.36395 .22789 L
s
% Start of user PostScript
-0.857143 -1.71429 -0.943727 -1.88745 MAarrowhead1
% End of user PostScript
.37643 .31464 m
.36395 .29592 L
s
% Start of user PostScript
-0.857143 -1.28571 -0.943727 -1.41559 MAarrowhead1
% End of user PostScript
.37643 .37643 m
.36395 .36395 L
s
% Start of user PostScript
-0.857143 -0.857143 -0.943727 -0.943727 MAarrowhead1
% End of user PostScript
.37643 .43821 m
.36395 .43197 L
s
% Start of user PostScript
-0.857143 -0.428571 -0.943727 -0.471864 MAarrowhead1
% End of user PostScript
.37643 .5 m
.36395 .5 L
s
% Start of user PostScript
-0.857143 0 -0.943727 0 MAarrowhead1
% End of user PostScript
.37643 .56179 m
.36395 .56803 L
s
% Start of user PostScript
-0.857143 0.428571 -0.943727 0.471864 MAarrowhead1
% End of user PostScript
.37643 .62357 m
.36395 .63605 L
s
% Start of user PostScript
-0.857143 0.857143 -0.943727 0.943727 MAarrowhead1
% End of user PostScript
.37643 .68536 m
.36395 .70408 L
s
% Start of user PostScript
-0.857143 1.28571 -0.943727 1.41559 MAarrowhead1
% End of user PostScript
.37643 .74714 m
.36395 .77211 L
s
% Start of user PostScript
-0.857143 1.71429 -0.943727 1.88745 MAarrowhead1
% End of user PostScript
.37643 .80893 m
.36395 .84014 L
s
% Start of user PostScript
-0.857143 2.14286 -0.943727 2.35932 MAarrowhead1
% End of user PostScript
.37643 .87072 m
.36395 .90816 L
s
% Start of user PostScript
-0.857143 2.57143 -0.943727 2.83118 MAarrowhead1
% End of user PostScript
.37643 .9325 m
.36395 .97619 L
s
% Start of user PostScript
-0.857143 3. -0.943727 3.30305 MAarrowhead1
% End of user PostScript
.43821 .0675 m
.43197 .02381 L
s
% Start of user PostScript
-0.428571 -3. -0.471864 -3.30305 MAarrowhead1
% End of user PostScript
.43821 .12928 m
.43197 .09184 L
s
% Start of user PostScript
-0.428571 -2.57143 -0.471864 -2.83118 MAarrowhead1
% End of user PostScript
.43821 .19107 m
.43197 .15986 L
s
% Start of user PostScript
-0.428571 -2.14286 -0.471864 -2.35932 MAarrowhead1
% End of user PostScript
.43821 .25286 m
.43197 .22789 L
s
% Start of user PostScript
-0.428571 -1.71429 -0.471864 -1.88745 MAarrowhead1
% End of user PostScript
.43821 .31464 m
.43197 .29592 L
s
% Start of user PostScript
-0.428571 -1.28571 -0.471864 -1.41559 MAarrowhead1
% End of user PostScript
.43821 .37643 m
.43197 .36395 L
s
% Start of user PostScript
-0.428571 -0.857143 -0.471864 -0.943727 MAarrowhead1
% End of user PostScript
.43821 .43821 m
.43197 .43197 L
s
% Start of user PostScript
-0.428571 -0.428571 -0.471864 -0.471864 MAarrowhead1
% End of user PostScript
.43821 .5 m
.43197 .5 L
s
% Start of user PostScript
-0.428571 0 -0.471864 0 MAarrowhead1
% End of user PostScript
.43821 .56179 m
.43197 .56803 L
s
% Start of user PostScript
-0.428571 0.428571 -0.471864 0.471864 MAarrowhead1
% End of user PostScript
.43821 .62357 m
.43197 .63605 L
s
% Start of user PostScript
-0.428571 0.857143 -0.471864 0.943727 MAarrowhead1
% End of user PostScript
.43821 .68536 m
.43197 .70408 L
s
% Start of user PostScript
-0.428571 1.28571 -0.471864 1.41559 MAarrowhead1
% End of user PostScript
.43821 .74714 m
.43197 .77211 L
s
% Start of user PostScript
-0.428571 1.71429 -0.471864 1.88745 MAarrowhead1
% End of user PostScript
.43821 .80893 m
.43197 .84014 L
s
% Start of user PostScript
-0.428571 2.14286 -0.471864 2.35932 MAarrowhead1
% End of user PostScript
.43821 .87072 m
.43197 .90816 L
s
% Start of user PostScript
-0.428571 2.57143 -0.471864 2.83118 MAarrowhead1
% End of user PostScript
.43821 .9325 m
.43197 .97619 L
s
% Start of user PostScript
-0.428571 3. -0.471864 3.30305 MAarrowhead1
% End of user PostScript
.5 .0675 m
.5 .02381 L
s
% Start of user PostScript
0 -3. 0 -3.30305 MAarrowhead1
% End of user PostScript
.5 .12928 m
.5 .09184 L
s
% Start of user PostScript
0 -2.57143 0 -2.83118 MAarrowhead1
% End of user PostScript
.5 .19107 m
.5 .15986 L
s
% Start of user PostScript
0 -2.14286 0 -2.35932 MAarrowhead1
% End of user PostScript
.5 .25286 m
.5 .22789 L
s
% Start of user PostScript
0 -1.71429 0 -1.88745 MAarrowhead1
% End of user PostScript
.5 .31464 m
.5 .29592 L
s
% Start of user PostScript
0 -1.28571 0 -1.41559 MAarrowhead1
% End of user PostScript
.5 .37643 m
.5 .36395 L
s
% Start of user PostScript
0 -0.857143 0 -0.943727 MAarrowhead1
% End of user PostScript
.5 .43821 m
.5 .43197 L
s
% Start of user PostScript
0 -0.428571 0 -0.471864 MAarrowhead1
% End of user PostScript
.5 .5 m
.5 .5 L
s
% Start of user PostScript
0 0 MAarrowzero1
% End of user PostScript
.5 .56179 m
.5 .56803 L
s
% Start of user PostScript
0 0.428571 0 0.471864 MAarrowhead1
% End of user PostScript
.5 .62357 m
.5 .63605 L
s
% Start of user PostScript
0 0.857143 0 0.943727 MAarrowhead1
% End of user PostScript
.5 .68536 m
.5 .70408 L
s
% Start of user PostScript
0 1.28571 0 1.41559 MAarrowhead1
% End of user PostScript
.5 .74714 m
.5 .77211 L
s
% Start of user PostScript
0 1.71429 0 1.88745 MAarrowhead1
% End of user PostScript
.5 .80893 m
.5 .84014 L
s
% Start of user PostScript
0 2.14286 0 2.35932 MAarrowhead1
% End of user PostScript
.5 .87072 m
.5 .90816 L
s
% Start of user PostScript
0 2.57143 0 2.83118 MAarrowhead1
% End of user PostScript
.5 .9325 m
.5 .97619 L
s
% Start of user PostScript
0 3. 0 3.30305 MAarrowhead1
% End of user PostScript
.56179 .0675 m
.56803 .02381 L
s
% Start of user PostScript
0.428571 -3. 0.471864 -3.30305 MAarrowhead1
% End of user PostScript
.56179 .12928 m
.56803 .09184 L
s
% Start of user PostScript
0.428571 -2.57143 0.471864 -2.83118 MAarrowhead1
% End of user PostScript
.56179 .19107 m
.56803 .15986 L
s
% Start of user PostScript
0.428571 -2.14286 0.471864 -2.35932 MAarrowhead1
% End of user PostScript
.56179 .25286 m
.56803 .22789 L
s
% Start of user PostScript
0.428571 -1.71429 0.471864 -1.88745 MAarrowhead1
% End of user PostScript
.56179 .31464 m
.56803 .29592 L
s
% Start of user PostScript
0.428571 -1.28571 0.471864 -1.41559 MAarrowhead1
% End of user PostScript
.56179 .37643 m
.56803 .36395 L
s
% Start of user PostScript
0.428571 -0.857143 0.471864 -0.943727 MAarrowhead1
% End of user PostScript
.56179 .43821 m
.56803 .43197 L
s
% Start of user PostScript
0.428571 -0.428571 0.471864 -0.471864 MAarrowhead1
% End of user PostScript
.56179 .5 m
.56803 .5 L
s
% Start of user PostScript
0.428571 0 0.471864 0 MAarrowhead1
% End of user PostScript
.56179 .56179 m
.56803 .56803 L
s
% Start of user PostScript
0.428571 0.428571 0.471864 0.471864 MAarrowhead1
% End of user PostScript
.56179 .62357 m
.56803 .63605 L
s
% Start of user PostScript
0.428571 0.857143 0.471864 0.943727 MAarrowhead1
% End of user PostScript
.56179 .68536 m
.56803 .70408 L
s
% Start of user PostScript
0.428571 1.28571 0.471864 1.41559 MAarrowhead1
% End of user PostScript
.56179 .74714 m
.56803 .77211 L
s
% Start of user PostScript
0.428571 1.71429 0.471864 1.88745 MAarrowhead1
% End of user PostScript
.56179 .80893 m
.56803 .84014 L
s
% Start of user PostScript
0.428571 2.14286 0.471864 2.35932 MAarrowhead1
% End of user PostScript
.56179 .87072 m
.56803 .90816 L
s
% Start of user PostScript
0.428571 2.57143 0.471864 2.83118 MAarrowhead1
% End of user PostScript
.56179 .9325 m
.56803 .97619 L
s
% Start of user PostScript
0.428571 3. 0.471864 3.30305 MAarrowhead1
% End of user PostScript
.62357 .0675 m
.63605 .02381 L
s
% Start of user PostScript
0.857143 -3. 0.943727 -3.30305 MAarrowhead1
% End of user PostScript
.62357 .12928 m
.63605 .09184 L
s
% Start of user PostScript
0.857143 -2.57143 0.943727 -2.83118 MAarrowhead1
% End of user PostScript
.62357 .19107 m
.63605 .15986 L
s
% Start of user PostScript
0.857143 -2.14286 0.943727 -2.35932 MAarrowhead1
% End of user PostScript
.62357 .25286 m
.63605 .22789 L
s
% Start of user PostScript
0.857143 -1.71429 0.943727 -1.88745 MAarrowhead1
% End of user PostScript
.62357 .31464 m
.63605 .29592 L
s
% Start of user PostScript
0.857143 -1.28571 0.943727 -1.41559 MAarrowhead1
% End of user PostScript
.62357 .37643 m
.63605 .36395 L
s
% Start of user PostScript
0.857143 -0.857143 0.943727 -0.943727 MAarrowhead1
% End of user PostScript
.62357 .43821 m
.63605 .43197 L
s
% Start of user PostScript
0.857143 -0.428571 0.943727 -0.471864 MAarrowhead1
% End of user PostScript
.62357 .5 m
.63605 .5 L
s
% Start of user PostScript
0.857143 0 0.943727 0 MAarrowhead1
% End of user PostScript
.62357 .56179 m
.63605 .56803 L
s
% Start of user PostScript
0.857143 0.428571 0.943727 0.471864 MAarrowhead1
% End of user PostScript
.62357 .62357 m
.63605 .63605 L
s
% Start of user PostScript
0.857143 0.857143 0.943727 0.943727 MAarrowhead1
% End of user PostScript
.62357 .68536 m
.63605 .70408 L
s
% Start of user PostScript
0.857143 1.28571 0.943727 1.41559 MAarrowhead1
% End of user PostScript
.62357 .74714 m
.63605 .77211 L
s
% Start of user PostScript
0.857143 1.71429 0.943727 1.88745 MAarrowhead1
% End of user PostScript
.62357 .80893 m
.63605 .84014 L
s
% Start of user PostScript
0.857143 2.14286 0.943727 2.35932 MAarrowhead1
% End of user PostScript
.62357 .87072 m
.63605 .90816 L
s
% Start of user PostScript
0.857143 2.57143 0.943727 2.83118 MAarrowhead1
% End of user PostScript
.62357 .9325 m
.63605 .97619 L
s
% Start of user PostScript
0.857143 3. 0.943727 3.30305 MAarrowhead1
% End of user PostScript
.68536 .0675 m
.70408 .02381 L
s
% Start of user PostScript
1.28571 -3. 1.41559 -3.30305 MAarrowhead1
% End of user PostScript
.68536 .12928 m
.70408 .09184 L
s
% Start of user PostScript
1.28571 -2.57143 1.41559 -2.83118 MAarrowhead1
% End of user PostScript
.68536 .19107 m
.70408 .15986 L
s
% Start of user PostScript
1.28571 -2.14286 1.41559 -2.35932 MAarrowhead1
% End of user PostScript
.68536 .25286 m
.70408 .22789 L
s
% Start of user PostScript
1.28571 -1.71429 1.41559 -1.88745 MAarrowhead1
% End of user PostScript
.68536 .31464 m
.70408 .29592 L
s
% Start of user PostScript
1.28571 -1.28571 1.41559 -1.41559 MAarrowhead1
% End of user PostScript
.68536 .37643 m
.70408 .36395 L
s
% Start of user PostScript
1.28571 -0.857143 1.41559 -0.943727 MAarrowhead1
% End of user PostScript
.68536 .43821 m
.70408 .43197 L
s
% Start of user PostScript
1.28571 -0.428571 1.41559 -0.471864 MAarrowhead1
% End of user PostScript
.68536 .5 m
.70408 .5 L
s
% Start of user PostScript
1.28571 0 1.41559 0 MAarrowhead1
% End of user PostScript
.68536 .56179 m
.70408 .56803 L
s
% Start of user PostScript
1.28571 0.428571 1.41559 0.471864 MAarrowhead1
% End of user PostScript
.68536 .62357 m
.70408 .63605 L
s
% Start of user PostScript
1.28571 0.857143 1.41559 0.943727 MAarrowhead1
% End of user PostScript
.68536 .68536 m
.70408 .70408 L
s
% Start of user PostScript
1.28571 1.28571 1.41559 1.41559 MAarrowhead1
% End of user PostScript
.68536 .74714 m
.70408 .77211 L
s
% Start of user PostScript
1.28571 1.71429 1.41559 1.88745 MAarrowhead1
% End of user PostScript
.68536 .80893 m
.70408 .84014 L
s
% Start of user PostScript
1.28571 2.14286 1.41559 2.35932 MAarrowhead1
% End of user PostScript
.68536 .87072 m
.70408 .90816 L
s
% Start of user PostScript
1.28571 2.57143 1.41559 2.83118 MAarrowhead1
% End of user PostScript
.68536 .9325 m
.70408 .97619 L
s
% Start of user PostScript
1.28571 3. 1.41559 3.30305 MAarrowhead1
% End of user PostScript
.74714 .0675 m
.77211 .02381 L
s
% Start of user PostScript
1.71429 -3. 1.88745 -3.30305 MAarrowhead1
% End of user PostScript
.74714 .12928 m
.77211 .09184 L
s
% Start of user PostScript
1.71429 -2.57143 1.88745 -2.83118 MAarrowhead1
% End of user PostScript
.74714 .19107 m
.77211 .15986 L
s
% Start of user PostScript
1.71429 -2.14286 1.88745 -2.35932 MAarrowhead1
% End of user PostScript
.74714 .25286 m
.77211 .22789 L
s
% Start of user PostScript
1.71429 -1.71429 1.88745 -1.88745 MAarrowhead1
% End of user PostScript
.74714 .31464 m
.77211 .29592 L
s
% Start of user PostScript
1.71429 -1.28571 1.88745 -1.41559 MAarrowhead1
% End of user PostScript
.74714 .37643 m
.77211 .36395 L
s
% Start of user PostScript
1.71429 -0.857143 1.88745 -0.943727 MAarrowhead1
% End of user PostScript
.74714 .43821 m
.77211 .43197 L
s
% Start of user PostScript
1.71429 -0.428571 1.88745 -0.471864 MAarrowhead1
% End of user PostScript
.74714 .5 m
.77211 .5 L
s
% Start of user PostScript
1.71429 0 1.88745 0 MAarrowhead1
% End of user PostScript
.74714 .56179 m
.77211 .56803 L
s
% Start of user PostScript
1.71429 0.428571 1.88745 0.471864 MAarrowhead1
% End of user PostScript
.74714 .62357 m
.77211 .63605 L
s
% Start of user PostScript
1.71429 0.857143 1.88745 0.943727 MAarrowhead1
% End of user PostScript
.74714 .68536 m
.77211 .70408 L
s
% Start of user PostScript
1.71429 1.28571 1.88745 1.41559 MAarrowhead1
% End of user PostScript
.74714 .74714 m
.77211 .77211 L
s
% Start of user PostScript
1.71429 1.71429 1.88745 1.88745 MAarrowhead1
% End of user PostScript
.74714 .80893 m
.77211 .84014 L
s
% Start of user PostScript
1.71429 2.14286 1.88745 2.35932 MAarrowhead1
% End of user PostScript
.74714 .87072 m
.77211 .90816 L
s
% Start of user PostScript
1.71429 2.57143 1.88745 2.83118 MAarrowhead1
% End of user PostScript
.74714 .9325 m
.77211 .97619 L
s
% Start of user PostScript
1.71429 3. 1.88745 3.30305 MAarrowhead1
% End of user PostScript
.80893 .0675 m
.84014 .02381 L
s
% Start of user PostScript
2.14286 -3. 2.35932 -3.30305 MAarrowhead1
% End of user PostScript
.80893 .12928 m
.84014 .09184 L
s
% Start of user PostScript
2.14286 -2.57143 2.35932 -2.83118 MAarrowhead1
% End of user PostScript
.80893 .19107 m
.84014 .15986 L
s
% Start of user PostScript
2.14286 -2.14286 2.35932 -2.35932 MAarrowhead1
% End of user PostScript
.80893 .25286 m
.84014 .22789 L
s
% Start of user PostScript
2.14286 -1.71429 2.35932 -1.88745 MAarrowhead1
% End of user PostScript
.80893 .31464 m
.84014 .29592 L
s
% Start of user PostScript
2.14286 -1.28571 2.35932 -1.41559 MAarrowhead1
% End of user PostScript
.80893 .37643 m
.84014 .36395 L
s
% Start of user PostScript
2.14286 -0.857143 2.35932 -0.943727 MAarrowhead1
% End of user PostScript
.80893 .43821 m
.84014 .43197 L
s
% Start of user PostScript
2.14286 -0.428571 2.35932 -0.471864 MAarrowhead1
% End of user PostScript
.80893 .5 m
.84014 .5 L
s
% Start of user PostScript
2.14286 0 2.35932 0 MAarrowhead1
% End of user PostScript
.80893 .56179 m
.84014 .56803 L
s
% Start of user PostScript
2.14286 0.428571 2.35932 0.471864 MAarrowhead1
% End of user PostScript
.80893 .62357 m
.84014 .63605 L
s
% Start of user PostScript
2.14286 0.857143 2.35932 0.943727 MAarrowhead1
% End of user PostScript
.80893 .68536 m
.84014 .70408 L
s
% Start of user PostScript
2.14286 1.28571 2.35932 1.41559 MAarrowhead1
% End of user PostScript
.80893 .74714 m
.84014 .77211 L
s
% Start of user PostScript
2.14286 1.71429 2.35932 1.88745 MAarrowhead1
% End of user PostScript
.80893 .80893 m
.84014 .84014 L
s
% Start of user PostScript
2.14286 2.14286 2.35932 2.35932 MAarrowhead1
% End of user PostScript
.80893 .87072 m
.84014 .90816 L
s
% Start of user PostScript
2.14286 2.57143 2.35932 2.83118 MAarrowhead1
% End of user PostScript
.80893 .9325 m
.84014 .97619 L
s
% Start of user PostScript
2.14286 3. 2.35932 3.30305 MAarrowhead1
% End of user PostScript
.87072 .0675 m
.90816 .02381 L
s
% Start of user PostScript
2.57143 -3. 2.83118 -3.30305 MAarrowhead1
% End of user PostScript
.87072 .12928 m
.90816 .09184 L
s
% Start of user PostScript
2.57143 -2.57143 2.83118 -2.83118 MAarrowhead1
% End of user PostScript
.87072 .19107 m
.90816 .15986 L
s
% Start of user PostScript
2.57143 -2.14286 2.83118 -2.35932 MAarrowhead1
% End of user PostScript
.87072 .25286 m
.90816 .22789 L
s
% Start of user PostScript
2.57143 -1.71429 2.83118 -1.88745 MAarrowhead1
% End of user PostScript
.87072 .31464 m
.90816 .29592 L
s
% Start of user PostScript
2.57143 -1.28571 2.83118 -1.41559 MAarrowhead1
% End of user PostScript
.87072 .37643 m
.90816 .36395 L
s
% Start of user PostScript
2.57143 -0.857143 2.83118 -0.943727 MAarrowhead1
% End of user PostScript
.87072 .43821 m
.90816 .43197 L
s
% Start of user PostScript
2.57143 -0.428571 2.83118 -0.471864 MAarrowhead1
% End of user PostScript
.87072 .5 m
.90816 .5 L
s
% Start of user PostScript
2.57143 0 2.83118 0 MAarrowhead1
% End of user PostScript
.87072 .56179 m
.90816 .56803 L
s
% Start of user PostScript
2.57143 0.428571 2.83118 0.471864 MAarrowhead1
% End of user PostScript
.87072 .62357 m
.90816 .63605 L
s
% Start of user PostScript
2.57143 0.857143 2.83118 0.943727 MAarrowhead1
% End of user PostScript
.87072 .68536 m
.90816 .70408 L
s
% Start of user PostScript
2.57143 1.28571 2.83118 1.41559 MAarrowhead1
% End of user PostScript
.87072 .74714 m
.90816 .77211 L
s
% Start of user PostScript
2.57143 1.71429 2.83118 1.88745 MAarrowhead1
% End of user PostScript
.87072 .80893 m
.90816 .84014 L
s
% Start of user PostScript
2.57143 2.14286 2.83118 2.35932 MAarrowhead1
% End of user PostScript
.87072 .87072 m
.90816 .90816 L
s
% Start of user PostScript
2.57143 2.57143 2.83118 2.83118 MAarrowhead1
% End of user PostScript
.87072 .9325 m
.90816 .97619 L
s
% Start of user PostScript
2.57143 3. 2.83118 3.30305 MAarrowhead1
% End of user PostScript
.9325 .0675 m
.97619 .02381 L
s
% Start of user PostScript
3. -3. 3.30305 -3.30305 MAarrowhead1
% End of user PostScript
.9325 .12928 m
.97619 .09184 L
s
% Start of user PostScript
3. -2.57143 3.30305 -2.83118 MAarrowhead1
% End of user PostScript
.9325 .19107 m
.97619 .15986 L
s
% Start of user PostScript
3. -2.14286 3.30305 -2.35932 MAarrowhead1
% End of user PostScript
.9325 .25286 m
.97619 .22789 L
s
% Start of user PostScript
3. -1.71429 3.30305 -1.88745 MAarrowhead1
% End of user PostScript
.9325 .31464 m
.97619 .29592 L
s
% Start of user PostScript
3. -1.28571 3.30305 -1.41559 MAarrowhead1
% End of user PostScript
.9325 .37643 m
.97619 .36395 L
s
% Start of user PostScript
3. -0.857143 3.30305 -0.943727 MAarrowhead1
% End of user PostScript
.9325 .43821 m
.97619 .43197 L
s
% Start of user PostScript
3. -0.428571 3.30305 -0.471864 MAarrowhead1
% End of user PostScript
.9325 .5 m
.97619 .5 L
s
% Start of user PostScript
3. 0 3.30305 0 MAarrowhead1
% End of user PostScript
.9325 .56179 m
.97619 .56803 L
s
% Start of user PostScript
3. 0.428571 3.30305 0.471864 MAarrowhead1
% End of user PostScript
.9325 .62357 m
.97619 .63605 L
s
% Start of user PostScript
3. 0.857143 3.30305 0.943727 MAarrowhead1
% End of user PostScript
.9325 .68536 m
.97619 .70408 L
s
% Start of user PostScript
3. 1.28571 3.30305 1.41559 MAarrowhead1
% End of user PostScript
.9325 .74714 m
.97619 .77211 L
s
% Start of user PostScript
3. 1.71429 3.30305 1.88745 MAarrowhead1
% End of user PostScript
.9325 .80893 m
.97619 .84014 L
s
% Start of user PostScript
3. 2.14286 3.30305 2.35932 MAarrowhead1
% End of user PostScript
.9325 .87072 m
.97619 .90816 L
s
% Start of user PostScript
3. 2.57143 3.30305 2.83118 MAarrowhead1
% End of user PostScript
.9325 .9325 m
.97619 .97619 L
s
% Start of user PostScript
3. 3. 3.30305 3.30305 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.39.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.39.1"]
}, Open  ]],

Cell["\<\
In the plane, the gradient and Hamiltonian vector fields of the same function \
are always orthogonal. \
\>", "MathCaption",
 CellTags->{"S5.39.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
PlotHamiltonianField[x^2 +  y^2,
             {x, -3, 3}, {y, -3, 3}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.39.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.144167 0.5 0.144167 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
0 0 Mdot
grestore
} def
% End of user PostScript
0 g
.0001 w
[ ] 0 setdash
.0675 .0675 m
.02381 .11119 L
s
% Start of user PostScript
-3. -3. -3.30305 -2.69695 MAarrowhead1
% End of user PostScript
.0675 .12928 m
.03005 .17297 L
s
% Start of user PostScript
-3. -2.57143 -3.25975 -2.26838 MAarrowhead1
% End of user PostScript
.0675 .19107 m
.03629 .23476 L
s
% Start of user PostScript
-3. -2.14286 -3.21646 -1.83981 MAarrowhead1
% End of user PostScript
.0675 .25286 m
.04253 .29655 L
s
% Start of user PostScript
-3. -1.71429 -3.17317 -1.41124 MAarrowhead1
% End of user PostScript
.0675 .31464 m
.04877 .35833 L
s
% Start of user PostScript
-3. -1.28571 -3.12988 -0.982669 MAarrowhead1
% End of user PostScript
.0675 .37643 m
.05502 .42012 L
s
% Start of user PostScript
-3. -0.857143 -3.08658 -0.554097 MAarrowhead1
% End of user PostScript
.0675 .43821 m
.06126 .4819 L
s
% Start of user PostScript
-3. -0.428571 -3.04329 -0.125526 MAarrowhead1
% End of user PostScript
.0675 .5 m
.0675 .54369 L
s
% Start of user PostScript
-3. 0 -3. 0.303046 MAarrowhead1
% End of user PostScript
.0675 .56179 m
.07374 .60548 L
s
% Start of user PostScript
-3. 0.428571 -2.95671 0.731617 MAarrowhead1
% End of user PostScript
.0675 .62357 m
.07998 .66726 L
s
% Start of user PostScript
-3. 0.857143 -2.91342 1.16019 MAarrowhead1
% End of user PostScript
.0675 .68536 m
.08622 .72905 L
s
% Start of user PostScript
-3. 1.28571 -2.87012 1.58876 MAarrowhead1
% End of user PostScript
.0675 .74714 m
.09246 .79083 L
s
% Start of user PostScript
-3. 1.71429 -2.82683 2.01733 MAarrowhead1
% End of user PostScript
.0675 .80893 m
.09871 .85262 L
s
% Start of user PostScript
-3. 2.14286 -2.78354 2.4459 MAarrowhead1
% End of user PostScript
.0675 .87072 m
.10495 .9144 L
s
% Start of user PostScript
-3. 2.57143 -2.74025 2.87447 MAarrowhead1
% End of user PostScript
.0675 .9325 m
.11119 .97619 L
s
% Start of user PostScript
-3. 3. -2.69695 3.30305 MAarrowhead1
% End of user PostScript
.12928 .0675 m
.0856 .10495 L
s
% Start of user PostScript
-2.57143 -3. -2.87447 -2.74025 MAarrowhead1
% End of user PostScript
.12928 .12928 m
.09184 .16673 L
s
% Start of user PostScript
-2.57143 -2.57143 -2.83118 -2.31168 MAarrowhead1
% End of user PostScript
.12928 .19107 m
.09808 .22852 L
s
% Start of user PostScript
-2.57143 -2.14286 -2.78789 -1.8831 MAarrowhead1
% End of user PostScript
.12928 .25286 m
.10432 .2903 L
s
% Start of user PostScript
-2.57143 -1.71429 -2.7446 -1.45453 MAarrowhead1
% End of user PostScript
.12928 .31464 m
.11056 .35209 L
s
% Start of user PostScript
-2.57143 -1.28571 -2.70131 -1.02596 MAarrowhead1
% End of user PostScript
.12928 .37643 m
.1168 .41388 L
s
% Start of user PostScript
-2.57143 -0.857143 -2.65801 -0.597389 MAarrowhead1
% End of user PostScript
.12928 .43821 m
.12304 .47566 L
s
% Start of user PostScript
-2.57143 -0.428571 -2.61472 -0.168818 MAarrowhead1
% End of user PostScript
.12928 .5 m
.12928 .53745 L
s
% Start of user PostScript
-2.57143 0 -2.57143 0.259754 MAarrowhead1
% End of user PostScript
.12928 .56179 m
.13553 .59923 L
s
% Start of user PostScript
-2.57143 0.428571 -2.52814 0.688325 MAarrowhead1
% End of user PostScript
.12928 .62357 m
.14177 .66102 L
s
% Start of user PostScript
-2.57143 0.857143 -2.48484 1.1169 MAarrowhead1
% End of user PostScript
.12928 .68536 m
.14801 .72281 L
s
% Start of user PostScript
-2.57143 1.28571 -2.44155 1.54547 MAarrowhead1
% End of user PostScript
.12928 .74714 m
.15425 .78459 L
s
% Start of user PostScript
-2.57143 1.71429 -2.39826 1.97404 MAarrowhead1
% End of user PostScript
.12928 .80893 m
.16049 .84638 L
s
% Start of user PostScript
-2.57143 2.14286 -2.35497 2.40261 MAarrowhead1
% End of user PostScript
.12928 .87072 m
.16673 .90816 L
s
% Start of user PostScript
-2.57143 2.57143 -2.31168 2.83118 MAarrowhead1
% End of user PostScript
.12928 .9325 m
.17297 .96995 L
s
% Start of user PostScript
-2.57143 3. -2.26838 3.25975 MAarrowhead1
% End of user PostScript
.19107 .0675 m
.14738 .09871 L
s
% Start of user PostScript
-2.14286 -3. -2.4459 -2.78354 MAarrowhead1
% End of user PostScript
.19107 .12928 m
.15362 .16049 L
s
% Start of user PostScript
-2.14286 -2.57143 -2.40261 -2.35497 MAarrowhead1
% End of user PostScript
.19107 .19107 m
.15986 .22228 L
s
% Start of user PostScript
-2.14286 -2.14286 -2.35932 -1.9264 MAarrowhead1
% End of user PostScript
.19107 .25286 m
.16611 .28406 L
s
% Start of user PostScript
-2.14286 -1.71429 -2.31603 -1.49782 MAarrowhead1
% End of user PostScript
.19107 .31464 m
.17235 .34585 L
s
% Start of user PostScript
-2.14286 -1.28571 -2.27273 -1.06925 MAarrowhead1
% End of user PostScript
.19107 .37643 m
.17859 .40763 L
s
% Start of user PostScript
-2.14286 -0.857143 -2.22944 -0.640682 MAarrowhead1
% End of user PostScript
.19107 .43821 m
.18483 .46942 L
s
% Start of user PostScript
-2.14286 -0.428571 -2.18615 -0.21211 MAarrowhead1
% End of user PostScript
.19107 .5 m
.19107 .53121 L
s
% Start of user PostScript
-2.14286 0 -2.14286 0.216461 MAarrowhead1
% End of user PostScript
.19107 .56179 m
.19731 .59299 L
s
% Start of user PostScript
-2.14286 0.428571 -2.09956 0.645033 MAarrowhead1
% End of user PostScript
.19107 .62357 m
.20355 .65478 L
s
% Start of user PostScript
-2.14286 0.857143 -2.05627 1.0736 MAarrowhead1
% End of user PostScript
.19107 .68536 m
.20979 .71656 L
s
% Start of user PostScript
-2.14286 1.28571 -2.01298 1.50218 MAarrowhead1
% End of user PostScript
.19107 .74714 m
.21604 .77835 L
s
% Start of user PostScript
-2.14286 1.71429 -1.96969 1.93075 MAarrowhead1
% End of user PostScript
.19107 .80893 m
.22228 .84014 L
s
% Start of user PostScript
-2.14286 2.14286 -1.9264 2.35932 MAarrowhead1
% End of user PostScript
.19107 .87072 m
.22852 .90192 L
s
% Start of user PostScript
-2.14286 2.57143 -1.8831 2.78789 MAarrowhead1
% End of user PostScript
.19107 .9325 m
.23476 .96371 L
s
% Start of user PostScript
-2.14286 3. -1.83981 3.21646 MAarrowhead1
% End of user PostScript
.25286 .0675 m
.20917 .09246 L
s
% Start of user PostScript
-1.71429 -3. -2.01733 -2.82683 MAarrowhead1
% End of user PostScript
.25286 .12928 m
.21541 .15425 L
s
% Start of user PostScript
-1.71429 -2.57143 -1.97404 -2.39826 MAarrowhead1
% End of user PostScript
.25286 .19107 m
.22165 .21604 L
s
% Start of user PostScript
-1.71429 -2.14286 -1.93075 -1.96969 MAarrowhead1
% End of user PostScript
.25286 .25286 m
.22789 .27782 L
s
% Start of user PostScript
-1.71429 -1.71429 -1.88745 -1.54112 MAarrowhead1
% End of user PostScript
.25286 .31464 m
.23413 .33961 L
s
% Start of user PostScript
-1.71429 -1.28571 -1.84416 -1.11255 MAarrowhead1
% End of user PostScript
.25286 .37643 m
.24037 .40139 L
s
% Start of user PostScript
-1.71429 -0.857143 -1.80087 -0.683974 MAarrowhead1
% End of user PostScript
.25286 .43821 m
.24662 .46318 L
s
% Start of user PostScript
-1.71429 -0.428571 -1.75758 -0.255402 MAarrowhead1
% End of user PostScript
.25286 .5 m
.25286 .52497 L
s
% Start of user PostScript
-1.71429 0 -1.71429 0.173169 MAarrowhead1
% End of user PostScript
.25286 .56179 m
.2591 .58675 L
s
% Start of user PostScript
-1.71429 0.428571 -1.67099 0.60174 MAarrowhead1
% End of user PostScript
.25286 .62357 m
.26534 .64854 L
s
% Start of user PostScript
-1.71429 0.857143 -1.6277 1.03031 MAarrowhead1
% End of user PostScript
.25286 .68536 m
.27158 .71032 L
s
% Start of user PostScript
-1.71429 1.28571 -1.58441 1.45888 MAarrowhead1
% End of user PostScript
.25286 .74714 m
.27782 .77211 L
s
% Start of user PostScript
-1.71429 1.71429 -1.54112 1.88745 MAarrowhead1
% End of user PostScript
.25286 .80893 m
.28406 .83389 L
s
% Start of user PostScript
-1.71429 2.14286 -1.49782 2.31603 MAarrowhead1
% End of user PostScript
.25286 .87072 m
.2903 .89568 L
s
% Start of user PostScript
-1.71429 2.57143 -1.45453 2.7446 MAarrowhead1
% End of user PostScript
.25286 .9325 m
.29655 .95747 L
s
% Start of user PostScript
-1.71429 3. -1.41124 3.17317 MAarrowhead1
% End of user PostScript
.31464 .0675 m
.27095 .08622 L
s
% Start of user PostScript
-1.28571 -3. -1.58876 -2.87012 MAarrowhead1
% End of user PostScript
.31464 .12928 m
.27719 .14801 L
s
% Start of user PostScript
-1.28571 -2.57143 -1.54547 -2.44155 MAarrowhead1
% End of user PostScript
.31464 .19107 m
.28344 .20979 L
s
% Start of user PostScript
-1.28571 -2.14286 -1.50218 -2.01298 MAarrowhead1
% End of user PostScript
.31464 .25286 m
.28968 .27158 L
s
% Start of user PostScript
-1.28571 -1.71429 -1.45888 -1.58441 MAarrowhead1
% End of user PostScript
.31464 .31464 m
.29592 .33337 L
s
% Start of user PostScript
-1.28571 -1.28571 -1.41559 -1.15584 MAarrowhead1
% End of user PostScript
.31464 .37643 m
.30216 .39515 L
s
% Start of user PostScript
-1.28571 -0.857143 -1.3723 -0.727266 MAarrowhead1
% End of user PostScript
.31464 .43821 m
.3084 .45694 L
s
% Start of user PostScript
-1.28571 -0.428571 -1.32901 -0.298695 MAarrowhead1
% End of user PostScript
.31464 .5 m
.31464 .51872 L
s
% Start of user PostScript
-1.28571 0 -1.28571 0.129877 MAarrowhead1
% End of user PostScript
.31464 .56179 m
.32088 .58051 L
s
% Start of user PostScript
-1.28571 0.428571 -1.24242 0.558448 MAarrowhead1
% End of user PostScript
.31464 .62357 m
.32712 .6423 L
s
% Start of user PostScript
-1.28571 0.857143 -1.19913 0.98702 MAarrowhead1
% End of user PostScript
.31464 .68536 m
.33337 .70408 L
s
% Start of user PostScript
-1.28571 1.28571 -1.15584 1.41559 MAarrowhead1
% End of user PostScript
.31464 .74714 m
.33961 .76587 L
s
% Start of user PostScript
-1.28571 1.71429 -1.11255 1.84416 MAarrowhead1
% End of user PostScript
.31464 .80893 m
.34585 .82765 L
s
% Start of user PostScript
-1.28571 2.14286 -1.06925 2.27273 MAarrowhead1
% End of user PostScript
.31464 .87072 m
.35209 .88944 L
s
% Start of user PostScript
-1.28571 2.57143 -1.02596 2.70131 MAarrowhead1
% End of user PostScript
.31464 .9325 m
.35833 .95123 L
s
% Start of user PostScript
-1.28571 3. -0.982669 3.12988 MAarrowhead1
% End of user PostScript
.37643 .0675 m
.33274 .07998 L
s
% Start of user PostScript
-0.857143 -3. -1.16019 -2.91342 MAarrowhead1
% End of user PostScript
.37643 .12928 m
.33898 .14177 L
s
% Start of user PostScript
-0.857143 -2.57143 -1.1169 -2.48484 MAarrowhead1
% End of user PostScript
.37643 .19107 m
.34522 .20355 L
s
% Start of user PostScript
-0.857143 -2.14286 -1.0736 -2.05627 MAarrowhead1
% End of user PostScript
.37643 .25286 m
.35146 .26534 L
s
% Start of user PostScript
-0.857143 -1.71429 -1.03031 -1.6277 MAarrowhead1
% End of user PostScript
.37643 .31464 m
.3577 .32712 L
s
% Start of user PostScript
-0.857143 -1.28571 -0.98702 -1.19913 MAarrowhead1
% End of user PostScript
.37643 .37643 m
.36395 .38891 L
s
% Start of user PostScript
-0.857143 -0.857143 -0.943727 -0.770558 MAarrowhead1
% End of user PostScript
.37643 .43821 m
.37019 .4507 L
s
% Start of user PostScript
-0.857143 -0.428571 -0.900435 -0.341987 MAarrowhead1
% End of user PostScript
.37643 .5 m
.37643 .51248 L
s
% Start of user PostScript
-0.857143 0 -0.857143 0.0865845 MAarrowhead1
% End of user PostScript
.37643 .56179 m
.38267 .57427 L
s
% Start of user PostScript
-0.857143 0.428571 -0.813851 0.515156 MAarrowhead1
% End of user PostScript
.37643 .62357 m
.38891 .63605 L
s
% Start of user PostScript
-0.857143 0.857143 -0.770558 0.943727 MAarrowhead1
% End of user PostScript
.37643 .68536 m
.39515 .69784 L
s
% Start of user PostScript
-0.857143 1.28571 -0.727266 1.3723 MAarrowhead1
% End of user PostScript
.37643 .74714 m
.40139 .75963 L
s
% Start of user PostScript
-0.857143 1.71429 -0.683974 1.80087 MAarrowhead1
% End of user PostScript
.37643 .80893 m
.40763 .82141 L
s
% Start of user PostScript
-0.857143 2.14286 -0.640682 2.22944 MAarrowhead1
% End of user PostScript
.37643 .87072 m
.41388 .8832 L
s
% Start of user PostScript
-0.857143 2.57143 -0.597389 2.65801 MAarrowhead1
% End of user PostScript
.37643 .9325 m
.42012 .94498 L
s
% Start of user PostScript
-0.857143 3. -0.554097 3.08658 MAarrowhead1
% End of user PostScript
.43821 .0675 m
.39452 .07374 L
s
% Start of user PostScript
-0.428571 -3. -0.731617 -2.95671 MAarrowhead1
% End of user PostScript
.43821 .12928 m
.40077 .13553 L
s
% Start of user PostScript
-0.428571 -2.57143 -0.688325 -2.52814 MAarrowhead1
% End of user PostScript
.43821 .19107 m
.40701 .19731 L
s
% Start of user PostScript
-0.428571 -2.14286 -0.645033 -2.09956 MAarrowhead1
% End of user PostScript
.43821 .25286 m
.41325 .2591 L
s
% Start of user PostScript
-0.428571 -1.71429 -0.60174 -1.67099 MAarrowhead1
% End of user PostScript
.43821 .31464 m
.41949 .32088 L
s
% Start of user PostScript
-0.428571 -1.28571 -0.558448 -1.24242 MAarrowhead1
% End of user PostScript
.43821 .37643 m
.42573 .38267 L
s
% Start of user PostScript
-0.428571 -0.857143 -0.515156 -0.813851 MAarrowhead1
% End of user PostScript
.43821 .43821 m
.43197 .44446 L
s
% Start of user PostScript
-0.428571 -0.428571 -0.471864 -0.385279 MAarrowhead1
% End of user PostScript
.43821 .5 m
.43821 .50624 L
s
% Start of user PostScript
-0.428571 0 -0.428571 0.0432923 MAarrowhead1
% End of user PostScript
.43821 .56179 m
.44446 .56803 L
s
% Start of user PostScript
-0.428571 0.428571 -0.385279 0.471864 MAarrowhead1
% End of user PostScript
.43821 .62357 m
.4507 .62981 L
s
% Start of user PostScript
-0.428571 0.857143 -0.341987 0.900435 MAarrowhead1
% End of user PostScript
.43821 .68536 m
.45694 .6916 L
s
% Start of user PostScript
-0.428571 1.28571 -0.298695 1.32901 MAarrowhead1
% End of user PostScript
.43821 .74714 m
.46318 .75338 L
s
% Start of user PostScript
-0.428571 1.71429 -0.255402 1.75758 MAarrowhead1
% End of user PostScript
.43821 .80893 m
.46942 .81517 L
s
% Start of user PostScript
-0.428571 2.14286 -0.21211 2.18615 MAarrowhead1
% End of user PostScript
.43821 .87072 m
.47566 .87696 L
s
% Start of user PostScript
-0.428571 2.57143 -0.168818 2.61472 MAarrowhead1
% End of user PostScript
.43821 .9325 m
.4819 .93874 L
s
% Start of user PostScript
-0.428571 3. -0.125526 3.04329 MAarrowhead1
% End of user PostScript
.5 .0675 m
.45631 .0675 L
s
% Start of user PostScript
0 -3. -0.303046 -3. MAarrowhead1
% End of user PostScript
.5 .12928 m
.46255 .12928 L
s
% Start of user PostScript
0 -2.57143 -0.259754 -2.57143 MAarrowhead1
% End of user PostScript
.5 .19107 m
.46879 .19107 L
s
% Start of user PostScript
0 -2.14286 -0.216461 -2.14286 MAarrowhead1
% End of user PostScript
.5 .25286 m
.47503 .25286 L
s
% Start of user PostScript
0 -1.71429 -0.173169 -1.71429 MAarrowhead1
% End of user PostScript
.5 .31464 m
.48128 .31464 L
s
% Start of user PostScript
0 -1.28571 -0.129877 -1.28571 MAarrowhead1
% End of user PostScript
.5 .37643 m
.48752 .37643 L
s
% Start of user PostScript
0 -0.857143 -0.0865845 -0.857143 MAarrowhead1
% End of user PostScript
.5 .43821 m
.49376 .43821 L
s
% Start of user PostScript
0 -0.428571 -0.0432923 -0.428571 MAarrowhead1
% End of user PostScript
.5 .5 m
.5 .5 L
s
% Start of user PostScript
0 0 MAarrowzero1
% End of user PostScript
.5 .56179 m
.50624 .56179 L
s
% Start of user PostScript
0 0.428571 0.0432923 0.428571 MAarrowhead1
% End of user PostScript
.5 .62357 m
.51248 .62357 L
s
% Start of user PostScript
0 0.857143 0.0865845 0.857143 MAarrowhead1
% End of user PostScript
.5 .68536 m
.51872 .68536 L
s
% Start of user PostScript
0 1.28571 0.129877 1.28571 MAarrowhead1
% End of user PostScript
.5 .74714 m
.52497 .74714 L
s
% Start of user PostScript
0 1.71429 0.173169 1.71429 MAarrowhead1
% End of user PostScript
.5 .80893 m
.53121 .80893 L
s
% Start of user PostScript
0 2.14286 0.216461 2.14286 MAarrowhead1
% End of user PostScript
.5 .87072 m
.53745 .87072 L
s
% Start of user PostScript
0 2.57143 0.259754 2.57143 MAarrowhead1
% End of user PostScript
.5 .9325 m
.54369 .9325 L
s
% Start of user PostScript
0 3. 0.303046 3. MAarrowhead1
% End of user PostScript
.56179 .0675 m
.5181 .06126 L
s
% Start of user PostScript
0.428571 -3. 0.125526 -3.04329 MAarrowhead1
% End of user PostScript
.56179 .12928 m
.52434 .12304 L
s
% Start of user PostScript
0.428571 -2.57143 0.168818 -2.61472 MAarrowhead1
% End of user PostScript
.56179 .19107 m
.53058 .18483 L
s
% Start of user PostScript
0.428571 -2.14286 0.21211 -2.18615 MAarrowhead1
% End of user PostScript
.56179 .25286 m
.53682 .24662 L
s
% Start of user PostScript
0.428571 -1.71429 0.255402 -1.75758 MAarrowhead1
% End of user PostScript
.56179 .31464 m
.54306 .3084 L
s
% Start of user PostScript
0.428571 -1.28571 0.298695 -1.32901 MAarrowhead1
% End of user PostScript
.56179 .37643 m
.5493 .37019 L
s
% Start of user PostScript
0.428571 -0.857143 0.341987 -0.900435 MAarrowhead1
% End of user PostScript
.56179 .43821 m
.55554 .43197 L
s
% Start of user PostScript
0.428571 -0.428571 0.385279 -0.471864 MAarrowhead1
% End of user PostScript
.56179 .5 m
.56179 .49376 L
s
% Start of user PostScript
0.428571 0 0.428571 -0.0432923 MAarrowhead1
% End of user PostScript
.56179 .56179 m
.56803 .55554 L
s
% Start of user PostScript
0.428571 0.428571 0.471864 0.385279 MAarrowhead1
% End of user PostScript
.56179 .62357 m
.57427 .61733 L
s
% Start of user PostScript
0.428571 0.857143 0.515156 0.813851 MAarrowhead1
% End of user PostScript
.56179 .68536 m
.58051 .67912 L
s
% Start of user PostScript
0.428571 1.28571 0.558448 1.24242 MAarrowhead1
% End of user PostScript
.56179 .74714 m
.58675 .7409 L
s
% Start of user PostScript
0.428571 1.71429 0.60174 1.67099 MAarrowhead1
% End of user PostScript
.56179 .80893 m
.59299 .80269 L
s
% Start of user PostScript
0.428571 2.14286 0.645033 2.09956 MAarrowhead1
% End of user PostScript
.56179 .87072 m
.59923 .86447 L
s
% Start of user PostScript
0.428571 2.57143 0.688325 2.52814 MAarrowhead1
% End of user PostScript
.56179 .9325 m
.60548 .92626 L
s
% Start of user PostScript
0.428571 3. 0.731617 2.95671 MAarrowhead1
% End of user PostScript
.62357 .0675 m
.57988 .05502 L
s
% Start of user PostScript
0.857143 -3. 0.554097 -3.08658 MAarrowhead1
% End of user PostScript
.62357 .12928 m
.58612 .1168 L
s
% Start of user PostScript
0.857143 -2.57143 0.597389 -2.65801 MAarrowhead1
% End of user PostScript
.62357 .19107 m
.59237 .17859 L
s
% Start of user PostScript
0.857143 -2.14286 0.640682 -2.22944 MAarrowhead1
% End of user PostScript
.62357 .25286 m
.59861 .24037 L
s
% Start of user PostScript
0.857143 -1.71429 0.683974 -1.80087 MAarrowhead1
% End of user PostScript
.62357 .31464 m
.60485 .30216 L
s
% Start of user PostScript
0.857143 -1.28571 0.727266 -1.3723 MAarrowhead1
% End of user PostScript
.62357 .37643 m
.61109 .36395 L
s
% Start of user PostScript
0.857143 -0.857143 0.770558 -0.943727 MAarrowhead1
% End of user PostScript
.62357 .43821 m
.61733 .42573 L
s
% Start of user PostScript
0.857143 -0.428571 0.813851 -0.515156 MAarrowhead1
% End of user PostScript
.62357 .5 m
.62357 .48752 L
s
% Start of user PostScript
0.857143 0 0.857143 -0.0865845 MAarrowhead1
% End of user PostScript
.62357 .56179 m
.62981 .5493 L
s
% Start of user PostScript
0.857143 0.428571 0.900435 0.341987 MAarrowhead1
% End of user PostScript
.62357 .62357 m
.63605 .61109 L
s
% Start of user PostScript
0.857143 0.857143 0.943727 0.770558 MAarrowhead1
% End of user PostScript
.62357 .68536 m
.6423 .67288 L
s
% Start of user PostScript
0.857143 1.28571 0.98702 1.19913 MAarrowhead1
% End of user PostScript
.62357 .74714 m
.64854 .73466 L
s
% Start of user PostScript
0.857143 1.71429 1.03031 1.6277 MAarrowhead1
% End of user PostScript
.62357 .80893 m
.65478 .79645 L
s
% Start of user PostScript
0.857143 2.14286 1.0736 2.05627 MAarrowhead1
% End of user PostScript
.62357 .87072 m
.66102 .85823 L
s
% Start of user PostScript
0.857143 2.57143 1.1169 2.48484 MAarrowhead1
% End of user PostScript
.62357 .9325 m
.66726 .92002 L
s
% Start of user PostScript
0.857143 3. 1.16019 2.91342 MAarrowhead1
% End of user PostScript
.68536 .0675 m
.64167 .04877 L
s
% Start of user PostScript
1.28571 -3. 0.982669 -3.12988 MAarrowhead1
% End of user PostScript
.68536 .12928 m
.64791 .11056 L
s
% Start of user PostScript
1.28571 -2.57143 1.02596 -2.70131 MAarrowhead1
% End of user PostScript
.68536 .19107 m
.65415 .17235 L
s
% Start of user PostScript
1.28571 -2.14286 1.06925 -2.27273 MAarrowhead1
% End of user PostScript
.68536 .25286 m
.66039 .23413 L
s
% Start of user PostScript
1.28571 -1.71429 1.11255 -1.84416 MAarrowhead1
% End of user PostScript
.68536 .31464 m
.66663 .29592 L
s
% Start of user PostScript
1.28571 -1.28571 1.15584 -1.41559 MAarrowhead1
% End of user PostScript
.68536 .37643 m
.67288 .3577 L
s
% Start of user PostScript
1.28571 -0.857143 1.19913 -0.98702 MAarrowhead1
% End of user PostScript
.68536 .43821 m
.67912 .41949 L
s
% Start of user PostScript
1.28571 -0.428571 1.24242 -0.558448 MAarrowhead1
% End of user PostScript
.68536 .5 m
.68536 .48128 L
s
% Start of user PostScript
1.28571 0 1.28571 -0.129877 MAarrowhead1
% End of user PostScript
.68536 .56179 m
.6916 .54306 L
s
% Start of user PostScript
1.28571 0.428571 1.32901 0.298695 MAarrowhead1
% End of user PostScript
.68536 .62357 m
.69784 .60485 L
s
% Start of user PostScript
1.28571 0.857143 1.3723 0.727266 MAarrowhead1
% End of user PostScript
.68536 .68536 m
.70408 .66663 L
s
% Start of user PostScript
1.28571 1.28571 1.41559 1.15584 MAarrowhead1
% End of user PostScript
.68536 .74714 m
.71032 .72842 L
s
% Start of user PostScript
1.28571 1.71429 1.45888 1.58441 MAarrowhead1
% End of user PostScript
.68536 .80893 m
.71656 .79021 L
s
% Start of user PostScript
1.28571 2.14286 1.50218 2.01298 MAarrowhead1
% End of user PostScript
.68536 .87072 m
.72281 .85199 L
s
% Start of user PostScript
1.28571 2.57143 1.54547 2.44155 MAarrowhead1
% End of user PostScript
.68536 .9325 m
.72905 .91378 L
s
% Start of user PostScript
1.28571 3. 1.58876 2.87012 MAarrowhead1
% End of user PostScript
.74714 .0675 m
.70345 .04253 L
s
% Start of user PostScript
1.71429 -3. 1.41124 -3.17317 MAarrowhead1
% End of user PostScript
.74714 .12928 m
.7097 .10432 L
s
% Start of user PostScript
1.71429 -2.57143 1.45453 -2.7446 MAarrowhead1
% End of user PostScript
.74714 .19107 m
.71594 .16611 L
s
% Start of user PostScript
1.71429 -2.14286 1.49782 -2.31603 MAarrowhead1
% End of user PostScript
.74714 .25286 m
.72218 .22789 L
s
% Start of user PostScript
1.71429 -1.71429 1.54112 -1.88745 MAarrowhead1
% End of user PostScript
.74714 .31464 m
.72842 .28968 L
s
% Start of user PostScript
1.71429 -1.28571 1.58441 -1.45888 MAarrowhead1
% End of user PostScript
.74714 .37643 m
.73466 .35146 L
s
% Start of user PostScript
1.71429 -0.857143 1.6277 -1.03031 MAarrowhead1
% End of user PostScript
.74714 .43821 m
.7409 .41325 L
s
% Start of user PostScript
1.71429 -0.428571 1.67099 -0.60174 MAarrowhead1
% End of user PostScript
.74714 .5 m
.74714 .47503 L
s
% Start of user PostScript
1.71429 0 1.71429 -0.173169 MAarrowhead1
% End of user PostScript
.74714 .56179 m
.75338 .53682 L
s
% Start of user PostScript
1.71429 0.428571 1.75758 0.255402 MAarrowhead1
% End of user PostScript
.74714 .62357 m
.75963 .59861 L
s
% Start of user PostScript
1.71429 0.857143 1.80087 0.683974 MAarrowhead1
% End of user PostScript
.74714 .68536 m
.76587 .66039 L
s
% Start of user PostScript
1.71429 1.28571 1.84416 1.11255 MAarrowhead1
% End of user PostScript
.74714 .74714 m
.77211 .72218 L
s
% Start of user PostScript
1.71429 1.71429 1.88745 1.54112 MAarrowhead1
% End of user PostScript
.74714 .80893 m
.77835 .78396 L
s
% Start of user PostScript
1.71429 2.14286 1.93075 1.96969 MAarrowhead1
% End of user PostScript
.74714 .87072 m
.78459 .84575 L
s
% Start of user PostScript
1.71429 2.57143 1.97404 2.39826 MAarrowhead1
% End of user PostScript
.74714 .9325 m
.79083 .90754 L
s
% Start of user PostScript
1.71429 3. 2.01733 2.82683 MAarrowhead1
% End of user PostScript
.80893 .0675 m
.76524 .03629 L
s
% Start of user PostScript
2.14286 -3. 1.83981 -3.21646 MAarrowhead1
% End of user PostScript
.80893 .12928 m
.77148 .09808 L
s
% Start of user PostScript
2.14286 -2.57143 1.8831 -2.78789 MAarrowhead1
% End of user PostScript
.80893 .19107 m
.77772 .15986 L
s
% Start of user PostScript
2.14286 -2.14286 1.9264 -2.35932 MAarrowhead1
% End of user PostScript
.80893 .25286 m
.78396 .22165 L
s
% Start of user PostScript
2.14286 -1.71429 1.96969 -1.93075 MAarrowhead1
% End of user PostScript
.80893 .31464 m
.79021 .28344 L
s
% Start of user PostScript
2.14286 -1.28571 2.01298 -1.50218 MAarrowhead1
% End of user PostScript
.80893 .37643 m
.79645 .34522 L
s
% Start of user PostScript
2.14286 -0.857143 2.05627 -1.0736 MAarrowhead1
% End of user PostScript
.80893 .43821 m
.80269 .40701 L
s
% Start of user PostScript
2.14286 -0.428571 2.09956 -0.645033 MAarrowhead1
% End of user PostScript
.80893 .5 m
.80893 .46879 L
s
% Start of user PostScript
2.14286 0 2.14286 -0.216461 MAarrowhead1
% End of user PostScript
.80893 .56179 m
.81517 .53058 L
s
% Start of user PostScript
2.14286 0.428571 2.18615 0.21211 MAarrowhead1
% End of user PostScript
.80893 .62357 m
.82141 .59237 L
s
% Start of user PostScript
2.14286 0.857143 2.22944 0.640682 MAarrowhead1
% End of user PostScript
.80893 .68536 m
.82765 .65415 L
s
% Start of user PostScript
2.14286 1.28571 2.27273 1.06925 MAarrowhead1
% End of user PostScript
.80893 .74714 m
.83389 .71594 L
s
% Start of user PostScript
2.14286 1.71429 2.31603 1.49782 MAarrowhead1
% End of user PostScript
.80893 .80893 m
.84014 .77772 L
s
% Start of user PostScript
2.14286 2.14286 2.35932 1.9264 MAarrowhead1
% End of user PostScript
.80893 .87072 m
.84638 .83951 L
s
% Start of user PostScript
2.14286 2.57143 2.40261 2.35497 MAarrowhead1
% End of user PostScript
.80893 .9325 m
.85262 .90129 L
s
% Start of user PostScript
2.14286 3. 2.4459 2.78354 MAarrowhead1
% End of user PostScript
.87072 .0675 m
.82703 .03005 L
s
% Start of user PostScript
2.57143 -3. 2.26838 -3.25975 MAarrowhead1
% End of user PostScript
.87072 .12928 m
.83327 .09184 L
s
% Start of user PostScript
2.57143 -2.57143 2.31168 -2.83118 MAarrowhead1
% End of user PostScript
.87072 .19107 m
.83951 .15362 L
s
% Start of user PostScript
2.57143 -2.14286 2.35497 -2.40261 MAarrowhead1
% End of user PostScript
.87072 .25286 m
.84575 .21541 L
s
% Start of user PostScript
2.57143 -1.71429 2.39826 -1.97404 MAarrowhead1
% End of user PostScript
.87072 .31464 m
.85199 .27719 L
s
% Start of user PostScript
2.57143 -1.28571 2.44155 -1.54547 MAarrowhead1
% End of user PostScript
.87072 .37643 m
.85823 .33898 L
s
% Start of user PostScript
2.57143 -0.857143 2.48484 -1.1169 MAarrowhead1
% End of user PostScript
.87072 .43821 m
.86447 .40077 L
s
% Start of user PostScript
2.57143 -0.428571 2.52814 -0.688325 MAarrowhead1
% End of user PostScript
.87072 .5 m
.87072 .46255 L
s
% Start of user PostScript
2.57143 0 2.57143 -0.259754 MAarrowhead1
% End of user PostScript
.87072 .56179 m
.87696 .52434 L
s
% Start of user PostScript
2.57143 0.428571 2.61472 0.168818 MAarrowhead1
% End of user PostScript
.87072 .62357 m
.8832 .58612 L
s
% Start of user PostScript
2.57143 0.857143 2.65801 0.597389 MAarrowhead1
% End of user PostScript
.87072 .68536 m
.88944 .64791 L
s
% Start of user PostScript
2.57143 1.28571 2.70131 1.02596 MAarrowhead1
% End of user PostScript
.87072 .74714 m
.89568 .7097 L
s
% Start of user PostScript
2.57143 1.71429 2.7446 1.45453 MAarrowhead1
% End of user PostScript
.87072 .80893 m
.90192 .77148 L
s
% Start of user PostScript
2.57143 2.14286 2.78789 1.8831 MAarrowhead1
% End of user PostScript
.87072 .87072 m
.90816 .83327 L
s
% Start of user PostScript
2.57143 2.57143 2.83118 2.31168 MAarrowhead1
% End of user PostScript
.87072 .9325 m
.9144 .89505 L
s
% Start of user PostScript
2.57143 3. 2.87447 2.74025 MAarrowhead1
% End of user PostScript
.9325 .0675 m
.88881 .02381 L
s
% Start of user PostScript
3. -3. 2.69695 -3.30305 MAarrowhead1
% End of user PostScript
.9325 .12928 m
.89505 .0856 L
s
% Start of user PostScript
3. -2.57143 2.74025 -2.87447 MAarrowhead1
% End of user PostScript
.9325 .19107 m
.90129 .14738 L
s
% Start of user PostScript
3. -2.14286 2.78354 -2.4459 MAarrowhead1
% End of user PostScript
.9325 .25286 m
.90754 .20917 L
s
% Start of user PostScript
3. -1.71429 2.82683 -2.01733 MAarrowhead1
% End of user PostScript
.9325 .31464 m
.91378 .27095 L
s
% Start of user PostScript
3. -1.28571 2.87012 -1.58876 MAarrowhead1
% End of user PostScript
.9325 .37643 m
.92002 .33274 L
s
% Start of user PostScript
3. -0.857143 2.91342 -1.16019 MAarrowhead1
% End of user PostScript
.9325 .43821 m
.92626 .39452 L
s
% Start of user PostScript
3. -0.428571 2.95671 -0.731617 MAarrowhead1
% End of user PostScript
.9325 .5 m
.9325 .45631 L
s
% Start of user PostScript
3. 0 3. -0.303046 MAarrowhead1
% End of user PostScript
.9325 .56179 m
.93874 .5181 L
s
% Start of user PostScript
3. 0.428571 3.04329 0.125526 MAarrowhead1
% End of user PostScript
.9325 .62357 m
.94498 .57988 L
s
% Start of user PostScript
3. 0.857143 3.08658 0.554097 MAarrowhead1
% End of user PostScript
.9325 .68536 m
.95123 .64167 L
s
% Start of user PostScript
3. 1.28571 3.12988 0.982669 MAarrowhead1
% End of user PostScript
.9325 .74714 m
.95747 .70345 L
s
% Start of user PostScript
3. 1.71429 3.17317 1.41124 MAarrowhead1
% End of user PostScript
.9325 .80893 m
.96371 .76524 L
s
% Start of user PostScript
3. 2.14286 3.21646 1.83981 MAarrowhead1
% End of user PostScript
.9325 .87072 m
.96995 .82703 L
s
% Start of user PostScript
3. 2.57143 3.25975 2.26838 MAarrowhead1
% End of user PostScript
.9325 .9325 m
.97619 .88881 L
s
% Start of user PostScript
3. 3. 3.30305 2.69695 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.39.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.39.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ScaleFactor", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "linearly rescales the vectors so the longest vector is equal to this \
value; ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" fits the vectors in the mesh, ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" eliminates the rescaling",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ScaleFunction", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a function to use for rescaling the magnitude of vectors ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MaxArrowLength", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "length of the largest vector to be drawn, applied after the ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["ScaleFunction", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" but before the ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["ScaleFactor", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ColorFunction", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a function to use for coloring the vectors by their magnitude",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotPoints", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["15", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the number of evaluation points in each direction ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.39.1"],

Cell["Options for vector field plotting.", "Caption",
 CellTags->"S5.39.1"],

Cell["\<\
This increases the number of sample points in each direction to 20 and draws \
each vector at half its true magnitude. \
\>", "MathCaption",
 CellTags->{"S5.39.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
PlotVectorField[{Sin[x y], Cos[x y]},
  {x, 0, Pi}, {y, 0, Pi},
  PlotPoints -> 20,
  ScaleFunction -> (.5#&),
  ScaleFactor -> None]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.39.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00001 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.261531 0.0238098 0.261531 [
[ 0 0 0 0 ]
[ 1 1.00001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.0001 w
[ ] 0 setdash
.02381 .02381 m
.02381 .15458 L
s
% Start of user PostScript
0 0 0 0.5 MAarrowhead1
% End of user PostScript
.02381 .06705 m
.02381 .19782 L
s
% Start of user PostScript
0 0.165347 0 0.665347 MAarrowhead1
% End of user PostScript
.02381 .1103 m
.02381 .24106 L
s
% Start of user PostScript
0 0.330694 0 0.830694 MAarrowhead1
% End of user PostScript
.02381 .15354 m
.02381 .28431 L
s
% Start of user PostScript
0 0.496041 0 0.996041 MAarrowhead1
% End of user PostScript
.02381 .19678 m
.02381 .32755 L
s
% Start of user PostScript
0 0.661388 0 1.16139 MAarrowhead1
% End of user PostScript
.02381 .24003 m
.02381 .37079 L
s
% Start of user PostScript
0 0.826735 0 1.32673 MAarrowhead1
% End of user PostScript
.02381 .28327 m
.02381 .41404 L
s
% Start of user PostScript
0 0.992082 0 1.49208 MAarrowhead1
% End of user PostScript
.02381 .32651 m
.02381 .45728 L
s
% Start of user PostScript
0 1.15743 0 1.65743 MAarrowhead1
% End of user PostScript
.02381 .36976 m
.02381 .50052 L
s
% Start of user PostScript
0 1.32278 0 1.82278 MAarrowhead1
% End of user PostScript
.02381 .413 m
.02381 .54377 L
s
% Start of user PostScript
0 1.48812 0 1.98812 MAarrowhead1
% End of user PostScript
.02381 .45624 m
.02381 .58701 L
s
% Start of user PostScript
0 1.65347 0 2.15347 MAarrowhead1
% End of user PostScript
.02381 .49949 m
.02381 .63025 L
s
% Start of user PostScript
0 1.81882 0 2.31882 MAarrowhead1
% End of user PostScript
.02381 .54273 m
.02381 .6735 L
s
% Start of user PostScript
0 1.98416 0 2.48416 MAarrowhead1
% End of user PostScript
.02381 .58597 m
.02381 .71674 L
s
% Start of user PostScript
0 2.14951 0 2.64951 MAarrowhead1
% End of user PostScript
.02381 .62922 m
.02381 .75998 L
s
% Start of user PostScript
0 2.31486 0 2.81486 MAarrowhead1
% End of user PostScript
.02381 .67246 m
.02381 .80323 L
s
% Start of user PostScript
0 2.4802 0 2.9802 MAarrowhead1
% End of user PostScript
.02381 .7157 m
.02381 .84647 L
s
% Start of user PostScript
0 2.64555 0 3.14555 MAarrowhead1
% End of user PostScript
.02381 .75895 m
.02381 .88971 L
s
% Start of user PostScript
0 2.8109 0 3.3109 MAarrowhead1
% End of user PostScript
.02381 .80219 m
.02381 .93296 L
s
% Start of user PostScript
0 2.97625 0 3.47625 MAarrowhead1
% End of user PostScript
.02381 .84544 m
.02381 .9762 L
s
% Start of user PostScript
0 3.14159 0 3.64159 MAarrowhead1
% End of user PostScript
.06705 .02381 m
.06705 .15458 L
s
% Start of user PostScript
0.165347 0 0.165347 0.5 MAarrowhead1
% End of user PostScript
.06705 .06705 m
.07063 .19777 L
s
% Start of user PostScript
0.165347 0.165347 0.179015 0.66516 MAarrowhead1
% End of user PostScript
.06705 .1103 m
.0742 .24087 L
s
% Start of user PostScript
0.165347 0.330694 0.192673 0.829947 MAarrowhead1
% End of user PostScript
.06705 .15354 m
.07777 .28387 L
s
% Start of user PostScript
0.165347 0.496041 0.20631 0.99436 MAarrowhead1
% End of user PostScript
.06705 .19678 m
.08132 .32677 L
s
% Start of user PostScript
0.165347 0.661388 0.219917 1.1584 MAarrowhead1
% End of user PostScript
.06705 .24003 m
.08487 .36957 L
s
% Start of user PostScript
0.165347 0.826735 0.233483 1.32207 MAarrowhead1
% End of user PostScript
.06705 .28327 m
.08841 .41228 L
s
% Start of user PostScript
0.165347 0.992082 0.246999 1.48537 MAarrowhead1
% End of user PostScript
.06705 .32651 m
.09193 .45489 L
s
% Start of user PostScript
0.165347 1.15743 0.260453 1.6483 MAarrowhead1
% End of user PostScript
.06705 .36976 m
.09543 .49741 L
s
% Start of user PostScript
0.165347 1.32278 0.273836 1.81086 MAarrowhead1
% End of user PostScript
.06705 .413 m
.09891 .53983 L
s
% Start of user PostScript
0.165347 1.48812 0.287138 1.97306 MAarrowhead1
% End of user PostScript
.06705 .45624 m
.10236 .58215 L
s
% Start of user PostScript
0.165347 1.65347 0.300349 2.1349 MAarrowhead1
% End of user PostScript
.06705 .49949 m
.10579 .62438 L
s
% Start of user PostScript
0.165347 1.81882 0.313459 2.29638 MAarrowhead1
% End of user PostScript
.06705 .54273 m
.10919 .66652 L
s
% Start of user PostScript
0.165347 1.98416 0.326458 2.4575 MAarrowhead1
% End of user PostScript
.06705 .58597 m
.11256 .70857 L
s
% Start of user PostScript
0.165347 2.14951 0.339337 2.61826 MAarrowhead1
% End of user PostScript
.06705 .62922 m
.11589 .75052 L
s
% Start of user PostScript
0.165347 2.31486 0.352086 2.77868 MAarrowhead1
% End of user PostScript
.06705 .67246 m
.11919 .79238 L
s
% Start of user PostScript
0.165347 2.4802 0.364695 2.93875 MAarrowhead1
% End of user PostScript
.06705 .7157 m
.12245 .83416 L
s
% Start of user PostScript
0.165347 2.64555 0.377155 3.09847 MAarrowhead1
% End of user PostScript
.06705 .75895 m
.12566 .87584 L
s
% Start of user PostScript
0.165347 2.8109 0.389457 3.25786 MAarrowhead1
% End of user PostScript
.06705 .80219 m
.12884 .91744 L
s
% Start of user PostScript
0.165347 2.97625 0.401592 3.41691 MAarrowhead1
% End of user PostScript
.06705 .84544 m
.13197 .95895 L
s
% Start of user PostScript
0.165347 3.14159 0.41355 3.57564 MAarrowhead1
% End of user PostScript
.1103 .02381 m
.1103 .15458 L
s
% Start of user PostScript
0.330694 0 0.330694 0.5 MAarrowhead1
% End of user PostScript
.1103 .06705 m
.11744 .19762 L
s
% Start of user PostScript
0.330694 0.165347 0.35802 0.6646 MAarrowhead1
% End of user PostScript
.1103 .1103 m
.12457 .24028 L
s
% Start of user PostScript
0.330694 0.330694 0.385264 0.827707 MAarrowhead1
% End of user PostScript
.1103 .15354 m
.13165 .28255 L
s
% Start of user PostScript
0.330694 0.496041 0.412345 0.989329 MAarrowhead1
% End of user PostScript
.1103 .19678 m
.13867 .32443 L
s
% Start of user PostScript
0.330694 0.661388 0.439183 1.14948 MAarrowhead1
% End of user PostScript
.1103 .24003 m
.1456 .36594 L
s
% Start of user PostScript
0.330694 0.826735 0.465696 1.30816 MAarrowhead1
% End of user PostScript
.1103 .28327 m
.15243 .40706 L
s
% Start of user PostScript
0.330694 0.992082 0.491805 1.46541 MAarrowhead1
% End of user PostScript
.1103 .32651 m
.15913 .44782 L
s
% Start of user PostScript
0.330694 1.15743 0.517433 1.62125 MAarrowhead1
% End of user PostScript
.1103 .36976 m
.16569 .48821 L
s
% Start of user PostScript
0.330694 1.32278 0.542502 1.7757 MAarrowhead1
% End of user PostScript
.1103 .413 m
.17208 .52825 L
s
% Start of user PostScript
0.330694 1.48812 0.566939 1.92879 MAarrowhead1
% End of user PostScript
.1103 .45624 m
.17829 .56794 L
s
% Start of user PostScript
0.330694 1.65347 0.590669 2.08057 MAarrowhead1
% End of user PostScript
.1103 .49949 m
.18429 .6073 L
s
% Start of user PostScript
0.330694 1.81882 0.613622 2.23107 MAarrowhead1
% End of user PostScript
.1103 .54273 m
.19007 .64634 L
s
% Start of user PostScript
0.330694 1.98416 0.63573 2.38034 MAarrowhead1
% End of user PostScript
.1103 .58597 m
.19562 .68507 L
s
% Start of user PostScript
0.330694 2.14951 0.656926 2.52842 MAarrowhead1
% End of user PostScript
.1103 .62922 m
.2009 .7235 L
s
% Start of user PostScript
0.330694 2.31486 0.677146 2.67537 MAarrowhead1
% End of user PostScript
.1103 .67246 m
.20592 .76165 L
s
% Start of user PostScript
0.330694 2.4802 0.696331 2.82125 MAarrowhead1
% End of user PostScript
.1103 .7157 m
.21065 .79954 L
s
% Start of user PostScript
0.330694 2.64555 0.714423 2.9661 MAarrowhead1
% End of user PostScript
.1103 .75895 m
.21509 .83717 L
s
% Start of user PostScript
0.330694 2.8109 0.731369 3.11 MAarrowhead1
% End of user PostScript
.1103 .80219 m
.2192 .87457 L
s
% Start of user PostScript
0.330694 2.97625 0.747116 3.253 MAarrowhead1
% End of user PostScript
.1103 .84544 m
.223 .91175 L
s
% Start of user PostScript
0.330694 3.14159 0.761619 3.39517 MAarrowhead1
% End of user PostScript
.15354 .02381 m
.15354 .15458 L
s
% Start of user PostScript
0.496041 0 0.496041 0.5 MAarrowhead1
% End of user PostScript
.15354 .06705 m
.16425 .19738 L
s
% Start of user PostScript
0.496041 0.165347 0.537004 0.663666 MAarrowhead1
% End of user PostScript
.15354 .1103 m
.17489 .23931 L
s
% Start of user PostScript
0.496041 0.330694 0.577692 0.823982 MAarrowhead1
% End of user PostScript
.15354 .15354 m
.18539 .28037 L
s
% Start of user PostScript
0.496041 0.496041 0.617832 0.980981 MAarrowhead1
% End of user PostScript
.15354 .19678 m
.19568 .32057 L
s
% Start of user PostScript
0.496041 0.661388 0.657152 1.13472 MAarrowhead1
% End of user PostScript
.15354 .24003 m
.20568 .35995 L
s
% Start of user PostScript
0.496041 0.826735 0.695389 1.28528 MAarrowhead1
% End of user PostScript
.15354 .28327 m
.21533 .39852 L
s
% Start of user PostScript
0.496041 0.992082 0.732286 1.43275 MAarrowhead1
% End of user PostScript
.15354 .32651 m
.22456 .43631 L
s
% Start of user PostScript
0.496041 1.15743 0.767594 1.57726 MAarrowhead1
% End of user PostScript
.15354 .36976 m
.23332 .47337 L
s
% Start of user PostScript
0.496041 1.32278 0.801077 1.71895 MAarrowhead1
% End of user PostScript
.15354 .413 m
.24154 .50973 L
s
% Start of user PostScript
0.496041 1.48812 0.832509 1.85797 MAarrowhead1
% End of user PostScript
.15354 .45624 m
.24917 .54544 L
s
% Start of user PostScript
0.496041 1.65347 0.861678 1.99451 MAarrowhead1
% End of user PostScript
.15354 .49949 m
.25615 .58055 L
s
% Start of user PostScript
0.496041 1.81882 0.88839 2.12876 MAarrowhead1
% End of user PostScript
.15354 .54273 m
.26245 .61511 L
s
% Start of user PostScript
0.496041 1.98416 0.912463 2.26092 MAarrowhead1
% End of user PostScript
.15354 .58597 m
.26801 .64919 L
s
% Start of user PostScript
0.496041 2.14951 0.933737 2.39122 MAarrowhead1
% End of user PostScript
.15354 .62922 m
.27281 .68284 L
s
% Start of user PostScript
0.496041 2.31486 0.952068 2.51989 MAarrowhead1
% End of user PostScript
.15354 .67246 m
.2768 .71613 L
s
% Start of user PostScript
0.496041 2.4802 0.967333 2.64719 MAarrowhead1
% End of user PostScript
.15354 .7157 m
.27996 .74913 L
s
% Start of user PostScript
0.496041 2.64555 0.979429 2.77336 MAarrowhead1
% End of user PostScript
.15354 .75895 m
.28227 .78191 L
s
% Start of user PostScript
0.496041 2.8109 0.988275 2.89868 MAarrowhead1
% End of user PostScript
.15354 .80219 m
.28372 .81453 L
s
% Start of user PostScript
0.496041 2.97625 0.993812 3.0234 MAarrowhead1
% End of user PostScript
.15354 .84544 m
.2843 .84706 L
s
% Start of user PostScript
0.496041 3.14159 0.996002 3.14781 MAarrowhead1
% End of user PostScript
.19678 .02381 m
.19678 .15458 L
s
% Start of user PostScript
0.661388 0 0.661388 0.5 MAarrowhead1
% End of user PostScript
.19678 .06705 m
.21106 .19704 L
s
% Start of user PostScript
0.661388 0.165347 0.715958 0.66236 MAarrowhead1
% End of user PostScript
.19678 .1103 m
.22516 .23795 L
s
% Start of user PostScript
0.661388 0.330694 0.769877 0.818782 MAarrowhead1
% End of user PostScript
.19678 .15354 m
.23892 .27733 L
s
% Start of user PostScript
0.661388 0.496041 0.822499 0.969373 MAarrowhead1
% End of user PostScript
.19678 .19678 m
.25218 .31524 L
s
% Start of user PostScript
0.661388 0.661388 0.873196 1.11431 MAarrowhead1
% End of user PostScript
.19678 .24003 m
.26477 .35173 L
s
% Start of user PostScript
0.661388 0.826735 0.921363 1.25383 MAarrowhead1
% End of user PostScript
.19678 .28327 m
.27656 .38688 L
s
% Start of user PostScript
0.661388 0.992082 0.966424 1.38826 MAarrowhead1
% End of user PostScript
.19678 .32651 m
.28739 .4208 L
s
% Start of user PostScript
0.661388 1.15743 1.00784 1.51794 MAarrowhead1
% End of user PostScript
.19678 .36976 m
.29714 .45359 L
s
% Start of user PostScript
0.661388 1.32278 1.04512 1.64332 MAarrowhead1
% End of user PostScript
.19678 .413 m
.30569 .48538 L
s
% Start of user PostScript
0.661388 1.48812 1.07781 1.76488 MAarrowhead1
% End of user PostScript
.19678 .45624 m
.31294 .51631 L
s
% Start of user PostScript
0.661388 1.65347 1.10553 1.88312 MAarrowhead1
% End of user PostScript
.19678 .49949 m
.3188 .54651 L
s
% Start of user PostScript
0.661388 1.81882 1.12794 1.99862 MAarrowhead1
% End of user PostScript
.19678 .54273 m
.3232 .57616 L
s
% Start of user PostScript
0.661388 1.98416 1.14478 2.11198 MAarrowhead1
% End of user PostScript
.19678 .58597 m
.3261 .6054 L
s
% Start of user PostScript
0.661388 2.14951 1.15584 2.2238 MAarrowhead1
% End of user PostScript
.19678 .62922 m
.32745 .63442 L
s
% Start of user PostScript
0.661388 2.31486 1.16099 2.33474 MAarrowhead1
% End of user PostScript
.19678 .67246 m
.32723 .66337 L
s
% Start of user PostScript
0.661388 2.4802 1.16018 2.44544 MAarrowhead1
% End of user PostScript
.19678 .7157 m
.32546 .69243 L
s
% Start of user PostScript
0.661388 2.64555 1.1534 2.55656 MAarrowhead1
% End of user PostScript
.19678 .75895 m
.32215 .72177 L
s
% Start of user PostScript
0.661388 2.8109 1.14075 2.66874 MAarrowhead1
% End of user PostScript
.19678 .80219 m
.31735 .75155 L
s
% Start of user PostScript
0.661388 2.97625 1.12237 2.78262 MAarrowhead1
% End of user PostScript
.19678 .84544 m
.3111 .78194 L
s
% Start of user PostScript
0.661388 3.14159 1.09849 2.89881 MAarrowhead1
% End of user PostScript
.24003 .02381 m
.24003 .15458 L
s
% Start of user PostScript
0.826735 0 0.826735 0.5 MAarrowhead1
% End of user PostScript
.24003 .06705 m
.25785 .1966 L
s
% Start of user PostScript
0.826735 0.165347 0.894871 0.660683 MAarrowhead1
% End of user PostScript
.24003 .1103 m
.27533 .23621 L
s
% Start of user PostScript
0.826735 0.330694 0.961736 0.812124 MAarrowhead1
% End of user PostScript
.24003 .15354 m
.29216 .27346 L
s
% Start of user PostScript
0.826735 0.496041 1.02608 0.954583 MAarrowhead1
% End of user PostScript
.24003 .19678 m
.30802 .30848 L
s
% Start of user PostScript
0.826735 0.661388 1.08671 1.08849 MAarrowhead1
% End of user PostScript
.24003 .24003 m
.32261 .34142 L
s
% Start of user PostScript
0.826735 0.826735 1.14249 1.21442 MAarrowhead1
% End of user PostScript
.24003 .28327 m
.33565 .37246 L
s
% Start of user PostScript
0.826735 0.992082 1.19237 1.33312 MAarrowhead1
% End of user PostScript
.24003 .32651 m
.34691 .40184 L
s
% Start of user PostScript
0.826735 1.15743 1.23544 1.44546 MAarrowhead1
% End of user PostScript
.24003 .36976 m
.35618 .42982 L
s
% Start of user PostScript
0.826735 1.32278 1.27087 1.55243 MAarrowhead1
% End of user PostScript
.24003 .413 m
.36328 .45667 L
s
% Start of user PostScript
0.826735 1.48812 1.29803 1.65511 MAarrowhead1
% End of user PostScript
.24003 .45624 m
.36809 .48271 L
s
% Start of user PostScript
0.826735 1.65347 1.31639 1.75467 MAarrowhead1
% End of user PostScript
.24003 .49949 m
.3705 .50826 L
s
% Start of user PostScript
0.826735 1.81882 1.32561 1.85235 MAarrowhead1
% End of user PostScript
.24003 .54273 m
.37048 .53364 L
s
% Start of user PostScript
0.826735 1.98416 1.32553 1.9494 MAarrowhead1
% End of user PostScript
.24003 .58597 m
.36802 .55919 L
s
% Start of user PostScript
0.826735 2.14951 1.31613 2.0471 MAarrowhead1
% End of user PostScript
.24003 .62922 m
.36318 .58524 L
s
% Start of user PostScript
0.826735 2.31486 1.29761 2.14671 MAarrowhead1
% End of user PostScript
.24003 .67246 m
.35603 .61211 L
s
% Start of user PostScript
0.826735 2.4802 1.27031 2.24946 MAarrowhead1
% End of user PostScript
.24003 .7157 m
.34673 .64011 L
s
% Start of user PostScript
0.826735 2.64555 1.23472 2.35651 MAarrowhead1
% End of user PostScript
.24003 .75895 m
.33543 .66952 L
s
% Start of user PostScript
0.826735 2.8109 1.19153 2.46896 MAarrowhead1
% End of user PostScript
.24003 .80219 m
.32236 .7006 L
s
% Start of user PostScript
0.826735 2.97625 1.14153 2.58778 MAarrowhead1
% End of user PostScript
.24003 .84544 m
.30774 .73357 L
s
% Start of user PostScript
0.826735 3.14159 1.08566 2.71386 MAarrowhead1
% End of user PostScript
.28327 .02381 m
.28327 .15458 L
s
% Start of user PostScript
0.992082 0 0.992082 0.5 MAarrowhead1
% End of user PostScript
.28327 .06705 m
.30462 .19606 L
s
% Start of user PostScript
0.992082 0.165347 1.07373 0.658635 MAarrowhead1
% End of user PostScript
.28327 .1103 m
.32541 .23409 L
s
% Start of user PostScript
0.992082 0.330694 1.15319 0.804026 MAarrowhead1
% End of user PostScript
.28327 .15354 m
.34506 .26879 L
s
% Start of user PostScript
0.992082 0.496041 1.22833 0.936709 MAarrowhead1
% End of user PostScript
.28327 .19678 m
.36305 .3004 L
s
% Start of user PostScript
0.992082 0.661388 1.29712 1.05756 MAarrowhead1
% End of user PostScript
.28327 .24003 m
.3789 .32922 L
s
% Start of user PostScript
0.992082 0.826735 1.35772 1.16778 MAarrowhead1
% End of user PostScript
.28327 .28327 m
.39218 .35565 L
s
% Start of user PostScript
0.992082 0.992082 1.4085 1.26884 MAarrowhead1
% End of user PostScript
.28327 .32651 m
.40254 .38014 L
s
% Start of user PostScript
0.992082 1.15743 1.44811 1.36246 MAarrowhead1
% End of user PostScript
.28327 .36976 m
.40969 .40318 L
s
% Start of user PostScript
0.992082 1.32278 1.47547 1.45059 MAarrowhead1
% End of user PostScript
.28327 .413 m
.41345 .42533 L
s
% Start of user PostScript
0.992082 1.48812 1.48985 1.53528 MAarrowhead1
% End of user PostScript
.28327 .45624 m
.41372 .44715 L
s
% Start of user PostScript
0.992082 1.65347 1.49087 1.61871 MAarrowhead1
% End of user PostScript
.28327 .49949 m
.41048 .46922 L
s
% Start of user PostScript
0.992082 1.81882 1.4785 1.70307 MAarrowhead1
% End of user PostScript
.28327 .54273 m
.40383 .49209 L
s
% Start of user PostScript
0.992082 1.98416 1.45307 1.79053 MAarrowhead1
% End of user PostScript
.28327 .58597 m
.39394 .51633 L
s
% Start of user PostScript
0.992082 2.14951 1.41526 1.8832 MAarrowhead1
% End of user PostScript
.28327 .62922 m
.38108 .54243 L
s
% Start of user PostScript
0.992082 2.31486 1.36609 1.98302 MAarrowhead1
% End of user PostScript
.28327 .67246 m
.3656 .57087 L
s
% Start of user PostScript
0.992082 2.4802 1.30688 2.09174 MAarrowhead1
% End of user PostScript
.28327 .7157 m
.3479 .60203 L
s
% Start of user PostScript
0.992082 2.64555 1.23921 2.2109 MAarrowhead1
% End of user PostScript
.28327 .75895 m
.32847 .63624 L
s
% Start of user PostScript
0.992082 2.8109 1.16492 2.34172 MAarrowhead1
% End of user PostScript
.28327 .80219 m
.30783 .67375 L
s
% Start of user PostScript
0.992082 2.97625 1.08598 2.48514 MAarrowhead1
% End of user PostScript
.28327 .84544 m
.28652 .71471 L
s
% Start of user PostScript
0.992082 3.14159 1.00452 2.64175 MAarrowhead1
% End of user PostScript
.32651 .02381 m
.32651 .15458 L
s
% Start of user PostScript
1.15743 0 1.15743 0.5 MAarrowhead1
% End of user PostScript
.32651 .06705 m
.35139 .19543 L
s
% Start of user PostScript
1.15743 0.165347 1.25253 0.656219 MAarrowhead1
% End of user PostScript
.32651 .1103 m
.37535 .2316 L
s
% Start of user PostScript
1.15743 0.330694 1.34417 0.794514 MAarrowhead1
% End of user PostScript
.32651 .15354 m
.39753 .26334 L
s
% Start of user PostScript
1.15743 0.496041 1.42898 0.915873 MAarrowhead1
% End of user PostScript
.32651 .19678 m
.41712 .29107 L
s
% Start of user PostScript
1.15743 0.661388 1.50388 1.0219 MAarrowhead1
% End of user PostScript
.32651 .24003 m
.4334 .31536 L
s
% Start of user PostScript
1.15743 0.826735 1.56613 1.11477 MAarrowhead1
% End of user PostScript
.32651 .28327 m
.44578 .33689 L
s
% Start of user PostScript
1.15743 0.992082 1.61346 1.19712 MAarrowhead1
% End of user PostScript
.32651 .32651 m
.4538 .35647 L
s
% Start of user PostScript
1.15743 1.15743 1.64413 1.27198 MAarrowhead1
% End of user PostScript
.32651 .36976 m
.45718 .37496 L
s
% Start of user PostScript
1.15743 1.32278 1.65703 1.34266 MAarrowhead1
% End of user PostScript
.32651 .413 m
.45578 .39325 L
s
% Start of user PostScript
1.15743 1.48812 1.65169 1.41261 MAarrowhead1
% End of user PostScript
.32651 .45624 m
.44966 .41227 L
s
% Start of user PostScript
1.15743 1.65347 1.62831 1.48532 MAarrowhead1
% End of user PostScript
.32651 .49949 m
.43905 .43289 L
s
% Start of user PostScript
1.15743 1.81882 1.58773 1.56417 MAarrowhead1
% End of user PostScript
.32651 .54273 m
.42433 .45594 L
s
% Start of user PostScript
1.15743 1.98416 1.53144 1.65232 MAarrowhead1
% End of user PostScript
.32651 .58597 m
.40603 .48217 L
s
% Start of user PostScript
1.15743 2.14951 1.46149 1.75259 MAarrowhead1
% End of user PostScript
.32651 .62922 m
.38484 .51218 L
s
% Start of user PostScript
1.15743 2.31486 1.38044 1.86735 MAarrowhead1
% End of user PostScript
.32651 .67246 m
.36151 .54647 L
s
% Start of user PostScript
1.15743 2.4802 1.29124 1.99844 MAarrowhead1
% End of user PostScript
.32651 .7157 m
.33691 .58535 L
s
% Start of user PostScript
1.15743 2.64555 1.19716 2.14713 MAarrowhead1
% End of user PostScript
.32651 .75895 m
.31192 .629 L
s
% Start of user PostScript
1.15743 2.8109 1.10163 2.31402 MAarrowhead1
% End of user PostScript
.32651 .80219 m
.28747 .67739 L
s
% Start of user PostScript
1.15743 2.97625 1.00814 2.49905 MAarrowhead1
% End of user PostScript
.32651 .84544 m
.26444 .73034 L
s
% Start of user PostScript
1.15743 3.14159 0.920099 2.70151 MAarrowhead1
% End of user PostScript
.36976 .02381 m
.36976 .15458 L
s
% Start of user PostScript
1.32278 0 1.32278 0.5 MAarrowhead1
% End of user PostScript
.36976 .06705 m
.39813 .1947 L
s
% Start of user PostScript
1.32278 0.165347 1.43126 0.653435 MAarrowhead1
% End of user PostScript
.36976 .1103 m
.42515 .22875 L
s
% Start of user PostScript
1.32278 0.330694 1.53458 0.783615 MAarrowhead1
% End of user PostScript
.36976 .15354 m
.44953 .25715 L
s
% Start of user PostScript
1.32278 0.496041 1.62781 0.892214 MAarrowhead1
% End of user PostScript
.36976 .19678 m
.47011 .28062 L
s
% Start of user PostScript
1.32278 0.661388 1.70651 0.981937 MAarrowhead1
% End of user PostScript
.36976 .24003 m
.48591 .30009 L
s
% Start of user PostScript
1.32278 0.826735 1.76692 1.05639 MAarrowhead1
% End of user PostScript
.36976 .28327 m
.49618 .3167 L
s
% Start of user PostScript
1.32278 0.992082 1.80616 1.11989 MAarrowhead1
% End of user PostScript
.36976 .32651 m
.50042 .33171 L
s
% Start of user PostScript
1.32278 1.15743 1.82238 1.17731 MAarrowhead1
% End of user PostScript
.36976 .36976 m
.49843 .34648 L
s
% Start of user PostScript
1.32278 1.32278 1.81479 1.23378 MAarrowhead1
% End of user PostScript
.36976 .413 m
.49032 .36236 L
s
% Start of user PostScript
1.32278 1.48812 1.78376 1.29449 MAarrowhead1
% End of user PostScript
.36976 .45624 m
.47646 .38065 L
s
% Start of user PostScript
1.32278 1.65347 1.73077 1.36443 MAarrowhead1
% End of user PostScript
.36976 .49949 m
.45752 .40254 L
s
% Start of user PostScript
1.32278 1.81882 1.65833 1.44814 MAarrowhead1
% End of user PostScript
.36976 .54273 m
.43439 .42905 L
s
% Start of user PostScript
1.32278 1.98416 1.56991 1.54951 MAarrowhead1
% End of user PostScript
.36976 .58597 m
.40818 .46098 L
s
% Start of user PostScript
1.32278 2.14951 1.46971 1.67159 MAarrowhead1
% End of user PostScript
.36976 .62922 m
.38015 .49887 L
s
% Start of user PostScript
1.32278 2.31486 1.36251 1.81644 MAarrowhead1
% End of user PostScript
.36976 .67246 m
.35162 .54296 L
s
% Start of user PostScript
1.32278 2.4802 1.25342 1.98504 MAarrowhead1
% End of user PostScript
.36976 .7157 m
.32395 .59322 L
s
% Start of user PostScript
1.32278 2.64555 1.14763 2.17723 MAarrowhead1
% End of user PostScript
.36976 .75895 m
.29847 .64932 L
s
% Start of user PostScript
1.32278 2.8109 1.05019 2.39174 MAarrowhead1
% End of user PostScript
.36976 .80219 m
.27638 .71065 L
s
% Start of user PostScript
1.32278 2.97625 0.965734 2.62622 MAarrowhead1
% End of user PostScript
.36976 .84544 m
.25874 .77633 L
s
% Start of user PostScript
1.32278 3.14159 0.898292 2.87737 MAarrowhead1
% End of user PostScript
.413 .02381 m
.413 .15458 L
s
% Start of user PostScript
1.48812 0 1.48812 0.5 MAarrowhead1
% End of user PostScript
.413 .06705 m
.44485 .19388 L
s
% Start of user PostScript
1.48812 0.165347 1.60991 0.650287 MAarrowhead1
% End of user PostScript
.413 .1103 m
.47479 .22555 L
s
% Start of user PostScript
1.48812 0.330694 1.72437 0.771362 MAarrowhead1
% End of user PostScript
.413 .15354 m
.501 .25027 L
s
% Start of user PostScript
1.48812 0.496041 1.82459 0.865892 MAarrowhead1
% End of user PostScript
.413 .19678 m
.52191 .26916 L
s
% Start of user PostScript
1.48812 0.661388 1.90454 0.938142 MAarrowhead1
% End of user PostScript
.413 .24003 m
.53626 .2837 L
s
% Start of user PostScript
1.48812 0.826735 1.95941 0.99372 MAarrowhead1
% End of user PostScript
.413 .28327 m
.54318 .2956 L
s
% Start of user PostScript
1.48812 0.992082 1.98589 1.03924 MAarrowhead1
% End of user PostScript
.413 .32651 m
.54227 .30677 L
s
% Start of user PostScript
1.48812 1.15743 1.98239 1.08192 MAarrowhead1
% End of user PostScript
.413 .36976 m
.53356 .31912 L
s
% Start of user PostScript
1.48812 1.32278 1.94911 1.12915 MAarrowhead1
% End of user PostScript
.413 .413 m
.5176 .33452 L
s
% Start of user PostScript
1.48812 1.48812 1.88806 1.18804 MAarrowhead1
% End of user PostScript
.413 .45624 m
.49533 .35465 L
s
% Start of user PostScript
1.48812 1.65347 1.80292 1.26501 MAarrowhead1
% End of user PostScript
.413 .49949 m
.4681 .3809 L
s
% Start of user PostScript
1.48812 1.81882 1.69881 1.36538 MAarrowhead1
% End of user PostScript
.413 .54273 m
.43756 .41429 L
s
% Start of user PostScript
1.48812 1.98416 1.58202 1.49306 MAarrowhead1
% End of user PostScript
.413 .58597 m
.40553 .45542 L
s
% Start of user PostScript
1.48812 2.14951 1.45957 1.65033 MAarrowhead1
% End of user PostScript
.413 .62922 m
.37396 .50442 L
s
% Start of user PostScript
1.48812 2.31486 1.33883 1.83766 MAarrowhead1
% End of user PostScript
.413 .67246 m
.34473 .56093 L
s
% Start of user PostScript
1.48812 2.4802 1.2271 2.05375 MAarrowhead1
% End of user PostScript
.413 .7157 m
.31962 .62416 L
s
% Start of user PostScript
1.48812 2.64555 1.13108 2.29552 MAarrowhead1
% End of user PostScript
.413 .75895 m
.30014 .69291 L
s
% Start of user PostScript
1.48812 2.8109 1.05657 2.55838 MAarrowhead1
% End of user PostScript
.413 .80219 m
.28745 .76563 L
s
% Start of user PostScript
1.48812 2.97625 1.00806 2.83645 MAarrowhead1
% End of user PostScript
.413 .84544 m
.28233 .84056 L
s
% Start of user PostScript
1.48812 3.14159 0.988471 3.12294 MAarrowhead1
% End of user PostScript
.45624 .02381 m
.45624 .15458 L
s
% Start of user PostScript
1.65347 0 1.65347 0.5 MAarrowhead1
% End of user PostScript
.45624 .06705 m
.49155 .19296 L
s
% Start of user PostScript
1.65347 0.165347 1.78847 0.646777 MAarrowhead1
% End of user PostScript
.45624 .1103 m
.52424 .222 L
s
% Start of user PostScript
1.65347 0.330694 1.91344 0.757792 MAarrowhead1
% End of user PostScript
.45624 .15354 m
.55187 .24273 L
s
% Start of user PostScript
1.65347 0.496041 2.01911 0.837083 MAarrowhead1
% End of user PostScript
.45624 .19678 m
.5724 .25684 L
s
% Start of user PostScript
1.65347 0.661388 2.09761 0.89104 MAarrowhead1
% End of user PostScript
.45624 .24003 m
.5843 .26649 L
s
% Start of user PostScript
1.65347 0.826735 2.14312 0.927938 MAarrowhead1
% End of user PostScript
.45624 .28327 m
.58669 .27418 L
s
% Start of user PostScript
1.65347 0.992082 2.15226 0.957319 MAarrowhead1
% End of user PostScript
.45624 .32651 m
.57939 .28254 L
s
% Start of user PostScript
1.65347 1.15743 2.12435 0.989283 MAarrowhead1
% End of user PostScript
.45624 .36976 m
.56295 .29416 L
s
% Start of user PostScript
1.65347 1.32278 2.06146 1.03374 MAarrowhead1
% End of user PostScript
.45624 .413 m
.53857 .31141 L
s
% Start of user PostScript
1.65347 1.48812 1.96827 1.09966 MAarrowhead1
% End of user PostScript
.45624 .45624 m
.50808 .33619 L
s
% Start of user PostScript
1.65347 1.65347 1.85169 1.19444 MAarrowhead1
% End of user PostScript
.45624 .49949 m
.47374 .3699 L
s
% Start of user PostScript
1.65347 1.81882 1.72039 1.32331 MAarrowhead1
% End of user PostScript
.45624 .54273 m
.4381 .41323 L
s
% Start of user PostScript
1.65347 1.98416 1.58411 1.489 MAarrowhead1
% End of user PostScript
.45624 .58597 m
.40381 .46618 L
s
% Start of user PostScript
1.65347 2.14951 1.45299 1.69146 MAarrowhead1
% End of user PostScript
.45624 .62922 m
.37342 .52803 L
s
% Start of user PostScript
1.65347 2.31486 1.33676 1.92795 MAarrowhead1
% End of user PostScript
.45624 .67246 m
.34917 .5974 L
s
% Start of user PostScript
1.65347 2.4802 1.24406 2.19318 MAarrowhead1
% End of user PostScript
.45624 .7157 m
.33288 .67234 L
s
% Start of user PostScript
1.65347 2.64555 1.18177 2.47973 MAarrowhead1
% End of user PostScript
.45624 .75895 m
.32575 .7505 L
s
% Start of user PostScript
1.65347 2.8109 1.15451 2.77859 MAarrowhead1
% End of user PostScript
.45624 .80219 m
.32832 .82929 L
s
% Start of user PostScript
1.65347 2.97625 1.16432 3.07986 MAarrowhead1
% End of user PostScript
.45624 .84544 m
.34038 .90607 L
s
% Start of user PostScript
1.65347 3.14159 1.21047 3.37343 MAarrowhead1
% End of user PostScript
.49949 .02381 m
.49949 .15458 L
s
% Start of user PostScript
1.81882 0 1.81882 0.5 MAarrowhead1
% End of user PostScript
.49949 .06705 m
.53822 .19195 L
s
% Start of user PostScript
1.81882 0.165347 1.96693 0.642906 MAarrowhead1
% End of user PostScript
.49949 .1103 m
.57348 .21811 L
s
% Start of user PostScript
1.81882 0.330694 2.10175 0.742946 MAarrowhead1
% End of user PostScript
.49949 .15354 m
.6021 .2346 L
s
% Start of user PostScript
1.81882 0.496041 2.21117 0.805981 MAarrowhead1
% End of user PostScript
.49949 .19678 m
.62151 .24381 L
s
% Start of user PostScript
1.81882 0.661388 2.28537 0.841194 MAarrowhead1
% End of user PostScript
.49949 .24003 m
.62996 .2488 L
s
% Start of user PostScript
1.81882 0.826735 2.31769 0.860268 MAarrowhead1
% End of user PostScript
.49949 .28327 m
.6267 .253 L
s
% Start of user PostScript
1.81882 0.992082 2.30523 0.876332 MAarrowhead1
% End of user PostScript
.49949 .32651 m
.61202 .25992 L
s
% Start of user PostScript
1.81882 1.15743 2.24912 0.902786 MAarrowhead1
% End of user PostScript
.49949 .36976 m
.58725 .27281 L
s
% Start of user PostScript
1.81882 1.32278 2.15437 0.952097 MAarrowhead1
% End of user PostScript
.49949 .413 m
.55459 .29441 L
s
% Start of user PostScript
1.81882 1.48812 2.02951 1.03468 MAarrowhead1
% End of user PostScript
.49949 .45624 m
.51699 .32665 L
s
% Start of user PostScript
1.81882 1.65347 1.88573 1.15797 MAarrowhead1
% End of user PostScript
.49949 .49949 m
.47782 .37053 L
s
% Start of user PostScript
1.81882 1.81882 1.73595 1.32573 MAarrowhead1
% End of user PostScript
.49949 .54273 m
.44059 .42598 L
s
% Start of user PostScript
1.81882 1.98416 1.59361 1.53776 MAarrowhead1
% End of user PostScript
.49949 .58597 m
.40865 .49191 L
s
% Start of user PostScript
1.81882 2.14951 1.47148 1.78985 MAarrowhead1
% End of user PostScript
.49949 .62922 m
.38486 .56629 L
s
% Start of user PostScript
1.81882 2.31486 1.38053 2.07423 MAarrowhead1
% End of user PostScript
.49949 .67246 m
.37136 .64631 L
s
% Start of user PostScript
1.81882 2.4802 1.32892 2.38021 MAarrowhead1
% End of user PostScript
.49949 .7157 m
.36937 .72868 L
s
% Start of user PostScript
1.81882 2.64555 1.32128 2.69516 MAarrowhead1
% End of user PostScript
.49949 .75895 m
.37905 .80989 L
s
% Start of user PostScript
1.81882 2.8109 1.35831 3.00566 MAarrowhead1
% End of user PostScript
.49949 .80219 m
.39954 .88652 L
s
% Start of user PostScript
1.81882 2.97625 1.43667 3.29868 MAarrowhead1
% End of user PostScript
.49949 .84544 m
.42901 .95558 L
s
% Start of user PostScript
1.81882 3.14159 1.54934 3.56276 MAarrowhead1
% End of user PostScript
.54273 .02381 m
.54273 .15458 L
s
% Start of user PostScript
1.98416 0 1.98416 0.5 MAarrowhead1
% End of user PostScript
.54273 .06705 m
.58487 .19084 L
s
% Start of user PostScript
1.98416 0.165347 2.14527 0.638679 MAarrowhead1
% End of user PostScript
.54273 .1103 m
.62251 .21391 L
s
% Start of user PostScript
1.98416 0.330694 2.2892 0.726867 MAarrowhead1
% End of user PostScript
.54273 .15354 m
.65164 .22592 L
s
% Start of user PostScript
1.98416 0.496041 2.40059 0.772795 MAarrowhead1
% End of user PostScript
.54273 .19678 m
.66915 .23021 L
s
% Start of user PostScript
1.98416 0.661388 2.46755 0.789201 MAarrowhead1
% End of user PostScript
.54273 .24003 m
.67318 .23094 L
s
% Start of user PostScript
1.98416 0.826735 2.48295 0.791972 MAarrowhead1
% End of user PostScript
.54273 .28327 m
.66329 .23263 L
s
% Start of user PostScript
1.98416 0.992082 2.44515 0.798452 MAarrowhead1
% End of user PostScript
.54273 .32651 m
.64055 .23973 L
s
% Start of user PostScript
1.98416 1.15743 2.35817 0.825587 MAarrowhead1
% End of user PostScript
.54273 .36976 m
.60736 .25608 L
s
% Start of user PostScript
1.98416 1.32278 2.2313 0.88812 MAarrowhead1
% End of user PostScript
.54273 .413 m
.56729 .28456 L
s
% Start of user PostScript
1.98416 1.48812 2.07806 0.997018 MAarrowhead1
% End of user PostScript
.54273 .45624 m
.52459 .32674 L
s
% Start of user PostScript
1.98416 1.65347 1.91481 1.1583 MAarrowhead1
% End of user PostScript
.54273 .49949 m
.48383 .38274 L
s
% Start of user PostScript
1.98416 1.81882 1.75895 1.37241 MAarrowhead1
% End of user PostScript
.54273 .54273 m
.44935 .45119 L
s
% Start of user PostScript
1.98416 1.98416 1.62712 1.63413 MAarrowhead1
% End of user PostScript
.54273 .58597 m
.42484 .5294 L
s
% Start of user PostScript
1.98416 2.14951 1.53338 1.9332 MAarrowhead1
% End of user PostScript
.54273 .62922 m
.4129 .61365 L
s
% Start of user PostScript
1.98416 2.31486 1.48772 2.25533 MAarrowhead1
% End of user PostScript
.54273 .67246 m
.4148 .69956 L
s
% Start of user PostScript
1.98416 2.4802 1.49502 2.58382 MAarrowhead1
% End of user PostScript
.54273 .7157 m
.43036 .78258 L
s
% Start of user PostScript
1.98416 2.64555 1.55449 2.90125 MAarrowhead1
% End of user PostScript
.54273 .75895 m
.4579 .85846 L
s
% Start of user PostScript
1.98416 2.8109 1.6598 3.19141 MAarrowhead1
% End of user PostScript
.54273 .80219 m
.49449 .92373 L
s
% Start of user PostScript
1.98416 2.97625 1.79971 3.44098 MAarrowhead1
% End of user PostScript
.54273 .84544 m
.53623 .97604 L
s
% Start of user PostScript
1.98416 3.14159 1.9593 3.64097 MAarrowhead1
% End of user PostScript
.58597 .02381 m
.58597 .15458 L
s
% Start of user PostScript
2.14951 0 2.14951 0.5 MAarrowhead1
% End of user PostScript
.58597 .06705 m
.63148 .18965 L
s
% Start of user PostScript
2.14951 0.165347 2.3235 0.634098 MAarrowhead1
% End of user PostScript
.58597 .1103 m
.67129 .20939 L
s
% Start of user PostScript
2.14951 0.330694 2.47574 0.709604 MAarrowhead1
% End of user PostScript
.58597 .15354 m
.70045 .21675 L
s
% Start of user PostScript
2.14951 0.496041 2.58721 0.737748 MAarrowhead1
% End of user PostScript
.58597 .19678 m
.71529 .21621 L
s
% Start of user PostScript
2.14951 0.661388 2.64396 0.73568 MAarrowhead1
% End of user PostScript
.58597 .24003 m
.71397 .21324 L
s
% Start of user PostScript
2.14951 0.826735 2.63891 0.724325 MAarrowhead1
% End of user PostScript
.58597 .28327 m
.69665 .21362 L
s
% Start of user PostScript
2.14951 0.992082 2.57269 0.725771 MAarrowhead1
% End of user PostScript
.58597 .32651 m
.6655 .22271 L
s
% Start of user PostScript
2.14951 1.15743 2.45357 0.760505 MAarrowhead1
% End of user PostScript
.58597 .36976 m
.6244 .24477 L
s
% Start of user PostScript
2.14951 1.32278 2.29645 0.844853 MAarrowhead1
% End of user PostScript
.58597 .413 m
.57851 .28245 L
s
% Start of user PostScript
2.14951 1.48812 2.12095 0.988939 MAarrowhead1
% End of user PostScript
.58597 .45624 m
.53354 .33645 L
s
% Start of user PostScript
2.14951 1.65347 1.94903 1.19542 MAarrowhead1
% End of user PostScript
.58597 .49949 m
.49513 .40543 L
s
% Start of user PostScript
2.14951 1.81882 1.80217 1.45916 MAarrowhead1
% End of user PostScript
.58597 .54273 m
.46808 .48616 L
s
% Start of user PostScript
2.14951 1.98416 1.69872 1.76785 MAarrowhead1
% End of user PostScript
.58597 .58597 m
.45576 .57396 L
s
% Start of user PostScript
2.14951 2.14951 1.65162 2.10358 MAarrowhead1
% End of user PostScript
.58597 .62922 m
.45972 .66327 L
s
% Start of user PostScript
2.14951 2.31486 1.66676 2.44505 MAarrowhead1
% End of user PostScript
.58597 .67246 m
.47946 .74832 L
s
% Start of user PostScript
2.14951 2.4802 1.74223 2.77025 MAarrowhead1
% End of user PostScript
.58597 .7157 m
.51251 .82388 L
s
% Start of user PostScript
2.14951 2.64555 1.86862 3.05919 MAarrowhead1
% End of user PostScript
.58597 .75895 m
.55475 .88593 L
s
% Start of user PostScript
2.14951 2.8109 2.03011 3.29643 MAarrowhead1
% End of user PostScript
.58597 .80219 m
.60089 .9321 L
s
% Start of user PostScript
2.14951 2.97625 2.20653 3.47298 MAarrowhead1
% End of user PostScript
.58597 .84544 m
.64516 .96204 L
s
% Start of user PostScript
2.14951 3.14159 2.37582 3.58744 MAarrowhead1
% End of user PostScript
.62922 .02381 m
.62922 .15458 L
s
% Start of user PostScript
2.31486 0 2.31486 0.5 MAarrowhead1
% End of user PostScript
.62922 .06705 m
.67806 .18836 L
s
% Start of user PostScript
2.31486 0.165347 2.5016 0.629167 MAarrowhead1
% End of user PostScript
.62922 .1103 m
.71983 .20458 L
s
% Start of user PostScript
2.31486 0.330694 2.66131 0.691209 MAarrowhead1
% End of user PostScript
.62922 .15354 m
.74848 .20716 L
s
% Start of user PostScript
2.31486 0.496041 2.77088 0.701077 MAarrowhead1
% End of user PostScript
.62922 .19678 m
.75988 .20198 L
s
% Start of user PostScript
2.31486 0.661388 2.81446 0.681271 MAarrowhead1
% End of user PostScript
.62922 .24003 m
.75237 .19605 L
s
% Start of user PostScript
2.31486 0.826735 2.78574 0.658589 MAarrowhead1
% End of user PostScript
.62922 .28327 m
.72703 .19648 L
s
% Start of user PostScript
2.31486 0.992082 2.68886 0.66024 MAarrowhead1
% End of user PostScript
.62922 .32651 m
.68754 .20948 L
s
% Start of user PostScript
2.31486 1.15743 2.53787 0.709916 MAarrowhead1
% End of user PostScript
.62922 .36976 m
.63961 .23941 L
s
% Start of user PostScript
2.31486 1.32278 2.35459 0.824357 MAarrowhead1
% End of user PostScript
.62922 .413 m
.59017 .2882 L
s
% Start of user PostScript
2.31486 1.48812 2.16557 1.01093 MAarrowhead1
% End of user PostScript
.62922 .45624 m
.54639 .35506 L
s
% Start of user PostScript
2.31486 1.65347 1.99815 1.26656 MAarrowhead1
% End of user PostScript
.62922 .49949 m
.51459 .43656 L
s
% Start of user PostScript
2.31486 1.81882 1.87657 1.57819 MAarrowhead1
% End of user PostScript
.62922 .54273 m
.49938 .52716 L
s
% Start of user PostScript
2.31486 1.98416 1.81841 1.92464 MAarrowhead1
% End of user PostScript
.62922 .58597 m
.50296 .62002 L
s
% Start of user PostScript
2.31486 2.14951 1.83211 2.2797 MAarrowhead1
% End of user PostScript
.62922 .62922 m
.52482 .70796 L
s
% Start of user PostScript
2.31486 2.31486 1.91566 2.61593 MAarrowhead1
% End of user PostScript
.62922 .67246 m
.56178 .78449 L
s
% Start of user PostScript
2.31486 2.4802 2.05699 2.90858 MAarrowhead1
% End of user PostScript
.62922 .7157 m
.6085 .84482 L
s
% Start of user PostScript
2.31486 2.64555 2.23564 3.13924 MAarrowhead1
% End of user PostScript
.62922 .75895 m
.65822 .88646 L
s
% Start of user PostScript
2.31486 2.8109 2.42575 3.29845 MAarrowhead1
% End of user PostScript
.62922 .80219 m
.70374 .90964 L
s
% Start of user PostScript
2.31486 2.97625 2.59981 3.3871 MAarrowhead1
% End of user PostScript
.62922 .84544 m
.73848 .91728 L
s
% Start of user PostScript
2.31486 3.14159 2.73264 3.41629 MAarrowhead1
% End of user PostScript
.67246 .02381 m
.67246 .15458 L
s
% Start of user PostScript
2.4802 0 2.4802 0.5 MAarrowhead1
% End of user PostScript
.67246 .06705 m
.7246 .18698 L
s
% Start of user PostScript
2.4802 0.165347 2.67955 0.623889 MAarrowhead1
% End of user PostScript
.67246 .1103 m
.76809 .19949 L
s
% Start of user PostScript
2.4802 0.330694 2.84584 0.671736 MAarrowhead1
% End of user PostScript
.67246 .15354 m
.79572 .19721 L
s
% Start of user PostScript
2.4802 0.496041 2.9515 0.663026 MAarrowhead1
% End of user PostScript
.67246 .19678 m
.80291 .18769 L
s
% Start of user PostScript
2.4802 0.661388 2.97899 0.626625 MAarrowhead1
% End of user PostScript
.67246 .24003 m
.78847 .17968 L
s
% Start of user PostScript
2.4802 0.826735 2.92378 0.595989 MAarrowhead1
% End of user PostScript
.67246 .28327 m
.75479 .18167 L
s
% Start of user PostScript
2.4802 0.992082 2.795 0.603618 MAarrowhead1
% End of user PostScript
.67246 .32651 m
.70746 .20052 L
s
% Start of user PostScript
2.4802 1.15743 2.61402 0.675668 MAarrowhead1
% End of user PostScript
.67246 .36976 m
.65432 .24026 L
s
% Start of user PostScript
2.4802 1.32278 2.41085 0.82761 MAarrowhead1
% End of user PostScript
.67246 .413 m
.60419 .30147 L
s
% Start of user PostScript
2.4802 1.48812 2.21918 1.06167 MAarrowhead1
% End of user PostScript
.67246 .45624 m
.56539 .38118 L
s
% Start of user PostScript
2.4802 1.65347 2.0708 1.36644 MAarrowhead1
% End of user PostScript
.67246 .49949 m
.54434 .47334 L
s
% Start of user PostScript
2.4802 1.81882 1.99031 1.71882 MAarrowhead1
% End of user PostScript
.67246 .54273 m
.54453 .56983 L
s
% Start of user PostScript
2.4802 1.98416 1.99106 2.08778 MAarrowhead1
% End of user PostScript
.67246 .58597 m
.56595 .66183 L
s
% Start of user PostScript
2.4802 2.14951 2.07293 2.43956 MAarrowhead1
% End of user PostScript
.67246 .62922 m
.60502 .74125 L
s
% Start of user PostScript
2.4802 2.31486 2.22234 2.74323 MAarrowhead1
% End of user PostScript
.67246 .67246 m
.65528 .80209 L
s
% Start of user PostScript
2.4802 2.4802 2.41451 2.97587 MAarrowhead1
% End of user PostScript
.67246 .7157 m
.70839 .84144 L
s
% Start of user PostScript
2.4802 2.64555 2.61758 3.12631 MAarrowhead1
% End of user PostScript
.67246 .75895 m
.75554 .85993 L
s
% Start of user PostScript
2.4802 2.8109 2.79786 3.19702 MAarrowhead1
% End of user PostScript
.67246 .80219 m
.78891 .86168 L
s
% Start of user PostScript
2.4802 2.97625 2.92547 3.20371 MAarrowhead1
% End of user PostScript
.67246 .84544 m
.80297 .85356 L
s
% Start of user PostScript
2.4802 3.14159 2.97924 3.17267 MAarrowhead1
% End of user PostScript
.7157 .02381 m
.7157 .15458 L
s
% Start of user PostScript
2.64555 0 2.64555 0.5 MAarrowhead1
% End of user PostScript
.7157 .06705 m
.7711 .18551 L
s
% Start of user PostScript
2.64555 0.165347 2.85736 0.618268 MAarrowhead1
% End of user PostScript
.7157 .1103 m
.81606 .19413 L
s
% Start of user PostScript
2.64555 0.330694 3.02928 0.651243 MAarrowhead1
% End of user PostScript
.7157 .15354 m
.84213 .18697 L
s
% Start of user PostScript
2.64555 0.496041 3.12894 0.623854 MAarrowhead1
% End of user PostScript
.7157 .19678 m
.84438 .17351 L
s
% Start of user PostScript
2.64555 0.661388 3.13757 0.572395 MAarrowhead1
% End of user PostScript
.7157 .24003 m
.82241 .16443 L
s
% Start of user PostScript
2.64555 0.826735 3.05354 0.537695 MAarrowhead1
% End of user PostScript
.7157 .28327 m
.78034 .16959 L
s
% Start of user PostScript
2.64555 0.992082 2.89268 0.557426 MAarrowhead1
% End of user PostScript
.7157 .32651 m
.7261 .19616 L
s
% Start of user PostScript
2.64555 1.15743 2.68529 0.65901 MAarrowhead1
% End of user PostScript
.7157 .36976 m
.6699 .24728 L
s
% Start of user PostScript
2.64555 1.32278 2.47041 0.854455 MAarrowhead1
% End of user PostScript
.7157 .413 m
.62233 .32146 L
s
% Start of user PostScript
2.64555 1.48812 2.28851 1.13809 MAarrowhead1
% End of user PostScript
.7157 .45624 m
.59234 .41288 L
s
% Start of user PostScript
2.64555 1.65347 2.17385 1.48765 MAarrowhead1
% End of user PostScript
.7157 .49949 m
.58558 .51246 L
s
% Start of user PostScript
2.64555 1.81882 2.14802 1.86843 MAarrowhead1
% End of user PostScript
.7157 .54273 m
.60333 .60961 L
s
% Start of user PostScript
2.64555 1.98416 2.21588 2.23987 MAarrowhead1
% End of user PostScript
.7157 .58597 m
.64224 .69415 L
s
% Start of user PostScript
2.64555 2.14951 2.36466 2.56315 MAarrowhead1
% End of user PostScript
.7157 .62922 m
.69499 .75833 L
s
% Start of user PostScript
2.64555 2.31486 2.56633 2.80854 MAarrowhead1
% End of user PostScript
.7157 .67246 m
.75163 .79819 L
s
% Start of user PostScript
2.64555 2.4802 2.78292 2.96096 MAarrowhead1
% End of user PostScript
.7157 .7157 m
.80151 .81438 L
s
% Start of user PostScript
2.64555 2.64555 2.97365 3.02285 MAarrowhead1
% End of user PostScript
.7157 .75895 m
.83523 .81198 L
s
% Start of user PostScript
2.64555 2.8109 3.10258 3.01368 MAarrowhead1
% End of user PostScript
.7157 .80219 m
.84644 .7996 L
s
% Start of user PostScript
2.64555 2.97625 3.14545 2.96633 MAarrowhead1
% End of user PostScript
.7157 .84544 m
.83304 .7877 L
s
% Start of user PostScript
2.64555 3.14159 3.09418 2.92085 MAarrowhead1
% End of user PostScript
.75895 .02381 m
.75895 .15458 L
s
% Start of user PostScript
2.8109 0 2.8109 0.5 MAarrowhead1
% End of user PostScript
.75895 .06705 m
.81756 .18395 L
s
% Start of user PostScript
2.8109 0.165347 3.03501 0.612309 MAarrowhead1
% End of user PostScript
.75895 .1103 m
.86374 .18852 L
s
% Start of user PostScript
2.8109 0.330694 3.21157 0.629792 MAarrowhead1
% End of user PostScript
.75895 .15354 m
.88768 .1765 L
s
% Start of user PostScript
2.8109 0.496041 3.30313 0.583821 MAarrowhead1
% End of user PostScript
.75895 .19678 m
.88432 .1596 L
s
% Start of user PostScript
2.8109 0.661388 3.29026 0.519227 MAarrowhead1
% End of user PostScript
.75895 .24003 m
.85435 .1506 L
s
% Start of user PostScript
2.8109 0.826735 3.17569 0.484793 MAarrowhead1
% End of user PostScript
.75895 .28327 m
.80415 .16057 L
s
% Start of user PostScript
2.8109 0.992082 2.98373 0.522904 MAarrowhead1
% End of user PostScript
.75895 .32651 m
.74436 .19656 L
s
% Start of user PostScript
2.8109 1.15743 2.7551 0.660552 MAarrowhead1
% End of user PostScript
.75895 .36976 m
.68766 .26013 L
s
% Start of user PostScript
2.8109 1.32278 2.53831 0.903614 MAarrowhead1
% End of user PostScript
.75895 .413 m
.64608 .34696 L
s
% Start of user PostScript
2.8109 1.48812 2.37935 1.2356 MAarrowhead1
% End of user PostScript
.75895 .45624 m
.62846 .4478 L
s
% Start of user PostScript
2.8109 1.65347 2.31194 1.62117 MAarrowhead1
% End of user PostScript
.75895 .49949 m
.63851 .55042 L
s
% Start of user PostScript
2.8109 1.81882 2.35039 2.01358 MAarrowhead1
% End of user PostScript
.75895 .54273 m
.67412 .64225 L
s
% Start of user PostScript
2.8109 1.98416 2.48654 2.36468 MAarrowhead1
% End of user PostScript
.75895 .58597 m
.72772 .71296 L
s
% Start of user PostScript
2.8109 2.14951 2.6915 2.63505 MAarrowhead1
% End of user PostScript
.75895 .62922 m
.78795 .75673 L
s
% Start of user PostScript
2.8109 2.31486 2.92179 2.80241 MAarrowhead1
% End of user PostScript
.75895 .67246 m
.84203 .77345 L
s
% Start of user PostScript
2.8109 2.4802 3.12856 2.86633 MAarrowhead1
% End of user PostScript
.75895 .7157 m
.87848 .76874 L
s
% Start of user PostScript
2.8109 2.64555 3.26793 2.84834 MAarrowhead1
% End of user PostScript
.75895 .75895 m
.88957 .75278 L
s
% Start of user PostScript
2.8109 2.8109 3.31034 2.78732 MAarrowhead1
% End of user PostScript
.75895 .80219 m
.87295 .73813 L
s
% Start of user PostScript
2.8109 2.97625 3.2468 2.73131 MAarrowhead1
% End of user PostScript
.75895 .84544 m
.83214 .73707 L
s
% Start of user PostScript
2.8109 3.14159 3.09077 2.72726 MAarrowhead1
% End of user PostScript
.80219 .02381 m
.80219 .15458 L
s
% Start of user PostScript
2.97625 0 2.97625 0.5 MAarrowhead1
% End of user PostScript
.80219 .06705 m
.86398 .1823 L
s
% Start of user PostScript
2.97625 0.165347 3.21249 0.606015 MAarrowhead1
% End of user PostScript
.80219 .1103 m
.9111 .18268 L
s
% Start of user PostScript
2.97625 0.330694 3.39267 0.607448 MAarrowhead1
% End of user PostScript
.80219 .15354 m
.93237 .16587 L
s
% Start of user PostScript
2.97625 0.496041 3.47402 0.543199 MAarrowhead1
% End of user PostScript
.80219 .19678 m
.92275 .14614 L
s
% Start of user PostScript
2.97625 0.661388 3.43723 0.467758 MAarrowhead1
% End of user PostScript
.80219 .24003 m
.88452 .13843 L
s
% Start of user PostScript
2.97625 0.826735 3.29104 0.438271 MAarrowhead1
% End of user PostScript
.80219 .28327 m
.82675 .15483 L
s
% Start of user PostScript
2.97625 0.992082 3.07014 0.500977 MAarrowhead1
% End of user PostScript
.80219 .32651 m
.76315 .20171 L
s
% Start of user PostScript
2.97625 1.15743 2.82696 0.680236 MAarrowhead1
% End of user PostScript
.80219 .36976 m
.70881 .27821 L
s
% Start of user PostScript
2.97625 1.32278 2.6192 0.972745 MAarrowhead1
% End of user PostScript
.80219 .413 m
.67664 .37644 L
s
% Start of user PostScript
2.97625 1.48812 2.49619 1.34833 MAarrowhead1
% End of user PostScript
.80219 .45624 m
.67426 .48334 L
s
% Start of user PostScript
2.97625 1.65347 2.4871 1.75709 MAarrowhead1
% End of user PostScript
.80219 .49949 m
.70225 .58381 L
s
% Start of user PostScript
2.97625 1.81882 2.5941 2.14125 MAarrowhead1
% End of user PostScript
.80219 .54273 m
.75395 .66427 L
s
% Start of user PostScript
2.97625 1.98416 2.7918 2.4489 MAarrowhead1
% End of user PostScript
.80219 .58597 m
.8171 .71589 L
s
% Start of user PostScript
2.97625 2.14951 3.03326 2.64625 MAarrowhead1
% End of user PostScript
.80219 .62922 m
.87672 .73667 L
s
% Start of user PostScript
2.97625 2.31486 3.2612 2.72571 MAarrowhead1
% End of user PostScript
.80219 .67246 m
.91864 .73195 L
s
% Start of user PostScript
2.97625 2.4802 3.42151 2.70767 MAarrowhead1
% End of user PostScript
.80219 .7157 m
.93293 .71311 L
s
% Start of user PostScript
2.97625 2.64555 3.47615 2.63564 MAarrowhead1
% End of user PostScript
.80219 .75895 m
.91619 .69489 L
s
% Start of user PostScript
2.97625 2.8109 3.41214 2.56596 MAarrowhead1
% End of user PostScript
.80219 .80219 m
.8724 .69187 L
s
% Start of user PostScript
2.97625 2.97625 3.24469 2.55442 MAarrowhead1
% End of user PostScript
.80219 .84544 m
.81194 .71503 L
s
% Start of user PostScript
2.97625 3.14159 3.01352 2.64298 MAarrowhead1
% End of user PostScript
.84543 .02381 m
.84543 .15458 L
s
% Start of user PostScript
3.14159 0 3.14159 0.5 MAarrowhead1
% End of user PostScript
.84543 .06705 m
.91035 .18057 L
s
% Start of user PostScript
3.14159 0.165347 3.3898 0.599392 MAarrowhead1
% End of user PostScript
.84543 .1103 m
.95814 .17662 L
s
% Start of user PostScript
3.14159 0.330694 3.57252 0.584276 MAarrowhead1
% End of user PostScript
.84543 .15354 m
.97619 .15517 L
s
% Start of user PostScript
3.14159 0.496041 3.64155 0.50226 MAarrowhead1
% End of user PostScript
.84543 .19678 m
.95975 .13329 L
s
% Start of user PostScript
3.14159 0.661388 3.57869 0.418603 MAarrowhead1
% End of user PostScript
.84543 .24003 m
.91315 .12816 L
s
% Start of user PostScript
3.14159 0.826735 3.40051 0.398997 MAarrowhead1
% End of user PostScript
.84543 .28327 m
.84869 .15255 L
s
% Start of user PostScript
3.14159 0.992082 3.15403 0.492237 MAarrowhead1
% End of user PostScript
.84543 .32651 m
.78337 .21142 L
s
% Start of user PostScript
3.14159 1.15743 2.90426 0.717344 MAarrowhead1
% End of user PostScript
.84543 .36976 m
.73442 .30065 L
s
% Start of user PostScript
3.14159 1.32278 2.71711 1.05855 MAarrowhead1
% End of user PostScript
.84543 .413 m
.71476 .40812 L
s
% Start of user PostScript
3.14159 1.48812 2.64194 1.46947 MAarrowhead1
% End of user PostScript
.84543 .45624 m
.72958 .51688 L
s
% Start of user PostScript
3.14159 1.65347 2.69859 1.88531 MAarrowhead1
% End of user PostScript
.84543 .49949 m
.77496 .60964 L
s
% Start of user PostScript
3.14159 1.81882 2.87211 2.23998 MAarrowhead1
% End of user PostScript
.84543 .54273 m
.83893 .67333 L
s
% Start of user PostScript
3.14159 1.98416 3.11673 2.48355 MAarrowhead1
% End of user PostScript
.84543 .58597 m
.90462 .70258 L
s
% Start of user PostScript
3.14159 2.14951 3.3679 2.59536 MAarrowhead1
% End of user PostScript
.84543 .62922 m
.9547 .70106 L
s
% Start of user PostScript
3.14159 2.31486 3.55937 2.58956 MAarrowhead1
% End of user PostScript
.84543 .67246 m
.97595 .68059 L
s
% Start of user PostScript
3.14159 2.4802 3.64063 2.51128 MAarrowhead1
% End of user PostScript
.84543 .7157 m
.96277 .65797 L
s
% Start of user PostScript
3.14159 2.64555 3.59022 2.4248 MAarrowhead1
% End of user PostScript
.84543 .75895 m
.91863 .65059 L
s
% Start of user PostScript
3.14159 2.8109 3.42147 2.39657 MAarrowhead1
% End of user PostScript
.84543 .80219 m
.85518 .67179 L
s
% Start of user PostScript
3.14159 2.97625 3.17887 2.47764 MAarrowhead1
% End of user PostScript
.84543 .84544 m
.78917 .72739 L
s
% Start of user PostScript
3.14159 3.14159 2.92644 2.69025 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 1.00001 L
0 1.00001 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.39.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.39.1"]
}, Open  ]],

Cell[TextData[{
 "There are a variety of options to control the display of the vectors. Three \
of them control aspects of the scaling of the vector magnitudes. They are \
applied in the order ",
 StyleBox["ScaleFunction", "MR"],
 ", ",
 StyleBox["MaxArrowLength", "MR"],
 ", and ",
 StyleBox["ScaleFactor", "MR"],
 ". The ",
 StyleBox["ScaleFunction", "MR"],
 " can be a pure function that takes the magnitude of the vector, and returns \
the new magnitude for that vector. It can also be ",
 StyleBox["None", "MR"],
 ", specifying no rescaling by this option. If its application results in a \
nonnumeric value, the vector is set to zero magnitude. Next, ",
 StyleBox["MaxArrowLength", "MR"],
 " eliminates any vectors that are longer than the specified value after the \
application of the ",
 StyleBox["ScaleFunction", "MR"],
 ". It can also be set to ",
 StyleBox["None", "MR"],
 ", so no vectors are removed. Finally, the ",
 StyleBox["ScaleFactor", "MR"],
 " is applied. It linearly scales the remaining vectors so that the length of \
the longest one is equal to the specified value. If ",
 StyleBox["ScaleFactor", "MR"],
 " is set to ",
 StyleBox["Automatic", "MR"],
 ", then, in the field plotting functions, the longest vector will be sized \
to the grid increment, so the head of any given vector will not cover the \
base of any adjacent vector. If it is set to ",
 StyleBox["None", "MR"],
 ", no rescaling due to this option will occur. "
}], "Text",
 CellTags->{"S5.39.1", "1.11"}],

Cell[TextData[{
 "Thus, the ",
 StyleBox["ScaleFunction", "MR"],
 " option is best used to change the relative magnitudes of the vectors, \
while the ",
 StyleBox["ScaleFactor", "MR"],
 " is best used for linear scaling of the vectors when you know the desired \
length of the longest vector. If you want to perform linear rescaling of the \
vector lengths without specifying the longest vector, set ",
 StyleBox["ScaleFactor", "MR"],
 " to ",
 StyleBox["None", "MR"],
 ", as in the preceding example. ",
 StyleBox["MaxArrowLength", "MR"],
 " is best for removing unusual outliers, or filtering out all longer vectors \
so fine changes in the field can be better observed. "
}], "Text",
 CellTags->{"S5.39.1", "1.12"}],

Cell[TextData[{
 "All of the two\[Hyphen]dimensional vector plots also accept the same \
options as the ",
 StyleBox["Arrow", "MR"],
 " primitive; all the arrows in the plot will use these options. "
}], "Text",
 CellTags->{"S5.39.1", "1.13"}],

Cell[TextData[{
 "A complex\[Hyphen]valued function of a complex argument can be viewed as a \
vector field on the plane by using the real and complex parts of a complex \
number to give two coordinates. This is essentially the Polya representation \
of such a function. However, in the Polya representation the magnitude is \
scaled using ",
 StyleBox["ScaleFunction", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["(Log[#", "MR"],
 " ",
 StyleBox["+", "MR"],
 " ",
 StyleBox["1]&)", "MR"],
 " and the negative of the imaginary part is used. "
}], "Text",
 CellTags->{"S5.39.1", "1.14"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PlotPolyaField[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the complex\[Hyphen]valued function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" using the Polya representation",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.39.1"],

Cell["\<\
Plotting the Polya representation of a complex\[Hyphen]valued function. \
\>", "Caption",
 CellTags->"S5.39.1"],

Cell[TextData[{
 "The complex function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["z",
      "TI"], "4"], "-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " has zeros at the fourth roots of unity, so the magnitude of the vector \
field is small near these points."
}], "MathCaption",
 CellTags->{"S5.39.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
PlotPolyaField[(x + I y)^4 - 1,
                {x, 0, 3}, {y, 0, 3}]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.39.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .99588 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0314763 0.298703 0.0237115 0.298703 [
[ 0 0 0 0 ]
[ 1 .99588 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.0001 w
[ ] 0 setdash
.03148 .02371 m
.02381 .02371 L
s
% Start of user PostScript
0 0 -0.0256669 0 MAarrowhead1
% End of user PostScript
.03148 .08772 m
.02382 .08772 L
s
% Start of user PostScript
0 0.214286 -0.0256278 0.214286 MAarrowhead1
% End of user PostScript
.03148 .15173 m
.024 .15173 L
s
% Start of user PostScript
0 0.428571 -0.0250369 0.428571 MAarrowhead1
% End of user PostScript
.03148 .21573 m
.0248 .21573 L
s
% Start of user PostScript
0 0.642857 -0.0223615 0.642857 MAarrowhead1
% End of user PostScript
.03148 .27974 m
.02729 .27974 L
s
% Start of user PostScript
0 0.857143 -0.014019 0.857143 MAarrowhead1
% End of user PostScript
.03148 .34375 m
.03453 .34375 L
s
% Start of user PostScript
0 1.07143 0.0102191 1.07143 MAarrowhead1
% End of user PostScript
.03148 .40776 m
.0426 .40776 L
s
% Start of user PostScript
0 1.28571 0.0372242 1.28571 MAarrowhead1
% End of user PostScript
.03148 .47177 m
.04942 .47177 L
s
% Start of user PostScript
0 1.5 0.0600566 1.5 MAarrowhead1
% End of user PostScript
.03148 .53577 m
.05532 .53577 L
s
% Start of user PostScript
0 1.71429 0.079835 1.71429 MAarrowhead1
% End of user PostScript
.03148 .59978 m
.06053 .59978 L
s
% Start of user PostScript
0 1.92857 0.0972808 1.92857 MAarrowhead1
% End of user PostScript
.03148 .66379 m
.0652 .66379 L
s
% Start of user PostScript
0 2.14286 0.112887 2.14286 MAarrowhead1
% End of user PostScript
.03148 .7278 m
.06941 .7278 L
s
% Start of user PostScript
0 2.35714 0.127004 2.35714 MAarrowhead1
% End of user PostScript
.03148 .7918 m
.07326 .7918 L
s
% Start of user PostScript
0 2.57143 0.139892 2.57143 MAarrowhead1
% End of user PostScript
.03148 .85581 m
.0768 .85581 L
s
% Start of user PostScript
0 2.78571 0.151747 2.78571 MAarrowhead1
% End of user PostScript
.03148 .91982 m
.08008 .91982 L
s
% Start of user PostScript
0 3. 0.162724 3. MAarrowhead1
% End of user PostScript
.09548 .02371 m
.08783 .02371 L
s
% Start of user PostScript
0.214286 0 0.188658 0 MAarrowhead1
% End of user PostScript
.09548 .08772 m
.08777 .08772 L
s
% Start of user PostScript
0.214286 0.214286 0.188463 0.214286 MAarrowhead1
% End of user PostScript
.09548 .15173 m
.08774 .15211 L
s
% Start of user PostScript
0.214286 0.428571 0.188356 0.429865 MAarrowhead1
% End of user PostScript
.09548 .21573 m
.08819 .2173 L
s
% Start of user PostScript
0.214286 0.642857 0.189878 0.648108 MAarrowhead1
% End of user PostScript
.09548 .27974 m
.09017 .28382 L
s
% Start of user PostScript
0.214286 0.857143 0.196488 0.870778 MAarrowhead1
% End of user PostScript
.09548 .34375 m
.09551 .35148 L
s
% Start of user PostScript
0.214286 1.07143 0.214379 1.09732 MAarrowhead1
% End of user PostScript
.09548 .40776 m
.10299 .41814 L
s
% Start of user PostScript
0.214286 1.28571 0.239402 1.32049 MAarrowhead1
% End of user PostScript
.09548 .47177 m
.10998 .48369 L
s
% Start of user PostScript
0.214286 1.5 0.26283 1.53993 MAarrowhead1
% End of user PostScript
.09548 .53577 m
.11616 .54864 L
s
% Start of user PostScript
0.214286 1.71429 0.283512 1.75738 MAarrowhead1
% End of user PostScript
.09548 .59978 m
.12164 .61323 L
s
% Start of user PostScript
0.214286 1.92857 0.301849 1.97359 MAarrowhead1
% End of user PostScript
.09548 .66379 m
.12655 .67757 L
s
% Start of user PostScript
0.214286 2.14286 0.318277 2.18899 MAarrowhead1
% End of user PostScript
.09548 .7278 m
.13099 .74174 L
s
% Start of user PostScript
0.214286 2.35714 0.333138 2.40383 MAarrowhead1
% End of user PostScript
.09548 .7918 m
.13503 .8058 L
s
% Start of user PostScript
0.214286 2.57143 0.346692 2.61828 MAarrowhead1
% End of user PostScript
.09548 .85581 m
.13875 .86977 L
s
% Start of user PostScript
0.214286 2.78571 0.359144 2.83246 MAarrowhead1
% End of user PostScript
.09548 .91982 m
.14219 .93369 L
s
% Start of user PostScript
0.214286 3. 0.370654 3.04644 MAarrowhead1
% End of user PostScript
.15949 .02371 m
.15201 .02371 L
s
% Start of user PostScript
0.428571 0 0.403534 0 MAarrowhead1
% End of user PostScript
.15949 .08772 m
.15175 .08733 L
s
% Start of user PostScript
0.428571 0.214286 0.402641 0.212993 MAarrowhead1
% End of user PostScript
.15949 .15173 m
.1511 .15173 L
s
% Start of user PostScript
0.428571 0.428571 0.400487 0.428571 MAarrowhead1
% End of user PostScript
.15949 .21573 m
.15057 .21754 L
s
% Start of user PostScript
0.428571 0.642857 0.398718 0.648895 MAarrowhead1
% End of user PostScript
.15949 .27974 m
.1511 .28524 L
s
% Start of user PostScript
0.428571 0.857143 0.400466 0.875552 MAarrowhead1
% End of user PostScript
.15949 .34375 m
.15393 .35453 L
s
% Start of user PostScript
0.428571 1.07143 0.409963 1.10751 MAarrowhead1
% End of user PostScript
.15949 .40776 m
.15922 .42373 L
s
% Start of user PostScript
0.428571 1.28571 0.427657 1.33919 MAarrowhead1
% End of user PostScript
.15949 .47177 m
.16554 .49166 L
s
% Start of user PostScript
0.428571 1.5 0.448836 1.5666 MAarrowhead1
% End of user PostScript
.15949 .53577 m
.17184 .55833 L
s
% Start of user PostScript
0.428571 1.71429 0.469912 1.78982 MAarrowhead1
% End of user PostScript
.15949 .59978 m
.17773 .6241 L
s
% Start of user PostScript
0.428571 1.92857 0.489634 2.00997 MAarrowhead1
% End of user PostScript
.15949 .66379 m
.18315 .68923 L
s
% Start of user PostScript
0.428571 2.14286 0.50776 2.22801 MAarrowhead1
% End of user PostScript
.15949 .7278 m
.1881 .75392 L
s
% Start of user PostScript
0.428571 2.35714 0.524359 2.44458 MAarrowhead1
% End of user PostScript
.15949 .7918 m
.19265 .8183 L
s
% Start of user PostScript
0.428571 2.57143 0.539583 2.66012 MAarrowhead1
% End of user PostScript
.15949 .85581 m
.19684 .88246 L
s
% Start of user PostScript
0.428571 2.78571 0.55359 2.87493 MAarrowhead1
% End of user PostScript
.15949 .91982 m
.2007 .94647 L
s
% Start of user PostScript
0.428571 3. 0.566529 3.08921 MAarrowhead1
% End of user PostScript
.2235 .02371 m
.21682 .02371 L
s
% Start of user PostScript
0.642857 0 0.620496 0 MAarrowhead1
% End of user PostScript
.2235 .08772 m
.21621 .08615 L
s
% Start of user PostScript
0.642857 0.214286 0.61845 0.209035 MAarrowhead1
% End of user PostScript
.2235 .15173 m
.21458 .14992 L
s
% Start of user PostScript
0.642857 0.428571 0.613004 0.422533 MAarrowhead1
% End of user PostScript
.2235 .21573 m
.21258 .21573 L
s
% Start of user PostScript
0.642857 0.642857 0.606309 0.642857 MAarrowhead1
% End of user PostScript
.2235 .27974 m
.21121 .28386 L
s
% Start of user PostScript
0.642857 0.857143 0.60173 0.870944 MAarrowhead1
% End of user PostScript
.2235 .34375 m
.21164 .35393 L
s
% Start of user PostScript
0.642857 1.07143 0.603162 1.10551 MAarrowhead1
% End of user PostScript
.2235 .40776 m
.21446 .42464 L
s
% Start of user PostScript
0.642857 1.28571 0.612581 1.34224 MAarrowhead1
% End of user PostScript
.2235 .47177 m
.21915 .49464 L
s
% Start of user PostScript
0.642857 1.5 0.628307 1.5766 MAarrowhead1
% End of user PostScript
.2235 .53577 m
.22479 .56336 L
s
% Start of user PostScript
0.642857 1.71429 0.647173 1.80664 MAarrowhead1
% End of user PostScript
.2235 .59978 m
.23066 .63083 L
s
% Start of user PostScript
0.642857 1.92857 0.666834 2.03251 MAarrowhead1
% End of user PostScript
.2235 .66379 m
.2364 .69729 L
s
% Start of user PostScript
0.642857 2.14286 0.686059 2.255 MAarrowhead1
% End of user PostScript
.2235 .7278 m
.24186 .76298 L
s
% Start of user PostScript
0.642857 2.35714 0.704316 2.47493 MAarrowhead1
% End of user PostScript
.2235 .7918 m
.24697 .82811 L
s
% Start of user PostScript
0.642857 2.57143 0.721422 2.69296 MAarrowhead1
% End of user PostScript
.2235 .85581 m
.25173 .89281 L
s
% Start of user PostScript
0.642857 2.78571 0.737359 2.90959 MAarrowhead1
% End of user PostScript
.2235 .91982 m
.25615 .95721 L
s
% Start of user PostScript
0.642857 3. 0.752181 3.12517 MAarrowhead1
% End of user PostScript
.28751 .02371 m
.28332 .02371 L
s
% Start of user PostScript
0.857143 0 0.843124 0 MAarrowhead1
% End of user PostScript
.28751 .08772 m
.28219 .08365 L
s
% Start of user PostScript
0.857143 0.214286 0.839346 0.200651 MAarrowhead1
% End of user PostScript
.28751 .15173 m
.27911 .14623 L
s
% Start of user PostScript
0.857143 0.428571 0.829037 0.410162 MAarrowhead1
% End of user PostScript
.28751 .21573 m
.27522 .21161 L
s
% Start of user PostScript
0.857143 0.642857 0.816016 0.629056 MAarrowhead1
% End of user PostScript
.28751 .27974 m
.27174 .27974 L
s
% Start of user PostScript
0.857143 0.857143 0.804365 0.857143 MAarrowhead1
% End of user PostScript
.28751 .34375 m
.26983 .35013 L
s
% Start of user PostScript
0.857143 1.07143 0.797971 1.0928 MAarrowhead1
% End of user PostScript
.28751 .40776 m
.27023 .42171 L
s
% Start of user PostScript
0.857143 1.28571 0.799302 1.33241 MAarrowhead1
% End of user PostScript
.28751 .47177 m
.27289 .49319 L
s
% Start of user PostScript
0.857143 1.5 0.808209 1.57173 MAarrowhead1
% End of user PostScript
.28751 .53577 m
.27719 .56374 L
s
% Start of user PostScript
0.857143 1.71429 0.822605 1.80792 MAarrowhead1
% End of user PostScript
.28751 .59978 m
.28241 .63305 L
s
% Start of user PostScript
0.857143 1.92857 0.840088 2.03995 MAarrowhead1
% End of user PostScript
.28751 .66379 m
.28801 .70116 L
s
% Start of user PostScript
0.857143 2.14286 0.858835 2.26797 MAarrowhead1
% End of user PostScript
.28751 .7278 m
.29365 .76825 L
s
% Start of user PostScript
0.857143 2.35714 0.877711 2.49257 MAarrowhead1
% End of user PostScript
.28751 .7918 m
.29914 .83451 L
s
% Start of user PostScript
0.857143 2.57143 0.896087 2.71441 MAarrowhead1
% End of user PostScript
.28751 .85581 m
.30438 .90013 L
s
% Start of user PostScript
0.857143 2.78571 0.913646 2.93409 MAarrowhead1
% End of user PostScript
.28751 .91982 m
.30935 .96525 L
s
% Start of user PostScript
0.857143 3. 0.930255 3.15209 MAarrowhead1
% End of user PostScript
.35151 .02371 m
.35457 .02371 L
s
% Start of user PostScript
1.07143 0 1.08165 0 MAarrowhead1
% End of user PostScript
.35151 .08772 m
.35154 .07999 L
s
% Start of user PostScript
1.07143 0.214286 1.07152 0.188396 MAarrowhead1
% End of user PostScript
.35151 .15173 m
.34596 .14095 L
s
% Start of user PostScript
1.07143 0.428571 1.05282 0.392495 MAarrowhead1
% End of user PostScript
.35151 .21573 m
.33966 .20556 L
s
% Start of user PostScript
1.07143 0.642857 1.03173 0.60878 MAarrowhead1
% End of user PostScript
.35151 .27974 m
.33384 .27336 L
s
% Start of user PostScript
1.07143 0.857143 1.01226 0.835769 MAarrowhead1
% End of user PostScript
.35151 .34375 m
.32957 .34375 L
s
% Start of user PostScript
1.07143 1.07143 0.997965 1.07143 MAarrowhead1
% End of user PostScript
.35151 .40776 m
.32758 .41575 L
s
% Start of user PostScript
1.07143 1.28571 0.991307 1.31247 MAarrowhead1
% End of user PostScript
.35151 .47177 m
.32803 .48821 L
s
% Start of user PostScript
1.07143 1.5 0.99282 1.55505 MAarrowhead1
% End of user PostScript
.35151 .53577 m
.33057 .56019 L
s
% Start of user PostScript
1.07143 1.71429 1.00129 1.79604 MAarrowhead1
% End of user PostScript
.35151 .59978 m
.33458 .63117 L
s
% Start of user PostScript
1.07143 1.92857 1.01473 2.03367 MAarrowhead1
% End of user PostScript
.35151 .66379 m
.33949 .70098 L
s
% Start of user PostScript
1.07143 2.14286 1.03118 2.26735 MAarrowhead1
% End of user PostScript
.35151 .7278 m
.34486 .76964 L
s
% Start of user PostScript
1.07143 2.35714 1.04915 2.49723 MAarrowhead1
% End of user PostScript
.35151 .7918 m
.35038 .8373 L
s
% Start of user PostScript
1.07143 2.57143 1.06762 2.72375 MAarrowhead1
% End of user PostScript
.35151 .85581 m
.35585 .90412 L
s
% Start of user PostScript
1.07143 2.78571 1.08595 2.94745 MAarrowhead1
% End of user PostScript
.35151 .91982 m
.36117 .97025 L
s
% Start of user PostScript
1.07143 3. 1.10375 3.16884 MAarrowhead1
% End of user PostScript
.41552 .02371 m
.42664 .02371 L
s
% Start of user PostScript
1.28571 0 1.32294 0 MAarrowhead1
% End of user PostScript
.41552 .08772 m
.42302 .07733 L
s
% Start of user PostScript
1.28571 0.214286 1.31083 0.179513 MAarrowhead1
% End of user PostScript
.41552 .15173 m
.41525 .13575 L
s
% Start of user PostScript
1.28571 0.428571 1.2848 0.375095 MAarrowhead1
% End of user PostScript
.41552 .21573 m
.40648 .19885 L
s
% Start of user PostScript
1.28571 0.642857 1.25544 0.586333 MAarrowhead1
% End of user PostScript
.41552 .27974 m
.39825 .26579 L
s
% Start of user PostScript
1.28571 0.857143 1.22787 0.810448 MAarrowhead1
% End of user PostScript
.41552 .34375 m
.39159 .33576 L
s
% Start of user PostScript
1.28571 1.07143 1.20559 1.04468 MAarrowhead1
% End of user PostScript
.41552 .40776 m
.38721 .40776 L
s
% Start of user PostScript
1.28571 1.28571 1.19093 1.28571 MAarrowhead1
% End of user PostScript
.41552 .47177 m
.38536 .48071 L
s
% Start of user PostScript
1.28571 1.5 1.18474 1.52996 MAarrowhead1
% End of user PostScript
.41552 .53577 m
.38586 .55368 L
s
% Start of user PostScript
1.28571 1.71429 1.1864 1.77423 MAarrowhead1
% End of user PostScript
.41552 .59978 m
.38825 .626 L
s
% Start of user PostScript
1.28571 1.92857 1.1944 2.01633 MAarrowhead1
% End of user PostScript
.41552 .66379 m
.392 .69731 L
s
% Start of user PostScript
1.28571 2.14286 1.20695 2.2551 MAarrowhead1
% End of user PostScript
.41552 .7278 m
.39662 .76753 L
s
% Start of user PostScript
1.28571 2.35714 1.22245 2.49016 MAarrowhead1
% End of user PostScript
.41552 .7918 m
.40175 .83667 L
s
% Start of user PostScript
1.28571 2.57143 1.23962 2.72162 MAarrowhead1
% End of user PostScript
.41552 .85581 m
.40711 .90484 L
s
% Start of user PostScript
1.28571 2.78571 1.25755 2.94985 MAarrowhead1
% End of user PostScript
.41552 .91982 m
.41251 .97217 L
s
% Start of user PostScript
1.28571 3. 1.27561 3.17526 MAarrowhead1
% End of user PostScript
.47953 .02371 m
.49747 .02371 L
s
% Start of user PostScript
1.5 0 1.56006 0 MAarrowhead1
% End of user PostScript
.47953 .08772 m
.49403 .07579 L
s
% Start of user PostScript
1.5 0.214286 1.54854 0.174351 MAarrowhead1
% End of user PostScript
.47953 .15173 m
.48558 .13183 L
s
% Start of user PostScript
1.5 0.428571 1.52026 0.361968 MAarrowhead1
% End of user PostScript
.47953 .21573 m
.47518 .19286 L
s
% Start of user PostScript
1.5 0.642857 1.48545 0.566261 MAarrowhead1
% End of user PostScript
.47953 .27974 m
.46491 .25832 L
s
% Start of user PostScript
1.5 0.857143 1.45107 0.785409 MAarrowhead1
% End of user PostScript
.47953 .34375 m
.45605 .32731 L
s
% Start of user PostScript
1.5 1.07143 1.42139 1.01638 MAarrowhead1
% End of user PostScript
.47953 .40776 m
.44937 .39881 L
s
% Start of user PostScript
1.5 1.28571 1.39903 1.25576 MAarrowhead1
% End of user PostScript
.47953 .47177 m
.44522 .47177 L
s
% Start of user PostScript
1.5 1.5 1.38512 1.5 MAarrowhead1
% End of user PostScript
.47953 .53577 m
.44355 .54522 L
s
% Start of user PostScript
1.5 1.71429 1.37954 1.74592 MAarrowhead1
% End of user PostScript
.47953 .59978 m
.44405 .61845 L
s
% Start of user PostScript
1.5 1.92857 1.38122 1.99107 MAarrowhead1
% End of user PostScript
.47953 .66379 m
.44627 .69097 L
s
% Start of user PostScript
1.5 2.14286 1.38866 2.23385 MAarrowhead1
% End of user PostScript
.47953 .7278 m
.44976 .76254 L
s
% Start of user PostScript
1.5 2.35714 1.40032 2.47344 MAarrowhead1
% End of user PostScript
.47953 .7918 m
.4541 .83307 L
s
% Start of user PostScript
1.5 2.57143 1.41485 2.70959 MAarrowhead1
% End of user PostScript
.47953 .85581 m
.45896 .9026 L
s
% Start of user PostScript
1.5 2.78571 1.43115 2.94237 MAarrowhead1
% End of user PostScript
.47953 .91982 m
.46412 .97121 L
s
% Start of user PostScript
1.5 3. 1.4484 3.17205 MAarrowhead1
% End of user PostScript
.54354 .02371 m
.56738 .02371 L
s
% Start of user PostScript
1.71429 0 1.79412 0 MAarrowhead1
% End of user PostScript
.54354 .08772 m
.56422 .07485 L
s
% Start of user PostScript
1.71429 0.214286 1.78351 0.171195 MAarrowhead1
% End of user PostScript
.54354 .15173 m
.55589 .12917 L
s
% Start of user PostScript
1.71429 0.428571 1.75563 0.353039 MAarrowhead1
% End of user PostScript
.54354 .21573 m
.54483 .18815 L
s
% Start of user PostScript
1.71429 0.642857 1.7186 0.550498 MAarrowhead1
% End of user PostScript
.54354 .27974 m
.53322 .25177 L
s
% Start of user PostScript
1.71429 0.857143 1.67975 0.763509 MAarrowhead1
% End of user PostScript
.54354 .34375 m
.52259 .31933 L
s
% Start of user PostScript
1.71429 1.07143 1.64415 0.989678 MAarrowhead1
% End of user PostScript
.54354 .40776 m
.51387 .38985 L
s
% Start of user PostScript
1.71429 1.28571 1.61498 1.22577 MAarrowhead1
% End of user PostScript
.54354 .47177 m
.50756 .46232 L
s
% Start of user PostScript
1.71429 1.5 1.59382 1.46836 MAarrowhead1
% End of user PostScript
.54354 .53577 m
.50374 .53577 L
s
% Start of user PostScript
1.71429 1.71429 1.58103 1.71429 MAarrowhead1
% End of user PostScript
.54354 .59978 m
.50223 .60945 L
s
% Start of user PostScript
1.71429 1.92857 1.57601 1.96093 MAarrowhead1
% End of user PostScript
.54354 .66379 m
.50271 .68277 L
s
% Start of user PostScript
1.71429 2.14286 1.57759 2.20641 MAarrowhead1
% End of user PostScript
.54354 .7278 m
.50475 .75539 L
s
% Start of user PostScript
1.71429 2.35714 1.58443 2.44953 MAarrowhead1
% End of user PostScript
.54354 .7918 m
.50797 .82712 L
s
% Start of user PostScript
1.71429 2.57143 1.59521 2.68967 MAarrowhead1
% End of user PostScript
.54354 .85581 m
.51202 .8979 L
s
% Start of user PostScript
1.71429 2.78571 1.60876 2.92662 MAarrowhead1
% End of user PostScript
.54354 .91982 m
.51661 .96774 L
s
% Start of user PostScript
1.71429 3. 1.62414 3.16044 MAarrowhead1
% End of user PostScript
.60755 .02371 m
.6366 .02371 L
s
% Start of user PostScript
1.92857 0 2.02585 0 MAarrowhead1
% End of user PostScript
.60755 .08772 m
.6337 .07427 L
s
% Start of user PostScript
1.92857 0.214286 2.01613 0.169267 MAarrowhead1
% End of user PostScript
.60755 .15173 m
.62579 .12741 L
s
% Start of user PostScript
1.92857 0.428571 1.98963 0.347168 MAarrowhead1
% End of user PostScript
.60755 .21573 m
.61471 .18469 L
s
% Start of user PostScript
1.92857 0.642857 1.95255 0.538917 MAarrowhead1
% End of user PostScript
.60755 .27974 m
.60245 .24647 L
s
% Start of user PostScript
1.92857 0.857143 1.91152 0.745765 MAarrowhead1
% End of user PostScript
.60755 .34375 m
.59061 .31236 L
s
% Start of user PostScript
1.92857 1.07143 1.87187 0.966334 MAarrowhead1
% End of user PostScript
.60755 .40776 m
.58027 .38154 L
s
% Start of user PostScript
1.92857 1.28571 1.83726 1.19795 MAarrowhead1
% End of user PostScript
.60755 .47177 m
.57206 .4531 L
s
% Start of user PostScript
1.92857 1.5 1.80979 1.4375 MAarrowhead1
% End of user PostScript
.60755 .53577 m
.56624 .52611 L
s
% Start of user PostScript
1.92857 1.71429 1.79029 1.68193 MAarrowhead1
% End of user PostScript
.60755 .59978 m
.56276 .59978 L
s
% Start of user PostScript
1.92857 1.92857 1.77864 1.92857 MAarrowhead1
% End of user PostScript
.60755 .66379 m
.5614 .6735 L
s
% Start of user PostScript
1.92857 2.14286 1.77408 2.17536 MAarrowhead1
% End of user PostScript
.60755 .7278 m
.56183 .74682 L
s
% Start of user PostScript
1.92857 2.35714 1.77551 2.42081 MAarrowhead1
% End of user PostScript
.60755 .7918 m
.56369 .81946 L
s
% Start of user PostScript
1.92857 2.57143 1.78175 2.66401 MAarrowhead1
% End of user PostScript
.60755 .85581 m
.56665 .89128 L
s
% Start of user PostScript
1.92857 2.78571 1.79166 2.90446 MAarrowhead1
% End of user PostScript
.60755 .91982 m
.57041 .96223 L
s
% Start of user PostScript
1.92857 3. 1.80425 3.14198 MAarrowhead1
% End of user PostScript
.67155 .02371 m
.70527 .02371 L
s
% Start of user PostScript
2.14286 0 2.25574 0 MAarrowhead1
% End of user PostScript
.67155 .08772 m
.70262 .07394 L
s
% Start of user PostScript
2.14286 0.214286 2.24685 0.168154 MAarrowhead1
% End of user PostScript
.67155 .15173 m
.69521 .12629 L
s
% Start of user PostScript
2.14286 0.428571 2.22205 0.343414 MAarrowhead1
% End of user PostScript
.67155 .21573 m
.68446 .18224 L
s
% Start of user PostScript
2.14286 0.642857 2.18606 0.530712 MAarrowhead1
% End of user PostScript
.67155 .27974 m
.67206 .24237 L
s
% Start of user PostScript
2.14286 0.857143 2.14455 0.732033 MAarrowhead1
% End of user PostScript
.67155 .34375 m
.65953 .30656 L
s
% Start of user PostScript
2.14286 1.07143 2.10261 0.946934 MAarrowhead1
% End of user PostScript
.67155 .40776 m
.64803 .37423 L
s
% Start of user PostScript
2.14286 1.28571 2.0641 1.17347 MAarrowhead1
% End of user PostScript
.67155 .47177 m
.6383 .44459 L
s
% Start of user PostScript
2.14286 1.5 2.03152 1.40901 MAarrowhead1
% End of user PostScript
.67155 .53577 m
.63072 .51679 L
s
% Start of user PostScript
2.14286 1.71429 2.00616 1.65073 MAarrowhead1
% End of user PostScript
.67155 .59978 m
.62541 .59007 L
s
% Start of user PostScript
2.14286 1.92857 1.98837 1.89607 MAarrowhead1
% End of user PostScript
.67155 .66379 m
.62224 .66379 L
s
% Start of user PostScript
2.14286 2.14286 1.97777 2.14286 MAarrowhead1
% End of user PostScript
.67155 .7278 m
.62099 .73744 L
s
% Start of user PostScript
2.14286 2.35714 1.97359 2.38944 MAarrowhead1
% End of user PostScript
.67155 .7918 m
.62137 .81069 L
s
% Start of user PostScript
2.14286 2.57143 1.97484 2.63464 MAarrowhead1
% End of user PostScript
.67155 .85581 m
.62306 .8833 L
s
% Start of user PostScript
2.14286 2.78571 1.98049 2.87773 MAarrowhead1
% End of user PostScript
.67155 .91982 m
.62577 .95515 L
s
% Start of user PostScript
2.14286 3. 1.98958 3.11829 MAarrowhead1
% End of user PostScript
.73556 .02371 m
.7735 .02371 L
s
% Start of user PostScript
2.35714 0 2.48415 0 MAarrowhead1
% End of user PostScript
.73556 .08772 m
.77106 .07377 L
s
% Start of user PostScript
2.35714 0.214286 2.47599 0.1676 MAarrowhead1
% End of user PostScript
.73556 .15173 m
.76417 .12561 L
s
% Start of user PostScript
2.35714 0.428571 2.45293 0.34113 MAarrowhead1
% End of user PostScript
.73556 .21573 m
.75392 .18055 L
s
% Start of user PostScript
2.35714 0.642857 2.4186 0.525067 MAarrowhead1
% End of user PostScript
.73556 .27974 m
.7417 .23929 L
s
% Start of user PostScript
2.35714 0.857143 2.37771 0.721719 MAarrowhead1
% End of user PostScript
.73556 .34375 m
.72891 .30191 L
s
% Start of user PostScript
2.35714 1.07143 2.33487 0.931343 MAarrowhead1
% End of user PostScript
.73556 .40776 m
.71666 .36803 L
s
% Start of user PostScript
2.35714 1.28571 2.29388 1.1527 MAarrowhead1
% End of user PostScript
.73556 .47177 m
.70579 .43703 L
s
% Start of user PostScript
2.35714 1.5 2.25747 1.3837 MAarrowhead1
% End of user PostScript
.73556 .53577 m
.69677 .50818 L
s
% Start of user PostScript
2.35714 1.71429 2.22729 1.6219 MAarrowhead1
% End of user PostScript
.73556 .59978 m
.68984 .58076 L
s
% Start of user PostScript
2.35714 1.92857 2.20408 1.8649 MAarrowhead1
% End of user PostScript
.73556 .66379 m
.685 .65414 L
s
% Start of user PostScript
2.35714 2.14286 2.18788 2.11056 MAarrowhead1
% End of user PostScript
.73556 .7278 m
.68211 .7278 L
s
% Start of user PostScript
2.35714 2.35714 2.17821 2.35714 MAarrowhead1
% End of user PostScript
.73556 .7918 m
.68096 .80133 L
s
% Start of user PostScript
2.35714 2.57143 2.17435 2.6033 MAarrowhead1
% End of user PostScript
.73556 .85581 m
.68128 .87445 L
s
% Start of user PostScript
2.35714 2.78571 2.17541 2.84811 MAarrowhead1
% End of user PostScript
.73556 .91982 m
.68281 .94699 L
s
% Start of user PostScript
2.35714 3. 2.18053 3.09095 MAarrowhead1
% End of user PostScript
.79957 .02371 m
.84135 .02371 L
s
% Start of user PostScript
2.57143 0 2.71132 0 MAarrowhead1
% End of user PostScript
.79957 .08772 m
.83912 .07372 L
s
% Start of user PostScript
2.57143 0.214286 2.70384 0.167435 MAarrowhead1
% End of user PostScript
.79957 .15173 m
.83273 .12523 L
s
% Start of user PostScript
2.57143 0.428571 2.68244 0.339877 MAarrowhead1
% End of user PostScript
.79957 .21573 m
.82304 .17943 L
s
% Start of user PostScript
2.57143 0.642857 2.64999 0.521322 MAarrowhead1
% End of user PostScript
.79957 .27974 m
.8112 .23703 L
s
% Start of user PostScript
2.57143 0.857143 2.61037 0.714161 MAarrowhead1
% End of user PostScript
.79957 .34375 m
.79843 .29825 L
s
% Start of user PostScript
2.57143 1.07143 2.56762 0.919109 MAarrowhead1
% End of user PostScript
.79957 .40776 m
.7858 .36289 L
s
% Start of user PostScript
2.57143 1.28571 2.52533 1.13552 MAarrowhead1
% End of user PostScript
.79957 .47177 m
.77413 .4305 L
s
% Start of user PostScript
2.57143 1.5 2.48628 1.36184 MAarrowhead1
% End of user PostScript
.79957 .53577 m
.764 .50045 L
s
% Start of user PostScript
2.57143 1.71429 2.45235 1.59605 MAarrowhead1
% End of user PostScript
.79957 .59978 m
.75571 .57213 L
s
% Start of user PostScript
2.57143 1.92857 2.4246 1.83599 MAarrowhead1
% End of user PostScript
.79957 .66379 m
.74938 .64491 L
s
% Start of user PostScript
2.57143 2.14286 2.40341 2.07965 MAarrowhead1
% End of user PostScript
.79957 .7278 m
.74497 .71827 L
s
% Start of user PostScript
2.57143 2.35714 2.38863 2.32527 MAarrowhead1
% End of user PostScript
.79957 .7918 m
.74232 .7918 L
s
% Start of user PostScript
2.57143 2.57143 2.37978 2.57143 MAarrowhead1
% End of user PostScript
.79957 .85581 m
.74125 .86517 L
s
% Start of user PostScript
2.57143 2.78571 2.37618 2.81705 MAarrowhead1
% End of user PostScript
.79957 .91982 m
.74151 .93815 L
s
% Start of user PostScript
2.57143 3. 2.37707 3.06137 MAarrowhead1
% End of user PostScript
.86358 .02371 m
.9089 .02371 L
s
% Start of user PostScript
2.78571 0 2.93746 0 MAarrowhead1
% End of user PostScript
.86358 .08772 m
.90685 .07376 L
s
% Start of user PostScript
2.78571 0.214286 2.93057 0.167544 MAarrowhead1
% End of user PostScript
.86358 .15173 m
.90092 .12508 L
s
% Start of user PostScript
2.78571 0.428571 2.91073 0.339357 MAarrowhead1
% End of user PostScript
.86358 .21573 m
.8918 .17873 L
s
% Start of user PostScript
2.78571 0.642857 2.88022 0.518984 MAarrowhead1
% End of user PostScript
.86358 .27974 m
.88045 .23542 L
s
% Start of user PostScript
2.78571 0.857143 2.84222 0.708765 MAarrowhead1
% End of user PostScript
.86358 .34375 m
.86791 .29544 L
s
% Start of user PostScript
2.78571 1.07143 2.80024 0.909695 MAarrowhead1
% End of user PostScript
.86358 .40776 m
.85516 .35873 L
s
% Start of user PostScript
2.78571 1.28571 2.75755 1.12158 MAarrowhead1
% End of user PostScript
.86358 .47177 m
.84301 .42497 L
s
% Start of user PostScript
2.78571 1.5 2.71686 1.34335 MAarrowhead1
% End of user PostScript
.86358 .53577 m
.83205 .49368 L
s
% Start of user PostScript
2.78571 1.71429 2.68018 1.57338 MAarrowhead1
% End of user PostScript
.86358 .59978 m
.82268 .56431 L
s
% Start of user PostScript
2.78571 1.92857 2.6488 1.80983 MAarrowhead1
% End of user PostScript
.86358 .66379 m
.81508 .6363 L
s
% Start of user PostScript
2.78571 2.14286 2.62335 2.05085 MAarrowhead1
% End of user PostScript
.86358 .7278 m
.80929 .70916 L
s
% Start of user PostScript
2.78571 2.35714 2.60399 2.29475 MAarrowhead1
% End of user PostScript
.86358 .7918 m
.80526 .78244 L
s
% Start of user PostScript
2.78571 2.57143 2.59047 2.54009 MAarrowhead1
% End of user PostScript
.86358 .85581 m
.80282 .85581 L
s
% Start of user PostScript
2.78571 2.78571 2.58233 2.78571 MAarrowhead1
% End of user PostScript
.86358 .91982 m
.80182 .929 L
s
% Start of user PostScript
2.78571 3. 2.57895 3.03073 MAarrowhead1
% End of user PostScript
.92758 .02371 m
.97619 .02371 L
s
% Start of user PostScript
3. 0 3.16272 0 MAarrowhead1
% End of user PostScript
.92758 .08772 m
.97429 .07385 L
s
% Start of user PostScript
3. 0.214286 3.15637 0.167843 MAarrowhead1
% End of user PostScript
.92758 .15173 m
.96879 .12508 L
s
% Start of user PostScript
3. 0.428571 3.13796 0.339359 MAarrowhead1
% End of user PostScript
.92758 .21573 m
.96024 .17835 L
s
% Start of user PostScript
3. 0.642857 3.10932 0.517687 MAarrowhead1
% End of user PostScript
.92758 .27974 m
.94942 .23431 L
s
% Start of user PostScript
3. 0.857143 3.07311 0.705048 MAarrowhead1
% End of user PostScript
.92758 .34375 m
.93724 .29332 L
s
% Start of user PostScript
3. 1.07143 3.03232 0.902591 MAarrowhead1
% End of user PostScript
.92758 .40776 m
.92457 .35541 L
s
% Start of user PostScript
3. 1.28571 2.9899 1.11045 MAarrowhead1
% End of user PostScript
.92758 .47177 m
.91217 .42037 L
s
% Start of user PostScript
3. 1.5 2.9484 1.32795 MAarrowhead1
% End of user PostScript
.92758 .53577 m
.90066 .48785 L
s
% Start of user PostScript
3. 1.71429 2.90985 1.55384 MAarrowhead1
% End of user PostScript
.92758 .59978 m
.89045 .55737 L
s
% Start of user PostScript
3. 1.92857 2.87567 1.78659 MAarrowhead1
% End of user PostScript
.92758 .66379 m
.8818 .62845 L
s
% Start of user PostScript
3. 2.14286 2.84673 2.02457 MAarrowhead1
% End of user PostScript
.92758 .7278 m
.87483 .70063 L
s
% Start of user PostScript
3. 2.35714 2.82338 2.26619 MAarrowhead1
% End of user PostScript
.92758 .7918 m
.86953 .77347 L
s
% Start of user PostScript
3. 2.57143 2.80565 2.51006 MAarrowhead1
% End of user PostScript
.92758 .85581 m
.86582 .84663 L
s
% Start of user PostScript
3. 2.78571 2.79324 2.75498 MAarrowhead1
% End of user PostScript
.92758 .91982 m
.86358 .91982 L
s
% Start of user PostScript
3. 3. 2.78571 3. MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 .99588 L
0 .99588 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.39.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.39.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ListPlotVectorField[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "21"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "22"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "make a vector field plot of the rectangular array of vectors ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["v",
          "TI"], 
         StyleBox["e",
          "TI"], 
         StyleBox["c",
          "TI"], 
         SubscriptBox[
          StyleBox["t",
           "TI"], 
          StyleBox[
           RowBox[{"x", "y"}],
           "TI"]]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ListPlotVectorField[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pt",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pt",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "display a list of vectors based at the given points ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.39.1"],

Cell["Vector field plots of lists. ", "Caption",
 CellTags->"S5.39.1"],

Cell["This gives an array of random vectors. ", "MathCaption",
 CellTags->{"S5.39.1", "1.16"}],

Cell["\<\
varray = Table[
  {Random[Real, {-0.7, 0.7}],
      Random[Real, {-0.7, 0.7}]},
                  {i, 10}, {j, 10}];\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.39.1"],

Cell["This displays the array of vectors in a plot. ", "MathCaption",
 CellTags->{"S5.39.1", "1.17"}],

Cell[CellGroupData[{

Cell["ListPlotVectorField[varray]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.39.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .96602 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0112644 0.0926659 -0.0358974 0.0926659 [
[ 0 0 0 0 ]
[ 1 .96602 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.0001 w
[ ] 0 setdash
.0814 .05677 m
.14296 .09091 L
s
% Start of user PostScript
1. 1. 1.66436 1.36845 MAarrowhead1
% End of user PostScript
.17407 .05677 m
.17042 .027 L
s
% Start of user PostScript
2. 1. 1.96059 0.678772 MAarrowhead1
% End of user PostScript
.26673 .05677 m
.3069 .02399 L
s
% Start of user PostScript
3. 1. 3.4335 0.646252 MAarrowhead1
% End of user PostScript
.3594 .05677 m
.37366 .03904 L
s
% Start of user PostScript
4. 1. 4.15393 0.808723 MAarrowhead1
% End of user PostScript
.45207 .05677 m
.50667 .023 L
s
% Start of user PostScript
5. 1. 5.58931 0.635594 MAarrowhead1
% End of user PostScript
.54473 .05677 m
.54274 .1027 L
s
% Start of user PostScript
6. 1. 5.97848 1.49565 MAarrowhead1
% End of user PostScript
.6374 .05677 m
.65036 .04845 L
s
% Start of user PostScript
7. 1. 7.13984 0.910261 MAarrowhead1
% End of user PostScript
.73006 .05677 m
.76566 .11698 L
s
% Start of user PostScript
8. 1. 8.38412 1.6498 MAarrowhead1
% End of user PostScript
.82273 .05677 m
.7717 .05826 L
s
% Start of user PostScript
9. 1. 8.44928 1.01606 MAarrowhead1
% End of user PostScript
.91539 .05677 m
.90673 .03696 L
s
% Start of user PostScript
10. 1. 9.90651 0.786258 MAarrowhead1
% End of user PostScript
.0814 .14943 m
.03793 .15149 L
s
% Start of user PostScript
1. 2. 0.530859 2.0222 MAarrowhead1
% End of user PostScript
.17407 .14943 m
.22102 .20226 L
s
% Start of user PostScript
2. 2. 2.50665 2.57005 MAarrowhead1
% End of user PostScript
.26673 .14943 m
.31716 .08556 L
s
% Start of user PostScript
3. 2. 3.54419 1.31066 MAarrowhead1
% End of user PostScript
.3594 .14943 m
.31079 .15065 L
s
% Start of user PostScript
4. 2. 3.47545 2.01307 MAarrowhead1
% End of user PostScript
.45207 .14943 m
.42885 .18885 L
s
% Start of user PostScript
5. 2. 4.74947 2.42533 MAarrowhead1
% End of user PostScript
.54473 .14943 m
.57201 .20002 L
s
% Start of user PostScript
6. 2. 6.29435 2.54585 MAarrowhead1
% End of user PostScript
.6374 .14943 m
.63652 .2045 L
s
% Start of user PostScript
7. 2. 6.99055 2.59421 MAarrowhead1
% End of user PostScript
.73006 .14943 m
.70946 .16459 L
s
% Start of user PostScript
8. 2. 7.77762 2.16354 MAarrowhead1
% End of user PostScript
.82273 .14943 m
.85109 .20083 L
s
% Start of user PostScript
9. 2. 9.30611 2.55464 MAarrowhead1
% End of user PostScript
.91539 .14943 m
.88976 .08551 L
s
% Start of user PostScript
10. 2. 9.72331 1.31016 MAarrowhead1
% End of user PostScript
.0814 .2421 m
.05237 .24317 L
s
% Start of user PostScript
1. 3. 0.686666 3.01154 MAarrowhead1
% End of user PostScript
.17407 .2421 m
.20476 .22885 L
s
% Start of user PostScript
2. 3. 2.3312 2.85698 MAarrowhead1
% End of user PostScript
.26673 .2421 m
.27551 .20367 L
s
% Start of user PostScript
3. 3. 3.09472 2.58533 MAarrowhead1
% End of user PostScript
.3594 .2421 m
.34838 .2576 L
s
% Start of user PostScript
4. 3. 3.8811 3.16722 MAarrowhead1
% End of user PostScript
.45207 .2421 m
.49459 .29132 L
s
% Start of user PostScript
5. 3. 5.45892 3.53113 MAarrowhead1
% End of user PostScript
.54473 .2421 m
.52775 .21266 L
s
% Start of user PostScript
6. 3. 5.81674 2.68231 MAarrowhead1
% End of user PostScript
.6374 .2421 m
.67302 .1809 L
s
% Start of user PostScript
7. 3. 7.38444 2.33957 MAarrowhead1
% End of user PostScript
.73006 .2421 m
.67023 .25631 L
s
% Start of user PostScript
8. 3. 7.35431 3.15338 MAarrowhead1
% End of user PostScript
.82273 .2421 m
.8544 .19449 L
s
% Start of user PostScript
9. 3. 9.34175 2.48618 MAarrowhead1
% End of user PostScript
.91539 .2421 m
.95827 .27281 L
s
% Start of user PostScript
10. 3. 10.4627 3.33139 MAarrowhead1
% End of user PostScript
.0814 .33477 m
.10845 .3094 L
s
% Start of user PostScript
1. 4. 1.29194 3.72622 MAarrowhead1
% End of user PostScript
.17407 .33477 m
.15091 .37088 L
s
% Start of user PostScript
2. 4. 1.7501 4.38975 MAarrowhead1
% End of user PostScript
.26673 .33477 m
.29785 .31199 L
s
% Start of user PostScript
3. 4. 3.3358 3.7542 MAarrowhead1
% End of user PostScript
.3594 .33477 m
.3005 .31483 L
s
% Start of user PostScript
4. 4. 3.36436 3.78491 MAarrowhead1
% End of user PostScript
.45207 .33477 m
.3941 .38032 L
s
% Start of user PostScript
5. 4. 4.37448 4.49156 MAarrowhead1
% End of user PostScript
.54473 .33477 m
.52272 .35598 L
s
% Start of user PostScript
6. 4. 5.76243 4.22893 MAarrowhead1
% End of user PostScript
.6374 .33477 m
.57649 .38605 L
s
% Start of user PostScript
7. 4. 6.34269 4.55339 MAarrowhead1
% End of user PostScript
.73006 .33477 m
.69222 .38314 L
s
% Start of user PostScript
8. 4. 7.59158 4.52199 MAarrowhead1
% End of user PostScript
.82273 .33477 m
.833 .34996 L
s
% Start of user PostScript
9. 4. 9.11089 4.16398 MAarrowhead1
% End of user PostScript
.91539 .33477 m
.97619 .37752 L
s
% Start of user PostScript
10. 4. 10.6561 4.46134 MAarrowhead1
% End of user PostScript
.0814 .42743 m
.1422 .48971 L
s
% Start of user PostScript
1. 5. 1.65614 5.67202 MAarrowhead1
% End of user PostScript
.17407 .42743 m
.14495 .41861 L
s
% Start of user PostScript
2. 5. 1.68574 4.90485 MAarrowhead1
% End of user PostScript
.26673 .42743 m
.29095 .42397 L
s
% Start of user PostScript
3. 5. 3.26133 4.96264 MAarrowhead1
% End of user PostScript
.3594 .42743 m
.38738 .45115 L
s
% Start of user PostScript
4. 5. 4.30193 5.25597 MAarrowhead1
% End of user PostScript
.45207 .42743 m
.39014 .48657 L
s
% Start of user PostScript
5. 5. 4.33178 5.63817 MAarrowhead1
% End of user PostScript
.54473 .42743 m
.4957 .46514 L
s
% Start of user PostScript
6. 5. 5.47085 5.40694 MAarrowhead1
% End of user PostScript
.6374 .42743 m
.63108 .39865 L
s
% Start of user PostScript
7. 5. 6.9318 4.68941 MAarrowhead1
% End of user PostScript
.73006 .42743 m
.69629 .36819 L
s
% Start of user PostScript
8. 5. 7.6355 4.36065 MAarrowhead1
% End of user PostScript
.82273 .42743 m
.79717 .37669 L
s
% Start of user PostScript
9. 5. 8.72422 4.45243 MAarrowhead1
% End of user PostScript
.91539 .42743 m
.88063 .41857 L
s
% Start of user PostScript
10. 5. 9.62488 4.90436 MAarrowhead1
% End of user PostScript
.0814 .5201 m
.05312 .52097 L
s
% Start of user PostScript
1. 6. 0.694815 6.00938 MAarrowhead1
% End of user PostScript
.17407 .5201 m
.18183 .55243 L
s
% Start of user PostScript
2. 6. 2.0838 6.34887 MAarrowhead1
% End of user PostScript
.26673 .5201 m
.288 .52237 L
s
% Start of user PostScript
3. 6. 3.22954 6.02447 MAarrowhead1
% End of user PostScript
.3594 .5201 m
.37155 .57097 L
s
% Start of user PostScript
4. 6. 4.13108 6.54903 MAarrowhead1
% End of user PostScript
.45207 .5201 m
.46133 .54315 L
s
% Start of user PostScript
5. 6. 5.09998 6.24876 MAarrowhead1
% End of user PostScript
.54473 .5201 m
.59434 .55219 L
s
% Start of user PostScript
6. 6. 6.53535 6.34629 MAarrowhead1
% End of user PostScript
.6374 .5201 m
.59177 .47719 L
s
% Start of user PostScript
7. 6. 6.50758 5.53697 MAarrowhead1
% End of user PostScript
.73006 .5201 m
.66618 .53458 L
s
% Start of user PostScript
8. 6. 7.31063 6.15629 MAarrowhead1
% End of user PostScript
.82273 .5201 m
.83499 .55959 L
s
% Start of user PostScript
9. 6. 9.13228 6.42622 MAarrowhead1
% End of user PostScript
.91539 .5201 m
.96866 .53998 L
s
% Start of user PostScript
10. 6. 10.5748 6.21461 MAarrowhead1
% End of user PostScript
.0814 .61276 m
.09672 .67623 L
s
% Start of user PostScript
1. 7. 1.16527 7.68492 MAarrowhead1
% End of user PostScript
.17407 .61276 m
.23455 .65908 L
s
% Start of user PostScript
2. 7. 2.65272 7.49984 MAarrowhead1
% End of user PostScript
.26673 .61276 m
.21387 .65685 L
s
% Start of user PostScript
3. 7. 2.42956 7.4757 MAarrowhead1
% End of user PostScript
.3594 .61276 m
.3868 .56668 L
s
% Start of user PostScript
4. 7. 4.29573 6.50274 MAarrowhead1
% End of user PostScript
.45207 .61276 m
.44209 .61386 L
s
% Start of user PostScript
5. 7. 4.8924 7.01179 MAarrowhead1
% End of user PostScript
.54473 .61276 m
.59336 .5655 L
s
% Start of user PostScript
6. 7. 6.52472 6.49 MAarrowhead1
% End of user PostScript
.6374 .61276 m
.64437 .59523 L
s
% Start of user PostScript
7. 7. 7.0753 6.81076 MAarrowhead1
% End of user PostScript
.73006 .61276 m
.67779 .67223 L
s
% Start of user PostScript
8. 7. 7.43585 7.64169 MAarrowhead1
% End of user PostScript
.82273 .61276 m
.83905 .65485 L
s
% Start of user PostScript
9. 7. 9.17614 7.45419 MAarrowhead1
% End of user PostScript
.91539 .61276 m
.93291 .5766 L
s
% Start of user PostScript
10. 7. 10.189 6.60976 MAarrowhead1
% End of user PostScript
.0814 .70543 m
.08471 .65995 L
s
% Start of user PostScript
1. 8. 1.03571 7.50921 MAarrowhead1
% End of user PostScript
.17407 .70543 m
.14228 .73296 L
s
% Start of user PostScript
2. 8. 1.65699 8.2971 MAarrowhead1
% End of user PostScript
.26673 .70543 m
.28871 .68355 L
s
% Start of user PostScript
3. 8. 3.23716 7.76391 MAarrowhead1
% End of user PostScript
.3594 .70543 m
.40305 .64174 L
s
% Start of user PostScript
4. 8. 4.47101 7.31274 MAarrowhead1
% End of user PostScript
.45207 .70543 m
.49998 .65919 L
s
% Start of user PostScript
5. 8. 5.51711 7.50103 MAarrowhead1
% End of user PostScript
.54473 .70543 m
.58077 .66357 L
s
% Start of user PostScript
6. 8. 6.38887 7.54831 MAarrowhead1
% End of user PostScript
.6374 .70543 m
.69292 .71067 L
s
% Start of user PostScript
7. 8. 7.59916 8.05656 MAarrowhead1
% End of user PostScript
.73006 .70543 m
.72513 .73619 L
s
% Start of user PostScript
8. 8. 7.94681 8.33193 MAarrowhead1
% End of user PostScript
.82273 .70543 m
.80246 .68178 L
s
% Start of user PostScript
9. 8. 8.78132 7.74481 MAarrowhead1
% End of user PostScript
.91539 .70543 m
.86028 .70181 L
s
% Start of user PostScript
10. 8. 9.40524 7.96089 MAarrowhead1
% End of user PostScript
.0814 .7981 m
.1276 .83936 L
s
% Start of user PostScript
1. 9. 1.49855 9.4453 MAarrowhead1
% End of user PostScript
.17407 .7981 m
.1635 .82445 L
s
% Start of user PostScript
2. 9. 1.88598 9.28436 MAarrowhead1
% End of user PostScript
.26673 .7981 m
.30566 .75759 L
s
% Start of user PostScript
3. 9. 3.42005 8.56288 MAarrowhead1
% End of user PostScript
.3594 .7981 m
.30214 .84113 L
s
% Start of user PostScript
4. 9. 3.38213 9.46443 MAarrowhead1
% End of user PostScript
.45207 .7981 m
.50933 .81148 L
s
% Start of user PostScript
5. 9. 5.61795 9.14447 MAarrowhead1
% End of user PostScript
.54473 .7981 m
.52083 .79035 L
s
% Start of user PostScript
6. 9. 5.74206 8.91639 MAarrowhead1
% End of user PostScript
.6374 .7981 m
.64832 .76212 L
s
% Start of user PostScript
7. 9. 7.11784 8.61175 MAarrowhead1
% End of user PostScript
.73006 .7981 m
.71538 .76761 L
s
% Start of user PostScript
8. 9. 7.84157 8.67104 MAarrowhead1
% End of user PostScript
.82273 .7981 m
.85202 .77585 L
s
% Start of user PostScript
9. 9. 9.31605 8.7599 MAarrowhead1
% End of user PostScript
.91539 .7981 m
.86466 .81302 L
s
% Start of user PostScript
10. 9. 9.45252 9.16104 MAarrowhead1
% End of user PostScript
.0814 .89076 m
.02381 .90767 L
s
% Start of user PostScript
1. 10. 0.378499 10.1824 MAarrowhead1
% End of user PostScript
.17407 .89076 m
.15589 .93894 L
s
% Start of user PostScript
2. 10. 1.80385 10.5199 MAarrowhead1
% End of user PostScript
.26673 .89076 m
.31326 .90173 L
s
% Start of user PostScript
3. 10. 3.5021 10.1184 MAarrowhead1
% End of user PostScript
.3594 .89076 m
.39091 .87668 L
s
% Start of user PostScript
4. 10. 4.34007 9.84805 MAarrowhead1
% End of user PostScript
.45207 .89076 m
.43354 .87526 L
s
% Start of user PostScript
5. 10. 4.80011 9.83272 MAarrowhead1
% End of user PostScript
.54473 .89076 m
.60038 .84863 L
s
% Start of user PostScript
6. 10. 6.60049 9.54535 MAarrowhead1
% End of user PostScript
.6374 .89076 m
.6839 .9419 L
s
% Start of user PostScript
7. 10. 7.50178 10.5519 MAarrowhead1
% End of user PostScript
.73006 .89076 m
.70125 .91022 L
s
% Start of user PostScript
8. 10. 7.68905 10.21 MAarrowhead1
% End of user PostScript
.82273 .89076 m
.78384 .84913 L
s
% Start of user PostScript
9. 10. 8.58034 9.55068 MAarrowhead1
% End of user PostScript
.91539 .89076 m
.96131 .94302 L
s
% Start of user PostScript
10. 10. 10.4955 10.5639 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 .96602 L
0 .96602 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.39.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.39.1"]
}, Open  ]],

Cell[TextData[{
 "This generates a list of vectors as ",
 StyleBox["{", "MR"],
 StyleBox["base", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["vector", "TI"],
 StyleBox["}", "MR"],
 " pairs. "
}], "MathCaption",
 CellTags->{"S5.39.1", "1.18"}],

Cell["\<\
vectors = Table[
  {{Sin[u], Cos[u]}, {u^2 Sin[2u], u^2 Cos[2u]}},
       {u, 0, 2 Pi, Pi/16}];\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.39.1"],

Cell["Here are the vectors without any scaling applied. ", "MathCaption",
 CellTags->{"S5.39.1", "1.19"}],

Cell[CellGroupData[{

Cell["\<\
ListPlotVectorField[
    vectors,
    ScaleFactor -> None,
    Frame -> True
]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.39.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.3684 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.666909 0.0207902 0.494262 0.0207902 [
[.0432 -0.0125 -9 -9 ]
[.0432 -0.0125 9 0 ]
[.2511 -0.0125 -9 -9 ]
[.2511 -0.0125 9 0 ]
[.45901 -0.0125 -9 -9 ]
[.45901 -0.0125 9 0 ]
[.66691 -0.0125 -3 -9 ]
[.66691 -0.0125 3 0 ]
[.87481 -0.0125 -6 -9 ]
[.87481 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .07846 -18 -4.5 ]
[-0.0125 .07846 0 4.5 ]
[-0.0125 .28636 -18 -4.5 ]
[-0.0125 .28636 0 4.5 ]
[-0.0125 .49426 -6 -4.5 ]
[-0.0125 .49426 0 4.5 ]
[-0.0125 .70216 -12 -4.5 ]
[-0.0125 .70216 0 4.5 ]
[-0.0125 .91007 -12 -4.5 ]
[-0.0125 .91007 0 4.5 ]
[-0.0125 1.11797 -12 -4.5 ]
[-0.0125 1.11797 0 4.5 ]
[-0.0125 1.32587 -12 -4.5 ]
[-0.0125 1.32587 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1.3684 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1.3684 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0432 0 m
.0432 .00625 L
s
[(-30)] .0432 -0.0125 0 1 Mshowa
.2511 0 m
.2511 .00625 L
s
[(-20)] .2511 -0.0125 0 1 Mshowa
.45901 0 m
.45901 .00625 L
s
[(-10)] .45901 -0.0125 0 1 Mshowa
.66691 0 m
.66691 .00625 L
s
[(0)] .66691 -0.0125 0 1 Mshowa
.87481 0 m
.87481 .00625 L
s
[(10)] .87481 -0.0125 0 1 Mshowa
.125 Mabswid
.08478 0 m
.08478 .00375 L
s
.12636 0 m
.12636 .00375 L
s
.16794 0 m
.16794 .00375 L
s
.20952 0 m
.20952 .00375 L
s
.29268 0 m
.29268 .00375 L
s
.33427 0 m
.33427 .00375 L
s
.37585 0 m
.37585 .00375 L
s
.41743 0 m
.41743 .00375 L
s
.50059 0 m
.50059 .00375 L
s
.54217 0 m
.54217 .00375 L
s
.58375 0 m
.58375 .00375 L
s
.62533 0 m
.62533 .00375 L
s
.70849 0 m
.70849 .00375 L
s
.75007 0 m
.75007 .00375 L
s
.79165 0 m
.79165 .00375 L
s
.83323 0 m
.83323 .00375 L
s
.00162 0 m
.00162 .00375 L
s
.91639 0 m
.91639 .00375 L
s
.95797 0 m
.95797 .00375 L
s
.99955 0 m
.99955 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07846 m
.00625 .07846 L
s
[(-20)] -0.0125 .07846 1 0 Mshowa
0 .28636 m
.00625 .28636 L
s
[(-10)] -0.0125 .28636 1 0 Mshowa
0 .49426 m
.00625 .49426 L
s
[(0)] -0.0125 .49426 1 0 Mshowa
0 .70216 m
.00625 .70216 L
s
[(10)] -0.0125 .70216 1 0 Mshowa
0 .91007 m
.00625 .91007 L
s
[(20)] -0.0125 .91007 1 0 Mshowa
0 1.11797 m
.00625 1.11797 L
s
[(30)] -0.0125 1.11797 1 0 Mshowa
0 1.32587 m
.00625 1.32587 L
s
[(40)] -0.0125 1.32587 1 0 Mshowa
.125 Mabswid
0 .12004 m
.00375 .12004 L
s
0 .16162 m
.00375 .16162 L
s
0 .2032 m
.00375 .2032 L
s
0 .24478 m
.00375 .24478 L
s
0 .32794 m
.00375 .32794 L
s
0 .36952 m
.00375 .36952 L
s
0 .4111 m
.00375 .4111 L
s
0 .45268 m
.00375 .45268 L
s
0 .53584 m
.00375 .53584 L
s
0 .57742 m
.00375 .57742 L
s
0 .619 m
.00375 .619 L
s
0 .66058 m
.00375 .66058 L
s
0 .74374 m
.00375 .74374 L
s
0 .78533 m
.00375 .78533 L
s
0 .82691 m
.00375 .82691 L
s
0 .86849 m
.00375 .86849 L
s
0 .95165 m
.00375 .95165 L
s
0 .99323 m
.00375 .99323 L
s
0 1.03481 m
.00375 1.03481 L
s
0 1.07639 m
.00375 1.07639 L
s
0 1.15955 m
.00375 1.15955 L
s
0 1.20113 m
.00375 1.20113 L
s
0 1.24271 m
.00375 1.24271 L
s
0 1.28429 m
.00375 1.28429 L
s
0 .03688 m
.00375 .03688 L
s
0 1.36745 m
.00375 1.36745 L
s
.25 Mabswid
0 0 m
0 1.3684 L
s
.0432 1.36215 m
.0432 1.3684 L
s
.2511 1.36215 m
.2511 1.3684 L
s
.45901 1.36215 m
.45901 1.3684 L
s
.66691 1.36215 m
.66691 1.3684 L
s
.87481 1.36215 m
.87481 1.3684 L
s
.125 Mabswid
.08478 1.36465 m
.08478 1.3684 L
s
.12636 1.36465 m
.12636 1.3684 L
s
.16794 1.36465 m
.16794 1.3684 L
s
.20952 1.36465 m
.20952 1.3684 L
s
.29268 1.36465 m
.29268 1.3684 L
s
.33427 1.36465 m
.33427 1.3684 L
s
.37585 1.36465 m
.37585 1.3684 L
s
.41743 1.36465 m
.41743 1.3684 L
s
.50059 1.36465 m
.50059 1.3684 L
s
.54217 1.36465 m
.54217 1.3684 L
s
.58375 1.36465 m
.58375 1.3684 L
s
.62533 1.36465 m
.62533 1.3684 L
s
.70849 1.36465 m
.70849 1.3684 L
s
.75007 1.36465 m
.75007 1.3684 L
s
.79165 1.36465 m
.79165 1.3684 L
s
.83323 1.36465 m
.83323 1.3684 L
s
.00162 1.36465 m
.00162 1.3684 L
s
.91639 1.36465 m
.91639 1.3684 L
s
.95797 1.36465 m
.95797 1.3684 L
s
.99955 1.36465 m
.99955 1.3684 L
s
.25 Mabswid
0 1.3684 m
1 1.3684 L
s
.99375 .07846 m
1 .07846 L
s
.99375 .28636 m
1 .28636 L
s
.99375 .49426 m
1 .49426 L
s
.99375 .70216 m
1 .70216 L
s
.99375 .91007 m
1 .91007 L
s
.99375 1.11797 m
1 1.11797 L
s
.99375 1.32587 m
1 1.32587 L
s
.125 Mabswid
.99625 .12004 m
1 .12004 L
s
.99625 .16162 m
1 .16162 L
s
.99625 .2032 m
1 .2032 L
s
.99625 .24478 m
1 .24478 L
s
.99625 .32794 m
1 .32794 L
s
.99625 .36952 m
1 .36952 L
s
.99625 .4111 m
1 .4111 L
s
.99625 .45268 m
1 .45268 L
s
.99625 .53584 m
1 .53584 L
s
.99625 .57742 m
1 .57742 L
s
.99625 .619 m
1 .619 L
s
.99625 .66058 m
1 .66058 L
s
.99625 .74374 m
1 .74374 L
s
.99625 .78533 m
1 .78533 L
s
.99625 .82691 m
1 .82691 L
s
.99625 .86849 m
1 .86849 L
s
.99625 .95165 m
1 .95165 L
s
.99625 .99323 m
1 .99323 L
s
.99625 1.03481 m
1 1.03481 L
s
.99625 1.07639 m
1 1.07639 L
s
.99625 1.15955 m
1 1.15955 L
s
.99625 1.20113 m
1 1.20113 L
s
.99625 1.24271 m
1 1.24271 L
s
.99625 1.28429 m
1 1.28429 L
s
.99625 .03688 m
1 .03688 L
s
.99625 1.36745 m
1 1.36745 L
s
.25 Mabswid
1 0 m
1 1.3684 L
s
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
0 0 Mdot
grestore
} def
% End of user PostScript
.0001 w
.66691 .51505 m
.66691 .51505 L
s
% Start of user PostScript
0 1. MAarrowzero1
% End of user PostScript
.67097 .51465 m
.67127 .51539 L
s
% Start of user PostScript
0.19509 0.980785 0.209844 1.0164 MAarrowhead1
% End of user PostScript
.67487 .51347 m
.67713 .51574 L
s
% Start of user PostScript
0.382683 0.92388 0.491728 1.03292 MAarrowhead1
% End of user PostScript
.67846 .51155 m
.68512 .51431 L
s
% Start of user PostScript
0.55557 0.83147 0.876136 0.964252 MAarrowhead1
% End of user PostScript
.68161 .50896 m
.69443 .50896 L
s
% Start of user PostScript
0.707107 0.707107 1.32396 0.707107 MAarrowhead1
% End of user PostScript
.6842 .50581 m
.70271 .49814 L
s
% Start of user PostScript
0.83147 0.55557 1.72193 0.186729 MAarrowhead1
% End of user PostScript
.68612 .50222 m
.70652 .48181 L
s
% Start of user PostScript
0.92388 0.382683 1.90528 -0.598719 MAarrowhead1
% End of user PostScript
.6873 .49832 m
.70233 .46203 L
s
% Start of user PostScript
0.980785 0.19509 1.70371 -1.55021 MAarrowhead1
% End of user PostScript
.6877 .49426 m
.6877 .44296 L
s
% Start of user PostScript
1. 0 1. -2.4674 MAarrowhead1
% End of user PostScript
.6873 .49021 m
.66245 .43022 L
s
% Start of user PostScript
0.980785 -0.19509 -0.21426 -3.08019 MAarrowhead1
% End of user PostScript
.68612 .48631 m
.62944 .42963 L
s
% Start of user PostScript
0.92388 -0.382683 -1.80224 -3.1088 MAarrowhead1
% End of user PostScript
.6842 .48271 m
.59459 .4456 L
s
% Start of user PostScript
0.83147 -0.55557 -3.47836 -2.34076 MAarrowhead1
% End of user PostScript
.68161 .47956 m
.56619 .47956 L
s
% Start of user PostScript
0.707107 -0.707107 -4.84455 -0.707107 MAarrowhead1
% End of user PostScript
.67846 .47698 m
.55331 .52881 L
s
% Start of user PostScript
0.55557 -0.83147 -5.46395 1.6619 MAarrowhead1
% End of user PostScript
.67487 .47505 m
.56378 .58614 L
s
% Start of user PostScript
0.382683 -0.92388 -4.96051 4.41931 MAarrowhead1
% End of user PostScript
.67097 .47387 m
.60195 .64049 L
s
% Start of user PostScript
0.19509 -0.980785 -3.12448 7.03337 MAarrowhead1
% End of user PostScript
.66691 .47347 m
.66691 .67866 L
s
% Start of user PostScript
0 -1. 0 8.8696 MAarrowhead1
% End of user PostScript
.66285 .47387 m
.7515 .68788 L
s
% Start of user PostScript
-0.19509 -0.980785 4.06871 9.31295 MAarrowhead1
% End of user PostScript
.65895 .47505 m
.84259 .65869 L
s
% Start of user PostScript
-0.382683 -0.92388 8.44994 7.90875 MAarrowhead1
% End of user PostScript
.65536 .47698 m
.92269 .58771 L
s
% Start of user PostScript
-0.55557 -0.83147 12.3027 4.4946 MAarrowhead1
% End of user PostScript
.65221 .47956 m
.97282 .47956 L
s
% Start of user PostScript
-0.707107 -0.707107 14.7142 -0.707107 MAarrowhead1
% End of user PostScript
.64962 .48271 m
.97619 .34744 L
s
% Start of user PostScript
-0.83147 -0.55557 14.8763 -7.06193 MAarrowhead1
% End of user PostScript
.6477 .48631 m
.92202 .21199 L
s
% Start of user PostScript
-0.92388 -0.382683 12.2705 -13.5771 MAarrowhead1
% End of user PostScript
.64652 .49021 m
.80878 .09847 L
s
% Start of user PostScript
-0.980785 -0.19509 6.82389 -19.0373 MAarrowhead1
% End of user PostScript
.64612 .49426 m
.64612 .03258 L
s
% Start of user PostScript
-1. 0 -1. -22.2066 MAarrowhead1
% End of user PostScript
.64652 .49832 m
.45481 .03549 L
s
% Start of user PostScript
-0.980785 0.19509 -10.2018 -22.0664 MAarrowhead1
% End of user PostScript
.6477 .50222 m
.26457 .11908 L
s
% Start of user PostScript
-0.92388 0.382683 -19.3524 -18.0459 MAarrowhead1
% End of user PostScript
.64962 .50581 m
.10979 .2822 L
s
% Start of user PostScript
-0.83147 0.55557 -26.7973 -10.1998 MAarrowhead1
% End of user PostScript
.65221 .50896 m
.02381 .50896 L
s
% Start of user PostScript
-0.707107 0.707107 -30.9328 0.707107 MAarrowhead1
% End of user PostScript
.65536 .51155 m
.03258 .76951 L
s
% Start of user PostScript
-0.55557 0.83147 -30.5107 13.2393 MAarrowhead1
% End of user PostScript
.65895 .51347 m
.14886 1.02356 L
s
% Start of user PostScript
-0.382683 0.92388 -24.9178 25.4589 MAarrowhead1
% End of user PostScript
.66285 .51465 m
.36808 1.22629 L
s
% Start of user PostScript
-0.19509 0.980785 -14.3733 35.2101 MAarrowhead1
% End of user PostScript
.66691 .51505 m
.66691 1.33582 L
s
% Start of user PostScript
0 1. 0 40.4784 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 1.3684 L
0 1.3684 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.39.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.39.1"]
}, Open  ]],

Cell["\<\
Here are the vectors with the longest vector scaled to a length of 1, and all \
other vectors scaled proportionately. \
\>", "MathCaption",
 CellTags->{"S5.39.1", "1.20"}],

Cell[CellGroupData[{

Cell["\<\
ListPlotVectorField[
    vectors,
    ScaleFactor -> 1,
    Frame -> True
]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.39.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.20521 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.593584 0.382606 0.411302 0.382606 [
[.01967 -0.0125 -12 -9 ]
[.01967 -0.0125 12 0 ]
[.21098 -0.0125 -6 -9 ]
[.21098 -0.0125 6 0 ]
[.40228 -0.0125 -12 -9 ]
[.40228 -0.0125 12 0 ]
[.59358 -0.0125 -3 -9 ]
[.59358 -0.0125 3 0 ]
[.78489 -0.0125 -9 -9 ]
[.78489 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .0287 -12 -4.5 ]
[-0.0125 .0287 0 4.5 ]
[-0.0125 .22 -24 -4.5 ]
[-0.0125 .22 0 4.5 ]
[-0.0125 .4113 -6 -4.5 ]
[-0.0125 .4113 0 4.5 ]
[-0.0125 .60261 -18 -4.5 ]
[-0.0125 .60261 0 4.5 ]
[-0.0125 .79391 -6 -4.5 ]
[-0.0125 .79391 0 4.5 ]
[-0.0125 .98521 -18 -4.5 ]
[-0.0125 .98521 0 4.5 ]
[-0.0125 1.17651 -6 -4.5 ]
[-0.0125 1.17651 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1.20521 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1.20521 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01967 0 m
.01967 .00625 L
s
[(-1.5)] .01967 -0.0125 0 1 Mshowa
.21098 0 m
.21098 .00625 L
s
[(-1)] .21098 -0.0125 0 1 Mshowa
.40228 0 m
.40228 .00625 L
s
[(-0.5)] .40228 -0.0125 0 1 Mshowa
.59358 0 m
.59358 .00625 L
s
[(0)] .59358 -0.0125 0 1 Mshowa
.78489 0 m
.78489 .00625 L
s
[(0.5)] .78489 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05794 0 m
.05794 .00375 L
s
.0962 0 m
.0962 .00375 L
s
.13446 0 m
.13446 .00375 L
s
.17272 0 m
.17272 .00375 L
s
.24924 0 m
.24924 .00375 L
s
.2875 0 m
.2875 .00375 L
s
.32576 0 m
.32576 .00375 L
s
.36402 0 m
.36402 .00375 L
s
.44054 0 m
.44054 .00375 L
s
.4788 0 m
.4788 .00375 L
s
.51706 0 m
.51706 .00375 L
s
.55532 0 m
.55532 .00375 L
s
.63184 0 m
.63184 .00375 L
s
.67011 0 m
.67011 .00375 L
s
.70837 0 m
.70837 .00375 L
s
.74663 0 m
.74663 .00375 L
s
.82315 0 m
.82315 .00375 L
s
.86141 0 m
.86141 .00375 L
s
.89967 0 m
.89967 .00375 L
s
.93793 0 m
.93793 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .0287 m
.00625 .0287 L
s
[(-1)] -0.0125 .0287 1 0 Mshowa
0 .22 m
.00625 .22 L
s
[(-0.5)] -0.0125 .22 1 0 Mshowa
0 .4113 m
.00625 .4113 L
s
[(0)] -0.0125 .4113 1 0 Mshowa
0 .60261 m
.00625 .60261 L
s
[(0.5)] -0.0125 .60261 1 0 Mshowa
0 .79391 m
.00625 .79391 L
s
[(1)] -0.0125 .79391 1 0 Mshowa
0 .98521 m
.00625 .98521 L
s
[(1.5)] -0.0125 .98521 1 0 Mshowa
0 1.17651 m
.00625 1.17651 L
s
[(2)] -0.0125 1.17651 1 0 Mshowa
.125 Mabswid
0 .06696 m
.00375 .06696 L
s
0 .10522 m
.00375 .10522 L
s
0 .14348 m
.00375 .14348 L
s
0 .18174 m
.00375 .18174 L
s
0 .25826 m
.00375 .25826 L
s
0 .29652 m
.00375 .29652 L
s
0 .33478 m
.00375 .33478 L
s
0 .37304 m
.00375 .37304 L
s
0 .44956 m
.00375 .44956 L
s
0 .48782 m
.00375 .48782 L
s
0 .52608 m
.00375 .52608 L
s
0 .56434 m
.00375 .56434 L
s
0 .64087 m
.00375 .64087 L
s
0 .67913 m
.00375 .67913 L
s
0 .71739 m
.00375 .71739 L
s
0 .75565 m
.00375 .75565 L
s
0 .83217 m
.00375 .83217 L
s
0 .87043 m
.00375 .87043 L
s
0 .90869 m
.00375 .90869 L
s
0 .94695 m
.00375 .94695 L
s
0 1.02347 m
.00375 1.02347 L
s
0 1.06173 m
.00375 1.06173 L
s
0 1.09999 m
.00375 1.09999 L
s
0 1.13825 m
.00375 1.13825 L
s
.25 Mabswid
0 0 m
0 1.20521 L
s
.01967 1.19896 m
.01967 1.20521 L
s
.21098 1.19896 m
.21098 1.20521 L
s
.40228 1.19896 m
.40228 1.20521 L
s
.59358 1.19896 m
.59358 1.20521 L
s
.78489 1.19896 m
.78489 1.20521 L
s
.97619 1.19896 m
.97619 1.20521 L
s
.125 Mabswid
.05794 1.20146 m
.05794 1.20521 L
s
.0962 1.20146 m
.0962 1.20521 L
s
.13446 1.20146 m
.13446 1.20521 L
s
.17272 1.20146 m
.17272 1.20521 L
s
.24924 1.20146 m
.24924 1.20521 L
s
.2875 1.20146 m
.2875 1.20521 L
s
.32576 1.20146 m
.32576 1.20521 L
s
.36402 1.20146 m
.36402 1.20521 L
s
.44054 1.20146 m
.44054 1.20521 L
s
.4788 1.20146 m
.4788 1.20521 L
s
.51706 1.20146 m
.51706 1.20521 L
s
.55532 1.20146 m
.55532 1.20521 L
s
.63184 1.20146 m
.63184 1.20521 L
s
.67011 1.20146 m
.67011 1.20521 L
s
.70837 1.20146 m
.70837 1.20521 L
s
.74663 1.20146 m
.74663 1.20521 L
s
.82315 1.20146 m
.82315 1.20521 L
s
.86141 1.20146 m
.86141 1.20521 L
s
.89967 1.20146 m
.89967 1.20521 L
s
.93793 1.20146 m
.93793 1.20521 L
s
.25 Mabswid
0 1.20521 m
1 1.20521 L
s
.99375 .0287 m
1 .0287 L
s
.99375 .22 m
1 .22 L
s
.99375 .4113 m
1 .4113 L
s
.99375 .60261 m
1 .60261 L
s
.99375 .79391 m
1 .79391 L
s
.99375 .98521 m
1 .98521 L
s
.99375 1.17651 m
1 1.17651 L
s
.125 Mabswid
.99625 .06696 m
1 .06696 L
s
.99625 .10522 m
1 .10522 L
s
.99625 .14348 m
1 .14348 L
s
.99625 .18174 m
1 .18174 L
s
.99625 .25826 m
1 .25826 L
s
.99625 .29652 m
1 .29652 L
s
.99625 .33478 m
1 .33478 L
s
.99625 .37304 m
1 .37304 L
s
.99625 .44956 m
1 .44956 L
s
.99625 .48782 m
1 .48782 L
s
.99625 .52608 m
1 .52608 L
s
.99625 .56434 m
1 .56434 L
s
.99625 .64087 m
1 .64087 L
s
.99625 .67913 m
1 .67913 L
s
.99625 .71739 m
1 .71739 L
s
.99625 .75565 m
1 .75565 L
s
.99625 .83217 m
1 .83217 L
s
.99625 .87043 m
1 .87043 L
s
.99625 .90869 m
1 .90869 L
s
.99625 .94695 m
1 .94695 L
s
.99625 1.02347 m
1 1.02347 L
s
.99625 1.06173 m
1 1.06173 L
s
.99625 1.09999 m
1 1.09999 L
s
.99625 1.13825 m
1 1.13825 L
s
.25 Mabswid
1 0 m
1 1.20521 L
s
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
0 0 Mdot
grestore
} def
% End of user PostScript
.0001 w
.59358 .79391 m
.59358 .79391 L
s
% Start of user PostScript
0 1. MAarrowzero1
% End of user PostScript
.66823 .78656 m
.66837 .7869 L
s
% Start of user PostScript
0.19509 0.980785 0.195464 0.981688 MAarrowhead1
% End of user PostScript
.74 .76478 m
.74106 .76584 L
s
% Start of user PostScript
0.382683 0.92388 0.385446 0.926642 MAarrowhead1
% End of user PostScript
.80615 .72943 m
.80926 .73071 L
s
% Start of user PostScript
0.55557 0.83147 0.56369 0.834833 MAarrowhead1
% End of user PostScript
.86413 .68185 m
.87011 .68185 L
s
% Start of user PostScript
0.707107 0.707107 0.722732 0.707107 MAarrowhead1
% End of user PostScript
.91171 .62387 m
.92034 .62029 L
s
% Start of user PostScript
0.83147 0.55557 0.854025 0.546227 MAarrowhead1
% End of user PostScript
.94707 .55772 m
.95658 .54821 L
s
% Start of user PostScript
0.92388 0.382683 0.948739 0.357824 MAarrowhead1
% End of user PostScript
.96884 .48594 m
.97585 .46903 L
s
% Start of user PostScript
0.980785 0.19509 0.999097 0.150881 MAarrowhead1
% End of user PostScript
.97619 .4113 m
.97619 .38739 L
s
% Start of user PostScript
1. 0 1. -0.0625 MAarrowhead1
% End of user PostScript
.96884 .33666 m
.95726 .3087 L
s
% Start of user PostScript
0.980785 -0.19509 0.950514 -0.268171 MAarrowhead1
% End of user PostScript
.94707 .26488 m
.92065 .23846 L
s
% Start of user PostScript
0.92388 -0.382683 0.854826 -0.451737 MAarrowhead1
% End of user PostScript
.91171 .19874 m
.86994 .18144 L
s
% Start of user PostScript
0.83147 -0.55557 0.7223 -0.60079 MAarrowhead1
% End of user PostScript
.86413 .14076 m
.81032 .14076 L
s
% Start of user PostScript
0.707107 -0.707107 0.566482 -0.707107 MAarrowhead1
% End of user PostScript
.80615 .09318 m
.74781 .11734 L
s
% Start of user PostScript
0.55557 -0.83147 0.403094 -0.768312 MAarrowhead1
% End of user PostScript
.74 .05782 m
.68822 .1096 L
s
% Start of user PostScript
0.382683 -0.92388 0.247339 -0.788535 MAarrowhead1
% End of user PostScript
.66823 .03605 m
.63606 .11372 L
s
% Start of user PostScript
0.19509 -0.980785 0.111005 -0.777784 MAarrowhead1
% End of user PostScript
.59358 .0287 m
.59358 .12435 L
s
% Start of user PostScript
0 -1. 0 -0.75 MAarrowhead1
% End of user PostScript
.51894 .03605 m
.56026 .13581 L
s
% Start of user PostScript
-0.19509 -0.980785 -0.0870869 -0.720042 MAarrowhead1
% End of user PostScript
.44717 .05782 m
.53277 .14342 L
s
% Start of user PostScript
-0.382683 -0.92388 -0.15895 -0.700147 MAarrowhead1
% End of user PostScript
.38102 .09318 m
.50564 .14479 L
s
% Start of user PostScript
-0.55557 -0.83147 -0.229867 -0.696559 MAarrowhead1
% End of user PostScript
.32304 .14076 m
.4725 .14076 L
s
% Start of user PostScript
-0.707107 -0.707107 -0.316482 -0.707107 MAarrowhead1
% End of user PostScript
.27546 .19874 m
.42769 .13568 L
s
% Start of user PostScript
-0.83147 -0.55557 -0.433588 -0.720378 MAarrowhead1
% End of user PostScript
.2401 .26488 m
.36798 .13701 L
s
% Start of user PostScript
-0.92388 -0.382683 -0.589661 -0.716902 MAarrowhead1
% End of user PostScript
.21833 .33666 m
.29397 .15405 L
s
% Start of user PostScript
-0.980785 -0.19509 -0.78309 -0.672368 MAarrowhead1
% End of user PostScript
.21098 .4113 m
.21098 .19609 L
s
% Start of user PostScript
-1. 0 -1. -0.5625 MAarrowhead1
% End of user PostScript
.21833 .48594 m
.12896 .2702 L
s
% Start of user PostScript
-0.980785 0.19509 -1.21436 -0.368801 MAarrowhead1
% End of user PostScript
.2401 .55772 m
.0615 .37912 L
s
% Start of user PostScript
-0.92388 0.382683 -1.39068 -0.0841175 MAarrowhead1
% End of user PostScript
.27546 .62387 m
.02381 .51963 L
s
% Start of user PostScript
-0.83147 0.55557 -1.48919 0.283133 MAarrowhead1
% End of user PostScript
.32304 .68185 m
.03011 .68185 L
s
% Start of user PostScript
-0.707107 0.707107 -1.47273 0.707107 MAarrowhead1
% End of user PostScript
.38102 .72943 m
.09071 .84968 L
s
% Start of user PostScript
-0.55557 0.83147 -1.31434 1.14576 MAarrowhead1
% End of user PostScript
.44717 .76478 m
.20938 1.00257 L
s
% Start of user PostScript
-0.382683 0.92388 -1.00416 1.54536 MAarrowhead1
% End of user PostScript
.51894 .78656 m
.38153 1.11829 L
s
% Start of user PostScript
-0.19509 0.980785 -0.55423 1.84782 MAarrowhead1
% End of user PostScript
.59358 .79391 m
.59358 1.17651 L
s
% Start of user PostScript
0 1. 0 2. MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 1.20521 L
0 1.20521 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.39.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.39.1"]
}, Open  ]],

Cell["\<\
In this plot, the vectors are all scaled by a function that converts their \
lengths to a constant. \
\>", "MathCaption",
 CellTags->{"S5.39.1", "1.21"}],

Cell[CellGroupData[{

Cell["\<\
ListPlotVectorField[
    vectors,
    ScaleFunction->(.4&),
    Frame -> True]\
\>", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.39.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .99443 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.394615 0.418292 0.394615 [
[.10539 -0.0125 -6 -9 ]
[.10539 -0.0125 6 0 ]
[.30269 -0.0125 -12 -9 ]
[.30269 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.69731 -0.0125 -9 -9 ]
[.69731 -0.0125 9 0 ]
[.89461 -0.0125 -3 -9 ]
[.89461 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02368 -12 -4.5 ]
[-0.0125 .02368 0 4.5 ]
[-0.0125 .22098 -24 -4.5 ]
[-0.0125 .22098 0 4.5 ]
[-0.0125 .41829 -6 -4.5 ]
[-0.0125 .41829 0 4.5 ]
[-0.0125 .6156 -18 -4.5 ]
[-0.0125 .6156 0 4.5 ]
[-0.0125 .81291 -6 -4.5 ]
[-0.0125 .81291 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .99443 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .99443 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10539 0 m
.10539 .00625 L
s
[(-1)] .10539 -0.0125 0 1 Mshowa
.30269 0 m
.30269 .00625 L
s
[(-0.5)] .30269 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.69731 0 m
.69731 .00625 L
s
[(0.5)] .69731 -0.0125 0 1 Mshowa
.89461 0 m
.89461 .00625 L
s
[(1)] .89461 -0.0125 0 1 Mshowa
.125 Mabswid
.14485 0 m
.14485 .00375 L
s
.18431 0 m
.18431 .00375 L
s
.22377 0 m
.22377 .00375 L
s
.26323 0 m
.26323 .00375 L
s
.34215 0 m
.34215 .00375 L
s
.38162 0 m
.38162 .00375 L
s
.42108 0 m
.42108 .00375 L
s
.46054 0 m
.46054 .00375 L
s
.53946 0 m
.53946 .00375 L
s
.57892 0 m
.57892 .00375 L
s
.61838 0 m
.61838 .00375 L
s
.65785 0 m
.65785 .00375 L
s
.73677 0 m
.73677 .00375 L
s
.77623 0 m
.77623 .00375 L
s
.81569 0 m
.81569 .00375 L
s
.85515 0 m
.85515 .00375 L
s
.06592 0 m
.06592 .00375 L
s
.02646 0 m
.02646 .00375 L
s
.93408 0 m
.93408 .00375 L
s
.97354 0 m
.97354 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02368 m
.00625 .02368 L
s
[(-1)] -0.0125 .02368 1 0 Mshowa
0 .22098 m
.00625 .22098 L
s
[(-0.5)] -0.0125 .22098 1 0 Mshowa
0 .41829 m
.00625 .41829 L
s
[(0)] -0.0125 .41829 1 0 Mshowa
0 .6156 m
.00625 .6156 L
s
[(0.5)] -0.0125 .6156 1 0 Mshowa
0 .81291 m
.00625 .81291 L
s
[(1)] -0.0125 .81291 1 0 Mshowa
.125 Mabswid
0 .06314 m
.00375 .06314 L
s
0 .1026 m
.00375 .1026 L
s
0 .14206 m
.00375 .14206 L
s
0 .18152 m
.00375 .18152 L
s
0 .26045 m
.00375 .26045 L
s
0 .29991 m
.00375 .29991 L
s
0 .33937 m
.00375 .33937 L
s
0 .37883 m
.00375 .37883 L
s
0 .45775 m
.00375 .45775 L
s
0 .49721 m
.00375 .49721 L
s
0 .53668 m
.00375 .53668 L
s
0 .57614 m
.00375 .57614 L
s
0 .65506 m
.00375 .65506 L
s
0 .69452 m
.00375 .69452 L
s
0 .73398 m
.00375 .73398 L
s
0 .77345 m
.00375 .77345 L
s
0 .85237 m
.00375 .85237 L
s
0 .89183 m
.00375 .89183 L
s
0 .93129 m
.00375 .93129 L
s
0 .97075 m
.00375 .97075 L
s
.25 Mabswid
0 0 m
0 .99443 L
s
.10539 .98818 m
.10539 .99443 L
s
.30269 .98818 m
.30269 .99443 L
s
.5 .98818 m
.5 .99443 L
s
.69731 .98818 m
.69731 .99443 L
s
.89461 .98818 m
.89461 .99443 L
s
.125 Mabswid
.14485 .99068 m
.14485 .99443 L
s
.18431 .99068 m
.18431 .99443 L
s
.22377 .99068 m
.22377 .99443 L
s
.26323 .99068 m
.26323 .99443 L
s
.34215 .99068 m
.34215 .99443 L
s
.38162 .99068 m
.38162 .99443 L
s
.42108 .99068 m
.42108 .99443 L
s
.46054 .99068 m
.46054 .99443 L
s
.53946 .99068 m
.53946 .99443 L
s
.57892 .99068 m
.57892 .99443 L
s
.61838 .99068 m
.61838 .99443 L
s
.65785 .99068 m
.65785 .99443 L
s
.73677 .99068 m
.73677 .99443 L
s
.77623 .99068 m
.77623 .99443 L
s
.81569 .99068 m
.81569 .99443 L
s
.85515 .99068 m
.85515 .99443 L
s
.06592 .99068 m
.06592 .99443 L
s
.02646 .99068 m
.02646 .99443 L
s
.93408 .99068 m
.93408 .99443 L
s
.97354 .99068 m
.97354 .99443 L
s
.25 Mabswid
0 .99443 m
1 .99443 L
s
.99375 .02368 m
1 .02368 L
s
.99375 .22098 m
1 .22098 L
s
.99375 .41829 m
1 .41829 L
s
.99375 .6156 m
1 .6156 L
s
.99375 .81291 m
1 .81291 L
s
.125 Mabswid
.99625 .06314 m
1 .06314 L
s
.99625 .1026 m
1 .1026 L
s
.99625 .14206 m
1 .14206 L
s
.99625 .18152 m
1 .18152 L
s
.99625 .26045 m
1 .26045 L
s
.99625 .29991 m
1 .29991 L
s
.99625 .33937 m
1 .33937 L
s
.99625 .37883 m
1 .37883 L
s
.99625 .45775 m
1 .45775 L
s
.99625 .49721 m
1 .49721 L
s
.99625 .53668 m
1 .53668 L
s
.99625 .57614 m
1 .57614 L
s
.99625 .65506 m
1 .65506 L
s
.99625 .69452 m
1 .69452 L
s
.99625 .73398 m
1 .73398 L
s
.99625 .77345 m
1 .77345 L
s
.99625 .85237 m
1 .85237 L
s
.99625 .89183 m
1 .89183 L
s
.99625 .93129 m
1 .93129 L
s
.99625 .97075 m
1 .97075 L
s
.25 Mabswid
1 0 m
1 .99443 L
s
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
0 0 Mdot
grestore
} def
% End of user PostScript
.0001 w
.5 .81291 m
.5 .81291 L
s
% Start of user PostScript
0 1. MAarrowzero1
% End of user PostScript
.57699 .80532 m
.63739 .95115 L
s
% Start of user PostScript
0.19509 0.980785 0.348164 1.35034 MAarrowhead1
% End of user PostScript
.65101 .78287 m
.76263 .89448 L
s
% Start of user PostScript
0.382683 0.92388 0.665526 1.20672 MAarrowhead1
% End of user PostScript
.71924 .7464 m
.86507 .80681 L
s
% Start of user PostScript
0.55557 0.83147 0.925122 0.984543 MAarrowhead1
% End of user PostScript
.77903 .69733 m
.93688 .69733 L
s
% Start of user PostScript
0.707107 0.707107 1.10711 0.707107 MAarrowhead1
% End of user PostScript
.82811 .63753 m
.97394 .57712 L
s
% Start of user PostScript
0.83147 0.55557 1.20102 0.402497 MAarrowhead1
% End of user PostScript
.86458 .5693 m
.97619 .45769 L
s
% Start of user PostScript
0.92388 0.382683 1.20672 0.0998407 MAarrowhead1
% End of user PostScript
.88703 .49528 m
.94744 .34945 L
s
% Start of user PostScript
0.980785 0.19509 1.13386 -0.174461 MAarrowhead1
% End of user PostScript
.89461 .41829 m
.89461 .26045 L
s
% Start of user PostScript
1. 0 1. -0.4 MAarrowhead1
% End of user PostScript
.88703 .34131 m
.82663 .19548 L
s
% Start of user PostScript
0.980785 -0.19509 0.827712 -0.564642 MAarrowhead1
% End of user PostScript
.86458 .26728 m
.75296 .15567 L
s
% Start of user PostScript
0.92388 -0.382683 0.641037 -0.665526 MAarrowhead1
% End of user PostScript
.82811 .19906 m
.68228 .13865 L
s
% Start of user PostScript
0.83147 -0.55557 0.461918 -0.708644 MAarrowhead1
% End of user PostScript
.77903 .13926 m
.62119 .13926 L
s
% Start of user PostScript
0.707107 -0.707107 0.307107 -0.707107 MAarrowhead1
% End of user PostScript
.71924 .09018 m
.57341 .15059 L
s
% Start of user PostScript
0.55557 -0.83147 0.186018 -0.678396 MAarrowhead1
% End of user PostScript
.65101 .05372 m
.5394 .16533 L
s
% Start of user PostScript
0.382683 -0.92388 0.0998407 -0.641037 MAarrowhead1
% End of user PostScript
.57699 .03126 m
.51658 .17709 L
s
% Start of user PostScript
0.19509 -0.980785 0.0420169 -0.611233 MAarrowhead1
% End of user PostScript
.5 .02368 m
.5 .18152 L
s
% Start of user PostScript
0 -1. 0 -0.6 MAarrowhead1
% End of user PostScript
.42301 .03126 m
.48342 .17709 L
s
% Start of user PostScript
-0.19509 -0.980785 -0.0420169 -0.611233 MAarrowhead1
% End of user PostScript
.34899 .05372 m
.4606 .16533 L
s
% Start of user PostScript
-0.382683 -0.92388 -0.0998407 -0.641037 MAarrowhead1
% End of user PostScript
.28076 .09018 m
.42659 .15059 L
s
% Start of user PostScript
-0.55557 -0.83147 -0.186018 -0.678396 MAarrowhead1
% End of user PostScript
.22097 .13926 m
.37881 .13926 L
s
% Start of user PostScript
-0.707107 -0.707107 -0.307107 -0.707107 MAarrowhead1
% End of user PostScript
.17189 .19906 m
.31772 .13865 L
s
% Start of user PostScript
-0.83147 -0.55557 -0.461918 -0.708644 MAarrowhead1
% End of user PostScript
.13542 .26728 m
.24704 .15567 L
s
% Start of user PostScript
-0.92388 -0.382683 -0.641037 -0.665526 MAarrowhead1
% End of user PostScript
.11297 .34131 m
.17337 .19548 L
s
% Start of user PostScript
-0.980785 -0.19509 -0.827712 -0.564642 MAarrowhead1
% End of user PostScript
.10539 .41829 m
.10539 .26045 L
s
% Start of user PostScript
-1. 0 -1. -0.4 MAarrowhead1
% End of user PostScript
.11297 .49528 m
.05256 .34945 L
s
% Start of user PostScript
-0.980785 0.19509 -1.13386 -0.174461 MAarrowhead1
% End of user PostScript
.13542 .5693 m
.02381 .45769 L
s
% Start of user PostScript
-0.92388 0.382683 -1.20672 0.0998407 MAarrowhead1
% End of user PostScript
.17189 .63753 m
.02606 .57712 L
s
% Start of user PostScript
-0.83147 0.55557 -1.20102 0.402497 MAarrowhead1
% End of user PostScript
.22097 .69733 m
.06312 .69733 L
s
% Start of user PostScript
-0.707107 0.707107 -1.10711 0.707107 MAarrowhead1
% End of user PostScript
.28076 .7464 m
.13493 .80681 L
s
% Start of user PostScript
-0.55557 0.83147 -0.925122 0.984543 MAarrowhead1
% End of user PostScript
.34899 .78287 m
.23737 .89448 L
s
% Start of user PostScript
-0.382683 0.92388 -0.665526 1.20672 MAarrowhead1
% End of user PostScript
.42301 .80532 m
.36261 .95115 L
s
% Start of user PostScript
-0.19509 0.980785 -0.348164 1.35034 MAarrowhead1
% End of user PostScript
.5 .81291 m
.5 .97075 L
s
% Start of user PostScript
0 1. 0 1.4 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 .99443 L
0 .99443 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.39.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.39.1"]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 StyleBox["ListPlotVectorField", "MR"],
 " treats the option ",
 StyleBox["ScaleFactor", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["Automatic", "MR"],
 " the same as ",
 StyleBox["ScaleFactor", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["None", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.39.1", "1.22"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.39.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.39.1", "1.1"}],
    Cell[1913, 61, 557, 9, 88, "Text",
      CellTags->{"S5.39.1", "1.2"}],
    Cell[2473, 72, 231, 6, 40, "Text",
      CellTags->{"S5.39.1", "1.3"}],
    Cell[2707, 80, 6662, 210, 198, "DefinitionBox",
      CellTags->"S5.39.1"],
    Cell[9372, 292, 83, 1, 15, "Caption",
      CellTags->"S5.39.1"],
    Cell[9458, 295, 78, 1, 40, "MathCaption",
      CellTags->{"S5.39.1", "1.4"}],
    Cell[9539, 298, 84, 2, 28, "Input",
      CellTags->"S5.39.1"],
    Cell[9626, 302, 511, 19, 40, "MathCaption",
      CellTags->{"S5.39.1", "1.5"}],
    Cell[10162, 325, 141, 5, 45, "Input",
      CellTags->"S5.39.1"],
    Cell[10306, 332, 30223, 1441, 186, 30152, 1438, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.39.1"],
    Cell[40532, 1775, 180, 6, 70, "Output",
      CellTags->"S5.39.1"],
    Cell[40727, 1784, 2105, 72, 70, "Text",
      CellTags->{"S5.39.1", "1.6"}],
    Cell[42835, 1858, 387, 10, 70, "Text",
      CellTags->{"S5.39.1", "1.7"}],
    Cell[43225, 1870, 364, 14, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.8"}],
    Cell[43614, 1888, 137, 5, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[43754, 1895, 30501, 1441, 70, 30430, 1438, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.39.1"],
    Cell[74258, 3338, 180, 6, 70, "Output",
      CellTags->"S5.39.1"],
    Cell[74453, 3347, 165, 4, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.9"}],
    Cell[74643, 3355, 140, 5, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[74786, 3362, 30719, 1441, 70, 30648, 1438, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.39.1"],
    Cell[105508, 4805, 180, 6, 70, "Output",
      CellTags->"S5.39.1"],
    Cell[105703, 4814, 6087, 175, 70, "DefinitionBox3Col",
      CellTags->"S5.39.1"],
    Cell[111793, 4991, 75, 1, 70, "Caption",
      CellTags->"S5.39.1"],
    Cell[111871, 4994, 182, 4, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.10"}],
    Cell[112078, 5002, 204, 8, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[112285, 5012, 53295, 2485, 70, 53224, 2482, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.39.1"],
    Cell[165583, 7499, 180, 6, 70, "Output",
      CellTags->"S5.39.1"],
    Cell[165778, 7508, 1496, 35, 70, "Text",
      CellTags->{"S5.39.1", "1.11"}],
    Cell[167277, 7545, 718, 17, 70, "Text",
      CellTags->{"S5.39.1", "1.12"}],
    Cell[167998, 7564, 243, 6, 70, "Text",
      CellTags->{"S5.39.1", "1.13"}],
    Cell[168244, 7572, 594, 17, 70, "Text",
      CellTags->{"S5.39.1", "1.14"}],
    Cell[168841, 7591, 2248, 70, 70, "DefinitionBox",
      CellTags->"S5.39.1"],
    Cell[171092, 7663, 121, 3, 70, "Caption",
      CellTags->"S5.39.1"],
    Cell[171216, 7668, 393, 12, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.15"}],
    Cell[171634, 7684, 140, 5, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[171777, 7691, 30365, 1435, 70, 30294, 1432, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.39.1"],
    Cell[202145, 9128, 180, 6, 70, "Output",
      CellTags->"S5.39.1"],
    Cell[202340, 9137, 4805, 147, 70, "DefinitionBox",
      CellTags->"S5.39.1"],
    Cell[207148, 9286, 70, 1, 70, "Caption",
      CellTags->"S5.39.1"],
    Cell[207221, 9289, 94, 1, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.16"}],
    Cell[207318, 9292, 187, 7, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[207508, 9301, 101, 1, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.17"}],
    Cell[207634, 9306, 90, 2, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[207727, 9310, 13320, 685, 70, 13249, 682, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.39.1"],
    Cell[221050, 9997, 180, 6, 70, "Output",
      CellTags->"S5.39.1"],
    Cell[221245, 10006, 238, 9, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.18"}],
    Cell[221486, 10017, 166, 6, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[221655, 10025, 105, 1, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.19"}],
    Cell[221785, 10030, 150, 8, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[221938, 10040, 10440, 698, 70, 10369, 695, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.39.1"],
    Cell[232381, 10740, 181, 6, 70, "Output",
      CellTags->"S5.39.1"],
    Cell[232577, 10749, 181, 4, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.20"}],
    Cell[232783, 10757, 147, 8, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[232933, 10767, 10493, 695, 70, 10422, 692, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.39.1"],
    Cell[243429, 11464, 181, 6, 70, "Output",
      CellTags->"S5.39.1"],
    Cell[243625, 11473, 163, 4, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.21"}],
    Cell[243813, 11481, 150, 7, 70, "Input",
      CellTags->"S5.39.1"],
    Cell[243966, 11490, 9737, 644, 70, 9666, 641, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.39.1"],
    Cell[253706, 12136, 181, 6, 70, "Output",
      CellTags->"S5.39.1"],
    Cell[253902, 12145, 351, 17, 70, "Text",
      CellTags->{"S5.39.1", "1.22"}]},
  "1.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.39.1", "1.1"}]},
  "1.2"->{
    Cell[1913, 61, 557, 9, 88, "Text",
      CellTags->{"S5.39.1", "1.2"}]},
  "1.3"->{
    Cell[2473, 72, 231, 6, 40, "Text",
      CellTags->{"S5.39.1", "1.3"}]},
  "1.4"->{
    Cell[9458, 295, 78, 1, 40, "MathCaption",
      CellTags->{"S5.39.1", "1.4"}]},
  "1.5"->{
    Cell[9626, 302, 511, 19, 40, "MathCaption",
      CellTags->{"S5.39.1", "1.5"}]},
  "1.6"->{
    Cell[40727, 1784, 2105, 72, 70, "Text",
      CellTags->{"S5.39.1", "1.6"}]},
  "1.7"->{
    Cell[42835, 1858, 387, 10, 70, "Text",
      CellTags->{"S5.39.1", "1.7"}]},
  "1.8"->{
    Cell[43225, 1870, 364, 14, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.8"}]},
  "1.9"->{
    Cell[74453, 3347, 165, 4, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.9"}]},
  "1.10"->{
    Cell[111871, 4994, 182, 4, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.10"}]},
  "1.11"->{
    Cell[165778, 7508, 1496, 35, 70, "Text",
      CellTags->{"S5.39.1", "1.11"}]},
  "1.12"->{
    Cell[167277, 7545, 718, 17, 70, "Text",
      CellTags->{"S5.39.1", "1.12"}]},
  "1.13"->{
    Cell[167998, 7564, 243, 6, 70, "Text",
      CellTags->{"S5.39.1", "1.13"}]},
  "1.14"->{
    Cell[168244, 7572, 594, 17, 70, "Text",
      CellTags->{"S5.39.1", "1.14"}]},
  "1.15"->{
    Cell[171216, 7668, 393, 12, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.15"}]},
  "1.16"->{
    Cell[207221, 9289, 94, 1, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.16"}]},
  "1.17"->{
    Cell[207508, 9301, 101, 1, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.17"}]},
  "1.18"->{
    Cell[221245, 10006, 238, 9, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.18"}]},
  "1.19"->{
    Cell[221655, 10025, 105, 1, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.19"}]},
  "1.20"->{
    Cell[232577, 10749, 181, 4, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.20"}]},
  "1.21"->{
    Cell[243625, 11473, 163, 4, 70, "MathCaption",
      CellTags->{"S5.39.1", "1.21"}]},
  "1.22"->{
    Cell[253902, 12145, 351, 17, 70, "Text",
      CellTags->{"S5.39.1", "1.22"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.39.1", 254892, 12181},
  {"1.1", 260310, 12320},
  {"1.2", 260404, 12323},
  {"1.3", 260492, 12326},
  {"1.4", 260580, 12329},
  {"1.5", 260675, 12332},
  {"1.6", 260772, 12335},
  {"1.7", 260865, 12338},
  {"1.8", 260957, 12341},
  {"1.9", 261056, 12344},
  {"1.10", 261155, 12347},
  {"1.11", 261256, 12350},
  {"1.12", 261352, 12353},
  {"1.13", 261447, 12356},
  {"1.14", 261541, 12359},
  {"1.15", 261636, 12362},
  {"1.16", 261738, 12365},
  {"1.17", 261838, 12368},
  {"1.18", 261939, 12371},
  {"1.19", 262041, 12374},
  {"1.20", 262143, 12377},
  {"1.21", 262245, 12380},
  {"1.22", 262347, 12383}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 6, 36, "Subsection",
  CellTags->{"S5.39.1", "1.1"}],
Cell[1913, 61, 557, 9, 88, "Text",
  CellTags->{"S5.39.1", "1.2"}],
Cell[2473, 72, 231, 6, 40, "Text",
  CellTags->{"S5.39.1", "1.3"}],
Cell[2707, 80, 6662, 210, 198, "DefinitionBox",
  CellTags->"S5.39.1"],
Cell[9372, 292, 83, 1, 15, "Caption",
  CellTags->"S5.39.1"],
Cell[9458, 295, 78, 1, 40, "MathCaption",
  CellTags->{"S5.39.1", "1.4"}],
Cell[9539, 298, 84, 2, 28, "Input",
  CellTags->"S5.39.1"],
Cell[9626, 302, 511, 19, 40, "MathCaption",
  CellTags->{"S5.39.1", "1.5"}],

Cell[CellGroupData[{
Cell[10162, 325, 141, 5, 45, "Input",
  CellTags->"S5.39.1"],
Cell[10306, 332, 30223, 1441, 186, 30152, 1438, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.39.1"],
Cell[40532, 1775, 180, 6, 70, "Output",
  CellTags->"S5.39.1"]
}, Open  ]],
Cell[40727, 1784, 2105, 72, 70, "Text",
  CellTags->{"S5.39.1", "1.6"}],
Cell[42835, 1858, 387, 10, 70, "Text",
  CellTags->{"S5.39.1", "1.7"}],
Cell[43225, 1870, 364, 14, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.8"}],

Cell[CellGroupData[{
Cell[43614, 1888, 137, 5, 70, "Input",
  CellTags->"S5.39.1"],
Cell[43754, 1895, 30501, 1441, 70, 30430, 1438, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.39.1"],
Cell[74258, 3338, 180, 6, 70, "Output",
  CellTags->"S5.39.1"]
}, Open  ]],
Cell[74453, 3347, 165, 4, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.9"}],

Cell[CellGroupData[{
Cell[74643, 3355, 140, 5, 70, "Input",
  CellTags->"S5.39.1"],
Cell[74786, 3362, 30719, 1441, 70, 30648, 1438, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.39.1"],
Cell[105508, 4805, 180, 6, 70, "Output",
  CellTags->"S5.39.1"]
}, Open  ]],
Cell[105703, 4814, 6087, 175, 70, "DefinitionBox3Col",
  CellTags->"S5.39.1"],
Cell[111793, 4991, 75, 1, 70, "Caption",
  CellTags->"S5.39.1"],
Cell[111871, 4994, 182, 4, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.10"}],

Cell[CellGroupData[{
Cell[112078, 5002, 204, 8, 70, "Input",
  CellTags->"S5.39.1"],
Cell[112285, 5012, 53295, 2485, 70, 53224, 2482, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.39.1"],
Cell[165583, 7499, 180, 6, 70, "Output",
  CellTags->"S5.39.1"]
}, Open  ]],
Cell[165778, 7508, 1496, 35, 70, "Text",
  CellTags->{"S5.39.1", "1.11"}],
Cell[167277, 7545, 718, 17, 70, "Text",
  CellTags->{"S5.39.1", "1.12"}],
Cell[167998, 7564, 243, 6, 70, "Text",
  CellTags->{"S5.39.1", "1.13"}],
Cell[168244, 7572, 594, 17, 70, "Text",
  CellTags->{"S5.39.1", "1.14"}],
Cell[168841, 7591, 2248, 70, 70, "DefinitionBox",
  CellTags->"S5.39.1"],
Cell[171092, 7663, 121, 3, 70, "Caption",
  CellTags->"S5.39.1"],
Cell[171216, 7668, 393, 12, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.15"}],

Cell[CellGroupData[{
Cell[171634, 7684, 140, 5, 70, "Input",
  CellTags->"S5.39.1"],
Cell[171777, 7691, 30365, 1435, 70, 30294, 1432, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.39.1"],
Cell[202145, 9128, 180, 6, 70, "Output",
  CellTags->"S5.39.1"]
}, Open  ]],
Cell[202340, 9137, 4805, 147, 70, "DefinitionBox",
  CellTags->"S5.39.1"],
Cell[207148, 9286, 70, 1, 70, "Caption",
  CellTags->"S5.39.1"],
Cell[207221, 9289, 94, 1, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.16"}],
Cell[207318, 9292, 187, 7, 70, "Input",
  CellTags->"S5.39.1"],
Cell[207508, 9301, 101, 1, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.17"}],

Cell[CellGroupData[{
Cell[207634, 9306, 90, 2, 70, "Input",
  CellTags->"S5.39.1"],
Cell[207727, 9310, 13320, 685, 70, 13249, 682, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.39.1"],
Cell[221050, 9997, 180, 6, 70, "Output",
  CellTags->"S5.39.1"]
}, Open  ]],
Cell[221245, 10006, 238, 9, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.18"}],
Cell[221486, 10017, 166, 6, 70, "Input",
  CellTags->"S5.39.1"],
Cell[221655, 10025, 105, 1, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.19"}],

Cell[CellGroupData[{
Cell[221785, 10030, 150, 8, 70, "Input",
  CellTags->"S5.39.1"],
Cell[221938, 10040, 10440, 698, 70, 10369, 695, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.39.1"],
Cell[232381, 10740, 181, 6, 70, "Output",
  CellTags->"S5.39.1"]
}, Open  ]],
Cell[232577, 10749, 181, 4, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.20"}],

Cell[CellGroupData[{
Cell[232783, 10757, 147, 8, 70, "Input",
  CellTags->"S5.39.1"],
Cell[232933, 10767, 10493, 695, 70, 10422, 692, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.39.1"],
Cell[243429, 11464, 181, 6, 70, "Output",
  CellTags->"S5.39.1"]
}, Open  ]],
Cell[243625, 11473, 163, 4, 70, "MathCaption",
  CellTags->{"S5.39.1", "1.21"}],

Cell[CellGroupData[{
Cell[243813, 11481, 150, 7, 70, "Input",
  CellTags->"S5.39.1"],
Cell[243966, 11490, 9737, 644, 70, 9666, 641, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.39.1"],
Cell[253706, 12136, 181, 6, 70, "Output",
  CellTags->"S5.39.1"]
}, Open  ]],
Cell[253902, 12145, 351, 17, 70, "Text",
  CellTags->{"S5.39.1", "1.22"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

