(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    136350,       8144]*)
(*NotebookOutlinePosition[    141090,       8284]*)
(*  CellTagsIndexPosition[    140738,       8267]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "PlotField3D",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.40.1", "1.1"}],

Cell["\<\
This package allows the graphical display of vector fields in three \
dimensions. The vector field can be represented by lines or arrows that can \
display direction and magnitude. \
\>", "Text",
 CellTags->{"S5.40.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PlotVectorField3D[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["z",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the vector field given by the vector function in the range \
specified",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotGradientField3D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["plot the gradient vector field of the scalar function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.40.1"],

Cell["Plotting vector fields in three dimensions. ", "Caption",
 CellTags->"S5.40.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.40.1", "1.3"}],

Cell["<<Graphics`PlotField3D`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.40.1"],

Cell[TextData[{
 "The components of this vector field are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["y",
     "TI"], "/", 
    StyleBox["z",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " , ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    StyleBox["x",
     "TI"], "/", 
    StyleBox["z",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.40.1", "1.4"}],

Cell[CellGroupData[{

Cell["\<\
PlotVectorField3D[{y , -x, 0}/z ,
   {x, -1, 1}, {y, -1, 1}, {z, 1, 3}]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.40.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00241 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.020918 1.09352 2.07245e-16 1.09352 [
[ 0 0 0 0 ]
[ 1 1.00241 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07268 .24892 m
0 .70758 L
s
0 .70758 m
.39955 1.00241 L
s
.39955 1.00241 m
.41404 .58795 L
s
.41404 .58795 m
.07268 .24892 L
s
.67739 0 m
.94009 .42007 L
s
.94009 .42007 m
1 .85841 L
s
1 .85841 m
.70529 .48066 L
s
.70529 .48066 m
.67739 0 L
s
.07268 .24892 m
0 .70758 L
s
0 .70758 m
.70529 .48066 L
s
.70529 .48066 m
.67739 0 L
s
.67739 0 m
.07268 .24892 L
s
.41404 .58795 m
.94009 .42007 L
s
.94009 .42007 m
1 .85841 L
s
1 .85841 m
.39955 1.00241 L
s
.39955 1.00241 m
.41404 .58795 L
s
0 0 m
1 0 L
1 1.00241 L
0 1.00241 L
closepath
clip
newpath
.5 Mabswid
.43675 .54557 m
.50752 .5579 L
s
.50124 .52455 m
.5643 .52801 L
s
.39878 .50635 m
.45615 .52429 L
s
.43504 .60612 m
.48924 .61523 L
s
.56736 .50301 m
.62314 .49705 L
s
.50077 .58546 m
.549 .58802 L
s
.46431 .48435 m
.51316 .49319 L
s
.35902 .46529 m
.40269 .48932 L
s
.43327 .66905 m
.47752 .6762 L
s
.39629 .56757 m
.44029 .58084 L
s
.63515 .48091 m
.68413 .46495 L
s
.56817 .56428 m
.6108 .55989 L
s
.53151 .46178 m
.57227 .46095 L
s
.50027 .64879 m
.53963 .6508 L
s
.70468 .45826 m
.74742 .43165 L
s
.4256 .44222 m
.45989 .45693 L
s
.46308 .54592 m
.5005 .55245 L
s
.31733 .42223 m
.34701 .45289 L
s
.43142 .73449 m
.46907 .74032 L
s
.39369 .63124 m
.42967 .64167 L
s
.35566 .52716 m
.38922 .54496 L
s
.63733 .54254 m
.67473 .53078 L
s
.60046 .43862 m
.63359 .42749 L
s
.77603 .43501 m
.81312 .39707 L
s
.56902 .62801 m
.60379 .62456 L
s
.53162 .5237 m
.5628 .52309 L
s
.49392 .41855 m
.51925 .42332 L
s
.49975 .71468 m
.53323 .71632 L
s
.7083 .52023 m
.74092 .50065 L
s
.38498 .39803 m
.40437 .41913 L
s
.46181 .60999 m
.49237 .61512 L
s
.42355 .50444 m
.44986 .51533 L
s
.27356 .37704 m
.28897 .41492 L
s
.67123 .41485 m
.69727 .39276 L
s
.4295 .80259 m
.46245 .80746 L
s
.84927 .41114 m
.88138 .36115 L
s
.39099 .69751 m
.42163 .70602 L
s
.63959 .60667 m
.6701 .59744 L
s
.31303 .48474 m
.3359 .50749 L
s
.35217 .59156 m
.37965 .60558 L
s
.60199 .50089 m
.62731 .49268 L
s
.78115 .49733 m
.80948 .46944 L
s
.56991 .69435 m
.59947 .69154 L
s
.56407 .39425 m
.58088 .38842 L
s
.7439 .39045 m
.76343 .35667 L
s
.53174 .58817 m
.5572 .58769 L
s
.71206 .58476 m
.73867 .5694 L
s
.49326 .48111 m
.51266 .48464 L
s
.49921 .78329 m
.5285 .78466 L
s
.45446 .37317 m
.46394 .38407 L
s
.46048 .67671 m
.4865 .6809 L
s
.34233 .35161 m
.34645 .37969 L
s
.67424 .47747 m
.69415 .46118 L
s
.42142 .56925 m
.44295 .57781 L
s
.38204 .46088 m
.39695 .47653 L
s
.22757 .32954 m
.22841 .3753 L
s
.42749 .87353 m
.45694 .87766 L
s
.85597 .47381 m
.88054 .43708 L
s
.64196 .67346 m
.6679 .66594 L
s
.38818 .76655 m
.41502 .77367 L
s
.63612 .36929 m
.64492 .35216 L
s
.26823 .44018 m
.28017 .46834 L
s
.34853 .65867 m
.37196 .67012 L
s
.30855 .54988 m
.32732 .56782 L
s
.81852 .36539 m
.83223 .31914 L
s
.60357 .56576 m
.62425 .55931 L
s
.78649 .56226 m
.80962 .54039 L
s
.57083 .76346 m
.59669 .76111 L
s
.56487 .45715 m
.57773 .45285 L
s
.74847 .45341 m
.76343 .42852 L
s
.53187 .65534 m
.55352 .65495 L
s
.52584 .34763 m
.52584 .34763 L
s
.71598 .65201 m
.73862 .63949 L
s
.49865 .85479 m
.52482 .85595 L
s
.49258 .54632 m
.50843 .54909 L
s
.71013 .34364 m
.71152 .31445 L
s
.41299 .32547 m
.40619 .34309 L
s
.45295 .43636 m
.46023 .44444 L
s
.4591 .74626 m
.48188 .74977 L
s
.29747 .30279 m
.28597 .33851 L
s
.67738 .54273 m
.69364 .52994 L
s
.41921 .6368 m
.43755 .64381 L
s
.42541 .94747 m
.45215 .95102 L
s
.17918 .27956 m
.16516 .33392 L
s
.86297 .53913 m
.88308 .51035 L
s
.37897 .52642 m
.3912 .53875 L
s
.3384 .41508 m
.34161 .43595 L
s
.64442 .74309 m
.66712 .7368 L
s
.38524 .83853 m
.40925 .84458 L
s
.63846 .43253 m
.6452 .41988 L
s
.82475 .42868 m
.8353 .39465 L
s
.34474 .72865 m
.36529 .73824 L
s
.22111 .39329 m
.22187 .42738 L
s
.60523 .63339 m
.62282 .62812 L
s
.30388 .61782 m
.31993 .6325 L
s
.26267 .50604 m
.27253 .52828 L
s
.5992 .32139 m
.59022 .30974 L
s
.79205 .62995 m
.81176 .61213 L
s
.57179 .83553 m
.5949 .83353 L
s
.78621 .31729 m
.78083 .27521 L
s
.56571 .52275 m
.57621 .51936 L
s
.75324 .51906 m
.76549 .49953 L
s
.532 .7254 m
.55096 .72507 L
s
.52584 .41116 m
.52584 .41116 L
s
.48564 .29861 m
.46833 .30501 L
s
.72006 .72214 m
.7399 .71167 L
s
.49807 .92936 m
.52183 .93036 L
s
.49186 .61433 m
.50536 .6166 L
s
.7141 .40722 m
.71521 .38568 L
s
.36935 .27528 m
.34584 .30025 L
s
.45138 .50229 m
.45733 .50865 L
s
.45766 .81881 m
.47803 .82179 L
s
.41054 .38928 m
.40534 .40235 L
s
.68065 .61081 m
.6945 .60037 L
s
.25023 .25138 m
.22275 .29547 L
s
.67462 .29441 m
.65723 .2703 L
s
.41689 .7073 m
.43297 .71316 L
s
.87026 .60728 m
.88744 .58382 L
s
.64699 .81573 m
.66728 .81038 L
s
.37577 .59481 m
.38621 .6049 L
s
.29245 .36687 m
.28366 .39346 L
s
.6409 .49852 m
.64642 .48857 L
s
.33429 .48134 m
.33696 .49781 L
s
.38218 .91364 m
.40401 .91885 L
s
.83124 .49473 m
.83994 .46801 L
s
.34077 .80169 m
.35919 .80986 L
s
.60696 .70396 m
.62236 .69955 L
s
.6008 .38524 m
.59394 .37663 L
s
.17146 .34391 m
.16081 .38448 L
s
.299 .68875 m
.31311 .70106 L
s
.79785 .7006 m
.81515 .68569 L
s
.25686 .57482 m
.26534 .59304 L
s
.57279 .91074 m
.59378 .90903 L
s
.79189 .38119 m
.78789 .35017 L
s
.21435 .45987 m
.21508 .48683 L
s
.56658 .59121 m
.57552 .58844 L
s
.56035 .27098 m
.53301 .26537 L
s
.75822 .58759 m
.76868 .57165 L
s
.53213 .79853 m
.54909 .79825 L
s
.75219 .26666 m
.72703 .22922 L
s
.52584 .47747 m
.52584 .47747 L
s
.72433 .79536 m
.74208 .78646 L
s
.48475 .36273 m
.47148 .36748 L
s
.44329 .24698 m
.40817 .26042 L
s
.49111 .68533 m
.50294 .68723 L
s
.71824 .47359 m
.71918 .45666 L
s
.32335 .22239 m
.2827 .25544 L
s
.44973 .57113 m
.45481 .57634 L
s
.45615 .89457 m
.47467 .89714 L
s
.68407 .6819 m
.69621 .67315 L
s
.40798 .45592 m
.40373 .46624 L
s
.67791 .35858 m
.66465 .34076 L
s
.36586 .33967 m
.34781 .35825 L
s
.41447 .78092 m
.42887 .78591 L
s
.87788 .67845 m
.893 .65882 L
s
.64967 .89158 m
.66811 .88699 L
s
.64345 .56743 m
.64816 .5593 L
s
.37243 .66625 m
.3816 .67472 L
s
.63721 .24255 m
.6004 .22408 L
s
.24401 .31604 m
.22292 .34892 L
s
.33 .55056 m
.33232 .56406 L
s
.83803 .56371 m
.84551 .5419 L
s
.2872 .43382 m
.28006 .45485 L
s
.60876 .77767 m
.62254 .77391 L
s
.33664 .878 m
.3534 .88503 L
s
.60247 .45194 m
.59687 .44515 L
s
.80391 .7744 m
.81943 .76172 L
s
.29391 .76286 m
.30658 .77336 L
s
.79782 .44794 m
.79464 .42356 L
s
.56749 .66273 m
.57533 .66041 L
s
.25079 .64669 m
.25829 .662 L
s
.56112 .33542 m
.54018 .33126 L
s
.16339 .41118 m
.15478 .44333 L
s
.20729 .52947 m
.208 .5516 L
s
.76342 .65919 m
.77262 .64584 L
s
.75726 .33114 m
.73813 .3035 L
s
.53227 .87494 m
.54768 .8747 L
s
.52584 .54676 m
.52584 .54676 L
s
.5194 .21785 m
.47311 .21892 L
s
.72879 .87187 m
.74494 .86421 L
s
.72257 .54295 m
.7234 .5291 L
s
.49033 .75953 m
.50092 .76115 L
s
.48383 .42975 m
.47296 .4335 L
s
.39864 .19253 m
.34518 .21373 L
s
.71633 .21329 m
.67066 .18103 L
s
.44143 .31168 m
.41445 .32167 L
s
.44801 .64309 m
.45247 .64746 L
s
.68764 .75619 m
.69851 .74874 L
s
.68134 .42565 m
.67054 .41162 L
s
.4053 .52558 m
.40169 .53404 L
s
.88584 .75283 m
.89944 .73612 L
s
.41195 .85788 m
.42504 .86218 L
s
.31871 .28734 m
.28746 .31197 L
s
.3622 .407 m
.34744 .42169 L
s
.64611 .63946 m
.65025 .63265 L
s
.36893 .74095 m
.37716 .74817 L
s
.63974 .3073 m
.61158 .29362 L
s
.84512 .63582 m
.85175 .61756 L
s
.32552 .62295 m
.32758 .63429 L
s
.61065 .85473 m
.62317 .8515 L
s
.60421 .52167 m
.59945 .51611 L
s
.28171 .50386 m
.27566 .52113 L
s
.23749 .38368 m
.22027 .40973 L
s
.81025 .85157 m
.82439 .84065 L
s
.59776 .18786 m
.54083 .17564 L
s
.80403 .51775 m
.8014 .49781 L
s
.28858 .84038 m
.30014 .84943 L
s
.56844 .73752 m
.57545 .73554 L
s
.56193 .4028 m
.5448 .39953 L
s
.24445 .72189 m
.25122 .73496 L
s
.76886 .73407 m
.77713 .72269 L
s
.76257 .39859 m
.74701 .37682 L
s
.1999 .6023 m
.20061 .62091 L
s
.15495 .48159 m
.14771 .50801 L
s
.52584 .61923 m
.52584 .61923 L
s
.51925 .28284 m
.48374 .28364 L
s
.47619 .16178 m
.41033 .17023 L
s
.72709 .6155 m
.72786 .60389 L
s
.48951 .83715 m
.49914 .83855 L
s
.48286 .49985 m
.4736 .50293 L
s
.72072 .27833 m
.68586 .25446 L
s
.43947 .37937 m
.41738 .38727 L
s
.44621 .71837 m
.4502 .7221 L
s
.69137 .83391 m
.70127 .8275 L
s
.39568 .25777 m
.35457 .27356 L
s
.68494 .49583 m
.67576 .48434 L
s
.89417 .83065 m
.90661 .81627 L
s
.67848 .15696 m
.61151 .13048 L
s
.4025 .59848 m
.39934 .60559 L
s
.6489 .71484 m
.65262 .70902 L
s
.35838 .47748 m
.34581 .48954 L
s
.64239 .37505 m
.61938 .36426 L
s
.31385 .35533 m
.28826 .37485 L
s
.36527 .81913 m
.37278 .82536 L
s
.85254 .71129 m
.85854 .69572 L
s
.32082 .69873 m
.3227 .70842 L
s
.60604 .59465 m
.60187 .58999 L
s
.59944 .25314 m
.55582 .24408 L
s
.27596 .5772 m
.2707 .59172 L
s
.81053 .59081 m
.80829 .57408 L
s
.23067 .45452 m
.21603 .47594 L
s
.56943 .8158 m
.57582 .8141 L
s
.56277 .47335 m
.54817 .47066 L
s
.77456 .81246 m
.78211 .80265 L
s
.55609 .13009 m
.47834 .12482 L
s
.2378 .80064 m
.24401 .81192 L
s
.76812 .4692 m
.75493 .45137 L
s
.52584 .69511 m
.52584 .69511 L
s
.19216 .67858 m
.19288 .69449 L
s
.5191 .3509 m
.49001 .35153 L
s
.1461 .55536 m
.13986 .57762 L
s
.73183 .69146 m
.73255 .68156 L
s
.47501 .22729 m
.42441 .23358 L
s
.48184 .57327 m
.47372 .57585 L
s
.72531 .34644 m
.69687 .32761 L
s
.43742 .45028 m
.41857 .45676 L
s
.44432 .79722 m
.44796 .80044 L
s
.6887 .56932 m
.68068 .55967 L
s
.39258 .32611 m
.35888 .33862 L
s
.6821 .22252 m
.63087 .20288 L
s
.39956 .67486 m
.39675 .68093 L
s
.65183 .79379 m
.65521 .78878 L
s
.35438 .55132 m
.34336 .56147 L
s
.64516 .44602 m
.62556 .43717 L
s
.86032 .79035 m
.86585 .77692 L
s
.63847 .09742 m
.5494 .07738 L
s
.30876 .4266 m
.28693 .44265 L
s
.60795 .67112 m
.60422 .66713 L
s
.3159 .77815 m
.31764 .78652 L
s
.6012 .32154 m
.5655 .31438 L
s
.81734 .66736 m
.81539 .65309 L
s
.26993 .65407 m
.26526 .6665 L
s
.56366 .54727 m
.55084 .54501 L
s
.22352 .52879 m
.21072 .54684 L
s
.55682 .19586 m
.49714 .19195 L
s
.77394 .5432 m
.76243 .52822 L
s
.52584 .77463 m
.52584 .77463 L
s
.51894 .42223 m
.49411 .42274 L
s
.18405 .75857 m
.18478 .77233 L
s
.7368 .77109 m
.73748 .76254 L
s
.48078 .65023 m
.4735 .65244 L
s
.47378 .29597 m
.4323 .30096 L
s
.73013 .41783 m
.70593 .40239 L
s
.13682 .63273 m
.13132 .65179 L
s
.43527 .52463 m
.41873 .53009 L
s
.69265 .64638 m
.68548 .63813 L
s
.68589 .29125 m
.64401 .27574 L
s
.38933 .3978 m
.36055 .40808 L
s
.39648 .75496 m
.39393 .76021 L
s
.64806 .52045 m
.63088 .513 L
s
.35018 .62879 m
.34031 .63747 L
s
.64122 .16344 m
.57295 .14855 L
s
.30341 .50137 m
.28426 .5149 L
s
.60996 .75132 m
.60656 .74788 L
s
.60304 .39328 m
.57259 .3874 L
s
.82448 .74767 m
.82277 .73535 L
s
.26361 .73475 m
.2594 .7455 L
s
.56459 .62482 m
.5531 .62289 L
s
.55758 .26487 m
.50868 .26177 L
s
.21601 .60675 m
.2046 .62222 L
s
.78005 .62084 m
.76979 .60804 L
s
.51877 .49708 m
.49696 .49751 L
s
.47966 .73101 m
.47303 .73292 L
s
.73518 .49276 m
.71399 .47977 L
s
.47249 .36806 m
.43705 .37216 L
s
.12707 .71398 m
.12217 .73049 L
s
.43302 .60268 m
.41818 .60736 L
s
.69679 .72726 m
.69028 .72013 L
s
.68987 .36341 m
.65417 .35066 L
s
.38591 .47307 m
.36063 .48174 L
s
.65111 .59859 m
.63572 .59222 L
s
.6441 .23276 m
.58821 .22097 L
s
.34577 .71014 m
.33679 .71766 L
s
.2978 .57992 m
.28065 .59152 L
s
.60498 .46863 m
.57824 .46367 L
s
.56556 .70628 m
.5551 .70461 L
s
.55838 .33736 m
.51662 .33481 L
s
.78647 .70241 m
.77717 .69134 L
s
.20812 .68869 m
.19778 .70209 L
s
.51859 .57572 m
.49903 .57609 L
s
.74049 .57149 m
.72153 .56037 L
s
.47113 .44382 m
.43998 .44728 L
s
.43065 .68472 m
.41713 .68877 L
s
.69405 .43924 m
.66273 .42849 L
s
.38232 .5522 m
.35963 .55964 L
s
.65432 .68073 m
.6403 .67522 L
s
.64713 .30563 m
.59942 .29593 L
s
.60702 .54785 m
.58303 .5436 L
s
.29189 .66254 m
.27628 .6726 L
s
.55922 .4136 m
.5225 .41144 L
s
.5184 .65844 m
.50056 .65876 L
s
.74608 .65432 m
.72883 .64468 L
s
.46971 .52354 m
.44173 .5265 L
s
.69845 .51904 m
.67037 .50983 L
s
.37854 .6355 m
.35785 .64196 L
s
.65032 .38234 m
.60839 .37415 L
s
.60916 .63126 m
.58728 .62757 L
s
.56011 .49388 m
.52713 .49203 L
s
.4682 .60752 m
.44267 .6101 L
s
.70309 .60313 m
.67749 .59513 L
s
.65369 .46319 m
.61603 .45615 L
s
.56104 .57855 m
.53093 .57694 L
s
.65723 .54853 m
.62286 .54241 L
s
.25 Mabswid
.67739 0 m
.94009 .42007 L
s
.94009 .42007 m
1 .85841 L
s
1 .85841 m
.70529 .48066 L
s
.70529 .48066 m
.67739 0 L
s
.07268 .24892 m
0 .70758 L
s
0 .70758 m
.70529 .48066 L
s
.70529 .48066 m
.67739 0 L
s
.67739 0 m
.07268 .24892 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003o]?ooool2
o`0007Kooooo002aooooo`?o000000?oooooo`000?ooool0MOooool00:oooooo0_l00004ooooo`;o
0000MOooool00:gooooo0_l00006ooooo`03o`000?oooooo000007Cooooo002Zooooo`?o00002?oo
ool00ol0003oooooo`00001dooooo`00Z?ooool2o`0000_ooooo00Co0000oooooooooooo0000Looo
ool00:Gooooo0ol0000=ooooo`04o`000?ooooooooooo`0007?ooooo002Sooooo`;o00004?ooool0
1Ol0003ooooooooooooooooo000007;ooooo002Qooooo`;o00004_ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo06oooooo002Nooooo`?o00005?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo06oooooo002Looooo`;o00006?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo06kooooo002Iooooo`?o00006_ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo06kooooo002Gooooo`;o00007Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo06gooooo002Eooooo`;o00007oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo06cooooo002Booooo`?o00002Oooool3o`0001Gooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`1/ooooo`00T?ooool2o`0000oooooo1?l0000Aooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool0Joooool008gooooo0ol0000Eooooo`Co00003Oooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo06[ooooo002;ooooo`;o00007?ooool4o`0000Wooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`1Zooooo`00ROooool2o`0002;ooooo0_l00007
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0JOooool008Kooooo0ol0000]oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0JOooool008Cooooo0_l0000`ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool0J?ooool0087ooooo0ol0000booooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool0Ioooool007oooooo0_l0000eooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool0Ioooool007gooooo0_l0000Booooo`So00007Oooool0
0ol0003oooooooooo`0:ooooo`03o`000?oooooooooo06Kooooo001jooooo`?o00007?ooool7o`00
00Wooooo0_l0000;ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0IOooool007So
oooo0_l0000aooooo`?o00002?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo06Go
oooo001eooooo`?o0000=_ooool2o`0000Kooooo00?o0000ooooooooool03?ooool00ol0003ooooo
ooooo`1Tooooo`00Loooool2o`0002gooooo0ol0000;ooooo`;o00001Oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo06Cooooo001aooooo`;o0000<_ooool4o`0000Wooooo0ol00002
ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0Hoooool006kooooo0ol0000Moooo
o`Co00005oooool4o`0000Sooooo00?o0000ooooool000003oooool00ol0003oooooooooo`1Roooo
o`00K?ooool2o`0001[ooooo1_l0000Oooooo`;o00002?ooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo06;ooooo001Yooooo`?o00006Oooool3o`0002oooooo00?o0000ooooooooool0
3_ooool00ol0003oooooooooo`1Qooooo`00Ioooool2o`0003?ooooo1?l0000Gooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool0HOooool006Gooooo0_l0000iooooo`Go00003_ooool2
o`0000;ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`1Pooooo`00H_ooool3o`00
043ooooo0_l0000>ooooo`03o`000?oooooo000001;ooooo00?o0000ooooooooool0Goooool0063o
oooo0_l0000Pooooo`;o00004?ooool<o`0001Kooooo0_l0000Booooo`03o`000?oooooooooo05oo
oooo001Mooooo`?o00007oooool3o`0003Gooooo0_l0000Booooo`03o`000?oooooooooo05kooooo
001Kooooo`;o00008?ooool2o`0002gooooo0ol00008ooooo`04o`000?oooooo0000o`00017ooooo
00?o0000ooooooooool0GOooool005Wooooo0_l0000Oooooo`?o0000<_ooool3o`0000Gooooo00Go
0000ooooooooooooooooo`00000@ooooo`03o`000?oooooooooo05gooooo001Fooooo`?o00008?oo
ool00ol0003oooooooooo`0Hooooo`Go00006Oooool3o`0000;ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo05cooooo001Dooooo`;o00007_ooool2
o`0001[ooooo1?l0000Aooooo`Co00003?ooool3o`0001Gooooo00?o0000ooooooooool0G?ooool0
057ooooo0ol0000Oooooo`03o`000?oooooooooo01Oooooo1Ol0000Eooooo`Oo00002Oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0Foooool004oo
oooo0_l0000Qooooo`03o`000?oooooooooo01?ooooo1Ol0000Looooo`?o00000_ooool2o`0000Oo
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo05[o
oooo001=ooooo`;o00008_ooool00ol0003oooooooooo`0hooooo`;o00002Oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0F_ooool004[ooooo0ol0
000Sooooo`03o`000?oooooooooo02cooooo0ol0000<ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo05Wooooo0019
ooooo`;o00007Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Sooooo0_l0000F
ooooo`Co00004_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool0F?ooool004Wooooo00?o0000ooooool000007?ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo01Kooooo0ol0000Looooo`;o00003_ooool3o`0000Sooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`1Hooooo`00BOooool01?l0003oooooooooool0000Joooo
o`03o`000?oooooooooo01Kooooo0ol00002ooooo`;o00004?ooool5o`0001cooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo05Oooooo0019ooooo`05
o`000?ooooooooooooooool000006?ooool00ol0003oooooooooo`0Dooooo`?o00006oooool5o`00
01Sooooo0ol00007ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0Eoooool004So
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo01;o
oooo0_l0000Rooooo`;o00004?ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`00
01Oooooo00?o0000ooooooooool0E_ooool004Sooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool05Oooool2o`00033o
oooo0ol00006ooooo`05o`000?ooooooooooooooool000002_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo05Gooooo0018ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool04oooool7o`0001Sooooo0ol00004ooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`1Eooooo`00B?ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`;o0000
1Oooool00ol0003oooooooooo`0eooooo`?o00000_ooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool0E?ooool004Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo013ooooo1?l0000Fooooo`Co00002Ooo
ool01Ol0003oooooo`000?oooooo000000kooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`1Dooooo`00B?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool04oooool2o`0000Kooooo00?o0000ooooooooool03Oooool4o`0000Cooooo0_l0
000Gooooo`Co00002_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool0Doooool004Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo01;ooooo0_l0000Mooooo`;o00007Oooool2o`0000Sooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool0D_ooool004Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooool000006?ooool2o`0001Wooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`1Booooo`00Aoooool00ol0003oooooooooo`0<ooooo`05
o`000?ooooooooooooooool000003?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
01Cooooo0ol0000Gooooo`Co000000?oooooo`000?ooool04?ooool01?l0003oooooooooool00005
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo057ooooo0017ooooo`03o`000?oooooooooo00gooooo00Co0000oooo
oooooooo00003?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool07?ooool3o`00013ooooo00Co0000oooooooooooo00001_ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0D?ooool004Oooooo00?o0000
ooooooooool03_ooool2o`0000[ooooo00?o0000ooooool000002Oooool00ol0003oooooooooo`0>
ooooo`;o00000_ooool00ol0003oooooooooo`0`ooooo`;o000000?oooooo`000?ooool01Oooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0D?ooool0
04Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo0000
00Sooooo00?o0000ooooooooool03?ooool3o`0000Cooooo00?o0000ooooooooool04?ooool9o`00
01Oooooo00Co0000ooooool0003o00001oooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool0Coooool004Oooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`07ooooo`;o00002Oooool00ol0003oooooooooo`0:ooooo`;o00001_ooool00ol0
003oooooooooo`0Fooooo`?o00004_ooool00ol0003oooooooooo`04ooooo`04o`000?oooooo0000
o`0001;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`1?ooooo`00A_ooool00ol0
003oooooooooo`0Aooooo`;o00002?ooool2o`0001Kooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`0Cooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool01?ooool01Ol0
003oooooo`000?oooooo0000017ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`1>
ooooo`00A_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo000000Oooooo00?o0000oooo
ooooool04_ooool00ol0003oooooo`00000Gooooo`Ko00005_ooool00ol0003oooooo`000002o`00
00Gooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool0COooool004Kooooo00?o0000ooooooooool04Oooool01?l0003o
ooooooooool00007ooooo`03o`000?oooooooooo00_ooooo0_l00004ooooo`;o0000=?ooool00ol0
003oooooooooo`02ooooo`?o00000_ooool00ol0003oooooooooo`08ooooo`05o`000?oooooooooo
ooooool000001_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo04gooooo0016oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Wooooo0_l00006ooooo`03o`000?oooooooooo01Gooooo0_l0000Koooo
o`03o`000?oooooooooo00Cooooo00Go0000ooooool0003oooooo`00000:ooooo`05o`000?oooooo
ooooooooool000001Oooool00ol0003oooooooooo`08ooooo`05o`000?ooooooooooooooool00000
C_ooool004Kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo013ooooo1?l0000Iooooo`Co00002oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0Boooool004Kooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01oooool2
o`0000Wooooo00?o0000ooooooooool03Oooool4o`0001[ooooo0ol00002ooooo`;o00002_ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo04_ooooo0015ooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool01_ooool01Ol0003ooooooooooooooooo000000Oooooo00?o0000
ooooool000002_ooool00ol0003oooooooooo`0<ooooo`;o00000oooool00ol0003oooooooooo`0E
ooooo`03o`000?oooooooooo00;ooooo1?l0000:ooooo`03o`000?oooooooooo00Gooooo0_l00006
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1:
ooooo`00AOooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Oooooo00Go0000oooo
ooooooooooooo`000006ooooo`03o`000?oooooo000001Oooooo0_l00006ooooo`03o`000?oooooo
oooo01Gooooo00?o0000ooooooooool01Oooool2o`0000Sooooo00?o0000ooooool000001Oooool2
o`0000Kooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo04[ooooo0015ooooo`03o`000?oooooooooo01_ooooo00Co0000oooooooooooo00001_ooool0
0ol0003oooooo`00000Eooooo`;o00006oooool4o`0001?ooooo00?o0000ooooool000001Oooool2
o`0001?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`19ooooo`00AOooool00ol0
003oooooooooo`0Kooooo`?o00002?ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo
01Sooooo0_l00004ooooo`;o00004?ooool2o`000003ooooool0003ooooo00Kooooo00?o0000oooo
ooooool01oooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`18ooooo`00AOooool00ol0003oooooooooo`0Kooooo`?o00002?ooool00ol0
003oooooooooo`0>ooooo`?o00000_ooool00ol0003oooooooooo`0Fooooo`Co00005_ooool00ol0
003oooooo`000002o`0000Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02oooo
o`05o`000?ooooooooooooooool000002oooool00ol0003oooooooooo`18ooooo`00AOooool00ol0
003oooooooooo`0Kooooo`;o000000?oooooo`000?ooool01_ooool00ol0003oooooooooo`0;oooo
o`?o00000oooool00ol0003oooooooooo`0aooooo`05o`000?ooooooooooo`000?ooool00_l0000>
ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00000=ooooo`03o`000?oo
oooooooo04Oooooo0014ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01oooool0
1Ol0003ooooooooooooooooo000000Oooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01?ooooo2?l0000Booooo`03o`000?oooooo000000?ooooo00Go
0000ooooooooooooooooo`00000<ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo
00003_ooool00ol0003oooooooooo`17ooooo`00A?ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Kooooo00Co0000oooooooooooo00002?ooool00ol0003oooooooooo`0=ooooo`?o
00006?ooool01?l0003oooooooooooooool2o`0000Cooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`16ooooo`00A?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`08ooooo`;o00000_ooool00ol0003o
ooooo`00000Iooooo`Go00005_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool03?ooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo013o
oooo0ol00017ooooo`00A?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`;o00000_ooool01?l0003ooooo
ooooool0000Gooooo`;o00006Oooool3o`0000?ooooo1?l00003ooooo`03o`000?oooooooooo00So
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00gooooo0ol00002ooooo`03o`000?oooooooooo04Gooooo0014ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04?ooool01ol0003ooooooooooooooooo0000ooooool000001Oooool0
0ol0003oooooo`00000Cooooo`04o`000?ooooooooooo`0001Sooooo0ol00002ooooo`03o`000?oo
oooooooo00Cooooo0ol00002ooooo`03o`000?oooooooooo00?ooooo0_l00002ooooo`03o`000?oo
oooo000000?ooooo00?o0000ooooooooool03oooool3o`0000Gooooo00?o0000ooooooooool0AOoo
ool004Cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00;o00001oooool00ol0003oooooooooo`0=ooooo`;o00000oooool00ol0003oooooooooo`0G
ooooo`;o00000_ooool3o`0000[ooooo00?o0000ooooool000000oooool2o`0000?ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0<ooooo`?o00002?ooool00ol0003oooooooooo`15
ooooo`00A?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01;ooooo0_l000000ooo
oooo0000ooooo`08ooooo`03o`000?oooooooooo00kooooo1ol0000Eooooo`03o`000?oooooooooo
00Gooooo0_l0000:ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`08ooooo`Go00002_ooool00ol0003oooooooooo`15ooooo`00@oooool00ol0
003oooooooooo`0Wooooo`;o00002oooool00ol0003oooooooooo`0;ooooo`?o000000?oooooo`00
0?l000005?ooool2o`0000?ooooo00?o0000ooooooooool04?ooool3o`0000Cooooo00?o0000oooo
ool000003_ooool3o`0000?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`14oooo
o`00@oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Gooooo0ol0000Eooooo`?o
00001_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Kooooo1?l0000<ooooo`03
o`000?oooooo000000Kooooo00?o0000ooooooooool02Oooool3o`0000Gooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`14ooooo`00@oooool00ol0003oooooooooo`0Looooo`03o`00
0?oooooo000000Sooooo00Co0000oooooooooooo00003oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo01?ooooo3?l00007ooooo`?o00001_ooool2o`000004ooooool0003oooooo`00
00Oooooo00?o0000ooooooooool01Oooool3o`0000Sooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`14ooooo`00@oooool00ol0003oooooooooo`0Looooo`;o00002_ooool01?l0003o
ooooooooool0000:ooooo`;o00000oooool01?l0003oooooooooool0000Rooooo`;o00002oooool3
o`0000?ooooo00?o0000ooooool000002?ooool00ol0003oooooooooo`05o`0000Gooooo00Go0000
ooooooooooooooooo`00000>ooooo`03o`000?oooooooooo04Cooooo0013ooooo`03o`000?oooooo
oooo01cooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`09ooooo`Go00006oooool3
o`0000kooooo1Ol000000ooooooo0000ooooo`03ooooo`03o`000?oooooo000000Sooooo0ol00003
ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00003oooool00ol0003ooooooooo
o`14ooooo`00@oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool03_ooool01Ol0003ooooooooooooooooo000000?ooooo1ol000000ooooooo0000oooo
o`0?ooooo`?o00000oooool00ol0003oooooooooo`0@ooooo`;o00001Oooool01?l0003ooooooooo
ooooool5o`0000Gooooo0ol00005ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`14ooooo`00@_ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool03oooool01?l0003oooooooooool00002ooooo`03o`00
0?oooooo000000Gooooo0_l0000;ooooo`?o00001Oooool00ol0003oooooooooo`0Jooooo`Co0000
0_ooool00ol0003oooooooooo`05o`0000Oooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo04Cooooo0012ooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool06oooool00ol0003oooooooooo`02o`0000[ooooo00?o0000ooooooooool02ooo
ool4o`0000Cooooo1?l0000=ooooo`;o00000_ooool00ol0003oooooooooo`04o`0000Gooooo1Ol0
0008ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`14ooooo`00@_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01gooooo00?o0000
ooooool000006oooool5o`0000Gooooo0ol00005ooooo`Ko00000oooool3o`0000Cooooo00?o0000
ooooool000000_l000000ooooooo0000ooooo`09ooooo`05o`000?ooooooooooooooool000001?oo
ool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo04?ooooo0012ooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`02o`0000Cooooo00?o0000
ooooooooool04_ooool01?l0003oooooooooooooool3o`0000kooooo1Ol000000ooooooo0000oooo
o`03ooooo`?o00001_ooool3o`0000Gooooo00Co0000ooooool0003o00000oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0@oooool004;ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00?o00001ooo
ool00ol0003oooooooooo`08ooooo`?o000000?oooooo`000?l000001?ooool00ol0003ooooooooo
o`0Iooooo`?o00001_ooool3o`0000Sooooo0_l00005ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`13ooooo`00@_ooool00ol0003oooooooooo`0V
ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool02_ooool6o`0001[ooooo0ol0
0003ooooo`Ko000000?oooooo`000?l000000_l00004ooooo`;o000000?oooooo`000?ooool00ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`13ooooo`00@Oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooo
000000cooooo00?o0000ooooooooool03?ooool4o`0001Gooooo1?l000000ooooooo0000ooooo`02
ooooo`Go00001oooool2o`000003ooooool0003ooooo00?ooooo00Co0000oooooooooooo00002?oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0@ooo
ool0047ooooo00?o0000ooooooooool0:?ooool2o`0000gooooo00?o0000ooooooooool01_ooool0
1?l0003oooooooooooooool2o`0000;ooooo1Ol00004ooooo`ko00001Oooool3o`0001Gooooo00?o
0000ooooooooool05Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo04?ooooo0011
ooooo`03o`000?oooooooooo01gooooo00Co0000oooooooooooo00001oooool00ol0003ooooooooo
o`0<ooooo`;o00000_ooool2o`0000?ooooo00Co0000ooooool0003o00000oooool3o`0000kooooo
1Ol00004ooooo`?o00002oooool2o`0000;ooooo0_l00004ooooo`05o`000?ooooooooooooooool0
00000_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool0@oooool0047ooooo00?o0000ooooooooool07Oooool00ol0003oooooo`00000Iooooo`;o0000
0_ooool00ol0003oooooo`00000Fooooo`?o00001Oooool3o`0000_ooooo0ol00003ooooo`03o`00
0?oooooooooo00Cooooo00Go0000ooooooooooooooooo`000003ooooo`03o`000?oooooooooo00oo
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`12ooooo`00@Oooool00ol0003ooooo
ooooo`0Mooooo`;o00006oooool3o`000003ooooool0003ooooo01?ooooo0ol00004ooooo`Co0000
2Oooool5o`0000Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`05o`00
0?ooooooooooooooool000001Oooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`00
013ooooo00?o0000ooooooooool0@_ooool0047ooooo00?o0000ooooooooool07Oooool00ol0003o
ooooooooo`0Kooooo`03o`000?oooooo000000Sooooo2Ol000001?oooooo0000o`000?l00003oooo
o`Oo00000oooool5o`0000Kooooo0ol0000Aooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04;ooooo0011ooooo`03
o`000?oooooooooo01gooooo00?o0000ooooooooool03oooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool00ol0000=ooooo`So000000?oooooo`000?l000000_l0000Yoooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo04;ooooo0010ooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool06oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo0000o`0000?ooooo00?o0000
ooooooooool02Oooool4o`0000?ooooo1?l0000=ooooo`Oo00000oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0@_ooool0043ooooo00?o0000oooo
ooooool04oooool00ol0003oooooooooo`0Looooo`05o`000?oooooo0000ooooool000002?ooool0
0ol0003oooooooooo`05ooooo`?o00001?ooool4o`0000cooooo1?l00003ooooo`;o00001Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo0_l00006ooooo`04o`000?oooooo
ooooo`0000Sooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`12ooooo`00@?ooool0
0ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool02Oooool3
o`0000;ooooo0ol00002ooooo`03o`000?oooooo000000;o00005_ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool2o`0000Gooooo00?o0000
ooooooooool07_ooool00ol0003oooooooooo`12ooooo`00@?ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool05oooool:o`0000;ooooo0ol00002oooo
o`Co00009?ooool2o`000003ooooool0003ooooo00?ooooo00?o0000ooooool000001?ooool00ol0
003oooooooooo`0Hooooo`03o`000?oooooooooo04;ooooo0010ooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool04_ooool01?l0003oooooooooool00002ooooo`;o00003oooool3o`00
0004ooooool0003oooooooooo`Co00003oooool6o`0001_ooooo00?o0000ooooooooool01Oooool0
1?l0003oooooooooool00004ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0@Ooo
ool0043ooooo00?o0000ooooooooool0:?ooool01Ol0003oooooo`000?oooooo000000kooooo0ol0
0005ooooo`;o00003Oooool6o`0000;ooooo0ol0000Kooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000gooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`11ooooo`00?oooool00ol0003oooooooooo`0Yooooo`;o000000?o
ooooo`000?ooool02oooool3o`0000Sooooo00?o0000ooooooooool04_ooool4o`0000;ooooo0_l0
0004ooooo`03o`000?oooooooooo00?ooooo0ol0000Iooooo`04o`000?ooooooooooo`0000gooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`11ooooo`00?oooool00ol0003ooooooooo
o`0fooooo`?o00000_ooool3o`0000Cooooo00?o0000ooooool000008Oooool00ol0003ooooooooo
o`05ooooo`05o`000?oooooo0000o`000?ooool00ol0000Booooo`03o`000?oooooooooo00cooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`11ooooo`00?oooool00ol0003ooooooooo
o`0Mooooo`03o`000?oooooooooo01?ooooo0ol00007ooooo`;o00000oooool01?l0003oooooo`00
0?ooool2o`0002Gooooo0ol00005ooooo`?o00001?ooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`11ooooo`00?ooo
ool00ol0003oooooooooo`0Mooooo`04o`000?ooooooooooo`0000oooooo0ol0000;ooooo`;o0000
00Coooooo`000?oooooooooo0_l000000ooooooo0000o`000007o`0001cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool0@Oooool003oooooo00?o0000ooooooooool07_ooool00ol0003oooooo`00000<ooooo`?o0000
5?ooool00ol0003oooooooooo`06ooooo`Oo00007oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool00oooool2o`0001[ooooo00?o0000ooooooooool0
@Oooool003oooooo00?o0000ooooooooool07_ooool2o`0000[ooooo0ol00003ooooo`;o00004_oo
ool00ol0003oooooooooo`0=ooooo`05o`000?ooooooooooooooool00000;?ooool01ol0003ooooo
oooooooooooo0000ooooool000001_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
047ooooo000nooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool01_ooool3o`0000So
oooo00?o0000ooooool000003oooool00ol0003oooooooooo`0Eooooo`Co00000oooool4o`00027o
oooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool0@?ooool003kooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0>ooooo`Co
00003?ooool2o`0000;ooooo0_l00007ooooo`?o000000?oooooo`000?ooool06Oooool8o`000003
ooooool0003o000000Cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`10ooooo`00
?_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00_ooooo0ol0000Aooooo`03o`00
0?oooooo000000Gooooo0_l00005ooooo`Go00007_ooool2o`0000Kooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0Fooooo`05o`000?ooooooooooooooool000005Oooool00ol0003o
ooooooooo`10ooooo`00?_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Sooooo
0ol0000Jooooo`;o00002?ooool01ol0003oooooo`000?oooooo0000ooooool000008_ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00Kooooo0_l0000?ooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool0@?ooool003kooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`06ooooo`?o00002_ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool01Oooool5o`0001gooooo00?o0000ooooooooool00oooool4o`0000Go
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo043o
oooo000nooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool00oooool3o`0000gooooo
00Co0000oooooooooooo00006Oooool00ol0003oooooooooo`07ooooo`?o00001oooool6o`0001co
oooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000000Oooooo00Go0000oooo
ooooooooooooo`00000Gooooo`03o`000?oooooooooo043ooooo000nooooo`03o`000?oooooooooo
01Gooooo0ol0000Aooooo`03o`000?oooooo000000gooooo0_l00009ooooo`03o`000?oooooooooo
00gooooo1?l00002ooooo`;o00001Oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool0@?ooool003gooooo00?o0000ooooooooool04oooool3o`0001Co
oooo0_l00003ooooo`;o00002oooool3o`0000Kooooo00?o0000ooooooooool06Oooool00ol0003o
ooooooooo`0>ooooo`;o00006_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`10ooooo`00?Oooool00ol0003ooooo
ooooo`0@ooooo`?o00006?ooool01?l0003oooooooooool0000?ooooo`;o00001Oooool01?l0003o
ooooooooooooool5o`0001[ooooo00?o0000ooooooooool01?ooool3o`0001cooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00gooooo00?o0000oooo
ooooool0?oooool003gooooo00?o0000ooooooooool03Oooool3o`0001gooooo00?o0000oooooooo
ool04?ooool01_l0003oooooooooool0003oooooo`0000Sooooo1?l0000Looooo`?o00001_ooool2
o`0001_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo03oooooo000mooooo`03o`000?oooooooooo00[ooooo0ol0000Aooooo`03o`000?oooooooooo
02;ooooo00?o0000ooooool000003?ooool2o`0001gooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo01?ooooo00Co0000oooooooooooo00004Oooool0
0ol0003oooooooooo`0oooooo`00?Oooool00ol0003oooooooooo`07ooooo`?o00005?ooool01?l0
003oooooooooool0000?ooooo`03o`000?oooooooooo017ooooo1Ol00009ooooo`Co0000:?ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0oooooo`00?Oooool00ol0003oooooooooo`04ooooo`?o00005oooool01?l0
003oooooooooool0000@ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`04ooooo`Oo00005_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo03oooooo000looooo`03o`000?oooooooooo00;ooooo0ol0000Jooooo`03o`000?oooooo0000
01;ooooo00?o0000ooooool000003?ooool2o`000003ooooool0003ooooo02?ooooo0_l0000Koooo
o`05o`000?ooooooooooooooool000002Oooool00ol0003oooooo`00000Booooo`03o`000?oooooo
oooo03oooooo000looooo`03o`000?oooooo000000;o00007_ooool00ol0003oooooooooo`0Boooo
o`;o00003_ooool3o`0001Sooooo0_l00007ooooo`;o00007_ooool00ol0003oooooo`00000:oooo
o`04o`000?ooooooooooo`00017ooooo00?o0000ooooooooool0?oooool003cooooo0_l0000goooo
o`05o`000?ooooooooooooooool000002oooool4o`0001Sooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03_ooool0
0ol0003oooooooooo`0oooooo`00?_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
02Cooooo00?o0000ooooooooool02Oooool01Ol0003ooooooooooooooooo000000_ooooo1ol0000D
ooooo`03o`000?oooooooooo00_ooooo0ol0000Cooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`0nooooo`00?oooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00?ooooo0_l0000Zooooo`03o`000?oooooooooo00;ooooo0_l0000Moooo
o`03o`000?oooooooooo00gooooo00?o0000ooooooooool0?_ooool0043ooooo0_l0000@ooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Cooooo`Co
00006Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`0nooooo`00@_ooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool03_ooool3o`0000Wooooo00?o0000ooooooooool0
2?ooool2o`0003Cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo03kooooo0013ooooo`;o00009?ooool00ol0003oooooo`00000@ooooo`;o00001ooo
ool01?l0003oooooooooooooool4o`0001Cooooo0_l0000>ooooo`?o00004Oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00[ooooo0_l0000=ooooo`03o`000?oooooooooo03kooooo
0015ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo0ol0000Oooooo`;o00007_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooo000000cooooo00?o0000ooooooooool0?_ooool004Kooooo00?o0000
ooooooooool08Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool01_ooool5o`0001Gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0D
ooooo`03o`000?oooooooooo00Wooooo00Co0000oooooooooooo00003?ooool00ol0003ooooooooo
o`0nooooo`00Aoooool2o`0003[ooooo00?o0000ooooool000008oooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo03gooooo0019ooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool08_ooool01?l0003oooooooooool0000=ooooo`?o00003_ooool3o`00013ooooo00?o0000
ooooooooool09_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo03gooooo001:oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0>oooo
o`;o00000_ooool00ol0003oooooooooo`0Jooooo`;o00006oooool00ol0003oooooooooo`0;oooo
o`;o00004_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo03gooooo001;ooooo`;o
00004?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00oooooo0ol0000iooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo03gooooo001=ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooool00000
4?ooool2o`0001?ooooo00?o0000ooooooooool02oooool4o`0001oooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
?Oooool004kooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0>ooooo`?o00003Ooo
ool4o`0003gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo03gooooo001?ooooo`;o00008oooool00ol0003oooooooooo`0>ooooo`04o`000?oooooo
ooooo`00013ooooo0_l0000Fooooo`03o`000?oooooooooo00_ooooo0_l0000Dooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0mooooo`00DOooool0
0ol0003oooooooooo`0aooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0mooooo`00D_ooool2o`0001;ooooo00?o0000ooooooooool06oooool00ol0
003oooooooooo`04ooooo`;o00003_ooool4o`0001kooooo00?o0000ooooooooool09Oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo03cooooo001Dooooo`03o`000?oooooooooo00oo
oooo00?o0000ooooooooool04?ooool3o`0000Sooooo00Co0000oooooooooooooooo1?l0000koooo
o`03o`000?oooooooooo01cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0loooo
o`00EOooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`05ooooo`?o00008_ooool3o`0001?ooooo00?o0000oooooooo
ool07Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03cooooo001Fooooo`;o0000
;?ooool00ol0003oooooooooo`0Jooooo`?o00002oooool2o`0001Gooooo00?o0000ooooooooool0
5Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
??ooool005Sooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo00Kooooo1Ol0001;ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`0looooo`00FOooool00ol0003oooooooooo`0Rooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0<Oooool2o`0002;ooooo00?o0000ooooooooool02_ooool0
1Ol0003ooooooooooooooooo000003kooooo001Jooooo`;o0000:?ooool00ol0003oooooooooo`0M
ooooo`?o00004?ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00cooooo00Co0000
oooooooooooo0000?_ooool005cooooo00?o0000ooooooooool08_ooool4o`0000kooooo0ol0000<
ooooo`;o0000Aoooool00ol0003oooooo`00000nooooo`00GOooool00ol0003oooooooooo`0?oooo
o`;o00004oooool2o`0004Sooooo0_l0000Kooooo`04o`000?ooooooooooo`0003gooooo001Noooo
o`;o00004Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo04Kooooo00?o0000oooo
ooooool07?ooool00ol0003oooooo`00000mooooo`00H?ooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooooooo00kooooo1Ol0000?ooooo`?o00008?ooool00ol0003oooooooooo`0Nooooo`;o
0000?Oooool0067ooooo0_l0000Qooooo`Go0000Hoooool3o`0003gooooo001Sooooo`03o`000?oo
oooooooo01kooooo00?o0000ooooooooool0>Oooool2o`0002Kooooo1?l00010ooooo`00I?ooool0
0ol0003oooooooooo`0Mooooo`04o`000?ooooooooooooooo`Co0000<_ooool2o`0002?ooooo1Ol0
0014ooooo`00IOooool2o`00017ooooo0_l0000:ooooo`03o`000?oooooooooo00Gooooo0_l0000=
ooooo`Co0000@?ooool4o`0004Wooooo001Wooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`1Dooooo`Co0000COooool006Sooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo02_ooooo0_l0000Rooooo`Go
0000DOooool006Wooooo0_l0000Iooooo`03o`000?oooooooooo00Kooooo0ol0000Pooooo`;o0000
8?ooool4o`0005Kooooo001[ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0kooooo`Co0000F_ooool006cooooo00?o0000ooooooooool05Oooool0
0ol0003oooooooooo`13ooooo`Co0000G_ooool006gooooo0_l0000Eooooo`03o`000?oooooooooo
01_ooooo1Ol0000Nooooo`Go0000H_ooool006oooooo00?o0000ooooooooool03_ooool3o`000003
ooooool0003ooooo03_ooooo1?l0001Wooooo`00L?ooool2o`00017ooooo0_l0000hooooo`Co0000
Joooool007;ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0>ooooo`?o00008?oo
ool5o`0006oooooo001cooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool04Oooool2
o`0001[ooooo1?l0001dooooo`00M?ooool2o`0000gooooo00?o0000ooooooooool0:_ooool4o`00
07Sooooo001fooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool09_ooool4o`0007co
oooo001gooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00_ooool5o`0001[ooooo
1Ol00020ooooo`00N?ooool2o`0000Wooooo00?o0000ooooooooool07Oooool4o`0008Gooooo001j
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool06Oooool4o`0008Wooooo001koooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05Oooool4o`0008gooooo001looooo`;o
00001Oooool00ol0003oooooooooo`0@ooooo`Go0000TOooool007kooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`0<ooooo`Co0000U_ooool007oooooo0_l00002ooooo`03o`000?oo
oooooooo00Sooooo1?l0002Jooooo`00POooool00ol0003oooooo`000005ooooo`Go0000W_ooool0
08;ooooo0_l000000ooooooo0000o`000002o`000:?ooooo0023ooooo`;o0000Yoooool00001\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.289248, -4.58346, 0.00512118, \
0.00512118}},
 CellTags->"S5.40.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.40.1"]
}, Open  ]],

Cell[TextData[{
 "The gradient of a scalar function ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " is the vector field with components given by ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"\[PartialD]", 
     StyleBox["f",
      "TI"]}], 
    RowBox[{"\[PartialD]", 
     StyleBox["x",
      "TI"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"\[PartialD]", 
     StyleBox["f",
      "TI"]}], 
    RowBox[{"\[PartialD]", 
     StyleBox["y",
      "TI"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"\[PartialD]", 
     StyleBox["f",
      "TI"]}], 
    RowBox[{"\[PartialD]", 
     StyleBox["z",
      "TI"]}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 ", respectively. ",
 StyleBox["PlotGradientField", "MR"],
 " computes formulas for the partial derivatives and generates a vector field \
plot. Thus the function ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " must be such that ",
 StyleBox["Mathematica", "TI"],
 " can compute its derivatives. "
}], "Text",
 CellTags->{"S5.40.1", "1.5"}],

Cell[TextData[{
 "Here is the gradient field of the scalar function ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"x", "y", "z"}],
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.40.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
PlotGradientField3D[
    x y z, {x, -1, 1}, {y, -1, 1}, {z,-1,1}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.40.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 6.09322e-17 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.43618 .58183 m
.42216 .58164 L
s
.50142 .56056 m
.47809 .56493 L
s
.4344 .64313 m
.42518 .62997 L
s
.39768 .54213 m
.39627 .55047 L
s
.56835 .53874 m
.53637 .54751 L
s
.50092 .62223 m
.48505 .61631 L
s
.46399 .51983 m
.45342 .52873 L
s
.43254 .7069 m
.42837 .6809 L
s
.39507 .60412 m
.39449 .60078 L
s
.3573 .5005 m
.36881 .5174 L
s
.63703 .51635 m
.59716 .52934 L
s
.5692 .60078 m
.5473 .6021 L
s
.53206 .49693 m
.51289 .50611 L
s
.5004 .68643 m
.49237 .67034 L
s
.46271 .58218 m
.45561 .58209 L
s
.42471 .47708 m
.42729 .49039 L
s
.43061 .77331 m
.43174 .73464 L
s
.39236 .66867 m
.39261 .65379 L
s
.70753 .49336 m
.66061 .51038 L
s
.35379 .56316 m
.36193 .56982 L
s
.6393 .57876 m
.6121 .5873 L
s
.60195 .47343 m
.57483 .48255 L
s
.57009 .6654 m
.55878 .65938 L
s
.3149 .45678 m
.33963 .48228 L
s
.53218 .55966 m
.51909 .56268 L
s
.77993 .46975 m
.72691 .49057 L
s
.49986 .7533 m
.50007 .72723 L
s
.49395 .45303 m
.48805 .46232 L
s
.46138 .64716 m
.45792 .63819 L
s
.42257 .54012 m
.42444 .54586 L
s
.71131 .55614 m
.67959 .5719 L
s
.4286 .8425 m
.43529 .79143 L
s
.38343 .43217 m
.39957 .44972 L
s
.67375 .44928 m
.63939 .45799 L
s
.38953 .73595 m
.39063 .70972 L
s
.64168 .64379 m
.62775 .648 L
s
.85431 .4455 m
.79625 .46985 L
s
.35013 .62849 m
.3547 .62504 L
s
.60355 .53651 m
.58505 .54251 L
s
.57101 .73275 m
.57083 .71956 L
s
.31039 .52011 m
.32736 .53694 L
s
.5323 .62505 m
.52559 .62203 L
s
.5651 .42832 m
.55125 .43313 L
s
.78529 .5329 m
.74996 .55584 L
s
.49326 .51643 m
.48925 .52101 L
s
.27032 .41081 m
.30858 .4449 L
s
.74753 .42446 m
.70675 .43237 L
s
.4993 .82303 m
.5082 .78722 L
s
.45999 .71491 m
.46035 .69725 L
s
.71525 .62159 m
.69943 .63617 L
s
.45388 .40688 m
.46175 .41594 L
s
.42034 .60586 m
.42146 .60416 L
s
.6769 .51273 m
.65365 .52154 L
s
.86134 .50901 m
.82338 .53908 L
s
.38035 .49587 m
.39139 .50744 L
s
.64415 .71162 m
.64415 .71162 L
s
.4265 .91467 m
.43906 .85154 L
s
.63823 .40292 m
.61702 .40275 L
s
.60521 .60232 m
.59574 .60527 L
s
.82337 .39895 m
.77709 .40562 L
s
.38658 .80613 m
.38854 .76881 L
s
.34631 .69664 m
.34706 .6833 L
s
.34001 .38492 m
.37011 .4065 L
s
.79088 .59877 m
.77398 .62386 L
s
.56593 .49207 m
.5565 .49524 L
s
.57198 .80301 m
.58351 .78288 L
s
.3057 .58621 m
.31443 .59452 L
s
.53243 .69328 m
.53241 .68436 L
s
.75233 .48827 m
.72504 .49971 L
s
.49254 .58259 m
.49051 .58256 L
s
.52632 .38087 m
.52632 .38087 L
s
.71936 .68989 m
.72017 .70338 L
s
.26472 .47481 m
.29056 .50195 L
s
.49871 .89579 m
.51678 .85057 L
s
.71343 .3768 m
.68553 .37111 L
s
.45229 .47093 m
.45767 .4769 L
s
.68019 .57895 m
.66853 .58789 L
s
.45854 .78562 m
.46291 .7595 L
s
.86867 .57529 m
.85158 .61106 L
s
.41801 .67449 m
.41831 .66552 L
s
.22339 .36243 m
.27546 .40502 L
s
.64674 .78242 m
.66137 .77839 L
s
.42431 .99 m
.44304 .91526 L
s
.64069 .46703 m
.62631 .46847 L
s
.41169 .35828 m
.43384 .36673 L
s
.37713 .56237 m
.3828 .56808 L
s
.82991 .46311 m
.79941 .47697 L
s
.60695 .67102 m
.60695 .67102 L
s
.3835 .8794 m
.38633 .83135 L
s
.60083 .35412 m
.5934 .34443 L
s
.79672 .66754 m
.79904 .69483 L
s
.57299 .87638 m
.59687 .84957 L
s
.7908 .34993 m
.75695 .33812 L
s
.56681 .55864 m
.56198 .5602 L
s
.33588 .44926 m
.35627 .46661 L
s
.34233 .76782 m
.33899 .74484 L
s
.75734 .5549 m
.7441 .56984 L
s
.53257 .76453 m
.53959 .7499 L
s
.52632 .44527 m
.52632 .44527 L
s
.30079 .65524 m
.30079 .65524 L
s
.72365 .76123 m
.74189 .77374 L
s
.49178 .65169 m
.49183 .64717 L
s
.29427 .33514 m
.33874 .36048 L
s
.49809 .9718 m
.52585 .91756 L
s
.7176 .44125 m
.69884 .44067 L
s
.48546 .33087 m
.4999 .32551 L
s
.25888 .54166 m
.27158 .56203 L
s
.68363 .64813 m
.68408 .65723 L
s
.45064 .53784 m
.45339 .54078 L
s
.45702 .85951 m
.46561 .82522 L
s
.67751 .32659 m
.66316 .30653 L
s
.87634 .64454 m
.88092 .68596 L
s
.64943 .85639 m
.67946 .84855 L
s
.21659 .42706 m
.25132 .46463 L
s
.64325 .534 m
.636 .53705 L
s
.41558 .7462 m
.415 .73017 L
s
.40912 .42297 m
.42417 .4301 L
s
.83674 .53015 m
.82261 .55108 L
s
.60876 .74282 m
.6187 .73999 L
s
.17393 .31143 m
.24007 .36241 L
s
.38028 .95598 m
.38399 .89764 L
s
.60251 .41885 m
.59746 .41248 L
s
.37376 .63188 m
.37376 .63188 L
s
.80283 .73943 m
.82521 .76894 L
s
.57404 .95306 m
.61096 .91992 L
s
.36722 .30705 m
.40417 .31442 L
s
.79677 .41472 m
.77425 .41176 L
s
.56773 .62823 m
.56773 .62823 L
s
.33816 .84221 m
.33046 .80996 L
s
.5614 .30266 m
.56842 .28275 L
s
.33156 .51652 m
.34174 .52976 L
s
.76257 .62455 m
.76396 .64294 L
s
.53271 .83902 m
.54715 .81891 L
s
.75645 .29824 m
.73575 .2671 L
s
.52632 .51259 m
.52632 .51259 L
s
.29566 .72742 m
.28638 .71939 L
s
.72814 .83582 m
.76464 .84749 L
s
.28898 .40011 m
.31889 .42316 L
s
.72196 .50864 m
.71269 .51306 L
s
.491 .72395 m
.49322 .71508 L
s
.48453 .39589 m
.49436 .39236 L
s
.25277 .61157 m
.25156 .62539 L
s
.68723 .72047 m
.70036 .72977 L
s
.24601 .28263 m
.30527 .31138 L
s
.45543 .93677 m
.46847 .89469 L
s
.68097 .39166 m
.67124 .37849 L
s
.4489 .60782 m
.4489 .60782 L
s
.88436 .71697 m
.91148 .76396 L
s
.44235 .27813 m
.47187 .26676 L
s
.65226 .93376 m
.69849 .92235 L
s
.20948 .49466 m
.22589 .52739 L
s
.64594 .60406 m
.64611 .60866 L
s
.41303 .82122 m
.41151 .7984 L
s
.6396 .2736 m
.63955 .23837 L
s
.40642 .49063 m
.41404 .4965 L
s
.84388 .60028 m
.84672 .62814 L
s
.61066 .81793 m
.63105 .81242 L
s
.1658 .37667 m
.20938 .42475 L
s
.60427 .48657 m
.60169 .48344 L
s
.37024 .7046 m
.36424 .69909 L
s
.80921 .81463 m
.85256 .84639 L
s
.36354 .37235 m
.38857 .38039 L
s
.80303 .4825 m
.79222 .48818 L
s
.56869 .70103 m
.57375 .69953 L
s
.3338 .92006 m
.32141 .87897 L
s
.56221 .368 m
.56698 .35332 L
s
.32704 .5869 m
.32645 .59617 L
s
.76805 .69744 m
.78468 .71921 L
s
.32027 .25297 m
.37257 .25871 L
s
.53286 .91698 m
.55512 .89167 L
s
.76179 .36364 m
.74781 .34321 L
s
.52632 .58304 m
.52632 .58304 L
s
.29029 .80295 m
.27114 .78725 L
s
.51976 .24832 m
.54197 .21742 L
s
.73284 .91388 m
.78852 .92485 L
s
.28345 .4681 m
.29804 .48898 L
s
.72652 .57916 m
.72712 .58845 L
s
.49017 .79958 m
.49468 .78654 L
s
.72018 .24366 m
.71342 .19227 L
s
.48355 .46395 m
.48858 .46221 L
s
.24637 .68475 m
.23042 .69231 L
s
.69099 .79619 m
.7174 .80573 L
s
.23945 .3482 m
.27901 .37681 L
s
.68459 .45977 m
.67964 .4533 L
s
.44709 .68109 m
.44419 .67825 L
s
.89275 .79279 m
.94334 .84526 L
s
.44038 .34374 m
.46048 .33626 L
s
.20204 .56544 m
.19908 .59357 L
s
.64875 .67741 m
.65669 .68353 L
s
.41037 .89976 m
.40781 .87051 L
s
.64227 .33926 m
.64213 .3129 L
s
.4036 .56147 m
.40341 .56613 L
s
.85136 .67371 m
.8718 .7083 L
s
.39681 .22239 m
.44208 .20431 L
s
.61265 .89658 m
.64402 .88856 L
s
.15729 .445 m
.17707 .49039 L
s
.60611 .55749 m
.60611 .55749 L
s
.36655 .78076 m
.35419 .77 L
s
.59954 .21761 m
.61459 .1663 L
s
.8159 .89339 m
.88117 .92743 L
s
.35969 .44073 m
.37224 .44947 L
s
.80957 .55349 m
.81087 .56754 L
s
.56969 .77728 m
.58007 .77437 L
s
.56306 .43645 m
.56547 .42684 L
s
.32231 .66062 m
.31035 .66611 L
s
.7738 .77379 m
.80632 .79885 L
s
.31537 .31884 m
.35068 .32746 L
s
.76739 .43214 m
.7603 .42211 L
s
.52632 .65685 m
.52632 .65685 L
s
.28466 .88209 m
.25499 .85916 L
s
.5196 .31424 m
.53471 .29069 L
s
.27765 .53934 m
.27612 .55818 L
s
.73129 .65305 m
.74215 .66703 L
s
.48931 .87883 m
.49622 .86186 L
s
.72481 .30962 m
.71997 .27105 L
s
.48253 .53526 m
.48253 .53526 L
s
.23967 .76143 m
.20806 .7631 L
s
.47573 .19087 m
.5139 .1481 L
s
.69493 .87555 m
.73526 .88537 L
s
.23257 .4169 m
.25145 .44549 L
s
.68838 .53115 m
.68838 .53115 L
s
.44519 .75787 m
.43922 .75234 L
s
.68182 .18593 m
.68986 .11331 L
s
.90155 .87225 m
.97657 .93008 L
s
.43832 .4125 m
.44858 .40882 L
s
.65169 .75428 m
.66776 .76187 L
s
.19423 .63962 m
.17077 .66346 L
s
.64506 .40808 m
.64482 .39034 L
s
.40064 .63574 m
.39225 .63926 L
s
.8592 .75068 m
.89792 .79177 L
s
.60804 .63184 m
.61072 .63484 L
s
.39368 .28856 m
.42448 .27665 L
s
.14836 .51663 m
.14301 .55958 L
s
.36268 .8606 m
.34358 .84491 L
s
.60132 .28382 m
.61139 .24364 L
s
.35565 .51243 m
.35512 .52188 L
s
.81644 .62793 m
.83026 .65003 L
s
.56395 .50821 m
.56389 .50351 L
s
.57074 .85723 m
.58671 .853 L
s
.31735 .73793 m
.29337 .73986 L
s
.55715 .15835 m
.58815 .08999 L
s
.77982 .85385 m
.82893 .8821 L
s
.31024 .38792 m
.32777 .39942 L
s
.77326 .50398 m
.77326 .50398 L
s
.52632 .73425 m
.52632 .73425 L
s
.7363 .73055 m
.75784 .74902 L
s
.51944 .38338 m
.52716 .36698 L
s
.27158 .61407 m
.25305 .63103 L
s
.69236 .60604 m
.69749 .61223 L
s
.72967 .37882 m
.72674 .35265 L
s
.48145 .61006 m
.47619 .61174 L
s
.23263 .84188 m
.18436 .83809 L
s
.47449 .25732 m
.50051 .22431 L
s
.22535 .48899 m
.22248 .51768 L
s
.44319 .83842 m
.434 .83037 L
s
.68564 .25242 m
.69063 .195 L
s
.64799 .4803 m
.64761 .47084 L
s
.43615 .48465 m
.43615 .48465 L
s
.65478 .83495 m
.67935 .84393 L
s
.18605 .71746 m
.14083 .73736 L
s
.86743 .83146 m
.92513 .87874 L
s
.61006 .70988 m
.61554 .71572 L
s
.39753 .71368 m
.38052 .71613 L
s
.64118 .12478 m
.66497 .02988 L
s
.82365 .70606 m
.85042 .73582 L
s
.3904 .358 m
.40612 .35213 L
s
.139 .5918 m
.10706 .63263 L
s
.56489 .58356 m
.56225 .58352 L
s
.60318 .35331 m
.60807 .3239 L
s
.77943 .5794 m
.78672 .58897 L
s
.35142 .58769 m
.33715 .59788 L
s
.74157 .81194 m
.77422 .83464 L
s
.31214 .8191 m
.27545 .81776 L
s
.55792 .22506 m
.57886 .17036 L
s
.51927 .45597 m
.51929 .44646 L
s
.30484 .46045 m
.30377 .47482 L
s
.73477 .45148 m
.73377 .43721 L
s
.69655 .6847 m
.70697 .69673 L
s
.52632 .81553 m
.52632 .81553 L
s
.26519 .69254 m
.22873 .70783 L
s
.48033 .68863 m
.46955 .69189 L
s
.65107 .55618 m
.65051 .55459 L
s
.47319 .32711 m
.48658 .30357 L
s
.68966 .32226 m
.69141 .27952 L
s
.21777 .5647 m
.192 .59365 L
s
.43388 .56045 m
.42314 .56399 L
s
.83122 .78817 m
.87141 .82512 L
s
.61219 .79187 m
.62059 .80037 L
s
.60513 .42635 m
.60462 .40725 L
s
.17745 .79923 m
.10911 .81564 L
s
.78591 .65869 m
.80071 .67726 L
s
.56587 .66275 m
.56054 .66711 L
s
.39427 .79556 m
.36817 .79706 L
s
.64409 .19174 m
.65966 .11473 L
s
.38695 .43097 m
.38695 .43097 L
s
.12916 .6708 m
.06904 .70987 L
s
.74013 .52788 m
.74105 .5249 L
s
.34696 .66679 m
.31827 .67774 L
s
.51909 .5323 m
.51108 .52934 L
s
.55872 .29519 m
.56923 .25368 L
s
.70094 .76743 m
.71687 .78488 L
s
.29917 .53669 m
.2786 .55391 L
s
.69388 .39572 m
.69223 .367 L
s
.65431 .636 m
.65353 .64179 L
s
.47182 .4005 m
.47208 .38608 L
s
.47914 .77124 m
.46259 .77599 L
s
.25848 .77504 m
.20305 .7889 L
s
.60719 .50319 m
.60104 .49389 L
s
.43148 .64017 m
.40952 .64708 L
s
.79273 .74215 m
.81524 .76906 L
s
.2098 .64432 m
.15987 .67371 L
s
.64715 .26219 m
.65417 .20242 L
s
.74578 .60832 m
.74861 .6159 L
s
.56691 .74609 m
.55874 .75452 L
s
.38332 .50773 m
.36691 .51338 L
s
.55957 .36899 m
.55924 .34013 L
s
.5189 .61264 m
.50252 .61584 L
s
.11881 .75392 m
.02877 .79167 L
s
.69833 .47308 m
.69308 .45761 L
s
.34227 .75002 m
.29841 .76176 L
s
.65772 .72007 m
.65668 .73266 L
s
.47037 .47778 m
.45698 .47204 L
s
.2932 .61694 m
.25216 .63696 L
s
.60936 .58415 m
.59731 .58399 L
s
.65038 .33639 m
.6485 .29307 L
s
.75174 .69313 m
.75646 .71039 L
s
.42896 .72413 m
.39524 .7342 L
s
.56047 .44678 m
.54887 .42988 L
s
.20141 .72817 m
.12597 .75818 L
s
.70303 .55466 m
.69395 .55152 L
s
.3795 .5886 m
.34593 .59962 L
s
.5187 .69733 m
.49357 .70621 L
s
.65378 .41467 m
.64263 .38685 L
s
.46885 .55926 m
.44123 .56168 L
s
.61164 .66958 m
.59343 .67779 L
s
.28691 .70152 m
.22436 .72429 L
s
.56142 .52887 m
.53809 .52311 L
s
.70798 .64081 m
.69486 .64891 L
s
.37547 .67391 m
.32396 .68997 L
s
.65738 .49736 m
.63655 .48391 L
s
.46724 .6453 m
.42479 .65523 L
s
.56242 .61564 m
.52689 .62005 L
s
.66118 .58485 m
.63026 .58444 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.40.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.40.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ScaleFactor", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the scale of the vectors to the mesh; ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["Max", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ensures that the largest vector fits in the mesh",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ScaleFunction", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the function to use for rescaling the magnitude of vectors ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MaxArrowLength", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "determine the largest vector to be drawn ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ColorFunction", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["the colors to use",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotPoints", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["7", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the number of evaluation points in each direction ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VectorHeads", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to draw vectors with heads ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.40.1"],

Cell["Options for vector field plotting.", "Caption",
 CellTags->"S5.40.1"],

Cell[TextData[{
 "This sets the number of sample points in each direction to ",
 Cell[BoxData[
  FormBox["5", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " and puts heads on the arrows. "
}], "MathCaption",
 CellTags->{"S5.40.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
PlotVectorField3D[{x , y, z}, {x, 0, 2},
    {y, 0, 2}, {z, 0, 2}, PlotPoints -> 5,
    VectorHeads -> True]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.40.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08563 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567784 1.16618 1.39862e-17 1.16618 [
[ 0 0 0 0 ]
[ 1 1.08563 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08845 .24554 m
0 .80386 L
s
0 .80386 m
.40036 1.08563 L
s
.40036 1.08563 m
.41798 .58158 L
s
.41798 .58158 m
.08845 .24554 L
s
.67244 0 m
.92712 .41495 L
s
.92712 .41495 m
1 .94826 L
s
1 .94826 m
.70642 .5856 L
s
.70642 .5856 m
.67244 0 L
s
.08845 .24554 m
0 .80386 L
s
0 .80386 m
.70642 .5856 L
s
.70642 .5856 m
.67244 0 L
s
.67244 0 m
.08845 .24554 L
s
.41798 .58158 m
.92712 .41495 L
s
.92712 .41495 m
1 .94826 L
s
1 .94826 m
.40036 1.08563 L
s
.40036 1.08563 m
.41798 .58158 L
s
0 0 m
1 0 L
1 1.08563 L
0 1.08563 L
closepath
clip
newpath
.5 Mabswid
.43293 .58841 m
.4262 .58917 L
s
.42668 .57438 m
.43293 .58841 L
s
.43293 .58841 m
.41854 .58434 L
s
.43436 .57917 m
.43293 .58841 L
s
.39996 .55462 m
.43293 .58841 L
s
.42668 .57438 m
.41854 .58434 L
s
.43436 .57917 m
.42668 .57438 L
s
.41854 .58434 m
.4262 .58917 L
s
.4262 .58917 m
.43436 .57917 L
s
.54474 .55207 m
.5357 .55379 L
s
.53566 .5384 m
.54474 .55207 L
s
.54474 .55207 m
.52856 .55 L
s
.54284 .54212 m
.54474 .55207 L
s
.49878 .52164 m
.54474 .55207 L
s
.53566 .5384 m
.52856 .55 L
s
.54284 .54212 m
.53566 .5384 L
s
.52856 .55 m
.5357 .55379 L
s
.5357 .55379 m
.54284 .54212 L
s
.42975 .69429 m
.42165 .69184 L
s
.42457 .67837 m
.42975 .69429 L
s
.42975 .69429 m
.41471 .68766 L
s
.43154 .6825 m
.42975 .69429 L
s
.39613 .64765 m
.42975 .69429 L
s
.42457 .67837 m
.41471 .68766 L
s
.43154 .6825 m
.42457 .67837 L
s
.41471 .68766 m
.42165 .69184 L
s
.42165 .69184 m
.43154 .6825 L
s
.36625 .52006 m
.36067 .52031 L
s
.36128 .50903 m
.36625 .52006 L
s
.36625 .52006 m
.35489 .51675 L
s
.36707 .51256 m
.36625 .52006 L
s
.33956 .49271 m
.36625 .52006 L
s
.36128 .50903 m
.35489 .51675 L
s
.36707 .51256 m
.36128 .50903 L
s
.35489 .51675 m
.36067 .52031 L
s
.6432 .51422 m
.65005 .51727 L
s
.64936 .50042 m
.6432 .51422 L
s
.66156 .51411 m
.6432 .51422 L
s
.66156 .51411 m
.65005 .51727 L
s
.64936 .50042 m
.66156 .51411 L
s
.65624 .50339 m
.66156 .51411 L
s
.60153 .48735 m
.66156 .51411 L
s
.65624 .50339 m
.64936 .50042 L
s
.36067 .52031 m
.36707 .51256 L
s
.65005 .51727 m
.65624 .50339 L
s
.5376 .64328 m
.52842 .65439 L
s
.54362 .64653 m
.5376 .64328 L
s
.5376 .64328 m
.54539 .65908 L
s
.54539 .65908 m
.53439 .65771 L
s
.54539 .65908 m
.52842 .65439 L
s
.54362 .64653 m
.54539 .65908 L
s
.49793 .61552 m
.54539 .65908 L
s
.52842 .65439 m
.53439 .65771 L
s
.53439 .65771 m
.54362 .64653 L
s
.48125 .48064 m
.47315 .48202 L
s
.47336 .47002 m
.48125 .48064 L
s
.48125 .48064 m
.4681 .47954 L
s
.47843 .47246 m
.48125 .48064 L
s
.44085 .45725 m
.48125 .48064 L
s
.47336 .47002 m
.4681 .47954 L
s
.47843 .47246 m
.47336 .47002 L
s
.4681 .47954 m
.47315 .48202 L
s
.76279 .4769 m
.7696 .47944 L
s
.76806 .46043 m
.76279 .4769 L
s
.78373 .47441 m
.76279 .4769 L
s
.77492 .46287 m
.76806 .46043 L
s
.76806 .46043 m
.78373 .47441 L
s
.78373 .47441 m
.7696 .47944 L
s
.77492 .46287 m
.78373 .47441 L
s
.70844 .45166 m
.78373 .47441 L
s
.42231 .78933 m
.41013 .79822 L
s
.42901 .79284 m
.42231 .78933 L
s
.42231 .78933 m
.42634 .80764 L
s
.47315 .48202 m
.47843 .47246 L
s
.42634 .80764 m
.41677 .80178 L
s
.42634 .80764 m
.41013 .79822 L
s
.42901 .79284 m
.42634 .80764 L
s
.39207 .7465 m
.42634 .80764 L
s
.41013 .79822 m
.41677 .80178 L
s
.7696 .47944 m
.77492 .46287 L
s
.41677 .80178 m
.42901 .79284 L
s
.35687 .61518 m
.34861 .6221 L
s
.36188 .61781 m
.35687 .61518 L
s
.35687 .61518 m
.36056 .62803 L
s
.36056 .62803 m
.35359 .62476 L
s
.36056 .62803 m
.34861 .6221 L
s
.36188 .61781 m
.36056 .62803 L
s
.33369 .58731 m
.36056 .62803 L
s
.34861 .6221 m
.35359 .62476 L
s
.65559 .60612 m
.6471 .61966 L
s
.66095 .60888 m
.65559 .60612 L
s
.65559 .60612 m
.66639 .62225 L
s
.6471 .61966 m
.6524 .62251 L
s
.66639 .62225 m
.6471 .61966 L
s
.66639 .62225 m
.6524 .62251 L
s
.66095 .60888 m
.66639 .62225 L
s
.6039 .58207 m
.66639 .62225 L
s
.35359 .62476 m
.36188 .61781 L
s
.29383 .44584 m
.28971 .44576 L
s
.29032 .43811 m
.29383 .44584 L
s
.29383 .44584 m
.28585 .44345 L
s
.29419 .44041 m
.29383 .44584 L
s
.27457 .4261 m
.29383 .44584 L
s
.29032 .43811 m
.28585 .44345 L
s
.29419 .44041 m
.29032 .43811 L
s
.28585 .44345 m
.28971 .44576 L
s
.6524 .62251 m
.66095 .60888 L
s
.58628 .44069 m
.5908 .44252 L
s
.5905 .4287 m
.58628 .44069 L
s
.60162 .43937 m
.58628 .44069 L
s
.28971 .44576 m
.29419 .44041 L
s
.59505 .43047 m
.5905 .4287 L
s
.5905 .4287 m
.60162 .43937 L
s
.60162 .43937 m
.5908 .44252 L
s
.59505 .43047 m
.60162 .43937 L
s
.54631 .42032 m
.60162 .43937 L
s
.88763 .43793 m
.89476 .4401 L
s
.89206 .4184 m
.88763 .43793 L
s
.91163 .43285 m
.88763 .43793 L
s
.89923 .42041 m
.89206 .4184 L
s
.89206 .4184 m
.91163 .43285 L
s
.53967 .75539 m
.52787 .76631 L
s
.54487 .75813 m
.53967 .75539 L
s
.53967 .75539 m
.54607 .77382 L
s
.91163 .43285 m
.89476 .4401 L
s
.89923 .42041 m
.91163 .43285 L
s
.81978 .41451 m
.91163 .43285 L
s
.5908 .44252 m
.59505 .43047 L
s
.52787 .76631 m
.53298 .76912 L
s
.54607 .77382 m
.52787 .76631 L
s
.54607 .77382 m
.53298 .76912 L
s
.54487 .75813 m
.54607 .77382 L
s
.49703 .71539 m
.54607 .77382 L
s
.89476 .4401 m
.89923 .42041 L
s
.53298 .76912 m
.54487 .75813 L
s
.47335 .57696 m
.46578 .58597 L
s
.47698 .57874 m
.47335 .57696 L
s
.47335 .57696 m
.47961 .58972 L
s
.46578 .58597 m
.46937 .5878 L
s
.47961 .58972 m
.46578 .58597 L
s
.47961 .58972 m
.46937 .5878 L
s
.47698 .57874 m
.47961 .58972 L
s
.43811 .55268 m
.47961 .58972 L
s
.77106 .58336 m
.77609 .58603 L
s
.77885 .56689 m
.77106 .58336 L
s
.79313 .58367 m
.77106 .58336 L
s
.78394 .56943 m
.77885 .56689 L
s
.77885 .56689 m
.79313 .58367 L
s
.4199 .90801 m
.40484 .91673 L
s
.42669 .911 m
.4199 .90801 L
s
.4199 .90801 m
.42268 .92928 L
s
.79313 .58367 m
.77609 .58603 L
s
.78394 .56943 m
.79313 .58367 L
s
.7143 .54723 m
.79313 .58367 L
s
.46937 .5878 m
.47698 .57874 L
s
.40484 .91673 m
.41154 .91979 L
s
.42268 .92928 m
.40484 .91673 L
s
.42268 .92928 m
.41154 .91979 L
s
.42669 .911 m
.42268 .92928 L
s
.38774 .85172 m
.42268 .92928 L
s
.40241 .40298 m
.40529 .40425 L
s
.40564 .39562 m
.40241 .40298 L
s
.41217 .40292 m
.40241 .40298 L
s
.41217 .40292 m
.40529 .40425 L
s
.40564 .39562 m
.41217 .40292 L
s
.40853 .39687 m
.41217 .40292 L
s
.37842 .38787 m
.41217 .40292 L
s
.40853 .39687 m
.40564 .39562 L
s
.70977 .4001 m
.71406 .40151 L
s
.713 .38512 m
.70977 .4001 L
s
.72775 .39613 m
.70977 .4001 L
s
.77609 .58603 m
.78394 .56943 L
s
.41154 .91979 m
.42669 .911 L
s
.71732 .38643 m
.713 .38512 L
s
.713 .38512 m
.72775 .39613 L
s
.40529 .40425 m
.40853 .39687 L
s
.35214 .72878 m
.34127 .73519 L
s
.35692 .73047 m
.35214 .72878 L
s
.35214 .72878 m
.35445 .74395 L
s
.72775 .39613 m
.71406 .40151 L
s
.71732 .38643 m
.72775 .39613 L
s
.65622 .38185 m
.72775 .39613 L
s
.34127 .73519 m
.346 .73691 L
s
.35445 .74395 m
.34127 .73519 L
s
.35445 .74395 m
.346 .73691 L
s
.35692 .73047 m
.35445 .74395 L
s
.32744 .68804 m
.35445 .74395 L
s
.66227 .7193 m
.65095 .7329 L
s
.66633 .72178 m
.66227 .7193 L
s
.66227 .7193 m
.67157 .73838 L
s
.65095 .7329 m
.65493 .73549 L
s
.67157 .73838 m
.65095 .7329 L
s
.71406 .40151 m
.71732 .38643 L
s
.346 .73691 m
.35692 .73047 L
s
.67157 .73838 m
.65493 .73549 L
s
.66633 .72178 m
.67157 .73838 L
s
.60643 .68297 m
.67157 .73838 L
s
.2832 .54644 m
.27664 .55082 L
s
.28628 .54752 m
.2832 .54644 L
s
.2832 .54644 m
.28521 .55586 L
s
.28521 .55586 m
.2797 .55192 L
s
.28521 .55586 m
.27664 .55082 L
s
.28628 .54752 m
.28521 .55586 L
s
.26636 .52223 m
.28521 .55586 L
s
.27664 .55082 m
.2797 .55192 L
s
.65493 .73549 m
.66633 .72178 L
s
.58828 .54815 m
.59089 .5497 L
s
.59508 .53633 m
.58828 .54815 L
s
.60443 .54956 m
.58828 .54815 L
s
.59773 .5378 m
.59508 .53633 L
s
.59508 .53633 m
.60443 .54956 L
s
.2797 .55192 m
.28628 .54752 L
s
.90066 .5454 m
.90586 .54803 L
s
.90773 .52561 m
.90066 .5454 L
s
.92604 .54321 m
.90066 .5454 L
s
.60443 .54956 m
.59089 .5497 L
s
.59773 .5378 m
.60443 .54956 L
s
.54697 .51658 m
.60443 .54956 L
s
.91301 .52805 m
.90773 .52561 L
s
.90773 .52561 m
.92604 .54321 L
s
.5419 .87551 m
.52694 .88649 L
s
.54654 .87781 m
.5419 .87551 L
s
.5419 .87551 m
.54682 .89716 L
s
.52694 .88649 m
.53147 .88888 L
s
.54682 .89716 m
.52694 .88649 L
s
.92604 .54321 m
.90586 .54803 L
s
.91301 .52805 m
.92604 .54321 L
s
.82942 .51089 m
.92604 .54321 L
s
.21493 .36496 m
.21263 .36478 L
s
.21305 .36089 m
.21493 .36496 L
s
.21493 .36496 m
.2107 .36366 L
s
.21499 .362 m
.21493 .36496 L
s
.20447 .35424 m
.21493 .36496 L
s
.59089 .5497 m
.59773 .5378 L
s
.21305 .36089 m
.2107 .36366 L
s
.21499 .362 m
.21305 .36089 L
s
.2107 .36366 m
.21263 .36478 L
s
.21263 .36478 m
.21499 .362 L
s
.54682 .89716 m
.53147 .88888 L
s
.54654 .87781 m
.54682 .89716 L
s
.49606 .82184 m
.54682 .89716 L
s
.52432 .36065 m
.52641 .36144 L
s
.52641 .35043 m
.52432 .36065 L
s
.53628 .3579 m
.52432 .36065 L
s
.52851 .35117 m
.52641 .35043 L
s
.52641 .35043 m
.53628 .3579 L
s
.53628 .3579 m
.52641 .36144 L
s
.52851 .35117 m
.53628 .3579 L
s
.48672 .348 m
.53628 .3579 L
s
.83893 .35764 m
.84336 .35874 L
s
.84121 .33926 m
.83893 .35764 L
s
.86006 .35077 m
.83893 .35764 L
s
.84566 .34022 m
.84121 .33926 L
s
.84121 .33926 m
.86006 .35077 L
s
.90586 .54803 m
.91301 .52805 L
s
.53147 .88888 m
.54654 .87781 L
s
.52641 .36144 m
.52851 .35117 L
s
.47335 .69162 m
.46281 .70048 L
s
.47591 .69261 m
.47335 .69162 L
s
.47335 .69162 m
.47785 .70704 L
s
.86006 .35077 m
.84336 .35874 L
s
.84566 .34022 m
.86006 .35077 L
s
.77085 .34171 m
.86006 .35077 L
s
.46281 .70048 m
.46531 .70152 L
s
.47785 .70704 m
.46281 .70048 L
s
.47785 .70704 m
.46531 .70152 L
s
.47591 .69261 m
.47785 .70704 L
s
.43518 .65444 m
.47785 .70704 L
s
.77969 .69789 m
.78306 .70061 L
s
.79042 .68111 m
.77969 .69789 L
s
.80324 .7012 m
.77969 .69789 L
s
.79389 .68368 m
.79042 .68111 L
s
.79042 .68111 m
.80324 .7012 L
s
.41732 1.03523 m
.39888 1.044 L
s
.42448 1.03793 m
.41732 1.03523 L
s
.41732 1.03523 m
.41875 1.06016 L
s
.84336 .35874 m
.84566 .34022 L
s
.46531 .70152 m
.47591 .69261 L
s
.80324 .7012 m
.78306 .70061 L
s
.79389 .68368 m
.80324 .7012 L
s
.72055 .64914 m
.80324 .7012 L
s
.39888 1.044 m
.40591 1.04679 L
s
.41875 1.06016 m
.39888 1.044 L
s
.41875 1.06016 m
.40591 1.04679 L
s
.42448 1.03793 m
.41875 1.06016 L
s
.38313 .96394 m
.41875 1.06016 L
s
.4034 .5045 m
.39752 .51146 L
s
.40446 .50492 m
.4034 .5045 L
s
.4034 .5045 m
.40783 .51402 L
s
.39752 .51146 m
.39856 .51191 L
s
.40783 .51402 m
.39752 .51146 L
s
.40783 .51402 m
.39856 .51191 L
s
.40446 .50492 m
.40783 .51402 L
s
.37349 .48481 m
.40783 .51402 L
s
.71647 .50855 m
.71858 .5101 L
s
.72241 .49339 m
.71647 .50855 L
s
.73544 .5074 m
.71647 .50855 L
s
.78306 .70061 m
.79389 .68368 L
s
.72457 .49483 m
.72241 .49339 L
s
.72241 .49339 m
.73544 .5074 L
s
.40591 1.04679 m
.42448 1.03793 L
s
.34707 .85063 m
.33294 .85678 L
s
.35203 .85147 m
.34707 .85063 L
s
.34707 .85063 m
.34788 .86873 L
s
.39856 .51191 m
.40446 .50492 L
s
.73544 .5074 m
.71858 .5101 L
s
.72457 .49483 m
.73544 .5074 L
s
.66056 .47891 m
.73544 .5074 L
s
.33294 .85678 m
.33782 .85766 L
s
.34788 .86873 m
.33294 .85678 L
s
.66943 .8408 m
.65481 .85472 L
s
.67239 .84305 m
.66943 .8408 L
s
.66943 .8408 m
.67715 .86344 L
s
.34788 .86873 m
.33782 .85766 L
s
.35203 .85147 m
.34788 .86873 L
s
.32078 .79554 m
.34788 .86873 L
s
.65481 .85472 m
.65765 .8571 L
s
.67715 .86344 m
.65481 .85472 L
s
.33077 .31949 m
.3314 .31979 L
s
.33178 .31425 m
.33077 .31949 L
s
.33674 .31805 m
.33077 .31949 L
s
.33242 .31455 m
.33178 .31425 L
s
.33178 .31425 m
.33674 .31805 L
s
.71858 .5101 m
.72457 .49483 L
s
.33674 .31805 m
.3314 .31979 L
s
.33242 .31455 m
.33674 .31805 L
s
.31097 .3129 m
.33674 .31805 L
s
.33782 .85766 m
.35203 .85147 L
s
.65195 .31634 m
.65357 .31687 L
s
.65294 .30272 m
.65195 .31634 L
s
.6666 .31062 m
.65195 .31634 L
s
.3314 .31979 m
.33242 .31455 L
s
.65457 .30317 m
.65294 .30272 L
s
.65294 .30272 m
.6666 .31062 L
s
.67715 .86344 m
.65765 .8571 L
s
.67239 .84305 m
.67715 .86344 L
s
.60912 .79065 m
.67715 .86344 L
s
.27556 .6627 m
.26594 .6665 L
s
.27858 .66245 m
.27556 .6627 L
s
.27556 .6627 m
.27591 .67436 L
s
.6666 .31062 m
.65357 .31687 L
s
.65457 .30317 m
.6666 .31062 L
s
.59977 .30638 m
.6666 .31062 L
s
.26594 .6665 m
.26892 .66626 L
s
.27591 .67436 m
.26594 .6665 L
s
.27591 .67436 m
.26892 .66626 L
s
.27858 .66245 m
.27591 .67436 L
s
.25758 .62485 m
.27591 .67436 L
s
.59012 .664 m
.59099 .6651 L
s
.6 .65195 m
.59012 .664 L
s
.60745 .66827 m
.59012 .664 L
s
.60093 .65297 m
.6 .65195 L
s
.6 .65195 m
.60745 .66827 L
s
.65765 .8571 m
.67239 .84305 L
s
.65357 .31687 m
.65457 .30317 L
s
.26892 .66626 m
.27858 .66245 L
s
.91448 .6612 m
.91782 .66422 L
s
.92458 .64084 m
.91448 .6612 L
s
.94156 .66213 m
.91448 .6612 L
s
.92802 .64366 m
.92458 .64084 L
s
.92458 .64084 m
.94156 .66213 L
s
.60745 .66827 m
.59099 .6651 L
s
.60093 .65297 m
.60745 .66827 L
s
.54767 .61936 m
.60745 .66827 L
s
.54429 1.00452 m
.52568 1.01577 L
s
.54861 1.00658 m
.54429 1.00452 L
s
.54429 1.00452 m
.54761 1.0301 L
s
.52568 1.01577 m
.52984 1.01795 L
s
.54761 1.0301 m
.52568 1.01577 L
s
.20275 .47135 m
.19783 .47309 L
s
.20411 .47081 m
.20275 .47135 L
s
.20275 .47135 m
.20283 .47697 L
s
.19783 .47309 m
.19918 .47255 L
s
.20283 .47697 m
.19783 .47309 L
s
.59099 .6651 m
.60093 .65297 L
s
.94156 .66213 m
.91782 .66422 L
s
.92802 .64366 m
.94156 .66213 L
s
.83972 .61382 m
.94156 .66213 L
s
.20283 .47697 m
.19918 .47255 L
s
.20411 .47081 m
.20283 .47697 L
s
.19353 .45185 m
.20283 .47697 L
s
.19918 .47255 m
.20411 .47081 L
s
.52411 .4701 m
.52382 .47065 L
s
.529 .45977 m
.52411 .4701 L
s
.53667 .47006 m
.52411 .4701 L
s
.52873 .46027 m
.529 .45977 L
s
.529 .45977 m
.53667 .47006 L
s
.54761 1.0301 m
.52984 1.01795 L
s
.54861 1.00658 m
.54761 1.0301 L
s
.49503 .93553 m
.54761 1.0301 L
s
.85074 .46704 m
.85286 .46868 L
s
.85581 .44818 m
.85074 .46704 L
s
.87312 .4631 m
.85074 .46704 L
s
.53667 .47006 m
.52382 .47065 L
s
.52873 .46027 m
.53667 .47006 L
s
.48537 .44573 m
.53667 .47006 L
s
.85798 .44966 m
.85581 .44818 L
s
.85581 .44818 m
.87312 .4631 L
s
.91782 .66422 m
.92802 .64366 L
s
.47334 .81487 m
.45928 .82385 L
s
.47511 .81508 m
.47334 .81487 L
s
.47334 .81487 m
.47595 .83356 L
s
.52984 1.01795 m
.54861 1.00658 L
s
.52382 .47065 m
.52873 .46027 L
s
.45928 .82385 m
.46094 .82413 L
s
.47595 .83356 m
.45928 .82385 L
s
.87312 .4631 m
.85286 .46868 L
s
.85798 .44966 m
.87312 .4631 L
s
.77921 .43956 m
.87312 .4631 L
s
.01 w
.1286 .27649 Mdot
.5 Mabswid
.78876 .82132 m
.79058 .82413 L
s
.80287 .80396 m
.78876 .82132 L
s
.81415 .82799 m
.78876 .82132 L
s
.80483 .8066 m
.80287 .80396 L
s
.80287 .80396 m
.81415 .82799 L
s
.45661 .2732 m
.45615 .27335 L
s
.45637 .26452 m
.45661 .2732 L
s
.46477 .26874 m
.45661 .2732 L
s
.43206 .76317 m
.47595 .83356 L
s
.47595 .83356 m
.46094 .82413 L
s
.47511 .81508 m
.47595 .83356 L
s
.45591 .26465 m
.45637 .26452 L
s
.45637 .26452 m
.46477 .26874 L
s
.78572 .2699 m
.78727 .27018 L
s
.78562 .25251 m
.78572 .2699 L
s
.8036 .26092 m
.78572 .2699 L
s
.42223 .26972 m
.46477 .26874 L
s
.85286 .46868 m
.85798 .44966 L
s
.46477 .26874 m
.45615 .27335 L
s
.45591 .26465 m
.46477 .26874 L
s
.78717 .25267 m
.78562 .25251 L
s
.78562 .25251 m
.8036 .26092 L
s
.46094 .82413 m
.47511 .81508 L
s
.72723 .75807 m
.81415 .82799 L
s
.45615 .27335 m
.45591 .26465 L
s
.81415 .82799 m
.79058 .82413 L
s
.80483 .8066 m
.81415 .82799 L
s
.71787 .2629 m
.8036 .26092 L
s
.40098 .62162 m
.39176 .62868 L
s
.40056 .62092 m
.40098 .62162 L
s
.40098 .62162 m
.40314 .63391 L
s
.39176 .62868 m
.3913 .62802 L
s
.40314 .63391 m
.39176 .62868 L
s
.8036 .26092 m
.78727 .27018 L
s
.78717 .25267 m
.8036 .26092 L
s
.36822 .58844 m
.40314 .63391 L
s
.72347 .62565 m
.72345 .62717 L
s
.73254 .60995 m
.72347 .62565 L
s
.74374 .62751 m
.72347 .62565 L
s
.34162 .98166 m
.32371 .98776 L
s
.34704 .98188 m
.34162 .98166 L
s
.34162 .98166 m
.34078 1.00345 L
s
.40314 .63391 m
.3913 .62802 L
s
.40056 .62092 m
.40314 .63391 L
s
.73259 .61135 m
.73254 .60995 L
s
.73254 .60995 m
.74374 .62751 L
s
.79058 .82413 m
.80483 .8066 L
s
.78727 .27018 m
.78717 .25267 L
s
.3913 .62802 m
.40056 .62092 L
s
.66521 .58269 m
.74374 .62751 L
s
.32371 .98776 m
.32899 .98803 L
s
.34078 1.00345 m
.32371 .98776 L
s
.31365 .91048 m
.34078 1.00345 L
s
.74374 .62751 m
.72345 .62717 L
s
.73259 .61135 m
.74374 .62751 L
s
.67714 .97156 m
.65875 .986 L
s
.67916 .97376 m
.67714 .97156 L
s
.67714 .97156 m
.68317 .99848 L
s
.65875 .986 m
.66058 .98835 L
s
.68317 .99848 m
.65875 .986 L
s
.30349 .41128 m
.32918 .43109 L
s
.323 .43007 m
.32112 .4296 L
s
.32694 .42464 m
.323 .43007 L
s
.32918 .43109 m
.323 .43007 L
s
.34078 1.00345 m
.32899 .98803 L
s
.34704 .98188 m
.34078 1.00345 L
s
.32507 .42415 m
.32694 .42464 L
s
.32694 .42464 m
.32918 .43109 L
s
.72345 .62717 m
.73259 .61135 L
s
.612 .90583 m
.68317 .99848 L
s
.65678 .42669 m
.65579 .42751 L
s
.6606 .41257 m
.65678 .42669 L
s
.67221 .42381 m
.65678 .42669 L
s
.32899 .98803 m
.34704 .98188 L
s
.32918 .43109 m
.32112 .4296 L
s
.32507 .42415 m
.32918 .43109 L
s
.65964 .41329 m
.6606 .41257 L
s
.6606 .41257 m
.67221 .42381 L
s
.32112 .4296 m
.32507 .42415 L
s
.60233 .40487 m
.67221 .42381 L
s
.26734 .78781 m
.25399 .79125 L
s
.2707 .78631 m
.26734 .78781 L
s
.26734 .78781 m
.26587 .80236 L
s
.68317 .99848 m
.66058 .98835 L
s
.67916 .97376 m
.68317 .99848 L
s
.2482 .73464 m
.26587 .80236 L
s
.25399 .79125 m
.25727 .78977 L
s
.26587 .80236 m
.25399 .79125 L
s
.67221 .42381 m
.65579 .42751 L
s
.65964 .41329 m
.67221 .42381 L
s
.23785 .23164 m
.25403 .225 L
s
.59184 .78905 m
.59109 .78969 L
s
.6053 .7765 m
.59184 .78905 L
s
.61072 .79654 m
.59184 .78905 L
s
.60465 .77703 m
.6053 .7765 L
s
.6053 .7765 m
.61072 .79654 L
s
.26587 .80236 m
.25727 .78977 L
s
.2707 .78631 m
.26587 .80236 L
s
.65579 .42751 m
.65964 .41329 L
s
.66058 .98835 m
.67916 .97376 L
s
.54841 .72934 m
.61072 .79654 L
s
.25235 .22808 m
.25059 .22832 L
s
.25099 .22434 m
.25235 .22808 L
s
.25403 .225 m
.25235 .22808 L
s
.24922 .22457 m
.25099 .22434 L
s
.25099 .22434 m
.25403 .225 L
s
.25727 .78977 m
.2707 .78631 L
s
.9292 .78621 m
.93072 .78968 L
s
.94274 .76504 m
.9292 .78621 L
s
.95835 .79068 m
.9292 .78621 L
s
.25403 .225 m
.25059 .22832 L
s
.24922 .22457 m
.25403 .225 L
s
.25059 .22832 m
.24922 .22457 L
s
.58864 .22463 m
.58743 .22468 L
s
.58715 .21211 m
.58864 .22463 L
s
.59952 .21684 m
.58864 .22463 L
s
.53856 .22456 m
.59952 .21684 L
s
.94441 .76828 m
.94274 .76504 L
s
.94274 .76504 m
.95835 .79068 L
s
.58594 .2121 m
.58715 .21211 L
s
.58715 .21211 m
.59952 .21684 L
s
.85075 .724 m
.95835 .79068 L
s
.18182 .55633 m
.18975 .59803 L
s
.61072 .79654 m
.59109 .78969 L
s
.60465 .77703 m
.61072 .79654 L
s
.19166 .59029 m
.18303 .59141 L
s
.19331 .58791 m
.19166 .59029 L
s
.19166 .59029 m
.18975 .59803 L
s
.59952 .21684 m
.58743 .22468 L
s
.58594 .2121 m
.59952 .21684 L
s
.18303 .59141 m
.18465 .58902 L
s
.18975 .59803 m
.18303 .59141 L
s
.59109 .78969 m
.60465 .77703 L
s
.48393 .55036 m
.53709 .59133 L
s
.58743 .22468 m
.58594 .2121 L
s
.52365 .5886 m
.52102 .58858 L
s
.53179 .57766 m
.52365 .5886 L
s
.53709 .59133 m
.52365 .5886 L
s
.95835 .79068 m
.93072 .78968 L
s
.94441 .76828 m
.95835 .79068 L
s
.18975 .59803 m
.18465 .58902 L
s
.19331 .58791 m
.18975 .59803 L
s
.18465 .58902 m
.19331 .58791 L
s
.5292 .57758 m
.53179 .57766 L
s
.53179 .57766 m
.53709 .59133 L
s
.86333 .58537 m
.86311 .5874 L
s
.87157 .56568 m
.86333 .58537 L
s
.88725 .58458 m
.86333 .58537 L
s
.78817 .54434 m
.88725 .58458 L
s
.11451 .37549 m
.1124 .39036 L
s
.87142 .56754 m
.87157 .56568 L
s
.87157 .56568 m
.88725 .58458 L
s
.47333 .94769 m
.45523 .957 L
s
.47447 .94732 m
.47333 .94769 L
s
.47333 .94769 m
.47389 .97041 L
s
.53709 .59133 m
.52102 .58858 L
s
.5292 .57758 m
.53709 .59133 L
s
.93072 .78968 m
.94441 .76828 L
s
.42871 .87963 m
.47389 .97041 L
s
.45523 .957 m
.45621 .95671 L
s
.47389 .97041 m
.45523 .957 L
s
.52102 .58858 m
.5292 .57758 L
s
.11453 .38901 m
.11054 .38826 L
s
.1151 .38649 m
.11453 .38901 L
s
.1124 .39036 m
.11453 .38901 L
s
.41853 .36883 m
.46226 .38276 L
s
.11054 .38826 m
.11111 .38574 L
s
.11054 .38826 m
.1124 .39036 L
s
.79837 .95458 m
.7987 .95766 L
s
.8163 .93647 m
.79837 .95458 L
s
.82595 .96518 m
.79837 .95458 L
s
.11111 .38574 m
.1151 .38649 L
s
.1124 .39036 m
.1151 .38649 L
s
.81684 .93934 m
.8163 .93647 L
s
.8163 .93647 m
.82595 .96518 L
s
.11111 .38574 m
.1124 .39036 L
s
.88725 .58458 m
.86311 .5874 L
s
.87142 .56754 m
.88725 .58458 L
s
.73439 .87475 m
.82595 .96518 L
s
.45388 .38455 m
.45052 .3848 L
s
.45641 .37514 m
.45388 .38455 L
s
.46226 .38276 m
.45388 .38455 L
s
.45306 .37535 m
.45641 .37514 L
s
.45641 .37514 m
.46226 .38276 L
s
.72471 .36213 m
.81499 .3751 L
s
.47389 .97041 m
.45621 .95671 L
s
.47447 .94732 m
.47389 .97041 L
s
.79602 .38112 m
.79488 .38214 L
s
.79879 .3629 m
.79602 .38112 L
s
.81499 .3751 m
.79602 .38112 L
s
.86311 .5874 m
.87142 .56754 L
s
.79767 .36378 m
.79879 .3629 L
s
.79879 .3629 m
.81499 .3751 L
s
.36257 .69948 m
.39807 .76368 L
s
.46226 .38276 m
.45052 .3848 L
s
.45306 .37535 m
.46226 .38276 L
s
.45052 .3848 m
.45306 .37535 L
s
.45621 .95671 m
.47447 .94732 L
s
.39837 .74797 m
.38526 .7554 L
s
.39664 .74612 m
.39837 .74797 L
s
.39837 .74797 m
.39807 .76368 L
s
.35219 .18471 m
.38619 .17075 L
s
.38526 .7554 m
.38345 .75359 L
s
.39807 .76368 m
.38526 .7554 L
s
.82595 .96518 m
.7987 .95766 L
s
.81684 .93934 m
.82595 .96518 L
s
.6702 .69393 m
.75273 .75754 L
s
.73086 .75231 m
.72872 .75377 L
s
.74348 .73579 m
.73086 .75231 L
s
.75273 .75754 m
.73086 .75231 L
s
.81499 .3751 m
.79488 .38214 L
s
.79767 .36378 m
.81499 .3751 L
s
.74145 .73711 m
.74348 .73579 L
s
.74348 .73579 m
.75273 .75754 L
s
.66033 .17729 m
.74153 .16214 L
s
.38233 .17724 m
.37913 .17756 L
s
.37957 .16956 m
.38233 .17724 L
s
.38619 .17075 m
.38233 .17724 L
s
.37636 .16985 m
.37957 .16956 L
s
.37957 .16956 m
.38619 .17075 L
s
.79488 .38214 m
.79767 .36378 L
s
.39807 .76368 m
.38345 .75359 L
s
.39664 .74612 m
.39807 .76368 L
s
.7987 .95766 m
.81684 .93934 L
s
.72732 .17362 m
.72581 .17346 L
s
.72459 .15697 m
.72732 .17362 L
s
.74153 .16214 m
.72732 .17362 L
s
.29547 .51674 m
.321 .55351 L
s
.72305 .15669 m
.72459 .15697 L
s
.72459 .15697 m
.74153 .16214 L
s
.38345 .75359 m
.39664 .74612 L
s
.38619 .17075 m
.37913 .17756 L
s
.37636 .16985 m
.38619 .17075 L
s
.37913 .17756 m
.37636 .16985 L
s
.75273 .75754 m
.72872 .75377 L
s
.74145 .73711 m
.75273 .75754 L
s
.60507 .51048 m
.67829 .54644 L
s
.31436 .55017 m
.31 .54836 L
s
.3217 .54386 m
.31436 .55017 L
s
.321 .55351 m
.31436 .55017 L
s
.31737 .54203 m
.3217 .54386 L
s
.3217 .54386 m
.321 .55351 L
s
.23813 .85238 m
.25499 .94106 L
s
.74153 .16214 m
.72581 .17346 L
s
.72305 .15669 m
.74153 .16214 L
s
.6619 .54635 m
.65819 .54717 L
s
.66888 .53128 m
.6619 .54635 L
s
.67829 .54644 m
.6619 .54635 L
s
.72872 .75377 m
.74145 .73711 L
s
.25847 .92281 m
.24086 .92609 L
s
.26238 .9203 m
.25847 .92281 L
s
.25847 .92281 m
.25499 .94106 L
s
.72581 .17346 m
.72305 .15669 L
s
.66522 .53199 m
.66888 .53128 L
s
.66888 .53128 m
.67829 .54644 L
s
.22739 .33135 m
.24263 .33982 L
s
.321 .55351 m
.31 .54836 L
s
.31737 .54203 m
.321 .55351 L
s
.31 .54836 m
.31737 .54203 L
s
.54922 .84731 m
.61426 .93558 L
s
.24086 .92609 m
.24466 .9236 L
s
.25499 .94106 m
.24086 .92609 L
s
.53901 .32437 m
.6026 .33179 L
s
.59353 .92429 m
.5912 .92461 L
s
.61102 .91104 m
.59353 .92429 L
s
.61426 .93558 m
.59353 .92429 L
s
.60886 .91124 m
.61102 .91104 L
s
.61102 .91104 m
.61426 .93558 L
s
.67829 .54644 m
.65819 .54717 L
s
.66522 .53199 m
.67829 .54644 L
s
.86257 .8422 m
.97655 .93005 L
s
.16926 .66842 m
.17558 .72929 L
s
.24188 .34055 m
.23694 .3412 L
s
.24218 .33503 m
.24188 .34055 L
s
.24263 .33982 m
.24188 .34055 L
s
.65819 .54717 m
.66522 .53199 L
s
.94495 .92145 m
.9447 .92554 L
s
.96236 .89929 m
.94495 .92145 L
s
.97655 .93005 m
.94495 .92145 L
s
.25499 .94106 m
.24466 .9236 L
s
.26238 .9203 m
.25499 .94106 L
s
.23725 .33567 m
.24218 .33503 L
s
.24218 .33503 m
.24263 .33982 L
s
.24466 .9236 m
.26238 .9203 L
s
.23694 .3412 m
.23725 .33567 L
s
.24263 .33982 m
.23694 .3412 L
s
.96232 .90311 m
.96236 .89929 L
s
.96236 .89929 m
.97655 .93005 L
s
.59124 .33674 m
.58706 .33747 L
s
.5925 .32316 m
.59124 .33674 L
s
.6026 .33179 m
.59124 .33674 L
s
.23725 .33567 m
.24263 .33982 L
s
.58832 .32382 m
.5925 .32316 L
s
.5925 .32316 m
.6026 .33179 L
s
.48238 .66264 m
.53754 .72286 L
s
.17968 .71874 m
.16677 .7194 L
s
.18187 .71463 m
.17968 .71874 L
s
.17968 .71874 m
.17558 .72929 L
s
.61426 .93558 m
.5912 .92461 L
s
.60886 .91124 m
.61426 .93558 L
s
.47197 .13553 m
.52563 .11351 L
s
.16677 .7194 m
.1689 .71529 L
s
.17558 .72929 m
.16677 .7194 L
s
.79779 .65682 m
.90259 .71638 L
s
.09939 .48177 m
.09481 .51391 L
s
.6026 .33179 m
.58706 .33747 L
s
.58832 .32382 m
.6026 .33179 L
s
.523 .717 m
.51799 .71632 L
s
.53481 .70515 m
.523 .717 L
s
.53754 .72286 m
.523 .717 L
s
.58706 .33747 m
.58832 .32382 L
s
.5912 .92461 m
.60886 .91124 L
s
.52987 .70439 m
.53481 .70515 L
s
.53481 .70515 m
.53754 .72286 L
s
.1689 .71529 m
.18187 .71463 L
s
.18187 .71463 m
.17558 .72929 L
s
.97655 .93005 m
.9447 .92554 L
s
.96232 .90311 m
.97655 .93005 L
s
.17558 .72929 m
.1689 .71529 L
s
.87683 .71359 m
.87422 .71602 L
s
.88861 .69282 m
.87683 .71359 L
s
.90259 .71638 m
.87683 .71359 L
s
.41455 .47525 m
.45952 .50651 L
s
.51901 .12378 m
.51478 .12399 L
s
.51483 .11194 m
.51901 .12378 L
s
.52563 .11351 m
.51901 .12378 L
s
.51058 .11209 m
.51483 .11194 L
s
.51483 .11194 m
.52563 .11351 L
s
.88612 .69503 m
.88861 .69282 L
s
.88861 .69282 m
.90259 .71638 L
s
.9447 .92554 m
.96232 .90311 L
s
.53754 .72286 m
.51799 .71632 L
s
.52987 .70439 m
.53754 .72286 L
s
.09932 .51061 m
.091 .50915 L
s
.10048 .5057 m
.09932 .51061 L
s
.09481 .51391 m
.09932 .51061 L
s
.73205 .46869 m
.82736 .49905 L
s
.51799 .71632 m
.52987 .70439 L
s
.091 .50915 m
.09214 .50423 L
s
.091 .50915 m
.09481 .51391 L
s
.52563 .11351 m
.51478 .12399 L
s
.51058 .11209 m
.52563 .11351 L
s
.51478 .12399 m
.51058 .11209 L
s
.3565 .81875 m
.39257 .90458 L
s
.09214 .50423 m
.10048 .5057 L
s
.09481 .51391 m
.10048 .5057 L
s
.45097 .50567 m
.44442 .50551 L
s
.45646 .49492 m
.45097 .50567 L
s
.45952 .50651 m
.45097 .50567 L
s
.09214 .50423 m
.09481 .51391 L
s
.90259 .71638 m
.87422 .71602 L
s
.88612 .69503 m
.90259 .71638 L
s
.44992 .4947 m
.45646 .49492 L
s
.45646 .49492 m
.45952 .50651 L
s
.34572 .28508 m
.38016 .28644 L
s
.80715 .50191 m
.80313 .50345 L
s
.81307 .48247 m
.80715 .50191 L
s
.82736 .49905 m
.80715 .50191 L
s
.87422 .71602 m
.88612 .69503 L
s
.67555 .81343 m
.76249 .89879 L
s
.8091 .48384 m
.81307 .48247 L
s
.81307 .48247 m
.82736 .49905 L
s
.44442 .50551 m
.44992 .4947 L
s
.45952 .50651 m
.44442 .50551 L
s
.39555 .88467 m
.37807 .89261 L
s
.39255 .88185 m
.39555 .88467 L
s
.39555 .88467 m
.39257 .90458 L
s
.66533 .27776 m
.75083 .27797 L
s
.44992 .4947 m
.45952 .50651 L
s
.37807 .89261 m
.37493 .88985 L
s
.39257 .90458 m
.37807 .89261 L
s
.28684 .63008 m
.31211 .68653 L
s
.73872 .88957 m
.73444 .89112 L
s
.75532 .87205 m
.73872 .88957 L
s
.76249 .89879 m
.73872 .88957 L
s
.75121 .87342 m
.75532 .87205 L
s
.75532 .87205 m
.76249 .89879 L
s
.37668 .29023 m
.37043 .2915 L
s
.37597 .28085 m
.37668 .29023 L
s
.38016 .28644 m
.37668 .29023 L
s
.82736 .49905 m
.80313 .50345 L
s
.8091 .48384 m
.82736 .49905 L
s
.36971 .28209 m
.37597 .28085 L
s
.37597 .28085 m
.38016 .28644 L
s
.80313 .50345 m
.8091 .48384 L
s
.60803 .62401 m
.6849 .67974 L
s
.73579 .28647 m
.73126 .28743 L
s
.73583 .26848 m
.73579 .28647 L
s
.75083 .27797 m
.73579 .28647 L
s
.39257 .90458 m
.37493 .88985 L
s
.39255 .88185 m
.39257 .90458 L
s
.37043 .2915 m
.36971 .28209 L
s
.38016 .28644 m
.37043 .2915 L
s
.73129 .26931 m
.73583 .26848 L
s
.73583 .26848 m
.75083 .27797 L
s
.5976 .08396 m
.67297 .05303 L
s
.37493 .88985 m
.39255 .88185 L
s
.36971 .28209 m
.38016 .28644 L
s
.30492 .68041 m
.29794 .67721 L
s
.31603 .67304 m
.30492 .68041 L
s
.31211 .68653 m
.30492 .68041 L
s
.21614 .43856 m
.23024 .46467 L
s
.3091 .66979 m
.31603 .67304 L
s
.31603 .67304 m
.31211 .68653 L
s
.76249 .89879 m
.73444 .89112 L
s
.75121 .87342 m
.76249 .89879 L
s
.66736 .6763 m
.6608 .67701 L
s
.67786 .65998 m
.66736 .6763 L
s
.6849 .67974 m
.66736 .6763 L
s
.73444 .89112 m
.75121 .87342 L
s
.75083 .27797 m
.73126 .28743 L
s
.73129 .26931 m
.75083 .27797 L
s
.53949 .43173 m
.60595 .45684 L
s
.73126 .28743 m
.73129 .26931 L
s
.67137 .66056 m
.67786 .65998 L
s
.67786 .65998 m
.6849 .67974 L
s
.29794 .67721 m
.3091 .66979 L
s
.31211 .68653 m
.29794 .67721 L
s
.15575 .789 m
.16016 .87209 L
s
.66295 .06748 m
.65814 .06738 L
s
.65731 .05123 m
.66295 .06748 L
s
.67297 .05303 m
.66295 .06748 L
s
.3091 .66979 m
.31211 .68653 L
s
.65246 .05102 m
.65731 .05123 L
s
.65731 .05123 m
.67297 .05303 L
s
.48071 .78346 m
.53804 .86601 L
s
.23123 .46315 m
.22216 .46355 L
s
.23263 .45522 m
.23123 .46315 L
s
.23024 .46467 m
.23123 .46315 L
s
.6849 .67974 m
.6608 .67701 L
s
.67137 .66056 m
.6849 .67974 L
s
.6608 .67701 m
.67137 .66056 L
s
.22216 .46355 m
.22354 .45561 L
s
.23024 .46467 m
.22216 .46355 L
s
.4699 .23652 m
.5256 .23 L
s
.22354 .45561 m
.23263 .45522 L
s
.23263 .45522 m
.23024 .46467 L
s
.5942 .45885 m
.58665 .45985 L
s
.59831 .4437 m
.5942 .45885 L
s
.60595 .45684 m
.5942 .45885 L
s
.67297 .05303 m
.65814 .06738 L
s
.65246 .05102 m
.67297 .05303 L
s
.65814 .06738 m
.65246 .05102 L
s
.80814 .77787 m
.91928 .85988 L
s
.08311 .59615 m
.07567 .64842 L
s
.1667 .85787 m
.14905 .85821 L
s
.16952 .85231 m
.1667 .85787 L
s
.1667 .85787 m
.16016 .87209 L
s
.22354 .45561 m
.23024 .46467 L
s
.59078 .44461 m
.59831 .4437 L
s
.59831 .4437 m
.60595 .45684 L
s
.14905 .85821 m
.15176 .85263 L
s
.16016 .87209 m
.14905 .85821 L
s
.41027 .58982 m
.45655 .6413 L
s
.52219 .85636 m
.51469 .85514 L
s
.53808 .84348 m
.52219 .85636 L
s
.53804 .86601 m
.52219 .85636 L
s
.58665 .45985 m
.59078 .44461 L
s
.60595 .45684 m
.58665 .45985 L
s
.53071 .84214 m
.53808 .84348 L
s
.53808 .84348 m
.53804 .86601 L
s
.59078 .44461 m
.60595 .45684 L
s
.89137 .85287 m
.8863 .85581 L
s
.90711 .83082 m
.89137 .85287 L
s
.91928 .85988 m
.89137 .85287 L
s
.15176 .85263 m
.16952 .85231 L
s
.16952 .85231 m
.16016 .87209 L
s
.73995 .58345 m
.84083 .6341 L
s
.16016 .87209 m
.15176 .85263 L
s
.51894 .23739 m
.5116 .23894 L
s
.51702 .22374 m
.51894 .23739 L
s
.5256 .23 m
.51894 .23739 L
s
.90222 .83351 m
.90711 .83082 L
s
.90711 .83082 m
.91928 .85988 L
s
.50966 .22522 m
.51702 .22374 L
s
.51702 .22374 m
.5256 .23 L
s
.08283 .64243 m
.06981 .64033 L
s
.08457 .63532 m
.08283 .64243 L
s
.07567 .64842 m
.08283 .64243 L
s
.33875 .3932 m
.37359 .41254 L
s
.06981 .64033 m
.0715 .6332 L
s
.06981 .64033 m
.07567 .64842 L
s
.53804 .86601 m
.51469 .85514 L
s
.53071 .84214 m
.53804 .86601 L
s
.51469 .85514 m
.53071 .84214 L
s
.5116 .23894 m
.50966 .22522 L
s
.5256 .23 m
.5116 .23894 L
s
.44786 .63744 m
.43779 .63668 L
s
.45651 .62506 m
.44786 .63744 L
s
.45655 .6413 m
.44786 .63744 L
s
.50966 .22522 m
.5256 .23 L
s
.0715 .6332 m
.08457 .63532 L
s
.07567 .64842 m
.08457 .63532 L
s
.67071 .38602 m
.76097 .40425 L
s
.44646 .62423 m
.45651 .62506 L
s
.45651 .62506 m
.45655 .6413 L
s
.81918 .63336 m
.8121 .63533 L
s
.82858 .6124 m
.81918 .63336 L
s
.84083 .6341 m
.81918 .63336 L
s
.0715 .6332 m
.07567 .64842 L
s
.91928 .85988 m
.8863 .85581 L
s
.90222 .83351 m
.91928 .85988 L
s
.27755 .75221 m
.30241 .8316 L
s
.8863 .85581 m
.90222 .83351 L
s
.82156 .61418 m
.82858 .6124 L
s
.82858 .6124 m
.84083 .6341 L
s
.43779 .63668 m
.44646 .62423 L
s
.45655 .6413 m
.43779 .63668 L
s
.44646 .62423 m
.45655 .6413 L
s
.61121 .74638 m
.69211 .82515 L
s
.60038 .1855 m
.67965 .17021 L
s
.37112 .41364 m
.36097 .41528 L
s
.37206 .40197 m
.37112 .41364 L
s
.37359 .41254 m
.37112 .41364 L
s
.20402 .55416 m
.21672 .60092 L
s
.8121 .63533 m
.82156 .61418 L
s
.84083 .6341 m
.8121 .63533 L
s
.82156 .61418 m
.84083 .6341 L
s
.36189 .40356 m
.37206 .40197 L
s
.37206 .40197 m
.37359 .41254 L
s
.74512 .40958 m
.73719 .41135 L
s
.74806 .38981 m
.74512 .40958 L
s
.76097 .40425 m
.74512 .40958 L
s
.36097 .41528 m
.36189 .40356 L
s
.37359 .41254 m
.36097 .41528 L
s
.74014 .39143 m
.74806 .38981 L
s
.74806 .38981 m
.76097 .40425 L
s
.29463 .8219 m
.2848 .81749 L
s
.30986 .81345 m
.29463 .8219 L
s
.30241 .8316 m
.29463 .8219 L
s
.54 .54751 m
.6096 .59336 L
s
.36189 .40356 m
.37359 .41254 L
s
.30012 .80898 m
.30986 .81345 L
s
.30986 .81345 m
.30241 .8316 L
s
.67325 .81769 m
.66363 .81838 L
s
.68763 .79997 m
.67325 .81769 L
s
.69211 .82515 m
.67325 .81769 L
s
.73719 .41135 m
.74014 .39143 L
s
.76097 .40425 m
.73719 .41135 L
s
.67812 .8005 m
.68763 .79997 L
s
.68763 .79997 m
.69211 .82515 L
s
.74014 .39143 m
.76097 .40425 L
s
.2848 .81749 m
.30012 .80898 L
s
.30241 .8316 m
.2848 .81749 L
s
.66913 .18168 m
.66114 .18325 L
s
.66592 .16344 m
.66913 .18168 L
s
.67965 .17021 m
.66913 .18168 L
s
.65789 .16489 m
.66592 .16344 L
s
.66592 .16344 m
.67965 .17021 L
s
.30012 .80898 m
.30241 .8316 L
s
.46767 .3455 m
.52556 .35728 L
s
.21984 .59655 m
.20607 .59661 L
s
.22221 .58621 m
.21984 .59655 L
s
.21672 .60092 m
.21984 .59655 L
s
.06554 .71959 m
.05475 .79543 L
s
.66363 .81838 m
.67812 .8005 L
s
.69211 .82515 m
.66363 .81838 L
s
.20607 .59661 m
.2084 .58625 L
s
.21672 .60092 m
.20607 .59661 L
s
.5975 .59202 m
.58621 .59311 L
s
.60464 .575 m
.5975 .59202 L
s
.6096 .59336 m
.5975 .59202 L
s
.67812 .8005 m
.69211 .82515 L
s
.66114 .18325 m
.65789 .16489 L
s
.67965 .17021 m
.66114 .18325 L
s
.2084 .58625 m
.22221 .58621 L
s
.22221 .58621 m
.21672 .60092 L
s
.40566 .71351 m
.45329 .78865 L
s
.65789 .16489 m
.67965 .17021 L
s
.59337 .57597 m
.60464 .575 L
s
.60464 .575 m
.6096 .59336 L
s
.2084 .58625 m
.21672 .60092 L
s
.74849 .70738 m
.85557 .78181 L
s
.58621 .59311 m
.59337 .57597 L
s
.6096 .59336 m
.58621 .59311 L
s
.59337 .57597 m
.6096 .59336 L
s
.33123 .50999 m
.3664 .55052 L
s
.51928 .36166 m
.50813 .3641 L
s
.5194 .34569 m
.51928 .36166 L
s
.52556 .35728 m
.51928 .36166 L
s
.06489 .78582 m
.04673 .78315 L
s
.06721 .77679 m
.06489 .78582 L
s
.05475 .79543 m
.06489 .78582 L
s
.50822 .34805 m
.5194 .34569 L
s
.5194 .34569 m
.52556 .35728 L
s
.67652 .50299 m
.77207 .54249 L
s
.04673 .78315 m
.04894 .77409 L
s
.04673 .78315 m
.05475 .79543 L
s
.50813 .3641 m
.50822 .34805 L
s
.52556 .35728 m
.50813 .3641 L
s
.44449 .781 m
.43056 .77972 L
s
.45656 .76697 m
.44449 .781 L
s
.45329 .78865 m
.44449 .781 L
s
.50822 .34805 m
.52556 .35728 L
s
.04894 .77409 m
.06721 .77679 L
s
.05475 .79543 m
.06721 .77679 L
s
.83226 .77675 m
.82188 .77924 L
s
.84549 .75411 m
.83226 .77675 L
s
.85557 .78181 m
.83226 .77675 L
s
.44266 .76558 m
.45656 .76697 L
s
.45656 .76697 m
.45329 .78865 L
s
.04894 .77409 m
.05475 .79543 L
s
.83522 .75637 m
.84549 .75411 L
s
.84549 .75411 m
.85557 .78181 L
s
.60339 .29528 m
.68697 .29859 L
s
.43056 .77972 m
.44266 .76558 L
s
.45329 .78865 m
.43056 .77972 L
s
.1909 .67917 m
.2019 .75023 L
s
.44266 .76558 m
.45329 .78865 L
s
.36538 .54845 m
.35065 .55022 L
s
.36779 .53427 m
.36538 .54845 L
s
.3664 .55052 m
.36538 .54845 L
s
.54056 .67276 m
.61361 .74302 L
s
.75539 .54416 m
.74366 .54661 L
s
.76141 .5223 m
.75539 .54416 L
s
.77207 .54249 m
.75539 .54416 L
s
.82188 .77924 m
.83522 .75637 L
s
.85557 .78181 m
.82188 .77924 L
s
.35302 .53599 m
.36779 .53427 L
s
.36779 .53427 m
.3664 .55052 L
s
.35065 .55022 m
.35302 .53599 L
s
.3664 .55052 m
.35065 .55022 L
s
.83522 .75637 m
.85557 .78181 L
s
.7497 .52457 m
.76141 .5223 L
s
.76141 .5223 m
.77207 .54249 L
s
.35302 .53599 m
.3664 .55052 L
s
.46525 .46345 m
.52553 .49693 L
s
.74366 .54661 m
.7497 .52457 L
s
.77207 .54249 m
.74366 .54661 L
s
.67621 .30683 m
.66442 .30975 L
s
.67533 .28613 m
.67621 .30683 L
s
.68697 .29859 m
.67621 .30683 L
s
.7497 .52457 m
.77207 .54249 L
s
.66351 .28892 m
.67533 .28613 L
s
.67533 .28613 m
.68697 .29859 L
s
.20748 .74209 m
.18852 .74185 L
s
.21082 .72952 m
.20748 .74209 L
s
.2019 .75023 m
.20748 .74209 L
s
.18852 .74185 m
.19176 .72925 L
s
.2019 .75023 m
.18852 .74185 L
s
.60116 .73757 m
.58573 .73875 L
s
.61155 .71858 m
.60116 .73757 L
s
.61361 .74302 m
.60116 .73757 L
s
.66442 .30975 m
.66351 .28892 L
s
.68697 .29859 m
.66442 .30975 L
s
.19176 .72925 m
.21082 .72952 L
s
.21082 .72952 m
.2019 .75023 L
s
.66351 .28892 m
.68697 .29859 L
s
.59614 .71962 m
.61155 .71858 L
s
.61155 .71858 m
.61361 .74302 L
s
.19176 .72925 m
.2019 .75023 L
s
.32308 .63654 m
.3585 .70212 L
s
.58573 .73875 m
.59614 .71962 L
s
.61361 .74302 m
.58573 .73875 L
s
.68283 .62978 m
.78427 .69445 L
s
.51997 .49782 m
.50434 .50091 L
s
.52201 .47925 m
.51997 .49782 L
s
.52553 .49693 m
.51997 .49782 L
s
.59614 .71962 m
.61361 .74302 L
s
.50634 .48225 m
.52201 .47925 L
s
.52201 .47925 m
.52553 .49693 L
s
.50434 .50091 m
.50634 .48225 L
s
.52553 .49693 m
.50434 .50091 L
s
.60665 .41435 m
.69503 .43984 L
s
.50634 .48225 m
.52553 .49693 L
s
.35926 .69603 m
.33937 .69792 L
s
.3631 .6794 m
.35926 .69603 L
s
.3585 .70212 m
.35926 .69603 L
s
.7667 .69167 m
.75075 .69481 L
s
.77606 .66759 m
.7667 .69167 L
s
.78427 .69445 m
.7667 .69167 L
s
.33937 .69792 m
.34312 .68123 L
s
.3585 .70212 m
.33937 .69792 L
s
.34312 .68123 m
.3631 .6794 L
s
.3631 .6794 m
.3585 .70212 L
s
.46263 .59154 m
.52549 .65083 L
s
.76013 .67052 m
.77606 .66759 L
s
.77606 .66759 m
.78427 .69445 L
s
.34312 .68123 m
.3585 .70212 L
s
.75075 .69481 m
.76013 .67052 L
s
.78427 .69445 m
.75075 .69481 L
s
.68422 .44431 m
.66802 .4484 L
s
.68566 .42086 m
.68422 .44431 L
s
.69503 .43984 m
.68422 .44431 L
s
.76013 .67052 m
.78427 .69445 L
s
.66941 .42479 m
.68566 .42086 L
s
.68566 .42086 m
.69503 .43984 L
s
.66802 .4484 m
.66941 .42479 L
s
.69503 .43984 m
.66802 .4484 L
s
.66941 .42479 m
.69503 .43984 L
s
.52092 .64738 m
.50018 .65108 L
s
.52488 .62615 m
.52092 .64738 L
s
.52549 .65083 m
.52092 .64738 L
s
.6102 .54395 m
.70394 .59601 L
s
.50406 .62975 m
.52488 .62615 L
s
.52488 .62615 m
.52549 .65083 L
s
.50018 .65108 m
.50406 .62975 L
s
.52549 .65083 m
.50018 .65108 L
s
.50406 .62975 m
.52549 .65083 L
s
.69324 .59581 m
.67198 .60104 L
s
.69706 .56947 m
.69324 .59581 L
s
.70394 .59601 m
.69324 .59581 L
s
.67573 .57452 m
.69706 .56947 L
s
.69706 .56947 m
.70394 .59601 L
s
.67198 .60104 m
.67573 .57452 L
s
.70394 .59601 m
.67198 .60104 L
s
.67573 .57452 m
.70394 .59601 L
s
.25 Mabswid
.67244 0 m
.92712 .41495 L
s
.92712 .41495 m
1 .94826 L
s
1 .94826 m
.70642 .5856 L
s
.70642 .5856 m
.67244 0 L
s
.08845 .24554 m
0 .80386 L
s
0 .80386 m
.70642 .5856 L
s
.70642 .5856 m
.67244 0 L
s
.67244 0 m
.08845 .24554 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.40.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.40.1"]
}, Open  ]],

Cell[TextData[{
 "A variable range specification of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["xmin", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["xmax", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["dx", "TI"],
 StyleBox["}", "MR"],
 " adjusts the evaluation grid by specifying step sizes of ",
 StyleBox["dx", "TI"],
 " in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " direction. An analogous specification in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4,
  ColumnWidths->Automatic}],
 " ranges will adjust the evaluation grid in those directions. You can also \
adjust the evaluation grid by setting the ",
 StyleBox["PlotPoints", "MR"],
 " option. "
}], "Text",
 CellTags->{"S5.40.1", "1.8"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ListPlotVectorField3D[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pt",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["pt",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["vect",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4,
       ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot a list of vectors based at the given points",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.40.1"],

Cell["Vector field plots from lists. ", "Caption",
 CellTags->"S5.40.1"],

Cell["This gives an array of random vectors. ", "MathCaption",
 CellTags->{"S5.40.1", "1.9"}],

Cell["\<\
array = Flatten[
        Table[ {{i, j, k},
            {Random[Real, {-1, 1}],
             Random[Real, {-1, 1}],
             Random[Real, {-1, 1}]}},
              {i, 7}, {j, 7}, {k, 7}], 2];\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.40.1"],

Cell["This displays the vectors. ", "MathCaption",
 CellTags->{"S5.40.1", "1.10"}],

Cell[CellGroupData[{

Cell["ListPlotVectorField3D[array]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.40.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08379 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0560106 1.16455 -6.51063e-17 1.16455 [
[ 0 0 0 0 ]
[ 1 1.08379 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08811 .24565 m
0 .80188 L
s
0 .80188 m
.40018 1.08379 L
s
.40018 1.08379 m
.41775 .5816 L
s
.41775 .5816 m
.08811 .24565 L
s
.67266 0 m
.92738 .41489 L
s
.92738 .41489 m
1 .94624 L
s
1 .94624 m
.70655 .5834 L
s
.70655 .5834 m
.67266 0 L
s
.08811 .24565 m
0 .80188 L
s
0 .80188 m
.70655 .5834 L
s
.70655 .5834 m
.67266 0 L
s
.67266 0 m
.08811 .24565 L
s
.41775 .5816 m
.92738 .41489 L
s
.92738 .41489 m
1 .94624 L
s
1 .94624 m
.40018 1.08379 L
s
.40018 1.08379 m
.41775 .5816 L
s
0 0 m
1 0 L
1 1.08379 L
0 1.08379 L
closepath
clip
newpath
.5 Mabswid
.50421 .5632 m
.48274 .56617 L
s
.44466 .58256 m
.38323 .54088 L
s
.47024 .52624 m
.44565 .51894 L
s
.40766 .60288 m
.38539 .61097 L
s
.44167 .69631 m
.4144 .70588 L
s
.44319 .63841 m
.47362 .63184 L
s
.4098 .54646 m
.42117 .58357 L
s
.53213 .50553 m
.54347 .52272 L
s
.56515 .54338 m
.57657 .50598 L
s
.59552 .48433 m
.58126 .48263 L
s
.5038 .61936 m
.50049 .64418 L
s
.62755 .52309 m
.59053 .55916 L
s
.50251 .80081 m
.47957 .78612 L
s
.43474 .48762 m
.39532 .49158 L
s
.56587 .59984 m
.58862 .6745 L
s
.37339 .50875 m
.39418 .51376 L
s
.69145 .50231 m
.67943 .48747 L
s
.50339 .6776 m
.44611 .67946 L
s
.62944 .57986 m
.60836 .55751 L
s
.46919 .58296 m
.50802 .57396 L
s
.50295 .73804 m
.52438 .76971 L
s
.44009 .75637 m
.49226 .76255 L
s
.69781 .61866 m
.65992 .67382 L
s
.66048 .4626 m
.5811 .42121 L
s
.53235 .62179 m
.56089 .60526 L
s
.40543 .66141 m
.43885 .6202 L
s
.75691 .48102 m
.69461 .52386 L
s
.56661 .65843 m
.63917 .69926 L
s
.43845 .81871 m
.52179 .79549 L
s
.37051 .56574 m
.424 .57579 L
s
.66577 .58013 m
.64672 .57125 L
s
.53224 .56256 m
.54258 .64361 L
s
.39762 .44724 m
.35607 .50442 L
s
.69457 .55938 m
.72691 .49338 L
s
.33533 .46934 m
.3455 .45885 L
s
.36753 .6249 m
.43588 .58608 L
s
.4976 .46597 m
.56094 .49983 L
s
.29097 .48619 m
.30167 .46453 L
s
.72706 .44032 m
.74764 .48571 L
s
.46811 .64184 m
.45915 .64659 L
s
.59684 .54166 m
.50693 .49577 L
s
.82398 .45921 m
.90397 .5205 L
s
.66308 .52023 m
.68173 .58217 L
s
.6314 .63879 m
.64155 .57904 L
s
.32784 .58668 m
.36115 .5717 L
s
.52696 .45976 m
.52036 .45842 L
s
.433 .54491 m
.42824 .58438 L
s
.7659 .59801 m
.82245 .5642 L
s
.40312 .72218 m
.33621 .67538 L
s
.46019 .48271 m
.43032 .53653 L
s
.43675 .88348 m
.45568 .88471 L
s
.76132 .5384 m
.801 .51477 L
s
.56738 .71926 m
.52687 .69936 L
s
.29551 .4281 m
.28083 .47606 L
s
.56203 .44379 m
.58804 .40751 L
s
.49647 .58341 m
.57353 .55105 L
s
.33166 .52688 m
.33044 .47964 L
s
.49705 .52356 m
.5447 .53281 L
s
.43119 .60442 m
.52654 .62791 L
s
.59822 .60122 m
.57761 .60256 L
s
.46698 .703 m
.47658 .74362 L
s
.82975 .51688 m
.82473 .44689 L
s
.46147 .42458 m
.43543 .46951 L
s
.53247 .68333 m
.4901 .73718 L
s
.63344 .7 m
.54539 .73994 L
s
.62807 .42104 m
.65799 .36749 L
s
.56819 .78246 m
.62012 .77821 L
s
.79532 .41749 m
.83777 .44807 L
s
.63555 .76364 m
.62408 .72138 L
s
.40073 .78531 m
.33011 .77269 L
s
.39511 .50507 m
.38086 .5582 L
s
.3925 .56521 m
.37076 .65168 L
s
.73099 .49825 m
.64883 .43805 L
s
.56272 .50167 m
.60755 .50578 L
s
.36443 .68638 m
.28075 .67725 L
s
.56345 .56186 m
.57746 .59055 L
s
.70832 .811 m
.65651 .79741 L
s
.35875 .40495 m
.32157 .45676 L
s
.52695 .40134 m
.57036 .36987 L
s
.59964 .66315 m
.63442 .59314 L
s
.70117 .68026 m
.61803 .71528 L
s
.69581 .39771 m
.65195 .42922 L
s
.50204 .86605 m
.54185 .86908 L
s
.83574 .57684 m
.86192 .5553 L
s
.38098 .39491 m
.36154 .40421 L
s
.49019 .35684 m
.53894 .3706 L
s
.46582 .76656 m
.50617 .7396 L
s
.59412 .3775 m
.62486 .31835 L
s
.4646 .83269 m
.45038 .92692 L
s
.63009 .47922 m
.69794 .5084 L
s
.43498 .9508 m
.42126 .91824 L
s
.2538 .3849 m
.28562 .38582 L
s
.21006 .3396 m
.1674 .35735 L
s
.4293 .66629 m
.43621 .57623 L
s
.80066 .47571 m
.74306 .48914 L
s
.42362 .38121 m
.46995 .40288 L
s
.31802 .36063 m
.31832 .42063 L
s
.73508 .55849 m
.72747 .59166 L
s
.77066 .66 m
.70857 .60586 L
s
.49525 .71046 m
.50872 .68191 L
s
.32387 .64887 m
.32291 .58564 L
s
.39823 .85096 m
.41114 .80617 L
s
.5955 .43621 m
.56305 .42265 L
s
.7653 .37378 m
.84296 .41045 L
s
.56902 .84818 m
.48946 .91109 L
s
.70468 .74432 m
.64619 .73326 L
s
.53272 .81393 m
.51658 .81919 L
s
.63218 .53974 m
.59829 .51096 L
s
.69921 .45618 m
.66309 .45745 L
s
.3612 .75032 m
.39562 .82232 L
s
.28131 .60951 m
.27573 .66185 L
s
.38979 .62779 m
.47918 .63811 L
s
.35541 .46333 m
.36147 .48628 L
s
.66857 .64244 m
.67025 .68932 L
s
.53259 .74733 m
.53033 .78274 L
s
.7338 .32793 m
.71456 .33093 L
s
.66305 .35304 m
.62122 .4514 L
s
.39564 .91926 m
.45244 .90076 L
s
.50155 .93391 m
.57702 .96578 L
s
.42155 .43987 m
.37603 .53672 L
s
.80621 .53629 m
.85112 .60115 L
s
.49588 .64566 m
.52911 .69711 L
s
.42735 .73065 m
.47722 .76483 L
s
.77015 .43253 m
.69556 .41295 L
s
.28624 .54661 m
.30167 .53473 L
s
.70274 .51704 m
.77548 .53109 L
s
.73933 .62119 m
.70779 .58877 L
s
.84197 .63921 m
.86982 .69095 L
s
.45886 .54318 m
.50183 .44092 L
s
.63776 .82983 m
.58662 .78126 L
s
.2483 .44352 m
.26482 .34875 L
s
.52698 .52057 m
.59272 .55552 L
s
.70073 .27978 m
.66765 .26723 L
s
.85522 .7718 m
.90176 .73009 L
s
.60113 .72758 m
.58925 .67507 L
s
.55918 .39106 m
.57689 .45196 L
s
.45748 .60614 m
.51162 .63393 L
s
.46333 .90153 m
.5101 .96292 L
s
.77562 .7245 m
.84198 .79034 L
s
.45004 .36961 m
.51816 .33959 L
s
.34226 .28797 m
.44452 .25188 L
s
.56989 .91656 m
.5088 .98112 L
s
.38393 .33573 m
.40172 .28373 L
s
.56421 .6245 m
.62026 .57561 L
s
.56499 .68973 m
.54292 .78272 L
s
.55851 .33184 m
.54049 .26881 L
s
.35784 .81685 m
.41379 .90904 L
s
.35193 .52409 m
.3819 .46944 L
s
.64005 .89876 m
.61611 .95277 L
s
.24258 .50456 m
.32385 .53967 L
s
.31973 .71361 m
.38985 .74791 L
s
.31376 .41954 m
.36259 .45192 L
s
.52699 .58391 m
.54549 .64879 L
s
.48868 .47721 m
.52908 .46585 L
s
.48945 .41579 m
.50213 .37065 L
s
.81198 .59937 m
.72984 .54838 L
s
.67149 .70731 m
.71389 .64703 L
s
.66586 .41203 m
.70876 .3187 L
s
.27528 .31413 m
.31597 .38354 L
s
.73812 .3872 m
.70129 .41979 L
s
.27618 .67505 m
.29353 .67453 L
s
.84846 .70414 m
.80595 .71442 L
s
.45161 .31015 m
.42735 .30453 L
s
.20352 .39874 m
.28369 .4233 L
s
.63436 .60276 m
.55247 .57782 L
s
.62867 .30616 m
.71782 .3305 L
s
.42531 .79767 m
.43988 .72361 L
s
.41939 .50096 m
.42487 .47462 L
s
.38697 .69296 m
.37035 .7138 L
s
.60268 .79468 m
.66987 .77663 L
s
.59693 .49735 m
.61981 .52083 L
s
.74376 .68649 m
.75347 .76444 L
s
.78078 .79167 m
.85928 .87575 L
s
.7752 .49372 m
.80718 .5123 L
s
.18959 .52468 m
.21825 .52601 L
s
.41107 .2611 m
.3439 .26773 L
s
.35434 .88615 m
.31658 .91635 L
s
.70643 .58044 m
.66594 .60041 L
s
.34831 .58737 m
.32706 .56322 L
s
.71212 .88047 m
.73225 .94569 L
s
.53286 .88332 m
.60519 .94162 L
s
.40859 .32103 m
.39913 .30597 L
s
.52112 .28389 m
.54845 .29338 L
s
.31543 .78104 m
.31134 .72471 L
s
.30932 .4809 m
.29607 .52621 L
s
.63664 .66843 m
.68925 .65157 L
s
.66878 .4735 m
.61665 .45599 L
s
.49461 .77797 m
.55584 .81086 L
s
.41713 .56463 m
.37191 .66724 L
s
.56061 .51721 m
.57515 .49611 L
s
.67453 .7749 m
.71902 .80554 L
s
.27001 .37354 m
.22826 .39251 L
s
.818 .6651 m
.74499 .65409 L
s
.38095 .83174 m
.37361 .88582 L
s
.45603 .67175 m
.55443 .74407 L
s
.23661 .56817 m
.20532 .58252 L
s
.60429 .8646 m
.59682 .895 L
s
.74262 .44898 m
.79249 .50336 L
s
.63082 .36565 m
.67303 .41591 L
s
.42318 .86751 m
.47534 .92527 L
s
.59842 .56107 m
.58989 .58583 L
s
.1967 .46038 m
.22113 .42041 L
s
.48181 .23348 m
.54407 .17597 L
s
.33835 .34765 m
.40007 .43225 L
s
.78616 .86168 m
.85915 .82312 L
s
.59254 .2569 m
.55874 .29413 L
s
.38402 .76088 m
.40488 .68559 L
s
.78047 .5575 m
.82738 .60918 L
s
.37791 .4566 m
.39704 .34317 L
s
.4467 .49634 m
.41846 .50307 L
s
.52703 .71886 m
.57438 .74067 L
s
.56581 .75773 m
.60535 .79434 L
s
.55988 .4528 m
.58949 .42638 L
s
.33427 .40992 m
.32338 .35525 L
s
.49393 .84836 m
.52269 .82731 L
s
.23039 .6345 m
.18529 .60608 L
s
.74838 .75457 m
.79958 .7342 L
s
.34453 .65334 m
.32938 .59585 L
s
.45296 .81157 m
.46873 .79476 L
s
.52701 .64995 m
.53464 .74438 L
s
.45453 .74016 m
.43411 .68474 L
s
.52101 .3436 m
.46913 .29948 L
s
.31094 .85134 m
.31494 .89145 L
s
.71027 .64654 m
.6537 .58759 L
s
.3047 .54489 m
.34638 .44456 L
s
.59998 .62754 m
.61173 .62259 L
s
.41478 .63103 m
.36587 .69244 L
s
.78597 .62404 m
.73178 .62206 L
s
.70445 .33954 m
.72019 .36177 L
s
.67771 .84537 m
.66637 .93234 L
s
.48787 .54125 m
.45058 .62609 L
s
.64148 .80842 m
.67309 .8128 L
s
.27084 .74339 m
.2062 .71384 L
s
.3747 .52095 m
.38938 .44353 L
s
.34059 .72217 m
.3582 .77549 L
s
.67183 .53759 m
.58491 .48906 L
s
.26453 .4355 m
.15436 .43013 L
s
.86227 .84236 m
.83337 .74008 L
s
.66595 .22916 m
.76774 .2761 L
s
.56667 .82867 m
.55978 .92444 L
s
.4484 .43161 m
.36403 .44406 L
s
.41233 .70036 m
.428 .65966 L
s
.63901 .73692 m
.68277 .65849 L
s
.79171 .69352 m
.81214 .69578 L
s
.82428 .73367 m
.76349 .82243 L
s
.63307 .42771 m
.665 .31594 L
s
.29483 .6814 m
.29355 .68169 L
s
.48704 .60808 m
.42405 .60239 L
s
.71846 .78758 m
.74629 .79765 L
s
.59397 .31687 m
.64983 .3112 L
s
.18217 .59181 m
.27263 .57912 L
s
.62934 .17586 m
.68595 .14675 L
s
.75319 .8256 m
.68616 .80041 L
s
.44491 .56397 m
.51267 .55223 L
s
.55453 .20507 m
.62018 .25636 L
s
.74732 .51345 m
.74184 .46783 L
s
.67502 .6045 m
.74098 .56191 L
s
.29987 .61166 m
.39101 .60835 L
s
.52089 .40592 m
.42761 .33683 L
s
.71428 .71553 m
.75752 .77869 L
s
.70834 .4019 m
.77201 .37478 L
s
.26525 .81471 m
.32227 .91446 L
s
.48083 .29366 m
.47053 .32915 L
s
.2588 .50017 m
.25445 .49794 L
s
.33647 .79406 m
.28357 .83499 L
s
.66901 .28938 m
.60006 .313 L
s
.22389 .70375 m
.2441 .62463 L
s
.59546 .37949 m
.57938 .3469 L
s
.55516 .26549 m
.5269 .24074 L
s
.75223 .58078 m
.69859 .52965 L
s
.63542 .49249 m
.63587 .53938 L
s
.71239 .46705 m
.68261 .38977 L
s
.83084 .80525 m
.87184 .73418 L
s
.406 .38361 m
.45554 .39588 L
s
.6016 .69694 m
.62178 .69129 L
s
.37135 .58815 m
.35757 .58655 L
s
.67835 .67439 m
.7297 .66175 L
s
.21711 .77611 m
.2406 .72207 L
s
.56137 .58448 m
.60994 .6078 L
s
.33 .47495 m
.3212 .49205 L
s
.67221 .35229 m
.6849 .35476 L
s
.56216 .65479 m
.50764 .65218 L
s
.52704 .79083 m
.55612 .80892 L
s
.52077 .47101 m
.51452 .47712 L
s
.71664 .53516 m
.67082 .60739 L
s
.40977 .7728 m
.39975 .86888 L
s
.48616 .6779 m
.42165 .62259 L
s
.47982 .35653 m
.47873 .24591 L
s
.25282 .56773 m
.25421 .52709 L
s
.63787 .56018 m
.61639 .49559 L
s
.55581 .32865 m
.4492 .27519 L
s
.68183 .74748 m
.67587 .735 L
s
.63165 .23651 m
.59102 .29673 L
s
.59703 .44494 m
.58568 .39088 L
s
.40329 .449 m
.31991 .44777 L
s
.32555 .54294 m
.35736 .59036 L
s
.7977 .76613 m
.68713 .70942 L
s
.6033 .76947 m
.55021 .80048 L
s
.17441 .66197 m
.17034 .58274 L
s
.36785 .65839 m
.37922 .71039 L
s
.60037 .58512 m
.56807 .59209 L
s
.75736 .65117 m
.73275 .67366 L
s
.44305 .63469 m
.51082 .60677 L
s
.52065 .53906 m
.5792 .44001 L
s
.28956 .75432 m
.28797 .80253 L
s
.63408 .29994 m
.63866 .41628 L
s
.48524 .75091 m
.49703 .80675 L
s
.47876 .42228 m
.42393 .48746 L
s
.24656 .63839 m
.33552 .7137 L
s
.67555 .41809 m
.67689 .45208 L
s
.64043 .63099 m
.6625 .56461 L
s
.40046 .51741 m
.33732 .49761 L
s
.64312 .70512 m
.6269 .82416 L
s
.1663 .73537 m
.25427 .80687 L
s
.67905 .48698 m
.7078 .57404 L
s
.59866 .51341 m
.5169 .56786 L
s
.36419 .73187 m
.43111 .81354 L
s
.56299 .72836 m
.59863 .72421 L
s
.5565 .39474 m
.48645 .37419 L
s
.76272 .72483 m
.76371 .68379 L
s
.32089 .61408 m
.37479 .64777 L
s
.72573 .68116 m
.79161 .69701 L
s
.52052 .61028 m
.62945 .66654 L
s
.72108 .60646 m
.69664 .49857 L
s
.47765 .4911 m
.36024 .47853 L
s
.24001 .71235 m
.12729 .70439 L
s
.44109 .70874 m
.39038 .62571 L
s
.52038 .6849 m
.52764 .60731 L
s
.63662 .36637 m
.72005 .37976 L
s
.55722 .46397 m
.4658 .41447 L
s
.63928 .436 m
.70144 .43019 L
s
.39749 .58904 m
.46215 .60183 L
s
.60216 .6603 m
.56586 .58742 L
s
.316 .68861 m
.35611 .57531 L
s
.47648 .56321 m
.47808 .62372 L
s
.68272 .55917 m
.76858 .57218 L
s
.39438 .66413 m
.41578 .69681 L
s
.47526 .63887 m
.42102 .59983 L
s
.55797 .53657 m
.56571 .60931 L
s
.64207 .50907 m
.59773 .64107 L
s
.68656 .63491 m
.69428 .60125 L
s
.55876 .61279 m
.52049 .66168 L
s
.64501 .58585 m
.6061 .61485 L
s
.25 Mabswid
.67266 0 m
.92738 .41489 L
s
.92738 .41489 m
1 .94624 L
s
1 .94624 m
.70655 .5834 L
s
.70655 .5834 m
.67266 0 L
s
.08811 .24565 m
0 .80188 L
s
0 .80188 m
.70655 .5834 L
s
.70655 .5834 m
.67266 0 L
s
.67266 0 m
.08811 .24565 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.40.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.40.1"]
}, Open  ]],

Cell["\<\
It is often hard to arrange the number of points to have enough samples \
without making the image overly complex. One way to overcome this is to \
construct an animation that rotates the whole image. \
\>", "Text",
 CellTags->{"S5.40.1", "1.11"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.40.1"->{
    Cell[1776, 53, 136, 6, 36, "Subsection",
      CellTags->{"S5.40.1", "1.1"}],
    Cell[1915, 61, 236, 5, 40, "Text",
      CellTags->{"S5.40.1", "1.2"}],
    Cell[2154, 68, 6542, 206, 142, "DefinitionBox",
      CellTags->"S5.40.1"],
    Cell[8699, 276, 85, 1, 15, "Caption",
      CellTags->"S5.40.1"],
    Cell[8787, 279, 78, 1, 40, "MathCaption",
      CellTags->{"S5.40.1", "1.3"}],
    Cell[8868, 282, 86, 2, 28, "Input",
      CellTags->"S5.40.1"],
    Cell[8957, 286, 637, 25, 40, "MathCaption",
      CellTags->{"S5.40.1", "1.4"}],
    Cell[9619, 315, 142, 5, 45, "Input",
      CellTags->"S5.40.1"],
    Cell[9764, 322, 47671, 1575, 186, 12901, 1142, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.40.1"],
    Cell[57438, 1899, 182, 6, 25, "Output",
      CellTags->"S5.40.1"],
    Cell[57635, 1908, 1639, 63, 62, "Text",
      CellTags->{"S5.40.1", "1.5"}],
    Cell[59277, 1973, 326, 12, 70, "MathCaption",
      CellTags->{"S5.40.1", "1.6"}],
    Cell[59628, 1989, 136, 5, 70, "Input",
      CellTags->"S5.40.1"],
    Cell[59767, 1996, 12957, 1145, 70, 12886, 1142, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.40.1"],
    Cell[72727, 3143, 182, 6, 70, "Output",
      CellTags->"S5.40.1"],
    Cell[72924, 3152, 6129, 179, 70, "DefinitionBox3Col",
      CellTags->"S5.40.1"],
    Cell[79056, 3333, 75, 1, 70, "Caption",
      CellTags->"S5.40.1"],
    Cell[79134, 3336, 315, 9, 70, "MathCaption",
      CellTags->{"S5.40.1", "1.7"}],
    Cell[79474, 3349, 179, 6, 70, "Input",
      CellTags->"S5.40.1"],
    Cell[79656, 3357, 38884, 3467, 70, 38813, 3464, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.40.1"],
    Cell[118543, 6826, 182, 6, 70, "Output",
      CellTags->"S5.40.1"],
    Cell[118740, 6835, 1165, 42, 70, "Text",
      CellTags->{"S5.40.1", "1.8"}],
    Cell[119908, 6879, 2376, 73, 70, "DefinitionBox",
      CellTags->"S5.40.1"],
    Cell[122287, 6954, 72, 1, 70, "Caption",
      CellTags->"S5.40.1"],
    Cell[122362, 6957, 93, 1, 70, "MathCaption",
      CellTags->{"S5.40.1", "1.9"}],
    Cell[122458, 6960, 267, 9, 70, "Input",
      CellTags->"S5.40.1"],
    Cell[122728, 6971, 82, 1, 70, "MathCaption",
      CellTags->{"S5.40.1", "1.10"}],
    Cell[122835, 6976, 91, 2, 70, "Input",
      CellTags->"S5.40.1"],
    Cell[122929, 6980, 12948, 1145, 70, 12877, 1142, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.40.1"],
    Cell[135880, 8127, 182, 6, 70, "Output",
      CellTags->"S5.40.1"],
    Cell[136077, 8136, 257, 5, 70, "Text",
      CellTags->{"S5.40.1", "1.11"}]},
  "1.1"->{
    Cell[1776, 53, 136, 6, 36, "Subsection",
      CellTags->{"S5.40.1", "1.1"}]},
  "1.2"->{
    Cell[1915, 61, 236, 5, 40, "Text",
      CellTags->{"S5.40.1", "1.2"}]},
  "1.3"->{
    Cell[8787, 279, 78, 1, 40, "MathCaption",
      CellTags->{"S5.40.1", "1.3"}]},
  "1.4"->{
    Cell[8957, 286, 637, 25, 40, "MathCaption",
      CellTags->{"S5.40.1", "1.4"}]},
  "1.5"->{
    Cell[57635, 1908, 1639, 63, 62, "Text",
      CellTags->{"S5.40.1", "1.5"}]},
  "1.6"->{
    Cell[59277, 1973, 326, 12, 70, "MathCaption",
      CellTags->{"S5.40.1", "1.6"}]},
  "1.7"->{
    Cell[79134, 3336, 315, 9, 70, "MathCaption",
      CellTags->{"S5.40.1", "1.7"}]},
  "1.8"->{
    Cell[118740, 6835, 1165, 42, 70, "Text",
      CellTags->{"S5.40.1", "1.8"}]},
  "1.9"->{
    Cell[122362, 6957, 93, 1, 70, "MathCaption",
      CellTags->{"S5.40.1", "1.9"}]},
  "1.10"->{
    Cell[122728, 6971, 82, 1, 70, "MathCaption",
      CellTags->{"S5.40.1", "1.10"}]},
  "1.11"->{
    Cell[136077, 8136, 257, 5, 70, "Text",
      CellTags->{"S5.40.1", "1.11"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.40.1", 136973, 8160},
  {"1.1", 139674, 8230},
  {"1.2", 139768, 8233},
  {"1.3", 139856, 8236},
  {"1.4", 139951, 8239},
  {"1.5", 140048, 8242},
  {"1.6", 140141, 8245},
  {"1.7", 140240, 8248},
  {"1.8", 140338, 8251},
  {"1.9", 140432, 8254},
  {"1.10", 140531, 8257},
  {"1.11", 140631, 8260}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 136, 6, 36, "Subsection",
  CellTags->{"S5.40.1", "1.1"}],
Cell[1915, 61, 236, 5, 40, "Text",
  CellTags->{"S5.40.1", "1.2"}],
Cell[2154, 68, 6542, 206, 142, "DefinitionBox",
  CellTags->"S5.40.1"],
Cell[8699, 276, 85, 1, 15, "Caption",
  CellTags->"S5.40.1"],
Cell[8787, 279, 78, 1, 40, "MathCaption",
  CellTags->{"S5.40.1", "1.3"}],
Cell[8868, 282, 86, 2, 28, "Input",
  CellTags->"S5.40.1"],
Cell[8957, 286, 637, 25, 40, "MathCaption",
  CellTags->{"S5.40.1", "1.4"}],

Cell[CellGroupData[{
Cell[9619, 315, 142, 5, 45, "Input",
  CellTags->"S5.40.1"],
Cell[9764, 322, 47671, 1575, 186, 12901, 1142, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S5.40.1"],
Cell[57438, 1899, 182, 6, 25, "Output",
  CellTags->"S5.40.1"]
}, Open  ]],
Cell[57635, 1908, 1639, 63, 62, "Text",
  CellTags->{"S5.40.1", "1.5"}],
Cell[59277, 1973, 326, 12, 70, "MathCaption",
  CellTags->{"S5.40.1", "1.6"}],

Cell[CellGroupData[{
Cell[59628, 1989, 136, 5, 70, "Input",
  CellTags->"S5.40.1"],
Cell[59767, 1996, 12957, 1145, 70, 12886, 1142, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.40.1"],
Cell[72727, 3143, 182, 6, 70, "Output",
  CellTags->"S5.40.1"]
}, Open  ]],
Cell[72924, 3152, 6129, 179, 70, "DefinitionBox3Col",
  CellTags->"S5.40.1"],
Cell[79056, 3333, 75, 1, 70, "Caption",
  CellTags->"S5.40.1"],
Cell[79134, 3336, 315, 9, 70, "MathCaption",
  CellTags->{"S5.40.1", "1.7"}],

Cell[CellGroupData[{
Cell[79474, 3349, 179, 6, 70, "Input",
  CellTags->"S5.40.1"],
Cell[79656, 3357, 38884, 3467, 70, 38813, 3464, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.40.1"],
Cell[118543, 6826, 182, 6, 70, "Output",
  CellTags->"S5.40.1"]
}, Open  ]],
Cell[118740, 6835, 1165, 42, 70, "Text",
  CellTags->{"S5.40.1", "1.8"}],
Cell[119908, 6879, 2376, 73, 70, "DefinitionBox",
  CellTags->"S5.40.1"],
Cell[122287, 6954, 72, 1, 70, "Caption",
  CellTags->"S5.40.1"],
Cell[122362, 6957, 93, 1, 70, "MathCaption",
  CellTags->{"S5.40.1", "1.9"}],
Cell[122458, 6960, 267, 9, 70, "Input",
  CellTags->"S5.40.1"],
Cell[122728, 6971, 82, 1, 70, "MathCaption",
  CellTags->{"S5.40.1", "1.10"}],

Cell[CellGroupData[{
Cell[122835, 6976, 91, 2, 70, "Input",
  CellTags->"S5.40.1"],
Cell[122929, 6980, 12948, 1145, 70, 12877, 1142, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.40.1"],
Cell[135880, 8127, 182, 6, 70, "Output",
  CellTags->"S5.40.1"]
}, Open  ]],
Cell[136077, 8136, 257, 5, 70, "Text",
  CellTags->{"S5.40.1", "1.11"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

