(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    188185,       7430]*)
(*NotebookOutlinePosition[    194876,       7624]*)
(*  CellTagsIndexPosition[    194420,       7603]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "Polyhedra",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.41.1", "1.1"}],

Cell["\<\
A Platonic solid is a convex polyhedron whose faces and vertices are all of \
the same type. There are five such solids. There are also a few nonconvex \
polyhedra known that have faces and vertices all of the same type. This \
package contains the graphics primitives necessary for rendering these \
solids. \
\>", "Text",
 CellTags->{"S5.41.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Show[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "display the named polyhedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Show[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["scale", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["center the polygon at the point ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with the size given by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["scale", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.41.1"],

Cell["Displaying the regular polyhedra. ", "Caption",
 CellTags->"S5.41.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Tetrahedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Cube",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Octahedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Dodecahedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Icosahedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Hexahedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GreatDodecahedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "SmallStellatedDodecahedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GreatStellatedDodecahedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GreatIcosahedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.41.1"],

Cell["Polyhedra.", "Caption",
 CellTags->"S5.41.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.41.1", "1.3"}],

Cell["<<Graphics`Polyhedra`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.41.1"],

Cell["This displays a dodecahedron centered at the origin. ", "MathCaption",
 CellTags->{"S5.41.1", "1.4"}],

Cell[CellGroupData[{

Cell["Show[ Polyhedron[ Dodecahedron ]]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.41.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00162 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0206914 1.08755 3.61581e-17 1.08755 [
[ 0 0 0 0 ]
[ 1 1.00162 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
.40217 .57872 m
.07192 .25073 L
s
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
.40217 .57872 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
0 0 m
1 0 L
1 1.00162 L
0 1.00162 L
closepath
clip
newpath
.5 Mabswid
.67 .732 .896 r
.33115 .32429 m .44491 .44907 L .65615 .42467 L p F P
0 g
s
.889 .75 .702 r
.44491 .44907 m .33115 .32429 L p .24235 .68284 L F P
0 g
s
.889 .75 .702 r
.24235 .68284 m .39521 .65616 L .44491 .44907 L p F P
0 g
s
.675 .526 .675 r
.44491 .44907 m .39521 .65616 L .57791 .76621 L p F P
0 g
s
.675 .526 .675 r
.65615 .42467 m .44491 .44907 L p .57791 .76621 L F P
0 g
s
.762 .372 .314 r
.39521 .65616 m .24235 .68284 L p .56015 .87859 L F P
0 g
s
.762 .372 .314 r
.56015 .87859 m .57791 .76621 L .39521 .65616 L p F P
0 g
s
.67 .732 .896 r
.48589 .20782 m .33115 .32429 L p .65615 .42467 L F P
0 g
s
.67 .732 .896 r
.65615 .42467 m .69731 .27878 L .48589 .20782 L p F P
0 g
s
.675 .526 .675 r
.57791 .76621 m .74263 .62049 L .65615 .42467 L p F P
0 g
s
.273 .313 .722 r
.65615 .42467 m .74263 .62049 L .85199 .62068 L p F P
0 g
s
.273 .313 .722 r
.69731 .27878 m .65615 .42467 L p .85199 .62068 L F P
0 g
s
.244 0 .208 r
.57791 .76621 m .56015 .87859 L .73868 .79032 L p F P
0 g
s
.244 0 .208 r
.74263 .62049 m .57791 .76621 L p .73868 .79032 L F P
0 g
s
.244 0 .208 r
.73868 .79032 m .85199 .62068 L .74263 .62049 L p F P
0 g
s
.889 .75 .702 r
.33115 .32429 m .19481 .46702 L .24235 .68284 L p F P
0 g
s
0 0 0 r
.33115 .32429 m .48589 .20782 L p .25792 .45112 L F P
0 g
s
0 0 0 r
.25792 .45112 m .19481 .46702 L .33115 .32429 L p F P
0 g
s
.762 .372 .314 r
.24235 .68284 m .33664 .82736 L .56015 .87859 L p F P
0 g
s
0 .109 .635 r
.33664 .82736 m .24235 .68284 L .19481 .46702 L p F P
0 g
s
.273 .313 .722 r
.85199 .62068 m .82611 .39367 L .69731 .27878 L p F P
0 g
s
.709 .208 .046 r
.69731 .27878 m .82611 .39367 L .68527 .40123 L p F P
0 g
s
.709 .208 .046 r
.48589 .20782 m .69731 .27878 L p .68527 .40123 L F P
0 g
s
.633 .775 .949 r
.73868 .79032 m .56015 .87859 L .33664 .82736 L p F P
0 g
s
0 .109 .635 r
.19481 .46702 m .25792 .45112 L p .33664 .82736 L F P
0 g
s
.939 .801 .68 r
.82611 .39367 m .85199 .62068 L .73868 .79032 L p F P
0 g
s
.709 .208 .046 r
.68527 .40123 m .45664 .27423 L .48589 .20782 L p F P
0 g
s
0 0 0 r
.48589 .20782 m .45664 .27423 L .25792 .45112 L p F P
0 g
s
0 .109 .635 r
.25792 .45112 m .35521 .69402 L .33664 .82736 L p F P
0 g
s
.633 .775 .949 r
.33664 .82736 m .35521 .69402 L p .73868 .79032 L F P
0 g
s
.939 .801 .68 r
.68527 .40123 m .82611 .39367 L p .73868 .79032 L F P
0 g
s
.939 .801 .68 r
.73868 .79032 m .62474 .66693 L .68527 .40123 L p F P
0 g
s
.633 .775 .949 r
.35521 .69402 m .62474 .66693 L .73868 .79032 L p F P
0 g
s
.666 .512 .666 r
.62474 .66693 m .35521 .69402 L .25792 .45112 L p F P
0 g
s
.666 .512 .666 r
.68527 .40123 m .62474 .66693 L p .25792 .45112 L F P
0 g
s
.666 .512 .666 r
.25792 .45112 m .45664 .27423 L .68527 .40123 L p F P
0 g
s
.25 Mabswid
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003o]?ooool0
1?omoOgoe]KFog]kNon=SHedooooo`00/_ooool01ooalO7o`L71oiRHV?nYZJWoUiNGodY:B_oFe]H0
Loooool00;3ooooo00[of][Jojb/[?nFUYKo_Kfmong]kOoooooo`l?3of=SHonIVIWonOWiL_ooool0
0:gooooo00KomOGeolK6a_nKVi_oY:BTom?Cdookno/3ooooo`04om7AdOmXJ6So^[ZjokRh^7;ooooo
002[ooooo`05on3Ph?na/K7oUIFEokRh^?oWinL01_ooool01OoOgmooGemOooWinOnIVIWohn?S077o
oooo002Xooooo`06ooOgmoo:b/[oWYjNoj6QXOo=cLgonOWi2?ooool01_o_knooF5QHoooooooFe]Ko
X:2PoogmoG3ooooo002Vooooo`05onGUiOnf][KoUIFEok>c/ooShn<03?ooool01OmADE7ooooooooo
oon/[:coa/K6073ooooo002Sooooo`06oo_knoo?clooXj>SoibLW?o8b<SomOGe3_ooool01_mFEUKo
lo?coooooooalO7oUYJFono_kfoooooo002Qooooo`05onWYjOnj^[[oUYJFok2`/?oNg]h04Oooool0
1_mMGEgohn?Soooooooooooob<S8oj^[Zfoooooo002Nooooo`06oogmoOoDe=CoZ:RXoiVIVOo3`l?o
lo?c4oooool01omSHf?oe=CDoooooooooooooOgmoj6QXOoDe=@0K_ooool009cooooo00Kokno_okno
_onHV9SoZj^[omSHf?omoOdEooooo`03ofa/K?o6a/Kooooo00;ooooo00?oiNGUoiVIVOogmoL0KOoo
ool009[ooooo00Gof=SHoj^[ZonHV9So_knoono_k`0Hooooo`03ogAdM?nm_Kgooooo00?ooooo00?o
^[ZjokRh^?ooool0K?ooool009Oooooo00Kolo?colC4a?nIVIWoYZJVom?CdoomoOdJooooo`03ogem
OOn`/;3ooooo00?ooooo00?onOWioiVIVOoShn<0K?ooool009Gooooo00Gog]kNok2`/?nFUYKo^[Zj
onWYj@0Mooooo`03ohN7QonUYJGooooo00Cooooo00?oe]KFoj2PX?omoOd0Joooool009;ooooo00Ko
moOgolS8b?nLW9coXj>Solo?cookno/Oooooo`03oi:BT_nIVIWooooo00Gooooo00?o[:b/olK6a_oo
ool0J_ooool0093ooooo00Gohn?SokFe]OnEUIGo]KFeonGUi@0Rooooo`03oibLW?n?Shoooooo00Go
oooo00?olO7aoiJFU_o_knl0J_ooool008gooooo00KonOWiolg=cOnQXJ7oWYjNol[:b_ogmoLToooo
o`03ojNWYon4Q8Cooooo00Kooooo00?ob/[:oj^[Zoooool0JOooool008_ooooo00GojNWYokRh^?nE
UIGo/K6aon3Ph00Wooooo`03ok>c/omjNW[ooooo00Oooooo00?oXJ6QomCDe?ooool0J?ooool008So
oooo00Kono_kom?CdonVYZKoVIVIolC4a?oclo<Yooooo`03okfm_OmbLW;ooooo00Oooooo00?oiNGU
oiRHV?ogmoL0J?ooool008Kooooo00GokNg]okfm_OnFUYKo[:b/om[JfP0/ooooo`03ol[:b_mYJFWo
oooo00Sooooo00?o_;blokRh^?ooool0Ioooool008?ooooo00KooOgmomSHf?nYZJWoV9RHol71`Oo_
knl^ooooo`03omSHf?mSHf?ooooo00Sooooo00?onOWioiVIVOoShn<0Ioooool0087ooooo00KolO7a
ol?3`onIVIWoZ:RXomCDe?omoOd`ooooo`03onOWiomKFe_ooooo00Wooooo00?of=SHoj2PX?omoOd0
I_ooool007oooooo00Gog=cLojj^[_nFUYKo_;blon_[j`0cooooo`03ooOgmomDE5Cooooo00[ooooo
00?o[Zj^olK6a_ooool0IOooool007cooooo00KomOGeolS8b?nLW9coXj>Som7AdOokno/fooooo`03
oe=CDookno_ooooo00Wooooo00?olO7aoiJFU_o_knl0IOooool007[ooooo00GohN7Qok>c/onEUIGo
][JfonGUi@0iooooo`03oeYJF_o[jn_ooooo00[ooooo00?ob/[:ojVYZOooool0I?ooool007Oooooo
00KonOWiol_;bonPX:3oX:2Pol_;booinOTkooooo`03of5QHOoKfm_ooooo00_ooooo00?oXJ6QomCD
e?ooool0Hoooool007Gooooo00GoinOWokRh^?nEUIGo/K6aon7Qh@0nooooo`03ofUYJOo=cLgooooo
00_ooooo00?oiNGUoiRHV?ogmoL0Hoooool007;ooooo00Kono_kom7AdOnTY:CoVi^KolK6a_oemOE0
ooooo`03ofm_Koo1`L7ooooo00cooooo00?o_;blokJf]_ooool0H_ooool0073ooooo00Gojn_[okbl
_?nFUYKo[Zj^omcLg013ooooo`03ogUiNOnc/k?ooooo00cooooo00?onOWioiVIVOoQhN40H_ooool0
06gooooo00KooOgmomKFe_nYZJWoV9RHol?3`ooalO55ooooo`03oh:2P_n[Zj_ooooo00gooooo00?o
f=SHoj2PX?omoOd0HOooool006_ooooo00KolO7aol71`OnHV9SoZJVYomKFe_omoOe7ooooo`03ohb<
S?nOWioooooo00kooooo00?o[Zj^olC4a?ooool0H?ooool006Wooooo00Gof][Jojb/[?nFUYKo_Kfm
ong]k@1:ooooo`03oiNGUonDU9Cooooo00kooooo00?olO7aoiJFU_o]kNd0H?ooool006Kooooo00Ko
mOGeolK6a_nKVi_oY:BTom?Cdookno]<ooooo`03oj6QXOn:RX[ooooo00oooooo00?ob/[:ojVYZOoo
ool0Goooool006Cooooo00Goh>3Pok6a/OnEUIGo^;RhonOWi`1?ooooo`03ojf][On0P83ooooo013o
oooo00?oXj>Som?Cdoooool0G_ooool0067ooooo00KomoOgol[:b_nNWYkoXJ6Qolg=cOoinOUAoooo
o`03okZj^_mfMWKooooo013ooooo00?oinOWoiRHV?ogmoL0G_ooool005oooooo00GoiNGUokJf]_nF
UYKo/k>con?Sh`1Dooooo`03olK6a_m^KVkooooo017ooooo00?o_;blokJf]_ooool0GOooool005co
oooo00Kono_kolo?conSXj?oW9bLolS8b?oemODaooooo`03ooGemOoooooooooo02;ooooo00?odM7A
ofEUIOooool04Oooool00ooinOWoVIVIon7Qh@1Mooooo`00F_ooool01OoYjNWo^[ZjoiJFU_n`/;3o
g]kN03?ooooo00Co_knoochb<?miM7Cob<S88_ooool00ooOgmooGEeMooooo`0Booooo`03om[Jf_nN
WYkooOgm05cooooo001Gooooo`06oogmoOoDe=CoZ:RXoiVIVOo3`l?olo?c<oooool02OomoOgoR8V:
oa4B4om56@coTSlXoehZ7?m?=S7oPGalol[:bP0Oooooo`03ono_komHF5Sooooo01?ooooo00?o/;2`
olC4a?ooool0Foooool005Gooooo00Kokno_okno_onHV9SoZj^[omSHf?omoOddooooo`0=onWYjOm@
DE;o51HJoa4>3on?:PSo]CD<ok=F@OnV<0_oQRT;oe`Z7?m@=c;oPginol_;b`0Mooooo`03oe5ADOoo
oooooooo01;ooooo00?olO7aoiJFU_o]kNd0Foooool005?ooooo00Gof=SHoj^[ZonHV9So_knoono_
k`0fooooo`05olC4a?lZ:boo4aDJo`@41Olb5a400one=@`02OnbET7o]CD<okDe3?nV<0_oQBP;oe/Z
7?mA>C?oQ81oolg=c@0Jooooo`03oeIFE_oclo?ooooo01?ooooo00?obl_;ojVYZOooool0F_ooool0
053ooooo00Kolo?colC4a?nIVIWoYZJVom?CdoomoOdgooooo`06ohZ:S?lF5a[o4QDIo`T:3?l=30ko
OR@81?ne=@`00onbET7o]CD<okDe3002okDe3006ojD`2_n4:0_oFbTMoe4j=On6PX7oclo?5oooool0
0omMGEgohn?Sooooo`0Dooooo`03oj>SXooCdm?ooooo05Wooooo001>ooooo`05omkNg_n`/;3oUYJF
okZj^_oYjNT0>?ooool02?o[jn_oDE9Do`/=3_lB5A[o3@hAo`000?lS513o/c<:1One=@`00onbET7o
]CD<okDe3004okDe3006oj@`2_n3:@coFBXMoe8k=_n9QHGodm?C5?ooool00omUIFGoe=CDooooo`0D
ooooo`03onOWionHV9SomoOg05Wooooo001;ooooo`06ooOgmoo8b<SoW9bLoj>SXoo?cloono_k>Ooo
ool02?o4a<Co:b`_o`<41Ol@4AKo4A8Fo`000?l820[oJAl71one=@`00onbET7o]CD<okDe3006okDe
3006oj<_2_n2:@goFBTMoe<l=on:QhOoe=CD4Oooool00om^KVkoa/K6ooooo`0Eooooo`03okfm_One
]KGooooo05Sooooo0019ooooo`05onGUiOne]KGoUIFEokFe]OoUiND0>oooool01On;Rhgo5QPKo`00
0?l<3Q7o5ALL00;o000000?o6Q4@oj/a2_ne=@`01one=@`00onbED3o]3D<okDe3008okDe3006oj8_
2_n1:0goF2TMoe@m>On<RHWoe]KF3_ooool00omfMWKo^[Zjooooo`0Eooooo`03ooWinOnKVi_ohN7Q
05Sooooo0018ooooo`04ooclo?mWIfOo]KFeooOgmc_ooooo00Kojn_[oe5CE?l<3@oo0000o`T:3OlI
7282o`000003o`<31?mF70[o]CD<00Wo]CD<00?o/U@ook@e3?ne=@`02_ne=@`01_nQ;`[oPBT=oeHY
7OmE?c[oSHb<omSHf0_ooooo00?oOGemojf][Oooool05_ooool00ooJf][oWYjNoogmo@1Gooooo`00
B?ooool01?oLg=coOGemolO7aooVi^Hjooooo`06olK6a_l[;2oo10@5o`000?l51POo7R0X0ol00000
0olE3a3oW2d:okDe300:okDe3003ok9D?Ond=@go]CD<00co]CD<00KoXBl:oglY3_mE:AgoEd4lohn=
SOoJf]X8ooooo`03ohN7QonQXJ7ooooo01Oooooo00?o/;2`ol?3`oooool0E_ooool004Sooooo00Go
`L71oi>CToogmoOoalO7onGUi@0hooooo`06ohf=SolG61_o0000o`000?l30`Co8RD]1?l000000om1
6@oo]CD<okDe300;okDe3003ok9B??nd=Pko]CD<00ko]CD<00KoX2h:oglX3_mE:AkoEd8noi6?SooL
g=`5ooooo`03oi:BT_nGUiOooooo01Oooooo00?olo?coiJFU_o]kNd0E_ooool004Sooooo00Ko[:b/
ojRXZ?oooooomoOgolO7aooUiNDeooooo`03on_[jomCDeKo30d?00;o000000?o0@41obDY<Ol00000
0ol000000ol<2@_oS2P8okDe300=okDe3003ok9A>_nd=a3o]CD<013o]CD<00KoWbh:oghY3_mC:Ago
F4<ooi:ATOoNg]h2ooooo`03oibLW?n?Shoooooo01Sooooo00?obl_;ojRXZ?ooool0EOooool004So
oooo00OoUYJFokno_oooooooooooooShn?o8b<Soi>CT03?ooooo00?oa/K6obd^<Ol410D00ol00000
0olW:cGo0000o`000002o`000004o`P72OlX7RGoMR87ok<c2Pko]CD<00?o/U0hok@h4One=@`04One
=@`02?nd=0_oWRh:og`X3omB:AkoFTE1oiBBTon<S8coQ8B46_ooool00onSXj?odM7Aooooo`1Doooo
o`00B?ooool00on2PX;ofMWIooooo`02ooooo`03ooShn?o8b<Soi>CT037ooooo00?oSXj@oaLI6ol0
00000ol000000olY;COo0000o`000002o`000006o`l=4OmJB5goVgNKof1<HOm7:B[oR2P83_ne=@`0
0onbCSGo]3TCokDe300CokDe3005ok@d2onM;P[oNRP>ocTK5omLG5`06_ooool00ooWinOoV9RHooOg
m`1Dooooo`00B?ooool00om_Kfoom_Kfooooo`03ooooo`03ooShn?o8b<Soi>CT02kooooo00?okNg]
oeAFF?l<3A001?l000000olZ;SSo0000o`000002o`000003oaHD6OmVDFSoYWnV00;oZX>Z00CoSVf>
oeA1Dom?9R3oV2`:3One=@`00oncCCCo]3XEokDe300EokDe3003ohDZ4ol]4a3oZZVZ01[ooooo00?o
_KfmokFe]Oooool0Doooool004Oooooo00?oj^[ZogIfM_ooool01Oooool00oohn?Sob<S8on?Sh`0/
ooooo`03olS8b?l];S7o10D500Co000000?o:Bdgo`000?l000000_l000000olN6b;oLEUcojR1Z004
ojZ3ZP05ojR1Z?n4IXGoBSQ6oeTS5_nS;`X03?ne=@`00oncC37o]3/FokDe300DokDe3004oih_3_mZ
7PKoD24Ioi>BTQWooooo00?ono_koi^KVooPh>00Doooool004Oooooo00?oclo?ohV9ROooool01_oo
ool00oohn?Sob<S8on?Sh`0Zooooo`03ohn@TOlG61_o000000Co000000?o9b/eo`000?l000000_l0
00000olV8B[oNf5mojZ3ZP07ojZ3ZP05ojEoYOmiGg_oAC<lofHQ3_n]<PX02one=@`00oncBRko]3`I
okDe300BokDe3006ojde4?nW<@[oKb07oj/b2omI8AKoO7Mh6Oooool00ooJf][oWYjNoogmo@1Boooo
o`00Aoooool00one]KGoWinOooooo`07ooooo`03ooWinOo9bLWoh^;R02Oooooo00?okNg]oeIGFOl<
3@l01Ol000000olT:37o0@82o`000002o`000003oblX<on6J8OoZX>Z00[oZX>Z00GoX7^PofeGKom4
;C?oMB47ok<c2P0:okDe3003ok=9;?nd?Q[o]CD<017o]CD<00SoY3DKoj/a2_m[7PKo]CD<ojlc2omS
8Q;oJF1RooWinASooooo00?o/;2`ol?3`oooool0DOooool004Oooooo00?oWinOokFe]Oooool02?oo
ool00ooinOWobLW9on;RhP0Uooooo`03ol[:b_l];c;o10D600Go000000?o8B@/o`<41Ol000000_l0
00000olh;cgoT6j@ojZ3ZP0=ojZ3ZP04oiQeV?mQC6;oARTZohLW20[o]CD<00?o/dLZok@o7_ne=@`0
4?ne=@`00onM=bKo/C<:ofHN1P02okDe3004ok8d2om_913oFTe?oo7alAOooooo00?olo?coiJFU_o]
kNd0DOooool004Oooooo00?oS8b<olc<c?ooool02Oooool00ooinOWobLW9on;RhP0Sooooo`03oi6B
T_lH6Aco000000Go000000Oo7AlVo`L72Ol0003o0000o`410Om3=dKoUgBG017oZX>Z00CoSfj?oeA2
E?m?9R3oUR/92One=@`00oncABOo/d4OokDe300?okDe3004oi/j<_ne=@coIQh6ok<c2P;o]CD<00Co
]3@;og/V3_m@?T3oinOW5oooool00oo;bl_oZ:RXooooo`1@ooooo`00Aoooool00omhN7SoinOWoooo
o`0:ooooo`03ooWinOo9bLWohN7Q023ooooo00?ooOgmoeMHFOl<3A001_l000001olI6b;o2PX=o`00
0?l0003o1PH8oddnD?nMNId04onZPjX01OnXPJSoQFN6od/iA_mI8aKoXbl:00So]CD<00?o/d@Tok=3
8_ne=@`03_ne=@`01?nI>cKo]CD<of/N1_n]<PX4okDe3003ohPX3?m8<S;of=SH01Oooooo00?oY:BT
om7AdOooool0Coooool004Kooooo00?onOWiofm_Koooool03?ooool00ooinOWobLW9on7Qh@0Noooo
o`03ono_kolk>3So0`<400Ko000000Oo51LLo`d?4_l0003o0000o`h<3omHAecoXWbR01KoZX>Z00Go
YGnUogYPNom5<cgoIR4>ojdb2P07okDe3003ok=28_ncA2Go]CD<00go]CD<00CoVC/fokDe3?m_80Oo
Yc4:1One=@`00onC:`[oAb/XolS8b00Fooooo`03onOWionHV9SomOGe04oooooo0016ooooo`03omcL
g?n0P83ooooo00gooooo00?on_[jolW9bOoQhN407?ooool00oo]kNgo?cdloaDB4@06o`000007oa0B
5_lA4aOo0000o`000?lD4QSoHe1VojIoYP0IojZ3ZP05oj1kX?m_Eg3oA2dcogDR2?nc<`X01_ne=@`0
0ond@B3o/dDWokDe300<okDe3004oiXj<one=@coM247oj8_2PKo]CD<00?oW2d:odPU8Onf][H05_oo
ool00ono_koo]KFeooooo`1>ooooo`00A_ooool00oo1`L7oTi>Cooooo`0>ooooo`03oo[jn_o:b/[o
h>3P01[ooooo00?olO7aodI3@_lP71T01_l000001ol=3Q7o61XNo`000?l0003o7ATPofmHLOnXPJP0
7?nZPjX01?nHMISoHDeSodLY:_n69PP6okDe3003ok@o7OncAbWo]CD<00_o]CD<00CoWSX]okDe3?mi
8`OoW2d:1one=@`00onS;`[oCB8Koj2NW`0Eooooo`03oo_knonKVi_oh>3P04kooooo0016ooooo`;o
ZZZZ4?ooool00oojn_[ob/[:omoOg`0Hooooo`04ooGemOm<BTWo30X9oa<@3`Go000000Ko2@X<oaXM
8ol0003o0000obDP:?mkH7/PojZ3ZP04oi1^T?mE@eGoCRHQoiH[2@Go]CD<00?o]3hKok=9;?ne=@`0
2_ne=@`01?nU>2?o]CD<oghT2?nH;0X8okDe3003ojPa2omD81OoR8B501Gooooo00?og=cLoibLW?om
oOd0COooool004Kooooo00?oTi>Col71`Oooool04?ooool00oojn_[obl_;omoOg`0Fooooo`04ooWi
nOmCDE7o2@L7ocP_;0Go000000Ko0P82oaPJ8?l0003o0000obdW<On5IhHRojZ3ZP05ojR1Z?n5IhKo
C3Y7oePT5onR;`X01?ne=@`00ond?AWo/TX^okDe3009okDe3004ojde5_ne=@coPbH8oi<Z2@Wo]CD<
00Co[C8;oehQ4omaJVcono_k5?ooool00ona/K7o`l?3ooooo`1<ooooo`00A_ooool00on0P83og=cL
ooooo`0Aooooo`03oo[jn_o;bl_og]kN01Cooooo00Gono_koeYHF?l:20So61@Bo`D40`04o`000006
o`<20_lW8Aoo0000o`000?lg;S_oSFf>9OnZPjX01OnUOjGoNf1lodHd?OmU8Pko[C8:00?o]CD<00?o
]3/Gok9<<One=@`01one=@`01Ona=A7o]CD<okDe3?n79`SoSBP800[o]CD<00Co/C<;ofXR4OmPEEKo
mOGe4oooool00ooclo?oUYJFon_[j`1<ooooo`00A_ooool00om_Kfoom_Kfooooo`0Booooo`03oo[j
n_o;bl_og]kN01;ooooo00GooOgmof9PH?l;2PWo0000oc0Y9P05o`000005oc8Z9ol0003o0000ocX^
>_nFLiH0:?nZPjX01OnPNj3oL5Qaod@^=?mc8PSo/c<:00;o]CD<00?o]3XEok9=<one=@`01_ne=@`0
1OnX=ako]CD<okDe3?n::0SoR2P800_o]CD<00Co/c@;ogHU3omEADKojn_[4oooool00oo=cLgoZ:RX
ooooo`1;ooooo`00AOooool00ooZj^[oMWIfooooo`0Dooooo`03oo_knoo;bl_og]kN017ooooo00Co
JfUYo`d;2ol0003o:b@Q1Ol000001Ole;B[o0000o`L51_m??TcoW7RL02_oZX>Z00CoVGJIof=>I?m6
:R_oQBH80_ne=@`00ond>A?o/TlfokDe3005okDe3005oj4i:One=@co]CD<ohlZ2?n39PP03One=@`0
0on29`coBcLgomkNgP0Cooooo`03ojBTY?oAdM7ooooo04[ooooo0015ooooo`03olo?con9RHWooooo
01Gooooo00?ono_kolc<c?oMgMd03oooool01OmdLg;o3`d<o`000?l20P;o81/J00Co000000Go=bh/
o`000?l>2`coFTIGoj5lX@0^ojZ3ZP07oi1_T?mE@eGoCBHQoiD[2One=@co]3PAok9@>005okDe3005
oi`j<One=@co]CD<oiD[2On09@P03_ne=@`00on?:P_oAbh]olo?c`0Booooo`03onWYjOnHV9SomOGe
04[ooooo0015ooooo`03okFe]OnOWioooooo01Kooooo00?ono_kolc<c?oMgMd03Oooool01OmnOGgo
40l=o`000?l0003o=RdZ00Co000000Go>2l/o`000?lG4ACoIDmSojEoY@0`ojZ3ZP07ojR1Z?n6J8Oo
BcY8oePS6?nR;`[o]3P@ok9A>P04okDe3005oiTk=One=@co]CD<oiX]2_mk8`L03one=@`00onI;0[o
AbLTokfm_@0Booooo`03okno_onc/k?ooooo04Wooooo0015ooooo`03oinOWone]KGooooo01Oooooo
00?ono_kolc<c?oLg=`02oooool01_n9R8So4Q0?o`000?l0003o3@/:o`l<30?o000000Go=bh[o`00
0?lN61coKeM]ojR1Z00cojZ3ZP06ojIoY_mkH7coAS<mof@R3_nZ<`goY48Y0one=@`01OnI>cKo]CD<
okDe3?nP;P[oMR87013o]CD<00?oX2h:od/S7OnXZ:P04Oooool00ookno_oVi^Kon3Ph019ooooo`00
AOooool00on9RHWoclo?ooooo`0Hooooo`03oo_knoo<c<cog=cL00Wooooo00?oU9>Boa@A4Ol00000
0_l000002?lg;R_o0000o`000?l0003o=B`Zo`000?lW7bCoNUii=onZPjX01OnPNj3oKeQaod@^=Oma
8@SoUCDZ00;o]CD<00GoVS/dokDe3?ne=@coYBl:og8Q1`0AokDe3003ojH`2omA81SoTXj?017ooooo
00?og=cLoibLW?okno/0B?ooool004Gooooo00?oMWIfon[Zj_ooool06Oooool00ookno_ocLg=omcL
g007ooooo`03oifLW?lF4a?o000000;o000000So7APGo`<20_l0003o0000oc4Z:?l0003o<2H/ohEV
Q3[oZX>Z00KoVWJJoe]6Folo8bSoKbXUokDe3?nM>Bl2okDe3003oj/a2_m^7`Oo]CD<00Oo]CD<00go
/c<:oj/a2_nQ;`[oV2`:ohlZ2?n79`SoOR@8ogLS1om_80OoJ1h6of0O3?ll7QSoR8>6017ooooo00?o
/K6aol71`Oooool0Aoooool004Cooooo00?om_Kfofm_Koooool06oooool00ookno_ocLg=om_Kf`05
ooooo`03ojRXZ?lG5ACo000000?o000000Oo;RLTo`000?l0003o:b@Ro`@30oli;SKoSVf=03goZX>Z
01goT6n@oe0lDom18ROoMbPIogDQ1om^7`OoHQ`4ocLC1_mK9AOoF2XOoe<]9OmB<B_oD3@_oddf<_m?
>SGoC3Xfod`l>?mEA43oGde8ofQGDOmbH5WoOFYQohQdJOnDOW7oXHYhojfDO_nfW8Co_:28od@n>`0A
ooooo`03oo?clonFUYKojn_[04Oooooo0014ooooo`03omcLg?n0P83ooooo01cooooo00?oo?clolg=
cOoKfm/00oooool00on`/;3o6QPGo`000003o`000007obdV9?l0003o0000obDP7Ol71@CoA3I0oiEc
U@0jojZ3ZP0DojZ5[?nZR[7oVWbPohibXOn@MJgoT7F[of9>K?m?@d7oUX5boj>;N_n`UX3oIeQ:okjR
ROo4Z8kobZbBom6bUooG^9cogKbPon?2Y?oZb:T;ono<[@03omjo[?mABT[ooooo017ooooo00?ob/[:
oijNW_ooool0A_ooool004Cooooo00?o`L71oi>CToooool07Oooool01_olo?cocLg=om[Jf_oooooo
^[Zjoa`I60Co000000Oo0`82oadH5ol0003o81/Io`d;2om=?D[oVgNK03?oZX>Z00?oZhV_ojb>]?nZ
SkH00_nZT;P00onZS[KoZX^bojZ7[P06ojZ3ZP03of=>J_n:NWSoklb]00;oklb]00?oRgMTonO4Yoo_
c:d04Oo_c:d00oo9/:ooETe;oo?cl`0>ooooo`06oo[jn_oVi^KodM7Aol?3`omcLg?oinOWA_ooool0
04Cooooo0_nZZZXOooooo`04ooclo?o>c/koY:BToalM70Go000000Ko=bh[o`000?lK5QGo5a8CoeQ5
EOnPNj0[ojZ3ZP03ojZ5[?nZR[7oZXje00;oZY2g00?oZXngojZ<]?nZRK003onZPjX00om6>D_o/9^M
ono<[@02ono<[@03oi5lJOoO_Z7oklb]017oklb]00?oa:f_ofYNFOoFe]H02oooool02Oohn?Sohn?S
olo?coo3`l?oe]KFon[Zj_omoOgoR8R8om7Ad@16ooooo`00A?ooool00onCTi?o`L71ooooo`0Ooooo
o`03olG5aOlO71_o000000Co000000Ko3`d<o`h;2_lC3`ko7QPJof==HOnTOZ@TojZ3ZP03ojZ8[onZ
S;CoZXnf00;oZY2h00?oZXjeojZ;/_nZQJ`05_nZPjX00onNNIkoACU5olF][`03ono<[@03oiN0KOoJ
^Ygoklb]017oklb]00?od;F^ogm_I_nm_Kd02?ooool01oofm_KohN7Qolg=cOo4a<Cof=SHong]kOon
o_h00oooool00onJVY[o_Kfmooooo`15ooooo`00A?ooool00on0P83og=cLooooo`0Nooooo`03olo?
colV8b?o000000Go000000Go=RdZo`d:2_lV7R7oKUI/ojR1Z00LojZ3ZP03ojZ6[OnZRk;oZXje00;o
ZY2h00?oZXnfojZ</onZR:l07onZPjX00on:JX[oHU=Bolbb[`03ono<[@03oif5LOoB]9Soklb]013o
klb]00CojlV]onW8[OnHPgCoY:BT1Oooool01_oclo?ogmoOol[:b_o6a/Kofm_Kono_k`Oooooo00?o
[:b/ojRXZ?ooool0AOooool004Cooooo00?oKVi^ooWinOooool07Oooool00ooFe]Ko:BLVo`000005
o`000004ob0K6Ol;20Oo;2<XogUMMaKoZX>Z00So/8VZokB=ZonYQJ7oTgJEojN=]?nZS[GoZXZbojZ5
[2OoZX>Z00?oL5Mdoi9mJOoI_:h00oo_c:d00onSRgKoc:fDono<[@0@ono<[@04om>g[_o_c:go/YR1
oh^;R`;ooooo00KolO7aomcLg?o8b<SobLW9omgMgOobl_8:ooooo`03ol71`OnCTi?ooooo04Gooooo
0013ooooo`03onOWiomhN7Sooooo01gooooo00?og=cLobd[:_l000001_l000000olW81ko<bT^oh9U
PP0>ojZ3ZP08ojf6Z_nbS:_o]Hn[okNA[?nhTJco]Y2[ok>=Zon_R:X`ojZ3ZP04oe51Eoo0Y8_ojlV]
ong;[@;oklb]00?oZI5jolFXS_o_c:d04?o_c:d02Oo5[Jooklb]ol6TRom^K6kof][JolG5aOo;bl_o
h>3PooCdm00=ooooo`03omWIfOn3Ph?ooooo04Gooooo0013ooooo`03olc<c?n<S8cooooo01cooooo
00?ohN7Qoc8_;_l100001_l000000olU7ago>Rhfoha/R`06ojZ3ZP09oj^4Z_n`RZ[o]8j[okN@Zonh
TJ_o]i2[okB>Zon`RZ[oZhBZ03OoZX>Z00GoYGnUod4e@oo[b:Woklb]ombm[@02ono<[@03ok2FOonn
XXWoklb]013oklb]00Kob:n^ono<[Oo?/9GoEe=Eon;Rh_ogmoL@ooooo`03oo3`l?mcLg?ooooo04Go
oooo0013ooooo`03okFe]OnOWioooooo01_ooooo00?oinOWocLd<ol20@401ol000001?m4=T3oU7>B
ok><ZonfSj/2okNA[003okJ?ZondSZgo[XNZ043oZX>Z00GoTW6BoeA7C?o_c:goklb]oljc[P02ono<
[@03okJKQ?ngWHCoklb]013oklb]00Cofkf]ono<[OoL_9ooF59D4oooool00omaLG7om_Kfooooo`14
ooooo`00@oooool00onOWioo]KFeooooo`0Jooooo`03on_[jolk>SWo0`<300Co000000Go1`L<oa0B
:_l?5Cco51HbohY]P`18ojZ3ZP05ogePOOmoK5ooklb]ono<[Oo6[Jl00_o_c:d00onlXHWo/IN0ono<
[@0?ono<[@05on71[Oo_c:goklb]on[8ZOmABDP04oooool00on2PX;og=cLooooo`14ooooo`00@ooo
ool00on9RHWoclo?ooooo`0Iooooo`0?ono_kom2@3oo10<2o`000?l71`ko418[o`lE??l=6V3o01Em
o`0IT_l06j7o01AjoeE3E_naRj[o]8j[04KoZX>Z00GoG4MLojjDOOo_c:goklb]olVa/@02ono<[@03
ol6US?n[TG_oklb]00ooklb]00Kob[6_ono<[Oo_c:goklb]oe]ACoo[jn/Booooo`03oi:BT_o4a<Co
oooo04Cooooo0013ooooo`03ogIfM_oZj^[ooooo01Sooooo00Solo?cobd]=?l72bCo3aDmo`dJH_l0
5Ggo01VBo`0KX@Go01bR00Go<Ra4oiIcU_nZPj[o]Xn[ojn9ZP13ojZ3ZP03ojV2ZOm4=T7ogKfP00;o
klb]00Goc[B`ono<[Oo_c:gob:^@ojB<MP0@ono<[@06olB/[oo_c:goklb]ono<[Om_HEcodM7A4_oo
ool00onUYJGo[Zj^ooooo`14ooooo`00@_ooool00oofm_KoKfm_ooooo`0Jooooo`03oadTCol06I;o
01^Q00Wo01bR00Oo8bYUog1GKonZPj[oZX>Zoj^4Z_ngTJ_oZhBZ047oZX>Z00?oVWNJodm0AOo_c:d0
0_o_c:d01OoD^:koklb]ono<[Oo@/IKoWhQc013oklb]00KockB^ono<[Oo_c:goklb]ohEcJ_nf][HB
ooooo`03okZj^_nLW9cooooo04Cooooo0012ooooo`03omWIfOn2PX;ooooo01[ooooo00?oCTmRo`/S
Wol07:802Ol07:800ol^>i[o?354ojAnY003ojZ3ZP03ojn9Z_nfSj_oZX>Z03ooZX>Z00?oQfR7ofmM
EOo_c:d00_o_c:d01OoVaJgoklb]ono<[OoF]i_oVX=_00ooklb]00?okLZ]onS7[Oo_c:d00_o_c:d0
0onNQgOoX:2Pooooo`0Aooooo`03olo?con9RHWooooo04Cooooo0012ooooo`03okno_onFUYKooooo
01[ooooo00?oRHV;ob0^ROl07:802Ol07:800olH;J?o5A]?ohAVP`05ojZ3ZP03okB>ZonaRj_oZX>Z
03goZX>Z00?oKUE^oi^4L?o_c:d00oo_c:d01?oR`Zgoklb]omfmX?nDOV/?ono<[@03omFh[_o_c:go
klb]00;oklb]00?o]Yb4ohJ5Q_ooool04Oooool00ooWinOoN7Qhooooo`14ooooo`00@_ooool00onX
Z:So[:b/ooooo`0Jooooo`03okZj^_lM9VOo01bR00[o01bR00?o3AinoeA2EOnZPjX01_nZPjX00ong
TJco[8JZojZ3ZP0kojZ3ZP03oe=1D?o:[I;oklb]00?oklb]00Cod[J^onO5Yoo7ZXooSWUW3oo_c:d0
0oo5[Jooklb]ono<[@02ono<[@03olBXS_m_K6oooooo01;ooooo00?oKVi^ooclo?ooool0@oooool0
04;ooooo00?oTi>Col71`Oooool06_ooool00oo_knoo7299obLhY00:o`0LXP03obhmYOl]:4CoUG>E
00OoZX>Z00?o[XNZokN@ZonZPjX0>OnZPjX00onRO:;oBCY2ono<[@02ono<[@07onG4Y_oA/iOoX8b;
okRMQOo;[I?oa:N=olR[T@0>ono<[@03olN^[oo_c:goklb]00;oklb]00?odK>Gof1KG_ooool04_oo
ool00omjNW[oi>CTooooo`13ooooo`00@_ooool00on0P83og=cLooooo`0Kooooo`03ocDhDOl[>9Wo
01bR00Wo01bR00?o>4BVo`0AHom`Efl02OnZPjX00oncS:[o/hb[ojZ3ZP0gojZ3ZP08ohi]S_mQD4ko
h/6Toln`UOnlX8So^Yn7olj`UOnhXJ@2ono<[@03onk;[?noXh[oeKJJ00goklb]00?ofKb]ono<[Oo_
c:d00_o_c:d00ooP_j;oETm@ooooo`0Booooo`03ohb<S?o<c<cooooo04?ooooo0012ooooo`03ofi^
K_oinOWooooo01_ooooo00?oIfQbo`@IPOl<9J802Ol07:801?l^?JCo01ZGoc`aA?nTOZ@:ojZ3ZP03
okNAZon^Qj[oZX>Z03CoZX>Z00KoWgZOofM?IomYFTco_J69om2aU_oS`Z@2ono<[@07olN^[oo_c:go
klb]ono<[OoXaZSo^9f5on30XP0;ono<[@03onK6[_o_c:goklb]00?oklb]00?okLZ[oe58AoomoOd0
4_ooool00onOWioo^;Rhooooo`13ooooo`00@Oooool00ooWinOoN7Qhooooo`0Looooo`03oj6QXOl;
6Vgo=T>V00Wo01bR00Co42NRo`0LX_lE6e3oQ6F32onZPjX00on/QJ[o]i6/ojZ3ZP0_ojZ3ZP07ojV2
ZOnMNIgoT6j@oh9TP_n8JHSoDT1Aok2GO`05ono<[@03olnd[?o_c:goklb]00;oklb]00?ogkjQokVN
Q_oYajP02_o_c:d00oo@][3oklb]ono<[@04ono<[@03of1ED_oUiNGooooo017ooooo00?o/K6aoj>S
Xoooool0@oooool0047ooooo00?oc<c<ohb<S?ooool07?ooool00ooCdm?o625Eob8eY00:o`0LXP03
oaP]Xol05GkoE4=F00goZX>Z00?o/H^ZokB>ZonZPjX0:_nZPjX02_nXPJSoW7RLohi]S_n2I8;oRVZ:
oiQeV?nUOjGoZ86XodLg@_oWa:L5ono<[@03omfnZOo_c:goklb]00?oklb]00?odK>Gol:US?o^bj`0
2Oo_c:d00oo4[:ooklb]ono<[@04ono<[@03ogAVH?o:b/[ooooo017ooooo00?oalO7ohn?Soooool0
@oooool0047ooooo00?o/k>coj6QXOooool07?ooool01?omoOgo92Q7o`0KW?lT=Z@9o`0LXP04oc90
YOl07:;o;2Q5oiEcU@koZX>Z00?o]Xn[ok29ZonZPjX09OnZPjX01onWP:OoVWJJoha[S?n2I8;oS6^<
oiYfV_nVP:H00onZPjX00onFM9KoEDI9ono<[@05ono<[@03onk;[?oXajgoklb]00Coklb]00?oa:R>
olj`UOo_c:d02?o_c:d00oo=/jkoklb]ono<[@04ono<[@03ohYgKOna/K7ooooo017ooooo00?og]kN
oh20P?ooool0@oooool0047ooooo00?oW9bLokRh^?ooool07Oooool00om:Beko01R;ocI2Y@09o`0L
XP04ocQ4YOl07:;o015SofmGK`ooZX>Z00?oZhBZokNAZon[Q:X08OnZPjX01onUOjGoV7FHohYZR_n2
I8;oSVf>oi]gVonXPJP01_nZPjX00on2I8;oN6EIono<[@06ono<[@03omBhZ?o_c:goklb]00?oklb]
00?ojlRZok^PQooK^ih01oo_c:d00oo]bjgoi/F]ono<[@05ono<[@03ojF=N_nIVIWooooo017ooooo
00?om_Kfofm_Koooool0@oooool0047ooooo00?oR8R8om7AdOooool07Oooool01?n4PhOo0QIho`XS
X_l98Z88o`0LXP05obTiYOl07:;o01ZGoc/aA?nTOZ@04?nZPjX00on`RJ[o]Xn[ojZ3ZP0LojZ3ZP07
ojAnY?nFLiKoR6V8oh9TP_n@KY3oWGVMojV2Z@09ojZ3ZP03ofYAJ?nTS7Koklb]00Koklb]00?oaZ^J
ono<[Oo_c:d01?o_c:d00ooT`jGo]ib4onG4YP06ono<[@03omJj[_o_c:goklb]00Goklb]00?o^Ij6
oh5oPOooool04_ooool00omeMGGokNg]ooooo`12ooooo`00@Oooool00omfMWKoj^[Zooooo`0Moooo
o`04okJf]_lC7V;o01bRocE2Y@So01bR00Go2B:Ro`4MX_l07:;o5A]@ohAUP`0BojZ3ZP03okB>Zona
Rj_oZX>Z01OoZX>Z00KoXWbRoiAbU?n6IhKoQ6F4oi5_TOnONYl=ojZ3ZP03oddmB_oF]i_oklb]00Ko
klb]00?oa:NFono<[Oo_c:d01Oo_c:d00ooI^Igo_:28onc9ZP05ono<[@03olJ^[oo_c:goklb]00Go
klb]00?oajZ@of]XK?ooool04_ooool00on3Ph?oe]KFooooo`12ooooo`00@?ooool00oofm_KoKfm_
ooooo`0Nooooo`04on_[jolL8D[o01bRobHgY0Wo01bR00Co83>Uo`0LX_l05GkoDd9E5?nZPjX00ong
TJcoZ8:WojZ3ZP0BojZ3ZP06oj1kX?nBLI;oQ6J4ohIWQ_nCLI?oXGbQ3onZPjX00onNNIkoC3e3ono<
[@07ono<[@03om:aX?o_c:goklb]00Koklb]00?objfColJYSoo_c:d01?o_c:d00oo7[Zooklb]ono<
[@05ono<[@03omBeV_mNF5_ooooo01;ooooo00?oUYJFokno_oooool0@_ooool0043ooooo00?ofMWI
oh:2P_ooool07oooool01?lb=Doo01VEo`0LX_lO<Z@8o`0LXP05ocE2YOl07:;o01bRob`WA?nELiD0
5?nZPjX00onTOj;oXWfRojZ3ZP0=ojZ3ZP07ojV2ZOnNNYkoT6n@oh=UPon7J8OoUG>Eoj9mXP0BojZ3
ZP03ohYZR_mWEe7oklb]00Ooklb]00?oh;f/ono<[Oo_c:d01_o_c:d00oo^bjco`:B;om>dV@04ono<
[@03omNj[Oo_c:goklb]00Goklb]00?oh/6ToeE=C_ooool04_ooool2ojZZZT?ooooo0010ooooo`03
okno_onFUYKooooo01oooooo00CoHf=_o`0FP_l07:;o=d>U2?l07:801Olf@jGo01bRo`0LX_l04FCo
KeM^027oZX>Z00OoZ86XoiahW?n>KHkoPVB2ohUYROnGM9OoY7jT01GoZX>Z00?oLeUcoi9mJOo_c:d0
1oo_c:d00ooV`jcoklb]ono<[@07ono<[@03onS6Z?nhWHGoh<2R00;oklb]00?oiLF]onk;[Oo_c:d0
1_o_c:d00oo^bjcoDTU8oo_kn`0Booooo`03okfm_OnHV9Sooooo04;ooooo0010ooooo`03ojRXZ?n/
[:cooooo01oooooo00GoWYjNo`TIK_l07:;o3RJRo`HPXP07o`0LXP06ob@eY?l07:;o01bRo`0JV?lk
<DCoY7jT7OnZPjX01onWP:OoVWNJohe/SOn2I8;oRf^;oiQeV?nVOjH06?nZPjX00omHAEOo`:B;ono<
[@07ono<[@03ong:[?o^bjcoklb]00Soklb]00Goh;nRokVNQ_oYajSoklb]om6g/009ono<[@03of=H
EOoPh>3ooooo017ooooo00?odm?CohJ6Q_ooool0@_ooool0043ooooo00?oTY:BolC4a?ooool07ooo
ool01Oo?cloo625Go`0LX_l07:;o<d2U00Oo01bR00Ko0ajRo`HPX_l07:;o01bRoa@KD?n4IH<JojZ3
ZP07ojIoY_nHMISoRf^;oh9TP_n=K8goVWNJojN0Y`0JojZ3ZP03ojEoYOm6>47ojlRY00Woklb]00?o
ilB/ono<[Oo_c:d02?o_c:d01?oB]9So`JB;onk;[?o4[:l9ono<[@03ogQYHoo4a<Cooooo017ooooo
00?okNg]ogEeMOooool0@_ooool0043ooooo00?oOWinomkNg_ooool07oooool01Ookno_o8BI6o`0K
W_l07:;o:SZT00So01bR00Go9SNTo`0LX_l07:;o01F0oe=1E00GojZ3ZP07ojAnY?nGM9OoRFV9oh9T
P_n>KHkoW7RLojR1Z00MojZ3ZP03oi9aT_mKBd_oklb]00Woklb]00?ohKf/ono<[Oo_c:d02Oo_c:d0
0oo5Z8oocJnDolbb[`09ono<[@03oi1lKon/[:cooooo01;ooooo00?oKfm_ooWinOooool0@Oooool0
043ooooo00?oKVi^ooWinOooool08?ooool01Om6Aeco01R=o`0LX_l07:;o6bnS00Oo01bR00Ko=d>U
o`0LX_l07:;o01bRob`XAOnDLY@CojZ3ZP07oj9mX_nELiGoR6R8oh=UPon@Ki3oWWVNojV2Z@0PojZ3
ZP03ogeQOOn0KEkoklb]00Woklb]00?og[^/ono<[Oo_c:d02Oo_c:d00oo/bJ[o^Yn7olnbWP09ono<
[@03ojZAOOnEUIGooooo01;ooooo00?oOWinomkNg_ooool0@Oooool003oooooo00?oinOWogQhN?oo
ool08Oooool01On0P8Co0AEio`0LX_l07:;o>4BV00Oo01bR00Ko=46Uo`0LX_l07:;o01bRo`0AI?m_
Efd@ojZ3ZP06oj5lXOnCLI?oQVN6ohAVQ?nBLI;oX7^P9?nZPjX00omTCF?o[YAmono<[@09ono<[@03
omjj[?o_c:goklb]00[oklb]00?oc[:VokNLQ?oT`jD02?o_c:d00onmXHWoNWQjooooo`0Booooo`03
ohn?Soo9bLWooooo047ooooo000oooooo`03olc<c?n<S8cooooo027ooooo00Ko/k>coa4MHol07:;o
01bRoa8XX_l37Z86o`0LXP07oa``Xol07:;o01bRo`0LX_l06YSo>c14oj=mX`0<ojZ3ZP06oimjWonA
Ki7oQ6F4ohIWQ_nDLYCoXWbR9_nZPjX00onYPZWoBCU5omfmX00:ono<[@03on2l[?o_c:goklb]00[o
klb]00Coajj_omZjW_nkX8Ook<VZ1oo_c:d00oo:[9;oJ6AWooooo`0Booooo`03oj6QXOnc/k?ooooo
047ooooo000oooooo`03ok>c/onQXJ7ooooo027ooooo00?oinOWoaXQBol07:800_l07:800ol`?jGo
01bRo`0LXP05o`0LXP06o``UX_l07:;o01bRo`0LX_lD6e3oPfF22?nZPjX01onYPZWoWGVMoi1^T?n2
I8;oR6V8oiIcU_nTOZ@04OnZPjX00onZQ:[oZX>ZojZ3ZP0EojZ3ZP03oiYgV_m@@DKoklb]00[oklb]
00?oi<6/ono<[Oo_c:d02_o_c:d01?o5[Jooklb]olf_U?o5Z8l7ono<[@03omRhW?mKEEOooooo01;o
oooo00?o]KFeoinOWoooool0@Oooool003oooooo00?oW9bLokRh^?ooool08_ooool01Ol_<dgo01ZF
o`0LX_l07:;o;SfT00Oo01bR00Ko:c^Uo`0LX_l07:;o01bRo`0EP?mB@E@5ojZ3ZP07ojR1Z?nKMi_o
SVf>oh9TP_n:JX[oV7FHojEoY@0EojZ3ZP03ojj:[_nZPj[oZX>Z01CoZX>Z00?oQVN6ofmMEOo_c:d0
2_o_c:d00oo[b:coklb]ono<[@0:ono<[@05omBi[_o_c:gok/^/ol6TRooB]9P01_o_c:d00ooUa:Ko
Dd]<ooooo`0Booooo`03olc<c?n=SHgooooo047ooooo000oooooo`03ohR8R?oAdM7ooooo02;ooooo
00?oGUm/o`0FQ?l07:800_l07:800olG;:?o01bRo`0LXP04o`0LXP03ocQ4Y_l07:;o01bR00;o01bR
00[o;2Q5oiAbU?nZPj[oYX2VoiYfV_n<JhcoPVB2oha[S?nJMY[oYX2V;onZPjX00om^EFgoVhA`ono<
[@0;ono<[@03onW6[?o_c:goklb]00Soklb]00Ooi/F]ong;[Oo_c:goklb]onW7Z?niWXKoh;nR00Ko
klb]00?oEDa:ooGemOooool04Oooool00ooQhN7oO7alooooo`11ooooo`00?oooool00omeMGGokNg]
ooooo`0Rooooo`03oi^KVol7673o01bR00;o01bR00?o>4BUo`0LX_l07:801?l07:800ola?ZGo01bR
o`0LXP02o`0LXP07o`0@H_mRC67oRVZ:oh9TP_n>KHkoVgNKojR1Z00bojZ3ZP03oe=0D?o:[I;oklb]
00_oklb]00?ohkn/ono<[Oo_c:d02?o_c:d00oo>]:ooklb]ono<[@02ono<[@03on2oX_niWXKoj<JX
00Goklb]00?oJUeIomSHf?ooool04Oooool00oolo?coKVi^ooooo`11ooooo`00?_ooool00ooclo?o
LG5aooooo`0Sooooo`03ol[:b_lG85So01bR00;o01bR00?o5R^Ro`4MX_l07:801?l07:802OlE:j;o
01bRo`0KW?l068ko01J2o`0CM?lb:CWoUW>FojV2Z@0dojZ3ZP03oj9lX_m9>T;oklb]00coklb]00?o
gk^/ono<[Oo_c:d02?o_c:d00oo2ZZ[oklb]ono<[@03ono<[@03om>dVOo0Y8_ok/^/00Coklb]00?o
P6mVokno_oooool04_ooool00omhN7Soj^[Zooooo`10ooooo`00?_ooool00ooFe]KoPh>3ooooo`0S
ooooo`03ooWinOlP9DKo01^N00?o01bR00?o;cnXo`0LX_l07:800_l07:802Ol06Y[o01R=o`lQPOl0
5Ggo01R;o`0JUol07:;o51]@oh=UPP0eojZ3ZP03ohi]S_mQD4koklb]00coklb]00?og[Z/ono<[Oo_
c:d02?o_c:d00oo5YI7oklb]ono<[@04ono<[@03olJYSoo<[Y?oklb]00?oklb]00?oNfQKojBTY?oo
ool04_ooool00on8R8SodM7Aooooo`10ooooo`00?_ooool00ono_kooUYJFooooo`0Tooooo`03od=4
F_l068ko01bR00;o01bR00So<T:Yo`0LX_l06YSo01R;o`0EO_l05Woo01R<obdjW0Co01bR00?o01F0
oe91E?nZPjX0=?nZPjX00omiGGWoR7ARono<[@0<ono<[@03omjk[?o_c:goklb]00Soklb]00?oh[fS
ono<[Oo_c:d01?o_c:d00oo/bJ[o_:28omViW@02ono<[@03okRLQOmOEeOooooo01?ooooo00?oVYZJ
okZj^_ooool0@?ooool003kooooo00?oZ:RXojb/[?ooool09?ooool02_mlO87o01Eko`0LX_l06j7o
01ZFo`4HROl>7ggo01J1o`0HS_l06Y/2o`0LXP03ocQ4Y_l07:;o01bR00?o01bR00?o;2Q5oiAbU?nZ
PjX0<onZPjX00omNBEco]if4ono<[@0<ono<[@03on:o[?o_c:goklb]00Ooklb]00?of[BOono<[Oo_
c:d01_o_c:d01_oUa:Ko]ib4onC3YOoN_J3oETQ4omkNgQCooooo00?o[Zj^ojRXZ?ooool0@?ooool0
03kooooo00?oTY:BolC4a?ooool09?ooool01on/[:co3AUMo`0GQol05Gco01J2o`0HT?lf@J001Ol0
7:800ol/>jCo01bRo`0LXP03o`0LXP03o`0AIOm^EFgoZX>Z03;oZX>Z00?oZ86XodHg@_oWa:L03Oo_
c:d00ooWa:_oklb]ono<[@07ono<[@03olJLTOo_c:goklb]00Ooklb]00Cofk^Nok^PQomlIU[oVIVH
5Oooool00oo1`L7oTi>Cooooo`10ooooo`00?_ooool00omnOWkog]kNooooo`0Qooooo`07ooOgmooC
dm?o/;2`ohB4Q?lD6Cgo01VAo`0KWP02o`0LXP03oa/_Xol07:;o01bR00?o01bR00?o3RFRo`0LX_l0
7:800ol07:800ol06YSo>c13oj=mX`0bojZ3ZP03oiIdU_mFATWoklb]00koklb]00?oilBWono<[Oo_
c:d01_o_c:d00oo3VHooklb]ono<[@08ono<[@03oif6LOm4?Skooooo01Gooooo00?ofMWIoh:2P_oo
ool0@?ooool003kooooo00?oKVi^ooclo?ooool07_ooool02Ooclo?ocLg=oj^[ZonEUIGo/;2`om?C
doogmoOo:bm;o`0JU`04o`0LXP03obXjYOl07:;o01bR00?o01bR00?o6bnSo`0LX_l07:800ol07:80
0olD6e7oPVB1ojZ3ZP0aojZ3ZP03oh9TP_mhIEWoklb]00koklb]00?oeJjKono<[Oo_c:d01_o_c:d0
0ooBZiWoklb]ono<[@07ono<[@04omjmX?mEAd;oTY:BolC4a1Gooooo00?olo?cog=cLoooool0@?oo
ool003gooooo00?oi>CTogYjN_ooool07?ooool01oo_knoob/[:ojJVY_nFUYKo]KFeomSHf?okno/0
0oooool00omJFf[o01N5o`0LXP03o`0LXP03ocA3ZOl07:;o01bR00?o01bR00?o<d6Uo`0LX_l07:80
0ol07:800ol05X3oDT5DojZ3ZP0]ojZ3ZP06ojn:[onZPj[oZX>ZojZ3Z_mYDFSoY8af3oo_c:d00oo9
Wi;oklb]ono<[@05ono<[@03onS4Z?o/b:_oklb]00Ooklb]00Kok/^/ogeXG?nKVi[olo?coiVIVOoN
g]hEooooo`03og5aLOoclo?ooooo03oooooo000mooooo`03olW9bOn=SHgooooo01Wooooo00OojNWY
olC4a?nQXJ7oV9RHokRh^?oNg]kooOgm00Kooooo00?oUYJFo`HHL_l07:800ol07:800ol57j;o3RJS
o`0LXP03o`0LXP03ocM3YOl07:;o01bR00Co01bR00?o:bM5oiAbU?nZPjX0<?nZPjX00om=?4[oe[NK
ono<[@0>ono<[@03ol:ISoo_c:goklb]00Goklb]00?ocjNGono<[Oo_c:d01oo_c:d01onfVh?oH5UG
oooooooooooohN7QoiRHV?oalO405?ooool00on2PX;ofMWIooooo`0oooooo`00?Oooool00ona/K7o
Xj>Sooooo`0Fooooo`06on?Shono_kooWYjNoibLW?nm_KgohN7Q2_ooool00oo6a/Ko5R1Jo`0LXP04
o`0LXP03ocM3YOl07:;o01bR00;o01bR00?o9cRTo`0LX_l07:801?l07:800ol04FCoJ4mWojZ3ZP0X
ojZ3ZP0:ojR1Z?nPNj3oUgBGohi]S_n6IhKoO61log1FLOmPC6?oB3e5ong:Z`ooklb]00?o`iZ?ono<
[Oo_c:d01Oo_c:d00oo2VHooklb]ono<[@06ono<[@03omjmX?mEB4Cog]kN00?ooooo00?ob/[:oj>S
XoomoOd04oooool00onCTi?oa<C4ooooo`0oooooo`00?Oooool00onLW9co^;Rhooooo`0Booooo`07
oogmoOoPh>3o^[ZjoiVIVOnPX:3o`l?3onOWi`0=ooooo`03ooOgmolO94Ko01^P00Co01bR00?o7S:S
o`0LX_l07:800_l07:800ol279ko0AbPo`0LXP04o`0LXP03o`0JV?lh:CcoXgfS01koZX>Z01GoZ86X
oimjWonFM9KoSVf>ohIWQ_mkGg_oKeI_of==I?mEA5SoB3]<oclfA?m2?4coAdEGodeBIOmCGgOoFg2:
ofV0WOmfT[7oIgbGoemFD_o[b:T03_o_c:d00oo:XYCoklb]ono<[@05ono<[@03olROT_o_c:goklb]
00Goklb]00?ok/^/ogaXG?nKViX01Oooool00ona/K7o^;Rhooooo`0Booooo`03ojFUYOn^[Zkooooo
03oooooo000mooooo`03ohR8R?oAdM7ooooo00oooooo00Oono_kom[Jf_nf][KoUYJFojBTY?o6a/Ko
kNg]017ooooo00?o?d5Ho`0HSol07:801?l07:800ol@8Hoo01bRo`0LXP02o`0LXP03oadUUOl07:;o
01bR00Co01bR00?o4aI=oh5SPOnZPjX04onZPjX05?nXPJSoWgZOoiIdU_n>KHkoQFJ5og]ONom_EVoo
HTeToeE4F?m7>dco?cI4od<mCOm7AUSoCE9Uoe=OMomLLX_oJH6OogJB/On4XlSoTkKN2?nQa_801?nP
aO7oIGVDofQMEoo]bZ/=ono<[@03omRbW_o_c:goklb]00Goklb]00?ogkVRono<[Oo_c:d01Oo_c:d0
0oneVX?oH5UHooooo`05ooooo`03oo_knonPX:3odM7A01;ooooo00?o^[ZjoiZJV_ooool0?oooool0
03gooooo00?oMGEeong]kOooool03?ooool01ooinOWoe=CDok6a/OnEUIGoZJVYol_;booalO405?oo
ool00om_Kg?o0QEeo`0LXP04o`0LXP03obd[S_l07:;o01bR00;o01bR00?o;R^>o`0LX_l07:801?l0
7:800ol05X3oCcY<ojZ3ZP09ojZ3ZP0DojN0YonNNYkoUW>Fohi]S_n5IXGoNEeiofaCKOmRCFCoEDAH
odLjBoln=TCo@ce=odM6F?m=DVKoDf5hoeabRomYPIooMi:cohJTbOnC]]hCoj76lP03oio3komOKhSo
MFIL00goklb]00?ojlRZonc9Zoo_c:d01?o_c:d00ooL]Z3oklb]ono<[@05ono<[@03omjmX?mEB4?o
g]kN00Oooooo00?okNg]oiRHV?oWinL04Oooool00ooAdM7oRHV9ooooo`0oooooo`00??ooool00oof
m_KoLG5aooooo`0:ooooo`07ooGemOoAdM7o[:b/oiFEUOn/[:codM7AooOgm`0Gooooo`03on_[jolW
9dCo01VB00Co01bR00?o1afNo`XOWOl07:800_l07:800ol^:hgo01bRo`0LXP05o`0LXP0EobTQ?_nC
LI?oWWZNoiIcU_n=K8goQ6J4og]MNOm_Df[oHdULoeE0D?m9>4Go@C<oodHmB_m:A5;oCTmPoeAPMOmN
LhgoJX>PogNB/on6Y<WoUKSP01koXLKb00?oWL7/oeQWOOn3LF803Oo_c:d00ooJ]Iooklb]ono<[@03
ono<[@03olNNT_o_c:goklb]00Coklb]00?ok/^/ogaWFonLW9`02Oooool00ooHf=SoVi^KooOgm`0@
ooooo`03onOWiomhN7Sooooo03oooooo000looooo`03omkNg_n3Ph?ooooo00Oooooo00OolO7aol_;
bonXZ:SoUIFEok6a/OoFe]KonOWi01_ooooo00?oZj^[oa4GD_l06j001?l07:801Ol^;8ko01bRo`0L
X_l07:;o72FD00Oo01bR00_o015XobhU;_m5>DCoBTABodm@H_mEHGOoGW>=ofZ3X?mhU;GoQZK;oiFh
h00Yoj76lP03oiZnj?mCGg?oTGe[00coklb]00?oc:BEono<[Oo_c:d00oo_c:d00oo3VHooklb]ono<
[@04ono<[@03okFJPomQFU[ooooo00[ooooo00?o_knooj^[Zoooool04?ooool00om^KVkoo?cloooo
o`0nooooo`00??ooool00oo9bLWoV9RHooooo`04ooooo`07ong]kOo6a/KoY:BToiJFU_nf][Kof][J
oogmo@0Oooooo`03oeQEH?l35GOo01bR00?o01bR00Ko7bJDo`0LX_l07:;o01bRo`4LXOl77Yh6o`0L
XP07o`<BF?mhTkCoXLKboj>lhonX[/coZ:g:ojFig@0^oj76lP03oiNjhom5D63oXHYe00_oklb]00?o
a9Z@ono<[Oo_c:d00oo_c:d00oo@Z9Ooklb]ono<[@03ono<[@03omflX?mEAd?oh>3P00cooooo00?o
ZJVYol?3`oooool03oooool00omlO7coi>CTooooo`0nooooo`00??ooool02_nf][Ko[Zj^oooooooo
ooooinOWol71`OnPX:3oVIVIokbl_?oPh>0Sooooo`03onGUiOlS8d?o01VD00Co01bR00Go7BJEo`0L
X_l07:;o01bRob8WT`06o`0LXP03oaXQD?n4XlOoXLKb00CoXLKb00CoXkcQojR^c?nX[L_oY;WN:onQ
a_800onC]Mko@dQHok2FO`0:ono<[@03ol:IS_o_c:goklb]00;oklb]00?oj/JYon[7Z_o_c:d00oo_
c:d00oo^bjcoNfIKoibLW00=ooooo`03ooGemOnIVIWog=cL00oooooo00?oS8b<olc<c?ooool0?_oo
ool003cooooo00OoX:2Pok2`/?nm_KgoVi^KoijNW_no_kooiNGU02Oooooo00?oX9nPo`lGE_l06j40
0ol07:801Ola<YGo01bRo`0LX_l07:;o;bb=00Ko01bR00?o:Ri=ohnaf?nQa_802?nQa_801?nS^n7o
Z:g<ojR]bonT^]lXoj76lP03ohnaf?m0@e7o_:6900Woklb]00?oainBono<[Oo_c:d00_o_c:d00oo@
Z9Soklb]ono<[@03ono<[@03okBIP_mQFUWooooo00kooooo00?ohn?SoiRHV?o_knl03_ooool00onO
Wioo]KFeooooo`0nooooo`00??ooool01?nHV9SoQXJ6olC4a?o[jn/[ooooo`03odm<FOl25W_o01bR
00;o01bR00Go2QjMo`LOX?l07:;o01bRob/ZS`06o`0LXP03oc4eBonK_nWoXLKb00coXLKb00CoXk[Q
oj^ddonX[L_oY;[P9OnQa_800on:Z]3o@41;olR[T008ono<[@03om>/V_o_c:goklb]00;oklb]00?o
`iV?ono<[Oo_c:d00_o_c:d00ooM_:3oEDM3on3Ph00@ooooo`03olg=cOnQXJ7ono_k00gooooo00?o
/K6aoj>SXoooool0?_ooool003cooooo00Con?Sholc<c?oDe=Cono_k:oooool00ooNg]ko8213o`0J
U`03o`0LXP04ob`[S_l07:;o01bRoaHSU`Go01bR00?o01ZFoce3E_nQa_804OnQa_801?nT^]ooZ:g;
ojR]c?nT^n4Roj76lP03ohFSb?m1@4SodK>G00Ooklb]00?oi/:Wono<[Oo_c:d00_o_c:d01oo7WY7o
klb]ono<[Oo_c:gok/^/ogYVF_nOWih04_ooool00onc/k?o][Jfooooo`0<ooooo`03olO7aon?Shoo
oooo03kooooo000mooooo`04ookno_oKfm_oalO7oo;blR_ooooo00?oUYFGo`dFF_l07:800_l07:80
1OlR9i;o01bRo`0LX_l07:;o3B:M00Co01bR00?o01J0oe9KLOnQa_805OnQa_801?nT^MooZ:g;ojR]
c?nT^n8Ooj76lP03ogfJ_Om4@DKof[ZM00Ooklb]00GohKbSono<[Oo_c:goklb]ombfW`03ono<[@03
okBHP_mQFUWooooo01;ooooo00?ono_koj6QXOo=cLd03?ooool00ooNg]koOWinooooo`0nooooo`00
?oooool00oo/k>coaLG5on;RhP0Zooooo`03oogmoOm7A5?o01J000?o01bR00Co6RFFo`0LX_l07:;o
9RVA1?l07:800ol04fkoIWJ?oj76lP0Ioj76lP04ojBig_nX[L_oY:c;oibihAcoXLKb00?oMHn`od]4
AooQ`:<01_o_c:d01?o@Z9Ooklb]ono<[OoN^:43ono<[@03omflX?mEAd?oh>3P01Cooooo00?okNg]
oiRHV?oUiND02oooool00oofm_KoKfm_ooooo`0nooooo`00@?ooool01?ohn?Soc/k>om7AdOojn_XY
ooooo`03omSHf?lM7T?o01ZI00;o01bR00Co;bb=o`0LX_l07:;o<2b=1?l07:800ol045_oMHn^oj76
lP0Moj76lP04oj6ffon@Y<CoT:O=oj2ojQWoXLKb00?oK8>Qoe=:B_oWa:L01Oo_c:d01?o5WI7oklb]
ono<[Oo8Wi82ono<[@03onk;[?mjIUWoWinN01Kooooo00?of][Joi^KVooemOD02oooool00omeMGGo
kNg]ooooo`0mooooo`00@_ooool00ooNg]koa/K6ono_k`0Yooooo`08ohZ9S?l;5Uoo01bRo`0LX_l<
7i_o11fPo`0LX_lX:I04o`0LXP03oaHODon2Wl?oXLKb027oXLKb00CoVKKPoj:eh?nS]n;oXL3/5_nQ
a_800omUN9GoGE5>ong:Z`04ono<[@04ol:HS_o_c:goklb]ol:ISP;oklb]00?o]9R2of9KF_ooool0
5oooool00oo1`L7oZJVYooooo`0:ooooo`03ohJ6Q_oCdm?ooooo03gooooo0013ooooo`03ono_koo6
a/KogmoO02Sooooo00?ono_kochlC_l05h@00_l07:800ol[:Xoo01bRo`lQVP04o`0LXP03obL]C_n=
[MCoXLKb02GoXLKb00CoY<3Zoj>fh?nW_NKoXL3/4_nQa_800onOa?3oG6f8ofUKE004ono<[@08olFL
T?o_c:goklb]oljVU_o_c:gog;bOoeI8A?oPh>0Iooooo`03ojVYZOo1`L7ooooo00Wooooo00?oUYJF
okno_oooool0?Oooool004Cooooo00Con_[jom7AdOo>c/kon?Sh9oooool01Oo?cloo6Qa5o`0JVol0
7:;o9BVA00;o01bR00Ko4b:Io`0LX_l07:;o01bRoc0dBonH^nDZoj76lP04oi6/e_n7UL?oRY[8oiVg
i0ooXLKb00?oW/;^oeITO?mfIe/00oo_c:d01oo?YiOoklb]on_8Z_oYaJWok/^/ogYUFOnOWih06_oo
ool00oogmoOoVi^Kom[JfP09ooooo`;oZZZZ?_ooool004Kooooo00?oh^;RolG5aOo/k>`09oooool0
1omoOX?o2QITo`0LX_l07:7o5R>Ho`0LX_lZ:Xl00_l07:800ol06Y[o>CiAoj76lP0]oj76lP05oj35
lOnBZMKoR9G3oh^Jb?nJ^>@03?nQa_800onK_n[oCe]aohMcI002ono<[@06omniX_o_c:godZ^Iono<
[OncV87oHEaK7?ooool00ooUiNGoV9RHong]k@08ooooo`03okno_onHV9Sooooo03gooooo0017oooo
o`04oo7alOo7alOofm_KooknoRGooooo00OomoOgocLfB_l05hSo01bRoc0/SOl07:;o<2b=00;o01bR
00?o01J5odeEJ_nQa_80<OnQa_801OnPaO7oTZSEohRE`on;V/WoV[WV00WoXLKb00?oVKcVodUCIonG
P6h00_o_c:d01OoXaJWo`iZ?omblWomDAd?ohN7Q01gooooo00?oclo?oj6QXOokno/01oooool00ooC
dm?oQXJ6ooooo`0mooooo`00B?ooool01?okno_oe=CDolc<c?ogmoLUooooo`06olS8b?lG6TOo01^L
oa4QVOl27J3o9BRA0_l07:800ol04g;oHVn8oj76lP0eoj76lP05oj34l?nAYmGoR9G2oh^KbOnK^^H0
1_nQa_802?nF^>7oADaNojJ>N?o_c:gofkFQolFLT?miIEWoX:2P7oooool00one]KGo/k>cooooo`06
ooooo`03ong]kOmeMGGooooo03gooooo001:ooooo`03onGUiOo4a<CojNWY02Gooooo00WoMWEjo`PF
J?l07:;o:2V@o`PNWOl17:7o01bRo`0@H?mcRjT0>_nQa_801OnPa?3oT:KDohRD`on;W<[oVk_W00?o
XLKb00KoT[CLod96E_neVX;odJ^LojV<NomRFe/Pooooo`03oo_knonQXJ7obl_;00Oooooo00?oKfm_
ooWinOooool0??ooool004_ooooo00Com?CdolW9bOoHf=SooOgm8oooool02OoemOGo<Bm7o`0HRolX
:I3o01bRoaTTUol07:;o4A]DognL_`0noj76lP0:oj34l?nEZmOoRIK4ohbLb_nK^nSoSZkEod12ConN
P7KoEDQ4on7QhB7ooooo00?okno_oiRHV?oShn<01_ooool00omnOWkog]kNooooo`0looooo`00C?oo
ool01?omoOgoemOGol[:b_odm?@Sooooo`08okno_olE6D_o01^Moa8RVOl/:hko01bRob@YCon:Z]12
oj76lP05oj34l?nEZmKoLh6SocXh??nRXJ408oooool00ooLg=coVi^KooGem@05ooooo`03ohn?Soo7
alOooooo03cooooo001>ooooo`03onSXj?o4a<Coi^KV02?ooooo00OoJVQ`o`HFK_l`;8go;bb=o`0L
X_l`<dcoU[SQ03SoXLKb00koWKkZoiF_g?n?Xm7oRi[9ohRE`on7U<;oRIK4oh^Jb?n?Xm7oUJoLohVX
c_mGIWooAdUDolK6aRGooooo00?o`l?3ojRXZ?ooool01?ooool00onSXj?o/k>cooooo`0looooo`00
Coooool01?ofm_Kobl_;omGEeOolo?`Qooooo`07ono_kol/:dGo3Qf7ob4WTol06Yko=S]>oio4l00]
oj76lP0;oik0k?nF/=goT:CBoh^KbOn9U/CoR9C2ohRE`on:V/SoSj;@oiB]f_nL_>T02?nQa_801On;
Zm7oEVAlodQ:EOn[Zj_ooOgm02Oooooo00?oZj^[okno_oooool00oooool00one]KGoWinOooooo`0l
ooooo`00D?ooool01?ono_kof][JolS8b?obl_8Qooooo`05okJf]_lC64go9bR>o`8HR?m9D6D08onQ
a_802onQa>ooY;cRojJef?nW/=3oZ:g;ohbN`?n5UL7oRYW7ohjQc_nCZmWoVk[V017oXLKb00GoRZ[?
oeERN_m:C5Ko[Zj^oogmo@0Yooooo`03ooOgmonKVi_of=SH00?ooooo00?oc<c<ohb<S?ooool0??oo
ool005;ooooo00?ojn_[olG5aOoShn<08Oooool01?mRGfWo6QmboaHKKOmMJX4Hoj76lP0<oj75l?nS
_NCoYKKIojNadOnX[LcoZ[7?ojV]b_nX[/coY[7BojFgfonR_^GoXLGa6OnQa_801On9ZLkoDf1hod]=
Eon`/;3ooOgm02cooooo00?oinOWoiJFU_o]kNd00_ooool00ooTi>CoO7alooooo`0looooo`00Dooo
ool01?ohn?Soc/k>om;Bd_ojn_XOooooo`04on_[jolW9D?o5aMDog25XPgoXLKb00GoXLGaoj>niOnU
]m[oYk7BojR^c002ojV/b@05oj^ddonX]MKoYKKJoj:miOnQaO008_nQa_801?n8YlcoDUifode>FOnc
/k<`ooooo`06om7AdOnPX:3onOWiooooooolo?coKVi^?Oooool005Cooooo00Coo_knomkNg_o6a/Ko
l?3`7oooool00on[Zj_o4aHgogfI^`03oj76lP0;oj>oionU^=coYk;CojR^cOnX[<[oZJ_9ojR]bonW
/=3oYKGHoj>lhonQa>l0:onQa_801?n7Y/coD5acodi@F_ne]KDcooooo`06okRh^?na/K7ooooooooo
oomhN7Sojn_[??ooool005Kooooo00?ok^k^olG5aOoOgml07oooool01_mDDe[oDEQWofU`Q?mhRZOo
RJG;oi^ojC?oXLKb00CoQZG:odmJL?m@DE[o^;Rh=Oooool01_omoOgoXj>Sol[:b_ooooooRHV9omSH
f3cooooo001Gooooo`04oo[jn_o@d=3oclo?ooWinAkooooo00Wolo?cokfm_On<S8goHEmUodM:DomE
GFgoKH6Koh:Pa?nE]ml0;?nQa_801OnPaO7oQJC9odiIKomBDeco^[Zj03Sooooo00GolO7aoiRHV?oQ
hN7oVYZJolG5a@0looooo`00FOooool00ooQhN7oaLG5ong]k@0Qooooo`0:oogmoOoAdM7oX:2Pog1^
LOm?D5OoB4eIofAaR?mjUkSoSZkEoik2kRGoXLKb00GoX<GaohBSaom=F6goDeALokfm_@0kooooo`04
omkNg_nIVIWoYZJVok:b/Scooooo001Jooooo`04oo7alOo7alOog=cLooknoRCooooo00WoV9RHoibL
W?n1P87oFEQNodM;EOmKI7OoM8ZXohNVbonI_>H07onQa_801OnPaO7oPj75od]EJomEEUoo_kno03ko
oooo00?oa<C4ogmoOonRXZ80??ooool005_ooooo00Cono_kom?Cdoo<c<comoOg8oooool03_nTY:Co
iNGUoooooooooooomoOgolC4a?nCTi?oIVAYodY;DomBF6OoJgbEoh2M`?nB]=coX<Ga6?nQa_801OnO
a?3oPIo3odYDJOmGF67o`l?3047ooooo00?oRXZ:og1`L?ooool0>oooool005gooooo00?oi>CTolC4
a?oZj^X08_ooool00onQXJ7ojNWYooooo`06ooooo`09omSHf?nVYZKoMWAfoe9AFOm9CEWoHVf3ogRB
/on;Zm7oWL7/01;oXLKb00GoWlC`oh2N`Om9DfOoFEYRolK6aP0nooooo`08ookno_o`l?3oh>3Pom7A
dOo3`l?obl_;onOWioono_hkooooo`00G_ooool01?oclo?ob<S8omWIfOomoOdPooooo`03oibLW?o_
knoooooo00[ooooo00WokNg]okRh^?n7QXOoGE]QodM:DomIHG;oL8FQohBSaonF^N803?nQa_801OnO
`nooP9c0odQAIOmLG6Cob<S803cooooo00Woo?clong]kOoNg]koclo?ol;2`_o=cLgogMgMonc/k?ok
no/0?_ooool005oooooo00Coo?clomKFe_o:b/[omOGe7oooool00onIVIWolo?cooooo`0>ooooo`0:
oo_knoo;bl_oVi^KofYYK?m<C5GoCeAQofQgS_mlVKcoSk7Hoio4l0GoXLKb00GoWl?_ogfJ_Om7D6Co
GEiUol_;b`0jooooo`09oo[jn_o[jn_og=cLolc<c?o2`/;od=3@omoOgoo^k^kooOgm04;ooooo001Q
ooooo`03onOWioo4a<CoinOW01kooooo00?oUIFEooOgmoooool04oooool03OoPh>3o[:b/ogYiNomF
EE_oB4]FoemYO?meSjgoRJS=oic0jommVKcoATmQof1PIoo=cLd0>?ooool02Oohn?SojNWYomWIfOo:
b/[o`l?3om;Bd_oQhN7olO7aooknoP16ooooo`00H_ooool01?oemOGobl_;omKFe_olo?`Looooo`03
oi:BT_omoOgooooo01Oooooo00Oolo?cokno_on<S8goHF1Uoci2C?mKFf;odM7A03Kooooo00Som_Kf
onKVi_oGemOoalO7olG5aOoDe=Coi>CToo?cld_ooooo001Sooooo`04oogmoOoJf][ob<S8oo?cla_o
oooo00?oT92@ooooooooool06oooool00ooemOGoooooooooo`0booooo`08oo?clooTi>CoeMGEolG5
aOo7alOoemOGonKVi_ofm_I?ooooo`00IOooool00ooZj^[oaLG5on?Sh`0Iooooo`03ooWinOnCTi?o
oooo04cooooo00Woo_knoo7alOoRh^;od];Bol?3`oo:b/[ofMWIonSXj?ohn?P0Doooool006Kooooo
00ComoOgolg=cOoBd];ono_k5oooool00ooemOGoV9RHooooo`18ooooo`09oogmoOo_knoogmoOom3@
d?o2`/;oc<c<om_Kfoo[jn_on_[j05Oooooo001Wooooo`04ookno_oMgMgoa/K6oo3`l1Kooooo00?o
lO7aoi^KVoooool0A?ooool02Ookno_ok>c/omgMgOo=cLgo`/;2olk>c_oNg]kokNg]ooclo01Koooo
o`00JOooool00oo]kNgoaLG5on3Ph00Eooooo`03on_[jonNWYkooooo043ooooo00WonOWion[Zj_oJ
f][obl_;ol?3`ooAdM7oh>3Poo3`l?omoOd0Goooool006[ooooo00ConOWiolo?coo@d=3onOWi4ooo
ool00ooWinOoXj>Sooooo`0looooo`08ooOgmooWinOof=SHolW9bOo4a<Codm?Con?Shoobl_9Toooo
o`00K?ooool00ooPh>3oaLG5onk^kP0Booooo`03on?ShonVYZKooooo03Sooooo00?om?CdonGUiOoF
e]H00_o6a/H00ooFe]KoiNGUooCdm01Xooooo`00KOooool01?o`l?3oa/K6omgMgOono_h@ooooo`03
omkNg_n[Zj_ooooo03Cooooo00Sol_;bon?ShooCdm?oa<C4olW9bOoHf=SoinOWooOgmfcooooo001^
ooooo`04oo_knooBd];ocLg=ooShn0oooooo00?of][Jojj^[_ooool0;oooool02OomoOgol?3`on3P
h?oAdM7o`l?3ol_;booJf][oj^[ZooWin@1`ooooo`00L?ooool00ooShn?oaLG5on_[j`0>ooooo`03
omCDe?na/K7ooooo02_ooooo00Woo?clong]kOoNg]koclo?ol;2`_o=cLgogMgMonc/k?okno/0M?oo
ool0077ooooo00Col_;bolS8b?oJf][ooOgm3?ooool00ooAdM7o][Jfooooo`0Wooooo`09oo[jn_o[
jn_og=cLolc<c?o2`/;od=3@omoOgoo^k^kooOgm07Sooooo001booooo`04ooclo?oEeMGobl_;ooKf
mP_ooooo00?ocLg=okZj^_ooool08oooool02Oohn?SojNWYomWIfOo:b/[o`l?3om;Bd_oQhN7olO7a
ooknoP1looooo`00M?ooool00ooVi^Koa<C4onSXj00:ooooo`03olS8b?nm_Kgooooo01oooooo00So
m_KfonKVi_oGemOoalO7olG5aOoDe=Coi>CToo?clh7ooooo001eooooo`04ooGemOo:b/[oemOGoocl
o0Sooooo00?oa<C4ol?3`oooool06oooool02?oclo?oi>CTomCDe?o5aLGoalO7omOGeooVi^Kom_Kf
QOooool007Kooooo00CooOgmomWIfOo9bLWolo?c1oooool00oo1`L7oa/K6ooooo`0Fooooo`09ookn
o_oalO7ohN7Qom;Bd_o3`l?ob/[:omWIfOoYjNWon?Sh08Wooooo001hooooo`03on[Zj_o5aLGoi>CT
00Kooooo00?o_;blol[:b_ooool04_ooool02OomoOgokno_omoOgoo@d=3o`/;2olc<c?oLg=cojn_[
oo[jnP2=ooooo`00NOooool01?ogmoOoc<c<om?Cdookno/4ooooo`03okRh^?o?cloooooo00kooooo
00Wono_konc/k?oMgMgocLg=ol;2`_o>c/kog]kNong]kOolo?`0TOooool007[ooooo00Coo_knomcL
g?o7alOolO7a0oooool00one]KGodm?Cooooo`0:ooooo`09ooWinOoZj^[of][Jol_;boo3`l?odM7A
on3Ph?o`l?3ooOgm09Gooooo001looooo`03ong]kOo5aLGohN7Q00;ooooo00?o/;2`omSHf?ooool0
1_ooool02?ogmoOoinOWomSHf?o9bLWoa<C4om?CdooShn?ol_;bV_ooool007gooooo00KonOWiolo?
coo@d=3on_[jojb/[?oLg=`3ooooo`03ooCdm?oUiNGoe]KF00;oa/K600?oe]KFonGUiOodm?@0W_oo
ool007oooooo00_ogmoOolK6a_nRXZ;odm?Con?ShooCdm?oa<C4olW9bOoHf=SoinOWooOgm`2Roooo
o`00P?ooool01_o_knooXZ:Rol71`OoJf][oj^[ZooWinJKooooo0000\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.290438, -4.60498, 0.00514523, \
0.00514523}},
 CellTags->"S5.41.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.41.1"]
}, Open  ]],

Cell[TextData[{
 "This displays two polyhedra simultaneously. The diameter of the icosahedron \
is reduced by a factor of ",
 StyleBox["0.7", "MR"],
 " and its center is moved to the point ",
 StyleBox["{3,", "MR"],
 " ",
 StyleBox["3,", "MR"],
 " ",
 StyleBox["3}", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.41.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
Show[
    Polyhedron[GreatStellatedDodecahedron],
    Polyhedron[Icosahedron, {3, 3, 3}, 0.7]
]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.41.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05679 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.044639 1.13857 4.09828e-17 1.13857 [
[ 0 0 0 0 ]
[ 1 1.05679 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08246 .24775 m
0 .77537 L
s
0 .77537 m
.39307 1.05679 L
s
.39307 1.05679 m
.41035 .57904 L
s
.41035 .57904 m
.08246 .24775 L
s
.67829 0 m
.93129 .40955 L
s
.93129 .40955 m
1 .91494 L
s
1 .91494 m
.71123 .55336 L
s
.71123 .55336 m
.67829 0 L
s
.08246 .24775 m
0 .77537 L
s
0 .77537 m
.71123 .55336 L
s
.71123 .55336 m
.67829 0 L
s
.67829 0 m
.08246 .24775 L
s
.41035 .57904 m
.93129 .40955 L
s
.93129 .40955 m
1 .91494 L
s
1 .91494 m
.39307 1.05679 L
s
.39307 1.05679 m
.41035 .57904 L
s
0 0 m
1 0 L
1 1.05679 L
0 1.05679 L
closepath
clip
newpath
.5 Mabswid
.75 .316 .219 r
.39765 .41984 m .36963 .48148 L .47754 .51276 L closepath p F P
0 g
s
.165 .243 .699 r
.39765 .41984 m .47754 .51276 L .45835 .4026 L closepath p F P
0 g
s
0 0 0 r
.39765 .41984 m .45835 .4026 L .36963 .48148 L closepath p F P
0 g
s
.045 0 0 r
.35562 .59245 m .41365 .58854 L .47754 .51276 L closepath p F P
0 g
s
.664 .741 .908 r
.35562 .59245 m .47754 .51276 L .36963 .48148 L closepath p F P
0 g
s
.103 .201 .682 r
.35562 .59245 m .36963 .48148 L .41365 .58854 L closepath p F P
0 g
s
.045 0 0 r
.57363 .3988 m .47754 .51276 L .55889 .45958 L closepath p F P
0 g
s
.9 .761 .699 r
.57363 .3988 m .45835 .4026 L .47754 .51276 L closepath p F P
0 g
s
.74 .283 .165 r
.57363 .3988 m .55889 .45958 L .45835 .4026 L closepath p F P
0 g
s
.9 .761 .699 r
.50715 .68266 m .47754 .51276 L .41365 .58854 L closepath p F P
0 g
s
.165 .243 .699 r
.50715 .68266 m .53169 .57573 L .47754 .51276 L closepath p F P
0 g
s
.658 .749 .918 r
.50715 .68266 m .41365 .58854 L .53169 .57573 L closepath p F P
0 g
s
.75 .316 .219 r
.64433 .56109 m .47754 .51276 L .53169 .57573 L closepath p F P
0 g
s
.664 .741 .908 r
.64433 .56109 m .55889 .45958 L .47754 .51276 L closepath p F P
0 g
s
.909 .771 .696 r
.64433 .56109 m .53169 .57573 L .55889 .45958 L closepath p F P
0 g
s
.672 .521 .672 r
.3004 .31309 m .36963 .48148 L .45835 .4026 L closepath p F P
0 g
s
.103 .201 .682 r
.3004 .31309 m .37927 .4052 L .36963 .48148 L closepath p F P
0 g
s
.74 .283 .165 r
.3004 .31309 m .45835 .4026 L .37927 .4052 L closepath p F P
0 g
s
.672 .521 .672 r
.2264 .60885 m .41365 .58854 L .36963 .48148 L closepath p F P
0 g
s
.658 .749 .918 r
.2264 .60885 m .35007 .52453 L .41365 .58854 L closepath p F P
0 g
s
0 0 0 r
.2264 .60885 m .36963 .48148 L .35007 .52453 L closepath p F P
0 g
s
.75 .316 .219 r
.18661 .42844 m .35007 .52453 L .36963 .48148 L closepath p F P
0 g
s
.664 .741 .908 r
.18661 .42844 m .36963 .48148 L .37927 .4052 L closepath p F P
0 g
s
.672 .521 .672 r
.6022 .27468 m .45835 .4026 L .55889 .45958 L closepath p F P
0 g
s
0 0 0 r
.6022 .27468 m .50079 .39054 L .45835 .4026 L closepath p F P
0 g
s
.165 .243 .699 r
.42572 .21535 m .45835 .4026 L .50079 .39054 L closepath p F P
0 g
s
.9 .761 .699 r
.42572 .21535 m .37927 .4052 L .45835 .4026 L closepath p F P
0 g
s
.909 .771 .696 r
.6022 .27468 m .55889 .45958 L .50079 .39054 L closepath p F P
0 g
s
.9 .761 .699 r
.30202 .72093 m .41365 .58854 L .35007 .52453 L closepath p F P
0 g
s
.672 .521 .672 r
.48694 .7668 m .53169 .57573 L .41365 .58854 L closepath p F P
0 g
s
.103 .201 .682 r
.48694 .7668 m .41365 .58854 L .45428 .58579 L closepath p F P
0 g
s
.045 0 0 r
.30202 .72093 m .45428 .58579 L .41365 .58854 L closepath p F P
0 g
s
.672 .521 .672 r
.72656 .55459 m .55889 .45958 L .53169 .57573 L closepath p F P
0 g
s
.74 .283 .165 r
.72656 .55459 m .54859 .50208 L .55889 .45958 L closepath p F P
0 g
s
.045 0 0 r
.70155 .36633 m .55889 .45958 L .54859 .50208 L closepath p F P
0 g
s
.664 .741 .908 r
.70155 .36633 m .50079 .39054 L .55889 .45958 L closepath p F P
0 g
s
.658 .749 .918 r
.72656 .55459 m .53169 .57573 L .54859 .50208 L closepath p F P
0 g
s
.909 .771 .696 r
.48694 .7668 m .45428 .58579 L .53169 .57573 L closepath p F P
0 g
s
.75 .316 .219 r
.62831 .6881 m .53169 .57573 L .45428 .58579 L closepath p F P
0 g
s
.165 .243 .699 r
.62831 .6881 m .54859 .50208 L .53169 .57573 L closepath p F P
0 g
s
.67 .519 .671 r
.18661 .42844 m .37927 .4052 L .35007 .52453 L closepath p F P
0 g
s
.764 .687 .777 r
.87194 .81456 m .86331 .73821 L .79824 .79565 L closepath p F P
0 g
s
.585 .556 .788 r
.93993 .78251 m .86331 .73821 L .87194 .81456 L closepath p F P
0 g
s
.8 .576 .599 r
.87194 .81456 m .79824 .79565 L .83372 .87616 L closepath p F P
0 g
s
.502 .359 .619 r
.93993 .78251 m .87194 .81456 L .92189 .86845 L closepath p F P
0 g
s
.635 .366 .495 r
.92189 .86845 m .87194 .81456 L .83372 .87616 L closepath p F P
0 g
s
.67 .519 .671 r
.42572 .21535 m .50079 .39054 L .37927 .4052 L closepath p F P
0 g
s
.664 .741 .908 r
.39673 .2669 m .37927 .4052 L .50079 .39054 L closepath p F P
0 g
s
.103 .201 .682 r
.39673 .2669 m .43302 .46798 L .37927 .4052 L closepath p F P
0 g
s
.9 .761 .699 r
.23621 .40992 m .35007 .52453 L .37927 .4052 L closepath p F P
0 g
s
.74 .283 .165 r
.23621 .40992 m .37927 .4052 L .43302 .46798 L closepath p F P
0 g
s
.828 .986 .875 r
.79824 .79565 m .86331 .73821 L .81847 .75028 L closepath p F P
0 g
s
.928 .55 .16 r
.83372 .87616 m .79824 .79565 L .79947 .83794 L closepath p F P
0 g
s
0 0 .139 r
.79824 .79565 m .81847 .75028 L .79947 .83794 L closepath p F P
0 g
s
.179 .507 .911 r
.90857 .74167 m .86331 .73821 L .93993 .78251 L closepath p F P
0 g
s
.154 0 0 r
.81847 .75028 m .86331 .73821 L .90857 .74167 L closepath p F P
0 g
s
.658 .749 .918 r
.23621 .40992 m .43302 .46798 L .35007 .52453 L closepath p F P
0 g
s
.67 .519 .671 r
.30202 .72093 m .35007 .52453 L .45428 .58579 L closepath p F P
0 g
s
.75 .316 .219 r
.31394 .60403 m .45428 .58579 L .35007 .52453 L closepath p F P
0 g
s
0 0 0 r
.31394 .60403 m .35007 .52453 L .43302 .46798 L closepath p F P
0 g
s
.67 .519 .671 r
.70155 .36633 m .54859 .50208 L .50079 .39054 L closepath p F P
0 g
s
.909 .771 .696 r
.39673 .2669 m .50079 .39054 L .43302 .46798 L closepath p F P
0 g
s
.165 .243 .699 r
.57931 .36825 m .50079 .39054 L .54859 .50208 L closepath p F P
0 g
s
0 0 0 r
.57931 .36825 m .43302 .46798 L .50079 .39054 L closepath p F P
0 g
s
.264 0 0 r
.87825 .88468 m .92189 .86845 L .83372 .87616 L closepath p F P
0 g
s
.082 .464 .888 r
.87825 .88468 m .83372 .87616 L .79947 .83794 L closepath p F P
0 g
s
0 0 .243 r
.94629 .82472 m .93993 .78251 L .92189 .86845 L closepath p F P
0 g
s
.889 .499 .05 r
.90857 .74167 m .93993 .78251 L .94629 .82472 L closepath p F P
0 g
s
.801 .998 .854 r
.87825 .88468 m .94629 .82472 L .92189 .86845 L closepath p F P
0 g
s
.67 .519 .671 r
.62831 .6881 m .45428 .58579 L .54859 .50208 L closepath p F P
0 g
s
.045 0 0 r
.52954 .58071 m .54859 .50208 L .45428 .58579 L closepath p F P
0 g
s
.103 .201 .682 r
.52954 .58071 m .45428 .58579 L .43302 .46798 L closepath p F P
0 g
s
.909 .771 .696 r
.31394 .60403 m .43302 .46798 L .45428 .58579 L closepath p F P
0 g
s
.658 .749 .918 r
.57931 .36825 m .54859 .50208 L .43302 .46798 L closepath p F P
0 g
s
.74 .283 .165 r
.52954 .58071 m .43302 .46798 L .54859 .50208 L closepath p F P
0 g
s
.628 .35 .477 r
.81847 .75028 m .90857 .74167 L .86921 .80482 L closepath p F P
0 g
s
.486 .342 .61 r
.79947 .83794 m .81847 .75028 L .86921 .80482 L closepath p F P
0 g
s
.576 .554 .793 r
.87825 .88468 m .79947 .83794 L .86921 .80482 L closepath p F P
0 g
s
.805 .575 .59 r
.86921 .80482 m .90857 .74167 L .94629 .82472 L closepath p F P
0 g
s
.767 .694 .782 r
.87825 .88468 m .86921 .80482 L .94629 .82472 L closepath p F P
0 g
s
.25 Mabswid
.67829 0 m
.93129 .40955 L
s
.93129 .40955 m
1 .91494 L
s
1 .91494 m
.71123 .55336 L
s
.71123 .55336 m
.67829 0 L
s
.08246 .24775 m
0 .77537 L
s
0 .77537 m
.71123 .55336 L
s
.71123 .55336 m
.67829 0 L
s
.67829 0 m
.08246 .24775 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.41.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.41.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Show[Stellate[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "display a stellated polyhedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Show[Stellate[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["display a stellated polyhedron with stellation ratio ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Show[Geodesate[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["display the projection of the order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " regular tessellation of each face of the polyhedron onto the \
circumscribed sphere",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Show[Geodesate[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["radius", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["display the projection of the order ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " regular tessellation of each face of the polyhedron onto the \
circumscribed sphere having center ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and size ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["radius", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Show[Truncate[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "display a truncated polyhedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Show[Truncate[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "display a truncated polyhedron with the polygon edges truncated by the \
ratio ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Show[OpenTruncate[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "display a truncated polyhedron without the polygons that close the \
truncated vertices",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Show[OpenTruncate[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "display a truncated polyhedron with edges truncated by the ratio ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ratio", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" without the polygons that close the truncated vertices",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.41.1"],

Cell["Transformation functions for the regular polyhedra. ", "Caption",
 CellTags->"S5.41.1"],

Cell[TextData[{
 "The polyhedra are by default centered at the origin with a unit distance \
from the origin to the midpoint of the edges. Any of the convex solids can be \
stellated using ",
 StyleBox["Stellate", "MR"],
 ". This replaces each of the polygon faces by a pyramid with the polygon as \
its base. The user can also adjust the stellation ratio. Note that ratios \
less than ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " give concave figures and that the default value of this ratio is ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". ",
 StyleBox["Geodesate", "MR"],
 " triangulates five\[Hyphen]sided or greater polygons before projecting onto \
the circumscribed sphere. If the order ",
 StyleBox["n", "TI"],
 " of the regular tessellation of each face is not given, a default value of \
",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is assumed. The default position of the sphere is ",
 StyleBox["{0,0,0}", "MR"],
 " with radius ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". ",
 StyleBox["Truncate", "MR"],
 " and ",
 StyleBox["OpenTruncate", "MR"],
 " act on every polygon and truncate at each vertex of the polygon. The \
default value of the truncation ratio is ",
 Cell[BoxData[
  FormBox["0.3", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.41.1", "1.6"}],

Cell[TextData[{
 "Here is a stellated octahedron with stellation ratio equal to ",
 Cell[BoxData[
  FormBox["4.0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This gives very long points. "
}], "MathCaption",
 CellTags->{"S5.41.1", "1.7"}],

Cell[CellGroupData[{

Cell["Show[Stellate[Polyhedron[Octahedron], 4.0]]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.41.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 5.41017e-17 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.572 .036 0 r
.42216 .58164 m .32369 .64791 L .63257 .69898 L closepath p F P
0 g
s
.755 .956 .649 r
.42216 .58164 m .52632 .40098 L .32369 .64791 L closepath p F P
0 g
s
.309 .356 .748 r
.42216 .58164 m .63257 .69898 L .52632 .40098 L closepath p F P
0 g
s
.772 .625 .697 r
.91022 .42206 m .52632 .40098 L .63257 .69898 L closepath p F P
0 g
s
.801 .994 .765 r
.91022 .42206 m .63257 .69898 L .74607 .51268 L closepath p F P
0 g
s
.601 .108 .055 r
.91022 .42206 m .74607 .51268 L .52632 .40098 L closepath p F P
0 g
s
.749 .63 .728 r
.40598 1.06315 m .63257 .69898 L .32369 .64791 L closepath p F P
0 g
s
.845 .965 .637 r
.40598 1.06315 m .52632 .78933 L .63257 .69898 L closepath p F P
0 g
s
.713 .257 .167 r
.97657 .93008 m .63257 .69898 L .52632 .78933 L closepath p F P
0 g
s
.433 .458 .786 r
.97657 .93008 m .74607 .51268 L .63257 .69898 L closepath p F P
0 g
s
.359 .362 .727 r
.40598 1.06315 m .32369 .64791 L .52632 .78933 L closepath p F P
0 g
s
.736 .591 .693 r
.10855 .26104 m .32369 .64791 L .52632 .40098 L closepath p F P
0 g
s
.662 .145 0 r
.10855 .26104 m .52632 .40098 L .40287 .44834 L closepath p F P
0 g
s
.421 .402 .733 r
.66497 .02988 m .52632 .40098 L .74607 .51268 L closepath p F P
0 g
s
.917 .979 .742 r
.66497 .02988 m .40287 .44834 L .52632 .40098 L closepath p F P
0 g
s
.371 .426 .789 r
.10855 .26104 m .40287 .44834 L .32369 .64791 L closepath p F P
0 g
s
.865 .989 .834 r
.02877 .79167 m .32369 .64791 L .40287 .44834 L closepath p F P
0 g
s
.652 .218 .204 r
.02877 .79167 m .52632 .78933 L .32369 .64791 L closepath p F P
0 g
s
.74 .592 .691 r
.97657 .93008 m .52632 .78933 L .74607 .51268 L closepath p F P
0 g
s
.754 .636 .73 r
.66497 .02988 m .74607 .51268 L .40287 .44834 L closepath p F P
0 g
s
0 0 0 r
.6952 .58531 m .74607 .51268 L .52632 .78933 L closepath p F P
0 g
s
.433 0 0 r
.6952 .58531 m .40287 .44834 L .74607 .51268 L closepath p F P
0 g
s
.202 .289 .731 r
.6952 .58531 m .52632 .78933 L .40287 .44834 L closepath p F P
0 g
s
.78 .63 .695 r
.02877 .79167 m .40287 .44834 L .52632 .78933 L closepath p F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.41.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.41.1"]
}, Open  ]],

Cell["\<\
Here is an example of a polyhedron that is triangulated before being \
projected onto the circumscribed sphere. \
\>", "MathCaption",
 CellTags->{"S5.41.1", "1.8"}],

Cell[CellGroupData[{

Cell["Show[Geodesate[Polyhedron[Dodecahedron], 4]]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.41.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08629 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0570532 1.16684 1.30104e-18 1.16684 [
[ 0 0 0 0 ]
[ 1 1.08629 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08847 .24541 m
0 .80419 L
s
0 .80419 m
.40073 1.08629 L
s
.40073 1.08629 m
.4183 .58184 L
s
.4183 .58184 m
.08847 .24541 L
s
.67213 0 m
.92714 .41532 L
s
.92714 .41532 m
1 .94902 L
s
1 .94902 m
.70602 .58604 L
s
.70602 .58604 m
.67213 0 L
s
.08847 .24541 m
0 .80419 L
s
0 .80419 m
.70602 .58604 L
s
.70602 .58604 m
.67213 0 L
s
.67213 0 m
.08847 .24541 L
s
.4183 .58184 m
.92714 .41532 L
s
.92714 .41532 m
1 .94902 L
s
1 .94902 m
.40073 1.08629 L
s
.40073 1.08629 m
.4183 .58184 L
s
0 0 m
1 0 L
1 1.08629 L
0 1.08629 L
closepath
clip
newpath
.5 Mabswid
.71 .562 .685 r
.52312 .64883 m .53717 .58881 L .49022 .60944 L closepath p F P
0 g
s
.697 .549 .682 r
.53717 .58881 m .52312 .64883 L .572 .62822 L closepath p F P
0 g
s
.72 .588 .707 r
.5044 .55191 m .49022 .60944 L .53717 .58881 L closepath p F P
0 g
s
.68 .559 .711 r
.53717 .58881 m .59831 .58217 L .56319 .5447 L closepath p F P
0 g
s
.701 .586 .724 r
.56319 .5447 m .5044 .55191 L .53717 .58881 L closepath p F P
0 g
s
.678 .547 .698 r
.59831 .58217 m .53717 .58881 L .572 .62822 L closepath p F P
0 g
s
.73 .599 .71 r
.49022 .60944 m .5044 .55191 L .46091 .57257 L closepath p F P
0 g
s
.739 .623 .729 r
.4758 .51987 m .46091 .57257 L .5044 .55191 L closepath p F P
0 g
s
.702 .596 .734 r
.5044 .55191 m .56319 .5447 L .52996 .51127 L closepath p F P
0 g
s
.721 .621 .746 r
.52996 .51127 m .4758 .51987 L .5044 .55191 L closepath p F P
0 g
s
.739 .574 .67 r
.47737 .66631 m .49022 .60944 L .44774 .62785 L closepath p F P
0 g
s
.728 .563 .668 r
.49022 .60944 m .47737 .66631 L .52312 .64883 L closepath p F P
0 g
s
.749 .601 .693 r
.46091 .57257 m .44774 .62785 L .49022 .60944 L closepath p F P
0 g
s
.661 .567 .738 r
.56319 .5447 m .62099 .53896 L .58633 .50487 L closepath p F P
0 g
s
.683 .595 .751 r
.58633 .50487 m .52996 .51127 L .56319 .5447 L closepath p F P
0 g
s
.66 .557 .727 r
.62099 .53896 m .56319 .5447 L .59831 .58217 L closepath p F P
0 g
s
.686 .52 .656 r
.57577 .67984 m .52312 .64883 L .572 .62822 L closepath p F P
0 g
s
.654 .517 .684 r
.62253 .63842 m .59831 .58217 L .572 .62822 L closepath p F P
0 g
s
.659 .5 .657 r
.57577 .67984 m .62253 .63842 L .572 .62822 L closepath p F P
0 g
s
.692 .516 .644 r
.52312 .64883 m .57577 .67984 L .52738 .69828 L closepath p F P
0 g
s
.717 .535 .642 r
.52738 .69828 m .47737 .66631 L .52312 .64883 L closepath p F P
0 g
s
.757 .609 .695 r
.44774 .62785 m .46091 .57257 L .42251 .59177 L closepath p F P
0 g
s
.748 .632 .731 r
.46091 .57257 m .4758 .51987 L .43646 .54034 L closepath p F P
0 g
s
.766 .635 .715 r
.43646 .54034 m .42251 .59177 L .46091 .57257 L closepath p F P
0 g
s
.641 .511 .688 r
.59831 .58217 m .62253 .63842 L .64663 .59263 L closepath p F P
0 g
s
.636 .526 .713 r
.64663 .59263 m .62099 .53896 L .59831 .58217 L closepath p F P
0 g
s
.722 .629 .754 r
.4758 .51987 m .52996 .51127 L .50065 .48333 L closepath p F P
0 g
s
.684 .602 .759 r
.52996 .51127 m .58633 .50487 L .55337 .47558 L closepath p F P
0 g
s
.703 .629 .771 r
.55337 .47558 m .50065 .48333 L .52996 .51127 L closepath p F P
0 g
s
.756 .653 .748 r
.45208 .49341 m .43646 .54034 L .4758 .51987 L closepath p F P
0 g
s
.737 .652 .764 r
.50065 .48333 m .45208 .49341 L .4758 .51987 L closepath p F P
0 g
s
.764 .585 .655 r
.43764 .68002 m .44774 .62785 L .41175 .64323 L closepath p F P
0 g
s
.756 .576 .653 r
.44774 .62785 m .43764 .68002 L .47737 .66631 L closepath p F P
0 g
s
.775 .612 .678 r
.42251 .59177 m .41175 .64323 L .44774 .62785 L closepath p F P
0 g
s
.722 .531 .631 r
.47737 .66631 m .52738 .69828 L .48264 .71231 L closepath p F P
0 g
s
.745 .547 .627 r
.48264 .71231 m .43764 .68002 L .47737 .66631 L closepath p F P
0 g
s
.642 .573 .762 r
.58633 .50487 m .63909 .50134 L .6056 .47119 L closepath p F P
0 g
s
.665 .602 .775 r
.6056 .47119 m .55337 .47558 L .58633 .50487 L closepath p F P
0 g
s
.642 .565 .753 r
.63909 .50134 m .58633 .50487 L .62099 .53896 L closepath p F P
0 g
s
.782 .669 .739 r
.41668 .50268 m .39935 .55525 L .43646 .54034 L closepath p F P
0 g
s
.764 .663 .75 r
.43646 .54034 m .45208 .49341 L .41668 .50268 L closepath p F P
0 g
s
.774 .643 .717 r
.42251 .59177 m .43646 .54034 L .39935 .55525 L closepath p F P
0 g
s
.725 .664 .79 r
.46525 .45951 m .51958 .44843 L .50065 .48333 L closepath p F P
0 g
s
.738 .661 .773 r
.50065 .48333 m .45208 .49341 L .46525 .45951 L closepath p F P
0 g
s
.703 .636 .779 r
.55337 .47558 m .50065 .48333 L .51958 .44843 L closepath p F P
0 g
s
.793 .647 .7 r
.39935 .55525 m .38585 .61105 L .42251 .59177 L closepath p F P
0 g
s
.783 .621 .679 r
.41175 .64323 m .42251 .59177 L .38585 .61105 L closepath p F P
0 g
s
.623 .521 .717 r
.62099 .53896 m .64663 .59263 L .66576 .55001 L closepath p F P
0 g
s
.616 .534 .739 r
.66576 .55001 m .63909 .50134 L .62099 .53896 L closepath p F P
0 g
s
.679 .485 .616 r
.57794 .72607 m .52738 .69828 L .57577 .67984 L closepath p F P
0 g
s
.648 .482 .645 r
.62253 .63842 m .57577 .67984 L .62479 .6884 L closepath p F P
0 g
s
.651 .463 .616 r
.57794 .72607 m .62479 .6884 L .57577 .67984 L closepath p F P
0 g
s
.614 .478 .673 r
.66777 .64653 m .64663 .59263 L .62253 .63842 L closepath p F P
0 g
s
.618 .459 .644 r
.62479 .6884 m .66777 .64653 L .62253 .63842 L closepath p F P
0 g
s
.684 .637 .797 r
.51958 .44843 m .57652 .44172 L .55337 .47558 L closepath p F P
0 g
s
.664 .61 .783 r
.6056 .47119 m .55337 .47558 L .57652 .44172 L closepath p F P
0 g
s
.684 .48 .604 r
.52738 .69828 m .57794 .72607 L .53134 .74149 L closepath p F P
0 g
s
.711 .5 .601 r
.53134 .74149 m .48264 .71231 L .52738 .69828 L closepath p F P
0 g
s
.76 .686 .78 r
.42179 .4598 m .45208 .49341 L .46525 .45951 L closepath p F P
0 g
s
.768 .687 .773 r
.45208 .49341 m .42179 .4598 L .41668 .50268 L closepath p F P
0 g
s
.601 .471 .676 r
.64663 .59263 m .66777 .64653 L .68866 .60217 L closepath p F P
0 g
s
.594 .488 .702 r
.68866 .60217 m .66576 .55001 L .64663 .59263 L closepath p F P
0 g
s
.801 .621 .658 r
.38585 .61105 m .37762 .66427 L .41175 .64323 L closepath p F P
0 g
s
.79 .596 .639 r
.40486 .69021 m .41175 .64323 L .37762 .66427 L closepath p F P
0 g
s
.78 .587 .639 r
.41175 .64323 m .40486 .69021 L .43764 .68002 L closepath p F P
0 g
s
.811 .684 .725 r
.37679 .5153 m .35927 .57323 L .39935 .55525 L closepath p F P
0 g
s
.791 .679 .741 r
.39935 .55525 m .41668 .50268 L .37679 .5153 L closepath p F P
0 g
s
.802 .656 .701 r
.38585 .61105 m .39935 .55525 L .35927 .57323 L closepath p F P
0 g
s
.75 .544 .617 r
.43764 .68002 m .48264 .71231 L .44398 .72205 L closepath p F P
0 g
s
.77 .558 .611 r
.44398 .72205 m .40486 .69021 L .43764 .68002 L closepath p F P
0 g
s
.707 .675 .817 r
.48215 .42163 m .54176 .41107 L .51958 .44843 L closepath p F P
0 g
s
.725 .673 .799 r
.51958 .44843 m .46525 .45951 L .48215 .42163 L closepath p F P
0 g
s
.684 .645 .805 r
.57652 .44172 m .51958 .44843 L .54176 .41107 L closepath p F P
0 g
s
.715 .496 .591 r
.48264 .71231 m .53134 .74149 L .48853 .75197 L closepath p F P
0 g
s
.739 .513 .586 r
.48853 .75197 m .44398 .72205 L .48264 .71231 L closepath p F P
0 g
s
.789 .706 .773 r
.38283 .46786 m .41668 .50268 L .42179 .4598 L closepath p F P
0 g
s
.796 .706 .765 r
.41668 .50268 m .38283 .46786 L .37679 .5153 L closepath p F P
0 g
s
.64 .606 .8 r
.57652 .44172 m .63014 .44013 L .6056 .47119 L closepath p F P
0 g
s
.622 .58 .786 r
.6528 .47026 m .6056 .47119 L .63014 .44013 L closepath p F P
0 g
s
.623 .572 .776 r
.6528 .47026 m .6056 .47119 L .63909 .50134 L closepath p F P
0 g
s
.757 .703 .801 r
.46525 .45951 m .43403 .42232 L .42179 .4598 L closepath p F P
0 g
s
.749 .702 .807 r
.43403 .42232 m .46525 .45951 L .48215 .42163 L closepath p F P
0 g
s
.605 .53 .743 r
.63909 .50134 m .66576 .55001 L .67981 .51299 L closepath p F P
0 g
s
.596 .541 .763 r
.67981 .51299 m .6528 .47026 L .63909 .50134 L closepath p F P
0 g
s
.822 .658 .68 r
.35927 .57323 m .34835 .63194 L .38585 .61105 L closepath p F P
0 g
s
.81 .63 .658 r
.37762 .66427 m .38585 .61105 L .34835 .63194 L closepath p F P
0 g
s
.584 .482 .705 r
.66576 .55001 m .68866 .60217 L .70406 .56105 L closepath p F P
0 g
s
.574 .496 .729 r
.70406 .56105 m .67981 .51299 L .66576 .55001 L closepath p F P
0 g
s
.607 .442 .633 r
.66777 .64653 m .62479 .6884 L .66803 .69363 L closepath p F P
0 g
s
.64 .446 .604 r
.62479 .6884 m .57794 .72607 L .6243 .73233 L closepath p F P
0 g
s
.608 .419 .601 r
.6243 .73233 m .66803 .69363 L .62479 .6884 L closepath p F P
0 g
s
.659 .643 .823 r
.54176 .41107 m .60122 .40736 L .57652 .44172 L closepath p F P
0 g
s
.638 .614 .809 r
.63014 .44013 m .57652 .44172 L .60122 .40736 L closepath p F P
0 g
s
.671 .447 .573 r
.5787 .76444 m .53134 .74149 L .57794 .72607 L closepath p F P
0 g
s
.64 .423 .572 r
.5787 .76444 m .6243 .73233 L .57794 .72607 L closepath p F P
0 g
s
.571 .437 .659 r
.70532 .65239 m .68866 .60217 L .66777 .64653 L closepath p F P
0 g
s
.574 .416 .629 r
.66803 .69363 m .70532 .65239 L .66777 .64653 L closepath p F P
0 g
s
.674 .442 .561 r
.53134 .74149 m .5787 .76444 L .53477 .77679 L closepath p F P
0 g
s
.703 .463 .558 r
.53477 .77679 m .48853 .75197 L .53134 .74149 L closepath p F P
0 g
s
.77 .53 .571 r
.40184 .72414 m .44609 .75883 L .44398 .72205 L closepath p F P
0 g
s
.776 .555 .6 r
.44398 .72205 m .40486 .69021 L .40184 .72414 L closepath p F P
0 g
s
.743 .509 .575 r
.48853 .75197 m .44398 .72205 L .44609 .75883 L closepath p F P
0 g
s
.805 .591 .612 r
.3633 .70143 m .40486 .69021 L .37762 .66427 L closepath p F P
0 g
s
.801 .578 .6 r
.40486 .69021 m .3633 .70143 L .40184 .72414 L closepath p F P
0 g
s
.782 .731 .805 r
.39177 .42672 m .42179 .4598 L .43403 .42232 L closepath p F P
0 g
s
.79 .731 .799 r
.42179 .4598 m .39177 .42672 L .38283 .46786 L closepath p F P
0 g
s
.558 .429 .661 r
.68866 .60217 m .70532 .65239 L .72284 .61031 L closepath p F P
0 g
s
.551 .446 .689 r
.72284 .61031 m .70406 .56105 L .68866 .60217 L closepath p F P
0 g
s
.82 .728 .764 r
.34095 .48002 m .37679 .5153 L .38283 .46786 L closepath p F P
0 g
s
.829 .727 .753 r
.37679 .5153 m .34095 .48002 L .33471 .53167 L closepath p F P
0 g
s
.822 .697 .727 r
.35927 .57323 m .37679 .5153 L .33471 .53167 L closepath p F P
0 g
s
.844 .701 .705 r
.33471 .53167 m .3195 .59356 L .35927 .57323 L closepath p F P
0 g
s
.834 .67 .68 r
.34835 .63194 m .35927 .57323 L .3195 .59356 L closepath p F P
0 g
s
.706 .687 .829 r
.54176 .41107 m .48215 .42163 L .50284 .38217 L closepath p F P
0 g
s
.743 .722 .832 r
.48215 .42163 m .45052 .38254 L .43403 .42232 L closepath p F P
0 g
s
.731 .719 .839 r
.45052 .38254 m .48215 .42163 L .50284 .38217 L closepath p F P
0 g
s
.554 .508 .758 r
.71571 .51991 m .68656 .47163 L .67981 .51299 L closepath p F P
0 g
s
.563 .49 .732 r
.67981 .51299 m .70406 .56105 L .71571 .51991 L closepath p F P
0 g
s
.584 .536 .767 r
.6528 .47026 m .67981 .51299 L .68656 .47163 L closepath p F P
0 g
s
.826 .615 .618 r
.37762 .66427 m .33264 .67349 L .3633 .70143 L closepath p F P
0 g
s
.829 .627 .63 r
.33264 .67349 m .37762 .66427 L .34835 .63194 L closepath p F P
0 g
s
.591 .57 .799 r
.6528 .47026 m .66835 .43075 L .63014 .44013 L closepath p F P
0 g
s
.579 .557 .793 r
.66835 .43075 m .6528 .47026 L .68656 .47163 L closepath p F P
0 g
s
.732 .475 .539 r
.44609 .75883 m .4954 .78877 L .48853 .75197 L closepath p F P
0 g
s
.706 .457 .546 r
.53477 .77679 m .48853 .75197 L .4954 .78877 L closepath p F P
0 g
s
.681 .687 .85 r
.50284 .38217 m .56605 .37444 L .54176 .41107 L closepath p F P
0 g
s
.657 .654 .836 r
.60122 .40736 m .54176 .41107 L .56605 .37444 L closepath p F P
0 g
s
.594 .593 .82 r
.64394 .39709 m .63014 .44013 L .66835 .43075 L closepath p F P
0 g
s
.606 .606 .825 r
.63014 .44013 m .64394 .39709 L .60122 .40736 L closepath p F P
0 g
s
.598 .404 .59 r
.66803 .69363 m .6243 .73233 L .66496 .73465 L closepath p F P
0 g
s
.631 .407 .56 r
.6243 .73233 m .5787 .76444 L .62179 .76842 L closepath p F P
0 g
s
.595 .377 .554 r
.62179 .76842 m .66496 .73465 L .6243 .73233 L closepath p F P
0 g
s
.526 .453 .716 r
.73929 .57283 m .71571 .51991 L .70406 .56105 L closepath p F P
0 g
s
.537 .439 .691 r
.70406 .56105 m .72284 .61031 L .73929 .57283 L closepath p F P
0 g
s
.562 .399 .618 r
.70532 .65239 m .66803 .69363 L .70369 .69597 L closepath p F P
0 g
s
.562 .373 .583 r
.66496 .73465 m .70369 .69597 L .66803 .69363 L closepath p F P
0 g
s
.815 .757 .798 r
.35177 .43473 m .38283 .46786 L .39177 .42672 L closepath p F P
0 g
s
.823 .757 .791 r
.38283 .46786 m .35177 .43473 L .34095 .48002 L closepath p F P
0 g
s
.852 .655 .636 r
.34835 .63194 m .30183 .63891 L .33264 .67349 L closepath p F P
0 g
s
.855 .669 .651 r
.30183 .63891 m .34835 .63194 L .3195 .59356 L closepath p F P
0 g
s
.778 .754 .831 r
.43403 .42232 m .40391 .38833 L .39177 .42672 L closepath p F P
0 g
s
.769 .753 .838 r
.40391 .38833 m .43403 .42232 L .45052 .38254 L closepath p F P
0 g
s
.809 .565 .568 r
.35796 .73685 m .40184 .72414 L .3633 .70143 L closepath p F P
0 g
s
.804 .551 .555 r
.40184 .72414 m .35796 .73685 L .40074 .76197 L closepath p F P
0 g
s
.776 .526 .558 r
.44609 .75883 m .40184 .72414 L .40074 .76197 L closepath p F P
0 g
s
.661 .408 .528 r
.57845 .7947 m .53477 .77679 L .5787 .76444 L closepath p F P
0 g
s
.628 .382 .526 r
.57845 .7947 m .62179 .76842 L .5787 .76444 L closepath p F P
0 g
s
.609 .633 .85 r
.61279 .36263 m .60122 .40736 L .64394 .39709 L closepath p F P
0 g
s
.623 .648 .854 r
.60122 .40736 m .61279 .36263 L .56605 .37444 L closepath p F P
0 g
s
.525 .393 .643 r
.7349 .65629 m .72284 .61031 L .70532 .65239 L closepath p F P
0 g
s
.528 .37 .611 r
.70369 .69597 m .7349 .65629 L .70532 .65239 L closepath p F P
0 g
s
.766 .491 .518 r
.40074 .76197 m .4505 .79769 L .44609 .75883 L closepath p F P
0 g
s
.736 .469 .525 r
.4954 .78877 m .44609 .75883 L .4505 .79769 L closepath p F P
0 g
s
.687 .414 .504 r
.4954 .78877 m .54462 .81069 L .53477 .77679 L closepath p F P
0 g
s
.663 .4 .512 r
.57845 .7947 m .53477 .77679 L .54462 .81069 L closepath p F P
0 g
s
.539 .502 .762 r
.68656 .47163 m .71571 .51991 L .72382 .47556 L closepath p F P
0 g
s
.545 .538 .798 r
.68656 .47163 m .70373 .43012 L .66835 .43075 L closepath p F P
0 g
s
.532 .523 .792 r
.70373 .43012 m .68656 .47163 L .72382 .47556 L closepath p F P
0 g
s
.496 .392 .667 r
.75469 .62481 m .73929 .57283 L .72284 .61031 L closepath p F P
0 g
s
.508 .383 .644 r
.72284 .61031 m .7349 .65629 L .75469 .62481 L closepath p F P
0 g
s
.858 .754 .748 r
.2997 .49667 m .33471 .53167 L .34095 .48002 L closepath p F P
0 g
s
.868 .752 .732 r
.33471 .53167 m .2997 .49667 L .2945 .5513 L closepath p F P
0 g
s
.859 .717 .705 r
.3195 .59356 m .33471 .53167 L .2945 .5513 L closepath p F P
0 g
s
.499 .463 .748 r
.7532 .52958 m .72382 .47556 L .71571 .51991 L closepath p F P
0 g
s
.511 .445 .719 r
.71571 .51991 m .73929 .57283 L .7532 .52958 L closepath p F P
0 g
s
.841 .605 .581 r
.32259 .71008 m .3633 .70143 L .33264 .67349 L closepath p F P
0 g
s
.838 .593 .569 r
.3633 .70143 m .32259 .71008 L .35796 .73685 L closepath p F P
0 g
s
.678 .702 .864 r
.56605 .37444 m .50284 .38217 L .52637 .34508 L closepath p F P
0 g
s
.721 .743 .869 r
.50284 .38217 m .4712 .34406 L .45052 .38254 L closepath p F P
0 g
s
.704 .738 .877 r
.4712 .34406 m .50284 .38217 L .52637 .34508 L closepath p F P
0 g
s
.543 .322 .53 r
.65871 .77315 m .70341 .73362 L .66496 .73465 L closepath p F P
0 g
s
.584 .359 .541 r
.66496 .73465 m .62179 .76842 L .65871 .77315 L closepath p F P
0 g
s
.549 .355 .571 r
.70369 .69597 m .66496 .73465 L .70341 .73362 L closepath p F P
0 g
s
.805 .784 .833 r
.36514 .39766 m .39177 .42672 L .40391 .38833 L closepath p F P
0 g
s
.813 .784 .826 r
.39177 .42672 m .36514 .39766 L .35177 .43473 L closepath p F P
0 g
s
.881 .704 .657 r
.3195 .59356 m .27433 .59889 L .30183 .63891 L closepath p F P
0 g
s
.883 .72 .674 r
.27433 .59889 m .3195 .59356 L .2945 .5513 L closepath p F P
0 g
s
.718 .423 .477 r
.4505 .79769 m .50398 .82502 L .4954 .78877 L closepath p F P
0 g
s
.69 .405 .487 r
.54462 .81069 m .4954 .78877 L .50398 .82502 L closepath p F P
0 g
s
.582 .328 .496 r
.61091 .80446 m .65871 .77315 L .62179 .76842 L closepath p F P
0 g
s
.616 .362 .509 r
.62179 .76842 m .57845 .7947 L .61091 .80446 L closepath p F P
0 g
s
.553 .577 .833 r
.66835 .43075 m .68101 .39195 L .64394 .39709 L closepath p F P
0 g
s
.54 .564 .828 r
.68101 .39195 m .66835 .43075 L .70373 .43012 L closepath p F P
0 g
s
.503 .319 .563 r
.70341 .73362 m .74022 .69011 L .70369 .69597 L closepath p F P
0 g
s
.512 .35 .598 r
.7349 .65629 m .70369 .69597 L .74022 .69011 L closepath p F P
0 g
s
.852 .788 .788 r
.31139 .44765 m .34095 .48002 L .35177 .43473 L closepath p F P
0 g
s
.862 .788 .776 r
.34095 .48002 m .31139 .44765 L .2997 .49667 L closepath p F P
0 g
s
.625 .681 .883 r
.57563 .331 m .56605 .37444 L .61279 .36263 L closepath p F P
0 g
s
.642 .699 .887 r
.56605 .37444 m .57563 .331 L .52637 .34508 L closepath p F P
0 g
s
.462 .394 .695 r
.77355 .58644 m .7532 .52958 L .73929 .57283 L closepath p F P
0 g
s
.477 .381 .668 r
.73929 .57283 m .75469 .62481 L .77355 .58644 L closepath p F P
0 g
s
.868 .636 .585 r
.33264 .67349 m .29137 .68005 L .32259 .71008 L closepath p F P
0 g
s
.871 .648 .598 r
.29137 .68005 m .33264 .67349 L .30183 .63891 L closepath p F P
0 g
s
.762 .781 .868 r
.45052 .38254 m .4208 .35025 L .40391 .38833 L closepath p F P
0 g
s
.748 .778 .878 r
.4208 .35025 m .45052 .38254 L .4712 .34406 L closepath p F P
0 g
s
.634 .347 .465 r
.57679 .83086 m .57845 .7947 L .54462 .81069 L closepath p F P
0 g
s
.62 .335 .464 r
.57845 .7947 m .57679 .83086 L .61091 .80446 L closepath p F P
0 g
s
.813 .53 .51 r
.35583 .77467 m .40074 .76197 L .35796 .73685 L closepath p F P
0 g
s
.804 .509 .49 r
.40074 .76197 m .35583 .77467 L .40286 .8012 L closepath p F P
0 g
s
.772 .483 .497 r
.4505 .79769 m .40074 .76197 L .40286 .8012 L closepath p F P
0 g
s
.551 .606 .861 r
.65441 .3576 m .64394 .39709 L .68101 .39195 L closepath p F P
0 g
s
.564 .62 .866 r
.64394 .39709 m .65441 .3576 L .61279 .36263 L closepath p F P
0 g
s
.462 .327 .61 r
.77022 .6598 m .7349 .65629 L .75469 .62481 L closepath p F P
0 g
s
.463 .316 .596 r
.77022 .6598 m .7349 .65629 L .74022 .69011 L closepath p F P
0 g
s
.475 .451 .752 r
.72382 .47556 m .7532 .52958 L .76189 .48308 L closepath p F P
0 g
s
.481 .495 .795 r
.72382 .47556 m .74094 .43318 L .70373 .43012 L closepath p F P
0 g
s
.462 .473 .784 r
.74094 .43318 m .72382 .47556 L .76189 .48308 L closepath p F P
0 g
s
.754 .433 .441 r
.40286 .8012 m .45774 .83496 L .4505 .79769 L closepath p F P
0 g
s
.721 .411 .453 r
.50398 .82502 m .4505 .79769 L .45774 .83496 L closepath p F P
0 g
s
.85 .574 .521 r
.31695 .74478 m .35796 .73685 L .32259 .71008 L closepath p F P
0 g
s
.844 .559 .506 r
.35796 .73685 m .31695 .74478 L .35583 .77467 L closepath p F P
0 g
s
.645 .334 .429 r
.54462 .81069 m .53996 .84801 L .57679 .83086 L closepath p F P
0 g
s
.66 .347 .432 r
.53996 .84801 m .54462 .81069 L .50398 .82502 L closepath p F P
0 g
s
.842 .819 .826 r
.32705 .407 m .35177 .43473 L .36514 .39766 L closepath p F P
0 g
s
.852 .819 .816 r
.35177 .43473 m .32705 .407 L .31139 .44765 L closepath p F P
0 g
s
.8 .816 .864 r
.40391 .38833 m .37823 .36143 L .36514 .39766 L closepath p F P
0 g
s
.789 .814 .872 r
.37823 .36143 m .40391 .38833 L .4208 .35025 L closepath p F P
0 g
s
.901 .683 .598 r
.30183 .63891 m .26267 .64387 L .29137 .68005 L closepath p F P
0 g
s
.904 .7 .616 r
.26267 .64387 m .30183 .63891 L .27433 .59889 L closepath p F P
0 g
s
.52 .259 .459 r
.64816 .81157 m .69871 .77401 L .65871 .77315 L closepath p F P
0 g
s
.567 .304 .477 r
.65871 .77315 m .61091 .80446 L .64816 .81157 L closepath p F P
0 g
s
.528 .3 .513 r
.70341 .73362 m .65871 .77315 L .69871 .77401 L closepath p F P
0 g
s
.422 .307 .617 r
.75469 .62481 m .79141 .6256 L .77022 .6598 L closepath p F P
0 g
s
.422 .319 .632 r
.79141 .6256 m .75469 .62481 L .77355 .58644 L closepath p F P
0 g
s
.473 .253 .499 r
.69871 .77401 m .74214 .72849 L .70341 .73362 L closepath p F P
0 g
s
.484 .294 .547 r
.74022 .69011 m .70341 .73362 L .74214 .72849 L closepath p F P
0 g
s
.417 .395 .728 r
.78856 .54208 m .76189 .48308 L .7532 .52958 L closepath p F P
0 g
s
.435 .378 .696 r
.7532 .52958 m .77355 .58644 L .78856 .54208 L closepath p F P
0 g
s
.912 .76 .68 r
.27433 .59889 m .26142 .53809 L .2945 .5513 L closepath p F P
0 g
s
.901 .782 .72 r
.2997 .49667 m .26142 .53809 L .2945 .5513 L closepath p F P
0 g
s
.487 .538 .835 r
.70373 .43012 m .71556 .39107 L .68101 .39195 L closepath p F P
0 g
s
.471 .521 .828 r
.71556 .39107 m .70373 .43012 L .74094 .43318 L closepath p F P
0 g
s
.582 .281 .422 r
.61039 .84156 m .61091 .80446 L .57679 .83086 L closepath p F P
0 g
s
.566 .267 .421 r
.61091 .80446 m .61039 .84156 L .64816 .81157 L closepath p F P
0 g
s
.559 .652 .898 r
.62124 .32519 m .61279 .36263 L .65441 .3576 L closepath p F P
0 g
s
.577 .671 .903 r
.61279 .36263 m .62124 .32519 L .57563 .331 L closepath p F P
0 g
s
.686 .764 .911 r
.51611 .31147 m .4712 .34406 L .52637 .34508 L closepath p F P
0 g
s
.642 .737 .918 r
.57563 .331 m .51611 .31147 L .52637 .34508 L closepath p F P
0 g
s
.424 .261 .554 r
.74022 .69011 m .77616 .69502 L .77022 .6598 L closepath p F P
0 g
s
.425 .25 .538 r
.77616 .69502 m .74022 .69011 L .74214 .72849 L closepath p F P
0 g
s
.884 .621 .536 r
.28712 .71483 m .32259 .71008 L .29137 .68005 L closepath p F P
0 g
s
.879 .606 .52 r
.32259 .71008 m .28712 .71483 L .31695 .74478 L closepath p F P
0 g
s
.672 .328 .382 r
.50398 .82502 m .49671 .86136 L .53996 .84801 L closepath p F P
0 g
s
.691 .346 .386 r
.49671 .86136 m .50398 .82502 L .45774 .83496 L closepath p F P
0 g
s
.91 .805 .73 r
.26142 .53809 m .2997 .49667 L .26954 .48443 L closepath p F P
0 g
s
.895 .823 .768 r
.31139 .44765 m .26954 .48443 L .2997 .49667 L closepath p F P
0 g
s
.694 .787 .922 r
.4712 .34406 m .51611 .31147 L .46154 .3135 L closepath p F P
0 g
s
.734 .81 .912 r
.46154 .3135 m .4208 .35025 L .4712 .34406 L closepath p F P
0 g
s
.825 .845 .862 r
.34416 .37505 m .36514 .39766 L .37823 .36143 L closepath p F P
0 g
s
.837 .846 .852 r
.36514 .39766 m .34416 .37505 L .32705 .407 L closepath p F P
0 g
s
.495 .583 .872 r
.68101 .39195 m .68897 .35803 L .65441 .3576 L closepath p F P
0 g
s
.48 .567 .866 r
.68897 .35803 m .68101 .39195 L .71556 .39107 L closepath p F P
0 g
s
.366 .291 .638 r
.77355 .58644 m .80945 .58466 L .79141 .6256 L closepath p F P
0 g
s
.367 .307 .657 r
.80945 .58466 m .77355 .58644 L .78856 .54208 L closepath p F P
0 g
s
.809 .474 .422 r
.35864 .81145 m .40286 .8012 L .35583 .77467 L closepath p F P
0 g
s
.795 .443 .391 r
.40286 .8012 m .35864 .81145 L .40924 .83768 L closepath p F P
0 g
s
.759 .417 .406 r
.45774 .83496 m .40286 .8012 L .40924 .83768 L closepath p F P
0 g
s
.929 .768 .661 r
.26142 .53809 m .27433 .59889 L .24416 .58589 L closepath p F P
0 g
s
.936 .74 .613 r
.26267 .64387 m .24416 .58589 L .27433 .59889 L closepath p F P
0 g
s
.601 .259 .362 r
.57331 .86306 m .57679 .83086 L .53996 .84801 L closepath p F P
0 g
s
.585 .245 .36 r
.57679 .83086 m .57331 .86306 L .61039 .84156 L closepath p F P
0 g
s
.916 .655 .529 r
.29137 .68005 m .2586 .68308 L .28712 .71483 L closepath p F P
0 g
s
.92 .671 .546 r
.2586 .68308 m .29137 .68005 L .26267 .64387 L closepath p F P
0 g
s
.901 .844 .778 r
.26954 .48443 m .31139 .44765 L .28428 .43737 L closepath p F P
0 g
s
.883 .859 .812 r
.32705 .407 m .28428 .43737 L .31139 .44765 L closepath p F P
0 g
s
.356 .228 .565 r
.80162 .66122 m .77022 .6598 L .79141 .6256 L closepath p F P
0 g
s
.356 .216 .549 r
.80162 .66122 m .77022 .6598 L .77616 .69502 L closepath p F P
0 g
s
.742 .831 .919 r
.4208 .35025 m .46154 .3135 L .41274 .32296 L closepath p F P
0 g
s
.779 .851 .905 r
.41274 .32296 m .37823 .36143 L .4208 .35025 L closepath p F P
0 g
s
.378 .374 .728 r
.76189 .48308 m .78856 .54208 L .79648 .4947 L closepath p F P
0 g
s
.385 .428 .782 r
.76189 .48308 m .77633 .44122 L .74094 .43318 L closepath p F P
0 g
s
.354 .394 .764 r
.77633 .44122 m .76189 .48308 L .79648 .4947 L closepath p F P
0 g
s
.855 .53 .436 r
.31618 .7798 m .35583 .77467 L .31695 .74478 L closepath p F P
0 g
s
.844 .504 .409 r
.35583 .77467 m .31618 .7798 L .35864 .81145 L closepath p F P
0 g
s
.425 .157 .402 r
.68819 .81355 m .73841 .76917 L .69871 .77401 L closepath p F P
0 g
s
.494 .221 .428 r
.69871 .77401 m .64816 .81157 L .68819 .81355 L closepath p F P
0 g
s
.443 .214 .47 r
.74214 .72849 m .69871 .77401 L .73841 .76917 L closepath p F P
0 g
s
.619 .742 .934 r
.51611 .31147 m .57563 .331 L .56522 .30032 L closepath p F P
0 g
s
.566 .707 .937 r
.62124 .32519 m .56522 .30032 L .57563 .331 L closepath p F P
0 g
s
.508 .187 .358 r
.64778 .84762 m .64816 .81157 L .61039 .84156 L closepath p F P
0 g
s
.483 .167 .355 r
.64816 .81157 m .64778 .84762 L .68819 .81355 L closepath p F P
0 g
s
.48 .614 .906 r
.6602 .32628 m .65441 .3576 L .68897 .35803 L closepath p F P
0 g
s
.499 .632 .912 r
.65441 .3576 m .6602 .32628 L .62124 .32519 L closepath p F P
0 g
s
.366 .168 .474 r
.74214 .72849 m .7768 .73361 L .77616 .69502 L closepath p F P
0 g
s
.367 .152 .45 r
.7768 .73361 m .74214 .72849 L .73841 .76917 L closepath p F P
0 g
s
.703 .319 .317 r
.45774 .83496 m .4494 .86767 L .49671 .86136 L closepath p F P
0 g
s
.726 .342 .322 r
.4494 .86767 m .45774 .83496 L .40924 .83768 L closepath p F P
0 g
s
.391 .481 .832 r
.74094 .43318 m .74968 .39528 L .71556 .39107 L closepath p F P
0 g
s
.363 .452 .818 r
.74968 .39528 m .74094 .43318 L .77633 .44122 L closepath p F P
0 g
s
.894 .582 .449 r
.28354 .74676 m .31695 .74478 L .28712 .71483 L closepath p F P
0 g
s
.887 .561 .426 r
.31695 .74478 m .28354 .74676 L .31618 .7798 L closepath p F P
0 g
s
.606 .225 .295 r
.53996 .84801 m .53436 .87842 L .57331 .86306 L closepath p F P
0 g
s
.624 .242 .298 r
.53436 .87842 m .53996 .84801 L .49671 .86136 L closepath p F P
0 g
s
.288 .268 .662 r
.78856 .54208 m .82083 .53892 L .80945 .58466 L closepath p F P
0 g
s
.29 .289 .686 r
.82083 .53892 m .78856 .54208 L .79648 .4947 L closepath p F P
0 g
s
.885 .877 .822 r
.28428 .43737 m .32705 .407 L .30268 .39892 L closepath p F P
0 g
s
.865 .889 .851 r
.34416 .37505 m .30268 .39892 L .32705 .407 L closepath p F P
0 g
s
.787 .869 .909 r
.37823 .36143 m .41274 .32296 L .3721 .33709 L closepath p F P
0 g
s
.818 .885 .893 r
.3721 .33709 m .34416 .37505 L .37823 .36143 L closepath p F P
0 g
s
.281 .183 .562 r
.79141 .6256 m .82113 .62484 L .80162 .66122 L closepath p F P
0 g
s
.282 .198 .58 r
.82113 .62484 m .79141 .6256 L .80945 .58466 L closepath p F P
0 g
s
.958 .813 .657 r
.24416 .58589 m .23734 .52661 L .26142 .53809 L closepath p F P
0 g
s
.945 .84 .708 r
.26954 .48443 m .23734 .52661 L .26142 .53809 L closepath p F P
0 g
s
.397 .531 .874 r
.71556 .39107 m .7204 .35899 L .68897 .35803 L closepath p F P
0 g
s
.373 .507 .864 r
.7204 .35899 m .71556 .39107 L .74968 .39528 L closepath p F P
0 g
s
.95 .743 .588 r
.24416 .58589 m .26267 .64387 L .23596 .63069 L closepath p F P
0 g
s
.953 .709 .53 r
.2586 .68308 m .23596 .63069 L .26267 .64387 L closepath p F P
0 g
s
.52 .15 .278 r
.60655 .87195 m .61039 .84156 L .57331 .86306 L closepath p F P
0 g
s
.499 .132 .274 r
.61039 .84156 m .60655 .87195 L .64778 .84762 L closepath p F P
0 g
s
.662 .817 .958 r
.50642 .2871 m .46154 .3135 L .51611 .31147 L closepath p F P
0 g
s
.606 .783 .966 r
.56522 .30032 m .50642 .2871 L .51611 .31147 L closepath p F P
0 g
s
.927 .634 .465 r
.25994 .71539 m .28712 .71483 L .2586 .68308 L closepath p F P
0 g
s
.921 .613 .442 r
.28712 .71483 m .25994 .71539 L .28354 .74676 L closepath p F P
0 g
s
.277 .117 .475 r
.77616 .69502 m .8056 .69604 L .80162 .66122 L closepath p F P
0 g
s
.277 .102 .455 r
.8056 .69604 m .77616 .69502 L .7768 .73361 L closepath p F P
0 g
s
.535 .706 .949 r
.56522 .30032 m .62124 .32519 L .61027 .29789 L closepath p F P
0 g
s
.472 .664 .946 r
.6602 .32628 m .61027 .29789 L .62124 .32519 L closepath p F P
0 g
s
.952 .863 .714 r
.23734 .52661 m .26954 .48443 L .24793 .47552 L closepath p F P
0 g
s
.934 .886 .761 r
.28428 .43737 m .24793 .47552 L .26954 .48443 L closepath p F P
0 g
s
.827 .904 .893 r
.34416 .37505 m .3721 .33709 L .33137 .36151 L closepath p F P
0 g
s
.863 .907 .862 r
.30268 .39892 m .34416 .37505 L .33137 .36151 L closepath p F P
0 g
s
.665 .839 .967 r
.46154 .3135 m .50642 .2871 L .45413 .2919 L closepath p F P
0 g
s
.716 .869 .954 r
.45413 .2919 m .41274 .32296 L .46154 .3135 L closepath p F P
0 g
s
.407 .582 .912 r
.68897 .35803 m .6917 .33195 L .6602 .32628 L closepath p F P
0 g
s
.382 .558 .902 r
.6917 .33195 m .68897 .35803 L .7204 .35899 L closepath p F P
0 g
s
.624 .192 .202 r
.49671 .86136 m .49033 .88758 L .53436 .87842 L closepath p F P
0 g
s
.649 .217 .208 r
.49033 .88758 m .49671 .86136 L .4494 .86767 L closepath p F P
0 g
s
.736 .304 .224 r
.4494 .86767 m .38676 .85318 L .40924 .83768 L closepath p F P
0 g
s
.788 .381 .281 r
.35864 .81145 m .38676 .85318 L .40924 .83768 L closepath p F P
0 g
s
.386 .042 .255 r
.68613 .84617 m .68819 .81355 L .64778 .84762 L closepath p F P
0 g
s
.346 .013 .249 r
.68819 .81355 m .68613 .84617 L .72723 .8081 L closepath p F P
0 g
s
.379 .095 .352 r
.73841 .76917 m .68819 .81355 L .72723 .8081 L closepath p F P
0 g
s
.274 .026 .345 r
.73841 .76917 m .76969 .77237 L .7768 .73361 L closepath p F P
0 g
s
.273 .002 .307 r
.76969 .77237 m .73841 .76917 L .72723 .8081 L closepath p F P
0 g
s
.973 .82 .631 r
.23734 .52661 m .24416 .58589 L .22333 .57336 L closepath p F P
0 g
s
.981 .784 .566 r
.23596 .63069 m .22333 .57336 L .24416 .58589 L closepath p F P
0 g
s
.936 .904 .767 r
.24793 .47552 m .28428 .43737 L .26461 .43126 L closepath p F P
0 g
s
.913 .923 .808 r
.30268 .39892 m .26461 .43126 L .28428 .43737 L closepath p F P
0 g
s
.801 .379 .244 r
.38676 .85318 m .35864 .81145 L .33807 .82418 L closepath p F P
0 g
s
.845 .451 .297 r
.31618 .7798 m .33807 .82418 L .35864 .81145 L closepath p F P
0 g
s
.173 .132 .568 r
.80945 .58466 m .83497 .58273 L .82113 .62484 L closepath p F P
0 g
s
.175 .154 .594 r
.83497 .58273 m .80945 .58466 L .82083 .53892 L closepath p F P
0 g
s
.535 .116 .192 r
.56803 .88711 m .57331 .86306 L .53436 .87842 L closepath p F P
0 g
s
.513 .096 .187 r
.57331 .86306 m .56803 .88711 L .60655 .87195 L closepath p F P
0 g
s
.719 .887 .958 r
.41274 .32296 m .45413 .2919 L .40794 .30358 L closepath p F P
0 g
s
.764 .911 .939 r
.40794 .30358 m .3721 .33709 L .41274 .32296 L closepath p F P
0 g
s
.229 .314 .744 r
.81347 .47522 m .77633 .44122 L .79648 .4947 L closepath p F P
0 g
s
.176 .234 .684 r
.82083 .53892 m .81347 .47522 L .79648 .4947 L closepath p F P
0 g
s
.962 .705 .499 r
.23596 .63069 m .2586 .68308 L .23515 .66967 L closepath p F P
0 g
s
.959 .664 .432 r
.25994 .71539 m .23515 .66967 L .2586 .68308 L closepath p F P
0 g
s
.573 .786 .979 r
.50642 .2871 m .56522 .30032 L .55412 .27904 L closepath p F P
0 g
s
.501 .741 .981 r
.61027 .29789 m .55412 .27904 L .56522 .30032 L closepath p F P
0 g
s
.179 .066 .479 r
.82497 .66 m .80162 .66122 L .82113 .62484 L closepath p F P
0 g
s
.177 .049 .457 r
.82497 .66 m .80162 .66122 L .8056 .69604 L closepath p F P
0 g
s
.183 .304 .754 r
.77633 .44122 m .81347 .47522 L .79032 .4233 L closepath p F P
0 g
s
.235 .381 .806 r
.79032 .4233 m .74968 .39528 L .77633 .44122 L closepath p F P
0 g
s
.858 .452 .266 r
.33807 .82418 m .31618 .7798 L .2985 .79047 L closepath p F P
0 g
s
.893 .516 .314 r
.28354 .74676 m .2985 .79047 L .31618 .7798 L closepath p F P
0 g
s
.434 .655 .953 r
.61027 .29789 m .6602 .32628 L .64867 .30216 L closepath p F P
0 g
s
.359 .604 .941 r
.6917 .33195 m .64867 .30216 L .6602 .32628 L closepath p F P
0 g
s
.875 .95 .856 r
.33137 .36151 m .28771 .39017 L .30268 .39892 L closepath p F P
0 g
s
.91 .94 .814 r
.26461 .43126 m .30268 .39892 L .28771 .39017 L closepath p F P
0 g
s
.815 .945 .909 r
.36415 .32206 m .33137 .36151 L .3721 .33709 L closepath p F P
0 g
s
.767 .929 .939 r
.3721 .33709 m .40794 .30358 L .36415 .32206 L closepath p F P
0 g
s
.391 0 .145 r
.64208 .87403 m .64778 .84762 L .60655 .87195 L closepath p F P
0 g
s
.353 0 .136 r
.64778 .84762 m .64208 .87403 L .68613 .84617 L closepath p F P
0 g
s
.195 .375 .815 r
.74968 .39528 m .79032 .4233 L .76129 .37994 L closepath p F P
0 g
s
.242 .444 .858 r
.76129 .37994 m .7204 .35899 L .74968 .39528 L closepath p F P
0 g
s
.151 0 .335 r
.7768 .73361 m .80236 .73243 L .8056 .69604 L closepath p F P
0 g
s
.147 0 .298 r
.80236 .73243 m .7768 .73361 L .76969 .77237 L closepath p F P
0 g
s
.903 .52 .289 r
.2985 .79047 m .28354 .74676 L .26884 .7561 L closepath p F P
0 g
s
.93 .574 .33 r
.25994 .71539 m .26884 .7561 L .28354 .74676 L closepath p F P
0 g
s
.989 .784 .535 r
.22333 .57336 m .23596 .63069 L .21797 .61701 L closepath p F P
0 g
s
.989 .737 .452 r
.23515 .66967 m .21797 .61701 L .23596 .63069 L closepath p F P
0 g
s
.709 .243 .142 r
.38676 .85318 m .4494 .86767 L .42823 .8803 L closepath p F P
0 g
s
.635 .144 .069 r
.49033 .88758 m .42823 .8803 L .4494 .86767 L closepath p F P
0 g
s
.992 .861 .604 r
.22333 .57336 m .22244 .51746 L .23734 .52661 L closepath p F P
0 g
s
.978 .895 .671 r
.24793 .47552 m .22244 .51746 L .23734 .52661 L closepath p F P
0 g
s
.513 .036 .061 r
.53436 .87842 m .52839 .89791 L .56803 .88711 L closepath p F P
0 g
s
.539 .061 .068 r
.52839 .89791 m .53436 .87842 L .49033 .88758 L closepath p F P
0 g
s
.818 .963 .902 r
.33137 .36151 m .36415 .32206 L .32002 .34983 L closepath p F P
0 g
s
.865 .966 .862 r
.28771 .39017 m .33137 .36151 L .32002 .34983 L closepath p F P
0 g
s
.21 .442 .866 r
.7204 .35899 m .76129 .37994 L .7304 .3464 L closepath p F P
0 g
s
.249 .501 .899 r
.7304 .3464 m .6917 .33195 L .7204 .35899 L closepath p F P
0 g
s
.607 .864 .991 r
.498 .27213 m .45413 .2919 L .50642 .2871 L closepath p F P
0 g
s
.533 .82 .998 r
.55412 .27904 m .498 .27213 L .50642 .2871 L closepath p F P
0 g
s
.962 .651 .384 r
.25994 .71539 m .23515 .66967 L .24402 .7132 L closepath p F P
0 g
s
.939 .581 .304 r
.26884 .7561 m .25994 .71539 L .24402 .7132 L closepath p F P
0 g
s
.463 .735 .986 r
.55412 .27904 m .61027 .29789 L .59775 .27924 L closepath p F P
0 g
s
.37 .676 .976 r
.64867 .30216 m .59775 .27924 L .61027 .29789 L closepath p F P
0 g
s
.032 0 .44 r
.82113 .62484 m .83992 .62247 L .82497 .66 L closepath p F P
0 g
s
.036 0 .468 r
.83992 .62247 m .82113 .62484 L .83497 .58273 L closepath p F P
0 g
s
.086 .161 .647 r
.81347 .47522 m .82083 .53892 L .8348 .52043 L closepath p F P
0 g
s
.016 .059 .563 r
.83497 .58273 m .8348 .52043 L .82083 .53892 L closepath p F P
0 g
s
.977 .913 .667 r
.22244 .51746 m .24793 .47552 L .23458 .46985 L closepath p F P
0 g
s
.955 .942 .726 r
.26461 .43126 m .23458 .46985 L .24793 .47552 L closepath p F P
0 g
s
.392 0 .025 r
.59958 .89162 m .60655 .87195 L .56803 .88711 L closepath p F P
0 g
s
.358 0 .015 r
.60655 .87195 m .59958 .89162 L .64208 .87403 L closepath p F P
0 g
s
.599 .88 .992 r
.45413 .2919 m .498 .27213 L .44902 .27885 L closepath p F P
0 g
s
.664 .917 .976 r
.44902 .27885 m .40794 .30358 L .45413 .2919 L closepath p F P
0 g
s
.216 .502 .905 r
.6917 .33195 m .7304 .3464 L .69052 .3166 L closepath p F P
0 g
s
.303 .583 .94 r
.64867 .30216 m .6917 .33195 L .69052 .3166 L closepath p F P
0 g
s
.016 0 .319 r
.8056 .69604 m .82468 .69273 L .82497 .66 L closepath p F P
0 g
s
.01 0 .286 r
.82468 .69273 m .8056 .69604 L .80236 .73243 L closepath p F P
0 g
s
.177 0 .086 r
.73733 .82087 m .68613 .84617 L .72723 .8081 L closepath p F P
0 g
s
.121 0 .129 r
.73733 .82087 m .76969 .77237 L .72723 .8081 L closepath p F P
0 g
s
.914 .978 .77 r
.28771 .39017 m .25046 .42858 L .26461 .43126 L closepath p F P
0 g
s
.947 .956 .721 r
.23458 .46985 m .26461 .43126 L .25046 .42858 L closepath p F P
0 g
s
.997 .86 .565 r
.22244 .51746 m .22333 .57336 L .21129 .56218 L closepath p F P
0 g
s
.999 .811 .475 r
.21797 .61701 m .21129 .56218 L .22333 .57336 L closepath p F P
0 g
s
.97 .652 .302 r
.21997 .66074 m .24402 .7132 L .23515 .66967 L closepath p F P
0 g
s
.99 .726 .406 r
.23515 .66967 m .21797 .61701 L .21997 .66074 L closepath p F P
0 g
s
.684 .161 0 r
.42823 .8803 m .36919 .85975 L .38676 .85318 L closepath p F P
0 g
s
.763 .272 .06 r
.33807 .82418 m .36919 .85975 L .38676 .85318 L closepath p F P
0 g
s
.71 .961 .944 r
.40581 .29018 m .36415 .32206 L .40794 .30358 L closepath p F P
0 g
s
.656 .931 .971 r
.40794 .30358 m .44902 .27885 L .40581 .29018 L closepath p F P
0 g
s
.485 .813 1 r
.498 .27213 m .55412 .27904 L .54337 .26663 L closepath p F P
0 g
s
.384 .751 .992 r
.59775 .27924 m .54337 .26663 L .55412 .27904 L closepath p F P
0 g
s
.761 .255 0 r
.36919 .85975 m .33807 .82418 L .3238 .82937 L closepath p F P
0 g
s
.826 .356 .079 r
.2985 .79047 m .3238 .82937 L .33807 .82418 L closepath p F P
0 g
s
.588 .064 0 r
.42823 .8803 m .49033 .88758 L .4702 .89716 L closepath p F P
0 g
s
.487 0 0 r
.52839 .89791 m .4702 .89716 L .49033 .88758 L closepath p F P
0 g
s
.397 0 0 r
.56152 .90097 m .56803 .88711 L .52839 .89791 L closepath p F P
0 g
s
.36 0 0 r
.56803 .88711 m .56152 .90097 L .59958 .89162 L closepath p F P
0 g
s
.199 .568 .938 r
.69052 .3166 m .64055 .28686 L .64867 .30216 L closepath p F P
0 g
s
.314 .657 .972 r
.59775 .27924 m .64867 .30216 L .64055 .28686 L closepath p F P
0 g
s
0 .168 .691 r
.82092 .4596 m .79032 .4233 L .81347 .47522 L closepath p F P
0 g
s
0 .051 .6 r
.8348 .52043 m .82092 .4596 L .81347 .47522 L closepath p F P
0 g
s
.846 .998 .814 r
.32002 .34983 m .27615 .38482 L .28771 .39017 L closepath p F P
0 g
s
.896 .988 .762 r
.25046 .42858 m .28771 .39017 L .27615 .38482 L closepath p F P
0 g
s
.105 0 0 r
.68613 .84617 m .73733 .82087 L .69411 .85635 L closepath p F P
0 g
s
.163 0 0 r
.69411 .85635 m .64208 .87403 L .68613 .84617 L closepath p F P
0 g
s
.759 .99 .888 r
.35896 .31103 m .32002 .34983 L .36415 .32206 L closepath p F P
0 g
s
.699 .971 .928 r
.36415 .32206 m .40581 .29018 L .35896 .31103 L closepath p F P
0 g
s
.824 .346 .034 r
.3238 .82937 m .2985 .79047 L .28752 .7953 L closepath p F P
0 g
s
.874 .434 .102 r
.26884 .7561 m .28752 .7953 L .2985 .79047 L closepath p F P
0 g
s
.007 0 .048 r
.76969 .77237 m .73733 .82087 L .77747 .78272 L closepath p F P
0 g
s
0 0 .093 r
.77747 .78272 m .80236 .73243 L .76969 .77237 L closepath p F P
0 g
s
0 0 .308 r
.83829 .65635 m .82497 .66 L .83992 .62247 L closepath p F P
0 g
s
0 0 .271 r
.83829 .65635 m .82497 .66 L .82468 .69273 L closepath p F P
0 g
s
0 0 .502 r
.8348 .52043 m .83497 .58273 L .8458 .56489 L closepath p F P
0 g
s
0 0 .391 r
.83992 .62247 m .8458 .56489 L .83497 .58273 L closepath p F P
0 g
s
0 .141 .681 r
.79032 .4233 m .82092 .4596 L .79601 .41076 L closepath p F P
0 g
s
0 .249 .759 r
.79601 .41076 m .76129 .37994 L .79032 .4233 L closepath p F P
0 g
s
.919 .525 .154 r
.24402 .7132 m .25696 .75592 L .26884 .7561 L closepath p F P
0 g
s
.869 .426 .059 r
.28752 .7953 m .26884 .7561 L .25696 .75592 L closepath p F P
0 g
s
.971 .723 .298 r
.20679 .60195 m .21997 .66074 L .21797 .61701 L closepath p F P
0 g
s
.993 .797 .42 r
.21797 .61701 m .21129 .56218 L .20679 .60195 L closepath p F P
0 g
s
.955 .621 .227 r
.24402 .7132 m .21997 .66074 L .23088 .70763 L closepath p F P
0 g
s
.911 .52 .11 r
.25696 .75592 m .24402 .7132 L .23088 .70763 L closepath p F P
0 g
s
0 .231 .75 r
.76129 .37994 m .79601 .41076 L .76629 .37058 L closepath p F P
0 g
s
0 .325 .812 r
.76629 .37058 m .7304 .3464 L .76129 .37994 L closepath p F P
0 g
s
.977 .872 .495 r
.21129 .56218 m .21503 .51062 L .22244 .51746 L closepath p F P
0 g
s
.967 .919 .582 r
.23458 .46985 m .21503 .51062 L .22244 .51746 L closepath p F P
0 g
s
.737 .992 .846 r
.32002 .34983 m .35896 .31103 L .31263 .34285 L closepath p F P
0 g
s
.8 .998 .794 r
.27615 .38482 m .32002 .34983 L .31263 .34285 L closepath p F P
0 g
s
.181 .634 .94 r
.64055 .28686 m .58296 .2673 L .59775 .27924 L closepath p F P
0 g
s
.319 .728 .978 r
.54337 .26663 m .59775 .27924 L .58296 .2673 L closepath p F P
0 g
s
.495 .874 .975 r
.49109 .26481 m .44902 .27885 L .498 .27213 L closepath p F P
0 g
s
.397 .814 .974 r
.54337 .26663 m .49109 .26481 L .498 .27213 L closepath p F P
0 g
s
.626 .07 0 r
.36919 .85975 m .42823 .8803 L .41077 .88365 L closepath p F P
0 g
s
.508 0 0 r
.4702 .89716 m .41077 .88365 L .42823 .8803 L closepath p F P
0 g
s
.038 .42 .864 r
.73057 .33548 m .69052 .3166 L .7304 .3464 L closepath p F P
0 g
s
0 .31 .8 r
.7304 .3464 m .76629 .37058 L .73057 .33548 L closepath p F P
0 g
s
.094 0 0 r
.64208 .87403 m .69411 .85635 L .64883 .8813 L closepath p F P
0 g
s
.148 0 0 r
.64883 .8813 m .59958 .89162 L .64208 .87403 L closepath p F P
0 g
s
.909 .948 .598 r
.25046 .42858 m .22425 .47271 L .23458 .46985 L closepath p F P
0 g
s
.942 .922 .555 r
.21503 .51062 m .23458 .46985 L .22425 .47271 L closepath p F P
0 g
s
0 .407 .85 r
.69052 .3166 m .73057 .33548 L .68539 .30383 L closepath p F P
0 g
s
.111 .525 .912 r
.64055 .28686 m .69052 .3166 L .68539 .30383 L closepath p F P
0 g
s
0 0 .013 r
.80236 .73243 m .77747 .78272 L .80747 .74117 L closepath p F P
0 g
s
0 0 .055 r
.80747 .74117 m .82468 .69273 L .80236 .73243 L closepath p F P
0 g
s
.511 .907 .925 r
.4519 .26995 m .40581 .29018 L .44902 .27885 L closepath p F P
0 g
s
.462 .873 .949 r
.44902 .27885 m .49109 .26481 L .4519 .26995 L closepath p F P
0 g
s
.42 0 0 r
.4702 .89716 m .52839 .89791 L .5091 .90495 L closepath p F P
0 g
s
.296 0 0 r
.56152 .90097 m .5091 .90495 L .52839 .89791 L closepath p F P
0 g
s
0 0 .525 r
.82092 .4596 m .8348 .52043 L .83905 .50451 L closepath p F P
0 g
s
0 0 .392 r
.8458 .56489 m .83905 .50451 L .8348 .52043 L closepath p F P
0 g
s
.921 .773 .292 r
.20635 .54356 m .20679 .60195 L .21129 .56218 L closepath p F P
0 g
s
.951 .847 .42 r
.21129 .56218 m .21503 .51062 L .20635 .54356 L closepath p F P
0 g
s
0 0 .312 r
.8458 .56489 m .83992 .62247 L .84819 .60512 L closepath p F P
0 g
s
0 0 .18 r
.83829 .65635 m .84819 .60512 L .83992 .62247 L closepath p F P
0 g
s
.885 .568 .063 r
.21007 .64801 m .23088 .70763 L .21997 .66074 L closepath p F P
0 g
s
.941 .685 .215 r
.21997 .66074 m .20679 .60195 L .21007 .64801 L closepath p F P
0 g
s
.811 .952 .611 r
.27615 .38482 m .2421 .42994 L .25046 .42858 L closepath p F P
0 g
s
.863 .935 .559 r
.22425 .47271 m .25046 .42858 L .2421 .42994 L closepath p F P
0 g
s
.088 0 0 r
.59958 .89162 m .64883 .8813 L .60585 .89643 L closepath p F P
0 g
s
.133 0 0 r
.60585 .89643 m .56152 .90097 L .59958 .89162 L closepath p F P
0 g
s
.528 .921 .837 r
.40682 .28318 m .35896 .31103 L .40581 .29018 L closepath p F P
0 g
s
.467 .891 .878 r
.40581 .29018 m .4519 .26995 L .40682 .28318 L closepath p F P
0 g
s
.167 .684 .89 r
.58296 .2673 m .52429 .26053 L .54337 .26663 L closepath p F P
0 g
s
.31 .777 .939 r
.49109 .26481 m .54337 .26663 L .52429 .26053 L closepath p F P
0 g
s
0 0 0 r
.74037 .82567 m .69411 .85635 L .73733 .82087 L closepath p F P
0 g
s
0 0 0 r
.74037 .82567 m .77747 .78272 L .73733 .82087 L closepath p F P
0 g
s
0 0 0 r
.82468 .69273 m .80747 .74117 L .82748 .70062 L closepath p F P
0 g
s
0 0 .021 r
.82748 .70062 m .83829 .65635 L .82468 .69273 L closepath p F P
0 g
s
0 .446 .817 r
.68539 .30383 m .6278 .27658 L .64055 .28686 L closepath p F P
0 g
s
.086 .584 .897 r
.58296 .2673 m .64055 .28686 L .6278 .27658 L closepath p F P
0 g
s
.515 0 0 r
.41077 .88365 m .35706 .85861 L .36919 .85975 L closepath p F P
0 g
s
.636 .078 0 r
.3238 .82937 m .35706 .85861 L .36919 .85975 L closepath p F P
0 g
s
.6 .043 0 r
.35706 .85861 m .3238 .82937 L .31553 .82833 L closepath p F P
0 g
s
.698 .177 0 r
.28752 .7953 m .31553 .82833 L .3238 .82937 L closepath p F P
0 g
s
.432 0 0 r
.41077 .88365 m .4702 .89716 L .45253 .89806 L closepath p F P
0 g
s
.274 0 0 r
.5091 .90495 m .45253 .89806 L .4702 .89716 L closepath p F P
0 g
s
.732 .26 0 r
.25696 .75592 m .28202 .79506 L .28752 .7953 L closepath p F P
0 g
s
.661 .147 0 r
.31553 .82833 m .28752 .7953 L .28202 .79506 L closepath p F P
0 g
s
.65 .911 .6 r
.31263 .34285 m .27116 .38524 L .27615 .38482 L closepath p F P
0 g
s
.721 .908 .543 r
.2421 .42994 m .27615 .38482 L .27116 .38524 L closepath p F P
0 g
s
.194 0 0 r
.56152 .90097 m .5091 .90495 L .55569 .90526 L closepath p F P
0 g
s
.068 0 0 r
.60585 .89643 m .56152 .90097 L .55569 .90526 L closepath p F P
0 g
s
0 0 .517 r
.82008 .44841 m .79601 .41076 L .82092 .4596 L closepath p F P
0 g
s
0 0 .381 r
.83905 .50451 m .82008 .44841 L .82092 .4596 L closepath p F P
0 g
s
.53 .896 .694 r
.35852 .30738 m .31263 .34285 L .35896 .31103 L closepath p F P
0 g
s
.459 .876 .749 r
.35896 .31103 m .40682 .28318 L .35852 .30738 L closepath p F P
0 g
s
.814 .813 .328 r
.21335 .50314 m .21503 .51062 L .22425 .47271 L closepath p F P
0 g
s
.812 .784 .281 r
.21503 .51062 m .21335 .50314 L .20635 .54356 L closepath p F P
0 g
s
.77 .365 0 r
.23088 .70763 m .25005 .75104 L .25696 .75592 L closepath p F P
0 g
s
.687 .23 0 r
.28202 .79506 m .25696 .75592 L .25005 .75104 L closepath p F P
0 g
s
0 0 .303 r
.83905 .50451 m .8458 .56489 L .84772 .54841 L closepath p F P
0 g
s
0 0 .137 r
.84819 .60512 m .84772 .54841 L .8458 .56489 L closepath p F P
0 g
s
.784 .587 .02 r
.2032 .58414 m .21007 .64801 L .20679 .60195 L closepath p F P
0 g
s
.859 .714 .189 r
.20679 .60195 m .20635 .54356 L .2032 .58414 L closepath p F P
0 g
s
0 0 .471 r
.79601 .41076 m .82008 .44841 L .79485 .40339 L closepath p F P
0 g
s
0 .027 .582 r
.79485 .40339 m .76629 .37058 L .79601 .41076 L closepath p F P
0 g
s
0 0 0 r
.82748 .70062 m .83829 .65635 L .84227 .65198 L closepath p F P
0 g
s
0 0 .068 r
.84819 .60512 m .83829 .65635 L .84227 .65198 L closepath p F P
0 g
s
0 0 0 r
.69411 .85635 m .74037 .82567 L .69674 .85792 L closepath p F P
0 g
s
0 0 0 r
.69674 .85792 m .64883 .8813 L .69411 .85635 L closepath p F P
0 g
s
.795 .475 0 r
.23088 .70763 m .21007 .64801 L .22415 .69731 L closepath p F P
0 g
s
.704 .327 0 r
.25005 .75104 m .23088 .70763 L .22415 .69731 L closepath p F P
0 g
s
.158 .699 .788 r
.48247 .26349 m .49109 .26481 L .52429 .26053 L closepath p F P
0 g
s
.21 .736 .798 r
.49109 .26481 m .48247 .26349 L .4519 .26995 L closepath p F P
0 g
s
0 0 0 r
.77747 .78272 m .74037 .82567 L .77739 .78669 L closepath p F P
0 g
s
0 0 0 r
.77739 .78669 m .80747 .74117 L .77747 .78272 L closepath p F P
0 g
s
0 .109 .62 r
.76549 .36614 m .73057 .33548 L .76629 .37058 L closepath p F P
0 g
s
0 0 .537 r
.76629 .37058 m .79485 .40339 L .76549 .36614 L closepath p F P
0 g
s
0 .464 .715 r
.6278 .27658 m .56435 .26277 L .58296 .2673 L closepath p F P
0 g
s
.054 .611 .815 r
.52429 .26053 m .58296 .2673 L .56435 .26277 L closepath p F P
0 g
s
0 .218 .668 r
.72521 .32916 m .68539 .30383 L .73057 .33548 L closepath p F P
0 g
s
0 .075 .567 r
.73057 .33548 m .76549 .36614 L .72521 .32916 L closepath p F P
0 g
s
0 .337 .707 r
.6278 .27658 m .68539 .30383 L .67455 .2971 L closepath p F P
0 g
s
.383 0 0 r
.68539 .30383 m .72521 .32916 L .67455 .2971 L closepath p F P
0 g
s
.414 0 0 r
.35706 .85861 m .41077 .88365 L .39758 .87958 L closepath p F P
0 g
s
.248 0 0 r
.45253 .89806 m .39758 .87958 L .41077 .88365 L closepath p F P
0 g
s
.662 .764 .283 r
.228 .46309 m .22425 .47271 L .2421 .42994 L closepath p F P
0 g
s
0 0 0 r
.22425 .47271 m .228 .46309 L .21335 .50314 L closepath p F P
0 g
s
.508 .818 .497 r
.27116 .38524 m .31263 .34285 L .31189 .34352 L closepath p F P
0 g
s
0 0 0 r
.31263 .34285 m .35852 .30738 L .31189 .34352 L closepath p F P
0 g
s
.005 0 0 r
.49706 .90487 m .55569 .90526 L .5091 .90495 L closepath p F P
0 g
s
.171 0 0 r
.5091 .90495 m .45253 .89806 L .49706 .90487 L closepath p F P
0 g
s
0 0 0 r
.64883 .8813 m .69674 .85792 L .65202 .88035 L closepath p F P
0 g
s
0 0 0 r
.65202 .88035 m .60585 .89643 L .64883 .8813 L closepath p F P
0 g
s
0 0 0 r
.44036 .27393 m .4519 .26995 L .48247 .26349 L closepath p F P
0 g
s
0 0 0 r
.4519 .26995 m .44036 .27393 L .40682 .28318 L closepath p F P
0 g
s
0 0 0 r
.80747 .74117 m .77739 .78669 L .80489 .74533 L closepath p F P
0 g
s
.655 .791 .336 r
.80489 .74533 m .82748 .70062 L .80747 .74117 L closepath p F P
0 g
s
0 0 .269 r
.82008 .44841 m .83905 .50451 L .83548 .49186 L closepath p F P
0 g
s
.737 .484 0 r
.84772 .54841 m .83548 .49186 L .83905 .50451 L closepath p F P
0 g
s
0 0 0 r
.20887 .53881 m .20635 .54356 L .21335 .50314 L closepath p F P
0 g
s
0 0 .004 r
.20635 .54356 m .20887 .53881 L .2032 .58414 L closepath p F P
0 g
s
0 0 .028 r
.84772 .54841 m .84819 .60512 L .84846 .59411 L closepath p F P
0 g
s
.752 .681 .133 r
.84227 .65198 m .84846 .59411 L .84819 .60512 L closepath p F P
0 g
s
0 0 .301 r
.2093 .63133 m .22415 .69731 L .21007 .64801 L closepath p F P
0 g
s
0 0 .128 r
.21007 .64801 m .2032 .58414 L .2093 .63133 L closepath p F P
0 g
s
.09 0 0 r
.52429 .26053 m .51771 .26388 L .48247 .26349 L closepath p F P
0 g
s
.136 0 0 r
.51771 .26388 m .52429 .26053 L .56435 .26277 L closepath p F P
0 g
s
.19 .721 .758 r
.55569 .90526 m .60369 .89547 L .60585 .89643 L closepath p F P
0 g
s
.291 .785 .746 r
.65202 .88035 m .60585 .89643 L .60369 .89547 L closepath p F P
0 g
s
0 0 0 r
.2421 .42994 m .25334 .41968 L .228 .46309 L closepath p F P
0 g
s
0 0 0 r
.25334 .41968 m .2421 .42994 L .27116 .38524 L closepath p F P
0 g
s
0 .317 .724 r
.39758 .87958 m .34965 .8522 L .35706 .85861 L closepath p F P
0 g
s
0 .164 .616 r
.31553 .82833 m .34965 .8522 L .35706 .85861 L closepath p F P
0 g
s
.772 .8 .313 r
.84227 .65198 m .82562 .69939 L .82748 .70062 L closepath p F P
0 g
s
.741 .846 .402 r
.80489 .74533 m .82748 .70062 L .82562 .69939 L closepath p F P
0 g
s
0 0 0 r
.39366 .29466 m .40682 .28318 L .44036 .27393 L closepath p F P
0 g
s
0 0 0 r
.40682 .28318 m .39366 .29466 L .35852 .30738 L closepath p F P
0 g
s
0 .115 .626 r
.28202 .79506 m .31691 .82568 L .31553 .82833 L closepath p F P
0 g
s
0 .204 .678 r
.34965 .8522 m .31553 .82833 L .31691 .82568 L closepath p F P
0 g
s
.436 0 0 r
.67455 .2971 m .60985 .27511 L .6278 .27658 L closepath p F P
0 g
s
.269 0 0 r
.56435 .26277 m .6278 .27658 L .60985 .27511 L closepath p F P
0 g
s
.115 .665 .806 r
.55569 .90526 m .49706 .90487 L .54788 .90307 L closepath p F P
0 g
s
.252 .764 .835 r
.60369 .89547 m .55569 .90526 L .54788 .90307 L closepath p F P
0 g
s
.046 .586 .85 r
.43598 .891 m .49706 .90487 L .45253 .89806 L closepath p F P
0 g
s
0 .435 .748 r
.45253 .89806 m .39758 .87958 L .43598 .891 L closepath p F P
0 g
s
.574 .916 .701 r
.73745 .82363 m .69674 .85792 L .74037 .82567 L closepath p F P
0 g
s
.648 .925 .644 r
.73745 .82363 m .77739 .78669 L .74037 .82567 L closepath p F P
0 g
s
.847 .84 .373 r
.82562 .69939 m .84227 .65198 L .8398 .64503 L closepath p F P
0 g
s
.838 .761 .249 r
.84846 .59411 m .84227 .65198 L .8398 .64503 L closepath p F P
0 g
s
0 .037 .593 r
.25005 .75104 m .2829 .78854 L .28202 .79506 L closepath p F P
0 g
s
0 .151 .674 r
.31691 .82568 m .28202 .79506 L .2829 .78854 L closepath p F P
0 g
s
.729 .318 0 r
.81355 .44116 m .79485 .40339 L .82008 .44841 L closepath p F P
0 g
s
.816 .458 0 r
.83548 .49186 m .81355 .44116 L .82008 .44841 L closepath p F P
0 g
s
.899 .696 .186 r
.84846 .59411 m .84152 .53212 L .84772 .54841 L closepath p F P
0 g
s
.824 .566 .014 r
.83548 .49186 m .84772 .54841 L .84152 .53212 L closepath p F P
0 g
s
.739 .267 0 r
.79076 .40557 m .76549 .36614 L .79485 .40339 L closepath p F P
0 g
s
.782 .352 0 r
.79485 .40339 m .81355 .44116 L .79076 .40557 L closepath p F P
0 g
s
0 0 .531 r
.22415 .69731 m .25146 .73981 L .25005 .75104 L closepath p F P
0 g
s
0 .082 .64 r
.2829 .78854 m .25005 .75104 L .25146 .73981 L closepath p F P
0 g
s
0 0 .269 r
.21245 .58204 m .2032 .58414 L .20887 .53881 L closepath p F P
0 g
s
0 0 .312 r
.2032 .58414 m .21245 .58204 L .2093 .63133 L closepath p F P
0 g
s
0 0 .081 r
.22277 .49761 m .21335 .50314 L .228 .46309 L closepath p F P
0 g
s
0 0 .122 r
.21335 .50314 m .22277 .49761 L .20887 .53881 L closepath p F P
0 g
s
0 0 0 r
.27116 .38524 m .29073 .377 L .25334 .41968 L closepath p F P
0 g
s
0 0 0 r
.29073 .377 m .27116 .38524 L .31189 .34352 L closepath p F P
0 g
s
.707 .186 0 r
.75749 .36747 m .72521 .32916 L .76549 .36614 L closepath p F P
0 g
s
.776 .296 0 r
.76549 .36614 m .79076 .40557 L .75749 .36747 L closepath p F P
0 g
s
.63 .955 .779 r
.69674 .85792 m .73745 .82363 L .69502 .85271 L closepath p F P
0 g
s
.561 .934 .831 r
.69502 .85271 m .65202 .88035 L .69674 .85792 L closepath p F P
0 g
s
0 0 0 r
.34636 .32743 m .35852 .30738 L .39366 .29466 L closepath p F P
0 g
s
0 0 0 r
.35852 .30738 m .34636 .32743 L .31189 .34352 L closepath p F P
0 g
s
.73 .966 .7 r
.77739 .78669 m .73745 .82363 L .77124 .78539 L closepath p F P
0 g
s
.797 .962 .644 r
.77124 .78539 m .80489 .74533 L .77739 .78669 L closepath p F P
0 g
s
0 0 .443 r
.22415 .69731 m .2093 .63133 L .22749 .68158 L closepath p F P
0 g
s
0 0 .574 r
.25146 .73981 m .22415 .69731 L .22749 .68158 L closepath p F P
0 g
s
.068 .536 .897 r
.37983 .86496 m .43598 .891 L .39758 .87958 L closepath p F P
0 g
s
0 .407 .814 r
.39758 .87958 m .34965 .8522 L .37983 .86496 L closepath p F P
0 g
s
.23 0 0 r
.47435 .27358 m .48247 .26349 L .51771 .26388 L closepath p F P
0 g
s
.188 0 0 r
.48247 .26349 m .47435 .27358 L .44036 .27393 L closepath p F P
0 g
s
.383 0 0 r
.56435 .26277 m .55946 .27328 L .51771 .26388 L closepath p F P
0 g
s
.426 0 0 r
.55946 .27328 m .56435 .26277 L .60985 .27511 L closepath p F P
0 g
s
.646 .089 0 r
.71237 .33054 m .67455 .2971 L .72521 .32916 L closepath p F P
0 g
s
.741 .22 0 r
.72521 .32916 m .75749 .36747 L .71237 .33054 L closepath p F P
0 g
s
.303 .757 .955 r
.48349 .89584 m .54788 .90307 L .49706 .90487 L closepath p F P
0 g
s
.152 .65 .911 r
.49706 .90487 m .43598 .891 L .48349 .89584 L closepath p F P
0 g
s
.537 .92 .921 r
.60369 .89547 m .65212 .87169 L .65202 .88035 L closepath p F P
0 g
s
.6 .952 .882 r
.69502 .85271 m .65202 .88035 L .65212 .87169 L closepath p F P
0 g
s
.675 .128 0 r
.67455 .2971 m .71237 .33054 L .65696 .29991 L closepath p F P
0 g
s
.559 0 0 r
.60985 .27511 m .67455 .2971 L .65696 .29991 L closepath p F P
0 g
s
.947 .643 .199 r
.84152 .53212 m .82189 .47343 L .83548 .49186 L closepath p F P
0 g
s
.887 .535 .049 r
.81355 .44116 m .83548 .49186 L .82189 .47343 L closepath p F P
0 g
s
.969 .832 .417 r
.8398 .64503 m .83979 .58068 L .84846 .59411 L closepath p F P
0 g
s
.947 .746 .281 r
.84152 .53212 m .84846 .59411 L .83979 .58068 L closepath p F P
0 g
s
.9 .959 .627 r
.82562 .69939 m .79499 .74548 L .80489 .74533 L closepath p F P
0 g
s
.849 .979 .681 r
.77124 .78539 m .80489 .74533 L .79499 .74548 L closepath p F P
0 g
s
.039 0 0 r
.29073 .377 m .34636 .32743 L .31189 .34352 L closepath p F P
0 g
s
0 0 .187 r
.228 .46309 m .2449 .45766 L .22277 .49761 L closepath p F P
0 g
s
0 0 .147 r
.2449 .45766 m .228 .46309 L .25334 .41968 L closepath p F P
0 g
s
.017 .411 .858 r
.34965 .8522 m .34443 .8356 L .31691 .82568 L closepath p F P
0 g
s
.067 .459 .884 r
.34965 .8522 m .34443 .8356 L .37983 .86496 L closepath p F P
0 g
s
.48 .871 .968 r
.54788 .90307 m .59893 .88559 L .60369 .89547 L closepath p F P
0 g
s
.567 .923 .952 r
.65212 .87169 m .60369 .89547 L .59893 .88559 L closepath p F P
0 g
s
.27 0 0 r
.43137 .29157 m .44036 .27393 L .47435 .27358 L closepath p F P
0 g
s
.229 0 0 r
.44036 .27393 m .43137 .29157 L .39366 .29466 L closepath p F P
0 g
s
.96 .921 .574 r
.8398 .64503 m .81499 .69466 L .82562 .69939 L closepath p F P
0 g
s
.931 .96 .652 r
.79499 .74548 m .82562 .69939 L .81499 .69466 L closepath p F P
0 g
s
0 0 .516 r
.22723 .63058 m .2093 .63133 L .21245 .58204 L closepath p F P
0 g
s
0 .015 .554 r
.2093 .63133 m .22723 .63058 L .22749 .68158 L closepath p F P
0 g
s
0 0 .347 r
.2253 .5355 m .20887 .53881 L .22277 .49761 L closepath p F P
0 g
s
0 0 .379 r
.20887 .53881 m .2253 .5355 L .21245 .58204 L closepath p F P
0 g
s
.308 .686 .977 r
.41972 .87369 m .48349 .89584 L .43598 .891 L closepath p F P
0 g
s
.17 .59 .938 r
.43598 .891 m .37983 .86496 L .41972 .87369 L closepath p F P
0 g
s
.916 .522 .14 r
.79622 .4352 m .81355 .44116 L .79076 .40557 L closepath p F P
0 g
s
.935 .563 .186 r
.79622 .4352 m .81355 .44116 L .82189 .47343 L closepath p F P
0 g
s
.404 .798 .987 r
.54788 .90307 m .48349 .89584 L .53795 .89055 L closepath p F P
0 g
s
.511 .864 .99 r
.59893 .88559 m .54788 .90307 L .53795 .89055 L closepath p F P
0 g
s
.085 .404 .857 r
.31192 .80144 m .31691 .82568 L .34443 .8356 L closepath p F P
0 g
s
.035 .357 .831 r
.31691 .82568 m .31192 .80144 L .2829 .78854 L closepath p F P
0 g
s
.763 .994 .871 r
.73061 .81699 m .69502 .85271 L .73745 .82363 L closepath p F P
0 g
s
.823 1 .821 r
.73061 .81699 m .77124 .78539 L .73745 .82363 L closepath p F P
0 g
s
.433 0 0 r
.51771 .26388 m .51085 .28134 L .47435 .27358 L closepath p F P
0 g
s
.465 0 0 r
.51085 .28134 m .51771 .26388 L .55946 .27328 L closepath p F P
0 g
s
.98 .91 .598 r
.81499 .69466 m .8398 .64503 L .82714 .63488 L closepath p F P
0 g
s
.991 .858 .504 r
.83979 .58068 m .8398 .64503 L .82714 .63488 L closepath p F P
0 g
s
.6 .078 0 r
.60985 .27511 m .60518 .29452 L .55946 .27328 L closepath p F P
0 g
s
.637 .116 0 r
.60518 .29452 m .60985 .27511 L .65696 .29991 L closepath p F P
0 g
s
.995 .759 .41 r
.83979 .58068 m .82492 .51498 L .84152 .53212 L closepath p F P
0 g
s
.973 .682 .287 r
.82189 .47343 m .84152 .53212 L .82492 .51498 L closepath p F P
0 g
s
.908 .502 .191 r
.79076 .40557 m .76565 .39904 L .79622 .4352 L closepath p F P
0 g
s
.888 .462 .145 r
.76565 .39904 m .79076 .40557 L .75749 .36747 L closepath p F P
0 g
s
.068 0 .241 r
.25334 .41968 m .27829 .41663 L .2449 .45766 L closepath p F P
0 g
s
.061 0 .194 r
.27829 .41663 m .25334 .41968 L .29073 .377 L closepath p F P
0 g
s
.107 .347 .814 r
.28033 .75569 m .2829 .78854 L .31192 .80144 L closepath p F P
0 g
s
.047 .289 .78 r
.2829 .78854 m .28033 .75569 L .25146 .73981 L closepath p F P
0 g
s
.301 0 .06 r
.38608 .32062 m .39366 .29466 L .43137 .29157 L closepath p F P
0 g
s
.251 0 .047 r
.39366 .29466 m .38608 .32062 L .34636 .32743 L closepath p F P
0 g
s
.737 .967 .935 r
.65212 .87169 m .69501 .83615 L .69502 .85271 L closepath p F P
0 g
s
.778 .986 .899 r
.73061 .81699 m .69502 .85271 L .69501 .83615 L closepath p F P
0 g
s
.899 .982 .797 r
.79499 .74548 m .75351 .78447 L .77124 .78539 L closepath p F P
0 g
s
.855 .993 .833 r
.73061 .81699 m .77124 .78539 L .75351 .78447 L closepath p F P
0 g
s
.251 .561 .934 r
.37906 .84319 m .37983 .86496 L .34443 .8356 L closepath p F P
0 g
s
.285 .593 .948 r
.37983 .86496 m .37906 .84319 L .41972 .87369 L closepath p F P
0 g
s
.866 .438 .198 r
.75749 .36747 m .72343 .36241 L .76565 .39904 L closepath p F P
0 g
s
.839 .388 .141 r
.72343 .36241 m .75749 .36747 L .71237 .33054 L closepath p F P
0 g
s
.12 .279 .752 r
.25411 .69941 m .25146 .73981 L .28033 .75569 L closepath p F P
0 g
s
.051 .21 .709 r
.25146 .73981 m .25411 .69941 L .22749 .68158 L closepath p F P
0 g
s
.067 0 .374 r
.2443 .49507 m .22277 .49761 L .2449 .45766 L closepath p F P
0 g
s
.071 0 .403 r
.22277 .49761 m .2443 .49507 L .2253 .5355 L closepath p F P
0 g
s
.495 .779 .995 r
.46951 .87474 m .53795 .89055 L .48349 .89584 L closepath p F P
0 g
s
.392 .714 .987 r
.48349 .89584 m .41972 .87369 L .46951 .87474 L closepath p F P
0 g
s
.963 .638 .345 r
.82189 .47343 m .7987 .47144 L .79622 .4352 L closepath p F P
0 g
s
.971 .667 .377 r
.7987 .47144 m .82189 .47343 L .82492 .51498 L closepath p F P
0 g
s
.121 .202 .675 r
.22723 .63058 m .25411 .69941 L .22749 .68158 L closepath p F P
0 g
s
.689 .921 .971 r
.59893 .88559 m .64841 .85297 L .65212 .87169 L closepath p F P
0 g
s
.743 .95 .945 r
.69501 .83615 m .65212 .87169 L .64841 .85297 L closepath p F P
0 g
s
.468 .015 .09 r
.46781 .29608 m .47435 .27358 L .51085 .28134 L closepath p F P
0 g
s
.439 0 .082 r
.47435 .27358 m .46781 .29608 L .43137 .29157 L closepath p F P
0 g
s
.103 .071 .532 r
.23739 .57989 m .21245 .58204 L .2253 .5355 L closepath p F P
0 g
s
.106 .097 .564 r
.21245 .58204 m .23739 .57989 L .22723 .63058 L closepath p F P
0 g
s
.806 .364 .194 r
.71237 .33054 m .67018 .32982 L .72343 .36241 L closepath p F P
0 g
s
.771 .303 .129 r
.67018 .32982 m .71237 .33054 L .65696 .29991 L closepath p F P
0 g
s
.945 .943 .751 r
.81499 .69466 m .77544 .74072 L .79499 .74548 L closepath p F P
0 g
s
.913 .965 .8 r
.75351 .78447 m .79499 .74548 L .77544 .74072 L closepath p F P
0 g
s
.993 .826 .572 r
.82714 .63488 m .81905 .56545 L .83979 .58068 L closepath p F P
0 g
s
.996 .774 .48 r
.82492 .51498 m .83979 .58068 L .81905 .56545 L closepath p F P
0 g
s
.162 0 .125 r
.34636 .32743 m .29073 .377 L .3274 .36339 L closepath p F P
0 g
s
.232 0 .274 r
.27829 .41663 m .3274 .36339 L .29073 .377 L closepath p F P
0 g
s
.313 0 .21 r
.3274 .36339 m .38608 .32062 L .34636 .32743 L closepath p F P
0 g
s
.732 .281 .18 r
.67018 .32982 m .60518 .29452 L .65696 .29991 L closepath p F P
0 g
s
.594 .138 .139 r
.55946 .27328 m .55268 .29941 L .51085 .28134 L closepath p F P
0 g
s
.625 .168 .147 r
.55268 .29941 m .55946 .27328 L .60518 .29452 L closepath p F P
0 g
s
.288 .511 .897 r
.34443 .8356 m .34534 .80756 L .31192 .80144 L closepath p F P
0 g
s
.318 .54 .909 r
.34443 .8356 m .34534 .80756 L .37906 .84319 L closepath p F P
0 g
s
.627 .859 .986 r
.53795 .89055 m .59098 .86378 L .59893 .88559 L closepath p F P
0 g
s
.692 .896 .971 r
.64841 .85297 m .59893 .88559 L .59098 .86378 L closepath p F P
0 g
s
.853 .952 .877 r
.73061 .81699 m .71514 .80092 L .75351 .78447 L closepath p F P
0 g
s
.835 .95 .893 r
.73061 .81699 m .71514 .80092 L .69501 .83615 L closepath p F P
0 g
s
.971 .888 .69 r
.82714 .63488 m .7928 .68539 L .81499 .69466 L closepath p F P
0 g
s
.948 .918 .749 r
.77544 .74072 m .81499 .69466 L .7928 .68539 L closepath p F P
0 g
s
.427 .653 .954 r
.42412 .84463 m .41972 .87369 L .37906 .84319 L closepath p F P
0 g
s
.457 .683 .962 r
.41972 .87369 m .42412 .84463 L .46951 .87474 L closepath p F P
0 g
s
.219 .046 .421 r
.2449 .45766 m .2739 .45747 L .2443 .49507 L closepath p F P
0 g
s
.217 .025 .393 r
.2739 .45747 m .2449 .45766 L .27829 .41663 L closepath p F P
0 g
s
.925 .581 .365 r
.76667 .43405 m .79622 .4352 L .76565 .39904 L closepath p F P
0 g
s
.933 .605 .393 r
.76667 .43405 m .79622 .4352 L .7987 .47144 L closepath p F P
0 g
s
.554 .785 .985 r
.53795 .89055 m .46951 .87474 L .52637 .865 L closepath p F P
0 g
s
.629 .83 .978 r
.59098 .86378 m .53795 .89055 L .52637 .865 L closepath p F P
0 g
s
.469 .081 .221 r
.42629 .32178 m .43137 .29157 L .46781 .29608 L closepath p F P
0 g
s
.44 .057 .215 r
.43137 .29157 m .42629 .32178 L .38608 .32062 L closepath p F P
0 g
s
.964 .706 .496 r
.82492 .51498 m .79374 .51734 L .7987 .47144 L closepath p F P
0 g
s
.969 .732 .525 r
.79374 .51734 m .82492 .51498 L .81905 .56545 L closepath p F P
0 g
s
.325 .482 .862 r
.31589 .76533 m .31192 .80144 L .34534 .80756 L closepath p F P
0 g
s
.296 .453 .848 r
.31192 .80144 m .31589 .76533 L .28033 .75569 L closepath p F P
0 g
s
.964 .858 .687 r
.7928 .68539 m .82714 .63488 L .80162 .62155 L closepath p F P
0 g
s
.979 .823 .619 r
.81905 .56545 m .82714 .63488 L .80162 .62155 L closepath p F P
0 g
s
.227 .127 .526 r
.25471 .53418 m .2253 .5355 L .2443 .49507 L closepath p F P
0 g
s
.228 .146 .55 r
.2253 .5355 m .25471 .53418 L .23739 .57989 L closepath p F P
0 g
s
.811 .911 .908 r
.67233 .81596 m .69501 .83615 L .71514 .80092 L closepath p F P
0 g
s
.792 .908 .921 r
.69501 .83615 m .67233 .81596 L .64841 .85297 L closepath p F P
0 g
s
.876 .916 .851 r
.7347 .76084 m .75351 .78447 L .71514 .80092 L closepath p F P
0 g
s
.89 .916 .835 r
.75351 .78447 m .7347 .76084 L .77544 .74072 L closepath p F P
0 g
s
.212 .258 .693 r
.25411 .69941 m .22723 .63058 L .25681 .6474 L closepath p F P
0 g
s
.257 .245 .654 r
.23739 .57989 m .25681 .6474 L .22723 .63058 L closepath p F P
0 g
s
.575 .174 .244 r
.51085 .28134 m .50455 .31185 L .46781 .29608 L closepath p F P
0 g
s
.599 .195 .25 r
.50455 .31185 m .51085 .28134 L .55268 .29941 L closepath p F P
0 g
s
.889 .544 .388 r
.76565 .39904 m .72764 .40004 L .76667 .43405 L closepath p F P
0 g
s
.879 .518 .36 r
.72764 .40004 m .76565 .39904 L .72343 .36241 L closepath p F P
0 g
s
.333 .427 .808 r
.28967 .71271 m .28033 .75569 L .31589 .76533 L closepath p F P
0 g
s
.295 .388 .788 r
.28033 .75569 m .28967 .71271 L .25411 .69941 L closepath p F P
0 g
s
.74 .324 .26 r
.60518 .29452 m .67018 .32982 L .61709 .32719 L closepath p F P
0 g
s
.697 .3 .291 r
.61709 .32719 m .55268 .29941 L .60518 .29452 L closepath p F P
0 g
s
.301 .04 .341 r
.3274 .36339 m .27829 .41663 L .31576 .40474 L closepath p F P
0 g
s
.339 .123 .433 r
.2739 .45747 m .31576 .40474 L .27829 .41663 L closepath p F P
0 g
s
.439 .595 .909 r
.38476 .80783 m .37906 .84319 L .34534 .80756 L closepath p F P
0 g
s
.461 .616 .916 r
.37906 .84319 m .38476 .80783 L .42412 .84463 L closepath p F P
0 g
s
.375 .051 .282 r
.38608 .32062 m .3274 .36339 L .36879 .35751 L closepath p F P
0 g
s
.466 .14 .329 r
.36879 .35751 m .42629 .32178 L .38608 .32062 L closepath p F P
0 g
s
.556 .71 .943 r
.47822 .83698 m .46951 .87474 L .42412 .84463 L closepath p F P
0 g
s
.582 .737 .949 r
.46951 .87474 m .47822 .83698 L .52637 .865 L closepath p F P
0 g
s
.409 .137 .387 r
.31576 .40474 m .36879 .35751 L .3274 .36339 L closepath p F P
0 g
s
.838 .483 .384 r
.72343 .36241 m .67797 .36794 L .72764 .40004 L closepath p F P
0 g
s
.822 .449 .348 r
.67797 .36794 m .72343 .36241 L .67018 .32982 L closepath p F P
0 g
s
.332 .366 .747 r
.25681 .6474 m .28967 .71271 L .25411 .69941 L closepath p F P
0 g
s
.763 .861 .922 r
.61822 .82668 m .64841 .85297 L .67233 .81596 L closepath p F P
0 g
s
.74 .856 .935 r
.64841 .85297 m .61822 .82668 L .59098 .86378 L closepath p F P
0 g
s
.308 .158 .508 r
.27535 .49571 m .2443 .49507 L .2739 .45747 L closepath p F P
0 g
s
.309 .176 .532 r
.2443 .49507 m .27535 .49571 L .25471 .53418 L closepath p F P
0 g
s
.898 .872 .803 r
.75143 .70892 m .77544 .74072 L .7347 .76084 L closepath p F P
0 g
s
.913 .87 .783 r
.77544 .74072 m .75143 .70892 L .7928 .68539 L closepath p F P
0 g
s
.922 .643 .496 r
.7987 .47144 m .76121 .47424 L .76667 .43405 L closepath p F P
0 g
s
.927 .662 .517 r
.76121 .47424 m .7987 .47144 L .79374 .51734 L closepath p F P
0 g
s
.571 .21 .317 r
.46347 .32827 m .46781 .29608 L .50455 .31185 L closepath p F P
0 g
s
.547 .19 .313 r
.46781 .29608 m .46347 .32827 L .42629 .32178 L closepath p F P
0 g
s
.942 .745 .608 r
.81905 .56545 m .77866 .57105 L .79374 .51734 L closepath p F P
0 g
s
.945 .769 .634 r
.77866 .57105 m .81905 .56545 L .80162 .62155 L closepath p F P
0 g
s
.78 .418 .372 r
.67797 .36794 m .61709 .32719 L .67018 .32982 L closepath p F P
0 g
s
.313 .281 .662 r
.25681 .6474 m .23739 .57989 L .26814 .59626 L closepath p F P
0 g
s
.343 .268 .626 r
.25471 .53418 m .26814 .59626 L .23739 .57989 L closepath p F P
0 g
s
.435 .538 .863 r
.34534 .80756 m .35342 .76938 L .31589 .76533 L closepath p F P
0 g
s
.456 .559 .871 r
.34534 .80756 m .35342 .76938 L .38476 .80783 L closepath p F P
0 g
s
.842 .866 .861 r
.71514 .80092 m .6906 .77462 L .7347 .76084 L closepath p F P
0 g
s
.829 .865 .872 r
.71514 .80092 m .6906 .77462 L .67233 .81596 L closepath p F P
0 g
s
.708 .805 .925 r
.55517 .82985 m .59098 .86378 L .61822 .82668 L closepath p F P
0 g
s
.68 .797 .937 r
.59098 .86378 m .55517 .82985 L .52637 .865 L closepath p F P
0 g
s
.909 .821 .748 r
.76187 .64701 m .7928 .68539 L .75143 .70892 L closepath p F P
0 g
s
.923 .818 .724 r
.7928 .68539 m .76187 .64701 L .80162 .62155 L closepath p F P
0 g
s
.699 .328 .341 r
.55268 .29941 m .61709 .32719 L .56411 .3331 L closepath p F P
0 g
s
.661 .307 .362 r
.56411 .3331 m .50455 .31185 L .55268 .29941 L closepath p F P
0 g
s
.879 .584 .483 r
.72626 .43875 m .76667 .43405 L .72764 .40004 L closepath p F P
0 g
s
.885 .603 .503 r
.72626 .43875 m .76667 .43405 L .76121 .47424 L closepath p F P
0 g
s
.378 .171 .468 r
.31576 .40474 m .2739 .45747 L .31068 .44651 L closepath p F P
0 g
s
.401 .227 .527 r
.27535 .49571 m .31068 .44651 L .2739 .45747 L closepath p F P
0 g
s
.648 .745 .92 r
.47822 .83698 m .55517 .82985 L .52637 .865 L closepath p F P
0 g
s
.546 .645 .898 r
.43383 .80106 m .42412 .84463 L .38476 .80783 L closepath p F P
0 g
s
.568 .667 .905 r
.42412 .84463 m .43383 .80106 L .47822 .83698 L closepath p F P
0 g
s
.498 .187 .37 r
.42629 .32178 m .36879 .35751 L .4101 .35801 L closepath p F P
0 g
s
.556 .247 .399 r
.4101 .35801 m .46347 .32827 L .42629 .32178 L closepath p F P
0 g
s
.454 .507 .823 r
.32899 .72116 m .31589 .76533 L .35342 .76938 L closepath p F P
0 g
s
.432 .483 .813 r
.31589 .76533 m .32899 .72116 L .28967 .71271 L closepath p F P
0 g
s
.912 .768 .689 r
.76187 .64701 m .77866 .57105 L .80162 .62155 L closepath p F P
0 g
s
.38 .392 .747 r
.28967 .71271 m .25681 .6474 L .29393 .66138 L closepath p F P
0 g
s
.406 .372 .708 r
.26814 .59626 m .29393 .66138 L .25681 .6474 L closepath p F P
0 g
s
.441 .181 .422 r
.36879 .35751 m .31576 .40474 L .35703 .39865 L closepath p F P
0 g
s
.462 .242 .493 r
.31068 .44651 m .35703 .39865 L .31576 .40474 L closepath p F P
0 g
s
.379 .291 .63 r
.26814 .59626 m .25471 .53418 L .28489 .55037 L closepath p F P
0 g
s
.4 .28 .599 r
.27535 .49571 m .28489 .55037 L .25471 .53418 L closepath p F P
0 g
s
.513 .248 .45 r
.35703 .39865 m .4101 .35801 L .36879 .35751 L closepath p F P
0 g
s
.902 .678 .589 r
.79374 .51734 m .7476 .52311 L .76121 .47424 L closepath p F P
0 g
s
.906 .698 .611 r
.7476 .52311 m .79374 .51734 L .77866 .57105 L closepath p F P
0 g
s
.795 .822 .872 r
.64102 .78345 m .67233 .81596 L .6906 .77462 L closepath p F P
0 g
s
.782 .82 .882 r
.67233 .81596 m .64102 .78345 L .61822 .82668 L closepath p F P
0 g
s
.849 .826 .825 r
.70479 .72706 m .7347 .76084 L .6906 .77462 L closepath p F P
0 g
s
.86 .826 .813 r
.7347 .76084 m .70479 .72706 L .75143 .70892 L closepath p F P
0 g
s
.661 .326 .394 r
.50455 .31185 m .56411 .3331 L .516 .34481 L closepath p F P
0 g
s
.628 .308 .409 r
.516 .34481 m .46347 .32827 L .50455 .31185 L closepath p F P
0 g
s
.841 .547 .492 r
.72764 .40004 m .68072 .409 L .72626 .43875 L closepath p F P
0 g
s
.833 .526 .471 r
.68072 .409 m .72764 .40004 L .67797 .36794 L closepath p F P
0 g
s
.775 .437 .414 r
.61709 .32719 m .67797 .36794 L .62548 .36686 L closepath p F P
0 g
s
.735 .41 .431 r
.62548 .36686 m .56411 .3331 L .61709 .32719 L closepath p F P
0 g
s
.452 .458 .774 r
.29393 .66138 m .32899 .72116 L .28967 .71271 L closepath p F P
0 g
s
.431 .3 .602 r
.27535 .49571 m .28489 .55037 L .30524 .49819 L closepath p F P
0 g
s
.432 .265 .553 r
.27535 .49571 m .31068 .44651 L .30524 .49819 L closepath p F P
0 g
s
.533 .59 .857 r
.39666 .7625 m .38476 .80783 L .35342 .76938 L closepath p F P
0 g
s
.551 .608 .864 r
.38476 .80783 m .39666 .7625 L .43383 .80106 L closepath p F P
0 g
s
.794 .495 .483 r
.68072 .409 m .62548 .36686 L .67797 .36794 L closepath p F P
0 g
s
.628 .324 .437 r
.46347 .32827 m .516 .34481 L .46153 .35913 L closepath p F P
0 g
s
.579 .283 .431 r
.4101 .35801 m .46347 .32827 L .46153 .35913 L closepath p F P
0 g
s
.748 .774 .874 r
.58199 .78694 m .61822 .82668 L .64102 .78345 L closepath p F P
0 g
s
.731 .77 .885 r
.61822 .82668 m .58199 .78694 L .55517 .82985 L closepath p F P
0 g
s
.865 .622 .57 r
.76121 .47424 m .71328 .48182 L .72626 .43875 L closepath p F P
0 g
s
.87 .639 .587 r
.71328 .48182 m .76121 .47424 L .7476 .52311 L closepath p F P
0 g
s
.434 .388 .708 r
.29393 .66138 m .26814 .59626 L .30462 .61134 L closepath p F P
0 g
s
.455 .372 .673 r
.28489 .55037 m .30462 .61134 L .26814 .59626 L closepath p F P
0 g
s
.657 .725 .899 r
.55517 .82985 m .47822 .83698 L .50707 .79943 L closepath p F P
0 g
s
.626 .679 .88 r
.43383 .80106 m .50707 .79943 L .47822 .83698 L closepath p F P
0 g
s
.858 .783 .778 r
.71495 .6693 m .75143 .70892 L .70479 .72706 L closepath p F P
0 g
s
.87 .782 .762 r
.75143 .70892 m .71495 .6693 L .76187 .64701 L closepath p F P
0 g
s
.492 .317 .571 r
.34963 .44593 m .30524 .49819 L .31068 .44651 L closepath p F P
0 g
s
.485 .273 .516 r
.31068 .44651 m .35703 .39865 L .34963 .44593 L closepath p F P
0 g
s
.515 .54 .82 r
.35342 .76938 m .36753 .72558 L .32899 .72116 L closepath p F P
0 g
s
.533 .559 .828 r
.35342 .76938 m .36753 .72558 L .39666 .7625 L closepath p F P
0 g
s
.589 .328 .489 r
.46153 .35913 m .40408 .39748 L .4101 .35801 L closepath p F P
0 g
s
.534 .279 .475 r
.35703 .39865 m .4101 .35801 L .40408 .39748 L closepath p F P
0 g
s
.732 .422 .456 r
.56411 .3331 m .62548 .36686 L .57379 .37212 L closepath p F P
0 g
s
.696 .4 .469 r
.57379 .37212 m .516 .34481 L .56411 .3331 L closepath p F P
0 g
s
.892 .745 .693 r
.77866 .57105 m .76187 .64701 L .73661 .59624 L closepath p F P
0 g
s
.877 .701 .66 r
.73661 .59624 m .7476 .52311 L .77866 .57105 L closepath p F P
0 g
s
.815 .788 .827 r
.6906 .77462 m .65843 .73953 L .70479 .72706 L closepath p F P
0 g
s
.804 .787 .837 r
.6906 .77462 m .65843 .73953 L .64102 .78345 L closepath p F P
0 g
s
.545 .326 .534 r
.40408 .39748 m .34963 .44593 L .35703 .39865 L closepath p F P
0 g
s
.699 .725 .871 r
.50707 .79943 m .58199 .78694 L .55517 .82985 L closepath p F P
0 g
s
.831 .572 .546 r
.67981 .44855 m .72626 .43875 L .68072 .409 L closepath p F P
0 g
s
.837 .59 .564 r
.67981 .44855 m .72626 .43875 L .71328 .48182 L closepath p F P
0 g
s
.479 .47 .77 r
.32899 .72116 m .29393 .66138 L .33349 .67195 L closepath p F P
0 g
s
.496 .449 .734 r
.30462 .61134 m .33349 .67195 L .29393 .66138 L closepath p F P
0 g
s
.861 .739 .728 r
.71495 .6693 m .73661 .59624 L .76187 .64701 L closepath p F P
0 g
s
.488 .362 .634 r
.32161 .55976 m .30524 .49819 L .28489 .55037 L closepath p F P
0 g
s
.477 .385 .673 r
.28489 .55037 m .30462 .61134 L .32161 .55976 L closepath p F P
0 g
s
.527 .513 .784 r
.33349 .67195 m .36753 .72558 L .32899 .72116 L closepath p F P
0 g
s
.654 .381 .494 r
.52007 .38332 m .46153 .35913 L .516 .34481 L closepath p F P
0 g
s
.693 .41 .49 r
.516 .34481 m .57379 .37212 L .52007 .38332 L closepath p F P
0 g
s
.787 .503 .506 r
.62548 .36686 m .68072 .409 L .63045 .40828 L closepath p F P
0 g
s
.751 .476 .516 r
.63045 .40828 m .57379 .37212 L .62548 .36686 L closepath p F P
0 g
s
.51 .375 .633 r
.30524 .49819 m .32161 .55976 L .347 .50336 L closepath p F P
0 g
s
.513 .344 .59 r
.30524 .49819 m .34963 .44593 L .347 .50336 L closepath p F P
0 g
s
.632 .664 .863 r
.50707 .79943 m .43383 .80106 L .46257 .76365 L closepath p F P
0 g
s
.605 .623 .843 r
.39666 .7625 m .46257 .76365 L .43383 .80106 L closepath p F P
0 g
s
.65 .391 .514 r
.46153 .35913 m .52007 .38332 L .46082 .40213 L closepath p F P
0 g
s
.606 .355 .511 r
.40408 .39748 m .46153 .35913 L .46082 .40213 L closepath p F P
0 g
s
.796 .541 .552 r
.67981 .44855 m .63045 .40828 L .68072 .409 L closepath p F P
0 g
s
.771 .747 .831 r
.60464 .74211 m .64102 .78345 L .65843 .73953 L closepath p F P
0 g
s
.759 .745 .84 r
.64102 .78345 m .60464 .74211 L .58199 .78694 L closepath p F P
0 g
s
.861 .685 .662 r
.7476 .52311 m .73661 .59624 L .70583 .54813 L closepath p F P
0 g
s
.845 .646 .633 r
.70583 .54813 m .71328 .48182 L .7476 .52311 L closepath p F P
0 g
s
.815 .751 .793 r
.66698 .68694 m .70479 .72706 L .65843 .73953 L closepath p F P
0 g
s
.824 .751 .782 r
.70479 .72706 m .66698 .68694 L .71495 .6693 L closepath p F P
0 g
s
.564 .386 .599 r
.40071 .44939 m .347 .50336 L .34963 .44593 L closepath p F P
0 g
s
.562 .351 .552 r
.34963 .44593 m .40408 .39748 L .40071 .44939 L closepath p F P
0 g
s
.531 .442 .699 r
.34834 .62608 m .32161 .55976 L .30462 .61134 L closepath p F P
0 g
s
.516 .459 .731 r
.30462 .61134 m .33349 .67195 L .34834 .62608 L closepath p F P
0 g
s
.61 .392 .56 r
.46082 .40213 m .40071 .44939 L .40408 .39748 L closepath p F P
0 g
s
.608 .612 .83 r
.46257 .76365 m .39666 .7625 L .42485 .72722 L closepath p F P
0 g
s
.584 .577 .811 r
.36753 .72558 m .42485 .72722 L .39666 .7625 L closepath p F P
0 g
s
.701 .709 .854 r
.58199 .78694 m .50707 .79943 L .53506 .75658 L closepath p F P
0 g
s
.671 .667 .838 r
.46257 .76365 m .53506 .75658 L .50707 .79943 L closepath p F P
0 g
s
.713 .462 .543 r
.58243 .41816 m .52007 .38332 L .57379 .37212 L closepath p F P
0 g
s
.746 .483 .533 r
.57379 .37212 m .63045 .40828 L .58243 .41816 L closepath p F P
0 g
s
.548 .522 .779 r
.33349 .67195 m .36753 .72558 L .3821 .68846 L closepath p F P
0 g
s
.587 .566 .798 r
.42485 .72722 m .36753 .72558 L .3821 .68846 L closepath p F P
0 g
s
.832 .634 .634 r
.71328 .48182 m .70583 .54813 L .67383 .50647 L closepath p F P
0 g
s
.817 .6 .609 r
.67383 .50647 m .67981 .44855 L .71328 .48182 L closepath p F P
0 g
s
.563 .508 .752 r
.3821 .68846 m .34834 .62608 L .33349 .67195 L closepath p F P
0 g
s
.728 .706 .829 r
.53506 .75658 m .60464 .74211 L .58199 .78694 L closepath p F P
0 g
s
.845 .721 .727 r
.73661 .59624 m .71495 .6693 L .68972 .61964 L closepath p F P
0 g
s
.833 .682 .696 r
.68972 .61964 m .70583 .54813 L .73661 .59624 L closepath p F P
0 g
s
.818 .713 .75 r
.66698 .68694 m .68972 .61964 L .71495 .6693 L closepath p F P
0 g
s
.558 .429 .661 r
.37099 .57152 m .347 .50336 L .32161 .55976 L closepath p F P
0 g
s
.548 .451 .696 r
.32161 .55976 m .34834 .62608 L .37099 .57152 L closepath p F P
0 g
s
.787 .725 .794 r
.65843 .73953 m .62252 .69991 L .66698 .68694 L closepath p F P
0 g
s
.776 .724 .804 r
.65843 .73953 m .62252 .69991 L .60464 .74211 L closepath p F P
0 g
s
.804 .588 .61 r
.67981 .44855 m .67383 .50647 L .64041 .45925 L closepath p F P
0 g
s
.789 .547 .57 r
.63045 .40828 m .67981 .44855 L .64041 .45925 L closepath p F P
0 g
s
.762 .529 .58 r
.64041 .45925 m .58243 .41816 L .63045 .40828 L closepath p F P
0 g
s
.672 .441 .562 r
.52505 .43463 m .46082 .40213 L .52007 .38332 L closepath p F P
0 g
s
.709 .468 .559 r
.52007 .38332 m .58243 .41816 L .52505 .43463 L closepath p F P
0 g
s
.577 .44 .657 r
.347 .50336 m .37099 .57152 L .40158 .51205 L closepath p F P
0 g
s
.582 .413 .618 r
.347 .50336 m .40071 .44939 L .40158 .51205 L closepath p F P
0 g
s
.667 .449 .581 r
.46082 .40213 m .52505 .43463 L .46219 .45818 L closepath p F P
0 g
s
.626 .418 .579 r
.40071 .44939 m .46082 .40213 L .46219 .45818 L closepath p F P
0 g
s
.672 .656 .826 r
.53506 .75658 m .46257 .76365 L .49133 .72333 L closepath p F P
0 g
s
.646 .619 .808 r
.42485 .72722 m .49133 .72333 L .46257 .76365 L closepath p F P
0 g
s
.625 .447 .622 r
.46219 .45818 m .40158 .51205 L .40071 .44939 L closepath p F P
0 g
s
.591 .499 .718 r
.40327 .64126 m .37099 .57152 L .34834 .62608 L closepath p F P
0 g
s
.58 .516 .748 r
.34834 .62608 m .3821 .68846 L .40327 .64126 L closepath p F P
0 g
s
.821 .67 .695 r
.70583 .54813 m .68972 .61964 L .6615 .57255 L closepath p F P
0 g
s
.807 .634 .667 r
.6615 .57255 m .67383 .50647 L .70583 .54813 L closepath p F P
0 g
s
.616 .569 .779 r
.3821 .68846 m .44819 .68583 L .42485 .72722 L closepath p F P
0 g
s
.617 .559 .767 r
.44819 .68583 m .3821 .68846 L .40327 .64126 L closepath p F P
0 g
s
.728 .693 .817 r
.60464 .74211 m .53506 .75658 L .55984 .71369 L closepath p F P
0 g
s
.747 .688 .795 r
.55984 .71369 m .62252 .69991 L .60464 .74211 L closepath p F P
0 g
s
.647 .609 .797 r
.49133 .72333 m .42485 .72722 L .44819 .68583 L closepath p F P
0 g
s
.806 .7 .748 r
.68972 .61964 m .66698 .68694 L .64355 .63956 L closepath p F P
0 g
s
.783 .691 .764 r
.62252 .69991 m .64355 .63956 L .66698 .68694 L closepath p F P
0 g
s
.726 .513 .602 r
.59031 .47525 m .52505 .43463 L .58243 .41816 L closepath p F P
0 g
s
.756 .534 .595 r
.58243 .41816 m .64041 .45925 L .59031 .47525 L closepath p F P
0 g
s
.7 .656 .803 r
.49133 .72333 m .55984 .71369 L .53506 .75658 L closepath p F P
0 g
s
.783 .586 .634 r
.62919 .52532 m .64041 .45925 L .67383 .50647 L closepath p F P
0 g
s
.771 .574 .633 r
.64041 .45925 m .62919 .52532 L .59031 .47525 L closepath p F P
0 g
s
.796 .664 .718 r
.64355 .63956 m .6615 .57255 L .68972 .61964 L closepath p F P
0 g
s
.797 .623 .666 r
.67383 .50647 m .6615 .57255 L .62919 .52532 L closepath p F P
0 g
s
.617 .487 .681 r
.43176 .58506 m .40158 .51205 L .37099 .57152 L closepath p F P
0 g
s
.609 .507 .713 r
.37099 .57152 m .40327 .64126 L .43176 .58506 L closepath p F P
0 g
s
.746 .676 .783 r
.62252 .69991 m .55984 .71369 L .59269 .66676 L closepath p F P
0 g
s
.771 .678 .761 r
.64355 .63956 m .62252 .69991 L .59269 .66676 L closepath p F P
0 g
s
.686 .494 .622 r
.53064 .49727 m .46219 .45818 L .52505 .43463 L closepath p F P
0 g
s
.719 .519 .618 r
.52505 .43463 m .59031 .47525 L .53064 .49727 L closepath p F P
0 g
s
.675 .61 .775 r
.44819 .68583 m .52163 .67828 L .49133 .72333 L closepath p F P
0 g
s
.7 .645 .792 r
.55984 .71369 m .49133 .72333 L .52163 .67828 L closepath p F P
0 g
s
.635 .496 .675 r
.40158 .51205 m .43176 .58506 L .46624 .52439 L closepath p F P
0 g
s
.641 .472 .639 r
.40158 .51205 m .46219 .45818 L .46624 .52439 L closepath p F P
0 g
s
.678 .5 .638 r
.46219 .45818 m .53064 .49727 L .46624 .52439 L closepath p F P
0 g
s
.645 .562 .747 r
.40327 .64126 m .47773 .63455 L .44819 .68583 L closepath p F P
0 g
s
.644 .549 .733 r
.47773 .63455 m .40327 .64126 L .43176 .58506 L closepath p F P
0 g
s
.773 .619 .69 r
.61256 .5977 m .62919 .52532 L .6615 .57255 L closepath p F P
0 g
s
.786 .653 .716 r
.6615 .57255 m .64355 .63956 L .61256 .5977 L closepath p F P
0 g
s
.726 .646 .769 r
.52163 .67828 m .59269 .66676 L .55984 .71369 L closepath p F P
0 g
s
.761 .649 .739 r
.59269 .66676 m .61256 .5977 L .64355 .63956 L closepath p F P
0 g
s
.674 .6 .765 r
.52163 .67828 m .44819 .68583 L .47773 .63455 L closepath p F P
0 g
s
.748 .572 .657 r
.57418 .549 m .59031 .47525 L .62919 .52532 L closepath p F P
0 g
s
.734 .558 .654 r
.59031 .47525 m .57418 .549 L .53064 .49727 L closepath p F P
0 g
s
.762 .609 .688 r
.62919 .52532 m .61256 .5977 L .57418 .549 L closepath p F P
0 g
s
.725 .635 .758 r
.59269 .66676 m .52163 .67828 L .55545 .62513 L closepath p F P
0 g
s
.749 .637 .736 r
.61256 .5977 m .59269 .66676 L .55545 .62513 L closepath p F P
0 g
s
.7 .602 .743 r
.47773 .63455 m .55545 .62513 L .52163 .67828 L closepath p F P
0 g
s
.671 .552 .712 r
.43176 .58506 m .51203 .57627 L .47773 .63455 L closepath p F P
0 g
s
.669 .537 .695 r
.51203 .57627 m .43176 .58506 L .46624 .52439 L closepath p F P
0 g
s
.738 .606 .71 r
.55545 .62513 m .57418 .549 L .61256 .5977 L closepath p F P
0 g
s
.711 .556 .677 r
.51203 .57627 m .53064 .49727 L .57418 .549 L closepath p F P
0 g
s
.694 .54 .673 r
.53064 .49727 m .51203 .57627 L .46624 .52439 L closepath p F P
0 g
s
.699 .589 .729 r
.55545 .62513 m .47773 .63455 L .51203 .57627 L closepath p F P
0 g
s
.724 .592 .707 r
.57418 .549 m .55545 .62513 L .51203 .57627 L closepath p F P
0 g
s
.25 Mabswid
.67213 0 m
.92714 .41532 L
s
.92714 .41532 m
1 .94902 L
s
1 .94902 m
.70602 .58604 L
s
.70602 .58604 m
.67213 0 L
s
.08847 .24541 m
0 .80419 L
s
0 .80419 m
.70602 .58604 L
s
.70602 .58604 m
.67213 0 L
s
.67213 0 m
.08847 .24541 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.41.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.41.1"]
}, Open  ]],

Cell["\<\
Here is a an example of a polyhedron with edges truncated on each side by 40 \
percent. \
\>", "MathCaption",
 CellTags->{"S5.41.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
Show[Truncate[
        Polyhedron[Dodecahedron], .4]]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.41.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.03406 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0344789 1.12262 -4.06576e-18 1.12262 [
[ 0 0 0 0 ]
[ 1 1.03406 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0764 .24555 m
0 .73551 L
s
0 .73551 m
.40614 1.03406 L
s
.40614 1.03406 m
.42067 .59137 L
s
.42067 .59137 m
.0764 .24555 L
s
.67012 0 m
.93745 .42554 L
s
.93745 .42554 m
1 .89301 L
s
1 .89301 m
.69793 .51286 L
s
.69793 .51286 m
.67012 0 L
s
.0764 .24555 m
0 .73551 L
s
0 .73551 m
.69793 .51286 L
s
.69793 .51286 m
.67012 0 L
s
.67012 0 m
.0764 .24555 L
s
.42067 .59137 m
.93745 .42554 L
s
.93745 .42554 m
1 .89301 L
s
1 .89301 m
.40614 1.03406 L
s
.40614 1.03406 m
.42067 .59137 L
s
0 0 m
1 0 L
1 1.03406 L
0 1.03406 L
closepath
clip
newpath
.5 Mabswid
.754 .667 .765 r
.39968 .41249 m .53272 .45251 L .42478 .54837 L closepath p F P
0 g
s
.888 .749 .703 r
.42478 .54837 m .39968 .41249 L p .3003 .69494 L F P
0 g
s
.888 .749 .703 r
.41441 .59154 m .42478 .54837 L p .3003 .69494 L F P
0 g
s
.675 .526 .675 r
.42478 .54837 m .41441 .59154 L p .65274 .73266 L F P
0 g
s
.675 .526 .675 r
.53272 .45251 m .42478 .54837 L p .65274 .73266 L F P
0 g
s
.67 .731 .895 r
.53272 .45251 m .57676 .44741 L .68218 .37879 L p F P
0 g
s
.67 .731 .895 r
.39968 .41249 m .53272 .45251 L p .68218 .37879 L F P
0 g
s
.675 .526 .675 r
.57676 .44741 m .53272 .45251 L p .65274 .73266 L F P
0 g
s
.787 .578 .617 r
.41441 .59154 m .46876 .72387 L .33233 .68928 L closepath p F P
0 g
s
.888 .749 .703 r
.3003 .69494 m .33233 .68928 L .41441 .59154 L p F P
0 g
s
.675 .526 .675 r
.41441 .59154 m .46876 .72387 L p .65274 .73266 L F P
0 g
s
.599 .559 .781 r
.68218 .37879 m .70128 .51783 L .57676 .44741 L closepath p F P
0 g
s
.675 .526 .675 r
.70128 .51783 m .57676 .44741 L p .65274 .73266 L F P
0 g
s
.675 .526 .675 r
.46876 .72387 m .50686 .74685 L .65274 .73266 L p F P
0 g
s
.763 .374 .318 r
.46876 .72387 m .33233 .68928 L p .57345 .862 L F P
0 g
s
.763 .374 .318 r
.50686 .74685 m .46876 .72387 L p .57345 .862 L F P
0 g
s
.675 .526 .675 r
.71935 .55867 m .70128 .51783 L p .65274 .73266 L F P
0 g
s
.278 .316 .723 r
.70128 .51783 m .71935 .55867 L p .86126 .54889 L F P
0 g
s
.278 .316 .723 r
.68218 .37879 m .70128 .51783 L p .86126 .54889 L F P
0 g
s
.637 .373 .501 r
.65274 .73266 m .57711 .83829 L .50686 .74685 L closepath p F P
0 g
s
.763 .374 .318 r
.57345 .862 m .57711 .83829 L .50686 .74685 L p F P
0 g
s
.5 .357 .618 r
.71935 .55867 m .79959 .64158 L .68712 .70225 L closepath p F P
0 g
s
.675 .526 .675 r
.65274 .73266 m .68712 .70225 L .71935 .55867 L p F P
0 g
s
.278 .316 .723 r
.71935 .55867 m .79959 .64158 L p .86126 .54889 L F P
0 g
s
.67 .731 .895 r
.37588 .38638 m .39968 .41249 L p .68218 .37879 L F P
0 g
s
.888 .749 .703 r
.39968 .41249 m .37588 .38638 L p .3003 .69494 L F P
0 g
s
.25 0 .215 r
.65274 .73266 m .57711 .83829 L p .80253 .74643 L F P
0 g
s
.25 0 .215 r
.68712 .70225 m .65274 .73266 L p .80253 .74643 L F P
0 g
s
.25 0 .215 r
.79959 .64158 m .68712 .70225 L p .80253 .74643 L F P
0 g
s
.841 .881 .87 r
.38851 .28458 m .37588 .38638 L .27082 .38941 L closepath p F P
0 g
s
.67 .731 .895 r
.38851 .28458 m .37588 .38638 L p .68218 .37879 L F P
0 g
s
.888 .749 .703 r
.37588 .38638 m .27082 .38941 L p .3003 .69494 L F P
0 g
s
.763 .374 .318 r
.33233 .68928 m .3003 .69494 L p .57345 .862 L F P
0 g
s
.67 .731 .895 r
.42081 .26005 m .38851 .28458 L p .68218 .37879 L F P
0 g
s
.67 .731 .895 r
.57832 .23975 m .42081 .26005 L p .68218 .37879 L F P
0 g
s
.67 .731 .895 r
.62257 .25472 m .57832 .23975 L p .68218 .37879 L F P
0 g
s
.67 .731 .895 r
.68218 .37879 m .69088 .34821 L .62257 .25472 L p F P
0 g
s
.278 .316 .723 r
.69088 .34821 m .68218 .37879 L p .86126 .54889 L F P
0 g
s
.943 .622 .395 r
.3003 .69494 m .27053 .76498 L .21344 .61849 L closepath p F P
0 g
s
.888 .749 .703 r
.20337 .57332 m .21344 .61849 L .3003 .69494 L p F P
0 g
s
.888 .749 .703 r
.24215 .41918 m .20337 .57332 L p .3003 .69494 L F P
0 g
s
.888 .749 .703 r
.27082 .38941 m .24215 .41918 L p .3003 .69494 L F P
0 g
s
.763 .374 .318 r
.3003 .69494 m .27053 .76498 L p .57345 .862 L F P
0 g
s
.322 .558 .921 r
.69088 .34821 m .76107 .3297 L .62257 .25472 L closepath p F P
0 g
s
.278 .316 .723 r
.76107 .3297 m .69088 .34821 L p .86126 .54889 L F P
0 g
s
.25 0 .215 r
.57711 .83829 m .57345 .862 L p .80253 .74643 L F P
0 g
s
.278 .316 .723 r
.79959 .64158 m .82267 .64169 L .86126 .54889 L p F P
0 g
s
.25 0 .215 r
.82267 .64169 m .79959 .64158 L p .80253 .74643 L F P
0 g
s
.246 0 0 r
.57345 .862 m .63792 .87698 L .47396 .89146 L closepath p F P
0 g
s
.763 .374 .318 r
.42705 .88084 m .47396 .89146 L .57345 .862 L p F P
0 g
s
.763 .374 .318 r
.29009 .79539 m .42705 .88084 L p .57345 .862 L F P
0 g
s
.763 .374 .318 r
.27053 .76498 m .29009 .79539 L p .57345 .862 L F P
0 g
s
.25 0 .215 r
.57345 .862 m .63792 .87698 L p .80253 .74643 L F P
0 g
s
0 0 .135 r
.86126 .54889 m .82612 .71074 L .82267 .64169 L closepath p F P
0 g
s
.25 0 .215 r
.80253 .74643 m .82612 .71074 L .82267 .64169 L p F P
0 g
s
.927 .875 .451 r
.24215 .41918 m .207 .47441 L .20337 .57332 L closepath p F P
0 g
s
0 0 0 r
.27082 .38941 m .38851 .28458 L p .21989 .47098 L F P
0 g
s
0 0 0 r
.24215 .41918 m .27082 .38941 L p .21989 .47098 L F P
0 g
s
0 0 0 r
.38851 .28458 m .42081 .26005 L p .21989 .47098 L F P
0 g
s
0 0 0 r
.21989 .47098 m .207 .47441 L .24215 .41918 L p F P
0 g
s
0 .1 .63 r
.21344 .61849 m .20337 .57332 L p .29009 .79539 L F P
0 g
s
0 .1 .63 r
.29009 .79539 m .27053 .76498 L .21344 .61849 L p F P
0 g
s
.344 .811 .921 r
.57832 .23975 m .47619 .23469 L .42081 .26005 L closepath p F P
0 g
s
0 0 0 r
.42081 .26005 m .47619 .23469 L p .21989 .47098 L F P
0 g
s
.706 .202 .036 r
.62257 .25472 m .76107 .3297 L p .59998 .35655 L F P
0 g
s
.706 .202 .036 r
.57832 .23975 m .62257 .25472 L p .59998 .35655 L F P
0 g
s
0 .1 .63 r
.20337 .57332 m .207 .47441 L p .29009 .79539 L F P
0 g
s
.706 .202 .036 r
.47619 .23469 m .57832 .23975 L p .59998 .35655 L F P
0 g
s
.278 .316 .723 r
.78823 .35359 m .76107 .3297 L p .86126 .54889 L F P
0 g
s
.706 .202 .036 r
.76107 .3297 m .78823 .35359 L p .59998 .35655 L F P
0 g
s
0 .348 .792 r
.33809 .80649 m .42705 .88084 L .29009 .79539 L closepath p F P
0 g
s
0 .1 .63 r
.3418 .7787 m .33809 .80649 L .29009 .79539 L p F P
0 g
s
0 .1 .63 r
.30814 .61582 m .3418 .7787 L p .29009 .79539 L F P
0 g
s
0 .1 .63 r
.28769 .56458 m .30814 .61582 L p .29009 .79539 L F P
0 g
s
0 .1 .63 r
.21989 .47098 m .28769 .56458 L p .29009 .79539 L F P
0 g
s
0 .1 .63 r
.207 .47441 m .21989 .47098 L p .29009 .79539 L F P
0 g
s
.278 .316 .723 r
.86126 .54889 m .85596 .50125 L .78823 .35359 L p F P
0 g
s
.871 .479 .011 r
.78948 .40637 m .85596 .50125 L .78823 .35359 L closepath p F P
0 g
s
.706 .202 .036 r
.78823 .35359 m .78948 .40637 L p .59998 .35655 L F P
0 g
s
.25 0 .215 r
.63792 .87698 m .67546 .85866 L .80253 .74643 L p F P
0 g
s
.631 .776 .95 r
.47396 .89146 m .42705 .88084 L p .67546 .85866 L F P
0 g
s
.631 .776 .95 r
.67546 .85866 m .63792 .87698 L .47396 .89146 L p F P
0 g
s
.941 .802 .679 r
.86126 .54889 m .82612 .71074 L p .70821 .7715 L F P
0 g
s
.941 .802 .679 r
.85596 .50125 m .86126 .54889 L p .70821 .7715 L F P
0 g
s
.631 .776 .95 r
.42705 .88084 m .33809 .80649 L p .67546 .85866 L F P
0 g
s
.941 .802 .679 r
.78948 .40637 m .85596 .50125 L p .70821 .7715 L F P
0 g
s
.941 .802 .679 r
.82612 .71074 m .80253 .74643 L .70821 .7715 L p F P
0 g
s
.829 .984 .876 r
.80253 .74643 m .70821 .7715 L .67546 .85866 L closepath p F P
0 g
s
.631 .776 .95 r
.68439 .74571 m .70821 .7715 L .67546 .85866 L p F P
0 g
s
.631 .776 .95 r
.51916 .70291 m .68439 .74571 L p .67546 .85866 L F P
0 g
s
.631 .776 .95 r
.46226 .7086 m .51916 .70291 L p .67546 .85866 L F P
0 g
s
.631 .776 .95 r
.3418 .7787 m .46226 .7086 L p .67546 .85866 L F P
0 g
s
.631 .776 .95 r
.33809 .80649 m .3418 .7787 L p .67546 .85866 L F P
0 g
s
.706 .202 .036 r
.47 .24827 m .47619 .23469 L p .59998 .35655 L F P
0 g
s
0 0 0 r
.47619 .23469 m .47 .24827 L p .21989 .47098 L F P
0 g
s
.388 .242 .559 r
.33106 .38918 m .28769 .56458 L .21989 .47098 L closepath p F P
0 g
s
0 0 0 r
.37294 .35189 m .33106 .38918 L .21989 .47098 L p F P
0 g
s
0 0 0 r
.47 .24827 m .37294 .35189 L p .21989 .47098 L F P
0 g
s
.589 .267 .392 r
.47 .24827 m .55174 .32983 L .37294 .35189 L closepath p F P
0 g
s
.706 .202 .036 r
.59998 .35655 m .55174 .32983 L .47 .24827 L p F P
0 g
s
.706 .202 .036 r
.78948 .40637 m .76012 .40781 L .59998 .35655 L p F P
0 g
s
.941 .802 .679 r
.76012 .40781 m .78948 .40637 L p .70821 .7715 L F P
0 g
s
.552 .547 .803 r
.30814 .61582 m .46226 .7086 L .3418 .7787 L closepath p F P
0 g
s
.812 .574 .578 r
.76012 .40781 m .67272 .52208 L .59998 .35655 L closepath p F P
0 g
s
.941 .802 .679 r
.67272 .52208 m .76012 .40781 L p .70821 .7715 L F P
0 g
s
.941 .802 .679 r
.65996 .57818 m .67272 .52208 L p .70821 .7715 L F P
0 g
s
.941 .802 .679 r
.70821 .7715 m .68439 .74571 L .65996 .57818 L p F P
0 g
s
.665 .512 .666 r
.30814 .61582 m .28769 .56458 L .33106 .38918 L p F P
0 g
s
.665 .512 .666 r
.46226 .7086 m .30814 .61582 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.51916 .70291 m .46226 .7086 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.65996 .57818 m .51916 .70291 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.67272 .52208 m .65996 .57818 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.59998 .35655 m .67272 .52208 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.55174 .32983 m .59998 .35655 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.33106 .38918 m .37294 .35189 L .55174 .32983 L p F P
0 g
s
.768 .696 .783 r
.65996 .57818 m .68439 .74571 L .51916 .70291 L closepath p F P
0 g
s
.25 Mabswid
.67012 0 m
.93745 .42554 L
s
.93745 .42554 m
1 .89301 L
s
1 .89301 m
.69793 .51286 L
s
.69793 .51286 m
.67012 0 L
s
.0764 .24555 m
0 .73551 L
s
0 .73551 m
.69793 .51286 L
s
.69793 .51286 m
.67012 0 L
s
.67012 0 m
.0764 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.41.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.41.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["OpenTruncate", "MR"],
 " allows you to view the interior of the truncated polyhedron. "
}], "MathCaption",
 CellTags->{"S5.41.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
Show[OpenTruncate[
    Polyhedron[Dodecahedron], .4]]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.41.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.03406 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0344789 1.12262 -4.06576e-18 1.12262 [
[ 0 0 0 0 ]
[ 1 1.03406 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0764 .24555 m
0 .73551 L
s
0 .73551 m
.40614 1.03406 L
s
.40614 1.03406 m
.42067 .59137 L
s
.42067 .59137 m
.0764 .24555 L
s
.67012 0 m
.93745 .42554 L
s
.93745 .42554 m
1 .89301 L
s
1 .89301 m
.69793 .51286 L
s
.69793 .51286 m
.67012 0 L
s
.0764 .24555 m
0 .73551 L
s
0 .73551 m
.69793 .51286 L
s
.69793 .51286 m
.67012 0 L
s
.67012 0 m
.0764 .24555 L
s
.42067 .59137 m
.93745 .42554 L
s
.93745 .42554 m
1 .89301 L
s
1 .89301 m
.40614 1.03406 L
s
.40614 1.03406 m
.42067 .59137 L
s
0 0 m
1 0 L
1 1.03406 L
0 1.03406 L
closepath
clip
newpath
.5 Mabswid
.888 .749 .703 r
.42478 .54837 m .39968 .41249 L p .3003 .69494 L F P
0 g
s
.888 .749 .703 r
.41441 .59154 m .42478 .54837 L p .3003 .69494 L F P
0 g
s
.675 .526 .675 r
.42478 .54837 m .41441 .59154 L p .65274 .73266 L F P
0 g
s
.675 .526 .675 r
.53272 .45251 m .42478 .54837 L p .65274 .73266 L F P
0 g
s
.67 .731 .895 r
.53272 .45251 m .57676 .44741 L .68218 .37879 L p F P
0 g
s
.67 .731 .895 r
.39968 .41249 m .53272 .45251 L p .68218 .37879 L F P
0 g
s
.675 .526 .675 r
.57676 .44741 m .53272 .45251 L p .65274 .73266 L F P
0 g
s
.888 .749 .703 r
.3003 .69494 m .33233 .68928 L .41441 .59154 L p F P
0 g
s
.675 .526 .675 r
.41441 .59154 m .46876 .72387 L p .65274 .73266 L F P
0 g
s
.675 .526 .675 r
.70128 .51783 m .57676 .44741 L p .65274 .73266 L F P
0 g
s
.675 .526 .675 r
.46876 .72387 m .50686 .74685 L .65274 .73266 L p F P
0 g
s
.763 .374 .318 r
.46876 .72387 m .33233 .68928 L p .57345 .862 L F P
0 g
s
.763 .374 .318 r
.50686 .74685 m .46876 .72387 L p .57345 .862 L F P
0 g
s
.675 .526 .675 r
.71935 .55867 m .70128 .51783 L p .65274 .73266 L F P
0 g
s
.278 .316 .723 r
.70128 .51783 m .71935 .55867 L p .86126 .54889 L F P
0 g
s
.278 .316 .723 r
.68218 .37879 m .70128 .51783 L p .86126 .54889 L F P
0 g
s
.763 .374 .318 r
.57345 .862 m .57711 .83829 L .50686 .74685 L p F P
0 g
s
.675 .526 .675 r
.65274 .73266 m .68712 .70225 L .71935 .55867 L p F P
0 g
s
.278 .316 .723 r
.71935 .55867 m .79959 .64158 L p .86126 .54889 L F P
0 g
s
.67 .731 .895 r
.37588 .38638 m .39968 .41249 L p .68218 .37879 L F P
0 g
s
.888 .749 .703 r
.39968 .41249 m .37588 .38638 L p .3003 .69494 L F P
0 g
s
.25 0 .215 r
.65274 .73266 m .57711 .83829 L p .80253 .74643 L F P
0 g
s
.25 0 .215 r
.68712 .70225 m .65274 .73266 L p .80253 .74643 L F P
0 g
s
.25 0 .215 r
.79959 .64158 m .68712 .70225 L p .80253 .74643 L F P
0 g
s
.67 .731 .895 r
.38851 .28458 m .37588 .38638 L p .68218 .37879 L F P
0 g
s
.888 .749 .703 r
.37588 .38638 m .27082 .38941 L p .3003 .69494 L F P
0 g
s
.763 .374 .318 r
.33233 .68928 m .3003 .69494 L p .57345 .862 L F P
0 g
s
.67 .731 .895 r
.42081 .26005 m .38851 .28458 L p .68218 .37879 L F P
0 g
s
.67 .731 .895 r
.57832 .23975 m .42081 .26005 L p .68218 .37879 L F P
0 g
s
.67 .731 .895 r
.62257 .25472 m .57832 .23975 L p .68218 .37879 L F P
0 g
s
.67 .731 .895 r
.68218 .37879 m .69088 .34821 L .62257 .25472 L p F P
0 g
s
.278 .316 .723 r
.69088 .34821 m .68218 .37879 L p .86126 .54889 L F P
0 g
s
.888 .749 .703 r
.20337 .57332 m .21344 .61849 L .3003 .69494 L p F P
0 g
s
.888 .749 .703 r
.24215 .41918 m .20337 .57332 L p .3003 .69494 L F P
0 g
s
.888 .749 .703 r
.27082 .38941 m .24215 .41918 L p .3003 .69494 L F P
0 g
s
.763 .374 .318 r
.3003 .69494 m .27053 .76498 L p .57345 .862 L F P
0 g
s
.278 .316 .723 r
.76107 .3297 m .69088 .34821 L p .86126 .54889 L F P
0 g
s
.25 0 .215 r
.57711 .83829 m .57345 .862 L p .80253 .74643 L F P
0 g
s
.278 .316 .723 r
.79959 .64158 m .82267 .64169 L .86126 .54889 L p F P
0 g
s
.25 0 .215 r
.82267 .64169 m .79959 .64158 L p .80253 .74643 L F P
0 g
s
.763 .374 .318 r
.42705 .88084 m .47396 .89146 L .57345 .862 L p F P
0 g
s
.763 .374 .318 r
.29009 .79539 m .42705 .88084 L p .57345 .862 L F P
0 g
s
.763 .374 .318 r
.27053 .76498 m .29009 .79539 L p .57345 .862 L F P
0 g
s
.25 0 .215 r
.57345 .862 m .63792 .87698 L p .80253 .74643 L F P
0 g
s
.25 0 .215 r
.80253 .74643 m .82612 .71074 L .82267 .64169 L p F P
0 g
s
0 0 0 r
.27082 .38941 m .38851 .28458 L p .21989 .47098 L F P
0 g
s
0 0 0 r
.24215 .41918 m .27082 .38941 L p .21989 .47098 L F P
0 g
s
0 0 0 r
.38851 .28458 m .42081 .26005 L p .21989 .47098 L F P
0 g
s
0 0 0 r
.21989 .47098 m .207 .47441 L .24215 .41918 L p F P
0 g
s
0 .1 .63 r
.21344 .61849 m .20337 .57332 L p .29009 .79539 L F P
0 g
s
0 .1 .63 r
.29009 .79539 m .27053 .76498 L .21344 .61849 L p F P
0 g
s
0 0 0 r
.42081 .26005 m .47619 .23469 L p .21989 .47098 L F P
0 g
s
.706 .202 .036 r
.62257 .25472 m .76107 .3297 L p .59998 .35655 L F P
0 g
s
.706 .202 .036 r
.57832 .23975 m .62257 .25472 L p .59998 .35655 L F P
0 g
s
0 .1 .63 r
.20337 .57332 m .207 .47441 L p .29009 .79539 L F P
0 g
s
.706 .202 .036 r
.47619 .23469 m .57832 .23975 L p .59998 .35655 L F P
0 g
s
.278 .316 .723 r
.78823 .35359 m .76107 .3297 L p .86126 .54889 L F P
0 g
s
.706 .202 .036 r
.76107 .3297 m .78823 .35359 L p .59998 .35655 L F P
0 g
s
0 .1 .63 r
.3418 .7787 m .33809 .80649 L .29009 .79539 L p F P
0 g
s
0 .1 .63 r
.30814 .61582 m .3418 .7787 L p .29009 .79539 L F P
0 g
s
0 .1 .63 r
.28769 .56458 m .30814 .61582 L p .29009 .79539 L F P
0 g
s
0 .1 .63 r
.21989 .47098 m .28769 .56458 L p .29009 .79539 L F P
0 g
s
0 .1 .63 r
.207 .47441 m .21989 .47098 L p .29009 .79539 L F P
0 g
s
.706 .202 .036 r
.78823 .35359 m .78948 .40637 L p .59998 .35655 L F P
0 g
s
.278 .316 .723 r
.86126 .54889 m .85596 .50125 L .78823 .35359 L p F P
0 g
s
.25 0 .215 r
.63792 .87698 m .67546 .85866 L .80253 .74643 L p F P
0 g
s
.631 .776 .95 r
.47396 .89146 m .42705 .88084 L p .67546 .85866 L F P
0 g
s
.631 .776 .95 r
.67546 .85866 m .63792 .87698 L .47396 .89146 L p F P
0 g
s
.941 .802 .679 r
.86126 .54889 m .82612 .71074 L p .70821 .7715 L F P
0 g
s
.941 .802 .679 r
.85596 .50125 m .86126 .54889 L p .70821 .7715 L F P
0 g
s
.631 .776 .95 r
.42705 .88084 m .33809 .80649 L p .67546 .85866 L F P
0 g
s
.941 .802 .679 r
.78948 .40637 m .85596 .50125 L p .70821 .7715 L F P
0 g
s
.941 .802 .679 r
.82612 .71074 m .80253 .74643 L .70821 .7715 L p F P
0 g
s
.631 .776 .95 r
.68439 .74571 m .70821 .7715 L .67546 .85866 L p F P
0 g
s
.631 .776 .95 r
.51916 .70291 m .68439 .74571 L p .67546 .85866 L F P
0 g
s
.631 .776 .95 r
.46226 .7086 m .51916 .70291 L p .67546 .85866 L F P
0 g
s
.631 .776 .95 r
.3418 .7787 m .46226 .7086 L p .67546 .85866 L F P
0 g
s
.631 .776 .95 r
.33809 .80649 m .3418 .7787 L p .67546 .85866 L F P
0 g
s
.706 .202 .036 r
.47 .24827 m .47619 .23469 L p .59998 .35655 L F P
0 g
s
0 0 0 r
.47619 .23469 m .47 .24827 L p .21989 .47098 L F P
0 g
s
0 0 0 r
.37294 .35189 m .33106 .38918 L .21989 .47098 L p F P
0 g
s
0 0 0 r
.47 .24827 m .37294 .35189 L p .21989 .47098 L F P
0 g
s
.706 .202 .036 r
.59998 .35655 m .55174 .32983 L .47 .24827 L p F P
0 g
s
.706 .202 .036 r
.78948 .40637 m .76012 .40781 L .59998 .35655 L p F P
0 g
s
.941 .802 .679 r
.76012 .40781 m .78948 .40637 L p .70821 .7715 L F P
0 g
s
.941 .802 .679 r
.67272 .52208 m .76012 .40781 L p .70821 .7715 L F P
0 g
s
.941 .802 .679 r
.65996 .57818 m .67272 .52208 L p .70821 .7715 L F P
0 g
s
.941 .802 .679 r
.70821 .7715 m .68439 .74571 L .65996 .57818 L p F P
0 g
s
.665 .512 .666 r
.30814 .61582 m .28769 .56458 L .33106 .38918 L p F P
0 g
s
.665 .512 .666 r
.46226 .7086 m .30814 .61582 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.51916 .70291 m .46226 .7086 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.65996 .57818 m .51916 .70291 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.67272 .52208 m .65996 .57818 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.59998 .35655 m .67272 .52208 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.55174 .32983 m .59998 .35655 L p .33106 .38918 L F P
0 g
s
.665 .512 .666 r
.33106 .38918 m .37294 .35189 L .55174 .32983 L p F P
0 g
s
.25 Mabswid
.67012 0 m
.93745 .42554 L
s
.93745 .42554 m
1 .89301 L
s
1 .89301 m
.69793 .51286 L
s
.69793 .51286 m
.67012 0 L
s
.0764 .24555 m
0 .73551 L
s
0 .73551 m
.69793 .51286 L
s
.69793 .51286 m
.67012 0 L
s
.67012 0 m
.0764 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.41.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.41.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Polyhedron", "MR"],
 " converts the polygon list corresponding to the name of a polyhedron into a \
",
 StyleBox["Graphics3D", "MR"],
 " object. You can extract the polygon list from the ",
 StyleBox["Graphics3D", "MR"],
 " object using ",
 StyleBox["First", "MR"],
 ". In addition, ",
 StyleBox["Vertices", "MR"],
 " and ",
 StyleBox["Faces", "MR"],
 " give you the vertex coordinates and the vertices comprising each face of \
the polyhedra. "
}], "Text",
 CellTags->{"S5.41.1", "1.11"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["First[Polyhedron[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the list of polygons for the named polyhedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Vertices[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a list of the coordinates of the vertices of the polyhedron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Faces[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["polyname", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a list of the vertices associated with each face",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.41.1"],

Cell["Getting face and vertex data. ", "Caption",
 CellTags->"S5.41.1"],

Cell["\<\
Here is the list of polygons for the tetrahedron centered at the origin. \
\>", "MathCaption",
 CellTags->{"S5.41.1", "1.12"}],

Cell[CellGroupData[{

Cell["First[ Polyhedron[ Tetrahedron ] ]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.41.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "0.`", ",", "1.7320508075688772`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.632993161855452`", ",", 
        RowBox[{"-", "0.5773502691896257`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.4142135623730951`"}], ",", 
        RowBox[{"-", "0.816496580927726`"}], ",", 
        RowBox[{"-", "0.5773502691896257`"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "0.`", ",", "1.7320508075688772`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.4142135623730951`"}], ",", 
        RowBox[{"-", "0.816496580927726`"}], ",", 
        RowBox[{"-", "0.5773502691896257`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.4142135623730951`", ",", 
        RowBox[{"-", "0.816496580927726`"}], ",", 
        RowBox[{"-", "0.5773502691896257`"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "0.`", ",", "1.7320508075688772`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.4142135623730951`", ",", 
        RowBox[{"-", "0.816496580927726`"}], ",", 
        RowBox[{"-", "0.5773502691896257`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.632993161855452`", ",", 
        RowBox[{"-", "0.5773502691896257`"}]}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.632993161855452`", ",", 
        RowBox[{"-", "0.5773502691896257`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.4142135623730951`", ",", 
        RowBox[{"-", "0.816496580927726`"}], ",", 
        RowBox[{"-", "0.5773502691896257`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.4142135623730951`"}], ",", 
        RowBox[{"-", "0.816496580927726`"}], ",", 
        RowBox[{"-", "0.5773502691896257`"}]}], "}"}]}], "}"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.41.1"]
}, Open  ]],

Cell["These are the vertices of the tetrahedron. ", "MathCaption",
 CellTags->{"S5.41.1", "1.13"}],

Cell[CellGroupData[{

Cell["Vertices[ Tetrahedron ]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.41.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     SqrtBox["3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox["2", "3"]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox["2"]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "3"]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox["2"], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "3"]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["3"]]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.41.1"]
}, Open  ]],

Cell["\<\
This shows which vertices are associated with which face. For example, the \
second face has the first, third, and fourth vertices as its corners.\
\>", "MathCaption",
 CellTags->{"S5.41.1", "1.14"}],

Cell[CellGroupData[{

Cell["Faces[ Tetrahedron ]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.41.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.41.1"]
}, Open  ]],

Cell[TextData[{
 "Note that the geometry data for the regular polyhedra is actually found in \
the standard package ",
 StyleBox["Geometry`Polytopes`", "MR"],
 ". All of the functionality of that package is loaded and available to you. \
"
}], "Text",
 CellTags->{"S5.41.1", "1.15"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.41.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.41.1", "1.1"}],
    Cell[1913, 61, 364, 7, 56, "Text",
      CellTags->{"S5.41.1", "1.2"}],
    Cell[2280, 70, 3200, 100, 84, "DefinitionBox",
      CellTags->"S5.41.1"],
    Cell[5483, 172, 75, 1, 15, "Caption",
      CellTags->"S5.41.1"],
    Cell[5561, 175, 1960, 52, 130, "DefinitionBox",
      CellTags->"S5.41.1"],
    Cell[7524, 229, 51, 1, 15, "Caption",
      CellTags->"S5.41.1"],
    Cell[7578, 232, 78, 1, 40, "MathCaption",
      CellTags->{"S5.41.1", "1.3"}],
    Cell[7659, 235, 84, 2, 28, "Input",
      CellTags->"S5.41.1"],
    Cell[7746, 239, 107, 1, 40, "MathCaption",
      CellTags->{"S5.41.1", "1.4"}],
    Cell[7878, 244, 96, 2, 28, "Input",
      CellTags->"S5.41.1"],
    Cell[7977, 248, 44589, 761, 186, 4088, 257, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.41.1"],
    Cell[52569, 1011, 182, 6, 70, "Output",
      CellTags->"S5.41.1"],
    Cell[52766, 1020, 329, 12, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.5"}],
    Cell[53120, 1036, 166, 7, 70, "Input",
      CellTags->"S5.41.1"],
    Cell[53289, 1045, 8235, 436, 70, 8164, 433, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.41.1"],
    Cell[61527, 1483, 182, 6, 70, "Output",
      CellTags->"S5.41.1"],
    Cell[61724, 1492, 9574, 292, 70, "DefinitionBox",
      CellTags->"S5.41.1"],
    Cell[71301, 1786, 93, 1, 70, "Caption",
      CellTags->"S5.41.1"],
    Cell[71397, 1789, 1632, 42, 70, "Text",
      CellTags->{"S5.41.1", "1.6"}],
    Cell[73032, 1833, 281, 7, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.7"}],
    Cell[73338, 1844, 106, 2, 70, "Input",
      CellTags->"S5.41.1"],
    Cell[73447, 1848, 3503, 212, 70, 3432, 209, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.41.1"],
    Cell[76953, 2062, 182, 6, 70, "Output",
      CellTags->"S5.41.1"],
    Cell[77150, 2071, 174, 4, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.8"}],
    Cell[77349, 2079, 107, 2, 70, "Input",
      CellTags->"S5.41.1"],
    Cell[77459, 2083, 83138, 3956, 70, 83067, 3953, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.41.1"],
    Cell[160600, 6041, 182, 6, 70, "Output",
      CellTags->"S5.41.1"],
    Cell[160797, 6050, 150, 4, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.9"}],
    Cell[160972, 6058, 124, 5, 70, "Input",
      CellTags->"S5.41.1"],
    Cell[161099, 6065, 10304, 580, 70, 10233, 577, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.41.1"],
    Cell[171406, 6647, 182, 6, 70, "Output",
      CellTags->"S5.41.1"],
    Cell[171603, 6656, 165, 4, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.10"}],
    Cell[171793, 6664, 124, 5, 70, "Input",
      CellTags->"S5.41.1"],
    Cell[171920, 6671, 8595, 500, 70, 8524, 497, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.41.1"],
    Cell[180518, 7173, 182, 6, 70, "Output",
      CellTags->"S5.41.1"],
    Cell[180715, 7182, 516, 16, 70, "Text",
      CellTags->{"S5.41.1", "1.11"}],
    Cell[181234, 7200, 2302, 69, 70, "DefinitionBox",
      CellTags->"S5.41.1"],
    Cell[183539, 7271, 71, 1, 70, "Caption",
      CellTags->"S5.41.1"],
    Cell[183613, 7274, 136, 3, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.12"}],
    Cell[183774, 7281, 97, 2, 70, "Input",
      CellTags->"S5.41.1"],
    Cell[183874, 7285, 2233, 59, 70, "Output",
      CellTags->"S5.41.1"],
    Cell[186122, 7347, 98, 1, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.13"}],
    Cell[186245, 7352, 86, 2, 70, "Input",
      CellTags->"S5.41.1"],
    Cell[186334, 7356, 825, 34, 70, "Output",
      CellTags->"S5.41.1"],
    Cell[187174, 7393, 209, 4, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.14"}],
    Cell[187408, 7401, 84, 2, 70, "Input",
      CellTags->"S5.41.1"],
    Cell[187495, 7405, 376, 12, 70, "Output",
      CellTags->"S5.41.1"],
    Cell[187886, 7420, 283, 7, 70, "Text",
      CellTags->{"S5.41.1", "1.15"}]},
  "1.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.41.1", "1.1"}]},
  "1.2"->{
    Cell[1913, 61, 364, 7, 56, "Text",
      CellTags->{"S5.41.1", "1.2"}]},
  "1.3"->{
    Cell[7578, 232, 78, 1, 40, "MathCaption",
      CellTags->{"S5.41.1", "1.3"}]},
  "1.4"->{
    Cell[7746, 239, 107, 1, 40, "MathCaption",
      CellTags->{"S5.41.1", "1.4"}]},
  "1.5"->{
    Cell[52766, 1020, 329, 12, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.5"}]},
  "1.6"->{
    Cell[71397, 1789, 1632, 42, 70, "Text",
      CellTags->{"S5.41.1", "1.6"}]},
  "1.7"->{
    Cell[73032, 1833, 281, 7, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.7"}]},
  "1.8"->{
    Cell[77150, 2071, 174, 4, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.8"}]},
  "1.9"->{
    Cell[160797, 6050, 150, 4, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.9"}]},
  "1.10"->{
    Cell[171603, 6656, 165, 4, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.10"}]},
  "1.11"->{
    Cell[180715, 7182, 516, 16, 70, "Text",
      CellTags->{"S5.41.1", "1.11"}]},
  "1.12"->{
    Cell[183613, 7274, 136, 3, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.12"}]},
  "1.13"->{
    Cell[186122, 7347, 98, 1, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.13"}]},
  "1.14"->{
    Cell[187174, 7393, 209, 4, 70, "MathCaption",
      CellTags->{"S5.41.1", "1.14"}]},
  "1.15"->{
    Cell[187886, 7420, 283, 7, 70, "Text",
      CellTags->{"S5.41.1", "1.15"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.41.1", 188808, 7446},
  {"1.1", 192954, 7554},
  {"1.2", 193048, 7557},
  {"1.3", 193136, 7560},
  {"1.4", 193231, 7563},
  {"1.5", 193327, 7566},
  {"1.6", 193426, 7569},
  {"1.7", 193519, 7572},
  {"1.8", 193617, 7575},
  {"1.9", 193715, 7578},
  {"1.10", 193815, 7581},
  {"1.11", 193916, 7584},
  {"1.12", 194011, 7587},
  {"1.13", 194112, 7590},
  {"1.14", 194212, 7593},
  {"1.15", 194313, 7596}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 6, 36, "Subsection",
  CellTags->{"S5.41.1", "1.1"}],
Cell[1913, 61, 364, 7, 56, "Text",
  CellTags->{"S5.41.1", "1.2"}],
Cell[2280, 70, 3200, 100, 84, "DefinitionBox",
  CellTags->"S5.41.1"],
Cell[5483, 172, 75, 1, 15, "Caption",
  CellTags->"S5.41.1"],
Cell[5561, 175, 1960, 52, 130, "DefinitionBox",
  CellTags->"S5.41.1"],
Cell[7524, 229, 51, 1, 15, "Caption",
  CellTags->"S5.41.1"],
Cell[7578, 232, 78, 1, 40, "MathCaption",
  CellTags->{"S5.41.1", "1.3"}],
Cell[7659, 235, 84, 2, 28, "Input",
  CellTags->"S5.41.1"],
Cell[7746, 239, 107, 1, 40, "MathCaption",
  CellTags->{"S5.41.1", "1.4"}],

Cell[CellGroupData[{
Cell[7878, 244, 96, 2, 28, "Input",
  CellTags->"S5.41.1"],
Cell[7977, 248, 44589, 761, 186, 4088, 257, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S5.41.1"],
Cell[52569, 1011, 182, 6, 70, "Output",
  CellTags->"S5.41.1"]
}, Open  ]],
Cell[52766, 1020, 329, 12, 70, "MathCaption",
  CellTags->{"S5.41.1", "1.5"}],

Cell[CellGroupData[{
Cell[53120, 1036, 166, 7, 70, "Input",
  CellTags->"S5.41.1"],
Cell[53289, 1045, 8235, 436, 70, 8164, 433, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.41.1"],
Cell[61527, 1483, 182, 6, 70, "Output",
  CellTags->"S5.41.1"]
}, Open  ]],
Cell[61724, 1492, 9574, 292, 70, "DefinitionBox",
  CellTags->"S5.41.1"],
Cell[71301, 1786, 93, 1, 70, "Caption",
  CellTags->"S5.41.1"],
Cell[71397, 1789, 1632, 42, 70, "Text",
  CellTags->{"S5.41.1", "1.6"}],
Cell[73032, 1833, 281, 7, 70, "MathCaption",
  CellTags->{"S5.41.1", "1.7"}],

Cell[CellGroupData[{
Cell[73338, 1844, 106, 2, 70, "Input",
  CellTags->"S5.41.1"],
Cell[73447, 1848, 3503, 212, 70, 3432, 209, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.41.1"],
Cell[76953, 2062, 182, 6, 70, "Output",
  CellTags->"S5.41.1"]
}, Open  ]],
Cell[77150, 2071, 174, 4, 70, "MathCaption",
  CellTags->{"S5.41.1", "1.8"}],

Cell[CellGroupData[{
Cell[77349, 2079, 107, 2, 70, "Input",
  CellTags->"S5.41.1"],
Cell[77459, 2083, 83138, 3956, 70, 83067, 3953, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.41.1"],
Cell[160600, 6041, 182, 6, 70, "Output",
  CellTags->"S5.41.1"]
}, Open  ]],
Cell[160797, 6050, 150, 4, 70, "MathCaption",
  CellTags->{"S5.41.1", "1.9"}],

Cell[CellGroupData[{
Cell[160972, 6058, 124, 5, 70, "Input",
  CellTags->"S5.41.1"],
Cell[161099, 6065, 10304, 580, 70, 10233, 577, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.41.1"],
Cell[171406, 6647, 182, 6, 70, "Output",
  CellTags->"S5.41.1"]
}, Open  ]],
Cell[171603, 6656, 165, 4, 70, "MathCaption",
  CellTags->{"S5.41.1", "1.10"}],

Cell[CellGroupData[{
Cell[171793, 6664, 124, 5, 70, "Input",
  CellTags->"S5.41.1"],
Cell[171920, 6671, 8595, 500, 70, 8524, 497, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.41.1"],
Cell[180518, 7173, 182, 6, 70, "Output",
  CellTags->"S5.41.1"]
}, Open  ]],
Cell[180715, 7182, 516, 16, 70, "Text",
  CellTags->{"S5.41.1", "1.11"}],
Cell[181234, 7200, 2302, 69, 70, "DefinitionBox",
  CellTags->"S5.41.1"],
Cell[183539, 7271, 71, 1, 70, "Caption",
  CellTags->"S5.41.1"],
Cell[183613, 7274, 136, 3, 70, "MathCaption",
  CellTags->{"S5.41.1", "1.12"}],

Cell[CellGroupData[{
Cell[183774, 7281, 97, 2, 70, "Input",
  CellTags->"S5.41.1"],
Cell[183874, 7285, 2233, 59, 70, "Output",
  CellTags->"S5.41.1"]
}, Open  ]],
Cell[186122, 7347, 98, 1, 70, "MathCaption",
  CellTags->{"S5.41.1", "1.13"}],

Cell[CellGroupData[{
Cell[186245, 7352, 86, 2, 70, "Input",
  CellTags->"S5.41.1"],
Cell[186334, 7356, 825, 34, 70, "Output",
  CellTags->"S5.41.1"]
}, Open  ]],
Cell[187174, 7393, 209, 4, 70, "MathCaption",
  CellTags->{"S5.41.1", "1.14"}],

Cell[CellGroupData[{
Cell[187408, 7401, 84, 2, 70, "Input",
  CellTags->"S5.41.1"],
Cell[187495, 7405, 376, 12, 70, "Output",
  CellTags->"S5.41.1"]
}, Open  ]],
Cell[187886, 7420, 283, 7, 70, "Text",
  CellTags->{"S5.41.1", "1.15"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

