(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13234,        477]*)
(*NotebookOutlinePosition[     16920,        592]*)
(*  CellTagsIndexPosition[     16617,        576]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "PolynomialExtendedGCD",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.5.1", "1.1"}],

Cell[TextData[{
 StyleBox["PolynomialExtendedGCD", "MR"],
 " gives the extended greatest common divisor for two univariate polynomials. \
The ",
 StyleBox["Mathematica", "TI"],
 " kernel has the functions ",
 StyleBox["GCD", "MR"],
 " and ",
 StyleBox["ExtendedGCD", "MR"],
 " for integers, and the function ",
 StyleBox["PolynomialGCD", "MR"],
 " for multivariate polynomials over the rationals. The function defined in \
this package works not only for polynomials over the rationals, but also for \
polynomials over the integers mod prime ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and for polynomials with coefficients in a finite field defined by the \
package ",
 StyleBox["Algebra`FiniteFields`", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.5.1", "1.2"}],

Cell[TextData[{
 "In a Euclidean domain, such as addition and multiplication on the integers, \
or addition and multiplication on univariate polynomials with coefficients in \
some field, it is possible to write the gcd of two elements as a linear \
combination of the two elements. The extended gcd gives the coefficients of \
the linear combination. ",
 StyleBox["PolynomialExtendedGCD[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["poly",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["poly",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["]", "MR"],
 " gives the list ",
 StyleBox["{", "MR"],
 StyleBox["gcd", "TI"],
 StyleBox[", {", "MR"],
 StyleBox["r", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["s", "TI"],
 StyleBox["}}", "MR"],
 " where ",
 StyleBox["gcd", "TI"],
 " is the greatest common divisor of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["poly",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["poly",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["s",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are polynomials such that ",
 StyleBox["r", "TI"],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["poly",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" + ", "MR"],
 StyleBox["s", "TI"],
 StyleBox[" ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["poly",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[" = ", "MR"],
 StyleBox["gcd", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.5.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PolynomialExtendedGCD[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the extended gcd of the two univariate polynomials ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" over the rationals, gaussian rationals, or finite fields",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PolynomialExtendedGCD[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Modulus->", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the extended gcd of two univariate polynomials over the integers \
mod prime ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.5.1"],

Cell["Polynomial greatest common divisor.", "Caption",
 CellTags->"S5.5.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.5.1", "1.4"}],

Cell["<<Algebra`PolynomialExtendedGCD`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.5.1"],

Cell["Here is an example over the integers mod 7. ", "MathCaption",
 CellTags->{"S5.5.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
PolynomialExtendedGCD[x^2 + 2 x + 1,
 Expand[(x + 1)(x + 2)], Modulus->7]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.5.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.5.1"]
}, Open  ]],

Cell["Here is the same example over the rationals. ", "MathCaption",
 CellTags->{"S5.5.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
PolynomialExtendedGCD[x^2 + 2 x + 1,
 Expand[(x + 1)(x + 2)]]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.5.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.5.1"]
}, Open  ]],

Cell[TextData[{
 "Load the ",
 StyleBox["Algebra`FiniteFields`", "MR"],
 " package. "
}], "MathCaption",
 CellTags->{"S5.5.1", "1.7"}],

Cell["<<Algebra`FiniteFields`", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.5.1"],

Cell[TextData[{
 "Here is the example over the field ",
 StyleBox["GF[7]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.5.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
PolynomialExtendedGCD[
 x^2 + GF[7][{2}] x + GF[7][{1}],
 Expand[(x + GF[7][{1}])(x + GF[7][{2}])]]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.5.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    InterpretationBox[
     SubscriptBox[
      RowBox[{"{", "1", "}"}], "7"],
     Subscripted[
      {1}[7]],
     Editable->False], "+", 
    RowBox[{"x", " ", 
     InterpretationBox[
      SubscriptBox[
       RowBox[{"{", "1", "}"}], "7"],
      Subscripted[
       {1}[7]],
      Editable->False]}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      SubscriptBox[
       RowBox[{"{", "6", "}"}], "7"],
      Subscripted[
       {6}[7]],
      Editable->False], ",", 
     InterpretationBox[
      SubscriptBox[
       RowBox[{"{", "1", "}"}], "7"],
      Subscripted[
       {1}[7]],
      Editable->False]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.5.1"]
}, Open  ]],

Cell[TextData[{
 "Note that the kernel function ",
 StyleBox["PolynomialGCD", "MR"],
 " does not work for polynomials over finite fields. Apply ",
 StyleBox["First", "MR"],
 " to the result of ",
 StyleBox["PolynomialExtendedGCD", "MR"],
 " instead. "
}], "MathCaption",
 CellTags->{"S5.5.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
PolynomialGCD[x^2 + GF[7][{2}] x + GF[7][{1}],
 Expand[(x + GF[7][{1}])(x + GF[7][{2}])]]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.5.1"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.5.1"]
}, Open  ]],

Cell["Here the polynomial coefficients are Gaussian integers. ", "MathCaption",
 CellTags->{"S5.5.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
PolynomialExtendedGCD[
  Expand[ ((12+I) z^2 + 7 z + I) (I z + 3)],
  Expand[ ((9+2I) z + (3+I)) ((3I)z + 9)]
]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.5.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1672", "3469"]}], "+", 
      FractionBox[
       RowBox[{"1489", " ", "\[ImaginaryI]"}], "3469"]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["89", "3469"], "-", 
        FractionBox[
         RowBox[{"688", " ", "\[ImaginaryI]"}], "10407"]}], ")"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1901", "10407"], "-", 
         FractionBox[
          RowBox[{"2222", " ", "\[ImaginaryI]"}], "10407"]}], ")"}], " ", 
       "z"}]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.5.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.5.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.5.1", "1.1"}],
    Cell[1923, 61, 858, 24, 104, "Text",
      CellTags->{"S5.5.1", "1.2"}],
    Cell[2784, 87, 2226, 79, 107, "Text",
      CellTags->{"S5.5.1", "1.3"}],
    Cell[5013, 168, 3960, 119, 120, "DefinitionBox",
      CellTags->"S5.5.1"],
    Cell[8976, 289, 75, 1, 15, "Caption",
      CellTags->"S5.5.1"],
    Cell[9054, 292, 77, 1, 40, "MathCaption",
      CellTags->{"S5.5.1", "1.4"}],
    Cell[9134, 295, 94, 2, 28, "Input",
      CellTags->"S5.5.1"],
    Cell[9231, 299, 97, 1, 40, "MathCaption",
      CellTags->{"S5.5.1", "1.5"}],
    Cell[9353, 304, 143, 5, 45, "Input",
      CellTags->"S5.5.1"],
    Cell[9499, 311, 191, 7, 25, "Output",
      CellTags->"S5.5.1"],
    Cell[9705, 321, 98, 1, 40, "MathCaption",
      CellTags->{"S5.5.1", "1.6"}],
    Cell[9828, 326, 131, 5, 45, "Input",
      CellTags->"S5.5.1"],
    Cell[9962, 333, 212, 8, 70, "Output",
      CellTags->"S5.5.1"],
    Cell[10189, 344, 134, 5, 70, "MathCaption",
      CellTags->{"S5.5.1", "1.7"}],
    Cell[10326, 351, 85, 2, 70, "Input",
      CellTags->"S5.5.1"],
    Cell[10414, 355, 136, 5, 70, "MathCaption",
      CellTags->{"S5.5.1", "1.8"}],
    Cell[10575, 364, 169, 6, 70, "Input",
      CellTags->"S5.5.1"],
    Cell[10747, 372, 758, 32, 70, "Output",
      CellTags->"S5.5.1"],
    Cell[11520, 407, 300, 9, 70, "MathCaption",
      CellTags->{"S5.5.1", "1.9"}],
    Cell[11845, 420, 159, 5, 70, "Input",
      CellTags->"S5.5.1"],
    Cell[12007, 427, 73, 2, 70, "Output",
      CellTags->"S5.5.1"],
    Cell[12095, 432, 110, 1, 70, "MathCaption",
      CellTags->{"S5.5.1", "1.10"}],
    Cell[12230, 437, 181, 7, 70, "Input",
      CellTags->"S5.5.1"],
    Cell[12414, 446, 792, 27, 70, "Output",
      CellTags->"S5.5.1"]},
  "1.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.5.1", "1.1"}]},
  "1.2"->{
    Cell[1923, 61, 858, 24, 104, "Text",
      CellTags->{"S5.5.1", "1.2"}]},
  "1.3"->{
    Cell[2784, 87, 2226, 79, 107, "Text",
      CellTags->{"S5.5.1", "1.3"}]},
  "1.4"->{
    Cell[9054, 292, 77, 1, 40, "MathCaption",
      CellTags->{"S5.5.1", "1.4"}]},
  "1.5"->{
    Cell[9231, 299, 97, 1, 40, "MathCaption",
      CellTags->{"S5.5.1", "1.5"}]},
  "1.6"->{
    Cell[9705, 321, 98, 1, 40, "MathCaption",
      CellTags->{"S5.5.1", "1.6"}]},
  "1.7"->{
    Cell[10189, 344, 134, 5, 70, "MathCaption",
      CellTags->{"S5.5.1", "1.7"}]},
  "1.8"->{
    Cell[10414, 355, 136, 5, 70, "MathCaption",
      CellTags->{"S5.5.1", "1.8"}]},
  "1.9"->{
    Cell[11520, 407, 300, 9, 70, "MathCaption",
      CellTags->{"S5.5.1", "1.9"}]},
  "1.10"->{
    Cell[12095, 432, 110, 1, 70, "MathCaption",
      CellTags->{"S5.5.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.5.1", 13856, 493},
  {"1.1", 15663, 542},
  {"1.2", 15756, 545},
  {"1.3", 15845, 548},
  {"1.4", 15935, 551},
  {"1.5", 16029, 554},
  {"1.6", 16123, 557},
  {"1.7", 16217, 560},
  {"1.8", 16313, 563},
  {"1.9", 16409, 566},
  {"1.10", 16506, 569}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 144, 6, 36, "Subsection",
  CellTags->{"S5.5.1", "1.1"}],
Cell[1923, 61, 858, 24, 104, "Text",
  CellTags->{"S5.5.1", "1.2"}],
Cell[2784, 87, 2226, 79, 107, "Text",
  CellTags->{"S5.5.1", "1.3"}],
Cell[5013, 168, 3960, 119, 120, "DefinitionBox",
  CellTags->"S5.5.1"],
Cell[8976, 289, 75, 1, 15, "Caption",
  CellTags->"S5.5.1"],
Cell[9054, 292, 77, 1, 40, "MathCaption",
  CellTags->{"S5.5.1", "1.4"}],
Cell[9134, 295, 94, 2, 28, "Input",
  CellTags->"S5.5.1"],
Cell[9231, 299, 97, 1, 40, "MathCaption",
  CellTags->{"S5.5.1", "1.5"}],

Cell[CellGroupData[{
Cell[9353, 304, 143, 5, 45, "Input",
  CellTags->"S5.5.1"],
Cell[9499, 311, 191, 7, 25, "Output",
  CellTags->"S5.5.1"]
}, Open  ]],
Cell[9705, 321, 98, 1, 40, "MathCaption",
  CellTags->{"S5.5.1", "1.6"}],

Cell[CellGroupData[{
Cell[9828, 326, 131, 5, 45, "Input",
  CellTags->"S5.5.1"],
Cell[9962, 333, 212, 8, 70, "Output",
  CellTags->"S5.5.1"]
}, Open  ]],
Cell[10189, 344, 134, 5, 70, "MathCaption",
  CellTags->{"S5.5.1", "1.7"}],
Cell[10326, 351, 85, 2, 70, "Input",
  CellTags->"S5.5.1"],
Cell[10414, 355, 136, 5, 70, "MathCaption",
  CellTags->{"S5.5.1", "1.8"}],

Cell[CellGroupData[{
Cell[10575, 364, 169, 6, 70, "Input",
  CellTags->"S5.5.1"],
Cell[10747, 372, 758, 32, 70, "Output",
  CellTags->"S5.5.1"]
}, Open  ]],
Cell[11520, 407, 300, 9, 70, "MathCaption",
  CellTags->{"S5.5.1", "1.9"}],

Cell[CellGroupData[{
Cell[11845, 420, 159, 5, 70, "Input",
  CellTags->"S5.5.1"],
Cell[12007, 427, 73, 2, 70, "Output",
  CellTags->"S5.5.1"]
}, Open  ]],
Cell[12095, 432, 110, 1, 70, "MathCaption",
  CellTags->{"S5.5.1", "1.10"}],

Cell[CellGroupData[{
Cell[12230, 437, 181, 7, 70, "Input",
  CellTags->"S5.5.1"],
Cell[12414, 446, 792, 27, 70, "Output",
  CellTags->"S5.5.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

