(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6608,        214]*)
(*NotebookOutlinePosition[      9341,        301]*)
(*  CellTagsIndexPosition[      9115,        288]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "PolynomialFit",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.92.1", "1.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " function ",
 StyleBox["Fit", "MR"],
 " does linear least squares fitting to data. It allows any combination of \
basis functions. However, it is often the case that you want to do polynomial \
fitting and it would be easier if you did not have to explicitly list the \
basis functions. In addition, for high\[Hyphen]degree fitting, things often \
get rather unstable numerically if you give simple powers of a variable as \
basis functions. ",
 StyleBox["PolynomialFit", "MR"],
 " avoids these problems. "
}], "Text",
 CellTags->{"S5.92.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PolynomialFit[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the least squares ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" degree polynomial fit to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.92.1"],

Cell["Fitting polynomials to data. ", "Caption",
 CellTags->"S5.92.1"],

Cell[TextData[{
 StyleBox["PolynomialFit", "MR"],
 " uses the function ",
 StyleBox["Fit", "MR"],
 ", but it chooses a more appropriate set of basis functions than simple \
powers of a variable. It also returns a pure function rather than an \
expression and evaluates the function in a numerically stable way. If you \
want, you can evaluate the function at a symbolic point and expand the result \
to get an ordinary looking polynomial, but this is ",
 StyleBox["not", "TI"],
 " advised; doing so will result in something that could be numerically very \
unstable. That is, extreme loss of accuracy could result due to cancellation \
of digits. "
}], "Text",
 CellTags->{"S5.92.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.92.1", "1.4"}],

Cell["<<NumericalMath`PolynomialFit`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.92.1"],

Cell["Here is the cubic polynomial that fits the data. ", "MathCaption",
 CellTags->{"S5.92.1", "1.5"}],

Cell[CellGroupData[{

Cell["p = PolynomialFit[{1,4,9,16,25,36,49},3]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.92.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"FittingPolynomial[<>, \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm["FittingPolynomial[<>, ", 3, "]"],
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.92.1"]
}, Open  ]],

Cell["This evaluates the polynomial at 10. ", "MathCaption",
 CellTags->{"S5.92.1", "1.6"}],

Cell[CellGroupData[{

Cell["p[10]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.92.1"],

Cell[BoxData["100.`"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.92.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the ordinary form of the polynomial. Doing this and then \
replacing ",
 StyleBox["x", "MR"],
 " by some numerical value is not advised, especially for high\[Hyphen]degree \
polynomials. "
}], "MathCaption",
 CellTags->{"S5.92.1", "1.7"}],

Cell[CellGroupData[{

Cell["Expand[p[x]]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.92.1"],

Cell[BoxData[
 RowBox[{"1.80700362`-9.301043925751605*^-20", "+", 
  RowBox[{"0``10.750441082085109", " ", "x"}], "+", 
  RowBox[{"1.`11.46874554029305", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"0``12.607004876855806", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.92.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.92.1"->{
    Cell[1776, 53, 143, 6, 36, "Subsection",
      CellTags->{"S5.92.1", "1.1"}],
    Cell[1922, 61, 608, 14, 88, "Text",
      CellTags->{"S5.92.1", "1.2"}],
    Cell[2533, 77, 1604, 49, 46, "DefinitionBox",
      CellTags->"S5.92.1"],
    Cell[4140, 128, 70, 1, 15, "Caption",
      CellTags->"S5.92.1"],
    Cell[4213, 131, 691, 14, 104, "Text",
      CellTags->{"S5.92.1", "1.3"}],
    Cell[4907, 147, 78, 1, 40, "MathCaption",
      CellTags->{"S5.92.1", "1.4"}],
    Cell[4988, 150, 93, 2, 28, "Input",
      CellTags->"S5.92.1"],
    Cell[5084, 154, 103, 1, 40, "MathCaption",
      CellTags->{"S5.92.1", "1.5"}],
    Cell[5212, 159, 103, 2, 28, "Input",
      CellTags->"S5.92.1"],
    Cell[5318, 163, 270, 7, 25, "Output",
      CellTags->"S5.92.1"],
    Cell[5603, 173, 91, 1, 40, "MathCaption",
      CellTags->{"S5.92.1", "1.6"}],
    Cell[5719, 178, 68, 2, 28, "Input",
      CellTags->"S5.92.1"],
    Cell[5790, 182, 78, 2, 25, "Output",
      CellTags->"S5.92.1"],
    Cell[5883, 187, 267, 7, 56, "MathCaption",
      CellTags->{"S5.92.1", "1.7"}],
    Cell[6175, 198, 75, 2, 28, "Input",
      CellTags->"S5.92.1"],
    Cell[6253, 202, 327, 8, 70, "Output",
      CellTags->"S5.92.1"]},
  "1.1"->{
    Cell[1776, 53, 143, 6, 36, "Subsection",
      CellTags->{"S5.92.1", "1.1"}]},
  "1.2"->{
    Cell[1922, 61, 608, 14, 88, "Text",
      CellTags->{"S5.92.1", "1.2"}]},
  "1.3"->{
    Cell[4213, 131, 691, 14, 104, "Text",
      CellTags->{"S5.92.1", "1.3"}]},
  "1.4"->{
    Cell[4907, 147, 78, 1, 40, "MathCaption",
      CellTags->{"S5.92.1", "1.4"}]},
  "1.5"->{
    Cell[5084, 154, 103, 1, 40, "MathCaption",
      CellTags->{"S5.92.1", "1.5"}]},
  "1.6"->{
    Cell[5603, 173, 91, 1, 40, "MathCaption",
      CellTags->{"S5.92.1", "1.6"}]},
  "1.7"->{
    Cell[5883, 187, 267, 7, 56, "MathCaption",
      CellTags->{"S5.92.1", "1.7"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.92.1", 7231, 230},
  {"1.1", 8445, 263},
  {"1.2", 8539, 266},
  {"1.3", 8628, 269},
  {"1.4", 8719, 272},
  {"1.5", 8814, 275},
  {"1.6", 8910, 278},
  {"1.7", 9005, 281}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 143, 6, 36, "Subsection",
  CellTags->{"S5.92.1", "1.1"}],
Cell[1922, 61, 608, 14, 88, "Text",
  CellTags->{"S5.92.1", "1.2"}],
Cell[2533, 77, 1604, 49, 46, "DefinitionBox",
  CellTags->"S5.92.1"],
Cell[4140, 128, 70, 1, 15, "Caption",
  CellTags->"S5.92.1"],
Cell[4213, 131, 691, 14, 104, "Text",
  CellTags->{"S5.92.1", "1.3"}],
Cell[4907, 147, 78, 1, 40, "MathCaption",
  CellTags->{"S5.92.1", "1.4"}],
Cell[4988, 150, 93, 2, 28, "Input",
  CellTags->"S5.92.1"],
Cell[5084, 154, 103, 1, 40, "MathCaption",
  CellTags->{"S5.92.1", "1.5"}],

Cell[CellGroupData[{
Cell[5212, 159, 103, 2, 28, "Input",
  CellTags->"S5.92.1"],
Cell[5318, 163, 270, 7, 25, "Output",
  CellTags->"S5.92.1"]
}, Open  ]],
Cell[5603, 173, 91, 1, 40, "MathCaption",
  CellTags->{"S5.92.1", "1.6"}],

Cell[CellGroupData[{
Cell[5719, 178, 68, 2, 28, "Input",
  CellTags->"S5.92.1"],
Cell[5790, 182, 78, 2, 25, "Output",
  CellTags->"S5.92.1"]
}, Open  ]],
Cell[5883, 187, 267, 7, 56, "MathCaption",
  CellTags->{"S5.92.1", "1.7"}],

Cell[CellGroupData[{
Cell[6175, 198, 75, 2, 28, "Input",
  CellTags->"S5.92.1"],
Cell[6253, 202, 327, 8, 70, "Output",
  CellTags->"S5.92.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

