(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21188,        736]*)
(*NotebookOutlinePosition[     25189,        859]*)
(*  CellTagsIndexPosition[     24886,        843]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "PolynomialPowerMod",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.6.1", "1.1"}],

Cell[TextData[{
 "This package introduces the function ",
 StyleBox["PolynomialPowerMod", "MR"],
 ", which efficiently computes a power of a polynomial modulo a prime and a \
polynomial. Support for the ",
 StyleBox["Modulus", "MR"],
 " option is added to ",
 StyleBox["PolynomialQuotient", "MR"],
 " and ",
 StyleBox["PolynomialRemainder", "MR"],
 ". The package also extends the ",
 StyleBox["Modulus", "MR"],
 " option of ",
 StyleBox["Factor", "MR"],
 ", ",
 StyleBox["FactorList", "MR"],
 ", and ",
 StyleBox["PolynomialGCD", "MR"],
 " to handle large prime moduli. "
}], "Text",
 CellTags->{"S5.6.1", "1.2"}],

Cell[TextData[{
 "The factoring algorithm used by the functions in this package is described \
in D.E.\[NonBreakingSpace]Knuth, ",
 StyleBox["Seminumerical Algorithms", "TI"],
 ", Addison\[Hyphen]Wesley, 1981, Section 4.6.2. You first use the derivative \
to factor the polynomial ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " into square\[Hyphen]free factors. The degree ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " factorization of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " modulo ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is obtained by finding the greatest common denominator of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x",
      "TI"], 
     SuperscriptBox[
      StyleBox["p",
       "TI"], 
      StyleBox["d",
       "TI"]]], "-", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d",
     "TI"], "=", "1", ",", "2", ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " . This is computed quickly using repeated squaring. Finally, you use the \
probabilistic factoring algorithm of Cantor\[Hyphen]Zassenhaus to factor the \
result into irreducible degree ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " factors. "
}], "Text",
 CellTags->{"S5.6.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PolynomialPowerMod[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["compute ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["PolynomialMod[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["^",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is an integer and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a prime",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.6.1"],

Cell[TextData[{
 "Using ",
 StyleBox["PolynomialPowerMod", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.6.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.6.1", "1.4"}],

Cell["<<Algebra`PolynomialPowerMod`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.6.1"],

Cell[TextData[{
 "The package function ",
 StyleBox["PolynomialPowerMod", "MR"],
 " is more efficient than the built\[Hyphen]in function ",
 StyleBox["PolynomialMod", "MR"],
 " applied to a polynomial raised to a power. "
}], "MathCaption",
 CellTags->{"S5.6.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
{Timing[PolynomialPowerMod[1 + x + x^2, 400,
 {x^3 + x^2 + 1, Prime[4750]}]][[1]],
 Timing[PolynomialMod[(1 + x + x^2)^400,
 {x^3 + x^2 + 1, Prime[4750]}]][[1]]}\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.6.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.01000000000000002`", " ", "Second"}], ",", 
   RowBox[{"1.53`", " ", "Second"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.6.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PolynomialQuotient[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Modulus -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["compute ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["PolynomialMod[PolynomialQuotient[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["],", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PolynomialRemainder[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Modulus -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["compute ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["PolynomialMod[PolynomialRemainder[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["],", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.6.1"],

Cell[TextData[{
 StyleBox["Modulus", "MR"],
 " option for ",
 StyleBox["PolynomialQuotient", "MR"],
 " and ",
 StyleBox["PolynomialRemainder", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.6.1"],

Cell[TextData[{
 "Here are two polynomials in ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.6.1", "1.6"}],

Cell["{f, g} = {(1 + x)^3 (1 + x^3), x^2 + 2};", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.6.1"],

Cell[TextData[{
 "Using the ",
 StyleBox["Modulus", "MR"],
 " option of ",
 StyleBox["PolynomialQuotient", "MR"],
 " is equivalent to applying ",
 StyleBox["PolynomialMod", "MR"],
 " to the result of ",
 StyleBox["PolynomialQuotient", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.6.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
{PolynomialQuotient[f, g, x, Modulus -> 11],
 PolynomialMod[PolynomialQuotient[f,g,x], 11]}\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.6.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"7", " ", "x"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"7", " ", "x"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "4"]}]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.6.1"]
}, Open  ]],

Cell[TextData[{
 "Using the ",
 StyleBox["Modulus", "MR"],
 " option of ",
 StyleBox["PolynomialRemainder", "MR"],
 " is equivalent to applying ",
 StyleBox["PolynomialMod", "MR"],
 " to the result of ",
 StyleBox["PolynomialRemainder", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.6.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
{PolynomialRemainder[f, g, x, Modulus -> 11],
  PolynomialMod[PolynomialRemainder[f,g,x],11]}\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.6.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "10"}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.6.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PolynomialGCD[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , Modulus -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find the greatest common divisor of the polynomials modulo ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Factor[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Modulus -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["factor a polynomial modulo ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FactorList[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Modulus -> ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give results as lists of factors",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.6.1"],

Cell[TextData[{
 "Extending ",
 StyleBox["PolynomialGCD", "MR"],
 ", ",
 StyleBox["Factor", "MR"],
 ", and ",
 StyleBox["FactorList", "MR"],
 " to accept large prime moduli. "
}], "Caption",
 CellTags->"S5.6.1"],

Cell[TextData[{
 "Using the ",
 StyleBox["Modulus", "MR"],
 " option with ",
 StyleBox["PolynomialGCD", "MR"],
 " is equivalent to applying ",
 StyleBox["PolynomialMod", "MR"],
 " to the result of ",
 StyleBox["PolynomialGCD", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.6.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
{PolynomialGCD[x^2-1,x-1, Modulus -> Prime[10^8]],
 PolynomialMod[PolynomialGCD[x^2-1,x-1], Prime[10^8]]}\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.6.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2038074742", "+", "x"}], ",", 
   RowBox[{"2038074742", "+", "x"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.6.1"]
}, Open  ]],

Cell["\<\
After loading this package, a polynomial may be factored modulo a large \
prime. \
\>", "MathCaption",
 CellTags->{"S5.6.1", "1.10"}],

Cell[CellGroupData[{

Cell["Factor[1 + 2 x^3, Modulus -> Prime[10^7]]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.6.1"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"89712337", "+", 
    SuperscriptBox["x", "3"]}], ")"}]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.6.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.6.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.6.1", "1.1"}],
    Cell[1920, 61, 614, 20, 72, "Text",
      CellTags->{"S5.6.1", "1.2"}],
    Cell[2537, 83, 2160, 74, 106, "Text",
      CellTags->{"S5.6.1", "1.3"}],
    Cell[4700, 159, 3764, 116, 64, "DefinitionBox",
      CellTags->"S5.6.1"],
    Cell[8467, 277, 107, 5, 15, "Caption",
      CellTags->"S5.6.1"],
    Cell[8577, 284, 77, 1, 40, "MathCaption",
      CellTags->{"S5.6.1", "1.4"}],
    Cell[8657, 287, 91, 2, 28, "Input",
      CellTags->"S5.6.1"],
    Cell[8751, 291, 270, 7, 56, "MathCaption",
      CellTags->{"S5.6.1", "1.5"}],
    Cell[9046, 302, 231, 7, 79, "Input",
      CellTags->"S5.6.1"],
    Cell[9280, 311, 199, 6, 25, "Output",
      CellTags->"S5.6.1"],
    Cell[9494, 320, 4267, 134, 100, "DefinitionBox",
      CellTags->"S5.6.1"],
    Cell[13764, 456, 191, 8, 70, "Caption",
      CellTags->"S5.6.1"],
    Cell[13958, 466, 239, 9, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.6"}],
    Cell[14200, 477, 102, 2, 70, "Input",
      CellTags->"S5.6.1"],
    Cell[14305, 481, 296, 11, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.7"}],
    Cell[14626, 496, 161, 5, 70, "Input",
      CellTags->"S5.6.1"],
    Cell[14790, 503, 484, 16, 70, "Output",
      CellTags->"S5.6.1"],
    Cell[15289, 522, 298, 11, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.8"}],
    Cell[15612, 537, 163, 5, 70, "Input",
      CellTags->"S5.6.1"],
    Cell[15778, 544, 120, 4, 70, "Output",
      CellTags->"S5.6.1"],
    Cell[15913, 551, 3891, 119, 70, "DefinitionBox",
      CellTags->"S5.6.1"],
    Cell[19807, 672, 211, 9, 70, "Caption",
      CellTags->"S5.6.1"],
    Cell[20021, 683, 288, 11, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.9"}],
    Cell[20334, 698, 175, 5, 70, "Input",
      CellTags->"S5.6.1"],
    Cell[20512, 705, 184, 6, 70, "Output",
      CellTags->"S5.6.1"],
    Cell[20711, 714, 143, 4, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.10"}],
    Cell[20879, 722, 103, 2, 70, "Input",
      CellTags->"S5.6.1"],
    Cell[20985, 726, 175, 6, 70, "Output",
      CellTags->"S5.6.1"]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.6.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 614, 20, 72, "Text",
      CellTags->{"S5.6.1", "1.2"}]},
  "1.3"->{
    Cell[2537, 83, 2160, 74, 106, "Text",
      CellTags->{"S5.6.1", "1.3"}]},
  "1.4"->{
    Cell[8577, 284, 77, 1, 40, "MathCaption",
      CellTags->{"S5.6.1", "1.4"}]},
  "1.5"->{
    Cell[8751, 291, 270, 7, 56, "MathCaption",
      CellTags->{"S5.6.1", "1.5"}]},
  "1.6"->{
    Cell[13958, 466, 239, 9, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.6"}]},
  "1.7"->{
    Cell[14305, 481, 296, 11, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.7"}]},
  "1.8"->{
    Cell[15289, 522, 298, 11, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.8"}]},
  "1.9"->{
    Cell[20021, 683, 288, 11, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.9"}]},
  "1.10"->{
    Cell[20711, 714, 143, 4, 70, "MathCaption",
      CellTags->{"S5.6.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.6.1", 21810, 752},
  {"1.1", 23927, 809},
  {"1.2", 24020, 812},
  {"1.3", 24108, 815},
  {"1.4", 24198, 818},
  {"1.5", 24292, 821},
  {"1.6", 24387, 824},
  {"1.7", 24483, 827},
  {"1.8", 24580, 830},
  {"1.9", 24677, 833},
  {"1.10", 24775, 836}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 36, "Subsection",
  CellTags->{"S5.6.1", "1.1"}],
Cell[1920, 61, 614, 20, 72, "Text",
  CellTags->{"S5.6.1", "1.2"}],
Cell[2537, 83, 2160, 74, 106, "Text",
  CellTags->{"S5.6.1", "1.3"}],
Cell[4700, 159, 3764, 116, 64, "DefinitionBox",
  CellTags->"S5.6.1"],
Cell[8467, 277, 107, 5, 15, "Caption",
  CellTags->"S5.6.1"],
Cell[8577, 284, 77, 1, 40, "MathCaption",
  CellTags->{"S5.6.1", "1.4"}],
Cell[8657, 287, 91, 2, 28, "Input",
  CellTags->"S5.6.1"],
Cell[8751, 291, 270, 7, 56, "MathCaption",
  CellTags->{"S5.6.1", "1.5"}],

Cell[CellGroupData[{
Cell[9046, 302, 231, 7, 79, "Input",
  CellTags->"S5.6.1"],
Cell[9280, 311, 199, 6, 25, "Output",
  CellTags->"S5.6.1"]
}, Open  ]],
Cell[9494, 320, 4267, 134, 100, "DefinitionBox",
  CellTags->"S5.6.1"],
Cell[13764, 456, 191, 8, 70, "Caption",
  CellTags->"S5.6.1"],
Cell[13958, 466, 239, 9, 70, "MathCaption",
  CellTags->{"S5.6.1", "1.6"}],
Cell[14200, 477, 102, 2, 70, "Input",
  CellTags->"S5.6.1"],
Cell[14305, 481, 296, 11, 70, "MathCaption",
  CellTags->{"S5.6.1", "1.7"}],

Cell[CellGroupData[{
Cell[14626, 496, 161, 5, 70, "Input",
  CellTags->"S5.6.1"],
Cell[14790, 503, 484, 16, 70, "Output",
  CellTags->"S5.6.1"]
}, Open  ]],
Cell[15289, 522, 298, 11, 70, "MathCaption",
  CellTags->{"S5.6.1", "1.8"}],

Cell[CellGroupData[{
Cell[15612, 537, 163, 5, 70, "Input",
  CellTags->"S5.6.1"],
Cell[15778, 544, 120, 4, 70, "Output",
  CellTags->"S5.6.1"]
}, Open  ]],
Cell[15913, 551, 3891, 119, 70, "DefinitionBox",
  CellTags->"S5.6.1"],
Cell[19807, 672, 211, 9, 70, "Caption",
  CellTags->"S5.6.1"],
Cell[20021, 683, 288, 11, 70, "MathCaption",
  CellTags->{"S5.6.1", "1.9"}],

Cell[CellGroupData[{
Cell[20334, 698, 175, 5, 70, "Input",
  CellTags->"S5.6.1"],
Cell[20512, 705, 184, 6, 70, "Output",
  CellTags->"S5.6.1"]
}, Open  ]],
Cell[20711, 714, 143, 4, 70, "MathCaption",
  CellTags->{"S5.6.1", "1.10"}],

Cell[CellGroupData[{
Cell[20879, 722, 103, 2, 70, "Input",
  CellTags->"S5.6.1"],
Cell[20985, 726, 175, 6, 70, "Output",
  CellTags->"S5.6.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

