(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32153,       1095]*)
(*NotebookOutlinePosition[     36772,       1234]*)
(*  CellTagsIndexPosition[     36432,       1217]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Geometry",
 StyleBox["`", "MB"],
 "Polytopes",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.23.1", "1.1"}],

Cell[TextData[{
 "This package contains functions that give geometrical characteristics of \
regular polygons and regular polyhedra. Polygons and polyhedra are identified \
by name (",
 StyleBox["Square", "MR"],
 ", ",
 StyleBox["Tetrahedron", "MR"],
 ", etc.) in function arguments and in results. "
}], "Text",
 CellTags->{"S5.23.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NumberOfVertices[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["number of vertices in polygon ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NumberOfEdges[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["number of edges in polygon ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NumberOfFaces[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["number of faces in polygon ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Vertices[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list of vertex coordinates for polygon ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Area[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["area of polygon ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" when edges have unit length ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InscribedRadius[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["radius of the inscribed circle of polygon ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" when edges have unit length ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CircumscribedRadius[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["radius of the circumscribed circle of polygon ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" when edges have unit length ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.23.1"],

Cell["Geometrical characteristics of polygons. ", "Caption",
 CellTags->"S5.23.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Digon", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 2 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Triangle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 3 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Square", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 4 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Pentagon", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 5 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Hexagon", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 6 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Heptagon", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 7 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Octagon", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 8 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Nonagon", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 9 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Decagon", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 10 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Undecagon", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 11 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Dodecagon", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polygon with 12 edges ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.23.1"],

Cell["Names of polygons. ", "Caption",
 CellTags->"S5.23.1"],

Cell[TextData[{
 "The functions ",
 StyleBox["Area", "MR"],
 ", ",
 StyleBox["InscribedRadius", "MR"],
 ", and ",
 StyleBox["CircumscribedRadius", "MR"],
 " give information for a polygon with edges of length 1. The list of \
coordinates returned by ",
 StyleBox["Vertices", "MR"],
 " is conventional for the specified polygon and does not necessarily \
correspond to a polygon with unit edge length. "
}], "Text",
 CellTags->{"S5.23.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.23.1", "1.4"}],

Cell["<< Geometry`Polytopes`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.23.1"],

Cell["An octagon has 8 edges. ", "MathCaption",
 CellTags->{"S5.23.1", "1.5"}],

Cell[CellGroupData[{

Cell["NumberOfEdges[Octagon]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.23.1"],

Cell[BoxData["8"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.23.1"]
}, Open  ]],

Cell["\<\
This is the area of an octagon when the length of each edge is 1. \
\>", "MathCaption",
 CellTags->{"S5.23.1", "1.6"}],

Cell[CellGroupData[{

Cell["Area[Octagon]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.23.1"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cot", "[", 
   FractionBox["\[Pi]", "8"], "]"}]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.23.1"]
}, Open  ]],

Cell["\<\
These points represent the coordinates of the vertices of an octagon. \
\>", "MathCaption",
 CellTags->{"S5.23.1", "1.7"}],

Cell[CellGroupData[{

Cell["Vertices[Octagon]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.23.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.23.1"]
}, Open  ]],

Cell["Here is a plot of the vertices of an octagon. ", "MathCaption",
 CellTags->{"S5.23.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[{PointSize[.05], Point /@ %},
        AspectRatio -> 1]]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.23.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.05 w
.83672 .83672 Mdot
.5 .97619 Mdot
.16328 .83672 Mdot
.02381 .5 Mdot
.16328 .16328 Mdot
.5 .02381 Mdot
.83672 .16328 Mdot
.97619 .5 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.23.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.23.1"]
}, Open  ]],

Cell[TextData[{
 "The polyhedra functions ",
 StyleBox["Volume", "MR"],
 ", ",
 StyleBox["InscribedRadius", "MR"],
 ", and ",
 StyleBox["CircumscribedRadius", "MR"],
 " return information for a polyhedron with edges of length 1. The list of \
coordinates returned by ",
 StyleBox["Vertices", "MR"],
 " is conventional for the specified polyhedron and does not necessarily \
correspond to a polyhedron with unit edge length. "
}], "Text",
 CellTags->{"S5.23.1", "1.9"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["NumberOfVertices[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["number of vertices in polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NumberOfEdges[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["number of edges in polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NumberOfFaces[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["number of faces in polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Vertices[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list of vertex coordinates for polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Faces[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["list of faces from vertex numbers for polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Area[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["area of face of polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", when edges have unit length ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Volume[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["volume of polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", when edges have unit length ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["InscribedRadius[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["radius of the inscribed sphere of polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", when edges have unit length ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CircumscribedRadius[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["radius of the circumscribed sphere of polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", when edges have unit length ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Dual[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["dual of polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Schlafli[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Schlafli symbol for polyhedron ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.23.1"],

Cell["Geometrical characteristics of polyhedra. ", "Caption",
 CellTags->"S5.23.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Tetrahedron", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polyhedron with 4 faces",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Cube", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polyhedron with 6 faces ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Octahedron", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polyhedron with 8 faces ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Dodecahedron", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polyhedron with 12 faces ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Icosahedron", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["polyhedron with 20 faces ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.23.1"],

Cell["The five regular polyhedra. ", "Caption",
 CellTags->"S5.23.1"],

Cell["This is the volume of a tetrahedron with edges of length 1. ", \
"MathCaption",
 CellTags->{"S5.23.1", "1.10"}],

Cell[CellGroupData[{

Cell["Volume[Tetrahedron]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.23.1"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"6", " ", 
   SqrtBox["2"]}]]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.23.1"]
}, Open  ]],

Cell["These coordinates form the vertices of an octahedron. ", "MathCaption",
 CellTags->{"S5.23.1", "1.11"}],

Cell[CellGroupData[{

Cell["Vertices[Octahedron]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.23.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     SqrtBox["2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox["2"], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     SqrtBox["2"], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox["2"]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      SqrtBox["2"]}], ",", "0"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.23.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.23.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.23.1", "1.1"}],
    Cell[1913, 61, 343, 9, 56, "Text",
      CellTags->{"S5.23.1", "1.2"}],
    Cell[2259, 72, 6362, 202, 208, "DefinitionBox",
      CellTags->"S5.23.1"],
    Cell[8624, 276, 82, 1, 15, "Caption",
      CellTags->"S5.23.1"],
    Cell[8709, 279, 5310, 160, 256, "DefinitionBox",
      CellTags->"S5.23.1"],
    Cell[14022, 441, 60, 1, 15, "Caption",
      CellTags->"S5.23.1"],
    Cell[14085, 444, 445, 13, 56, "Text",
      CellTags->{"S5.23.1", "1.3"}],
    Cell[14533, 459, 78, 1, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.4"}],
    Cell[14614, 462, 85, 2, 70, "Input",
      CellTags->"S5.23.1"],
    Cell[14702, 466, 78, 1, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.5"}],
    Cell[14805, 471, 85, 2, 70, "Input",
      CellTags->"S5.23.1"],
    Cell[14893, 475, 74, 2, 70, "Output",
      CellTags->"S5.23.1"],
    Cell[14982, 480, 128, 3, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.6"}],
    Cell[15135, 487, 76, 2, 70, "Input",
      CellTags->"S5.23.1"],
    Cell[15214, 491, 152, 5, 70, "Output",
      CellTags->"S5.23.1"],
    Cell[15381, 499, 132, 3, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.7"}],
    Cell[15538, 506, 80, 2, 70, "Input",
      CellTags->"S5.23.1"],
    Cell[15621, 510, 1025, 42, 70, "Output",
      CellTags->"S5.23.1"],
    Cell[16661, 555, 100, 1, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.8"}],
    Cell[16786, 560, 141, 5, 70, "Input",
      CellTags->"S5.23.1"],
    Cell[16930, 567, 781, 49, 70, 710, 46, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.23.1"],
    Cell[17714, 618, 180, 6, 70, "Output",
      CellTags->"S5.23.1"],
    Cell[17909, 627, 468, 13, 70, "Text",
      CellTags->{"S5.23.1", "1.9"}],
    Cell[18380, 642, 9778, 311, 70, "DefinitionBox",
      CellTags->"S5.23.1"],
    Cell[28161, 955, 83, 1, 70, "Caption",
      CellTags->"S5.23.1"],
    Cell[28247, 958, 2542, 76, 70, "DefinitionBox",
      CellTags->"S5.23.1"],
    Cell[30792, 1036, 69, 1, 70, "Caption",
      CellTags->"S5.23.1"],
    Cell[30864, 1039, 117, 2, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.10"}],
    Cell[31006, 1045, 82, 2, 70, "Input",
      CellTags->"S5.23.1"],
    Cell[31091, 1049, 130, 5, 70, "Output",
      CellTags->"S5.23.1"],
    Cell[31236, 1057, 109, 1, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.11"}],
    Cell[31370, 1062, 83, 2, 70, "Input",
      CellTags->"S5.23.1"],
    Cell[31456, 1066, 669, 25, 70, "Output",
      CellTags->"S5.23.1"]},
  "1.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.23.1", "1.1"}]},
  "1.2"->{
    Cell[1913, 61, 343, 9, 56, "Text",
      CellTags->{"S5.23.1", "1.2"}]},
  "1.3"->{
    Cell[14085, 444, 445, 13, 56, "Text",
      CellTags->{"S5.23.1", "1.3"}]},
  "1.4"->{
    Cell[14533, 459, 78, 1, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.4"}]},
  "1.5"->{
    Cell[14702, 466, 78, 1, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.5"}]},
  "1.6"->{
    Cell[14982, 480, 128, 3, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.6"}]},
  "1.7"->{
    Cell[15381, 499, 132, 3, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.7"}]},
  "1.8"->{
    Cell[16661, 555, 100, 1, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.8"}]},
  "1.9"->{
    Cell[17909, 627, 468, 13, 70, "Text",
      CellTags->{"S5.23.1", "1.9"}]},
  "1.10"->{
    Cell[30864, 1039, 117, 2, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.10"}]},
  "1.11"->{
    Cell[31236, 1057, 109, 1, 70, "MathCaption",
      CellTags->{"S5.23.1", "1.11"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.23.1", 32776, 1111},
  {"1.1", 35371, 1180},
  {"1.2", 35465, 1183},
  {"1.3", 35553, 1186},
  {"1.4", 35644, 1189},
  {"1.5", 35740, 1192},
  {"1.6", 35836, 1195},
  {"1.7", 35933, 1198},
  {"1.8", 36030, 1201},
  {"1.9", 36127, 1204},
  {"1.10", 36219, 1207},
  {"1.11", 36319, 1210}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 6, 36, "Subsection",
  CellTags->{"S5.23.1", "1.1"}],
Cell[1913, 61, 343, 9, 56, "Text",
  CellTags->{"S5.23.1", "1.2"}],
Cell[2259, 72, 6362, 202, 208, "DefinitionBox",
  CellTags->"S5.23.1"],
Cell[8624, 276, 82, 1, 15, "Caption",
  CellTags->"S5.23.1"],
Cell[8709, 279, 5310, 160, 256, "DefinitionBox",
  CellTags->"S5.23.1"],
Cell[14022, 441, 60, 1, 15, "Caption",
  CellTags->"S5.23.1"],
Cell[14085, 444, 445, 13, 56, "Text",
  CellTags->{"S5.23.1", "1.3"}],
Cell[14533, 459, 78, 1, 70, "MathCaption",
  CellTags->{"S5.23.1", "1.4"}],
Cell[14614, 462, 85, 2, 70, "Input",
  CellTags->"S5.23.1"],
Cell[14702, 466, 78, 1, 70, "MathCaption",
  CellTags->{"S5.23.1", "1.5"}],

Cell[CellGroupData[{
Cell[14805, 471, 85, 2, 70, "Input",
  CellTags->"S5.23.1"],
Cell[14893, 475, 74, 2, 70, "Output",
  CellTags->"S5.23.1"]
}, Open  ]],
Cell[14982, 480, 128, 3, 70, "MathCaption",
  CellTags->{"S5.23.1", "1.6"}],

Cell[CellGroupData[{
Cell[15135, 487, 76, 2, 70, "Input",
  CellTags->"S5.23.1"],
Cell[15214, 491, 152, 5, 70, "Output",
  CellTags->"S5.23.1"]
}, Open  ]],
Cell[15381, 499, 132, 3, 70, "MathCaption",
  CellTags->{"S5.23.1", "1.7"}],

Cell[CellGroupData[{
Cell[15538, 506, 80, 2, 70, "Input",
  CellTags->"S5.23.1"],
Cell[15621, 510, 1025, 42, 70, "Output",
  CellTags->"S5.23.1"]
}, Open  ]],
Cell[16661, 555, 100, 1, 70, "MathCaption",
  CellTags->{"S5.23.1", "1.8"}],

Cell[CellGroupData[{
Cell[16786, 560, 141, 5, 70, "Input",
  CellTags->"S5.23.1"],
Cell[16930, 567, 781, 49, 70, 710, 46, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.23.1"],
Cell[17714, 618, 180, 6, 70, "Output",
  CellTags->"S5.23.1"]
}, Open  ]],
Cell[17909, 627, 468, 13, 70, "Text",
  CellTags->{"S5.23.1", "1.9"}],
Cell[18380, 642, 9778, 311, 70, "DefinitionBox",
  CellTags->"S5.23.1"],
Cell[28161, 955, 83, 1, 70, "Caption",
  CellTags->"S5.23.1"],
Cell[28247, 958, 2542, 76, 70, "DefinitionBox",
  CellTags->"S5.23.1"],
Cell[30792, 1036, 69, 1, 70, "Caption",
  CellTags->"S5.23.1"],
Cell[30864, 1039, 117, 2, 70, "MathCaption",
  CellTags->{"S5.23.1", "1.10"}],

Cell[CellGroupData[{
Cell[31006, 1045, 82, 2, 70, "Input",
  CellTags->"S5.23.1"],
Cell[31091, 1049, 130, 5, 70, "Output",
  CellTags->"S5.23.1"]
}, Open  ]],
Cell[31236, 1057, 109, 1, 70, "MathCaption",
  CellTags->{"S5.23.1", "1.11"}],

Cell[CellGroupData[{
Cell[31370, 1062, 83, 2, 70, "Input",
  CellTags->"S5.23.1"],
Cell[31456, 1066, 669, 25, 70, "Output",
  CellTags->"S5.23.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

