(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     37422,       1156]*)
(*NotebookOutlinePosition[     44984,       1383]*)
(*  CellTagsIndexPosition[     44319,       1353]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumberTheory",
 StyleBox["`", "MB"],
 "PrimeQ",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.70.1", "1.1"}],

Cell[TextData[{
 "This package implements primality proving. If ",
 StyleBox["ProvablePrimeQ[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " returns ",
 StyleBox["True", "MR"],
 ", then the number ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can be mathematically proven to be prime. In addition, ",
 StyleBox["PrimeQCertificate[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " prints a certificate that can be used to verify that ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is prime or composite. Note that the built\[Hyphen]in primality testing \
function ",
 StyleBox["PrimeQ", "MR"],
 " does not actually give a proof that a number is prime. However, as of this \
writing, there are no known examples where ",
 StyleBox["PrimeQ", "MR"],
 " fails. "
}], "Text",
 CellTags->{"S5.70.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ProvablePrimeQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" if ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" can be proved to be prime, and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" if ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" can be proved to be composite",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ProvablePrimeQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Certificate -> True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "print a certificate that can be used to verify the result",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrimeQCertificate[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["print a certificate that ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is prime or that ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is composite",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrimeQCertificateCheck[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cert", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["verify that the certificate ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cert", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" proves the primality or compositeness of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.70.1"],

Cell["Proving primality or compositeness. ", "Caption",
 CellTags->"S5.70.1"],

Cell[TextData[{
 "The functions provided in this package not only prove primality, but they \
also generate a ",
 StyleBox["certificate", "TI"],
 " of primality. A certificate of primality is a relatively short set of data \
that can be easily used to prove primality. The word easily means that using \
the data to prove primality is much easier and faster than generating the \
data in the first place. As a simple example of a certificate, the factors of \
a composite number provide a certificate of compositeness. Multiplying the \
numbers together to show that they are the factors is much easier than \
finding the factors. The advantage of providing certificates is that the user \
does not have to trust the internal mechanism of the algorithm that generated \
the certificate. It is fairly easy to write a program (in any system) that \
checks that the certificate provides a proof of primality. "
}], "Text",
 CellTags->{"S5.70.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.70.1", "1.4"}],

Cell["<<NumberTheory`PrimeQ`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.70.1"],

Cell[TextData[{
 StyleBox["PrimeQ", "MR"],
 " indicates that the number 1093 is prime. "
}], "MathCaption",
 CellTags->{"S5.70.1", "1.5"}],

Cell[CellGroupData[{

Cell["PrimeQ[1093]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["ProvablePrimeQ", "MR"],
 " gives the same result, but it has generated a certificate. "
}], "MathCaption",
 CellTags->{"S5.70.1", "1.6"}],

Cell[CellGroupData[{

Cell["ProvablePrimeQ[1093]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell["This prints the certificate. ", "MathCaption",
 CellTags->{"S5.70.1", "1.7"}],

Cell[CellGroupData[{

Cell["PrimeQCertificate[1093]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1093", ",", "5", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "3", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell["This prints the certificate directly. ", "MathCaption",
 CellTags->{"S5.70.1", "1.8"}],

Cell[CellGroupData[{

Cell["ProvablePrimeQ[1093, Certificate->True]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"{", 
    RowBox[{"1093", ",", "5", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", 
         RowBox[{"{", "2", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "3", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "2", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell[TextData[{
 "The certificate of primality used in this package for large ",
 StyleBox["n", "TI"],
 " is based on the theory of elliptic curves. The basic idea was discovered \
by S.\[NonBreakingSpace]Goldwasser and J.\[NonBreakingSpace]Kilian, \
\[OpenCurlyDoubleQuote]Almost All Primes Can Be Quickly Certified,\
\[CloseCurlyDoubleQuote] in ",
 StyleBox["Proc. 18th STOC", "TI"],
 ", 1986, pp. 316\[Dash]329. Their algorithm was only of theoretical \
significance, however. A.\[NonBreakingSpace]O.\[NonBreakingSpace]L.\
\[NonBreakingSpace]Atkin found a way to make it practical by using ideas from \
complex multiplication, which is a branch of number theory that combines the \
fields of complex analysis, Galois theory and modular forms. This method was \
implemented very successfully by F.\[NonBreakingSpace]Morain in \
\[OpenCurlyDoubleQuote]Implementation of the \
Atkin\[Hyphen]Goldwasser\[Hyphen]Kilian Primality Testing Algorithm,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["INRIA Research Report", "TI"],
 ", # 911, October 1988. In November 1989, Morain was able to give a \
primality proof for a 1065\[Hyphen]digit number, the first titanic prime (",
 Cell[BoxData[
  FormBox[
   RowBox[{">", "1000"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " digits) to be tested without special purpose algorithms. Since that time \
Atkin and Morain have written an extensive treatise on the algorithm: A.\
\[NonBreakingSpace]O.\[NonBreakingSpace]L. Atkin and F. Morain, \
\[OpenCurlyDoubleQuote]Elliptic Curves and Primality Proving,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["Mathematics of Computation", "TI"],
 ", 1993, 29\[Dash]68. "
}], "Text",
 CellTags->{"S5.70.1", "1.9"}],

Cell[TextData[{
 "For an introduction to primality testing and elliptic curves, see D.\
\[NonBreakingSpace]Bressoud, ",
 StyleBox["Factorization and Primality Testing", "TI"],
 ", Springer\[Hyphen]Verlag, 1989. "
}], "Text",
 CellTags->{"S5.70.1", "1.10"}],

Cell[TextData[{
 "This package can also be used to generate certificates of compositeness for \
composite numbers. These certificates are based on showing that simple \
properties that are true of prime numbers are not true for the given number. \
For example, ",
 StyleBox["PrimeQCertificate[3837523]", "MR"],
 " returns the certificate ",
 StyleBox["{2,", "MR"],
 " ",
 StyleBox["3837522,", "MR"],
 " ",
 StyleBox["3837523}", "MR"],
 ", which is intended to show that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", "3837522"], " ", 
    RowBox[{"(", 
     RowBox[{"mod", " ", "3837523"}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not equal to 1. "
}], "Text",
 CellTags->{"S5.70.1", "1.11"}],

Cell[TextData[{
 StyleBox["ProvablePrimeQ[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " returns ",
 StyleBox["True", "MR"],
 " or ",
 StyleBox["False", "MR"],
 " depending on whether ",
 StyleBox["n", "MR"],
 " is prime or not. The certificate for primality or compositeness is \
generated by ",
 StyleBox["PrimeQCertificate[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 ". ",
 StyleBox["ProvablePrimeQ", "MR"],
 " calls ",
 StyleBox["PrimeQCertificate", "MR"],
 " and stores the result, so it does not take any extra time to create a \
certificate once ",
 StyleBox["ProvablePrimeQ", "MR"],
 " has returned an answer. The certificate generated by ",
 StyleBox["PrimeQCertificate", "MR"],
 " can be checked by ",
 StyleBox["PrimeQCertificateCheck", "MR"],
 ". This function recognizes whether the certificate asserts primality or \
compositeness and then uses the certificate to verify the assertion. "
}], "Text",
 CellTags->{"S5.70.1", "1.12"}],

Cell["This prints the certificate of the prime number. ", "MathCaption",
 CellTags->{"S5.70.1", "1.13"}],

Cell[CellGroupData[{

Cell["\<\
ProvablePrimeQ[1093,
      Certificate -> True]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"{", 
    RowBox[{"1093", ",", "5", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2", ",", 
         RowBox[{"{", "2", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "3", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "2", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", 
             RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell["This verifies primality using the certificate. ", "MathCaption",
 CellTags->{"S5.70.1", "1.14"}],

Cell[CellGroupData[{

Cell["PrimeQCertificateCheck[Last[%], 1093]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell["\<\
Here is the certificate for a composite number. You can recognize a \
certificate of compositeness because it will always be a list of three \
integers. \
\>", "MathCaption",
 CellTags->{"S5.70.1", "1.15"}],

Cell[CellGroupData[{

Cell["PrimeQCertificate[1093 * 3511]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3837522", ",", "3837523"}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell["This verifies the compositeness. ", "MathCaption",
 CellTags->{"S5.70.1", "1.16"}],

Cell[CellGroupData[{

Cell["PrimeQCertificateCheck[%, 3837523]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell[TextData[{
 "The built\[Hyphen]in function ",
 StyleBox["PrimeQ", "MR"],
 " first tests for divisibility using small primes, then uses the Miller\
\[Hyphen]Rabin strong pseudoprime test base 2 and base 3, and then uses the \
Lucas test. As of 1998, this procedure is known to be correct only for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "<", 
    SuperscriptBox["10", "16"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and it is conceivable that for larger ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " it could claim a composite number to be prime. However, it is a \
mathematical theorem that when ",
 StyleBox["PrimeQ[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " returns ",
 StyleBox["False", "MR"],
 ", the number ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is genuinely composite. Thus ",
 StyleBox["PrimeQ[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " can only fail if ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is composite but ",
 StyleBox["PrimeQ", "MR"],
 " declares it to be prime. It is important to note that ",
 StyleBox["PrimeQ", "MR"],
 " is deterministic; no computations based on random numbers are involved. "
}], "Text",
 CellTags->{"S5.70.1", "1.17"}],

Cell[TextData[{
 "This package is not meant to replace the built\[Hyphen]in primality tester \
",
 StyleBox["PrimeQ", "MR"],
 " but rather to allow one to be completely secure that a number is truly \
prime. The package should be used only to certify results after all the \
number theoretical work has been done. For example, it would be a mistake to \
use ",
 StyleBox["ProvablePrimeQ", "MR"],
 " as a primality test for an integer factoring algorithm. Rather, only when \
the complete factorization has been achieved (using ",
 StyleBox["PrimeQ", "MR"],
 " for primality testing) would one use ",
 StyleBox["ProvablePrimeQ", "MR"],
 " to certify the primality of the prime factors given by the algorithm. The \
reason for this is that ",
 StyleBox["PrimeQ", "MR"],
 " will be, in general, several orders of magnitude faster than ",
 StyleBox["ProvablePrimeQ", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.70.1", "1.18"}],

Cell[TextData[{
 "As noted above, there is a possibility that ",
 StyleBox["PrimeQ", "MR"],
 " is incorrect, that is, it asserts that a number is prime when it is really \
composite. It is unclear whether ",
 StyleBox["ProvablePrimeQ", "MR"],
 " always detects this; but if it does, a warning message is generated \
indicating a counterexample to ",
 StyleBox["PrimeQ", "MR"],
 ", and ",
 StyleBox["False", "MR"],
 " is returned. This behavior can be simulated by artificially setting ",
 StyleBox["PrimeQ[", "MR"],
 StyleBox["n", "TI"],
 StyleBox["]", "MR"],
 " to ",
 StyleBox["True", "MR"],
 " for a known composite ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.70.1", "1.19"}],

Cell[TextData[{
 "Here ",
 StyleBox["PrimeQ", "MR"],
 " is artificially set to give an incorrect answer. ",
 StyleBox["ProvablePrimeQ", "MR"],
 " detects that ",
 StyleBox["PrimeQ", "MR"],
 " is incorrect, prints a warning message, and returns the correct answer. "
}], "MathCaption",
 CellTags->{"S5.70.1", "1.20"}],

Cell[CellGroupData[{

Cell["\<\
(Unprotect[PrimeQ];
PrimeQ[38200901201] = True;
ProvablePrimeQ[38200901201])\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.70.1"],

Cell["\<\
SqrtMod::fail: Warning: $IterationLimit exceeded; PrimeQ[38200901201] may be \
incorrect.

PrimeQCertificate::qrsqrtmod:
   Failure of elliptic curves certificate for p = 38200901201. Unable to find \
quadratic representation 4*p = u^2 + 7*v^2 due to failure of SqrtMod[-7 , p].

PrimeQCertificate::false:
   Warning: PrimeQCertificate has detected a counterexample to PrimeQ:
    PowerMod[3, 38200901200, 38200901201] != 1.
\
\>", "Message",
 CellTags->"S5.70.1"],

Cell["False", "Output",
 CellLabel->"Out[10]=",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SmallPrime", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["10^50", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "lower bound for using the Atkin\[Hyphen]Morain primality test",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Certificate", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to print a certificate",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PollardPTest", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["whether to apply the Pollard ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["p",
          "TI"], "-", "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[
      " factoring algorithm in the search for the next prime in the recursive \
certificate",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PollardRhoTest", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["whether to apply the Pollard ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Rho]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[
      " factoring algorithm in the search for the next prime in the recursive \
certificate",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TrialDivisionLimit", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["number of primes to be used in the trial division part of ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["PrimeQCertificate", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrimeQMessages", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to print out the progress of the algorithm",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.70.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["ProvablePrimeQ", "MR"],
 " and ",
 StyleBox["PrimeQCertificate", "MR"],
 "."
}], "Caption",
 CellTags->"S5.70.1"],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is larger than the value of the option ",
 StyleBox["SmallPrime", "MR"],
 ", ",
 StyleBox["ProvablePrimeQ", "MR"],
 " uses the Atkin\[Hyphen]Morain test as described above. This primality \
proving algorithm is suboptimal if the number is within the range of \
efficient factoring algorithms. When this is the case, a method of V.\
\[NonBreakingSpace]Pratt is preferable: V.\[NonBreakingSpace]Pratt, \
\[OpenCurlyDoubleQuote]Every Prime Has a Succinct Certificate,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["SIAM Journal of Computation", "TI"],
 " 4 (1975), pages 214\[Dash]220. An implementation of this algorithm in ",
 StyleBox["Mathematica", "TI"],
 " is described in S. Wagon, ",
 StyleBox["Mathematica in Action", "TI"],
 ", W. H. Freeman, 1991, Section\[NonBreakingSpace]8.7. "
}], "Text",
 CellTags->{"S5.70.1", "1.21"}],

Cell[TextData[{
 "Note that you must use the same value of ",
 StyleBox["SmallPrime", "MR"],
 " when you check a certificate using ",
 StyleBox["PrimeQCertificate", "MR"],
 " that you used when you generated it using ",
 StyleBox["ProvablePrimeQ", "MR"],
 " or ",
 StyleBox["PrimeQCertificate", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.70.1", "1.22"}],

Cell[TextData[{
 "Since the default value of ",
 StyleBox["SmallPrime", "MR"],
 " is larger than the given number, Pratt\[CloseCurlyQuote]s certificate of \
primality is returned. "
}], "MathCaption",
 CellTags->{"S5.70.1", "1.23"}],

Cell[CellGroupData[{

Cell["PrimeQCertificate[3511]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3511", ",", "7", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.70.1"]
}, Open  ]],

Cell["\<\
For large numbers, the certificate can be quite long and involved. \
\>", "MathCaption",
 CellTags->{"S5.70.1", "1.24"}],

Cell[CellGroupData[{

Cell["PrimeQCertificate[10^20 + 39]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.70.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100000000000000000039", ",", "3", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"32839", ",", "6", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", 
           RowBox[{"{", "2", "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"13", ",", "2", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "2", ",", 
               RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"421", ",", "2", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "2", ",", 
               RowBox[{"{", "2", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "2", ",", 
               RowBox[{"{", "2", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "3", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "2", ",", 
                   RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
            "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"507526619771207", ",", "5", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "3", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "2", ",", 
               RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"43", ",", "3", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "2", ",", 
               RowBox[{"{", "2", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "3", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "2", ",", 
                   RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
            "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5741", ",", "2", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "2", ",", 
               RowBox[{"{", "2", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"7", ",", "3", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "2", ",", 
                   RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"41", ",", "6", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{"{", 
                  RowBox[{"5", ",", "2", ",", 
                   RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
            "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"146850283", ",", "2", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "2", ",", 
               RowBox[{"{", "2", "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"419", ",", "2", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{"{", 
                  RowBox[{"11", ",", "2", ",", 
                   RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "2", ",", 
                    RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"19", ",", "2", ",", 
                   RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", 
                    RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
                "}"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"19471", ",", "11", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "2", ",", 
                   RowBox[{"{", "2", "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"5", ",", "2", ",", 
                   RowBox[{"{", "2", "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"11", ",", "2", ",", 
                   RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "2", ",", 
                    RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"59", ",", "2", ",", 
                   RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{"{", 
                    RowBox[{"29", ",", "2", ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", "3", ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "2", ",", 
                    RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
                    "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
            "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.70.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.70.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.70.1", "1.1"}],
    Cell[1914, 61, 1007, 31, 88, "Text",
      CellTags->{"S5.70.1", "1.2"}],
    Cell[2924, 94, 4658, 144, 162, "DefinitionBox",
      CellTags->"S5.70.1"],
    Cell[7585, 240, 77, 1, 15, "Caption",
      CellTags->"S5.70.1"],
    Cell[7665, 243, 950, 15, 152, "Text",
      CellTags->{"S5.70.1", "1.3"}],
    Cell[8618, 260, 78, 1, 40, "MathCaption",
      CellTags->{"S5.70.1", "1.4"}],
    Cell[8699, 263, 85, 2, 28, "Input",
      CellTags->"S5.70.1"],
    Cell[8787, 267, 138, 4, 40, "MathCaption",
      CellTags->{"S5.70.1", "1.5"}],
    Cell[8950, 275, 75, 2, 28, "Input",
      CellTags->"S5.70.1"],
    Cell[9028, 279, 77, 2, 25, "Output",
      CellTags->"S5.70.1"],
    Cell[9120, 284, 164, 4, 40, "MathCaption",
      CellTags->{"S5.70.1", "1.6"}],
    Cell[9309, 292, 83, 2, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[9395, 296, 77, 2, 70, "Output",
      CellTags->"S5.70.1"],
    Cell[9487, 301, 83, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.7"}],
    Cell[9595, 306, 86, 2, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[9684, 310, 742, 24, 70, "Output",
      CellTags->"S5.70.1"],
    Cell[10441, 337, 92, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.8"}],
    Cell[10558, 342, 102, 2, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[10663, 346, 834, 26, 70, "Output",
      CellTags->"S5.70.1"],
    Cell[11512, 375, 1722, 32, 70, "Text",
      CellTags->{"S5.70.1", "1.9"}],
    Cell[13237, 409, 256, 6, 70, "Text",
      CellTags->{"S5.70.1", "1.10"}],
    Cell[13496, 417, 770, 23, 70, "Text",
      CellTags->{"S5.70.1", "1.11"}],
    Cell[14269, 442, 966, 29, 70, "Text",
      CellTags->{"S5.70.1", "1.12"}],
    Cell[15238, 473, 104, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.13"}],
    Cell[15367, 478, 118, 5, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[15488, 485, 834, 26, 70, "Output",
      CellTags->"S5.70.1"],
    Cell[16337, 514, 102, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.14"}],
    Cell[16464, 519, 100, 2, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[16567, 523, 77, 2, 70, "Output",
      CellTags->"S5.70.1"],
    Cell[16659, 528, 216, 5, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.15"}],
    Cell[16900, 537, 93, 2, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[16996, 541, 141, 4, 70, "Output",
      CellTags->"S5.70.1"],
    Cell[17152, 548, 88, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.16"}],
    Cell[17265, 553, 97, 2, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[17365, 557, 77, 2, 70, "Output",
      CellTags->"S5.70.1"],
    Cell[17457, 562, 1567, 48, 70, "Text",
      CellTags->{"S5.70.1", "1.17"}],
    Cell[19027, 612, 919, 21, 70, "Text",
      CellTags->{"S5.70.1", "1.18"}],
    Cell[19949, 635, 807, 25, 70, "Text",
      CellTags->{"S5.70.1", "1.19"}],
    Cell[20759, 662, 316, 9, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.20"}],
    Cell[21100, 675, 148, 6, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[21251, 683, 474, 13, 70, "Message",
      CellTags->"S5.70.1"],
    Cell[21728, 698, 69, 2, 70, "Output",
      CellTags->"S5.70.1"],
    Cell[21812, 703, 7052, 202, 70, "DefinitionBox3Col",
      CellTags->"S5.70.1"],
    Cell[28867, 907, 157, 7, 70, "Caption",
      CellTags->"S5.70.1"],
    Cell[29027, 916, 990, 24, 70, "Text",
      CellTags->{"S5.70.1", "1.21"}],
    Cell[30020, 942, 351, 11, 70, "Text",
      CellTags->{"S5.70.1", "1.22"}],
    Cell[30374, 955, 232, 6, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.23"}],
    Cell[30631, 965, 87, 2, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[30721, 969, 611, 20, 70, "Output",
      CellTags->"S5.70.1"],
    Cell[31347, 992, 130, 3, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.24"}],
    Cell[31502, 999, 93, 2, 70, "Input",
      CellTags->"S5.70.1"],
    Cell[31598, 1003, 5796, 149, 70, "Output",
      CellTags->"S5.70.1"]},
  "1.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.70.1", "1.1"}]},
  "1.2"->{
    Cell[1914, 61, 1007, 31, 88, "Text",
      CellTags->{"S5.70.1", "1.2"}]},
  "1.3"->{
    Cell[7665, 243, 950, 15, 152, "Text",
      CellTags->{"S5.70.1", "1.3"}]},
  "1.4"->{
    Cell[8618, 260, 78, 1, 40, "MathCaption",
      CellTags->{"S5.70.1", "1.4"}]},
  "1.5"->{
    Cell[8787, 267, 138, 4, 40, "MathCaption",
      CellTags->{"S5.70.1", "1.5"}]},
  "1.6"->{
    Cell[9120, 284, 164, 4, 40, "MathCaption",
      CellTags->{"S5.70.1", "1.6"}]},
  "1.7"->{
    Cell[9487, 301, 83, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.7"}]},
  "1.8"->{
    Cell[10441, 337, 92, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.8"}]},
  "1.9"->{
    Cell[11512, 375, 1722, 32, 70, "Text",
      CellTags->{"S5.70.1", "1.9"}]},
  "1.10"->{
    Cell[13237, 409, 256, 6, 70, "Text",
      CellTags->{"S5.70.1", "1.10"}]},
  "1.11"->{
    Cell[13496, 417, 770, 23, 70, "Text",
      CellTags->{"S5.70.1", "1.11"}]},
  "1.12"->{
    Cell[14269, 442, 966, 29, 70, "Text",
      CellTags->{"S5.70.1", "1.12"}]},
  "1.13"->{
    Cell[15238, 473, 104, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.13"}]},
  "1.14"->{
    Cell[16337, 514, 102, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.14"}]},
  "1.15"->{
    Cell[16659, 528, 216, 5, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.15"}]},
  "1.16"->{
    Cell[17152, 548, 88, 1, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.16"}]},
  "1.17"->{
    Cell[17457, 562, 1567, 48, 70, "Text",
      CellTags->{"S5.70.1", "1.17"}]},
  "1.18"->{
    Cell[19027, 612, 919, 21, 70, "Text",
      CellTags->{"S5.70.1", "1.18"}]},
  "1.19"->{
    Cell[19949, 635, 807, 25, 70, "Text",
      CellTags->{"S5.70.1", "1.19"}]},
  "1.20"->{
    Cell[20759, 662, 316, 9, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.20"}]},
  "1.21"->{
    Cell[29027, 916, 990, 24, 70, "Text",
      CellTags->{"S5.70.1", "1.21"}]},
  "1.22"->{
    Cell[30020, 942, 351, 11, 70, "Text",
      CellTags->{"S5.70.1", "1.22"}]},
  "1.23"->{
    Cell[30374, 955, 232, 6, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.23"}]},
  "1.24"->{
    Cell[31347, 992, 130, 3, 70, "MathCaption",
      CellTags->{"S5.70.1", "1.24"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.70.1", 38045, 1172},
  {"1.1", 42024, 1277},
  {"1.2", 42118, 1280},
  {"1.3", 42208, 1283},
  {"1.4", 42299, 1286},
  {"1.5", 42394, 1289},
  {"1.6", 42490, 1292},
  {"1.7", 42586, 1295},
  {"1.8", 42681, 1298},
  {"1.9", 42777, 1301},
  {"1.10", 42870, 1304},
  {"1.11", 42962, 1307},
  {"1.12", 43055, 1310},
  {"1.13", 43148, 1313},
  {"1.14", 43247, 1316},
  {"1.15", 43346, 1319},
  {"1.16", 43445, 1322},
  {"1.17", 43543, 1325},
  {"1.18", 43637, 1328},
  {"1.19", 43730, 1331},
  {"1.20", 43823, 1334},
  {"1.21", 43922, 1337},
  {"1.22", 44015, 1340},
  {"1.23", 44108, 1343},
  {"1.24", 44207, 1346}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 135, 6, 36, "Subsection",
  CellTags->{"S5.70.1", "1.1"}],
Cell[1914, 61, 1007, 31, 88, "Text",
  CellTags->{"S5.70.1", "1.2"}],
Cell[2924, 94, 4658, 144, 162, "DefinitionBox",
  CellTags->"S5.70.1"],
Cell[7585, 240, 77, 1, 15, "Caption",
  CellTags->"S5.70.1"],
Cell[7665, 243, 950, 15, 152, "Text",
  CellTags->{"S5.70.1", "1.3"}],
Cell[8618, 260, 78, 1, 40, "MathCaption",
  CellTags->{"S5.70.1", "1.4"}],
Cell[8699, 263, 85, 2, 28, "Input",
  CellTags->"S5.70.1"],
Cell[8787, 267, 138, 4, 40, "MathCaption",
  CellTags->{"S5.70.1", "1.5"}],

Cell[CellGroupData[{
Cell[8950, 275, 75, 2, 28, "Input",
  CellTags->"S5.70.1"],
Cell[9028, 279, 77, 2, 25, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[9120, 284, 164, 4, 40, "MathCaption",
  CellTags->{"S5.70.1", "1.6"}],

Cell[CellGroupData[{
Cell[9309, 292, 83, 2, 70, "Input",
  CellTags->"S5.70.1"],
Cell[9395, 296, 77, 2, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[9487, 301, 83, 1, 70, "MathCaption",
  CellTags->{"S5.70.1", "1.7"}],

Cell[CellGroupData[{
Cell[9595, 306, 86, 2, 70, "Input",
  CellTags->"S5.70.1"],
Cell[9684, 310, 742, 24, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[10441, 337, 92, 1, 70, "MathCaption",
  CellTags->{"S5.70.1", "1.8"}],

Cell[CellGroupData[{
Cell[10558, 342, 102, 2, 70, "Input",
  CellTags->"S5.70.1"],
Cell[10663, 346, 834, 26, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[11512, 375, 1722, 32, 70, "Text",
  CellTags->{"S5.70.1", "1.9"}],
Cell[13237, 409, 256, 6, 70, "Text",
  CellTags->{"S5.70.1", "1.10"}],
Cell[13496, 417, 770, 23, 70, "Text",
  CellTags->{"S5.70.1", "1.11"}],
Cell[14269, 442, 966, 29, 70, "Text",
  CellTags->{"S5.70.1", "1.12"}],
Cell[15238, 473, 104, 1, 70, "MathCaption",
  CellTags->{"S5.70.1", "1.13"}],

Cell[CellGroupData[{
Cell[15367, 478, 118, 5, 70, "Input",
  CellTags->"S5.70.1"],
Cell[15488, 485, 834, 26, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[16337, 514, 102, 1, 70, "MathCaption",
  CellTags->{"S5.70.1", "1.14"}],

Cell[CellGroupData[{
Cell[16464, 519, 100, 2, 70, "Input",
  CellTags->"S5.70.1"],
Cell[16567, 523, 77, 2, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[16659, 528, 216, 5, 70, "MathCaption",
  CellTags->{"S5.70.1", "1.15"}],

Cell[CellGroupData[{
Cell[16900, 537, 93, 2, 70, "Input",
  CellTags->"S5.70.1"],
Cell[16996, 541, 141, 4, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[17152, 548, 88, 1, 70, "MathCaption",
  CellTags->{"S5.70.1", "1.16"}],

Cell[CellGroupData[{
Cell[17265, 553, 97, 2, 70, "Input",
  CellTags->"S5.70.1"],
Cell[17365, 557, 77, 2, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[17457, 562, 1567, 48, 70, "Text",
  CellTags->{"S5.70.1", "1.17"}],
Cell[19027, 612, 919, 21, 70, "Text",
  CellTags->{"S5.70.1", "1.18"}],
Cell[19949, 635, 807, 25, 70, "Text",
  CellTags->{"S5.70.1", "1.19"}],
Cell[20759, 662, 316, 9, 70, "MathCaption",
  CellTags->{"S5.70.1", "1.20"}],

Cell[CellGroupData[{
Cell[21100, 675, 148, 6, 70, "Input",
  CellTags->"S5.70.1"],
Cell[21251, 683, 474, 13, 70, "Message",
  CellTags->"S5.70.1"],
Cell[21728, 698, 69, 2, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[21812, 703, 7052, 202, 70, "DefinitionBox3Col",
  CellTags->"S5.70.1"],
Cell[28867, 907, 157, 7, 70, "Caption",
  CellTags->"S5.70.1"],
Cell[29027, 916, 990, 24, 70, "Text",
  CellTags->{"S5.70.1", "1.21"}],
Cell[30020, 942, 351, 11, 70, "Text",
  CellTags->{"S5.70.1", "1.22"}],
Cell[30374, 955, 232, 6, 70, "MathCaption",
  CellTags->{"S5.70.1", "1.23"}],

Cell[CellGroupData[{
Cell[30631, 965, 87, 2, 70, "Input",
  CellTags->"S5.70.1"],
Cell[30721, 969, 611, 20, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]],
Cell[31347, 992, 130, 3, 70, "MathCaption",
  CellTags->{"S5.70.1", "1.24"}],

Cell[CellGroupData[{
Cell[31502, 999, 93, 2, 70, "Input",
  CellTags->"S5.70.1"],
Cell[31598, 1003, 5796, 149, 70, "Output",
  CellTags->"S5.70.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

