(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17117,        609]*)
(*NotebookOutlinePosition[     19733,        692]*)
(*  CellTagsIndexPosition[     19499,        679]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumberTheory",
 StyleBox["`", "MB"],
 "PrimitiveElement",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.71.1", "1.1"}],

Cell["\<\
This package provides a function for computing primitive elements of multiple \
algebraic extensions of rationals. \
\>", "Text",
 CellTags->{"S5.71.1", "1.2"}],

Cell[TextData[{
 "Given algebraic numbers ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " you can always find a single algebraic number ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that each of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can be expressed as a polynomial in ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with rational coefficients. The number ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is called a primitive element of the field extension ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "(",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ")/",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". In other words, an algebraic number ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a primitive element of ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "(",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ")/",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " iff ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "(",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ") = ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "(",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "). "
}], "Text",
 CellTags->{"S5.71.1", "1.3"}],

Cell[TextData[{
 "The function ",
 StyleBox["PrimitiveElement", "MR"],
 " takes a variable ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and a list of algebraic numbers ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and returns a primitive element ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "(",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ")/",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and a list of polynomials ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "(",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "),\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ",\[ThinSpace]",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "(",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ") such that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " = ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "(",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ") for all ",
 Cell[BoxData[
  FormBox[
   StyleBox["i",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.71.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PrimitiveElement[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",...,", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",...,", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is a primitive element for the extension of rationals by algebraic \
numbers ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ,", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a polynomial in the variable ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" representing ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in terms of the primitive element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.71.1"],

Cell["\<\
The primitive element of an algebraic extension of the rationals. \
\>", "Caption",
 CellTags->"S5.71.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.71.1", "1.5"}],

Cell["<<NumberTheory`PrimitiveElement`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.71.1"],

Cell[TextData[{
 "Here is a primitive element of ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "(",
 StyleBox["Sqrt[2]", "MR"],
 ", ",
 StyleBox["Sqrt[3]", "MR"],
 ")/",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and a list of polynomials showing how to represent ",
 StyleBox["Sqrt[2]", "MR"],
 " and ",
 StyleBox["Sqrt[3]", "MR"],
 " in terms of the primitive element. "
}], "MathCaption",
 CellTags->{"S5.71.1", "1.6"}],

Cell[CellGroupData[{

Cell["PrimitiveElement[z, {Sqrt[2], Sqrt[3]}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.71.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"9", " ", "z"}], "2"]}], "+", 
      FractionBox[
       SuperscriptBox["z", "3"], "2"]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"11", " ", "z"}], "2"], "-", 
      FractionBox[
       SuperscriptBox["z", "3"], "2"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.71.1"]
}, Open  ]],

Cell[TextData[{
 "This checks that the computed polynomials evaluated at the primitive \
element give ",
 StyleBox["Sqrt[2]", "MR"],
 " and ",
 StyleBox["Sqrt[3]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.71.1", "1.7"}],

Cell[CellGroupData[{

Cell["RootReduce[%[[2]] /. z -> %[[1]]]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.71.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["2"], ",", 
   SqrtBox["3"]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.71.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.71.1"->{
    Cell[1776, 53, 145, 6, 36, "Subsection",
      CellTags->{"S5.71.1", "1.1"}],
    Cell[1924, 61, 170, 4, 40, "Text",
      CellTags->{"S5.71.1", "1.2"}],
    Cell[2097, 67, 4557, 162, 72, "Text",
      CellTags->{"S5.71.1", "1.3"}],
    Cell[6657, 231, 3365, 130, 58, "Text",
      CellTags->{"S5.71.1", "1.4"}],
    Cell[10025, 363, 4851, 152, 100, "DefinitionBox",
      CellTags->"S5.71.1"],
    Cell[14879, 517, 115, 3, 15, "Caption",
      CellTags->"S5.71.1"],
    Cell[14997, 522, 78, 1, 40, "MathCaption",
      CellTags->{"S5.71.1", "1.5"}],
    Cell[15078, 525, 95, 2, 28, "Input",
      CellTags->"S5.71.1"],
    Cell[15176, 529, 609, 19, 56, "MathCaption",
      CellTags->{"S5.71.1", "1.6"}],
    Cell[15810, 552, 102, 2, 28, "Input",
      CellTags->"S5.71.1"],
    Cell[15915, 556, 664, 24, 43, "Output",
      CellTags->"S5.71.1"],
    Cell[16594, 583, 226, 8, 56, "MathCaption",
      CellTags->{"S5.71.1", "1.7"}],
    Cell[16845, 595, 96, 2, 28, "Input",
      CellTags->"S5.71.1"],
    Cell[16944, 599, 145, 6, 30, "Output",
      CellTags->"S5.71.1"]},
  "1.1"->{
    Cell[1776, 53, 145, 6, 36, "Subsection",
      CellTags->{"S5.71.1", "1.1"}]},
  "1.2"->{
    Cell[1924, 61, 170, 4, 40, "Text",
      CellTags->{"S5.71.1", "1.2"}]},
  "1.3"->{
    Cell[2097, 67, 4557, 162, 72, "Text",
      CellTags->{"S5.71.1", "1.3"}]},
  "1.4"->{
    Cell[6657, 231, 3365, 130, 58, "Text",
      CellTags->{"S5.71.1", "1.4"}]},
  "1.5"->{
    Cell[14997, 522, 78, 1, 40, "MathCaption",
      CellTags->{"S5.71.1", "1.5"}]},
  "1.6"->{
    Cell[15176, 529, 609, 19, 56, "MathCaption",
      CellTags->{"S5.71.1", "1.6"}]},
  "1.7"->{
    Cell[16594, 583, 226, 8, 56, "MathCaption",
      CellTags->{"S5.71.1", "1.7"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.71.1", 17740, 625},
  {"1.1", 18829, 654},
  {"1.2", 18923, 657},
  {"1.3", 19011, 660},
  {"1.4", 19102, 663},
  {"1.5", 19194, 666},
  {"1.6", 19290, 669},
  {"1.7", 19388, 672}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 145, 6, 36, "Subsection",
  CellTags->{"S5.71.1", "1.1"}],
Cell[1924, 61, 170, 4, 40, "Text",
  CellTags->{"S5.71.1", "1.2"}],
Cell[2097, 67, 4557, 162, 72, "Text",
  CellTags->{"S5.71.1", "1.3"}],
Cell[6657, 231, 3365, 130, 58, "Text",
  CellTags->{"S5.71.1", "1.4"}],
Cell[10025, 363, 4851, 152, 100, "DefinitionBox",
  CellTags->"S5.71.1"],
Cell[14879, 517, 115, 3, 15, "Caption",
  CellTags->"S5.71.1"],
Cell[14997, 522, 78, 1, 40, "MathCaption",
  CellTags->{"S5.71.1", "1.5"}],
Cell[15078, 525, 95, 2, 28, "Input",
  CellTags->"S5.71.1"],
Cell[15176, 529, 609, 19, 56, "MathCaption",
  CellTags->{"S5.71.1", "1.6"}],

Cell[CellGroupData[{
Cell[15810, 552, 102, 2, 28, "Input",
  CellTags->"S5.71.1"],
Cell[15915, 556, 664, 24, 43, "Output",
  CellTags->"S5.71.1"]
}, Open  ]],
Cell[16594, 583, 226, 8, 56, "MathCaption",
  CellTags->{"S5.71.1", "1.7"}],

Cell[CellGroupData[{
Cell[16845, 595, 96, 2, 28, "Input",
  CellTags->"S5.71.1"],
Cell[16944, 599, 145, 6, 30, "Output",
  CellTags->"S5.71.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

