(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     56755,       2023]*)
(*NotebookOutlinePosition[     70050,       2414]*)
(*  CellTagsIndexPosition[     69011,       2369]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "Quaternions",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.7.1", "1.1"}],

Cell[TextData[{
 "This package implements Hamilton\[CloseCurlyQuote]s quaternion algebra. \
Quaternions have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     "TI"], "+", 
    StyleBox["b",
     "TI"], 
    StyleBox["i",
     "TI"], "+", 
    StyleBox["c",
     "TI"], 
    StyleBox["j",
     "TI"], "+", 
    StyleBox["d",
     "TI"], 
    StyleBox["k",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are real numbers. The symbols ",
 Cell[BoxData[
  FormBox[
   StyleBox["i",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["j",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["k",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are multiplied according to the rules ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["i",
      "TI"], "2"], "=", 
    SuperscriptBox[
     StyleBox["j",
      "TI"], "2"], "=", 
    SuperscriptBox[
     StyleBox["k",
      "TI"], "2"], "=", 
    StyleBox["i",
     "TI"], 
    StyleBox["j",
     "TI"], 
    StyleBox["k",
     "TI"], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Quaternions are an extension of the complex numbers, and work much the \
same except that their multiplication is not commutative. For instance, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i",
     "TI"], 
    StyleBox["j",
     "TI"], "=", "-", 
    StyleBox["j",
     "TI"], 
    StyleBox["i",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.7.1", "1.2"}],

Cell[TextData[{
 "Because of the similarities between quaternions and complex numbers, this \
package imitates ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s treatment of complex numbers in many ways. To provide a \
clear distinction between quaternions and complex numbers, all quaternions \
should be entered using the form ",
 StyleBox["Quaternion[", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["c", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["d", "TI"],
 StyleBox["]", "MR"],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["d",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are real numbers. Only limited support is offered to the symbolic form ",
 StyleBox["a", "TI"],
 StyleBox[" + I ", "MR"],
 StyleBox["b", "TI"],
 StyleBox[" + J ", "MR"],
 StyleBox["c", "TI"],
 StyleBox[" + K ", "MR"],
 StyleBox["d", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.7.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Quaternion[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["c", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the quaternion number ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["a",
          "TI"], "+", 
         StyleBox["b",
          "TI"], 
         StyleBox["i",
          "TI"], "+", 
         StyleBox["c",
          "TI"], 
         StyleBox["j",
          "TI"], "+", 
         StyleBox["d",
          "TI"], 
         StyleBox["k",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["QuaternionQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["test whether ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a quaternion number",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FromQuaternion[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["transform the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Quaternion", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to the symbolic form ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" + I ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" + J ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["c", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" + K ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["d", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ToQuaternion[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["transform ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Quaternion", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object if possible ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.7.1"],

Cell["Defining, testing, and transforming quaternions. ", "Caption",
 CellTags->"S5.7.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.7.1", "1.4"}],

Cell["<<Algebra`Quaternions`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.7.1"],

Cell[TextData[{
 StyleBox["Quaternion", "MR"],
 " objects will not automatically simplify to ",
 StyleBox["Complex", "MR"],
 " or ",
 StyleBox["Real", "MR"],
 " numbers. "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.5"}],

Cell[CellGroupData[{

Cell["3 + 2 I + Quaternion[2,0,-6,0] -3 * Quaternion[1,3,-2,0]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"2", ",", 
   RowBox[{"-", "7"}], ",", "0", ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["FromQuaternion", "MR"],
 " transforms this ",
 StyleBox["Quaternion", "MR"],
 " object to an object with head ",
 StyleBox["Complex", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.6"}],

Cell[CellGroupData[{

Cell["FromQuaternion[%]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"7", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "The primary purpose of this package is to define arithmetic for \
quaternions. It adds rules to ",
 StyleBox["Plus", "MR"],
 ", ",
 StyleBox["Minus", "MR"],
 ", ",
 StyleBox["Times", "MR"],
 ", ",
 StyleBox["Divide", "MR"],
 ", and, most importantly, ",
 StyleBox["NonCommutativeMultiply", "MR"],
 ". It is only legal to use ",
 StyleBox["Times", "MR"],
 " when multiplying two nonquaternions or a quaternion by a ",
 StyleBox["scalar", "TI"],
 " (",
 StyleBox["i.e.", "TI"],
 ", real) number. When multiplying two quaternions, you must use ",
 StyleBox["NonCommutativeMultiply", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.7.1", "1.7"}],

Cell["Addition is done component by component. ", "MathCaption",
 CellTags->{"S5.7.1", "1.8"}],

Cell[CellGroupData[{

Cell["Quaternion[1,2,3,4] + Quaternion[2,3,4,5]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"3", ",", "5", ",", "7", ",", "9"}], "]"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["\<\
Be sure to use ** rather than * when multiplying quaternions. \
\>", "MathCaption",
 CellTags->{"S5.7.1", "1.9"}],

Cell[CellGroupData[{

Cell["Quaternion[2,0,-6,3] ** Quaternion[1,3,-2,2]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{"-", "16"}], ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "25"}], "]"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["This multiplication is noncommutative. ", "MathCaption",
 CellTags->{"S5.7.1", "1.10"}],

Cell[CellGroupData[{

Cell["Quaternion[1,3,-2,2] ** Quaternion[2,0,-6,3]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{"-", "16"}], ",", "12", ",", 
   RowBox[{"-", "19"}], ",", 
   RowBox[{"-", "11"}]}], "]"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "Be careful with ",
 StyleBox["Divide", "MR"],
 " since ",
 StyleBox["Mathematica", "TI"],
 "\[CloseCurlyQuote]s internal rules quickly turn it into ",
 StyleBox["Times", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.11"}],

Cell[CellGroupData[{

Cell["Quaternion[1,3,-2,0] / Quaternion[1,0,0,0]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}], " ", 
  RowBox[{"Quaternion", "[", 
   RowBox[{"1", ",", "3", ",", 
    RowBox[{"-", "2"}], ",", "0"}], "]"}]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "Although quaternions are whole algebraic objects, just as with complex \
numbers, it is sometimes useful to look at their component parts. These \
objects form a vector space over the real numbers, with their standard basis \
being ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", 
     StyleBox["i",
      "TI"], ",", 
     StyleBox["j",
      "TI"], ",", 
     StyleBox["k",
      "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". You may use standard ",
 StyleBox["Mathematica", "TI"],
 " techniques for extracting the individual components. However, there are \
other vector\[Hyphen]type parameters such as length and direction which you \
may want to look at as well. "
}], "Text",
 CellTags->{"S5.7.1", "1.12"}],

Cell[TextData[{
 "The projection of a quaternion onto ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"i", "j", "k"}],
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " space, the nonreal part of the quaternion, is called the ",
 StyleBox["pure quaternion part", "TI"],
 ". This plays a role similar to the pure imaginary part of a complex number. \
"
}], "Text",
 CellTags->{"S5.7.1", "1.13"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Re[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the real part Re ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Conjugate[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the quaternion conjugate ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["w",
          "TI"], "*"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Abs[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the absolute value ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[VerticalSeparator]", 
         StyleBox["w",
          "TI"], "\[VerticalSeparator]"}], TraditionalForm]], "InlineFormula",
       
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AbsIJK[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the magnitude of the pure quaternion part of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Norm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the sum of the squares of the components of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Sign[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the sign of the quaternion ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AdjustedSignIJK[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the sign of the pure quaternion part of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", adjusted so its first nonzero component is positive",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.7.1"],

Cell["Component functions of quaternions.", "Caption",
 CellTags->"S5.7.1"],

Cell["\<\
In the conjugate of a quaternion, all the signs of the nonreal components are \
reversed. \
\>", "MathCaption",
 CellTags->{"S5.7.1", "1.14"}],

Cell[CellGroupData[{

Cell["q = Conjugate[Quaternion[4,-3,1,-2]]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"4", ",", "3", ",", 
   RowBox[{"-", "1"}], ",", "2"}], "]"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["\<\
The sign of a quaternion is defined in the same way as the sign of a complex \
number. It is the \[OpenCurlyDoubleQuote]direction\[CloseCurlyDoubleQuote] of \
the quaternion. \
\>", "MathCaption",
 CellTags->{"S5.7.1", "1.15"}],

Cell[CellGroupData[{

Cell["Sign[q]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{"2", " ", 
    SqrtBox[
     FractionBox["2", "15"]]}], ",", 
   SqrtBox[
    FractionBox["3", "10"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["30"]]}], ",", 
   SqrtBox[
    FractionBox["2", "15"]]}], "]"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["This returns a quaternion with norm 1 and real part 0. ", "MathCaption",
 CellTags->{"S5.7.1", "1.16"}],

Cell[CellGroupData[{

Cell["AdjustedSignIJK[q]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"0", ",", 
   FractionBox["3", 
    SqrtBox["14"]], ",", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["14"]]}], ",", 
   SqrtBox[
    FractionBox["2", "7"]]}], "]"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["This gives the standard Euclidean length. ", "MathCaption",
 CellTags->{"S5.7.1", "1.17"}],

Cell[CellGroupData[{

Cell["Abs[q]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 SqrtBox["30"]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "A quaternion with a zero ",
 StyleBox["I", "MR"],
 " component will still have a nonzero pure quaternion part. "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.18"}],

Cell[CellGroupData[{

Cell["AbsIJK[Quaternion[1,0,2,3]]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 SqrtBox["13"]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "For a complex number ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["z",
     "TI"], "=", 
    StyleBox["x",
     "TI"], "+", 
    StyleBox["i",
     "TI"], 
    StyleBox["y",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["z",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["e",
      "TI"], 
     StyleBox["x",
      "TI"]], 
    RowBox[{"(", 
     RowBox[{"cos", 
      StyleBox["y",
       "TI"], "+", 
      StyleBox["i",
       "TI"], "sin", 
      StyleBox["y",
       "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The package defines ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["q",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in a similar way, using the pure quaternion part of ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " instead of the pure imaginary part of a complex number. Indeed, it makes \
analogous definitions for the following elementary functions: ",
 StyleBox["Exp", "MR"],
 ", ",
 StyleBox["Log", "MR"],
 ", ",
 StyleBox["Cos", "MR"],
 ", ",
 StyleBox["Sin", "MR"],
 ", ",
 StyleBox["Tan", "MR"],
 ", ",
 StyleBox["Sec", "MR"],
 ", ",
 StyleBox["Csc", "MR"],
 ", ",
 StyleBox["Cot", "MR"],
 ", ",
 StyleBox["ArcCos", "MR"],
 ", ",
 StyleBox["ArcSin", "MR"],
 ", ",
 StyleBox["ArcTan", "MR"],
 ", ",
 StyleBox["ArcSec", "MR"],
 ", ",
 StyleBox["ArcCsc", "MR"],
 ", ",
 StyleBox["ArcCot", "MR"],
 ", ",
 StyleBox["Cosh", "MR"],
 ", ",
 StyleBox["Sinh", "MR"],
 ", ",
 StyleBox["Tanh", "MR"],
 ", ",
 StyleBox["Sech", "MR"],
 ", ",
 StyleBox["Csch", "MR"],
 ", ",
 StyleBox["Coth", "MR"],
 ", ",
 StyleBox["ArcCosh", "MR"],
 ", ",
 StyleBox["ArcSinh", "MR"],
 ", ",
 StyleBox["ArcTanh", "MR"],
 ", ",
 StyleBox["ArcSech", "MR"],
 ", ",
 StyleBox["ArcCsch", "MR"],
 ", and ",
 StyleBox["ArcCoth", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.7.1", "1.19"}],

Cell["The exponential of a quaternion can be quite complicated. ", \
"MathCaption",
 CellTags->{"S5.7.1", "1.20"}],

Cell[CellGroupData[{

Cell["Exp[Quaternion[2,3,1,6]]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "2"], " ", 
    RowBox[{"Cos", "[", 
     SqrtBox["46"], "]"}]}], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["\[ExponentialE]", "2"], " ", 
     RowBox[{"Sin", "[", 
      SqrtBox["46"], "]"}]}], 
    SqrtBox["46"]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "2"], " ", 
     RowBox[{"Sin", "[", 
      SqrtBox["46"], "]"}]}], 
    SqrtBox["46"]], ",", 
   RowBox[{"3", " ", 
    SqrtBox[
     FractionBox["2", "23"]], " ", 
    SuperscriptBox["\[ExponentialE]", "2"], " ", 
    RowBox[{"Sin", "[", 
     SqrtBox["46"], "]"}]}]}], "]"}]], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["\<\
Just as with complex numbers, it is important to beware of branch cuts. \
\>", "MathCaption",
 CellTags->{"S5.7.1", "1.21"}],

Cell[CellGroupData[{

Cell["Sin[Cos[Quaternion[.3,.1,.5,.5]]]", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
  "0.9601629306397526`", ",", "0.011457679117870483`", ",", 
   "0.05728839558935242`", ",", "0.05728839558935242`"}], "]"}]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["\<\
A four\[Hyphen]dimensional analog of deMoivre\[CloseCurlyQuote]s theorem is \
used for calculating powers of quaternions. \
\>", "MathCaption",
 CellTags->{"S5.7.1", "1.22"}],

Cell[CellGroupData[{

Cell["Quaternion[1,2,0,1]^2.5", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   RowBox[{"-", "9.060398190482424`"}], ",", "2.2074085023116488`", ",", "0", 
   ",", "1.1037042511558244`"}], "]"}]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "The functions so far have been intended to work with quaternions whose \
components are arbitrary real numbers. Just as the integers and Gaussian \
integers are interesting subsets of the reals and complexes, there is a \
special subset of the quaternions called the quaternion integers. This subset \
is a little broader than one might expect. It includes not only those \
quaternions that have all integer components, but also those quaternions that \
have all components being odd multiples of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". In this subset there are 24 quaternions that have multiplicative \
inverses. These are the ",
 StyleBox["units", "TI"],
 " of the algebra. They correspond roughly to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     StyleBox["i",
      "TI"], ",", "-", 
     StyleBox["i",
      "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the Gaussian integers. "
}], "Text",
 CellTags->{"S5.7.1", "1.23"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Round[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the closest integer quaternion to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OddQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["test whether the quaternion ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is odd",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EvenQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["test whether the quaternion ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is even",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["IntegerQuaternionQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["test whether the quaternion ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is an integer quaternion",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["UnitQuaternions", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the list of 24 units of Hamilton\[CloseCurlyQuote]s division algebra",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["UnitQuaternionQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["test whether ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a unit quaternion",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.7.1"],

Cell["Integer quaternion functions.", "Caption",
 CellTags->"S5.7.1"],

Cell[TextData[{
 StyleBox["Round", "MR"],
 " for quaternions returns a ",
 StyleBox["Quaternion", "MR"],
 " in which either all components are integers, or all components are odd \
multiples of 1/2. "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.24"}],

Cell[CellGroupData[{

Cell["Round[Quaternion[1/2,3,4,5/2]]", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"0", ",", "3", ",", "4", ",", "2"}], "]"}]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["A quaternion is even if its norm is even. ", "MathCaption",
 CellTags->{"S5.7.1", "1.25"}],

Cell[CellGroupData[{

Cell["EvenQ[Quaternion[2,3,4,5]]", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["\<\
A quaternion integer has components that are either all integers or all \
halves of odd integers. \
\>", "MathCaption",
 CellTags->{"S5.7.1", "1.26"}],

Cell[CellGroupData[{

Cell["IntegerQuaternionQ[Quaternion[3/2,1/2, -1/2,5/2]]", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "Given a quaternion ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and a unit quaternion ",
 Cell[BoxData[
  FormBox[
   StyleBox["e",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", then ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"q", "e"}],
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"e", "q"}],
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are, respectively, right and left ",
 StyleBox["associates", "TI"],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". It is useful to choose an arbitrary associate and call it the ",
 StyleBox["primary", "TI"],
 " associate. This package chooses the associate with the largest real \
component. "
}], "Text",
 CellTags->{"S5.7.1", "1.27"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["LeftAssociates[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the list of 24 left associates of the quaternion ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RightAssociates[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the list of 24 right associates of the quaternion ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrimaryLeftAssociate[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["side", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the primary left associate of the quaternion ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PrimaryRightAssociate[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["side", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the primary right associate of the quaternion ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.7.1"],

Cell["The associates of an integer quaternion. ", "Caption",
 CellTags->"S5.7.1"],

Cell["This is the primary left associate of the quaternion. ", "MathCaption",
 CellTags->{"S5.7.1", "1.28"}],

Cell[CellGroupData[{

Cell["PrimaryLeftAssociate[Quaternion[1,4,5,3]]", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   FractionBox["13", "2"], ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["1", "2"]}], "]"}]], "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["The primary right associate is often very similar. ", "MathCaption",
 CellTags->{"S5.7.1", "1.29"}],

Cell[CellGroupData[{

Cell["PrimaryRightAssociate[Quaternion[1,4,5,3]]", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   FractionBox["13", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["3", "2"]}], "]"}]], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "Quaternion multiplication is noncommutative, so there are two greatest \
common denominators, one for the left side and one for the right. Since this \
function depends on the value returned by ",
 StyleBox["PrimaryAssociate", "MR"],
 ", the ",
 StyleBox["RightGCD", "MR"],
 " and ",
 StyleBox["LeftGCD", "MR"],
 " are not unique. "
}], "Text",
 CellTags->{"S5.7.1", "1.30"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["LeftGCD[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the greatest common left divisor of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["u",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RightGCD[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the greatest common right divisor of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["u",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Mod[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["w", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" modulo ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["u",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" (remainder on division of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["w",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["u",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[")",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.7.1"],

Cell["Some integer division functions.", "Caption",
 CellTags->"S5.7.1"],

Cell[TextData[{
 "The largest quaternion that divides both of these is ",
 StyleBox["Quaternion[1,0,0,0]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.31"}],

Cell[CellGroupData[{

Cell["LeftGCD[Quaternion[1,3,4,1], Quaternion[3,4,1,2]]", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["LeftGCD", "MR"],
 " and the ",
 StyleBox["RightGCD", "MR"],
 " can be quite different. "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.32"}],

Cell[CellGroupData[{

Cell["RightGCD[Quaternion[1,3,4,1], Quaternion[3,4,1,2]]", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}], "]"}]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "Just as with complex numbers, the quaternion ",
 StyleBox["Mod", "MR"],
 " works recursively. "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.33"}],

Cell[CellGroupData[{

Cell["Mod[Quaternion[-3,4,1,2],3]", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"0", ",", "1", ",", "1", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell["You can specify a quaternion as the modulus. ", "MathCaption",
 CellTags->{"S5.7.1", "1.34"}],

Cell[CellGroupData[{

Cell["Mod[Quaternion[1,3,4,1], Quaternion[3,4,1,2]]", "Input",
 CellLabel->"In[24]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData[
 RowBox[{"Quaternion", "[", 
  RowBox[{"1", ",", "1", ",", 
   RowBox[{"-", "1"}], ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[24]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["PrimeQ", "MR"],
 " has the option ",
 StyleBox["GaussianIntegers->True", "MR"],
 " that checks to see if a number is prime with respect to the Gaussian \
integers. This package extends ",
 StyleBox["PrimeQ", "MR"],
 " farther to check if a number is prime with respect to the quaternions. "
}], "Text",
 CellTags->{"S5.7.1", "1.35"}],

Cell[TextData[{
 "Lagrange proved that every integer can be expressed as a sum of squares of, \
at most, four integers. Therefore, given an integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", there is a quaternion ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with integer components such that ",
 StyleBox["q", "TI"],
 StyleBox[" ** Conjugate[", "MR"],
 StyleBox["q", "TI"],
 StyleBox["] == ", "MR"],
 StyleBox["n", "TI"],
 ". So no integer is prime with respect to the quaternions. In fact, a \
quaternion integer is prime, if and only if, its norm is prime in the usual \
sense. "
}], "Text",
 CellTags->{"S5.7.1", "1.36"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PrimeQ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", Quaternions->True]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["test whether ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a prime with respect to the quaternions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.7.1"],

Cell[TextData[{
 "An extension of ",
 StyleBox["PrimeQ", "MR"],
 "."
}], "Caption",
 CellTags->"S5.7.1"],

Cell["19 is a prime with respect to the Gaussian integers. ", "MathCaption",
 CellTags->{"S5.7.1", "1.37"}],

Cell[CellGroupData[{

Cell["PrimeQ[19, GaussianIntegers->True]", "Input",
 CellLabel->"In[25]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[25]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 "It is not a prime with respect to the quaternions. It can be factored into \
",
 StyleBox["Quaternion[1,4,1,1]", "MR"],
 " and ",
 StyleBox["Quaternion[1,-4,-1,-1]", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.38"}],

Cell[CellGroupData[{

Cell["PrimeQ[19, Quaternions->True]", "Input",
 CellLabel->"In[26]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[26]= ",
 CellTags->"S5.7.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Quaternion[1,3,0,1]", "MR"],
 " is a prime quaternion. "
}], "MathCaption",
 CellTags->{"S5.7.1", "1.39"}],

Cell[CellGroupData[{

Cell["PrimeQ[Quaternion[1,3,0,1], Quaternions->True]", "Input",
 CellLabel->"In[27]:= ",
 CellTags->"S5.7.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[27]= ",
 CellTags->"S5.7.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.7.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.7.1", "1.1"}],
    Cell[1913, 61, 2451, 100, 88, "Text",
      CellTags->{"S5.7.1", "1.2"}],
    Cell[4367, 163, 1421, 50, 88, "Text",
      CellTags->{"S5.7.1", "1.3"}],
    Cell[5791, 215, 6056, 195, 126, "DefinitionBox",
      CellTags->"S5.7.1"],
    Cell[11850, 412, 89, 1, 15, "Caption",
      CellTags->"S5.7.1"],
    Cell[11942, 415, 77, 1, 40, "MathCaption",
      CellTags->{"S5.7.1", "1.4"}],
    Cell[12022, 418, 84, 2, 28, "Input",
      CellTags->"S5.7.1"],
    Cell[12109, 422, 220, 8, 40, "MathCaption",
      CellTags->{"S5.7.1", "1.5"}],
    Cell[12354, 434, 118, 2, 45, "Input",
      CellTags->"S5.7.1"],
    Cell[12475, 438, 171, 5, 25, "Output",
      CellTags->"S5.7.1"],
    Cell[12661, 446, 222, 8, 40, "MathCaption",
      CellTags->{"S5.7.1", "1.6"}],
    Cell[12908, 458, 79, 2, 28, "Input",
      CellTags->"S5.7.1"],
    Cell[12990, 462, 130, 4, 25, "Output",
      CellTags->"S5.7.1"],
    Cell[13135, 469, 652, 22, 70, "Text",
      CellTags->{"S5.7.1", "1.7"}],
    Cell[13790, 493, 94, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.8"}],
    Cell[13909, 498, 103, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[14015, 502, 152, 4, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[14182, 509, 123, 3, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.9"}],
    Cell[14330, 516, 106, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[14439, 520, 192, 6, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[14646, 529, 93, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.10"}],
    Cell[14764, 534, 106, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[14873, 538, 213, 7, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[15101, 548, 250, 9, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.11"}],
    Cell[15376, 561, 104, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[15483, 565, 277, 8, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[15775, 576, 806, 22, 70, "Text",
      CellTags->{"S5.7.1", "1.12"}],
    Cell[16584, 600, 446, 13, 70, "Text",
      CellTags->{"S5.7.1", "1.13"}],
    Cell[17033, 615, 6863, 215, 70, "DefinitionBox",
      CellTags->"S5.7.1"],
    Cell[23899, 832, 75, 1, 70, "Caption",
      CellTags->"S5.7.1"],
    Cell[23977, 835, 152, 4, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.14"}],
    Cell[24154, 843, 98, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[24255, 847, 171, 5, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[24441, 855, 237, 5, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.15"}],
    Cell[24703, 864, 69, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[24775, 868, 347, 14, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[25137, 885, 109, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.16"}],
    Cell[25271, 890, 81, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[25355, 894, 284, 11, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[25654, 908, 96, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.17"}],
    Cell[25775, 913, 69, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[25847, 917, 86, 3, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[25948, 923, 180, 5, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.18"}],
    Cell[26153, 932, 90, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[26246, 936, 86, 3, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[26347, 942, 2338, 111, 70, "Text",
      CellTags->{"S5.7.1", "1.19"}],
    Cell[28688, 1055, 114, 2, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.20"}],
    Cell[28827, 1061, 87, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[28917, 1065, 752, 26, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[29684, 1094, 134, 3, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.21"}],
    Cell[29843, 1101, 96, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[29942, 1105, 236, 6, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[30193, 1114, 184, 4, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.22"}],
    Cell[30402, 1122, 86, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[30491, 1126, 229, 6, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[30735, 1135, 1163, 28, 70, "Text",
      CellTags->{"S5.7.1", "1.23"}],
    Cell[31901, 1165, 5705, 178, 70, "DefinitionBox",
      CellTags->"S5.7.1"],
    Cell[37609, 1345, 69, 1, 70, "Caption",
      CellTags->"S5.7.1"],
    Cell[37681, 1348, 250, 7, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.24"}],
    Cell[37956, 1359, 93, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[38052, 1363, 153, 4, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[38220, 1370, 96, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.25"}],
    Cell[38341, 1375, 89, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[38433, 1379, 77, 2, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[38525, 1384, 160, 4, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.26"}],
    Cell[38710, 1392, 112, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[38825, 1396, 77, 2, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[38917, 1401, 1115, 40, 70, "Text",
      CellTags->{"S5.7.1", "1.27"}],
    Cell[40035, 1443, 4355, 134, 70, "DefinitionBox",
      CellTags->"S5.7.1"],
    Cell[44393, 1579, 81, 1, 70, "Caption",
      CellTags->"S5.7.1"],
    Cell[44477, 1582, 108, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.28"}],
    Cell[44610, 1587, 104, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[44717, 1591, 242, 8, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[44974, 1602, 105, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.29"}],
    Cell[45104, 1607, 105, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[45212, 1611, 242, 8, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[45469, 1622, 393, 11, 70, "Text",
      CellTags->{"S5.7.1", "1.30"}],
    Cell[45865, 1635, 5162, 161, 70, "DefinitionBox",
      CellTags->"S5.7.1"],
    Cell[51030, 1798, 72, 1, 70, "Caption",
      CellTags->"S5.7.1"],
    Cell[51105, 1801, 169, 5, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.31"}],
    Cell[51299, 1810, 112, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[51414, 1814, 153, 4, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[51582, 1821, 174, 7, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.32"}],
    Cell[51781, 1832, 113, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[51897, 1836, 261, 9, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[52173, 1848, 163, 5, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.33"}],
    Cell[52361, 1857, 90, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[52454, 1861, 172, 5, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[52641, 1869, 99, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.34"}],
    Cell[52765, 1874, 108, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[52876, 1878, 172, 5, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[53063, 1886, 360, 9, 70, "Text",
      CellTags->{"S5.7.1", "1.35"}],
    Cell[53426, 1897, 821, 24, 70, "Text",
      CellTags->{"S5.7.1", "1.36"}],
    Cell[54250, 1923, 1237, 38, 70, "DefinitionBox",
      CellTags->"S5.7.1"],
    Cell[55490, 1963, 104, 5, 70, "Caption",
      CellTags->"S5.7.1"],
    Cell[55597, 1970, 107, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.37"}],
    Cell[55729, 1975, 97, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[55829, 1979, 77, 2, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[55921, 1984, 246, 8, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.38"}],
    Cell[56192, 1996, 92, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[56287, 2000, 78, 2, 70, "Output",
      CellTags->"S5.7.1"],
    Cell[56380, 2005, 133, 4, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.39"}],
    Cell[56538, 2013, 109, 2, 70, "Input",
      CellTags->"S5.7.1"],
    Cell[56650, 2017, 77, 2, 70, "Output",
      CellTags->"S5.7.1"]},
  "1.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.7.1", "1.1"}]},
  "1.2"->{
    Cell[1913, 61, 2451, 100, 88, "Text",
      CellTags->{"S5.7.1", "1.2"}]},
  "1.3"->{
    Cell[4367, 163, 1421, 50, 88, "Text",
      CellTags->{"S5.7.1", "1.3"}]},
  "1.4"->{
    Cell[11942, 415, 77, 1, 40, "MathCaption",
      CellTags->{"S5.7.1", "1.4"}]},
  "1.5"->{
    Cell[12109, 422, 220, 8, 40, "MathCaption",
      CellTags->{"S5.7.1", "1.5"}]},
  "1.6"->{
    Cell[12661, 446, 222, 8, 40, "MathCaption",
      CellTags->{"S5.7.1", "1.6"}]},
  "1.7"->{
    Cell[13135, 469, 652, 22, 70, "Text",
      CellTags->{"S5.7.1", "1.7"}]},
  "1.8"->{
    Cell[13790, 493, 94, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.8"}]},
  "1.9"->{
    Cell[14182, 509, 123, 3, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.9"}]},
  "1.10"->{
    Cell[14646, 529, 93, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.10"}]},
  "1.11"->{
    Cell[15101, 548, 250, 9, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.11"}]},
  "1.12"->{
    Cell[15775, 576, 806, 22, 70, "Text",
      CellTags->{"S5.7.1", "1.12"}]},
  "1.13"->{
    Cell[16584, 600, 446, 13, 70, "Text",
      CellTags->{"S5.7.1", "1.13"}]},
  "1.14"->{
    Cell[23977, 835, 152, 4, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.14"}]},
  "1.15"->{
    Cell[24441, 855, 237, 5, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.15"}]},
  "1.16"->{
    Cell[25137, 885, 109, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.16"}]},
  "1.17"->{
    Cell[25654, 908, 96, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.17"}]},
  "1.18"->{
    Cell[25948, 923, 180, 5, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.18"}]},
  "1.19"->{
    Cell[26347, 942, 2338, 111, 70, "Text",
      CellTags->{"S5.7.1", "1.19"}]},
  "1.20"->{
    Cell[28688, 1055, 114, 2, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.20"}]},
  "1.21"->{
    Cell[29684, 1094, 134, 3, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.21"}]},
  "1.22"->{
    Cell[30193, 1114, 184, 4, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.22"}]},
  "1.23"->{
    Cell[30735, 1135, 1163, 28, 70, "Text",
      CellTags->{"S5.7.1", "1.23"}]},
  "1.24"->{
    Cell[37681, 1348, 250, 7, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.24"}]},
  "1.25"->{
    Cell[38220, 1370, 96, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.25"}]},
  "1.26"->{
    Cell[38525, 1384, 160, 4, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.26"}]},
  "1.27"->{
    Cell[38917, 1401, 1115, 40, 70, "Text",
      CellTags->{"S5.7.1", "1.27"}]},
  "1.28"->{
    Cell[44477, 1582, 108, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.28"}]},
  "1.29"->{
    Cell[44974, 1602, 105, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.29"}]},
  "1.30"->{
    Cell[45469, 1622, 393, 11, 70, "Text",
      CellTags->{"S5.7.1", "1.30"}]},
  "1.31"->{
    Cell[51105, 1801, 169, 5, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.31"}]},
  "1.32"->{
    Cell[51582, 1821, 174, 7, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.32"}]},
  "1.33"->{
    Cell[52173, 1848, 163, 5, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.33"}]},
  "1.34"->{
    Cell[52641, 1869, 99, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.34"}]},
  "1.35"->{
    Cell[53063, 1886, 360, 9, 70, "Text",
      CellTags->{"S5.7.1", "1.35"}]},
  "1.36"->{
    Cell[53426, 1897, 821, 24, 70, "Text",
      CellTags->{"S5.7.1", "1.36"}]},
  "1.37"->{
    Cell[55597, 1970, 107, 1, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.37"}]},
  "1.38"->{
    Cell[55921, 1984, 246, 8, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.38"}]},
  "1.39"->{
    Cell[56380, 2005, 133, 4, 70, "MathCaption",
      CellTags->{"S5.7.1", "1.39"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.7.1", 57377, 2039},
  {"1.1", 65245, 2248},
  {"1.2", 65338, 2251},
  {"1.3", 65428, 2254},
  {"1.4", 65518, 2257},
  {"1.5", 65613, 2260},
  {"1.6", 65709, 2263},
  {"1.7", 65805, 2266},
  {"1.8", 65895, 2269},
  {"1.9", 65990, 2272},
  {"1.10", 66087, 2275},
  {"1.11", 66184, 2278},
  {"1.12", 66282, 2281},
  {"1.13", 66374, 2284},
  {"1.14", 66466, 2287},
  {"1.15", 66564, 2290},
  {"1.16", 66662, 2293},
  {"1.17", 66760, 2296},
  {"1.18", 66857, 2299},
  {"1.19", 66955, 2302},
  {"1.20", 67049, 2305},
  {"1.21", 67148, 2308},
  {"1.22", 67247, 2311},
  {"1.23", 67346, 2314},
  {"1.24", 67440, 2317},
  {"1.25", 67539, 2320},
  {"1.26", 67637, 2323},
  {"1.27", 67736, 2326},
  {"1.28", 67830, 2329},
  {"1.29", 67929, 2332},
  {"1.30", 68028, 2335},
  {"1.31", 68121, 2338},
  {"1.32", 68220, 2341},
  {"1.33", 68319, 2344},
  {"1.34", 68418, 2347},
  {"1.35", 68516, 2350},
  {"1.36", 68608, 2353},
  {"1.37", 68701, 2356},
  {"1.38", 68800, 2359},
  {"1.39", 68899, 2362}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 6, 36, "Subsection",
  CellTags->{"S5.7.1", "1.1"}],
Cell[1913, 61, 2451, 100, 88, "Text",
  CellTags->{"S5.7.1", "1.2"}],
Cell[4367, 163, 1421, 50, 88, "Text",
  CellTags->{"S5.7.1", "1.3"}],
Cell[5791, 215, 6056, 195, 126, "DefinitionBox",
  CellTags->"S5.7.1"],
Cell[11850, 412, 89, 1, 15, "Caption",
  CellTags->"S5.7.1"],
Cell[11942, 415, 77, 1, 40, "MathCaption",
  CellTags->{"S5.7.1", "1.4"}],
Cell[12022, 418, 84, 2, 28, "Input",
  CellTags->"S5.7.1"],
Cell[12109, 422, 220, 8, 40, "MathCaption",
  CellTags->{"S5.7.1", "1.5"}],

Cell[CellGroupData[{
Cell[12354, 434, 118, 2, 45, "Input",
  CellTags->"S5.7.1"],
Cell[12475, 438, 171, 5, 25, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[12661, 446, 222, 8, 40, "MathCaption",
  CellTags->{"S5.7.1", "1.6"}],

Cell[CellGroupData[{
Cell[12908, 458, 79, 2, 28, "Input",
  CellTags->"S5.7.1"],
Cell[12990, 462, 130, 4, 25, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[13135, 469, 652, 22, 70, "Text",
  CellTags->{"S5.7.1", "1.7"}],
Cell[13790, 493, 94, 1, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.8"}],

Cell[CellGroupData[{
Cell[13909, 498, 103, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[14015, 502, 152, 4, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[14182, 509, 123, 3, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.9"}],

Cell[CellGroupData[{
Cell[14330, 516, 106, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[14439, 520, 192, 6, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[14646, 529, 93, 1, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.10"}],

Cell[CellGroupData[{
Cell[14764, 534, 106, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[14873, 538, 213, 7, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[15101, 548, 250, 9, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.11"}],

Cell[CellGroupData[{
Cell[15376, 561, 104, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[15483, 565, 277, 8, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[15775, 576, 806, 22, 70, "Text",
  CellTags->{"S5.7.1", "1.12"}],
Cell[16584, 600, 446, 13, 70, "Text",
  CellTags->{"S5.7.1", "1.13"}],
Cell[17033, 615, 6863, 215, 70, "DefinitionBox",
  CellTags->"S5.7.1"],
Cell[23899, 832, 75, 1, 70, "Caption",
  CellTags->"S5.7.1"],
Cell[23977, 835, 152, 4, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.14"}],

Cell[CellGroupData[{
Cell[24154, 843, 98, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[24255, 847, 171, 5, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[24441, 855, 237, 5, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.15"}],

Cell[CellGroupData[{
Cell[24703, 864, 69, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[24775, 868, 347, 14, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[25137, 885, 109, 1, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.16"}],

Cell[CellGroupData[{
Cell[25271, 890, 81, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[25355, 894, 284, 11, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[25654, 908, 96, 1, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.17"}],

Cell[CellGroupData[{
Cell[25775, 913, 69, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[25847, 917, 86, 3, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[25948, 923, 180, 5, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.18"}],

Cell[CellGroupData[{
Cell[26153, 932, 90, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[26246, 936, 86, 3, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[26347, 942, 2338, 111, 70, "Text",
  CellTags->{"S5.7.1", "1.19"}],
Cell[28688, 1055, 114, 2, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.20"}],

Cell[CellGroupData[{
Cell[28827, 1061, 87, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[28917, 1065, 752, 26, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[29684, 1094, 134, 3, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.21"}],

Cell[CellGroupData[{
Cell[29843, 1101, 96, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[29942, 1105, 236, 6, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[30193, 1114, 184, 4, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.22"}],

Cell[CellGroupData[{
Cell[30402, 1122, 86, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[30491, 1126, 229, 6, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[30735, 1135, 1163, 28, 70, "Text",
  CellTags->{"S5.7.1", "1.23"}],
Cell[31901, 1165, 5705, 178, 70, "DefinitionBox",
  CellTags->"S5.7.1"],
Cell[37609, 1345, 69, 1, 70, "Caption",
  CellTags->"S5.7.1"],
Cell[37681, 1348, 250, 7, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.24"}],

Cell[CellGroupData[{
Cell[37956, 1359, 93, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[38052, 1363, 153, 4, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[38220, 1370, 96, 1, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.25"}],

Cell[CellGroupData[{
Cell[38341, 1375, 89, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[38433, 1379, 77, 2, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[38525, 1384, 160, 4, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.26"}],

Cell[CellGroupData[{
Cell[38710, 1392, 112, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[38825, 1396, 77, 2, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[38917, 1401, 1115, 40, 70, "Text",
  CellTags->{"S5.7.1", "1.27"}],
Cell[40035, 1443, 4355, 134, 70, "DefinitionBox",
  CellTags->"S5.7.1"],
Cell[44393, 1579, 81, 1, 70, "Caption",
  CellTags->"S5.7.1"],
Cell[44477, 1582, 108, 1, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.28"}],

Cell[CellGroupData[{
Cell[44610, 1587, 104, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[44717, 1591, 242, 8, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[44974, 1602, 105, 1, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.29"}],

Cell[CellGroupData[{
Cell[45104, 1607, 105, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[45212, 1611, 242, 8, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[45469, 1622, 393, 11, 70, "Text",
  CellTags->{"S5.7.1", "1.30"}],
Cell[45865, 1635, 5162, 161, 70, "DefinitionBox",
  CellTags->"S5.7.1"],
Cell[51030, 1798, 72, 1, 70, "Caption",
  CellTags->"S5.7.1"],
Cell[51105, 1801, 169, 5, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.31"}],

Cell[CellGroupData[{
Cell[51299, 1810, 112, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[51414, 1814, 153, 4, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[51582, 1821, 174, 7, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.32"}],

Cell[CellGroupData[{
Cell[51781, 1832, 113, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[51897, 1836, 261, 9, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[52173, 1848, 163, 5, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.33"}],

Cell[CellGroupData[{
Cell[52361, 1857, 90, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[52454, 1861, 172, 5, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[52641, 1869, 99, 1, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.34"}],

Cell[CellGroupData[{
Cell[52765, 1874, 108, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[52876, 1878, 172, 5, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[53063, 1886, 360, 9, 70, "Text",
  CellTags->{"S5.7.1", "1.35"}],
Cell[53426, 1897, 821, 24, 70, "Text",
  CellTags->{"S5.7.1", "1.36"}],
Cell[54250, 1923, 1237, 38, 70, "DefinitionBox",
  CellTags->"S5.7.1"],
Cell[55490, 1963, 104, 5, 70, "Caption",
  CellTags->"S5.7.1"],
Cell[55597, 1970, 107, 1, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.37"}],

Cell[CellGroupData[{
Cell[55729, 1975, 97, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[55829, 1979, 77, 2, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[55921, 1984, 246, 8, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.38"}],

Cell[CellGroupData[{
Cell[56192, 1996, 92, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[56287, 2000, 78, 2, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]],
Cell[56380, 2005, 133, 4, 70, "MathCaption",
  CellTags->{"S5.7.1", "1.39"}],

Cell[CellGroupData[{
Cell[56538, 2013, 109, 2, 70, "Input",
  CellTags->"S5.7.1"],
Cell[56650, 2017, 77, 2, 70, "Output",
  CellTags->"S5.7.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

