(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     43454,       1499]*)
(*NotebookOutlinePosition[     51329,       1730]*)
(*  CellTagsIndexPosition[     50739,       1703]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "DiscreteMath",
 StyleBox["`", "MB"],
 "RSolve",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.21.1", "1.1"}],

Cell[TextData[{
 "A recurrence or difference equation specifies a relationship between \
different values of an unknown sequence. For example, the equation ",
 StyleBox["a[n]", "MR"],
 " ",
 StyleBox["==", "MR"],
 " ",
 StyleBox["a[n-1]", "MR"],
 " ",
 StyleBox["+", "MR"],
 " ",
 StyleBox["a[n-2]", "MR"],
 " specifies that in the unknown sequence ",
 StyleBox["a[n]", "MR"],
 ", the sum of the two previous terms gives the next term."
}], "Text",
 CellTags->{"S5.21.1", "1.2"}],

Cell[TextData[{
 StyleBox["Mathematica", "TI"],
 " includes the built\[Hyphen]in function ",
 StyleBox["RSolve", "MR"],
 " to find solutions to equations of this type. The ",
 StyleBox["RSolve.m", "MR"],
 " package contains an assortment of utility functions useful for \
investigating methods of solving recurrence equations. "
}], "Text",
 CellTags->{"S5.21.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PowerSum[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the generating function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in terms of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is treated as a sequence in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and the sum runs from zero to infinity",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PowerSum[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the generating function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where the sum runs from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to infinity",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExponentialPowerSum[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the exponential generating function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where the sum runs from zero to infinity",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExponentialPowerSum[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the exponential generating function of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where the sum runs from ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["n",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to infinity",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.21.1"],

Cell["Generating functions of sequences. ", "Caption",
 CellTags->"S5.21.1"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["g",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "=", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["n",
       "TI"], "=", "0"}], "\[Infinity]",
     LimitsPositioning->False], 
    SubscriptBox[
     StyleBox["a",
      "TI"], 
     StyleBox["n",
      "TI"]], 
    SuperscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is called the generating function of the solution ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    SubscriptBox[
     StyleBox["a",
      "TI"], 
     StyleBox["n",
      "TI"]], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The exponential generating function of the sequence is the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["h",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], "=", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["n",
       "TI"], "=", "0"}], "\[Infinity]",
     LimitsPositioning->False], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       StyleBox["a",
        "TI"], 
       StyleBox["n",
        "TI"]], "/", 
      StyleBox["n",
       "TI"], "!"}], ")"}], 
    SuperscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For example, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    StyleBox["x",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the generating function of the sequence ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", "/", 
     StyleBox["n",
      "TI"], "!"}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the exponential generating function of the constant sequence ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", "1", "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.21.1", "1.4"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.21.1", "1.5"}],

Cell["<<DiscreteMath`RSolve`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.21.1"],

Cell[TextData[{
 "This computes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["n",
       "TI"], "=", "0"}], "\[Infinity]",
     LimitsPositioning->False], 
    SuperscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", which is simply a geometric series. "
}], "MathCaption",
 CellTags->{"S5.21.1", "1.6"}],

Cell[CellGroupData[{

Cell["PowerSum[1, {x, n}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "-", "x"}]]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell["\<\
This computes the generating function of the sequence of squares of integers. \
\
\>", "MathCaption",
 CellTags->{"S5.21.1", "1.7"}],

Cell[CellGroupData[{

Cell["PowerSum[n^2, {x, n}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell["\<\
This confirms that the coefficients of the series expansion of the function \
are the squares of the integers. \
\>", "MathCaption",
 CellTags->{"S5.21.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
CoefficientList[Normal[
 Series[%, {x, 0, 10}]], x]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", 
   "49", ",", "64", ",", "81", ",", "100"}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell["\<\
This exponential generating function is simply the Taylor series for the \
exponential. \
\>", "MathCaption",
 CellTags->{"S5.21.1", "1.9"}],

Cell[CellGroupData[{

Cell["ExponentialPowerSum[1, {x, n}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "x"]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell["\<\
Here is the exponential generating function of the sequence of squares of \
integers. \
\>", "MathCaption",
 CellTags->{"S5.21.1", "1.10"}],

Cell[CellGroupData[{

Cell["ExponentialPowerSum[n^2, {x, n}]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], " ", "x", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}]}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell[TextData[{
 "This computes the exponential power sum for a series that has a different \
form when ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is odd and even. The function ",
 StyleBox["Even", "MR"],
 " is provided in the package. It is equivalent to the built\[Hyphen]in ",
 StyleBox["EvenQ", "MR"],
 ", except that it does not evaluate when its argument is symbolic. "
}], "MathCaption",
 CellTags->{"S5.21.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
ExponentialPowerSum[
    n^2 + 4 n If[Even[n], 2^n, 3^n] + 1,
        {x, n}]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}], "+", 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["3", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "3"}], " ", "x"}]], " ", "x"}], "-", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}]], " ", "x"}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], " ", "x"}], "+", 
     RowBox[{
      FractionBox["3", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], " ", "x"}]}], ")"}]}]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["GeneratingFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the ordinary generating functions for the solutions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to the recurrence equation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in terms of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GeneratingFunction[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["eqn",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["eqn",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the ordinary generating functions for the solutions of a system of \
equations",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExponentialGeneratingFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the exponential generating functions for the solutions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to the recurrence equation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["eqn", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in terms of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExponentialGeneratingFunction[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["eqn",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["eqn",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the exponential generating functions for the solutions of a system \
of equations",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.21.1"],

Cell["\<\
Generating functions for the solutions to recurrence equations. \
\>", "Caption",
 CellTags->"S5.21.1"],

Cell["\<\
The solution to the given recurrence equation is the sequence of Fibonacci \
numbers. Thus, this gives the generating function for this sequence. \
\>", "MathCaption",
 CellTags->{"S5.21.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
GeneratingFunction[
 {a[n] == a[n-1] + a[n-2],
 a[0] == a[1] == 1}, a[n], n, x]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell["\<\
This recurrence equation gives the sequence of Bernoulli numbers. \
\>", "MathCaption",
 CellTags->{"S5.21.1", "1.13"}],

Cell[CellGroupData[{

Cell["\<\
ExponentialGeneratingFunction[
 Sum[Binomial[n, k] B[k], {k, 0, n}]  ==
 B[n] + If[n==1, 1, 0],
 B[n], n, x]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   FractionBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", "x"]}]], "}"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell[TextData[{
 "This computes a list of coefficients in the power series of the generating \
function just computed and then cancels a factor of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "!"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " from the ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " term. "
}], "MathCaption",
 CellTags->{"S5.21.1", "1.14"}],

Cell[CellGroupData[{

Cell["\<\
CoefficientList[
 Normal[Series[%[[1,1]], {x, 0, 10}]], x] *
 Table[n!, {n, 0, 10}]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   FractionBox["1", "6"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["1", "42"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["5", "66"]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell["The resulting list contains Bernoulli numbers. ", "MathCaption",
 CellTags->{"S5.21.1", "1.15"}],

Cell[CellGroupData[{

Cell["Table[BernoulliB[n], {n, 0, 10}]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   FractionBox["1", "6"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["1", "42"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["5", "66"]}], "}"}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SeriesTerm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" coefficient in the power series expansion of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" about the point ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["x",
          "TI"], "=", 
         SubscriptBox[
          StyleBox["x",
           "TI"], "0"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SeriesTerm[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, Assumptions -> {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["cond", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["make assumptions about parameters such as ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.21.1"],

Cell["Coefficients of power series. ", "Caption",
 CellTags->"S5.21.1"],

Cell[TextData[{
 "This gives the coefficient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["x",
     "TI"], 
    RowBox[{"-", "2"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the power series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x",
       "TI"], "-", "2"}], ")"}], 
    SuperscriptBox[
     StyleBox["x",
      "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " about ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.21.1", "1.16"}],

Cell[CellGroupData[{

Cell["SeriesTerm[1/((x-2) x^2 ), {x, 0, -2}]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", "2"]}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell[TextData[{
 "The coefficient of a series can be computed for a general value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The default is to assume that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[GreaterEqual]", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.21.1", "1.17"}],

Cell[CellGroupData[{

Cell["SeriesTerm[1/(1-x), {x, 0, n}]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell[TextData[{
 "Here no assumption is made about ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.21.1", "1.18"}],

Cell[CellGroupData[{

Cell["\<\
SeriesTerm[1/(1-x), {x, 0, n},
 Assumptions -> {}]\
\>", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"n", "\[GreaterEqual]", "0"}], ",", "1", ",", "0"}], 
  "]"}]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell[TextData[{
 "Here is another general coefficient where it is assumed that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n",
     "TI"], "\[GreaterEqual]", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.21.1", "1.19"}],

Cell[CellGroupData[{

Cell["SeriesTerm[1/(x - x^3), {x, 0, n}]", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Odd", "[", "n", "]"}], ",", "1", ",", "0"}], "]"}]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell[TextData[{
 "When no assumption is made about ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the result involves the conditional ",
 StyleBox["If", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.21.1", "1.20"}],

Cell[CellGroupData[{

Cell["\<\
SeriesTerm[1/(x - x^3), {x, 0, n},
  Assumptions -> {}]\
\>", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.21.1"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"n", "\[GreaterEqual]", 
    RowBox[{"-", "1"}]}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"Odd", "[", "n", "]"}], ",", "1", ",", "0"}], "]"}], ",", "0"}], 
  "]"}]], "Output",
 CellLabel->"Out[16]= ",
 CellTags->"S5.21.1"]
}, Open  ]],

Cell[TextData[{
 "The options ",
 StyleBox["GeneratingFunctionConstants", "MR"],
 " and ",
 StyleBox["ExponentialGeneratingFunctionConstants", "MR"],
 " can be used to specify constants in the ",
 StyleBox["GeneratingFunction", "MR"],
 " and ",
 StyleBox["ExponentialGeneratingFunction", "MR"],
 " solutions, respectively. "
}], "Text",
 CellTags->{"S5.21.1", "1.21"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value ", "TI",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["GeneratingFunctionConstants", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["C", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["which constant to use in ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["GeneratingFunction", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" solution ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExponentialGeneratingFunctionConstants", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["C", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["which constant to use in ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["ExponentialGeneratingFunction", "MR",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[" solution ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.21.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["GeneratingFunction", "MR"],
 " and ",
 StyleBox["ExponentialGeneratingFunction", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.21.1"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.21.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.21.1", "1.1"}],
    Cell[1914, 61, 479, 16, 56, "Text",
      CellTags->{"S5.21.1", "1.2"}],
    Cell[2396, 79, 371, 9, 56, "Text",
      CellTags->{"S5.21.1", "1.3"}],
    Cell[2770, 90, 7711, 236, 198, "DefinitionBox",
      CellTags->"S5.21.1"],
    Cell[10484, 328, 76, 1, 15, "Caption",
      CellTags->"S5.21.1"],
    Cell[10563, 331, 2242, 89, 100, "Text",
      CellTags->{"S5.21.1", "1.4"}],
    Cell[12808, 422, 78, 1, 40, "MathCaption",
      CellTags->{"S5.21.1", "1.5"}],
    Cell[12889, 425, 85, 2, 28, "Input",
      CellTags->"S5.21.1"],
    Cell[12977, 429, 476, 18, 54, "MathCaption",
      CellTags->{"S5.21.1", "1.6"}],
    Cell[13478, 451, 82, 2, 28, "Input",
      CellTags->"S5.21.1"],
    Cell[13563, 455, 117, 4, 40, "Output",
      CellTags->"S5.21.1"],
    Cell[13695, 462, 142, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.7"}],
    Cell[13862, 470, 84, 2, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[13949, 474, 285, 11, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[14249, 488, 173, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.8"}],
    Cell[14447, 496, 122, 5, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[14572, 503, 224, 6, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[14811, 512, 150, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.9"}],
    Cell[14986, 520, 93, 2, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[15082, 524, 111, 3, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[15208, 530, 149, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.10"}],
    Cell[15382, 538, 95, 2, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[15480, 542, 191, 6, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[15686, 551, 525, 14, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.11"}],
    Cell[16236, 569, 148, 6, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[16387, 577, 859, 27, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[17261, 607, 10601, 323, 70, "DefinitionBox",
      CellTags->"S5.21.1"],
    Cell[27865, 932, 113, 3, 70, "Caption",
      CellTags->"S5.21.1"],
    Cell[27981, 937, 209, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.12"}],
    Cell[28215, 945, 150, 6, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[28368, 953, 247, 9, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[28630, 965, 129, 3, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.13"}],
    Cell[28784, 972, 179, 7, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[28966, 981, 228, 8, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[29209, 992, 663, 21, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.14"}],
    Cell[29897, 1017, 155, 6, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[30055, 1025, 406, 13, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[30476, 1041, 102, 1, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.15"}],
    Cell[30603, 1046, 96, 2, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[30702, 1050, 406, 13, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[31123, 1066, 4721, 145, 70, "DefinitionBox",
      CellTags->"S5.21.1"],
    Cell[35847, 1213, 71, 1, 70, "Caption",
      CellTags->"S5.21.1"],
    Cell[35921, 1216, 779, 30, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.16"}],
    Cell[36725, 1250, 102, 2, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[36830, 1254, 113, 4, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[36958, 1261, 493, 16, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.17"}],
    Cell[37476, 1281, 94, 2, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[37573, 1285, 75, 2, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[37663, 1290, 246, 9, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.18"}],
    Cell[37934, 1303, 122, 5, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[38059, 1310, 177, 6, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[38251, 1319, 314, 10, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.19"}],
    Cell[38590, 1333, 98, 2, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[38691, 1337, 167, 5, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[38873, 1345, 312, 11, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.20"}],
    Cell[39210, 1360, 127, 5, 70, "Input",
      CellTags->"S5.21.1"],
    Cell[39340, 1367, 295, 10, 70, "Output",
      CellTags->"S5.21.1"],
    Cell[39650, 1380, 368, 11, 70, "Text",
      CellTags->{"S5.21.1", "1.21"}],
    Cell[40021, 1393, 3240, 94, 70, "DefinitionBox3Col",
      CellTags->"S5.21.1"],
    Cell[43264, 1489, 174, 7, 70, "Caption",
      CellTags->"S5.21.1"]},
  "1.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.21.1", "1.1"}]},
  "1.2"->{
    Cell[1914, 61, 479, 16, 56, "Text",
      CellTags->{"S5.21.1", "1.2"}]},
  "1.3"->{
    Cell[2396, 79, 371, 9, 56, "Text",
      CellTags->{"S5.21.1", "1.3"}]},
  "1.4"->{
    Cell[10563, 331, 2242, 89, 100, "Text",
      CellTags->{"S5.21.1", "1.4"}]},
  "1.5"->{
    Cell[12808, 422, 78, 1, 40, "MathCaption",
      CellTags->{"S5.21.1", "1.5"}]},
  "1.6"->{
    Cell[12977, 429, 476, 18, 54, "MathCaption",
      CellTags->{"S5.21.1", "1.6"}]},
  "1.7"->{
    Cell[13695, 462, 142, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.7"}]},
  "1.8"->{
    Cell[14249, 488, 173, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.8"}]},
  "1.9"->{
    Cell[14811, 512, 150, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.9"}]},
  "1.10"->{
    Cell[15208, 530, 149, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.10"}]},
  "1.11"->{
    Cell[15686, 551, 525, 14, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.11"}]},
  "1.12"->{
    Cell[27981, 937, 209, 4, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.12"}]},
  "1.13"->{
    Cell[28630, 965, 129, 3, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.13"}]},
  "1.14"->{
    Cell[29209, 992, 663, 21, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.14"}]},
  "1.15"->{
    Cell[30476, 1041, 102, 1, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.15"}]},
  "1.16"->{
    Cell[35921, 1216, 779, 30, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.16"}]},
  "1.17"->{
    Cell[36958, 1261, 493, 16, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.17"}]},
  "1.18"->{
    Cell[37663, 1290, 246, 9, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.18"}]},
  "1.19"->{
    Cell[38251, 1319, 314, 10, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.19"}]},
  "1.20"->{
    Cell[38873, 1345, 312, 11, 70, "MathCaption",
      CellTags->{"S5.21.1", "1.20"}]},
  "1.21"->{
    Cell[39650, 1380, 368, 11, 70, "Text",
      CellTags->{"S5.21.1", "1.21"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.21.1", 44077, 1515},
  {"1.1", 48681, 1636},
  {"1.2", 48775, 1639},
  {"1.3", 48864, 1642},
  {"1.4", 48952, 1645},
  {"1.5", 49045, 1648},
  {"1.6", 49141, 1651},
  {"1.7", 49239, 1654},
  {"1.8", 49336, 1657},
  {"1.9", 49433, 1660},
  {"1.10", 49531, 1663},
  {"1.11", 49630, 1666},
  {"1.12", 49730, 1669},
  {"1.13", 49829, 1672},
  {"1.14", 49928, 1675},
  {"1.15", 50028, 1678},
  {"1.16", 50128, 1681},
  {"1.17", 50229, 1684},
  {"1.18", 50330, 1687},
  {"1.19", 50430, 1690},
  {"1.20", 50531, 1693},
  {"1.21", 50632, 1696}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 135, 6, 36, "Subsection",
  CellTags->{"S5.21.1", "1.1"}],
Cell[1914, 61, 479, 16, 56, "Text",
  CellTags->{"S5.21.1", "1.2"}],
Cell[2396, 79, 371, 9, 56, "Text",
  CellTags->{"S5.21.1", "1.3"}],
Cell[2770, 90, 7711, 236, 198, "DefinitionBox",
  CellTags->"S5.21.1"],
Cell[10484, 328, 76, 1, 15, "Caption",
  CellTags->"S5.21.1"],
Cell[10563, 331, 2242, 89, 100, "Text",
  CellTags->{"S5.21.1", "1.4"}],
Cell[12808, 422, 78, 1, 40, "MathCaption",
  CellTags->{"S5.21.1", "1.5"}],
Cell[12889, 425, 85, 2, 28, "Input",
  CellTags->"S5.21.1"],
Cell[12977, 429, 476, 18, 54, "MathCaption",
  CellTags->{"S5.21.1", "1.6"}],

Cell[CellGroupData[{
Cell[13478, 451, 82, 2, 28, "Input",
  CellTags->"S5.21.1"],
Cell[13563, 455, 117, 4, 40, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[13695, 462, 142, 4, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.7"}],

Cell[CellGroupData[{
Cell[13862, 470, 84, 2, 70, "Input",
  CellTags->"S5.21.1"],
Cell[13949, 474, 285, 11, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[14249, 488, 173, 4, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.8"}],

Cell[CellGroupData[{
Cell[14447, 496, 122, 5, 70, "Input",
  CellTags->"S5.21.1"],
Cell[14572, 503, 224, 6, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[14811, 512, 150, 4, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.9"}],

Cell[CellGroupData[{
Cell[14986, 520, 93, 2, 70, "Input",
  CellTags->"S5.21.1"],
Cell[15082, 524, 111, 3, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[15208, 530, 149, 4, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.10"}],

Cell[CellGroupData[{
Cell[15382, 538, 95, 2, 70, "Input",
  CellTags->"S5.21.1"],
Cell[15480, 542, 191, 6, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[15686, 551, 525, 14, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.11"}],

Cell[CellGroupData[{
Cell[16236, 569, 148, 6, 70, "Input",
  CellTags->"S5.21.1"],
Cell[16387, 577, 859, 27, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[17261, 607, 10601, 323, 70, "DefinitionBox",
  CellTags->"S5.21.1"],
Cell[27865, 932, 113, 3, 70, "Caption",
  CellTags->"S5.21.1"],
Cell[27981, 937, 209, 4, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.12"}],

Cell[CellGroupData[{
Cell[28215, 945, 150, 6, 70, "Input",
  CellTags->"S5.21.1"],
Cell[28368, 953, 247, 9, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[28630, 965, 129, 3, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.13"}],

Cell[CellGroupData[{
Cell[28784, 972, 179, 7, 70, "Input",
  CellTags->"S5.21.1"],
Cell[28966, 981, 228, 8, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[29209, 992, 663, 21, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.14"}],

Cell[CellGroupData[{
Cell[29897, 1017, 155, 6, 70, "Input",
  CellTags->"S5.21.1"],
Cell[30055, 1025, 406, 13, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[30476, 1041, 102, 1, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.15"}],

Cell[CellGroupData[{
Cell[30603, 1046, 96, 2, 70, "Input",
  CellTags->"S5.21.1"],
Cell[30702, 1050, 406, 13, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[31123, 1066, 4721, 145, 70, "DefinitionBox",
  CellTags->"S5.21.1"],
Cell[35847, 1213, 71, 1, 70, "Caption",
  CellTags->"S5.21.1"],
Cell[35921, 1216, 779, 30, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.16"}],

Cell[CellGroupData[{
Cell[36725, 1250, 102, 2, 70, "Input",
  CellTags->"S5.21.1"],
Cell[36830, 1254, 113, 4, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[36958, 1261, 493, 16, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.17"}],

Cell[CellGroupData[{
Cell[37476, 1281, 94, 2, 70, "Input",
  CellTags->"S5.21.1"],
Cell[37573, 1285, 75, 2, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[37663, 1290, 246, 9, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.18"}],

Cell[CellGroupData[{
Cell[37934, 1303, 122, 5, 70, "Input",
  CellTags->"S5.21.1"],
Cell[38059, 1310, 177, 6, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[38251, 1319, 314, 10, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.19"}],

Cell[CellGroupData[{
Cell[38590, 1333, 98, 2, 70, "Input",
  CellTags->"S5.21.1"],
Cell[38691, 1337, 167, 5, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[38873, 1345, 312, 11, 70, "MathCaption",
  CellTags->{"S5.21.1", "1.20"}],

Cell[CellGroupData[{
Cell[39210, 1360, 127, 5, 70, "Input",
  CellTags->"S5.21.1"],
Cell[39340, 1367, 295, 10, 70, "Output",
  CellTags->"S5.21.1"]
}, Open  ]],
Cell[39650, 1380, 368, 11, 70, "Text",
  CellTags->{"S5.21.1", "1.21"}],
Cell[40021, 1393, 3240, 94, 70, "DefinitionBox3Col",
  CellTags->"S5.21.1"],
Cell[43264, 1489, 174, 7, 70, "Caption",
  CellTags->"S5.21.1"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

