(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     30679,       1042]*)
(*NotebookOutlinePosition[     38306,       1269]*)
(*  CellTagsIndexPosition[     37566,       1236]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumberTheory",
 StyleBox["`", "MB"],
 "Ramanujan",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.72.1", "1.1"}],

Cell[TextData[{
 "The Riemann ",
 Cell[BoxData[
  FormBox["\[Zeta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " function "
}], "Text",
 CellTags->{"S5.72.1", "1.2"}],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Zeta]", 
   RowBox[{"(", 
    StyleBox["s",
     "TI"], ")"}], "=", 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["n",
      "TI"], "=", "1"}], "\[Infinity]",
    LimitsPositioning->False], 
   SuperscriptBox[
    StyleBox["n",
     "TI"], 
    RowBox[{"-", 
     StyleBox["s",
      "TI"]}]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.72.1", "1.3"}],

Cell["\<\
is the simplest of all Dirichlet series. Ramanujan studied the Dirichlet \
series \
\>", "Text",
 CellTags->{"S5.72.1", "1.4"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    StyleBox["s",
     "TI"], ")"}], "=", 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["n",
      "TI"], "=", "1"}], "\[Infinity]",
    LimitsPositioning->False], 
   SubscriptBox["\[Tau]", 
    StyleBox["n",
     "TI"]], 
   SuperscriptBox[
    StyleBox["n",
     "TI"], 
    RowBox[{"-", 
     StyleBox["s",
      "TI"]}]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.72.1", "1.5"}],

Cell[TextData[{
 "where the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Tau]", 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the coefficients of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["z",
     "TI"], 
    StyleBox["n",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the series expansion "
}], "Text",
 CellTags->{"S5.72.1", "1.6"}],

Cell[BoxData[
 FormBox[Cell[BoxData[
   FormBox[GridBox[{
      {Cell[TextData[StyleBox[Cell[BoxData[
        FormBox[
         StyleBox[
          RowBox[{
           StyleBox["z",
            "TI"], 
           UnderoverscriptBox["\[Product]", 
            RowBox[{
             StyleBox["k",
              "TI"], "=", "1"}], "\[Infinity]",
            LimitsPositioning->True], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              SuperscriptBox[
               StyleBox["z",
                "TI"], 
               StyleBox["k",
                "TI"]]}], ")"}], "24"]}],
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox["=",
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox[
          RowBox[{
           StyleBox["z",
            "TI"], "-", "24", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "2"], "+", "252", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "3"], "-", "1472", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "4"], "+", "4830", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "5"], "-", "6048", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "6"], "-", "16744", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "7"], "+"}],
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]},
      {Cell[TextData[StyleBox[Cell[BoxData[
        FormBox[
         StyleBox["\[Null]",
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox["\[Null]",
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox[
          RowBox[{"84480", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "8"], "-", "113643", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "9"], "-", "115920", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "10"], "+", "534612", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "11"], "-", "370944", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "12"], "-"}],
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]},
      {Cell[TextData[StyleBox[Cell[BoxData[
        FormBox[
         StyleBox["\[Null]",
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox["\[Null]",
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], Cell[TextData[StyleBox[
       Cell[BoxData[
        FormBox[
         StyleBox[
          RowBox[{"577738", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "13"], "+", "401856", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "14"], "+", "1217160", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "15"], "+", "987136", 
           SuperscriptBox[
            StyleBox["z",
             "TI"], "16"], "-", "\[CenterEllipsis]"}],
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]},
      {Cell[TextData[StyleBox[Cell[BoxData[
        FormBox[
         StyleBox["\[Null]",
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}], "\[Null]", "\[Null]"}
      },
     ColumnAlignments->{Right, Center, Left}], TraditionalForm]],
   UnderoverscriptBoxOptions->{LimitsPositioning->True},
   GridBoxOptions->{ColumnWidths->Automatic}], 
  TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.72.1", "1.7"}],

Cell[TextData[{
 "Just as there is the Riemann hypothesis that all of the nontrivial zeros of \
the ",
 Cell[BoxData[
  FormBox["\[Zeta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " lie on the critical line ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Re", " ", 
    StyleBox["s",
     "TI"], "=", "1", "/", "2"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", there is a conjecture due to Ramanujan that all of the nontrivial zeros \
of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " lie on the critical line ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Re", " ", 
    StyleBox["s",
     "TI"], "=", "6"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The function ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " satisfies the functional equation "
}], "Text",
 CellTags->{"S5.72.1", "1.8"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    StyleBox["s",
     "TI"], ")"}], "\[CapitalGamma]", 
   RowBox[{"(", 
    StyleBox["s",
     "TI"], ")"}], "/", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]"}], ")"}], 
    StyleBox["s",
     "TI"]], "=", 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    RowBox[{"12", "-", 
     StyleBox["s",
      "TI"]}], ")"}], "\[CapitalGamma]", 
   RowBox[{"(", 
    RowBox[{"12", "-", 
     StyleBox["s",
      "TI"]}], ")"}], "/", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]"}], ")"}], 
    RowBox[{"12", "-", 
     StyleBox["s",
      "TI"]}]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.72.1", "1.9"}],

Cell[TextData[{
 "Just as ",
 Cell[BoxData[
  FormBox["\[Zeta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can be split into "
}], "Text",
 CellTags->{"S5.72.1", "1.10"}],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Zeta]", 
   RowBox[{"(", 
    RowBox[{"1", "/", "2", "+", 
     StyleBox["i",
      "TI"], 
     StyleBox["t",
      "TI"]}], ")"}], "=", 
   StyleBox["Z",
    "TI"], 
   RowBox[{"(", 
    StyleBox["t",
     "TI"], ")"}], 
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    RowBox[{"-", 
     StyleBox["i",
      "TI"], "\[CurlyTheta]", 
     RowBox[{"(", 
      StyleBox["t",
       "TI"], ")"}]}]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.72.1", "1.11"}],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   StyleBox["Z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 StyleBox["RiemannSiegelZ", "MR"],
 " and ",
 Cell[BoxData[
  FormBox["\[CurlyTheta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 StyleBox["RiemannSiegelTheta", "MR"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can split into "
}], "Text",
 CellTags->{"S5.72.1", "1.12"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    RowBox[{"6", "+", 
     StyleBox["i",
      "TI"], 
     StyleBox["t",
      "TI"]}], ")"}], "=", 
   StyleBox["z",
    "TI"], 
   RowBox[{"(", 
    StyleBox["t",
     "TI"], ")"}], 
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    RowBox[{"-", 
     StyleBox["i",
      "TI"], "\[Theta]", 
     RowBox[{"(", 
      StyleBox["t",
       "TI"], ")"}]}]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.72.1", "1.13"}],

Cell["where ", "Text",
 CellTags->{"S5.72.1", "1.14"}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["z",
    "TI"], 
   RowBox[{"(", 
    StyleBox["t",
     "TI"], ")"}], "=", "\[CapitalGamma]", 
   RowBox[{"(", 
    RowBox[{"6", "+", 
     StyleBox["i",
      "TI"], 
     StyleBox["t",
      "TI"]}], ")"}], 
   StyleBox["f",
    "TI"], 
   RowBox[{"(", 
    RowBox[{"6", "+", 
     StyleBox["i",
      "TI"], 
     StyleBox["t",
      "TI"]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]"}], ")"}], 
    RowBox[{"-", 
     StyleBox["i",
      "TI"], 
     StyleBox["t",
      "TI"]}]], 
   SqrtBox[
    FractionBox[
     RowBox[{"sinh", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", 
        StyleBox["t",
         "TI"]}], ")"}]}], 
     RowBox[{"\[Pi]", 
      StyleBox["t",
       "TI"], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         StyleBox["t",
          "TI"], "2"]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        SuperscriptBox[
         StyleBox["t",
          "TI"], "2"]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"9", "+", 
        SuperscriptBox[
         StyleBox["t",
          "TI"], "2"]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"16", "+", 
        SuperscriptBox[
         StyleBox["t",
          "TI"], "2"]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"25", "+", 
        SuperscriptBox[
         StyleBox["t",
          "TI"], "2"]}], ")"}]}]]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.72.1", "1.15"}],

Cell["and ", "Text",
 CellTags->{"S5.72.1", "1.16"}],

Cell[BoxData[
 FormBox[
  RowBox[{"\[Theta]", 
   RowBox[{"(", 
    StyleBox["t",
     "TI"], ")"}], "=", 
   FractionBox[
    RowBox[{"-", 
     StyleBox["i",
      "TI"]}], "2"], "log", 
   FractionBox[
    RowBox[{"\[CapitalGamma]", 
     RowBox[{"(", 
      RowBox[{"6", "+", 
       StyleBox["i",
        "TI"], 
       StyleBox["t",
        "TI"]}], ")"}]}], 
    RowBox[{"\[CapitalGamma]", 
     RowBox[{"(", 
      RowBox[{"6", "-", 
       StyleBox["i",
        "TI"], 
       StyleBox["t",
        "TI"]}], ")"}]}]], "-", 
   StyleBox["t",
    "TI"], "log", 
   RowBox[{"(", 
    RowBox[{"2", "\[Pi]"}], ")"}]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.72.1", "1.17"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RamanujanTau[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["n",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" coefficient of the Ramanujan ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]Dirichlet series ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Tau]", 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RamanujanTauGeneratingFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["generating function of the Ramanujan ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]Dirichlet series, ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["z",
          "TI"], 
         UnderoverscriptBox["\[Product]", 
          RowBox[{
           StyleBox["k",
            "TI"], "=", "1"}], "\[Infinity]",
          LimitsPositioning->True], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox[
             StyleBox["z",
              "TI"], 
             StyleBox["k",
              "TI"]]}], ")"}], "24"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RamanujanTauDirichletSeries[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Ramanujan ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]Dirichlet series ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["f",
          "TI"], 
         RowBox[{"(", 
          StyleBox["s",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RamanujanTauTheta[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Ramanujan ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]Dirichlet function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Theta]", 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RamanujanTauZ[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Ramanujan ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]Dirichlet function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["z",
          "TI"], 
         RowBox[{"(", 
          StyleBox["t",
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.72.1"],

Cell[TextData[{
 "Functions related to the Ramanujan ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]Dirichlet series. "
}], "Caption",
 CellTags->"S5.72.1"],

Cell[TextData[{
 "The Ramanujan ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]Dirichlet series is rather difficult to evaluate, especially far \
up the critical line ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Re", " ", 
    StyleBox["s",
     "TI"], "=", "6"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". This package does not provide any great new method to help with this \
effort, but it does use the fastest methods known. "
}], "Text",
 CellTags->{"S5.72.1", "1.18"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.72.1", "1.19"}],

Cell["<<NumberTheory`Ramanujan`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.72.1"],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Tau]", "5"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.72.1", "1.20"}],

Cell[CellGroupData[{

Cell["RamanujanTau[5]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.72.1"],

Cell[BoxData["4830"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.72.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the first five terms in the generating function ",
 StyleBox["RamanujanTauGeneratingFunction[z]", "MR"],
 ".  "
}], "MathCaption",
 CellTags->{"S5.72.1", "1.21"}],

Cell[CellGroupData[{

Cell["Sum[RamanujanTau[n] z^n, {n, 5}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.72.1"],

Cell[BoxData[
 RowBox[{"z", "-", 
  RowBox[{"24", " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"252", " ", 
   SuperscriptBox["z", "3"]}], "-", 
  RowBox[{"1472", " ", 
   SuperscriptBox["z", "4"]}], "+", 
  RowBox[{"4830", " ", 
   SuperscriptBox["z", "5"]}]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.72.1"]
}, Open  ]],

Cell["The generating function can be evaluated numerically. ", "MathCaption",
 CellTags->{"S5.72.1", "1.22"}],

Cell[CellGroupData[{

Cell["RamanujanTauGeneratingFunction[.1]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.72.1"],

Cell[BoxData["0.0061020876712914235`"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.72.1"]
}, Open  ]],

Cell["\<\
The generating function can be evaluated numerically even at some points \
outside the radius of convergence. This uses a functional equation to achieve \
analytic continuation. \
\>", "MathCaption",
 CellTags->{"S5.72.1", "1.23"}],

Cell[CellGroupData[{

Cell["RamanujanTauGeneratingFunction[.99]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.72.1"],

Cell[BoxData["4.1028780370331435983351`9.729763342425878*^-1673"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.72.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the value of the ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]Dirichlet series near the first zero on the critical line. "
}], "MathCaption",
 CellTags->{"S5.72.1", "1.24"}],

Cell[CellGroupData[{

Cell["RamanujanTauDirichletSeries[6 + 9.22I]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.72.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.000403090379812512`", "\[InvisibleSpace]"}], "-", 
  RowBox[{"0.0023901276521193994`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.72.1"]
}, Open  ]],

Cell[TextData[{
 "This is the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " near the same zero. "
}], "MathCaption",
 CellTags->{"S5.72.1", "1.25"}],

Cell[CellGroupData[{

Cell["z = RamanujanTauZ[9.22]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.72.1"],

Cell[BoxData["0.0024238795448048088`"], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.72.1"]
}, Open  ]],

Cell[TextData[{
 "This is the value of ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.72.1", "1.26"}],

Cell[CellGroupData[{

Cell["theta = RamanujanTauTheta[9.22]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.72.1"],

Cell[BoxData["1.4037204336632279`"], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.72.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the value of the ",
 Cell[BoxData[
  FormBox["\[Tau]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]Dirichlet series again. "
}], "MathCaption",
 CellTags->{"S5.72.1", "1.27"}],

Cell[CellGroupData[{

Cell["z Exp[-I theta]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.72.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.0004030903798125004`", "\[InvisibleSpace]"}], "-", 
  RowBox[{"0.002390127652119397`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.72.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.72.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.72.1", "1.1"}],
    Cell[1917, 61, 207, 7, 24, "Text",
      CellTags->{"S5.72.1", "1.2"}],
    Cell[2127, 70, 514, 19, 52, "DisplayFormula",
      CellTags->{"S5.72.1", "1.3"}],
    Cell[2644, 91, 137, 4, 24, "Text",
      CellTags->{"S5.72.1", "1.4"}],
    Cell[2784, 97, 591, 24, 52, "DisplayFormula",
      CellTags->{"S5.72.1", "1.5"}],
    Cell[3378, 123, 487, 19, 24, "Text",
      CellTags->{"S5.72.1", "1.6"}],
    Cell[3868, 144, 7233, 176, 115, "DisplayFormula",
      CellTags->{"S5.72.1", "1.7"}],
    Cell[11104, 322, 1096, 35, 56, "Text",
      CellTags->{"S5.72.1", "1.8"}],
    Cell[12203, 359, 829, 34, 31, "DisplayFormula",
      CellTags->{"S5.72.1", "1.9"}],
    Cell[13035, 395, 213, 7, 24, "Text",
      CellTags->{"S5.72.1", "1.10"}],
    Cell[13251, 404, 610, 25, 31, "DisplayFormula",
      CellTags->{"S5.72.1", "1.11"}],
    Cell[13864, 431, 595, 23, 24, "Text",
      CellTags->{"S5.72.1", "1.12"}],
    Cell[14462, 456, 613, 27, 31, "DisplayFormula",
      CellTags->{"S5.72.1", "1.13"}],
    Cell[15078, 485, 54, 1, 24, "Text",
      CellTags->{"S5.72.1", "1.14"}],
    Cell[15135, 488, 1571, 67, 53, "DisplayFormula",
      CellTags->{"S5.72.1", "1.15"}],
    Cell[16709, 557, 52, 1, 24, "Text",
      CellTags->{"S5.72.1", "1.16"}],
    Cell[16764, 560, 790, 31, 70, "DisplayFormula",
      CellTags->{"S5.72.1", "1.17"}],
    Cell[17557, 593, 8024, 244, 70, "DefinitionBox",
      CellTags->"S5.72.1"],
    Cell[25584, 839, 240, 7, 70, "Caption",
      CellTags->"S5.72.1"],
    Cell[25827, 848, 598, 16, 70, "Text",
      CellTags->{"S5.72.1", "1.18"}],
    Cell[26428, 866, 79, 1, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.19"}],
    Cell[26510, 869, 88, 2, 70, "Input",
      CellTags->"S5.72.1"],
    Cell[26601, 873, 228, 8, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.20"}],
    Cell[26854, 885, 78, 2, 70, "Input",
      CellTags->"S5.72.1"],
    Cell[26935, 889, 77, 2, 70, "Output",
      CellTags->"S5.72.1"],
    Cell[27027, 894, 191, 5, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.21"}],
    Cell[27243, 903, 95, 2, 70, "Input",
      CellTags->"S5.72.1"],
    Cell[27341, 907, 327, 11, 70, "Output",
      CellTags->"S5.72.1"],
    Cell[27683, 921, 109, 1, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.22"}],
    Cell[27817, 926, 97, 2, 70, "Input",
      CellTags->"S5.72.1"],
    Cell[27917, 930, 95, 2, 70, "Output",
      CellTags->"S5.72.1"],
    Cell[28027, 935, 241, 5, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.23"}],
    Cell[28293, 944, 98, 2, 70, "Input",
      CellTags->"S5.72.1"],
    Cell[28394, 948, 122, 2, 70, "Output",
      CellTags->"S5.72.1"],
    Cell[28531, 953, 285, 7, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.24"}],
    Cell[28841, 964, 101, 2, 70, "Input",
      CellTags->"S5.72.1"],
    Cell[28945, 968, 206, 5, 70, "Output",
      CellTags->"S5.72.1"],
    Cell[29166, 976, 253, 9, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.25"}],
    Cell[29444, 989, 86, 2, 70, "Input",
      CellTags->"S5.72.1"],
    Cell[29533, 993, 95, 2, 70, "Output",
      CellTags->"S5.72.1"],
    Cell[29643, 998, 217, 7, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.26"}],
    Cell[29885, 1009, 94, 2, 70, "Input",
      CellTags->"S5.72.1"],
    Cell[29982, 1013, 92, 2, 70, "Output",
      CellTags->"S5.72.1"],
    Cell[30089, 1018, 250, 7, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.27"}],
    Cell[30364, 1029, 78, 2, 70, "Input",
      CellTags->"S5.72.1"],
    Cell[30445, 1033, 206, 5, 70, "Output",
      CellTags->"S5.72.1"]},
  "1.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.72.1", "1.1"}]},
  "1.2"->{
    Cell[1917, 61, 207, 7, 24, "Text",
      CellTags->{"S5.72.1", "1.2"}]},
  "1.3"->{
    Cell[2127, 70, 514, 19, 52, "DisplayFormula",
      CellTags->{"S5.72.1", "1.3"}]},
  "1.4"->{
    Cell[2644, 91, 137, 4, 24, "Text",
      CellTags->{"S5.72.1", "1.4"}]},
  "1.5"->{
    Cell[2784, 97, 591, 24, 52, "DisplayFormula",
      CellTags->{"S5.72.1", "1.5"}]},
  "1.6"->{
    Cell[3378, 123, 487, 19, 24, "Text",
      CellTags->{"S5.72.1", "1.6"}]},
  "1.7"->{
    Cell[3868, 144, 7233, 176, 115, "DisplayFormula",
      CellTags->{"S5.72.1", "1.7"}]},
  "1.8"->{
    Cell[11104, 322, 1096, 35, 56, "Text",
      CellTags->{"S5.72.1", "1.8"}]},
  "1.9"->{
    Cell[12203, 359, 829, 34, 31, "DisplayFormula",
      CellTags->{"S5.72.1", "1.9"}]},
  "1.10"->{
    Cell[13035, 395, 213, 7, 24, "Text",
      CellTags->{"S5.72.1", "1.10"}]},
  "1.11"->{
    Cell[13251, 404, 610, 25, 31, "DisplayFormula",
      CellTags->{"S5.72.1", "1.11"}]},
  "1.12"->{
    Cell[13864, 431, 595, 23, 24, "Text",
      CellTags->{"S5.72.1", "1.12"}]},
  "1.13"->{
    Cell[14462, 456, 613, 27, 31, "DisplayFormula",
      CellTags->{"S5.72.1", "1.13"}]},
  "1.14"->{
    Cell[15078, 485, 54, 1, 24, "Text",
      CellTags->{"S5.72.1", "1.14"}]},
  "1.15"->{
    Cell[15135, 488, 1571, 67, 53, "DisplayFormula",
      CellTags->{"S5.72.1", "1.15"}]},
  "1.16"->{
    Cell[16709, 557, 52, 1, 24, "Text",
      CellTags->{"S5.72.1", "1.16"}]},
  "1.17"->{
    Cell[16764, 560, 790, 31, 70, "DisplayFormula",
      CellTags->{"S5.72.1", "1.17"}]},
  "1.18"->{
    Cell[25827, 848, 598, 16, 70, "Text",
      CellTags->{"S5.72.1", "1.18"}]},
  "1.19"->{
    Cell[26428, 866, 79, 1, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.19"}]},
  "1.20"->{
    Cell[26601, 873, 228, 8, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.20"}]},
  "1.21"->{
    Cell[27027, 894, 191, 5, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.21"}]},
  "1.22"->{
    Cell[27683, 921, 109, 1, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.22"}]},
  "1.23"->{
    Cell[28027, 935, 241, 5, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.23"}]},
  "1.24"->{
    Cell[28531, 953, 285, 7, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.24"}]},
  "1.25"->{
    Cell[29166, 976, 253, 9, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.25"}]},
  "1.26"->{
    Cell[29643, 998, 217, 7, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.26"}]},
  "1.27"->{
    Cell[30089, 1018, 250, 7, 70, "MathCaption",
      CellTags->{"S5.72.1", "1.27"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.72.1", 31302, 1058},
  {"1.1", 34934, 1151},
  {"1.2", 35028, 1154},
  {"1.3", 35116, 1157},
  {"1.4", 35215, 1160},
  {"1.5", 35303, 1163},
  {"1.6", 35402, 1166},
  {"1.7", 35492, 1169},
  {"1.8", 35595, 1172},
  {"1.9", 35687, 1175},
  {"1.10", 35789, 1178},
  {"1.11", 35881, 1181},
  {"1.12", 35984, 1184},
  {"1.13", 36077, 1187},
  {"1.14", 36180, 1190},
  {"1.15", 36271, 1193},
  {"1.16", 36375, 1196},
  {"1.17", 36466, 1199},
  {"1.18", 36569, 1202},
  {"1.19", 36662, 1205},
  {"1.20", 36760, 1208},
  {"1.21", 36859, 1211},
  {"1.22", 36958, 1214},
  {"1.23", 37057, 1217},
  {"1.24", 37156, 1220},
  {"1.25", 37255, 1223},
  {"1.26", 37354, 1226},
  {"1.27", 37453, 1229}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 138, 6, 36, "Subsection",
  CellTags->{"S5.72.1", "1.1"}],
Cell[1917, 61, 207, 7, 24, "Text",
  CellTags->{"S5.72.1", "1.2"}],
Cell[2127, 70, 514, 19, 52, "DisplayFormula",
  CellTags->{"S5.72.1", "1.3"}],
Cell[2644, 91, 137, 4, 24, "Text",
  CellTags->{"S5.72.1", "1.4"}],
Cell[2784, 97, 591, 24, 52, "DisplayFormula",
  CellTags->{"S5.72.1", "1.5"}],
Cell[3378, 123, 487, 19, 24, "Text",
  CellTags->{"S5.72.1", "1.6"}],
Cell[3868, 144, 7233, 176, 115, "DisplayFormula",
  CellTags->{"S5.72.1", "1.7"}],
Cell[11104, 322, 1096, 35, 56, "Text",
  CellTags->{"S5.72.1", "1.8"}],
Cell[12203, 359, 829, 34, 31, "DisplayFormula",
  CellTags->{"S5.72.1", "1.9"}],
Cell[13035, 395, 213, 7, 24, "Text",
  CellTags->{"S5.72.1", "1.10"}],
Cell[13251, 404, 610, 25, 31, "DisplayFormula",
  CellTags->{"S5.72.1", "1.11"}],
Cell[13864, 431, 595, 23, 24, "Text",
  CellTags->{"S5.72.1", "1.12"}],
Cell[14462, 456, 613, 27, 31, "DisplayFormula",
  CellTags->{"S5.72.1", "1.13"}],
Cell[15078, 485, 54, 1, 24, "Text",
  CellTags->{"S5.72.1", "1.14"}],
Cell[15135, 488, 1571, 67, 53, "DisplayFormula",
  CellTags->{"S5.72.1", "1.15"}],
Cell[16709, 557, 52, 1, 24, "Text",
  CellTags->{"S5.72.1", "1.16"}],
Cell[16764, 560, 790, 31, 70, "DisplayFormula",
  CellTags->{"S5.72.1", "1.17"}],
Cell[17557, 593, 8024, 244, 70, "DefinitionBox",
  CellTags->"S5.72.1"],
Cell[25584, 839, 240, 7, 70, "Caption",
  CellTags->"S5.72.1"],
Cell[25827, 848, 598, 16, 70, "Text",
  CellTags->{"S5.72.1", "1.18"}],
Cell[26428, 866, 79, 1, 70, "MathCaption",
  CellTags->{"S5.72.1", "1.19"}],
Cell[26510, 869, 88, 2, 70, "Input",
  CellTags->"S5.72.1"],
Cell[26601, 873, 228, 8, 70, "MathCaption",
  CellTags->{"S5.72.1", "1.20"}],

Cell[CellGroupData[{
Cell[26854, 885, 78, 2, 70, "Input",
  CellTags->"S5.72.1"],
Cell[26935, 889, 77, 2, 70, "Output",
  CellTags->"S5.72.1"]
}, Open  ]],
Cell[27027, 894, 191, 5, 70, "MathCaption",
  CellTags->{"S5.72.1", "1.21"}],

Cell[CellGroupData[{
Cell[27243, 903, 95, 2, 70, "Input",
  CellTags->"S5.72.1"],
Cell[27341, 907, 327, 11, 70, "Output",
  CellTags->"S5.72.1"]
}, Open  ]],
Cell[27683, 921, 109, 1, 70, "MathCaption",
  CellTags->{"S5.72.1", "1.22"}],

Cell[CellGroupData[{
Cell[27817, 926, 97, 2, 70, "Input",
  CellTags->"S5.72.1"],
Cell[27917, 930, 95, 2, 70, "Output",
  CellTags->"S5.72.1"]
}, Open  ]],
Cell[28027, 935, 241, 5, 70, "MathCaption",
  CellTags->{"S5.72.1", "1.23"}],

Cell[CellGroupData[{
Cell[28293, 944, 98, 2, 70, "Input",
  CellTags->"S5.72.1"],
Cell[28394, 948, 122, 2, 70, "Output",
  CellTags->"S5.72.1"]
}, Open  ]],
Cell[28531, 953, 285, 7, 70, "MathCaption",
  CellTags->{"S5.72.1", "1.24"}],

Cell[CellGroupData[{
Cell[28841, 964, 101, 2, 70, "Input",
  CellTags->"S5.72.1"],
Cell[28945, 968, 206, 5, 70, "Output",
  CellTags->"S5.72.1"]
}, Open  ]],
Cell[29166, 976, 253, 9, 70, "MathCaption",
  CellTags->{"S5.72.1", "1.25"}],

Cell[CellGroupData[{
Cell[29444, 989, 86, 2, 70, "Input",
  CellTags->"S5.72.1"],
Cell[29533, 993, 95, 2, 70, "Output",
  CellTags->"S5.72.1"]
}, Open  ]],
Cell[29643, 998, 217, 7, 70, "MathCaption",
  CellTags->{"S5.72.1", "1.26"}],

Cell[CellGroupData[{
Cell[29885, 1009, 94, 2, 70, "Input",
  CellTags->"S5.72.1"],
Cell[29982, 1013, 92, 2, 70, "Output",
  CellTags->"S5.72.1"]
}, Open  ]],
Cell[30089, 1018, 250, 7, 70, "MathCaption",
  CellTags->{"S5.72.1", "1.27"}],

Cell[CellGroupData[{
Cell[30364, 1029, 78, 2, 70, "Input",
  CellTags->"S5.72.1"],
Cell[30445, 1033, 206, 5, 70, "Output",
  CellTags->"S5.72.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

