(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14539,        476]*)
(*NotebookOutlinePosition[     17833,        579]*)
(*  CellTagsIndexPosition[     17553,        564]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumberTheory",
 StyleBox["`", "MB"],
 "Rationalize",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.73.1", "1.1"}],

Cell[TextData[{
 "It is frequently useful to approximate arbitrary real numbers with a nearby \
rational. The built\[Hyphen]in function ",
 StyleBox["Rationalize", "MR"],
 " gives a rational approximation to a single real number. "
}], "Text",
 CellTags->{"S5.73.1", "1.2"}],

Cell[TextData[{
 "In certain situations, such as the computation of gear ratios or the \
setting of musical scales, one wants to get a list of rational numbers that \
approximates a given list of real numbers. You could simply apply ",
 StyleBox["Rationalize", "MR"],
 " to each element in the list, but it is very likely that the elements in \
the result would not be related to each other in a simple way. To get a \
simultaneous rational approximation that preserves the relationships among \
the given numbers, you should use ",
 StyleBox["ProjectiveRationalize", "MR"],
 " or ",
 StyleBox["AffineRationalize", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.73.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ProjectiveRationalize[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give a list of integers whose ratios well approximate the \
corresponding ratios of the real numbers ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ProjectiveRationalize[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["prec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["use a tolerance of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["10", 
         RowBox[{"-", 
          StyleBox["p",
           "TI"], 
          StyleBox["r",
           "TI"], 
          StyleBox["e",
           "TI"], 
          StyleBox["c",
           "TI"]}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the approximation",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AffineRationalize[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give a list of rational numbers with a small least common denominator \
that well approximate the corresponding real numbers ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AffineRationalize[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["prec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["use a tolerance of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["10", 
         RowBox[{"-", 
          StyleBox["p",
           "TI"], 
          StyleBox["r",
           "TI"], 
          StyleBox["e",
           "TI"], 
          StyleBox["c",
           "TI"]}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the approximation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.73.1"],

Cell["Getting a simultaneous rational approximation. ", "Caption",
 CellTags->"S5.73.1"],

Cell[TextData[{
 "The second argument in ",
 StyleBox["ProjectiveRationalize", "MR"],
 " and ",
 StyleBox["AffineRationalize", "MR"],
 " controls the number of digits that are to be considered significant in the \
numbers given in the first argument. If no second argument is given all \
digits are considered significant. Note that the convention used for \
specifying the tolerances in this package differs from the one used in the \
built\[Hyphen]in ",
 StyleBox["Rationalize", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.73.1", "1.4"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.73.1", "1.5"}],

Cell["<<NumberTheory`Rationalize`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.73.1"],

Cell[TextData[{
 "Here is the ratio of rational approximations. The result is close to ",
 Cell[BoxData[
  FormBox[
   FractionBox["3", "11"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", but it is a very awkward way to approximate it."
}], "MathCaption",
 CellTags->{"S5.73.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
Rationalize[N[3 Pi], 6]/
 Rationalize[N[11 Pi], 6]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.73.1"],

Cell[BoxData[
 FractionBox["9", "34"]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.73.1"]
}, Open  ]],

Cell["\<\
This computes a simultaneous rational approximation that preserves the simple \
relationship between the given numbers. \
\>", "MathCaption",
 CellTags->{"S5.73.1", "1.7"}],

Cell[CellGroupData[{

Cell["AffineRationalize[{N[3 Pi], N[11 Pi]}, 6]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.73.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1065", "113"], ",", 
   FractionBox["3905", "113"]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.73.1"]
}, Open  ]],

Cell["This ratio is much simpler. ", "MathCaption",
 CellTags->{"S5.73.1", "1.8"}],

Cell[CellGroupData[{

Cell["%[[1]]/%[[2]]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.73.1"],

Cell[BoxData[
 FractionBox["3", "11"]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.73.1"]
}, Open  ]],

Cell[TextData[{
 "The ratios of the integers returned by ",
 StyleBox["ProjectiveRationalize", "MR"],
 " approximate the ratios of the corresponding irrationals. "
}], "MathCaption",
 CellTags->{"S5.73.1", "1.9"}],

Cell[CellGroupData[{

Cell["ProjectiveRationalize[{N[3 Pi], N[11 Pi]}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.73.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "11"}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.73.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.73.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.73.1", "1.1"}],
    Cell[1919, 61, 274, 6, 40, "Text",
      CellTags->{"S5.73.1", "1.2"}],
    Cell[2196, 69, 670, 14, 104, "Text",
      CellTags->{"S5.73.1", "1.3"}],
    Cell[2869, 85, 8985, 282, 198, "DefinitionBox",
      CellTags->"S5.73.1"],
    Cell[11857, 369, 88, 1, 15, "Caption",
      CellTags->"S5.73.1"],
    Cell[11948, 372, 536, 13, 72, "Text",
      CellTags->{"S5.73.1", "1.4"}],
    Cell[12487, 387, 78, 1, 40, "MathCaption",
      CellTags->{"S5.73.1", "1.5"}],
    Cell[12568, 390, 90, 2, 28, "Input",
      CellTags->"S5.73.1"],
    Cell[12661, 394, 327, 8, 60, "MathCaption",
      CellTags->{"S5.73.1", "1.6"}],
    Cell[13013, 406, 121, 5, 45, "Input",
      CellTags->"S5.73.1"],
    Cell[13137, 413, 95, 3, 70, "Output",
      CellTags->"S5.73.1"],
    Cell[13247, 419, 182, 4, 70, "MathCaption",
      CellTags->{"S5.73.1", "1.7"}],
    Cell[13454, 427, 104, 2, 70, "Input",
      CellTags->"S5.73.1"],
    Cell[13561, 431, 173, 6, 70, "Output",
      CellTags->"S5.73.1"],
    Cell[13749, 440, 82, 1, 70, "MathCaption",
      CellTags->{"S5.73.1", "1.8"}],
    Cell[13856, 445, 76, 2, 70, "Input",
      CellTags->"S5.73.1"],
    Cell[13935, 449, 95, 3, 70, "Output",
      CellTags->"S5.73.1"],
    Cell[14045, 455, 213, 5, 70, "MathCaption",
      CellTags->{"S5.73.1", "1.9"}],
    Cell[14283, 464, 105, 2, 70, "Input",
      CellTags->"S5.73.1"],
    Cell[14391, 468, 120, 4, 70, "Output",
      CellTags->"S5.73.1"]},
  "1.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.73.1", "1.1"}]},
  "1.2"->{
    Cell[1919, 61, 274, 6, 40, "Text",
      CellTags->{"S5.73.1", "1.2"}]},
  "1.3"->{
    Cell[2196, 69, 670, 14, 104, "Text",
      CellTags->{"S5.73.1", "1.3"}]},
  "1.4"->{
    Cell[11948, 372, 536, 13, 72, "Text",
      CellTags->{"S5.73.1", "1.4"}]},
  "1.5"->{
    Cell[12487, 387, 78, 1, 40, "MathCaption",
      CellTags->{"S5.73.1", "1.5"}]},
  "1.6"->{
    Cell[12661, 394, 327, 8, 60, "MathCaption",
      CellTags->{"S5.73.1", "1.6"}]},
  "1.7"->{
    Cell[13247, 419, 182, 4, 70, "MathCaption",
      CellTags->{"S5.73.1", "1.7"}]},
  "1.8"->{
    Cell[13749, 440, 82, 1, 70, "MathCaption",
      CellTags->{"S5.73.1", "1.8"}]},
  "1.9"->{
    Cell[14045, 455, 213, 5, 70, "MathCaption",
      CellTags->{"S5.73.1", "1.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.73.1", 15162, 492},
  {"1.1", 16693, 533},
  {"1.2", 16787, 536},
  {"1.3", 16875, 539},
  {"1.4", 16965, 542},
  {"1.5", 17056, 545},
  {"1.6", 17152, 548},
  {"1.7", 17249, 551},
  {"1.8", 17346, 554},
  {"1.9", 17442, 557}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 140, 6, 36, "Subsection",
  CellTags->{"S5.73.1", "1.1"}],
Cell[1919, 61, 274, 6, 40, "Text",
  CellTags->{"S5.73.1", "1.2"}],
Cell[2196, 69, 670, 14, 104, "Text",
  CellTags->{"S5.73.1", "1.3"}],
Cell[2869, 85, 8985, 282, 198, "DefinitionBox",
  CellTags->"S5.73.1"],
Cell[11857, 369, 88, 1, 15, "Caption",
  CellTags->"S5.73.1"],
Cell[11948, 372, 536, 13, 72, "Text",
  CellTags->{"S5.73.1", "1.4"}],
Cell[12487, 387, 78, 1, 40, "MathCaption",
  CellTags->{"S5.73.1", "1.5"}],
Cell[12568, 390, 90, 2, 28, "Input",
  CellTags->"S5.73.1"],
Cell[12661, 394, 327, 8, 60, "MathCaption",
  CellTags->{"S5.73.1", "1.6"}],

Cell[CellGroupData[{
Cell[13013, 406, 121, 5, 45, "Input",
  CellTags->"S5.73.1"],
Cell[13137, 413, 95, 3, 70, "Output",
  CellTags->"S5.73.1"]
}, Open  ]],
Cell[13247, 419, 182, 4, 70, "MathCaption",
  CellTags->{"S5.73.1", "1.7"}],

Cell[CellGroupData[{
Cell[13454, 427, 104, 2, 70, "Input",
  CellTags->"S5.73.1"],
Cell[13561, 431, 173, 6, 70, "Output",
  CellTags->"S5.73.1"]
}, Open  ]],
Cell[13749, 440, 82, 1, 70, "MathCaption",
  CellTags->{"S5.73.1", "1.8"}],

Cell[CellGroupData[{
Cell[13856, 445, 76, 2, 70, "Input",
  CellTags->"S5.73.1"],
Cell[13935, 449, 95, 3, 70, "Output",
  CellTags->"S5.73.1"]
}, Open  ]],
Cell[14045, 455, 213, 5, 70, "MathCaption",
  CellTags->{"S5.73.1", "1.9"}],

Cell[CellGroupData[{
Cell[14283, 464, 105, 2, 70, "Input",
  CellTags->"S5.73.1"],
Cell[14391, 468, 120, 4, 70, "Output",
  CellTags->"S5.73.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

