(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10507,        404]*)
(*NotebookOutlinePosition[     15499,        559]*)
(*  CellTagsIndexPosition[     15076,        538]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "ReIm",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.8.1", "1.1"}],

Cell[TextData[{
 "This package extends the class of algebraic identities used by the built\
\[Hyphen]in functions ",
 StyleBox["Re", "MR"],
 ", ",
 StyleBox["Im", "MR"],
 ", ",
 StyleBox["Abs", "MR"],
 ", ",
 StyleBox["Conjugate", "MR"],
 ", and ",
 StyleBox["Arg", "MR"],
 ", and enables these functions to make more complete use of known properties \
of symbols and functions. For example, the input ",
 StyleBox["Im[z]", "MR"],
 " ",
 StyleBox["^=", "MR"],
 " ",
 StyleBox["0", "MR"],
 " can be used to declare that ",
 StyleBox["z", "MR"],
 " is real, after which ",
 StyleBox["Re[z]", "MR"],
 " will evaluate to ",
 StyleBox["z", "MR"],
 ". The function ",
 StyleBox["RealValued", "MR"],
 " is also included for declaring functions to be real\[Hyphen]valued for \
real arguments. "
}], "Text",
 CellTags->{"S5.8.1", "1.2"}],

Cell[TextData[{
 "Some of the functionality provided by this package has been incorporated \
into the ",
 StyleBox["Mathematica", "TI"],
 " kernel and may be available without loading the package. In addition, the \
option ",
 StyleBox["GaussianIntegers", "MR"],
 " has been added to several built\[Hyphen]in polynomial functions, such as \
",
 StyleBox["Factor", "MR"],
 ", and is helpful when working with rational expressions containing complex \
numbers. The function ",
 StyleBox["ComplexExpand", "MR"],
 " can also be used for manipulating complex\[Hyphen]valued expressions. "
}], "Text",
 CellTags->{"S5.8.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.8.1", "1.4"}],

Cell["<<Algebra`ReIm`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.8.1"],

Cell["\<\
Symbols with no special properties are expanded into real and imaginary \
parts. \
\>", "MathCaption",
 CellTags->{"S5.8.1", "1.5"}],

Cell[CellGroupData[{

Cell["Re[1/a]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.8.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"Re", "[", "a", "]"}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Im", "[", "a", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Re", "[", "a", "]"}], "2"]}]]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.8.1"]
}, Open  ]],

Cell[TextData[{
 "This declares the symbol ",
 StyleBox["z", "MR"],
 " to have an imaginary part of zero, and attaches the rule to ",
 StyleBox["z", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.8.1", "1.6"}],

Cell[CellGroupData[{

Cell["z /: Im[z] = 0", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.8.1"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.8.1"]
}, Open  ]],

Cell[TextData[{
 "The symbol ",
 StyleBox["z", "MR"],
 " is now treated as a real number. "
}], "MathCaption",
 CellTags->{"S5.8.1", "1.7"}],

Cell[CellGroupData[{

Cell["Re[(z + I)^2 + Exp[I z]]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.8.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["z", "2"], "+", 
  RowBox[{"Cos", "[", "z", "]"}]}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.8.1"]
}, Open  ]],

Cell["\<\
Combinations of real symbols and other expressions can also be handled. \
\>", "MathCaption",
 CellTags->{"S5.8.1", "1.8"}],

Cell[CellGroupData[{

Cell["Re[(a + z)^2]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.8.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"Im", "[", "a", "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"z", "+", 
     RowBox[{"Re", "[", "a", "]"}]}], ")"}], "2"]}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.8.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RealValued[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "declare functions to be real for real arguments",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.8.1"],

Cell[TextData[{
 "The function ",
 StyleBox["RealValued", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.8.1"],

Cell[TextData[{
 "This declares the symbol ",
 StyleBox["x", "MR"],
 " to be real and the functions ",
 StyleBox["f", "MR"],
 " and ",
 StyleBox["g", "MR"],
 " to be real\[Hyphen]valued for real arguments. "
}], "MathCaption",
 CellTags->{"S5.8.1", "1.9"}],

Cell[CellGroupData[{

Cell["Im[x] ^= 0; RealValued[f, g]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.8.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", ",", "g"}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.8.1"]
}, Open  ]],

Cell[TextData[{
 "The imaginary part of this expression is determined using previously \
declared properties of ",
 StyleBox["f", "MR"],
 ", ",
 StyleBox["g", "MR"],
 ", and ",
 StyleBox["x", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.8.1", "1.10"}],

Cell[CellGroupData[{

Cell["Im[1/(1 - I f[x] g[x])]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.8.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], " ", 
   RowBox[{"g", "[", "x", "]"}]}], 
  RowBox[{"1", "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"f", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"g", "[", "x", "]"}], "2"]}]}]]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.8.1"]
}, Open  ]],

Cell["\<\
The rules in this package are based on simple identities that are easy to \
understand and apply, and you are encouraged to read and modify the package \
as necessary for your application. If you modify the package, however, or if \
you use rules involving multiple\[Hyphen]valued functions, there are a few \
issues you should keep in mind. \
\>", "Text",
 CellTags->{"S5.8.1", "1.11"}],

Cell["\<\
Many useful identities involving logarithms, roots and other \
multiple\[Hyphen]valued functions are not correct for arbitrary complex \
arguments. The rules that implement these identities can lead to results that \
represent unintended branches of the function. If you encounter problems \
related to branches of multiple\[Hyphen]valued functions, the corresponding \
rules can be modified or removed from the package. \
\>", "Text",
 CellTags->{"S5.8.1", "1.12"}],

Cell[TextData[{
 "This declares the symbols ",
 StyleBox["a", "MR"],
 " and ",
 StyleBox["b", "MR"],
 " to be negative. "
}], "MathCaption",
 CellTags->{"S5.8.1", "1.13"}],

Cell[CellGroupData[{

Cell["Negative[a] ^= True; Negative[b] ^= True", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.8.1"],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.8.1"]
}, Open  ]],

Cell[TextData[{
 "This result corresponds to an analytic continuation of the principal branch \
of the logarithm function, and was obtained using the rule ",
 StyleBox["Im[Log[a_", "MR"],
 " ",
 StyleBox["b_]]", "MR"],
 " ",
 StyleBox[":=", "MR"],
 " ",
 StyleBox["Im[Log[a]", "MR"],
 " ",
 StyleBox["+", "MR"],
 " ",
 StyleBox["Log[b]]", "MR"],
 ". This rule can be modified or removed if the principal branch must be \
preserved. "
}], "MathCaption",
 CellTags->{"S5.8.1", "1.14"}],

Cell[CellGroupData[{

Cell["Im[Log[a b]]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.8.1"],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.8.1"]
}, Open  ]],

Cell[TextData[{
 "You should also be careful to avoid infinite recursion when adding rules to \
this package. For example, the pair of rules ",
 StyleBox["Im[x_]:=x", "MR"],
 " ",
 StyleBox["/;", "MR"],
 " ",
 StyleBox["Re[x]==0", "MR"],
 " and ",
 StyleBox["Re[x_]:=x", "MR"],
 " ",
 StyleBox["/;", "MR"],
 " ",
 StyleBox["Im[x]==0", "MR"],
 " can lead to infinite recursion, since evaluation of the condition in the \
rule for ",
 StyleBox["Re[x]", "MR"],
 " requires evaluation of ",
 StyleBox["Im[x]", "MR"],
 ", and evaluation of the condition in the rule for ",
 StyleBox["Im[x]", "MR"],
 " requires evaluation of ",
 StyleBox["Re[x]", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.8.1", "1.15"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.8.1"->{
    Cell[1776, 53, 127, 6, 36, "Subsection",
      CellTags->{"S5.8.1", "1.1"}],
    Cell[1906, 61, 828, 30, 88, "Text",
      CellTags->{"S5.8.1", "1.2"}],
    Cell[2737, 93, 625, 15, 88, "Text",
      CellTags->{"S5.8.1", "1.3"}],
    Cell[3365, 110, 77, 1, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.4"}],
    Cell[3445, 113, 77, 2, 28, "Input",
      CellTags->"S5.8.1"],
    Cell[3525, 117, 142, 4, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.5"}],
    Cell[3692, 125, 69, 2, 28, "Input",
      CellTags->"S5.8.1"],
    Cell[3764, 129, 257, 9, 42, "Output",
      CellTags->"S5.8.1"],
    Cell[4036, 141, 210, 7, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.6"}],
    Cell[4271, 152, 76, 2, 28, "Input",
      CellTags->"S5.8.1"],
    Cell[4350, 156, 73, 2, 25, "Output",
      CellTags->"S5.8.1"],
    Cell[4438, 161, 140, 5, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.7"}],
    Cell[4603, 170, 86, 2, 28, "Input",
      CellTags->"S5.8.1"],
    Cell[4692, 174, 177, 6, 27, "Output",
      CellTags->"S5.8.1"],
    Cell[4884, 183, 133, 3, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.8"}],
    Cell[5042, 190, 75, 2, 28, "Input",
      CellTags->"S5.8.1"],
    Cell[5120, 194, 274, 10, 70, "Output",
      CellTags->"S5.8.1"],
    Cell[5409, 207, 1079, 33, 70, "DefinitionBox",
      CellTags->"S5.8.1"],
    Cell[6491, 242, 106, 5, 70, "Caption",
      CellTags->"S5.8.1"],
    Cell[6600, 249, 256, 9, 70, "MathCaption",
      CellTags->{"S5.8.1", "1.9"}],
    Cell[6881, 262, 90, 2, 70, "Input",
      CellTags->"S5.8.1"],
    Cell[6974, 266, 118, 4, 70, "Output",
      CellTags->"S5.8.1"],
    Cell[7107, 273, 254, 10, 70, "MathCaption",
      CellTags->{"S5.8.1", "1.10"}],
    Cell[7386, 287, 85, 2, 70, "Input",
      CellTags->"S5.8.1"],
    Cell[7474, 291, 335, 12, 70, "Output",
      CellTags->"S5.8.1"],
    Cell[7824, 306, 397, 7, 70, "Text",
      CellTags->{"S5.8.1", "1.11"}],
    Cell[8224, 315, 476, 8, 70, "Text",
      CellTags->{"S5.8.1", "1.12"}],
    Cell[8703, 325, 171, 7, 70, "MathCaption",
      CellTags->{"S5.8.1", "1.13"}],
    Cell[8899, 336, 102, 2, 70, "Input",
      CellTags->"S5.8.1"],
    Cell[9004, 340, 76, 2, 70, "Output",
      CellTags->"S5.8.1"],
    Cell[9095, 345, 483, 17, 70, "MathCaption",
      CellTags->{"S5.8.1", "1.14"}],
    Cell[9603, 366, 74, 2, 70, "Input",
      CellTags->"S5.8.1"],
    Cell[9680, 370, 99, 3, 70, "Output",
      CellTags->"S5.8.1"],
    Cell[9794, 376, 697, 25, 70, "Text",
      CellTags->{"S5.8.1", "1.15"}]},
  "1.1"->{
    Cell[1776, 53, 127, 6, 36, "Subsection",
      CellTags->{"S5.8.1", "1.1"}]},
  "1.2"->{
    Cell[1906, 61, 828, 30, 88, "Text",
      CellTags->{"S5.8.1", "1.2"}]},
  "1.3"->{
    Cell[2737, 93, 625, 15, 88, "Text",
      CellTags->{"S5.8.1", "1.3"}]},
  "1.4"->{
    Cell[3365, 110, 77, 1, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.4"}]},
  "1.5"->{
    Cell[3525, 117, 142, 4, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.5"}]},
  "1.6"->{
    Cell[4036, 141, 210, 7, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.6"}]},
  "1.7"->{
    Cell[4438, 161, 140, 5, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.7"}]},
  "1.8"->{
    Cell[4884, 183, 133, 3, 40, "MathCaption",
      CellTags->{"S5.8.1", "1.8"}]},
  "1.9"->{
    Cell[6600, 249, 256, 9, 70, "MathCaption",
      CellTags->{"S5.8.1", "1.9"}]},
  "1.10"->{
    Cell[7107, 273, 254, 10, 70, "MathCaption",
      CellTags->{"S5.8.1", "1.10"}]},
  "1.11"->{
    Cell[7824, 306, 397, 7, 70, "Text",
      CellTags->{"S5.8.1", "1.11"}]},
  "1.12"->{
    Cell[8224, 315, 476, 8, 70, "Text",
      CellTags->{"S5.8.1", "1.12"}]},
  "1.13"->{
    Cell[8703, 325, 171, 7, 70, "MathCaption",
      CellTags->{"S5.8.1", "1.13"}]},
  "1.14"->{
    Cell[9095, 345, 483, 17, 70, "MathCaption",
      CellTags->{"S5.8.1", "1.14"}]},
  "1.15"->{
    Cell[9794, 376, 697, 25, 70, "Text",
      CellTags->{"S5.8.1", "1.15"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.8.1", 11129, 420},
  {"1.1", 13660, 489},
  {"1.2", 13753, 492},
  {"1.3", 13841, 495},
  {"1.4", 13929, 498},
  {"1.5", 14023, 501},
  {"1.6", 14118, 504},
  {"1.7", 14213, 507},
  {"1.8", 14308, 510},
  {"1.9", 14403, 513},
  {"1.10", 14499, 516},
  {"1.11", 14597, 519},
  {"1.12", 14687, 522},
  {"1.13", 14777, 525},
  {"1.14", 14874, 528},
  {"1.15", 14972, 531}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 127, 6, 36, "Subsection",
  CellTags->{"S5.8.1", "1.1"}],
Cell[1906, 61, 828, 30, 88, "Text",
  CellTags->{"S5.8.1", "1.2"}],
Cell[2737, 93, 625, 15, 88, "Text",
  CellTags->{"S5.8.1", "1.3"}],
Cell[3365, 110, 77, 1, 40, "MathCaption",
  CellTags->{"S5.8.1", "1.4"}],
Cell[3445, 113, 77, 2, 28, "Input",
  CellTags->"S5.8.1"],
Cell[3525, 117, 142, 4, 40, "MathCaption",
  CellTags->{"S5.8.1", "1.5"}],

Cell[CellGroupData[{
Cell[3692, 125, 69, 2, 28, "Input",
  CellTags->"S5.8.1"],
Cell[3764, 129, 257, 9, 42, "Output",
  CellTags->"S5.8.1"]
}, Open  ]],
Cell[4036, 141, 210, 7, 40, "MathCaption",
  CellTags->{"S5.8.1", "1.6"}],

Cell[CellGroupData[{
Cell[4271, 152, 76, 2, 28, "Input",
  CellTags->"S5.8.1"],
Cell[4350, 156, 73, 2, 25, "Output",
  CellTags->"S5.8.1"]
}, Open  ]],
Cell[4438, 161, 140, 5, 40, "MathCaption",
  CellTags->{"S5.8.1", "1.7"}],

Cell[CellGroupData[{
Cell[4603, 170, 86, 2, 28, "Input",
  CellTags->"S5.8.1"],
Cell[4692, 174, 177, 6, 27, "Output",
  CellTags->"S5.8.1"]
}, Open  ]],
Cell[4884, 183, 133, 3, 40, "MathCaption",
  CellTags->{"S5.8.1", "1.8"}],

Cell[CellGroupData[{
Cell[5042, 190, 75, 2, 28, "Input",
  CellTags->"S5.8.1"],
Cell[5120, 194, 274, 10, 70, "Output",
  CellTags->"S5.8.1"]
}, Open  ]],
Cell[5409, 207, 1079, 33, 70, "DefinitionBox",
  CellTags->"S5.8.1"],
Cell[6491, 242, 106, 5, 70, "Caption",
  CellTags->"S5.8.1"],
Cell[6600, 249, 256, 9, 70, "MathCaption",
  CellTags->{"S5.8.1", "1.9"}],

Cell[CellGroupData[{
Cell[6881, 262, 90, 2, 70, "Input",
  CellTags->"S5.8.1"],
Cell[6974, 266, 118, 4, 70, "Output",
  CellTags->"S5.8.1"]
}, Open  ]],
Cell[7107, 273, 254, 10, 70, "MathCaption",
  CellTags->{"S5.8.1", "1.10"}],

Cell[CellGroupData[{
Cell[7386, 287, 85, 2, 70, "Input",
  CellTags->"S5.8.1"],
Cell[7474, 291, 335, 12, 70, "Output",
  CellTags->"S5.8.1"]
}, Open  ]],
Cell[7824, 306, 397, 7, 70, "Text",
  CellTags->{"S5.8.1", "1.11"}],
Cell[8224, 315, 476, 8, 70, "Text",
  CellTags->{"S5.8.1", "1.12"}],
Cell[8703, 325, 171, 7, 70, "MathCaption",
  CellTags->{"S5.8.1", "1.13"}],

Cell[CellGroupData[{
Cell[8899, 336, 102, 2, 70, "Input",
  CellTags->"S5.8.1"],
Cell[9004, 340, 76, 2, 70, "Output",
  CellTags->"S5.8.1"]
}, Open  ]],
Cell[9095, 345, 483, 17, 70, "MathCaption",
  CellTags->{"S5.8.1", "1.14"}],

Cell[CellGroupData[{
Cell[9603, 366, 74, 2, 70, "Input",
  CellTags->"S5.8.1"],
Cell[9680, 370, 99, 3, 70, "Output",
  CellTags->"S5.8.1"]
}, Open  ]],
Cell[9794, 376, 697, 25, 70, "Text",
  CellTags->{"S5.8.1", "1.15"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

