(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     37401,       1224]*)
(*NotebookOutlinePosition[     43049,       1392]*)
(*  CellTagsIndexPosition[     42659,       1373]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "RealOnly",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.59.1", "1.1"}],

Cell[TextData[{
 "In high school algebra, exponents and radicals are taught early, but \
complex numbers are usually left to more advanced courses. Some algebra \
teachers have asked for a package that would allow them to avoid complex \
numbers. ",
 StyleBox["Mathematica", "TI"],
 " is flexible enough to block out imaginary and complex numbers in a way \
that is mathematically correct. "
}], "Text",
 CellTags->{"S5.59.1", "1.2"}],

Cell[TextData[{
 "Two ideas are implemented in the package ",
 StyleBox["RealOnly", "MR"],
 "\[ThinSpace]. Odd roots of negative numbers are defined to be negative, and \
calculations with unavoidable complex numbers are condensed to the symbol ",
 StyleBox["Nonreal", "MR"],
 ". This is done by redefining the built\[Hyphen]in functions ",
 StyleBox["Power", "MR"],
 " and ",
 StyleBox["$Post", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.59.1", "1.3"}],

Cell[TextData[{
 "Without loading the package, ",
 StyleBox["Mathematica", "TI"],
 " calculates a cube root of a negative number to be complex. So no points \
are plotted for negative values of ",
 StyleBox["x", "TI"],
 " and warning messages are generated. "
}], "MathCaption",
 CellTags->{"S5.59.1", "1.4"}],

Cell[CellGroupData[{

Cell["Plot[x ^ (1/3), {x, -8, 8}]", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "::", "\<\"plnr\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(x\\^\\(1/3\\)\\) is not a machine-size real number \
at \\!\\(x\\) = \\!\\(-7.999999333333333`\\).\"\>"}]], "Message",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "::", "\<\"plnr\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(x\\^\\(1/3\\)\\) is not a machine-size real number \
at \\!\\(x\\) = \\!\\(-7.350928134833347`\\).\"\>"}]], "Message",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "::", "\<\"plnr\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(x\\^\\(1/3\\)\\) is not a machine-size real number \
at \\!\\(x\\) = \\!\\(-6.64305920225002`\\).\"\>"}]], "Message",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Further output of \\!\\(Plot :: \\\"plnr\\\"\\) will be \
suppressed during this calculation.\"\>"}]], "Message",
 CellTags->"S5.59.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.119048 0.0147151 0.294302 [
[.2619 .00222 -3 -9 ]
[.2619 .00222 3 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -3 -9 ]
[.7381 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .16187 -18 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .30902 -6 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(2)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(4)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(6)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(8)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.08333 .01472 m
.08333 .01847 L
s
.14286 .01472 m
.14286 .01847 L
s
.20238 .01472 m
.20238 .01847 L
s
.32143 .01472 m
.32143 .01847 L
s
.38095 .01472 m
.38095 .01847 L
s
.44048 .01472 m
.44048 .01847 L
s
.55952 .01472 m
.55952 .01847 L
s
.61905 .01472 m
.61905 .01847 L
s
.67857 .01472 m
.67857 .01847 L
s
.79762 .01472 m
.79762 .01847 L
s
.85714 .01472 m
.85714 .01847 L
s
.91667 .01472 m
.91667 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .16187 m
.03006 .16187 L
s
[(0.5)] .01131 .16187 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(1)] .01131 .30902 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(1.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(2)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02427 .06093 m
.0255 .086 L
.02692 .10207 L
.02826 .11313 L
.03065 .12826 L
.03323 .14105 L
.03909 .16317 L
.04448 .17891 L
.06499 .22131 L
.08371 .2488 L
.10349 .27215 L
.18103 .33761 L
.25698 .38294 L
.33782 .42135 L
.41564 .45249 L
.49836 .48135 L
.57805 .50614 L
.65471 .52782 L
.73628 .54904 L
.81481 .568 L
.89031 .58507 L
.97072 .60219 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003ogOooool0
0ooooo_ok^k^ooOoo`0oooooo`03ooObk_o^l_Oooooo00[ooooo001Hooooo`06oookeom`003o0000
o`000?l0047ob?;o?Oooool01?oooo_o/G11o`000?mVYM8mooooo`05oookh?nAC`3o0000o`00G?o2
j_/0??ooool01_oooo_o`Y5Lo`00;_l^003oChVmoo_oo`Wooooo001Iooooo`05omNUG?l005cocO;k
on[GcOoUmol0??ooool01Ookj]Oo]k6gokNaYOmV@EcoZm;Z03gooooo00Gok/9io`1V]ooooooocHT^
od6HdP0looooo`06ooogcOm105coeooooooog?mL047ob?;o2Oooool005[ooooo00?og;5io`00Coo=
l_l0?Oooool01_obcH;o001?oiROTOmL@D7oL96mooOooccooooo00GodY51obj2b?oooooocHU1od6H
dP0looooo`06oookg?m`02koYM;Uon[BYOl^06Koeo_o2Oooool005_ooooo00?odYQ1o`1V/Ookool0
??ooool01OoonmcoL2iVomcomonUNIool_oo03gooooo00GodYQ1o`000?l^@@3o001?okgZn`0moooo
o`04olfA;_l0003o0000obj9c@[ooooo001Iooooo`05oo;^l_oooooooooLoe`0@Oo8l_l0?Oooool0
1?o^b8WoCgVOoi62WooZoolmooooo`04onk8ROl0@ISoh>kbooOoocgooooo00Kooo_Goe`0;_o8mooo
oo_8obh0CooBmol9ooooo`00F?ooool01_ooooOoWd40obj2ZonmZh;o001VomOkocgooooo00Coooog
oj]L0?l0097ok_oo?Oooool01Ooooo;oYE`0o`1VTOo2b<gog>kg03cooooo00Koooo^oi4^0?m`YL;o
b:]io`00ROoZool9ooooo`00FOooool01?oomn[o`Z^HohV9WooBj_Loooooo`03ooo^cOnOZlSomooo
03kooooo00Coooogom:gYOn2NH;o/M;^?Oooool01?ool]coZi69ohVAZooLl_/:ooooo`006Oooool0
0oono_konOWiooooo`3ooooooa7ooooo000Iooooo`03ooCdm?o;bl_ooooo0?oooooo4Oooool001Wo
oooo00?om?Cdol_;boooool0oooooolAooooo`006Oooool00oodm?Cobl_;ooooo`3ooooooa7ooooo
000Cooooo`03ooOgmooLg=cog=cL00?og=cL00?od];Bojn_[ooLg=`03_oLg=`00ooKfm_og=cLomcL
g00>omcLg003om_KfooLg=cog=cL00gog=cL00?ofm_KomcLg?oLg=`03OoLg=`00ooJf][ofm_KomcL
g00>omcLg003om_KfooLg=cog=cL00gog=cL00?ofm_KomcLg?oLg=`03_oLg=`00ooKfm_og=cLomcL
g00=omcLg003omWIfOoLg=cog=cL00gog=cL00?ofm_KomcLg?oLg=`03_oLg=`00ooKfm_og=cLomcL
g00=omcLg003om_KfooLg=cog=cL00gog=cL00?ofm_Kom[Jf_oLg=`03_oLg=`00ooKfm_og=cLomcL
g00=omcLg003om_KfooLg=cog=cL00kog=cL00?ofm_KomcLg?oLg=`03OoLg=`00ooIfMWog=cLomcL
g004omcLg003oo_knooooooooooo00;ooooo000Cooooo`03ooShn?oShn?ohn?S00?ohn?S00?ofMWI
okBd]?oShn<03_oShn<00oo>c/kofm_Kon?Sh`0=on?Sh`03omWIfOoAdM7ohn?S00kohn?S00?oalO7
on?ShooShn<03OoShn<00oo0`<3ocLg=on?Sh`0=on?Sh`03omcLg?o=cLgohn?S00kohn?S00?oc<c<
omgMgOoShn<03OoShn<00ooGemOod];Bon?Sh`0=on?Sh`03on3Ph?n][Jgohn?S00kohn?S00?od=3@
om[Jf_oShn<03OoShn<00ooLg=cocLg=on?Sh`0>on?Sh`03ol[:b_oOgmoohn?S00gohn?S00?oalO7
olK6a_oShn<03OoShn<00ooPh>3ob/[:on?Sh`0>on?Sh`03olk>c_oKfm_ohn?S00gohn?S00?of][J
olo?cooShn<03_oShn<00on^[ZkogmoOon?Sh`04on?Sh`03ooclo?oooooooooo00;ooooo000Ioooo
o`03ooCdm?o;bl_ooooo03oooooo00?oi>CTono_koooool0?_ooool00oomoOgoe]KFooooo`0ooooo
o`03on[Zj_oYjNWooooo03oooooo00?oe]KFoogmoOooool02Oooool001Wooooo00?om?Cdol_;booo
ool0oooooolAooooo`006Oooool00oodm?Cobl_;ooooo`3ooooooa7ooooo000Iooooo`03ooCdm?o;
bl_ooooo0?oooooo4Oooool001Wooooo00?om?Cdol_;boooool0oooooolAooooo`006Oooool00ood
m?Cobl_;ooooo`3ooooooa7ooooo000Iooooo`03ooCdm?o3`l?on_[j0?oooooo4Oooool001Wooooo
00?om?Cdol71`OoinOT0oooooolAooooo`006Oooool00oodm?Cobl_;ooooo`3ooooooa7ooooo000I
ooooo`03ooCdm?o;bl_ooooo0?oooooo4Oooool001Wooooo00?om?Cdol_;boooool0oooooolAoooo
o`006Oooool00oobl_;o[Jf]ooooo`3ooooooa7ooooo000Iooooo`03oo;bl_mVIVKooooo0?oooooo
4Oooool001Wooooo00?om?CdofUYJOojn_X0oooooolAooooo`006Oooool00oodm?CoJVYZono_k`3o
oooooa7ooooo000Iooooo`03ooCdm?m]KFgoi^KV0?oooooo4Oooool001Wooooo00?om?CdogUiNOoV
i^H0oooooolAooooo`006Oooool00oodm?CoOgmoomoOg`3ooooooa7ooooo000Iooooo`03ooCdm?n5
QHGof=SH0?oooooo4Oooool001Wooooo00?om?Cdohb<S?o=cLd0oooooolAooooo`006Oooool00ood
m?CoUIFEol;2`P3ooooooa7ooooo000Iooooo`03ooCdm?nNWYko^;Rh0?oooooo4Oooool001Wooooo
00?om?Cdoj>SXon[Zj/0oooooolAooooo`006Oooool00oodm?CoYZJVoiVIV@3ooooooa7ooooo000I
ooooo`03ooCdm?nm_KgoT92@0?oooooo4Oooool001Wooooo00Com?CdolW9bOn3Ph?oo_knooooool@
ooooo`006Oooool01?odm?Cobl_;oi2@T?o_knoooooooa3ooooo000Iooooo`04ooCdm?o;bl_oYJFU
omSHf?oooooo4?ooool001Wooooo00Com?Cdol_;bonk^k_o`/;2ooooool@ooooo`006Oooool01?od
m?Cobl_;om3@d?n][Jgooooooa3ooooo000Iooooo`04ooCdm?o9bLWoi^KVoiRHV?oooooo4?ooool0
01Wooooo00Gom?Cdok^k^oobl_;oQ8B4ooclo03oooooo`oooooo000Iooooo`05ooCdm?o;bl_ooooo
oiNGUooUiND0ooooool?ooooo`006Oooool01Oodm?Cobl_;oooooon`/;3oc/k>0?oooooo3oooool0
01Wooooo00Gom?Cdol_;boooooooclo?oj^[Z`3oooooo`oooooo0006ooooo`03oookl_o^k_;ooooo
00Wooooo00?ol_;boo;bmoooool01?ooool01Oodm?Cobl_;oooooooalO7oRHV90?oooooo3oooool0
00Gooooo00GonnG2oe`00?l0003oCi72oo_oo`02ooooo`0:okMi;_l002koZmcgooooooooonGoRBh0
o`00;_l0003o;W2[onkoo`?ooooo00Kom?Cdol_;booooooooooooiBDU?oVi^Koooooo`kooooo0005
ooooo`05olf9;_m?YN3ooooPoe`0;_o2l_l00_ooool02_o2TDoo001?okgUnooooooooookonk^k_ok
oooooooZohT00?nOeoL3ooooo`06ooCdm?o;bl_ooooooooooonf][Koa<C4ooooool>ooooo`001?oo
ool01_oooo;oV44^oj_Pnooooo_o/FH^ohW=kP[ooooo00?oZe`0ohW8k_ooool00_ooool01_odm?Co
bLW9ooclo?oooooof=SHoj:RX_oooooo3_ooool000Cooooo00Koooo^ohT^Coo8l_ooooooolf9Con2
`^h7ooooo`05om:HG?l^G7WoPW11o`00L?oGnol00oooool01oodm?CoZZZZol?3`oolo?conOWiohJ6
Q_omoOd0ooooool=ooooo`001?ooool01_oooo_o]fH^ohW=moooooOoTBh^oj_Pn`Oooooo00CocHU?
oebO_OoBd]Ool_oo1?ooool00oodm?Cobl_;ooooo`02ooooo`03oj6QXOoGemOooooo0?oooooo3?oo
ool000Gooooo00Goh;5`o`0^NOn[YGWo001`omcko`07ooooo`05olf9;_l0G8;oWiRAoi6U`_ogool0
0oooool00oodm?Cobl_;ooooo`02ooooo`03olc<c?n/[:cooooo0?oooooo3?ooool000Kooooo00?o
ekNOoh:9WooGk_l02?ooool01Oobh<go]kNgokNg/Ong`]Oonooo00?ooooo00?om?Cdol_;boooool0
0_ooool00ooemOGoQhN7oo_kn`3oooooo`cooooo000Iooooo`03ooCdm?o;bl_ooooo00?ooooo00?o
XJ6QomOGeoooool0ooooool;ooooo`006Oooool00oodm?Cobl_;ooooo`03ooooo`03om3@d?nSXj?o
oooo0?oooooo2oooool001Wooooo00?om?Cdol_;boooool00oooool00oomoOgoT92@on?Sh`3ooooo
o`_ooooo000Iooooo`03ooCdm?o;bl_ooooo00Cooooo00?oc<c<ojBTY?ooool0ooooool:ooooo`00
6Oooool00oodm?Co^k^kooCdm004ooooo`03ooclo?n>SXkoi^KV0?oooooo2_ooool001Wooooo00?o
m?Cdol[:b_ooool01Oooool00oo9bLWoZ:RXooooo`3oooooo`Wooooo000Iooooo`03ooCdm?o;bl_o
oooo00Gooooo00?ono_kohb<S?oYjNT0ooooool9ooooo`006Oooool00oodm?Cobl_;ooooo`06oooo
o`03olG5aOn[Zj_ooooo0?oooooo2?ooool001Wooooo00?om?Cdol_;boooool01_ooool00oojn_[o
RXZ:onc/k03oooooo`Sooooo000Iooooo`03ooCdm?o;bl_ooooo00Oooooo00?o`/;2ojn_[oooool0
ooooool7ooooo`006Oooool00oodm?Cobl_;ooooo`07ooooo`03ooShn?n9RHWokno_0?oooooo1ooo
ool001Wooooo00?om?Cdol_;boooool02?ooool00onn_[ko/[:booooo`3oooooo`Kooooo000Ioooo
o`03ooCdm?nm_Kgom_Kf00Sooooo00?omOGeohV9ROoalO40ooooool6ooooo`006Oooool00oodm?Co
alO7oogmo@09ooooo`03olK6a_nOWioooooo0?oooooo1Oooool001Wooooo00?om?Cdol_;boooool0
2Oooool00oono_koWIfMolS8b03oooooo`Gooooo000Iooooo`03ooCdm?o;bl_ooooo00[ooooo00?o
k^k^ohV9ROo/k>`0ooooool4ooooo`006Oooool00oodm?Cobl_;ooooo`0;ooooo`03ol[:b_nKVi_o
o_kn0?oooooo0oooool001Wooooo00?om?Cdol_;boooool03?ooool00onQXJ7oa<C4ooooo`3ooooo
o`;ooooo000Iooooo`03ooCdm?o;bl_ooooo00cooooo00?olO7aohV9ROoYjNT0ooooool2ooooo`00
6Oooool00oodm?Cobl_;ooooo`0=ooooo`03olk>c_nHV9SooOgm0?oooooo0Oooool001Wooooo00?o
m?Cdokjn__ogmoL03_ooool00onTY:Co^[Zjooooo`3oooooo`006Oooool00oodm?CoalO7ooclo00>
ooooo`03ooShn?nDU9Cob/[:0?oooooo000Iooooo`03ooCdm?o;bl_ooooo00oooooo00?okno_oh^;
RooLg=`0o_ooool001Wooooo00?om?Cdol_;boooool04?ooool00ooRh^;oRXZ:on[ZjP3mooooo`00
6Oooool00oodm?Cobl_;ooooo`0Aooooo`03om;Bd_n?ShoomOGe0?cooooo000Iooooo`03ooCdm?o;
bl_ooooo01;ooooo00?o_[jnohj>S_olo?`0noooool001Wooooo00?om?Cdol_;boooool04oooool0
0onQXJ7oWIfMooclo03jooooo`006Oooool00oodm?Cobl_;ooooo`0Cooooo`04ookno_nZZZ[oWIfM
ooGemOWooooo000Iooooo`03ooCdm?o0`<3on?Sh01Gooooo00?o_Kfmoi2@T?o[jn/0n?ooool001Wo
oooo00?om?CdolC4a?okno/05_ooool00ooAdM7oRXZ:omcLg03gooooo`006Oooool00oodm?Cobl_;
ooooo`0Gooooo`03on;Rh_n;Rh_ob/[:0?Kooooo000Iooooo`03ooCdm?o;bl_ooooo01Sooooo00Co
kno_oiFEUOne]KGoo_knm?ooool001Wooooo00?om?Cdol_;boooool06Oooool01?ohn?SoY:BToj:R
X_ohn?Scooooo`006Oooool00oodm?Cobl_;ooooo`0Jooooo`04ookno_ng]kOoU9BDono_ko;ooooo
000Aooooo`05omNUL?l0003o0000o`00;_nUeo800oooool00oodm?Cobl_;ooooo`0Looooo`03ol_;
bon;Rh_ohN7Q0?7ooooo000Booooo`03ooobb?m?;XWok_oo00Cooooo00?om?Cdol_;boooool07Ooo
ool00ooMgMgoRXZ:om7Ad@3`ooooo`004_ooool00oool/SoCbjAonkoo`04ooooo`04ooCdm?nj^[[o
h>3PooknoQgooooo00?ojn_[oi2@T?nl_;`0koooool001;ooooo00?ooo;8odl^TOo^ool01?ooool0
1?odm?Co^KViomoOgoomoOdNooooo`04ooKfm_nNWYkoZ:RXoo[jn^gooooo000Booooo`03oookcOm?
;XWok_oo00Cooooo00?om?Cdol_;boooool08?ooool01?olo?co/;2`oiRHV?obl_;/ooooo`004Ooo
ool01?oZb9ooG4l^o`0^TOo^ool4ooooo`03ooCdm?o;bl_ooooo02;ooooo00?oa<C4ohf=SOoVi^H0
joooool0017ooooo00Cooo_bomc=_On[/Lgomooo1?ooool00oodm?Cobl_;ooooo`0Sooooo`03omOG
eon:RX[oemOG0>[ooooo000Iooooo`03ooCdm?o;bl_ooooo02Cooooo00?oinOWohf=SOo3`l<0jOoo
ool001Wooooo00?om?Cdol_;boooool09Oooool01?oclo?oVIVIojj^[_olo?cWooooo`006Oooool0
0oodm?Cobl_;ooooo`0Vooooo`04oo_knonZZZ[oWIfMooWinNKooooo000Iooooo`03ooCdm?o3`l?o
n_[j02Sooooo00?o_Kfmoi>CTooPh>00iOooool001Wooooo00?om?Cdol71`OoinOT0:Oooool01?oD
e=CoSXj>ojb/[?obl_;Sooooo`006Oooool00oodm?Cobl_;ooooo`0Zooooo`05oo_knonm_KgoRHV9
olG5aOomoOd0hOooool001Wooooo00?om?Cdol_;boooool0;?ooool01?o^k^koYJFUoi>CTooNg]kP
ooooo`006Oooool00oodm?Cobl_;ooooo`0^ooooo`04omWIfOn?ShooZZZZoo7alMkooooo000Ioooo
o`03ooCdm?o;bl_ooooo02oooooo00Gono_kokno_on8R8So`l?3ooclo03Looooo`006Oooool00ood
m?Cobl_;ooooo`0aooooo`04ono_konWYjOoTY:BomcLg=_ooooo000Iooooo`03ooCdm?o;bl_ooooo
03?ooooo00Cofm_Koi6ATOnXZ:Sol?3`fOooool001Wooooo00?om?CdolK6a_olo?`0=?ooool01Ool
o?co`L71ohR8R?o1`L7oo?cl0=Oooooo000Iooooo`03ooCdm?no_koomoOg03Kooooo00Col?3`ojVY
ZOn@T93of][Je_ooool001Wooooo00?om?Cdol_;boooool0>?ooool01?oMgMgoTY:BojJVY_o_knoD
ooooo`006Oooool00oodm?Cobl_;ooooo`0iooooo`05ooclo?o3`l?oRHV9okno_ookno/0d_ooool0
01Wooooo00?om?Cdol_;boooool0>oooool01?oalO7oZj^[ohn?SooJf][Aooooo`006Oooool00ood
m?Cobl_;ooooo`0mooooo`04omoOgonEUIGoVIVIomKFe/oooooo000Iooooo`03ooCdm?o;bl_ooooo
03kooooo00Koo_knomSHf?nKVi_oTi>Com3@d?omoOg<ooooo`006Oooool00oodm?Cobl_;ooooo`11
ooooo`05omkNg_nQXJ7oSXj>olW9bOokno/0b_ooool001Wooooo00?om?CdolO7aoomoOd0@oooool0
1OoUiNGoZ:RXoh^;Roo3`l?on?Sh0<Sooooo000Iooooo`03ooCdm?nn_[kom_Kf04Gooooo00Gojn_[
ojj^[_n8R8So_;blooGem@36ooooo`006Oooool00oodm?Cobl_;ooooo`17ooooo`05oo3`l?ne]KGo
R8R8okJf]_o`l?00a?ooool001Wooooo00?om?Cdol_;boooool0BOooool01Oodm?Co^k^kohR8R?n_
[joojn_[0<;ooooo000Iooooo`03ooCdm?o;bl_ooooo04_ooooo00Gon?Shol;2`_n:RX[oZJVYonKV
iP30ooooo`006Oooool00oodm?Cobl_;ooooo`1=ooooo`05oo_knoo8b<SoSXj>oj:RX_oOgml0__oo
ool001Wooooo00?om?Cdol_;boooool0Coooool01OomoOgoclo?oi>CTonKVi_ofMWI0;cooooo000I
ooooo`03ooCdm?o;bl_ooooo057ooooo00Koo_knomKFe_nHV9SoUiNGolk>c_ojn_Ziooooo`006Ooo
ool00oodm?CobLW9ooknoP1Dooooo`05omgMgOnWYjOoR8R8okFe]OoYjNT0]oooool001Wooooo00?o
m?Cdok^k^ooemOD0E_ooool01_obl_;o_knoohf=SOnMWIgod=3@oo_knkCooooo000Iooooo`03ooCd
m?o;bl_ooooo05Sooooo00Koo_knomSHf?nTY:CoR8R8okNg]oo[jn^booooo`006Oooool00oodm?Co
bl_;ooooo`1Kooooo`06oo3`l?nm_KgoRh^;oinOWooBd];oo?cl[oooool001Wooooo00?om?Cdol_;
boooool0GOooool01_omoOgoe]KFoj:RX_n9RHWo^[Zjong]kJgooooo000Booooo`03oo;bl_obl_Oo
oooo00Cooooo00?om?Cdol_;boooool0H?ooool01_o^k^ko^k^kohZ:R_nQXJ7oeMGEoogmoJ[ooooo
0005ooooo`05omNUL?l0003o0000o`00;_nUeo800_ooool02_ngNBko000^oj_LmooooooooooUohT^
0?l002ko0000obi`Zoo^ool3ooooo`03ooCdm?o;bl_ooooo06;ooooo00KooOgmom?CdonPX:3oRh^;
okbl_?o_knnXooooo`001_ooool00oool/SoCbj9onkoo`03ooooo`0:ol:ACol004oo_NGkoooooooo
oo_ok^k^oo_oooooon[oR@00oioGm`?ooooo00?om?Cdol_;boooool0IOooool01_o/k>co^;RhohV9
ROnSXj?oemOGooknoZGooooo0006ooooo`03ooobb?m?;Y7ok_oo00_ooooo00?oZe`0ohW8k_ooool0
0_ooool00oodm?Cobl_;ooooo`1Wooooo`06ooclo?oAdM7oWIfMohb<S?nf][Kohn?SXoooool000Ko
oooo00?ooo;8odl^TOo^ool02?ooool01OoBV5co;Uaioh9`@Ol0073oeo_o00?ooooo00Com?CdojRX
Z?o0`<3oo?clJOooool01_o^k^ko`L71oiBDU?n?Shoo_;blonSXj:3ooooo0006ooooo`03oookcOm?
;XWok_oo00Sooooo00CocHU?oebO_OoBd]Ool_oo1?ooool00oodm?Cobl_;ooooo`1]ooooo`06onSX
j?nk^k_oShn?oiBDU?o1`L7ok^k^WOooool000Gooooo00Coj/ROoea?;_l0;Y7ok_oo2?ooool01Oo=
RBko05b2oinHTOnAYL;omooo00?ooooo00?om?Cdol_;boooool0L?ooool01_oShn?o][Jfoh^;RonJ
VY[oalO7oo?cli[ooooo0005ooooo`04oookl_oLcKgoZk7=ooOoo`Sooooo00Gol^3=okNg]ong]k7o
]l;Goo_oo`03ooooo`03ooCdm?o;bl_ooooo07;ooooo00Ooo_knomgMgOn`/;3oQhN7oj2PX?o<c<co
m_Kf09Oooooo000Iooooo`03ooCdm?o;bl_ooooo07Gooooo00Ooo?clomOGeon[Zj_oQXJ6ojFUYOoB
d];on_[j09Cooooo000Iooooo`03ooCdm?o;bl_ooooo07Sooooo00Oon_[jom;Bd_nUYJGoQXJ6oj^[
ZooHf=Soo?cl097ooooo000Iooooo`03ooCdm?o;bl_ooooo07_ooooo00Oom_Kfolc<c?nOWiooR8R8
ok6a/OoMgMgoo_kn08kooooo000Iooooo`03ooCdm?o;bl_ooooo07kooooo00Ool_;bolK6a_nJVY[o
RHV9ok2`/?oHf=Sono_k08_ooooo000Iooooo`03ooCdm?nk^k_om?Cd087ooooo00OolO7aolS8b?nQ
XJ7oQXJ6ojNWYoo?cloom_Kf08Sooooo000Iooooo`03ooCdm?o:b/[ooooo08Cooooo00OomoOgom7A
dOnYZJWoQXJ6oinOWoo6a/Kok^k^08Gooooo000Iooooo`03ooCdm?o;bl_ooooo08Oooooo00Ooo?cl
om[Jf_nb/[;oRh^;oiJFU_nn_[koiNGU08;ooooo000Iooooo`03ooCdm?o;bl_ooooo08_ooooo00Oo
hn?Sok^k^onCTi?oSHf=okFe]OoMgMgooOgm07kooooo000Iooooo`03ooCdm?o;bl_ooooo08kooooo
00Ook>c/olC4a?nLW9coQhN7ojb/[?oDe=ConOWi07_ooooo000Iooooo`03ooCdm?o;bl_ooooo097o
oooo00Oom?Cdolc<c?nUYJGoQXJ6oj>SXoo<c<colO7a07Sooooo000Iooooo`03ooCdm?o;bl_ooooo
09Cooooo00SonOWiomGEeOn^[ZkoRXZ:oiFEUOni^KWogMgMooclo7Cooooo000Iooooo`03ooCdm?o;
bl_ooooo09Oooooo00Soo_knonGUiOo1`L7oWIfMohJ6Q_nUYJGobLW9ong]kG7ooooo000Iooooo`03
ooCdm?nm_Kgom_Kf09_ooooo00SomoOgomGEeOna/K7oSHf=oi6ATOne]KGofMWIoo[jnVgooooo000I
ooooo`03ooCdm?o7alOooOgm09oooooo00OojNWYolG5aOnQXJ7oQXJ6oj6QXOo5aLGojNWY06[ooooo
000Iooooo`03ooCdm?o;bl_ooooo0:;ooooo00Son_[jomWIfOne]KGoTI6Aohf=SOna/K7oeMGEooOg
mfKooooo000Iooooo`03ooCdm?o;bl_ooooo0:Kooooo00SokNg]olW9bOnUYJGoQXJ6oifMWOo1`L7o
iNGUooknoV;ooooo000Iooooo`03ooCdm?o;bl_ooooo0:Wooooo00Soo?clomgMgOni^KWoV9RHohN7
QonWYjOob<S8on[ZjUoooooo000Iooooo`03ooCdm?o;bl_ooooo0:gooooo00SomOGeomCDe?nb/[;o
TI6Aoh^;Ron][Jgoc/k>oo3`l5_ooooo000Iooooo`03ooCdm?o;bl_ooooo0;7ooooo00Sokno_olk>
c_n/[:coRXZ:oi6ATOnc/k?oe=CDooGemEOooooo000Iooooo`03ooCdm?o;bl_ooooo0;Gooooo00So
jNWYolS8b?nVYZKoQhN7oiNGUoni^KWof][Joo[jnU?ooooo000Iooooo`03ooCdm?no_koomoOg0;So
oooo00Woo_knon?Shoo2`/;oX:2PohF5QOnMWIgo_knoon3Ph?omoOd0Coooool001Wooooo00?om?Cd
olK6a_olo?`0_?ooool02Ookno_ogMgMokbl_?nJVY[oQXJ6oj>SXoo6a/Koi>CToogmo@1;ooooo`00
6Oooool00oodm?Cobl_;ooooo`30ooooo`09ooOgmooGemOo][JfoiNGUon6QXKoXZ:Rol30`?oOgmoo
no_k04Oooooo000Iooooo`03ooCdm?o;bl_ooooo0<Cooooo00WomoOgomWIfOnk^k_oW9bLohB4Q?nM
WIgo^k^kom[Jf_ohn?P0@oooool001Wooooo00?om?Cdol_;boooool0b?ooool02Ookno_og]kNol30
`?nQXJ7oQHF5oiRHV?nf][KoeMGEooCdm00oooooo`006Oooool00oodm?Cobl_;ooooo`3<ooooo`09
oogmoOoShn?oaLG5ojJVY_n8R8SoTY:Bok6a/Oo@d=3okno_03_ooooo000Iooooo`03ooCdm?o;bl_o
oooo0=7ooooo00SojNWYol[:b_n[Zj_oS8b<ohf=SOn/[:cobl_;on[ZjSOooooo000Iooooo`03ooCd
m?o;bl_ooooo0=Gooooo00Wok^k^olo?con`/;3oU9BDohN7QonSXj?o`L71omkNg_ojn_X0<_ooool0
01Wooooo00?om?Cdol30`?ohn?P0fOooool02OoemOGof=SHok^k^onNWYkoQHF5oiVIVOnf][Kodm?C
oo7al@0^ooooo`006Oooool00oodm?Coa<C4oo_kn`3Mooooo`0:ooclo?oShn?oa/K6ojRXZ?n;Rh_o
SXj>oj^[Zoo8b<Soi^KVooknoRWooooo000Iooooo`03ooCdm?o;bl_ooooo0>;ooooo00Wok^k^om3@
d?nc/k?oUYJFohF5QOnPX:3o_[jnom_Kfoohn?P09Oooool001Wooooo00?om?Cdol_;boooool0i_oo
ool02_ohn?Sofm_Kokjn__nPX:3oQHF5oiJFU_nd];Coclo?on[Zj_ono_hPooooo`006Oooool00ood
m?Cobl_;ooooo`3Zooooo`0:ookno_oVi^Kob/[:ojf][OnBTY;oQXJ6oj2PX?nk^k_oe]KFoo7alAco
oooo000Iooooo`03ooCdm?o;bl_ooooo0>oooooo00[omoOgomcLg?o1`L7oYZJVoh^;Ron<S8coYjNW
ol;2`_oMgMgon?Sh5oooool0013ooooo00Kooo_Gog000?l0003o0000o`00@Oo8l_l3ooooo`03ooCd
m?o;bl_ooooo0?Cooooo00[ol?3`omGEeOnj^[[oWinOohF5QOnCTi?o[Zj^olW9bOoTi>Coo?cl4_oo
ool0017ooooo00GoejELo`00G?o=l__oj]O=onGgo`03ooooo`03ooCdm?o;bl_ooooo0?Sooooo00[o
o_knonWYjOo>c/ko/k>coiRHV?n4Q8CoVi^KokJf]_oAdM7ok>c/3_ooool001;ooooo00?og;5io`00
Coo=l_l01?ooool01?odm?Co^[Zjon3Ph?ono_klooooo`08oo_knooQhN7oa/K6oj^[Zon@T93oQhN7
oj>SXooJf]X;ooooo`004oooool00ooBV47o06Jaoo_oo`03ooooo`04ooCdm?ni^KWogmoOoogmoOoo
oooo0_ooool00ooemOGofm_KomcLg00;ooooo`004Oooool01Oobk_;ooooooooog?mL047ob?;o00?o
oooo00?om?Cdol_;boooool0oooooolAooooo`004?ooool01_ooooOoWd40obj2ZonmZh;o001VomOk
o`?ooooo00?om?Cdol_;boooool0oooooolAooooo`004Oooool01?oomn[o`Z^HohV9WooBj_L4oooo
o`03ooCdm?o;bl_ooooo0?oooooo4Oooool001[ooooo00?oo?clooooooooool0ooooool@ooooo`00
\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.788221, -0.153538, 0.0305092, \
0.0123413}},
 CellTags->"S5.59.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[1]= ",
 CellTags->"S5.59.1"]
}, Open  ]],

Cell["\<\
Every cubic equation has three roots, counting multiplicity. \
\>", "MathCaption",
 CellTags->{"S5.59.1", "1.5"}],

Cell[CellGroupData[{

Cell["Solve[x^3 == -8.0]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"0.9999999999999996`", "\[InvisibleSpace]"}], "-", 
      RowBox[{"1.7320508075688776`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"1.0000000000000002`", "\[InvisibleSpace]"}], "+", 
      RowBox[{"1.7320508075688772`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.59.1"]
}, Open  ]],

Cell[TextData[{
 "Any one of these three roots could be taken as the cube root of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "8.0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Ordinarily, ",
 StyleBox["Mathematica", "TI"],
 " chooses the one with the least positive argument (the third solution in \
this case). "
}], "MathCaption",
 CellTags->{"S5.59.1", "1.6"}],

Cell[CellGroupData[{

Cell["(-8.0) ^ (1/3)", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"1.0000000000000002`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"1.7320508075688772`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.59.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ^ (", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["/", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[")", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["gives ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["(-(-", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[") ^ (1/", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["))^", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" if ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is negative and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" are integers with ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" odd",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" + ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" I", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["if ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" are real, gives ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" if ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is small and gives ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Nonreal", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" otherwise",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[..., Nonreal, ...]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["gives ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Nonreal", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" for an elementary function or operation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.59.1"],

Cell[TextData[{
 "Automatic transformations caused by the ",
 StyleBox["RealOnly", "MR"],
 " package. "
}], "Caption",
 CellTags->"S5.59.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.59.1", "1.7"}],

Cell["Needs[\"Miscellaneous`RealOnly`\"]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.59.1"],

Cell[TextData[{
 StyleBox["Power", "MR"],
 " has been redefined so that an odd root of a negative number is negative. "
}], "MathCaption",
 CellTags->{"S5.59.1", "1.8"}],

Cell[CellGroupData[{

Cell["(-8.0) ^ (1/3)", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{"-", "2.`"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.59.1"]
}, Open  ]],

Cell[TextData[{
 "Now the plot works for negative values of ",
 StyleBox["x", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.59.1", "1.9"}],

Cell[CellGroupData[{

Cell["Plot[x ^ (1/3), {x, -8, 8}]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.59.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0595238 0.309017 0.147151 [
[.05357 .29652 -12 -9 ]
[.05357 .29652 12 0 ]
[.20238 .29652 -6 -9 ]
[.20238 .29652 6 0 ]
[.35119 .29652 -12 -9 ]
[.35119 .29652 12 0 ]
[.64881 .29652 -9 -9 ]
[.64881 .29652 9 0 ]
[.79762 .29652 -3 -9 ]
[.79762 .29652 3 0 ]
[.94643 .29652 -9 -9 ]
[.94643 .29652 9 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .16187 -12 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -6 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05357 .30902 m
.05357 .31527 L
s
[(-7.5)] .05357 .29652 0 1 Mshowa
.20238 .30902 m
.20238 .31527 L
s
[(-5)] .20238 .29652 0 1 Mshowa
.35119 .30902 m
.35119 .31527 L
s
[(-2.5)] .35119 .29652 0 1 Mshowa
.64881 .30902 m
.64881 .31527 L
s
[(2.5)] .64881 .29652 0 1 Mshowa
.79762 .30902 m
.79762 .31527 L
s
[(5)] .79762 .29652 0 1 Mshowa
.94643 .30902 m
.94643 .31527 L
s
[(7.5)] .94643 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.1131 .30902 m
.1131 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.17262 .30902 m
.17262 .31277 L
s
.23214 .30902 m
.23214 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.29167 .30902 m
.29167 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.41071 .30902 m
.41071 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.47024 .30902 m
.47024 .31277 L
s
.52976 .30902 m
.52976 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.58929 .30902 m
.58929 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.70833 .30902 m
.70833 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.76786 .30902 m
.76786 .31277 L
s
.82738 .30902 m
.82738 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.8869 .30902 m
.8869 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.02381 .30902 m
.02381 .31277 L
s
.97619 .30902 m
.97619 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01472 m
.50625 .01472 L
s
[(-2)] .4875 .01472 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-1)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(1)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(2)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .0229 L
.10458 .0324 L
.14415 .04195 L
.18221 .05183 L
.22272 .06326 L
.26171 .07537 L
.30316 .08978 L
.34309 .10574 L
.3815 .1239 L
.40095 .13464 L
.42237 .14824 L
.44292 .1639 L
.46172 .182 L
.47167 .19412 L
.48113 .20867 L
.4863 .21884 L
.49111 .23094 L
.49387 .24006 L
.49638 .25116 L
.49777 .2598 L
.49856 .26642 L
.49928 .27519 L
.49991 .29207 L
.5006 .34086 L
.50133 .35044 L
.502 .35653 L
.50326 .36493 L
.5046 .37172 L
.50701 .38115 L
.51246 .39638 L
.51716 .40623 L
.52236 .41519 L
.54091 .43888 L
.56026 .45677 L
.58112 .47216 L
.62226 .49607 L
.66188 .51442 L
.69999 .52941 L
.74055 .5434 L
.77959 .55546 L
.82109 .56709 L
.86107 .57739 L
.89954 .5866 L
.94046 .59577 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.59.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.59.1"]
}, Open  ]],

Cell[TextData[{
 "In addition to modifying ",
 StyleBox["Power", "MR"],
 ", the package suppresses complex numbers. This is now the solution of the \
cubic equation. "
}], "MathCaption",
 CellTags->{"S5.59.1", "1.10"}],

Cell[CellGroupData[{

Cell["Solve[x^3 == -8.0]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Nonreal", "::", "\<\"warning\"\>"}], 
  RowBox[{":", " "}], "\<\"Nonreal number encountered.\"\>"}]], "Message",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "Nonreal"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "Nonreal"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.59.1"]
}, Open  ]],

Cell[TextData[{
 "Very small imaginary parts are transformed to ",
 StyleBox["0", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.59.1", "1.11"}],

Cell[CellGroupData[{

Cell["{23 + 0. I, Sin[ArcSin[23.]]}", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"23", ",", "23.000000000000004`"}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.59.1"]
}, Open  ]],

Cell[TextData[{
 "A number with an imaginary part that is not small is transformed to ",
 StyleBox["Nonreal", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.59.1", "1.12"}],

Cell[CellGroupData[{

Cell["{ArcSin[23.], Sin[23. + I]}", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Nonreal", "::", "\<\"warning\"\>"}], 
  RowBox[{":", " "}], "\<\"Nonreal number encountered.\"\>"}]], "Message",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Nonreal", ",", "Nonreal"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.59.1"]
}, Open  ]],

Cell[TextData[{
 "Finally, elementary calculations involving unavoidable complex numbers are \
transformed to ",
 StyleBox["Nonreal", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.59.1", "1.13"}],

Cell[CellGroupData[{

Cell["Tan[a + 23 / (a + b I)]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.59.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Nonreal", "::", "\<\"warning\"\>"}], 
  RowBox[{":", " "}], "\<\"Nonreal number encountered.\"\>"}]], "Message",
 CellTags->"S5.59.1"],

Cell[BoxData["Nonreal"], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.59.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.59.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.59.1", "1.1"}],
    Cell[1917, 61, 434, 9, 72, "Text",
      CellTags->{"S5.59.1", "1.2"}],
    Cell[2354, 72, 451, 12, 56, "Text",
      CellTags->{"S5.59.1", "1.3"}],
    Cell[2808, 86, 309, 8, 56, "MathCaption",
      CellTags->{"S5.59.1", "1.4"}],
    Cell[3142, 98, 90, 2, 28, "Input",
      CellTags->"S5.59.1"],
    Cell[3235, 102, 243, 6, 21, "Message",
      CellTags->"S5.59.1"],
    Cell[3481, 110, 243, 6, 21, "Message",
      CellTags->"S5.59.1"],
    Cell[3727, 118, 242, 6, 21, "Message",
      CellTags->"S5.59.1"],
    Cell[3972, 126, 235, 6, 33, "Message",
      CellTags->"S5.59.1"],
    Cell[4210, 134, 18657, 405, 186, 2918, 206, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.59.1"],
    Cell[22870, 541, 180, 6, 22, "Output",
      CellTags->"S5.59.1"],
    Cell[23065, 550, 123, 3, 40, "MathCaption",
      CellTags->{"S5.59.1", "1.5"}],
    Cell[23213, 557, 81, 2, 28, "Input",
      CellTags->"S5.59.1"],
    Cell[23297, 561, 598, 18, 70, "Output",
      CellTags->"S5.59.1"],
    Cell[23910, 582, 409, 11, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.6"}],
    Cell[24344, 597, 77, 2, 70, "Input",
      CellTags->"S5.59.1"],
    Cell[24424, 601, 201, 5, 70, "Output",
      CellTags->"S5.59.1"],
    Cell[24640, 609, 5162, 165, 70, "DefinitionBox",
      CellTags->"S5.59.1"],
    Cell[29805, 776, 140, 5, 70, "Caption",
      CellTags->"S5.59.1"],
    Cell[29948, 783, 78, 1, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.7"}],
    Cell[30029, 786, 97, 2, 70, "Input",
      CellTags->"S5.59.1"],
    Cell[30129, 790, 169, 4, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.8"}],
    Cell[30323, 798, 77, 2, 70, "Input",
      CellTags->"S5.59.1"],
    Cell[30403, 802, 93, 3, 70, "Output",
      CellTags->"S5.59.1"],
    Cell[30511, 808, 140, 5, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.9"}],
    Cell[30676, 817, 90, 2, 70, "Input",
      CellTags->"S5.59.1"],
    Cell[30769, 821, 3971, 286, 70, 3900, 283, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.59.1"],
    Cell[34743, 1109, 180, 6, 70, "Output",
      CellTags->"S5.59.1"],
    Cell[34938, 1118, 218, 6, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.10"}],
    Cell[35181, 1128, 81, 2, 70, "Input",
      CellTags->"S5.59.1"],
    Cell[35265, 1132, 169, 4, 70, "Message",
      CellTags->"S5.59.1"],
    Cell[35437, 1138, 329, 11, 70, "Output",
      CellTags->"S5.59.1"],
    Cell[35781, 1152, 145, 5, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.11"}],
    Cell[35951, 1161, 92, 2, 70, "Input",
      CellTags->"S5.59.1"],
    Cell[36046, 1165, 138, 4, 70, "Output",
      CellTags->"S5.59.1"],
    Cell[36199, 1172, 173, 5, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.12"}],
    Cell[36397, 1181, 90, 2, 70, "Input",
      CellTags->"S5.59.1"],
    Cell[36490, 1185, 169, 4, 70, "Message",
      CellTags->"S5.59.1"],
    Cell[36662, 1191, 131, 4, 70, "Output",
      CellTags->"S5.59.1"],
    Cell[36808, 1198, 197, 6, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.13"}],
    Cell[37030, 1208, 87, 2, 70, "Input",
      CellTags->"S5.59.1"],
    Cell[37120, 1212, 169, 4, 70, "Message",
      CellTags->"S5.59.1"],
    Cell[37292, 1218, 81, 2, 70, "Output",
      CellTags->"S5.59.1"]},
  "1.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.59.1", "1.1"}]},
  "1.2"->{
    Cell[1917, 61, 434, 9, 72, "Text",
      CellTags->{"S5.59.1", "1.2"}]},
  "1.3"->{
    Cell[2354, 72, 451, 12, 56, "Text",
      CellTags->{"S5.59.1", "1.3"}]},
  "1.4"->{
    Cell[2808, 86, 309, 8, 56, "MathCaption",
      CellTags->{"S5.59.1", "1.4"}]},
  "1.5"->{
    Cell[23065, 550, 123, 3, 40, "MathCaption",
      CellTags->{"S5.59.1", "1.5"}]},
  "1.6"->{
    Cell[23910, 582, 409, 11, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.6"}]},
  "1.7"->{
    Cell[29948, 783, 78, 1, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.7"}]},
  "1.8"->{
    Cell[30129, 790, 169, 4, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.8"}]},
  "1.9"->{
    Cell[30511, 808, 140, 5, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.9"}]},
  "1.10"->{
    Cell[34938, 1118, 218, 6, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.10"}]},
  "1.11"->{
    Cell[35781, 1152, 145, 5, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.11"}]},
  "1.12"->{
    Cell[36199, 1172, 173, 5, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.12"}]},
  "1.13"->{
    Cell[36808, 1198, 197, 6, 70, "MathCaption",
      CellTags->{"S5.59.1", "1.13"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.59.1", 38024, 1240},
  {"1.1", 41394, 1330},
  {"1.2", 41488, 1333},
  {"1.3", 41576, 1336},
  {"1.4", 41665, 1339},
  {"1.5", 41760, 1342},
  {"1.6", 41857, 1345},
  {"1.7", 41955, 1348},
  {"1.8", 42051, 1351},
  {"1.9", 42148, 1354},
  {"1.10", 42246, 1357},
  {"1.11", 42346, 1360},
  {"1.12", 42446, 1363},
  {"1.13", 42546, 1366}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 138, 6, 36, "Subsection",
  CellTags->{"S5.59.1", "1.1"}],
Cell[1917, 61, 434, 9, 72, "Text",
  CellTags->{"S5.59.1", "1.2"}],
Cell[2354, 72, 451, 12, 56, "Text",
  CellTags->{"S5.59.1", "1.3"}],
Cell[2808, 86, 309, 8, 56, "MathCaption",
  CellTags->{"S5.59.1", "1.4"}],

Cell[CellGroupData[{
Cell[3142, 98, 90, 2, 28, "Input",
  CellTags->"S5.59.1"],
Cell[3235, 102, 243, 6, 21, "Message",
  CellTags->"S5.59.1"],
Cell[3481, 110, 243, 6, 21, "Message",
  CellTags->"S5.59.1"],
Cell[3727, 118, 242, 6, 21, "Message",
  CellTags->"S5.59.1"],
Cell[3972, 126, 235, 6, 33, "Message",
  CellTags->"S5.59.1"],
Cell[4210, 134, 18657, 405, 186, 2918, 206, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S5.59.1"],
Cell[22870, 541, 180, 6, 22, "Output",
  CellTags->"S5.59.1"]
}, Open  ]],
Cell[23065, 550, 123, 3, 40, "MathCaption",
  CellTags->{"S5.59.1", "1.5"}],

Cell[CellGroupData[{
Cell[23213, 557, 81, 2, 28, "Input",
  CellTags->"S5.59.1"],
Cell[23297, 561, 598, 18, 70, "Output",
  CellTags->"S5.59.1"]
}, Open  ]],
Cell[23910, 582, 409, 11, 70, "MathCaption",
  CellTags->{"S5.59.1", "1.6"}],

Cell[CellGroupData[{
Cell[24344, 597, 77, 2, 70, "Input",
  CellTags->"S5.59.1"],
Cell[24424, 601, 201, 5, 70, "Output",
  CellTags->"S5.59.1"]
}, Open  ]],
Cell[24640, 609, 5162, 165, 70, "DefinitionBox",
  CellTags->"S5.59.1"],
Cell[29805, 776, 140, 5, 70, "Caption",
  CellTags->"S5.59.1"],
Cell[29948, 783, 78, 1, 70, "MathCaption",
  CellTags->{"S5.59.1", "1.7"}],
Cell[30029, 786, 97, 2, 70, "Input",
  CellTags->"S5.59.1"],
Cell[30129, 790, 169, 4, 70, "MathCaption",
  CellTags->{"S5.59.1", "1.8"}],

Cell[CellGroupData[{
Cell[30323, 798, 77, 2, 70, "Input",
  CellTags->"S5.59.1"],
Cell[30403, 802, 93, 3, 70, "Output",
  CellTags->"S5.59.1"]
}, Open  ]],
Cell[30511, 808, 140, 5, 70, "MathCaption",
  CellTags->{"S5.59.1", "1.9"}],

Cell[CellGroupData[{
Cell[30676, 817, 90, 2, 70, "Input",
  CellTags->"S5.59.1"],
Cell[30769, 821, 3971, 286, 70, 3900, 283, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.59.1"],
Cell[34743, 1109, 180, 6, 70, "Output",
  CellTags->"S5.59.1"]
}, Open  ]],
Cell[34938, 1118, 218, 6, 70, "MathCaption",
  CellTags->{"S5.59.1", "1.10"}],

Cell[CellGroupData[{
Cell[35181, 1128, 81, 2, 70, "Input",
  CellTags->"S5.59.1"],
Cell[35265, 1132, 169, 4, 70, "Message",
  CellTags->"S5.59.1"],
Cell[35437, 1138, 329, 11, 70, "Output",
  CellTags->"S5.59.1"]
}, Open  ]],
Cell[35781, 1152, 145, 5, 70, "MathCaption",
  CellTags->{"S5.59.1", "1.11"}],

Cell[CellGroupData[{
Cell[35951, 1161, 92, 2, 70, "Input",
  CellTags->"S5.59.1"],
Cell[36046, 1165, 138, 4, 70, "Output",
  CellTags->"S5.59.1"]
}, Open  ]],
Cell[36199, 1172, 173, 5, 70, "MathCaption",
  CellTags->{"S5.59.1", "1.12"}],

Cell[CellGroupData[{
Cell[36397, 1181, 90, 2, 70, "Input",
  CellTags->"S5.59.1"],
Cell[36490, 1185, 169, 4, 70, "Message",
  CellTags->"S5.59.1"],
Cell[36662, 1191, 131, 4, 70, "Output",
  CellTags->"S5.59.1"]
}, Open  ]],
Cell[36808, 1198, 197, 6, 70, "MathCaption",
  CellTags->{"S5.59.1", "1.13"}],

Cell[CellGroupData[{
Cell[37030, 1208, 87, 2, 70, "Input",
  CellTags->"S5.59.1"],
Cell[37120, 1212, 169, 4, 70, "Message",
  CellTags->"S5.59.1"],
Cell[37292, 1218, 81, 2, 70, "Output",
  CellTags->"S5.59.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

