(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10050,        364]*)
(*NotebookOutlinePosition[     13967,        485]*)
(*  CellTagsIndexPosition[     13663,        469]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumberTheory",
 StyleBox["`", "MB"],
 "Recognize",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.74.1", "1.1"}],

Cell[TextData[{
 "This package defines the function ",
 StyleBox["Recognize", "MR"],
 " for determining a polynomial with integer coefficients, given an \
approximate real zero of the polynomial and the degree of the polynomial. The \
resulting polynomial is normally not unique. "
}], "Text",
 CellTags->{"S5.74.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Recognize[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a polynomial of degree at most ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" such that ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is an approximate zero of the polynomial ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Recognize[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find a polynomial of degree at most ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" such that ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is a zero, and with penalty weight ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" against higher\[Hyphen]degree polynomials. ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.74.1"],

Cell["Determining a polynomial from a solution. ", "Caption",
 CellTags->"S5.74.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.74.1", "1.3"}],

Cell["<< NumberTheory`Recognize`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.74.1"],

Cell[TextData[{
 "This finds a linear polynomial in ",
 StyleBox["t", "MR"],
 " with solution ",
 StyleBox["1.7", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.74.1", "1.4"}],

Cell[CellGroupData[{

Cell["Recognize[1.7, 1, t]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.74.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "17"}], "+", 
  RowBox[{"10", " ", "t"}]}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.74.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["NSolve", "MR"],
 " gives the numerical solutions of a cubic equation. "
}], "MathCaption",
 CellTags->{"S5.74.1", "1.5"}],

Cell[CellGroupData[{

Cell["NSolve[3 x^3 - 2 x + 5 == 0]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.74.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.3717394241650058`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"0.6858697120825029`", "\[InvisibleSpace]"}], "-", 
      RowBox[{"0.8628934576120852`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"0.6858697120825029`", "\[InvisibleSpace]"}], "+", 
      RowBox[{"0.8628934576120852`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.74.1"]
}, Open  ]],

Cell["Here is the first solution. ", "MathCaption",
 CellTags->{"S5.74.1", "1.6"}],

Cell[CellGroupData[{

Cell["sol = First[x /. %]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.74.1"],

Cell[BoxData[
 RowBox[{"-", "1.3717394241650058`"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.74.1"]
}, Open  ]],

Cell[TextData[{
 "This result is proportional to the original polynomial used in ",
 StyleBox["NSolve", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.74.1", "1.7"}],

Cell[CellGroupData[{

Cell["Recognize[sol, 3, t]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.74.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "5"}], "+", 
  RowBox[{"2", " ", "t"}], "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["t", "3"]}]}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.74.1"]
}, Open  ]],

Cell[TextData[{
 "Here is a quadratic polynomial for which ",
 StyleBox["sol", "MR"],
 " is an approximate solution. "
}], "MathCaption",
 CellTags->{"S5.74.1", "1.8"}],

Cell[CellGroupData[{

Cell["Recognize[sol, 2, t]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.74.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "173197"}], "+", 
  RowBox[{"44341", " ", "t"}], "+", 
  RowBox[{"124369", " ", 
   SuperscriptBox["t", "2"]}]}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.74.1"]
}, Open  ]],

Cell["This result is a polynomial of degree 5. ", "MathCaption",
 CellTags->{"S5.74.1", "1.9"}],

Cell[CellGroupData[{

Cell["Recognize[N[Sqrt[3^(2/5)]], 5, t]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.74.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], "+", 
  SuperscriptBox["t", "5"]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.74.1"]
}, Open  ]],

Cell["\<\
If the penalty is large enough, a lower\[Hyphen]order polynomial may be \
returned. \
\>", "MathCaption",
 CellTags->{"S5.74.1", "1.10"}],

Cell[CellGroupData[{

Cell["Recognize[N[Sqrt[3^(2/5)]], 5, t, 10]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.74.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "14625"}], "+", 
  RowBox[{"11193", " ", "t"}], "+", 
  RowBox[{"328", " ", 
   SuperscriptBox["t", "2"]}], "+", 
  RowBox[{"88", " ", 
   SuperscriptBox["t", "3"]}], "+", 
  SuperscriptBox["t", "4"]}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.74.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.74.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.74.1", "1.1"}],
    Cell[1917, 61, 324, 7, 56, "Text",
      CellTags->{"S5.74.1", "1.2"}],
    Cell[2244, 70, 3928, 122, 120, "DefinitionBox",
      CellTags->"S5.74.1"],
    Cell[6175, 194, 83, 1, 15, "Caption",
      CellTags->"S5.74.1"],
    Cell[6261, 197, 78, 1, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.3"}],
    Cell[6342, 200, 89, 2, 28, "Input",
      CellTags->"S5.74.1"],
    Cell[6434, 204, 176, 7, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.4"}],
    Cell[6635, 215, 83, 2, 28, "Input",
      CellTags->"S5.74.1"],
    Cell[6721, 219, 139, 5, 25, "Output",
      CellTags->"S5.74.1"],
    Cell[6875, 227, 148, 4, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.5"}],
    Cell[7048, 235, 91, 2, 28, "Input",
      CellTags->"S5.74.1"],
    Cell[7142, 239, 614, 18, 41, "Output",
      CellTags->"S5.74.1"],
    Cell[7771, 260, 82, 1, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.6"}],
    Cell[7878, 265, 82, 2, 28, "Input",
      CellTags->"S5.74.1"],
    Cell[7963, 269, 109, 3, 25, "Output",
      CellTags->"S5.74.1"],
    Cell[8087, 275, 166, 5, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.7"}],
    Cell[8278, 284, 83, 2, 70, "Input",
      CellTags->"S5.74.1"],
    Cell[8364, 288, 195, 7, 70, "Output",
      CellTags->"S5.74.1"],
    Cell[8574, 298, 168, 5, 70, "MathCaption",
      CellTags->{"S5.74.1", "1.8"}],
    Cell[8767, 307, 83, 2, 70, "Input",
      CellTags->"S5.74.1"],
    Cell[8853, 311, 209, 7, 70, "Output",
      CellTags->"S5.74.1"],
    Cell[9077, 321, 95, 1, 70, "MathCaption",
      CellTags->{"S5.74.1", "1.9"}],
    Cell[9197, 326, 96, 2, 70, "Input",
      CellTags->"S5.74.1"],
    Cell[9296, 330, 138, 5, 70, "Output",
      CellTags->"S5.74.1"],
    Cell[9449, 338, 147, 4, 70, "MathCaption",
      CellTags->{"S5.74.1", "1.10"}],
    Cell[9621, 346, 100, 2, 70, "Input",
      CellTags->"S5.74.1"],
    Cell[9724, 350, 298, 10, 70, "Output",
      CellTags->"S5.74.1"]},
  "1.1"->{
    Cell[1776, 53, 138, 6, 36, "Subsection",
      CellTags->{"S5.74.1", "1.1"}]},
  "1.2"->{
    Cell[1917, 61, 324, 7, 56, "Text",
      CellTags->{"S5.74.1", "1.2"}]},
  "1.3"->{
    Cell[6261, 197, 78, 1, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.3"}]},
  "1.4"->{
    Cell[6434, 204, 176, 7, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.4"}]},
  "1.5"->{
    Cell[6875, 227, 148, 4, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.5"}]},
  "1.6"->{
    Cell[7771, 260, 82, 1, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.6"}]},
  "1.7"->{
    Cell[8087, 275, 166, 5, 40, "MathCaption",
      CellTags->{"S5.74.1", "1.7"}]},
  "1.8"->{
    Cell[8574, 298, 168, 5, 70, "MathCaption",
      CellTags->{"S5.74.1", "1.8"}]},
  "1.9"->{
    Cell[9077, 321, 95, 1, 70, "MathCaption",
      CellTags->{"S5.74.1", "1.9"}]},
  "1.10"->{
    Cell[9449, 338, 147, 4, 70, "MathCaption",
      CellTags->{"S5.74.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.74.1", 10673, 380},
  {"1.1", 12700, 435},
  {"1.2", 12794, 438},
  {"1.3", 12882, 441},
  {"1.4", 12977, 444},
  {"1.5", 13073, 447},
  {"1.6", 13169, 450},
  {"1.7", 13264, 453},
  {"1.8", 13360, 456},
  {"1.9", 13456, 459},
  {"1.10", 13552, 462}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 138, 6, 36, "Subsection",
  CellTags->{"S5.74.1", "1.1"}],
Cell[1917, 61, 324, 7, 56, "Text",
  CellTags->{"S5.74.1", "1.2"}],
Cell[2244, 70, 3928, 122, 120, "DefinitionBox",
  CellTags->"S5.74.1"],
Cell[6175, 194, 83, 1, 15, "Caption",
  CellTags->"S5.74.1"],
Cell[6261, 197, 78, 1, 40, "MathCaption",
  CellTags->{"S5.74.1", "1.3"}],
Cell[6342, 200, 89, 2, 28, "Input",
  CellTags->"S5.74.1"],
Cell[6434, 204, 176, 7, 40, "MathCaption",
  CellTags->{"S5.74.1", "1.4"}],

Cell[CellGroupData[{
Cell[6635, 215, 83, 2, 28, "Input",
  CellTags->"S5.74.1"],
Cell[6721, 219, 139, 5, 25, "Output",
  CellTags->"S5.74.1"]
}, Open  ]],
Cell[6875, 227, 148, 4, 40, "MathCaption",
  CellTags->{"S5.74.1", "1.5"}],

Cell[CellGroupData[{
Cell[7048, 235, 91, 2, 28, "Input",
  CellTags->"S5.74.1"],
Cell[7142, 239, 614, 18, 41, "Output",
  CellTags->"S5.74.1"]
}, Open  ]],
Cell[7771, 260, 82, 1, 40, "MathCaption",
  CellTags->{"S5.74.1", "1.6"}],

Cell[CellGroupData[{
Cell[7878, 265, 82, 2, 28, "Input",
  CellTags->"S5.74.1"],
Cell[7963, 269, 109, 3, 25, "Output",
  CellTags->"S5.74.1"]
}, Open  ]],
Cell[8087, 275, 166, 5, 40, "MathCaption",
  CellTags->{"S5.74.1", "1.7"}],

Cell[CellGroupData[{
Cell[8278, 284, 83, 2, 70, "Input",
  CellTags->"S5.74.1"],
Cell[8364, 288, 195, 7, 70, "Output",
  CellTags->"S5.74.1"]
}, Open  ]],
Cell[8574, 298, 168, 5, 70, "MathCaption",
  CellTags->{"S5.74.1", "1.8"}],

Cell[CellGroupData[{
Cell[8767, 307, 83, 2, 70, "Input",
  CellTags->"S5.74.1"],
Cell[8853, 311, 209, 7, 70, "Output",
  CellTags->"S5.74.1"]
}, Open  ]],
Cell[9077, 321, 95, 1, 70, "MathCaption",
  CellTags->{"S5.74.1", "1.9"}],

Cell[CellGroupData[{
Cell[9197, 326, 96, 2, 70, "Input",
  CellTags->"S5.74.1"],
Cell[9296, 330, 138, 5, 70, "Output",
  CellTags->"S5.74.1"]
}, Open  ]],
Cell[9449, 338, 147, 4, 70, "MathCaption",
  CellTags->{"S5.74.1", "1.10"}],

Cell[CellGroupData[{
Cell[9621, 346, 100, 2, 70, "Input",
  CellTags->"S5.74.1"],
Cell[9724, 350, 298, 10, 70, "Output",
  CellTags->"S5.74.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

