(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     72620,       3729]*)
(*NotebookOutlinePosition[     78054,       3890]*)
(*  CellTagsIndexPosition[     77689,       3872]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "ResonanceAbsorptionLines",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.60.1", "1.1"}],

Cell[TextData[{
 "The functions defined in ",
 StyleBox["Miscellaneous`ResonanceAbsorptionLines`", "MR"],
 " allow you to efficiently search through an atomic data table for resonance \
absorption lines. Other functions give absorption maps of particular elements \
or of a particular wavelength range. "
}], "Text",
 CellTags->{"S5.60.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FindIons[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["wavelength1", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["wavelenth2", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the resonance absorption lines in the wavelength range between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["wavelength",
          "TI"], "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["wavelength",
          "TI"], "2"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.60.1"],

Cell["Finding the resonance absorption lines. ", "Caption",
 CellTags->"S5.60.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.60.1", "1.3"}],

Cell["<<Miscellaneous`ResonanceAbsorptionLines`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.60.1"],

Cell["\<\
This gives the resonance absorption lines in the wavelength range between \
1215 Angstrom and 1220 Angstrom. \
\>", "MathCaption",
 CellTags->{"S5.60.1", "1.4"}],

Cell[CellGroupData[{

Cell["FindIons[1215 Angstrom, 1220 Angstrom]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.60.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Hydrogen", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.6701`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Hydrogen", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.6737`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Hydrogen", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.6683`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Deuterium", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.3394`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Deuterium", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.343`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Deuterium", ",", "\<\"I\"\>", ",", 
     RowBox[{"1215.3376`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Oxygen", ",", "Vanadium", ",", 
     RowBox[{"1218.344`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Phosphorus", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.385`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Phosphorus", ",", "\<\"I\"\>", ",", 
     RowBox[{"1217.843`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Sulfur", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.5953`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Sulfur", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.57`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Sulfur", ",", "\<\"I\"\>", ",", 
     RowBox[{"1218.5133`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Manganese", ",", "\<\"II\"\>", ",", 
     RowBox[{"1219.604`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Manganese", ",", "\<\"II\"\>", ",", 
     RowBox[{"1218.745`", " ", "Angstrom"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Manganese", ",", "\<\"II\"\>", ",", 
     RowBox[{"1218.704`", " ", "Angstrom"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.60.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["AtomicData[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the spectral data for the resonance absorption lines produced by \
the specified element",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VacuumWavelength[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a list of the wavelength in vacuum for the resonance absorption \
lines produced by the specified element",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.60.1"],

Cell["Properties of resonance absorption lines. ", "Caption",
 CellTags->"S5.60.1"],

Cell[TextData[{
 StyleBox["AtomicData[", "MR"],
 StyleBox["element", "TI"],
 StyleBox["]", "MR"],
 " gives a list of properties for the lines produced by the specified \
element. These properties are vacuum wavelength, air wavelength, lower term \
fine structure energy, statistical weight of the lower level, statistical \
weight of the upper level, relative strength, transition probability, damping \
constant, and oscillator strength of the element. Individual properties can \
be selected using the functions ",
 StyleBox["VacuumWavelength", "MR"],
 ", ",
 StyleBox["AirWavelength", "MR"],
 ", ",
 StyleBox["LowerTermFineStructureEnergy", "MR"],
 ", ",
 StyleBox["LowerStatisticalWeight", "MR"],
 ", ",
 StyleBox["UpperStatisticalWeight", "MR"],
 ", ",
 StyleBox["RelativeStrength", "MR"],
 ", ",
 StyleBox["TransitionProbability", "MR"],
 ", ",
 StyleBox["DampingConstant", "MR"],
 ", and ",
 StyleBox["OscillatorStrength", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.60.1", "1.5"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["AirWavelength[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["v",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["a",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" pairs, where ", "TR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["v",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the wavelength in vacuum and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["a",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the wavelength in air for the resonance absorption lines produced \
by the specified element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LowerTermFineStructureEnergy[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["v",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["energy", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" pairs, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["energy", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the energy of the fine structure level in the lower term for the \
lines produced by the specified element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["LowerStatisticalWeight[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["v",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["weight", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" pairs, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["weight", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the statistical weight of the lower level for the lines produced \
by the specified element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["UpperStatisticalWeight[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["v",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["weight", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" pairs, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["weight", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the statistical weight of the upper level for the lines produced \
by the specified element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RelativeStrength[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["v",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["strength", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" pairs, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["strength", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the relative strength of the lines produced by the specified \
element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TransitionProbability[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["v",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["probability", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" pairs, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["probability", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the spontaneous transition probability of the lines produced by \
the specified element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DampingConstant[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["v",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["damping", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" pairs, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["damping", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is a natural damping constant of the lines produced by the specified \
element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["OscillatorStrength[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["wavelength",
          "TI"], 
         StyleBox["v",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["strength", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" pairs, where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["strength", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is the absorption oscillator strength of the lines produced by the \
specified element",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.60.1"],

Cell["\<\
Properties of resonance absorption lines paired with associated wavelengths \
in vacuum. \
\>", "Caption",
 CellTags->"S5.60.1"],

Cell["\<\
This gives a list of pairs of vacuum wavelength and oscillator strength for \
the resonance absorption lines produced by Beryllium. \
\>", "MathCaption",
 CellTags->{"S5.60.1", "1.6"}],

Cell[CellGroupData[{

Cell["OscillatorStrength[Beryllium]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.60.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1036.299`", " ", "Angstrom"}], ",", "0.053453`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1036.3057`", " ", "Angstrom"}], ",", "0.080179`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1036.319`", " ", "Angstrom"}], ",", "0.026726`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1661.478`", " ", "Angstrom"}], ",", "0.024831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2349.329`", " ", "Angstrom"}], ",", "1.3554`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3131.327`", " ", "Angstrom"}], ",", "0.33817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3131.5423`", " ", "Angstrom"}], ",", "0.50722`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3131.973`", " ", "Angstrom"}], ",", "0.16905`"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.60.1"]
}, Open  ]],

Cell["\<\
The ionization level of an element can be specified by giving the quoted \
roman numeral, \"I\", \"II\", \"III\", \"IV\", \"V\", or \"VI\", as a second \
argument to a property function. \
\>", "Text",
 CellTags->{"S5.60.1", "1.7"}],

Cell["\<\
This gives the paired data for vacuum wavelength and oscillator strength for \
the lines produced by Beryllium at the ionization level I. \
\>", "MathCaption",
 CellTags->{"S5.60.1", "1.8"}],

Cell[CellGroupData[{

Cell["OscillatorStrength[Beryllium, \"I\"]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.60.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1661.478`", " ", "Angstrom"}], ",", "0.024831`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2349.329`", " ", "Angstrom"}], ",", "1.3554`"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.60.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["WavelengthAbsorptionMap[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["wavelength1", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["wavelength2", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the absorption map in the wavelength range between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["wavelength",
          "TI"], "1"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["wavelength",
          "TI"], "2"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ElementAbsorptionMap[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the absorption map of the specified element",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ElementAbsorptionMap[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["element", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ionstage", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the absorption map of the element at the specified ionization \
level",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.60.1"],

Cell["Absorption maps. ", "Caption",
 CellTags->"S5.60.1"],

Cell["\<\
This gives the absorption map in the range between 1213 Angstrom and 1215 \
Angstrom. \
\>", "MathCaption",
 CellTags->{"S5.60.1", "1.9"}],

Cell[CellGroupData[{

Cell["WavelengthAbsorptionMap[1213 Angstrom, 1218 Angstrom]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.60.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-242.6 0.2 -9.81203e-18 0.18 [
[0 -0.0125 -12 -9 ]
[0 -0.0125 12 0 ]
[.2 -0.0125 -12 -9 ]
[.2 -0.0125 12 0 ]
[.4 -0.0125 -12 -9 ]
[.4 -0.0125 12 0 ]
[.6 -0.0125 -12 -9 ]
[.6 -0.0125 12 0 ]
[.8 -0.0125 -12 -9 ]
[.8 -0.0125 12 0 ]
[1 -0.0125 -12 -9 ]
[1 -0.0125 12 0 ]
[ 0 0 0 0 ]
[ 1 .3 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
0 .00625 L
s
[(1213)] 0 -0.0125 0 1 Mshowa
.2 0 m
.2 .00625 L
s
[(1214)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(1215)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(1216)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(1217)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(1218)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.04 0 m
.04 .00375 L
s
.08 0 m
.08 .00375 L
s
.12 0 m
.12 .00375 L
s
.16 0 m
.16 .00375 L
s
.24 0 m
.24 .00375 L
s
.28 0 m
.28 .00375 L
s
.32 0 m
.32 .00375 L
s
.36 0 m
.36 .00375 L
s
.44 0 m
.44 .00375 L
s
.48 0 m
.48 .00375 L
s
.52 0 m
.52 .00375 L
s
.56 0 m
.56 .00375 L
s
.64 0 m
.64 .00375 L
s
.68 0 m
.68 .00375 L
s
.72 0 m
.72 .00375 L
s
.76 0 m
.76 .00375 L
s
.84 0 m
.84 .00375 L
s
.88 0 m
.88 .00375 L
s
.92 0 m
.92 .00375 L
s
.96 0 m
.96 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 0 m
1 0 L
1 .3 L
0 .3 L
closepath
clip
newpath
.5 Mabswid
0 .18 m
1 .18 L
s
.061 0 m
.061 .18 L
s
gsave
.061 .18 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(MnII) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.0878 0 m
.0878 .18 L
s
gsave
.0878 .21 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(FeIII) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25624 0 m
.25624 .18 L
s
gsave
.25624 .24 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(SI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25888 0 m
.25888 .18 L
s
gsave
.25888 .27 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(SI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.26354 0 m
.26354 .18 L
s
gsave
.26354 .18 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(SI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.3132 0 m
.3132 .18 L
s
gsave
.3132 .21 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(FeIII) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.46752 0 m
.46752 .18 L
s
gsave
.46752 .24 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(DI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.46788 0 m
.46788 .18 L
s
gsave
.46788 .27 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(DI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.4686 0 m
.4686 .18 L
s
gsave
.4686 .18 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(DI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.53366 0 m
.53366 .18 L
s
gsave
.53366 .21 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(HI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.53402 0 m
.53402 .18 L
s
gsave
.53402 .24 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(HI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.53474 0 m
.53474 .18 L
s
gsave
.53474 .27 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(HI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.9686 0 m
.9686 .18 L
s
gsave
.9686 .18 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(PI) show
75.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.60.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.60.1"]
}, Open  ]],

Cell["Here is the absorption map of Hydrogen. ", "MathCaption",
 CellTags->{"S5.60.1", "1.10"}],

Cell[CellGroupData[{

Cell["ElementAbsorptionMap[Hydrogen]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.60.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.90257 0.00319063 0.00714286 0.285714 [
[.12852 -0.0125 -9 -9 ]
[.12852 -0.0125 9 0 ]
[.28806 -0.0125 -12 -9 ]
[.28806 -0.0125 12 0 ]
[.44759 -0.0125 -12 -9 ]
[.44759 -0.0125 12 0 ]
[.60712 -0.0125 -12 -9 ]
[.60712 -0.0125 12 0 ]
[.76665 -0.0125 -12 -9 ]
[.76665 -0.0125 12 0 ]
[.92618 -0.0125 -12 -9 ]
[.92618 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .3 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .3 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12852 0 m
.12852 .00625 L
s
[(950)] .12852 -0.0125 0 1 Mshowa
.28806 0 m
.28806 .00625 L
s
[(1000)] .28806 -0.0125 0 1 Mshowa
.44759 0 m
.44759 .00625 L
s
[(1050)] .44759 -0.0125 0 1 Mshowa
.60712 0 m
.60712 .00625 L
s
[(1100)] .60712 -0.0125 0 1 Mshowa
.76665 0 m
.76665 .00625 L
s
[(1150)] .76665 -0.0125 0 1 Mshowa
.92618 0 m
.92618 .00625 L
s
[(1200)] .92618 -0.0125 0 1 Mshowa
.125 Mabswid
.16043 0 m
.16043 .00375 L
s
.19234 0 m
.19234 .00375 L
s
.22424 0 m
.22424 .00375 L
s
.25615 0 m
.25615 .00375 L
s
.31996 0 m
.31996 .00375 L
s
.35187 0 m
.35187 .00375 L
s
.38377 0 m
.38377 .00375 L
s
.41568 0 m
.41568 .00375 L
s
.47949 0 m
.47949 .00375 L
s
.5114 0 m
.5114 .00375 L
s
.54331 0 m
.54331 .00375 L
s
.57521 0 m
.57521 .00375 L
s
.63902 0 m
.63902 .00375 L
s
.67093 0 m
.67093 .00375 L
s
.70284 0 m
.70284 .00375 L
s
.73474 0 m
.73474 .00375 L
s
.79856 0 m
.79856 .00375 L
s
.83046 0 m
.83046 .00375 L
s
.86237 0 m
.86237 .00375 L
s
.89428 0 m
.89428 .00375 L
s
.09662 0 m
.09662 .00375 L
s
.06471 0 m
.06471 .00375 L
s
.03281 0 m
.03281 .00375 L
s
.0009 0 m
.0009 .00375 L
s
.95809 0 m
.95809 .00375 L
s
.98999 0 m
.98999 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 0 m
0 .3 L
s
.12852 .29375 m
.12852 .3 L
s
.28806 .29375 m
.28806 .3 L
s
.44759 .29375 m
.44759 .3 L
s
.60712 .29375 m
.60712 .3 L
s
.76665 .29375 m
.76665 .3 L
s
.92618 .29375 m
.92618 .3 L
s
.125 Mabswid
.16043 .29625 m
.16043 .3 L
s
.19234 .29625 m
.19234 .3 L
s
.22424 .29625 m
.22424 .3 L
s
.25615 .29625 m
.25615 .3 L
s
.31996 .29625 m
.31996 .3 L
s
.35187 .29625 m
.35187 .3 L
s
.38377 .29625 m
.38377 .3 L
s
.41568 .29625 m
.41568 .3 L
s
.47949 .29625 m
.47949 .3 L
s
.5114 .29625 m
.5114 .3 L
s
.54331 .29625 m
.54331 .3 L
s
.57521 .29625 m
.57521 .3 L
s
.63902 .29625 m
.63902 .3 L
s
.67093 .29625 m
.67093 .3 L
s
.70284 .29625 m
.70284 .3 L
s
.73474 .29625 m
.73474 .3 L
s
.79856 .29625 m
.79856 .3 L
s
.83046 .29625 m
.83046 .3 L
s
.86237 .29625 m
.86237 .3 L
s
.89428 .29625 m
.89428 .3 L
s
.09662 .29625 m
.09662 .3 L
s
.06471 .29625 m
.06471 .3 L
s
.03281 .29625 m
.03281 .3 L
s
.0009 .29625 m
.0009 .3 L
s
.95809 .29625 m
.95809 .3 L
s
.98999 .29625 m
.98999 .3 L
s
.25 Mabswid
0 .3 m
1 .3 L
s
1 0 m
1 .3 L
s
0 0 m
1 0 L
1 .3 L
0 .3 L
closepath
clip
newpath
0 w
.97618 .00714 m
.97618 .29286 L
s
.97619 .00714 m
.97619 .29286 L
s
.97617 .00714 m
.97617 .29286 L
s
.37013 .00714 m
.37013 .29286 L
s
.37013 .00714 m
.37013 .29286 L
s
.37012 .00714 m
.37012 .29286 L
s
.20043 .00714 m
.20043 .29286 L
s
.20043 .00714 m
.20043 .29286 L
s
.20043 .00714 m
.20043 .29286 L
s
.1277 .00714 m
.1277 .29286 L
s
.08961 .00714 m
.08961 .29286 L
s
.0671 .00714 m
.0671 .29286 L
s
.05267 .00714 m
.05267 .29286 L
s
.04286 .00714 m
.04286 .29286 L
s
.03588 .00714 m
.03588 .29286 L
s
.03074 .00714 m
.03074 .29286 L
s
.02684 .00714 m
.02684 .29286 L
s
.02381 .00714 m
.02381 .29286 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.60.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.60.1"]
}, Open  ]],

Cell["You can zoom in on a particular area of the spectrum. ", "MathCaption",
 CellTags->{"S5.60.1", "1.11"}],

Cell[CellGroupData[{

Cell["ElementAbsorptionMap[Hydrogen, PlotRange->{{915, 950}, All}]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.60.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-26.1429 0.0285714 0.00714286 0.285714 [
[.14286 -0.0125 -9 -9 ]
[.14286 -0.0125 9 0 ]
[.28571 -0.0125 -9 -9 ]
[.28571 -0.0125 9 0 ]
[.42857 -0.0125 -9 -9 ]
[.42857 -0.0125 9 0 ]
[.57143 -0.0125 -9 -9 ]
[.57143 -0.0125 9 0 ]
[.71429 -0.0125 -9 -9 ]
[.71429 -0.0125 9 0 ]
[.85714 -0.0125 -9 -9 ]
[.85714 -0.0125 9 0 ]
[1 -0.0125 -9 -9 ]
[1 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .3 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .3 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.14286 0 m
.14286 .00625 L
s
[(920)] .14286 -0.0125 0 1 Mshowa
.28571 0 m
.28571 .00625 L
s
[(925)] .28571 -0.0125 0 1 Mshowa
.42857 0 m
.42857 .00625 L
s
[(930)] .42857 -0.0125 0 1 Mshowa
.57143 0 m
.57143 .00625 L
s
[(935)] .57143 -0.0125 0 1 Mshowa
.71429 0 m
.71429 .00625 L
s
[(940)] .71429 -0.0125 0 1 Mshowa
.85714 0 m
.85714 .00625 L
s
[(945)] .85714 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(950)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.02857 0 m
.02857 .00375 L
s
.05714 0 m
.05714 .00375 L
s
.08571 0 m
.08571 .00375 L
s
.11429 0 m
.11429 .00375 L
s
.17143 0 m
.17143 .00375 L
s
.2 0 m
.2 .00375 L
s
.22857 0 m
.22857 .00375 L
s
.25714 0 m
.25714 .00375 L
s
.31429 0 m
.31429 .00375 L
s
.34286 0 m
.34286 .00375 L
s
.37143 0 m
.37143 .00375 L
s
.4 0 m
.4 .00375 L
s
.45714 0 m
.45714 .00375 L
s
.48571 0 m
.48571 .00375 L
s
.51429 0 m
.51429 .00375 L
s
.54286 0 m
.54286 .00375 L
s
.6 0 m
.6 .00375 L
s
.62857 0 m
.62857 .00375 L
s
.65714 0 m
.65714 .00375 L
s
.68571 0 m
.68571 .00375 L
s
.74286 0 m
.74286 .00375 L
s
.77143 0 m
.77143 .00375 L
s
.8 0 m
.8 .00375 L
s
.82857 0 m
.82857 .00375 L
s
.88571 0 m
.88571 .00375 L
s
.91429 0 m
.91429 .00375 L
s
.94286 0 m
.94286 .00375 L
s
.97143 0 m
.97143 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 0 m
0 .3 L
s
0 .29375 m
0 .3 L
s
.14286 .29375 m
.14286 .3 L
s
.28571 .29375 m
.28571 .3 L
s
.42857 .29375 m
.42857 .3 L
s
.57143 .29375 m
.57143 .3 L
s
.71429 .29375 m
.71429 .3 L
s
.85714 .29375 m
.85714 .3 L
s
.125 Mabswid
.02857 .29625 m
.02857 .3 L
s
.05714 .29625 m
.05714 .3 L
s
.08571 .29625 m
.08571 .3 L
s
.11429 .29625 m
.11429 .3 L
s
.17143 .29625 m
.17143 .3 L
s
.2 .29625 m
.2 .3 L
s
.22857 .29625 m
.22857 .3 L
s
.25714 .29625 m
.25714 .3 L
s
.31429 .29625 m
.31429 .3 L
s
.34286 .29625 m
.34286 .3 L
s
.37143 .29625 m
.37143 .3 L
s
.4 .29625 m
.4 .3 L
s
.45714 .29625 m
.45714 .3 L
s
.48571 .29625 m
.48571 .3 L
s
.51429 .29625 m
.51429 .3 L
s
.54286 .29625 m
.54286 .3 L
s
.6 .29625 m
.6 .3 L
s
.62857 .29625 m
.62857 .3 L
s
.65714 .29625 m
.65714 .3 L
s
.68571 .29625 m
.68571 .3 L
s
.74286 .29625 m
.74286 .3 L
s
.77143 .29625 m
.77143 .3 L
s
.8 .29625 m
.8 .3 L
s
.82857 .29625 m
.82857 .3 L
s
.88571 .29625 m
.88571 .3 L
s
.91429 .29625 m
.91429 .3 L
s
.94286 .29625 m
.94286 .3 L
s
.97143 .29625 m
.97143 .3 L
s
.25 Mabswid
0 .3 m
1 .3 L
s
1 0 m
1 .3 L
s
0 0 m
1 0 L
1 .3 L
0 .3 L
closepath
clip
newpath
0 w
.99266 .00714 m
.99266 .29286 L
s
.65153 .00714 m
.65153 .29286 L
s
.44995 .00714 m
.44995 .29286 L
s
.32073 .00714 m
.32073 .29286 L
s
.23287 .00714 m
.23287 .29286 L
s
.17037 .00714 m
.17037 .29286 L
s
.12433 .00714 m
.12433 .29286 L
s
.08941 .00714 m
.08941 .29286 L
s
.0623 .00714 m
.0623 .29286 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.60.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.60.1"]
}, Open  ]],

Cell["\<\
Here is the absorption map of Carbon at the ionization level I. \
\>", "MathCaption",
 CellTags->{"S5.60.1", "1.12"}],

Cell[CellGroupData[{

Cell["ElementAbsorptionMap[Carbon, \"I\"]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.60.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.74185 0.00250668 0.00714286 0.285714 [
[.0155 -0.0125 -12 -9 ]
[.0155 -0.0125 12 0 ]
[.14083 -0.0125 -12 -9 ]
[.14083 -0.0125 12 0 ]
[.26617 -0.0125 -12 -9 ]
[.26617 -0.0125 12 0 ]
[.3915 -0.0125 -12 -9 ]
[.3915 -0.0125 12 0 ]
[.51683 -0.0125 -12 -9 ]
[.51683 -0.0125 12 0 ]
[.64217 -0.0125 -12 -9 ]
[.64217 -0.0125 12 0 ]
[.7675 -0.0125 -12 -9 ]
[.7675 -0.0125 12 0 ]
[.89284 -0.0125 -12 -9 ]
[.89284 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .3 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .3 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0155 0 m
.0155 .00625 L
s
[(1100)] .0155 -0.0125 0 1 Mshowa
.14083 0 m
.14083 .00625 L
s
[(1150)] .14083 -0.0125 0 1 Mshowa
.26617 0 m
.26617 .00625 L
s
[(1200)] .26617 -0.0125 0 1 Mshowa
.3915 0 m
.3915 .00625 L
s
[(1250)] .3915 -0.0125 0 1 Mshowa
.51683 0 m
.51683 .00625 L
s
[(1300)] .51683 -0.0125 0 1 Mshowa
.64217 0 m
.64217 .00625 L
s
[(1350)] .64217 -0.0125 0 1 Mshowa
.7675 0 m
.7675 .00625 L
s
[(1400)] .7675 -0.0125 0 1 Mshowa
.89284 0 m
.89284 .00625 L
s
[(1450)] .89284 -0.0125 0 1 Mshowa
.125 Mabswid
.04056 0 m
.04056 .00375 L
s
.06563 0 m
.06563 .00375 L
s
.0907 0 m
.0907 .00375 L
s
.11576 0 m
.11576 .00375 L
s
.1659 0 m
.1659 .00375 L
s
.19097 0 m
.19097 .00375 L
s
.21603 0 m
.21603 .00375 L
s
.2411 0 m
.2411 .00375 L
s
.29123 0 m
.29123 .00375 L
s
.3163 0 m
.3163 .00375 L
s
.34137 0 m
.34137 .00375 L
s
.36643 0 m
.36643 .00375 L
s
.41657 0 m
.41657 .00375 L
s
.44163 0 m
.44163 .00375 L
s
.4667 0 m
.4667 .00375 L
s
.49177 0 m
.49177 .00375 L
s
.5419 0 m
.5419 .00375 L
s
.56697 0 m
.56697 .00375 L
s
.59203 0 m
.59203 .00375 L
s
.6171 0 m
.6171 .00375 L
s
.66723 0 m
.66723 .00375 L
s
.6923 0 m
.6923 .00375 L
s
.71737 0 m
.71737 .00375 L
s
.74243 0 m
.74243 .00375 L
s
.79257 0 m
.79257 .00375 L
s
.81764 0 m
.81764 .00375 L
s
.8427 0 m
.8427 .00375 L
s
.86777 0 m
.86777 .00375 L
s
.9179 0 m
.9179 .00375 L
s
.94297 0 m
.94297 .00375 L
s
.96804 0 m
.96804 .00375 L
s
.9931 0 m
.9931 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 0 m
0 .3 L
s
.0155 .29375 m
.0155 .3 L
s
.14083 .29375 m
.14083 .3 L
s
.26617 .29375 m
.26617 .3 L
s
.3915 .29375 m
.3915 .3 L
s
.51683 .29375 m
.51683 .3 L
s
.64217 .29375 m
.64217 .3 L
s
.7675 .29375 m
.7675 .3 L
s
.89284 .29375 m
.89284 .3 L
s
.125 Mabswid
.04056 .29625 m
.04056 .3 L
s
.06563 .29625 m
.06563 .3 L
s
.0907 .29625 m
.0907 .3 L
s
.11576 .29625 m
.11576 .3 L
s
.1659 .29625 m
.1659 .3 L
s
.19097 .29625 m
.19097 .3 L
s
.21603 .29625 m
.21603 .3 L
s
.2411 .29625 m
.2411 .3 L
s
.29123 .29625 m
.29123 .3 L
s
.3163 .29625 m
.3163 .3 L
s
.34137 .29625 m
.34137 .3 L
s
.36643 .29625 m
.36643 .3 L
s
.41657 .29625 m
.41657 .3 L
s
.44163 .29625 m
.44163 .3 L
s
.4667 .29625 m
.4667 .3 L
s
.49177 .29625 m
.49177 .3 L
s
.5419 .29625 m
.5419 .3 L
s
.56697 .29625 m
.56697 .3 L
s
.59203 .29625 m
.59203 .3 L
s
.6171 .29625 m
.6171 .3 L
s
.66723 .29625 m
.66723 .3 L
s
.6923 .29625 m
.6923 .3 L
s
.71737 .29625 m
.71737 .3 L
s
.74243 .29625 m
.74243 .3 L
s
.79257 .29625 m
.79257 .3 L
s
.81764 .29625 m
.81764 .3 L
s
.8427 .29625 m
.8427 .3 L
s
.86777 .29625 m
.86777 .3 L
s
.9179 .29625 m
.9179 .3 L
s
.94297 .29625 m
.94297 .3 L
s
.96804 .29625 m
.96804 .3 L
s
.9931 .29625 m
.9931 .3 L
s
.25 Mabswid
0 .3 m
1 .3 L
s
1 0 m
1 .3 L
s
0 0 m
1 0 L
1 .3 L
0 .3 L
closepath
clip
newpath
0 w
.59038 .00714 m
.59038 .29286 L
s
.59103 .00714 m
.59103 .29286 L
s
.59097 .00714 m
.59097 .29286 L
s
.58984 .00714 m
.58984 .29286 L
s
.58978 .00714 m
.58978 .29286 L
s
.58974 .00714 m
.58974 .29286 L
s
.58911 .00714 m
.58911 .29286 L
s
.48689 .00714 m
.48689 .29286 L
s
.48577 .00714 m
.48577 .29286 L
s
.46759 .00714 m
.46759 .29286 L
s
.46882 .00714 m
.46882 .29286 L
s
.4682 .00714 m
.4682 .29286 L
s
.46771 .00714 m
.46771 .29286 L
s
.46753 .00714 m
.46753 .29286 L
s
.46704 .00714 m
.46704 .29286 L
s
.46643 .00714 m
.46643 .29286 L
s
.46544 .00714 m
.46544 .29286 L
s
.46477 .00714 m
.46477 .29286 L
s
.46433 .00714 m
.46433 .29286 L
s
.46034 .00714 m
.46034 .29286 L
s
.46157 .00714 m
.46157 .29286 L
s
.46099 .00714 m
.46099 .29286 L
s
.46056 .00714 m
.46056 .29286 L
s
.46047 .00714 m
.46047 .29286 L
s
.45989 .00714 m
.45989 .29286 L
s
.4598 .00714 m
.4598 .29286 L
s
.45966 .00714 m
.45966 .29286 L
s
.45855 .00714 m
.45855 .29286 L
s
.45788 .00714 m
.45788 .29286 L
s
.45193 .00714 m
.45193 .29286 L
s
.44375 .00714 m
.44375 .29286 L
s
.44266 .00714 m
.44266 .29286 L
s
.44199 .00714 m
.44199 .29286 L
s
.41975 .00714 m
.41975 .29286 L
s
.42046 .00714 m
.42046 .29286 L
s
.42014 .00714 m
.42014 .29286 L
s
.41938 .00714 m
.41938 .29286 L
s
.41906 .00714 m
.41906 .29286 L
s
.41889 .00714 m
.41889 .29286 L
s
.41841 .00714 m
.41841 .29286 L
s
.26181 .00714 m
.26181 .29286 L
s
.26084 .00714 m
.26084 .29286 L
s
.25145 .00714 m
.25145 .29286 L
s
.25267 .00714 m
.25267 .29286 L
s
.25214 .00714 m
.25214 .29286 L
s
.2517 .00714 m
.2517 .29286 L
s
.25128 .00714 m
.25128 .29286 L
s
.25111 .00714 m
.25111 .29286 L
s
.25032 .00714 m
.25032 .29286 L
s
.25285 .00714 m
.25285 .29286 L
s
.25235 .00714 m
.25235 .29286 L
s
.25188 .00714 m
.25188 .29286 L
s
.24906 .00714 m
.24906 .29286 L
s
.25025 .00714 m
.25025 .29286 L
s
.2496 .00714 m
.2496 .29286 L
s
.24928 .00714 m
.24928 .29286 L
s
.24922 .00714 m
.24922 .29286 L
s
.2487 .00714 m
.2487 .29286 L
s
.24864 .00714 m
.24864 .29286 L
s
.2482 .00714 m
.2482 .29286 L
s
.24724 .00714 m
.24724 .29286 L
s
.24666 .00714 m
.24666 .29286 L
s
.24571 .00714 m
.24571 .29286 L
s
.24269 .00714 m
.24269 .29286 L
s
.24173 .00714 m
.24173 .29286 L
s
.24115 .00714 m
.24115 .29286 L
s
.23946 .00714 m
.23946 .29286 L
s
.24017 .00714 m
.24017 .29286 L
s
.23971 .00714 m
.23971 .29286 L
s
.23922 .00714 m
.23922 .29286 L
s
.23875 .00714 m
.23875 .29286 L
s
.23857 .00714 m
.23857 .29286 L
s
.23817 .00714 m
.23817 .29286 L
s
.1681 .00714 m
.1681 .29286 L
s
.16718 .00714 m
.16718 .29286 L
s
.16363 .00714 m
.16363 .29286 L
s
.16331 .00714 m
.16331 .29286 L
s
.16272 .00714 m
.16272 .29286 L
s
.16202 .00714 m
.16202 .29286 L
s
.16316 .00714 m
.16316 .29286 L
s
.16257 .00714 m
.16257 .29286 L
s
.16225 .00714 m
.16225 .29286 L
s
.16188 .00714 m
.16188 .29286 L
s
.1617 .00714 m
.1617 .29286 L
s
.16097 .00714 m
.16097 .29286 L
s
.1608 .00714 m
.1608 .29286 L
s
.16212 .00714 m
.16212 .29286 L
s
.16121 .00714 m
.16121 .29286 L
s
.16121 .00714 m
.16121 .29286 L
s
.16093 .00714 m
.16093 .29286 L
s
.16066 .00714 m
.16066 .29286 L
s
.16031 .00714 m
.16031 .29286 L
s
.1603 .00714 m
.1603 .29286 L
s
.15939 .00714 m
.15939 .29286 L
s
.15884 .00714 m
.15884 .29286 L
s
.15921 .00714 m
.15921 .29286 L
s
.15779 .00714 m
.15779 .29286 L
s
.15688 .00714 m
.15688 .29286 L
s
.15633 .00714 m
.15633 .29286 L
s
.15661 .00714 m
.15661 .29286 L
s
.15728 .00714 m
.15728 .29286 L
s
.15685 .00714 m
.15685 .29286 L
s
.15637 .00714 m
.15637 .29286 L
s
.15594 .00714 m
.15594 .29286 L
s
.15582 .00714 m
.15582 .29286 L
s
.15539 .00714 m
.15539 .29286 L
s
.11997 .00714 m
.11997 .29286 L
s
.11909 .00714 m
.11909 .29286 L
s
.11754 .00714 m
.11754 .29286 L
s
.11737 .00714 m
.11737 .29286 L
s
.11666 .00714 m
.11666 .29286 L
s
.11614 .00714 m
.11614 .29286 L
s
.1172 .00714 m
.1172 .29286 L
s
.11656 .00714 m
.11656 .29286 L
s
.11632 .00714 m
.11632 .29286 L
s
.11606 .00714 m
.11606 .29286 L
s
.11579 .00714 m
.11579 .29286 L
s
.11518 .00714 m
.11518 .29286 L
s
.11516 .00714 m
.11516 .29286 L
s
.11666 .00714 m
.11666 .29286 L
s
.11578 .00714 m
.11578 .29286 L
s
.11543 .00714 m
.11543 .29286 L
s
.11529 .00714 m
.11529 .29286 L
s
.11525 .00714 m
.11525 .29286 L
s
.11455 .00714 m
.11455 .29286 L
s
.11489 .00714 m
.11489 .29286 L
s
.11401 .00714 m
.11401 .29286 L
s
.11348 .00714 m
.11348 .29286 L
s
.11432 .00714 m
.11432 .29286 L
s
.11357 .00714 m
.11357 .29286 L
s
.11269 .00714 m
.11269 .29286 L
s
.11216 .00714 m
.11216 .29286 L
s
.11287 .00714 m
.11287 .29286 L
s
.11349 .00714 m
.11349 .29286 L
s
.11313 .00714 m
.11313 .29286 L
s
.11261 .00714 m
.11261 .29286 L
s
.11225 .00714 m
.11225 .29286 L
s
.11215 .00714 m
.11215 .29286 L
s
.11171 .00714 m
.11171 .29286 L
s
.09199 .00714 m
.09199 .29286 L
s
.09113 .00714 m
.09113 .29286 L
s
.09062 .00714 m
.09062 .29286 L
s
.09051 .00714 m
.09051 .29286 L
s
.08976 .00714 m
.08976 .29286 L
s
.08933 .00714 m
.08933 .29286 L
s
.09037 .00714 m
.09037 .29286 L
s
.08968 .00714 m
.08968 .29286 L
s
.08951 .00714 m
.08951 .29286 L
s
.08925 .00714 m
.08925 .29286 L
s
.08899 .00714 m
.08899 .29286 L
s
.08839 .00714 m
.08839 .29286 L
s
.08842 .00714 m
.08842 .29286 L
s
.09006 .00714 m
.09006 .29286 L
s
.0892 .00714 m
.0892 .29286 L
s
.08867 .00714 m
.08867 .29286 L
s
.08859 .00714 m
.08859 .29286 L
s
.08854 .00714 m
.08854 .29286 L
s
.08773 .00714 m
.08773 .29286 L
s
.08827 .00714 m
.08827 .29286 L
s
.0874 .00714 m
.0874 .29286 L
s
.08688 .00714 m
.08688 .29286 L
s
.08795 .00714 m
.08795 .29286 L
s
.08698 .00714 m
.08698 .29286 L
s
.08757 .00714 m
.08757 .29286 L
s
.08727 .00714 m
.08727 .29286 L
s
.08671 .00714 m
.08671 .29286 L
s
.0864 .00714 m
.0864 .29286 L
s
.08632 .00714 m
.08632 .29286 L
s
.08588 .00714 m
.08588 .29286 L
s
.0875 .00714 m
.0875 .29286 L
s
.08664 .00714 m
.08664 .29286 L
s
.08611 .00714 m
.08611 .29286 L
s
.0743 .00714 m
.0743 .29286 L
s
.07345 .00714 m
.07345 .29286 L
s
.07349 .00714 m
.07349 .29286 L
s
.07341 .00714 m
.07341 .29286 L
s
.07263 .00714 m
.07263 .29286 L
s
.07227 .00714 m
.07227 .29286 L
s
.07331 .00714 m
.07331 .29286 L
s
.07258 .00714 m
.07258 .29286 L
s
.07246 .00714 m
.07246 .29286 L
s
.0722 .00714 m
.0722 .29286 L
s
.07194 .00714 m
.07194 .29286 L
s
.07135 .00714 m
.07135 .29286 L
s
.07138 .00714 m
.07138 .29286 L
s
.07311 .00714 m
.07311 .29286 L
s
.07226 .00714 m
.07226 .29286 L
s
.07174 .00714 m
.07174 .29286 L
s
.07151 .00714 m
.07151 .29286 L
s
.07148 .00714 m
.07148 .29286 L
s
.07065 .00714 m
.07065 .29286 L
s
.07129 .00714 m
.07129 .29286 L
s
.07044 .00714 m
.07044 .29286 L
s
.06993 .00714 m
.06993 .29286 L
s
.07109 .00714 m
.07109 .29286 L
s
.07034 .00714 m
.07034 .29286 L
s
.07089 .00714 m
.07089 .29286 L
s
.07064 .00714 m
.07064 .29286 L
s
.07004 .00714 m
.07004 .29286 L
s
.06979 .00714 m
.06979 .29286 L
s
.06974 .00714 m
.06974 .29286 L
s
.06927 .00714 m
.06927 .29286 L
s
.07081 .00714 m
.07081 .29286 L
s
.06996 .00714 m
.06996 .29286 L
s
.06944 .00714 m
.06944 .29286 L
s
.06242 .00714 m
.06242 .29286 L
s
.06157 .00714 m
.06157 .29286 L
s
.06192 .00714 m
.06192 .29286 L
s
.06185 .00714 m
.06185 .29286 L
s
.06107 .00714 m
.06107 .29286 L
s
.06075 .00714 m
.06075 .29286 L
s
.06178 .00714 m
.06178 .29286 L
s
.06099 .00714 m
.06099 .29286 L
s
.06093 .00714 m
.06093 .29286 L
s
.06069 .00714 m
.06069 .29286 L
s
.06042 .00714 m
.06042 .29286 L
s
.05984 .00714 m
.05984 .29286 L
s
.05984 .00714 m
.05984 .29286 L
s
.06164 .00714 m
.06164 .29286 L
s
.06079 .00714 m
.06079 .29286 L
s
.06028 .00714 m
.06028 .29286 L
s
.05994 .00714 m
.05994 .29286 L
s
.05993 .00714 m
.05993 .29286 L
s
.0591 .00714 m
.0591 .29286 L
s
.0598 .00714 m
.0598 .29286 L
s
.05896 .00714 m
.05896 .29286 L
s
.05844 .00714 m
.05844 .29286 L
s
.05967 .00714 m
.05967 .29286 L
s
.05957 .00714 m
.05957 .29286 L
s
.05872 .00714 m
.05872 .29286 L
s
.05947 .00714 m
.05947 .29286 L
s
.05862 .00714 m
.05862 .29286 L
s
.06037 .00714 m
.06037 .29286 L
s
.05366 .00714 m
.05366 .29286 L
s
.05167 .00714 m
.05167 .29286 L
s
.05352 .00714 m
.05352 .29286 L
s
.05268 .00714 m
.05268 .29286 L
s
.05217 .00714 m
.05217 .29286 L
s
.05175 .00714 m
.05175 .29286 L
s
.05174 .00714 m
.05174 .29286 L
s
.05091 .00714 m
.05091 .29286 L
s
.05154 .00714 m
.05154 .29286 L
s
.05142 .00714 m
.05142 .29286 L
s
.05058 .00714 m
.05058 .29286 L
s
.05007 .00714 m
.05007 .29286 L
s
.04765 .00714 m
.04765 .29286 L
s
.04567 .00714 m
.04567 .29286 L
s
.0476 .00714 m
.0476 .29286 L
s
.04676 .00714 m
.04676 .29286 L
s
.04625 .00714 m
.04625 .29286 L
s
.04573 .00714 m
.04573 .29286 L
s
.04572 .00714 m
.04572 .29286 L
s
.04489 .00714 m
.04489 .29286 L
s
.04547 .00714 m
.04547 .29286 L
s
.04464 .00714 m
.04464 .29286 L
s
.04413 .00714 m
.04413 .29286 L
s
.04167 .00714 m
.04167 .29286 L
s
.04109 .00714 m
.04109 .29286 L
s
.04026 .00714 m
.04026 .29286 L
s
.03975 .00714 m
.03975 .29286 L
s
.04099 .00714 m
.04099 .29286 L
s
.04015 .00714 m
.04015 .29286 L
s
.03965 .00714 m
.03965 .29286 L
s
.03947 .00714 m
.03947 .29286 L
s
.03864 .00714 m
.03864 .29286 L
s
.03814 .00714 m
.03814 .29286 L
s
.0376 .00714 m
.0376 .29286 L
s
.03676 .00714 m
.03676 .29286 L
s
.03626 .00714 m
.03626 .29286 L
s
.03754 .00714 m
.03754 .29286 L
s
.03671 .00714 m
.03671 .29286 L
s
.0362 .00714 m
.0362 .29286 L
s
.03666 .00714 m
.03666 .29286 L
s
.03582 .00714 m
.03582 .29286 L
s
.03532 .00714 m
.03532 .29286 L
s
.03475 .00714 m
.03475 .29286 L
s
.03391 .00714 m
.03391 .29286 L
s
.03341 .00714 m
.03341 .29286 L
s
.03315 .00714 m
.03315 .29286 L
s
.0325 .00714 m
.0325 .29286 L
s
.03167 .00714 m
.03167 .29286 L
s
.03116 .00714 m
.03116 .29286 L
s
.03133 .00714 m
.03133 .29286 L
s
.0307 .00714 m
.0307 .29286 L
s
.02987 .00714 m
.02987 .29286 L
s
.02936 .00714 m
.02936 .29286 L
s
.02886 .00714 m
.02886 .29286 L
s
.02921 .00714 m
.02921 .29286 L
s
.02839 .00714 m
.02839 .29286 L
s
.02789 .00714 m
.02789 .29286 L
s
.02792 .00714 m
.02792 .29286 L
s
.0271 .00714 m
.0271 .29286 L
s
.02659 .00714 m
.02659 .29286 L
s
.02683 .00714 m
.02683 .29286 L
s
.026 .00714 m
.026 .29286 L
s
.0255 .00714 m
.0255 .29286 L
s
.02592 .00714 m
.02592 .29286 L
s
.02509 .00714 m
.02509 .29286 L
s
.02459 .00714 m
.02459 .29286 L
s
.02514 .00714 m
.02514 .29286 L
s
.02431 .00714 m
.02431 .29286 L
s
.02381 .00714 m
.02381 .29286 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.60.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.60.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.60.1"->{
    Cell[1776, 53, 154, 6, 36, "Subsection",
      CellTags->{"S5.60.1", "1.1"}],
    Cell[1933, 61, 347, 7, 56, "Text",
      CellTags->{"S5.60.1", "1.2"}],
    Cell[2283, 70, 1760, 54, 64, "DefinitionBox",
      CellTags->"S5.60.1"],
    Cell[4046, 126, 81, 1, 15, "Caption",
      CellTags->"S5.60.1"],
    Cell[4130, 129, 78, 1, 40, "MathCaption",
      CellTags->{"S5.60.1", "1.3"}],
    Cell[4211, 132, 104, 2, 28, "Input",
      CellTags->"S5.60.1"],
    Cell[4318, 136, 171, 4, 56, "MathCaption",
      CellTags->{"S5.60.1", "1.4"}],
    Cell[4514, 144, 101, 2, 28, "Input",
      CellTags->"S5.60.1"],
    Cell[4618, 148, 1984, 49, 201, "Output",
      CellTags->"S5.60.1"],
    Cell[6617, 200, 1693, 50, 94, "DefinitionBox",
      CellTags->"S5.60.1"],
    Cell[8313, 252, 83, 1, 70, "Caption",
      CellTags->"S5.60.1"],
    Cell[8399, 255, 985, 29, 70, "Text",
      CellTags->{"S5.60.1", "1.5"}],
    Cell[9387, 286, 15127, 473, 70, "DefinitionBox",
      CellTags->"S5.60.1"],
    Cell[24517, 761, 138, 4, 70, "Caption",
      CellTags->"S5.60.1"],
    Cell[24658, 767, 194, 4, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.6"}],
    Cell[24877, 775, 92, 2, 70, "Input",
      CellTags->"S5.60.1"],
    Cell[24972, 779, 967, 30, 70, "Output",
      CellTags->"S5.60.1"],
    Cell[25954, 812, 242, 5, 70, "Text",
      CellTags->{"S5.60.1", "1.7"}],
    Cell[26199, 819, 200, 4, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.8"}],
    Cell[26424, 827, 99, 2, 70, "Input",
      CellTags->"S5.60.1"],
    Cell[26526, 831, 316, 11, 70, "Output",
      CellTags->"S5.60.1"],
    Cell[26857, 845, 3391, 102, 70, "DefinitionBox",
      CellTags->"S5.60.1"],
    Cell[30251, 949, 58, 1, 70, "Caption",
      CellTags->"S5.60.1"],
    Cell[30312, 952, 148, 4, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.9"}],
    Cell[30485, 960, 116, 2, 70, "Input",
      CellTags->"S5.60.1"],
    Cell[30604, 964, 18907, 810, 70, 18836, 807, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.60.1"],
    Cell[49514, 1776, 180, 6, 70, "Output",
      CellTags->"S5.60.1"],
    Cell[49709, 1785, 95, 1, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.10"}],
    Cell[49829, 1790, 93, 2, 70, "Input",
      CellTags->"S5.60.1"],
    Cell[49925, 1794, 3847, 327, 70, 3776, 324, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.60.1"],
    Cell[53775, 2123, 180, 6, 70, "Output",
      CellTags->"S5.60.1"],
    Cell[53970, 2132, 109, 1, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.11"}],
    Cell[54104, 2137, 123, 2, 70, "Input",
      CellTags->"S5.60.1"],
    Cell[54230, 2141, 3693, 321, 70, 3622, 318, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.60.1"],
    Cell[57926, 2464, 180, 6, 70, "Output",
      CellTags->"S5.60.1"],
    Cell[58121, 2473, 127, 3, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.12"}],
    Cell[58273, 2480, 98, 2, 70, "Input",
      CellTags->"S5.60.1"],
    Cell[58374, 2484, 14035, 1233, 70, 13964, 1230, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.60.1"],
    Cell[72412, 3719, 180, 6, 70, "Output",
      CellTags->"S5.60.1"]},
  "1.1"->{
    Cell[1776, 53, 154, 6, 36, "Subsection",
      CellTags->{"S5.60.1", "1.1"}]},
  "1.2"->{
    Cell[1933, 61, 347, 7, 56, "Text",
      CellTags->{"S5.60.1", "1.2"}]},
  "1.3"->{
    Cell[4130, 129, 78, 1, 40, "MathCaption",
      CellTags->{"S5.60.1", "1.3"}]},
  "1.4"->{
    Cell[4318, 136, 171, 4, 56, "MathCaption",
      CellTags->{"S5.60.1", "1.4"}]},
  "1.5"->{
    Cell[8399, 255, 985, 29, 70, "Text",
      CellTags->{"S5.60.1", "1.5"}]},
  "1.6"->{
    Cell[24658, 767, 194, 4, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.6"}]},
  "1.7"->{
    Cell[25954, 812, 242, 5, 70, "Text",
      CellTags->{"S5.60.1", "1.7"}]},
  "1.8"->{
    Cell[26199, 819, 200, 4, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.8"}]},
  "1.9"->{
    Cell[30312, 952, 148, 4, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.9"}]},
  "1.10"->{
    Cell[49709, 1785, 95, 1, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.10"}]},
  "1.11"->{
    Cell[53970, 2132, 109, 1, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.11"}]},
  "1.12"->{
    Cell[58121, 2473, 127, 3, 70, "MathCaption",
      CellTags->{"S5.60.1", "1.12"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.60.1", 73243, 3745},
  {"1.1", 76532, 3832},
  {"1.2", 76626, 3835},
  {"1.3", 76714, 3838},
  {"1.4", 76809, 3841},
  {"1.5", 76905, 3844},
  {"1.6", 76995, 3847},
  {"1.7", 77092, 3850},
  {"1.8", 77182, 3853},
  {"1.9", 77279, 3856},
  {"1.10", 77377, 3859},
  {"1.11", 77476, 3862},
  {"1.12", 77576, 3865}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 154, 6, 36, "Subsection",
  CellTags->{"S5.60.1", "1.1"}],
Cell[1933, 61, 347, 7, 56, "Text",
  CellTags->{"S5.60.1", "1.2"}],
Cell[2283, 70, 1760, 54, 64, "DefinitionBox",
  CellTags->"S5.60.1"],
Cell[4046, 126, 81, 1, 15, "Caption",
  CellTags->"S5.60.1"],
Cell[4130, 129, 78, 1, 40, "MathCaption",
  CellTags->{"S5.60.1", "1.3"}],
Cell[4211, 132, 104, 2, 28, "Input",
  CellTags->"S5.60.1"],
Cell[4318, 136, 171, 4, 56, "MathCaption",
  CellTags->{"S5.60.1", "1.4"}],

Cell[CellGroupData[{
Cell[4514, 144, 101, 2, 28, "Input",
  CellTags->"S5.60.1"],
Cell[4618, 148, 1984, 49, 201, "Output",
  CellTags->"S5.60.1"]
}, Open  ]],
Cell[6617, 200, 1693, 50, 94, "DefinitionBox",
  CellTags->"S5.60.1"],
Cell[8313, 252, 83, 1, 70, "Caption",
  CellTags->"S5.60.1"],
Cell[8399, 255, 985, 29, 70, "Text",
  CellTags->{"S5.60.1", "1.5"}],
Cell[9387, 286, 15127, 473, 70, "DefinitionBox",
  CellTags->"S5.60.1"],
Cell[24517, 761, 138, 4, 70, "Caption",
  CellTags->"S5.60.1"],
Cell[24658, 767, 194, 4, 70, "MathCaption",
  CellTags->{"S5.60.1", "1.6"}],

Cell[CellGroupData[{
Cell[24877, 775, 92, 2, 70, "Input",
  CellTags->"S5.60.1"],
Cell[24972, 779, 967, 30, 70, "Output",
  CellTags->"S5.60.1"]
}, Open  ]],
Cell[25954, 812, 242, 5, 70, "Text",
  CellTags->{"S5.60.1", "1.7"}],
Cell[26199, 819, 200, 4, 70, "MathCaption",
  CellTags->{"S5.60.1", "1.8"}],

Cell[CellGroupData[{
Cell[26424, 827, 99, 2, 70, "Input",
  CellTags->"S5.60.1"],
Cell[26526, 831, 316, 11, 70, "Output",
  CellTags->"S5.60.1"]
}, Open  ]],
Cell[26857, 845, 3391, 102, 70, "DefinitionBox",
  CellTags->"S5.60.1"],
Cell[30251, 949, 58, 1, 70, "Caption",
  CellTags->"S5.60.1"],
Cell[30312, 952, 148, 4, 70, "MathCaption",
  CellTags->{"S5.60.1", "1.9"}],

Cell[CellGroupData[{
Cell[30485, 960, 116, 2, 70, "Input",
  CellTags->"S5.60.1"],
Cell[30604, 964, 18907, 810, 70, 18836, 807, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.60.1"],
Cell[49514, 1776, 180, 6, 70, "Output",
  CellTags->"S5.60.1"]
}, Open  ]],
Cell[49709, 1785, 95, 1, 70, "MathCaption",
  CellTags->{"S5.60.1", "1.10"}],

Cell[CellGroupData[{
Cell[49829, 1790, 93, 2, 70, "Input",
  CellTags->"S5.60.1"],
Cell[49925, 1794, 3847, 327, 70, 3776, 324, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.60.1"],
Cell[53775, 2123, 180, 6, 70, "Output",
  CellTags->"S5.60.1"]
}, Open  ]],
Cell[53970, 2132, 109, 1, 70, "MathCaption",
  CellTags->{"S5.60.1", "1.11"}],

Cell[CellGroupData[{
Cell[54104, 2137, 123, 2, 70, "Input",
  CellTags->"S5.60.1"],
Cell[54230, 2141, 3693, 321, 70, 3622, 318, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.60.1"],
Cell[57926, 2464, 180, 6, 70, "Output",
  CellTags->"S5.60.1"]
}, Open  ]],
Cell[58121, 2473, 127, 3, 70, "MathCaption",
  CellTags->{"S5.60.1", "1.12"}],

Cell[CellGroupData[{
Cell[58273, 2480, 98, 2, 70, "Input",
  CellTags->"S5.60.1"],
Cell[58374, 2484, 14035, 1233, 70, 13964, 1230, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.60.1"],
Cell[72412, 3719, 180, 6, 70, "Output",
  CellTags->"S5.60.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

