(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27658,        946]*)
(*NotebookOutlinePosition[     33270,       1117]*)
(*  CellTagsIndexPosition[     32782,       1094]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "RootIsolation",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.9.1", "1.1"}],

Cell["\<\
This package provides functions for counting and isolating roots of \
polynomials. \
\>", "Text",
 CellTags->{"S5.9.1", "1.2"}],

Cell[TextData[{
 "For complex numbers ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["m",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["m",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and a polynomial ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with Gaussian rational coefficients, the function ",
 StyleBox["CountRoots", "MR"],
 " gives the number of roots of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the interval ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["m",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["m",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 ", multiplicities counted. The interval ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["m",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["m",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 " means here the set of all complex ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " such that"
}], "Text",
 CellTags->{"S5.9.1", "1.3"}],

Cell["", "Text",
 CellTags->{"S5.9.1", "1.4"}],

Cell[BoxData[
 FormBox[Cell[BoxData[
   FormBox[GridBox[{
      {Cell[TextData[StyleBox[Cell[BoxData[
        FormBox[
         StyleBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"Re", 
             RowBox[{"[", 
              SubscriptBox[
               StyleBox["m",
                "TI"], "1"], "]"}], "<", "Re", 
             RowBox[{"[", 
              StyleBox["z",
               "TI"], "]"}], "<", "Re", 
             RowBox[{"[", 
              SubscriptBox[
               StyleBox["m",
                "TI"], "2"], "]"}], "  ", 
             RowBox[{"\[Vee]", "  "}], "Re", 
             RowBox[{"[", 
              SubscriptBox[
               StyleBox["m",
                "TI"], "1"], "]"}], "=", "Re", 
             RowBox[{"[", 
              StyleBox["z",
               "TI"], "]"}], "=", "Re", 
             RowBox[{"[", 
              SubscriptBox[
               StyleBox["m",
                "TI"], "2"], "]"}]}], ")"}], "    ", "\[Wedge]"}],
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]},
      {Cell[TextData[StyleBox[Cell[BoxData[
        FormBox[
         StyleBox[
          RowBox[{"(", 
           RowBox[{"Im", 
            RowBox[{"[", 
             SubscriptBox[
              StyleBox["m",
               "TI"], "1"], "]"}], "<", "Im", 
            RowBox[{"[", 
             StyleBox["z",
              "TI"], "]"}], "<", "Im", 
            RowBox[{"[", 
             SubscriptBox[
              StyleBox["m",
               "TI"], "2"], "]"}], "  ", 
            RowBox[{"\[Vee]", "  "}], "Im", 
            RowBox[{"[", 
             SubscriptBox[
              StyleBox["m",
               "TI"], "1"], "]"}], "=", "Im", 
            RowBox[{"[", 
             StyleBox["z",
              "TI"], "]"}], "=", "Im", 
            RowBox[{"[", 
             SubscriptBox[
              StyleBox["m",
               "TI"], "2"], "]"}]}], ")"}],
          "DisplayFormula"], TraditionalForm]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]],
        UnderoverscriptBoxOptions->{LimitsPositioning->True},
        GridBoxOptions->{ColumnWidths->Automatic}]}
      },
     ColumnAlignments->{Center}], TraditionalForm]],
   UnderoverscriptBoxOptions->{LimitsPositioning->True},
   GridBoxOptions->{ColumnWidths->Automatic}], 
  TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.9.1", "1.5"}],

Cell["\<\
which may be a point, a horizontal or vertical open interval, or an open \
rectangle. \
\>", "Text",
 CellTags->{"S5.9.1", "1.6"}],

Cell[TextData[{
 "An interval ",
 Cell[BoxData[
  FormBox[
   StyleBox["I",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is an ",
 StyleBox["isolating interval", "TB"],
 " for a root ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " of a polynomial ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", if ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the only root of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in ",
 Cell[BoxData[
  FormBox[
   StyleBox["I",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Isolating roots of a polynomial means finding disjoint isolating \
intervals for all the roots of the polynomial. The package defines functions \
for isolating roots of polynomials with rational coefficients. "
}], "Text",
 CellTags->{"S5.9.1", "1.7"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CountRoots[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the number of roots of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the complex interval ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["m",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "TR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RealRootIntervals[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give disjoint isolating intervals for the real roots of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RealRootIntervals[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give disjoint isolating intervals for the real roots of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ComplexRootIntervals[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give disjoint isolating intervals for the complex roots of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["poly", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ComplexRootIntervals[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give disjoint isolating intervals for the complex roots of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["poly",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ContractInterval[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give an isolating interval that bounds the value of the algebraic \
number ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" up to the precision of at least ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" decimal places ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.9.1"],

Cell["Functions for counting and isolating roots of polynomials. ", "Caption",
 CellTags->"S5.9.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.9.1", "1.8"}],

Cell["<<Algebra`RootIsolation`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.9.1"],

Cell[TextData[{
 "This counts roots of ",
 StyleBox["f", "MR"],
 " in the open interval (1, 2). "
}], "MathCaption",
 CellTags->{"S5.9.1", "1.9"}],

Cell[CellGroupData[{

Cell["f = (x^2 - 2) (x^2 - 3) (x^2 - 4); CountRoots[f, {x, 1, 2}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.9.1"],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.9.1"]
}, Open  ]],

Cell[TextData[{
 "The polynomial has two roots in the vertical interval as follows: a single \
root at ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and a triple root at 0. "
}], "MathCaption",
 CellTags->{"S5.9.1", "1.10"}],

Cell[CellGroupData[{

Cell["CountRoots[(x^2+1) x^3, {x, -I, 2 I}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.9.1"],

Cell[BoxData["4"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.9.1"]
}, Open  ]],

Cell[TextData[{
 "This counts 17",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degree roots of unity in the open unit square. "
}], "MathCaption",
 CellTags->{"S5.9.1", "1.11"}],

Cell[CellGroupData[{

Cell["CountRoots[x^17 - 1, {x, 0, 1 + I}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.9.1"],

Cell[BoxData["4"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.9.1"]
}, Open  ]],

Cell[TextData[{
 "Here are isolating intervals for the real roots of ",
 StyleBox["f", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.9.1", "1.12"}],

Cell[CellGroupData[{

Cell["RealRootIntervals[f]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.9.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["3", "2"]}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["3", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", "2"], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.9.1"]
}, Open  ]],

Cell["\<\
The second list shows which interval contains a root of which polynomial. \
\>", "MathCaption",
 CellTags->{"S5.9.1", "1.13"}],

Cell[CellGroupData[{

Cell["RealRootIntervals[{f + 3, f + 5, f + 7}]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.9.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["5", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["9", "8"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["9", "8"]}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["9", "8"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["9", "8"], ",", 
       FractionBox["5", "4"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "3", ",", "2", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.9.1"]
}, Open  ]],

Cell[TextData[{
 "This gives isolating intervals for all complex roots of ",
 StyleBox["f+3", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.9.1", "1.14"}],

Cell[CellGroupData[{

Cell["ComplexRootIntervals[f + 3]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.9.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7"}], "-", 
      RowBox[{"7", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"-", 
      FractionBox["7", "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "7"}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["7", "4"]}], "+", 
      RowBox[{"7", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["7", "4"]}], "-", 
      RowBox[{"7", " ", "\[ImaginaryI]"}]}], ",", 
     FractionBox["7", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["7", "4"]}], ",", 
     RowBox[{
      FractionBox["7", "2"], "+", 
      RowBox[{"7", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.9.1"]
}, Open  ]],

Cell["\<\
Here are isolating intervals for the third and fourth degree roots of unity. \
The second interval contains a root common to both polynomials. \
\>", "MathCaption",
 CellTags->{"S5.9.1", "1.15"}],

Cell[CellGroupData[{

Cell["ComplexRootIntervals[{x^3 - 1, x^4 - 1}]", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.9.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "4"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "4"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ",", 
       RowBox[{
        FractionBox["3", "8"], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}], ",", 
       RowBox[{
        FractionBox["3", "8"], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "1", ",", "1", ",", "2", ",", 
     "2"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.9.1"]
}, Open  ]],

Cell["\<\
Here is a small interval containing a tenth degree root of unity. \
\>", "MathCaption",
 CellTags->{"S5.9.1", "1.16"}],

Cell[CellGroupData[{

Cell["ContractInterval[Root[x^10 - 1, 5], 10]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.9.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["5308871539", "17179869184"]}], "-", 
    FractionBox[
     RowBox[{"65356106147", " ", "\[ImaginaryI]"}], "68719476736"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["21235486155", "68719476736"]}], "-", 
    FractionBox[
     RowBox[{"32678053073", " ", "\[ImaginaryI]"}], "34359738368"]}]}], 
  "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.9.1"]
}, Open  ]],

Cell["See how small the interval is. ", "MathCaption",
 CellTags->{"S5.9.1", "1.17"}],

Cell[CellGroupData[{

Cell["N[%, 20]", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.9.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.3090169943752698600292205810546875`19.64049736191343"}], 
    "-", 
    RowBox[{
    "0.951056516307289712131023406982421875`20.12872132337749", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{
    "-", "0.309016994360717944800853729248046875`19.640497361900945"}], "-", 
    RowBox[{
    "0.95105651629273779690265655517578125`20.12872132337881", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.9.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.9.1"->{
    Cell[1776, 53, 136, 6, 36, "Subsection",
      CellTags->{"S5.9.1", "1.1"}],
    Cell[1915, 61, 137, 4, 24, "Text",
      CellTags->{"S5.9.1", "1.2"}],
    Cell[2055, 67, 1863, 69, 56, "Text",
      CellTags->{"S5.9.1", "1.3"}],
    Cell[3921, 138, 46, 1, 24, "Text",
      CellTags->{"S5.9.1", "1.4"}],
    Cell[3970, 141, 2971, 81, 51, "DisplayFormula",
      CellTags->{"S5.9.1", "1.5"}],
    Cell[6944, 224, 140, 4, 24, "Text",
      CellTags->{"S5.9.1", "1.6"}],
    Cell[7087, 230, 1240, 43, 72, "Text",
      CellTags->{"S5.9.1", "1.7"}],
    Cell[8330, 275, 10525, 320, 258, "DefinitionBox",
      CellTags->"S5.9.1"],
    Cell[18858, 597, 99, 1, 15, "Caption",
      CellTags->"S5.9.1"],
    Cell[18960, 600, 77, 1, 40, "MathCaption",
      CellTags->{"S5.9.1", "1.8"}],
    Cell[19040, 603, 86, 2, 28, "Input",
      CellTags->"S5.9.1"],
    Cell[19129, 607, 146, 5, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.9"}],
    Cell[19300, 616, 121, 2, 70, "Input",
      CellTags->"S5.9.1"],
    Cell[19424, 620, 73, 2, 70, "Output",
      CellTags->"S5.9.1"],
    Cell[19512, 625, 329, 10, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.10"}],
    Cell[19866, 639, 99, 2, 70, "Input",
      CellTags->"S5.9.1"],
    Cell[19968, 643, 73, 2, 70, "Output",
      CellTags->"S5.9.1"],
    Cell[20056, 648, 280, 8, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.11"}],
    Cell[20361, 660, 97, 2, 70, "Input",
      CellTags->"S5.9.1"],
    Cell[20461, 664, 73, 2, 70, "Output",
      CellTags->"S5.9.1"],
    Cell[20549, 669, 149, 5, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.12"}],
    Cell[20723, 678, 82, 2, 70, "Input",
      CellTags->"S5.9.1"],
    Cell[20808, 682, 676, 26, 70, "Output",
      CellTags->"S5.9.1"],
    Cell[21499, 711, 136, 3, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.13"}],
    Cell[21660, 718, 102, 2, 70, "Input",
      CellTags->"S5.9.1"],
    Cell[21765, 722, 891, 32, 70, "Output",
      CellTags->"S5.9.1"],
    Cell[22671, 757, 156, 5, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.14"}],
    Cell[22852, 766, 89, 2, 70, "Input",
      CellTags->"S5.9.1"],
    Cell[22944, 770, 1034, 38, 70, "Output",
      CellTags->"S5.9.1"],
    Cell[23993, 811, 205, 4, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.15"}],
    Cell[24223, 819, 102, 2, 70, "Input",
      CellTags->"S5.9.1"],
    Cell[24328, 823, 1842, 62, 70, "Output",
      CellTags->"S5.9.1"],
    Cell[26185, 888, 128, 3, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.16"}],
    Cell[26338, 895, 101, 2, 70, "Input",
      CellTags->"S5.9.1"],
    Cell[26442, 899, 458, 15, 70, "Output",
      CellTags->"S5.9.1"],
    Cell[26915, 917, 85, 1, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.17"}],
    Cell[27025, 922, 71, 2, 70, "Input",
      CellTags->"S5.9.1"],
    Cell[27099, 926, 531, 16, 70, "Output",
      CellTags->"S5.9.1"]},
  "1.1"->{
    Cell[1776, 53, 136, 6, 36, "Subsection",
      CellTags->{"S5.9.1", "1.1"}]},
  "1.2"->{
    Cell[1915, 61, 137, 4, 24, "Text",
      CellTags->{"S5.9.1", "1.2"}]},
  "1.3"->{
    Cell[2055, 67, 1863, 69, 56, "Text",
      CellTags->{"S5.9.1", "1.3"}]},
  "1.4"->{
    Cell[3921, 138, 46, 1, 24, "Text",
      CellTags->{"S5.9.1", "1.4"}]},
  "1.5"->{
    Cell[3970, 141, 2971, 81, 51, "DisplayFormula",
      CellTags->{"S5.9.1", "1.5"}]},
  "1.6"->{
    Cell[6944, 224, 140, 4, 24, "Text",
      CellTags->{"S5.9.1", "1.6"}]},
  "1.7"->{
    Cell[7087, 230, 1240, 43, 72, "Text",
      CellTags->{"S5.9.1", "1.7"}]},
  "1.8"->{
    Cell[18960, 600, 77, 1, 40, "MathCaption",
      CellTags->{"S5.9.1", "1.8"}]},
  "1.9"->{
    Cell[19129, 607, 146, 5, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.9"}]},
  "1.10"->{
    Cell[19512, 625, 329, 10, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.10"}]},
  "1.11"->{
    Cell[20056, 648, 280, 8, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.11"}]},
  "1.12"->{
    Cell[20549, 669, 149, 5, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.12"}]},
  "1.13"->{
    Cell[21499, 711, 136, 3, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.13"}]},
  "1.14"->{
    Cell[22671, 757, 156, 5, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.14"}]},
  "1.15"->{
    Cell[23993, 811, 205, 4, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.15"}]},
  "1.16"->{
    Cell[26185, 888, 128, 3, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.16"}]},
  "1.17"->{
    Cell[26915, 917, 85, 1, 70, "MathCaption",
      CellTags->{"S5.9.1", "1.17"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.9.1", 28280, 962},
  {"1.1", 31159, 1039},
  {"1.2", 31252, 1042},
  {"1.3", 31339, 1045},
  {"1.4", 31428, 1048},
  {"1.5", 31515, 1051},
  {"1.6", 31615, 1054},
  {"1.7", 31703, 1057},
  {"1.8", 31793, 1060},
  {"1.9", 31888, 1063},
  {"1.10", 31985, 1066},
  {"1.11", 32084, 1069},
  {"1.12", 32182, 1072},
  {"1.13", 32280, 1075},
  {"1.14", 32378, 1078},
  {"1.15", 32476, 1081},
  {"1.16", 32574, 1084},
  {"1.17", 32672, 1087}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 136, 6, 36, "Subsection",
  CellTags->{"S5.9.1", "1.1"}],
Cell[1915, 61, 137, 4, 24, "Text",
  CellTags->{"S5.9.1", "1.2"}],
Cell[2055, 67, 1863, 69, 56, "Text",
  CellTags->{"S5.9.1", "1.3"}],
Cell[3921, 138, 46, 1, 24, "Text",
  CellTags->{"S5.9.1", "1.4"}],
Cell[3970, 141, 2971, 81, 51, "DisplayFormula",
  CellTags->{"S5.9.1", "1.5"}],
Cell[6944, 224, 140, 4, 24, "Text",
  CellTags->{"S5.9.1", "1.6"}],
Cell[7087, 230, 1240, 43, 72, "Text",
  CellTags->{"S5.9.1", "1.7"}],
Cell[8330, 275, 10525, 320, 258, "DefinitionBox",
  CellTags->"S5.9.1"],
Cell[18858, 597, 99, 1, 15, "Caption",
  CellTags->"S5.9.1"],
Cell[18960, 600, 77, 1, 40, "MathCaption",
  CellTags->{"S5.9.1", "1.8"}],
Cell[19040, 603, 86, 2, 28, "Input",
  CellTags->"S5.9.1"],
Cell[19129, 607, 146, 5, 70, "MathCaption",
  CellTags->{"S5.9.1", "1.9"}],

Cell[CellGroupData[{
Cell[19300, 616, 121, 2, 70, "Input",
  CellTags->"S5.9.1"],
Cell[19424, 620, 73, 2, 70, "Output",
  CellTags->"S5.9.1"]
}, Open  ]],
Cell[19512, 625, 329, 10, 70, "MathCaption",
  CellTags->{"S5.9.1", "1.10"}],

Cell[CellGroupData[{
Cell[19866, 639, 99, 2, 70, "Input",
  CellTags->"S5.9.1"],
Cell[19968, 643, 73, 2, 70, "Output",
  CellTags->"S5.9.1"]
}, Open  ]],
Cell[20056, 648, 280, 8, 70, "MathCaption",
  CellTags->{"S5.9.1", "1.11"}],

Cell[CellGroupData[{
Cell[20361, 660, 97, 2, 70, "Input",
  CellTags->"S5.9.1"],
Cell[20461, 664, 73, 2, 70, "Output",
  CellTags->"S5.9.1"]
}, Open  ]],
Cell[20549, 669, 149, 5, 70, "MathCaption",
  CellTags->{"S5.9.1", "1.12"}],

Cell[CellGroupData[{
Cell[20723, 678, 82, 2, 70, "Input",
  CellTags->"S5.9.1"],
Cell[20808, 682, 676, 26, 70, "Output",
  CellTags->"S5.9.1"]
}, Open  ]],
Cell[21499, 711, 136, 3, 70, "MathCaption",
  CellTags->{"S5.9.1", "1.13"}],

Cell[CellGroupData[{
Cell[21660, 718, 102, 2, 70, "Input",
  CellTags->"S5.9.1"],
Cell[21765, 722, 891, 32, 70, "Output",
  CellTags->"S5.9.1"]
}, Open  ]],
Cell[22671, 757, 156, 5, 70, "MathCaption",
  CellTags->{"S5.9.1", "1.14"}],

Cell[CellGroupData[{
Cell[22852, 766, 89, 2, 70, "Input",
  CellTags->"S5.9.1"],
Cell[22944, 770, 1034, 38, 70, "Output",
  CellTags->"S5.9.1"]
}, Open  ]],
Cell[23993, 811, 205, 4, 70, "MathCaption",
  CellTags->{"S5.9.1", "1.15"}],

Cell[CellGroupData[{
Cell[24223, 819, 102, 2, 70, "Input",
  CellTags->"S5.9.1"],
Cell[24328, 823, 1842, 62, 70, "Output",
  CellTags->"S5.9.1"]
}, Open  ]],
Cell[26185, 888, 128, 3, 70, "MathCaption",
  CellTags->{"S5.9.1", "1.16"}],

Cell[CellGroupData[{
Cell[26338, 895, 101, 2, 70, "Input",
  CellTags->"S5.9.1"],
Cell[26442, 899, 458, 15, 70, "Output",
  CellTags->"S5.9.1"]
}, Open  ]],
Cell[26915, 917, 85, 1, 70, "MathCaption",
  CellTags->{"S5.9.1", "1.17"}],

Cell[CellGroupData[{
Cell[27025, 922, 71, 2, 70, "Input",
  CellTags->"S5.9.1"],
Cell[27099, 926, 531, 16, 70, "Output",
  CellTags->"S5.9.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

