(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     19050,        685]*)
(*NotebookOutlinePosition[     22990,        806]*)
(*  CellTagsIndexPosition[     22686,        790]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Geometry",
 StyleBox["`", "MB"],
 "Rotations",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.24.1", "1.1"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RotationMatrix2D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the matrix for rotation by angle ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in two dimensions",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Rotate2D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["rotate the vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" clockwise by angle ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Rotate2D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["rotate about the point ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.24.1"],

Cell["Rotations in two dimensions. ", "Caption",
 CellTags->"S5.24.1"],

Cell[TextData[{
 "The usual mathematical convention is that angles in the plane are measured \
counterclockwise from the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis. ",
 StyleBox["RotationMatrix2D", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " gives the matrix needed to change coordinates by a rotation in this \
direction. This means that if this matrix is used to move vectors, they will \
be rotated in the clockwise direction. As is the case with all \
built\[Hyphen]in ",
 StyleBox["Mathematica", "TI",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " functions, all angles are given in radians. "
}], "Text",
 CellTags->{"S5.24.1", "1.2"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.24.1", "1.3"}],

Cell["<<Geometry`Rotations`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.24.1"],

Cell[TextData[{
 "Here is the matrix for rotation by ",
 Cell[BoxData[
  FormBox["60", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees displayed using ",
 StyleBox["MatrixForm", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". "
}], "MathCaption",
 CellTags->{"S5.24.1", "1.4"}],

Cell[CellGroupData[{

Cell["MatrixForm[RotationMatrix2D[ N[Pi/3]] ]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.24.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.5000000000000001`", "0.8660254037844386`"},
     {
      RowBox[{"-", "0.8660254037844386`"}], "0.5000000000000001`"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[2]//MatrixForm= ",
 CellTags->"S5.24.1"]
}, Open  ]],

Cell["This is a list containing two points in the plane. ", "MathCaption",
 CellTags->{"S5.24.1", "1.5"}],

Cell[CellGroupData[{

Cell["{a, b} = {{0., 0.}, {0.5, 0.5}}", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.24.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.5`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.24.1"]
}, Open  ]],

Cell[TextData[{
 "Each point is rotated by ",
 Cell[BoxData[
  FormBox["60", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees about the point ",
 StyleBox["{1,", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["1}", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". "
}], "MathCaption",
 CellTags->{"S5.24.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
{anew, bnew} =
 {Rotate2D[a, N[Pi/3], {1., 1.}],
 Rotate2D[b, N[Pi/3], {1., 1.}]}\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.24.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3660254037844388`"}], ",", "1.3660254037844384`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3169872981077806`", ",", "1.1830127018922192`"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.24.1"]
}, Open  ]],

Cell["\<\
This shows a line joining the two points before and after the rotation. The \
point at the center of the rotation is also shown. \
\>", "MathCaption",
 CellTags->{"S5.24.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[
 {Line[{a, b}], Line[{anew, bnew}],
 {PointSize[.02], Point[{1, 1}]}}],
 AspectRatio->Automatic]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.24.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.278999 0.697191 0.0238095 0.697191 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.279 .02381 m
.62759 .37241 L
s
.02381 .97619 m
.5 .8486 L
s
.02 w
.97619 .721 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.24.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.24.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RotationMatrix3D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["phi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["psi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the matrix for rotation by the specified Euler angles ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["phi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["psi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in three dimensions",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Rotate3D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["phi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["psi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["rotate the vector ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" by the specified Euler angles",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Rotate3D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["phi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["psi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["rotate about the point ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.24.1"],

Cell["Rotations in three dimensions. ", "Caption",
 CellTags->"S5.24.1"],

Cell[TextData[{
 "The rotation given by the Euler angles ",
 StyleBox["phi", "TI"],
 ", ",
 StyleBox["theta", "TI"],
 ", and ",
 StyleBox["psi", "TI"],
 " can be decomposed into a sequence of three successive rotations. The first \
by angle ",
 StyleBox["phi", "TI"],
 " about the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis, the second by angle ",
 StyleBox["theta", "TI"],
 " about the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis, and the third about the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis (again) by angle ",
 StyleBox["psi", "TI"],
 ". The angle ",
 StyleBox["theta", "TI"],
 " is restricted to the range ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.24.1", "1.8"}],

Cell["\<\
If you give exact arguments, the entries in the matrix are exact. \
\>", "MathCaption",
 CellTags->{"S5.24.1", "1.9"}],

Cell[CellGroupData[{

Cell["RotationMatrix3D[Pi, Pi/3, Pi/4]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.24.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], ",", 
     FractionBox[
      SqrtBox[
       FractionBox["3", "2"]], "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      SqrtBox["3"], "2"], ",", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.24.1"]
}, Open  ]],

Cell[TextData[{
 "To rotate an entire three\[Hyphen]dimensional graphics object you need to \
transform all the coordinates specified in the list of primitives for the \
object. You can do this using the function ",
 StyleBox["RotateShape", "MR"],
 " provided in the package ",
 StyleBox["Graphics`Shapes`", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.24.1", "1.10"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.24.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.24.1", "1.1"}],
    Cell[1913, 61, 3977, 126, 106, "DefinitionBox",
      CellTags->"S5.24.1"],
    Cell[5893, 189, 70, 1, 15, "Caption",
      CellTags->"S5.24.1"],
    Cell[5966, 192, 792, 21, 88, "Text",
      CellTags->{"S5.24.1", "1.2"}],
    Cell[6761, 215, 78, 1, 40, "MathCaption",
      CellTags->{"S5.24.1", "1.3"}],
    Cell[6842, 218, 84, 2, 28, "Input",
      CellTags->"S5.24.1"],
    Cell[6929, 222, 342, 11, 40, "MathCaption",
      CellTags->{"S5.24.1", "1.4"}],
    Cell[7296, 237, 102, 2, 28, "Input",
      CellTags->"S5.24.1"],
    Cell[7401, 241, 340, 10, 51, "Output",
      CellTags->"S5.24.1"],
    Cell[7756, 254, 105, 1, 40, "MathCaption",
      CellTags->{"S5.24.1", "1.5"}],
    Cell[7886, 259, 94, 2, 28, "Input",
      CellTags->"S5.24.1"],
    Cell[7983, 263, 227, 8, 25, "Output",
      CellTags->"S5.24.1"],
    Cell[8225, 274, 411, 15, 38, "MathCaption",
      CellTags->{"S5.24.1", "1.6"}],
    Cell[8661, 293, 152, 6, 62, "Input",
      CellTags->"S5.24.1"],
    Cell[8816, 301, 318, 11, 70, "Output",
      CellTags->"S5.24.1"],
    Cell[9149, 315, 191, 4, 70, "MathCaption",
      CellTags->{"S5.24.1", "1.7"}],
    Cell[9365, 323, 182, 7, 70, "Input",
      CellTags->"S5.24.1"],
    Cell[9550, 332, 761, 50, 70, 690, 47, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.24.1"],
    Cell[10314, 384, 180, 6, 70, "Output",
      CellTags->"S5.24.1"],
    Cell[10509, 393, 5810, 183, 70, "DefinitionBox",
      CellTags->"S5.24.1"],
    Cell[16322, 578, 72, 1, 70, "Caption",
      CellTags->"S5.24.1"],
    Cell[16397, 581, 1215, 44, 70, "Text",
      CellTags->{"S5.24.1", "1.8"}],
    Cell[17615, 627, 128, 3, 70, "MathCaption",
      CellTags->{"S5.24.1", "1.9"}],
    Cell[17768, 634, 95, 2, 70, "Input",
      CellTags->"S5.24.1"],
    Cell[17866, 638, 789, 32, 70, "Output",
      CellTags->"S5.24.1"],
    Cell[18670, 673, 364, 9, 70, "Text",
      CellTags->{"S5.24.1", "1.10"}]},
  "1.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S5.24.1", "1.1"}]},
  "1.2"->{
    Cell[5966, 192, 792, 21, 88, "Text",
      CellTags->{"S5.24.1", "1.2"}]},
  "1.3"->{
    Cell[6761, 215, 78, 1, 40, "MathCaption",
      CellTags->{"S5.24.1", "1.3"}]},
  "1.4"->{
    Cell[6929, 222, 342, 11, 40, "MathCaption",
      CellTags->{"S5.24.1", "1.4"}]},
  "1.5"->{
    Cell[7756, 254, 105, 1, 40, "MathCaption",
      CellTags->{"S5.24.1", "1.5"}]},
  "1.6"->{
    Cell[8225, 274, 411, 15, 38, "MathCaption",
      CellTags->{"S5.24.1", "1.6"}]},
  "1.7"->{
    Cell[9149, 315, 191, 4, 70, "MathCaption",
      CellTags->{"S5.24.1", "1.7"}]},
  "1.8"->{
    Cell[16397, 581, 1215, 44, 70, "Text",
      CellTags->{"S5.24.1", "1.8"}]},
  "1.9"->{
    Cell[17615, 627, 128, 3, 70, "MathCaption",
      CellTags->{"S5.24.1", "1.9"}]},
  "1.10"->{
    Cell[18670, 673, 364, 9, 70, "Text",
      CellTags->{"S5.24.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.24.1", 19673, 701},
  {"1.1", 21726, 756},
  {"1.2", 21820, 759},
  {"1.3", 21910, 762},
  {"1.4", 22005, 765},
  {"1.5", 22102, 768},
  {"1.6", 22198, 771},
  {"1.7", 22295, 774},
  {"1.8", 22391, 777},
  {"1.9", 22483, 780},
  {"1.10", 22581, 783}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 6, 36, "Subsection",
  CellTags->{"S5.24.1", "1.1"}],
Cell[1913, 61, 3977, 126, 106, "DefinitionBox",
  CellTags->"S5.24.1"],
Cell[5893, 189, 70, 1, 15, "Caption",
  CellTags->"S5.24.1"],
Cell[5966, 192, 792, 21, 88, "Text",
  CellTags->{"S5.24.1", "1.2"}],
Cell[6761, 215, 78, 1, 40, "MathCaption",
  CellTags->{"S5.24.1", "1.3"}],
Cell[6842, 218, 84, 2, 28, "Input",
  CellTags->"S5.24.1"],
Cell[6929, 222, 342, 11, 40, "MathCaption",
  CellTags->{"S5.24.1", "1.4"}],

Cell[CellGroupData[{
Cell[7296, 237, 102, 2, 28, "Input",
  CellTags->"S5.24.1"],
Cell[7401, 241, 340, 10, 51, "Output",
  CellTags->"S5.24.1"]
}, Open  ]],
Cell[7756, 254, 105, 1, 40, "MathCaption",
  CellTags->{"S5.24.1", "1.5"}],

Cell[CellGroupData[{
Cell[7886, 259, 94, 2, 28, "Input",
  CellTags->"S5.24.1"],
Cell[7983, 263, 227, 8, 25, "Output",
  CellTags->"S5.24.1"]
}, Open  ]],
Cell[8225, 274, 411, 15, 38, "MathCaption",
  CellTags->{"S5.24.1", "1.6"}],

Cell[CellGroupData[{
Cell[8661, 293, 152, 6, 62, "Input",
  CellTags->"S5.24.1"],
Cell[8816, 301, 318, 11, 70, "Output",
  CellTags->"S5.24.1"]
}, Open  ]],
Cell[9149, 315, 191, 4, 70, "MathCaption",
  CellTags->{"S5.24.1", "1.7"}],

Cell[CellGroupData[{
Cell[9365, 323, 182, 7, 70, "Input",
  CellTags->"S5.24.1"],
Cell[9550, 332, 761, 50, 70, 690, 47, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.24.1"],
Cell[10314, 384, 180, 6, 70, "Output",
  CellTags->"S5.24.1"]
}, Open  ]],
Cell[10509, 393, 5810, 183, 70, "DefinitionBox",
  CellTags->"S5.24.1"],
Cell[16322, 578, 72, 1, 70, "Caption",
  CellTags->"S5.24.1"],
Cell[16397, 581, 1215, 44, 70, "Text",
  CellTags->{"S5.24.1", "1.8"}],
Cell[17615, 627, 128, 3, 70, "MathCaption",
  CellTags->{"S5.24.1", "1.9"}],

Cell[CellGroupData[{
Cell[17768, 634, 95, 2, 70, "Input",
  CellTags->"S5.24.1"],
Cell[17866, 638, 789, 32, 70, "Output",
  CellTags->"S5.24.1"]
}, Open  ]],
Cell[18670, 673, 364, 9, 70, "Text",
  CellTags->{"S5.24.1", "1.10"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

