(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    170317,       6829]*)
(*NotebookOutlinePosition[    176301,       7003]*)
(*  CellTagsIndexPosition[    175897,       6984]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "Shapes",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.42.1", "1.1"}],

Cell[TextData[{
 "One of the most powerful aspects of graphics in ",
 StyleBox["Mathematica", "TI"],
 " is the availability of three\[Hyphen]dimensional graphics primitives such \
as ",
 StyleBox["Polygon", "MR"],
 " and ",
 StyleBox["Cuboid", "MR"],
 ". You can create three\[Hyphen]dimensional graphics objects simply by \
specifying a list of these primitives. This package provides lists of \
polygons for some common three\[Hyphen]dimensional shapes. "
}], "Text",
 CellTags->{"S5.42.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Show[Graphics3D[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["shape", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "display the specified shape",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.42.1"],

Cell["\<\
Displaying a three\[Hyphen]dimensional shape. \
\>", "Caption",
 CellTags->"S5.42.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.42.1", "1.3"}],

Cell["<<Graphics`Shapes`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.42.1"],

Cell[TextData[{
 "Using ",
 StyleBox["Short", "MR"],
 " we can look at a skeleton version of the polygon list for a cone. "
}], "MathCaption",
 CellTags->{"S5.42.1", "1.4"}],

Cell[CellGroupData[{

Cell["Short[ Cone[ ], 5]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.42.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`", ",", 
         RowBox[{"-", "1.`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9510565162951535`", ",", "0.30901699437494745`", ",", 
         RowBox[{"-", "1.`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"\[LeftSkeleton]", "18", "\[RightSkeleton]"}], ",", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.9510565162951535`", ",", 
         RowBox[{"-", "0.30901699437494745`"}], ",", 
         RowBox[{"-", "1.`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`", ",", 
         RowBox[{"-", "1.`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}]}], "}"}], "]"}]}], 
   "}"}],
  (Short[#, 5]& )]], "Output",
 CellLabel->"Out[2]//Short= ",
 CellTags->"S5.42.1"]
}, Open  ]],

Cell["\<\
This displays a torus with default values for all parameters. \
\>", "MathCaption",
 CellTags->{"S5.42.1", "1.5"}],

Cell[CellGroupData[{

Cell["Show[Graphics3D[ Torus[ ] ]]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.42.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .77006 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.72135e-17 1.0494 -0.0881211 1.0494 [
[ 0 0 0 0 ]
[ 1 .77006 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02966 .25621 m
0 .44336 L
s
0 .44336 m
.39755 .77006 L
s
.39755 .77006 m
.40347 .60068 L
s
.40347 .60068 m
.02966 .25621 L
s
.69117 0 m
.97553 .43075 L
s
.97553 .43075 m
1 .60976 L
s
1 .60976 m
.70254 .19586 L
s
.70254 .19586 m
.69117 0 L
s
.02966 .25621 m
0 .44336 L
s
0 .44336 m
.70254 .19586 L
s
.70254 .19586 m
.69117 0 L
s
.69117 0 m
.02966 .25621 L
s
.40347 .60068 m
.97553 .43075 L
s
.97553 .43075 m
1 .60976 L
s
1 .60976 m
.39755 .77006 L
s
.39755 .77006 m
.40347 .60068 L
s
0 0 m
1 0 L
1 .77006 L
0 .77006 L
closepath
clip
newpath
.5 Mabswid
.756 .57 .645 r
.39136 .60138 m .40095 .54112 L .4873 .55522 L p F P
0 g
s
.756 .57 .645 r
.4873 .55522 m .48442 .61602 L .39136 .60138 L p F P
0 g
s
.737 .654 .767 r
.49371 .49635 m .4873 .55522 L .40095 .54112 L p F P
0 g
s
.7 .522 .644 r
.48442 .61602 m .4873 .55522 L .57629 .55399 L p F P
0 g
s
.702 .621 .764 r
.4873 .55522 m .49371 .49635 L .56744 .49529 L p F P
0 g
s
.702 .621 .764 r
.56744 .49529 m .57629 .55399 L .4873 .55522 L p F P
0 g
s
.7 .522 .644 r
.57629 .55399 m .58026 .61474 L .48442 .61602 L p F P
0 g
s
.639 .475 .645 r
.58026 .61474 m .57629 .55399 L .66162 .53746 L p F P
0 g
s
.663 .594 .768 r
.57629 .55399 m .56744 .49529 L .63792 .48114 L p F P
0 g
s
.663 .594 .768 r
.63792 .48114 m .66162 .53746 L .57629 .55399 L p F P
0 g
s
.737 .654 .767 r
.40095 .54112 m .42233 .48427 L .49371 .49635 L p F P
0 g
s
.662 .743 .91 r
.50153 .45989 m .49371 .49635 L .42233 .48427 L p F P
0 g
s
.662 .743 .91 r
.49371 .49635 m .50153 .45989 L .55666 .45908 L p F P
0 g
s
.662 .743 .91 r
.55666 .45908 m .56744 .49529 L .49371 .49635 L p F P
0 g
s
.744 .424 .441 r
.39721 .64403 m .39136 .60138 L .48442 .61602 L p F P
0 g
s
.744 .424 .441 r
.48442 .61602 m .48618 .65766 L .39721 .64403 L p F P
0 g
s
.664 .36 .448 r
.48618 .65766 m .48442 .61602 L .58026 .61474 L p F P
0 g
s
.662 .743 .91 r
.56744 .49529 m .55666 .45908 L .60919 .44829 L p F P
0 g
s
.662 .743 .91 r
.60919 .44829 m .63792 .48114 L .56744 .49529 L p F P
0 g
s
.813 .625 .649 r
.30776 .57143 m .32363 .51232 L .40095 .54112 L p F P
0 g
s
.813 .625 .649 r
.40095 .54112 m .39136 .60138 L .30776 .57143 L p F P
0 g
s
.771 .692 .776 r
.42233 .48427 m .40095 .54112 L .32363 .51232 L p F P
0 g
s
.664 .36 .448 r
.58026 .61474 m .57784 .65647 L .48618 .65766 L p F P
0 g
s
.572 .283 .438 r
.57784 .65647 m .58026 .61474 L .67225 .59759 L p F P
0 g
s
.639 .475 .645 r
.66162 .53746 m .67225 .59759 L .58026 .61474 L p F P
0 g
s
.565 .425 .649 r
.67225 .59759 m .66162 .53746 L .7369 .50641 L p F P
0 g
s
.62 .572 .779 r
.66162 .53746 m .63792 .48114 L .69961 .45469 L p F P
0 g
s
.62 .572 .779 r
.69961 .45469 m .7369 .50641 L .66162 .53746 L p F P
0 g
s
.771 .692 .776 r
.32363 .51232 m .35887 .4597 L .42233 .48427 L p F P
0 g
s
.662 .743 .91 r
.44827 .45067 m .42233 .48427 L .35887 .4597 L p F P
0 g
s
.662 .743 .91 r
.42233 .48427 m .44827 .45067 L .50153 .45989 L p F P
0 g
s
.662 .743 .91 r
.63792 .48114 m .60919 .44829 L .65472 .42826 L p F P
0 g
s
.662 .743 .91 r
.65472 .42826 m .69961 .45469 L .63792 .48114 L p F P
0 g
s
.821 .481 .413 r
.31745 .61617 m .30776 .57143 L .39136 .60138 L p F P
0 g
s
.821 .481 .413 r
.39136 .60138 m .39721 .64403 L .31745 .61617 L p F P
0 g
s
.572 .283 .438 r
.67225 .59759 m .66577 .6405 L .57784 .65647 L p F P
0 g
s
.444 .172 .406 r
.66577 .6405 m .67225 .59759 L .75371 .56528 L p F P
0 g
s
.565 .425 .649 r
.7369 .50641 m .75371 .56528 L .67225 .59759 L p F P
0 g
s
.874 .693 .655 r
.24047 .52758 m .26177 .47029 L .32363 .51232 L p F P
0 g
s
.874 .693 .655 r
.32363 .51232 m .30776 .57143 L .24047 .52758 L p F P
0 g
s
.802 .739 .794 r
.35887 .4597 m .32363 .51232 L .26177 .47029 L p F P
0 g
s
.019 0 0 r
.50793 .46053 m .54782 .45994 L p .53677 .45993 L F P
0 g
s
.019 0 0 r
.50153 .45989 m .50793 .46053 L p .53677 .45993 L F P
0 g
s
.019 0 0 r
.54782 .45994 m .55666 .45908 L .50153 .45989 L p F P
0 g
s
0 .486 .715 r
.50793 .46053 m .50153 .45989 L .44827 .45067 L p F P
0 g
s
0 .486 .715 r
.46949 .45387 m .50793 .46053 L p .49375 .45818 L F P
0 g
s
0 .486 .715 r
.44827 .45067 m .46949 .45387 L p .49375 .45818 L F P
0 g
s
.662 .743 .91 r
.35887 .4597 m .40134 .43204 L .44827 .45067 L p F P
0 g
s
0 .476 .815 r
.46949 .45387 m .44827 .45067 L .40134 .43204 L p F P
0 g
s
0 .476 .815 r
.43584 .44048 m .46949 .45387 L p .45337 .44871 L F P
0 g
s
0 .476 .815 r
.40134 .43204 m .43584 .44048 L p .45337 .44871 L F P
0 g
s
.075 .495 .897 r
.43584 .44048 m .40134 .43204 L .36491 .40529 L p F P
0 g
s
.075 .495 .897 r
.41009 .42138 m .43584 .44048 L p .41916 .4322 L F P
0 g
s
.075 .495 .897 r
.36491 .40529 m .41009 .42138 L p .41916 .4322 L F P
0 g
s
.241 .511 .907 r
.39485 .39816 m .41009 .42138 L p .39434 .40994 L F P
0 g
s
.241 .511 .907 r
.34274 .37246 m .39485 .39816 L p .39434 .40994 L F P
0 g
s
0 0 .437 r
.39485 .39816 m .39199 .37288 L p .39543 .38487 L F P
0 g
s
.855 .466 0 r
.41009 .42138 m .39485 .39816 L p .39987 .40918 L F P
0 g
s
.241 .511 .907 r
.41009 .42138 m .36491 .40529 L .34274 .37246 L p F P
0 g
s
.855 .466 0 r
.4266 .46799 m .41009 .42138 L p .39987 .40918 L F P
0 g
s
.855 .466 0 r
.41377 .44866 m .4266 .46799 L p .42009 .45367 L F P
0 g
s
.855 .466 0 r
.39485 .39816 m .41377 .44866 L p .42009 .45367 L F P
0 g
s
0 0 .437 r
.41377 .44866 m .39485 .39816 L p .39543 .38487 L F P
0 g
s
0 0 .437 r
.41155 .42771 m .41377 .44866 L p .40931 .43316 L F P
0 g
s
0 0 .437 r
.39199 .37288 m .41155 .42771 L p .40931 .43316 L F P
0 g
s
.9 .504 .254 r
.43584 .44048 m .41009 .42138 L p .41614 .43123 L F P
0 g
s
.9 .504 .254 r
.41009 .42138 m .4266 .46799 L .44853 .48393 L p F P
0 g
s
.136 .144 .603 r
.42054 .40714 m .41155 .42771 L p .40966 .41142 L F P
0 g
s
.136 .144 .603 r
.40229 .34796 m .42054 .40714 L p .40966 .41142 L F P
0 g
s
0 0 .087 r
.42054 .40714 m .44019 .38909 L p .43168 .40276 L F P
0 g
s
.66 .774 .302 r
.41155 .42771 m .42054 .40714 L p .41384 .42211 L F P
0 g
s
.136 .144 .603 r
.41155 .42771 m .39199 .37288 L .40229 .34796 L p F P
0 g
s
.66 .774 .302 r
.38756 .4809 m .41155 .42771 L p .41384 .42211 L F P
0 g
s
.981 .906 .584 r
.41377 .44866 m .41155 .42771 L p .40728 .44353 L F P
0 g
s
.981 .906 .584 r
.41155 .42771 m .38756 .4809 L .39059 .50548 L p F P
0 g
s
.66 .774 .302 r
.39815 .45666 m .38756 .4809 L p .39282 .46913 L F P
0 g
s
.66 .774 .302 r
.42054 .40714 m .39815 .45666 L p .39282 .46913 L F P
0 g
s
0 0 .087 r
.39815 .45666 m .42054 .40714 L p .43168 .40276 L F P
0 g
s
.981 .906 .584 r
.39059 .50548 m .41377 .44866 L p .40728 .44353 L F P
0 g
s
.9 .504 .254 r
.44853 .48393 m .43584 .44048 L p .41614 .43123 L F P
0 g
s
0 0 .087 r
.4218 .43528 m .39815 .45666 L p .40488 .44584 L F P
0 g
s
0 0 .087 r
.44019 .38909 m .4218 .43528 L p .40488 .44584 L F P
0 g
s
.323 .011 .272 r
.45646 .41916 m .4218 .43528 L p .42935 .42568 L F P
0 g
s
.323 .011 .272 r
.46875 .37552 m .45646 .41916 L p .42935 .42568 L F P
0 g
s
.515 .182 .342 r
.4986 .41021 m .45646 .41916 L p .46402 .4109 L F P
0 g
s
.515 .182 .342 r
.50332 .36801 m .4986 .41021 L p .46402 .4109 L F P
0 g
s
.639 .289 .362 r
.54022 .36744 m .54365 .40952 L .4986 .41021 L p F P
0 g
s
.032 .603 .728 r
.4986 .41021 m .54365 .40952 L p .53059 .40956 L F P
0 g
s
.639 .289 .362 r
.4986 .41021 m .50332 .36801 L .54022 .36744 L p F P
0 g
s
.032 .603 .728 r
.48648 .40967 m .4986 .41021 L p .53059 .40956 L F P
0 g
s
.224 .745 .773 r
.45646 .41916 m .4986 .41021 L p .4817 .41309 L F P
0 g
s
.323 .011 .272 r
.4218 .43528 m .44019 .38909 L .46875 .37552 L p F P
0 g
s
.515 .182 .342 r
.45646 .41916 m .46875 .37552 L .50332 .36801 L p F P
0 g
s
.224 .745 .773 r
.42499 .42276 m .45646 .41916 L p .4817 .41309 L F P
0 g
s
.482 .9 .861 r
.4218 .43528 m .45646 .41916 L p .43763 .4254 L F P
0 g
s
.662 .743 .91 r
.40134 .43204 m .35887 .4597 L .30879 .42412 L p F P
0 g
s
.482 .9 .861 r
.37497 .44617 m .4218 .43528 L p .43763 .4254 L F P
0 g
s
.705 .977 .914 r
.39815 .45666 m .4218 .43528 L p .40314 .44496 L F P
0 g
s
.705 .977 .914 r
.34156 .47692 m .39815 .45666 L p .40314 .44496 L F P
0 g
s
.825 .458 .36 r
.46949 .45387 m .43584 .44048 L p .44235 .44905 L F P
0 g
s
.825 .458 .36 r
.47732 .49514 m .46949 .45387 L p .44235 .44905 L F P
0 g
s
.742 .399 .401 r
.50793 .46053 m .46949 .45387 L p .47587 .46119 L F P
0 g
s
.742 .399 .401 r
.5103 .50072 m .50793 .46053 L p .47587 .46119 L F P
0 g
s
.802 .739 .794 r
.26177 .47029 m .30879 .42412 L .35887 .4597 L p F P
0 g
s
.466 .365 .656 r
.75371 .56528 m .7369 .50641 L .79568 .46247 L p F P
0 g
s
.571 .555 .797 r
.7369 .50641 m .69961 .45469 L .74704 .41754 L p F P
0 g
s
.571 .555 .797 r
.74704 .41754 m .79568 .46247 L .7369 .50641 L p F P
0 g
s
.175 .708 .728 r
.55666 .45908 m .54782 .45994 L .58571 .45216 L p F P
0 g
s
.175 .708 .728 r
.58571 .45216 m .60919 .44829 L .55666 .45908 L p F P
0 g
s
.303 0 0 r
.4172 .65223 m .39721 .64403 L .48618 .65766 L p F P
0 g
s
.303 0 0 r
.48618 .65766 m .49217 .66368 L .4172 .65223 L p F P
0 g
s
.219 0 0 r
.49217 .66368 m .48618 .65766 L .57784 .65647 L p F P
0 g
s
.219 0 0 r
.57784 .65647 m .56956 .66268 L .49217 .66368 L p F P
0 g
s
.036 0 0 r
.56956 .66268 m .57784 .65647 L .66577 .6405 L p F P
0 g
s
.662 .743 .91 r
.69961 .45469 m .65472 .42826 L .68909 .40038 L p F P
0 g
s
.662 .743 .91 r
.68909 .40038 m .74704 .41754 L .69961 .45469 L p F P
0 g
s
.444 .879 .831 r
.60919 .44829 m .58571 .45216 L .61829 .43777 L p F P
0 g
s
.444 .879 .831 r
.61829 .43777 m .65472 .42826 L .60919 .44829 L p F P
0 g
s
.898 .535 .342 r
.25349 .57547 m .24047 .52758 L .30776 .57143 L p F P
0 g
s
.898 .535 .342 r
.30776 .57143 m .31745 .61617 L .25349 .57547 L p F P
0 g
s
.278 0 0 r
.35043 .62893 m .31745 .61617 L .39721 .64403 L p F P
0 g
s
.278 0 0 r
.39721 .64403 m .4172 .65223 L .35043 .62893 L p F P
0 g
s
.444 .172 .406 r
.75371 .56528 m .74344 .61046 L .66577 .6405 L p F P
0 g
s
.229 0 .323 r
.74344 .61046 m .75371 .56528 L .81774 .5194 L p F P
0 g
s
.466 .365 .656 r
.79568 .46247 m .81774 .5194 L .75371 .56528 L p F P
0 g
s
.036 0 0 r
.66577 .6405 m .64361 .64927 L .56956 .66268 L p F P
0 g
s
0 0 0 r
.64361 .64927 m .66577 .6405 L .74344 .61046 L p F P
0 g
s
.662 .743 .91 r
.30879 .42412 m .36491 .40529 L .40134 .43204 L p F P
0 g
s
.687 .976 .903 r
.65472 .42826 m .63123 .43439 L p .64252 .41789 L F P
0 g
s
.687 .976 .903 r
.64252 .41789 m .68909 .40038 L .65472 .42826 L p F P
0 g
s
.816 .963 .904 r
.68909 .40038 m .64252 .41789 L .65588 .39419 L p F P
0 g
s
0 0 0 r
.63673 .44536 m .65242 .40343 L p .64252 .41789 L F P
0 g
s
0 0 0 r
.65242 .40343 m .65588 .39419 L .64252 .41789 L p F P
0 g
s
.687 .976 .903 r
.63123 .43439 m .61829 .43777 L .64252 .41789 L p F P
0 g
s
.827 .794 .82 r
.22173 .41759 m .27724 .37994 L .30879 .42412 L p F P
0 g
s
.827 .794 .82 r
.30879 .42412 m .26177 .47029 L .22173 .41759 L p F P
0 g
s
.662 .743 .91 r
.36491 .40529 m .30879 .42412 L .27724 .37994 L p F P
0 g
s
.939 .783 .66 r
.19638 .47235 m .22173 .41759 L .26177 .47029 L p F P
0 g
s
.939 .783 .66 r
.26177 .47029 m .24047 .52758 L .19638 .47235 L p F P
0 g
s
.513 .544 .825 r
.79568 .46247 m .74704 .41754 L .77519 .37227 L p F P
0 g
s
.662 .743 .91 r
.74704 .41754 m .68909 .40038 L .70869 .36681 L p F P
0 g
s
.662 .743 .91 r
.70869 .36681 m .77519 .37227 L .74704 .41754 L p F P
0 g
s
.311 .278 .66 r
.81774 .5194 m .79568 .46247 L .83167 .40838 L p F P
0 g
s
.513 .544 .825 r
.77519 .37227 m .83167 .40838 L .79568 .46247 L p F P
0 g
s
.654 .329 .411 r
.50793 .46053 m .5103 .50072 L .54455 .50023 L p F P
0 g
s
.654 .329 .411 r
.54455 .50023 m .54782 .45994 L .50793 .46053 L p F P
0 g
s
0 .385 .796 r
.29757 .59512 m .25349 .57547 L .31745 .61617 L p F P
0 g
s
0 .385 .796 r
.31745 .61617 m .35043 .62893 L .29757 .59512 L p F P
0 g
s
.548 .239 .397 r
.54782 .45994 m .54455 .50023 L .57705 .49371 L p F P
0 g
s
.548 .239 .397 r
.57705 .49371 m .58571 .45216 L .54782 .45994 L p F P
0 g
s
.648 .76 .931 r
.44437 .62035 m .4172 .65223 L .49217 .66368 L p F P
0 g
s
.648 .76 .931 r
.49217 .66368 m .50035 .6291 L .44437 .62035 L p F P
0 g
s
.648 .76 .931 r
.50035 .6291 m .49217 .66368 L .56956 .66268 L p F P
0 g
s
.648 .76 .931 r
.56956 .66268 m .55828 .62833 L .50035 .6291 L p F P
0 g
s
.648 .76 .931 r
.55828 .62833 m .56956 .66268 L .64361 .64927 L p F P
0 g
s
.742 .399 .401 r
.46949 .45387 m .47732 .49514 L .5103 .50072 L p F P
0 g
s
0 0 0 r
.74344 .61046 m .70853 .62417 L .64361 .64927 L p F P
0 g
s
.229 0 .323 r
.81774 .5194 m .80426 .5679 L .74344 .61046 L p F P
0 g
s
.574 .939 .818 r
.70853 .62417 m .74344 .61046 L .80426 .5679 L p F P
0 g
s
.662 .743 .91 r
.27724 .37994 m .34274 .37246 L .36491 .40529 L p F P
0 g
s
.393 .103 .349 r
.58571 .45216 m .57705 .49371 L .60492 .48166 L p F P
0 g
s
.393 .103 .349 r
.60492 .48166 m .61829 .43777 L .58571 .45216 L p F P
0 g
s
.928 .552 .155 r
.21188 .52435 m .19638 .47235 L .24047 .52758 L p F P
0 g
s
.928 .552 .155 r
.24047 .52758 m .25349 .57547 L .21188 .52435 L p F P
0 g
s
.816 .963 .904 r
.65588 .39419 m .70869 .36681 L .68909 .40038 L p F P
0 g
s
.648 .76 .931 r
.39496 .60265 m .35043 .62893 L .4172 .65223 L p F P
0 g
s
.648 .76 .931 r
.4172 .65223 m .44437 .62035 L .39496 .60265 L p F P
0 g
s
.648 .76 .931 r
.64361 .64927 m .61352 .61809 L .55828 .62833 L p F P
0 g
s
.648 .76 .931 r
.61352 .61809 m .64361 .64927 L .70853 .62417 L p F P
0 g
s
0 0 .104 r
.80426 .5679 m .81774 .5194 L .8575 .46268 L p F P
0 g
s
.311 .278 .66 r
.83167 .40838 m .8575 .46268 L .81774 .5194 L p F P
0 g
s
.825 .458 .36 r
.43584 .44048 m .44853 .48393 L .47732 .49514 L p F P
0 g
s
.115 0 .226 r
.61829 .43777 m .60492 .48166 L .62552 .46508 L p F P
0 g
s
.115 0 .226 r
.62552 .46508 m .64252 .41789 L .61829 .43777 L p F P
0 g
s
.84 .857 .856 r
.20917 .35811 m .26855 .33064 L .27724 .37994 L p F P
0 g
s
.84 .857 .856 r
.27724 .37994 m .22173 .41759 L .20917 .35811 L p F P
0 g
s
.662 .743 .91 r
.34274 .37246 m .27724 .37994 L .26855 .33064 L p F P
0 g
s
.662 .743 .91 r
.26855 .33064 m .33767 .33632 L .34274 .37246 L p F P
0 g
s
.376 .522 .875 r
.39485 .39816 m .34274 .37246 L .33767 .33632 L p F P
0 g
s
.442 .542 .863 r
.83167 .40838 m .77519 .37227 L .77991 .32256 L p F P
0 g
s
.662 .743 .91 r
.77519 .37227 m .70869 .36681 L .71082 .33044 L p F P
0 g
s
.662 .743 .91 r
.71082 .33044 m .77991 .32256 L .77519 .37227 L p F P
0 g
s
.76 .569 .639 r
.5074 .56601 m .5103 .50072 L .47732 .49514 L p F P
0 g
s
.699 .517 .638 r
.5103 .50072 m .5074 .56601 L .54855 .56544 L p F P
0 g
s
.699 .517 .638 r
.54855 .56544 m .54455 .50023 L .5103 .50072 L p F P
0 g
s
.632 .465 .639 r
.54455 .50023 m .54855 .56544 L .58766 .5579 L p F P
0 g
s
.632 .465 .639 r
.58766 .5579 m .57705 .49371 L .54455 .50023 L p F P
0 g
s
.74 .66 .772 r
.46773 .55956 m .44437 .62035 L .50035 .6291 L p F P
0 g
s
.74 .66 .772 r
.50035 .6291 m .5074 .56601 L .46773 .55956 L p F P
0 g
s
.701 .625 .769 r
.5074 .56601 m .50035 .6291 L .55828 .62833 L p F P
0 g
s
.648 .76 .931 r
.35652 .5772 m .29757 .59512 L .35043 .62893 L p F P
0 g
s
.648 .76 .931 r
.35043 .62893 m .39496 .60265 L .35652 .5772 L p F P
0 g
s
.701 .625 .769 r
.55828 .62833 m .54855 .56544 L .5074 .56601 L p F P
0 g
s
.659 .595 .773 r
.54855 .56544 m .55828 .62833 L .61352 .61809 L p F P
0 g
s
0 .002 .56 r
.66106 .47692 m .64352 .43832 L p .63673 .44536 L F P
0 g
s
0 0 0 r
.64252 .41789 m .63016 .45218 L p .63673 .44536 L F P
0 g
s
.94 .888 .483 r
.65588 .39419 m .64195 .4314 L p .63717 .42433 L F P
0 g
s
.94 .888 .483 r
.64195 .4314 m .63673 .44536 L .63717 .42433 L p F P
0 g
s
0 .002 .56 r
.64352 .43832 m .63717 .42433 L .63673 .44536 L p F P
0 g
s
.707 .327 0 r
.64831 .45297 m .63222 .41702 L p .63717 .42433 L F P
0 g
s
.707 .327 0 r
.63222 .41702 m .6264 .40402 L .63717 .42433 L p F P
0 g
s
0 0 0 r
.63016 .45218 m .62552 .46508 L .63673 .44536 L p F P
0 g
s
.984 .894 .643 r
.18182 .40969 m .20917 .35811 L .22173 .41759 L p F P
0 g
s
.984 .894 .643 r
.22173 .41759 m .19638 .47235 L .18182 .40969 L p F P
0 g
s
.85 .896 .869 r
.70869 .36681 m .65588 .39419 L .65665 .36879 L p F P
0 g
s
.85 .896 .869 r
.65665 .36879 m .71082 .33044 L .70869 .36681 L p F P
0 g
s
.105 .454 .885 r
.26405 .55303 m .21188 .52435 L .25349 .57547 L p F P
0 g
s
.105 .454 .885 r
.25349 .57547 m .29757 .59512 L .26405 .55303 L p F P
0 g
s
.822 .629 .641 r
.46773 .55956 m .47732 .49514 L .44853 .48393 L p F P
0 g
s
.76 .569 .639 r
.47732 .49514 m .46773 .55956 L .5074 .56601 L p F P
0 g
s
.648 .76 .931 r
.70853 .62417 m .66146 .59905 L .61352 .61809 L p F P
0 g
s
.648 .76 .931 r
.66146 .59905 m .70853 .62417 L .75864 .58885 L p F P
0 g
s
.574 .939 .818 r
.80426 .5679 m .75864 .58885 L .70853 .62417 L p F P
0 g
s
.549 .409 .642 r
.57705 .49371 m .58766 .5579 L .6213 .54394 L p F P
0 g
s
.549 .409 .642 r
.6213 .54394 m .60492 .48166 L .57705 .49371 L p F P
0 g
s
.776 .703 .782 r
.43299 .54657 m .39496 .60265 L .44437 .62035 L p F P
0 g
s
.776 .703 .782 r
.44437 .62035 m .46773 .55956 L .43299 .54657 L p F P
0 g
s
.021 .125 .633 r
.8575 .46268 m .83167 .40838 L .83938 .34829 L p F P
0 g
s
.442 .542 .863 r
.77991 .32256 m .83938 .34829 L .83167 .40838 L p F P
0 g
s
.659 .595 .773 r
.61352 .61809 m .58766 .5579 L .54855 .56544 L p F P
0 g
s
.611 .571 .785 r
.58766 .5579 m .61352 .61809 L .66146 .59905 L p F P
0 g
s
0 0 .104 r
.8575 .46268 m .8417 .51541 L .80426 .5679 L p F P
0 g
s
.786 .989 .889 r
.75864 .58885 m .80426 .5679 L .8417 .51541 L p F P
0 g
s
.89 .704 .645 r
.43299 .54657 m .44853 .48393 L .4266 .46799 L p F P
0 g
s
.822 .629 .641 r
.44853 .48393 m .43299 .54657 L .46773 .55956 L p F P
0 g
s
.433 .336 .645 r
.60492 .48166 m .6213 .54394 L .64635 .52464 L p F P
0 g
s
.433 .336 .645 r
.64635 .52464 m .62552 .46508 L .60492 .48166 L p F P
0 g
s
.376 .522 .875 r
.33767 .33632 m .39199 .37288 L .39485 .39816 L p F P
0 g
s
.611 .571 .785 r
.66146 .59905 m .6213 .54394 L .58766 .5579 L p F P
0 g
s
.94 .888 .483 r
.63717 .42433 m .65665 .36879 L .65588 .39419 L p F P
0 g
s
0 0 .256 r
.19857 .46654 m .18182 .40969 L .19638 .47235 L p F P
0 g
s
0 0 .256 r
.19638 .47235 m .21188 .52435 L .19857 .46654 L p F P
0 g
s
.81 .754 .801 r
.40638 .52803 m .35652 .5772 L .39496 .60265 L p F P
0 g
s
.81 .754 .801 r
.39496 .60265 m .43299 .54657 L .40638 .52803 L p F P
0 g
s
.96 .803 .641 r
.40638 .52803 m .4266 .46799 L .41377 .44866 L p F P
0 g
s
.89 .704 .645 r
.4266 .46799 m .40638 .52803 L .43299 .54657 L p F P
0 g
s
.662 .743 .91 r
.28541 .28082 m .35123 .30031 L .33767 .33632 L p F P
0 g
s
.662 .743 .91 r
.33767 .33632 m .26855 .33064 L .28541 .28082 L p F P
0 g
s
.475 .533 .837 r
.39199 .37288 m .33767 .33632 L .35123 .30031 L p F P
0 g
s
.554 .551 .805 r
.6213 .54394 m .66146 .59905 L .69775 .57251 L p F P
0 g
s
.648 .76 .931 r
.75864 .58885 m .69775 .57251 L .66146 .59905 L p F P
0 g
s
.237 .221 .638 r
.62552 .46508 m .64635 .52464 L .6602 .50162 L p F P
0 g
s
.237 .221 .638 r
.6602 .50162 m .63673 .44536 L .62552 .46508 L p F P
0 g
s
.648 .76 .931 r
.333 .5459 m .26405 .55303 L .29757 .59512 L p F P
0 g
s
.648 .76 .931 r
.29757 .59512 m .35652 .5772 L .333 .5459 L p F P
0 g
s
.021 .125 .633 r
.83938 .34829 m .86682 .39931 L .8575 .46268 L p F P
0 g
s
.83 .811 .324 r
.8417 .51541 m .8575 .46268 L .86682 .39931 L p F P
0 g
s
.826 .92 .899 r
.22812 .29726 m .28541 .28082 L .26855 .33064 L p F P
0 g
s
.826 .92 .899 r
.26855 .33064 m .20917 .35811 L .22812 .29726 L p F P
0 g
s
.662 .743 .91 r
.77991 .32256 m .71082 .33044 L .69427 .2948 L p F P
0 g
s
.84 .822 .832 r
.71082 .33044 m .65665 .36879 L .64426 .34418 L p F P
0 g
s
.84 .822 .832 r
.64426 .34418 m .69427 .2948 L .71082 .33044 L p F P
0 g
s
.554 .551 .805 r
.69775 .57251 m .64635 .52464 L .6213 .54394 L p F P
0 g
s
.648 .76 .931 r
.69775 .57251 m .75864 .58885 L .7886 .54572 L p F P
0 g
s
.786 .989 .889 r
.8417 .51541 m .7886 .54572 L .75864 .58885 L p F P
0 g
s
.354 .55 .906 r
.83938 .34829 m .77991 .32256 L .75886 .27314 L p F P
0 g
s
.662 .743 .91 r
.69427 .2948 m .75886 .27314 L .77991 .32256 L p F P
0 g
s
.475 .533 .837 r
.35123 .30031 m .40229 .34796 L .39199 .37288 L p F P
0 g
s
.981 .822 .611 r
.65665 .36879 m .63717 .42433 L .6264 .40402 L p F P
0 g
s
.981 .822 .611 r
.6264 .40402 m .64426 .34418 L .65665 .36879 L p F P
0 g
s
.96 .803 .641 r
.41377 .44866 m .39059 .50548 L .40638 .52803 L p F P
0 g
s
.837 .816 .829 r
.35652 .5772 m .40638 .52803 L .39059 .50548 L p F P
0 g
s
0 .002 .56 r
.63673 .44536 m .6602 .50162 L .66106 .47692 L p F P
0 g
s
.837 .816 .829 r
.39059 .50548 m .333 .5459 L .35652 .5772 L p F P
0 g
s
.484 .536 .835 r
.64635 .52464 m .69775 .57251 L .71857 .5405 L p F P
0 g
s
.484 .536 .835 r
.71857 .5405 m .6602 .50162 L .64635 .52464 L p F P
0 g
s
.299 .494 .881 r
.2545 .50595 m .19857 .46654 L .21188 .52435 L p F P
0 g
s
.299 .494 .881 r
.21188 .52435 m .26405 .55303 L .2545 .50595 L p F P
0 g
s
.83 .902 .489 r
.20149 .34523 m .22812 .29726 L .20917 .35811 L p F P
0 g
s
.83 .902 .489 r
.20917 .35811 m .18182 .40969 L .20149 .34523 L p F P
0 g
s
.648 .76 .931 r
.7886 .54572 m .71857 .5405 L .69775 .57251 L p F P
0 g
s
.662 .743 .91 r
.328 .23585 m .38301 .26825 L .35123 .30031 L p F P
0 g
s
.662 .743 .91 r
.35123 .30031 m .28541 .28082 L .328 .23585 L p F P
0 g
s
.55 .55 .807 r
.40229 .34796 m .35123 .30031 L .38301 .26825 L p F P
0 g
s
.83 .811 .324 r
.86682 .39931 m .85002 .45698 L .8417 .51541 L p F P
0 g
s
.855 .932 .876 r
.7886 .54572 m .8417 .51541 L .85002 .45698 L p F P
0 g
s
0 0 .437 r
.86682 .39931 m .83938 .34829 L .8152 .28781 L p F P
0 g
s
.354 .55 .906 r
.75886 .27314 m .8152 .28781 L .83938 .34829 L p F P
0 g
s
.55 .55 .807 r
.38301 .26825 m .42521 .32601 L .40229 .34796 L p F P
0 g
s
.39 .298 .63 r
.42054 .40714 m .40229 .34796 L .42521 .32601 L p F P
0 g
s
.662 .743 .91 r
.75886 .27314 m .69427 .2948 L .65974 .26373 L p F P
0 g
s
.812 .759 .803 r
.69427 .2948 m .64426 .34418 L .61946 .32293 L p F P
0 g
s
.812 .759 .803 r
.61946 .32293 m .65974 .26373 L .69427 .2948 L p F P
0 g
s
.908 .716 .631 r
.64426 .34418 m .6264 .40402 L .60517 .38656 L p F P
0 g
s
.908 .716 .631 r
.60517 .38656 m .61946 .32293 L .64426 .34418 L p F P
0 g
s
.707 .327 0 r
.63717 .42433 m .65662 .46715 L p .64831 .45297 L F P
0 g
s
.884 .452 .13 r
.6264 .40402 m .64831 .45297 L .62271 .43228 L p F P
0 g
s
.115 .514 .91 r
.66742 .44183 m .6381 .43557 L p .64831 .45297 L F P
0 g
s
.115 .514 .91 r
.6381 .43557 m .62271 .43228 L .64831 .45297 L p F P
0 g
s
.707 .327 0 r
.65662 .46715 m .66106 .47692 L .64831 .45297 L p F P
0 g
s
.849 .888 .867 r
.333 .5459 m .39059 .50548 L .38756 .4809 L p F P
0 g
s
.391 .526 .873 r
.6602 .50162 m .71857 .5405 L .72103 .50576 L p F P
0 g
s
.391 .526 .873 r
.72103 .50576 m .66106 .47692 L .6602 .50162 L p F P
0 g
s
.648 .76 .931 r
.32746 .51138 m .2545 .50595 L .26405 .55303 L p F P
0 g
s
.648 .76 .931 r
.26405 .55303 m .333 .5459 L .32746 .51138 L p F P
0 g
s
.755 .962 .935 r
.27954 .2417 m .328 .23585 L .28541 .28082 L p F P
0 g
s
.755 .962 .935 r
.28541 .28082 m .22812 .29726 L .27954 .2417 L p F P
0 g
s
.608 .57 .786 r
.43041 .24388 m .45874 .30947 L .42521 .32601 L p F P
0 g
s
.608 .57 .786 r
.42521 .32601 m .38301 .26825 L .43041 .24388 L p F P
0 g
s
.53 .388 .633 r
.44019 .38909 m .42521 .32601 L .45874 .30947 L p F P
0 g
s
.39 .298 .63 r
.42521 .32601 m .44019 .38909 L .42054 .40714 L p F P
0 g
s
.849 .888 .867 r
.38756 .4809 m .32746 .51138 L .333 .5459 L p F P
0 g
s
.648 .76 .931 r
.71857 .5405 m .7886 .54572 L .79397 .49822 L p F P
0 g
s
.855 .932 .876 r
.85002 .45698 m .79397 .49822 L .7886 .54572 L p F P
0 g
s
0 .035 .544 r
.21781 .40726 m .20149 .34523 L .18182 .40969 L p F P
0 g
s
0 .035 .544 r
.18182 .40969 m .19857 .46654 L .21781 .40726 L p F P
0 g
s
.253 .569 .938 r
.8152 .28781 m .75886 .27314 L .71234 .22947 L p F P
0 g
s
.662 .743 .91 r
.65974 .26373 m .71234 .22947 L .75886 .27314 L p F P
0 g
s
.778 .706 .784 r
.65974 .26373 m .61946 .32293 L .58451 .30746 L p F P
0 g
s
.833 .633 .633 r
.61946 .32293 m .60517 .38656 L .57543 .37388 L p F P
0 g
s
.833 .633 .633 r
.57543 .37388 m .58451 .30746 L .61946 .32293 L p F P
0 g
s
.662 .743 .91 r
.39316 .20129 m .43041 .24388 L .38301 .26825 L p F P
0 g
s
.662 .743 .91 r
.38301 .26825 m .328 .23585 L .39316 .20129 L p F P
0 g
s
.648 .76 .931 r
.79397 .49822 m .72103 .50576 L .71857 .5405 L p F P
0 g
s
.884 .452 .13 r
.62271 .43228 m .60517 .38656 L .6264 .40402 L p F P
0 g
s
.662 .743 .91 r
.71234 .22947 m .65974 .26373 L .61024 .24091 L p F P
0 g
s
.778 .706 .784 r
.58451 .30746 m .61024 .24091 L .65974 .26373 L p F P
0 g
s
0 0 .437 r
.8152 .28781 m .84142 .33518 L .86682 .39931 L p F P
0 g
s
.997 .839 .563 r
.85002 .45698 m .86682 .39931 L .84142 .33518 L p F P
0 g
s
.819 .955 .904 r
.32746 .51138 m .38756 .4809 L .39815 .45666 L p F P
0 g
s
.657 .596 .774 r
.48857 .23028 m .49948 .30029 L .45874 .30947 L p F P
0 g
s
.657 .596 .774 r
.45874 .30947 m .43041 .24388 L .48857 .23028 L p F P
0 g
s
.624 .453 .631 r
.46875 .37552 m .45874 .30947 L .49948 .30029 L p F P
0 g
s
.53 .388 .633 r
.45874 .30947 m .46875 .37552 L .44019 .38909 L p F P
0 g
s
.741 .662 .773 r
.61024 .24091 m .58451 .30746 L .54301 .29959 L p F P
0 g
s
.765 .568 .631 r
.58451 .30746 m .57543 .37388 L .54022 .36744 L p F P
0 g
s
.765 .568 .631 r
.54022 .36744 m .54301 .29959 L .58451 .30746 L p F P
0 g
s
.266 .521 .909 r
.66106 .47692 m .72103 .50576 L .70375 .47164 L p F P
0 g
s
.266 .521 .909 r
.70375 .47164 m .64831 .45297 L .66106 .47692 L p F P
0 g
s
.826 .425 .288 r
.60517 .38656 m .62271 .43228 L .58658 .4172 L p F P
0 g
s
.826 .425 .288 r
.58658 .4172 m .57543 .37388 L .60517 .38656 L p F P
0 g
s
.701 .626 .77 r
.55093 .22924 m .54301 .29959 L .49948 .30029 L p F P
0 g
s
.701 .626 .77 r
.49948 .30029 m .48857 .23028 L .55093 .22924 L p F P
0 g
s
.698 .51 .631 r
.50332 .36801 m .49948 .30029 L .54301 .29959 L p F P
0 g
s
.624 .453 .631 r
.49948 .30029 m .50332 .36801 L .46875 .37552 L p F P
0 g
s
.741 .662 .773 r
.54301 .29959 m .55093 .22924 L .61024 .24091 L p F P
0 g
s
.698 .51 .631 r
.54301 .29959 m .54022 .36744 L .50332 .36801 L p F P
0 g
s
0 0 0 r
.25683 .28603 m .27954 .2417 L .22812 .29726 L p F P
0 g
s
0 0 0 r
.22812 .29726 m .20149 .34523 L .25683 .28603 L p F P
0 g
s
.662 .743 .91 r
.47416 .18185 m .48857 .23028 L .43041 .24388 L p F P
0 g
s
.662 .743 .91 r
.43041 .24388 m .39316 .20129 L .47416 .18185 L p F P
0 g
s
.433 .52 .847 r
.27192 .45823 m .21781 .40726 L .19857 .46654 L p F P
0 g
s
.433 .52 .847 r
.19857 .46654 m .2545 .50595 L .27192 .45823 L p F P
0 g
s
.662 .743 .91 r
.61024 .24091 m .6441 .19705 L .71234 .22947 L p F P
0 g
s
.662 .743 .91 r
.6441 .19705 m .61024 .24091 L .55093 .22924 L p F P
0 g
s
.605 .942 .941 r
.36005 .19856 m .39316 .20129 L .328 .23585 L p F P
0 g
s
.605 .942 .941 r
.328 .23585 m .27954 .2417 L .36005 .19856 L p F P
0 g
s
.737 .366 .348 r
.57543 .37388 m .58658 .4172 L .54365 .40952 L p F P
0 g
s
.737 .366 .348 r
.54365 .40952 m .54022 .36744 L .57543 .37388 L p F P
0 g
s
.253 .569 .938 r
.71234 .22947 m .75875 .23376 L .8152 .28781 L p F P
0 g
s
.828 .364 0 r
.84142 .33518 m .8152 .28781 L .75875 .23376 L p F P
0 g
s
.819 .955 .904 r
.39815 .45666 m .34156 .47692 L .32746 .51138 L p F P
0 g
s
.648 .76 .931 r
.2545 .50595 m .32746 .51138 L .34156 .47692 L p F P
0 g
s
.997 .839 .563 r
.84142 .33518 m .82534 .39804 L .85002 .45698 L p F P
0 g
s
.851 .851 .842 r
.79397 .49822 m .85002 .45698 L .82534 .39804 L p F P
0 g
s
.662 .743 .91 r
.5614 .18036 m .55093 .22924 L .48857 .23028 L p F P
0 g
s
.662 .743 .91 r
.48857 .23028 m .47416 .18185 L .5614 .18036 L p F P
0 g
s
.168 .6 .938 r
.75875 .23376 m .71234 .22947 L .6441 .19705 L p F P
0 g
s
.662 .743 .91 r
.55093 .22924 m .5614 .18036 L .6441 .19705 L p F P
0 g
s
.115 .514 .91 r
.64831 .45297 m .70375 .47164 L .66742 .44183 L p F P
0 g
s
.648 .76 .931 r
.34156 .47692 m .27192 .45823 L .2545 .50595 L p F P
0 g
s
.648 .76 .931 r
.72103 .50576 m .79397 .49822 L .77211 .45086 L p F P
0 g
s
.648 .76 .931 r
.77211 .45086 m .70375 .47164 L .72103 .50576 L p F P
0 g
s
.851 .851 .842 r
.82534 .39804 m .77211 .45086 L .79397 .49822 L p F P
0 g
s
.705 .977 .914 r
.4218 .43528 m .37497 .44617 L .34156 .47692 L p F P
0 g
s
0 .506 .848 r
.62271 .43228 m .66742 .44183 L .61516 .4199 L p F P
0 g
s
0 .506 .848 r
.61516 .4199 m .58658 .4172 L .62271 .43228 L p F P
0 g
s
.332 .248 .609 r
.27077 .35301 m .25683 .28603 L .20149 .34523 L p F P
0 g
s
.332 .248 .609 r
.20149 .34523 m .21781 .40726 L .27077 .35301 L p F P
0 g
s
.404 .851 .914 r
.46128 .17413 m .47416 .18185 L .39316 .20129 L p F P
0 g
s
.404 .851 .914 r
.39316 .20129 m .36005 .19856 L .46128 .17413 L p F P
0 g
s
.168 .6 .938 r
.6441 .19705 m .67424 .19325 L .75875 .23376 L p F P
0 g
s
.15 .651 .909 r
.67424 .19325 m .6441 .19705 L .5614 .18036 L p F P
0 g
s
.648 .76 .931 r
.27192 .45823 m .34156 .47692 L .37497 .44617 L p F P
0 g
s
.929 .729 .612 r
.82534 .39804 m .84142 .33518 L .78053 .27756 L p F P
0 g
s
.828 .364 0 r
.75875 .23376 m .78053 .27756 L .84142 .33518 L p F P
0 g
s
.482 .9 .861 r
.45646 .41916 m .42499 .42276 L .37497 .44617 L p F P
0 g
s
.648 .76 .931 r
.70375 .47164 m .77211 .45086 L .72321 .4089 L p F P
0 g
s
.648 .76 .931 r
.72321 .4089 m .66742 .44183 L .70375 .47164 L p F P
0 g
s
.223 0 .163 r
.34443 .23987 m .36005 .19856 L .27954 .2417 L p F P
0 g
s
.223 0 .163 r
.27954 .2417 m .25683 .28603 L .34443 .23987 L p F P
0 g
s
0 .525 .762 r
.58658 .4172 m .61516 .4199 L .55245 .40868 L p F P
0 g
s
0 .525 .762 r
.55245 .40868 m .54365 .40952 L .58658 .4172 L p F P
0 g
s
.232 .737 .893 r
.57076 .17226 m .5614 .18036 L .47416 .18185 L p F P
0 g
s
.232 .737 .893 r
.47416 .18185 m .46128 .17413 L .57076 .17226 L p F P
0 g
s
.15 .651 .909 r
.5614 .18036 m .57076 .17226 L .67424 .19325 L p F P
0 g
s
.224 .745 .773 r
.4986 .41021 m .48648 .40967 L .42499 .42276 L p F P
0 g
s
.818 .375 .187 r
.78053 .27756 m .75875 .23376 L .67424 .19325 L p F P
0 g
s
.032 .603 .728 r
.54365 .40952 m .55245 .40868 L .48648 .40967 L p F P
0 g
s
.526 .543 .816 r
.31664 .41504 m .27077 .35301 L .21781 .40726 L p F P
0 g
s
.526 .543 .816 r
.21781 .40726 m .27192 .45823 L .31664 .41504 L p F P
0 g
s
.648 .76 .931 r
.37497 .44617 m .31664 .41504 L .27192 .45823 L p F P
0 g
s
.929 .729 .612 r
.78053 .27756 m .76717 .34525 L .82534 .39804 L p F P
0 g
s
.822 .778 .812 r
.77211 .45086 m .82534 .39804 L .76717 .34525 L p F P
0 g
s
.822 .778 .812 r
.76717 .34525 m .72321 .4089 L .77211 .45086 L p F P
0 g
s
.648 .76 .931 r
.31664 .41504 m .37497 .44617 L .42499 .42276 L p F P
0 g
s
.648 .76 .931 r
.66742 .44183 m .72321 .4089 L .65114 .37768 L p F P
0 g
s
.648 .76 .931 r
.65114 .37768 m .61516 .4199 L .66742 .44183 L p F P
0 g
s
.468 .106 .267 r
.45518 .21364 m .46128 .17413 L .36005 .19856 L p F P
0 g
s
.468 .106 .267 r
.36005 .19856 m .34443 .23987 L .45518 .21364 L p F P
0 g
s
.505 .362 .62 r
.35402 .31082 m .34443 .23987 L .25683 .28603 L p F P
0 g
s
.505 .362 .62 r
.25683 .28603 m .27077 .35301 L .35402 .31082 L p F P
0 g
s
.818 .375 .187 r
.67424 .19325 m .68846 .23417 L .78053 .27756 L p F P
0 g
s
.727 .32 .276 r
.68846 .23417 m .67424 .19325 L .57076 .17226 L p F P
0 g
s
.846 .638 .621 r
.76717 .34525 m .78053 .27756 L .68846 .23417 L p F P
0 g
s
.648 .76 .931 r
.38543 .38176 m .42499 .42276 L .48648 .40967 L p F P
0 g
s
.648 .76 .931 r
.42499 .42276 m .38543 .38176 L .31664 .41504 L p F P
0 g
s
.648 .76 .931 r
.61516 .4199 m .65114 .37768 L .56358 .36158 L p F P
0 g
s
.648 .76 .931 r
.56358 .36158 m .55245 .40868 L .61516 .4199 L p F P
0 g
s
.596 .568 .794 r
.27077 .35301 m .31664 .41504 L .38543 .38176 L p F P
0 g
s
.616 .234 .297 r
.57519 .21163 m .57076 .17226 L .46128 .17413 L p F P
0 g
s
.616 .234 .297 r
.46128 .17413 m .45518 .21364 L .57519 .21163 L p F P
0 g
s
.727 .32 .276 r
.57076 .17226 m .57519 .21163 L .68846 .23417 L p F P
0 g
s
.648 .76 .931 r
.47116 .36301 m .48648 .40967 L .55245 .40868 L p F P
0 g
s
.648 .76 .931 r
.48648 .40967 m .47116 .36301 L .38543 .38176 L p F P
0 g
s
.596 .568 .794 r
.38543 .38176 m .35402 .31082 L .27077 .35301 L p F P
0 g
s
.784 .719 .791 r
.72321 .4089 m .76717 .34525 L .67973 .30562 L p F P
0 g
s
.784 .719 .791 r
.67973 .30562 m .65114 .37768 L .72321 .4089 L p F P
0 g
s
.648 .76 .931 r
.55245 .40868 m .56358 .36158 L .47116 .36301 L p F P
0 g
s
.846 .638 .621 r
.68846 .23417 m .67973 .30562 L .76717 .34525 L p F P
0 g
s
.613 .439 .622 r
.45893 .2869 m .45518 .21364 L .34443 .23987 L p F P
0 g
s
.613 .439 .622 r
.34443 .23987 m .35402 .31082 L .45893 .2869 L p F P
0 g
s
.771 .566 .622 r
.67973 .30562 m .68846 .23417 L .57519 .21163 L p F P
0 g
s
.651 .597 .781 r
.35402 .31082 m .38543 .38176 L .47116 .36301 L p F P
0 g
s
.743 .671 .78 r
.65114 .37768 m .67973 .30562 L .57247 .28507 L p F P
0 g
s
.743 .671 .78 r
.57247 .28507 m .56358 .36158 L .65114 .37768 L p F P
0 g
s
.651 .597 .781 r
.47116 .36301 m .45893 .2869 L .35402 .31082 L p F P
0 g
s
.696 .503 .622 r
.57247 .28507 m .57519 .21163 L .45518 .21364 L p F P
0 g
s
.696 .503 .622 r
.45518 .21364 m .45893 .2869 L .57247 .28507 L p F P
0 g
s
.771 .566 .622 r
.57519 .21163 m .57247 .28507 L .67973 .30562 L p F P
0 g
s
.7 .631 .776 r
.45893 .2869 m .47116 .36301 L .56358 .36158 L p F P
0 g
s
.7 .631 .776 r
.56358 .36158 m .57247 .28507 L .45893 .2869 L p F P
0 g
s
.25 Mabswid
.69117 0 m
.97553 .43075 L
s
.97553 .43075 m
1 .60976 L
s
1 .60976 m
.70254 .19586 L
s
.70254 .19586 m
.69117 0 L
s
.02966 .25621 m
0 .44336 L
s
0 .44336 m
.70254 .19586 L
s
.70254 .19586 m
.69117 0 L
s
.69117 0 m
.02966 .25621 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003o`?ooool2
o`0006[ooooo002mooooo`?o000000?oooooo`000?ooool0JOooool00;_ooooo0_l00004ooooo`;o
0000JOooool00;Sooooo0ol00006ooooo`03o`000?oooooo000006Sooooo002fooooo`;o00002Ooo
ool00ol0003oooooo`00001Xooooo`00/oooool3o`0000_ooooo00Co0000oooooooooooo0000Iooo
ool00;3ooooo0ol0000>ooooo`05o`000?ooooooooooooooool00000I_ooool00:kooooo0_l0000A
ooooo`05o`000?ooooooooooooooool00000I_ooool00:_ooooo0ol0000Cooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0Hoooool00:Wooooo0_l0000Gooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool0H_ooool00:Kooooo0ol0000Iooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool0H_ooool00:Cooooo0_l0000Looooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool0HOooool00:7ooooo0ol0000Nooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool0H?ooool009oooooo0_l0000Qooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0H?ooool009cooooo0ol0000Sooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0Goooool009Wooooo0ol0000Vooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool0G_ooool009Oooooo0_l0000Yooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
G_ooool009Cooooo0ol0000[ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0GOoo
ool009;ooooo0_l0000^ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0G?ooool0
08oooooo0ol0000`ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0G?ooool008go
oooo0_l0000cooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0Foooool008[ooooo
0ol0000eooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0F_ooool008Sooooo0_l0
000hooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0F_ooool008Gooooo0ol0000j
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0FOooool008?ooooo0_l0000noooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0F?ooool0083ooooo0ol00010ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool0F?ooool007gooooo0ol00013ooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool0Eoooool007_ooooo0_l00016ooooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool0E_ooool007Sooooo0ol00018ooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool0E_ooool007Kooooo0_l0001;ooooo`03o`000?oooooooooo
00kooooo00?o0000ooooooooool0EOooool007?ooooo0ol0001=ooooo`03o`000?oooooooooo00oo
oooo00?o0000ooooooooool0E?ooool0077ooooo0_l0001@ooooo`03o`000?oooooooooo00oooooo
00?o0000ooooooooool0E?ooool006kooooo0ol0001Booooo`03o`000?oooooooooo013ooooo00?o
0000ooooooooool0Doooool006cooooo0_l0001Eooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool0D_ooool006Wooooo0ol0001Gooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0D_ooool006Kooooo0ol0001Jooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool0DOooool006Cooooo0_l0001Mooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0
D?ooool0067ooooo0ol0001Oooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0D?oo
ool005oooooo0_l0001Rooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0Coooool0
05cooooo0ol0001Uooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0C_ooool005[o
oooo0_l0001Xooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0C_ooool005Oooooo
0ol0000`oooooaoo00006oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo04gooooo
001Eooooo`;o0000;oooool4o`0000;oMa]400?o0000oidkC?nM>d`05_nM>d`01?l0003o^U56okYA
A_njDDH6o`0001Gooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`1<ooooo`00D_oo
ool3o`0002gooooo1?l00006ogLKA003o`000?nM>dcoWC]<01KoWC]<00?o0000okYAA_njDDH01onj
DDH7o`0000kooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`1<ooooo`00D?ooool2
o`0002cooooo1?l0000:ogLKA003o`000?nM>dcoWC]<01KoWC]<00?o0000okYAA_njDDH03_njDDH6
o`0000Sooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`1;ooooo`00COooool3o`00
02[ooooo1?l0000>ogLKA003o`000?nM>dcoWC]<01KoWC]<00?o0000okYAA_njDDH05?njDDH4o`00
00Cooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`1:ooooo`00B_ooool3o`0002Wo
oooo1?l0000AogLKA003o`000?nM>dcoWC]<01SoWC]<00?o0000okYAA_njDDH05OnjDDH01Ol0003o
dEl_o`000?l0003ooooo00;o00006_ooool00ol0003oooooooooo`1:ooooo`00B?ooool2o`0002Wo
oooo0ol0000EogLKA003o`000?nM>dcoWC]<01SoWC]<00?o0000okYAA_njDDH05OnjDDH00ol0003o
dEl_o`000004o`0001_ooooo00?o0000ooooooooool0BOooool004Gooooo0ol0000Yooooo`;o0000
00?o>@0Yo`000?mg6d@05Omg6d@00ol0003oWC]<oidkC00HoidkC003o`000?njDDKo^U5601Co^U56
0ol00004om5O;`;o00006oooool00ol0003oooooooooo`18ooooo`00@oooool2o`0002[ooooo0_l0
0002ocT0:@03o`000?mg6dCoMa]401GoMa]400?o0000oidkC?nM>d`06?nM>d`00ol0003o^U56okYA
AP0AokYAAP?o00000_njDDH00ol0003odEl_om5O;`04om5O;`;o00006Oooool00ol0003ooooooooo
o`18ooooo`00@?ooool3o`0002_ooooo00?o0000ocT0:Oli02T00_li02T00ol0003oMa]4ogLKA00C
ogLKA27o00003OnjDDH3o`0000Go^U5600?o0000om5O;ooAGbl01OoAGbl2o`0001Wooooo00?o0000
ooooooooool0Aoooool003kooooo0_l0000/ooooo`;o00001Oli02T00ol0003oMa]4ogLKA00>ogLK
A0Go00000_nLL9l00ol0003o/X2Ook:0W`0Hok:0W`04o`000?o5T9ooaI2OolF@W`Go00001_njDDH2
o`0000Wo^U5600?o0000om5O;ooAGbl01?oAGbl01?l0003odEl_o`000?l0000Hooooo`03o`000?oo
oooooooo04Kooooo000kooooo`?o0000;?ooool2o`0000Ko>@0Y00?o0000ogLKA?mg6d@02omg6d@4
o`0000OoW72O00?o0000ok:0WonbP9l06?nbP9l00ol0003oaI2OolF@W`06olF@W`Ko00002onjDDH0
0ol0003odEl_om5O;`05om5O;`03o`000?oAGboodEl_00;o00005_ooool00ol0003oooooooooo`16
ooooo`00>Oooool2o`0002gooooo0_l00008ocT0:@03o`000?mg6dCoMa]400OoMa]41?l0000;oia`
W`03o`000?nbP9oo/X2O01So/X2O00?o0000olF@Woo5T9l01_o5T9l3o`0000?oaI2O1Ol00006okYA
AP03o`000?oAGboodEl_00KodEl_00Co0000om5O;ooAGboodEl_0_l0000Eooooo`03o`000?oooooo
oooo04Gooooo000fooooo`?o0000;Oooool2o`0000[o>@0Y00?o0000ogLKA?mg6d@00_mg6d@5o`00
00ooW72O00?o0000ok:0WonbP9l06?nbP9l00ol0003oaI2OolF@W`03olF@W`?o00002oo5T9l5o`00
00;o^U5600?o0000om5O;ooAGbl01OoAGbl00ol0003odEl_om5O;`03om5O;`;o00004oooool00ol0
003oooooooooo`15ooooo`00<oooool3o`0002oooooo00?o0000ocT0:Oli02T02Oli02T00ol0003o
Ma]4o`000003o`0001CoW72O00?o0000ok:0WonbP9l06?nbP9l00ol0003oaI2OolF@W`03o`0001?o
aI2O1?l00007om5O;`03o`000?oAGboodEl_00CodEl_0_l0000Booooo`03o`000?oooooooooo04Co
oooo000aooooo`;o0000<?ooool2o`0000_o>@0Y0ol0000Hoia`W`03o`000?nbP9oo/X2O01So/X2O
0ol0000HolF@W`04o`000?oHXiko0000o`0000KodEl_00?o0000om5O;ooAGbl00ooAGbl00ol0003o
ded0o`00000Booooo`03o`000?oooooooooo04?ooooo000^ooooo`?o0000<Oooool00ol0003o>@0Y
ocT0:@09ocT0:@;o000000?oPEbNo`000?nLL9l06?nLL9l00ol0003o/X2Ook:0W`0Fok:0W`?o0000
6_o5T9l01?l0003of:>NomRSW_oHXih2o`0000GodEl_00?o0000om5O;ooAGbl00ooAGbl00ol0003o
ded0o`00000Aooooo`03o`000?oooooooooo04?ooooo000/ooooo`;o0000=?ooool00ol0003o>@0Y
ocT0:@07ocT0:@;o00000on1G9h00ol0003oW72Ooia`W`0Goia`W`03o`000?nbP9oo/X2O01?o/X2O
0ol00002ok:0W`03o`000?o5T9ooaI2O01SoaI2O00?o0000omRSW_oHXih00ooHXih2o`0000?odEl_
00?o0000om5O;ooAGbl00ooAGbl01?l0003oded0om=M0?l0000Aooooo`03o`000?oooooooooo04;o
oooo000Yooooo`?o0000=Oooool00ol0003o>@0YocT0:@06ocT0:@;o00001On1G9h00ol0003oW72O
oia`W`0Goia`W`03o`000?nbP9oo/X2O013o/X2O0ol00005ok:0W`03o`000?o5T9ooaI2O01SoaI2O
00?o0000omRSW_oHXih01OoHXih2o`0000;odEl_00?o0000om5O;ooAGbl00ooAGbl01?l0003oded0
om=M0?l0000Aooooo`03o`000?oooooooooo047ooooo000Xooooo`;o0000=_ooool00ol0003o>@0Y
ocT0:@05ocT0:@;o00001on1G9h00ol0003oW72Ooia`W`0Goia`W`03o`000?nbP9oo/X2O00go/X2O
0ol00008ok:0W`03o`000?o5T9ooaI2O01OoaI2O00?o0000omRSW_oHXih02?oHXih4o`0000CodEl_
00Go0000om=M0?oCG@3oded0o`00000@ooooo`03o`000?oooooooooo047ooooo000Xooooo`03o`00
0?oooooo000003Cooooo0_l00005ocT0:@;o00002_n1G9h00ol0003oW72Ooia`W`0Foia`W`03o`00
0?nbP9oo/X2O00[o/X2O0ol0000;ok:0W`03o`000?o5T9ooaI2O01OoaI2O00?o0000omRSW_oHXih0
2ooHXih2o`0000CodEl_00Go0000om=M0?oCG@3oded0o`00000@ooooo`03o`000?oooooooooo043o
oooo000Xooooo`04o`000?ooooooooooo`0003;ooooo0_l00005ocT0:@03o`000?n1G9koPEbN00[o
PEbN00?o0000oia`WonLL9l05_nLL9l00ol0003o/X2Ook:0W`08ok:0W`;o00003_nbP9l00ol0003o
aI2OolF@W`0GolF@W`03o`000?oHXikof:>N00cof:>N0ol00002om5O;`03o`000?oCG@3oded000;o
ded000?o0000ooooooooool03_ooool00ol0003oooooooooo`0oooooo`00:?ooool01Ol0003ooooo
oooooooooooo0000033ooooo0ol00003ocT0:@;o00003On1G9h00ol0003oW72Ooia`W`0Foia`W`03
o`000?nbP9oo/X2O00Go/X2O0ol0000@ok:0W`03o`000?o5T9ooaI2O01OoaI2O00?o0000omRSW_oH
Xih03OoHXih01_l0003of:>No`000?l0003odEl_o`0000Coded000?o0000ooooooooool03Oooool0
0ol0003oooooooooo`0oooooo`009oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
02cooooo0ol00002ocT0:@;o00003on1G9h00ol0003oW72Ooia`W`0Foia`W`03o`000?nbP9oo/X2O
00;o/X2O0ol0000Cok:0W`03o`000?o5T9ooaI2O01OoaI2O00?o0000omRSW_oHXih03_oHXih00ol0
003of:>NomRSWP02o`0000Goded000?o0000ooooooooool03Oooool00ol0003oooooooooo`0noooo
o`009oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02[ooooo0ol000000oli02Wo
0000o`00000Aoh5LWP03o`000?nLL9ooW72O01KoW72O00?o0000ok:0Wol000000_l0000Fok:0W`03
o`000?o5T9ooaI2O01OoaI2O00?o0000omRSW_oHXih03_oHXih00ol0003of:>NomRSWP02omRSWP;o
00001?oCG@000ol0003oooooooooo`0=ooooo`03o`000?oooooooooo03gooooo000Wooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool0:?ooool5o`0001?oPEbN00?o0000oia`WonLL9l0
5OnLL9l3o`0001Wo/X2O00?o0000olF@Woo5T9l05oo5T9l00ol0003of:>NomRSWP0?omRSWP07o`00
0?oHXikof:>NomRSW_l0003okKZLo`000004om=M0003o`000?oooooooooo00cooooo00?o0000oooo
ooooool0?Oooool002Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Vooooo`Co
00005On1G9h00ol0003oW72Ooia`W`0Coia`Wb;o00005_o5T9l00ol0003of:>NomRSWP0@omRSWP04
o`000?oHXikof:>No`0000;okKZL00?o0000om=M0?oCG@000_oCG@000ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo03cooooo000Wooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool09?ooool5o`0001GoPEbN00?o0000oia`WonLL9l04?nLL9l4o`0000;oYYS700?o0000ok>Qa_nc
XLH06?ncXLH01?l0003o_Z_7okj[aonnZlL5o`00017oaI2O00?o0000omRSW_oHXih04?oHXih01?l0
003of:>NomRSW_l00003onfjW005o`000?oCG@3oded0om=M0?l000003oooool00ol0003ooooooooo
o`0kooooo`009oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo02;ooooo1_l0000E
oh5LWP03o`000?nLL9ooW72O00coW72O1?l00006ojJHa`03o`000?ncXLKo/j7601So/j7600?o0000
okj[aonnZlL01_nnZlL5o`0000_oaI2O00?o0000omRSW_oHXih04_oHXih2o`0000GokKZL00Go0000
om=M0?oCG@3oded0o`00000>ooooo`03o`000?oooooooooo03_ooooo000Vooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool08?ooool5o`0000;oE3nK00?o0000oh5LW_n1G9h04on1G9h0
0ol0003oW72Ooia`W`07oia`W`Go00002OnVV<L00ol0003o/j76ok>QaP0Hok>QaP03o`000?nnZlOo
_Z_700_o_Z_71Ol00006olF@W`03o`000?oHXikof:>N01?of:>N00?o0000onfjW?o]^Y`01?o]^Y`0
1?l0003oded0om=M0?l0000?ooooo`03o`000?oooooooooo03[ooooo000Vooooo`03o`000?oooooo
oooo00_ooooo0_l0000Pooooo`Co00000omD?i/00ol0003oPEbNoh5LWP0Coh5LWP03o`000?nLL9oo
W72O00?oW72O1_l0000=ojJHa`03o`000?ncXLKo/j7601Oo/j7600?o0000okj[aonnZlL04?nnZlL5
o`000003olF@Wol0003of:>N01Cof:>N0_l00006onfjW004o`000?oCG@3oded0o`0000oooooo00?o
0000ooooooooool0>Oooool002Kooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0L
ooooo`Co00001?mD?i/00ol0003oPEbNoh5LWP0Coh5LWP03o`000?nLL9oo000000?o000000?oYYS7
o`000?l000004?nVV<L00ol0003o/j76ok>QaP0Fok>QaP03o`000?nnZlOo_Z_701Ko_Z_70ol0000D
omRSWP;o00001oo]^Y`00ol0003oded0o`00000?ooooo`03o`000?oooooooooo03Wooooo000Voooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool06oooool3o`0000GoE3nK00?o0000oh5L
W_n1G9h04_n1G9h3o`0000;oYYS70ol0000BojJHa`03o`000?ncXLKo/j7601Ko/j7600?o0000okj[
aonnZlL05onnZlL01?l0003ob;S:o`000?l0000BomRSWP03o`000?o]^Yco000000OokKZL00?o0000
om=M0?l000003oooool00ol0003oooooooooo`0hooooo`009_ooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo01Wooooo0ol00007oe@oV`03o`000?n1G9koPEbN00ooPEbN0_l000000onH
TL_o0000o`000002o`0001GoYYS700?o0000ok>Qa_ncXLH05_ncXLH00ol0003o_Z_7okj[a`0Fokj[
a`03o`000?o8^<[ob;S:00;ob;S:0ol0000>omRSWP05o`000?o]^YcokKZLonfjW?l000001oo]^Y`0
0ol0003oded0o`00000?ooooo`03o`000?oooooooooo03Oooooo000Vooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool06?ooool3o`0000OoE3nK00?o0000oh5LW_n1G9h03On1G9h2o`00
0003oiRAbol0003o000000;o00005onVV<L00ol0003o/j76ok>QaP0Fok>QaP03o`000?nnZlOo_Z_7
01Ko_Z_700?o0000olRhb_o8^<X01Oo8^<X2o`0000cof:>N00Go0000onfjW?o]^YcokKZLo`000008
onfjW0;o00003oooool00ol0003oooooooooo`0gooooo`009_ooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo01Kooooo0ol00008oe@oV`03o`000?n1G9koPEbN00_oPEbN1Ol00003oiRA
b`03o`000?nVV<OoYYS701GoYYS700?o0000ok>Qa_ncXLH05_ncXLH00ol0003o_Z_7okj[a`0Eokj[
a`03o`000?o8^<[ob;S:00Sob;S:0_l0000:omRSWP03o`000?o]^YcokKZL00;okKZL00?o0000onfj
W?o]^Y`01_o]^Y`2o`0000oooooo00?o0000ooooooooool0=_ooool002Gooooo00?o0000oooooooo
ool04oooool00ol0003oooooooooo`0Dooooo`?o00002OmD?i/00ol0003oPEbNoh5LWP09oh5LWPCo
00001onHTL/00ol0003oYYS7ojJHa`0EojJHa`03o`000?ncXLKo/j7601Go/j7600?o0000okj[aonn
ZlL05OnnZlL00ol0003ob;S:olRhbP0:olRhbP;o00002?oHXih00ol0003okKZLonfjW003onfjW003
o`000?o]^YcokKZL00KokKZL00?o0000ooooooooool03_ooool00ol0003oooooooooo`0eooooo`00
9Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo01?ooooo0_l0000;oe@oV`03o`00
0?n1G9koPEbN00OoPEbN0_l0000:oiRAb`03o`000?nVV<OoYYS701GoYYS700?o0000ok>Qa_ncXLH0
5OncXLH00ol0003o_Z_7okj[a`0Eokj[a`03o`000?o8^<[ob;S:00cob;S:0_l00006omRSWP03o`00
0?o]^YcokKZL00CokKZL00?o0000onfjW?o]^Y`01_o]^Y`00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo03Gooooo000Uooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool04Ooo
ool2o`0000coE3nK00?o0000oh5LW_n1G9h01?n1G9h3o`0000coV97;00?o0000ojJHaonVV<L05OnV
V<L00ol0003o/j76ok>QaP0Eok>QaP03o`000?nnZlOo_Z_701Co_Z_700?o0000olRhb_o8^<X03oo8
^<X3o`0000;of:>N00?o0000onfjW?o]^Y`01Oo]^Y`00ol0003okKZLonfjW006onfjW003o`000?oo
oooooooo00kooooo00?o0000ooooooooool0=?ooool002Gooooo00?o0000ooooooooool05_ooool0
0ol0003oooooooooo`0@ooooo`03o`000?mD?i_oE3nK00_oE3nK00Co0000oh5LW_n1G9koPEbN1?l0
000?oiRAb`03o`000?nVV<OoYYS701CoYYS700?o0000ok>Qa_ncXLH05OncXLH00ol0003o_Z_7okj[
a`0Dokj[a`03o`000?o8^<[ob;S:01;ob;S:0ol00008onfjW003o`000?o]^YcokKZL00GokKZL0_l0
000@ooooo`03o`000?oooooooooo03?ooooo000Uooooo`03o`000?oooooooooo01Oooooo00?o0000
ooooooooool03_ooool00ol0003oE3nKoe@oV`0<oe@oV`Ko00004OnHTL/00ol0003oYYS7ojJHa`0D
ojJHa`03o`000?ncXLKo/j7601Co/j7600?o0000okj[aonnZlL05?nnZlL00ol0003ob;S:olRhbP0E
olRhbP;o00002?o]^Y`00ol0003okKZLonfjW003onfjW003o`000?ooeY3o0000013ooooo00?o0000
ooooooooool0<oooool002Gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0=oooo
o`03o`000?mD?i_oE3nK00[oE3nK1_l0000DoiRAb`03o`000?nVV<OoYYS701?oYYS700?o0000ok>Q
a_ncXLH05?ncXLH00ol0003o_Z_7okj[a`0Dokj[a`03o`000?o8^<[ob;S:01Gob;S:00?o0000om;7
col000002?o]^Y`00ol0003okKZLonfjW002onfjW003o`000?ooeY3o0000017ooooo00?o0000oooo
ooooool0<_ooool002Cooooo00?o0000ooooooooool06_ooool2o`0000cooooo0_l0000:oe@oV`;o
00000_mD?i/2o`0001KoV97;00?o0000ojJHaonVV<L05?nVV<L00ol0003o/j76ok>QaP0Cok>QaP03
o`000?nnZlOo_Z_701?o_Z_700?o0000olRhb_o8^<X05Oo8^<X01Ol0003od/O?om;7cooBaloo0000
00OokKZL00?o0000onfjW?o]^Y`00_o]^Y`01?l0003oomJ@oooFT?l0000Aooooo`03o`000?oooooo
oooo037ooooo000Tooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool02Oooool00ol0
003o00R;o`000006oe@oV`?o00000omD?i/00ol0003oQX_@o`00000GoiRAb`03o`000?nVV<OoYYS7
01?oYYS700?o0000ok>Qa_ncXLH04oncXLH00ol0003o_Z_7okj[a`0Cokj[a`03o`000?o8^<[ob;S:
01Cob;S:00?o0000om;7cooBall00ooBall00ol0003okKZLonfjW005onfjW005o`000?o]^YcokKZL
onfjW?l000000_ooeY000ol0003oooooooooo`0?ooooo`03o`000?oooooooooo037ooooo000Toooo
o`03o`000?oooooooooo01gooooo00?o0000ooooooooool02?ooool00ol0003o00R;o`000003oe@o
V`?o00001OmD?i/01Ol0003oQX_@ohJ;d?n6Rm3o000001KoV97;00?o0000ojJHaonVV<L04OnVV<LL
o`0001;o_Z_700?o0000olRhb_o8^<X05?o8^<X00ol0003od/O?om;7c`04om;7c`03o`000?o]^Yco
kKZL00GokKZL00Co0000onfjW?o]^Yco00000oooeY000ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo033ooooo000Tooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool01_ooool0
0ol0003o00R;o`08R`04o`0000OoE3nK00?o0000ohJ;d?n6Rm000on6Rm000ol0003oV97;oiRAb`0C
oiRAb`03o`000?nVV<OoYYS700coYYS71Ol00002ojG2kP03o`000?nU`^koYL;^01?oYL;^00Co0000
ojG2k_nU`^koYL;^1ol0000:okj[a`03o`000?o8^<[ob;S:01Cob;S:00?o0000om;7cooBall01_oB
all00ol0003okKZLonfjW004onfjW003o`000?o]^Yco000000CoomJ@00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`0_ooooo`009?ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooo
oooo00Gooooo1?l00009oe@oV`03o`000?n6Rm3oQX_@00GoQX_@00?o0000oiRAbonHTL/04onHTL/0
0ol0003oYYS7ojJHa`06ojJHa`Go00002?nU`^h00ol0003oYL;^ojG2kP0BojG2kP03o`000?nU`^ko
YL;^00SoYL;^1ol00003okj[a`03o`000?o8^<[ob;S:01?ob;S:00?o0000om;7cooBall02?oBall2
o`0000GokKZL0_l00004oooFT003o`000?oooooooooo013ooooo00?o0000ooooooooool0;oooool0
02Cooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`03ooooo`;o00000_l028/00ol0
003oE3nKoe@oV`06oe@oV`03o`000?n6Rm3oQX_@00KoQX_@00?o0000oiRAbonHTL/04onHTL/01?l0
003oYYS7ojJHaonVV<L5o`0000goYL;^00?o0000ojG2k_nU`^h04OnU`^h00ol0003oYL;^ojG2kP0@
ojG2kPCo00005Oo8^<X00ol0003od/O?om;7c`0:om;7c`03o`000?o]^YcokKZL00?okKZL00?o0000
oooFT?ooeY000oooeY000ol0003oooooooooo`0@ooooo`03o`000?oooooooooo02kooooo000Soooo
o`03o`000?oooooooooo02;ooooo00?o0000ooooool000000ol00004o`08R`03o`000?mD?i_oE3nK
00CoE3nK00?o0000ohJ;d?n6Rm002?n6Rm000ol0003oV97;oiRAb`0CoiRAb`?o00004_nU`^h00ol0
003oYL;^ojG2kP0AojG2kP03o`000?nU`^koYL;^01;oYL;^00Co0000ojG2k_l0003o00004_o8^<X0
0ol0003od/O?om;7c`0<om;7c`03o`000?o]^YcokKZL00;okKZL0_l00004oooFT003o`000?oooooo
oooo017ooooo00?o0000ooooooooool0;Oooool002?ooooo00?o0000ooooooooool08Oooool3o`00
00?ooooo00?o0000o`08Rol028/00_l028/00ol0003oE3nKoe@oV`03oe@oV`03o`000?n6Rm3oQX_@
00[oQX_@00?o0000oiRAbonHTL/03onHTL/2o`0000;oYL;^00?o0000ojG2k_nU`^h04_nU`^h00ol0
003oYL;^ojG2kP0@ojG2kP03o`000?nU`^koYL;^017oYL;^00?o0000ojG2k_nU`^h00_nU`^h2o`00
00oob;S:00?o0000om;7cooBall03_oBall01?l0003okKZLonfjW?o]^Y`2o`0000GoomJ@00?o0000
ooooooooool04?ooool00ol0003oooooooooo`0]ooooo`008oooool00ol0003oooooooooo`0Noooo
o`?o00000oooool01?l0003oooooooooool00004o`08R`03o`000?mD?i_oE3nK00;oE3nK00?o0000
ohJ;d?n6Rm002on6Rm000ol0003oV97;oiRAb`0=oiRAb`;o00001OnU`^h00ol0003oYL;^ojG2kP0A
ojG2kP03o`000?nU`^koYL;^00ooYL;^00?o0000ojG2k_nU`^h04OnU`^h00ol0003oYL;^ojG2kP05
ojG2kP;o00003Oo8^<X00ol0003od/O?om;7c`0?om;7c`03o`000?o]^Yco000000;oomJ@00?o0000
oooFT?ooeY000_ooeY000ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02cooooo000Soooo
o`03o`000?oooooooooo01_ooooo0ol00007ooooo`;o00001Ol028/01Ol0003oE3nKoe@oVomD?i_o
000000ooQX_@00?o0000oiRAbonHTL/02_nHTL/2o`0000SoYL;^00?o0000ojG2k_nU`^h04?nU`^h0
0ol0003oYL;^ojG2kP0?ojG2kP03o`000?nU`^koYL;^013oYL;^00?o0000ojG2k_nU`^h02?nU`^h3
o`0000Wob;S:00?o0000om;7cooBall04OoBall2o`0000?oomJ@00Go0000oooFT?ooeY3oomJ@o`00
000Dooooo`03o`000?oooooooooo02_ooooo000Sooooo`03o`000?oooooooooo01Wooooo0_l0000;
ooooo`03o`000?l028_o00R;00?o00R;00Co0000oe@oVomD?i_o00004On6Rm000ol0003oV97;oiRA
b`07oiRAb`;o00002onU`^h00ol0003oYL;^ojG2kP0@ojG2kP03o`000?nU`^koYL;^00koYL;^00?o
0000ojG2k_nU`^h03onU`^h00ol0003oYL;^ojG2kP0<ojG2kP;o00001_o8^<X00ol0003od/O?om;7
c`0Bom;7c`;o00000oooeY000ol0003oomJ@oooFT002oooFT003o`000?oooooooooo017ooooo00?o
0000ooooooooool0:oooool002?ooooo00?o0000ooooooooool05_ooool3o`0000gooooo00?o0000
o`08Rol028/01?l028/2o`0001?oQX_@00?o0000oiRAbonHTL/01?nHTL/2o`0000koYL;^00?o0000
ojG2k_nU`^h03onU`^h00ol0003oYL;^ojG2kP0=ojG2kP03o`000?nU`^koYL;^013oYL;^00?o0000
ojG2k_nU`^h03_nU`^h2o`0000Cob;S:00?o0000om;7cooBall04OoBall00ol0003ofMWGo`000004
oooFT005o`000?ooeY3oomJ@oooFT?l000005?ooool00ol0003oooooooooo`0Zooooo`008oooool0
0ol0003oooooooooo`0Cooooo`?o00003oooool00ol0003o00R;o`08R`05o`08R`;o00004on6Rm00
0ol0003oV97;oiRAb`02oiRAb`;o00004OnU`^h00ol0003oYL;^ojG2kP0>ojG2kP03o`000?nU`^ko
YL;^00KoYL;^2ol0000>ojG2kP03o`000?nU`^koYL;^017oYL;^0_l000000oo8^<[o0000om;7c`0B
om;7c`05o`000?oIfMOofMWGomWIeol000001?ooeY001?l0003oomJ@oooFT?l0000Eooooo`03o`00
0?oooooooooo02Wooooo000Rooooo`03o`000?oooooooooo017ooooo0ol0000Booooo`03o`000?l0
28_o00R;00Go00R;00?o0000ofj5f?l000004on6Rm001?l0003oV97;o`000?l0000DojG2kP03o`00
0?nU`^koYL;^00coYL;^00?o0000ojG2k_l000001ol00005o`RJ^P_o00002?nU`^h00ol0003oYL;^
ojG2kP0CojG2kP?o00004_oBall00ol0003ofMWGomWIe`02omWIe`03o`000?ooeY3oomJ@00?oomJ@
0ol0000Eooooo`03o`000?oooooooooo02Wooooo000Rooooo`03o`000?oooooooooo00kooooo0ol0
000Eooooo`03o`000?l028_o00R;00Go00R;00Co0000ofj5f?m^QMSo00004on6Rm000ol0003oYL;^
ojG2kP0EojG2kP03o`000?nU`^koYL;^00KoYL;^1Ol00002ocVna@03o`000?oooooooooo013ooooo
2_l00002ojG2kP03o`000?nU`^koYL;^01;oYL;^0_l00003ojG2kP03o`000?oBalood/O?00kod/O?
00?o0000omWIeooIfML00ooIfML00ol0003oomJ@oooFT003oooFT0?o00005_ooool00ol0003ooooo
ooooo`0Xooooo`008_ooool00ol0003oooooooooo`0;ooooo`?o00006?ooool00ol0003o00R;o`08
R`04o`08R`03o`000?m^QMSoKXGH00;oKXGH00?o0000ohJ;d?n6Rm003on6Rm000ol0003oYL;^ojG2
kP02o`0001GoYL;^00?o0000ojG2k_nU`^h01Ol000000oli_/Go0000o`00000Mooooo`;o000000?o
087Io`000?l000000_l0000BojG2kP;o00001_nU`^h00ol0003od/O?om;7c`0<om;7c`03o`000?oI
fMOofMWG00GofMWG00?o0000oooFT?ooeY000oooeY000ol0003oooooooooo`0Fooooo`03o`000?oo
oooooooo02Oooooo000Rooooo`03o`000?oooooooooo00Wooooo0_l0000Looooo`03o`000?l028_o
00R;00?o00R;00?o0000ofj5f?m^QMP00om^QMP00ol0003oQX_@ohJ;d00=ohJ;d003o`000?nU`^ko
YL;^00?oYL;^0_l0000DojG2kP;o000000Co>Kk5o`000?mki]co00008oooool3o`0000;o087I0ol0
000=ojG2kP;o00002OnU`^h00ol0003od/O?om;7c`0:om;7c`03o`000?oIfMOofMWG00KofMWG00?o
0000oooFT?ooeY000_ooeY03o`0001Oooooo00?o0000ooooooooool09oooool002;ooooo00?o0000
ooooooooool01_ooool3o`0001kooooo00?o0000o`08Rol028/00ol028/00ol0003oKXGHofj5f004
ofj5f003o`000?n6Rm3oQX_@00_oQX_@00?o0000ojG2k_nU`^h01_nU`^h2o`0000koYL;^0ol00003
og_Vg0;o0000:?ooool2o`0000?o087I0_l0000:ojG2kP03o`000?nU`^koYL;^00[oYL;^0_l00009
om;7c`03o`000?oIfMOofMWG00OofMWG00?o0000oooFT?ooeY000_ooeY03o`0001Sooooo00?o0000
ooooooooool09_ooool002;ooooo00?o0000ooooooooool00oooool3o`00027ooooo00?o0000o`08
Rol028/00_l028/00ol0003oKXGHofj5f006ofj5f003o`000?n6Rm3oQX_@00WoQX_@00?o0000ojG2
k_nU`^h02OnU`^h2o`0000[oYL;^0_l00005og_Vg003o`000?oooooooooo02Wooooo1Ol000000ol0
PMWo0000o`000006ojG2kP;o00003onU`^h00ol0003od/O?om;7c`05om;7c`03o`000?oIfMOofMWG
00WofMWG00Co0000oooFT?ooeY3oomJ@0_l000000ooooooo0000ooooo`0Eooooo`?o00009oooool0
027ooooo00Co0000oooooooooooooooo0ol0000Tooooo`;o00000ol028/00ol0003oKXGHofj5f007
ofj5f003o`000?n6Rm3oQX_@00OoQX_@00?o0000ojG2k_nU`^h03?nU`^h2o`0000KoYL;^0_l00002
og_Vg0Co000000?oiX51o`000?ooool0:?ooool2o`0000;o7@0i00?o0000oaf3j?l000001_l00000
0onU`^ko0000o`00000BojG2kP03o`000?oBalood/O?00?od/O?00?o0000omWIeooIfML02_oIfML0
1?l0003oomJ@oooFT?ooeY02o`0000;ooooo00?o0000ooooooooool04?ooool3o`0000;ooooo00?o
0000ooooooooool09Oooool0027ooooo1?l0000Wooooo`;o00000ol028/00ol0003oKXGHofj5f008
ofj5f003o`000?n6Rm3oQX_@00GoQX_@00?o0000ojG2k_nU`^h03onU`^h2o`000005ojG2k_l0003o
0000o`000?mki]`00ol00002okCjj@04o`000?oVPD7oiX51onJ1@@;o00009Oooool2o`000003of@J
FOlM03Wo7@0i00;o7@0i00?o0000oaf3j?lMPnP00olMPnP4o`0001CoYL;^00Go0000om;7cooBaloo
d/O?o`00000=omWIe`06o`000?ooeY3oomJ@o`000?oDce;o00000oooool00ol0003oooooooooo`0;
ooooo`Co00001Oooool00ol0003oooooooooo`0Uooooo`008Oooool2o`0002[ooooo00Go0000o`08
Rol028_o00R;o`00000;ofj5f003o`000?n6Rm3oQX_@00?oQX_@00?o0000ojG2k_nU`^h04_nU`^h0
0ol0003oNnKLo`000005okCjj@?o00000ooVPD400ol0003odgELo`000002o`00027ooooo00Co0000
of@JFOmT6UWoI1YI1?lM03T2o`0000So7H?X00?o0000ojG2k_nU`^h04_nU`^h00ol0003od/O?o`00
000?omWIe`05o`000?ooeY3o0000omC?D_l000000oooool00ol0003oooooooooo`08ooooo`?o0000
2Oooool00ol0003oooooooooo`0Uooooo`008oooool00ol0003oooooooooo`0Wooooo`;o000000?o
00R;o`000?m^QMP03?m^QMP01Ol0003oQX_@ohJ;d?n6Rm3o000001?oYL;^00?o0000okCjjOndn^T0
1_ndn^T01?l0003onnNEo`000?l00003onJ1@@03o`000?nY_^SodgEL00;odgEL0ol0000Looooo`;o
00000omT6UT00ol0003o7@0ioad0>@02oad0>@?o00002?lMPnP00ol0003oYL;^ojG2kP0@ojG2kP?o
00004?oIfML01?l0003oomJ@o`000?l00005ooooo`03o`000?oooooooooo00Cooooo0ol0000<oooo
o`03o`000?oooooooooo02Gooooo000Tooooo`03o`000?oooooooooo02Kooooo0_l000000ol028_o
0000ofj5f00=ofj5f003o`000?n6Rm3o000001?oYL;^00?o0000okCjjOndn^T01_ndn^T01_l0003o
nnNEoo_WUOl0003ofWL0o`0000?oiX5100?o0000om=eG?oCME`01?oCME`5o`0001;ooooo1Ol00005
of@JF@04o`000?lM03Wo7@0ioad0>@;o000000?o?3RSo`000?l000000_l00006oaf3j003o`000?nU
`^koYL;^00coYL;^0ol00002ojG2kP03o`000?oIfMOofMWG00kofMWG0_l000000ooDce;o0000oooo
o`05ooooo`03o`000?oooooo000000?o00004?ooool00ol0003oooooooooo`0Tooooo`009Oooool0
0ol0003oooooooooo`0Uooooo`;o000000?o00R;o`000?m^QMP03_m^QMP00ol0003oYL;^ojG2kP0A
ojG2kP03o`000?ndn^Wo]?[Y00Co]?[Y0ol00002oo_WU@04o`000?oecJCo0000o`0000?oiX5100?o
0000om=eG?oCME`01?oCME`00ol0003o_FIVokeVIP0Do`0000CoS3eU1_mT6UT01Ol0003o7@0ioad0
>OlM03Wo000000;o?3RS0_l00002odB5j0?o00001?lMPnP00ol0003oYL;^ojG2kP08ojG2kP?o0000
1_nU`^h00ol0003ofMWGomWIe`0=omWIe`;o000000?oe<mBo`000?ooool01?ooool3o`0001Cooooo
00?o0000ooooooooool09?ooool002Kooooo0_l0000Uooooo`03o`000?l0047o0000013oKXGH00?o
0000ojG2k_nU`^h01?l0000<ojG2kP03o`000?ndn^Wo]?[Y00;o]?[Y0ol00002om7di`04o`000?ok
iiGonnNEo`0000;omLfT00Oo0000onJ1@OoVPD7oiX51o`000?oCMEcoZKkX00CodgEL00?o0000okeV
I_nmIVH01OnmIVH6o`0000CoYeAY2On<?FD00ol0003oI1YIof@JF@02of@JF@04o`000?lM03Wo7@0i
oad0>@;o00000_ll>:<00ol0003o002?o`000004odB5j0?o00000_lMPnP00ol0003oYL;^ojG2kP04
ojG2kP?o00002OnU`^h00ol0003ofMWGomWIe`0<omWIe`06o`000?oJk^3o0000omC?D_l0003ooooo
1?l00002ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool09?ooool002Sooooo00?o
0000ooooooooool08oooool3o`0000koKXGH00?o0000ojG2k_nU`^h01OnU`^h4o`0000OoYL;^00?o
0000okCjjOndn^T00ol00004om7di`05o`000?okiiGonnNEoo_WUOl000000ooecJ@2o`0000;oiX51
00?o0000om=eG?nY_^P01?oCME`00ol0003o_FIVokeVIP05okeVIPWoYeAY00?o0000oh`mIOn<?FD0
1On<?FD00ol0003oI1YIof@JF@03of@JF@03o`000?lM03Wo7@0i00;o00001?ll>:<00ol0003o002?
o`000006odB5j0Co00000_nU`^h3o`0000goYL;^00?o0000omWIeooIfML02OoIfML2o`0000;of^kP
00Co0000omC?D_l0003o00001oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo02Co
oooo000Yooooo`03o`000?oooooooooo02;ooooo0_l000000om<O^7o0000ofj5f00<ofj5f003o`00
0?nU`^koYL;^00WoYL;^1?l00002ojG2kP04o`000?ndn^Wo0000o`0000OodOCW00Co0000oo_WUOok
iiGo00001?oecJ@01Ol0003ohkBUo`000?oVPD7o000000KodgEL00?o0000okeVI_nmIVH01OnmIVH0
0ol0003oYeAYojMDJ@06ojMDJ@03o`000?n<?FGoS3eU00GoS3eU00?o0000of@JFOmT6UT00omT6UT3
o`000003ofiFYOl0003o?3RS00?o?3RS00?o0000o`00Sol000002Om4QNP3o`00013oYL;^00?o0000
omWIeooIfML02?oIfML00ol0003of^kPom[^h002om[^h0;o00002_ooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo02Cooooo000Zooooo`03o`000?oooooooooo027ooooo0_l00002odan
h@;o00002om^QMP00ol0003oYL;^ojG2kP0=ojG2kP?o00002_oAm>L01?l0003onnNEoo_WUOl00003
ooG=Y004o`000?oS]:GohkBUon>dY@;o00001_oCME`00ol0003o_FIVokeVIP05okeVIP03o`000?nW
E6WoYeAY00KoYeAY00?o0000oh`mIOn<?FD01On<?FD00ol0003oI1YIof@JF@02of@JF@;o00001?m^
EZD00ol0003o?3RSoc`hX`02oc`hX`03o`000?l008oo000000WoA8GX00?o0000ojG2k_nU`^h04?nU
`^h00ol0003ofMWGomWIe`05omWIe`;o00001?oJk^000ol0003oe<mBo`00000:ooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool09?ooool002_ooooo00?o0000ooooooooool08Oooool2
o`0000?oC7kQ00?o0000ofj5f?m^QMP01om^QMP00ol0003oYL;^ojG2kP0?ojG2kP03o`000?oAm>Oo
dOCW00OodOCW0_l00002oo_WU@03o`000?oecJComLfT00;omLfT00?o0000on>dYOoS]:D00_oS]:D2
o`0000GodgEL00?o0000okeVI_nmIVH01OnmIVH00ol0003oYeAYojMDJ@06ojMDJ@03o`000?n<?FGo
S3eU00GoS3eU00Co0000of@JFOmT6UWoI1YI0_l00005ofiFY@03o`000?ll>:?o?3RS00;o?3RS00Co
0000o`00Sol0003oI8KO0_l00007odB5j003o`000?nU`^koYL;^00ooYL;^00?o0000omWIeooIfML0
1?oIfML00ol0003of^kPom[^h004om[^h003o`000?oDce;o000000_ooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`0Tooooo`00;?ooool2o`00027ooooo0_l00004odanh@;o00001om^
QMP00ol0003oYL;^ojG2kP0>ojG2kP03o`000?oAm>OodOCW00KodOCW0_l000001OoIhmgo0000oo_W
UOokiiGo000000ComLfT00?o0000on>dYOoS]:D00ooS]:D2o`0000CodgEL00?o0000okeVI_nmIVH0
1OnmIVH00ol0003oYeAYojMDJ@05ojMDJ@03o`000?n<?FGoS3eU00KoS3eU00Ko0000of@JFOl0003o
0000ohaXY?l00005ofiFY@03o`000?ll>:?o?3RS00;o?3RS00?o0000o`00Sol000000omTQ]l2o`00
00GoA8GX00?o0000ojG2k_nU`^h03onU`^h00ol0003ofMWGomWIe`03omWIe`03o`000?oJk^3of^kP
00Gof^kP0_l0000=ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool09?ooool002ko
oooo00?o0000ooooooooool07_ooool2o`0000KoC7kQ00?o0000ofj5f?m^QMP01?m^QMP00ol0003o
YL;^ojG2kP0>ojG2kP03o`000?oAm>OodOCW00CodOCW0_l00003omWSg@04o`000?okiiGonnNEo`00
00?omLfT00?o0000on>dYOoS]:D01?oS]:D00ol0003odZ6To`000002o`0000;odgEL00?o0000okeV
I_nmIVH01?nmIVH00ol0003oYeAYojMDJ@05ojMDJ@03o`000?n<?FGoS3eU00GoS3eU0ol00003ohaX
Y003o`000?m^EZGoKUJU00CoKUJU00?o0000oc`hXoll>:<00_ll>:<2o`0000GoI8KO0_l00004odB5
j003o`000?nU`^koYL;^00ooYL;^00?o0000omWIeooIfML00_l00008om[^h0;o00003_ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo02?ooooo000_ooooo`03o`000?oooooooooo01ko
oooo00?o0000odanhOm<O^401Om<O^400ol0003oKXGHofj5f002ofj5f003o`000?nU`^koYL;^00oo
YL;^00?o0000om7diooAm>L00_oAm>L2o`0000GofN?M00?o0000oo_WUOl000001?oecJ@00ol0003o
hkBUon>dY@04on>dY@03o`000?oBXJCodZ6T00;odZ6T0ol00006okeVIP03o`000?nWE6WoYeAY00Go
YeAY00?o0000oh`mIOn<?FD00on<?FD3o`0000KoS6RT00?o0000ofiFYOm^EZD00om^EZD00ol0003o
?3RSoc`hX`02oc`hX`;o00001omTQ]l2o`0000;oA8GX00?o0000ojG2k_nU`^h03onU`^h00ol0003o
fMWGo`00000:om[^h0;o00003_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo02?o
oooo000`ooooo`03o`000?oooooooooo01gooooo0_l00007odanh@;o00000_m^QMP00ol0003oYL;^
ojG2kP0>ojG2kP04o`000?oAm>OodOCWom7di`;o00002?oIhmd2o`0000ComLfT00?o0000on>dYOoS
]:D00ooS]:D00ol0003odZ6Tom:QY005om:QY0Go00000_nmIVH00ol0003oYeAYojMDJ@05ojMDJ@03
o`000?n<?FGo000000?o00000_nQMj<7ohaXY003o`000?m^EZGoKUJU00CoKUJU00Co0000oc`hXoll
>:?o?3RS0_l00009ofB6g`;o000000?oA8GXo`000?nU`^h03?nU`^h5o`0000_of^kP00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo02?ooooo000aooooo`;o
00007Oooool2o`0000WoC7kQ00?o0000ofj5f?l000004?nU`^h01?l0003odOCWo`000?l0000:omWS
g@;o00000ooecJ@00ol0003ohkBUon>dY@04on>dY@03o`000?oBXJCodZ6T00GodZ6T00?o0000ol:A
Xoo2TJ<00_o2TJ<<o`0000KoXGNS00?o0000ohaXY?n<J:@01?n<J:@00ol0003oKUJUofiFY@04ofiF
Y@03o`000?ll>:?o?3RS00;o?3RS00?o0000ofB6gomTQ]l02OmTQ]l2o`0000CoYL;^2Ol00004ojG2
kP03o`000?oJk^3of^kP00Wof^kP00?o0000ooooooooool03oooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo02?ooooo000cooooo`03o`000?oooooooooo01_ooooo00?o0000odanhOm<
O^402?m<O^4:o`0000SoYL;^0_l0000;omWSg@;o00001?oecJ@00ol0003ohkBUon>dY@04on>dY@03
o`000?oBXJCodZ6T00GodZ6T00?o0000ol:AXoo2TJ<01?o2TJ<8ok:4X`SoXGNS00?o0000ohaXY?n<
J:@01?n<J:@00ol0003oKUJUofiFY@04ofiFY@03o`000?ll>:?o?3RS00;o?3RS00?o0000og^9eOl0
00002omTQ]l4o`0000goYL;^00?o0000om[^h?oJk^002?oJk^02o`00017ooooo00?o0000oooooooo
ool03?ooool00ol0003oooooooooo`0Sooooo`00=?ooool00ol0003oooooooooo`0Jooooo`03o`00
0?m<O^7oC7kQ00SoC7kQ00?o0000ojG2k_nU`^h01onU`^h8o`0000cofN?M00?o0000omK@e?l00000
1?oecJ@00ol0003ohkBUon>dY@04on>dY@03o`000?oBXJCodZ6T00GodZ6T00?o0000ol:AXoo2TJ<0
1?o2TJ<00ol0003o/XBSok:4X`05ok:4X`03o`000?nQMj?oXGNS00GoXGNS00?o0000ohaXY?n<J:@0
1On<J:@00ol0003oKUJUofiFY@04ofiFY@04o`000?ll>:?o?3RSo`0000?oNhWE0_l00009ofB6g`03
o`000?nU`^koYL;^00koYL;^00?o0000om[^h?oJk^002?oJk^000ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool08oooool003Gooooo00?o0000ooooooooool0
6Oooool00ol0003oC7kQodanh@08odanh@03o`000?nU`^koYL;^00koYL;^00?o0000omWSgOoIhmd0
2?oIhmd2o`0000?oe]3D00Co0000ooG=Y?oecJCo00001_oS]:D00ol0003odZ6Tom:QY006om:QY003
o`000?o2TJ?o`Y6S00Co`Y6S00?o0000ok:4XonbQ:<01OnbQ:<00ol0003oXGNSoj5gX`06oj5gX`03
o`000?n<J:CoS6RT00CoS6RT00?o0000ofiFYOm^EZD01?m^EZD00ol0003o?3RSo`000006og^9e@03
o`000?mTQ]ooI8KO00KoI8KO00?o0000ojG2k_nU`^h03_nU`^h00ol0003of^kPom[^h007om[^h0;o
00005?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02?ooooo000fooooo`03o`00
0?oooooooooo01Wooooo00?o0000odanhOm<O^401om<O^400ol0003oYL;^ojG2kP0>ojG2kP03o`00
0?oIhmgofN?M00OofN?M00?o0000omK@e?oFd=@01?oFd=@00ol0003omLfTo`000006on>dY@03o`00
0?oBXJCodZ6T00GodZ6T00?o0000ol:AXoo2TJ<01Oo2TJ<00ol0003o/XBSok:4X`05ok:4X`03o`00
0?nQMj?oXGNS00KoXGNS00?o0000ohaXY?n<J:@01?n<J:@00ol0003oKUJUofiFY@04ofiFY@03o`00
0?ll>:?o000000OoNhWE0_l00006ofB6g`03o`000?nU`^koYL;^00koYL;^00?o0000om[^h?oJk^00
1OoJk^02o`000003olWmhol0003ooooo01Cooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`0Sooooo`00=oooool2o`0001Wooooo0_l00009odanh@03o`000?nU`^koYL;^00goYL;^00?o
0000omWSgOoIhmd01OoIhmd2o`0000Ooe]3D00?o0000ooG=Y?l000001_oS]:D00ol0003odZ6Tom:Q
Y005om:QY003o`000?o2TJ?o`Y6S00Go`Y6S00?o0000ok:4XonbQ:<01OnbQ:<00ol0003oXGNSoj5g
X`06oj5gX`03o`000?n<J:CoS6RT00GoS6RT00?o0000ofiFYOm^EZD00om^EZD2o`0000[oNhWE0_l0
0004ofB6g`03o`000?nU`^koYL;^00goYL;^00?o0000om[^h?oJk^001OoJk^001?l0003obOgSolWm
hol0000Fooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool08_ooool003Wooooo00?o
0000ooooooooool05_ooool01?l0003o6WCRo`000?l00007odanh@03o`000?nU`^koYL;^00goYL;^
00?o0000omWSgOoIhmd00ooIhmd2o`0000[oe]3D0_l00005on>dY@03o`000?oBXJCodZ6T00KodZ6T
00?o0000ol:AXoo2TJ<01Oo2TJ<00ol0003o/XBSok:4X`05ok:4X`03o`000?nQMj?oXGNS00KoXGNS
00?o0000ohaXY?n<J:@01On<J:@00ol0003oKUJUofiFY@02ofiFY@04o`000?n=SLkoSHg>o`0000_o
NhWE00Go0000ofB6gomTQ]ooI8KOo`00000?ojG2kP03o`000?oJk^3of^kP00?of^kP0_l00002olWm
h`03o`000?oooooooooo01Kooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Roooo
o`00>_ooool00ol0003oooooooooo`0Fooooo`04o`000?lJM>;o6WCRo`0000KoC7kQ00?o0000ojG2
k_nU`^h03_nU`^h01Ol0003ofN?MomWSgOoIhmgo000000coe]3D00?o0000olo1cOl000001?oS]:D0
0ol0003odZ6Tom:QY006om:QY003o`000?o2TJ?o`Y6S00Go`Y6S00?o0000ok:4XonbQ:<01OnbQ:<0
0ol0003oXGNSoj5gX`06oj5gX`03o`000?n<J:CoS6RT00GoS6RT00Go0000ofiFYOm^EZGoKUJUo`00
0004ohf=cP03o`000?mkRMGoNhWE00WoNhWE0_l000000omTQ]oo0000ojG2kP0>ojG2kP04o`000?oJ
k^3of^kPom[^h0;o00001?o9oN<00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool08_ooool003_ooooo00?o0000ooooooooool05_ooool00ol0003o6WCRoaYd
hP02o`0000CoC7kQ00?o0000ojG2k_nU`^h03_nU`^h01?l0003ofN?MomWSgOl0000<omK@e005o`00
0?o?`Lgocl7=olo1cOl000000ooS]:D00ol0003odZ6Tom:QY006om:QY003o`000?o2TJ?o`Y6S00Go
`Y6S00?o0000ok:4XonbQ:<01_nbQ:<00ol0003oXGNSoj5gX`05oj5gX`03o`000?n<J:CoS6RT00Go
S6RT00Co0000ofiFYOm^EZGo00001_n=SLh00ol0003oNhWEog^9e@0:og^9e@;o00003onU`^h01?l0
003of^kPom[^h?l00005olWmh`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0Rooooo`00??ooool2o`0001Oooooo00Co0000oaYdh_lJM>;o6WCR0_l00002
odanh@03o`000?nU`^koYL;^00koYL;^00?o0000omWSgOoFd=@03?oFd=@00ol0003ocl7=olo1c@03
olo1c@04o`000?oS]:GohkBUo`0000SodZ6T00?o0000ol:AXoo2TJ<01Oo2TJ<00ol0003o/XBSok:4
X`06ok:4X`03o`000?nQMj?oXGNS00GoXGNS00?o0000ohaXY?n<J:@01_n<J:@2o`0000SoSHg>00?o
0000og^9eOmkRMD02_mkRMD9o`0000OoYL;^00?o0000om[^h?l000001_o9oN<00ol0003ooooooooo
o`0Iooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool08_ooool003kooooo00?o0000
ooooooooool05Oooool00ol0003o6WCRoaYdhP02oaYdhP04o`000?m<O^7oC7kQo`0000_oYL;^1Ol0
000=omK@e003o`000?o?`Lgocl7=00Gocl7=0_l00009om:QY003o`000?o2TJ?o`Y6S00Go`Y6S00?o
0000ok:4XonbQ:<01_nbQ:<00ol0003oXGNSoj5gX`06oj5gX`03o`000?n<J:CoS6RT00CoS6RT0_l0
000:ohf=cP03o`000?mkRMGoNhWE00WoNhWE00?o0000ojG2k_nU`^h01_nU`^h8o`0000OobOgS00?o
0000ooooooooool06oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo02;ooooo000o
ooooo`03o`000?oooooooooo01Gooooo00?o0000oaYdh_lJM>800_lJM>83o`0000?oYL;^2?l00004
ojG2kP03o`000?oFd=Coe]3D00[oe]3D00?o0000olo1cOo?`Ld01oo?`Ld3o`0000KodZ6T00?o0000
ol:AXoo2TJ<01_o2TJ<00ol0003o/XBSok:4X`06ok:4X`03o`000?nQMj?oXGNS00KoXGNS00Co0000
ohaXY?n<J:CoS6RT0ol000000onLT/So0000ohf=cP0:ohf=cP03o`000?mkRMGoNhWE00OoNhWE00?o
0000ojG2k_nU`^h03_nU`^h00ol0003obOgSolWmh`04olWmh`03o`000?oooooooooo01gooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`0Rooooo`00@?ooool00ol0003oooooooooo`0D
ooooo`03o`000?lJM>;o6WCR00Co6WCR1?l0000=ojG2kP03o`000?oFd=Coe]3D00Soe]3D00?o0000
olo1cOo?`Ld02?o?`Ld00ol0003oa[?8olJcb003o`0000?odZ6T00?o0000ol:AXoo2TJ<01_o2TJ<0
0ol0003o/XBSok:4X`06ok:4X`03o`000?nQMj?oXGNS00KoXGNS1?l00005oibBb003o`000?n=SLko
SHg>00WoSHg>00?o0000og^9eOmkRMD01OmkRMD00ol0003oYL;^ojG2kP0>ojG2kP03o`000?o9oN?o
bOgS00GobOgS00?o0000ooooooooool07Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo02;ooooo0011ooooo`;o00005Oooool00ol0003o6WCRoaYdhP03oaYdhP03o`000?nU`^koYL;^
00ooYL;^00?o0000omK@e?oFd=@01_oFd=@00ol0003ocl7=olo1c@08olo1c@03o`000?o6/lSoa[?8
00Coa[?81?l00008ol:AX`03o`000?nbQ:?o/XBS00Ko/XBS00?o0000oj5gXonQMj<01?nQMj<3o`00
00WoW9;800?o0000ohf=c_n=SLh02On=SLh00ol0003oNhWEog^9e@04og^9e@03o`000?nU`^koYL;^
00goYL;^00?o0000olWmhoo9oN<01Oo9oN<00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool08_ooool004?ooooo00?o0000ooooooooool04oooool00ol0003o
6WCRoaYdhP03oaYdhP03o`000?nU`^koYL;^00ooYL;^00?o0000omK@e?oFd=@01?oFd=@00ol0003o
cl7=olo1c@08olo1c@03o`000?o6/lSoa[?800Soa[?81_l00003ol:AX`03o`000?nbQ:?o/XBS00Ko
/XBS00?o0000oj5gXol000001?l00002ojRHa@03o`000?nLT/SoW9;800SoW9;800?o0000ohf=c_n=
SLh02On=SLh00ol0003oNhWEog^9e@02og^9e@03o`000?nU`^koYL;^00koYL;^00?o0000olWmhoo9
oN<01Oo9oN<00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool08Oooool004Cooooo00?o0000ooooooooool04oooool00ol0003o6WCRoaYdhP03oaYdhP03o`00
0?nU`^koYL;^00koYL;^00?o0000omK@e?oFd=@00ooFd=@00ol0003ocl7=olo1c@09olo1c@03o`00
0?o6/lSoa[?800Soa[?800?o0000okfXaOnmZ<D00onmZ<D>o`0000SoZ9S500?o0000oibBb?nLT/P0
1onLT/P00ol0003oSHg>ohf=cP0:ohf=cP05o`000?mkRMGoNhWEog^9eOl000003onU`^h00ol0003o
bOgSolWmh`05olWmh`03o`000?oooooooooo027ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Qooooo`00AOooool00ol0003oooooooooo`0Cooooo`03o`000?lJM>;o6WCR00?o6WCR
00?o0000ojG2k_nU`^h03_nU`^h01Ol0003oe]3DomK@e?oFd=Co000000_ocl7=00?o0000olJcb?o6
/lP02?o6/lP00ol0003o_JS5okfXa@07okfXa@Wo/io400?o0000ojRHaOnXV<D01onXV<D00ol0003o
W9;8oibBb008oibBb003o`000?n=SLkoSHg>00[oSHg>00?o0000og^9eOl000003onU`^h00ol0003o
bOgSolWmh`04olWmh`;o00009Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo027o
oooo0016ooooo`03o`000?oooooooooo01?ooooo0_l00004oaYdhP03o`000?nU`^koYL;^00koYL;^
00?o0000omK@e?l000003?o?`Ld00ol0003oa[?8olJcb008olJcb003o`000?nmZ<Go_JS500Oo_JS5
00?o0000ok>Oa?ncWl@01_ncWl@00ol0003oZ9S5ojRHa@08ojRHa@03o`000?nLT/SoW9;800SoW9;8
00?o0000ohf=c_n=SLh02On=SLh2o`000003ojG2k_l0003oYL;^00coYL;^00?o0000olWmhoo9oN<0
0_o9oN<3o`0002Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Qooooo`00Aooo
ool2o`0001Gooooo0_l00002oaYdhP03o`000?nU`^koYL;^00goYL;^1?l0000;olo1c@03o`000?o6
/lSoa[?800Soa[?800?o0000okfXaOnmZ<D02?nmZ<D00ol0003o/io4ok>Oa007ok>Oa003o`000?nX
V<GoZ9S500OoZ9S500?o0000oibBb?nLT/P02OnLT/P00ol0003oSHg>ohf=cP07ohf=cP03o`000?nU
`^koYL;^00;oYL;^1Ol00008ojG2kP03o`000?o9oN?o000000;o000000?oT_3Ao`000?ooool0:Ooo
ool01Ol0003ooooooooooooooooo000002?ooooo0019ooooo`03o`000?oooooooooo01?ooooo0ol0
00000olJM>;o0000ojG2kP0:ojG2kP?o00001?nU`^h00ol0003ocl7=olo1c@07olo1c@03o`000?o6
/lSoa[?800Woa[?800?o0000okfXaOnmZ<D02?nmZ<D00ol0003o/io4ok>Oa007ok>Oa003o`000?nX
V<GoZ9S500OoZ9S500?o0000oibBb?nLT/P02_nLT/P00ol0003oSHg>ohf=cP05ohf=cP03o`000?nU
`^koYL;^00SoYL;^1Ol00002ojG2kP?o00000onBl=4/ooooo`05o`000?ooooooooooooooool00000
8oooool004[ooooo00?o0000ooooooooool05?ooool4o`0000KoYL;^1?l00008ojG2kP;o00001oo?
`Ld00ol0003oa[?8olJcb009olJcb003o`000?nmZ<Go_JS500Oo_JS500?o0000ok>Oa?ncWl@02?nc
Wl@00ol0003oZ9S5ojRHa@08ojRHa@03o`000?nLT/SoW9;800WoW9;800?o0000ohf=c_n=SLh00on=
SLh2o`00013oYL;^0_l00004oi;`d@03o`000?oooooooooo02cooooo00Co0000oooooooooooo0000
8oooool004_ooooo00?o0000ooooooooool05?ooool4o`0000;oYL;^0ol0000>ojG2kP03o`000?o?
`Lgocl7=00?ocl7=00?o0000olJcb?o6/lP02Oo6/lP00ol0003o_JS5okfXa@08okfXa@03o`000?nc
WlCo/io400So/io400?o0000ojRHaOnXV<D02?nXV<D00ol0003oW9;8oibBb00:oibBb005o`000?n=
SLkoSHg>ohf=c_l000004OnU`^h00ol0003oT_3Aoi;`d@02oi;`d@03o`000?oooooooooo02oooooo
00?o0000ooooool000008oooool004cooooo0_l0000Fooooo`04o`000?l0H/_o0000o`0001;oYL;^
0_l00003olo1c@03o`000?o6/lSoa[?800Woa[?800?o0000okfXaOnmZ<D02?nmZ<D00ol0003o/io4
ok>Oa008ok>Oa003o`000?nXV<GoZ9S500WoZ9S500?o0000oibBb?nLT/P02_nLT/P00ol0003oSHg>
o`00000AojG2kP05o`000?nBl=7oT_3Aoi;`dOl00000<oooool01?l0003oooooooooool0000Roooo
o`00C_ooool00ol0003oooooooooo`0Dooooo`;o000000?o06;;o`000?nU`^h04_nU`^h00ol0003o
cl7=o`00000;olJcb003o`000?nmZ<Go_JS500Wo_JS500?o0000ok>Oa?ncWl@02OncWl@00ol0003o
Z9S5ojRHa@08ojRHa@03o`000?nLT/SoW9;800[oW9;80_l0000@ojG2kP;o00000_nBl=42o`0003Go
oooo00?o0000ooooool000008_ooool004oooooo00?o0000ooooooooool05Oooool01?l0003o06;;
o`000?l0000AojG2kP?o00002oo6/lP00ol0003o_JS5okfXa@09okfXa@03o`000?ncWlCo/io400Wo
/io400?o0000ojRHaOnXV<D02OnXV<D00ol0003oW9;8oibBb006oibBb0?o00000onU`^h2o`0000co
YL;^00Go0000oi;`dOnBl=7oT_3Ao`00000hooooo`;o00008_ooool0053ooooo00?o0000oooooooo
ool05Oooool01?l0003o06;;o`1Rbol0000>ojG2kP;o00000onU`^h3o`0000Ooa[?800?o0000okfX
aOnmZ<D02_nmZ<D00ol0003o/io4ok>Oa009ok>Oa003o`000?nXV<GoZ9S500WoZ9S500?o0000oibB
b?nLT/P00onLT/P3o`0000SoYL;^00?o0000ojG2k_nU`^h02?nU`^h00ol0003oT_3Aoi;`d@02o`00
03Sooooo0ol0000Rooooo`00DOooool00ol0003oooooooooo`0Fooooo`;o06;;0_l0000:ojG2kP;o
00002?nU`^h3o`0000Coa[?800?o0000okfXaOnmZ<D02_nmZ<D00ol0003o/io4ok>Oa009ok>Oa003
o`000?nXV<GoZ9S500WoZ9S500?o0000oibBb?nLT/P00ol0000<ojG2kP;o00001_nU`^h2o`000003
oi;`dOl0003o000003Kooooo1?l0000Uooooo`00D_ooool2o`0001Oooooo0_l000000ol0H/_o0000
ojG2kP07ojG2kP03o`000?nU`^koYL;^00_oYL;^0ol000000oo6/lSo0000okfXa@0:okfXa@03o`00
0?ncWlCo/io400[o/io400?o0000ojRHaOnXV<D02?nXV<D4o`00017oYL;^0_l00003ojG2kP04o`00
0?nBl=7o0000o`0003Gooooo0ol0000Yooooo`00E?ooool00ol0003oooooooooo`0Fooooo`Co0000
1?nU`^h2o`00017oYL;^1?l00009okfXa@03o`000?ncWlCo/io400_o/io400?o0000ojRHaOnXV<D0
0onXV<D4o`0000?oYL;^00?o0000ojG2k_nU`^h04OnU`^h01?l0003oYL;^o`000?nBl=4dooooo`Co
0000;?ooool005Gooooo00?o0000ooooooooool06?ooool2o`000003ojG2k_l0003o000001?oYL;^
00Co0000ojG2k_nU`^koYL;^1ol00002okfXa@03o`000?ncWlCo/io400_o/io400?o0000ojRHaOl0
00000ol00008ojG2kP03o`000?nU`^koYL;^017oYL;^00?o0000ooooooooool0<?ooool4o`00033o
oooo001Fooooo`03o`000?oooooooooo01Wooooo0ol0000BojG2kP03o`000?nU`^koYL;^00WoYL;^
4_l0000=ojG2kP03o`000?nU`^koYL;^00coYL;^0ol0000`ooooo`Co0000=?ooool005Oooooo0_l0
000Looooo`?o00003_nU`^h00ol0003oYL;^ojG2kP0<ojG2kP03o`000?nU`^koYL;^00_oYL;^00?o
0000ojG2k_nU`^h03OnU`^h00ol0003oYL;^ojG2kP08ojG2kP?o0000;oooool4o`0003Sooooo001I
ooooo`03o`000?oooooooooo01cooooo0ol0000:ojG2kP03o`000?nU`^koYL;^00goYL;^00?o0000
ojG2k_nU`^h02onU`^h00ol0003oYL;^ojG2kP0>ojG2kP03o`000?nU`^koYL;^00CoYL;^0ol0000_
ooooo`?o0000??ooool005[ooooo00?o0000ooooooooool07_ooool3o`0000KoYL;^00?o0000ojG2
k_nU`^h03OnU`^h00ol0003oYL;^ojG2kP0=ojG2kP03o`000?nU`^koYL;^00koYL;^00?o0000ojG2
k_nU`^h00ol0000^ooooo`Co0000?oooool005_ooooo00?o0000ooooooooool08?ooool3o`0000;o
YL;^00?o0000ojG2k_nU`^h03_nU`^h00ol0003oYL;^ojG2kP0=ojG2kP03o`000?nU`^koYL;^00go
YL;^00Co0000ojG2k_l0003o0000;Oooool4o`0004?ooooo001Looooo`03o`000?oooooooooo01oo
oooo00?o0000ooooooooool01Ol0000>ojG2kP03o`000?nU`^koYL;^00goYL;^00?o0000ojG2k_nU
`^h02OnU`^h4o`0002gooooo1?l00017ooooo`00GOooool2o`0001oooooo00?o0000ooooooooool0
1Oooool6o`0000SoYL;^00?o0000ojG2k_nU`^h03OnU`^h00ol0003oYL;^ojG2kP04ojG2kPGo0000
;Oooool4o`0004_ooooo001Oooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool02ooo
ool5o`0000;oYL;^00?o0000ojG2k_nU`^h03onU`^h00ol0003oYL;^o`000003o`0002oooooo0ol0
001?ooooo`00H?ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo013ooooo5_l0000_
ooooo`Co0000D_ooool0067ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`1Aoooo
o`Co0000E_ooool006;ooooo0_l0000Jooooo`03o`000?oooooooooo04gooooo1?l0001Jooooo`00
I?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo04[ooooo0ol0001Nooooo`00IOoo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo04Kooooo1?l0001Qooooo`00I_ooool0
0ol0003oooooooooo`0Eooooo`03o`000?oooooooooo04;ooooo1?l0001Uooooo`00Ioooool2o`00
01Gooooo00?o0000ooooooooool0?_ooool4o`0006Wooooo001Yooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool0>_ooool4o`0006gooooo001Zooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool0=oooool3o`00077ooooo001[ooooo`03o`000?oooooooooo013ooooo00?o
0000ooooooooool0<oooool4o`0007Cooooo001/ooooo`03o`000?oooooooooo00oooooo00?o0000
ooooooooool0;oooool4o`0007Sooooo001]ooooo`;o00003oooool00ol0003oooooooooo`0[oooo
o`Co0000O?ooool006oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Xooooo`?o
0000P?ooool0073ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Tooooo`Co0000
Poooool0077ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Pooooo`Co0000Qooo
ool007;ooooo0_l00009ooooo`03o`000?oooooooooo01gooooo1?l0002;ooooo`00M?ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo01Wooooo1?l0002?ooooo`00MOooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo01Kooooo0ol0002Cooooo`00M_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo01;ooooo1?l0002Fooooo`00Moooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00kooooo1?l0002Jooooo`00N?ooool2o`0000?ooooo00?o0000
ooooooooool02_ooool4o`0009kooooo001jooooo`04o`000?ooooooooooo`0000Sooooo1?l0002R
ooooo`00Noooool00ol0003oooooo`000005ooooo`?o0000Y_ooool007cooooo0_l000000ooooooo
0000o`000002o`000:Wooooo001mooooo`;o0000[Oooool00001\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.136418, 0.0839692, 0.00409954, \
0.00409954}},
 CellTags->"S5.42.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.42.1"]
}, Open  ]],

Cell[TextData[{
 "Each of the shapes can take various parameters as arguments. These \
parameters adjust things such as the radii, height, and size of the polygon \
mesh. If you do not give any arguments, you get the shape with all default \
values for the parameters. Thus, for example, ",
 StyleBox["Torus[", "MR"],
 " ",
 StyleBox["]", "MR"],
 " gives a torus with default values for the radius, height, and polygon \
mesh. "
}], "Text",
 CellTags->{"S5.42.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Cylinder[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["cylinder with radius ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and half height ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" drawn using ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" polygons",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Cone[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["cone with radius ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and half height ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" drawn using ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" polygons ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Torus[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["torus with radii ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" drawn using an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" mesh",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Sphere[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["sphere with radius ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" drawn using ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["n",
          "TI"], 
         RowBox[{"(", 
          RowBox[{
           StyleBox["m",
            "TI"], "-", "2"}], ")"}], "+", "2"}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" polygons ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MoebiusStrip[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["M\[ODoubleDot]bius strip with radii ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" drawn using ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" polygons",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Helix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["helix with radius ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", half height ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" turns drawn using an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" mesh",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DoubleHelix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["double helix with radius ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", half height ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["h", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" turns drawn using an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" mesh",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.42.1"],

Cell["Shapes.", "Caption",
 CellTags->"S5.42.1"],

Cell["This gives a M\[ODoubleDot]bius strip with a fine mesh. ", "MathCaption",
 CellTags->{"S5.42.1", "1.7"}],

Cell[CellGroupData[{

Cell["Show[ Graphics3D[ MoebiusStrip[ 2, 1, 80] ]]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.42.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81717 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-3.00324e-17 1.05386 -0.0670921 1.05386 [
[ 0 0 0 0 ]
[ 1 .81717 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03445 .24853 m
0 .47506 L
s
0 .47506 m
.41426 .81717 L
s
.41426 .81717 m
.42033 .61213 L
s
.42033 .61213 m
.03445 .24853 L
s
.67192 0 m
.97204 .44698 L
s
.97204 .44698 m
1 .66282 L
s
1 .66282 m
.68338 .23633 L
s
.68338 .23633 m
.67192 0 L
s
.03445 .24853 m
0 .47506 L
s
0 .47506 m
.68338 .23633 L
s
.68338 .23633 m
.67192 0 L
s
.67192 0 m
.03445 .24853 L
s
.42033 .61213 m
.97204 .44698 L
s
.97204 .44698 m
1 .66282 L
s
1 .66282 m
.41426 .81717 L
s
.41426 .81717 m
.42033 .61213 L
s
0 0 m
1 0 L
1 .81717 L
0 .81717 L
closepath
clip
newpath
.5 Mabswid
.723 .545 .649 r
.37397 .72559 m .40762 .49392 L .39157 .49145 L p F P
0 g
s
.707 .537 .657 r
.40762 .49392 m .37397 .72559 L .39447 .72988 L p F P
0 g
s
.707 .537 .657 r
.39447 .72988 m .42339 .49577 L .40762 .49392 L p F P
0 g
s
.723 .545 .649 r
.39157 .49145 m .35455 .72037 L .37397 .72559 L p F P
0 g
s
.818 .636 .655 r
.35455 .72037 m .39157 .49145 L .40762 .49392 L p F P
0 g
s
.818 .636 .655 r
.40762 .49392 m .37397 .72559 L .35455 .72037 L p F P
0 g
s
.802 .626 .663 r
.37397 .72559 m .40762 .49392 L .42339 .49577 L p F P
0 g
s
.691 .53 .664 r
.42339 .49577 m .39447 .72988 L .41593 .73319 L p F P
0 g
s
.691 .53 .664 r
.41593 .73319 m .4388 .49703 L .42339 .49577 L p F P
0 g
s
.802 .626 .663 r
.42339 .49577 m .39447 .72988 L .37397 .72559 L p F P
0 g
s
.787 .617 .67 r
.39447 .72988 m .42339 .49577 L .4388 .49703 L p F P
0 g
s
.739 .552 .641 r
.35455 .72037 m .39157 .49145 L .37531 .48832 L p F P
0 g
s
.739 .552 .641 r
.37531 .48832 m .33631 .71428 L .35455 .72037 L p F P
0 g
s
.836 .647 .647 r
.33631 .71428 m .37531 .48832 L .39157 .49145 L p F P
0 g
s
.836 .647 .647 r
.39157 .49145 m .35455 .72037 L .33631 .71428 L p F P
0 g
s
.787 .617 .67 r
.4388 .49703 m .41593 .73319 L .39447 .72988 L p F P
0 g
s
.675 .524 .672 r
.4388 .49703 m .41593 .73319 L .43825 .73548 L p F P
0 g
s
.675 .524 .672 r
.43825 .73548 m .45377 .49773 L .4388 .49703 L p F P
0 g
s
.773 .609 .676 r
.41593 .73319 m .4388 .49703 L .45377 .49773 L p F P
0 g
s
.755 .561 .633 r
.33631 .71428 m .37531 .48832 L .35895 .48452 L p F P
0 g
s
.755 .561 .633 r
.35895 .48452 m .31935 .70737 L .33631 .71428 L p F P
0 g
s
.854 .659 .638 r
.31935 .70737 m .35895 .48452 L .37531 .48832 L p F P
0 g
s
.854 .659 .638 r
.37531 .48832 m .33631 .71428 L .31935 .70737 L p F P
0 g
s
.773 .609 .676 r
.45377 .49773 m .43825 .73548 L .41593 .73319 L p F P
0 g
s
.659 .518 .681 r
.45377 .49773 m .43825 .73548 L .4613 .73671 L p F P
0 g
s
.659 .518 .681 r
.4613 .73671 m .46824 .49792 L .45377 .49773 L p F P
0 g
s
.759 .602 .683 r
.43825 .73548 m .45377 .49773 L .46824 .49792 L p F P
0 g
s
.772 .569 .625 r
.31935 .70737 m .35895 .48452 L .34258 .48001 L p F P
0 g
s
.772 .569 .625 r
.34258 .48001 m .30375 .69969 L .31935 .70737 L p F P
0 g
s
.874 .673 .628 r
.30375 .69969 m .34258 .48001 L .35895 .48452 L p F P
0 g
s
.874 .673 .628 r
.35895 .48452 m .31935 .70737 L .30375 .69969 L p F P
0 g
s
.643 .513 .689 r
.46824 .49792 m .4613 .73671 L .48495 .73684 L p F P
0 g
s
.643 .513 .689 r
.48495 .73684 m .48215 .49763 L .46824 .49792 L p F P
0 g
s
.759 .602 .683 r
.46824 .49792 m .4613 .73671 L .43825 .73548 L p F P
0 g
s
.746 .596 .69 r
.4613 .73671 m .46824 .49792 L .48215 .49763 L p F P
0 g
s
.789 .579 .616 r
.30375 .69969 m .34258 .48001 L .3263 .47478 L p F P
0 g
s
.789 .579 .616 r
.3263 .47478 m .28959 .69132 L .30375 .69969 L p F P
0 g
s
.895 .688 .615 r
.28959 .69132 m .3263 .47478 L .34258 .48001 L p F P
0 g
s
.895 .688 .615 r
.34258 .48001 m .30375 .69969 L .28959 .69132 L p F P
0 g
s
.626 .508 .699 r
.48215 .49763 m .48495 .73684 L .50908 .73585 L p F P
0 g
s
.626 .508 .699 r
.50908 .73585 m .49544 .4969 L .48215 .49763 L p F P
0 g
s
.746 .596 .69 r
.48215 .49763 m .48495 .73684 L .4613 .73671 L p F P
0 g
s
.733 .59 .696 r
.48495 .73684 m .48215 .49763 L .49544 .4969 L p F P
0 g
s
.807 .588 .606 r
.28959 .69132 m .3263 .47478 L .31022 .46881 L p F P
0 g
s
.807 .588 .606 r
.31022 .46881 m .27695 .68232 L .28959 .69132 L p F P
0 g
s
.918 .704 .598 r
.27695 .68232 m .31022 .46881 L .3263 .47478 L p F P
0 g
s
.918 .704 .598 r
.3263 .47478 m .28959 .69132 L .27695 .68232 L p F P
0 g
s
.733 .59 .696 r
.49544 .4969 m .50908 .73585 L .48495 .73684 L p F P
0 g
s
.609 .503 .709 r
.49544 .4969 m .50908 .73585 L .53355 .73369 L p F P
0 g
s
.609 .503 .709 r
.53355 .73369 m .50808 .49577 L .49544 .4969 L p F P
0 g
s
.721 .586 .703 r
.50908 .73585 m .49544 .4969 L .50808 .49577 L p F P
0 g
s
.826 .599 .594 r
.27695 .68232 m .31022 .46881 L .29446 .46209 L p F P
0 g
s
.826 .599 .594 r
.29446 .46209 m .26589 .67276 L .27695 .68232 L p F P
0 g
s
.941 .721 .576 r
.26589 .67276 m .29446 .46209 L .31022 .46881 L p F P
0 g
s
.941 .721 .576 r
.31022 .46881 m .27695 .68232 L .26589 .67276 L p F P
0 g
s
.721 .586 .703 r
.50808 .49577 m .53355 .73369 L .50908 .73585 L p F P
0 g
s
.591 .5 .719 r
.50808 .49577 m .53355 .73369 L .55823 .73036 L p F P
0 g
s
.591 .5 .719 r
.55823 .73036 m .52003 .4943 L .50808 .49577 L p F P
0 g
s
.71 .582 .71 r
.53355 .73369 m .50808 .49577 L .52003 .4943 L p F P
0 g
s
.71 .582 .71 r
.52003 .4943 m .55823 .73036 L .53355 .73369 L p F P
0 g
s
.572 .497 .731 r
.52003 .4943 m .55823 .73036 L .58297 .72582 L p F P
0 g
s
.572 .497 .731 r
.58297 .72582 m .53124 .4925 L .52003 .4943 L p F P
0 g
s
.699 .579 .718 r
.55823 .73036 m .52003 .4943 L .53124 .4925 L p F P
0 g
s
.699 .579 .718 r
.53124 .4925 m .58297 .72582 L .55823 .73036 L p F P
0 g
s
.553 .495 .744 r
.53124 .4925 m .58297 .72582 L .60762 .72007 L p F P
0 g
s
.553 .495 .744 r
.60762 .72007 m .5417 .49044 L .53124 .4925 L p F P
0 g
s
.688 .577 .725 r
.58297 .72582 m .53124 .4925 L .5417 .49044 L p F P
0 g
s
.688 .577 .725 r
.5417 .49044 m .60762 .72007 L .58297 .72582 L p F P
0 g
s
.532 .493 .758 r
.5417 .49044 m .60762 .72007 L .63204 .71309 L p F P
0 g
s
.532 .493 .758 r
.63204 .71309 m .55138 .48815 L .5417 .49044 L p F P
0 g
s
.677 .576 .734 r
.60762 .72007 m .5417 .49044 L .55138 .48815 L p F P
0 g
s
.677 .576 .734 r
.55138 .48815 m .63204 .71309 L .60762 .72007 L p F P
0 g
s
.846 .609 .58 r
.26589 .67276 m .29446 .46209 L .27914 .45462 L p F P
0 g
s
.846 .609 .58 r
.27914 .45462 m .25645 .66271 L .26589 .67276 L p F P
0 g
s
.965 .739 .546 r
.25645 .66271 m .27914 .45462 L .29446 .46209 L p F P
0 g
s
.965 .739 .546 r
.29446 .46209 m .26589 .67276 L .25645 .66271 L p F P
0 g
s
.51 .493 .774 r
.55138 .48815 m .63204 .71309 L .65608 .70488 L p F P
0 g
s
.51 .493 .774 r
.65608 .70488 m .56028 .48567 L .55138 .48815 L p F P
0 g
s
.667 .575 .742 r
.63204 .71309 m .55138 .48815 L .56028 .48567 L p F P
0 g
s
.667 .575 .742 r
.56028 .48567 m .65608 .70488 L .63204 .71309 L p F P
0 g
s
.867 .621 .564 r
.25645 .66271 m .27914 .45462 L .26439 .4464 L p F P
0 g
s
.867 .621 .564 r
.26439 .4464 m .24866 .65226 L .25645 .66271 L p F P
0 g
s
.986 .755 .502 r
.24866 .65226 m .26439 .4464 L .27914 .45462 L p F P
0 g
s
.986 .755 .502 r
.27914 .45462 m .25645 .66271 L .24866 .65226 L p F P
0 g
s
.487 .495 .791 r
.56028 .48567 m .65608 .70488 L .67958 .69544 L p F P
0 g
s
.487 .495 .791 r
.67958 .69544 m .56838 .48304 L .56028 .48567 L p F P
0 g
s
.658 .576 .751 r
.65608 .70488 m .56028 .48567 L .56838 .48304 L p F P
0 g
s
.658 .576 .751 r
.56838 .48304 m .67958 .69544 L .65608 .70488 L p F P
0 g
s
.463 .498 .809 r
.56838 .48304 m .67958 .69544 L .70239 .68478 L p F P
0 g
s
.463 .498 .809 r
.70239 .68478 m .57567 .48029 L .56838 .48304 L p F P
0 g
s
.649 .577 .76 r
.67958 .69544 m .56838 .48304 L .57567 .48029 L p F P
0 g
s
.649 .577 .76 r
.57567 .48029 m .70239 .68478 L .67958 .69544 L p F P
0 g
s
.889 .632 .543 r
.24866 .65226 m .26439 .4464 L .25034 .43744 L p F P
0 g
s
.889 .632 .543 r
.24256 .64146 m .24866 .65226 L p .24947 .54888 L F P
0 g
s
.889 .632 .543 r
.25034 .43744 m .24641 .54055 L p .24947 .54888 L F P
0 g
s
.936 .654 .481 r
.23816 .63041 m .23712 .42775 L .22487 .41736 L p F P
0 g
s
.957 .661 .433 r
.23544 .61918 m .22487 .41736 L .21373 .4063 L p F P
0 g
s
.957 .661 .433 r
.22276 .49484 m .21612 .42969 L .22272 .49405 L F
.21751 .44315 m .21929 .46055 L p .21612 .42969 L F P
0 g
s
.957 .661 .433 r
.21923 .46 m .21929 .46051 L .22104 .47762 L F
.22095 .47677 m .22104 .47762 L .2344 .60785 L F
.21923 .46 m .22104 .47762 L .22095 .47677 L F
.21931 .46074 m .2344 .60785 L p .21929 .46051 L F P
0 g
s
.957 .661 .433 r
.2344 .60785 m .23544 .61918 L p .22276 .49484 L F P
0 g
s
.957 .661 .433 r
.22276 .49484 m .22272 .49405 L .2344 .60785 L F
.97 .66 .364 r
.21373 .4063 m .20385 .3946 L p .20726 .41845 L F P
0 g
s
.97 .66 .364 r
.2344 .60785 m .21931 .46074 L p .20726 .41845 L F P
0 g
s
.957 .661 .433 r
.21929 .46055 m .21931 .46074 L p .21929 .46051 L F P
0 g
s
.957 .661 .433 r
.21612 .42969 m .21929 .46055 L .21923 .46 L F
.21373 .4063 m .21751 .44315 L p .21612 .42969 L F P
0 g
s
.97 .66 .364 r
.21931 .46074 m .21373 .4063 L p .20726 .41845 L F P
0 g
s
.936 .654 .481 r
.23544 .61918 m .23816 .63041 L p .23056 .50864 L F P
0 g
s
.936 .654 .481 r
.23056 .50864 m .22991 .50603 L .23544 .61918 L F
.22813 .46965 m .22805 .46989 L .23139 .53726 L F
.23145 .53761 m .23139 .53726 L .23544 .61918 L F
.22813 .46965 m .23139 .53726 L .23145 .53761 L F
.22768 .4711 m .23544 .61918 L p .2277 .4628 L F P
0 g
s
.936 .654 .481 r
.23056 .50864 m .22813 .46965 L .22991 .50603 L F
.22813 .46965 m .2277 .4628 L .22805 .46989 L F
.22487 .41736 m .22768 .4711 L p .2277 .4628 L F P
0 g
s
.907 .694 .19 r
.23544 .61918 m .22487 .41736 L .23712 .42775 L p F P
0 g
s
.749 .573 0 r
.2344 .60785 m .21373 .4063 L .22487 .41736 L p F P
0 g
s
.749 .573 0 r
.23544 .61918 m .2344 .60785 L p .23047 .5294 L F P
0 g
s
.749 .573 0 r
.22487 .41736 m .23106 .53549 L p .23047 .5294 L F P
0 g
s
.749 .573 0 r
.23106 .53549 m .23544 .61918 L p .23047 .5294 L F P
0 g
s
0 0 .204 r
.21373 .4063 m .22429 .5093 L p .22503 .50734 L F P
0 g
s
0 0 .204 r
.2344 .60785 m .235 .5965 L p .22503 .50734 L F P
0 g
s
0 0 .204 r
.22429 .5093 m .2344 .60785 L p .22503 .50734 L F P
0 g
s
0 0 .204 r
.235 .5965 m .20385 .3946 L .21373 .4063 L p F P
0 g
s
.97 .66 .364 r
.2344 .60785 m .20601 .40967 L .23387 .58922 L F
.20385 .3946 m .2068 .41372 L p .20601 .40967 L F P
0 g
s
.97 .66 .364 r
.2068 .41372 m .235 .5965 L p .20601 .40967 L F P
0 g
s
.965 .642 .265 r
.2275 .55594 m .20655 .41304 L .19536 .38233 L F
.20385 .3946 m .19536 .38233 L p .20655 .41304 L F P
0 g
s
.965 .642 .265 r
.22751 .54797 m .20385 .3946 L p .2275 .55594 L F P
0 g
s
.907 .694 .19 r
.23816 .63041 m .23544 .61918 L p .23661 .48523 L F P
0 g
s
.907 .694 .19 r
.23712 .42775 m .23739 .48097 L p .23661 .48523 L F P
0 g
s
0 0 .369 r
.235 .5965 m .2372 .5852 L p .20926 .42553 L F P
0 g
s
0 0 .369 r
.20385 .3946 m .2068 .41372 L p .20926 .42553 L F P
0 g
s
0 0 .369 r
.2068 .41372 m .235 .5965 L p .20926 .42553 L F P
0 g
s
0 0 .369 r
.19536 .38233 m .20385 .3946 L p .22799 .53258 L F P
0 g
s
.336 .264 .626 r
.17821 .32874 m .17971 .34265 L p .21731 .43531 L F P
0 g
s
.907 .694 .19 r
.23739 .48097 m .23772 .54546 L p .23661 .48523 L F P
0 g
s
.889 .632 .543 r
.24641 .54055 m .24518 .57276 L p .24947 .54888 L F P
0 g
s
.889 .632 .543 r
.24518 .57276 m .24256 .64146 L p .24716 .57987 L F P
0 g
s
.889 .632 .543 r
.24947 .54888 m .24518 .57276 L .24716 .57987 L F
.996 .762 .437 r
.24256 .64146 m .25034 .43744 L .26439 .4464 L p F P
0 g
s
.996 .762 .437 r
.26439 .4464 m .24866 .65226 L .24256 .64146 L p F P
0 g
s
.912 .644 .517 r
.24256 .64146 m .25034 .43744 L .23712 .42775 L p F P
0 g
s
.912 .644 .517 r
.23816 .63041 m .24256 .64146 L p .24133 .59314 L F P
0 g
s
.912 .644 .517 r
.23712 .42775 m .23788 .5757 L p .24133 .59314 L F P
0 g
s
.912 .644 .517 r
.23788 .5757 m .23816 .63041 L p .24133 .59314 L F P
0 g
s
.979 .749 .337 r
.23712 .42775 m .25034 .43744 L p .24187 .57153 L F P
0 g
s
.979 .749 .337 r
.23816 .63041 m .2378 .55984 L p .24187 .57153 L F P
0 g
s
.979 .749 .337 r
.2378 .55984 m .23712 .42775 L p .24187 .57153 L F P
0 g
s
.979 .749 .337 r
.24256 .64146 m .23816 .63041 L p .24187 .57153 L F P
0 g
s
.979 .749 .337 r
.25034 .43744 m .24468 .58579 L p .24187 .57153 L F P
0 g
s
.979 .749 .337 r
.24468 .58579 m .24256 .64146 L p .24187 .57153 L F P
0 g
s
.408 .32 .645 r
.17877 .31466 m .17821 .32874 L p .20636 .39133 L F P
0 g
s
.408 .32 .645 r
.26961 .53191 m .20238 .37113 L p .20636 .39133 L F P
0 g
s
.408 .32 .645 r
.20238 .37113 m .17877 .31466 L p .20636 .39133 L F P
0 g
s
0 0 .546 r
.17821 .32874 m .17877 .31466 L p .19521 .36035 L F P
0 g
s
.408 .32 .645 r
.17821 .32874 m .26057 .54193 L .26961 .53191 L p F P
0 g
s
0 0 .546 r
.26057 .54193 m .20026 .38583 L p .19521 .36035 L F P
0 g
s
0 0 .546 r
.20026 .38583 m .17821 .32874 L p .19521 .36035 L F P
0 g
s
.336 .264 .626 r
.26057 .54193 m .2154 .42501 L p .21731 .43531 L F P
0 g
s
.336 .264 .626 r
.2154 .42501 m .17821 .32874 L p .21731 .43531 L F P
0 g
s
.907 .694 .19 r
.23772 .54546 m .23816 .63041 L p .23723 .54279 L F P
0 g
s
.907 .694 .19 r
.23772 .54546 m .23723 .54279 L .23661 .48523 L F
0 0 .369 r
.2372 .5852 m .22722 .53682 L p .22799 .53258 L F P
0 g
s
0 0 .369 r
.22722 .53682 m .19536 .38233 L p .22799 .53258 L F P
0 g
s
0 0 .482 r
.19536 .38233 m .2372 .5852 L .24093 .57402 L p F P
0 g
s
0 0 .482 r
.22127 .49129 m .23506 .54934 L .22039 .49404 L F
.24093 .57402 m .23709 .55907 L p .23506 .54934 L F P
0 g
s
0 0 .482 r
.23709 .55907 m .22039 .49404 L p .23506 .54934 L F P
0 g
s
.97 .66 .364 r
.235 .5965 m .23463 .6036 L p .23387 .58922 L F P
0 g
s
.97 .66 .364 r
.23463 .6036 m .2344 .60785 L p .23387 .58922 L F P
0 g
s
.965 .642 .265 r
.23134 .5767 m .22751 .54797 L .2275 .55594 L F
.235 .5965 m .2301 .56471 L p .23134 .5767 L F P
0 g
s
.965 .642 .265 r
.2301 .56471 m .22751 .54797 L p .23134 .5767 L F P
0 g
s
.965 .642 .265 r
.19536 .38233 m .2372 .5852 L .235 .5965 L p F P
0 g
s
.92 .594 .127 r
.19536 .38233 m .18842 .36953 L p .22831 .54591 L F P
0 g
s
.92 .594 .127 r
.22749 .53811 m .19536 .38233 L p .22831 .54591 L F P
0 g
s
0 0 .482 r
.18842 .36953 m .19536 .38233 L p .22127 .49129 L F P
0 g
s
.336 .264 .626 r
.17971 .34265 m .25271 .55233 L .26057 .54193 L p F P
0 g
s
0 0 .424 r
.2246 .46798 m .21283 .43778 L .21065 .42611 L F
.23176 .48946 m .22485 .47061 L .2246 .46798 L F
.22485 .47061 m .21283 .43778 L .2246 .46798 L F
.25271 .55233 m .23127 .49075 L p .23176 .48946 L F P
0 g
s
0 0 .424 r
.23127 .49075 m .21283 .43778 L p .23176 .48946 L F P
0 g
s
0 0 .424 r
.17971 .34265 m .17821 .32874 L p .21065 .42611 L F P
0 g
s
0 0 .424 r
.21283 .43778 m .17971 .34265 L p .21065 .42611 L F P
0 g
s
0 0 .482 r
.22039 .49404 m .18842 .36953 L p .22127 .49129 L F P
0 g
s
.92 .594 .127 r
.2372 .5852 m .22749 .53811 L p .22831 .54591 L F P
0 g
s
.92 .594 .127 r
.18842 .36953 m .24093 .57402 L .2372 .5852 L p F P
0 g
s
.809 .497 0 r
.18842 .36953 m .18316 .35627 L p .22528 .51504 L F P
0 g
s
.809 .497 0 r
.22489 .51153 m .18842 .36953 L p .22528 .51504 L F P
0 g
s
.12 .095 .553 r
.18842 .36953 m .24093 .57402 L .24613 .56304 L p F P
0 g
s
.12 .095 .553 r
.18316 .35627 m .18842 .36953 L p .1981 .40199 L F P
0 g
s
.12 .095 .553 r
.1981 .40199 m .20943 .43998 L .18316 .35627 L F
.243 .191 .597 r
.17971 .34265 m .18316 .35627 L p .21464 .44502 L F P
0 g
s
.243 .191 .597 r
.25271 .55233 m .21283 .43778 L p .21464 .44502 L F P
0 g
s
.243 .191 .597 r
.21283 .43778 m .17971 .34265 L p .21464 .44502 L F P
0 g
s
.809 .497 0 r
.24093 .57402 m .22489 .51153 L p .22528 .51504 L F P
0 g
s
.12 .095 .553 r
.20943 .43998 m .22191 .48181 L .20489 .42763 L F
.24613 .56304 m .22225 .48465 L p .22191 .48181 L F P
0 g
s
.12 .095 .553 r
.22225 .48465 m .20489 .42763 L p .22191 .48181 L F P
0 g
s
.12 .095 .553 r
.20489 .42763 m .18316 .35627 L p .20943 .43998 L F P
0 g
s
.243 .191 .597 r
.18316 .35627 m .24613 .56304 L .25271 .55233 L p F P
0 g
s
0 0 .251 r
.2222 .48365 m .20489 .42763 L .19984 .40943 L F
.24613 .56304 m .22225 .48465 L p .2222 .48365 L F P
0 g
s
0 0 .251 r
.22225 .48465 m .20489 .42763 L p .2222 .48365 L F P
0 g
s
0 0 .251 r
.18316 .35627 m .17971 .34265 L p .19984 .40943 L F P
0 g
s
0 0 .251 r
.20489 .42763 m .18316 .35627 L p .19984 .40943 L F P
0 g
s
.437 .502 .828 r
.57567 .48029 m .70239 .68478 L .72433 .6729 L p F P
0 g
s
.437 .502 .828 r
.72433 .6729 m .58217 .47746 L .57567 .48029 L p F P
0 g
s
.641 .579 .77 r
.70239 .68478 m .57567 .48029 L .58217 .47746 L p F P
0 g
s
.641 .579 .77 r
.58217 .47746 m .72433 .6729 L .70239 .68478 L p F P
0 g
s
.409 .509 .849 r
.58217 .47746 m .72433 .6729 L .74526 .65983 L p F P
0 g
s
.409 .509 .849 r
.74526 .65983 m .58787 .47459 L .58217 .47746 L p F P
0 g
s
.633 .583 .78 r
.72433 .6729 m .58217 .47746 L .58787 .47459 L p F P
0 g
s
.633 .583 .78 r
.58787 .47459 m .74526 .65983 L .72433 .6729 L p F P
0 g
s
.381 .518 .87 r
.58787 .47459 m .74526 .65983 L .765 .64559 L p F P
0 g
s
.381 .518 .87 r
.765 .64559 m .59279 .4717 L .58787 .47459 L p F P
0 g
s
.627 .587 .79 r
.74526 .65983 m .58787 .47459 L .59279 .4717 L p F P
0 g
s
.627 .587 .79 r
.59279 .4717 m .765 .64559 L .74526 .65983 L p F P
0 g
s
.352 .529 .891 r
.59279 .4717 m .765 .64559 L .78339 .63023 L p F P
0 g
s
.352 .529 .891 r
.78339 .63023 m .59693 .46881 L .59279 .4717 L p F P
0 g
s
.621 .593 .8 r
.765 .64559 m .59279 .4717 L .59693 .46881 L p F P
0 g
s
.621 .593 .8 r
.59693 .46881 m .78339 .63023 L .765 .64559 L p F P
0 g
s
.323 .544 .911 r
.59693 .46881 m .78339 .63023 L .80027 .61377 L p F P
0 g
s
.323 .544 .911 r
.80027 .61377 m .60032 .46597 L .59693 .46881 L p F P
0 g
s
.616 .599 .811 r
.78339 .63023 m .59693 .46881 L .60032 .46597 L p F P
0 g
s
.616 .599 .811 r
.60032 .46597 m .80027 .61377 L .78339 .63023 L p F P
0 g
s
.296 .56 .928 r
.60032 .46597 m .80027 .61377 L .81548 .59629 L p F P
0 g
s
.296 .56 .928 r
.81548 .59629 m .60297 .46318 L .60032 .46597 L p F P
0 g
s
.612 .607 .821 r
.80027 .61377 m .60032 .46597 L .60297 .46318 L p F P
0 g
s
.612 .607 .821 r
.60297 .46318 m .81548 .59629 L .80027 .61377 L p F P
0 g
s
.272 .58 .942 r
.60297 .46318 m .81548 .59629 L .82884 .57783 L p F P
0 g
s
.272 .58 .942 r
.82884 .57783 m .6049 .46047 L .60297 .46318 L p F P
0 g
s
.61 .615 .831 r
.81548 .59629 m .60297 .46318 L .6049 .46047 L p F P
0 g
s
.61 .615 .831 r
.6049 .46047 m .82884 .57783 L .81548 .59629 L p F P
0 g
s
.254 .602 .953 r
.6049 .46047 m .82884 .57783 L .84022 .55847 L p F P
0 g
s
.254 .602 .953 r
.84022 .55847 m .60613 .45785 L .6049 .46047 L p F P
0 g
s
.609 .624 .841 r
.82884 .57783 m .6049 .46047 L .60613 .45785 L p F P
0 g
s
.609 .624 .841 r
.60613 .45785 m .84022 .55847 L .82884 .57783 L p F P
0 g
s
.243 .628 .959 r
.60613 .45785 m .84022 .55847 L .84945 .53831 L p F P
0 g
s
.243 .628 .959 r
.84945 .53831 m .60667 .45535 L .60613 .45785 L p F P
0 g
s
.609 .634 .85 r
.84022 .55847 m .60613 .45785 L .60667 .45535 L p F P
0 g
s
.809 .497 0 r
.18316 .35627 m .24613 .56304 L .24093 .57402 L p F P
0 g
s
.609 .634 .85 r
.60667 .45535 m .84945 .53831 L .84022 .55847 L p F P
0 g
s
.243 .655 .962 r
.60667 .45535 m .84945 .53831 L .8564 .51743 L p F P
0 g
s
.243 .655 .962 r
.8564 .51743 m .60654 .45296 L .60667 .45535 L p F P
0 g
s
.611 .644 .858 r
.84945 .53831 m .60667 .45535 L .60654 .45296 L p F P
0 g
s
.254 .686 .962 r
.60654 .45296 m .8564 .51743 L .86093 .49595 L p F P
0 g
s
.254 .686 .962 r
.86093 .49595 m .60577 .4507 L .60654 .45296 L p F P
0 g
s
.611 .644 .858 r
.60654 .45296 m .8564 .51743 L .84945 .53831 L p F P
0 g
s
.614 .654 .865 r
.8564 .51743 m .60654 .45296 L .60577 .4507 L p F P
0 g
s
0 0 .251 r
.17971 .34265 m .25271 .55233 L .24613 .56304 L p F P
0 g
s
.278 .72 .963 r
.60577 .4507 m .86093 .49595 L .86294 .47398 L p F P
0 g
s
.278 .72 .963 r
.86294 .47398 m .60437 .44857 L .60577 .4507 L p F P
0 g
s
.614 .654 .865 r
.60577 .4507 m .86093 .49595 L .8564 .51743 L p F P
0 g
s
.619 .663 .871 r
.86093 .49595 m .60577 .4507 L .60437 .44857 L p F P
0 g
s
.619 .663 .871 r
.60437 .44857 m .86294 .47398 L .86093 .49595 L p F P
0 g
s
.314 .757 .964 r
.60437 .44857 m .86294 .47398 L .86233 .45167 L p F P
0 g
s
.314 .757 .964 r
.86233 .45167 m .60235 .44659 L .60437 .44857 L p F P
0 g
s
.624 .673 .876 r
.86294 .47398 m .60437 .44857 L .60235 .44659 L p F P
0 g
s
0 0 .424 r
.17821 .32874 m .26057 .54193 L .25271 .55233 L p F P
0 g
s
.361 .794 .966 r
.60235 .44659 m .86233 .45167 L .85901 .42916 L p F P
0 g
s
.361 .794 .966 r
.85901 .42916 m .59973 .44476 L .60235 .44659 L p F P
0 g
s
.624 .673 .876 r
.60235 .44659 m .86233 .45167 L .86294 .47398 L p F P
0 g
s
.631 .681 .879 r
.86233 .45167 m .60235 .44659 L .59973 .44476 L p F P
0 g
s
.631 .681 .879 r
.59973 .44476 m .85901 .42916 L .86233 .45167 L p F P
0 g
s
.416 .832 .969 r
.59973 .44476 m .85901 .42916 L .85294 .40661 L p F P
0 g
s
.416 .832 .969 r
.85294 .40661 m .59651 .44308 L .59973 .44476 L p F P
0 g
s
.639 .689 .881 r
.85901 .42916 m .59973 .44476 L .59651 .44308 L p F P
0 g
s
.464 .366 .659 r
.27971 .5223 m .18151 .30051 L .17877 .31466 L p F P
0 g
s
.464 .366 .659 r
.17877 .31466 m .26961 .53191 L .27971 .5223 L p F P
0 g
s
.008 .111 .624 r
.26961 .53191 m .17877 .31466 L .18151 .30051 L p F P
0 g
s
0 0 .546 r
.17877 .31466 m .26961 .53191 L .26057 .54193 L p F P
0 g
s
.478 .867 .973 r
.59651 .44308 m .85294 .40661 L .84408 .38417 L p F P
0 g
s
.478 .867 .973 r
.84408 .38417 m .59271 .44155 L .59651 .44308 L p F P
0 g
s
.639 .689 .881 r
.59651 .44308 m .85294 .40661 L .85901 .42916 L p F P
0 g
s
.647 .695 .881 r
.85294 .40661 m .59651 .44308 L .59271 .44155 L p F P
0 g
s
.542 .897 .975 r
.59271 .44155 m .84408 .38417 L .83244 .36203 L p F P
0 g
s
.542 .897 .975 r
.83244 .36203 m .58832 .44018 L .59271 .44155 L p F P
0 g
s
.647 .695 .881 r
.59271 .44155 m .84408 .38417 L .85294 .40661 L p F P
0 g
s
.655 .7 .88 r
.84408 .38417 m .59271 .44155 L .58832 .44018 L p F P
0 g
s
.51 .404 .67 r
.29076 .51317 m .18651 .28641 L .18151 .30051 L p F P
0 g
s
.51 .404 .67 r
.18151 .30051 m .27971 .5223 L .29076 .51317 L p F P
0 g
s
.146 .207 .67 r
.27971 .5223 m .18151 .30051 L .18651 .28641 L p F P
0 g
s
.008 .111 .624 r
.18151 .30051 m .27971 .5223 L .26961 .53191 L p F P
0 g
s
.604 .92 .974 r
.58832 .44018 m .83244 .36203 L .81804 .34036 L p F P
0 g
s
.604 .92 .974 r
.81804 .34036 m .58335 .43898 L .58832 .44018 L p F P
0 g
s
.655 .7 .88 r
.58832 .44018 m .83244 .36203 L .84408 .38417 L p F P
0 g
s
.662 .703 .877 r
.83244 .36203 m .58832 .44018 L .58335 .43898 L p F P
0 g
s
.662 .703 .877 r
.58335 .43898 m .81804 .34036 L .83244 .36203 L p F P
0 g
s
.662 .934 .969 r
.58335 .43898 m .81804 .34036 L .80097 .31935 L p F P
0 g
s
.662 .934 .969 r
.80097 .31935 m .5778 .43794 L .58335 .43898 L p F P
0 g
s
.67 .705 .874 r
.81804 .34036 m .58335 .43898 L .5778 .43794 L p F P
0 g
s
.548 .436 .678 r
.30263 .50453 m .19385 .27251 L .18651 .28641 L p F P
0 g
s
.548 .436 .678 r
.18651 .28641 m .29076 .51317 L .30263 .50453 L p F P
0 g
s
.25 .28 .698 r
.29076 .51317 m .18651 .28641 L .19385 .27251 L p F P
0 g
s
.146 .207 .67 r
.18651 .28641 m .29076 .51317 L .27971 .5223 L p F P
0 g
s
.711 .939 .959 r
.5778 .43794 m .80097 .31935 L .78131 .29917 L p F P
0 g
s
.711 .939 .959 r
.78131 .29917 m .57167 .43708 L .5778 .43794 L p F P
0 g
s
.67 .705 .874 r
.5778 .43794 m .80097 .31935 L .81804 .34036 L p F P
0 g
s
.676 .705 .869 r
.80097 .31935 m .5778 .43794 L .57167 .43708 L p F P
0 g
s
.676 .705 .869 r
.57167 .43708 m .78131 .29917 L .80097 .31935 L p F P
0 g
s
.751 .935 .946 r
.57167 .43708 m .78131 .29917 L .75922 .28002 L p F P
0 g
s
.751 .935 .946 r
.75922 .28002 m .56495 .4364 L .57167 .43708 L p F P
0 g
s
.682 .703 .863 r
.78131 .29917 m .57167 .43708 L .56495 .4364 L p F P
0 g
s
.581 .465 .686 r
.3152 .49641 m .20359 .25895 L .19385 .27251 L p F P
0 g
s
.581 .465 .686 r
.19385 .27251 m .30263 .50453 L .3152 .49641 L p F P
0 g
s
.33 .336 .715 r
.30263 .50453 m .19385 .27251 L .20359 .25895 L p F P
0 g
s
.25 .28 .698 r
.19385 .27251 m .30263 .50453 L .29076 .51317 L p F P
0 g
s
.682 .703 .863 r
.56495 .4364 m .75922 .28002 L .78131 .29917 L p F P
0 g
s
.782 .924 .93 r
.56495 .4364 m .75922 .28002 L .73486 .26206 L p F P
0 g
s
.782 .924 .93 r
.73486 .26206 m .55765 .43591 L .56495 .4364 L p F P
0 g
s
.686 .699 .856 r
.75922 .28002 m .56495 .4364 L .55765 .43591 L p F P
0 g
s
.686 .699 .856 r
.55765 .43591 m .73486 .26206 L .75922 .28002 L p F P
0 g
s
.804 .908 .912 r
.55765 .43591 m .73486 .26206 L .70844 .24546 L p F P
0 g
s
.804 .908 .912 r
.70844 .24546 m .54976 .43562 L .55765 .43591 L p F P
0 g
s
.689 .694 .849 r
.73486 .26206 m .55765 .43591 L .54976 .43562 L p F P
0 g
s
.609 .49 .692 r
.32834 .48884 m .21577 .24586 L .20359 .25895 L p F P
0 g
s
.609 .49 .692 r
.20359 .25895 m .3152 .49641 L .32834 .48884 L p F P
0 g
s
.393 .381 .727 r
.3152 .49641 m .20359 .25895 L .21577 .24586 L p F P
0 g
s
.33 .336 .715 r
.20359 .25895 m .3152 .49641 L .30263 .50453 L p F P
0 g
s
.819 .887 .893 r
.54976 .43562 m .70844 .24546 L .6802 .23037 L p F P
0 g
s
.819 .887 .893 r
.6802 .23037 m .54128 .43555 L .54976 .43562 L p F P
0 g
s
.689 .694 .849 r
.54976 .43562 m .70844 .24546 L .73486 .26206 L p F P
0 g
s
.691 .687 .842 r
.70844 .24546 m .54976 .43562 L .54128 .43555 L p F P
0 g
s
.826 .864 .874 r
.54128 .43555 m .6802 .23037 L .65043 .21693 L p F P
0 g
s
.826 .864 .874 r
.65043 .21693 m .5322 .43571 L .54128 .43555 L p F P
0 g
s
.691 .687 .842 r
.54128 .43555 m .6802 .23037 L .70844 .24546 L p F P
0 g
s
.691 .68 .834 r
.6802 .23037 m .54128 .43555 L .5322 .43571 L p F P
0 g
s
.829 .84 .855 r
.5322 .43571 m .65043 .21693 L .61941 .20525 L p F P
0 g
s
.829 .84 .855 r
.61941 .20525 m .52254 .43612 L .5322 .43571 L p F P
0 g
s
.691 .68 .834 r
.5322 .43571 m .65043 .21693 L .6802 .23037 L p F P
0 g
s
.689 .671 .827 r
.65043 .21693 m .5322 .43571 L .52254 .43612 L p F P
0 g
s
.635 .514 .698 r
.34192 .48182 m .23038 .23342 L .21577 .24586 L p F P
0 g
s
.635 .514 .698 r
.21577 .24586 m .32834 .48884 L .34192 .48182 L p F P
0 g
s
.442 .417 .736 r
.32834 .48884 m .21577 .24586 L .23038 .23342 L p F P
0 g
s
.393 .381 .727 r
.21577 .24586 m .32834 .48884 L .3152 .49641 L p F P
0 g
s
.689 .671 .827 r
.52254 .43612 m .61941 .20525 L .65043 .21693 L p F P
0 g
s
.828 .815 .838 r
.52254 .43612 m .61941 .20525 L .58746 .19542 L p F P
0 g
s
.828 .815 .838 r
.58746 .19542 m .5123 .43681 L .52254 .43612 L p F P
0 g
s
.687 .661 .819 r
.61941 .20525 m .52254 .43612 L .5123 .43681 L p F P
0 g
s
.687 .661 .819 r
.5123 .43681 m .58746 .19542 L .61941 .20525 L p F P
0 g
s
.823 .791 .821 r
.5123 .43681 m .58746 .19542 L .55491 .18752 L p F P
0 g
s
.823 .791 .821 r
.55491 .18752 m .50149 .43778 L .5123 .43681 L p F P
0 g
s
.682 .65 .812 r
.58746 .19542 m .5123 .43681 L .50149 .43778 L p F P
0 g
s
.657 .536 .705 r
.35582 .47536 m .24741 .22178 L .23038 .23342 L p F P
0 g
s
.657 .536 .705 r
.23038 .23342 m .34192 .48182 L .35582 .47536 L p F P
0 g
s
.483 .448 .742 r
.34192 .48182 m .23038 .23342 L .24741 .22178 L p F P
0 g
s
.442 .417 .736 r
.23038 .23342 m .34192 .48182 L .32834 .48884 L p F P
0 g
s
.682 .65 .812 r
.50149 .43778 m .55491 .18752 L .58746 .19542 L p F P
0 g
s
.817 .767 .806 r
.50149 .43778 m .55491 .18752 L .5221 .18159 L p F P
0 g
s
.817 .767 .806 r
.5221 .18159 m .49013 .43908 L .50149 .43778 L p F P
0 g
s
.677 .639 .804 r
.55491 .18752 m .50149 .43778 L .49013 .43908 L p F P
0 g
s
.677 .639 .804 r
.49013 .43908 m .5221 .18159 L .55491 .18752 L p F P
0 g
s
.808 .743 .792 r
.49013 .43908 m .5221 .18159 L .48937 .17764 L p F P
0 g
s
.808 .743 .792 r
.48937 .17764 m .47825 .44072 L .49013 .43908 L p F P
0 g
s
.669 .626 .797 r
.5221 .18159 m .49013 .43908 L .47825 .44072 L p F P
0 g
s
.669 .626 .797 r
.47825 .44072 m .48937 .17764 L .5221 .18159 L p F P
0 g
s
.798 .721 .779 r
.47825 .44072 m .48937 .17764 L .45705 .17567 L p F P
0 g
s
.798 .721 .779 r
.45705 .17567 m .46587 .44273 L .47825 .44072 L p F P
0 g
s
.661 .613 .791 r
.48937 .17764 m .47825 .44072 L .46587 .44273 L p F P
0 g
s
.661 .613 .791 r
.46587 .44273 m .45705 .17567 L .48937 .17764 L p F P
0 g
s
.786 .699 .768 r
.46587 .44273 m .45705 .17567 L .42548 .17562 L p F P
0 g
s
.786 .699 .768 r
.42548 .17562 m .45303 .44514 L .46587 .44273 L p F P
0 g
s
.65 .6 .784 r
.45705 .17567 m .46587 .44273 L .45303 .44514 L p F P
0 g
s
.678 .557 .711 r
.36992 .46947 m .26681 .21109 L .24741 .22178 L p F P
0 g
s
.678 .557 .711 r
.24741 .22178 m .35582 .47536 L .36992 .46947 L p F P
0 g
s
.517 .474 .748 r
.35582 .47536 m .24741 .22178 L .26681 .21109 L p F P
0 g
s
.483 .448 .742 r
.24741 .22178 m .35582 .47536 L .34192 .48182 L p F P
0 g
s
.774 .678 .758 r
.45303 .44514 m .42548 .17562 L .39495 .17746 L p F P
0 g
s
.774 .678 .758 r
.39495 .17746 m .43979 .44798 L .45303 .44514 L p F P
0 g
s
.65 .6 .784 r
.45303 .44514 m .42548 .17562 L .45705 .17567 L p F P
0 g
s
.638 .585 .779 r
.42548 .17562 m .45303 .44514 L .43979 .44798 L p F P
0 g
s
.76 .657 .748 r
.43979 .44798 m .39495 .17746 L .36574 .18108 L p F P
0 g
s
.76 .657 .748 r
.36574 .18108 m .42621 .45127 L .43979 .44798 L p F P
0 g
s
.638 .585 .779 r
.43979 .44798 m .39495 .17746 L .42548 .17562 L p F P
0 g
s
.624 .57 .773 r
.39495 .17746 m .43979 .44798 L .42621 .45127 L p F P
0 g
s
.746 .637 .739 r
.42621 .45127 m .36574 .18108 L .33812 .18638 L p F P
0 g
s
.746 .637 .739 r
.33812 .18638 m .41235 .45504 L .42621 .45127 L p F P
0 g
s
.624 .57 .773 r
.42621 .45127 m .36574 .18108 L .39495 .17746 L p F P
0 g
s
.609 .554 .768 r
.36574 .18108 m .42621 .45127 L .41235 .45504 L p F P
0 g
s
.517 .474 .748 r
.26681 .21109 m .36992 .46947 L .35582 .47536 L p F P
0 g
s
.609 .554 .768 r
.41235 .45504 m .33812 .18638 L .36574 .18108 L p F P
0 g
s
.73 .617 .731 r
.41235 .45504 m .33812 .18638 L .3123 .19324 L p F P
0 g
s
.73 .617 .731 r
.3123 .19324 m .39828 .45932 L .41235 .45504 L p F P
0 g
s
.59 .536 .763 r
.33812 .18638 m .41235 .45504 L .39828 .45932 L p F P
0 g
s
.697 .577 .717 r
.26681 .21109 m .36992 .46947 L .38411 .46412 L p F P
0 g
s
.697 .577 .717 r
.38411 .46412 m .28848 .20153 L .26681 .21109 L p F P
0 g
s
.545 .497 .753 r
.28848 .20153 m .38411 .46412 L .36992 .46947 L p F P
0 g
s
.545 .497 .753 r
.36992 .46947 m .26681 .21109 L .28848 .20153 L p F P
0 g
s
.714 .597 .724 r
.39828 .45932 m .3123 .19324 L .28848 .20153 L p F P
0 g
s
.714 .597 .724 r
.28848 .20153 m .38411 .46412 L .39828 .45932 L p F P
0 g
s
.59 .536 .763 r
.39828 .45932 m .3123 .19324 L .33812 .18638 L p F P
0 g
s
.569 .518 .758 r
.3123 .19324 m .39828 .45932 L .38411 .46412 L p F P
0 g
s
.569 .518 .758 r
.38411 .46412 m .28848 .20153 L .3123 .19324 L p F P
0 g
s
.25 Mabswid
.67192 0 m
.97204 .44698 L
s
.97204 .44698 m
1 .66282 L
s
1 .66282 m
.68338 .23633 L
s
.68338 .23633 m
.67192 0 L
s
.03445 .24853 m
0 .47506 L
s
0 .47506 m
.68338 .23633 L
s
.68338 .23633 m
.67192 0 L
s
.67192 0 m
.03445 .24853 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.42.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.42.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Cone[1, 1, 20]",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Cylinder[1, 1, 20]",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["DoubleHelix[1, 0.5, 2, 20]",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Helix[1, 0.5, 2, 20]",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MoebiusStrip[1, 0.5, 20]",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Sphere[1, 20, 15]",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Torus[1, 0.5, 20, 10]",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.42.1"],

Cell["Shapes with default values of parameters.", "Caption",
 CellTags->"S5.42.1"],

Cell[TextData[{
 "You can adjust the position, orientation, and scale of any shape by using \
",
 StyleBox["TranslateShape", "MR"],
 ", ",
 StyleBox["RotateShape", "MR"],
 ", and ",
 StyleBox["AffineShape", "MR"],
 ". These functions work by transforming all the coordinates of points given \
in the polygon list. For example, ",
 StyleBox["RotateShape", "MR"],
 " multiplies all the coordinates in the polygon list by a specified rotation \
matrix. "
}], "Text",
 CellTags->{"S5.42.1", "1.8"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RotateShape[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["phi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["psi", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["rotate the graphics object ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" by the specified Euler angles",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TranslateShape[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "translate the graphics object by the specified vector",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["AffineShape[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["scale",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["scale",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["scale",
          "TI"], "3"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "multiply all coordinates by the respective scale factors",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.42.1"],

Cell["\<\
Geometric operations on three\[Hyphen]dimensional graphics objects. \
\>", "Caption",
 CellTags->"S5.42.1"],

Cell[TextData[{
 "This rotates the M\[ODoubleDot]bius strip by the Euler angles ",
 StyleBox["Pi/4", "MR"],
 ", ",
 StyleBox["Pi/3", "MR"],
 " and ",
 StyleBox["Pi/2", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.42.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
Show[RotateShape[
         Graphics3D[MoebiusStrip[ ] ],
                  Pi/4, Pi/3, Pi/2]]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.42.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.15492 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0861925 1.24159 -7.69784e-18 1.24159 [
[ 0 0 0 0 ]
[ 1 1.15492 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07463 .21727 m
0 .78045 L
s
0 .78045 m
.47594 1.15492 L
s
.47594 1.15492 m
.48272 .6456 L
s
.48272 .6456 m
.07463 .21727 L
s
.60278 0 m
.9424 .49902 L
s
.9424 .49902 m
1 1.02908 L
s
1 1.02908 m
.61499 .58237 L
s
.61499 .58237 m
.60278 0 L
s
.07463 .21727 m
0 .78045 L
s
0 .78045 m
.61499 .58237 L
s
.61499 .58237 m
.60278 0 L
s
.60278 0 m
.07463 .21727 L
s
.48272 .6456 m
.9424 .49902 L
s
.9424 .49902 m
1 1.02908 L
s
1 1.02908 m
.47594 1.15492 L
s
.47594 1.15492 m
.48272 .6456 L
s
0 0 m
1 0 L
1 1.15492 L
0 1.15492 L
closepath
clip
newpath
.5 Mabswid
.426 .258 .549 r
.77355 .72988 m .6089 .71268 L .58124 .80727 L p F P
0 g
s
.426 .258 .549 r
.58124 .80727 m .72791 .78014 L .77355 .72988 L p F P
0 g
s
.416 .103 .323 r
.72791 .78014 m .58124 .80727 L .6089 .71268 L p F P
0 g
s
.416 .103 .323 r
.6089 .71268 m .77355 .72988 L .72791 .78014 L p F P
0 g
s
.489 .39 .669 r
.6089 .71268 m .77355 .72988 L .80949 .66012 L p F P
0 g
s
.489 .39 .669 r
.80949 .66012 m .61856 .61937 L .6089 .71268 L p F P
0 g
s
.512 .305 .537 r
.77355 .72988 m .6089 .71268 L .61856 .61937 L p F P
0 g
s
.527 .49 .759 r
.61856 .61937 m .80949 .66012 L .83105 .5753 L p F P
0 g
s
.527 .49 .759 r
.83105 .5753 m .61149 .53563 L .61856 .61937 L p F P
0 g
s
.512 .305 .537 r
.61856 .61937 m .80949 .66012 L .77355 .72988 L p F P
0 g
s
.553 .419 .652 r
.80949 .66012 m .61856 .61937 L .61149 .53563 L p F P
0 g
s
.284 .026 .336 r
.72791 .78014 m .58124 .80727 L .53609 .89363 L p F P
0 g
s
.082 0 0 r
.67724 .8089 m .53609 .89363 L .58124 .80727 L p F P
0 g
s
.082 0 0 r
.58124 .80727 m .72791 .78014 L .67724 .8089 L p F P
0 g
s
.553 .419 .652 r
.61149 .53563 m .83105 .5753 L .80949 .66012 L p F P
0 g
s
.558 .586 .838 r
.61149 .53563 m .83105 .5753 L .83401 .48214 L p F P
0 g
s
.558 .586 .838 r
.83401 .48214 m .59047 .46817 L .61149 .53563 L p F P
0 g
s
.581 .505 .734 r
.83105 .5753 m .61149 .53563 L .59047 .46817 L p F P
0 g
s
.559 .918 .954 r
.53609 .89363 m .67724 .8089 L .62581 .81656 L p F P
0 g
s
.284 .026 .336 r
.67724 .8089 m .72791 .78014 L p .63683 .83403 L F P
0 g
s
.284 .026 .336 r
.53609 .89363 m .61557 .84592 L p .63683 .83403 L F P
0 g
s
.284 .026 .336 r
.61557 .84592 m .67724 .8089 L p .63683 .83403 L F P
0 g
s
.706 .819 .936 r
.57708 .80557 m .40611 .99968 L .47602 .96136 L p F P
0 g
s
0 0 0 r
.56245 .87781 m .53609 .89363 L .47602 .96136 L p F P
0 g
s
0 0 0 r
.67724 .8089 m .56245 .87781 L p .47602 .96136 L F P
0 g
s
.559 .918 .954 r
.62581 .81656 m .47602 .96136 L .53609 .89363 L p F P
0 g
s
.706 .819 .936 r
.47602 .96136 m .62581 .81656 L .57708 .80557 L p F P
0 g
s
.682 .974 .798 r
.47602 .96136 m .40611 .99968 L p .53962 .8884 L F P
0 g
s
.682 .974 .798 r
.62581 .81656 m .5678 .87264 L p .53962 .8884 L F P
0 g
s
.682 .974 .798 r
.5678 .87264 m .47602 .96136 L p .53962 .8884 L F P
0 g
s
.581 .505 .734 r
.59047 .46817 m .83401 .48214 L .83105 .5753 L p F P
0 g
s
.594 .696 .914 r
.59047 .46817 m .83401 .48214 L .8149 .38944 L p F P
0 g
s
.594 .696 .914 r
.8149 .38944 m .55958 .42173 L .59047 .46817 L p F P
0 g
s
.608 .585 .802 r
.83401 .48214 m .59047 .46817 L .55958 .42173 L p F P
0 g
s
.608 .585 .802 r
.55958 .42173 m .8149 .38944 L .83401 .48214 L p F P
0 g
s
.644 .829 .972 r
.55958 .42173 m .8149 .38944 L .77158 .30784 L p F P
0 g
s
.644 .829 .972 r
.77158 .30784 m .52378 .39859 L .55958 .42173 L p F P
0 g
s
.643 .67 .861 r
.8149 .38944 m .55958 .42173 L .52378 .39859 L p F P
0 g
s
0 0 0 r
.47602 .96136 m .62581 .81656 L .67724 .8089 L p F P
0 g
s
.643 .67 .861 r
.52378 .39859 m .77158 .30784 L .8149 .38944 L p F P
0 g
s
.702 .957 .949 r
.52378 .39859 m .77158 .30784 L .70397 .24933 L p F P
0 g
s
.702 .957 .949 r
.70397 .24933 m .48823 .39833 L .52378 .39859 L p F P
0 g
s
.691 .762 .906 r
.77158 .30784 m .52378 .39859 L .48823 .39833 L p F P
0 g
s
.729 .722 .844 r
.53342 .77969 m .33432 .99873 L .40611 .99968 L p F P
0 g
s
.729 .722 .844 r
.40611 .99968 m .57708 .80557 L .53342 .77969 L p F P
0 g
s
.83 .945 .898 r
.57708 .80557 m .40611 .99968 L .33432 .99873 L p F P
0 g
s
.682 .974 .798 r
.40611 .99968 m .57708 .80557 L .62581 .81656 L p F P
0 g
s
.691 .762 .906 r
.48823 .39833 m .70397 .24933 L .77158 .30784 L p F P
0 g
s
.75 .986 .763 r
.48823 .39833 m .70397 .24933 L .61511 .22605 L p F P
0 g
s
.75 .986 .763 r
.61511 .22605 m .45752 .41799 L .48823 .39833 L p F P
0 g
s
.754 .852 .924 r
.45752 .41799 m .61511 .22605 L .70397 .24933 L p F P
0 g
s
.754 .852 .924 r
.48823 .39833 m .45752 .41799 L p .59611 .32315 L F P
0 g
s
.825 .916 .899 r
.45752 .41799 m .435 .4529 L p .54256 .31744 L F P
0 g
s
.825 .916 .899 r
.61511 .22605 m .57067 .28019 L p .54256 .31744 L F P
0 g
s
.825 .916 .899 r
.57067 .28019 m .45752 .41799 L p .54256 .31744 L F P
0 g
s
.821 .919 .527 r
.45752 .41799 m .61511 .22605 L .51224 .24792 L p F P
0 g
s
.821 .919 .527 r
.51224 .24792 m .435 .4529 L .45752 .41799 L p F P
0 g
s
.825 .916 .899 r
.435 .4529 m .44578 .4243 L p .47141 .40705 L F P
0 g
s
.825 .916 .899 r
.44578 .4243 m .51224 .24792 L p .47141 .40705 L F P
0 g
s
.887 .932 .843 r
.51224 .24792 m .435 .4529 L .4224 .49781 L p F P
0 g
s
.945 .854 .427 r
.435 .4529 m .51224 .24792 L .40705 .31911 L p F P
0 g
s
.887 .932 .843 r
.40705 .31911 m .51224 .24792 L p .43691 .45744 L F P
0 g
s
.945 .854 .427 r
.40705 .31911 m .4224 .49781 L .435 .4529 L p F P
0 g
s
.887 .932 .843 r
.4224 .49781 m .42077 .47883 L p .43691 .45744 L F P
0 g
s
.887 .932 .843 r
.42077 .47883 m .40705 .31911 L p .43691 .45744 L F P
0 g
s
.825 .916 .899 r
.51224 .24792 m .61511 .22605 L p .47141 .40705 L F P
0 g
s
.754 .852 .924 r
.70397 .24933 m .63413 .29756 L p .59611 .32315 L F P
0 g
s
.754 .852 .924 r
.63413 .29756 m .48823 .39833 L p .59611 .32315 L F P
0 g
s
.746 .665 .771 r
.49613 .74301 m .27137 .95187 L .33432 .99873 L p F P
0 g
s
.746 .665 .771 r
.33432 .99873 m .53342 .77969 L .49613 .74301 L p F P
0 g
s
.846 .861 .854 r
.53342 .77969 m .33432 .99873 L .27137 .95187 L p F P
0 g
s
.83 .945 .898 r
.33432 .99873 m .53342 .77969 L .57708 .80557 L p F P
0 g
s
.998 .775 .459 r
.4224 .49781 m .40705 .31911 L .31441 .43459 L p F P
0 g
s
.998 .775 .459 r
.31441 .43459 m .41998 .54795 L .4224 .49781 L p F P
0 g
s
.922 .906 .789 r
.40705 .31911 m .4224 .49781 L .41998 .54795 L p F P
0 g
s
.846 .861 .854 r
.27137 .95187 m .49613 .74301 L .53342 .77969 L p F P
0 g
s
.922 .906 .789 r
.41998 .54795 m .31441 .43459 L .40705 .31911 L p F P
0 g
s
.942 .691 .528 r
.41998 .54795 m .31441 .43459 L .24882 .57872 L p F P
0 g
s
.942 .691 .528 r
.24882 .57872 m .42704 .59973 L .41998 .54795 L p F P
0 g
s
.924 .861 .761 r
.31441 .43459 m .41998 .54795 L .42704 .59973 L p F P
0 g
s
.771 .634 .709 r
.27137 .95187 m .49613 .74301 L .46575 .69913 L p F P
0 g
s
.771 .634 .709 r
.46575 .69913 m .22955 .85874 L .27137 .95187 L p F P
0 g
s
.857 .817 .809 r
.22955 .85874 m .46575 .69913 L .49613 .74301 L p F P
0 g
s
.857 .817 .809 r
.49613 .74301 m .27137 .95187 L .22955 .85874 L p F P
0 g
s
.868 .641 .593 r
.42704 .59973 m .24882 .57872 L .21997 .72822 L p F P
0 g
s
.868 .641 .593 r
.21997 .72822 m .44257 .65073 L .42704 .59973 L p F P
0 g
s
.924 .861 .761 r
.42704 .59973 m .24882 .57872 L .31441 .43459 L p F P
0 g
s
.903 .823 .758 r
.24882 .57872 m .42704 .59973 L .44257 .65073 L p F P
0 g
s
.81 .625 .652 r
.22955 .85874 m .46575 .69913 L .44257 .65073 L p F P
0 g
s
.81 .625 .652 r
.44257 .65073 m .21997 .72822 L .22955 .85874 L p F P
0 g
s
.878 .807 .776 r
.21997 .72822 m .44257 .65073 L .46575 .69913 L p F P
0 g
s
.878 .807 .776 r
.46575 .69913 m .22955 .85874 L .21997 .72822 L p F P
0 g
s
.903 .823 .758 r
.44257 .65073 m .21997 .72822 L .24882 .57872 L p F P
0 g
s
.25 Mabswid
.60278 0 m
.9424 .49902 L
s
.9424 .49902 m
1 1.02908 L
s
1 1.02908 m
.61499 .58237 L
s
.61499 .58237 m
.60278 0 L
s
.07463 .21727 m
0 .78045 L
s
0 .78045 m
.61499 .58237 L
s
.61499 .58237 m
.60278 0 L
s
.60278 0 m
.07463 .21727 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.42.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.42.1"]
}, Open  ]],

Cell[TextData[{
 "This translates the helix with the smaller radius a distance of ",
 Cell[BoxData[
  FormBox["1.5", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " in the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " direction. The helix with the larger radius has twice as many turns. "
}], "MathCaption",
 CellTags->{"S5.42.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
Show[TranslateShape[
        Graphics3D[ Helix[0.5, 0.5, 2, 20] ],
                {1.5, 0, 0}],
        Graphics3D[ Helix[1, 0.5, 4, 20] ]]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.42.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .73441 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.91108e-17 1.01349 -0.10373 1.01349 [
[ 0 0 0 0 ]
[ 1 .73441 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02904 .26976 m
0 .48936 L
s
0 .48936 m
.29917 .73441 L
s
.29917 .73441 m
.30963 .52902 L
s
.30963 .52902 m
.02904 .26976 L
s
.75919 0 m
.97244 .32367 L
s
.97244 .32367 m
1 .54061 L
s
1 .54061 m
.7766 .23052 L
s
.7766 .23052 m
.75919 0 L
s
.02904 .26976 m
0 .48936 L
s
0 .48936 m
.7766 .23052 L
s
.7766 .23052 m
.75919 0 L
s
.75919 0 m
.02904 .26976 L
s
.30963 .52902 m
.97244 .32367 L
s
.97244 .32367 m
1 .54061 L
s
1 .54061 m
.29917 .73441 L
s
.29917 .73441 m
.30963 .52902 L
s
0 0 m
1 0 L
1 .73441 L
0 .73441 L
closepath
clip
newpath
.5 Mabswid
.675 .752 .909 r
.39806 .35307 m .44713 .49051 L .37496 .49391 L p F P
0 g
s
.676 .748 .905 r
.44713 .49051 m .39806 .35307 L .39814 .35061 L p F P
0 g
s
.676 .748 .905 r
.39814 .35061 m .51525 .47444 L .44713 .49051 L p F P
0 g
s
.675 .752 .909 r
.37496 .49391 m .39799 .35553 L .39806 .35307 L p F P
0 g
s
.673 .755 .913 r
.39799 .35553 m .37496 .49391 L .30441 .48462 L p F P
0 g
s
.675 .744 .903 r
.51525 .47444 m .39814 .35061 L .39821 .34815 L p F P
0 g
s
.675 .744 .903 r
.39821 .34815 m .57377 .44653 L .51525 .47444 L p F P
0 g
s
.673 .755 .913 r
.30441 .48462 m .39792 .35799 L .39799 .35553 L p F P
0 g
s
.67 .758 .916 r
.39792 .35799 m .30441 .48462 L .24117 .46337 L p F P
0 g
s
.672 .757 .914 r
.3966 .40291 m .44638 .53872 L .3733 .54217 L p F P
0 g
s
.673 .752 .91 r
.44638 .53872 m .3966 .40291 L .39667 .40039 L p F P
0 g
s
.673 .752 .91 r
.39667 .40039 m .51536 .52276 L .44638 .53872 L p F P
0 g
s
.672 .757 .914 r
.3733 .54217 m .39652 .40544 L .3966 .40291 L p F P
0 g
s
.67 .76 .918 r
.39652 .40544 m .3733 .54217 L .30185 .53309 L p F P
0 g
s
.673 .739 .9 r
.57377 .44653 m .39821 .34815 L .39828 .3457 L p F P
0 g
s
.673 .739 .9 r
.39828 .3457 m .61739 .40844 L .57377 .44653 L p F P
0 g
s
.672 .748 .907 r
.51536 .52276 m .39667 .40039 L .39675 .39787 L p F P
0 g
s
.672 .748 .907 r
.39675 .39787 m .57463 .49511 L .51536 .52276 L p F P
0 g
s
.67 .76 .918 r
.30185 .53309 m .39645 .40797 L .39652 .40544 L p F P
0 g
s
.667 .762 .922 r
.39645 .40797 m .30185 .53309 L .23777 .5122 L p F P
0 g
s
.67 .758 .916 r
.24117 .46337 m .39785 .36046 L .39792 .35799 L p F P
0 g
s
.665 .759 .92 r
.39785 .36046 m .24117 .46337 L .19079 .43171 L p F P
0 g
s
.669 .761 .919 r
.39509 .45413 m .44561 .58816 L .3716 .59166 L p F P
0 g
s
.67 .757 .916 r
.44561 .58816 m .39509 .45413 L .39517 .45153 L p F P
0 g
s
.67 .757 .916 r
.39517 .45153 m .51547 .57233 L .44561 .58816 L p F P
0 g
s
.669 .761 .919 r
.3716 .59166 m .39502 .45672 L .39509 .45413 L p F P
0 g
s
.667 .765 .923 r
.39502 .45672 m .3716 .59166 L .29922 .58281 L p F P
0 g
s
.67 .744 .905 r
.57463 .49511 m .39675 .39787 L .39682 .39535 L p F P
0 g
s
.67 .744 .905 r
.39682 .39535 m .61884 .45738 L .57463 .49511 L p F P
0 g
s
.67 .752 .913 r
.51547 .57233 m .39517 .45153 L .39524 .44894 L p F P
0 g
s
.67 .752 .913 r
.39524 .44894 m .57551 .54495 L .51547 .57233 L p F P
0 g
s
.667 .765 .923 r
.29922 .58281 m .39494 .45933 L .39502 .45672 L p F P
0 g
s
.663 .767 .927 r
.39494 .45933 m .29922 .58281 L .23427 .5623 L p F P
0 g
s
.667 .762 .922 r
.23777 .5122 m .39637 .41051 L .39645 .40797 L p F P
0 g
s
.662 .763 .925 r
.39637 .41051 m .23777 .5122 L .18666 .48102 L p F P
0 g
s
.67 .736 .899 r
.61739 .40844 m .39828 .3457 L .39835 .34325 L p F P
0 g
s
.67 .736 .899 r
.39835 .34325 m .64148 .3628 L .61739 .40844 L p F P
0 g
s
.665 .759 .92 r
.19079 .43171 m .39777 .36293 L .39785 .36046 L p F P
0 g
s
.661 .758 .922 r
.39777 .36293 m .19079 .43171 L .15838 .39212 L p F P
0 g
s
.666 .766 .925 r
.39354 .50676 m .44482 .63887 L .36986 .64243 L p F P
0 g
s
.667 .762 .921 r
.44482 .63887 m .39354 .50676 L .39362 .50409 L p F P
0 g
s
.667 .762 .921 r
.39362 .50409 m .51559 .62318 L .44482 .63887 L p F P
0 g
s
.666 .766 .925 r
.36986 .64243 m .39347 .50943 L .39354 .50676 L p F P
0 g
s
.663 .77 .929 r
.39347 .50943 m .36986 .64243 L .29652 .63381 L p F P
0 g
s
.668 .748 .91 r
.57551 .54495 m .39524 .44894 L .39532 .44636 L p F P
0 g
s
.668 .748 .91 r
.39532 .44636 m .62032 .50762 L .57551 .54495 L p F P
0 g
s
.666 .757 .918 r
.51559 .62318 m .39362 .50409 L .3937 .50143 L p F P
0 g
s
.666 .757 .918 r
.3937 .50143 m .57641 .5961 L .51559 .62318 L p F P
0 g
s
.663 .77 .929 r
.29652 .63381 m .39339 .5121 L .39347 .50943 L p F P
0 g
s
.659 .772 .933 r
.39339 .5121 m .29652 .63381 L .23068 .61372 L p F P
0 g
s
.663 .767 .927 r
.23427 .5623 m .39486 .46193 L .39494 .45933 L p F P
0 g
s
.658 .768 .931 r
.39486 .46193 m .23427 .5623 L .18243 .53164 L p F P
0 g
s
.667 .74 .904 r
.61884 .45738 m .39682 .39535 L .39689 .39284 L p F P
0 g
s
.667 .74 .904 r
.39689 .39284 m .64327 .41217 L .61884 .45738 L p F P
0 g
s
.662 .763 .925 r
.18666 .48102 m .3963 .41305 L .39637 .41051 L p F P
0 g
s
.657 .763 .928 r
.3963 .41305 m .18666 .48102 L .15373 .442 L p F P
0 g
s
.666 .733 .899 r
.64148 .3628 m .39835 .34325 L .39842 .34081 L p F P
0 g
s
.666 .733 .899 r
.39842 .34081 m .64251 .31324 L .64148 .3628 L p F P
0 g
s
.664 .752 .916 r
.57641 .5961 m .3937 .50143 L .39378 .49877 L p F P
0 g
s
.664 .752 .916 r
.39378 .49877 m .62184 .5592 L .57641 .5961 L p F P
0 g
s
.659 .772 .933 r
.23068 .61372 m .39331 .51478 L .39339 .5121 L p F P
0 g
s
.654 .773 .936 r
.39331 .51478 m .23068 .61372 L .17807 .58362 L p F P
0 g
s
.661 .758 .922 r
.15838 .39212 m .3977 .3654 L .39777 .36293 L p F P
0 g
s
.656 .756 .924 r
.3977 .3654 m .15838 .39212 L .14815 .34806 L p F P
0 g
s
.664 .744 .909 r
.62032 .50762 m .39532 .44636 L .3954 .44377 L p F P
0 g
s
.664 .744 .909 r
.3954 .44377 m .64511 .46287 L .62032 .50762 L p F P
0 g
s
.658 .768 .931 r
.18243 .53164 m .39479 .46454 L .39486 .46193 L p F P
0 g
s
.653 .767 .933 r
.39479 .46454 m .18243 .53164 L .14895 .49323 L p F P
0 g
s
.662 .73 .9 r
.64251 .31324 m .39842 .34081 L .3985 .33837 L p F P
0 g
s
.662 .73 .9 r
.3985 .33837 m .61886 .26427 L .64251 .31324 L p F P
0 g
s
.663 .736 .904 r
.64327 .41217 m .39689 .39284 L .39697 .39033 L p F P
0 g
s
.663 .736 .904 r
.39697 .39033 m .64436 .36304 L .64327 .41217 L p F P
0 g
s
.656 .756 .924 r
.14815 .34806 m .39763 .36788 L .3977 .3654 L p F P
0 g
s
.657 .763 .928 r
.15373 .442 m .39623 .41559 L .3963 .41305 L p F P
0 g
s
.652 .761 .929 r
.39623 .41559 m .15373 .442 L .14324 .39854 L p F P
0 g
s
.651 .753 .924 r
.39763 .36788 m .14815 .34806 L .16266 .30391 L p F P
0 g
s
.651 .753 .924 r
.16266 .30391 m .39756 .37036 L .39763 .36788 L p F P
0 g
s
.648 .75 .924 r
.39756 .37036 m .16266 .30391 L .20204 .26466 L p F P
0 g
s
.648 .75 .924 r
.20204 .26466 m .39748 .37284 L .39756 .37036 L p F P
0 g
s
.645 .745 .922 r
.39748 .37284 m .20204 .26466 L .26332 .2353 L p F P
0 g
s
.645 .745 .922 r
.26332 .2353 m .39741 .37533 L .39748 .37284 L p F P
0 g
s
.645 .741 .919 r
.39741 .37533 m .26332 .2353 L .34025 .22001 L p F P
0 g
s
.645 .741 .919 r
.34025 .22001 m .39734 .37782 L .39741 .37533 L p F P
0 g
s
.661 .748 .914 r
.62184 .5592 m .39378 .49877 L .39386 .49612 L p F P
0 g
s
.661 .748 .914 r
.39386 .49612 m .64701 .51497 L .62184 .5592 L p F P
0 g
s
.646 .738 .916 r
.42401 .22122 m .39726 .38032 L .39734 .37782 L p F P
0 g
s
.646 .738 .916 r
.39734 .37782 m .34025 .22001 L .42401 .22122 L p F P
0 g
s
.648 .735 .913 r
.50455 .23911 m .39719 .38281 L .39726 .38032 L p F P
0 g
s
.648 .735 .913 r
.39726 .38032 m .42401 .22122 L .50455 .23911 L p F P
0 g
s
.654 .773 .936 r
.17807 .58362 m .39323 .51746 L .39331 .51478 L p F P
0 g
s
.648 .772 .939 r
.39323 .51746 m .17807 .58362 L .14404 .54586 L p F P
0 g
s
.651 .734 .91 r
.57243 .27152 m .39712 .38532 L .39719 .38281 L p F P
0 g
s
.651 .734 .91 r
.39719 .38281 m .50455 .23911 L .57243 .27152 L p F P
0 g
s
.655 .733 .907 r
.62042 .31448 m .39704 .38782 L .39712 .38532 L p F P
0 g
s
.655 .733 .907 r
.39712 .38532 m .57243 .27152 L .62042 .31448 L p F P
0 g
s
.659 .734 .905 r
.64436 .36304 m .39697 .39033 L .39704 .38782 L p F P
0 g
s
.659 .734 .905 r
.39704 .38782 m .62042 .31448 L .64436 .36304 L p F P
0 g
s
.66 .74 .909 r
.64511 .46287 m .3954 .44377 L .39547 .44119 L p F P
0 g
s
.66 .74 .909 r
.39547 .44119 m .64626 .41423 L .64511 .46287 L p F P
0 g
s
.652 .761 .929 r
.14324 .39854 m .39615 .41813 L .39623 .41559 L p F P
0 g
s
.653 .767 .933 r
.14895 .49323 m .39471 .46715 L .39479 .46454 L p F P
0 g
s
.647 .765 .935 r
.39471 .46715 m .14895 .49323 L .1382 .45041 L p F P
0 g
s
.647 .758 .93 r
.39615 .41813 m .14324 .39854 L .15784 .35496 L p F P
0 g
s
.647 .758 .93 r
.15784 .35496 m .39608 .42068 L .39615 .41813 L p F P
0 g
s
.644 .754 .929 r
.39608 .42068 m .15784 .35496 L .19769 .31621 L p F P
0 g
s
.644 .754 .929 r
.19769 .31621 m .396 .42323 L .39608 .42068 L p F P
0 g
s
.641 .75 .927 r
.396 .42323 m .19769 .31621 L .25978 .28724 L p F P
0 g
s
.641 .75 .927 r
.25978 .28724 m .39593 .42579 L .396 .42323 L p F P
0 g
s
.641 .745 .925 r
.39593 .42579 m .25978 .28724 L .33781 .27219 L p F P
0 g
s
.641 .745 .925 r
.33781 .27219 m .39585 .42835 L .39593 .42579 L p F P
0 g
s
.642 .742 .922 r
.4228 .27349 m .39577 .43091 L .39585 .42835 L p F P
0 g
s
.642 .742 .922 r
.39585 .42835 m .33781 .27219 L .4228 .27349 L p F P
0 g
s
.711 .78 .906 r
.73698 .25538 m .75145 .33409 L .71222 .3397 L p F P
0 g
s
.711 .763 .893 r
.75145 .33409 m .73698 .25538 L .73666 .25032 L p F P
0 g
s
.711 .763 .893 r
.73666 .25032 m .78938 .32103 L .75145 .33409 L p F P
0 g
s
.644 .739 .918 r
.50452 .29131 m .3957 .43348 L .39577 .43091 L p F P
0 g
s
.644 .739 .918 r
.39577 .43091 m .4228 .27349 L .50452 .29131 L p F P
0 g
s
.711 .78 .906 r
.71222 .3397 m .73731 .26046 L .73698 .25538 L p F P
0 g
s
.705 .794 .92 r
.73731 .26046 m .71222 .3397 L .67513 .33783 L p F P
0 g
s
.647 .737 .915 r
.57338 .3235 m .39562 .43604 L .3957 .43348 L p F P
0 g
s
.647 .737 .915 r
.3957 .43348 m .50452 .29131 L .57338 .3235 L p F P
0 g
s
.652 .737 .912 r
.62203 .36611 m .39555 .43862 L .39562 .43604 L p F P
0 g
s
.652 .737 .912 r
.39562 .43604 m .57338 .3235 L .62203 .36611 L p F P
0 g
s
.707 .746 .883 r
.78938 .32103 m .73666 .25032 L .73633 .24527 L p F P
0 g
s
.707 .746 .883 r
.73633 .24527 m .82259 .30113 L .78938 .32103 L p F P
0 g
s
.656 .738 .91 r
.64626 .41423 m .39547 .44119 L .39555 .43862 L p F P
0 g
s
.656 .738 .91 r
.39555 .43862 m .62203 .36611 L .64626 .41423 L p F P
0 g
s
.705 .794 .92 r
.67513 .33783 m .73763 .26556 L .73731 .26046 L p F P
0 g
s
.693 .803 .933 r
.73763 .26556 m .67513 .33783 L .64353 .32905 L p F P
0 g
s
.657 .745 .914 r
.64701 .51497 m .39386 .49612 L .39394 .49347 L p F P
0 g
s
.657 .745 .914 r
.39394 .49347 m .64821 .46685 L .64701 .51497 L p F P
0 g
s
.698 .73 .875 r
.82259 .30113 m .73633 .24527 L .73601 .24023 L p F P
0 g
s
.698 .73 .875 r
.73601 .24023 m .84798 .27558 L .82259 .30113 L p F P
0 g
s
.647 .765 .935 r
.1382 .45041 m .39463 .46977 L .39471 .46715 L p F P
0 g
s
.648 .772 .939 r
.14404 .54586 m .39315 .52015 L .39323 .51746 L p F P
0 g
s
.643 .77 .941 r
.39315 .52015 m .14404 .54586 L .13302 .50374 L p F P
0 g
s
.643 .762 .935 r
.39463 .46977 m .1382 .45041 L .15289 .40746 L p F P
0 g
s
.643 .762 .935 r
.15289 .40746 m .39456 .47238 L .39463 .46977 L p F P
0 g
s
.639 .758 .935 r
.39456 .47238 m .15289 .40746 L .19321 .36926 L p F P
0 g
s
.639 .758 .935 r
.19321 .36926 m .39448 .47501 L .39456 .47238 L p F P
0 g
s
.637 .754 .933 r
.39448 .47501 m .19321 .36926 L .25614 .34071 L p F P
0 g
s
.637 .754 .933 r
.25614 .34071 m .3944 .47763 L .39448 .47501 L p F P
0 g
s
.636 .75 .93 r
.3944 .47763 m .25614 .34071 L .3353 .32593 L p F P
0 g
s
.636 .75 .93 r
.3353 .32593 m .39432 .48026 L .3944 .47763 L p F P
0 g
s
.637 .746 .927 r
.42155 .32732 m .39425 .4829 L .39432 .48026 L p F P
0 g
s
.637 .746 .927 r
.39432 .48026 m .3353 .32593 L .42155 .32732 L p F P
0 g
s
.693 .803 .933 r
.64353 .32905 m .73796 .27066 L .73763 .26556 L p F P
0 g
s
.675 .806 .945 r
.73796 .27066 m .64353 .32905 L .62042 .31448 L p F P
0 g
s
.64 .743 .924 r
.50448 .34506 m .39417 .48553 L .39425 .4829 L p F P
0 g
s
.64 .743 .924 r
.39425 .4829 m .42155 .32732 L .50448 .34506 L p F P
0 g
s
.643 .741 .92 r
.57435 .377 m .39409 .48817 L .39417 .48553 L p F P
0 g
s
.643 .741 .92 r
.39417 .48553 m .50448 .34506 L .57435 .377 L p F P
0 g
s
.648 .741 .917 r
.62368 .41921 m .39401 .49082 L .39409 .48817 L p F P
0 g
s
.648 .741 .917 r
.39409 .48817 m .57435 .377 L .62368 .41921 L p F P
0 g
s
.653 .742 .915 r
.64821 .46685 m .39394 .49347 L .39401 .49082 L p F P
0 g
s
.653 .742 .915 r
.39401 .49082 m .62368 .41921 L .64821 .46685 L p F P
0 g
s
.687 .716 .871 r
.84798 .27558 m .73601 .24023 L .73569 .23521 L p F P
0 g
s
.687 .716 .871 r
.73569 .23521 m .86295 .24612 L .84798 .27558 L p F P
0 g
s
.643 .77 .941 r
.13302 .50374 m .39307 .52284 L .39315 .52015 L p F P
0 g
s
.638 .767 .941 r
.39307 .52284 m .13302 .50374 L .14779 .46147 L p F P
0 g
s
.638 .767 .941 r
.14779 .46147 m .39299 .52553 L .39307 .52284 L p F P
0 g
s
.675 .806 .945 r
.62042 .31448 m .73829 .27579 L .73796 .27066 L p F P
0 g
s
.654 .803 .954 r
.73829 .27579 m .62042 .31448 L .60824 .2958 L p F P
0 g
s
.634 .763 .941 r
.39299 .52553 m .14779 .46147 L .18859 .42386 L p F P
0 g
s
.634 .763 .941 r
.18859 .42386 m .39291 .52822 L .39299 .52553 L p F P
0 g
s
.632 .758 .939 r
.39291 .52822 m .18859 .42386 L .2524 .39578 L p F P
0 g
s
.632 .758 .939 r
.2524 .39578 m .39283 .53092 L .39291 .52822 L p F P
0 g
s
.674 .704 .87 r
.86295 .24612 m .73569 .23521 L .73537 .2302 L p F P
0 g
s
.674 .704 .87 r
.73537 .2302 m .86571 .21497 L .86295 .24612 L p F P
0 g
s
.631 .754 .936 r
.39283 .53092 m .2524 .39578 L .33272 .38129 L p F P
0 g
s
.631 .754 .936 r
.33272 .38129 m .39275 .53363 L .39283 .53092 L p F P
0 g
s
.632 .75 .933 r
.42026 .38278 m .39267 .53633 L .39275 .53363 L p F P
0 g
s
.632 .75 .933 r
.39275 .53363 m .33272 .38129 L .42026 .38278 L p F P
0 g
s
.708 .791 .916 r
.74366 .35977 m .75829 .43676 L .71796 .44264 L p F P
0 g
s
.709 .773 .903 r
.75829 .43676 m .74366 .35977 L .74332 .3544 L p F P
0 g
s
.709 .773 .903 r
.74332 .3544 m .79729 .4236 L .75829 .43676 L p F P
0 g
s
.635 .747 .929 r
.50445 .40042 m .39259 .53905 L .39267 .53633 L p F P
0 g
s
.635 .747 .929 r
.39267 .53633 m .42026 .38278 L .50445 .40042 L p F P
0 g
s
.708 .791 .916 r
.71796 .44264 m .74401 .36515 L .74366 .35977 L p F P
0 g
s
.7 .805 .93 r
.74401 .36515 m .71796 .44264 L .67986 .44122 L p F P
0 g
s
.659 .696 .873 r
.86571 .21497 m .73537 .2302 L .73505 .2252 L p F P
0 g
s
.659 .696 .873 r
.73505 .2252 m .85554 .18469 L .86571 .21497 L p F P
0 g
s
.639 .746 .926 r
.57535 .43208 m .39251 .54176 L .39259 .53905 L p F P
0 g
s
.639 .746 .926 r
.39259 .53905 m .50445 .40042 L .57535 .43208 L p F P
0 g
s
.644 .745 .923 r
.62538 .47386 m .39243 .54448 L .39251 .54176 L p F P
0 g
s
.644 .745 .923 r
.39251 .54176 m .57535 .43208 L .62538 .47386 L p F P
0 g
s
.704 .755 .892 r
.79729 .4236 m .74332 .3544 L .74298 .34906 L p F P
0 g
s
.704 .755 .892 r
.74298 .34906 m .83149 .40375 L .79729 .4236 L p F P
0 g
s
.7 .805 .93 r
.67986 .44122 m .74435 .37054 L .74401 .36515 L p F P
0 g
s
.686 .815 .944 r
.74435 .37054 m .67986 .44122 L .64741 .43304 L p F P
0 g
s
.696 .738 .884 r
.83149 .40375 m .74298 .34906 L .74263 .34373 L p F P
0 g
s
.696 .738 .884 r
.74263 .34373 m .85768 .37835 L .83149 .40375 L p F P
0 g
s
.654 .803 .954 r
.60824 .2958 m .73862 .28092 L .73829 .27579 L p F P
0 g
s
.632 .792 .959 r
.73862 .28092 m .60824 .2958 L .60857 .27516 L p F P
0 g
s
.686 .815 .944 r
.64741 .43304 m .7447 .37595 L .74435 .37054 L p F P
0 g
s
.665 .818 .957 r
.7447 .37595 m .64741 .43304 L .62368 .41921 L p F P
0 g
s
.632 .792 .959 r
.60857 .27516 m .73895 .28607 L .73862 .28092 L p F P
0 g
s
.684 .723 .879 r
.85768 .37835 m .74263 .34373 L .74229 .33841 L p F P
0 g
s
.684 .723 .879 r
.74229 .33841 m .87318 .3491 L .85768 .37835 L p F P
0 g
s
.613 .777 .959 r
.73895 .28607 m .60857 .27516 L .62192 .25504 L p F P
0 g
s
.613 .777 .959 r
.62192 .25504 m .73928 .29124 L .73895 .28607 L p F P
0 g
s
.6 .758 .954 r
.73928 .29124 m .62192 .25504 L .64742 .23807 L p F P
0 g
s
.6 .758 .954 r
.64742 .23807 m .73961 .29642 L .73928 .29124 L p F P
0 g
s
.593 .739 .945 r
.73961 .29642 m .64742 .23807 L .68282 .22666 L p F P
0 g
s
.593 .739 .945 r
.68282 .22666 m .73994 .30162 L .73961 .29642 L p F P
0 g
s
.594 .723 .934 r
.73994 .30162 m .68282 .22666 L .72456 .22272 L p F P
0 g
s
.594 .723 .934 r
.72456 .22272 m .74027 .30683 L .73994 .30162 L p F P
0 g
s
.6 .709 .921 r
.76823 .22733 m .74061 .31205 L .74027 .30683 L p F P
0 g
s
.6 .709 .921 r
.74027 .30683 m .72456 .22272 L .76823 .22733 L p F P
0 g
s
.665 .818 .957 r
.62368 .41921 m .74504 .38138 L .7447 .37595 L p F P
0 g
s
.641 .814 .966 r
.74504 .38138 m .62368 .41921 L .61118 .40137 L p F P
0 g
s
.611 .7 .908 r
.80907 .24055 m .74094 .31729 L .74061 .31205 L p F P
0 g
s
.611 .7 .908 r
.74061 .31205 m .76823 .22733 L .80907 .24055 L p F P
0 g
s
.624 .696 .896 r
.84272 .2614 m .74128 .32255 L .74094 .31729 L p F P
0 g
s
.624 .696 .896 r
.74094 .31729 m .80907 .24055 L .84272 .2614 L p F P
0 g
s
.67 .711 .878 r
.87318 .3491 m .74229 .33841 L .74196 .33311 L p F P
0 g
s
.67 .711 .878 r
.74196 .33311 m .87612 .31817 L .87318 .3491 L p F P
0 g
s
.639 .697 .887 r
.86576 .28808 m .74162 .32782 L .74128 .32255 L p F P
0 g
s
.639 .697 .887 r
.74128 .32255 m .84272 .2614 L .86576 .28808 L p F P
0 g
s
.655 .702 .881 r
.87612 .31817 m .74196 .33311 L .74162 .32782 L p F P
0 g
s
.655 .702 .881 r
.74162 .32782 m .86576 .28808 L .87612 .31817 L p F P
0 g
s
.641 .814 .966 r
.61118 .40137 m .74539 .38682 L .74504 .38138 L p F P
0 g
s
.617 .802 .97 r
.74539 .38682 m .61118 .40137 L .61157 .3816 L p F P
0 g
s
.617 .802 .97 r
.61157 .3816 m .74574 .39227 L .74539 .38682 L p F P
0 g
s
.597 .785 .97 r
.74574 .39227 m .61157 .3816 L .62535 .36234 L p F P
0 g
s
.597 .785 .97 r
.62535 .36234 m .74609 .39775 L .74574 .39227 L p F P
0 g
s
.584 .766 .966 r
.74609 .39775 m .62535 .36234 L .65167 .34616 L p F P
0 g
s
.584 .766 .966 r
.65167 .34616 m .74644 .40324 L .74609 .39775 L p F P
0 g
s
.578 .746 .957 r
.74644 .40324 m .65167 .34616 L .68818 .33542 L p F P
0 g
s
.578 .746 .957 r
.68818 .33542 m .7468 .40874 L .74644 .40324 L p F P
0 g
s
.58 .729 .945 r
.7468 .40874 m .68818 .33542 L .73124 .332 L p F P
0 g
s
.58 .729 .945 r
.73124 .332 m .74715 .41427 L .7468 .40874 L p F P
0 g
s
.588 .715 .931 r
.77626 .33695 m .7475 .4198 L .74715 .41427 L p F P
0 g
s
.588 .715 .931 r
.74715 .41427 m .73124 .332 L .77626 .33695 L p F P
0 g
s
.6 .706 .918 r
.81833 .35033 m .74786 .42536 L .7475 .4198 L p F P
0 g
s
.6 .706 .918 r
.7475 .4198 m .77626 .33695 L .81833 .35033 L p F P
0 g
s
.616 .702 .906 r
.85296 .37118 m .74822 .43093 L .74786 .42536 L p F P
0 g
s
.616 .702 .906 r
.74786 .42536 m .81833 .35033 L .85296 .37118 L p F P
0 g
s
.632 .702 .896 r
.87661 .3977 m .74857 .43652 L .74822 .43093 L p F P
0 g
s
.632 .702 .896 r
.74822 .43093 m .85296 .37118 L .87661 .3977 L p F P
0 g
s
.25 Mabswid
.75919 0 m
.97244 .32367 L
s
.97244 .32367 m
1 .54061 L
s
1 .54061 m
.7766 .23052 L
s
.7766 .23052 m
.75919 0 L
s
.02904 .26976 m
0 .48936 L
s
0 .48936 m
.7766 .23052 L
s
.7766 .23052 m
.75919 0 L
s
.75919 0 m
.02904 .26976 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.42.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.42.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["WireFrame[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "show all polygons as transparent ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.42.1"],

Cell["Making polygons appear transparent. ", "Caption",
 CellTags->"S5.42.1"],

Cell[TextData[{
 StyleBox["WireFrame", "MR"],
 " as well as ",
 StyleBox["TranslateShape", "MR"],
 ", ",
 StyleBox["RotateShape", "MR"],
 ", and ",
 StyleBox["AffineShape", "MR"],
 " will work on any ",
 StyleBox["Graphics3D", "MR"],
 " object that contains the primitives ",
 StyleBox["Polygon", "MR"],
 ", ",
 StyleBox["Line", "MR"],
 ", and ",
 StyleBox["Point", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.42.1", "1.11"}],

Cell[TextData[{
 StyleBox["WireFrame", "MR"],
 " replaces all the polygon specifications by their edges. "
}], "MathCaption",
 CellTags->{"S5.42.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
WireFrame[
  Polygon[{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}]]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.42.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.42.1"]
}, Open  ]],

Cell["This gives a wire frame in the shape of a cone. ", "MathCaption",
 CellTags->{"S5.42.1", "1.13"}],

Cell[CellGroupData[{

Cell["\<\
Show[WireFrame[Graphics3D[ Cone[ ] ]],
                         Boxed->False]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.42.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 6.45642e-17 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.52632 .86433 m
.49115 .52402 L
s
.49115 .52402 m
.40998 .50931 L
s
.57482 .52273 m
.49115 .52402 L
s
.52632 .86433 m
.57482 .52273 L
s
.65504 .5055 m
.57482 .52273 L
s
.52632 .86433 m
.40998 .50931 L
s
.40998 .50931 m
.33728 .47926 L
s
.52632 .86433 m
.65504 .5055 L
s
.72581 .4731 m
.65504 .5055 L
s
.52632 .86433 m
.33728 .47926 L
s
.33728 .47926 m
.27912 .43541 L
s
.52632 .86433 m
.72581 .4731 L
s
.78108 .42726 m
.72581 .4731 L
s
.52632 .86433 m
.27912 .43541 L
s
.27912 .43541 m
.24145 .38042 L
s
.52632 .86433 m
.78108 .42726 L
s
.81494 .37082 m
.78108 .42726 L
s
.52632 .86433 m
.24145 .38042 L
s
.24145 .38042 m
.22963 .31836 L
s
.52632 .86433 m
.81494 .37082 L
s
.82221 .30811 m
.81494 .37082 L
s
.52632 .86433 m
.22963 .31836 L
s
.22963 .31836 m
.24742 .25485 L
s
.52632 .86433 m
.82221 .30811 L
s
.79949 .24499 m
.82221 .30811 L
s
.52632 .86433 m
.24742 .25485 L
s
.24742 .25485 m
.29576 .19685 L
s
.79949 .24499 m
.52632 .86433 L
s
.74642 .18856 m
.79949 .24499 L
s
.52632 .86433 m
.29576 .19685 L
s
.29576 .19685 m
.37146 .15181 L
s
.52632 .86433 m
.74642 .18856 L
s
.66695 .14627 m
.74642 .18856 L
s
.52632 .86433 m
.37146 .15181 L
s
.37146 .15181 m
.46667 .12631 L
s
.52632 .86433 m
.66695 .14627 L
s
.56963 .12436 m
.66695 .14627 L
s
.52632 .86433 m
.46667 .12631 L
s
.46667 .12631 m
.56963 .12436 L
s
.52632 .86433 m
.56963 .12436 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.42.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.42.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.42.1"->{
    Cell[1776, 53, 131, 6, 36, "Subsection",
      CellTags->{"S5.42.1", "1.1"}],
    Cell[1910, 61, 500, 12, 72, "Text",
      CellTags->{"S5.42.1", "1.2"}],
    Cell[2413, 75, 867, 27, 46, "DefinitionBox",
      CellTags->"S5.42.1"],
    Cell[3283, 104, 95, 3, 15, "Caption",
      CellTags->"S5.42.1"],
    Cell[3381, 109, 78, 1, 40, "MathCaption",
      CellTags->{"S5.42.1", "1.3"}],
    Cell[3462, 112, 81, 2, 28, "Input",
      CellTags->"S5.42.1"],
    Cell[3546, 116, 173, 5, 40, "MathCaption",
      CellTags->{"S5.42.1", "1.4"}],
    Cell[3744, 125, 81, 2, 28, "Input",
      CellTags->"S5.42.1"],
    Cell[3828, 129, 1053, 31, 57, "Output",
      CellTags->"S5.42.1"],
    Cell[4896, 163, 124, 3, 40, "MathCaption",
      CellTags->{"S5.42.1", "1.5"}],
    Cell[5045, 170, 91, 2, 28, "Input",
      CellTags->"S5.42.1"],
    Cell[5139, 174, 76972, 2377, 186, 33882, 1841, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.42.1"],
    Cell[82114, 2553, 182, 6, 25, "Output",
      CellTags->"S5.42.1"],
    Cell[82311, 2562, 471, 11, 70, "Text",
      CellTags->{"S5.42.1", "1.6"}],
    Cell[82785, 2575, 14741, 467, 70, "DefinitionBox",
      CellTags->"S5.42.1"],
    Cell[97529, 3044, 48, 1, 70, "Caption",
      CellTags->"S5.42.1"],
    Cell[97580, 3047, 110, 1, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.7"}],
    Cell[97715, 3052, 107, 2, 70, "Input",
      CellTags->"S5.42.1"],
    Cell[97825, 3056, 31239, 1656, 70, 31168, 1653, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.42.1"],
    Cell[129067, 4714, 182, 6, 70, "Output",
      CellTags->"S5.42.1"],
    Cell[129264, 4723, 1476, 38, 70, "DefinitionBox",
      CellTags->"S5.42.1"],
    Cell[130743, 4763, 82, 1, 70, "Caption",
      CellTags->"S5.42.1"],
    Cell[130828, 4766, 494, 14, 70, "Text",
      CellTags->{"S5.42.1", "1.8"}],
    Cell[131325, 4782, 4725, 145, 70, "DefinitionBox",
      CellTags->"S5.42.1"],
    Cell[136053, 4929, 117, 3, 70, "Caption",
      CellTags->"S5.42.1"],
    Cell[136173, 4934, 230, 9, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.9"}],
    Cell[136428, 4947, 164, 6, 70, "Input",
      CellTags->"S5.42.1"],
    Cell[136595, 4955, 8500, 488, 70, 8429, 485, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.42.1"],
    Cell[145098, 5445, 182, 6, 70, "Output",
      CellTags->"S5.42.1"],
    Cell[145295, 5454, 481, 13, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.10"}],
    Cell[145801, 5471, 211, 7, 70, "Input",
      CellTags->"S5.42.1"],
    Cell[146015, 5480, 19676, 1076, 70, 19605, 1073, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.42.1"],
    Cell[165694, 6558, 182, 6, 70, "Output",
      CellTags->"S5.42.1"],
    Cell[165891, 6567, 862, 27, 70, "DefinitionBox",
      CellTags->"S5.42.1"],
    Cell[166756, 6596, 77, 1, 70, "Caption",
      CellTags->"S5.42.1"],
    Cell[166836, 6599, 422, 18, 70, "Text",
      CellTags->{"S5.42.1", "1.11"}],
    Cell[167261, 6619, 157, 4, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.12"}],
    Cell[167443, 6627, 127, 5, 70, "Input",
      CellTags->"S5.42.1"],
    Cell[167573, 6634, 182, 6, 70, "Output",
      CellTags->"S5.42.1"],
    Cell[167770, 6643, 103, 1, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.13"}],
    Cell[167898, 6648, 148, 5, 70, "Input",
      CellTags->"S5.42.1"],
    Cell[168049, 6655, 2055, 162, 70, 1984, 159, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.42.1"],
    Cell[170107, 6819, 182, 6, 70, "Output",
      CellTags->"S5.42.1"]},
  "1.1"->{
    Cell[1776, 53, 131, 6, 36, "Subsection",
      CellTags->{"S5.42.1", "1.1"}]},
  "1.2"->{
    Cell[1910, 61, 500, 12, 72, "Text",
      CellTags->{"S5.42.1", "1.2"}]},
  "1.3"->{
    Cell[3381, 109, 78, 1, 40, "MathCaption",
      CellTags->{"S5.42.1", "1.3"}]},
  "1.4"->{
    Cell[3546, 116, 173, 5, 40, "MathCaption",
      CellTags->{"S5.42.1", "1.4"}]},
  "1.5"->{
    Cell[4896, 163, 124, 3, 40, "MathCaption",
      CellTags->{"S5.42.1", "1.5"}]},
  "1.6"->{
    Cell[82311, 2562, 471, 11, 70, "Text",
      CellTags->{"S5.42.1", "1.6"}]},
  "1.7"->{
    Cell[97580, 3047, 110, 1, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.7"}]},
  "1.8"->{
    Cell[130828, 4766, 494, 14, 70, "Text",
      CellTags->{"S5.42.1", "1.8"}]},
  "1.9"->{
    Cell[136173, 4934, 230, 9, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.9"}]},
  "1.10"->{
    Cell[145295, 5454, 481, 13, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.10"}]},
  "1.11"->{
    Cell[166836, 6599, 422, 18, 70, "Text",
      CellTags->{"S5.42.1", "1.11"}]},
  "1.12"->{
    Cell[167261, 6619, 157, 4, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.12"}]},
  "1.13"->{
    Cell[167770, 6643, 103, 1, 70, "MathCaption",
      CellTags->{"S5.42.1", "1.13"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.42.1", 170940, 6845},
  {"1.1", 174632, 6941},
  {"1.2", 174726, 6944},
  {"1.3", 174815, 6947},
  {"1.4", 174910, 6950},
  {"1.5", 175006, 6953},
  {"1.6", 175102, 6956},
  {"1.7", 175194, 6959},
  {"1.8", 175292, 6962},
  {"1.9", 175385, 6965},
  {"1.10", 175485, 6968},
  {"1.11", 175587, 6971},
  {"1.12", 175682, 6974},
  {"1.13", 175783, 6977}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 131, 6, 36, "Subsection",
  CellTags->{"S5.42.1", "1.1"}],
Cell[1910, 61, 500, 12, 72, "Text",
  CellTags->{"S5.42.1", "1.2"}],
Cell[2413, 75, 867, 27, 46, "DefinitionBox",
  CellTags->"S5.42.1"],
Cell[3283, 104, 95, 3, 15, "Caption",
  CellTags->"S5.42.1"],
Cell[3381, 109, 78, 1, 40, "MathCaption",
  CellTags->{"S5.42.1", "1.3"}],
Cell[3462, 112, 81, 2, 28, "Input",
  CellTags->"S5.42.1"],
Cell[3546, 116, 173, 5, 40, "MathCaption",
  CellTags->{"S5.42.1", "1.4"}],

Cell[CellGroupData[{
Cell[3744, 125, 81, 2, 28, "Input",
  CellTags->"S5.42.1"],
Cell[3828, 129, 1053, 31, 57, "Output",
  CellTags->"S5.42.1"]
}, Open  ]],
Cell[4896, 163, 124, 3, 40, "MathCaption",
  CellTags->{"S5.42.1", "1.5"}],

Cell[CellGroupData[{
Cell[5045, 170, 91, 2, 28, "Input",
  CellTags->"S5.42.1"],
Cell[5139, 174, 76972, 2377, 186, 33882, 1841, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S5.42.1"],
Cell[82114, 2553, 182, 6, 25, "Output",
  CellTags->"S5.42.1"]
}, Open  ]],
Cell[82311, 2562, 471, 11, 70, "Text",
  CellTags->{"S5.42.1", "1.6"}],
Cell[82785, 2575, 14741, 467, 70, "DefinitionBox",
  CellTags->"S5.42.1"],
Cell[97529, 3044, 48, 1, 70, "Caption",
  CellTags->"S5.42.1"],
Cell[97580, 3047, 110, 1, 70, "MathCaption",
  CellTags->{"S5.42.1", "1.7"}],

Cell[CellGroupData[{
Cell[97715, 3052, 107, 2, 70, "Input",
  CellTags->"S5.42.1"],
Cell[97825, 3056, 31239, 1656, 70, 31168, 1653, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.42.1"],
Cell[129067, 4714, 182, 6, 70, "Output",
  CellTags->"S5.42.1"]
}, Open  ]],
Cell[129264, 4723, 1476, 38, 70, "DefinitionBox",
  CellTags->"S5.42.1"],
Cell[130743, 4763, 82, 1, 70, "Caption",
  CellTags->"S5.42.1"],
Cell[130828, 4766, 494, 14, 70, "Text",
  CellTags->{"S5.42.1", "1.8"}],
Cell[131325, 4782, 4725, 145, 70, "DefinitionBox",
  CellTags->"S5.42.1"],
Cell[136053, 4929, 117, 3, 70, "Caption",
  CellTags->"S5.42.1"],
Cell[136173, 4934, 230, 9, 70, "MathCaption",
  CellTags->{"S5.42.1", "1.9"}],

Cell[CellGroupData[{
Cell[136428, 4947, 164, 6, 70, "Input",
  CellTags->"S5.42.1"],
Cell[136595, 4955, 8500, 488, 70, 8429, 485, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.42.1"],
Cell[145098, 5445, 182, 6, 70, "Output",
  CellTags->"S5.42.1"]
}, Open  ]],
Cell[145295, 5454, 481, 13, 70, "MathCaption",
  CellTags->{"S5.42.1", "1.10"}],

Cell[CellGroupData[{
Cell[145801, 5471, 211, 7, 70, "Input",
  CellTags->"S5.42.1"],
Cell[146015, 5480, 19676, 1076, 70, 19605, 1073, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.42.1"],
Cell[165694, 6558, 182, 6, 70, "Output",
  CellTags->"S5.42.1"]
}, Open  ]],
Cell[165891, 6567, 862, 27, 70, "DefinitionBox",
  CellTags->"S5.42.1"],
Cell[166756, 6596, 77, 1, 70, "Caption",
  CellTags->"S5.42.1"],
Cell[166836, 6599, 422, 18, 70, "Text",
  CellTags->{"S5.42.1", "1.11"}],
Cell[167261, 6619, 157, 4, 70, "MathCaption",
  CellTags->{"S5.42.1", "1.12"}],

Cell[CellGroupData[{
Cell[167443, 6627, 127, 5, 70, "Input",
  CellTags->"S5.42.1"],
Cell[167573, 6634, 182, 6, 70, "Output",
  CellTags->"S5.42.1"]
}, Open  ]],
Cell[167770, 6643, 103, 1, 70, "MathCaption",
  CellTags->{"S5.42.1", "1.13"}],

Cell[CellGroupData[{
Cell[167898, 6648, 148, 5, 70, "Input",
  CellTags->"S5.42.1"],
Cell[168049, 6655, 2055, 162, 70, 1984, 159, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.42.1"],
Cell[170107, 6819, 182, 6, 70, "Output",
  CellTags->"S5.42.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

