(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6037,        212]*)
(*NotebookOutlinePosition[      8711,        297]*)
(*  CellTagsIndexPosition[      8507,        285]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Utilities",
 StyleBox["`", "MB"],
 "ShowTime",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.15.1", "1.1"}],

Cell[TextData[{
 "The function ",
 StyleBox["ShowTime", "MR"],
 " uses the built\[Hyphen]in function ",
 StyleBox["Timing", "MR"],
 " to print timing information for each evaluation. After the package is \
loaded, ",
 StyleBox["ShowTime", "MR"],
 " is automatically applied to every evaluation. Automatic printing of timing \
information can be turned off using ",
 StyleBox["Off[ShowTime]", "MR"],
 " and turned back on using ",
 StyleBox["On[ShowTime]", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.15.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ShowTime[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["print the time required for evaluation of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["On[ShowTime]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "print timing information for subsequent evaluations ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Off[ShowTime]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "turn off automatic printing of timing information ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.15.1"],

Cell["Automatic printing of timing information. ", "Caption",
 CellTags->"S6.15.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.15.1", "1.3"}],

Cell["<< Utilities`ShowTime`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.15.1"],

Cell["\<\
The time required to evaluate this numerical integral is printed before \
returning the result. \
\>", "MathCaption",
 CellTags->{"S6.15.1", "1.4"}],

Cell[CellGroupData[{

Cell["NIntegrate[x^2 BesselJ[x, x], {x, 0, 1000}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.15.1"],

Cell[BoxData[
 RowBox[{"0.9400000000000001`", " ", "Second"}]], "Print",
 CellTags->"S6.15.1"],

Cell[BoxData["1.6773980093552027`*^7"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S6.15.1"]
}, Open  ]],

Cell["This turns automatic timing off. ", "MathCaption",
 CellTags->{"S6.15.1", "1.5"}],

Cell[CellGroupData[{

Cell["Off[ShowTime]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.15.1"],

Cell[BoxData[
 RowBox[{"0.`", " ", "Second"}]], "Print",
 CellTags->"S6.15.1"]
}, Open  ]],

Cell[TextData[{
 "Timing information is printed if ",
 StyleBox["ShowTime", "MR"],
 " is entered explicitly. "
}], "MathCaption",
 CellTags->{"S6.15.1", "1.6"}],

Cell[CellGroupData[{

Cell["ShowTime[N[Sum[1/n, {n, 1, 30000}]]]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.15.1"],

Cell[BoxData[
 RowBox[{"1.6`", " ", "Second"}]], "Print",
 CellTags->"S6.15.1"],

Cell[BoxData["10.8861849921199`"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.15.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.15.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S6.15.1", "1.1"}],
    Cell[1913, 61, 511, 15, 72, "Text",
      CellTags->{"S6.15.1", "1.2"}],
    Cell[2427, 78, 2082, 64, 88, "DefinitionBox",
      CellTags->"S6.15.1"],
    Cell[4512, 144, 83, 1, 15, "Caption",
      CellTags->"S6.15.1"],
    Cell[4598, 147, 78, 1, 40, "MathCaption",
      CellTags->{"S6.15.1", "1.3"}],
    Cell[4679, 150, 85, 2, 28, "Input",
      CellTags->"S6.15.1"],
    Cell[4767, 154, 158, 4, 40, "MathCaption",
      CellTags->{"S6.15.1", "1.4"}],
    Cell[4950, 162, 106, 2, 28, "Input",
      CellTags->"S6.15.1"],
    Cell[5059, 166, 94, 2, 21, "Print",
      CellTags->"S6.15.1"],
    Cell[5156, 170, 95, 2, 27, "Output",
      CellTags->"S6.15.1"],
    Cell[5266, 175, 87, 1, 40, "MathCaption",
      CellTags->{"S6.15.1", "1.5"}],
    Cell[5378, 180, 76, 2, 28, "Input",
      CellTags->"S6.15.1"],
    Cell[5457, 184, 78, 2, 21, "Print",
      CellTags->"S6.15.1"],
    Cell[5550, 189, 160, 5, 40, "MathCaption",
      CellTags->{"S6.15.1", "1.6"}],
    Cell[5735, 198, 99, 2, 28, "Input",
      CellTags->"S6.15.1"],
    Cell[5837, 202, 79, 2, 21, "Print",
      CellTags->"S6.15.1"],
    Cell[5919, 206, 90, 2, 25, "Output",
      CellTags->"S6.15.1"]},
  "1.1"->{
    Cell[1776, 53, 134, 6, 36, "Subsection",
      CellTags->{"S6.15.1", "1.1"}]},
  "1.2"->{
    Cell[1913, 61, 511, 15, 72, "Text",
      CellTags->{"S6.15.1", "1.2"}]},
  "1.3"->{
    Cell[4598, 147, 78, 1, 40, "MathCaption",
      CellTags->{"S6.15.1", "1.3"}]},
  "1.4"->{
    Cell[4767, 154, 158, 4, 40, "MathCaption",
      CellTags->{"S6.15.1", "1.4"}]},
  "1.5"->{
    Cell[5266, 175, 87, 1, 40, "MathCaption",
      CellTags->{"S6.15.1", "1.5"}]},
  "1.6"->{
    Cell[5550, 189, 160, 5, 40, "MathCaption",
      CellTags->{"S6.15.1", "1.6"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.15.1", 6660, 228},
  {"1.1", 7928, 263},
  {"1.2", 8022, 266},
  {"1.3", 8111, 269},
  {"1.4", 8206, 272},
  {"1.5", 8302, 275},
  {"1.6", 8397, 278}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 6, 36, "Subsection",
  CellTags->{"S6.15.1", "1.1"}],
Cell[1913, 61, 511, 15, 72, "Text",
  CellTags->{"S6.15.1", "1.2"}],
Cell[2427, 78, 2082, 64, 88, "DefinitionBox",
  CellTags->"S6.15.1"],
Cell[4512, 144, 83, 1, 15, "Caption",
  CellTags->"S6.15.1"],
Cell[4598, 147, 78, 1, 40, "MathCaption",
  CellTags->{"S6.15.1", "1.3"}],
Cell[4679, 150, 85, 2, 28, "Input",
  CellTags->"S6.15.1"],
Cell[4767, 154, 158, 4, 40, "MathCaption",
  CellTags->{"S6.15.1", "1.4"}],

Cell[CellGroupData[{
Cell[4950, 162, 106, 2, 28, "Input",
  CellTags->"S6.15.1"],
Cell[5059, 166, 94, 2, 21, "Print",
  CellTags->"S6.15.1"],
Cell[5156, 170, 95, 2, 27, "Output",
  CellTags->"S6.15.1"]
}, Open  ]],
Cell[5266, 175, 87, 1, 40, "MathCaption",
  CellTags->{"S6.15.1", "1.5"}],

Cell[CellGroupData[{
Cell[5378, 180, 76, 2, 28, "Input",
  CellTags->"S6.15.1"],
Cell[5457, 184, 78, 2, 21, "Print",
  CellTags->"S6.15.1"]
}, Open  ]],
Cell[5550, 189, 160, 5, 40, "MathCaption",
  CellTags->{"S6.15.1", "1.6"}],

Cell[CellGroupData[{
Cell[5735, 198, 99, 2, 28, "Input",
  CellTags->"S6.15.1"],
Cell[5837, 202, 79, 2, 21, "Print",
  CellTags->"S6.15.1"],
Cell[5919, 206, 90, 2, 25, "Output",
  CellTags->"S6.15.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

