(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10000,        360]*)
(*NotebookOutlinePosition[     13030,        455]*)
(*  CellTagsIndexPosition[     12773,        441]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumberTheory",
 StyleBox["`", "MB"],
 "SiegelTheta",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.75.1", "1.1"}],

Cell[TextData[{
 "The Siegel theta function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalTheta]", 
    RowBox[{"(", 
     RowBox[{
      StyleBox["Z",
       "TB"], ",", 
      StyleBox["s",
       "TB"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is defined as "
}], "Text",
 CellTags->{"S5.75.1", "1.2"}],

Cell[BoxData[
 FormBox[
  RowBox[{"\[CapitalTheta]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["Z",
      "TB"], ",", 
     StyleBox["s",
      "TB"]}], ")"}], "=", 
   UnderscriptBox["\[Sum]", 
    StyleBox["t",
     "TB"],
    LimitsPositioning->False], 
   SuperscriptBox[
    StyleBox["e",
     "TI"], 
    RowBox[{"\[Pi]", 
     StyleBox["i",
      "TI"], 
     SuperscriptBox[
      StyleBox["t",
       "TB"], "\[Prime]"], 
     StyleBox["Zt",
      "TB"], "+", "2", "\[Pi]", 
     StyleBox["i",
      "TI"], 
     SuperscriptBox[
      StyleBox["t",
       "TB"], "\[Prime]"], 
     StyleBox["s",
      "TB"]}]]}], TraditionalForm]], "DisplayFormula",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{ColumnWidths->Automatic},
 CellTags->{"S5.75.1", "1.3"}],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   StyleBox["Z",
    "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["p",
     "TI"], "\[Cross]", 
    StyleBox["p",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " symmetric complex matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["Z",
     "TB"], "=", 
    StyleBox["X",
     "TB"], "+", 
    StyleBox["i",
     "TI"], 
    StyleBox["Y",
     "TB"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with imaginary part ",
 Cell[BoxData[
  FormBox[
   StyleBox["Y",
    "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " positive definite, ",
 Cell[BoxData[
  FormBox[
   StyleBox["s",
    "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a complex vector of dimension ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is an integer vector of dimension ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " that ranges over the entire ",
 Cell[BoxData[
  FormBox[
   StyleBox["p",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]dimensional lattice of integers. This function was initially \
investigated by Riemann and Weierstrass and further studies were done by \
Frobenius and Poincar\[EAcute]. These investigations represent some of the \
most significant accomplishments of nineteenth century mathematics. "
}], "Text",
 CellTags->{"S5.75.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SiegelTheta[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["s", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Siegel theta function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[CapitalTheta]", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["Z",
            "TB"], ",", 
           StyleBox["s",
            "TB"]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.75.1"],

Cell["The Siegel theta function. ", "Caption",
 CellTags->"S5.75.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.75.1", "1.5"}],

Cell["<< NumberTheory`SiegelTheta`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.75.1"],

Cell[TextData[{
 "This evaluates ",
 Cell[BoxData[
  FormBox["\[CapitalTheta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for particular arguments in 2\[Hyphen]space. "
}], "MathCaption",
 CellTags->{"S5.75.1", "1.6"}],

Cell[CellGroupData[{

Cell["SiegelTheta[{{1+I,2+I}, {2+I,-1+4I}}, {1.2, 2.3+.3I}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.75.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.9737148349537305`", "\[InvisibleSpace]"}], "-", 
  RowBox[{"0.00029704806583312514`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.75.1"]
}, Open  ]],

Cell[TextData[{
 "This is a slow, brute force way to get the same answer. (The tails beyond \
",
 Cell[BoxData[
  FormBox["-", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "10 and 10 die off quickly.) "
}], "MathCaption",
 CellTags->{"S5.75.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
Sum[E^(Pi I {t1,t2}.{{1+I,2+I}, {2+I,-1+4I}}.{t1,t2} +
               2 Pi I {t1,t2} . {1.2, 2.3+.3I}),
          {t1, -10, 10}, {t2, -10, 10}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.75.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.9737148349537305`", "\[InvisibleSpace]"}], "-", 
  RowBox[{"0.00029704806583312867`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.75.1"]
}, Open  ]],

Cell[TextData[{
 "If the imaginary part of ",
 Cell[BoxData[
  FormBox[
   StyleBox["Z",
    "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not positive definite, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalTheta]", 
    RowBox[{"(", 
     RowBox[{
      StyleBox["Z",
       "TB"], ",", 
      StyleBox["s",
       "TB"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not defined. "
}], "MathCaption",
 CellTags->{"S5.75.1", "1.8"}],

Cell[CellGroupData[{

Cell["SiegelTheta[{{1+I,2+I}, {2+I,-1-4I}}, {1.2, 2.3+.3I}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.75.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SiegelTheta", "::", "\<\"npd\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"The imaginary part of the matrix \\!\\({\\(\\({\\(\\(1 + \
\[ImaginaryI]\\)\\), \\(\\(2 + \[ImaginaryI]\\)\\)}\\)\\), \\(\\({\\(\\(2 + \
\[ImaginaryI]\\)\\), \\(\\(\\(\\(-1\\)\\) - \\(\\(4\\\\ \
\[ImaginaryI]\\)\\)\\)\\)}\\)\\)}\\) is not positive definite.\"\>"}]], \
"Message",
 CellTags->"S5.75.1"],

Cell[BoxData[
 RowBox[{"SiegelTheta", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "+", "\[ImaginaryI]"}], ",", 
       RowBox[{"2", "+", "\[ImaginaryI]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "+", "\[ImaginaryI]"}], ",", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"4", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2`", ",", 
     RowBox[{
      RowBox[{"2.3`", "\[InvisibleSpace]"}], "+", 
      RowBox[{"0.3`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.75.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.75.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.75.1", "1.1"}],
    Cell[1919, 61, 364, 14, 24, "Text",
      CellTags->{"S5.75.1", "1.2"}],
    Cell[2286, 77, 792, 33, 44, "DisplayFormula",
      CellTags->{"S5.75.1", "1.3"}],
    Cell[3081, 112, 1984, 70, 88, "Text",
      CellTags->{"S5.75.1", "1.4"}],
    Cell[5068, 184, 1524, 49, 46, "DefinitionBox",
      CellTags->"S5.75.1"],
    Cell[6595, 235, 68, 1, 15, "Caption",
      CellTags->"S5.75.1"],
    Cell[6666, 238, 78, 1, 40, "MathCaption",
      CellTags->{"S5.75.1", "1.5"}],
    Cell[6747, 241, 91, 2, 28, "Input",
      CellTags->"S5.75.1"],
    Cell[6841, 245, 261, 7, 40, "MathCaption",
      CellTags->{"S5.75.1", "1.6"}],
    Cell[7127, 256, 116, 2, 28, "Input",
      CellTags->"S5.75.1"],
    Cell[7246, 260, 205, 5, 25, "Output",
      CellTags->"S5.75.1"],
    Cell[7466, 268, 290, 8, 56, "MathCaption",
      CellTags->{"S5.75.1", "1.7"}],
    Cell[7781, 280, 214, 6, 62, "Input",
      CellTags->"S5.75.1"],
    Cell[7998, 288, 205, 5, 25, "Output",
      CellTags->"S5.75.1"],
    Cell[8218, 296, 540, 20, 40, "MathCaption",
      CellTags->{"S5.75.1", "1.8"}],
    Cell[8783, 320, 116, 2, 28, "Input",
      CellTags->"S5.75.1"],
    Cell[8902, 324, 404, 9, 70, "Message",
      CellTags->"S5.75.1"],
    Cell[9309, 335, 663, 21, 70, "Output",
      CellTags->"S5.75.1"]},
  "1.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.75.1", "1.1"}]},
  "1.2"->{
    Cell[1919, 61, 364, 14, 24, "Text",
      CellTags->{"S5.75.1", "1.2"}]},
  "1.3"->{
    Cell[2286, 77, 792, 33, 44, "DisplayFormula",
      CellTags->{"S5.75.1", "1.3"}]},
  "1.4"->{
    Cell[3081, 112, 1984, 70, 88, "Text",
      CellTags->{"S5.75.1", "1.4"}]},
  "1.5"->{
    Cell[6666, 238, 78, 1, 40, "MathCaption",
      CellTags->{"S5.75.1", "1.5"}]},
  "1.6"->{
    Cell[6841, 245, 261, 7, 40, "MathCaption",
      CellTags->{"S5.75.1", "1.6"}]},
  "1.7"->{
    Cell[7466, 268, 290, 8, 56, "MathCaption",
      CellTags->{"S5.75.1", "1.7"}]},
  "1.8"->{
    Cell[8218, 296, 540, 20, 40, "MathCaption",
      CellTags->{"S5.75.1", "1.8"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.75.1", 10623, 376},
  {"1.1", 12002, 413},
  {"1.2", 12096, 416},
  {"1.3", 12185, 419},
  {"1.4", 12284, 422},
  {"1.5", 12375, 425},
  {"1.6", 12470, 428},
  {"1.7", 12566, 431},
  {"1.8", 12662, 434}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 140, 6, 36, "Subsection",
  CellTags->{"S5.75.1", "1.1"}],
Cell[1919, 61, 364, 14, 24, "Text",
  CellTags->{"S5.75.1", "1.2"}],
Cell[2286, 77, 792, 33, 44, "DisplayFormula",
  CellTags->{"S5.75.1", "1.3"}],
Cell[3081, 112, 1984, 70, 88, "Text",
  CellTags->{"S5.75.1", "1.4"}],
Cell[5068, 184, 1524, 49, 46, "DefinitionBox",
  CellTags->"S5.75.1"],
Cell[6595, 235, 68, 1, 15, "Caption",
  CellTags->"S5.75.1"],
Cell[6666, 238, 78, 1, 40, "MathCaption",
  CellTags->{"S5.75.1", "1.5"}],
Cell[6747, 241, 91, 2, 28, "Input",
  CellTags->"S5.75.1"],
Cell[6841, 245, 261, 7, 40, "MathCaption",
  CellTags->{"S5.75.1", "1.6"}],

Cell[CellGroupData[{
Cell[7127, 256, 116, 2, 28, "Input",
  CellTags->"S5.75.1"],
Cell[7246, 260, 205, 5, 25, "Output",
  CellTags->"S5.75.1"]
}, Open  ]],
Cell[7466, 268, 290, 8, 56, "MathCaption",
  CellTags->{"S5.75.1", "1.7"}],

Cell[CellGroupData[{
Cell[7781, 280, 214, 6, 62, "Input",
  CellTags->"S5.75.1"],
Cell[7998, 288, 205, 5, 25, "Output",
  CellTags->"S5.75.1"]
}, Open  ]],
Cell[8218, 296, 540, 20, 40, "MathCaption",
  CellTags->{"S5.75.1", "1.8"}],

Cell[CellGroupData[{
Cell[8783, 320, 116, 2, 28, "Input",
  CellTags->"S5.75.1"],
Cell[8902, 324, 404, 9, 70, "Message",
  CellTags->"S5.75.1"],
Cell[9309, 335, 663, 21, 70, "Output",
  CellTags->"S5.75.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

