(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     44110,       1186]*)
(*NotebookOutlinePosition[     48913,       1330]*)
(*  CellTagsIndexPosition[     48548,       1312]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "Spline",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.43.1", "1.1"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Spline[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["points", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a spline curve graphics primitive",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Spline[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["points", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["internal", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "an evaluated spline, with information cached for faster rendering",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.43.1"],

Cell["A spline graphics primitive. ", "Caption",
 CellTags->"S5.43.1"],

Cell[TextData[{
 "This package takes the functions from ",
 StyleBox["NumericalMath`SplineFit`", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " and adapts them to a graphics primitive. Currently, three types of splines \
are supported: ",
 StyleBox["Cubic", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", ",
 StyleBox["Bezier", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", and ",
 StyleBox["CompositeBezier", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". See the documentation for the ",
 StyleBox["NumericalMath`SplineFit`", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " package for more information about the various types of splines. "
}], "Text",
 CellTags->{"S5.43.1", "1.2"}],

Cell["This loads the package.", "MathCaption",
 CellTags->{"S5.43.1", "1.3"}],

Cell["<<Graphics`Spline`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.43.1"],

Cell["Here is a list of points.", "MathCaption",
 CellTags->{"S5.43.1", "1.4"}],

Cell["\<\
pts =
  {{0, 0}, {1, 2}, {-1, 3}, {0, 1}, {3, 0}};\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.43.1"],

Cell[TextData[{
 "This is a graph of the cubic ",
 StyleBox["Spline", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " primitive combined with other primitives. Here a line of a different color \
connects the points making up the spline."
}], "MathCaption",
 CellTags->{"S5.43.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
Show[
  Graphics[{Hue[0], Line[pts], GrayLevel[0],
    Spline[pts, Cubic]}],
    PlotRange -> All]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.43.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.282615 0.231192 0.0147151 0.192519 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 0 0 r
.5 Mabswid
[ ] 0 setdash
.28262 .01472 m
.51381 .39975 L
.05142 .59227 L
.28262 .20723 L
.97619 .01472 L
s
0 g
.28262 .01472 m
.35794 .08 L
.42696 .1451 L
.45713 .17752 L
.48336 .20981 L
.50486 .24197 L
.51359 .25798 L
.52084 .27395 L
.52652 .28988 L
.53051 .30575 L
.53274 .32157 L
.53316 .32946 L
.53309 .33733 L
.53147 .35303 L
.52779 .36867 L
.52193 .38425 L
.51816 .39201 L
.51381 .39975 L
.49075 .43046 L
.45977 .46033 L
.38017 .51537 L
.28726 .56047 L
.23965 .57793 L
.19332 .59125 L
.1498 .5999 L
.12957 .6023 L
.11062 .60332 L
.09314 .6029 L
.07731 .60096 L
.07009 .5994 L
.06335 .59744 L
.05712 .59507 L
.0542 .59372 L
.0528 .59301 L
.05142 .59227 L
.04628 .58905 L
.04169 .58542 L
.03765 .58138 L
.03582 .57921 L
.03413 .57695 L
.03115 .57215 L
.02868 .56699 L
.02672 .56148 L
.02593 .5586 L
.02526 .55563 L
.02381 .54301 L
.02427 .52921 L
.02656 .51436 L
.03063 .49856 L
.04381 .46457 L
Mistroke
.06329 .42812 L
.08853 .39009 L
.11901 .35137 L
.19353 .27539 L
.28262 .20723 L
.38244 .15239 L
.49087 .10996 L
.60618 .07746 L
.72665 .0524 L
.85056 .03232 L
.97619 .01472 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00E_ooool00oooj^[o`;Bdoooo
o`32ooooo`05oo3`l?oNg]koc<G5okZKVon^O7`03?ooool005Kooooo00Cooo7aojAHF?nZWiooo?cl
^Oooool03Oono_kok^k^omcLg?o:b/[o^;RhojJVY_nDTi?oPgAdoheYJOnOHF7o/EeMol=nO_oH[:`0
3?ooool005Oooooo00Coo<30oja_KonMWIgom_Kf/Oooool04_omoOgok>c/om[Jf_o8b<So][JfojBT
Y?nBTY;oPh>3ohn?SonQXJ7o/jVYolFNW_oGShoojGaloo^DU?oo^k_oomkNooolo0kooooo001Goooo
o`05ooolo?ooTi?o_:2Poi:BT_o^k^h0ZOooool05Oolo?coj^[ZomSHf?o6a/Ko];Bdoj:RX_n@T93o
Ph>3oi6ATOnSXj?o]KFeolO7aooIfMWojnOWoocHf?oo^;SooiBDoon9ROoo[Jgoom3@ooocl`0Boooo
o`00F?ooool01OoogMgooi2@olg9bOn;Rh_ohn?S0:7ooooo00oon_[jonSXj?oFe]Koa<C4ok:b/_nP
X:3oSXj>oh>3PonCTi?oYJFUokNg]oo9bLWofm_Kong]kOomoOd00_ooool01ooojNWoolK6oonRX_oo
QXKooinOooo2`_ooi^H05_ooool005Wooooo00GoojZZooo0`?oLg=coRXZ:omKFeP2Jooooo`0>ono_
kooKfm_oa/K6ok:b/_nNWYkoS8b<ohB4Q?nEUIGoYjNWokVi^Oo;bl_ogMgMono_koono_h5ooooo`08
ooofm_ooe=Cook2`oon=SOooTI7ookBdoooHf?oonOTIooooo`00FOooool01_oolO7oohV9ooo_kooX
j>SoSHf=olG5aI;ooooo00gooOgmon_[jooGemOo`/;2ojf][OnIVIWoQHF5ohj>S_nRXZ;o]kNgolk>
c_oOgmoolO7a00Wooooo00SoooknoooRh_oo_[kooi^Koon6Q_ooYZKool[:ooo]kAgooooo001Joooo
o`07ooo4a?ooYZKooooooo;bl_nFUYKo/k>cooknoP2:ooooo`0=oo_knooWinOodm?Cokjn__nYZJWo
UIFEoh>3PonBTY;oYZJVok^k^oo@d=3oi>CTooWin@0<ooooo`08ooo`l?ooc<coojVYoon7QoooV9So
okbloooOgooooOdPooooo`00F_ooool01OoooOgooi>CoooIfOoooooonOWi00;oY:BT00?on_[joooo
ooooool0POooool03Oohn?Sohn?Solo?conj^[[oYJFUoi6ATOn3Ph?oUYJFojZZZ_no_kooe=CDonSX
j?olo?`03_ooool02?oon_[oom[Joong]oooTi?oohZ:oon^[_oodM7oooCd9?ooool005_ooooo00So
omgMoon@T?oono_ooooooogmoOnb/[;oV9RHoo?clgcooooo00gom?CdomoOgoo;bl_o][Jfoj6QXOn=
SHgoQHF5oiZJV_n^[Zko`l?3omSHf?o/k>coo_kn017ooooo00OoonSXooo5aOooXJ7oohJ6oonPX?oo
`l?oonOW02Sooooo001Looooo`03oonZZ_oo_koooooo00;ooooo00?o`l?3ohj>S_oYjNT0MOooool0
3?o`l?3ofm_KolK6a_nb/[;oWIfMohR8R?n9RHWoWYjNok:b/_o7alOog=cLoo3`l1Cooooo00SoooKf
oooCdooo[jooohb<oonBT_oo]KGoomWIoooinB_ooooo001Looooo`03oooalOooRHWoono_00?ooooo
00?odm?CohZ:R_oMgMd0Koooool02oo[jn_od=3@okFe]OnKVi_oQHF5ohf=SOnRXZ;o]kNgol_;booP
h>3omOGe01Kooooo00SooogmoooQhOoo_KgooiZJoon7QoooYjOool_;ooo^kRoooooo001Mooooo`03
ooo4a?ooYZKooooo00?ooooo00?ohN7Qoh^;Roo?cll0JOooool02_o_knooeMGEokZj^_nPX:3oQXJ6
oi6ATOn/[:coalO7on?ShooinOTIooooo`08ooo_kooobl_oojRXoon7QoooVIWookfmoooPh?oooOdb
ooooo`00GOooool00ooooOgooi>CoooIf@04ooooo`03onc/k?n@T93o_[jn06?ooooo00[omOGeom[J
f_no_kooYJFUohZ:R_n=SHgoYjNWol;2`_oLg=comoOg6_ooool02?oon_[oomWIoonf]_ooTY;ooh^;
oon_[oood];oooGe=_ooool005kooooo00?oomkNoon@T?oono/01?ooool01?oemOGoVi^Kojb/[?ol
o?aLooooo`0:ooShn?oNg]koa<C4ojVYZOn?ShooQhN7oj:RX_nm_KgoemOGoo;blQcooooo00OoonOW
ooo4a?ooX:3oohJ6oonQXOooa<CoonSX03[ooooo001Oooooo`03oonZZ_oo_koooooo00Cooooo00Co
no_kojVYZOnOWioomoOgE_ooool02_olo?cohn?SolW9bOn^[ZkoU9BDohF5QOnNWYko^;Rhom?Cdoo]
kNdMooooo`08oooemOood];oojj^oon;RoooTi?ookJfoooJf_oon_Xmooooo`00Goooool00ooolO7o
ohV9ooo_k`06ooooo`03okVi^OnCTi?okno_053ooooo00_oo_knonSXj?o>c/ko/k>coiRHV?n4Q8Co
VIVIok>c/oo>c/koj>SXooknoP0Mooooo`08ooomoOooh>3ookbloonIVOooQhOoojRXooo<c?ooknm1
ooooo`00H?ooool00oooa<CoojJVooooo`06ooooo`03ol[:b_n<S8coiNGU04_ooooo00[okNg]om;B
d_nh^;SoWIfMohF5QOnDU9Co[Zj^olW9bOoTi>Coo?cl7oooool02?ook^kool[:oonWYoooQhOooiZJ
oonn__oohN7ooogmA?ooool0063ooooo00?ooogmoonCTooofMT01oooool00ooIfMWoRHV9omSHf015
ooooo`0:ookno_oShn?o_knooj:RX_n7QhOoShn?ojZZZ_o4a<CogmoOooWinB3ooooo00SoooWioooH
f?oo]KGooi6Aoon<S?oo/;3oom?CooofmTSooooo001Qooooo`03oooNg_ooT93ooo_k00Oooooo00?o
i^KVohf=SOo;bl/0@Oooool02?odm?Cod=3@ojb/[?n8R8SoUYJFokbl_?oJf][omOGe8_ooool01ooo
i^Kool?3oonOWoooQXKooj:Rooo5aOoojNT0C?ooool006;ooooo00?oojZZoono_oooool01oooool0
0oo`l?3oTI6AolC4a00looooo`08oogmoOoQhN7o_;bloiRHV?n7QhOoZZZZolk>c_obl_8Rooooo`08
ooodm?oodM7oojf]oon:R_ooU9CookNgoooKfooon_Y?ooooo`00H_ooool00ooolO7oohV9ooo^kP08
ooooo`03oo?clonDU9Co_;bl03Sooooo00SolO7aolg=cOnYZJWoQhN7oiVIVOnm_KgohN7QooknoR7o
oooo00SooogmoooOgooo^k_ooiRHoon7QoooZJWoolg=ooo`l5?ooooo001Sooooo`03ooo4a?ooYJGo
oooo00Sooooo00?om_KfoiZJV_nd];@0<oooool02?olo?cog]kNokVi^OnEUIGoRHV9ojf][OoAdM7o
mOGe8_ooool02?ookNgoolW9oonVY_ooQXKooi^Koono_oooh^;oooknE_ooool006?ooooo00?ooogm
oonCTooofMT02Oooool01?oinOWoWinOojf][OomoOd^ooooo`07ono_koo:b/[oYZJVohJ6Q_nLW9co
`<30onCTi00Rooooo`08oooinOooemOookBdoon@T?ooSHgook6aoooDe?oom_IJooooo`00I?ooool0
0ooog]koohn?oookn`09ooooo`04oo_knonUYJGoYZJVooclo2Wooooo00Sono_kom_Kfong]kOoTY:B
oh^;Ron_[jooe=CDooOgmb;ooooo00OoonGUooo2`_ooWYkoohJ6oonSXoooa/Koon[Z05kooooo001U
ooooo`03oon[Zooo_koooooo00Wooooo00CooOgmojb/[?nPX:3on_[j9Oooool01oo[jn_oalO7oj>S
Xon5QHGoWinOol?3`ooWinL08_ooool02?oolo?oom3@oon/[?ooRHWooiFEoonh^?oog=cooo_kHOoo
ool006Gooooo00?ooo;boon9ROook^h02_ooool01?ono_ko/[:boi^KVoogmoLPooooo`08ooWinOoH
f=So];Bdohn?Son>SXko/[:bomKFe_oinOTQooooo`08ooolo?oog]kookZjoonGUoooR8SoojZZooo>
c_oolO5Uooooo`00I_ooool00oooa<CoojFUooooo`0;ooooo`03okZj^_nFUYKom?Cd01cooooo00Oo
j>SXolC4a?nPX:3oQHF5oj:RX_o6a/Kojn_[02;ooooo00Soonc/ooo8b?ooYJGoohJ6oonLW?oo`<3o
on?SooonoVSooooo001Vooooo`03ooomoOooU9CoomSH00cooooo00?o`L71oi:BT_o`l?006?ooool0
1oogmoOobLW9oiNGUonBTY;o]KFeomWIfOojn_X08Oooool02?oon?SoomKFoonc/oooShooohj>oonb
/_ooeMGoooOgK?ooool006Oooooo00?oomkNoon?Sooono/03?ooool00oo9bLWoSXj>onc/k00Eoooo
o`05omoOgon][JgoQhN7ojb/[?oNg]h08Oooool02?ooo_koonCTooo1`OooWIgoohJ6oonTY?ooalOo
on_[L?ooool006Sooooo00?ooj^[oono_oooool03?ooool00oo@d=3oS8b<onSXj00Aooooo`06oo?c
loo2`/;oTI6AoiNGUoo9bLWomoOg8?ooool02?ool_;oolo?oon[ZoooRHWooiJFooni^OoogMgooo_k
Loooool006Sooooo00?ooo;boon9ROook^h03Oooool00ooFe]KoRXZ:on?Sh`0=ooooo`06ookno_oH
f=SoYZJVohR8R?nc/k?oiNGU7oooool02?ooo?coomgMooni^OooUYKoohV9oon[Zooocloooo;bMooo
ool006Wooooo00?oolG5oonUYOooool03Oooool00ooLg=coRXZ:omgMg@0:ooooo`06ong]kOnl_;co
Rh^;oifMWOo?cloon_[j7_ooool02?oojn_oolO7oonTY?ooQXKooifMooo1`Oooi>CoooknN_ooool0
06Wooooo00?ooogmoonDU?oof=P03_ooool00ooRh^;oRXZ:omOGe`06ooooo`06oo_knooAdM7oWinO
oh^;Ronj^[[ok>c/7Oooool02?oomoOoomGEoonb/_ooSXkoohn?oonc/oooe]KoooShO_ooool006[o
oooo00?oomkNoon@T?oono/03_ooool00ooWinOoRh^;om7Ad@03ooooo`06onOWione]KGoR8R8ojBT
Y?oFe]KooOgm6oooool02?ooo_koon?Sooo0`?ooW9coohJ6oonUYOoob<Soonc/P_ooool006_ooooo
00?ooj^[oonn__ooool03_ooool02?o/k>coSXj>olC4a?o:b/[oVIVIohn?Soo1`L7olO7a6oooool0
2?ool_;oolk>oonZZ_ooR8SooiNGoonj^_oog]koooclQOooool006_ooooo00?ooo;boon9ROook^h0
3_ooool01OoPh>3oXj>Soda<C?n2PX;ogMgM01[ooooo00Sooo_koooLg?oo^;SooiFEoon9ROoo[:co
om3@oooclhWooooo001/ooooo`03ooo5aOooYJGooooo00[ooooo00Som?CdolC4a?nBTY;oUYJFolO7
aooZj^[oUIFEol?3`aOooooo00Soon[Zooo6a_ooXj?oohJ6oonNW_oo`/;oonGUooonoXcooooo001/
ooooo`03ooomoOooU9CoomSH00Oooooo00Koo_knomWIfOnWYjOoQhN7ok:b/_oTi>@3ooooo`03oo?c
lom5ADGoW9bL01;ooooo00SoooOgoooDe?oo/K7oohf=oon@T?oo];CoomOGooohn93ooooo001]oooo
o`03oooOgoooShoooo_k00Cooooo00Kok^k^okfm_On<S8coW9bLolk>c_ojn_X6ooooo`03ooKfm_nF
UYKo`l?300gooooo00SoooknoooRh_oo_koooi^Koon6Q_ooYZKoolW9ooo]kICooooo001^ooooo`09
oon[Zooo_[koooooooooooo[jn_oYjNWohZ:R_ni^KWojn_[00[ooooo00?olo?coi2@T?o=cLd02Ooo
ool02?oolO7oolg=oonYZOooR8SooiRHoonk^ooogmooooclUoooool006kooooo00Oooo;boon9ROoc
h^;o/k>cohZ:R_o9bLWoo?cl00gooooo00?ok^k^ohb<S?oFe]H01?ooool02?oono_oom_Koong]ooo
U9CoohZ:oon][OoodM7oooCdVoooool006kooooo00Gon_[joknCTon8EeOo^[ZjooOgm`0@ooooo`0:
onSXj?n:RX[og]kNoooYjOooaLGooj:Roon6Q_ooWioool?3oooViYoooooo001/ooooo`06ookno_o<
c<coS8b<ojf[Zoo`Rh_oomSH4?ooool02?oom_Koom?Con6KVon9Bd_oiH:2oone]Ooof=SoooWiX_oo
ool006_ooooo00SofMWIoi>CTonQXJ7oi^KVoooooooogmooohn?oookn`_ooooo00[ooogmoooQhOoo
_[kooiZJoon7QoooYjOool[:omW:b_n;Rh_ok>c/Y?ooool006Wooooo00CoiNGUoinOWonEUIGofm_K
1?ooool00ooo[:cookjnooooo`07ooooo`08ooo`l?ooc<coojRXoon8R?ooVIWookbloooPh?oooOd3
ooooo`03om7AdOn>SXkolO7a0:?ooooo001Wooooo`05ono_kon/[:coS8b<olk>c_ono_h01Oooool0
0oool_;oohV9ooo^kP03ooooo`08ooojn_oof][ookJfoonCToooRh_oojj^oooBd_oom?@8ooooo`03
olO7aonCTi?om_Kf0:;ooooo001Uooooo`05ooOgmonh^;SoR8R8ol71`Oojn_X02?ooool02OooaLGo
ojBToooXj?ooa<Cooj6Qoon5QOooX:3oolC4oooWi`0=ooooo`03okjn__nJVY[on_[j0:7ooooo001S
ooooo`05ooclo?o5aLGoRHV9okBd]?odm?@02?ooool02?oomOGoom;Boon^[_ooL73oohR8oonf]_oo
fMWooo[j4Oooool00on_[jooZZZZooooo`2Pooooo`00H_ooool01?oBd];oShn?ojNWYoo/k>`6oooo
o`0:ooomoOooh>3ookfmoonIVOooQhOoojRXooo;booofm_oohn?oookna?ooooo00?oo?cloi^KVoo1
`L40X?ooool0063ooooo00CogmoOoiRHV?nKVi_ohN7Q1Oooool02?ooknoool_;oonWYoooQhOooiZJ
oonm_OoohN7ooogm0oooool00ooo[:cookjnooooo`0Cooooo`03ooCdm?n=SHgof=SH09oooooo001N
ooooo`04on[Zj_nUYJGoT92@omGEe@?ooooo00Sooo[joooIfOoo]KGooi:Boon;Rooo[jooom?Coooe
m@Oooooo00?ooo;boon9ROook^h05?ooool00ooVi^KoRXZ:onWYj@2Nooooo`00G?ooool03Ooclo?o
/K6aohZ:R_o8b<SooOgmooooooooinOool?3oonPX?ooQHGooj6Qooo5aOooj>P03?ooool00oooaLGo
ojBTooooo`0Dooooo`03om?Cdon@T93om_Kf09gooooo001Jooooo`0<ooWinOnn_[koR8R8ok^k^ooh
kNgoom7Aoon^[_ooRh_ooi>Coong]ooof][ooo[j3oooool00ooooOgooiBDoooGe`0Eooooo`03okbl
_?nPX:3ooOgm09cooooo001Hooooo`0:oogmoOo;bl_oRhV9ojjHV?oa/K7ooiRHoon8R?ooZJWoolc<
ooo`l1Cooooo00?oomoOoon?Sooono/05?ooool00oono_koYZJVokFe]@2Looooo`00Eoooool02?oG
alOoTgAdoj9YJOoXNW[ooi^Koonn__ooh^;ooogm6?ooool00ooo[:cookfmooooo`0Dooooo`03ooWi
nOnDU9Coc<c<09_ooooo001Eooooo`06ooShn?nVLG7oUde=ombGUoooe=CoooKf7?ooool00ooolo?o
ohV9ooo]k@0Eooooo`03ong]kOn;Rh_ohN7Q09[ooooo001Dooooo`04onOWion@QHGo]e]Koooclb3o
oooo00?oolK6oonTY?ooool05Oooool00ooPh>3oSHf=ooKfmP2Iooooo`00Doooool01?o<c<coRHV9
omF8R?ooalLQooooo`03ooomoOooU9CoomOG01Kooooo00?o][Jfojn_[oooool0V?ooool0057ooooo
00Kon_[jojj^[_nFUYKokLK6oonEUOoooOdRooooo`03oooPh?ooSXkooo_k01Gooooo00?on_[joi2@
T?oIfMT0V?ooool0053ooooo00Kok>c/oiFEUOn`/;3onoKfoon>S_ooh>0Tooooo`03oon/[?oo_Kgo
oooo01Gooooo00?ohN7Qohb<S?ogmoL0Uoooool004oooooo00Koe=CDohV9ROo>c/kooooooonm_Ooo
[JdUooooo`03ooocloooRHWoong]01Kooooo00?o^;Rhojf][Oooool0U_ooool004gooooo00SooOgm
okJf]_nATI7oj>SXooooooookNgoohV9oooclbKooooo00?oolK6oonTY?ooool05Oooool00ookno_o
TY:BomOGe`2Fooooo`00C?ooool01?o`l?3oVYZJojNWYoohn?P2ooooo`03oonSXoooalOooooo02Ko
oooo00?ooogmoonEUOooemL05_ooool00ooRh^;oS8b<ooKfmP2Eooooo`00Boooool00ooKfm_oRh^;
olK6aP03ooooo`03oooFe_ooUIGooogm02Sooooo00?oon3Poon>S_oono/05_ooool00oni^KWoZj^[
ooooo`2Dooooo`00BOooool01?ono_ko_[jnohf=SOoRh^83ooooo`03ooojn_ooSXkoon3P02[ooooo
00?oojb/oonm_Oooool05Oooool00ookno_oTi>ComKFeP2Dooooo`00B?ooool01?odm?CoX:2Poj6Q
XOoemOD4ooooo`03oonl_?oo[Jgooooo02[ooooo00?ooo?coon9ROookNd05_ooool00ooWinOoRh^;
ooShn02Cooooo`00Aoooool01?oQhN7oSHf=okjn__ono_h4ooooo`03ooo]kOooRHWooo?c02cooooo
00?oolK6oonSXoooool05_ooool00on_[joo_knoooooo`2Booooo`00A_ooool00oo5aLGoRh^;om_K
f`06ooooo`03oonRX_ooalOooooo02cooooo00?ooogmoonEUOooemL05_ooool00oo`l?3oR8R8ooCd
m02Booooo`00A?ooool01?ohn?SoYjNWoi^KVooalO46ooooo`03oooFe_ooUYKooogm02kooooo00?o
on3Poon?Sooon_X05_ooool00ong]kOo][Jfooooo`2Aooooo`00@oooool01?oWinOoT92@okNg]oom
oOd6ooooo`03ooojn_ooSXkoon7Q033ooooo00?oojf]oonm_Oooool05Oooool00ooemOGoRHV9ono_
k`2Aooooo`00@_ooool00oo=cLgoRHV9omGEe@08ooooo`03oonl_?oo[Jgooooo033ooooo00?ooo?c
oon9ROookNd05_ooool00oo1`L7o/[:booooo`2@ooooo`00@?ooool01?ojn_[o[Zj^oiJFU_o/k>`8
ooooo`03ooo/k?ooRHWooo?c03;ooooo00?oolK6oonSXoooool05Oooool00oofm_KoR8R8ooCdm02@
ooooo`00?oooool01?o/k>coUIFEojn_[oojn_X9ooooo`03oonRX_ooalOooooo03;ooooo00?ooogm
oonEUOooe]H05_ooool00one]KGo_Kfmooooo`2?ooooo`00?_ooool00ooEeMGoRHV9olg=c@0:oooo
o`03oooFe_ooUIGoookn03Cooooo00?oon3Poon>S_oon_X05Oooool00oo_knooRHV9ooWin@2?oooo
o`00?Oooool00onf][KoT92@onOWi`0:ooooo`03ooojn_ooSXkoon7Q03Kooooo00?oojf]oonm_Ooo
ool05Oooool00on][JgoalO7ooooo`2>ooooo`00>oooool01?ono_koY:BToi^KVoohn?P;ooooo`03
oonl_?oo[Zkooooo03Kooooo00?ooo?coon9ROookNd05Oooool00ooPh>3oUiNGooooo`2>ooooo`00
>_ooool01?ono_koZJVYoiRHV?omoOd;ooooo`03ooo/k?ooRHWooo?c03Sooooo00?oolO7oonSXooo
ool05Oooool00on>SXkoj^[Zooooo`2=ooooo`00>Oooool01?ono_koZj^[ojBTY?olo?`<ooooo`03
oonRX_ooalOooooo03Sooooo00?ooogmoonEUOooe]H05Oooool00onk^k_o_;blooooo`2=ooooo`00
>?ooool01?ono_ko[Jf]oj:RX_olo?`<ooooo`03oooEeOooUYKoookn03[ooooo00?oon3Poon>S_oo
n_X05?ooool00ooYjNWoSXj>ooooo`2=ooooo`00>?ooool00on_[jooXJ6Qoo_kn`0<ooooo`03oooj
n_ooSXkoon7Q03cooooo00?oojf]oonl_?ooool05?ooool00onHV9Sohn?Sooooo`2<ooooo`00=ooo
ool00ona/K7oWinOoo[jnP0=ooooo`03oonl_?oo[Zkooooo03cooooo00?ooo?coon9ROookNd05?oo
ool00ong]kOoa<C4ooooo`2<ooooo`00=_ooool00onc/k?oWYjNoo[jnP0=ooooo`03ooo/k?ooRHWo
oo?c03kooooo00?oolO7oonSXoooool04oooool00ooFe]KoYJFUooooo`2<ooooo`00=Oooool00one
]KGoWIfMooWin@0>ooooo`03oonRX_oob<Sooooo03kooooo00?ooogmoonEUOooe]H04oooool00ooe
mOGoQhN7ooknoP2<ooooo`00=?ooool00ong]kOoVi^KooShn00>ooooo`03oooEeOooUYKoookn043o
oooo00?oon7Qoon>S_oon_X04oooool00onDU9CoinOWooooo`2;ooooo`00<oooool00oni^KWoVYZJ
ooOgm`0>ooooo`03ooojn_ooSXkoon7Q04;ooooo00?oojf]oonl_?ooool04_ooool00on`/;3oclo?
ooooo`2;ooooo`00<_ooool00onl_;coV9RHooOgm`0?ooooo`03oonk^ooo[Zkooooo04;ooooo00?o
oo?coon9ROookNd04_ooool00oo2`/;o^k^kooooo`2;ooooo`00<Oooool00ono_kooUYJFooKfmP0?
ooooo`03ooo/k?ooRHWoooCd04Cooooo00?oolO7oonRX_ooool04Oooool00ooFe]KoZ:RXooooo`2;
ooooo`00<?ooool00oo1`L7oU9BDooGem@0@ooooo`03oonRX_oob<Sooooo04Cooooo00?oooknoonE
UOooe]H04Oooool00ooYjNWoUIFEooooo`2;ooooo`00;oooool00oo3`l?oTi>CooCdm00@ooooo`03
oooEeOooUYKoookn04Kooooo00?oon7Qoon>S_oon_X04?ooool00oomoOgoPh>3ooooo`2;ooooo`00
;_ooool00oo6a/KoTI6Aoo?cl`0@ooooo`03ooojn_ooSXkoon7Q04Sooooo00?oojj^oonl_?ooool0
4?ooool00on5QHGonOWiooooo`2:ooooo`00;Oooool00oo8b<SoTI6Aoo;blP0Aooooo`03oonk^ooo
[Zkooooo04Sooooo00?ooo?coon9ROook>`04?ooool00on>SXkol_;booooo`2:ooooo`00;?ooool0
0oo:b/[oT92@oo7al@0Aooooo`03ooo/k?ooRHWoooCd04[ooooo00?oolO7oonRX_ooool03oooool0
0on=SHgolO7aooooo`2:ooooo`00:oooool00oo<c<coShn?oo3`l00Booooo`03oonQXOoob<Sooooo
04[ooooo00?oooknoonEUOooe]H03oooool00on:RX[omOGeooooo`2:ooooo`00:_ooool00oo>c/ko
SXj>ono_k`0Booooo`03oooEeOooUYKoookn04cooooo00?oon7Qoon>S_oon_X03_ooool00on4Q8Co
no_kooooo`2:ooooo`00:Oooool00oo@d=3oSHf=onk^kP0Booooo`03ooojn_ooSXkoon7Q04kooooo
00?oojj^oonl_?ooool03?ooool00oogmoOoQhN7ooooo`2;ooooo`00:?ooool00ooBd];oS8b<onc/
k00Cooooo`03oonk^ooo[Zkooooo04kooooo00?ooo?coon9ROook>`03?ooool00oo[jn_oTi>Coooo
o`2;ooooo`009oooool00ooDe=CoRh^;on_[j`0Cooooo`03ooo[joooRX[oooCd053ooooo00?oolO7
oonRX_ooool02oooool00ooOgmooWinOooooo`2;ooooo`009_ooool00ooPh>3oRXZ:onk^kP0Doooo
o`03oonQXOoob<Sooooo053ooooo00?oooknoonFU_ooeMD02oooool00ooDe=CoZj^[ooooo`2;oooo
o`009Oooool00oodm?CoSHf=om_Kf`0Dooooo`03oooEeOooUYKoookn05;ooooo00?oon7Qoon>S_oo
n_X02_ooool00ong]kOoa<C4ooooo`2;ooooo`009?ooool00oomoOgoWYjNol30`00Dooooo`03oooj
n_ooSHgoon;R05Cooooo00?oojj^oonl_?ooool02Oooool00onIVIWoh^;Rooooo`2;ooooo`009?oo
ool00onh^;SoY:BTooooo`0Dooooo`03oonk^ooo[joooooo05Cooooo00?ooo?coon:R_ook>`02?oo
ool00ooinOWoQHF5ooclo02<ooooo`008oooool00ooDe=CoT92@ooOgm`0Dooooo`03ooo[joooRHWo
ooCd05Kooooo00?oolS8oonRX_ooool01oooool00ooLg=coWinOooooo`2<ooooo`008_ooool00ooZ
j^[oRHV9onSXj00Eooooo`03oonQXOoobLWooooo05Kooooo00?oooknoonFU_ooeMD01oooool00oni
^KWo_knoooooo`2<ooooo`008Oooool00oohn?SoTY:Bom7Ad@0Eooooo`03oooDe?ooUiOoookn05So
oooo00?oon7Qoon>S_oon_X01Oooool00oomoOgoRXZ:onk^kP2=ooooo`008Oooool00onWYjOo]KFe
ooooo`0Dooooo`03ooojn_ooSHgoon;R05[ooooo00?oojj^oonk^oooool01?ooool00ooIfMWoWIfM
ooooo`2=ooooo`008?ooool00oo3`l?oVi^Koogmo@0Eooooo`03oonk^ooo[joooooo05[ooooo00?o
ooCdoon9ROook>`01?ooool00onYZJWocLg=ooooo`2=ooooo`007oooool00ooNg]koRh^;oo;blP0E
ooooo`03ooo[joooRHWoooCd05cooooo00?oolS8oonRX_ooool00_ooool00oohn?SoQhN7ooShn02>
ooooo`007_ooool00ooalO7oRh^;on3Ph00Fooooo`03oonQXOoobLWooooo05cooooo00?oooknoonF
U_ooeMD00_ooool00onl_;co];Bdooooo`2>ooooo`007Oooool00oono_koVYZJolW9b@0Fooooo`03
oooDe?ooUiOoookn05kooooo00Koon7Qoon>S_oon_[om_KfohR8R?oalO6?ooooo`007Oooool00oo6
a/KoX:2Pooooo`0Eooooo`03oooinOooSXkoon;R063ooooo00Coojj^oonk^ong]kOo]kNgT?ooool0
01cooooo00?ok>c/ohV9ROo_knl05_ooool00ooo^[[oojn_ooooo`1Pooooo`04ooodm?o[MGGoRWmo
ooKfmY3ooooo000Kooooo`03ookno_nLW9cob/[:01Kooooo00?oon_[oon9ROoom?@0H?ooool01?oo
hn?ooZb/oia:B_o9][JAooooo`006oooool00oo6a/KoWinOooooo`0Fooooo`03oonQXOoobLWooooo
05gooooo00Kooo_kooo=cOooV9Sooi:BokR?SonWXJ6Booooo`006_ooool00oo]kNgoRHV9onk^kP0F
ooooo`03oooDe?ooUiOoookn05cooooo00Soong]oonh^?ooR8SoojNWoooLg?oHf=SoShn?ooOgmi;o
oooo000Iooooo`03ookno_nMWIgobLW901Kooooo00?oooWioon=SOooh^80F_ooool02_ooo_koomSH
oonSXoooRX[ookblooo`l?ooooool?3`ohZ:R_oTi>BCooooo`006Oooool00oo7alOoWYjNooooo`0F
ooooo`03oonj^_oo[joooooo05Sooooo00KoooGeooo3`oooSXkooibLoooAdOooo?`2ooooo`03oogm
oOnKVi_oalO709Cooooo000Hooooo`03ong]kOn9RHWok^k^01Kooooo00?oon_[oon:R_oom?@0Eooo
ool01Ooohn?oojf]oon7Qooo/K7oonOW00Gooooo00?o^KViojJVY_ooool0U?ooool001Sooooo00?o
WIfMolS8b?ooool05_ooool00oooX:3oolW9ooooo`1Dooooo`06ooojn_oocLgooiRHoonBT_ooalOo
ooOg1_ooool00ooIfMWoShn?ooOgm`2Eooooo`005oooool00oo8b<SoWIfMooooo`0Fooooo`03oooD
e?ooUiOoookn05?ooooo00Goong]oonh^?ooR8SoojNWoooLg008ooooo`03oo3`l?n:RX[ohn?S09Ko
oooo000Fooooo`03oo7alOn9RHWol?3`01Kooooo00?oooWioon=SOooh^80DOooool01_ooo_koomSH
oonRX_ooRX[ookbloooal@Wooooo00?oo?cloeEEEOo6a/H0Uoooool001Kooooo00?o/k>cok^k^ooo
ool05_ooool00ooo^[[ook2`ooooo`1?ooooo`06oooemOoo`/;oohj>oonLW?ood];ooocl2_ooool0
0oolo?coXZ:RojRXZ02Hooooo`005Oooool00oo]kNgoRHV9ooOgm`0Fooooo`03ooo[joooRHWoooGe
04kooooo00Goon;Roon][OooQhOook:boooWi`0<ooooo`04oo_knonRXZ;oZj^[ooknoYSooooo000E
ooooo`03oj^[Zoo3`l?ooooo01Kooooo00?ooj2Pooo9bOooool0Boooool01_oon_[oolg=oonGUooo
TY;oolO7ooogm`gooooo00ConOWioijNW_n_[jooo_knVOooool001Cooooo00?oi^KVohb<S?okno/0
5_ooool00ooodm?ooiRHooonoP1:ooooo`05ooo]kOoo^;SoohR8oonWYooogMd03oooool00oohn?So
Vi^Kok>c/`2Kooooo`005?ooool00onRXZ;obl_;ooooo`0Eooooo`03oooinOooSHgoon?S04Sooooo
00KoooknoooGeoooXZ;oohZ:oonl_?oolO4@ooooo`03ooKfm_nHV9So^;Rh09cooooo000Cooooo`03
omoOgonATI7ooOgm01Kooooo00?ookZjoon`/?ooool0A_ooool01_oom?Cool;2oon>S_ooWIgoom;B
ooolo17ooooo00?om?CdoiJFU_nl_;`0WOooool001?ooooo00?oVYZJomCDe?ooool05Oooool00ooo
jn_oohV9oooem@15ooooo`05oooRh_oo[JgoohN7oonb/_ooj>P04oooool00oobl_;oTi>Col71`@2N
ooooo`004_ooool00ooFe]KoV9RHooooo`0Fooooo`03oonPX?oob/[ooooo04;ooooo00Kooo[jooo=
cOooUiOooi:Booo7aooon?PDooooo`03ooGemOn@T93oaLG509oooooo000Aooooo`03ookno_nCTi?o
g=cL01Kooooo00?oom?CoonHV?ooo_h0@Oooool01OookNgookNgoon8R?ooYjOoomgM01Kooooo00?o
iNGUoi6ATOo:b/X0X?ooool0017ooooo00?oc/k>oj2PX?ooool05Oooool00ooonOWoohf=oooSh`0o
ooooo`06ooono_ooemOooj:Roon:R_oo_Kgooo7a5_ooool01?omoOgo`<30ohZ:R_oBd]:Qooooo`00
4Oooool00onGUiOoh^;Rooooo`0Eooooo`03oonj^_oo/;3ooooo03gooooo00KoooCdooo2`_ooSXko
oifMoooBd_ooo?`Gooooo`04onc/k?nJVY[oXj>Soo?clj;ooooo000@ooooo`03on?ShonBTY;ooooo
01Gooooo00?oon[Zoon:R_oomOD0??ooool01Oooh^;oojb/oon7Qooo/[;oonSX01Wooooo00?obLW9
ohV9ROo;bl/0Y?ooool0013ooooo00?o/[:bolC4a?ooool05Oooool00oooX:3ool[:ooooo`0ioooo
o`06ooojn_ooc<cooiNGoonCTooob<SoooSh6Oooool01?obl_;oXZ:Roi^KVoo]kNfUooooo`003ooo
ool00oojn_[oQhN7ooCdm00Eooooo`03oooCdoooV9Soookn03Sooooo00Goonc/oong]oooR8SoojRX
oooMg@0Kooooo`04om;Bd_n:RX[o`/;2ooknoZKooooo000?ooooo`03olk>c_nWYjOooooo01Cooooo
00?oooWioon<S?oohn<0=_ooool01_ooo_koomOGoonRX_ooRh_ookfmoooalA_ooooo00Com_KfojZZ
Z_nDU9CoinOWZ?ooool000oooooo00?oWIfMomWIfOooool05?ooool00ooo^KWook2`ooooo`0doooo
o`06ooodm?oo`/;oohf=oonMWOood];ooocl7?ooool01?oLg=coSHf=okVi^Oolo?bYooooo`003_oo
ool00oo[jn_oS8b<ooknoP0Dooooo`03oooZj_ooRX[oooGe03?ooooo00Goon;Roon/[?ooQhOook:b
oooXj00Mooooo`04oo[jn_nd];CoSXj>omoOgj_ooooo000>ooooo`03okVi^Onl_;cooooo01Cooooo
00?ooinOooo:b_ooool0<?ooool01_oon_[oolc<oonGUoooTi?oolS8ooohn1kooooo00Coi>CToi6A
TOn_[joon?Sh[?ooool000gooooo00?ooOgmohZ:R_o^k^h05?ooool00ooodm?ooiRHooonoP0_oooo
o`05ooo/k?oo]kOoohR8oonXZ?oogMd07oooool01?omoOgo_Kfmoh^;RooGemN^ooooo`003Oooool0
0ooFe]KoXZ:Rooooo`0Cooooo`03oooinOooS8coon?S02gooooo00KoooknoooGeoooXJ7ooh^;oonm
_OoolO4Pooooo`04on[Zj_nHV9SoYZJVooCdm:oooooo000=ooooo`03ok6a/Oo:b/[ooooo01?ooooo
00?ookVioon`/?ooool0:oooool01_oom?Cool71oon=SOooWIgoom?Cooolo27ooooo00?oalO7ohV9
ROo>c/h0/Oooool000gooooo00?oT92@on[Zj_ooool04_ooool00oooj^[oohZ:oooem@0Zooooo`05
oooQhOoo[:coohN7oonc/oooj>P08_ooool01?oalO7oWinOoifMWOo_knnbooooo`003?ooool00oo_
knooRh^;ooooo`0Cooooo`03oonOWooob/[ooooo02Oooooo00Kooo[jooo<c?ooUYKooi>Cooo8b?oo
n?PSooooo`04om3@d?n9RHWoa<C4ookno[?ooooo000<ooooo`03olk>c_n/[:cooooo01;ooooo00?o
om?CoonHV?ooo_h09_ooool01Oook>cookNgoon8R?ooZ:SoomkN02Cooooo00ConOWiojRXZ?nFUYKo
j>SX]Oooool000cooooo00?o[Zj^olk>c_ooool04Oooool00ooonOWoohf=oooSh`0Tooooo`06ooon
o_ooe]Kooj6Qoon;Rooo_Kgooo7a9?ooool01Oolo?coc<c<ohj>S_nk^k_oo?cl0;Kooooo000<oooo
o`03oiZJV_oShn?ooooo017ooooo00?ookVioona/Oooool08_ooool01_oom?Cool71oon=SOooWYko
om?CooomoBCooooo00Gono_kolS8b?n=SHgoYJFUon?Sh`2hooooo`003?ooool00on5QHGon?Shoooo
o`0@ooooo`03oooZj_ooRX[oooGe027ooooo00Goon7Qoon/[?ooQhOook>coooYj@0Uooooo`05ooWi
nOo4a<CoRh^;ojVYZOoWinL0^_ooool000_ooooo00?ol?3`ohf=SOooool04Oooool00oooWioool_;
ooooo`0Nooooo`06ooojn_ooc<cooiJFoonCTooob<SoooSh9Oooool01OogmoOo`<30ohZ:R_n][Jgo
j^[Z0;cooooo000;ooooo`03omcLg?nSXj?ooooo013ooooo00?oom;BoonHV?ooo_h07Oooool01Ooo
k>cookJfoon8R?ooZ:SoomkN02Kooooo00GomOGeokbl_?n8R8So/;2`ong]k@2nooooo`002oooool0
0ooEeMGoZZZZooooo`0?ooooo`03oooinOooS8coonCT01_ooooo00KoooknoooFe_ooXJ7ooh^;oonn
__ool_8Vooooo`05oo?clonh^;SoR8R8okBd]?o`l?00`?ooool000_ooooo00?odM7Aojj^[_ooool0
3oooool00ooo^KWook6aooooo`0Iooooo`06ooodm?oo`L7oohf=oonNW_oodm?ooogm9_ooool01Oo`
l?3o];BdohR8R?nh^;Solo?c0<;ooooo000;ooooo`03olg=cOnb/[;ooooo00kooooo00?oon[Zoon:
R_oomOD06?ooool01OoohN7ooj^[oon7Qooo/k?oonWY02Oooooo00GokNg]ok2`/?n9RHWo_;blooGe
m@34ooooo`002oooool00oo8b<So]kNgooooo`0>ooooo`03oonOWooobl_ooooo01Gooooo00Kooo[j
ooo;boooUYKooi>Cooo9bOoon?PWooooo`05on[Zj_n/[:coRXZ:ol30`?ogmoL0a_ooool000_ooooo
00?od];Bojb/[?ooool03Oooool00oood];ooiRHooonoP0Dooooo`05ooo[jooo][KoohR8oonYZOoo
g]h0:?ooool01OoVi^KoZ:RXoh^;Roo4a<ConOWi0<Sooooo000;ooooo`03on;Rh_nLW9cooooo00co
oooo00?oooWioon<S?ooi>@04_ooool01_ooo_koomKFoonQXOooRh_ookjnoooblRSooooo00Gohn?S
ojBTY?n=SHgob<S8oo_kn`3:ooooo`002oooool00ooalO7oSHf=ooooo`0<ooooo`03oonh^?oo/K7o
oooo013ooooo00Kooo?cooo1`OooSHgooijNoooCdooooOdXooooo`05omoOgonQXJ7oT92@olc<c?ol
o?`0c?ooool000_ooooo00?oo_knohB4Q?olo?`02oooool00oooj^[oohZ:oooem@0?ooooo`05oooQ
hOooZj_oohR8oonc/ooojNT0:Oooool01OoKfm_oW9bLoi>CToo@d=3ooOgm0<kooooo000<ooooo`03
oibLW?oOgmoooooo00[ooooo00?ooinOooo;boooool03?ooool01_oonOWool_;oonFU_ooTi?oolW9
ooohn2Sooooo00Kon?Sholg=cOnKVi_oUYJFomCDe?ono_k@ooooo`003?ooool00oo5aLGo/k>coooo
o`09ooooo`03oooBd_ooVIWoookn00_ooooo00Goon_[oonf]_ooR8SoojVYoooNgP0Xooooo`06ookn
o_oJf][oZj^[ohN7QonZZZ[ofMWIdoooool000cooooo00?olO7aohZ:R_olo?`02?ooool00ooonOWo
ohb<oooTi009ooooo`06ooono_ooe]Kooj2Poon;Rooo_[kooo;b:?ooool01_oXj>So^;Rhoh^;RonL
W9cobl_;ooOgmmGooooo000=ooooo`03ojVYZOo9bLWooooo00Oooooo00?ookRhoona/Oooool01ooo
ool01_oolo?ool30oon=SOooWYkoomCDooomoBOooooo00Kolo?colK6a_nGUiOoShn?okjn__o]kNgH
ooooo`003Oooool00ooUiNGoSXj>oo[jnP06ooooo`03oooZj_ooRX[oooGe00Kooooo00Goon3Poon[
ZoooR8SookBdoooYj@0Wooooo`06oo_knooCdm?oY:BTohR8R?na/K7oh>3Pfoooool000kooooo00?o
/;2`olK6a_ooool01Oooool00oooWYkool_;ooooo`03ooooo`06oooinOoobl_ooiFEoonDU?oobLWo
ooSh9_ooool01ooinOWoemOGok:b/_n8R8SoXj>Som?Cdookno/0gOooool000kooooo00?onOWioi:B
T_o<c<`01?ooool00oood];ooiVIooonoP02ooooo`05ooo[jooo][KoohR8oonYZOoogml09_ooool0
1ooZj^[oaLG5oj6QXOn6QXKoXj>SolS8b?oclo<0h?ooool000oooooo00?ok^k^ohj>S_o3`l<00_oo
ool02Ooon?Soohb<oooTi?oooOgoomGEoonPX?ooS8cookjnoooblP0Tooooo`03oo[jn_oIfMWo];Bd
00;oShn?00?o];BdomWIfOojn_X0hoooool0013ooooo00_om_Kfofm_KonOWiooo?cloonh^?oo[joo
ol30oon=SOooWiooomCDooomo@0Sooooo`07onc/k?o8b<SoXj>SohJ6Q_nQXJ7oaLG5on_[j`3Woooo
o`004Oooool01oojn_[oYjNWoi>6Q_oGHf?oohF5oond]?oojNT08Oooool02Oojn_[ohn?SolW9bOn`
/;3oTi>Cohf=SOnb/[;oemOGooWin@3Zooooo`004oooool01OoIdm?oT79boiZFU_o?cloono_k01co
oooo00[onOWion7QhOo8b<So[jn_oiFEUOn4Q8CoVIVIok>c/oo<c<cojNWYk_ooool001Gooooo00Ko
f=SHojNWYon8R8SoZ:RXolk>c_oYjNTCooooo`0<oogmoOo_knoohN7QolK6a_n][JgoU9BDohB4Q?nK
Vi_o];Bdolg=cOoWinOooOgml_ooool001Oooooo01kom_Kfom;Bd_n^[ZkoTi>CohJ6Q_nEUIGoYJFU
okFe]Oo4a<CodM7AomCDe?oGemOof][JomgMgOoOgmooe]KFolo?coo8b<So`<30okZj^_n[Zj_oW9bL
ohf=SOn2PX;oShn?oijNW_nf][Koclo?onSXj?ono_kgooooo`006oooool02Oohn?SojNWYomWIfOo9
bLWo^[Zjojn_[on[Zj_oZ:RXojFUY@02oj6QX@09ojRXZ?n`/;3o]kNgokjn__o6a/Kodm?Con;Rh_oa
lO7oo_kn0?gooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo
0000\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-1.29242, -0.0764506, 0.0149344, \
0.0179344}},
 CellTags->"S5.43.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.43.1"]
}, Open  ]],

Cell["\<\
Compare the cubic spline of the previous example to a Bezier spline.\
\>", "MathCaption",
 CellTags->{"S5.43.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
Show[
  Graphics[{Hue[0], Line[pts], GrayLevel[0],
    Spline[pts, Bezier]}],
    PlotRange -> All]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.43.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0147151 0.196201 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 0 0 r
.5 Mabswid
[ ] 0 setdash
.2619 .01472 m
.5 .40712 L
.02381 .60332 L
.2619 .21092 L
.97619 .01472 L
s
0 g
.2619 .01472 m
.29456 .07796 L
.31473 .13649 L
.32474 .18974 L
.32676 .23726 L
.32284 .27865 L
.31492 .31362 L
.30482 .34195 L
.29424 .36352 L
.28475 .37828 L
.28087 .38312 L
.27923 .38491 L
.27781 .38628 L
.27663 .38724 L
.27614 .38756 L
.27592 .38769 L
.27571 .38778 L
.27553 .38786 L
.27536 .3879 L
.27528 .38792 L
.27521 .38792 L
.27514 .38792 L
.27508 .38792 L
.27502 .38791 L
.27497 .38789 L
.27492 .38786 L
.27488 .38783 L
.27484 .3878 L
.2748 .38775 L
.27477 .3877 L
.27475 .38765 L
.27471 .38752 L
.2747 .38736 L
.27471 .38718 L
.27474 .38698 L
.27485 .38649 L
.27506 .38591 L
.27574 .38444 L
.27679 .38259 L
.28501 .37141 L
.3004 .35449 L
.32381 .3323 L
.35597 .30538 L
.39748 .27439 L
.44885 .24004 L
.51043 .20314 L
.58249 .16459 L
.66514 .12537 L
.75841 .08653 L
.86217 .04924 L
Mistroke
.97619 .01472 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.43.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.43.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SplineDots", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "style to render interpolation or control points of curve",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SplinePoints", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["25", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "initial number of points sampled in default rendering of spline",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MaxBend", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["10.", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "maximum angle between successive segments when using adaptive \
rendering",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SplineDivision", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["20.", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "maximum amount of subdivision to be used in attempting to generate a \
smooth curve",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.43.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["Spline", "MR"],
 "."
}], "Caption",
 CellTags->"S5.43.1"],

Cell[TextData[{
 "The spline graphics primitive has an option allowing the control points to \
be shown. By setting the ",
 StyleBox["SplineDots", "MR"],
 " option to a style primitive (or list of style primitives), you can control \
the characteristics of these points. Setting it to ",
 StyleBox["None", "MR"],
 " will suppress the display of the points, while setting it to ",
 StyleBox["Automatic", "MR"],
 " will place red dots at each point. "
}], "Text",
 CellTags->{"S5.43.1", "1.7"}],

Cell["Here is a spline with the control points shown.", "MathCaption",
 CellTags->{"S5.43.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[Spline[pts, CompositeBezier,
 SplineDots -> Automatic]]]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.43.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.297067 0.226374 0.0147151 0.160842 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.03 w
.29707 .01472 Mdot
.52344 .3364 Mdot
.07069 .49724 Mdot
.29707 .17556 Mdot
.97619 .01472 Mdot
0 g
.5 Mabswid
[ ] 0 setdash
.29707 .01472 m
.32078 .05569 L
.33584 .09793 L
.34305 .141 L
.34318 .18449 L
.32536 .27106 L
.28868 .35427 L
.23943 .43078 L
.18388 .49724 L
.12833 .5503 L
.10253 .57075 L
.07908 .5866 L
.06848 .59266 L
.05877 .59742 L
.05004 .60081 L
.04608 .60198 L
.0442 .60243 L
.0424 .60279 L
.03901 .60324 L
.03743 .60332 L
.03593 .60331 L
.03451 .6032 L
.03317 .603 L
.03191 .6027 L
.03131 .60251 L
.03074 .6023 L
.02965 .60181 L
.02865 .60122 L
.02774 .60052 L
.02732 .60014 L
.02692 .59973 L
.02619 .59883 L
.02556 .59784 L
.02502 .59674 L
.02479 .59615 L
.02458 .59553 L
.02399 .59281 L
.02381 .58966 L
.02404 .58608 L
.02471 .58206 L
.02738 .57268 L
.03192 .56147 L
.07069 .49724 L
.13606 .42017 L
.21637 .3498 L
.30768 .28614 L
.40606 .22917 L
.50759 .17891 L
.60833 .13535 L
.70436 .09849 L
Mistroke
.79174 .06833 L
.86654 .04487 L
.92484 .02812 L
.9627 .01807 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.43.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.43.1"]
}, Open  ]],

Cell[TextData[{
 "The rendering of the splines uses an adaptive algorithm, similar to that of \
the ",
 StyleBox["Plot", "MR"],
 " function. The initial number of samples taken along the spline is \
determined by ",
 StyleBox["SplinePoints", "MR"],
 ". If the bend between two adjacent segments is greater than ",
 StyleBox["MaxBend", "MR"],
 ", additional samples are taken. This process continues up to at most a \
resolution determined by ",
 StyleBox["SplineDivision", "MR"],
 ". If ",
 StyleBox["SplineDivision", "MR"],
 " is ",
 StyleBox["None", "MR"],
 ", then adaptive methods will not be used; samples will only be taken where \
determined by ",
 StyleBox["SplinePoints", "MR"],
 ". This will be useful on occasion, as the adaptive method is relatively \
slow. "
}], "Text",
 CellTags->{"S5.43.1", "1.9"}],

Cell[TextData[{
 "When rendering a spline in the usual fashion, a ",
 StyleBox["Line", "MR"],
 " graphics primitive is generated behind the scenes. It may be useful to \
incorporate the points of this primitive into other ",
 StyleBox["Line", "MR"],
 " and ",
 StyleBox["Polygon", "MR"],
 " primitives. In particular, you can create a polygon with a spline along \
one or more sides. "
}], "Text",
 CellTags->{"S5.43.1", "1.10"}],

Cell["This represents a Bezier curve.", "MathCaption",
 CellTags->{"S5.43.1", "1.11"}],

Cell["\<\
bcurve =
  Spline[
    {{1,0},{1.5,0},{1.5,0.5},
    {2,1.5},{0.7,1.6},{0,1.5},{0,1}},
  Bezier];\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.43.1"],

Cell["Here is a polygon with a spline incorporated into one side.", \
"MathCaption",
 CellTags->{"S5.43.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
Show[
  Graphics[
    Polygon[
      {{0,1},{0,0},{1,0},bcurve}]
  ]]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.43.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.646449 0.0147151 0.420204 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.02381 .43492 m
.02381 .01472 L
.67026 .01472 L
.67026 .01472 L
.70867 .01608 L
.74349 .02016 L
.77523 .0269 L
.79006 .03124 L
.80426 .03621 L
.83088 .04798 L
.85527 .06206 L
.87755 .0783 L
.89775 .09653 L
.91588 .11653 L
.93187 .13812 L
.95702 .18517 L
.9722 .2359 L
.97619 .28851 L
.96786 .34124 L
.95878 .36712 L
.94631 .39241 L
.93041 .41693 L
.91107 .44051 L
.8883 .46297 L
.86217 .48416 L
.83279 .50396 L
.80029 .52223 L
.72673 .55376 L
.64349 .57805 L
.55321 .59459 L
.4591 .60305 L
.36487 .60332 L
.27457 .59538 L
.23222 .58835 L
.19245 .57931 L
.15577 .56826 L
.13875 .56199 L
.12269 .55522 L
.09369 .5402 L
.08087 .53194 L
.06923 .52319 L
.04969 .50419 L
.04189 .49394 L
.03544 .48317 L
.02674 .4601 L
.02381 .43492 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.43.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.43.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.43.1"->{
    Cell[1776, 53, 131, 6, 36, "Subsection",
      CellTags->{"S5.43.1", "1.1"}],
    Cell[1910, 61, 2152, 66, 84, "DefinitionBox",
      CellTags->"S5.43.1"],
    Cell[4065, 129, 70, 1, 15, "Caption",
      CellTags->"S5.43.1"],
    Cell[4138, 132, 788, 24, 72, "Text",
      CellTags->{"S5.43.1", "1.2"}],
    Cell[4929, 158, 77, 1, 40, "MathCaption",
      CellTags->{"S5.43.1", "1.3"}],
    Cell[5009, 161, 81, 2, 28, "Input",
      CellTags->"S5.43.1"],
    Cell[5093, 165, 79, 1, 40, "MathCaption",
      CellTags->{"S5.43.1", "1.4"}],
    Cell[5175, 168, 121, 5, 45, "Input",
      CellTags->"S5.43.1"],
    Cell[5299, 175, 306, 8, 56, "MathCaption",
      CellTags->{"S5.43.1", "1.5"}],
    Cell[5630, 187, 169, 7, 79, "Input",
      CellTags->"S5.43.1"],
    Cell[5802, 196, 25459, 407, 186, 1697, 109, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.43.1"],
    Cell[31264, 605, 180, 6, 70, "Output",
      CellTags->"S5.43.1"],
    Cell[31459, 614, 130, 3, 70, "MathCaption",
      CellTags->{"S5.43.1", "1.6"}],
    Cell[31614, 621, 170, 7, 70, "Input",
      CellTags->"S5.43.1"],
    Cell[31787, 630, 1607, 102, 70, 1536, 99, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.43.1"],
    Cell[33397, 734, 180, 6, 70, "Output",
      CellTags->"S5.43.1"],
    Cell[33592, 743, 4351, 127, 70, "DefinitionBox3Col",
      CellTags->"S5.43.1"],
    Cell[37946, 872, 101, 5, 70, "Caption",
      CellTags->"S5.43.1"],
    Cell[38050, 879, 492, 11, 70, "Text",
      CellTags->{"S5.43.1", "1.7"}],
    Cell[38545, 892, 101, 1, 70, "MathCaption",
      CellTags->{"S5.43.1", "1.8"}],
    Cell[38671, 897, 141, 5, 70, "Input",
      CellTags->"S5.43.1"],
    Cell[38815, 904, 1690, 106, 70, 1619, 103, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.43.1"],
    Cell[40508, 1012, 180, 6, 70, "Output",
      CellTags->"S5.43.1"],
    Cell[40703, 1021, 814, 22, 70, "Text",
      CellTags->{"S5.43.1", "1.9"}],
    Cell[41520, 1045, 429, 11, 70, "Text",
      CellTags->{"S5.43.1", "1.10"}],
    Cell[41952, 1058, 86, 1, 70, "MathCaption",
      CellTags->{"S5.43.1", "1.11"}],
    Cell[42041, 1061, 168, 8, 70, "Input",
      CellTags->"S5.43.1"],
    Cell[42212, 1071, 116, 2, 70, "MathCaption",
      CellTags->{"S5.43.1", "1.12"}],
    Cell[42353, 1077, 140, 8, 70, "Input",
      CellTags->"S5.43.1"],
    Cell[42496, 1087, 1403, 87, 70, 1332, 84, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.43.1"],
    Cell[43902, 1176, 180, 6, 70, "Output",
      CellTags->"S5.43.1"]},
  "1.1"->{
    Cell[1776, 53, 131, 6, 36, "Subsection",
      CellTags->{"S5.43.1", "1.1"}]},
  "1.2"->{
    Cell[4138, 132, 788, 24, 72, "Text",
      CellTags->{"S5.43.1", "1.2"}]},
  "1.3"->{
    Cell[4929, 158, 77, 1, 40, "MathCaption",
      CellTags->{"S5.43.1", "1.3"}]},
  "1.4"->{
    Cell[5093, 165, 79, 1, 40, "MathCaption",
      CellTags->{"S5.43.1", "1.4"}]},
  "1.5"->{
    Cell[5299, 175, 306, 8, 56, "MathCaption",
      CellTags->{"S5.43.1", "1.5"}]},
  "1.6"->{
    Cell[31459, 614, 130, 3, 70, "MathCaption",
      CellTags->{"S5.43.1", "1.6"}]},
  "1.7"->{
    Cell[38050, 879, 492, 11, 70, "Text",
      CellTags->{"S5.43.1", "1.7"}]},
  "1.8"->{
    Cell[38545, 892, 101, 1, 70, "MathCaption",
      CellTags->{"S5.43.1", "1.8"}]},
  "1.9"->{
    Cell[40703, 1021, 814, 22, 70, "Text",
      CellTags->{"S5.43.1", "1.9"}]},
  "1.10"->{
    Cell[41520, 1045, 429, 11, 70, "Text",
      CellTags->{"S5.43.1", "1.10"}]},
  "1.11"->{
    Cell[41952, 1058, 86, 1, 70, "MathCaption",
      CellTags->{"S5.43.1", "1.11"}]},
  "1.12"->{
    Cell[42212, 1071, 116, 2, 70, "MathCaption",
      CellTags->{"S5.43.1", "1.12"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.43.1", 44733, 1202},
  {"1.1", 47394, 1272},
  {"1.2", 47488, 1275},
  {"1.3", 47578, 1278},
  {"1.4", 47673, 1281},
  {"1.5", 47768, 1284},
  {"1.6", 47864, 1287},
  {"1.7", 47961, 1290},
  {"1.8", 48052, 1293},
  {"1.9", 48149, 1296},
  {"1.10", 48242, 1299},
  {"1.11", 48336, 1302},
  {"1.12", 48435, 1305}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 131, 6, 36, "Subsection",
  CellTags->{"S5.43.1", "1.1"}],
Cell[1910, 61, 2152, 66, 84, "DefinitionBox",
  CellTags->"S5.43.1"],
Cell[4065, 129, 70, 1, 15, "Caption",
  CellTags->"S5.43.1"],
Cell[4138, 132, 788, 24, 72, "Text",
  CellTags->{"S5.43.1", "1.2"}],
Cell[4929, 158, 77, 1, 40, "MathCaption",
  CellTags->{"S5.43.1", "1.3"}],
Cell[5009, 161, 81, 2, 28, "Input",
  CellTags->"S5.43.1"],
Cell[5093, 165, 79, 1, 40, "MathCaption",
  CellTags->{"S5.43.1", "1.4"}],
Cell[5175, 168, 121, 5, 45, "Input",
  CellTags->"S5.43.1"],
Cell[5299, 175, 306, 8, 56, "MathCaption",
  CellTags->{"S5.43.1", "1.5"}],

Cell[CellGroupData[{
Cell[5630, 187, 169, 7, 79, "Input",
  CellTags->"S5.43.1"],
Cell[5802, 196, 25459, 407, 186, 1697, 109, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S5.43.1"],
Cell[31264, 605, 180, 6, 70, "Output",
  CellTags->"S5.43.1"]
}, Open  ]],
Cell[31459, 614, 130, 3, 70, "MathCaption",
  CellTags->{"S5.43.1", "1.6"}],

Cell[CellGroupData[{
Cell[31614, 621, 170, 7, 70, "Input",
  CellTags->"S5.43.1"],
Cell[31787, 630, 1607, 102, 70, 1536, 99, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.43.1"],
Cell[33397, 734, 180, 6, 70, "Output",
  CellTags->"S5.43.1"]
}, Open  ]],
Cell[33592, 743, 4351, 127, 70, "DefinitionBox3Col",
  CellTags->"S5.43.1"],
Cell[37946, 872, 101, 5, 70, "Caption",
  CellTags->"S5.43.1"],
Cell[38050, 879, 492, 11, 70, "Text",
  CellTags->{"S5.43.1", "1.7"}],
Cell[38545, 892, 101, 1, 70, "MathCaption",
  CellTags->{"S5.43.1", "1.8"}],

Cell[CellGroupData[{
Cell[38671, 897, 141, 5, 70, "Input",
  CellTags->"S5.43.1"],
Cell[38815, 904, 1690, 106, 70, 1619, 103, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.43.1"],
Cell[40508, 1012, 180, 6, 70, "Output",
  CellTags->"S5.43.1"]
}, Open  ]],
Cell[40703, 1021, 814, 22, 70, "Text",
  CellTags->{"S5.43.1", "1.9"}],
Cell[41520, 1045, 429, 11, 70, "Text",
  CellTags->{"S5.43.1", "1.10"}],
Cell[41952, 1058, 86, 1, 70, "MathCaption",
  CellTags->{"S5.43.1", "1.11"}],
Cell[42041, 1061, 168, 8, 70, "Input",
  CellTags->"S5.43.1"],
Cell[42212, 1071, 116, 2, 70, "MathCaption",
  CellTags->{"S5.43.1", "1.12"}],

Cell[CellGroupData[{
Cell[42353, 1077, 140, 8, 70, "Input",
  CellTags->"S5.43.1"],
Cell[42496, 1087, 1403, 87, 70, 1332, 84, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.43.1"],
Cell[43902, 1176, 180, 6, 70, "Output",
  CellTags->"S5.43.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

