(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16290,        727]*)
(*NotebookOutlinePosition[     20728,        864]*)
(*  CellTagsIndexPosition[     20352,        845]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "SplineFit",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.93.1", "1.1"}],

Cell[TextData[{
 "Most methods of fitting curves to data assume that the fit is \
one\[Hyphen]to\[Hyphen]one; that is, for each value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", there is only one value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". For some data, you may want to find a general curve in the plane. This is \
in general a difficult problem, so the approach of making piecewise fits is \
useful. These are generally referred to as splines. Note that not all splines \
interpolate points; some splines use a subset of the points to control the \
shape of the curve, as in specifying a convex hull using Bezier splines. "
}], "Text",
 CellTags->{"S5.93.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SplineFit[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["points", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["generate a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["SplineFunction", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object of the specified type",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.93.1"],

Cell["Generating a spline. ", "Caption",
 CellTags->"S5.93.1"],

Cell[TextData[{
 "The ",
 StyleBox["SplineFit", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " routine currently supports three types of splines: ",
 StyleBox["Cubic", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", ",
 StyleBox["Bezier", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ", and ",
 StyleBox["CompositeBezier", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". A cubic spline as currently implemented is made of piecewise third\
\[Hyphen]order polynomials, with ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["C",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " continuity, where the second derivative of each polynomial is zero at the \
endpoints. This curve interpolates each of the points it is created from. "
}], "Text",
 CellTags->{"S5.93.1", "1.3"}],

Cell["\<\
A Bezier spline, on the other hand, interpolates only the endpoints; the \
other points control the spline, forming a convex hull. \
\>", "Text",
 CellTags->{"S5.93.1", "1.4"}],

Cell[TextData[{
 "Finally, a composite Bezier spline is made up of a series of \
third\[Hyphen]order Bezier curves with ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["C",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " continuity. It alternates interpolating points and control points. "
}], "Text",
 CellTags->{"S5.93.1", "1.5"}],

Cell[TextData[{
 StyleBox["SplineFit", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " returns a ",
 StyleBox["SplineFunction", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " object that represents the piecewise spline. It is a parametric function \
of one argument, representing a spline curve in the plane. Giving it one \
numeric argument within the range of the parameterization will evaluate to \
the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["x",
      "TI"], ",", 
     StyleBox["y",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " pair at that point. "
}], "Text",
 CellTags->{"S5.93.1", "1.6"}],

Cell["This loads the package.", "MathCaption",
 CellTags->{"S5.93.1", "1.7"}],

Cell["<<NumericalMath`SplineFit`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.93.1"],

Cell["Here is a list of points.", "MathCaption",
 CellTags->{"S5.93.1", "1.8"}],

Cell["pts = {{0,0},{1,2},{-1,3},{0,1},{3,0}};", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.93.1"],

Cell[TextData[{
 "This generates a cubic spline from ",
 StyleBox["pts", "MR"],
 "."
}], "MathCaption",
 CellTags->{"S5.93.1", "1.9"}],

Cell[CellGroupData[{

Cell["spline = SplineFit[pts, Cubic]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.93.1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SplineFunction[\"\>", "\[InvisibleSpace]", "Cubic", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "4.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\", <>]\"\>"}],
  SequenceForm["SplineFunction[", Cubic, ", ", {0, 4}, ", <>]"],
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.93.1"]
}, Open  ]],

Cell["We can evaluate the function at any point on the curve.", "MathCaption",
 CellTags->{"S5.93.1", "1.10"}],

Cell[CellGroupData[{

Cell["spline[1.4]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.93.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.26514285714285735`", ",", "2.7017142857142855`"}], 
  "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.93.1"]
}, Open  ]],

Cell["Here is a graph of the curve.", "MathCaption",
 CellTags->{"S5.93.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
ParametricPlot[spline[u], {u, 0, 4},
 PlotRange -> All, Compiled -> False]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.93.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.282659 0.231177 0.0147151 0.192509 [
[.05148 .00222 -6 -9 ]
[.05148 .00222 6 0 ]
[.51384 .00222 -3 -9 ]
[.51384 .00222 3 0 ]
[.74501 .00222 -3 -9 ]
[.74501 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.27016 .11097 -18 -4.5 ]
[.27016 .11097 0 4.5 ]
[.27016 .20722 -6 -4.5 ]
[.27016 .20722 0 4.5 ]
[.27016 .30348 -18 -4.5 ]
[.27016 .30348 0 4.5 ]
[.27016 .39973 -6 -4.5 ]
[.27016 .39973 0 4.5 ]
[.27016 .49599 -18 -4.5 ]
[.27016 .49599 0 4.5 ]
[.27016 .59224 -6 -4.5 ]
[.27016 .59224 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05148 .01472 m
.05148 .02097 L
s
[(-1)] .05148 .00222 0 1 Mshowa
.51384 .01472 m
.51384 .02097 L
s
[(1)] .51384 .00222 0 1 Mshowa
.74501 .01472 m
.74501 .02097 L
s
[(2)] .74501 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(3)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.09772 .01472 m
.09772 .01847 L
s
.14395 .01472 m
.14395 .01847 L
s
.19019 .01472 m
.19019 .01847 L
s
.23642 .01472 m
.23642 .01847 L
s
.32889 .01472 m
.32889 .01847 L
s
.37513 .01472 m
.37513 .01847 L
s
.42137 .01472 m
.42137 .01847 L
s
.4676 .01472 m
.4676 .01847 L
s
.56007 .01472 m
.56007 .01847 L
s
.60631 .01472 m
.60631 .01847 L
s
.65254 .01472 m
.65254 .01847 L
s
.69878 .01472 m
.69878 .01847 L
s
.79125 .01472 m
.79125 .01847 L
s
.83748 .01472 m
.83748 .01847 L
s
.88372 .01472 m
.88372 .01847 L
s
.92996 .01472 m
.92996 .01847 L
s
.00525 .01472 m
.00525 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.28266 .11097 m
.28891 .11097 L
s
[(0.5)] .27016 .11097 1 0 Mshowa
.28266 .20722 m
.28891 .20722 L
s
[(1)] .27016 .20722 1 0 Mshowa
.28266 .30348 m
.28891 .30348 L
s
[(1.5)] .27016 .30348 1 0 Mshowa
.28266 .39973 m
.28891 .39973 L
s
[(2)] .27016 .39973 1 0 Mshowa
.28266 .49599 m
.28891 .49599 L
s
[(2.5)] .27016 .49599 1 0 Mshowa
.28266 .59224 m
.28891 .59224 L
s
[(3)] .27016 .59224 1 0 Mshowa
.125 Mabswid
.28266 .03397 m
.28641 .03397 L
s
.28266 .05322 m
.28641 .05322 L
s
.28266 .07247 m
.28641 .07247 L
s
.28266 .09172 m
.28641 .09172 L
s
.28266 .13022 m
.28641 .13022 L
s
.28266 .14947 m
.28641 .14947 L
s
.28266 .16872 m
.28641 .16872 L
s
.28266 .18797 m
.28641 .18797 L
s
.28266 .22647 m
.28641 .22647 L
s
.28266 .24573 m
.28641 .24573 L
s
.28266 .26498 m
.28641 .26498 L
s
.28266 .28423 m
.28641 .28423 L
s
.28266 .32273 m
.28641 .32273 L
s
.28266 .34198 m
.28641 .34198 L
s
.28266 .36123 m
.28641 .36123 L
s
.28266 .38048 m
.28641 .38048 L
s
.28266 .41898 m
.28641 .41898 L
s
.28266 .43823 m
.28641 .43823 L
s
.28266 .45749 m
.28641 .45749 L
s
.28266 .47674 m
.28641 .47674 L
s
.28266 .51524 m
.28641 .51524 L
s
.28266 .53449 m
.28641 .53449 L
s
.28266 .55374 m
.28641 .55374 L
s
.28266 .57299 m
.28641 .57299 L
s
.28266 .61149 m
.28641 .61149 L
s
.25 Mabswid
.28266 0 m
.28266 .61803 L
s
.5 Mabswid
.28266 .01472 m
.35604 .07828 L
.42924 .14739 L
.46007 .18085 L
.48495 .2119 L
.50585 .2436 L
.52065 .27341 L
.52632 .28912 L
.5288 .29797 L
.53062 .30612 L
.53179 .31297 L
.5323 .31686 L
.53268 .3205 L
.53284 .32246 L
.53297 .32433 L
.53306 .32602 L
.53314 .32783 L
.53319 .32978 L
.53321 .33159 L
.53322 .3327 L
.53321 .33374 L
.53317 .33569 L
.53311 .33754 L
.53301 .33951 L
.53289 .34137 L
.53276 .34307 L
.53234 .34722 L
.5318 .35115 L
.53035 .35895 L
.52818 .36742 L
.52272 .38249 L
.5158 .39637 L
.50618 .41136 L
.49525 .42533 L
.46421 .4565 L
.38808 .51074 L
.34254 .53552 L
.29237 .55837 L
.24442 .57633 L
.2018 .58909 L
.18045 .59422 L
.15813 .59856 L
.14631 .60037 L
.13572 .60167 L
.12591 .60257 L
.12109 .60289 L
.11838 .60303 L
.11588 .60314 L
.11362 .60322 L
.11124 .60328 L
Mistroke
.10989 .6033 L
.10862 .60331 L
.10628 .60332 L
.10406 .6033 L
.10204 .60327 L
.09984 .6032 L
.09755 .60311 L
.09565 .60302 L
.09364 .60289 L
.09008 .60262 L
.08594 .60219 L
.08227 .60172 L
.07447 .60036 L
.07029 .59941 L
.06658 .5984 L
.06014 .59624 L
.05388 .5935 L
.04855 .5905 L
.04416 .58739 L
.03992 .58367 L
.03588 .57918 L
.03302 .57518 L
.03041 .57061 L
.02814 .56546 L
.02646 .56037 L
.02569 .55732 L
.02501 .55399 L
.02456 .55108 L
.02418 .5478 L
.02403 .54592 L
.02392 .54418 L
.02388 .54321 L
.02384 .54214 L
.02382 .54113 L
.02381 .54019 L
.02381 .5385 L
.02383 .53753 L
.02385 .53662 L
.02388 .53565 L
.02392 .53476 L
.02404 .53273 L
.02416 .53106 L
.02432 .52926 L
.02468 .52597 L
.02585 .51829 L
.02761 .50991 L
.02966 .50204 L
.04159 .46958 L
.06124 .43165 L
.11793 .35269 L
Mistroke
.19151 .27722 L
.27592 .21167 L
.3767 .15507 L
.48219 .11287 L
.60165 .07855 L
.72209 .05323 L
.84127 .0337 L
.96994 .01557 L
.97619 .01472 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.93.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.93.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SplineFunction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["range", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["internal", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["spline function object of type ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["type", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" defined over the parameter range ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["range", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.93.1"],

Cell[TextData[{
 "Object returned by ",
 StyleBox["SplineFit", "MR"],
 ". "
}], "Caption",
 CellTags->"S5.93.1"],

Cell[TextData[{
 "Note that the spline function object returned by ",
 StyleBox["SplineFit", "MR"],
 " indicates the type of the spline, and the valid range of the parameter to \
which the function can be applied. The various internal arguments differ for \
each type of spline, and are hidden in the standard output format. In the \
cubic spline, for instance, these internal arguments cache the coefficients \
of the polynomials that make up the spline. "
}], "Text",
 CellTags->{"S5.93.1", "1.12"}],

Cell[TextData[{
 "Here is the internal form of the cubic spline function generated from ",
 StyleBox["pts", "MR"],
 "."
}], "MathCaption",
 CellTags->{"S5.93.1", "1.13"}],

Cell[CellGroupData[{

Cell["InputForm[spline]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.93.1"],

Cell["\<\
SplineFunction[Cubic, {0., 4.},   {{0, 0}, {1, 2}, {-1, 3}, {0, 1}, {3, 0}},  \
 {{{0, 111/56, 0, -55/56}, {0, 57/28, 0, -1/28}},    {{1, -27/28, -165/56, \
107/56},     {2, 27/14, -3/28, -23/28}},    {{-1, -9/8, 39/14, -37/56}, {3, \
-3/4, -18/7,      37/28}}, {{0, 69/28, 45/56, -15/56},     {1, -27/14, 39/28, \
-13/28}}}]\
\>", "Output",
 CellLabel->"Out[6]//InputForm= ",
 CellTags->"S5.93.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.93.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.93.1", "1.1"}],
    Cell[1918, 61, 878, 20, 88, "Text",
      CellTags->{"S5.93.1", "1.2"}],
    Cell[2799, 83, 1271, 40, 46, "DefinitionBox",
      CellTags->"S5.93.1"],
    Cell[4073, 125, 62, 1, 15, "Caption",
      CellTags->"S5.93.1"],
    Cell[4138, 128, 915, 28, 72, "Text",
      CellTags->{"S5.93.1", "1.3"}],
    Cell[5056, 158, 186, 4, 40, "Text",
      CellTags->{"S5.93.1", "1.4"}],
    Cell[5245, 164, 400, 11, 40, "Text",
      CellTags->{"S5.93.1", "1.5"}],
    Cell[5648, 177, 732, 23, 56, "Text",
      CellTags->{"S5.93.1", "1.6"}],
    Cell[6383, 202, 77, 1, 40, "MathCaption",
      CellTags->{"S5.93.1", "1.7"}],
    Cell[6463, 205, 89, 2, 28, "Input",
      CellTags->"S5.93.1"],
    Cell[6555, 209, 79, 1, 40, "MathCaption",
      CellTags->{"S5.93.1", "1.8"}],
    Cell[6637, 212, 102, 2, 28, "Input",
      CellTags->"S5.93.1"],
    Cell[6742, 216, 134, 5, 40, "MathCaption",
      CellTags->{"S5.93.1", "1.9"}],
    Cell[6901, 225, 93, 2, 28, "Input",
      CellTags->"S5.93.1"],
    Cell[6997, 229, 404, 10, 25, "Output",
      CellTags->"S5.93.1"],
    Cell[7416, 242, 110, 1, 70, "MathCaption",
      CellTags->{"S5.93.1", "1.10"}],
    Cell[7551, 247, 74, 2, 70, "Input",
      CellTags->"S5.93.1"],
    Cell[7628, 251, 159, 5, 70, "Output",
      CellTags->"S5.93.1"],
    Cell[7802, 259, 84, 1, 70, "MathCaption",
      CellTags->{"S5.93.1", "1.11"}],
    Cell[7911, 264, 145, 5, 70, "Input",
      CellTags->"S5.93.1"],
    Cell[8059, 271, 5113, 351, 70, 5042, 348, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.93.1"],
    Cell[13175, 624, 180, 6, 70, "Output",
      CellTags->"S5.93.1"],
    Cell[13370, 633, 1584, 49, 70, "DefinitionBox",
      CellTags->"S5.93.1"],
    Cell[14957, 684, 112, 5, 70, "Caption",
      CellTags->"S5.93.1"],
    Cell[15072, 691, 501, 9, 70, "Text",
      CellTags->{"S5.93.1", "1.12"}],
    Cell[15576, 702, 170, 5, 70, "MathCaption",
      CellTags->{"S5.93.1", "1.13"}],
    Cell[15771, 711, 80, 2, 70, "Input",
      CellTags->"S5.93.1"],
    Cell[15854, 715, 408, 8, 70, "Output",
      CellTags->"S5.93.1"]},
  "1.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.93.1", "1.1"}]},
  "1.2"->{
    Cell[1918, 61, 878, 20, 88, "Text",
      CellTags->{"S5.93.1", "1.2"}]},
  "1.3"->{
    Cell[4138, 128, 915, 28, 72, "Text",
      CellTags->{"S5.93.1", "1.3"}]},
  "1.4"->{
    Cell[5056, 158, 186, 4, 40, "Text",
      CellTags->{"S5.93.1", "1.4"}]},
  "1.5"->{
    Cell[5245, 164, 400, 11, 40, "Text",
      CellTags->{"S5.93.1", "1.5"}]},
  "1.6"->{
    Cell[5648, 177, 732, 23, 56, "Text",
      CellTags->{"S5.93.1", "1.6"}]},
  "1.7"->{
    Cell[6383, 202, 77, 1, 40, "MathCaption",
      CellTags->{"S5.93.1", "1.7"}]},
  "1.8"->{
    Cell[6555, 209, 79, 1, 40, "MathCaption",
      CellTags->{"S5.93.1", "1.8"}]},
  "1.9"->{
    Cell[6742, 216, 134, 5, 40, "MathCaption",
      CellTags->{"S5.93.1", "1.9"}]},
  "1.10"->{
    Cell[7416, 242, 110, 1, 70, "MathCaption",
      CellTags->{"S5.93.1", "1.10"}]},
  "1.11"->{
    Cell[7802, 259, 84, 1, 70, "MathCaption",
      CellTags->{"S5.93.1", "1.11"}]},
  "1.12"->{
    Cell[15072, 691, 501, 9, 70, "Text",
      CellTags->{"S5.93.1", "1.12"}]},
  "1.13"->{
    Cell[15576, 702, 170, 5, 70, "MathCaption",
      CellTags->{"S5.93.1", "1.13"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.93.1", 16913, 743},
  {"1.1", 19124, 802},
  {"1.2", 19218, 805},
  {"1.3", 19307, 808},
  {"1.4", 19397, 811},
  {"1.5", 19486, 814},
  {"1.6", 19576, 817},
  {"1.7", 19666, 820},
  {"1.8", 19761, 823},
  {"1.9", 19856, 826},
  {"1.10", 19953, 829},
  {"1.11", 20051, 832},
  {"1.12", 20148, 835},
  {"1.13", 20240, 838}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 139, 6, 36, "Subsection",
  CellTags->{"S5.93.1", "1.1"}],
Cell[1918, 61, 878, 20, 88, "Text",
  CellTags->{"S5.93.1", "1.2"}],
Cell[2799, 83, 1271, 40, 46, "DefinitionBox",
  CellTags->"S5.93.1"],
Cell[4073, 125, 62, 1, 15, "Caption",
  CellTags->"S5.93.1"],
Cell[4138, 128, 915, 28, 72, "Text",
  CellTags->{"S5.93.1", "1.3"}],
Cell[5056, 158, 186, 4, 40, "Text",
  CellTags->{"S5.93.1", "1.4"}],
Cell[5245, 164, 400, 11, 40, "Text",
  CellTags->{"S5.93.1", "1.5"}],
Cell[5648, 177, 732, 23, 56, "Text",
  CellTags->{"S5.93.1", "1.6"}],
Cell[6383, 202, 77, 1, 40, "MathCaption",
  CellTags->{"S5.93.1", "1.7"}],
Cell[6463, 205, 89, 2, 28, "Input",
  CellTags->"S5.93.1"],
Cell[6555, 209, 79, 1, 40, "MathCaption",
  CellTags->{"S5.93.1", "1.8"}],
Cell[6637, 212, 102, 2, 28, "Input",
  CellTags->"S5.93.1"],
Cell[6742, 216, 134, 5, 40, "MathCaption",
  CellTags->{"S5.93.1", "1.9"}],

Cell[CellGroupData[{
Cell[6901, 225, 93, 2, 28, "Input",
  CellTags->"S5.93.1"],
Cell[6997, 229, 404, 10, 25, "Output",
  CellTags->"S5.93.1"]
}, Open  ]],
Cell[7416, 242, 110, 1, 70, "MathCaption",
  CellTags->{"S5.93.1", "1.10"}],

Cell[CellGroupData[{
Cell[7551, 247, 74, 2, 70, "Input",
  CellTags->"S5.93.1"],
Cell[7628, 251, 159, 5, 70, "Output",
  CellTags->"S5.93.1"]
}, Open  ]],
Cell[7802, 259, 84, 1, 70, "MathCaption",
  CellTags->{"S5.93.1", "1.11"}],

Cell[CellGroupData[{
Cell[7911, 264, 145, 5, 70, "Input",
  CellTags->"S5.93.1"],
Cell[8059, 271, 5113, 351, 70, 5042, 348, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.93.1"],
Cell[13175, 624, 180, 6, 70, "Output",
  CellTags->"S5.93.1"]
}, Open  ]],
Cell[13370, 633, 1584, 49, 70, "DefinitionBox",
  CellTags->"S5.93.1"],
Cell[14957, 684, 112, 5, 70, "Caption",
  CellTags->"S5.93.1"],
Cell[15072, 691, 501, 9, 70, "Text",
  CellTags->{"S5.93.1", "1.12"}],
Cell[15576, 702, 170, 5, 70, "MathCaption",
  CellTags->{"S5.93.1", "1.13"}],

Cell[CellGroupData[{
Cell[15771, 711, 80, 2, 70, "Input",
  CellTags->"S5.93.1"],
Cell[15854, 715, 408, 8, 70, "Output",
  CellTags->"S5.93.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

