(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27060,       1412]*)
(*NotebookOutlinePosition[     30280,       1511]*)
(*  CellTagsIndexPosition[     30038,       1498]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "StandardAtmosphere",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.61.1", "1.1"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["AtmosphericPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["property", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the specified property on the horizontal axis versus the altitude \
on the vertical axis ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.61.1"],

Cell["Plotting an atmospheric property. ", "Caption",
 CellTags->"S5.61.1"],

Cell["\<\
This package provides support for plotting how U.S. Standard Atmosphere \
properties vary with altitude. \
\>", "Text",
 CellTags->{"S5.61.1", "1.2"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.61.1", "1.3"}],

Cell["<<Miscellaneous`StandardAtmosphere`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.61.1"],

Cell["\<\
The speed of sound does not decrease monotonically with increasing altitude. \
\
\>", "MathCaption",
 CellTags->{"S5.61.1", "1.4"}],

Cell[CellGroupData[{

Cell["AtmosphericPlot[ SoundSpeed ]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.61.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-3.08529 0.0113136 0.0472346 0.00650391 [
[.08253 -0.0125 -9 -9 ]
[.08253 -0.0125 9 0 ]
[.3088 -0.0125 -9 -9 ]
[.3088 -0.0125 9 0 ]
[.53507 -0.0125 -9 -9 ]
[.53507 -0.0125 9 0 ]
[.76134 -0.0125 -9 -9 ]
[.76134 -0.0125 9 0 ]
[.98762 -0.0125 -9 -9 ]
[.98762 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -47 -18.8125 ]
[.5 -0.0125 47 -9 ]
[-0.0125 .04723 -6 -4.5 ]
[-0.0125 .04723 0 4.5 ]
[-0.0125 .17731 -12 -4.5 ]
[-0.0125 .17731 0 4.5 ]
[-0.0125 .30739 -12 -4.5 ]
[-0.0125 .30739 0 4.5 ]
[-0.0125 .43747 -12 -4.5 ]
[-0.0125 .43747 0 4.5 ]
[-0.0125 .56755 -12 -4.5 ]
[-0.0125 .56755 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -22.125 -38 ]
[-0.01875 .30902 -12 38 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08253 0 m
.08253 .00625 L
s
[(280)] .08253 -0.0125 0 1 Mshowa
.3088 0 m
.3088 .00625 L
s
[(300)] .3088 -0.0125 0 1 Mshowa
.53507 0 m
.53507 .00625 L
s
[(320)] .53507 -0.0125 0 1 Mshowa
.76134 0 m
.76134 .00625 L
s
[(340)] .76134 -0.0125 0 1 Mshowa
.98762 0 m
.98762 .00625 L
s
[(360)] .98762 -0.0125 0 1 Mshowa
.125 Mabswid
.1391 0 m
.1391 .00375 L
s
.19566 0 m
.19566 .00375 L
s
.25223 0 m
.25223 .00375 L
s
.36537 0 m
.36537 .00375 L
s
.42194 0 m
.42194 .00375 L
s
.4785 0 m
.4785 .00375 L
s
.59164 0 m
.59164 .00375 L
s
.64821 0 m
.64821 .00375 L
s
.70478 0 m
.70478 .00375 L
s
.81791 0 m
.81791 .00375 L
s
.87448 0 m
.87448 .00375 L
s
.93105 0 m
.93105 .00375 L
s
.02596 0 m
.02596 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -108 -22.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(SoundSpeed) show
123.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
135.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
141.000 11.250 moveto
(\\220) show
147.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(s) show
153.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .04723 m
.00625 .04723 L
s
[(0)] -0.0125 .04723 1 0 Mshowa
0 .17731 m
.00625 .17731 L
s
[(20)] -0.0125 .17731 1 0 Mshowa
0 .30739 m
.00625 .30739 L
s
[(40)] -0.0125 .30739 1 0 Mshowa
0 .43747 m
.00625 .43747 L
s
[(60)] -0.0125 .43747 1 0 Mshowa
0 .56755 m
.00625 .56755 L
s
[(80)] -0.0125 .56755 1 0 Mshowa
.125 Mabswid
0 .07975 m
.00375 .07975 L
s
0 .11227 m
.00375 .11227 L
s
0 .14479 m
.00375 .14479 L
s
0 .20983 m
.00375 .20983 L
s
0 .24235 m
.00375 .24235 L
s
0 .27487 m
.00375 .27487 L
s
0 .33991 m
.00375 .33991 L
s
0 .37243 m
.00375 .37243 L
s
0 .40495 m
.00375 .40495 L
s
0 .46999 m
.00375 .46999 L
s
0 .50251 m
.00375 .50251 L
s
0 .53503 m
.00375 .53503 L
s
0 .01472 m
.00375 .01472 L
s
0 .60007 m
.00375 .60007 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -116.062 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
99 9.0625 translate
90 rotate
-99 -9.0625 translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Altitude) show
111.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
123.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Km) show
135.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.08253 .61178 m
.08253 .61803 L
s
.3088 .61178 m
.3088 .61803 L
s
.53507 .61178 m
.53507 .61803 L
s
.76134 .61178 m
.76134 .61803 L
s
.98762 .61178 m
.98762 .61803 L
s
.125 Mabswid
.1391 .61428 m
.1391 .61803 L
s
.19566 .61428 m
.19566 .61803 L
s
.25223 .61428 m
.25223 .61803 L
s
.36537 .61428 m
.36537 .61803 L
s
.42194 .61428 m
.42194 .61803 L
s
.4785 .61428 m
.4785 .61803 L
s
.59164 .61428 m
.59164 .61803 L
s
.64821 .61428 m
.64821 .61803 L
s
.70478 .61428 m
.70478 .61803 L
s
.81791 .61428 m
.81791 .61803 L
s
.87448 .61428 m
.87448 .61803 L
s
.93105 .61428 m
.93105 .61803 L
s
.02596 .61428 m
.02596 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .04723 m
1 .04723 L
s
.99375 .17731 m
1 .17731 L
s
.99375 .30739 m
1 .30739 L
s
.99375 .43747 m
1 .43747 L
s
.99375 .56755 m
1 .56755 L
s
.125 Mabswid
.99625 .07975 m
1 .07975 L
s
.99625 .11227 m
1 .11227 L
s
.99625 .14479 m
1 .14479 L
s
.99625 .20983 m
1 .20983 L
s
.99625 .24235 m
1 .24235 L
s
.99625 .27487 m
1 .27487 L
s
.99625 .33991 m
1 .33991 L
s
.99625 .37243 m
1 .37243 L
s
.99625 .40495 m
1 .40495 L
s
.99625 .46999 m
1 .46999 L
s
.99625 .50251 m
1 .50251 L
s
.99625 .53503 m
1 .53503 L
s
.99625 .01472 m
1 .01472 L
s
.99625 .60007 m
1 .60007 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
.5 Mabswid
.97619 .01472 m
.95549 .01797 L
.93467 .02122 L
.91385 .02447 L
.89292 .02772 L
.87177 .03097 L
.85061 .03423 L
.82923 .03748 L
.80784 .04073 L
.78635 .04398 L
.76463 .04723 L
.7429 .05049 L
.72096 .05374 L
.69901 .05699 L
.67683 .06024 L
.65454 .06349 L
.63214 .06675 L
.60963 .07 L
.587 .07325 L
.56415 .0765 L
.54129 .07975 L
.5181 .08301 L
.49491 .08626 L
.4716 .08951 L
.44807 .09276 L
.42431 .09601 L
.40055 .09927 L
.37646 .10252 L
.35236 .10577 L
.32803 .10902 L
.30348 .11227 L
.27882 .11553 L
.25393 .11878 L
.25302 .12203 L
.25302 .12528 L
.25302 .12853 L
.25302 .13179 L
.25302 .13504 L
.25302 .13829 L
.25302 .14154 L
.25302 .14479 L
.25302 .1513 L
.25302 .1578 L
.25302 .16431 L
.25302 .17081 L
.25302 .17731 L
.25302 .18382 L
.26784 .19032 L
.27542 .19682 L
.283 .20333 L
Mistroke
.29058 .20983 L
.29816 .21634 L
.30563 .22284 L
.31321 .22934 L
.32068 .23585 L
.32815 .24235 L
.33561 .24886 L
.34297 .25536 L
.36163 .26186 L
.38223 .26837 L
.4027 .27487 L
.42307 .28138 L
.46346 .29438 L
.50328 .30739 L
.54265 .3204 L
.58168 .33341 L
.62015 .34641 L
.64595 .35942 L
.64595 .37243 L
.63475 .38544 L
.59651 .39845 L
.55781 .41145 L
.51878 .42446 L
.4793 .43747 L
.37883 .46999 L
.27554 .50251 L
.18888 .53503 L
.11126 .56755 L
.03184 .60007 L
.02381 .60332 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {261.228, -20.5704, 0.347921, \
0.605211}},
 ImageSoundCache->{{{0, 299}, {179, 0}} -> GraphicsData["MacintoshSound", "\<\
\>"]},
 ImageCacheContents->"SoundAndGraphics",
 CellTags->"S5.61.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.61.1"]
}, Open  ]],

Cell["\<\
The speed of particles does not increase monotonically with increasing \
altitude. \
\>", "MathCaption",
 CellTags->{"S5.61.1", "1.5"}],

Cell[CellGroupData[{

Cell["AtmosphericPlot[ MeanParticleSpeed ]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.61.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.1569 0.000488802 0.0176435 0.000585675 [
[.0875 -0.0125 -9 -9 ]
[.0875 -0.0125 9 0 ]
[.3319 -0.0125 -12 -9 ]
[.3319 -0.0125 12 0 ]
[.5763 -0.0125 -12 -9 ]
[.5763 -0.0125 12 0 ]
[.8207 -0.0125 -12 -9 ]
[.8207 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -68 -19.125 ]
[.5 -0.0125 68 -9 ]
[-0.0125 .01764 -6 -4.5 ]
[-0.0125 .01764 0 4.5 ]
[-0.0125 .13478 -18 -4.5 ]
[-0.0125 .13478 0 4.5 ]
[-0.0125 .25191 -18 -4.5 ]
[-0.0125 .25191 0 4.5 ]
[-0.0125 .36905 -18 -4.5 ]
[-0.0125 .36905 0 4.5 ]
[-0.0125 .48618 -18 -4.5 ]
[-0.0125 .48618 0 4.5 ]
[-0.0125 .60332 -24 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -34.125 -38 ]
[-0.01875 .30902 -24 38 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0875 0 m
.0875 .00625 L
s
[(500)] .0875 -0.0125 0 1 Mshowa
.3319 0 m
.3319 .00625 L
s
[(1000)] .3319 -0.0125 0 1 Mshowa
.5763 0 m
.5763 .00625 L
s
[(1500)] .5763 -0.0125 0 1 Mshowa
.8207 0 m
.8207 .00625 L
s
[(2000)] .8207 -0.0125 0 1 Mshowa
.125 Mabswid
.13638 0 m
.13638 .00375 L
s
.18526 0 m
.18526 .00375 L
s
.23414 0 m
.23414 .00375 L
s
.28302 0 m
.28302 .00375 L
s
.38078 0 m
.38078 .00375 L
s
.42966 0 m
.42966 .00375 L
s
.47854 0 m
.47854 .00375 L
s
.52742 0 m
.52742 .00375 L
s
.62518 0 m
.62518 .00375 L
s
.67406 0 m
.67406 .00375 L
s
.72294 0 m
.72294 .00375 L
s
.77182 0 m
.77182 .00375 L
s
.03862 0 m
.03862 .00375 L
s
.86958 0 m
.86958 .00375 L
s
.91846 0 m
.91846 .00375 L
s
.96734 0 m
.96734 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -129 -23.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(MeanParticleSpeed) show
165.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
177.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
183.000 11.562 moveto
(\\220) show
189.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(s) show
195.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01764 m
.00625 .01764 L
s
[(0)] -0.0125 .01764 1 0 Mshowa
0 .13478 m
.00625 .13478 L
s
[(200)] -0.0125 .13478 1 0 Mshowa
0 .25191 m
.00625 .25191 L
s
[(400)] -0.0125 .25191 1 0 Mshowa
0 .36905 m
.00625 .36905 L
s
[(600)] -0.0125 .36905 1 0 Mshowa
0 .48618 m
.00625 .48618 L
s
[(800)] -0.0125 .48618 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(1000)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04693 m
.00375 .04693 L
s
0 .07621 m
.00375 .07621 L
s
0 .10549 m
.00375 .10549 L
s
0 .16406 m
.00375 .16406 L
s
0 .19335 m
.00375 .19335 L
s
0 .22263 m
.00375 .22263 L
s
0 .2812 m
.00375 .2812 L
s
0 .31048 m
.00375 .31048 L
s
0 .33976 m
.00375 .33976 L
s
0 .39833 m
.00375 .39833 L
s
0 .42762 m
.00375 .42762 L
s
0 .4569 m
.00375 .4569 L
s
0 .51547 m
.00375 .51547 L
s
0 .54475 m
.00375 .54475 L
s
0 .57404 m
.00375 .57404 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -128.062 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
99 9.0625 translate
90 rotate
-99 -9.0625 translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Altitude) show
111.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
123.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Km) show
135.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.0875 .61178 m
.0875 .61803 L
s
.3319 .61178 m
.3319 .61803 L
s
.5763 .61178 m
.5763 .61803 L
s
.8207 .61178 m
.8207 .61803 L
s
.125 Mabswid
.13638 .61428 m
.13638 .61803 L
s
.18526 .61428 m
.18526 .61803 L
s
.23414 .61428 m
.23414 .61803 L
s
.28302 .61428 m
.28302 .61803 L
s
.38078 .61428 m
.38078 .61803 L
s
.42966 .61428 m
.42966 .61803 L
s
.47854 .61428 m
.47854 .61803 L
s
.52742 .61428 m
.52742 .61803 L
s
.62518 .61428 m
.62518 .61803 L
s
.67406 .61428 m
.67406 .61803 L
s
.72294 .61428 m
.72294 .61803 L
s
.77182 .61428 m
.77182 .61803 L
s
.03862 .61428 m
.03862 .61803 L
s
.86958 .61428 m
.86958 .61803 L
s
.91846 .61428 m
.91846 .61803 L
s
.96734 .61428 m
.96734 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01764 m
1 .01764 L
s
.99375 .13478 m
1 .13478 L
s
.99375 .25191 m
1 .25191 L
s
.99375 .36905 m
1 .36905 L
s
.99375 .48618 m
1 .48618 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .04693 m
1 .04693 L
s
.99625 .07621 m
1 .07621 L
s
.99625 .10549 m
1 .10549 L
s
.99625 .16406 m
1 .16406 L
s
.99625 .19335 m
1 .19335 L
s
.99625 .22263 m
1 .22263 L
s
.99625 .2812 m
1 .2812 L
s
.99625 .31048 m
1 .31048 L
s
.99625 .33976 m
1 .33976 L
s
.99625 .39833 m
1 .39833 L
s
.99625 .42762 m
1 .42762 L
s
.99625 .4569 m
1 .4569 L
s
.99625 .51547 m
1 .51547 L
s
.99625 .54475 m
1 .54475 L
s
.99625 .57404 m
1 .57404 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
.5 Mabswid
.07975 .01472 m
.07855 .01501 L
.07734 .0153 L
.07613 .01559 L
.0749 .01589 L
.07367 .01618 L
.07268 .01647 L
.0712 .01676 L
.06995 .01706 L
.0687 .01735 L
.06743 .01764 L
.06616 .01794 L
.06489 .01823 L
.06361 .01852 L
.06232 .01881 L
.06102 .01911 L
.05971 .0194 L
.0584 .01969 L
.05708 .01999 L
.05575 .02028 L
.05441 .02057 L
.05307 .02086 L
.05172 .02116 L
.05035 .02145 L
.04898 .02174 L
.0476 .02204 L
.04621 .02233 L
.04481 .02262 L
.04341 .02291 L
.04199 .02321 L
.04056 .0235 L
.03912 .02379 L
.03768 .02409 L
.03762 .02438 L
.03762 .02467 L
.03762 .02496 L
.03762 .02526 L
.03762 .02555 L
.03762 .02584 L
.03762 .02614 L
.03762 .02643 L
.03762 .02701 L
.03762 .0276 L
.03762 .02819 L
.03762 .02877 L
.03762 .02936 L
.03804 .02994 L
.03848 .03053 L
.03892 .03111 L
.03937 .0317 L
Mistroke
.03981 .03229 L
.04025 .03287 L
.04069 .03346 L
.04112 .03404 L
.04156 .03463 L
.042 .03521 L
.04243 .0358 L
.04286 .03639 L
.04395 .03697 L
.04515 .03756 L
.04634 .03814 L
.04753 .03873 L
.04988 .0399 L
.0522 .04107 L
.0545 .04224 L
.05677 .04341 L
.05901 .04458 L
.06051 .04576 L
.06051 .04693 L
.05986 .0481 L
.05763 .04927 L
.05538 .05044 L
.0531 .05161 L
.05081 .05278 L
.04495 .05571 L
.03893 .05864 L
.03388 .06157 L
.02936 .0645 L
.02473 .06743 L
.02426 .06772 L
.02381 .06801 L
.02391 .07035 L
.02523 .07328 L
.02953 .07621 L
.05412 .08207 L
.10671 .08792 L
.1486 .09378 L
.1813 .09964 L
.20799 .10549 L
.23033 .11135 L
.24944 .11721 L
.26606 .12307 L
.28063 .12892 L
.29358 .13478 L
.30455 .14064 L
.31553 .14649 L
.33347 .15821 L
.34828 .16992 L
.36059 .18163 L
.37086 .19335 L
Mistroke
.37951 .20506 L
.38684 .21677 L
.39325 .22849 L
.39906 .2402 L
.40449 .25191 L
.41861 .2812 L
.43699 .31048 L
.46461 .33976 L
.50611 .36905 L
.56457 .39833 L
.63838 .42762 L
.71996 .4569 L
.79836 .48618 L
.8645 .51547 L
.91485 .54475 L
.95092 .57404 L
.97619 .60332 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.61.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.61.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["CollisionFrequency",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DynamicViscosity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GravityAcceleration",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["KinematicViscosity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["KineticTemperature",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MeanDensity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MeanFreePath",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MeanMolecularWeight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MeanParticleSpeed",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NumberDensity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Pressure",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PressureScaleHeight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SoundSpeed",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "ThermalConductivityCoefficient",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.61.1"],

Cell["Atmospheric properties.", "Caption",
 CellTags->"S5.61.1"],

Cell[TextData[{
 "You can also treat the various atmospheric properties as functions of \
altitude. These functions understand the units defined in ",
 StyleBox["Miscellaneous`Units`", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.61.1", "1.6"}],

Cell["This gives the mean particle speed at 5 kilometers. ", "MathCaption",
 CellTags->{"S5.61.1", "1.7"}],

Cell[CellGroupData[{

Cell["MeanParticleSpeed[5000 Meter]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.61.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"432.31`", " ", "Meter"}], "Second"]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.61.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.61.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.61.1", "1.1"}],
    Cell[1927, 61, 936, 28, 64, "DefinitionBox",
      CellTags->"S5.61.1"],
    Cell[2866, 91, 75, 1, 15, "Caption",
      CellTags->"S5.61.1"],
    Cell[2944, 94, 160, 4, 40, "Text",
      CellTags->{"S5.61.1", "1.2"}],
    Cell[3107, 100, 78, 1, 40, "MathCaption",
      CellTags->{"S5.61.1", "1.3"}],
    Cell[3188, 103, 98, 2, 28, "Input",
      CellTags->"S5.61.1"],
    Cell[3289, 107, 141, 4, 40, "MathCaption",
      CellTags->{"S5.61.1", "1.4"}],
    Cell[3455, 115, 92, 2, 28, "Input",
      CellTags->"S5.61.1"],
    Cell[3550, 119, 9411, 551, 186, 9126, 543, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.61.1"],
    Cell[12964, 672, 180, 6, 25, "Output",
      CellTags->"S5.61.1"],
    Cell[13159, 681, 145, 4, 40, "MathCaption",
      CellTags->{"S5.61.1", "1.5"}],
    Cell[13329, 689, 99, 2, 28, "Input",
      CellTags->"S5.61.1"],
    Cell[13431, 693, 10035, 608, 186, 9964, 605, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.61.1"],
    Cell[23469, 1303, 180, 6, 70, "Output",
      CellTags->"S5.61.1"],
    Cell[23664, 1312, 2697, 70, 70, "DefinitionBox",
      CellTags->"S5.61.1"],
    Cell[26364, 1384, 64, 1, 70, "Caption",
      CellTags->"S5.61.1"],
    Cell[26431, 1387, 240, 6, 70, "Text",
      CellTags->{"S5.61.1", "1.6"}],
    Cell[26674, 1395, 106, 1, 70, "MathCaption",
      CellTags->{"S5.61.1", "1.7"}],
    Cell[26805, 1400, 92, 2, 70, "Input",
      CellTags->"S5.61.1"],
    Cell[26900, 1404, 132, 4, 70, "Output",
      CellTags->"S5.61.1"]},
  "1.1"->{
    Cell[1776, 53, 148, 6, 36, "Subsection",
      CellTags->{"S5.61.1", "1.1"}]},
  "1.2"->{
    Cell[2944, 94, 160, 4, 40, "Text",
      CellTags->{"S5.61.1", "1.2"}]},
  "1.3"->{
    Cell[3107, 100, 78, 1, 40, "MathCaption",
      CellTags->{"S5.61.1", "1.3"}]},
  "1.4"->{
    Cell[3289, 107, 141, 4, 40, "MathCaption",
      CellTags->{"S5.61.1", "1.4"}]},
  "1.5"->{
    Cell[13159, 681, 145, 4, 40, "MathCaption",
      CellTags->{"S5.61.1", "1.5"}]},
  "1.6"->{
    Cell[26431, 1387, 240, 6, 70, "Text",
      CellTags->{"S5.61.1", "1.6"}]},
  "1.7"->{
    Cell[26674, 1395, 106, 1, 70, "MathCaption",
      CellTags->{"S5.61.1", "1.7"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.61.1", 27683, 1428},
  {"1.1", 29365, 1473},
  {"1.2", 29459, 1476},
  {"1.3", 29547, 1479},
  {"1.4", 29642, 1482},
  {"1.5", 29738, 1485},
  {"1.6", 29835, 1488},
  {"1.7", 29926, 1491}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 148, 6, 36, "Subsection",
  CellTags->{"S5.61.1", "1.1"}],
Cell[1927, 61, 936, 28, 64, "DefinitionBox",
  CellTags->"S5.61.1"],
Cell[2866, 91, 75, 1, 15, "Caption",
  CellTags->"S5.61.1"],
Cell[2944, 94, 160, 4, 40, "Text",
  CellTags->{"S5.61.1", "1.2"}],
Cell[3107, 100, 78, 1, 40, "MathCaption",
  CellTags->{"S5.61.1", "1.3"}],
Cell[3188, 103, 98, 2, 28, "Input",
  CellTags->"S5.61.1"],
Cell[3289, 107, 141, 4, 40, "MathCaption",
  CellTags->{"S5.61.1", "1.4"}],

Cell[CellGroupData[{
Cell[3455, 115, 92, 2, 28, "Input",
  CellTags->"S5.61.1"],
Cell[3550, 119, 9411, 551, 186, 9126, 543, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.61.1"],
Cell[12964, 672, 180, 6, 25, "Output",
  CellTags->"S5.61.1"]
}, Open  ]],
Cell[13159, 681, 145, 4, 40, "MathCaption",
  CellTags->{"S5.61.1", "1.5"}],

Cell[CellGroupData[{
Cell[13329, 689, 99, 2, 28, "Input",
  CellTags->"S5.61.1"],
Cell[13431, 693, 10035, 608, 186, 9964, 605, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.61.1"],
Cell[23469, 1303, 180, 6, 70, "Output",
  CellTags->"S5.61.1"]
}, Open  ]],
Cell[23664, 1312, 2697, 70, 70, "DefinitionBox",
  CellTags->"S5.61.1"],
Cell[26364, 1384, 64, 1, 70, "Caption",
  CellTags->"S5.61.1"],
Cell[26431, 1387, 240, 6, 70, "Text",
  CellTags->{"S5.61.1", "1.6"}],
Cell[26674, 1395, 106, 1, 70, "MathCaption",
  CellTags->{"S5.61.1", "1.7"}],

Cell[CellGroupData[{
Cell[26805, 1400, 92, 2, 70, "Input",
  CellTags->"S5.61.1"],
Cell[26900, 1404, 132, 4, 70, "Output",
  CellTags->"S5.61.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

