(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    472452,      12249]*)
(*NotebookOutlinePosition[    495642,      12912]*)
(*  CellTagsIndexPosition[    493416,      12826]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Statistics",
 StyleBox["`", "MB"],
 "StatisticsPlots",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S6.9.1", "1.1"}],

Cell["\<\
A wide variety of plots are used to gain an overview of data from a \
statistical perspective. Some summarize statistical computations on the data, \
while others compare data in ways that highlight their properties. This \
package implements several plotting functions of this class, including box\
\[Hyphen]and\[Hyphen]whisker plots, Pareto plots, quantile\[Hyphen]quantile \
plots, and stem-and-leaf plots. \
\>", "Text",
  CellTags->{"S6.9.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BoxWhiskerPlot[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "create a box\[Hyphen]and\[Hyphen]whisker plot of a data set",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["ParetoPlot[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "create a Pareto plot from the data",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["QuantilePlot[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "create a quantile\[Hyphen]quantile plot from the lists of data",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["PairwiseScatterPlot[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["matrix", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "create a pairs scatter plot from multivariate data",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["StemLeafPlot[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["data", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "create a stem\[Hyphen]and\[Hyphen]leaf plot from a list of data",
              
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.9.1"],

Cell["\<\
Basic statistics\[Hyphen]related plots.\
\>", "Caption",
 CellTags->"S6.9.1"],

Cell["Load the plotting package. ", "MathCaption",
 CellTags->{"S6.9.1", "1.3"}],

Cell["<<Statistics`StatisticsPlots`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S6.9.1"],

Cell[CellGroupData[{

Cell["Box\[Hyphen]and\[Hyphen]Whisker Plots", "Subsubsection",
  CellTags->{"S6.9.1", "1.4"}],

Cell["\<\
The box\[Hyphen]and\[Hyphen]whisker plot is invaluable for gaining a quick \
overview of the extent of a numeric data set. It takes the form of a box that \
spans the distance between two quantiles surrounding the median, typically \
the 25% quantile to the 75% quantile. Commonly, \
\[OpenCurlyDoubleQuote]whiskers,\[CloseCurlyDoubleQuote] lines that extend to \
span either the full data set or the data set excluding outliers, are added. \
Outliers are defined as points beyond 3/2 the interquantile range from the \
edge of the box; far outliers are points beyond three times the interquantile \
range. \
\>", "Text",
  CellTags->{"S6.9.1", "1.5"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BoxWhiskerPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vector", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["plot a vector of data",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxWhiskerPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["matrix", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot each column as a separate box",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxWhiskerPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["data",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot multiple data sets, with a box for each column or vector",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.9.1"],

Cell["Box\[Hyphen]and\[Hyphen]whisker plots.", "Caption",
  CellTags->"S6.9.1"],

Cell["Generate some numbers to plot. ", "MathCaption",
  CellTags->{"S6.9.1", "1.6"}],

Cell["\<\
dat = Table[Random[], {50}];
datm = Table[Random[], {50}, {3}];\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S6.9.1"],

Cell["\<\
In its most basic form, the function takes a simple vector of data. \
\>", "MathCaption",
  CellTags->{"S6.9.1", "1.7"}],

Cell[CellGroupData[{

Cell["BoxWhiskerPlot[dat]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.5 1 0.00648201 1.01156 [
[ 0 0 -0.125 0 ]
[-0.0125 .00648 -6 -4.5 ]
[-0.0125 .00648 0 4.5 ]
[-0.0125 .20879 -18 -4.5 ]
[-0.0125 .20879 0 4.5 ]
[-0.0125 .41111 -18 -4.5 ]
[-0.0125 .41111 0 4.5 ]
[-0.0125 .61342 -18 -4.5 ]
[-0.0125 .61342 0 4.5 ]
[-0.0125 .81573 -18 -4.5 ]
[-0.0125 .81573 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 .00648 m
.00625 .00648 L
s
[(0)] -0.0125 .00648 1 0 Mshowa
0 .20879 m
.00625 .20879 L
s
[(0.2)] -0.0125 .20879 1 0 Mshowa
0 .41111 m
.00625 .41111 L
s
[(0.4)] -0.0125 .41111 1 0 Mshowa
0 .61342 m
.00625 .61342 L
s
[(0.6)] -0.0125 .61342 1 0 Mshowa
0 .81573 m
.00625 .81573 L
s
[(0.8)] -0.0125 .81573 1 0 Mshowa
.125 Mabswid
0 .05706 m
.00375 .05706 L
s
0 .10764 m
.00375 .10764 L
s
0 .15822 m
.00375 .15822 L
s
0 .25937 m
.00375 .25937 L
s
0 .30995 m
.00375 .30995 L
s
0 .36053 m
.00375 .36053 L
s
0 .46168 m
.00375 .46168 L
s
0 .51226 m
.00375 .51226 L
s
0 .56284 m
.00375 .56284 L
s
0 .664 m
.00375 .664 L
s
0 .71458 m
.00375 .71458 L
s
0 .76515 m
.00375 .76515 L
s
0 .86631 m
.00375 .86631 L
s
0 .91689 m
.00375 .91689 L
s
0 .96747 m
.00375 .96747 L
s
.25 Mabswid
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.25 .2377 m
.75 .2377 L
.75 .66844 L
.25 .66844 L
.25 .2377 L
F
0 g
.5 Mabswid
.25 .2377 m
.75 .2377 L
.75 .66844 L
.25 .66844 L
.25 .2377 L
s
.38 .02381 m
.62 .02381 L
s
.5 .02381 m
.5 .2377 L
s
.5 .66844 m
.5 .97619 L
s
.38 .97619 m
.62 .97619 L
s
.25 .35128 m
.75 .35128 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00@@3oool200000>T0oooo00100?ooo`040000003o
ool0oooo000000<0oooo/@00000d0?ooo`00@03oool010000000oooo0?ooo`0000030?ooo`800000
[P3oool00`000000oooo0?ooo`0b0?ooo`00@03oool010000000oooo0?ooo`0000030?ooo`030000
003oool0oooo0:d0oooo00<000000?ooo`3oool0<P3oool00400oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`2]0?ooo`030000003oool0oooo0380oooo00110?ooo`800000103o
ool00`000000oooo0?ooo`100?ooob/00000@P3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool0
0`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool0
04L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo
0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000
oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo
00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo0380oooo00170?ooo`800000EP3oool00`000000oooo0?ooo`1E
0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?oo
o`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`03
0000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0
E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003o
ool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool0
0`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool0
04L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo
0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000
oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo
00<000000?ooo`3oool0<P3oool004L0oooo0P00001F0?ooo`030000003oool0oooo05D0oooo00<0
00000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E
0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?oo
o`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`03
0000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0
E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003o
ool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool0
0`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool0
04L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo
0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000
oooo0?ooo`0b0?ooo`00A`3oool2000005H0oooo00<000000?ooo`3oool0E@3oool00`000000oooo
0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<0
00000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E
0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?oo
o`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`03
0000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0
E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003o
ool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00=@3oool2
000000@0oooo0P0000030?ooo`@000000`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0
oooo05D0oooo00<000000?ooo`3oool0<P3oool003@0oooo00@000000?ooo`3oool00000203oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool0
0`000000oooo0?ooo`0b0?ooo`00=03oool010000000oooo0?ooo`0000090?ooo`030000003oool0
oooo00<0oooo0P00001F0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool0
03@0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00=03oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0E@3o
ool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo000e0?ooo`8000002P3oool2
000000@0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0
oooo0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`00
0000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`0Y0?oooeT00000:`3oool00`000000
oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`00
00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?oo
o`0Y0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool00`000000oooo0?oo
o`0b0?ooo`00A`3oool2000002X0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y
0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo02T0oooo00<000000?l0
003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`03
0000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo0380oooo00170?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000
E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003o
ool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003o
ool0oooo0380oooo00170?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o0000
0`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo
02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo
0380oooo00170?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000
oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo02T0oooo
00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo
00170?ooo`800000:P3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<0
00000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E
0?l000030000003oool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?oo
o`3oool0:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<000000?oo
o`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l00003
0000003oool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0
:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<000000?ooo`3oool0
<P3oool004L0oooo00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l000030000003o
ool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3oool0
0`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<000000?ooo`3oool0<P3oool0
04L0oooo00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo
02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3ooomI000002/0
oooo00<000000?ooo`3oool0<P3oool004L0oooo0P00000Z0?ooo`030000003o0000o`0005D0o`00
00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?oo
o`0Y0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool00`000000oooo0?oo
o`0b0?ooo`00A`3oool00`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`0000<00000
0?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`0Y0?oo
o`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?oo
o`00A`3oool00`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3o
ool0:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`0Y0?ooo`030000
003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3o
ool00`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`0b0?ooo`00=@3oool2000000@0oooo0P0000050?ooo`<000000P3oool0
0`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool0
0`000000oooo0?ooo`0b0?ooo`00=03oool010000000oooo0?ooo`00000;0?ooo`050000003oool0
oooo0?ooo`000000:`3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<0
00000?ooo`3oool0<P3oool003@0oooo00@000000?ooo`3oool00000203oool500000080oooo0P00
000Z0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool00`000000oooo0?oo
o`0b0?ooo`00=03oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo
00<000000?ooo`3oool0<P3oool003@0oooo00@000000?ooo`3oool000002@3oool00`000000oooo
000000030?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo0380oooo000e0?ooo`8000002`3oool2000000<0oooo00<0
00000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<0
00000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E
0?l000030000003oool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?oo
o`3oool0:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<000000?oo
o`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l00003
0000003oool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0
:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<000000?ooo`3oool0
<P3oool004L0oooo00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l000030000003o
ool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo0P00000Z0?ooo`030000003o0000
o`0005D0o`0000<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`00
0000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool00`00
0000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0
o`0000<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo
0?ooo`0Y0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool00`000000oooo
0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`0000<0
00000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`0Y
0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b
0?ooo`00A`3oool00`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`0000<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`0Y0?ooo`03
0000003o0000o`0005D0o`0000<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00
A`3oool00`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0
:@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool2000002X0oooo00<000000?l0003o0000E@3o
00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0
oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0
oooo0380oooo00170?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`00
0000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo02T0
oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380
oooo00170?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo02T0oooo00<0
00000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo0017
0?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y
0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo02T0oooo00<000000?l0
003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`03
0000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo0380oooo00170?ooo`800000:P3oool00`000000o`000?l0001E0?l000030000
003oool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3o
ool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<000000?ooo`3oool0<P3o
ool004L0oooo00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l000030000003oool0
oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3oool00`00
0000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0
oooo00<000000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0
oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3oool00`000000o`00
0?l0001E0?l000030000003oool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<0
00000?ooo`3oool0:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<0
00000?ooo`3oool0<P3oool003D0oooo0P0000040?ooo`8000000`3oool3000000@0oooo00<00000
0?ooo`3oool0:@3oool00`000000o`000?l0001E0?l000030000003oool0oooo02T0oooo00<00000
0?ooo`3oool0<P3oool003@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo0380oooo000d0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000`3oool2000002X0oooo00<000000?l0003o0000E@3o00000`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo0380oooo000d0?ooo`040000003oool0oooo000000P0oooo
0`0000040?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo0380oooo000d0?ooo`040000003oool0oooo000000T0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0Y0?ooo`030000003o0000o`0005D0o`00
00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0b0?ooo`00=@3oool2000000X0oooo0`00
00030?ooo`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo02T0oooo00<00000
0?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?oo
o`030000003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?oo
o`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo02T0oooo00<000000?l0003o
0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0380oooo00170?ooo`030000
003oool0oooo02T0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Y0?ooo`030000
003oool0oooo0380oooo00170?ooo`800000:P3oool00`000000o`000?l0001E0?l000030000003o
ool0oooo02T0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0:@3ooomI
000002/0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`00
0000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo
0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<0
00000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo0017
0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b
0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?oo
o`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`03
0000003oool0oooo0380oooo00170?ooo`800000EP3oool00`000000oooo0?ooo`1E0?ooo`030000
003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3o
ool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0
oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`00
0000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo
0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<0
00000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo0017
0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b
0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?oo
o`3oool0<P3oool004L0oooo0P00001F0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3o
ool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000
003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3o
ool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0
oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`00
0000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo
0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool003D0oooo0P00
00040?ooo`800000103oool2000000@0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo0380oooo000d0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000000`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo
00<000000?ooo`3oool0<P3oool003@0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`0000030?ooo`800000EP3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380
oooo000d0?ooo`040000003oool0oooo000000T0oooo0P0000040?ooo`030000003oool0oooo05D0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00=03oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0E@3oool00`00
0000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo000e0?ooo`8000002P3oool2000000@0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380
oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo
0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<0
00000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E
0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?oo
o`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`03
0000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo0P00001F0?ooo`030000
003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3o
ool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0
oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`00
0000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380
oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo
0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<0
00000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E
0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?oo
o`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool2000005H0oooo00<000000?ooo`3o
ool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000
003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3o
ool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380oooo00170?ooo`030000003oool0
oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool00`00
0000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0<P3oool004L0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0380
oooo00170?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0E@3oool00`000000oooo
0?ooo`0b0?ooo`00A`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo05D0oooo00<0
00000?ooo`3oool0<P3oool004L0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1E
0?ooo`030000003oool0oooo0380oooo00170?ooo`800000EP3oool00`000000oooo0?ooo`1E0?oo
o`030000003oool0oooo0380oooo00170?ooo`030000003oool0oooo0400oooo:`0000120?ooo`03
0000003oool0oooo0380oooo00170?ooo`030000003oool0oooo0:d0oooo00<000000?ooo`3oool0
<P3oool004L0oooo00<000000?ooo`3oool0[@3oool00`000000oooo0?ooo`0b0?ooo`00A`3oool0
0`000000oooo0?ooo`2]0?ooo`030000003oool0oooo0380oooo00170?oook400000=03oool00001
\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {0.0916732, -0.0253352, \
0.00569358, 0.00562852}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S6.9.1"]
}, Open  ]],

Cell["\<\
When the data is multivariate, a box is produced for each column. \
\>", "MathCaption",
 CellTags->{"S6.9.1", "1.8"}],

Cell[CellGroupData[{

Cell["BoxWhiskerPlot[datm]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .55556 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.333333 0.0120785 0.535357 [
[.16667 -0.0125 -3 -9 ]
[.16667 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.83333 -0.0125 -3 -9 ]
[.83333 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01208 -6 -4.5 ]
[-0.0125 .01208 0 4.5 ]
[-0.0125 .11915 -18 -4.5 ]
[-0.0125 .11915 0 4.5 ]
[-0.0125 .22622 -18 -4.5 ]
[-0.0125 .22622 0 4.5 ]
[-0.0125 .33329 -18 -4.5 ]
[-0.0125 .33329 0 4.5 ]
[-0.0125 .44036 -18 -4.5 ]
[-0.0125 .44036 0 4.5 ]
[-0.0125 .54744 -6 -4.5 ]
[-0.0125 .54744 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .55556 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .55556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 0 m
.16667 .00625 L
s
[(1)] .16667 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(2)] .5 -0.0125 0 1 Mshowa
.83333 0 m
.83333 .00625 L
s
[(3)] .83333 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .01208 m
.00625 .01208 L
s
[(0)] -0.0125 .01208 1 0 Mshowa
0 .11915 m
.00625 .11915 L
s
[(0.2)] -0.0125 .11915 1 0 Mshowa
0 .22622 m
.00625 .22622 L
s
[(0.4)] -0.0125 .22622 1 0 Mshowa
0 .33329 m
.00625 .33329 L
s
[(0.6)] -0.0125 .33329 1 0 Mshowa
0 .44036 m
.00625 .44036 L
s
[(0.8)] -0.0125 .44036 1 0 Mshowa
0 .54744 m
.00625 .54744 L
s
[(1)] -0.0125 .54744 1 0 Mshowa
.125 Mabswid
0 .03885 m
.00375 .03885 L
s
0 .06561 m
.00375 .06561 L
s
0 .09238 m
.00375 .09238 L
s
0 .14592 m
.00375 .14592 L
s
0 .17269 m
.00375 .17269 L
s
0 .19945 m
.00375 .19945 L
s
0 .25299 m
.00375 .25299 L
s
0 .27976 m
.00375 .27976 L
s
0 .30652 m
.00375 .30652 L
s
0 .36006 m
.00375 .36006 L
s
0 .38683 m
.00375 .38683 L
s
0 .4136 m
.00375 .4136 L
s
0 .46713 m
.00375 .46713 L
s
0 .4939 m
.00375 .4939 L
s
0 .52067 m
.00375 .52067 L
s
.25 Mabswid
0 0 m
0 .55556 L
s
0 .55556 m
1 .55556 L
s
1 0 m
1 .55556 L
s
0 0 m
1 0 L
1 .55556 L
0 .55556 L
closepath
clip
newpath
1 0 0 r
.08333 .16964 m
.25 .16964 L
.25 .42323 L
.08333 .42323 L
.08333 .16964 L
F
0 g
.5 Mabswid
.08333 .16964 m
.25 .16964 L
.25 .42323 L
.08333 .42323 L
.08333 .16964 L
s
.12667 .01323 m
.20667 .01323 L
s
.16667 .01323 m
.16667 .16964 L
s
.16667 .42323 m
.16667 .54233 L
s
.12667 .54233 m
.20667 .54233 L
s
.08333 .3109 m
.25 .3109 L
s
1 0 0 r
.41667 .13897 m
.58333 .13897 L
.58333 .4217 L
.41667 .4217 L
.41667 .13897 L
F
0 g
.41667 .13897 m
.58333 .13897 L
.58333 .4217 L
.41667 .4217 L
.41667 .13897 L
s
.46 .03352 m
.54 .03352 L
s
.5 .03352 m
.5 .13897 L
s
.5 .4217 m
.5 .53256 L
s
.46 .53256 m
.54 .53256 L
s
.41667 .2679 m
.58333 .2679 L
s
1 0 0 r
.75 .14986 m
.91667 .14986 L
.91667 .46604 L
.75 .46604 L
.75 .14986 L
F
0 g
.75 .14986 m
.91667 .14986 L
.91667 .46604 L
.75 .46604 L
.75 .14986 L
s
.79333 .01748 m
.87333 .01748 L
s
.83333 .01748 m
.83333 .14986 L
s
.83333 .46604 m
.83333 .54229 L
s
.79333 .54229 m
.87333 .54229 L
s
.75 .26861 m
.91667 .26861 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]
0?ooo`00o`3oool]0?ooo`00@@3oool5000005P0oooo1000001I0?ooo`800000;`3oool004<0oooo
00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`1I0?ooo`040000003oool0oooo000002h0
oooo00130?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0FP3oool00`000000oooo
0?ooo`0]0?ooo`00@`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05X0oooo00<0
00000?ooo`3oool0;03oool004<0oooo00<000000?ooo`3oool0F03oool010000000oooo0?ooo`00
001H0?ooo`040000003oool0oooo000002h0oooo00120?ooo`800000F`3oool2000005X0oooo0P00
000_0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3o
ool]0?ooo`005@3ooooo000001L000000@3oool000h0oooo0P0000050?ooo`030000003oool0oooo
02/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo
02/0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo
02/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo
02/0oooo0@0000010?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`<00000o`3ooolC0?oo
o`4000000@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0P0?oo
oaL00000f`3oool100000040oooo000=0?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`2[0?oooaL000008P3oool100000040oooo000>0?ooo`80
00001@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0;H0oooo00<000000?ooo`3o
ool0:`3oool100000040oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
]P3oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3o
ool00`000000oooo0?ooo`2f0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0[0?ooo`030000003oool0oooo04l0oooo5`00001@0?ooo`030000003oool0
oooo02/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo
05X0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0
oooo0P00000/0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`000000
oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool00`000000oooo
0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool100000040oooo
000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?oo
o`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0[
0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0[
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1J0?oo
o`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool100000040oooo000E0?ooo`03
0000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`1I0?ooo`03
0000003oool0oooo02/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0[0?ooo`030000
003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0[0?ooo`400000
0@3oool001D0oooo0P00000/0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3o
ool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool0
0`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool1
00000040oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool00`00
0000oooo0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`005@3oool00`000000
oooo0?ooo`0[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`000000
oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool00`000000oooo
0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool100000040oooo
000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?oo
o`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0[
0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0[
0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1J0?oo
o`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool100000040oooo000E0?ooo`80
0000;03oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3o
ool0:`3oool100000040oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
FP3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3o
ool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool0
0`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool1
00000040oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool00`00
0000oooo0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`000P3oool2000000@0
oooo0P0000030?ooo`@00000103oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo05X0
oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool000050?oo
o`000000oooo0?ooo`000000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02/0
oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000090?ooo`030000003oool0oooo00@0
oooo0`00000[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`000000
oooo0?ooo`0[0?ooo`4000000@3oool000050?ooo`000000oooo0?ooo`0000002P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool00`000000
oooo0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`0000D0oooo0000003oool0
oooo000000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0:`3oool00`00
0000oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool10000
0040oooo00020?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3oool0:`3oool00`000000
oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool100000040
oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo
0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?oo
o`0[0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`13
0?ooobl00000A03oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`130?ooo`030000003o0000o`0002/0o`0000<000000?oo
o`3oool0@P3oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo0P00000/0?ooo`03
0000003oool0oooo04<0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`120?ooo`03
0000003oool0oooo02/0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0[0?ooo`030000
003oool0oooo04<0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooobl00000
5P3oool100000040oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0@`3o
ool00`000000o`000?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o
00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool0
0`000000oooo0?ooo`130?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool0
0`000000o`000?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo04<0oooo00<000000?l0003o0000:`3o00000`00
0000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool10000
0040oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0@`3oool00`000000
o`000?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000
oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0503oool_000002h0oooo
00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`00
00<000000?ooo`3oool0503oool100000040oooo000E0?ooo`8000005@3oool00`000000o`000?l0
000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?oo
o`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool100000040oooo000E
0?ooo`030000003oool0oooo01@0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/
0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[
0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?oo
o`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l0
00030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0503oool00`000000o`000?l0000[0?l00003
0000003oool0oooo02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`03
0000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool100000040oooo000E0?ooo`030000
003oool0oooo01@0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000
003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000
003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`030000003o
0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l000030000003o
ool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0503oool00`000000o`000?l0000[0?l000030000003oool0
oooo02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000
o`0002/0o`0000<000000?ooo`3oool0503oool100000040oooo000E0?ooo`8000005@3oool00`00
0000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o0000:`3o00000`00
0000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool10000
0040oooo000E0?ooo`030000003oool0oooo01@0oooo00<000000?l0003o0000:`3o00000`000000
oooo0?ooo`0/0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000
o`000?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`0D0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`00
0?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo
0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0503oool00`000000o`000?l0
000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?oo
o`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool100000040oooo000E
0?ooo`030000003oool0oooo01@0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/
0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[
0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?oo
o`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l0
00030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?oo
o`4000000@3oool00080oooo0P0000040?ooo`8000001@3oool3000000<0oooo00<000000?ooo`3o
ool0503oool00`000000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o
0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3o
ool0503oool100000040oooo00001@3oool000000?ooo`3oool0000000/0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0D0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3o
ool0;03oool00`000000o`000?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o
0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool000050?ooo`000000oooo0?ooo`00
0000203oool5000000<0oooo0`00000D0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3o
ool0;03oool00`000000o`000?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o
0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool000050?ooo`000000oooo0?ooo`00
0000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo01@0oooo00<000000?l0
003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0o`0000<000000?oo
o`3oool0:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?oo
o`0000D0oooo0000003oool0oooo000000090?ooo`030000003oool0000000@0oooo00<000000?oo
o`3oool0503oool00`000000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<000000?l0
003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?oo
o`3oool0503oool100000040oooo00020?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3o
ool0503oool00`000000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o
0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3o
ool0503oool100000040oooo000E0?ooo`030000003oool0oooo01@0oooo00<000000?l0003o0000
:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0
:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3o
ool00`000000oooo0?ooo`0D0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03o
ool00`000000o`000?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o
00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0503oool0
0`000000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o0000:`3o0000
0`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool1
00000040oooo000E0?ooo`8000005@3oool00`000000o`000?l0000[0?l000030000003oool0oooo
02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`00
02/0o`0000<000000?ooo`3oool0503oool100000040oooo000E0?ooo`030000003oool0oooo01@0
oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0
o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo01@0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`030000003o0000o`0002/0o`00
00<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l000030000003oool0oooo02/0oooo
00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0503oool00`000000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<0
00000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<0
00000?ooo`3oool0503oool100000040oooo000E0?ooo`030000003oool0oooo01@0oooo00<00000
0?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooobl00000;@3oool00`000000o`000?l0000[
0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?oo
o`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l0
00030000003oool0oooo02/0oooo;`00000F0?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0503oool00`000000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o
0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3o
ool0503oool100000040oooo000E0?ooo`030000003oool0oooo01@0oooo00<000000?l0003o0000
:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0
:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3o
ool2000001D0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o
0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000003o
ool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`030000003o0000
o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l000030000003oool0
oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool0
01D0oooo00<000000?ooo`3oool0503oool00`000000o`000?l0000[0?l000030000003oool0oooo
02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`00
02/0o`0000<000000?ooo`3oool0503oool100000040oooo000E0?ooo`030000003oool0oooo01@0
oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0
o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo01@0
oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`030000003o0000o`0002/0o`00
00<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l000030000003oool0oooo02/0oooo
00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0503oool00`000000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<0
00000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<0
00000?ooo`3oool0503oool100000040oooo000E0?ooo`030000003oool0oooo01@0oooo00<00000
0?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0o`0000<00000
0?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo01@0oooo0@000001
0?ooo`005@3oool2000001D0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?oo
o`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l0
00030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooobl0
0000;P3oool00`000000o`000?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o
0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0
503oool00`000000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o0000
:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0
503oool100000040oooo000E0?ooo`030000003oool0oooo01@0oooo00<000000?l0003o0000:`3o
00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3o
ool00`000000o`000?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool0
0`000000oooo0?ooo`0D0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03oool0
0`000000o`000?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o0000
0`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0503oool00`00
0000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o0000:`3o00000`00
0000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool10000
0040oooo00020?ooo`800000103oool2000000<0oooo0`0000050?ooo`030000003oool0oooo01@0
oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0
o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo01@0
oooo0@0000010?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool0503oool00`000000o`000?l0000[0?l000030000003oool0oooo
02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`00
02/0o`0000<000000?ooo`3oool0503oool100000040oooo00001@3oool000000?ooo`3oool00000
00P0oooo00@000000?ooo`3oool00000103oool3000001@0oooo00<000000?l0003o0000:`3o0000
0`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool0
0`000000o`000?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`0000D0oooo0000
003oool0oooo000000080?ooo`<000001@3oool00`000000oooo0?ooo`0D0?ooo`030000003o0000
o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l000030000003oool0
oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool0
00050?ooo`000000oooo0?ooo`0000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo01@0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000
o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000003oool0
oooo01@0oooo0@0000010?ooo`000P3oool2000000X0oooo0`0000040?ooo`030000003oool0oooo
01@0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`00
02/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo
01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`030000003o0000o`0002/0
o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l000030000003oool0oooo02/0
oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0503oool00`000000o`000?l0000[0?l000030000003oool0oooo02`0oooo
00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`00
00<000000?ooo`3oool0503oool100000040oooo000E0?ooo`030000003oool0oooo01@0oooo00<0
00000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`0002/0o`0000<0
00000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo01@0oooo0@00
00010?ooo`005@3oool2000001D0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/
0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[
0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?oo
o`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l0
00030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0503oool00`000000o`000?l0000[0?l00003
0000003oool0oooo02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`03
0000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool100000040oooo000E0?ooo`030000
003oool0oooo01@0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000
003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000
003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`030000003o
0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l000030000003o
ool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3o
ool001D0oooo00<000000?ooo`3oool0503oool00`000000o`000?l0000[0?l000030000003oool0
oooo02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`030000003o0000
o`0002/0o`0000<000000?ooo`3oool0503oool100000040oooo000E0?ooo`030000003oool0oooo
01@0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000003o0000o`00
02/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000003oool0oooo
01@0oooo0@0000010?ooo`005@3oool2000001D0oooo00<000000?l0003o0000:`3o00000`000000
oooo0?ooo`0/0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000
o`000?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`0D0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`00
0?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo
0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0503oool00`000000o`000?l0
000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?oo
o`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool100000040oooo000E
0?ooo`030000003oool0oooo01@0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/
0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[
0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?oo
o`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l0
00030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0503oool00`000000o`000?l0000[0?l00003
0000003oool0oooo02`0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0[0?ooo`03
0000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool100000040oooo000E0?ooo`030000
003oool0oooo01@0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0/0?ooo`030000
003o0000o`0002/0o`0000<000000?ooo`3oool0:`3oool00`000000o`000?l0000[0?l000030000
003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`030000003o
0000o`0002/0o`0000<000000?ooo`3oool0;03oool00`000000o`000?l0000[0?l000030000003o
ool0oooo02/0oooo00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3o
ool001D0oooo0P00000E0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0;03oool0
0`000000o`000?l0000[0?l000030000003oool0oooo02/0oooo00<000000?l0003o0000:`3o0000
0`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0503oool00`00
0000o`000?l0000[0?l000030000003oool0oooo02`0oooo00<000000?l0003o0000:`3o00000`00
0000oooo0?ooo`0[0?ooo`030000003o0000o`0002/0o`0000<000000?ooo`3oool0503oool10000
0040oooo000E0?ooo`030000003oool0oooo01@0oooo;`00000^0?ooobl00000;@3oool00`000000
o`000?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo
0?ooo`0[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0@P3oool00`000000o`00
0?l0000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0@P3oool00`000000o`000?l0
000[0?l000030000003oool0oooo01@0oooo0@0000010?ooo`000P3oool2000000@0oooo0P000004
0?ooo`8000001@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo05X0oooo00<00000
0?ooo`3oool0@P3oool00`000000o`000?l0000[0?l000030000003oool0oooo01@0oooo0@000001
0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool0:`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0480oooo00<0
00000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool000050?ooo`000000
oooo0?ooo`000000203oool010000000oooo0?ooo`0000040?ooo`<00000:`3oool00`000000oooo
0?ooo`1J0?ooo`030000003oool0oooo0480oooo00<000000?l0003o0000:`3o00000`000000oooo
0?ooo`0D0?ooo`4000000@3oool000050?ooo`000000oooo0?ooo`0000002@3oool2000000D0oooo
00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0480oooo
00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool000050?ooo`00
0000oooo0?ooo`000000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`120?ooo`030000003o0000o`0002/0
o`0000<000000?ooo`3oool0503oool100000040oooo00020?ooo`8000002P3oool2000000D0oooo
00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0480oooo
00<000000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0:`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0480oooo00<0
00000?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<00000
0?ooo`3oool0:`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0480oooo00<00000
0?l0003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0480oooo00<000000?l0
003o0000:`3o00000`000000oooo0?ooo`0D0?ooo`4000000@3oool001D0oooo00<000000?ooo`3o
ool0:`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0480oooo;`00000F0?ooo`40
00000@3oool001D0oooo0P00000/0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3o
ool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3o
ool100000040oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool0
0`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`00
0000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool00`000000
oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3oool100000040
oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo
0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`005@3oool00`000000oooo0?oo
o`0[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?oo
o`0[0?ooo`4000000@3oool001D0oooo0P00000/0?ooo`030000003oool0oooo05X0oooo00<00000
0?ooo`3oool0F@3oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?oo
o`3oool0:`3oool100000040oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3o
ool0FP3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`00
5@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0
F@3oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3o
ool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0:`3o
ool100000040oooo000E0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0FP3oool0
0`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@0000010?ooo`005@3oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F@3oool00`00
0000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo0P00000/0?ooo`030000003oool0oooo05X0
oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo
00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05T0oooo
00<000000?ooo`3oool0:`3oool100000040oooo000E0?ooo`030000003oool0oooo02/0oooo00<0
00000?ooo`3oool0FP3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02/0oooo0@00
00010?ooo`005@3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo05X0oooo00<00000
0?ooo`3oool0F@3oool00`000000oooo0?ooo`0[0?ooo`4000000@3oool001D0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`1?0?oooaL00000D03oool00`000000oooo0?ooo`0[0?oo
o`4000000@3oool001D0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`2f0?ooo`03
0000003oool0oooo02/0oooo0@0000010?ooo`003@3oool5000000<0oooo00<000000?ooo`3oool0
803ooolG00000:80oooo5`00000R0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`3o0?oooa<0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`03
0?ooo`<00000o`3ooolC0?ooo`4000000@3oool000l0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`3o0?oooa<0oooo0@0000010?ooo`003`3oool00`000000oooo0?ooo`030?ooool0
00005`0000010?ooo`003P3oool200000?l0oooo7@3oool00?l0oooo;@3oool00?l0oooo;@3oool0
0?l0oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3oool00001\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {0.267825, -0.140752, 0.0108145, \
0.00673353}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S6.9.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxQuantile", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["0.25", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "distance of quantile from median (0.5) for box edges",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxOutliers", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to indicate outliers",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxOrientation", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Vertical", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["orientation of the graph",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxLabels", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["labels for the boxes",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxExtraSpacing", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["0", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify extra space to place between boxes",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Hue[0]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "colors to use for the boxes",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxLineStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "styles to use for lines in the graph",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxMedianStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "additional styles for the median line",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BoxOutlierShapes", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "functions to use to draw outlier points",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S6.9.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["BoxWhiskerPlot", "MR"],
 ". "
}], "Caption",
 CellTags->"S6.9.1"],

Cell[TextData[{
 "A number of options can be applied to control the appearance of the boxes. \
In addition to the above options, standard ",
 StyleBox["Graphics", "MR"],
 " options can be used. "
}], "Text",
 CellTags->{"S6.9.1", "1.9"}],

Cell[TextData[{
 "The amount of data covered by the boxes is determined by the ",
 StyleBox["BoxQuantile", "MR"],
 " option. This takes the form of a number from 0 to 0.5, indicating a \
distance from the median (i.e., 0.5). Thus, 0.25 places quantiles at 0.25 and \
0.75 (or the 25% and 75% quantiles). "
}], "Text",
 CellTags->{"S6.9.1", "1.10"}],

Cell[TextData[{
 "The ",
 StyleBox["BoxOutliers", "MR"],
 " option indicates whether outliers should be drawn in a special way. If ",
 StyleBox["None", "MR"],
 ", the whiskers are drawn to cover the entire data set. If ",
 StyleBox["All", "MR"],
 ", near and far outliers (as described previously) are drawn identically, \
and the whiskers only cover non\[Hyphen]outlying data points. If ",
 StyleBox["Automatic", "MR"],
 ", the near and far outliers are drawn differently, as determined by the ",
 StyleBox["BoxOutlierShapes", "MR"],
 " option. The ",
 StyleBox["BoxOutlierShapes", "MR"],
 " option takes a pure function or a pair of pure functions that describe how \
to draw the outliers. It can also take ",
 StyleBox["None", "MR"],
 ", in which case the outliers are not drawn at all, or ",
 StyleBox["Automatic", "MR"],
 ", which draws them as simple points. The pure function should take the \
location of the outlier as an argument, and return the graphics primitives to \
be drawn. For convenience, you may use the shape functions such as ",
 StyleBox["PlotSymbol", "MR"],
 " from the ",
 StyleBox["Graphics`MultipleListPlot`", "MR"],
 " package, which is automatically loaded with the ",
 StyleBox["StatisticsPlots", "MR"],
 " package. "
}], "Text",
 CellTags->{"S6.9.1", "1.11"}],

Cell["\<\
Add some outliers to the data and draw the box with the quantiles placed at \
10% and 90%, with the outliers drawn as a star for the near outliers and a \
box for the far outliers. \
\>", "MathCaption",
 CellTags->{"S6.9.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
BoxWhiskerPlot[Join[dat, {1.5, 2.5, 3.}],
    BoxQuantile -> 0.4,
    BoxOutliers -> All,
    BoxOutlierShapes -> {PlotSymbol[Star], PlotSymbol[Box]}
]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.5 1 0.0183404 0.319283 [
[ 0 0 -0.125 0 ]
[-0.0125 .01834 -6 -4.5 ]
[-0.0125 .01834 0 4.5 ]
[-0.0125 .17798 -18 -4.5 ]
[-0.0125 .17798 0 4.5 ]
[-0.0125 .33762 -6 -4.5 ]
[-0.0125 .33762 0 4.5 ]
[-0.0125 .49727 -18 -4.5 ]
[-0.0125 .49727 0 4.5 ]
[-0.0125 .65691 -6 -4.5 ]
[-0.0125 .65691 0 4.5 ]
[-0.0125 .81655 -18 -4.5 ]
[-0.0125 .81655 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 .01834 m
.00625 .01834 L
s
[(0)] -0.0125 .01834 1 0 Mshowa
0 .17798 m
.00625 .17798 L
s
[(0.5)] -0.0125 .17798 1 0 Mshowa
0 .33762 m
.00625 .33762 L
s
[(1)] -0.0125 .33762 1 0 Mshowa
0 .49727 m
.00625 .49727 L
s
[(1.5)] -0.0125 .49727 1 0 Mshowa
0 .65691 m
.00625 .65691 L
s
[(2)] -0.0125 .65691 1 0 Mshowa
0 .81655 m
.00625 .81655 L
s
[(2.5)] -0.0125 .81655 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(3)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .05027 m
.00375 .05027 L
s
0 .0822 m
.00375 .0822 L
s
0 .11413 m
.00375 .11413 L
s
0 .14605 m
.00375 .14605 L
s
0 .20991 m
.00375 .20991 L
s
0 .24184 m
.00375 .24184 L
s
0 .27377 m
.00375 .27377 L
s
0 .3057 m
.00375 .3057 L
s
0 .36955 m
.00375 .36955 L
s
0 .40148 m
.00375 .40148 L
s
0 .43341 m
.00375 .43341 L
s
0 .46534 m
.00375 .46534 L
s
0 .52919 m
.00375 .52919 L
s
0 .56112 m
.00375 .56112 L
s
0 .59305 m
.00375 .59305 L
s
0 .62498 m
.00375 .62498 L
s
0 .68884 m
.00375 .68884 L
s
0 .72076 m
.00375 .72076 L
s
0 .75269 m
.00375 .75269 L
s
0 .78462 m
.00375 .78462 L
s
0 .84848 m
.00375 .84848 L
s
0 .88041 m
.00375 .88041 L
s
0 .91233 m
.00375 .91233 L
s
0 .94426 m
.00375 .94426 L
s
.25 Mabswid
0 0 m
0 1 L
s
0 1 m
1 1 L
s
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.25 .06042 m
.75 .06042 L
.75 .32113 L
.25 .32113 L
.25 .06042 L
F
0 g
.5 Mabswid
.25 .06042 m
.75 .06042 L
.75 .32113 L
.25 .32113 L
.25 .06042 L
s
.38 .02381 m
.62 .02381 L
s
.5 .02381 m
.5 .06042 L
s
.5 .32113 m
.5 .49727 L
s
.38 .49727 m
.62 .49727 L
s
.5 .81655 0 2.5 Mabsadd m
.5 .81655 -0.56518 .7779 Mabsadd L
.5 .81655 -2.37764 .77254 Mabsadd L
.5 .81655 -0.91448 -0.29713 Mabsadd L
.5 .81655 -1.46946 -2.02254 Mabsadd L
.5 .81655 0 -0.96154 Mabsadd L
.5 .81655 1.46946 -2.02254 Mabsadd L
.5 .81655 .91448 -0.29713 Mabsadd L
.5 .81655 2.37764 .77254 Mabsadd L
.5 .81655 .56518 .7779 Mabsadd L
.5 .81655 0 2.5 Mabsadd L closepath F
.5 .97619 0 2.5 Mabsadd m
.5 .97619 -0.56518 .7779 Mabsadd L
.5 .97619 -2.37764 .77254 Mabsadd L
.5 .97619 -0.91448 -0.29713 Mabsadd L
.5 .97619 -1.46946 -2.02254 Mabsadd L
.5 .97619 0 -0.96154 Mabsadd L
.5 .97619 1.46946 -2.02254 Mabsadd L
.5 .97619 .91448 -0.29713 Mabsadd L
.5 .97619 2.37764 .77254 Mabsadd L
.5 .97619 .56518 .7779 Mabsadd L
.5 .97619 0 2.5 Mabsadd L closepath F
.25 .14051 m
.75 .14051 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00o`3oool]0?ooo`00AP3ooonc000003<0oooo00100?ooo`800000103oool00`000000oooo
0?ooo`2_0?ooo`030000003oool0oooo0340oooo000o0?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00?`3oool010000000oooo0?oo
o`0000030?ooo`800000/03oool00`000000oooo0?ooo`0a0?ooo`00?`3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo0440oooo:`0000130?ooo`030000003oool0oooo0340oooo
000o0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0EP3oool00`000000oooo
0?ooo`1F0?ooo`030000003oool0oooo0340oooo00100?ooo`800000103oool00`000000oooo0?oo
o`1F0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<00000
0?ooo`3oool0EP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0340oooo00160?oo
o`030000003oool0oooo05H0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0a0?oo
o`00AP3oool2000005L0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0a0?ooo`00
AP3oool00`000000oooo0?ooo`0Z0?oooeT00000;03oool00`000000oooo0?ooo`0a0?ooo`00AP3o
ool00`000000oooo0?ooo`0Z0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:P3o
ool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`0Z0?ooo`030000003o0000
o`0005D0o`0000<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`00
0000oooo0?ooo`0Z0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:P3oool00`00
0000oooo0?ooo`0a0?ooo`00AP3oool2000002/0oooo00<000000?l0003o0000E@3o00000`000000
oooo0?ooo`0Z0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo02X0oooo
00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0340oooo
00160?ooo`030000003oool0oooo02X0oooo00<000000?l0003o0000E@3o00000`000000oooo0?oo
o`0Z0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo02X0oooo00<00000
0?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0340oooo00160?oo
o`030000003oool0oooo02X0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?oo
o`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo02X0oooo00<000000?l0003o
0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0340oooo00160?ooo`800000
:`3oool00`000000o`000?l0001E0?l000030000003oool0oooo02X0oooo00<000000?ooo`3oool0
<@3oool004H0oooo00<000000?ooo`3oool0:P3oool00`000000o`000?l0001E0?l000030000003o
ool0oooo02X0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0:P3oool0
0`000000o`000?l0001E0?l000030000003oool0oooo02X0oooo00<000000?ooo`3oool0<@3oool0
04H0oooo00<000000?ooo`3oool0:P3oool00`000000o`000?l0001E0?l000030000003oool0oooo
02X0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0:P3oool00`000000
o`000?l0001E0?l000030000003oool0oooo02X0oooo00<000000?ooo`3oool0<@3oool004H0oooo
00<000000?ooo`3oool0:P3ooomI000002`0oooo00<000000?ooo`3oool0<@3oool004H0oooo0P00
000[0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`0a0?ooo`00AP3oool00`000000oooo0?ooo`0Z0?ooo`030000003o0000o`0005D0o`0000<00000
0?ooo`3oool0:P3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`0Z0?oo
o`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0a0?oo
o`00=03oool2000000@0oooo0P0000040?ooo`800000103oool00`000000oooo0?ooo`0Z0?ooo`03
0000003o0000o`0005D0o`0000<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0a0?ooo`00
<`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool0:P3oool00`000000o`000?l0001E0?l000030000003oool0oooo02X0oooo00<000000?oo
o`3oool0<@3oool003<0oooo00@000000?ooo`3oool000002`3oool010000000oooo0?ooo`3oool2
000002/0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0
oooo0340oooo000c0?ooo`040000003oool0oooo000000T0oooo0P0000040?ooo`030000003oool0
oooo02X0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0
oooo0340oooo000c0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0Z0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:P3oool0
0`000000oooo0?ooo`0a0?ooo`00=03oool2000000X0oooo0`0000030?ooo`030000003oool0oooo
02X0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo
0340oooo00160?ooo`030000003oool0oooo02X0oooo00<000000?l0003o0000E@3o00000`000000
oooo0?ooo`0Z0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo02X0oooo
00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0340oooo
00160?ooo`800000:`3oool00`000000o`000?l0001E0?l000030000003oool0oooo02X0oooo00<0
00000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0:P3oool00`000000o`000?l0001E
0?l000030000003oool0oooo02X0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?oo
o`3oool0:P3oool00`000000o`000?l0001E0?l000030000003oool0oooo02X0oooo00<000000?oo
o`3oool0<@3oool004H0oooo00<000000?ooo`3oool0:P3oool00`000000o`000?l0001E0?l00003
0000003oool0oooo02X0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0
:P3oool00`000000o`000?l0001E0?l000030000003oool0oooo02X0oooo00<000000?ooo`3oool0
<@3oool004H0oooo00<000000?ooo`3oool0:P3oool00`000000o`000?l0001E0?l000030000003o
ool0oooo02X0oooo00<000000?ooo`3oool0<@3oool004H0oooo0P00000[0?ooo`030000003o0000
o`0005D0o`0000<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`00
0000oooo0?ooo`0Z0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:P3oool00`00
0000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`0Z0?ooo`030000003o0000o`0005D0
o`0000<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo
0?ooo`0Z0?ooo`030000003o0000o`0005D0o`0000<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`0Z0?ooo`030000003o0000o`0005D0o`0000<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool2000002/0oooo00<00000
0?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0340oooo00160?oo
o`030000003oool0oooo02X0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?oo
o`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo02X0oooo00<000000?l0003o
0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0340oooo00160?ooo`030000
003oool0oooo02X0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000
003oool0oooo0340oooo00160?ooo`030000003oool0oooo02X0oooo00<000000?l0003o0000E@3o
00000`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0
oooo02X0oooo00<000000?l0003o0000E@3o00000`000000oooo0?ooo`0Z0?ooo`030000003oool0
oooo0340oooo00160?ooo`800000:`3oool00`000000o`000?l0001E0?l000030000003oool0oooo
02X0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0:P3oool00`000000
o`000?l0001E0?l000030000003oool0oooo02X0oooo00<000000?ooo`3oool0<@3oool004H0oooo
00<000000?ooo`3oool0:P3oool00`000000o`000?l0001E0?l000030000003oool0oooo02X0oooo
00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0:P3ooomI000002`0oooo00<0
00000?ooo`3oool0<@3oool003l0oooo1@0000020?ooo`030000003oool0oooo05H0oooo00<00000
0?ooo`3oool0EP3oool00`000000oooo0?ooo`0a0?ooo`00@@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo05H0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0a0?oo
o`00@@3oool00`000000oooo0?ooo`020?ooo`800000E`3oool00`000000oooo0?ooo`1F0?ooo`03
0000003oool0oooo0340oooo00110?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
EP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0340oooo00110?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1F0?ooo`030000003o
ool0oooo0340oooo00100?ooo`800000103oool00`000000oooo0?ooo`1F0?ooo`030000003oool0
oooo05H0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0EP3oool00`00
0000oooo0?ooo`1F0?ooo`030000003oool0oooo0340oooo00160?ooo`800000E`3oool00`000000
oooo0?ooo`1F0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo05H0oooo
00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?oo
o`1F0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<00000
0?ooo`3oool0EP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0340oooo00160?oo
o`030000003oool0oooo05H0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0a0?oo
o`00AP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3o
ool0<@3oool004H0oooo0P00001G0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0
<@3oool004H0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1F0?ooo`030000003o
ool0oooo0340oooo00160?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0EP3oool0
0`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo
05H0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0EP3oool00`000000
oooo0?ooo`1F0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo05H0oooo
00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool2000005L0oooo00<0
00000?ooo`3oool0EP3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`1F
0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?oo
o`3oool0EP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0340oooo00160?ooo`03
0000003oool0oooo05H0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0a0?ooo`00
AP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0
<@3oool004H0oooo0P00001G0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0<@3o
ool004H0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0
oooo0340oooo00160?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0EP3oool00`00
0000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo05H0
oooo00<000000?ooo`3oool0<@3oool003<0oooo1@0000020?ooo`800000103oool2000000@0oooo
00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0340oooo
000e0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`1F0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0<@3oool003D0oooo00<0
00000?ooo`3oool02P3oool010000000oooo0?ooo`3oool200000480oooo:`0000130?ooo`030000
003oool0oooo0340oooo000e0?ooo`030000003oool0oooo00P0oooo0P0000040?ooo`030000003o
ool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool003D0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool0
03@0oooo0P00000:0?ooo`<000000`3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo
0340oooo00160?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo
00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool200000;00oooo00<0
00000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a
0?ooo`00AP3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo00160?ooo`03
0000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0
[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool200000;00oooo00<000000?ooo`3oool0<@3o
ool004H0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`00
0000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo0:l0
oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0[`3oool00`000000oooo
0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo0016
0?ooo`800000/03oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`2_0?oo
o`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3o
ool0<@3oool004H0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3o
ool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0
oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo0P00002`0?ooo`030000003oool0oooo
0340oooo00160?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo
00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00?`3oool4000000<0oooo00<0
00000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00?`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool00400oooo00<000000?oo
o`3oool00`3oool200000;00oooo00<000000?ooo`3oool0<@3oool00440oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo000o0?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00
@03oool2000000@0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3o
ool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0
oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo0P00002`0?ooo`030000003oool0oooo
0340oooo00160?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo
00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?oo
o`2_0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo0:l0oooo00<00000
0?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?oo
o`00AP3oool200000;00oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0
[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`2_0?ooo`030000003o
ool0oooo0340oooo00160?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool0
04H0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool200000;00
oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0[`3oool00`000000oooo
0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo0016
0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?oo
o`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`2_0?ooo`03
0000003oool0oooo0340oooo00160?ooo`800000/03oool00`000000oooo0?ooo`0a0?ooo`00AP3o
ool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0
oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0[`3oool00`00
0000oooo0?ooo`0a0?ooo`00<`3oool4000000<0oooo0P0000040?ooo`800000103oool00`000000
oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo000c0?ooo`030000003oool0oooo00T0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`1E0?ooo`800000F03oool00`000000
oooo0?ooo`0a0?ooo`00=03oool00`000000oooo0?ooo`0;0?ooo`040000003oool0oooo0?ooo`80
0000E@3oool4000005L0oooo00<000000?ooo`3oool0<@3oool003D0oooo00<000000?ooo`3oool0
203oool2000000@0oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`1F0?ooo`030000
003oool0oooo0340oooo000c0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo000d0?ooo`8000002P3o
ool3000000<0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool0
0`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo00160?ooo`800000/03oool00`00
0000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340
oooo00160?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<0
00000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`2_
0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo0:l0oooo00<000000?oo
o`3oool0<@3oool004H0oooo0P00002`0?ooo`030000003oool0oooo0340oooo00160?ooo`030000
003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0[`3o
ool00`000000oooo0?ooo`0a0?ooo`00AP3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0
oooo0340oooo00160?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0
oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool200000;00oooo
00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?oo
o`0a0?ooo`00AP3oool00`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo00160?oo
o`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3oool004H0oooo00<000000?ooo`3o
ool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool200000;00oooo00<000000?ooo`3oool0
<@3oool004H0oooo00<000000?ooo`3oool0[`3oool00`000000oooo0?ooo`0a0?ooo`00AP3oool0
0`000000oooo0?ooo`2_0?ooo`030000003oool0oooo0340oooo00160?ooo`030000003oool0oooo
0:l0oooo00<000000?ooo`3oool0<@3oool00400oooo0P0000040?ooo`030000003oool0oooo0:l0
oooo00<000000?ooo`3oool0<@3oool003l0oooo00@000000?ooo`3oool000000`3oool00`000000
oooo0?ooo`1E0?ooo`<00000E`3oool00`000000oooo0?ooo`0a0?ooo`00@@3oool00`000000oooo
0?ooo`020?ooo`800000EP3oool2000005P0oooo00<000000?ooo`3oool0<@3oool00480oooo00D0
00000?ooo`3oool0oooo0000001F0?ooo`@00000E`3oool00`000000oooo0?ooo`0a0?ooo`00?`3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0
<@3oool00400oooo0P0000040?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0<@3o
ool004H0oooo/`00000c0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {0.101039, -0.0794289, \
0.00563447, 0.0176473}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S6.9.1"]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["BoxOrientation", "MR"],
 " option allows the graph to be oriented so that the bars run in a \
horizontal rather than a vertical direction. This option takes the value ",
 StyleBox["Vertical", "MR"],
 " or ",
 StyleBox["Horizontal", "MR"],
 ", depending on the orientation you desire. "
}], "Text",
 CellTags->{"S6.9.1", "1.13"}],

Cell[TextData[{
 "Labels can be placed for each box via the ",
 StyleBox["BoxLabels", "MR"],
 " option. If this option is ",
 StyleBox["Automatic", "MR"],
 ", no label is drawn when a single box is being plotted, but if multiple \
boxes are being drawn, they are numbered sequentially. If a list of labels is \
provided, they are used cyclically for the boxes. "
}], "Text",
 CellTags->{"S6.9.1", "1.14"}],

Cell[TextData[{
 "You can adjust the spacing between the boxes via the ",
 StyleBox["BoxExtraSpacing", "MR"],
 " option. A space of 1 is equivalent to the space used for a single box. You \
can provide a list for this option, in which case the additional spaces are \
used cyclically. This is useful when you have multiple groups of boxes to be \
drawn, and you want some space between each group. "
}], "Text",
 CellTags->{"S6.9.1", "1.15"}],

Cell[TextData[{
 "The styles used to draw the boxes are determined by the ",
 StyleBox["BoxStyles", "MR"],
 ", ",
 StyleBox["BoxLineStyles", "MR"],
 ", and ",
 StyleBox["BoxMedianStyles", "MR"],
 " options. The ",
 StyleBox["BoxStyles", "MR"],
 " option should be a color or list of colors to be used cyclically among the \
boxes. The style for the lines around the boxes is determined by the ",
 StyleBox["BoxLineStyles", "MR"],
 " option; this may also take a list of styles to be used cyclically. \
Finally, the median line is often drawn somewhat differently than the rest of \
the lines; you can specify additional style options for the median line via \
the ",
 StyleBox["BoxMedianStyles", "MR"],
 " option. "
}], "Text",
 CellTags->{"S6.9.1", "1.16"}],

Cell["\<\
This example mixes multiple data sets in a single plot, and applies a variety \
of options to control the final appearance. \
\>", "MathCaption",
 CellTags->{"S6.9.1", "1.17"}],

Cell[CellGroupData[{

Cell["\<\
BoxWhiskerPlot[dat, datm,
    BoxOrientation -> Horizontal,
    BoxLabels -> {\"a\", \"b\"},
    BoxExtraSpacing -> {0, 0.5},
    BoxStyle -> {Hue[0], Hue[0.5]},
    BoxMedianStyle -> Dashing[{0.05}]
]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 2.4 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0217414 0.963642 2.66667 0.533333 [
[.02174 -0.0125 -3 -9 ]
[.02174 -0.0125 3 0 ]
[.21447 -0.0125 -9 -9 ]
[.21447 -0.0125 9 0 ]
[.4072 -0.0125 -9 -9 ]
[.4072 -0.0125 9 0 ]
[.59993 -0.0125 -9 -9 ]
[.59993 -0.0125 9 0 ]
[.79265 -0.0125 -9 -9 ]
[.79265 -0.0125 9 0 ]
[.98538 -0.0125 -3 -9 ]
[.98538 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 2.13333 -10 -4.90625 ]
[-0.0125 2.13333 0 4.90625 ]
[-0.0125 1.6 -10 -4.90625 ]
[-0.0125 1.6 0 4.90625 ]
[-0.0125 .8 -10 -4.90625 ]
[-0.0125 .8 0 4.90625 ]
[-0.0125 .26667 -10 -4.90625 ]
[-0.0125 .26667 0 4.90625 ]
[ 0 0 -0.125 0 ]
[ 0 2.4 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 2.4 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02174 0 m
.02174 .00625 L
s
[(0)] .02174 -0.0125 0 1 Mshowa
.21447 0 m
.21447 .00625 L
s
[(0.2)] .21447 -0.0125 0 1 Mshowa
.4072 0 m
.4072 .00625 L
s
[(0.4)] .4072 -0.0125 0 1 Mshowa
.59993 0 m
.59993 .00625 L
s
[(0.6)] .59993 -0.0125 0 1 Mshowa
.79265 0 m
.79265 .00625 L
s
[(0.8)] .79265 -0.0125 0 1 Mshowa
.98538 0 m
.98538 .00625 L
s
[(1)] .98538 -0.0125 0 1 Mshowa
.125 Mabswid
.06992 0 m
.06992 .00375 L
s
.11811 0 m
.11811 .00375 L
s
.16629 0 m
.16629 .00375 L
s
.26265 0 m
.26265 .00375 L
s
.31083 0 m
.31083 .00375 L
s
.35902 0 m
.35902 .00375 L
s
.45538 0 m
.45538 .00375 L
s
.50356 0 m
.50356 .00375 L
s
.55174 0 m
.55174 .00375 L
s
.64811 0 m
.64811 .00375 L
s
.69629 0 m
.69629 .00375 L
s
.74447 0 m
.74447 .00375 L
s
.84084 0 m
.84084 .00375 L
s
.88902 0 m
.88902 .00375 L
s
.9372 0 m
.9372 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 2.13333 m
.00625 2.13333 L
s
gsave
-0.0125 2.13333 -71 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 1.6 m
.00625 1.6 L
s
gsave
-0.0125 1.6 -71 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .8 m
.00625 .8 L
s
gsave
-0.0125 .8 -71 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .26667 m
.00625 .26667 L
s
gsave
-0.0125 .26667 -71 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 2.4 L
s
0 2.4 m
1 2.4 L
s
1 0 m
1 2.4 L
s
0 0 m
1 0 L
1 2.4 L
0 2.4 L
closepath
clip
newpath
1 0 0 r
.242 2.26667 m
.242 2 L
.65234 2 L
.65234 2.26667 L
.242 2.26667 L
F
0 g
.5 Mabswid
.242 2.26667 m
.242 2 L
.65234 2 L
.65234 2.26667 L
.242 2.26667 L
s
.03825 2.19733 m
.03825 2.06933 L
s
.03825 2.13333 m
.242 2.13333 L
s
.65234 2.13333 m
.94551 2.13333 L
s
.94551 2.19733 m
.94551 2.06933 L
s
[ .05 ] 0 setdash
.3502 2.26667 m
.3502 2 L
s
0 1 1 r
.30536 1.73333 m
.30536 1.46667 L
.76181 1.46667 L
.76181 1.73333 L
.30536 1.73333 L
F
0 g
[ ] 0 setdash
.30536 1.73333 m
.30536 1.46667 L
.76181 1.46667 L
.76181 1.73333 L
.30536 1.73333 L
s
.02381 1.664 m
.02381 1.536 L
s
.02381 1.6 m
.30536 1.6 L
s
.76181 1.6 m
.97619 1.6 L
s
.97619 1.664 m
.97619 1.536 L
s
[ .05 ] 0 setdash
.55962 1.73333 m
.55962 1.46667 L
s
1 0 0 r
.25014 .93333 m
.25014 .66667 L
.75905 .66667 L
.75905 .93333 L
.25014 .93333 L
F
0 g
[ ] 0 setdash
.25014 .93333 m
.25014 .66667 L
.75905 .66667 L
.75905 .93333 L
.25014 .93333 L
s
.06033 .864 m
.06033 .736 L
s
.06033 .8 m
.25014 .8 L
s
.75905 .8 m
.95861 .8 L
s
.95861 .864 m
.95861 .736 L
s
[ .05 ] 0 setdash
.48222 .93333 m
.48222 .66667 L
s
0 1 1 r
.26975 .4 m
.26975 .13333 L
.83887 .13333 L
.83887 .4 L
.26975 .4 L
F
0 g
[ ] 0 setdash
.26975 .4 m
.26975 .13333 L
.83887 .13333 L
.83887 .4 L
.26975 .4 L
s
.03146 .33067 m
.03146 .20267 L
s
.03146 .26667 m
.26975 .26667 L
s
.83887 .26667 m
.97613 .26667 L
s
.97613 .33067 m
.97613 .20267 L
s
[ .05 ] 0 setdash
.4835 .4 m
.4835 .13333 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00M`3oool2000000D0oooo0P0000040?ooo`8000000`3oool5000000@0oooo0P0000050?oo
o`<000000`3oool2000000<0oooo1@0000040?ooo`800000103oool2000000D0oooo1@00001]0?oo
o`00MP3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000P0oooo00<00000
0?ooo`0000000P3oool00`000000oooo0?ooo`070?ooo`040000003oool00000000000P0oooo00H0
00000?ooo`00000000000?ooo`0000080?ooo`040000003oool0oooo000000H0oooo00<000000?oo
o`3oool0K@3oool007H0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`000009
0?ooo`8000000P3oool00`000000oooo0?ooo`060?ooo`D00000203oool01P000000oooo00000000
0000oooo000000P0oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`1]0?ooo`00
MP3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000X0oooo00@000000?oo
o`3oool00000203oool2000000030?ooo`000000000000P0oooo0`0000020?ooo`030000003oool0
oooo00L0oooo0P0000070?ooo`030000003oool0oooo06d0oooo001f0?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool00000203oool01P000000oooo000000000000oooo000000T0
oooo00@000000?ooo`00000000002@3oool200000080oooo00<000000?ooo`3oool01P3oool01000
0000oooo0?ooo`0000060?ooo`030000003oool0oooo06d0oooo001g0?ooo`8000001@3oool20000
00X0oooo1000000;0?ooo`8000002P3oool4000000X0oooo0P0000060?ooo`800000K`3oool00?l0
oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3oool007H0ooooB000001^0?ooo`00MP3oool00`00
0000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`00
00030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`00
00030?ooo`040000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`04
0000003oool0oooo0?ooo`800000KP3oool007H0oooo00<000000?ooo`3oool0A03oool00`000000
oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo
001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<00000
0?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3o
ool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3o
ool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0
oooo0100oooo:@00000;0?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo
0100oooo00<00000003oo`00ool03000ool00`0000000?oo003oo`0F003oo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0403oool00`000000
0?oo003oo`0<003oo`0300000000ool00?oo01H00?oo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`0@0?ooo`0300000000ool00?oo00`00?oo
00<00000003oo`00ool05P00ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo06`0oooo
001f0?ooo`030000003oool0oooo0100oooo00<00000003oo`00ool03000ool00`0000000?oo003o
o`0F003oo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0K03oool007H0oooo00<00000
0?ooo`000000403oool00`0000000?oo003oo`0<003oo`0300000000ool00?oo01H00?oo00<00000
0?ooo`3oool01`3oool00`000000oooo0000001^0?ooo`00MP3oool00`000000oooo0000000@0?oo
o`0300000000ool00?oo02D00?oo00<000000?ooo`3oool01`3oool00`000000oooo0000001^0?oo
o`00MP3oool00`000000oooo0000000@0?ooo`0300000000ool00?oo02D00?oo00<000000?ooo`3o
ool01`3oool00`000000oooo0000001^0?ooo`00K@3oool4000000D0oooo00<000000?ooo`000000
403oool00`0000000?oo003oo`0<003oo`0300000000ool00?oo01H00?oo00<000000?ooo`3oool0
1`3oool00`000000oooo0000001^0?ooo`00KP3oool010000000oooo0?ooo`0000040?oooa@00000
3P00ool00`0000000?oo003oo`0F003oo`/0000000<0oooo0000003oool0K@3oool006h0oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0000000@0?ooo`0300000000ool00?oo00`00?oo
00<00000003oo`00ool05P00ool00`000000oooo0?ooo`070?ooo`030000003oool0000006h0oooo
001^0?ooo`<000001@3oool00`000000oooo0000000@0?ooo`0300000000ool00?oo00`00?oo00<0
0000003oo`00ool05P00ool00`000000oooo0?ooo`070?ooo`030000003oool0000006h0oooo001^
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000403oool00`0000000?oo003oo`0<
003oo`0300000000ool00?oo01H00?oo00<000000?ooo`3oool01`3oool00`000000oooo0000001^
0?ooo`00K@3oool2000000L0oooo00<000000?ooo`000000403oool00`0000000?oo003oo`0U003o
o`030000003oool0oooo00L0oooo00<000000?ooo`000000KP3oool007H0oooo00<000000?ooo`00
0000403oool00`0000000?oo003oo`0U003oo`030000003oool0oooo00L0oooo00<000000?ooo`00
0000KP3oool007H0oooo00<000000?ooo`3oool0403oool00`0000000?oo003oo`0<003oo`030000
0000ool00?oo01H00?oo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1/0?ooo`00MP3o
ool00`000000oooo0?ooo`0@0?ooo`0300000000ool00?oo00`00?oo00<00000003oo`00ool05P00
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0
oooo0100oooo00<00000003oo`00ool03000ool00`0000000?oo003oo`0F003oo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0403oool00`00
00000?oo003oo`0<003oo`0300000000ool00?oo01H00?oo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`0@0?ooobT000002`3oool00`000000
oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo
001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<00000
0?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3o
ool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3o
ool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0
oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0
oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?oo
o`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00
MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool03`3ooolU
00000100oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool03`3oool00`00
0000o`000?l0000Q0?l000030000003oool0oooo00h0oooo00<000000?ooo`3oool0K03oool007H0
oooo00<000000?ooo`3oool03`3oool00`000000o`000?l0000=0?l000030000003o0000o`000140
o`0000<000000?ooo`3oool03P3oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo
0?ooo`0?0?ooo`030000003o0000o`0000d0o`0000<000000?l0003o00004@3o00000`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo00l0oooo00<0
00000?l0003o00003@3o00000`000000o`000?l0000A0?l000030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0K03oool007H0oooo00D000000?ooo`3oool0oooo0000000=0?ooo`030000003o
0000o`0000d0o`0000<000000?l0003o00004@3o00000`000000oooo0?ooo`0;0?ooo`040000003o
ool0oooo000006h0oooo001f0?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000o`00
0?l0000Q0?l000030000003oool0oooo00/0oooo00@000000?ooo`3oool00000KP3oool007H0oooo
00D000000?ooo`3oool0oooo0000000=0?ooo`030000003o0000o`000240o`0000<000000?ooo`3o
ool02`3oool010000000oooo0?ooo`00001^0?ooo`00KP3oool5000000<0oooo00D000000?ooo`3o
ool0oooo0000000=0?ooo`030000003o0000o`000240o`0000<000000?ooo`3oool02`3oool01000
0000oooo0?ooo`00001^0?ooo`00KP3oool4000000@0oooo00D000000?ooo`3oool0oooo0000000=
0?ooo`030000003o0000o`0000d0o`0000<000000?l0003o00004@3o00000`000000oooo0?ooo`0;
0?ooo`040000003oool0oooo000006h0oooo001a0?ooo`030000003oool0oooo0080oooo0P000002
0?ooo`l000003`3o00000`000000o`000?l0000A0?l000l000000P3oool00`000000oooo0?ooo`1/
0?ooo`00K`3oool3000000@0oooo00D000000?ooo`3oool0oooo0000000=0?ooo`030000003o0000
o`0000d0o`0000<000000?l0003o00004@3o00000`000000oooo0?ooo`0;0?ooo`040000003oool0
oooo000006h0oooo001f0?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000o`000?l0
000=0?l000030000003o0000o`000140o`0000<000000?ooo`3oool02`3oool010000000oooo0?oo
o`00001^0?ooo`00MP3oool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?l0003o0000
8@3o00000`000000oooo0?ooo`0;0?ooo`040000003oool0oooo000006h0oooo001f0?ooo`050000
003oool0oooo0?ooo`0000003@3oool00`000000o`000?l0000Q0?l000030000003oool0oooo00/0
oooo00@000000?ooo`3oool00000KP3oool007H0oooo00<000000?ooo`3oool03`3oool00`000000
o`000?l0000Q0?l000030000003oool0oooo00h0oooo00<000000?ooo`3oool0K03oool007H0oooo
00<000000?ooo`3oool03`3oool00`000000o`000?l0000=0?l000030000003o0000o`000140o`00
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?oo
o`0?0?ooo`030000003o0000o`0000d0o`0000<000000?l0003o00004@3o00000`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo00l0oooo00<00000
0?l0003o00003@3o00000`000000o`000?l0000A0?l000030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool03`3ooolU00000100oooo00<000000?oo
o`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00
MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool0
0`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo
06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo
00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?oo
o`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<00000
0?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?oo
o`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000
003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03o
ool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0
oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0
oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo
0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<0
00000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/
0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`03
0000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0
A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003o
ool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool0
07H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000
oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo
00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?oo
o`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3o
ool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000
003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03o
ool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`00
0000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0
oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo
0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`0C0?ooob400000403oool00`000000oooo0?oo
o`1/0?ooo`00MP3oool00`000000oooo0?ooo`0C0?ooo`0300000000ool00?oo00l00?oo00<00000
003oo`00ool02`00ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo06`0oooo001f0?oo
o`030000003oool0oooo01<0oooo00<00000003oo`00ool03`00ool00`0000000?oo003oo`0;003o
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3o
ool04`3oool00`0000000?oo003oo`0?003oo`0300000000ool00?oo00/00?oo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`0C0?ooo`030000
0000ool00?oo00l00?oo00<00000003oo`00ool02`00ool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo06`0oooo001f0?ooo`030000003oool0000001<0oooo00<00000003oo`00ool07@00
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0000006h0oooo001f0?ooo`030000003oool0
000001<0oooo00<00000003oo`00ool07@00ool00`000000oooo0?ooo`0<0?ooo`030000003oool0
000006h0oooo001f0?ooo`030000003oool0000001<0oooo00<00000003oo`00ool07@00ool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0000006h0oooo001]0?ooo`@000001@3oool00`000000
oooo0000000C0?ooo`0300000000ool00?oo00l00?oo00<00000003oo`00ool02`00ool00`000000
oooo0?ooo`0<0?ooo`030000003oool0000006h0oooo001^0?ooo`040000003oool0oooo000000@0
oooo5`00000A003oo`0300000000ool00?oo00/00?oo400000000`3oool000000?ooo`1]0?ooo`00
KP3oool010000000oooo0?ooo`0000040?ooo`030000003oool0000001<0oooo00<00000003oo`00
ool03`00ool00`0000000?oo003oo`0;003oo`030000003oool0oooo00`0oooo00<000000?ooo`00
0000KP3oool006h0oooo0`0000050?ooo`030000003oool0000001<0oooo00<00000003oo`00ool0
3`00ool00`0000000?oo003oo`0;003oo`030000003oool0oooo00`0oooo00<000000?ooo`000000
KP3oool006h0oooo00<000000?ooo`3oool01@3oool00`000000oooo0000000C0?ooo`0300000000
ool00?oo00l00?oo00<00000003oo`00ool02`00ool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0000006h0oooo001]0?ooo`8000001`3oool00`000000oooo0000000C0?ooo`0300000000ool0
0?oo01d00?oo00<000000?ooo`3oool0303oool00`000000oooo0000001^0?ooo`00MP3oool00`00
0000oooo0000000C0?ooo`0300000000ool00?oo01d00?oo00<000000?ooo`3oool0303oool00`00
0000oooo0000001^0?ooo`00MP3oool00`000000oooo0?ooo`0C0?ooo`0300000000ool00?oo00l0
0?oo00<00000003oo`00ool02`00ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo06`0
oooo001f0?ooo`030000003oool0oooo01<0oooo00<00000003oo`00ool03`00ool00`0000000?oo
003oo`0;003oo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0K03oool007H0oooo00<0
00000?ooo`3oool04`3oool00`0000000?oo003oo`0?003oo`0300000000ool00?oo00/00?oo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`0C
0?ooo`0300000000ool00?oo00l00?oo00<00000003oo`00ool02`00ool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo01<0oooo8@00000@0?oo
o`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3o
ool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3o
ool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0
oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0
oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?oo
o`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00
MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003o
ool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool0
0`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo
06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo
00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?oo
o`0>0?oooah00000603oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`0>
0?ooo`030000003o0000o`0001X0o`0000<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1/
0?ooo`00MP3oool00`000000oooo0?ooo`0>0?ooo`030000003o0000o`0000D0o`0000<000000?l0
003o00004P3o00000`000000oooo0?ooo`0F0?ooo`030000003oool0oooo06`0oooo001f0?ooo`03
0000003oool0oooo00h0oooo00<000000?l0003o00001@3o00000`000000o`000?l0000B0?l00003
0000003oool0oooo01H0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0
3P3oool00`000000o`000?l000050?l000030000003o0000o`000180o`0000<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`1/0?ooo`00MP3oool010000000oooo0?ooo`00000=0?ooo`030000
003o0000o`0000D0o`0000<000000?l0003o00004P3o00000`000000oooo0?ooo`0B0?ooo`050000
003oool0oooo0?ooo`000000KP3oool007H0oooo00@000000?ooo`3oool000003@3oool00`000000
o`000?l0000J0?l000030000003oool0oooo0180oooo00D000000?ooo`3oool0oooo0000001^0?oo
o`00MP3oool010000000oooo0?ooo`00000=0?ooo`030000003o0000o`0001X0o`0000<000000?oo
o`3oool04P3oool01@000000oooo0?ooo`3oool0000006h0oooo001^0?ooo`D000000`3oool01000
0000oooo0?ooo`00000=0?ooo`030000003o0000o`0001X0o`0000<000000?ooo`3oool04P3oool0
1@000000oooo0?ooo`3oool0000006h0oooo001^0?ooo`@00000103oool010000000oooo0?ooo`00
000=0?ooo`030000003o0000o`0000D0o`0000<000000?l0003o00004P3o00000`000000oooo0?oo
o`0B0?ooo`050000003oool0oooo0?ooo`000000KP3oool00740oooo00<000000?ooo`3oool00P3o
ool2000000030?ooo`000000000000d000001`3o00000`000000o`000?l0000B0?l001H000000`3o
ool00`000000oooo0?ooo`1/0?ooo`00K`3oool3000000@0oooo00@000000?ooo`3oool000003@3o
ool00`000000o`000?l000050?l000030000003o0000o`000180o`0000<000000?ooo`3oool04P3o
ool01@000000oooo0?ooo`3oool0000006h0oooo001f0?ooo`040000003oool0oooo000000d0oooo
00<000000?l0003o00001@3o00000`000000o`000?l0000B0?l000030000003oool0oooo0180oooo
00D000000?ooo`3oool0oooo0000001^0?ooo`00MP3oool010000000oooo0?ooo`00000=0?ooo`03
0000003o0000o`0001X0o`0000<000000?ooo`3oool04P3oool01@000000oooo0?ooo`3oool00000
06h0oooo001f0?ooo`040000003oool0oooo000000d0oooo00<000000?l0003o00006P3o00000`00
0000oooo0?ooo`0B0?ooo`050000003oool0oooo0?ooo`000000KP3oool007H0oooo00<000000?oo
o`3oool03P3oool00`000000o`000?l0000J0?l000030000003oool0oooo01H0oooo00<000000?oo
o`3oool0K03oool007H0oooo00<000000?ooo`3oool03P3oool00`000000o`000?l000050?l00003
0000003o0000o`000180o`0000<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1/0?ooo`00
MP3oool00`000000oooo0?ooo`0>0?ooo`030000003o0000o`0000D0o`0000<000000?l0003o0000
4P3o00000`000000oooo0?ooo`0F0?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003o
ool0oooo00h0oooo00<000000?l0003o00001@3o00000`000000o`000?l0000B0?l000030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool03P3ooolN
000001P0oooo00<000000?ooo`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0
oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0K03oool007H0oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00MP3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo06`0oooo001f0?ooo`030000003oool0oooo04@0oooo00<000000?oo
o`3oool0K03oool007H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`1/0?ooo`00
MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo06`0oooo001f0?ooodP00000KP3o
ool00001\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-1.77096, -5.26295, 0.0147268, \
0.0266087}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S6.9.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pareto Plots", "Subsubsection",
 CellTags->{"S6.9.1", "1.18"}],

Cell["\<\
The Pareto plot is a quality control plot that combines a bar chart \
displaying percentages of categories in the data with a line plot showing \
cumulative percentages of the categories. \
\>", "Text",
  CellTags->{"S6.9.1", "1.19"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ParetoPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["find frequencies of data in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and create a Pareto plot",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ParetoPlot[{{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["cat",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["freq",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["cat",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["freq",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "create a Pareto plot from the categories with given frequencies",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.9.1"],

Cell["Pareto plots. ", "Caption",
 CellTags->"S6.9.1"],

Cell[TextData[{
 "In the most basic form, ",
 StyleBox["ParetoPlot", "MR"],
 " takes a list of data that is assumed to consist of discrete categories. It \
determines the frequency of each category in the list, converts the \
frequencies to percentages, and creates the plot. "
}], "Text",
 CellTags->{"S6.9.1", "1.20"}],

Cell["\<\
Create a Pareto plot from a list. Note that the data does not need to be \
numerical. \
\>", "MathCaption",
 CellTags->{"S6.9.1", "1.21"}],

Cell[CellGroupData[{

Cell["\<\
ParetoPlot[
   {a, b, c, d, d, d, e, d, e, e, f, a, b, c}
]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0645161 0.16129 0 0.618034 [
[.09677 -0.0125 -5 -9.8125 ]
[.09677 -0.0125 5 0 ]
[.25806 -0.0125 -5 -9.8125 ]
[.25806 -0.0125 5 0 ]
[.41935 -0.0125 -5 -9.8125 ]
[.41935 -0.0125 5 0 ]
[.58065 -0.0125 -5 -9.8125 ]
[.58065 -0.0125 5 0 ]
[.74194 -0.0125 -5 -9.8125 ]
[.74194 -0.0125 5 0 ]
[.90323 -0.0125 -5 -9.8125 ]
[.90323 -0.0125 5 0 ]
[-0.0125 .12361 -18 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .24721 -18 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .37082 -18 -4.5 ]
[-0.0125 .37082 0 4.5 ]
[-0.0125 .49443 -18 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.09677 0 m
.09677 .00625 L
s
gsave
.09677 -0.0125 -66 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(d) show
1.000 setlinewidth
grestore
.25806 0 m
.25806 .00625 L
s
gsave
.25806 -0.0125 -66 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
1.000 setlinewidth
grestore
.41935 0 m
.41935 .00625 L
s
gsave
.41935 -0.0125 -66 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(c) show
1.000 setlinewidth
grestore
.58065 0 m
.58065 .00625 L
s
gsave
.58065 -0.0125 -66 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(b) show
1.000 setlinewidth
grestore
.74194 0 m
.74194 .00625 L
s
gsave
.74194 -0.0125 -66 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
1.000 setlinewidth
grestore
.90323 0 m
.90323 .00625 L
s
gsave
.90323 -0.0125 -66 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
s
0 .12361 m
.00625 .12361 L
s
[(0.2)] -0.0125 .12361 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(0.4)] -0.0125 .24721 1 0 Mshowa
0 .37082 m
.00625 .37082 L
s
[(0.6)] -0.0125 .37082 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(0.8)] -0.0125 .49443 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(1)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0309 m
.00375 .0309 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .15451 m
.00375 .15451 L
s
0 .18541 m
.00375 .18541 L
s
0 .21631 m
.00375 .21631 L
s
0 .27812 m
.00375 .27812 L
s
0 .30902 m
.00375 .30902 L
s
0 .33992 m
.00375 .33992 L
s
0 .40172 m
.00375 .40172 L
s
0 .43262 m
.00375 .43262 L
s
0 .46353 m
.00375 .46353 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .58713 m
.00375 .58713 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.03226 0 m
.03226 .17658 L
.16129 .17658 L
.16129 0 L
F
0 g
.5 Mabswid
.03226 0 m
.03226 .17658 L
.16129 .17658 L
.16129 0 L
.03226 0 L
s
1 0 0 r
.19355 0 m
.19355 .13244 L
.32258 .13244 L
.32258 0 L
F
0 g
.19355 0 m
.19355 .13244 L
.32258 .13244 L
.32258 0 L
.19355 0 L
s
1 0 0 r
.35484 0 m
.35484 .08829 L
.48387 .08829 L
.48387 0 L
F
0 g
.35484 0 m
.35484 .08829 L
.48387 .08829 L
.48387 0 L
.35484 0 L
s
1 0 0 r
.51613 0 m
.51613 .08829 L
.64516 .08829 L
.64516 0 L
F
0 g
.51613 0 m
.51613 .08829 L
.64516 .08829 L
.64516 0 L
.51613 0 L
s
1 0 0 r
.67742 0 m
.67742 .08829 L
.80645 .08829 L
.80645 0 L
F
0 g
.67742 0 m
.67742 .08829 L
.80645 .08829 L
.80645 0 L
.67742 0 L
s
1 0 0 r
.83871 0 m
.83871 .04415 L
.96774 .04415 L
.96774 0 L
F
0 g
.83871 0 m
.83871 .04415 L
.96774 .04415 L
.96774 0 L
.83871 0 L
s
.001 w
.09677 .17658 m
.25806 .30902 L
.41935 .39731 L
.58065 .4856 L
.74194 .57389 L
.90323 .61803 L
s
.0001 w
.09677 .17658 -1.875 0 Mabsadd m
.09677 .17658 0 2.5 Mabsadd L
.09677 .17658 1.875 0 Mabsadd L
.09677 .17658 0 -2.5 Mabsadd L
.09677 .17658 -1.875 0 Mabsadd L closepath F
.25806 .30902 -1.875 0 Mabsadd m
.25806 .30902 0 2.5 Mabsadd L
.25806 .30902 1.875 0 Mabsadd L
.25806 .30902 0 -2.5 Mabsadd L
.25806 .30902 -1.875 0 Mabsadd L closepath F
.41935 .39731 -1.875 0 Mabsadd m
.41935 .39731 0 2.5 Mabsadd L
.41935 .39731 1.875 0 Mabsadd L
.41935 .39731 0 -2.5 Mabsadd L
.41935 .39731 -1.875 0 Mabsadd L closepath F
.58065 .4856 -1.875 0 Mabsadd m
.58065 .4856 0 2.5 Mabsadd L
.58065 .4856 1.875 0 Mabsadd L
.58065 .4856 0 -2.5 Mabsadd L
.58065 .4856 -1.875 0 Mabsadd L closepath F
.74194 .57389 -1.875 0 Mabsadd m
.74194 .57389 0 2.5 Mabsadd L
.74194 .57389 1.875 0 Mabsadd L
.74194 .57389 0 -2.5 Mabsadd L
.74194 .57389 -1.875 0 Mabsadd L closepath F
.90323 .61803 -1.875 0 Mabsadd m
.90323 .61803 0 2.5 Mabsadd L
.90323 .61803 1.875 0 Mabsadd L
.90323 .61803 0 -2.5 Mabsadd L
.90323 .61803 -1.875 0 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00=@3oool4000002H0oooo0`00
000X0?ooo`<000009@3oool4000002L0oooo1@00000U0?ooo`@000008@3oool003@0oooo00@00000
0?ooo`3oool000009P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02L0oooo00@0
00000?ooo`3oool000009P3oool4000002L0oooo00<000000?ooo`3oool08@3oool003@0oooo00@0
00000?ooo`3oool000009P3oool4000002L0oooo00<000000?ooo`3oool09`3oool010000000oooo
0?ooo`00000Y0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool08@3oool003D0oooo
0`00000W0?ooo`800000:@3oool3000002H0oooo0`00000X0?ooo`<000009P3oool400000240oooo
000g0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?oo
o`0Q0?ooo`00=P3oool2000007X0oooo0P00001E0?ooo`8000008@3oool00?l0oooo;@3oool00?l0
oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3oool001d0ooooo`000007000000T0oooo000M0?oo
o`030000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`060?oo
o`030000003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000N0?l0
00030000003oool0oooo00H0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`050?oo
o`030000003o0000o`0001l0o`0000<000000?ooo`3oool01@3oool00`000000o`000?l0000O0?l0
00030000003oool0oooo00l0oooo000M0?ooo`030000003oool0oooo00D0oooo00<000000?l0003o
00007`3o00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001h0o`0000<000000?ooo`3o
ool01P3oool00`000000o`000?l0000N0?l000030000003oool0oooo00H0oooo00<000000?l0003o
00007`3o00000`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3o
ool01@3oool00`000000o`000?l0000O0?l000030000003oool0oooo00l0oooo000M0?ooo`030000
003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`060?ooo`030000
003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000N0?l000030000
003oool0oooo00H0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`050?ooo`030000
003o0000o`0001l0o`0000<000000?ooo`3oool01@3oool00`000000o`000?l0000O0?l000030000
003oool0oooo00l0oooo000M0?ooo`030000003oool0oooo00D0oooo00<000000?l0003o00007`3o
00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001h0o`0000<000000?ooo`3oool01P3o
ool00`000000o`000?l0000N0?l000030000003oool0oooo00H0oooo00<000000?l0003o00007`3o
00000`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool01@3o
ool00`000000o`000?l0000O0?l000030000003oool0oooo00l0oooo000M0?ooo`030000003oool0
oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`060?ooo`030000003o0000
o`0001h0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000N0?l000030000003oool0
oooo00H0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`050?ooo`030000003o0000
o`0001l0o`0000<000000?ooo`3oool01@3oool00`000000o`000?l0000O0?l000030000003oool0
oooo00l0oooo000M0?ooo`030000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`00
0000oooo0?ooo`060?ooo`030000003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`00
0000o`000?l0000N0?l000030000003oool0oooo00H0oooo00<000000?l0003o00007`3o00000`00
0000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool01@3oool00`00
0000o`000?l0000O0?l000030000003oool0oooo00l0oooo000M0?ooo`030000003oool0oooo00D0
oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001h0
o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000N0?l000030000003oool0oooo00H0
oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0
o`0000<000000?ooo`3oool01@3oool00`000000o`000?l0000O0?l000030000003oool0oooo00l0
oooo000M0?ooo`8000001P3oool00`000000o`000?l0000O0?l000030000003oool0oooo00H0oooo
00<000000?l0003o00007P3o00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001h0o`00
00<000000?ooo`3oool01P3oool00`000000o`000?l0000O0?l000030000003oool0oooo00D0oooo
00<000000?l0003o00007`3o00000`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`00
00<000000?ooo`3oool03`3oool001d0oooo00<000000?ooo`3oool01@3oool00`000000o`000?l0
000O0?l000030000003oool0oooo00H0oooo00<000000?l0003o00007P3o00000`000000oooo0?oo
o`060?ooo`030000003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0
000O0?l000030000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?oo
o`050?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool03`3oool001d0oooo00<00000
0?ooo`3oool01@3oool00`000000o`000?l0000O0?l000030000003oool0oooo00H0oooo00<00000
0?l0003o00007P3o00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001h0o`0000<00000
0?ooo`3oool01P3oool00`000000o`000?l0000O0?l000030000003oool0oooo00D0oooo00<00000
0?l0003o00007`3o00000`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`0000<00000
0?ooo`3oool03`3oool001d0oooo00<000000?ooo`3oool01@3oool00`000000o`000?l0000O0?l0
00030000003oool0oooo00H0oooo00<000000?l0003o00007P3o00000`000000oooo0?ooo`060?oo
o`030000003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000O0?l0
00030000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`050?oo
ob<000004@3oool001d0oooo00<000000?ooo`3oool01@3oool00`000000o`000?l0000O0?l00003
0000003oool0oooo00H0oooo00<000000?l0003o00007P3o00000`000000oooo0?ooo`060?ooo`03
0000003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000O0?l00003
0000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`0i0?ooo`00
7@3oool00`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool0
1P3oool00`000000o`000?l0000N0?l000030000003oool0oooo00H0oooo00<000000?l0003o0000
7P3o00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool0
1@3oool00`000000o`000?l0000O0?l000030000003oool0oooo03T0oooo000M0?ooo`030000003o
ool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`060?ooo`030000003o
0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000N0?l000030000003o
ool0oooo00H0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`050?ooo`030000003o
0000o`0001l0o`0000<000000?ooo`3oool0>@3oool001d0oooo00<000000?ooo`3oool01@3oool0
0`000000o`000?l0000O0?l000030000003oool0oooo00H0oooo00<000000?l0003o00007P3o0000
0`000000oooo0?ooo`060?ooo`030000003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool0
0`000000o`000?l0000O0?l000030000003oool0oooo00D0oooo00<000000?l0003o00007`3o0000
0`000000oooo0?ooo`0i0?ooo`007@3oool2000000H0oooo00<000000?l0003o00007`3o00000`00
0000oooo0?ooo`060?ooo`030000003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`00
0000o`000?l0000N0?l000030000003oool0oooo00H0oooo00<000000?l0003o00007`3o00000`00
0000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool0>@3oool001d0
oooo00<000000?ooo`3oool01@3oool00`000000o`000?l0000O0?l000030000003oool0oooo00H0
oooo00<000000?l0003o00007P3o00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001h0
o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000O0?l000030000003oool0oooo00D0
oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`0i0?ooo`007@3oool00`000000oooo
0?ooo`050?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool01P3oool00`000000o`00
0?l0000N0?l000030000003oool0oooo00H0oooo00<000000?l0003o00007P3o00000`000000oooo
0?ooo`060?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool01@3oool00`000000o`00
0?l0000O0?l000030000003oool0oooo03T0oooo000M0?ooo`030000003oool0oooo00D0oooo00<0
00000?l0003o00007`3o00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001h0o`0000<0
00000?ooo`3oool01P3oool00`000000o`000?l0000N0?l000030000003oool0oooo00H0oooo00<0
00000?l0003o00007`3o00000`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`0000<0
00000?ooo`3oool0>@3oool001d0oooo00<000000?ooo`3oool01@3oool00`000000o`000?l0000O
0?l000030000003oool0oooo00H0oooo00<000000?l0003o00007P3o00000`000000oooo0?ooo`06
0?ooo`030000003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000O
0?l000030000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`0i
0?ooo`007@3oool00`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`0000<000000?oo
o`3oool01P3oool00`000000o`000?l0000N0?l000030000003oool0oooo00H0oooo00<000000?l0
003o00007P3o00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001l0o`0000<000000?oo
o`3oool01@3oool00`000000o`000?l0000O0?l000030000003oool0oooo03T0oooo000M0?ooo`03
0000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`060?ooo`03
0000003o0000o`0001h0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000N0?l00003
0000003oool0oooo00H0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`050?ooo`03
0000003o0000o`0001l0o`0000<000000?ooo`3oool0>@3oool001d0oooo00<000000?ooo`3oool0
1@3oool00`000000o`000?l0000O0?l000030000003oool0oooo00H0oooo00<000000?l0003o0000
7P3o00000`000000oooo0?ooo`060?ooob800000203ooolS000000L0oooo8`00000k0?ooo`007@3o
ool2000000H0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`060?ooo`030000003o
0000o`0001h0o`0000<000000?ooo`3oool0^03oool001d0oooo00<000000?ooo`3oool01@3oool0
0`000000o`000?l0000O0?l000030000003oool0oooo00H0oooo00<000000?l0003o00007P3o0000
0`000000oooo0?ooo`2h0?ooo`007@3oool00`000000oooo0?ooo`050?ooo`030000003o0000o`00
01l0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0000N0?l000030000003oool0oooo
0;P0oooo000M0?ooo`030000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000
oooo0?ooo`060?ooo`030000003o0000o`0001h0o`0000<000000?ooo`3oool0^03oool001d0oooo
00<000000?ooo`3oool01@3oool00`000000o`000?l0000O0?l000030000003oool0oooo00H0oooo
00<000000?l0003o00007P3o00000`000000oooo0?ooo`2h0?ooo`007@3oool00`000000oooo0?oo
o`050?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool01P3oool00`000000o`000?l0
000N0?l000030000003oool0oooo0;P0oooo000:0?ooo`800000103oool2000000<0oooo10000004
0?ooo`030000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`06
0?ooo`030000003o0000o`0001h0o`0000<000000?ooo`3oool0^03oool000T0oooo00@000000?oo
o`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<00000
0?l0003o00007`3o00000`000000oooo0?ooo`060?ooo`030000003o0000o`0001h0o`0000<00000
0?ooo`3oool0^03oool000T0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`04
0?ooo`<000001@3oool00`000000o`000?l0000O0?l000030000003oool0oooo00H0oooo00<00000
0?l0003o00007P3o00000`000000oooo0?ooo`2h0?ooo`002@3oool010000000oooo0?ooo`00000:
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000o`000?l0000O
0?l000030000003oool0oooo00H0oooo00<000000?l0003o00007P3o00000`000000oooo0?ooo`2h
0?ooo`002@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool01@3oool00`000000o`000?l0000O0?l000030000003oool0oooo00H0oooo8P00
002j0?ooo`002P3oool2000000X0oooo0P0000050?ooo`030000003oool0oooo00D0oooo00<00000
0?l0003o00007`3o00000`000000oooo0?ooo`3R0?ooo`007@3oool00`000000oooo0?ooo`050?oo
o`030000003o0000o`0001l0o`0000<000000?ooo`3oool0hP3oool001d0oooo00<000000?ooo`3o
ool01@3oool00`000000o`000?l0000O0?l000030000003oool0oooo0>80oooo000M0?ooo`030000
003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000oooo0?ooo`3R0?ooo`007@3o
ool00`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool0hP3o
ool001d0oooo0P0000060?ooo`030000003o0000o`0001l0o`0000<000000?ooo`3oool0hP3oool0
01d0oooo00<000000?ooo`3oool01@3oool00`000000o`000?l0000O0?l000030000003oool0oooo
0>80oooo000M0?ooo`030000003oool0oooo00D0oooo00<000000?l0003o00007`3o00000`000000
oooo0?ooo`3R0?ooo`007@3oool00`000000oooo0?ooo`050?ooo`030000003o0000o`0001l0o`00
00<000000?ooo`3oool0hP3oool001d0oooo00<000000?ooo`3oool01@3oool00`000000o`000?l0
000>0?l000030000003o0000o`0000h0o`0000<000000?ooo`3oool0hP3oool001d0oooo00<00000
0?ooo`3oool01@3oool00`000000o`000?l0000=0?l000<000003`3o00000`000000oooo0?ooo`3R
0?ooo`007@3oool00`000000oooo0?ooo`050?ooob<00000i03oool001d0oooo00<000000?ooo`3o
ool05@3oool300000?@0oooo000M0?ooo`8000006@3oool200000?80oooo000M0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool0k`3oool001d0oooo00<000000?ooo`3oool06`3oool0
0`000000oooo0?ooo`3^0?ooo`007@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
0>d0oooo000M0?ooo`030000003oool0oooo01d0oooo0P00003]0?ooo`007@3oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo0>X0oooo000M0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool0j@3oool001d0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`3X
0?ooo`007@3oool2000002<0oooo00<000000?ooo`3oool0i`3oool001d0oooo00<000000?ooo`3o
ool08`3oool200000>L0oooo000M0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
i03oool001d0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`3S0?ooo`007@3oool0
0`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0>80oooo000M0?ooo`030000003oool0oooo
02P0oooo0P00003R0?ooo`002P3oool2000000@0oooo0P0000050?ooo`<000000`3oool00`000000
oooo0?ooo`0Z0?ooo`030000003oool0oooo0=l0oooo00090?ooo`040000003oool0oooo000000/0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo0=h0
oooo00090?ooo`040000003oool0oooo000000P0oooo1@0000030?ooo`<00000;03oool00`000000
oooo0?ooo`3M0?ooo`002@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool0;@3oool200000=d0oooo00090?ooo`040000003oool0oooo0000
00T0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo
0=X0oooo000:0?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3oool0<03oool00`000000
oooo0?ooo`3I0?ooo`007@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0=P0oooo
000M0?ooo`030000003oool0oooo0380oooo0P00003H0?ooo`007@3oool00`000000oooo0?ooo`0d
0?ooo`030000003oool0oooo0=D0oooo000M0?ooo`030000003oool0oooo03D0oooo00<000000?oo
o`3oool0e03oool001d0oooo0P00000g0?ooo`030000003oool0oooo0=<0oooo000M0?ooo`030000
003oool0oooo03L0oooo00<000000?ooo`3oool0dP3oool001d0oooo00<000000?ooo`3oool0>03o
ool200000=80oooo000M0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0c`3oool0
01d0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`3>0?ooo`007@3oool00`000000
oooo0?ooo`0l0?ooo`030000003oool0oooo0<d0oooo000M0?ooo`030000003oool0oooo03d0oooo
0P00003=0?ooo`007@3oool00`000000oooo0?ooo`0o0?ooo`800000b`3oool001d0oooo0P000010
0?ooo`<00000bP3oool001d0oooo00<000000?ooo`3oool0@03oool300000<T0oooo000M0?ooo`03
0000003oool0oooo0400oooo00<000000?ooo`3oool00P0000370?ooo`007@3oool00`000000oooo
0?ooo`150?ooo`800000a@3oool001d0oooo00<000000?ooo`3oool0A`3oool200000<<0oooo000M
0?ooo`030000003oool0oooo04T0oooo0P0000310?ooo`007@3oool00`000000oooo0?ooo`1;0?oo
o`800000_`3oool001d0oooo00<000000?ooo`3oool0C@3oool200000;d0oooo000M0?ooo`800000
D03oool00`000000oooo0?ooo`2j0?ooo`007@3oool00`000000oooo0?ooo`1@0?ooo`800000^P3o
ool001d0oooo00<000000?ooo`3oool0DP3oool200000;P0oooo000M0?ooo`030000003oool0oooo
05@0oooo0P00002f0?ooo`007@3oool00`000000oooo0?ooo`1F0?ooo`800000]03oool001d0oooo
00<000000?ooo`3oool0F03oool200000;80oooo000:0?ooo`800000103oool2000000<0oooo0`00
00050?ooo`030000003oool0oooo05X0oooo0P00002`0?ooo`002@3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0G03oool00`000000oooo
0?ooo`2]0?ooo`002@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0
oooo0`00001M0?ooo`800000[@3oool000T0oooo00@000000?ooo`3oool00000203oool3000000D0
oooo00<000000?ooo`3oool0G`3oool200000:/0oooo00090?ooo`040000003oool0oooo000000T0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1Q0?ooo`800000Z@3oool000X0oooo
0P00000:0?ooo`<00000103oool00`000000oooo0?ooo`1S0?ooo`800000Y`3oool001d0oooo00<0
00000?ooo`3oool0I@3oool200000:D0oooo000M0?ooo`030000003oool0oooo06L0oooo0P00002S
0?ooo`007@3oool00`000000oooo0?ooo`1Y0?ooo`<00000X03oool001d0oooo00<000000?ooo`3o
ool0J@3oool300000:00oooo000M0?ooo`800000J`3oool4000009h0oooo000M0?ooo`030000003o
ool0oooo06/0oooo00<000000?ooo`3oool00P00002L0?ooo`007@3oool00`000000oooo0?ooo`1`
0?ooo`800000VP3oool001d0oooo00<000000?ooo`3oool0LP3oool2000009P0oooo000M0?ooo`03
0000003oool0oooo07@0oooo0P00002F0?ooo`007@3oool00`000000oooo0?ooo`1f0?ooo`030000
003oool0oooo09<0oooo000M0?ooo`030000003oool0oooo07L0oooo0P00002C0?ooo`007@3oool0
0`000000oooo0?ooo`1i0?ooo`800000T@3oool001d0oooo00<000000?ooo`3oool0N`3oool20000
08l0oooo000M0?ooo`800000OP3oool2000008d0oooo000M0?ooo`030000003oool0oooo07l0oooo
00<000000?ooo`3oool0RP3oool001d0oooo00<000000?ooo`3oool0P03oool2000008X0oooo000M
0?ooo`030000003oool0oooo0880oooo0P0000280?ooo`007@3oool00`000000oooo0?ooo`240?oo
o`800000QP3oool001d0oooo00<000000?ooo`3oool0QP3oool2000008@0oooo000M0?ooo`030000
003oool0oooo08P0oooo0P0000220?ooo`007@3oool00`000000oooo0?ooo`2:0?ooo`030000003o
ool0oooo07l0oooo000M0?ooo`800000S03oool2000007l0oooo000M0?ooo`030000003oool0oooo
08d0oooo0P00001m0?ooo`007@3oool00`000000oooo0?ooo`2?0?ooo`800000N`3oool001d0oooo
00<000000?ooo`3oool0T@3oool2000007T0oooo000M0?ooo`030000003oool0oooo09<0oooo0`00
001f0?ooo`007@3oool00`000000oooo0?ooo`2C0?ooo`@00000M@3oool000X0oooo0P0000040?oo
o`800000103oool2000000D0oooo00<000000?ooo`3oool0U03oool4000007@0oooo00090?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`2E
0?ooo`030000003oool0oooo00800000LP3oool000T0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000040?ooo`<00000VP3oool200000700oooo00090?ooo`040000003oool0
oooo000000T0oooo0P0000050?ooo`030000003oool0oooo09`0oooo0P00001^0?ooo`002@3oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
WP3oool2000006`0oooo000:0?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3oool0X03o
ool00`000000oooo0?ooo`1Y0?ooo`007@3oool00`000000oooo0?ooo`2Q0?ooo`800000J@3oool0
01d0oooo00<000000?ooo`3oool0X`3oool2000006L0oooo000M0?ooo`030000003oool0oooo0:D0
oooo0P00001U0?ooo`007@3oool00`000000oooo0?ooo`2W0?ooo`800000H`3oool001d0oooo0P00
002Z0?ooo`030000003oool0oooo0600oooo000M0?ooo`030000003oool0oooo0:X0oooo0P00001P
0?ooo`007@3oool00`000000oooo0?ooo`2/0?ooo`800000GP3oool001d0oooo00<000000?ooo`3o
ool0[P3oool2000005`0oooo000M0?ooo`030000003oool0oooo0;00oooo0P00001J0?ooo`007@3o
ool00`000000oooo0?ooo`2b0?ooo`800000F03oool001d0oooo00<000000?ooo`3oool0]03oool0
0`000000oooo0?ooo`1E0?ooo`007@3oool00`000000oooo0?ooo`2e0?ooo`800000E@3oool001d0
oooo0P00002h0?ooo`800000D`3oool001d0oooo00<000000?ooo`3oool0^@3oool200000540oooo
000M0?ooo`030000003oool0oooo0;/0oooo0P00001?0?ooo`007@3oool00`000000oooo0?ooo`2m
0?ooo`<00000C03oool001d0oooo00<000000?ooo`3oool0_@3oool4000004/0oooo000M0?ooo`03
0000003oool0oooo0;h0oooo1`0000170?ooo`007@3oool00`000000oooo0?ooo`2o0?ooo`030000
003oool0oooo00<0oooo0`0000140?ooo`007@3oool00`000000oooo0?ooo`380?ooo`@00000@03o
ool001d0oooo0P00003=0?ooo`<00000?@3oool001d0oooo00<000000?ooo`3oool0c`3oool40000
03T0oooo000M0?ooo`030000003oool0oooo0=<0oooo0`00000f0?ooo`007@3oool00`000000oooo
0?ooo`3F0?ooo`@00000<P3oool001d0oooo00<000000?ooo`3oool0fP3oool3000002l0oooo000M
0?ooo`030000003oool0oooo0=d0oooo1000000[0?ooo`005@3oool5000000<0oooo00<000000?oo
o`3oool0h@3oool3000000D0oooo00<000000?ooo`3oool0803oool001L0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`3T0?ooo`L000008@3oool001L0oooo00<000000?ooo`3oool0
0`3oool300000>L0oooo1000000Q0?ooo`005`3oool00`000000oooo0?ooo`3o0?oooa<0oooo000G
0?ooo`030000003oool0oooo0?l0oooo4`3oool001H0oooo0P00003o0?oooaD0oooo003o0?ooobd0
oooo0000\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.301198, -0.0810184, \
0.0237379, 0.00619494}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S6.9.1"]
}, Open  ]],

Cell[TextData[{
 "If you have data where the frequencies are precomputed, you can plot it \
directly by providing ",
 StyleBox["{", "MR"],
 StyleBox["category", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["frequency", "TI"],
 StyleBox["}", "MR"],
 " pairs instead of the raw data to ",
 StyleBox["ParetoPlot", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.9.1", "1.22"}],

Cell["\<\
The data quantities have been precomputed for this Pareto plot. \
\>", "MathCaption",
 CellTags->{"S6.9.1", "1.23"}],

Cell[CellGroupData[{

Cell["\<\
ParetoPlot[
   {{\"Oats\", 34.3},{\"Wheat\", 72.1}, {\"Rye\", 10.2}, {\"Soy\", 68.2}}
]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0952381 0.238095 0 0.618034 [
[.14286 -0.0125 -17 -9.8125 ]
[.14286 -0.0125 17 0 ]
[.38095 -0.0125 -11 -9.8125 ]
[.38095 -0.0125 11 0 ]
[.61905 -0.0125 -14 -9.8125 ]
[.61905 -0.0125 14 0 ]
[.85714 -0.0125 -11 -9.8125 ]
[.85714 -0.0125 11 0 ]
[-0.0125 .12361 -18 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .24721 -18 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .37082 -18 -4.5 ]
[-0.0125 .37082 0 4.5 ]
[-0.0125 .49443 -18 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.14286 0 m
.14286 .00625 L
s
gsave
.14286 -0.0125 -78 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Wheat) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.38095 0 m
.38095 .00625 L
s
gsave
.38095 -0.0125 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Soy) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.61905 0 m
.61905 .00625 L
s
gsave
.61905 -0.0125 -75 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Oats) show
87.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.85714 0 m
.85714 .00625 L
s
gsave
.85714 -0.0125 -72 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Rye) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
s
0 .12361 m
.00625 .12361 L
s
[(0.2)] -0.0125 .12361 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(0.4)] -0.0125 .24721 1 0 Mshowa
0 .37082 m
.00625 .37082 L
s
[(0.6)] -0.0125 .37082 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(0.8)] -0.0125 .49443 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(1)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0309 m
.00375 .0309 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .15451 m
.00375 .15451 L
s
0 .18541 m
.00375 .18541 L
s
0 .21631 m
.00375 .21631 L
s
0 .27812 m
.00375 .27812 L
s
0 .30902 m
.00375 .30902 L
s
0 .33992 m
.00375 .33992 L
s
0 .40172 m
.00375 .40172 L
s
0 .43262 m
.00375 .43262 L
s
0 .46353 m
.00375 .46353 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .58713 m
.00375 .58713 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.04762 0 m
.04762 .24113 L
.2381 .24113 L
.2381 0 L
F
0 g
.5 Mabswid
.04762 0 m
.04762 .24113 L
.2381 .24113 L
.2381 0 L
.04762 0 L
s
1 0 0 r
.28571 0 m
.28571 .22808 L
.47619 .22808 L
.47619 0 L
F
0 g
.28571 0 m
.28571 .22808 L
.47619 .22808 L
.47619 0 L
.28571 0 L
s
1 0 0 r
.52381 0 m
.52381 .11471 L
.71429 .11471 L
.71429 0 L
F
0 g
.52381 0 m
.52381 .11471 L
.71429 .11471 L
.71429 0 L
.52381 0 L
s
1 0 0 r
.7619 0 m
.7619 .03411 L
.95238 .03411 L
.95238 0 L
F
0 g
.7619 0 m
.7619 .03411 L
.95238 .03411 L
.95238 0 L
.7619 0 L
s
.001 w
.14286 .24113 m
.38095 .46921 L
.61905 .58392 L
.85714 .61803 L
s
.0001 w
.14286 .24113 -1.875 0 Mabsadd m
.14286 .24113 0 2.5 Mabsadd L
.14286 .24113 1.875 0 Mabsadd L
.14286 .24113 0 -2.5 Mabsadd L
.14286 .24113 -1.875 0 Mabsadd L closepath F
.38095 .46921 -1.875 0 Mabsadd m
.38095 .46921 0 2.5 Mabsadd L
.38095 .46921 1.875 0 Mabsadd L
.38095 .46921 0 -2.5 Mabsadd L
.38095 .46921 -1.875 0 Mabsadd L closepath F
.61905 .58392 -1.875 0 Mabsadd m
.61905 .58392 0 2.5 Mabsadd L
.61905 .58392 1.875 0 Mabsadd L
.61905 .58392 0 -2.5 Mabsadd L
.61905 .58392 -1.875 0 Mabsadd L closepath F
.85714 .61803 -1.875 0 Mabsadd m
.85714 .61803 0 2.5 Mabsadd L
.85714 .61803 1.875 0 Mabsadd L
.85714 .61803 0 -2.5 Mabsadd L
.85714 .61803 -1.875 0 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00o`3oool]0?ooo`00Q@3oool2000007@0oooo0P00000_0?ooo`00QP3oool00`000000oooo
0?ooo`1c0?ooo`030000003oool0oooo02d0oooo000e0?ooo`040000003oool000000?ooo`<00000
00<0oooo0000000000000P3oool300000080oooo1@0000020?ooo`800000:P3oool3000000@0oooo
0P0000050?ooo`030000003oool0oooo02/0oooo0P0000030?ooo`D000000P3oool2000000<0oooo
0`00000[0?ooo`<000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo0`00000W0?ooo`00
=03oool01`000000oooo0000003oool000000?ooo`0000000P3oool010000000oooo0?ooo`000005
0?ooo`@000000P3oool010000000oooo0?ooo`00000Y0?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0000000[0?ooo`040000003oool0oooo0000
0080oooo100000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0:@3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool000000080oooo00<000000?ooo`3oool0:03o
ool003@0oooo00L000000?ooo`000000oooo0000003oool000000080oooo00<000000?ooo`3oool0
100000050?ooo`040000003oool0oooo000002l0oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo02T0oooo00@000000?ooo`3oool000001@3o
ool010000000oooo0?ooo`0000050?ooo`<00000;03oool3000000<0oooo00@000000?ooo`3oool0
00000P3oool4000002L0oooo000d0?ooo`060000003oool000000?ooo`000000oooo0`0000040?oo
o`800000103oool3000000030?ooo`000000000000<00000:P3oool2000000@0oooo0P0000020?oo
o`<0000000<0oooo000000000000:P3oool010000000oooo0?ooo`0000030?ooo`<0000000<0oooo
0000000000000`0000020?ooo`@00000:`3oool01@000000oooo0?ooo`000000oooo00<0000000<0
oooo0000000000000P3oool2000002P0oooo000d0?ooo`070000003oool0oooo0?ooo`000000oooo
0000000A0?ooo`030000003oool0oooo02X0oooo00@000000?ooo`3oool00000=`3oool010000000
oooo0?ooo`0000080?ooo`030000003oool0oooo0380oooo00@000000?ooo`3oool00000<`3oool0
03<0oooo0`0000000`3oool0000000000002000003h0oooo1000000h0?ooo`800000?@3oool40000
03@0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo000M0?oo
ool000001`0000090?ooo`007@3oool00`000000oooo0?ooo`090?ooo`030000003o0000o`0002l0
o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000^0?l000030000003oool0oooo00X0
oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`090?ooo`030000003o0000o`0002l0
o`0000<000000?ooo`3oool04`3oool001d0oooo00<000000?ooo`3oool02@3oool00`000000o`00
0?l0000_0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000;P3o00000`000000oooo
0?ooo`0:0?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02@3oool00`000000o`00
0?l0000_0?l000030000003oool0oooo01<0oooo000M0?ooo`030000003oool0oooo00T0oooo00<0
00000?l0003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<0
00000?ooo`3oool02P3oool00`000000o`000?l0000_0?l000030000003oool0oooo00T0oooo00<0
00000?l0003o0000;`3o00000`000000oooo0?ooo`0C0?ooo`007@3oool00`000000oooo0?ooo`09
0?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000^
0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`09
0?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool04`3oool001d0oooo00<000000?oo
o`3oool02@3oool00`000000o`000?l0000_0?l000030000003oool0oooo00X0oooo00<000000?l0
003o0000;P3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002l0o`0000<000000?oo
o`3oool02@3oool00`000000o`000?l0000_0?l000030000003oool0oooo01<0oooo000M0?ooo`03
0000003oool0oooo00T0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`03
0000003o0000o`0002h0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000_0?l00003
0000003oool0oooo00T0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0C0?ooo`00
7@3oool00`000000oooo0?ooo`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool0
2P3oool00`000000o`000?l0000^0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000
;`3o00000`000000oooo0?ooo`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool0
4`3oool001d0oooo0P00000:0?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3o
ool00`000000o`000?l0000^0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000;`3o
00000`000000oooo0?ooo`090?oooc<000005@3oool001d0oooo00<000000?ooo`3oool02@3oool0
0`000000o`000?l0000_0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000;P3o0000
0`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool0D@3oool0
01d0oooo00<000000?ooo`3oool02@3oool00`000000o`000?l0000_0?l000030000003oool0oooo
00X0oooo00<000000?l0003o0000;P3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`00
02l0o`0000<000000?ooo`3oool0D@3oool001d0oooo00<000000?ooo`3oool02@3oool00`000000
o`000?l0000_0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000;P3o00000`000000
oooo0?ooo`0:0?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool0D@3oool001d0oooo
00<000000?ooo`3oool02@3oool00`000000o`000?l0000_0?l000030000003oool0oooo00X0oooo
00<000000?l0003o0000;P3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002l0o`00
00<000000?ooo`3oool0D@3oool001d0oooo00<000000?ooo`3oool02@3oool00`000000o`000?l0
000_0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000;P3o00000`000000oooo0?oo
o`0:0?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool0D@3oool001d0oooo00<00000
0?ooo`3oool02@3oool00`000000o`000?l0000_0?l000030000003oool0oooo00X0oooo00<00000
0?l0003o0000;P3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002l0o`0000<00000
0?ooo`3oool0D@3oool001d0oooo00<000000?ooo`3oool02@3oool00`000000o`000?l0000_0?l0
00030000003oool0oooo00X0oooo00<000000?l0003o0000;P3o00000`000000oooo0?ooo`0:0?oo
o`030000003o0000o`0002l0o`0000<000000?ooo`3oool0D@3oool001d0oooo0P00000:0?ooo`03
0000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000^0?l00003
0000003oool0oooo00X0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`1A0?ooo`00
7@3oool00`000000oooo0?ooo`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool0
2P3oool00`000000o`000?l0000^0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000
;`3o00000`000000oooo0?ooo`1A0?ooo`007@3oool00`000000oooo0?ooo`090?ooo`030000003o
0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000^0?l000030000003o
ool0oooo00X0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`1A0?ooo`007@3oool0
0`000000oooo0?ooo`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool0
0`000000o`000?l0000^0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000;`3o0000
0`000000oooo0?ooo`1A0?ooo`007@3oool00`000000oooo0?ooo`090?ooo`030000003o0000o`00
02l0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000^0?l000030000003oool0oooo
00X0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`1A0?ooo`007@3oool00`000000
oooo0?ooo`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`000000
o`000?l0000^0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000;`3o00000`000000
oooo0?ooo`1A0?ooo`007@3oool00`000000oooo0?ooo`090?ooo`030000003o0000o`0002l0o`00
00<000000?ooo`3oool02P3oool00`000000o`000?l0000^0?l000030000003oool0oooo00X0oooo
00<000000?l0003o0000;`3o00000`000000oooo0?ooo`1A0?ooo`007@3oool00`000000oooo0?oo
o`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0
000^0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000;`3o00000`000000oooo0?oo
o`1A0?ooo`007@3oool2000000X0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0:
0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000_
0?l000030000003oool0oooo0540oooo000M0?ooo`030000003oool0oooo00T0oooo00<000000?l0
003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?oo
o`3oool02P3oool00`000000o`000?l0000_0?l000030000003oool0oooo0540oooo000M0?ooo`03
0000003oool0oooo00T0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`03
0000003o0000o`0002h0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000_0?l00003
0000003oool0oooo0540oooo000M0?ooo`030000003oool0oooo00T0oooo00<000000?l0003o0000
;`3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool0
2P3oool00`000000o`000?l0000_0?l000030000003oool0oooo0540oooo000M0?ooo`030000003o
ool0oooo00T0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`030000003o
0000o`0002h0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000_0?l000030000003o
ool0oooo0540oooo000M0?ooo`030000003oool0oooo00T0oooo00<000000?l0003o0000;`3o0000
0`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool02P3oool0
0`000000o`000?l0000_0?l000030000003oool0oooo0540oooo000:0?ooo`800000103oool20000
00<0oooo100000040?ooo`030000003oool0oooo00T0oooo00<000000?l0003o0000;`3o00000`00
0000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool02P3ooolc0000
05<0oooo00090?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`00
0000o`000?l0000^0?l000030000003oool0oooo0900oooo00090?ooo`040000003oool0oooo0000
00T0oooo00<000000?ooo`3oool0103oool3000000T0oooo00<000000?l0003o0000;`3o00000`00
0000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool0T03oool000T0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00T0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`00
02h0o`0000<000000?ooo`3oool0T03oool000T0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo00T0oooo00<000000?l0003o0000;`3o0000
0`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool0T03oool0
00X0oooo0P00000:0?ooo`8000001@3oool00`000000oooo0?ooo`090?ooo`030000003o0000o`00
02l0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000^0?l000030000003oool0oooo
0900oooo000M0?ooo`030000003oool0oooo00T0oooo00<000000?l0003o0000;`3o00000`000000
oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool0T03oool001d0oooo
00<000000?ooo`3oool02@3oool00`000000o`000?l0000_0?l000030000003oool0oooo00X0oooo
00<000000?l0003o0000;P3o00000`000000oooo0?ooo`2@0?ooo`007@3oool00`000000oooo0?oo
o`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0
000^0?l000030000003oool0oooo0900oooo000M0?ooo`030000003oool0oooo00T0oooo00<00000
0?l0003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<00000
0?ooo`3oool0T03oool001d0oooo0P00000:0?ooo`030000003o0000o`0002l0o`0000<000000?oo
o`3oool02P3oool00`000000o`000?l0000^0?l000030000003oool0oooo0900oooo000M0?ooo`03
0000003oool0oooo00T0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`03
0000003o0000o`0002h0o`0000<000000?ooo`3oool0T03oool001d0oooo00<000000?ooo`3oool0
2@3oool00`000000o`000?l0000_0?l000030000003oool0oooo00X0oooo00<000000?l0003o0000
;P3o00000`000000oooo0?ooo`2@0?ooo`007@3oool00`000000oooo0?ooo`090?ooo`030000003o
0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000^0?l000030000003o
ool0oooo0900oooo000M0?ooo`030000003oool0oooo00T0oooo00<000000?l0003o0000;`3o0000
0`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool0T03oool0
01d0oooo00<000000?ooo`3oool02@3oool00`000000o`000?l0000_0?l000030000003oool0oooo
00X0oooo00<000000?l0003o0000;P3o00000`000000oooo0?ooo`2@0?ooo`007@3oool00`000000
oooo0?ooo`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`000000
o`000?l0000^0?l000030000003oool0oooo0900oooo000M0?ooo`030000003oool0oooo00T0oooo
00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`00
00<000000?ooo`3oool0T03oool001d0oooo0P00000:0?ooo`030000003o0000o`0002l0o`0000<0
00000?ooo`3oool02P3oool00`000000o`000?l0000^0?l000030000003oool0oooo0900oooo000M
0?ooo`030000003oool0oooo00T0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0:
0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool0T03oool001d0oooo00<000000?oo
o`3oool02@3oool00`000000o`000?l0000_0?l000030000003oool0oooo00X0oooo00<000000?l0
003o0000;P3o00000`000000oooo0?ooo`2@0?ooo`007@3oool00`000000oooo0?ooo`090?ooo`03
0000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000^0?l00003
0000003oool0oooo0900oooo000M0?ooo`030000003oool0oooo00T0oooo00<000000?l0003o0000
;`3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool0
T03oool001d0oooo00<000000?ooo`3oool02@3oool00`000000o`000?l0000_0?l000030000003o
ool0oooo00X0oooo00<000000?l0003o0000;P3o00000`000000oooo0?ooo`2@0?ooo`007@3oool0
0`000000oooo0?ooo`090?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3oool0
0`000000o`000?l0000^0?l000030000003oool0oooo0900oooo000M0?ooo`030000003oool0oooo
00T0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`0:0?ooo`030000003o0000o`00
02h0o`0000<000000?ooo`3oool0T03oool001d0oooo0P00000:0?ooo`030000003o0000o`0002l0
o`0000<000000?ooo`3oool02P3oool00`000000o`000?l0000^0?l000030000003oool0oooo0900
oooo000M0?ooo`030000003oool0oooo00T0oooo00<000000?l0003o0000;`3o00000`000000oooo
0?ooo`0:0?ooo`030000003o0000o`0002h0o`0000<000000?ooo`3oool0T03oool001d0oooo00<0
00000?ooo`3oool02@3oool00`000000o`000?l0000_0?l000030000003oool0oooo00X0oooo00<0
00000?l0003o0000;P3o00000`000000oooo0?ooo`2@0?ooo`007@3oool00`000000oooo0?ooo`09
0?ooo`030000003o0000o`0002l0o`0000<000000?ooo`3oool02P3ooolb00000980oooo000M0?oo
o`030000003oool0oooo00T0oooo00<000000?l0003o0000;`3o00000`000000oooo0?ooo`3>0?oo
o`007@3oool00`000000oooo0?ooo`090?ooo`030000003o0000o`0001H0o`0000<000000?l0003o
00005P3o00000`000000oooo0?ooo`3>0?ooo`002P3oool2000000@0oooo0P0000050?ooo`<00000
0`3oool00`000000oooo0?ooo`090?ooo`030000003o0000o`0001D0o`000`00000G0?l000030000
003oool0oooo0<h0oooo00090?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`090?oooc<00000d03oool000T0oooo00@000000?ooo`3oool00000
203oool5000000<0oooo0`00000Q0?ooo`<00000j03oool000T0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool0i@3oool000T0oooo00@000000?ooo`3oool000002@3oool00`000000oooo000000040?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool0i03oool000X0oooo0P00000;0?ooo`800000
103oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0><0oooo000M0?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool0hP3oool001d0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`3Q0?ooo`007@3oool00`000000oooo0?ooo`0Y0?ooo`800000h@3oool001d0
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`3N0?ooo`007@3oool2000002d0oooo
00<000000?ooo`3oool0g@3oool001d0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?oo
o`3L0?ooo`007@3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0=/0oooo000M0?oo
o`030000003oool0oooo02l0oooo00<000000?ooo`3oool0fP3oool001d0oooo00<000000?ooo`3o
ool0<03oool00`000000oooo0?ooo`3I0?ooo`007@3oool00`000000oooo0?ooo`0a0?ooo`030000
003oool0oooo0=P0oooo000M0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0e`3o
ool001d0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`3F0?ooo`007@3oool20000
03D0oooo00<000000?ooo`3oool0e@3oool001d0oooo00<000000?ooo`3oool0=@3oool00`000000
oooo0?ooo`3D0?ooo`007@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo0=<0oooo
000M0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0dP3oool001d0oooo00<00000
0?ooo`3oool0>03oool00`000000oooo0?ooo`3A0?ooo`007@3oool00`000000oooo0?ooo`0i0?oo
o`800000d@3oool001d0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`3>0?ooo`00
7@3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0<d0oooo000M0?ooo`800000?P3o
ool00`000000oooo0?ooo`3<0?ooo`007@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0
oooo0</0oooo000M0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0bP3oool001d0
oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`390?ooo`007@3oool00`000000oooo
0?ooo`110?ooo`030000003oool0oooo0<P0oooo000M0?ooo`030000003oool0oooo0480oooo00<0
00000?ooo`3oool0a`3oool000X0oooo0P0000040?ooo`8000000`3oool3000000D0oooo00<00000
0?ooo`3oool0@`3oool00`000000oooo0?ooo`360?ooo`002@3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`350?ooo`002@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo
0`0000150?ooo`030000003oool0oooo0<@0oooo00090?ooo`040000003oool0oooo000000P0oooo
0`0000050?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0``3oool000T0oooo00@0
00000?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04L0oooo
00<000000?ooo`3oool0`P3oool000X0oooo0P00000:0?ooo`<00000103oool00`000000oooo0?oo
o`180?ooo`030000003oool0oooo0<40oooo000M0?ooo`030000003oool0oooo04T0oooo0P000031
0?ooo`007@3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo0;h0oooo000M0?ooo`03
0000003oool0oooo04`0oooo00<000000?ooo`3oool0_@3oool001d0oooo00<000000?ooo`3oool0
C@3oool00`000000oooo0?ooo`2l0?ooo`007@3oool2000004l0oooo00<000000?ooo`3oool0^`3o
ool001d0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`2j0?ooo`007@3oool00`00
0000oooo0?ooo`1@0?ooo`030000003oool0oooo0;T0oooo000M0?ooo`030000003oool0oooo0540
oooo00<000000?ooo`3oool0^03oool001d0oooo00<000000?ooo`3oool0DP3oool00`000000oooo
0?ooo`2g0?ooo`007@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo0;H0oooo000M
0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0]@3oool001d0oooo00<000000?oo
o`3oool0E@3oool00`000000oooo0?ooo`2d0?ooo`007@3oool00`000000oooo0?ooo`1F0?ooo`03
0000003oool0oooo0;<0oooo000M0?ooo`800000F03oool00`000000oooo0?ooo`2b0?ooo`007@3o
ool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo0;40oooo000M0?ooo`030000003oool0
oooo05T0oooo0P00002a0?ooo`007@3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo
0:h0oooo000M0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0[@3oool001d0oooo
00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`2/0?ooo`007@3oool00`000000oooo0?oo
o`1N0?ooo`030000003oool0oooo0:/0oooo000M0?ooo`030000003oool0oooo05l0oooo00<00000
0?ooo`3oool0ZP3oool001d0oooo0P00001Q0?ooo`800000ZP3oool001d0oooo00<000000?ooo`3o
ool0G`3oool400000:T0oooo000M0?ooo`030000003oool0oooo0600oooo0P0000000`3oool00000
0000002W0?ooo`007@3oool00`000000oooo0?ooo`1Q0?ooo`040000003oool0oooo0?ooo`800000
Y@3oool001d0oooo00<000000?ooo`3oool0I`3oool200000:<0oooo000M0?ooo`030000003oool0
oooo06T0oooo0P00002Q0?ooo`002P3oool2000000@0oooo0P0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`1[0?ooo`800000W`3oool000T0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo06d0oooo0P00002M0?ooo`002@3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo0`00001_0?ooo`800000V`3o
ool000T0oooo00@000000?ooo`3oool000002@3oool2000000D0oooo00<000000?ooo`3oool0L@3o
ool2000009T0oooo00090?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`1c0?ooo`800000U`3oool000X0oooo0P00000:0?ooo`8000001@3o
ool00`000000oooo0?ooo`1e0?ooo`800000U@3oool001d0oooo00<000000?ooo`3oool0M`3oool2
000009<0oooo000M0?ooo`030000003oool0oooo07T0oooo0P00002A0?ooo`007@3oool00`000000
oooo0?ooo`1k0?ooo`800000S`3oool001d0oooo00<000000?ooo`3oool0O@3oool2000008d0oooo
000M0?ooo`800000P03oool3000008X0oooo000M0?ooo`030000003oool0oooo0880oooo0P000028
0?ooo`007@3oool00`000000oooo0?ooo`240?ooo`800000QP3oool001d0oooo00<000000?ooo`3o
ool0QP3oool2000008@0oooo000M0?ooo`030000003oool0oooo08P0oooo0P0000220?ooo`007@3o
ool00`000000oooo0?ooo`2:0?ooo`800000P03oool001d0oooo00<000000?ooo`3oool0S03oool2
000007h0oooo000M0?ooo`030000003oool0oooo08h0oooo0P00001l0?ooo`007@3oool200000940
oooo0P00001j0?ooo`007@3oool00`000000oooo0?ooo`2B0?ooo`800000N03oool001d0oooo00<0
00000?ooo`3oool0U03oool2000007H0oooo000M0?ooo`030000003oool0oooo09H0oooo0P00001d
0?ooo`007@3oool00`000000oooo0?ooo`2H0?ooo`800000LP3oool001d0oooo00<000000?ooo`3o
ool0VP3oool200000700oooo000M0?ooo`030000003oool0oooo09`0oooo1000001/0?ooo`007@3o
ool00`000000oooo0?ooo`2M0?ooo`H00000J@3oool001d0oooo0P00002O0?ooo`<000000P3oool7
00000680oooo000M0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool0203oool70000
05/0oooo000M0?ooo`030000003oool0oooo0;40oooo1`00001D0?ooo`007@3oool00`000000oooo
0?ooo`2h0?ooo`H00000CP3oool001d0oooo00<000000?ooo`3oool0_P3oool7000004L0oooo000M
0?ooo`030000003oool0oooo0<D0oooo1`0000100?ooo`005@3oool5000000<0oooo00<000000?oo
o`3oool0c03oool7000000X0oooo00<000000?ooo`3oool0;03oool001L0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`3C0?ooo`L000000P3oool3000002d0oooo000G0?ooo`030000
003oool0oooo00<0oooo0`00003J0?ooo`D00000;@3oool001L0oooo00<000000?ooo`3oool0o`3o
oolC0?ooo`005`3oool00`000000oooo0?ooo`3o0?oooa<0oooo000F0?ooo`800000o`3ooolE0?oo
o`00o`3oool]0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.0750046, -0.0810184, \
0.0160805, 0.00619494}},
  CellTags->"S6.9.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S6.9.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BarOrientation", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Vertical", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["orientation of the plot",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BarStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["color for the bars",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BarLabels", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["labels for the bars",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BarEdges", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to draw borders on the bars",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["BarEdgeStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["GrayLevel[0]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["style for the bar edges",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotJoined", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to draw a line through the cumulative points",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["style for the line",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SymbolStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["style for the points",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SymbolShape", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{
       RowLines->{True, False, False, False, False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "function for drawing the points",
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{
      RowLines->{True, False, False, False, False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False, False, False, False, True, False},
 RowSpacings->0.4},
 CellTags->"S6.9.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["ParetoPlot", "MR"],
 ". "
}], "Caption",
 CellTags->"S6.9.1"],

Cell[TextData[{
  StyleBox["ParetoPlot", "MR"],
  " accepts a number of options common to bar charts and line plots, as \
detailed in the above table. It also accepts the usual ",
  StyleBox["Graphics", "MR"],
  " options. "
}], "Text",
  CellTags->{"S6.9.1", "1.24"}],

Cell[TextData[{
  "The various ",
  StyleBox["Bar", "MR"],
  " options are drawn from ",
  StyleBox["BarChart", "MR"],
  ". Most of these behave the same as their ",
  StyleBox["BarChart", "MR"],
  " counterparts. Note that unless the ",
  StyleBox["BarLabels", "MR"],
  " option is set to ",
  StyleBox["Automatic", "MR"],
  ", it will simply apply the labels cyclically to the bars in the order they \
appear; they only correspond to the categories in the ",
  StyleBox["Automatic", "MR"],
  " case. The ",
  StyleBox["BarOrientation", "MR"],
  " option applies to the entire plot, not just the bars. "
}], "Text",
  CellTags->{"S6.9.1", "1.25"}],

Cell[TextData[{
 "The line plot portion of the plot can also be modified. The options used by \
",
 StyleBox["ParetoPlot", "MR"],
 " are the same as their equivalents in ",
 StyleBox["MultipleListPlot", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.9.1", "1.26"}],

Cell["\<\
This is a Pareto plot with various options controlling the appearance. \
\>", "MathCaption",
 CellTags->{"S6.9.1", "1.27"}],

Cell[CellGroupData[{

Cell["\<\
ParetoPlot[
   Table[Random[Integer, {1,10}], {50}],
   BarLabels -> None,
   BarOrientation -> Horizontal,
   BarStyle -> GrayLevel[1],
   BarEdgeStyle -> Dashing[{0.02}],
   PlotJoined -> False,
   SymbolShape -> PlotSymbol[Box]
]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 -0.0242366 0.0605916 [
[.2 -0.0125 -9 -9 ]
[.2 -0.0125 9 0 ]
[.4 -0.0125 -9 -9 ]
[.4 -0.0125 9 0 ]
[.6 -0.0125 -9 -9 ]
[.6 -0.0125 9 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -3 -9 ]
[1 -0.0125 3 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2 0 m
.2 .00625 L
s
[(0.2)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(0.4)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(0.6)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(0.8)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(1)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 g
0 .01212 m
0 .06059 L
.18 .06059 L
.18 .01212 L
F
0 g
.5 Mabswid
[ .02 ] 0 setdash
0 .01212 m
0 .06059 L
.18 .06059 L
.18 .01212 L
0 .01212 L
s
1 g
0 .07271 m
0 .12118 L
.16 .12118 L
.16 .07271 L
F
0 g
0 .07271 m
0 .12118 L
.16 .12118 L
.16 .07271 L
0 .07271 L
s
1 g
0 .1333 m
0 .18177 L
.14 .18177 L
.14 .1333 L
F
0 g
0 .1333 m
0 .18177 L
.14 .18177 L
.14 .1333 L
0 .1333 L
s
1 g
0 .19389 m
0 .24237 L
.14 .24237 L
.14 .19389 L
F
0 g
0 .19389 m
0 .24237 L
.14 .24237 L
.14 .19389 L
0 .19389 L
s
1 g
0 .25448 m
0 .30296 L
.1 .30296 L
.1 .25448 L
F
0 g
0 .25448 m
0 .30296 L
.1 .30296 L
.1 .25448 L
0 .25448 L
s
1 g
0 .31508 m
0 .36355 L
.06 .36355 L
.06 .31508 L
F
0 g
0 .31508 m
0 .36355 L
.06 .36355 L
.06 .31508 L
0 .31508 L
s
1 g
0 .37567 m
0 .42414 L
.06 .42414 L
.06 .37567 L
F
0 g
0 .37567 m
0 .42414 L
.06 .42414 L
.06 .37567 L
0 .37567 L
s
1 g
0 .43626 m
0 .48473 L
.06 .48473 L
.06 .43626 L
F
0 g
0 .43626 m
0 .48473 L
.06 .48473 L
.06 .43626 L
0 .43626 L
s
1 g
0 .49685 m
0 .54532 L
.06 .54532 L
.06 .49685 L
F
0 g
0 .49685 m
0 .54532 L
.06 .54532 L
.06 .49685 L
0 .49685 L
s
1 g
0 .55744 m
0 .60592 L
.04 .60592 L
.04 .55744 L
F
0 g
0 .55744 m
0 .60592 L
.04 .60592 L
.04 .55744 L
0 .55744 L
s
.0001 w
[ ] 0 setdash
.18 .03635 -2.5 2.5 Mabsadd m
.18 .03635 2.5 2.5 Mabsadd L
.18 .03635 2.5 -2.5 Mabsadd L
.18 .03635 -2.5 -2.5 Mabsadd L
.18 .03635 -2.5 2.5 Mabsadd L closepath F
.34 .09695 -2.5 2.5 Mabsadd m
.34 .09695 2.5 2.5 Mabsadd L
.34 .09695 2.5 -2.5 Mabsadd L
.34 .09695 -2.5 -2.5 Mabsadd L
.34 .09695 -2.5 2.5 Mabsadd L closepath F
.48 .15754 -2.5 2.5 Mabsadd m
.48 .15754 2.5 2.5 Mabsadd L
.48 .15754 2.5 -2.5 Mabsadd L
.48 .15754 -2.5 -2.5 Mabsadd L
.48 .15754 -2.5 2.5 Mabsadd L closepath F
.62 .21813 -2.5 2.5 Mabsadd m
.62 .21813 2.5 2.5 Mabsadd L
.62 .21813 2.5 -2.5 Mabsadd L
.62 .21813 -2.5 -2.5 Mabsadd L
.62 .21813 -2.5 2.5 Mabsadd L closepath F
.72 .27872 -2.5 2.5 Mabsadd m
.72 .27872 2.5 2.5 Mabsadd L
.72 .27872 2.5 -2.5 Mabsadd L
.72 .27872 -2.5 -2.5 Mabsadd L
.72 .27872 -2.5 2.5 Mabsadd L closepath F
.78 .33931 -2.5 2.5 Mabsadd m
.78 .33931 2.5 2.5 Mabsadd L
.78 .33931 2.5 -2.5 Mabsadd L
.78 .33931 -2.5 -2.5 Mabsadd L
.78 .33931 -2.5 2.5 Mabsadd L closepath F
.84 .3999 -2.5 2.5 Mabsadd m
.84 .3999 2.5 2.5 Mabsadd L
.84 .3999 2.5 -2.5 Mabsadd L
.84 .3999 -2.5 -2.5 Mabsadd L
.84 .3999 -2.5 2.5 Mabsadd L closepath F
.9 .4605 -2.5 2.5 Mabsadd m
.9 .4605 2.5 2.5 Mabsadd L
.9 .4605 2.5 -2.5 Mabsadd L
.9 .4605 -2.5 -2.5 Mabsadd L
.9 .4605 -2.5 2.5 Mabsadd L closepath F
.96 .52109 -2.5 2.5 Mabsadd m
.96 .52109 2.5 2.5 Mabsadd L
.96 .52109 2.5 -2.5 Mabsadd L
.96 .52109 -2.5 -2.5 Mabsadd L
.96 .52109 -2.5 2.5 Mabsadd L closepath F
1 .58168 -2.5 2.5 Mabsadd m
1 .58168 2.5 2.5 Mabsadd L
1 .58168 2.5 -2.5 Mabsadd L
1 .58168 -2.5 -2.5 Mabsadd L
1 .58168 -2.5 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00?03oool2000000@0oooo0P0000030?ooo`@000009`3oool2000000@0oooo0P0000050?oo
o`<000009@3oool2000000@0oooo0P0000030?ooo`<00000:03oool2000000@0oooo0P0000040?oo
o`800000;@3oool5000000l0oooo000k0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool09`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo02<0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00000V0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000;P3oool00`000000oooo0?ooo`0?0?ooo`00>`3oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo02H0oooo00@000000?ooo`3oool00000203oool5
000002@0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000V0?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000;P3oool00`000000oooo0?ooo`0?0?oo
o`00>`3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo02D0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`00000U0?ooo`040000003oool0oooo000000P0oooo
0`00000W0?ooo`040000003oool0oooo000000T0oooo0P00000_0?ooo`030000003oool0oooo00l0
oooo000k0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000009P3oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0000002D0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo0?ooo`0V0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
0000;P3oool00`000000oooo0?ooo`0?0?ooo`00?03oool2000000X0oooo0P00000X0?ooo`800000
2`3oool2000002H0oooo0P00000:0?ooo`<000009`3oool2000000X0oooo0P00000^0?ooo`800000
4@3oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0oooo;@3oool00?l0oooo
;@3oool00?l0oooo;@3oool000d0ooooo`00000?00000140oooo000=0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0?0?ooo`003@3oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<P3oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool03`3oool000d0oooo
1@0000050?ooo`H00000103oool7000000@0oooo1`0000040?ooo`H00000k`3oool000d0oooo00<0
00000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?oo
o`030000003oool0oooo0?l0oooo7@3oool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`00
3@3oool00`000000oooo0?ooo`0[0?ooo`D00000k03oool000d0oooo00<000000?ooo`3oool0:`3o
ool500000>`0oooo000k0?ooo`D00000k03oool003/0oooo1@00003/0?ooo`00>`3oool500000>`0
oooo000m0?ooo`030000003oool0oooo0>`0oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3o
ool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool4000000@0oooo1`0000040?oo
o`H000001@3oool6000000D0oooo1P00003`0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0
oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3oool000d0oooo1@0000050?ooo`H00000103o
ool7000000@0oooo1`0000040?ooo`800000l`3oool000d0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`3a0?ooo`003@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo
0?40oooo000=0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0l@3oool000d0oooo
00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`3a0?ooo`003@3oool00`000000oooo0?oo
o`0X0?ooo`030000003oool0oooo0?40oooo000=0?ooo`030000003oool0oooo05H0oooo1@000031
0?ooo`00IP3oool500000<40oooo001V0?ooo`D00000`@3oool006H0oooo1@0000310?ooo`00>03o
ool00`000000oooo0?ooo`0[0?ooo`D00000`@3oool000d0oooo00<000000?ooo`3oool0:03oool0
0`000000oooo0?ooo`3a0?ooo`003@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo
0?40oooo000=0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0l@3oool000d0oooo
100000040?ooo`L00000103oool6000000D0oooo1P0000050?ooo`<00000l`3oool000d0oooo00<0
00000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?oo
o`D000001@3oool6000000D0oooo1P0000040?ooo`L00000n@3oool000d0oooo00<000000?ooo`3o
ool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`030000003o
ool0oooo0?l0oooo7@3oool000d0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`3g
0?ooo`003@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo05L0oooo1@00002K0?oo
o`00<P3oool00`000000oooo0?ooo`1G0?ooo`D00000V`3oool00380oooo00<000000?ooo`3oool0
E`3oool5000009/0oooo000b0?ooo`030000003oool0oooo05L0oooo1@00002K0?ooo`00<P3oool0
0`000000oooo0?ooo`1G0?ooo`D00000V`3oool00380oooo00<000000?ooo`3oool0m`3oool000d0
oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo
000=0?ooo`@00000103oool7000000@0oooo1P0000050?ooo`H00000n`3oool000d0oooo00<00000
0?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`D0
00001@3oool6000000@0oooo1`0000040?ooo`L00000n@3oool000d0oooo00<000000?ooo`3oool0
o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`030000003oool0
oooo0?l0oooo7@3oool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo07`0oooo1@00001f0?ooo`003@3oool00`000000oooo
0?ooo`0R0?ooo`030000003oool0oooo07`0oooo1@00001f0?ooo`00<P3oool00`000000oooo0?oo
o`1l0?ooo`D00000MP3oool00380oooo00<000000?ooo`3oool0O03oool5000007H0oooo000b0?oo
o`030000003oool0oooo07`0oooo1@00001f0?ooo`00<P3oool00`000000oooo0?ooo`3g0?ooo`00
3@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3o
ool000d0oooo100000040?ooo`L00000103oool6000000D0oooo1P00003k0?ooo`003@3oool00`00
0000oooo0?ooo`3o0?oooad0oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3oool000d0oooo
1@0000050?ooo`H00000103oool700000?l0oooo1@3oool000d0oooo00<000000?ooo`3oool0o`3o
oolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`030000003oool0oooo
0?l0oooo7@3oool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo0?l0oooo0P3oool000d0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`2Q0?ooo`D00000F`3oool002P0oooo00<000000?ooo`3oool0X@3oool5
000005/0oooo000X0?ooo`030000003oool0oooo0:40oooo1@00001K0?ooo`00:03oool00`000000
oooo0?ooo`2Q0?ooo`D00000F`3oool002P0oooo00<000000?ooo`3oool0X@3oool5000005/0oooo
000=0?ooo`030000003oool0oooo0?l0oooo7@3oool000d0oooo00<000000?ooo`3oool0o`3ooolM
0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`@00000103oool7000000@0
oooo1P00003o0?ooo`L0oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3oool000d0oooo00<0
00000?ooo`3oool0o`3ooolM0?ooo`003@3oool5000000D0oooo1P00003o0?oooa00oooo000=0?oo
o`030000003oool0oooo0?l0oooo7@3oool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`00
3@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0o`3oool=0?ooo`003@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo0;`0oooo1@00001;0?ooo`007@3oool00`000000oooo0?ooo`2l0?ooo`D00000B`3oool001d0
oooo00<000000?ooo`3oool0_03oool5000004/0oooo000M0?ooo`030000003oool0oooo0;`0oooo
1@00001;0?ooo`007@3oool00`000000oooo0?ooo`2l0?ooo`D00000B`3oool001d0oooo00<00000
0?ooo`3oool0o`3oool=0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`03
0000003oool0oooo0?l0oooo7@3oool000d0oooo100000040?ooo`L00000o`3ooolA0?ooo`003@3o
ool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3oool0
00d0oooo1@0000050?ooo`H00000o`3oool@0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0
oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3oool000d0oooo00<000000?ooo`3oool0o`3o
oolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0c@3oool5000003X0oooo000=0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool0c@3oool5000003X0oooo000M0?ooo`030000003oool0oooo0<d0oooo
1@00000j0?ooo`007@3oool00`000000oooo0?ooo`3=0?ooo`D00000>P3oool001d0oooo00<00000
0?ooo`3oool0c@3oool5000003X0oooo000M0?ooo`030000003oool0oooo0?l0oooo3@3oool000d0
oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo
000=0?ooo`@00000103oool700000?l0oooo4@3oool000d0oooo00<000000?ooo`3oool0o`3ooolM
0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`D000001@3oool600000?l0
oooo403oool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo0?oo
o`3o0?oooad0oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3oool000d0oooo00<000000?oo
o`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0?l0
oooo3@3oool000d0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3M0?ooo`D00000
:P3oool001d0oooo00<000000?ooo`3oool0g@3oool5000002X0oooo000M0?ooo`030000003oool0
oooo0=d0oooo1@00000Z0?ooo`007@3oool00`000000oooo0?ooo`3M0?ooo`D00000:P3oool001d0
oooo00<000000?ooo`3oool0g@3oool5000002X0oooo000=0?ooo`030000003oool0oooo0?l0oooo
7@3oool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o
0?oooad0oooo000=0?ooo`@00000103oool700000?l0oooo4@3oool000d0oooo00<000000?ooo`3o
ool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o0?oooad0oooo000=0?ooo`D000001@3o
ool600000?l0oooo403oool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`00
0000oooo0?ooo`3o0?oooad0oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3oool000d0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3o0?ooo`d0oooo000=0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool0k@3oool5000001X0oooo000M0?ooo`030000003oool0
oooo0>d0oooo1@00000J0?ooo`007@3oool00`000000oooo0?ooo`3]0?ooo`D000006P3oool001d0
oooo00<000000?ooo`3oool0k@3oool5000001X0oooo000M0?ooo`030000003oool0oooo0>d0oooo
1@00000J0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooo`d0oooo000=0?ooo`030000003oool0
oooo0?l0oooo7@3oool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool4000000@0
oooo1`00003o0?oooa40oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3oool000d0oooo00<0
00000?ooo`3oool0o`3ooolM0?ooo`003@3oool5000000D0oooo00<000000?ooo`3oool0o`3ooolC
0?ooo`003@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?l0oooo4`3oool000d0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?oooa<0oooo000=0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`003@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo0?l0oooo4`3oool000d0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`3n0?ooo`<000004@3oool000d0oooo00<000000?ooo`3oool0o`3oool90?oo
o`<000004@3oool00?l0oooo6@3oool300000140oooo003o0?oooaT0oooo0`00000A0?ooo`00o`3o
oolI0?ooo`<000004@3oool001L0oooo00<000000?ooo`3oool0o`3ooolC0?ooo`003@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0?l0oooo4`3oool000d0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`3o0?oooa<0oooo000=0?ooo`@00000103oool300000?l0oooo
5@3oool000d0oooo00<000000?ooo`3oool0o`3ooolM0?ooo`003@3oool00`000000oooo0?ooo`3o
0?oooad0oooo000=0?ooo`030000003oool0oooo0?l0oooo7@3oool00001\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.0489375, -0.357275, \
0.00370904, 0.0612137}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S6.9.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quantile\[Hyphen]Quantile Plots", "Subsubsection",
  CellTags->{"S6.9.1", "1.28"}],

Cell["\<\
Quantile\[Hyphen]quantile plots are used to determine whether two data sets \
come from populations with a common distribution. If the points of the plot, \
which are formed from the quantiles of the data, are roughly on a line with a \
slope of 1, then the distributions are the same. \
\>", "Text",
 CellTags->{"S6.9.1", "1.29"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["QuantilePlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["list",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["list",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "create a quantile\[Hyphen]quantile plot from the lists of data",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.9.1"],

Cell["Quantile\[Hyphen]quantile plots. ", "Caption",
 CellTags->"S6.9.1"],

Cell[TextData[{
 StyleBox["QuantilePlot", "MR"],
 " first sorts the shorter of the two lists of numbers and then determines \
the interpolated quantiles at the equivalent position in the longer list of \
data. It then plots the two sets of quantiles against each other. For data \
sets of equal length, this is equivalent to plotting the sorted lists against \
each other. The plot also displays a reference line with a slope of 1. "
}], "Text",
 CellTags->{"S6.9.1", "1.30"}],

Cell["\<\
Compare two data sets. Because these have identical distributions, the plot \
falls roughly along the reference line. \
\>", "MathCaption",
 CellTags->{"S6.9.1", "1.31"}],

Cell[CellGroupData[{

Cell["\<\
QuantilePlot[
   Table[Random[], {300}],
   Table[Random[], {300}]
]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.955407 0.0147151 0.591015 [
[.21489 .00222 -9 -9 ]
[.21489 .00222 9 0 ]
[.40597 .00222 -9 -9 ]
[.40597 .00222 9 0 ]
[.59705 .00222 -9 -9 ]
[.59705 .00222 9 0 ]
[.78814 .00222 -9 -9 ]
[.78814 .00222 9 0 ]
[.97922 .00222 -3 -9 ]
[.97922 .00222 3 0 ]
[.01131 .13292 -18 -4.5 ]
[.01131 .13292 0 4.5 ]
[.01131 .25112 -18 -4.5 ]
[.01131 .25112 0 4.5 ]
[.01131 .36932 -18 -4.5 ]
[.01131 .36932 0 4.5 ]
[.01131 .48753 -18 -4.5 ]
[.01131 .48753 0 4.5 ]
[.01131 .60573 -6 -4.5 ]
[.01131 .60573 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21489 .01472 m
.21489 .02097 L
s
[(0.2)] .21489 .00222 0 1 Mshowa
.40597 .01472 m
.40597 .02097 L
s
[(0.4)] .40597 .00222 0 1 Mshowa
.59705 .01472 m
.59705 .02097 L
s
[(0.6)] .59705 .00222 0 1 Mshowa
.78814 .01472 m
.78814 .02097 L
s
[(0.8)] .78814 .00222 0 1 Mshowa
.97922 .01472 m
.97922 .02097 L
s
[(1)] .97922 .00222 0 1 Mshowa
.125 Mabswid
.07158 .01472 m
.07158 .01847 L
s
.11935 .01472 m
.11935 .01847 L
s
.16712 .01472 m
.16712 .01847 L
s
.26266 .01472 m
.26266 .01847 L
s
.31043 .01472 m
.31043 .01847 L
s
.3582 .01472 m
.3582 .01847 L
s
.45374 .01472 m
.45374 .01847 L
s
.50151 .01472 m
.50151 .01847 L
s
.54928 .01472 m
.54928 .01847 L
s
.64482 .01472 m
.64482 .01847 L
s
.69259 .01472 m
.69259 .01847 L
s
.74036 .01472 m
.74036 .01847 L
s
.83591 .01472 m
.83591 .01847 L
s
.88368 .01472 m
.88368 .01847 L
s
.93145 .01472 m
.93145 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13292 m
.03006 .13292 L
s
[(0.2)] .01131 .13292 1 0 Mshowa
.02381 .25112 m
.03006 .25112 L
s
[(0.4)] .01131 .25112 1 0 Mshowa
.02381 .36932 m
.03006 .36932 L
s
[(0.6)] .01131 .36932 1 0 Mshowa
.02381 .48753 m
.03006 .48753 L
s
[(0.8)] .01131 .48753 1 0 Mshowa
.02381 .60573 m
.03006 .60573 L
s
[(1)] .01131 .60573 1 0 Mshowa
.125 Mabswid
.02381 .04427 m
.02756 .04427 L
s
.02381 .07382 m
.02756 .07382 L
s
.02381 .10337 m
.02756 .10337 L
s
.02381 .16247 m
.02756 .16247 L
s
.02381 .19202 m
.02756 .19202 L
s
.02381 .22157 m
.02756 .22157 L
s
.02381 .28067 m
.02756 .28067 L
s
.02381 .31022 m
.02756 .31022 L
s
.02381 .33977 m
.02756 .33977 L
s
.02381 .39887 m
.02756 .39887 L
s
.02381 .42843 m
.02756 .42843 L
s
.02381 .45798 m
.02756 .45798 L
s
.02381 .51708 m
.02756 .51708 L
s
.02381 .54663 m
.02756 .54663 L
s
.02381 .57618 m
.02756 .57618 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.02908 .01768 -1.875 0 Mabsadd m
.02908 .01768 0 2.5 Mabsadd L
.02908 .01768 1.875 0 Mabsadd L
.02908 .01768 0 -2.5 Mabsadd L
.02908 .01768 -1.875 0 Mabsadd L closepath F
.03121 .02117 -1.875 0 Mabsadd m
.03121 .02117 0 2.5 Mabsadd L
.03121 .02117 1.875 0 Mabsadd L
.03121 .02117 0 -2.5 Mabsadd L
.03121 .02117 -1.875 0 Mabsadd L closepath F
.0374 .02239 -1.875 0 Mabsadd m
.0374 .02239 0 2.5 Mabsadd L
.0374 .02239 1.875 0 Mabsadd L
.0374 .02239 0 -2.5 Mabsadd L
.0374 .02239 -1.875 0 Mabsadd L closepath F
.03789 .0232 -1.875 0 Mabsadd m
.03789 .0232 0 2.5 Mabsadd L
.03789 .0232 1.875 0 Mabsadd L
.03789 .0232 0 -2.5 Mabsadd L
.03789 .0232 -1.875 0 Mabsadd L closepath F
.03897 .02366 -1.875 0 Mabsadd m
.03897 .02366 0 2.5 Mabsadd L
.03897 .02366 1.875 0 Mabsadd L
.03897 .02366 0 -2.5 Mabsadd L
.03897 .02366 -1.875 0 Mabsadd L closepath F
.04529 .02785 -1.875 0 Mabsadd m
.04529 .02785 0 2.5 Mabsadd L
.04529 .02785 1.875 0 Mabsadd L
.04529 .02785 0 -2.5 Mabsadd L
.04529 .02785 -1.875 0 Mabsadd L closepath F
.046 .02826 -1.875 0 Mabsadd m
.046 .02826 0 2.5 Mabsadd L
.046 .02826 1.875 0 Mabsadd L
.046 .02826 0 -2.5 Mabsadd L
.046 .02826 -1.875 0 Mabsadd L closepath F
.05388 .0287 -1.875 0 Mabsadd m
.05388 .0287 0 2.5 Mabsadd L
.05388 .0287 1.875 0 Mabsadd L
.05388 .0287 0 -2.5 Mabsadd L
.05388 .0287 -1.875 0 Mabsadd L closepath F
.05473 .03048 -1.875 0 Mabsadd m
.05473 .03048 0 2.5 Mabsadd L
.05473 .03048 1.875 0 Mabsadd L
.05473 .03048 0 -2.5 Mabsadd L
.05473 .03048 -1.875 0 Mabsadd L closepath F
.05618 .03208 -1.875 0 Mabsadd m
.05618 .03208 0 2.5 Mabsadd L
.05618 .03208 1.875 0 Mabsadd L
.05618 .03208 0 -2.5 Mabsadd L
.05618 .03208 -1.875 0 Mabsadd L closepath F
.05785 .03371 -1.875 0 Mabsadd m
.05785 .03371 0 2.5 Mabsadd L
.05785 .03371 1.875 0 Mabsadd L
.05785 .03371 0 -2.5 Mabsadd L
.05785 .03371 -1.875 0 Mabsadd L closepath F
.05913 .03497 -1.875 0 Mabsadd m
.05913 .03497 0 2.5 Mabsadd L
.05913 .03497 1.875 0 Mabsadd L
.05913 .03497 0 -2.5 Mabsadd L
.05913 .03497 -1.875 0 Mabsadd L closepath F
.07333 .0352 -1.875 0 Mabsadd m
.07333 .0352 0 2.5 Mabsadd L
.07333 .0352 1.875 0 Mabsadd L
.07333 .0352 0 -2.5 Mabsadd L
.07333 .0352 -1.875 0 Mabsadd L closepath F
.07358 .0355 -1.875 0 Mabsadd m
.07358 .0355 0 2.5 Mabsadd L
.07358 .0355 1.875 0 Mabsadd L
.07358 .0355 0 -2.5 Mabsadd L
.07358 .0355 -1.875 0 Mabsadd L closepath F
.07363 .03586 -1.875 0 Mabsadd m
.07363 .03586 0 2.5 Mabsadd L
.07363 .03586 1.875 0 Mabsadd L
.07363 .03586 0 -2.5 Mabsadd L
.07363 .03586 -1.875 0 Mabsadd L closepath F
.0742 .03802 -1.875 0 Mabsadd m
.0742 .03802 0 2.5 Mabsadd L
.0742 .03802 1.875 0 Mabsadd L
.0742 .03802 0 -2.5 Mabsadd L
.0742 .03802 -1.875 0 Mabsadd L closepath F
.0761 .03833 -1.875 0 Mabsadd m
.0761 .03833 0 2.5 Mabsadd L
.0761 .03833 1.875 0 Mabsadd L
.0761 .03833 0 -2.5 Mabsadd L
.0761 .03833 -1.875 0 Mabsadd L closepath F
.07654 .04352 -1.875 0 Mabsadd m
.07654 .04352 0 2.5 Mabsadd L
.07654 .04352 1.875 0 Mabsadd L
.07654 .04352 0 -2.5 Mabsadd L
.07654 .04352 -1.875 0 Mabsadd L closepath F
.08421 .04369 -1.875 0 Mabsadd m
.08421 .04369 0 2.5 Mabsadd L
.08421 .04369 1.875 0 Mabsadd L
.08421 .04369 0 -2.5 Mabsadd L
.08421 .04369 -1.875 0 Mabsadd L closepath F
.08995 .04642 -1.875 0 Mabsadd m
.08995 .04642 0 2.5 Mabsadd L
.08995 .04642 1.875 0 Mabsadd L
.08995 .04642 0 -2.5 Mabsadd L
.08995 .04642 -1.875 0 Mabsadd L closepath F
.09142 .0468 -1.875 0 Mabsadd m
.09142 .0468 0 2.5 Mabsadd L
.09142 .0468 1.875 0 Mabsadd L
.09142 .0468 0 -2.5 Mabsadd L
.09142 .0468 -1.875 0 Mabsadd L closepath F
.0996 .04685 -1.875 0 Mabsadd m
.0996 .04685 0 2.5 Mabsadd L
.0996 .04685 1.875 0 Mabsadd L
.0996 .04685 0 -2.5 Mabsadd L
.0996 .04685 -1.875 0 Mabsadd L closepath F
.10006 .04794 -1.875 0 Mabsadd m
.10006 .04794 0 2.5 Mabsadd L
.10006 .04794 1.875 0 Mabsadd L
.10006 .04794 0 -2.5 Mabsadd L
.10006 .04794 -1.875 0 Mabsadd L closepath F
.1109 .05314 -1.875 0 Mabsadd m
.1109 .05314 0 2.5 Mabsadd L
.1109 .05314 1.875 0 Mabsadd L
.1109 .05314 0 -2.5 Mabsadd L
.1109 .05314 -1.875 0 Mabsadd L closepath F
.1111 .05409 -1.875 0 Mabsadd m
.1111 .05409 0 2.5 Mabsadd L
.1111 .05409 1.875 0 Mabsadd L
.1111 .05409 0 -2.5 Mabsadd L
.1111 .05409 -1.875 0 Mabsadd L closepath F
.11287 .05732 -1.875 0 Mabsadd m
.11287 .05732 0 2.5 Mabsadd L
.11287 .05732 1.875 0 Mabsadd L
.11287 .05732 0 -2.5 Mabsadd L
.11287 .05732 -1.875 0 Mabsadd L closepath F
.11304 .06005 -1.875 0 Mabsadd m
.11304 .06005 0 2.5 Mabsadd L
.11304 .06005 1.875 0 Mabsadd L
.11304 .06005 0 -2.5 Mabsadd L
.11304 .06005 -1.875 0 Mabsadd L closepath F
.11412 .06301 -1.875 0 Mabsadd m
.11412 .06301 0 2.5 Mabsadd L
.11412 .06301 1.875 0 Mabsadd L
.11412 .06301 0 -2.5 Mabsadd L
.11412 .06301 -1.875 0 Mabsadd L closepath F
.11419 .06352 -1.875 0 Mabsadd m
.11419 .06352 0 2.5 Mabsadd L
.11419 .06352 1.875 0 Mabsadd L
.11419 .06352 0 -2.5 Mabsadd L
.11419 .06352 -1.875 0 Mabsadd L closepath F
.11814 .06525 -1.875 0 Mabsadd m
.11814 .06525 0 2.5 Mabsadd L
.11814 .06525 1.875 0 Mabsadd L
.11814 .06525 0 -2.5 Mabsadd L
.11814 .06525 -1.875 0 Mabsadd L closepath F
.11821 .06829 -1.875 0 Mabsadd m
.11821 .06829 0 2.5 Mabsadd L
.11821 .06829 1.875 0 Mabsadd L
.11821 .06829 0 -2.5 Mabsadd L
.11821 .06829 -1.875 0 Mabsadd L closepath F
.11882 .07028 -1.875 0 Mabsadd m
.11882 .07028 0 2.5 Mabsadd L
.11882 .07028 1.875 0 Mabsadd L
.11882 .07028 0 -2.5 Mabsadd L
.11882 .07028 -1.875 0 Mabsadd L closepath F
.12215 .07217 -1.875 0 Mabsadd m
.12215 .07217 0 2.5 Mabsadd L
.12215 .07217 1.875 0 Mabsadd L
.12215 .07217 0 -2.5 Mabsadd L
.12215 .07217 -1.875 0 Mabsadd L closepath F
.12249 .0742 -1.875 0 Mabsadd m
.12249 .0742 0 2.5 Mabsadd L
.12249 .0742 1.875 0 Mabsadd L
.12249 .0742 0 -2.5 Mabsadd L
.12249 .0742 -1.875 0 Mabsadd L closepath F
.12621 .07668 -1.875 0 Mabsadd m
.12621 .07668 0 2.5 Mabsadd L
.12621 .07668 1.875 0 Mabsadd L
.12621 .07668 0 -2.5 Mabsadd L
.12621 .07668 -1.875 0 Mabsadd L closepath F
.14303 .07694 -1.875 0 Mabsadd m
.14303 .07694 0 2.5 Mabsadd L
.14303 .07694 1.875 0 Mabsadd L
.14303 .07694 0 -2.5 Mabsadd L
.14303 .07694 -1.875 0 Mabsadd L closepath F
.14306 .078 -1.875 0 Mabsadd m
.14306 .078 0 2.5 Mabsadd L
.14306 .078 1.875 0 Mabsadd L
.14306 .078 0 -2.5 Mabsadd L
.14306 .078 -1.875 0 Mabsadd L closepath F
.14631 .08135 -1.875 0 Mabsadd m
.14631 .08135 0 2.5 Mabsadd L
.14631 .08135 1.875 0 Mabsadd L
.14631 .08135 0 -2.5 Mabsadd L
.14631 .08135 -1.875 0 Mabsadd L closepath F
.15606 .08685 -1.875 0 Mabsadd m
.15606 .08685 0 2.5 Mabsadd L
.15606 .08685 1.875 0 Mabsadd L
.15606 .08685 0 -2.5 Mabsadd L
.15606 .08685 -1.875 0 Mabsadd L closepath F
.15935 .0883 -1.875 0 Mabsadd m
.15935 .0883 0 2.5 Mabsadd L
.15935 .0883 1.875 0 Mabsadd L
.15935 .0883 0 -2.5 Mabsadd L
.15935 .0883 -1.875 0 Mabsadd L closepath F
.16068 .08877 -1.875 0 Mabsadd m
.16068 .08877 0 2.5 Mabsadd L
.16068 .08877 1.875 0 Mabsadd L
.16068 .08877 0 -2.5 Mabsadd L
.16068 .08877 -1.875 0 Mabsadd L closepath F
.16124 .08925 -1.875 0 Mabsadd m
.16124 .08925 0 2.5 Mabsadd L
.16124 .08925 1.875 0 Mabsadd L
.16124 .08925 0 -2.5 Mabsadd L
.16124 .08925 -1.875 0 Mabsadd L closepath F
.16297 .08962 -1.875 0 Mabsadd m
.16297 .08962 0 2.5 Mabsadd L
.16297 .08962 1.875 0 Mabsadd L
.16297 .08962 0 -2.5 Mabsadd L
.16297 .08962 -1.875 0 Mabsadd L closepath F
.17539 .10687 -1.875 0 Mabsadd m
.17539 .10687 0 2.5 Mabsadd L
.17539 .10687 1.875 0 Mabsadd L
.17539 .10687 0 -2.5 Mabsadd L
.17539 .10687 -1.875 0 Mabsadd L closepath F
.17559 .10819 -1.875 0 Mabsadd m
.17559 .10819 0 2.5 Mabsadd L
.17559 .10819 1.875 0 Mabsadd L
.17559 .10819 0 -2.5 Mabsadd L
.17559 .10819 -1.875 0 Mabsadd L closepath F
.18383 .10928 -1.875 0 Mabsadd m
.18383 .10928 0 2.5 Mabsadd L
.18383 .10928 1.875 0 Mabsadd L
.18383 .10928 0 -2.5 Mabsadd L
.18383 .10928 -1.875 0 Mabsadd L closepath F
.18656 .11123 -1.875 0 Mabsadd m
.18656 .11123 0 2.5 Mabsadd L
.18656 .11123 1.875 0 Mabsadd L
.18656 .11123 0 -2.5 Mabsadd L
.18656 .11123 -1.875 0 Mabsadd L closepath F
.18989 .11218 -1.875 0 Mabsadd m
.18989 .11218 0 2.5 Mabsadd L
.18989 .11218 1.875 0 Mabsadd L
.18989 .11218 0 -2.5 Mabsadd L
.18989 .11218 -1.875 0 Mabsadd L closepath F
.197 .11388 -1.875 0 Mabsadd m
.197 .11388 0 2.5 Mabsadd L
.197 .11388 1.875 0 Mabsadd L
.197 .11388 0 -2.5 Mabsadd L
.197 .11388 -1.875 0 Mabsadd L closepath F
.20182 .11459 -1.875 0 Mabsadd m
.20182 .11459 0 2.5 Mabsadd L
.20182 .11459 1.875 0 Mabsadd L
.20182 .11459 0 -2.5 Mabsadd L
.20182 .11459 -1.875 0 Mabsadd L closepath F
.20216 .11744 -1.875 0 Mabsadd m
.20216 .11744 0 2.5 Mabsadd L
.20216 .11744 1.875 0 Mabsadd L
.20216 .11744 0 -2.5 Mabsadd L
.20216 .11744 -1.875 0 Mabsadd L closepath F
.20645 .11876 -1.875 0 Mabsadd m
.20645 .11876 0 2.5 Mabsadd L
.20645 .11876 1.875 0 Mabsadd L
.20645 .11876 0 -2.5 Mabsadd L
.20645 .11876 -1.875 0 Mabsadd L closepath F
.21433 .11961 -1.875 0 Mabsadd m
.21433 .11961 0 2.5 Mabsadd L
.21433 .11961 1.875 0 Mabsadd L
.21433 .11961 0 -2.5 Mabsadd L
.21433 .11961 -1.875 0 Mabsadd L closepath F
.21514 .12144 -1.875 0 Mabsadd m
.21514 .12144 0 2.5 Mabsadd L
.21514 .12144 1.875 0 Mabsadd L
.21514 .12144 0 -2.5 Mabsadd L
.21514 .12144 -1.875 0 Mabsadd L closepath F
.21531 .12524 -1.875 0 Mabsadd m
.21531 .12524 0 2.5 Mabsadd L
.21531 .12524 1.875 0 Mabsadd L
.21531 .12524 0 -2.5 Mabsadd L
.21531 .12524 -1.875 0 Mabsadd L closepath F
.21799 .12655 -1.875 0 Mabsadd m
.21799 .12655 0 2.5 Mabsadd L
.21799 .12655 1.875 0 Mabsadd L
.21799 .12655 0 -2.5 Mabsadd L
.21799 .12655 -1.875 0 Mabsadd L closepath F
.22411 .13504 -1.875 0 Mabsadd m
.22411 .13504 0 2.5 Mabsadd L
.22411 .13504 1.875 0 Mabsadd L
.22411 .13504 0 -2.5 Mabsadd L
.22411 .13504 -1.875 0 Mabsadd L closepath F
.22795 .13598 -1.875 0 Mabsadd m
.22795 .13598 0 2.5 Mabsadd L
.22795 .13598 1.875 0 Mabsadd L
.22795 .13598 0 -2.5 Mabsadd L
.22795 .13598 -1.875 0 Mabsadd L closepath F
.23031 .13699 -1.875 0 Mabsadd m
.23031 .13699 0 2.5 Mabsadd L
.23031 .13699 1.875 0 Mabsadd L
.23031 .13699 0 -2.5 Mabsadd L
.23031 .13699 -1.875 0 Mabsadd L closepath F
.24692 .13762 -1.875 0 Mabsadd m
.24692 .13762 0 2.5 Mabsadd L
.24692 .13762 1.875 0 Mabsadd L
.24692 .13762 0 -2.5 Mabsadd L
.24692 .13762 -1.875 0 Mabsadd L closepath F
.24807 .14001 -1.875 0 Mabsadd m
.24807 .14001 0 2.5 Mabsadd L
.24807 .14001 1.875 0 Mabsadd L
.24807 .14001 0 -2.5 Mabsadd L
.24807 .14001 -1.875 0 Mabsadd L closepath F
.25068 .14258 -1.875 0 Mabsadd m
.25068 .14258 0 2.5 Mabsadd L
.25068 .14258 1.875 0 Mabsadd L
.25068 .14258 0 -2.5 Mabsadd L
.25068 .14258 -1.875 0 Mabsadd L closepath F
.25132 .1441 -1.875 0 Mabsadd m
.25132 .1441 0 2.5 Mabsadd L
.25132 .1441 1.875 0 Mabsadd L
.25132 .1441 0 -2.5 Mabsadd L
.25132 .1441 -1.875 0 Mabsadd L closepath F
.25163 .14438 -1.875 0 Mabsadd m
.25163 .14438 0 2.5 Mabsadd L
.25163 .14438 1.875 0 Mabsadd L
.25163 .14438 0 -2.5 Mabsadd L
.25163 .14438 -1.875 0 Mabsadd L closepath F
.25557 .1526 -1.875 0 Mabsadd m
.25557 .1526 0 2.5 Mabsadd L
.25557 .1526 1.875 0 Mabsadd L
.25557 .1526 0 -2.5 Mabsadd L
.25557 .1526 -1.875 0 Mabsadd L closepath F
.25991 .15281 -1.875 0 Mabsadd m
.25991 .15281 0 2.5 Mabsadd L
.25991 .15281 1.875 0 Mabsadd L
.25991 .15281 0 -2.5 Mabsadd L
.25991 .15281 -1.875 0 Mabsadd L closepath F
.26225 .15443 -1.875 0 Mabsadd m
.26225 .15443 0 2.5 Mabsadd L
.26225 .15443 1.875 0 Mabsadd L
.26225 .15443 0 -2.5 Mabsadd L
.26225 .15443 -1.875 0 Mabsadd L closepath F
.26281 .16104 -1.875 0 Mabsadd m
.26281 .16104 0 2.5 Mabsadd L
.26281 .16104 1.875 0 Mabsadd L
.26281 .16104 0 -2.5 Mabsadd L
.26281 .16104 -1.875 0 Mabsadd L closepath F
.26398 .16396 -1.875 0 Mabsadd m
.26398 .16396 0 2.5 Mabsadd L
.26398 .16396 1.875 0 Mabsadd L
.26398 .16396 0 -2.5 Mabsadd L
.26398 .16396 -1.875 0 Mabsadd L closepath F
.26431 .16862 -1.875 0 Mabsadd m
.26431 .16862 0 2.5 Mabsadd L
.26431 .16862 1.875 0 Mabsadd L
.26431 .16862 0 -2.5 Mabsadd L
.26431 .16862 -1.875 0 Mabsadd L closepath F
.26445 .16971 -1.875 0 Mabsadd m
.26445 .16971 0 2.5 Mabsadd L
.26445 .16971 1.875 0 Mabsadd L
.26445 .16971 0 -2.5 Mabsadd L
.26445 .16971 -1.875 0 Mabsadd L closepath F
.26478 .17241 -1.875 0 Mabsadd m
.26478 .17241 0 2.5 Mabsadd L
.26478 .17241 1.875 0 Mabsadd L
.26478 .17241 0 -2.5 Mabsadd L
.26478 .17241 -1.875 0 Mabsadd L closepath F
.27231 .17639 -1.875 0 Mabsadd m
.27231 .17639 0 2.5 Mabsadd L
.27231 .17639 1.875 0 Mabsadd L
.27231 .17639 0 -2.5 Mabsadd L
.27231 .17639 -1.875 0 Mabsadd L closepath F
.27596 .17667 -1.875 0 Mabsadd m
.27596 .17667 0 2.5 Mabsadd L
.27596 .17667 1.875 0 Mabsadd L
.27596 .17667 0 -2.5 Mabsadd L
.27596 .17667 -1.875 0 Mabsadd L closepath F
.27629 .17839 -1.875 0 Mabsadd m
.27629 .17839 0 2.5 Mabsadd L
.27629 .17839 1.875 0 Mabsadd L
.27629 .17839 0 -2.5 Mabsadd L
.27629 .17839 -1.875 0 Mabsadd L closepath F
.27629 .17866 -1.875 0 Mabsadd m
.27629 .17866 0 2.5 Mabsadd L
.27629 .17866 1.875 0 Mabsadd L
.27629 .17866 0 -2.5 Mabsadd L
.27629 .17866 -1.875 0 Mabsadd L closepath F
.2763 .1833 -1.875 0 Mabsadd m
.2763 .1833 0 2.5 Mabsadd L
.2763 .1833 1.875 0 Mabsadd L
.2763 .1833 0 -2.5 Mabsadd L
.2763 .1833 -1.875 0 Mabsadd L closepath F
.27824 .18346 -1.875 0 Mabsadd m
.27824 .18346 0 2.5 Mabsadd L
.27824 .18346 1.875 0 Mabsadd L
.27824 .18346 0 -2.5 Mabsadd L
.27824 .18346 -1.875 0 Mabsadd L closepath F
.2834 .18444 -1.875 0 Mabsadd m
.2834 .18444 0 2.5 Mabsadd L
.2834 .18444 1.875 0 Mabsadd L
.2834 .18444 0 -2.5 Mabsadd L
.2834 .18444 -1.875 0 Mabsadd L closepath F
.28484 .18727 -1.875 0 Mabsadd m
.28484 .18727 0 2.5 Mabsadd L
.28484 .18727 1.875 0 Mabsadd L
.28484 .18727 0 -2.5 Mabsadd L
.28484 .18727 -1.875 0 Mabsadd L closepath F
.28676 .18831 -1.875 0 Mabsadd m
.28676 .18831 0 2.5 Mabsadd L
.28676 .18831 1.875 0 Mabsadd L
.28676 .18831 0 -2.5 Mabsadd L
.28676 .18831 -1.875 0 Mabsadd L closepath F
.28942 .19102 -1.875 0 Mabsadd m
.28942 .19102 0 2.5 Mabsadd L
.28942 .19102 1.875 0 Mabsadd L
.28942 .19102 0 -2.5 Mabsadd L
.28942 .19102 -1.875 0 Mabsadd L closepath F
.28972 .1929 -1.875 0 Mabsadd m
.28972 .1929 0 2.5 Mabsadd L
.28972 .1929 1.875 0 Mabsadd L
.28972 .1929 0 -2.5 Mabsadd L
.28972 .1929 -1.875 0 Mabsadd L closepath F
.29684 .19344 -1.875 0 Mabsadd m
.29684 .19344 0 2.5 Mabsadd L
.29684 .19344 1.875 0 Mabsadd L
.29684 .19344 0 -2.5 Mabsadd L
.29684 .19344 -1.875 0 Mabsadd L closepath F
.30035 .19618 -1.875 0 Mabsadd m
.30035 .19618 0 2.5 Mabsadd L
.30035 .19618 1.875 0 Mabsadd L
.30035 .19618 0 -2.5 Mabsadd L
.30035 .19618 -1.875 0 Mabsadd L closepath F
.30264 .1962 -1.875 0 Mabsadd m
.30264 .1962 0 2.5 Mabsadd L
.30264 .1962 1.875 0 Mabsadd L
.30264 .1962 0 -2.5 Mabsadd L
.30264 .1962 -1.875 0 Mabsadd L closepath F
.30578 .19625 -1.875 0 Mabsadd m
.30578 .19625 0 2.5 Mabsadd L
.30578 .19625 1.875 0 Mabsadd L
.30578 .19625 0 -2.5 Mabsadd L
.30578 .19625 -1.875 0 Mabsadd L closepath F
.30673 .19766 -1.875 0 Mabsadd m
.30673 .19766 0 2.5 Mabsadd L
.30673 .19766 1.875 0 Mabsadd L
.30673 .19766 0 -2.5 Mabsadd L
.30673 .19766 -1.875 0 Mabsadd L closepath F
.30863 .20433 -1.875 0 Mabsadd m
.30863 .20433 0 2.5 Mabsadd L
.30863 .20433 1.875 0 Mabsadd L
.30863 .20433 0 -2.5 Mabsadd L
.30863 .20433 -1.875 0 Mabsadd L closepath F
.31191 .20451 -1.875 0 Mabsadd m
.31191 .20451 0 2.5 Mabsadd L
.31191 .20451 1.875 0 Mabsadd L
.31191 .20451 0 -2.5 Mabsadd L
.31191 .20451 -1.875 0 Mabsadd L closepath F
.31498 .207 -1.875 0 Mabsadd m
.31498 .207 0 2.5 Mabsadd L
.31498 .207 1.875 0 Mabsadd L
.31498 .207 0 -2.5 Mabsadd L
.31498 .207 -1.875 0 Mabsadd L closepath F
.31933 .2088 -1.875 0 Mabsadd m
.31933 .2088 0 2.5 Mabsadd L
.31933 .2088 1.875 0 Mabsadd L
.31933 .2088 0 -2.5 Mabsadd L
.31933 .2088 -1.875 0 Mabsadd L closepath F
.32035 .21059 -1.875 0 Mabsadd m
.32035 .21059 0 2.5 Mabsadd L
.32035 .21059 1.875 0 Mabsadd L
.32035 .21059 0 -2.5 Mabsadd L
.32035 .21059 -1.875 0 Mabsadd L closepath F
.32464 .21428 -1.875 0 Mabsadd m
.32464 .21428 0 2.5 Mabsadd L
.32464 .21428 1.875 0 Mabsadd L
.32464 .21428 0 -2.5 Mabsadd L
.32464 .21428 -1.875 0 Mabsadd L closepath F
.32562 .21765 -1.875 0 Mabsadd m
.32562 .21765 0 2.5 Mabsadd L
.32562 .21765 1.875 0 Mabsadd L
.32562 .21765 0 -2.5 Mabsadd L
.32562 .21765 -1.875 0 Mabsadd L closepath F
.33004 .21774 -1.875 0 Mabsadd m
.33004 .21774 0 2.5 Mabsadd L
.33004 .21774 1.875 0 Mabsadd L
.33004 .21774 0 -2.5 Mabsadd L
.33004 .21774 -1.875 0 Mabsadd L closepath F
.33562 .22495 -1.875 0 Mabsadd m
.33562 .22495 0 2.5 Mabsadd L
.33562 .22495 1.875 0 Mabsadd L
.33562 .22495 0 -2.5 Mabsadd L
.33562 .22495 -1.875 0 Mabsadd L closepath F
.3385 .22532 -1.875 0 Mabsadd m
.3385 .22532 0 2.5 Mabsadd L
.3385 .22532 1.875 0 Mabsadd L
.3385 .22532 0 -2.5 Mabsadd L
.3385 .22532 -1.875 0 Mabsadd L closepath F
.34094 .22788 -1.875 0 Mabsadd m
.34094 .22788 0 2.5 Mabsadd L
.34094 .22788 1.875 0 Mabsadd L
.34094 .22788 0 -2.5 Mabsadd L
.34094 .22788 -1.875 0 Mabsadd L closepath F
.34132 .23634 -1.875 0 Mabsadd m
.34132 .23634 0 2.5 Mabsadd L
.34132 .23634 1.875 0 Mabsadd L
.34132 .23634 0 -2.5 Mabsadd L
.34132 .23634 -1.875 0 Mabsadd L closepath F
.34206 .23778 -1.875 0 Mabsadd m
.34206 .23778 0 2.5 Mabsadd L
.34206 .23778 1.875 0 Mabsadd L
.34206 .23778 0 -2.5 Mabsadd L
.34206 .23778 -1.875 0 Mabsadd L closepath F
.34305 .23814 -1.875 0 Mabsadd m
.34305 .23814 0 2.5 Mabsadd L
.34305 .23814 1.875 0 Mabsadd L
.34305 .23814 0 -2.5 Mabsadd L
.34305 .23814 -1.875 0 Mabsadd L closepath F
.3472 .23863 -1.875 0 Mabsadd m
.3472 .23863 0 2.5 Mabsadd L
.3472 .23863 1.875 0 Mabsadd L
.3472 .23863 0 -2.5 Mabsadd L
.3472 .23863 -1.875 0 Mabsadd L closepath F
.3517 .24232 -1.875 0 Mabsadd m
.3517 .24232 0 2.5 Mabsadd L
.3517 .24232 1.875 0 Mabsadd L
.3517 .24232 0 -2.5 Mabsadd L
.3517 .24232 -1.875 0 Mabsadd L closepath F
.3618 .24269 -1.875 0 Mabsadd m
.3618 .24269 0 2.5 Mabsadd L
.3618 .24269 1.875 0 Mabsadd L
.3618 .24269 0 -2.5 Mabsadd L
.3618 .24269 -1.875 0 Mabsadd L closepath F
.36327 .24338 -1.875 0 Mabsadd m
.36327 .24338 0 2.5 Mabsadd L
.36327 .24338 1.875 0 Mabsadd L
.36327 .24338 0 -2.5 Mabsadd L
.36327 .24338 -1.875 0 Mabsadd L closepath F
.36706 .24398 -1.875 0 Mabsadd m
.36706 .24398 0 2.5 Mabsadd L
.36706 .24398 1.875 0 Mabsadd L
.36706 .24398 0 -2.5 Mabsadd L
.36706 .24398 -1.875 0 Mabsadd L closepath F
.3768 .24628 -1.875 0 Mabsadd m
.3768 .24628 0 2.5 Mabsadd L
.3768 .24628 1.875 0 Mabsadd L
.3768 .24628 0 -2.5 Mabsadd L
.3768 .24628 -1.875 0 Mabsadd L closepath F
.37828 .24692 -1.875 0 Mabsadd m
.37828 .24692 0 2.5 Mabsadd L
.37828 .24692 1.875 0 Mabsadd L
.37828 .24692 0 -2.5 Mabsadd L
.37828 .24692 -1.875 0 Mabsadd L closepath F
.37851 .25181 -1.875 0 Mabsadd m
.37851 .25181 0 2.5 Mabsadd L
.37851 .25181 1.875 0 Mabsadd L
.37851 .25181 0 -2.5 Mabsadd L
.37851 .25181 -1.875 0 Mabsadd L closepath F
.38056 .25198 -1.875 0 Mabsadd m
.38056 .25198 0 2.5 Mabsadd L
.38056 .25198 1.875 0 Mabsadd L
.38056 .25198 0 -2.5 Mabsadd L
.38056 .25198 -1.875 0 Mabsadd L closepath F
.38432 .25637 -1.875 0 Mabsadd m
.38432 .25637 0 2.5 Mabsadd L
.38432 .25637 1.875 0 Mabsadd L
.38432 .25637 0 -2.5 Mabsadd L
.38432 .25637 -1.875 0 Mabsadd L closepath F
.38926 .25674 -1.875 0 Mabsadd m
.38926 .25674 0 2.5 Mabsadd L
.38926 .25674 1.875 0 Mabsadd L
.38926 .25674 0 -2.5 Mabsadd L
.38926 .25674 -1.875 0 Mabsadd L closepath F
.38984 .25826 -1.875 0 Mabsadd m
.38984 .25826 0 2.5 Mabsadd L
.38984 .25826 1.875 0 Mabsadd L
.38984 .25826 0 -2.5 Mabsadd L
.38984 .25826 -1.875 0 Mabsadd L closepath F
.39269 .25869 -1.875 0 Mabsadd m
.39269 .25869 0 2.5 Mabsadd L
.39269 .25869 1.875 0 Mabsadd L
.39269 .25869 0 -2.5 Mabsadd L
.39269 .25869 -1.875 0 Mabsadd L closepath F
.39505 .25964 -1.875 0 Mabsadd m
.39505 .25964 0 2.5 Mabsadd L
.39505 .25964 1.875 0 Mabsadd L
.39505 .25964 0 -2.5 Mabsadd L
.39505 .25964 -1.875 0 Mabsadd L closepath F
.39958 .26195 -1.875 0 Mabsadd m
.39958 .26195 0 2.5 Mabsadd L
.39958 .26195 1.875 0 Mabsadd L
.39958 .26195 0 -2.5 Mabsadd L
.39958 .26195 -1.875 0 Mabsadd L closepath F
.40303 .26385 -1.875 0 Mabsadd m
.40303 .26385 0 2.5 Mabsadd L
.40303 .26385 1.875 0 Mabsadd L
.40303 .26385 0 -2.5 Mabsadd L
.40303 .26385 -1.875 0 Mabsadd L closepath F
.4059 .2642 -1.875 0 Mabsadd m
.4059 .2642 0 2.5 Mabsadd L
.4059 .2642 1.875 0 Mabsadd L
.4059 .2642 0 -2.5 Mabsadd L
.4059 .2642 -1.875 0 Mabsadd L closepath F
.40676 .27014 -1.875 0 Mabsadd m
.40676 .27014 0 2.5 Mabsadd L
.40676 .27014 1.875 0 Mabsadd L
.40676 .27014 0 -2.5 Mabsadd L
.40676 .27014 -1.875 0 Mabsadd L closepath F
.41089 .27429 -1.875 0 Mabsadd m
.41089 .27429 0 2.5 Mabsadd L
.41089 .27429 1.875 0 Mabsadd L
.41089 .27429 0 -2.5 Mabsadd L
.41089 .27429 -1.875 0 Mabsadd L closepath F
.41516 .27676 -1.875 0 Mabsadd m
.41516 .27676 0 2.5 Mabsadd L
.41516 .27676 1.875 0 Mabsadd L
.41516 .27676 0 -2.5 Mabsadd L
.41516 .27676 -1.875 0 Mabsadd L closepath F
.41766 .27894 -1.875 0 Mabsadd m
.41766 .27894 0 2.5 Mabsadd L
.41766 .27894 1.875 0 Mabsadd L
.41766 .27894 0 -2.5 Mabsadd L
.41766 .27894 -1.875 0 Mabsadd L closepath F
.42555 .27921 -1.875 0 Mabsadd m
.42555 .27921 0 2.5 Mabsadd L
.42555 .27921 1.875 0 Mabsadd L
.42555 .27921 0 -2.5 Mabsadd L
.42555 .27921 -1.875 0 Mabsadd L closepath F
.42726 .28262 -1.875 0 Mabsadd m
.42726 .28262 0 2.5 Mabsadd L
.42726 .28262 1.875 0 Mabsadd L
.42726 .28262 0 -2.5 Mabsadd L
.42726 .28262 -1.875 0 Mabsadd L closepath F
.42841 .28526 -1.875 0 Mabsadd m
.42841 .28526 0 2.5 Mabsadd L
.42841 .28526 1.875 0 Mabsadd L
.42841 .28526 0 -2.5 Mabsadd L
.42841 .28526 -1.875 0 Mabsadd L closepath F
.43038 .28816 -1.875 0 Mabsadd m
.43038 .28816 0 2.5 Mabsadd L
.43038 .28816 1.875 0 Mabsadd L
.43038 .28816 0 -2.5 Mabsadd L
.43038 .28816 -1.875 0 Mabsadd L closepath F
.43232 .29119 -1.875 0 Mabsadd m
.43232 .29119 0 2.5 Mabsadd L
.43232 .29119 1.875 0 Mabsadd L
.43232 .29119 0 -2.5 Mabsadd L
.43232 .29119 -1.875 0 Mabsadd L closepath F
.43237 .2932 -1.875 0 Mabsadd m
.43237 .2932 0 2.5 Mabsadd L
.43237 .2932 1.875 0 Mabsadd L
.43237 .2932 0 -2.5 Mabsadd L
.43237 .2932 -1.875 0 Mabsadd L closepath F
.4343 .29719 -1.875 0 Mabsadd m
.4343 .29719 0 2.5 Mabsadd L
.4343 .29719 1.875 0 Mabsadd L
.4343 .29719 0 -2.5 Mabsadd L
.4343 .29719 -1.875 0 Mabsadd L closepath F
.43703 .29883 -1.875 0 Mabsadd m
.43703 .29883 0 2.5 Mabsadd L
.43703 .29883 1.875 0 Mabsadd L
.43703 .29883 0 -2.5 Mabsadd L
.43703 .29883 -1.875 0 Mabsadd L closepath F
.43778 .30009 -1.875 0 Mabsadd m
.43778 .30009 0 2.5 Mabsadd L
.43778 .30009 1.875 0 Mabsadd L
.43778 .30009 0 -2.5 Mabsadd L
.43778 .30009 -1.875 0 Mabsadd L closepath F
.43932 .30136 -1.875 0 Mabsadd m
.43932 .30136 0 2.5 Mabsadd L
.43932 .30136 1.875 0 Mabsadd L
.43932 .30136 0 -2.5 Mabsadd L
.43932 .30136 -1.875 0 Mabsadd L closepath F
.44358 .30442 -1.875 0 Mabsadd m
.44358 .30442 0 2.5 Mabsadd L
.44358 .30442 1.875 0 Mabsadd L
.44358 .30442 0 -2.5 Mabsadd L
.44358 .30442 -1.875 0 Mabsadd L closepath F
.44551 .30549 -1.875 0 Mabsadd m
.44551 .30549 0 2.5 Mabsadd L
.44551 .30549 1.875 0 Mabsadd L
.44551 .30549 0 -2.5 Mabsadd L
.44551 .30549 -1.875 0 Mabsadd L closepath F
.44809 .30621 -1.875 0 Mabsadd m
.44809 .30621 0 2.5 Mabsadd L
.44809 .30621 1.875 0 Mabsadd L
.44809 .30621 0 -2.5 Mabsadd L
.44809 .30621 -1.875 0 Mabsadd L closepath F
.45381 .30666 -1.875 0 Mabsadd m
.45381 .30666 0 2.5 Mabsadd L
.45381 .30666 1.875 0 Mabsadd L
.45381 .30666 0 -2.5 Mabsadd L
.45381 .30666 -1.875 0 Mabsadd L closepath F
.45717 .30715 -1.875 0 Mabsadd m
.45717 .30715 0 2.5 Mabsadd L
.45717 .30715 1.875 0 Mabsadd L
.45717 .30715 0 -2.5 Mabsadd L
.45717 .30715 -1.875 0 Mabsadd L closepath F
.45733 .31193 -1.875 0 Mabsadd m
.45733 .31193 0 2.5 Mabsadd L
.45733 .31193 1.875 0 Mabsadd L
.45733 .31193 0 -2.5 Mabsadd L
.45733 .31193 -1.875 0 Mabsadd L closepath F
.46297 .31214 -1.875 0 Mabsadd m
.46297 .31214 0 2.5 Mabsadd L
.46297 .31214 1.875 0 Mabsadd L
.46297 .31214 0 -2.5 Mabsadd L
.46297 .31214 -1.875 0 Mabsadd L closepath F
.47842 .31463 -1.875 0 Mabsadd m
.47842 .31463 0 2.5 Mabsadd L
.47842 .31463 1.875 0 Mabsadd L
.47842 .31463 0 -2.5 Mabsadd L
.47842 .31463 -1.875 0 Mabsadd L closepath F
.48023 .31908 -1.875 0 Mabsadd m
.48023 .31908 0 2.5 Mabsadd L
.48023 .31908 1.875 0 Mabsadd L
.48023 .31908 0 -2.5 Mabsadd L
.48023 .31908 -1.875 0 Mabsadd L closepath F
.48105 .31961 -1.875 0 Mabsadd m
.48105 .31961 0 2.5 Mabsadd L
.48105 .31961 1.875 0 Mabsadd L
.48105 .31961 0 -2.5 Mabsadd L
.48105 .31961 -1.875 0 Mabsadd L closepath F
.48135 .32029 -1.875 0 Mabsadd m
.48135 .32029 0 2.5 Mabsadd L
.48135 .32029 1.875 0 Mabsadd L
.48135 .32029 0 -2.5 Mabsadd L
.48135 .32029 -1.875 0 Mabsadd L closepath F
.48246 .32328 -1.875 0 Mabsadd m
.48246 .32328 0 2.5 Mabsadd L
.48246 .32328 1.875 0 Mabsadd L
.48246 .32328 0 -2.5 Mabsadd L
.48246 .32328 -1.875 0 Mabsadd L closepath F
.49345 .32689 -1.875 0 Mabsadd m
.49345 .32689 0 2.5 Mabsadd L
.49345 .32689 1.875 0 Mabsadd L
.49345 .32689 0 -2.5 Mabsadd L
.49345 .32689 -1.875 0 Mabsadd L closepath F
.49354 .32726 -1.875 0 Mabsadd m
.49354 .32726 0 2.5 Mabsadd L
.49354 .32726 1.875 0 Mabsadd L
.49354 .32726 0 -2.5 Mabsadd L
.49354 .32726 -1.875 0 Mabsadd L closepath F
.49817 .32826 -1.875 0 Mabsadd m
.49817 .32826 0 2.5 Mabsadd L
.49817 .32826 1.875 0 Mabsadd L
.49817 .32826 0 -2.5 Mabsadd L
.49817 .32826 -1.875 0 Mabsadd L closepath F
.50278 .33241 -1.875 0 Mabsadd m
.50278 .33241 0 2.5 Mabsadd L
.50278 .33241 1.875 0 Mabsadd L
.50278 .33241 0 -2.5 Mabsadd L
.50278 .33241 -1.875 0 Mabsadd L closepath F
.50305 .33292 -1.875 0 Mabsadd m
.50305 .33292 0 2.5 Mabsadd L
.50305 .33292 1.875 0 Mabsadd L
.50305 .33292 0 -2.5 Mabsadd L
.50305 .33292 -1.875 0 Mabsadd L closepath F
.5061 .33444 -1.875 0 Mabsadd m
.5061 .33444 0 2.5 Mabsadd L
.5061 .33444 1.875 0 Mabsadd L
.5061 .33444 0 -2.5 Mabsadd L
.5061 .33444 -1.875 0 Mabsadd L closepath F
.50995 .33573 -1.875 0 Mabsadd m
.50995 .33573 0 2.5 Mabsadd L
.50995 .33573 1.875 0 Mabsadd L
.50995 .33573 0 -2.5 Mabsadd L
.50995 .33573 -1.875 0 Mabsadd L closepath F
.51427 .33743 -1.875 0 Mabsadd m
.51427 .33743 0 2.5 Mabsadd L
.51427 .33743 1.875 0 Mabsadd L
.51427 .33743 0 -2.5 Mabsadd L
.51427 .33743 -1.875 0 Mabsadd L closepath F
.51483 .34028 -1.875 0 Mabsadd m
.51483 .34028 0 2.5 Mabsadd L
.51483 .34028 1.875 0 Mabsadd L
.51483 .34028 0 -2.5 Mabsadd L
.51483 .34028 -1.875 0 Mabsadd L closepath F
.51525 .34123 -1.875 0 Mabsadd m
.51525 .34123 0 2.5 Mabsadd L
.51525 .34123 1.875 0 Mabsadd L
.51525 .34123 0 -2.5 Mabsadd L
.51525 .34123 -1.875 0 Mabsadd L closepath F
.51561 .34144 -1.875 0 Mabsadd m
.51561 .34144 0 2.5 Mabsadd L
.51561 .34144 1.875 0 Mabsadd L
.51561 .34144 0 -2.5 Mabsadd L
.51561 .34144 -1.875 0 Mabsadd L closepath F
.52353 .34316 -1.875 0 Mabsadd m
.52353 .34316 0 2.5 Mabsadd L
.52353 .34316 1.875 0 Mabsadd L
.52353 .34316 0 -2.5 Mabsadd L
.52353 .34316 -1.875 0 Mabsadd L closepath F
.52706 .34603 -1.875 0 Mabsadd m
.52706 .34603 0 2.5 Mabsadd L
.52706 .34603 1.875 0 Mabsadd L
.52706 .34603 0 -2.5 Mabsadd L
.52706 .34603 -1.875 0 Mabsadd L closepath F
.54018 .35231 -1.875 0 Mabsadd m
.54018 .35231 0 2.5 Mabsadd L
.54018 .35231 1.875 0 Mabsadd L
.54018 .35231 0 -2.5 Mabsadd L
.54018 .35231 -1.875 0 Mabsadd L closepath F
.5442 .35453 -1.875 0 Mabsadd m
.5442 .35453 0 2.5 Mabsadd L
.5442 .35453 1.875 0 Mabsadd L
.5442 .35453 0 -2.5 Mabsadd L
.5442 .35453 -1.875 0 Mabsadd L closepath F
.54478 .35483 -1.875 0 Mabsadd m
.54478 .35483 0 2.5 Mabsadd L
.54478 .35483 1.875 0 Mabsadd L
.54478 .35483 0 -2.5 Mabsadd L
.54478 .35483 -1.875 0 Mabsadd L closepath F
.55091 .35496 -1.875 0 Mabsadd m
.55091 .35496 0 2.5 Mabsadd L
.55091 .35496 1.875 0 Mabsadd L
.55091 .35496 0 -2.5 Mabsadd L
.55091 .35496 -1.875 0 Mabsadd L closepath F
.55321 .35699 -1.875 0 Mabsadd m
.55321 .35699 0 2.5 Mabsadd L
.55321 .35699 1.875 0 Mabsadd L
.55321 .35699 0 -2.5 Mabsadd L
.55321 .35699 -1.875 0 Mabsadd L closepath F
.55512 .36262 -1.875 0 Mabsadd m
.55512 .36262 0 2.5 Mabsadd L
.55512 .36262 1.875 0 Mabsadd L
.55512 .36262 0 -2.5 Mabsadd L
.55512 .36262 -1.875 0 Mabsadd L closepath F
.55738 .36564 -1.875 0 Mabsadd m
.55738 .36564 0 2.5 Mabsadd L
.55738 .36564 1.875 0 Mabsadd L
.55738 .36564 0 -2.5 Mabsadd L
.55738 .36564 -1.875 0 Mabsadd L closepath F
.56109 .36576 -1.875 0 Mabsadd m
.56109 .36576 0 2.5 Mabsadd L
.56109 .36576 1.875 0 Mabsadd L
.56109 .36576 0 -2.5 Mabsadd L
.56109 .36576 -1.875 0 Mabsadd L closepath F
.56182 .36709 -1.875 0 Mabsadd m
.56182 .36709 0 2.5 Mabsadd L
.56182 .36709 1.875 0 Mabsadd L
.56182 .36709 0 -2.5 Mabsadd L
.56182 .36709 -1.875 0 Mabsadd L closepath F
.56967 .37057 -1.875 0 Mabsadd m
.56967 .37057 0 2.5 Mabsadd L
.56967 .37057 1.875 0 Mabsadd L
.56967 .37057 0 -2.5 Mabsadd L
.56967 .37057 -1.875 0 Mabsadd L closepath F
.57128 .3711 -1.875 0 Mabsadd m
.57128 .3711 0 2.5 Mabsadd L
.57128 .3711 1.875 0 Mabsadd L
.57128 .3711 0 -2.5 Mabsadd L
.57128 .3711 -1.875 0 Mabsadd L closepath F
.57464 .37457 -1.875 0 Mabsadd m
.57464 .37457 0 2.5 Mabsadd L
.57464 .37457 1.875 0 Mabsadd L
.57464 .37457 0 -2.5 Mabsadd L
.57464 .37457 -1.875 0 Mabsadd L closepath F
.5775 .37484 -1.875 0 Mabsadd m
.5775 .37484 0 2.5 Mabsadd L
.5775 .37484 1.875 0 Mabsadd L
.5775 .37484 0 -2.5 Mabsadd L
.5775 .37484 -1.875 0 Mabsadd L closepath F
.58269 .37752 -1.875 0 Mabsadd m
.58269 .37752 0 2.5 Mabsadd L
.58269 .37752 1.875 0 Mabsadd L
.58269 .37752 0 -2.5 Mabsadd L
.58269 .37752 -1.875 0 Mabsadd L closepath F
.58743 .37762 -1.875 0 Mabsadd m
.58743 .37762 0 2.5 Mabsadd L
.58743 .37762 1.875 0 Mabsadd L
.58743 .37762 0 -2.5 Mabsadd L
.58743 .37762 -1.875 0 Mabsadd L closepath F
.59324 .37901 -1.875 0 Mabsadd m
.59324 .37901 0 2.5 Mabsadd L
.59324 .37901 1.875 0 Mabsadd L
.59324 .37901 0 -2.5 Mabsadd L
.59324 .37901 -1.875 0 Mabsadd L closepath F
.5972 .38032 -1.875 0 Mabsadd m
.5972 .38032 0 2.5 Mabsadd L
.5972 .38032 1.875 0 Mabsadd L
.5972 .38032 0 -2.5 Mabsadd L
.5972 .38032 -1.875 0 Mabsadd L closepath F
.59872 .38267 -1.875 0 Mabsadd m
.59872 .38267 0 2.5 Mabsadd L
.59872 .38267 1.875 0 Mabsadd L
.59872 .38267 0 -2.5 Mabsadd L
.59872 .38267 -1.875 0 Mabsadd L closepath F
.60441 .38702 -1.875 0 Mabsadd m
.60441 .38702 0 2.5 Mabsadd L
.60441 .38702 1.875 0 Mabsadd L
.60441 .38702 0 -2.5 Mabsadd L
.60441 .38702 -1.875 0 Mabsadd L closepath F
.60755 .38735 -1.875 0 Mabsadd m
.60755 .38735 0 2.5 Mabsadd L
.60755 .38735 1.875 0 Mabsadd L
.60755 .38735 0 -2.5 Mabsadd L
.60755 .38735 -1.875 0 Mabsadd L closepath F
.61038 .39037 -1.875 0 Mabsadd m
.61038 .39037 0 2.5 Mabsadd L
.61038 .39037 1.875 0 Mabsadd L
.61038 .39037 0 -2.5 Mabsadd L
.61038 .39037 -1.875 0 Mabsadd L closepath F
.61215 .39249 -1.875 0 Mabsadd m
.61215 .39249 0 2.5 Mabsadd L
.61215 .39249 1.875 0 Mabsadd L
.61215 .39249 0 -2.5 Mabsadd L
.61215 .39249 -1.875 0 Mabsadd L closepath F
.61398 .39592 -1.875 0 Mabsadd m
.61398 .39592 0 2.5 Mabsadd L
.61398 .39592 1.875 0 Mabsadd L
.61398 .39592 0 -2.5 Mabsadd L
.61398 .39592 -1.875 0 Mabsadd L closepath F
.61854 .39771 -1.875 0 Mabsadd m
.61854 .39771 0 2.5 Mabsadd L
.61854 .39771 1.875 0 Mabsadd L
.61854 .39771 0 -2.5 Mabsadd L
.61854 .39771 -1.875 0 Mabsadd L closepath F
.62299 .39883 -1.875 0 Mabsadd m
.62299 .39883 0 2.5 Mabsadd L
.62299 .39883 1.875 0 Mabsadd L
.62299 .39883 0 -2.5 Mabsadd L
.62299 .39883 -1.875 0 Mabsadd L closepath F
.62967 .40038 -1.875 0 Mabsadd m
.62967 .40038 0 2.5 Mabsadd L
.62967 .40038 1.875 0 Mabsadd L
.62967 .40038 0 -2.5 Mabsadd L
.62967 .40038 -1.875 0 Mabsadd L closepath F
.63304 .40188 -1.875 0 Mabsadd m
.63304 .40188 0 2.5 Mabsadd L
.63304 .40188 1.875 0 Mabsadd L
.63304 .40188 0 -2.5 Mabsadd L
.63304 .40188 -1.875 0 Mabsadd L closepath F
.63619 .40234 -1.875 0 Mabsadd m
.63619 .40234 0 2.5 Mabsadd L
.63619 .40234 1.875 0 Mabsadd L
.63619 .40234 0 -2.5 Mabsadd L
.63619 .40234 -1.875 0 Mabsadd L closepath F
.63763 .40392 -1.875 0 Mabsadd m
.63763 .40392 0 2.5 Mabsadd L
.63763 .40392 1.875 0 Mabsadd L
.63763 .40392 0 -2.5 Mabsadd L
.63763 .40392 -1.875 0 Mabsadd L closepath F
.6379 .40418 -1.875 0 Mabsadd m
.6379 .40418 0 2.5 Mabsadd L
.6379 .40418 1.875 0 Mabsadd L
.6379 .40418 0 -2.5 Mabsadd L
.6379 .40418 -1.875 0 Mabsadd L closepath F
.63834 .40422 -1.875 0 Mabsadd m
.63834 .40422 0 2.5 Mabsadd L
.63834 .40422 1.875 0 Mabsadd L
.63834 .40422 0 -2.5 Mabsadd L
.63834 .40422 -1.875 0 Mabsadd L closepath F
.63959 .40513 -1.875 0 Mabsadd m
.63959 .40513 0 2.5 Mabsadd L
.63959 .40513 1.875 0 Mabsadd L
.63959 .40513 0 -2.5 Mabsadd L
.63959 .40513 -1.875 0 Mabsadd L closepath F
.64225 .40704 -1.875 0 Mabsadd m
.64225 .40704 0 2.5 Mabsadd L
.64225 .40704 1.875 0 Mabsadd L
.64225 .40704 0 -2.5 Mabsadd L
.64225 .40704 -1.875 0 Mabsadd L closepath F
.6516 .40811 -1.875 0 Mabsadd m
.6516 .40811 0 2.5 Mabsadd L
.6516 .40811 1.875 0 Mabsadd L
.6516 .40811 0 -2.5 Mabsadd L
.6516 .40811 -1.875 0 Mabsadd L closepath F
.65305 .4088 -1.875 0 Mabsadd m
.65305 .4088 0 2.5 Mabsadd L
.65305 .4088 1.875 0 Mabsadd L
.65305 .4088 0 -2.5 Mabsadd L
.65305 .4088 -1.875 0 Mabsadd L closepath F
.65613 .41262 -1.875 0 Mabsadd m
.65613 .41262 0 2.5 Mabsadd L
.65613 .41262 1.875 0 Mabsadd L
.65613 .41262 0 -2.5 Mabsadd L
.65613 .41262 -1.875 0 Mabsadd L closepath F
.65677 .41444 -1.875 0 Mabsadd m
.65677 .41444 0 2.5 Mabsadd L
.65677 .41444 1.875 0 Mabsadd L
.65677 .41444 0 -2.5 Mabsadd L
.65677 .41444 -1.875 0 Mabsadd L closepath F
.66051 .41644 -1.875 0 Mabsadd m
.66051 .41644 0 2.5 Mabsadd L
.66051 .41644 1.875 0 Mabsadd L
.66051 .41644 0 -2.5 Mabsadd L
.66051 .41644 -1.875 0 Mabsadd L closepath F
.6746 .42177 -1.875 0 Mabsadd m
.6746 .42177 0 2.5 Mabsadd L
.6746 .42177 1.875 0 Mabsadd L
.6746 .42177 0 -2.5 Mabsadd L
.6746 .42177 -1.875 0 Mabsadd L closepath F
.67829 .42246 -1.875 0 Mabsadd m
.67829 .42246 0 2.5 Mabsadd L
.67829 .42246 1.875 0 Mabsadd L
.67829 .42246 0 -2.5 Mabsadd L
.67829 .42246 -1.875 0 Mabsadd L closepath F
.6792 .4236 -1.875 0 Mabsadd m
.6792 .4236 0 2.5 Mabsadd L
.6792 .4236 1.875 0 Mabsadd L
.6792 .4236 0 -2.5 Mabsadd L
.6792 .4236 -1.875 0 Mabsadd L closepath F
.68133 .42538 -1.875 0 Mabsadd m
.68133 .42538 0 2.5 Mabsadd L
.68133 .42538 1.875 0 Mabsadd L
.68133 .42538 0 -2.5 Mabsadd L
.68133 .42538 -1.875 0 Mabsadd L closepath F
.6817 .4258 -1.875 0 Mabsadd m
.6817 .4258 0 2.5 Mabsadd L
.6817 .4258 1.875 0 Mabsadd L
.6817 .4258 0 -2.5 Mabsadd L
.6817 .4258 -1.875 0 Mabsadd L closepath F
.68457 .42733 -1.875 0 Mabsadd m
.68457 .42733 0 2.5 Mabsadd L
.68457 .42733 1.875 0 Mabsadd L
.68457 .42733 0 -2.5 Mabsadd L
.68457 .42733 -1.875 0 Mabsadd L closepath F
.68484 .43178 -1.875 0 Mabsadd m
.68484 .43178 0 2.5 Mabsadd L
.68484 .43178 1.875 0 Mabsadd L
.68484 .43178 0 -2.5 Mabsadd L
.68484 .43178 -1.875 0 Mabsadd L closepath F
.68627 .4322 -1.875 0 Mabsadd m
.68627 .4322 0 2.5 Mabsadd L
.68627 .4322 1.875 0 Mabsadd L
.68627 .4322 0 -2.5 Mabsadd L
.68627 .4322 -1.875 0 Mabsadd L closepath F
.68658 .4332 -1.875 0 Mabsadd m
.68658 .4332 0 2.5 Mabsadd L
.68658 .4332 1.875 0 Mabsadd L
.68658 .4332 0 -2.5 Mabsadd L
.68658 .4332 -1.875 0 Mabsadd L closepath F
.68829 .4364 -1.875 0 Mabsadd m
.68829 .4364 0 2.5 Mabsadd L
.68829 .4364 1.875 0 Mabsadd L
.68829 .4364 0 -2.5 Mabsadd L
.68829 .4364 -1.875 0 Mabsadd L closepath F
.68901 .44287 -1.875 0 Mabsadd m
.68901 .44287 0 2.5 Mabsadd L
.68901 .44287 1.875 0 Mabsadd L
.68901 .44287 0 -2.5 Mabsadd L
.68901 .44287 -1.875 0 Mabsadd L closepath F
.693 .44469 -1.875 0 Mabsadd m
.693 .44469 0 2.5 Mabsadd L
.693 .44469 1.875 0 Mabsadd L
.693 .44469 0 -2.5 Mabsadd L
.693 .44469 -1.875 0 Mabsadd L closepath F
.69888 .44533 -1.875 0 Mabsadd m
.69888 .44533 0 2.5 Mabsadd L
.69888 .44533 1.875 0 Mabsadd L
.69888 .44533 0 -2.5 Mabsadd L
.69888 .44533 -1.875 0 Mabsadd L closepath F
.7059 .44614 -1.875 0 Mabsadd m
.7059 .44614 0 2.5 Mabsadd L
.7059 .44614 1.875 0 Mabsadd L
.7059 .44614 0 -2.5 Mabsadd L
.7059 .44614 -1.875 0 Mabsadd L closepath F
.71058 .45307 -1.875 0 Mabsadd m
.71058 .45307 0 2.5 Mabsadd L
.71058 .45307 1.875 0 Mabsadd L
.71058 .45307 0 -2.5 Mabsadd L
.71058 .45307 -1.875 0 Mabsadd L closepath F
.71555 .45376 -1.875 0 Mabsadd m
.71555 .45376 0 2.5 Mabsadd L
.71555 .45376 1.875 0 Mabsadd L
.71555 .45376 0 -2.5 Mabsadd L
.71555 .45376 -1.875 0 Mabsadd L closepath F
.71782 .45479 -1.875 0 Mabsadd m
.71782 .45479 0 2.5 Mabsadd L
.71782 .45479 1.875 0 Mabsadd L
.71782 .45479 0 -2.5 Mabsadd L
.71782 .45479 -1.875 0 Mabsadd L closepath F
.71888 .46164 -1.875 0 Mabsadd m
.71888 .46164 0 2.5 Mabsadd L
.71888 .46164 1.875 0 Mabsadd L
.71888 .46164 0 -2.5 Mabsadd L
.71888 .46164 -1.875 0 Mabsadd L closepath F
.72738 .46225 -1.875 0 Mabsadd m
.72738 .46225 0 2.5 Mabsadd L
.72738 .46225 1.875 0 Mabsadd L
.72738 .46225 0 -2.5 Mabsadd L
.72738 .46225 -1.875 0 Mabsadd L closepath F
.72742 .46262 -1.875 0 Mabsadd m
.72742 .46262 0 2.5 Mabsadd L
.72742 .46262 1.875 0 Mabsadd L
.72742 .46262 0 -2.5 Mabsadd L
.72742 .46262 -1.875 0 Mabsadd L closepath F
.7293 .46328 -1.875 0 Mabsadd m
.7293 .46328 0 2.5 Mabsadd L
.7293 .46328 1.875 0 Mabsadd L
.7293 .46328 0 -2.5 Mabsadd L
.7293 .46328 -1.875 0 Mabsadd L closepath F
.73057 .46625 -1.875 0 Mabsadd m
.73057 .46625 0 2.5 Mabsadd L
.73057 .46625 1.875 0 Mabsadd L
.73057 .46625 0 -2.5 Mabsadd L
.73057 .46625 -1.875 0 Mabsadd L closepath F
.73371 .46662 -1.875 0 Mabsadd m
.73371 .46662 0 2.5 Mabsadd L
.73371 .46662 1.875 0 Mabsadd L
.73371 .46662 0 -2.5 Mabsadd L
.73371 .46662 -1.875 0 Mabsadd L closepath F
.73757 .46782 -1.875 0 Mabsadd m
.73757 .46782 0 2.5 Mabsadd L
.73757 .46782 1.875 0 Mabsadd L
.73757 .46782 0 -2.5 Mabsadd L
.73757 .46782 -1.875 0 Mabsadd L closepath F
.74509 .4697 -1.875 0 Mabsadd m
.74509 .4697 0 2.5 Mabsadd L
.74509 .4697 1.875 0 Mabsadd L
.74509 .4697 0 -2.5 Mabsadd L
.74509 .4697 -1.875 0 Mabsadd L closepath F
.74902 .46992 -1.875 0 Mabsadd m
.74902 .46992 0 2.5 Mabsadd L
.74902 .46992 1.875 0 Mabsadd L
.74902 .46992 0 -2.5 Mabsadd L
.74902 .46992 -1.875 0 Mabsadd L closepath F
.74978 .47203 -1.875 0 Mabsadd m
.74978 .47203 0 2.5 Mabsadd L
.74978 .47203 1.875 0 Mabsadd L
.74978 .47203 0 -2.5 Mabsadd L
.74978 .47203 -1.875 0 Mabsadd L closepath F
.7522 .47275 -1.875 0 Mabsadd m
.7522 .47275 0 2.5 Mabsadd L
.7522 .47275 1.875 0 Mabsadd L
.7522 .47275 0 -2.5 Mabsadd L
.7522 .47275 -1.875 0 Mabsadd L closepath F
.75813 .4765 -1.875 0 Mabsadd m
.75813 .4765 0 2.5 Mabsadd L
.75813 .4765 1.875 0 Mabsadd L
.75813 .4765 0 -2.5 Mabsadd L
.75813 .4765 -1.875 0 Mabsadd L closepath F
.761 .47818 -1.875 0 Mabsadd m
.761 .47818 0 2.5 Mabsadd L
.761 .47818 1.875 0 Mabsadd L
.761 .47818 0 -2.5 Mabsadd L
.761 .47818 -1.875 0 Mabsadd L closepath F
.76146 .47828 -1.875 0 Mabsadd m
.76146 .47828 0 2.5 Mabsadd L
.76146 .47828 1.875 0 Mabsadd L
.76146 .47828 0 -2.5 Mabsadd L
.76146 .47828 -1.875 0 Mabsadd L closepath F
.76197 .48129 -1.875 0 Mabsadd m
.76197 .48129 0 2.5 Mabsadd L
.76197 .48129 1.875 0 Mabsadd L
.76197 .48129 0 -2.5 Mabsadd L
.76197 .48129 -1.875 0 Mabsadd L closepath F
.76846 .4833 -1.875 0 Mabsadd m
.76846 .4833 0 2.5 Mabsadd L
.76846 .4833 1.875 0 Mabsadd L
.76846 .4833 0 -2.5 Mabsadd L
.76846 .4833 -1.875 0 Mabsadd L closepath F
.7688 .4923 -1.875 0 Mabsadd m
.7688 .4923 0 2.5 Mabsadd L
.7688 .4923 1.875 0 Mabsadd L
.7688 .4923 0 -2.5 Mabsadd L
.7688 .4923 -1.875 0 Mabsadd L closepath F
.77015 .49385 -1.875 0 Mabsadd m
.77015 .49385 0 2.5 Mabsadd L
.77015 .49385 1.875 0 Mabsadd L
.77015 .49385 0 -2.5 Mabsadd L
.77015 .49385 -1.875 0 Mabsadd L closepath F
.77495 .49506 -1.875 0 Mabsadd m
.77495 .49506 0 2.5 Mabsadd L
.77495 .49506 1.875 0 Mabsadd L
.77495 .49506 0 -2.5 Mabsadd L
.77495 .49506 -1.875 0 Mabsadd L closepath F
.77554 .49712 -1.875 0 Mabsadd m
.77554 .49712 0 2.5 Mabsadd L
.77554 .49712 1.875 0 Mabsadd L
.77554 .49712 0 -2.5 Mabsadd L
.77554 .49712 -1.875 0 Mabsadd L closepath F
.77713 .49812 -1.875 0 Mabsadd m
.77713 .49812 0 2.5 Mabsadd L
.77713 .49812 1.875 0 Mabsadd L
.77713 .49812 0 -2.5 Mabsadd L
.77713 .49812 -1.875 0 Mabsadd L closepath F
.7789 .50267 -1.875 0 Mabsadd m
.7789 .50267 0 2.5 Mabsadd L
.7789 .50267 1.875 0 Mabsadd L
.7789 .50267 0 -2.5 Mabsadd L
.7789 .50267 -1.875 0 Mabsadd L closepath F
.78018 .50268 -1.875 0 Mabsadd m
.78018 .50268 0 2.5 Mabsadd L
.78018 .50268 1.875 0 Mabsadd L
.78018 .50268 0 -2.5 Mabsadd L
.78018 .50268 -1.875 0 Mabsadd L closepath F
.7842 .50444 -1.875 0 Mabsadd m
.7842 .50444 0 2.5 Mabsadd L
.7842 .50444 1.875 0 Mabsadd L
.7842 .50444 0 -2.5 Mabsadd L
.7842 .50444 -1.875 0 Mabsadd L closepath F
.78446 .50472 -1.875 0 Mabsadd m
.78446 .50472 0 2.5 Mabsadd L
.78446 .50472 1.875 0 Mabsadd L
.78446 .50472 0 -2.5 Mabsadd L
.78446 .50472 -1.875 0 Mabsadd L closepath F
.78683 .50593 -1.875 0 Mabsadd m
.78683 .50593 0 2.5 Mabsadd L
.78683 .50593 1.875 0 Mabsadd L
.78683 .50593 0 -2.5 Mabsadd L
.78683 .50593 -1.875 0 Mabsadd L closepath F
.78777 .50602 -1.875 0 Mabsadd m
.78777 .50602 0 2.5 Mabsadd L
.78777 .50602 1.875 0 Mabsadd L
.78777 .50602 0 -2.5 Mabsadd L
.78777 .50602 -1.875 0 Mabsadd L closepath F
.79133 .50655 -1.875 0 Mabsadd m
.79133 .50655 0 2.5 Mabsadd L
.79133 .50655 1.875 0 Mabsadd L
.79133 .50655 0 -2.5 Mabsadd L
.79133 .50655 -1.875 0 Mabsadd L closepath F
.79137 .5089 -1.875 0 Mabsadd m
.79137 .5089 0 2.5 Mabsadd L
.79137 .5089 1.875 0 Mabsadd L
.79137 .5089 0 -2.5 Mabsadd L
.79137 .5089 -1.875 0 Mabsadd L closepath F
.79624 .51149 -1.875 0 Mabsadd m
.79624 .51149 0 2.5 Mabsadd L
.79624 .51149 1.875 0 Mabsadd L
.79624 .51149 0 -2.5 Mabsadd L
.79624 .51149 -1.875 0 Mabsadd L closepath F
.7984 .51195 -1.875 0 Mabsadd m
.7984 .51195 0 2.5 Mabsadd L
.7984 .51195 1.875 0 Mabsadd L
.7984 .51195 0 -2.5 Mabsadd L
.7984 .51195 -1.875 0 Mabsadd L closepath F
.80059 .51599 -1.875 0 Mabsadd m
.80059 .51599 0 2.5 Mabsadd L
.80059 .51599 1.875 0 Mabsadd L
.80059 .51599 0 -2.5 Mabsadd L
.80059 .51599 -1.875 0 Mabsadd L closepath F
.80371 .51873 -1.875 0 Mabsadd m
.80371 .51873 0 2.5 Mabsadd L
.80371 .51873 1.875 0 Mabsadd L
.80371 .51873 0 -2.5 Mabsadd L
.80371 .51873 -1.875 0 Mabsadd L closepath F
.80444 .51989 -1.875 0 Mabsadd m
.80444 .51989 0 2.5 Mabsadd L
.80444 .51989 1.875 0 Mabsadd L
.80444 .51989 0 -2.5 Mabsadd L
.80444 .51989 -1.875 0 Mabsadd L closepath F
.80509 .52063 -1.875 0 Mabsadd m
.80509 .52063 0 2.5 Mabsadd L
.80509 .52063 1.875 0 Mabsadd L
.80509 .52063 0 -2.5 Mabsadd L
.80509 .52063 -1.875 0 Mabsadd L closepath F
.80641 .52182 -1.875 0 Mabsadd m
.80641 .52182 0 2.5 Mabsadd L
.80641 .52182 1.875 0 Mabsadd L
.80641 .52182 0 -2.5 Mabsadd L
.80641 .52182 -1.875 0 Mabsadd L closepath F
.81351 .52498 -1.875 0 Mabsadd m
.81351 .52498 0 2.5 Mabsadd L
.81351 .52498 1.875 0 Mabsadd L
.81351 .52498 0 -2.5 Mabsadd L
.81351 .52498 -1.875 0 Mabsadd L closepath F
.81648 .52518 -1.875 0 Mabsadd m
.81648 .52518 0 2.5 Mabsadd L
.81648 .52518 1.875 0 Mabsadd L
.81648 .52518 0 -2.5 Mabsadd L
.81648 .52518 -1.875 0 Mabsadd L closepath F
.82106 .52519 -1.875 0 Mabsadd m
.82106 .52519 0 2.5 Mabsadd L
.82106 .52519 1.875 0 Mabsadd L
.82106 .52519 0 -2.5 Mabsadd L
.82106 .52519 -1.875 0 Mabsadd L closepath F
.82311 .52806 -1.875 0 Mabsadd m
.82311 .52806 0 2.5 Mabsadd L
.82311 .52806 1.875 0 Mabsadd L
.82311 .52806 0 -2.5 Mabsadd L
.82311 .52806 -1.875 0 Mabsadd L closepath F
.82679 .5283 -1.875 0 Mabsadd m
.82679 .5283 0 2.5 Mabsadd L
.82679 .5283 1.875 0 Mabsadd L
.82679 .5283 0 -2.5 Mabsadd L
.82679 .5283 -1.875 0 Mabsadd L closepath F
.83828 .53039 -1.875 0 Mabsadd m
.83828 .53039 0 2.5 Mabsadd L
.83828 .53039 1.875 0 Mabsadd L
.83828 .53039 0 -2.5 Mabsadd L
.83828 .53039 -1.875 0 Mabsadd L closepath F
.84272 .53105 -1.875 0 Mabsadd m
.84272 .53105 0 2.5 Mabsadd L
.84272 .53105 1.875 0 Mabsadd L
.84272 .53105 0 -2.5 Mabsadd L
.84272 .53105 -1.875 0 Mabsadd L closepath F
.8428 .53186 -1.875 0 Mabsadd m
.8428 .53186 0 2.5 Mabsadd L
.8428 .53186 1.875 0 Mabsadd L
.8428 .53186 0 -2.5 Mabsadd L
.8428 .53186 -1.875 0 Mabsadd L closepath F
.84532 .53224 -1.875 0 Mabsadd m
.84532 .53224 0 2.5 Mabsadd L
.84532 .53224 1.875 0 Mabsadd L
.84532 .53224 0 -2.5 Mabsadd L
.84532 .53224 -1.875 0 Mabsadd L closepath F
.8506 .53423 -1.875 0 Mabsadd m
.8506 .53423 0 2.5 Mabsadd L
.8506 .53423 1.875 0 Mabsadd L
.8506 .53423 0 -2.5 Mabsadd L
.8506 .53423 -1.875 0 Mabsadd L closepath F
.85202 .53648 -1.875 0 Mabsadd m
.85202 .53648 0 2.5 Mabsadd L
.85202 .53648 1.875 0 Mabsadd L
.85202 .53648 0 -2.5 Mabsadd L
.85202 .53648 -1.875 0 Mabsadd L closepath F
.85324 .53719 -1.875 0 Mabsadd m
.85324 .53719 0 2.5 Mabsadd L
.85324 .53719 1.875 0 Mabsadd L
.85324 .53719 0 -2.5 Mabsadd L
.85324 .53719 -1.875 0 Mabsadd L closepath F
.85898 .5385 -1.875 0 Mabsadd m
.85898 .5385 0 2.5 Mabsadd L
.85898 .5385 1.875 0 Mabsadd L
.85898 .5385 0 -2.5 Mabsadd L
.85898 .5385 -1.875 0 Mabsadd L closepath F
.86189 .54184 -1.875 0 Mabsadd m
.86189 .54184 0 2.5 Mabsadd L
.86189 .54184 1.875 0 Mabsadd L
.86189 .54184 0 -2.5 Mabsadd L
.86189 .54184 -1.875 0 Mabsadd L closepath F
.86237 .54426 -1.875 0 Mabsadd m
.86237 .54426 0 2.5 Mabsadd L
.86237 .54426 1.875 0 Mabsadd L
.86237 .54426 0 -2.5 Mabsadd L
.86237 .54426 -1.875 0 Mabsadd L closepath F
.8658 .54521 -1.875 0 Mabsadd m
.8658 .54521 0 2.5 Mabsadd L
.8658 .54521 1.875 0 Mabsadd L
.8658 .54521 0 -2.5 Mabsadd L
.8658 .54521 -1.875 0 Mabsadd L closepath F
.86664 .54903 -1.875 0 Mabsadd m
.86664 .54903 0 2.5 Mabsadd L
.86664 .54903 1.875 0 Mabsadd L
.86664 .54903 0 -2.5 Mabsadd L
.86664 .54903 -1.875 0 Mabsadd L closepath F
.86922 .54955 -1.875 0 Mabsadd m
.86922 .54955 0 2.5 Mabsadd L
.86922 .54955 1.875 0 Mabsadd L
.86922 .54955 0 -2.5 Mabsadd L
.86922 .54955 -1.875 0 Mabsadd L closepath F
.87388 .55145 -1.875 0 Mabsadd m
.87388 .55145 0 2.5 Mabsadd L
.87388 .55145 1.875 0 Mabsadd L
.87388 .55145 0 -2.5 Mabsadd L
.87388 .55145 -1.875 0 Mabsadd L closepath F
.8759 .55385 -1.875 0 Mabsadd m
.8759 .55385 0 2.5 Mabsadd L
.8759 .55385 1.875 0 Mabsadd L
.8759 .55385 0 -2.5 Mabsadd L
.8759 .55385 -1.875 0 Mabsadd L closepath F
.8782 .55664 -1.875 0 Mabsadd m
.8782 .55664 0 2.5 Mabsadd L
.8782 .55664 1.875 0 Mabsadd L
.8782 .55664 0 -2.5 Mabsadd L
.8782 .55664 -1.875 0 Mabsadd L closepath F
.88263 .55946 -1.875 0 Mabsadd m
.88263 .55946 0 2.5 Mabsadd L
.88263 .55946 1.875 0 Mabsadd L
.88263 .55946 0 -2.5 Mabsadd L
.88263 .55946 -1.875 0 Mabsadd L closepath F
.88334 .56338 -1.875 0 Mabsadd m
.88334 .56338 0 2.5 Mabsadd L
.88334 .56338 1.875 0 Mabsadd L
.88334 .56338 0 -2.5 Mabsadd L
.88334 .56338 -1.875 0 Mabsadd L closepath F
.88352 .56364 -1.875 0 Mabsadd m
.88352 .56364 0 2.5 Mabsadd L
.88352 .56364 1.875 0 Mabsadd L
.88352 .56364 0 -2.5 Mabsadd L
.88352 .56364 -1.875 0 Mabsadd L closepath F
.88481 .56402 -1.875 0 Mabsadd m
.88481 .56402 0 2.5 Mabsadd L
.88481 .56402 1.875 0 Mabsadd L
.88481 .56402 0 -2.5 Mabsadd L
.88481 .56402 -1.875 0 Mabsadd L closepath F
.88769 .56921 -1.875 0 Mabsadd m
.88769 .56921 0 2.5 Mabsadd L
.88769 .56921 1.875 0 Mabsadd L
.88769 .56921 0 -2.5 Mabsadd L
.88769 .56921 -1.875 0 Mabsadd L closepath F
.88827 .56961 -1.875 0 Mabsadd m
.88827 .56961 0 2.5 Mabsadd L
.88827 .56961 1.875 0 Mabsadd L
.88827 .56961 0 -2.5 Mabsadd L
.88827 .56961 -1.875 0 Mabsadd L closepath F
.89072 .57273 -1.875 0 Mabsadd m
.89072 .57273 0 2.5 Mabsadd L
.89072 .57273 1.875 0 Mabsadd L
.89072 .57273 0 -2.5 Mabsadd L
.89072 .57273 -1.875 0 Mabsadd L closepath F
.89654 .57731 -1.875 0 Mabsadd m
.89654 .57731 0 2.5 Mabsadd L
.89654 .57731 1.875 0 Mabsadd L
.89654 .57731 0 -2.5 Mabsadd L
.89654 .57731 -1.875 0 Mabsadd L closepath F
.90621 .57779 -1.875 0 Mabsadd m
.90621 .57779 0 2.5 Mabsadd L
.90621 .57779 1.875 0 Mabsadd L
.90621 .57779 0 -2.5 Mabsadd L
.90621 .57779 -1.875 0 Mabsadd L closepath F
.91165 .57846 -1.875 0 Mabsadd m
.91165 .57846 0 2.5 Mabsadd L
.91165 .57846 1.875 0 Mabsadd L
.91165 .57846 0 -2.5 Mabsadd L
.91165 .57846 -1.875 0 Mabsadd L closepath F
.91444 .57924 -1.875 0 Mabsadd m
.91444 .57924 0 2.5 Mabsadd L
.91444 .57924 1.875 0 Mabsadd L
.91444 .57924 0 -2.5 Mabsadd L
.91444 .57924 -1.875 0 Mabsadd L closepath F
.91637 .58049 -1.875 0 Mabsadd m
.91637 .58049 0 2.5 Mabsadd L
.91637 .58049 1.875 0 Mabsadd L
.91637 .58049 0 -2.5 Mabsadd L
.91637 .58049 -1.875 0 Mabsadd L closepath F
.92342 .58136 -1.875 0 Mabsadd m
.92342 .58136 0 2.5 Mabsadd L
.92342 .58136 1.875 0 Mabsadd L
.92342 .58136 0 -2.5 Mabsadd L
.92342 .58136 -1.875 0 Mabsadd L closepath F
.92547 .58177 -1.875 0 Mabsadd m
.92547 .58177 0 2.5 Mabsadd L
.92547 .58177 1.875 0 Mabsadd L
.92547 .58177 0 -2.5 Mabsadd L
.92547 .58177 -1.875 0 Mabsadd L closepath F
.92706 .58533 -1.875 0 Mabsadd m
.92706 .58533 0 2.5 Mabsadd L
.92706 .58533 1.875 0 Mabsadd L
.92706 .58533 0 -2.5 Mabsadd L
.92706 .58533 -1.875 0 Mabsadd L closepath F
.9277 .58571 -1.875 0 Mabsadd m
.9277 .58571 0 2.5 Mabsadd L
.9277 .58571 1.875 0 Mabsadd L
.9277 .58571 0 -2.5 Mabsadd L
.9277 .58571 -1.875 0 Mabsadd L closepath F
.933 .58582 -1.875 0 Mabsadd m
.933 .58582 0 2.5 Mabsadd L
.933 .58582 1.875 0 Mabsadd L
.933 .58582 0 -2.5 Mabsadd L
.933 .58582 -1.875 0 Mabsadd L closepath F
.9352 .58616 -1.875 0 Mabsadd m
.9352 .58616 0 2.5 Mabsadd L
.9352 .58616 1.875 0 Mabsadd L
.9352 .58616 0 -2.5 Mabsadd L
.9352 .58616 -1.875 0 Mabsadd L closepath F
.93679 .58646 -1.875 0 Mabsadd m
.93679 .58646 0 2.5 Mabsadd L
.93679 .58646 1.875 0 Mabsadd L
.93679 .58646 0 -2.5 Mabsadd L
.93679 .58646 -1.875 0 Mabsadd L closepath F
.93934 .58728 -1.875 0 Mabsadd m
.93934 .58728 0 2.5 Mabsadd L
.93934 .58728 1.875 0 Mabsadd L
.93934 .58728 0 -2.5 Mabsadd L
.93934 .58728 -1.875 0 Mabsadd L closepath F
.93949 .58786 -1.875 0 Mabsadd m
.93949 .58786 0 2.5 Mabsadd L
.93949 .58786 1.875 0 Mabsadd L
.93949 .58786 0 -2.5 Mabsadd L
.93949 .58786 -1.875 0 Mabsadd L closepath F
.94165 .58955 -1.875 0 Mabsadd m
.94165 .58955 0 2.5 Mabsadd L
.94165 .58955 1.875 0 Mabsadd L
.94165 .58955 0 -2.5 Mabsadd L
.94165 .58955 -1.875 0 Mabsadd L closepath F
.95279 .5913 -1.875 0 Mabsadd m
.95279 .5913 0 2.5 Mabsadd L
.95279 .5913 1.875 0 Mabsadd L
.95279 .5913 0 -2.5 Mabsadd L
.95279 .5913 -1.875 0 Mabsadd L closepath F
.95954 .59148 -1.875 0 Mabsadd m
.95954 .59148 0 2.5 Mabsadd L
.95954 .59148 1.875 0 Mabsadd L
.95954 .59148 0 -2.5 Mabsadd L
.95954 .59148 -1.875 0 Mabsadd L closepath F
.96935 .59483 -1.875 0 Mabsadd m
.96935 .59483 0 2.5 Mabsadd L
.96935 .59483 1.875 0 Mabsadd L
.96935 .59483 0 -2.5 Mabsadd L
.96935 .59483 -1.875 0 Mabsadd L closepath F
.97191 .59516 -1.875 0 Mabsadd m
.97191 .59516 0 2.5 Mabsadd L
.97191 .59516 1.875 0 Mabsadd L
.97191 .59516 0 -2.5 Mabsadd L
.97191 .59516 -1.875 0 Mabsadd L closepath F
.97249 .5985 -1.875 0 Mabsadd m
.97249 .5985 0 2.5 Mabsadd L
.97249 .5985 1.875 0 Mabsadd L
.97249 .5985 0 -2.5 Mabsadd L
.97249 .5985 -1.875 0 Mabsadd L closepath F
.97329 .60014 -1.875 0 Mabsadd m
.97329 .60014 0 2.5 Mabsadd L
.97329 .60014 1.875 0 Mabsadd L
.97329 .60014 0 -2.5 Mabsadd L
.97329 .60014 -1.875 0 Mabsadd L closepath F
.97468 .60146 -1.875 0 Mabsadd m
.97468 .60146 0 2.5 Mabsadd L
.97468 .60146 1.875 0 Mabsadd L
.97468 .60146 0 -2.5 Mabsadd L
.97468 .60146 -1.875 0 Mabsadd L closepath F
.97619 .60332 -1.875 0 Mabsadd m
.97619 .60332 0 2.5 Mabsadd L
.97619 .60332 1.875 0 Mabsadd L
.97619 .60332 0 -2.5 Mabsadd L
.97619 .60332 -1.875 0 Mabsadd L closepath F
.5 Mabswid
.02861 .01768 m
.97619 .60386 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00A`3oool2000000@0oooo0P0000030?ooo`@000009P3oool2000000@0oooo0P0000050?oo
o`<00000903oool2000000@0oooo0P0000030?ooo`<000009P3oool2000000@0oooo0P0000040?oo
o`800000;03oool5000000T0oooo00160?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool09P3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0280oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000;@3oool00`000000oooo0?ooo`090?ooo`00AP3oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo02D0oooo00@000000?ooo`3oool00000203oool5
000002<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000;@3oool00`000000oooo0?ooo`090?oo
o`00AP3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo02@0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000003oool0oooo000000P0oooo
0`00000U0?ooo`040000003oool0oooo000000T0oooo0P00000^0?ooo`030000003oool0oooo00T0
oooo00160?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000009@3oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0000002@0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo0?ooo`0T0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
0000;@3oool00`000000oooo0?ooo`090?ooo`00A`3oool2000000X0oooo0P00000W0?ooo`800000
2`3oool2000002D0oooo0P00000:0?ooo`<000009@3oool2000000X0oooo0P00000]0?ooo`800000
2`3oool00?l0oooo;@3oool00?l0oooo;@3oool001X0oooo00<000000?ooo`3oool0o`3oool@0?oo
o`006P3oool00`000000oooo0?ooo`3o0?oooa00oooo000J0?ooo`030000003oool0oooo0?l0oooo
403oool001X0oooo0P00003o0?oooa40oooo000C0?ooool000005@0000050?ooo`006@3oool60000
00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`006P3oool700000003
0?ooo`000000oooo02X0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0a0?ooo`03
0000003oool0oooo0340oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`090?ooo`00
6P3oool:00000?l0oooo2@3oool001X0oooo00@000000?ooo`3oool0oooo1`0000020?ooo`800000
o`3oool40?ooo`006P3oool00`000000oooo0?ooo`020?ooo`H000000P3oool200000?l0oooo103o
ool001X0oooo00<000000?ooo`3oool01@3oool3000000030?ooo`000000000000<00000o`3oool2
0?ooo`006P3oool00`000000oooo0?ooo`060?ooo`<0000000<0oooo000000000000100000020?oo
o`030000003oool0oooo0?X0oooo000J0?ooo`8000002P3oool;00000?/0oooo000J0?ooo`030000
003oool0oooo00X0oooo0P0000000`3oool000000000000700000?T0oooo000J0?ooo`030000003o
ool0oooo00`0oooo100000000`3oool000000000000400000?P0oooo000J0?ooo`030000003oool0
oooo00h0oooo0P0000020?ooo`D00000n03oool001X0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0500000?L0oooo000J0?ooo`030000003oool0oooo0140oooo0P0000000`3oool0
00000000000300000?H0oooo000J0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`000000
0`00003f0?ooo`006P3oool00`000000oooo0?ooo`0D0?ooo`H00000103oool00`000000oooo0?oo
o`3^0?ooo`006P3oool2000001L0oooo1@0000020?ooo`800000l03oool001X0oooo00<000000?oo
o`3oool05`3oool4000000040?ooo`000000000000000?00oooo000J0?ooo`030000003oool0oooo
01P0oooo0`0000020?ooo`<0000000<0oooo0000003oool0k03oool001X0oooo00<000000?ooo`3o
ool06`3oool2000000030?ooo`000000000000@00000j`3oool001X0oooo00<000000?ooo`3oool0
7@3oool800000>X0oooo000J0?ooo`030000003oool0oooo01h0oooo1`00003Z0?ooo`006P3oool0
0`000000oooo0?ooo`0P0?ooo`040000003oool0000000000>/0oooo000J0?ooo`030000003oool0
oooo0240oooo0P00003/0?ooo`006P3oool2000002@0oooo0P0000001@3oool000000?ooo`3oool0
00000>D0oooo000J0?ooo`030000003oool0oooo02D0oooo1P00003T0?ooo`006P3oool00`000000
oooo0?ooo`0U0?ooo`X00000h03oool001X0oooo00<000000?ooo`3oool09P3oool00`000000oooo
00000007000000030?ooo`000000oooo0=`0oooo000J0?ooo`030000003oool0oooo02T0oooo2P00
003L0?ooo`006P3oool00`000000oooo0?ooo`0[0?ooo`P00000g03oool000H0oooo0P0000040?oo
o`8000000`3oool4000000D0oooo00<000000?ooo`3oool0;@3oool700000=/0oooo00050?ooo`04
0000003oool0oooo000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0^0?oo
o`L00000fP3oool000D0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`050?oo
o`<00000<03oool6000000@0oooo00<000000?ooo`3oool0dP3oool000D0oooo00@000000?ooo`3o
ool000002P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0380oooo1@0000020?oo
o`<00000d`3oool000D0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo03<0oooo100000000`3oool000000000000300000=80oooo00060?oo
o`8000002P3oool2000000H0oooo00<000000?ooo`3oool0=@3oool200000080oooo1000003B0?oo
o`006P3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo00<0000000<0oooo0000003o
ool0c`3oool001X0oooo00<000000?ooo`3oool0>03oool2000000030?ooo`000000000000800000
d03oool001X0oooo00<000000?ooo`3oool0>P3oool600000<l0oooo000J0?ooo`030000003oool0
oooo03/0oooo1@00003?0?ooo`006P3oool2000003h0oooo1000003>0?ooo`006P3oool00`000000
oooo0?ooo`0m0?ooo`@00000cP3oool001X0oooo00<000000?ooo`3oool0?@3oool500000<d0oooo
000J0?ooo`030000003oool0oooo03d0oooo1`00003;0?ooo`006P3oool00`000000oooo0?ooo`0n
0?ooo`L00000bP3oool001X0oooo00<000000?ooo`3oool0?`3oool800000<P0oooo000J0?ooo`03
0000003oool0oooo0400oooo1P0000000`3oool000000?ooo`360?ooo`006P3oool00`000000oooo
0?ooo`110?ooo`H0000000<0oooo000000000000a@3oool001X0oooo00<000000?ooo`3oool0@P3o
ool:00000<<0oooo000J0?ooo`800000A@3oool900000<80oooo000J0?ooo`030000003oool0oooo
04D0oooo2P0000300?ooo`006P3oool00`000000oooo0?ooo`180?ooo`H0000000<0oooo00000000
0000_P3oool001X0oooo00<000000?ooo`3oool0B@3oool600000080oooo00<000000?ooo`3oool0
^`3oool001X0oooo00<000000?ooo`3oool0BP3oool600000080oooo0P00002k0?ooo`006P3oool0
0`000000oooo0?ooo`1<0?ooo`H000000P3oool00`000000oooo0?ooo`2h0?ooo`006P3oool00`00
0000oooo0?ooo`1=0?ooo`H000000P3oool200000;P0oooo000J0?ooo`030000003oool0oooo04h0
oooo1P0000030?ooo`800000]P3oool001X0oooo0P00001@0?ooo`H00000103oool00`000000oooo
0?ooo`2c0?ooo`006P3oool00`000000oooo0?ooo`1@0?ooo`H00000103oool200000;<0oooo000J
0?ooo`030000003oool0oooo0540oooo1@0000060?ooo`800000/@3oool001X0oooo00<000000?oo
o`3oool0D`3oool4000000L0oooo00<000000?ooo`3oool0[P3oool001X0oooo00<000000?ooo`3o
ool0DP3oool6000000040?ooo`0000000000000000<0oooo0P00002^0?ooo`006P3oool00`000000
oooo0?ooo`1C0?ooo``000000P3oool00`000000oooo0?ooo`2[0?ooo`001P3oool2000000@0oooo
0P0000050?ooo`<00000103oool00`000000oooo0?ooo`1D0?ooo`030000003oool0000000T00000
0P3oool200000:/0oooo00050?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0000000L000000`3oool200000:T0oooo
00050?ooo`040000003oool0oooo000000P0oooo1@0000040?ooo`<00000G03oool7000000<0oooo
00<000000?ooo`3oool0YP3oool000D0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`0000050?ooo`030000003oool0oooo05d0oooo200000020?ooo`800000YP3oool000D0oooo
00@000000?ooo`3oool000002@3oool00`000000oooo000000050?ooo`030000003oool0oooo05l0
oooo200000020?ooo`800000Y03oool000H0oooo0P00000;0?ooo`8000001@3oool00`000000oooo
0?ooo`1P0?ooo`P000000`3oool00`000000oooo0?ooo`2Q0?ooo`006P3oool00`000000oooo0?oo
o`1S0?ooo`D00000103oool200000:40oooo000J0?ooo`030000003oool0oooo06@0oooo1@000005
0?ooo`030000003oool0oooo09h0oooo000J0?ooo`030000003oool0oooo06D0oooo1`0000030?oo
o`800000WP3oool001X0oooo00<000000?ooo`3oool0IP3oool7000000@0oooo0P00002L0?ooo`00
6P3oool2000006P0oooo1P0000060?ooo`030000003oool0oooo09T0oooo000J0?ooo`030000003o
ool0oooo06T0oooo1@0000060?ooo`800000V@3oool001X0oooo00<000000?ooo`3oool0JP3oool5
000000L0oooo0P00002G0?ooo`006P3oool00`000000oooo0?ooo`1[0?ooo`@000002@3oool00`00
0000oooo0?ooo`2D0?ooo`006P3oool00`000000oooo0?ooo`1/0?ooo`@000002@3oool2000009@0
oooo000J0?ooo`030000003oool0oooo06`0oooo1P0000000`3oool000000?ooo`060?ooo`030000
003oool0oooo0940oooo000J0?ooo`030000003oool0oooo06d0oooo200000070?ooo`800000T@3o
ool001X0oooo00<000000?ooo`3oool0KP3oool8000000P0oooo0P00002?0?ooo`006P3oool20000
0740oooo1`0000020?ooo`8000001@3oool00`000000oooo0?ooo`2<0?ooo`006P3oool00`000000
oooo0?ooo`1c0?ooo`@0000000@0oooo00000000000000001P3oool2000008`0oooo000J0?ooo`03
0000003oool0oooo07@0oooo0P0000020?ooo`@000001`3oool2000008X0oooo000J0?ooo`030000
003oool0oooo07P0oooo1@0000000`3oool00000000000050?ooo`030000003oool0oooo08L0oooo
000J0?ooo`030000003oool0oooo07T0oooo200000050?ooo`800000Q`3oool001X0oooo00<00000
0?ooo`3oool0NP3oool9000000D0oooo00<000000?ooo`3oool0Q03oool001X0oooo00<000000?oo
o`3oool0O@3oool7000000D0oooo0P0000240?ooo`006P3oool00`000000oooo0?ooo`1o0?ooo`H0
000000<0oooo0000003oool00`3oool200000880oooo000J0?ooo`800000P@3oool8000000D0oooo
00<000000?ooo`3oool0O`3oool001X0oooo00<000000?ooo`3oool0PP3oool7000000D0oooo0P00
001o0?ooo`006P3oool00`000000oooo0?ooo`230?ooo`H0000000<0oooo0000003oool0103oool2
000007d0oooo000J0?ooo`030000003oool0oooo08H0oooo0P0000020?ooo`D000000`3oool00`00
0000oooo0?ooo`1j0?ooo`006P3oool00`000000oooo0?ooo`290?ooo`L000000`3oool2000007X0
oooo000J0?ooo`030000003oool0oooo08X0oooo1P0000050?ooo`030000003oool0oooo07L0oooo
00060?ooo`800000103oool2000000<0oooo0`0000060?ooo`030000003oool0oooo08`0oooo1@00
00050?ooo`800000M`3oool000D0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000050?ooo`030000003oool0oooo08d0oooo1@0000000`3oool000000?ooo`030?ooo`800000
M@3oool000D0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000050?ooo`<0
0000SP3oool8000000@0oooo00<000000?ooo`3oool0LP3oool000D0oooo00@000000?ooo`3oool0
0000203oool3000000H0oooo00<000000?ooo`3oool0S`3oool9000000030?ooo`000000oooo0080
0000LP3oool000D0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0980oooo2P0000000`3oool000000000001`0?ooo`001P3oool2000000X0oooo
0`0000050?ooo`030000003oool0oooo09<0oooo2@0000030?ooo`030000003oool0oooo06d0oooo
000J0?ooo`030000003oool0oooo09H0oooo2@0000000`3oool000000000001]0?ooo`006P3oool0
0`000000oooo0?ooo`2J0?ooo`H000000P3oool00`000000oooo0?ooo`1Z0?ooo`006P3oool00`00
0000oooo0?ooo`2K0?ooo`H000000P3oool2000006X0oooo000J0?ooo`030000003oool0oooo09`0
oooo1P0000000`3oool000000?ooo`02000006P0oooo000J0?ooo`800000WP3oool;000006L0oooo
000J0?ooo`030000003oool0oooo09l0oooo2`00001U0?ooo`006P3oool00`000000oooo0?ooo`2Q
0?ooo`/00000H`3oool001X0oooo00<000000?ooo`3oool0Y03oool7000000030?ooo`000000oooo
0640oooo000J0?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`0000000`0000000`3oool0
00000000001P0?ooo`006P3oool00`000000oooo0?ooo`2Y0?ooo`@000000P3oool2000005h0oooo
000J0?ooo`030000003oool0oooo0:X0oooo0`0000000`3oool0000000000002000005d0oooo000J
0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`0000001P00001K0?ooo`006P3oool20000
0:l0oooo1`00001J0?ooo`006P3oool00`000000oooo0?ooo`2`0?ooo`@0000000<0oooo00000000
0000F03oool001X0oooo00<000000?ooo`3oool0/@3oool400000080oooo0P00001F0?ooo`006P3o
ool00`000000oooo0?ooo`2a0?ooo`@00000103oool00`000000oooo0?ooo`1C0?ooo`006P3oool0
0`000000oooo0?ooo`2a0?ooo`P0000000<0oooo000000000000D`3oool001X0oooo00<000000?oo
o`3oool0/P3oool800000080oooo00<000000?ooo`3oool0D03oool001X0oooo00<000000?ooo`3o
ool0/`3oool9000000030?ooo`00000000000500oooo000J0?ooo`030000003oool0oooo0;H0oooo
1`0000020?ooo`800000CP3oool001X0oooo0P00002i0?ooo`D0000000D0oooo0000003oool0oooo
0000001=0?ooo`006P3oool00`000000oooo0?ooo`2i0?ooo`P0000000<0oooo000000000000B`3o
ool001X0oooo00<000000?ooo`3oool0^`3oool7000000040?ooo`0000000000000004T0oooo000J
0?ooo`030000003oool0oooo0;/0oooo00<000000?ooo`0000002@0000180?ooo`006P3oool00`00
0000oooo0?ooo`2n0?ooo`/00000AP3oool001X0oooo00<000000?ooo`3oool0`@3oool700000003
0?ooo`000000oooo04@0oooo000J0?ooo`030000003oool0oooo0<@0oooo200000130?ooo`001P3o
ool2000000@0oooo0P0000040?ooo`8000001P3oool00`000000oooo0?ooo`350?ooo`H0000000<0
oooo000000000000@@3oool000D0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000050?ooo`030000003oool0oooo0<H0oooo1@0000030?ooo`030000003oool0oooo03h0oooo
00050?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000001@3oool300000<P0
oooo100000030?ooo`800000?P3oool000D0oooo00@000000?ooo`3oool000002@3oool2000000H0
oooo00<000000?ooo`3oool0a`3oool6000000@0oooo0P00000l0?ooo`001@3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0b03oool50000
00H0oooo00<000000?ooo`3oool0>@3oool000H0oooo0P00000:0?ooo`8000001P3oool00`000000
oooo0?ooo`3:0?ooo`H00000103oool2000003T0oooo000J0?ooo`030000003oool0oooo0<X0oooo
1`0000050?ooo`030000003oool0oooo03H0oooo000J0?ooo`030000003oool0oooo0</0oooo1`00
00050?ooo`800000=P3oool001X0oooo00<000000?ooo`3oool0c@3oool6000000H0oooo0P00000d
0?ooo`006P3oool00`000000oooo0?ooo`3?0?ooo`D000001`3oool00`000000oooo0?ooo`0a0?oo
o`006P3oool200000=80oooo1`0000040?ooo`800000<@3oool001X0oooo00<000000?ooo`3oool0
d@3oool9000000@0oooo0P00000_0?ooo`006P3oool00`000000oooo0?ooo`3B0?ooo`d0000000<0
oooo0000003oool0;@3oool001X0oooo00<000000?ooo`3oool0e@3oool>000002`0oooo000J0?oo
o`030000003oool0oooo0=L0oooo0`0000000`3oool0000000000004000000030?ooo`0000000000
02/0oooo000J0?ooo`030000003oool0oooo0=`0oooo2P00000Y0?ooo`006P3oool00`000000oooo
0?ooo`3O0?ooo`H0000000<0oooo0000000000009`3oool001X0oooo00<000000?ooo`3oool0h03o
ool600000080oooo00<000000?ooo`3oool0903oool001X0oooo0P00003S0?ooo`H0000000<0oooo
000000000000903oool001X0oooo00<000000?ooo`3oool0h`3oool5000000<0oooo0P00000R0?oo
o`006P3oool00`000000oooo0?ooo`3T0?ooo`D00000103oool00`000000oooo0?ooo`0O0?ooo`00
6P3oool00`000000oooo0?ooo`3U0?ooo`D00000103oool2000001l0oooo000J0?ooo`030000003o
ool0oooo0>H0oooo1@0000050?ooo`030000003oool0oooo01`0oooo000J0?ooo`030000003oool0
oooo0>L0oooo1@0000050?ooo`800000703oool001X0oooo00<000000?ooo`3oool0j03oool40000
00L0oooo0P00000J0?ooo`006P3oool00`000000oooo0?ooo`3Y0?ooo`@0000000<0oooo00000000
00000P0000030?ooo`030000003oool0oooo01L0oooo000J0?ooo`800000j`3oool;000000030?oo
o`000000000001L0oooo000J0?ooo`030000003oool0oooo0>/0oooo3`00000E0?ooo`006P3oool0
0`000000oooo0?ooo`3/0?ooo`030000003oool0oooo00`00000503oool001X0oooo00<000000?oo
o`3oool0lP3oool8000000040?ooo`000000000000000140oooo000J0?ooo`030000003oool0oooo
0?@0oooo3P00000=0?ooo`006P3oool00`000000oooo0?ooo`3h0?ooo`80000000<0oooo00000000
00001P00000<0?ooo`004@3oool5000000@0oooo00<000000?ooo`3oool0o03oool2000000030?oo
o`000000000000800000303oool001<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`3o0?ooo`40oooo1000000;0?ooo`004`3oool00`000000oooo0?ooo`040?ooo`<00000o`3oool2
0?ooo`<000002`3oool001<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oo
o`<0oooo00<000000?ooo`3oool02P3oool001<0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`3o0?oooa00oooo000B0?ooo`8000001P3oool00`000000oooo0?ooo`3o0?oooa00oooo
003o0?ooobd0oooo0000\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.100632, -0.0766778, \
0.00381683, 0.0061701}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S6.9.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ReferenceLineStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "style for the reference line",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotJoined", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "whether to draw a line through the cumulative points",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["PlotStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["style for the line",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SymbolStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["style for the points",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SymbolShape", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "function for drawing the points",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S6.9.1"],

Cell[TextData[{
 "Options for ",
 StyleBox["QuantilePlot", "MR"],
 ". "
}], "Caption",
 CellTags->"S6.9.1"],

Cell[TextData[{
 "Typical list plot operations are available to control the display. The \
option ",
 StyleBox["ReferenceLineStyle", "MR"],
 ", which can modify the reference line, can also be used. If it is set to ",
 StyleBox["None", "MR"],
 ", the reference line is not drawn; otherwise it should be set to a style or \
list of styles. ",
 StyleBox["SymbolShape", "MR"],
 " determines how the points are drawn; it takes a pure function in the same \
way that ",
 StyleBox["MultipleListPlot", "MR"],
 " does. ",
 StyleBox["SymbolStyle", "MR"],
 " allows an additional style to be specified for the points. ",
 StyleBox["PlotJoined", "MR"],
 " determines whether the quantiles line is drawn, while ",
 StyleBox["PlotStyle", "MR"],
 " specifies how the line is drawn. The usual ",
 StyleBox["Graphics", "MR"],
 " options may be supplied as well. "
}], "Text",
 CellTags->{"S6.9.1", "1.32"}],

Cell["\<\
Generate a quantile\[Hyphen]quantile plot with a modified appearance. \
\>", "MathCaption",
  CellTags->{"S6.9.1", "1.33"}],

Cell[CellGroupData[{

Cell["\<\
QuantilePlot[Table[Random[], {300}], Table[Random[], {300}],
  SymbolShape -> None,
  PlotJoined -> True,
  ReferenceLineStyle -> {Hue[0], Dashing[{0.02}]}]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.957297 0.0147151 0.589205 [
[.21527 .00222 -9 -9 ]
[.21527 .00222 9 0 ]
[.40673 .00222 -9 -9 ]
[.40673 .00222 9 0 ]
[.59819 .00222 -9 -9 ]
[.59819 .00222 9 0 ]
[.78965 .00222 -9 -9 ]
[.78965 .00222 9 0 ]
[.98111 .00222 -3 -9 ]
[.98111 .00222 3 0 ]
[.01131 .13256 -18 -4.5 ]
[.01131 .13256 0 4.5 ]
[.01131 .2504 -18 -4.5 ]
[.01131 .2504 0 4.5 ]
[.01131 .36824 -18 -4.5 ]
[.01131 .36824 0 4.5 ]
[.01131 .48608 -18 -4.5 ]
[.01131 .48608 0 4.5 ]
[.01131 .60392 -6 -4.5 ]
[.01131 .60392 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21527 .01472 m
.21527 .02097 L
s
[(0.2)] .21527 .00222 0 1 Mshowa
.40673 .01472 m
.40673 .02097 L
s
[(0.4)] .40673 .00222 0 1 Mshowa
.59819 .01472 m
.59819 .02097 L
s
[(0.6)] .59819 .00222 0 1 Mshowa
.78965 .01472 m
.78965 .02097 L
s
[(0.8)] .78965 .00222 0 1 Mshowa
.98111 .01472 m
.98111 .02097 L
s
[(1)] .98111 .00222 0 1 Mshowa
.125 Mabswid
.07167 .01472 m
.07167 .01847 L
s
.11954 .01472 m
.11954 .01847 L
s
.1674 .01472 m
.1674 .01847 L
s
.26313 .01472 m
.26313 .01847 L
s
.311 .01472 m
.311 .01847 L
s
.35886 .01472 m
.35886 .01847 L
s
.45459 .01472 m
.45459 .01847 L
s
.50246 .01472 m
.50246 .01847 L
s
.55032 .01472 m
.55032 .01847 L
s
.64605 .01472 m
.64605 .01847 L
s
.69392 .01472 m
.69392 .01847 L
s
.74178 .01472 m
.74178 .01847 L
s
.83751 .01472 m
.83751 .01847 L
s
.88538 .01472 m
.88538 .01847 L
s
.93324 .01472 m
.93324 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13256 m
.03006 .13256 L
s
[(0.2)] .01131 .13256 1 0 Mshowa
.02381 .2504 m
.03006 .2504 L
s
[(0.4)] .01131 .2504 1 0 Mshowa
.02381 .36824 m
.03006 .36824 L
s
[(0.6)] .01131 .36824 1 0 Mshowa
.02381 .48608 m
.03006 .48608 L
s
[(0.8)] .01131 .48608 1 0 Mshowa
.02381 .60392 m
.03006 .60392 L
s
[(1)] .01131 .60392 1 0 Mshowa
.125 Mabswid
.02381 .04418 m
.02756 .04418 L
s
.02381 .07364 m
.02756 .07364 L
s
.02381 .1031 m
.02756 .1031 L
s
.02381 .16202 m
.02756 .16202 L
s
.02381 .19148 m
.02756 .19148 L
s
.02381 .22094 m
.02756 .22094 L
s
.02381 .27986 m
.02756 .27986 L
s
.02381 .30932 m
.02756 .30932 L
s
.02381 .33878 m
.02756 .33878 L
s
.02381 .3977 m
.02756 .3977 L
s
.02381 .42716 m
.02756 .42716 L
s
.02381 .45662 m
.02756 .45662 L
s
.02381 .51554 m
.02756 .51554 L
s
.02381 .545 m
.02756 .545 L
s
.02381 .57446 m
.02756 .57446 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.001 w
.02546 .01754 m
.02833 .02123 L
.03507 .02754 L
.03697 .02916 L
.03994 .03004 L
.04237 .03058 L
.04321 .03362 L
.04887 .03649 L
.05282 .03932 L
.05942 .0399 L
.05947 .04066 L
.06246 .04191 L
.06449 .04358 L
.06485 .04645 L
.06792 .0483 L
.072 .05268 L
.07336 .05303 L
.07359 .05549 L
.07365 .0593 L
.07365 .06029 L
.07472 .06939 L
.07595 .07073 L
.08214 .07603 L
.08299 .08056 L
.08738 .08168 L
.08789 .08448 L
.09308 .08582 L
.09571 .08587 L
.09629 .08651 L
.11273 .08652 L
.12228 .08985 L
.12235 .09152 L
.13648 .09694 L
.14051 .09878 L
.14137 .10101 L
.15631 .10155 L
.15882 .10251 L
.15952 .1032 L
.16056 .10787 L
.16735 .10837 L
.16868 .10942 L
.16916 .11006 L
.17644 .11335 L
.17849 .11389 L
.17974 .11553 L
.18405 .11679 L
.18596 .1177 L
.19043 .11958 L
.19494 .12647 L
.19518 .12731 L
Mistroke
.19926 .12892 L
.19941 .13076 L
.20327 .13076 L
.20557 .13172 L
.20777 .13232 L
.20931 .13382 L
.21008 .13545 L
.21281 .13702 L
.21442 .13739 L
.2151 .13966 L
.21766 .1405 L
.22304 .14094 L
.22383 .14408 L
.23199 .1446 L
.23283 .14495 L
.23403 .14654 L
.23628 .14712 L
.23905 .14951 L
.24498 .151 L
.24534 .15296 L
.24904 .15334 L
.2522 .1538 L
.25384 .15676 L
.2588 .15832 L
.26641 .15875 L
.27975 .1612 L
.28217 .16419 L
.28286 .16428 L
.28318 .16483 L
.287 .17123 L
.29573 .17126 L
.30975 .17144 L
.31067 .17622 L
.31098 .17881 L
.31561 .18016 L
.32203 .18192 L
.32317 .1824 L
.33476 .18273 L
.33556 .18289 L
.33685 .18297 L
.34119 .18572 L
.35146 .18738 L
.36096 .19398 L
.36301 .19455 L
.36328 .19638 L
.36894 .19932 L
.36897 .19999 L
.36955 .20115 L
.37014 .20677 L
.37145 .20783 L
Mistroke
.37221 .20863 L
.37401 .21103 L
.38333 .2128 L
.38476 .21372 L
.3851 .21407 L
.3851 .21605 L
.38899 .21835 L
.39193 .21924 L
.40366 .22122 L
.40432 .22651 L
.41123 .23192 L
.41545 .23252 L
.41566 .23404 L
.41615 .23525 L
.4165 .23587 L
.41676 .23589 L
.41889 .23729 L
.42071 .24021 L
.42249 .24813 L
.42757 .25032 L
.42988 .25308 L
.43122 .25315 L
.4376 .25422 L
.44303 .25767 L
.44575 .25815 L
.44836 .2596 L
.45038 .26157 L
.45386 .26413 L
.45455 .26584 L
.45662 .26699 L
.457 .26887 L
.46106 .27054 L
.46164 .27479 L
.46189 .27525 L
.46515 .27743 L
.46551 .27945 L
.46585 .27991 L
.46999 .28025 L
.47056 .28282 L
.4787 .28339 L
.47972 .2878 L
.48251 .2887 L
.48323 .29024 L
.48357 .29087 L
.48523 .29337 L
.4869 .29356 L
.48828 .2962 L
.48996 .30277 L
.49149 .30429 L
.49559 .30593 L
Mistroke
.49792 .30671 L
.49975 .31125 L
.50104 .31212 L
.50367 .31276 L
.50538 .31353 L
.50542 .3144 L
.50902 .32069 L
.51175 .32135 L
.51213 .32202 L
.51304 .32266 L
.52027 .32544 L
.52116 .32614 L
.52314 .32689 L
.52569 .33133 L
.5271 .33284 L
.53206 .33505 L
.53444 .33611 L
.53507 .33675 L
.53714 .33844 L
.53977 .33863 L
.54109 .3404 L
.54338 .34164 L
.54767 .34184 L
.54928 .3457 L
.55069 .34892 L
.55353 .3513 L
.56032 .35749 L
.56129 .36033 L
.56376 .36266 L
.56485 .36422 L
.56795 .36457 L
.56866 .36587 L
.56895 .36604 L
.57863 .36664 L
.58559 .36748 L
.58928 .36771 L
.58979 .37311 L
.59657 .37542 L
.59696 .37665 L
.60003 .37869 L
.60279 .38 L
.60674 .38009 L
.61171 .38332 L
.62064 .38343 L
.62292 .38469 L
.62707 .38739 L
.62845 .38794 L
.63009 .38961 L
.63027 .3924 L
.63289 .39507 L
Mistroke
.63423 .39677 L
.64562 .3996 L
.64852 .39963 L
.65105 .40268 L
.65305 .40336 L
.65451 .40673 L
.66458 .40853 L
.66498 .41042 L
.66621 .41267 L
.66956 .41467 L
.67086 .41493 L
.67505 .41496 L
.67636 .41606 L
.68994 .41699 L
.69097 .42015 L
.6913 .42075 L
.70523 .42198 L
.71113 .42348 L
.71619 .42541 L
.71719 .426 L
.72153 .42659 L
.72291 .42886 L
.72429 .42912 L
.72727 .43047 L
.72976 .43351 L
.73035 .4356 L
.75145 .43616 L
.75233 .44131 L
.75403 .44209 L
.76883 .446 L
.77186 .4475 L
.77606 .44751 L
.77704 .44817 L
.77805 .45038 L
.77825 .45093 L
.78305 .4528 L
.78757 .45747 L
.78838 .46404 L
.79085 .47144 L
.80296 .4803 L
.80572 .48486 L
.80627 .48646 L
.80711 .48743 L
.80927 .49162 L
.8094 .49176 L
.81163 .4937 L
.81172 .49592 L
.81409 .49943 L
.81859 .50011 L
.81869 .50232 L
Mistroke
.81892 .50271 L
.82082 .50457 L
.83129 .5054 L
.83473 .50593 L
.83628 .50615 L
.84181 .50863 L
.84369 .50943 L
.84398 .5148 L
.84516 .51583 L
.84634 .51789 L
.84963 .51868 L
.85387 .52362 L
.85817 .52444 L
.85977 .52532 L
.86078 .52765 L
.86131 .52866 L
.87803 .52924 L
.87989 .53067 L
.88382 .53148 L
.88448 .5337 L
.88457 .54063 L
.88864 .54089 L
.89244 .54587 L
.89796 .54696 L
.89835 .54708 L
.90398 .54919 L
.92047 .55109 L
.92401 .55196 L
.92542 .55339 L
.92768 .5538 L
.93371 .55762 L
.93432 .55769 L
.93656 .55796 L
.93831 .56494 L
.93888 .56527 L
.93905 .56607 L
.94002 .56748 L
.94225 .56883 L
.94363 .56987 L
.94494 .57036 L
.94518 .57248 L
.95068 .57689 L
.95179 .58043 L
.95611 .58722 L
.95922 .58756 L
.96011 .59344 L
.96796 .59649 L
.96872 .5977 L
.97522 .60242 L
.97619 .60332 L
Mistroke
Mfstroke
1 0 0 r
.5 Mabswid
[ .02 ] 0 setdash
.02546 .01573 m
.98013 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00A`3oool2000000@0oooo0P0000030?ooo`@000009P3oool2000000@0oooo0P0000050?oo
o`<00000903oool2000000@0oooo0P0000030?ooo`<000009`3oool2000000@0oooo0P0000040?oo
o`800000;03oool5000000P0oooo00160?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool09P3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0280oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00000U0?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool00000;@3oool00`000000oooo0?ooo`080?ooo`00AP3oool010000000
oooo0?ooo`0000090?ooo`030000003oool0oooo02D0oooo00@000000?ooo`3oool00000203oool5
000002<0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000U0?ooo`040000
003oool0oooo000000P0oooo00@000000?ooo`3oool00000;@3oool00`000000oooo0?ooo`080?oo
o`00AP3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo02@0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`00000T0?ooo`040000003oool0oooo000000P0oooo
0`00000V0?ooo`040000003oool0oooo000000T0oooo0P00000^0?ooo`030000003oool0oooo00P0
oooo00160?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000009@3oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0000002@0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo0?ooo`0U0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
0000;@3oool00`000000oooo0?ooo`080?ooo`00A`3oool2000000X0oooo0P00000W0?ooo`800000
2`3oool2000002D0oooo0P00000:0?ooo`<000009P3oool2000000X0oooo0P00000]0?ooo`800000
2P3oool00?l0oooo;@3oool00?l0oooo;@3oool001T0oooo00<000000?ooo`3oool0o`3ooolA0?oo
o`006@3oool00`000000oooo0?ooo`3o0?oooa40oooo000I0?ooo`030000003oool0oooo0?l0oooo
4@3oool001T0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`004`3oool7000000030?l000000000
00000?l000002`0000050?ooo`006@3oool200000080o`002P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo00P0oooo000I0?ooo`040000003oool000000?ooo`80o`00;`3oool00`00
0000oooo0?ooo`0b0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0<P3oool00`00
0000oooo0?ooo`0b0?ooo`030000003oool0oooo00P0oooo000I0?ooo`030000003oool0oooo0080
000000<0oooo0?l0003oool0o`3oool<0?ooo`006@3oool010000000oooo0?ooo`3oool300000?l0
oooo3@3oool001T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooo`/0oooo
000I0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0o`00o`3oool90?ooo`006@3o
ool00`000000oooo0?ooo`050?ooo`<000000P3o003o0?ooo`L0oooo000I0?ooo`<000002@3oool0
0`000000o`000?l0003o0?ooo`D0oooo000I0?ooo`030000003oool0oooo00T0oooo0P0000000`3o
ool0o`000?ooo`3o0?ooo`<0oooo000I0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0o`3oool30?ooo`006@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0oooo
0`3oool001T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`030?ooo`030?l0003o
ool0oooo0?`0oooo000I0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool0
0`3o0000oooo0?ooo`3k0?ooo`006@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00D0oooo0P3o003k0?ooo`006@3oool00`000000oooo0?ooo`0;0?ooo`800000203oool00`3o0000
oooo0?ooo`3h0?ooo`006@3oool3000000d0oooo00<000000?ooo`3oool0o`3oool10?ooo`006@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0?l0oooo000I0?ooo`030000003oool0
oooo00h0oooo0P00000:0?ooo`80o`00m03oool001T0oooo00<000000?ooo`3oool03`3oool30000
00X0oooo0P3o003b0?ooo`006@3oool00`000000oooo0?ooo`0A0?ooo`L000001P3oool20?l00?00
oooo000I0?ooo`030000003oool0oooo01P0oooo0P00003f0?ooo`006@3oool00`000000oooo0?oo
o`0J0?ooo`800000m03oool001T0oooo00<000000?ooo`3oool0703oool3000000@0oooo00<0o`00
0?ooo`3oool0jP3oool001T0oooo0`00000N0?ooo`H000000P3o003Z0?ooo`006@3oool00`000000
oooo0?ooo`0S0?ooo`030000003oool0oooo0080o`00j03oool001T0oooo00<000000?ooo`3oool0
8`3oool300000080oooo00<0o`000?ooo`3oool0i@3oool001T0oooo00<000000?ooo`3oool09P3o
ool300000>L0oooo000I0?ooo`030000003oool0oooo02P0oooo0`00003U0?ooo`006@3oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0o`000>80oooo00060?ooo`800000103oool2000000<0
oooo100000040?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3o0000h@3oool000D0oooo
00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02d0
oooo0P0000020?l00=l0oooo00050?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3o
ool0103oool3000002h0oooo0`0000000`3o0000oooo0?ooo`3L0?ooo`001@3oool010000000oooo
0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0<03oool200000=h0
oooo00050?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`00
0000oooo0?ooo`0a0?ooo`800000g@3oool000H0oooo0P00000:0?ooo`8000001@3oool00`000000
oooo0?ooo`0c0?ooo`80000000<0oooo0?l0003oool0f03oool001T0oooo00<000000?ooo`3oool0
=03oool300000080o`00e`3oool001T0oooo00<000000?ooo`3oool0>@3oool20?l00=D0oooo000I
0?ooo`030000003oool0oooo03X0oooo00<000000?l000000000d`3oool001T0oooo00<000000?oo
o`3oool0?@3oool200000=40oooo000I0?ooo`<00000?`3oool600000</0oooo000I0?ooo`030000
003oool0oooo03l0oooo0P3o00040?ooo`030000003oool0oooo0<P0oooo000I0?ooo`030000003o
ool0oooo0440oooo0P3o00020?ooo`030000003oool0oooo0<P0oooo000I0?ooo`030000003oool0
oooo04<0oooo0P3o00000`3oool000000000000500000<<0oooo000I0?ooo`030000003oool0oooo
04`0oooo00<000000?ooo`3oool0`@3oool001T0oooo00<000000?ooo`3oool0C03oool300000<40
oooo000I0?ooo`030000003oool0oooo04T0oooo00<0o`000?ooo`3oool00`3oool600000;/0oooo
000I0?ooo`030000003oool0oooo04X0oooo0P3o00090?ooo`@00000]`3oool001T0oooo00<00000
0?ooo`3oool0C03oool20?l000/0oooo00<000000?ooo`3oool0]03oool001T0oooo0`00001>0?oo
o`030?l0003oool0oooo00T0oooo0P00002d0?ooo`006@3oool00`000000oooo0?ooo`1K0?ooo`03
0000003oool0oooo0;80oooo000I0?ooo`030000003oool0oooo05`0oooo0P00002b0?ooo`006@3o
ool00`000000oooo0?ooo`1B0?ooo`030?l0003oool0oooo00P0oooo00<000000?ooo`3oool0/03o
ool001T0oooo00<000000?ooo`3oool0D`3oool20?l000P0oooo00<000000?ooo`3oool0/03oool0
01T0oooo00<000000?ooo`3oool0E@3oool20?l000L0oooo0`00002_0?ooo`006@3oool00`000000
oooo0?ooo`1G0?ooo`030?l0003oool0oooo00L0oooo00<000000?ooo`3oool0[03oool001T0oooo
00<000000?ooo`3oool0HP3oool300000:/0oooo000I0?ooo`<00000I@3oool200000:T0oooo000I
0?ooo`030000003oool0oooo05`0oooo00<0o`000?ooo`3oool01`3oool00`000000oooo0?ooo`2W
0?ooo`006@3oool00`000000oooo0?ooo`1M0?ooo`030?l0003oool0oooo00L0oooo00<000000?oo
o`3oool0YP3oool001T0oooo00<000000?ooo`3oool0GP3oool20?l000P0oooo0P00002V0?ooo`00
6@3oool00`000000oooo0?ooo`1P0?ooo`030?l0003oool0oooo00H0oooo0P00002U0?ooo`006@3o
ool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo0:80oooo00060?ooo`800000103oool2
000000D0oooo0`0000030?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0XP3oool0
00D0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo06D0oooo00<0o`000?ooo`3oool00`3oool00`000000oooo0?ooo`2R0?ooo`001@3oool01000
0000oooo0?ooo`0000080?ooo`D000000`3oool3000006H0oooo0P3o00040?ooo`800000XP3oool0
00D0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo06P0oooo0P3o00040?ooo`800000X03oool000D0oooo00@000000?ooo`3oool000002@3o
ool00`000000oooo000000040?ooo`030000003oool0oooo06X0oooo00<0o`000?ooo`3oool00`3o
ool3000009d0oooo00060?ooo`8000002`3oool2000000@0oooo00<000000?ooo`3oool0L`3oool0
0`000000oooo0?ooo`2J0?ooo`006@3oool00`000000oooo0?ooo`1^0?ooo`030?l0003oool0oooo
00<0oooo0P00002J0?ooo`006@3oool00`000000oooo0?ooo`1_0?ooo`80o`00103oool2000009T0
oooo000I0?ooo`030000003oool0oooo0740oooo0P3o00030?ooo`030000003oool0oooo09L0oooo
000I0?ooo`030000003oool0oooo07<0oooo00<0o`000?ooo`3oool00P00002H0?ooo`006@3oool3
000007L0oooo0P00002G0?ooo`006@3oool00`000000oooo0?ooo`1h0?ooo`@00000U03oool001T0
oooo00<000000?ooo`3oool0N03oool00`3o0000oooo0?ooo`02000009<0oooo000I0?ooo`030000
003oool0oooo07T0oooo00@0o`000?ooo`3oool00000T`3oool001T0oooo00<000000?ooo`3oool0
NP3oool20?l000800000TP3oool001T0oooo00<000000?ooo`3oool0O03oool00`3o000000000?oo
o`2A0?ooo`006@3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo08l0oooo000I0?oo
o`030000003oool0oooo07h0oooo0`00002?0?ooo`006@3oool300000800oooo00<000000?l0003o
ool0S@3oool001T0oooo00<000000?ooo`3oool0P@3oool00`000000o`000?l0002<0?ooo`006@3o
ool00`000000oooo0?ooo`220?ooo`040000003oool0o`000?l008X0oooo000I0?ooo`030000003o
ool0oooo08<0oooo0P0000000`3oool0o`000?ooo`280?ooo`006@3oool00`000000oooo0?ooo`24
0?ooo`<00000R@3oool001T0oooo00<000000?ooo`3oool0QP3oool2000008P0oooo000I0?ooo`03
0000003oool0oooo08P0oooo00<000000?ooo`3o0000Q@3oool001T0oooo00<000000?ooo`3oool0
R@3oool200000080o`00P`3oool001T0oooo0`00002:0?ooo`80000000<0oooo0?l0003o0000P@3o
ool001T0oooo00<000000?ooo`3oool0S03oool3000000030?l0003oool0oooo07h0oooo000I0?oo
o`030000003oool0oooo08h0oooo00<000000?ooo`3oool0O`3oool001T0oooo00<000000?ooo`3o
ool0SP3oool00`000000oooo0?ooo`1o0?ooo`006@3oool00`000000oooo0?ooo`2?0?ooo`030000
003oool0oooo0080oooo00<0o`000?ooo`3oool0N@3oool001T0oooo00<000000?ooo`3oool0T03o
ool2000000<0oooo0P3o001i0?ooo`001P3oool2000000@0oooo0P0000030?ooo`<000001@3oool0
0`000000oooo0?ooo`2A0?ooo`030000003oool0oooo00<0oooo0P3o001g0?ooo`001@3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0TP3o
ool2000007`0oooo00050?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
103oool3000009<0oooo1`00001f0?ooo`001@3oool010000000oooo0?ooo`0000080?ooo`<00000
1@3oool00`000000oooo0?ooo`2I0?ooo`050000003oool0oooo0?ooo`3o0000LP3oool000D0oooo
00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo09T0
oooo0`0000020?ooo`80o`00L03oool000H0oooo0P00000:0?ooo`<00000103oool00`000000oooo
0?ooo`2L0?ooo`<0000000<0oooo0?l0003o0000KP3oool001T0oooo00<000000?ooo`3oool0W`3o
ool3000000030?l0003oool0oooo06/0oooo000I0?ooo`030000003oool0oooo0:80oooo0P00001/
0?ooo`006@3oool00`000000oooo0?ooo`2T0?ooo`030000003oool0oooo06T0oooo000I0?ooo`03
0000003oool0oooo0:@0oooo00@000000?ooo`3oool0o`00J03oool001T0oooo0`00002U0?ooo`80
000000<0oooo0?l0003oool0IP3oool001T0oooo00<000000?ooo`3oool0Y`3oool200000080o`00
I@3oool001T0oooo00<000000?ooo`3oool0ZP3oool00`000000o`000?ooo`1S0?ooo`006@3oool0
0`000000oooo0?ooo`2[0?ooo`@00000H@3oool001T0oooo00<000000?ooo`3oool0[P3oool00`00
0000oooo0?ooo`1O0?ooo`006@3oool00`000000oooo0?ooo`2_0?ooo`040000003o000000000000
05d0oooo000I0?ooo`030000003oool0oooo0;40oooo0P3o0003000005X0oooo000I0?ooo`030000
003oool0oooo0;<0oooo0P3o0007000005@0oooo000I0?ooo`<00000]@3oool00`3o0000oooo0?oo
o`040?ooo`800000DP3oool001T0oooo00<000000?ooo`3oool0_P3oool200000500oooo000I0?oo
o`030000003oool0oooo0<00oooo00<000000?ooo`3oool0C@3oool001T0oooo00<000000?ooo`3o
ool0^@3oool20?l000D0oooo1`0000190?ooo`006@3oool00`000000oooo0?ooo`2k0?ooo`80o`00
2@3oool00`000000oooo0?ooo`170?ooo`006@3oool00`000000oooo0?ooo`2m0?ooo`80o`00203o
ool2000004L0oooo000I0?ooo`030000003oool0oooo0<T0oooo1@0000120?ooo`006@3oool00`00
0000oooo0?ooo`3=0?ooo`800000@@3oool001T0oooo0`0000330?ooo`030?l0003oool0oooo00T0
oooo00<000000?ooo`3oool0?P3oool001T0oooo00<000000?ooo`3oool0a03oool00`3o0000oooo
0?ooo`090?ooo`030000003oool0oooo03d0oooo000I0?ooo`030000003oool0oooo0<D0oooo0P3o
00090?ooo`030000003oool0oooo03d0oooo000I0?ooo`030000003oool0oooo0<L0oooo00<0o`00
0?ooo`3oool01P3oool00`000000oooo0?ooo`0m0?ooo`006@3oool00`000000oooo0?ooo`3@0?oo
o`030000003oool0oooo03d0oooo000I0?ooo`030000003oool0oooo0=00oooo00<000000?ooo`3o
ool0?@3oool001T0oooo00<000000?ooo`3oool0c03oool00`3o0000oooo0?ooo`020?ooo`800000
?@3oool000H0oooo0P0000040?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0c@3o
ool20?l000@0oooo0P00000k0?ooo`001@3oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool0c`3oool20?l000@0oooo00<000000?ooo`3oool0
>03oool000D0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`<0
0000d@3oool01@3o0000oooo0?ooo`3oool0000003X0oooo00050?ooo`040000003oool0oooo0000
00T0oooo0P0000050?ooo`030000003oool0oooo0=H0oooo00<000000?ooo`3oool0=`3oool000D0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0=H0oooo00<000000?ooo`3oool0=`3oool000H0oooo0P00000:0?ooo`8000001@3oool00`00
0000oooo0?ooo`3E0?ooo`040?l0003oool00000000003L0oooo000I0?ooo`030000003oool0oooo
0=H0oooo0P3o00000`000000oooo0?ooo`0e0?ooo`006@3oool00`000000oooo0?ooo`3H0?ooo`80
o`001000000b0?ooo`006@3oool00`000000oooo0?ooo`3J0?ooo`040?l0003oool0oooo0?ooo`80
0000<03oool001T0oooo00<000000?ooo`3oool0g`3oool00`000000oooo0?ooo`0^0?ooo`006@3o
ool300000=l0oooo0P00000_0?ooo`006@3oool00`000000oooo0?ooo`3O0?ooo`030?l0003oool0
000002h0oooo000I0?ooo`030000003oool0oooo0>00oooo00@0o`000?ooo`0000000000;03oool0
01T0oooo00<000000?ooo`3oool0h@3oool20?l000030?ooo`000000000000<000009`3oool001T0
oooo00<000000?ooo`3oool0h`3oool00`3o0000oooo0?ooo`030?ooo`8000009@3oool001T0oooo
00<000000?ooo`3oool0jP3oool00`000000oooo0?ooo`0S0?ooo`006@3oool00`000000oooo0?oo
o`3X0?ooo`030?l0003oool0000002D0oooo000I0?ooo`030000003oool0oooo0>T0oooo0P3o0000
0`000000oooo0?ooo`0R0?ooo`006@3oool300000>/0oooo0P3o000200000240oooo000I0?ooo`03
0000003oool0oooo0>d0oooo00<0o`000?ooo`0000001@00000K0?ooo`006@3oool00`000000oooo
0?ooo`3e0?ooo`8000006@3oool001T0oooo00<000000?ooo`3oool0m`3oool3000001H0oooo000I
0?ooo`030000003oool0oooo0?40oooo00<0o`000?ooo`3oool01@3oool00`000000oooo0?ooo`0D
0?ooo`006@3oool00`000000oooo0?ooo`3b0?ooo`80o`001@3oool00`000000oooo0?ooo`0D0?oo
o`006@3oool00`000000oooo0?ooo`3d0?ooo`80o`000`3oool2000001D0oooo000I0?ooo`030000
003oool0oooo0?H0oooo00@0o`000?ooo`3oool0oooo0P00000D0?ooo`006@3oool300000?/0oooo
00<000000?ooo`3oool04P3oool001T0oooo00<000000?ooo`3oool0o03oool00`000000oooo0?oo
o`0A0?ooo`006@3oool00`000000oooo0?ooo`3k0?ooo`030?l0003oool000000180oooo000I0?oo
o`030000003oool0oooo0?`0oooo0P3o000200000100oooo000I0?ooo`030000003oool0oooo0?h0
oooo0P3o000@0?ooo`006@3oool00`000000oooo0?ooo`3o0?ooo`030000003o0000oooo00h0oooo
000A0?ooo`D000000`3oool00`000000oooo0?ooo`3o0?ooo`40oooo0P00000>0?ooo`004`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo0`3oool00`000000oooo0?ooo`0;
0?ooo`004`3oool00`000000oooo0?ooo`030?ooo`<00000o`3oool40?ooo`030000003o0000o`00
00X0oooo000C0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`00
4`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo4@3oool00180oooo0P00
00050?ooo`030000003oool0oooo0?l0oooo4@3oool001T0oooo00<000000?ooo`3oool0o`3ooolA
0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.0986222, -0.0767463, \
0.00379787, 0.00617049}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S6.9.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pairwise Scatter Plots", "Subsubsection",
 CellTags->{"S6.9.1", "1.34"}],

Cell["\<\
The pairs or matrix scatter plot allows the individual columns in a \
multivariate set of data to be plotted against each other. This can be used \
to investigate relationships between the variables. The resulting plot is a \
matrix of subgraphs. \
\>", "Text",
 CellTags->{"S6.9.1", "1.35"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["PairwiseScatterPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["matrix", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "plot the columns of the matrix against each other in a pairwise \
fashion",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.9.1"],

Cell["A pairs scatter plot. ", "Caption",
 CellTags->"S6.9.1"],

Cell[TextData[{
 "The pairs scatter plot forms a matrix of scatter plots from the columns of \
a multivariate data set plotted against each other. ",
 StyleBox["PairwiseScatterPlot", "MR"],
 " by default places the first column at the lower left side of the plot, and \
proceeds to the right and upwards. "
}], "Text",
 CellTags->{"S6.9.1", "1.36"}],

Cell["Generate data for the examples. ", "MathCaption",
 CellTags->{"S6.9.1", "1.37"}],

Cell["dat = Table[{x, Sin[x], Cos[x]}, {x, 0, 2 Pi, 0.1}];", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S6.9.1"],

Cell["Plot the columns of the data against each other. ", "MathCaption",
 CellTags->{"S6.9.1", "1.38"}],

Cell[CellGroupData[{

Cell["PairwiseScatterPlot[dat]", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.0238095 0.31746 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .02381 m
.34127 .02381 L
.34127 .34127 L
.02381 .34127 L
.02381 .02381 L
s
.008 w
.03824 .03824 Mdot
.04289 .04289 Mdot
.04755 .04755 Mdot
.0522 .0522 Mdot
.05686 .05686 Mdot
.06151 .06151 Mdot
.06617 .06617 Mdot
.07082 .07082 Mdot
.07548 .07548 Mdot
.08013 .08013 Mdot
.08479 .08479 Mdot
.08944 .08944 Mdot
.0941 .0941 Mdot
.09875 .09875 Mdot
.10341 .10341 Mdot
.10806 .10806 Mdot
.11272 .11272 Mdot
.11737 .11737 Mdot
.12203 .12203 Mdot
.12668 .12668 Mdot
.13134 .13134 Mdot
.13599 .13599 Mdot
.14065 .14065 Mdot
.1453 .1453 Mdot
.14996 .14996 Mdot
.15461 .15461 Mdot
.15927 .15927 Mdot
.16392 .16392 Mdot
.16858 .16858 Mdot
.17323 .17323 Mdot
.17788 .17788 Mdot
.18254 .18254 Mdot
.18719 .18719 Mdot
.19185 .19185 Mdot
.1965 .1965 Mdot
.20116 .20116 Mdot
.20581 .20581 Mdot
.21047 .21047 Mdot
.21512 .21512 Mdot
.21978 .21978 Mdot
.22443 .22443 Mdot
.22909 .22909 Mdot
.23374 .23374 Mdot
.2384 .2384 Mdot
.24305 .24305 Mdot
.24771 .24771 Mdot
.25236 .25236 Mdot
.25702 .25702 Mdot
.26167 .26167 Mdot
.26633 .26633 Mdot
.27098 .27098 Mdot
.27564 .27564 Mdot
.28029 .28029 Mdot
.28495 .28495 Mdot
.2896 .2896 Mdot
.29426 .29426 Mdot
.29891 .29891 Mdot
.30357 .30357 Mdot
.30822 .30822 Mdot
.31288 .31288 Mdot
.31753 .31753 Mdot
.32218 .32218 Mdot
.32684 .32684 Mdot
.5 Mabswid
.02381 .34127 m
.34127 .34127 L
.34127 .65873 L
.02381 .65873 L
.02381 .34127 L
s
.008 w
.50003 .03824 Mdot
.51443 .04289 Mdot
.5287 .04755 Mdot
.54268 .0522 Mdot
.55623 .05686 Mdot
.56922 .06151 Mdot
.58152 .06617 Mdot
.59301 .07082 Mdot
.60357 .07548 Mdot
.61309 .08013 Mdot
.62148 .08479 Mdot
.62866 .08944 Mdot
.63455 .0941 Mdot
.6391 .09875 Mdot
.64226 .10341 Mdot
.644 .10806 Mdot
.6443 .11272 Mdot
.64316 .11737 Mdot
.64059 .12203 Mdot
.63661 .12668 Mdot
.63127 .13134 Mdot
.62462 .13599 Mdot
.61672 .14065 Mdot
.60766 .1453 Mdot
.59752 .14996 Mdot
.58641 .15461 Mdot
.57443 .15927 Mdot
.56171 .16392 Mdot
.54838 .16858 Mdot
.53456 .17323 Mdot
.52039 .17788 Mdot
.50603 .18254 Mdot
.4916 .18719 Mdot
.47726 .19185 Mdot
.46314 .1965 Mdot
.44939 .20116 Mdot
.43615 .20581 Mdot
.42355 .21047 Mdot
.41171 .21512 Mdot
.40076 .21978 Mdot
.39079 .22443 Mdot
.38192 .22909 Mdot
.37423 .23374 Mdot
.36779 .2384 Mdot
.36267 .24305 Mdot
.35893 .24771 Mdot
.3566 .25236 Mdot
.3557 .25702 Mdot
.35624 .26167 Mdot
.35822 .26633 Mdot
.36162 .27098 Mdot
.3664 .27564 Mdot
.37251 .28029 Mdot
.3799 .28495 Mdot
.38849 .2896 Mdot
.39819 .29426 Mdot
.40891 .29891 Mdot
.42054 .30357 Mdot
.43297 .30822 Mdot
.44606 .31288 Mdot
.4597 .31753 Mdot
.47373 .32218 Mdot
.48803 .32684 Mdot
.5 Mabswid
.02381 .65873 m
.34127 .65873 L
.34127 .97619 L
.02381 .97619 L
.02381 .65873 L
s
.008 w
.96176 .03824 Mdot
.96104 .04289 Mdot
.95888 .04755 Mdot
.95531 .0522 Mdot
.95036 .05686 Mdot
.94409 .06151 Mdot
.93655 .06617 Mdot
.92781 .07082 Mdot
.91798 .07548 Mdot
.90714 .08013 Mdot
.8954 .08479 Mdot
.88288 .08944 Mdot
.86971 .0941 Mdot
.85601 .09875 Mdot
.84193 .10341 Mdot
.82761 .10806 Mdot
.81318 .11272 Mdot
.7988 .11737 Mdot
.7846 .12203 Mdot
.77073 .12668 Mdot
.75732 .13134 Mdot
.74452 .13599 Mdot
.73244 .14065 Mdot
.72121 .1453 Mdot
.71095 .14996 Mdot
.70174 .15461 Mdot
.6937 .15927 Mdot
.68688 .16392 Mdot
.68138 .16858 Mdot
.67723 .17323 Mdot
.67448 .17788 Mdot
.67316 .18254 Mdot
.67328 .18719 Mdot
.67484 .19185 Mdot
.67783 .1965 Mdot
.68221 .20116 Mdot
.68794 .20581 Mdot
.69496 .21047 Mdot
.70321 .21512 Mdot
.7126 .21978 Mdot
.72304 .22443 Mdot
.73441 .22909 Mdot
.74662 .23374 Mdot
.75954 .2384 Mdot
.77303 .24305 Mdot
.78697 .24771 Mdot
.80121 .25236 Mdot
.81561 .25702 Mdot
.83003 .26167 Mdot
.84432 .26633 Mdot
.85835 .27098 Mdot
.87196 .27564 Mdot
.88503 .28029 Mdot
.89743 .28495 Mdot
.90902 .2896 Mdot
.9197 .29426 Mdot
.92936 .29891 Mdot
.9379 .30357 Mdot
.94523 .30822 Mdot
.95129 .31288 Mdot
.95601 .31753 Mdot
.95935 .32218 Mdot
.96126 .32684 Mdot
.5 Mabswid
.34127 .02381 m
.65873 .02381 L
.65873 .34127 L
.34127 .34127 L
.34127 .02381 L
s
.008 w
.03824 .50003 Mdot
.04289 .51443 Mdot
.04755 .5287 Mdot
.0522 .54268 Mdot
.05686 .55623 Mdot
.06151 .56922 Mdot
.06617 .58152 Mdot
.07082 .59301 Mdot
.07548 .60357 Mdot
.08013 .61309 Mdot
.08479 .62148 Mdot
.08944 .62866 Mdot
.0941 .63455 Mdot
.09875 .6391 Mdot
.10341 .64226 Mdot
.10806 .644 Mdot
.11272 .6443 Mdot
.11737 .64316 Mdot
.12203 .64059 Mdot
.12668 .63661 Mdot
.13134 .63127 Mdot
.13599 .62462 Mdot
.14065 .61672 Mdot
.1453 .60766 Mdot
.14996 .59752 Mdot
.15461 .58641 Mdot
.15927 .57443 Mdot
.16392 .56171 Mdot
.16858 .54838 Mdot
.17323 .53456 Mdot
.17788 .52039 Mdot
.18254 .50603 Mdot
.18719 .4916 Mdot
.19185 .47726 Mdot
.1965 .46314 Mdot
.20116 .44939 Mdot
.20581 .43615 Mdot
.21047 .42355 Mdot
.21512 .41171 Mdot
.21978 .40076 Mdot
.22443 .39079 Mdot
.22909 .38192 Mdot
.23374 .37423 Mdot
.2384 .36779 Mdot
.24305 .36267 Mdot
.24771 .35893 Mdot
.25236 .3566 Mdot
.25702 .3557 Mdot
.26167 .35624 Mdot
.26633 .35822 Mdot
.27098 .36162 Mdot
.27564 .3664 Mdot
.28029 .37251 Mdot
.28495 .3799 Mdot
.2896 .38849 Mdot
.29426 .39819 Mdot
.29891 .40891 Mdot
.30357 .42054 Mdot
.30822 .43297 Mdot
.31288 .44606 Mdot
.31753 .4597 Mdot
.32218 .47373 Mdot
.32684 .48803 Mdot
.5 Mabswid
.34127 .34127 m
.65873 .34127 L
.65873 .65873 L
.34127 .65873 L
.34127 .34127 L
s
.008 w
.50003 .50003 Mdot
.51443 .51443 Mdot
.5287 .5287 Mdot
.54268 .54268 Mdot
.55623 .55623 Mdot
.56922 .56922 Mdot
.58152 .58152 Mdot
.59301 .59301 Mdot
.60357 .60357 Mdot
.61309 .61309 Mdot
.62148 .62148 Mdot
.62866 .62866 Mdot
.63455 .63455 Mdot
.6391 .6391 Mdot
.64226 .64226 Mdot
.644 .644 Mdot
.6443 .6443 Mdot
.64316 .64316 Mdot
.64059 .64059 Mdot
.63661 .63661 Mdot
.63127 .63127 Mdot
.62462 .62462 Mdot
.61672 .61672 Mdot
.60766 .60766 Mdot
.59752 .59752 Mdot
.58641 .58641 Mdot
.57443 .57443 Mdot
.56171 .56171 Mdot
.54838 .54838 Mdot
.53456 .53456 Mdot
.52039 .52039 Mdot
.50603 .50603 Mdot
.4916 .4916 Mdot
.47726 .47726 Mdot
.46314 .46314 Mdot
.44939 .44939 Mdot
.43615 .43615 Mdot
.42355 .42355 Mdot
.41171 .41171 Mdot
.40076 .40076 Mdot
.39079 .39079 Mdot
.38192 .38192 Mdot
.37423 .37423 Mdot
.36779 .36779 Mdot
.36267 .36267 Mdot
.35893 .35893 Mdot
.3566 .3566 Mdot
.3557 .3557 Mdot
.35624 .35624 Mdot
.35822 .35822 Mdot
.36162 .36162 Mdot
.3664 .3664 Mdot
.37251 .37251 Mdot
.3799 .3799 Mdot
.38849 .38849 Mdot
.39819 .39819 Mdot
.40891 .40891 Mdot
.42054 .42054 Mdot
.43297 .43297 Mdot
.44606 .44606 Mdot
.4597 .4597 Mdot
.47373 .47373 Mdot
.48803 .48803 Mdot
.5 Mabswid
.34127 .65873 m
.65873 .65873 L
.65873 .97619 L
.34127 .97619 L
.34127 .65873 L
s
.008 w
.96176 .50003 Mdot
.96104 .51443 Mdot
.95888 .5287 Mdot
.95531 .54268 Mdot
.95036 .55623 Mdot
.94409 .56922 Mdot
.93655 .58152 Mdot
.92781 .59301 Mdot
.91798 .60357 Mdot
.90714 .61309 Mdot
.8954 .62148 Mdot
.88288 .62866 Mdot
.86971 .63455 Mdot
.85601 .6391 Mdot
.84193 .64226 Mdot
.82761 .644 Mdot
.81318 .6443 Mdot
.7988 .64316 Mdot
.7846 .64059 Mdot
.77073 .63661 Mdot
.75732 .63127 Mdot
.74452 .62462 Mdot
.73244 .61672 Mdot
.72121 .60766 Mdot
.71095 .59752 Mdot
.70174 .58641 Mdot
.6937 .57443 Mdot
.68688 .56171 Mdot
.68138 .54838 Mdot
.67723 .53456 Mdot
.67448 .52039 Mdot
.67316 .50603 Mdot
.67328 .4916 Mdot
.67484 .47726 Mdot
.67783 .46314 Mdot
.68221 .44939 Mdot
.68794 .43615 Mdot
.69496 .42355 Mdot
.70321 .41171 Mdot
.7126 .40076 Mdot
.72304 .39079 Mdot
.73441 .38192 Mdot
.74662 .37423 Mdot
.75954 .36779 Mdot
.77303 .36267 Mdot
.78697 .35893 Mdot
.80121 .3566 Mdot
.81561 .3557 Mdot
.83003 .35624 Mdot
.84432 .35822 Mdot
.85835 .36162 Mdot
.87196 .3664 Mdot
.88503 .37251 Mdot
.89743 .3799 Mdot
.90902 .38849 Mdot
.9197 .39819 Mdot
.92936 .40891 Mdot
.9379 .42054 Mdot
.94523 .43297 Mdot
.95129 .44606 Mdot
.95601 .4597 Mdot
.95935 .47373 Mdot
.96126 .48803 Mdot
.5 Mabswid
.65873 .02381 m
.97619 .02381 L
.97619 .34127 L
.65873 .34127 L
.65873 .02381 L
s
.008 w
.03824 .96176 Mdot
.04289 .96104 Mdot
.04755 .95888 Mdot
.0522 .95531 Mdot
.05686 .95036 Mdot
.06151 .94409 Mdot
.06617 .93655 Mdot
.07082 .92781 Mdot
.07548 .91798 Mdot
.08013 .90714 Mdot
.08479 .8954 Mdot
.08944 .88288 Mdot
.0941 .86971 Mdot
.09875 .85601 Mdot
.10341 .84193 Mdot
.10806 .82761 Mdot
.11272 .81318 Mdot
.11737 .7988 Mdot
.12203 .7846 Mdot
.12668 .77073 Mdot
.13134 .75732 Mdot
.13599 .74452 Mdot
.14065 .73244 Mdot
.1453 .72121 Mdot
.14996 .71095 Mdot
.15461 .70174 Mdot
.15927 .6937 Mdot
.16392 .68688 Mdot
.16858 .68138 Mdot
.17323 .67723 Mdot
.17788 .67448 Mdot
.18254 .67316 Mdot
.18719 .67328 Mdot
.19185 .67484 Mdot
.1965 .67783 Mdot
.20116 .68221 Mdot
.20581 .68794 Mdot
.21047 .69496 Mdot
.21512 .70321 Mdot
.21978 .7126 Mdot
.22443 .72304 Mdot
.22909 .73441 Mdot
.23374 .74662 Mdot
.2384 .75954 Mdot
.24305 .77303 Mdot
.24771 .78697 Mdot
.25236 .80121 Mdot
.25702 .81561 Mdot
.26167 .83003 Mdot
.26633 .84432 Mdot
.27098 .85835 Mdot
.27564 .87196 Mdot
.28029 .88503 Mdot
.28495 .89743 Mdot
.2896 .90902 Mdot
.29426 .9197 Mdot
.29891 .92936 Mdot
.30357 .9379 Mdot
.30822 .94523 Mdot
.31288 .95129 Mdot
.31753 .95601 Mdot
.32218 .95935 Mdot
.32684 .96126 Mdot
.5 Mabswid
.65873 .34127 m
.97619 .34127 L
.97619 .65873 L
.65873 .65873 L
.65873 .34127 L
s
.008 w
.50003 .96176 Mdot
.51443 .96104 Mdot
.5287 .95888 Mdot
.54268 .95531 Mdot
.55623 .95036 Mdot
.56922 .94409 Mdot
.58152 .93655 Mdot
.59301 .92781 Mdot
.60357 .91798 Mdot
.61309 .90714 Mdot
.62148 .8954 Mdot
.62866 .88288 Mdot
.63455 .86971 Mdot
.6391 .85601 Mdot
.64226 .84193 Mdot
.644 .82761 Mdot
.6443 .81318 Mdot
.64316 .7988 Mdot
.64059 .7846 Mdot
.63661 .77073 Mdot
.63127 .75732 Mdot
.62462 .74452 Mdot
.61672 .73244 Mdot
.60766 .72121 Mdot
.59752 .71095 Mdot
.58641 .70174 Mdot
.57443 .6937 Mdot
.56171 .68688 Mdot
.54838 .68138 Mdot
.53456 .67723 Mdot
.52039 .67448 Mdot
.50603 .67316 Mdot
.4916 .67328 Mdot
.47726 .67484 Mdot
.46314 .67783 Mdot
.44939 .68221 Mdot
.43615 .68794 Mdot
.42355 .69496 Mdot
.41171 .70321 Mdot
.40076 .7126 Mdot
.39079 .72304 Mdot
.38192 .73441 Mdot
.37423 .74662 Mdot
.36779 .75954 Mdot
.36267 .77303 Mdot
.35893 .78697 Mdot
.3566 .80121 Mdot
.3557 .81561 Mdot
.35624 .83003 Mdot
.35822 .84432 Mdot
.36162 .85835 Mdot
.3664 .87196 Mdot
.37251 .88503 Mdot
.3799 .89743 Mdot
.38849 .90902 Mdot
.39819 .9197 Mdot
.40891 .92936 Mdot
.42054 .9379 Mdot
.43297 .94523 Mdot
.44606 .95129 Mdot
.4597 .95601 Mdot
.47373 .95935 Mdot
.48803 .96126 Mdot
.5 Mabswid
.65873 .65873 m
.97619 .65873 L
.97619 .97619 L
.65873 .97619 L
.65873 .65873 L
s
.008 w
.96176 .96176 Mdot
.96104 .96104 Mdot
.95888 .95888 Mdot
.95531 .95531 Mdot
.95036 .95036 Mdot
.94409 .94409 Mdot
.93655 .93655 Mdot
.92781 .92781 Mdot
.91798 .91798 Mdot
.90714 .90714 Mdot
.8954 .8954 Mdot
.88288 .88288 Mdot
.86971 .86971 Mdot
.85601 .85601 Mdot
.84193 .84193 Mdot
.82761 .82761 Mdot
.81318 .81318 Mdot
.7988 .7988 Mdot
.7846 .7846 Mdot
.77073 .77073 Mdot
.75732 .75732 Mdot
.74452 .74452 Mdot
.73244 .73244 Mdot
.72121 .72121 Mdot
.71095 .71095 Mdot
.70174 .70174 Mdot
.6937 .6937 Mdot
.68688 .68688 Mdot
.68138 .68138 Mdot
.67723 .67723 Mdot
.67448 .67448 Mdot
.67316 .67316 Mdot
.67328 .67328 Mdot
.67484 .67484 Mdot
.67783 .67783 Mdot
.68221 .68221 Mdot
.68794 .68794 Mdot
.69496 .69496 Mdot
.70321 .70321 Mdot
.7126 .7126 Mdot
.72304 .72304 Mdot
.73441 .73441 Mdot
.74662 .74662 Mdot
.75954 .75954 Mdot
.77303 .77303 Mdot
.78697 .78697 Mdot
.80121 .80121 Mdot
.81561 .81561 Mdot
.83003 .83003 Mdot
.84432 .84432 Mdot
.85835 .85835 Mdot
.87196 .87196 Mdot
.88503 .88503 Mdot
.89743 .89743 Mdot
.90902 .90902 Mdot
.9197 .9197 Mdot
.92936 .92936 Mdot
.9379 .9379 Mdot
.94523 .94523 Mdot
.95129 .95129 Mdot
.95601 .95601 Mdot
.95935 .95935 Mdot
.96126 .96126 Mdot
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00@03ooon[
00000440oooo00100?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0=@3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo03l0oooo00100?ooo`040000003oool000000000
03D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0000000I0?ooo`030000003oool0oooo
03<0oooo00@000000?ooo`3oool00000@@3oool00400oooo00D000000?ooo`3oool0oooo0000000d
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0c
0?ooo`040000003oool0oooo00000440oooo00100?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0<@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool0<P3oool01@000000oooo0?ooo`3oool000000440oooo00100?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo03l0oooo00100?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0<03oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0<03oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo00@0
oooo0P00000`0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`0000002`3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool0?`3oool00400oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo02/0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`0/0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0Z0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0?`3oool00400oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02l0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0[0?oo
o`030000003oool0oooo0300oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0U0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3o
ool02@3oool2000002/0oooo00<000000?ooo`3oool0<@3oool200000080oooo00<000000?ooo`3o
ool08@3oool00`000000oooo0000000B0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0b0?ooo`040000
003oool0oooo00000200oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0o0?ooo`00
@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
<`3oool00`000000oooo0000000M0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
?`3oool00400oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0W0?ooo`030000003o
ool0oooo03<0oooo00<000000?ooo`0000006`3oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo03l0oooo00100?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0b0?ooo`040000003oool0oooo000001P0oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0>0?ooo`8000009P3oool0
0`000000oooo0?ooo`0a0?ooo`8000000P3oool00`000000oooo0?ooo`0A0?ooo`040000003oool0
oooo00000240oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0?`3oool0
0400oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo
02l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0?`3oool00400oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02`0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo02/0oooo
00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool04`3oool200000240oooo00<0
00000?ooo`3oool0:03oool00`000000oooo0000000:0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`000000;P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0o
0?ooo`00@03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01d0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0A0?ooo`05
0000003oool0oooo0?ooo`000000=03oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool07`3oool00`000000
oooo0?ooo`0C0?ooo`050000003oool0oooo0?ooo`000000=03oool00`000000oooo0?ooo`0o0?oo
o`00@03oool00`000000oooo0?ooo`0H0?ooo`800000703oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0000001P0oooo00@000000?ooo`3oool00000=@3oool00`000000oooo0?ooo`0o0?oo
o`00@03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0K0?ooo`040000003oool0oooo000003D0oooo00<000000?oo
o`3oool0?`3oool00400oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`00000e0?oo
o`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0200oooo00D000000?ooo`3o
ool0oooo0000000d0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0280
oooo00D000000?ooo`3oool0oooo0000000d0?ooo`030000003oool0oooo03l0oooo00100?ooo`03
0000003oool0oooo01d0oooo0P00000G0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`00
00009`3oool00`000000oooo0?ooo`020?ooo`030000003oool000000340oooo00<000000?ooo`3o
ool0?`3oool00400oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo02h0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0:`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0?`3o
ool00400oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo02X0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool08@3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;P3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0?`3oool00400
oooo00<000000?ooo`3oool08P3oool200000180oooo00@000000?ooo`3oool0oooo0P00000b0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`0000009P3oool00`000000oooo0?ooo`0o0?oo
o`00@03oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00l0oooo00@000000?ooo`3o
ool00000=03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0240oooo00<000000?oo
o`3oool0?`3oool00400oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0>0?ooo`04
0000003oool0oooo000003@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0O0?oo
o`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0000000e0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`000000=@3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool09`3o
ool2000000d0oooo00<000000?ooo`000000=@3oool00`000000oooo0?ooo`0L0?ooo`030000003o
ool0000001L0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0:@3oool0
0`000000oooo0?ooo`0:0?ooo`040000003oool0oooo000003@0oooo00<000000?ooo`3oool08@3o
ool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0
oooo02X0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000003<0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03l0oooo0010
0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo02/0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02l0oooo00<000000?oo
o`3oool0:03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03l0oooo00100?ooo`03
0000003oool0oooo02`0oooo0P0000080?ooo`030000003oool0oooo00D0oooo00<000000?ooo`00
0000;@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0000000T0oooo00<000000?ooo`3o
ool0?`3oool00400oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0^0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0;`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0?`3o
ool00400oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0<03oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`0b0?ooo`050000003oool0oooo0?ooo`000000@@3oool00400oooo00<000000?oo
o`3oool0<@3oool2000000<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0000000P0?oo
o`030000003oool0oooo0380oooo0P0000020?ooo`030000003oool0oooo03l0oooo00100?ooo`03
0000003oool0oooo03<0oooo00@000000?ooo`3oool000006@3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo03<0oooo00@000000?ooo`3oool00000@@3oool00400oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo03H0oooo00<000000?oo
o`3oool0?`3oool00400oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0e0?ooo`03
0000003oool0oooo03H0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0
?`3oool00400ooooZ`0000110?ooo`00@03oool00`000000oooo0?ooo`0V0?ooo`8000003P3oool0
0`000000oooo0000000e0?ooo`030000003oool0oooo01T0oooo00@000000?ooo`3oool000006@3o
ool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo00800000303oool010000000oooo00000000000d0?ooo`030000003oool0oooo01@0oooo00@0
00000?ooo`3oool000001P3oool010000000oooo0?ooo`00000D0?ooo`030000003oool0oooo03l0
oooo00100?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00800000<`3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0o0?ooo`00@03o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3o
ool010000000oooo0?ooo`3oool200000380oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0?`3oool00400oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0<03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02H0oooo00<0
00000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool200000300oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0Z0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3o
ool0?`3oool00400oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0[0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo03l0oooo00100?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0=@3o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0
oooo01l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo02H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02l0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0;`3oool00`000000oooo
0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0340oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0o
0?ooo`00@03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0L0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`80
0000903oool01@000000oooo0?ooo`3oool000000300oooo00D000000?ooo`3oool0oooo00000011
0?ooo`00@03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0a0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo0380oooo00D000000?ooo`3oool0oooo000000110?ooo`00@03oool00`000000
oooo0?ooo`0K0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0P0?ooo`050000003oool0oooo0?ooo`000000=03oool00`000000oooo0?ooo`0o0?oo
o`00@03oool00`000000oooo0?ooo`0b0?ooo`050000003oool0oooo0?ooo`0000005P3oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo03<0oooo00@000000?ooo`3oool00000@@3oool0
0400oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`00000e0?ooo`030000003oool0
oooo03l0oooo00100?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0=@3oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo03<0
oooo00@000000?ooo`3oool000006@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
03<0oooo00@000000?ooo`3oool00000@@3oool00400oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool06`3oool01000
0000oooo0?ooo`00000e0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool00000
03H0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
03<0oooo00@000000?ooo`3oool00000@@3oool00400oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0603oool01000
0000oooo0?ooo`00000e0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
03l0oooo00100?ooo`040000003oool0oooo000003D0oooo00<000000?ooo`3oool06`3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo03<0oooo00@000000?ooo`3oool00000@@3oool0
0400oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool05P3oool010000000oooo0?ooo`00000e0?ooo`030000003oool0
oooo03l0oooo00100?ooo`050000003oool0oooo0?ooo`000000=03oool00`000000oooo0?ooo`0N
0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0<`3oool010000000oooo0?ooo`00
00110?ooo`00@03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`0C0?ooo`050000003oool0oooo0?ooo`000000=03o
ool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0
oooo03D0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0803oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo0380oooo00D000000?ooo`3oool0oooo00000011
0?ooo`00@03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01d0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`0A0?ooo`050000003oool0oooo0?ooo`000000=03oool0
0`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
0340oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0903oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0<@3oool00`000000
oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0o0?ooo`00@03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01h0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0<03oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo02l0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo02l0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0o0?oo
o`00@03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0;P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo02h0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo02d0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0o0?ooo`00@03o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0:P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0;03o
ool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0[0?ooo`800000203oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
02`0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
02X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0:@3oool00`000000
oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`0[0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0U0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0?`3oool00400oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool0<03oool2000000<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?oo
o`3oool02P3oool010000000oooo0?ooo`3oool2000002H0oooo00<000000?ooo`3oool0<@3oool2
00000080oooo00<000000?ooo`3oool04@3oool010000000oooo0?ooo`00000<0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool02`3oool3
000002P0oooo00<000000?ooo`3oool0<P3oool2000000030?ooo`000000oooo01L0oooo00H00000
0?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
?`3oool00400oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0e0?ooo`030000003o
ool0oooo03H0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`0e0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0?`3oool0
0400ooooZ`0000110?ooo`00@03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo
0?ooo`0H0?ooo`@000006P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool000000080oooo
00<000000?ooo`000000603oool010000000oooo0?ooo`00000e0?ooo`030000003oool0oooo03l0
oooo00100?ooo`030000003oool0oooo01L0oooo00D000000?ooo`3oool0oooo0000000J0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`05
0000003oool0oooo0?ooo`000000=03oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04@3oool01@000000
oooo0?ooo`3oool0000003@0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00<0oooo0P00000a0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0X0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0^0?ooo`030000003o
ool0oooo03l0oooo00100?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0^0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02@0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`080?ooo`800000;03oool00`000000oooo
0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:
0?ooo`800000:P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0f0?oo
o`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0o0?oo
o`00@03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool0?`3oool00400oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0e0?ooo`030000
003oool0oooo03H0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0?`3o
ool00400oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0@0?ooo`050000003oool0
oooo0?ooo`000000<`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0e
0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00l0oooo00@000000?oo
o`3oool00000<03oool01@000000oooo0?ooo`3oool0000001<0oooo0P00000S0?ooo`030000003o
ool0oooo03l0oooo00100?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0b0?ooo`040000003oool0oooo
000001H0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo00h0oooo00@000000?ooo`3oool00000=03oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0?`3oool0
0400oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
03H0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`000000<P3oool010000000
oooo0?ooo`00000H0?ooo`8000007P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3oool00`000000
oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02L0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0000000K0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0000003D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo03H0oooo00<00000
0?ooo`3oool0=@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03l0oooo00100?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0000003<0oooo00<000000?ooo`0000007@3oool2000001T0oooo00<000000?oo
o`3oool0?`3oool00400oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0e0?ooo`03
0000003oool0oooo03H0oooo00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0380oooo00@000000?ooo`3oool0
0000803oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000
003oool0oooo02P0oooo00<000000?ooo`3oool02`3oool00`000000oooo0000000e0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0o0?ooo`00@03o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool02P3oool010000000oooo0?ooo`00000a0?ooo`040000003o
ool0oooo000002<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0o0?ooo`00@03o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3o
ool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo02X0oooo00<000000?ooo`3oool0<@3oool01@000000oooo0?ooo`3oool0000002D0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0Z
0?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000c0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0o0?ooo`00@03oool0
0`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
02/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0U0?ooo`8000003`3oool00`00
0000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0X0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0?`3oool00400oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo03H0oooo00<0
00000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo03l0oooo00100?ooo`030000003oool0oooo03H0oooo00<000000?oo
o`3oool0=@3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03l0oooo00100?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo02`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0o0?ooo`00
@03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo01d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0]0?ooo`8000001`3o
ool00`000000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo02l0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo02l0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0o0?ooo`00@03oool00`00
0000oooo0?ooo`0_0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0W0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0`0?ooo`800000103oool00`000000
oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02/0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0a0?ooo`8000000`3oool00`000000oooo
0?ooo`0o0?ooo`00@03oool010000000oooo0?ooo`3oool2000002h0oooo0P0000030?ooo`030000
003oool0oooo0180oooo00<000000?ooo`0000002@3oool00`000000oooo0000000D0?ooo`030000
003oool0oooo0380oooo0P0000020?ooo`030000003oool0oooo03l0oooo00100?ooo`040000003o
ool0000000000380oooo00@000000?ooo`3oool000006@3oool01@000000oooo0000003oool00000
01T0oooo00<000000?ooo`3oool0<`3oool010000000oooo0?ooo`0000110?ooo`00@03oool00`00
0000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0o0?ooo`00@03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03D0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0o0?ooo`00@03ooon[00000440oooo
003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo0000\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-1.13089, -0.0750158, 0.017598, \
0.017598}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S6.9.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["default value", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox["",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["DataRanges", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["All", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "range limits on the data",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["DataLabels", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["None", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "labels for the columns",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["DataTicks", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["None", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "tick specifications for the columns",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["DataSpacing", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["0", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "space to place between subgraphs",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["PlotStyle", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["Automatic", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "styles for the subgraphs",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S6.9.1"],

Cell[TextData[{
 "Options specific to ",
 StyleBox["PairwiseScatterPlot", "MR"],
 ". "
}], "Caption",
 CellTags->"S6.9.1"],

Cell[TextData[{
 "A variety of options can be used to control the appearance of the plot. The \
",
 StyleBox["DataRanges", "MR"],
 " option accepts a list of ranges or ",
 StyleBox["All", "MR"],
 ", which can be used to restrict the points to be plotted. The ranges are \
given as ",
 StyleBox["{", "MR"],
 StyleBox["min", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["max", "TI"],
 StyleBox["}", "MR"],
 " pairs, used cyclically for all of the columns. "
}], "Text",
 CellTags->{"S6.9.1", "1.39"}],

Cell[TextData[{
 "Textual annotations are provided via ",
 StyleBox["DataLabels", "MR"],
 " and ",
 StyleBox["DataTicks", "MR"],
 ". Labels can be supplied for each column via the ",
 StyleBox["DataLabels", "MR"],
 " option, given as a list of labels. Ticks can be specified for each column \
using the usual graphics ticks syntax; these are drawn at the top and bottom \
of the corresponding column of the matrix of plots, as well as the right and \
left sides of the corresponding row. Tick labels are only drawn on \
alternating sides for each column to prevent labels for adjacent columns from \
overriding. "
}], "Text",
 CellTags->{"S6.9.1", "1.40"}],

Cell[TextData[{
 "The ",
 StyleBox["PlotStyle", "MR"],
 " option can take either a single style primitive or a matrix of style \
primitives. If given a matrix, the primitives are applied to the subplots in \
a cyclic fashion. "
}], "Text",
 CellTags->{"S6.9.1", "1.41"}],

Cell[TextData[{
 "Finally, the ",
 StyleBox["DataSpacing", "MR"],
 " option allows the subgraphs to be drawn with varying amounts of space \
between them. This takes a number or a pair of numbers corresponding to the \
horizontal and vertical space between each graph. This number is scaled to \
the size of one of the subgraphs, which range from 0 to 1. You may provide \
negative numbers for the spacing, which can cause the subgraphs to be \
arranged in a different order. For example, if you prefer the first column to \
be at the upper rather than lower left, you can supply the option ",
 StyleBox["DataSpacing", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["{0,", "MR"],
 " ",
 StyleBox["-2}", "MR"],
 ". An interesting effect can be derived by setting this option to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", where all the subgraphs are overlaid. "
}], "Text",
 CellTags->{"S6.9.1", "1.42"}],

Cell[TextData[{
 "In addition, all of the usual ",
 StyleBox["Graphics", "MR"],
 " options are accepted. "
}], "Text",
 CellTags->{"S6.9.1", "1.43"}],

Cell["Generate the plot with options controlling its appearance. ", \
"MathCaption",
  CellTags->{"S6.9.1", "1.44"}],

Cell[CellGroupData[{

Cell["\<\
PairwiseScatterPlot[dat,
  DataSpacing -> 0.1,
  PlotStyle -> {{GrayLevel[0], GrayLevel[0.7]}, {GrayLevel[0.4],
        GrayLevel[0.9]}},
  DataRanges -> {All, All, {-0.75, 1}},
  DataLabels -> {\"Line\", \"Sin\", \"Cos\"},
  AspectRatio -> 0.5]\
\>", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S6.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.297619 0.0119048 0.14881 [
[.17262 .0119 -14 -11.6438 ]
[.17262 .0119 14 -1.51875 ]
[.02381 .08631 -32.2 -5.0625 ]
[.02381 .08631 -4.2 5.0625 ]
[.5 .0119 -11 -11.6438 ]
[.5 .0119 11 -1.51875 ]
[.02381 .25 -25.3 -5.0625 ]
[.02381 .25 -3.3 5.0625 ]
[.82738 .0119 -11 -11.2844 ]
[.82738 .0119 11 -1.47188 ]
[.02381 .41369 -25.3 -4.90625 ]
[.02381 .41369 -3.3 4.90625 ]
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .0119 m
.32143 .0119 L
.32143 .16071 L
.02381 .16071 L
.02381 .0119 L
s
.008 w
.03734 .01867 Mdot
.0417 .02085 Mdot
.04607 .02303 Mdot
.05043 .02521 Mdot
.05479 .0274 Mdot
.05916 .02958 Mdot
.06352 .03176 Mdot
.06789 .03394 Mdot
.07225 .03612 Mdot
.07661 .03831 Mdot
.08098 .04049 Mdot
.08534 .04267 Mdot
.0897 .04485 Mdot
.09407 .04703 Mdot
.09843 .04922 Mdot
.1028 .0514 Mdot
.10716 .05358 Mdot
.11152 .05576 Mdot
.11589 .05794 Mdot
.12025 .06013 Mdot
.12462 .06231 Mdot
.12898 .06449 Mdot
.13334 .06667 Mdot
.13771 .06885 Mdot
.14207 .07104 Mdot
.20753 .10377 Mdot
.21189 .10595 Mdot
.21626 .10813 Mdot
.22062 .11031 Mdot
.22499 .11249 Mdot
.22935 .11467 Mdot
.23371 .11686 Mdot
.23808 .11904 Mdot
.24244 .12122 Mdot
.24681 .1234 Mdot
.25117 .12558 Mdot
.25553 .12777 Mdot
.2599 .12995 Mdot
.26426 .13213 Mdot
.26863 .13431 Mdot
.27299 .13649 Mdot
.27735 .13868 Mdot
.28172 .14086 Mdot
.28608 .14304 Mdot
.29044 .14522 Mdot
.29481 .1474 Mdot
.29917 .14959 Mdot
.30354 .15177 Mdot
.3079 .15395 Mdot
.5 Mabswid
.02381 .1756 m
.32143 .1756 L
.32143 .3244 L
.02381 .3244 L
.02381 .1756 L
s
.4 g
.008 w
.50002 .01867 Mdot
.51353 .02085 Mdot
.52691 .02303 Mdot
.54001 .02521 Mdot
.55272 .0274 Mdot
.5649 .02958 Mdot
.57643 .03176 Mdot
.5872 .03394 Mdot
.59709 .03612 Mdot
.60602 .03831 Mdot
.61389 .04049 Mdot
.62062 .04267 Mdot
.62614 .04485 Mdot
.63041 .04703 Mdot
.63337 .04922 Mdot
.635 .0514 Mdot
.63528 .05358 Mdot
.63421 .05576 Mdot
.6318 .05794 Mdot
.62807 .06013 Mdot
.62307 .06231 Mdot
.61683 .06449 Mdot
.60943 .06667 Mdot
.60093 .06885 Mdot
.59142 .07104 Mdot
.40696 .10377 Mdot
.39762 .10595 Mdot
.3893 .10813 Mdot
.38209 .11031 Mdot
.37605 .11249 Mdot
.37126 .11467 Mdot
.36775 .11686 Mdot
.36556 .11904 Mdot
.36472 .12122 Mdot
.36523 .1234 Mdot
.36708 .12558 Mdot
.37027 .12777 Mdot
.37475 .12995 Mdot
.38048 .13213 Mdot
.38741 .13431 Mdot
.39546 .13649 Mdot
.40455 .13868 Mdot
.4146 .14086 Mdot
.42551 .14304 Mdot
.43716 .14522 Mdot
.44943 .1474 Mdot
.46221 .14959 Mdot
.47537 .15177 Mdot
.48878 .15395 Mdot
0 g
.5 Mabswid
.02381 .33929 m
.32143 .33929 L
.32143 .4881 L
.02381 .4881 L
.02381 .33929 L
s
.008 w
.96266 .01867 Mdot
.96189 .02085 Mdot
.95958 .02303 Mdot
.95576 .02521 Mdot
.95046 .0274 Mdot
.94374 .02958 Mdot
.93566 .03176 Mdot
.92631 .03394 Mdot
.91577 .03612 Mdot
.90416 .03831 Mdot
.89159 .04049 Mdot
.87818 .04267 Mdot
.86408 .04485 Mdot
.84941 .04703 Mdot
.83433 .04922 Mdot
.81899 .0514 Mdot
.80354 .05358 Mdot
.78813 .05576 Mdot
.77293 .05794 Mdot
.75807 .06013 Mdot
.74372 .06231 Mdot
.73 .06449 Mdot
.71707 .06667 Mdot
.70504 .06885 Mdot
.69405 .07104 Mdot
.69582 .10377 Mdot
.707 .10595 Mdot
.71918 .10813 Mdot
.73226 .11031 Mdot
.74609 .11249 Mdot
.76054 .11467 Mdot
.77546 .11686 Mdot
.79072 .11904 Mdot
.80614 .12122 Mdot
.82158 .1234 Mdot
.83689 .12558 Mdot
.85191 .12777 Mdot
.86649 .12995 Mdot
.88049 .13213 Mdot
.89377 .13431 Mdot
.90618 .13649 Mdot
.91762 .13868 Mdot
.92796 .14086 Mdot
.93711 .14304 Mdot
.94496 .14522 Mdot
.95145 .1474 Mdot
.9565 .14959 Mdot
.96008 .15177 Mdot
.96213 .15395 Mdot
.5 Mabswid
.35119 .0119 m
.64881 .0119 L
.64881 .16071 L
.35119 .16071 L
.35119 .0119 L
s
.7 g
.008 w
.03734 .25001 Mdot
.0417 .25677 Mdot
.04607 .26345 Mdot
.05043 .27001 Mdot
.05479 .27636 Mdot
.05916 .28245 Mdot
.06352 .28821 Mdot
.06789 .2936 Mdot
.07225 .29855 Mdot
.07661 .30301 Mdot
.08098 .30694 Mdot
.08534 .31031 Mdot
.0897 .31307 Mdot
.09407 .3152 Mdot
.09843 .31669 Mdot
.1028 .3175 Mdot
.10716 .31764 Mdot
.11152 .31711 Mdot
.11589 .3159 Mdot
.12025 .31404 Mdot
.12462 .31153 Mdot
.12898 .30841 Mdot
.13334 .30471 Mdot
.13771 .30046 Mdot
.14207 .29571 Mdot
.20753 .20348 Mdot
.21189 .19881 Mdot
.21626 .19465 Mdot
.22062 .19104 Mdot
.22499 .18803 Mdot
.22935 .18563 Mdot
.23371 .18387 Mdot
.23808 .18278 Mdot
.24244 .18236 Mdot
.24681 .18261 Mdot
.25117 .18354 Mdot
.25553 .18513 Mdot
.2599 .18737 Mdot
.26426 .19024 Mdot
.26863 .1937 Mdot
.27299 .19773 Mdot
.27735 .20228 Mdot
.28172 .2073 Mdot
.28608 .21275 Mdot
.29044 .21858 Mdot
.29481 .22472 Mdot
.29917 .23111 Mdot
.30354 .23769 Mdot
.3079 .24439 Mdot
0 g
.5 Mabswid
.35119 .1756 m
.64881 .1756 L
.64881 .3244 L
.35119 .3244 L
.35119 .1756 L
s
.9 g
.008 w
.50002 .25001 Mdot
.51353 .25677 Mdot
.52691 .26345 Mdot
.54001 .27001 Mdot
.55272 .27636 Mdot
.5649 .28245 Mdot
.57643 .28821 Mdot
.5872 .2936 Mdot
.59709 .29855 Mdot
.60602 .30301 Mdot
.61389 .30694 Mdot
.62062 .31031 Mdot
.62614 .31307 Mdot
.63041 .3152 Mdot
.63337 .31669 Mdot
.635 .3175 Mdot
.63528 .31764 Mdot
.63421 .31711 Mdot
.6318 .3159 Mdot
.62807 .31404 Mdot
.62307 .31153 Mdot
.61683 .30841 Mdot
.60943 .30471 Mdot
.60093 .30046 Mdot
.59142 .29571 Mdot
.40696 .20348 Mdot
.39762 .19881 Mdot
.3893 .19465 Mdot
.38209 .19104 Mdot
.37605 .18803 Mdot
.37126 .18563 Mdot
.36775 .18387 Mdot
.36556 .18278 Mdot
.36472 .18236 Mdot
.36523 .18261 Mdot
.36708 .18354 Mdot
.37027 .18513 Mdot
.37475 .18737 Mdot
.38048 .19024 Mdot
.38741 .1937 Mdot
.39546 .19773 Mdot
.40455 .20228 Mdot
.4146 .2073 Mdot
.42551 .21275 Mdot
.43716 .21858 Mdot
.44943 .22472 Mdot
.46221 .23111 Mdot
.47537 .23769 Mdot
.48878 .24439 Mdot
0 g
.5 Mabswid
.35119 .33929 m
.64881 .33929 L
.64881 .4881 L
.35119 .4881 L
.35119 .33929 L
s
.7 g
.008 w
.96266 .25001 Mdot
.96189 .25677 Mdot
.95958 .26345 Mdot
.95576 .27001 Mdot
.95046 .27636 Mdot
.94374 .28245 Mdot
.93566 .28821 Mdot
.92631 .2936 Mdot
.91577 .29855 Mdot
.90416 .30301 Mdot
.89159 .30694 Mdot
.87818 .31031 Mdot
.86408 .31307 Mdot
.84941 .3152 Mdot
.83433 .31669 Mdot
.81899 .3175 Mdot
.80354 .31764 Mdot
.78813 .31711 Mdot
.77293 .3159 Mdot
.75807 .31404 Mdot
.74372 .31153 Mdot
.73 .30841 Mdot
.71707 .30471 Mdot
.70504 .30046 Mdot
.69405 .29571 Mdot
.69582 .20348 Mdot
.707 .19881 Mdot
.71918 .19465 Mdot
.73226 .19104 Mdot
.74609 .18803 Mdot
.76054 .18563 Mdot
.77546 .18387 Mdot
.79072 .18278 Mdot
.80614 .18236 Mdot
.82158 .18261 Mdot
.83689 .18354 Mdot
.85191 .18513 Mdot
.86649 .18737 Mdot
.88049 .19024 Mdot
.89377 .1937 Mdot
.90618 .19773 Mdot
.91762 .20228 Mdot
.92796 .2073 Mdot
.93711 .21275 Mdot
.94496 .21858 Mdot
.95145 .22472 Mdot
.9565 .23111 Mdot
.96008 .23769 Mdot
.96213 .24439 Mdot
0 g
.5 Mabswid
.67857 .0119 m
.97619 .0119 L
.97619 .16071 L
.67857 .16071 L
.67857 .0119 L
s
.008 w
.03734 .48133 Mdot
.0417 .48094 Mdot
.04607 .47979 Mdot
.05043 .47788 Mdot
.05479 .47523 Mdot
.05916 .47187 Mdot
.06352 .46783 Mdot
.06789 .46315 Mdot
.07225 .45789 Mdot
.07661 .45208 Mdot
.08098 .44579 Mdot
.08534 .43909 Mdot
.0897 .43204 Mdot
.09407 .42471 Mdot
.09843 .41717 Mdot
.1028 .4095 Mdot
.10716 .40177 Mdot
.11152 .39407 Mdot
.11589 .38646 Mdot
.12025 .37904 Mdot
.12462 .37186 Mdot
.12898 .365 Mdot
.13334 .35853 Mdot
.13771 .35252 Mdot
.14207 .34702 Mdot
.20753 .34791 Mdot
.21189 .3535 Mdot
.21626 .35959 Mdot
.22062 .36613 Mdot
.22499 .37304 Mdot
.22935 .38027 Mdot
.23371 .38773 Mdot
.23808 .39536 Mdot
.24244 .40307 Mdot
.24681 .41079 Mdot
.25117 .41845 Mdot
.25553 .42596 Mdot
.2599 .43325 Mdot
.26426 .44025 Mdot
.26863 .44688 Mdot
.27299 .45309 Mdot
.27735 .45881 Mdot
.28172 .46398 Mdot
.28608 .46855 Mdot
.29044 .47248 Mdot
.29481 .47572 Mdot
.29917 .47825 Mdot
.30354 .48004 Mdot
.3079 .48106 Mdot
.5 Mabswid
.67857 .1756 m
.97619 .1756 L
.97619 .3244 L
.67857 .3244 L
.67857 .1756 L
s
.4 g
.008 w
.50002 .48133 Mdot
.51353 .48094 Mdot
.52691 .47979 Mdot
.54001 .47788 Mdot
.55272 .47523 Mdot
.5649 .47187 Mdot
.57643 .46783 Mdot
.5872 .46315 Mdot
.59709 .45789 Mdot
.60602 .45208 Mdot
.61389 .44579 Mdot
.62062 .43909 Mdot
.62614 .43204 Mdot
.63041 .42471 Mdot
.63337 .41717 Mdot
.635 .4095 Mdot
.63528 .40177 Mdot
.63421 .39407 Mdot
.6318 .38646 Mdot
.62807 .37904 Mdot
.62307 .37186 Mdot
.61683 .365 Mdot
.60943 .35853 Mdot
.60093 .35252 Mdot
.59142 .34702 Mdot
.40696 .34791 Mdot
.39762 .3535 Mdot
.3893 .35959 Mdot
.38209 .36613 Mdot
.37605 .37304 Mdot
.37126 .38027 Mdot
.36775 .38773 Mdot
.36556 .39536 Mdot
.36472 .40307 Mdot
.36523 .41079 Mdot
.36708 .41845 Mdot
.37027 .42596 Mdot
.37475 .43325 Mdot
.38048 .44025 Mdot
.38741 .44688 Mdot
.39546 .45309 Mdot
.40455 .45881 Mdot
.4146 .46398 Mdot
.42551 .46855 Mdot
.43716 .47248 Mdot
.44943 .47572 Mdot
.46221 .47825 Mdot
.47537 .48004 Mdot
.48878 .48106 Mdot
0 g
.5 Mabswid
.67857 .33929 m
.97619 .33929 L
.97619 .4881 L
.67857 .4881 L
.67857 .33929 L
s
.008 w
.96266 .48133 Mdot
.96189 .48094 Mdot
.95958 .47979 Mdot
.95576 .47788 Mdot
.95046 .47523 Mdot
.94374 .47187 Mdot
.93566 .46783 Mdot
.92631 .46315 Mdot
.91577 .45789 Mdot
.90416 .45208 Mdot
.89159 .44579 Mdot
.87818 .43909 Mdot
.86408 .43204 Mdot
.84941 .42471 Mdot
.83433 .41717 Mdot
.81899 .4095 Mdot
.80354 .40177 Mdot
.78813 .39407 Mdot
.77293 .38646 Mdot
.75807 .37904 Mdot
.74372 .37186 Mdot
.73 .365 Mdot
.71707 .35853 Mdot
.70504 .35252 Mdot
.69405 .34702 Mdot
.69582 .34791 Mdot
.707 .3535 Mdot
.71918 .35959 Mdot
.73226 .36613 Mdot
.74609 .37304 Mdot
.76054 .38027 Mdot
.77546 .38773 Mdot
.79072 .39536 Mdot
.80614 .40307 Mdot
.82158 .41079 Mdot
.83689 .41845 Mdot
.85191 .42596 Mdot
.86649 .43325 Mdot
.88049 .44025 Mdot
.89377 .44688 Mdot
.90618 .45309 Mdot
.91762 .45881 Mdot
.92796 .46398 Mdot
.93711 .46855 Mdot
.94496 .47248 Mdot
.95145 .47572 Mdot
.9565 .47825 Mdot
.96008 .48004 Mdot
.96213 .48106 Mdot
gsave
.17262 .0119 -75 -15.6438 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Line) show
87.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.02381 .08631 -93.2 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Line) show
87.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .0119 -72 -15.6438 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sin) show
81.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.02381 .25 -86.3 -9.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sin) show
81.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.82738 .0119 -72 -15.2844 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cos) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.02381 .41369 -86.3 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cos) show
81.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oo`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]
0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]
0?ooo`00?03oool5000000<0oooo0`0000000`3oool00000000000020?ooo`8000000P3oool30000
04L0oooo0`0000040?ooo`<0000000<0oooo0000000000000P3oool2000004T0oooo0`0000030?oo
o`8000000`3oool3000002X0oooo000m0?ooo`040000003oool0oooo000000@0oooo00D000000?oo
o`3oool0oooo000000020?ooo`040000003oool0oooo000004X0oooo00@000000?ooo`3oool00000
103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0A`3oool00`000000
oooo0?ooo`030?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool09`3oool003d0
oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool01000001:0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00020?ooo`<00000:P3oool003d0oooo00<000000?ooo`3oool0103oool200000080oooo10000004
0?ooo`800000B@3oool2000000@0oooo0P0000020?ooo`@00000BP3oool00`000000oooo0?ooo`04
0?ooo`8000000`3oool4000002T0oooo000m0?ooo`030000003oool0oooo05X0oooo00@000000?oo
o`3oool00000E@3oool010000000oooo0?ooo`00000e0?ooo`00?03oool3000000H0oooo00<00000
0?ooo`3oool0DP3oool4000000@0oooo00<000000?ooo`3oool0C`3oool3000003D0oooo003o0?oo
obd0oooo003o0?ooobd0oooo000P0?oooe8000001`3ooomC000000L0ooooDP0000070?ooo`00803o
ool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0C`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool01@3o
ool00200oooo00<000000?ooo`3oool00P00001<0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool09@3oool01@1VIVH0oooo0?ooo`3oool0IVIV02D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`1:0?ooo`050000003oool0oooo0?ooo`0000001`3oool00200oooo00<0
00000?ooo`3oool01000001:0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool09@3o
ool01@1VIVH0oooo0?ooo`3oool0IVIV00<0oooo00@0IVIV0?ooo`3oool0IVIV7P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo04P0oooo0`0000030?ooo`030000003oool0oooo00D0
oooo000P0?ooo`030000003oool0oooo0080oooo0P0000000`3oool000000?ooo`170?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0;@3oool0101VIVH0oooo0?ooo`1VIVH30?ooo`03
06IVIP3oool0oooo01P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`160?ooo`04
0000003oool00000000000@0oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3o
ool01@3oool3000004H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0d0?ooo`04
06IVIP3oool0oooo06IVIP80oooo00<0IVIV0?ooo`3oool04P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0480oooo00<000000?ooo`3oool00P0000070?ooo`030000003oool0oooo
00D0oooo000P0?ooo`030000003oool0oooo00H0oooo100000140?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0=`3oool0101VIVH0oooo0?ooo`1VIVH20?ooo`0406IVIP3oool0oooo
06IVIPh0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0m0?ooo`060000003oool0
oooo0000003oool000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo
000P0?ooo`030000003oool0oooo00P0oooo0P0000000`3oool00000000000110?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0?@3oool0201VIVH0oooo0?ooo`1VIVH0oooo06IVIP3o
ool0IVIV2P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03H0oooo00D000000?oo
o`3oool0oooo000000020?ooo`040000003oool0oooo000000d0oooo00<000000?ooo`3oool01@3o
ool00200oooo00<000000?ooo`3oool02`3oool300000400oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`120?ooo`0506IVIP3oool0IVIV0?ooo`1VIVH0203oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo03<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo00d0oooo0`00
000n0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0AP3oool0101VIVH0oooo06IV
IP1VIVH50?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0:`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`050?ooo`00
803oool00`000000oooo0?ooo`0>0?ooo`80000000<0oooo000000000000>`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo04P0oooo0`1VIVH40?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000
003oool0oooo0140oooo0`00000j0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
BP3oool00`1VIVH0oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
7P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0903oool00`000000
oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0C0?ooo`<00000>03oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo04T0oooo0P1VIVH40?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool05P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0D0?ooo`<00000
00<0oooo0000003oool0=03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04L0oooo
101VIVH40?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo0000000c0?ooo`030000003oool0oooo
00D0oooo000P0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`0000000000=03oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo04D0oooo00@0IVIV0?ooo`1VIVH0IVIV1P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool01@3oool00200oooo00<00000
0?ooo`3oool06@3oool300000380oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`11
0?ooo`0506IVIP3oool0IVIV0?ooo`1VIVH02@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0440oooo
00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool06P3oool300000340oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0n0?ooo`0606IVIP3oool0oooo06IVIP3oool0
IVIV2`3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo00000080oooo00D000000?oo
o`3oool0oooo000000160?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
03h0oooo00<0IVIV0?ooo`3oool03P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo
000004d0oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0CP3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`1>0?ooo`030000003oool0oooo00D0oooo00020?ooo`D000000`3oool300000003
0?ooo`00000000000080oooo0P0000020?ooo`<000001`3oool00`000000oooo0?ooo`1>0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo04h0oooo00<000000?ooo`3oool01@3oool000<0oooo00@000000?ooo`3oool0
0000103oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000002P3oool0
0`000000oooo0?ooo`1>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0C`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool01@3oool0
00<0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool0100000070?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`1?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0CP3oool0
0`000000oooo0?ooo`050?ooo`000`3oool00`000000oooo0?ooo`040?ooo`8000000P3oool40000
00@0oooo0P0000080?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`1?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0CP3oool00`00
0000oooo0?ooo`050?ooo`000`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo04h0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`050?ooo`000P3oool3000000H0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04h0oooo
00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0;P3oool00`000000oooo0000
000M0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool0101VIVH0oooo0?oo
o`1VIVI20?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo04L0oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0
;P3oool010000000oooo00000000000L0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01`3oool00`1VIVH0oooo06IVIP020?ooo`0306IVIP3oool0oooo0400oooo00<000000?ooo`3o
ool01@3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool00000AP3oool0
0`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0a0?ooo`<000006P3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00D0IVIV0?ooo`1VIVH0oooo06IVIP17
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`050?ooo`00803oool0
0`000000oooo0?ooo`0b0?ooo`<0000000<0oooo0000003oool05P3oool00`000000oooo0?ooo`05
0?ooo`040000003oool0oooo0?ooo`<0IVIV00<0oooo06IVIP3oool0B03oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00/0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`050?ooo`00803o
ool00`000000oooo0?ooo`0d0?ooo`040000003oool00000000001H0oooo00<000000?ooo`3oool0
1@3oool010000000oooo0?ooo`3oool206IVIT`0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000b0?oo
o`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo03L0oooo0`00000D0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00P1VIVI=0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool06`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0:03oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0h0?ooo`@0
00004P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0IVIVC03oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo01l0oooo00D000000?ooo`3oool0oooo000000030?oo
o`050000003oool0oooo0?ooo`0000008P3oool00`000000oooo0?ooo`050?ooo`00803oool00`00
0000oooo0?ooo`0j0?ooo`80000000<0oooo0000003oool03`3oool00`000000oooo0?ooo`050?oo
o`040000003oool0oooo0?ooo`<0IVIVB`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo02L0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo01`0oooo00<0
00000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0?@3oool3000000h0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`0506IVIP3oool0IVIV0?ooo`1VIVH0A`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02l0oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool01@3oool00200oooo00<0
00000?ooo`3oool0?P3oool4000000`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`050?ooo`0706IVIP3oool0IVIV0?ooo`1VIVH0oooo06IVIP130?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0<`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?oo
o`3oool00000403oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`100?oo
o`80000000<0oooo0000003oool02@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00T0oooo00<0IVIV0?ooo`1VIVH00P3oool00`1VIVH0oooo0?ooo`0n0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0>P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0@`3oool30000
00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`0406IVIP3oool0oooo
06IVIP80oooo00<0IVIV0?ooo`3oool0>03oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0400oooo00H000000?ooo`3oool000000?ooo`0000080?ooo`030000003oool0oooo00D0oooo
000P0?ooo`030000003oool0oooo04@0oooo100000060?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool04@3oool0101VIVH0oooo0?ooo`1VIVH20?ooo`0506IVIP3oool0oooo0?ooo`1V
IVH0<`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04<0oooo00@000000?ooo`00
0000oooo0P0000050?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo04H0
oooo0P0000000`3oool000000?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool05`3oool01@1VIVH0oooo0?ooo`3oool0IVIV00<0oooo00<0IVIV0?ooo`3oool0;@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo04L0oooo0`0000040?ooo`030000003oool0oooo
00D0oooo000P0?ooo`030000003oool0oooo04T0oooo0P0000030?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool07`3oool0101VIVH0oooo0?ooo`1VIVH/0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0B@3oool2000000<0oooo00<000000?ooo`3oool01@3oool00200
oooo00<000000?ooo`3oool0BP3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?oo
o`3oool08P3oool00`1VIVH0oooo0?ooo`0Z0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0BP3oool01@000000oooo0?ooo`3oool0000000L0oooo000P0?oooe8000001`3ooomC0000
00L0ooooDP0000070?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00803ooomB
000000L0ooooD`0000070?oooe8000001`3oool00200oooo00<000000?ooo`3oool0=`3oool30;>c
/a@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020>KViTd0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0K0?ooo`050;>c/`3oool0oooo0?ooo`2c/k<00`3oool0
0`2c/k<0oooo0?ooo`0X0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo
03@0oooo00<0/k>c0?ooo`2c/k<01@2c/k<B0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool00`3Vi^I<0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool00`2c
/k<0oooo0?ooo`020?ooo`050;>c/`3oool0oooo0?ooo`2c/k<00`3oool01@2c/k<0oooo0?ooo`3o
ool0/k>c00<0oooo00D0/k>c0?ooo`3oool0oooo0;>c/`0R0?ooo`030000003oool0oooo00D0oooo
000P0?ooo`030000003oool0oooo03<0oooo0P2c/k<00`3oool0/k>c0?ooo`020?ooo`80/k>c00<0
oooo0;>c/`2c/k<03`3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo0?ooo`<0i^KV
00<0oooo0>KViP3oool0B03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00l0oooo
00@0/k>c0?ooo`3oool0/k>c103oool00`2c/k<0oooo0?ooo`0=0?ooo`050;>c/`3oool0oooo0?oo
o`2c/k<00`3oool01@2c/k<0oooo0?ooo`3oool0/k>c01X0oooo00<000000?ooo`3oool01@3oool0
0200oooo00<000000?ooo`3oool0<P3oool20;>c/`T0oooo0`2c/k<>0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool00`3oool01@3Vi^H0oooo0>KViP3oool0i^KV04L0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0;0?ooo`050;>c/`3oool0oooo0?ooo`2c/k<07`3o
ool01@2c/k<0oooo0?ooo`3oool0/k>c00<0oooo00<0/k>c0?ooo`3oool0503oool00`000000oooo
0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0a0?ooo`80/k>c303oool20;>c/`d0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`050>KViP3oool0i^KV0?ooo`3Vi^H0
A@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00D0/k>c0?ooo`3oool0
oooo0;>c/`0[0?ooo`040;>c/`3oool0oooo0;>c/a<0oooo00<000000?ooo`3oool01@3oool00200
oooo00<000000?ooo`3oool0<03oool20;>c/`h0oooo00<0/k>c0?ooo`3oool02`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00L0oooo00<0i^KV0?ooo`3Vi^H0A@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00@0/k>c0?ooo`3oool0/k>c<P3oool00`2c
/k<0oooo0?ooo`0A0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo02h0
oooo00<0/k>c0?ooo`2c/k<0403oool00`2c/k<0oooo0?ooo`0:0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool02@3oool0103Vi^H0oooo0>KViP3Vi^I20?ooo`030000003oool0oooo
00D0oooo00D000000?ooo`3oool0oooo0;>c/`020?ooo`030;>c/`3oool0oooo03H0oooo00<0/k>c
0?ooo`3oool03P3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0^0?oo
o`030;>c/`3oool0oooo0100oooo00<0/k>c0?ooo`2c/k<02P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00/0oooo0P3Vi^H00`3oool0i^KV0?ooo`0o0?ooo`030000003oool0oooo
00D0oooo00D000000?ooo`3oool0oooo0;>c/`0k0?ooo`040;>c/`3oool0oooo0;>c/`d0oooo00<0
00000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0@`3oool00`2c/k<0oooo0?ooo`08
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool03P3oool00`3Vi^H0oooo0?ooo`0n
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0@03oool00`2c/k<0oooo0?ooo`0;
0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo04@0oooo00<0/k>c0?oo
o`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0140oooo00<0i^KV0?oo
o`3oool0>`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04<0oooo00<0/k>c0?oo
o`3oool0203oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`140?ooo`80
/k>c203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0140oooo00@0i^KV0?ooo`3o
ool0i^KV>P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04<0oooo00<0/k>c0?oo
o`2c/k<0203oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`150?ooo`03
0;>c/`3oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0D0?ooo`03
0>KViP3oool0oooo03P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`150?ooo`03
0;>c/`3oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0
AP3oool00`2c/k<0oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
5`3oool00`3Vi^H0oooo0?ooo`0e0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
A`3oool00`2c/k<0oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003o
ool0oooo04H0oooo00<0/k>c0?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo01L0oooo00<0i^KV0?ooo`3oool0=@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo04L0oooo00<0/k>c0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`00803oool0
0`000000oooo0?ooo`170?ooo`030;>c/`3oool0oooo00@0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0K0?ooo`030>KViP3oool0oooo0340oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`180?ooo`030;>c/`3oool0oooo00<0oooo00<000000?ooo`3oool01@3oool0
0200oooo00<000000?ooo`3oool0A`3oool00`2c/k<0oooo0;>c/`040?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool06`3oool01@3Vi^H0oooo0?ooo`3oool0i^KV02l0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`180?ooo`80/k>c103oool00`000000oooo0?ooo`05
0?ooo`00803oool00`000000oooo0?ooo`190?ooo`030;>c/`3oool0oooo0080oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0O0?ooo`030>KViP3oool0oooo02d0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`190?ooo`030;>c/`3oool0oooo0080oooo00<000000?oo
o`3oool01@3oool00200oooo00<000000?ooo`3oool0BP3oool01@2c/k<0oooo0?ooo`3oool00000
00L0oooo00<000000?ooo`3oool08P3oool00`3Vi^H0oooo0?ooo`0Z0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0BP3oool01@2c/k<0oooo0?ooo`3oool0000000L0oooo00090?oo
o`<00000103oool3000000030?ooo`00000000000080oooo0P0000060?ooo`030000003oool0oooo
04X0oooo00D0/k>c0?ooo`3oool0oooo000000070?ooo`030000003oool0oooo0280oooo00<0i^KV
0?ooo`3oool0:P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04X0oooo00D0/k>c
0?ooo`3oool0oooo000000070?ooo`002@3oool010000000oooo0?ooo`0000040?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo0;>c/dd0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0U0?ooo`030>KViP3oool0oooo02L0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1:0?ooo`050;>c/`3oool0oooo0?oo
o`0000001`3oool000`0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`2c/k==0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool09@3oool00`3Vi^H0oooo0?ooo`0W0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0BP3oool01@2c/k<0oooo0?ooo`3oool0000000L0oooo000:
0?ooo`800000103oool200000080oooo100000080?ooo`050000003oool0oooo0?ooo`2c/k<0C03o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02T0oooo00<0i^KV0?ooo`3oool08`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04X0oooo00D0/k>c0?ooo`3oool0oooo
000000070?ooo`002@3oool010000000oooo0?ooo`00000C0?ooo`040000003oool0oooo0?ooo`80
/k>cB`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02T0oooo00D0i^KV0?ooo`3o
ool0oooo0>KViP0Q0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0B@3oool20;>c
/`<0oooo00<000000?ooo`3oool01@3oool000T0oooo100000040?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool00P3oool00`2c/k<0oooo0?ooo`190?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0;@3oool00`3Vi^H0oooo0?ooo`0O0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0B@3oool00`2c/k<0oooo0?ooo`020?ooo`030000003oool0oooo00D0
oooo000P0?ooo`030000003oool0oooo00<0oooo00<0/k>c0?ooo`3oool0B03oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0300oooo00<0i^KV0?ooo`3oool0703oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo04P0oooo00<0/k>c0?ooo`3oool00`3oool00`000000oooo
0?ooo`050?ooo`00803oool00`000000oooo0?ooo`030?ooo`030;>c/`3oool0oooo04P0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0`0?ooo`030>KViP3oool0oooo01`0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`180?ooo`030;>c/`3oool0oooo00<0oooo00<0
00000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool01@3oool00`2c/k<0oooo0?ooo`16
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0=03oool00`3Vi^H0oooo0?ooo`0H
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0AP3oool00`2c/k<0oooo0?ooo`05
0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo00D0oooo00<0/k>c0?oo
o`3oool0AP3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03@0oooo00<0i^KV0?oo
o`3oool0603oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04H0oooo00<0/k>c0?oo
o`3oool01@3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`060?ooo`03
0;>c/`3oool0oooo04D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0g0?ooo`03
0>KViP3oool0oooo01D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`150?ooo`03
0;>c/`3oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0
1P3oool20;>c/dH0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0g0?ooo`040>KV
iP3oool0oooo0>KViQ@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`120?ooo`04
0;>c/`3oool0oooo0;>c/`P0oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3o
ool01`3oool00`2c/k<0oooo0?ooo`140?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0>P3oool00`3Vi^H0oooo0?ooo`0B0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0@P3oool00`2c/k<0oooo0?ooo`090?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000
003oool0oooo00P0oooo00<0/k>c0?ooo`3oool04@3oool00`2c/k<0oooo0?ooo`0_0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0?@3oool20>KViQ00oooo00<000000?ooo`3oool0
1@3oool010000000oooo0?ooo`2c/k<o0?ooo`030;>c/`3oool0oooo00/0oooo00<000000?ooo`3o
ool01@3oool00200oooo00<000000?ooo`3oool0203oool20;>c/a80oooo00<0/k>c0?ooo`3oool0
;`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03d0oooo0P3Vi^H00`3oool0i^KV
0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0/k>c?03oool0102c/k<0
oooo0?ooo`2c/k<=0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo00T0
oooo00<0/k>c0?ooo`2c/k<03`3oool00`2c/k<0oooo0?ooo`0`0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0@03oool30>KViP`0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`030?ooo`030;>c/`3oool0oooo03@0oooo00@0/k>c0?ooo`3oool0/k>c403oool00`00
0000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0;0?ooo`80/k>c3@3oool20;>c/c80
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`110?ooo`@0i^KV2P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00D0/k>c0?ooo`3oool0oooo0;>c/`0^0?oo
o`050;>c/`3oool0oooo0?ooo`2c/k<04`3oool00`000000oooo0?ooo`050?ooo`00803oool00`00
0000oooo0?ooo`0<0?ooo`80/k>c2`3oool20;>c/c<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`130?ooo`@0i^KV203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00L0oooo00@0/k>c0?ooo`3oool0/k>c:03oool0102c/k<0oooo0?ooo`2c/k<G0?ooo`030000003o
ool0oooo00D0oooo000P0?ooo`030000003oool0oooo00d0oooo0P2c/k<70?ooo`040;>c/`3oool0
/k>c0;>c/c@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`150?ooo`@0i^KV1P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo00D0/k>c0?ooo`3oool0oooo
0;>c/`030?ooo`030;>c/`3oool0oooo01X0oooo00D0/k>c0?ooo`3oool0oooo0;>c/`0J0?ooo`03
0000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo00h0oooo0P2c/k<00`3oool0/k>c
0;>c/`040;>c/`030?ooo`2c/k<0oooo03@0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`170?ooo`@0i^KV103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00h0oooo
00D0/k>c0?ooo`3oool0oooo0;>c/`030?ooo`050;>c/`3oool0oooo0?ooo`2c/k<00`3oool01@2c
/k<0oooo0?ooo`3oool0/k>c00@0oooo00D0/k>c0?ooo`3oool0oooo0;>c/`030?ooo`030;>c/`3o
ool0oooo01`0oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool03`3oool0
0`2c/k<0oooo0;>c/`040;>c/cP0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`19
0?ooo`80i^KV103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01H0oooo00D0/k>c
0?ooo`3oool0oooo0;>c/`030?ooo`050;>c/`3oool0oooo0?ooo`2c/k<0103oool01@2c/k<0oooo
0?ooo`3oool0/k>c0280oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0
CP3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo00D0oooo000P0?oooe8000001`3o
oomC000000L0ooooDP0000070?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00o`3oool]0?ooo`00
803ooomB000000L0ooooD`0000070?oooe8000001`3oool00200oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0?P3o
ool00`1VIVH0oooo0?ooo`0>0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000
C@3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0L0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00`0oooo00<0IVIV0?ooo`3oool0;`3oool00`1VIVH0oooo0?ooo`0>0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00P00001<0?ooo`030000003oool0oooo00D0oooo000P
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0403oool00`000000oooo0000000M
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool0101VIVH0oooo0?ooo`1V
IVHd0?ooo`0306IVIP3oool0oooo00/0oooo00<000000?ooo`3oool01@3oool01P000000oooo0?oo
o`3oool000000?ooo`800000B@3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo
0?ooo`0J0?ooo`800000503oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool02@3oool00`1VIVH0oooo0?ooo`0e0?ooo`0306IVIP3oool0IVIV00/0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`8000000P3oool00`000000oooo
0?ooo`140?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01`3oool00`1VIVH0oooo0?ooo`0i0?ooo`0306IVIP3oool0oooo00T0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04@0oooo00<0
00000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0E
0?ooo`8000006`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0IVIV
0?ooo`1VIVH0?@3oool00`1VIVH0oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0200000480oooo00<000000?ooo`3oool01@3oool0
0200oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`0306IVIP3oool0oooo
03d0oooo00<0IVIV0?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00X0oooo0P0000120?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool00`3oool00`1VIVH0oooo0?ooo`110?ooo`0306IVIP3oool0oooo00D0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`800000?P3oool00`000000
oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo
00<0IVIV0?ooo`3oool0@@3oool00`1VIVH0oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool03P3oool2000003h0oooo00<000000?ooo`3oool01@3oool00200oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`0306IVIP3oool0oooo04<0oooo00<0
IVIV0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool0>@3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0080oooo00<0IVIV0?ooo`3oool0@`3oool00`1VIVH0oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0i
0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00D0oooo00D000000?oo
o`3oool0oooo06IVIP170?ooo`0306IVIP3oool0oooo00<0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0F0?ooo`800000=P3oool00`000000oooo0?ooo`050?ooo`00803oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`1VIVH0A`3oool00`1VIVH0oooo0?ooo`03
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05P3oool2000003H0oooo00<00000
0?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0P0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0
IVIV04P0oooo00<0IVIV0?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo01X0oooo0P00000b0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
00D0oooo00D000000?ooo`3oool0oooo06IVIP180?ooo`0306IVIP3oool0oooo0080oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0J0?ooo`800000<P3oool00`000000oooo0?ooo`05
0?ooo`00803oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo03P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`1:0?ooo`0306IVIP3oool0oooo0080oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo02d0oooo00<000000?oo
o`3oool01@3oool00200oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`1VIVI90?oo
o`0306IVIP3oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0N0?oo
o`800000;P3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo02<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`050?ooo`04
0000003oool0oooo06IVITT0oooo00<0IVIV0?ooo`3oool00P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo01l0oooo00@000000?ooo`3oool00000:`3oool00`000000oooo0?ooo`05
0?ooo`002P3oool3000000<0oooo0P0000030?ooo`<00000203oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo02@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`050?oo
o`040000003oool0oooo06IVITT0oooo00<0IVIV0?ooo`3oool00P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0280oooo0P00000Z0?ooo`030000003oool0oooo00D0oooo00090?oo
o`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0IVIVB@3oool00`1VIVH0oooo0?oo
o`020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool08`3oool01@000000oooo0?oo
o`3oool0000002H0oooo00<000000?ooo`3oool01@3oool000T0oooo00<000000?ooo`3oool00`3o
ool010000000oooo0?ooo`0000020?ooo`<00000203oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`050?ooo`050000
003oool0oooo0?ooo`1VIVH0B03oool00`1VIVH0oooo0?ooo`020?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00D0
oooo00090?ooo`030000003oool0oooo00@0oooo0P0000030?ooo`@000001`3oool00`000000oooo
0?ooo`0j0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool01@3oool01@000000oooo
0?ooo`3oool0IVIV04d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0W0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool01@3oool000T0oooo00@000000?ooo`3oool0
00004`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<0IVIV0?ooo`3o
ool0A03oool00`1VIVH0oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0:`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00D0oooo000:0?ooo`<00000
4`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<0IVIV0?ooo`3oool0
A03oool00`1VIVH0oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
:`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`1VIVH0oooo0?ooo`120?ooo`0306IVIP3o
ool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0_0?ooo`030000003o
ool0oooo01`0oooo00<000000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool03@3oool2
000002h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00<0oooo00<0IVIV0?ooo`3oool0@03oool00`1VIVH0oooo06IVIP060?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0;`3oool01@000000oooo0?ooo`3oool0000001X0oooo00<0
00000?ooo`3oool01@3oool00200oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`05
0?ooo`0306IVIP3oool0oooo03h0oooo00<0IVIV0?ooo`3oool01P3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`05
0?ooo`00803oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02l0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0IVIV0?oo
o`3oool0?03oool00`1VIVH0oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0<`3oool010000000oooo0?ooo`00000G0?ooo`030000003oool0oooo00D0oooo000P0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`1VIVH0oooo0?ooo`0j0?oo
o`0306IVIP3oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0f0?oo
o`8000005P3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo0340oooo0P00000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01`3oool00`1VIVH0oooo06IVIP0h0?ooo`0306IVIP3oool0oooo00X0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0g0?ooo`040000003oool0oooo000001<0oooo00<000000?oo
o`3oool01@3oool00200oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0b0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`03
06IVIP3oool0oooo03H0oooo00<0IVIV0?ooo`3oool02P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`050?ooo`00
803oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo00<0IVIV0?ooo`3oool0
<P3oool00`1VIVH0oooo0?ooo`0<0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
?@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00D0oooo000P0?ooo`030000003o
ool0oooo00P0oooo0P00000g0?ooo`030000003oool0000000X0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0;0?ooo`0406IVIP3oool0oooo06IVIRh0oooo00@0IVIV0?ooo`3oool0
IVIV3P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo03d0oooo00@000000?ooo`3o
ool000003@3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`070?ooo`80
0000>P3oool2000000T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0>0?ooo`04
06IVIP3oool0oooo06IVIRP0oooo00@0IVIV0?ooo`3oool0IVIV4@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo0400oooo00@000000?ooo`00000000002P3oool00`000000oooo0?oo
o`050?ooo`00803oool00`000000oooo0?ooo`060?ooo`800000?03oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool04@3oool00`1VIVH0oooo0?ooo`0S
0?ooo`0406IVIP3oool0oooo06IVIQ@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`120?ooo`80000000<0oooo0000003oool01`3oool00`000000oooo0?ooo`050?ooo`00803oool0
0`000000oooo0?ooo`050?ooo`800000?P3oool2000000L0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0D0?ooo`0406IVIP3oool0oooo06IVIQ`0oooo00@0IVIV0?ooo`3oool0IVIV
5`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo04D0oooo0`0000060?ooo`030000
003oool0oooo00D0oooo000P0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000?`3o
ool3000000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0D0?ooo`0406IVIP3o
ool0oooo06IVIP<0oooo00<0IVIV0?ooo`3oool04P3oool01@1VIVH0oooo0?ooo`3oool0IVIV01X0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`150?ooo`@000001@3oool00`000000
oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`04000004<0oooo00@000000?ooo`000000
00000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01/0oooo00D0IVIV0?ooo`3o
ool0oooo06IVIP020?ooo`0406IVIP3oool0oooo06IVIP<0oooo00D0IVIV0?ooo`3oool0oooo06IV
IP020?ooo`0306IVIP3oool0oooo01`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`180?ooo`<000000`3oool00`000000oooo0?ooo`050?ooo`00803oool00`000000oooo0?ooo`03
000004H0oooo0P0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool07`3oool0
101VIVH0oooo0?ooo`1VIVH20?ooo`0506IVIP3oool0oooo0?ooo`1VIVH00`3oool00`1VIVH0oooo
0?ooo`0O0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0B@3oool2000000<0oooo
00<000000?ooo`3oool01@3oool00200ooooDP0000070?oooe<000001`3ooomB000000L0oooo003o
0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o
0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o
0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o
0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo003o0?ooobd0oooo0000
\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.395881, -0.703783, 0.012294, \
0.0245879}},
  CellTags->"S6.9.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S6.9.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stem\[Hyphen]and\[Hyphen]Leaf Plots", "Subsubsection",
  CellTags->{"S6.9.1", "1.45"}],

Cell["\<\
The stem-and-leaf plot is generally used to visualize the distribution of \
real\[Hyphen]valued data along with the magnitudes of the individual data \
values. Each data value is represented by a stem and leaf, where the stem is \
an integer multiple of a base unit and the leaf is the remainder given to \
some predetermined number of digits. With a base unit of 10, for instance, \
17.3 could be represented as a stem of 1 and a leaf of 7. Leaves are \
collected onto common stems giving a display analogous to a histogram. The \
stems play a role similar to histogram bar positions, and the leaves are \
similar to the histogram bar heights. An advantage of the stem\[Hyphen]and\
\[Hyphen]leaf plot is that individual data values can be read directly from \
the plot. Side\[Hyphen]by\[Hyphen]side stem\[Hyphen]and\[Hyphen]leaf plots \
can be used to compare distributions and magnitudes of two data sets.\
\>", "Text",
  CellTags->{"S6.9.1", "1.46"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StemLeafPlot[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["vector", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[StyleBox[
            "create a stem\[Hyphen]and\[Hyphen]leaf plot of a vector of data",
              
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]},
          {Cell[TextData[{
              StyleBox["StemLeafPlot[", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["vector",
                        "TI",
                        GridBoxOptions->{RowSpacings->0.4,
                        RowLines->False}], "1"], TraditionalForm]], 
                "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox[", ", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["vector",
                        "TI",
                        GridBoxOptions->{RowSpacings->0.4,
                        RowLines->False}], "2"], TraditionalForm]], 
                "InlineFormula",
                GridBoxOptions->{ColumnWidths->Automatic}],
              StyleBox["]", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}], Cell[TextData[Cell[BoxData[
                FormBox[
                Cell[TextData[StyleBox[
                  "create a side\[Hyphen]by\[Hyphen]side stem\[Hyphen]and\
\[Hyphen]leaf plot of two vectors of data",
                    GridBoxOptions->{RowSpacings->0.4,
                    RowLines->False}]],
                    GridBoxOptions->{RowSpacings->0.4,
                    RowLines->False}], TraditionalForm]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->False}]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S6.9.1"],

Cell["Stem\[Hyphen]and\[Hyphen]leaf plots.", "Caption",
  CellTags->"S6.9.1"],

Cell["Here is a vector of real values. ", "MathCaption",
  CellTags->{"S6.9.1", "1.47"}],

Cell["sldata = {1,3.2,3.1,4.556,5.7345};", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S6.9.1"],

Cell["\<\
This is a basic stem\[Hyphen]and\[Hyphen]leaf plot of the data. \
\>", "MathCaption",
  CellTags->{"S6.9.1", "1.48"}],

Cell[CellGroupData[{

Cell["StemLeafPlot[sldata]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"S6.9.1"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[GridBox[{
                  {"\<\"Stem\"\>", "\<\"Leaves\"\>"},
                  {"\<\"1\"\>", "\<\"0\"\>"},
                  {"\<\"3\"\>", "\<\"12\"\>"},
                  {"\<\"4\"\>", "\<\"6\"\>"},
                  {"\<\"5\"\>", "\<\"7\"\>"}
                  },
                ColumnSpacings->1.5,
                RowAlignments->Top,
                ColumnAlignments->{Right, Left, Center},
                RowLines->{True, False},
                ColumnLines->{True, False}],
              Grid]},
          {"\<\"Stem units: \\!\\(1\\)\"\>"}
          },
        RowSpacings->2,
        ColumnAlignments->{Left}],
      Grid]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"S6.9.1"]
}, Open  ]],

Cell["\<\
For this vector, multiples of 1 are taken as the stems and the fractional \
parts rounded to one digit are displayed as the leaves. The values 3.1 and \
3.2 are displayed on the common stem 3 as leaves 1 and 2.\
\>", "Text",
  CellTags->{"S6.9.1", "1.49"}],

Cell["Here is a second vector of real values. ", "MathCaption",
  CellTags->{"S6.9.1", "1.50"}],

Cell["sldata2 = {3.7,3.4,2.1,4.1,3.8,2.6};", "Input",
  CellLabel->"In[4]:=",
  CellTags->"S6.9.1"],

Cell["\<\
The two data sets can be compared in a side\[Hyphen]by\[Hyphen]side stem\
\[Hyphen]and\[Hyphen]leaf plot.\
\>", "MathCaption",
  CellTags->{"S6.9.1", "1.51"}],

Cell[CellGroupData[{

Cell["StemLeafPlot[sldata, sldata2]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"S6.9.1"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[GridBox[{
                  {"\<\"Leaves\"\>", "\<\"Stem\"\>", "\<\"Leaves\"\>"},
                  {"\<\"0\"\>", "\<\"1\"\>", "\<\"\"\>"},
                  {"\<\"\"\>", "\<\"2\"\>", "\<\"16\"\>"},
                  {"\<\"21\"\>", "\<\"3\"\>", "\<\"478\"\>"},
                  {"\<\"6\"\>", "\<\"4\"\>", "\<\"1\"\>"},
                  {"\<\"7\"\>", "\<\"5\"\>", "\<\"\"\>"}
                  },
                ColumnSpacings->1.5,
                RowAlignments->Top,
                ColumnAlignments->{Right, Center, Left},
                RowLines->{True, False},
                ColumnLines->True],
              Grid]},
          {"\<\"Stem units: \\!\\(1\\)\"\>"}
          },
        RowSpacings->2,
        ColumnAlignments->{Left}],
      Grid]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"S6.9.1"]
}, Open  ]],

Cell["\<\
A number of options can be applied to control the appearance of the stem\
\[Hyphen]and\[Hyphen]leaf plot.\
\>", "Text",
  CellTags->{"S6.9.1", "1.52"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["default value", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox["",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["StemExponent", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["Automatic", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "stem units given as an integer power of 10",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["Leaves", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["\"Digits\"", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "how leaves are represented",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["ColumnLabels", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["Automatic", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "labels for the columns of the plot",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["IncludeEmptyStems", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["False", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "whether stems without leaves should be displayed",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["IncludeStemUnits", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["True", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "whether stem units should be included in the plot",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["IncludeStemCounts", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["Automatic", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "whether to include a column of counts along with the leaves",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S6.9.1"],

Cell[TextData[{
  "Options for ",
  StyleBox["StemLeafPlot", "MR",
    GridBoxOptions->{RowSpacings->0.4,
    RowLines->False}],
  ". "
}], "Caption",
  CellTags->"S6.9.1"],

Cell[TextData[{
  "The value of ",
  StyleBox["StemExponent", "MR"],
  " can be an integer or ",
  StyleBox["Automatic", "MR"],
  ". If it is an integer ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", the stem unit is taken to be ",
  Cell[BoxData[
      \(TraditionalForm\`10\^x\)]],
  ".  With ",
  StyleBox["StemExponent\[Rule]Automatic", "MR"],
  ", the exponent is chosen based on the magnitudes of the data."
}], "Text",
  CellTags->{"S6.9.1", "1.53"}],

Cell[TextData[{
  "The ",
  StyleBox["Leaves", "MR"],
  " option value can be ",
  StyleBox["\"Digits\"", "MR"],
  ", ",
  StyleBox["\"Tallies\"", "MR"],
  ", or ",
  StyleBox["None", "MR"],
  ". With ",
  StyleBox["Leaves\[Rule]\"Tallies\"", "MR"],
  ", leaves are represented as tally marks. With ",
  StyleBox["Leaves\[Rule]None", "MR"],
  ", leaves are not included in the plot. The setting ",
  StyleBox["Leaves\[Rule]None", "MR"],
  " is most useful for plotting large data sets as stems and counts instead \
of displaying all the leaves."
}], "Text",
  CellTags->{"S6.9.1", "1.54"}],

Cell[TextData[{
  "The ",
  StyleBox["ColumnLabels", "MR"],
  " option can be used to specify the labels for the columns of the plot. The \
",
  StyleBox["ColumnLabels", "MR"],
  " option value can be a list of a length equal to the number of columns in \
the plot or ",
  StyleBox["Automatic", "MR"],
  ". With ",
  StyleBox["ColumnLabels\[Rule]Automatic", "MR"],
  ", the stem column is labeled ",
  StyleBox["Stem", "MR"],
  ", leaf columns are labeled ",
  StyleBox["Leaves", "MR"],
  ", and count columns are labeled ",
  StyleBox["Counts", "MR"],
  "."
}], "Text",
  CellTags->{"S6.9.1", "1.55"}],

Cell[TextData[{
  "The ",
  StyleBox["IncludeEmptyStems", "MR"],
  " option specifies whether stems within the data range should be included \
if they have no leaves. The possible values for this option are ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  "."
}], "Text",
  CellTags->{"S6.9.1", "1.56"}],

Cell[TextData[{
  "The ",
  StyleBox["IncludeStemUnits", "MR"],
  " option specifies whether or not a reminder of the stem units should be \
included in the plot.  Possible values are ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  "."
}], "Text",
  CellTags->{"S6.9.1", "1.57"}],

Cell[TextData[{
  "The ",
  StyleBox["IncludeStemCounts", "MR"],
  " option specifies whether a column of counts should be included for each \
vector of real values plotted. If included, counts are displayed in the \
rightmost column in a stem\[Hyphen]and\[Hyphen]leaf plot of a single vector, \
and in the leftmost and rightmost columns for a side\[Hyphen]by\[Hyphen]side \
stem\[Hyphen]and\[Hyphen]leaf plot. Possible values are ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["False", "MR"],
  ", and ",
  StyleBox["Automatic", "MR"],
  ". With ",
  StyleBox["IncludeStemCounts\[Rule]Automatic", "MR"],
  ", counts are only included if the ",
  StyleBox["Leaves", "MR"],
  " option is set to ",
  StyleBox["None", "MR"],
  "."
}], "Text",
  CellTags->{"S6.9.1", "1.58"}],

Cell["\<\
Here is a side\[Hyphen]by\[Hyphen]side stem\[Hyphen]and\[Hyphen]leaf plot \
with stem counts, tally leaves, and nondefault stem units.\
\>", "MathCaption",
  CellTags->{"S6.9.1", "1.59"}],

Cell[CellGroupData[{

Cell["\<\
StemLeafPlot[sldata, sldata2, StemExponent->-1, Leaves->\"Tallies\", \
IncludeStemCounts->True]\
\>", "Input",
  CellLabel->"In[6]:=",
  CellTags->"S6.9.1"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[GridBox[{
                  {"\<\"Counts\"\>", "\<\"Leaves\"\>", "\<\"Stem\"\>", \
"\<\"Leaves\"\>", "\<\"Counts\"\>"},
                  {"1", "\<\"X\"\>", "\<\"10\"\>", "\<\"\"\>", "0"},
                  {"0", "\<\"\"\>", "\<\"21\"\>", "\<\"X\"\>", "1"},
                  {"0", "\<\"\"\>", "\<\"26\"\>", "\<\"X\"\>", "1"},
                  {"1", "\<\"X\"\>", "\<\"31\"\>", "\<\"\"\>", "0"},
                  {"1", "\<\"X\"\>", "\<\"32\"\>", "\<\"\"\>", "0"},
                  {"0", "\<\"\"\>", "\<\"34\"\>", "\<\"X\"\>", "1"},
                  {"0", "\<\"\"\>", "\<\"37\"\>", "\<\"X\"\>", "1"},
                  {"0", "\<\"\"\>", "\<\"38\"\>", "\<\"X\"\>", "1"},
                  {"0", "\<\"\"\>", "\<\"41\"\>", "\<\"X\"\>", "1"},
                  {"1", "\<\"X\"\>", "\<\"45\"\>", "\<\"\"\>", "0"},
                  {"1", "\<\"X\"\>", "\<\"57\"\>", "\<\"\"\>", "0"}
                  },
                ColumnSpacings->1.5,
                RowAlignments->Top,
                ColumnAlignments->{Center, Right, Center, Left, Center},
                RowLines->{True, False},
                ColumnLines->{False, True, True, False}],
              Grid]},
          {"\<\"Stem units: \\!\\(1\\/10\\)\"\>"}
          },
        RowSpacings->2,
        ColumnAlignments->{Left}],
      Grid]], "Output",
  CellLabel->"Out[6]=",
  CellTags->"S6.9.1"]
}, Open  ]],

Cell[TextData[{
  "This plot displays ",
  StyleBox["sldata", "MR"],
  " including empty stems and using the column labels as a reminder of the \
units."
}], "MathCaption",
  CellTags->{"S6.9.1", "1.60"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StemLeafPlot[sldata, 
      ColumnLabels \[Rule] {"\<(\[Times]1)\>", \*"\"\<(\[Times]\!\(10\^\(-1\)\
\))\>\""}, StemExponent \[Rule] 0, \ IncludeEmptyStems \[Rule] True, 
      IncludeStemUnits \[Rule] False]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"(\[Times]1)\"\>", \
"\<\"(\[Times]\\!\\(10\\^\\(-1\\)\\))\"\>"},
          {"\<\"1\"\>", "\<\"0\"\>"},
          {"\<\"2\"\>", "\<\"\"\>"},
          {"\<\"3\"\>", "\<\"12\"\>"},
          {"\<\"4\"\>", "\<\"6\"\>"},
          {"\<\"5\"\>", "\<\"7\"\>"}
          },
        ColumnSpacings->1.5,
        RowAlignments->Top,
        ColumnAlignments->{Right, Left, Center},
        RowLines->{True, False},
        ColumnLines->{True, False}],
      Grid]], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
  "A number of options can be applied to control the appearance of the stem\
\[Hyphen]and\[Hyphen]leaf plot. The plot is constructed as a ",
  StyleBox["GridBox", "MR"],
  ". In addition to the above options, standard ",
  StyleBox["GridBox", "MR"],
  " options can be used. If ",
  StyleBox["IncludeStemUnits\[Rule]True", "MR"],
  ", ",
  StyleBox["GridBox", "MR"],
  " options are applied to the grid of stems and leaves, but not to the label \
for stem units."
}], "Text",
  CellTags->{"S6.9.1", "1.61"}],

Cell[TextData[{
  "Here ",
  StyleBox["sldata", "MR"],
  " is displayed with a frame and nondefault column alignments."
}], "MathCaption",
  CellTags->{"S6.9.1", "1.62"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StemLeafPlot[sldata, GridFrame \[Rule] True, 
      ColumnAlignments \[Rule] {Left, Right}]\)], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[GridBox[{
                  {"\<\"Stem\"\>", "\<\"Leaves\"\>"},
                  {"\<\"1\"\>", "\<\"0\"\>"},
                  {"\<\"3\"\>", "\<\"12\"\>"},
                  {"\<\"4\"\>", "\<\"6\"\>"},
                  {"\<\"5\"\>", "\<\"7\"\>"}
                  },
                ColumnSpacings->1.5,
                RowAlignments->Top,
                ColumnAlignments->{Left, Right},
                GridFrame->True,
                RowLines->{True, False},
                ColumnLines->{True, False}],
              Grid]},
          {"\<\"Stem units: \\!\\(1\\)\"\>"}
          },
        RowSpacings->2,
        ColumnAlignments->{Left}],
      Grid]], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["StemExponent", "MR"],
  " option has additional options than can be used to further subdivide stem \
units and label those divisions."
}], "Text",
  CellTags->{"S6.9.1", "1.63"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["default value", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox["",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["\"UnitDivisions\"", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["1", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "the number of divisions for each stem unit",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["\"DivisionLabels\"", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["None", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "a list of labels appended to stem numbers within each unit \
division",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S6.9.1"],

Cell[TextData[{
  "Suboptions for ",
  StyleBox["StemExponent", "MR",
    GridBoxOptions->{RowSpacings->0.4,
    RowLines->False}],
  ". "
}], "Caption",
  CellTags->"S6.9.1"],

Cell[TextData[{
  "The ",
  StyleBox["\"UnitDivisions\"", "MR"],
  " option specifies the number of stems a base unit should be divided into. \
The value of ",
  StyleBox["\"UnitDivisions\"", "MR"],
  " must be a positive integer. "
}], "Text",
  CellTags->{"S6.9.1", "1.64"}],

Cell[TextData[{
  "Alternate labeling of subdivisions can be specified via the ",
  StyleBox["\"DivisionLabels\"", "MR"],
  " option. The value of ",
  StyleBox["\"DivisionLabels\"", "MR"],
  " must be ",
  StyleBox["None", "MR"],
  " or a list of a length equal to the ",
  StyleBox["\"UnitDivisions\"", "MR"],
  " value. If the ",
  StyleBox["\"DivisionLabels\"", "MR"],
  " value is a list, the values are appended to each numeric stem in the \
plot."
}], "Text",
  CellTags->{"S6.9.1", "1.65"}],

Cell[TextData[{
  "Here, each base unit is broken into two stems and the stems are labeled ",
  StyleBox["\"L\"", "MR"],
  " and ",
  StyleBox["\"H\"", "MR"],
  ", for low and high."
}], "MathCaption",
  CellTags->{"S6.9.1", "1.66"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(sldata3 = {1.34, 1.6, 2.4, 2.8, 1.7, 3.1, 1.63, 0.8};\)\), "\n", 
    \(StemLeafPlot[sldata3, 
      StemExponent \[Rule] {Automatic, "\<UnitDivisions\>" \[Rule] 
            2, "\<DivisionLabels\>" \[Rule] {"\<L\>", "\<H\>"}}]\)}], "Input",\

  CellLabel->"In[9]:="],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[GridBox[{
                  {"\<\"Stem\"\>", "\<\"Leaves\"\>"},
                  {"\<\"0H\"\>", "\<\"8\"\>"},
                  {"\<\"1L\"\>", "\<\"3\"\>"},
                  {"\<\"1H\"\>", "\<\"667\"\>"},
                  {"\<\"2L\"\>", "\<\"4\"\>"},
                  {"\<\"2H\"\>", "\<\"8\"\>"},
                  {"\<\"3L\"\>", "\<\"1\"\>"}
                  },
                ColumnSpacings->1.5,
                RowAlignments->Top,
                ColumnAlignments->{Right, Left, Center},
                RowLines->{True, False},
                ColumnLines->{True, False}],
              Grid]},
          {"\<\"Stem units: \\!\\(1\\)\"\>"}
          },
        RowSpacings->2,
        ColumnAlignments->{Left}],
      Grid]], "Output",
  CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
  "A number of options to the ",
  StyleBox["Leaves", "MR"],
  " option can be used to modify how leaves are computed and displayed. "
}], "Text",
  CellTags->{"S6.9.1", "1.67"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["default value", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox["",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["\"LeafDigits\"", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["1", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "the number of digits to use for each leaf",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["\"LeafSpacing\"", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["Automatic", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "the number of spaces between displayed leaves",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["\"LeafWrapping\"", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["None", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "specifies when leaves should be wrapped to a new line",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["\"RoundLeaves\"", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["True", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "whether data entries should be rounded before determining \
leaves",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S6.9.1"],

Cell[TextData[{
  "Suboptions for all ",
  StyleBox["Leaves", "MR",
    GridBoxOptions->{RowSpacings->0.4,
    RowLines->False}],
  " option values. "
}], "Caption",
  CellTags->"S6.9.1"],

Cell[TextData[{
  "The ",
  StyleBox["\"LeafDigits\"", "MR"],
  " option specifies the number of digits beyond the stem to use in computing \
leaves. This is also the number of digits displayed for each leaf if leaves \
are displayed as ",
  StyleBox["\"Digits\"", "MR"],
  ". The value must be a positive integer. "
}], "Text",
  CellTags->{"S6.9.1", "1.68"}],

Cell[TextData[{
  StyleBox["\"LeafSpacing\"", "MR"],
  " indicates the number of spaces to display between leaves. ",
  StyleBox["\"LeafSpacing\"", "MR"],
  " can be set to a nonnegative integer or ",
  StyleBox["Automatic", "MR"],
  ". With ",
  StyleBox["\"LeafSpacing\"\[Rule]Automatic", "MR"],
  ", zero spaces are used when ",
  StyleBox["\"LeafDigits\"\[Rule]1", "MR"],
  ", and one space is used otherwise."
}], "Text",
  CellTags->{"S6.9.1", "1.69"}],

Cell[TextData[{
  StyleBox["\"LeafWrapping\"", "MR"],
  " specifies the number of leaves after which leaves should be wrapped to a \
new line. ",
  StyleBox["\"LeafWrapping\"", "MR"],
  " can be any positive integer or ",
  StyleBox["None", "MR"],
  ", with ",
  StyleBox["None", "MR"],
  " indicating that leaves should not be wrapped to new lines."
}], "Text",
  CellTags->{"S6.9.1", "1.70"}],

Cell[TextData[{
  StyleBox["\"RoundLeaves\"", "MR"],
  " specifies whether or not values should be rounded to the last leaf digit \
before computing leaves."
}], "Text",
  CellTags->{"S6.9.1", "1.71"}],

Cell["The following generates 100 numbers between 0 and 5.", "MathCaption",
  CellTags->{"S6.9.1", "1.72"}],

Cell[BoxData[
    \(\(sldata4 = 
        Block[{$RandomState}, 
          SeedRandom[1]; \[IndentingNewLine]Table[
            Random[Real, {0, 5}], {100}]];\)\)], "Input",
  CellLabel->"In[11]:="],

Cell["\<\
This displays the data using two digits for leaves and including two spaces \
between leaves.\
\>", "MathCaption",
  CellTags->{"S6.9.1", "1.73"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StemLeafPlot[sldata4, 
      Leaves \[Rule] {"\<Digits\>", "\<LeafDigits\>" \[Rule] 
            2, "\<LeafSpacing\>" \[Rule] 2}]\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[GridBox[{
                  {"\<\"Stem\"\>", "\<\"Leaves\"\>"},
                  {"\<\"0\"\>", "\<\"06  08  10  10  15  28  30  30  33  36  \
46  62  62  63  64  77  80  83  87  93  94  97  97\"\>"},
                  {"\<\"1\"\>", "\<\"04  04  04  06  14  20  24  27  29  30  \
34  38  40  60  67  82  89\"\>"},
                  {"\<\"2\"\>", "\<\"08  13  15  16  16  46  64  80  81  88  \
90  92  98\"\>"},
                  {"\<\"3\"\>", "\<\"00  02  02  14  16  19  24  29  34  64  \
68  70  76  78  79  83  87  91  92\"\>"},
                  {"\<\"4\"\>", "\<\"02  02  04  08  09  11  15  15  16  18  \
27  27  29  36  38  49  60  67  67  69  71  73  73  74  75  84  84  85\"\>"}
                  },
                ColumnSpacings->1.5,
                RowAlignments->Top,
                ColumnAlignments->{Right, Left, Center},
                RowLines->{True, False},
                ColumnLines->{True, False}],
              Grid]},
          {"\<\"Stem units: \\!\\(1\\)\"\>"}
          },
        RowSpacings->2,
        ColumnAlignments->{Left}],
      Grid]], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell["\<\
Wrapping leaves to a new line can be useful if there is a large number of \
leaves for one or more stems, as is the case with this data set.\
\>", "Text",
  CellTags->{"S6.9.1", "1.74"}],

Cell["\<\
Here the leaves are wrapped to a new line after 12 leaves, and row lines are \
inserted.\
\>", "MathCaption",
  CellTags->{"S6.9.1", "1.75"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StemLeafPlot[sldata4, 
      Leaves \[Rule] {"\<Digits\>", "\<LeafDigits\>" \[Rule] 
            2, "\<LeafWrapping\>" \[Rule] 12}, 
      RowLines \[Rule] True]\)], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[GridBox[{
                  {"\<\"Stem\"\>", "\<\"Leaves\"\>"},
                  {"\<\"0\"\>", 
                    TagBox[GridBox[{
                          {"\<\"06 08 10 10 15 28 30 30 33 36 46 62\"\>"},
                          {"\<\"62 63 64 77 80 83 87 93 94 97 97\"\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid]},
                  {"\<\"1\"\>", 
                    TagBox[GridBox[{
                          {"\<\"04 04 04 06 14 20 24 27 29 30 34 38\"\>"},
                          {"\<\"40 60 67 82 89\"\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid]},
                  {"\<\"2\"\>", 
                    TagBox[GridBox[{
                          {"\<\"08 13 15 16 16 46 64 80 81 88 90 92\"\>"},
                          {"\<\"98\"\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid]},
                  {"\<\"3\"\>", 
                    TagBox[GridBox[{
                          {"\<\"00 02 02 14 16 19 24 29 34 64 68 70\"\>"},
                          {"\<\"76 78 79 83 87 91 92\"\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid]},
                  {"\<\"4\"\>", 
                    TagBox[GridBox[{
                          {"\<\"02 02 04 08 09 11 15 15 16 18 27 27\"\>"},
                          {"\<\"29 36 38 49 60 67 67 69 71 73 73 74\"\>"},
                          {"\<\"75 84 84 85\"\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid]}
                  },
                ColumnSpacings->1.5,
                RowAlignments->Top,
                ColumnAlignments->{Right, Left, Center},
                RowLines->True,
                ColumnLines->{True, False}],
              Grid]},
          {"\<\"Stem units: \\!\\(1\\)\"\>"}
          },
        RowSpacings->2,
        ColumnAlignments->{Left}],
      Grid]], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell[TextData[{
  "If leaves are displayed as ",
  StyleBox["\"Tallies\"", "MR"],
  ", the symbol used as tally markers can also be specified."
}], "Text",
  CellTags->{"S6.9.1", "1.76"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["default value", "TI",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox["",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]},
          {Cell[TextData[{
              StyleBox["\"TallySymbol\"", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[{
              StyleBox["\"X\"", "MR",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->False}],
              StyleBox[" ",
                GridBoxOptions->{RowSpacings->0.4,
                RowLines->{True, False}}]
            }],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}], Cell[TextData[StyleBox[
            "the symbol to use for each leaf",
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]],
              GridBoxOptions->{RowSpacings->0.4,
              RowLines->{True, False}}]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S6.9.1"],

Cell[TextData[{
  "Suboption for \"",
  StyleBox["Tallies\"", "MR"],
  " leaves. "
}], "Caption",
  CellTags->"S6.9.1"],

Cell[TextData[{
  "The ",
  StyleBox["\"TallySymbol\"", "MR"],
  " option can be any string or symbol."
}], "Text",
  CellTags->{"S6.9.1", "1.77"}],

Cell[TextData[{
  "Here the leaves for ",
  StyleBox["sldata4", "MR"],
  " are represented by checkmarks."
}], "MathCaption",
  CellTags->{"S6.9.1", "1.78"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StemLeafPlot[sldata4, 
      Leaves \[Rule] {"\<Tallies\>", "\<TallySymbol\>" \[Rule] \[Checkmark]}]\
\)], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[GridBox[{
                  {"\<\"Stem\"\>", "\<\"Leaves\"\>"},
                  {"\<\"0\"\>", "\<\"\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\"\>"}\
,
                  {"\<\"1\"\>", "\<\"\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\"\>"},
                  {"\<\"2\"\>", "\<\"\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\"\>"},
                  {"\<\"3\"\>", "\<\"\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\"\>"},
                  {"\<\"4\"\>", "\<\"\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\[Checkmark]\
\[Checkmark]\"\>"}
                  },
                ColumnSpacings->1.5,
                RowAlignments->Top,
                ColumnAlignments->{Right, Left, Center},
                RowLines->{True, False},
                ColumnLines->{True, False}],
              Grid]},
          {"\<\"Stem units: \\!\\(1\\)\"\>"}
          },
        RowSpacings->2,
        ColumnAlignments->{Left}],
      Grid]], "Output",
  CellLabel->"Out[14]="]
}, Open  ]],

Cell["\<\
From the previous display it is clear which stems contain more values than \
others. Including other features, such as counts and leaf wrapping, can be \
useful in determining the actual magnitudes of the leaf counts for each stem.\
\
\>", "Text",
  CellTags->{"S6.9.1", "1.79"}],

Cell["\<\
Wrapping leaves and including counts can make the plot easier to \
comprehend.\
\>", "MathCaption",
  CellTags->{"S6.9.1", "1.80"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StemLeafPlot[sldata4, 
      Leaves \[Rule] {"\<Tallies\>", "\<TallySymbol\>" \[Rule] \
\\[FilledCircle], "\<LeafWrapping\>" \[Rule] 10}, 
      IncludeStemCounts \[Rule] True, RowLines \[Rule] True]\)], "Input",
  CellLabel->"In[15]:="],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[GridBox[{
                  {"\<\"Stem\"\>", "\<\"Leaves\"\>", "\<\"Counts\"\>"},
                  {"\<\"0\"\>", 
                    TagBox[GridBox[{
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\"\>"},
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\"\>"},
                          {"\<\"\[FilledCircle]\"\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid], "21"},
                  {"\<\"1\"\>", 
                    TagBox[GridBox[{
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\"\>"},
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\"\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid], "19"},
                  {"\<\"2\"\>", 
                    TagBox[GridBox[{
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\"\>"},
                          {"\<\"\[FilledCircle]\[FilledCircle]\"\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid], "12"},
                  {"\<\"3\"\>", 
                    TagBox[GridBox[{
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\"\>"},
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\"\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid], "20"},
                  {"\<\"4\"\>", 
                    TagBox[GridBox[{
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\"\>"},
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\"\>"},
                          {"\<\"\[FilledCircle]\[FilledCircle]\[FilledCircle]\
\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\[FilledCircle]\"\
\>"}
                          },
                        RowAlignments->Top,
                        ColumnAlignments->{Left}],
                      Grid], "28"}
                  },
                ColumnSpacings->1.5,
                RowAlignments->Top,
                ColumnAlignments->{Right, Left, Center},
                RowLines->True,
                ColumnLines->{True, False}],
              Grid]},
          {"\<\"Stem units: \\!\\(1\\)\"\>"}
          },
        RowSpacings->2,
        ColumnAlignments->{Left}],
      Grid]], "Output",
  CellLabel->"Out[15]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{494, 578},
WindowMargins->{{Automatic, 172}, {Automatic, 4}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.9.1"->{
    Cell[1776, 53, 141, 6, 40, "Subsection",
      CellTags->{"S6.9.1", "1.1"}],
    Cell[1920, 61, 465, 8, 93, "Text",
      CellTags->{"S6.9.1", "1.2"}],
    Cell[2388, 71, 4883, 118, 172, "DefinitionBox",
      CellTags->"S6.9.1"],
    Cell[7274, 191, 87, 3, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[7364, 196, 80, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.3"}],
    Cell[7447, 199, 91, 2, 31, "Input",
      CellTags->"S6.9.1"],
    Cell[7563, 205, 93, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.4"}],
    Cell[7659, 208, 662, 11, 127, "Text",
      CellTags->{"S6.9.1", "1.5"}],
    Cell[8324, 221, 2802, 84, 110, "DefinitionBox",
      CellTags->"S6.9.1"],
    Cell[11129, 307, 79, 1, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[11211, 310, 85, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.6"}],
    Cell[11299, 313, 133, 5, 51, "Input",
      CellTags->"S6.9.1"],
    Cell[11435, 320, 130, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.7"}],
    Cell[11590, 327, 81, 2, 31, "Input",
      CellTags->"S6.9.1"],
    Cell[11674, 331, 20929, 400, 186, 2025, 162, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[32606, 733, 179, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[32800, 742, 127, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.8"}],
    Cell[32952, 749, 82, 2, 31, "Input",
      CellTags->"S6.9.1"],
    Cell[33037, 753, 30982, 591, 186, 3184, 244, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[64022, 1346, 179, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[64216, 1355, 8292, 243, 322, "DefinitionBox3Col",
      CellTags->"S6.9.1"],
    Cell[72511, 1600, 109, 5, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[72623, 1607, 237, 6, 42, "Text",
      CellTags->{"S6.9.1", "1.9"}],
    Cell[72863, 1615, 348, 7, 76, "Text",
      CellTags->{"S6.9.1", "1.10"}],
    Cell[73214, 1624, 1290, 29, 229, "Text",
      CellTags->{"S6.9.1", "1.11"}],
    Cell[74507, 1655, 243, 5, 75, "MathCaption",
      CellTags->{"S6.9.1", "1.12"}],
    Cell[74775, 1664, 221, 8, 131, "Input",
      CellTags->"S6.9.1"],
    Cell[74999, 1674, 19292, 425, 186, 3278, 223, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[94294, 2101, 179, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[94488, 2110, 364, 10, 59, "Text",
      CellTags->{"S6.9.1", "1.13"}],
    Cell[94855, 2122, 405, 9, 76, "Text",
      CellTags->{"S6.9.1", "1.14"}],
    Cell[95263, 2133, 442, 8, 93, "Text",
      CellTags->{"S6.9.1", "1.15"}],
    Cell[95708, 2143, 758, 19, 127, "Text",
      CellTags->{"S6.9.1", "1.16"}],
    Cell[96469, 2164, 186, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.17"}],
    Cell[96680, 2172, 271, 10, 151, "Input",
      CellTags->"S6.9.1"],
    Cell[96954, 2184, 27150, 705, 186, 8810, 474, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[124107, 2891, 179, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[124335, 2903, 68, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.18"}],
    Cell[124406, 2906, 244, 5, 59, "Text",
      CellTags->{"S6.9.1", "1.19"}],
    Cell[124653, 2913, 3078, 93, 126, "DefinitionBox",
      CellTags->"S6.9.1"],
    Cell[127734, 3008, 54, 1, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[127791, 3011, 320, 7, 59, "Text",
      CellTags->{"S6.9.1", "1.20"}],
    Cell[128114, 3020, 148, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.21"}],
    Cell[128287, 3028, 129, 6, 71, "Input",
      CellTags->"S6.9.1"],
    Cell[128419, 3036, 28193, 708, 186, 9606, 474, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[156615, 3746, 179, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[156809, 3755, 361, 12, 59, "Text",
      CellTags->{"S6.9.1", "1.22"}],
    Cell[157173, 3769, 126, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.23"}],
    Cell[157324, 3776, 157, 6, 91, "Input",
      CellTags->"S6.9.1"],
    Cell[157484, 3784, 28354, 663, 186, 8539, 414, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[185841, 4449, 177, 5, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[186033, 4457, 10712, 299, 304, "DefinitionBox3Col",
      CellTags->"S6.9.1"],
    Cell[196748, 4758, 105, 5, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[196856, 4765, 268, 7, 42, "Text",
      CellTags->{"S6.9.1", "1.24"}],
    Cell[197127, 4774, 648, 18, 93, "Text",
      CellTags->{"S6.9.1", "1.25"}],
    Cell[197778, 4794, 258, 8, 42, "Text",
      CellTags->{"S6.9.1", "1.26"}],
    Cell[198039, 4804, 133, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.27"}],
    Cell[198197, 4811, 302, 12, 191, "Input",
      CellTags->"S6.9.1"],
    Cell[198502, 4825, 14974, 442, 186, 4273, 306, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[213479, 5269, 180, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[213708, 5281, 88, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.28"}],
    Cell[213799, 5284, 341, 6, 76, "Text",
      CellTags->{"S6.9.1", "1.29"}],
    Cell[214143, 5292, 1436, 43, 66, "DefinitionBox",
      CellTags->"S6.9.1"],
    Cell[215582, 5337, 73, 1, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[215658, 5340, 476, 8, 93, "Text",
      CellTags->{"S6.9.1", "1.30"}],
    Cell[216137, 5350, 180, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.31"}],
    Cell[216342, 5358, 139, 7, 91, "Input",
      CellTags->"S6.9.1"],
    Cell[216484, 5367, 68609, 1891, 186, 53817, 1704, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[285096, 7260, 180, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[285291, 7269, 5019, 147, 176, "DefinitionBox3Col",
      CellTags->"S6.9.1"],
    Cell[290313, 7418, 107, 5, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[290423, 7425, 890, 22, 144, "Text",
      CellTags->{"S6.9.1", "1.32"}],
    Cell[291316, 7449, 133, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.33"}],
    Cell[291474, 7456, 227, 7, 111, "Input",
      CellTags->"S6.9.1"],
    Cell[291704, 7465, 22203, 696, 186, 7745, 513, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[313910, 8163, 180, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[314139, 8175, 78, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.34"}],
    Cell[314220, 8178, 302, 6, 59, "Text",
      CellTags->{"S6.9.1", "1.35"}],
    Cell[314525, 8186, 916, 28, 66, "DefinitionBox",
      CellTags->"S6.9.1"],
    Cell[315444, 8216, 62, 1, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[315509, 8219, 349, 7, 76, "Text",
      CellTags->{"S6.9.1", "1.36"}],
    Cell[315861, 8228, 86, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.37"}],
    Cell[315950, 8231, 115, 2, 31, "Input",
      CellTags->"S6.9.1"],
    Cell[316068, 8235, 103, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.38"}],
    Cell[316196, 8240, 87, 2, 31, "Input",
      CellTags->"S6.9.1"],
    Cell[316286, 8244, 42673, 1058, 186, 12123, 677, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[358962, 9304, 180, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[359157, 9313, 6169, 149, 158, "DefinitionBox3Col",
      CellTags->"S6.9.1"],
    Cell[365329, 9464, 122, 5, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[365454, 9471, 493, 15, 76, "Text",
      CellTags->{"S6.9.1", "1.39"}],
    Cell[365950, 9488, 656, 14, 127, "Text",
      CellTags->{"S6.9.1", "1.40"}],
    Cell[366609, 9504, 270, 7, 59, "Text",
      CellTags->{"S6.9.1", "1.41"}],
    Cell[366882, 9513, 1002, 24, 161, "Text",
      CellTags->{"S6.9.1", "1.42"}],
    Cell[367887, 9539, 149, 5, 25, "Text",
      CellTags->{"S6.9.1", "1.43"}],
    Cell[368039, 9546, 116, 2, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.44"}],
    Cell[368180, 9552, 316, 10, 171, "Input",
      CellTags->"S6.9.1"],
    Cell[368499, 9564, 54111, 1312, 186, 17958, 861, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.9.1"],
    Cell[422613, 10878, 180, 6, 27, "Output",
      CellTags->"S6.9.1"],
    Cell[422842, 10890, 92, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.45"}],
    Cell[422937, 10893, 963, 14, 195, "Text",
      CellTags->{"S6.9.1", "1.46"}],
    Cell[423903, 10909, 3062, 74, 88, "DefinitionBox",
      CellTags->"S6.9.1"],
    Cell[426968, 10985, 77, 1, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[427048, 10988, 88, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.47"}],
    Cell[427139, 10991, 97, 2, 31, "Input",
      CellTags->"S6.9.1"],
    Cell[427239, 10995, 127, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.48"}],
    Cell[427391, 11002, 83, 2, 31, "Input",
      CellTags->"S6.9.1"],
    Cell[427477, 11006, 759, 22, 109, "Output",
      CellTags->"S6.9.1"],
    Cell[428251, 11031, 266, 5, 59, "Text",
      CellTags->{"S6.9.1", "1.49"}],
    Cell[428520, 11038, 95, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.50"}],
    Cell[428618, 11041, 99, 2, 31, "Input",
      CellTags->"S6.9.1"],
    Cell[428720, 11045, 168, 4, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.51"}],
    Cell[428913, 11053, 92, 2, 31, "Input",
      CellTags->"S6.9.1"],
    Cell[429008, 11057, 879, 23, 125, "Output",
      CellTags->"S6.9.1"],
    Cell[429902, 11083, 161, 4, 42, "Text",
      CellTags->{"S6.9.1", "1.52"}],
    Cell[430066, 11089, 7303, 173, 256, "DefinitionBox3Col",
      CellTags->"S6.9.1"],
    Cell[437372, 11264, 172, 7, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[437547, 11273, 460, 15, 59, "Text",
      CellTags->{"S6.9.1", "1.53"}],
    Cell[438010, 11290, 589, 18, 93, "Text",
      CellTags->{"S6.9.1", "1.54"}],
    Cell[438602, 11310, 602, 19, 93, "Text",
      CellTags->{"S6.9.1", "1.55"}],
    Cell[439207, 11331, 323, 10, 59, "Text",
      CellTags->{"S6.9.1", "1.56"}],
    Cell[439533, 11343, 300, 10, 42, "Text",
      CellTags->{"S6.9.1", "1.57"}],
    Cell[439836, 11355, 773, 21, 110, "Text",
      CellTags->{"S6.9.1", "1.58"}],
    Cell[440612, 11378, 197, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.59"}],
    Cell[440834, 11386, 166, 5, 51, "Input",
      CellTags->"S6.9.1"],
    Cell[441003, 11393, 1423, 30, 231, "Output",
      CellTags->"S6.9.1"],
    Cell[442441, 11426, 204, 6, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.60"}],
    Cell[443494, 11462, 523, 13, 93, "Text",
      CellTags->{"S6.9.1", "1.61"}],
    Cell[444020, 11477, 170, 5, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.62"}],
    Cell[445143, 11516, 216, 6, 42, "Text",
      CellTags->{"S6.9.1", "1.63"}],
    Cell[445362, 11524, 3242, 78, 130, "DefinitionBox3Col",
      CellTags->"S6.9.1"],
    Cell[448607, 11604, 175, 7, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[448785, 11613, 276, 8, 59, "Text",
      CellTags->{"S6.9.1", "1.64"}],
    Cell[449064, 11623, 498, 14, 76, "Text",
      CellTags->{"S6.9.1", "1.65"}],
    Cell[449565, 11639, 233, 7, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.66"}],
    Cell[450968, 11684, 194, 5, 42, "Text",
      CellTags->{"S6.9.1", "1.67"}],
    Cell[451165, 11691, 5288, 126, 212, "DefinitionBox3Col",
      CellTags->"S6.9.1"],
    Cell[456456, 11819, 187, 7, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[456646, 11828, 360, 9, 59, "Text",
      CellTags->{"S6.9.1", "1.68"}],
    Cell[457009, 11839, 458, 12, 76, "Text",
      CellTags->{"S6.9.1", "1.69"}],
    Cell[457470, 11853, 394, 11, 59, "Text",
      CellTags->{"S6.9.1", "1.70"}],
    Cell[457867, 11866, 201, 5, 42, "Text",
      CellTags->{"S6.9.1", "1.71"}],
    Cell[458071, 11873, 107, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.72"}],
    Cell[458381, 11883, 156, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.73"}],
    Cell[459945, 11927, 196, 4, 42, "Text",
      CellTags->{"S6.9.1", "1.74"}],
    Cell[460144, 11933, 151, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.75"}],
    Cell[462945, 12009, 187, 5, 42, "Text",
      CellTags->{"S6.9.1", "1.76"}],
    Cell[463135, 12016, 2185, 53, 70, "DefinitionBox3Col",
      CellTags->"S6.9.1"],
    Cell[465323, 12071, 119, 5, 17, "Caption",
      CellTags->"S6.9.1"],
    Cell[465445, 12078, 147, 5, 25, "Text",
      CellTags->{"S6.9.1", "1.77"}],
    Cell[465595, 12085, 157, 5, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.78"}],
    Cell[467967, 12142, 289, 6, 59, "Text",
      CellTags->{"S6.9.1", "1.79"}],
    Cell[468259, 12150, 141, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.80"}]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 40, "Subsection",
      CellTags->{"S6.9.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 465, 8, 93, "Text",
      CellTags->{"S6.9.1", "1.2"}]},
  "1.3"->{
    Cell[7364, 196, 80, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.3"}]},
  "1.4"->{
    Cell[7563, 205, 93, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.4"}]},
  "1.5"->{
    Cell[7659, 208, 662, 11, 127, "Text",
      CellTags->{"S6.9.1", "1.5"}]},
  "1.6"->{
    Cell[11211, 310, 85, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.6"}]},
  "1.7"->{
    Cell[11435, 320, 130, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.7"}]},
  "1.8"->{
    Cell[32800, 742, 127, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.8"}]},
  "1.9"->{
    Cell[72623, 1607, 237, 6, 42, "Text",
      CellTags->{"S6.9.1", "1.9"}]},
  "1.10"->{
    Cell[72863, 1615, 348, 7, 76, "Text",
      CellTags->{"S6.9.1", "1.10"}]},
  "1.11"->{
    Cell[73214, 1624, 1290, 29, 229, "Text",
      CellTags->{"S6.9.1", "1.11"}]},
  "1.12"->{
    Cell[74507, 1655, 243, 5, 75, "MathCaption",
      CellTags->{"S6.9.1", "1.12"}]},
  "1.13"->{
    Cell[94488, 2110, 364, 10, 59, "Text",
      CellTags->{"S6.9.1", "1.13"}]},
  "1.14"->{
    Cell[94855, 2122, 405, 9, 76, "Text",
      CellTags->{"S6.9.1", "1.14"}]},
  "1.15"->{
    Cell[95263, 2133, 442, 8, 93, "Text",
      CellTags->{"S6.9.1", "1.15"}]},
  "1.16"->{
    Cell[95708, 2143, 758, 19, 127, "Text",
      CellTags->{"S6.9.1", "1.16"}]},
  "1.17"->{
    Cell[96469, 2164, 186, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.17"}]},
  "1.18"->{
    Cell[124335, 2903, 68, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.18"}]},
  "1.19"->{
    Cell[124406, 2906, 244, 5, 59, "Text",
      CellTags->{"S6.9.1", "1.19"}]},
  "1.20"->{
    Cell[127791, 3011, 320, 7, 59, "Text",
      CellTags->{"S6.9.1", "1.20"}]},
  "1.21"->{
    Cell[128114, 3020, 148, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.21"}]},
  "1.22"->{
    Cell[156809, 3755, 361, 12, 59, "Text",
      CellTags->{"S6.9.1", "1.22"}]},
  "1.23"->{
    Cell[157173, 3769, 126, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.23"}]},
  "1.24"->{
    Cell[196856, 4765, 268, 7, 42, "Text",
      CellTags->{"S6.9.1", "1.24"}]},
  "1.25"->{
    Cell[197127, 4774, 648, 18, 93, "Text",
      CellTags->{"S6.9.1", "1.25"}]},
  "1.26"->{
    Cell[197778, 4794, 258, 8, 42, "Text",
      CellTags->{"S6.9.1", "1.26"}]},
  "1.27"->{
    Cell[198039, 4804, 133, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.27"}]},
  "1.28"->{
    Cell[213708, 5281, 88, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.28"}]},
  "1.29"->{
    Cell[213799, 5284, 341, 6, 76, "Text",
      CellTags->{"S6.9.1", "1.29"}]},
  "1.30"->{
    Cell[215658, 5340, 476, 8, 93, "Text",
      CellTags->{"S6.9.1", "1.30"}]},
  "1.31"->{
    Cell[216137, 5350, 180, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.31"}]},
  "1.32"->{
    Cell[290423, 7425, 890, 22, 144, "Text",
      CellTags->{"S6.9.1", "1.32"}]},
  "1.33"->{
    Cell[291316, 7449, 133, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.33"}]},
  "1.34"->{
    Cell[314139, 8175, 78, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.34"}]},
  "1.35"->{
    Cell[314220, 8178, 302, 6, 59, "Text",
      CellTags->{"S6.9.1", "1.35"}]},
  "1.36"->{
    Cell[315509, 8219, 349, 7, 76, "Text",
      CellTags->{"S6.9.1", "1.36"}]},
  "1.37"->{
    Cell[315861, 8228, 86, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.37"}]},
  "1.38"->{
    Cell[316068, 8235, 103, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.38"}]},
  "1.39"->{
    Cell[365454, 9471, 493, 15, 76, "Text",
      CellTags->{"S6.9.1", "1.39"}]},
  "1.40"->{
    Cell[365950, 9488, 656, 14, 127, "Text",
      CellTags->{"S6.9.1", "1.40"}]},
  "1.41"->{
    Cell[366609, 9504, 270, 7, 59, "Text",
      CellTags->{"S6.9.1", "1.41"}]},
  "1.42"->{
    Cell[366882, 9513, 1002, 24, 161, "Text",
      CellTags->{"S6.9.1", "1.42"}]},
  "1.43"->{
    Cell[367887, 9539, 149, 5, 25, "Text",
      CellTags->{"S6.9.1", "1.43"}]},
  "1.44"->{
    Cell[368039, 9546, 116, 2, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.44"}]},
  "1.45"->{
    Cell[422842, 10890, 92, 1, 35, "Subsubsection",
      CellTags->{"S6.9.1", "1.45"}]},
  "1.46"->{
    Cell[422937, 10893, 963, 14, 195, "Text",
      CellTags->{"S6.9.1", "1.46"}]},
  "1.47"->{
    Cell[427048, 10988, 88, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.47"}]},
  "1.48"->{
    Cell[427239, 10995, 127, 3, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.48"}]},
  "1.49"->{
    Cell[428251, 11031, 266, 5, 59, "Text",
      CellTags->{"S6.9.1", "1.49"}]},
  "1.50"->{
    Cell[428520, 11038, 95, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.50"}]},
  "1.51"->{
    Cell[428720, 11045, 168, 4, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.51"}]},
  "1.52"->{
    Cell[429902, 11083, 161, 4, 42, "Text",
      CellTags->{"S6.9.1", "1.52"}]},
  "1.53"->{
    Cell[437547, 11273, 460, 15, 59, "Text",
      CellTags->{"S6.9.1", "1.53"}]},
  "1.54"->{
    Cell[438010, 11290, 589, 18, 93, "Text",
      CellTags->{"S6.9.1", "1.54"}]},
  "1.55"->{
    Cell[438602, 11310, 602, 19, 93, "Text",
      CellTags->{"S6.9.1", "1.55"}]},
  "1.56"->{
    Cell[439207, 11331, 323, 10, 59, "Text",
      CellTags->{"S6.9.1", "1.56"}]},
  "1.57"->{
    Cell[439533, 11343, 300, 10, 42, "Text",
      CellTags->{"S6.9.1", "1.57"}]},
  "1.58"->{
    Cell[439836, 11355, 773, 21, 110, "Text",
      CellTags->{"S6.9.1", "1.58"}]},
  "1.59"->{
    Cell[440612, 11378, 197, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.59"}]},
  "1.60"->{
    Cell[442441, 11426, 204, 6, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.60"}]},
  "1.61"->{
    Cell[443494, 11462, 523, 13, 93, "Text",
      CellTags->{"S6.9.1", "1.61"}]},
  "1.62"->{
    Cell[444020, 11477, 170, 5, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.62"}]},
  "1.63"->{
    Cell[445143, 11516, 216, 6, 42, "Text",
      CellTags->{"S6.9.1", "1.63"}]},
  "1.64"->{
    Cell[448785, 11613, 276, 8, 59, "Text",
      CellTags->{"S6.9.1", "1.64"}]},
  "1.65"->{
    Cell[449064, 11623, 498, 14, 76, "Text",
      CellTags->{"S6.9.1", "1.65"}]},
  "1.66"->{
    Cell[449565, 11639, 233, 7, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.66"}]},
  "1.67"->{
    Cell[450968, 11684, 194, 5, 42, "Text",
      CellTags->{"S6.9.1", "1.67"}]},
  "1.68"->{
    Cell[456646, 11828, 360, 9, 59, "Text",
      CellTags->{"S6.9.1", "1.68"}]},
  "1.69"->{
    Cell[457009, 11839, 458, 12, 76, "Text",
      CellTags->{"S6.9.1", "1.69"}]},
  "1.70"->{
    Cell[457470, 11853, 394, 11, 59, "Text",
      CellTags->{"S6.9.1", "1.70"}]},
  "1.71"->{
    Cell[457867, 11866, 201, 5, 42, "Text",
      CellTags->{"S6.9.1", "1.71"}]},
  "1.72"->{
    Cell[458071, 11873, 107, 1, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.72"}]},
  "1.73"->{
    Cell[458381, 11883, 156, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.73"}]},
  "1.74"->{
    Cell[459945, 11927, 196, 4, 42, "Text",
      CellTags->{"S6.9.1", "1.74"}]},
  "1.75"->{
    Cell[460144, 11933, 151, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.75"}]},
  "1.76"->{
    Cell[462945, 12009, 187, 5, 42, "Text",
      CellTags->{"S6.9.1", "1.76"}]},
  "1.77"->{
    Cell[465445, 12078, 147, 5, 25, "Text",
      CellTags->{"S6.9.1", "1.77"}]},
  "1.78"->{
    Cell[465595, 12085, 157, 5, 41, "MathCaption",
      CellTags->{"S6.9.1", "1.78"}]},
  "1.79"->{
    Cell[467967, 12142, 289, 6, 59, "Text",
      CellTags->{"S6.9.1", "1.79"}]},
  "1.80"->{
    Cell[468259, 12150, 141, 4, 58, "MathCaption",
      CellTags->{"S6.9.1", "1.80"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.9.1", 473118, 12266},
  {"1.1", 485715, 12582},
  {"1.2", 485808, 12585},
  {"1.3", 485895, 12588},
  {"1.4", 485989, 12591},
  {"1.5", 486085, 12594},
  {"1.6", 486175, 12597},
  {"1.7", 486270, 12600},
  {"1.8", 486366, 12603},
  {"1.9", 486462, 12606},
  {"1.10", 486553, 12609},
  {"1.11", 486645, 12612},
  {"1.12", 486740, 12615},
  {"1.13", 486839, 12618},
  {"1.14", 486932, 12621},
  {"1.15", 487024, 12624},
  {"1.16", 487116, 12627},
  {"1.17", 487210, 12630},
  {"1.18", 487309, 12633},
  {"1.19", 487410, 12636},
  {"1.20", 487503, 12639},
  {"1.21", 487596, 12642},
  {"1.22", 487696, 12645},
  {"1.23", 487790, 12648},
  {"1.24", 487890, 12651},
  {"1.25", 487983, 12654},
  {"1.26", 488077, 12657},
  {"1.27", 488170, 12660},
  {"1.28", 488270, 12663},
  {"1.29", 488371, 12666},
  {"1.30", 488464, 12669},
  {"1.31", 488557, 12672},
  {"1.32", 488657, 12675},
  {"1.33", 488752, 12678},
  {"1.34", 488852, 12681},
  {"1.35", 488953, 12684},
  {"1.36", 489046, 12687},
  {"1.37", 489139, 12690},
  {"1.38", 489238, 12693},
  {"1.39", 489338, 12696},
  {"1.40", 489432, 12699},
  {"1.41", 489527, 12702},
  {"1.42", 489620, 12705},
  {"1.43", 489716, 12708},
  {"1.44", 489809, 12711},
  {"1.45", 489909, 12714},
  {"1.46", 490011, 12717},
  {"1.47", 490107, 12720},
  {"1.48", 490207, 12723},
  {"1.49", 490308, 12726},
  {"1.50", 490402, 12729},
  {"1.51", 490502, 12732},
  {"1.52", 490603, 12735},
  {"1.53", 490697, 12738},
  {"1.54", 490792, 12741},
  {"1.55", 490887, 12744},
  {"1.56", 490982, 12747},
  {"1.57", 491077, 12750},
  {"1.58", 491172, 12753},
  {"1.59", 491268, 12756},
  {"1.60", 491369, 12759},
  {"1.61", 491470, 12762},
  {"1.62", 491565, 12765},
  {"1.63", 491666, 12768},
  {"1.64", 491760, 12771},
  {"1.65", 491854, 12774},
  {"1.66", 491949, 12777},
  {"1.67", 492050, 12780},
  {"1.68", 492144, 12783},
  {"1.69", 492238, 12786},
  {"1.70", 492333, 12789},
  {"1.71", 492428, 12792},
  {"1.72", 492522, 12795},
  {"1.73", 492623, 12798},
  {"1.74", 492724, 12801},
  {"1.75", 492818, 12804},
  {"1.76", 492919, 12807},
  {"1.77", 493013, 12810},
  {"1.78", 493107, 12813},
  {"1.79", 493208, 12816},
  {"1.80", 493302, 12819}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 40, "Subsection",
  CellTags->{"S6.9.1", "1.1"}],
Cell[1920, 61, 465, 8, 93, "Text",
  CellTags->{"S6.9.1", "1.2"}],
Cell[2388, 71, 4883, 118, 172, "DefinitionBox",
  CellTags->"S6.9.1"],
Cell[7274, 191, 87, 3, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[7364, 196, 80, 1, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.3"}],
Cell[7447, 199, 91, 2, 31, "Input",
  CellTags->"S6.9.1"],

Cell[CellGroupData[{
Cell[7563, 205, 93, 1, 35, "Subsubsection",
  CellTags->{"S6.9.1", "1.4"}],
Cell[7659, 208, 662, 11, 127, "Text",
  CellTags->{"S6.9.1", "1.5"}],
Cell[8324, 221, 2802, 84, 110, "DefinitionBox",
  CellTags->"S6.9.1"],
Cell[11129, 307, 79, 1, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[11211, 310, 85, 1, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.6"}],
Cell[11299, 313, 133, 5, 51, "Input",
  CellTags->"S6.9.1"],
Cell[11435, 320, 130, 3, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.7"}],

Cell[CellGroupData[{
Cell[11590, 327, 81, 2, 31, "Input",
  CellTags->"S6.9.1"],
Cell[11674, 331, 20929, 400, 186, 2025, 162, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S6.9.1"],
Cell[32606, 733, 179, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[32800, 742, 127, 3, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.8"}],

Cell[CellGroupData[{
Cell[32952, 749, 82, 2, 31, "Input",
  CellTags->"S6.9.1"],
Cell[33037, 753, 30982, 591, 186, 3184, 244, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S6.9.1"],
Cell[64022, 1346, 179, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[64216, 1355, 8292, 243, 322, "DefinitionBox3Col",
  CellTags->"S6.9.1"],
Cell[72511, 1600, 109, 5, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[72623, 1607, 237, 6, 42, "Text",
  CellTags->{"S6.9.1", "1.9"}],
Cell[72863, 1615, 348, 7, 76, "Text",
  CellTags->{"S6.9.1", "1.10"}],
Cell[73214, 1624, 1290, 29, 229, "Text",
  CellTags->{"S6.9.1", "1.11"}],
Cell[74507, 1655, 243, 5, 75, "MathCaption",
  CellTags->{"S6.9.1", "1.12"}],

Cell[CellGroupData[{
Cell[74775, 1664, 221, 8, 131, "Input",
  CellTags->"S6.9.1"],
Cell[74999, 1674, 19292, 425, 186, 3278, 223, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S6.9.1"],
Cell[94294, 2101, 179, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[94488, 2110, 364, 10, 59, "Text",
  CellTags->{"S6.9.1", "1.13"}],
Cell[94855, 2122, 405, 9, 76, "Text",
  CellTags->{"S6.9.1", "1.14"}],
Cell[95263, 2133, 442, 8, 93, "Text",
  CellTags->{"S6.9.1", "1.15"}],
Cell[95708, 2143, 758, 19, 127, "Text",
  CellTags->{"S6.9.1", "1.16"}],
Cell[96469, 2164, 186, 4, 58, "MathCaption",
  CellTags->{"S6.9.1", "1.17"}],

Cell[CellGroupData[{
Cell[96680, 2172, 271, 10, 151, "Input",
  CellTags->"S6.9.1"],
Cell[96954, 2184, 27150, 705, 186, 8810, 474, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S6.9.1"],
Cell[124107, 2891, 179, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[124335, 2903, 68, 1, 35, "Subsubsection",
  CellTags->{"S6.9.1", "1.18"}],
Cell[124406, 2906, 244, 5, 59, "Text",
  CellTags->{"S6.9.1", "1.19"}],
Cell[124653, 2913, 3078, 93, 126, "DefinitionBox",
  CellTags->"S6.9.1"],
Cell[127734, 3008, 54, 1, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[127791, 3011, 320, 7, 59, "Text",
  CellTags->{"S6.9.1", "1.20"}],
Cell[128114, 3020, 148, 4, 58, "MathCaption",
  CellTags->{"S6.9.1", "1.21"}],

Cell[CellGroupData[{
Cell[128287, 3028, 129, 6, 71, "Input",
  CellTags->"S6.9.1"],
Cell[128419, 3036, 28193, 708, 186, 9606, 474, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S6.9.1"],
Cell[156615, 3746, 179, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[156809, 3755, 361, 12, 59, "Text",
  CellTags->{"S6.9.1", "1.22"}],
Cell[157173, 3769, 126, 3, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.23"}],

Cell[CellGroupData[{
Cell[157324, 3776, 157, 6, 91, "Input",
  CellTags->"S6.9.1"],
Cell[157484, 3784, 28354, 663, 186, 8539, 414, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S6.9.1"],
Cell[185841, 4449, 177, 5, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[186033, 4457, 10712, 299, 304, "DefinitionBox3Col",
  CellTags->"S6.9.1"],
Cell[196748, 4758, 105, 5, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[196856, 4765, 268, 7, 42, "Text",
  CellTags->{"S6.9.1", "1.24"}],
Cell[197127, 4774, 648, 18, 93, "Text",
  CellTags->{"S6.9.1", "1.25"}],
Cell[197778, 4794, 258, 8, 42, "Text",
  CellTags->{"S6.9.1", "1.26"}],
Cell[198039, 4804, 133, 3, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.27"}],

Cell[CellGroupData[{
Cell[198197, 4811, 302, 12, 191, "Input",
  CellTags->"S6.9.1"],
Cell[198502, 4825, 14974, 442, 186, 4273, 306, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S6.9.1"],
Cell[213479, 5269, 180, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[213708, 5281, 88, 1, 35, "Subsubsection",
  CellTags->{"S6.9.1", "1.28"}],
Cell[213799, 5284, 341, 6, 76, "Text",
  CellTags->{"S6.9.1", "1.29"}],
Cell[214143, 5292, 1436, 43, 66, "DefinitionBox",
  CellTags->"S6.9.1"],
Cell[215582, 5337, 73, 1, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[215658, 5340, 476, 8, 93, "Text",
  CellTags->{"S6.9.1", "1.30"}],
Cell[216137, 5350, 180, 4, 58, "MathCaption",
  CellTags->{"S6.9.1", "1.31"}],

Cell[CellGroupData[{
Cell[216342, 5358, 139, 7, 91, "Input",
  CellTags->"S6.9.1"],
Cell[216484, 5367, 68609, 1891, 186, 53817, 1704, "GraphicsData", \
"PostScript", "Graphics",
  CellTags->"S6.9.1"],
Cell[285096, 7260, 180, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[285291, 7269, 5019, 147, 176, "DefinitionBox3Col",
  CellTags->"S6.9.1"],
Cell[290313, 7418, 107, 5, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[290423, 7425, 890, 22, 144, "Text",
  CellTags->{"S6.9.1", "1.32"}],
Cell[291316, 7449, 133, 3, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.33"}],

Cell[CellGroupData[{
Cell[291474, 7456, 227, 7, 111, "Input",
  CellTags->"S6.9.1"],
Cell[291704, 7465, 22203, 696, 186, 7745, 513, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S6.9.1"],
Cell[313910, 8163, 180, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[314139, 8175, 78, 1, 35, "Subsubsection",
  CellTags->{"S6.9.1", "1.34"}],
Cell[314220, 8178, 302, 6, 59, "Text",
  CellTags->{"S6.9.1", "1.35"}],
Cell[314525, 8186, 916, 28, 66, "DefinitionBox",
  CellTags->"S6.9.1"],
Cell[315444, 8216, 62, 1, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[315509, 8219, 349, 7, 76, "Text",
  CellTags->{"S6.9.1", "1.36"}],
Cell[315861, 8228, 86, 1, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.37"}],
Cell[315950, 8231, 115, 2, 31, "Input",
  CellTags->"S6.9.1"],
Cell[316068, 8235, 103, 1, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.38"}],

Cell[CellGroupData[{
Cell[316196, 8240, 87, 2, 31, "Input",
  CellTags->"S6.9.1"],
Cell[316286, 8244, 42673, 1058, 186, 12123, 677, "GraphicsData", \
"PostScript", "Graphics",
  CellTags->"S6.9.1"],
Cell[358962, 9304, 180, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[359157, 9313, 6169, 149, 158, "DefinitionBox3Col",
  CellTags->"S6.9.1"],
Cell[365329, 9464, 122, 5, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[365454, 9471, 493, 15, 76, "Text",
  CellTags->{"S6.9.1", "1.39"}],
Cell[365950, 9488, 656, 14, 127, "Text",
  CellTags->{"S6.9.1", "1.40"}],
Cell[366609, 9504, 270, 7, 59, "Text",
  CellTags->{"S6.9.1", "1.41"}],
Cell[366882, 9513, 1002, 24, 161, "Text",
  CellTags->{"S6.9.1", "1.42"}],
Cell[367887, 9539, 149, 5, 25, "Text",
  CellTags->{"S6.9.1", "1.43"}],
Cell[368039, 9546, 116, 2, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.44"}],

Cell[CellGroupData[{
Cell[368180, 9552, 316, 10, 171, "Input",
  CellTags->"S6.9.1"],
Cell[368499, 9564, 54111, 1312, 186, 17958, 861, "GraphicsData", \
"PostScript", "Graphics",
  CellTags->"S6.9.1"],
Cell[422613, 10878, 180, 6, 27, "Output",
  CellTags->"S6.9.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[422842, 10890, 92, 1, 35, "Subsubsection",
  CellTags->{"S6.9.1", "1.45"}],
Cell[422937, 10893, 963, 14, 195, "Text",
  CellTags->{"S6.9.1", "1.46"}],
Cell[423903, 10909, 3062, 74, 88, "DefinitionBox",
  CellTags->"S6.9.1"],
Cell[426968, 10985, 77, 1, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[427048, 10988, 88, 1, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.47"}],
Cell[427139, 10991, 97, 2, 31, "Input",
  CellTags->"S6.9.1"],
Cell[427239, 10995, 127, 3, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.48"}],

Cell[CellGroupData[{
Cell[427391, 11002, 83, 2, 31, "Input",
  CellTags->"S6.9.1"],
Cell[427477, 11006, 759, 22, 109, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[428251, 11031, 266, 5, 59, "Text",
  CellTags->{"S6.9.1", "1.49"}],
Cell[428520, 11038, 95, 1, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.50"}],
Cell[428618, 11041, 99, 2, 31, "Input",
  CellTags->"S6.9.1"],
Cell[428720, 11045, 168, 4, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.51"}],

Cell[CellGroupData[{
Cell[428913, 11053, 92, 2, 31, "Input",
  CellTags->"S6.9.1"],
Cell[429008, 11057, 879, 23, 125, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[429902, 11083, 161, 4, 42, "Text",
  CellTags->{"S6.9.1", "1.52"}],
Cell[430066, 11089, 7303, 173, 256, "DefinitionBox3Col",
  CellTags->"S6.9.1"],
Cell[437372, 11264, 172, 7, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[437547, 11273, 460, 15, 59, "Text",
  CellTags->{"S6.9.1", "1.53"}],
Cell[438010, 11290, 589, 18, 93, "Text",
  CellTags->{"S6.9.1", "1.54"}],
Cell[438602, 11310, 602, 19, 93, "Text",
  CellTags->{"S6.9.1", "1.55"}],
Cell[439207, 11331, 323, 10, 59, "Text",
  CellTags->{"S6.9.1", "1.56"}],
Cell[439533, 11343, 300, 10, 42, "Text",
  CellTags->{"S6.9.1", "1.57"}],
Cell[439836, 11355, 773, 21, 110, "Text",
  CellTags->{"S6.9.1", "1.58"}],
Cell[440612, 11378, 197, 4, 58, "MathCaption",
  CellTags->{"S6.9.1", "1.59"}],

Cell[CellGroupData[{
Cell[440834, 11386, 166, 5, 51, "Input",
  CellTags->"S6.9.1"],
Cell[441003, 11393, 1423, 30, 231, "Output",
  CellTags->"S6.9.1"]
}, Open  ]],
Cell[442441, 11426, 204, 6, 58, "MathCaption",
  CellTags->{"S6.9.1", "1.60"}],

Cell[CellGroupData[{
Cell[442670, 11436, 265, 5, 72, "Input"],
Cell[442938, 11443, 541, 16, 107, "Output"]
}, Open  ]],
Cell[443494, 11462, 523, 13, 93, "Text",
  CellTags->{"S6.9.1", "1.61"}],
Cell[444020, 11477, 170, 5, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.62"}],

Cell[CellGroupData[{
Cell[444215, 11486, 148, 3, 49, "Input"],
Cell[444366, 11491, 762, 22, 117, "Output"]
}, Open  ]],
Cell[445143, 11516, 216, 6, 42, "Text",
  CellTags->{"S6.9.1", "1.63"}],
Cell[445362, 11524, 3242, 78, 130, "DefinitionBox3Col",
  CellTags->"S6.9.1"],
Cell[448607, 11604, 175, 7, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[448785, 11613, 276, 8, 59, "Text",
  CellTags->{"S6.9.1", "1.64"}],
Cell[449064, 11623, 498, 14, 76, "Text",
  CellTags->{"S6.9.1", "1.65"}],
Cell[449565, 11639, 233, 7, 58, "MathCaption",
  CellTags->{"S6.9.1", "1.66"}],

Cell[CellGroupData[{
Cell[449823, 11650, 290, 6, 89, "Input"],
Cell[450116, 11658, 837, 23, 141, "Output"]
}, Open  ]],
Cell[450968, 11684, 194, 5, 42, "Text",
  CellTags->{"S6.9.1", "1.67"}],
Cell[451165, 11691, 5288, 126, 212, "DefinitionBox3Col",
  CellTags->"S6.9.1"],
Cell[456456, 11819, 187, 7, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[456646, 11828, 360, 9, 59, "Text",
  CellTags->{"S6.9.1", "1.68"}],
Cell[457009, 11839, 458, 12, 76, "Text",
  CellTags->{"S6.9.1", "1.69"}],
Cell[457470, 11853, 394, 11, 59, "Text",
  CellTags->{"S6.9.1", "1.70"}],
Cell[457867, 11866, 201, 5, 42, "Text",
  CellTags->{"S6.9.1", "1.71"}],
Cell[458071, 11873, 107, 1, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.72"}],
Cell[458181, 11876, 197, 5, 49, "Input"],
Cell[458381, 11883, 156, 4, 58, "MathCaption",
  CellTags->{"S6.9.1", "1.73"}],

Cell[CellGroupData[{
Cell[458562, 11891, 187, 4, 49, "Input"],
Cell[458752, 11897, 1178, 27, 125, "Output"]
}, Open  ]],
Cell[459945, 11927, 196, 4, 42, "Text",
  CellTags->{"S6.9.1", "1.74"}],
Cell[460144, 11933, 151, 4, 58, "MathCaption",
  CellTags->{"S6.9.1", "1.75"}],

Cell[CellGroupData[{
Cell[460320, 11941, 219, 5, 69, "Input"],
Cell[460542, 11948, 2388, 58, 225, "Output"]
}, Open  ]],
Cell[462945, 12009, 187, 5, 42, "Text",
  CellTags->{"S6.9.1", "1.76"}],
Cell[463135, 12016, 2185, 53, 70, "DefinitionBox3Col",
  CellTags->"S6.9.1"],
Cell[465323, 12071, 119, 5, 17, "Caption",
  CellTags->"S6.9.1"],
Cell[465445, 12078, 147, 5, 25, "Text",
  CellTags->{"S6.9.1", "1.77"}],
Cell[465595, 12085, 157, 5, 41, "MathCaption",
  CellTags->{"S6.9.1", "1.78"}],

Cell[CellGroupData[{
Cell[465777, 12094, 160, 4, 49, "Input"],
Cell[465940, 12100, 2012, 39, 125, "Output"]
}, Open  ]],
Cell[467967, 12142, 289, 6, 59, "Text",
  CellTags->{"S6.9.1", "1.79"}],
Cell[468259, 12150, 141, 4, 58, "MathCaption",
  CellTags->{"S6.9.1", "1.80"}],

Cell[CellGroupData[{
Cell[468425, 12158, 257, 5, 89, "Input"],
Cell[468685, 12165, 3727, 79, 241, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

