(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    832813,      40464]*)
(*NotebookOutlinePosition[    838420,      40624]*)
(*  CellTagsIndexPosition[    838056,      40607]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "SurfaceOfRevolution",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.44.1", "1.1"}],

Cell[TextData[{
 "A surface of revolution is generated by rotating a curve about a given \
line. ",
 StyleBox["SurfaceOfRevolution", "MR"],
 " plots the surface of revolution generated by rotating about any axis the \
graph of a function in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " plane or a curve described parametrically. "
}], "Text",
 CellTags->{"S5.44.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SurfaceOfRevolution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the surface of revolution obtained by rotating the curve of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["f",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["z",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" plane between ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SurfaceOfRevolution[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["z",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the surface of revolution by rotating the curve described \
parametrically in the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["z",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" plane with the variable ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SurfaceOfRevolution[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["z",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the surface of revolution by rotating the curve described \
parametrically in three\[Hyphen]dimensional space with the variable ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["t",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.44.1"],

Cell["Surface of revolution of a curve.", "Caption",
 CellTags->"S5.44.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.44.1", "1.3"}],

Cell["<<Graphics`SurfaceOfRevolution`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.44.1"],

Cell[TextData[{
 "The curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is rotated about the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis. "
}], "MathCaption",
 CellTags->{"S5.44.1", "1.4"}],

Cell[CellGroupData[{

Cell["\<\
SurfaceOfRevolution[
          Sin[x], {x, 0, 2 Pi}]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.44.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .68999 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
4.43439e-17 1.0488 -0.128487 1.0488 [
[.07775 .22154 -12 -8.73869 ]
[.07775 .22154 0 .26131 ]
[.32443 .12758 -5.68272 -9 ]
[.32443 .12758 .31728 0 ]
[.59579 .02429 -5.1805 -9 ]
[.59579 .02429 .8195 0 ]
[.75045 .05873 0 -6.14434 ]
[.75045 .05873 12 2.85566 ]
[.87 .23645 0 -5.97748 ]
[.87 .23645 6 3.02252 ]
[.97119 .38691 0 -5.84137 ]
[.97119 .38691 6 3.15863 ]
[.0025 .26468 -12 -2.79627 ]
[.0025 .26468 0 6.20373 ]
[-0.00105 .2869 -24 -2.81469 ]
[-0.00105 .2869 0 6.18531 ]
[-0.00464 .30942 -6 -2.83339 ]
[-0.00464 .30942 0 6.16661 ]
[-0.00828 .33226 -18 -2.85238 ]
[-0.00828 .33226 0 6.14762 ]
[-0.01197 .35542 -6 -2.87167 ]
[-0.01197 .35542 0 6.12833 ]
[ 0 0 0 0 ]
[ 1 .68999 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01509 .2579 m
.69556 0 L
s
.0873 .23053 m
.09207 .23503 L
s
[(-5)] .07775 .22154 1 .94193 Mshowa
.33317 .13735 m
.33754 .14224 L
s
[(0)] .32443 .12758 .89424 1 Mshowa
.6035 .03489 m
.60735 .0402 L
s
[(5)] .59579 .02429 .72683 1 Mshowa
.125 Mabswid
.13467 .21258 m
.13749 .21532 L
s
.18293 .19429 m
.1857 .19708 L
s
.23207 .17566 m
.2348 .1785 L
s
.28215 .15669 m
.28482 .15957 L
s
.38516 .11764 m
.38773 .12062 L
s
.43816 .09755 m
.44067 .10058 L
s
.4922 .07708 m
.49465 .08016 L
s
.5473 .05619 m
.54968 .05932 L
s
.04077 .24817 m
.04367 .25082 L
s
.66082 .01317 m
.66306 .0164 L
s
.25 Mabswid
.69556 0 m
.98755 .43361 L
s
.73814 .06323 m
.73198 .06548 L
s
[(-5)] .75045 .05873 -1 .36541 Mshowa
.85754 .24054 m
.85131 .24259 L
s
[(0)] .87 .23645 -1 .32833 Mshowa
.95862 .39065 m
.95234 .39252 L
s
[(5)] .97119 .38691 -1 .29808 Mshowa
.125 Mabswid
.76372 .10122 m
.76002 .10254 L
s
.78841 .13788 m
.78469 .13917 L
s
.81224 .17327 m
.80852 .17455 L
s
.83528 .20748 m
.83155 .20873 L
s
.87908 .27253 m
.87534 .27373 L
s
.89992 .30348 m
.89617 .30467 L
s
.92011 .33346 m
.91635 .33462 L
s
.93967 .3625 m
.9359 .36364 L
s
.71161 .02384 m
.70793 .02521 L
s
.977 .41795 m
.97323 .41905 L
s
.25 Mabswid
.01509 .2579 m
0 .35323 L
s
.01476 .26004 m
.02089 .25772 L
s
[(-1)] .0025 .26468 1 -0.37861 Mshowa
.01123 .2823 m
.01737 .28 L
s
[(-0.5)] -0.00105 .2869 1 -0.37451 Mshowa
.00766 .30487 m
.0138 .30259 L
s
[(0)] -0.00464 .30942 1 -0.37036 Mshowa
.00403 .32775 m
.01019 .3255 L
s
[(0.5)] -0.00828 .33226 1 -0.36614 Mshowa
.00036 .35096 m
.00652 .34873 L
s
[(1)] -0.01197 .35542 1 -0.36185 Mshowa
.125 Mabswid
.01405 .26447 m
.01773 .26308 L
s
.01335 .26891 m
.01703 .26752 L
s
.01265 .27336 m
.01633 .27197 L
s
.01194 .27782 m
.01562 .27644 L
s
.01052 .28679 m
.0142 .28541 L
s
.00981 .29129 m
.01349 .28991 L
s
.00909 .2958 m
.01278 .29443 L
s
.00838 .30033 m
.01206 .29896 L
s
.00694 .30942 m
.01063 .30806 L
s
.00621 .31398 m
.0099 .31262 L
s
.00549 .31856 m
.00918 .3172 L
s
.00476 .32315 m
.00845 .32179 L
s
.0033 .33237 m
.007 .33102 L
s
.00257 .337 m
.00627 .33565 L
s
.00184 .34164 m
.00553 .34029 L
s
.0011 .34629 m
.0048 .34495 L
s
.25 Mabswid
.01509 .2579 m
0 .35323 L
s
0 .35323 m
.39726 .68999 L
s
.39726 .68999 m
.40027 .60369 L
s
.40027 .60369 m
.01509 .2579 L
s
.69556 0 m
.98755 .43361 L
s
.98755 .43361 m
1 .52479 L
s
1 .52479 m
.70134 .09974 L
s
.70134 .09974 m
.69556 0 L
s
.01509 .2579 m
0 .35323 L
s
0 .35323 m
.70134 .09974 L
s
.70134 .09974 m
.69556 0 L
s
.69556 0 m
.01509 .2579 L
s
.40027 .60369 m
.98755 .43361 L
s
.98755 .43361 m
1 .52479 L
s
1 .52479 m
.39726 .68999 L
s
.39726 .68999 m
.40027 .60369 L
s
0 0 m
1 0 L
1 .68999 L
0 .68999 L
closepath
clip
newpath
.5 Mabswid
.734 .625 .737 r
.49375 .56444 m .49272 .57918 L .42643 .57177 L p F P
0 g
s
.705 .6 .736 r
.49272 .57918 m .49375 .56444 L .55879 .56413 L p F P
0 g
s
.705 .6 .736 r
.55879 .56413 m .56001 .57886 L .49272 .57918 L p F P
0 g
s
.675 .577 .738 r
.56001 .57886 m .55879 .56413 L .62265 .55629 L p F P
0 g
s
.675 .577 .738 r
.62265 .55629 m .6261 .57082 L .56001 .57886 L p F P
0 g
s
.734 .625 .737 r
.42643 .57177 m .42971 .55722 L .49375 .56444 L p F P
0 g
s
.733 .628 .742 r
.49479 .55009 m .49375 .56444 L .42971 .55722 L p F P
0 g
s
.705 .604 .74 r
.49375 .56444 m .49479 .55009 L .55756 .54979 L p F P
0 g
s
.705 .604 .74 r
.55756 .54979 m .55879 .56413 L .49375 .56444 L p F P
0 g
s
.675 .581 .742 r
.55879 .56413 m .55756 .54979 L .61919 .54216 L p F P
0 g
s
.675 .581 .742 r
.61919 .54216 m .62265 .55629 L .55879 .56413 L p F P
0 g
s
.733 .628 .742 r
.42971 .55722 m .43298 .54306 L .49479 .55009 L p F P
0 g
s
.732 .635 .751 r
.49582 .53653 m .49479 .55009 L .43298 .54306 L p F P
0 g
s
.705 .611 .75 r
.49479 .55009 m .49582 .53653 L .55635 .53624 L p F P
0 g
s
.705 .611 .75 r
.55635 .53624 m .55756 .54979 L .49479 .55009 L p F P
0 g
s
.676 .59 .752 r
.55756 .54979 m .55635 .53624 L .61575 .52883 L p F P
0 g
s
.676 .59 .752 r
.61575 .52883 m .61919 .54216 L .55756 .54979 L p F P
0 g
s
.732 .635 .751 r
.43298 .54306 m .43623 .5297 L .49582 .53653 L p F P
0 g
s
.728 .646 .767 r
.49684 .52412 m .49582 .53653 L .43623 .5297 L p F P
0 g
s
.703 .624 .765 r
.49582 .53653 m .49684 .52412 L .55514 .52383 L p F P
0 g
s
.703 .624 .765 r
.55514 .52383 m .55635 .53624 L .49582 .53653 L p F P
0 g
s
.677 .605 .767 r
.55635 .53624 m .55514 .52383 L .61234 .51664 L p F P
0 g
s
.677 .605 .767 r
.61234 .51664 m .61575 .52883 L .55635 .53624 L p F P
0 g
s
.762 .653 .742 r
.42971 .55722 m .42643 .57177 L .36337 .55679 L p F P
0 g
s
.728 .646 .767 r
.43623 .5297 m .43947 .51749 L .49684 .52412 L p F P
0 g
s
.723 .663 .79 r
.49786 .51315 m .49684 .52412 L .43947 .51749 L p F P
0 g
s
.701 .643 .789 r
.49684 .52412 m .49786 .51315 L .55394 .51287 L p F P
0 g
s
.701 .643 .789 r
.55394 .51287 m .55514 .52383 L .49684 .52412 L p F P
0 g
s
.678 .626 .79 r
.55514 .52383 m .55394 .51287 L .60895 .50591 L p F P
0 g
s
.678 .626 .79 r
.60895 .50591 m .61234 .51664 L .55514 .52383 L p F P
0 g
s
.643 .556 .742 r
.6261 .57082 m .62265 .55629 L .68317 .54109 L p F P
0 g
s
.643 .556 .742 r
.68317 .54109 m .68879 .55523 L .6261 .57082 L p F P
0 g
s
.762 .653 .742 r
.36337 .55679 m .36882 .54262 L .42971 .55722 L p F P
0 g
s
.761 .656 .746 r
.43298 .54306 m .42971 .55722 L .36882 .54262 L p F P
0 g
s
.644 .561 .747 r
.62265 .55629 m .61919 .54216 L .67755 .52737 L p F P
0 g
s
.644 .561 .747 r
.67755 .52737 m .68317 .54109 L .62265 .55629 L p F P
0 g
s
.761 .656 .746 r
.36882 .54262 m .37425 .52885 L .43298 .54306 L p F P
0 g
s
.758 .662 .756 r
.43623 .5297 m .43298 .54306 L .37425 .52885 L p F P
0 g
s
.646 .571 .757 r
.61919 .54216 m .61575 .52883 L .67197 .51446 L p F P
0 g
s
.646 .571 .757 r
.67197 .51446 m .67755 .52737 L .61919 .54216 L p F P
0 g
s
.723 .663 .79 r
.43947 .51749 m .44267 .50673 L .49786 .51315 L p F P
0 g
s
.712 .686 .823 r
.49886 .50385 m .49786 .51315 L .44267 .50673 L p F P
0 g
s
.695 .671 .822 r
.49786 .51315 m .49886 .50385 L .55274 .50358 L p F P
0 g
s
.695 .671 .822 r
.55274 .50358 m .55394 .51287 L .49786 .51315 L p F P
0 g
s
.677 .658 .824 r
.55394 .51287 m .55274 .50358 L .60559 .49686 L p F P
0 g
s
.677 .658 .824 r
.60559 .49686 m .60895 .50591 L .55394 .51287 L p F P
0 g
s
.758 .662 .756 r
.37425 .52885 m .37966 .5159 L .43623 .5297 L p F P
0 g
s
.752 .671 .772 r
.43947 .51749 m .43623 .5297 L .37966 .5159 L p F P
0 g
s
.649 .587 .772 r
.61575 .52883 m .61234 .51664 L .66643 .50271 L p F P
0 g
s
.649 .587 .772 r
.66643 .50271 m .67197 .51446 L .61575 .52883 L p F P
0 g
s
.752 .671 .772 r
.37966 .5159 m .38503 .50411 L .43947 .51749 L p F P
0 g
s
.743 .685 .795 r
.44267 .50673 m .43947 .51749 L .38503 .50411 L p F P
0 g
s
.653 .612 .795 r
.61234 .51664 m .60895 .50591 L .66093 .49243 L p F P
0 g
s
.653 .612 .795 r
.66093 .49243 m .66643 .50271 L .61234 .51664 L p F P
0 g
s
.712 .686 .823 r
.44267 .50673 m .44586 .49765 L .49886 .50385 L p F P
0 g
s
.69 .718 .87 r
.49986 .49638 m .49886 .50385 L .44586 .49765 L p F P
0 g
s
.681 .71 .87 r
.49886 .50385 m .49986 .49638 L .55156 .49612 L p F P
0 g
s
.681 .71 .87 r
.55156 .49612 m .55274 .50358 L .49886 .50385 L p F P
0 g
s
.672 .703 .871 r
.55274 .50358 m .55156 .49612 L .60225 .48964 L p F P
0 g
s
.672 .703 .871 r
.60225 .48964 m .60559 .49686 L .55274 .50358 L p F P
0 g
s
.743 .685 .795 r
.38503 .50411 m .39036 .49378 L .44267 .50673 L p F P
0 g
s
.727 .703 .828 r
.44586 .49765 m .44267 .50673 L .39036 .49378 L p F P
0 g
s
.658 .647 .828 r
.60895 .50591 m .60559 .49686 L .65548 .48384 L p F P
0 g
s
.658 .647 .828 r
.65548 .48384 m .66093 .49243 L .60895 .50591 L p F P
0 g
s
.69 .718 .87 r
.44586 .49765 m .44901 .49041 L .49986 .49638 L p F P
0 g
s
.644 .758 .932 r
.50085 .49081 m .49986 .49638 L .44901 .49041 L p F P
0 g
s
.647 .761 .932 r
.49986 .49638 m .50085 .49081 L .55039 .49057 L p F P
0 g
s
.647 .761 .932 r
.55039 .49057 m .55156 .49612 L .49986 .49638 L p F P
0 g
s
.652 .764 .931 r
.55156 .49612 m .55039 .49057 L .59894 .48434 L p F P
0 g
s
.652 .764 .931 r
.59894 .48434 m .60225 .48964 L .55156 .49612 L p F P
0 g
s
.727 .703 .828 r
.39036 .49378 m .39564 .48515 L .44586 .49765 L p F P
0 g
s
.698 .727 .873 r
.44901 .49041 m .44586 .49765 L .39564 .48515 L p F P
0 g
s
.661 .698 .873 r
.60559 .49686 m .60225 .48964 L .65008 .47711 L p F P
0 g
s
.661 .698 .873 r
.65008 .47711 m .65548 .48384 L .60559 .49686 L p F P
0 g
s
.789 .685 .75 r
.36882 .54262 m .36337 .55679 L .30577 .53454 L p F P
0 g
s
.789 .685 .75 r
.30577 .53454 m .31327 .52094 L .36882 .54262 L p F P
0 g
s
.787 .688 .754 r
.37425 .52885 m .36882 .54262 L .31327 .52094 L p F P
0 g
s
.607 .537 .751 r
.68879 .55523 m .68317 .54109 L .73815 .51885 L p F P
0 g
s
.607 .537 .751 r
.73815 .51885 m .74582 .53239 L .68879 .55523 L p F P
0 g
s
.787 .688 .754 r
.31327 .52094 m .32075 .50778 L .37425 .52885 L p F P
0 g
s
.783 .692 .764 r
.37966 .5159 m .37425 .52885 L .32075 .50778 L p F P
0 g
s
.609 .543 .755 r
.68317 .54109 m .67755 .52737 L .7305 .50575 L p F P
0 g
s
.609 .543 .755 r
.7305 .50575 m .73815 .51885 L .68317 .54109 L p F P
0 g
s
.783 .692 .764 r
.32075 .50778 m .32819 .49544 L .37966 .5159 L p F P
0 g
s
.775 .699 .78 r
.38503 .50411 m .37966 .5159 L .32819 .49544 L p F P
0 g
s
.612 .554 .765 r
.67755 .52737 m .67197 .51446 L .72291 .49347 L p F P
0 g
s
.612 .554 .765 r
.72291 .49347 m .7305 .50575 L .67755 .52737 L p F P
0 g
s
.698 .727 .873 r
.39564 .48515 m .40087 .47836 L .44901 .49041 L p F P
0 g
s
.641 .754 .93 r
.45215 .48508 m .44901 .49041 L .40087 .47836 L p F P
0 g
s
.644 .758 .932 r
.44901 .49041 m .45215 .48508 L .50085 .49081 L p F P
0 g
s
.538 .788 .99 r
.50184 .48714 m .50085 .49081 L .45215 .48508 L p F P
0 g
s
.561 .811 .992 r
.50085 .49081 m .50184 .48714 L .54921 .4869 L p F P
0 g
s
.561 .811 .992 r
.54921 .4869 m .55039 .49057 L .50085 .49081 L p F P
0 g
s
.618 .573 .781 r
.67197 .51446 m .66643 .50271 L .71537 .48237 L p F P
0 g
s
.618 .573 .781 r
.71537 .48237 m .72291 .49347 L .67197 .51446 L p F P
0 g
s
.59 .83 .99 r
.55039 .49057 m .54921 .4869 L .59564 .48093 L p F P
0 g
s
.59 .83 .99 r
.59564 .48093 m .59894 .48434 L .55039 .49057 L p F P
0 g
s
.656 .766 .93 r
.60225 .48964 m .59894 .48434 L .64471 .4723 L p F P
0 g
s
.656 .766 .93 r
.64471 .4723 m .65008 .47711 L .60225 .48964 L p F P
0 g
s
.775 .699 .78 r
.32819 .49544 m .33557 .48428 L .38503 .50411 L p F P
0 g
s
.762 .71 .802 r
.39036 .49378 m .38503 .50411 L .33557 .48428 L p F P
0 g
s
.627 .6 .803 r
.66643 .50271 m .66093 .49243 L .7079 .47276 L p F P
0 g
s
.627 .6 .803 r
.7079 .47276 m .71537 .48237 L .66643 .50271 L p F P
0 g
s
.762 .71 .802 r
.33557 .48428 m .34288 .47461 L .39036 .49378 L p F P
0 g
s
.741 .723 .834 r
.39564 .48515 m .39036 .49378 L .34288 .47461 L p F P
0 g
s
.638 .639 .835 r
.66093 .49243 m .65548 .48384 L .70051 .46487 L p F P
0 g
s
.638 .639 .835 r
.70051 .46487 m .7079 .47276 L .66093 .49243 L p F P
0 g
s
.641 .754 .93 r
.40087 .47836 m .40606 .4735 L .45215 .48508 L p F P
0 g
s
.523 .765 .985 r
.45526 .48164 m .45215 .48508 L .40606 .4735 L p F P
0 g
s
.538 .788 .99 r
.45215 .48508 m .45526 .48164 L .50184 .48714 L p F P
0 g
s
.622 .845 .985 r
.59894 .48434 m .59564 .48093 L .63938 .4694 L p F P
0 g
s
.622 .845 .985 r
.63938 .4694 m .64471 .4723 L .59894 .48434 L p F P
0 g
s
.741 .723 .834 r
.34288 .47461 m .35011 .46665 L .39564 .48515 L p F P
0 g
s
.705 .738 .877 r
.40087 .47836 m .39564 .48515 L .35011 .46665 L p F P
0 g
s
.314 .747 .969 r
.50282 .48526 m .50184 .48714 L .45526 .48164 L p F P
0 g
s
.359 .792 .967 r
.50184 .48714 m .50282 .48526 L .54805 .48503 L p F P
0 g
s
.359 .792 .967 r
.54805 .48503 m .54921 .4869 L .50184 .48714 L p F P
0 g
s
.429 .84 .97 r
.54921 .4869 m .54805 .48503 L .59235 .47933 L p F P
0 g
s
.429 .84 .97 r
.59235 .47933 m .59564 .48093 L .54921 .4869 L p F P
0 g
s
.651 .694 .877 r
.65548 .48384 m .65008 .47711 L .69319 .45885 L p F P
0 g
s
.651 .694 .877 r
.69319 .45885 m .70051 .46487 L .65548 .48384 L p F P
0 g
s
.705 .738 .877 r
.35011 .46665 m .35728 .46056 L .40087 .47836 L p F P
0 g
s
.639 .749 .929 r
.40606 .4735 m .40087 .47836 L .35728 .46056 L p F P
0 g
s
.523 .765 .985 r
.40606 .4735 m .41123 .47055 L .45526 .48164 L p F P
0 g
s
.298 .71 .974 r
.45837 .48 m .45526 .48164 L .41123 .47055 L p F P
0 g
s
.314 .747 .969 r
.45526 .48164 m .45837 .48 L .50282 .48526 L p F P
0 g
s
.661 .767 .929 r
.65008 .47711 m .64471 .4723 L .68592 .45477 L p F P
0 g
s
.661 .767 .929 r
.68592 .45477 m .69319 .45885 L .65008 .47711 L p F P
0 g
s
.515 .884 .975 r
.59564 .48093 m .59235 .47933 L .63407 .46831 L p F P
0 g
s
.515 .884 .975 r
.63407 .46831 m .63938 .4694 L .59564 .48093 L p F P
0 g
s
0 .566 .772 r
.50381 .48499 m .50282 .48526 L .45837 .48 L p F P
0 g
s
0 .566 .772 r
.46148 .47999 m .50381 .48499 L p .46661 .48091 L F P
0 g
s
0 .566 .772 r
.45837 .48 m .46148 .47999 L p .46661 .48091 L F P
0 g
s
0 .54 .817 r
.46148 .47999 m .45837 .48 L .41637 .46941 L p F P
0 g
s
0 .54 .817 r
.42151 .46991 m .46148 .47999 L p .42457 .47133 L F P
0 g
s
0 .54 .817 r
.41637 .46941 m .42151 .46991 L p .42457 .47133 L F P
0 g
s
0 .35 .692 r
.42151 .46991 m .3855 .45505 L p .41786 .4682 L F P
0 g
s
.274 0 0 r
.46148 .47999 m .42151 .46991 L p .45536 .47889 L F P
0 g
s
.274 0 0 r
.42667 .47178 m .46459 .48134 L p .42728 .47144 L F P
0 g
s
.274 0 0 r
.42151 .46991 m .42667 .47178 L p .42728 .47144 L F P
0 g
s
0 .35 .692 r
.42667 .47178 m .42151 .46991 L p .41786 .4682 L F P
0 g
s
.298 .71 .974 r
.41123 .47055 m .41637 .46941 L .45837 .48 L p F P
0 g
s
.028 .534 .872 r
.42151 .46991 m .41637 .46941 L .37848 .4538 L p F P
0 g
s
.028 .534 .872 r
.37848 .4538 m .3855 .45505 L .42151 .46991 L p F P
0 g
s
0 .35 .692 r
.39253 .45769 m .42667 .47178 L p .39103 .4573 L F P
0 g
s
0 .35 .692 r
.3855 .45505 m .39253 .45769 L p .39103 .4573 L F P
0 g
s
0 .267 .686 r
.39253 .45769 m .36367 .43955 L p .39424 .45815 L F P
0 g
s
.389 0 0 r
.42667 .47178 m .39253 .45769 L p .42597 .47216 L F P
0 g
s
.389 0 0 r
.39959 .46141 m .43184 .47471 L p .39594 .45917 L F P
0 g
s
.389 0 0 r
.39253 .45769 m .39959 .46141 L p .39594 .45917 L F P
0 g
s
.47 0 0 r
.43707 .47831 m .43184 .47471 L .39959 .46141 L p F P
0 g
s
.309 .68 .977 r
.41637 .46941 m .41123 .47055 L .37145 .45419 L p F P
0 g
s
.309 .68 .977 r
.37145 .45419 m .37848 .4538 L .41637 .46941 L p F P
0 g
s
.47 0 0 r
.40671 .4658 m .43707 .47831 L p .4008 .46195 L F P
0 g
s
.47 0 0 r
.39959 .46141 m .40671 .4658 L p .4008 .46195 L F P
0 g
s
0 .19 .607 r
.39959 .46141 m .37237 .44429 L p .40355 .46382 L F P
0 g
s
0 .19 .607 r
.40671 .4658 m .39959 .46141 L p .40355 .46382 L F P
0 g
s
0 .267 .686 r
.39959 .46141 m .39253 .45769 L p .39424 .45815 L F P
0 g
s
0 .267 .686 r
.36367 .43955 m .37237 .44429 L .39959 .46141 L p F P
0 g
s
0 .19 .607 r
.38112 .44972 m .40671 .4658 L p .37348 .44498 L F P
0 g
s
0 .19 .607 r
.37237 .44429 m .38112 .44972 L p .37348 .44498 L F P
0 g
s
0 .259 .741 r
.38112 .44972 m .36153 .43064 L p .38902 .45461 L F P
0 g
s
.395 0 0 r
.40671 .4658 m .38112 .44972 L p .41281 .46979 L F P
0 g
s
.395 0 0 r
.38112 .44972 m .38996 .45542 L .41389 .47047 L p F P
0 g
s
0 .259 .741 r
.38996 .45542 m .38112 .44972 L p .38902 .45461 L F P
0 g
s
.395 0 0 r
.41389 .47047 m .40671 .4658 L p .41281 .46979 L F P
0 g
s
.389 0 0 r
.43184 .47471 m .42667 .47178 L p .42597 .47216 L F P
0 g
s
.274 0 0 r
.46459 .48134 m .46148 .47999 L p .45536 .47889 L F P
0 g
s
.259 0 0 r
.50381 .48499 m .46148 .47999 L p .49548 .48478 L F P
0 g
s
.055 .621 .757 r
.50282 .48526 m .50381 .48499 L p .51079 .48517 L F P
0 g
s
.055 .621 .757 r
.54688 .48478 m .54805 .48503 L .53854 .48508 L p F P
0 g
s
.055 .621 .757 r
.53854 .48508 m .50282 .48526 L p .54688 .48478 L F P
0 g
s
.164 .703 .775 r
.54805 .48503 m .54688 .48478 L .58907 .47934 L p F P
0 g
s
.164 .703 .775 r
.58907 .47934 m .59235 .47933 L .58301 .48053 L p F P
0 g
s
.164 .703 .775 r
.58301 .48053 m .54805 .48503 L p .58907 .47934 L F P
0 g
s
.312 .803 .822 r
.59235 .47933 m .58907 .47934 L .62876 .46886 L p F P
0 g
s
0 0 0 r
.58907 .47934 m .58577 .48073 L .59661 .47787 L p F P
0 g
s
.312 .803 .822 r
.62876 .46886 m .63407 .46831 L .62525 .47064 L p F P
0 g
s
.312 .803 .822 r
.62525 .47064 m .59235 .47933 L p .62876 .46886 L F P
0 g
s
0 0 0 r
.62343 .47078 m .62876 .46886 L .62293 .47039 L p F P
0 g
s
0 0 0 r
.62293 .47039 m .58907 .47934 L p .62343 .47078 L F P
0 g
s
0 0 0 r
.62343 .47078 m .61808 .47376 L .62401 .47123 L p F P
0 g
s
.321 .794 .702 r
.62876 .46886 m .62343 .47078 L .63312 .46663 L p F P
0 g
s
.321 .794 .702 r
.63312 .46663 m .65717 .45634 L p .62876 .46886 L F P
0 g
s
.479 .897 .877 r
.63407 .46831 m .62876 .46886 L .66435 .45363 L p F P
0 g
s
.321 .794 .702 r
.65717 .45634 m .66435 .45363 L .65912 .45587 L p F P
0 g
s
.321 .794 .702 r
.65912 .45587 m .62876 .46886 L p .65717 .45634 L F P
0 g
s
0 0 0 r
.64996 .46013 m .65717 .45634 L .65415 .45764 L p F P
0 g
s
0 0 0 r
.65415 .45764 m .62343 .47078 L p .64996 .46013 L F P
0 g
s
.479 .897 .877 r
.66435 .45363 m .67153 .4523 L .63407 .46831 L p F P
0 g
s
0 0 0 r
.64269 .4646 m .64996 .46013 L .64895 .46056 L p F P
0 g
s
0 0 0 r
.64895 .46056 m .61808 .47376 L p .64269 .4646 L F P
0 g
s
.603 .916 .976 r
.63938 .4694 m .63407 .46831 L .67153 .4523 L p F P
0 g
s
0 0 0 r
.63535 .46935 m .64269 .4646 L .61269 .47743 L p F P
0 g
s
.389 .802 .597 r
.64269 .4646 m .63535 .46935 L .6362 .46879 L p F P
0 g
s
0 0 0 r
.62401 .47123 m .64996 .46013 L p .62343 .47078 L F P
0 g
s
0 0 0 r
.61808 .47376 m .61269 .47743 L .64269 .4646 L p F P
0 g
s
.389 .802 .597 r
.6362 .46879 m .65884 .45405 L p .64269 .4646 L F P
0 g
s
.408 .819 .623 r
.64996 .46013 m .64269 .4646 L .64539 .46285 L p F P
0 g
s
.408 .819 .623 r
.64539 .46285 m .6678 .44825 L p .64996 .46013 L F P
0 g
s
.464 .867 .699 r
.65717 .45634 m .64996 .46013 L .65492 .4569 L p F P
0 g
s
.464 .867 .699 r
.65492 .4569 m .67669 .44272 L p .65717 .45634 L F P
0 g
s
0 0 0 r
.59661 .47787 m .62343 .47078 L p .58907 .47934 L F P
0 g
s
.07 0 0 r
.54688 .48478 m .5457 .48589 L .55726 .4844 L p F P
0 g
s
.07 0 0 r
.55726 .4844 m .58577 .48073 L p .54688 .48478 L F P
0 g
s
.259 0 0 r
.50479 .48609 m .50381 .48499 L p .49548 .48478 L F P
0 g
s
.055 .621 .757 r
.50381 .48499 m .54688 .48478 L p .51079 .48517 L F P
0 g
s
.639 .749 .929 r
.35728 .46056 m .36439 .45641 L .40606 .4735 L p F P
0 g
s
.518 .742 .977 r
.41123 .47055 m .40606 .4735 L .36439 .45641 L p F P
0 g
s
.655 .853 .976 r
.64471 .4723 m .63938 .4694 L .67871 .45262 L p F P
0 g
s
.655 .853 .976 r
.67871 .45262 m .68592 .45477 L .64471 .4723 L p F P
0 g
s
.816 .722 .761 r
.31327 .52094 m .30577 .53454 L .25593 .50551 L p F P
0 g
s
.816 .722 .761 r
.25593 .50551 m .26531 .4927 L .31327 .52094 L p F P
0 g
s
.813 .724 .766 r
.32075 .50778 m .31327 .52094 L .26531 .4927 L p F P
0 g
s
.813 .724 .766 r
.26531 .4927 m .27464 .48034 L .32075 .50778 L p F P
0 g
s
.807 .727 .776 r
.32819 .49544 m .32075 .50778 L .27464 .48034 L p F P
0 g
s
.807 .727 .776 r
.27464 .48034 m .28392 .46883 L .32819 .49544 L p F P
0 g
s
.797 .732 .792 r
.33557 .48428 m .32819 .49544 L .28392 .46883 L p F P
0 g
s
.566 .52 .763 r
.74582 .53239 m .73815 .51885 L .78536 .4901 L p F P
0 g
s
.569 .526 .767 r
.73815 .51885 m .7305 .50575 L .77588 .47782 L p F P
0 g
s
.569 .526 .767 r
.77588 .47782 m .78536 .4901 L .73815 .51885 L p F P
0 g
s
.797 .732 .792 r
.28392 .46883 m .2931 .45853 L .33557 .48428 L p F P
0 g
s
.78 .737 .814 r
.34288 .47461 m .33557 .48428 L .2931 .45853 L p F P
0 g
s
.566 .52 .763 r
.78536 .4901 m .79488 .50283 L .74582 .53239 L p F P
0 g
s
.575 .539 .777 r
.7305 .50575 m .72291 .49347 L .76647 .46638 L p F P
0 g
s
.575 .539 .777 r
.76647 .46638 m .77588 .47782 L .7305 .50575 L p F P
0 g
s
.585 .56 .793 r
.72291 .49347 m .71537 .48237 L .75715 .45616 L p F P
0 g
s
.585 .56 .793 r
.75715 .45616 m .76647 .46638 L .72291 .49347 L p F P
0 g
s
.599 .591 .815 r
.71537 .48237 m .7079 .47276 L .74792 .44744 L p F P
0 g
s
.599 .591 .815 r
.74792 .44744 m .75715 .45616 L .71537 .48237 L p F P
0 g
s
.78 .737 .814 r
.2931 .45853 m .30219 .44973 L .34288 .47461 L p F P
0 g
s
.753 .744 .844 r
.35011 .46665 m .34288 .47461 L .30219 .44973 L p F P
0 g
s
.518 .742 .977 r
.36439 .45641 m .37145 .45419 L .41123 .47055 L p F P
0 g
s
.617 .634 .845 r
.7079 .47276 m .70051 .46487 L .7388 .44047 L p F P
0 g
s
.617 .634 .845 r
.7388 .44047 m .74792 .44744 L .7079 .47276 L p F P
0 g
s
.19 0 0 r
.50381 .48499 m .50479 .48609 L .5457 .48589 L p F P
0 g
s
.19 0 0 r
.5457 .48589 m .54688 .48478 L .50381 .48499 L p F P
0 g
s
.07 0 0 r
.58577 .48073 m .58907 .47934 L .54688 .48478 L p F P
0 g
s
.603 .916 .976 r
.67153 .4523 m .67871 .45262 L .63938 .4694 L p F P
0 g
s
.753 .744 .844 r
.30219 .44973 m .31118 .44267 L .35011 .46665 L p F P
0 g
s
.709 .748 .882 r
.35728 .46056 m .35011 .46665 L .31118 .44267 L p F P
0 g
s
.64 .692 .883 r
.70051 .46487 m .69319 .45885 L .72977 .43539 L p F P
0 g
s
.64 .692 .883 r
.72977 .43539 m .7388 .44047 L .70051 .46487 L p F P
0 g
s
.709 .748 .882 r
.31118 .44267 m .32007 .43751 L .35728 .46056 L p F P
0 g
s
.638 .745 .926 r
.36439 .45641 m .35728 .46056 L .32007 .43751 L p F P
0 g
s
.259 0 0 r
.46148 .47999 m .46459 .48134 L .50479 .48609 L p F P
0 g
s
.665 .768 .926 r
.69319 .45885 m .68592 .45477 L .72083 .43228 L p F P
0 g
s
.665 .768 .926 r
.72083 .43228 m .72977 .43539 L .69319 .45885 L p F P
0 g
s
.638 .745 .926 r
.32007 .43751 m .32889 .4343 L .36439 .45641 L p F P
0 g
s
.52 .721 .965 r
.37145 .45419 m .36439 .45641 L .32889 .4343 L p F P
0 g
s
.396 0 0 r
.50578 .48824 m .50479 .48609 L .46459 .48134 L p F P
0 g
s
.323 0 0 r
.50479 .48609 m .50578 .48824 L .54452 .48804 L p F P
0 g
s
.323 0 0 r
.54452 .48804 m .5457 .48589 L .50479 .48609 L p F P
0 g
s
.206 0 0 r
.5457 .48589 m .54452 .48804 L .58245 .48317 L p F P
0 g
s
.206 0 0 r
.58245 .48317 m .58577 .48073 L .5457 .48589 L p F P
0 g
s
.684 .854 .964 r
.68592 .45477 m .67871 .45262 L .71195 .43111 L p F P
0 g
s
.684 .854 .964 r
.71195 .43111 m .72083 .43228 L .68592 .45477 L p F P
0 g
s
.422 0 0 r
.46773 .48374 m .46459 .48134 L .42667 .47178 L p F P
0 g
s
.396 0 0 r
.46459 .48134 m .46773 .48374 L .50578 .48824 L p F P
0 g
s
.036 0 0 r
.58577 .48073 m .58245 .48317 L .61808 .47376 L p F P
0 g
s
.036 0 0 r
.61808 .47376 m .62343 .47078 L .58577 .48073 L p F P
0 g
s
.52 .721 .965 r
.32889 .4343 m .33763 .43305 L .37145 .45419 L p F P
0 g
s
.339 .656 .971 r
.37848 .4538 m .37145 .45419 L .33763 .43305 L p F P
0 g
s
.679 .929 .97 r
.67871 .45262 m .67153 .4523 L .70313 .43179 L p F P
0 g
s
.679 .929 .97 r
.70313 .43179 m .71195 .43111 L .67871 .45262 L p F P
0 g
s
.458 0 0 r
.50678 .49105 m .50578 .48824 L .46773 .48374 L p F P
0 g
s
.384 0 0 r
.50578 .48824 m .50678 .49105 L .54333 .49087 L p F P
0 g
s
.384 0 0 r
.54333 .49087 m .54452 .48804 L .50578 .48824 L p F P
0 g
s
.271 0 0 r
.54452 .48804 m .54333 .49087 L .57911 .48628 L p F P
0 g
s
.271 0 0 r
.57911 .48628 m .58245 .48317 L .54452 .48804 L p F P
0 g
s
.829 .766 .792 r
.23808 .44731 m .24891 .43684 L .28392 .46883 L p F P
0 g
s
.829 .766 .792 r
.28392 .46883 m .27464 .48034 L .23808 .44731 L p F P
0 g
s
.816 .768 .808 r
.2931 .45853 m .28392 .46883 L .24891 .43684 L p F P
0 g
s
.816 .768 .808 r
.24891 .43684 m .25962 .4276 L .2931 .45853 L p F P
0 g
s
.795 .768 .829 r
.30219 .44973 m .2931 .45853 L .25962 .4276 L p F P
0 g
s
.837 .765 .782 r
.22715 .45865 m .23808 .44731 L .27464 .48034 L p F P
0 g
s
.837 .765 .782 r
.27464 .48034 m .26531 .4927 L .22715 .45865 L p F P
0 g
s
.339 .656 .971 r
.33763 .43305 m .34632 .43364 L .37848 .4538 L p F P
0 g
s
.108 .537 .914 r
.3855 .45505 m .37848 .4538 L .34632 .43364 L p F P
0 g
s
.841 .765 .778 r
.21616 .47046 m .22715 .45865 L .26531 .4927 L p F P
0 g
s
.841 .765 .778 r
.26531 .4927 m .25593 .50551 L .21616 .47046 L p F P
0 g
s
.795 .768 .829 r
.25962 .4276 m .27021 .41989 L .30219 .44973 L p F P
0 g
s
.762 .767 .857 r
.31118 .44267 m .30219 .44973 L .27021 .41989 L p F P
0 g
s
.631 .958 .916 r
.67153 .4523 m .66435 .45363 L .69433 .43414 L p F P
0 g
s
.631 .958 .916 r
.69433 .43414 m .70313 .43179 L .67153 .4523 L p F P
0 g
s
.533 .526 .794 r
.77588 .47782 m .76647 .46638 L .80059 .43399 L p F P
0 g
s
.547 .551 .809 r
.76647 .46638 m .75715 .45616 L .78977 .42484 L p F P
0 g
s
.547 .551 .809 r
.78977 .42484 m .80059 .43399 L .76647 .46638 L p F P
0 g
s
.568 .585 .831 r
.75715 .45616 m .74792 .44744 L .77907 .41724 L p F P
0 g
s
.568 .585 .831 r
.77907 .41724 m .78977 .42484 L .75715 .45616 L p F P
0 g
s
.422 0 0 r
.42667 .47178 m .43184 .47471 L .46773 .48374 L p F P
0 g
s
.524 .511 .784 r
.78536 .4901 m .77588 .47782 L .81154 .44436 L p F P
0 g
s
.533 .526 .794 r
.80059 .43399 m .81154 .44436 L .77588 .47782 L p F P
0 g
s
.762 .767 .857 r
.27021 .41989 m .28066 .41395 L .31118 .44267 L p F P
0 g
s
.712 .759 .889 r
.32007 .43751 m .31118 .44267 L .28066 .41395 L p F P
0 g
s
.491 0 0 r
.47089 .48682 m .46773 .48374 L .43184 .47471 L p F P
0 g
s
.458 0 0 r
.46773 .48374 m .47089 .48682 L .50678 .49105 L p F P
0 g
s
.595 .632 .858 r
.74792 .44744 m .7388 .44047 L .76851 .4114 L p F P
0 g
s
.595 .632 .858 r
.76851 .4114 m .77907 .41724 L .74792 .44744 L p F P
0 g
s
.519 .504 .779 r
.79488 .50283 m .78536 .4901 L .82257 .45561 L p F P
0 g
s
.524 .511 .784 r
.81154 .44436 m .82257 .45561 L .78536 .4901 L p F P
0 g
s
.106 0 0 r
.58245 .48317 m .57911 .48628 L .61269 .47743 L p F P
0 g
s
.106 0 0 r
.61269 .47743 m .61808 .47376 L .58245 .48317 L p F P
0 g
s
.519 .504 .779 r
.82257 .45561 m .83368 .46733 L .79488 .50283 L p F P
0 g
s
.63 .693 .89 r
.7388 .44047 m .72977 .43539 L .75807 .40748 L p F P
0 g
s
.63 .693 .89 r
.75807 .40748 m .76851 .4114 L .7388 .44047 L p F P
0 g
s
.712 .759 .889 r
.28066 .41395 m .291 .40992 L .32007 .43751 L p F P
0 g
s
.637 .741 .924 r
.32889 .4343 m .32007 .43751 L .291 .40992 L p F P
0 g
s
.669 .767 .923 r
.72977 .43539 m .72083 .43228 L .74775 .40554 L p F P
0 g
s
.669 .767 .923 r
.74775 .40554 m .75807 .40748 L .72977 .43539 L p F P
0 g
s
.108 .537 .914 r
.34632 .43364 m .35499 .43589 L .3855 .45505 L p F P
0 g
s
0 .392 .802 r
.39253 .45769 m .3855 .45505 L .35499 .43589 L p F P
0 g
s
.475 0 0 r
.5078 .49412 m .50678 .49105 L .47089 .48682 L p F P
0 g
s
.401 0 0 r
.50678 .49105 m .5078 .49412 L .54213 .49395 L p F P
0 g
s
.401 0 0 r
.54213 .49395 m .54333 .49087 L .50678 .49105 L p F P
0 g
s
.547 .926 .81 r
.66435 .45363 m .65717 .45634 L .68552 .43789 L p F P
0 g
s
.547 .926 .81 r
.68552 .43789 m .69433 .43414 L .66435 .45363 L p F P
0 g
s
.637 .741 .924 r
.291 .40992 m .30122 .40789 L .32889 .4343 L p F P
0 g
s
.528 .703 .951 r
.33763 .43305 m .32889 .4343 L .30122 .40789 L p F P
0 g
s
.29 0 0 r
.54333 .49087 m .54213 .49395 L .57572 .48965 L p F P
0 g
s
.29 0 0 r
.57572 .48965 m .57911 .48628 L .54333 .49087 L p F P
0 g
s
.708 .848 .949 r
.72083 .43228 m .71195 .43111 L .73752 .40558 L p F P
0 g
s
.708 .848 .949 r
.73752 .40558 m .74775 .40554 L .72083 .43228 L p F P
0 g
s
.491 0 0 r
.43184 .47471 m .43707 .47831 L .47089 .48682 L p F P
0 g
s
.511 0 0 r
.47409 .49016 m .47089 .48682 L .43707 .47831 L p F P
0 g
s
.475 0 0 r
.47089 .48682 m .47409 .49016 L .5078 .49412 L p F P
0 g
s
.127 0 0 r
.57911 .48628 m .57572 .48965 L .60723 .48136 L p F P
0 g
s
.127 0 0 r
.60723 .48136 m .61269 .47743 L .57911 .48628 L p F P
0 g
s
.528 .703 .951 r
.30122 .40789 m .31135 .40782 L .33763 .43305 L p F P
0 g
s
.38 .637 .956 r
.34632 .43364 m .33763 .43305 L .31135 .40782 L p F P
0 g
s
.736 .923 .954 r
.71195 .43111 m .70313 .43179 L .72736 .40748 L p F P
0 g
s
.736 .923 .954 r
.72736 .40748 m .73752 .40558 L .71195 .43111 L p F P
0 g
s
0 .392 .802 r
.35499 .43589 m .36367 .43955 L .39253 .45769 L p F P
0 g
s
.464 .867 .699 r
.67669 .44272 m .68552 .43789 L .65717 .45634 L p F P
0 g
s
.38 .637 .956 r
.31135 .40782 m .32141 .40961 L .34632 .43364 L p F P
0 g
s
.205 .541 .927 r
.35499 .43589 m .34632 .43364 L .32141 .40961 L p F P
0 g
s
.458 0 0 r
.50882 .49701 m .5078 .49412 L .47409 .49016 L p F P
0 g
s
.384 0 0 r
.5078 .49412 m .50882 .49701 L .54091 .49685 L p F P
0 g
s
.384 0 0 r
.54091 .49685 m .54213 .49395 L .5078 .49412 L p F P
0 g
s
.271 0 0 r
.54213 .49395 m .54091 .49685 L .57229 .49284 L p F P
0 g
s
.271 0 0 r
.57229 .49284 m .57572 .48965 L .54213 .49395 L p F P
0 g
s
.741 .973 .927 r
.70313 .43179 m .69433 .43414 L .71724 .41107 L p F P
0 g
s
.741 .973 .927 r
.71724 .41107 m .72736 .40748 L .70313 .43179 L p F P
0 g
s
.494 0 0 r
.44235 .48218 m .43707 .47831 L .40671 .4658 L p F P
0 g
s
.511 0 0 r
.43707 .47831 m .44235 .48218 L .47409 .49016 L p F P
0 g
s
0 0 0 r
.61269 .47743 m .60723 .48136 L .63535 .46935 L p F P
0 g
s
.492 0 0 r
.47733 .49331 m .47409 .49016 L .44235 .48218 L p F P
0 g
s
.458 0 0 r
.47409 .49016 m .47733 .49331 L .50882 .49701 L p F P
0 g
s
.106 0 0 r
.57572 .48965 m .57229 .49284 L .60171 .48511 L p F P
0 g
s
.106 0 0 r
.60171 .48511 m .60723 .48136 L .57572 .48965 L p F P
0 g
s
.408 .819 .623 r
.6678 .44825 m .67669 .44272 L .64996 .46013 L p F P
0 g
s
.205 .541 .927 r
.32141 .40961 m .33142 .41309 L .35499 .43589 L p F P
0 g
s
.036 .434 .87 r
.36367 .43955 m .35499 .43589 L .33142 .41309 L p F P
0 g
s
.724 .988 .873 r
.69433 .43414 m .68552 .43789 L .70713 .41607 L p F P
0 g
s
.724 .988 .873 r
.70713 .41607 m .71724 .41107 L .69433 .43414 L p F P
0 g
s
.805 .802 .848 r
.23701 .39251 m .24872 .38609 L .27021 .41989 L p F P
0 g
s
.805 .802 .848 r
.27021 .41989 m .25962 .4276 L .23701 .39251 L p F P
0 g
s
.767 .79 .872 r
.28066 .41395 m .27021 .41989 L .24872 .38609 L p F P
0 g
s
.831 .808 .828 r
.22513 .40048 m .23701 .39251 L .25962 .4276 L p F P
0 g
s
.831 .808 .828 r
.25962 .4276 m .24891 .43684 L .22513 .40048 L p F P
0 g
s
.767 .79 .872 r
.24872 .38609 m .26027 .38146 L .28066 .41395 L p F P
0 g
s
.713 .77 .897 r
.291 .40992 m .28066 .41395 L .26027 .38146 L p F P
0 g
s
.848 .812 .813 r
.21311 .40972 m .22513 .40048 L .24891 .43684 L p F P
0 g
s
.848 .812 .813 r
.24891 .43684 m .23808 .44731 L .21311 .40972 L p F P
0 g
s
.397 0 0 r
.50986 .49928 m .50882 .49701 L .47733 .49331 L p F P
0 g
s
.325 0 0 r
.50882 .49701 m .50986 .49928 L .53966 .49913 L p F P
0 g
s
.325 0 0 r
.53966 .49913 m .54091 .49685 L .50882 .49701 L p F P
0 g
s
.208 0 0 r
.54091 .49685 m .53966 .49913 L .56881 .49541 L p F P
0 g
s
.208 0 0 r
.56881 .49541 m .57229 .49284 L .54091 .49685 L p F P
0 g
s
.713 .77 .897 r
.26027 .38146 m .27167 .37877 L .291 .40992 L p F P
0 g
s
.638 .738 .92 r
.30122 .40789 m .291 .40992 L .27167 .37877 L p F P
0 g
s
.494 0 0 r
.40671 .4658 m .41389 .47047 L .44235 .48218 L p F P
0 g
s
.471 0 0 r
.44769 .48588 m .44235 .48218 L .41389 .47047 L p F P
0 g
s
.492 0 0 r
.44235 .48218 m .44769 .48588 L .47733 .49331 L p F P
0 g
s
.534 .583 .85 r
.78977 .42484 m .77907 .41724 L .79959 .38316 L p F P
0 g
s
.573 .634 .873 r
.77907 .41724 m .76851 .4114 L .78797 .37865 L p F P
0 g
s
.573 .634 .873 r
.78797 .37865 m .79959 .38316 L .77907 .41724 L p F P
0 g
s
.859 .813 .803 r
.20097 .41984 m .21311 .40972 L .23808 .44731 L p F P
0 g
s
.859 .813 .803 r
.23808 .44731 m .22715 .45865 L .20097 .41984 L p F P
0 g
s
.505 .544 .83 r
.80059 .43399 m .78977 .42484 L .81138 .38946 L p F P
0 g
s
.534 .583 .85 r
.79959 .38316 m .81138 .38946 L .78977 .42484 L p F P
0 g
s
.62 .695 .898 r
.76851 .4114 m .75807 .40748 L .77651 .37608 L p F P
0 g
s
.62 .695 .898 r
.77651 .37608 m .78797 .37865 L .76851 .4114 L p F P
0 g
s
0 0 0 r
.60723 .48136 m .60171 .48511 L .62792 .47392 L p F P
0 g
s
0 0 0 r
.62792 .47392 m .63535 .46935 L .60723 .48136 L p F P
0 g
s
.483 .516 .815 r
.81154 .44436 m .80059 .43399 L .82332 .39733 L p F P
0 g
s
.505 .544 .83 r
.81138 .38946 m .82332 .39733 L .80059 .43399 L p F P
0 g
s
.036 .434 .87 r
.33142 .41309 m .34143 .41798 L .36367 .43955 L p F P
0 g
s
0 .341 .805 r
.37237 .44429 m .36367 .43955 L .34143 .41798 L p F P
0 g
s
.673 .765 .92 r
.75807 .40748 m .74775 .40554 L .76518 .37552 L p F P
0 g
s
.673 .765 .92 r
.76518 .37552 m .77651 .37608 L .75807 .40748 L p F P
0 g
s
.864 .814 .799 r
.18873 .43045 m .20097 .41984 L .22715 .45865 L p F P
0 g
s
.864 .814 .799 r
.22715 .45865 m .21616 .47046 L .18873 .43045 L p F P
0 g
s
.638 .738 .92 r
.27167 .37877 m .28292 .37809 L .30122 .40789 L p F P
0 g
s
.541 .688 .935 r
.31135 .40782 m .30122 .40789 L .28292 .37809 L p F P
0 g
s
.424 0 0 r
.48062 .49585 m .47733 .49331 L .44769 .48588 L p F P
0 g
s
.397 0 0 r
.47733 .49331 m .48062 .49585 L .50986 .49928 L p F P
0 g
s
.037 0 0 r
.57229 .49284 m .56881 .49541 L .5961 .48824 L p F P
0 g
s
.037 0 0 r
.5961 .48824 m .60171 .48511 L .57229 .49284 L p F P
0 g
s
.469 .498 .805 r
.82257 .45561 m .81154 .44436 L .83542 .40645 L p F P
0 g
s
.483 .516 .815 r
.82332 .39733 m .83542 .40645 L .81154 .44436 L p F P
0 g
s
.389 .802 .597 r
.65884 .45405 m .6678 .44825 L .64269 .4646 L p F P
0 g
s
.695 .98 .813 r
.68552 .43789 m .67669 .44272 L .69701 .42216 L p F P
0 g
s
.695 .98 .813 r
.69701 .42216 m .70713 .41607 L .68552 .43789 L p F P
0 g
s
.726 .837 .934 r
.74775 .40554 m .73752 .40558 L .75398 .37695 L p F P
0 g
s
.726 .837 .934 r
.75398 .37695 m .76518 .37552 L .74775 .40554 L p F P
0 g
s
.462 .489 .801 r
.83368 .46733 m .82257 .45561 L .84764 .41647 L p F P
0 g
s
.469 .498 .805 r
.83542 .40645 m .84764 .41647 L .82257 .45561 L p F P
0 g
s
.541 .688 .935 r
.28292 .37809 m .29406 .3794 L .31135 .40782 L p F P
0 g
s
.424 .622 .934 r
.32141 .40961 m .31135 .40782 L .29406 .3794 L p F P
0 g
s
.462 .489 .801 r
.84764 .41647 m .85995 .42697 L .83368 .46733 L p F P
0 g
s
.772 .902 .932 r
.73752 .40558 m .72736 .40748 L .74287 .38026 L p F P
0 g
s
.772 .902 .932 r
.74287 .38026 m .75398 .37695 L .73752 .40558 L p F P
0 g
s
.265 0 0 r
.51092 .50051 m .50986 .49928 L .48062 .49585 L p F P
0 g
s
.197 0 0 r
.50986 .49928 m .51092 .50051 L .5384 .50037 L p F P
0 g
s
.197 0 0 r
.5384 .50037 m .53966 .49913 L .50986 .49928 L p F P
0 g
s
0 .341 .805 r
.34143 .41798 m .35146 .42396 L .37237 .44429 L p F P
0 g
s
0 .28 .758 r
.38112 .44972 m .37237 .44429 L .35146 .42396 L p F P
0 g
s
.077 0 0 r
.53966 .49913 m .5384 .50037 L .56527 .49694 L p F P
0 g
s
.077 0 0 r
.56527 .49694 m .56881 .49541 L .53966 .49913 L p F P
0 g
s
.471 0 0 r
.41389 .47047 m .42116 .47497 L .44769 .48588 L p F P
0 g
s
.391 0 0 r
.45312 .48896 m .44769 .48588 L .42116 .47497 L p F P
0 g
s
.424 0 0 r
.44769 .48588 m .45312 .48896 L .48062 .49585 L p F P
0 g
s
0 0 0 r
.60171 .48511 m .5961 .48824 L .6204 .47788 L p F P
0 g
s
0 0 0 r
.6204 .47788 m .62792 .47392 L .60171 .48511 L p F P
0 g
s
.424 .622 .934 r
.29406 .3794 m .3051 .38259 L .32141 .40961 L p F P
0 g
s
.299 .544 .917 r
.33142 .41309 m .32141 .40961 L .3051 .38259 L p F P
0 g
s
.671 .966 .768 r
.67669 .44272 m .6678 .44825 L .68683 .42895 L p F P
0 g
s
.671 .966 .768 r
.68683 .42895 m .69701 .42216 L .67669 .44272 L p F P
0 g
s
0 .19 .607 r
.42116 .47497 m .41389 .47047 L .38996 .45542 L p F P
0 g
s
.408 .819 .622 r
.63535 .46935 m .62792 .47392 L .64978 .45968 L p F P
0 g
s
.408 .819 .622 r
.64978 .45968 m .65884 .45405 L .63535 .46935 L p F P
0 g
s
.805 .95 .915 r
.72736 .40748 m .71724 .41107 L .73183 .38527 L p F P
0 g
s
.805 .95 .915 r
.73183 .38527 m .74287 .38026 L .72736 .40748 L p F P
0 g
s
.281 0 0 r
.48396 .49735 m .48062 .49585 L .45312 .48896 L p F P
0 g
s
.265 0 0 r
.48062 .49585 m .48396 .49735 L .51092 .50051 L p F P
0 g
s
0 0 0 r
.56881 .49541 m .56527 .49694 L .59042 .49034 L p F P
0 g
s
0 0 0 r
.59042 .49034 m .5961 .48824 L .56881 .49541 L p F P
0 g
s
.299 .544 .917 r
.3051 .38259 m .31608 .38747 L .33142 .41309 L p F P
0 g
s
.184 .465 .887 r
.34143 .41798 m .33142 .41309 L .31608 .38747 L p F P
0 g
s
0 .28 .758 r
.35146 .42396 m .36153 .43064 L .38112 .44972 L p F P
0 g
s
.823 .98 .887 r
.71724 .41107 m .70713 .41607 L .72081 .3917 L p F P
0 g
s
.823 .98 .887 r
.72081 .3917 m .73183 .38527 L .71724 .41107 L p F P
0 g
s
.662 .96 .752 r
.6678 .44825 m .65884 .45405 L .67658 .43602 L p F P
0 g
s
.662 .96 .752 r
.67658 .43602 m .68683 .42895 L .6678 .44825 L p F P
0 g
s
0 .553 .756 r
.512 .50032 m .51092 .50051 L .48396 .49735 L p F P
0 g
s
.037 .607 .74 r
.51092 .50051 m .512 .50032 L .53712 .50019 L p F P
0 g
s
.037 .607 .74 r
.53712 .50019 m .5384 .50037 L .51092 .50051 L p F P
0 g
s
.146 .69 .759 r
.5384 .50037 m .53712 .50019 L .56168 .49706 L p F P
0 g
s
.146 .69 .759 r
.56168 .49706 m .56527 .49694 L .5384 .50037 L p F P
0 g
s
.391 0 0 r
.42116 .47497 m .42852 .47885 L .45312 .48896 L p F P
0 g
s
.281 0 0 r
.45312 .48896 m .45863 .491 L .48396 .49735 L p F P
0 g
s
0 .344 .685 r
.45863 .491 m .45312 .48896 L .42852 .47885 L p F P
0 g
s
.314 .789 .696 r
.5961 .48824 m .59042 .49034 L .61277 .48081 L p F P
0 g
s
.314 .789 .696 r
.61277 .48081 m .6204 .47788 L .5961 .48824 L p F P
0 g
s
0 .19 .607 r
.38996 .45542 m .39888 .46096 L .42116 .47497 L p F P
0 g
s
0 .265 .684 r
.42852 .47885 m .42116 .47497 L .39888 .46096 L p F P
0 g
s
.462 .866 .697 r
.62792 .47392 m .6204 .47788 L .64061 .46471 L p F P
0 g
s
.462 .866 .697 r
.64061 .46471 m .64978 .45968 L .62792 .47392 L p F P
0 g
s
.184 .465 .887 r
.31608 .38747 m .32704 .39378 L .34143 .41798 L p F P
0 g
s
.093 .4 .855 r
.35146 .42396 m .34143 .41798 L .32704 .39378 L p F P
0 g
s
0 .528 .803 r
.48736 .49743 m .48396 .49735 L .45863 .491 L p F P
0 g
s
0 .553 .756 r
.48396 .49735 m .48736 .49743 L .512 .50032 L p F P
0 g
s
.296 .793 .808 r
.56527 .49694 m .56168 .49706 L .58464 .49103 L p F P
0 g
s
.296 .793 .808 r
.58464 .49103 m .59042 .49034 L .56527 .49694 L p F P
0 g
s
.829 .994 .856 r
.70713 .41607 m .69701 .42216 L .70979 .39923 L p F P
0 g
s
.829 .994 .856 r
.70979 .39923 m .72081 .3917 L .70713 .41607 L p F P
0 g
s
0 .259 .741 r
.36153 .43064 m .37169 .4376 L .38996 .45542 L p F P
0 g
s
0 .28 .758 r
.39888 .46096 m .38996 .45542 L .37169 .4376 L p F P
0 g
s
.671 .966 .768 r
.65884 .45405 m .64978 .45968 L .66624 .44293 L p F P
0 g
s
.671 .966 .768 r
.66624 .44293 m .67658 .43602 L .65884 .45405 L p F P
0 g
s
.768 .814 .89 r
.23928 .3496 m .25146 .34644 L .26027 .38146 L p F P
0 g
s
.768 .814 .89 r
.26027 .38146 m .24872 .38609 L .23928 .3496 L p F P
0 g
s
.711 .781 .906 r
.27167 .37877 m .26027 .38146 L .25146 .34644 L p F P
0 g
s
.289 .738 .959 r
.5131 .49839 m .512 .50032 L .48736 .49743 L p F P
0 g
s
.334 .783 .956 r
.512 .50032 m .5131 .49839 L .53582 .49828 L p F P
0 g
s
.334 .783 .956 r
.53582 .49828 m .53712 .50019 L .512 .50032 L p F P
0 g
s
0 .344 .685 r
.42852 .47885 m .436 .4817 L .45863 .491 L p F P
0 g
s
.011 .524 .862 r
.46422 .49163 m .45863 .491 L .436 .4817 L p F P
0 g
s
0 .528 .803 r
.45863 .491 m .46422 .49163 L .48736 .49743 L p F P
0 g
s
.093 .4 .855 r
.32704 .39378 m .338 .40119 L .35146 .42396 L p F P
0 g
s
.035 .358 .831 r
.36153 .43064 m .35146 .42396 L .338 .40119 L p F P
0 g
s
.407 .833 .96 r
.53712 .50019 m .53582 .49828 L .55803 .49544 L p F P
0 g
s
.407 .833 .96 r
.55803 .49544 m .56168 .49706 L .53712 .50019 L p F P
0 g
s
.711 .781 .906 r
.25146 .34644 m .26346 .34525 L .27167 .37877 L p F P
0 g
s
.64 .735 .917 r
.28292 .37809 m .27167 .37877 L .26346 .34525 L p F P
0 g
s
.81 .837 .871 r
.22691 .35456 m .23928 .3496 L .24872 .38609 L p F P
0 g
s
.81 .837 .871 r
.24872 .38609 m .23701 .39251 L .22691 .35456 L p F P
0 g
s
.466 .891 .867 r
.59042 .49034 m .58464 .49103 L .60502 .48232 L p F P
0 g
s
.466 .891 .867 r
.60502 .48232 m .61277 .48081 L .59042 .49034 L p F P
0 g
s
0 .265 .684 r
.39888 .46096 m .40792 .46589 L .42852 .47885 L p F P
0 g
s
0 .387 .797 r
.436 .4817 m .42852 .47885 L .40792 .46589 L p F P
0 g
s
.64 .735 .917 r
.26346 .34525 m .27528 .34608 L .28292 .37809 L p F P
0 g
s
.557 .677 .919 r
.29406 .3794 m .28292 .37809 L .27528 .34608 L p F P
0 g
s
.542 .924 .805 r
.6204 .47788 m .61277 .48081 L .63132 .4687 L p F P
0 g
s
.542 .924 .805 r
.63132 .4687 m .64061 .46471 L .6204 .47788 L p F P
0 g
s
.83 .998 .834 r
.69701 .42216 m .68683 .42895 L .69873 .40747 L p F P
0 g
s
.83 .998 .834 r
.69873 .40747 m .70979 .39923 L .69701 .42216 L p F P
0 g
s
.84 .853 .854 r
.21435 .36111 m .22691 .35456 L .23701 .39251 L p F P
0 g
s
.84 .853 .854 r
.23701 .39251 m .22513 .40048 L .21435 .36111 L p F P
0 g
s
.551 .639 .891 r
.79959 .38316 m .78797 .37865 L .79573 .34349 L p F P
0 g
s
.611 .7 .907 r
.78797 .37865 m .77651 .37608 L .78371 .34242 L p F P
0 g
s
.611 .7 .907 r
.78371 .34242 m .79573 .34349 L .78797 .37865 L p F P
0 g
s
.675 .763 .917 r
.77651 .37608 m .76518 .37552 L .77186 .34338 L p F P
0 g
s
.675 .763 .917 r
.77186 .34338 m .78371 .34242 L .77651 .37608 L p F P
0 g
s
.274 .702 .967 r
.49081 .49577 m .48736 .49743 L .46422 .49163 L p F P
0 g
s
.289 .738 .959 r
.48736 .49743 m .49081 .49577 L .5131 .49839 L p F P
0 g
s
.498 .586 .873 r
.81138 .38946 m .79959 .38316 L .80794 .34651 L p F P
0 g
s
.551 .639 .891 r
.79573 .34349 m .80794 .34651 L .79959 .38316 L p F P
0 g
s
.496 .881 .968 r
.56168 .49706 m .55803 .49544 L .57878 .48998 L p F P
0 g
s
.496 .881 .968 r
.57878 .48998 m .58464 .49103 L .56168 .49706 L p F P
0 g
s
.557 .677 .919 r
.27528 .34608 m .28696 .34892 L .29406 .3794 L p F P
0 g
s
.468 .612 .91 r
.3051 .38259 m .29406 .3794 L .28696 .34892 L p F P
0 g
s
.736 .822 .918 r
.76518 .37552 m .75398 .37695 L .76016 .34635 L p F P
0 g
s
.736 .822 .918 r
.76016 .34635 m .77186 .34338 L .76518 .37552 L p F P
0 g
s
.861 .862 .839 r
.20162 .36893 m .21435 .36111 L .22513 .40048 L p F P
0 g
s
.861 .862 .839 r
.22513 .40048 m .21311 .40972 L .20162 .36893 L p F P
0 g
s
.455 .542 .856 r
.82332 .39733 m .81138 .38946 L .82033 .35135 L p F P
0 g
s
.498 .586 .873 r
.80794 .34651 m .82033 .35135 L .81138 .38946 L p F P
0 g
s
0 .28 .758 r
.37169 .4376 m .38193 .44439 L .39888 .46096 L p F P
0 g
s
0 .34 .804 r
.40792 .46589 m .39888 .46096 L .38193 .44439 L p F P
0 g
s
.79 .872 .908 r
.75398 .37695 m .74287 .38026 L .74857 .35122 L p F P
0 g
s
.79 .872 .908 r
.74857 .35122 m .76016 .34635 L .75398 .37695 L p F P
0 g
s
.694 .98 .812 r
.64978 .45968 m .64061 .46471 L .65578 .44923 L p F P
0 g
s
.694 .98 .812 r
.65578 .44923 m .66624 .44293 L .64978 .45968 L p F P
0 g
s
.035 .358 .831 r
.338 .40119 m .34899 .4093 L .36153 .43064 L p F P
0 g
s
.016 .343 .823 r
.37169 .4376 m .36153 .43064 L .34899 .4093 L p F P
0 g
s
.468 .612 .91 r
.28696 .34892 m .29853 .35365 L .3051 .38259 L p F P
0 g
s
.381 .546 .893 r
.31608 .38747 m .3051 .38259 L .29853 .35365 L p F P
0 g
s
.873 .867 .829 r
.18872 .37766 m .20162 .36893 L .21311 .40972 L p F P
0 g
s
.873 .867 .829 r
.21311 .40972 m .20097 .41984 L .18872 .37766 L p F P
0 g
s
.423 .508 .842 r
.83542 .40645 m .82332 .39733 L .83292 .35778 L p F P
0 g
s
.455 .542 .856 r
.82033 .35135 m .83292 .35778 L .82332 .39733 L p F P
0 g
s
.011 .524 .862 r
.436 .4817 m .44358 .48314 L .46422 .49163 L p F P
0 g
s
.287 .674 .973 r
.4699 .49052 m .46422 .49163 L .44358 .48314 L p F P
0 g
s
.274 .702 .967 r
.46422 .49163 m .4699 .49052 L .49081 .49577 L p F P
0 g
s
.52 .791 .995 r
.51421 .49449 m .5131 .49839 L .49081 .49577 L p F P
0 g
s
.544 .814 .996 r
.5131 .49839 m .51421 .49449 L .5345 .49438 L p F P
0 g
s
.544 .814 .996 r
.5345 .49438 m .53582 .49828 L .5131 .49839 L p F P
0 g
s
.575 .835 .994 r
.53582 .49828 m .5345 .49438 L .55433 .49184 L p F P
0 g
s
.575 .835 .994 r
.55433 .49184 m .55803 .49544 L .53582 .49828 L p F P
0 g
s
.83 .999 .826 r
.68683 .42895 m .67658 .43602 L .68761 .41598 L p F P
0 g
s
.83 .999 .826 r
.68761 .41598 m .69873 .40747 L .68683 .42895 L p F P
0 g
s
0 .387 .797 r
.40792 .46589 m .41708 .46979 L .436 .4817 L p F P
0 g
s
.094 .531 .908 r
.44358 .48314 m .436 .4817 L .41708 .46979 L p F P
0 g
s
.589 .916 .973 r
.58464 .49103 m .57878 .48998 L .59717 .48211 L p F P
0 g
s
.589 .916 .973 r
.59717 .48211 m .60502 .48232 L .58464 .49103 L p F P
0 g
s
.831 .909 .891 r
.74287 .38026 m .73183 .38527 L .73707 .35778 L p F P
0 g
s
.831 .909 .891 r
.73707 .35778 m .74857 .35122 L .74287 .38026 L p F P
0 g
s
.622 .956 .911 r
.61277 .48081 m .60502 .48232 L .62191 .47128 L p F P
0 g
s
.622 .956 .911 r
.62191 .47128 m .63132 .4687 L .61277 .48081 L p F P
0 g
s
.402 .486 .832 r
.84764 .41647 m .83542 .40645 L .84569 .36547 L p F P
0 g
s
.423 .508 .842 r
.83292 .35778 m .84569 .36547 L .83542 .40645 L p F P
0 g
s
.879 .869 .824 r
.17571 .38689 m .18872 .37766 L .20097 .41984 L p F P
0 g
s
.879 .869 .824 r
.20097 .41984 m .18873 .43045 L .17571 .38689 L p F P
0 g
s
.506 .767 .99 r
.49431 .49214 m .49081 .49577 L .4699 .49052 L p F P
0 g
s
.52 .791 .995 r
.49081 .49577 m .49431 .49214 L .51421 .49449 L p F P
0 g
s
.381 .546 .893 r
.29853 .35365 m .31002 .36009 L .31608 .38747 L p F P
0 g
s
.306 .487 .873 r
.32704 .39378 m .31608 .38747 L .31002 .36009 L p F P
0 g
s
.61 .85 .989 r
.55803 .49544 m .55433 .49184 L .57283 .48696 L p F P
0 g
s
.61 .85 .989 r
.57283 .48696 m .57878 .48998 L .55803 .49544 L p F P
0 g
s
0 .34 .804 r
.38193 .44439 m .39229 .45058 L .40792 .46589 L p F P
0 g
s
.03 .431 .868 r
.41708 .46979 m .40792 .46589 L .39229 .45058 L p F P
0 g
s
.861 .934 .871 r
.73183 .38527 m .72081 .3917 L .72561 .36579 L p F P
0 g
s
.861 .934 .871 r
.72561 .36579 m .73707 .35778 L .73183 .38527 L p F P
0 g
s
.391 .476 .827 r
.85995 .42697 m .84764 .41647 L .85861 .37409 L p F P
0 g
s
.402 .486 .832 r
.84569 .36547 m .85861 .37409 L .84764 .41647 L p F P
0 g
s
.016 .343 .823 r
.34899 .4093 m .36005 .41769 L .37169 .4376 L p F P
0 g
s
.035 .358 .831 r
.38193 .44439 m .37169 .4376 L .36005 .41769 L p F P
0 g
s
.721 .988 .871 r
.64061 .46471 m .63132 .4687 L .6452 .45449 L p F P
0 g
s
.721 .988 .871 r
.6452 .45449 m .65578 .44923 L .64061 .46471 L p F P
0 g
s
.83 .998 .834 r
.67658 .43602 m .66624 .44293 L .6764 .42433 L p F P
0 g
s
.83 .998 .834 r
.6764 .42433 m .68761 .41598 L .67658 .43602 L p F P
0 g
s
.306 .487 .873 r
.31002 .36009 m .32145 .36795 L .32704 .39378 L p F P
0 g
s
.248 .44 .853 r
.338 .40119 m .32704 .39378 L .32145 .36795 L p F P
0 g
s
.635 .765 .941 r
.51534 .48847 m .51421 .49449 L .49431 .49214 L p F P
0 g
s
.639 .769 .942 r
.51421 .49449 m .51534 .48847 L .53316 .48838 L p F P
0 g
s
.639 .769 .942 r
.53316 .48838 m .5345 .49438 L .51421 .49449 L p F P
0 g
s
.287 .674 .973 r
.44358 .48314 m .45127 .48284 L .4699 .49052 L p F P
0 g
s
.501 .744 .982 r
.47566 .48745 m .4699 .49052 L .45127 .48284 L p F P
0 g
s
.506 .767 .99 r
.4699 .49052 m .47566 .48745 L .49431 .49214 L p F P
0 g
s
.644 .772 .941 r
.5345 .49438 m .53316 .48838 L .55058 .48614 L p F P
0 g
s
.644 .772 .941 r
.55058 .48614 m .55433 .49184 L .5345 .49438 L p F P
0 g
s
.645 .86 .981 r
.57878 .48998 m .57283 .48696 L .58922 .47993 L p F P
0 g
s
.645 .86 .981 r
.58922 .47993 m .59717 .48211 L .57878 .48998 L p F P
0 g
s
.094 .531 .908 r
.41708 .46979 m .42636 .47227 L .44358 .48314 L p F P
0 g
s
.321 .652 .97 r
.45127 .48284 m .44358 .48314 L .42636 .47227 L p F P
0 g
s
.391 .476 .827 r
.85861 .37409 m .87166 .3832 L .85995 .42697 L p F P
0 g
s
.671 .933 .969 r
.60502 .48232 m .59717 .48211 L .61237 .47214 L p F P
0 g
s
.671 .933 .969 r
.61237 .47214 m .62191 .47128 L .60502 .48232 L p F P
0 g
s
.879 .948 .852 r
.72081 .3917 m .70979 .39923 L .71417 .37488 L p F P
0 g
s
.879 .948 .852 r
.71417 .37488 m .72561 .36579 L .72081 .3917 L p F P
0 g
s
.632 .761 .94 r
.49786 .4864 m .49431 .49214 L .47566 .48745 L p F P
0 g
s
.635 .765 .941 r
.49431 .49214 m .49786 .4864 L .51534 .48847 L p F P
0 g
s
.649 .775 .94 r
.55433 .49184 m .55058 .48614 L .56682 .48184 L p F P
0 g
s
.649 .775 .94 r
.56682 .48184 m .57283 .48696 L .55433 .49184 L p F P
0 g
s
.03 .431 .868 r
.39229 .45058 m .40277 .45573 L .41708 .46979 L p F P
0 g
s
.194 .537 .925 r
.42636 .47227 m .41708 .46979 L .40277 .45573 L p F P
0 g
s
.035 .358 .831 r
.36005 .41769 m .3712 .42592 L .38193 .44439 L p F P
0 g
s
.091 .4 .854 r
.39229 .45058 m .38193 .44439 L .3712 .42592 L p F P
0 g
s
.248 .44 .853 r
.32145 .36795 m .33287 .37692 L .338 .40119 L p F P
0 g
s
.213 .411 .84 r
.34899 .4093 m .338 .40119 L .33287 .37692 L p F P
0 g
s
.737 .974 .926 r
.63132 .4687 m .62191 .47128 L .63449 .45834 L p F P
0 g
s
.737 .974 .926 r
.63449 .45834 m .6452 .45449 L .63132 .4687 L p F P
0 g
s
.829 .994 .856 r
.66624 .44293 m .65578 .44923 L .66509 .43207 L p F P
0 g
s
.829 .994 .856 r
.66509 .43207 m .6764 .42433 L .66624 .44293 L p F P
0 g
s
.687 .727 .88 r
.51648 .48029 m .51534 .48847 L .49786 .4864 L p F P
0 g
s
.677 .718 .88 r
.51534 .48847 m .51648 .48029 L .53181 .48021 L p F P
0 g
s
.677 .718 .88 r
.53181 .48021 m .53316 .48838 L .51534 .48847 L p F P
0 g
s
.667 .71 .88 r
.53316 .48838 m .53181 .48021 L .54678 .47828 L p F P
0 g
s
.667 .71 .88 r
.54678 .47828 m .55058 .48614 L .53316 .48838 L p F P
0 g
s
.501 .744 .982 r
.45127 .48284 m .45907 .48059 L .47566 .48745 L p F P
0 g
s
.63 .757 .939 r
.48149 .48227 m .47566 .48745 L .45907 .48059 L p F P
0 g
s
.632 .761 .94 r
.47566 .48745 m .48149 .48227 L .49786 .4864 L p F P
0 g
s
.889 .956 .839 r
.70979 .39923 m .69873 .40747 L .7027 .38469 L p F P
0 g
s
.889 .956 .839 r
.7027 .38469 m .71417 .37488 L .70979 .39923 L p F P
0 g
s
.654 .776 .938 r
.57283 .48696 m .56682 .48184 L .58117 .47565 L p F P
0 g
s
.654 .776 .938 r
.58117 .47565 m .58922 .47993 L .57283 .48696 L p F P
0 g
s
.321 .652 .97 r
.42636 .47227 m .43577 .47303 L .45127 .48284 L p F P
0 g
s
.505 .723 .971 r
.45907 .48059 m .45127 .48284 L .43577 .47303 L p F P
0 g
s
.677 .862 .969 r
.59717 .48211 m .58922 .47993 L .60273 .47103 L p F P
0 g
s
.677 .862 .969 r
.60273 .47103 m .61237 .47214 L .59717 .48211 L p F P
0 g
s
.695 .737 .883 r
.50145 .47851 m .49786 .4864 L .48149 .48227 L p F P
0 g
s
.687 .727 .88 r
.49786 .4864 m .50145 .47851 L .51648 .48029 L p F P
0 g
s
.656 .705 .883 r
.55058 .48614 m .54678 .47828 L .56073 .47457 L p F P
0 g
s
.656 .705 .883 r
.56073 .47457 m .56682 .48184 L .55058 .48614 L p F P
0 g
s
.213 .411 .84 r
.33287 .37692 m .34432 .38659 L .34899 .4093 L p F P
0 g
s
.201 .401 .835 r
.36005 .41769 m .34899 .4093 L .34432 .38659 L p F P
0 g
s
.194 .537 .925 r
.40277 .45573 m .41338 .45947 L .42636 .47227 L p F P
0 g
s
.365 .634 .957 r
.43577 .47303 m .42636 .47227 L .41338 .45947 L p F P
0 g
s
.091 .4 .854 r
.3712 .42592 m .38245 .43353 L .39229 .45058 L p F P
0 g
s
.179 .464 .886 r
.40277 .45573 m .39229 .45058 L .38245 .43353 L p F P
0 g
s
.731 .928 .956 r
.62191 .47128 m .61237 .47214 L .62367 .46046 L p F P
0 g
s
.731 .928 .956 r
.62367 .46046 m .63449 .45834 L .62191 .47128 L p F P
0 g
s
.711 .694 .832 r
.51763 .47003 m .51648 .48029 L .50145 .47851 L p F P
0 g
s
.693 .677 .831 r
.51648 .48029 m .51763 .47003 L .53045 .46996 L p F P
0 g
s
.693 .677 .831 r
.53045 .46996 m .53181 .48021 L .51648 .48029 L p F P
0 g
s
.673 .663 .832 r
.53181 .48021 m .53045 .46996 L .54295 .46834 L p F P
0 g
s
.673 .663 .832 r
.54295 .46834 m .54678 .47828 L .53181 .48021 L p F P
0 g
s
.892 .958 .835 r
.69873 .40747 m .68761 .41598 L .6912 .39477 L p F P
0 g
s
.892 .958 .835 r
.6912 .39477 m .7027 .38469 L .69873 .40747 L p F P
0 g
s
.63 .757 .939 r
.45907 .48059 m .46695 .47622 L .48149 .48227 L p F P
0 g
s
.702 .748 .887 r
.48739 .47494 m .48149 .48227 L .46695 .47622 L p F P
0 g
s
.695 .737 .883 r
.48149 .48227 m .48739 .47494 L .50145 .47851 L p F P
0 g
s
.822 .981 .886 r
.65578 .44923 m .6452 .45449 L .65366 .43876 L p F P
0 g
s
.822 .981 .886 r
.65366 .43876 m .66509 .43207 L .65578 .44923 L p F P
0 g
s
.644 .701 .888 r
.56682 .48184 m .56073 .47457 L .57305 .46923 L p F P
0 g
s
.644 .701 .888 r
.57305 .46923 m .58117 .47565 L .56682 .48184 L p F P
0 g
s
.505 .723 .971 r
.43577 .47303 m .44528 .47183 L .45907 .48059 L p F P
0 g
s
.629 .752 .936 r
.46695 .47622 m .45907 .48059 L .44528 .47183 L p F P
0 g
s
.728 .713 .836 r
.50508 .46853 m .50145 .47851 L .48739 .47494 L p F P
0 g
s
.711 .694 .832 r
.50145 .47851 m .50508 .46853 L .51763 .47003 L p F P
0 g
s
.659 .776 .936 r
.58922 .47993 m .58117 .47565 L .59299 .46782 L p F P
0 g
s
.659 .776 .936 r
.59299 .46782 m .60273 .47103 L .58922 .47993 L p F P
0 g
s
.653 .652 .837 r
.54678 .47828 m .54295 .46834 L .5546 .46522 L p F P
0 g
s
.653 .652 .837 r
.5546 .46522 m .56073 .47457 L .54678 .47828 L p F P
0 g
s
.643 .732 .914 r
.26737 .31082 m .27923 .31326 L .27528 .34608 L p F P
0 g
s
.643 .732 .914 r
.27528 .34608 m .26346 .34525 L .26737 .31082 L p F P
0 g
s
.574 .67 .903 r
.28696 .34892 m .27528 .34608 L .27923 .31326 L p F P
0 g
s
.706 .789 .916 r
.25533 .31041 m .26737 .31082 L .26346 .34525 L p F P
0 g
s
.706 .789 .916 r
.26346 .34525 m .25146 .34644 L .25533 .31041 L p F P
0 g
s
.574 .67 .903 r
.27923 .31326 m .29092 .31771 L .28696 .34892 L p F P
0 g
s
.508 .607 .887 r
.29853 .35365 m .28696 .34892 L .29092 .31771 L p F P
0 g
s
.761 .837 .91 r
.24308 .31199 m .25533 .31041 L .25146 .34644 L p F P
0 g
s
.761 .837 .91 r
.25146 .34644 m .23928 .3496 L .24308 .31199 L p F P
0 g
s
.201 .401 .835 r
.34432 .38659 m .35581 .39654 L .36005 .41769 L p F P
0 g
s
.213 .411 .84 r
.3712 .42592 m .36005 .41769 L .35581 .39654 L p F P
0 g
s
.677 .76 .914 r
.78371 .34242 m .77186 .34338 L .7669 .31056 L p F P
0 g
s
.741 .804 .902 r
.77186 .34338 m .76016 .34635 L .75524 .31515 L p F P
0 g
s
.741 .804 .902 r
.75524 .31515 m .7669 .31056 L .77186 .34338 L p F P
0 g
s
.604 .707 .917 r
.79573 .34349 m .78371 .34242 L .77873 .30798 L p F P
0 g
s
.677 .76 .914 r
.7669 .31056 m .77873 .30798 L .78371 .34242 L p F P
0 g
s
.723 .67 .797 r
.5188 .45784 m .51763 .47003 L .50508 .46853 L p F P
0 g
s
.7 .648 .795 r
.51763 .47003 m .5188 .45784 L .52907 .45779 L p F P
0 g
s
.7 .648 .795 r
.52907 .45779 m .53045 .46996 L .51763 .47003 L p F P
0 g
s
.675 .63 .797 r
.53045 .46996 m .52907 .45779 L .53909 .45648 L p F P
0 g
s
.675 .63 .797 r
.53909 .45648 m .54295 .46834 L .53045 .46996 L p F P
0 g
s
.365 .634 .957 r
.41338 .45947 m .42411 .46148 L .43577 .47303 L p F P
0 g
s
.515 .705 .957 r
.44528 .47183 m .43577 .47303 L .42411 .46148 L p F P
0 g
s
.508 .607 .887 r
.29092 .31771 m .30248 .32407 L .29853 .35365 L p F P
0 g
s
.448 .55 .867 r
.31002 .36009 m .29853 .35365 L .30248 .32407 L p F P
0 g
s
.702 .748 .887 r
.46695 .47622 m .47491 .46972 L .48739 .47494 L p F P
0 g
s
.742 .734 .844 r
.49334 .46553 m .48739 .47494 L .47491 .46972 L p F P
0 g
s
.728 .713 .836 r
.48739 .47494 m .49334 .46553 L .50508 .46853 L p F P
0 g
s
.805 .873 .897 r
.23062 .31539 m .24308 .31199 L .23928 .3496 L p F P
0 g
s
.805 .873 .897 r
.23928 .3496 m .22691 .35456 L .23062 .31539 L p F P
0 g
s
.794 .838 .885 r
.76016 .34635 m .74857 .35122 L .74371 .32165 L p F P
0 g
s
.794 .838 .885 r
.74371 .32165 m .75524 .31515 L .76016 .34635 L p F P
0 g
s
.631 .643 .844 r
.56073 .47457 m .5546 .46522 L .56486 .46073 L p F P
0 g
s
.631 .643 .844 r
.56486 .46073 m .57305 .46923 L .56073 .47457 L p F P
0 g
s
.703 .856 .955 r
.61237 .47214 m .60273 .47103 L .61273 .46062 L p F P
0 g
s
.703 .856 .955 r
.61273 .46062 m .62367 .46046 L .61237 .47214 L p F P
0 g
s
.179 .464 .886 r
.38245 .43353 m .39382 .4401 L .40277 .45573 L p F P
0 g
s
.291 .541 .917 r
.41338 .45947 m .40277 .45573 L .39382 .4401 L p F P
0 g
s
.529 .65 .911 r
.80794 .34651 m .79573 .34349 L .79075 .30745 L p F P
0 g
s
.604 .707 .917 r
.77873 .30798 m .79075 .30745 L .79573 .34349 L p F P
0 g
s
.889 .956 .839 r
.68761 .41598 m .6764 .42433 L .67962 .40467 L p F P
0 g
s
.889 .956 .839 r
.67962 .40467 m .6912 .39477 L .68761 .41598 L p F P
0 g
s
.746 .694 .802 r
.50873 .45663 m .50508 .46853 L .49334 .46553 L p F P
0 g
s
.723 .67 .797 r
.50508 .46853 m .50873 .45663 L .5188 .45784 L p F P
0 g
s
.629 .752 .936 r
.44528 .47183 m .45489 .46852 L .46695 .47622 L p F P
0 g
s
.707 .759 .893 r
.47491 .46972 m .46695 .47622 L .45489 .46852 L p F P
0 g
s
.648 .614 .802 r
.54295 .46834 m .53909 .45648 L .54842 .45396 L p F P
0 g
s
.648 .614 .802 r
.54842 .45396 m .5546 .46522 L .54295 .46834 L p F P
0 g
s
.632 .699 .894 r
.58117 .47565 m .57305 .46923 L .58316 .46248 L p F P
0 g
s
.632 .699 .894 r
.58316 .46248 m .59299 .46782 L .58117 .47565 L p F P
0 g
s
.803 .953 .915 r
.6452 .45449 m .63449 .45834 L .64212 .44404 L p F P
0 g
s
.803 .953 .915 r
.64212 .44404 m .65366 .43876 L .6452 .45449 L p F P
0 g
s
.835 .862 .865 r
.74857 .35122 m .73707 .35778 L .73228 .32985 L p F P
0 g
s
.835 .862 .865 r
.73228 .32985 m .74371 .32165 L .74857 .35122 L p F P
0 g
s
.448 .55 .867 r
.30248 .32407 m .31393 .33214 L .31002 .36009 L p F P
0 g
s
.4 .503 .848 r
.32145 .36795 m .31002 .36009 L .31393 .33214 L p F P
0 g
s
.458 .593 .9 r
.82033 .35135 m .80794 .34651 L .80298 .30889 L p F P
0 g
s
.529 .65 .911 r
.79075 .30745 m .80298 .30889 L .80794 .34651 L p F P
0 g
s
.837 .898 .883 r
.21794 .32038 m .23062 .31539 L .22691 .35456 L p F P
0 g
s
.837 .898 .883 r
.22691 .35456 m .21435 .36111 L .21794 .32038 L p F P
0 g
s
.73 .652 .772 r
.51997 .444 m .5188 .45784 L .50873 .45663 L p F P
0 g
s
.703 .628 .77 r
.5188 .45784 m .51997 .444 L .52769 .44396 L p F P
0 g
s
.703 .628 .77 r
.52769 .44396 m .52907 .45779 L .5188 .45784 L p F P
0 g
s
.674 .607 .772 r
.52907 .45779 m .52769 .44396 L .53522 .44297 L p F P
0 g
s
.674 .607 .772 r
.53522 .44297 m .53909 .45648 L .52907 .45779 L p F P
0 g
s
.742 .734 .844 r
.47491 .46972 m .48294 .46115 L .49334 .46553 L p F P
0 g
s
.766 .721 .81 r
.49933 .45421 m .49334 .46553 L .48294 .46115 L p F P
0 g
s
.746 .694 .802 r
.49334 .46553 m .49933 .45421 L .50873 .45663 L p F P
0 g
s
.618 .601 .811 r
.5546 .46522 m .54842 .45396 L .55663 .45035 L p F P
0 g
s
.618 .601 .811 r
.55663 .45035 m .56486 .46073 L .5546 .46522 L p F P
0 g
s
.756 .68 .777 r
.51241 .44309 m .50873 .45663 L .49933 .45421 L p F P
0 g
s
.73 .652 .772 r
.50873 .45663 m .51241 .44309 L .51997 .444 L p F P
0 g
s
.515 .705 .957 r
.42411 .46148 m .43496 .46153 L .44528 .47183 L p F P
0 g
s
.629 .748 .933 r
.45489 .46852 m .44528 .47183 L .43496 .46153 L p F P
0 g
s
.643 .588 .778 r
.53909 .45648 m .53522 .44297 L .54222 .44106 L p F P
0 g
s
.643 .588 .778 r
.54222 .44106 m .54842 .45396 L .53909 .45648 L p F P
0 g
s
.864 .877 .846 r
.73707 .35778 m .72561 .36579 L .72092 .33948 L p F P
0 g
s
.864 .877 .846 r
.72092 .33948 m .73228 .32985 L .73707 .35778 L p F P
0 g
s
.213 .411 .84 r
.35581 .39654 m .36737 .40631 L .3712 .42592 L p F P
0 g
s
.247 .44 .853 r
.38245 .43353 m .3712 .42592 L .36737 .40631 L p F P
0 g
s
.707 .759 .893 r
.45489 .46852 m .46459 .46308 L .47491 .46972 L p F P
0 g
s
.755 .757 .854 r
.48294 .46115 m .47491 .46972 L .46459 .46308 L p F P
0 g
s
.663 .776 .933 r
.60273 .47103 m .59299 .46782 L .6017 .45868 L p F P
0 g
s
.663 .776 .933 r
.6017 .45868 m .61273 .46062 L .60273 .47103 L p F P
0 g
s
.607 .637 .855 r
.57305 .46923 m .56486 .46073 L .57327 .45508 L p F P
0 g
s
.607 .637 .855 r
.57327 .45508 m .58316 .46248 L .57305 .46923 L p F P
0 g
s
.396 .543 .885 r
.83292 .35778 m .82033 .35135 L .81541 .31216 L p F P
0 g
s
.458 .593 .9 r
.80298 .30889 m .81541 .31216 L .82033 .35135 L p F P
0 g
s
.291 .541 .917 r
.39382 .4401 m .40531 .44525 L .41338 .45947 L p F P
0 g
s
.413 .62 .937 r
.42411 .46148 m .41338 .45947 L .40531 .44525 L p F P
0 g
s
.4 .503 .848 r
.31393 .33214 m .32532 .34164 L .32145 .36795 L p F P
0 g
s
.364 .468 .832 r
.33287 .37692 m .32145 .36795 L .32532 .34164 L p F P
0 g
s
.734 .641 .755 r
.52114 .42884 m .51997 .444 L .51241 .44309 L p F P
0 g
s
.704 .615 .754 r
.51997 .444 m .52114 .42884 L .5263 .42882 L p F P
0 g
s
.704 .615 .754 r
.5263 .42882 m .52769 .44396 L .51997 .444 L p F P
0 g
s
.673 .591 .756 r
.52769 .44396 m .5263 .42882 L .53132 .42815 L p F P
0 g
s
.673 .591 .756 r
.53132 .42815 m .53522 .44297 L .52769 .44396 L p F P
0 g
s
.879 .949 .852 r
.6764 .42433 m .66509 .43207 L .66795 .41396 L p F P
0 g
s
.879 .949 .852 r
.66795 .41396 m .67962 .40467 L .6764 .42433 L p F P
0 g
s
.858 .914 .868 r
.20506 .32667 m .21794 .32038 L .21435 .36111 L p F P
0 g
s
.858 .914 .868 r
.21435 .36111 m .20162 .36893 L .20506 .32667 L p F P
0 g
s
.766 .721 .81 r
.48294 .46115 m .49101 .45068 L .49933 .45421 L p F P
0 g
s
.781 .711 .786 r
.50535 .44125 m .49933 .45421 L .49101 .45068 L p F P
0 g
s
.756 .68 .777 r
.49933 .45421 m .50535 .44125 L .51241 .44309 L p F P
0 g
s
.609 .571 .787 r
.54842 .45396 m .54222 .44106 L .54837 .43833 L p F P
0 g
s
.609 .571 .787 r
.54837 .43833 m .55663 .45035 L .54842 .45396 L p F P
0 g
s
.77 .907 .935 r
.63449 .45834 m .62367 .46046 L .63046 .44758 L p F P
0 g
s
.77 .907 .935 r
.63046 .44758 m .64212 .44404 L .63449 .45834 L p F P
0 g
s
.762 .67 .76 r
.5161 .42823 m .51241 .44309 L .50535 .44125 L p F P
0 g
s
.734 .641 .755 r
.51241 .44309 m .5161 .42823 L .52114 .42884 L p F P
0 g
s
.639 .57 .761 r
.53522 .44297 m .53132 .42815 L .53599 .42687 L p F P
0 g
s
.639 .57 .761 r
.53599 .42687 m .54222 .44106 L .53522 .44297 L p F P
0 g
s
.755 .757 .854 r
.46459 .46308 m .47435 .45558 L .48294 .46115 L p F P
0 g
s
.785 .752 .823 r
.49101 .45068 m .48294 .46115 L .47435 .45558 L p F P
0 g
s
.882 .886 .83 r
.72561 .36579 m .71417 .37488 L .70959 .35021 L p F P
0 g
s
.882 .886 .83 r
.70959 .35021 m .72092 .33948 L .72561 .36579 L p F P
0 g
s
.586 .591 .824 r
.56486 .46073 m .55663 .45035 L .56334 .44579 L p F P
0 g
s
.586 .591 .824 r
.56334 .44579 m .57327 .45508 L .56486 .46073 L p F P
0 g
s
.629 .748 .933 r
.43496 .46153 m .4459 .45948 L .45489 .46852 L p F P
0 g
s
.71 .771 .9 r
.46459 .46308 m .45489 .46852 L .4459 .45948 L p F P
0 g
s
.736 .633 .745 r
.52232 .41276 m .52114 .42884 L .5161 .42823 L p F P
0 g
s
.705 .606 .744 r
.52114 .42884 m .52232 .41276 L .5249 .41275 L p F P
0 g
s
.705 .606 .744 r
.5249 .41275 m .5263 .42882 L .52114 .42884 L p F P
0 g
s
.672 .582 .745 r
.5263 .42882 m .5249 .41275 L .52742 .41241 L p F P
0 g
s
.672 .582 .745 r
.52742 .41241 m .53132 .42815 L .5263 .42882 L p F P
0 g
s
.781 .711 .786 r
.49101 .45068 m .49911 .43859 L .50535 .44125 L p F P
0 g
s
.79 .703 .769 r
.51139 .42699 m .50535 .44125 L .49911 .43859 L p F P
0 g
s
.762 .67 .76 r
.50535 .44125 m .51139 .42699 L .5161 .42823 L p F P
0 g
s
.602 .551 .77 r
.54222 .44106 m .53599 .42687 L .54009 .42503 L p F P
0 g
s
.602 .551 .77 r
.54009 .42503 m .54837 .43833 L .54222 .44106 L p F P
0 g
s
.62 .699 .901 r
.59299 .46782 m .58316 .46248 L .59059 .45462 L p F P
0 g
s
.62 .699 .901 r
.59059 .45462 m .6017 .45868 L .59299 .46782 L p F P
0 g
s
.766 .664 .75 r
.5198 .41245 m .5161 .42823 L .51139 .42699 L p F P
0 g
s
.736 .633 .745 r
.5161 .42823 m .5198 .41245 L .52232 .41276 L p F P
0 g
s
.637 .559 .751 r
.53132 .42815 m .52742 .41241 L .52975 .41176 L p F P
0 g
s
.637 .559 .751 r
.52975 .41176 m .53599 .42687 L .53132 .42815 L p F P
0 g
s
.349 .503 .871 r
.84569 .36547 m .83292 .35778 L .82807 .31702 L p F P
0 g
s
.396 .543 .885 r
.81541 .31216 m .82807 .31702 L .83292 .35778 L p F P
0 g
s
.364 .468 .832 r
.32532 .34164 m .33667 .35223 L .33287 .37692 L p F P
0 g
s
.343 .447 .823 r
.34432 .38659 m .33287 .37692 L .33667 .35223 L p F P
0 g
s
.785 .752 .823 r
.47435 .45558 m .48416 .4462 L .49101 .45068 L p F P
0 g
s
.804 .746 .799 r
.49911 .43859 m .49101 .45068 L .48416 .4462 L p F P
0 g
s
.247 .44 .853 r
.36737 .40631 m .37903 .41547 L .38245 .43353 L p F P
0 g
s
.303 .485 .873 r
.39382 .4401 m .38245 .43353 L .37903 .41547 L p F P
0 g
s
.79 .703 .769 r
.49911 .43859 m .50724 .4252 L .51139 .42699 L p F P
0 g
s
.795 .699 .759 r
.51744 .41183 m .51139 .42699 L .50724 .4252 L p F P
0 g
s
.766 .664 .75 r
.51139 .42699 m .51744 .41183 L .5198 .41245 L p F P
0 g
s
.57 .557 .8 r
.55663 .45035 m .54837 .43833 L .55338 .43489 L p F P
0 g
s
.57 .557 .8 r
.55338 .43489 m .56334 .44579 L .55663 .45035 L p F P
0 g
s
.597 .538 .759 r
.53599 .42687 m .52975 .41176 L .5318 .41084 L p F P
0 g
s
.597 .538 .759 r
.5318 .41084 m .54009 .42503 L .53599 .42687 L p F P
0 g
s
.737 .63 .74 r
.52351 .3962 m .52232 .41276 L .5198 .41245 L closepath p F P
0 g
s
.705 .602 .739 r
.52351 .3962 m .5249 .41275 L .52232 .41276 L closepath p F P
0 g
s
.672 .577 .741 r
.52351 .3962 m .52742 .41241 L .5249 .41275 L closepath p F P
0 g
s
.413 .62 .937 r
.40531 .44525 m .41691 .44867 L .42411 .46148 L p F P
0 g
s
.53 .69 .941 r
.43496 .46153 m .42411 .46148 L .41691 .44867 L p F P
0 g
s
.767 .661 .745 r
.52351 .3962 m .5198 .41245 L .51744 .41183 L closepath p F P
0 g
s
.635 .554 .746 r
.52351 .3962 m .52975 .41176 L .52742 .41241 L closepath p F P
0 g
s
.872 .924 .858 r
.192 .33388 m .20506 .32667 L .20162 .36893 L p F P
0 g
s
.872 .924 .858 r
.20162 .36893 m .18872 .37766 L .192 .33388 L p F P
0 g
s
.71 .771 .9 r
.4459 .45948 m .45691 .4553 L .46459 .46308 L p F P
0 g
s
.764 .782 .868 r
.47435 .45558 m .46459 .46308 L .45691 .4553 L p F P
0 g
s
.804 .746 .799 r
.48416 .4462 m .49399 .4352 L .49911 .43859 L p F P
0 g
s
.816 .742 .782 r
.50724 .4252 m .49911 .43859 L .49399 .4352 L p F P
0 g
s
.795 .699 .759 r
.50724 .4252 m .51537 .41092 L .51744 .41183 L p F P
0 g
s
.797 .697 .754 r
.52351 .3962 m .51744 .41183 L .51537 .41092 L closepath p F P
0 g
s
.595 .532 .754 r
.52351 .3962 m .5318 .41084 L .52975 .41176 L closepath p F P
0 g
s
.723 .845 .94 r
.62367 .46046 m .61273 .46062 L .61871 .44916 L p F P
0 g
s
.723 .845 .94 r
.61871 .44916 m .63046 .44758 L .62367 .46046 L p F P
0 g
s
.559 .533 .783 r
.54837 .43833 m .54009 .42503 L .54342 .42272 L p F P
0 g
s
.559 .533 .783 r
.54342 .42272 m .55338 .43489 L .54837 .43833 L p F P
0 g
s
.861 .935 .871 r
.66509 .43207 m .65366 .43876 L .65618 .42219 L p F P
0 g
s
.861 .935 .871 r
.65618 .42219 m .66795 .41396 L .66509 .43207 L p F P
0 g
s
.893 .891 .821 r
.71417 .37488 m .7027 .38469 L .69826 .36164 L p F P
0 g
s
.893 .891 .821 r
.69826 .36164 m .70959 .35021 L .71417 .37488 L p F P
0 g
s
.582 .635 .869 r
.58316 .46248 m .57327 .45508 L .57943 .4485 L p F P
0 g
s
.582 .635 .869 r
.57943 .4485 m .59059 .45462 L .58316 .46248 L p F P
0 g
s
.816 .742 .782 r
.49399 .4352 m .50383 .42293 L .50724 .4252 L p F P
0 g
s
.824 .739 .771 r
.51537 .41092 m .50724 .4252 L .50383 .42293 L p F P
0 g
s
.551 .519 .772 r
.54009 .42503 m .5318 .41084 L .53346 .40967 L p F P
0 g
s
.551 .519 .772 r
.53346 .40967 m .54342 .42272 L .54009 .42503 L p F P
0 g
s
.824 .739 .771 r
.50383 .42293 m .51367 .40978 L .51537 .41092 L p F P
0 g
s
.827 .738 .766 r
.52351 .3962 m .51537 .41092 L .51367 .40978 L closepath p F P
0 g
s
0 .301 .762 r
.52351 .3962 m .53258 .40117 L .53405 .40242 L closepath p F P
0 g
s
0 .23 .622 r
.52351 .3962 m .53069 .40012 L .53258 .40117 L closepath p F P
0 g
s
.018 .367 .837 r
.52351 .3962 m .53405 .40242 L .53503 .40384 L closepath p F P
0 g
s
.416 0 0 r
.52351 .3962 m .52845 .39935 L .53069 .40012 L closepath p F P
0 g
s
.418 .469 .806 r
.52351 .3962 m .53533 .40686 L .53465 .40833 L closepath p F P
0 g
s
.322 .445 .83 r
.52351 .3962 m .53546 .40534 L .53533 .40686 L closepath p F P
0 g
s
.191 .413 .848 r
.52351 .3962 m .53503 .40384 L .53546 .40534 L closepath p F P
0 g
s
.419 0 0 r
.52351 .3962 m .52598 .39887 L .52845 .39935 L closepath p F P
0 g
s
.548 .511 .767 r
.52351 .3962 m .53346 .40967 L .5318 .41084 L closepath p F P
0 g
s
.49 .491 .785 r
.52351 .3962 m .53465 .40833 L .53346 .40967 L closepath p F P
0 g
s
.366 0 0 r
.52351 .3962 m .52339 .39872 L .52598 .39887 L closepath p F P
0 g
s
.879 .842 .804 r
.52351 .3962 m .51243 .40844 L .51171 .40698 L closepath p F P
0 g
s
.855 .786 .783 r
.52351 .3962 m .51367 .40978 L .51243 .40844 L closepath p F P
0 g
s
.266 0 0 r
.52351 .3962 m .52081 .3989 L .52339 .39872 L closepath p F P
0 g
s
.803 .999 .84 r
.52351 .3962 m .51192 .40396 L .51285 .40254 L closepath p F P
0 g
s
.878 .967 .847 r
.52351 .3962 m .51154 .40547 L .51192 .40396 L closepath p F P
0 g
s
.892 .905 .829 r
.52351 .3962 m .51171 .40698 L .51154 .40547 L closepath p F P
0 g
s
.115 0 0 r
.52351 .3962 m .51836 .3994 L .52081 .3989 L closepath p F P
0 g
s
.366 .802 .636 r
.52351 .3962 m .51428 .40126 L .51614 .4002 L closepath p F P
0 g
s
.628 .952 .772 r
.52351 .3962 m .51285 .40254 L .51428 .40126 L closepath p F P
0 g
s
0 0 0 r
.52351 .3962 m .51614 .4002 L .51836 .3994 L closepath p F P
0 g
s
.764 .782 .868 r
.45691 .4553 m .46799 .44907 L .47435 .45558 L p F P
0 g
s
.801 .786 .839 r
.48416 .4462 m .47435 .45558 L .46799 .44907 L p F P
0 g
s
.851 .786 .788 r
.50134 .42027 m .51243 .40844 L .51367 .40978 L p F P
0 g
s
.851 .786 .788 r
.51367 .40978 m .50383 .42293 L .50134 .42027 L p F P
0 g
s
.496 .499 .79 r
.54342 .42272 m .53346 .40967 L .53465 .40833 L p F P
0 g
s
.55 .584 .841 r
.57327 .45508 m .56334 .44579 L .56824 .4405 L p F P
0 g
s
.55 .584 .841 r
.56824 .4405 m .57943 .4485 L .57327 .45508 L p F P
0 g
s
.316 .476 .86 r
.85861 .37409 m .84569 .36547 L .84093 .32318 L p F P
0 g
s
.349 .503 .871 r
.82807 .31702 m .84093 .32318 L .84569 .36547 L p F P
0 g
s
.841 .787 .799 r
.49022 .43125 m .50134 .42027 L .50383 .42293 L p F P
0 g
s
.841 .787 .799 r
.50383 .42293 m .49399 .4352 L .49022 .43125 L p F P
0 g
s
.801 .786 .839 r
.46799 .44907 m .4791 .44096 L .48416 .4462 L p F P
0 g
s
.825 .787 .816 r
.49399 .4352 m .48416 .4462 L .4791 .44096 L p F P
0 g
s
.53 .69 .941 r
.41691 .44867 m .42862 .45013 L .43496 .46153 L p F P
0 g
s
.63 .745 .93 r
.4459 .45948 m .43496 .46153 L .42862 .45013 L p F P
0 g
s
.508 .517 .801 r
.55338 .43489 m .54342 .42272 L .54583 .42004 L p F P
0 g
s
.496 .499 .79 r
.53465 .40833 m .54583 .42004 L .54342 .42272 L p F P
0 g
s
.343 .447 .823 r
.33667 .35223 m .34803 .36353 L .34432 .38659 L p F P
0 g
s
.336 .44 .819 r
.35581 .39654 m .34432 .38659 L .34803 .36353 L p F P
0 g
s
.825 .787 .816 r
.4791 .44096 m .49022 .43125 L .49399 .4352 L p F P
0 g
s
.873 .841 .81 r
.49987 .41737 m .51171 .40698 L .51243 .40844 L p F P
0 g
s
.873 .841 .81 r
.51243 .40844 m .50134 .42027 L .49987 .41737 L p F P
0 g
s
.526 .545 .818 r
.56334 .44579 m .55338 .43489 L .55703 .4309 L p F P
0 g
s
.526 .545 .818 r
.55703 .4309 m .56824 .4405 L .56334 .44579 L p F P
0 g
s
.427 .48 .812 r
.54583 .42004 m .53465 .40833 L .53533 .40686 L p F P
0 g
s
.508 .517 .801 r
.54583 .42004 m .55703 .4309 L .55338 .43489 L p F P
0 g
s
.667 .774 .93 r
.61273 .46062 m .6017 .45868 L .60687 .44863 L p F P
0 g
s
.667 .774 .93 r
.60687 .44863 m .61871 .44916 L .61273 .46062 L p F P
0 g
s
.303 .485 .873 r
.37903 .41547 m .39078 .42357 L .39382 .4401 L p F P
0 g
s
.375 .544 .894 r
.40531 .44525 m .39382 .4401 L .39078 .42357 L p F P
0 g
s
.878 .928 .852 r
.17879 .3416 m .192 .33388 L .18872 .37766 L p F P
0 g
s
.878 .928 .852 r
.18872 .37766 m .17571 .38689 L .17879 .3416 L p F P
0 g
s
.886 .902 .835 r
.4995 .41434 m .51154 .40547 L .51171 .40698 L p F P
0 g
s
.886 .902 .835 r
.51171 .40698 m .49987 .41737 L .4995 .41434 L p F P
0 g
s
.427 .48 .812 r
.53533 .40686 m .54721 .41712 L .54583 .42004 L p F P
0 g
s
.337 .459 .837 r
.54721 .41712 m .53533 .40686 L .53546 .40534 L p F P
0 g
s
.896 .892 .817 r
.7027 .38469 m .6912 .39477 L .68691 .37334 L p F P
0 g
s
.896 .892 .817 r
.68691 .37334 m .69826 .36164 L .7027 .38469 L p F P
0 g
s
.831 .912 .892 r
.65366 .43876 m .64212 .44404 L .64431 .42899 L p F P
0 g
s
.831 .912 .892 r
.64431 .42899 m .65618 .42219 L .65366 .43876 L p F P
0 g
s
.861 .838 .821 r
.48798 .42691 m .49987 .41737 L .50134 .42027 L p F P
0 g
s
.861 .838 .821 r
.50134 .42027 m .49022 .43125 L .48798 .42691 L p F P
0 g
s
.445 .502 .824 r
.55703 .4309 m .54583 .42004 L .54721 .41712 L p F P
0 g
s
.63 .745 .93 r
.42862 .45013 m .44041 .44949 L .4459 .45948 L p F P
0 g
s
.71 .783 .909 r
.45691 .4553 m .4459 .45948 L .44041 .44949 L p F P
0 g
s
.872 .962 .856 r
.50025 .41133 m .51192 .40396 L .51154 .40547 L p F P
0 g
s
.872 .962 .856 r
.51154 .40547 m .4995 .41434 L .50025 .41133 L p F P
0 g
s
.337 .459 .837 r
.53546 .40534 m .54748 .41409 L .54721 .41712 L p F P
0 g
s
.215 .433 .857 r
.54748 .41409 m .53546 .40534 L .53503 .40384 L p F P
0 g
s
.609 .702 .91 r
.6017 .45868 m .59059 .45462 L .59497 .44598 L p F P
0 g
s
.609 .702 .91 r
.59497 .44598 m .60687 .44863 L .6017 .45868 L p F P
0 g
s
.841 .833 .838 r
.47607 .4352 m .48798 .42691 L .49022 .43125 L p F P
0 g
s
.841 .833 .838 r
.49022 .43125 m .4791 .44096 L .47607 .4352 L p F P
0 g
s
.473 .535 .84 r
.56824 .4405 m .55703 .4309 L .55913 .42654 L p F P
0 g
s
.445 .502 .824 r
.54721 .41712 m .55913 .42654 L .55703 .4309 L p F P
0 g
s
.804 .997 .855 r
.5021 .40848 m .51285 .40254 L .51192 .40396 L p F P
0 g
s
.804 .997 .855 r
.51192 .40396 m .50025 .41133 L .5021 .40848 L p F P
0 g
s
.71 .783 .909 r
.44041 .44949 m .45226 .44671 L .45691 .4553 L p F P
0 g
s
.769 .808 .884 r
.46799 .44907 m .45691 .4553 L .45226 .44671 L p F P
0 g
s
.336 .44 .819 r
.34803 .36353 m .35942 .37509 L .35581 .39654 L p F P
0 g
s
.343 .447 .823 r
.36737 .40631 m .35581 .39654 L .35942 .37509 L p F P
0 g
s
.215 .433 .857 r
.53503 .40384 m .54664 .41109 L .54748 .41409 L p F P
0 g
s
.056 .395 .853 r
.54664 .41109 m .53503 .40384 L .53405 .40242 L p F P
0 g
s
.3 .462 .854 r
.87166 .3832 m .85861 .37409 L .85397 .33026 L p F P
0 g
s
.316 .476 .86 r
.84093 .32318 m .85397 .33026 L .85861 .37409 L p F P
0 g
s
.812 .824 .859 r
.46416 .44189 m .47607 .4352 L .4791 .44096 L p F P
0 g
s
.812 .824 .859 r
.4791 .44096 m .46799 .44907 L .46416 .44189 L p F P
0 g
s
.872 .895 .847 r
.4874 .42238 m .4995 .41434 L .49987 .41737 L p F P
0 g
s
.872 .895 .847 r
.49987 .41737 m .48798 .42691 L .4874 .42238 L p F P
0 g
s
.556 .636 .886 r
.59059 .45462 m .57943 .4485 L .58303 .44128 L p F P
0 g
s
.556 .636 .886 r
.58303 .44128 m .59497 .44598 L .59059 .45462 L p F P
0 g
s
.375 .544 .894 r
.39078 .42357 m .40264 .43025 L .40531 .44525 L p F P
0 g
s
.459 .611 .913 r
.41691 .44867 m .40531 .44525 L .40264 .43025 L p F P
0 g
s
.769 .808 .884 r
.45226 .44671 m .46416 .44189 L .46799 .44907 L p F P
0 g
s
.366 .487 .849 r
.55913 .42654 m .54721 .41712 L .54748 .41409 L p F P
0 g
s
.51 .58 .861 r
.57943 .4485 m .56824 .4405 L .57108 .43471 L p F P
0 g
s
.473 .535 .84 r
.55913 .42654 m .57108 .43471 L .56824 .4405 L p F P
0 g
s
.51 .58 .861 r
.57108 .43471 m .58303 .44128 L .57943 .4485 L p F P
0 g
s
.647 .964 .802 r
.50496 .40593 m .51428 .40126 L .51285 .40254 L p F P
0 g
s
.647 .964 .802 r
.51285 .40254 m .5021 .40848 L .50496 .40593 L p F P
0 g
s
.056 .395 .853 r
.53405 .40242 m .5447 .40826 L .54664 .41109 L p F P
0 g
s
0 .34 .794 r
.5447 .40826 m .53405 .40242 L .53258 .40117 L p F P
0 g
s
.893 .891 .821 r
.6912 .39477 m .67962 .40467 L .6755 .38485 L p F P
0 g
s
.893 .891 .821 r
.6755 .38485 m .68691 .37334 L .6912 .39477 L p F P
0 g
s
.79 .877 .911 r
.64212 .44404 m .63046 .44758 L .63235 .43405 L p F P
0 g
s
.79 .877 .911 r
.63235 .43405 m .64431 .42899 L .64212 .44404 L p F P
0 g
s
.403 .834 .685 r
.5087 .4038 m .51614 .4002 L .51428 .40126 L p F P
0 g
s
.403 .834 .685 r
.51428 .40126 m .50496 .40593 L .5087 .4038 L p F P
0 g
s
0 .34 .794 r
.53258 .40117 m .54176 .40574 L .5447 .40826 L p F P
0 g
s
0 .278 .672 r
.54176 .40574 m .53258 .40117 L .53069 .40012 L p F P
0 g
s
.86 .951 .872 r
.4885 .41787 m .50025 .41133 L .4995 .41434 L p F P
0 g
s
.86 .951 .872 r
.4995 .41434 m .4874 .42238 L .4885 .41787 L p F P
0 g
s
0 0 0 r
.51314 .40219 m .51836 .3994 L .51614 .4002 L p F P
0 g
s
0 0 0 r
.51614 .4002 m .5087 .4038 L .51314 .40219 L p F P
0 g
s
0 .278 .672 r
.53795 .40364 m .54176 .40574 L p .53655 .4031 L F P
0 g
s
0 .373 .765 r
.55102 .40947 m .54176 .40574 L .53795 .40364 L p F P
0 g
s
0 .373 .765 r
.5453 .40632 m .55102 .40947 L p .54529 .40691 L F P
0 g
s
0 .373 .765 r
.53795 .40364 m .5453 .40632 L p .54529 .40691 L F P
0 g
s
.249 0 0 r
.5453 .40632 m .53795 .40364 L p .53929 .40417 L F P
0 g
s
.249 0 0 r
.53852 .40396 m .5453 .40632 L p .5401 .40446 L F P
0 g
s
.249 0 0 r
.53346 .40208 m .53852 .40396 L p .5401 .40446 L F P
0 g
s
.266 0 0 r
.53852 .40396 m .53346 .40208 L .52849 .40112 L p F P
0 g
s
.266 0 0 r
.53102 .40251 m .53852 .40396 L p .53412 .40271 L F P
0 g
s
.266 0 0 r
.52849 .40112 m .53102 .40251 L p .53412 .40271 L F P
0 g
s
.222 0 0 r
.52328 .40082 m .52316 .40205 L .53102 .40251 L p F P
0 g
s
0 .547 .711 r
.53102 .40251 m .52316 .40205 L p .52814 .40233 L F P
0 g
s
.222 0 0 r
.53102 .40251 m .52849 .40112 L .52328 .40082 L p F P
0 g
s
0 .547 .711 r
.53359 .40263 m .53102 .40251 L p .52814 .40233 L F P
0 g
s
0 .506 .749 r
.53852 .40396 m .53102 .40251 L p .53705 .40349 L F P
0 g
s
.249 0 0 r
.53795 .40364 m .53346 .40208 L p .53929 .40417 L F P
0 g
s
0 .506 .749 r
.54365 .40457 m .53852 .40396 L p .53705 .40349 L F P
0 g
s
0 .494 .812 r
.5453 .40632 m .53852 .40396 L p .54531 .40576 L F P
0 g
s
0 .494 .812 r
.55272 .40772 m .5453 .40632 L p .54531 .40576 L F P
0 g
s
0 .278 .672 r
.53069 .40012 m .53795 .40364 L p .53655 .4031 L F P
0 g
s
.365 0 0 r
.53795 .40364 m .53069 .40012 L .52845 .39935 L p F P
0 g
s
.849 .883 .864 r
.47525 .42917 m .4874 .42238 L .48798 .42691 L p F P
0 g
s
.849 .883 .864 r
.48798 .42691 m .47607 .4352 L .47525 .42917 L p F P
0 g
s
.366 .487 .849 r
.54748 .41409 m .55957 .422 L .55913 .42654 L p F P
0 g
s
.262 .47 .873 r
.55957 .422 m .54748 .41409 L .54664 .41109 L p F P
0 g
s
.408 .528 .866 r
.57108 .43471 m .55913 .42654 L .55957 .422 L p F P
0 g
s
.459 .611 .913 r
.40264 .43025 m .4146 .43518 L .41691 .44867 L p F P
0 g
s
.548 .679 .925 r
.42862 .45013 m .41691 .44867 L .4146 .43518 L p F P
0 g
s
.07 0 0 r
.51808 .40118 m .52081 .3989 L .51836 .3994 L p F P
0 g
s
.07 0 0 r
.51836 .3994 m .51314 .40219 L .51808 .40118 L p F P
0 g
s
.365 0 0 r
.52845 .39935 m .53346 .40208 L .53795 .40364 L p F P
0 g
s
.373 0 0 r
.53346 .40208 m .52845 .39935 L .52598 .39887 L p F P
0 g
s
.343 .447 .823 r
.35942 .37509 m .37086 .38647 L .36737 .40631 L p F P
0 g
s
.364 .468 .833 r
.37903 .41547 m .36737 .40631 L .37086 .38647 L p F P
0 g
s
.223 0 0 r
.52328 .40082 m .52339 .39872 L .52081 .3989 L p F P
0 g
s
.223 0 0 r
.52081 .3989 m .51808 .40118 L .52328 .40082 L p F P
0 g
s
.373 0 0 r
.52598 .39887 m .52849 .40112 L .53346 .40208 L p F P
0 g
s
.323 0 0 r
.52849 .40112 m .52598 .39887 L .52339 .39872 L p F P
0 g
s
.323 0 0 r
.52339 .39872 m .52328 .40082 L .52849 .40112 L p F P
0 g
s
.735 .83 .923 r
.63046 .44758 m .61871 .44916 L .62031 .43714 L p F P
0 g
s
.735 .83 .923 r
.62031 .43714 m .63235 .43405 L .63046 .44758 L p F P
0 g
s
.3 .462 .854 r
.85397 .33026 m .86715 .33785 L .87166 .3832 L p F P
0 g
s
.815 .863 .884 r
.46308 .43437 m .47525 .42917 L .47607 .4352 L p F P
0 g
s
.815 .863 .884 r
.47607 .4352 m .46416 .44189 L .46308 .43437 L p F P
0 g
s
.883 .886 .831 r
.67962 .40467 m .66795 .41396 L .66402 .39573 L p F P
0 g
s
.883 .886 .831 r
.66402 .39573 m .6755 .38485 L .67962 .40467 L p F P
0 g
s
.804 .99 .882 r
.49126 .41359 m .5021 .40848 L .50025 .41133 L p F P
0 g
s
.804 .99 .882 r
.50025 .41133 m .4885 .41787 L .49126 .41359 L p F P
0 g
s
.463 .58 .886 r
.58303 .44128 m .57108 .43471 L .57171 .42867 L p F P
0 g
s
.408 .528 .866 r
.55957 .422 m .57171 .42867 L .57108 .43471 L p F P
0 g
s
.262 .47 .873 r
.54664 .41109 m .55832 .4175 L .55957 .422 L p F P
0 g
s
.13 .447 .881 r
.55832 .4175 m .54664 .41109 L .5447 .40826 L p F P
0 g
s
.548 .679 .925 r
.4146 .43518 m .42664 .43814 L .42862 .45013 L p F P
0 g
s
.632 .741 .927 r
.44041 .44949 m .42862 .45013 L .42664 .43814 L p F P
0 g
s
.593 .666 .889 r
.29518 .28121 m .30628 .28729 L .29092 .31771 L p F P
0 g
s
.593 .666 .889 r
.29092 .31771 m .27923 .31326 L .29518 .28121 L p F P
0 g
s
.545 .606 .866 r
.30248 .32407 m .29092 .31771 L .30628 .28729 L p F P
0 g
s
.646 .731 .911 r
.2839 .27714 m .29518 .28121 L .27923 .31326 L p F P
0 g
s
.646 .731 .911 r
.27923 .31326 m .26737 .31082 L .2839 .27714 L p F P
0 g
s
.67 .771 .926 r
.61871 .44916 m .60687 .44863 L .6082 .43811 L p F P
0 g
s
.67 .771 .926 r
.6082 .43811 m .62031 .43714 L .61871 .44916 L p F P
0 g
s
.545 .606 .866 r
.30628 .28729 m .31724 .29528 L .30248 .32407 L p F P
0 g
s
.504 .557 .843 r
.31393 .33214 m .30248 .32407 L .31724 .29528 L p F P
0 g
s
.768 .834 .903 r
.4509 .43771 m .46308 .43437 L .46416 .44189 L p F P
0 g
s
.768 .834 .903 r
.46416 .44189 m .45226 .44671 L .4509 .43771 L p F P
0 g
s
.838 .932 .891 r
.47669 .42316 m .4885 .41787 L .4874 .42238 L p F P
0 g
s
.838 .932 .891 r
.4874 .42238 m .47525 .42917 L .47669 .42316 L p F P
0 g
s
.632 .741 .927 r
.42664 .43814 m .43875 .43899 L .44041 .44949 L p F P
0 g
s
.707 .794 .919 r
.45226 .44671 m .44041 .44949 L .43875 .43899 L p F P
0 g
s
.528 .641 .905 r
.59497 .44598 m .58303 .44128 L .58387 .43375 L p F P
0 g
s
.463 .58 .886 r
.57171 .42867 m .58387 .43375 L .58303 .44128 L p F P
0 g
s
.707 .794 .919 r
.43875 .43899 m .4509 .43771 L .45226 .44671 L p F P
0 g
s
.329 .522 .893 r
.57171 .42867 m .55957 .422 L .55832 .4175 L p F P
0 g
s
.364 .468 .833 r
.37086 .38647 m .38237 .39721 L .37903 .41547 L p F P
0 g
s
.398 .502 .848 r
.39078 .42357 m .37903 .41547 L .38237 .39721 L p F P
0 g
s
.599 .707 .919 r
.60687 .44863 m .59497 .44598 L .59604 .43696 L p F P
0 g
s
.599 .707 .919 r
.59604 .43696 m .6082 .43811 L .60687 .44863 L p F P
0 g
s
.699 .796 .925 r
.27243 .27511 m .2839 .27714 L .26737 .31082 L p F P
0 g
s
.699 .796 .925 r
.26737 .31082 m .25533 .31041 L .27243 .27511 L p F P
0 g
s
.504 .557 .843 r
.31724 .29528 m .32809 .30498 L .31393 .33214 L p F P
0 g
s
.473 .518 .823 r
.32532 .34164 m .31393 .33214 L .32809 .30498 L p F P
0 g
s
.528 .641 .905 r
.58387 .43375 m .59604 .43696 L .59497 .44598 L p F P
0 g
s
.676 .977 .854 r
.49554 .40976 m .50496 .40593 L .5021 .40848 L p F P
0 g
s
.676 .977 .854 r
.5021 .40848 m .49126 .41359 L .49554 .40976 L p F P
0 g
s
.13 .447 .881 r
.5447 .40826 m .55543 .41326 L .55832 .4175 L p F P
0 g
s
0 .414 .849 r
.55543 .41326 m .5447 .40826 L .54176 .40574 L p F P
0 g
s
.741 .785 .888 r
.7669 .31056 m .75524 .31515 L .73891 .28487 L p F P
0 g
s
.79 .804 .864 r
.75524 .31515 m .74371 .32165 L .72803 .29299 L p F P
0 g
s
.79 .804 .864 r
.72803 .29299 m .73891 .28487 L .75524 .31515 L p F P
0 g
s
.825 .816 .841 r
.74371 .32165 m .73228 .32985 L .71726 .30282 L p F P
0 g
s
.825 .816 .841 r
.71726 .30282 m .72803 .29299 L .74371 .32165 L p F P
0 g
s
.677 .756 .911 r
.77873 .30798 m .7669 .31056 L .74993 .27865 L p F P
0 g
s
.741 .785 .888 r
.73891 .28487 m .74993 .27865 L .7669 .31056 L p F P
0 g
s
.864 .878 .846 r
.66795 .41396 m .65618 .42219 L .65247 .40554 L p F P
0 g
s
.864 .878 .846 r
.65247 .40554 m .66402 .39573 L .66795 .41396 L p F P
0 g
s
.85 .822 .821 r
.73228 .32985 m .72092 .33948 L .70657 .31408 L p F P
0 g
s
.85 .822 .821 r
.70657 .31408 m .71726 .30282 L .73228 .32985 L p F P
0 g
s
.473 .518 .823 r
.32809 .30498 m .33885 .31611 L .32532 .34164 L p F P
0 g
s
.45 .49 .809 r
.33667 .35223 m .32532 .34164 L .33885 .31611 L p F P
0 g
s
.746 .856 .93 r
.26073 .27508 m .27243 .27511 L .25533 .31041 L p F P
0 g
s
.746 .856 .93 r
.25533 .31041 m .24308 .31199 L .26073 .27508 L p F P
0 g
s
.599 .716 .926 r
.79075 .30745 m .77873 .30798 L .76113 .27445 L p F P
0 g
s
.677 .756 .911 r
.74993 .27865 m .76113 .27445 L .77873 .30798 L p F P
0 g
s
.473 .887 .774 r
.50117 .40655 m .5087 .4038 L .50496 .40593 L p F P
0 g
s
.473 .887 .774 r
.50496 .40593 m .49554 .40976 L .50117 .40655 L p F P
0 g
s
0 .414 .849 r
.54176 .40574 m .55102 .40947 L .55543 .41326 L p F P
0 g
s
.805 .902 .91 r
.46483 .42686 m .47669 .42316 L .47525 .42917 L p F P
0 g
s
.805 .902 .91 r
.47525 .42917 m .46308 .43437 L .46483 .42686 L p F P
0 g
s
.398 .502 .848 r
.38237 .39721 m .39396 .40689 L .39078 .42357 L p F P
0 g
s
.445 .549 .868 r
.40264 .43025 m .39078 .42357 L .39396 .40689 L p F P
0 g
s
.796 .97 .911 r
.48034 .41746 m .49126 .41359 L .4885 .41787 L p F P
0 g
s
.796 .97 .911 r
.4885 .41787 m .47669 .42316 L .48034 .41746 L p F P
0 g
s
.41 .584 .912 r
.58387 .43375 m .57171 .42867 L .57008 .42268 L p F P
0 g
s
.329 .522 .893 r
.55832 .4175 m .57008 .42268 L .57171 .42867 L p F P
0 g
s
.232 .517 .912 r
.57008 .42268 m .55832 .4175 L .55543 .41326 L p F P
0 g
s
.865 .826 .807 r
.72092 .33948 m .70959 .35021 L .69593 .32642 L p F P
0 g
s
.865 .826 .807 r
.69593 .32642 m .70657 .31408 L .72092 .33948 L p F P
0 g
s
0 0 0 r
.50786 .40412 m .51314 .40219 L .5087 .4038 L p F P
0 g
s
.199 .727 .754 r
.50786 .40412 m .50253 .40478 L .51068 .40311 L p F P
0 g
s
0 0 0 r
.51314 .40219 m .51113 .40292 L p .51531 .4026 L F P
0 g
s
0 0 0 r
.51113 .40292 m .50786 .40412 L .51531 .4026 L p F P
0 g
s
0 0 0 r
.51531 .4026 m .51808 .40118 L .51314 .40219 L p F P
0 g
s
.123 0 0 r
.51808 .40118 m .51531 .4026 L .52316 .40205 L p F P
0 g
s
.057 .622 .713 r
.51531 .4026 m .51252 .40274 L .52111 .40214 L p F P
0 g
s
.057 .622 .713 r
.52111 .40214 m .52304 .40201 L p .51531 .4026 L F P
0 g
s
.199 .727 .754 r
.51068 .40311 m .51252 .40274 L p .50786 .40412 L F P
0 g
s
0 0 0 r
.5087 .4038 m .50583 .40484 L p .50786 .40412 L F P
0 g
s
0 0 0 r
.50583 .40484 m .50117 .40655 L .50786 .40412 L p F P
0 g
s
.835 .864 .866 r
.65618 .42219 m .64431 .42899 L .64083 .4139 L p F P
0 g
s
.835 .864 .866 r
.64083 .4139 m .65247 .40554 L .65618 .42219 L p F P
0 g
s
.45 .49 .809 r
.33885 .31611 m .34957 .32832 L .33667 .35223 L p F P
0 g
s
.437 .474 .8 r
.34803 .36353 m .33667 .35223 L .34957 .32832 L p F P
0 g
s
.509 .665 .932 r
.80298 .30889 m .79075 .30745 L .77253 .27229 L p F P
0 g
s
.599 .716 .926 r
.76113 .27445 m .77253 .27229 L .79075 .30745 L p F P
0 g
s
.759 .859 .924 r
.45294 .42869 m .46483 .42686 L .46308 .43437 L p F P
0 g
s
.759 .859 .924 r
.46308 .43437 m .4509 .43771 L .45294 .42869 L p F P
0 g
s
.785 .904 .925 r
.24881 .27687 m .26073 .27508 L .24308 .31199 L p F P
0 g
s
.785 .904 .925 r
.24308 .31199 m .23062 .31539 L .24881 .27687 L p F P
0 g
s
.445 .549 .868 r
.39396 .40689 m .40564 .41513 L .40264 .43025 L p F P
0 g
s
.502 .607 .889 r
.4146 .43518 m .40264 .43025 L .40564 .41513 L p F P
0 g
s
.5 .651 .925 r
.59604 .43696 m .58387 .43375 L .58189 .42626 L p F P
0 g
s
.41 .584 .912 r
.57008 .42268 m .58189 .42626 L .58387 .43375 L p F P
0 g
s
.874 .827 .798 r
.70959 .35021 m .69826 .36164 L .68531 .33946 L p F P
0 g
s
.874 .827 .798 r
.68531 .33946 m .69593 .32642 L .70959 .35021 L p F P
0 g
s
.123 0 0 r
.52316 .40205 m .52328 .40082 L .51808 .40118 L p F P
0 g
s
.705 .978 .912 r
.48605 .41233 m .49554 .40976 L .49126 .41359 L p F P
0 g
s
.705 .978 .912 r
.49126 .41359 m .48034 .41746 L .48605 .41233 L p F P
0 g
s
.795 .843 .887 r
.64431 .42899 m .63235 .43405 L .62913 .4205 L p F P
0 g
s
.795 .843 .887 r
.62913 .4205 m .64083 .4139 L .64431 .42899 L p F P
0 g
s
.232 .517 .912 r
.55543 .41326 m .56625 .41701 L .57008 .42268 L p F P
0 g
s
.123 .51 .91 r
.56625 .41701 m .55543 .41326 L .55102 .40947 L p F P
0 g
s
.437 .474 .8 r
.34957 .32832 m .36027 .34123 L .34803 .36353 L p F P
0 g
s
.433 .469 .797 r
.35942 .37509 m .34803 .36353 L .36027 .34123 L p F P
0 g
s
.701 .803 .929 r
.44106 .42847 m .45294 .42869 L .4509 .43771 L p F P
0 g
s
.701 .803 .929 r
.4509 .43771 m .43875 .43899 L .44106 .42847 L p F P
0 g
s
.502 .607 .889 r
.40564 .41513 m .41739 .42161 L .4146 .43518 L p F P
0 g
s
.567 .672 .909 r
.42664 .43814 m .4146 .43518 L .41739 .42161 L p F P
0 g
s
.775 .934 .935 r
.46936 .41972 m .48034 .41746 L .47669 .42316 L p F P
0 g
s
.775 .934 .935 r
.47669 .42316 m .46483 .42686 L .46936 .41972 L p F P
0 g
s
.59 .714 .929 r
.6082 .43811 m .59604 .43696 L .59372 .42796 L p F P
0 g
s
.5 .651 .925 r
.58189 .42626 m .59372 .42796 L .59604 .43696 L p F P
0 g
s
.416 .607 .927 r
.81541 .31216 m .80298 .30889 L .78414 .27212 L p F P
0 g
s
.509 .665 .932 r
.77253 .27229 m .78414 .27212 L .80298 .30889 L p F P
0 g
s
.352 .594 .937 r
.58189 .42626 m .57008 .42268 L .56625 .41701 L p F P
0 g
s
.635 .739 .923 r
.4292 .4261 m .44106 .42847 L .43875 .43899 L p F P
0 g
s
.635 .739 .923 r
.43875 .43899 m .42664 .43814 L .4292 .4261 L p F P
0 g
s
.567 .672 .909 r
.41739 .42161 m .4292 .4261 L .42664 .43814 L p F P
0 g
s
.741 .811 .908 r
.63235 .43405 m .62031 .43714 L .61736 .42512 L p F P
0 g
s
.741 .811 .908 r
.61736 .42512 m .62913 .4205 L .63235 .43405 L p F P
0 g
s
.877 .828 .795 r
.69826 .36164 m .68691 .37334 L .67467 .35274 L p F P
0 g
s
.877 .828 .795 r
.67467 .35274 m .68531 .33946 L .69826 .36164 L p F P
0 g
s
.672 .768 .923 r
.62031 .43714 m .6082 .43811 L .60555 .42761 L p F P
0 g
s
.59 .714 .929 r
.59372 .42796 m .60555 .42761 L .6082 .43811 L p F P
0 g
s
.672 .768 .923 r
.60555 .42761 m .61736 .42512 L .62031 .43714 L p F P
0 g
s
.812 .939 .911 r
.23667 .28027 m .24881 .27687 L .23062 .31539 L p F P
0 g
s
.812 .939 .911 r
.23062 .31539 m .21794 .32038 L .23667 .28027 L p F P
0 g
s
.559 .935 .879 r
.49356 .40803 m .50117 .40655 L .49554 .40976 L p F P
0 g
s
.559 .935 .879 r
.49554 .40976 m .48605 .41233 L .49356 .40803 L p F P
0 g
s
.433 .469 .797 r
.36027 .34123 m .37099 .35439 L .35942 .37509 L p F P
0 g
s
.437 .474 .8 r
.37086 .38647 m .35942 .37509 L .37099 .35439 L p F P
0 g
s
.123 .51 .91 r
.55102 .40947 m .56037 .41194 L .56625 .41701 L p F P
0 g
s
.019 .5 .875 r
.56037 .41194 m .55102 .40947 L .5453 .40632 L p F P
0 g
s
.874 .827 .798 r
.68691 .37334 m .6755 .38485 L .66401 .36583 L p F P
0 g
s
.874 .827 .798 r
.66401 .36583 m .67467 .35274 L .68691 .37334 L p F P
0 g
s
.739 .879 .945 r
.45834 .42011 m .46936 .41972 L .46483 .42686 L p F P
0 g
s
.739 .879 .945 r
.46483 .42686 m .45294 .42869 L .45834 .42011 L p F P
0 g
s
.329 .55 .914 r
.82807 .31702 m .81541 .31216 L .79598 .27379 L p F P
0 g
s
.416 .607 .927 r
.78414 .27212 m .79598 .27379 L .81541 .31216 L p F P
0 g
s
.473 .665 .946 r
.59372 .42796 m .58189 .42626 L .57712 .41916 L p F P
0 g
s
.352 .594 .937 r
.56625 .41701 m .57712 .41916 L .58189 .42626 L p F P
0 g
s
.377 .842 .818 r
.50253 .40478 m .50786 .40412 L .50117 .40655 L p F P
0 g
s
.377 .842 .818 r
.50117 .40655 m .49356 .40803 L .50253 .40478 L p F P
0 g
s
.718 .95 .953 r
.47649 .4133 m .48605 .41233 L .48034 .41746 L p F P
0 g
s
.718 .95 .953 r
.48034 .41746 m .46936 .41972 L .47649 .4133 L p F P
0 g
s
.437 .474 .8 r
.37099 .35439 m .38173 .36734 L .37086 .38647 L p F P
0 g
s
.45 .49 .809 r
.38237 .39721 m .37086 .38647 L .38173 .36734 L p F P
0 g
s
.019 .5 .875 r
.5453 .40632 m .55272 .40772 L .56037 .41194 L p F P
0 g
s
.291 .607 .953 r
.57712 .41916 m .56625 .41701 L .56037 .41194 L p F P
0 g
s
.865 .826 .807 r
.6755 .38485 m .66402 .39573 L .65329 .37826 L p F P
0 g
s
.865 .826 .807 r
.65329 .37826 m .66401 .36583 L .6755 .38485 L p F P
0 g
s
.829 .961 .895 r
.22431 .28497 m .23667 .28027 L .21794 .32038 L p F P
0 g
s
.829 .961 .895 r
.21794 .32038 m .20506 .32667 L .22431 .28497 L p F P
0 g
s
.199 .727 .754 r
.51252 .40274 m .51531 .4026 L .50786 .40412 L p F P
0 g
s
0 .494 .812 r
.53852 .40396 m .54365 .40457 L .55272 .40772 L p F P
0 g
s
.692 .811 .939 r
.4473 .41842 m .45834 .42011 L .45294 .42869 L p F P
0 g
s
.692 .811 .939 r
.45294 .42869 m .44106 .42847 L .4473 .41842 L p F P
0 g
s
.45 .49 .809 r
.38173 .36734 m .39253 .37965 L .38237 .39721 L p F P
0 g
s
.471 .517 .824 r
.39396 .40689 m .38237 .39721 L .39253 .37965 L p F P
0 g
s
.583 .723 .939 r
.60555 .42761 m .59372 .42796 L .58804 .41943 L p F P
0 g
s
.473 .665 .946 r
.57712 .41916 m .58804 .41943 L .59372 .42796 L p F P
0 g
s
.057 .622 .713 r
.52304 .40201 m .52316 .40205 L .51531 .4026 L p F P
0 g
s
0 .506 .749 r
.53102 .40251 m .53359 .40263 L .54365 .40457 L p F P
0 g
s
0 .547 .711 r
.52316 .40205 m .52304 .40201 L .53359 .40263 L p F P
0 g
s
.85 .823 .822 r
.66402 .39573 m .65247 .40554 L .64253 .38961 L p F P
0 g
s
.85 .823 .822 r
.64253 .38961 m .65329 .37826 L .66402 .39573 L p F P
0 g
s
.258 .501 .897 r
.84093 .32318 m .82807 .31702 L .80804 .27706 L p F P
0 g
s
.329 .55 .914 r
.79598 .27379 m .80804 .27706 L .82807 .31702 L p F P
0 g
s
.63 .941 .957 r
.4859 .4079 m .49356 .40803 L .48605 .41233 L p F P
0 g
s
.63 .941 .957 r
.48605 .41233 m .47649 .4133 L .4859 .4079 L p F P
0 g
s
.471 .517 .824 r
.39253 .37965 m .40338 .39087 L .39396 .40689 L p F P
0 g
s
.501 .556 .844 r
.40564 .41513 m .39396 .40689 L .40338 .39087 L p F P
0 g
s
.639 .737 .92 r
.43627 .41459 m .4473 .41842 L .44106 .42847 L p F P
0 g
s
.639 .737 .92 r
.44106 .42847 m .4292 .4261 L .43627 .41459 L p F P
0 g
s
.291 .607 .953 r
.56037 .41194 m .56979 .41281 L .57712 .41916 L p F P
0 g
s
.236 .624 .957 r
.56979 .41281 m .56037 .41194 L .55272 .40772 L p F P
0 g
s
.708 .891 .964 r
.46688 .41237 m .47649 .4133 L .46936 .41972 L p F P
0 g
s
.708 .891 .964 r
.46936 .41972 m .45834 .42011 L .46688 .41237 L p F P
0 g
s
.673 .765 .92 r
.61736 .42512 m .60555 .42761 L .59898 .41763 L p F P
0 g
s
.583 .723 .939 r
.58804 .41943 m .59898 .41763 L .60555 .42761 L p F P
0 g
s
.826 .818 .842 r
.65247 .40554 m .64083 .4139 L .6317 .39949 L p F P
0 g
s
.826 .818 .842 r
.6317 .39949 m .64253 .38961 L .65247 .40554 L p F P
0 g
s
.45 .684 .965 r
.58804 .41943 m .57712 .41916 L .56979 .41281 L p F P
0 g
s
.501 .556 .844 r
.40338 .39087 m .41429 .40063 L .40564 .41513 L p F P
0 g
s
.54 .606 .868 r
.41739 .42161 m .40564 .41513 L .41429 .40063 L p F P
0 g
s
.587 .668 .895 r
.42526 .40861 m .43627 .41459 L .4292 .4261 L p F P
0 g
s
.587 .668 .895 r
.4292 .4261 m .41739 .42161 L .42526 .40861 L p F P
0 g
s
.54 .606 .868 r
.41429 .40063 m .42526 .40861 L .41739 .42161 L p F P
0 g
s
.741 .792 .894 r
.62913 .4205 m .61736 .42512 L .60991 .41368 L p F P
0 g
s
.673 .765 .92 r
.59898 .41763 m .60991 .41368 L .61736 .42512 L p F P
0 g
s
.791 .808 .866 r
.64083 .4139 m .62913 .4205 L .62083 .40759 L p F P
0 g
s
.791 .808 .866 r
.62083 .40759 m .6317 .39949 L .64083 .4139 L p F P
0 g
s
.838 .973 .882 r
.21175 .2906 m .22431 .28497 L .20506 .32667 L p F P
0 g
s
.838 .973 .882 r
.20506 .32667 m .192 .33388 L .21175 .2906 L p F P
0 g
s
.741 .792 .894 r
.60991 .41368 m .62083 .40759 L .62913 .4205 L p F P
0 g
s
.519 .903 .948 r
.49715 .40382 m .50253 .40478 L .49356 .40803 L p F P
0 g
s
.519 .903 .948 r
.49356 .40803 m .4859 .4079 L .49715 .40382 L p F P
0 g
s
.236 .624 .957 r
.55272 .40772 m .5602 .40751 L .56979 .41281 L p F P
0 g
s
.199 .646 .946 r
.5602 .40751 m .55272 .40772 L .54365 .40457 L p F P
0 g
s
.578 .61 .848 r
.33282 .25928 m .34257 .26881 L .31724 .29528 L p F P
0 g
s
.578 .61 .848 r
.31724 .29528 m .30628 .28729 L .33282 .25928 L p F P
0 g
s
.551 .566 .823 r
.32809 .30498 m .31724 .29528 L .34257 .26881 L p F P
0 g
s
.551 .566 .823 r
.34257 .26881 m .35221 .28005 L .32809 .30498 L p F P
0 g
s
.53 .533 .803 r
.33885 .31611 m .32809 .30498 L .35221 .28005 L p F P
0 g
s
.679 .815 .948 r
.45724 .40936 m .46688 .41237 L .45834 .42011 L p F P
0 g
s
.679 .815 .948 r
.45834 .42011 m .4473 .41842 L .45724 .40936 L p F P
0 g
s
.208 .466 .883 r
.85397 .33026 m .84093 .32318 L .82032 .28162 L p F P
0 g
s
.258 .501 .897 r
.80804 .27706 m .82032 .28162 L .84093 .32318 L p F P
0 g
s
.611 .665 .877 r
.32292 .25164 m .33282 .25928 L .30628 .28729 L p F P
0 g
s
.611 .665 .877 r
.30628 .28729 m .29518 .28121 L .32292 .25164 L p F P
0 g
s
.53 .533 .803 r
.35221 .28005 m .36176 .2927 L .33885 .31611 L p F P
0 g
s
.516 .511 .789 r
.34957 .32832 m .33885 .31611 L .36176 .2927 L p F P
0 g
s
.579 .734 .949 r
.59898 .41763 m .58804 .41943 L .57925 .41178 L p F P
0 g
s
.45 .684 .965 r
.56979 .41281 m .57925 .41178 L .58804 .41943 L p F P
0 g
s
.664 .894 .979 r
.47818 .40587 m .4859 .4079 L .47649 .4133 L p F P
0 g
s
.664 .894 .979 r
.47649 .4133 m .46688 .41237 L .47818 .40587 L p F P
0 g
s
.401 .845 .93 r
.50969 .40125 m .51252 .40274 L .50253 .40478 L p F P
0 g
s
.401 .845 .93 r
.50253 .40478 m .49715 .40382 L .50969 .40125 L p F P
0 g
s
.199 .646 .946 r
.54365 .40457 m .54882 .40354 L .5602 .40751 L p F P
0 g
s
.194 .677 .929 r
.54882 .40354 m .54365 .40457 L .53359 .40263 L p F P
0 g
s
.808 .774 .821 r
.72803 .29299 m .71726 .30282 L .69232 .27813 L p F P
0 g
s
.828 .774 .801 r
.71726 .30282 m .70657 .31408 L .6829 .29091 L p F P
0 g
s
.828 .774 .801 r
.6829 .29091 m .69232 .27813 L .71726 .30282 L p F P
0 g
s
.779 .772 .847 r
.73891 .28487 m .72803 .29299 L .70184 .26678 L p F P
0 g
s
.808 .774 .821 r
.69232 .27813 m .70184 .26678 L .72803 .29299 L p F P
0 g
s
.433 .708 .981 r
.57925 .41178 m .56979 .41281 L .5602 .40751 L p F P
0 g
s
.516 .511 .789 r
.36176 .2927 m .37126 .30644 L .34957 .32832 L p F P
0 g
s
.508 .498 .78 r
.36027 .34123 m .34957 .32832 L .37126 .30644 L p F P
0 g
s
.649 .73 .908 r
.31285 .24602 m .32292 .25164 L .29518 .28121 L p F P
0 g
s
.649 .73 .908 r
.29518 .28121 m .2839 .27714 L .31285 .24602 L p F P
0 g
s
.84 .773 .787 r
.70657 .31408 m .69593 .32642 L .67353 .30476 L p F P
0 g
s
.84 .773 .787 r
.67353 .30476 m .6829 .29091 L .70657 .31408 L p F P
0 g
s
.737 .766 .876 r
.74993 .27865 m .73891 .28487 L .71146 .25712 L p F P
0 g
s
.779 .772 .847 r
.70184 .26678 m .71146 .25712 L .73891 .28487 L p F P
0 g
s
.299 .78 .917 r
.52293 .40033 m .52304 .40201 L .51252 .40274 L p F P
0 g
s
.299 .78 .917 r
.51252 .40274 m .50969 .40125 L .52293 .40033 L p F P
0 g
s
.194 .677 .929 r
.53359 .40263 m .53619 .40111 L .54882 .40354 L p F P
0 g
s
.227 .722 .916 r
.53619 .40111 m .53359 .40263 L .52304 .40201 L p F P
0 g
s
.842 .978 .874 r
.19903 .29674 m .21175 .2906 L .192 .33388 L p F P
0 g
s
.842 .978 .874 r
.192 .33388 m .17879 .3416 L .19903 .29674 L p F P
0 g
s
.847 .772 .779 r
.69593 .32642 m .68531 .33946 L .66418 .31928 L p F P
0 g
s
.847 .772 .779 r
.66418 .31928 m .67353 .30476 L .69593 .32642 L p F P
0 g
s
.508 .498 .78 r
.37126 .30644 m .38073 .32084 L .36027 .34123 L p F P
0 g
s
.505 .493 .777 r
.37099 .35439 m .36027 .34123 L .38073 .32084 L p F P
0 g
s
.227 .722 .916 r
.52304 .40201 m .52293 .40033 L .53619 .40111 L p F P
0 g
s
.643 .737 .917 r
.44759 .40418 m .45724 .40936 L .4473 .41842 L p F P
0 g
s
.643 .737 .917 r
.4473 .41842 m .43627 .41459 L .44759 .40418 L p F P
0 g
s
.677 .752 .908 r
.76113 .27445 m .74993 .27865 L .72123 .24937 L p F P
0 g
s
.737 .766 .876 r
.71146 .25712 m .72123 .24937 L .74993 .27865 L p F P
0 g
s
.672 .761 .917 r
.60991 .41368 m .59898 .41763 L .58875 .40867 L p F P
0 g
s
.579 .734 .949 r
.57925 .41178 m .58875 .40867 L .59898 .41763 L p F P
0 g
s
.688 .801 .935 r
.30259 .24245 m .31285 .24602 L .2839 .27714 L p F P
0 g
s
.688 .801 .935 r
.2839 .27714 m .27243 .27511 L .30259 .24245 L p F P
0 g
s
.849 .772 .776 r
.68531 .33946 m .67467 .35274 L .65484 .33405 L p F P
0 g
s
.849 .772 .776 r
.65484 .33405 m .66418 .31928 L .68531 .33946 L p F P
0 g
s
.505 .493 .777 r
.38073 .32084 m .3902 .33549 L .37099 .35439 L p F P
0 g
s
.508 .498 .78 r
.38173 .36734 m .37099 .35439 L .3902 .33549 L p F P
0 g
s
.612 .884 .99 r
.49172 .40093 m .49715 .40382 L .4859 .4079 L p F P
0 g
s
.612 .884 .99 r
.4859 .4079 m .47818 .40587 L .49172 .40093 L p F P
0 g
s
.433 .708 .981 r
.5602 .40751 m .56773 .4054 L .57925 .41178 L p F P
0 g
s
.428 .736 .991 r
.56773 .4054 m .5602 .40751 L .54882 .40354 L p F P
0 g
s
.183 .447 .875 r
.86715 .33785 m .85397 .33026 L .83279 .28712 L p F P
0 g
s
.208 .466 .883 r
.82032 .28162 m .83279 .28712 L .85397 .33026 L p F P
0 g
s
.606 .667 .882 r
.43794 .39684 m .44759 .40418 L .43627 .41459 L p F P
0 g
s
.606 .667 .882 r
.43627 .41459 m .42526 .40861 L .43794 .39684 L p F P
0 g
s
.847 .772 .779 r
.67467 .35274 m .66401 .36583 L .64549 .34858 L p F P
0 g
s
.847 .772 .779 r
.64549 .34858 m .65484 .33405 L .67467 .35274 L p F P
0 g
s
.508 .498 .78 r
.3902 .33549 m .39968 .34992 L .38173 .36734 L p F P
0 g
s
.516 .511 .789 r
.39253 .37965 m .38173 .36734 L .39968 .34992 L p F P
0 g
s
.596 .726 .935 r
.77253 .27229 m .76113 .27445 L .73117 .24363 L p F P
0 g
s
.677 .752 .908 r
.72123 .24937 m .73117 .24363 L .76113 .27445 L p F P
0 g
s
.664 .816 .956 r
.47043 .40173 m .47818 .40587 L .46688 .41237 L p F P
0 g
s
.664 .816 .956 r
.46688 .41237 m .45724 .40936 L .47043 .40173 L p F P
0 g
s
.737 .772 .881 r
.62083 .40759 m .60991 .41368 L .59825 .40338 L p F P
0 g
s
.672 .761 .917 r
.58875 .40867 m .59825 .40338 L .60991 .41368 L p F P
0 g
s
.578 .747 .957 r
.58875 .40867 m .57925 .41178 L .56773 .4054 L p F P
0 g
s
.516 .511 .789 r
.39968 .34992 m .40919 .36367 L .39253 .37965 L p F P
0 g
s
.53 .533 .803 r
.40338 .39087 m .39253 .37965 L .40919 .36367 L p F P
0 g
s
.84 .773 .787 r
.66401 .36583 m .65329 .37826 L .63611 .36245 L p F P
0 g
s
.84 .773 .787 r
.63611 .36245 m .64549 .34858 L .66401 .36583 L p F P
0 g
s
.575 .61 .85 r
.42832 .38748 m .43794 .39684 L .42526 .40861 L p F P
0 g
s
.575 .61 .85 r
.42526 .40861 m .41429 .40063 L .42832 .38748 L p F P
0 g
s
.722 .869 .95 r
.29211 .24086 m .30259 .24245 L .27243 .27511 L p F P
0 g
s
.722 .869 .95 r
.27243 .27511 m .26073 .27508 L .29211 .24086 L p F P
0 g
s
.53 .533 .803 r
.40919 .36367 m .41874 .37632 L .40338 .39087 L p F P
0 g
s
.549 .566 .823 r
.41429 .40063 m .40338 .39087 L .41874 .37632 L p F P
0 g
s
.549 .566 .823 r
.41874 .37632 m .42832 .38748 L .41429 .40063 L p F P
0 g
s
.78 .776 .849 r
.6317 .39949 m .62083 .40759 L .60776 .39594 L p F P
0 g
s
.737 .772 .881 r
.59825 .40338 m .60776 .39594 L .62083 .40759 L p F P
0 g
s
.828 .774 .801 r
.65329 .37826 m .64253 .38961 L .62669 .37521 L p F P
0 g
s
.828 .774 .801 r
.62669 .37521 m .63611 .36245 L .65329 .37826 L p F P
0 g
s
.556 .863 .996 r
.50685 .39783 m .50969 .40125 L .49715 .40382 L p F P
0 g
s
.556 .863 .996 r
.49715 .40382 m .49172 .40093 L .50685 .39783 L p F P
0 g
s
.428 .736 .991 r
.54882 .40354 m .55403 .4006 L .56773 .4054 L p F P
0 g
s
.437 .767 .997 r
.55403 .4006 m .54882 .40354 L .53619 .40111 L p F P
0 g
s
.809 .776 .822 r
.64253 .38961 m .6317 .39949 L .61724 .38648 L p F P
0 g
s
.78 .776 .849 r
.60776 .39594 m .61724 .38648 L .6317 .39949 L p F P
0 g
s
.809 .776 .822 r
.61724 .38648 m .62669 .37521 L .64253 .38961 L p F P
0 g
s
.493 .685 .952 r
.78414 .27212 m .77253 .27229 L .74129 .23994 L p F P
0 g
s
.596 .726 .935 r
.73117 .24363 m .74129 .23994 L .77253 .27229 L p F P
0 g
s
.647 .737 .915 r
.46267 .39541 m .47043 .40173 L .45724 .40936 L p F P
0 g
s
.647 .737 .915 r
.45724 .40936 m .44759 .40418 L .46267 .39541 L p F P
0 g
s
.504 .834 .999 r
.52281 .39672 m .52293 .40033 L .50969 .40125 L p F P
0 g
s
.504 .834 .999 r
.50969 .40125 m .50685 .39783 L .52281 .39672 L p F P
0 g
s
.437 .767 .997 r
.53619 .40111 m .5388 .39766 L .55403 .4006 L p F P
0 g
s
.463 .8 .999 r
.5388 .39766 m .53619 .40111 L .52293 .40033 L p F P
0 g
s
.672 .756 .914 r
.59825 .40338 m .58875 .40867 L .5753 .40118 L p F P
0 g
s
.578 .747 .957 r
.56773 .4054 m .5753 .40118 L .58875 .40867 L p F P
0 g
s
.463 .8 .999 r
.52293 .40033 m .52281 .39672 L .5388 .39766 L p F P
0 g
s
.648 .813 .963 r
.48627 .39594 m .49172 .40093 L .47818 .40587 L p F P
0 g
s
.648 .813 .963 r
.47818 .40587 m .47043 .40173 L .48627 .39594 L p F P
0 g
s
.183 .447 .875 r
.83279 .28712 m .84543 .29313 L .86715 .33785 L p F P
0 g
s
.746 .925 .95 r
.28142 .24111 m .29211 .24086 L .26073 .27508 L p F P
0 g
s
.746 .925 .95 r
.26073 .27508 m .24881 .27687 L .28142 .24111 L p F P
0 g
s
.581 .76 .963 r
.5753 .40118 m .56773 .4054 L .55403 .4006 L p F P
0 g
s
.375 .628 .952 r
.79598 .27379 m .78414 .27212 L .75163 .23823 L p F P
0 g
s
.493 .685 .952 r
.74129 .23994 m .75163 .23823 L .78414 .27212 L p F P
0 g
s
.626 .669 .872 r
.4549 .38691 m .46267 .39541 L .44759 .40418 L p F P
0 g
s
.626 .669 .872 r
.44759 .40418 m .43794 .39684 L .4549 .38691 L p F P
0 g
s
.729 .753 .871 r
.60776 .39594 m .59825 .40338 L .58288 .39477 L p F P
0 g
s
.672 .756 .914 r
.5753 .40118 m .58288 .39477 L .59825 .40338 L p F P
0 g
s
.63 .807 .968 r
.50399 .39229 m .50685 .39783 L .49172 .40093 L p F P
0 g
s
.63 .807 .968 r
.49172 .40093 m .48627 .39594 L .50399 .39229 L p F P
0 g
s
.581 .76 .963 r
.55403 .4006 m .55926 .39555 L .5753 .40118 L p F P
0 g
s
.589 .774 .968 r
.55926 .39555 m .55403 .4006 L .5388 .39766 L p F P
0 g
s
.606 .617 .836 r
.44714 .37637 m .4549 .38691 L .43794 .39684 L p F P
0 g
s
.606 .617 .836 r
.43794 .39684 m .42832 .38748 L .44714 .37637 L p F P
0 g
s
.651 .738 .913 r
.48081 .38874 m .48627 .39594 L .47043 .40173 L p F P
0 g
s
.651 .738 .913 r
.47043 .40173 m .46267 .39541 L .48081 .38874 L p F P
0 g
s
.756 .963 .933 r
.27051 .24297 m .28142 .24111 L .24881 .27687 L p F P
0 g
s
.756 .963 .933 r
.24881 .27687 m .23667 .28027 L .27051 .24297 L p F P
0 g
s
.67 .752 .912 r
.58288 .39477 m .5753 .40118 L .55926 .39555 L p F P
0 g
s
.766 .746 .835 r
.61724 .38648 m .60776 .39594 L .59047 .38619 L p F P
0 g
s
.729 .753 .871 r
.58288 .39477 m .59047 .38619 L .60776 .39594 L p F P
0 g
s
.614 .798 .97 r
.52269 .39098 m .52281 .39672 L .50685 .39783 L p F P
0 g
s
.614 .798 .97 r
.50685 .39783 m .50399 .39229 L .52269 .39098 L p F P
0 g
s
.589 .774 .968 r
.5388 .39766 m .54143 .39209 L .55926 .39555 L p F P
0 g
s
.6 .787 .97 r
.54143 .39209 m .5388 .39766 L .52281 .39672 L p F P
0 g
s
.578 .55 .787 r
.38539 .25875 m .39318 .27274 L .36176 .2927 L p F P
0 g
s
.578 .55 .787 r
.36176 .2927 m .35221 .28005 L .38539 .25875 L p F P
0 g
s
.569 .531 .773 r
.37126 .30644 m .36176 .2927 L .39318 .27274 L p F P
0 g
s
.569 .531 .773 r
.39318 .27274 m .40091 .28779 L .37126 .30644 L p F P
0 g
s
.564 .52 .765 r
.38073 .32084 m .37126 .30644 L .40091 .28779 L p F P
0 g
s
.591 .578 .807 r
.37753 .24617 m .38539 .25875 L .35221 .28005 L p F P
0 g
s
.591 .578 .807 r
.35221 .28005 m .34257 .26881 L .37753 .24617 L p F P
0 g
s
.59 .578 .808 r
.4394 .364 m .44714 .37637 L .42832 .38748 L p F P
0 g
s
.59 .578 .808 r
.42832 .38748 m .41874 .37632 L .4394 .364 L p F P
0 g
s
.564 .52 .765 r
.40091 .28779 m .4086 .30351 L .38073 .32084 L p F P
0 g
s
.563 .517 .762 r
.3902 .33549 m .38073 .32084 L .4086 .30351 L p F P
0 g
s
.6 .787 .97 r
.52281 .39672 m .52269 .39098 L .54143 .39209 L p F P
0 g
s
.256 .562 .935 r
.80804 .27706 m .79598 .27379 L .76218 .23835 L p F P
0 g
s
.375 .628 .952 r
.75163 .23823 m .76218 .23835 L .79598 .27379 L p F P
0 g
s
.563 .517 .762 r
.4086 .30351 m .41629 .31944 L .3902 .33549 L p F P
0 g
s
.564 .52 .765 r
.39968 .34992 m .3902 .33549 L .41629 .31944 L p F P
0 g
s
.788 .738 .807 r
.62669 .37521 m .61724 .38648 L .59805 .37556 L p F P
0 g
s
.766 .746 .835 r
.59047 .38619 m .59805 .37556 L .61724 .38648 L p F P
0 g
s
.608 .616 .834 r
.36957 .23529 m .37753 .24617 L .34257 .26881 L p F P
0 g
s
.608 .616 .834 r
.34257 .26881 m .33282 .25928 L .36957 .23529 L p F P
0 g
s
.578 .55 .787 r
.43167 .35013 m .4394 .364 L .41874 .37632 L p F P
0 g
s
.578 .55 .787 r
.41874 .37632 m .40919 .36367 L .43167 .35013 L p F P
0 g
s
.803 .732 .786 r
.69232 .27813 m .6829 .29091 L .65082 .27129 L p F P
0 g
s
.812 .727 .772 r
.6829 .29091 m .67353 .30476 L .64326 .28644 L p F P
0 g
s
.812 .727 .772 r
.64326 .28644 m .65082 .27129 L .6829 .29091 L p F P
0 g
s
.817 .725 .764 r
.67353 .30476 m .66418 .31928 L .63573 .30225 L p F P
0 g
s
.817 .725 .764 r
.63573 .30225 m .64326 .28644 L .67353 .30476 L p F P
0 g
s
.564 .52 .765 r
.41629 .31944 m .42397 .33513 L .39968 .34992 L p F P
0 g
s
.569 .531 .773 r
.40919 .36367 m .39968 .34992 L .42397 .33513 L p F P
0 g
s
.569 .531 .773 r
.42397 .33513 m .43167 .35013 L .40919 .36367 L p F P
0 g
s
.818 .724 .761 r
.66418 .31928 m .65484 .33405 L .62822 .31827 L p F P
0 g
s
.818 .724 .761 r
.62822 .31827 m .63573 .30225 L .66418 .31928 L p F P
0 g
s
.788 .737 .806 r
.70184 .26678 m .69232 .27813 L .65843 .2572 L p F P
0 g
s
.803 .732 .786 r
.65082 .27129 m .65843 .2572 L .69232 .27813 L p F P
0 g
s
.803 .732 .786 r
.63611 .36245 m .62669 .37521 L .60562 .36311 L p F P
0 g
s
.788 .738 .807 r
.59805 .37556 m .60562 .36311 L .62669 .37521 L p F P
0 g
s
.817 .725 .764 r
.65484 .33405 m .64549 .34858 L .6207 .33406 L p F P
0 g
s
.817 .725 .764 r
.6207 .33406 m .62822 .31827 L .65484 .33405 L p F P
0 g
s
.812 .727 .772 r
.64549 .34858 m .63611 .36245 L .61317 .34915 L p F P
0 g
s
.812 .727 .772 r
.61317 .34915 m .6207 .33406 L .64549 .34858 L p F P
0 g
s
.803 .732 .786 r
.60562 .36311 m .61317 .34915 L .63611 .36245 L p F P
0 g
s
.765 .743 .833 r
.71146 .25712 m .70184 .26678 L .66612 .24452 L p F P
0 g
s
.788 .737 .806 r
.65843 .2572 m .66612 .24452 L .70184 .26678 L p F P
0 g
s
.644 .675 .864 r
.47533 .37935 m .48081 .38874 L .46267 .39541 L p F P
0 g
s
.644 .675 .864 r
.46267 .39541 m .4549 .38691 L .47533 .37935 L p F P
0 g
s
.629 .667 .867 r
.36147 .22629 m .36957 .23529 L .33282 .25928 L p F P
0 g
s
.629 .667 .867 r
.33282 .25928 m .32292 .25164 L .36147 .22629 L p F P
0 g
s
.656 .739 .911 r
.50112 .38454 m .50399 .39229 L .48627 .39594 L p F P
0 g
s
.656 .739 .911 r
.48627 .39594 m .48081 .38874 L .50112 .38454 L p F P
0 g
s
.719 .735 .864 r
.59047 .38619 m .58288 .39477 L .56452 .3883 L p F P
0 g
s
.67 .752 .912 r
.55926 .39555 m .56452 .3883 L .58288 .39477 L p F P
0 g
s
.667 .748 .911 r
.56452 .3883 m .55926 .39555 L .54143 .39209 L p F P
0 g
s
.755 .983 .908 r
.25939 .24612 m .27051 .24297 L .23667 .28027 L p F P
0 g
s
.755 .983 .908 r
.23667 .28027 m .22431 .28497 L .25939 .24612 L p F P
0 g
s
.73 .748 .867 r
.72123 .24937 m .71146 .25712 L .67391 .23353 L p F P
0 g
s
.765 .743 .833 r
.66612 .24452 m .67391 .23353 L .71146 .25712 L p F P
0 g
s
.653 .73 .906 r
.35323 .2193 m .36147 .22629 L .32292 .25164 L p F P
0 g
s
.653 .73 .906 r
.32292 .25164 m .31285 .24602 L .35323 .2193 L p F P
0 g
s
.66 .742 .91 r
.52257 .38303 m .52269 .39098 L .50399 .39229 L p F P
0 g
s
.66 .742 .91 r
.50399 .39229 m .50112 .38454 L .52257 .38303 L p F P
0 g
s
.667 .748 .911 r
.54143 .39209 m .54407 .38431 L .56452 .3883 L p F P
0 g
s
.664 .745 .91 r
.54407 .38431 m .54143 .39209 L .52269 .39098 L p F P
0 g
s
.634 .627 .825 r
.46986 .3679 m .47533 .37935 L .4549 .38691 L p F P
0 g
s
.634 .627 .825 r
.4549 .38691 m .44714 .37637 L .46986 .3679 L p F P
0 g
s
.154 .5 .908 r
.82032 .28162 m .80804 .27706 L .77295 .24009 L p F P
0 g
s
.256 .562 .935 r
.76218 .23835 m .77295 .24009 L .80804 .27706 L p F P
0 g
s
.748 .719 .825 r
.59805 .37556 m .59047 .38619 L .56978 .37885 L p F P
0 g
s
.719 .735 .864 r
.56452 .3883 m .56978 .37885 L .59047 .38619 L p F P
0 g
s
.664 .745 .91 r
.52269 .39098 m .52257 .38303 L .54407 .38431 L p F P
0 g
s
.676 .749 .905 r
.73117 .24363 m .72123 .24937 L .68183 .22444 L p F P
0 g
s
.73 .748 .867 r
.67391 .23353 m .68183 .22444 L .72123 .24937 L p F P
0 g
s
.662 .682 .859 r
.49824 .37459 m .50112 .38454 L .48081 .38874 L p F P
0 g
s
.662 .682 .859 r
.48081 .38874 m .47533 .37935 L .49824 .37459 L p F P
0 g
s
.707 .719 .859 r
.56978 .37885 m .56452 .3883 L .54407 .38431 L p F P
0 g
s
.626 .592 .796 r
.46439 .35461 m .46986 .3679 L .44714 .37637 L p F P
0 g
s
.626 .592 .796 r
.44714 .37637 m .4394 .364 L .46439 .35461 L p F P
0 g
s
.675 .802 .943 r
.34481 .21436 m .35323 .2193 L .31285 .24602 L p F P
0 g
s
.675 .802 .943 r
.31285 .24602 m .30259 .24245 L .34481 .21436 L p F P
0 g
s
.765 .705 .795 r
.60562 .36311 m .59805 .37556 L .57505 .36734 L p F P
0 g
s
.748 .719 .825 r
.56978 .37885 m .57505 .36734 L .59805 .37556 L p F P
0 g
s
.749 .99 .884 r
.24807 .2502 m .25939 .24612 L .22431 .28497 L p F P
0 g
s
.749 .99 .884 r
.22431 .28497 m .21175 .2906 L .24807 .2502 L p F P
0 g
s
.597 .738 .943 r
.74129 .23994 m .73117 .24363 L .68989 .21735 L p F P
0 g
s
.676 .749 .905 r
.68183 .22444 m .68989 .21735 L .73117 .24363 L p F P
0 g
s
.619 .568 .775 r
.45894 .33979 m .46439 .35461 L .4394 .364 L p F P
0 g
s
.619 .568 .775 r
.4394 .364 m .43167 .35013 L .45894 .33979 L p F P
0 g
s
.678 .693 .856 r
.52245 .37288 m .52257 .38303 L .50112 .38454 L p F P
0 g
s
.678 .693 .856 r
.50112 .38454 m .49824 .37459 L .52245 .37288 L p F P
0 g
s
.776 .695 .775 r
.61317 .34915 m .60562 .36311 L .58031 .35398 L p F P
0 g
s
.765 .705 .795 r
.57505 .36734 m .58031 .35398 L .60562 .36311 L p F P
0 g
s
.707 .719 .859 r
.54407 .38431 m .54672 .37433 L .56978 .37885 L p F P
0 g
s
.693 .705 .856 r
.54672 .37433 m .54407 .38431 L .52257 .38303 L p F P
0 g
s
.614 .552 .761 r
.45349 .32383 m .45894 .33979 L .43167 .35013 L p F P
0 g
s
.614 .552 .761 r
.43167 .35013 m .42397 .33513 L .45349 .32383 L p F P
0 g
s
.661 .64 .819 r
.49536 .36256 m .49824 .37459 L .47533 .37935 L p F P
0 g
s
.661 .64 .819 r
.47533 .37935 m .46986 .3679 L .49536 .36256 L p F P
0 g
s
.693 .705 .856 r
.52257 .38303 m .52245 .37288 L .54672 .37433 L p F P
0 g
s
.729 .695 .818 r
.57505 .36734 m .56978 .37885 L .54672 .37433 L p F P
0 g
s
.611 .543 .753 r
.44805 .30716 m .45349 .32383 L .42397 .33513 L p F P
0 g
s
.611 .543 .753 r
.42397 .33513 m .41629 .31944 L .44805 .30716 L p F P
0 g
s
.782 .688 .761 r
.6207 .33406 m .61317 .34915 L .58556 .3391 L p F P
0 g
s
.776 .695 .775 r
.58031 .35398 m .58556 .3391 L .61317 .34915 L p F P
0 g
s
.61 .54 .751 r
.4426 .29023 m .44805 .30716 L .41629 .31944 L p F P
0 g
s
.61 .54 .751 r
.41629 .31944 m .4086 .30351 L .4426 .29023 L p F P
0 g
s
.08 .452 .883 r
.83279 .28712 m .82032 .28162 L .78393 .24312 L p F P
0 g
s
.154 .5 .908 r
.77295 .24009 m .78393 .24312 L .82032 .28162 L p F P
0 g
s
.689 .874 .968 r
.33621 .2114 m .34481 .21436 L .30259 .24245 L p F P
0 g
s
.689 .874 .968 r
.30259 .24245 m .29211 .24086 L .33621 .2114 L p F P
0 g
s
.611 .543 .753 r
.43715 .2735 m .4426 .29023 L .4086 .30351 L p F P
0 g
s
.611 .543 .753 r
.4086 .30351 m .40091 .28779 L .43715 .2735 L p F P
0 g
s
.785 .684 .753 r
.62822 .31827 m .6207 .33406 L .5908 .32308 L p F P
0 g
s
.782 .688 .761 r
.58556 .3391 m .5908 .32308 L .6207 .33406 L p F P
0 g
s
.614 .552 .761 r
.43166 .25742 m .43715 .2735 L .40091 .28779 L p F P
0 g
s
.614 .552 .761 r
.40091 .28779 m .39318 .27274 L .43166 .25742 L p F P
0 g
s
.787 .683 .75 r
.63573 .30225 m .62822 .31827 L .59604 .30634 L p F P
0 g
s
.785 .684 .753 r
.5908 .32308 m .59604 .30634 L .62822 .31827 L p F P
0 g
s
.785 .684 .753 r
.64326 .28644 m .63573 .30225 L .60128 .28934 L p F P
0 g
s
.787 .683 .75 r
.59604 .30634 m .60128 .28934 L .63573 .30225 L p F P
0 g
s
.619 .568 .775 r
.42613 .24239 m .43166 .25742 L .39318 .27274 L p F P
0 g
s
.619 .568 .775 r
.39318 .27274 m .38539 .25875 L .42613 .24239 L p F P
0 g
s
.782 .688 .761 r
.65082 .27129 m .64326 .28644 L .60654 .27254 L p F P
0 g
s
.785 .684 .753 r
.60128 .28934 m .60654 .27254 L .64326 .28644 L p F P
0 g
s
.484 .709 .969 r
.75163 .23823 m .74129 .23994 L .69812 .21231 L p F P
0 g
s
.597 .738 .943 r
.68989 .21735 m .69812 .21231 L .74129 .23994 L p F P
0 g
s
.658 .609 .789 r
.49249 .34868 m .49536 .36256 L .46986 .3679 L p F P
0 g
s
.658 .609 .789 r
.46986 .3679 m .46439 .35461 L .49249 .34868 L p F P
0 g
s
.776 .695 .774 r
.65843 .2572 m .65082 .27129 L .61182 .2564 L p F P
0 g
s
.782 .688 .761 r
.60654 .27254 m .61182 .2564 L .65082 .27129 L p F P
0 g
s
.626 .592 .796 r
.42054 .22876 m .42613 .24239 L .38539 .25875 L p F P
0 g
s
.626 .592 .796 r
.38539 .25875 m .37753 .24617 L .42054 .22876 L p F P
0 g
s
.741 .677 .788 r
.58031 .35398 m .57505 .36734 L .54937 .36227 L p F P
0 g
s
.729 .695 .818 r
.54672 .37433 m .54937 .36227 L .57505 .36734 L p F P
0 g
s
.685 .656 .815 r
.52234 .36064 m .52245 .37288 L .49824 .37459 L p F P
0 g
s
.685 .656 .815 r
.49824 .37459 m .49536 .36256 L .52234 .36064 L p F P
0 g
s
.708 .674 .815 r
.54937 .36227 m .54672 .37433 L .52245 .37288 L p F P
0 g
s
.765 .704 .795 r
.66612 .24452 m .65843 .2572 L .61714 .24129 L p F P
0 g
s
.776 .695 .774 r
.61182 .2564 m .61714 .24129 L .65843 .2572 L p F P
0 g
s
.708 .674 .815 r
.52245 .37288 m .52234 .36064 L .54937 .36227 L p F P
0 g
s
.745 .992 .87 r
.23658 .25479 m .24807 .2502 L .21175 .2906 L p F P
0 g
s
.745 .992 .87 r
.21175 .2906 m .19903 .29674 L .23658 .25479 L p F P
0 g
s
.636 .626 .824 r
.41486 .21681 m .42054 .22876 L .37753 .24617 L p F P
0 g
s
.636 .626 .824 r
.37753 .24617 m .36957 .23529 L .41486 .21681 L p F P
0 g
s
.655 .588 .768 r
.48961 .33326 m .49249 .34868 L .46439 .35461 L p F P
0 g
s
.655 .588 .768 r
.46439 .35461 m .45894 .33979 L .48961 .33326 L p F P
0 g
s
.748 .663 .767 r
.58556 .3391 m .58031 .35398 L .55202 .34835 L p F P
0 g
s
.741 .677 .788 r
.54937 .36227 m .55202 .34835 L .58031 .35398 L p F P
0 g
s
.684 .93 .969 r
.32742 .21027 m .33621 .2114 L .29211 .24086 L p F P
0 g
s
.684 .93 .969 r
.29211 .24086 m .28142 .24111 L .32742 .21027 L p F P
0 g
s
.748 .717 .823 r
.67391 .23353 m .66612 .24452 L .62253 .22759 L p F P
0 g
s
.765 .704 .795 r
.61714 .24129 m .62253 .22759 L .66612 .24452 L p F P
0 g
s
.687 .629 .785 r
.52222 .34655 m .52234 .36064 L .49536 .36256 L p F P
0 g
s
.687 .629 .785 r
.49536 .36256 m .49249 .34868 L .52222 .34655 L p F P
0 g
s
.715 .651 .785 r
.55202 .34835 m .54937 .36227 L .52234 .36064 L p F P
0 g
s
.653 .574 .754 r
.48675 .31668 m .48961 .33326 L .45894 .33979 L p F P
0 g
s
.653 .574 .754 r
.45894 .33979 m .45349 .32383 L .48675 .31668 L p F P
0 g
s
.043 .427 .868 r
.84543 .29313 m .83279 .28712 L .7951 .24708 L p F P
0 g
s
.08 .452 .883 r
.78393 .24312 m .7951 .24708 L .83279 .28712 L p F P
0 g
s
.647 .672 .86 r
.40909 .20674 m .41486 .21681 L .36957 .23529 L p F P
0 g
s
.647 .672 .86 r
.36957 .23529 m .36147 .22629 L .40909 .20674 L p F P
0 g
s
.752 .655 .754 r
.5908 .32308 m .58556 .3391 L .55466 .3329 L p F P
0 g
s
.748 .663 .767 r
.55202 .34835 m .55466 .3329 L .58556 .3391 L p F P
0 g
s
.341 .655 .97 r
.76218 .23835 m .75163 .23823 L .70653 .20924 L p F P
0 g
s
.484 .709 .969 r
.69812 .21231 m .70653 .20924 L .75163 .23823 L p F P
0 g
s
.715 .651 .785 r
.52234 .36064 m .52222 .34655 L .55202 .34835 L p F P
0 g
s
.651 .566 .746 r
.48388 .29938 m .48675 .31668 L .45349 .32383 L p F P
0 g
s
.651 .566 .746 r
.45349 .32383 m .44805 .30716 L .48388 .29938 L p F P
0 g
s
.72 .731 .859 r
.68183 .22444 m .67391 .23353 L .62799 .21557 L p F P
0 g
s
.748 .717 .823 r
.62253 .22759 m .62799 .21557 L .67391 .23353 L p F P
0 g
s
.754 .65 .746 r
.59604 .30634 m .5908 .32308 L .55731 .31629 L p F P
0 g
s
.752 .655 .754 r
.55466 .3329 m .55731 .31629 L .5908 .32308 L p F P
0 g
s
.651 .564 .744 r
.48101 .28181 m .48388 .29938 L .44805 .30716 L p F P
0 g
s
.651 .564 .744 r
.44805 .30716 m .4426 .29023 L .48101 .28181 L p F P
0 g
s
.688 .61 .764 r
.5221 .33091 m .52222 .34655 L .49249 .34868 L p F P
0 g
s
.688 .61 .764 r
.49249 .34868 m .48961 .33326 L .5221 .33091 L p F P
0 g
s
.719 .635 .764 r
.55466 .3329 m .55202 .34835 L .52222 .34655 L p F P
0 g
s
.755 .648 .743 r
.60128 .28934 m .59604 .30634 L .55995 .29896 L p F P
0 g
s
.754 .65 .746 r
.55731 .31629 m .55995 .29896 L .59604 .30634 L p F P
0 g
s
.651 .566 .746 r
.47813 .26444 m .48101 .28181 L .4426 .29023 L p F P
0 g
s
.651 .566 .746 r
.4426 .29023 m .43715 .2735 L .47813 .26444 L p F P
0 g
s
.657 .731 .904 r
.40321 .19868 m .40909 .20674 L .36147 .22629 L p F P
0 g
s
.657 .731 .904 r
.36147 .22629 m .35323 .2193 L .40321 .19868 L p F P
0 g
s
.754 .65 .746 r
.60654 .27254 m .60128 .28934 L .5626 .28135 L p F P
0 g
s
.755 .648 .743 r
.55995 .29896 m .5626 .28135 L .60128 .28934 L p F P
0 g
s
.719 .635 .764 r
.52222 .34655 m .5221 .33091 L .55466 .3329 L p F P
0 g
s
.653 .574 .754 r
.47523 .2477 m .47813 .26444 L .43715 .2735 L p F P
0 g
s
.653 .574 .754 r
.43715 .2735 m .43166 .25742 L .47523 .2477 L p F P
0 g
s
.659 .958 .94 r
.31844 .21074 m .32742 .21027 L .28142 .24111 L p F P
0 g
s
.659 .958 .94 r
.28142 .24111 m .27051 .24297 L .31844 .21074 L p F P
0 g
s
.688 .598 .751 r
.52199 .31412 m .5221 .33091 L .48961 .33326 L p F P
0 g
s
.688 .598 .751 r
.48961 .33326 m .48675 .31668 L .52199 .31412 L p F P
0 g
s
.721 .625 .75 r
.55731 .31629 m .55466 .3329 L .5221 .33091 L p F P
0 g
s
.674 .745 .903 r
.68989 .21735 m .68183 .22444 L .63354 .20543 L p F P
0 g
s
.72 .731 .859 r
.62799 .21557 m .63354 .20543 L .68183 .22444 L p F P
0 g
s
.752 .655 .754 r
.61182 .2564 m .60654 .27254 L .56525 .26394 L p F P
0 g
s
.754 .65 .746 r
.5626 .28135 m .56525 .26394 L .60654 .27254 L p F P
0 g
s
.655 .588 .768 r
.47231 .232 m .47523 .2477 L .43166 .25742 L p F P
0 g
s
.655 .588 .768 r
.43166 .25742 m .42613 .24239 L .47231 .232 L p F P
0 g
s
.721 .625 .75 r
.5221 .33091 m .52199 .31412 L .55731 .31629 L p F P
0 g
s
.748 .663 .767 r
.61714 .24129 m .61182 .2564 L .56792 .24717 L p F P
0 g
s
.752 .655 .754 r
.56525 .26394 m .56792 .24717 L .61182 .2564 L p F P
0 g
s
.688 .592 .743 r
.52187 .29659 m .52199 .31412 L .48675 .31668 L p F P
0 g
s
.688 .592 .743 r
.48675 .31668 m .48388 .29938 L .52187 .29659 L p F P
0 g
s
.187 .579 .939 r
.77295 .24009 m .76218 .23835 L .71512 .20801 L p F P
0 g
s
.341 .655 .97 r
.70653 .20924 m .71512 .20801 L .76218 .23835 L p F P
0 g
s
.721 .619 .743 r
.55995 .29896 m .55731 .31629 L .52199 .31412 L p F P
0 g
s
.043 .427 .868 r
.7951 .24708 m .80644 .25154 L .84543 .29313 L p F P
0 g
s
.658 .609 .788 r
.46935 .21769 m .47231 .232 L .42613 .24239 L p F P
0 g
s
.658 .609 .788 r
.42613 .24239 m .42054 .22876 L .46935 .21769 L p F P
0 g
s
.688 .589 .74 r
.52175 .27879 m .52187 .29659 L .48388 .29938 L p F P
0 g
s
.688 .589 .74 r
.48388 .29938 m .48101 .28181 L .52175 .27879 L p F P
0 g
s
.661 .8 .949 r
.3972 .19265 m .40321 .19868 L .35323 .2193 L p F P
0 g
s
.661 .8 .949 r
.35323 .2193 m .34481 .21436 L .3972 .19265 L p F P
0 g
s
.722 .617 .74 r
.5626 .28135 m .55995 .29896 L .52187 .29659 L p F P
0 g
s
.721 .619 .743 r
.52199 .31412 m .52187 .29659 L .55995 .29896 L p F P
0 g
s
.74 .676 .788 r
.62253 .22759 m .61714 .24129 L .57061 .23143 L p F P
0 g
s
.748 .663 .767 r
.56792 .24717 m .57061 .23143 L .61714 .24129 L p F P
0 g
s
.688 .592 .743 r
.52164 .26118 m .52175 .27879 L .48101 .28181 L p F P
0 g
s
.688 .592 .743 r
.48101 .28181 m .47813 .26444 L .52164 .26118 L p F P
0 g
s
.6 .751 .95 r
.69812 .21231 m .68989 .21735 L .6392 .19729 L p F P
0 g
s
.674 .745 .903 r
.63354 .20543 m .6392 .19729 L .68989 .21735 L p F P
0 g
s
.721 .619 .743 r
.56525 .26394 m .5626 .28135 L .52175 .27879 L p F P
0 g
s
.722 .617 .74 r
.52187 .29659 m .52175 .27879 L .5626 .28135 L p F P
0 g
s
.662 .639 .817 r
.46635 .20505 m .46935 .21769 L .42054 .22876 L p F P
0 g
s
.662 .639 .817 r
.42054 .22876 m .41486 .21681 L .46635 .20505 L p F P
0 g
s
.688 .598 .75 r
.52152 .2442 m .52164 .26118 L .47813 .26444 L p F P
0 g
s
.688 .598 .75 r
.47813 .26444 m .47523 .2477 L .52152 .2442 L p F P
0 g
s
.728 .693 .816 r
.62799 .21557 m .62253 .22759 L .57333 .21708 L p F P
0 g
s
.74 .676 .788 r
.57061 .23143 m .57333 .21708 L .62253 .22759 L p F P
0 g
s
.72 .625 .75 r
.56792 .24717 m .56525 .26394 L .52164 .26118 L p F P
0 g
s
.721 .619 .743 r
.52175 .27879 m .52164 .26118 L .56525 .26394 L p F P
0 g
s
.621 .958 .893 r
.30927 .21251 m .31844 .21074 L .27051 .24297 L p F P
0 g
s
.621 .958 .893 r
.27051 .24297 m .25939 .24612 L .30927 .21251 L p F P
0 g
s
.688 .61 .764 r
.5214 .22826 m .52152 .2442 L .47523 .2477 L p F P
0 g
s
.688 .61 .764 r
.47523 .2477 m .47231 .232 L .5214 .22826 L p F P
0 g
s
.718 .635 .764 r
.57061 .23143 m .56792 .24717 L .52152 .2442 L p F P
0 g
s
.72 .625 .75 r
.52164 .26118 m .52152 .2442 L .56792 .24717 L p F P
0 g
s
.647 .868 .982 r
.39105 .18859 m .3972 .19265 L .34481 .21436 L p F P
0 g
s
.647 .868 .982 r
.34481 .21436 m .33621 .2114 L .39105 .18859 L p F P
0 g
s
.664 .68 .855 r
.4633 .19429 m .46635 .20505 L .41486 .21681 L p F P
0 g
s
.664 .68 .855 r
.41486 .21681 m .40909 .20674 L .4633 .19429 L p F P
0 g
s
.05 .499 .889 r
.78393 .24312 m .77295 .24009 L .72391 .20838 L p F P
0 g
s
.187 .579 .939 r
.71512 .20801 m .72391 .20838 L .77295 .24009 L p F P
0 g
s
.708 .715 .855 r
.63354 .20543 m .62799 .21557 L .5761 .20441 L p F P
0 g
s
.728 .693 .816 r
.57333 .21708 m .5761 .20441 L .62799 .21557 L p F P
0 g
s
.484 .738 .983 r
.70653 .20924 m .69812 .21231 L .64498 .19119 L p F P
0 g
s
.6 .751 .95 r
.6392 .19729 m .64498 .19119 L .69812 .21231 L p F P
0 g
s
.687 .629 .785 r
.52128 .21371 m .5214 .22826 L .47231 .232 L p F P
0 g
s
.687 .629 .785 r
.47231 .232 m .46935 .21769 L .52128 .21371 L p F P
0 g
s
.718 .635 .764 r
.52152 .2442 m .5214 .22826 L .57061 .23143 L p F P
0 g
s
.715 .651 .784 r
.57333 .21708 m .57061 .23143 L .5214 .22826 L p F P
0 g
s
.661 .732 .902 r
.46018 .18553 m .4633 .19429 L .40909 .20674 L p F P
0 g
s
.661 .732 .902 r
.40909 .20674 m .40321 .19868 L .46018 .18553 L p F P
0 g
s
.715 .651 .784 r
.5214 .22826 m .52128 .21371 L .57333 .21708 L p F P
0 g
s
.685 .654 .813 r
.52116 .20082 m .52128 .21371 L .46935 .21769 L p F P
0 g
s
.685 .654 .813 r
.46935 .21769 m .46635 .20505 L .52116 .20082 L p F P
0 g
s
.708 .672 .813 r
.5761 .20441 m .57333 .21708 L .52128 .21371 L p F P
0 g
s
.672 .741 .902 r
.6392 .19729 m .63354 .20543 L .57891 .19362 L p F P
0 g
s
.708 .715 .855 r
.5761 .20441 m .57891 .19362 L .63354 .20543 L p F P
0 g
s
.587 .946 .847 r
.29992 .21519 m .30927 .21251 L .25939 .24612 L p F P
0 g
s
.587 .946 .847 r
.25939 .24612 m .24807 .2502 L .29992 .21519 L p F P
0 g
s
.602 .913 .979 r
.38476 .18637 m .39105 .18859 L .33621 .2114 L p F P
0 g
s
.602 .913 .979 r
.33621 .2114 m .32742 .21027 L .38476 .18637 L p F P
0 g
s
.708 .672 .813 r
.52128 .21371 m .52116 .20082 L .5761 .20441 L p F P
0 g
s
0 .435 .842 r
.7951 .24708 m .78393 .24312 L .73288 .21004 L p F P
0 g
s
.05 .499 .889 r
.72391 .20838 m .73288 .21004 L .78393 .24312 L p F P
0 g
s
.322 .688 .979 r
.71512 .20801 m .70653 .20924 L .6509 .18706 L p F P
0 g
s
.484 .738 .983 r
.64498 .19119 m .6509 .18706 L .70653 .20924 L p F P
0 g
s
.68 .689 .852 r
.52103 .18981 m .52116 .20082 L .46635 .20505 L p F P
0 g
s
.68 .689 .852 r
.46635 .20505 m .4633 .19429 L .52103 .18981 L p F P
0 g
s
.694 .701 .852 r
.57891 .19362 m .5761 .20441 L .52116 .20082 L p F P
0 g
s
.646 .795 .954 r
.457 .1788 m .46018 .18553 L .40321 .19868 L p F P
0 g
s
.646 .795 .954 r
.40321 .19868 m .3972 .19265 L .457 .1788 L p F P
0 g
s
.608 .764 .954 r
.64498 .19119 m .6392 .19729 L .58178 .18482 L p F P
0 g
s
.672 .741 .902 r
.57891 .19362 m .58178 .18482 L .6392 .19729 L p F P
0 g
s
.694 .701 .852 r
.52116 .20082 m .52103 .18981 L .57891 .19362 L p F P
0 g
s
.665 .735 .902 r
.5209 .1808 m .52103 .18981 L .4633 .19429 L p F P
0 g
s
.665 .735 .902 r
.4633 .19429 m .46018 .18553 L .5209 .1808 L p F P
0 g
s
.526 .914 .927 r
.37832 .18574 m .38476 .18637 L .32742 .21027 L p F P
0 g
s
.526 .914 .927 r
.32742 .21027 m .31844 .21074 L .37832 .18574 L p F P
0 g
s
.567 .936 .82 r
.29042 .21838 m .29992 .21519 L .24807 .2502 L p F P
0 g
s
.567 .936 .82 r
.24807 .2502 m .23658 .25479 L .29042 .21838 L p F P
0 g
s
.669 .737 .902 r
.58178 .18482 m .57891 .19362 L .52103 .18981 L p F P
0 g
s
.138 .601 .925 r
.72391 .20838 m .71512 .20801 L .65695 .18476 L p F P
0 g
s
.322 .688 .979 r
.6509 .18706 m .65695 .18476 L .71512 .20801 L p F P
0 g
s
.602 .853 .992 r
.45374 .17404 m .457 .1788 L .3972 .19265 L p F P
0 g
s
.602 .853 .992 r
.3972 .19265 m .39105 .18859 L .45374 .17404 L p F P
0 g
s
0 .401 .814 r
.80644 .25154 m .7951 .24708 L .74202 .21262 L p F P
0 g
s
0 .435 .842 r
.73288 .21004 m .74202 .21262 L .7951 .24708 L p F P
0 g
s
.669 .737 .902 r
.52103 .18981 m .5209 .1808 L .58178 .18482 L p F P
0 g
s
.497 .769 .992 r
.6509 .18706 m .64498 .19119 L .58471 .17805 L p F P
0 g
s
.608 .764 .954 r
.58178 .18482 m .58471 .17805 L .64498 .19119 L p F P
0 g
s
.631 .787 .956 r
.52077 .17381 m .5209 .1808 L .46018 .18553 L p F P
0 g
s
.631 .787 .956 r
.46018 .18553 m .457 .1788 L .52077 .17381 L p F P
0 g
s
.618 .776 .957 r
.58471 .17805 m .58178 .18482 L .5209 .1808 L p F P
0 g
s
.441 .878 .845 r
.37174 .18639 m .37832 .18574 L .31844 .21074 L p F P
0 g
s
.441 .878 .845 r
.31844 .21074 m .30927 .21251 L .37174 .18639 L p F P
0 g
s
.618 .776 .957 r
.5209 .1808 m .52077 .17381 L .58471 .17805 L p F P
0 g
s
.511 .877 .981 r
.4504 .1711 m .45374 .17404 L .39105 .18859 L p F P
0 g
s
.511 .877 .981 r
.39105 .18859 m .38476 .18637 L .4504 .1711 L p F P
0 g
s
0 .502 .84 r
.73288 .21004 m .72391 .20838 L .66314 .18406 L p F P
0 g
s
.138 .601 .925 r
.65695 .18476 m .66314 .18406 L .72391 .20838 L p F P
0 g
s
.328 .729 .981 r
.65695 .18476 m .6509 .18706 L .58771 .17325 L p F P
0 g
s
.497 .769 .992 r
.58471 .17805 m .58771 .17325 L .6509 .18706 L p F P
0 g
s
0 .401 .814 r
.74202 .21262 m .75131 .21571 L .80644 .25154 L p F P
0 g
s
.558 .829 .996 r
.52063 .1688 m .52077 .17381 L .457 .1788 L p F P
0 g
s
.558 .829 .996 r
.457 .1788 m .45374 .17404 L .52063 .1688 L p F P
0 g
s
.522 .8 .997 r
.58771 .17325 m .58471 .17805 L .52077 .17381 L p F P
0 g
s
.522 .8 .997 r
.52077 .17381 m .52063 .1688 L .58771 .17325 L p F P
0 g
s
.372 .834 .77 r
.36503 .18797 m .37174 .18639 L .30927 .21251 L p F P
0 g
s
.372 .834 .77 r
.30927 .21251 m .29992 .21519 L .36503 .18797 L p F P
0 g
s
.381 .84 .901 r
.44698 .16975 m .4504 .1711 L .38476 .18637 L p F P
0 g
s
.381 .84 .901 r
.38476 .18637 m .37832 .18574 L .44698 .16975 L p F P
0 g
s
.127 .635 .899 r
.66314 .18406 m .65695 .18476 L .59078 .17027 L p F P
0 g
s
.328 .729 .981 r
.58771 .17325 m .59078 .17027 L .65695 .18476 L p F P
0 g
s
0 .423 .763 r
.74202 .21262 m .73288 .21004 L .66947 .18464 L p F P
0 g
s
0 .502 .84 r
.66314 .18406 m .66947 .18464 L .73288 .21004 L p F P
0 g
s
.427 .828 .98 r
.52049 .1656 m .52063 .1688 L .45374 .17404 L p F P
0 g
s
.427 .828 .98 r
.45374 .17404 m .4504 .1711 L .52049 .1656 L p F P
0 g
s
.363 .776 .98 r
.59078 .17027 m .58771 .17325 L .52063 .1688 L p F P
0 g
s
.363 .776 .98 r
.52063 .1688 m .52049 .1656 L .59078 .17027 L p F P
0 g
s
.336 .808 .729 r
.3582 .19003 m .36503 .18797 L .29992 .21519 L p F P
0 g
s
.336 .808 .729 r
.29992 .21519 m .29042 .21838 L .3582 .19003 L p F P
0 g
s
.252 .764 .786 r
.44348 .16968 m .44698 .16975 L .37832 .18574 L p F P
0 g
s
.252 .764 .786 r
.37832 .18574 m .37174 .18639 L .44348 .16968 L p F P
0 g
s
0 .522 .781 r
.66947 .18464 m .66314 .18406 L .59392 .16888 L p F P
0 g
s
.127 .635 .899 r
.59078 .17027 m .59392 .16888 L .66314 .18406 L p F P
0 g
s
0 .381 .72 r
.75131 .21571 m .74202 .21262 L .67593 .18613 L p F P
0 g
s
0 .423 .763 r
.66947 .18464 m .67593 .18613 L .74202 .21262 L p F P
0 g
s
.254 .758 .882 r
.52035 .16398 m .52049 .1656 L .4504 .1711 L p F P
0 g
s
.254 .758 .882 r
.4504 .1711 m .44698 .16975 L .52035 .16398 L p F P
0 g
s
.166 .687 .881 r
.59392 .16888 m .59078 .17027 L .52049 .1656 L p F P
0 g
s
.166 .687 .881 r
.52049 .1656 m .52035 .16398 L .59392 .16888 L p F P
0 g
s
0 0 0 r
.4399 .17052 m .44348 .16968 L .37174 .18639 L p F P
0 g
s
0 0 0 r
.37174 .18639 m .36503 .18797 L .4399 .17052 L p F P
0 g
s
0 .522 .781 r
.59392 .16888 m .59714 .16877 L .66947 .18464 L p F P
0 g
s
.161 0 0 r
.67593 .18613 m .66947 .18464 L .59714 .16877 L p F P
0 g
s
0 .381 .72 r
.67593 .18613 m .6825 .18812 L .75131 .21571 L p F P
0 g
s
.097 .653 .746 r
.5202 .16365 m .52035 .16398 L .44698 .16975 L p F P
0 g
s
.097 .653 .746 r
.44698 .16975 m .44348 .16968 L .5202 .16365 L p F P
0 g
s
0 .57 .744 r
.59714 .16877 m .59392 .16888 L .52035 .16398 L p F P
0 g
s
0 .57 .744 r
.52035 .16398 m .5202 .16365 L .59714 .16877 L p F P
0 g
s
0 0 0 r
.43627 .17185 m .4399 .17052 L .36503 .18797 L p F P
0 g
s
0 0 0 r
.36503 .18797 m .3582 .19003 L .43627 .17185 L p F P
0 g
s
.215 0 0 r
.6825 .18812 m .67593 .18613 L .60042 .16957 L p F P
0 g
s
.161 0 0 r
.59714 .16877 m .60042 .16957 L .67593 .18613 L p F P
0 g
s
.008 0 0 r
.52005 .16422 m .5202 .16365 L .44348 .16968 L p F P
0 g
s
.008 0 0 r
.44348 .16968 m .4399 .17052 L .52005 .16422 L p F P
0 g
s
.117 0 0 r
.60042 .16957 m .59714 .16877 L .5202 .16365 L p F P
0 g
s
.117 0 0 r
.5202 .16365 m .52005 .16422 L .60042 .16957 L p F P
0 g
s
.215 0 0 r
.60042 .16957 m .60376 .17085 L .6825 .18812 L p F P
0 g
s
.058 0 0 r
.5199 .16528 m .52005 .16422 L .4399 .17052 L p F P
0 g
s
.058 0 0 r
.4399 .17052 m .43627 .17185 L .5199 .16528 L p F P
0 g
s
.168 0 0 r
.60376 .17085 m .60042 .16957 L .52005 .16422 L p F P
0 g
s
.168 0 0 r
.52005 .16422 m .5199 .16528 L .60376 .17085 L p F P
0 g
s
.25 Mabswid
.69556 0 m
.98755 .43361 L
s
.98755 .43361 m
1 .52479 L
s
1 .52479 m
.70134 .09974 L
s
.70134 .09974 m
.69556 0 L
s
.01509 .2579 m
0 .35323 L
s
0 .35323 m
.70134 .09974 L
s
.70134 .09974 m
.69556 0 L
s
.69556 0 m
.01509 .2579 L
s
.01509 .2579 m
.69556 0 L
s
.0873 .23053 m
.09207 .23503 L
s
[(-5)] .07775 .22154 1 .94193 Mshowa
.33317 .13735 m
.33754 .14224 L
s
[(0)] .32443 .12758 .89424 1 Mshowa
.6035 .03489 m
.60735 .0402 L
s
[(5)] .59579 .02429 .72683 1 Mshowa
.125 Mabswid
.13467 .21258 m
.13749 .21532 L
s
.18293 .19429 m
.1857 .19708 L
s
.23207 .17566 m
.2348 .1785 L
s
.28215 .15669 m
.28482 .15957 L
s
.38516 .11764 m
.38773 .12062 L
s
.43816 .09755 m
.44067 .10058 L
s
.4922 .07708 m
.49465 .08016 L
s
.5473 .05619 m
.54968 .05932 L
s
.04077 .24817 m
.04367 .25082 L
s
.66082 .01317 m
.66306 .0164 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oooooool]
ooooo`00]Oooool3o`0007Cooooo002dooooo`05o`000?ooooooooooooooool00000Loooool00;So
oooo00?o0000ooooooooool05oooool2o`0005Sooooo002hooooo`03o`000?oooooooooo01Cooooo
0ol000000ooooooo0000ooooo`1Gooooo`00]?ooool4o`0001Cooooo0ol00004ooooo`;o0000Eooo
ool00;Cooooo00?o0000ooooooooool04oooool2o`0000Oooooo00?o0000ooooool00000E_ooool0
0;Cooooo1Ol0000>ooooo`Go00001oooool00ol0003oooooo`00001Fooooo`00a?ooool3o`0000co
oooo00Co0000oooooooooooo0000EOooool00<;ooooo0_l0000?ooooo`05o`000?oooooooooooooo
ool00000E?ooool00;oooooo0ol0000Booooo`04o`000?oooooo0000o`0005Cooooo002mooooo`;o
00005Oooool01Ol0003ooooooooooooooooo000005?ooooo002jooooo`?o00005oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo053ooooo002gooooo`?o00000_ooool00ol0003ooooo
ooooo`0Eooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0D?ooool00;Gooooo0_l0
0006ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0;ooooo`?o0000@Oooool00;;ooooo0ol0000Oooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool02Oooool01Ol0003ooooooooooooooooo0000043ooooo002_ooooo`?o00008_ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00?ooooo1Ol00005ooooo`03o`000?oooooo
oooo03kooooo002]ooooo`;o00009Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool0?_ooool00:[ooooo1Ol0000Uooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool01oooool4o`00047ooooo002Wooooo`?o0000:_ooool00ol0003ooooo
ooooo`06ooooo`;o00002?ooool00ol0003oooooooooo`12ooooo`00YOooool2o`0002gooooo00?o
0000ooooooooool01Oooool00ol0003oooooo`000008ooooo`Go0000@?ooool00:;ooooo0ol0000_
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0B_ooool00:3ooooo0_l0000boooo
o`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0BOooool009gooooo0ol0000eooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool0BOooool009[ooooo0ol00003ooooo`03o`00
0?oooooooooo03;ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`18ooooo`00V?oo
ool2o`0003_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`17ooooo`00UOooool3
o`0003gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`17ooooo`00T_ooool3o`00
043ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`16ooooo`00LOooool2o`0001go
oooo0_l00013ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0AOooool0073ooooo
00Co0000oooooooooooo00006Oooool3o`0000;ooooo00?o0000ooooooooool0?oooool2o`0000ko
oooo00?o0000ooooooooool0AOooool0073ooooo00Co0000oooooooooooo00005_ooool3o`0004Co
oooo0ol000000ooooooo0000ooooo`0>ooooo`03o`000?oooooooooo04Cooooo001`ooooo`04o`00
0?ooooooooooo`0001Cooooo0_l00014ooooo`?o00001Oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo04?ooooo001`ooooo`04o`000?ooooooooooo`00017ooooo0ol00013ooooo`?o
00002Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo04?ooooo001`ooooo`04o`00
0?ooooooooooo`0000oooooo0_l00013ooooo`?o00003?ooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo04;ooooo001aooooo`;o00003Oooool3o`000003ooooool0003ooooo043ooooo
0_l0000@ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0@Oooool007gooooo0ol0
0013ooooo`?o00004oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo047ooooo001k
ooooo`;o0000@oooool3o`0001Oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`10
ooooo`00N?ooool3o`0004;ooooo0ol0000Jooooo`03o`000?oooooooooo00gooooo00?o0000oooo
ooooool0?oooool007Gooooo0ol00012ooooo`?o00007_ooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo03oooooo001cooooo`;o00000_ooool00ol0003oooooooooo`0mooooo`?o0000
8_ooool00ol0003oooooooooo`0;ooooo`;o0000@?ooool0073ooooo0ol00005ooooo`03o`000?oo
oooooooo03[ooooo0_l0000Uooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0?Ooo
ool006gooooo0ol00012ooooo`?o0000:?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo03gooooo001[ooooo`;o0000@_ooool3o`0002cooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`0looooo`00J?ooool3o`00047ooooo0ol0000`ooooo`03o`000?oooooooooo00co
oooo00?o0000ooooooooool0>oooool006Kooooo0_l00002ooooo`03o`000?oooooooooo03cooooo
0ol0000cooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0>oooool006?ooooo0ol0
000koooooa3o0000;oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo03[ooooo001P
ooooo`?o0000=?oooolVo`0002Cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0i
ooooo`00G_ooool2o`0002oooooo3_l00004ofgCnP?o00000_n>e?h00ol0003oQLcoohG<o`03ohG<
oaKo00007oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo03Wooooo001Kooooo`?o
0000;Oooool;o`0000?oKM?j1On>e?h9o`0000koQLco1?l00003oe>jn`;o8:;V00?o0000ocL00?l0
00001Ol0000Looooo`03o`000?oooooooooo00_ooooo0_l0000jooooo`00F?ooool3o`0000;ooooo
00?o0000ooooooooool09_ooool6o`000003od33bOmQenKo000000?o00000_nJf_d3o`0000;oS]Cn
1Ol00006oj79m0?o00002OnNa_@8o`0000CoOlCm00?o0000oe>jnomC^_/00omC^_/2o`000003ocL0
0?l0003o000000Co00006?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo03Oooooo
001Fooooo`;o0000:Oooool6o`000004od33bOl0003oHMOVoh;Pn`;o00000onJf_d4o`0000;oYL_d
00?o0000oj79m?nQbO@00_l00004oj79m0?o00001?nZ_>H00ol0003oZkcVoj^liP06oj^liPSo0000
1?nK`o@00ol0003oOlCmogo4o@03ogo4o@Go000000CoDk[ko`000?l0003o=`001Ol0000Dooooo`03
o`000?oooooooooo00cooooo00?o0000ooooooooool0=oooool005?ooooo0ol0000Xooooo`Go0000
00Go@<?9o`000?mQenKoP^3ko`000004oi[Jo@?o00001_nUbo@4o`000003oj79m?l0003oZ[cV00_o
Z[cV00?o0000oj^li_n[_>H03?n[_>H00ol0003o[;gVojbmiP02o`0000GoVl?d1Ol000001?moa?go
0000o`000?l00002oe:`nP;o8iW/00?o0000ocL00?l000000_l0000Booooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool0=_ooool0033ooooo0ol0000Mooooo`?o0000:?ooool9o`0000;o
YMkk0_l000000onJf_go0000ojG;m005ojG;m0Ko000000?oZK_Vo`000?nZ_>H01onZ_>H8o`0000?o
ZkcV1?l00006oj^liP03o`000?n/_NKo[;gV00Go[;gV0ol00005oi_3m0;o00000omk_?/01_l0003o
D[3joe:`n_mB/?[o8iW/o`0000;o066h0ol0000@ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool0=Oooool002oooooo00Go0000ooooooooooooooooo`00000Jooooo`?o0000:?ooool5
o`000003ohKYkOl0003oV^Wj00?oYMkk0_l000000onYc?;o0000ojG;m003ojG;m0Oo00000onY^nH3
o`000003ojZli_l0003o000000Co00001on^/=X00ol0003o/K?Jok6cfP05ok6cfPOo00002_n/_NH4
o`0000;oVl?d00?o0000oiW0lol000001?mk_?/01_l0003oD[3joe:`n_lSVNco0000o`20e`;o066h
0_l0000?ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0=Oooool002Wooooo1Ol0
0005ooooo`03o`000?oooooooooo01Gooooo0ol00003ooooo`03o`000?oooooooooo02;ooooo0ol0
00001_mOeLGoL>3Ho`000?n6jNgo0000oi[YnP?oYMkk0_l00003ojW<lPCo00000_nY^nH3o`000003
ojVki_l0003o000000?o00000_nY[]X00ol0003o[[3Jojj`fP0<ojj`fP03o`000?na/m[o/K?J00_o
/K?J00?o0000okFgf_ne]mX01Ol00007ojbmiP;o00001OnI`?<01?l0003oNkckog^lnomk_?/2o`00
00;oD[3j00Co8iW/o`000?l0003o066h0ol0000<ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool0=?ooool003?ooooo00?o0000ooooooooool04oooool2o`0002Wooooo1Ol000001?n6
jNgo0000oi[Yn_l00002ojGNn`?o00000_nYc?83o`0000;oZ;_W1?l000001?nY^nKo0000o`000?l0
0008ojV^fP03o`000?n^/=[o[[3J00Co[[3J2?l00003ok6cfP_o00001one]mX5o`0000;o[;gV00Co
0000ojbnion/_^Oo00001OnI`?<2o`0000;oNkck0ol000000omB/?[o8iW/o`000002o`000003o`1Q
^?l0003o000000_ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0cooooo`00;ooo
ool4o`0001?ooooo0ol0000Yooooo`;o000000KoGmG5o`000?l0003oQ^W]o`000?nJjOX4ojGNn`04
o`000?nYc?;oZLcbojW<lP;o00001?nX^nL4o`0000_oZJkJ0ol000000on^/=[o0000o`000003o`00
00Oo[jO@00?o0000okF/d?ne[=002one[=000ol0003o^[7@okZad005o`0000Go]KOJ0_l00006ojbn
i`;o00000onI`?<3o`0000;oNkck0_l000000omB/?[o8iW/o`000002o`000003o`1Q^?l0003o0000
00[ooooo00?o0000ooooooooool02oooool2o`0003Cooooo000_ooooo`03o`000?oooooooooo017o
oooo0ol0000Yooooo`?o000000?oGmG5o`000?l000001Ol00002ojGNn`04o`000?nYc?;oZLcbojW<
lP;o00000onX^nL4o`000003ojF/g?l0003oZJkJ00KoZJkJ1Ol00002ojVSd@03o`000?n_Ym3o[jO@
00_o[jO@00?o0000okF/d?ne[=002one[=000ol0003o^[7@okZad005okZad0Co00000_ne]mX01?l0
003o^;_Ko`000?l00006ojbni`;o00000onI`?<2o`0000;oNkck00Co0000oeNWn?mGYoSoEjOh1ol0
0007ooooo`03o`000?oooooooooo00_ooooo0_l0000dooooo`00;oooool5o`0000gooooo0_l00000
0ooooooo0000o`00000Wooooo`Go000000CoZ?G`o`000?n_k_So00000on`goL3o`0000;oZLcb0_l0
0002ojRki`Co00001OnU[=`00ol0003oZJkJojV^fP04o`0000OoZJ?A00?o0000ojnWd?n_Ym001?n_
Ym08o`000003okF/d?l0003o000000Co00001One[=000ol0003o^[7@okZad00:okZad0;o00001Onh
^m/3o`0000Co[;kW0ol00002oiW0l`04o`000?mk]OSoNkGhog^en0?oEjOh00Co0000o`aohol<On?o
37oS1?l00006ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0<Oooool003kooooo
0ol0000Zooooo`;o000000?oU_;Ho`000?l000000ol000000on_k_So0000ok3Om`02ok3Om`03o`00
0?n/cO7o[<ga00;o00000_nX^nL5o`0000KoYJcL0ol0000:ojVSd@?o000000?o[jO@o`000?l00000
0ol00007ojnQb003o`000?ngY/So]jK800Go]jK81_l0000=okZad003o`000?no]m;o000000Ko^;_K
0_l00005ojbni`04o`000?nH_?7oV;caoiRll@?oNkGh00Go0000oeNWn?mGYoSoEjOho`000002o`ao
h`04o`000?l0I]3o06K@o`0000Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`06
ooooo`;o0000:?ooool003_ooooo0ol0000/ooooo`Go000000?oZ?G`o`000?n_k_P00_l00002ok3O
m`;o00000_n/cO400ol0003oYk[Wo`000002o`000003ojRkiol0003o000000GoYJcL0ol000000onR
X=;o0000ojVSd@06ojVSd@Co00000_nXVlT00ol0003o[j78ojnQb00;ojnQb003o`000?ngY/So]jK8
00[o]jK800Co0000okf]bOnm[LWo_Jg91_l00003okZad003o`000?no]m;o_kOB00?o_kOB0_l00004
okRkf`?o000000Co[;kWo`000?n]_nOo[KoW0onH_?401Ol0003oNkGhog^en?mk]OSo000000;oEjOh
0_l00002o`aoh`;o06K@0_l00004ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
1Oooool01?l0003oooooooooool0000Wooooo`00>Oooool2o`0002gooooo0_l000002?nFl]So0000
oikei?l0003oZ?G`o`000?n_k_So00000_n`goL2o`0000;o[<ga1?l000000onW^^Oo0000o`000005
ojF/g0?o00001OnRX=801?l0003oZJ?AojVSdOnYXm43o`0000KoZ9_900?o0000ojnQb?n_XLP02on_
XLP00ol0003o]jK8okNVb009okNVb003o`000?nm[LWo_Jg900So_Jg90ol00008okngdP;o00001Onh
^m/00ol0003o[KoWojfoi`02ojfoi`05o`000?nH_?7oV;caoiRllOl000000omk]OP00ol0003oEjOh
oeNWn002o`0000;o37oS0_l0I]000ol0003oooooooooo`02ooooo`03o`000?oooooooooo00cooooo
00?o0000ooooooooool01?ooool01?l0003oooooooooool0000Wooooo`00=_ooool3o`0002kooooo
00?o0000oi7_dOnFl]P00_l000001OnXmO3o0000ojo^n?n_k_So000000;o/=og00?o0000ojc=lOn/
cO401?l00002ojNji`04o`000?nQZ]goXJ[Mo`0000;oYJcL0_l00008oj:PdP?o00002onXVlT00ol0
003o[j78ojnQb004ojnQb0Oo000000?o]jK8o`000?l000002Ol0000<okf]b@03o`000?o3]<_o0000
00;o00001_no]m83o`000004okRkfol0003o^[oMokZog@Go[KoW00Go0000oiRllOnH_?7oV;cao`00
0002og^en0;o000000SoEjOho`000?l0003o0000o`aohol0003o06K@o`0000Cooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooo`0002Oooooo000coooo
o`?o00000oooool00ol0003oooooooooo`0Yooooo`;o000000KoU_;Ho`000?nNmNCo0000ojSel?l0
0002ojo^n0?o/=og00?o0000ojc=lOl000000_l00003ojNji`;o00000onQZ]d2o`0000SoXZ3B0ol0
00000onPUl_o0000ojRKb@08ojRKb@[o00001_n`W<<00ol0003o]j;3okNR``09okNR``03o`000?no
ZLCo_jW400Co00001_nm[LT00ol0003o`kC;ol>db`02ol>db`;o00001ono]m800ol0003o^[oMokZo
g@03okZog@05o`000?n]_nOo[KoWojfoiol000000onH_?42o`0000;oNkGh00?o0000oeNWn?mGYoP0
0ol000001?l<On?o06K@o`000?l00003ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool00oooool01?l0003oooooooooool0000Wooooo`00<Oooool2o`00033ooooo0_l000001?nAkm7o
U_;Ho`000?nNmN@2ojSel0?o[nkh0on`goL4o`0000CoYk[W00?o0000oj6ZgOnQZ]d00_nQZ]d00ol0
003oVigEo`000005oj:PdP?o00001OnPUl/00ol0003oZ9_9ojRKb@06o`0000?oYiK400?o0000ok2L
`on`W<<02_n`W<<00ol0003o]j;3okNR``09okNR``03o`000?noZLCo_jW400Co_jW41?l000000onm
[LWo0000ol>db`06ol>db`;o00001Ono]m800ol0003o`kkEo`000004okZog@;o00000_n]_nL2o`00
00?oV;ca00?o0000og^en?l000001_l00002o`aoh`05o`1Vd?l0003oooooooooool000003_ooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0002Oooooo000^ooooo`?o0000<Oooool0
1?l0003oTNoAo`000?nFl]P;o`0000;o[<ga1OnW^^L01?l0003oXJ[Moj6ZgOnQZ]d2o`0000?oVigE
00?o0000oj:Pd_nRX=800_l00007oj2Gb`Co00002OnWU/@00ol0003o/9c3ok2L``0:ok2L``03o`00
0?ngX/?o]j;300So]j;300?o0000oknYa?noZL@02OnoZL@2o`0000Wo`kC;0ol000000ono]m;o0000
ol>ne@02ol>ne@;o00001?nj_md2o`0000;o[KoW00?o0000oiRllOnH_?400_l00002ogj_l`05o`00
0?mOX??oGj3co`000?m1Snl00ol000001Ol0I]3o0000o`000?oooooo000000cooooo0ol00004oooo
o`;o0000:?ooool002cooooo0_l0000booooo`;o000000SoTNoAo`000?l0003o0000ol7kj?l0003o
`OK^o`0000;o_^cc0_l000000onhg_?o0000ok3=k`02o`0000CoYk[W00Go0000oj6ZgOnQZ]goXJ[M
o`000005oi^Me@;o00001onPUl/3o`000003oijAa_l0003oYiK400_oYiK400?o0000ok2L`on`W<<0
0on`W<<7o`000003okNR`ol0003o000000So00003?noZL@00ol0003oa[76o`000002o`0000So`kC;
00?o0000ol>neOo3_]D01?o3_]D00ol0003o^[oMokZog@03okZog@03o`000?n]_nOo000000;o0000
0_nH^Nl01?l0003oOZocogj_lol00002oenPl`0:o`000?m1Snoo0000obMoj?l0003o57?Ro`1Vd?l0
003oooooo`0000gooooo00?o0000ooooooooool0;?ooool002Wooooo1Ol0000aooooo`Co000000Go
_ogRo`000?o1nnSo0000ol7fkP04o`0000;o^=kc00Ko0000ok3=kon`cNoo0000ojJjj?l00002ojNj
i`CoXJ[M00?o0000oi^MeOnKWMD00onKWMD00ol0003oUi?>o`000005oj2Gb`;o00001OnNTLH00ol0
003oYiK4ojNFa006ojNFa0Wo00001_n`VKl00ol0003o^9nookRO_`08okRO_`03o`000?o0Yl7o`:O1
00Co00001_noZL@00ol0003oa[76olJaaP02olJaaP?o00001Oo3]</00ol0003obKc>o`000005ol>n
e@;o00000onj_md2o`0000?o[L3X0onH^Nl01?l0003oOZocogj_lol00002oenPl`04o`000?m1Snoo
0000obMoj0;o000000?o2fgNo`000?l000003_ooool00ol0003oooooooooo`0[ooooo`009_ooool3
o`0003Gooooo0_l000001OnnoMko0000okomh_l0003o`O_X00Co000000Go_^cco`000?nhg_?o^=kc
o`000002ok3=k`05o`000?nV^^SoY[[XojJjj?l000001?nQZ]d00ol0003oVigEoi^Me@02oi^Me@;o
00000onGTlh00ol0003oX9O;oj2Gb`02o`0000OoWY7600Co0000ojNFa?nWU/CoYiK41Ol00003ojNB
`@03o`000?n`VKoo/9Vo00Wo/9Vo00?o0000okRO_onhWkl02?nhWkl00ol0003o`:O1ol2W`@04ol2W
`@Co000000?o_jW4o`000?o6/LH01oo6/LH3o`000003ol>dbol0003obKc>00?obKc>0_l00004ol>n
e@03o`000?nj_mgo000000;o_<CP00Co0000ojg0j?n]`>So[L3X0onH^Nl01?l0003oOZocogj_lol0
0002oenPl`04o`000?m1Snoo0000obMoj0;o000000?o2fgNo`000?l000003_ooool00ol0003ooooo
ooooo`0Zooooo`009Oooool3o`0003Kooooo00Co0000okkmg_l0003o_ogR1Ol00002okk/l`04o`00
0?nhg_?o^=kco`0000;o/<g_00Oo0000ojJjj?nV^^SoY[[Xo`000?nLZ^3o000000;oXJ[M1OnKWMD0
0ol0003oUi?>oiNCcP03oiNCcP;o00002_nNTLH4o`0000SoYi;100?o0000ok2I_on`VKl02On`VKl0
0ol0003o^9nookRO_`08okRO_`03o`000?o0Yl7o`:O100So`:O10_l0000;olJaaP03o`000?o9_<ko
bKc>00GobKc>00?o0000ol>neOo3_]D00_o3_]D00ol0003o_<CPokc4h002okc4h005o`000?n]`>So
[L3Xojg0j?l000000_nH^Nl01?l0003oOZocogj_lol00002oenPl`04o`000?m1Snoo0000obMoj0;o
000000?o2fgNo`000?l000003Oooool00ol0003oooooooooo`0Zooooo`009Oooool3o`0003Gooooo
00?o0000okkmg_l000001?l000001Oo1m^ko0000okk/lonnk??o000000;o^=kc00Co0000ok3=kon`
cNoo00000onV^^P01?l0003oW:[PoibZh?nLZ^02o`0000CoVigE00?o0000oiNCc_nGTlh00onGTlh0
0ol0003oThc9o`000007oijAaP?o000000?oWHg2o`000?nWT/402_nWT/400ol0003o/9Vook2I_`03
ok2I_`co00001?nhWkl00ol0003o`:O1ol2W`@09ol2W`@03o`000?o8/<;o000000;o00001oo6/LH0
0ol0003ocK_9o`000006olVlcP;o000000Co`kkEo`000?o7aMSo00001?nla>001Ol0003o[L3Xojg0
j?n]`>So000000;oV;W_00Co0000ogj_lomn[o?o00000_mOX?<01?l0003o@Ho_o`000?lWOnP2o`00
0003o`]]g_l0003o000000gooooo00?o0000ooooooooool0:Oooool001gooooo0ol00005ooooo`04
o`000?ooooooooooo`0003?ooooo1Ol000001?o1nnSo0000ol7fk_l00002okk/l`04o`000?nhg_?o
^=kco`0000;o/<g_00Go0000ojJjj?nV^^SoY[[Xo`000004oibZh003o`000?nCW=Wo000000;oVigE
1OnGTlh2o`0000?oThc900?o0000oijAa_nNTLH00_nNTLH2o`0000CoWHg200?o0000ojNB`OnWT/40
1_nWT/49o`0000Go/9Nn00?o0000okRN__nhW[h01?nhW[h5o`0000;o`:O100?o0000ol2W`Oo0Yl40
1Oo0Yl400ol0003ob;32olR``P03olR``P;o00001?o6/LH01?l0003ocK_9olfkbOo=^lT2o`0000Ko
bKc>00Go0000olO5f?o7aMSoalGHo`000004okc4h005o`000?n]`>So[L3Xojg0j?l000000_nH^Nl0
1?l0003oOZocogj_lol00002oenPl`04o`000?m1Snoo0000obMoj0;o000000?o2fgNo`000?ooool0
3Oooool00ol0003oooooooooo`0Xooooo`007_ooool00ol0003oooooooooo`04ooooo`;o00000_oo
ool00ol0003oooooooooo`0_ooooo`?o000000Ko_ogRo`000?o1nnSo0000ol7fk_l00002okk/l`04
o`000?nhg_?o^=kco`0000;o/<g_00Go0000ojJjj?nV^^SoY[[Xo`000004oibZh005o`000?nCW=Wo
TicIoi>LfOl000001OnGTlh00ol0003oThc9oi><b@03oi><b@03o`000?nNTLKoWY7600;o00001onM
SL800ol0003oYi;1ojNB`@05o`0000?oYY2n00?o0000ok2G__n`Ukh02?n`Ukh00ol0003o^9jnokRN
_P08okRN_P04o`000?o1Y[ko`JJnol6V_PGo00000_o0Yl400ol0003ob;32olR``P05olR``P?o0000
00?oa[76o`000?o=^lT01?o=^lT2o`0000?obKc>0_l00004olO5f003o`000?nla>3o_<CP00;o_<CP
00Go0000ojg0j?n]`>So[L3Xo`000002oiRik`04o`000?mn[o?oOZoco`0000;oGj3c00Co0000od6?
kol0003o9goX0_l000000ol;KMko0000ooooo`0<ooooo`03o`000?oooooooooo02Sooooo000Foooo
o`Go00000oooool00ol0003oooooooooo`03ooooo`?o00000oooool00ol0003oooooooooo`0[oooo
o`?o000000Ko__gNo`000?nooN;o0000ol7kj?l00002ol7fkP;o_^cc00Co0000okSNlonhg_?o0000
0_n`cNl01Ol0003oY[[XojJjj?nV^^So000000CoW:[P00Co0000oi>LfOnCW=WoTicI0_l00004oiNC
cP03o`000?nCS<WoThc900CoThc90_l00009oif=`PCo00002?nVT;h00ol0003o/9Nnok2G_P08ok2G
_P03o`000?nhW[ko^9jn00So^9jn00?o0000ol6V__o1Y[h01_o1Y[h2o`0000_ob;3200?o0000olfk
bOo=^lT01_o=^lT00ol0003obKc>o`000002olk6dP03o`000?o7aMSoalGH00;oalGH00?o0000okc4
h?nla>000_nla>000ol0003o[L3Xojg0j00=o`000005obMoj?l0003o0000o`]]g_l000003?ooool2
o`0002Wooooo000Nooooo`03o`000?oooooooooo00?ooooo0_l00005ooooo`03o`000?oooooooooo
02Oooooo0ol000001?oooooo0000okkmg_nnoMh2o`0000;o`O_X3Ol000000onV^^So0000oibZh003
oibZh005o`000?nCW=WoTicIoi>LfOl000000_n=T=800ol0003oUi?>oiNCcP07oi><b@03o`000?nA
QlGo000000OoWHg20_l000000onLRl3o0000ojJ@_P09ojJ@_P03o`000?n`Ukko/9Nn00?o/9Nn1_l0
00000onhW[ko0000o`000002o`0000Co^9jn00?o0000ol6V__o1Y[h02?o1Y[h00ol0003ob:o0olR_
`003o`0000Kob;3200?o0000olnjaOl000001oo=^lT00ol0003oc/KBolk6dP02olk6dP03o`000?o7
aMSoalGH00;oalGH00Co0000okc4h?nla>3o_<CP0ol000001?n]`NWoVKO]oiVgkOnI]nd3oh:ZkP?o
JY_]0omDS>T6o`0000gooooo00?o0000ooooooooool09_ooool001kooooo00?o0000ooooooooool0
0oooool3o`0000Gooooo00?o0000ooooooooool08oooool3o`0000?ooooo00Go0000okkmg_nnoMko
0000okomhP03o`000005olo`jOl0003ob>O/olSWk?l000000_nnfnh01?l0003o//_/ok;;k?l00002
ojFkj@;o00000onLZ^001Ol0003oTicIoi>LfOnCW=Wo000000CoSI3B00?o0000oi><bOnCS<T01?nC
S<T2o`0000?oTHO500Co0000oif=`_nMSL;oWHg20ol00003oib;`003o`000?nVT;koYY2n00KoYY2n
2?l00005ok2F_@03o`000?nhWKgo^9fm00?o^9fm1Ol00002ol6V_P03o`000?o1Y[ko`JJn00Go`JJn
00?o0000olR_`?o8[l000oo8[l03o`0000;ob;3200Co0000olnjaOo?^/Gock[50_l00005olfkb@;o
00001?o>a]800ol0003oalGHolO5f002olO5f004o`000?nla>3o0000okg8h`Co[L7Y0onI]nd3oh:Z
kP?oJY_]0_mDS>T3od:0i@Co00003?ooool00ol0003oooooooooo`0Vooooo`004Oooool2o`0000Co
oooo00?o0000ooooooooool00_ooool3o`0000Gooooo0_l00007ooooo`03o`000?oooooooooo01oo
oooo0ol00005ooooo`03o`000?nnoMko__gN00?o000000Coe?KUo`000?o?l>Wo00000_o8in`01?l0
003o_]_^okkKk_l00002ok;;k009o`000?nU^nWoYK_YojFkjOl0003oUj[So`000?nLZ^3o000000?o
TicI00?o0000ohf@d_n=T=800_n=T=800ol0003oQhS=o`000003oi><b@;o00001OnAQlD01?l0003o
WHg2oif=`_l00007oib;`003o`000?nVT;koYY2n00Go00000_nVT;h00ol0003o/9Jmok2F_@08ok2F
_@03o`000?nhWKgo^9fm00Oo^9fm00Co0000ol6U__o1YKko`JFn1Ol000000oo1Y[ko0000olR_`008
olR_`0?o00001Oo?^/D2o`0000;ocK_900Co0000om?6cOoCa/go00001?o>a]801?l0003oalGHolO5
f?o7aMP2o`0000?o_LSS0on]`NT01?l0003oVKO]oiVgkOl00002oh:ZkP04o`000?mZVngoJY_]o`00
00;oE8cY0_m2P>D2ocEghP?o00003?ooool00ol0003oooooooooo`0Uooooo`004?ooool01?l0003o
ooooooooool00007ooooo`03o`000?oooooooooo00;o00001?ooool2o`0000Sooooo0_l0000Moooo
o`;o00001oooool02?l0003o__gNokkmg_l0003oe_WQo`000?oDm^Go00000_o?l>T01?l0003ob>O/
olSWk?l00002okkKkP04o`000?nbbnco//_/o`0000;oYK_Y00Go0000oiNZhonGZ^?oUj[So`000003
oi>Lf@03o`000?n=T=;oSI3B00;oSI3B00Oo0000ohN8cOn7R<goQhS=o`000?nCS<Wo000000OoTHO5
0_l00008oib;`0Co00001onVT;h00ol0003o/9Jmok2F_@08ok2F_@03o`000?nhWKgo^9fm00Oo^9fm
00?o0000ol6U__o1YKh01_o1YKh2o`0000[ob:o000?o0000om6i`ol000001_o?^/D00ol0003ocK_9
o`000003om?6c@03o`000?o>a];oc/KB00;oc/KB00Go0000olO5f?l0003ob/gMo`000003okg8h`05
o`000?n]`NWo[L7Yojg1jOl000000_nI]nd01?l0003oPZ[^oh:Zk_l00002ofZKk@03o`000?mDS>Wo
000000;o@X3U0_leMn83o`0000cooooo00?o0000ooooooooool09?ooool000Wooooo1Ol00002oooo
o`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool00_ooool2o`0000[ooooo00?o0000
ooooooooool05oooool3o`0000Sooooo1?l000001ooFnN7o0000omCfiOoDm^Go0000olo`jOl00000
0_o8in`01?l0003o_]_^okkKk_l00002ok;;k005o`000?nU^nWoYK_YojFkjOl000000onGZ^<01?n;
Vmgo0000oi>LfOl00004ohf@dP03o`000?n7R<goQhS=00?oQhS=00?o0000oi67aOnAQlD01OnAQlD0
0ol0003oT8G3o`000006oib;`0;o000000?oW8[0o`000?nVT;h02OnVT;h00ol0003o/9Jmok2F_@07
ok2F_@03o`000?nhWKgo^9fm00Ko^9fm00?o0000ol6U__o1YKh02?o1YKh00ol0003obJjoolV^_`03
o`0000Cob:o000Co0000om6i`ooA^L?odKW30_l00005olnja@03o`000?oCa/godlK=00?odlK=00?o
0000olk6d_o>a]800_o>a]801Ol0003ob/gMol[=gOo:cMgo000000?o_LSS00Co0000ojg1jOn]`NWo
00000_nI]nd01ol0003oPZ[^oh:Zk_n2Z^ko0000ofZKkOl000000_mDS>T2od:0i@06o`000?leMn;o
;W;Oo`000?l^L]oo00002oooool00ol0003oooooooooo`0Tooooo`004?ooool01?l0003ooooooooo
ool0000;ooooo`04o`000?ooooooooooooooo`;o00003?ooool00ol0003oooooooooo`0Cooooo`?o
00002_ooool2o`0000;oeo[O00Go0000omKihOl0003oe?KUo`000002olo`j@04o`000?o8incob>O/
o`0000;o_]_^00Co0000ok;;k?nbbnco00000_nU^nT01Ol0003oUj[SoiNZhonGZ^?o000000;oRi_M
0_l00003ohf@dP03o`000?n7R<goQhS=00?oQhS=0_l00005oi67a@;o00000on@QL<01?l0003oW8_0
oib;`?nLRl02o`0000CoW8[000?o0000ojJ@__nVT;h01onVT;h00ol0003o/9Jmok2F_@02ok2F_@_o
00000onhWKd00ol0003o`JFnol6U_P08ol6U_P03o`000?o9[[oobJjo00?obJjo0ol000000oo8[l3o
0000om6i``04om6i``07o`000?o?^/Gock[5olnjaOl0003oelG9o`000005om?6c@05o`000?o>a];o
c/KBolk6d_l000000oo:cMd01Ol0003o_LSSokg8honmb>?o000000;o[L7Y00Co0000oiVgkOnI]ngo
00000on2Z^h01_l0003oJY_]ofZKkOl0003oE8cYo`0000;o@X3U0_leMn800ol^L]oo0000o`00000<
ooooo`03o`000?oooooooooo02?ooooo000@ooooo`04o`000?ooooooooooo`0000Oooooo1?l00004
ooooo`?o00003?ooool00ol0003oooooooooo`0?ooooo`?o00003Oooool01_l0003oeo[OomOjgol0
003oe_WQo`0000;oe?KU00?o0000olo`jOl000000oo8in`01?l0003o_]_^okkKk_l00002ok;;k004
o`000?nU^nWoYK_Yo`0000?oUj[S00?o0000oh^KgOn;Vmd00_n1S]L00ol0003oSI3Bo`000005ohN8
c@04o`000?n4P/WoQ8;9o`0000;oTHO50_l00005oi25``04o`000?nLRl3oW8_0o`0000KoW8[000?o
0000ojJ@__nVT;h01OnVT;h7o`0000Go/9Nn00?o0000okRN__nhW[h00onhW[h4o`000003ol6U__l0
003o000000Ko`JFn00?o0000olV^_oo9[[l01oo9[[l2o`0000KodKW300?o0000olnjaOl000000ooG
aLT00ol0003odlK=om?6c@03om?6c@05o`000?o>a];o0000om?@eol000000oo:cMd01?l0003o_LSS
okg8hol00003ojg1j@04o`000?nI]ngoVKO]o`0000?oPZ[^00?o0000ofZKkOl000000_mDS>T01_l0
003o@X3Uo`000?leMn;o0000obibg`;o00003?ooool00ol0003oooooooooo`0Rooooo`004?ooool0
1?l0003oooooooooool00007ooooo`03o`000?oooooooooo00Gooooo0ol0000=ooooo`03o`000?oo
oooooooo00_ooooo0ol0000?ooooo`09o`000?oGn]ooeo[OomOjgol0003oe_WQo`000?oDm^Go0000
00;oco3Y00Co0000olSWk?o8inco00000_nnfnh01?l0003o//_/ok;;k?l00002ojFkj@05o`000?nG
Z^?oUj[SoiNZhol000000_n;Vmd01Ol0003oPHkGoh6>eon1S]Oo000000GoQhS=00Oo0000ohB2bOn4
P/WoQ8;9o`000?nAQlGo000000OoT8G30_l00008oib:`003o`000?nVT;koYY2n00Go00000_nVT;h0
0ol0003o/9Nnok2G_P07ok2G_P03o`000?nhW[ko^9jn00Ko^9jn00Co0000ol6V__o1Y[ko`JJn1Ol0
00000oo1YKko0000olV^_`08olV^_`03o`000?oA^L;o000000KodKW300?o0000omO5bOoGaLT00ooG
aLT00ol0003odlK=om?6c@03om?6c@04o`000?oCd=Oodm3Go`0000?ob/gM00Go0000okg8honmb>?o
_LSSo`000002ojg1j@04o`000?nI]ngoVKO]o`0000?oPZ[^00Ko0000ofZKkOmZVngo0000oeB<jOl0
0002od:0i@03o`000?leMn;o;W;O00;o00002oooool2o`0002Cooooo000Aooooo`;o00002?ooool5
o`0000?ooooo0_l0000?ooooo`03o`000?oooooooooo00Sooooo0_l0000Booooo`06o`000?oGn]oo
eo[Oo`000?oFnN7o00000_oDm^D00ol0003oco3Yo`000003olSWk004o`000?nnfnko_]_^o`0000;o
//_/00Co0000ojFkjOnU^nWo00000_nGZ^<01Ol0003oRi_Moh^KgOn;Vmgo000000?oPHkG00?oNHCB
o`000?n7R<d00_n7R<d00ol0003oQ8;9ohB2b@03ohB2b@03o`000?n@QL?oT8G300CoT8G30_l00000
0on@Q<?o0000oib:`007oib:`0?o00001onVT;h00ol0003o/9Nnok2G_P07ok2G_P03o`000?nhW[ko
^9jn00Ko^9jn00?o0000ol6V__o1Y[h01_o1Y[h2o`0000SobJjo00Co0000om6i`_oA^L;odKW20_l0
0004om6i``;o00001OoGaLT01?l0003odlK=om?6cOoCa/d2o`0000?odm3G00Go0000ol[=gOo:cMgo
b/gMo`000002okg8h`03o`000?n]`NWo[L7Y00_o00000_mDS>T01_l0003o@X3Uo`000?leMn;o0000
obibg`;o00003?ooool00ol0003oooooooooo`0Qooooo`006oooool01?l0003oooooooooool00004
ooooo`;o00004?ooool00ol0003oooooooooo`04ooooo`?o00005?ooool02?l0003oeo[OomOjgol0
003oe_WQo`000?oDm^Go00000_o?l>T?o`000005oiNZhol0003oRi_Moh^KgOl000000on1S]L01_l0
003oNHCBogV4d_l0003oQhS=o`0000GoQ8;900?o0000oh9oaol000001?n@QL<00ol0003oT8C3oi24
``02oi24``03o`000?nLR/3oW8[000;oW8[00ol000000onLRl3o0000ojJ@_P08ojJ@_P03o`000?n`
Ukko/9Nn00Ko/9Nn00?o0000okRN__nhW[h01_nhW[h00ol0003o`JJnol6V_P07ol6V_P03o`000?o8
[l3o000000;o00001?o9[[l00ol0003odKW2om6i`P03om6i`P04o`000?oA^L?odKW3o`0000;of<G7
00?o0000omO5bOoGaLT00ooGaLT00ol0003odlK=o`000002omWBdP05o`000?oCd=Oodm3Gom?@eol0
00000_o:cMd00ol0003o_LSSokg8h`03o`000004ojg2jOnJ]>[oV[CZoiZdjPCoQjKY0omeUnH3o`00
0007od:0iOl0003o=GORocEgh_l0003o;W;Oo`00000=ooooo`03o`000?oooooooooo023ooooo000K
ooooo`04o`000?ooooooooooo`0000Cooooo0_l0000Aooooo`03o`000?oooooooooo00?o00005_oo
ool01?l0003oeo[OomOjgol00002omKih@03o`000?oDm^Go000000?o00000_o>gnD01?l0003o`]KX
ol;Fj?l00002okC9jP03o`000?nT^nWoY;_Y00?oTZ_W0_l00002oh^Kg@05o`000?n1S]OoPHkGoh6>
eol000000omiQ=800ol0003oQ8;9ohB2b@03ohB2b@06o`000?n2OlOoPWo7oh9oaol0003oT8G30_l0
0005oi24``03o`000?nLR/3oW8[000;o00001?nLRl000ol0003oYY2nojJ@_P05ojJ@_QGo00002?o1
Y[h00ol0003ob:o0olR_`003olR_`0?o000000?obJjoo`000?oA^L801OoA^L800ol0003odKW3o`00
0003omS5a`03o`000?oGaLWoelG900?oelG900Go0000omWBd_oId];ofM;Bo`000003om?@e`03o`00
0?o:cMgob/gM00?o000000Go_LgVojg2jOn]`^Wo[L;Yo`000002oiZdjP05o`000?n7Y^WoQjKYohNV
jOl000000_meUnH3ofF;hP03o`000?m2P>Go000000;o=GOR0ol0000<ooooo`03o`000?oooooooooo
023ooooo000Kooooo`04o`000?ooooooooooo`0000?ooooo0ol0000Aooooo`?o00006Oooool00ol0
003oeo[Oo`000002omKih@Co000000?oe^GRo`000?o>gnD00_o>gnD01?l0003o`]KXol;Fj?l00002
okC9jP03o`000?nT^nWoY;_Y00?oTZ_W0_n2Vn<00ol0003oRi_Mo`000002oh6>e`03o`000?miQ=;o
NHCB00;oNHCB00?oLgg?o`000?n4P/T00_n4P/T00ol0003oPWo7oh9oa`02oh9oa`;o00001on@Q<<2
o`0000SoW8_000?o0000ojJ@__l000001?l00002ojNB`@03o`000?n`VL3o/9W000Ko/9W000?o0000
okRO_onhWkl01_nhWkl00ol0003o`:O1ol2W`@04o`0000;o`JJn00?o0000olR_`?o8[l001_o8[l02
o`0000OodKW200?o0000omS5aooHaLL00ooHaLL01?l0003oelG9omO5bOoGaLT2o`0000CofM;B00Co
0000om?@eooCd=Oodm3G0_l000001Oo;e^;o0000okg=i_nmcNKo000000?o[L;Y0onJ]>X3ohNVj@04
o`000?meUnKoMIOVo`0000;oIH_R0_mIP=h01_l0003o=GORocEgh_l0003o;W;Oo`0000gooooo00?o
0000ooooooooool07oooool001_ooooo00Co0000oooooooooooo00000oooool3o`0000kooooo0ol0
0003ooooo`03o`000?oooooooooo01Gooooo00Co0000omOjgooGn]oo00000_oFnN400ol0003ofnWN
o`000002omKUhP05o`000?o>gnGoc]oUolkOiOl000000_o2e^P01?l0003o]<WZokC9j_l00002ojBk
j@03o`000?nBZnOoTZ_W00?oPY_S0_l00002oh6>e`05o`000?miQ=;oNHCBogV4d_l000000_mcOLl0
0ol0003oQ8;9o`000004oh9oa`03o`000?n1O/Ko000000GoT8C30_l000000on@QL?o0000oib;`006
oib;`0?o00001onWT/400ol0003o/9W0ok2I`006ok2I`003o`000?nhWkoo^9no00Ko^9no00?o0000
ol2W`Oo0Yl401?o0Yl42o`0000Wob:o000Co0000om6i`ol0003o00001OoA^L82o`0000Gof<G700?o
0000omO5bOl000000_oMdlh01Ol0003ofM;BomWBd_oId];o000000;odm3G0_l00002ol_FhP05o`00
0?nmcNKo_LgVokg=i_l000000_n]`^T01?l0003oV[CZoiZdj_l00002ohNVj@04o`000?meUnKoMIOV
o`0000;oIH_R0omIP=h2o`000004ocEgh_l0003o;W;Oo`0000gooooo00?o0000ooooooooool07_oo
ool001_ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0;ooooo`?o00001ooo
ool00ol0003oooooooooo`0Dooooo`04o`000?oGn]oo0000omKih@;o00000_oKjMh01?l0003oe^GR
omKUh_l00003olkOi@04o`000?o2e^So`]KXo`0000;o]<WZ00Co0000ojBkjOnT^nWo00000_nBZnL0
0ol0003oPY_Soh:Kh`02og:<g@03o`000?n1S]Oo000000?oNHCB00Go0000og=mcomcOLooLgg?o`00
0004oh9oa`05o`000?n1O/KoPGk6oh5na_l000000on@Q<<00ol0003oT8G3oi25``02oi25``04o`00
0?nLRl3oW8_0oib;`0?o000000?oWHg2o`000?nWT/401onWT/400ol0003o/9W0ok2I`006ok2I`003
o`000?nhWkoo^9no00Go^9no00?o0000ol2W`Oo0Yl401_o0Yl400ol0003ob;32o`000002o`0000Co
b:o000?o0000om6i`ooA^L<00_oA^L<01Ol0003odKW2om6i`_oA^L;o000000;ofLG600?o0000omS5
aooHaLL00ooHaLL00ol0003ogM?>omgCcP02omgCcP08o`000?oId];ofM;Bo`000?oCd=Oo0000omGL
gOl00003ol_FhP04o`000?nmcNKo_LgVo`0000;o[L;Y00Co0000oiZdj_nJ]>[o00000_n7Y^T01?l0
003oMIOVogFGi_l00002ofF;hP03o`000?mIP=koFH3N00;oD7WL0_l000000ol^L]oo0000ooooo`0<
ooooo`03o`000?oooooooooo01kooooo000?ooooo`;o00001?ooool00ol0003oooooooooo`02oooo
o`Co00001?ooool2o`0000[ooooo0_l0000;ooooo`03o`000?oooooooooo01;ooooo00?o0000omOj
gooGn]l00_l000001OoOk=_o0000om_Yg_oKjMko000000;oe^GR00Oo0000olkOiOo>gnGoc]oUo`00
0?o2e^So000000;o]<WZ00Co0000ojBkjOnT^nWo00000onBZnL00ol0003oPY_Soh:Kh`03og:<g@05
o`000?miQ=;oNHCBogV4d_l000001?mcOLl01Ol0003oPWo7oh9oaon2OlOo000000CoPGk600Co0000
oi24`ol0003o00001On@QL<01?l0003oW8_0oib;`?l00005oif=`P03o`000?nWT/7oYi;100?oYi;1
5?l000000oo0Yl7o0000ol2W`@05ol2W`@03o`000?o8/<;ob;3200;ob;320ol000000oo8[l3o0000
om6i``04om6i``;o000000?odKW2o`000?oIaLH00_oIaLH01?l0003of<G7omS5aooHaLL2o`0000Co
gM?>00Go0000omWBd_oId];ofM;Bo`000003omGLg@04o`000?o;e^;obmKRo`0000;o_LgV00Co0000
ojg2jOn]`^Wo00000_nJ]>X01ol0003oQjKYohNVjOn7Y^Wo0000ogFGi_l000000_mURn801?l0003o
FH3NoeV0g_l00003oe1ig003o`000?l^L]oo000000gooooo00?o0000ooooooooool07Oooool000ko
oooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Cooooo0_l00007
ooooo`?o00003_ooool00ol0003oooooooooo`0Aooooo`?o00000ooOk=/01?l0003ofnWNom_Yg_l0
0002omKUhP04o`000?o>gnGoc]oUo`0000;o`]KX00Co0000okC9j_ndbN[o00000_nT^nT01?l0003o
TZ_Woi:[iol00003oh:Kh`05o`000?mbS=goLXcMofJ0fOl000000_miQ=802Ol0003oLgg?og=mcomc
OLoo0000ofmic?l0003oPWo7o`000006oh5naP03o`000?n@QL?oT8G300GoT8G30_l00007oif=`P03
o`000?nWT/7oYi;100?o00000_nWU/@00ol0003o/9c3ok2L``06ok2L``03o`000?nhX/?o^:;300Go
^:;300?o0000oknYa?noZL@01?l000000oo0Yl7o0000olR``P07olR``P;o00001ooA^L<2o`0000Co
fLG600?o0000omS5aol000000_oOdl`00ol0003ogM?>omgCcP02omgCcP04o`000?oId];o0000o`00
00?oeMcM00Co0000ol_Fh_o;e^;o00000_nmcNH01?l0003o[L;Yojg2jOl00002oiZdjP05o`000?n7
Y^WoQjKYohNVjOl000000_meUnH00ol0003oIH_Ro`000002oeV0gP04o`000?m@NMcoD7WLoe1ig0;o
C7KJ0_l0000;ooooo`03o`000?oooooo000001kooooo000>ooooo`04o`000?ooooooooooo`0000_o
oooo00?o0000ooooooooool00_ooool2o`0000Cooooo0ol0000Booooo`03o`000?oooooooooo013o
oooo00?o0000on3]f_l000000ooOk=/01_l0003ofnWNom_Yg_l0003oe^GRo`0000?oc]oU00Co0000
ol;Fj?o2e^So00000_ndbNX01?l0003oY;_YojBkjOl00002oi:[i`05o`000?n2Vn?oPY_Soh:Khol0
00000_mbS=d2ofJ0f@03o`000?miQ=;o000000;oLgg?00Go0000ofmic?m_NLcoKgW<o`000006oh5n
aP;o00001_n@QL<00ol0003oTHO5o`000007oif=`P?o00001OnWU/@00ol0003o/9c3ok2L``06ok2L
``03o`000?nhX/?o^:;300Go^:;300?o0000oknYa?noZL@01?noZL@2o`0000Sob;3200Co0000olnj
aOl0003o00001?oA^L<01?l0003of<G7omS5aol00004omW5aP03o`000?oOdlcogm?<00;ogm?<00?o
0000omgCc_oMdlh00_oMdlh00ol0003ogN3Ho`000003omGLg@04o`000?o;e^;obmKRo`0000?o_LgV
00Co0000ojg2jOn]`^Wo00000_nJ]>X01?l0003oQjKYohNVjOl00002ogFGiP06o`000?mURn;oIH_R
o`000?mIP=ko00000om@NM`3odaffP;o00003?ooool00ol0003oooooooooo`0Looooo`003_ooool0
1?l0003oooooooooool0000;ooooo`04o`000?ooooooooooooooo`?o000000Coooooo`000?l0003o
00005_ooool00ol0003oooooooooo`0>ooooo`04o`000?oPkM[oh>gJo`0000?ogncK00?o0000om_Y
g_l000000_oFiN801Ol0003oc]oUolkOiOo>gnGo000000;o`]KX00?o0000okC9j_l000001?l00002
oi:[i`04o`000?n2Vn?oPY_So`0000?oLXcM00Co0000ofJ0fOmVP=Wo00000omcOLl01Ol0003oKgW<
ofmic?m_NLco000000GoPGk600Co0000oh9oaon2OlOo00000on@QL<2o`0000?oTHO500Co0000oif=
`_nMSL;oWHg20ol000000onNTLKo0000ojNFa006ojNFa003o`000?n`W<?o/9c300Go/9c300?o0000
okRR`onhX/<01?nhX/<00ol0003o_jW4oknYa006oknYa003o`000?o6/LKoa[7600?o00000_o8/<80
0ol0003ock[5olnja@02olnja@;o000000?odKW3o`000?oHaLL00ooHaLL01Ol0003ofLG6omW5a_oI
aLKo000000Cogm?<00Co0000omgCc_oMdlkogM?>0_l00002omgPf004o`000?oEg=goeMcMo`0000?o
bmKR00?o0000okg=i_l000002?l000001On7Y^Wo0000ogFGi_meUnKo000000;oIH_R00?o0000oeV0
g_l000000om@NM`00ol0003oC7KJodaffP02o`0000gooooo00?o0000ooooooooool06oooool000ko
oooo00Co0000oooooooooooo00001oooool4o`0000Cooooo1?l0000Jooooo`03o`000?oooooooooo
00gooooo00Co0000on3]f_oPkM[o00000ooOk=/00ol0003ofnWNo`000002omKUhP06o`000?o>gnGo
c]oUolkOiOl0003o`]KX0ol000001?nfanOoXkcZoj>lj_nS_>X5o`000005oh:Khol0003oLXcMog:<
gOl000000omVP=T01?mMMmCo0000og=mcol00003ofmic003o`000?m^N<co000000?oPGk600?o0000
oh9oaon2OlL00_n2OlL00ol0003oT8G3o`000005oi67a@04o`000?nMSL;oWHg2o`0000CoWY7600?o
0000ojNFa?nWU/@00onWU/@Bo`000003oknYa?l0003o_jW400Go_jW400?o0000olJaa_o6/LH00oo6
/LH3o`0000Kock[500?o0000omS5aooHaLL01?oHaLL01Ol0003ofLG6o`000?oPdl_o000000Cogm?<
00Go0000omgCc_l0003ohN;Do`000002omgPf006o`000?oEg=goeMcMomGLgOl0003obmKR0ol00000
1Onld^_o0000ojc3j_n/`n[o000000;oW;?X0on=Xn@2o`000005ogFGi_l0003oIH_RofF;h_l00000
0_mIP=h01?l0003oD7WLoe1ig?l00002odaffP03o`000?oooooo000000gooooo00?o0000oooooooo
ool06_ooool000kooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`05ooooo`;o
00007Oooool2o`0000gooooo00Co0000on3]f_oPkM[o00000_oOk=/01?l0003ofnWNom_Yg_l00002
omKUhP03o`000?o>gnGo000000?o000000Goa=3SokK7ionfanOo]/OWo`000002oj>ljP?oSZg[0_mg
W>P2o`0000;oLXcM00Co0000ofJ0fOmVP=WoIX3I0_mMMm@00ol0003oKgW<ofmic002ofmic006o`00
0?m^N<coKWS<o`000?n1O/Ko00001On2OlL2o`0000KoTHO50_l00007oijAaP03o`000?nWU/Co0000
00;o00000_nXVlT00ol0003o[j78ojnQb005ojnQb003o`000?ngY/So]jK800Co]jK800?o0000okf]
bOnm[LT01?l000000onoZLCo0000olJaaP06olJaaP03o`000?o=^lWo000000Gock[50_l00006omS5
a`05o`000?oPdl_oh=?;on3Cbol000001?oOdl`01?l0003ohN;Don7Re?l00002omgPf003o`000?oE
g=goeMcM00?o000000Gob]oXo`000?nld^_o_=;[o`000002ojc3jP03o`000?nL/nSoW;?X00?oSJ?T
0omoU]l2o`000005ofF;h_l0003oFH3NoeV0g_l000000_m@NM`01?l0003oC7KJodaff_l00002oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool06_ooool000oooooo0_l00008ooooo`Go
00001Oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo00[ooooo00Co0000on3]f_oP
kM[o00000_oOk=/01Ol0003ofnWNom_Yg_l0003oe^GR00?o00000_o?e]h01?l0003oa=3SolC@hol0
0003okK7i`;oXkcZ00Co0000ohj]jon>[N_o00000_mgW>P4o`0000?oIX3I0_mMMm@01OmGL];o0000
ofmic?m_NLco000000CoKWS<00?o0000oh9oaon2OlL00on2OlL00ol0003oQ8;9o`000004oi67a@;o
000000?oThc9o`000?nNTLH01OnNTLH3o`0000GoZ9_900?o0000ojnQb?n_XLP01On_XLP00ol0003o
]jK8okNVb004okNVb003o`000?nm[LWo_Jg900Co_Jg90_l000000oo6/LKo0000olJaaP03olJaaP04
o`000?o=^lWocK_9olfkb@;o00000_o?^/D01?l0003oelG9omO5bOl00005omS5a`05o`000?oPdl_o
h=?;on3Cbol000000ooOdl`2o`0000?ohN;D00?o0000omgPf?oMh=P00_l000001ooDj>Co0000ol[O
j?o:gnSo0000okcBjol000000_n/`nX01?l0003oW;?Xoibcj?l00003ohfSi0?oOiKO0_mdR]/2o`00
00;oFH3N00Oo0000oe1ig?m@NMcoD7WLo`000?m<M][o000000;ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0Iooooo`006_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo01cooooo00?o0000ooooooooool02Oooool01?l0003oh>gJon3]f_l00002omo/f`03o`000?oK
jMkofnWN00;o000000?oem[Jo`000?o?e]h00_o?e]h01Ol0003oa=3SolC@hoo4d>?o000000;o]/OW
00Co0000oj>lj_nS_>[o00000_n>[N/2ogNLj0?oHH_T0_l000001?mVP=Wo0000oeege?mMMm@2oeMb
dP03o`000?m_NLco000000CoKWS<00?oKgW<o`000?n2OlL00_n2OlL01_l0003oQ8;9ohB2bOn4P/Wo
0000oi67a@;o00001?nCS<T00ol0003oWY76oijAaP03o`000003oj2Gbol0003oZ9_900KoZ9_900Co
0000ojnQb?n_XLSo[j782?l00002okNVb003o`000?nm[LWo_Jg900Go_Jg900?o0000ol>dboo3]</0
0ol000000oo6/LKo0000olfkb@04olfkb@03o`000?o?^/Go000000?oelG900Oo0000omS5aooHaLOo
f<G7o`000?oOdlco000000?oh=?;00Go0000omoCc?l0003oi>CBo`000003on7Re004o`000?oMh=So
0000o`0000;oe>ST00?o0000ol[Oj?l000000_nld^/01?l0003o[<?Zojc3j_l00002oibcj004o`00
0?n=XnCoSJ?To`0000?oOiKO0omdR]/2o`000003oeV0g_l0003oD7WL00;oD7WL00?o0000odaff_l0
00000oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Sooooo000Jooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`08ooooo`04o`00
0?oPkM[oh>gJo`0000;ogncK00Co0000om_Yg_l0003o00000_oGf]X00ol0003ocmKNoloFgP02oloF
gP04o`000?o4d>?oa=3So`0000;o]/OW00Co0000oj>lj_nS_>[o00000_n>[N/00ol0003oMicXo`00
0002of6;i0;oCWcO0_l00002oeege004o`000?mGL];oEg;Bo`0000CoKWS<00Ko0000ofmic?m_NLco
0000oh9oaol00005ohB2b@03o`000?nCS<WoThc900CoThc90ol00005oj2Gb`04o`000?nXVlWoZ9_9
ojRKb@Oo00000on_Ym000ol0003o]Jc@okF/d002okF/d0?o000000?o_Jg9o`000?l000000onm[LT0
0ol0003o`kC;ol>db`04ol>db`03o`000?o=^lWocK_900GocK_900?o0000omO5bOoGaLT00ooGaLT0
0ol0003of<G7o`000002omoCc003o`000?oPdl_oh=?;00;oh=?;00Co0000onCTd_oTi=;o00000ooQ
h]@2o`000004omc_g_l0003oe>STo`0000;ob]oX00Co0000okcBjonld^_o00000_n/`nX01?l0003o
W;?Xoibcj?l00002ohfSi004o`000?moU]ooOiKOo`0000?oM8[K0_m/P]L2o`0000?oD7WL00Co0000
odaff_m<M][o00000oooool00ol0003oooooooooo`09ooooo`?o00006Oooool001[ooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo00Kooooo00Go0000
on3]f_oPkM[oh>gJo`000002omo/f`;o000000?og=cFo`000?oGf]X00_oGf]X01Ol0003ocmKNoloF
g_o?e]ko000000;oa=3S00Co0000okK7ionfanOo00000_nS_>X01_l0003oSZg[ohj]jol0003oMicX
o`0000;oHH_T00Ko0000odilgom>O=oo0000oeege?l00003oeMbdP05oeI`dOl0003oKWS<ofihc?l0
00001?m_NL`00ol0003oQ8;9ohB2b@03ohB2b@;o00001?nCS<T2o`000003oiNCc_l0003oX9O;00Co
X9O;1Ol00003ojVSd@03o`000?n_Ym3o[jO@00Co[jO@00?o0000okF/d?ne[=001?ne[=001?l0003o
^[7AokZadOnj/M43o`0000Oo`kC;00Co0000olVlc_l0003o00000oo=^lT00ol0003odlK=o`000005
omO5b@03o`000?oOdlcogm?<00;ogm?<00?o0000on3CbooPdl/00_l00003onCTdP04o`000?oQh]Co
0000o`0000;og>oN00?o0000omCXi?l000000_o:gnP01?l0003o_=;[okcBjol00002ojc3jP04o`00
0?nL/nSoW;?Xo`0000;oSJ?T00Co0000ognFgomoU]oo00000omdR]/3ofb2e`;o00000_m@NM`01?l0
003oC7KJodaff_l00004ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool05oooool0
01[ooooo00?o0000ooooooooool02_ooool2o`0001gooooo00?o0000ooooooooool01Oooool01_l0
003oh>gJon3]f_oPkM[o0000omo/f`;o00000_oLg=H01Ol0003oem[JomOJf_oGf][o000000?ocmKN
00Co0000olC@hoo4d>?o00000_nfanL01?l0003oXkcZoj>lj_l00002ohj]j`06o`000?mgW>SoMicX
o`000?mQRnCo00000_m>O=l00ol0003oGGODo`000003oeMbdP;oEW3A00?o0000ofihc?l000001?m_
NL`00omcOLoo0000ohB2b@02ohB2b@04o`000?n7R<goQhS=o`0000;oThc900?o0000oiNCc_nGTlh0
0_nGTlh00ol0003oX9O;oj2Gb`02o`000003oj:Pdol0003oZJ?A00KoZJ?A00?o0000ojnWd?n_Ym00
0on_Ym000ol0003o]Jc@okF/d003okF/d003o`000?nj/M7o^[7A00Co^[7A00?o0000oknhdono^=<0
0ol000000oo3]<_o0000olVlcP03olVlcP03o`000?o=^lWo000000?odlK=00Co0000omO5bOoGaLWo
elG90_l00004omoCc005o`000?oPdl_o0000onGTdOl000000ooTi=82o`000004on7bf_l0003og>oN
o`0000;oe>ST00Ko0000ol[Oj?o:gnSo0000okcBjol00002ojc3jP05o`000?nL/nSoW;?Xoibcj?l0
00000_n=Xn@01?l0003oOiKOognFgol00002ogB:f`04o`000?m/P]OoK8;Gofb2e`;oIWcD00?o0000
oe1ig?l000000_m<M]X00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool01?ooool3o`0000oooooo000Iooooo`;o00003_ooool00ol0003oooooooooo`0Koooo
o`03o`000?oooooooooo00Cooooo00Co0000on3]f_oPkM[oh>gJ0_l000000ooOgMCo0000omcLeP02
omcLeP04o`000?oGf][oem[Jo`0000?ocmKN00Co0000olC@hoo4d>?o00000onfanL01?l0003oXkcZ
oj>lj_l00002ohj]j`03o`000?mgW>So000000;oHH_T00?o0000odilgol000000_l00003oeMbdP04
o`000?mFL=7oEW3Ao`0000CoKgW<00Ko0000og=mcomcOLoo0000ohB2bOl00004ohN8c@03o`000?nG
TlkoUi?>00CoUi?>0_l00005oj:Pd`04o`000?nYXm7oZJ?AojVSdA3o000000?o^[7Ao`000?l00000
0_nj/M400ol0003o_kSCoknhd`04oknhd`03o`000?o9_<kobKc>00CobKc>0_l00004om?6c@03o`00
0?oGaLWo000000;ogM?>00?o0000omoCc?oOdl`00_oOdl`01?l0003oiNCAonGTdOl00003onCTdP08
o`000?oQl][ohO;Jo`000?oLkmko0000omCXi?l00002ol[Oj003o`000?nld^_o000000Oo00000on=
Xn@01?l0003oOiKOognFgol00002ogB:f`04o`000?m/P]OoK8;Gofb2e`CoIWcD0_l000000om<M][o
0000ooooo`04ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_ooool01Ol0003o
oooooooooooooooo000000kooooo000Jooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool06oooool00ol0003oooooooooo`03ooooo`03o`000?oPkM[oh>gJ00;o00000_oOgM@01Ol0003o
g=cFomcLe_oLg=Ko000000?oem[J00Co0000oloFg_o?e]ko00000oo4d><00ol0003o]/OWo`000007
o`000008ogNLj?l0003oHH_Tof6;i?l0003oCWcOo`000?loL=X2o`000003oeMbd_l0003oEW3A00;o
EW3A00GoEg;Bo`000?m_NLcoKgW<o`000004og=mc`03o`000?n7R<goQhS=00;oQhS=00?o0000ohb@
d_l000000onGTlh2o`000003oi^Me_l0003oXZ3C00CoXZ3C1?l00003ojV^f`03o`000?n]/M_o[K7K
00?o[K7K00?o0000ok6dfona]=/00ona]=/01?l0003o];SKokBhfond^=/3o`0000Ko_kSC00Co0000
olBneOl0003o00000oo9_<h00ol0003oclKBo`000004om?6c@03o`000?oMdlkogM?>00;ogM?>00?o
0000omoCc?oOdl`00_l00003onGTd@04o`000?oTi=;o0000o`0000;ohO;J00?o0000omc_g_l00000
1_l000001Onie^oo0000ojc3jon/`n_o000000;oW[7U1?l00003ognFg`04o`000?mdR]_oM8[Ko`00
00;oK8;G00?o0000ofIle?mVO=@00_mVO=@2ofAid`;o00001_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03?ooool002_ooooo00?o0000oooooooo
ool06oooool2o`0000?ooooo0ol000000ooQg];o0000omoMe002omoMe004o`000?oLg=Kog=cFo`00
00?oem[J00Ko0000oloFg_o?e]kocmKNo`000?o4d><3o`000005okK5iOl0003oXkc[oj>ljol00000
0_n:/>l2ofbOk`;o000000GoHH_To`000?m>O=ooCWcOo`000002ocIYe`;o00000omFL=42oeMbdP03
o`000?m_NLco000000CoLgg?00Go0000ohN8cOn7R<goQhS=o`000003ohb@dP03o`000?nGTlko0000
00CoVigF00?o0000oj:Pdol000000_l000000onT[=go0000ojV^f`03ojV^f`;o000000?o[K7Ko`00
0?l000000ol000000ona]=_o0000o`000002o`0000Ko];SK00?o0000okRlgOl000000_l000000ono
^=?o0000olBne@03olBne@03o`000?o9_<ko000000?oclKB00Go0000om?6cOoCa/godlK=o`000004
omgCcP05o`000?oOdlco0000onCTd_l000000ooUi=42o`000005on?de_l0003ohO;Jo`000?oLkmh0
0_l000001oo>ln[o0000olGVk_o5i^ko0000okWFkol000000_n/`n/01Ol0003oW[7UoijaiOnN/NGo
000000;oTZ;O0_l000000omoU]oo0000ogB:f`02ogB:f`04o`000?m/P]OoK8;Go`0000CoIWcD0omT
NM<00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`0<ooooo`00;?ooool00ol0003oooooooooo`0Looooo`04o`000?oooooo
ooooo`0000?ohMkB00Go0000omoMe?oOgMCogmgDo`000003omcLeP04o`000?oGf][oem[Jo`0000;o
cmKN0ol000000oo4b]oo0000okK5i@02okK5i@04o`000?nS_>_oXkc[o`0000;oR[3_00CoK9o_odb;
j_m<Rn[oC8_Z0_l000000om>O=oo0000ocm`fP02ocIYe`05o`000?mFL=7oEW3AoeI`dOl000000_mG
L]800ol0003oLgg?og=mc`02og=mc`05o`000?mhQ=;o0000ohN8cOl000001On<T=800ol0003oVigF
oi^MeP03oi^MeP;o00001OnT[=d01_l0003oZJkKo`000?l0003oYkgYo`0000GoZ;gX00?o0000ojVn
j?nY_^P00_nY_^P01?l0003oZ[oYojZojOnZ_nT3o`0000Go^;cM00?o0000olBneOo4_]D01?o4_]D0
0ol0003oclKBolo6dP03olo6dP05o`000?oCa/go0000omWBd_l000000ooMdlh2o`0000?oi>CB00Co
0000onGTdOl0003o00000_oSm=H00ol0003ohO;Jo`000002o`000007olkcj_l0003oaNK^olGVk_l0
003o^MK_o`000002ojc3j`05o`000?nN/NGoW[7UoijaiOl000000onBX]l2ohREf@;o00000omdR]/0
1?l0003oK8;Gofb2eol00003ofIle005o`000?mTNM?oI7WCofAidol000001oooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00Co00003oooool002gooooo00?o0000ooooooooool07?oo
ool00ol0003oooooo`000004on7NdP04o`000?oOgMCogmgDo`0000?og=cF00Co0000omOJf_oGf][o
em[J0_l000000oo>cMWo0000olC:g`02olC:g`07o`000?nfaNGo]/GUokK5iOl0003oXkc[o`000002
ohZ`k`04o`000?m/WnooC8_Zodb;jP;o;gOS00WoCWcOo`000?loL=[o0000ocIYeolcI]Go0000oeI`
dOl000000omGL]801OmMMmGo0000og=mcomcOLoo000000?oN8CB00?o0000ohb@d_n<T=800on<T=82
o`0000?oVigF0_l00002oj2[g`03o`000?nT[=goY:cM00Co00000_nW_NT=o`0000CoZ[oY00?o0000
oj_0jOn[`>T00_l000001?nh_=go0000ok[0g_nj`=h3o`000005olBneOl0003oalKIolO6fOl00000
1?o?a]802Ol0003ofM;BomWBd_oId];o0000omgCc_l0003oh^;Do`000003onCTdP;o000000Goi?GE
o`000?oSm=Ko0000on7bfP02o`000004om;jhol0003oc_?Zo`0000;oaNK^00?o0000okWFkol00000
0_n/`n/01?l0003oW[7UoijaiOl00003oi:Rg`04o`000?n8UMWoR9GIohREf@;o000000?oM8[Ko`00
0?m/P]L00_m/P]L01Ol0003oIWcDofIle?mVO=Co000000?oI7WC00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`0:ooooo`04o`000?ooooooooooo`0001;ooooo000^ooooo`;o00007Oooool0
0ol0003oooooo`000003on7NdP05o`000?oOgMCogmgDomoMe?l000000_oLg=H00ol0003oem[JomOJ
fP02o`0000?oc/gI00Go0000olC:goo4b]ooa<[Oo`000002okK5i@04o`000?nS_>_oXkc[o`0000;o
R[3_00Co0000ofbOkom<Rn[oC8_Z0_l_Mn<3o`0000;o=VWG00?o<fKEo`000?l000000omGL]82oeeg
e@03o`000?mcOLoo000000?oN8CB00?oP8kHo`000?n<T=800_n<T=801_l0003oTicIoi>LfOl0003o
VigFo`0000CoX:_O0ol00003ojJlj@?o00000_nQc_L00ol0003oWLchoig<n002oig<n003o`000?nI
bOSoVLWh00;oVLWh00?o0000oiK6monFa_L00_l00005oj_0j@03o`000?nj`=ko^/3N00Co^/3N00?o
0000olO6fOo7a]T00_o7a]T01Ol0003oclKBo`000?oCdMOo000000CofM;B00Co0000on;Re?oRh]Co
00000ooTi=801Ol0003oi?GEonCeeOl0003ohoCF00;o000000Goe?kKo`000?l0003oc_?Zo`000002
olGVkP03o`000?nie^oo000000;o[<?[00Go0000oijaiOnN/NGoW[7Uo`000002oi:Rg`03o`000?n8
UMWoR9GI00;oR9GI0_n1Rm@2o`0000?oK8;G00Go0000ofIle?mVO=CoIWcDo`000002ofAid`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool02Oooool01?l0003oooooo`000?ooool5o`0000ko
oooo000`ooooo`03o`000?oooooooooo01_ooooo0_l00003on7NdP05o`000?oOgMCogmgDomoMe?l0
00000ooLg=H2o`000003omC>dol0003oc/gI00;oc/gI00Go0000olC:goo4b]ooa<[Oo`000003okK5
i@04o`000?nS_>_oXkc[o`0000;oR[3_00Go0000ofbOkom<Rn[o0000obmgh`02oaMVfP03ocm`f_l0
003o=VWG00;o<fKE0_l000000omGL];o0000oeege@02oeege@;o00000_mhQ=801_l0003oP8kHoh2>
f?l0003oS93Bo`0000CoTicI0_l00003oj2[g`04o`000?nU_>[oYKcZo`0000;oY[cY00?o0000ojG@
m_l000000_nQc_L;o`0000CoU/Kg00Ko0000oiC2m_l0003o0000oj_0jOl00002ojc1j@;o000000Go
^/3No`000?nlaN7o_<GQo`000004olO6f@05o`000?oCdMOodm7Gom?Aeol000000_oId]82o`0000?o
h^;D00Oo0000onCTd_l0003o0000onCeeOl0003ohoCF00;o000000?oe?kKo`000?oBn^<00_l00002
olGVkP04o`000?nie^oo^MK_o`0000;o[<?[00Co0000oijaiOnN/NGo00000onBX]l01Ol0003oR9GI
ohREfOn8UMWo000000?oPH_D0_l000000om/P]Oo0000ofIle002ofIle005o`000?mTNM?oI7WCofAi
dol000002_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo017ooooo000aooooo`03
o`000?oooooooooo01_ooooo00?o0000on7Nd_oQg]800_oQg]801?l0003ogmgDomoMe?l00002omcL
eP;o00000ooDc]<01Ol0003oc/gIolk=fOo>cMWo000000?oa<[O00Co0000okK5iOnfaNGo00000_nS
_>/02Ol0003oR[3_ohZ`kol0003oK9o_o`000?m<Rn[o0000obmgh`02oaMVfP04o`000?lfJMOo0000
oc=Ve@;o=VWG0_l00003oeege@;oIH3I00?o0000ogR4d_l000000on0S]P2o`0000?oTicI00Ko0000
oi^ZhOnKZ^7o0000oj2[gol00003ojFljP?o00000_nUd?H3o`000005ohkLo_l0003o0000o`000?n1
eOl00_l000000omfc?oo0000o`000003ofo4o`;o00001?nD`_H00ol0003o[<7Yojc1j@03ojc1j@03
o`000?nlaN7o_<GQ00;o_<GQ00Go0000olO6fOl0003ob/kMo`000003om?Ae`05o`000?oId];o0000
omgPf?l000000ooRh]@2o`000003on?de_l0003oi?GE00;o000000?oe?oEo`000?oDo]/00_l00000
1oo>ln[o0000olGVk_o5i^ko0000okWFkol000000_n/`n/01Ol0003oW[7UoijaiOnN/NGo000000;o
TZ;O00Go0000ohREfOn8UMWoR9GIo`000004oh6;e0;oNhC@0_l00003ofIle005o`000?mTNM?oI7WC
ofAidol000002oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo017ooooo000boooo
o`03o`000?oooooooooo01_ooooo00Go0000on7Nd_oQg];ohMkBo`000003omoMe0;o000000?ofLo@
o`000?oDc]<00ooDc]<01Ol0003oc/gIolk=fOo>cMWo000000;oa<[O00Ko0000okK5iOnfaNGo]/GU
o`000?nS_>/7o`000004odb;j_l0003o;gOSoaMVfP;o25_D00?o=VWGoc=VeOl000000_lfJML2o`00
00;oGGOE00?o0000ofF0fOmUP=T00_l00003oh2>f0;oRY_N00?o0000oi>LfOl000000onKZ^43o`00
0003ojFlj_l0003o000000;oZM3d4?l000000olo003o0000oc:UlP03oc:UlP03offloOl0003oTkod
00;oTkod0_l000001?n/`NWo0000ojc2j_l00004okc5h@05o`000?o:c]gob/kMol[>gOl000000_oC
dML2o`0000?ogN3H00Co0000on;Re?l0003o00000_oSm=H02?l0003oi?GEo`000?oDomGo0000omCn
fol0003od_[S3?l000001OnN/NGo0000oi:RgonBX]oo000000CoR9GI00Go0000oh6;e?n1RmCoPH_D
o`000003og^4d005o`000?mVO=CoIWcDofIle?l000000_mTNM<00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool003?ooooo00?o0000ooooooooool0
6_ooool01Ol0003ohMkBon7Nd_oQg];o000000?ogmgD00Go0000omW?d?oIcm3ofLo@o`000004omC>
d`04o`000?o>cMWoc/gIo`0000?oa<[O00?o0000okK5iOnfaND00_l00002oj>mk005o`000?n7/o?o
Qk?co`000?mQXo@00_l000000ol_Mn?o0000oaMVfP02o`QKe004o`000?lcI]Go=VWGocIYe`;o?g3J
0_l00003ofF0f@;oLHcN00?o0000oh2>f?l000000on:Vmh3o`000003oi^ZhOl0003oY;cZ00;oY;cZ
0ol000001?nYd?Co0000ojWTn_l00002oj7`m0_o000000?oKG[?oeIee_lgK]/00ol000000ol4Omoo
?9odo`000002ofjen`04o`000?nC_oCoTkodo`0000?o[<;Z00Go0000okc5hOl0003o_L[To`000003
ol[>g@05o`000?oCdMOo0000omGMgOl000000ooMh=P2o`000005on7bf_l0003ohoCFo`000?oTmMD0
0ol000001OoDo]_o0000o`000?l0003o_OW]00;o00000onefO800ol0003oZlC/o`000003oj6ah`05
o`000?nBX]ooTZ;Ooi:Rgol000000on8UMT01Ol0003oPH_Doh6;e?n1RmCo000000CoNhC@00GoN7o>
o`000?mVO=CoIWcDo`000002ofAid`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0?ooooo`00=?ooool2o`0001[ooooo00Go0000on7Nd_oQg];ohMkBo`00
0002omoMe0;o00001?oIcm001Ol0003oe<kComC>dooDc]?o000000?oc/gI00?o0000olC:goo4b]l0
0ol00002okK2h`04o`000?nS_NcoXkg/o`0000;oQk?c00?o0000of6Sm?l000000_l000002?lGI][o
0000o`QKe?l4Em;o<fKEo`000?lfJMOo00000_loL=X2o`0000;oIH3I00?o0000og6<g_maS=h00_l0
0003ohZKgP03o`000?nFZnGoUZ_U00?o000000CoY;cZo`000?n]d?;o[M3b4_l000002_mnOl[oKG[?
oeIee_l0003o@gSOo`000?lOP^So0000odZKlol00003og>_m`;oU;_b00Go0000ojc2j_n/`^[o[<;Z
o`000003okg:i003o`000?o:c]gob/kM00;o00000_oEgMd00ol0003ogN3HomgPf002o`0000;ohO;J
00?o0000on?de_l000000_l000000ooDomGo0000omCnf`02o`000003okgikOl0003o000000?o]MWb
00?o0000oj_4k?l000000onQ/N<01Ol0003oV:7Ko`000?nBX]oo000000?oR9GI00?o0000oh6;e?n1
Rm@00_n1Rm@01Ol0003oNhC@og^4d?mkQ=3o000000;oN7o>0_l00003ofAid`03o`000?oooooooooo
00cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0?ooooo`00=_ooool00ol0003o
ooooooooo`0Hooooo`04o`000?oQg];ohMkBon7NdP;o00000_oKd<d01Ol0003ofLo@omW?d?oIcm3o
000000Coe<kC00Ko0000olk=fOo>cMWo0000olC:gol00003ol?4f`?o]/;S00Co0000oj>mk?nS_Nco
00000_n7/o<02Ol0003oHJ?do`000?l0003o2FoNoaMVf_l0003o25_Do`AGdP02o`000003ocIYeolo
L=[o?g3J00;oCGcO0_l00003og6<gP;oP9_S00?o0000ohZKg_l000000onFZnD00ol0003oXkc[oj>l
j`02o`000003ojg@l_l0003o000000co000000gobk;2o`000?l0003o0000oiR9`_n=Q<GoOWo:ofej
col0003oGGcIod=hgol0003o>hCY00Go000000?oLjogo`000?l000000_l000000on/`n_o0000okg:
i002okg:i005o`000?o:c]go0000ol_Ghol000000ooEgMd2o`000005omc_g_l0003ohO;Jo`000?oS
m=H00_l000000ooDom?o0000o`000003o`000003okgikOl0003o000000?o]MWb00?o0000oj_4k?l0
00000onQ/N<01?l0003oV:7KoiRQfonHXM/2o`0000?oR9GI00Go0000oh6;e?n1RmCoPH_Do`000003
og^4d003o`000?mhOlkoN7o>00;oN7o>0_l00002ofAid`03o`000?oooooooooo00gooooo00?o0000
ooooooooool02Oooool2o`00013ooooo000gooooo`03o`000?oooooooooo01Oooooo00?o0000on7N
d_oQg]800_l00004om_@c@05o`000?oIcm3ofLo@omW?d?l000001?oDc]<01?l0003oc/gIo`000?l0
0005ol?4f`04o`000?nf`^?o]/;So`0000;oXkg/00Go0000ohNclon7/o?o0000of6Sm004o`0000Co
25_D00Co=VWGo`000?loL=[o00000_m=O=l2o`0000;oLHcN00?o0000oh2Khon0Vn<00ol000000onF
ZnGo0000oj>lj`02oj>lj`05o`000?naco3o0000o`000?nmhO401ol000001?oLe];o0000o`000?oB
_LD5o`000003oj>?`?l0003oSHC500;o000000?oLH3BoeelfOl000000_mDQN@00ol0003oFYS_o`00
0002ogVZlP04o`000?nE^O3oUKW`o`0000;o[<?[00?o0000okg:i?nmb^@00_l00002ol_Gh`03o`00
0?oEgMgoeMgM00;o00000_oLkmh01Ol0003ohO;Jo`000?l0003oe?oE00Ko000000?o_OW]o`000?l0
00000onefO800ol0003oZlC/o`000003oj6ah`05o`000?nHXM_oV:7KoiRQfol000000_nAUM@00ol0
003oR9GIo`000003oh6;e003o`000?mkQ=3oNhC@00;oNhC@00?o0000ogQoc_mhOlh00_mhOlh2ogIm
c@;o00004?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00gooooo000hooooo`03
o`000?oooooooooo01Kooooo00Go0000on7Nd_l0003ogM3<o`000004om_@c@03o`000?oIcm3ofLo@
00;ofLo@00?o0000omC>dooDc]<00_oDc]<01?l0003oblCDol_4e?o;a=@5ol?4f`04o`000?nf`^?o
]/;So`0000;oXkg/00Go0000ohNclon7/o?o0000of6Sm006o`0000;o25_D0_l000000oloL=[oCGcO
odelg`02oen;i0;o00000on0Vn<3oi6/j0?o000000CoXkc[o`000?naco3o/Lo`1?l000000oo>i^So
0000o`000002o`000003omcFd_l0003oelW<00Co000000Co_::nokBK__n/U;koXho00_l000002?n?
R<SoPXC=oh:4cOmaP=;o0000ofR7gOmDQNCo00000_mXUNT2o`000003ogVZl_l0003oUKW`00Ko0000
00?o_LoXo`000?o;en<00_o;en<2o`000005omCYi?l0003og>oNo`000?oQl]X00_l000001OoDomGo
0000omCodol0003o/O[@00;o000000?o_OW]o`000?l000000onefO800ol0003oZlC/o`000003oj6a
h`05o`000?nHXM_oV:7KoiRQfol000001?nAUM@2o`0000?oPH_D00Go0000og^4d?mkQ=3oNhC@o`00
0004ogQocP05o`000?mfOLgoMWg=ogImcOl000004Oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00gooooo000iooooo`03o`000?oooooooooo01Kooooo00Go0000omg@c?oMd<cogM3<
o`000004om_@c@05o`000?oIcm3ofLo@omW?d?l000000ooDc]<00ol0003od<C>o`000003ol_4e003
o`000?o3a=_o`lCK00;o`lCK00Co0000okK2honf`^?o00000_nS_N`01Ol0003oQk?cohNclol0003o
HJ?d00?o000000[o05O>o`17`_l4Em;o25_Do`000?lGI][o?g3Jo`000?m=O=oo00000_mORn@2o`00
0003oh2Khol0003oTJcX00;oTJcX00?o0000oj:mk?nR_N`01Ol000000oo2fnco0000olkVj003o`00
00;oemGF00Co0000omO9c?l0003od;g82Ol00002ohn8b0;oPXC=0_miR=L00omXQmgo0000o`000002
o`0000;oOjK/0_l000001OnG]^go0000ojc4k?n/a>co000000?o_LoX00Co0000ol_Ghol0003o0000
0_oDjN@01Ol0003og>oNo`000?l0003oe?kK00Co000000Co/O[@o`000?l0003o_OW]1?l000001?ne
fO;o0000oj_4k?l00003oj6ah`05o`000?nHXM_oV:7KoiRQfol000001?nAUM@01_l0003oS8g?ohb=
col0003oPH_Do`0000CoNhC@00Go0000ogQoc_mhOlkoN7o>o`000004ogImc@03o`000?oooooooooo
013ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`00>_ooool2o`0001Ko
oooo00?o0000omg@c?oMd<`00_oMd<`01Ol0003ofm3=om_@cOoKd<go000000CofLo@00?o0000omC>
dol000000oo@a<h01?l0003oblCDol_4e?o;a=@2o`0000?o`lCK00Go0000okK2honf`^?o0000oj>m
k009o`000006o`1Gc_l0Al;o0000o`QKe?l0003o5fKJ0_l000000om=O=oo0000oen;i003ogFLj@;o
000000?oTJcXo`000?nR_N`00_nR_N`01Ol0003o/lg]ok?=kOl0003o`]_/00Go00000_oGeMH01_l0
003odlW@o`000?o@_LSo0000olZca0;o000000So^jC1o`000?l0003o0000oj>A`_nJSLGo0000ohn8
b0;o000000CoQX_AogV8eomiR=Oo00000_mfU>84o`0000?oUkK]00Go0000ojc4k?n/a>co0000okg?
j003o`000005ol[PjOl0003oe>WTo`000?oLkmh00_l000000ooDo]_o0000omCoe@02o`000003ok7j
d?l0003o000000;o00000on_f_H4o`0000?oXK7S00Go0000oiRQfonHXM_oV:7Ko`000004oi6Ee004
o`000?n<SLooS8g?ohb=c`;o00001?mkQ=000ol0003oN7o>ogQocP02ogQocP05o`000?mfOLgoMWg=
ogImcOl000004oooool00ol0003oooooooooo`09ooooo`?o00003Oooool003cooooo00?o0000oooo
ooooool05?ooool01Ol0003ogM3<omg@c?oMd<co000000Cofm3=00?o0000omW?d?oIcm000_oIcm00
0ol0003od<C>om34cP03om34cP03o`000?o;a=CoblCD00;oblCD00Ko0000ol?4foo3a=_o`lCKo`00
0?nf`^<2o`0000?oXkk]0on5^?L2oeJWn0;o000000Go05O>o`17`_l0003o25_Do`000002obefhP04
odelgol0003oGh_To`0000;oMIcY00?o0000ohb]k?n<[N`02Ol000002_o4eNOo0000o`000?o?d]_o
0000omOEe_l0003odlW@o`000?o=_/`3o`000003ol>[`_nkY<7o^jC100;o000000Oo[9O1oj>A`_l0
003oVXg5o`000?nAS/co000000;oQX_A00?oNHSGoh:Dg?n2U=`00_mfU>83ohNTi`So000000Co_=C/
o`000?o:h>Wob^3Y1?l000000ooBnn;o0000omCnf`05o`000003oj7ej_l0003o000000;o[m[f1?l0
0002oj>ahP03o`000?nQ/N?o000000?oV:7K00?o0000oi6Ee?nAUM@00_nAUM@01Ol0003oS8g?ohb=
con<SLoo000000;oR8K;00Co0000og^4d?mkQ=3o00001?mhOlh01Ol0003oMWg=ogImcOmfOLgo0000
01Gooooo00?o0000ooooooooool01Oooool3o`0000;ooooo00?o0000ooooooooool02oooool003go
oooo00?o0000ooooooooool05?ooool01Ol0003ogM3<omg@c?oMd<co000000Cofm3=00Co0000omW?
d?oIcm3o00000_oDa<X5om34cP03o`000?o;a=CoblCD00;oblCD00Go0000ol?4foo3a=_o`lCKo`00
0003okFoh@CoXkk]0_n5^?L00ol0003oEZOho`000005o`000003oaMVf_l]M^;o;GKR00;o000000Co
Gh_To`000?meW>Wo00000_n<[N`01?l0003oXKg]oj6mkOl00003okC;j`04o`000?o4eNOo0000o`00
00;ocm;K0_l000001_oCbM3o0000olfnc?o=_/co0000olNfb@Co000000?o]9g1o`000?l000000ol0
00001OnKT/Wo0000oi6>c?l0003oQX_A00;o00000_n2U=`2o`0000;oQjCW00Co0000oiVdjonI]>_o
00000_n[aNd01Ol0003o_=C/okcDk?l0003ob^3Y00;o000000?ocO?Zo`000?oBnn802_l000001On_
f_Ko0000o`000?nZa>go000000CoXk7R0_l00003oiRQf`03o`000?nAUMCoTIGD00;oTIGD00Go0000
ohb=con<SLooS8g?o`000004ohR6b`03o`000?mkQ=3o000000CoN7o>00Go0000ogImcOmfOLgoMWg=
o`00000Fooooo`03o`000?oooooooooo00Co00001Oooool00ol0003oooooooooo`0;ooooo`00?_oo
ool00ol0003oooooooooo`0Cooooo`03o`000?oMd<cogM3<00;ogM3<00Oo0000om_@cOoKd<gofm3=
o`000?oIcm3o000000Coe<C:00?o0000om34c_o@a<h00_o@a<h00ol0003oblCDol_4e002ol_4e003
o`000?o3a=_o000000;o`;kH1?ne_n400ol0003oXkk]oj>nk@02o`000003ohFhmol0003oEZOh00Ko
000000Co;GKRo`000?m:R^[oBX[Z0_l000001OmeW>Wo0000ohb]k?n<[Nco000000;oXKg]00?o0000
okC;jol000000_l000001?o4c^;o0000oloBfol00002olg9eP;o000000CocKk<o`000?o7]/WoakK9
0_l000002?njY/Go0000o`000?l0003o[9_5o`000?nTU/Oo00000_nKT/T00ol0003oTHk<o`000002
ohbEe`;oPYCL00?o0000ohjRh_n>X^800_l000001OnI]>_o0000oj_5kOn[aNgo000000;o_=C/00Ko
0000ol[PjOl0003o0000olgcj_l00002om;khPSo00000_n_f_H01?l0003oZ/C]o`000?l00003oj>a
hP;o00000_nMX]P00ol0003oV:7Ko`000004oi6Ee005o`000?n<SLooS8g?ohb=col000001On8Q//2
o`0000CoN7o>00Go0000ogImcOmfOLgoMWg=o`00000Gooooo`?o00002Oooool00ol0003ooooooooo
o`0;ooooo`00?oooool00ol0003oooooooooo`0Cooooo`05o`000?oMd<cogM3<omg@c?l000000ooK
d<d3o`0000Goe<C:00?o0000om34c_o@a<h00_o@a<h01?l0003oblCDol_4e?o;a=@2o`0000Go`;kH
00?o0000okFohOne_n400_l00002oj>nk@;o000000?oQKSgo`000?mFYoP01?l000001Ol0Elgo;GKR
o`000?m:R^[o000000;oJIk_2?l000000oneb>So0000olC>hP02olC>hP06o`000?o=bMKocLWFolg9
e_l0003ob<3B0_l000002_o7]/Wo0000ol6^a_l0003o^ZK5o`000?ncX<Go0000ojbKaOl00002ojBF
a`06o`000?nKT/Wo0000o`000?nFUm;o00000_n<UML2o`0000;oSZ;R00?o0000oi^cj?nK/nP02?l0
00000oo5j>oo0000olgcjP06o`000005oj7ej_l0003o[Ngho`000?n_f_H01?l00004oj>ahP03o`00
0?nMX]SoWJ;H00;oWJ;H0ol00003oi6Ee005o`000?n<SLooS8g?ohb=col000001On8Q//01?l0003o
QX;8ohJ2b?l00002ogQocP05o`000?mfOLgoMWg=ogImcOl000005?ooool4o`000003ooooool0003o
oooo00Wooooo00?o0000ooooooooool02oooool0043ooooo00?o0000ooooooooool04oooool01ol0
003ogM3<omg@c?oMd<co0000om_@cOl000000ooF`lP00ol0003oe<C:omC4bP03omC4bP03o`000?o@
a<kod<C>00;od<C>00?o0000ol_4e?l000000oo7_=000ol0003o`;kHol2nf002ol2nf0;o00000_ne
_n42o`0000;oXkk]00?o0000ohFhmol000001Ol000001ol0Elgo0000odZ:j_m:R^[o0000ofVNkol0
00000_n7/?001?l0003oXKk^oj6nk_l00003okG8j0;o00000_o3b=h00ol0003ocLWFo`000002olS0
dP03o`000?o4^<oo000000;o00000_njY/D01ol0003o/j35ok>PaOl0003o[9_5o`000?nTU/L00_l0
00001onNVLoo0000oiJGd_nFUm;o0000ohbEeol000000_nDX]h2o`0000;oVk?X00Co0000oj[6k_nZ
a^ko00000_nif?000ol0003oaNS_o`00000=o`000003oj[4kOl0003oXk7R00?oXk7R0_l00003oifR
f0;o00000onIUm000ol0003oTIGDo`000003ohb=c`03o`000?n8Q/_oR8K;00?oR8K;00?o0000ohJ2
b?n6P/P00_n6P/P00ol0003oN7o>o`000003ogImc@03o`000?oooooooooo00oooooo0ol00006oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02_ooool0047ooooo0_l0000Dooooo`04
o`000?oMd<cogM3<omg@c0;o00001?oF`lP00ol0003oe<C:omC4bP03omC4bP03o`000?o@a<kod<C>
00;od<C>00?o0000olNld?o7_=001?o7_=000ol0003o`;kHol2nf002ol2nf0;o00000_ne_n401?l0
003oXkk]o`000?l00002ohBmnPGo000000Co05O=o`000?l0003o00000_mYW^l01?l0003oQk3`ohN`
l?l00002oj6nkP04o`000?neb>So0000o`0000Co`lSN0_l000001_o8`=;o0000olBhcoo4^<oo0000
okjac@[o000000KoYIg=o`000?nNVLooWYW?o`000?nFUm83o`000003oiBRg_l0003oW[;V00;oW[;V
0_l000001?nZa^ko0000okWHl?nif?04o`000003okcikOl0003o000000So000000?oZLC]o`000?l0
00000onS/N82o`0000CoWJ;H00?o0000oiVGd?nIUm000onIUm02o`0000?oS8g?00?o0000ohR6bon8
Q//00on8Q//00ol0003oQX;8ohJ2b003ohJ2b0;o00000omfOLd00ol0003oooooooooo`0<ooooo`Co
00002_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00[ooooo0013ooooo`03o`00
0?oooooooooo017ooooo00Oo0000omg@c?oMd<cogM3<o`000?oG`lOo000000Coe/?800?o0000omC4
b_oDa<X00ooDa<X01ol0003od<C>om34c_o@a<ko0000olbkb_l000001Oo7_=02o`0000Co`;kH00Co
0000okFohOl0003o00000onS_nd01?l0003oQ;gjohBmn_n4_OX5o`000003oc69k?l0003o000000So
00000_neaNH00ol0003o`lSNo`000003ol71fP;o000000Goa;S?o`000?nn/Lgo_[7=o`000002okV[
c006o`000?ncYL_o/jG;o`000?n/XLco00000onUWLd01?l0003oWYW?o`000?l00003oi^SfP;o0000
0onN/^H00ol0003oZLK^ojW6kP04o`000003ok_]m?l0003o_?W]00Wo000000?oZLC]o`000?l00000
0_nV/N000ol0003oXk7Ro`000004oifRf0;o00001?nIUm02o`0000;oUHo;00?o0000ohb=col00000
1On8Q//00ol0003oQX;8ohJ2b003ohJ2b003o`000?n4PLOo000000?oMWg=00?o0000ooooooooool0
2Oooool3o`0000kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0:ooooo`00A?oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oMd<co000000?oel?700?o0000omK3b?oF`lP00_oF
`lP2o`0000Coe<C:00?o0000om34c_l000000oo<^lX2o`0000Goakc@0_l00003ol2nf005o`000?nd
_>3o];cPokBlh?l000001?nS_nd2o`000007ohBmn_l0003o032Ko`13[ol0003o<HW/o`000002oefR
m003o`000?n3]?Co000000?oXKo^00Co0000okG5i_neaNKo00000oo1`MX00ol0003o_K_Hokfkf004
o`0000?o^J_<00Co0000ok>UboncYL_o00000_n/XL`00ol0003oYIg=o`000002o`0000;oXJCH00?o
0000oi^Sf_l000000_nQ/^@00ol0003oW[;Vo`000002ojW6kP07o`000?ncfoCo/m_do`000?nkkOCo
0000okcik@07o`000004ojW4kOl0003o0000o`0000CoY[7P0_l00003oifRf0;o00001?nIUm02o`00
00CoUHo;0_l00005ohR6b`03o`000?n6P/SoQX;800?oQX;800Oo0000ohB1aon4PLOoQ877o`000?mf
OLgo000000Sooooo1?l0000Booooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02_oo
ool004Gooooo00?o0000ooooooooool04Oooool2o`0000Coel?700?o0000omK3b?oF`lP00ooF`lP0
0ol0003oe<C:omC4bP02omC4bP03o`000?o<^l[oc;_:00Coc;_:0_l00005olNld003o`000?o0_]So
000000;o_KWE00?o0000okBlh?nd_>000_nd_>02o`0000;oXko]0ol000000on4_O[o04>_o`13[`02
o`0000;oGJ;d00?o0000oh>dm?l000000_nQ_nh2o`0000Co]<;T00Go0000okfkf?nm^mSo_K_Ho`00
0002okZfePco00000_nWY]H00ol0003oXJCHoj6Tf002o`0000?oXK;T0ol000001_nYa^ko0000ok?K
m?ncfoCo0000ok_]m0Go000000CoYm[io`000?l0003oZLC]0_l00005ojJah0;o00000_nSXmD00ol0
003oWJ;Ho`000005oiVGd003o`000?nESl_oUHo;00?oUHo;00Co0000oi>9a_nCRLKo00000on8Q//0
0ol0003oQX;8ohJ2b003ohJ2b003o`000?n4PLOoQ87700;oQ8770_l00006ooooo`?o00005oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00[ooooo0016ooooo`03o`000?oooooooooo
01;ooooo00?o0000omO3aooG`lL00_oG`lL00ol0003oe/?8omK3b003omK3b007o`000?oDa<[oe<C:
omC4b_l0003oc[[6o`000006olbkbP03o`000?o7_=3oakc@00?oakc@00?o0000okfieOnm^MD00onm
^MD3o`0000?o];cP0ol000001OnS_ngo0000ohG3o?n5`oco04>_00So00000onQ`>l00ol0003o]<;T
o`000002ok>oh`;o00000onj]]H01Ol0003o][7DokJae?nf/MCo000000;o/JgD00Co0000ojbYe?n/
ZMCo00000_nWY]H4o`0000;oY;?S00?o0000oj6bi?l000000_nXa^l9o`000005oioHo?l0003o0000
o`000?nYa>d00_l00004ojJah0?o00001?nSXmD2o`0000CoVIO@0_l00004oiF?b`;o00001?nCRLH0
0ol0003oR8K;o`000004ohJ2b0;o00001?n4PLL00ol0003oooooooooo`02ooooo`Co00006oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00[ooooo0017ooooo`;o00004oooool00ol0
003oel?7omO3a`02omO3a`03o`000?oF`lSoe/?800?oe/?800?o0000omC4b_l000000oo>^/H2o`00
00Goc;_:0_l00003olNld003o`000?o3]Lgo000000Ko_KWE0_l00004okBlh004o`000?nT`NkoY<7^
ojC1kP?o000000Ko06?<oe:Vn?mBY_SoDZKho`000?n1^OP2o`0000;oXL3_00?o0000ok>ohonc_n<0
0_nc_n<8o`0000?o/JgD00?o0000ojbYe?l000000ol00002ojNdhP03o`000?nT/n?oY;?S00Co0000
00?oZ<K_o`000?n]g?P02Ol000001?nWa>ko0000o`000?l00004ojJah0;o00001?nSXmD3o`0000;o
X9W=00Co0000oiVGd?l0003o00001?nESl/2o`0000KoThW60_l00004ohJ2b003o`000?n4PLOoQ877
00?oQ87700?o0000ooooooooool00ol0000Oooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool02_ooool004Wooooo00?o0000ooooooooool04Oooool00ol0003oel?7omO3a`02omO3a`03
o`000?oF`lSoe/?800?oe/?800?o0000oljja_o>^/H01?o>^/H2o`0000Goc;_:00?o0000olNld?l0
00001Oo3]Ld2o`0000Co_KWE0_l000000ond_>3o0000ok:jg`02ok:jg`04o`000?nT`NkoY<7^ojC1
kP;o000000Go68OXo`000?mBY_So0000oh6in002o`0000CoXL7`00?o0000ok6lh_na_>800ona_>80
0ol0003o[k[Qojnjh@06o`0000;oZ[GQ00?o0000ojNdh_nW]>801?l00003ojO6l0Wo000000?oYlC^
o`000?l000000_l00003ojVbg`04o`000?nV/N3o0000o`0000CoXj?E0_l00005oj2Ic@;o00001OnE
Sl/00ol0003oThW6oi>9aP04oi>9aP;o000000?oTHK4o`000?n6P/P00_n6P/P00ol0003oQ877ohB1
a`03ohB1a`Co00008oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Wooooo001:
ooooo`03o`000?oooooooooo017ooooo00?o0000omO3aooG`lL00_oG`lL01Ol0003oe/?8omK3b?oF
`lSo000000;od;W400?o0000oljja_o>^/H01?o>^/H00ol0003oc;_:olbkbP03olbkbP03o`000?o3
]Lgo`kG=00Ko`kG=0_l00004okfie@03o`000?nb^]oo/[[O00Go/[[O0ol00002o`1H[`?o00000on0
__/2o`000003oj71l?l0003oXL;`00Co00000on_^^401Ol0003o[KOQojfghOn]]n7o000000;oZ[GQ
1?l00003ojK6l003o`000?nWa_3o000000_o00001_nY/]l3o`0000CoXj?E0_l00005oj2Ic@;o0000
00?oWY;7o`000?nESl/00_nESl/2o`0000KoThW600?o0000oi66a?nAQ/@00_nAQ/@00ol0003oQX;8
o`000005ohB1a`03o`000?oooooooooo02Kooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`09ooooo`00Boooool00ol0003oooooooooo`0Aooooo`03o`000?oG`lOoel?700;oel?700?o
0000omK3b?l000001?o@^L@2o`0000Goc[[60_l00003olbkbP03o`000?o6//Oo000000;o00001_o3
]Ld3o`000004okfieOl0003o^[?CokZcd`;o00001_nb^]l3o`000003o`1H[ol0003oBJci00;o0000
0_n0__/00ol0003oXL;`oj72l003oj72l0_o00000_nTaO001?l0003oY/K`ojK6l?nVa_05o`000003
oiKZnOl0003o000000?o00001OnY/]l5o`0000;oZ:GC00?o0000oj>SeOl000000_l00005oj2Ic@;o
00001?nNT/L00ol0003oUHo;o`000006oi>9aP;o00001OnAQ/@2o`0000GoQ87700?o0000oooooooo
ool09oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo001<ooooo`03o`00
0?oooooooooo017ooooo00?o0000omO3aooG`lL00_oG`lL00ol0003od;W4om2ia005om2ia0;o0000
1Oo>^/H00ol0003oc;_:o`000005olJba`?o00001_o3]Ld00ol0003o^[?CokZcd`06okZcd`Co0000
0_nb^]l00ol0003oY<;^ojC2kP03o`0000GoPLCm0_l00002oj;3l003o`000?nR`o3o000000CoXlCa
00?o0000ojC5l?nTaO003?l00002ojbcgP03o`000?nY/]ooZK;O00Co00001_nXYM<3o`0000KoX9W=
0_l00006oijBa`;o00001OnCRLH2o`0000KoTHK400?o0000oi25`ol000001?n4PLL00ol0003ooooo
ooooo`0Yooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02Oooool004gooooo00?o
0000ooooooooool04Oooool01ol0003oel?7omO3aooG`lOo0000om2h`_l000001oo@^L@00ol0003o
c[[6oljjaP03oljjaP03o`000?o6//Ooa[;700Ooa[;70_l00004ol>ec@03o`000?nn[l_o_Zo;00?o
00001onj/m<2o`0000Oo/;ON1Ol00004ohG:oQ;o00000on//mh5o`0000GoZ:GC1Ol00002ojNLb`03
o`000?nPVLgoX9W=00;oX9W=0_l00006oijBa`;o000000?oW8g3o`000?nCRLH00onCRLH00ol0003o
THK4oi66a004oi66a0;o00000on@QL<01?l0003oQ877ohB1aol0000]ooooo`05o`000?oooooooooo
ooooool000002oooool004kooooo0_l0000Booooo`03o`000?oG`lOo000000Cod;S200?o0000om2i
a?o@^L@01?o@^L@2o`0000?oc[[600?o0000olRa`ol000000_l00007olJba`Co00001_nn[l/3o`00
00Go^[?C00?o0000okJ_d_nf[m800_nf[m87o`0000;o/;ON00?o@`00odVlmOl000002ol00003ojbc
gPOo00000on]Z=800ol0003oZ:GCojRUd`04o`0000SoYic;00Co0000oj2IcOl0003o00001_nNT/L2
o`0000CoW8g300Co0000oi>9a_l0003o00001_nAQ/@00ol0003oT8G3oi25``03oi25``03o`000?n4
PLOo000002kooooo00Go0000ooooooooooooooooo`00000;ooooo`00D?ooool00ol0003ooooooooo
o`0@ooooo`03o`000?o@^<;od;S200Cod;S20_l00006om2ia003o`000?o>^/Ko000000Gob;730ol0
0007olJba`03o`000?nn[l_o_Zo;00Oo_Zo;0ol000000onj/m?o0000okJ_dP0;okJ_dQ?o00002?n]
Z=85o`0000_oYic;0ol00005oijBa`?o00001_nLSL<2o`0000KoTHK40_l00006oi25``;o0000<?oo
ool01?l0003oooooooooool0000;ooooo`00DOooool00ol0003oooooooooo`0Aooooo`03o`000?o@
^<;od;S200Cod;S20_l00005om2ia003o`000?o8/L?ob;7300Oob;730_l00005olJba`03o`000?o0
ZlGo`:_500Go00001Onn[l/2o`0000Oo]ZoB00?o0000okJ_d_nf[m801?nf[m800ol0003o/J_Bok6[
dP0;ok6[dP04o`000?n]Z=;o[JSBojfXdPOo00000on]X<X00ol0003oYic;ojNLb`05ojNLb`Go0000
0_nVU/D01?l0003oWY;7oijBaonNT/L2o`0000KoW8g30ol000000onKRl7o0000oi66a004oi66a003
o`000?n@QL?oT8G300CoT8G30_l0000cooooo`03o`000?oooooo000000_ooooo001Booooo`03o`00
0?oooooooooo017ooooo0_l00006om2h`P03o`000?o@^LCod;W400;od;W400?o0000olV``Ol00000
0_l00007olRa``?o000000?oa[;7o`000?o0ZlD01oo0ZlD5o`000003okj_bol0003o^JW:00Oo^JW:
6?l0000;ojfPbP03o`000?nWW<_o000000Co00002?nVU/D3o`0000KoW8g30_l00005oi^;`@03o`00
0?nAQ/CoTHK400;o00001_n@QL<00ol0003oooooooooo`0dooooo`03o`000?oooooo000000[ooooo
001Cooooo`03o`000?oooooooooo01;ooooo0_l00005om2h`P;o000000?od;W4o`000?o9/<401?o9
/<43o`0000Oob;7300?o0000ol2[aOo0ZlD03?o0ZlD2o`0000ko^JW:00?o0000ok>TbOncY<T02onc
Y<T00ol0003o[J3:ojfPbP08ojfPbPKo00002onVU/D3o`0000KoW8g30_l00007oi^;`@03o`000?nA
Q/Co000000KoT8G30_l0000gooooo`03o`000?oooooo000000[ooooo001Dooooo`;o00005?ooool0
0ol0003od;S2om2h`P04om2h`P03o`000?o9/<7obK3100OobK310ol00004olRa``03o`000?o2ZL7o
`ZW100Co00002Oo0ZlD00ol0003o^ZG4okZUa002okZUa0Oo00000_niZLX00ol0003o/jC9ok>Tb@0<
ok>Tb@04o`000?n]X<[o[J3:ojfPbPOo00001?n]V/@00ol0003oYYK5ojJFa@05ojJFa@Go00000_nU
T/401?l0003oW8g3oib=`onLSL<3o`0000WoVh_10_l00005oi25``;o0000>_ooool2o`0000[ooooo
001Fooooo`03o`000?oooooooooo01;ooooo0_l00004om2h`P03o`000?o9[koo000000;o00002?o9
/<44o`0000Oo`ZW10ol00006ol2[a@03o`000?njYLCo^ZG400Wo^ZG45Ol0000<ojfJa003o`000?nV
U/Go000000Co00002?nUT/43o`0000WoVh_10ol000000onKRL3o0000oi25``03oi25``03o`000?oo
oooooooo03Wooooo0ol0000:ooooo`00Eoooool00ol0003oooooooooo`0Cooooo`;o00000_o@^<80
0ol0003obJnoolV__`02olV__`;o00002Oo9/<400ol0003o`ZW1ol:Y`@08ol:Y`@Co000000?o`:_5
o`000?njYL@03OnjYL@00ol0003o/io3ok>O``0<ok>O``03o`000?n]V/Co[I[400Wo[I[41_l0000;
ojFB`@?o00002?nKRl43o`0000GoVhW000Co0000oi25`ol0003o0000>?ooool4o`0000gooooo001H
ooooo`03o`000?oooooooooo01Cooooo0_l00007olV__`?o00001_o9/<400ol0003o`ZNnol:W_P04
o`0000So`ZW10_l00003okZUa0Go00001_njYL@00ol0003o/io3ok>O``0=ok>O``04o`000?n]V/Co
[I[4ojfJa0Oo00001?n]Ul000ol0003oYI;1ojFB`@07ojFB`@?o00000_nTSkl00ol0003oVh_1oi^;
`@03oi^;`@?o00002?nKRL02o`0003Oooooo0ol0000Aooooo`00FOooool00ol0003oooooooooo`0D
ooooo`03o`000?o9[koobJno00SobJno0_l00004olV``@03o`000?o2Ykko`ZNn00Co`ZNn0ol00006
ol:Y`@03o`000?nkX/3o^j;000Ko^j;06_l0000;ojfG`003o`000?nUT/7oYI;100?oYI;11?l00006
ojB?_`03o`000?nKRl7o000000;o00002?nKRL03o`0003Gooooo1?l0000Dooooo`00F_ooool2o`00
01Kooooo0ol00008olV__`Co00002_o2Ykh4o`000003ol:Y`Ol0003o^j;000ko^j;000?o0000okBL
_ondW;l03OndW;l00ol0003o[IO0ojfG`00=ojfG`003o`000?nUT/7o000000;o00002OnTSkl3o`00
00WoVhW00_l0000dooooo`Co00006?ooool005cooooo00?o0000ooooooooool05_ooool3o`0000So
bJno00?o0000ol:W__o2Ykh03?o2Ykh2o`0000?o^j;000?o0000ok^R`?nkX/002OnkX/000ol0003o
]9bookBL_`0=okBL_`03o`000?n]Ul3o[IO000Wo[IO01_l00008ojB?_`Co00000_nTS[d00ol0003o
VhW0oi^9`004oi^9`0?o0000<oooool3o`0001cooooo001Mooooo`03o`000?oooooooooo01Sooooo
0ol00005olV__`03o`000?o3Ykgo`jNm00Co00002Oo2Ykh00ol0003o^j2mok^P_@02ok^P_@So0000
0onkX/000ol0003o]9bookBL_`0=okBL_`04o`000?n]Ul3o[IO0ojfG`0So00001?n/U;d00ol0003o
Y8noojB?_`03ojB?_`Co00001_nTS[d00ol0003oVhW0oi^9`002oi^9`0;o0000<_ooool4o`0001oo
oooo001Nooooo`03o`000?oooooooooo01Wooooo1?l000000oo9[koo0000ol>W_@06ol>W_@?o0000
1_o2Ykh00ol0003o^j2mok^P_@0:ok^P_AOo00003?n/U;d00ol0003oY8noo`000003o`0000_oY8jm
1?l0000`ooooo`Co00008oooool005oooooo00?o0000ooooooooool06Oooool01?l0003ooooooooo
ool0000;ol>W_@Co000000?o`ZNno`000?nkX;d03onkX;d00ol0003o]9ZmokBJ_@0=okBJ_@03o`00
0?n/U;go[9Bm00Wo[9Bm1_l0000=ojB>_@?o0000<?ooool3o`0002Oooooo001Pooooo`03o`000?oo
oooooooo01Wooooo00?o0000ooooooooool00_ooool4o`0000Wo`jNm0_l00003ok^P_@Ko00001onk
X;d00ol0003o]9ZmokBJ_@0=okBJ_@04o`000?n/U;go[9BmojbD_@So00001?n/Tk`00ol0003oY8jm
ojB>_@08ojB>_@Co0000;oooool4o`0002[ooooo001Qooooo`;o00006_ooool00ol0003ooooooooo
o`05ooooo`Co00001_o3Ykd00ol0003o^inlok^O_007ok^O_1_o00003?n/Tk`00ol0003oY8jmojB>
_@04ojB>_@Co0000;oooool4o`0002kooooo001Sooooo`03o`000?oooooooooo01Sooooo00?o0000
ooooooooool02?ooool4o`000003ol>W_Ol0003o^inl013o^inl00?o0000okBI_?ndVK`03OndVK`0
0ol0003o[9>lojbC_00>ojbC_003o`000?nTS[go000000?o0000<?ooool3o`0003;ooooo001Toooo
o`03o`000?oooooooooo01Sooooo0_l0000<ooooo`;o00004OnkWk`00ol0003o]9VlokBI_00=okBI
_003o`000?n/Tkco[9>l00[o[9>l1_l0000`ooooo`Co0000=Oooool006Gooooo00?o0000oooooooo
ool06Oooool00ol0003oooooooooo`0?ooooo`Wo00000onkWk`00ol0003o]9VlokBI_00>okBI_004
o`000?n/Tkco[9>lojbC_0Wo0000<_ooool4o`0003Wooooo001Vooooo`03o`000?oooooooooo01Wo
oooo00?o0000ooooooooool05_oooolIo`0003Sooooo0ol0000mooooo`00Ioooool2o`0001[ooooo
00?o0000ooooooooool04_ooool3o`0004gooooo1?l00010ooooo`00JOooool00ol0003ooooooooo
o`0Hooooo`03o`000?oooooooooo00gooooo1?l0001<ooooo`Co0000A?ooool006[ooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`09ooooo`?o0000COooool3o`0004Sooooo001[oooo
o`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01?ooool4o`0004cooooo1?l0001;oooo
o`00K?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00?o0000C?ooool4o`0004oo
oooo001]ooooo`;o00006Oooool2o`0004cooooo0ol0001Cooooo`00Koooool00ol0003ooooooooo
o`0Fooooo`03o`000?oooooooooo04Oooooo1?l0001Fooooo`00L?ooool00ol0003oooooooooo`0E
ooooo`03o`000?oooooooooo04?ooooo1?l0001Jooooo`00LOooool00ol0003oooooooooo`0Doooo
o`03o`000?oooooooooo043ooooo0ol0001Nooooo`00L_ooool00ol0003oooooooooo`0Cooooo`03
o`000?oooooooooo03cooooo1?l0001Qooooo`00Loooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo03Sooooo1?l0001Uooooo`00M?ooool2o`0001;ooooo00?o0000ooooooooool0=Ooo
ool3o`0006Wooooo001fooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0<Oooool4
o`0006cooooo001gooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0;Oooool4o`00
073ooooo001hooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0:_ooool3o`0007Co
oooo001iooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool09_ooool4o`0007Oooooo
001jooooo`;o00003?ooool00ol0003oooooooooo`0Rooooo`Co0000Noooool007cooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`0Pooooo`?o0000Ooooool007gooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0Looooo`Co0000P_ooool007kooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`0Hooooo`Co0000Q_ooool007oooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Eooooo`?o0000R_ooool0083ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Aooooo`Co0000SOooool0087ooooo0_l00004ooooo`03o`000?oooooo
oooo00gooooo1?l0002Aooooo`00Poooool01Ol0003ooooooooooooooooo000000cooooo0ol0002E
ooooo`00Q?ooool01?l0003oooooooooool00008ooooo`Co0000V?ooool008Gooooo00?o0000oooo
ool000001?ooool4o`0009cooooo0026ooooo`;o000000Coooooo`000?l0003o0000X?ooool008Oo
oooo0_l0002Sooooo`00\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {-0.12676, 0.112062, 0.00373372, \
0.00373372}},
  CellTags->"S5.44.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.44.1"]
}, Open  ]],

Cell[TextData[{
 "Any options you give are passed directly to the built\[Hyphen]in ",
 StyleBox["ParametricPlot3D", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.44.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
SurfaceOfRevolution[ Sin[x], {x, 0, 2 Pi},
       ViewVertical -> {1, 0, 0},
       Ticks -> {Automatic, Automatic,
    {-1., 0, 1.}}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.44.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.54568 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.368955 1.64154 3.32308e-17 1.64154 [
[.96043 .19348 0 -6.99029 ]
[.96043 .19348 12 2.00971 ]
[.98447 .63812 0 -6.5084 ]
[.98447 .63812 6 2.4916 ]
[1.01078 1.1272 0 -5.98459 ]
[1.01078 1.1272 6 3.01541 ]
[.87732 1.35594 -5.75691 0 ]
[.87732 1.35594 6.24309 9 ]
[.53025 1.45661 -2.97781 0 ]
[.53025 1.45661 3.02219 9 ]
[.23645 1.54181 -3.06045 0 ]
[.23645 1.54181 2.93955 9 ]
[.93132 .05117 -6.31279 -9 ]
[.93132 .05117 5.68721 0 ]
[.86308 .01669 -3.13464 -9 ]
[.86308 .01669 2.86536 0 ]
[.79291 -0.01876 -3.11211 -9 ]
[.79291 -0.01876 2.88789 0 ]
[ 0 0 0 0 ]
[ 1 1.54568 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.93565 .07331 m
1 1.29954 L
s
.94248 .20342 m
.9335 .20839 L
s
[(-5)] .96043 .19348 -1 .5534 Mshowa
.96573 .64648 m
.95636 .65067 L
s
[(0)] .98447 .63812 -1 .44631 Mshowa
.99129 1.13363 m
.98155 1.13685 L
s
[(5)] 1.01078 1.1272 -1 .32991 Mshowa
.125 Mabswid
.94696 .28879 m
.94153 .29169 L
s
.95152 .37574 m
.94604 .37855 L
s
.95617 .46431 m
.95064 .46702 L
s
.9609 .55454 m
.95533 .55715 L
s
.97065 .74018 m
.96498 .74259 L
s
.97566 .8357 m
.96994 .83799 L
s
.98077 .93307 m
.97501 .93524 L
s
.98598 1.03236 m
.98018 1.03442 L
s
.93808 .11957 m
.93274 .12264 L
s
.99671 1.23693 m
.99083 1.23873 L
s
.25 Mabswid
1 1.29954 m
.15294 1.54568 L
s
.87649 1.33543 m
.87607 1.32518 L
s
[(-5)] .87732 1.35594 -0.04051 -1 Mshowa
.5301 1.43609 m
.53002 1.42583 L
s
[(0)] .53025 1.45661 -0.0074 -1 Mshowa
.23686 1.5213 m
.23707 1.51104 L
s
[(5)] .23645 1.54181 .02015 -1 Mshowa
.125 Mabswid
.80228 1.357 m
.80207 1.35084 L
s
.73066 1.37781 m
.7305 1.37165 L
s
.66151 1.3979 m
.66139 1.39175 L
s
.59469 1.41732 m
.59461 1.41116 L
s
.46762 1.45424 m
.46761 1.44809 L
s
.40714 1.47182 m
.40717 1.46566 L
s
.34859 1.48883 m
.34865 1.48268 L
s
.29185 1.50532 m
.29195 1.49916 L
s
.95344 1.31307 m
.95314 1.30692 L
s
.18353 1.53679 m
.18369 1.53064 L
s
.25 Mabswid
.93565 .07331 m
.79022 0 L
s
.93238 .07166 m
.93292 .0819 L
s
[(-1)] .93132 .05117 .05213 1 Mshowa
.864 .03719 m
.86446 .04744 L
s
[(0)] .86308 .01669 .04488 1 Mshowa
.79367 .00174 m
.79406 .012 L
s
[(1)] .79291 -0.01876 .03737 1 Mshowa
.93565 .07331 m
.79022 0 L
s
.79022 0 m
.04464 .46515 L
s
.04464 .46515 m
.18177 .51438 L
s
.18177 .51438 m
.93565 .07331 L
s
1 1.29954 m
.15294 1.54568 L
s
.15294 1.54568 m
0 1.51878 L
s
0 1.51878 m
.83674 1.2575 L
s
.83674 1.2575 m
1 1.29954 L
s
.93565 .07331 m
.79022 0 L
s
.79022 0 m
.83674 1.2575 L
s
.83674 1.2575 m
1 1.29954 L
s
1 1.29954 m
.93565 .07331 L
s
.18177 .51438 m
.15294 1.54568 L
s
.15294 1.54568 m
0 1.51878 L
s
0 1.51878 m
.04464 .46515 L
s
.04464 .46515 m
.18177 .51438 L
s
0 0 m
1 0 L
1 1.54568 L
0 1.54568 L
closepath
clip
newpath
.5 Mabswid
.667 .559 .723 r
.19676 .68482 m .1736 .67557 L .2196 .57286 L p F P
0 g
s
.679 .546 .696 r
.1736 .67557 m .19676 .68482 L .1638 .78949 L p F P
0 g
s
.679 .546 .696 r
.1638 .78949 m .13949 .78387 L .1736 .67557 L p F P
0 g
s
.685 .527 .667 r
.13949 .78387 m .1638 .78949 L .14353 .89614 L p F P
0 g
s
.685 .527 .667 r
.14353 .89614 m .1184 .89423 L .13949 .78387 L p F P
0 g
s
.667 .559 .723 r
.2196 .57286 m .24131 .58561 L .19676 .68482 L p F P
0 g
s
.663 .554 .721 r
.21928 .69386 m .19676 .68482 L .24131 .58561 L p F P
0 g
s
.674 .541 .695 r
.19676 .68482 m .21928 .69386 L .18747 .7949 L p F P
0 g
s
.674 .541 .695 r
.18747 .7949 m .1638 .78949 L .19676 .68482 L p F P
0 g
s
.68 .523 .666 r
.1638 .78949 m .18747 .7949 L .16802 .89786 L p F P
0 g
s
.68 .523 .666 r
.16802 .89786 m .14353 .89614 L .1638 .78949 L p F P
0 g
s
.663 .554 .721 r
.24131 .58561 m .26237 .59815 L .21928 .69386 L p F P
0 g
s
.653 .542 .716 r
.24054 .70249 m .21928 .69386 L .26237 .59815 L p F P
0 g
s
.664 .53 .691 r
.21928 .69386 m .24054 .70249 L .20987 .79992 L p F P
0 g
s
.664 .53 .691 r
.20987 .79992 m .18747 .7949 L .21928 .69386 L p F P
0 g
s
.669 .512 .663 r
.18747 .7949 m .20987 .79992 L .19121 .8992 L p F P
0 g
s
.669 .512 .663 r
.19121 .8992 m .16802 .89786 L .18747 .7949 L p F P
0 g
s
.653 .542 .716 r
.26237 .59815 m .28217 .61025 L .24054 .70249 L p F P
0 g
s
.636 .523 .708 r
.25996 .71052 m .24054 .70249 L .28217 .61025 L p F P
0 g
s
.647 .512 .685 r
.24054 .70249 m .25996 .71052 L .23042 .80435 L p F P
0 g
s
.647 .512 .685 r
.23042 .80435 m .20987 .79992 L .24054 .70249 L p F P
0 g
s
.652 .495 .659 r
.20987 .79992 m .23042 .80435 L .21255 .89998 L p F P
0 g
s
.652 .495 .659 r
.21255 .89998 m .19121 .8992 L .20987 .79992 L p F P
0 g
s
.649 .566 .748 r
.24131 .58561 m .2196 .57286 L .27612 .47921 L p F P
0 g
s
.636 .523 .708 r
.28217 .61025 m .30013 .62173 L .25996 .71052 L p F P
0 g
s
.61 .493 .695 r
.27707 .7178 m .25996 .71052 L .30013 .62173 L p F P
0 g
s
.619 .483 .674 r
.25996 .71052 m .27707 .7178 L .24866 .80806 L p F P
0 g
s
.619 .483 .674 r
.24866 .80806 m .23042 .80435 L .25996 .71052 L p F P
0 g
s
.623 .468 .652 r
.23042 .80435 m .24866 .80806 L .23154 .90005 L p F P
0 g
s
.623 .468 .652 r
.23154 .90005 m .21255 .89998 L .23042 .80435 L p F P
0 g
s
.685 .502 .634 r
.1184 .89423 m .14353 .89614 L .13682 1.00122 L p F P
0 g
s
.685 .502 .634 r
.13682 1.00122 m .11121 1.00299 L .1184 .89423 L p F P
0 g
s
.649 .566 .748 r
.27612 .47921 m .2961 .49526 L .24131 .58561 L p F P
0 g
s
.645 .561 .745 r
.26237 .59815 m .24131 .58561 L .2961 .49526 L p F P
0 g
s
.68 .498 .633 r
.14353 .89614 m .16802 .89786 L .16176 .99926 L p F P
0 g
s
.68 .498 .633 r
.16176 .99926 m .13682 1.00122 L .14353 .89614 L p F P
0 g
s
.645 .561 .745 r
.2961 .49526 m .31542 .51108 L .26237 .59815 L p F P
0 g
s
.636 .548 .739 r
.28217 .61025 m .26237 .59815 L .31542 .51108 L p F P
0 g
s
.669 .488 .632 r
.16802 .89786 m .19121 .8992 L .18538 .99693 L p F P
0 g
s
.669 .488 .632 r
.18538 .99693 m .16176 .99926 L .16802 .89786 L p F P
0 g
s
.61 .493 .695 r
.30013 .62173 m .31577 .63242 L .27707 .7178 L p F P
0 g
s
.568 .445 .672 r
.29149 .7242 m .27707 .7178 L .31577 .63242 L p F P
0 g
s
.575 .438 .656 r
.27707 .7178 m .29149 .7242 L .2642 .81093 L p F P
0 g
s
.575 .438 .656 r
.2642 .81093 m .24866 .80806 L .27707 .7178 L p F P
0 g
s
.578 .426 .639 r
.24866 .80806 m .2642 .81093 L .24782 .89931 L p F P
0 g
s
.578 .426 .639 r
.24782 .89931 m .23154 .90005 L .24866 .80806 L p F P
0 g
s
.636 .548 .739 r
.31542 .51108 m .33346 .52644 L .28217 .61025 L p F P
0 g
s
.62 .528 .729 r
.30013 .62173 m .28217 .61025 L .33346 .52644 L p F P
0 g
s
.651 .473 .63 r
.19121 .8992 m .21255 .89998 L .20711 .99407 L p F P
0 g
s
.651 .473 .63 r
.20711 .99407 m .18538 .99693 L .19121 .8992 L p F P
0 g
s
.62 .528 .729 r
.33346 .52644 m .34965 .54114 L .30013 .62173 L p F P
0 g
s
.595 .496 .712 r
.31577 .63242 m .30013 .62173 L .34965 .54114 L p F P
0 g
s
.621 .448 .626 r
.21255 .89998 m .23154 .90005 L .22647 .99053 L p F P
0 g
s
.621 .448 .626 r
.22647 .99053 m .20711 .99407 L .21255 .89998 L p F P
0 g
s
.568 .445 .672 r
.31577 .63242 m .32872 .6422 L .29149 .7242 L p F P
0 g
s
.499 .367 .632 r
.30298 .72965 m .29149 .7242 L .32872 .6422 L p F P
0 g
s
.503 .363 .624 r
.29149 .7242 m .30298 .72965 L .27679 .81286 L p F P
0 g
s
.503 .363 .624 r
.27679 .81286 m .2642 .81093 L .29149 .7242 L p F P
0 g
s
.504 .357 .614 r
.2642 .81093 m .27679 .81286 L .26113 .89766 L p F P
0 g
s
.504 .357 .614 r
.26113 .89766 m .24782 .89931 L .2642 .81093 L p F P
0 g
s
.595 .496 .712 r
.34965 .54114 m .3635 .55501 L .31577 .63242 L p F P
0 g
s
.555 .446 .685 r
.32872 .6422 m .31577 .63242 L .3635 .55501 L p F P
0 g
s
.576 .409 .619 r
.23154 .90005 m .24782 .89931 L .24307 .98619 L p F P
0 g
s
.576 .409 .619 r
.24307 .98619 m .22647 .99053 L .23154 .90005 L p F P
0 g
s
.499 .367 .632 r
.32872 .6422 m .33874 .651 L .30298 .72965 L p F P
0 g
s
.378 .235 .557 r
.31142 .73411 m .30298 .72965 L .33874 .651 L p F P
0 g
s
.376 .236 .561 r
.30298 .72965 m .31142 .73411 L .28633 .81383 L p F P
0 g
s
.376 .236 .561 r
.28633 .81383 m .27679 .81286 L .30298 .72965 L p F P
0 g
s
.376 .24 .565 r
.27679 .81286 m .28633 .81383 L .27136 .89507 L p F P
0 g
s
.376 .24 .565 r
.27136 .89507 m .26113 .89766 L .27679 .81286 L p F P
0 g
s
.555 .446 .685 r
.3635 .55501 m .37466 .56793 L .32872 .6422 L p F P
0 g
s
.491 .367 .638 r
.33874 .651 m .32872 .6422 L .37466 .56793 L p F P
0 g
s
.502 .347 .603 r
.24782 .89931 m .26113 .89766 L .25667 .98097 L p F P
0 g
s
.502 .347 .603 r
.25667 .98097 m .24307 .98619 L .24782 .89931 L p F P
0 g
s
.625 .567 .77 r
.2961 .49526 m .27612 .47921 L .34153 .3981 L p F P
0 g
s
.625 .567 .77 r
.34153 .3981 m .35951 .41715 L .2961 .49526 L p F P
0 g
s
.62 .561 .766 r
.31542 .51108 m .2961 .49526 L .35951 .41715 L p F P
0 g
s
.678 .469 .596 r
.11121 1.00299 m .13682 1.00122 L .14427 1.10102 L p F P
0 g
s
.678 .469 .596 r
.14427 1.10102 m .11857 1.10638 L .11121 1.00299 L p F P
0 g
s
.62 .561 .766 r
.35951 .41715 m .37682 .43595 L .31542 .51108 L p F P
0 g
s
.612 .548 .759 r
.33346 .52644 m .31542 .51108 L .37682 .43595 L p F P
0 g
s
.673 .465 .596 r
.13682 1.00122 m .16176 .99926 L .16927 1.09548 L p F P
0 g
s
.673 .465 .596 r
.16927 1.09548 m .14427 1.10102 L .13682 1.00122 L p F P
0 g
s
.612 .548 .759 r
.37682 .43595 m .39283 .45425 L .33346 .52644 L p F P
0 g
s
.597 .527 .747 r
.34965 .54114 m .33346 .52644 L .39283 .45425 L p F P
0 g
s
.662 .457 .596 r
.16176 .99926 m .18538 .99693 L .19291 1.08959 L p F P
0 g
s
.662 .457 .596 r
.19291 1.08959 m .16927 1.09548 L .16176 .99926 L p F P
0 g
s
.491 .367 .638 r
.37466 .56793 m .38287 .57983 L .33874 .651 L p F P
0 g
s
.382 .236 .555 r
.3457 .65878 m .33874 .651 L .38287 .57983 L p F P
0 g
s
.378 .235 .557 r
.33874 .651 m .3457 .65878 L .31142 .73411 L p F P
0 g
s
.163 .007 .409 r
.31682 .73758 m .31142 .73411 L .3457 .65878 L p F P
0 g
s
.147 .014 .429 r
.31142 .73411 m .31682 .73758 L .29283 .81384 L p F P
0 g
s
.147 .014 .429 r
.29283 .81384 m .28633 .81383 L .31142 .73411 L p F P
0 g
s
.643 .443 .597 r
.18538 .99693 m .20711 .99407 L .21462 1.08319 L p F P
0 g
s
.643 .443 .597 r
.21462 1.08319 m .19291 1.08959 L .18538 .99693 L p F P
0 g
s
.148 .036 .458 r
.28633 .81383 m .29283 .81384 L .27853 .89152 L p F P
0 g
s
.148 .036 .458 r
.27853 .89152 m .27136 .89507 L .28633 .81383 L p F P
0 g
s
.378 .244 .57 r
.26113 .89766 m .27136 .89507 L .26716 .97482 L p F P
0 g
s
.378 .244 .57 r
.26716 .97482 m .25667 .98097 L .26113 .89766 L p F P
0 g
s
.597 .527 .747 r
.39283 .45425 m .40696 .47185 L .34965 .54114 L p F P
0 g
s
.574 .494 .727 r
.3635 .55501 m .34965 .54114 L .40696 .47185 L p F P
0 g
s
.614 .421 .597 r
.20711 .99407 m .22647 .99053 L .2339 1.07614 L p F P
0 g
s
.614 .421 .597 r
.2339 1.07614 m .21462 1.08319 L .20711 .99407 L p F P
0 g
s
.574 .494 .727 r
.40696 .47185 m .41875 .48857 L .3635 .55501 L p F P
0 g
s
.538 .443 .695 r
.37466 .56793 m .3635 .55501 L .41875 .48857 L p F P
0 g
s
.568 .387 .596 r
.22647 .99053 m .24307 .98619 L .25039 1.06832 L p F P
0 g
s
.568 .387 .596 r
.25039 1.06832 m .2339 1.07614 L .22647 .99053 L p F P
0 g
s
.382 .236 .555 r
.38287 .57983 m .38801 .59068 L .3457 .65878 L p F P
0 g
s
.192 .017 .4 r
.34962 .66556 m .3457 .65878 L .38801 .59068 L p F P
0 g
s
.163 .007 .409 r
.3457 .65878 m .34962 .66556 L .31682 .73758 L p F P
0 g
s
.165 .071 .494 r
.27136 .89507 m .27853 .89152 L .27457 .96775 L p F P
0 g
s
.165 .071 .494 r
.27457 .96775 m .26716 .97482 L .27136 .89507 L p F P
0 g
s
.538 .443 .695 r
.41875 .48857 m .42781 .50429 L .37466 .56793 L p F P
0 g
s
.481 .364 .643 r
.38287 .57983 m .37466 .56793 L .42781 .50429 L p F P
0 g
s
0 0 .133 r
.31934 .74013 m .31682 .73758 L .34962 .66556 L p F P
0 g
s
0 0 .172 r
.31682 .73758 m .31934 .74013 L .29643 .81292 L p F P
0 g
s
0 0 .172 r
.29643 .81292 m .29283 .81384 L .31682 .73758 L p F P
0 g
s
0 0 .243 r
.29283 .81384 m .29643 .81292 L .2828 .88706 L p F P
0 g
s
0 0 .243 r
.2828 .88706 m .27853 .89152 L .29283 .81384 L p F P
0 g
s
.496 .334 .591 r
.24307 .98619 m .25667 .98097 L .26383 1.05964 L p F P
0 g
s
.496 .334 .591 r
.26383 1.05964 m .25039 1.06832 L .24307 .98619 L p F P
0 g
s
.481 .364 .643 r
.42781 .50429 m .43391 .51895 L .38287 .57983 L p F P
0 g
s
.387 .238 .554 r
.38801 .59068 m .38287 .57983 L .43391 .51895 L p F P
0 g
s
.192 .017 .4 r
.38801 .59068 m .3901 .6005 L .34962 .66556 L p F P
0 g
s
0 0 .129 r
.35065 .6714 m .34962 .66556 L .3901 .6005 L p F P
0 g
s
0 0 .133 r
.34962 .66556 m .35065 .6714 L .31934 .74013 L p F P
0 g
s
.381 .25 .575 r
.25667 .98097 m .26716 .97482 L .27412 1.05007 L p F P
0 g
s
.381 .25 .575 r
.27412 1.05007 m .26383 1.05964 L .25667 .98097 L p F P
0 g
s
0 0 .336 r
.27853 .89152 m .2828 .88706 L .27905 .95977 L p F P
0 g
s
0 0 .336 r
.27905 .95977 m .27457 .96775 L .27853 .89152 L p F P
0 g
s
0 0 0 r
.31926 .74185 m .31934 .74013 L .35065 .6714 L p F P
0 g
s
0 0 0 r
.34908 .6764 m .31926 .74185 L p .34496 .68417 L F P
0 g
s
0 0 0 r
.35065 .6714 m .34908 .6764 L p .34496 .68417 L F P
0 g
s
0 0 0 r
.34908 .6764 m .35065 .6714 L .38928 .60935 L p F P
0 g
s
0 0 0 r
.38584 .61736 m .34908 .6764 L p .38197 .62154 L F P
0 g
s
0 0 0 r
.38928 .60935 m .38584 .61736 L p .38197 .62154 L F P
0 g
s
0 0 0 r
.38584 .61736 m .42824 .56713 L p .39046 .61237 L F P
0 g
s
.684 .867 .472 r
.34908 .6764 m .38584 .61736 L p .35399 .66713 L F P
0 g
s
.684 .867 .472 r
.38018 .62468 m .3453 .68071 L p .38041 .62584 L F P
0 g
s
.684 .867 .472 r
.38584 .61736 m .38018 .62468 L p .38041 .62584 L F P
0 g
s
0 0 0 r
.38018 .62468 m .38584 .61736 L p .39046 .61237 L F P
0 g
s
0 0 .129 r
.3901 .6005 m .38928 .60935 L .35065 .6714 L p F P
0 g
s
0 0 0 r
.38584 .61736 m .38928 .60935 L .43387 .5565 L p F P
0 g
s
0 0 0 r
.43387 .5565 m .42824 .56713 L .38584 .61736 L p F P
0 g
s
0 0 0 r
.42037 .57707 m .38018 .62468 L p .42179 .57486 L F P
0 g
s
0 0 0 r
.42824 .56713 m .42037 .57707 L p .42179 .57486 L F P
0 g
s
0 0 0 r
.42037 .57707 m .46438 .54001 L p .41877 .57957 L F P
0 g
s
.631 .893 .571 r
.38018 .62468 m .42037 .57707 L p .37992 .62336 L F P
0 g
s
.631 .893 .571 r
.41078 .58651 m .37281 .63149 L p .41626 .58178 L F P
0 g
s
.631 .893 .571 r
.42037 .57707 m .41078 .58651 L p .41626 .58178 L F P
0 g
s
.688 .938 .646 r
.36433 .63803 m .37281 .63149 L .41078 .58651 L p F P
0 g
s
0 0 .156 r
.38928 .60935 m .3901 .6005 L .43685 .545 L p F P
0 g
s
0 0 .156 r
.43685 .545 m .43387 .5565 L .38928 .60935 L p F P
0 g
s
.688 .938 .646 r
.40005 .59567 m .36433 .63803 L p .40928 .58817 L F P
0 g
s
.688 .938 .646 r
.41078 .58651 m .40005 .59567 L p .40928 .58817 L F P
0 g
s
0 0 0 r
.41078 .58651 m .4523 .55156 L p .40485 .59162 L F P
0 g
s
0 0 0 r
.40005 .59567 m .41078 .58651 L p .40485 .59162 L F P
0 g
s
0 0 0 r
.41078 .58651 m .42037 .57707 L p .41877 .57957 L F P
0 g
s
0 0 0 r
.46438 .54001 m .4523 .55156 L .41078 .58651 L p F P
0 g
s
0 0 0 r
.43906 .56284 m .40005 .59567 L p .4506 .55299 L F P
0 g
s
0 0 0 r
.4523 .55156 m .43906 .56284 L p .4506 .55299 L F P
0 g
s
0 0 0 r
.43906 .56284 m .4798 .54118 L p .42714 .57302 L F P
0 g
s
.469 .826 .559 r
.40005 .59567 m .43906 .56284 L p .39051 .60343 L F P
0 g
s
.469 .826 .559 r
.43906 .56284 m .42535 .5741 L .38886 .60482 L p F P
0 g
s
0 0 0 r
.42535 .5741 m .43906 .56284 L p .42714 .57302 L F P
0 g
s
.469 .826 .559 r
.38886 .60482 m .40005 .59567 L p .39051 .60343 L F P
0 g
s
.631 .893 .571 r
.37281 .63149 m .38018 .62468 L p .37992 .62336 L F P
0 g
s
.684 .867 .472 r
.3453 .68071 m .34908 .6764 L p .35399 .66713 L F P
0 g
s
.792 .885 .462 r
.31926 .74185 m .34908 .6764 L p .32388 .72858 L F P
0 g
s
0 0 0 r
.31934 .74013 m .31926 .74185 L p .31538 .75298 L F P
0 g
s
0 0 0 r
.29744 .81118 m .29643 .81292 L .30125 .79762 L p F P
0 g
s
0 0 0 r
.30125 .79762 m .31934 .74013 L p .29744 .81118 L F P
0 g
s
0 0 0 r
.29643 .81292 m .29744 .81118 L .28447 .88177 L p F P
0 g
s
0 0 0 r
.28447 .88177 m .2828 .88706 L .28568 .87143 L p F P
0 g
s
0 0 0 r
.28568 .87143 m .29643 .81292 L p .28447 .88177 L F P
0 g
s
0 0 .099 r
.2828 .88706 m .28447 .88177 L .2809 .95095 L p F P
0 g
s
.786 .665 .112 r
.28447 .88177 m .28393 .87576 L .28296 .89465 L p F P
0 g
s
0 0 .099 r
.2809 .95095 m .27905 .95977 L .27984 .9444 L p F P
0 g
s
0 0 .099 r
.27984 .9444 m .2828 .88706 L p .2809 .95095 L F P
0 g
s
.786 .665 .112 r
.28054 .9414 m .2809 .95095 L .28142 .9408 L p F P
0 g
s
.786 .665 .112 r
.28142 .9408 m .28447 .88177 L p .28054 .9414 L F P
0 g
s
.79 .579 .013 r
.28054 .9414 m .2785 .93127 L .27953 .9421 L p F P
0 g
s
0 0 .11 r
.2809 .95095 m .28054 .9414 L .28222 .95911 L p F P
0 g
s
0 0 .11 r
.28222 .95911 m .28639 1.00305 L p .2809 .95095 L F P
0 g
s
0 0 .279 r
.27905 .95977 m .2809 .95095 L .28706 1.01599 L p F P
0 g
s
0 0 .11 r
.28639 1.00305 m .28706 1.01599 L .28615 1.00643 L p F P
0 g
s
0 0 .11 r
.28615 1.00643 m .2809 .95095 L p .28639 1.00305 L F P
0 g
s
.79 .579 .013 r
.28401 .98951 m .28639 1.00305 L .28586 .99752 L p F P
0 g
s
.79 .579 .013 r
.28586 .99752 m .28054 .9414 L p .28401 .98951 L F P
0 g
s
0 0 .279 r
.28706 1.01599 m .2855 1.0282 L .27905 .95977 L p F P
0 g
s
.851 .62 .079 r
.28056 .97553 m .28401 .98951 L .28384 .98767 L p F P
0 g
s
.851 .62 .079 r
.28384 .98767 m .2785 .93127 L p .28056 .97553 L F P
0 g
s
0 0 .437 r
.27457 .96775 m .27905 .95977 L .2855 1.0282 L p F P
0 g
s
.867 .631 .1 r
.27672 .96129 m .28056 .97553 L .27539 .92071 L p F P
0 g
s
0 0 .19 r
.28056 .97553 m .27672 .96129 L .27717 .96295 L p F P
0 g
s
.79 .579 .013 r
.27953 .9421 m .28401 .98951 L p .28054 .9414 L F P
0 g
s
.851 .62 .079 r
.2785 .93127 m .27539 .92071 L .28056 .97553 L p F P
0 g
s
0 0 .19 r
.27717 .96295 m .28921 1.00692 L p .28056 .97553 L F P
0 g
s
0 0 .208 r
.28401 .98951 m .28056 .97553 L .282 .98077 L p F P
0 g
s
0 0 .208 r
.282 .98077 m .29393 1.0243 L p .28401 .98951 L F P
0 g
s
0 0 .264 r
.28639 1.00305 m .28401 .98951 L .28665 .99915 L p F P
0 g
s
0 0 .264 r
.28665 .99915 m .29824 1.04143 L p .28639 1.00305 L F P
0 g
s
.786 .665 .112 r
.28296 .89465 m .28054 .9414 L p .28447 .88177 L F P
0 g
s
.844 .784 .282 r
.29744 .81118 m .29626 .80872 L .29271 .82805 L p F P
0 g
s
.844 .784 .282 r
.29271 .82805 m .28393 .87576 L p .29744 .81118 L F P
0 g
s
.792 .885 .462 r
.31698 .74286 m .31926 .74185 L p .32388 .72858 L F P
0 g
s
0 0 0 r
.31926 .74185 m .29744 .81118 L p .31538 .75298 L F P
0 g
s
.387 .238 .554 r
.43391 .51895 m .43692 .53251 L .38801 .59068 L p F P
0 g
s
.232 .04 .401 r
.3901 .6005 m .38801 .59068 L .43692 .53251 L p F P
0 g
s
.194 .115 .533 r
.26716 .97482 m .27457 .96775 L .28129 1.03958 L p F P
0 g
s
.194 .115 .533 r
.28129 1.03958 m .27412 1.05007 L .26716 .97482 L p F P
0 g
s
.59 .56 .789 r
.35951 .41715 m .34153 .3981 L .41382 .33294 L p F P
0 g
s
.59 .56 .789 r
.41382 .33294 m .42957 .3546 L .35951 .41715 L p F P
0 g
s
.587 .554 .785 r
.37682 .43595 m .35951 .41715 L .42957 .3546 L p F P
0 g
s
.587 .554 .785 r
.42957 .3546 m .44463 .37597 L .37682 .43595 L p F P
0 g
s
.579 .541 .776 r
.39283 .45425 m .37682 .43595 L .44463 .37597 L p F P
0 g
s
.579 .541 .776 r
.44463 .37597 m .45836 .39679 L .39283 .45425 L p F P
0 g
s
.566 .518 .761 r
.40696 .47185 m .39283 .45425 L .45836 .39679 L p F P
0 g
s
.664 .426 .551 r
.11857 1.10638 m .14427 1.10102 L .16618 1.19169 L p F P
0 g
s
.658 .423 .552 r
.14427 1.10102 m .16927 1.09548 L .1908 1.18277 L p F P
0 g
s
.658 .423 .552 r
.1908 1.18277 m .16618 1.19169 L .14427 1.10102 L p F P
0 g
s
.566 .518 .761 r
.45836 .39679 m .4702 .41685 L .40696 .47185 L p F P
0 g
s
.546 .484 .738 r
.41875 .48857 m .40696 .47185 L .4702 .41685 L p F P
0 g
s
.664 .426 .551 r
.16618 1.19169 m .14082 1.20044 L .11857 1.10638 L p F P
0 g
s
.647 .416 .555 r
.16927 1.09548 m .19291 1.08959 L .21402 1.17353 L p F P
0 g
s
.647 .416 .555 r
.21402 1.17353 m .1908 1.18277 L .16927 1.09548 L p F P
0 g
s
.628 .405 .559 r
.19291 1.08959 m .21462 1.08319 L .23525 1.16381 L p F P
0 g
s
.628 .405 .559 r
.23525 1.16381 m .21402 1.17353 L .19291 1.08959 L p F P
0 g
s
.599 .387 .565 r
.21462 1.08319 m .2339 1.07614 L .254 1.15347 L p F P
0 g
s
.599 .387 .565 r
.254 1.15347 m .23525 1.16381 L .21462 1.08319 L p F P
0 g
s
.546 .484 .738 r
.4702 .41685 m .47966 .43598 L .41875 .48857 L p F P
0 g
s
.515 .433 .702 r
.42781 .50429 m .41875 .48857 L .47966 .43598 L p F P
0 g
s
.232 .04 .401 r
.43692 .53251 m .43685 .545 L .3901 .6005 L p F P
0 g
s
.554 .36 .572 r
.2339 1.07614 m .25039 1.06832 L .2699 1.14239 L p F P
0 g
s
.554 .36 .572 r
.2699 1.14239 m .254 1.15347 L .2339 1.07614 L p F P
0 g
s
.843 .854 .398 r
.31926 .74185 m .31698 .74286 L .29626 .80872 L p F P
0 g
s
.843 .854 .398 r
.29626 .80872 m .29744 .81118 L .31926 .74185 L p F P
0 g
s
.844 .784 .282 r
.28393 .87576 m .28447 .88177 L .29744 .81118 L p F P
0 g
s
0 0 .437 r
.2855 1.0282 m .28129 1.03958 L .27457 .96775 L p F P
0 g
s
.515 .433 .702 r
.47966 .43598 m .48637 .45406 L .42781 .50429 L p F P
0 g
s
.467 .357 .645 r
.43391 .51895 m .42781 .50429 L .48637 .45406 L p F P
0 g
s
.487 .319 .578 r
.25039 1.06832 m .26383 1.05964 L .28271 1.1305 L p F P
0 g
s
.487 .319 .578 r
.28271 1.1305 m .2699 1.14239 L .25039 1.06832 L p F P
0 g
s
.467 .357 .645 r
.48637 .45406 m .4901 .47101 L .43391 .51895 L p F P
0 g
s
.393 .242 .554 r
.43692 .53251 m .43391 .51895 L .4901 .47101 L p F P
0 g
s
.792 .885 .462 r
.34908 .6764 m .3453 .68071 L .31698 .74286 L p F P
0 g
s
.386 .257 .581 r
.26383 1.05964 m .27412 1.05007 L .29231 1.11773 L p F P
0 g
s
.386 .257 .581 r
.29231 1.11773 m .28271 1.1305 L .26383 1.05964 L p F P
0 g
s
.393 .242 .554 r
.4901 .47101 m .49071 .48682 L .43692 .53251 L p F P
0 g
s
.279 .074 .412 r
.43685 .545 m .43692 .53251 L .49071 .48682 L p F P
0 g
s
.88 .945 .584 r
.31302 .74335 m .31698 .74286 L .3453 .68071 L p F P
0 g
s
.925 .909 .515 r
.31698 .74286 m .31302 .74335 L .2934 .80571 L p F P
0 g
s
.925 .909 .515 r
.2934 .80571 m .29626 .80872 L .31698 .74286 L p F P
0 g
s
.934 .845 .403 r
.29626 .80872 m .2934 .80571 L .28172 .86917 L p F P
0 g
s
.934 .845 .403 r
.28172 .86917 m .28393 .87576 L .29626 .80872 L p F P
0 g
s
.233 .164 .57 r
.27412 1.05007 m .28129 1.03958 L .29875 1.10407 L p F P
0 g
s
.233 .164 .57 r
.29875 1.10407 m .29231 1.11773 L .27412 1.05007 L p F P
0 g
s
.79 .949 .609 r
.33982 .68451 m .3453 .68071 L .38018 .62468 L p F P
0 g
s
.88 .945 .584 r
.3453 .68071 m .33982 .68451 L .31302 .74335 L p F P
0 g
s
.898 .742 .24 r
.28393 .87576 m .28172 .86917 L .2785 .93127 L p F P
0 g
s
.898 .742 .24 r
.2785 .93127 m .28054 .9414 L .28393 .87576 L p F P
0 g
s
.279 .074 .412 r
.49071 .48682 m .48823 .50151 L .43685 .545 L p F P
0 g
s
.114 0 .205 r
.43387 .5565 m .43685 .545 L .48823 .50151 L p F P
0 g
s
.022 .035 .531 r
.28129 1.03958 m .2855 1.0282 L .30219 1.08953 L p F P
0 g
s
.022 .035 .531 r
.30219 1.08953 m .29875 1.10407 L .28129 1.03958 L p F P
0 g
s
.911 .96 .635 r
.30798 .74351 m .31302 .74335 L .33982 .68451 L p F P
0 g
s
.952 .922 .564 r
.31302 .74335 m .30798 .74351 L .28947 .80234 L p F P
0 g
s
.952 .922 .564 r
.28947 .80234 m .2934 .80571 L .31302 .74335 L p F P
0 g
s
.964 .862 .457 r
.2934 .80571 m .28947 .80234 L .27844 .86219 L p F P
0 g
s
.964 .862 .457 r
.27844 .86219 m .28172 .86917 L .2934 .80571 L p F P
0 g
s
.535 .523 .789 r
.51653 .33419 m .52779 .35699 L .45836 .39679 L p F P
0 g
s
.535 .523 .789 r
.45836 .39679 m .44463 .37597 L .51653 .33419 L p F P
0 g
s
.524 .5 .772 r
.4702 .41685 m .45836 .39679 L .52779 .35699 L p F P
0 g
s
.524 .5 .772 r
.52779 .35699 m .53713 .37896 L .4702 .41685 L p F P
0 g
s
.509 .466 .745 r
.47966 .43598 m .4702 .41685 L .53713 .37896 L p F P
0 g
s
.541 .537 .8 r
.50392 .3108 m .51653 .33419 L .44463 .37597 L p F P
0 g
s
.541 .537 .8 r
.44463 .37597 m .42957 .3546 L .50392 .3108 L p F P
0 g
s
.114 0 .205 r
.48823 .50151 m .48281 .51518 L .43387 .5565 L p F P
0 g
s
0 0 0 r
.42824 .56713 m .43387 .5565 L .48281 .51518 L p F P
0 g
s
.543 .544 .805 r
.4906 .28707 m .50392 .3108 L .42957 .3546 L p F P
0 g
s
.543 .544 .805 r
.42957 .3546 m .41382 .33294 L .4906 .28707 L p F P
0 g
s
.509 .466 .745 r
.53713 .37896 m .54406 .39994 L .47966 .43598 L p F P
0 g
s
.486 .417 .704 r
.48637 .45406 m .47966 .43598 L .54406 .39994 L p F P
0 g
s
0 0 .453 r
.2855 1.0282 m .28706 1.01599 L .30295 1.07418 L p F P
0 g
s
0 0 .453 r
.30295 1.07418 m .30219 1.08953 L .2855 1.0282 L p F P
0 g
s
.621 .363 .506 r
.1908 1.18277 m .21402 1.17353 L .24852 1.24504 L p F P
0 g
s
.603 .356 .515 r
.21402 1.17353 m .23525 1.16381 L .26879 1.23235 L p F P
0 g
s
.603 .356 .515 r
.26879 1.23235 m .24852 1.24504 L .21402 1.17353 L p F P
0 g
s
.575 .344 .528 r
.23525 1.16381 m .254 1.15347 L .28651 1.21908 L p F P
0 g
s
.575 .344 .528 r
.28651 1.21908 m .26879 1.23235 L .23525 1.16381 L p F P
0 g
s
.79 .949 .609 r
.38018 .62468 m .37281 .63149 L .33982 .68451 L p F P
0 g
s
.632 .368 .5 r
.16618 1.19169 m .1908 1.18277 L .22622 1.25728 L p F P
0 g
s
.621 .363 .506 r
.24852 1.24504 m .22622 1.25728 L .1908 1.18277 L p F P
0 g
s
.486 .417 .704 r
.54406 .39994 m .54823 .4198 L .48637 .45406 L p F P
0 g
s
.452 .346 .644 r
.4901 .47101 m .48637 .45406 L .54823 .4198 L p F P
0 g
s
.831 .974 .669 r
.33325 .688 m .33982 .68451 L .37281 .63149 L p F P
0 g
s
.911 .96 .635 r
.33982 .68451 m .33325 .688 L .30798 .74351 L p F P
0 g
s
.534 .327 .545 r
.254 1.15347 m .2699 1.14239 L .30134 1.20511 L p F P
0 g
s
.534 .327 .545 r
.30134 1.20511 m .28651 1.21908 L .254 1.15347 L p F P
0 g
s
.638 .37 .497 r
.14082 1.20044 m .16618 1.19169 L .20246 1.26923 L p F P
0 g
s
.632 .368 .5 r
.22622 1.25728 m .20246 1.26923 L .16618 1.19169 L p F P
0 g
s
.94 .77 .302 r
.28172 .86917 m .27844 .86219 L .27539 .92071 L p F P
0 g
s
.94 .77 .302 r
.27539 .92071 m .2785 .93127 L .28172 .86917 L p F P
0 g
s
.638 .37 .497 r
.20246 1.26923 m .17792 1.28105 L .14082 1.20044 L p F P
0 g
s
.475 .301 .565 r
.2699 1.14239 m .28271 1.1305 L .31301 1.19035 L p F P
0 g
s
.475 .301 .565 r
.31301 1.19035 m .30134 1.20511 L .2699 1.14239 L p F P
0 g
s
.452 .346 .644 r
.54823 .4198 m .54938 .43848 L .4901 .47101 L p F P
0 g
s
.4 .247 .556 r
.49071 .48682 m .4901 .47101 L .54938 .43848 L p F P
0 g
s
.391 .265 .586 r
.28271 1.1305 m .29231 1.11773 L .32142 1.17475 L p F P
0 g
s
.391 .265 .586 r
.32142 1.17475 m .31301 1.19035 L .28271 1.1305 L p F P
0 g
s
0 0 0 r
.48281 .51518 m .47472 .52796 L .42824 .56713 L p F P
0 g
s
0 0 0 r
.42037 .57707 m .42824 .56713 L .47472 .52796 L p F P
0 g
s
.918 .963 .649 r
.30253 .74356 m .30798 .74351 L .33325 .688 L p F P
0 g
s
.958 .924 .578 r
.30798 .74351 m .30253 .74356 L .28514 .79882 L p F P
0 g
s
.958 .924 .578 r
.28514 .79882 m .28947 .80234 L .30798 .74351 L p F P
0 g
s
0 0 .353 r
.28706 1.01599 m .28639 1.00305 L .30145 1.05811 L p F P
0 g
s
0 0 .353 r
.30145 1.05811 m .30295 1.07418 L .28706 1.01599 L p F P
0 g
s
.4 .247 .556 r
.54938 .43848 m .5474 .45595 L .49071 .48682 L p F P
0 g
s
.327 .114 .431 r
.48823 .50151 m .49071 .48682 L .5474 .45595 L p F P
0 g
s
.971 .865 .473 r
.28947 .80234 m .28514 .79882 L .27477 .85502 L p F P
0 g
s
.971 .865 .473 r
.27477 .85502 m .27844 .86219 L .28947 .80234 L p F P
0 g
s
.276 .213 .603 r
.29231 1.11773 m .29875 1.10407 L .32663 1.15829 L p F P
0 g
s
.276 .213 .603 r
.32663 1.15829 m .32142 1.17475 L .29231 1.11773 L p F P
0 g
s
.831 .974 .669 r
.37281 .63149 m .36433 .63803 L .33325 .688 L p F P
0 g
s
.842 .98 .685 r
.32624 .69143 m .33325 .688 L .36433 .63803 L p F P
0 g
s
.918 .963 .649 r
.33325 .688 m .32624 .69143 L .30253 .74356 L p F P
0 g
s
.95 .776 .32 r
.27844 .86219 m .27477 .85502 L .27189 .90993 L p F P
0 g
s
.95 .776 .32 r
.27189 .90993 m .27539 .92071 L .27844 .86219 L p F P
0 g
s
.327 .114 .431 r
.5474 .45595 m .5423 .47226 L .48823 .50151 L p F P
0 g
s
.229 0 .266 r
.48281 .51518 m .48823 .50151 L .5423 .47226 L p F P
0 g
s
.13 .145 .607 r
.29875 1.10407 m .30219 1.08953 L .32879 1.14098 L p F P
0 g
s
.13 .145 .607 r
.32879 1.14098 m .32663 1.15829 L .29875 1.10407 L p F P
0 g
s
0 0 0 r
.47472 .52796 m .46438 .54001 L .42037 .57707 L p F P
0 g
s
0 0 .264 r
.29824 1.04143 m .30145 1.05811 L .28639 1.00305 L p F P
0 g
s
.229 0 .266 r
.5423 .47226 m .53424 .4875 L .48281 .51518 L p F P
0 g
s
.114 0 .078 r
.47472 .52796 m .48281 .51518 L .53424 .4875 L p F P
0 g
s
.911 .96 .635 r
.29736 .74372 m .30253 .74356 L .32624 .69143 L p F P
0 g
s
.952 .922 .565 r
.30253 .74356 m .29736 .74372 L .28111 .79536 L p F P
0 g
s
.952 .922 .565 r
.28111 .79536 m .28514 .79882 L .30253 .74356 L p F P
0 g
s
.964 .862 .457 r
.28514 .79882 m .28111 .79536 L .27141 .84787 L p F P
0 g
s
.964 .862 .457 r
.27141 .84787 m .27477 .85502 L .28514 .79882 L p F P
0 g
s
0 .068 .592 r
.30219 1.08953 m .30295 1.07418 L .32824 1.12288 L p F P
0 g
s
0 .068 .592 r
.32824 1.12288 m .32879 1.14098 L .30219 1.08953 L p F P
0 g
s
.703 .95 .667 r
.35539 .64452 m .36433 .63803 L .40005 .59567 L p F P
0 g
s
.842 .98 .685 r
.36433 .63803 m .35539 .64452 L .32624 .69143 L p F P
0 g
s
.867 .631 .1 r
.27539 .92071 m .27189 .90993 L .27672 .96129 L p F P
0 g
s
.832 .974 .669 r
.31951 .69501 m .32624 .69143 L .35539 .64452 L p F P
0 g
s
.911 .96 .635 r
.32624 .69143 m .31951 .69501 L .29736 .74372 L p F P
0 g
s
.94 .77 .302 r
.27477 .85502 m .27141 .84787 L .2687 .89912 L p F P
0 g
s
.94 .77 .302 r
.2687 .89912 m .27189 .90993 L .27477 .85502 L p F P
0 g
s
0 0 .208 r
.29393 1.0243 m .29824 1.04143 L .28401 .98951 L p F P
0 g
s
.114 0 .078 r
.53424 .4875 m .5235 .50182 L .47472 .52796 L p F P
0 g
s
.004 0 0 r
.46438 .54001 m .47472 .52796 L .5235 .50182 L p F P
0 g
s
0 0 .559 r
.30295 1.07418 m .30145 1.05811 L .3254 1.10406 L p F P
0 g
s
0 0 .559 r
.3254 1.10406 m .32824 1.12288 L .30295 1.07418 L p F P
0 g
s
.462 .437 .745 r
.60516 .36067 m .60944 .3828 L .54406 .39994 L p F P
0 g
s
.462 .437 .745 r
.54406 .39994 m .53713 .37896 L .60516 .36067 L p F P
0 g
s
.451 .393 .701 r
.54823 .4198 m .54406 .39994 L .60944 .3828 L p F P
0 g
s
.47 .47 .775 r
.59844 .33749 m .60516 .36067 L .53713 .37896 L p F P
0 g
s
.47 .47 .775 r
.53713 .37896 m .52779 .35699 L .59844 .33749 L p F P
0 g
s
.451 .393 .701 r
.60944 .3828 m .61094 .40374 L .54823 .4198 L p F P
0 g
s
.433 .332 .641 r
.54938 .43848 m .54823 .4198 L .61094 .40374 L p F P
0 g
s
.475 .492 .796 r
.58979 .31342 m .59844 .33749 L .52779 .35699 L p F P
0 g
s
.475 .492 .796 r
.52779 .35699 m .51653 .33419 L .58979 .31342 L p F P
0 g
s
.881 .946 .585 r
.29317 .74423 m .29736 .74372 L .31951 .69501 L p F P
0 g
s
.926 .909 .516 r
.29736 .74372 m .29317 .74423 L .27808 .7922 L p F P
0 g
s
.926 .909 .516 r
.27808 .7922 m .28111 .79536 L .29736 .74372 L p F P
0 g
s
.935 .845 .405 r
.28111 .79536 m .27808 .7922 L .26907 .84095 L p F P
0 g
s
.935 .845 .405 r
.26907 .84095 m .27141 .84787 L .28111 .79536 L p F P
0 g
s
.433 .332 .641 r
.61094 .40374 m .6094 .42344 L .54938 .43848 L p F P
0 g
s
.408 .254 .558 r
.5474 .45595 m .54938 .43848 L .6094 .42344 L p F P
0 g
s
.703 .95 .667 r
.40005 .59567 m .38886 .60482 L .35539 .64452 L p F P
0 g
s
.688 .938 .646 r
.3467 .65121 m .35539 .64452 L .38886 .60482 L p F P
0 g
s
.832 .974 .669 r
.35539 .64452 m .3467 .65121 L .31951 .69501 L p F P
0 g
s
.54 .291 .486 r
.26879 1.23235 m .28651 1.21908 L .33072 1.26958 L p F P
0 g
s
.507 .287 .516 r
.28651 1.21908 m .30134 1.20511 L .34396 1.25323 L p F P
0 g
s
.507 .287 .516 r
.34396 1.25323 m .33072 1.26958 L .28651 1.21908 L p F P
0 g
s
.477 .505 .808 r
.57977 .2887 m .58979 .31342 L .51653 .33419 L p F P
0 g
s
.477 .505 .808 r
.51653 .33419 m .50392 .3108 L .57977 .2887 L p F P
0 g
s
.564 .293 .463 r
.24852 1.24504 m .26879 1.23235 L .31453 1.28528 L p F P
0 g
s
.54 .291 .486 r
.33072 1.26958 m .31453 1.28528 L .26879 1.23235 L p F P
0 g
s
.46 .282 .552 r
.30134 1.20511 m .31301 1.19035 L .35398 1.23613 L p F P
0 g
s
.46 .282 .552 r
.35398 1.23613 m .34396 1.25323 L .30134 1.20511 L p F P
0 g
s
.851 .62 .08 r
.27189 .90993 m .2687 .89912 L .27319 .94701 L p F P
0 g
s
.851 .62 .08 r
.27319 .94701 m .27672 .96129 L .27189 .90993 L p F P
0 g
s
.58 .294 .446 r
.22622 1.25728 m .24852 1.24504 L .29574 1.30043 L p F P
0 g
s
.564 .293 .463 r
.31453 1.28528 m .29574 1.30043 L .24852 1.24504 L p F P
0 g
s
.004 0 0 r
.5235 .50182 m .51049 .51538 L .46438 .54001 L p F P
0 g
s
0 0 0 r
.4523 .55156 m .46438 .54001 L .51049 .51538 L p F P
0 g
s
.398 .272 .591 r
.31301 1.19035 m .32142 1.17475 L .36071 1.21822 L p F P
0 g
s
.398 .272 .591 r
.36071 1.21822 m .35398 1.23613 L .31301 1.19035 L p F P
0 g
s
.479 .512 .814 r
.56901 .26357 m .57977 .2887 L .50392 .3108 L p F P
0 g
s
.479 .512 .814 r
.50392 .3108 m .4906 .28707 L .56901 .26357 L p F P
0 g
s
.408 .254 .558 r
.6094 .42344 m .6047 .44188 L .5474 .45595 L p F P
0 g
s
.373 .158 .453 r
.5423 .47226 m .5474 .45595 L .6047 .44188 L p F P
0 g
s
.792 .949 .61 r
.31374 .69899 m .31951 .69501 L .3467 .65121 L p F P
0 g
s
.881 .946 .585 r
.31951 .69501 m .31374 .69899 L .29317 .74423 L p F P
0 g
s
.899 .743 .242 r
.27141 .84787 m .26907 .84095 L .26654 .8885 L p F P
0 g
s
.899 .743 .242 r
.26654 .8885 m .2687 .89912 L .27141 .84787 L p F P
0 g
s
.59 .295 .436 r
.20246 1.26923 m .22622 1.25728 L .27486 1.31517 L p F P
0 g
s
.58 .294 .446 r
.29574 1.30043 m .27486 1.31517 L .22622 1.25728 L p F P
0 g
s
0 0 .19 r
.28921 1.00692 m .29393 1.0243 L .28056 .97553 L p F P
0 g
s
0 0 .522 r
.30145 1.05811 m .29824 1.04143 L .32083 1.08465 L p F P
0 g
s
0 0 .522 r
.32083 1.08465 m .3254 1.10406 L .30145 1.05811 L p F P
0 g
s
.321 .258 .63 r
.32142 1.17475 m .32663 1.15829 L .36417 1.19948 L p F P
0 g
s
.321 .258 .63 r
.36417 1.19948 m .36071 1.21822 L .32142 1.17475 L p F P
0 g
s
.595 .295 .43 r
.17792 1.28105 m .20246 1.26923 L .25247 1.32966 L p F P
0 g
s
.59 .295 .436 r
.27486 1.31517 m .25247 1.32966 L .20246 1.26923 L p F P
0 g
s
.373 .158 .453 r
.6047 .44188 m .59686 .4591 L .5423 .47226 L p F P
0 g
s
.328 .049 .329 r
.53424 .4875 m .5423 .47226 L .59686 .4591 L p F P
0 g
s
.595 .295 .43 r
.25247 1.32966 m .22926 1.34404 L .17792 1.28105 L p F P
0 g
s
.231 .239 .662 r
.32663 1.15829 m .32879 1.14098 L .36456 1.17992 L p F P
0 g
s
.231 .239 .662 r
.36456 1.17992 m .36417 1.19948 L .32663 1.15829 L p F P
0 g
s
.797 .888 .468 r
.29066 .7453 m .29317 .74423 L .31374 .69899 L p F P
0 g
s
.847 .858 .403 r
.29317 .74423 m .29066 .7453 L .27674 .78953 L p F P
0 g
s
.847 .858 .403 r
.27674 .78953 m .27808 .7922 L .29317 .74423 L p F P
0 g
s
0 0 0 r
.51049 .51538 m .49572 .52842 L .4523 .55156 L p F P
0 g
s
0 0 0 r
.43906 .56284 m .4523 .55156 L .49572 .52842 L p F P
0 g
s
.849 .787 .289 r
.27808 .7922 m .27674 .78953 L .26842 .83448 L p F P
0 g
s
.849 .787 .289 r
.26842 .83448 m .26907 .84095 L .27808 .7922 L p F P
0 g
s
.688 .938 .646 r
.38886 .60482 m .37789 .61418 L .3467 .65121 L p F P
0 g
s
.633 .895 .573 r
.33896 .65835 m .3467 .65121 L .37789 .61418 L p F P
0 g
s
.792 .949 .61 r
.3467 .65121 m .33896 .65835 L .31374 .69899 L p F P
0 g
s
.791 .58 .015 r
.2687 .89912 m .26654 .8885 L .27069 .93287 L p F P
0 g
s
.791 .58 .015 r
.27069 .93287 m .27319 .94701 L .2687 .89912 L p F P
0 g
s
.328 .049 .329 r
.59686 .4591 m .58606 .4752 L .53424 .4875 L p F P
0 g
s
.278 0 .2 r
.5235 .50182 m .53424 .4875 L .58606 .4752 L p F P
0 g
s
0 0 .495 r
.29824 1.04143 m .29393 1.0243 L .31515 1.06481 L p F P
0 g
s
0 0 .495 r
.31515 1.06481 m .32083 1.08465 L .29824 1.04143 L p F P
0 g
s
0 0 0 r
.37789 .61418 m .38886 .60482 L .42535 .5741 L p F P
0 g
s
0 0 .208 r
.27672 .96129 m .27319 .94701 L .28482 .98946 L p F P
0 g
s
0 0 .208 r
.28482 .98946 m .28921 1.00692 L .27672 .96129 L p F P
0 g
s
.138 .217 .683 r
.32879 1.14098 m .32824 1.12288 L .3622 1.1596 L p F P
0 g
s
.138 .217 .683 r
.3622 1.1596 m .36456 1.17992 L .32879 1.14098 L p F P
0 g
s
.69 .872 .479 r
.30961 .70359 m .31374 .69899 L .33896 .65835 L p F P
0 g
s
.797 .888 .468 r
.31374 .69899 m .30961 .70359 L .29066 .7453 L p F P
0 g
s
.792 .669 .119 r
.26907 .84095 m .26842 .83448 L .2661 .87828 L p F P
0 g
s
.792 .669 .119 r
.2661 .87828 m .26654 .8885 L .26907 .84095 L p F P
0 g
s
.278 0 .2 r
.58606 .4752 m .57256 .49034 L .5235 .50182 L p F P
0 g
s
.229 0 .081 r
.51049 .51538 m .5235 .50182 L .57256 .49034 L p F P
0 g
s
0 0 0 r
.49572 .52842 m .4798 .54118 L .43906 .56284 L p F P
0 g
s
.054 .194 .693 r
.32824 1.12288 m .3254 1.10406 L .35753 1.13858 L p F P
0 g
s
.054 .194 .693 r
.35753 1.13858 m .3622 1.1596 L .32824 1.12288 L p F P
0 g
s
0 0 .485 r
.29393 1.0243 m .28921 1.00692 L .30906 1.0447 L p F P
0 g
s
0 0 .485 r
.30906 1.0447 m .31515 1.06481 L .29393 1.0243 L p F P
0 g
s
0 0 0 r
.29041 .74713 m .29066 .7453 L .30961 .70359 L p F P
0 g
s
0 0 0 r
.29066 .7453 m .29041 .74713 L .27769 .78757 L p F P
0 g
s
0 0 0 r
.27769 .78757 m .27674 .78953 L .29066 .7453 L p F P
0 g
s
0 0 0 r
.27674 .78953 m .27769 .78757 L .27009 .82864 L p F P
0 g
s
0 0 0 r
.27009 .82864 m .26842 .83448 L .27674 .78953 L p F P
0 g
s
.633 .895 .573 r
.37789 .61418 m .36786 .62403 L .33896 .65835 L p F P
0 g
s
.69 .872 .479 r
.33896 .65835 m .33284 .66615 L .30961 .70359 L p F P
0 g
s
0 0 0 r
.33284 .66615 m .33896 .65835 L .36786 .62403 L p F P
0 g
s
0 0 .103 r
.26654 .8885 m .2661 .87828 L .26992 .9191 L p F P
0 g
s
0 0 .103 r
.26992 .9191 m .27069 .93287 L .26654 .8885 L p F P
0 g
s
0 0 0 r
.42535 .5741 m .41185 .5856 L .37789 .61418 L p F P
0 g
s
0 0 0 r
.36786 .62403 m .37789 .61418 L .41185 .5856 L p F P
0 g
s
0 0 .262 r
.27319 .94701 m .27069 .93287 L .28146 .97213 L p F P
0 g
s
0 0 .262 r
.28146 .97213 m .28482 .98946 L .27319 .94701 L p F P
0 g
s
.229 0 .081 r
.57256 .49034 m .55678 .5047 L .51049 .51538 L p F P
0 g
s
.189 0 0 r
.49572 .52842 m .51049 .51538 L .55678 .5047 L p F P
0 g
s
0 0 0 r
.30773 .70901 m .30961 .70359 L .33284 .66615 L p F P
0 g
s
0 0 0 r
.30961 .70359 m .30773 .70901 L .29041 .74713 L p F P
0 g
s
0 0 .082 r
.26842 .83448 m .27009 .82864 L .26797 .86865 L p F P
0 g
s
0 0 .082 r
.26797 .86865 m .2661 .87828 L .26842 .83448 L p F P
0 g
s
0 .175 .694 r
.3254 1.10406 m .32083 1.08465 L .3511 1.11699 L p F P
0 g
s
0 .175 .694 r
.3511 1.11699 m .35753 1.13858 L .3254 1.10406 L p F P
0 g
s
0 0 0 r
.4798 .54118 m .4634 .55391 L .42535 .5741 L p F P
0 g
s
0 0 0 r
.41185 .5856 m .42535 .5741 L .4634 .55391 L p F P
0 g
s
0 0 .495 r
.28921 1.00692 m .28482 .98946 L .30328 1.02452 L p F P
0 g
s
0 0 .495 r
.30328 1.02452 m .30906 1.0447 L .28921 1.00692 L p F P
0 g
s
.408 .36 .692 r
.67294 .38641 m .67174 .4076 L .61094 .40374 L p F P
0 g
s
.408 .36 .692 r
.61094 .40374 m .60944 .3828 L .67294 .38641 L p F P
0 g
s
.413 .315 .634 r
.6094 .42344 m .61094 .40374 L .67174 .4076 L p F P
0 g
s
0 0 .104 r
.29295 .74988 m .29041 .74713 L .30773 .70901 L p F P
0 g
s
0 0 .144 r
.29041 .74713 m .29295 .74988 L .28144 .78646 L p F P
0 g
s
0 0 .144 r
.28144 .78646 m .27769 .78757 L .29041 .74713 L p F P
0 g
s
0 0 0 r
.36786 .62403 m .35943 .63457 L .33284 .66615 L p F P
0 g
s
0 0 0 r
.32896 .67481 m .33284 .66615 L .35943 .63457 L p F P
0 g
s
0 0 0 r
.33284 .66615 m .32896 .67481 L .30773 .70901 L p F P
0 g
s
.189 0 0 r
.55678 .5047 m .53924 .5185 L .49572 .52842 L p F P
0 g
s
.164 0 0 r
.4798 .54118 m .49572 .52842 L .53924 .5185 L p F P
0 g
s
0 0 .217 r
.27769 .78757 m .28144 .78646 L .27457 .82361 L p F P
0 g
s
0 0 .217 r
.27457 .82361 m .27009 .82864 L .27769 .78757 L p F P
0 g
s
.413 .315 .634 r
.67174 .4076 m .66749 .42749 L .6094 .42344 L p F P
0 g
s
.415 .261 .562 r
.6047 .44188 m .6094 .42344 L .66749 .42749 L p F P
0 g
s
.403 .395 .737 r
.67132 .36398 m .67294 .38641 L .60944 .3828 L p F P
0 g
s
.403 .395 .737 r
.60944 .3828 m .60516 .36067 L .67132 .36398 L p F P
0 g
s
0 0 .264 r
.2661 .87828 m .26797 .86865 L .27147 .90588 L p F P
0 g
s
0 0 .264 r
.27147 .90588 m .26992 .9191 L .2661 .87828 L p F P
0 g
s
0 0 0 r
.41185 .5856 m .39928 .59759 L .36786 .62403 L p F P
0 g
s
0 0 0 r
.35943 .63457 m .36786 .62403 L .39928 .59759 L p F P
0 g
s
.415 .261 .562 r
.66749 .42749 m .66007 .44607 L .6047 .44188 L p F P
0 g
s
.414 .201 .478 r
.59686 .4591 m .6047 .44188 L .66007 .44607 L p F P
0 g
s
0 0 .347 r
.27069 .93287 m .26992 .9191 L .27983 .95515 L p F P
0 g
s
0 0 .347 r
.27983 .95515 m .28146 .97213 L .27069 .93287 L p F P
0 g
s
0 .163 .692 r
.32083 1.08465 m .31515 1.06481 L .34355 1.09499 L p F P
0 g
s
0 .163 .692 r
.34355 1.09499 m .3511 1.11699 L .32083 1.08465 L p F P
0 g
s
.397 .422 .769 r
.66727 .34042 m .67132 .36398 L .60516 .36067 L p F P
0 g
s
.397 .422 .769 r
.60516 .36067 m .59844 .33749 L .66727 .34042 L p F P
0 g
s
.471 .242 .485 r
.33072 1.26958 m .34396 1.25323 L .39646 1.28379 L p F P
0 g
s
.442 .261 .539 r
.34396 1.25323 m .35398 1.23613 L .40436 1.26503 L p F P
0 g
s
.442 .261 .539 r
.40436 1.26503 m .39646 1.28379 L .34396 1.25323 L p F P
0 g
s
.405 .28 .595 r
.35398 1.23613 m .36071 1.21822 L .40891 1.24549 L p F P
0 g
s
.405 .28 .595 r
.40891 1.24549 m .40436 1.26503 L .35398 1.23613 L p F P
0 g
s
0 0 .101 r
.30862 .71541 m .30773 .70901 L .32896 .67481 L p F P
0 g
s
0 0 .104 r
.30773 .70901 m .30862 .71541 L .29295 .74988 L p F P
0 g
s
.492 .226 .438 r
.31453 1.28528 m .33072 1.26958 L .38532 1.30185 L p F P
0 g
s
.471 .242 .485 r
.39646 1.28379 m .38532 1.30185 L .33072 1.26958 L p F P
0 g
s
0 0 .313 r
.27009 .82864 m .27457 .82361 L .27267 .85976 L p F P
0 g
s
0 0 .313 r
.27267 .85976 m .26797 .86865 L .27009 .82864 L p F P
0 g
s
.414 .201 .478 r
.66007 .44607 m .6495 .46338 L .59686 .4591 L p F P
0 g
s
.408 .138 .389 r
.58606 .4752 m .59686 .4591 L .6495 .46338 L p F P
0 g
s
.363 .298 .65 r
.36071 1.21822 m .36417 1.19948 L .41016 1.22515 L p F P
0 g
s
.363 .298 .65 r
.41016 1.22515 m .40891 1.24549 L .36071 1.21822 L p F P
0 g
s
.393 .44 .791 r
.66125 .31593 m .66727 .34042 L .59844 .33749 L p F P
0 g
s
.393 .44 .791 r
.59844 .33749 m .58979 .31342 L .66125 .31593 L p F P
0 g
s
.508 .213 .4 r
.29574 1.30043 m .31453 1.28528 L .37116 1.31928 L p F P
0 g
s
.492 .226 .438 r
.38532 1.30185 m .37116 1.31928 L .31453 1.28528 L p F P
0 g
s
0 0 0 r
.4634 .55391 m .4472 .56688 L .41185 .5856 L p F P
0 g
s
0 0 0 r
.39928 .59759 m .41185 .5856 L .4472 .56688 L p F P
0 g
s
.317 .314 .697 r
.36417 1.19948 m .36456 1.17992 L .40831 1.20402 L p F P
0 g
s
.317 .314 .697 r
.40831 1.20402 m .41016 1.22515 L .36417 1.19948 L p F P
0 g
s
0 0 .521 r
.28482 .98946 m .28146 .97213 L .29854 1.00447 L p F P
0 g
s
0 0 .521 r
.29854 1.00447 m .30328 1.02452 L .28482 .98946 L p F P
0 g
s
.164 0 0 r
.53924 .5185 m .52055 .532 L .4798 .54118 L p F P
0 g
s
.156 0 0 r
.4634 .55391 m .4798 .54118 L .52055 .532 L p F P
0 g
s
.408 .138 .389 r
.6495 .46338 m .63594 .47954 L .58606 .4752 L p F P
0 g
s
.4 .08 .304 r
.57256 .49034 m .58606 .4752 L .63594 .47954 L p F P
0 g
s
.39 .452 .804 r
.65385 .29072 m .66125 .31593 L .58979 .31342 L p F P
0 g
s
.39 .452 .804 r
.58979 .31342 m .57977 .2887 L .65385 .29072 L p F P
0 g
s
.518 .203 .372 r
.27486 1.31517 m .29574 1.30043 L .35437 1.33621 L p F P
0 g
s
.508 .213 .4 r
.37116 1.31928 m .35437 1.33621 L .29574 1.30043 L p F P
0 g
s
0 0 0 r
.35943 .63457 m .35322 .64602 L .32896 .67481 L p F P
0 g
s
0 0 .13 r
.32781 .68451 m .32896 .67481 L .35322 .64602 L p F P
0 g
s
0 0 .101 r
.32896 .67481 m .32781 .68451 L .30862 .71541 L p F P
0 g
s
.127 0 .385 r
.29865 .75368 m .29295 .74988 L .30862 .71541 L p F P
0 g
s
.111 0 .406 r
.29295 .74988 m .29865 .75368 L .28837 .78634 L p F P
0 g
s
.111 0 .406 r
.28837 .78634 m .28144 .78646 L .29295 .74988 L p F P
0 g
s
.112 .002 .437 r
.28144 .78646 m .28837 .78634 L .28225 .81951 L p F P
0 g
s
.112 .002 .437 r
.28225 .81951 m .27457 .82361 L .28144 .78646 L p F P
0 g
s
0 .159 .691 r
.31515 1.06481 m .30906 1.0447 L .33559 1.07273 L p F P
0 g
s
0 .159 .691 r
.33559 1.07273 m .34355 1.09499 L .31515 1.06481 L p F P
0 g
s
0 0 0 r
.39928 .59759 m .38831 .6103 L .35943 .63457 L p F P
0 g
s
0 0 0 r
.35322 .64602 m .35943 .63457 L .38831 .6103 L p F P
0 g
s
0 0 .419 r
.26797 .86865 m .27267 .85976 L .27585 .89337 L p F P
0 g
s
0 0 .419 r
.27585 .89337 m .27147 .90588 L .26797 .86865 L p F P
0 g
s
.273 .326 .735 r
.36456 1.17992 m .3622 1.1596 L .40367 1.18215 L p F P
0 g
s
.273 .326 .735 r
.40367 1.18215 m .40831 1.20402 L .36456 1.17992 L p F P
0 g
s
0 0 .443 r
.26992 .9191 m .27147 .90588 L .28052 .93869 L p F P
0 g
s
0 0 .443 r
.28052 .93869 m .27983 .95515 L .26992 .9191 L p F P
0 g
s
.525 .197 .354 r
.25247 1.32966 m .27486 1.31517 L .33542 1.35276 L p F P
0 g
s
.518 .203 .372 r
.35437 1.33621 m .33542 1.35276 L .27486 1.31517 L p F P
0 g
s
.388 .458 .811 r
.64571 .26505 m .65385 .29072 L .57977 .2887 L p F P
0 g
s
.388 .458 .811 r
.57977 .2887 m .56901 .26357 L .64571 .26505 L p F P
0 g
s
.159 0 .376 r
.31265 .72291 m .30862 .71541 L .32781 .68451 L p F P
0 g
s
.127 0 .385 r
.30862 .71541 m .31265 .72291 L .29865 .75368 L p F P
0 g
s
.4 .08 .304 r
.63594 .47954 m .61969 .49468 L .57256 .49034 L p F P
0 g
s
.39 .031 .23 r
.55678 .5047 m .57256 .49034 L .61969 .49468 L p F P
0 g
s
.131 .04 .476 r
.27457 .82361 m .28225 .81951 L .28057 .85176 L p F P
0 g
s
.131 .04 .476 r
.28057 .85176 m .27267 .85976 L .27457 .82361 L p F P
0 g
s
0 0 0 r
.4472 .56688 m .43193 .58034 L .39928 .59759 L p F P
0 g
s
0 0 0 r
.38831 .6103 m .39928 .59759 L .43193 .58034 L p F P
0 g
s
.235 .334 .761 r
.3622 1.1596 m .35753 1.13858 L .39671 1.15963 L p F P
0 g
s
.235 .334 .761 r
.39671 1.15963 m .40367 1.18215 L .3622 1.1596 L p F P
0 g
s
.528 .194 .345 r
.22926 1.34404 m .25247 1.32966 L .31494 1.3691 L p F P
0 g
s
.525 .197 .354 r
.33542 1.35276 m .31494 1.3691 L .25247 1.32966 L p F P
0 g
s
.156 0 0 r
.52055 .532 m .50137 .54545 L .4634 .55391 L p F P
0 g
s
.164 0 0 r
.4472 .56688 m .4634 .55391 L .50137 .54545 L p F P
0 g
s
0 0 .556 r
.28146 .97213 m .27983 .95515 L .29552 .98476 L p F P
0 g
s
0 0 .556 r
.29552 .98476 m .29854 1.00447 L .28146 .97213 L p F P
0 g
s
0 .163 .692 r
.30906 1.0447 m .30328 1.02452 L .32794 1.05043 L p F P
0 g
s
0 .163 .692 r
.32794 1.05043 m .33559 1.07273 L .30906 1.0447 L p F P
0 g
s
.39 .031 .23 r
.61969 .49468 m .60116 .50901 L .55678 .5047 L p F P
0 g
s
.382 0 .175 r
.53924 .5185 m .55678 .5047 L .60116 .50901 L p F P
0 g
s
.353 .21 .543 r
.30774 .75859 m .29865 .75368 L .31265 .72291 L p F P
0 g
s
.35 .211 .547 r
.29865 .75368 m .30774 .75859 L .29871 .78729 L p F P
0 g
s
.35 .211 .547 r
.29871 .78729 m .28837 .78634 L .29865 .75368 L p F P
0 g
s
0 0 .13 r
.35322 .64602 m .34974 .65853 L .32781 .68451 L p F P
0 g
s
.203 .009 .38 r
.32979 .69535 m .32781 .68451 L .34974 .65853 L p F P
0 g
s
.159 0 .376 r
.32781 .68451 m .32979 .69535 L .31265 .72291 L p F P
0 g
s
.35 .214 .551 r
.28837 .78634 m .29871 .78729 L .29335 .81642 L p F P
0 g
s
.35 .214 .551 r
.29335 .81642 m .28225 .81951 L .28837 .78634 L p F P
0 g
s
.163 .087 .517 r
.27267 .85976 m .28057 .85176 L .28345 .88171 L p F P
0 g
s
.163 .087 .517 r
.28345 .88171 m .27585 .89337 L .27267 .85976 L p F P
0 g
s
0 0 0 r
.38831 .6103 m .37954 .62394 L .35322 .64602 L p F P
0 g
s
.09 0 .183 r
.34974 .65853 m .35322 .64602 L .37954 .62394 L p F P
0 g
s
.528 .194 .345 r
.31494 1.3691 m .29358 1.38538 L .22926 1.34404 L p F P
0 g
s
0 .013 .518 r
.27147 .90588 m .27585 .89337 L .28406 .92294 L p F P
0 g
s
0 .013 .518 r
.28406 .92294 m .28052 .93869 L .27147 .90588 L p F P
0 g
s
.206 .339 .778 r
.35753 1.13858 m .3511 1.11699 L .38797 1.13656 L p F P
0 g
s
.206 .339 .778 r
.38797 1.13656 m .39671 1.15963 L .35753 1.13858 L p F P
0 g
s
.357 .21 .541 r
.32005 .73157 m .31265 .72291 L .32979 .69535 L p F P
0 g
s
.353 .21 .543 r
.31265 .72291 m .32005 .73157 L .30774 .75859 L p F P
0 g
s
.352 .219 .557 r
.28225 .81951 m .29335 .81642 L .29191 .84473 L p F P
0 g
s
.352 .219 .557 r
.29191 .84473 m .28057 .85176 L .28225 .81951 L p F P
0 g
s
0 0 0 r
.43193 .58034 m .41826 .59454 L .38831 .6103 L p F P
0 g
s
.102 0 .065 r
.37954 .62394 m .38831 .6103 L .41826 .59454 L p F P
0 g
s
.164 0 0 r
.50137 .54545 m .48242 .55914 L .4472 .56688 L p F P
0 g
s
.188 0 0 r
.43193 .58034 m .4472 .56688 L .48242 .55914 L p F P
0 g
s
.382 0 .175 r
.60116 .50901 m .58088 .52276 L .53924 .5185 L p F P
0 g
s
.376 0 .141 r
.52055 .532 m .53924 .5185 L .58088 .52276 L p F P
0 g
s
0 .057 .586 r
.27983 .95515 m .28052 .93869 L .29484 .96558 L p F P
0 g
s
0 .057 .586 r
.29484 .96558 m .29552 .98476 L .27983 .95515 L p F P
0 g
s
0 .174 .693 r
.30328 1.02452 m .29854 1.00447 L .32133 1.02827 L p F P
0 g
s
0 .174 .693 r
.32133 1.02827 m .32794 1.05043 L .30328 1.02452 L p F P
0 g
s
.481 .35 .624 r
.32029 .76463 m .30774 .75859 L .32005 .73157 L p F P
0 g
s
.486 .346 .616 r
.30774 .75859 m .32029 .76463 L .31253 .78931 L p F P
0 g
s
.486 .346 .616 r
.31253 .78931 m .29871 .78729 L .30774 .75859 L p F P
0 g
s
.487 .339 .605 r
.29871 .78729 m .31253 .78931 L .30793 .81436 L p F P
0 g
s
.487 .339 .605 r
.30793 .81436 m .29335 .81642 L .29871 .78729 L p F P
0 g
s
.203 .009 .38 r
.34974 .65853 m .34936 .67221 L .32979 .69535 L p F P
0 g
s
.362 .213 .54 r
.33512 .70739 m .32979 .69535 L .34936 .67221 L p F P
0 g
s
.357 .21 .541 r
.32979 .69535 m .33512 .70739 L .32005 .73157 L p F P
0 g
s
.188 .341 .787 r
.3511 1.11699 m .34355 1.09499 L .37812 1.11309 L p F P
0 g
s
.188 .341 .787 r
.37812 1.11309 m .38797 1.13656 L .3511 1.11699 L p F P
0 g
s
.356 .226 .563 r
.28057 .85176 m .29191 .84473 L .29447 .87098 L p F P
0 g
s
.356 .226 .563 r
.29447 .87098 m .28345 .88171 L .28057 .85176 L p F P
0 g
s
.09 0 .183 r
.37954 .62394 m .37349 .63866 L .34974 .65853 L p F P
0 g
s
.253 .046 .393 r
.34936 .67221 m .34974 .65853 L .37349 .63866 L p F P
0 g
s
.205 .14 .558 r
.27585 .89337 m .28345 .88171 L .2908 .90801 L p F P
0 g
s
.205 .14 .558 r
.2908 .90801 m .28406 .92294 L .27585 .89337 L p F P
0 g
s
.473 .349 .631 r
.33089 .7414 m .32005 .73157 L .33512 .70739 L p F P
0 g
s
.481 .35 .624 r
.32005 .73157 m .33089 .7414 L .32029 .76463 L p F P
0 g
s
.484 .328 .593 r
.29335 .81642 m .30793 .81436 L .30672 .8387 L p F P
0 g
s
.484 .328 .593 r
.30672 .8387 m .29191 .84473 L .29335 .81642 L p F P
0 g
s
.376 0 .141 r
.58088 .52276 m .55945 .53617 L .52055 .532 L p F P
0 g
s
.374 0 .129 r
.50137 .54545 m .52055 .532 L .55945 .53617 L p F P
0 g
s
.102 0 .065 r
.41826 .59454 m .4068 .60966 L .37954 .62394 L p F P
0 g
s
.21 0 .249 r
.37349 .63866 m .37954 .62394 L .4068 .60966 L p F P
0 g
s
.188 0 0 r
.48242 .55914 m .4644 .57331 L .43193 .58034 L p F P
0 g
s
.225 0 .076 r
.41826 .59454 m .43193 .58034 L .4644 .57331 L p F P
0 g
s
.109 .129 .599 r
.28052 .93869 m .28406 .92294 L .297 .94709 L p F P
0 g
s
.109 .129 .599 r
.297 .94709 m .29484 .96558 L .28052 .93869 L p F P
0 g
s
.556 .433 .668 r
.33619 .77177 m .32029 .76463 L .33089 .7414 L p F P
0 g
s
.564 .426 .651 r
.32029 .76463 m .33619 .77177 L .3297 .79239 L p F P
0 g
s
.564 .426 .651 r
.3297 .79239 m .31253 .78931 L .32029 .76463 L p F P
0 g
s
.566 .413 .632 r
.31253 .78931 m .3297 .79239 L .32588 .81333 L p F P
0 g
s
.566 .413 .632 r
.32588 .81333 m .30793 .81436 L .31253 .78931 L p F P
0 g
s
.182 .342 .79 r
.34355 1.09499 m .33559 1.07273 L .36784 1.08941 L p F P
0 g
s
.182 .342 .79 r
.36784 1.08941 m .37812 1.11309 L .34355 1.09499 L p F P
0 g
s
.362 .213 .54 r
.34936 .67221 m .35231 .68713 L .33512 .70739 L p F P
0 g
s
.461 .345 .635 r
.34386 .72064 m .33512 .70739 L .35231 .68713 L p F P
0 g
s
.473 .349 .631 r
.33512 .70739 m .34386 .72064 L .33089 .7414 L p F P
0 g
s
.049 .191 .691 r
.29854 1.00447 m .29552 .98476 L .31645 1.00646 L p F P
0 g
s
.049 .191 .691 r
.31645 1.00646 m .32133 1.02827 L .29854 1.00447 L p F P
0 g
s
.478 .314 .58 r
.29191 .84473 m .30672 .8387 L .30897 .86123 L p F P
0 g
s
.478 .314 .58 r
.30897 .86123 m .29447 .87098 L .29191 .84473 L p F P
0 g
s
.253 .046 .393 r
.37349 .63866 m .37053 .65457 L .34936 .67221 L p F P
0 g
s
.369 .218 .541 r
.35231 .68713 m .34936 .67221 L .37053 .65457 L p F P
0 g
s
.542 .435 .682 r
.34506 .75236 m .33089 .7414 L .34386 .72064 L p F P
0 g
s
.556 .433 .668 r
.33089 .7414 m .34506 .75236 L .33619 .77177 L p F P
0 g
s
.361 .234 .569 r
.28345 .88171 m .29447 .87098 L .30097 .894 L p F P
0 g
s
.361 .234 .569 r
.30097 .894 m .2908 .90801 L .28345 .88171 L p F P
0 g
s
.564 .394 .61 r
.30793 .81436 m .32588 .81333 L .3249 .83365 L p F P
0 g
s
.564 .394 .61 r
.3249 .83365 m .30672 .8387 L .30793 .81436 L p F P
0 g
s
.423 .268 .566 r
.72081 .45151 m .71079 .4693 L .66007 .44607 L p F P
0 g
s
.423 .268 .566 r
.66007 .44607 m .66749 .42749 L .72081 .45151 L p F P
0 g
s
.449 .241 .503 r
.6495 .46338 m .66007 .44607 L .71079 .4693 L p F P
0 g
s
.392 .295 .624 r
.72765 .43236 m .72081 .45151 L .66749 .42749 L p F P
0 g
s
.392 .295 .624 r
.66749 .42749 m .67174 .4076 L .72765 .43236 L p F P
0 g
s
.449 .241 .503 r
.71079 .4693 m .69761 .48579 L .6495 .46338 L p F P
0 g
s
.471 .214 .443 r
.63594 .47954 m .6495 .46338 L .69761 .48579 L p F P
0 g
s
.36 .318 .675 r
.73143 .41186 m .72765 .43236 L .67174 .4076 L p F P
0 g
s
.36 .318 .675 r
.67174 .4076 m .67294 .38641 L .73143 .41186 L p F P
0 g
s
.374 0 .129 r
.55945 .53617 m .53755 .54952 L .50137 .54545 L p F P
0 g
s
.376 0 .141 r
.48242 .55914 m .50137 .54545 L .53755 .54952 L p F P
0 g
s
.413 .287 .598 r
.40436 1.26503 m .40891 1.24549 L .46421 1.2544 L p F P
0 g
s
.401 .331 .663 r
.40891 1.24549 m .41016 1.22515 L .46283 1.2333 L p F P
0 g
s
.401 .331 .663 r
.46283 1.2333 m .46421 1.2544 L .40891 1.24549 L p F P
0 g
s
.421 .239 .527 r
.39646 1.28379 m .40436 1.26503 L .46226 1.27474 L p F P
0 g
s
.413 .287 .598 r
.46421 1.2544 m .46226 1.27474 L .40436 1.26503 L p F P
0 g
s
.601 .485 .693 r
.35517 .7799 m .33619 .77177 L .34506 .75236 L p F P
0 g
s
.611 .475 .671 r
.33619 .77177 m .35517 .7799 L .34997 .79644 L p F P
0 g
s
.611 .475 .671 r
.34997 .79644 m .3297 .79239 L .33619 .77177 L p F P
0 g
s
.615 .459 .646 r
.3297 .79239 m .34997 .79644 L .34692 .81323 L p F P
0 g
s
.615 .459 .646 r
.34692 .81323 m .32588 .81333 L .3297 .79239 L p F P
0 g
s
.21 0 .249 r
.4068 .60966 m .39804 .62587 L .37349 .63866 L p F P
0 g
s
.305 .09 .413 r
.37053 .65457 m .37349 .63866 L .39804 .62587 L p F P
0 g
s
.471 .214 .443 r
.69761 .48579 m .68145 .50109 L .63594 .47954 L p F P
0 g
s
.486 .191 .389 r
.61969 .49468 m .63594 .47954 L .68145 .50109 L p F P
0 g
s
.461 .345 .635 r
.35231 .68713 m .35866 .70327 L .34386 .72064 L p F P
0 g
s
.522 .43 .692 r
.35592 .73504 m .34386 .72064 L .35866 .70327 L p F P
0 g
s
.542 .435 .682 r
.34386 .72064 m .35592 .73504 L .34506 .75236 L p F P
0 g
s
.329 .336 .716 r
.73238 .39008 m .73143 .41186 L .67294 .38641 L p F P
0 g
s
.329 .336 .716 r
.67294 .38641 m .67132 .36398 L .73238 .39008 L p F P
0 g
s
.389 .37 .717 r
.41016 1.22515 m .40831 1.20402 L .45833 1.21143 L p F P
0 g
s
.389 .37 .717 r
.45833 1.21143 m .46283 1.2333 L .41016 1.22515 L p F P
0 g
s
.555 .37 .585 r
.30672 .8387 m .3249 .83365 L .32683 .85245 L p F P
0 g
s
.555 .37 .585 r
.32683 .85245 m .30897 .86123 L .30672 .8387 L p F P
0 g
s
.252 .193 .594 r
.28406 .92294 m .2908 .90801 L .30238 .92943 L p F P
0 g
s
.252 .193 .594 r
.30238 .92943 m .297 .94709 L .28406 .92294 L p F P
0 g
s
.225 0 .076 r
.4644 .57331 m .44798 .5882 L .41826 .59454 L p F P
0 g
s
.269 0 .19 r
.4068 .60966 m .41826 .59454 L .44798 .5882 L p F P
0 g
s
.426 .191 .453 r
.38532 1.30185 m .39646 1.28379 L .45694 1.29433 L p F P
0 g
s
.421 .239 .527 r
.46226 1.27474 m .45694 1.29433 L .39646 1.28379 L p F P
0 g
s
.188 .341 .787 r
.33559 1.07273 m .32794 1.05043 L .35788 1.06571 L p F P
0 g
s
.188 .341 .787 r
.35788 1.06571 m .36784 1.08941 L .33559 1.07273 L p F P
0 g
s
.584 .488 .712 r
.36229 .76435 m .34506 .75236 L .35592 .73504 L p F P
0 g
s
.601 .485 .693 r
.34506 .75236 m .36229 .76435 L .35517 .7799 L p F P
0 g
s
.369 .218 .541 r
.37053 .65457 m .37089 .67172 L .35231 .68713 L p F P
0 g
s
.446 .337 .637 r
.35866 .70327 m .35231 .68713 L .37089 .67172 L p F P
0 g
s
.613 .436 .618 r
.32588 .81333 m .34692 .81323 L .34617 .82951 L p F P
0 g
s
.613 .436 .618 r
.34617 .82951 m .3249 .83365 L .32588 .81333 L p F P
0 g
s
.468 .297 .566 r
.29447 .87098 m .30897 .86123 L .31461 .88095 L p F P
0 g
s
.468 .297 .566 r
.31461 .88095 m .30097 .894 L .29447 .87098 L p F P
0 g
s
.128 .21 .68 r
.29552 .98476 m .29484 .96558 L .31391 .98519 L p F P
0 g
s
.128 .21 .68 r
.31391 .98519 m .31645 1.00646 L .29552 .98476 L p F P
0 g
s
.376 .4 .758 r
.40831 1.20402 m .40367 1.18215 L .45103 1.18884 L p F P
0 g
s
.376 .4 .758 r
.45103 1.18884 m .45833 1.21143 L .40831 1.20402 L p F P
0 g
s
.486 .191 .389 r
.68145 .50109 m .66259 .51535 L .61969 .49468 L p F P
0 g
s
.497 .172 .345 r
.60116 .50901 m .61969 .49468 L .66259 .51535 L p F P
0 g
s
.427 .147 .384 r
.37116 1.31928 m .38532 1.30185 L .44834 1.31323 L p F P
0 g
s
.426 .191 .453 r
.45694 1.29433 m .44834 1.31323 L .38532 1.30185 L p F P
0 g
s
.302 .35 .746 r
.73087 .36714 m .73238 .39008 L .67132 .36398 L p F P
0 g
s
.302 .35 .746 r
.67132 .36398 m .66727 .34042 L .73087 .36714 L p F P
0 g
s
.63 .518 .708 r
.37681 .78891 m .35517 .7799 L .36229 .76435 L p F P
0 g
s
.641 .506 .683 r
.35517 .7799 m .37681 .78891 L .3729 .80133 L p F P
0 g
s
.641 .506 .683 r
.3729 .80133 m .34997 .79644 L .35517 .7799 L p F P
0 g
s
.646 .488 .654 r
.34997 .79644 m .3729 .80133 L .37063 .81394 L p F P
0 g
s
.646 .488 .654 r
.37063 .81394 m .34692 .81323 L .34997 .79644 L p F P
0 g
s
.522 .43 .692 r
.35866 .70327 m .36831 .72057 L .35592 .73504 L p F P
0 g
s
.56 .485 .727 r
.37102 .75049 m .35592 .73504 L .36831 .72057 L p F P
0 g
s
.584 .488 .712 r
.35592 .73504 m .37102 .75049 L .36229 .76435 L p F P
0 g
s
.604 .405 .586 r
.3249 .83365 m .34617 .82951 L .34775 .84456 L p F P
0 g
s
.604 .405 .586 r
.34775 .84456 m .32683 .85245 L .3249 .83365 L p F P
0 g
s
.611 .523 .73 r
.38217 .77723 m .36229 .76435 L .37102 .75049 L p F P
0 g
s
.63 .518 .708 r
.36229 .76435 m .38217 .77723 L .37681 .78891 L p F P
0 g
s
.305 .09 .413 r
.39804 .62587 m .39239 .64327 L .37053 .65457 L p F P
0 g
s
.377 .223 .542 r
.37089 .67172 m .37053 .65457 L .39239 .64327 L p F P
0 g
s
.645 .462 .622 r
.34692 .81323 m .37063 .81394 L .37009 .82617 L p F P
0 g
s
.645 .462 .622 r
.37009 .82617 m .34617 .82951 L .34692 .81323 L p F P
0 g
s
.365 .423 .789 r
.40367 1.18215 m .39671 1.15963 L .44139 1.16563 L p F P
0 g
s
.365 .423 .789 r
.44139 1.16563 m .45103 1.18884 L .40367 1.18215 L p F P
0 g
s
.376 0 .141 r
.53755 .54952 m .51589 .56307 L .48242 .55914 L p F P
0 g
s
.381 0 .174 r
.4644 .57331 m .48242 .55914 L .51589 .56307 L p F P
0 g
s
.446 .337 .637 r
.37089 .67172 m .37464 .6901 L .35866 .70327 L p F P
0 g
s
.496 .419 .699 r
.36831 .72057 m .35866 .70327 L .37464 .6901 L p F P
0 g
s
.368 .242 .575 r
.2908 .90801 m .30097 .894 L .31117 .9127 L p F P
0 g
s
.368 .242 .575 r
.31117 .9127 m .30238 .92943 L .2908 .90801 L p F P
0 g
s
.539 .339 .558 r
.30897 .86123 m .32683 .85245 L .33159 .86887 L p F P
0 g
s
.539 .339 .558 r
.33159 .86887 m .31461 .88095 L .30897 .86123 L p F P
0 g
s
.427 .111 .325 r
.35437 1.33621 m .37116 1.31928 L .43669 1.33154 L p F P
0 g
s
.427 .147 .384 r
.44834 1.31323 m .43669 1.33154 L .37116 1.31928 L p F P
0 g
s
.269 0 .19 r
.44798 .5882 m .43379 .60401 L .4068 .60966 L p F P
0 g
s
.314 .033 .316 r
.39804 .62587 m .4068 .60966 L .43379 .60401 L p F P
0 g
s
.497 .172 .345 r
.66259 .51535 m .64147 .52876 L .60116 .50901 L p F P
0 g
s
.504 .158 .313 r
.58088 .52276 m .60116 .50901 L .64147 .52876 L p F P
0 g
s
.647 .539 .717 r
.40057 .7986 m .37681 .78891 L .38217 .77723 L p F P
0 g
s
.66 .526 .689 r
.37681 .78891 m .40057 .7986 L .39796 .80689 L p F P
0 g
s
.66 .526 .689 r
.39796 .80689 m .3729 .80133 L .37681 .78891 L p F P
0 g
s
.665 .506 .659 r
.3729 .80133 m .39796 .80689 L .39645 .81531 L p F P
0 g
s
.665 .506 .659 r
.39645 .81531 m .37063 .81394 L .3729 .80133 L p F P
0 g
s
.205 .338 .778 r
.32794 1.05043 m .32133 1.02827 L .34896 1.04218 L p F P
0 g
s
.205 .338 .778 r
.34896 1.04218 m .35788 1.06571 L .32794 1.05043 L p F P
0 g
s
.281 .36 .767 r
.7274 .3432 m .73087 .36714 L .66727 .34042 L p F P
0 g
s
.281 .36 .767 r
.66727 .34042 m .66125 .31593 L .7274 .3432 L p F P
0 g
s
.56 .485 .727 r
.36831 .72057 m .38097 .73893 L .37102 .75049 L p F P
0 g
s
.585 .521 .75 r
.38875 .76683 m .37102 .75049 L .38097 .73893 L p F P
0 g
s
.611 .523 .73 r
.37102 .75049 m .38875 .76683 L .38217 .77723 L p F P
0 g
s
.636 .429 .585 r
.34617 .82951 m .37009 .82617 L .37131 .83746 L p F P
0 g
s
.636 .429 .585 r
.37131 .83746 m .34775 .84456 L .34617 .82951 L p F P
0 g
s
.215 .228 .658 r
.29484 .96558 m .297 .94709 L .31421 .96464 L p F P
0 g
s
.215 .228 .658 r
.31421 .96464 m .31391 .98519 L .29484 .96558 L p F P
0 g
s
.628 .545 .742 r
.40416 .7908 m .38217 .77723 L .38875 .76683 L p F P
0 g
s
.647 .539 .717 r
.38217 .77723 m .40416 .7908 L .40057 .7986 L p F P
0 g
s
.665 .479 .624 r
.37063 .81394 m .39645 .81531 L .39611 .82347 L p F P
0 g
s
.665 .479 .624 r
.39611 .82347 m .37009 .82617 L .37063 .81394 L p F P
0 g
s
.496 .419 .699 r
.37464 .6901 m .38167 .70964 L .36831 .72057 L p F P
0 g
s
.528 .474 .739 r
.38097 .73893 m .36831 .72057 L .38167 .70964 L p F P
0 g
s
.357 .439 .808 r
.39671 1.15963 m .38797 1.13656 L .42997 1.1419 L p F P
0 g
s
.357 .439 .808 r
.42997 1.1419 m .44139 1.16563 L .39671 1.15963 L p F P
0 g
s
.586 .366 .549 r
.32683 .85245 m .34775 .84456 L .35162 .85769 L p F P
0 g
s
.586 .366 .549 r
.35162 .85769 m .33159 .86887 L .32683 .85245 L p F P
0 g
s
.377 .223 .542 r
.39239 .64327 m .39005 .66191 L .37089 .67172 L p F P
0 g
s
.428 .325 .636 r
.37464 .6901 m .37089 .67172 L .39005 .66191 L p F P
0 g
s
.658 .551 .722 r
.4258 .80877 m .40057 .7986 L .40416 .7908 L p F P
0 g
s
.671 .537 .693 r
.40057 .7986 m .4258 .80877 L .4245 .81292 L p F P
0 g
s
.671 .537 .693 r
.4245 .81292 m .39796 .80689 L .40057 .7986 L p F P
0 g
s
.677 .517 .661 r
.39796 .80689 m .4245 .81292 L .42375 .81713 L p F P
0 g
s
.677 .517 .661 r
.42375 .81713 m .39645 .81531 L .39796 .80689 L p F P
0 g
s
.585 .521 .75 r
.38097 .73893 m .39625 .75818 L .38875 .76683 L p F P
0 g
s
.601 .545 .764 r
.40856 .78387 m .38875 .76683 L .39625 .75818 L p F P
0 g
s
.628 .545 .742 r
.38875 .76683 m .40856 .78387 L .40416 .7908 L p F P
0 g
s
.656 .443 .584 r
.37009 .82617 m .39611 .82347 L .39695 .831 L p F P
0 g
s
.656 .443 .584 r
.39695 .831 m .37131 .83746 L .37009 .82617 L p F P
0 g
s
.454 .277 .55 r
.30097 .894 m .31461 .88095 L .32342 .89695 L p F P
0 g
s
.454 .277 .55 r
.32342 .89695 m .31117 .9127 L .30097 .894 L p F P
0 g
s
.638 .558 .748 r
.4276 .80487 m .40416 .7908 L .40856 .78387 L p F P
0 g
s
.658 .551 .722 r
.40416 .7908 m .4276 .80487 L .4258 .80877 L p F P
0 g
s
.677 .489 .625 r
.39645 .81531 m .42375 .81713 L .42359 .82122 L p F P
0 g
s
.677 .489 .625 r
.42359 .82122 m .39611 .82347 L .39645 .81531 L p F P
0 g
s
.425 .083 .279 r
.33542 1.35276 m .35437 1.33621 L .42236 1.34937 L p F P
0 g
s
.427 .111 .325 r
.43669 1.33154 m .42236 1.34937 L .35437 1.33621 L p F P
0 g
s
.504 .158 .313 r
.64147 .52876 m .6186 .54156 L .58088 .52276 L p F P
0 g
s
.508 .15 .294 r
.55945 .53617 m .58088 .52276 L .6186 .54156 L p F P
0 g
s
.528 .474 .739 r
.38167 .70964 m .3917 .73023 L .38097 .73893 L p F P
0 g
s
.549 .511 .765 r
.39625 .75818 m .38097 .73893 L .3917 .73023 L p F P
0 g
s
.381 0 .174 r
.51589 .56307 m .49518 .5771 L .4644 .57331 L p F P
0 g
s
.388 .028 .227 r
.44798 .5882 m .4644 .57331 L .49518 .5771 L p F P
0 g
s
.601 .545 .764 r
.39625 .75818 m .41358 .77812 L .40856 .78387 L p F P
0 g
s
.61 .559 .772 r
.42982 .80141 m .40856 .78387 L .41358 .77812 L p F P
0 g
s
.638 .558 .748 r
.40856 .78387 m .42982 .80141 L .4276 .80487 L p F P
0 g
s
.618 .385 .542 r
.34775 .84456 m .37131 .83746 L .37426 .8473 L p F P
0 g
s
.618 .385 .542 r
.37426 .8473 m .35162 .85769 L .34775 .84456 L p F P
0 g
s
.668 .452 .583 r
.39611 .82347 m .42359 .82122 L .42402 .82498 L p F P
0 g
s
.668 .452 .583 r
.42402 .82498 m .39695 .831 L .39611 .82347 L p F P
0 g
s
.663 .557 .725 r
.45182 .81919 m .4258 .80877 L .4276 .80487 L closepath p F P
0 g
s
.676 .543 .695 r
.45182 .81919 m .4245 .81292 L .4258 .80877 L closepath p F P
0 g
s
.682 .522 .663 r
.45182 .81919 m .42375 .81713 L .4245 .81292 L closepath p F P
0 g
s
.314 .033 .316 r
.43379 .60401 m .42232 .62089 L .39804 .62587 L p F P
0 g
s
.354 .136 .438 r
.39239 .64327 m .39804 .62587 L .42232 .62089 L p F P
0 g
s
.643 .565 .751 r
.45182 .81919 m .4276 .80487 L .42982 .80141 L closepath p F P
0 g
s
.682 .494 .625 r
.45182 .81919 m .42359 .82122 L .42375 .81713 L closepath p F P
0 g
s
.267 .366 .779 r
.72253 .3185 m .7274 .3432 L .66125 .31593 L p F P
0 g
s
.267 .366 .779 r
.66125 .31593 m .65385 .29072 L .72253 .3185 L p F P
0 g
s
.428 .325 .636 r
.39005 .66191 m .3911 .68176 L .37464 .6901 L p F P
0 g
s
.463 .399 .701 r
.38167 .70964 m .37464 .6901 L .3911 .68176 L p F P
0 g
s
.549 .511 .765 r
.3917 .73023 m .40432 .75169 L .39625 .75818 L p F P
0 g
s
.563 .535 .782 r
.41358 .77812 m .39625 .75818 L .40432 .75169 L p F P
0 g
s
.61 .559 .772 r
.41358 .77812 m .43234 .79854 L .42982 .80141 L p F P
0 g
s
.614 .565 .776 r
.45182 .81919 m .42982 .80141 L .43234 .79854 L closepath p F P
0 g
s
.674 .456 .582 r
.45182 .81919 m .42402 .82498 L .42359 .82122 L closepath p F P
0 g
s
.3 .242 .623 r
.297 .94709 m .30238 .92943 L .31773 .94494 L p F P
0 g
s
.3 .242 .623 r
.31773 .94494 m .31421 .96464 L .297 .94709 L p F P
0 g
s
.638 .396 .536 r
.37131 .83746 m .39695 .831 L .39895 .83755 L p F P
0 g
s
.638 .396 .536 r
.39895 .83755 m .37426 .8473 L .37131 .83746 L p F P
0 g
s
.232 .332 .761 r
.32133 1.02827 m .31645 1.00646 L .34178 1.01903 L p F P
0 g
s
.232 .332 .761 r
.34178 1.01903 m .34896 1.04218 L .32133 1.02827 L p F P
0 g
s
.352 .448 .82 r
.38797 1.13656 m .37812 1.11309 L .41743 1.11781 L p F P
0 g
s
.352 .448 .82 r
.41743 1.11781 m .42997 1.1419 L .38797 1.13656 L p F P
0 g
s
.515 .301 .527 r
.31461 .88095 m .33159 .86887 L .339 .88216 L p F P
0 g
s
.515 .301 .527 r
.339 .88216 m .32342 .89695 L .31461 .88095 L p F P
0 g
s
.563 .535 .782 r
.40432 .75169 m .41899 .77382 L .41358 .77812 L p F P
0 g
s
.571 .55 .792 r
.43234 .79854 m .41358 .77812 L .41899 .77382 L p F P
0 g
s
.65 .403 .532 r
.39695 .831 m .42402 .82498 L .42504 .82825 L p F P
0 g
s
.65 .403 .532 r
.42504 .82825 m .39895 .83755 L .39695 .831 L p F P
0 g
s
.571 .55 .792 r
.41899 .77382 m .43505 .7964 L .43234 .79854 L p F P
0 g
s
.574 .557 .797 r
.45182 .81919 m .43234 .79854 L .43505 .7964 L closepath p F P
0 g
s
0 0 0 r
.45182 .81919 m .43916 .83122 L .43638 .83294 L closepath p F P
0 g
s
0 0 0 r
.45182 .81919 m .44181 .82871 L .43916 .83122 L closepath p F P
0 g
s
.112 0 0 r
.45182 .81919 m .43638 .83294 L .43361 .83377 L closepath p F P
0 g
s
.704 .926 .6 r
.45182 .81919 m .44421 .82552 L .44181 .82871 L closepath p F P
0 g
s
.57 .247 .381 r
.45182 .81919 m .4286 .83271 L .42659 .83087 L closepath p F P
0 g
s
.482 .116 .267 r
.45182 .81919 m .43097 .8337 L .4286 .83271 L closepath p F P
0 g
s
.337 0 .111 r
.45182 .81919 m .43361 .83377 L .43097 .8337 L closepath p F P
0 g
s
.836 .953 .605 r
.45182 .81919 m .44625 .82179 L .44421 .82552 L closepath p F P
0 g
s
.656 .407 .53 r
.45182 .81919 m .42504 .82825 L .42402 .82498 L closepath p F P
0 g
s
.624 .339 .465 r
.45182 .81919 m .42659 .83087 L .42504 .82825 L closepath p F P
0 g
s
.906 .931 .555 r
.45182 .81919 m .44783 .81771 L .44625 .82179 L closepath p F P
0 g
s
.438 .496 .822 r
.45182 .81919 m .43783 .7951 L .44055 .79468 L closepath p F P
0 g
s
.518 .536 .814 r
.45182 .81919 m .43505 .7964 L .43783 .7951 L closepath p F P
0 g
s
.934 .878 .46 r
.45182 .81919 m .44887 .81347 L .44783 .81771 L closepath p F P
0 g
s
0 .113 .656 r
.45182 .81919 m .4453 .79658 L .44711 .7988 L closepath p F P
0 g
s
.147 .305 .768 r
.45182 .81919 m .44308 .79518 L .4453 .79658 L closepath p F P
0 g
s
.32 .425 .813 r
.45182 .81919 m .44055 .79468 L .44308 .79518 L closepath p F P
0 g
s
.92 .791 .316 r
.45182 .81919 m .44932 .80927 L .44887 .81347 L closepath p F P
0 g
s
0 0 .162 r
.44917 .8053 m .45182 .81919 L .45008 .81029 L p F P
0 g
s
0 0 .162 r
.45008 .81029 m .44842 .80176 L .44917 .8053 L p F P
0 g
s
0 0 .466 r
.44572 .78437 m .44842 .80176 L .44711 .7988 L p F P
0 g
s
0 0 .199 r
.44722 .79148 m .44917 .8053 L .44842 .80176 L p F P
0 g
s
0 0 .199 r
.44842 .80176 m .44572 .78437 L .44722 .79148 L p F P
0 g
s
.806 .624 .067 r
.44917 .8053 m .44722 .79148 L .44737 .79546 L p F P
0 g
s
0 0 .445 r
.45182 .81919 m .44711 .7988 L .44842 .80176 L closepath p F P
0 g
s
.806 .624 .067 r
.44737 .79546 m .44752 .79945 L p .44917 .8053 L F P
0 g
s
.845 .651 .109 r
.45182 .81919 m .44917 .8053 L .44932 .80927 L closepath p F P
0 g
s
.463 .399 .701 r
.3911 .68176 m .39542 .70277 L .38167 .70964 L p F P
0 g
s
.485 .452 .746 r
.3917 .73023 m .38167 .70964 L .39542 .70277 L p F P
0 g
s
.516 .529 .808 r
.42453 .77117 m .43783 .7951 L .43505 .7964 L p F P
0 g
s
.516 .529 .808 r
.43505 .7964 m .41899 .77382 L .42453 .77117 L p F P
0 g
s
.619 .338 .469 r
.39895 .83755 m .42504 .82825 L .42659 .83087 L p F P
0 g
s
.558 .317 .506 r
.33159 .86887 m .35162 .85769 L .3576 .86828 L p F P
0 g
s
.558 .317 .506 r
.3576 .86828 m .339 .88216 L .33159 .86887 L p F P
0 g
s
.424 .064 .248 r
.31494 1.3691 m .33542 1.35276 L .40585 1.36687 L p F P
0 g
s
.425 .083 .279 r
.42236 1.34937 m .40585 1.36687 L .33542 1.35276 L p F P
0 g
s
.51 .514 .796 r
.41262 .74766 m .42453 .77117 L .41899 .77382 L p F P
0 g
s
.51 .514 .796 r
.41899 .77382 m .40432 .75169 L .41262 .74766 L p F P
0 g
s
.485 .452 .746 r
.39542 .70277 m .40273 .72479 L .3917 .73023 L p F P
0 g
s
.5 .489 .776 r
.40432 .75169 m .3917 .73023 L .40273 .72479 L p F P
0 g
s
.354 .136 .438 r
.42232 .62089 m .41396 .63895 L .39239 .64327 L p F P
0 g
s
.386 .231 .545 r
.39005 .66191 m .39239 .64327 L .41396 .63895 L p F P
0 g
s
.607 .334 .477 r
.37426 .8473 m .39895 .83755 L .40201 .8428 L p F P
0 g
s
.619 .338 .469 r
.42659 .83087 m .40201 .8428 L .39895 .83755 L p F P
0 g
s
.508 .15 .294 r
.6186 .54156 m .5946 .554 L .55945 .53617 L p F P
0 g
s
.509 .147 .288 r
.53755 .54952 m .55945 .53617 L .5946 .554 L p F P
0 g
s
.5 .489 .776 r
.40273 .72479 m .41262 .74766 L .40432 .75169 L p F P
0 g
s
.437 .489 .815 r
.42996 .77031 m .44055 .79468 L .43783 .7951 L p F P
0 g
s
.437 .489 .815 r
.43783 .7951 m .42453 .77117 L .42996 .77031 L p F P
0 g
s
.587 .327 .49 r
.35162 .85769 m .37426 .8473 L .3788 .85521 L p F P
0 g
s
.587 .327 .49 r
.3788 .85521 m .3576 .86828 L .35162 .85769 L p F P
0 g
s
.566 .248 .389 r
.40201 .8428 m .42659 .83087 L .4286 .83271 L p F P
0 g
s
.607 .334 .477 r
.40201 .8428 m .3788 .85521 L .37426 .8473 L p F P
0 g
s
.375 .25 .58 r
.30238 .92943 m .31117 .9127 L .32466 .92618 L p F P
0 g
s
.375 .25 .58 r
.32466 .92618 m .31773 .94494 L .30238 .92943 L p F P
0 g
s
.388 .028 .227 r
.49518 .5771 m .47611 .59182 L .44798 .5882 L p F P
0 g
s
.395 .073 .297 r
.43379 .60401 m .44798 .5882 L .47611 .59182 L p F P
0 g
s
.26 .369 .785 r
.71692 .2933 m .72253 .3185 L .65385 .29072 L p F P
0 g
s
.26 .369 .785 r
.65385 .29072 m .64571 .26505 L .71692 .2933 L p F P
0 g
s
.324 .42 .806 r
.43502 .77127 m .44308 .79518 L .44055 .79468 L p F P
0 g
s
.324 .42 .806 r
.44055 .79468 m .42996 .77031 L .43502 .77127 L p F P
0 g
s
.566 .248 .389 r
.4286 .83271 m .406 .84652 L .40201 .8428 L p F P
0 g
s
.48 .122 .281 r
.406 .84652 m .4286 .83271 L .43097 .8337 L p F P
0 g
s
.35 .451 .823 r
.37812 1.11309 m .36784 1.08941 L .40448 1.09354 L p F P
0 g
s
.35 .451 .823 r
.40448 1.09354 m .41743 1.11781 L .37812 1.11309 L p F P
0 g
s
.266 .321 .734 r
.31645 1.00646 m .31391 .98519 L .33696 .99646 L p F P
0 g
s
.266 .321 .734 r
.33696 .99646 m .34178 1.01903 L .31645 1.00646 L p F P
0 g
s
.436 .475 .801 r
.42074 .7463 m .42996 .77031 L .42453 .77117 L p F P
0 g
s
.436 .475 .801 r
.42453 .77117 m .41262 .74766 L .42074 .7463 L p F P
0 g
s
.556 .25 .403 r
.3788 .85521 m .40201 .8428 L .406 .84652 L p F P
0 g
s
.386 .231 .545 r
.41396 .63895 m .40893 .65823 L .39005 .66191 L p F P
0 g
s
.407 .309 .631 r
.3911 .68176 m .39005 .66191 L .40893 .65823 L p F P
0 g
s
.16 .305 .764 r
.43946 .77403 m .4453 .79658 L .44308 .79518 L p F P
0 g
s
.16 .305 .764 r
.44308 .79518 m .43502 .77127 L .43946 .77403 L p F P
0 g
s
.48 .122 .281 r
.43097 .8337 m .41073 .84852 L .406 .84652 L p F P
0 g
s
.342 0 .135 r
.41073 .84852 m .43097 .8337 L .43361 .83377 L p F P
0 g
s
.436 .255 .535 r
.31117 .9127 m .32342 .89695 L .33505 .90842 L p F P
0 g
s
.436 .255 .535 r
.33505 .90842 m .32466 .92618 L .31117 .9127 L p F P
0 g
s
.434 .451 .778 r
.41355 .7229 m .42074 .7463 L .41262 .74766 L p F P
0 g
s
.434 .451 .778 r
.41262 .74766 m .40273 .72479 L .41355 .7229 L p F P
0 g
s
.54 .252 .426 r
.3576 .86828 m .3788 .85521 L .38473 .86083 L p F P
0 g
s
.556 .25 .403 r
.406 .84652 m .38473 .86083 L .3788 .85521 L p F P
0 g
s
0 .123 .66 r
.44309 .77847 m .44711 .7988 L .4453 .79658 L p F P
0 g
s
0 .123 .66 r
.4453 .79658 m .43946 .77403 L .44309 .77847 L p F P
0 g
s
.407 .309 .631 r
.40893 .65823 m .40729 .67871 L .3911 .68176 L p F P
0 g
s
.421 .371 .697 r
.39542 .70277 m .3911 .68176 L .40729 .67871 L p F P
0 g
s
.509 .147 .288 r
.5946 .554 m .57016 .56636 L .53755 .54952 L p F P
0 g
s
.508 .15 .294 r
.51589 .56307 m .53755 .54952 L .57016 .56636 L p F P
0 g
s
.342 0 .135 r
.43361 .83377 m .41599 .8487 L .41073 .84852 L p F P
0 g
s
.131 0 0 r
.41599 .8487 m .43361 .83377 L .43638 .83294 L p F P
0 g
s
.423 .055 .233 r
.29358 1.38538 m .31494 1.3691 L .38776 1.38418 L p F P
0 g
s
.424 .064 .248 r
.40585 1.36687 m .38776 1.38418 L .31494 1.3691 L p F P
0 g
s
.429 .418 .745 r
.40892 .70031 m .41355 .7229 L .40273 .72479 L p F P
0 g
s
.429 .418 .745 r
.40273 .72479 m .39542 .70277 L .40892 .70031 L p F P
0 g
s
.332 .409 .791 r
.42833 .74769 m .43502 .77127 L .42996 .77031 L p F P
0 g
s
.332 .409 .791 r
.42996 .77031 m .42074 .7463 L .42833 .74769 L p F P
0 g
s
.482 .255 .493 r
.32342 .89695 m .339 .88216 L .34875 .89166 L p F P
0 g
s
.482 .255 .493 r
.34875 .89166 m .33505 .90842 L .32342 .89695 L p F P
0 g
s
.395 .073 .297 r
.47611 .59182 m .45928 .60744 L .43379 .60401 L p F P
0 g
s
.399 .126 .379 r
.42232 .62089 m .43379 .60401 L .45928 .60744 L p F P
0 g
s
.421 .371 .697 r
.40729 .67871 m .40892 .70031 L .39542 .70277 L p F P
0 g
s
.476 .135 .307 r
.38473 .86083 m .406 .84652 L .41073 .84852 L p F P
0 g
s
.516 .254 .456 r
.339 .88216 m .3576 .86828 L .36546 .87583 L p F P
0 g
s
.54 .252 .426 r
.38473 .86083 m .36546 .87583 L .3576 .86828 L p F P
0 g
s
.516 .254 .456 r
.36546 .87583 m .34875 .89166 L .339 .88216 L p F P
0 g
s
0 0 .466 r
.44711 .7988 m .44309 .77847 L .44572 .78437 L p F P
0 g
s
.131 0 0 r
.43638 .83294 m .42153 .84704 L .41599 .8487 L p F P
0 g
s
0 0 0 r
.42153 .84704 m .43638 .83294 L .43916 .83122 L p F P
0 g
s
.352 .448 .82 r
.36784 1.08941 m .35788 1.06571 L .39185 1.06929 L p F P
0 g
s
.352 .448 .82 r
.39185 1.06929 m .40448 1.09354 L .36784 1.08941 L p F P
0 g
s
.306 .306 .695 r
.31391 .98519 m .31421 .96464 L .33498 .97463 L p F P
0 g
s
.306 .306 .695 r
.33498 .97463 m .33696 .99646 L .31391 .98519 L p F P
0 g
s
0 0 0 r
.43916 .83122 m .4271 .84361 L .42153 .84704 L p F P
0 g
s
0 0 0 r
.4271 .84361 m .43916 .83122 L .44181 .82871 L p F P
0 g
s
.185 .304 .753 r
.435 .75179 m .43946 .77403 L .43502 .77127 L p F P
0 g
s
.185 .304 .753 r
.43502 .77127 m .42833 .74769 L .435 .75179 L p F P
0 g
s
.806 .624 .067 r
.44752 .79945 m .44932 .80927 L .44917 .8053 L p F P
0 g
s
0 0 0 r
.43242 .83857 m .4271 .84361 L p .43401 .83661 L F P
0 g
s
0 0 0 r
.41634 .85659 m .4271 .84361 L .43242 .83857 L p F P
0 g
s
0 0 0 r
.42435 .84901 m .41634 .85659 L p .42339 .84869 L F P
0 g
s
0 0 0 r
.43242 .83857 m .42435 .84901 L p .42339 .84869 L F P
0 g
s
.579 .821 .441 r
.42435 .84901 m .43242 .83857 L p .43089 .84046 L F P
0 g
s
.579 .821 .441 r
.43162 .83933 m .42435 .84901 L p .43001 .84161 L F P
0 g
s
.579 .821 .441 r
.43724 .83215 m .43162 .83933 L p .43001 .84161 L F P
0 g
s
.731 .876 .467 r
.43162 .83933 m .43724 .83215 L .44134 .82466 L p F P
0 g
s
.731 .876 .467 r
.4378 .82802 m .43162 .83933 L p .43589 .83289 L F P
0 g
s
.731 .876 .467 r
.44134 .82466 m .4378 .82802 L p .43589 .83289 L F P
0 g
s
.814 .87 .428 r
.44451 .81645 m .44259 .81562 L .4378 .82802 L p F P
0 g
s
0 0 0 r
.4378 .82802 m .44259 .81562 L p .43958 .82348 L F P
0 g
s
.814 .87 .428 r
.4378 .82802 m .44134 .82466 L .44451 .81645 L p F P
0 g
s
0 0 0 r
.43629 .83209 m .4378 .82802 L p .43958 .82348 L F P
0 g
s
0 0 0 r
.43162 .83933 m .4378 .82802 L p .43312 .83721 L F P
0 g
s
.579 .821 .441 r
.43242 .83857 m .43724 .83215 L p .43089 .84046 L F P
0 g
s
0 0 0 r
.42801 .84725 m .43162 .83933 L p .43312 .83721 L F P
0 g
s
0 0 0 r
.42435 .84901 m .43162 .83933 L p .42524 .8493 L F P
0 g
s
0 0 0 r
.41826 .86021 m .42435 .84901 L p .42524 .8493 L F P
0 g
s
0 0 0 r
.44181 .82871 m .43242 .83857 L p .43401 .83661 L F P
0 g
s
.668 .898 .552 r
.43242 .83857 m .44181 .82871 L .44421 .82552 L p F P
0 g
s
.344 .392 .767 r
.42366 .72468 m .42833 .74769 L .42074 .7463 L p F P
0 g
s
.344 .392 .767 r
.42074 .7463 m .41355 .7229 L .42366 .72468 L p F P
0 g
s
.476 .135 .307 r
.41073 .84852 m .39179 .86388 L .38473 .86083 L p F P
0 g
s
.352 0 .181 r
.39179 .86388 m .41073 .84852 L .41599 .8487 L p F P
0 g
s
.469 .152 .346 r
.36546 .87583 m .38473 .86083 L .39179 .86388 L p F P
0 g
s
.399 .126 .379 r
.45928 .60744 m .44521 .62411 L .42232 .62089 L p F P
0 g
s
.399 .183 .466 r
.41396 .63895 m .42232 .62089 L .44521 .62411 L p F P
0 g
s
.891 .772 .276 r
.44661 .80791 m .44887 .81347 L .44932 .80927 L p F P
0 g
s
.891 .772 .276 r
.44932 .80927 m .44752 .79945 L .44661 .80791 L p F P
0 g
s
.668 .898 .552 r
.44421 .82552 m .43724 .83215 L .43242 .83857 L p F P
0 g
s
.807 .934 .565 r
.43724 .83215 m .44421 .82552 L .44625 .82179 L p F P
0 g
s
.508 .15 .294 r
.57016 .56636 m .54598 .57889 L .51589 .56307 L p F P
0 g
s
.504 .157 .312 r
.49518 .5771 m .51589 .56307 L .54598 .57889 L p F P
0 g
s
.91 .863 .423 r
.44451 .81645 m .44783 .81771 L .44887 .81347 L p F P
0 g
s
.91 .863 .423 r
.44887 .81347 m .44661 .80791 L .44451 .81645 L p F P
0 g
s
.807 .934 .565 r
.44625 .82179 m .44134 .82466 L .43724 .83215 L p F P
0 g
s
.882 .917 .518 r
.44134 .82466 m .44625 .82179 L .44783 .81771 L p F P
0 g
s
.882 .917 .518 r
.44783 .81771 m .44451 .81645 L .44134 .82466 L p F P
0 g
s
.346 .284 .645 r
.31421 .96464 m .31773 .94494 L .33622 .95369 L p F P
0 g
s
.346 .284 .645 r
.33622 .95369 m .33498 .97463 L .31421 .96464 L p F P
0 g
s
.423 .055 .233 r
.38776 1.38418 m .36878 1.40147 L .29358 1.38538 L p F P
0 g
s
.357 .366 .732 r
.42156 .70244 m .42366 .72468 L .41355 .7229 L p F P
0 g
s
.357 .366 .732 r
.41355 .7229 m .40892 .70031 L .42156 .70244 L p F P
0 g
s
.356 .439 .808 r
.35788 1.06571 m .34896 1.04218 L .38028 1.04525 L p F P
0 g
s
.356 .439 .808 r
.38028 1.04525 m .39185 1.06929 L .35788 1.06571 L p F P
0 g
s
0 .142 .663 r
.44046 .75841 m .44309 .77847 L .43946 .77403 L p F P
0 g
s
0 .142 .663 r
.43946 .77403 m .435 .75179 L .44046 .75841 L p F P
0 g
s
.457 .175 .396 r
.34875 .89166 m .36546 .87583 L .37483 .87995 L p F P
0 g
s
.469 .152 .346 r
.39179 .86388 m .37483 .87995 L .36546 .87583 L p F P
0 g
s
.352 0 .181 r
.41599 .8487 m .39966 .86418 L .39179 .86388 L p F P
0 g
s
.166 0 .018 r
.39966 .86418 m .41599 .8487 L .42153 .84704 L p F P
0 g
s
.399 .183 .466 r
.44521 .62411 m .43426 .64194 L .41396 .63895 L p F P
0 g
s
.394 .239 .549 r
.40893 .65823 m .41396 .63895 L .43426 .64194 L p F P
0 g
s
.478 .277 .529 r
.75409 .51143 m .73859 .52614 L .69761 .48579 L p F P
0 g
s
.478 .277 .529 r
.69761 .48579 m .71079 .4693 L .75409 .51143 L p F P
0 g
s
.517 .277 .49 r
.68145 .50109 m .69761 .48579 L .73859 .52614 L p F P
0 g
s
.429 .276 .57 r
.76643 .49539 m .75409 .51143 L .71079 .4693 L p F P
0 g
s
.429 .276 .57 r
.71079 .4693 m .72081 .45151 L .76643 .49539 L p F P
0 g
s
.383 .259 .585 r
.31773 .94494 m .32466 .92618 L .34088 .93373 L p F P
0 g
s
.383 .259 .585 r
.34088 .93373 m .33622 .95369 L .31773 .94494 L p F P
0 g
s
.517 .277 .49 r
.73859 .52614 m .72011 .53964 L .68145 .50109 L p F P
0 g
s
.545 .276 .458 r
.66259 .51535 m .68145 .50109 L .72011 .53964 L p F P
0 g
s
.371 .332 .685 r
.42247 .68116 m .42156 .70244 L .40892 .70031 L p F P
0 g
s
.371 .332 .685 r
.40892 .70031 m .40729 .67871 L .42247 .68116 L p F P
0 g
s
.221 .3 .733 r
.43257 .73007 m .435 .75179 L .42833 .74769 L p F P
0 g
s
.221 .3 .733 r
.42833 .74769 m .42366 .72468 L .43257 .73007 L p F P
0 g
s
.394 .239 .549 r
.43426 .64194 m .42666 .66096 L .40893 .65823 L p F P
0 g
s
.384 .289 .623 r
.40729 .67871 m .40893 .65823 L .42666 .66096 L p F P
0 g
s
.44 .202 .455 r
.33505 .90842 m .34875 .89166 L .36041 .89688 L p F P
0 g
s
.457 .175 .396 r
.37483 .87995 m .36041 .89688 L .34875 .89166 L p F P
0 g
s
.384 .289 .623 r
.42666 .66096 m .42247 .68116 L .40729 .67871 L p F P
0 g
s
.364 .022 .246 r
.37483 .87995 m .39179 .86388 L .39966 .86418 L p F P
0 g
s
.504 .157 .312 r
.54598 .57889 m .5228 .59186 L .49518 .5771 L p F P
0 g
s
.496 .169 .343 r
.47611 .59182 m .49518 .5771 L .5228 .59186 L p F P
0 g
s
.415 .23 .52 r
.32466 .92618 m .33505 .90842 L .34899 .91479 L p F P
0 g
s
.415 .23 .52 r
.34899 .91479 m .34088 .93373 L .32466 .92618 L p F P
0 g
s
.37 .272 .612 r
.77558 .47799 m .76643 .49539 L .72081 .45151 L p F P
0 g
s
.37 .272 .612 r
.72081 .45151 m .72765 .43236 L .77558 .47799 L p F P
0 g
s
.545 .276 .458 r
.72011 .53964 m .69895 .55208 L .66259 .51535 L p F P
0 g
s
.566 .275 .432 r
.64147 .52876 m .66259 .51535 L .69895 .55208 L p F P
0 g
s
.44 .202 .455 r
.36041 .89688 m .34899 .91479 L .33505 .90842 L p F P
0 g
s
0 0 .501 r
.44441 .76728 m .44572 .78437 L .44309 .77847 L p F P
0 g
s
0 0 .501 r
.44309 .77847 m .44046 .75841 L .44441 .76728 L p F P
0 g
s
.166 0 .018 r
.42153 .84704 m .40798 .86172 L .39966 .86418 L p F P
0 g
s
0 0 0 r
.40798 .86172 m .42153 .84704 L .4271 .84361 L p F P
0 g
s
.435 .358 .671 r
.46421 1.2544 m .46283 1.2333 L .5199 1.22263 L p F P
0 g
s
.446 .41 .725 r
.46283 1.2333 m .45833 1.21143 L .51245 1.20096 L p F P
0 g
s
.446 .41 .725 r
.51245 1.20096 m .5199 1.22263 L .46283 1.2333 L p F P
0 g
s
.453 .449 .765 r
.45833 1.21143 m .45103 1.18884 L .50219 1.1786 L p F P
0 g
s
.453 .449 .765 r
.50219 1.1786 m .51245 1.20096 L .45833 1.21143 L p F P
0 g
s
.42 .293 .601 r
.46226 1.27474 m .46421 1.2544 L .52422 1.24355 L p F P
0 g
s
.435 .358 .671 r
.5199 1.22263 m .52422 1.24355 L .46421 1.2544 L p F P
0 g
s
.363 .422 .789 r
.34896 1.04218 m .34178 1.01903 L .37046 1.02163 L p F P
0 g
s
.363 .422 .789 r
.37046 1.02163 m .38028 1.04525 L .34896 1.04218 L p F P
0 g
s
.457 .478 .793 r
.45103 1.18884 m .44139 1.16563 L .4896 1.15563 L p F P
0 g
s
.457 .478 .793 r
.4896 1.15563 m .50219 1.1786 L .45103 1.18884 L p F P
0 g
s
.566 .275 .432 r
.69895 .55208 m .67553 .56365 L .64147 .52876 L p F P
0 g
s
.579 .274 .415 r
.6186 .54156 m .64147 .52876 L .67553 .56365 L p F P
0 g
s
.305 .266 .649 r
.78166 .45922 m .77558 .47799 L .72765 .43236 L p F P
0 g
s
.305 .266 .649 r
.72765 .43236 m .73143 .41186 L .78166 .45922 L p F P
0 g
s
.399 .218 .516 r
.45694 1.29433 m .46226 1.27474 L .52521 1.26371 L p F P
0 g
s
.42 .293 .601 r
.52422 1.24355 m .52521 1.26371 L .46226 1.27474 L p F P
0 g
s
0 0 .271 r
.44668 .77796 m .44722 .79148 L .44572 .78437 L p F P
0 g
s
0 0 .271 r
.44572 .78437 m .44441 .76728 L .44668 .77796 L p F P
0 g
s
0 0 0 r
.4271 .84361 m .41634 .85659 L .40798 .86172 L p F P
0 g
s
.265 .293 .704 r
.43273 .70911 m .43257 .73007 L .42366 .72468 L p F P
0 g
s
.265 .293 .704 r
.42366 .72468 m .42156 .70244 L .43273 .70911 L p F P
0 g
s
.496 .169 .343 r
.5228 .59186 m .50128 .60551 L .47611 .59182 L p F P
0 g
s
.483 .185 .384 r
.45928 .60744 m .47611 .59182 L .50128 .60551 L p F P
0 g
s
.06 .167 .663 r
.43986 .73888 m .44046 .75841 L .435 .75179 L p F P
0 g
s
.06 .167 .663 r
.435 .75179 m .43257 .73007 L .43986 .73888 L p F P
0 g
s
.376 .078 .327 r
.36041 .89688 m .37483 .87995 L .3853 .88042 L p F P
0 g
s
.364 .022 .246 r
.39966 .86418 m .3853 .88042 L .37483 .87995 L p F P
0 g
s
.214 0 .123 r
.3853 .88042 m .39966 .86418 L .40798 .86172 L p F P
0 g
s
.46 .498 .811 r
.44139 1.16563 m .42997 1.1419 L .47523 1.13218 L p F P
0 g
s
.46 .498 .811 r
.47523 1.13218 m .4896 1.15563 L .44139 1.16563 L p F P
0 g
s
.709 .557 0 r
.44713 .78998 m .44752 .79945 L .44722 .79148 L p F P
0 g
s
.812 .716 .183 r
.44752 .79945 m .44738 .79584 L p .44575 .80273 L F P
0 g
s
.812 .716 .183 r
.44738 .79584 m .44713 .78998 L .44575 .80273 L p F P
0 g
s
.812 .716 .183 r
.44575 .80273 m .44661 .80791 L .44752 .79945 L p F P
0 g
s
.842 .816 .333 r
.44661 .80791 m .44575 .80273 L .44259 .81562 L p F P
0 g
s
0 0 0 r
.44575 .80273 m .44696 .79817 L .44349 .81228 L p F P
0 g
s
.842 .816 .333 r
.44259 .81562 m .44451 .81645 L .44661 .80791 L p F P
0 g
s
0 0 0 r
.44349 .81228 m .44272 .81546 L p .44575 .80273 L F P
0 g
s
0 0 0 r
.44713 .78998 m .44881 .78106 L .4473 .79503 L p F P
0 g
s
0 0 0 r
.4473 .79503 m .44696 .79817 L p .44713 .78998 L F P
0 g
s
.709 .557 0 r
.44722 .79148 m .44702 .78633 L p .44713 .78998 L F P
0 g
s
.709 .557 0 r
.44702 .78633 m .44668 .77796 L .44713 .78998 L p F P
0 g
s
.371 .398 .758 r
.34178 1.01903 m .33696 .99646 L .363 .99863 L p F P
0 g
s
.371 .398 .758 r
.363 .99863 m .37046 1.02163 L .34178 1.01903 L p F P
0 g
s
.579 .274 .415 r
.67553 .56365 m .65039 .57459 L .6186 .54156 L p F P
0 g
s
.587 .273 .404 r
.5946 .554 m .6186 .54156 L .65039 .57459 L p F P
0 g
s
.372 .136 .422 r
.44834 1.31323 m .45694 1.29433 L .52281 1.28313 L p F P
0 g
s
.399 .218 .516 r
.52521 1.26371 m .52281 1.28313 L .45694 1.29433 L p F P
0 g
s
.313 .282 .663 r
.4359 .68907 m .43273 .70911 L .42156 .70244 L p F P
0 g
s
.313 .282 .663 r
.42156 .70244 m .42247 .68116 L .4359 .68907 L p F P
0 g
s
.24 .257 .678 r
.78491 .43914 m .78166 .45922 L .73143 .41186 L p F P
0 g
s
.24 .257 .678 r
.73143 .41186 m .73238 .39008 L .78491 .43914 L p F P
0 g
s
.483 .185 .384 r
.50128 .60551 m .48204 .62003 L .45928 .60744 L p F P
0 g
s
.464 .205 .435 r
.44521 .62411 m .45928 .60744 L .48204 .62003 L p F P
0 g
s
.386 .141 .416 r
.34899 .91479 m .36041 .89688 L .37347 .89754 L p F P
0 g
s
.376 .078 .327 r
.3853 .88042 m .37347 .89754 L .36041 .89688 L p F P
0 g
s
.461 .509 .821 r
.42997 1.1419 m .41743 1.11781 L .45975 1.1084 L p F P
0 g
s
.461 .509 .821 r
.45975 1.1084 m .47523 1.13218 L .42997 1.1419 L p F P
0 g
s
0 0 .541 r
.44516 .75069 m .44441 .76728 L .44046 .75841 L p F P
0 g
s
0 0 .541 r
.44046 .75841 m .43986 .73888 L .44516 .75069 L p F P
0 g
s
.38 .364 .716 r
.33696 .99646 m .33498 .97463 L .35841 .97642 L p F P
0 g
s
.38 .364 .716 r
.35841 .97642 m .363 .99863 L .33696 .99646 L p F P
0 g
s
.214 0 .123 r
.40798 .86172 m .39638 .87717 L .3853 .88042 L p F P
0 g
s
.019 0 0 r
.39638 .87717 m .40798 .86172 L .41634 .85659 L p F P
0 g
s
.587 .273 .404 r
.65039 .57459 m .62414 .58515 L .5946 .554 L p F P
0 g
s
.59 .273 .401 r
.57016 .56636 m .5946 .554 L .62414 .58515 L p F P
0 g
s
.36 .266 .612 r
.44238 .67009 m .4359 .68907 L .42247 .68116 L p F P
0 g
s
.36 .266 .612 r
.42247 .68116 m .42666 .66096 L .44238 .67009 L p F P
0 g
s
.464 .205 .435 r
.48204 .62003 m .46558 .63558 L .44521 .62411 L p F P
0 g
s
.437 .226 .493 r
.43426 .64194 m .44521 .62411 L .46558 .63558 L p F P
0 g
s
.151 .194 .653 r
.44187 .72006 m .43986 .73888 L .43257 .73007 L p F P
0 g
s
.151 .194 .653 r
.43257 .73007 m .43273 .70911 L .44187 .72006 L p F P
0 g
s
.391 .206 .506 r
.34088 .93373 m .34899 .91479 L .36464 .91568 L p F P
0 g
s
.386 .141 .416 r
.37347 .89754 m .36464 .91568 L .34899 .91479 L p F P
0 g
s
.343 .056 .325 r
.43669 1.33154 m .44834 1.31323 L .51711 1.30188 L p F P
0 g
s
.372 .136 .422 r
.52281 1.28313 m .51711 1.30188 L .44834 1.31323 L p F P
0 g
s
.268 0 .247 r
.37347 .89754 m .3853 .88042 L .39638 .87717 L p F P
0 g
s
.402 .247 .554 r
.45229 .65225 m .44238 .67009 L .42666 .66096 L p F P
0 g
s
.402 .247 .554 r
.42666 .66096 m .43426 .64194 L .45229 .65225 L p F P
0 g
s
.437 .226 .493 r
.46558 .63558 m .45229 .65225 L .43426 .64194 L p F P
0 g
s
.387 .32 .659 r
.33498 .97463 m .33622 .95369 L .35705 .95514 L p F P
0 g
s
.387 .32 .659 r
.35705 .95514 m .35841 .97642 L .33498 .97463 L p F P
0 g
s
.461 .513 .825 r
.41743 1.11781 m .40448 1.09354 L .44387 1.08448 L p F P
0 g
s
.461 .513 .825 r
.44387 1.08448 m .45975 1.1084 L .41743 1.11781 L p F P
0 g
s
.391 .267 .589 r
.33622 .95369 m .34088 .93373 L .35912 .93487 L p F P
0 g
s
.391 .206 .506 r
.36464 .91568 m .35912 .93487 L .34088 .93373 L p F P
0 g
s
.391 .267 .589 r
.35912 .93487 m .35705 .95514 L .33622 .95369 L p F P
0 g
s
.18 .248 .698 r
.7857 .41787 m .78491 .43914 L .73238 .39008 L p F P
0 g
s
.18 .248 .698 r
.73238 .39008 m .73087 .36714 L .7857 .41787 L p F P
0 g
s
0 0 .367 r
.4482 .76498 m .44668 .77796 L .44441 .76728 L p F P
0 g
s
0 0 .367 r
.44441 .76728 m .44516 .75069 L .4482 .76498 L p F P
0 g
s
.59 .273 .401 r
.62414 .58515 m .59748 .5956 L .57016 .56636 L p F P
0 g
s
.587 .273 .404 r
.54598 .57889 m .57016 .56636 L .59748 .5956 L p F P
0 g
s
.019 0 0 r
.41634 .85659 m .40755 .87033 L .39638 .87717 L p F P
0 g
s
0 0 0 r
.40755 .87033 m .41634 .85659 L .42435 .84901 L p F P
0 g
s
.461 .509 .821 r
.40448 1.09354 m .39185 1.06929 L .42833 1.06061 L p F P
0 g
s
.461 .509 .821 r
.42833 1.06061 m .44387 1.08448 L .40448 1.09354 L p F P
0 g
s
.246 .22 .63 r
.44692 .70216 m .44187 .72006 L .43273 .70911 L p F P
0 g
s
.246 .22 .63 r
.43273 .70911 m .4359 .68907 L .44692 .70216 L p F P
0 g
s
.314 0 .236 r
.42236 1.34937 m .43669 1.33154 L .50835 1.32005 L p F P
0 g
s
.343 .056 .325 r
.51711 1.30188 m .50835 1.32005 L .43669 1.33154 L p F P
0 g
s
.321 .074 .376 r
.36464 .91568 m .37347 .89754 L .38733 .89354 L p F P
0 g
s
.268 0 .247 r
.39638 .87717 m .38733 .89354 L .37347 .89754 L p F P
0 g
s
0 0 .167 r
.44881 .78106 m .44713 .78998 L .44668 .77796 L p F P
0 g
s
0 0 .167 r
.44668 .77796 m .4482 .76498 L .44881 .78106 L p F P
0 g
s
.018 .068 .572 r
.44853 .73483 m .44516 .75069 L .43986 .73888 L p F P
0 g
s
.018 .068 .572 r
.43986 .73888 m .44187 .72006 L .44853 .73483 L p F P
0 g
s
.587 .273 .404 r
.59748 .5956 m .57113 .6062 L .54598 .57889 L p F P
0 g
s
.579 .273 .414 r
.5228 .59186 m .54598 .57889 L .57113 .6062 L p F P
0 g
s
0 0 0 r
.42435 .84901 m .41826 .86021 L .40755 .87033 L p F P
0 g
s
.135 0 .163 r
.38733 .89354 m .39638 .87717 L .40755 .87033 L p F P
0 g
s
.459 .498 .811 r
.39185 1.06929 m .38028 1.04525 L .41387 1.037 L p F P
0 g
s
.459 .498 .811 r
.41387 1.037 m .42833 1.06061 L .39185 1.06929 L p F P
0 g
s
.131 .24 .71 r
.78451 .39559 m .7857 .41787 L .73087 .36714 L p F P
0 g
s
.131 .24 .71 r
.73087 .36714 m .7274 .3432 L .78451 .39559 L p F P
0 g
s
0 0 0 r
.44696 .79817 m .44575 .80273 L .44713 .78998 L p F P
0 g
s
0 0 0 r
.43162 .83933 m .42801 .84725 L .41826 .86021 L p F P
0 g
s
.334 .24 .597 r
.4553 .68529 m .44692 .70216 L .4359 .68907 L p F P
0 g
s
.334 .24 .597 r
.4359 .68907 m .44238 .67009 L .4553 .68529 L p F P
0 g
s
.579 .273 .414 r
.57113 .6062 m .5458 .61722 L .5228 .59186 L p F P
0 g
s
.565 .273 .431 r
.50128 .60551 m .5228 .59186 L .5458 .61722 L p F P
0 g
s
.365 .181 .493 r
.35912 .93487 m .36464 .91568 L .38127 .91095 L p F P
0 g
s
.321 .074 .376 r
.38733 .89354 m .38127 .91095 L .36464 .91568 L p F P
0 g
s
0 0 0 r
.44272 .81546 m .44259 .81562 L .44575 .80273 L p F P
0 g
s
0 0 0 r
.4378 .82802 m .43629 .83209 L .42801 .84725 L p F P
0 g
s
0 0 0 r
.44259 .81562 m .44272 .81546 L .43629 .83209 L p F P
0 g
s
.456 .478 .793 r
.38028 1.04525 m .37046 1.02163 L .40117 1.01385 L p F P
0 g
s
.456 .478 .793 r
.40117 1.01385 m .41387 1.037 L .38028 1.04525 L p F P
0 g
s
.289 0 .163 r
.40585 1.36687 m .42236 1.34937 L .49689 1.33775 L p F P
0 g
s
.314 0 .236 r
.50835 1.32005 m .49689 1.33775 L .42236 1.34937 L p F P
0 g
s
0 0 .462 r
.45236 .75273 m .4482 .76498 L .44516 .75069 L p F P
0 g
s
0 0 .462 r
.44516 .75069 m .44853 .73483 L .45236 .75273 L p F P
0 g
s
.565 .273 .431 r
.5458 .61722 m .52218 .62888 L .50128 .60551 L p F P
0 g
s
.543 .272 .455 r
.48204 .62003 m .50128 .60551 L .52218 .62888 L p F P
0 g
s
.409 .255 .559 r
.46715 .66953 m .4553 .68529 L .44238 .67009 L p F P
0 g
s
.409 .255 .559 r
.44238 .67009 m .45229 .65225 L .46715 .66953 L p F P
0 g
s
.135 0 .163 r
.40755 .87033 m .40131 .88502 L .38733 .89354 L p F P
0 g
s
0 0 .084 r
.40131 .88502 m .40755 .87033 L .41826 .86021 L p F P
0 g
s
.175 .147 .585 r
.45496 .71986 m .44853 .73483 L .44187 .72006 L p F P
0 g
s
.175 .147 .585 r
.44187 .72006 m .44692 .70216 L .45496 .71986 L p F P
0 g
s
.399 .273 .591 r
.35705 .95514 m .35912 .93487 L .37854 .92945 L p F P
0 g
s
.365 .181 .493 r
.38127 .91095 m .37854 .92945 L .35912 .93487 L p F P
0 g
s
.45 .448 .765 r
.37046 1.02163 m .363 .99863 L .39087 .99138 L p F P
0 g
s
.45 .448 .765 r
.39087 .99138 m .40117 1.01385 L .37046 1.02163 L p F P
0 g
s
.247 .006 .338 r
.38127 .91095 m .38733 .89354 L .40131 .88502 L p F P
0 g
s
.543 .272 .455 r
.52218 .62888 m .50088 .6414 L .48204 .62003 L p F P
0 g
s
.511 .27 .485 r
.46558 .63558 m .48204 .62003 L .50088 .6414 L p F P
0 g
s
.468 .264 .52 r
.48242 .65492 m .46715 .66953 L .45229 .65225 L p F P
0 g
s
.468 .264 .52 r
.45229 .65225 m .46558 .63558 L .48242 .65492 L p F P
0 g
s
.511 .27 .485 r
.50088 .6414 m .48242 .65492 L .46558 .63558 L p F P
0 g
s
.423 .348 .667 r
.35841 .97642 m .35705 .95514 L .37927 .94906 L p F P
0 g
s
.399 .273 .591 r
.37854 .92945 m .37927 .94906 L .35705 .95514 L p F P
0 g
s
.439 .405 .724 r
.363 .99863 m .35841 .97642 L .38344 .96973 L p F P
0 g
s
.439 .405 .724 r
.38344 .96973 m .39087 .99138 L .363 .99863 L p F P
0 g
s
.098 .233 .716 r
.78192 .37252 m .78451 .39559 L .7274 .3432 L p F P
0 g
s
.098 .233 .716 r
.7274 .3432 m .72253 .3185 L .78192 .37252 L p F P
0 g
s
.423 .348 .667 r
.37927 .94906 m .38344 .96973 L .35841 .97642 L p F P
0 g
s
0 0 .332 r
.45314 .77291 m .44881 .78106 L .4482 .76498 L p F P
0 g
s
0 0 .332 r
.4482 .76498 m .45236 .75273 L .45314 .77291 L p F P
0 g
s
0 0 .084 r
.41826 .86021 m .41475 .87234 L .40131 .88502 L p F P
0 g
s
0 0 .026 r
.41475 .87234 m .41826 .86021 L .42801 .84725 L p F P
0 g
s
.549 .328 .531 r
.76997 .58319 m .74962 .59396 L .72011 .53964 L p F P
0 g
s
.549 .328 .531 r
.72011 .53964 m .73859 .52614 L .76997 .58319 L p F P
0 g
s
.585 .341 .514 r
.69895 .55208 m .72011 .53964 L .74962 .59396 L p F P
0 g
s
.585 .341 .514 r
.74962 .59396 m .72661 .60366 L .69895 .55208 L p F P
0 g
s
.609 .35 .5 r
.67553 .56365 m .69895 .55208 L .72661 .60366 L p F P
0 g
s
.31 .213 .58 r
.46476 .70592 m .45496 .71986 L .44692 .70216 L p F P
0 g
s
.31 .213 .58 r
.44692 .70216 m .4553 .68529 L .46476 .70592 L p F P
0 g
s
.272 0 .113 r
.38776 1.38418 m .40585 1.36687 L .48323 1.35513 L p F P
0 g
s
.289 0 .163 r
.49689 1.33775 m .48323 1.35513 L .40585 1.36687 L p F P
0 g
s
.5 .309 .552 r
.78733 .57121 m .76997 .58319 L .73859 .52614 L p F P
0 g
s
.5 .309 .552 r
.73859 .52614 m .75409 .51143 L .78733 .57121 L p F P
0 g
s
.609 .35 .5 r
.72661 .60366 m .70135 .61251 L .67553 .56365 L p F P
0 g
s
.625 .356 .491 r
.65039 .57459 m .67553 .56365 L .70135 .61251 L p F P
0 g
s
.339 .158 .484 r
.37854 .92945 m .38127 .91095 L .39809 .90076 L p F P
0 g
s
.247 .006 .338 r
.40131 .88502 m .39809 .90076 L .38127 .91095 L p F P
0 g
s
.105 .068 .528 r
.4596 .74138 m .45236 .75273 L .44853 .73483 L p F P
0 g
s
.105 .068 .528 r
.44853 .73483 m .45496 .71986 L .4596 .74138 L p F P
0 g
s
0 0 .203 r
.45081 .7944 m .44696 .79817 L .44881 .78106 L p F P
0 g
s
0 0 .203 r
.44881 .78106 m .45314 .77291 L .45081 .7944 L p F P
0 g
s
0 0 .026 r
.42801 .84725 m .42699 .85609 L .41475 .87234 L p F P
0 g
s
0 0 .004 r
.42699 .85609 m .42801 .84725 L .43629 .83209 L p F P
0 g
s
.51 .48 .76 r
.51245 1.20096 m .50219 1.1786 L .55469 1.15123 L p F P
0 g
s
.522 .511 .784 r
.50219 1.1786 m .4896 1.15563 L .53901 1.12951 L p F P
0 g
s
.522 .511 .784 r
.53901 1.12951 m .55469 1.15123 L .50219 1.1786 L p F P
0 g
s
.491 .437 .724 r
.5199 1.22263 m .51245 1.20096 L .56805 1.17236 L p F P
0 g
s
.51 .48 .76 r
.55469 1.15123 m .56805 1.17236 L .51245 1.20096 L p F P
0 g
s
.169 0 .307 r
.39809 .90076 m .40131 .88502 L .41475 .87234 L p F P
0 g
s
.625 .356 .491 r
.70135 .61251 m .6744 .6207 L .65039 .57459 L p F P
0 g
s
.634 .36 .485 r
.62414 .58515 m .65039 .57459 L .6744 .6207 L p F P
0 g
s
.435 .283 .575 r
.80154 .55792 m .78733 .57121 L .75409 .51143 L p F P
0 g
s
.435 .283 .575 r
.75409 .51143 m .76643 .49539 L .80154 .55792 L p F P
0 g
s
.531 .531 .8 r
.4896 1.15563 m .47523 1.13218 L .52158 1.10732 L p F P
0 g
s
.531 .531 .8 r
.52158 1.10732 m .53901 1.12951 L .4896 1.15563 L p F P
0 g
s
.464 .377 .673 r
.52422 1.24355 m .5199 1.22263 L .57861 1.1928 L p F P
0 g
s
.491 .437 .724 r
.56805 1.17236 m .57861 1.1928 L .5199 1.22263 L p F P
0 g
s
0 0 .097 r
.44548 .81613 m .44272 .81546 L .44696 .79817 L p F P
0 g
s
0 0 .097 r
.44696 .79817 m .45081 .7944 L .44548 .81613 L p F P
0 g
s
0 0 .004 r
.43629 .83209 m .4374 .83704 L .42699 .85609 L p F P
0 g
s
0 0 .028 r
.4374 .83704 m .43629 .83209 L .44272 .81546 L p F P
0 g
s
.081 .23 .719 r
.7786 .34891 m .78192 .37252 L .72253 .3185 L p F P
0 g
s
.081 .23 .719 r
.72253 .3185 m .71692 .2933 L .7786 .34891 L p F P
0 g
s
.535 .542 .809 r
.47523 1.13218 m .45975 1.1084 L .50304 1.08483 L p F P
0 g
s
.535 .542 .809 r
.50304 1.08483 m .52158 1.10732 L .47523 1.13218 L p F P
0 g
s
.634 .36 .485 r
.6744 .6207 m .64637 .62851 L .62414 .58515 L p F P
0 g
s
.637 .361 .484 r
.59748 .5956 m .62414 .58515 L .64637 .62851 L p F P
0 g
s
0 0 .028 r
.44272 .81546 m .44548 .81613 L .4374 .83704 L p F P
0 g
s
.415 .263 .564 r
.47805 .69308 m .46476 .70592 L .4553 .68529 L p F P
0 g
s
.415 .263 .564 r
.4553 .68529 m .46715 .66953 L .47805 .69308 L p F P
0 g
s
.426 .298 .602 r
.52521 1.26371 m .52422 1.24355 L .58605 1.21248 L p F P
0 g
s
.464 .377 .673 r
.57861 1.1928 m .58605 1.21248 L .52422 1.24355 L p F P
0 g
s
.407 .279 .593 r
.37927 .94906 m .37854 .92945 L .39821 .91762 L p F P
0 g
s
.339 .158 .484 r
.39809 .90076 m .39821 .91762 L .37854 .92945 L p F P
0 g
s
.35 .249 .597 r
.81256 .54326 m .80154 .55792 L .76643 .49539 L p F P
0 g
s
.35 .249 .597 r
.76643 .49539 m .77558 .47799 L .81256 .54326 L p F P
0 g
s
.537 .546 .812 r
.45975 1.1084 m .44387 1.08448 L .48413 1.06223 L p F P
0 g
s
.537 .546 .812 r
.48413 1.06223 m .50304 1.08483 L .45975 1.1084 L p F P
0 g
s
.637 .361 .484 r
.64637 .62851 m .61797 .63619 L .59748 .5956 L p F P
0 g
s
.634 .36 .485 r
.57113 .6062 m .59748 .5956 L .61797 .63619 L p F P
0 g
s
.044 0 .464 r
.46056 .76568 m .45314 .77291 L .45236 .75273 L p F P
0 g
s
.044 0 .464 r
.45236 .75273 m .4596 .74138 L .46056 .76568 L p F P
0 g
s
.169 0 .307 r
.41475 .87234 m .41428 .88553 L .39809 .90076 L p F P
0 g
s
.094 0 .288 r
.41428 .88553 m .41475 .87234 L .42699 .85609 L p F P
0 g
s
.263 0 .087 r
.36878 1.40147 m .38776 1.38418 L .46798 1.37235 L p F P
0 g
s
.272 0 .113 r
.48323 1.35513 m .46798 1.37235 L .38776 1.38418 L p F P
0 g
s
.492 .298 .545 r
.4948 .68136 m .47805 .69308 L .46715 .66953 L p F P
0 g
s
.492 .298 .545 r
.46715 .66953 m .48242 .65492 L .4948 .68136 L p F P
0 g
s
.535 .542 .809 r
.44387 1.08448 m .42833 1.06061 L .46557 1.03972 L p F P
0 g
s
.535 .542 .809 r
.46557 1.03972 m .48413 1.06223 L .44387 1.08448 L p F P
0 g
s
.634 .36 .485 r
.61797 .63619 m .5899 .644 L .57113 .6062 L p F P
0 g
s
.625 .356 .491 r
.5458 .61722 m .57113 .6062 L .5899 .644 L p F P
0 g
s
.376 .198 .509 r
.52281 1.28313 m .52521 1.26371 L .59016 1.23141 L p F P
0 g
s
.426 .298 .602 r
.58605 1.21248 m .59016 1.23141 L .52521 1.26371 L p F P
0 g
s
.289 .186 .56 r
.47023 .73105 m .4596 .74138 L .45496 .71986 L p F P
0 g
s
.289 .186 .56 r
.45496 .71986 m .46476 .70592 L .47023 .73105 L p F P
0 g
s
.454 .369 .67 r
.38344 .96973 m .37927 .94906 L .40181 .93562 L p F P
0 g
s
.407 .279 .593 r
.39821 .91762 m .40181 .93562 L .37927 .94906 L p F P
0 g
s
.313 .139 .478 r
.39821 .91762 m .39809 .90076 L .41428 .88553 L p F P
0 g
s
.625 .356 .491 r
.5899 .644 m .56291 .65221 L .5458 .61722 L p F P
0 g
s
.609 .349 .499 r
.52218 .62888 m .5458 .61722 L .56291 .65221 L p F P
0 g
s
.53 .531 .8 r
.42833 1.06061 m .41387 1.037 L .44812 1.01751 L p F P
0 g
s
.53 .531 .8 r
.44812 1.01751 m .46557 1.03972 L .42833 1.06061 L p F P
0 g
s
.546 .322 .527 r
.5148 .67072 m .4948 .68136 L .48242 .65492 L p F P
0 g
s
.546 .322 .527 r
.48242 .65492 m .50088 .6414 L .5148 .67072 L p F P
0 g
s
.248 .206 .613 r
.8205 .52725 m .81256 .54326 L .77558 .47799 L p F P
0 g
s
.248 .206 .613 r
.77558 .47799 m .78166 .45922 L .8205 .52725 L p F P
0 g
s
.609 .349 .499 r
.56291 .65221 m .53767 .66105 L .52218 .62888 L p F P
0 g
s
.583 .339 .512 r
.50088 .6414 m .52218 .62888 L .53767 .66105 L p F P
0 g
s
.583 .339 .512 r
.53767 .66105 m .5148 .67072 L .50088 .6414 L p F P
0 g
s
.486 .433 .724 r
.39087 .99138 m .38344 .96973 L .40888 .95471 L p F P
0 g
s
.454 .369 .67 r
.40181 .93562 m .40888 .95471 L .38344 .96973 L p F P
0 g
s
.522 .51 .784 r
.41387 1.037 m .40117 1.01385 L .43246 .99581 L p F P
0 g
s
.522 .51 .784 r
.43246 .99581 m .44812 1.01751 L .41387 1.037 L p F P
0 g
s
.001 0 .401 r
.45777 .79158 m .45081 .7944 L .45314 .77291 L p F P
0 g
s
.001 0 .401 r
.45314 .77291 m .46056 .76568 L .45777 .79158 L p F P
0 g
s
.094 0 .288 r
.42699 .85609 m .42903 .86597 L .41428 .88553 L p F P
0 g
s
.033 0 .287 r
.42903 .86597 m .42699 .85609 L .4374 .83704 L p F P
0 g
s
.508 .479 .76 r
.40117 1.01385 m .39087 .99138 L .41921 .97482 L p F P
0 g
s
.486 .433 .724 r
.40888 .95471 m .41921 .97482 L .39087 .99138 L p F P
0 g
s
.508 .479 .76 r
.41921 .97482 m .43246 .99581 L .40117 1.01385 L p F P
0 g
s
.312 .081 .393 r
.51711 1.30188 m .52281 1.28313 L .59089 1.24958 L p F P
0 g
s
.376 .198 .509 r
.59016 1.23141 m .59089 1.24958 L .52281 1.28313 L p F P
0 g
s
.42 .27 .57 r
.48439 .72183 m .47023 .73105 L .46476 .70592 L p F P
0 g
s
.42 .27 .57 r
.46476 .70592 m .47805 .69308 L .48439 .72183 L p F P
0 g
s
0 0 .345 r
.45134 .8178 m .44548 .81613 L .45081 .7944 L p F P
0 g
s
0 0 .345 r
.45081 .7944 m .45777 .79158 L .45134 .8178 L p F P
0 g
s
.033 0 .287 r
.4374 .83704 m .4416 .84302 L .42903 .86597 L p F P
0 g
s
0 0 .306 r
.4416 .84302 m .4374 .83704 L .44548 .81613 L p F P
0 g
s
.413 .283 .593 r
.40181 .93562 m .39821 .91762 L .41716 .89986 L p F P
0 g
s
.313 .139 .478 r
.41428 .88553 m .41716 .89986 L .39821 .91762 L p F P
0 g
s
0 0 .306 r
.44548 .81613 m .45134 .8178 L .4416 .84302 L p F P
0 g
s
.272 .161 .54 r
.47139 .75949 m .46056 .76568 L .4596 .74138 L p F P
0 g
s
.272 .161 .54 r
.4596 .74138 m .47023 .73105 L .47139 .75949 L p F P
0 g
s
.263 0 .087 r
.46798 1.37235 m .45182 1.38957 L .36878 1.40147 L p F P
0 g
s
.137 .158 .619 r
.8256 .50994 m .8205 .52725 L .78166 .45922 L p F P
0 g
s
.137 .158 .619 r
.78166 .45922 m .78491 .43914 L .8256 .50994 L p F P
0 g
s
.291 .125 .476 r
.41716 .89986 m .41428 .88553 L .42903 .86597 L p F P
0 g
s
.239 0 .264 r
.50835 1.32005 m .51711 1.30188 L .58832 1.26707 L p F P
0 g
s
.312 .081 .393 r
.59089 1.24958 m .58832 1.26707 L .51711 1.30188 L p F P
0 g
s
.509 .327 .569 r
.50204 .71371 m .48439 .72183 L .47805 .69308 L p F P
0 g
s
.509 .327 .569 r
.47805 .69308 m .4948 .68136 L .50204 .71371 L p F P
0 g
s
.479 .383 .668 r
.40888 .95471 m .40181 .93562 L .42356 .91534 L p F P
0 g
s
.413 .283 .593 r
.41716 .89986 m .42356 .91534 L .40181 .93562 L p F P
0 g
s
.261 .14 .52 r
.46814 .78984 m .45777 .79158 L .46056 .76568 L p F P
0 g
s
.261 .14 .52 r
.46056 .76568 m .47139 .75949 L .46814 .78984 L p F P
0 g
s
.291 .125 .476 r
.42903 .86597 m .43445 .87699 L .41716 .89986 L p F P
0 g
s
.273 .118 .48 r
.43445 .87699 m .42903 .86597 L .4416 .84302 L p F P
0 g
s
.569 .364 .564 r
.52298 .70667 m .50204 .71371 L .4948 .68136 L p F P
0 g
s
.569 .364 .564 r
.4948 .68136 m .5148 .67072 L .52298 .70667 L p F P
0 g
s
.424 .276 .575 r
.48577 .75441 m .47139 .75949 L .47023 .73105 L p F P
0 g
s
.424 .276 .575 r
.47023 .73105 m .48439 .72183 L .48577 .75441 L p F P
0 g
s
.03 .11 .614 r
.82823 .49145 m .8256 .50994 L .78491 .43914 L p F P
0 g
s
.03 .11 .614 r
.78491 .43914 m .7857 .41787 L .82823 .49145 L p F P
0 g
s
.418 .286 .593 r
.42356 .91534 m .41716 .89986 L .43445 .87699 L p F P
0 g
s
.522 .451 .717 r
.41921 .97482 m .40888 .95471 L .43344 .93195 L p F P
0 g
s
.479 .383 .668 r
.42356 .91534 m .43344 .93195 L .40888 .95471 L p F P
0 g
s
.257 .125 .503 r
.46061 .82056 m .45134 .8178 L .45777 .79158 L p F P
0 g
s
.257 .125 .503 r
.45777 .79158 m .46814 .78984 L .46061 .82056 L p F P
0 g
s
.273 .118 .48 r
.4416 .84302 m .44919 .85011 L .43445 .87699 L p F P
0 g
s
.261 .118 .489 r
.44919 .85011 m .4416 .84302 L .45134 .8178 L p F P
0 g
s
.635 .407 .555 r
.74375 .66795 m .71727 .67326 L .70135 .61251 L p F P
0 g
s
.635 .407 .555 r
.70135 .61251 m .72661 .60366 L .74375 .66795 L p F P
0 g
s
.652 .417 .55 r
.6744 .6207 m .70135 .61251 L .71727 .67326 L p F P
0 g
s
.652 .417 .55 r
.71727 .67326 m .6891 .67794 L .6744 .6207 L p F P
0 g
s
.661 .423 .548 r
.64637 .62851 m .6744 .6207 L .6891 .67794 L p F P
0 g
s
.61 .391 .56 r
.76801 .66179 m .74375 .66795 L .72661 .60366 L p F P
0 g
s
.61 .391 .56 r
.72661 .60366 m .74962 .59396 L .76801 .66179 L p F P
0 g
s
.608 .39 .559 r
.54683 .70059 m .52298 .70667 L .5148 .67072 L p F P
0 g
s
.608 .39 .559 r
.5148 .67072 m .53767 .66105 L .54683 .70059 L p F P
0 g
s
.661 .423 .548 r
.6891 .67794 m .65989 .68222 L .64637 .62851 L p F P
0 g
s
.664 .424 .547 r
.61797 .63619 m .64637 .62851 L .65989 .68222 L p F P
0 g
s
.261 .118 .489 r
.45134 .8178 m .46061 .82056 L .44919 .85011 L p F P
0 g
s
.166 0 .136 r
.49689 1.33775 m .50835 1.32005 L .58268 1.28396 L p F P
0 g
s
.239 0 .264 r
.58832 1.26707 m .58268 1.28396 L .50835 1.32005 L p F P
0 g
s
.664 .424 .547 r
.65989 .68222 m .63034 .68638 L .61797 .63619 L p F P
0 g
s
.661 .422 .548 r
.5899 .644 m .61797 .63619 L .63034 .68638 L p F P
0 g
s
.55 .497 .748 r
.43246 .99581 m .41921 .97482 L .44663 .94961 L p F P
0 g
s
.522 .451 .717 r
.43344 .93195 m .44663 .94961 L .41921 .97482 L p F P
0 g
s
.572 .369 .567 r
.78961 .65459 m .76801 .66179 L .74962 .59396 L p F P
0 g
s
.572 .369 .567 r
.74962 .59396 m .76997 .58319 L .78961 .65459 L p F P
0 g
s
.635 .406 .554 r
.5731 .69531 m .54683 .70059 L .53767 .66105 L p F P
0 g
s
.635 .406 .554 r
.53767 .66105 m .56291 .65221 L .5731 .69531 L p F P
0 g
s
.57 .528 .769 r
.55469 1.15123 m .53901 1.12951 L .58705 1.08805 L p F P
0 g
s
.581 .547 .782 r
.53901 1.12951 m .52158 1.10732 L .56659 1.06811 L p F P
0 g
s
.581 .547 .782 r
.56659 1.06811 m .58705 1.08805 L .53901 1.12951 L p F P
0 g
s
.587 .558 .789 r
.52158 1.10732 m .50304 1.08483 L .54506 1.04788 L p F P
0 g
s
.587 .558 .789 r
.54506 1.04788 m .56659 1.06811 L .52158 1.10732 L p F P
0 g
s
.661 .422 .548 r
.63034 .68638 m .60116 .69065 L .5899 .644 L p F P
0 g
s
.652 .417 .55 r
.56291 .65221 m .5899 .644 L .60116 .69065 L p F P
0 g
s
.652 .417 .55 r
.60116 .69065 m .5731 .69531 L .56291 .65221 L p F P
0 g
s
.589 .562 .791 r
.50304 1.08483 m .48413 1.06223 L .52317 1.02756 L p F P
0 g
s
.589 .562 .791 r
.52317 1.02756 m .54506 1.04788 L .50304 1.08483 L p F P
0 g
s
.552 .497 .748 r
.56805 1.17236 m .55469 1.15123 L .60577 1.10753 L p F P
0 g
s
.57 .528 .769 r
.58705 1.08805 m .60577 1.10753 L .55469 1.15123 L p F P
0 g
s
.569 .527 .769 r
.44812 1.01751 m .43246 .99581 L .46274 .96818 L p F P
0 g
s
.55 .497 .748 r
.44663 .94961 m .46274 .96818 L .43246 .99581 L p F P
0 g
s
.587 .558 .789 r
.48413 1.06223 m .46557 1.03972 L .50167 1.00736 L p F P
0 g
s
.587 .558 .789 r
.50167 1.00736 m .52317 1.02756 L .48413 1.06223 L p F P
0 g
s
.581 .547 .782 r
.46557 1.03972 m .44812 1.01751 L .4813 .98749 L p F P
0 g
s
.581 .547 .782 r
.4813 .98749 m .50167 1.00736 L .46557 1.03972 L p F P
0 g
s
.569 .527 .769 r
.46274 .96818 m .4813 .98749 L .44812 1.01751 L p F P
0 g
s
.526 .453 .717 r
.57861 1.1928 m .56805 1.17236 L .62219 1.12641 L p F P
0 g
s
.552 .497 .748 r
.60577 1.10753 m .62219 1.12641 L .56805 1.17236 L p F P
0 g
s
.52 .35 .59 r
.50367 .75044 m .48577 .75441 L .48439 .72183 L p F P
0 g
s
.52 .35 .59 r
.48439 .72183 m .50204 .71371 L .50367 .75044 L p F P
0 g
s
.517 .336 .575 r
.80823 .64621 m .78961 .65459 L .76997 .58319 L p F P
0 g
s
.517 .336 .575 r
.76997 .58319 m .78733 .57121 L .80823 .64621 L p F P
0 g
s
.426 .281 .58 r
.48207 .78921 m .46814 .78984 L .47139 .75949 L p F P
0 g
s
.426 .281 .58 r
.47139 .75949 m .48577 .75441 L .48207 .78921 L p F P
0 g
s
.499 .391 .662 r
.43344 .93195 m .42356 .91534 L .44341 .88917 L p F P
0 g
s
.418 .286 .593 r
.43445 .87699 m .44341 .88917 L .42356 .91534 L p F P
0 g
s
.422 .287 .591 r
.44341 .88917 m .43445 .87699 L .44919 .85011 L p F P
0 g
s
0 .07 .604 r
.82889 .47195 m .82823 .49145 L .7857 .41787 L p F P
0 g
s
0 .07 .604 r
.7857 .41787 m .78451 .39559 L .82889 .47195 L p F P
0 g
s
.488 .39 .671 r
.58605 1.21248 m .57861 1.1928 L .63584 1.14459 L p F P
0 g
s
.526 .453 .717 r
.62219 1.12641 m .63584 1.14459 L .57861 1.1928 L p F P
0 g
s
.439 .289 .58 r
.8237 .63656 m .80823 .64621 L .78733 .57121 L p F P
0 g
s
.439 .289 .58 r
.78733 .57121 m .80154 .55792 L .8237 .63656 L p F P
0 g
s
.426 .285 .584 r
.47345 .82446 m .46061 .82056 L .46814 .78984 L p F P
0 g
s
.426 .285 .584 r
.46814 .78984 m .48207 .78921 L .47345 .82446 L p F P
0 g
s
.422 .287 .591 r
.44919 .85011 m .46034 .85836 L .44341 .88917 L p F P
0 g
s
.425 .287 .588 r
.46034 .85836 m .44919 .85011 L .46061 .82056 L p F P
0 g
s
.582 .398 .596 r
.52489 .74754 m .50367 .75044 L .50204 .71371 L p F P
0 g
s
.582 .398 .596 r
.50204 .71371 m .52298 .70667 L .52489 .74754 L p F P
0 g
s
.104 0 .028 r
.48323 1.35513 m .49689 1.33775 L .57436 1.30038 L p F P
0 g
s
.166 0 .136 r
.58268 1.28396 m .57436 1.30038 L .49689 1.33775 L p F P
0 g
s
.549 .459 .705 r
.44663 .94961 m .43344 .93195 L .45589 .90249 L p F P
0 g
s
.499 .391 .662 r
.44341 .88917 m .45589 .90249 L .43344 .93195 L p F P
0 g
s
.425 .287 .588 r
.46061 .82056 m .47345 .82446 L .46034 .85836 L p F P
0 g
s
.432 .302 .602 r
.59016 1.23141 m .58605 1.21248 L .64639 1.16199 L p F P
0 g
s
.488 .39 .671 r
.63584 1.14459 m .64639 1.16199 L .58605 1.21248 L p F P
0 g
s
.526 .368 .61 r
.49955 .78971 m .48207 .78921 L .48577 .75441 L p F P
0 g
s
.526 .368 .61 r
.48577 .75441 m .50367 .75044 L .49955 .78971 L p F P
0 g
s
.513 .393 .653 r
.45589 .90249 m .44341 .88917 L .46034 .85836 L p F P
0 g
s
.623 .429 .599 r
.54906 .74559 m .52489 .74754 L .52298 .70667 L p F P
0 g
s
.623 .429 .599 r
.52298 .70667 m .54683 .70059 L .54906 .74559 L p F P
0 g
s
.332 .225 .58 r
.83598 .62558 m .8237 .63656 L .80154 .55792 L p F P
0 g
s
.332 .225 .58 r
.80154 .55792 m .81256 .54326 L .83598 .62558 L p F P
0 g
s
.582 .504 .732 r
.46274 .96818 m .44663 .94961 L .47168 .91687 L p F P
0 g
s
.549 .459 .705 r
.45589 .90249 m .47168 .91687 L .44663 .94961 L p F P
0 g
s
0 .041 .592 r
.82815 .45166 m .82889 .47195 L .78451 .39559 L p F P
0 g
s
0 .041 .592 r
.78451 .39559 m .78192 .37252 L .82815 .45166 L p F P
0 g
s
.354 .182 .504 r
.59089 1.24958 m .59016 1.23141 L .65363 1.17859 L p F P
0 g
s
.432 .302 .602 r
.64639 1.16199 m .65363 1.17859 L .59016 1.23141 L p F P
0 g
s
.649 .449 .599 r
.57568 .74445 m .54906 .74559 L .54683 .70059 L p F P
0 g
s
.649 .449 .599 r
.54683 .70059 m .5731 .69531 L .57568 .74445 L p F P
0 g
s
.527 .381 .627 r
.48983 .8295 m .47345 .82446 L .48207 .78921 L p F P
0 g
s
.527 .381 .627 r
.48207 .78921 m .49955 .78971 L .48983 .8295 L p F P
0 g
s
.603 .533 .749 r
.4813 .98749 m .46274 .96818 L .49043 .93219 L p F P
0 g
s
.582 .504 .732 r
.47168 .91687 m .49043 .93219 L .46274 .96818 L p F P
0 g
s
.513 .393 .653 r
.46034 .85836 m .47502 .86775 L .45589 .90249 L p F P
0 g
s
.522 .39 .641 r
.47502 .86775 m .46034 .85836 L .47345 .82446 L p F P
0 g
s
.666 .462 .599 r
.60414 .7439 m .57568 .74445 L .5731 .69531 L p F P
0 g
s
.666 .462 .599 r
.5731 .69531 m .60116 .69065 L .60414 .7439 L p F P
0 g
s
.589 .423 .625 r
.52036 .79127 m .49955 .78971 L .50367 .75044 L p F P
0 g
s
.589 .423 .625 r
.50367 .75044 m .52489 .74754 L .52036 .79127 L p F P
0 g
s
.522 .39 .641 r
.47345 .82446 m .48983 .8295 L .47502 .86775 L p F P
0 g
s
.569 .46 .69 r
.47168 .91687 m .45589 .90249 L .47502 .86775 L p F P
0 g
s
.675 .469 .599 r
.63373 .74374 m .60414 .7439 L .60116 .69065 L p F P
0 g
s
.675 .469 .599 r
.60116 .69065 m .63034 .68638 L .63373 .74374 L p F P
0 g
s
.616 .552 .76 r
.50167 1.00736 m .4813 .98749 L .51164 .94829 L p F P
0 g
s
.603 .533 .749 r
.49043 .93219 m .51164 .94829 L .4813 .98749 L p F P
0 g
s
.678 .471 .598 r
.66374 .7437 m .63373 .74374 L .63034 .68638 L p F P
0 g
s
.678 .471 .598 r
.63034 .68638 m .65989 .68222 L .66374 .7437 L p F P
0 g
s
.059 0 0 r
.46798 1.37235 m .48323 1.35513 L .56384 1.31646 L p F P
0 g
s
.104 0 .028 r
.57436 1.30038 m .56384 1.31646 L .48323 1.35513 L p F P
0 g
s
.192 .141 .567 r
.84516 .61328 m .83598 .62558 L .81256 .54326 L p F P
0 g
s
.192 .141 .567 r
.81256 .54326 m .8205 .52725 L .84516 .61328 L p F P
0 g
s
.675 .469 .599 r
.69343 .74353 m .66374 .7437 L .65989 .68222 L p F P
0 g
s
.675 .469 .599 r
.65989 .68222 m .6891 .67794 L .69343 .74353 L p F P
0 g
s
.624 .562 .765 r
.52317 1.02756 m .50167 1.00736 L .5347 .96496 L p F P
0 g
s
.616 .552 .76 r
.51164 .94829 m .5347 .96496 L .50167 1.00736 L p F P
0 g
s
.666 .462 .599 r
.72209 .74299 m .69343 .74353 L .6891 .67794 L p F P
0 g
s
.666 .462 .599 r
.6891 .67794 m .71727 .67326 L .72209 .74299 L p F P
0 g
s
.626 .566 .767 r
.54506 1.04788 m .52317 1.02756 L .55891 .98199 L p F P
0 g
s
.624 .562 .765 r
.5347 .96496 m .55891 .98199 L .52317 1.02756 L p F P
0 g
s
.624 .562 .765 r
.56659 1.06811 m .54506 1.04788 L .58353 .99916 L p F P
0 g
s
.626 .566 .767 r
.55891 .98199 m .58353 .99916 L .54506 1.04788 L p F P
0 g
s
.65 .449 .599 r
.74909 .74183 m .72209 .74299 L .71727 .67326 L p F P
0 g
s
.65 .449 .599 r
.71727 .67326 m .74375 .66795 L .74909 .74183 L p F P
0 g
s
.616 .552 .759 r
.58705 1.08805 m .56659 1.06811 L .60781 1.01625 L p F P
0 g
s
.624 .562 .765 r
.58353 .99916 m .60781 1.01625 L .56659 1.06811 L p F P
0 g
s
.249 .029 .371 r
.58832 1.26707 m .59089 1.24958 L .6575 1.19441 L p F P
0 g
s
.354 .182 .504 r
.65363 1.17859 m .6575 1.19441 L .59089 1.24958 L p F P
0 g
s
.629 .458 .633 r
.54414 .79379 m .52036 .79127 L .52489 .74754 L p F P
0 g
s
.629 .458 .633 r
.52489 .74754 m .54906 .74559 L .54414 .79379 L p F P
0 g
s
.604 .534 .749 r
.60577 1.10753 m .58705 1.08805 L .63105 1.03304 L p F P
0 g
s
.616 .552 .759 r
.60781 1.01625 m .63105 1.03304 L .58705 1.08805 L p F P
0 g
s
.624 .43 .6 r
.77388 .73986 m .74909 .74183 L .74375 .66795 L p F P
0 g
s
.624 .43 .6 r
.74375 .66795 m .76801 .66179 L .77388 .73986 L p F P
0 g
s
.604 .503 .712 r
.49043 .93219 m .47168 .91687 L .49304 .87821 L p F P
0 g
s
.569 .46 .69 r
.47502 .86775 m .49304 .87821 L .47168 .91687 L p F P
0 g
s
.588 .442 .649 r
.50956 .8356 m .48983 .8295 L .49955 .78971 L p F P
0 g
s
.588 .442 .649 r
.49955 .78971 m .52036 .79127 L .50956 .8356 L p F P
0 g
s
.582 .454 .671 r
.49304 .87821 m .47502 .86775 L .48983 .8295 L p F P
0 g
s
.583 .505 .732 r
.62219 1.12641 m .60577 1.10753 L .65258 1.04937 L p F P
0 g
s
.604 .534 .749 r
.63105 1.03304 m .65258 1.04937 L .60577 1.10753 L p F P
0 g
s
.582 .454 .671 r
.48983 .8295 m .50956 .8356 L .49304 .87821 L p F P
0 g
s
0 .027 .585 r
.82669 .43084 m .82815 .45166 L .78192 .37252 L p F P
0 g
s
0 .027 .585 r
.78192 .37252 m .7786 .34891 L .82669 .43084 L p F P
0 g
s
.585 .401 .599 r
.796 .73689 m .77388 .73986 L .76801 .66179 L p F P
0 g
s
.585 .401 .599 r
.76801 .66179 m .78961 .65459 L .796 .73689 L p F P
0 g
s
.655 .481 .637 r
.5704 .79711 m .54414 .79379 L .54906 .74559 L p F P
0 g
s
.655 .481 .637 r
.54906 .74559 m .57568 .74445 L .5704 .79711 L p F P
0 g
s
.627 .531 .726 r
.51164 .94829 m .49043 .93219 L .51403 .88962 L p F P
0 g
s
.604 .503 .712 r
.49304 .87821 m .51403 .88962 L .49043 .93219 L p F P
0 g
s
.029 .042 .537 r
.8515 .59974 m .84516 .61328 L .8205 .52725 L p F P
0 g
s
.029 .042 .537 r
.8205 .52725 m .8256 .50994 L .8515 .59974 L p F P
0 g
s
.552 .461 .705 r
.63584 1.14459 m .62219 1.12641 L .67183 1.06507 L p F P
0 g
s
.583 .505 .732 r
.65258 1.04937 m .67183 1.06507 L .62219 1.12641 L p F P
0 g
s
.627 .48 .663 r
.53226 .84266 m .50956 .8356 L .52036 .79127 L p F P
0 g
s
.627 .48 .663 r
.52036 .79127 m .54414 .79379 L .53226 .84266 L p F P
0 g
s
.619 .495 .689 r
.51403 .88962 m .49304 .87821 L .50956 .8356 L p F P
0 g
s
.671 .495 .64 r
.59852 .80103 m .5704 .79711 L .57568 .74445 L p F P
0 g
s
.671 .495 .64 r
.57568 .74445 m .60414 .7439 L .59852 .80103 L p F P
0 g
s
.036 0 0 r
.45182 1.38957 m .46798 1.37235 L .55172 1.33238 L p F P
0 g
s
.059 0 0 r
.56384 1.31646 m .55172 1.33238 L .46798 1.37235 L p F P
0 g
s
.527 .358 .595 r
.81515 .7328 m .796 .73689 L .78961 .65459 L p F P
0 g
s
.527 .358 .595 r
.78961 .65459 m .80823 .64621 L .81515 .7328 L p F P
0 g
s
.641 .549 .734 r
.5347 .96496 m .51164 .94829 L .5375 .90183 L p F P
0 g
s
.627 .531 .726 r
.51403 .88962 m .5375 .90183 L .51164 .94829 L p F P
0 g
s
.122 0 .209 r
.58268 1.28396 m .58832 1.26707 L .6581 1.2095 L p F P
0 g
s
.249 .029 .371 r
.6575 1.19441 m .6581 1.2095 L .58832 1.26707 L p F P
0 g
s
.619 .495 .689 r
.50956 .8356 m .53226 .84266 L .51403 .88962 L p F P
0 g
s
.679 .503 .641 r
.6278 .80532 m .59852 .80103 L .60414 .7439 L p F P
0 g
s
.679 .503 .641 r
.60414 .7439 m .63373 .74374 L .6278 .80532 L p F P
0 g
s
.506 .398 .665 r
.64639 1.16199 m .63584 1.14459 L .68834 1.08003 L p F P
0 g
s
.552 .461 .705 r
.67183 1.06507 m .68834 1.08003 L .63584 1.14459 L p F P
0 g
s
.649 .558 .739 r
.55891 .98199 m .5347 .96496 L .56284 .91462 L p F P
0 g
s
.641 .549 .734 r
.5375 .90183 m .56284 .91462 L .5347 .96496 L p F P
0 g
s
.682 .506 .641 r
.65751 .80975 m .6278 .80532 L .63373 .74374 L p F P
0 g
s
.682 .506 .641 r
.63373 .74374 m .66374 .7437 L .65751 .80975 L p F P
0 g
s
.652 .505 .67 r
.55745 .85052 m .53226 .84266 L .54414 .79379 L p F P
0 g
s
.652 .505 .67 r
.54414 .79379 m .5704 .79711 L .55745 .85052 L p F P
0 g
s
.643 .521 .7 r
.5375 .90183 m .51403 .88962 L .53226 .84266 L p F P
0 g
s
.652 .561 .74 r
.58353 .99916 m .55891 .98199 L .58934 .92779 L p F P
0 g
s
.649 .558 .739 r
.56284 .91462 m .58934 .92779 L .55891 .98199 L p F P
0 g
s
.679 .503 .641 r
.68691 .81406 m .65751 .80975 L .66374 .7437 L p F P
0 g
s
.679 .503 .641 r
.66374 .7437 m .69343 .74353 L .68691 .81406 L p F P
0 g
s
.442 .295 .585 r
.83113 .7275 m .81515 .7328 L .80823 .64621 L p F P
0 g
s
.442 .295 .585 r
.80823 .64621 m .8237 .63656 L .83113 .7275 L p F P
0 g
s
.649 .558 .739 r
.60781 1.01625 m .58353 .99916 L .61627 .9411 L p F P
0 g
s
.652 .561 .74 r
.58934 .92779 m .61627 .9411 L .58353 .99916 L p F P
0 g
s
.643 .521 .7 r
.53226 .84266 m .55745 .85052 L .5375 .90183 L p F P
0 g
s
.671 .496 .64 r
.7153 .81802 m .68691 .81406 L .69343 .74353 L p F P
0 g
s
.671 .496 .64 r
.69343 .74353 m .72209 .74299 L .7153 .81802 L p F P
0 g
s
0 0 .491 r
.85537 .58506 m .8515 .59974 L .8256 .50994 L p F P
0 g
s
0 0 .491 r
.8256 .50994 m .82823 .49145 L .85537 .58506 L p F P
0 g
s
.668 .52 .675 r
.58451 .85898 m .55745 .85052 L .5704 .79711 L p F P
0 g
s
.668 .52 .675 r
.5704 .79711 m .59852 .80103 L .58451 .85898 L p F P
0 g
s
.658 .538 .706 r
.56284 .91462 m .5375 .90183 L .55745 .85052 L p F P
0 g
s
.437 .304 .602 r
.65363 1.17859 m .64639 1.16199 L .70178 1.09417 L p F P
0 g
s
.506 .398 .665 r
.68834 1.08003 m .70178 1.09417 L .64639 1.16199 L p F P
0 g
s
.641 .549 .734 r
.63105 1.03304 m .60781 1.01625 L .64288 .95432 L p F P
0 g
s
.649 .558 .739 r
.61627 .9411 m .64288 .95432 L .60781 1.01625 L p F P
0 g
s
.655 .481 .637 r
.74204 .8214 m .7153 .81802 L .72209 .74299 L p F P
0 g
s
.655 .481 .637 r
.72209 .74299 m .74909 .74183 L .74204 .8214 L p F P
0 g
s
.658 .538 .706 r
.55745 .85052 m .58451 .85898 L .56284 .91462 L p F P
0 g
s
.628 .531 .726 r
.65258 1.04937 m .63105 1.03304 L .66847 .96724 L p F P
0 g
s
.641 .549 .734 r
.64288 .95432 m .66847 .96724 L .63105 1.03304 L p F P
0 g
s
.676 .529 .677 r
.61274 .86781 m .58451 .85898 L .59852 .80103 L p F P
0 g
s
.676 .529 .677 r
.59852 .80103 m .6278 .80532 L .61274 .86781 L p F P
0 g
s
0 0 .039 r
.57436 1.30038 m .58268 1.28396 L .65566 1.22395 L p F P
0 g
s
.122 0 .209 r
.6581 1.2095 m .65566 1.22395 L .58268 1.28396 L p F P
0 g
s
.666 .547 .71 r
.58934 .92779 m .56284 .91462 L .58451 .85898 L p F P
0 g
s
.036 0 0 r
.55172 1.33238 m .53871 1.34831 L .45182 1.38957 L p F P
0 g
s
.63 .459 .633 r
.76655 .82401 m .74204 .8214 L .74909 .74183 L p F P
0 g
s
.63 .459 .633 r
.74909 .74183 m .77388 .73986 L .76655 .82401 L p F P
0 g
s
.679 .532 .678 r
.6414 .87678 m .61274 .86781 L .6278 .80532 L p F P
0 g
s
.679 .532 .678 r
.6278 .80532 m .65751 .80975 L .6414 .87678 L p F P
0 g
s
.317 .203 .562 r
.84391 .72094 m .83113 .7275 L .8237 .63656 L p F P
0 g
s
.317 .203 .562 r
.8237 .63656 m .83598 .62558 L .84391 .72094 L p F P
0 g
s
.669 .55 .711 r
.61627 .9411 m .58934 .92779 L .61274 .86781 L p F P
0 g
s
.666 .547 .71 r
.58451 .85898 m .61274 .86781 L .58934 .92779 L p F P
0 g
s
.605 .504 .712 r
.67183 1.06507 m .65258 1.04937 L .69237 .97966 L p F P
0 g
s
.628 .531 .726 r
.66847 .96724 m .69237 .97966 L .65258 1.04937 L p F P
0 g
s
.676 .529 .677 r
.66976 .88565 m .6414 .87678 L .65751 .80975 L p F P
0 g
s
.676 .529 .677 r
.65751 .80975 m .68691 .81406 L .66976 .88565 L p F P
0 g
s
.334 .17 .504 r
.6575 1.19441 m .65363 1.17859 L .71194 1.10745 L p F P
0 g
s
.437 .304 .602 r
.70178 1.09417 m .71194 1.10745 L .65363 1.17859 L p F P
0 g
s
.666 .547 .71 r
.64288 .95432 m .61627 .9411 L .6414 .87678 L p F P
0 g
s
.669 .55 .711 r
.61274 .86781 m .6414 .87678 L .61627 .9411 L p F P
0 g
s
.591 .426 .626 r
.7884 .82569 m .76655 .82401 L .77388 .73986 L p F P
0 g
s
.591 .426 .626 r
.77388 .73986 m .796 .73689 L .7884 .82569 L p F P
0 g
s
.668 .52 .675 r
.6971 .8942 m .66976 .88565 L .68691 .81406 L p F P
0 g
s
.668 .52 .675 r
.68691 .81406 m .7153 .81802 L .6971 .8942 L p F P
0 g
s
.572 .462 .69 r
.68834 1.08003 m .67183 1.06507 L .71402 .99142 L p F P
0 g
s
.605 .504 .712 r
.69237 .97966 m .71402 .99142 L .67183 1.06507 L p F P
0 g
s
.658 .538 .706 r
.66847 .96724 m .64288 .95432 L .66976 .88565 L p F P
0 g
s
.666 .547 .71 r
.6414 .87678 m .66976 .88565 L .64288 .95432 L p F P
0 g
s
0 0 .44 r
.85725 .56941 m .85537 .58506 L .82823 .49145 L p F P
0 g
s
0 0 .44 r
.82823 .49145 m .82889 .47195 L .85725 .56941 L p F P
0 g
s
.653 .505 .67 r
.72278 .90221 m .6971 .8942 L .7153 .81802 L p F P
0 g
s
.653 .505 .67 r
.7153 .81802 m .74204 .8214 L .72278 .90221 L p F P
0 g
s
.644 .522 .7 r
.69237 .97966 m .66847 .96724 L .6971 .8942 L p F P
0 g
s
.658 .538 .706 r
.66976 .88565 m .6971 .8942 L .66847 .96724 L p F P
0 g
s
.144 .077 .516 r
.85359 .71315 m .84391 .72094 L .83598 .62558 L p F P
0 g
s
.144 .077 .516 r
.83598 .62558 m .84516 .61328 L .85359 .71315 L p F P
0 g
s
.533 .376 .613 r
.80726 .82632 m .7884 .82569 L .796 .73689 L p F P
0 g
s
.533 .376 .613 r
.796 .73689 m .81515 .7328 L .80726 .82632 L p F P
0 g
s
0 0 0 r
.56384 1.31646 m .57436 1.30038 L .65055 1.23788 L p F P
0 g
s
0 0 .039 r
.65566 1.22395 m .65055 1.23788 L .57436 1.30038 L p F P
0 g
s
.52 .399 .656 r
.70178 1.09417 m .68834 1.08003 L .73297 1.00238 L p F P
0 g
s
.572 .462 .69 r
.71402 .99142 m .73297 1.00238 L .68834 1.08003 L p F P
0 g
s
.189 0 .36 r
.6581 1.2095 m .6575 1.19441 L .71877 1.11988 L p F P
0 g
s
.334 .17 .504 r
.71194 1.10745 m .71877 1.11988 L .6575 1.19441 L p F P
0 g
s
.628 .481 .663 r
.74623 .90951 m .72278 .90221 L .74204 .8214 L p F P
0 g
s
.628 .481 .663 r
.74204 .8214 m .76655 .82401 L .74623 .90951 L p F P
0 g
s
.644 .522 .7 r
.6971 .8942 m .72278 .90221 L .69237 .97966 L p F P
0 g
s
.62 .496 .689 r
.71402 .99142 m .69237 .97966 L .72278 .90221 L p F P
0 g
s
.444 .3 .59 r
.82294 .82582 m .80726 .82632 L .81515 .7328 L p F P
0 g
s
.444 .3 .59 r
.81515 .7328 m .83113 .7275 L .82294 .82582 L p F P
0 g
s
.62 .496 .689 r
.72278 .90221 m .74623 .90951 L .71402 .99142 L p F P
0 g
s
.591 .444 .651 r
.767 .91594 m .74623 .90951 L .76655 .82401 L p F P
0 g
s
.591 .444 .651 r
.76655 .82401 m .7884 .82569 L .767 .91594 L p F P
0 g
s
.584 .456 .672 r
.73297 1.00238 m .71402 .99142 L .74623 .90951 L p F P
0 g
s
.441 .305 .6 r
.71194 1.10745 m .70178 1.09417 L .74887 1.01245 L p F P
0 g
s
.52 .399 .656 r
.73297 1.00238 m .74887 1.01245 L .70178 1.09417 L p F P
0 g
s
0 0 .398 r
.85773 .553 m .85725 .56941 L .82889 .47195 L p F P
0 g
s
0 0 .398 r
.82889 .47195 m .82815 .45166 L .85773 .553 L p F P
0 g
s
0 0 .438 r
.86041 .70418 m .85359 .71315 L .84516 .61328 L p F P
0 g
s
0 0 .438 r
.84516 .61328 m .8515 .59974 L .86041 .70418 L p F P
0 g
s
.584 .456 .672 r
.74623 .90951 m .767 .91594 L .73297 1.00238 L p F P
0 g
s
0 0 0 r
.55172 1.33238 m .56384 1.31646 L .64326 1.25144 L p F P
0 g
s
0 0 0 r
.65055 1.23788 m .64326 1.25144 L .56384 1.31646 L p F P
0 g
s
.004 0 .17 r
.65566 1.22395 m .6581 1.2095 L .72236 1.13151 L p F P
0 g
s
.189 0 .36 r
.71877 1.11988 m .72236 1.13151 L .6581 1.2095 L p F P
0 g
s
.533 .388 .63 r
.78476 .9214 m .767 .91594 L .7884 .82569 L p F P
0 g
s
.533 .388 .63 r
.7884 .82569 m .80726 .82632 L .78476 .9214 L p F P
0 g
s
.529 .396 .644 r
.74887 1.01245 m .73297 1.00238 L .767 .91594 L p F P
0 g
s
.308 .185 .545 r
.8354 .82416 m .82294 .82582 L .83113 .7275 L p F P
0 g
s
.308 .185 .545 r
.83113 .7275 m .84391 .72094 L .8354 .82416 L p F P
0 g
s
.319 .164 .508 r
.71877 1.11988 m .71194 1.10745 L .76153 1.02159 L p F P
0 g
s
.441 .305 .6 r
.74887 1.01245 m .76153 1.02159 L .71194 1.10745 L p F P
0 g
s
.529 .396 .644 r
.767 .91594 m .78476 .9214 L .74887 1.01245 L p F P
0 g
s
.444 .303 .594 r
.79931 .92583 m .78476 .9214 L .80726 .82632 L p F P
0 g
s
.444 .303 .594 r
.80726 .82632 m .82294 .82582 L .79931 .92583 L p F P
0 g
s
0 0 .336 r
.86473 .69416 m .86041 .70418 L .8515 .59974 L p F P
0 g
s
0 0 .336 r
.8515 .59974 m .85537 .58506 L .86473 .69416 L p F P
0 g
s
0 0 .375 r
.8575 .53609 m .85773 .553 L .82815 .45166 L p F P
0 g
s
0 0 .375 r
.82815 .45166 m .82669 .43084 L .8575 .53609 L p F P
0 g
s
.443 .305 .597 r
.76153 1.02159 m .74887 1.01245 L .78476 .9214 L p F P
0 g
s
0 0 0 r
.65055 1.23788 m .65566 1.22395 L .72295 1.14242 L p F P
0 g
s
.004 0 .17 r
.72236 1.13151 m .72295 1.14242 L .65566 1.22395 L p F P
0 g
s
.11 .021 .464 r
.84473 .82137 m .8354 .82416 L .84391 .72094 L p F P
0 g
s
.11 .021 .464 r
.84391 .72094 m .85359 .71315 L .84473 .82137 L p F P
0 g
s
0 0 0 r
.53871 1.34831 m .55172 1.33238 L .6344 1.2648 L p F P
0 g
s
0 0 0 r
.64326 1.25144 m .6344 1.2648 L .55172 1.33238 L p F P
0 g
s
.443 .305 .597 r
.78476 .9214 m .79931 .92583 L .76153 1.02159 L p F P
0 g
s
.139 0 .363 r
.72236 1.13151 m .71877 1.11988 L .77091 1.02978 L p F P
0 g
s
.319 .164 .508 r
.76153 1.02159 m .77091 1.02978 L .71877 1.11988 L p F P
0 g
s
.305 .172 .529 r
.8106 .92921 m .79931 .92583 L .82294 .82582 L p F P
0 g
s
.305 .172 .529 r
.82294 .82582 m .8354 .82416 L .8106 .92921 L p F P
0 g
s
.309 .165 .517 r
.77091 1.02978 m .76153 1.02159 L .79931 .92583 L p F P
0 g
s
0 0 .236 r
.86706 .68325 m .86473 .69416 L .85537 .58506 L p F P
0 g
s
0 0 .236 r
.85537 .58506 m .85725 .56941 L .86706 .68325 L p F P
0 g
s
.309 .165 .517 r
.79931 .92583 m .8106 .92921 L .77091 1.02978 L p F P
0 g
s
0 0 .336 r
.85117 .81751 m .84473 .82137 L .85359 .71315 L p F P
0 g
s
0 0 .336 r
.85359 .71315 m .86041 .70418 L .85117 .81751 L p F P
0 g
s
0 0 0 r
.64326 1.25144 m .65055 1.23788 L .72089 1.15274 L p F P
0 g
s
0 0 0 r
.72295 1.14242 m .72089 1.15274 L .65055 1.23788 L p F P
0 g
s
0 0 .159 r
.72295 1.14242 m .72236 1.13151 L .77708 1.03707 L p F P
0 g
s
.139 0 .363 r
.77091 1.02978 m .77708 1.03707 L .72236 1.13151 L p F P
0 g
s
0 0 0 r
.6344 1.2648 m .62467 1.27815 L .53871 1.34831 L p F P
0 g
s
.097 0 .417 r
.81874 .93158 m .8106 .92921 L .8354 .82416 L p F P
0 g
s
.097 0 .417 r
.8354 .82416 m .84473 .82137 L .81874 .93158 L p F P
0 g
s
.107 0 .383 r
.77708 1.03707 m .77091 1.02978 L .8106 .92921 L p F P
0 g
s
.107 0 .383 r
.8106 .92921 m .81874 .93158 L .77708 1.03707 L p F P
0 g
s
0 0 .162 r
.86799 .67165 m .86706 .68325 L .85725 .56941 L p F P
0 g
s
0 0 .162 r
.85725 .56941 m .85773 .553 L .86799 .67165 L p F P
0 g
s
0 0 .178 r
.8551 .81271 m .85117 .81751 L .86041 .70418 L p F P
0 g
s
0 0 .178 r
.86041 .70418 m .86473 .69416 L .8551 .81271 L p F P
0 g
s
0 0 0 r
.72089 1.15274 m .72295 1.14242 L .78029 1.04354 L p F P
0 g
s
0 0 .159 r
.77708 1.03707 m .78029 1.04354 L .72295 1.14242 L p F P
0 g
s
0 0 0 r
.6344 1.2648 m .64326 1.25144 L .7167 1.16261 L p F P
0 g
s
0 0 0 r
.72089 1.15274 m .7167 1.16261 L .64326 1.25144 L p F P
0 g
s
0 0 .246 r
.82395 .933 m .81874 .93158 L .84473 .82137 L p F P
0 g
s
0 0 .246 r
.84473 .82137 m .85117 .81751 L .82395 .933 L p F P
0 g
s
0 0 .185 r
.78029 1.04354 m .77708 1.03707 L .81874 .93158 L p F P
0 g
s
0 0 .185 r
.81874 .93158 m .82395 .933 L .78029 1.04354 L p F P
0 g
s
0 0 .125 r
.86819 .65961 m .86799 .67165 L .85773 .553 L p F P
0 g
s
0 0 .125 r
.85773 .553 m .8575 .53609 L .86819 .65961 L p F P
0 g
s
0 0 .037 r
.85701 .80712 m .8551 .81271 L .86473 .69416 L p F P
0 g
s
0 0 .037 r
.86473 .69416 m .86706 .68325 L .85701 .80712 L p F P
0 g
s
0 0 0 r
.7167 1.16261 m .72089 1.15274 L .7809 1.04931 L p F P
0 g
s
0 0 0 r
.78029 1.04354 m .7809 1.04931 L .72089 1.15274 L p F P
0 g
s
0 0 0 r
.62467 1.27815 m .6344 1.2648 L .71098 1.17222 L p F P
0 g
s
0 0 0 r
.7167 1.16261 m .71098 1.17222 L .6344 1.2648 L p F P
0 g
s
0 0 .046 r
.82662 .9336 m .82395 .933 L .85117 .81751 L p F P
0 g
s
0 0 .046 r
.85117 .81751 m .8551 .81271 L .82662 .9336 L p F P
0 g
s
0 0 0 r
.7809 1.04931 m .78029 1.04354 L .82395 .933 L p F P
0 g
s
0 0 0 r
.82395 .933 m .82662 .9336 L .7809 1.04931 L p F P
0 g
s
.706 .623 .058 r
.8575 .80095 m .85701 .80712 L .86706 .68325 L p F P
0 g
s
.706 .623 .058 r
.86706 .68325 m .86799 .67165 L .8575 .80095 L p F P
0 g
s
0 0 0 r
.7809 1.04931 m .77942 1.05453 L .7167 1.16261 L p F P
0 g
s
.62 .797 .364 r
.71098 1.17222 m .7167 1.16261 L .77942 1.05453 L p F P
0 g
s
0 0 0 r
.71098 1.17222 m .70441 1.18176 L .62467 1.27815 L p F P
0 g
s
0 0 0 r
.82723 .93353 m .82662 .9336 L .8551 .81271 L p F P
0 g
s
0 0 0 r
.8551 .81271 m .85701 .80712 L .82723 .93353 L p F P
0 g
s
0 0 0 r
.77942 1.05453 m .7809 1.04931 L .82662 .9336 L p F P
0 g
s
0 0 0 r
.82662 .9336 m .82723 .93353 L .77942 1.05453 L p F P
0 g
s
.754 .658 .103 r
.85725 .79442 m .8575 .80095 L .86799 .67165 L p F P
0 g
s
.754 .658 .103 r
.86799 .67165 m .86819 .65961 L .85725 .79442 L p F P
0 g
s
.666 .836 .417 r
.70441 1.18176 m .71098 1.17222 L .77644 1.0594 L p F P
0 g
s
.62 .797 .364 r
.77942 1.05453 m .77644 1.0594 L .71098 1.17222 L p F P
0 g
s
.751 .744 .225 r
.82638 .93299 m .82723 .93353 L .85701 .80712 L p F P
0 g
s
.751 .744 .225 r
.85701 .80712 m .8575 .80095 L .82638 .93299 L p F P
0 g
s
.722 .802 .329 r
.77644 1.0594 m .77942 1.05453 L .82723 .93353 L p F P
0 g
s
.722 .802 .329 r
.82723 .93353 m .82638 .93299 L .77644 1.0594 L p F P
0 g
s
.666 .836 .417 r
.77644 1.0594 m .77267 1.06411 L .70441 1.18176 L p F P
0 g
s
.796 .778 .273 r
.82477 .93221 m .82638 .93299 L .8575 .80095 L p F P
0 g
s
.796 .778 .273 r
.8575 .80095 m .85725 .79442 L .82477 .93221 L p F P
0 g
s
.766 .837 .378 r
.77267 1.06411 m .77644 1.0594 L .82638 .93299 L p F P
0 g
s
.766 .837 .378 r
.82638 .93299 m .82477 .93221 L .77267 1.06411 L p F P
0 g
s
.25 Mabswid
1 1.29954 m
.15294 1.54568 L
s
.15294 1.54568 m
0 1.51878 L
s
0 1.51878 m
.83674 1.2575 L
s
.83674 1.2575 m
1 1.29954 L
s
.93565 .07331 m
.79022 0 L
s
.79022 0 m
.83674 1.2575 L
s
.83674 1.2575 m
1 1.29954 L
s
1 1.29954 m
.93565 .07331 L
s
.93565 .07331 m
1 1.29954 L
s
.94248 .20342 m
.9335 .20839 L
s
[(-5)] .96043 .19348 -1 .5534 Mshowa
.96573 .64648 m
.95636 .65067 L
s
[(0)] .98447 .63812 -1 .44631 Mshowa
.99129 1.13363 m
.98155 1.13685 L
s
[(5)] 1.01078 1.1272 -1 .32991 Mshowa
.125 Mabswid
.94696 .28879 m
.94153 .29169 L
s
.95152 .37574 m
.94604 .37855 L
s
.95617 .46431 m
.95064 .46702 L
s
.9609 .55454 m
.95533 .55715 L
s
.97065 .74018 m
.96498 .74259 L
s
.97566 .8357 m
.96994 .83799 L
s
.98077 .93307 m
.97501 .93524 L
s
.98598 1.03236 m
.98018 1.03442 L
s
.93808 .11957 m
.93274 .12264 L
s
.99671 1.23693 m
.99083 1.23873 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.44.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.44.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the surface of revolution of a curve in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " plane described parametrically with the variable ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.44.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
SurfaceOfRevolution[{1.1 Sin[u], u^2},
  {u, 0, 3 Pi/2}, BoxRatios -> {1, 1, 2}]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.44.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.62453 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.30443 1.63518 -0.0106411 1.63518 [
[.41601 1.63527 -6.08277 0 ]
[.41601 1.63527 5.91723 9 ]
[.54629 1.60346 -11.9433 0 ]
[.54629 1.60346 12.0567 9 ]
[.67989 1.57083 -2.92832 0 ]
[.67989 1.57083 3.07168 9 ]
[.81693 1.53736 -8.6063 0 ]
[.81693 1.53736 9.3937 9 ]
[.95757 1.50299 -2.80706 0 ]
[.95757 1.50299 3.19294 9 ]
[.02631 1.36977 -6.43105 0 ]
[.02631 1.36977 5.56895 9 ]
[.11423 1.4389 -12.6993 0 ]
[.11423 1.4389 11.3007 9 ]
[.1979 1.5047 -3.13684 0 ]
[.1979 1.5047 2.86316 9 ]
[.27763 1.56739 -9.30394 0 ]
[.27763 1.56739 8.69606 9 ]
[.35368 1.62718 -3.06802 0 ]
[.35368 1.62718 2.93198 9 ]
[.06357 .25073 -6 -2.74334 ]
[.06357 .25073 0 6.25666 ]
[.04766 .45754 -6 -2.83401 ]
[.04766 .45754 0 6.16599 ]
[.03054 .68008 -12 -2.9319 ]
[.03054 .68008 0 6.0681 ]
[.01208 .92021 -12 -3.03791 ]
[.01208 .92021 0 5.96209 ]
[-0.00791 1.18012 -12 -3.1531 ]
[-0.00791 1.18012 0 5.8469 ]
[ 0 0 0 0 ]
[ 1 1.62453 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.37669 1.62453 m
1 1.47188 L
s
.4163 1.61484 m
.41644 1.60462 L
s
[(-1)] .41601 1.63527 .01379 -1 Mshowa
.54619 1.58302 m
.54614 1.5728 L
s
[(-0.5)] .54629 1.60346 -0.00473 -1 Mshowa
.6794 1.5504 m
.67915 1.54018 L
s
[(0)] .67989 1.57083 -0.02389 -1 Mshowa
.81604 1.51694 m
.81559 1.50673 L
s
[(0.5)] .81693 1.53736 -0.04374 -1 Mshowa
.95626 1.4826 m
.9556 1.4724 L
s
[(1)] .95757 1.50299 -0.06431 -1 Mshowa
.125 Mabswid
.44202 1.60854 m
.44208 1.6024 L
s
.46786 1.60221 m
.4679 1.59607 L
s
.49384 1.59584 m
.49386 1.58971 L
s
.51995 1.58945 m
.51995 1.58332 L
s
.57256 1.57656 m
.57251 1.57043 L
s
.59907 1.57007 m
.59899 1.56394 L
s
.62571 1.56355 m
.62561 1.55742 L
s
.65249 1.55699 m
.65236 1.55086 L
s
.70645 1.54378 m
.70628 1.53765 L
s
.73363 1.53712 m
.73344 1.53099 L
s
.76096 1.53042 m
.76074 1.5243 L
s
.78843 1.5237 m
.78819 1.51757 L
s
.84379 1.51014 m
.8435 1.50401 L
s
.87169 1.50331 m
.87137 1.49718 L
s
.89973 1.49644 m
.89939 1.49032 L
s
.92792 1.48953 m
.92755 1.48341 L
s
.3907 1.6211 m
.39081 1.61497 L
s
.98474 1.47562 m
.98432 1.4695 L
s
.25 Mabswid
0 1.32748 m
.37669 1.62453 L
s
.02777 1.34938 m
.0285 1.33919 L
s
[(-1)] .02631 1.36977 .07184 -1 Mshowa
.11542 1.4185 m
.11601 1.4083 L
s
[(-0.5)] .11423 1.4389 .05827 -1 Mshowa
.19883 1.48428 m
.1993 1.47407 L
s
[(0)] .1979 1.5047 .04561 -1 Mshowa
.27832 1.54696 m
.27866 1.53674 L
s
[(0.5)] .27763 1.56739 .03377 -1 Mshowa
.35414 1.60675 m
.35437 1.59653 L
s
[(1)] .35368 1.62718 .02267 -1 Mshowa
.125 Mabswid
.04565 1.36348 m
.04608 1.35737 L
s
.06336 1.37745 m
.06376 1.37133 L
s
.08089 1.39127 m
.08127 1.38515 L
s
.09824 1.40495 m
.09861 1.39883 L
s
.13243 1.43191 m
.13277 1.42579 L
s
.14928 1.4452 m
.1496 1.43907 L
s
.16596 1.45835 m
.16627 1.45223 L
s
.18247 1.47138 m
.18277 1.46525 L
s
.21504 1.49706 m
.2153 1.49093 L
s
.23108 1.50971 m
.23133 1.50358 L
s
.24698 1.52224 m
.24721 1.51612 L
s
.26272 1.53466 m
.26294 1.52853 L
s
.29377 1.55914 m
.29396 1.55301 L
s
.30907 1.57121 m
.30925 1.56508 L
s
.32423 1.58317 m
.3244 1.57704 L
s
.33925 1.59501 m
.33941 1.58888 L
s
.00971 1.33514 m
.01016 1.32902 L
s
.36889 1.61838 m
.36901 1.61225 L
s
.25 Mabswid
.0843 .2212 m
0 1.32748 L
s
.08261 .2433 m
.09213 .23959 L
s
[(0)] .06357 .25073 1 -0.39037 Mshowa
.06683 .45044 m
.07641 .4469 L
s
[(5)] .04766 .45754 1 -0.37022 Mshowa
.04984 .67335 m
.05949 .66999 L
s
[(10)] .03054 .68008 1 -0.34847 Mshowa
.03151 .9139 m
.04123 .91074 L
s
[(15)] .01208 .92021 1 -0.32491 Mshowa
.01168 1.17426 m
.02147 1.17133 L
s
[(20)] -0.00791 1.18012 1 -0.29931 Mshowa
.125 Mabswid
.07955 .28355 m
.08527 .28134 L
s
.07644 .32438 m
.08216 .32219 L
s
.07328 .36579 m
.07901 .36362 L
s
.07008 .40781 m
.07582 .40566 L
s
.06353 .49371 m
.06929 .4916 L
s
.06019 .53762 m
.06595 .53553 L
s
.05679 .58218 m
.06256 .58012 L
s
.05334 .62742 m
.05913 .62538 L
s
.04629 .71999 m
.05209 .71799 L
s
.04268 .76734 m
.04849 .76537 L
s
.03902 .81543 m
.04483 .81349 L
s
.0353 .86428 m
.04112 .86236 L
s
.02767 .96431 m
.03351 .96244 L
s
.02377 1.01553 m
.02962 1.01369 L
s
.0198 1.06758 m
.02566 1.06577 L
s
.01577 1.12049 m
.02164 1.1187 L
s
.00751 1.22893 m
.01339 1.2272 L
s
.00327 1.28451 m
.00917 1.28281 L
s
.25 Mabswid
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.37669 1.62453 L
s
.37669 1.62453 m
.3971 .57309 L
s
.3971 .57309 m
.0843 .2212 L
s
.64785 0 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.64785 0 m
.0843 .2212 L
s
.3971 .57309 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.37669 1.62453 L
s
.37669 1.62453 m
.3971 .57309 L
s
0 0 m
1 0 L
1 1.62453 L
0 1.62453 L
closepath
clip
newpath
.5 Mabswid
.742 .565 .653 r
.42502 .59441 m .42787 .57121 L .48617 .57897 L p F P
0 g
s
.742 .565 .653 r
.48617 .57897 m .48527 .60238 L .42502 .59441 L p F P
0 g
s
.737 .608 .714 r
.48774 .55315 m .48617 .57897 L .42787 .57121 L p F P
0 g
s
.704 .532 .653 r
.48527 .60238 m .48617 .57897 L .54556 .57865 L p F P
0 g
s
.706 .581 .713 r
.48617 .57897 m .48774 .55315 L .5437 .55284 L p F P
0 g
s
.706 .581 .713 r
.5437 .55284 m .54556 .57865 L .48617 .57897 L p F P
0 g
s
.704 .532 .653 r
.54556 .57865 m .54663 .60205 L .48527 .60238 L p F P
0 g
s
.663 .5 .654 r
.54663 .60205 m .54556 .57865 L .60366 .57025 L p F P
0 g
s
.673 .556 .714 r
.54556 .57865 m .5437 .55284 L .59842 .54487 L p F P
0 g
s
.673 .556 .714 r
.59842 .54487 m .60366 .57025 L .54556 .57865 L p F P
0 g
s
.737 .608 .714 r
.42787 .57121 m .43283 .54578 L .48774 .55315 L p F P
0 g
s
.729 .639 .759 r
.48996 .52506 m .48774 .55315 L .43283 .54578 L p F P
0 g
s
.704 .617 .757 r
.48774 .55315 m .48996 .52506 L .54107 .52477 L p F P
0 g
s
.704 .617 .757 r
.54107 .52477 m .5437 .55284 L .48774 .55315 L p F P
0 g
s
.678 .598 .759 r
.5437 .55284 m .54107 .52477 L .59105 .51744 L p F P
0 g
s
.678 .598 .759 r
.59105 .51744 m .59842 .54487 L .5437 .55284 L p F P
0 g
s
.742 .505 .571 r
.42435 .61535 m .42502 .59441 L .48527 .60238 L p F P
0 g
s
.742 .505 .571 r
.48527 .60238 m .48506 .62333 L .42435 .61535 L p F P
0 g
s
.694 .465 .571 r
.48506 .62333 m .48527 .60238 L .54663 .60205 L p F P
0 g
s
.694 .465 .571 r
.54663 .60205 m .54689 .623 L .48506 .62333 L p F P
0 g
s
.643 .424 .57 r
.54689 .623 m .54663 .60205 L .60667 .59342 L p F P
0 g
s
.663 .5 .654 r
.60366 .57025 m .60667 .59342 L .54663 .60205 L p F P
0 g
s
.729 .639 .759 r
.43283 .54578 m .4398 .51827 L .48996 .52506 L p F P
0 g
s
.72 .662 .792 r
.49277 .49493 m .48996 .52506 L .4398 .51827 L p F P
0 g
s
.701 .645 .791 r
.48996 .52506 m .49277 .49493 L .53774 .49468 L p F P
0 g
s
.701 .645 .791 r
.53774 .49468 m .54107 .52477 L .48996 .52506 L p F P
0 g
s
.68 .63 .792 r
.54107 .52477 m .53774 .49468 L .5817 .48817 L p F P
0 g
s
.68 .63 .792 r
.5817 .48817 m .59105 .51744 L .54107 .52477 L p F P
0 g
s
.781 .6 .656 r
.36831 .5784 m .37301 .55561 L .42787 .57121 L p F P
0 g
s
.781 .6 .656 r
.42787 .57121 m .42502 .59441 L .36831 .5784 L p F P
0 g
s
.767 .638 .718 r
.43283 .54578 m .42787 .57121 L .37301 .55561 L p F P
0 g
s
.767 .638 .718 r
.37301 .55561 m .38119 .53099 L .43283 .54578 L p F P
0 g
s
.753 .664 .763 r
.4398 .51827 m .43283 .54578 L .38119 .53099 L p F P
0 g
s
.617 .468 .656 r
.60667 .59342 m .60366 .57025 L .65812 .55405 L p F P
0 g
s
.638 .533 .719 r
.60366 .57025 m .59842 .54487 L .64967 .52951 L p F P
0 g
s
.638 .533 .719 r
.64967 .52951 m .65812 .55405 L .60366 .57025 L p F P
0 g
s
.651 .581 .764 r
.59842 .54487 m .59105 .51744 L .63782 .5033 L p F P
0 g
s
.651 .581 .764 r
.63782 .5033 m .64967 .52951 L .59842 .54487 L p F P
0 g
s
.789 .546 .568 r
.36721 .59931 m .36831 .5784 L .42502 .59441 L p F P
0 g
s
.789 .546 .568 r
.42502 .59441 m .42435 .61535 L .36721 .59931 L p F P
0 g
s
.753 .664 .763 r
.38119 .53099 m .39268 .50467 L .4398 .51827 L p F P
0 g
s
.738 .682 .796 r
.44865 .48892 m .4398 .51827 L .39268 .50467 L p F P
0 g
s
.72 .662 .792 r
.4398 .51827 m .44865 .48892 L .49277 .49493 L p F P
0 g
s
.643 .424 .57 r
.60667 .59342 m .60738 .61436 L .54689 .623 L p F P
0 g
s
.584 .378 .568 r
.60738 .61436 m .60667 .59342 L .66296 .57679 L p F P
0 g
s
.617 .468 .656 r
.65812 .55405 m .66296 .57679 L .60667 .59342 L p F P
0 g
s
.659 .617 .797 r
.59105 .51744 m .5817 .48817 L .6228 .47565 L p F P
0 g
s
.659 .617 .797 r
.6228 .47565 m .63782 .5033 L .59105 .51744 L p F P
0 g
s
.73 .423 .46 r
.42589 .63409 m .42435 .61535 L .48506 .62333 L p F P
0 g
s
.73 .423 .46 r
.48506 .62333 m .48554 .6419 L .42589 .63409 L p F P
0 g
s
.672 .376 .463 r
.48554 .6419 m .48506 .62333 L .54689 .623 L p F P
0 g
s
.672 .376 .463 r
.54689 .623 m .54631 .64157 L .48554 .6419 L p F P
0 g
s
.609 .324 .459 r
.54631 .64157 m .54689 .623 L .60738 .61436 L p F P
0 g
s
.711 .68 .817 r
.49611 .46313 m .49277 .49493 L .44865 .48892 L p F P
0 g
s
.696 .666 .816 r
.49277 .49493 m .49611 .46313 L .53377 .46292 L p F P
0 g
s
.696 .666 .816 r
.53377 .46292 m .53774 .49468 L .49277 .49493 L p F P
0 g
s
.68 .655 .818 r
.53774 .49468 m .53377 .46292 L .57057 .45742 L p F P
0 g
s
.68 .655 .818 r
.57057 .45742 m .5817 .48817 L .53774 .49468 L p F P
0 g
s
.797 .672 .725 r
.32389 .53273 m .335 .5093 L .38119 .53099 L p F P
0 g
s
.797 .672 .725 r
.38119 .53099 m .37301 .55561 L .32389 .53273 L p F P
0 g
s
.775 .691 .771 r
.39268 .50467 m .38119 .53099 L .335 .5093 L p F P
0 g
s
.82 .641 .659 r
.31751 .55489 m .32389 .53273 L .37301 .55561 L p F P
0 g
s
.82 .641 .659 r
.37301 .55561 m .36831 .5784 L .31751 .55489 L p F P
0 g
s
.599 .511 .726 r
.65812 .55405 m .64967 .52951 L .69531 .5073 L p F P
0 g
s
.621 .566 .772 r
.64967 .52951 m .63782 .5033 L .67939 .48289 L p F P
0 g
s
.621 .566 .772 r
.67939 .48289 m .69531 .5073 L .64967 .52951 L p F P
0 g
s
.738 .682 .796 r
.39268 .50467 m .40724 .47686 L .44865 .48892 L p F P
0 g
s
.725 .695 .821 r
.45918 .45805 m .44865 .48892 L .40724 .47686 L p F P
0 g
s
.711 .68 .817 r
.44865 .48892 m .45918 .45805 L .49611 .46313 L p F P
0 g
s
.786 .467 .448 r
.36974 .61841 m .36721 .59931 L .42435 .61535 L p F P
0 g
s
.786 .467 .448 r
.42435 .61535 m .42589 .63409 L .36974 .61841 L p F P
0 g
s
.664 .645 .822 r
.5817 .48817 m .57057 .45742 L .60492 .44686 L p F P
0 g
s
.664 .645 .822 r
.60492 .44686 m .6228 .47565 L .5817 .48817 L p F P
0 g
s
.565 .433 .66 r
.66296 .57679 m .65812 .55405 L .70665 .53061 L p F P
0 g
s
.599 .511 .726 r
.69531 .5073 m .70665 .53061 L .65812 .55405 L p F P
0 g
s
.609 .324 .459 r
.60738 .61436 m .60576 .63313 L .54631 .64157 L p F P
0 g
s
.532 .259 .446 r
.60576 .63313 m .60738 .61436 L .66411 .5977 L p F P
0 g
s
.584 .378 .568 r
.66296 .57679 m .66411 .5977 L .60738 .61436 L p F P
0 g
s
.775 .691 .771 r
.335 .5093 m .35059 .48473 L .39268 .50467 L p F P
0 g
s
.755 .704 .803 r
.40724 .47686 m .39268 .50467 L .35059 .48473 L p F P
0 g
s
.636 .607 .804 r
.63782 .5033 m .6228 .47565 L .65925 .45757 L p F P
0 g
s
.636 .607 .804 r
.65925 .45757 m .67939 .48289 L .63782 .5033 L p F P
0 g
s
.839 .59 .563 r
.316 .57576 m .31751 .55489 L .36831 .5784 L p F P
0 g
s
.839 .59 .563 r
.36831 .5784 m .36721 .59931 L .316 .57576 L p F P
0 g
s
.512 .324 .562 r
.66411 .5977 m .66296 .57679 L .71316 .55272 L p F P
0 g
s
.565 .433 .66 r
.70665 .53061 m .71316 .55272 L .66296 .57679 L p F P
0 g
s
.701 .319 .321 r
.42962 .65079 m .42589 .63409 L .48554 .6419 L p F P
0 g
s
.701 .319 .321 r
.48554 .6419 m .48673 .65823 L .42962 .65079 L p F P
0 g
s
.634 .266 .329 r
.48673 .65823 m .48554 .6419 L .54631 .64157 L p F P
0 g
s
.634 .266 .329 r
.54631 .64157 m .54491 .65792 L .48673 .65823 L p F P
0 g
s
.556 .2 .32 r
.54491 .65792 m .54631 .64157 L .60576 .63313 L p F P
0 g
s
.703 .693 .838 r
.49993 .43011 m .49611 .46313 L .45918 .45805 L p F P
0 g
s
.692 .683 .837 r
.49611 .46313 m .49993 .43011 L .52925 .42994 L p F P
0 g
s
.692 .683 .837 r
.52925 .42994 m .53377 .46292 L .49611 .46313 L p F P
0 g
s
.68 .675 .838 r
.53377 .46292 m .52925 .42994 L .55787 .42562 L p F P
0 g
s
.68 .675 .838 r
.55787 .42562 m .57057 .45742 L .53377 .46292 L p F P
0 g
s
.755 .704 .803 r
.35059 .48473 m .37032 .4592 L .40724 .47686 L p F P
0 g
s
.738 .712 .827 r
.42457 .44788 m .40724 .47686 L .37032 .4592 L p F P
0 g
s
.725 .695 .821 r
.40724 .47686 m .42457 .44788 L .45918 .45805 L p F P
0 g
s
.646 .638 .828 r
.6228 .47565 m .60492 .44686 L .63532 .43163 L p F P
0 g
s
.646 .638 .828 r
.63532 .43163 m .65925 .45757 L .6228 .47565 L p F P
0 g
s
.713 .705 .841 r
.4712 .42612 m .45918 .45805 L .42457 .44788 L p F P
0 g
s
.703 .693 .838 r
.45918 .45805 m .4712 .42612 L .49993 .43011 L p F P
0 g
s
.667 .668 .841 r
.57057 .45742 m .55787 .42562 L .58456 .41733 L p F P
0 g
s
.667 .668 .841 r
.58456 .41733 m .60492 .44686 L .57057 .45742 L p F P
0 g
s
.843 .51 .423 r
.31945 .5954 m .316 .57576 L .36721 .59931 L p F P
0 g
s
.843 .51 .423 r
.36721 .59931 m .36974 .61841 L .31945 .5954 L p F P
0 g
s
.761 .361 .294 r
.3759 .63586 m .36974 .61841 L .42589 .63409 L p F P
0 g
s
.761 .361 .294 r
.42589 .63409 m .42962 .65079 L .3759 .63586 L p F P
0 g
s
.532 .259 .446 r
.66411 .5977 m .66149 .61684 L .60576 .63313 L p F P
0 g
s
.431 .173 .42 r
.66149 .61684 m .66411 .5977 L .7147 .57359 L p F P
0 g
s
.512 .324 .562 r
.71316 .55272 m .7147 .57359 L .66411 .5977 L p F P
0 g
s
.556 .2 .32 r
.60576 .63313 m .60182 .64987 L .54491 .65792 L p F P
0 g
s
.456 .11 .29 r
.60182 .64987 m .60576 .63313 L .66149 .61684 L p F P
0 g
s
.828 .711 .736 r
.28266 .50336 m .29629 .4815 L .335 .5093 L p F P
0 g
s
.828 .711 .736 r
.335 .5093 m .32389 .53273 L .28266 .50336 L p F P
0 g
s
.797 .723 .782 r
.35059 .48473 m .335 .5093 L .29629 .4815 L p F P
0 g
s
.554 .489 .737 r
.70665 .53061 m .69531 .5073 L .73329 .47905 L p F P
0 g
s
.589 .554 .783 r
.69531 .5073 m .67939 .48289 L .71392 .45695 L p F P
0 g
s
.589 .554 .783 r
.71392 .45695 m .73329 .47905 L .69531 .5073 L p F P
0 g
s
.862 .688 .665 r
.27482 .52472 m .28266 .50336 L .32389 .53273 L p F P
0 g
s
.862 .688 .665 r
.32389 .53273 m .31751 .55489 L .27482 .52472 L p F P
0 g
s
.797 .723 .782 r
.29629 .4815 m .31539 .4592 L .35059 .48473 L p F P
0 g
s
.77 .728 .814 r
.37032 .4592 m .35059 .48473 L .31539 .4592 L p F P
0 g
s
.501 .395 .665 r
.71316 .55272 m .70665 .53061 L .74711 .50078 L p F P
0 g
s
.554 .489 .737 r
.73329 .47905 m .74711 .50078 L .70665 .53061 L p F P
0 g
s
.612 .6 .815 r
.67939 .48289 m .65925 .45757 L .68944 .43464 L p F P
0 g
s
.612 .6 .815 r
.68944 .43464 m .71392 .45695 L .67939 .48289 L p F P
0 g
s
.738 .712 .827 r
.37032 .4592 m .39377 .433 L .42457 .44788 L p F P
0 g
s
.722 .718 .846 r
.4443 .41813 m .42457 .44788 L .39377 .433 L p F P
0 g
s
.713 .705 .841 r
.42457 .44788 m .4443 .41813 L .4712 .42612 L p F P
0 g
s
.654 .663 .846 r
.60492 .44686 m .58456 .41733 L .60812 .40541 L p F P
0 g
s
.654 .663 .846 r
.60812 .40541 m .63532 .43163 L .60492 .44686 L p F P
0 g
s
.892 .641 .552 r
.27298 .54553 m .27482 .52472 L .31751 .55489 L p F P
0 g
s
.892 .641 .552 r
.31751 .55489 m .316 .57576 L .27298 .54553 L p F P
0 g
s
.77 .728 .814 r
.31539 .4592 m .33954 .43663 L .37032 .4592 L p F P
0 g
s
.748 .731 .836 r
.39377 .433 m .37032 .4592 L .33954 .43663 L p F P
0 g
s
.629 .634 .837 r
.65925 .45757 m .63532 .43163 L .6604 .41234 L p F P
0 g
s
.629 .634 .837 r
.6604 .41234 m .68944 .43464 L .65925 .45757 L p F P
0 g
s
.695 .705 .855 r
.50414 .39641 m .49993 .43011 L .4712 .42612 L p F P
0 g
s
.687 .697 .854 r
.49993 .43011 m .50414 .39641 L .52426 .39629 L p F P
0 g
s
.687 .697 .854 r
.52426 .39629 m .52925 .42994 L .49993 .43011 L p F P
0 g
s
.416 .253 .55 r
.7147 .57359 m .71316 .55272 L .75505 .52206 L p F P
0 g
s
.501 .395 .665 r
.74711 .50078 m .75505 .52206 L .71316 .55272 L p F P
0 g
s
.678 .691 .855 r
.52925 .42994 m .52426 .39629 L .54389 .3933 L p F P
0 g
s
.678 .691 .855 r
.54389 .3933 m .55787 .42562 L .52925 .42994 L p F P
0 g
s
.651 .199 .164 r
.4355 .66571 m .42962 .65079 L .48673 .65823 L p F P
0 g
s
.651 .199 .164 r
.48673 .65823 m .48859 .6726 L .4355 .66571 L p F P
0 g
s
.578 .142 .178 r
.48859 .6726 m .48673 .65823 L .54491 .65792 L p F P
0 g
s
.578 .142 .178 r
.54491 .65792 m .5427 .67231 L .48859 .6726 L p F P
0 g
s
.485 .062 .162 r
.5427 .67231 m .54491 .65792 L .60182 .64987 L p F P
0 g
s
.817 .393 .237 r
.32781 .61395 m .31945 .5954 L .36974 .61841 L p F P
0 g
s
.817 .393 .237 r
.36974 .61841 m .3759 .63586 L .32781 .61395 L p F P
0 g
s
.702 .713 .857 r
.48443 .39365 m .4712 .42612 L .4443 .41813 L p F P
0 g
s
.695 .705 .855 r
.4712 .42612 m .48443 .39365 L .50414 .39641 L p F P
0 g
s
.456 .11 .29 r
.66149 .61684 m .65515 .63436 L .60182 .64987 L p F P
0 g
s
.315 0 .23 r
.65515 .63436 m .66149 .61684 L .71118 .59328 L p F P
0 g
s
.431 .173 .42 r
.7147 .57359 m .71118 .59328 L .66149 .61684 L p F P
0 g
s
.669 .687 .857 r
.55787 .42562 m .54389 .3933 L .56217 .38757 L p F P
0 g
s
.669 .687 .857 r
.56217 .38757 m .58456 .41733 L .55787 .42562 L p F P
0 g
s
.748 .731 .836 r
.33954 .43663 m .36819 .41401 L .39377 .433 L p F P
0 g
s
.729 .731 .852 r
.42043 .40648 m .39377 .433 L .36819 .41401 L p F P
0 g
s
.722 .718 .846 r
.39377 .433 m .42043 .40648 L .4443 .41813 L p F P
0 g
s
.9 .552 .375 r
.27721 .56587 m .27298 .54553 L .316 .57576 L p F P
0 g
s
.9 .552 .375 r
.316 .57576 m .31945 .5954 L .27721 .56587 L p F P
0 g
s
.711 .235 .118 r
.38558 .65189 m .3759 .63586 L .42962 .65079 L p F P
0 g
s
.711 .235 .118 r
.42962 .65079 m .4355 .66571 L .38558 .65189 L p F P
0 g
s
.641 .661 .853 r
.63532 .43163 m .60812 .40541 L .62747 .39034 L p F P
0 g
s
.641 .661 .853 r
.62747 .39034 m .6604 .41234 L .63532 .43163 L p F P
0 g
s
.485 .062 .162 r
.60182 .64987 m .59561 .66486 L .5427 .67231 L p F P
0 g
s
.359 0 .112 r
.59561 .66486 m .60182 .64987 L .65515 .63436 L p F P
0 g
s
.708 .722 .861 r
.46601 .38812 m .4443 .41813 L .42043 .40648 L p F P
0 g
s
.702 .713 .857 r
.4443 .41813 m .46601 .38812 L .48443 .39365 L p F P
0 g
s
.283 .048 .37 r
.71118 .59328 m .7147 .57359 L .75693 .54287 L p F P
0 g
s
.416 .253 .55 r
.75505 .52206 m .75693 .54287 L .7147 .57359 L p F P
0 g
s
.66 .684 .861 r
.58456 .41733 m .56217 .38757 L .57825 .37934 L p F P
0 g
s
.66 .684 .861 r
.57825 .37934 m .60812 .40541 L .58456 .41733 L p F P
0 g
s
.857 .757 .751 r
.25128 .46863 m .2669 .44863 L .29629 .4815 L p F P
0 g
s
.857 .757 .751 r
.29629 .4815 m .28266 .50336 L .25128 .46863 L p F P
0 g
s
.816 .758 .798 r
.31539 .4592 m .29629 .4815 L .2669 .44863 L p F P
0 g
s
.816 .758 .798 r
.2669 .44863 m .28877 .42907 L .31539 .4592 L p F P
0 g
s
.783 .755 .827 r
.33954 .43663 m .31539 .4592 L .28877 .42907 L p F P
0 g
s
.552 .544 .799 r
.73329 .47905 m .71392 .45695 L .73974 .42651 L p F P
0 g
s
.587 .596 .829 r
.71392 .45695 m .68944 .43464 L .71191 .40778 L p F P
0 g
s
.587 .596 .829 r
.71191 .40778 m .73974 .42651 L .71392 .45695 L p F P
0 g
s
.5 .468 .752 r
.74711 .50078 m .73329 .47905 L .7618 .44584 L p F P
0 g
s
.552 .544 .799 r
.73974 .42651 m .7618 .44584 L .73329 .47905 L p F P
0 g
s
.783 .755 .827 r
.28877 .42907 m .31636 .41004 L .33954 .43663 L p F P
0 g
s
.756 .75 .847 r
.36819 .41401 m .33954 .43663 L .31636 .41004 L p F P
0 g
s
.905 .744 .671 r
.24229 .489 m .25128 .46863 L .28266 .50336 L p F P
0 g
s
.905 .744 .671 r
.28266 .50336 m .27482 .52472 L .24229 .489 L p F P
0 g
s
.611 .633 .848 r
.68944 .43464 m .6604 .41234 L .67897 .3898 L p F P
0 g
s
.611 .633 .848 r
.67897 .3898 m .71191 .40778 L .68944 .43464 L p F P
0 g
s
.729 .731 .852 r
.36819 .41401 m .40068 .39164 L .42043 .40648 L p F P
0 g
s
.712 .731 .866 r
.44971 .38008 m .42043 .40648 L .40068 .39164 L p F P
0 g
s
.708 .722 .861 r
.42043 .40648 m .44971 .38008 L .46601 .38812 L p F P
0 g
s
.417 .347 .672 r
.75505 .52206 m .74711 .50078 L .77756 .46567 L p F P
0 g
s
.5 .468 .752 r
.7618 .44584 m .77756 .46567 L .74711 .50078 L p F P
0 g
s
.652 .682 .866 r
.60812 .40541 m .57825 .37934 L .59141 .36896 L p F P
0 g
s
.652 .682 .866 r
.59141 .36896 m .62747 .39034 L .60812 .40541 L p F P
0 g
s
.686 .714 .87 r
.50865 .36269 m .50414 .39641 L .48443 .39365 L p F P
0 g
s
.681 .71 .87 r
.50414 .39641 m .50865 .36269 L .51892 .36263 L p F P
0 g
s
.681 .71 .87 r
.51892 .36263 m .52426 .39629 L .50414 .39641 L p F P
0 g
s
.676 .706 .87 r
.52426 .39629 m .51892 .36263 L .52894 .3611 L p F P
0 g
s
.676 .706 .87 r
.52894 .3611 m .54389 .3933 L .52426 .39629 L p F P
0 g
s
.75 .247 .024 r
.34096 .63163 m .32781 .61395 L .3759 .63586 L p F P
0 g
s
.75 .247 .024 r
.3759 .63586 m .38558 .65189 L .34096 .63163 L p F P
0 g
s
.854 .406 .13 r
.28747 .58584 m .27721 .56587 L .31945 .5954 L p F P
0 g
s
.854 .406 .13 r
.31945 .5954 m .32781 .61395 L .28747 .58584 L p F P
0 g
s
.359 0 .112 r
.65515 .63436 m .64515 .65051 L .59561 .66486 L p F P
0 g
s
.174 0 .013 r
.64515 .65051 m .65515 .63436 L .70265 .61192 L p F P
0 g
s
.315 0 .23 r
.71118 .59328 m .70265 .61192 L .65515 .63436 L p F P
0 g
s
.69 .719 .872 r
.49859 .36127 m .48443 .39365 L .46601 .38812 L p F P
0 g
s
.686 .714 .87 r
.48443 .39365 m .49859 .36127 L .50865 .36269 L p F P
0 g
s
.756 .75 .847 r
.31636 .41004 m .34902 .3917 L .36819 .41401 L p F P
0 g
s
.734 .746 .861 r
.40068 .39164 m .36819 .41401 L .34902 .3917 L p F P
0 g
s
.671 .704 .872 r
.54389 .3933 m .52894 .3611 L .53824 .35815 L p F P
0 g
s
.671 .704 .872 r
.53824 .35815 m .56217 .38757 L .54389 .3933 L p F P
0 g
s
.949 .7 .528 r
.24017 .50974 m .24229 .489 L .27482 .52472 L p F P
0 g
s
.949 .7 .528 r
.27482 .52472 m .27298 .54553 L .24017 .50974 L p F P
0 g
s
.097 0 .117 r
.70265 .61192 m .71118 .59328 L .75264 .56327 L p F P
0 g
s
.283 .048 .37 r
.75693 .54287 m .75264 .56327 L .71118 .59328 L p F P
0 g
s
.629 .661 .862 r
.6604 .41234 m .62747 .39034 L .64171 .37276 L p F P
0 g
s
.629 .661 .862 r
.64171 .37276 m .67897 .3898 L .6604 .41234 L p F P
0 g
s
.275 .152 .525 r
.75693 .54287 m .75505 .52206 L .78664 .48596 L p F P
0 g
s
.417 .347 .672 r
.77756 .46567 m .78664 .48596 L .75505 .52206 L p F P
0 g
s
.588 .08 .011 r
.44344 .67921 m .4355 .66571 L .48859 .6726 L p F P
0 g
s
.588 .08 .011 r
.48859 .6726 m .49112 .68537 L .44344 .67921 L p F P
0 g
s
.511 .021 .03 r
.49112 .68537 m .48859 .6726 L .5427 .67231 L p F P
0 g
s
.511 .021 .03 r
.5427 .67231 m .53971 .68511 L .49112 .68537 L p F P
0 g
s
.405 0 .008 r
.53971 .68511 m .5427 .67231 L .59561 .66486 L p F P
0 g
s
.694 .725 .874 r
.48921 .35843 m .46601 .38812 L .44971 .38008 L p F P
0 g
s
.69 .719 .872 r
.46601 .38812 m .48921 .35843 L .49859 .36127 L p F P
0 g
s
.666 .702 .874 r
.56217 .38757 m .53824 .35815 L .54641 .35392 L p F P
0 g
s
.666 .702 .874 r
.54641 .35392 m .57825 .37934 L .56217 .38757 L p F P
0 g
s
.734 .746 .861 r
.34902 .3917 m .38598 .37424 L .40068 .39164 L p F P
0 g
s
.715 .741 .872 r
.43628 .36985 m .40068 .39164 L .38598 .37424 L p F P
0 g
s
.712 .731 .866 r
.40068 .39164 m .43628 .36985 L .44971 .38008 L p F P
0 g
s
.643 .683 .872 r
.62747 .39034 m .59141 .36896 L .60102 .35689 L p F P
0 g
s
.643 .683 .872 r
.60102 .35689 m .64171 .37276 L .62747 .39034 L p F P
0 g
s
.641 .108 0 r
.39866 .66685 m .38558 .65189 L .4355 .66571 L p F P
0 g
s
.641 .108 0 r
.4355 .66571 m .44344 .67921 L .39866 .66685 L p F P
0 g
s
.405 0 .008 r
.59561 .66486 m .58722 .67844 L .53971 .68511 L p F P
0 g
s
.256 0 0 r
.58722 .67844 m .59561 .66486 L .64515 .65051 L p F P
0 g
s
.696 .73 .877 r
.48093 .3543 m .44971 .38008 L .43628 .36985 L p F P
0 g
s
.694 .725 .874 r
.44971 .38008 m .48093 .3543 L .48921 .35843 L p F P
0 g
s
.944 .585 .28 r
.24503 .53091 m .24017 .50974 L .27298 .54553 L p F P
0 g
s
.944 .585 .28 r
.27298 .54553 m .27721 .56587 L .24503 .53091 L p F P
0 g
s
.66 .701 .877 r
.57825 .37934 m .54641 .35392 L .55306 .3486 L p F P
0 g
s
.66 .701 .877 r
.55306 .3486 m .59141 .36896 L .57825 .37934 L p F P
0 g
s
.045 0 .268 r
.75264 .56327 m .75693 .54287 L .78877 .50669 L p F P
0 g
s
.275 .152 .525 r
.78664 .48596 m .78877 .50669 L .75693 .54287 L p F P
0 g
s
.832 .798 .818 r
.24839 .41203 m .27211 .39557 L .28877 .42907 L p F P
0 g
s
.832 .798 .818 r
.28877 .42907 m .2669 .44863 L .24839 .41203 L p F P
0 g
s
.792 .783 .845 r
.31636 .41004 m .28877 .42907 L .27211 .39557 L p F P
0 g
s
.792 .783 .845 r
.27211 .39557 m .30198 .38054 L .31636 .41004 L p F P
0 g
s
.762 .771 .861 r
.34902 .3917 m .31636 .41004 L .30198 .38054 L p F P
0 g
s
.739 .218 0 r
.3036 .60566 m .28747 .58584 L .32781 .61395 L p F P
0 g
s
.739 .218 0 r
.32781 .61395 m .34096 .63163 L .3036 .60566 L p F P
0 g
s
.56 .596 .846 r
.73974 .42651 m .71191 .40778 L .72549 .3781 L p F P
0 g
s
.593 .635 .862 r
.71191 .40778 m .67897 .3898 L .69007 .36496 L p F P
0 g
s
.593 .635 .862 r
.69007 .36496 m .72549 .3781 L .71191 .40778 L p F P
0 g
s
.511 .538 .82 r
.7618 .44584 m .73974 .42651 L .7555 .3928 L p F P
0 g
s
.56 .596 .846 r
.72549 .3781 m .7555 .3928 L .73974 .42651 L p F P
0 g
s
.762 .771 .861 r
.30198 .38054 m .33726 .367 L .34902 .3917 L p F P
0 g
s
.737 .76 .871 r
.38598 .37424 m .34902 .3917 L .33726 .367 L p F P
0 g
s
.885 .811 .77 r
.23142 .4299 m .24839 .41203 L .2669 .44863 L p F P
0 g
s
.885 .811 .77 r
.2669 .44863 m .25128 .46863 L .23142 .4299 L p F P
0 g
s
.174 0 .013 r
.70265 .61192 m .68923 .62976 L .64515 .65051 L p F P
0 g
s
0 0 0 r
.68923 .62976 m .70265 .61192 L .74224 .58337 L p F P
0 g
s
.097 0 .117 r
.75264 .56327 m .74224 .58337 L .70265 .61192 L p F P
0 g
s
.715 .741 .872 r
.38598 .37424 m .42635 .3579 L .43628 .36985 L p F P
0 g
s
.698 .736 .88 r
.47414 .34906 m .43628 .36985 L .42635 .3579 L p F P
0 g
s
.696 .73 .877 r
.43628 .36985 m .47414 .34906 L .48093 .3543 L p F P
0 g
s
.617 .663 .872 r
.67897 .3898 m .64171 .37276 L .65011 .35345 L p F P
0 g
s
.617 .663 .872 r
.65011 .35345 m .69007 .36496 L .67897 .3898 L p F P
0 g
s
.656 .702 .881 r
.59141 .36896 m .55306 .3486 L .55788 .34244 L p F P
0 g
s
.656 .702 .881 r
.55788 .34244 m .60102 .35689 L .59141 .36896 L p F P
0 g
s
.433 .445 .772 r
.77756 .46567 m .7618 .44584 L .77933 .409 L p F P
0 g
s
.511 .538 .82 r
.7555 .3928 m .77933 .409 L .7618 .44584 L p F P
0 g
s
.677 .723 .884 r
.51335 .32971 m .50865 .36269 L .49859 .36127 L closepath p F P
0 g
s
.676 .722 .884 r
.51335 .32971 m .51892 .36263 L .50865 .36269 L closepath p F P
0 g
s
.674 .721 .884 r
.51335 .32971 m .52894 .3611 L .51892 .36263 L closepath p F P
0 g
s
.679 .725 .885 r
.51335 .32971 m .49859 .36127 L .48921 .35843 L closepath p F P
0 g
s
.656 .101 0 r
.35869 .64874 m .34096 .63163 L .38558 .65189 L p F P
0 g
s
.656 .101 0 r
.38558 .65189 m .39866 .66685 L .35869 .64874 L p F P
0 g
s
.672 .72 .885 r
.51335 .32971 m .53824 .35815 L .52894 .3611 L closepath p F P
0 g
s
.737 .76 .871 r
.33726 .367 m .37706 .35503 L .38598 .37424 L p F P
0 g
s
.716 .75 .879 r
.42635 .3579 m .38598 .37424 L .37706 .35503 L p F P
0 g
s
.256 0 0 r
.64515 .65051 m .63166 .66561 L .58722 .67844 L p F P
0 g
s
.036 0 0 r
.63166 .66561 m .64515 .65051 L .68923 .62976 L p F P
0 g
s
.949 .813 .675 r
.22164 .44915 m .23142 .4299 L .25128 .46863 L p F P
0 g
s
.949 .813 .675 r
.25128 .46863 m .24229 .489 L .22164 .44915 L p F P
0 g
s
.636 .685 .88 r
.64171 .37276 m .60102 .35689 L .6066 .34366 L p F P
0 g
s
.636 .685 .88 r
.6066 .34366 m .65011 .35345 L .64171 .37276 L p F P
0 g
s
.68 .727 .886 r
.51335 .32971 m .48921 .35843 L .48093 .3543 L closepath p F P
0 g
s
.67 .719 .886 r
.51335 .32971 m .54641 .35392 L .53824 .35815 L closepath p F P
0 g
s
.823 .369 0 r
.25679 .55261 m .24503 .53091 L .27721 .56587 L p F P
0 g
s
.823 .369 0 r
.27721 .56587 m .28747 .58584 L .25679 .55261 L p F P
0 g
s
.296 .284 .676 r
.78664 .48596 m .77756 .46567 L .79638 .42669 L p F P
0 g
s
.433 .445 .772 r
.77933 .409 m .79638 .42669 L .77756 .46567 L p F P
0 g
s
0 0 0 r
.74224 .58337 m .75264 .56327 L .78388 .52793 L p F P
0 g
s
.045 0 .268 r
.78877 .50669 m .78388 .52793 L .75264 .56327 L p F P
0 g
s
.68 .729 .887 r
.51335 .32971 m .48093 .3543 L .47414 .34906 L closepath p F P
0 g
s
.668 .719 .887 r
.51335 .32971 m .55306 .3486 L .54641 .35392 L closepath p F P
0 g
s
.716 .75 .879 r
.37706 .35503 m .42041 .34475 L .42635 .3579 L p F P
0 g
s
.698 .741 .885 r
.46915 .34296 m .42635 .3579 L .42041 .34475 L p F P
0 g
s
.698 .736 .88 r
.42635 .3579 m .46915 .34296 L .47414 .34906 L p F P
0 g
s
.651 .704 .885 r
.60102 .35689 m .55788 .34244 L .56063 .33571 L p F P
0 g
s
.651 .704 .885 r
.56063 .33571 m .6066 .34366 L .60102 .35689 L p F P
0 g
s
.994 .763 .472 r
.21934 .4698 m .22164 .44915 L .24229 .489 L p F P
0 g
s
.994 .763 .472 r
.24229 .489 m .24017 .50974 L .21934 .4698 L p F P
0 g
s
.681 .731 .888 r
.51335 .32971 m .47414 .34906 L .46915 .34296 L closepath p F P
0 g
s
.667 .719 .888 r
.51335 .32971 m .55788 .34244 L .55306 .3486 L closepath p F P
0 g
s
.045 0 .464 r
.78877 .50669 m .78664 .48596 L .80621 .44584 L p F P
0 g
s
.296 .284 .676 r
.79638 .42669 m .80621 .44584 L .78664 .48596 L p F P
0 g
s
.526 0 0 r
.45331 .69172 m .44344 .67921 L .49112 .68537 L p F P
0 g
s
.526 0 0 r
.49112 .68537 m .49425 .697 L .45331 .69172 L p F P
0 g
s
.447 0 0 r
.49425 .697 m .49112 .68537 L .53971 .68511 L p F P
0 g
s
.447 0 0 r
.53971 .68511 m .536 .69678 L .49425 .697 L p F P
0 g
s
.332 0 0 r
.536 .69678 m .53971 .68511 L .58722 .67844 L p F P
0 g
s
.698 .741 .885 r
.42041 .34475 m .46622 .33626 L .46915 .34296 L p F P
0 g
s
.681 .732 .889 r
.51335 .32971 m .46915 .34296 L .46622 .33626 L closepath p F P
0 g
s
.665 .72 .889 r
.51335 .32971 m .56063 .33571 L .55788 .34244 L closepath p F P
0 g
s
.736 .774 .883 r
.33358 .34101 m .37443 .33488 L .37706 .35503 L p F P
0 g
s
.736 .774 .883 r
.37706 .35503 m .33726 .367 L .33358 .34101 L p F P
0 g
s
.715 .759 .887 r
.42041 .34475 m .37706 .35503 L .37443 .33488 L p F P
0 g
s
.762 .791 .877 r
.29727 .34941 m .33358 .34101 L .33726 .367 L p F P
0 g
s
.762 .791 .877 r
.33726 .367 m .30198 .38054 L .29727 .34941 L p F P
0 g
s
.57 .002 0 r
.4149 .68115 m .39866 .66685 L .44344 .67921 L p F P
0 g
s
.57 .002 0 r
.44344 .67921 m .45331 .69172 L .4149 .68115 L p F P
0 g
s
.606 .669 .884 r
.69007 .36496 m .65011 .35345 L .65219 .33327 L p F P
0 g
s
.629 .69 .888 r
.65011 .35345 m .6066 .34366 L .60786 .32989 L p F P
0 g
s
.629 .69 .888 r
.60786 .32989 m .65219 .33327 L .65011 .35345 L p F P
0 g
s
.715 .759 .887 r
.37443 .33488 m .41877 .33099 L .42041 .34475 L p F P
0 g
s
.697 .746 .889 r
.46622 .33626 m .42041 .34475 L .41877 .33099 L p F P
0 g
s
.592 .041 0 r
.32531 .62558 m .3036 .60566 L .34096 .63163 L p F P
0 g
s
.592 .041 0 r
.34096 .63163 m .35869 .64874 L .32531 .62558 L p F P
0 g
s
.332 0 0 r
.58722 .67844 m .57679 .69107 L .536 .69678 L p F P
0 g
s
.166 0 0 r
.57679 .69107 m .58722 .67844 L .63166 .66561 L p F P
0 g
s
.576 .641 .878 r
.72549 .3781 m .69007 .36496 L .69304 .33892 L p F P
0 g
s
.606 .669 .884 r
.65219 .33327 m .69304 .33892 L .69007 .36496 L p F P
0 g
s
.796 .813 .865 r
.26645 .36014 m .29727 .34941 L .30198 .38054 L p F P
0 g
s
.796 .813 .865 r
.30198 .38054 m .27211 .39557 L .26645 .36014 L p F P
0 g
s
.648 .706 .89 r
.6066 .34366 m .56063 .33571 L .56118 .32872 L p F P
0 g
s
.648 .706 .89 r
.56118 .32872 m .60786 .32989 L .6066 .34366 L p F P
0 g
s
.903 .563 .085 r
.22461 .49192 m .21934 .4698 L .24017 .50974 L p F P
0 g
s
.903 .563 .085 r
.24017 .50974 m .24503 .53091 L .22461 .49192 L p F P
0 g
s
.036 0 0 r
.68923 .62976 m .67113 .64707 L .63166 .66561 L p F P
0 g
s
0 0 0 r
.67113 .64707 m .68923 .62976 L .72588 .60338 L p F P
0 g
s
0 0 0 r
.74224 .58337 m .72588 .60338 L .68923 .62976 L p F P
0 g
s
.604 .116 0 r
.27527 .57499 m .25679 .55261 L .28747 .58584 L p F P
0 g
s
.604 .116 0 r
.28747 .58584 m .3036 .60566 L .27527 .57499 L p F P
0 g
s
.532 .6 .867 r
.7555 .3928 m .72549 .3781 L .72935 .3469 L p F P
0 g
s
.576 .641 .878 r
.69304 .33892 m .72935 .3469 L .72549 .3781 L p F P
0 g
s
.697 .746 .889 r
.41877 .33099 m .46547 .32928 L .46622 .33626 L p F P
0 g
s
.681 .734 .891 r
.51335 .32971 m .46622 .33626 L .46547 .32928 L closepath p F P
0 g
s
.664 .721 .891 r
.51335 .32971 m .56118 .32872 L .56063 .33571 L closepath p F P
0 g
s
.843 .841 .843 r
.24192 .37326 m .26645 .36014 L .27211 .39557 L p F P
0 g
s
.843 .841 .843 r
.27211 .39557 m .24839 .41203 L .24192 .37326 L p F P
0 g
s
0 0 .062 r
.78388 .52793 m .78877 .50669 L .80852 .46649 L p F P
0 g
s
.045 0 .464 r
.80621 .44584 m .80852 .46649 L .78877 .50669 L p F P
0 g
s
0 0 0 r
.72588 .60338 m .74224 .58337 L .77201 .54978 L p F P
0 g
s
0 0 0 r
.78388 .52793 m .77201 .54978 L .74224 .58337 L p F P
0 g
s
.464 .536 .845 r
.77933 .409 m .7555 .3928 L .76019 .35729 L p F P
0 g
s
.532 .6 .867 r
.72935 .3469 m .76019 .35729 L .7555 .3928 L p F P
0 g
s
.664 .726 .895 r
.51335 .32971 m .54977 .30947 L .55564 .31528 L closepath p F P
0 g
s
.664 .728 .897 r
.51335 .32971 m .54218 .30464 L .54977 .30947 L closepath p F P
0 g
s
.665 .73 .898 r
.51335 .32971 m .53322 .30103 L .54218 .30464 L closepath p F P
0 g
s
.666 .731 .898 r
.51335 .32971 m .5233 .29882 L .53322 .30103 L closepath p F P
0 g
s
.668 .733 .899 r
.51335 .32971 m .5129 .29811 L .5233 .29882 L closepath p F P
0 g
s
.67 .735 .899 r
.51335 .32971 m .50253 .29894 L .5129 .29811 L closepath p F P
0 g
s
.672 .736 .898 r
.51335 .32971 m .49268 .30127 L .50253 .29894 L closepath p F P
0 g
s
.674 .736 .898 r
.51335 .32971 m .48381 .30498 L .49268 .30127 L closepath p F P
0 g
s
.675 .737 .897 r
.51335 .32971 m .47635 .3099 L .48381 .30498 L closepath p F P
0 g
s
.677 .737 .895 r
.51335 .32971 m .47065 .31578 L .47635 .3099 L closepath p F P
0 g
s
.679 .736 .894 r
.51335 .32971 m .46697 .32235 L .47065 .31578 L closepath p F P
0 g
s
.68 .735 .892 r
.51335 .32971 m .46547 .32928 L .46697 .32235 L closepath p F P
0 g
s
.664 .722 .893 r
.51335 .32971 m .5595 .32181 L .56118 .32872 L closepath p F P
0 g
s
.663 .724 .894 r
.51335 .32971 m .55564 .31528 L .5595 .32181 L closepath p F P
0 g
s
.695 .75 .894 r
.42157 .31727 m .46697 .32235 L .46547 .32928 L p F P
0 g
s
.695 .75 .894 r
.46547 .32928 m .41877 .33099 L .42157 .31727 L p F P
0 g
s
.645 .71 .895 r
.60786 .32989 m .56118 .32872 L .5595 .32181 L p F P
0 g
s
.906 .874 .794 r
.22434 .38881 m .24192 .37326 L .24839 .41203 L p F P
0 g
s
.906 .874 .794 r
.24839 .41203 m .23142 .4299 L .22434 .38881 L p F P
0 g
s
.562 0 0 r
.38069 .66569 m .35869 .64874 L .39866 .66685 L p F P
0 g
s
.562 0 0 r
.39866 .66685 m .4149 .68115 L .38069 .66569 L p F P
0 g
s
.712 .767 .895 r
.37831 .31472 m .42157 .31727 L .41877 .33099 L p F P
0 g
s
.712 .767 .895 r
.41877 .33099 m .37443 .33488 L .37831 .31472 L p F P
0 g
s
.345 .421 .796 r
.79638 .42669 m .77933 .409 L .78474 .37013 L p F P
0 g
s
.464 .536 .845 r
.76019 .35729 m .78474 .37013 L .77933 .409 L p F P
0 g
s
.166 0 0 r
.63166 .66561 m .61491 .68009 L .57679 .69107 L p F P
0 g
s
0 0 0 r
.61491 .68009 m .63166 .66561 L .67113 .64707 L p F P
0 g
s
.624 .696 .896 r
.65219 .33327 m .60786 .32989 L .60468 .3162 L p F P
0 g
s
.645 .71 .895 r
.5595 .32181 m .60468 .3162 L .60786 .32989 L p F P
0 g
s
.692 .753 .899 r
.42871 .30424 m .47065 .31578 L .46697 .32235 L p F P
0 g
s
.692 .753 .899 r
.46697 .32235 m .42157 .31727 L .42871 .30424 L p F P
0 g
s
.644 .715 .899 r
.60468 .3162 m .5595 .32181 L .55564 .31528 L p F P
0 g
s
0 0 .351 r
.23741 .51557 m .22461 .49192 L .24503 .53091 L p F P
0 g
s
0 0 .351 r
.24503 .53091 m .25679 .55261 L .23741 .51557 L p F P
0 g
s
.732 .786 .896 r
.33833 .31492 m .37831 .31472 L .37443 .33488 L p F P
0 g
s
.732 .786 .896 r
.37443 .33488 m .33358 .34101 L .33833 .31492 L p F P
0 g
s
.978 .891 .668 r
.2142 .40683 m .22434 .38881 L .23142 .4299 L p F P
0 g
s
.978 .891 .668 r
.23142 .4299 m .22164 .44915 L .2142 .40683 L p F P
0 g
s
.597 .677 .897 r
.69304 .33892 m .65219 .33327 L .64775 .31314 L p F P
0 g
s
.624 .696 .896 r
.60468 .3162 m .64775 .31314 L .65219 .33327 L p F P
0 g
s
0 0 .062 r
.80852 .46649 m .80322 .48869 L .78388 .52793 L p F P
0 g
s
.675 .817 .375 r
.77201 .54978 m .78388 .52793 L .80322 .48869 L p F P
0 g
s
.112 .189 .666 r
.80621 .44584 m .79638 .42669 L .80233 .38549 L p F P
0 g
s
.345 .421 .796 r
.78474 .37013 m .80233 .38549 L .79638 .42669 L p F P
0 g
s
.687 .755 .903 r
.4399 .29253 m .47635 .3099 L .47065 .31578 L p F P
0 g
s
.687 .755 .903 r
.47065 .31578 m .42871 .30424 L .4399 .29253 L p F P
0 g
s
.644 .72 .904 r
.59719 .30326 m .55564 .31528 L .54977 .30947 L p F P
0 g
s
.644 .715 .899 r
.55564 .31528 m .59719 .30326 L .60468 .3162 L p F P
0 g
s
.758 .81 .894 r
.30269 .31808 m .33833 .31492 L .33358 .34101 L p F P
0 g
s
.758 .81 .894 r
.33358 .34101 m .29727 .34941 L .30269 .31808 L p F P
0 g
s
.56 .651 .896 r
.72935 .3469 m .69304 .33892 L .68757 .31287 L p F P
0 g
s
.597 .677 .897 r
.64775 .31314 m .68757 .31287 L .69304 .33892 L p F P
0 g
s
.706 .773 .904 r
.38862 .29551 m .42871 .30424 L .42157 .31727 L p F P
0 g
s
.706 .773 .904 r
.42157 .31727 m .37831 .31472 L .38862 .29551 L p F P
0 g
s
0 .077 .591 r
.30011 .59826 m .27527 .57499 L .3036 .60566 L p F P
0 g
s
0 .077 .591 r
.3036 .60566 m .32531 .62558 L .30011 .59826 L p F P
0 g
s
.621 .704 .904 r
.64775 .31314 m .60468 .3162 L .59719 .30326 L p F P
0 g
s
.682 .756 .907 r
.45463 .28271 m .48381 .30498 L .47635 .3099 L p F P
0 g
s
.682 .756 .907 r
.47635 .3099 m .4399 .29253 L .45463 .28271 L p F P
0 g
s
.644 .72 .904 r
.54977 .30947 m .58567 .29167 L .59719 .30326 L p F P
0 g
s
.645 .726 .908 r
.58567 .29167 m .54977 .30947 L .54218 .30464 L p F P
0 g
s
.955 .78 .33 r
.21181 .42739 m .2142 .40683 L .22164 .44915 L p F P
0 g
s
.955 .78 .33 r
.22164 .44915 m .21934 .4698 L .21181 .42739 L p F P
0 g
s
0 0 0 r
.72588 .60338 m .70387 .62354 L .67113 .64707 L p F P
0 g
s
0 0 0 r
.77201 .54978 m .75337 .57238 L .72588 .60338 L p F P
0 g
s
.621 .904 .608 r
.70387 .62354 m .72588 .60338 L .75337 .57238 L p F P
0 g
s
.793 .843 .889 r
.27235 .3244 m .30269 .31808 L .29727 .34941 L p F P
0 g
s
.793 .843 .889 r
.29727 .34941 m .26645 .36014 L .27235 .3244 L p F P
0 g
s
.465 0 0 r
.35221 .64593 m .32531 .62558 L .35869 .64874 L p F P
0 g
s
.465 0 0 r
.35869 .64874 m .38069 .66569 L .35221 .64593 L p F P
0 g
s
0 0 .311 r
.80852 .46649 m .80621 .44584 L .81248 .40341 L p F P
0 g
s
.112 .189 .666 r
.80233 .38549 m .81248 .40341 L .80621 .44584 L p F P
0 g
s
.676 .755 .911 r
.47222 .27528 m .49268 .30127 L .48381 .30498 L p F P
0 g
s
.676 .755 .911 r
.48381 .30498 m .45463 .28271 L .47222 .27528 L p F P
0 g
s
.505 .61 .891 r
.76019 .35729 m .72935 .3469 L .72307 .31562 L p F P
0 g
s
.56 .651 .896 r
.68757 .31287 m .72307 .31562 L .72935 .3469 L p F P
0 g
s
.645 .726 .908 r
.54218 .30464 m .57067 .28203 L .58567 .29167 L p F P
0 g
s
.648 .733 .911 r
.57067 .28203 m .54218 .30464 L .53322 .30103 L p F P
0 g
s
0 0 0 r
.67113 .64707 m .64869 .66426 L .61491 .68009 L p F P
0 g
s
0 0 0 r
.64869 .66426 m .67113 .64707 L .70387 .62354 L p F P
0 g
s
.477 0 0 r
.46494 .70381 m .45331 .69172 L .49425 .697 L p F P
0 g
s
.477 0 0 r
.49425 .697 m .49795 .70805 L .46494 .70381 L p F P
0 g
s
.398 0 0 r
.49795 .70805 m .49425 .697 L .536 .69678 L p F P
0 g
s
.398 0 0 r
.536 .69678 m .53162 .70788 L .49795 .70805 L p F P
0 g
s
.278 0 0 r
.53162 .70788 m .536 .69678 L .57679 .69107 L p F P
0 g
s
.669 .753 .913 r
.49181 .27061 m .50253 .29894 L .49268 .30127 L p F P
0 g
s
.669 .753 .913 r
.49268 .30127 m .47222 .27528 L .49181 .27061 L p F P
0 g
s
0 .052 .614 r
.25747 .54085 m .23741 .51557 L .25679 .55261 L p F P
0 g
s
0 .052 .614 r
.25679 .55261 m .27527 .57499 L .25747 .54085 L p F P
0 g
s
.648 .733 .911 r
.53322 .30103 m .55288 .27481 L .57067 .28203 L p F P
0 g
s
.652 .739 .913 r
.55288 .27481 m .53322 .30103 L .5233 .29882 L p F P
0 g
s
.724 .796 .909 r
.35145 .28998 m .38862 .29551 L .37831 .31472 L p F P
0 g
s
.724 .796 .909 r
.37831 .31472 m .33833 .31492 L .35145 .28998 L p F P
0 g
s
.591 .689 .91 r
.68757 .31287 m .64775 .31314 L .63691 .29405 L p F P
0 g
s
.621 .704 .904 r
.59719 .30326 m .63691 .29405 L .64775 .31314 L p F P
0 g
s
.699 .777 .912 r
.40495 .27818 m .4399 .29253 L .42871 .30424 L p F P
0 g
s
.699 .777 .912 r
.42871 .30424 m .38862 .29551 L .40495 .27818 L p F P
0 g
s
.663 .749 .914 r
.51246 .26895 m .5129 .29811 L .50253 .29894 L p F P
0 g
s
.663 .749 .914 r
.50253 .29894 m .49181 .27061 L .51246 .26895 L p F P
0 g
s
.652 .739 .913 r
.5233 .29882 m .53316 .27037 L .55288 .27481 L p F P
0 g
s
.657 .744 .914 r
.53316 .27037 m .5233 .29882 L .5129 .29811 L p F P
0 g
s
.842 .886 .872 r
.24816 .33406 m .27235 .3244 L .26645 .36014 L p F P
0 g
s
.842 .886 .872 r
.26645 .36014 m .24192 .37326 L .24816 .33406 L p F P
0 g
s
.812 .959 .628 r
.75337 .57238 m .77201 .54978 L .79037 .5125 L p F P
0 g
s
.675 .817 .375 r
.80322 .48869 m .79037 .5125 L .77201 .54978 L p F P
0 g
s
.657 .744 .914 r
.5129 .29811 m .51246 .26895 L .53316 .27037 L p F P
0 g
s
.62 .713 .913 r
.63691 .29405 m .59719 .30326 L .58567 .29167 L p F P
0 g
s
.514 0 0 r
.43402 .69532 m .4149 .68115 L .45331 .69172 L p F P
0 g
s
.514 0 0 r
.45331 .69172 m .46494 .70381 L .43402 .69532 L p F P
0 g
s
.278 0 0 r
.57679 .69107 m .56451 .70329 L .53162 .70788 L p F P
0 g
s
.103 0 0 r
.56451 .70329 m .57679 .69107 L .61491 .68009 L p F P
0 g
s
.41 .538 .875 r
.78474 .37013 m .76019 .35729 L .75329 .32159 L p F P
0 g
s
.505 .61 .891 r
.72307 .31562 m .75329 .32159 L .76019 .35729 L p F P
0 g
s
0 0 .221 r
.21728 .45053 m .21181 .42739 L .21934 .4698 L p F P
0 g
s
0 0 .221 r
.21934 .4698 m .22461 .49192 L .21728 .45053 L p F P
0 g
s
0 0 .311 r
.81248 .40341 m .81487 .42396 L .80852 .46649 L p F P
0 g
s
.792 .76 .246 r
.80322 .48869 m .80852 .46649 L .81487 .42396 L p F P
0 g
s
.908 .941 .817 r
.23079 .34722 m .24816 .33406 L .24192 .37326 L p F P
0 g
s
.908 .941 .817 r
.24192 .37326 m .22434 .38881 L .23079 .34722 L p F P
0 g
s
.748 .827 .913 r
.31822 .28804 m .35145 .28998 L .33833 .31492 L p F P
0 g
s
.748 .827 .913 r
.33833 .31492 m .30269 .31808 L .31822 .28804 L p F P
0 g
s
.689 .778 .919 r
.42659 .26362 m .45463 .28271 L .4399 .29253 L p F P
0 g
s
.689 .778 .919 r
.4399 .29253 m .40495 .27818 L .42659 .26362 L p F P
0 g
s
.547 .665 .915 r
.72307 .31562 m .68757 .31287 L .67376 .28808 L p F P
0 g
s
.591 .689 .91 r
.63691 .29405 m .67376 .28808 L .68757 .31287 L p F P
0 g
s
.62 .713 .913 r
.58567 .29167 m .6201 .27691 L .63691 .29405 L p F P
0 g
s
.622 .724 .92 r
.6201 .27691 m .58567 .29167 L .57067 .28203 L p F P
0 g
s
.492 0 0 r
.40654 .68292 m .38069 .66569 L .4149 .68115 L p F P
0 g
s
.492 0 0 r
.4149 .68115 m .43402 .69532 L .40654 .68292 L p F P
0 g
s
.226 .39 .818 r
.80233 .38549 m .78474 .37013 L .7774 .33098 L p F P
0 g
s
.41 .538 .875 r
.75329 .32159 m .7774 .33098 L .78474 .37013 L p F P
0 g
s
.103 0 0 r
.61491 .68009 m .59519 .69447 L .56451 .70329 L p F P
0 g
s
0 0 0 r
.59519 .69447 m .61491 .68009 L .64869 .66426 L p F P
0 g
s
.712 .803 .921 r
.37246 .26743 m .40495 .27818 L .38862 .29551 L p F P
0 g
s
.712 .803 .921 r
.38862 .29551 m .35145 .28998 L .37246 .26743 L p F P
0 g
s
0 .195 .699 r
.33081 .62268 m .30011 .59826 L .32531 .62558 L p F P
0 g
s
0 .195 .699 r
.32531 .62558 m .35221 .64593 L .33081 .62268 L p F P
0 g
s
.587 .703 .922 r
.67376 .28808 m .63691 .29405 L .6201 .27691 L p F P
0 g
s
0 0 .572 r
.23054 .47628 m .21728 .45053 L .22461 .49192 L p F P
0 g
s
0 0 .572 r
.22461 .49192 m .23741 .51557 L .23054 .47628 L p F P
0 g
s
0 0 0 r
.70387 .62354 m .67661 .6442 L .64869 .66426 L p F P
0 g
s
.684 .957 .711 r
.67661 .6442 m .70387 .62354 L .72831 .59594 L p F P
0 g
s
.621 .904 .608 r
.75337 .57238 m .72831 .59594 L .70387 .62354 L p F P
0 g
s
0 .209 .735 r
.2844 .56792 m .25747 .54085 L .27527 .57499 L p F P
0 g
s
0 .209 .735 r
.27527 .57499 m .30011 .59826 L .2844 .56792 L p F P
0 g
s
.677 .777 .925 r
.45251 .25258 m .47222 .27528 L .45463 .28271 L p F P
0 g
s
.677 .777 .925 r
.45463 .28271 m .42659 .26362 L .45251 .25258 L p F P
0 g
s
.94 .945 .612 r
.22077 .36397 m .23079 .34722 L .22434 .38881 L p F P
0 g
s
.94 .945 .612 r
.22434 .38881 m .2142 .40683 L .22077 .36397 L p F P
0 g
s
.622 .724 .92 r
.57067 .28203 m .59806 .2626 L .6201 .27691 L p F P
0 g
s
.626 .735 .926 r
.59806 .2626 m .57067 .28203 L .55288 .27481 L p F P
0 g
s
.935 .936 .584 r
.79037 .5125 m .80322 .48869 L .8094 .44718 L p F P
0 g
s
.792 .76 .246 r
.81487 .42396 m .8094 .44718 L .80322 .48869 L p F P
0 g
s
.779 .869 .915 r
.28987 .29006 m .31822 .28804 L .30269 .31808 L p F P
0 g
s
.779 .869 .915 r
.30269 .31808 m .27235 .3244 L .28987 .29006 L p F P
0 g
s
.851 .993 .742 r
.72831 .59594 m .75337 .57238 L .77021 .53803 L p F P
0 g
s
.812 .959 .628 r
.79037 .5125 m .77021 .53803 L .75337 .57238 L p F P
0 g
s
0 .04 .603 r
.81248 .40341 m .80233 .38549 L .79471 .34394 L p F P
0 g
s
.226 .39 .818 r
.7774 .33098 m .79471 .34394 L .80233 .38549 L p F P
0 g
s
.478 .626 .917 r
.75329 .32159 m .72307 .31562 L .7067 .28575 L p F P
0 g
s
.547 .665 .915 r
.67376 .28808 m .7067 .28575 L .72307 .31562 L p F P
0 g
s
.665 .772 .93 r
.48148 .24563 m .49181 .27061 L .47222 .27528 L p F P
0 g
s
.665 .772 .93 r
.47222 .27528 m .45251 .25258 L .48148 .24563 L p F P
0 g
s
.626 .735 .926 r
.55288 .27481 m .57182 .25187 L .59806 .2626 L p F P
0 g
s
.633 .746 .93 r
.57182 .25187 m .55288 .27481 L .53316 .27037 L p F P
0 g
s
0 .166 .603 r
.38376 .66711 m .35221 .64593 L .38069 .66569 L p F P
0 g
s
0 .166 .603 r
.38069 .66569 m .40654 .68292 L .38376 .66711 L p F P
0 g
s
0 0 0 r
.64869 .66426 m .62231 .68178 L .59519 .69447 L p F P
0 g
s
.445 .836 .618 r
.62231 .68178 m .64869 .66426 L .67661 .6442 L p F P
0 g
s
.653 .766 .932 r
.51204 .24314 m .51246 .26895 L .49181 .27061 L p F P
0 g
s
.653 .766 .932 r
.49181 .27061 m .48148 .24563 L .51204 .24314 L p F P
0 g
s
.633 .746 .93 r
.53316 .27037 m .54266 .24526 L .57182 .25187 L p F P
0 g
s
.642 .757 .932 r
.54266 .24526 m .53316 .27037 L .51246 .26895 L p F P
0 g
s
0 0 0 r
.2184 .38442 m .22077 .36397 L .2142 .40683 L p F P
0 g
s
0 0 0 r
.2142 .40683 m .21181 .42739 L .2184 .38442 L p F P
0 g
s
.697 .806 .933 r
.40045 .24843 m .42659 .26362 L .40495 .27818 L p F P
0 g
s
.697 .806 .933 r
.40495 .27818 m .37246 .26743 L .40045 .24843 L p F P
0 g
s
.642 .757 .932 r
.51246 .26895 m .51204 .24314 L .54266 .24526 L p F P
0 g
s
.73 .839 .932 r
.34334 .26082 m .37246 .26743 L .35145 .28998 L p F P
0 g
s
.73 .839 .932 r
.35145 .28998 m .31822 .28804 L .34334 .26082 L p F P
0 g
s
.587 .703 .922 r
.6201 .27691 m .65211 .26577 L .67376 .28808 L p F P
0 g
s
.588 .719 .934 r
.65211 .26577 m .6201 .27691 L .59806 .2626 L p F P
0 g
s
.823 .928 .903 r
.26721 .29634 m .28987 .29006 L .27235 .3244 L p F P
0 g
s
.823 .928 .903 r
.27235 .3244 m .24816 .33406 L .26721 .29634 L p F P
0 g
s
.002 .203 .716 r
.25131 .50471 m .23054 .47628 L .23741 .51557 L p F P
0 g
s
.002 .203 .716 r
.23741 .51557 m .25747 .54085 L .25131 .50471 L p F P
0 g
s
.538 .684 .933 r
.7067 .28575 m .67376 .28808 L .65211 .26577 L p F P
0 g
s
0 .04 .603 r
.79471 .34394 m .8047 .3606 L .81248 .40341 L p F P
0 g
s
.777 .554 0 r
.81487 .42396 m .81248 .40341 L .8047 .3606 L p F P
0 g
s
.348 .547 .905 r
.7774 .33098 m .75329 .32159 L .73481 .28744 L p F P
0 g
s
.478 .626 .917 r
.7067 .28575 m .73481 .28744 L .75329 .32159 L p F P
0 g
s
.942 .962 .719 r
.77021 .53803 m .79037 .5125 L .79613 .47311 L p F P
0 g
s
.935 .936 .584 r
.8094 .44718 m .79613 .47311 L .79037 .5125 L p F P
0 g
s
.449 0 0 r
.47812 .71612 m .46494 .70381 L .49795 .70805 L p F P
0 g
s
.449 0 0 r
.49795 .70805 m .50214 .7192 L .47812 .71612 L p F P
0 g
s
.371 0 0 r
.50214 .7192 m .49795 .70805 L .53162 .70788 L p F P
0 g
s
.371 0 0 r
.53162 .70788 m .52665 .71907 L .50214 .7192 L p F P
0 g
s
.249 0 0 r
.52665 .71907 m .53162 .70788 L .56451 .70329 L p F P
0 g
s
0 0 .456 r
.22382 .40861 m .2184 .38442 L .21181 .42739 L p F P
0 g
s
0 0 .456 r
.21181 .42739 m .21728 .45053 L .22382 .40861 L p F P
0 g
s
0 .294 .791 r
.3176 .59692 m .2844 .56792 L .30011 .59826 L p F P
0 g
s
0 .294 .791 r
.30011 .59826 m .33081 .62268 L .3176 .59692 L p F P
0 g
s
.483 0 0 r
.45565 .70997 m .43402 .69532 L .46494 .70381 L p F P
0 g
s
.483 0 0 r
.46494 .70381 m .47812 .71612 L .45565 .70997 L p F P
0 g
s
.678 .804 .943 r
.43412 .23399 m .45251 .25258 L .42659 .26362 L p F P
0 g
s
.678 .804 .943 r
.42659 .26362 m .40045 .24843 L .43412 .23399 L p F P
0 g
s
.249 0 0 r
.56451 .70329 m .55058 .71574 L .52665 .71907 L p F P
0 g
s
.07 0 0 r
.55058 .71574 m .56451 .70329 L .59519 .69447 L p F P
0 g
s
.862 .993 .824 r
.25092 .30713 m .26721 .29634 L .24816 .33406 L p F P
0 g
s
.862 .993 .824 r
.24816 .33406 m .23079 .34722 L .25092 .30713 L p F P
0 g
s
.684 .957 .711 r
.72831 .59594 m .69735 .62071 L .67661 .6442 L p F P
0 g
s
.859 .997 .795 r
.69735 .62071 m .72831 .59594 L .74317 .56541 L p F P
0 g
s
.851 .993 .742 r
.77021 .53803 m .74317 .56541 L .72831 .59594 L p F P
0 g
s
.588 .719 .934 r
.59806 .2626 m .62358 .2471 L .65211 .26577 L p F P
0 g
s
.594 .737 .943 r
.62358 .2471 m .59806 .2626 L .57182 .25187 L p F P
0 g
s
.989 .842 .469 r
.8094 .44718 m .81487 .42396 L .80706 .38104 L p F P
0 g
s
.777 .554 0 r
.8047 .3606 m .80706 .38104 L .81487 .42396 L p F P
0 g
s
0 .259 .753 r
.36674 .64855 m .33081 .62268 L .35221 .64593 L p F P
0 g
s
0 .259 .753 r
.35221 .64593 m .38376 .66711 L .36674 .64855 L p F P
0 g
s
.062 .349 .823 r
.79471 .34394 m .7774 .33098 L .75728 .29345 L p F P
0 g
s
.348 .547 .905 r
.73481 .28744 m .75728 .29345 L .7774 .33098 L p F P
0 g
s
.753 .889 .94 r
.31843 .25886 m .34334 .26082 L .31822 .28804 L p F P
0 g
s
.753 .889 .94 r
.31822 .28804 m .28987 .29006 L .31843 .25886 L p F P
0 g
s
.445 .836 .618 r
.67661 .6442 m .64464 .66573 L .62231 .68178 L p F P
0 g
s
.712 .976 .762 r
.64464 .66573 m .67661 .6442 L .69735 .62071 L p F P
0 g
s
.454 .649 .942 r
.73481 .28744 m .7067 .28575 L .68081 .25881 L p F P
0 g
s
.538 .684 .933 r
.65211 .26577 m .68081 .25881 L .7067 .28575 L p F P
0 g
s
.122 .306 .777 r
.27914 .53586 m .25131 .50471 L .25747 .54085 L p F P
0 g
s
.122 .306 .777 r
.25747 .54085 m .2844 .56792 L .27914 .53586 L p F P
0 g
s
.705 .844 .949 r
.37698 .23783 m .40045 .24843 L .37246 .26743 L p F P
0 g
s
.705 .844 .949 r
.37246 .26743 m .34334 .26082 L .37698 .23783 L p F P
0 g
s
.454 0 0 r
.43574 .701 m .40654 .68292 L .43402 .69532 L p F P
0 g
s
.454 0 0 r
.43402 .69532 m .45565 .70997 L .43574 .701 L p F P
0 g
s
.536 .708 .95 r
.68081 .25881 m .65211 .26577 L .62358 .2471 L p F P
0 g
s
.07 0 0 r
.59519 .69447 m .57287 .70935 L .55058 .71574 L p F P
0 g
s
0 0 0 r
.57287 .70935 m .59519 .69447 L .62231 .68178 L p F P
0 g
s
.657 .797 .95 r
.47182 .22489 m .48148 .24563 L .45251 .25258 L p F P
0 g
s
.657 .797 .95 r
.45251 .25258 m .43412 .23399 L .47182 .22489 L p F P
0 g
s
.928 .957 .778 r
.74317 .56541 m .77021 .53803 L .77534 .5018 L p F P
0 g
s
.942 .962 .719 r
.79613 .47311 m .77534 .5018 L .77021 .53803 L p F P
0 g
s
.594 .737 .943 r
.57182 .25187 m .5895 .23306 L .62358 .2471 L p F P
0 g
s
.604 .755 .95 r
.5895 .23306 m .57182 .25187 L .54266 .24526 L p F P
0 g
s
.095 .172 .655 r
.23693 .43654 m .22382 .40861 L .21728 .45053 L p F P
0 g
s
.095 .172 .655 r
.21728 .45053 m .23054 .47628 L .23693 .43654 L p F P
0 g
s
.709 .856 .436 r
.24151 .32264 m .25092 .30713 L .23079 .34722 L p F P
0 g
s
.709 .856 .436 r
.23079 .34722 m .22077 .36397 L .24151 .32264 L p F P
0 g
s
.981 .89 .658 r
.79613 .47311 m .8094 .44718 L .80167 .40531 L p F P
0 g
s
.989 .842 .469 r
.80706 .38104 m .80167 .40531 L .8094 .44718 L p F P
0 g
s
.637 .786 .953 r
.51164 .22164 m .51204 .24314 L .48148 .24563 L p F P
0 g
s
.637 .786 .953 r
.48148 .24563 m .47182 .22489 L .51164 .22164 L p F P
0 g
s
0 0 .415 r
.8047 .3606 m .79471 .34394 L .77344 .30406 L p F P
0 g
s
.062 .349 .823 r
.75728 .29345 m .77344 .30406 L .79471 .34394 L p F P
0 g
s
.604 .755 .95 r
.54266 .24526 m .55155 .22441 L .5895 .23306 L p F P
0 g
s
.619 .772 .953 r
.55155 .22441 m .54266 .24526 L .51204 .24314 L p F P
0 g
s
.619 .772 .953 r
.51204 .24314 m .51164 .22164 L .55155 .22441 L p F P
0 g
s
.774 .958 .93 r
.29849 .262 m .31843 .25886 L .28987 .29006 L p F P
0 g
s
.774 .958 .93 r
.28987 .29006 m .26721 .29634 L .29849 .262 L p F P
0 g
s
0 .204 .642 r
.41931 .68958 m .38376 .66711 L .40654 .68292 L p F P
0 g
s
0 .204 .642 r
.40654 .68292 m .43574 .701 L .41931 .68958 L p F P
0 g
s
.282 .562 .931 r
.75728 .29345 m .73481 .28744 L .70536 .25656 L p F P
0 g
s
.454 .649 .942 r
.68081 .25881 m .70536 .25656 L .73481 .28744 L p F P
0 g
s
0 0 0 r
.62231 .68178 m .59252 .70017 L .57287 .70935 L p F P
0 g
s
.473 .86 .656 r
.59252 .70017 m .62231 .68178 L .64464 .66573 L p F P
0 g
s
.674 .841 .963 r
.41757 .22032 m .43412 .23399 L .40045 .24843 L p F P
0 g
s
.674 .841 .963 r
.40045 .24843 m .37698 .23783 L .41757 .22032 L p F P
0 g
s
.045 .339 .818 r
.35636 .62804 m .3176 .59692 L .33081 .62268 L p F P
0 g
s
.045 .339 .818 r
.33081 .62268 m .36674 .64855 L .35636 .62804 L p F P
0 g
s
0 0 .234 r
.23929 .34297 m .24151 .32264 L .22077 .36397 L p F P
0 g
s
0 0 .234 r
.22077 .36397 m .2184 .38442 L .23929 .34297 L p F P
0 g
s
.536 .708 .95 r
.62358 .2471 m .64651 .23622 L .68081 .25881 L p F P
0 g
s
.541 .734 .964 r
.64651 .23622 m .62358 .2471 L .5895 .23306 L p F P
0 g
s
.223 .302 .734 r
.25743 .4682 m .23693 .43654 L .23054 .47628 L p F P
0 g
s
.223 .302 .734 r
.23054 .47628 m .25131 .50471 L .25743 .4682 L p F P
0 g
s
.712 .976 .762 r
.69735 .62071 m .66112 .64698 L .64464 .66573 L p F P
0 g
s
.859 .995 .82 r
.66112 .64698 m .69735 .62071 L .70982 .59479 L p F P
0 g
s
.859 .997 .795 r
.74317 .56541 m .70982 .59479 L .69735 .62071 L p F P
0 g
s
.711 .897 .963 r
.35687 .23247 m .37698 .23783 L .34334 .26082 L p F P
0 g
s
.711 .897 .963 r
.34334 .26082 m .31843 .25886 L .35687 .23247 L p F P
0 g
s
.187 .362 .807 r
.31336 .56976 m .27914 .53586 L .2844 .56792 L p F P
0 g
s
.187 .362 .807 r
.2844 .56792 m .3176 .59692 L .31336 .56976 L p F P
0 g
s
0 0 .415 r
.77344 .30406 m .78278 .31947 L .8047 .3606 L p F P
0 g
s
.964 .658 .251 r
.80706 .38104 m .8047 .3606 L .78278 .31947 L p F P
0 g
s
.951 .891 .734 r
.77534 .5018 m .79613 .47311 L .7886 .43342 L p F P
0 g
s
.981 .89 .658 r
.80167 .40531 m .7886 .43342 L .79613 .47311 L p F P
0 g
s
.439 .678 .965 r
.70536 .25656 m .68081 .25881 L .64651 .23622 L p F P
0 g
s
.915 .949 .806 r
.70982 .59479 m .74317 .56541 L .74751 .53327 L p F P
0 g
s
.928 .957 .778 r
.77534 .5018 m .74751 .53327 L .74317 .56541 L p F P
0 g
s
.72 .983 .783 r
.28414 .27061 m .29849 .262 L .26721 .29634 L p F P
0 g
s
.72 .983 .783 r
.26721 .29634 m .25092 .30713 L .28414 .27061 L p F P
0 g
s
0 .289 .776 r
.40711 .67622 m .36674 .64855 L .38376 .66711 L p F P
0 g
s
0 .289 .776 r
.38376 .66711 m .41931 .68958 L .40711 .67622 L p F P
0 g
s
0 .29 .776 r
.77344 .30406 m .75728 .29345 L .72501 .25947 L p F P
0 g
s
.282 .562 .931 r
.70536 .25656 m .72501 .25947 L .75728 .29345 L p F P
0 g
s
.64 .831 .974 r
.46312 .20928 m .47182 .22489 L .43412 .23399 L p F P
0 g
s
.64 .831 .974 r
.43412 .23399 m .41757 .22032 L .46312 .20928 L p F P
0 g
s
.473 .86 .656 r
.64464 .66573 m .60862 .68859 L .59252 .70017 L p F P
0 g
s
.723 .983 .784 r
.60862 .68859 m .64464 .66573 L .66112 .64698 L p F P
0 g
s
.15 .109 .552 r
.24437 .36819 m .23929 .34297 L .2184 .38442 L p F P
0 g
s
.15 .109 .552 r
.2184 .38442 m .22382 .40861 L .24437 .36819 L p F P
0 g
s
.541 .734 .964 r
.5895 .23306 m .60541 .2192 L .64651 .23622 L p F P
0 g
s
.554 .761 .974 r
.60541 .2192 m .5895 .23306 L .55155 .22441 L p F P
0 g
s
.985 .787 .557 r
.80167 .40531 m .80706 .38104 L .78498 .3398 L p F P
0 g
s
.964 .658 .251 r
.78278 .31947 m .78498 .3398 L .80706 .38104 L p F P
0 g
s
.291 .37 .772 r
.28485 .50354 m .25743 .4682 L .25131 .50471 L p F P
0 g
s
.291 .37 .772 r
.25131 .50471 m .27914 .53586 L .28485 .50354 L p F P
0 g
s
.444 0 0 r
.49259 .72938 m .47812 .71612 L .50214 .7192 L p F P
0 g
s
.444 0 0 r
.50214 .7192 m .50675 .73119 L .49259 .72938 L p F P
0 g
s
.366 0 0 r
.50675 .73119 m .50214 .7192 L .52665 .71907 L p F P
0 g
s
.366 0 0 r
.52665 .71907 m .5212 .73112 L .50675 .73119 L p F P
0 g
s
.244 0 0 r
.5212 .73112 m .52665 .71907 L .55058 .71574 L p F P
0 g
s
.927 .884 .771 r
.74751 .53327 m .77534 .5018 L .76817 .46533 L p F P
0 g
s
.951 .891 .734 r
.7886 .43342 m .76817 .46533 L .77534 .5018 L p F P
0 g
s
.607 .812 .979 r
.51128 .20533 m .51164 .22164 L .47182 .22489 L p F P
0 g
s
.607 .812 .979 r
.47182 .22489 m .46312 .20928 L .51128 .20533 L p F P
0 g
s
.554 .761 .974 r
.55155 .22441 m .55955 .2087 L .60541 .2192 L p F P
0 g
s
.577 .789 .979 r
.55955 .2087 m .55155 .22441 L .51164 .22164 L p F P
0 g
s
.478 0 0 r
.47937 .72577 m .45565 .70997 L .47812 .71612 L p F P
0 g
s
.478 0 0 r
.47812 .71612 m .49259 .72938 L .47937 .72577 L p F P
0 g
s
.687 .96 .944 r
.34074 .23291 m .35687 .23247 L .31843 .25886 L p F P
0 g
s
.687 .96 .944 r
.31843 .25886 m .29849 .262 L .34074 .23291 L p F P
0 g
s
.244 0 0 r
.55058 .71574 m .5353 .72916 L .5212 .73112 L p F P
0 g
s
.064 0 0 r
.5353 .72916 m .55058 .71574 L .57287 .70935 L p F P
0 g
s
.577 .789 .979 r
.51164 .22164 m .51128 .20533 L .55955 .2087 L p F P
0 g
s
.656 .892 .982 r
.40338 .21234 m .41757 .22032 L .37698 .23783 L p F P
0 g
s
.656 .892 .982 r
.37698 .23783 m .35687 .23247 L .40338 .21234 L p F P
0 g
s
.219 .583 .944 r
.72501 .25947 m .70536 .25656 L .66616 .23062 L p F P
0 g
s
.439 .678 .965 r
.64651 .23622 m .66616 .23062 L .70536 .25656 L p F P
0 g
s
0 0 0 r
.27584 .28494 m .28414 .27061 L .25092 .30713 L p F P
0 g
s
0 0 0 r
.25092 .30713 m .24151 .32264 L .27584 .28494 L p F P
0 g
s
.435 .714 .983 r
.66616 .23062 m .64651 .23622 L .60541 .2192 L p F P
0 g
s
.223 .392 .821 r
.3532 .60649 m .31336 .56976 L .3176 .59692 L p F P
0 g
s
.223 .392 .821 r
.3176 .59692 m .35636 .62804 L .3532 .60649 L p F P
0 g
s
.295 .28 .672 r
.25668 .39826 m .24437 .36819 L .22382 .40861 L p F P
0 g
s
.295 .28 .672 r
.22382 .40861 m .23693 .43654 L .25668 .39826 L p F P
0 g
s
0 .29 .776 r
.72501 .25947 m .73916 .26791 L .77344 .30406 L p F P
0 g
s
.782 .309 0 r
.78278 .31947 m .77344 .30406 L .73916 .26791 L p F P
0 g
s
.859 .995 .82 r
.70982 .59479 m .67091 .62635 L .66112 .64698 L p F P
0 g
s
.906 .943 .82 r
.67091 .62635 m .70982 .59479 L .71327 .56758 L p F P
0 g
s
.915 .949 .806 r
.74751 .53327 m .71327 .56758 L .70982 .59479 L p F P
0 g
s
.469 0 0 r
.5017 .74217 m .4677 .72052 L .47937 .72577 L p F P
0 g
s
0 .19 .628 r
.49927 .74048 m .49667 .73879 L p .4677 .72052 L F P
0 g
s
.448 0 0 r
.43924 .70257 m .45565 .70997 L p .4677 .72052 L F P
0 g
s
.448 0 0 r
.45565 .70997 m .47937 .72577 L .4677 .72052 L p F P
0 g
s
0 .19 .628 r
.49667 .73879 m .4581 .71385 L .4677 .72052 L p F P
0 g
s
.448 0 0 r
.4677 .72052 m .43574 .701 L .43924 .70257 L p F P
0 g
s
.064 0 0 r
.57287 .70935 m .54841 .72541 L .5353 .72916 L p F P
0 g
s
0 0 0 r
.54841 .72541 m .57287 .70935 L .59252 .70017 L p F P
0 g
s
.949 .811 .672 r
.7886 .43342 m .80167 .40531 L .77994 .3651 L p F P
0 g
s
.985 .787 .557 r
.78498 .3398 m .77994 .3651 L .80167 .40531 L p F P
0 g
s
.072 .359 .829 r
.39977 .6615 m .35636 .62804 L .36674 .64855 L p F P
0 g
s
.072 .359 .829 r
.36674 .64855 m .40711 .67622 L .39977 .6615 L p F P
0 g
s
.723 .983 .784 r
.66112 .64698 m .62042 .67509 L .60862 .68859 L p F P
0 g
s
.858 .993 .831 r
.62042 .67509 m .66112 .64698 L .67091 .62635 L p F P
0 g
s
.329 .408 .792 r
.3185 .54246 m .28485 .50354 L .27914 .53586 L p F P
0 g
s
.329 .408 .792 r
.27914 .53586 m .31336 .56976 L .3185 .54246 L p F P
0 g
s
.912 .879 .79 r
.71327 .56758 m .74751 .53327 L .74086 .501 L p F P
0 g
s
.927 .884 .771 r
.76817 .46533 m .74086 .501 L .74751 .53327 L p F P
0 g
s
0 .21 .648 r
.4581 .71385 m .41931 .68958 L .43574 .701 L p F P
0 g
s
0 .21 .648 r
.43574 .701 m .4677 .72052 L .4581 .71385 L p F P
0 g
s
0 0 0 r
.55993 .72004 m .54841 .72541 L p .58239 .70597 L F P
0 g
s
0 0 0 r
.52232 .74341 m .54841 .72541 L .55993 .72004 L p F P
0 g
s
0 0 0 r
.52525 .74204 m .52232 .74341 L p .53252 .73707 L F P
0 g
s
0 0 0 r
.55993 .72004 m .52525 .74204 L p .53252 .73707 L F P
0 g
s
.53 0 0 r
.50805 .74442 m .51133 .74722 L .51075 .74739 L F
.51267 .74836 m .51389 .7494 L .51279 .7487 L F
.512 0 0 r
.5093 .74682 m .51224 .74892 L .5108 .74808 L F
.5134 .74975 m .51377 .75002 L .5134 .74978 L F
.53698 .76666 m .51336 .75026 L p .51377 .75002 L F P
0 g
s
0 .145 .581 r
.54186 .77005 m .51336 .75026 L p .51339 .75028 L F P
0 g
s
.512 0 0 r
.51377 .75002 m .51827 .75367 L .53698 .76666 L F
.51336 .75026 m .51452 .75063 L .51377 .75002 L F
0 .145 .581 r
.53698 .76666 m .54186 .77005 L p .51339 .75028 L F P
0 g
s
0 .145 .581 r
.51339 .75028 m .53698 .76666 L .51339 .75028 L F
.51304 .75004 m .51339 .75028 L .51302 .75002 L F
.51339 .75028 m .53698 .76666 L .51339 .75028 L F
.51339 .75028 m .51339 .75028 L .51302 .75002 L F
0 .243 .739 r
.5086 .74725 m .51271 .75024 L .51336 .75026 L F
0 .145 .581 r
.51336 .75026 m .53698 .76666 L p .51339 .75028 L F P
0 g
s
0 .145 .581 r
.51336 .75026 m .51339 .75028 L .51256 .7497 L F
.51302 .75002 m .51339 .75028 L .51339 .75028 L F
.51256 .7497 m .51304 .75004 L .51302 .75002 L F
.53 0 0 r
.51407 .7498 m .51561 .75168 L .51424 .74969 L F
0 .243 .739 r
.52666 .76037 m .52048 .75553 L .5454 .77399 L F
.512 0 0 r
.50467 .7435 m .51336 .75026 L p .51291 .74941 L F P
0 g
s
.512 0 0 r
.5017 .74217 m .50467 .7435 L p .5093 .74682 L F P
0 g
s
.512 0 0 r
.5093 .74682 m .5108 .74808 L .5017 .74217 L F
.51336 .75026 m .5017 .74217 L p .50939 .74717 L F P
0 g
s
.512 0 0 r
.51242 .74914 m .51336 .75026 L .51174 .7487 L F
.53 0 0 r
.50467 .7435 m .50805 .74442 L p .51075 .74739 L F P
0 g
s
.512 0 0 r
.51296 .74949 m .51336 .75026 L .51242 .74914 L F
.51377 .75002 m .51336 .75026 L .51296 .74949 L F
.51174 .7487 m .51336 .75026 L .50939 .74717 L F
.5134 .74975 m .51336 .75026 L .51377 .75002 L F
.51291 .74941 m .51336 .75026 L .5134 .74975 L F
.51224 .74892 m .5134 .74975 L .51242 .74914 L F
.5134 .74975 m .5134 .74978 L .51242 .74914 L F
.51224 .74892 m .51242 .74914 L .5108 .74808 L F
.53 0 0 r
.51336 .75026 m .50467 .7435 L p .51196 .74817 L F P
0 g
s
.53 0 0 r
.51389 .7494 m .51336 .75026 L .51196 .74817 L F
.495 0 0 r
.50467 .7435 m .47937 .72577 L .49259 .72938 L p F P
0 g
s
.495 0 0 r
.49259 .72938 m .50805 .74442 L .50467 .7435 L p F P
0 g
s
.469 0 0 r
.47937 .72577 m .50467 .7435 L .5017 .74217 L p F P
0 g
s
.031 .327 .811 r
.51336 .75026 m .49646 .73636 L .4975 .73851 L p F P
0 g
s
.214 .384 .817 r
.51336 .75026 m .49622 .73412 L p .50386 .74304 L F P
0 g
s
.53 0 0 r
.50805 .74442 m .51336 .75026 L p .51267 .74836 L F P
0 g
s
.491 0 0 r
.50805 .74442 m .51167 .74488 L p .51418 .74835 L F P
0 g
s
0 .243 .739 r
.5104 .74839 m .5123 .7497 L .5086 .74725 L F
.51292 .75013 m .51337 .75044 L .51269 .75005 L F
.5123 .7497 m .51171 .74939 L .5086 .74725 L F
.5123 .7497 m .51292 .75013 L .51171 .74939 L F
.51292 .75013 m .51269 .75005 L .51171 .74939 L F
.5086 .74725 m .5123 .74979 L .51176 .74955 L F
.5123 .74979 m .51338 .75053 L .51176 .74955 L F
.50589 .74529 m .5104 .74839 L .5086 .74725 L F
0 .145 .581 r
.5017 .74217 m .51336 .75026 L p .51256 .7497 L F P
0 g
s
0 .145 .581 r
.5017 .74217 m .51339 .75028 L .51336 .75026 L F
.51336 .75026 m .49927 .74048 L .5017 .74217 L p F P
0 g
s
0 .19 .628 r
.4677 .72052 m .5017 .74217 L .49927 .74048 L p F P
0 g
s
0 .243 .739 r
.49927 .74048 m .51336 .75026 L p .50589 .74529 L F P
0 g
s
.53 0 0 r
.51336 .75026 m .51394 .74988 L .51267 .74836 L F
.51133 .74722 m .51267 .74836 L .51196 .74817 L F
.51267 .74836 m .51279 .7487 L .51196 .74817 L F
.51133 .74722 m .51196 .74817 L .51075 .74739 L F
.491 0 0 r
.51336 .75026 m .50805 .74442 L p .5124 .74721 L F P
0 g
s
.53 0 0 r
.51267 .74836 m .5134 .74924 L .51341 .74899 L F
0 .243 .739 r
.51336 .75026 m .54186 .77005 L p .51491 .7515 L F P
0 g
s
.214 .384 .817 r
.49646 .73636 m .51336 .75026 L p .50386 .74304 L F P
0 g
s
.345 .423 .799 r
.49622 .73412 m .51336 .75026 L p .50646 .74488 L F P
0 g
s
.46 0 0 r
.50805 .74442 m .49259 .72938 L .50675 .73119 L p F P
0 g
s
.46 0 0 r
.50675 .73119 m .51167 .74488 L .50805 .74442 L p F P
0 g
s
.345 .423 .799 r
.51336 .75026 m .49677 .73191 L p .50646 .74488 L F P
0 g
s
.439 .453 .778 r
.49677 .73191 m .51336 .75026 L .5079 .74591 L F
.51336 .75026 m .49811 .72981 L p .5079 .74591 L F P
0 g
s
.509 .479 .759 r
.50016 .72794 m .49811 .72981 L p .50883 .74657 L F P
0 g
s
0 .243 .739 r
.51336 .75026 m .51267 .74995 L .50589 .74529 L F
.4975 .73851 m .49927 .74048 L p .5086 .74725 L F P
0 g
s
0 .243 .739 r
.51336 .75026 m .4975 .73851 L p .5086 .74725 L F P
0 g
s
.031 .327 .811 r
.4975 .73851 m .50983 .74834 L .5085 .74666 L F
.50983 .74834 m .5116 .74974 L .5085 .74666 L F
.5085 .74666 m .5116 .74974 L .51336 .75026 L F
.345 .423 .799 r
.51512 .75397 m .5152 .75368 L .51566 .75454 L F
.51285 .75159 m .51449 .75305 L .51468 .75351 L F
.51468 .75351 m .51482 .75335 L .51512 .75397 L F
.51449 .75305 m .51482 .75335 L .51468 .75351 L F
.51482 .75335 m .5152 .75368 L .51512 .75397 L F
.51566 .75454 m .51814 .75643 L .52109 .76024 L F
.5152 .75368 m .5192 .75724 L .51566 .75454 L F
.50993 .74852 m .51298 .75127 L .51285 .75159 L F
.509 .479 .759 r
.49811 .72981 m .51336 .75026 L p .50414 .73923 L F P
0 g
s
.509 .479 .759 r
.51336 .75026 m .50016 .72794 L p .50883 .74657 L F P
0 g
s
.565 .503 .745 r
.50016 .72794 m .51336 .75026 L p .50714 .74222 L F P
0 g
s
.53 0 0 r
.5134 .74924 m .51418 .75016 L .51341 .74899 L F
.491 0 0 r
.51418 .74835 m .51336 .75026 L .5124 .74721 L F
.53 0 0 r
.51418 .75016 m .51426 .75015 L .51341 .74899 L F
0 .243 .739 r
.51336 .75026 m .51491 .7515 L .51469 .75135 L F
.51336 .75026 m .51469 .75135 L .51347 .75051 L F
.51336 .75026 m .51347 .75051 L .51267 .74995 L F
.51338 .75053 m .5146 .75137 L .51338 .75065 L F
.5146 .75137 m .51473 .75148 L .51338 .75065 L F
.5151 .75171 m .51534 .7519 L .51501 .75169 L F
.51484 .75155 m .51501 .75169 L .51338 .75065 L F
.5151 .75171 m .51501 .75169 L .51484 .75155 L F
.382 0 0 r
.51167 .74488 m .50675 .73119 L .5212 .73112 L p F P
0 g
s
.345 .423 .799 r
.51512 .7532 m .51563 .75407 L .51482 .75335 L F
.51457 .75281 m .51482 .75335 L .51285 .75159 L F
.51512 .7532 m .51482 .75335 L .51457 .75281 L F
0 .243 .739 r
.5161 .75239 m .51723 .75327 L .51586 .75234 L F
.51338 .75053 m .51338 .75065 L .51176 .74955 L F
.51337 .75044 m .51338 .75053 L .51269 .75005 L F
.51271 .75024 m .51308 .75049 L .51307 .7505 L F
.51176 .74955 m .51278 .75024 L .51271 .75024 L F
.51278 .75024 m .51381 .75095 L .51271 .75024 L F
.51381 .75095 m .51464 .75151 L .51384 .75098 L F
.51381 .75095 m .51384 .75098 L .51271 .75024 L F
.51271 .75024 m .51307 .7505 L .51336 .75026 L F
.509 .479 .759 r
.50414 .73923 m .51059 .74766 L .50795 .7452 L F
.031 .327 .811 r
.5116 .74974 m .51339 .75117 L .51336 .75026 L F
0 .243 .739 r
.51307 .7505 m .51418 .75131 L .51336 .75026 L F
.51418 .75131 m .51544 .75222 L .51336 .75026 L F
.5454 .77399 m .51336 .75026 L p .51544 .75222 L F P
0 g
s
0 .243 .739 r
.51464 .75151 m .54186 .77005 L .51478 .75165 L F
.51464 .75151 m .51478 .75165 L .51407 .75116 L F
.51402 .7511 m .51407 .75116 L .51271 .75024 L F
.51464 .75151 m .51407 .75116 L .51402 .7511 L F
.51307 .7505 m .51388 .75105 L .51393 .75113 L F
.51308 .75049 m .51425 .75129 L .51307 .7505 L F
.51425 .75129 m .51496 .75177 L .51427 .7513 L F
.51425 .75129 m .51427 .7513 L .51307 .7505 L F
.51496 .75177 m .51514 .75189 L .51496 .75177 L F
.51496 .75177 m .51496 .75177 L .51445 .75143 L F
.51427 .7513 m .51427 .75131 L .51307 .7505 L F
.031 .327 .811 r
.51444 .75201 m .51769 .75431 L .5197 .75619 L F
.5116 .74974 m .51336 .75026 L .51444 .75201 L F
.4975 .73851 m .51336 .75026 L p .5116 .74974 L F P
0 g
s
.53 0 0 r
.51418 .75016 m .51491 .75104 L .51426 .75015 L F
.51491 .75104 m .51522 .7512 L .51464 .75049 L F
.51449 .75047 m .51464 .75049 L .51341 .74899 L F
.51491 .75104 m .51464 .75049 L .51449 .75047 L F
0 .243 .739 r
.51444 .75142 m .51445 .75143 L .51427 .75131 L F
.51444 .75142 m .51427 .75131 L .51427 .7513 L F
.51496 .75177 m .51445 .75143 L .51444 .75142 L F
.51514 .75189 m .54186 .77005 L .51521 .75195 L F
.51514 .75189 m .51521 .75195 L .51465 .75158 L F
.51462 .75154 m .51465 .75158 L .51307 .7505 L F
.51514 .75189 m .51465 .75158 L .51462 .75154 L F
.509 .479 .759 r
.51336 .75026 m .51059 .74766 L .50414 .73923 L F
.214 .384 .817 r
.5104 .74801 m .51133 .74908 L .50386 .74304 L F
.51336 .75026 m .51133 .74908 L .5104 .74801 L F
.51336 .75026 m .51346 .7508 L .51133 .74908 L F
0 .243 .739 r
.5161 .75239 m .51586 .75234 L .51534 .7519 L F
.5151 .75171 m .5161 .75239 L .51534 .7519 L F
.5161 .75239 m .54186 .77005 L .51723 .75327 L F
.5157 .75204 m .54186 .77005 L .51678 .75286 L F
.5157 .75204 m .51678 .75286 L .51491 .75158 L F
.51464 .75135 m .51491 .75158 L .51338 .75053 L F
.5157 .75204 m .51491 .75158 L .51464 .75135 L F
.51534 .7519 m .51586 .75234 L .51536 .752 L F
.51501 .75169 m .51536 .752 L .51338 .75065 L F
.51534 .7519 m .51536 .752 L .51501 .75169 L F
.5146 .75137 m .5151 .75171 L .51473 .75148 L F
.51337 .75044 m .5144 .75114 L .51338 .75053 L F
.5144 .75114 m .5157 .75204 L .51464 .75135 L F
.5144 .75114 m .51464 .75135 L .51338 .75053 L F
.031 .327 .811 r
.51336 .75026 m .51537 .75267 L .51444 .75201 L F
0 .243 .739 r
.51393 .75113 m .51713 .75326 L .51976 .75536 L F
.51388 .75105 m .51774 .75367 L .51393 .75113 L F
.031 .327 .811 r
.51336 .75026 m .52207 .75743 L .51537 .75267 L F
.214 .384 .817 r
.50386 .74304 m .51421 .75237 L .51336 .75026 L F
.345 .423 .799 r
.51238 .75 m .51193 .74988 L .51142 .74874 L F
.51142 .74874 m .51193 .74988 L .50646 .74488 L F
.031 .327 .811 r
.51389 .75157 m .51502 .75247 L .51336 .75026 L F
.51339 .75117 m .51389 .75157 L .51336 .75026 L F
.51502 .75247 m .51535 .75273 L .51336 .75026 L F
.214 .384 .817 r
.51421 .75237 m .51791 .7557 L .51336 .75026 L F
.031 .327 .811 r
.51535 .75273 m .51831 .75509 L .51336 .75026 L F
.54742 .77828 m .51336 .75026 L p .51831 .75509 L F P
0 g
s
.214 .384 .817 r
.54785 .78272 m .51336 .75026 L p .51791 .7557 L F P
0 g
s
.214 .384 .817 r
.51262 .75012 m .51373 .75102 L .51148 .74991 L F
.51373 .75102 m .51379 .75114 L .51148 .74991 L F
.51405 .75128 m .51409 .75133 L .5139 .75123 L F
.51388 .75118 m .5139 .75123 L .51148 .74991 L F
.51405 .75128 m .5139 .75123 L .51388 .75118 L F
.509 .479 .759 r
.51059 .74766 m .51111 .74834 L .50987 .74699 L F
.214 .384 .817 r
.51418 .75139 m .51469 .75208 L .51148 .74991 L F
.51541 .75257 m .51671 .75404 L .51148 .74991 L F
.54742 .77828 m .54785 .78272 L p .51148 .74991 L F P
0 g
s
.214 .384 .817 r
.50386 .74304 m .51262 .75012 L .51148 .74991 L F
0 .243 .739 r
.51976 .75536 m .51774 .75367 L .52194 .75695 L F
.51713 .75326 m .51774 .75367 L .51976 .75536 L F
.52194 .75695 m .51874 .75435 L .52666 .76037 L F
.51774 .75367 m .51874 .75435 L .52194 .75695 L F
.51874 .75435 m .52048 .75553 L .52666 .76037 L F
.031 .327 .811 r
.51336 .75026 m .5454 .77399 L p .52207 .75743 L F P
0 g
s
.031 .327 .811 r
.5454 .77399 m .54742 .77828 L p .5197 .75619 L F P
0 g
s
.031 .327 .811 r
.51769 .75431 m .5454 .77399 L .5197 .75619 L F
.214 .384 .817 r
.51336 .75026 m .54742 .77828 L p .51346 .7508 L F P
0 g
s
.345 .423 .799 r
.51193 .74988 m .54785 .78272 L .51122 .74969 L F
.214 .384 .817 r
.51685 .75354 m .52082 .75728 L .51671 .75404 L F
.51685 .75354 m .54742 .77828 L .52082 .75728 L F
.51685 .75354 m .51671 .75404 L .51541 .75257 L F
.51418 .75139 m .51685 .75354 L .51469 .75208 L F
.345 .423 .799 r
.51336 .75026 m .54785 .78272 L p .51667 .75422 L F P
0 g
s
.345 .423 .799 r
.51512 .7532 m .54785 .78272 L .51563 .75407 L F
.5192 .75724 m .54785 .78272 L .52624 .76566 L F
0 .243 .739 r
.54186 .77005 m .5454 .77399 L p .52048 .75553 L F P
0 g
s
.512 0 0 r
.51336 .75026 m .53099 .76397 L p .51731 .75289 L F P
0 g
s
.512 0 0 r
.51336 .75026 m .51731 .75289 L .51452 .75063 L F
.53 0 0 r
.51491 .75104 m .52415 .76212 L .51522 .7512 L F
.51336 .75026 m .51591 .75224 L .51394 .74988 L F
.51336 .75026 m .51642 .75285 L .51591 .75224 L F
.51336 .75026 m .52415 .76212 L p .51642 .75285 L F P
0 g
s
.53 0 0 r
.51561 .75168 m .52415 .76212 L .51604 .75195 L F
.51561 .75168 m .51604 .75195 L .51424 .74969 L F
.51424 .74969 m .51604 .75195 L .5193 .75401 L F
.512 0 0 r
.53099 .76397 m .53698 .76666 L p .51827 .75367 L F P
0 g
s
.53 0 0 r
.51604 .75195 m .52415 .76212 L .5193 .75401 L F
.53099 .76397 m .51336 .75026 L p .51424 .74969 L F P
0 g
s
.491 0 0 r
.51504 .74953 m .51336 .75026 L .51907 .7551 L F
.345 .423 .799 r
.51108 .74911 m .51193 .74988 L .50993 .74852 L F
.51193 .74988 m .51122 .74969 L .50993 .74852 L F
.214 .384 .817 r
.51373 .75102 m .51405 .75128 L .51379 .75114 L F
.51405 .75128 m .51418 .75139 L .51409 .75133 L F
.345 .423 .799 r
.51336 .75026 m .51238 .75 L .51142 .74874 L F
.51336 .75026 m .51667 .75422 L .51583 .75344 L F
.51336 .75026 m .51583 .75344 L .51193 .74988 L F
.51298 .75127 m .51477 .75289 L .51285 .75159 L F
.51477 .75289 m .51512 .7532 L .51483 .753 L F
.51477 .75289 m .51483 .753 L .51285 .75159 L F
.52109 .76024 m .5192 .75724 L .52624 .76566 L F
.51814 .75643 m .5192 .75724 L .52109 .76024 L F
.54785 .78272 m .54667 .78711 L p .52624 .76566 L F P
0 g
s
.345 .423 .799 r
.50646 .74488 m .51108 .74911 L .50993 .74852 L F
.54667 .78711 m .51336 .75026 L p .50646 .74488 L F P
0 g
s
.439 .453 .778 r
.51336 .75026 m .54667 .78711 L p .5079 .74591 L F P
0 g
s
.439 .453 .778 r
.5079 .74591 m .50831 .74641 L .51336 .75026 L F
.50831 .74641 m .51096 .74975 L .51336 .75026 L F
.54393 .79124 m .51336 .75026 L p .51096 .74975 L F P
0 g
s
.509 .479 .759 r
.50987 .74699 m .51282 .75066 L .50795 .7452 L F
.51282 .75066 m .51417 .75235 L .51275 .75071 L F
.51282 .75066 m .51275 .75071 L .50795 .7452 L F
.439 .453 .778 r
.54667 .78711 m .54393 .79124 L p .5079 .74591 L F P
0 g
s
.509 .479 .759 r
.50795 .7452 m .51417 .75235 L .51671 .75888 L F
.51671 .75888 m .51452 .7528 L .51869 .76196 L F
.51417 .75235 m .51452 .7528 L .51671 .75888 L F
.53978 .79492 m .51336 .75026 L p .50883 .74657 L F P
0 g
s
.565 .503 .745 r
.50826 .74451 m .51697 .75843 L .53441 .79798 L F
.509 .479 .759 r
.51869 .76196 m .51604 .75479 L .53978 .79492 L F
.51452 .7528 m .51604 .75479 L .51869 .76196 L F
.565 .503 .745 r
.53978 .79492 m .53441 .79798 L p .51697 .75843 L F P
0 g
s
.509 .479 .759 r
.51111 .74834 m .51417 .75235 L .50987 .74699 L F
.53 0 0 r
.51341 .74899 m .51407 .7498 L .51424 .74969 L F
.51389 .7494 m .51424 .74969 L .51336 .75026 L F
.491 0 0 r
.51167 .74488 m .51336 .75026 L p .51485 .74927 L F P
0 g
s
.491 0 0 r
.51485 .74927 m .51336 .75026 L .51504 .74953 L F
.51418 .74835 m .51459 .74891 L .51336 .75026 L F
.52415 .76212 m .51336 .75026 L p .51459 .74891 L F P
0 g
s
.412 0 0 r
.51167 .74488 m .51537 .74486 L p .5159 .75094 L F P
0 g
s
.412 0 0 r
.5159 .75094 m .51432 .75052 L .51167 .74488 L F
.51336 .75026 m .51167 .74488 L p .51404 .74991 L F P
0 g
s
.382 0 0 r
.5212 .73112 m .51537 .74486 L .51167 .74488 L p F P
0 g
s
.612 .527 .735 r
.51336 .75026 m .50599 .7252 L p .50856 .73936 L F P
0 g
s
.652 .551 .728 r
.51336 .75026 m .50951 .72446 L p .51019 .74171 L F P
0 g
s
.565 .503 .745 r
.50925 .74562 m .51522 .75526 L .50826 .74451 L F
.51522 .75526 m .51528 .75543 L .50826 .74451 L F
.51643 .75722 m .51697 .75843 L .50826 .74451 L F
.50841 .74482 m .50981 .74664 L .51177 .74821 L F
.50714 .74222 m .50841 .74482 L .51177 .74821 L F
.509 .479 .759 r
.51336 .75026 m .51337 .7513 L .51059 .74766 L F
.565 .503 .745 r
.50898 .74599 m .52059 .76971 L .51212 .74905 L F
.50898 .74599 m .51212 .74905 L .51177 .74821 L F
.50714 .74222 m .51177 .74821 L .50283 .72638 L F
.51336 .75026 m .50283 .72638 L p .51223 .74932 L F P
0 g
s
.565 .503 .745 r
.51336 .75026 m .5108 .74812 L .50714 .74222 L F
.612 .527 .735 r
.51001 .74741 m .51336 .75026 L .50856 .73936 L F
.50649 .73709 m .51336 .75026 L .51001 .74741 L F
.50283 .72638 m .51336 .75026 L p .50649 .73709 L F P
0 g
s
.652 .551 .728 r
.51042 .7477 m .51336 .75026 L .51019 .74171 L F
.565 .503 .745 r
.51522 .75526 m .51643 .75722 L .51528 .75543 L F
.51643 .75722 m .53978 .79492 L .51697 .75843 L F
.50841 .74482 m .50898 .74599 L .50981 .74664 L F
.612 .527 .735 r
.50283 .72638 m .51001 .74741 L .50856 .73936 L F
.50599 .7252 m .50283 .72638 L p .50856 .73936 L F P
0 g
s
.652 .551 .728 r
.50907 .74083 m .51336 .75026 L .51042 .7477 L F
.688 .577 .725 r
.51065 .74571 m .5107 .74661 L .51336 .75026 L F
.652 .551 .728 r
.50599 .7252 m .51336 .75026 L p .50907 .74083 L F P
0 g
s
.688 .577 .725 r
.5105 .74289 m .51336 .75026 L .51077 .74794 L F
.722 .604 .725 r
.51336 .75026 m .51127 .74717 L .51124 .74629 L F
.509 .479 .759 r
.51336 .75026 m .54393 .79124 L p .51337 .7513 L F P
0 g
s
.565 .503 .745 r
.52059 .76971 m .51336 .75026 L .51223 .74932 L F
.53441 .79798 m .51336 .75026 L p .52059 .76971 L F P
0 g
s
.612 .527 .735 r
.53441 .79798 m .52807 .80028 L p .51001 .74741 L F P
0 g
s
.565 .503 .745 r
.51336 .75026 m .53978 .79492 L p .51643 .75722 L F P
0 g
s
.565 .503 .745 r
.51336 .75026 m .51643 .75722 L .5108 .74812 L F
.612 .527 .735 r
.51336 .75026 m .53441 .79798 L p .51001 .74741 L F P
0 g
s
.612 .527 .735 r
.52807 .80028 m .51336 .75026 L p .51001 .74741 L F P
0 g
s
.652 .551 .728 r
.52807 .80028 m .52105 .80172 L p .51042 .7477 L F P
0 g
s
.652 .551 .728 r
.51336 .75026 m .52807 .80028 L p .51042 .7477 L F P
0 g
s
.652 .551 .728 r
.52105 .80172 m .51336 .75026 L p .51042 .7477 L F P
0 g
s
.688 .577 .725 r
.5107 .74661 m .51112 .75456 L .51336 .75026 L F
.51112 .75456 m .51118 .75563 L .51336 .75026 L F
.51118 .75563 m .51137 .75926 L .51336 .75026 L F
.51368 .80223 m .51336 .75026 L p .51137 .75926 L F P
0 g
s
.688 .577 .725 r
.52105 .80172 m .51368 .80223 L p .51077 .74794 L F P
0 g
s
.688 .577 .725 r
.51336 .75026 m .52105 .80172 L p .51077 .74794 L F P
0 g
s
.722 .604 .725 r
.51336 .75026 m .51174 .75792 L .51166 .75611 L F
.412 0 0 r
.51582 .75003 m .51336 .75026 L .51589 .75079 L F
.51537 .74486 m .51336 .75026 L p .51582 .75003 L F P
0 g
s
.294 0 0 r
.51537 .74486 m .51897 .74436 L p .51527 .75082 L F P
0 g
s
.294 0 0 r
.51527 .75082 m .51452 .7506 L .51537 .74486 L F
.722 .604 .725 r
.51124 .74629 m .51107 .74816 L .51336 .75026 L F
.755 .635 .728 r
.51336 .75026 m .51154 .74854 L .51171 .74677 L F
.412 0 0 r
.51432 .75052 m .51336 .75026 L .51404 .74991 L F
.51589 .75079 m .51336 .75026 L .51596 .75164 L F
.294 0 0 r
.51336 .75026 m .51537 .74486 L p .5145 .75077 L F P
0 g
s
.26 0 0 r
.51537 .74486 m .5212 .73112 L .5353 .72916 L p F P
0 g
s
.26 0 0 r
.5353 .72916 m .51897 .74436 L .51537 .74486 L p F P
0 g
s
.787 .669 .734 r
.51336 .75026 m .52365 .72627 L p .51639 .73951 L F P
0 g
s
.755 .635 .728 r
.51171 .74677 m .51145 .74788 L .51336 .75026 L F
.688 .577 .725 r
.50951 .72446 m .51336 .75026 L p .5105 .74289 L F P
0 g
s
.688 .577 .725 r
.51336 .75026 m .5132 .7242 L p .51065 .74571 L F P
0 g
s
.722 .604 .725 r
.51336 .75026 m .51691 .72442 L p .51124 .74629 L F P
0 g
s
.755 .635 .728 r
.51336 .75026 m .52044 .72512 L p .51396 .74118 L F P
0 g
s
.722 .604 .725 r
.5132 .7242 m .51336 .75026 L p .51124 .74629 L F P
0 g
s
.755 .635 .728 r
.51171 .74677 m .51336 .75026 L .51396 .74118 L F
.51691 .72442 m .51336 .75026 L p .51171 .74677 L F P
0 g
s
.787 .669 .734 r
.51192 .74767 m .51336 .75026 L .51639 .73951 L F
.819 .709 .744 r
.51336 .75026 m .52636 .7278 L p .51523 .74381 L F P
0 g
s
.787 .669 .734 r
.51336 .75026 m .51185 .74825 L .51211 .74716 L F
.52044 .72512 m .51336 .75026 L p .51211 .74716 L F P
0 g
s
.819 .709 .744 r
.52365 .72627 m .51336 .75026 L p .51224 .74794 L F P
0 g
s
.851 .756 .758 r
.52847 .72965 m .52636 .7278 L p .51614 .74286 L F P
0 g
s
.722 .604 .725 r
.51336 .75026 m .51161 .75492 L .51158 .75405 L F
.851 .756 .758 r
.52636 .7278 m .51336 .75026 L p .51614 .74286 L F P
0 g
s
.722 .604 .725 r
.51336 .75026 m .51155 .75339 L .51127 .74717 L F
.851 .756 .758 r
.51336 .75026 m .52847 .72965 L p .51704 .74304 L F P
0 g
s
.722 .604 .725 r
.51336 .75026 m .51158 .75405 L .51155 .75339 L F
.51107 .74816 m .51011 .75891 L .51336 .75026 L F
.51336 .75026 m .51166 .75611 L .51161 .75492 L F
.51336 .75026 m .51368 .80223 L p .51174 .75792 L F P
0 g
s
.722 .604 .725 r
.50629 .80179 m .51336 .75026 L p .51011 .75891 L F P
0 g
s
.722 .604 .725 r
.51368 .80223 m .50629 .80179 L p .51124 .74629 L F P
0 g
s
.755 .635 .728 r
.51336 .75026 m .50629 .80179 L p .51154 .74854 L F P
0 g
s
.881 .811 .776 r
.51336 .75026 m .52987 .73173 L p .51668 .74472 L F P
0 g
s
.755 .635 .728 r
.51145 .74788 m .51134 .74835 L .51336 .75026 L F
.49923 .80042 m .51336 .75026 L p .51134 .74835 L F P
0 g
s
.755 .635 .728 r
.51171 .74677 m .51029 .76115 L .49923 .80042 L F
.50629 .80179 m .49923 .80042 L p .51029 .76115 L F P
0 g
s
.787 .669 .734 r
.51192 .74767 m .50886 .75575 L .51336 .75026 L F
.50886 .75575 m .50809 .75779 L .51336 .75026 L F
.294 0 0 r
.51625 .7491 m .51336 .75026 L .51537 .75064 L F
.51897 .74436 m .51336 .75026 L p .51625 .7491 L F P
0 g
s
.121 0 0 r
.51897 .74436 m .52232 .74341 L p .51931 .74571 L F P
0 g
s
.121 0 0 r
.51336 .75026 m .51897 .74436 L p .51941 .7461 L F P
0 g
s
.082 0 0 r
.51897 .74436 m .5353 .72916 L .54841 .72541 L p F P
0 g
s
.082 0 0 r
.54841 .72541 m .52232 .74341 L .51897 .74436 L p F P
0 g
s
.905 .876 .797 r
.51336 .75026 m .53049 .73395 L p .51983 .743 L F P
0 g
s
.787 .669 .734 r
.51336 .75026 m .51174 .74868 L .51185 .74825 L F
.819 .709 .744 r
.51183 .7487 m .51336 .75026 L .51523 .74381 L F
.787 .669 .734 r
.50809 .75779 m .50679 .76125 L .51336 .75026 L F
.50679 .76125 m .50396 .76871 L .51336 .75026 L F
.49282 .79819 m .51336 .75026 L p .50396 .76871 L F P
0 g
s
.787 .669 .734 r
.51336 .75026 m .49923 .80042 L p .51174 .74868 L F P
0 g
s
.787 .669 .734 r
.49923 .80042 m .49282 .79819 L p .51211 .74716 L F P
0 g
s
.819 .709 .744 r
.51336 .75026 m .49282 .79819 L p .50973 .75443 L F P
0 g
s
.819 .709 .744 r
.51336 .75026 m .50973 .75443 L .51224 .74794 L F
.851 .756 .758 r
.51464 .74585 m .51336 .75026 L .51704 .74304 L F
.881 .811 .776 r
.52847 .72965 m .51336 .75026 L p .51535 .74538 L F P
0 g
s
.905 .876 .797 r
.51641 .74591 m .51336 .75026 L .51983 .743 L F
.908 .945 .816 r
.51336 .75026 m .53031 .73618 L p .51997 .74396 L F P
0 g
s
.851 .756 .758 r
.51207 .74887 m .51336 .75026 L .51464 .74585 L F
.819 .709 .744 r
.49282 .79819 m .48736 .79518 L p .51224 .74794 L F P
0 g
s
.819 .709 .744 r
.48736 .79518 m .51336 .75026 L p .51183 .7487 L F P
0 g
s
.851 .756 .758 r
.51253 .74819 m .51336 .75026 L .51137 .7499 L F
.51334 .747 m .51336 .75026 L .51253 .74819 L F
.51614 .74286 m .51336 .75026 L .51334 .747 L F
.881 .811 .776 r
.5123 .74903 m .51336 .75026 L .51668 .74472 L F
.905 .876 .797 r
.52987 .73173 m .51336 .75026 L p .51544 .74627 L F P
0 g
s
.908 .945 .816 r
.51672 .74641 m .51336 .75026 L .51997 .74396 L F
.881 .811 .776 r
.51535 .74538 m .51336 .75026 L .5123 .74903 L F
.905 .876 .797 r
.51253 .7492 m .51336 .75026 L .51446 .74756 L F
.51446 .74756 m .51336 .75026 L .51641 .74591 L F
.51544 .74627 m .51336 .75026 L .51253 .7492 L F
.908 .945 .816 r
.51278 .74938 m .51336 .75026 L .51672 .74641 L F
.53031 .73618 m .53049 .73395 L p .51735 .74539 L F P
0 g
s
.908 .945 .816 r
.51735 .74539 m .51278 .74938 L .51619 .74681 L F
.51735 .74539 m .51619 .74681 L .53031 .73618 L F
.905 .876 .797 r
.53049 .73395 m .52987 .73173 L p .51603 .74568 L F P
0 g
s
.905 .876 .797 r
.51603 .74568 m .51253 .7492 L .51539 .74677 L F
.51603 .74568 m .51539 .74677 L .53049 .73395 L F
.881 .811 .776 r
.52987 .73173 m .52847 .72965 L p .51607 .74451 L F P
0 g
s
.881 .811 .776 r
.51607 .74451 m .5123 .74903 L .51536 .74601 L F
.51607 .74451 m .51536 .74601 L .52987 .73173 L F
.851 .756 .758 r
.51614 .74286 m .51207 .74887 L .51532 .74506 L F
.51614 .74286 m .51532 .74506 L .52847 .72965 L F
.819 .709 .744 r
.52636 .7278 m .52365 .72627 L p .51506 .74257 L F P
0 g
s
.819 .709 .744 r
.51506 .74257 m .51183 .7487 L .51458 .74475 L F
.51506 .74257 m .51458 .74475 L .52636 .7278 L F
.851 .756 .758 r
.48736 .79518 m .48309 .79155 L p .51137 .7499 L F P
0 g
s
.851 .756 .758 r
.51336 .75026 m .48736 .79518 L p .51137 .7499 L F P
0 g
s
.851 .756 .758 r
.48309 .79155 m .51336 .75026 L p .51207 .74887 L F P
0 g
s
.881 .811 .776 r
.48309 .79155 m .48023 .78745 L p .5123 .74903 L F P
0 g
s
.881 .811 .776 r
.51336 .75026 m .48309 .79155 L p .5123 .74903 L F P
0 g
s
.881 .811 .776 r
.48023 .78745 m .51336 .75026 L p .5123 .74903 L F P
0 g
s
.905 .876 .797 r
.48023 .78745 m .47892 .78307 L p .51253 .7492 L F P
0 g
s
.905 .876 .797 r
.51336 .75026 m .48023 .78745 L p .51253 .7492 L F P
0 g
s
.905 .876 .797 r
.47892 .78307 m .51336 .75026 L p .51253 .7492 L F P
0 g
s
.908 .945 .816 r
.47921 .77863 m .51336 .75026 L p .51278 .74938 L F P
0 g
s
.908 .945 .816 r
.47892 .78307 m .47921 .77863 L p .51278 .74938 L F P
0 g
s
.908 .945 .816 r
.51336 .75026 m .47892 .78307 L p .51278 .74938 L F P
0 g
s
.86 .995 .813 r
.47921 .77863 m .4811 .77432 L p .51192 .75043 L F P
0 g
s
.86 .995 .813 r
.51336 .75026 m .47921 .77863 L p .51192 .75043 L F P
0 g
s
.86 .995 .813 r
.4811 .77432 m .51336 .75026 L p .51305 .74956 L F P
0 g
s
.706 .972 .749 r
.51336 .75026 m .4811 .77432 L p .51121 .75139 L F P
0 g
s
.86 .995 .813 r
.51334 .74934 m .51336 .75026 L .51192 .75043 L F
.908 .945 .816 r
.53049 .73395 m .51336 .75026 L p .51278 .74938 L F P
0 g
s
.706 .972 .749 r
.4811 .77432 m .48451 .77035 L p .51334 .74977 L F P
0 g
s
.706 .972 .749 r
.48451 .77035 m .51336 .75026 L p .51334 .74977 L F P
0 g
s
.43 .822 .597 r
.51336 .75026 m .48451 .77035 L p .51198 .75118 L F P
0 g
s
.43 .822 .597 r
.51336 .75026 m .51198 .75118 L .51367 .75001 L F
.706 .972 .749 r
.51336 .75026 m .51121 .75139 L .51179 .75095 L F
.51336 .75026 m .51179 .75095 L .51334 .74977 L F
.491 0 0 r
.51907 .7551 m .51336 .75026 L .52415 .76212 L F
.509 .479 .759 r
.54393 .79124 m .53978 .79492 L p .51604 .75479 L F P
0 g
s
.491 0 0 r
.51336 .75026 m .5168 .76119 L .52415 .76212 L p F P
0 g
s
.412 0 0 r
.5159 .75094 m .51622 .75454 L .51432 .75052 L F
.565 .503 .745 r
.50714 .74222 m .50925 .74562 L .50826 .74451 L F
.787 .669 .734 r
.52365 .72627 m .52044 .72512 L p .51192 .74767 L F P
0 g
s
.412 0 0 r
.5149 .75174 m .51336 .75026 L .51432 .75052 L F
.51596 .75164 m .51336 .75026 L .51622 .75454 L F
.51336 .75026 m .50929 .76123 L p .51622 .75454 L F P
0 g
s
.412 0 0 r
.51436 .75175 m .51336 .75026 L .51442 .75128 L F
.51436 .75175 m .51442 .75128 L .5149 .75174 L F
.51622 .75454 m .51436 .75175 L .5149 .75174 L F
.5168 .76119 m .51336 .75026 L p .51622 .75454 L F P
0 g
s
.294 0 0 r
.51527 .75082 m .51423 .75263 L .51452 .7506 L F
.86 .995 .813 r
.51388 .74892 m .51336 .75026 L .51334 .74934 L F
.565 .503 .745 r
.50283 .72638 m .50016 .72794 L p .50714 .74222 L F P
0 g
s
.755 .635 .728 r
.52044 .72512 m .51691 .72442 L p .51171 .74677 L F P
0 g
s
.652 .551 .728 r
.50951 .72446 m .50599 .7252 L p .50818 .7363 L F P
0 g
s
.652 .551 .728 r
.50818 .7363 m .50907 .74083 L .50912 .73884 L F
.50818 .7363 m .50912 .73884 L .50951 .72446 L F
.50907 .74083 m .51042 .7477 L .51025 .74343 L F
.50907 .74083 m .51025 .74343 L .50951 .72446 L F
.722 .604 .725 r
.51691 .72442 m .5132 .7242 L p .51124 .74629 L F P
0 g
s
.688 .577 .725 r
.5132 .7242 m .50951 .72446 L p .51065 .74571 L F P
0 g
s
.86 .995 .813 r
.53031 .73618 m .51336 .75026 L p .51388 .74892 L F P
0 g
s
.86 .995 .813 r
.52934 .73835 m .53031 .73618 L p .51305 .74956 L F P
0 g
s
.121 0 0 r
.52232 .74341 m .51336 .75026 L p .51453 .75062 L F P
0 g
s
.294 0 0 r
.51527 .75082 m .51336 .75026 L .51513 .75105 L F
.51537 .75064 m .51336 .75026 L .51527 .75082 L F
.121 0 0 r
.51941 .7461 m .51425 .75088 L .51336 .75026 L F
0 0 0 r
.51398 .75028 m .51336 .75026 L .51724 .7476 L F
.51336 .75026 m .52232 .74341 L p .51724 .7476 L F P
0 g
s
0 0 0 r
.52232 .74341 m .52525 .74204 L p .51919 .7465 L F P
0 g
s
0 0 0 r
.51919 .7465 m .51373 .75052 L .51644 .74827 L F
.121 0 0 r
.52232 .74341 m .51941 .7461 L .51931 .74571 L F
0 0 0 r
.51919 .7465 m .51644 .74827 L .52232 .74341 L F
.51373 .75052 m .51371 .7505 L .52232 .74341 L F
.86 .995 .813 r
.51336 .75026 m .52934 .73835 L p .51305 .74956 L F P
0 g
s
.294 0 0 r
.51513 .75105 m .51336 .75026 L .51468 .75183 L F
.706 .972 .749 r
.52934 .73835 m .51336 .75026 L p .51334 .74977 L F P
0 g
s
.706 .972 .749 r
.52763 .74033 m .52934 .73835 L p .51334 .74977 L F P
0 g
s
.706 .972 .749 r
.51336 .75026 m .52763 .74033 L p .51334 .74977 L F P
0 g
s
.294 0 0 r
.51439 .75149 m .51336 .75026 L .5145 .75077 L F
.121 0 0 r
.51453 .75062 m .51336 .75026 L .51387 .75123 L F
.43 .822 .597 r
.48451 .77035 m .48928 .76691 L p .5124 .75088 L F P
0 g
s
.43 .822 .597 r
.51367 .75001 m .51251 .75081 L .5124 .75088 L F
.51251 .75081 m .48451 .77035 L .5124 .75088 L F
.412 0 0 r
.50929 .76123 m .5168 .76119 L p .51622 .75454 L F P
0 g
s
.439 .453 .778 r
.49811 .72981 m .49677 .73191 L p .50637 .74397 L F P
0 g
s
.439 .453 .778 r
.50637 .74397 m .5079 .74591 L .50716 .74469 L F
.50637 .74397 m .50716 .74469 L .49811 .72981 L F
.294 0 0 r
.51336 .75026 m .50197 .76223 L p .51468 .75183 L F P
0 g
s
.294 0 0 r
.51423 .75263 m .51336 .75026 L .51439 .75149 L F
.50929 .76123 m .51336 .75026 L p .51423 .75263 L F P
0 g
s
.121 0 0 r
.49519 .76416 m .50197 .76223 L p .51387 .75123 L F P
0 g
s
.121 0 0 r
.51336 .75026 m .49519 .76416 L p .51387 .75123 L F P
0 g
s
.294 0 0 r
.50197 .76223 m .50929 .76123 L p .51468 .75183 L F P
0 g
s
.345 .423 .799 r
.49677 .73191 m .49622 .73412 L p .50646 .74488 L F P
0 g
s
.214 .384 .817 r
.49622 .73412 m .49646 .73636 L p .50386 .74304 L F P
0 g
s
.43 .822 .597 r
.52763 .74033 m .51336 .75026 L p .51367 .75001 L F P
0 g
s
.121 0 0 r
.51425 .75088 m .51387 .75123 L .51336 .75026 L F
0 0 0 r
.51405 .75028 m .51336 .75026 L .51332 .75082 L F
.52525 .74204 m .51336 .75026 L p .51405 .75028 L F P
0 g
s
.43 .822 .597 r
.5124 .75088 m .51297 .75051 L .51335 .75025 L F
.51335 .75025 m .51335 .75025 L .51348 .75017 L F
.5124 .75088 m .51335 .75025 L .51335 .75025 L F
.51362 .75004 m .51348 .75017 L .52525 .74204 L F
.5124 .75088 m .51348 .75017 L .51362 .75004 L F
0 0 0 r
.51332 .75082 m .51336 .75026 L .51398 .75028 L F
.53 0 0 r
.52415 .76212 m .53099 .76397 L p .5193 .75401 L F P
0 g
s
.43 .822 .597 r
.51292 .75052 m .51295 .7505 L .51334 .75024 L F
.51333 .75024 m .51334 .75024 L .52525 .74204 L F
.51292 .75052 m .51334 .75024 L .51333 .75024 L F
.51782 .74713 m .51333 .75024 L .52525 .74204 L F
.51333 .75024 m .51292 .75052 L .51333 .75024 L F
.51333 .75024 m .51333 .75024 L .52525 .74204 L F
0 0 0 r
.51373 .75052 m .51332 .75082 L .51371 .7505 L F
.121 0 0 r
.5133 .75175 m .51234 .75264 L .51336 .75026 L F
.50197 .76223 m .51336 .75026 L p .51234 .75264 L F P
0 g
s
0 0 0 r
.49519 .76416 m .51336 .75026 L p .51332 .75082 L F P
0 g
s
.121 0 0 r
.51387 .75123 m .5133 .75175 L .51336 .75026 L F
.43 .822 .597 r
.51336 .75026 m .52525 .74204 L p .51335 .75025 L F P
0 g
s
.43 .822 .597 r
.51319 .75036 m .51336 .75026 L .51335 .75025 L F
.51297 .75051 m .51336 .75026 L .51319 .75036 L F
.50488 .7561 m .51336 .75026 L .51297 .75051 L F
0 0 0 r
.51332 .75082 m .51336 .75026 L .51276 .75123 L F
.43 .822 .597 r
.51292 .75052 m .5124 .75088 L .51295 .7505 L F
.5124 .75088 m .50488 .7561 L .51297 .75051 L F
0 0 0 r
.51276 .75123 m .51336 .75026 L .51193 .75185 L F
.51193 .75185 m .51336 .75026 L .49519 .76416 L F
.51336 .75026 m .48928 .76691 L .49519 .76416 L p F P
0 g
s
.43 .822 .597 r
.48928 .76691 m .51336 .75026 L p .50488 .7561 L F P
0 g
s
.43 .822 .597 r
.52525 .74204 m .52763 .74033 L p .51782 .74713 L F P
0 g
s
.463 .851 .642 r
.55993 .72004 m .56932 .71327 L p .536 .73503 L F P
0 g
s
.463 .851 .642 r
.52525 .74204 m .55993 .72004 L p .536 .73503 L F P
0 g
s
0 0 0 r
.59252 .70017 m .55993 .72004 L p .58239 .70597 L F P
0 g
s
.477 .863 .662 r
.55993 .72004 m .59252 .70017 L .60862 .68859 L p F P
0 g
s
.157 0 .381 r
.27388 .30517 m .27584 .28494 L .24151 .32264 L p F P
0 g
s
.157 0 .381 r
.24151 .32264 m .23929 .34297 L .27388 .30517 L p F P
0 g
s
.367 .366 .727 r
.2759 .43309 m .25668 .39826 L .23693 .43654 L p F P
0 g
s
.367 .366 .727 r
.23693 .43654 m .25743 .4682 L .2759 .43309 L p F P
0 g
s
.593 .871 .994 r
.45565 .19963 m .46312 .20928 L .41757 .22032 L p F P
0 g
s
.593 .871 .994 r
.41757 .22032 m .40338 .21234 L .45565 .19963 L p F P
0 g
s
.435 .714 .983 r
.60541 .2192 m .61906 .21104 L .66616 .23062 L p F P
0 g
s
.449 .755 .994 r
.61906 .21104 m .60541 .2192 L .55955 .2087 L p F P
0 g
s
.465 .859 .666 r
.32912 .23963 m .34074 .23291 L .29849 .262 L p F P
0 g
s
.465 .859 .666 r
.29849 .262 m .28414 .27061 L .32912 .23963 L p F P
0 g
s
.952 .633 .388 r
.78498 .3398 m .78278 .31947 L .74735 .28216 L p F P
0 g
s
.782 .309 0 r
.73916 .26791 m .74735 .28216 L .78278 .31947 L p F P
0 g
s
.92 .814 .725 r
.76817 .46533 m .7886 .43342 L .76774 .39533 L p F P
0 g
s
.949 .811 .672 r
.77994 .3651 m .76774 .39533 L .7886 .43342 L p F P
0 g
s
0 .222 .653 r
.73916 .26791 m .72501 .25947 L .68192 .23087 L p F P
0 g
s
.219 .583 .944 r
.66616 .23062 m .68192 .23087 L .72501 .25947 L p F P
0 g
s
.564 .926 .941 r
.39198 .2107 m .40338 .21234 L .35687 .23247 L p F P
0 g
s
.564 .926 .941 r
.35687 .23247 m .34074 .23291 L .39198 .2107 L p F P
0 g
s
.174 .613 .94 r
.68192 .23087 m .66616 .23062 L .61906 .21104 L p F P
0 g
s
.532 .838 .999 r
.51098 .19508 m .51128 .20533 L .46312 .20928 L p F P
0 g
s
.532 .838 .999 r
.46312 .20928 m .45565 .19963 L .51098 .19508 L p F P
0 g
s
0 .294 .779 r
.45104 .70607 m .40711 .67622 L .41931 .68958 L p F P
0 g
s
0 .294 .779 r
.41931 .68958 m .4581 .71385 L .45104 .70607 L p F P
0 g
s
.449 .755 .994 r
.55955 .2087 m .56642 .19896 L .61906 .21104 L p F P
0 g
s
.482 .797 .999 r
.56642 .19896 m .55955 .2087 L .51128 .20533 L p F P
0 g
s
.477 .863 .662 r
.60862 .68859 m .56932 .71327 L .55993 .72004 L p F P
0 g
s
.725 .984 .787 r
.56932 .71327 m .60862 .68859 L .62042 .67509 L p F P
0 g
s
.239 .406 .828 r
.39768 .64608 m .3532 .60649 L .35636 .62804 L p F P
0 g
s
.239 .406 .828 r
.35636 .62804 m .39977 .6615 L .39768 .64608 L p F P
0 g
s
.342 .235 .585 r
.27837 .33134 m .27388 .30517 L .23929 .34297 L p F P
0 g
s
.342 .235 .585 r
.23929 .34297 m .24437 .36819 L .27837 .33134 L p F P
0 g
s
.406 .414 .755 r
.30155 .47252 m .2759 .43309 L .25743 .4682 L p F P
0 g
s
.406 .414 .755 r
.25743 .4682 m .28485 .50354 L .30155 .47252 L p F P
0 g
s
.858 .993 .831 r
.67091 .62635 m .62733 .66029 L .62042 .67509 L p F P
0 g
s
.901 .94 .826 r
.62733 .66029 m .67091 .62635 L .67344 .60475 L p F P
0 g
s
.906 .943 .82 r
.71327 .56758 m .67344 .60475 L .67091 .62635 L p F P
0 g
s
.35 .429 .802 r
.35754 .58488 m .3185 .54246 L .31336 .56976 L p F P
0 g
s
.35 .429 .802 r
.31336 .56976 m .3532 .60649 L .35754 .58488 L p F P
0 g
s
.482 .797 .999 r
.51128 .20533 m .51098 .19508 L .56642 .19896 L p F P
0 g
s
.932 .715 .587 r
.77994 .3651 m .78498 .3398 L .74928 .30238 L p F P
0 g
s
.952 .633 .388 r
.74735 .28216 m .74928 .30238 L .78498 .3398 L p F P
0 g
s
.902 .875 .8 r
.67344 .60475 m .71327 .56758 L .70734 .54032 L p F P
0 g
s
.912 .879 .79 r
.74086 .501 m .70734 .54032 L .71327 .56758 L p F P
0 g
s
.9 .813 .754 r
.74086 .501 m .76817 .46533 L .74867 .43041 L p F P
0 g
s
.92 .814 .725 r
.76774 .39533 m .74867 .43041 L .76817 .46533 L p F P
0 g
s
.074 0 .055 r
.32239 .25295 m .32912 .23963 L .28414 .27061 L p F P
0 g
s
.074 0 .055 r
.28414 .27061 m .27584 .28494 L .32239 .25295 L p F P
0 g
s
0 .222 .653 r
.68192 .23087 m .69328 .23745 L .73916 .26791 L p F P
0 g
s
.825 .353 .069 r
.74735 .28216 m .73916 .26791 L .69328 .23745 L p F P
0 g
s
.077 .362 .831 r
.44685 .69752 m .39977 .6615 L .40711 .67622 L p F P
0 g
s
.077 .362 .831 r
.40711 .67622 m .45104 .70607 L .44685 .69752 L p F P
0 g
s
.423 .351 .671 r
.28922 .36339 m .27837 .33134 L .24437 .36819 L p F P
0 g
s
.423 .351 .671 r
.24437 .36819 m .25668 .39826 L .28922 .36339 L p F P
0 g
s
.725 .984 .787 r
.62042 .67509 m .57616 .70541 L .56932 .71327 L p F P
0 g
s
.858 .992 .832 r
.57616 .70541 m .62042 .67509 L .62733 .66029 L p F P
0 g
s
.425 .861 .925 r
.44965 .19667 m .45565 .19963 L .40338 .21234 L p F P
0 g
s
.425 .861 .925 r
.40338 .21234 m .39198 .2107 L .44965 .19667 L p F P
0 g
s
.174 .613 .94 r
.61906 .21104 m .63003 .20927 L .68192 .23087 L p F P
0 g
s
.167 .653 .923 r
.63003 .20927 m .61906 .21104 L .56642 .19896 L p F P
0 g
s
.429 .442 .771 r
.33297 .51633 m .30155 .47252 L .28485 .50354 L p F P
0 g
s
.429 .442 .771 r
.28485 .50354 m .3185 .54246 L .33297 .51633 L p F P
0 g
s
.902 .74 .671 r
.76774 .39533 m .77994 .3651 L .74486 .32862 L p F P
0 g
s
.932 .715 .587 r
.74928 .30238 m .74486 .32862 L .77994 .3651 L p F P
0 g
s
0 0 0 r
.38376 .21595 m .39198 .2107 L .34074 .23291 L p F P
0 g
s
0 0 0 r
.34074 .23291 m .32912 .23963 L .38376 .21595 L p F P
0 g
s
.887 .812 .77 r
.70734 .54032 m .74086 .501 L .72324 .47015 L p F P
0 g
s
.9 .813 .754 r
.74867 .43041 m .72324 .47015 L .74086 .501 L p F P
0 g
s
.419 0 0 r
.69328 .23745 m .68192 .23087 L .63003 .20927 L p F P
0 g
s
.36 .439 .807 r
.40101 .63068 m .35754 .58488 L .3532 .60649 L p F P
0 g
s
.36 .439 .807 r
.3532 .60649 m .39768 .64608 L .40101 .63068 L p F P
0 g
s
.358 .144 .447 r
.3208 .27308 m .32239 .25295 L .27584 .28494 L p F P
0 g
s
.358 .144 .447 r
.27584 .28494 m .27388 .30517 L .3208 .27308 L p F P
0 g
s
.901 .94 .826 r
.67344 .60475 m .62896 .64484 L .62733 .66029 L p F P
0 g
s
.897 .873 .805 r
.62896 .64484 m .67344 .60475 L .66845 .58319 L p F P
0 g
s
.902 .875 .8 r
.70734 .54032 m .66845 .58319 L .67344 .60475 L p F P
0 g
s
.465 .413 .714 r
.30615 .40116 m .28922 .36339 L .25668 .39826 L p F P
0 g
s
.465 .413 .714 r
.25668 .39826 m .2759 .43309 L .30615 .40116 L p F P
0 g
s
.893 .581 .451 r
.74928 .30238 m .74735 .28216 L .69985 .2507 L p F P
0 g
s
.825 .353 .069 r
.69328 .23745 m .69985 .2507 L .74735 .28216 L p F P
0 g
s
.298 .782 .91 r
.51073 .19164 m .51098 .19508 L .45565 .19963 L p F P
0 g
s
.298 .782 .91 r
.45565 .19963 m .44965 .19667 L .51073 .19164 L p F P
0 g
s
.167 .653 .923 r
.56642 .19896 m .57195 .19593 L .63003 .20927 L p F P
0 g
s
.208 .71 .909 r
.57195 .19593 m .56642 .19896 L .51098 .19508 L p F P
0 g
s
.242 .409 .829 r
.44575 .6886 m .39768 .64608 L .39977 .6615 L p F P
0 g
s
.242 .409 .829 r
.39977 .6615 m .44685 .69752 L .44575 .6886 L p F P
0 g
s
.88 .749 .713 r
.74867 .43041 m .76774 .39533 L .73416 .36082 L p F P
0 g
s
.902 .74 .671 r
.74486 .32862 m .73416 .36082 L .76774 .39533 L p F P
0 g
s
.858 .992 .832 r
.62733 .66029 m .58009 .69682 L .57616 .70541 L p F P
0 g
s
.9 .94 .827 r
.58009 .69682 m .62733 .66029 L .62896 .64484 L p F P
0 g
s
.442 .458 .78 r
.36933 .56426 m .33297 .51633 L .3185 .54246 L p F P
0 g
s
.442 .458 .78 r
.3185 .54246 m .35754 .58488 L .36933 .56426 L p F P
0 g
s
.208 .71 .909 r
.51098 .19508 m .51073 .19164 L .57195 .19593 L p F P
0 g
s
.879 .811 .779 r
.66845 .58319 m .70734 .54032 L .69209 .51434 L p F P
0 g
s
.887 .812 .77 r
.72324 .47015 m .69209 .51434 L .70734 .54032 L p F P
0 g
s
.489 .449 .739 r
.3287 .44436 m .30615 .40116 L .2759 .43309 L p F P
0 g
s
.489 .449 .739 r
.2759 .43309 m .30155 .47252 L .3287 .44436 L p F P
0 g
s
.309 0 .178 r
.379 .22849 m .38376 .21595 L .32912 .23963 L p F P
0 g
s
.309 0 .178 r
.32912 .23963 m .32239 .25295 L .379 .22849 L p F P
0 g
s
.464 .318 .597 r
.32444 .30007 m .3208 .27308 L .27388 .30517 L p F P
0 g
s
.464 .318 .597 r
.27388 .30517 m .27837 .33134 L .32444 .30007 L p F P
0 g
s
.078 0 0 r
.44532 .20098 m .44965 .19667 L .39198 .2107 L p F P
0 g
s
.078 0 0 r
.39198 .2107 m .38376 .21595 L .44532 .20098 L p F P
0 g
s
.787 .34 .185 r
.69985 .2507 m .69328 .23745 L .63793 .21443 L p F P
0 g
s
.419 0 0 r
.63003 .20927 m .63793 .21443 L .69328 .23745 L p F P
0 g
s
.865 .753 .738 r
.72324 .47015 m .74867 .43041 L .71748 .3988 L p F P
0 g
s
.88 .749 .713 r
.73416 .36082 m .71748 .3988 L .74867 .43041 L p F P
0 g
s
.427 0 0 r
.63793 .21443 m .63003 .20927 L .57195 .19593 L p F P
0 g
s
.875 .653 .598 r
.74486 .32862 m .74928 .30238 L .70141 .27083 L p F P
0 g
s
.893 .581 .451 r
.69985 .2507 m .70141 .27083 L .74928 .30238 L p F P
0 g
s
0 .278 .767 r
.4975 .73851 m .45104 .70607 L .4581 .71385 L p F P
0 g
s
0 .278 .767 r
.4581 .71385 m .49927 .74048 L .4975 .73851 L p F P
0 g
s
.463 .851 .642 r
.56932 .71327 m .52763 .74033 L .52525 .74204 L p F P
0 g
s
.719 .981 .776 r
.52763 .74033 m .56932 .71327 L .57616 .70541 L p F P
0 g
s
.362 .441 .808 r
.44781 .67972 m .40101 .63068 L .39768 .64608 L p F P
0 g
s
.362 .441 .808 r
.39768 .64608 m .44575 .6886 L .44781 .67972 L p F P
0 g
s
.448 .466 .785 r
.40968 .61602 m .36933 .56426 L .35754 .58488 L p F P
0 g
s
.448 .466 .785 r
.35754 .58488 m .40101 .63068 L .40968 .61602 L p F P
0 g
s
.9 .94 .827 r
.62896 .64484 m .58092 .68789 L .58009 .69682 L p F P
0 g
s
.896 .873 .806 r
.58092 .68789 m .62896 .64484 L .62517 .62947 L p F P
0 g
s
.897 .873 .805 r
.66845 .58319 m .62517 .62947 L .62896 .64484 L p F P
0 g
s
.875 .811 .783 r
.62517 .62947 m .66845 .58319 L .65605 .56269 L p F P
0 g
s
.879 .811 .779 r
.69209 .51434 m .65605 .56269 L .66845 .58319 L p F P
0 g
s
.503 .47 .753 r
.35627 .49266 m .3287 .44436 L .30155 .47252 L p F P
0 g
s
.503 .47 .753 r
.30155 .47252 m .33297 .51633 L .35627 .49266 L p F P
0 g
s
.855 .755 .752 r
.69209 .51434 m .72324 .47015 L .69524 .44229 L p F P
0 g
s
.865 .753 .738 r
.71748 .3988 m .69524 .44229 L .72324 .47015 L p F P
0 g
s
.062 .352 .825 r
.49646 .73636 m .44685 .69752 L .45104 .70607 L p F P
0 g
s
.062 .352 .825 r
.45104 .70607 m .4975 .73851 L .49646 .73636 L p F P
0 g
s
.512 .403 .666 r
.33323 .33383 m .32444 .30007 L .27837 .33134 L p F P
0 g
s
.512 .403 .666 r
.27837 .33134 m .28922 .36339 L .33323 .33383 L p F P
0 g
s
.719 .981 .776 r
.57616 .70541 m .52934 .73835 L .52763 .74033 L p F P
0 g
s
.859 .993 .827 r
.52934 .73835 m .57616 .70541 L .58009 .69682 L p F P
0 g
s
.253 0 0 r
.51055 .19562 m .51073 .19164 L .44965 .19667 L p F P
0 g
s
.253 0 0 r
.44965 .19667 m .44532 .20098 L .51055 .19562 L p F P
0 g
s
.427 0 0 r
.57195 .19593 m .57593 .20019 L .63793 .21443 L p F P
0 g
s
.367 0 0 r
.57593 .20019 m .57195 .19593 L .51073 .19164 L p F P
0 g
s
.855 .681 .666 r
.73416 .36082 m .74486 .32862 L .69785 .29788 L p F P
0 g
s
.875 .653 .598 r
.70141 .27083 m .69785 .29788 L .74486 .32862 L p F P
0 g
s
.486 .248 .479 r
.37787 .24854 m .379 .22849 L .32239 .25295 L p F P
0 g
s
.486 .248 .479 r
.32239 .25295 m .3208 .27308 L .37787 .24854 L p F P
0 g
s
.367 0 0 r
.51073 .19164 m .51055 .19562 L .57593 .20019 L p F P
0 g
s
.831 .53 .481 r
.70141 .27083 m .69985 .2507 L .64252 .22691 L p F P
0 g
s
.787 .34 .185 r
.63793 .21443 m .64252 .22691 L .69985 .2507 L p F P
0 g
s
.511 .483 .762 r
.3881 .54564 m .35627 .49266 L .33297 .51633 L p F P
0 g
s
.511 .483 .762 r
.33297 .51633 m .36933 .56426 L .3881 .54564 L p F P
0 g
s
.233 .401 .825 r
.49622 .73412 m .44575 .6886 L .44685 .69752 L p F P
0 g
s
.233 .401 .825 r
.44685 .69752 m .49646 .73636 L .49622 .73412 L p F P
0 g
s
.849 .757 .76 r
.65605 .56269 m .69209 .51434 L .66808 .49092 L p F P
0 g
s
.855 .755 .752 r
.69524 .44229 m .66808 .49092 L .69209 .51434 L p F P
0 g
s
.461 .086 .24 r
.44281 .21301 m .44532 .20098 L .38376 .21595 L p F P
0 g
s
.461 .086 .24 r
.38376 .21595 m .379 .22849 L .44281 .21301 L p F P
0 g
s
.859 .993 .827 r
.58009 .69682 m .53031 .73618 L .52934 .73835 L p F P
0 g
s
.903 .941 .824 r
.53031 .73618 m .58009 .69682 L .58092 .68789 L p F P
0 g
s
.538 .45 .704 r
.34693 .37412 m .33323 .33383 L .28922 .36339 L p F P
0 g
s
.538 .45 .704 r
.28922 .36339 m .30615 .40116 L .34693 .37412 L p F P
0 g
s
.726 .303 .244 r
.64252 .22691 m .63793 .21443 L .57593 .20019 L p F P
0 g
s
.449 .467 .785 r
.45297 .67131 m .40968 .61602 L .40101 .63068 L p F P
0 g
s
.449 .467 .785 r
.40101 .63068 m .44781 .67972 L .45297 .67131 L p F P
0 g
s
.896 .873 .806 r
.62517 .62947 m .57859 .67903 L .58092 .68789 L p F P
0 g
s
.874 .811 .784 r
.57859 .67903 m .62517 .62947 L .61607 .61491 L p F P
0 g
s
.875 .811 .783 r
.65605 .56269 m .61607 .61491 L .62517 .62947 L p F P
0 g
s
.84 .695 .703 r
.71748 .3988 m .73416 .36082 L .68927 .33176 L p F P
0 g
s
.855 .681 .666 r
.69785 .29788 m .68927 .33176 L .73416 .36082 L p F P
0 g
s
.515 .489 .766 r
.42332 .60283 m .3881 .54564 L .36933 .56426 L p F P
0 g
s
.515 .489 .766 r
.36933 .56426 m .40968 .61602 L .42332 .60283 L p F P
0 g
s
.846 .757 .764 r
.61607 .61491 m .65605 .56269 L .63672 .54427 L p F P
0 g
s
.849 .757 .76 r
.66808 .49092 m .63672 .54427 L .65605 .56269 L p F P
0 g
s
.553 .479 .726 r
.36517 .42056 m .34693 .37412 L .30615 .40116 L p F P
0 g
s
.553 .479 .726 r
.30615 .40116 m .3287 .44436 L .36517 .42056 L p F P
0 g
s
.356 .436 .805 r
.49677 .73191 m .44781 .67972 L .44575 .6886 L p F P
0 g
s
.356 .436 .805 r
.44575 .6886 m .49622 .73412 L .49677 .73191 L p F P
0 g
s
.55 .378 .602 r
.38045 .27617 m .37787 .24854 L .3208 .27308 L p F P
0 g
s
.55 .378 .602 r
.3208 .27308 m .32444 .30007 L .38045 .27617 L p F P
0 g
s
.903 .941 .824 r
.58092 .68789 m .53049 .73395 L .53031 .73618 L p F P
0 g
s
.899 .874 .803 r
.53049 .73395 m .58092 .68789 L .57859 .67903 L p F P
0 g
s
.822 .6 .602 r
.69785 .29788 m .70141 .27083 L .6436 .24696 L p F P
0 g
s
.831 .53 .481 r
.64252 .22691 m .6436 .24696 L .70141 .27083 L p F P
0 g
s
.829 .703 .725 r
.69524 .44229 m .71748 .3988 L .67588 .37222 L p F P
0 g
s
.84 .695 .703 r
.68927 .33176 m .67588 .37222 L .71748 .3988 L p F P
0 g
s
.569 .181 .267 r
.51045 .20747 m .51055 .19562 L .44532 .20098 L p F P
0 g
s
.569 .181 .267 r
.44532 .20098 m .44281 .21301 L .51045 .20747 L p F P
0 g
s
.726 .303 .244 r
.57593 .20019 m .57824 .2122 L .64252 .22691 L p F P
0 g
s
.654 .251 .268 r
.57824 .2122 m .57593 .20019 L .51055 .19562 L p F P
0 g
s
.561 .496 .739 r
.38741 .4727 m .36517 .42056 L .3287 .44436 L p F P
0 g
s
.561 .496 .739 r
.3287 .44436 m .35627 .49266 L .38741 .4727 L p F P
0 g
s
.516 .49 .766 r
.461 .66376 m .42332 .60283 L .40968 .61602 L p F P
0 g
s
.516 .49 .766 r
.40968 .61602 m .45297 .67131 L .461 .66376 L p F P
0 g
s
.577 .323 .495 r
.44222 .23302 m .44281 .21301 L .379 .22849 L p F P
0 g
s
.577 .323 .495 r
.379 .22849 m .37787 .24854 L .44222 .23302 L p F P
0 g
s
.822 .708 .738 r
.66808 .49092 m .69524 .44229 L .65806 .4189 L p F P
0 g
s
.829 .703 .725 r
.67588 .37222 m .65806 .4189 L .69524 .44229 L p F P
0 g
s
.874 .811 .784 r
.61607 .61491 m .57317 .67067 L .57859 .67903 L p F P
0 g
s
.846 .757 .765 r
.57317 .67067 m .61607 .61491 L .60203 .60186 L p F P
0 g
s
.846 .757 .764 r
.63672 .54427 m .60203 .60186 L .61607 .61491 L p F P
0 g
s
.446 .463 .783 r
.49811 .72981 m .45297 .67131 L .44781 .67972 L p F P
0 g
s
.446 .463 .783 r
.44781 .67972 m .49677 .73191 L .49811 .72981 L p F P
0 g
s
.654 .251 .268 r
.51055 .19562 m .51045 .20747 L .57824 .2122 L p F P
0 g
s
.899 .874 .803 r
.57859 .67903 m .52987 .73173 L .53049 .73395 L p F P
0 g
s
.876 .811 .781 r
.52987 .73173 m .57859 .67903 L .57317 .67067 L p F P
0 g
s
.771 .481 .496 r
.6436 .24696 m .64252 .22691 L .57824 .2122 L p F P
0 g
s
.579 .445 .662 r
.38667 .31125 m .38045 .27617 L .32444 .30007 L p F P
0 g
s
.579 .445 .662 r
.32444 .30007 m .33323 .33383 L .38667 .31125 L p F P
0 g
s
.566 .506 .747 r
.41304 .52997 m .38741 .4727 L .35627 .49266 L p F P
0 g
s
.566 .506 .747 r
.35627 .49266 m .3881 .54564 L .41304 .52997 L p F P
0 g
s
.81 .633 .662 r
.68927 .33176 m .69785 .29788 L .64112 .27463 L p F P
0 g
s
.822 .6 .602 r
.6436 .24696 m .64112 .27463 L .69785 .29788 L p F P
0 g
s
.818 .71 .746 r
.63672 .54427 m .66808 .49092 L .63633 .4713 L p F P
0 g
s
.822 .708 .738 r
.65806 .4189 m .63633 .4713 L .66808 .49092 L p F P
0 g
s
.569 .511 .751 r
.44134 .59176 m .41304 .52997 L .3881 .54564 L p F P
0 g
s
.569 .511 .751 r
.3881 .54564 m .42332 .60283 L .44134 .59176 L p F P
0 g
s
.514 .487 .764 r
.50016 .72794 m .461 .66376 L .45297 .67131 L p F P
0 g
s
.514 .487 .764 r
.45297 .67131 m .49811 .72981 L .50016 .72794 L p F P
0 g
s
.816 .712 .75 r
.60203 .60186 m .63672 .54427 L .61131 .52887 L p F P
0 g
s
.818 .71 .746 r
.63633 .4713 m .61131 .52887 L .63672 .54427 L p F P
0 g
s
.876 .811 .781 r
.57317 .67067 m .52847 .72965 L .52987 .73173 L p F P
0 g
s
.848 .757 .763 r
.52847 .72965 m .57317 .67067 L .56492 .66321 L p F P
0 g
s
.846 .757 .765 r
.60203 .60186 m .56492 .66321 L .57317 .67067 L p F P
0 g
s
.595 .483 .696 r
.39636 .35348 m .38667 .31125 L .33323 .33383 L p F P
0 g
s
.595 .483 .696 r
.33323 .33383 m .34693 .37412 L .39636 .35348 L p F P
0 g
s
.569 .512 .752 r
.47153 .65744 m .44134 .59176 L .42332 .60283 L p F P
0 g
s
.569 .512 .752 r
.42332 .60283 m .461 .66376 L .47153 .65744 L p F P
0 g
s
.801 .65 .695 r
.67588 .37222 m .68927 .33176 L .63514 .30979 L p F P
0 g
s
.81 .633 .662 r
.64112 .27463 m .63514 .30979 L .68927 .33176 L p F P
0 g
s
.816 .712 .75 r
.56492 .66321 m .60203 .60186 L .58367 .59098 L p F P
0 g
s
.816 .712 .75 r
.61131 .52887 m .58367 .59098 L .60203 .60186 L p F P
0 g
s
.617 .427 .603 r
.44357 .26105 m .44222 .23302 L .37787 .24854 L p F P
0 g
s
.617 .427 .603 r
.37787 .24854 m .38045 .27617 L .44357 .26105 L p F P
0 g
s
.649 .382 .502 r
.51042 .22746 m .51045 .20747 L .44281 .21301 L p F P
0 g
s
.649 .382 .502 r
.44281 .21301 m .44222 .23302 L .51042 .22746 L p F P
0 g
s
.771 .481 .496 r
.57824 .2122 m .57879 .2322 L .6436 .24696 L p F P
0 g
s
.712 .433 .502 r
.57879 .2322 m .57824 .2122 L .51045 .20747 L p F P
0 g
s
.772 .554 .603 r
.64112 .27463 m .6436 .24696 L .57879 .2322 L p F P
0 g
s
.724 .583 .697 r
.47666 1.04207 m .48593 .96117 L .51459 .96279 L p F P
0 g
s
.724 .583 .697 r
.51459 .96279 m .51501 1.04418 L .47666 1.04207 L p F P
0 g
s
.723 .592 .709 r
.51415 .88197 m .51459 .96279 L .48593 .96117 L p F P
0 g
s
.687 .552 .697 r
.51501 1.04418 m .51459 .96279 L .5432 .96089 L p F P
0 g
s
.687 .563 .709 r
.51459 .96279 m .51415 .88197 L .53237 .88073 L p F P
0 g
s
.687 .563 .709 r
.53237 .88073 m .5432 .96089 L .51459 .96279 L p F P
0 g
s
.568 .509 .749 r
.50283 .72638 m .47153 .65744 L .461 .66376 L p F P
0 g
s
.568 .509 .749 r
.461 .66376 m .50016 .72794 L .50283 .72638 L p F P
0 g
s
.604 .506 .717 r
.40924 .40242 m .39636 .35348 L .34693 .37412 L p F P
0 g
s
.604 .506 .717 r
.34693 .37412 m .36517 .42056 L .40924 .40242 L p F P
0 g
s
.723 .592 .709 r
.48593 .96117 m .49588 .88091 L .51415 .88197 L p F P
0 g
s
.723 .599 .718 r
.51368 .80223 m .51415 .88197 L .49588 .88091 L p F P
0 g
s
.688 .571 .718 r
.51415 .88197 m .51368 .80223 L .52105 .80172 L p F P
0 g
s
.688 .571 .718 r
.52105 .80172 m .53237 .88073 L .51415 .88197 L p F P
0 g
s
.848 .757 .763 r
.56492 .66321 m .52636 .7278 L .52847 .72965 L p F P
0 g
s
.817 .711 .748 r
.52636 .7278 m .56492 .66321 L .55419 .657 L p F P
0 g
s
.816 .712 .75 r
.58367 .59098 m .55419 .657 L .56492 .66321 L p F P
0 g
s
.758 .624 .711 r
.45846 .95611 m .4784 .87761 L .49588 .88091 L p F P
0 g
s
.758 .624 .711 r
.49588 .88091 m .48593 .96117 L .45846 .95611 L p F P
0 g
s
.756 .63 .721 r
.50629 .80179 m .49588 .88091 L .4784 .87761 L p F P
0 g
s
.723 .599 .718 r
.49588 .88091 m .50629 .80179 L .51368 .80223 L p F P
0 g
s
.76 .616 .699 r
.43987 1.03547 m .45846 .95611 L .48593 .96117 L p F P
0 g
s
.76 .616 .699 r
.48593 .96117 m .47666 1.04207 L .43987 1.03547 L p F P
0 g
s
.649 .535 .712 r
.5432 .96089 m .53237 .88073 L .54975 .87725 L p F P
0 g
s
.651 .544 .721 r
.53237 .88073 m .52105 .80172 L .52807 .80028 L p F P
0 g
s
.651 .544 .721 r
.52807 .80028 m .54975 .87725 L .53237 .88073 L p F P
0 g
s
.794 .661 .716 r
.65806 .4189 m .67588 .37222 L .62582 .35215 L p F P
0 g
s
.801 .65 .695 r
.63514 .30979 m .62582 .35215 L .67588 .37222 L p F P
0 g
s
.687 .552 .697 r
.5432 .96089 m .55329 1.04171 L .51501 1.04418 L p F P
0 g
s
.646 .523 .7 r
.55329 1.04171 m .5432 .96089 L .57051 .95556 L p F P
0 g
s
.649 .535 .712 r
.54975 .87725 m .57051 .95556 L .5432 .96089 L p F P
0 g
s
.712 .433 .502 r
.51045 .20747 m .51042 .22746 L .57879 .2322 L p F P
0 g
s
.724 .572 .682 r
.46829 1.12324 m .47666 1.04207 L .51501 1.04418 L p F P
0 g
s
.724 .572 .682 r
.51501 1.04418 m .51538 1.12576 L .46829 1.12324 L p F P
0 g
s
.685 .54 .682 r
.51538 1.12576 m .51501 1.04418 L .55329 1.04171 L p F P
0 g
s
.609 .521 .729 r
.42494 .45751 m .40924 .40242 L .36517 .42056 L p F P
0 g
s
.609 .521 .729 r
.36517 .42056 m .38741 .4727 L .42494 .45751 L p F P
0 g
s
.756 .63 .721 r
.4784 .87761 m .49923 .80042 L .50629 .80179 L p F P
0 g
s
.793 .66 .717 r
.4334 .9478 m .46249 .8722 L .4784 .87761 L p F P
0 g
s
.793 .66 .717 r
.4784 .87761 m .45846 .95611 L .4334 .9478 L p F P
0 g
s
.79 .666 .727 r
.49923 .80042 m .4784 .87761 L .46249 .8722 L p F P
0 g
s
.817 .711 .748 r
.55419 .657 m .52365 .72627 L .52636 .7278 L p F P
0 g
s
.762 .606 .684 r
.42306 1.11533 m .43987 1.03547 L .47666 1.04207 L p F P
0 g
s
.762 .606 .684 r
.47666 1.04207 m .46829 1.12324 L .42306 1.11533 L p F P
0 g
s
.789 .667 .729 r
.63633 .4713 m .65806 .4189 L .61344 .40126 L p F P
0 g
s
.794 .661 .716 r
.62582 .35215 m .61344 .40126 L .65806 .4189 L p F P
0 g
s
.605 .508 .718 r
.57051 .95556 m .54975 .87725 L .56549 .87168 L p F P
0 g
s
.609 .519 .727 r
.54975 .87725 m .52807 .80028 L .53441 .79798 L p F P
0 g
s
.609 .519 .727 r
.53441 .79798 m .56549 .87168 L .54975 .87725 L p F P
0 g
s
.79 .666 .727 r
.46249 .8722 m .49282 .79819 L .49923 .80042 L p F P
0 g
s
.685 .54 .682 r
.55329 1.04171 m .5624 1.1228 L .51538 1.12576 L p F P
0 g
s
.643 .509 .685 r
.5624 1.1228 m .55329 1.04171 L .58987 1.03475 L p F P
0 g
s
.646 .523 .7 r
.57051 .95556 m .58987 1.03475 L .55329 1.04171 L p F P
0 g
s
.612 .529 .737 r
.44299 .51807 m .42494 .45751 L .38741 .4727 L p F P
0 g
s
.612 .529 .737 r
.38741 .4727 m .41304 .52997 L .44299 .51807 L p F P
0 g
s
.613 .532 .739 r
.50599 .7252 m .48408 .65266 L .47153 .65744 L p F P
0 g
s
.613 .532 .739 r
.47153 .65744 m .50283 .72638 L .50599 .7252 L p F P
0 g
s
.614 .534 .741 r
.44134 .59176 m .47153 .65744 L .48408 .65266 L p F P
0 g
s
.614 .534 .741 r
.48408 .65266 m .46288 .58337 L .44134 .59176 L p F P
0 g
s
.614 .534 .741 r
.41304 .52997 m .44134 .59176 L .46288 .58337 L p F P
0 g
s
.614 .534 .741 r
.46288 .58337 m .44299 .51807 L .41304 .52997 L p F P
0 g
s
.786 .672 .738 r
.52365 .72627 m .55419 .657 L .54151 .65235 L p F P
0 g
s
.786 .672 .738 r
.54151 .65235 m .52044 .72512 L .52365 .72627 L p F P
0 g
s
.785 .673 .74 r
.55419 .657 m .58367 .59098 L .56187 .58283 L p F P
0 g
s
.785 .673 .74 r
.56187 .58283 m .54151 .65235 L .55419 .657 L p F P
0 g
s
.786 .671 .736 r
.61131 .52887 m .63633 .4713 L .59835 .45653 L p F P
0 g
s
.789 .667 .729 r
.61344 .40126 m .59835 .45653 L .63633 .4713 L p F P
0 g
s
.796 .653 .705 r
.40622 1.02462 m .4334 .9478 L .45846 .95611 L p F P
0 g
s
.796 .653 .705 r
.45846 .95611 m .43987 1.03547 L .40622 1.02462 L p F P
0 g
s
.785 .673 .74 r
.58367 .59098 m .61131 .52887 L .581 .5173 L p F P
0 g
s
.785 .673 .74 r
.581 .5173 m .56187 .58283 L .58367 .59098 L p F P
0 g
s
.634 .482 .659 r
.44685 .29697 m .44357 .26105 L .38045 .27617 L p F P
0 g
s
.634 .482 .659 r
.38045 .27617 m .38667 .31125 L .44685 .29697 L p F P
0 g
s
.786 .671 .736 r
.59835 .45653 m .581 .5173 L .61131 .52887 L p F P
0 g
s
.601 .495 .705 r
.58987 1.03475 m .57051 .95556 L .59532 .94701 L p F P
0 g
s
.605 .508 .718 r
.56549 .87168 m .59532 .94701 L .57051 .95556 L p F P
0 g
s
.653 .556 .732 r
.48408 .65266 m .50599 .7252 L .50951 .72446 L p F P
0 g
s
.823 .706 .736 r
.44887 .86491 m .48736 .79518 L .49282 .79819 L p F P
0 g
s
.823 .706 .736 r
.49282 .79819 m .46249 .8722 L .44887 .86491 L p F P
0 g
s
.754 .638 .732 r
.52044 .72512 m .54151 .65235 L .52746 .64951 L p F P
0 g
s
.754 .638 .732 r
.52746 .64951 m .51691 .72442 L .52044 .72512 L p F P
0 g
s
.561 .494 .737 r
.56549 .87168 m .53441 .79798 L .53978 .79492 L p F P
0 g
s
.689 .581 .729 r
.49803 .64966 m .50951 .72446 L .5132 .7242 L p F P
0 g
s
.653 .556 .732 r
.50951 .72446 m .49803 .64966 L .48408 .65266 L p F P
0 g
s
.722 .608 .729 r
.51691 .72442 m .52746 .64951 L .51273 .64859 L p F P
0 g
s
.722 .608 .729 r
.51273 .64859 m .5132 .7242 L .51691 .72442 L p F P
0 g
s
.689 .581 .729 r
.5132 .7242 m .51273 .64859 L .49803 .64966 L p F P
0 g
s
.768 .591 .659 r
.63514 .30979 m .64112 .27463 L .57754 .26025 L p F P
0 g
s
.772 .554 .603 r
.57879 .2322 m .57754 .26025 L .64112 .27463 L p F P
0 g
s
.725 .558 .665 r
.46099 1.20443 m .46829 1.12324 L .51538 1.12576 L p F P
0 g
s
.725 .558 .665 r
.51538 1.12576 m .51571 1.20727 L .46099 1.20443 L p F P
0 g
s
.683 .525 .665 r
.51571 1.20727 m .51538 1.12576 L .5624 1.1228 L p F P
0 g
s
.828 .702 .726 r
.41186 .9366 m .44887 .86491 L .46249 .8722 L p F P
0 g
s
.828 .702 .726 r
.46249 .8722 m .4334 .9478 L .41186 .9366 L p F P
0 g
s
.673 .471 .604 r
.51048 .25563 m .51042 .22746 L .44222 .23302 L p F P
0 g
s
.673 .471 .604 r
.44222 .23302 m .44357 .26105 L .51048 .25563 L p F P
0 g
s
.856 .754 .75 r
.43818 .85607 m .48309 .79155 L .48736 .79518 L p F P
0 g
s
.856 .754 .75 r
.48736 .79518 m .44887 .86491 L .43818 .85607 L p F P
0 g
s
.653 .558 .734 r
.46288 .58337 m .48408 .65266 L .49803 .64966 L p F P
0 g
s
.561 .494 .737 r
.53978 .79492 m .57889 .86426 L .56549 .87168 L p F P
0 g
s
.503 .468 .751 r
.57889 .86426 m .53978 .79492 L .54393 .79124 L p F P
0 g
s
.555 .481 .727 r
.59532 .94701 m .56549 .87168 L .57889 .86426 L p F P
0 g
s
.754 .639 .734 r
.54151 .65235 m .56187 .58283 L .53767 .57782 L p F P
0 g
s
.754 .639 .734 r
.53767 .57782 m .52746 .64951 L .54151 .65235 L p F P
0 g
s
.723 .512 .604 r
.57754 .26025 m .57879 .2322 L .51042 .22746 L p F P
0 g
s
.8 .645 .689 r
.38161 1.10234 m .40622 1.02462 L .43987 1.03547 L p F P
0 g
s
.8 .645 .689 r
.43987 1.03547 m .42306 1.11533 L .38161 1.10234 L p F P
0 g
s
.764 .594 .667 r
.4084 1.19549 m .42306 1.11533 L .46829 1.12324 L p F P
0 g
s
.764 .594 .667 r
.46829 1.12324 m .46099 1.20443 L .4084 1.19549 L p F P
0 g
s
.643 .509 .685 r
.58987 1.03475 m .60738 1.11448 L .5624 1.1228 L p F P
0 g
s
.595 .478 .69 r
.60738 1.11448 m .58987 1.03475 L .62318 1.02358 L p F P
0 g
s
.601 .495 .705 r
.59532 .94701 m .62318 1.02358 L .58987 1.03475 L p F P
0 g
s
.683 .525 .665 r
.5624 1.1228 m .57034 1.20393 L .51571 1.20727 L p F P
0 g
s
.639 .492 .667 r
.57034 1.20393 m .5624 1.1228 L .60738 1.11448 L p F P
0 g
s
.689 .582 .731 r
.48692 .57809 m .49803 .64966 L .51273 .64859 L p F P
0 g
s
.653 .558 .734 r
.49803 .64966 m .48692 .57809 L .46288 .58337 L p F P
0 g
s
.722 .609 .731 r
.52746 .64951 m .53767 .57782 L .51227 .57621 L p F P
0 g
s
.722 .609 .731 r
.51227 .57621 m .51273 .64859 L .52746 .64951 L p F P
0 g
s
.653 .557 .734 r
.44299 .51807 m .46288 .58337 L .48692 .57809 L p F P
0 g
s
.888 .811 .767 r
.43093 .84607 m .48023 .78745 L .48309 .79155 L p F P
0 g
s
.888 .811 .767 r
.48309 .79155 m .43818 .85607 L .43093 .84607 L p F P
0 g
s
.643 .514 .691 r
.45196 .34044 m .44685 .29697 L .38667 .31125 L p F P
0 g
s
.643 .514 .691 r
.38667 .31125 m .39636 .35348 L .45196 .34044 L p F P
0 g
s
.503 .468 .751 r
.54393 .79124 m .5893 .85531 L .57889 .86426 L p F P
0 g
s
.428 .439 .769 r
.5893 .85531 m .54393 .79124 L .54667 .78711 L p F P
0 g
s
.689 .582 .731 r
.51273 .64859 m .51227 .57621 L .48692 .57809 L p F P
0 g
s
.754 .639 .733 r
.56187 .58283 m .581 .5173 L .54728 .51018 L p F P
0 g
s
.754 .639 .733 r
.54728 .51018 m .53767 .57782 L .56187 .58283 L p F P
0 g
s
.723 .512 .604 r
.51042 .22746 m .51048 .25563 L .57754 .26025 L p F P
0 g
s
.763 .611 .691 r
.62582 .35215 m .63514 .30979 L .57453 .29622 L p F P
0 g
s
.768 .591 .659 r
.57754 .26025 m .57453 .29622 L .63514 .30979 L p F P
0 g
s
.833 .697 .713 r
.37721 1.00995 m .41186 .9366 L .4334 .9478 L p F P
0 g
s
.833 .697 .713 r
.4334 .9478 m .40622 1.02462 L .37721 1.00995 L p F P
0 g
s
.548 .465 .714 r
.62318 1.02358 m .59532 .94701 L .61651 .9356 L p F P
0 g
s
.555 .481 .727 r
.57889 .86426 m .61651 .9356 L .59532 .94701 L p F P
0 g
s
.653 .557 .734 r
.48692 .57809 m .47648 .51057 L .44299 .51807 L p F P
0 g
s
.652 .553 .73 r
.42494 .45751 m .44299 .51807 L .47648 .51057 L p F P
0 g
s
.863 .752 .739 r
.39485 .92297 m .43818 .85607 L .44887 .86491 L p F P
0 g
s
.863 .752 .739 r
.44887 .86491 m .41186 .9366 L .39485 .92297 L p F P
0 g
s
.755 .636 .73 r
.581 .5173 m .59835 .45653 L .556 .44743 L p F P
0 g
s
.755 .636 .73 r
.556 .44743 m .54728 .51018 L .581 .5173 L p F P
0 g
s
.913 .878 .787 r
.42748 .83535 m .47892 .78307 L .48023 .78745 L p F P
0 g
s
.913 .878 .787 r
.48023 .78745 m .43093 .84607 L .42748 .83535 L p F P
0 g
s
.648 .534 .711 r
.45874 .39098 m .45196 .34044 L .39636 .35348 L p F P
0 g
s
.648 .534 .711 r
.39636 .35348 m .40924 .40242 L .45874 .39098 L p F P
0 g
s
.493 .452 .74 r
.61651 .9356 m .57889 .86426 L .5893 .85531 L p F P
0 g
s
.428 .439 .769 r
.54667 .78711 m .59625 .84523 L .5893 .85531 L p F P
0 g
s
.327 .404 .789 r
.59625 .84523 m .54667 .78711 L .54785 .78272 L p F P
0 g
s
.689 .582 .731 r
.47648 .51057 m .48692 .57809 L .51227 .57621 L p F P
0 g
s
.722 .609 .73 r
.53767 .57782 m .54728 .51018 L .51184 .5079 L p F P
0 g
s
.722 .609 .73 r
.51184 .5079 m .51227 .57621 L .53767 .57782 L p F P
0 g
s
.652 .553 .73 r
.47648 .51057 m .46699 .44793 L .42494 .45751 L p F P
0 g
s
.651 .546 .723 r
.40924 .40242 m .42494 .45751 L .46699 .44793 L p F P
0 g
s
.759 .624 .71 r
.61344 .40126 m .62582 .35215 L .56983 .33976 L p F P
0 g
s
.763 .611 .691 r
.57453 .29622 m .56983 .33976 L .62582 .35215 L p F P
0 g
s
.651 .546 .723 r
.46699 .44793 m .45874 .39098 L .40924 .40242 L p F P
0 g
s
.756 .632 .723 r
.59835 .45653 m .61344 .40126 L .56359 .39037 L p F P
0 g
s
.756 .632 .723 r
.56359 .39037 m .556 .44743 L .59835 .45653 L p F P
0 g
s
.682 .517 .657 r
.51062 .29185 m .51048 .25563 L .44357 .26105 L p F P
0 g
s
.682 .517 .657 r
.44357 .26105 m .44685 .29697 L .51062 .29185 L p F P
0 g
s
.689 .582 .731 r
.51227 .57621 m .51184 .5079 L .47648 .51057 L p F P
0 g
s
.759 .624 .71 r
.56983 .33976 m .56359 .39037 L .61344 .40126 L p F P
0 g
s
.725 .553 .657 r
.57453 .29622 m .57754 .26025 L .51048 .25563 L p F P
0 g
s
.804 .634 .67 r
.36011 1.18077 m .38161 1.10234 L .42306 1.11533 L p F P
0 g
s
.804 .634 .67 r
.42306 1.11533 m .4084 1.19549 L .36011 1.18077 L p F P
0 g
s
.724 .543 .645 r
.45494 1.28552 m .46099 1.20443 L .51571 1.20727 L p F P
0 g
s
.724 .543 .645 r
.51571 1.20727 m .51598 1.28861 L .45494 1.28552 L p F P
0 g
s
.681 .508 .645 r
.51598 1.28861 m .51571 1.20727 L .57034 1.20393 L p F P
0 g
s
.639 .492 .667 r
.60738 1.11448 m .62265 1.19452 L .57034 1.20393 L p F P
0 g
s
.588 .458 .671 r
.62265 1.19452 m .60738 1.11448 L .64842 1.1011 L p F P
0 g
s
.595 .478 .69 r
.62318 1.02358 m .64842 1.1011 L .60738 1.11448 L p F P
0 g
s
.917 .949 .803 r
.42804 .82442 m .47921 .77863 L .47892 .78307 L p F P
0 g
s
.917 .949 .803 r
.47892 .78307 m .42748 .83535 L .42804 .82442 L p F P
0 g
s
.327 .404 .789 r
.54785 .78272 m .59936 .83448 L .59625 .84523 L p F P
0 g
s
.183 .357 .803 r
.59936 .83448 m .54785 .78272 L .54742 .77828 L p F P
0 g
s
.839 .689 .696 r
.34574 1.08473 m .37721 1.00995 L .40622 1.02462 L p F P
0 g
s
.839 .689 .696 r
.40622 1.02462 m .38161 1.10234 L .34574 1.08473 L p F P
0 g
s
.688 .579 .727 r
.46699 .44793 m .47648 .51057 L .51184 .5079 L p F P
0 g
s
.722 .606 .727 r
.54728 .51018 m .556 .44743 L .51145 .44451 L p F P
0 g
s
.722 .606 .727 r
.51145 .44451 m .51184 .5079 L .54728 .51018 L p F P
0 g
s
.766 .58 .646 r
.39622 1.27582 m .4084 1.19549 L .46099 1.20443 L p F P
0 g
s
.766 .58 .646 r
.46099 1.20443 m .45494 1.28552 L .39622 1.27582 L p F P
0 g
s
.539 .445 .697 r
.64842 1.1011 m .62318 1.02358 L .65174 1.00864 L p F P
0 g
s
.548 .465 .714 r
.61651 .9356 m .65174 1.00864 L .62318 1.02358 L p F P
0 g
s
.725 .553 .657 r
.51048 .25563 m .51062 .29185 L .57453 .29622 L p F P
0 g
s
.681 .508 .645 r
.57034 1.20393 m .57693 1.28499 L .51598 1.28861 L p F P
0 g
s
.634 .472 .646 r
.57693 1.28499 m .57034 1.20393 L .62265 1.19452 L p F P
0 g
s
.688 .579 .727 r
.51184 .5079 m .51145 .44451 L .46699 .44793 L p F P
0 g
s
.685 .545 .688 r
.51083 .33577 m .51062 .29185 L .44685 .29697 L p F P
0 g
s
.685 .545 .688 r
.44685 .29697 m .45196 .34044 L .51083 .33577 L p F P
0 g
s
.897 .811 .755 r
.38319 .9075 m .43093 .84607 L .43818 .85607 L p F P
0 g
s
.897 .811 .755 r
.43818 .85607 m .39485 .92297 L .38319 .9075 L p F P
0 g
s
.86 .997 .79 r
.43261 .81378 m .4811 .77432 L .47921 .77863 L p F P
0 g
s
.86 .997 .79 r
.47921 .77863 m .42804 .82442 L .43261 .81378 L p F P
0 g
s
.871 .748 .724 r
.35416 .99206 m .39485 .92297 L .41186 .9366 L p F P
0 g
s
.871 .748 .724 r
.41186 .9366 m .37721 1.00995 L .35416 .99206 L p F P
0 g
s
.725 .577 .688 r
.56983 .33976 m .57453 .29622 L .51062 .29185 L p F P
0 g
s
.183 .357 .803 r
.54742 .77828 m .59846 .82355 L .59936 .83448 L p F P
0 g
s
0 .287 .787 r
.59846 .82355 m .54742 .77828 L .5454 .77399 L p F P
0 g
s
.493 .452 .74 r
.5893 .85531 m .63309 .9218 L .61651 .9356 L p F P
0 g
s
.413 .419 .757 r
.63309 .9218 m .5893 .85531 L .59625 .84523 L p F P
0 g
s
.688 .572 .72 r
.45874 .39098 m .46699 .44793 L .51145 .44451 L p F P
0 g
s
.482 .432 .725 r
.65174 1.00864 m .61651 .9356 L .63309 .9218 L p F P
0 g
s
.723 .601 .72 r
.556 .44743 m .56359 .39037 L .51111 .38688 L p F P
0 g
s
.723 .601 .72 r
.51111 .38688 m .51145 .44451 L .556 .44743 L p F P
0 g
s
.687 .562 .708 r
.51111 .38688 m .51083 .33577 L .45196 .34044 L p F P
0 g
s
.687 .562 .708 r
.45196 .34044 m .45874 .39098 L .51111 .38688 L p F P
0 g
s
.688 .572 .72 r
.51145 .44451 m .51111 .38688 L .45874 .39098 L p F P
0 g
s
.724 .591 .708 r
.56359 .39037 m .56983 .33976 L .51083 .33577 L p F P
0 g
s
.725 .577 .688 r
.51062 .29185 m .51083 .33577 L .56983 .33976 L p F P
0 g
s
.724 .591 .708 r
.51083 .33577 m .51111 .38688 L .56359 .39037 L p F P
0 g
s
.683 .954 .704 r
.44102 .80394 m .48451 .77035 L .4811 .77432 L p F P
0 g
s
.683 .954 .704 r
.4811 .77432 m .43261 .81378 L .44102 .80394 L p F P
0 g
s
0 .287 .787 r
.5454 .77399 m .59355 .81296 L .59846 .82355 L p F P
0 g
s
0 .185 .692 r
.59355 .81296 m .5454 .77399 L .54186 .77005 L p F P
0 g
s
.808 .62 .648 r
.34224 1.25984 m .36011 1.18077 L .4084 1.19549 L p F P
0 g
s
.808 .62 .648 r
.4084 1.19549 m .39622 1.27582 L .34224 1.25984 L p F P
0 g
s
0 0 0 r
.45289 .79538 m .48928 .76691 L .48451 .77035 L p F P
0 g
s
0 0 0 r
.48451 .77035 m .44102 .80394 L .45289 .79538 L p F P
0 g
s
0 .185 .692 r
.54186 .77005 m .58483 .8032 L .59355 .81296 L p F P
0 g
s
.476 0 0 r
.58483 .8032 m .54186 .77005 L .53698 .76666 L p F P
0 g
s
.846 .679 .676 r
.31821 1.1608 m .34574 1.08473 L .38161 1.10234 L p F P
0 g
s
.846 .679 .676 r
.38161 1.10234 m .36011 1.18077 L .31821 1.1608 L p F P
0 g
s
.634 .472 .646 r
.62265 1.19452 m .63533 1.27478 L .57693 1.28499 L p F P
0 g
s
.58 .435 .649 r
.63533 1.27478 m .62265 1.19452 L .67046 1.17936 L p F P
0 g
s
.588 .458 .671 r
.64842 1.1011 m .67046 1.17936 L .62265 1.19452 L p F P
0 g
s
.528 .421 .676 r
.67046 1.17936 m .64842 1.1011 L .68373 1.08315 L p F P
0 g
s
.539 .445 .697 r
.65174 1.00864 m .68373 1.08315 L .64842 1.1011 L p F P
0 g
s
.924 .881 .773 r
.37749 .89086 m .42748 .83535 L .43093 .84607 L p F P
0 g
s
.924 .881 .773 r
.43093 .84607 m .38319 .9075 L .37749 .89086 L p F P
0 g
s
.413 .419 .757 r
.59625 .84523 m .64427 .9062 L .63309 .9218 L p F P
0 g
s
.302 .378 .774 r
.64427 .9062 m .59625 .84523 L .59936 .83448 L p F P
0 g
s
.723 .525 .622 r
.45026 1.36656 m .45494 1.28552 L .51598 1.28861 L p F P
0 g
s
.723 .525 .622 r
.51598 1.28861 m .51619 1.3698 L .45026 1.36656 L p F P
0 g
s
.678 .488 .622 r
.51619 1.3698 m .51598 1.28861 L .57693 1.28499 L p F P
0 g
s
0 0 0 r
.46768 .78853 m .49519 .76416 L .48928 .76691 L p F P
0 g
s
0 0 0 r
.48928 .76691 m .45289 .79538 L .46768 .78853 L p F P
0 g
s
.476 0 0 r
.53698 .76666 m .57269 .79477 L .58483 .8032 L p F P
0 g
s
.571 0 0 r
.57269 .79477 m .53698 .76666 L .53099 .76397 L p F P
0 g
s
.88 .742 .706 r
.3171 1.0632 m .35416 .99206 L .37721 1.00995 L p F P
0 g
s
.88 .742 .706 r
.37721 1.00995 m .34574 1.08473 L .3171 1.0632 L p F P
0 g
s
.467 .407 .707 r
.68373 1.08315 m .65174 1.00864 L .67422 .99052 L p F P
0 g
s
.482 .432 .725 r
.63309 .9218 m .67422 .99052 L .65174 1.00864 L p F P
0 g
s
.174 0 0 r
.4847 .78372 m .50197 .76223 L .49519 .76416 L p F P
0 g
s
.174 0 0 r
.49519 .76416 m .46768 .78853 L .4847 .78372 L p F P
0 g
s
.908 .81 .739 r
.3382 .97168 m .38319 .9075 L .39485 .92297 L p F P
0 g
s
.908 .81 .739 r
.39485 .92297 m .35416 .99206 L .3382 .97168 L p F P
0 g
s
.571 0 0 r
.53099 .76397 m .55768 .78807 L .57269 .79477 L p F P
0 g
s
.577 .013 0 r
.55768 .78807 m .53099 .76397 L .52415 .76212 L p F P
0 g
s
.767 .563 .622 r
.38681 1.35637 m .39622 1.27582 L .45494 1.28552 L p F P
0 g
s
.767 .563 .622 r
.45494 1.28552 m .45026 1.36656 L .38681 1.35637 L p F P
0 g
s
.394 .393 .74 r
.67422 .99052 m .63309 .9218 L .64427 .9062 L p F P
0 g
s
.678 .488 .622 r
.57693 1.28499 m .58202 1.366 L .51619 1.3698 L p F P
0 g
s
.628 .45 .622 r
.58202 1.366 m .57693 1.28499 L .63533 1.27478 L p F P
0 g
s
.339 0 0 r
.50311 .78121 m .50929 .76123 L .50197 .76223 L p F P
0 g
s
.339 0 0 r
.50197 .76223 m .4847 .78372 L .50311 .78121 L p F P
0 g
s
.577 .013 0 r
.52415 .76212 m .54051 .78343 L .55768 .78807 L p F P
0 g
s
.532 0 0 r
.54051 .78343 m .52415 .76212 L .5168 .76119 L p F P
0 g
s
.453 0 0 r
.52202 .78111 m .5168 .76119 L .50929 .76123 L p F P
0 g
s
.453 0 0 r
.50929 .76123 m .50311 .78121 L .52202 .78111 L p F P
0 g
s
.532 0 0 r
.5168 .76119 m .52202 .78111 L .54051 .78343 L p F P
0 g
s
.927 .954 .783 r
.3781 .87382 m .42804 .82442 L .42748 .83535 L p F P
0 g
s
.927 .954 .783 r
.42748 .83535 m .37749 .89086 L .3781 .87382 L p F P
0 g
s
.302 .378 .774 r
.59936 .83448 m .64944 .88951 L .64427 .9062 L p F P
0 g
s
.141 .319 .782 r
.64944 .88951 m .59936 .83448 L .59846 .82355 L p F P
0 g
s
.852 .667 .652 r
.29527 1.23812 m .31821 1.1608 L .36011 1.18077 L p F P
0 g
s
.852 .667 .652 r
.36011 1.18077 m .34224 1.25984 L .29527 1.23812 L p F P
0 g
s
.58 .435 .649 r
.67046 1.17936 m .6888 1.25831 L .63533 1.27478 L p F P
0 g
s
.515 .393 .652 r
.6888 1.25831 m .67046 1.17936 L .71173 1.15901 L p F P
0 g
s
.528 .421 .676 r
.68373 1.08315 m .71173 1.15901 L .67046 1.17936 L p F P
0 g
s
.811 .605 .623 r
.3284 1.33958 m .34224 1.25984 L .39622 1.27582 L p F P
0 g
s
.811 .605 .623 r
.39622 1.27582 m .38681 1.35637 L .3284 1.33958 L p F P
0 g
s
.628 .45 .622 r
.63533 1.27478 m .64514 1.35527 L .58202 1.366 L p F P
0 g
s
.571 .409 .623 r
.64514 1.35527 m .63533 1.27478 L .6888 1.25831 L p F P
0 g
s
.89 .734 .683 r
.28461 1.13633 m .3171 1.0632 L .34574 1.08473 L p F P
0 g
s
.89 .734 .683 r
.34574 1.08473 m .31821 1.1608 L .28461 1.13633 L p F P
0 g
s
.449 .377 .684 r
.71173 1.15901 m .68373 1.08315 L .71168 1.06134 L p F P
0 g
s
.467 .407 .707 r
.67422 .99052 m .71168 1.06134 L .68373 1.08315 L p F P
0 g
s
.938 .882 .753 r
.33021 .9497 m .37749 .89086 L .38319 .9075 L p F P
0 g
s
.938 .882 .753 r
.38319 .9075 m .3382 .97168 L .33021 .9497 L p F P
0 g
s
.92 .807 .717 r
.29711 1.03861 m .3382 .97168 L .35416 .99206 L p F P
0 g
s
.92 .807 .717 r
.35416 .99206 m .3171 1.0632 L .29711 1.03861 L p F P
0 g
s
.394 .393 .74 r
.64427 .9062 m .68953 .96998 L .67422 .99052 L p F P
0 g
s
.269 .342 .754 r
.68953 .96998 m .64427 .9062 L .64944 .88951 L p F P
0 g
s
.858 .994 .755 r
.38511 .85717 m .43261 .81378 L .42804 .82442 L p F P
0 g
s
.858 .994 .755 r
.42804 .82442 m .3781 .87382 L .38511 .85717 L p F P
0 g
s
.141 .319 .782 r
.59846 .82355 m .64828 .87246 L .64944 .88951 L p F P
0 g
s
0 .229 .749 r
.64828 .87246 m .59846 .82355 L .59355 .81296 L p F P
0 g
s
.37 .36 .718 r
.71168 1.06134 m .67422 .99052 L .68953 .96998 L p F P
0 g
s
.721 .505 .597 r
.44707 1.44768 m .45026 1.36656 L .51619 1.3698 L p F P
0 g
s
.721 .505 .597 r
.51619 1.3698 m .51634 1.45099 L .44707 1.44768 L p F P
0 g
s
.674 .466 .597 r
.51634 1.45099 m .51619 1.3698 L .58202 1.366 L p F P
0 g
s
.767 .544 .596 r
.38039 1.43729 m .38681 1.35637 L .45026 1.36656 L p F P
0 g
s
.767 .544 .596 r
.45026 1.36656 m .44707 1.44768 L .38039 1.43729 L p F P
0 g
s
.674 .466 .597 r
.58202 1.366 m .58549 1.44711 L .51634 1.45099 L p F P
0 g
s
.621 .426 .596 r
.58549 1.44711 m .58202 1.366 L .64514 1.35527 L p F P
0 g
s
.645 .921 .635 r
.39826 .84172 m .44102 .80394 L .43261 .81378 L p F P
0 g
s
.645 .921 .635 r
.43261 .81378 m .38511 .85717 L .39826 .84172 L p F P
0 g
s
0 .229 .749 r
.59355 .81296 m .64074 .85588 L .64828 .87246 L p F P
0 g
s
0 .104 .62 r
.64074 .85588 m .59355 .81296 L .58483 .8032 L p F P
0 g
s
.858 .653 .623 r
.2775 1.31674 m .29527 1.23812 L .34224 1.25984 L p F P
0 g
s
.858 .653 .623 r
.34224 1.25984 m .3284 1.33958 L .2775 1.31674 L p F P
0 g
s
.571 .409 .623 r
.6888 1.25831 m .703 1.33797 L .64514 1.35527 L p F P
0 g
s
.5 .361 .623 r
.703 1.33797 m .6888 1.25831 L .73506 1.23617 L p F P
0 g
s
.515 .393 .652 r
.71173 1.15901 m .73506 1.23617 L .6888 1.25831 L p F P
0 g
s
.899 .724 .655 r
.25747 1.21146 m .28461 1.13633 L .31821 1.1608 L p F P
0 g
s
.899 .724 .655 r
.31821 1.1608 m .29527 1.23812 L .25747 1.21146 L p F P
0 g
s
.939 .957 .753 r
.33071 .9271 m .3781 .87382 L .37749 .89086 L p F P
0 g
s
.939 .957 .753 r
.37749 .89086 m .33021 .9497 L .33071 .9271 L p F P
0 g
s
.428 .341 .655 r
.73506 1.23617 m .71173 1.15901 L .74455 1.13422 L p F P
0 g
s
.449 .377 .684 r
.71168 1.06134 m .74455 1.13422 L .71173 1.15901 L p F P
0 g
s
.269 .342 .754 r
.64944 .88951 m .69682 .94791 L .68953 .96998 L p F P
0 g
s
.083 .266 .752 r
.69682 .94791 m .64944 .88951 L .64828 .87246 L p F P
0 g
s
.814 .587 .595 r
.31896 1.42015 m .3284 1.33958 L .38681 1.35637 L p F P
0 g
s
.814 .587 .595 r
.38681 1.35637 m .38039 1.43729 L .31896 1.42015 L p F P
0 g
s
.934 .801 .69 r
.26097 1.10831 m .29711 1.03861 L .3171 1.0632 L p F P
0 g
s
.934 .801 .69 r
.3171 1.0632 m .28461 1.13633 L .26097 1.10831 L p F P
0 g
s
.621 .426 .596 r
.64514 1.35527 m .65183 1.43617 L .58549 1.44711 L p F P
0 g
s
.56 .38 .594 r
.65183 1.43617 m .64514 1.35527 L .703 1.33797 L p F P
0 g
s
0 0 0 r
.41701 .82824 m .45289 .79538 L .44102 .80394 L p F P
0 g
s
0 0 0 r
.44102 .80394 m .39826 .84172 L .41701 .82824 L p F P
0 g
s
.953 .883 .725 r
.28687 1.012 m .33021 .9497 L .3382 .97168 L p F P
0 g
s
.953 .883 .725 r
.3382 .97168 m .29711 1.03861 L .28687 1.012 L p F P
0 g
s
0 .104 .62 r
.58483 .8032 m .62708 .84057 L .64074 .85588 L p F P
0 g
s
.565 .013 0 r
.62708 .84057 m .58483 .8032 L .57269 .79477 L p F P
0 g
s
.34 .32 .69 r
.74455 1.13422 m .71168 1.06134 L .73088 1.03655 L p F P
0 g
s
.37 .36 .718 r
.68953 .96998 m .73088 1.03655 L .71168 1.06134 L p F P
0 g
s
.228 .295 .725 r
.73088 1.03655 m .68953 .96998 L .69682 .94791 L p F P
0 g
s
.008 0 0 r
.44049 .81741 m .46768 .78853 L .45289 .79538 L p F P
0 g
s
.008 0 0 r
.45289 .79538 m .41701 .82824 L .44049 .81741 L p F P
0 g
s
.565 .013 0 r
.57269 .79477 m .6079 .82727 L .62708 .84057 L p F P
0 g
s
.638 .077 0 r
.6079 .82727 m .57269 .79477 L .55768 .78807 L p F P
0 g
s
.718 .483 .569 r
.44546 1.52919 m .44707 1.44768 L .51634 1.45099 L p F P
0 g
s
.718 .483 .569 r
.51634 1.45099 m .51641 1.53247 L .44546 1.52919 L p F P
0 g
s
.668 .443 .569 r
.51641 1.53247 m .51634 1.45099 L .58549 1.44711 L p F P
0 g
s
.849 .984 .701 r
.33986 .90495 m .38511 .85717 L .3781 .87382 L p F P
0 g
s
.849 .984 .701 r
.3781 .87382 m .33071 .9271 L .33986 .90495 L p F P
0 g
s
.083 .266 .752 r
.64828 .87246 m .69558 .92531 L .69682 .94791 L p F P
0 g
s
0 .149 .692 r
.69558 .92531 m .64828 .87246 L .64074 .85588 L p F P
0 g
s
.235 0 0 r
.46759 .80981 m .4847 .78372 L .46768 .78853 L p F P
0 g
s
.235 0 0 r
.46768 .78853 m .44049 .81741 L .46759 .80981 L p F P
0 g
s
.766 .524 .568 r
.37714 1.51887 m .38039 1.43729 L .44707 1.44768 L p F P
0 g
s
.766 .524 .568 r
.44707 1.44768 m .44546 1.52919 L .37714 1.51887 L p F P
0 g
s
.638 .077 0 r
.55768 .78807 m .58406 .81668 L .6079 .82727 L p F P
0 g
s
.628 .087 0 r
.58406 .81668 m .55768 .78807 L .54051 .78343 L p F P
0 g
s
.668 .443 .569 r
.58549 1.44711 m .58725 1.52862 L .51641 1.53247 L p F P
0 g
s
.613 .399 .567 r
.58725 1.52862 m .58549 1.44711 L .65183 1.43617 L p F P
0 g
s
.909 .71 .621 r
.23641 1.28866 m .25747 1.21146 L .29527 1.23812 L p F P
0 g
s
.909 .71 .621 r
.29527 1.23812 m .2775 1.31674 L .23641 1.28866 L p F P
0 g
s
.863 .635 .591 r
.26535 1.39683 m .2775 1.31674 L .3284 1.33958 L p F P
0 g
s
.863 .635 .591 r
.3284 1.33958 m .31896 1.42015 L .26535 1.39683 L p F P
0 g
s
.5 .361 .623 r
.73506 1.23617 m .75315 1.31469 L .703 1.33797 L p F P
0 g
s
.404 .299 .621 r
.75315 1.31469 m .73506 1.23617 L .77199 1.20915 L p F P
0 g
s
.428 .341 .655 r
.74455 1.13422 m .77199 1.20915 L .73506 1.23617 L p F P
0 g
s
.39 0 0 r
.49698 .80582 m .50311 .78121 L .4847 .78372 L p F P
0 g
s
.39 0 0 r
.4847 .78372 m .46759 .80981 L .49698 .80582 L p F P
0 g
s
.56 .38 .594 r
.703 1.33797 m .71269 1.41851 L .65183 1.43617 L p F P
0 g
s
.483 .325 .591 r
.71269 1.41851 m .703 1.33797 L .75315 1.31469 L p F P
0 g
s
.628 .087 0 r
.54051 .78343 m .55671 .80935 L .58406 .81668 L p F P
0 g
s
.577 .06 0 r
.55671 .80935 m .54051 .78343 L .52202 .78111 L p F P
0 g
s
.948 .792 .655 r
.23072 1.18086 m .26097 1.10831 L .28461 1.13633 L p F P
0 g
s
.948 .792 .655 r
.28461 1.13633 m .25747 1.21146 L .23072 1.18086 L p F P
0 g
s
.499 .001 .004 r
.52719 .80567 m .52202 .78111 L .50311 .78121 L p F P
0 g
s
.499 .001 .004 r
.50311 .78121 m .49698 .80582 L .52719 .80567 L p F P
0 g
s
.577 .06 0 r
.52202 .78111 m .52719 .80567 L .55671 .80935 L p F P
0 g
s
.949 .956 .711 r
.28711 .98456 m .33071 .9271 L .33021 .9497 L p F P
0 g
s
.949 .956 .711 r
.33021 .9497 m .28687 1.012 L .28711 .98456 L p F P
0 g
s
.305 .27 .654 r
.77199 1.20915 m .74455 1.13422 L .76727 1.10596 L p F P
0 g
s
.34 .32 .69 r
.73088 1.03655 m .76727 1.10596 L .74455 1.13422 L p F P
0 g
s
.97 .879 .688 r
.24864 1.07791 m .28687 1.012 L .29711 1.03861 L p F P
0 g
s
.97 .879 .688 r
.29711 1.03861 m .26097 1.10831 L .24864 1.07791 L p F P
0 g
s
.228 .295 .725 r
.69682 .94791 m .74025 1.00983 L .73088 1.03655 L p F P
0 g
s
.009 .196 .708 r
.74025 1.00983 m .69682 .94791 L .69558 .92531 L p F P
0 g
s
.175 .236 .687 r
.76727 1.10596 m .73088 1.03655 L .74025 1.00983 L p F P
0 g
s
.815 .567 .563 r
.31418 1.50184 m .31896 1.42015 L .38039 1.43729 L p F P
0 g
s
.815 .567 .563 r
.38039 1.43729 m .37714 1.51887 L .31418 1.50184 L p F P
0 g
s
.587 .865 .537 r
.35739 .88432 m .39826 .84172 L .38511 .85717 L p F P
0 g
s
.587 .865 .537 r
.38511 .85717 m .33986 .90495 L .35739 .88432 L p F P
0 g
s
.613 .399 .567 r
.65183 1.43617 m .65522 1.51775 L .58725 1.52862 L p F P
0 g
s
.548 .349 .563 r
.65522 1.51775 m .65183 1.43617 L .71269 1.41851 L p F P
0 g
s
0 .149 .692 r
.64074 .85588 m .6857 .90324 L .69558 .92531 L p F P
0 g
s
0 0 .518 r
.6857 .90324 m .64074 .85588 L .62708 .84057 L p F P
0 g
s
0 0 0 r
.3826 .86626 m .41701 .82824 L .39826 .84172 L p F P
0 g
s
0 0 0 r
.39826 .84172 m .35739 .88432 L .3826 .86626 L p F P
0 g
s
.917 .692 .582 r
.22199 1.36813 m .23641 1.28866 L .2775 1.31674 L p F P
0 g
s
.917 .692 .582 r
.2775 1.31674 m .26535 1.39683 L .22199 1.36813 L p F P
0 g
s
0 0 .518 r
.62708 .84057 m .66748 .88278 L .6857 .90324 L p F P
0 g
s
.66 .119 0 r
.66748 .88278 m .62708 .84057 L .6079 .82727 L p F P
0 g
s
.827 .958 .623 r
.29809 .95756 m .33986 .90495 L .33071 .9271 L p F P
0 g
s
.827 .958 .623 r
.33071 .9271 m .28711 .98456 L .29809 .95756 L p F P
0 g
s
.483 .325 .591 r
.75315 1.31469 m .76551 1.39473 L .71269 1.41851 L p F P
0 g
s
.376 .252 .581 r
.76551 1.39473 m .75315 1.31469 L .7933 1.28623 L p F P
0 g
s
.404 .299 .621 r
.77199 1.20915 m .7933 1.28623 L .75315 1.31469 L p F P
0 g
s
.961 .779 .612 r
.20719 1.2564 m .23072 1.18086 L .25747 1.21146 L p F P
0 g
s
.961 .779 .612 r
.25747 1.21146 m .23641 1.28866 L .20719 1.2564 L p F P
0 g
s
.009 .196 .708 r
.69558 .92531 m .7391 .98238 L .74025 1.00983 L p F P
0 g
s
0 .044 .609 r
.7391 .98238 m .69558 .92531 L .6857 .90324 L p F P
0 g
s
.867 .615 .555 r
.2592 1.47865 m .26535 1.39683 L .31896 1.42015 L p F P
0 g
s
.867 .615 .555 r
.31896 1.42015 m .31418 1.50184 L .2592 1.47865 L p F P
0 g
s
.263 .211 .61 r
.7933 1.28623 m .77199 1.20915 L .79773 1.17829 L p F P
0 g
s
.305 .27 .654 r
.76727 1.10596 m .79773 1.17829 L .77199 1.20915 L p F P
0 g
s
.548 .349 .563 r
.71269 1.41851 m .7176 1.50021 L .65522 1.51775 L p F P
0 g
s
.464 .286 .554 r
.7176 1.50021 m .71269 1.41851 L .76551 1.39473 L p F P
0 g
s
.985 .87 .64 r
.21656 1.14759 m .24864 1.07791 L .26097 1.10831 L p F P
0 g
s
.985 .87 .64 r
.26097 1.10831 m .23072 1.18086 L .21656 1.14759 L p F P
0 g
s
.956 .946 .652 r
.24853 1.04646 m .28711 .98456 L .28687 1.012 L p F P
0 g
s
.956 .946 .652 r
.28687 1.012 m .24864 1.07791 L .24853 1.04646 L p F P
0 g
s
.111 .163 .637 r
.79773 1.17829 m .76727 1.10596 L .77859 1.07543 L p F P
0 g
s
.175 .236 .687 r
.74025 1.00983 m .77859 1.07543 L .76727 1.10596 L p F P
0 g
s
0 .105 .645 r
.77859 1.07543 m .74025 1.00983 L .7391 .98238 L p F P
0 g
s
.089 0 0 r
.41436 .85172 m .44049 .81741 L .41701 .82824 L p F P
0 g
s
.089 0 0 r
.41701 .82824 m .3826 .86626 L .41436 .85172 L p F P
0 g
s
.66 .119 0 r
.6079 .82727 m .64167 .86497 L .66748 .88278 L p F P
0 g
s
.703 .168 0 r
.64167 .86497 m .6079 .82727 L .58406 .81668 L p F P
0 g
s
.299 0 .016 r
.45113 .84149 m .46759 .80981 L .44049 .81741 L p F P
0 g
s
.299 0 .016 r
.44049 .81741 m .41436 .85172 L .45113 .84149 L p F P
0 g
s
0 0 0 r
.31955 .93235 m .35739 .88432 L .33986 .90495 L p F P
0 g
s
0 0 0 r
.33986 .90495 m .29809 .95756 L .31955 .93235 L p F P
0 g
s
.703 .168 0 r
.58406 .81668 m .60942 .85074 L .64167 .86497 L p F P
0 g
s
.676 .167 .023 r
.60942 .85074 m .58406 .81668 L .55671 .80935 L p F P
0 g
s
0 .044 .609 r
.6857 .90324 m .72722 .95547 L .7391 .98238 L p F P
0 g
s
.607 .127 0 r
.72722 .95547 m .6857 .90324 L .66748 .88278 L p F P
0 g
s
.441 0 .077 r
.49108 .83612 m .49698 .80582 L .46759 .80981 L p F P
0 g
s
.441 0 .077 r
.46759 .80981 m .45113 .84149 L .49108 .83612 L p F P
0 g
s
.923 .67 .538 r
.21469 1.45011 m .22199 1.36813 L .26535 1.39683 L p F P
0 g
s
.923 .67 .538 r
.26535 1.39683 m .2592 1.47865 L .21469 1.45011 L p F P
0 g
s
.676 .167 .023 r
.55671 .80935 m .57231 .84088 L .60942 .85074 L p F P
0 g
s
.62 .135 .08 r
.57231 .84088 m .55671 .80935 L .52719 .80567 L p F P
0 g
s
.971 .759 .56 r
.19107 1.33511 m .20719 1.2564 L .23641 1.28866 L p F P
0 g
s
.971 .759 .56 r
.23641 1.28866 m .22199 1.36813 L .19107 1.33511 L p F P
0 g
s
.464 .286 .554 r
.76551 1.39473 m .77177 1.47656 L .7176 1.50021 L p F P
0 g
s
.346 .2 .536 r
.77177 1.47656 m .76551 1.39473 L .80789 1.36564 L p F P
0 g
s
.376 .252 .581 r
.7933 1.28623 m .80789 1.36564 L .76551 1.39473 L p F P
0 g
s
.214 .144 .557 r
.80789 1.36564 m .7933 1.28623 L .82142 1.25368 L p F P
0 g
s
.263 .211 .61 r
.79773 1.17829 m .82142 1.25368 L .7933 1.28623 L p F P
0 g
s
.543 .076 .097 r
.53218 .83591 m .52719 .80567 L .49698 .80582 L p F P
0 g
s
.543 .076 .097 r
.49698 .80582 m .49108 .83612 L .53218 .83591 L p F P
0 g
s
.62 .135 .08 r
.52719 .80567 m .53218 .83591 L .57231 .84088 L p F P
0 g
s
.996 .853 .576 r
.19155 1.22124 m .21656 1.14759 L .23072 1.18086 L p F P
0 g
s
.996 .853 .576 r
.23072 1.18086 m .20719 1.2564 L .19155 1.22124 L p F P
0 g
s
.786 .908 .513 r
.26101 1.01544 m .29809 .95756 L .28711 .98456 L p F P
0 g
s
.786 .908 .513 r
.28711 .98456 m .24853 1.04646 L .26101 1.01544 L p F P
0 g
s
0 .105 .645 r
.7391 .98238 m .77763 1.04396 L .77859 1.07543 L p F P
0 g
s
0 0 .494 r
.77763 1.04396 m .7391 .98238 L .72722 .95547 L p F P
0 g
s
.034 .073 .571 r
.82142 1.25368 m .79773 1.17829 L .81076 1.14487 L p F P
0 g
s
.111 .163 .637 r
.77859 1.07543 m .81076 1.14487 L .79773 1.17829 L p F P
0 g
s
.953 .923 .57 r
.21606 1.11309 m .24853 1.04646 L .24864 1.07791 L p F P
0 g
s
.953 .923 .57 r
.24864 1.07791 m .21656 1.14759 L .21606 1.11309 L p F P
0 g
s
0 0 .559 r
.81076 1.14487 m .77859 1.07543 L .77763 1.04396 L p F P
0 g
s
0 0 0 r
.35066 .91021 m .3826 .86626 L .35739 .88432 L p F P
0 g
s
0 0 0 r
.35739 .88432 m .31955 .93235 L .35066 .91021 L p F P
0 g
s
.607 .127 0 r
.66748 .88278 m .7049 .93045 L .72722 .95547 L p F P
0 g
s
.748 .231 0 r
.7049 .93045 m .66748 .88278 L .64167 .86497 L p F P
0 g
s
.171 0 .022 r
.39004 .89234 m .41436 .85172 L .3826 .86626 L p F P
0 g
s
.171 0 .022 r
.3826 .86626 m .35066 .91021 L .39004 .89234 L p F P
0 g
s
.748 .231 0 r
.64167 .86497 m .67303 .90862 L .7049 .93045 L p F P
0 g
s
.758 .259 .033 r
.67303 .90862 m .64167 .86497 L .60942 .85074 L p F P
0 g
s
0 0 0 r
.28586 .98637 m .31955 .93235 L .29809 .95756 L p F P
0 g
s
0 0 0 r
.29809 .95756 m .26101 1.01544 L .28586 .98637 L p F P
0 g
s
.977 .733 .499 r
.18289 1.41725 m .19107 1.33511 L .22199 1.36813 L p F P
0 g
s
.977 .733 .499 r
.22199 1.36813 m .21469 1.45011 L .18289 1.41725 L p F P
0 g
s
0 0 .494 r
.72722 .95547 m .76408 1.01303 L .77763 1.04396 L p F P
0 g
s
.73 .263 0 r
.76408 1.01303 m .72722 .95547 L .7049 .93045 L p F P
0 g
s
.346 .2 .536 r
.80789 1.36564 m .81528 1.44763 L .77177 1.47656 L p F P
0 g
s
.161 .068 .494 r
.81528 1.44763 m .80789 1.36564 L .83767 1.33233 L p F P
0 g
s
.214 .144 .557 r
.82142 1.25368 m .83767 1.33233 L .80789 1.36564 L p F P
0 g
s
1 .824 .497 r
.17438 1.29908 m .19155 1.22124 L .20719 1.2564 L p F P
0 g
s
1 .824 .497 r
.20719 1.2564 m .19107 1.33511 L .17438 1.29908 L p F P
0 g
s
0 0 .488 r
.83767 1.33233 m .82142 1.25368 L .83585 1.21836 L p F P
0 g
s
.034 .073 .571 r
.81076 1.14487 m .83585 1.21836 L .82142 1.25368 L p F P
0 g
s
.717 .824 .37 r
.22973 1.07897 m .26101 1.01544 L .24853 1.04646 L p F P
0 g
s
.717 .824 .37 r
.24853 1.04646 m .21606 1.11309 L .22973 1.07897 L p F P
0 g
s
.934 .879 .462 r
.1907 1.18471 m .21606 1.11309 L .21656 1.14759 L p F P
0 g
s
.934 .879 .462 r
.21656 1.14759 m .19155 1.22124 L .1907 1.18471 L p F P
0 g
s
0 0 .559 r
.77763 1.04396 m .81006 1.11034 L .81076 1.14487 L p F P
0 g
s
0 0 .346 r
.81006 1.11034 m .77763 1.04396 L .76408 1.01303 L p F P
0 g
s
0 0 .445 r
.83585 1.21836 m .81076 1.14487 L .81006 1.11034 L p F P
0 g
s
.359 0 .122 r
.43578 .87974 m .45113 .84149 L .41436 .85172 L p F P
0 g
s
.359 0 .122 r
.41436 .85172 m .39004 .89234 L .43578 .87974 L p F P
0 g
s
.758 .259 .033 r
.60942 .85074 m .63303 .89113 L .67303 .90862 L p F P
0 g
s
.717 .245 .128 r
.63303 .89113 m .60942 .85074 L .57231 .84088 L p F P
0 g
s
.487 .069 .172 r
.48558 .87312 m .49108 .83612 L .45113 .84149 L p F P
0 g
s
.487 .069 .172 r
.45113 .84149 m .43578 .87974 L .48558 .87312 L p F P
0 g
s
.717 .245 .128 r
.57231 .84088 m .58685 .87898 L .63303 .89113 L p F P
0 g
s
.657 .208 .174 r
.58685 .87898 m .57231 .84088 L .53218 .83591 L p F P
0 g
s
0 0 0 r
.32215 .96079 m .35066 .91021 L .31955 .93235 L p F P
0 g
s
0 0 0 r
.31955 .93235 m .28586 .98637 L .32215 .96079 L p F P
0 g
s
.73 .263 0 r
.7049 .93045 m .73822 .98419 L .76408 1.01303 L p F P
0 g
s
.819 .338 .01 r
.73822 .98419 m .7049 .93045 L .67303 .90862 L p F P
0 g
s
.582 .15 .188 r
.53683 .87286 m .53218 .83591 L .49108 .83612 L p F P
0 g
s
.582 .15 .188 r
.49108 .83612 m .48558 .87312 L .53683 .87286 L p F P
0 g
s
.657 .208 .174 r
.53218 .83591 m .53683 .87286 L .58685 .87898 L p F P
0 g
s
.992 .781 .402 r
.16567 1.38138 m .17438 1.29908 L .19107 1.33511 L p F P
0 g
s
.992 .781 .402 r
.19107 1.33511 m .18289 1.41725 L .16567 1.38138 L p F P
0 g
s
0 0 0 r
.25736 1.04693 m .28586 .98637 L .26101 1.01544 L p F P
0 g
s
0 0 0 r
.26101 1.01544 m .22973 1.07897 L .25736 1.04693 L p F P
0 g
s
.161 .068 .494 r
.83767 1.33233 m .84591 1.41448 L .81528 1.44763 L p F P
0 g
s
0 0 .389 r
.84591 1.41448 m .83767 1.33233 L .85307 1.29613 L p F P
0 g
s
0 0 .488 r
.83585 1.21836 m .85307 1.29613 L .83767 1.33233 L p F P
0 g
s
0 0 .346 r
.76408 1.01303 m .79519 1.07632 L .81006 1.11034 L p F P
0 g
s
.833 .394 0 r
.79519 1.07632 m .76408 1.01303 L .73822 .98419 L p F P
0 g
s
.892 .807 .327 r
.17326 1.26161 m .1907 1.18471 L .19155 1.22124 L p F P
0 g
s
.892 .807 .327 r
.19155 1.22124 m .17438 1.29908 L .17326 1.26161 L p F P
0 g
s
0 0 0 r
.20523 1.14852 m .22973 1.07897 L .21606 1.11309 L p F P
0 g
s
0 0 0 r
.21606 1.11309 m .1907 1.18471 L .20523 1.14852 L p F P
0 g
s
0 0 .306 r
.85307 1.29613 m .83585 1.21836 L .8354 1.1818 L p F P
0 g
s
0 0 .445 r
.81006 1.11034 m .8354 1.1818 L .83585 1.21836 L p F P
0 g
s
.245 0 .141 r
.36829 .9401 m .39004 .89234 L .35066 .91021 L p F P
0 g
s
.245 0 .141 r
.35066 .91021 m .32215 .96079 L .36829 .9401 L p F P
0 g
s
.733 .393 0 r
.8354 1.1818 m .81006 1.11034 L .79519 1.07632 L p F P
0 g
s
.819 .338 .01 r
.67303 .90862 m .70103 .95895 L .73822 .98419 L p F P
0 g
s
.8 .342 .15 r
.70103 .95895 m .67303 .90862 L .63303 .89113 L p F P
0 g
s
.412 .04 .22 r
.42204 .92548 m .43578 .87974 L .39004 .89234 L p F P
0 g
s
.412 .04 .22 r
.39004 .89234 m .36829 .9401 L .42204 .92548 L p F P
0 g
s
.8 .342 .15 r
.63303 .89113 m .65415 .9387 L .70103 .95895 L p F P
0 g
s
.749 .317 .225 r
.65415 .9387 m .63303 .89113 L .58685 .87898 L p F P
0 g
s
.081 0 .132 r
.29798 1.01867 m .32215 .96079 L .28586 .98637 L p F P
0 g
s
.081 0 .132 r
.28586 .98637 m .25736 1.04693 L .29798 1.01867 L p F P
0 g
s
.833 .394 0 r
.73822 .98419 m .76641 1.04452 L .79519 1.07632 L p F P
0 g
s
.869 .431 .145 r
.76641 1.04452 m .73822 .98419 L .70103 .95895 L p F P
0 g
s
.527 .144 .259 r
.48064 .91779 m .48558 .87312 L .43578 .87974 L p F P
0 g
s
.527 .144 .259 r
.43578 .87974 m .42204 .92548 L .48064 .91779 L p F P
0 g
s
.749 .317 .225 r
.58685 .87898 m .59988 .92461 L .65415 .9387 L p F P
0 g
s
.686 .275 .261 r
.59988 .92461 m .58685 .87898 L .53683 .87286 L p F P
0 g
s
.824 .71 .176 r
.1644 1.34404 m .17326 1.26161 L .17438 1.29908 L p F P
0 g
s
.824 .71 .176 r
.17438 1.29908 m .16567 1.38138 L .1644 1.34404 L p F P
0 g
s
0 0 .389 r
.85307 1.29613 m .86182 1.37844 L .84591 1.41448 L p F P
0 g
s
0 0 .082 r
.235 1.11447 m .25736 1.04693 L .22973 1.07897 L p F P
0 g
s
0 0 .082 r
.22973 1.07897 m .20523 1.14852 L .235 1.11447 L p F P
0 g
s
0 0 0 r
.18837 1.22443 m .20523 1.14852 L .1907 1.18471 L p F P
0 g
s
0 0 0 r
.1907 1.18471 m .17326 1.26161 L .18837 1.22443 L p F P
0 g
s
0 0 .15 r
.86182 1.37844 m .85307 1.29613 L .85283 1.25861 L p F P
0 g
s
0 0 .306 r
.8354 1.1818 m .85283 1.25861 L .85307 1.29613 L p F P
0 g
s
.733 .393 0 r
.79519 1.07632 m .81956 1.14571 L .8354 1.1818 L p F P
0 g
s
.905 .505 .101 r
.81956 1.14571 m .79519 1.07632 L .76641 1.04452 L p F P
0 g
s
.614 .219 .271 r
.541 .9175 m .53683 .87286 L .48558 .87312 L p F P
0 g
s
.614 .219 .271 r
.48558 .87312 m .48064 .91779 L .541 .9175 L p F P
0 g
s
.686 .275 .261 r
.53683 .87286 m .541 .9175 L .59988 .92461 L p F P
0 g
s
.845 .533 0 r
.85283 1.25861 m .8354 1.1818 L .81956 1.14571 L p F P
0 g
s
.309 0 .247 r
.34981 .99577 m .36829 .9401 L .32215 .96079 L p F P
0 g
s
.309 0 .247 r
.32215 .96079 m .29798 1.01867 L .34981 .99577 L p F P
0 g
s
.869 .431 .145 r
.70103 .95895 m .72477 1.01663 L .76641 1.04452 L p F P
0 g
s
.829 .414 .254 r
.72477 1.01663 m .70103 .95895 L .65415 .9387 L p F P
0 g
s
.163 0 .252 r
.27898 1.08439 m .29798 1.01867 L .25736 1.04693 L p F P
0 g
s
.163 0 .252 r
.25736 1.04693 m .235 1.11447 L .27898 1.08439 L p F P
0 g
s
.455 .12 .307 r
.41035 .97956 m .42204 .92548 L .36829 .9401 L p F P
0 g
s
.455 .12 .307 r
.36829 .9401 m .34981 .99577 L .41035 .97956 L p F P
0 g
s
.905 .505 .101 r
.76641 1.04452 m .78854 1.11191 L .81956 1.14571 L p F P
0 g
s
.9 .506 .262 r
.78854 1.11191 m .76641 1.04452 L .72477 1.01663 L p F P
0 g
s
.829 .414 .254 r
.65415 .9387 m .67209 .99421 L .72477 1.01663 L p F P
0 g
s
.771 .379 .311 r
.67209 .99421 m .65415 .9387 L .59988 .92461 L p F P
0 g
s
0 0 .136 r
.17979 1.30697 m .18837 1.22443 L .17326 1.26161 L p F P
0 g
s
0 0 .136 r
.17326 1.26161 m .1644 1.34404 L .17979 1.30697 L p F P
0 g
s
0 0 .223 r
.21958 1.1894 m .235 1.11447 L .20523 1.14852 L p F P
0 g
s
0 0 .223 r
.20523 1.14852 m .18837 1.22443 L .21958 1.1894 L p F P
0 g
s
0 0 .15 r
.85283 1.25861 m .86169 1.34106 L .86182 1.37844 L p F P
0 g
s
.845 .533 0 r
.81956 1.14571 m .83634 1.22153 L .85283 1.25861 L p F P
0 g
s
.949 .592 .237 r
.83634 1.22153 m .81956 1.14571 L .78854 1.11191 L p F P
0 g
s
.922 .644 .158 r
.86169 1.34106 m .85283 1.25861 L .83634 1.22153 L p F P
0 g
s
.558 .211 .336 r
.47644 .97103 m .48064 .91779 L .42204 .92548 L p F P
0 g
s
.558 .211 .336 r
.42204 .92548 m .41035 .97956 L .47644 .97103 L p F P
0 g
s
.771 .379 .311 r
.59988 .92461 m .61095 .97859 L .67209 .99421 L p F P
0 g
s
.708 .334 .338 r
.61095 .97859 m .59988 .92461 L .541 .9175 L p F P
0 g
s
.639 .28 .345 r
.54455 .9707 m .541 .9175 L .48064 .91779 L p F P
0 g
s
.639 .28 .345 r
.48064 .91779 m .47644 .97103 L .54455 .9707 L p F P
0 g
s
.708 .334 .338 r
.541 .9175 m .54455 .9707 L .61095 .97859 L p F P
0 g
s
.361 .076 .338 r
.33527 1.05998 m .34981 .99577 L .29798 1.01867 L p F P
0 g
s
.361 .076 .338 r
.29798 1.01867 m .27898 1.08439 L .33527 1.05998 L p F P
0 g
s
.9 .506 .262 r
.72477 1.01663 m .74343 1.08222 L .78854 1.11191 L p F P
0 g
s
.847 .473 .342 r
.74343 1.08222 m .72477 1.01663 L .67209 .99421 L p F P
0 g
s
.229 .004 .35 r
.26586 1.15842 m .27898 1.08439 L .235 1.11447 L p F P
0 g
s
.229 .004 .35 r
.235 1.11447 m .21958 1.1894 L .26586 1.15842 L p F P
0 g
s
.949 .592 .237 r
.78854 1.11191 m .8038 1.18676 L .83634 1.22153 L p F P
0 g
s
.916 .565 .357 r
.8038 1.18676 m .78854 1.11191 L .74343 1.08222 L p F P
0 g
s
.031 0 .336 r
.21173 1.27203 m .21958 1.1894 L .18837 1.22443 L p F P
0 g
s
.031 0 .336 r
.18837 1.22443 m .17979 1.30697 L .21173 1.27203 L p F P
0 g
s
.922 .644 .158 r
.83634 1.22153 m .84488 1.30409 L .86169 1.34106 L p F P
0 g
s
.97 .656 .347 r
.84488 1.30409 m .83634 1.22153 L .8038 1.18676 L p F P
0 g
s
.49 .189 .381 r
.40114 1.04268 m .41035 .97956 L .34981 .99577 L p F P
0 g
s
.49 .189 .381 r
.34981 .99577 m .33527 1.05998 L .40114 1.04268 L p F P
0 g
s
.847 .473 .342 r
.67209 .99421 m .68621 1.05832 L .74343 1.08222 L p F P
0 g
s
.786 .43 .384 r
.68621 1.05832 m .67209 .99421 L .61095 .97859 L p F P
0 g
s
.583 .269 .402 r
.47313 1.03357 m .47644 .97103 L .41035 .97956 L p F P
0 g
s
.583 .269 .402 r
.41035 .97956 m .40114 1.04268 L .47313 1.03357 L p F P
0 g
s
.786 .43 .384 r
.61095 .97859 m .61968 1.04165 L .68621 1.05832 L p F P
0 g
s
.724 .384 .403 r
.61968 1.04165 m .61095 .97859 L .54455 .9707 L p F P
0 g
s
.402 .149 .412 r
.32522 1.13326 m .33527 1.05998 L .27898 1.08439 L p F P
0 g
s
.402 .149 .412 r
.27898 1.08439 m .26586 1.15842 L .32522 1.13326 L p F P
0 g
s
.658 .332 .409 r
.54735 1.03322 m .54455 .9707 L .47644 .97103 L p F P
0 g
s
.658 .332 .409 r
.47644 .97103 m .47313 1.03357 L .54735 1.03322 L p F P
0 g
s
.916 .565 .357 r
.74343 1.08222 m .75632 1.15618 L .8038 1.18676 L p F P
0 g
s
.856 .52 .415 r
.75632 1.15618 m .74343 1.08222 L .68621 1.05832 L p F P
0 g
s
.724 .384 .403 r
.54455 .9707 m .54735 1.03322 L .61968 1.04165 L p F P
0 g
s
.281 .086 .429 r
.25917 1.2411 m .26586 1.15842 L .21958 1.1894 L p F P
0 g
s
.281 .086 .429 r
.21958 1.1894 m .21173 1.27203 L .25917 1.2411 L p F P
0 g
s
.97 .656 .347 r
.8038 1.18676 m .81157 1.26939 L .84488 1.30409 L p F P
0 g
s
.922 .609 .433 r
.81157 1.26939 m .8038 1.18676 L .75632 1.15618 L p F P
0 g
s
.517 .246 .443 r
.39477 1.11542 m .40114 1.04268 L .33527 1.05998 L p F P
0 g
s
.517 .246 .443 r
.33527 1.05998 m .32522 1.13326 L .39477 1.11542 L p F P
0 g
s
.856 .52 .415 r
.68621 1.05832 m .69598 1.13155 L .75632 1.15618 L p F P
0 g
s
.795 .473 .444 r
.69598 1.13155 m .68621 1.05832 L .61968 1.04165 L p F P
0 g
s
.602 .318 .457 r
.47084 1.10601 m .47313 1.03357 L .40114 1.04268 L p F P
0 g
s
.602 .318 .457 r
.40114 1.04268 m .39477 1.11542 L .47084 1.10601 L p F P
0 g
s
.795 .473 .444 r
.61968 1.04165 m .62573 1.11435 L .69598 1.13155 L p F P
0 g
s
.734 .426 .458 r
.62573 1.11435 m .61968 1.04165 L .54735 1.03322 L p F P
0 g
s
.434 .209 .472 r
.3201 1.21596 m .32522 1.13326 L .26586 1.15842 L p F P
0 g
s
.434 .209 .472 r
.26586 1.15842 m .25917 1.2411 L .3201 1.21596 L p F P
0 g
s
.922 .609 .433 r
.75632 1.15618 m .76289 1.23886 L .81157 1.26939 L p F P
0 g
s
.86 .557 .474 r
.76289 1.23886 m .75632 1.15618 L .69598 1.13155 L p F P
0 g
s
.672 .375 .462 r
.54928 1.10565 m .54735 1.03322 L .47313 1.03357 L p F P
0 g
s
.672 .375 .462 r
.47313 1.03357 m .47084 1.10601 L .54928 1.10565 L p F P
0 g
s
.734 .426 .458 r
.54735 1.03322 m .54928 1.10565 L .62573 1.11435 L p F P
0 g
s
.538 .294 .493 r
.39152 1.19814 m .39477 1.11542 L .32522 1.13326 L p F P
0 g
s
.538 .294 .493 r
.32522 1.13326 m .3201 1.21596 L .39152 1.19814 L p F P
0 g
s
.86 .557 .474 r
.69598 1.13155 m .70096 1.21426 L .76289 1.23886 L p F P
0 g
s
.8 .507 .494 r
.70096 1.21426 m .69598 1.13155 L .62573 1.11435 L p F P
0 g
s
.616 .358 .503 r
.46968 1.18874 m .47084 1.10601 L .39477 1.11542 L p F P
0 g
s
.616 .358 .503 r
.39477 1.11542 m .39152 1.19814 L .46968 1.18874 L p F P
0 g
s
.8 .507 .494 r
.62573 1.11435 m .62881 1.19707 L .70096 1.21426 L p F P
0 g
s
.741 .46 .503 r
.62881 1.19707 m .62573 1.11435 L .54928 1.10565 L p F P
0 g
s
.682 .411 .506 r
.55027 1.18838 m .54928 1.10565 L .47084 1.10601 L p F P
0 g
s
.682 .411 .506 r
.47084 1.10601 m .46968 1.18874 L .55027 1.18838 L p F P
0 g
s
.741 .46 .503 r
.54928 1.10565 m .55027 1.18838 L .62881 1.19707 L p F P
0 g
s
.25 Mabswid
.64785 0 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.64785 0 m
.0843 .2212 L
s
0 1.32748 m
.37669 1.62453 L
s
.02777 1.34938 m
.0285 1.33919 L
s
[(-1)] .02631 1.36977 .07184 -1 Mshowa
.11542 1.4185 m
.11601 1.4083 L
s
[(-0.5)] .11423 1.4389 .05827 -1 Mshowa
.19883 1.48428 m
.1993 1.47407 L
s
[(0)] .1979 1.5047 .04561 -1 Mshowa
.27832 1.54696 m
.27866 1.53674 L
s
[(0.5)] .27763 1.56739 .03377 -1 Mshowa
.35414 1.60675 m
.35437 1.59653 L
s
[(1)] .35368 1.62718 .02267 -1 Mshowa
.125 Mabswid
.04565 1.36348 m
.04608 1.35737 L
s
.06336 1.37745 m
.06376 1.37133 L
s
.08089 1.39127 m
.08127 1.38515 L
s
.09824 1.40495 m
.09861 1.39883 L
s
.13243 1.43191 m
.13277 1.42579 L
s
.14928 1.4452 m
.1496 1.43907 L
s
.16596 1.45835 m
.16627 1.45223 L
s
.18247 1.47138 m
.18277 1.46525 L
s
.21504 1.49706 m
.2153 1.49093 L
s
.23108 1.50971 m
.23133 1.50358 L
s
.24698 1.52224 m
.24721 1.51612 L
s
.26272 1.53466 m
.26294 1.52853 L
s
.29377 1.55914 m
.29396 1.55301 L
s
.30907 1.57121 m
.30925 1.56508 L
s
.32423 1.58317 m
.3244 1.57704 L
s
.33925 1.59501 m
.33941 1.58888 L
s
.00971 1.33514 m
.01016 1.32902 L
s
.36889 1.61838 m
.36901 1.61225 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.44.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.44.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SurfaceOfRevolution[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "plot the surface of revolution obtained by rotating the curve from \
angle ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to angle ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.44.1"],

Cell["Surface of revolution of a curve over a reduced angle.", "Caption",
 CellTags->"S5.44.1"],

Cell[TextData[{
 "Here is the same curve rotated from ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.44.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
SurfaceOfRevolution[{1.1 Sin[u], u^2},
    {u, 0, 3 Pi/2}, {t, 0, Pi},
    BoxRatios -> {1, 1, 2}]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.44.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.62453 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.30443 1.63518 -0.0106411 1.63518 [
[.416 1.63528 -6.08278 0 ]
[.416 1.63528 5.91722 9 ]
[.54617 1.60349 -11.9435 0 ]
[.54617 1.60349 12.0565 9 ]
[.67967 1.57089 -2.92841 0 ]
[.67967 1.57089 3.07159 9 ]
[.81661 1.53744 -8.60673 0 ]
[.81661 1.53744 9.39327 9 ]
[.95713 1.5031 -2.80725 0 ]
[.95713 1.5031 3.19275 9 ]
[.02632 1.36978 -6.43104 0 ]
[.02632 1.36978 5.56896 9 ]
[.1143 1.43896 -12.6991 0 ]
[.1143 1.43896 11.3009 9 ]
[.19803 1.5048 -3.13678 0 ]
[.19803 1.5048 2.86322 9 ]
[.27781 1.56753 -9.3037 0 ]
[.27781 1.56753 8.6963 9 ]
[.3539 1.62736 -3.06792 0 ]
[.3539 1.62736 2.93208 9 ]
[.06357 .25073 -6 -2.74334 ]
[.06357 .25073 0 6.25666 ]
[.04766 .45754 -6 -2.83401 ]
[.04766 .45754 0 6.16599 ]
[.03054 .68008 -12 -2.9319 ]
[.03054 .68008 0 6.0681 ]
[.01208 .92021 -12 -3.03791 ]
[.01208 .92021 0 5.96209 ]
[-0.00791 1.18012 -12 -3.1531 ]
[-0.00791 1.18012 0 5.8469 ]
[ 0 0 0 0 ]
[ 1 1.62453 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.37669 1.62453 m
1 1.47188 L
s
.41628 1.61484 m
.41642 1.60462 L
s
[(-1)] .416 1.63528 .0138 -1 Mshowa
.54608 1.58305 m
.54603 1.57283 L
s
[(-0.5)] .54617 1.60349 -0.00471 -1 Mshowa
.67918 1.55045 m
.67894 1.54024 L
s
[(0)] .67967 1.57089 -0.02386 -1 Mshowa
.81572 1.51701 m
.81527 1.5068 L
s
[(0.5)] .81661 1.53744 -0.0437 -1 Mshowa
.95582 1.4827 m
.95517 1.4725 L
s
[(1)] .95713 1.5031 -0.06425 -1 Mshowa
.125 Mabswid
.44198 1.60855 m
.44204 1.60241 L
s
.46781 1.60222 m
.46785 1.59609 L
s
.49377 1.59586 m
.49378 1.58973 L
s
.51986 1.58947 m
.51985 1.58334 L
s
.57243 1.5766 m
.57238 1.57047 L
s
.59891 1.57011 m
.59884 1.56398 L
s
.62553 1.56359 m
.62543 1.55746 L
s
.65229 1.55704 m
.65217 1.55091 L
s
.70621 1.54383 m
.70604 1.5377 L
s
.73337 1.53718 m
.73318 1.53105 L
s
.76068 1.53049 m
.76046 1.52437 L
s
.78813 1.52377 m
.78789 1.51764 L
s
.84345 1.51022 m
.84316 1.5041 L
s
.87132 1.5034 m
.87101 1.49727 L
s
.89934 1.49653 m
.899 1.49041 L
s
.92751 1.48964 m
.92714 1.48352 L
s
.3907 1.6211 m
.39081 1.61497 L
s
.98428 1.47573 m
.98386 1.46961 L
s
.25 Mabswid
0 1.32748 m
.37669 1.62453 L
s
.02778 1.34939 m
.02852 1.3392 L
s
[(-1)] .02632 1.36978 .07184 -1 Mshowa
.11549 1.41856 m
.11609 1.40836 L
s
[(-0.5)] .1143 1.43896 .05826 -1 Mshowa
.19897 1.48438 m
.19943 1.47417 L
s
[(0)] .19803 1.5048 .04559 -1 Mshowa
.2785 1.5471 m
.27884 1.53689 L
s
[(0.5)] .27781 1.56753 .03374 -1 Mshowa
.35437 1.60693 m
.3546 1.59671 L
s
[(1)] .3539 1.62736 .02264 -1 Mshowa
.125 Mabswid
.04568 1.36351 m
.0461 1.35739 L
s
.0634 1.37748 m
.0638 1.37136 L
s
.08094 1.39131 m
.08133 1.38519 L
s
.0983 1.405 m
.09867 1.39888 L
s
.13252 1.43198 m
.13286 1.42586 L
s
.14937 1.44528 m
.1497 1.43915 L
s
.16607 1.45844 m
.16637 1.45231 L
s
.18259 1.47147 m
.18289 1.46535 L
s
.21518 1.49717 m
.21544 1.49104 L
s
.23124 1.50983 m
.23148 1.5037 L
s
.24714 1.52237 m
.24737 1.51624 L
s
.26289 1.5348 m
.26311 1.52867 L
s
.29396 1.55929 m
.29415 1.55316 L
s
.30927 1.57137 m
.30945 1.56524 L
s
.32444 1.58333 m
.32461 1.5772 L
s
.33947 1.59519 m
.33963 1.58906 L
s
.00971 1.33514 m
.01016 1.32902 L
s
.36912 1.61857 m
.36925 1.61244 L
s
.25 Mabswid
.0843 .2212 m
0 1.32748 L
s
.08261 .2433 m
.09213 .23959 L
s
[(0)] .06357 .25073 1 -0.39037 Mshowa
.06683 .45044 m
.07641 .4469 L
s
[(5)] .04766 .45754 1 -0.37022 Mshowa
.04984 .67335 m
.05949 .66999 L
s
[(10)] .03054 .68008 1 -0.34847 Mshowa
.03151 .9139 m
.04123 .91074 L
s
[(15)] .01208 .92021 1 -0.32491 Mshowa
.01168 1.17426 m
.02147 1.17133 L
s
[(20)] -0.00791 1.18012 1 -0.29931 Mshowa
.125 Mabswid
.07955 .28355 m
.08527 .28134 L
s
.07644 .32438 m
.08216 .32219 L
s
.07328 .36579 m
.07901 .36362 L
s
.07008 .40781 m
.07582 .40566 L
s
.06353 .49371 m
.06929 .4916 L
s
.06019 .53762 m
.06595 .53553 L
s
.05679 .58218 m
.06256 .58012 L
s
.05334 .62742 m
.05913 .62538 L
s
.04629 .71999 m
.05209 .71799 L
s
.04268 .76734 m
.04849 .76537 L
s
.03902 .81543 m
.04483 .81349 L
s
.0353 .86428 m
.04112 .86236 L
s
.02767 .96431 m
.03351 .96244 L
s
.02377 1.01553 m
.02962 1.01369 L
s
.0198 1.06758 m
.02566 1.06577 L
s
.01577 1.12049 m
.02164 1.1187 L
s
.00751 1.22893 m
.01339 1.2272 L
s
.00327 1.28451 m
.00917 1.28281 L
s
.25 Mabswid
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.37669 1.62453 L
s
.37669 1.62453 m
.3971 .57309 L
s
.3971 .57309 m
.0843 .2212 L
s
.64785 0 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.64785 0 m
.0843 .2212 L
s
.3971 .57309 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.37669 1.62453 L
s
.37669 1.62453 m
.3971 .57309 L
s
0 0 m
1 0 L
1 1.62453 L
0 1.62453 L
closepath
clip
newpath
.5 Mabswid
.714 .54 .653 r
.48537 .60262 m .48627 .57921 L .51596 .58008 L p F P
0 g
s
.714 .54 .653 r
.51596 .58008 m .51605 .60351 L .48537 .60262 L p F P
0 g
s
.714 .588 .713 r
.51581 .55421 m .51596 .58008 L .48627 .57921 L p F P
0 g
s
.694 .524 .653 r
.51605 .60351 m .51596 .58008 L .54563 .57891 L p F P
0 g
s
.698 .575 .713 r
.51596 .58008 m .51581 .55421 L .54375 .5531 L p F P
0 g
s
.698 .575 .713 r
.54375 .5531 m .54563 .57891 L .51596 .58008 L p F P
0 g
s
.714 .588 .713 r
.48627 .57921 m .48783 .55339 L .51581 .55421 L p F P
0 g
s
.711 .623 .758 r
.51559 .52605 m .51581 .55421 L .48783 .55339 L p F P
0 g
s
.698 .613 .758 r
.51581 .55421 m .51559 .52605 L .54112 .52503 L p F P
0 g
s
.698 .613 .758 r
.54112 .52503 m .54375 .5531 L .51581 .55421 L p F P
0 g
s
.733 .557 .653 r
.45497 .59965 m .45684 .57632 L .48627 .57921 L p F P
0 g
s
.733 .557 .653 r
.48627 .57921 m .48537 .60262 L .45497 .59965 L p F P
0 g
s
.729 .601 .714 r
.48783 .55339 m .48627 .57921 L .45684 .57632 L p F P
0 g
s
.694 .524 .653 r
.54563 .57891 m .54671 .60231 L .51605 .60351 L p F P
0 g
s
.673 .508 .654 r
.54671 .60231 m .54563 .57891 L .57497 .57572 L p F P
0 g
s
.682 .563 .714 r
.54563 .57891 m .54375 .5531 L .57139 .55007 L p F P
0 g
s
.682 .563 .714 r
.57139 .55007 m .57497 .57572 L .54563 .57891 L p F P
0 g
s
.729 .601 .714 r
.45684 .57632 m .46011 .55064 L .48783 .55339 L p F P
0 g
s
.723 .634 .758 r
.49003 .52529 m .48783 .55339 L .46011 .55064 L p F P
0 g
s
.711 .623 .758 r
.48783 .55339 m .49003 .52529 L .51559 .52605 L p F P
0 g
s
.685 .603 .759 r
.54375 .5531 m .54112 .52503 L .56636 .52224 L p F P
0 g
s
.685 .603 .759 r
.56636 .52224 m .57139 .55007 L .54375 .5531 L p F P
0 g
s
.752 .574 .654 r
.42514 .59462 m .42798 .57142 L .45684 .57632 L p F P
0 g
s
.752 .574 .654 r
.45684 .57632 m .45497 .59965 L .42514 .59462 L p F P
0 g
s
.745 .616 .715 r
.46011 .55064 m .45684 .57632 L .42798 .57142 L p F P
0 g
s
.745 .616 .715 r
.42798 .57142 m .43293 .546 L .46011 .55064 L p F P
0 g
s
.735 .645 .76 r
.46471 .52276 m .46011 .55064 L .43293 .546 L p F P
0 g
s
.723 .634 .758 r
.46011 .55064 m .46471 .52276 L .49003 .52529 L p F P
0 g
s
.673 .508 .654 r
.57497 .57572 m .57703 .59903 L .54671 .60231 L p F P
0 g
s
.652 .492 .654 r
.57703 .59903 m .57497 .57572 L .60369 .57053 L p F P
0 g
s
.665 .551 .716 r
.57497 .57572 m .57139 .55007 L .59844 .54515 L p F P
0 g
s
.665 .551 .716 r
.59844 .54515 m .60369 .57053 L .57497 .57572 L p F P
0 g
s
.672 .594 .76 r
.57139 .55007 m .56636 .52224 L .59106 .51771 L p F P
0 g
s
.672 .594 .76 r
.59106 .51771 m .59844 .54515 L .57139 .55007 L p F P
0 g
s
.706 .475 .571 r
.48516 .62357 m .48537 .60262 L .51605 .60351 L p F P
0 g
s
.706 .475 .571 r
.51605 .60351 m .51607 .62446 L .48516 .62357 L p F P
0 g
s
.682 .455 .571 r
.51607 .62446 m .51605 .60351 L .54671 .60231 L p F P
0 g
s
.73 .495 .571 r
.45452 .6206 m .45497 .59965 L .48537 .60262 L p F P
0 g
s
.73 .495 .571 r
.48537 .60262 m .48516 .62357 L .45452 .6206 L p F P
0 g
s
.682 .455 .571 r
.54671 .60231 m .54696 .62326 L .51607 .62446 L p F P
0 g
s
.656 .435 .571 r
.54696 .62326 m .54671 .60231 L .57703 .59903 L p F P
0 g
s
.706 .649 .791 r
.51531 .49584 m .51559 .52605 L .49003 .52529 L p F P
0 g
s
.696 .641 .791 r
.51559 .52605 m .51531 .49584 L .53777 .49493 L p F P
0 g
s
.696 .641 .791 r
.53777 .49493 m .54112 .52503 L .51559 .52605 L p F P
0 g
s
.715 .658 .792 r
.49282 .49516 m .49003 .52529 L .46471 .52276 L p F P
0 g
s
.706 .649 .791 r
.49003 .52529 m .49282 .49516 L .51531 .49584 L p F P
0 g
s
.685 .634 .792 r
.54112 .52503 m .53777 .49493 L .55998 .49246 L p F P
0 g
s
.685 .634 .792 r
.55998 .49246 m .56636 .52224 L .54112 .52503 L p F P
0 g
s
.771 .592 .655 r
.3962 .58758 m .39999 .56456 L .42798 .57142 L p F P
0 g
s
.771 .592 .655 r
.42798 .57142 m .42514 .59462 L .3962 .58758 L p F P
0 g
s
.76 .63 .717 r
.43293 .546 m .42798 .57142 L .39999 .56456 L p F P
0 g
s
.76 .63 .717 r
.39999 .56456 m .40657 .53949 L .43293 .546 L p F P
0 g
s
.747 .658 .762 r
.43989 .51849 m .43293 .546 L .40657 .53949 L p F P
0 g
s
.735 .645 .76 r
.43293 .546 m .43989 .51849 L .46471 .52276 L p F P
0 g
s
.754 .515 .57 r
.42447 .61556 m .42514 .59462 L .45497 .59965 L p F P
0 g
s
.754 .515 .57 r
.45497 .59965 m .45452 .6206 L .42447 .61556 L p F P
0 g
s
.652 .492 .654 r
.60369 .57053 m .60671 .5937 L .57703 .59903 L p F P
0 g
s
.629 .476 .656 r
.60671 .5937 m .60369 .57053 L .6315 .56338 L p F P
0 g
s
.647 .539 .718 r
.60369 .57053 m .59844 .54515 L .62462 .53837 L p F P
0 g
s
.647 .539 .718 r
.62462 .53837 m .6315 .56338 L .60369 .57053 L p F P
0 g
s
.656 .435 .571 r
.57703 .59903 m .57751 .61998 L .54696 .62326 L p F P
0 g
s
.629 .413 .57 r
.57751 .61998 m .57703 .59903 L .60671 .5937 L p F P
0 g
s
.658 .586 .763 r
.59844 .54515 m .59106 .51771 L .61496 .51147 L p F P
0 g
s
.658 .586 .763 r
.61496 .51147 m .62462 .53837 L .59844 .54515 L p F P
0 g
s
.725 .667 .793 r
.47054 .49292 m .46471 .52276 L .43989 .51849 L p F P
0 g
s
.715 .658 .792 r
.46471 .52276 m .47054 .49292 L .49282 .49516 L p F P
0 g
s
.675 .627 .793 r
.56636 .52224 m .55998 .49246 L .58171 .48844 L p F P
0 g
s
.675 .627 .793 r
.58171 .48844 m .59106 .51771 L .56636 .52224 L p F P
0 g
s
.778 .535 .569 r
.39531 .60851 m .3962 .58758 L .42514 .59462 L p F P
0 g
s
.778 .535 .569 r
.42514 .59462 m .42447 .61556 L .39531 .60851 L p F P
0 g
s
.747 .658 .762 r
.40657 .53949 m .41583 .5125 L .43989 .51849 L p F P
0 g
s
.734 .677 .795 r
.44871 .48913 m .43989 .51849 L .41583 .5125 L p F P
0 g
s
.725 .667 .793 r
.43989 .51849 m .44871 .48913 L .47054 .49292 L p F P
0 g
s
.629 .413 .57 r
.60671 .5937 m .60742 .61464 L .57751 .61998 L p F P
0 g
s
.6 .39 .569 r
.60742 .61464 m .60671 .5937 L .63545 .58637 L p F P
0 g
s
.629 .476 .656 r
.6315 .56338 m .63545 .58637 L .60671 .5937 L p F P
0 g
s
.664 .621 .796 r
.59106 .51771 m .58171 .48844 L .60271 .48291 L p F P
0 g
s
.664 .621 .796 r
.60271 .48291 m .61496 .51147 L .59106 .51771 L p F P
0 g
s
.775 .646 .72 r
.37314 .5558 m .3813 .53118 L .40657 .53949 L p F P
0 g
s
.775 .646 .72 r
.40657 .53949 m .39999 .56456 L .37314 .5558 L p F P
0 g
s
.758 .671 .765 r
.41583 .5125 m .40657 .53949 L .3813 .53118 L p F P
0 g
s
.791 .61 .657 r
.36845 .57858 m .37314 .5558 L .39999 .56456 L p F P
0 g
s
.791 .61 .657 r
.39999 .56456 m .3962 .58758 L .36845 .57858 L p F P
0 g
s
.687 .388 .463 r
.48564 .64213 m .48516 .62357 L .51607 .62446 L p F P
0 g
s
.687 .388 .463 r
.51607 .62446 m .51603 .643 L .48564 .64213 L p F P
0 g
s
.657 .364 .463 r
.51603 .643 m .51607 .62446 L .54696 .62326 L p F P
0 g
s
.629 .528 .721 r
.6315 .56338 m .62462 .53837 L .64966 .5298 L p F P
0 g
s
.644 .578 .766 r
.62462 .53837 m .61496 .51147 L .6378 .50359 L p F P
0 g
s
.644 .578 .766 r
.6378 .50359 m .64966 .5298 L .62462 .53837 L p F P
0 g
s
.605 .46 .657 r
.63545 .58637 m .6315 .56338 L .65811 .55435 L p F P
0 g
s
.629 .528 .721 r
.64966 .5298 m .65811 .55435 L .6315 .56338 L p F P
0 g
s
.716 .412 .461 r
.45554 .63922 m .45452 .6206 L .48516 .62357 L p F P
0 g
s
.716 .412 .461 r
.48516 .62357 m .48564 .64213 L .45554 .63922 L p F P
0 g
s
.657 .364 .463 r
.54696 .62326 m .54638 .64183 L .51603 .643 L p F P
0 g
s
.625 .337 .461 r
.54638 .64183 m .54696 .62326 L .57751 .61998 L p F P
0 g
s
.7 .67 .817 r
.51497 .46393 m .51531 .49584 L .49282 .49516 L p F P
0 g
s
.692 .663 .817 r
.51531 .49584 m .51497 .46393 L .53379 .46316 L p F P
0 g
s
.692 .663 .817 r
.53379 .46316 m .53777 .49493 L .51531 .49584 L p F P
0 g
s
.708 .676 .817 r
.49614 .46336 m .49282 .49516 L .47054 .49292 L p F P
0 g
s
.7 .67 .817 r
.49282 .49516 m .49614 .46336 L .51497 .46393 L p F P
0 g
s
.684 .658 .817 r
.53777 .49493 m .53379 .46316 L .55238 .46107 L p F P
0 g
s
.684 .658 .817 r
.55238 .46107 m .55998 .49246 L .53777 .49493 L p F P
0 g
s
.744 .434 .457 r
.42601 .6343 m .42447 .61556 L .45452 .6206 L p F P
0 g
s
.744 .434 .457 r
.45452 .6206 m .45554 .63922 L .42601 .6343 L p F P
0 g
s
.758 .671 .765 r
.3813 .53118 m .39277 .50486 L .41583 .5125 L p F P
0 g
s
.743 .687 .798 r
.42756 .48382 m .41583 .5125 L .39277 .50486 L p F P
0 g
s
.734 .677 .795 r
.41583 .5125 m .42756 .48382 L .44871 .48913 L p F P
0 g
s
.625 .337 .461 r
.57751 .61998 m .5764 .63862 L .54638 .64183 L p F P
0 g
s
.591 .309 .457 r
.5764 .63862 m .57751 .61998 L .60742 .61464 L p F P
0 g
s
.802 .556 .567 r
.36734 .5995 m .36845 .57858 L .3962 .58758 L p F P
0 g
s
.802 .556 .567 r
.3962 .58758 m .39531 .60851 L .36734 .5995 L p F P
0 g
s
.715 .683 .818 r
.47749 .46146 m .47054 .49292 L .44871 .48913 L p F P
0 g
s
.708 .676 .817 r
.47054 .49292 m .47749 .46146 L .49614 .46336 L p F P
0 g
s
.653 .615 .798 r
.61496 .51147 m .60271 .48291 L .62277 .47592 L p F P
0 g
s
.653 .615 .798 r
.62277 .47592 m .6378 .50359 L .61496 .51147 L p F P
0 g
s
.676 .652 .819 r
.55998 .49246 m .55238 .46107 L .57056 .45768 L p F P
0 g
s
.676 .652 .819 r
.57056 .45768 m .58171 .48844 L .55998 .49246 L p F P
0 g
s
.6 .39 .569 r
.63545 .58637 m .63638 .6073 L .60742 .61464 L p F P
0 g
s
.568 .366 .567 r
.63638 .6073 m .63545 .58637 L .66296 .57709 L p F P
0 g
s
.605 .46 .657 r
.65811 .55435 m .66296 .57709 L .63545 .58637 L p F P
0 g
s
.79 .663 .724 r
.34772 .54521 m .3574 .52114 L .3813 .53118 L p F P
0 g
s
.79 .663 .724 r
.3813 .53118 m .37314 .5558 L .34772 .54521 L p F P
0 g
s
.77 .684 .769 r
.39277 .50486 m .3813 .53118 L .3574 .52114 L p F P
0 g
s
.81 .63 .659 r
.34216 .56771 m .34772 .54521 L .37314 .5558 L p F P
0 g
s
.81 .63 .659 r
.37314 .5558 m .36845 .57858 L .34216 .56771 L p F P
0 g
s
.609 .517 .724 r
.65811 .55435 m .64966 .5298 L .67329 .51952 L p F P
0 g
s
.629 .57 .77 r
.64966 .5298 m .6378 .50359 L .65934 .49413 L p F P
0 g
s
.629 .57 .77 r
.65934 .49413 m .67329 .51952 L .64966 .5298 L p F P
0 g
s
.722 .691 .82 r
.45923 .45826 m .44871 .48913 L .42756 .48382 L p F P
0 g
s
.715 .683 .818 r
.44871 .48913 m .45923 .45826 L .47749 .46146 L p F P
0 g
s
.772 .456 .451 r
.39735 .62741 m .39531 .60851 L .42447 .61556 L p F P
0 g
s
.772 .456 .451 r
.42447 .61556 m .42601 .6343 L .39735 .62741 L p F P
0 g
s
.668 .648 .821 r
.58171 .48844 m .57056 .45768 L .58812 .45301 L p F P
0 g
s
.668 .648 .821 r
.58812 .45301 m .60271 .48291 L .58171 .48844 L p F P
0 g
s
.579 .443 .659 r
.66296 .57709 m .65811 .55435 L .68323 .54349 L p F P
0 g
s
.609 .517 .724 r
.67329 .51952 m .68323 .54349 L .65811 .55435 L p F P
0 g
s
.591 .309 .457 r
.60742 .61464 m .60579 .6334 L .5764 .63862 L p F P
0 g
s
.553 .276 .45 r
.60579 .6334 m .60742 .61464 L .63638 .6073 L p F P
0 g
s
.77 .684 .769 r
.3574 .52114 m .37098 .49563 L .39277 .50486 L p F P
0 g
s
.751 .698 .801 r
.40731 .47705 m .39277 .50486 L .37098 .49563 L p F P
0 g
s
.743 .687 .798 r
.39277 .50486 m .40731 .47705 L .42756 .48382 L p F P
0 g
s
.642 .61 .802 r
.6378 .50359 m .62277 .47592 L .64167 .46755 L p F P
0 g
s
.642 .61 .802 r
.64167 .46755 m .65934 .49413 L .6378 .50359 L p F P
0 g
s
.728 .699 .823 r
.44154 .45378 m .42756 .48382 L .40731 .47705 L p F P
0 g
s
.722 .691 .82 r
.42756 .48382 m .44154 .45378 L .45923 .45826 L p F P
0 g
s
.826 .579 .564 r
.34086 .5886 m .34216 .56771 L .36845 .57858 L p F P
0 g
s
.826 .579 .564 r
.36845 .57858 m .36734 .5995 L .34086 .5886 L p F P
0 g
s
.66 .644 .823 r
.60271 .48291 m .58812 .45301 L .60488 .44712 L p F P
0 g
s
.66 .644 .823 r
.60488 .44712 m .62277 .47592 L .60271 .48291 L p F P
0 g
s
.568 .366 .567 r
.66296 .57709 m .6641 .598 L .63638 .6073 L p F P
0 g
s
.532 .339 .564 r
.6641 .598 m .66296 .57709 L .68894 .56594 L p F P
0 g
s
.579 .443 .659 r
.68323 .54349 m .68894 .56594 L .66296 .57709 L p F P
0 g
s
.8 .477 .443 r
.36987 .6186 m .36734 .5995 L .39531 .60851 L p F P
0 g
s
.8 .477 .443 r
.39531 .60851 m .39735 .62741 L .36987 .6186 L p F P
0 g
s
.805 .681 .728 r
.32401 .53289 m .33511 .50947 L .3574 .52114 L p F P
0 g
s
.805 .681 .728 r
.3574 .52114 m .34772 .54521 L .32401 .53289 L p F P
0 g
s
.781 .699 .774 r
.37098 .49563 m .3574 .52114 L .33511 .50947 L p F P
0 g
s
.651 .28 .327 r
.48682 .65846 m .48564 .64213 L .51603 .643 L p F P
0 g
s
.651 .28 .327 r
.51603 .643 m .51591 .65929 L .48682 .65846 L p F P
0 g
s
.615 .25 .327 r
.51591 .65929 m .51603 .643 L .54638 .64183 L p F P
0 g
s
.553 .276 .45 r
.63638 .6073 m .63425 .62622 L .60579 .6334 L p F P
0 g
s
.509 .239 .441 r
.63425 .62622 m .63638 .6073 L .6641 .598 L p F P
0 g
s
.685 .306 .323 r
.458 .65569 m .45554 .63922 L .48564 .64213 L p F P
0 g
s
.685 .306 .323 r
.48564 .64213 m .48682 .65846 L .458 .65569 L p F P
0 g
s
.694 .686 .837 r
.51459 .43077 m .51497 .46393 L .49614 .46336 L p F P
0 g
s
.689 .681 .837 r
.51497 .46393 m .51459 .43077 L .52924 .43017 L p F P
0 g
s
.689 .681 .837 r
.52924 .43017 m .53379 .46316 L .51497 .46393 L p F P
0 g
s
.83 .652 .661 r
.31764 .55505 m .32401 .53289 L .34772 .54521 L p F P
0 g
s
.83 .652 .661 r
.34772 .54521 m .34216 .56771 L .31764 .55505 L p F P
0 g
s
.615 .25 .327 r
.54638 .64183 m .54497 .65818 L .51591 .65929 L p F P
0 g
s
.576 .217 .322 r
.54497 .65818 m .54638 .64183 L .5764 .63862 L p F P
0 g
s
.589 .506 .729 r
.68323 .54349 m .67329 .51952 L .69525 .5076 L p F P
0 g
s
.613 .564 .775 r
.67329 .51952 m .65934 .49413 L .67933 .48318 L p F P
0 g
s
.613 .564 .775 r
.67933 .48318 m .69525 .5076 L .67329 .51952 L p F P
0 g
s
.7 .691 .838 r
.49994 .43032 m .49614 .46336 L .47749 .46146 L p F P
0 g
s
.694 .686 .837 r
.49614 .46336 m .49994 .43032 L .51459 .43077 L p F P
0 g
s
.683 .677 .838 r
.53379 .46316 m .52924 .43017 L .54371 .42853 L p F P
0 g
s
.683 .677 .838 r
.54371 .42853 m .55238 .46107 L .53379 .46316 L p F P
0 g
s
.551 .425 .662 r
.68894 .56594 m .68323 .54349 L .70659 .53092 L p F P
0 g
s
.589 .506 .729 r
.69525 .5076 m .70659 .53092 L .68323 .54349 L p F P
0 g
s
.751 .698 .801 r
.37098 .49563 m .38818 .46887 L .40731 .47705 L p F P
0 g
s
.735 .708 .826 r
.42461 .44807 m .40731 .47705 L .38818 .46887 L p F P
0 g
s
.728 .699 .823 r
.40731 .47705 m .42461 .44807 L .44154 .45378 L p F P
0 g
s
.781 .699 .774 r
.33511 .50947 m .35068 .48489 L .37098 .49563 L p F P
0 g
s
.759 .71 .806 r
.38818 .46887 m .37098 .49563 L .35068 .48489 L p F P
0 g
s
.705 .696 .839 r
.48542 .42884 m .47749 .46146 L .45923 .45826 L p F P
0 g
s
.7 .691 .838 r
.47749 .46146 m .48542 .42884 L .49994 .43032 L p F P
0 g
s
.716 .329 .315 r
.42973 .651 m .42601 .6343 L .45554 .63922 L p F P
0 g
s
.716 .329 .315 r
.45554 .63922 m .458 .65569 L .42973 .651 L p F P
0 g
s
.677 .673 .839 r
.55238 .46107 m .54371 .42853 L .55785 .42587 L p F P
0 g
s
.677 .673 .839 r
.55785 .42587 m .57056 .45768 L .55238 .46107 L p F P
0 g
s
.651 .64 .826 r
.62277 .47592 m .60488 .44712 L .62065 .44006 L p F P
0 g
s
.651 .64 .826 r
.62065 .44006 m .64167 .46755 L .62277 .47592 L p F P
0 g
s
.576 .217 .322 r
.5764 .63862 m .57371 .65512 L .54497 .65818 L p F P
0 g
s
.533 .179 .313 r
.57371 .65512 m .5764 .63862 L .60579 .6334 L p F P
0 g
s
.63 .606 .807 r
.65934 .49413 m .64167 .46755 L .65919 .45786 L p F P
0 g
s
.63 .606 .807 r
.65919 .45786 m .67933 .48318 L .65934 .49413 L p F P
0 g
s
.711 .702 .84 r
.47121 .42632 m .45923 .45826 L .44154 .45378 L p F P
0 g
s
.705 .696 .839 r
.45923 .45826 m .47121 .42632 L .48542 .42884 L p F P
0 g
s
.67 .67 .84 r
.57056 .45768 m .55785 .42587 L .5715 .4222 L p F P
0 g
s
.67 .67 .84 r
.5715 .4222 m .58812 .45301 L .57056 .45768 L p F P
0 g
s
.852 .602 .561 r
.31614 .57592 m .31764 .55505 L .34216 .56771 L p F P
0 g
s
.852 .602 .561 r
.34216 .56771 m .34086 .5886 L .31614 .57592 L p F P
0 g
s
.829 .499 .43 r
.34385 .60795 m .34086 .5886 L .36734 .5995 L p F P
0 g
s
.829 .499 .43 r
.36734 .5995 m .36987 .6186 L .34385 .60795 L p F P
0 g
s
.747 .35 .301 r
.40231 .64444 m .39735 .62741 L .42601 .6343 L p F P
0 g
s
.747 .35 .301 r
.42601 .6343 m .42973 .651 L .40231 .64444 L p F P
0 g
s
.532 .339 .564 r
.68894 .56594 m .69028 .58684 L .6641 .598 L p F P
0 g
s
.491 .308 .56 r
.69028 .58684 m .68894 .56594 L .71311 .55303 L p F P
0 g
s
.551 .425 .662 r
.70659 .53092 m .71311 .55303 L .68894 .56594 L p F P
0 g
s
.509 .239 .441 r
.6641 .598 m .66148 .61714 L .63425 .62622 L p F P
0 g
s
.459 .197 .428 r
.66148 .61714 m .6641 .598 L .69028 .58684 L p F P
0 g
s
.533 .179 .313 r
.60579 .6334 m .60185 .65015 L .57371 .65512 L p F P
0 g
s
.483 .134 .298 r
.60185 .65015 m .60579 .6334 L .63425 .62622 L p F P
0 g
s
.715 .708 .842 r
.45746 .42281 m .44154 .45378 L .42461 .44807 L p F P
0 g
s
.711 .702 .84 r
.44154 .45378 m .45746 .42281 L .47121 .42632 L p F P
0 g
s
.759 .71 .806 r
.35068 .48489 m .37039 .45937 L .38818 .46887 L p F P
0 g
s
.74 .717 .829 r
.40865 .44117 m .38818 .46887 L .37039 .45937 L p F P
0 g
s
.735 .708 .826 r
.38818 .46887 m .40865 .44117 L .42461 .44807 L p F P
0 g
s
.82 .701 .733 r
.30228 .51894 m .3147 .49625 L .33511 .50947 L p F P
0 g
s
.82 .701 .733 r
.33511 .50947 m .32401 .53289 L .30228 .51894 L p F P
0 g
s
.791 .715 .779 r
.35068 .48489 m .33511 .50947 L .3147 .49625 L p F P
0 g
s
.664 .667 .842 r
.58812 .45301 m .5715 .4222 L .58451 .41758 L p F P
0 g
s
.664 .667 .842 r
.58451 .41758 m .60488 .44712 L .58812 .45301 L p F P
0 g
s
.642 .637 .83 r
.64167 .46755 m .62065 .44006 L .63525 .4319 L p F P
0 g
s
.642 .637 .83 r
.63525 .4319 m .65919 .45786 L .64167 .46755 L p F P
0 g
s
.566 .495 .735 r
.70659 .53092 m .69525 .5076 L .71529 .49418 L p F P
0 g
s
.597 .557 .781 r
.69525 .5076 m .67933 .48318 L .69756 .47085 L p F P
0 g
s
.597 .557 .781 r
.69756 .47085 m .71529 .49418 L .69525 .5076 L p F P
0 g
s
.851 .675 .664 r
.29514 .54072 m .30228 .51894 L .32401 .53289 L p F P
0 g
s
.851 .675 .664 r
.32401 .53289 m .31764 .55505 L .29514 .54072 L p F P
0 g
s
.791 .715 .779 r
.3147 .49625 m .33211 .47276 L .35068 .48489 L p F P
0 g
s
.767 .722 .811 r
.37039 .45937 m .35068 .48489 L .33211 .47276 L p F P
0 g
s
.519 .405 .664 r
.71311 .55303 m .70659 .53092 L .72793 .51675 L p F P
0 g
s
.566 .495 .735 r
.71529 .49418 m .72793 .51675 L .70659 .53092 L p F P
0 g
s
.618 .602 .812 r
.67933 .48318 m .65919 .45786 L .67514 .44695 L p F P
0 g
s
.618 .602 .812 r
.67514 .44695 m .69756 .47085 L .67933 .48318 L p F P
0 g
s
.776 .369 .281 r
.37601 .63605 m .36987 .6186 L .39735 .62741 L p F P
0 g
s
.776 .369 .281 r
.39735 .62741 m .40231 .64444 L .37601 .63605 L p F P
0 g
s
.72 .714 .845 r
.44432 .41833 m .42461 .44807 L .40865 .44117 L p F P
0 g
s
.715 .708 .842 r
.42461 .44807 m .44432 .41833 L .45746 .42281 L p F P
0 g
s
.483 .134 .298 r
.63425 .62622 m .62908 .64331 L .60185 .65015 L p F P
0 g
s
.424 .081 .277 r
.62908 .64331 m .63425 .62622 L .66148 .61714 L p F P
0 g
s
.658 .664 .845 r
.60488 .44712 m .58451 .41758 L .59674 .41205 L p F P
0 g
s
.658 .664 .845 r
.59674 .41205 m .62065 .44006 L .60488 .44712 L p F P
0 g
s
.857 .52 .413 r
.31958 .59556 m .31614 .57592 L .34086 .5886 L p F P
0 g
s
.857 .52 .413 r
.34086 .5886 m .34385 .60795 L .31958 .59556 L p F P
0 g
s
.878 .628 .555 r
.29346 .56157 m .29514 .54072 L .31764 .55505 L p F P
0 g
s
.878 .628 .555 r
.31764 .55505 m .31614 .57592 L .29346 .56157 L p F P
0 g
s
.767 .722 .811 r
.33211 .47276 m .35414 .44864 L .37039 .45937 L p F P
0 g
s
.746 .726 .834 r
.39382 .43317 m .37039 .45937 L .35414 .44864 L p F P
0 g
s
.74 .717 .829 r
.37039 .45937 m .39382 .43317 L .40865 .44117 L p F P
0 g
s
.459 .197 .428 r
.69028 .58684 m .6872 .60623 L .66148 .61714 L p F P
0 g
s
.399 .146 .41 r
.6872 .60623 m .69028 .58684 L .71464 .5739 L p F P
0 g
s
.491 .308 .56 r
.71311 .55303 m .71464 .5739 L .69028 .58684 L p F P
0 g
s
.689 .699 .855 r
.51418 .39693 m .51459 .43077 L .49994 .43032 L p F P
0 g
s
.685 .696 .855 r
.51459 .43077 m .51418 .39693 L .52423 .39651 L p F P
0 g
s
.685 .696 .855 r
.52423 .39651 m .52924 .43017 L .51459 .43077 L p F P
0 g
s
.633 .635 .835 r
.65919 .45786 m .63525 .4319 L .64852 .42272 L p F P
0 g
s
.633 .635 .835 r
.64852 .42272 m .67514 .44695 L .65919 .45786 L p F P
0 g
s
.693 .703 .855 r
.50412 .39662 m .49994 .43032 L .48542 .42884 L p F P
0 g
s
.689 .699 .855 r
.49994 .43032 m .50412 .39662 L .51418 .39693 L p F P
0 g
s
.443 .273 .554 r
.71464 .5739 m .71311 .55303 L .7352 .53847 L p F P
0 g
s
.519 .405 .664 r
.72793 .51675 m .7352 .53847 L .71311 .55303 L p F P
0 g
s
.68 .693 .855 r
.52924 .43017 m .52423 .39651 L .53415 .39538 L p F P
0 g
s
.68 .693 .855 r
.53415 .39538 m .54371 .42853 L .52924 .43017 L p F P
0 g
s
.724 .721 .847 r
.43194 .41292 m .40865 .44117 L .39382 .43317 L p F P
0 g
s
.72 .714 .845 r
.40865 .44117 m .43194 .41292 L .44432 .41833 L p F P
0 g
s
.597 .157 .174 r
.48867 .67283 m .48682 .65846 L .51591 .65929 L p F P
0 g
s
.597 .157 .174 r
.51591 .65929 m .51572 .6736 L .48867 .67283 L p F P
0 g
s
.556 .123 .174 r
.51572 .6736 m .51591 .65929 L .54497 .65818 L p F P
0 g
s
.696 .707 .856 r
.49416 .39559 m .48542 .42884 L .47121 .42632 L p F P
0 g
s
.693 .703 .855 r
.48542 .42884 m .49416 .39559 L .50412 .39662 L p F P
0 g
s
.676 .69 .856 r
.54371 .42853 m .53415 .39538 L .54385 .39353 L p F P
0 g
s
.676 .69 .856 r
.54385 .39353 m .55785 .42587 L .54371 .42853 L p F P
0 g
s
.634 .185 .168 r
.46187 .67026 m .458 .65569 L .48682 .65846 L p F P
0 g
s
.634 .185 .168 r
.48682 .65846 m .48867 .67283 L .46187 .67026 L p F P
0 g
s
.651 .663 .848 r
.62065 .44006 m .59674 .41205 L .60805 .40566 L p F P
0 g
s
.651 .663 .848 r
.60805 .40566 m .63525 .4319 L .62065 .44006 L p F P
0 g
s
.835 .722 .74 r
.28277 .5035 m .29639 .48164 L .3147 .49625 L p F P
0 g
s
.835 .722 .74 r
.3147 .49625 m .30228 .51894 L .28277 .5035 L p F P
0 g
s
.802 .731 .786 r
.33211 .47276 m .3147 .49625 L .29639 .48164 L p F P
0 g
s
.556 .123 .174 r
.54497 .65818 m .54275 .67256 L .51572 .6736 L p F P
0 g
s
.509 .083 .166 r
.54275 .67256 m .54497 .65818 L .57371 .65512 L p F P
0 g
s
.803 .385 .253 r
.35113 .62591 m .34385 .60795 L .36987 .6186 L p F P
0 g
s
.803 .385 .253 r
.36987 .6186 m .37601 .63605 L .35113 .62591 L p F P
0 g
s
.802 .731 .786 r
.29639 .48164 m .31548 .45934 L .33211 .47276 L p F P
0 g
s
.774 .735 .817 r
.35414 .44864 m .33211 .47276 L .31548 .45934 L p F P
0 g
s
.7 .711 .857 r
.48441 .39385 m .47121 .42632 L .45746 .42281 L p F P
0 g
s
.696 .707 .856 r
.47121 .42632 m .48441 .39385 L .49416 .39559 L p F P
0 g
s
.424 .081 .277 r
.66148 .61714 m .65513 .63465 L .62908 .64331 L p F P
0 g
s
.354 .017 .247 r
.65513 .63465 m .66148 .61714 L .6872 .60623 L p F P
0 g
s
.542 .485 .741 r
.72793 .51675 m .71529 .49418 L .73318 .47936 L p F P
0 g
s
.58 .552 .787 r
.71529 .49418 m .69756 .47085 L .71382 .45726 L p F P
0 g
s
.58 .552 .787 r
.71382 .45726 m .73318 .47936 L .71529 .49418 L p F P
0 g
s
.672 .688 .857 r
.55785 .42587 m .54385 .39353 L .5532 .391 L p F P
0 g
s
.672 .688 .857 r
.5532 .391 m .5715 .4222 L .55785 .42587 L p F P
0 g
s
.667 .208 .153 r
.43559 .66592 m .42973 .651 L .458 .65569 L p F P
0 g
s
.667 .208 .153 r
.458 .65569 m .46187 .67026 L .43559 .66592 L p F P
0 g
s
.872 .701 .667 r
.27494 .52485 m .28277 .5035 L .30228 .51894 L p F P
0 g
s
.872 .701 .667 r
.30228 .51894 m .29514 .54072 L .27494 .52485 L p F P
0 g
s
.606 .599 .818 r
.69756 .47085 m .67514 .44695 L .68934 .43494 L p F P
0 g
s
.606 .599 .818 r
.68934 .43494 m .71382 .45726 L .69756 .47085 L p F P
0 g
s
.509 .083 .166 r
.57371 .65512 m .56948 .66973 L .54275 .67256 L p F P
0 g
s
.456 .034 .15 r
.56948 .66973 m .57371 .65512 L .60185 .65015 L p F P
0 g
s
.703 .715 .858 r
.47499 .39142 m .45746 .42281 L .44432 .41833 L p F P
0 g
s
.7 .711 .857 r
.45746 .42281 m .47499 .39142 L .48441 .39385 L p F P
0 g
s
.482 .384 .667 r
.7352 .53847 m .72793 .51675 L .747 .5011 L p F P
0 g
s
.542 .485 .741 r
.73318 .47936 m .747 .5011 L .72793 .51675 L p F P
0 g
s
.667 .686 .858 r
.5715 .4222 m .5532 .391 L .56211 .38781 L p F P
0 g
s
.667 .686 .858 r
.56211 .38781 m .58451 .41758 L .5715 .4222 L p F P
0 g
s
.774 .735 .817 r
.31548 .45934 m .3396 .43678 L .35414 .44864 L p F P
0 g
s
.75 .736 .839 r
.38029 .42414 m .35414 .44864 L .3396 .43678 L p F P
0 g
s
.746 .726 .834 r
.35414 .44864 m .38029 .42414 L .39382 .43317 L p F P
0 g
s
.727 .728 .851 r
.42045 .40666 m .39382 .43317 L .38029 .42414 L p F P
0 g
s
.724 .721 .847 r
.39382 .43317 m .42045 .40666 L .43194 .41292 L p F P
0 g
s
.886 .542 .39 r
.29731 .58153 m .29346 .56157 L .31614 .57592 L p F P
0 g
s
.886 .542 .39 r
.31614 .57592 m .31958 .59556 L .29731 .58153 L p F P
0 g
s
.696 .226 .13 r
.41011 .65984 m .40231 .64444 L .42973 .651 L p F P
0 g
s
.696 .226 .13 r
.42973 .651 m .43559 .66592 L .41011 .65984 L p F P
0 g
s
.645 .661 .851 r
.63525 .4319 m .60805 .40566 L .6183 .39849 L p F P
0 g
s
.645 .661 .851 r
.6183 .39849 m .64852 .42272 L .63525 .4319 L p F P
0 g
s
.624 .634 .84 r
.67514 .44695 m .64852 .42272 L .66031 .41262 L p F P
0 g
s
.624 .634 .84 r
.66031 .41262 m .68934 .43494 L .67514 .44695 L p F P
0 g
s
.456 .034 .15 r
.60185 .65015 m .59563 .66513 L .56948 .66973 L p F P
0 g
s
.393 0 .125 r
.59563 .66513 m .60185 .65015 L .62908 .64331 L p F P
0 g
s
.706 .719 .86 r
.46599 .38832 m .44432 .41833 L .43194 .41292 L p F P
0 g
s
.703 .715 .858 r
.44432 .41833 m .46599 .38832 L .47499 .39142 L p F P
0 g
s
.399 .146 .41 r
.71464 .5739 m .71113 .59359 L .6872 .60623 L p F P
0 g
s
.326 .084 .385 r
.71113 .59359 m .71464 .5739 L .73691 .55931 L p F P
0 g
s
.443 .273 .554 r
.7352 .53847 m .73691 .55931 L .71464 .5739 L p F P
0 g
s
.663 .685 .86 r
.58451 .41758 m .56211 .38781 L .57046 .38398 L p F P
0 g
s
.663 .685 .86 r
.57046 .38398 m .59674 .41205 L .58451 .41758 L p F P
0 g
s
.906 .655 .548 r
.2731 .54567 m .27494 .52485 L .29514 .54072 L p F P
0 g
s
.906 .655 .548 r
.29514 .54072 m .29346 .56157 L .2731 .54567 L p F P
0 g
s
.828 .397 .214 r
.32792 .61411 m .31958 .59556 L .34385 .60795 L p F P
0 g
s
.828 .397 .214 r
.34385 .60795 m .35113 .62591 L .32792 .61411 L p F P
0 g
s
.386 .232 .546 r
.73691 .55931 m .7352 .53847 L .75495 .52238 L p F P
0 g
s
.482 .384 .667 r
.747 .5011 m .75495 .52238 L .7352 .53847 L p F P
0 g
s
.354 .017 .247 r
.6872 .60623 m .67973 .62426 L .65513 .63465 L p F P
0 g
s
.268 0 .206 r
.67973 .62426 m .6872 .60623 L .71113 .59359 L p F P
0 g
s
.722 .239 .097 r
.38569 .65208 m .37601 .63605 L .40231 .64444 L p F P
0 g
s
.722 .239 .097 r
.40231 .64444 m .41011 .65984 L .38569 .65208 L p F P
0 g
s
.85 .745 .747 r
.26573 .48671 m .28042 .46575 L .29639 .48164 L p F P
0 g
s
.85 .745 .747 r
.29639 .48164 m .28277 .5035 L .26573 .48671 L p F P
0 g
s
.811 .749 .794 r
.31548 .45934 m .29639 .48164 L .28042 .46575 L p F P
0 g
s
.811 .749 .794 r
.28042 .46575 m .30099 .44477 L .31548 .45934 L p F P
0 g
s
.78 .748 .824 r
.3396 .43678 m .31548 .45934 L .30099 .44477 L p F P
0 g
s
.709 .724 .862 r
.45753 .38459 m .43194 .41292 L .42045 .40666 L p F P
0 g
s
.706 .719 .86 r
.43194 .41292 m .45753 .38459 L .46599 .38832 L p F P
0 g
s
.75 .736 .839 r
.3396 .43678 m .36823 .41417 L .38029 .42414 L p F P
0 g
s
.73 .735 .855 r
.41 .39959 m .38029 .42414 L .36823 .41417 L p F P
0 g
s
.727 .728 .851 r
.38029 .42414 m .41 .39959 L .42045 .40666 L p F P
0 g
s
.658 .683 .862 r
.59674 .41205 m .57046 .38398 L .57818 .37958 L p F P
0 g
s
.658 .683 .862 r
.57818 .37958 m .60805 .40566 L .59674 .41205 L p F P
0 g
s
.393 0 .125 r
.62908 .64331 m .62093 .6588 L .59563 .66513 L p F P
0 g
s
.317 0 .089 r
.62093 .6588 m .62908 .64331 L .65513 .63465 L p F P
0 g
s
.562 .547 .795 r
.73318 .47936 m .71382 .45726 L .72789 .44253 L p F P
0 g
s
.593 .597 .825 r
.71382 .45726 m .68934 .43494 L .7016 .42193 L p F P
0 g
s
.593 .597 .825 r
.7016 .42193 m .72789 .44253 L .71382 .45726 L p F P
0 g
s
.515 .474 .749 r
.747 .5011 m .73318 .47936 L .7487 .4633 L p F P
0 g
s
.562 .547 .795 r
.72789 .44253 m .7487 .4633 L .73318 .47936 L p F P
0 g
s
.638 .661 .855 r
.64852 .42272 m .6183 .39849 L .62738 .3906 L p F P
0 g
s
.638 .661 .855 r
.62738 .3906 m .66031 .41262 L .64852 .42272 L p F P
0 g
s
.78 .748 .824 r
.30099 .44477 m .32698 .42391 L .3396 .43678 L p F P
0 g
s
.754 .745 .844 r
.36823 .41417 m .3396 .43678 L .32698 .42391 L p F P
0 g
s
.894 .729 .67 r
.25728 .50759 m .26573 .48671 L .28277 .5035 L p F P
0 g
s
.894 .729 .67 r
.28277 .5035 m .27494 .52485 L .25728 .50759 L p F P
0 g
s
.615 .633 .845 r
.68934 .43494 m .66031 .41262 L .67046 .4017 L p F P
0 g
s
.615 .633 .845 r
.67046 .4017 m .7016 .42193 L .68934 .43494 L p F P
0 g
s
.441 .361 .671 r
.75495 .52238 m .747 .5011 L .76357 .48413 L p F P
0 g
s
.515 .474 .749 r
.7487 .4633 m .76357 .48413 L .747 .5011 L p F P
0 g
s
.711 .729 .864 r
.44969 .38026 m .42045 .40666 L .41 .39959 L p F P
0 g
s
.709 .724 .862 r
.42045 .40666 m .44969 .38026 L .45753 .38459 L p F P
0 g
s
.654 .683 .865 r
.60805 .40566 m .57818 .37958 L .58515 .37463 L p F P
0 g
s
.654 .683 .865 r
.58515 .37463 m .6183 .39849 L .60805 .40566 L p F P
0 g
s
.683 .711 .87 r
.51373 .36306 m .51418 .39693 L .50412 .39662 L p F P
0 g
s
.68 .709 .87 r
.51418 .39693 m .51373 .36306 L .51886 .36284 L p F P
0 g
s
.68 .709 .87 r
.51886 .36284 m .52423 .39651 L .51418 .39693 L p F P
0 g
s
.914 .562 .357 r
.27732 .566 m .2731 .54567 L .29346 .56157 L p F P
0 g
s
.914 .562 .357 r
.29346 .56157 m .29731 .58153 L .27732 .566 L p F P
0 g
s
.685 .713 .87 r
.50859 .3629 m .50412 .39662 L .49416 .39559 L p F P
0 g
s
.683 .711 .87 r
.50412 .39662 m .50859 .3629 L .51373 .36306 L p F P
0 g
s
.678 .707 .87 r
.52423 .39651 m .51886 .36284 L .52393 .36226 L p F P
0 g
s
.678 .707 .87 r
.52393 .36226 m .53415 .39538 L .52423 .39651 L p F P
0 g
s
.742 .245 .05 r
.36259 .6427 m .35113 .62591 L .37601 .63605 L p F P
0 g
s
.742 .245 .05 r
.37601 .63605 m .38569 .65208 L .36259 .6427 L p F P
0 g
s
.687 .716 .871 r
.50351 .36237 m .49416 .39559 L .48441 .39385 L p F P
0 g
s
.685 .713 .87 r
.49416 .39559 m .50351 .36237 L .50859 .3629 L p F P
0 g
s
.675 .706 .871 r
.53415 .39538 m .52393 .36226 L .52887 .36131 L p F P
0 g
s
.675 .706 .871 r
.52887 .36131 m .54385 .39353 L .53415 .39538 L p F P
0 g
s
.848 .404 .161 r
.30666 .60076 m .29731 .58153 L .31958 .59556 L p F P
0 g
s
.848 .404 .161 r
.31958 .59556 m .32792 .61411 L .30666 .60076 L p F P
0 g
s
.326 .084 .385 r
.73691 .55931 m .73299 .57933 L .71113 .59359 L p F P
0 g
s
.234 .006 .35 r
.73299 .57933 m .73691 .55931 L .75682 .54319 L p F P
0 g
s
.386 .232 .546 r
.75495 .52238 m .75682 .54319 L .73691 .55931 L p F P
0 g
s
.317 0 .089 r
.65513 .63465 m .64513 .65079 L .62093 .6588 L p F P
0 g
s
.225 0 .04 r
.64513 .65079 m .65513 .63465 L .67973 .62426 L p F P
0 g
s
.689 .718 .871 r
.49854 .36147 m .48441 .39385 L .47499 .39142 L p F P
0 g
s
.687 .716 .871 r
.48441 .39385 m .49854 .36147 L .50351 .36237 L p F P
0 g
s
.754 .745 .844 r
.32698 .42391 m .35777 .40337 L .36823 .41417 L p F P
0 g
s
.733 .742 .859 r
.40069 .39181 m .36823 .41417 L .35777 .40337 L p F P
0 g
s
.73 .735 .855 r
.36823 .41417 m .40069 .39181 L .41 .39959 L p F P
0 g
s
.672 .704 .871 r
.54385 .39353 m .52887 .36131 L .53364 .36001 L p F P
0 g
s
.672 .704 .871 r
.53364 .36001 m .5532 .391 L .54385 .39353 L p F P
0 g
s
.934 .685 .536 r
.25529 .52837 m .25728 .50759 L .27494 .52485 L p F P
0 g
s
.934 .685 .536 r
.27494 .52485 m .2731 .54567 L .25529 .52837 L p F P
0 g
s
.268 0 .206 r
.71113 .59359 m .70259 .61223 L .67973 .62426 L p F P
0 g
s
.16 0 .15 r
.70259 .61223 m .71113 .59359 L .73299 .57933 L p F P
0 g
s
.632 .661 .86 r
.66031 .41262 m .62738 .3906 L .63518 .38208 L p F P
0 g
s
.632 .661 .86 r
.63518 .38208 m .67046 .4017 L .66031 .41262 L p F P
0 g
s
.691 .721 .872 r
.49374 .36022 m .47499 .39142 L .46599 .38832 L p F P
0 g
s
.689 .718 .871 r
.47499 .39142 m .49374 .36022 L .49854 .36147 L p F P
0 g
s
.67 .703 .872 r
.5532 .391 m .53364 .36001 L .53817 .35836 L p F P
0 g
s
.67 .703 .872 r
.53817 .35836 m .56211 .38781 L .5532 .391 L p F P
0 g
s
.713 .734 .867 r
.44257 .37539 m .41 .39959 L .40069 .39181 L p F P
0 g
s
.711 .729 .864 r
.41 .39959 m .44257 .37539 L .44969 .38026 L p F P
0 g
s
.316 .181 .534 r
.75682 .54319 m .75495 .52238 L .77212 .50493 L p F P
0 g
s
.441 .361 .671 r
.76357 .48413 m .77212 .50493 L .75495 .52238 L p F P
0 g
s
.65 .683 .868 r
.6183 .39849 m .58515 .37463 L .59132 .3692 L p F P
0 g
s
.65 .683 .868 r
.59132 .3692 m .62738 .3906 L .6183 .39849 L p F P
0 g
s
.531 .036 .025 r
.49118 .68559 m .48867 .67283 L .51572 .6736 L p F P
0 g
s
.531 .036 .025 r
.51572 .6736 m .51547 .68628 L .49118 .68559 L p F P
0 g
s
.486 0 .024 r
.51547 .68628 m .51572 .6736 L .54275 .67256 L p F P
0 g
s
.57 .065 .016 r
.4671 .6833 m .46187 .67026 L .48867 .67283 L p F P
0 g
s
.57 .065 .016 r
.48867 .67283 m .49118 .68559 L .4671 .6833 L p F P
0 g
s
.486 0 .024 r
.54275 .67256 m .53975 .68535 L .51547 .68628 L p F P
0 g
s
.433 0 .013 r
.53975 .68535 m .54275 .67256 L .56948 .66973 L p F P
0 g
s
.693 .723 .873 r
.48916 .35863 m .46599 .38832 L .45753 .38459 L p F P
0 g
s
.691 .721 .872 r
.46599 .38832 m .48916 .35863 L .49374 .36022 L p F P
0 g
s
.667 .702 .873 r
.56211 .38781 m .53817 .35836 L .54242 .3564 L p F P
0 g
s
.667 .702 .873 r
.54242 .3564 m .57046 .38398 L .56211 .38781 L p F P
0 g
s
.543 .543 .805 r
.7487 .4633 m .72789 .44253 L .7396 .42681 L p F P
0 g
s
.58 .596 .833 r
.72789 .44253 m .7016 .42193 L .71177 .40807 L p F P
0 g
s
.58 .596 .833 r
.71177 .40807 m .7396 .42681 L .72789 .44253 L p F P
0 g
s
.602 .087 0 r
.44351 .67941 m .43559 .66592 L .46187 .67026 L p F P
0 g
s
.602 .087 0 r
.46187 .67026 m .4671 .6833 L .44351 .67941 L p F P
0 g
s
.486 .463 .758 r
.76357 .48413 m .7487 .4633 L .76165 .44615 L p F P
0 g
s
.543 .543 .805 r
.7396 .42681 m .76165 .44615 L .7487 .4633 L p F P
0 g
s
.607 .633 .852 r
.7016 .42193 m .67046 .4017 L .67884 .39008 L p F P
0 g
s
.607 .633 .852 r
.67884 .39008 m .71177 .40807 L .7016 .42193 L p F P
0 g
s
.433 0 .013 r
.56948 .66973 m .56375 .68282 L .53975 .68535 L p F P
0 g
s
.371 0 0 r
.56375 .68282 m .56948 .66973 L .59563 .66513 L p F P
0 g
s
.753 .242 0 r
.34106 .63179 m .32792 .61411 L .35113 .62591 L p F P
0 g
s
.753 .242 0 r
.35113 .62591 m .36259 .6427 L .34106 .63179 L p F P
0 g
s
.694 .726 .874 r
.48485 .35671 m .45753 .38459 L .44969 .38026 L p F P
0 g
s
.693 .723 .873 r
.45753 .38459 m .48485 .35671 L .48916 .35863 L p F P
0 g
s
.664 .702 .875 r
.57046 .38398 m .54242 .3564 L .54633 .35414 L p F P
0 g
s
.664 .702 .875 r
.54633 .35414 m .57818 .37958 L .57046 .38398 L p F P
0 g
s
.733 .742 .859 r
.35777 .40337 m .39265 .38337 L .40069 .39181 L p F P
0 g
s
.714 .738 .87 r
.43626 .37003 m .40069 .39181 L .39265 .38337 L p F P
0 g
s
.713 .734 .867 r
.40069 .39181 m .43626 .37003 L .44257 .37539 L p F P
0 g
s
.225 0 .04 r
.67973 .62426 m .66796 .64118 L .64513 .65079 L p F P
0 g
s
.111 0 0 r
.66796 .64118 m .67973 .62426 L .70259 .61223 L p F P
0 g
s
.645 .683 .871 r
.62738 .3906 m .59132 .3692 L .59659 .36334 L p F P
0 g
s
.645 .683 .871 r
.59659 .36334 m .63518 .38208 L .62738 .3906 L p F P
0 g
s
.629 .101 0 r
.42064 .67397 m .41011 .65984 L .43559 .66592 L p F P
0 g
s
.629 .101 0 r
.43559 .66592 m .44351 .67941 L .42064 .67397 L p F P
0 g
s
.626 .661 .865 r
.67046 .4017 m .63518 .38208 L .64159 .37302 L p F P
0 g
s
.626 .661 .865 r
.64159 .37302 m .67884 .39008 L .67046 .4017 L p F P
0 g
s
.391 .334 .674 r
.77212 .50493 m .76357 .48413 L .77741 .46599 L p F P
0 g
s
.486 .463 .758 r
.76165 .44615 m .77741 .46599 L .76357 .48413 L p F P
0 g
s
.371 0 0 r
.59563 .66513 m .58723 .6787 L .56375 .68282 L p F P
0 g
s
.296 0 0 r
.58723 .6787 m .59563 .66513 L .62093 .6588 L p F P
0 g
s
.696 .729 .876 r
.48088 .35449 m .44969 .38026 L .44257 .37539 L p F P
0 g
s
.694 .726 .874 r
.44969 .38026 m .48088 .35449 L .48485 .35671 L p F P
0 g
s
.937 .579 .31 r
.25985 .54911 m .25529 .52837 L .2731 .54567 L p F P
0 g
s
.937 .579 .31 r
.2731 .54567 m .27732 .566 L .25985 .54911 L p F P
0 g
s
.856 .402 .088 r
.28757 .58598 m .27732 .566 L .29731 .58153 L p F P
0 g
s
.856 .402 .088 r
.29731 .58153 m .30666 .60076 L .28757 .58598 L p F P
0 g
s
.662 .702 .876 r
.57818 .37958 m .54633 .35414 L .54986 .3516 L p F P
0 g
s
.662 .702 .876 r
.54986 .3516 m .58515 .37463 L .57818 .37958 L p F P
0 g
s
.234 .006 .35 r
.75682 .54319 m .75253 .56359 L .73299 .57933 L p F P
0 g
s
.115 0 .3 r
.75253 .56359 m .75682 .54319 L .77413 .52571 L p F P
0 g
s
.316 .181 .534 r
.77212 .50493 m .77413 .52571 L .75682 .54319 L p F P
0 g
s
.16 0 .15 r
.73299 .57933 m .72348 .59866 L .70259 .61223 L p F P
0 g
s
.022 0 .073 r
.72348 .59866 m .73299 .57933 L .75253 .56359 L p F P
0 g
s
.697 .732 .878 r
.47727 .352 m .44257 .37539 L .43626 .37003 L p F P
0 g
s
.696 .729 .876 r
.44257 .37539 m .47727 .352 L .48088 .35449 L p F P
0 g
s
.647 .107 0 r
.39874 .66703 m .38569 .65208 L .41011 .65984 L p F P
0 g
s
.647 .107 0 r
.41011 .65984 m .42064 .67397 L .39874 .66703 L p F P
0 g
s
.714 .738 .87 r
.39265 .38337 m .43082 .36423 L .43626 .37003 L p F P
0 g
s
.659 .702 .878 r
.58515 .37463 m .54986 .3516 L .55297 .34882 L p F P
0 g
s
.659 .702 .878 r
.55297 .34882 m .59132 .3692 L .58515 .37463 L p F P
0 g
s
.296 0 0 r
.62093 .6588 m .60994 .67304 L .58723 .6787 L p F P
0 g
s
.205 0 0 r
.60994 .67304 m .62093 .6588 L .64513 .65079 L p F P
0 g
s
.641 .683 .874 r
.63518 .38208 m .59659 .36334 L .60091 .35713 L p F P
0 g
s
.641 .683 .874 r
.60091 .35713 m .64159 .37302 L .63518 .38208 L p F P
0 g
s
.748 .228 0 r
.32135 .61945 m .30666 .60076 L .32792 .61411 L p F P
0 g
s
.748 .228 0 r
.32792 .61411 m .34106 .63179 L .32135 .61945 L p F P
0 g
s
.228 .119 .515 r
.77413 .52571 m .77212 .50493 L .78648 .48628 L p F P
0 g
s
.391 .334 .674 r
.77741 .46599 m .78648 .48628 L .77212 .50493 L p F P
0 g
s
.567 .596 .842 r
.7396 .42681 m .71177 .40807 L .71972 .39351 L p F P
0 g
s
.598 .634 .858 r
.71177 .40807 m .67884 .39008 L .68536 .37788 L p F P
0 g
s
.598 .634 .858 r
.68536 .37788 m .71972 .39351 L .71177 .40807 L p F P
0 g
s
.523 .54 .815 r
.76165 .44615 m .7396 .42681 L .74878 .41028 L p F P
0 g
s
.567 .596 .842 r
.71972 .39351 m .74878 .41028 L .7396 .42681 L p F P
0 g
s
.111 0 0 r
.70259 .61223 m .68917 .63005 L .66796 .64118 L p F P
0 g
s
0 0 0 r
.68917 .63005 m .70259 .61223 L .72348 .59866 L p F P
0 g
s
.697 .734 .879 r
.47408 .34925 m .43626 .37003 L .43082 .36423 L p F P
0 g
s
.697 .732 .878 r
.43626 .37003 m .47408 .34925 L .47727 .352 L p F P
0 g
s
.62 .663 .87 r
.67884 .39008 m .64159 .37302 L .64655 .36353 L p F P
0 g
s
.62 .663 .87 r
.64655 .36353 m .68536 .37788 L .67884 .39008 L p F P
0 g
s
.657 .702 .88 r
.59132 .3692 m .55297 .34882 L .55562 .34583 L p F P
0 g
s
.657 .702 .88 r
.55562 .34583 m .59659 .36334 L .59132 .3692 L p F P
0 g
s
.452 .452 .767 r
.77741 .46599 m .76165 .44615 L .77185 .4281 L p F P
0 g
s
.523 .54 .815 r
.74878 .41028 m .77185 .4281 L .76165 .44615 L p F P
0 g
s
.676 .722 .884 r
.51326 .32991 m .51373 .36306 L .50859 .3629 L closepath p F P
0 g
s
.675 .722 .884 r
.51326 .32991 m .51886 .36284 L .51373 .36306 L closepath p F P
0 g
s
.677 .723 .884 r
.51326 .32991 m .50859 .3629 L .50351 .36237 L closepath p F P
0 g
s
.674 .721 .884 r
.51326 .32991 m .52393 .36226 L .51886 .36284 L closepath p F P
0 g
s
.678 .724 .884 r
.51326 .32991 m .50351 .36237 L .49854 .36147 L closepath p F P
0 g
s
.673 .72 .885 r
.51326 .32991 m .52887 .36131 L .52393 .36226 L closepath p F P
0 g
s
.678 .725 .885 r
.51326 .32991 m .49854 .36147 L .49374 .36022 L closepath p F P
0 g
s
.655 .103 0 r
.37804 .65865 m .36259 .6427 L .38569 .65208 L p F P
0 g
s
.655 .103 0 r
.38569 .65208 m .39874 .66703 L .37804 .65865 L p F P
0 g
s
.672 .72 .885 r
.51326 .32991 m .53364 .36001 L .52887 .36131 L closepath p F P
0 g
s
.679 .726 .885 r
.51326 .32991 m .49374 .36022 L .48916 .35863 L closepath p F P
0 g
s
.672 .72 .885 r
.51326 .32991 m .53817 .35836 L .53364 .36001 L closepath p F P
0 g
s
.205 0 0 r
.64513 .65079 m .63164 .66588 L .60994 .67304 L p F P
0 g
s
.096 0 0 r
.63164 .66588 m .64513 .65079 L .66796 .64118 L p F P
0 g
s
.638 .685 .878 r
.64159 .37302 m .60091 .35713 L .60422 .35062 L p F P
0 g
s
.638 .685 .878 r
.60422 .35062 m .64655 .36353 L .64159 .37302 L p F P
0 g
s
.697 .734 .879 r
.43082 .36423 m .47135 .34629 L .47408 .34925 L p F P
0 g
s
.679 .726 .885 r
.51326 .32991 m .48916 .35863 L .48485 .35671 L closepath p F P
0 g
s
.671 .719 .885 r
.51326 .32991 m .54242 .3564 L .53817 .35836 L closepath p F P
0 g
s
.842 .384 0 r
.27091 .56992 m .25985 .54911 L .27732 .566 L p F P
0 g
s
.842 .384 0 r
.27732 .566 m .28757 .58598 L .27091 .56992 L p F P
0 g
s
.655 .702 .882 r
.59659 .36334 m .55562 .34583 L .55778 .34266 L p F P
0 g
s
.655 .702 .882 r
.55778 .34266 m .60091 .35713 L .59659 .36334 L p F P
0 g
s
.332 .303 .676 r
.78648 .48628 m .77741 .46599 L .78834 .44689 L p F P
0 g
s
.452 .452 .767 r
.77185 .4281 m .78834 .44689 L .77741 .46599 L p F P
0 g
s
.68 .727 .886 r
.51326 .32991 m .48485 .35671 L .48088 .35449 L closepath p F P
0 g
s
.67 .719 .886 r
.51326 .32991 m .54633 .35414 L .54242 .3564 L closepath p F P
0 g
s
.022 0 .073 r
.75253 .56359 m .74213 .58368 L .72348 .59866 L p F P
0 g
s
0 0 0 r
.74213 .58368 m .75253 .56359 L .76952 .54651 L p F P
0 g
s
.115 0 .3 r
.77413 .52571 m .76952 .54651 L .75253 .56359 L p F P
0 g
s
.68 .728 .886 r
.51326 .32991 m .48088 .35449 L .47727 .352 L closepath p F P
0 g
s
.669 .719 .886 r
.51326 .32991 m .54986 .3516 L .54633 .35414 L closepath p F P
0 g
s
0 0 .227 r
.76952 .54651 m .77413 .52571 L .78862 .50702 L p F P
0 g
s
.228 .119 .515 r
.78648 .48628 m .78862 .50702 L .77413 .52571 L p F P
0 g
s
.719 .197 0 r
.30369 .6058 m .28757 .58598 L .30666 .60076 L p F P
0 g
s
.719 .197 0 r
.30666 .60076 m .32135 .61945 L .30369 .6058 L p F P
0 g
s
.681 .729 .887 r
.51326 .32991 m .47727 .352 L .47408 .34925 L closepath p F P
0 g
s
.652 .703 .884 r
.60091 .35713 m .55778 .34266 L .55942 .33935 L p F P
0 g
s
.652 .703 .884 r
.55942 .33935 m .60422 .35062 L .60091 .35713 L p F P
0 g
s
.554 .597 .851 r
.74878 .41028 m .71972 .39351 L .72532 .37839 L p F P
0 g
s
.589 .636 .866 r
.71972 .39351 m .68536 .37788 L .68991 .36524 L p F P
0 g
s
.589 .636 .866 r
.68991 .36524 m .72532 .37839 L .71972 .39351 L p F P
0 g
s
.614 .665 .875 r
.68536 .37788 m .64655 .36353 L .64997 .35371 L p F P
0 g
s
.614 .665 .875 r
.64997 .35371 m .68991 .36524 L .68536 .37788 L p F P
0 g
s
.668 .719 .887 r
.51326 .32991 m .55297 .34882 L .54986 .3516 L closepath p F P
0 g
s
.647 .088 0 r
.35877 .64891 m .34106 .63179 L .36259 .6427 L p F P
0 g
s
.647 .088 0 r
.36259 .6427 m .37804 .65865 L .35877 .64891 L p F P
0 g
s
0 0 0 r
.72348 .59866 m .70852 .61751 L .68917 .63005 L p F P
0 g
s
0 0 0 r
.70852 .61751 m .72348 .59866 L .74213 .58368 L p F P
0 g
s
.634 .686 .882 r
.64655 .36353 m .60422 .35062 L .60648 .3439 L p F P
0 g
s
.634 .686 .882 r
.60648 .3439 m .64997 .35371 L .64655 .36353 L p F P
0 g
s
.096 0 0 r
.66796 .64118 m .65209 .65729 L .63164 .66588 L p F P
0 g
s
0 0 0 r
.65209 .65729 m .66796 .64118 L .68917 .63005 L p F P
0 g
s
.501 .538 .826 r
.77185 .4281 m .74878 .41028 L .75531 .3931 L p F P
0 g
s
.554 .597 .851 r
.72532 .37839 m .75531 .3931 L .74878 .41028 L p F P
0 g
s
.681 .73 .888 r
.51326 .32991 m .47408 .34925 L .47135 .34629 L closepath p F P
0 g
s
.667 .719 .888 r
.51326 .32991 m .55562 .34583 L .55297 .34882 L closepath p F P
0 g
s
.468 0 0 r
.49429 .69722 m .49118 .68559 L .51547 .68628 L p F P
0 g
s
.468 0 0 r
.51547 .68628 m .51516 .69781 L .49429 .69722 L p F P
0 g
s
.42 0 0 r
.51516 .69781 m .51547 .68628 L .53975 .68535 L p F P
0 g
s
.114 .039 .485 r
.78862 .50702 m .78648 .48628 L .79783 .46663 L p F P
0 g
s
.332 .303 .676 r
.78834 .44689 m .79783 .46663 L .78648 .48628 L p F P
0 g
s
.507 0 0 r
.47361 .69525 m .4671 .6833 L .49118 .68559 L p F P
0 g
s
.507 0 0 r
.49118 .68559 m .49429 .69722 L .47361 .69525 L p F P
0 g
s
.42 0 0 r
.53975 .68535 m .53602 .69701 L .51516 .69781 L p F P
0 g
s
.362 0 0 r
.53602 .69701 m .53975 .68535 L .56375 .68282 L p F P
0 g
s
.667 .719 .888 r
.51326 .32991 m .55778 .34266 L .55562 .34583 L closepath p F P
0 g
s
.651 .704 .886 r
.60422 .35062 m .55942 .33935 L .56053 .33593 L p F P
0 g
s
.651 .704 .886 r
.56053 .33593 m .60648 .3439 L .60422 .35062 L p F P
0 g
s
.414 .44 .779 r
.78834 .44689 m .77185 .4281 L .77914 .40932 L p F P
0 g
s
.501 .538 .826 r
.75531 .3931 m .77914 .40932 L .77185 .4281 L p F P
0 g
s
.538 0 0 r
.45336 .69193 m .44351 .67941 L .4671 .6833 L p F P
0 g
s
.538 0 0 r
.4671 .6833 m .47361 .69525 L .45336 .69193 L p F P
0 g
s
.362 0 0 r
.56375 .68282 m .55663 .69484 L .53602 .69701 L p F P
0 g
s
.293 0 0 r
.55663 .69484 m .56375 .68282 L .58723 .6787 L p F P
0 g
s
.666 .72 .889 r
.51326 .32991 m .55942 .33935 L .55778 .34266 L closepath p F P
0 g
s
.56 0 0 r
.43373 .68727 m .42064 .67397 L .44351 .67941 L p F P
0 g
s
.56 0 0 r
.44351 .67941 m .45336 .69193 L .43373 .68727 L p F P
0 g
s
.609 .667 .881 r
.68991 .36524 m .64997 .35371 L .65181 .34367 L p F P
0 g
s
.631 .688 .886 r
.64997 .35371 m .60648 .3439 L .60765 .33704 L p F P
0 g
s
.631 .688 .886 r
.60765 .33704 m .65181 .34367 L .64997 .35371 L p F P
0 g
s
.616 .058 0 r
.34115 .6379 m .32135 .61945 L .34106 .63179 L p F P
0 g
s
.616 .058 0 r
.34106 .63179 m .35877 .64891 L .34115 .6379 L p F P
0 g
s
.665 .72 .89 r
.51326 .32991 m .56053 .33593 L .55942 .33935 L closepath p F P
0 g
s
.293 0 0 r
.58723 .6787 m .57679 .69132 L .55663 .69484 L p F P
0 g
s
.21 0 0 r
.57679 .69132 m .58723 .6787 L .60994 .67304 L p F P
0 g
s
.58 .639 .874 r
.72532 .37839 m .68991 .36524 L .69243 .35229 L p F P
0 g
s
.609 .667 .881 r
.65181 .34367 m .69243 .35229 L .68991 .36524 L p F P
0 g
s
.649 .706 .889 r
.60648 .3439 m .56053 .33593 L .56108 .33245 L p F P
0 g
s
.649 .706 .889 r
.56108 .33245 m .60765 .33704 L .60648 .3439 L p F P
0 g
s
0 0 0 r
.76952 .54651 m .75833 .56744 L .74213 .58368 L p F P
0 g
s
0 0 0 r
.75833 .56744 m .76952 .54651 L .78372 .52826 L p F P
0 g
s
0 0 .227 r
.78862 .50702 m .78372 .52826 L .76952 .54651 L p F P
0 g
s
0 0 0 r
.68917 .63005 m .67107 .64736 L .65209 .65729 L p F P
0 g
s
0 0 0 r
.67107 .64736 m .68917 .63005 L .70852 .61751 L p F P
0 g
s
.258 .265 .676 r
.79783 .46663 m .78834 .44689 L .79618 .42701 L p F P
0 g
s
.414 .44 .779 r
.77914 .40932 m .79618 .42701 L .78834 .44689 L p F P
0 g
s
.652 .146 0 r
.28829 .59097 m .27091 .56992 L .28757 .58598 L p F P
0 g
s
.652 .146 0 r
.28757 .58598 m .30369 .6058 L .28829 .59097 L p F P
0 g
s
.54 .599 .862 r
.75531 .3931 m .72532 .37839 L .72849 .36289 L p F P
0 g
s
.58 .639 .874 r
.69243 .35229 m .72849 .36289 L .72532 .37839 L p F P
0 g
s
.665 .721 .891 r
.51326 .32991 m .56108 .33245 L .56053 .33593 L closepath p F P
0 g
s
0 0 .125 r
.78372 .52826 m .78862 .50702 L .80007 .48732 L p F P
0 g
s
.114 .039 .485 r
.79783 .46663 m .80007 .48732 L .78862 .50702 L p F P
0 g
s
0 0 0 r
.74213 .58368 m .72578 .60368 L .70852 .61751 L p F P
0 g
s
0 0 0 r
.72578 .60368 m .74213 .58368 L .75833 .56744 L p F P
0 g
s
.571 0 0 r
.41496 .68134 m .39874 .66703 L .42064 .67397 L p F P
0 g
s
.571 0 0 r
.42064 .67397 m .43373 .68727 L .41496 .68134 L p F P
0 g
s
.21 0 0 r
.60994 .67304 m .59627 .68647 L .57679 .69132 L p F P
0 g
s
.11 0 0 r
.59627 .68647 m .60994 .67304 L .63164 .66588 L p F P
0 g
s
.647 .707 .891 r
.60765 .33704 m .56108 .33245 L .56107 .32894 L p F P
0 g
s
.664 .721 .891 r
.51326 .32991 m .56107 .32894 L .56108 .33245 L closepath p F P
0 g
s
.478 .537 .839 r
.77914 .40932 m .75531 .3931 L .75907 .37547 L p F P
0 g
s
.54 .599 .862 r
.72849 .36289 m .75907 .37547 L .75531 .3931 L p F P
0 g
s
.628 .691 .89 r
.65181 .34367 m .60765 .33704 L .60772 .33013 L p F P
0 g
s
.647 .707 .891 r
.56107 .32894 m .60772 .33013 L .60765 .33704 L p F P
0 g
s
.664 .722 .892 r
.51326 .32991 m .5605 .32545 L .56107 .32894 L closepath p F P
0 g
s
.664 .723 .893 r
.51326 .32991 m .55938 .32202 L .5605 .32545 L closepath p F P
0 g
s
.664 .723 .894 r
.51326 .32991 m .55771 .31869 L .55938 .32202 L closepath p F P
0 g
s
.663 .724 .894 r
.51326 .32991 m .55551 .3155 L .55771 .31869 L closepath p F P
0 g
s
.604 .671 .887 r
.69243 .35229 m .65181 .34367 L .65203 .33352 L p F P
0 g
s
.628 .691 .89 r
.60772 .33013 m .65203 .33352 L .65181 .34367 L p F P
0 g
s
.646 .709 .893 r
.60772 .33013 m .56107 .32894 L .5605 .32545 L p F P
0 g
s
0 0 .438 r
.80007 .48732 m .79783 .46663 L .806 .44617 L p F P
0 g
s
.258 .265 .676 r
.79618 .42701 m .806 .44617 L .79783 .46663 L p F P
0 g
s
.568 0 0 r
.39723 .67417 m .37804 .65865 L .39874 .66703 L p F P
0 g
s
.568 0 0 r
.39874 .66703 m .41496 .68134 L .39723 .67417 L p F P
0 g
s
.572 .643 .882 r
.72849 .36289 m .69243 .35229 L .69286 .33919 L p F P
0 g
s
.604 .671 .887 r
.65203 .33352 m .69286 .33919 L .69243 .35229 L p F P
0 g
s
.554 .012 0 r
.32539 .62572 m .30369 .6058 L .32135 .61945 L p F P
0 g
s
.554 .012 0 r
.32135 .61945 m .34115 .6379 L .32539 .62572 L p F P
0 g
s
.371 .428 .79 r
.79618 .42701 m .77914 .40932 L .78339 .39003 L p F P
0 g
s
.478 .537 .839 r
.75907 .37547 m .78339 .39003 L .77914 .40932 L p F P
0 g
s
.646 .709 .893 r
.5605 .32545 m .60668 .32323 L .60772 .33013 L p F P
0 g
s
.645 .711 .896 r
.60668 .32323 m .5605 .32545 L .55938 .32202 L p F P
0 g
s
.11 0 0 r
.63164 .66588 m .61487 .68035 L .59627 .68647 L p F P
0 g
s
0 0 0 r
.61487 .68035 m .63164 .66588 L .65209 .65729 L p F P
0 g
s
.625 .694 .894 r
.65203 .33352 m .60772 .33013 L .60668 .32323 L p F P
0 g
s
0 0 0 r
.70852 .61751 m .68836 .63617 L .67107 .64736 L p F P
0 g
s
0 0 0 r
.68836 .63617 m .70852 .61751 L .72578 .60368 L p F P
0 g
s
.645 .711 .896 r
.55938 .32202 m .60454 .31643 L .60668 .32323 L p F P
0 g
s
.644 .714 .898 r
.60454 .31643 m .55938 .32202 L .55771 .31869 L p F P
0 g
s
.526 .603 .873 r
.75907 .37547 m .72849 .36289 L .72915 .34719 L p F P
0 g
s
.572 .643 .882 r
.69286 .33919 m .72915 .34719 L .72849 .36289 L p F P
0 g
s
.599 .675 .893 r
.69286 .33919 m .65203 .33352 L .65062 .32339 L p F P
0 g
s
.625 .694 .894 r
.60668 .32323 m .65062 .32339 L .65203 .33352 L p F P
0 g
s
.644 .714 .898 r
.55771 .31869 m .60131 .30982 L .60454 .31643 L p F P
0 g
s
.644 .716 .9 r
.60131 .30982 m .55771 .31869 L .55551 .3155 L p F P
0 g
s
0 0 0 r
.78372 .52826 m .77186 .55009 L .75833 .56744 L p F P
0 g
s
0 0 0 r
.77186 .55009 m .78372 .52826 L .79495 .50902 L p F P
0 g
s
0 0 .125 r
.80007 .48732 m .79495 .50902 L .78372 .52826 L p F P
0 g
s
.623 .698 .898 r
.65062 .32339 m .60668 .32323 L .60454 .31643 L p F P
0 g
s
.545 0 0 r
.38074 .66586 m .35877 .64891 L .37804 .65865 L p F P
0 g
s
.545 0 0 r
.37804 .65865 m .39723 .67417 L .38074 .66586 L p F P
0 g
s
0 0 0 r
.75833 .56744 m .74075 .58869 L .72578 .60368 L p F P
0 g
s
.587 .84 .479 r
.74075 .58869 m .75833 .56744 L .77186 .55009 L p F P
0 g
s
.167 .218 .672 r
.806 .44617 m .79618 .42701 L .8008 .40657 L p F P
0 g
s
.371 .428 .79 r
.78339 .39003 m .8008 .40657 L .79618 .42701 L p F P
0 g
s
0 0 0 r
.65209 .65729 m .63239 .67302 L .61487 .68035 L p F P
0 g
s
0 0 0 r
.63239 .67302 m .65209 .65729 L .67107 .64736 L p F P
0 g
s
.644 .716 .9 r
.55551 .3155 m .59703 .30348 L .60131 .30982 L p F P
0 g
s
.452 .537 .853 r
.78339 .39003 m .75907 .37547 L .75998 .35758 L p F P
0 g
s
.526 .603 .873 r
.72915 .34719 m .75998 .35758 L .75907 .37547 L p F P
0 g
s
0 0 0 r
.79495 .50902 m .80007 .48732 L .80832 .46682 L p F P
0 g
s
0 0 .438 r
.806 .44617 m .80832 .46682 L .80007 .48732 L p F P
0 g
s
.564 .648 .891 r
.72915 .34719 m .69286 .33919 L .69117 .32608 L p F P
0 g
s
.599 .675 .893 r
.65062 .32339 m .69117 .32608 L .69286 .33919 L p F P
0 g
s
0 .047 .543 r
.31167 .61251 m .28829 .59097 L .30369 .6058 L p F P
0 g
s
0 .047 .543 r
.30369 .6058 m .32539 .62572 L .31167 .61251 L p F P
0 g
s
.623 .698 .898 r
.60454 .31643 m .64758 .31339 L .65062 .32339 L p F P
0 g
s
.622 .702 .902 r
.64758 .31339 m .60454 .31643 L .60131 .30982 L p F P
0 g
s
.596 .68 .9 r
.69117 .32608 m .65062 .32339 L .64758 .31339 L p F P
0 g
s
0 0 0 r
.72578 .60368 m .70377 .62383 L .68836 .63617 L p F P
0 g
s
.544 .859 .563 r
.70377 .62383 m .72578 .60368 L .74075 .58869 L p F P
0 g
s
.496 0 0 r
.3657 .65646 m .34115 .6379 L .35877 .64891 L p F P
0 g
s
.496 0 0 r
.35877 .64891 m .38074 .66586 L .3657 .65646 L p F P
0 g
s
.32 .415 .803 r
.8008 .40657 m .78339 .39003 L .78451 .37043 L p F P
0 g
s
.452 .537 .853 r
.75998 .35758 m .78451 .37043 L .78339 .39003 L p F P
0 g
s
0 0 .363 r
.80832 .46682 m .806 .44617 L .81084 .42512 L p F P
0 g
s
.167 .218 .672 r
.8008 .40657 m .81084 .42512 L .806 .44617 L p F P
0 g
s
.512 .608 .885 r
.75998 .35758 m .72915 .34719 L .72727 .33146 L p F P
0 g
s
.564 .648 .891 r
.69117 .32608 m .72727 .33146 L .72915 .34719 L p F P
0 g
s
0 0 0 r
.67107 .64736 m .64862 .66453 L .63239 .67302 L p F P
0 g
s
0 0 0 r
.64862 .66453 m .67107 .64736 L .68836 .63617 L p F P
0 g
s
.622 .702 .902 r
.60131 .30982 m .64293 .30365 L .64758 .31339 L p F P
0 g
s
.621 .706 .907 r
.64293 .30365 m .60131 .30982 L .59703 .30348 L p F P
0 g
s
.419 0 0 r
.49796 .70827 m .49429 .69722 L .51516 .69781 L p F P
0 g
s
.419 0 0 r
.51516 .69781 m .5148 .70874 L .49796 .70827 L p F P
0 g
s
.37 0 0 r
.5148 .70874 m .51516 .69781 L .53602 .69701 L p F P
0 g
s
.458 0 0 r
.48129 .70669 m .47361 .69525 L .49429 .69722 L p F P
0 g
s
.458 0 0 r
.49429 .69722 m .49796 .70827 L .48129 .70669 L p F P
0 g
s
.37 0 0 r
.53602 .69701 m .53162 .7081 L .5148 .70874 L p F P
0 g
s
.309 0 0 r
.53162 .7081 m .53602 .69701 L .55663 .69484 L p F P
0 g
s
.487 0 0 r
.46496 .70401 m .45336 .69193 L .47361 .69525 L p F P
0 g
s
.487 0 0 r
.47361 .69525 m .48129 .70669 L .46496 .70401 L p F P
0 g
s
.309 0 0 r
.55663 .69484 m .54824 .70636 L .53162 .7081 L p F P
0 g
s
.237 0 0 r
.54824 .70636 m .55663 .69484 L .57679 .69132 L p F P
0 g
s
.557 .654 .9 r
.72727 .33146 m .69117 .32608 L .68737 .31313 L p F P
0 g
s
.596 .68 .9 r
.64758 .31339 m .68737 .31313 L .69117 .32608 L p F P
0 g
s
.592 .686 .906 r
.68737 .31313 m .64758 .31339 L .64293 .30365 L p F P
0 g
s
.587 .84 .479 r
.77186 .55009 m .75322 .57269 L .74075 .58869 L p F P
0 g
s
0 0 0 r
.79495 .50902 m .78252 .53182 L .77186 .55009 L p F P
0 g
s
.751 .933 .588 r
.75322 .57269 m .77186 .55009 L .78252 .53182 L p F P
0 g
s
.621 .706 .907 r
.59703 .30348 m .63673 .29428 L .64293 .30365 L p F P
0 g
s
0 0 0 r
.80832 .46682 m .80302 .48901 L .79495 .50902 L p F P
0 g
s
.767 .872 .445 r
.78252 .53182 m .79495 .50902 L .80302 .48901 L p F P
0 g
s
.506 0 0 r
.44916 .70028 m .43373 .68727 L .45336 .69193 L p F P
0 g
s
.506 0 0 r
.45336 .69193 m .46496 .70401 L .44916 .70028 L p F P
0 g
s
.237 0 0 r
.57679 .69132 m .56448 .70353 L .54824 .70636 L p F P
0 g
s
.149 0 0 r
.56448 .70353 m .57679 .69132 L .59627 .68647 L p F P
0 g
s
.425 .538 .867 r
.78451 .37043 m .75998 .35758 L .75797 .33965 L p F P
0 g
s
.512 .608 .885 r
.72727 .33146 m .75797 .33965 L .75998 .35758 L p F P
0 g
s
.051 .159 .658 r
.81084 .42512 m .8008 .40657 L .80209 .3858 L p F P
0 g
s
.32 .415 .803 r
.78451 .37043 m .80209 .3858 L .8008 .40657 L p F P
0 g
s
0 .117 .573 r
.35226 .64608 m .32539 .62572 L .34115 .6379 L p F P
0 g
s
0 .117 .573 r
.34115 .6379 m .3657 .65646 L .35226 .64608 L p F P
0 g
s
.544 .859 .563 r
.74075 .58869 m .71709 .61048 L .70377 .62383 L p F P
0 g
s
.697 .944 .656 r
.71709 .61048 m .74075 .58869 L .75322 .57269 L p F P
0 g
s
.512 0 0 r
.43404 .69551 m .41496 .68134 L .43373 .68727 L p F P
0 g
s
.512 0 0 r
.43373 .68727 m .44916 .70028 L .43404 .69551 L p F P
0 g
s
0 0 0 r
.68836 .63617 m .66339 .65498 L .64862 .66453 L p F P
0 g
s
.47 .838 .591 r
.66339 .65498 m .68836 .63617 L .70377 .62383 L p F P
0 g
s
0 0 .363 r
.81084 .42512 m .81321 .44572 L .80832 .46682 L p F P
0 g
s
.697 .701 .171 r
.80302 .48901 m .80832 .46682 L .81321 .44572 L p F P
0 g
s
.149 0 0 r
.59627 .68647 m .58017 .69964 L .56448 .70353 L p F P
0 g
s
.044 0 0 r
.58017 .69964 m .59627 .68647 L .61487 .68035 L p F P
0 g
s
.592 .686 .906 r
.64293 .30365 m .68147 .3005 L .68737 .31313 L p F P
0 g
s
.59 .692 .913 r
.68147 .3005 m .64293 .30365 L .63673 .29428 L p F P
0 g
s
.498 .614 .897 r
.75797 .33965 m .72727 .33146 L .72284 .31589 L p F P
0 g
s
.557 .654 .9 r
.68737 .31313 m .72284 .31589 L .72727 .33146 L p F P
0 g
s
.551 .662 .91 r
.72284 .31589 m .68737 .31313 L .68147 .3005 L p F P
0 g
s
.501 0 0 r
.4198 .68977 m .39723 .67417 L .41496 .68134 L p F P
0 g
s
.501 0 0 r
.41496 .68134 m .43404 .69551 L .4198 .68977 L p F P
0 g
s
.261 .4 .814 r
.80209 .3858 m .78451 .37043 L .78244 .35077 L p F P
0 g
s
.425 .538 .867 r
.75797 .33965 m .78244 .35077 L .78451 .37043 L p F P
0 g
s
.044 0 0 r
.61487 .68035 m .59514 .69472 L .58017 .69964 L p F P
0 g
s
0 0 0 r
.59514 .69472 m .61487 .68035 L .63239 .67302 L p F P
0 g
s
0 0 .249 r
.81321 .44572 m .81084 .42512 L .81223 .40373 L p F P
0 g
s
.051 .159 .658 r
.80209 .3858 m .81223 .40373 L .81084 .42512 L p F P
0 g
s
0 .17 .664 r
.3406 .63483 m .31167 .61251 L .32539 .62572 L p F P
0 g
s
0 .17 .664 r
.32539 .62572 m .35226 .64608 L .3406 .63483 L p F P
0 g
s
.59 .692 .913 r
.63673 .29428 m .67354 .28833 L .68147 .3005 L p F P
0 g
s
.47 .838 .591 r
.70377 .62383 m .67651 .64447 L .66339 .65498 L p F P
0 g
s
.621 .927 .679 r
.67651 .64447 m .70377 .62383 L .71709 .61048 L p F P
0 g
s
.751 .933 .588 r
.78252 .53182 m .76303 .55584 L .75322 .57269 L p F P
0 g
s
.864 .974 .665 r
.76303 .55584 m .78252 .53182 L .79017 .51281 L p F P
0 g
s
.767 .872 .445 r
.80302 .48901 m .79017 .51281 L .78252 .53182 L p F P
0 g
s
.47 0 0 r
.40657 .6831 m .38074 .66586 L .39723 .67417 L p F P
0 g
s
.47 0 0 r
.39723 .67417 m .4198 .68977 L .40657 .6831 L p F P
0 g
s
.397 .541 .883 r
.78244 .35077 m .75797 .33965 L .75305 .32187 L p F P
0 g
s
.498 .614 .897 r
.72284 .31589 m .75305 .32187 L .75797 .33965 L p F P
0 g
s
0 0 0 r
.63239 .67302 m .60921 .68884 L .59514 .69472 L p F P
0 g
s
0 0 0 r
.60921 .68884 m .63239 .67302 L .64862 .66453 L p F P
0 g
s
.896 .929 .549 r
.79017 .51281 m .80302 .48901 L .80779 .46842 L p F P
0 g
s
.697 .701 .171 r
.81321 .44572 m .80779 .46842 L .80302 .48901 L p F P
0 g
s
.697 .944 .656 r
.75322 .57269 m .72817 .59623 L .71709 .61048 L p F P
0 g
s
.811 .987 .722 r
.72817 .59623 m .75322 .57269 L .76303 .55584 L p F P
0 g
s
0 .085 .629 r
.81223 .40373 m .80209 .3858 L .79998 .36494 L p F P
0 g
s
.261 .4 .814 r
.78244 .35077 m .79998 .36494 L .80209 .3858 L p F P
0 g
s
.551 .662 .91 r
.68147 .3005 m .71589 .30068 L .72284 .31589 L p F P
0 g
s
.545 .67 .919 r
.71589 .30068 m .68147 .3005 L .67354 .28833 L p F P
0 g
s
.485 .622 .91 r
.75305 .32187 m .72284 .31589 L .71589 .30068 L p F P
0 g
s
0 0 .249 r
.81223 .40373 m .81463 .42428 L .81321 .44572 L p F P
0 g
s
.872 .805 .319 r
.80779 .46842 m .81321 .44572 L .81463 .42428 L p F P
0 g
s
.413 0 0 r
.39452 .67557 m .3657 .65646 L .38074 .66586 L p F P
0 g
s
.413 0 0 r
.38074 .66586 m .40657 .6831 L .39452 .67557 L p F P
0 g
s
0 0 0 r
.64862 .66453 m .62224 .68204 L .60921 .68884 L p F P
0 g
s
0 0 0 r
.62224 .68204 m .64862 .66453 L .66339 .65498 L p F P
0 g
s
.191 .383 .823 r
.79998 .36494 m .78244 .35077 L .77714 .33127 L p F P
0 g
s
.397 .541 .883 r
.75305 .32187 m .77714 .33127 L .78244 .35077 L p F P
0 g
s
.621 .927 .679 r
.71709 .61048 m .68783 .6331 L .67651 .64447 L p F P
0 g
s
.743 .98 .744 r
.68783 .6331 m .71709 .61048 L .72817 .59623 L p F P
0 g
s
.545 .67 .919 r
.67354 .28833 m .70645 .28601 L .71589 .30068 L p F P
0 g
s
0 0 .099 r
.81463 .42428 m .81223 .40373 L .81011 .38224 L p F P
0 g
s
0 .085 .629 r
.79998 .36494 m .81011 .38224 L .81223 .40373 L p F P
0 g
s
.366 .545 .898 r
.77714 .33127 m .75305 .32187 L .74522 .30449 L p F P
0 g
s
.485 .622 .91 r
.71589 .30068 m .74522 .30449 L .75305 .32187 L p F P
0 g
s
.864 .974 .665 r
.79017 .51281 m .77002 .53833 L .76303 .55584 L p F P
0 g
s
.926 .973 .708 r
.77002 .53833 m .79017 .51281 L .79466 .49327 L p F P
0 g
s
.896 .929 .549 r
.80779 .46842 m .79466 .49327 L .79017 .51281 L p F P
0 g
s
0 .193 .65 r
.38378 .66727 m .35226 .64608 L .3657 .65646 L p F P
0 g
s
0 .193 .65 r
.3657 .65646 m .39452 .67557 L .38378 .66727 L p F P
0 g
s
.472 .632 .923 r
.74522 .30449 m .71589 .30068 L .70645 .28601 L p F P
0 g
s
.811 .987 .722 r
.76303 .55584 m .73684 .58125 L .72817 .59623 L p F P
0 g
s
.882 .992 .76 r
.73684 .58125 m .76303 .55584 L .77002 .53833 L p F P
0 g
s
0 0 0 r
.66339 .65498 m .63406 .67439 L .62224 .68204 L p F P
0 g
s
.524 .885 .666 r
.63406 .67439 m .66339 .65498 L .67651 .64447 L p F P
0 g
s
.391 0 0 r
.50212 .71941 m .49796 .70827 L .5148 .70874 L p F P
0 g
s
.391 0 0 r
.5148 .70874 m .51438 .71975 L .50212 .71941 L p F P
0 g
s
.342 0 0 r
.51438 .71975 m .5148 .70874 L .53162 .7081 L p F P
0 g
s
.961 .934 .614 r
.79466 .49327 m .80779 .46842 L .80915 .44749 L p F P
0 g
s
.872 .805 .319 r
.81463 .42428 m .80915 .44749 L .80779 .46842 L p F P
0 g
s
.43 0 0 r
.48999 .71826 m .48129 .70669 L .49796 .70827 L p F P
0 g
s
.43 0 0 r
.49796 .70827 m .50212 .71941 L .48999 .71826 L p F P
0 g
s
.342 0 0 r
.53162 .7081 m .52663 .71929 L .51438 .71975 L p F P
0 g
s
.28 0 0 r
.52663 .71929 m .53162 .7081 L .54824 .70636 L p F P
0 g
s
0 0 .572 r
.81011 .38224 m .79998 .36494 L .79444 .34424 L p F P
0 g
s
.191 .383 .823 r
.77714 .33127 m .79444 .34424 L .79998 .36494 L p F P
0 g
s
.459 0 0 r
.47811 .71632 m .46496 .70401 L .48129 .70669 L p F P
0 g
s
.459 0 0 r
.48129 .70669 m .48999 .71826 L .47811 .71632 L p F P
0 g
s
.28 0 0 r
.54824 .70636 m .53873 .71802 L .52663 .71929 L p F P
0 g
s
.206 0 0 r
.53873 .71802 m .54824 .70636 L .56448 .70353 L p F P
0 g
s
.476 0 0 r
.46662 .71361 m .44916 .70028 L .46496 .70401 L p F P
0 g
s
.476 0 0 r
.46496 .70401 m .47811 .71632 L .46662 .71361 L p F P
0 g
s
.206 0 0 r
.56448 .70353 m .55054 .71597 L .53873 .71802 L p F P
0 g
s
.116 0 0 r
.55054 .71597 m .56448 .70353 L .58017 .69964 L p F P
0 g
s
.743 .98 .744 r
.72817 .59623 m .69721 .62099 L .68783 .6331 L p F P
0 g
s
.829 .999 .785 r
.69721 .62099 m .72817 .59623 L .73684 .58125 L p F P
0 g
s
0 0 .099 r
.81011 .38224 m .81249 .40273 L .81463 .42428 L p F P
0 g
s
.967 .843 .43 r
.80915 .44749 m .81463 .42428 L .81249 .40273 L p F P
0 g
s
0 .239 .725 r
.37448 .65829 m .3406 .63483 L .35226 .64608 L p F P
0 g
s
0 .239 .725 r
.35226 .64608 m .38378 .66727 L .37448 .65829 L p F P
0 g
s
.11 .363 .826 r
.79444 .34424 m .77714 .33127 L .76864 .31218 L p F P
0 g
s
.366 .545 .898 r
.74522 .30449 m .76864 .31218 L .77714 .33127 L p F P
0 g
s
.479 0 0 r
.45565 .71016 m .43404 .69551 L .44916 .70028 L p F P
0 g
s
.479 0 0 r
.44916 .70028 m .46662 .71361 L .45565 .71016 L p F P
0 g
s
.524 .885 .666 r
.67651 .64447 m .64454 .66599 L .63406 .67439 L p F P
0 g
s
.657 .955 .737 r
.64454 .66599 m .67651 .64447 L .68783 .6331 L p F P
0 g
s
.116 0 0 r
.58017 .69964 m .56195 .71315 L .55054 .71597 L p F P
0 g
s
.01 0 0 r
.56195 .71315 m .58017 .69964 L .59514 .69472 L p F P
0 g
s
.472 .632 .923 r
.70645 .28601 m .73454 .2877 L .74522 .30449 L p F P
0 g
s
.334 .551 .913 r
.76864 .31218 m .74522 .30449 L .73454 .2877 L p F P
0 g
s
.465 0 0 r
.44531 .706 m .4198 .68977 L .43404 .69551 L p F P
0 g
s
.465 0 0 r
.43404 .69551 m .45565 .71016 L .44531 .706 L p F P
0 g
s
0 0 .572 r
.79444 .34424 m .80442 .3609 L .81011 .38224 L p F P
0 g
s
.853 .6 .061 r
.81249 .40273 m .81011 .38224 L .80442 .3609 L p F P
0 g
s
.01 0 0 r
.59514 .69472 m .57281 .70959 L .56195 .71315 L p F P
0 g
s
0 0 0 r
.57281 .70959 m .59514 .69472 L .60921 .68884 L p F P
0 g
s
.882 .992 .76 r
.77002 .53833 m .74299 .5657 L .73684 .58125 L p F P
0 g
s
.919 .972 .776 r
.74299 .5657 m .77002 .53833 L .77408 .52035 L p F P
0 g
s
.926 .973 .708 r
.79466 .49327 m .77408 .52035 L .77002 .53833 L p F P
0 g
s
.951 .947 .729 r
.77408 .52035 m .79466 .49327 L .79589 .47342 L p F P
0 g
s
.961 .934 .614 r
.80915 .44749 m .79589 .47342 L .79466 .49327 L p F P
0 g
s
.43 0 0 r
.43574 .70118 m .40657 .6831 L .4198 .68977 L p F P
0 g
s
.43 0 0 r
.4198 .68977 m .44531 .706 L .43574 .70118 L p F P
0 g
s
.981 .908 .649 r
.79589 .47342 m .80915 .44749 L .80703 .42647 L p F P
0 g
s
.967 .843 .43 r
.81249 .40273 m .80703 .42647 L .80915 .44749 L p F P
0 g
s
0 0 0 r
.60921 .68884 m .58302 .70533 L .57281 .70959 L p F P
0 g
s
0 0 0 r
.58302 .70533 m .60921 .68884 L .62224 .68204 L p F P
0 g
s
.829 .999 .785 r
.73684 .58125 m .70452 .60826 L .69721 .62099 L p F P
0 g
s
.882 .99 .804 r
.70452 .60826 m .73684 .58125 L .74299 .5657 L p F P
0 g
s
.657 .955 .737 r
.68783 .6331 m .65356 .6569 L .64454 .66599 L p F P
0 g
s
.762 .992 .787 r
.65356 .6569 m .68783 .6331 L .69721 .62099 L p F P
0 g
s
0 0 .478 r
.80442 .3609 m .79444 .34424 L .78547 .32395 L p F P
0 g
s
.11 .363 .826 r
.76864 .31218 m .78547 .32395 L .79444 .34424 L p F P
0 g
s
.018 .338 .819 r
.78547 .32395 m .76864 .31218 L .757 .29373 L p F P
0 g
s
.334 .551 .913 r
.73454 .2877 m .757 .29373 L .76864 .31218 L p F P
0 g
s
0 .188 .604 r
.42703 .69574 m .39452 .67557 L .40657 .6831 L p F P
0 g
s
0 .188 .604 r
.40657 .6831 m .43574 .70118 L .42703 .69574 L p F P
0 g
s
.998 .835 .501 r
.80703 .42647 m .81249 .40273 L .80678 .38134 L p F P
0 g
s
.853 .6 .061 r
.80442 .3609 m .80678 .38134 L .81249 .40273 L p F P
0 g
s
0 0 0 r
.62224 .68204 m .59244 .70041 L .58302 .70533 L p F P
0 g
s
.403 .816 .62 r
.59244 .70041 m .62224 .68204 L .63406 .67439 L p F P
0 g
s
.762 .992 .787 r
.69721 .62099 m .661 .64724 L .65356 .6569 L p F P
0 g
s
.834 .999 .814 r
.661 .64724 m .69721 .62099 L .70452 .60826 L p F P
0 g
s
.919 .972 .776 r
.77408 .52035 m .7465 .54974 L .74299 .5657 L p F P
0 g
s
.932 .94 .779 r
.7465 .54974 m .77408 .52035 L .77512 .50209 L p F P
0 g
s
.951 .947 .729 r
.79589 .47342 m .77512 .50209 L .77408 .52035 L p F P
0 g
s
0 .229 .685 r
.4193 .68975 m .38378 .66727 L .39452 .67557 L p F P
0 g
s
0 .229 .685 r
.39452 .67557 m .42703 .69574 L .4193 .68975 L p F P
0 g
s
0 0 .478 r
.78547 .32395 m .79519 .33998 L .80442 .3609 L p F P
0 g
s
.944 .65 .197 r
.80678 .38134 m .80442 .3609 L .79519 .33998 L p F P
0 g
s
.954 .91 .735 r
.77512 .50209 m .79589 .47342 L .79379 .45348 L p F P
0 g
s
.981 .908 .649 r
.80703 .42647 m .79379 .45348 L .79589 .47342 L p F P
0 g
s
.403 .816 .62 r
.63406 .67439 m .60098 .69489 L .59244 .70041 L p F P
0 g
s
.547 .904 .699 r
.60098 .69489 m .63406 .67439 L .64454 .66599 L p F P
0 g
s
.882 .99 .804 r
.74299 .5657 m .70965 .59507 L .70452 .60826 L p F P
0 g
s
.908 .965 .808 r
.70965 .59507 m .74299 .5657 L .7465 .54974 L p F P
0 g
s
.018 .338 .819 r
.757 .29373 m .77314 .30434 L .78547 .32395 L p F P
0 g
s
.622 .205 0 r
.79519 .33998 m .78547 .32395 L .77314 .30434 L p F P
0 g
s
.977 .871 .665 r
.79379 .45348 m .80703 .42647 L .80139 .40561 L p F P
0 g
s
.998 .835 .501 r
.80678 .38134 m .80139 .40561 L .80703 .42647 L p F P
0 g
s
0 .271 .752 r
.41262 .68328 m .37448 .65829 L .38378 .66727 L p F P
0 g
s
0 .271 .752 r
.38378 .66727 m .4193 .68975 L .41262 .68328 L p F P
0 g
s
.547 .904 .699 r
.64454 .66599 m .60853 .68882 L .60098 .69489 L p F P
0 g
s
.672 .965 .763 r
.60853 .68882 m .64454 .66599 L .65356 .6569 L p F P
0 g
s
.834 .999 .814 r
.70452 .60826 m .66676 .63711 L .661 .64724 L p F P
0 g
s
.878 .985 .825 r
.66676 .63711 m .70452 .60826 L .70965 .59507 L p F P
0 g
s
.994 .805 .543 r
.80139 .40561 m .80678 .38134 L .79749 .36037 L p F P
0 g
s
.944 .65 .197 r
.79519 .33998 m .79749 .36037 L .80678 .38134 L p F P
0 g
s
.386 0 0 r
.5067 .73139 m .50212 .71941 L .51438 .71975 L p F P
0 g
s
.386 0 0 r
.51438 .71975 m .51393 .73159 L .5067 .73139 L p F P
0 g
s
.337 0 0 r
.51393 .73159 m .51438 .71975 L .52663 .71929 L p F P
0 g
s
.426 0 0 r
.49954 .73072 m .48999 .71826 L .50212 .71941 L p F P
0 g
s
.426 0 0 r
.50212 .71941 m .5067 .73139 L .49954 .73072 L p F P
0 g
s
.337 0 0 r
.52663 .71929 m .52115 .73132 L .51393 .73159 L p F P
0 g
s
.275 0 0 r
.52115 .73132 m .52663 .71929 L .53873 .71802 L p F P
0 g
s
.932 .94 .779 r
.77512 .50209 m .7473 .53355 L .7465 .54974 L p F P
0 g
s
.931 .903 .775 r
.7473 .53355 m .77512 .50209 L .77307 .48377 L p F P
0 g
s
.954 .91 .735 r
.79379 .45348 m .77307 .48377 L .77512 .50209 L p F P
0 g
s
.454 0 0 r
.49255 .72958 m .47811 .71632 L .48999 .71826 L p F P
0 g
s
.454 0 0 r
.48999 .71826 m .49954 .73072 L .49255 .72958 L p F P
0 g
s
.275 0 0 r
.53873 .71802 m .52828 .73058 L .52115 .73132 L p F P
0 g
s
.201 0 0 r
.52828 .73058 m .53873 .71802 L .55054 .71597 L p F P
0 g
s
.908 .965 .808 r
.7465 .54974 m .71252 .58154 L .70965 .59507 L p F P
0 g
s
.917 .932 .804 r
.71252 .58154 m .7465 .54974 L .7473 .53355 L p F P
0 g
s
.672 .965 .763 r
.65356 .6569 m .615 .68228 L .60853 .68882 L p F P
0 g
s
.769 .995 .805 r
.615 .68228 m .65356 .6569 L .661 .64724 L p F P
0 g
s
.471 0 0 r
.48578 .72799 m .46662 .71361 L .47811 .71632 L p F P
0 g
s
.471 0 0 r
.47811 .71632 m .49255 .72958 L .48578 .72799 L p F P
0 g
s
.201 0 0 r
.55054 .71597 m .53524 .72937 L .52828 .73058 L p F P
0 g
s
.111 0 0 r
.53524 .72937 m .55054 .71597 L .56195 .71315 L p F P
0 g
s
.971 .658 .296 r
.79749 .36037 m .79519 .33998 L .78247 .31975 L p F P
0 g
s
.622 .205 0 r
.77314 .30434 m .78247 .31975 L .79519 .33998 L p F P
0 g
s
.945 .871 .734 r
.77307 .48377 m .79379 .45348 L .78833 .43371 L p F P
0 g
s
.977 .871 .665 r
.80139 .40561 m .78833 .43371 L .79379 .45348 L p F P
0 g
s
.473 0 0 r
.47933 .72596 m .45565 .71016 L .46662 .71361 L p F P
0 g
s
.473 0 0 r
.46662 .71361 m .48578 .72799 L .47933 .72596 L p F P
0 g
s
.111 0 0 r
.56195 .71315 m .54195 .72772 L .53524 .72937 L p F P
0 g
s
.004 0 0 r
.54195 .72772 m .56195 .71315 L .57281 .70959 L p F P
0 g
s
.878 .985 .825 r
.70965 .59507 m .67076 .62661 L .66676 .63711 L p F P
0 g
s
.9 .959 .824 r
.67076 .62661 m .70965 .59507 L .71252 .58154 L p F P
0 g
s
.459 0 0 r
.47327 .72353 m .44531 .706 L .45565 .71016 L p F P
0 g
s
.459 0 0 r
.45565 .71016 m .47933 .72596 L .47327 .72353 L p F P
0 g
s
.96 .83 .672 r
.78833 .43371 m .80139 .40561 L .79223 .38515 L p F P
0 g
s
.994 .805 .543 r
.79749 .36037 m .79223 .38515 L .80139 .40561 L p F P
0 g
s
.004 0 0 r
.57281 .70959 m .54834 .72563 L .54195 .72772 L p F P
0 g
s
0 0 0 r
.54834 .72563 m .57281 .70959 L .58302 .70533 L p F P
0 g
s
.769 .995 .805 r
.661 .64724 m .62031 .67533 L .615 .68228 L p F P
0 g
s
.836 .998 .827 r
.62031 .67533 m .661 .64724 L .66676 .63711 L p F P
0 g
s
.386 0 0 r
.50033 .74155 m .48115 .72935 L p .46766 .7207 L F P
0 g
s
.423 0 0 r
.46766 .7207 m .43574 .70118 L .44243 .70454 L p F P
0 g
s
0 .194 .611 r
.43574 .70118 m .46766 .7207 L .46257 .71753 L p F P
0 g
s
.386 0 0 r
.48115 .72935 m .46257 .71753 L .46766 .7207 L p F P
0 g
s
.423 0 0 r
.44243 .70454 m .44531 .706 L p .46766 .7207 L F P
0 g
s
.423 0 0 r
.44531 .706 m .47327 .72353 L .46766 .7207 L p F P
0 g
s
0 0 0 r
.58302 .70533 m .55432 .72313 L .54834 .72563 L p F P
0 g
s
0 0 0 r
.55432 .72313 m .58302 .70533 L .59244 .70041 L p F P
0 g
s
.973 .769 .568 r
.79223 .38515 m .79749 .36037 L .78467 .34008 L p F P
0 g
s
.971 .658 .296 r
.78247 .31975 m .78467 .34008 L .79749 .36037 L p F P
0 g
s
.917 .932 .804 r
.7473 .53355 m .71308 .56785 L .71252 .58154 L p F P
0 g
s
.915 .896 .795 r
.71308 .56785 m .7473 .53355 L .74534 .51733 L p F P
0 g
s
.931 .903 .775 r
.77307 .48377 m .74534 .51733 L .7473 .53355 L p F P
0 g
s
.921 .866 .767 r
.74534 .51733 m .77307 .48377 L .76791 .46562 L p F P
0 g
s
.945 .871 .734 r
.78833 .43371 m .76791 .46562 L .77307 .48377 L p F P
0 g
s
0 .194 .611 r
.46257 .71753 m .42703 .69574 L .43574 .70118 L p F P
0 g
s
0 0 0 r
.55984 .72025 m .55432 .72313 L p .57175 .71275 L F P
0 g
s
0 0 0 r
.52376 .74297 m .55432 .72313 L .55984 .72025 L p F P
0 g
s
.392 .806 .605 r
.55984 .72025 m .56483 .71703 L p .54749 .72805 L F P
0 g
s
0 0 0 r
.52516 .74224 m .52376 .74297 L p .52684 .74103 L F P
0 g
s
0 0 0 r
.55984 .72025 m .52516 .74224 L p .52684 .74103 L F P
0 g
s
0 0 0 r
.52516 .74224 m .52642 .74142 L p .52347 .74346 L F P
0 g
s
.433 0 0 r
.51344 .74512 m .5139 .74742 L .51335 .74801 L F
.51408 .74835 m .51418 .74885 L .51387 .74889 L F
.324 0 0 r
.51528 .74505 m .51711 .74486 L p .51599 .74721 L F P
0 g
s
.433 0 0 r
.51425 .74917 m .51429 .74939 L .51413 .74932 L F
.51429 .74939 m .51435 .74968 L .51422 .74946 L F
.51429 .74939 m .51422 .74946 L .51413 .74932 L F
.51418 .74885 m .51425 .74917 L .51402 .74913 L F
.51425 .74917 m .51413 .74932 L .51402 .74913 L F
.51418 .74885 m .51402 .74913 L .51387 .74889 L F
.502 0 0 r
.51178 .74736 m .51259 .74836 L .51233 .7485 L F
.522 0 0 r
.51074 .74723 m .51246 .74886 L .51175 .74851 L F
.529 0 0 r
.50459 .74369 m .50624 .74421 L p .50973 .74703 L F P
0 g
s
.52 0 0 r
.50876 .74677 m .51261 .74961 L .51035 .74807 L F
.436 0 0 r
.51267 .74998 m .51329 .7504 L .51327 .75045 L F
.51329 .7504 m .51337 .75046 L .51327 .75045 L F
.53946 .76847 m .51327 .75045 L p .51337 .75046 L F P
0 g
s
0 .172 .631 r
.51328 .75052 m .51987 .75504 L .54174 .77025 L F
.5132 .75046 m .51328 .75052 L .51328 .75052 L F
.51328 .75052 m .51987 .75504 L .51328 .75052 L F
.50033 .74155 m .51327 .75045 L p .5132 .75046 L F P
0 g
s
0 .172 .631 r
.51327 .75045 m .53946 .76847 L p .51336 .75058 L F P
0 g
s
0 .172 .631 r
.51327 .75045 m .51336 .75058 L .5132 .75046 L F
.436 0 0 r
.50033 .74155 m .50162 .74235 L p .50809 .74685 L F P
0 g
s
.436 0 0 r
.51327 .75045 m .50033 .74155 L p .51267 .74998 L F P
0 g
s
.445 0 0 r
.50162 .74235 m .46766 .7207 L .47327 .72353 L p F P
0 g
s
.386 0 0 r
.46766 .7207 m .50162 .74235 L .50033 .74155 L p F P
0 g
s
0 .172 .631 r
.49919 .74066 m .50033 .74155 L p .50986 .74815 L F P
0 g
s
0 .172 .631 r
.53946 .76847 m .54174 .77025 L p .51987 .75504 L F P
0 g
s
.436 0 0 r
.53686 .76685 m .53946 .76847 L p .51345 .75052 L F P
0 g
s
.436 0 0 r
.51329 .7504 m .51345 .75052 L .51345 .75052 L F
.51345 .75052 m .53686 .76685 L .51345 .75052 L F
0 .172 .631 r
.50986 .74815 m .5132 .75046 L .51327 .75045 L F
.5132 .75046 m .51328 .75052 L .51327 .75045 L F
0 .221 .71 r
.51312 .75052 m .5132 .75058 L .51327 .75045 L F
.5132 .75058 m .51328 .75064 L .51327 .75045 L F
0 .172 .631 r
.54174 .77025 m .51327 .75045 L p .51328 .75052 L F P
0 g
s
0 .221 .71 r
.54369 .77216 m .51327 .75045 L p .51328 .75064 L F P
0 g
s
.436 0 0 r
.51327 .75045 m .53686 .76685 L p .51352 .75057 L F P
0 g
s
.436 0 0 r
.51327 .75045 m .51352 .75057 L .51329 .7504 L F
.491 0 0 r
.51361 .7505 m .51327 .75045 L .53686 .76685 L F
.51338 .75034 m .51327 .75045 L .51361 .7505 L F
.759 .99 .776 r
.48101 .77449 m .48253 .77245 L p .50607 .75536 L F P
0 g
s
.759 .99 .776 r
.50703 .75471 m .48101 .77449 L .50607 .75536 L F
.50865 .75352 m .48101 .77449 L .50822 .75381 L F
0 .221 .71 r
.54174 .77025 m .54369 .77216 L p .51343 .75074 L F P
0 g
s
0 .221 .71 r
.51342 .75073 m .54174 .77025 L .51343 .75074 L F
.51327 .75045 m .54174 .77025 L p .51342 .75073 L F P
0 g
s
0 .221 .71 r
.51327 .75045 m .51342 .75073 L .51312 .75052 L F
.491 0 0 r
.51274 .74989 m .51329 .75027 L .51327 .75045 L F
.51148 .749 m .51274 .74989 L .51327 .75045 L F
.52 0 0 r
.51327 .75045 m .53086 .76416 L .53399 .76541 L p F P
0 g
s
.529 0 0 r
.51327 .75045 m .52753 .76312 L p .52091 .75609 L F P
0 g
s
.522 0 0 r
.51327 .75045 m .52403 .76231 L p .51962 .75564 L F P
0 g
s
.491 0 0 r
.51329 .75027 m .51338 .75034 L .51327 .75045 L F
.51338 .75034 m .51368 .75055 L .51327 .75045 L F
.52 0 0 r
.50459 .74369 m .51327 .75045 L p .51232 .7494 L F P
0 g
s
.52 0 0 r
.51261 .74961 m .51327 .75045 L .51349 .75026 L F
.51232 .7494 m .51327 .75045 L .51261 .74961 L F
.51261 .74961 m .51284 .74978 L .51327 .75045 L F
.51284 .74978 m .51349 .75026 L .51327 .75045 L F
.491 0 0 r
.51254 .74974 m .51327 .75045 L .51338 .75034 L F
.50784 .74644 m .51327 .75045 L .51254 .74974 L F
.502 0 0 r
.51327 .75045 m .5204 .76172 L p .51452 .75166 L F P
0 g
s
.472 0 0 r
.51327 .75045 m .51668 .76137 L p .51388 .75123 L F P
0 g
s
.502 0 0 r
.51452 .75166 m .5204 .76172 L .51826 .75526 L F
.472 0 0 r
.51388 .75123 m .51668 .76137 L .51683 .75498 L F
.491 0 0 r
.53686 .76685 m .51327 .75045 L p .51368 .75055 L F P
0 g
s
.491 0 0 r
.51327 .75045 m .53399 .76541 L .53686 .76685 L p F P
0 g
s
.52 0 0 r
.51383 .75052 m .51327 .75045 L .53399 .76541 L F
.51349 .75026 m .51327 .75045 L .51383 .75052 L F
.5135 .75027 m .51327 .75045 L p .51349 .75026 L F P
0 g
s
.52 0 0 r
.5136 .75035 m .53399 .76541 L .51327 .75045 L F
.529 0 0 r
.51361 .75018 m .51327 .75045 L .51376 .7503 L F
.51376 .7503 m .51327 .75045 L .5153 .75155 L F
.5153 .75155 m .51327 .75045 L .5173 .75317 L F
.5173 .75317 m .51327 .75045 L .52091 .75609 L F
.53086 .76416 m .51327 .75045 L p .51361 .75018 L F P
0 g
s
.522 0 0 r
.52753 .76312 m .51327 .75045 L p .51375 .75008 L F P
0 g
s
.529 0 0 r
.51271 .74945 m .51314 .7498 L .51327 .75045 L F
.51314 .7498 m .51361 .75018 L .51327 .75045 L F
.51314 .7498 m .51327 .75045 L .51361 .75018 L F
.51189 .74879 m .51327 .75045 L .51314 .7498 L F
.522 0 0 r
.5133 .74966 m .51327 .75045 L .51375 .75008 L F
.491 0 0 r
.50305 .74307 m .51327 .75045 L p .50784 .74644 L F P
0 g
s
.491 0 0 r
.50305 .74307 m .51148 .749 L .50817 .74677 L F
.52 0 0 r
.51327 .75045 m .50305 .74307 L p .51035 .74807 L F P
0 g
s
.52 0 0 r
.51261 .74961 m .51327 .75045 L .51035 .74807 L F
.436 0 0 r
.51224 .74969 m .51327 .75045 L .51329 .7504 L F
.50162 .74235 m .51327 .75045 L p .51224 .74969 L F P
0 g
s
.384 0 0 r
.51344 .74512 m .51528 .74505 L p .51467 .74931 L F P
0 g
s
.384 0 0 r
.51467 .74931 m .51457 .74996 L .51446 .74948 L F
.51467 .74931 m .51446 .74948 L .51344 .74512 L F
.522 0 0 r
.51375 .75008 m .51327 .75045 L .51962 .75564 L F
.502 0 0 r
.51409 .75019 m .51327 .75045 L p .51392 .74997 L F P
0 g
s
.502 0 0 r
.51456 .75076 m .52403 .76231 L .51485 .75219 L F
.472 0 0 r
.51327 .75045 m .51387 .75118 L .51378 .75087 L F
.51327 .75045 m .51388 .75123 L .51387 .75118 L F
.502 0 0 r
.51331 .74923 m .51362 .75011 L .51384 .74988 L F
.51259 .74836 m .5133 .74957 L .51331 .74923 L F
.5133 .74957 m .51362 .75011 L .51331 .74923 L F
.529 0 0 r
.50973 .74703 m .51327 .75045 L .51189 .74879 L F
.50624 .74421 m .51327 .75045 L p .50973 .74703 L F P
0 g
s
.529 0 0 r
.51238 .74918 m .51271 .74945 L .51327 .75045 L F
.50973 .74703 m .51238 .74918 L .51327 .75045 L F
.52 0 0 r
.50305 .74307 m .50459 .74369 L p .50876 .74677 L F P
0 g
s
.52 0 0 r
.50876 .74677 m .51035 .74807 L .50305 .74307 L F
.529 0 0 r
.51327 .75045 m .50459 .74369 L p .50973 .74703 L F P
0 g
s
.522 0 0 r
.51327 .75045 m .50624 .74421 L p .51313 .74959 L F P
0 g
s
.522 0 0 r
.51375 .75008 m .51327 .75045 L .51313 .74959 L F
.502 0 0 r
.51362 .75011 m .51365 .75017 L .51384 .74988 L F
.51365 .75017 m .51452 .75166 L .51389 .74999 L F
.51365 .75017 m .51389 .74999 L .51384 .74988 L F
.51401 .75032 m .51452 .75166 L .51418 .7503 L F
.51418 .7503 m .51452 .75166 L .51826 .75526 L F
.51415 .75026 m .51401 .75032 L .51418 .7503 L F
.51384 .74988 m .514 .75029 L .51415 .75026 L F
.514 .75029 m .51401 .75032 L .51415 .75026 L F
.472 0 0 r
.51432 .75023 m .51388 .75123 L .51683 .75498 L F
.502 0 0 r
.51376 .74978 m .51392 .74997 L .51327 .75045 L F
.522 0 0 r
.50797 .74461 m .51327 .75045 L p .5133 .74966 L F P
0 g
s
.522 0 0 r
.51246 .74886 m .51284 .74922 L .51264 .74921 L F
.51284 .74922 m .51375 .75008 L .51291 .74943 L F
.51284 .74922 m .51291 .74943 L .51264 .74921 L F
.51246 .74886 m .51264 .74921 L .51175 .74851 L F
.50624 .74421 m .50797 .74461 L p .51074 .74723 L F P
0 g
s
.522 0 0 r
.51074 .74723 m .51175 .74851 L .50624 .74421 L F
.502 0 0 r
.51327 .75045 m .50797 .74461 L p .51376 .74978 L F P
0 g
s
.472 0 0 r
.51283 .74743 m .51359 .75016 L .51406 .74974 L F
.51359 .75016 m .51364 .75036 L .51406 .74974 L F
.502 0 0 r
.51327 .75045 m .51452 .75166 L .51377 .75037 L F
.51327 .75045 m .51362 .75011 L .51259 .74836 L F
.472 0 0 r
.51399 .74961 m .51406 .74974 L .51327 .75045 L F
.51334 .74838 m .51399 .74961 L .51327 .75045 L F
.433 0 0 r
.51344 .74512 m .51327 .75045 L p .51432 .74955 L F P
0 g
s
.502 0 0 r
.51327 .75045 m .51377 .75037 L .51362 .75011 L F
.472 0 0 r
.51364 .75036 m .51366 .75035 L .51406 .74974 L F
.51406 .74974 m .51365 .75037 L .51432 .75023 L F
.51406 .74974 m .51427 .75013 L .51327 .75045 L F
.51327 .75045 m .51378 .75087 L .51359 .75016 L F
.51327 .75045 m .51359 .75016 L .51345 .74964 L F
.433 0 0 r
.5139 .74742 m .51408 .74835 L .51366 .74854 L F
.502 0 0 r
.51303 .7489 m .51376 .74978 L .51307 .74917 L F
.472 0 0 r
.51327 .75045 m .51345 .74964 L .51283 .74743 L F
.502 0 0 r
.51259 .74836 m .51303 .7489 L .51276 .74889 L F
.51303 .7489 m .51307 .74917 L .51276 .74889 L F
.472 0 0 r
.51159 .74507 m .51327 .75045 L p .51283 .74743 L F P
0 g
s
.472 0 0 r
.51283 .74743 m .51334 .74838 L .51327 .75045 L F
.50976 .7449 m .51159 .74507 L p .51283 .74743 L F P
0 g
s
.502 0 0 r
.50976 .7449 m .51327 .75045 L p .51259 .74836 L F P
0 g
s
.502 0 0 r
.51259 .74836 m .51276 .74889 L .51233 .7485 L F
.50797 .74461 m .50976 .7449 L p .51178 .74736 L F P
0 g
s
.502 0 0 r
.51178 .74736 m .51233 .7485 L .50797 .74461 L F
.472 0 0 r
.51327 .75045 m .50976 .7449 L p .51283 .74743 L F P
0 g
s
.433 0 0 r
.51327 .75045 m .51159 .74507 L p .51435 .74968 L F P
0 g
s
.384 0 0 r
.51433 .74959 m .51414 .74974 L .51344 .74512 L F
.51457 .74996 m .51441 .75002 L .5144 .74993 L F
.433 0 0 r
.51432 .74955 m .51327 .75045 L .51443 .75008 L F
.472 0 0 r
.51364 .75036 m .51365 .75037 L .51366 .75035 L F
.51365 .75037 m .51388 .75123 L .51432 .75023 L F
.5204 .76172 m .51327 .75045 L p .51554 .75254 L F P
0 g
s
.433 0 0 r
.51668 .76137 m .51327 .75045 L p .51435 .74968 L F P
0 g
s
.384 0 0 r
.51441 .75002 m .51414 .74974 L .51433 .74959 L F
.433 0 0 r
.51408 .74835 m .51387 .74889 L .51366 .74854 L F
.5139 .74742 m .51366 .74854 L .51335 .74801 L F
.384 0 0 r
.51327 .75045 m .51344 .74512 L p .51414 .74974 L F P
0 g
s
.433 0 0 r
.51443 .75008 m .51327 .75045 L .51489 .75242 L F
.384 0 0 r
.51438 .75128 m .51327 .75045 L .51421 .75015 L F
.51421 .75015 m .51327 .75045 L .51414 .74974 L F
.51457 .74996 m .5144 .74993 L .51455 .74986 L F
.51457 .74996 m .51438 .75128 L .5142 .7501 L F
.51459 .74985 m .51327 .75045 L .51433 .75162 L F
.51528 .74505 m .51327 .75045 L p .5147 .74909 L F P
0 g
s
.384 0 0 r
.51443 .74935 m .5143 .74947 L .51344 .74512 L F
0 .172 .631 r
.51327 .75045 m .49919 .74066 L p .50986 .74815 L F P
0 g
s
0 .221 .71 r
.49919 .74066 m .51327 .75045 L p .51312 .75052 L F P
0 g
s
0 .221 .71 r
.50944 .74792 m .51312 .75052 L .51327 .75045 L F
.49919 .74066 m .50944 .74792 L .51327 .75045 L F
.436 0 0 r
.50162 .74235 m .51267 .74998 L .50809 .74685 L F
.491 0 0 r
.50162 .74235 m .50305 .74307 L p .50817 .74677 L F P
0 g
s
.491 0 0 r
.51327 .75045 m .50162 .74235 L p .51148 .749 L F P
0 g
s
.479 0 0 r
.50305 .74307 m .47327 .72353 L .47933 .72596 L p F P
0 g
s
.445 0 0 r
.47327 .72353 m .50305 .74307 L .50162 .74235 L p F P
0 g
s
0 .221 .71 r
.51327 .75045 m .49822 .73971 L .49919 .74066 L p F P
0 g
s
.324 0 0 r
.51327 .75045 m .51528 .74505 L p .51372 .75027 L F P
0 g
s
.324 0 0 r
.51371 .7503 m .51327 .75045 L .51372 .75027 L F
.384 0 0 r
.5147 .74909 m .51327 .75045 L .51459 .74985 L F
.51455 .74986 m .5144 .74993 L .5143 .74947 L F
.51455 .74986 m .5143 .74947 L .51443 .74935 L F
.51441 .75002 m .5142 .7501 L .51414 .74974 L F
.324 0 0 r
.51711 .74486 m .51327 .75045 L p .5148 .74968 L F P
0 g
s
.324 0 0 r
.51599 .74721 m .51389 .74971 L .51528 .74505 L F
.253 0 0 r
.51327 .75045 m .51711 .74486 L p .51425 .7497 L F P
0 g
s
.873 .797 .771 r
.51138 .75151 m .51327 .75045 L .51182 .751 L F
.51187 .75089 m .51138 .75151 L .51193 .75087 L F
.50714 .75691 m .50451 .7607 L .50026 .76568 L F
.253 0 0 r
.51711 .74486 m .51889 .74456 L p .51487 .74971 L F P
0 g
s
.253 0 0 r
.51487 .74971 m .51485 .74972 L .51711 .74486 L F
.51483 .74977 m .51481 .74978 L .51711 .74486 L F
.51479 .74982 m .51478 .74982 L .5148 .74978 L F
.51481 .74978 m .5148 .74978 L .51711 .74486 L F
.51479 .74982 m .5148 .74978 L .51481 .74978 L F
.873 .797 .771 r
.51173 .75106 m .50886 .7551 L .50714 .75691 L F
.291 0 0 r
.51528 .74505 m .52115 .73132 L .52828 .73058 L p F P
0 g
s
.291 0 0 r
.52828 .73058 m .51711 .74486 L .51528 .74505 L p F P
0 g
s
.873 .797 .771 r
.52836 .72985 m .51066 .75277 L .51173 .75106 L F
.253 0 0 r
.51476 .74986 m .51475 .74987 L .51476 .74983 L F
.51478 .74982 m .51476 .74983 L .51711 .74486 L F
.51476 .74986 m .51476 .74983 L .51478 .74982 L F
.899 .859 .792 r
.48016 .78763 m .4793 .78546 L p .51168 .75111 L F P
0 g
s
.324 0 0 r
.5148 .74968 m .51327 .75045 L .51406 .75122 L F
.51599 .74721 m .51471 .74987 L .51389 .74971 L F
.51471 .74987 m .51469 .74991 L .51463 .7499 L F
.51471 .74987 m .51463 .7499 L .51389 .74971 L F
.51469 .74991 m .51462 .74994 L .51389 .74971 L F
.51467 .74995 m .51377 .75027 L .51377 .75026 L F
.51462 .74994 m .51377 .75026 L .51389 .74971 L F
.51467 .74995 m .51377 .75026 L .51462 .74994 L F
.253 0 0 r
.51476 .74983 m .51398 .75015 L .51711 .74486 L F
.218 0 0 r
.51711 .74486 m .52828 .73058 L .53524 .72937 L p F P
0 g
s
.218 0 0 r
.53524 .72937 m .51889 .74456 L .51711 .74486 L p F P
0 g
s
.873 .797 .771 r
.52836 .72985 m .51327 .75045 L .51211 .75089 L F
.51211 .75089 m .51327 .75045 L .51208 .75093 L F
.51327 .75045 m .52916 .73087 L p .51182 .751 L F P
0 g
s
.887 .826 .781 r
.51327 .75045 m .52976 .73193 L p .5125 .7507 L F P
0 g
s
.887 .826 .781 r
.51243 .75078 m .51327 .75045 L .5125 .7507 L F
0 .221 .71 r
.51312 .75052 m .51342 .75073 L .51343 .75074 L F
.433 0 0 r
.51327 .75045 m .51293 .76127 L p .51537 .7548 L F P
0 g
s
.384 0 0 r
.51322 .75193 m .51327 .75045 L p .51359 .75069 L F P
0 g
s
.433 0 0 r
.51489 .75242 m .51327 .75045 L .51537 .7548 L F
.384 0 0 r
.51438 .75128 m .51322 .75193 L .51359 .75069 L F
.51293 .76127 m .51322 .75193 L p .51438 .75128 L F P
0 g
s
.384 0 0 r
.51388 .75471 m .51327 .75045 L .51293 .76127 L F
.324 0 0 r
.51318 .75305 m .51322 .75193 L .51371 .7503 L F
.51377 .75029 m .51371 .7503 L .51389 .74971 L F
.384 0 0 r
.51423 .75233 m .51327 .75045 L .51412 .75308 L F
.324 0 0 r
.51318 .75305 m .51371 .7503 L .51377 .75029 L F
.873 .797 .771 r
.51187 .75089 m .51193 .75087 L .52916 .73087 L F
.887 .826 .781 r
.51172 .75106 m .51243 .75078 L .52976 .73193 L F
.48141 .78973 m .48016 .78763 L p .49984 .76482 L F P
0 g
s
.873 .797 .771 r
.512 .75103 m .51327 .75045 L p .50886 .7551 L F P
0 g
s
.873 .797 .771 r
.51066 .75277 m .50886 .7551 L .51026 .75312 L F
.51066 .75277 m .51026 .75312 L .51173 .75106 L F
.51327 .75045 m .48302 .79173 L p .50714 .75691 L F P
0 g
s
.873 .797 .771 r
.51138 .75151 m .51121 .75172 L .51327 .75045 L F
.384 0 0 r
.51433 .75162 m .51327 .75045 L .51429 .7519 L F
.51429 .7519 m .51327 .75045 L .51423 .75233 L F
.51412 .75308 m .51327 .75045 L .51388 .75471 L F
.324 0 0 r
.51467 .74995 m .51318 .75305 L .51377 .75027 L F
.51371 .75031 m .51327 .75045 L .51371 .7503 L F
.51356 .75082 m .51327 .75045 L .51371 .75031 L F
.253 0 0 r
.51399 .75013 m .51327 .75045 L .51414 .74989 L F
.51414 .74989 m .51327 .75045 L .51425 .7497 L F
.324 0 0 r
.51353 .75091 m .51327 .75045 L .51356 .75082 L F
.51348 .75106 m .51327 .75045 L .51353 .75091 L F
.5134 .75133 m .51327 .75045 L .51348 .75106 L F
.253 0 0 r
.51339 .75116 m .51327 .75045 L .51399 .75013 L F
.324 0 0 r
.51469 .74991 m .51467 .74995 L .51462 .74994 L F
.253 0 0 r
.51889 .74456 m .51327 .75045 L p .51391 .75095 L F P
0 g
s
.166 0 0 r
.51327 .75045 m .51889 .74456 L p .51337 .75097 L F P
0 g
s
.253 0 0 r
.51473 .7499 m .51396 .75019 L .51398 .75015 L F
.51473 .7499 m .51398 .75015 L .51476 .74983 L F
.51487 .74971 m .51483 .74977 L .51485 .74972 L F
.384 0 0 r
.51327 .75045 m .50918 .76141 L .51293 .76127 L p F P
0 g
s
.324 0 0 r
.51327 .75045 m .50547 .76179 L p .51399 .75137 L F P
0 g
s
.324 0 0 r
.51239 .75472 m .51327 .75045 L .5134 .75133 L F
.253 0 0 r
.51379 .75111 m .51225 .75308 L .51358 .75084 L F
.324 0 0 r
.51406 .75122 m .51327 .75045 L .51399 .75137 L F
.253 0 0 r
.51379 .75111 m .51358 .75084 L .51396 .75019 L F
.51473 .7499 m .51379 .75111 L .51396 .75019 L F
.324 0 0 r
.50918 .76141 m .51327 .75045 L p .51239 .75472 L F P
0 g
s
.253 0 0 r
.51225 .75308 m .51327 .75045 L .51323 .75142 L F
.51391 .75095 m .51327 .75045 L .51383 .75105 L F
.51383 .75105 m .51327 .75045 L .51374 .75118 L F
.873 .797 .771 r
.51121 .75172 m .50026 .76568 L .51327 .75045 L F
.48141 .78973 m .51327 .75045 L p .50026 .76568 L F P
0 g
s
.887 .826 .781 r
.51127 .75159 m .51327 .75045 L .49984 .76482 L F
.52916 .73087 m .51327 .75045 L p .51127 .75159 L F P
0 g
s
.166 0 0 r
.51889 .74456 m .5206 .74414 L p .51795 .74672 L F P
0 g
s
.873 .797 .771 r
.48302 .79173 m .48141 .78973 L p .50026 .76568 L F P
0 g
s
.873 .797 .771 r
.50451 .7607 m .48302 .79173 L .50026 .76568 L F
.887 .826 .781 r
.51327 .75045 m .48141 .78973 L p .49984 .76482 L F P
0 g
s
.887 .826 .781 r
.50477 .75912 m .51327 .75045 L .51243 .75078 L F
.48016 .78763 m .51327 .75045 L p .50477 .75912 L F P
0 g
s
.166 0 0 r
.51795 .74672 m .5136 .75096 L .51501 .74906 L F
.5206 .74414 m .51327 .75045 L p .51341 .75116 L F P
0 g
s
.062 0 0 r
.5175 .74751 m .51327 .75045 L .51573 .74896 L F
.166 0 0 r
.5136 .75096 m .5135 .75081 L .51501 .74906 L F
.899 .859 .792 r
.51327 .75045 m .48016 .78763 L p .51251 .75096 L F P
0 g
s
.887 .826 .781 r
.51168 .75111 m .51107 .75182 L .51239 .75082 L F
.51168 .75111 m .51239 .75082 L .51243 .75078 L F
.51172 .75106 m .51168 .75111 L .51243 .75078 L F
.51107 .75182 m .50916 .75403 L .51193 .75129 L F
.51107 .75182 m .51193 .75129 L .51243 .75078 L F
.50916 .75403 m .50477 .75912 L .5106 .75278 L F
.50916 .75403 m .5106 .75278 L .51243 .75078 L F
.899 .859 .792 r
.51278 .75065 m .48016 .78763 L .51168 .75111 L F
.253 0 0 r
.51327 .75045 m .50186 .76241 L p .51374 .75118 L F P
0 g
s
.166 0 0 r
.51795 .74672 m .51501 .74906 L .51889 .74456 L F
.253 0 0 r
.51323 .75142 m .51327 .75045 L .51339 .75116 L F
.50547 .76179 m .51327 .75045 L p .51225 .75308 L F P
0 g
s
.166 0 0 r
.51219 .75234 m .51327 .75045 L .51337 .75097 L F
.062 0 0 r
.5206 .74414 m .52223 .74361 L p .51215 .75191 L F P
0 g
s
.062 0 0 r
.51327 .75045 m .5206 .74414 L p .51215 .75191 L F P
0 g
s
0 0 0 r
.52376 .74297 m .51327 .75045 L p .51661 .7483 L F P
0 g
s
.062 0 0 r
.51573 .74896 m .51327 .75045 L .51349 .75081 L F
0 0 0 r
.52223 .74361 m .52376 .74297 L p .51274 .75118 L F P
0 g
s
0 0 0 r
.51754 .74761 m .51535 .74916 L .51327 .75045 L F
.51248 .75137 m .51253 .75132 L .52223 .74361 L F
.51327 .75045 m .51522 .74921 L .51754 .74761 L F
.062 0 0 r
.52223 .74361 m .51327 .75045 L p .5175 .74751 L F P
0 g
s
.166 0 0 r
.50186 .76241 m .51327 .75045 L p .51219 .75234 L F P
0 g
s
0 0 0 r
.51327 .75045 m .52223 .74361 L p .51213 .75164 L F P
0 g
s
0 0 0 r
.51327 .75045 m .51321 .7505 L .51476 .74945 L F
.51274 .75118 m .51276 .75115 L .52223 .74361 L F
.52516 .74224 m .51327 .75045 L p .51754 .74761 L F P
0 g
s
0 0 0 r
.51327 .75045 m .52376 .74297 L p .51754 .74761 L F P
0 g
s
0 0 0 r
.51327 .75045 m .51476 .74945 L .51901 .74653 L F
.899 .859 .792 r
.51327 .75045 m .51251 .75096 L .51258 .75088 L F
.51327 .75045 m .51258 .75088 L .51278 .75065 L F
.51168 .75111 m .51062 .75224 L .51183 .75105 L F
.908 .893 .803 r
.51178 .7511 m .51067 .75219 L .51164 .75116 L F
.899 .859 .792 r
.51062 .75224 m .51327 .75045 L .51759 .74539 L F
.908 .893 .803 r
.51327 .75045 m .51067 .75219 L .51178 .7511 L F
.899 .859 .792 r
.51062 .75224 m .49959 .76394 L .51327 .75045 L F
.4793 .78546 m .51327 .75045 L p .49959 .76394 L F P
0 g
s
.908 .893 .803 r
.51327 .75045 m .4793 .78546 L p .51067 .75219 L F P
0 g
s
0 0 0 r
.51327 .75045 m .51247 .75121 L .51473 .74962 L F
.51295 .75077 m .51292 .75079 L .51504 .74934 L F
.51327 .75045 m .51473 .74962 L .51661 .7483 L F
.515 .74937 m .51504 .74934 L .51576 .74884 L F
.51295 .75077 m .51504 .74934 L .515 .74937 L F
.166 0 0 r
.5136 .75096 m .51219 .75234 L .5135 .75081 L F
.129 0 0 r
.51889 .74456 m .53524 .72937 L .54195 .72772 L p F P
0 g
s
.129 0 0 r
.54195 .72772 m .5206 .74414 L .51889 .74456 L p F P
0 g
s
.899 .859 .792 r
.51327 .75045 m .53017 .73303 L p .51759 .74539 L F P
0 g
s
0 0 0 r
.51535 .74916 m .51523 .74924 L .51327 .75045 L F
.908 .893 .803 r
.4793 .78546 m .47884 .78325 L p .51164 .75116 L F P
0 g
s
.908 .893 .803 r
.51071 .75207 m .51074 .75205 L .51084 .75195 L F
.51169 .75117 m .51327 .75045 L .51177 .75111 L F
.51071 .75207 m .51034 .75243 L .51327 .75045 L F
.47884 .78325 m .51327 .75045 L p .51034 .75243 L F P
0 g
s
.908 .893 .803 r
.51164 .75116 m .51071 .75207 L .51177 .75111 L F
0 0 0 r
.51549 .74902 m .51522 .74921 L .51576 .74884 L F
.51522 .74921 m .51284 .75084 L .51543 .74907 L F
.51522 .74921 m .51543 .74907 L .51576 .74884 L F
.91 .927 .813 r
.51327 .75045 m .47884 .78325 L p .51069 .75209 L F P
0 g
s
.91 .927 .813 r
.51327 .75045 m .51069 .75209 L .51158 .75122 L F
.47884 .78325 m .47878 .78102 L p .51158 .75122 L F P
0 g
s
.91 .927 .813 r
.49955 .76216 m .51327 .75045 L .51273 .75067 L F
.51046 .75224 m .50474 .75744 L .5121 .75119 L F
.903 .96 .819 r
.51207 .75122 m .50547 .75682 L .5106 .75217 L F
.91 .927 .813 r
.50474 .75744 m .5084 .75444 L .51289 .75053 L F
.903 .96 .819 r
.51327 .75045 m .50547 .75682 L .51207 .75122 L F
.91 .927 .813 r
.50474 .75744 m .49955 .76216 L .5084 .75444 L F
.47878 .78102 m .51327 .75045 L p .49955 .76216 L F P
0 g
s
.903 .96 .819 r
.51327 .75045 m .47878 .78102 L p .50547 .75682 L F P
0 g
s
.899 .859 .792 r
.51327 .75045 m .51278 .75065 L .51281 .75063 L F
.51327 .75045 m .51281 .75063 L .51282 .75061 L F
.51478 .74839 m .51278 .75065 L .51206 .75095 L F
.908 .893 .803 r
.51177 .75111 m .51327 .75045 L .51193 .75096 L F
.51179 .75101 m .51327 .75045 L .51164 .75116 L F
.91 .927 .813 r
.51176 .75106 m .51327 .75045 L .51158 .75122 L F
.51219 .75068 m .51046 .75224 L .51289 .75053 L F
.51046 .75224 m .5121 .75119 L .51289 .75053 L F
.903 .96 .819 r
.51327 .75045 m .5106 .75217 L .5122 .75072 L F
.899 .859 .792 r
.51168 .75111 m .51183 .75105 L .53017 .73303 L F
.903 .96 .819 r
.47878 .78102 m .47912 .7788 L p .5122 .75072 L F P
0 g
s
.903 .96 .819 r
.51152 .75136 m .51327 .75045 L .51225 .75077 L F
.51015 .75246 m .51327 .75045 L .51152 .75136 L F
.899 .859 .792 r
.51327 .75045 m .51282 .75061 L .5149 .74825 L F
.51327 .75045 m .5149 .74825 L .52256 .73957 L F
.51478 .74839 m .51206 .75095 L .51168 .75111 L F
.52976 .73193 m .51327 .75045 L p .52256 .73957 L F P
0 g
s
.908 .893 .803 r
.51193 .75096 m .51327 .75045 L .51773 .74567 L F
.899 .859 .792 r
.52256 .73957 m .51478 .74839 L .51168 .75111 L F
.908 .893 .803 r
.53017 .73303 m .51327 .75045 L p .51179 .75101 L F P
0 g
s
.908 .893 .803 r
.51164 .75116 m .51177 .75111 L .53039 .73414 L F
.91 .927 .813 r
.51846 .74497 m .51327 .75045 L .51176 .75106 L F
.903 .96 .819 r
.51225 .75077 m .51327 .75045 L .51249 .75058 L F
.47912 .7788 m .51327 .75045 L p .51015 .75246 L F P
0 g
s
.88 .986 .819 r
.51327 .75045 m .47912 .7788 L p .51236 .75065 L F P
0 g
s
.166 0 0 r
.51327 .75045 m .49839 .76326 L p .51341 .75116 L F P
0 g
s
.903 .96 .819 r
.51191 .75097 m .51015 .75246 L .51211 .75089 L F
.88 .986 .819 r
.47912 .7788 m .47987 .77662 L p .51236 .75065 L F P
0 g
s
.88 .986 .819 r
.47987 .77662 m .51327 .75045 L p .50973 .75275 L F P
0 g
s
.834 1 .807 r
.47987 .77662 m .48101 .77449 L p .51057 .75208 L F P
0 g
s
.903 .96 .819 r
.51233 .75061 m .51327 .75045 L .5122 .75072 L F
.88 .986 .819 r
.51269 .75038 m .50973 .75275 L .51327 .75045 L F
.834 1 .807 r
.51311 .75016 m .51107 .75178 L .51057 .75208 L F
.51107 .75178 m .47987 .77662 L .51057 .75208 L F
.51327 .75045 m .47987 .77662 L p .51311 .75016 L F P
0 g
s
.062 0 0 r
.51327 .75045 m .49509 .76433 L p .51349 .75081 L F P
0 g
s
.062 0 0 r
.49839 .76326 m .51327 .75045 L p .51215 .75191 L F P
0 g
s
0 0 0 r
.51213 .75164 m .5128 .75083 L .51318 .75054 L F
.5128 .75083 m .51283 .75078 L .51297 .75069 L F
.5128 .75083 m .51297 .75069 L .51318 .75054 L F
.51523 .74924 m .51171 .75172 L .51327 .75045 L F
.908 .893 .803 r
.51327 .75045 m .53039 .73414 L p .51773 .74567 L F P
0 g
s
.91 .927 .813 r
.53039 .73414 m .51327 .75045 L p .51846 .74497 L F P
0 g
s
.91 .927 .813 r
.51273 .75067 m .51327 .75045 L .51498 .74871 L F
.51498 .74871 m .51327 .75045 L .51548 .74827 L F
.51327 .75045 m .5304 .73526 L p .51548 .74827 L F P
0 g
s
.91 .927 .813 r
.51219 .75068 m .51289 .75053 L .5304 .73526 L F
.903 .96 .819 r
.5304 .73526 m .51327 .75045 L p .51233 .75061 L F P
0 g
s
.023 0 0 r
.5206 .74414 m .54195 .72772 L .54834 .72563 L p F P
0 g
s
.023 0 0 r
.54834 .72563 m .52223 .74361 L .5206 .74414 L p F P
0 g
s
.903 .96 .819 r
.51327 .75045 m .53021 .73638 L p .51249 .75058 L F P
0 g
s
.88 .986 .819 r
.52305 .74211 m .51327 .75045 L .51236 .75065 L F
.903 .96 .819 r
.51191 .75097 m .51211 .75089 L .53021 .73638 L F
.88 .986 .819 r
.51327 .75045 m .52983 .73748 L p .51269 .75038 L F P
0 g
s
.834 1 .807 r
.51183 .75117 m .51512 .74881 L .5118 .75118 L F
.51512 .74881 m .51533 .74865 L .51512 .7488 L F
.51512 .74881 m .51512 .7488 L .5118 .75118 L F
.253 0 0 r
.51483 .74977 m .51479 .74982 L .51481 .74978 L F
.899 .859 .792 r
.53017 .73303 m .52976 .73193 L p .51168 .75111 L F P
0 g
s
.253 0 0 r
.51479 .74982 m .51476 .74986 L .51478 .74982 L F
.51476 .74986 m .51473 .7499 L .51475 .74987 L F
.887 .826 .781 r
.52976 .73193 m .52916 .73087 L p .51184 .75092 L F P
0 g
s
.887 .826 .781 r
.51184 .75092 m .51172 .75106 L .51186 .75092 L F
.51184 .75092 m .51186 .75092 L .52976 .73193 L F
.873 .797 .771 r
.52916 .73087 m .52836 .72985 L p .51187 .75089 L F P
0 g
s
0 0 0 r
.51508 .74944 m .51247 .75121 L .51164 .752 L F
.51661 .7483 m .51464 .74968 L .51508 .74944 L F
.51464 .74968 m .51247 .75121 L .51508 .74944 L F
.834 1 .807 r
.48101 .77449 m .51327 .75045 L p .50784 .75415 L F P
0 g
s
.759 .99 .776 r
.50974 .7528 m .48101 .77449 L .50865 .75352 L F
.834 1 .807 r
.50913 .75317 m .51327 .75045 L .51315 .75024 L F
.50913 .75317 m .50784 .75415 L .51327 .75045 L F
.759 .99 .776 r
.51327 .75045 m .48101 .77449 L p .51291 .7504 L F P
0 g
s
.834 1 .807 r
.51057 .75208 m .51093 .75186 L .51219 .75094 L F
.51057 .75208 m .50913 .75317 L .51093 .75186 L F
.759 .99 .776 r
.48253 .77245 m .51327 .75045 L p .51301 .75033 L F P
0 g
s
.649 .949 .723 r
.51327 .75045 m .48253 .77245 L p .51308 .75038 L F P
0 g
s
0 0 0 r
.49201 .76561 m .49509 .76433 L p .51164 .752 L F P
0 g
s
0 0 0 r
.51247 .75121 m .49201 .76561 L .51164 .752 L F
.834 1 .807 r
.51204 .75101 m .51533 .74865 L .5155 .74851 L F
.5118 .75118 m .51205 .75101 L .51204 .75101 L F
.51205 .75101 m .51533 .74865 L .51204 .75101 L F
.51057 .75208 m .51183 .75117 L .5118 .75118 L F
0 0 0 r
.51327 .75045 m .49201 .76561 L p .51247 .75121 L F P
0 g
s
0 0 0 r
.51283 .75078 m .51327 .75045 L p .51318 .75054 L F P
0 g
s
0 0 0 r
.49509 .76433 m .51283 .75078 L p .51213 .75164 L F P
0 g
s
0 0 0 r
.49201 .76561 m .51327 .75045 L p .51171 .75172 L F P
0 g
s
.88 .986 .819 r
.53021 .73638 m .51327 .75045 L p .52305 .74211 L F P
0 g
s
.834 1 .807 r
.5155 .74851 m .5164 .74788 L .51673 .74762 L F
.51533 .74865 m .5164 .74788 L .5155 .74851 L F
.51207 .751 m .51219 .75094 L .5164 .74788 L F
.51057 .75208 m .51219 .75094 L .51207 .751 L F
0 0 0 r
.51327 .75045 m .51254 .75104 L .51284 .75084 L F
.51327 .75045 m .51284 .75084 L .51501 .74935 L F
.51327 .75045 m .51203 .75139 L .51254 .75104 L F
.51494 .74932 m .51327 .75045 L .51506 .74924 L F
.51327 .75045 m .51501 .74935 L .51522 .74921 L F
.51262 .75093 m .51327 .75045 L .51494 .74932 L F
.51327 .75045 m .52516 .74224 L p .51506 .74924 L F P
0 g
s
.759 .99 .776 r
.51037 .75232 m .50974 .7528 L .50945 .75291 L F
.50974 .7528 m .50865 .75352 L .50945 .75291 L F
.50822 .75381 m .50703 .75471 L .50607 .75536 L F
.50945 .75291 m .50865 .75352 L .50822 .75381 L F
.649 .949 .723 r
.48253 .77245 m .48441 .77052 L p .51308 .75038 L F P
0 g
s
.649 .949 .723 r
.48441 .77052 m .51327 .75045 L p .51276 .75061 L F P
0 g
s
.511 .874 .647 r
.48441 .77052 m .48664 .76873 L p .51325 .75037 L F P
0 g
s
.511 .874 .647 r
.51327 .75045 m .48441 .77052 L p .51325 .75037 L F P
0 g
s
0 0 0 r
.51327 .75045 m .48918 .76708 L p .51203 .75139 L F P
0 g
s
.908 .893 .803 r
.53039 .73414 m .53017 .73303 L p .51164 .75116 L F P
0 g
s
0 0 0 r
.52223 .74361 m .54834 .72563 L .55432 .72313 L p F P
0 g
s
0 0 0 r
.55432 .72313 m .52376 .74297 L .52223 .74361 L p F P
0 g
s
.834 1 .807 r
.51673 .74762 m .5164 .74788 L .52925 .73854 L F
0 0 0 r
.51254 .75104 m .51246 .75111 L .51292 .75079 L F
.51254 .75104 m .51292 .75079 L .51295 .75077 L F
.51284 .75084 m .51271 .75093 L .51284 .75084 L F
.51284 .75084 m .51284 .75084 L .51576 .74884 L F
.91 .927 .813 r
.5304 .73526 m .53039 .73414 L p .51219 .75068 L F P
0 g
s
0 0 0 r
.5121 .75129 m .51327 .75045 L .51262 .75093 L F
.51284 .75084 m .51284 .75084 L .51295 .75077 L F
.51295 .75076 m .51295 .75077 L .51576 .74884 L F
.51284 .75084 m .51295 .75077 L .51295 .75076 L F
.51271 .75093 m .51271 .75093 L .51284 .75084 L F
.51271 .75093 m .51284 .75084 L .51284 .75084 L F
.472 0 0 r
.51454 .75065 m .51554 .75254 L .51478 .75184 L F
0 0 0 r
.51271 .75093 m .51254 .75104 L .51271 .75093 L F
.51254 .75104 m .48918 .76708 L .51246 .75111 L F
.903 .96 .819 r
.53021 .73638 m .5304 .73526 L p .51191 .75097 L F P
0 g
s
0 0 0 r
.51588 .74875 m .51549 .74902 L .51621 .74854 L F
.51549 .74902 m .51576 .74884 L .51621 .74854 L F
.51648 .74834 m .51588 .74875 L .51689 .74807 L F
.51588 .74875 m .51621 .74854 L .51689 .74807 L F
.48664 .76873 m .48918 .76708 L p .51276 .75084 L F P
0 g
s
0 0 0 r
.51342 .75038 m .51279 .75081 L .51276 .75084 L F
.51279 .75081 m .48664 .76873 L .51276 .75084 L F
.166 0 0 r
.49839 .76326 m .50186 .76241 L p .51341 .75116 L F P
0 g
s
0 0 0 r
.51163 .75159 m .51133 .7518 L .51308 .7506 L F
.5131 .75058 m .51308 .7506 L .51786 .74732 L F
.51163 .75159 m .51308 .7506 L .5131 .75058 L F
.88 .986 .819 r
.52983 .73748 m .53021 .73638 L p .51269 .75038 L F P
0 g
s
0 0 0 r
.51327 .75045 m .48664 .76873 L p .51321 .7505 L F P
0 g
s
.324 0 0 r
.50547 .76179 m .50918 .76141 L p .51399 .75137 L F P
0 g
s
.834 1 .807 r
.52983 .73748 m .51327 .75045 L p .51311 .75016 L F P
0 g
s
0 0 0 r
.51699 .74791 m .51316 .75054 L .51786 .74732 L F
.51316 .75054 m .51311 .75058 L .51316 .75054 L F
.51316 .75054 m .51316 .75054 L .51786 .74732 L F
.51311 .75058 m .51163 .75159 L .5131 .75058 L F
.51311 .75058 m .5131 .75058 L .51786 .74732 L F
.51163 .75159 m .48664 .76873 L .51133 .7518 L F
.834 1 .807 r
.51327 .75045 m .52925 .73854 L p .51315 .75024 L F P
0 g
s
0 0 0 r
.51786 .74732 m .51336 .75041 L .51342 .75038 L F
.51336 .75041 m .48664 .76873 L .51342 .75038 L F
.51901 .74653 m .51699 .74791 L .51786 .74732 L F
.48918 .76708 m .49201 .76561 L p .51325 .75064 L F P
0 g
s
0 0 0 r
.51689 .74807 m .51326 .75056 L .51325 .75064 L F
.51326 .75056 m .48918 .76708 L .51325 .75064 L F
.834 1 .807 r
.52925 .73854 m .52983 .73748 L p .51285 .75035 L F P
0 g
s
.834 1 .807 r
.51285 .75035 m .51057 .75208 L .51293 .75037 L F
.51285 .75035 m .51293 .75037 L .52925 .73854 L F
0 0 0 r
.51754 .74761 m .51648 .74834 L .51689 .74807 L F
.52376 .74297 m .52516 .74224 L p .51754 .74761 L F P
0 g
s
.392 .806 .605 r
.52516 .74224 m .55984 .72025 L p .54749 .72805 L F P
0 g
s
.392 .806 .605 r
.52642 .74142 m .52516 .74224 L p .52854 .74009 L F P
0 g
s
.392 .806 .605 r
.56483 .71703 m .52642 .74142 L p .52854 .74009 L F P
0 g
s
.511 .874 .647 r
.52642 .74142 m .52753 .74053 L p .52429 .74276 L F P
0 g
s
.759 .99 .776 r
.52925 .73854 m .51327 .75045 L p .51291 .7504 L F P
0 g
s
.511 .874 .647 r
.52429 .74276 m .51325 .75037 L .52642 .74142 L F
0 0 0 r
.52642 .74142 m .51327 .75045 L p .51901 .74653 L F P
0 g
s
.759 .99 .776 r
.51291 .7504 m .51037 .75232 L .50945 .75291 L F
.52848 .73956 m .52925 .73854 L p .51301 .75033 L F P
0 g
s
.759 .99 .776 r
.51327 .75045 m .52848 .73956 L p .51301 .75033 L F P
0 g
s
.062 0 0 r
.49509 .76433 m .49839 .76326 L p .51349 .75081 L F P
0 g
s
0 0 0 r
.51258 .75096 m .51262 .75093 L .5134 .75039 L F
.51341 .75039 m .5134 .75039 L .52516 .74224 L F
.51258 .75096 m .5134 .75039 L .51341 .75039 L F
.52347 .74346 m .51325 .7505 L .52516 .74224 L F
.511 .874 .647 r
.51327 .75045 m .52642 .74142 L p .51333 .75032 L F P
0 g
s
.649 .949 .723 r
.51325 .75026 m .51327 .75045 L .51308 .75038 L F
.51327 .75045 m .52753 .74053 L p .51317 .75032 L F P
0 g
s
.511 .874 .647 r
.51316 .75044 m .51327 .75045 L .51333 .75032 L F
0 0 0 r
.51276 .75084 m .51277 .75083 L .51334 .75044 L F
.51334 .75044 m .51334 .75044 L .52516 .74224 L F
.51276 .75084 m .51334 .75044 L .51334 .75044 L F
.649 .949 .723 r
.52848 .73956 m .51327 .75045 L p .51325 .75026 L F P
0 g
s
.649 .949 .723 r
.51317 .75032 m .51276 .75061 L .51327 .75045 L F
.511 .874 .647 r
.51325 .75037 m .51316 .75044 L .51325 .75038 L F
.51325 .75037 m .51325 .75038 L .52642 .74142 L F
.529 0 0 r
.52753 .76312 m .53086 .76416 L p .52091 .75609 L F P
0 g
s
.649 .949 .723 r
.52753 .74053 m .52848 .73956 L p .51317 .75032 L F P
0 g
s
.511 .874 .647 r
.52753 .74053 m .51327 .75045 L p .51325 .75037 L F P
0 g
s
0 0 0 r
.51325 .7505 m .51325 .7505 L .51334 .75044 L F
.51334 .75044 m .51334 .75044 L .52516 .74224 L F
.51325 .7505 m .51334 .75044 L .51334 .75044 L F
.51315 .75057 m .51316 .75056 L .51325 .7505 L F
.51315 .75057 m .51325 .7505 L .51325 .7505 L F
.51304 .75065 m .51305 .75064 L .51316 .75056 L F
.51304 .75065 m .51316 .75056 L .51315 .75057 L F
.511 .874 .647 r
.48664 .76873 m .51327 .75045 L p .51316 .75044 L F P
0 g
s
0 0 0 r
.51325 .7505 m .51304 .75065 L .51325 .7505 L F
.51325 .7505 m .51325 .7505 L .52516 .74224 L F
.253 0 0 r
.50186 .76241 m .50547 .76179 L p .51287 .75229 L F P
0 g
s
.253 0 0 r
.51374 .75118 m .51295 .75192 L .51287 .75229 L F
.51295 .75192 m .50186 .76241 L .51287 .75229 L F
0 0 0 r
.51304 .75065 m .51276 .75084 L .51305 .75064 L F
.522 0 0 r
.52403 .76231 m .52753 .76312 L p .51962 .75564 L F P
0 g
s
.502 0 0 r
.5204 .76172 m .52403 .76231 L p .51826 .75526 L F P
0 g
s
.472 0 0 r
.51668 .76137 m .5204 .76172 L p .51683 .75498 L F P
0 g
s
0 0 0 r
.51276 .75084 m .51258 .75096 L .51277 .75083 L F
.51258 .75096 m .5121 .75129 L .51262 .75093 L F
.433 0 0 r
.51293 .76127 m .51668 .76137 L p .51537 .7548 L F P
0 g
s
0 0 0 r
.51274 .75118 m .51248 .75137 L .51276 .75115 L F
.51248 .75137 m .51213 .75164 L .51253 .75132 L F
.324 0 0 r
.51318 .75305 m .51239 .75472 L .51322 .75193 L F
.433 0 0 r
.51159 .74507 m .51344 .74512 L p .51335 .74801 L F P
0 g
s
0 0 0 r
.48918 .76708 m .51327 .75045 L p .5121 .75129 L F P
0 g
s
0 0 0 r
.59244 .70041 m .55984 .72025 L p .57175 .71275 L F P
0 g
s
.408 .82 .626 r
.55984 .72025 m .59244 .70041 L .60098 .69489 L p F P
0 g
s
.9 .959 .824 r
.71252 .58154 m .67294 .61587 L .67076 .62661 L p F P
0 g
s
.907 .926 .817 r
.67294 .61587 m .71252 .58154 L .71308 .56785 L p F P
0 g
s
.929 .832 .729 r
.76791 .46562 m .78833 .43371 L .77953 .41433 L p F P
0 g
s
.96 .83 .672 r
.79223 .38515 m .77953 .41433 L .78833 .43371 L p F P
0 g
s
.836 .998 .827 r
.66676 .63711 m .62439 .66805 L .62031 .67533 L p F P
0 g
s
.876 .982 .834 r
.62439 .66805 m .66676 .63711 L .67076 .62661 L p F P
0 g
s
0 .235 .691 r
.45806 .71403 m .4193 .68975 L .42703 .69574 L p F P
0 g
s
0 .235 .691 r
.42703 .69574 m .46257 .71753 L .45806 .71403 L p F P
0 g
s
.408 .82 .626 r
.60098 .69489 m .56483 .71703 L .55984 .72025 L p F P
0 g
s
.551 .907 .705 r
.56483 .71703 m .60098 .69489 L .60853 .68882 L p F P
0 g
s
.938 .792 .673 r
.77953 .41433 m .79223 .38515 L .77963 .36537 L p F P
0 g
s
.973 .769 .568 r
.78467 .34008 m .77963 .36537 L .79223 .38515 L p F P
0 g
s
0 .277 .756 r
.45418 .71025 m .41262 .68328 L .4193 .68975 L p F P
0 g
s
0 .277 .756 r
.4193 .68975 m .45806 .71403 L .45418 .71025 L p F P
0 g
s
.551 .907 .705 r
.60853 .68882 m .56923 .71349 L .56483 .71703 L p F P
0 g
s
.675 .967 .767 r
.56923 .71349 m .60853 .68882 L .615 .68228 L p F P
0 g
s
.915 .896 .795 r
.74534 .51733 m .71128 .55414 L .71308 .56785 L p F P
0 g
s
.906 .861 .785 r
.71128 .55414 m .74534 .51733 L .74062 .50127 L p F P
0 g
s
.921 .866 .767 r
.76791 .46562 m .74062 .50127 L .74534 .51733 L p F P
0 g
s
.876 .982 .834 r
.67076 .62661 m .6272 .66053 L .62439 .66805 L p F P
0 g
s
.896 .955 .831 r
.6272 .66053 m .67076 .62661 L .67294 .61587 L p F P
0 g
s
.907 .926 .817 r
.71308 .56785 m .67326 .60501 L .67294 .61587 L p F P
0 g
s
.905 .892 .806 r
.67326 .60501 m .71308 .56785 L .71128 .55414 L p F P
0 g
s
.907 .83 .758 r
.74062 .50127 m .76791 .46562 L .75967 .44784 L p F P
0 g
s
.929 .832 .729 r
.77953 .41433 m .75967 .44784 L .76791 .46562 L p F P
0 g
s
.675 .967 .767 r
.615 .68228 m .57298 .70968 L .56923 .71349 L p F P
0 g
s
.77 .996 .808 r
.57298 .70968 m .615 .68228 L .62031 .67533 L p F P
0 g
s
.91 .797 .723 r
.75967 .44784 m .77953 .41433 L .76744 .39561 L p F P
0 g
s
.938 .792 .673 r
.77963 .36537 m .76744 .39561 L .77953 .41433 L p F P
0 g
s
.896 .955 .831 r
.67294 .61587 m .62868 .65284 L .6272 .66053 L p F P
0 g
s
.902 .923 .822 r
.62868 .65284 m .67294 .61587 L .67326 .60501 L p F P
0 g
s
.77 .996 .808 r
.62031 .67533 m .57605 .70563 L .57298 .70968 L p F P
0 g
s
.836 .998 .829 r
.57605 .70563 m .62031 .67533 L .62439 .66805 L p F P
0 g
s
.906 .861 .785 r
.74062 .50127 m .70712 .54058 L .71128 .55414 L p F P
0 g
s
.893 .828 .775 r
.70712 .54058 m .74062 .50127 L .73314 .48556 L p F P
0 g
s
.907 .83 .758 r
.75967 .44784 m .73314 .48556 L .74062 .50127 L p F P
0 g
s
.905 .892 .806 r
.71128 .55414 m .6717 .59415 L .67326 .60501 L p F P
0 g
s
.897 .858 .795 r
.6717 .59415 m .71128 .55414 L .70712 .54058 L p F P
0 g
s
.836 .998 .829 r
.62439 .66805 m .57839 .7014 L .57605 .70563 L p F P
0 g
s
.875 .982 .835 r
.57839 .7014 m .62439 .66805 L .6272 .66053 L p F P
0 g
s
.891 .797 .75 r
.73314 .48556 m .75967 .44784 L .74839 .43067 L p F P
0 g
s
.91 .797 .723 r
.76744 .39561 m .74839 .43067 L .75967 .44784 L p F P
0 g
s
.402 0 0 r
.51159 .74507 m .5067 .73139 L .51393 .73159 L p F P
0 g
s
.402 0 0 r
.51393 .73159 m .51344 .74512 L .51159 .74507 L p F P
0 g
s
.352 0 0 r
.51344 .74512 m .51393 .73159 L .52115 .73132 L p F P
0 g
s
.441 0 0 r
.50976 .7449 m .49954 .73072 L .5067 .73139 L p F P
0 g
s
.441 0 0 r
.5067 .73139 m .51159 .74507 L .50976 .7449 L p F P
0 g
s
.352 0 0 r
.52115 .73132 m .51528 .74505 L .51344 .74512 L p F P
0 g
s
.47 0 0 r
.50797 .74461 m .49255 .72958 L .49954 .73072 L p F P
0 g
s
.47 0 0 r
.49954 .73072 m .50976 .7449 L .50797 .74461 L p F P
0 g
s
.902 .923 .822 r
.67326 .60501 m .62881 .64508 L .62868 .65284 L p F P
0 g
s
.9 .889 .811 r
.62881 .64508 m .67326 .60501 L .6717 .59415 L p F P
0 g
s
.488 0 0 r
.50624 .74421 m .48578 .72799 L .49255 .72958 L p F P
0 g
s
.488 0 0 r
.49255 .72958 m .50797 .74461 L .50624 .74421 L p F P
0 g
s
.492 0 0 r
.50459 .74369 m .47933 .72596 L .48578 .72799 L p F P
0 g
s
.492 0 0 r
.48578 .72799 m .50624 .74421 L .50459 .74369 L p F P
0 g
s
.479 0 0 r
.47933 .72596 m .50459 .74369 L .50305 .74307 L p F P
0 g
s
.875 .982 .835 r
.6272 .66053 m .57997 .69704 L .57839 .7014 L p F P
0 g
s
.895 .955 .832 r
.57997 .69704 m .6272 .66053 L .62868 .65284 L p F P
0 g
s
.897 .858 .795 r
.70712 .54058 m .66826 .58343 L .6717 .59415 L p F P
0 g
s
.885 .826 .784 r
.66826 .58343 m .70712 .54058 L .70063 .52734 L p F P
0 g
s
.893 .828 .775 r
.73314 .48556 m .70063 .52734 L .70712 .54058 L p F P
0 g
s
.879 .797 .765 r
.70063 .52734 m .73314 .48556 L .72298 .47041 L p F P
0 g
s
.891 .797 .75 r
.74839 .43067 m .72298 .47041 L .73314 .48556 L p F P
0 g
s
.9 .889 .811 r
.6717 .59415 m .62758 .63733 L .62881 .64508 L p F P
0 g
s
.892 .857 .8 r
.62758 .63733 m .6717 .59415 L .66826 .58343 L p F P
0 g
s
0 .215 .673 r
.49919 .74066 m .45806 .71403 L .46257 .71753 L p F P
0 g
s
0 .215 .673 r
.46257 .71753 m .50033 .74155 L .49919 .74066 L p F P
0 g
s
.895 .955 .832 r
.62868 .65284 m .58078 .69259 L .57997 .69704 L p F P
0 g
s
.901 .923 .823 r
.58078 .69259 m .62868 .65284 L .62881 .64508 L p F P
0 g
s
.539 .898 .687 r
.52642 .74142 m .56483 .71703 L .56923 .71349 L p F P
0 g
s
0 .26 .742 r
.49822 .73971 m .45418 .71025 L .45806 .71403 L p F P
0 g
s
0 .26 .742 r
.45806 .71403 m .49919 .74066 L .49822 .73971 L p F P
0 g
s
.539 .898 .687 r
.56923 .71349 m .52753 .74053 L .52642 .74142 L p F P
0 g
s
.667 .962 .753 r
.52753 .74053 m .56923 .71349 L .57298 .70968 L p F P
0 g
s
.885 .826 .784 r
.70063 .52734 m .66296 .57298 L .66826 .58343 L p F P
0 g
s
.871 .797 .774 r
.66296 .57298 m .70063 .52734 L .69185 .51458 L p F P
0 g
s
.879 .797 .765 r
.72298 .47041 m .69185 .51458 L .70063 .52734 L p F P
0 g
s
.667 .962 .753 r
.57298 .70968 m .52848 .73956 L .52753 .74053 L p F P
0 g
s
.767 .994 .798 r
.52848 .73956 m .57298 .70968 L .57605 .70563 L p F P
0 g
s
.901 .923 .823 r
.62881 .64508 m .58079 .6881 L .58078 .69259 L p F P
0 g
s
.899 .889 .812 r
.58079 .6881 m .62881 .64508 L .62758 .63733 L p F P
0 g
s
.892 .857 .8 r
.66826 .58343 m .62501 .6297 L .62758 .63733 L p F P
0 g
s
.881 .826 .789 r
.62501 .6297 m .66826 .58343 L .66296 .57298 L p F P
0 g
s
.767 .994 .798 r
.57605 .70563 m .52925 .73854 L .52848 .73956 L p F P
0 g
s
.835 .999 .822 r
.52925 .73854 m .57605 .70563 L .57839 .7014 L p F P
0 g
s
.899 .889 .812 r
.62758 .63733 m .58002 .68364 L .58079 .6881 L p F P
0 g
s
.891 .856 .801 r
.58002 .68364 m .62758 .63733 L .62501 .6297 L p F P
0 g
s
.835 .999 .822 r
.57839 .7014 m .52983 .73748 L .52925 .73854 L p F P
0 g
s
.877 .983 .831 r
.52983 .73748 m .57839 .7014 L .57997 .69704 L p F P
0 g
s
.881 .826 .789 r
.66296 .57298 m .6211 .62227 L .62501 .6297 L p F P
0 g
s
.868 .797 .778 r
.6211 .62227 m .66296 .57298 L .65585 .56292 L p F P
0 g
s
.871 .797 .774 r
.69185 .51458 m .65585 .56292 L .66296 .57298 L p F P
0 g
s
.877 .983 .831 r
.57997 .69704 m .53021 .73638 L .52983 .73748 L p F P
0 g
s
.897 .956 .828 r
.53021 .73638 m .57997 .69704 L .58078 .69259 L p F P
0 g
s
.891 .856 .801 r
.62501 .6297 m .57845 .67924 L .58002 .68364 L p F P
0 g
s
.88 .825 .789 r
.57845 .67924 m .62501 .6297 L .6211 .62227 L p F P
0 g
s
.897 .956 .828 r
.58078 .69259 m .5304 .73526 L .53021 .73638 L p F P
0 g
s
.904 .924 .82 r
.5304 .73526 m .58078 .69259 L .58079 .6881 L p F P
0 g
s
.868 .797 .778 r
.65585 .56292 m .61589 .61513 L .6211 .62227 L p F P
0 g
s
.904 .924 .82 r
.58079 .6881 m .53039 .73414 L .5304 .73526 L p F P
0 g
s
.902 .89 .81 r
.53039 .73414 m .58079 .6881 L .58002 .68364 L p F P
0 g
s
.88 .825 .789 r
.6211 .62227 m .57611 .67497 L .57845 .67924 L p F P
0 g
s
.867 .797 .779 r
.57611 .67497 m .6211 .62227 L .61589 .61513 L p F P
0 g
s
.902 .89 .81 r
.58002 .68364 m .53017 .73303 L .53039 .73414 L p F P
0 g
s
.894 .857 .798 r
.53017 .73303 m .58002 .68364 L .57845 .67924 L p F P
0 g
s
.867 .797 .779 r
.61589 .61513 m .57303 .67088 L .57611 .67497 L p F P
0 g
s
.894 .857 .798 r
.57845 .67924 m .52976 .73193 L .53017 .73303 L p F P
0 g
s
.883 .826 .787 r
.52976 .73193 m .57845 .67924 L .57611 .67497 L p F P
0 g
s
.883 .826 .787 r
.57611 .67497 m .52916 .73087 L .52976 .73193 L p F P
0 g
s
.869 .797 .777 r
.52916 .73087 m .57611 .67497 L .57303 .67088 L p F P
0 g
s
.869 .797 .777 r
.57303 .67088 m .52836 .72985 L .52916 .73087 L p F P
0 g
s
.88 .796 .763 r
.43406 .85135 m .48141 .78973 L .48302 .79173 L p F P
0 g
s
.88 .796 .763 r
.48302 .79173 m .43815 .85624 L .43406 .85135 L p F P
0 g
s
.895 .827 .773 r
.43089 .84623 m .48016 .78763 L .48141 .78973 L p F P
0 g
s
.895 .827 .773 r
.48141 .78973 m .43406 .85135 L .43089 .84623 L p F P
0 g
s
.908 .86 .783 r
.42867 .84093 m .4793 .78546 L .48016 .78763 L p F P
0 g
s
.908 .86 .783 r
.48016 .78763 m .43089 .84623 L .42867 .84093 L p F P
0 g
s
.916 .896 .793 r
.42743 .83551 m .47884 .78325 L .4793 .78546 L p F P
0 g
s
.916 .896 .793 r
.4793 .78546 m .42867 .84093 L .42743 .83551 L p F P
0 g
s
.919 .931 .801 r
.42719 .83003 m .47878 .78102 L .47884 .78325 L p F P
0 g
s
.919 .931 .801 r
.47884 .78325 m .42743 .83551 L .42719 .83003 L p F P
0 g
s
.91 .965 .805 r
.42797 .82457 m .47912 .7788 L .47878 .78102 L p F P
0 g
s
.91 .965 .805 r
.47878 .78102 m .42719 .83003 L .42797 .82457 L p F P
0 g
s
.888 .795 .751 r
.3883 .91557 m .43406 .85135 L .43815 .85624 L p F P
0 g
s
.888 .795 .751 r
.43815 .85624 m .39484 .92313 L .3883 .91557 L p F P
0 g
s
.883 .99 .8 r
.42975 .81918 m .47987 .77662 L .47912 .7788 L p F P
0 g
s
.883 .99 .8 r
.47912 .7788 m .42797 .82457 L .42975 .81918 L p F P
0 g
s
.83 .998 .78 r
.43253 .81393 m .48101 .77449 L .47987 .77662 L p F P
0 g
s
.83 .998 .78 r
.47987 .77662 m .42975 .81918 L .43253 .81393 L p F P
0 g
s
.743 .979 .738 r
.43626 .80888 m .48253 .77245 L .48101 .77449 L p F P
0 g
s
.743 .979 .738 r
.48101 .77449 m .43253 .81393 L .43626 .80888 L p F P
0 g
s
.904 .827 .76 r
.38317 .90764 m .43089 .84623 L .43406 .85135 L p F P
0 g
s
.904 .827 .76 r
.43406 .85135 m .3883 .91557 L .38317 .90764 L p F P
0 g
s
.619 .924 .671 r
.44092 .80409 m .48441 .77052 L .48253 .77245 L p F P
0 g
s
.619 .924 .671 r
.48253 .77245 m .43626 .80888 L .44092 .80409 L p F P
0 g
s
0 .16 .655 r
.58949 .80815 m .54369 .77216 L .54174 .77025 L p F P
0 g
s
.466 .833 .581 r
.44645 .79962 m .48664 .76873 L .48441 .77052 L p F P
0 g
s
.466 .833 .581 r
.48441 .77052 m .44092 .80409 L .44645 .79962 L p F P
0 g
s
0 .16 .655 r
.54174 .77025 m .58467 .80341 L .58949 .80815 L p F P
0 g
s
0 .106 .563 r
.58467 .80341 m .54174 .77025 L .53946 .76847 L p F P
0 g
s
.918 .862 .769 r
.37954 .89942 m .42867 .84093 L .43089 .84623 L p F P
0 g
s
.918 .862 .769 r
.43089 .84623 m .38317 .90764 L .37954 .89942 L p F P
0 g
s
0 0 0 r
.45278 .79554 m .48918 .76708 L .48664 .76873 L p F P
0 g
s
0 0 0 r
.48664 .76873 m .44645 .79962 L .45278 .79554 L p F P
0 g
s
0 .106 .563 r
.53946 .76847 m .579 .79899 L .58467 .80341 L p F P
0 g
s
.507 0 0 r
.579 .79899 m .53946 .76847 L .53686 .76685 L p F P
0 g
s
0 0 0 r
.45985 .79187 m .49201 .76561 L .48918 .76708 L p F P
0 g
s
0 0 0 r
.48918 .76708 m .45278 .79554 L .45985 .79187 L p F P
0 g
s
.507 0 0 r
.53686 .76685 m .57253 .79497 L .579 .79899 L p F P
0 g
s
.554 0 0 r
.57253 .79497 m .53686 .76685 L .53399 .76541 L p F P
0 g
s
0 0 0 r
.46756 .78869 m .49509 .76433 L .49201 .76561 L p F P
0 g
s
0 0 0 r
.49201 .76561 m .45985 .79187 L .46756 .78869 L p F P
0 g
s
.554 0 0 r
.53399 .76541 m .56534 .79137 L .57253 .79497 L p F P
0 g
s
.576 0 0 r
.56534 .79137 m .53399 .76541 L .53086 .76416 L p F P
0 g
s
.118 0 0 r
.47583 .78601 m .49839 .76326 L .49509 .76433 L p F P
0 g
s
.118 0 0 r
.49509 .76433 m .46756 .78869 L .47583 .78601 L p F P
0 g
s
.898 .793 .735 r
.34525 .98227 m .3883 .91557 L .39484 .92313 L p F P
0 g
s
.898 .793 .735 r
.39484 .92313 m .35418 .9922 L .34525 .98227 L p F P
0 g
s
.576 0 0 r
.53086 .76416 m .55751 .78826 L .56534 .79137 L p F P
0 g
s
.579 .008 0 r
.55751 .78826 m .53086 .76416 L .52753 .76312 L p F P
0 g
s
.928 .899 .777 r
.37746 .891 m .42743 .83551 L .42867 .84093 L p F P
0 g
s
.928 .899 .777 r
.42867 .84093 m .37954 .89942 L .37746 .891 L p F P
0 g
s
.217 0 0 r
.48456 .78388 m .50186 .76241 L .49839 .76326 L p F P
0 g
s
.217 0 0 r
.49839 .76326 m .47583 .78601 L .48456 .78388 L p F P
0 g
s
.579 .008 0 r
.52753 .76312 m .54915 .78566 L .55751 .78826 L p F P
0 g
s
.567 .007 0 r
.54915 .78566 m .52753 .76312 L .52403 .76231 L p F P
0 g
s
.3 0 0 r
.49364 .78233 m .50547 .76179 L .50186 .76241 L p F P
0 g
s
.3 0 0 r
.50186 .76241 m .48456 .78388 L .49364 .78233 L p F P
0 g
s
.567 .007 0 r
.52403 .76231 m .54035 .78362 L .54915 .78566 L p F P
0 g
s
.545 0 0 r
.54035 .78362 m .52403 .76231 L .5204 .76172 L p F P
0 g
s
.369 0 0 r
.50296 .78137 m .50918 .76141 L .50547 .76179 L p F P
0 g
s
.369 0 0 r
.50547 .76179 m .49364 .78233 L .50296 .78137 L p F P
0 g
s
.545 0 0 r
.5204 .76172 m .53122 .78215 L .54035 .78362 L p F P
0 g
s
.513 0 0 r
.53122 .78215 m .5204 .76172 L .51668 .76137 L p F P
0 g
s
.426 0 0 r
.51241 .78102 m .51293 .76127 L .50918 .76141 L p F P
0 g
s
.426 0 0 r
.50918 .76141 m .50296 .78137 L .51241 .78102 L p F P
0 g
s
.513 0 0 r
.51668 .76137 m .52187 .78128 L .53122 .78215 L p F P
0 g
s
.474 0 0 r
.52187 .78128 m .51668 .76137 L .51293 .76127 L p F P
0 g
s
.474 0 0 r
.51293 .76127 m .51241 .78102 L .52187 .78128 L p F P
0 g
s
.93 .936 .783 r
.37695 .88247 m .42719 .83003 L .42743 .83551 L p F P
0 g
s
.93 .936 .783 r
.42743 .83551 m .37746 .891 L .37695 .88247 L p F P
0 g
s
.916 .827 .743 r
.33821 .97182 m .38317 .90764 L .3883 .91557 L p F P
0 g
s
.916 .827 .743 r
.3883 .91557 m .34525 .98227 L .33821 .97182 L p F P
0 g
s
.919 .969 .782 r
.37805 .87395 m .42797 .82457 L .42719 .83003 L p F P
0 g
s
.919 .969 .782 r
.42719 .83003 m .37695 .88247 L .37805 .87395 L p F P
0 g
s
.931 .863 .75 r
.33317 .96096 m .37954 .89942 L .38317 .90764 L p F P
0 g
s
.931 .863 .75 r
.38317 .90764 m .33821 .97182 L .33317 .96096 L p F P
0 g
s
.91 .789 .715 r
.306 1.05136 m .34525 .98227 L .35418 .9922 L p F P
0 g
s
.91 .789 .715 r
.35418 .9922 m .31716 1.06334 L .306 1.05136 L p F P
0 g
s
.886 .991 .77 r
.38076 .86553 m .42975 .81918 L .42797 .82457 L p F P
0 g
s
.886 .991 .77 r
.42797 .82457 m .37805 .87395 L .38076 .86553 L p F P
0 g
s
.822 .991 .738 r
.38504 .8573 m .43253 .81393 L .42975 .81918 L p F P
0 g
s
.822 .991 .738 r
.42975 .81918 m .38076 .86553 L .38504 .8573 L p F P
0 g
s
.942 .901 .756 r
.3302 .94982 m .37746 .891 L .37954 .89942 L p F P
0 g
s
.942 .901 .756 r
.37954 .89942 m .33317 .96096 L .3302 .94982 L p F P
0 g
s
.93 .824 .72 r
.29715 1.03873 m .33821 .97182 L .34525 .98227 L p F P
0 g
s
.93 .824 .72 r
.34525 .98227 m .306 1.05136 L .29715 1.03873 L p F P
0 g
s
.716 .957 .68 r
.39086 .84938 m .43626 .80888 L .43253 .81393 L p F P
0 g
s
.716 .957 .68 r
.43253 .81393 m .38504 .8573 L .39086 .84938 L p F P
0 g
s
.571 .88 .593 r
.39817 .84185 m .44092 .80409 L .43626 .80888 L p F P
0 g
s
.571 .88 .593 r
.43626 .80888 m .39086 .84938 L .39817 .84185 L p F P
0 g
s
.943 .939 .757 r
.32935 .93853 m .37695 .88247 L .37746 .891 L p F P
0 g
s
.943 .939 .757 r
.37746 .891 m .3302 .94982 L .32935 .93853 L p F P
0 g
s
0 .075 .574 r
.63445 .84824 m .58949 .80815 L .58467 .80341 L p F P
0 g
s
.923 .783 .689 r
.27152 1.12281 m .306 1.05136 L .31716 1.06334 L p F P
0 g
s
.923 .783 .689 r
.31716 1.06334 m .28469 1.13646 L .27152 1.12281 L p F P
0 g
s
0 0 0 r
.40688 .83482 m .44645 .79962 L .44092 .80409 L p F P
0 g
s
0 0 0 r
.44092 .80409 m .39817 .84185 L .40688 .83482 L p F P
0 g
s
.946 .863 .725 r
.29074 1.0256 m .33317 .96096 L .33821 .97182 L p F P
0 g
s
.946 .863 .725 r
.33821 .97182 m .29715 1.03873 L .29074 1.0256 L p F P
0 g
s
0 .075 .574 r
.58467 .80341 m .62689 .84078 L .63445 .84824 L p F P
0 g
s
.523 0 0 r
.62689 .84078 m .58467 .80341 L .579 .79899 L p F P
0 g
s
.928 .971 .749 r
.33067 .92722 m .37805 .87395 L .37695 .88247 L p F P
0 g
s
.928 .971 .749 r
.37695 .88247 m .32935 .93853 L .33067 .92722 L p F P
0 g
s
0 0 0 r
.41689 .82837 m .45278 .79554 L .44645 .79962 L p F P
0 g
s
0 0 0 r
.44645 .79962 m .40688 .83482 L .41689 .82837 L p F P
0 g
s
.523 0 0 r
.579 .79899 m .61793 .83383 L .62689 .84078 L p F P
0 g
s
.591 .031 0 r
.61793 .83383 m .579 .79899 L .57253 .79497 L p F P
0 g
s
0 0 0 r
.42809 .82259 m .45985 .79187 L .45278 .79554 L p F P
0 g
s
0 0 0 r
.45278 .79554 m .41689 .82837 L .42809 .82259 L p F P
0 g
s
.591 .031 0 r
.57253 .79497 m .6077 .82748 L .61793 .83383 L p F P
0 g
s
.627 .063 0 r
.6077 .82748 m .57253 .79497 L .56534 .79137 L p F P
0 g
s
.944 .82 .691 r
.26103 1.10842 m .29715 1.03873 L .306 1.05136 L p F P
0 g
s
.944 .82 .691 r
.306 1.05136 m .27152 1.12281 L .26103 1.10842 L p F P
0 g
s
.957 .902 .726 r
.28688 1.01211 m .3302 .94982 L .33317 .96096 L p F P
0 g
s
.957 .902 .726 r
.33317 .96096 m .29074 1.0256 L .28688 1.01211 L p F P
0 g
s
.069 0 0 r
.44035 .81755 m .46756 .78869 L .45985 .79187 L p F P
0 g
s
.069 0 0 r
.45985 .79187 m .42809 .82259 L .44035 .81755 L p F P
0 g
s
.886 .987 .725 r
.33416 .91602 m .38076 .86553 L .37805 .87395 L p F P
0 g
s
.886 .987 .725 r
.37805 .87395 m .33067 .92722 L .33416 .91602 L p F P
0 g
s
.627 .063 0 r
.56534 .79137 m .59629 .8218 L .6077 .82748 L p F P
0 g
s
.639 .08 0 r
.59629 .8218 m .56534 .79137 L .55751 .78826 L p F P
0 g
s
.183 0 0 r
.45352 .81332 m .47583 .78601 L .46756 .78869 L p F P
0 g
s
.183 0 0 r
.46756 .78869 m .44035 .81755 L .45352 .81332 L p F P
0 g
s
.639 .08 0 r
.55751 .78826 m .58386 .81688 L .59629 .8218 L p F P
0 g
s
.633 .086 0 r
.58386 .81688 m .55751 .78826 L .54915 .78566 L p F P
0 g
s
.277 0 0 r
.46744 .80995 m .48456 .78388 L .47583 .78601 L p F P
0 g
s
.277 0 0 r
.47583 .78601 m .45352 .81332 L .46744 .80995 L p F P
0 g
s
.633 .086 0 r
.54915 .78566 m .57054 .81277 L .58386 .81688 L p F P
0 g
s
.616 .081 0 r
.57054 .81277 m .54915 .78566 L .54035 .78362 L p F P
0 g
s
.354 0 0 r
.48192 .80749 m .49364 .78233 L .48456 .78388 L p F P
0 g
s
.354 0 0 r
.48456 .78388 m .46744 .80995 L .48192 .80749 L p F P
0 g
s
.616 .081 0 r
.54035 .78362 m .55651 .80953 L .57054 .81277 L p F P
0 g
s
.591 .067 0 r
.55651 .80953 m .54035 .78362 L .53122 .78215 L p F P
0 g
s
.803 .973 .675 r
.33979 .90506 m .38504 .8573 L .38076 .86553 L p F P
0 g
s
.803 .973 .675 r
.38076 .86553 m .33416 .91602 L .33979 .90506 L p F P
0 g
s
.418 0 0 r
.49681 .80598 m .50296 .78137 L .49364 .78233 L p F P
0 g
s
.418 0 0 r
.49364 .78233 m .48192 .80749 L .49681 .80598 L p F P
0 g
s
.936 .774 .656 r
.2427 1.19669 m .27152 1.12281 L .28469 1.13646 L p F P
0 g
s
.936 .774 .656 r
.28469 1.13646 m .25757 1.21157 L .2427 1.19669 L p F P
0 g
s
.591 .067 0 r
.53122 .78215 m .54194 .80721 L .55651 .80953 L p F P
0 g
s
.558 .045 0 r
.54194 .80721 m .53122 .78215 L .52187 .78128 L p F P
0 g
s
.473 0 0 r
.5119 .80542 m .51241 .78102 L .50296 .78137 L p F P
0 g
s
.473 0 0 r
.50296 .78137 m .49681 .80598 L .5119 .80542 L p F P
0 g
s
.558 .045 0 r
.52187 .78128 m .527 .80583 L .54194 .80721 L p F P
0 g
s
.519 .015 0 r
.527 .80583 m .52187 .78128 L .51241 .78102 L p F P
0 g
s
.519 .015 0 r
.51241 .78102 m .5119 .80542 L .527 .80583 L p F P
0 g
s
.957 .94 .72 r
.28565 .99841 m .32935 .93853 L .3302 .94982 L p F P
0 g
s
.957 .94 .72 r
.3302 .94982 m .28688 1.01211 L .28565 .99841 L p F P
0 g
s
.962 .859 .691 r
.25337 1.09343 m .29074 1.0256 L .29715 1.03873 L p F P
0 g
s
.962 .859 .691 r
.29715 1.03873 m .26103 1.10842 L .25337 1.09343 L p F P
0 g
s
.673 .915 .594 r
.34753 .89449 m .39086 .84938 L .38504 .8573 L p F P
0 g
s
.673 .915 .594 r
.38504 .8573 m .33979 .90506 L .34753 .89449 L p F P
0 g
s
.935 .967 .701 r
.28709 .98466 m .33067 .92722 L .32935 .93853 L p F P
0 g
s
.935 .967 .701 r
.32935 .93853 m .28565 .99841 L .28709 .98466 L p F P
0 g
s
.959 .811 .654 r
.23079 1.18096 m .26103 1.10842 L .27152 1.12281 L p F P
0 g
s
.959 .811 .654 r
.27152 1.12281 m .2427 1.19669 L .23079 1.18096 L p F P
0 g
s
0 0 0 r
.3573 .88443 m .39817 .84185 L .39086 .84938 L p F P
0 g
s
0 0 0 r
.39086 .84938 m .34753 .89449 L .3573 .88443 L p F P
0 g
s
.536 .033 0 r
.67737 .89297 m .63445 .84824 L .62689 .84078 L p F P
0 g
s
.973 .899 .685 r
.24867 1.07801 m .28688 1.01211 L .29074 1.0256 L p F P
0 g
s
.973 .899 .685 r
.29074 1.0256 m .25337 1.09343 L .24867 1.07801 L p F P
0 g
s
0 0 0 r
.36899 .87502 m .40688 .83482 L .39817 .84185 L p F P
0 g
s
0 0 0 r
.39817 .84185 m .3573 .88443 L .36899 .87502 L p F P
0 g
s
.536 .033 0 r
.62689 .84078 m .66725 .883 L .67737 .89297 L p F P
0 g
s
.627 .092 0 r
.66725 .883 m .62689 .84078 L .61793 .83383 L p F P
0 g
s
.877 .972 .659 r
.29122 .97102 m .33416 .91602 L .33067 .92722 L p F P
0 g
s
.877 .972 .659 r
.33067 .92722 m .28709 .98466 L .29122 .97102 L p F P
0 g
s
.948 .76 .616 r
.2203 1.27308 m .2427 1.19669 L .25757 1.21157 L p F P
0 g
s
.948 .76 .616 r
.25757 1.21157 m .23652 1.28877 L .2203 1.27308 L p F P
0 g
s
0 0 0 r
.38248 .86638 m .41689 .82837 L .40688 .83482 L p F P
0 g
s
0 0 0 r
.40688 .83482 m .36899 .87502 L .38248 .86638 L p F P
0 g
s
.978 .851 .647 r
.22204 1.16457 m .25337 1.09343 L .26103 1.10842 L p F P
0 g
s
.978 .851 .647 r
.26103 1.10842 m .23079 1.18096 L .22204 1.16457 L p F P
0 g
s
.627 .092 0 r
.61793 .83383 m .65522 .87369 L .66725 .883 L p F P
0 g
s
.678 .134 0 r
.65522 .87369 m .61793 .83383 L .6077 .82748 L p F P
0 g
s
.969 .934 .669 r
.24703 1.06232 m .28565 .99841 L .28688 1.01211 L p F P
0 g
s
.969 .934 .669 r
.28688 1.01211 m .24867 1.07801 L .24703 1.06232 L p F P
0 g
s
.768 .935 .584 r
.29804 .95766 m .33979 .90506 L .33416 .91602 L p F P
0 g
s
.768 .935 .584 r
.33416 .91602 m .29122 .97102 L .29804 .95766 L p F P
0 g
s
.018 0 0 r
.39761 .85862 m .42809 .82259 L .41689 .82837 L p F P
0 g
s
.018 0 0 r
.41689 .82837 m .38248 .86638 L .39761 .85862 L p F P
0 g
s
.678 .134 0 r
.6077 .82748 m .64142 .86517 L .65522 .87369 L p F P
0 g
s
.699 .159 0 r
.64142 .86517 m .6077 .82748 L .59629 .8218 L p F P
0 g
s
.147 0 0 r
.4142 .85185 m .44035 .81755 L .42809 .82259 L p F P
0 g
s
.147 0 0 r
.42809 .82259 m .39761 .85862 L .4142 .85185 L p F P
0 g
s
.972 .798 .607 r
.20728 1.25649 m .23079 1.18096 L .2427 1.19669 L p F P
0 g
s
.972 .798 .607 r
.2427 1.19669 m .2203 1.27308 L .20728 1.25649 L p F P
0 g
s
.699 .159 0 r
.59629 .8218 m .62602 .85755 L .64142 .86517 L p F P
0 g
s
.699 .169 0 r
.62602 .85755 m .59629 .8218 L .58386 .81688 L p F P
0 g
s
.935 .953 .632 r
.24852 1.04655 m .28709 .98466 L .28565 .99841 L p F P
0 g
s
.935 .953 .632 r
.28565 .99841 m .24703 1.06232 L .24852 1.04655 L p F P
0 g
s
.987 .889 .631 r
.2166 1.14768 m .24867 1.07801 L .25337 1.09343 L p F P
0 g
s
.987 .889 .631 r
.25337 1.09343 m .22204 1.16457 L .2166 1.14768 L p F P
0 g
s
.252 0 0 r
.43206 .84615 m .45352 .81332 L .44035 .81755 L p F P
0 g
s
.252 0 0 r
.44035 .81755 m .4142 .85185 L .43206 .84615 L p F P
0 g
s
.606 .845 .475 r
.30747 .94474 m .34753 .89449 L .33979 .90506 L p F P
0 g
s
.606 .845 .475 r
.33979 .90506 m .29804 .95766 L .30747 .94474 L p F P
0 g
s
.699 .169 0 r
.58386 .81688 m .60918 .85093 L .62602 .85755 L p F P
0 g
s
.685 .168 0 r
.60918 .85093 m .58386 .81688 L .57054 .81277 L p F P
0 g
s
.337 0 .032 r
.45095 .84162 m .46744 .80995 L .45352 .81332 L p F P
0 g
s
.337 0 .032 r
.45352 .81332 m .43206 .84615 L .45095 .84162 L p F P
0 g
s
.685 .168 0 r
.57054 .81277 m .59112 .84541 L .60918 .85093 L p F P
0 g
s
.663 .159 .038 r
.59112 .84541 m .57054 .81277 L .55651 .80953 L p F P
0 g
s
.408 0 .062 r
.47064 .83831 m .48192 .80749 L .46744 .80995 L p F P
0 g
s
.408 0 .062 r
.46744 .80995 m .45095 .84162 L .47064 .83831 L p F P
0 g
s
.663 .159 .038 r
.55651 .80953 m .57207 .84105 L .59112 .84541 L p F P
0 g
s
.635 .143 .067 r
.57207 .84105 m .55651 .80953 L .54194 .80721 L p F P
0 g
s
.958 .742 .568 r
.20497 1.35218 m .2203 1.27308 L .23652 1.28877 L p F P
0 g
s
.958 .742 .568 r
.23652 1.28877 m .22212 1.36823 L .20497 1.35218 L p F P
0 g
s
.468 .01 .082 r
.49088 .83626 m .49681 .80598 L .48192 .80749 L p F P
0 g
s
.468 .01 .082 r
.48192 .80749 m .47064 .83831 L .49088 .83626 L p F P
0 g
s
.635 .143 .067 r
.54194 .80721 m .55226 .83792 L .57207 .84105 L p F P
0 g
s
.601 .12 .085 r
.55226 .83792 m .54194 .80721 L .527 .80583 L p F P
0 g
s
0 0 0 r
.31946 .93244 m .3573 .88443 L .34753 .89449 L p F P
0 g
s
0 0 0 r
.34753 .89449 m .30747 .94474 L .31946 .93244 L p F P
0 g
s
.518 .055 .092 r
.5114 .83551 m .5119 .80542 L .49681 .80598 L p F P
0 g
s
.518 .055 .092 r
.49681 .80598 m .49088 .83626 L .5114 .83551 L p F P
0 g
s
.601 .12 .085 r
.527 .80583 m .53195 .83607 L .55226 .83792 L p F P
0 g
s
.563 .091 .093 r
.53195 .83607 m .527 .80583 L .5119 .80542 L p F P
0 g
s
.563 .091 .093 r
.5119 .80542 m .5114 .83551 L .53195 .83607 L p F P
0 g
s
.657 .158 0 r
.71706 .94288 m .67737 .89297 L .66725 .883 L p F P
0 g
s
.991 .835 .59 r
.19765 1.23917 m .22204 1.16457 L .23079 1.18096 L p F P
0 g
s
.991 .835 .59 r
.23079 1.18096 m .20728 1.25649 L .19765 1.23917 L p F P
0 g
s
.852 .937 .565 r
.25316 1.03088 m .29122 .97102 L .28709 .98466 L p F P
0 g
s
.852 .937 .565 r
.28709 .98466 m .24852 1.04655 L .25316 1.03088 L p F P
0 g
s
.974 .918 .598 r
.21457 1.13047 m .24703 1.06232 L .24867 1.07801 L p F P
0 g
s
.974 .918 .598 r
.24867 1.07801 m .2166 1.14768 L .21457 1.13047 L p F P
0 g
s
0 0 0 r
.33386 .92091 m .36899 .87502 L .3573 .88443 L p F P
0 g
s
0 0 0 r
.3573 .88443 m .31946 .93244 L .33386 .92091 L p F P
0 g
s
.657 .158 0 r
.66725 .883 m .70463 .93068 L .71706 .94288 L p F P
0 g
s
.727 .21 0 r
.70463 .93068 m .66725 .883 L .65522 .87369 L p F P
0 g
s
.983 .777 .55 r
.19116 1.33519 m .20728 1.25649 L .2203 1.27308 L p F P
0 g
s
.983 .777 .55 r
.2203 1.27308 m .20497 1.35218 L .19116 1.33519 L p F P
0 g
s
.708 .867 .459 r
.26096 1.01552 m .29804 .95766 L .29122 .97102 L p F P
0 g
s
.708 .867 .459 r
.29122 .97102 m .25316 1.03088 L .26096 1.01552 L p F P
0 g
s
0 0 0 r
.35053 .91031 m .38248 .86638 L .36899 .87502 L p F P
0 g
s
0 0 0 r
.36899 .87502 m .33386 .92091 L .35053 .91031 L p F P
0 g
s
.995 .869 .56 r
.1916 1.22132 m .2166 1.14768 L .22204 1.16457 L p F P
0 g
s
.995 .869 .56 r
.22204 1.16457 m .19765 1.23917 L .1916 1.22132 L p F P
0 g
s
.727 .21 0 r
.65522 .87369 m .6898 .91928 L .70463 .93068 L p F P
0 g
s
.757 .241 0 r
.6898 .91928 m .65522 .87369 L .64142 .86517 L p F P
0 g
s
.921 .92 .537 r
.21606 1.11316 m .24852 1.04655 L .24703 1.06232 L p F P
0 g
s
.921 .92 .537 r
.24703 1.06232 m .21457 1.13047 L .21606 1.11316 L p F P
0 g
s
.106 0 0 r
.36927 .90078 m .39761 .85862 L .38248 .86638 L p F P
0 g
s
.106 0 0 r
.38248 .86638 m .35053 .91031 L .36927 .90078 L p F P
0 g
s
.757 .241 0 r
.64142 .86517 m .67275 .90883 L .6898 .91928 L p F P
0 g
s
.761 .255 0 r
.67275 .90883 m .64142 .86517 L .62602 .85755 L p F P
0 g
s
0 0 0 r
.27186 1.00064 m .30747 .94474 L .29804 .95766 L p F P
0 g
s
0 0 0 r
.29804 .95766 m .26096 1.01552 L .27186 1.00064 L p F P
0 g
s
.965 .717 .512 r
.19719 1.43424 m .20497 1.35218 L .22212 1.36823 L p F P
0 g
s
.965 .717 .512 r
.22212 1.36823 m .21482 1.45021 L .19719 1.43424 L p F P
0 g
s
.999 .811 .52 r
.18092 1.31746 m .19765 1.23917 L .20728 1.25649 L p F P
0 g
s
.999 .811 .52 r
.20728 1.25649 m .19116 1.33519 L .18092 1.31746 L p F P
0 g
s
.223 0 .049 r
.38987 .89245 m .4142 .85185 L .39761 .85862 L p F P
0 g
s
.223 0 .049 r
.39761 .85862 m .36927 .90078 L .38987 .89245 L p F P
0 g
s
.761 .255 0 r
.62602 .85755 m .65365 .89947 L .67275 .90883 L p F P
0 g
s
.75 .257 .059 r
.65365 .89947 m .62602 .85755 L .60918 .85093 L p F P
0 g
s
.804 .874 .438 r
.2211 1.09595 m .25316 1.03088 L .24852 1.04655 L p F P
0 g
s
.804 .874 .438 r
.24852 1.04655 m .21606 1.11316 L .2211 1.09595 L p F P
0 g
s
.968 .885 .504 r
.18925 1.20312 m .21457 1.13047 L .2166 1.14768 L p F P
0 g
s
.968 .885 .504 r
.2166 1.14768 m .1916 1.22132 L .18925 1.20312 L p F P
0 g
s
.317 0 .099 r
.41206 .88544 m .43206 .84615 L .4142 .85185 L p F P
0 g
s
.317 0 .099 r
.4142 .85185 m .38987 .89245 L .41206 .88544 L p F P
0 g
s
0 0 0 r
.28576 .98645 m .31946 .93244 L .30747 .94474 L p F P
0 g
s
0 0 0 r
.30747 .94474 m .27186 1.00064 L .28576 .98645 L p F P
0 g
s
.75 .257 .059 r
.60918 .85093 m .63275 .89133 L .65365 .89947 L p F P
0 g
s
.729 .25 .106 r
.63275 .89133 m .60918 .85093 L .59112 .84541 L p F P
0 g
s
.767 .289 0 r
.75235 .99849 m .71706 .94288 L .70463 .93068 L p F P
0 g
s
.394 0 .135 r
.43558 .87986 m .45095 .84162 L .43206 .84615 L p F P
0 g
s
.394 0 .135 r
.43206 .84615 m .41206 .88544 L .43558 .87986 L p F P
0 g
s
.729 .25 .106 r
.59112 .84541 m .6103 .88452 L .63275 .89133 L p F P
0 g
s
.703 .236 .14 r
.6103 .88452 m .59112 .84541 L .57207 .84105 L p F P
0 g
s
.988 .748 .483 r
.18299 1.41733 m .19116 1.33519 L .20497 1.35218 L p F P
0 g
s
.988 .748 .483 r
.20497 1.35218 m .19719 1.43424 L .18299 1.41733 L p F P
0 g
s
.458 .041 .16 r
.46011 .87577 m .47064 .83831 L .45095 .84162 L p F P
0 g
s
.458 .041 .16 r
.45095 .84162 m .43558 .87986 L .46011 .87577 L p F P
0 g
s
.703 .236 .14 r
.57207 .84105 m .58658 .87916 L .6103 .88452 L p F P
0 g
s
.672 .217 .163 r
.58658 .87916 m .57207 .84105 L .55226 .83792 L p F P
0 g
s
.993 .834 .469 r
.17444 1.29916 m .1916 1.22132 L .19765 1.23917 L p F P
0 g
s
.993 .834 .469 r
.19765 1.23917 m .18092 1.31746 L .17444 1.29916 L p F P
0 g
s
0 0 0 r
.22968 1.07903 m .26096 1.01552 L .25316 1.03088 L p F P
0 g
s
0 0 0 r
.25316 1.03088 m .2211 1.09595 L .22968 1.07903 L p F P
0 g
s
0 0 0 r
.30254 .97314 m .33386 .92091 L .31946 .93244 L p F P
0 g
s
0 0 0 r
.31946 .93244 m .28576 .98645 L .30254 .97314 L p F P
0 g
s
.512 .09 .176 r
.48534 .87325 m .49088 .83626 L .47064 .83831 L p F P
0 g
s
.512 .09 .176 r
.47064 .83831 m .46011 .87577 L .48534 .87325 L p F P
0 g
s
.672 .217 .163 r
.55226 .83792 m .56189 .8753 L .58658 .87916 L p F P
0 g
s
.639 .194 .178 r
.56189 .8753 m .55226 .83792 L .53195 .83607 L p F P
0 g
s
.885 .861 .413 r
.1907 1.18478 m .21606 1.11316 L .21457 1.13047 L p F P
0 g
s
.885 .861 .413 r
.21457 1.13047 m .18925 1.20312 L .1907 1.18478 L p F P
0 g
s
.767 .289 0 r
.70463 .93068 m .73792 .98442 L .75235 .99849 L p F P
0 g
s
.81 .326 0 r
.73792 .98442 m .70463 .93068 L .6898 .91928 L p F P
0 g
s
.559 .131 .184 r
.51094 .87232 m .5114 .83551 L .49088 .83626 L p F P
0 g
s
.559 .131 .184 r
.49088 .83626 m .48534 .87325 L .51094 .87232 L p F P
0 g
s
.639 .194 .178 r
.53195 .83607 m .53657 .87301 L .56189 .8753 L p F P
0 g
s
.601 .165 .184 r
.53657 .87301 m .53195 .83607 L .5114 .83551 L p F P
0 g
s
.601 .165 .184 r
.5114 .83551 m .51094 .87232 L .53657 .87301 L p F P
0 g
s
.059 0 .035 r
.32201 .96088 m .35053 .91031 L .33386 .92091 L p F P
0 g
s
.059 0 .035 r
.33386 .92091 m .30254 .97314 L .32201 .96088 L p F P
0 g
s
.81 .326 0 r
.6898 .91928 m .72064 .97125 L .73792 .98442 L p F P
0 g
s
.819 .342 .05 r
.72064 .97125 m .6898 .91928 L .67275 .90883 L p F P
0 g
s
.997 .774 .436 r
.17244 1.39968 m .18092 1.31746 L .19116 1.33519 L p F P
0 g
s
.997 .774 .436 r
.19116 1.33519 m .18299 1.41733 L .17244 1.39968 L p F P
0 g
s
0 0 0 r
.24177 1.06265 m .27186 1.00064 L .26096 1.01552 L p F P
0 g
s
0 0 0 r
.26096 1.01552 m .22968 1.07903 L .24177 1.06265 L p F P
0 g
s
.944 .829 .386 r
.17185 1.28049 m .18925 1.20312 L .1916 1.22132 L p F P
0 g
s
.944 .829 .386 r
.1916 1.22132 m .17444 1.29916 L .17185 1.28049 L p F P
0 g
s
.727 .775 .281 r
.19601 1.16653 m .2211 1.09595 L .21606 1.11316 L p F P
0 g
s
.727 .775 .281 r
.21606 1.11316 m .1907 1.18478 L .19601 1.16653 L p F P
0 g
s
.189 0 .109 r
.34395 .94984 m .36927 .90078 L .35053 .91031 L p F P
0 g
s
.189 0 .109 r
.35053 .91031 m .32201 .96088 L .34395 .94984 L p F P
0 g
s
.819 .342 .05 r
.67275 .90883 m .70071 .95916 L .72064 .97125 L p F P
0 g
s
.809 .343 .12 r
.70071 .95916 m .67275 .90883 L .65365 .89947 L p F P
0 g
s
0 0 0 r
.25726 1.04699 m .28576 .98645 L .27186 1.00064 L p F P
0 g
s
0 0 0 r
.27186 1.00064 m .24177 1.06265 L .25726 1.04699 L p F P
0 g
s
.292 0 .163 r
.3681 .9402 m .38987 .89245 L .36927 .90078 L p F P
0 g
s
.292 0 .163 r
.36927 .90078 m .34395 .94984 L .3681 .9402 L p F P
0 g
s
.855 .41 .002 r
.78217 1.06028 m .75235 .99849 L .73792 .98442 L p F P
0 g
s
.809 .343 .12 r
.65365 .89947 m .67835 .94833 L .70071 .95916 L p F P
0 g
s
.789 .337 .171 r
.67835 .94833 m .65365 .89947 L .63275 .89133 L p F P
0 g
s
.976 .782 .362 r
.16573 1.38145 m .17444 1.29916 L .18092 1.31746 L p F P
0 g
s
.976 .782 .362 r
.18092 1.31746 m .17244 1.39968 L .16573 1.38145 L p F P
0 g
s
.822 .771 .263 r
.17327 1.26167 m .1907 1.18478 L .18925 1.20312 L p F P
0 g
s
.822 .771 .263 r
.18925 1.20312 m .17185 1.28049 L .17327 1.26167 L p F P
0 g
s
0 0 0 r
.20519 1.14858 m .22968 1.07903 L .2211 1.09595 L p F P
0 g
s
0 0 0 r
.2211 1.09595 m .19601 1.16653 L .20519 1.14858 L p F P
0 g
s
.375 .005 .203 r
.39417 .93207 m .41206 .88544 L .38987 .89245 L p F P
0 g
s
.375 .005 .203 r
.38987 .89245 m .3681 .9402 L .39417 .93207 L p F P
0 g
s
.789 .337 .171 r
.63275 .89133 m .65384 .93889 L .67835 .94833 L p F P
0 g
s
.763 .324 .208 r
.65384 .93889 m .63275 .89133 L .6103 .88452 L p F P
0 g
s
.001 0 .086 r
.27601 1.03229 m .30254 .97314 L .28576 .98645 L p F P
0 g
s
.001 0 .086 r
.28576 .98645 m .25726 1.04699 L .27601 1.03229 L p F P
0 g
s
.443 .068 .231 r
.42181 .92559 m .43558 .87986 L .41206 .88544 L p F P
0 g
s
.443 .068 .231 r
.41206 .88544 m .39417 .93207 L .42181 .92559 L p F P
0 g
s
.855 .41 .002 r
.73792 .98442 m .76608 1.04475 L .78217 1.06028 L p F P
0 g
s
.871 .428 .103 r
.76608 1.04475 m .73792 .98442 L .72064 .97125 L p F P
0 g
s
.763 .324 .208 r
.6103 .88452 m .62746 .93101 L .65384 .93889 L p F P
0 g
s
.734 .306 .235 r
.62746 .93101 m .6103 .88452 L .58658 .87916 L p F P
0 g
s
.5 .12 .25 r
.45068 .92085 m .46011 .87577 L .43558 .87986 L p F P
0 g
s
.5 .12 .25 r
.43558 .87986 m .42181 .92559 L .45068 .92085 L p F P
0 g
s
.734 .306 .235 r
.58658 .87916 m .59957 .92478 L .62746 .93101 L p F P
0 g
s
.702 .286 .253 r
.59957 .92478 m .58658 .87916 L .56189 .8753 L p F P
0 g
s
.896 .75 .249 r
.16301 1.36285 m .17185 1.28049 L .17444 1.29916 L p F P
0 g
s
.896 .75 .249 r
.17444 1.29916 m .16573 1.38145 L .16301 1.36285 L p F P
0 g
s
0 0 .018 r
.21818 1.13117 m .24177 1.06265 L .22968 1.07903 L p F P
0 g
s
0 0 .018 r
.22968 1.07903 m .20519 1.14858 L .21818 1.13117 L p F P
0 g
s
.55 .164 .262 r
.48038 .91792 m .48534 .87325 L .46011 .87577 L p F P
0 g
s
.55 .164 .262 r
.46011 .87577 m .45068 .92085 L .48038 .91792 L p F P
0 g
s
.702 .286 .253 r
.56189 .8753 m .57053 .9203 L .59957 .92478 L p F P
0 g
s
.669 .261 .264 r
.57053 .9203 m .56189 .8753 L .53657 .87301 L p F P
0 g
s
0 0 0 r
.17876 1.24292 m .19601 1.16653 L .1907 1.18478 L p F P
0 g
s
0 0 0 r
.1907 1.18478 m .17327 1.26167 L .17876 1.24292 L p F P
0 g
s
.146 0 .166 r
.29783 1.01874 m .32201 .96088 L .30254 .97314 L p F P
0 g
s
.146 0 .166 r
.30254 .97314 m .27601 1.03229 L .29783 1.01874 L p F P
0 g
s
.593 .201 .269 r
.51053 .91684 m .51094 .87232 L .48534 .87325 L p F P
0 g
s
.593 .201 .269 r
.48534 .87325 m .48038 .91792 L .51053 .91684 L p F P
0 g
s
.669 .261 .264 r
.53657 .87301 m .54071 .91764 L .57053 .9203 L p F P
0 g
s
.633 .233 .269 r
.54071 .91764 m .53657 .87301 L .51094 .87232 L p F P
0 g
s
.633 .233 .269 r
.51094 .87232 m .51053 .91684 L .54071 .91764 L p F P
0 g
s
.871 .428 .103 r
.72064 .97125 m .74676 1.03021 L .76608 1.04475 L p F P
0 g
s
.862 .428 .177 r
.74676 1.03021 m .72064 .97125 L .70071 .95916 L p F P
0 g
s
.26 0 .223 r
.32246 1.00653 m .34395 .94984 L .32201 .96088 L p F P
0 g
s
.26 0 .223 r
.32201 .96088 m .29783 1.01874 L .32246 1.00653 L p F P
0 g
s
.862 .428 .177 r
.70071 .95916 m .72442 1.01684 L .74676 1.03021 L p F P
0 g
s
.842 .42 .231 r
.72442 1.01684 m .70071 .95916 L .67835 .94833 L p F P
0 g
s
0 0 .133 r
.2349 1.11453 m .25726 1.04699 L .24177 1.06265 L p F P
0 g
s
0 0 .133 r
.24177 1.06265 m .21818 1.13117 L .2349 1.11453 L p F P
0 g
s
.913 .511 .15 r
.80555 1.12866 m .78217 1.06028 L .76608 1.04475 L p F P
0 g
s
.734 .655 .1 r
.16441 1.3441 m .17327 1.26167 L .17185 1.28049 L p F P
0 g
s
.734 .655 .1 r
.17185 1.28049 m .16301 1.36285 L .16441 1.3441 L p F P
0 g
s
0 0 .046 r
.18832 1.22448 m .20519 1.14858 L .19601 1.16653 L p F P
0 g
s
0 0 .046 r
.19601 1.16653 m .17876 1.24292 L .18832 1.22448 L p F P
0 g
s
.35 .024 .264 r
.34961 .99585 m .3681 .9402 L .34395 .94984 L p F P
0 g
s
.35 .024 .264 r
.34395 .94984 m .32246 1.00653 L .34961 .99585 L p F P
0 g
s
.842 .42 .231 r
.67835 .94833 m .69932 1.00485 L .72442 1.01684 L p F P
0 g
s
.815 .405 .27 r
.69932 1.00485 m .67835 .94833 L .65384 .93889 L p F P
0 g
s
.093 0 .217 r
.25518 1.09888 m .27601 1.03229 L .25726 1.04699 L p F P
0 g
s
.093 0 .217 r
.25726 1.04699 m .2349 1.11453 L .25518 1.09888 L p F P
0 g
s
.423 .09 .294 r
.37896 .98684 m .39417 .93207 L .3681 .9402 L p F P
0 g
s
.423 .09 .294 r
.3681 .9402 m .34961 .99585 L .37896 .98684 L p F P
0 g
s
.913 .511 .15 r
.76608 1.04475 m .78818 1.11215 L .80555 1.12866 L p F P
0 g
s
.909 .51 .23 r
.78818 1.11215 m .76608 1.04475 L .74676 1.03021 L p F P
0 g
s
.815 .405 .27 r
.65384 .93889 m .67174 .9944 L .69932 1.00485 L p F P
0 g
s
.786 .388 .298 r
.67174 .9944 m .65384 .93889 L .62746 .93101 L p F P
0 g
s
0 0 .061 r
.16998 1.32541 m .17876 1.24292 L .17327 1.26167 L p F P
0 g
s
0 0 .061 r
.17327 1.26167 m .16441 1.3441 L .16998 1.32541 L p F P
0 g
s
0 0 .171 r
.20193 1.20658 m .21818 1.13117 L .20519 1.14858 L p F P
0 g
s
0 0 .171 r
.20519 1.14858 m .18832 1.22448 L .20193 1.20658 L p F P
0 g
s
.484 .144 .315 r
.41011 .97966 m .42181 .92559 L .39417 .93207 L p F P
0 g
s
.484 .144 .315 r
.39417 .93207 m .37896 .98684 L .41011 .97966 L p F P
0 g
s
.786 .388 .298 r
.62746 .93101 m .64205 .98566 L .67174 .9944 L p F P
0 g
s
.756 .367 .318 r
.64205 .98566 m .62746 .93101 L .59957 .92478 L p F P
0 g
s
.22 0 .277 r
.27882 1.08445 m .29783 1.01874 L .27601 1.03229 L p F P
0 g
s
.22 0 .277 r
.27601 1.03229 m .25518 1.09888 L .27882 1.08445 L p F P
0 g
s
.535 .19 .33 r
.44265 .9744 m .45068 .92085 L .42181 .92559 L p F P
0 g
s
.535 .19 .33 r
.42181 .92559 m .41011 .97966 L .44265 .9744 L p F P
0 g
s
.909 .51 .23 r
.74676 1.03021 m .76728 1.09667 L .78818 1.11215 L p F P
0 g
s
.888 .499 .286 r
.76728 1.09667 m .74676 1.03021 L .72442 1.01684 L p F P
0 g
s
.756 .367 .318 r
.59957 .92478 m .61062 .97875 L .64205 .98566 L p F P
0 g
s
.724 .345 .332 r
.61062 .97875 m .59957 .92478 L .57053 .9203 L p F P
0 g
s
.58 .229 .339 r
.47616 .97115 m .48038 .91792 L .45068 .92085 L p F P
0 g
s
.58 .229 .339 r
.45068 .92085 m .44265 .9744 L .47616 .97115 L p F P
0 g
s
.724 .345 .332 r
.57053 .9203 m .57787 .97379 L .61062 .97875 L p F P
0 g
s
.691 .321 .34 r
.57787 .97379 m .57053 .9203 L .54071 .91764 L p F P
0 g
s
.62 .263 .343 r
.51018 .96995 m .51053 .91684 L .48038 .91792 L p F P
0 g
s
.62 .263 .343 r
.48038 .91792 m .47616 .97115 L .51018 .96995 L p F P
0 g
s
.691 .321 .34 r
.54071 .91764 m .54424 .97084 L .57787 .97379 L p F P
0 g
s
.657 .293 .344 r
.54424 .97084 m .54071 .91764 L .51053 .91684 L p F P
0 g
s
.657 .293 .344 r
.51053 .91684 m .51018 .96995 L .54424 .97084 L p F P
0 g
s
.026 0 .262 r
.21948 1.18945 m .2349 1.11453 L .21818 1.13117 L p F P
0 g
s
.026 0 .262 r
.21818 1.13117 m .20193 1.20658 L .21948 1.18945 L p F P
0 g
s
0 0 .198 r
.17974 1.30702 m .18832 1.22448 L .17876 1.24292 L p F P
0 g
s
0 0 .198 r
.17876 1.24292 m .16998 1.32541 L .17974 1.30702 L p F P
0 g
s
.946 .589 .275 r
.82167 1.20399 m .80555 1.12866 L .78818 1.11215 L p F P
0 g
s
.319 .038 .32 r
.30556 1.07144 m .32246 1.00653 L .29783 1.01874 L p F P
0 g
s
.319 .038 .32 r
.29783 1.01874 m .27882 1.08445 L .30556 1.07144 L p F P
0 g
s
.888 .499 .286 r
.72442 1.01684 m .74307 1.08243 L .76728 1.09667 L p F P
0 g
s
.861 .482 .326 r
.74307 1.08243 m .72442 1.01684 L .69932 1.00485 L p F P
0 g
s
.398 .107 .35 r
.33506 1.06005 m .34961 .99585 L .32246 1.00653 L p F P
0 g
s
.398 .107 .35 r
.32246 1.00653 m .30556 1.07144 L .33506 1.06005 L p F P
0 g
s
.861 .482 .326 r
.69932 1.00485 m .71581 1.06965 L .74307 1.08243 L p F P
0 g
s
.832 .462 .354 r
.71581 1.06965 m .69932 1.00485 L .67174 .9944 L p F P
0 g
s
.169 0 .325 r
.24081 1.17335 m .25518 1.09888 L .2349 1.11453 L p F P
0 g
s
.169 0 .325 r
.2349 1.11453 m .21948 1.18945 L .24081 1.17335 L p F P
0 g
s
.946 .589 .275 r
.78818 1.11215 m .80343 1.187 L .82167 1.20399 L p F P
0 g
s
.929 .574 .334 r
.80343 1.187 m .78818 1.11215 L .76728 1.09667 L p F P
0 g
s
0 0 .298 r
.19366 1.28916 m .20193 1.20658 L .18832 1.22448 L p F P
0 g
s
0 0 .298 r
.18832 1.22448 m .17974 1.30702 L .19366 1.28916 L p F P
0 g
s
.462 .163 .372 r
.36698 1.05044 m .37896 .98684 L .34961 .99585 L p F P
0 g
s
.462 .163 .372 r
.34961 .99585 m .33506 1.06005 L .36698 1.05044 L p F P
0 g
s
.832 .462 .354 r
.67174 .9944 m .68584 1.05851 L .71581 1.06965 L p F P
0 g
s
.801 .441 .375 r
.68584 1.05851 m .67174 .9944 L .64205 .98566 L p F P
0 g
s
.279 .045 .369 r
.2657 1.15848 m .27882 1.08445 L .25518 1.09888 L p F P
0 g
s
.279 .045 .369 r
.25518 1.09888 m .24081 1.17335 L .2657 1.15848 L p F P
0 g
s
.516 .21 .387 r
.40088 1.04277 m .41011 .97966 L .37896 .98684 L p F P
0 g
s
.516 .21 .387 r
.37896 .98684 m .36698 1.05044 L .40088 1.04277 L p F P
0 g
s
.929 .574 .334 r
.76728 1.09667 m .78144 1.17106 L .80343 1.187 L p F P
0 g
s
.902 .554 .375 r
.78144 1.17106 m .76728 1.09667 L .74307 1.08243 L p F P
0 g
s
.801 .441 .375 r
.64205 .98566 m .65354 1.04918 L .68584 1.05851 L p F P
0 g
s
.77 .419 .389 r
.65354 1.04918 m .64205 .98566 L .61062 .97875 L p F P
0 g
s
.105 0 .366 r
.21162 1.27208 m .21948 1.18945 L .20193 1.20658 L p F P
0 g
s
.105 0 .366 r
.20193 1.20658 m .19366 1.28916 L .21162 1.27208 L p F P
0 g
s
.562 .25 .398 r
.43633 1.03716 m .44265 .9744 L .41011 .97966 L p F P
0 g
s
.562 .25 .398 r
.41011 .97966 m .40088 1.04277 L .43633 1.03716 L p F P
0 g
s
.77 .419 .389 r
.61062 .97875 m .61933 1.04181 L .65354 1.04918 L p F P
0 g
s
.739 .396 .399 r
.61933 1.04181 m .61062 .97875 L .57787 .97379 L p F P
0 g
s
.962 .646 .375 r
.82987 1.28658 m .82167 1.20399 L .80343 1.187 L p F P
0 g
s
.603 .285 .404 r
.47284 1.03368 m .47616 .97115 L .44265 .9744 L p F P
0 g
s
.603 .285 .404 r
.44265 .9744 m .43633 1.03716 L .47284 1.03368 L p F P
0 g
s
.739 .396 .399 r
.57787 .97379 m .58366 1.03651 L .61933 1.04181 L p F P
0 g
s
.708 .371 .405 r
.58366 1.03651 m .57787 .97379 L .54424 .97084 L p F P
0 g
s
.365 .117 .399 r
.29388 1.14507 m .30556 1.07144 L .27882 1.08445 L p F P
0 g
s
.365 .117 .399 r
.27882 1.08445 m .2657 1.15848 L .29388 1.14507 L p F P
0 g
s
.64 .317 .408 r
.5099 1.03241 m .51018 .96995 L .47616 .97115 L p F P
0 g
s
.64 .317 .408 r
.47616 .97115 m .47284 1.03368 L .5099 1.03241 L p F P
0 g
s
.902 .554 .375 r
.74307 1.08243 m .75594 1.1564 L .78144 1.17106 L p F P
0 g
s
.871 .531 .404 r
.75594 1.1564 m .74307 1.08243 L .71581 1.06965 L p F P
0 g
s
.708 .371 .405 r
.54424 .97084 m .54701 1.03336 L .58366 1.03651 L p F P
0 g
s
.675 .345 .408 r
.54701 1.03336 m .54424 .97084 L .51018 .96995 L p F P
0 g
s
.675 .345 .408 r
.51018 .96995 m .5099 1.03241 L .54701 1.03336 L p F P
0 g
s
.229 .045 .411 r
.23348 1.256 m .24081 1.17335 L .21948 1.18945 L p F P
0 g
s
.229 .045 .411 r
.21948 1.18945 m .21162 1.27208 L .23348 1.256 L p F P
0 g
s
.435 .176 .421 r
.325 1.13332 m .33506 1.06005 L .30556 1.07144 L p F P
0 g
s
.435 .176 .421 r
.30556 1.07144 m .29388 1.14507 L .325 1.13332 L p F P
0 g
s
.962 .646 .375 r
.80343 1.187 m .81119 1.26963 L .82987 1.28658 L p F P
0 g
s
.937 .622 .417 r
.81119 1.26963 m .80343 1.187 L .78144 1.17106 L p F P
0 g
s
.871 .531 .404 r
.71581 1.06965 m .72721 1.14322 L .75594 1.1564 L p F P
0 g
s
.841 .508 .424 r
.72721 1.14322 m .71581 1.06965 L .68584 1.05851 L p F P
0 g
s
.492 .224 .436 r
.35869 1.12341 m .36698 1.05044 L .33506 1.06005 L p F P
0 g
s
.492 .224 .436 r
.33506 1.06005 m .325 1.13332 L .35869 1.12341 L p F P
0 g
s
.841 .508 .424 r
.68584 1.05851 m .69559 1.13174 L .72721 1.14322 L p F P
0 g
s
.81 .484 .438 r
.69559 1.13174 m .68584 1.05851 L .65354 1.04918 L p F P
0 g
s
.325 .121 .442 r
.25901 1.24115 m .2657 1.15848 L .24081 1.17335 L p F P
0 g
s
.325 .121 .442 r
.24081 1.17335 m .23348 1.256 L .25901 1.24115 L p F P
0 g
s
.937 .622 .417 r
.78144 1.17106 m .78866 1.25372 L .81119 1.26963 L p F P
0 g
s
.907 .596 .446 r
.78866 1.25372 m .78144 1.17106 L .75594 1.1564 L p F P
0 g
s
.54 .265 .447 r
.3945 1.1155 m .40088 1.04277 L .36698 1.05044 L p F P
0 g
s
.54 .265 .447 r
.36698 1.05044 m .35869 1.12341 L .3945 1.1155 L p F P
0 g
s
.81 .484 .438 r
.65354 1.04918 m .66149 1.12211 L .69559 1.13174 L p F P
0 g
s
.78 .461 .448 r
.66149 1.12211 m .65354 1.04918 L .61933 1.04181 L p F P
0 g
s
.583 .301 .454 r
.43195 1.1097 m .43633 1.03716 L .40088 1.04277 L p F P
0 g
s
.583 .301 .454 r
.40088 1.04277 m .3945 1.1155 L .43195 1.1097 L p F P
0 g
s
.78 .461 .448 r
.61933 1.04181 m .62536 1.1145 L .66149 1.12211 L p F P
0 g
s
.75 .437 .455 r
.62536 1.1145 m .61933 1.04181 L .58366 1.03651 L p F P
0 g
s
.401 .183 .463 r
.28792 1.22776 m .29388 1.14507 L .2657 1.15848 L p F P
0 g
s
.401 .183 .463 r
.2657 1.15848 m .25901 1.24115 L .28792 1.22776 L p F P
0 g
s
.907 .596 .446 r
.75594 1.1564 m .7625 1.23908 L .78866 1.25372 L p F P
0 g
s
.876 .57 .466 r
.7625 1.23908 m .75594 1.1564 L .72721 1.14322 L p F P
0 g
s
.621 .333 .459 r
.47053 1.10612 m .47284 1.03368 L .43633 1.03716 L p F P
0 g
s
.621 .333 .459 r
.43633 1.03716 m .43195 1.1097 L .47053 1.10612 L p F P
0 g
s
.75 .437 .455 r
.58366 1.03651 m .58766 1.10903 L .62536 1.1145 L p F P
0 g
s
.719 .413 .459 r
.58766 1.10903 m .58366 1.03651 L .54701 1.03336 L p F P
0 g
s
.655 .361 .461 r
.50971 1.1048 m .5099 1.03241 L .47284 1.03368 L p F P
0 g
s
.655 .361 .461 r
.47284 1.03368 m .47053 1.10612 L .50971 1.1048 L p F P
0 g
s
.719 .413 .459 r
.54701 1.03336 m .54894 1.10578 L .58766 1.10903 L p F P
0 g
s
.688 .388 .461 r
.54894 1.10578 m .54701 1.03336 L .5099 1.03241 L p F P
0 g
s
.688 .388 .461 r
.5099 1.03241 m .50971 1.1048 L .54894 1.10578 L p F P
0 g
s
.463 .233 .478 r
.31987 1.21603 m .325 1.13332 L .29388 1.14507 L p F P
0 g
s
.463 .233 .478 r
.29388 1.14507 m .28792 1.22776 L .31987 1.21603 L p F P
0 g
s
.876 .57 .466 r
.72721 1.14322 m .73302 1.22592 L .7625 1.23908 L p F P
0 g
s
.845 .544 .48 r
.73302 1.22592 m .72721 1.14322 L .69559 1.13174 L p F P
0 g
s
.515 .275 .488 r
.35447 1.20613 m .35869 1.12341 L .325 1.13332 L p F P
0 g
s
.515 .275 .488 r
.325 1.13332 m .31987 1.21603 L .35447 1.20613 L p F P
0 g
s
.845 .544 .48 r
.69559 1.13174 m .70057 1.21444 L .73302 1.22592 L p F P
0 g
s
.815 .519 .49 r
.70057 1.21444 m .69559 1.13174 L .66149 1.12211 L p F P
0 g
s
.559 .311 .496 r
.39124 1.19822 m .3945 1.1155 L .35869 1.12341 L p F P
0 g
s
.559 .311 .496 r
.35869 1.12341 m .35447 1.20613 L .39124 1.19822 L p F P
0 g
s
.815 .519 .49 r
.66149 1.12211 m .66555 1.20483 L .70057 1.21444 L p F P
0 g
s
.785 .495 .497 r
.66555 1.20483 m .66149 1.12211 L .62536 1.1145 L p F P
0 g
s
.598 .343 .501 r
.42972 1.19242 m .43195 1.1097 L .3945 1.1155 L p F P
0 g
s
.598 .343 .501 r
.3945 1.1155 m .39124 1.19822 L .42972 1.19242 L p F P
0 g
s
.785 .495 .497 r
.62536 1.1145 m .62843 1.19722 L .66555 1.20483 L p F P
0 g
s
.756 .472 .501 r
.62843 1.19722 m .62536 1.1145 L .58766 1.10903 L p F P
0 g
s
.634 .372 .504 r
.46936 1.18884 m .47053 1.10612 L .43195 1.1097 L p F P
0 g
s
.634 .372 .504 r
.43195 1.1097 m .42972 1.19242 L .46936 1.18884 L p F P
0 g
s
.756 .472 .501 r
.58766 1.10903 m .58971 1.19175 L .62843 1.19722 L p F P
0 g
s
.727 .448 .504 r
.58971 1.19175 m .58766 1.10903 L .54894 1.10578 L p F P
0 g
s
.666 .398 .506 r
.50961 1.18753 m .50971 1.1048 L .47053 1.10612 L p F P
0 g
s
.666 .398 .506 r
.47053 1.10612 m .46936 1.18884 L .50961 1.18753 L p F P
0 g
s
.727 .448 .504 r
.54894 1.10578 m .54992 1.1885 L .58971 1.19175 L p F P
0 g
s
.697 .424 .506 r
.54992 1.1885 m .54894 1.10578 L .50971 1.1048 L p F P
0 g
s
.697 .424 .506 r
.50971 1.1048 m .50961 1.18753 L .54992 1.1885 L p F P
0 g
s
.25 Mabswid
.64785 0 m
.92348 .39072 L
s
.92348 .39072 m
1 1.47188 L
s
1 1.47188 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.0843 .2212 m
0 1.32748 L
s
0 1.32748 m
.67613 1.13533 L
s
.67613 1.13533 m
.64785 0 L
s
.64785 0 m
.0843 .2212 L
s
0 1.32748 m
.37669 1.62453 L
s
.02778 1.34939 m
.02852 1.3392 L
s
[(-1)] .02632 1.36978 .07184 -1 Mshowa
.11549 1.41856 m
.11609 1.40836 L
s
[(-0.5)] .1143 1.43896 .05826 -1 Mshowa
.19897 1.48438 m
.19943 1.47417 L
s
[(0)] .19803 1.5048 .04559 -1 Mshowa
.2785 1.5471 m
.27884 1.53689 L
s
[(0.5)] .27781 1.56753 .03374 -1 Mshowa
.35437 1.60693 m
.3546 1.59671 L
s
[(1)] .3539 1.62736 .02264 -1 Mshowa
.125 Mabswid
.04568 1.36351 m
.0461 1.35739 L
s
.0634 1.37748 m
.0638 1.37136 L
s
.08094 1.39131 m
.08133 1.38519 L
s
.0983 1.405 m
.09867 1.39888 L
s
.13252 1.43198 m
.13286 1.42586 L
s
.14937 1.44528 m
.1497 1.43915 L
s
.16607 1.45844 m
.16637 1.45231 L
s
.18259 1.47147 m
.18289 1.46535 L
s
.21518 1.49717 m
.21544 1.49104 L
s
.23124 1.50983 m
.23148 1.5037 L
s
.24714 1.52237 m
.24737 1.51624 L
s
.26289 1.5348 m
.26311 1.52867 L
s
.29396 1.55929 m
.29415 1.55316 L
s
.30927 1.57137 m
.30945 1.56524 L
s
.32444 1.58333 m
.32461 1.5772 L
s
.33947 1.59519 m
.33963 1.58906 L
s
.00971 1.33514 m
.01016 1.32902 L
s
.36912 1.61857 m
.36925 1.61244 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.44.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.44.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["RevolutionAxis -> {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["rotate about axis connecting the origin to a point in the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["x",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\[Hyphen]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["z",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" plane",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["RevolutionAxis -> {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "rotate about axis connecting the origin to an arbitrary point in three\
\[Hyphen]dimensional space",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.44.1"],

Cell["Specifying the axis of revolution.", "Caption",
 CellTags->"S5.44.1"],

Cell["\<\
Here is a curve rotated about a different axis in three\[Hyphen]dimensional \
space. \
\>", "MathCaption",
 CellTags->{"S5.44.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
SurfaceOfRevolution[x^2, {x, 0, 1},
    RevolutionAxis -> {1, 1, 1}]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.44.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08549 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567325 1.16577 -7.10152e-18 1.16577 [
[.10806 .22264 -5.8795 -9 ]
[.10806 .22264 .1205 0 ]
[.2978 .14253 -16.4995 -9 ]
[.2978 .14253 1.5005 0 ]
[.5032 .05588 -5.12016 -9 ]
[.5032 .05588 .87984 0 ]
[.02556 .83816 -3.44709 0 ]
[.02556 .83816 2.55291 9 ]
[.18056 .94684 -9.89695 0 ]
[.18056 .94684 8.10305 9 ]
[.31358 1.0401 -3.17908 0 ]
[.31358 1.0401 2.82092 9 ]
[.07072 .27782 -6 -2.63214 ]
[.07072 .27782 0 6.36786 ]
[.0431 .45098 -18 -2.78623 ]
[.0431 .45098 0 6.21377 ]
[.01183 .64707 -6 -2.96291 ]
[.01183 .64707 0 6.03709 ]
[ 0 0 0 0 ]
[ 1 1.08549 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08839 .24566 m
.67289 0 L
s
.11815 .23315 m
.1232 .23841 L
s
[(0)] .10806 .22264 .95983 1 Mshowa
.30713 .15372 m
.3118 .15932 L
s
[(0.5)] .2978 .14253 .83328 1 Mshowa
.51161 .06778 m
.51581 .07373 L
s
[(1)] .5032 .05588 .70672 1 Mshowa
.125 Mabswid
.15479 .21775 m
.15778 .22094 L
s
.192 .20211 m
.19494 .20535 L
s
.22978 .18623 m
.23268 .18951 L
s
.26815 .17011 m
.271 .17342 L
s
.34673 .13708 m
.34948 .14048 L
s
.38696 .12017 m
.38965 .12362 L
s
.42784 .10299 m
.43048 .10648 L
s
.46938 .08553 m
.47197 .08906 L
s
.55453 .04974 m
.557 .05336 L
s
.59817 .0314 m
.60057 .03506 L
s
.64255 .01275 m
.64488 .01645 L
s
.25 Mabswid
0 .80425 m
.39963 1.08549 L
s
.02771 .82375 m
.02878 .81654 L
s
[(0)] .02556 .83816 .14903 -1 Mshowa
.182 .93234 m
.18272 .92509 L
s
[(0.5)] .18056 .94684 .09966 -1 Mshowa
.31445 1.02555 m
.31489 1.01828 L
s
[(1)] .31358 1.0401 .05969 -1 Mshowa
.125 Mabswid
.06057 .84688 m
.06117 .84255 L
s
.09238 .86926 m
.09294 .86493 L
s
.12319 .89095 m
.12371 .88661 L
s
.15305 .91196 m
.15352 .90762 L
s
.21008 .9521 m
.21048 .94774 L
s
.23733 .97127 m
.23769 .96692 L
s
.26379 .98989 m
.26411 .98553 L
s
.28948 1.00798 m
.28978 1.00362 L
s
.33872 1.04263 m
.33895 1.03827 L
s
.36233 1.05924 m
.36253 1.05488 L
s
.38529 1.0754 m
.38546 1.07103 L
s
.25 Mabswid
.08839 .24566 m
0 .80425 L
s
.08418 .27224 m
.09091 .26944 L
s
[(0)] .07072 .27782 1 -0.41508 Mshowa
.05672 .4458 m
.06353 .44321 L
s
[(0.5)] .0431 .45098 1 -0.38084 Mshowa
.02562 .64236 m
.03251 .64 L
s
[(1)] .01183 .64707 1 -0.34157 Mshowa
.125 Mabswid
.07895 .3053 m
.083 .30365 L
s
.07359 .33917 m
.07765 .33754 L
s
.0681 .37385 m
.07217 .37224 L
s
.06248 .40938 m
.06656 .4078 L
s
.05081 .48313 m
.05491 .4816 L
s
.04475 .52142 m
.04886 .51992 L
s
.03854 .56069 m
.04266 .55922 L
s
.03216 .60099 m
.03629 .59955 L
s
.01889 .68484 m
.02304 .68346 L
s
.01199 .72848 m
.01615 .72713 L
s
.00489 .77332 m
.00906 .772 L
s
.25 Mabswid
.08839 .24566 m
0 .80425 L
s
0 .80425 m
.39963 1.08549 L
s
.39963 1.08549 m
.41732 .58107 L
s
.41732 .58107 m
.08839 .24566 L
s
.67289 0 m
.92709 .4142 L
s
.92709 .4142 m
1 .94791 L
s
1 .94791 m
.70699 .5859 L
s
.70699 .5859 m
.67289 0 L
s
.08839 .24566 m
0 .80425 L
s
0 .80425 m
.70699 .5859 L
s
.70699 .5859 m
.67289 0 L
s
.67289 0 m
.08839 .24566 L
s
.41732 .58107 m
.92709 .4142 L
s
.92709 .4142 m
1 .94791 L
s
1 .94791 m
.39963 1.08549 L
s
.39963 1.08549 m
.41732 .58107 L
s
0 0 m
1 0 L
1 1.08549 L
0 1.08549 L
closepath
clip
newpath
.5 Mabswid
.783 .665 .733 r
.54535 .62542 m .57103 .63406 L .52729 .68868 L p F P
0 g
s
.761 .67 .762 r
.57103 .63406 m .54535 .62542 L .58609 .57199 L p F P
0 g
s
.761 .67 .762 r
.58609 .57199 m .61349 .578 L .57103 .63406 L p F P
0 g
s
.739 .678 .791 r
.61349 .578 m .58609 .57199 L .6245 .51837 L p F P
0 g
s
.739 .678 .791 r
.6245 .51837 m .65349 .52202 L .61349 .578 L p F P
0 g
s
.807 .663 .704 r
.50342 .67715 m .52729 .68868 L .48345 .74033 L p F P
0 g
s
.783 .665 .733 r
.52729 .68868 m .50342 .67715 L .54535 .62542 L p F P
0 g
s
.785 .663 .728 r
.52025 .61651 m .54535 .62542 L .50342 .67715 L p F P
0 g
s
.763 .667 .757 r
.54535 .62542 m .52025 .61651 L .55934 .5657 L p F P
0 g
s
.763 .667 .757 r
.55934 .5657 m .58609 .57199 L .54535 .62542 L p F P
0 g
s
.741 .675 .786 r
.58609 .57199 m .55934 .5657 L .59622 .51442 L p F P
0 g
s
.741 .675 .786 r
.59622 .51442 m .6245 .51837 L .58609 .57199 L p F P
0 g
s
.716 .689 .822 r
.65349 .52202 m .6245 .51837 L .6594 .46611 L p F P
0 g
s
.716 .689 .822 r
.6594 .46611 m .68983 .46771 L .65349 .52202 L p F P
0 g
s
.807 .663 .704 r
.48345 .74033 m .46147 .72568 L .50342 .67715 L p F P
0 g
s
.809 .661 .698 r
.48008 .66539 m .50342 .67715 L .46147 .72568 L p F P
0 g
s
.785 .663 .728 r
.50342 .67715 m .48008 .66539 L .52025 .61651 L p F P
0 g
s
.787 .66 .723 r
.49576 .60735 m .52025 .61651 L .48008 .66539 L p F P
0 g
s
.765 .665 .752 r
.52025 .61651 m .49576 .60735 L .53325 .55912 L p F P
0 g
s
.765 .665 .752 r
.53325 .55912 m .55934 .5657 L .52025 .61651 L p F P
0 g
s
.743 .671 .781 r
.55934 .5657 m .53325 .55912 L .56867 .51017 L p F P
0 g
s
.743 .671 .781 r
.56867 .51017 m .59622 .51442 L .55934 .5657 L p F P
0 g
s
.718 .685 .817 r
.6245 .51837 m .59622 .51442 L .62976 .46419 L p F P
0 g
s
.718 .685 .817 r
.62976 .46419 m .6594 .46611 L .6245 .51837 L p F P
0 g
s
.834 .663 .671 r
.46147 .72568 m .48345 .74033 L .44077 .78743 L p F P
0 g
s
.767 .662 .747 r
.50784 .55226 m .53325 .55912 L .49576 .60735 L p F P
0 g
s
.745 .668 .776 r
.53325 .55912 m .50784 .55226 L .54186 .50561 L p F P
0 g
s
.745 .668 .776 r
.54186 .50561 m .56867 .51017 L .53325 .55912 L p F P
0 g
s
.787 .66 .723 r
.48008 .66539 m .45731 .65342 L .49576 .60735 L p F P
0 g
s
.79 .658 .718 r
.4719 .59793 m .49576 .60735 L .45731 .65342 L p F P
0 g
s
.767 .662 .747 r
.49576 .60735 m .4719 .59793 L .50784 .55226 L p F P
0 g
s
.809 .661 .698 r
.46147 .72568 m .44 .71086 L .48008 .66539 L p F P
0 g
s
.812 .659 .693 r
.45731 .65342 m .48008 .66539 L .44 .71086 L p F P
0 g
s
.72 .681 .811 r
.59622 .51442 m .56867 .51017 L .60092 .46196 L p F P
0 g
s
.72 .681 .811 r
.60092 .46196 m .62976 .46419 L .59622 .51442 L p F P
0 g
s
.769 .66 .741 r
.48312 .54511 m .50784 .55226 L .4719 .59793 L p F P
0 g
s
.747 .666 .77 r
.50784 .55226 m .48312 .54511 L .51579 .50074 L p F P
0 g
s
.747 .666 .77 r
.51579 .50074 m .54186 .50561 L .50784 .55226 L p F P
0 g
s
.723 .678 .806 r
.56867 .51017 m .54186 .50561 L .57288 .45942 L p F P
0 g
s
.723 .678 .806 r
.57288 .45942 m .60092 .46196 L .56867 .51017 L p F P
0 g
s
.834 .663 .671 r
.44077 .78743 m .42078 .76946 L .46147 .72568 L p F P
0 g
s
.837 .661 .665 r
.44 .71086 m .46147 .72568 L .42078 .76946 L p F P
0 g
s
.79 .658 .718 r
.45731 .65342 m .43514 .64123 L .4719 .59793 L p F P
0 g
s
.792 .656 .712 r
.44869 .58826 m .4719 .59793 L .43514 .64123 L p F P
0 g
s
.769 .66 .741 r
.4719 .59793 m .44869 .58826 L .48312 .54511 L p F P
0 g
s
.812 .659 .693 r
.44 .71086 m .41907 .69587 L .45731 .65342 L p F P
0 g
s
.815 .657 .687 r
.43514 .64123 m .45731 .65342 L .41907 .69587 L p F P
0 g
s
.725 .674 .8 r
.54186 .50561 m .51579 .50074 L .54563 .45656 L p F P
0 g
s
.725 .674 .8 r
.54563 .45656 m .57288 .45942 L .54186 .50561 L p F P
0 g
s
.691 .704 .857 r
.68983 .46771 m .6594 .46611 L .68959 .41684 L p F P
0 g
s
.691 .704 .857 r
.68959 .41684 m .72127 .41677 L .68983 .46771 L p F P
0 g
s
.772 .657 .736 r
.45911 .53766 m .48312 .54511 L .44869 .58826 L p F P
0 g
s
.75 .663 .765 r
.48312 .54511 m .45911 .53766 L .49046 .49557 L p F P
0 g
s
.75 .663 .765 r
.49046 .49557 m .51579 .50074 L .48312 .54511 L p F P
0 g
s
.693 .699 .851 r
.6594 .46611 m .62976 .46419 L .65879 .41661 L p F P
0 g
s
.693 .699 .851 r
.65879 .41661 m .68959 .41684 L .6594 .46611 L p F P
0 g
s
.792 .656 .712 r
.43514 .64123 m .41358 .62882 L .44869 .58826 L p F P
0 g
s
.795 .654 .706 r
.42616 .57832 m .44869 .58826 L .41358 .62882 L p F P
0 g
s
.772 .657 .736 r
.44869 .58826 m .42616 .57832 L .45911 .53766 L p F P
0 g
s
.727 .671 .795 r
.51579 .50074 m .49046 .49557 L .51919 .45338 L p F P
0 g
s
.727 .671 .795 r
.51919 .45338 m .54563 .45656 L .51579 .50074 L p F P
0 g
s
.837 .661 .665 r
.42078 .76946 m .40126 .75139 L .44 .71086 L p F P
0 g
s
.84 .659 .658 r
.41907 .69587 m .44 .71086 L .40126 .75139 L p F P
0 g
s
.815 .657 .687 r
.41907 .69587 m .39869 .68072 L .43514 .64123 L p F P
0 g
s
.818 .655 .68 r
.41358 .62882 m .43514 .64123 L .39869 .68072 L p F P
0 g
s
.695 .695 .845 r
.62976 .46419 m .60092 .46196 L .62887 .41605 L p F P
0 g
s
.695 .695 .845 r
.62887 .41605 m .65879 .41661 L .62976 .46419 L p F P
0 g
s
.775 .655 .731 r
.43582 .52993 m .45911 .53766 L .42616 .57832 L p F P
0 g
s
.752 .66 .76 r
.45911 .53766 m .43582 .52993 L .4659 .49007 L p F P
0 g
s
.752 .66 .76 r
.4659 .49007 m .49046 .49557 L .45911 .53766 L p F P
0 g
s
.698 .691 .839 r
.60092 .46196 m .57288 .45942 L .59982 .41518 L p F P
0 g
s
.698 .691 .839 r
.59982 .41518 m .62887 .41605 L .60092 .46196 L p F P
0 g
s
.73 .668 .789 r
.49046 .49557 m .4659 .49007 L .49354 .44988 L p F P
0 g
s
.73 .668 .789 r
.49354 .44988 m .51919 .45338 L .49046 .49557 L p F P
0 g
s
.865 .666 .631 r
.42078 .76946 m .44077 .78743 L .40062 .82828 L p F P
0 g
s
.795 .654 .706 r
.41358 .62882 m .39265 .61621 L .42616 .57832 L p F P
0 g
s
.798 .652 .701 r
.40431 .56813 m .42616 .57832 L .39265 .61621 L p F P
0 g
s
.775 .655 .731 r
.42616 .57832 m .40431 .56813 L .43582 .52993 L p F P
0 g
s
.701 .686 .833 r
.57288 .45942 m .54563 .45656 L .57163 .414 L p F P
0 g
s
.701 .686 .833 r
.57163 .414 m .59982 .41518 L .57288 .45942 L p F P
0 g
s
.778 .653 .725 r
.41328 .5219 m .43582 .52993 L .40431 .56813 L p F P
0 g
s
.755 .658 .754 r
.43582 .52993 m .41328 .5219 L .4421 .48426 L p F P
0 g
s
.755 .658 .754 r
.4421 .48426 m .4659 .49007 L .43582 .52993 L p F P
0 g
s
.818 .655 .68 r
.39869 .68072 m .37889 .66543 L .41358 .62882 L p F P
0 g
s
.821 .653 .674 r
.39265 .61621 m .41358 .62882 L .37889 .66543 L p F P
0 g
s
.84 .659 .658 r
.40126 .75139 m .38225 .73323 L .41907 .69587 L p F P
0 g
s
.843 .657 .651 r
.39869 .68072 m .41907 .69587 L .38225 .73323 L p F P
0 g
s
.733 .665 .784 r
.4659 .49007 m .4421 .48426 L .46869 .44604 L p F P
0 g
s
.733 .665 .784 r
.46869 .44604 m .49354 .44988 L .4659 .49007 L p F P
0 g
s
.703 .683 .827 r
.54563 .45656 m .51919 .45338 L .54428 .4125 L p F P
0 g
s
.703 .683 .827 r
.54428 .4125 m .57163 .414 L .54563 .45656 L p F P
0 g
s
.798 .652 .701 r
.39265 .61621 m .37239 .60338 L .40431 .56813 L p F P
0 g
s
.802 .651 .695 r
.38318 .55768 m .40431 .56813 L .37239 .60338 L p F P
0 g
s
.778 .653 .725 r
.40431 .56813 m .38318 .55768 L .41328 .5219 L p F P
0 g
s
.706 .679 .821 r
.51919 .45338 m .49354 .44988 L .51777 .41068 L p F P
0 g
s
.706 .679 .821 r
.51777 .41068 m .54428 .4125 L .51919 .45338 L p F P
0 g
s
.781 .651 .719 r
.39148 .51357 m .41328 .5219 L .38318 .55768 L p F P
0 g
s
.758 .656 .749 r
.41328 .5219 m .39148 .51357 L .41908 .47813 L p F P
0 g
s
.758 .656 .749 r
.41908 .47813 m .4421 .48426 L .41328 .5219 L p F P
0 g
s
.736 .663 .778 r
.4421 .48426 m .41908 .47813 L .44464 .44188 L p F P
0 g
s
.736 .663 .778 r
.44464 .44188 m .46869 .44604 L .4421 .48426 L p F P
0 g
s
.865 .666 .631 r
.40062 .82828 m .38269 .80683 L .42078 .76946 L p F P
0 g
s
.868 .664 .623 r
.40126 .75139 m .42078 .76946 L .38269 .80683 L p F P
0 g
s
.821 .653 .674 r
.37889 .66543 m .3597 .64999 L .39265 .61621 L p F P
0 g
s
.825 .651 .667 r
.37239 .60338 m .39265 .61621 L .3597 .64999 L p F P
0 g
s
.709 .675 .815 r
.49354 .44988 m .46869 .44604 L .49209 .40853 L p F P
0 g
s
.709 .675 .815 r
.49209 .40853 m .51777 .41068 L .49354 .44988 L p F P
0 g
s
.843 .657 .651 r
.38225 .73323 m .36376 .71499 L .39869 .68072 L p F P
0 g
s
.847 .656 .644 r
.37889 .66543 m .39869 .68072 L .36376 .71499 L p F P
0 g
s
.761 .654 .743 r
.39685 .47167 m .41908 .47813 L .39148 .51357 L p F P
0 g
s
.739 .66 .772 r
.41908 .47813 m .39685 .47167 L .42138 .43739 L p F P
0 g
s
.739 .66 .772 r
.42138 .43739 m .44464 .44188 L .41908 .47813 L p F P
0 g
s
.802 .651 .695 r
.37239 .60338 m .35282 .59036 L .38318 .55768 L p F P
0 g
s
.805 .649 .688 r
.36278 .54697 m .38318 .55768 L .35282 .59036 L p F P
0 g
s
.781 .651 .719 r
.38318 .55768 m .36278 .54697 L .39148 .51357 L p F P
0 g
s
.784 .65 .714 r
.37046 .50494 m .39148 .51357 L .36278 .54697 L p F P
0 g
s
.761 .654 .743 r
.39148 .51357 m .37046 .50494 L .39685 .47167 L p F P
0 g
s
.713 .672 .809 r
.46869 .44604 m .44464 .44188 L .46723 .40607 L p F P
0 g
s
.713 .672 .809 r
.46723 .40607 m .49209 .40853 L .46869 .44604 L p F P
0 g
s
.868 .664 .623 r
.38269 .80683 m .3652 .78538 L .40126 .75139 L p F P
0 g
s
.872 .662 .615 r
.38225 .73323 m .40126 .75139 L .3652 .78538 L p F P
0 g
s
.825 .651 .667 r
.3597 .64999 m .34115 .63442 L .37239 .60338 L p F P
0 g
s
.829 .65 .66 r
.35282 .59036 m .37239 .60338 L .34115 .63442 L p F P
0 g
s
.658 .724 .897 r
.72127 .41677 m .68959 .41684 L .7138 .37238 L p F P
0 g
s
.658 .724 .897 r
.7138 .37238 m .74647 .37107 L .72127 .41677 L p F P
0 g
s
.765 .653 .738 r
.37541 .46489 m .39685 .47167 L .37046 .50494 L p F P
0 g
s
.743 .659 .767 r
.39685 .47167 m .37541 .46489 L .39894 .43256 L p F P
0 g
s
.743 .659 .767 r
.39894 .43256 m .42138 .43739 L .39685 .47167 L p F P
0 g
s
.716 .67 .803 r
.44464 .44188 m .42138 .43739 L .44318 .40328 L p F P
0 g
s
.716 .67 .803 r
.44318 .40328 m .46723 .40607 L .44464 .44188 L p F P
0 g
s
.662 .718 .891 r
.68959 .41684 m .65879 .41661 L .68211 .37338 L p F P
0 g
s
.662 .718 .891 r
.68211 .37338 m .7138 .37238 L .68959 .41684 L p F P
0 g
s
.665 .713 .884 r
.65879 .41661 m .62887 .41605 L .65139 .37408 L p F P
0 g
s
.665 .713 .884 r
.65139 .37408 m .68211 .37338 L .65879 .41661 L p F P
0 g
s
.847 .656 .644 r
.36376 .71499 m .34583 .69669 L .37889 .66543 L p F P
0 g
s
.851 .654 .636 r
.3597 .64999 m .37889 .66543 L .34583 .69669 L p F P
0 g
s
.784 .65 .714 r
.36278 .54697 m .34313 .53601 L .37046 .50494 L p F P
0 g
s
.788 .649 .708 r
.35022 .49601 m .37046 .50494 L .34313 .53601 L p F P
0 g
s
.765 .653 .738 r
.37046 .50494 m .35022 .49601 L .37541 .46489 L p F P
0 g
s
.668 .708 .877 r
.62887 .41605 m .59982 .41518 L .6216 .37448 L p F P
0 g
s
.668 .708 .877 r
.6216 .37448 m .65139 .37408 L .62887 .41605 L p F P
0 g
s
.805 .649 .688 r
.35282 .59036 m .33396 .57715 L .36278 .54697 L p F P
0 g
s
.81 .648 .682 r
.34313 .53601 m .36278 .54697 L .33396 .57715 L p F P
0 g
s
.672 .703 .87 r
.59982 .41518 m .57163 .414 L .59273 .37458 L p F P
0 g
s
.672 .703 .87 r
.59273 .37458 m .6216 .37448 L .59982 .41518 L p F P
0 g
s
.72 .667 .797 r
.42138 .43739 m .39894 .43256 L .41995 .40016 L p F P
0 g
s
.72 .667 .797 r
.41995 .40016 m .44318 .40328 L .42138 .43739 L p F P
0 g
s
.675 .698 .863 r
.57163 .414 m .54428 .4125 L .56475 .37438 L p F P
0 g
s
.675 .698 .863 r
.56475 .37438 m .59273 .37458 L .57163 .414 L p F P
0 g
s
.769 .651 .732 r
.35478 .45777 m .37541 .46489 L .35022 .49601 L p F P
0 g
s
.747 .657 .762 r
.37541 .46489 m .35478 .45777 L .37729 .42738 L p F P
0 g
s
.747 .657 .762 r
.37729 .42738 m .39894 .43256 L .37541 .46489 L p F P
0 g
s
.679 .693 .857 r
.54428 .4125 m .51777 .41068 L .53764 .37388 L p F P
0 g
s
.679 .693 .857 r
.53764 .37388 m .56475 .37438 L .54428 .4125 L p F P
0 g
s
.829 .65 .66 r
.34115 .63442 m .32326 .61873 L .35282 .59036 L p F P
0 g
s
.833 .649 .653 r
.33396 .57715 m .35282 .59036 L .32326 .61873 L p F P
0 g
s
.683 .689 .85 r
.51777 .41068 m .49209 .40853 L .5114 .37308 L p F P
0 g
s
.683 .689 .85 r
.5114 .37308 m .53764 .37388 L .51777 .41068 L p F P
0 g
s
.788 .649 .708 r
.34313 .53601 m .32426 .52479 L .35022 .49601 L p F P
0 g
s
.793 .648 .702 r
.33078 .48678 m .35022 .49601 L .32426 .52479 L p F P
0 g
s
.769 .651 .732 r
.35022 .49601 m .33078 .48678 L .35478 .45777 L p F P
0 g
s
.724 .665 .792 r
.39894 .43256 m .37729 .42738 L .39751 .3967 L p F P
0 g
s
.724 .665 .792 r
.39751 .3967 m .41995 .40016 L .39894 .43256 L p F P
0 g
s
.872 .662 .615 r
.3652 .78538 m .34819 .76394 L .38225 .73323 L p F P
0 g
s
.877 .66 .606 r
.36376 .71499 m .38225 .73323 L .34819 .76394 L p F P
0 g
s
.81 .648 .682 r
.33396 .57715 m .31583 .56374 L .34313 .53601 L p F P
0 g
s
.814 .647 .676 r
.32426 .52479 m .34313 .53601 L .31583 .56374 L p F P
0 g
s
.687 .685 .843 r
.49209 .40853 m .46723 .40607 L .48599 .37198 L p F P
0 g
s
.687 .685 .843 r
.48599 .37198 m .5114 .37308 L .49209 .40853 L p F P
0 g
s
.851 .654 .636 r
.34583 .69669 m .32848 .67834 L .3597 .64999 L p F P
0 g
s
.855 .653 .627 r
.34115 .63442 m .3597 .64999 L .32848 .67834 L p F P
0 g
s
.773 .651 .727 r
.33495 .45032 m .35478 .45777 L .33078 .48678 L p F P
0 g
s
.751 .656 .756 r
.35478 .45777 m .33495 .45032 L .35646 .42186 L p F P
0 g
s
.751 .656 .756 r
.35646 .42186 m .37729 .42738 L .35478 .45777 L p F P
0 g
s
.691 .682 .837 r
.46723 .40607 m .44318 .40328 L .46141 .37058 L p F P
0 g
s
.691 .682 .837 r
.46141 .37058 m .48599 .37198 L .46723 .40607 L p F P
0 g
s
.728 .664 .786 r
.37729 .42738 m .35646 .42186 L .37587 .39292 L p F P
0 g
s
.728 .664 .786 r
.37587 .39292 m .39751 .3967 L .37729 .42738 L p F P
0 g
s
.901 .67 .579 r
.38269 .80683 m .40062 .82828 L .36454 .86107 L p F P
0 g
s
.793 .648 .702 r
.32426 .52479 m .30618 .51332 L .33078 .48678 L p F P
0 g
s
.797 .648 .697 r
.31216 .47724 m .33078 .48678 L .30618 .51332 L p F P
0 g
s
.773 .651 .727 r
.33078 .48678 m .31216 .47724 L .33495 .45032 L p F P
0 g
s
.695 .679 .83 r
.44318 .40328 m .41995 .40016 L .43763 .36887 L p F P
0 g
s
.695 .679 .83 r
.43763 .36887 m .46141 .37058 L .44318 .40328 L p F P
0 g
s
.833 .649 .653 r
.32326 .61873 m .30606 .60293 L .33396 .57715 L p F P
0 g
s
.838 .648 .646 r
.31583 .56374 m .33396 .57715 L .30606 .60293 L p F P
0 g
s
.814 .647 .676 r
.31583 .56374 m .29846 .55015 L .32426 .52479 L p F P
0 g
s
.819 .647 .669 r
.30618 .51332 m .32426 .52479 L .29846 .55015 L p F P
0 g
s
.778 .651 .722 r
.31595 .44253 m .33495 .45032 L .31216 .47724 L p F P
0 g
s
.755 .655 .751 r
.33495 .45032 m .31595 .44253 L .33643 .416 L p F P
0 g
s
.755 .655 .751 r
.33643 .416 m .35646 .42186 L .33495 .45032 L p F P
0 g
s
.7 .676 .824 r
.41995 .40016 m .39751 .3967 L .41465 .36687 L p F P
0 g
s
.7 .676 .824 r
.41465 .36687 m .43763 .36887 L .41995 .40016 L p F P
0 g
s
.733 .663 .781 r
.35646 .42186 m .33643 .416 L .35503 .38879 L p F P
0 g
s
.733 .663 .781 r
.35503 .38879 m .37587 .39292 L .35646 .42186 L p F P
0 g
s
.877 .66 .606 r
.34819 .76394 m .33167 .74254 L .36376 .71499 L p F P
0 g
s
.881 .658 .596 r
.34583 .69669 m .36376 .71499 L .33167 .74254 L p F P
0 g
s
.855 .653 .627 r
.32848 .67834 m .31173 .65997 L .34115 .63442 L p F P
0 g
s
.86 .651 .619 r
.32326 .61873 m .34115 .63442 L .31173 .65997 L p F P
0 g
s
.704 .674 .818 r
.39751 .3967 m .37587 .39292 L .39245 .36455 L p F P
0 g
s
.704 .674 .818 r
.39245 .36455 m .41465 .36687 L .39751 .3967 L p F P
0 g
s
.797 .648 .697 r
.30618 .51332 m .28891 .5016 L .31216 .47724 L p F P
0 g
s
.802 .648 .691 r
.29436 .4674 m .31216 .47724 L .28891 .5016 L p F P
0 g
s
.778 .651 .722 r
.31216 .47724 m .29436 .4674 L .31595 .44253 L p F P
0 g
s
.76 .655 .746 r
.31722 .40978 m .33643 .416 L .31595 .44253 L p F P
0 g
s
.738 .662 .776 r
.33643 .416 m .31722 .40978 L .33497 .38432 L p F P
0 g
s
.738 .662 .776 r
.33497 .38432 m .35503 .38879 L .33643 .416 L p F P
0 g
s
.783 .651 .717 r
.29779 .4344 m .31595 .44253 L .29436 .4674 L p F P
0 g
s
.76 .655 .746 r
.31595 .44253 m .29779 .4344 L .31722 .40978 L p F P
0 g
s
.838 .648 .646 r
.30606 .60293 m .28956 .58703 L .31583 .56374 L p F P
0 g
s
.843 .647 .638 r
.29846 .55015 m .31583 .56374 L .28956 .58703 L p F P
0 g
s
.819 .647 .669 r
.29846 .55015 m .28187 .53638 L .30618 .51332 L p F P
0 g
s
.824 .647 .663 r
.28891 .5016 m .30618 .51332 L .28187 .53638 L p F P
0 g
s
.709 .672 .812 r
.37587 .39292 m .35503 .38879 L .37102 .36193 L p F P
0 g
s
.709 .672 .812 r
.37102 .36193 m .39245 .36455 L .37587 .39292 L p F P
0 g
s
.901 .67 .579 r
.36454 .86107 m .34871 .83606 L .38269 .80683 L p F P
0 g
s
.906 .668 .568 r
.3652 .78538 m .38269 .80683 L .34871 .83606 L p F P
0 g
s
.86 .651 .619 r
.31173 .65997 m .29562 .64158 L .32326 .61873 L p F P
0 g
s
.865 .65 .609 r
.30606 .60293 m .32326 .61873 L .29562 .64158 L p F P
0 g
s
.714 .671 .807 r
.35503 .38879 m .33497 .38432 L .35034 .359 L p F P
0 g
s
.714 .671 .807 r
.35034 .359 m .37102 .36193 L .35503 .38879 L p F P
0 g
s
.765 .656 .742 r
.29882 .4032 m .31722 .40978 L .29779 .4344 L p F P
0 g
s
.743 .662 .771 r
.31722 .40978 m .29882 .4032 L .31569 .3795 L p F P
0 g
s
.743 .662 .771 r
.31569 .3795 m .33497 .38432 L .31722 .40978 L p F P
0 g
s
.881 .658 .596 r
.33167 .74254 m .31567 .7212 L .34583 .69669 L p F P
0 g
s
.886 .657 .586 r
.32848 .67834 m .34583 .69669 L .31567 .7212 L p F P
0 g
s
.802 .648 .691 r
.28891 .5016 m .27246 .48963 L .29436 .4674 L p F P
0 g
s
.808 .649 .686 r
.27741 .45725 m .29436 .4674 L .27246 .48963 L p F P
0 g
s
.783 .651 .717 r
.29436 .4674 m .27741 .45725 L .29779 .4344 L p F P
0 g
s
.788 .652 .712 r
.28046 .42592 m .29779 .4344 L .27741 .45725 L p F P
0 g
s
.765 .656 .742 r
.29779 .4344 m .28046 .42592 L .29882 .4032 L p F P
0 g
s
.649 .708 .89 r
.53764 .37388 m .5114 .37308 L .52574 .34107 L p F P
0 g
s
.654 .703 .882 r
.5114 .37308 m .48599 .37198 L .50009 .34094 L p F P
0 g
s
.654 .703 .882 r
.50009 .34094 m .52574 .34107 L .5114 .37308 L p F P
0 g
s
.644 .713 .898 r
.56475 .37438 m .53764 .37388 L .55224 .34094 L p F P
0 g
s
.649 .708 .89 r
.52574 .34107 m .55224 .34094 L .53764 .37388 L p F P
0 g
s
.66 .698 .875 r
.48599 .37198 m .46141 .37058 L .47526 .34056 L p F P
0 g
s
.66 .698 .875 r
.47526 .34056 m .50009 .34094 L .48599 .37198 L p F P
0 g
s
.824 .647 .663 r
.28187 .53638 m .26607 .52244 L .28891 .5016 L p F P
0 g
s
.829 .647 .656 r
.27246 .48963 m .28891 .5016 L .26607 .52244 L p F P
0 g
s
.638 .718 .906 r
.59273 .37458 m .56475 .37438 L .57962 .34055 L p F P
0 g
s
.644 .713 .898 r
.55224 .34094 m .57962 .34055 L .56475 .37438 L p F P
0 g
s
.843 .647 .638 r
.28956 .58703 m .2738 .57105 L .29846 .55015 L p F P
0 g
s
.849 .647 .63 r
.28187 .53638 m .29846 .55015 L .2738 .57105 L p F P
0 g
s
.665 .694 .868 r
.46141 .37058 m .43763 .36887 L .45123 .33992 L p F P
0 g
s
.665 .694 .868 r
.45123 .33992 m .47526 .34056 L .46141 .37058 L p F P
0 g
s
.72 .671 .801 r
.33497 .38432 m .31569 .3795 L .33042 .35575 L p F P
0 g
s
.72 .671 .801 r
.33042 .35575 m .35034 .359 L .33497 .38432 L p F P
0 g
s
.633 .724 .913 r
.6216 .37448 m .59273 .37458 L .6079 .3399 L p F P
0 g
s
.638 .718 .906 r
.57962 .34055 m .6079 .3399 L .59273 .37458 L p F P
0 g
s
.671 .691 .86 r
.43763 .36887 m .41465 .36687 L .42798 .33902 L p F P
0 g
s
.671 .691 .86 r
.42798 .33902 m .45123 .33992 L .43763 .36887 L p F P
0 g
s
.77 .657 .738 r
.28125 .39625 m .29882 .4032 L .28046 .42592 L p F P
0 g
s
.748 .663 .767 r
.29882 .4032 m .28125 .39625 L .2972 .37433 L p F P
0 g
s
.748 .663 .767 r
.2972 .37433 m .31569 .3795 L .29882 .4032 L p F P
0 g
s
.627 .73 .921 r
.65139 .37408 m .6216 .37448 L .63712 .33899 L p F P
0 g
s
.633 .724 .913 r
.6079 .3399 m .63712 .33899 L .6216 .37448 L p F P
0 g
s
.677 .688 .853 r
.41465 .36687 m .39245 .36455 L .40549 .33787 L p F P
0 g
s
.677 .688 .853 r
.40549 .33787 m .42798 .33902 L .41465 .36687 L p F P
0 g
s
.906 .668 .568 r
.34871 .83606 m .3333 .81118 L .3652 .78538 L p F P
0 g
s
.91 .666 .556 r
.34819 .76394 m .3652 .78538 L .3333 .81118 L p F P
0 g
s
.808 .649 .686 r
.27246 .48963 m .25687 .47742 L .27741 .45725 L p F P
0 g
s
.813 .651 .681 r
.26132 .44679 m .27741 .45725 L .25687 .47742 L p F P
0 g
s
.788 .652 .712 r
.27741 .45725 m .26132 .44679 L .28046 .42592 L p F P
0 g
s
.622 .737 .929 r
.68211 .37338 m .65139 .37408 L .66731 .33782 L p F P
0 g
s
.627 .73 .921 r
.63712 .33899 m .66731 .33782 L .65139 .37408 L p F P
0 g
s
.794 .654 .708 r
.26399 .41709 m .28046 .42592 L .26132 .44679 L p F P
0 g
s
.77 .657 .738 r
.28046 .42592 m .26399 .41709 L .28125 .39625 L p F P
0 g
s
.683 .686 .847 r
.39245 .36455 m .37102 .36193 L .38374 .33647 L p F P
0 g
s
.683 .686 .847 r
.38374 .33647 m .40549 .33787 L .39245 .36455 L p F P
0 g
s
.726 .671 .796 r
.31569 .3795 m .2972 .37433 L .31123 .35218 L p F P
0 g
s
.726 .671 .796 r
.31123 .35218 m .33042 .35575 L .31569 .3795 L p F P
0 g
s
.865 .65 .609 r
.29562 .64158 m .28015 .62319 L .30606 .60293 L p F P
0 g
s
.871 .649 .599 r
.28956 .58703 m .30606 .60293 L .28015 .62319 L p F P
0 g
s
.616 .743 .936 r
.7138 .37238 m .68211 .37338 L .6985 .33638 L p F P
0 g
s
.622 .737 .929 r
.66731 .33782 m .6985 .33638 L .68211 .37338 L p F P
0 g
s
.886 .657 .586 r
.31567 .7212 m .30022 .69994 L .32848 .67834 L p F P
0 g
s
.891 .655 .574 r
.31173 .65997 m .32848 .67834 L .30022 .69994 L p F P
0 g
s
.689 .684 .84 r
.37102 .36193 m .35034 .359 L .36271 .3348 L p F P
0 g
s
.689 .684 .84 r
.36271 .3348 m .38374 .33647 L .37102 .36193 L p F P
0 g
s
.829 .647 .656 r
.26607 .52244 m .2511 .50834 L .27246 .48963 L p F P
0 g
s
.836 .649 .65 r
.25687 .47742 m .27246 .48963 L .2511 .50834 L p F P
0 g
s
.776 .659 .734 r
.2645 .38894 m .28125 .39625 L .26399 .41709 L p F P
0 g
s
.754 .665 .763 r
.28125 .39625 m .2645 .38894 L .27949 .3688 L p F P
0 g
s
.754 .665 .763 r
.27949 .3688 m .2972 .37433 L .28125 .39625 L p F P
0 g
s
.611 .749 .943 r
.74647 .37107 m .7138 .37238 L .73072 .33466 L p F P
0 g
s
.616 .743 .936 r
.6985 .33638 m .73072 .33466 L .7138 .37238 L p F P
0 g
s
.849 .647 .63 r
.2738 .57105 m .25879 .55498 L .28187 .53638 L p F P
0 g
s
.855 .647 .622 r
.26607 .52244 m .28187 .53638 L .25879 .55498 L p F P
0 g
s
.695 .683 .835 r
.35034 .359 m .33042 .35575 L .34238 .33288 L p F P
0 g
s
.695 .683 .835 r
.34238 .33288 m .36271 .3348 L .35034 .359 L p F P
0 g
s
.732 .673 .792 r
.2972 .37433 m .27949 .3688 L .29277 .34829 L p F P
0 g
s
.732 .673 .792 r
.29277 .34829 m .31123 .35218 L .2972 .37433 L p F P
0 g
s
.794 .654 .708 r
.26132 .44679 m .2461 .43602 L .26399 .41709 L p F P
0 g
s
.8 .657 .704 r
.24838 .40791 m .26399 .41709 L .2461 .43602 L p F P
0 g
s
.776 .659 .734 r
.26399 .41709 m .24838 .40791 L .2645 .38894 L p F P
0 g
s
.813 .651 .681 r
.25687 .47742 m .24214 .46496 L .26132 .44679 L p F P
0 g
s
.82 .653 .676 r
.2461 .43602 m .26132 .44679 L .24214 .46496 L p F P
0 g
s
.611 .749 .943 r
.73072 .33466 m .76402 .33267 L .74647 .37107 L p F P
0 g
s
.702 .683 .829 r
.33042 .35575 m .31123 .35218 L .32274 .33069 L p F P
0 g
s
.702 .683 .829 r
.32274 .33069 m .34238 .33288 L .33042 .35575 L p F P
0 g
s
.871 .649 .599 r
.28015 .62319 m .26537 .60482 L .28956 .58703 L p F P
0 g
s
.877 .649 .589 r
.2738 .57105 m .28956 .58703 L .26537 .60482 L p F P
0 g
s
.91 .666 .556 r
.3333 .81118 m .31832 .78646 L .34819 .76394 L p F P
0 g
s
.915 .663 .543 r
.33167 .74254 m .34819 .76394 L .31832 .78646 L p F P
0 g
s
.783 .662 .73 r
.24858 .38126 m .2645 .38894 L .24838 .40791 L p F P
0 g
s
.76 .667 .759 r
.2645 .38894 m .24858 .38126 L .26256 .36291 L p F P
0 g
s
.76 .667 .759 r
.26256 .36291 m .27949 .3688 L .2645 .38894 L p F P
0 g
s
.836 .649 .65 r
.2511 .50834 m .23697 .49408 L .25687 .47742 L p F P
0 g
s
.842 .651 .644 r
.24214 .46496 m .25687 .47742 L .23697 .49408 L p F P
0 g
s
.739 .674 .788 r
.27949 .3688 m .26256 .36291 L .27503 .34408 L p F P
0 g
s
.739 .674 .788 r
.27503 .34408 m .29277 .34829 L .27949 .3688 L p F P
0 g
s
.891 .655 .574 r
.30022 .69994 m .28534 .67878 L .31173 .65997 L p F P
0 g
s
.897 .653 .562 r
.29562 .64158 m .31173 .65997 L .28534 .67878 L p F P
0 g
s
.855 .647 .622 r
.25879 .55498 m .24456 .53885 L .26607 .52244 L p F P
0 g
s
.861 .648 .613 r
.2511 .50834 m .26607 .52244 L .24456 .53885 L p F P
0 g
s
.709 .684 .824 r
.31123 .35218 m .29277 .34829 L .30377 .32824 L p F P
0 g
s
.709 .684 .824 r
.30377 .32824 m .32274 .33069 L .31123 .35218 L p F P
0 g
s
.8 .657 .704 r
.2461 .43602 m .23177 .42494 L .24838 .40791 L p F P
0 g
s
.807 .66 .7 r
.23363 .39837 m .24838 .40791 L .23177 .42494 L p F P
0 g
s
.783 .662 .73 r
.24838 .40791 m .23363 .39837 L .24858 .38126 L p F P
0 g
s
.82 .653 .676 r
.24214 .46496 m .2283 .45226 L .2461 .43602 L p F P
0 g
s
.826 .656 .671 r
.23177 .42494 m .2461 .43602 L .2283 .45226 L p F P
0 g
s
.789 .666 .727 r
.23349 .37319 m .24858 .38126 L .23363 .39837 L p F P
0 g
s
.767 .67 .756 r
.24858 .38126 m .23349 .37319 L .24641 .35665 L p F P
0 g
s
.767 .67 .756 r
.24641 .35665 m .26256 .36291 L .24858 .38126 L p F P
0 g
s
.716 .685 .819 r
.29277 .34829 m .27503 .34408 L .28546 .32552 L p F P
0 g
s
.716 .685 .819 r
.28546 .32552 m .30377 .32824 L .29277 .34829 L p F P
0 g
s
.746 .677 .784 r
.26256 .36291 m .24641 .35665 L .25801 .33953 L p F P
0 g
s
.746 .677 .784 r
.25801 .33953 m .27503 .34408 L .26256 .36291 L p F P
0 g
s
.842 .651 .644 r
.23697 .49408 m .22369 .47966 L .24214 .46496 L p F P
0 g
s
.849 .654 .638 r
.2283 .45226 m .24214 .46496 L .22369 .47966 L p F P
0 g
s
.877 .649 .589 r
.26537 .60482 m .25128 .58649 L .2738 .57105 L p F P
0 g
s
.884 .649 .578 r
.25879 .55498 m .2738 .57105 L .25128 .58649 L p F P
0 g
s
.641 .707 .895 r
.42798 .33902 m .40549 .33787 L .41438 .31399 L p F P
0 g
s
.649 .704 .887 r
.40549 .33787 m .38374 .33647 L .3926 .31345 L p F P
0 g
s
.649 .704 .887 r
.3926 .31345 m .41438 .31399 L .40549 .33787 L p F P
0 g
s
.633 .71 .903 r
.45123 .33992 m .42798 .33902 L .43686 .31434 L p F P
0 g
s
.641 .707 .895 r
.41438 .31399 m .43686 .31434 L .42798 .33902 L p F P
0 g
s
.657 .701 .879 r
.38374 .33647 m .36271 .3348 L .3715 .31273 L p F P
0 g
s
.657 .701 .879 r
.3715 .31273 m .3926 .31345 L .38374 .33647 L p F P
0 g
s
.861 .648 .613 r
.24456 .53885 m .23113 .52267 L .2511 .50834 L p F P
0 g
s
.868 .65 .605 r
.23697 .49408 m .2511 .50834 L .23113 .52267 L p F P
0 g
s
.807 .66 .7 r
.23177 .42494 m .21834 .41355 L .23363 .39837 L p F P
0 g
s
.814 .664 .697 r
.21977 .38847 m .23363 .39837 L .21834 .41355 L p F P
0 g
s
.789 .666 .727 r
.23363 .39837 m .21977 .38847 L .23349 .37319 L p F P
0 g
s
.625 .715 .911 r
.47526 .34056 m .45123 .33992 L .46006 .31451 L p F P
0 g
s
.633 .71 .903 r
.43686 .31434 m .46006 .31451 L .45123 .33992 L p F P
0 g
s
.915 .663 .543 r
.31832 .78646 m .3038 .76192 L .33167 .74254 L p F P
0 g
s
.921 .661 .528 r
.31567 .7212 m .33167 .74254 L .3038 .76192 L p F P
0 g
s
.665 .7 .872 r
.36271 .3348 m .34238 .33288 L .35105 .31182 L p F P
0 g
s
.665 .7 .872 r
.35105 .31182 m .3715 .31273 L .36271 .3348 L p F P
0 g
s
.826 .656 .671 r
.2283 .45226 m .21535 .43933 L .23177 .42494 L p F P
0 g
s
.834 .66 .667 r
.21834 .41355 m .23177 .42494 L .21535 .43933 L p F P
0 g
s
.723 .687 .815 r
.27503 .34408 m .25801 .33953 L .2678 .32253 L p F P
0 g
s
.723 .687 .815 r
.2678 .32253 m .28546 .32552 L .27503 .34408 L p F P
0 g
s
.897 .653 .562 r
.28534 .67878 m .27105 .65774 L .29562 .64158 L p F P
0 g
s
.903 .652 .548 r
.28015 .62319 m .29562 .64158 L .27105 .65774 L p F P
0 g
s
.616 .72 .919 r
.50009 .34094 m .47526 .34056 L .48402 .3145 L p F P
0 g
s
.625 .715 .911 r
.46006 .31451 m .48402 .3145 L .47526 .34056 L p F P
0 g
s
.673 .699 .866 r
.34238 .33288 m .32274 .33069 L .33123 .31073 L p F P
0 g
s
.673 .699 .866 r
.33123 .31073 m .35105 .31182 L .34238 .33288 L p F P
0 g
s
.774 .674 .753 r
.23104 .35002 m .24641 .35665 L .23349 .37319 L p F P
0 g
s
.753 .681 .781 r
.24641 .35665 m .23104 .35002 L .2417 .33464 L p F P
0 g
s
.753 .681 .781 r
.2417 .33464 m .25801 .33953 L .24641 .35665 L p F P
0 g
s
.797 .671 .725 r
.21924 .36474 m .23349 .37319 L .21977 .38847 L p F P
0 g
s
.774 .674 .753 r
.23349 .37319 m .21924 .36474 L .23104 .35002 L p F P
0 g
s
.608 .725 .928 r
.52574 .34107 m .50009 .34094 L .50875 .3143 L p F P
0 g
s
.616 .72 .919 r
.48402 .3145 m .50875 .3143 L .50009 .34094 L p F P
0 g
s
.682 .699 .86 r
.32274 .33069 m .30377 .32824 L .31202 .30946 L p F P
0 g
s
.682 .699 .86 r
.31202 .30946 m .33123 .31073 L .32274 .33069 L p F P
0 g
s
.849 .654 .638 r
.22369 .47966 m .2113 .46511 L .2283 .45226 L p F P
0 g
s
.857 .658 .632 r
.21535 .43933 m .2283 .45226 L .2113 .46511 L p F P
0 g
s
.599 .731 .936 r
.55224 .34094 m .52574 .34107 L .53431 .31392 L p F P
0 g
s
.608 .725 .928 r
.50875 .3143 m .53431 .31392 L .52574 .34107 L p F P
0 g
s
.731 .69 .811 r
.25801 .33953 m .2417 .33464 L .25078 .31926 L p F P
0 g
s
.731 .69 .811 r
.25078 .31926 m .2678 .32253 L .25801 .33953 L p F P
0 g
s
.69 .7 .854 r
.30377 .32824 m .28546 .32552 L .2934 .308 L p F P
0 g
s
.69 .7 .854 r
.2934 .308 m .31202 .30946 L .30377 .32824 L p F P
0 g
s
.884 .649 .578 r
.25128 .58649 m .23792 .56821 L .25879 .55498 L p F P
0 g
s
.891 .649 .566 r
.24456 .53885 m .25879 .55498 L .23792 .56821 L p F P
0 g
s
.814 .664 .697 r
.21834 .41355 m .20582 .40185 L .21977 .38847 L p F P
0 g
s
.821 .67 .695 r
.2068 .37821 m .21977 .38847 L .20582 .40185 L p F P
0 g
s
.797 .671 .725 r
.21977 .38847 m .2068 .37821 L .21924 .36474 L p F P
0 g
s
.942 .673 .499 r
.34871 .83606 m .36454 .86107 L .33423 .88388 L p F P
0 g
s
.868 .65 .605 r
.23113 .52267 m .21852 .50645 L .23697 .49408 L p F P
0 g
s
.876 .653 .597 r
.22369 .47966 m .23697 .49408 L .21852 .50645 L p F P
0 g
s
.834 .66 .667 r
.21535 .43933 m .20332 .42616 L .21834 .41355 L p F P
0 g
s
.841 .665 .664 r
.20582 .40185 m .21834 .41355 L .20332 .42616 L p F P
0 g
s
.591 .737 .945 r
.57962 .34055 m .55224 .34094 L .56071 .31335 L p F P
0 g
s
.599 .731 .936 r
.53431 .31392 m .56071 .31335 L .55224 .34094 L p F P
0 g
s
.782 .679 .751 r
.21645 .343 m .23104 .35002 L .21924 .36474 L p F P
0 g
s
.76 .685 .779 r
.23104 .35002 m .21645 .343 L .22609 .32941 L p F P
0 g
s
.76 .685 .779 r
.22609 .32941 m .2417 .33464 L .23104 .35002 L p F P
0 g
s
.699 .701 .849 r
.28546 .32552 m .2678 .32253 L .27536 .30635 L p F P
0 g
s
.699 .701 .849 r
.27536 .30635 m .2934 .308 L .28546 .32552 L p F P
0 g
s
.804 .676 .723 r
.20585 .3559 m .21924 .36474 L .2068 .37821 L p F P
0 g
s
.782 .679 .751 r
.21924 .36474 m .20585 .3559 L .21645 .343 L p F P
0 g
s
.903 .652 .548 r
.27105 .65774 m .25737 .63685 L .28015 .62319 L p F P
0 g
s
.91 .65 .534 r
.26537 .60482 m .28015 .62319 L .25737 .63685 L p F P
0 g
s
.921 .661 .528 r
.3038 .76192 m .28976 .7376 L .31567 .7212 L p F P
0 g
s
.926 .658 .512 r
.30022 .69994 m .31567 .7212 L .28976 .7376 L p F P
0 g
s
.739 .694 .808 r
.2417 .33464 m .22609 .32941 L .23438 .31571 L p F P
0 g
s
.739 .694 .808 r
.23438 .31571 m .25078 .31926 L .2417 .33464 L p F P
0 g
s
.581 .743 .953 r
.6079 .3399 m .57962 .34055 L .58799 .31258 L p F P
0 g
s
.591 .737 .945 r
.56071 .31335 m .58799 .31258 L .57962 .34055 L p F P
0 g
s
.857 .658 .632 r
.2113 .46511 m .1998 .45042 L .21535 .43933 L p F P
0 g
s
.865 .663 .627 r
.20332 .42616 m .21535 .43933 L .1998 .45042 L p F P
0 g
s
.708 .704 .844 r
.2678 .32253 m .25078 .31926 L .25787 .30451 L p F P
0 g
s
.708 .704 .844 r
.25787 .30451 m .27536 .30635 L .2678 .32253 L p F P
0 g
s
.821 .67 .695 r
.20582 .40185 m .19423 .38984 L .2068 .37821 L p F P
0 g
s
.829 .676 .693 r
.19473 .36758 m .2068 .37821 L .19423 .38984 L p F P
0 g
s
.804 .676 .723 r
.2068 .37821 m .19473 .36758 L .20585 .3559 L p F P
0 g
s
.891 .649 .566 r
.23792 .56821 m .2253 .55 L .24456 .53885 L p F P
0 g
s
.898 .65 .554 r
.23113 .52267 m .24456 .53885 L .2253 .55 L p F P
0 g
s
.876 .653 .597 r
.21852 .50645 m .20675 .4902 L .22369 .47966 L p F P
0 g
s
.884 .656 .588 r
.2113 .46511 m .22369 .47966 L .20675 .4902 L p F P
0 g
s
.841 .665 .664 r
.20332 .42616 m .19222 .41275 L .20582 .40185 L p F P
0 g
s
.849 .672 .661 r
.19423 .38984 m .20582 .40185 L .19222 .41275 L p F P
0 g
s
.789 .685 .75 r
.20264 .33559 m .21645 .343 L .20585 .3559 L p F P
0 g
s
.768 .691 .777 r
.21645 .343 m .20264 .33559 L .21119 .32383 L p F P
0 g
s
.768 .691 .777 r
.21119 .32383 m .22609 .32941 L .21645 .343 L p F P
0 g
s
.572 .749 .961 r
.63712 .33899 m .6079 .3399 L .61619 .31163 L p F P
0 g
s
.581 .743 .953 r
.58799 .31258 m .61619 .31163 L .6079 .3399 L p F P
0 g
s
.812 .683 .722 r
.1933 .34667 m .20585 .3559 L .19473 .36758 L p F P
0 g
s
.789 .685 .75 r
.20585 .3559 m .1933 .34667 L .20264 .33559 L p F P
0 g
s
.717 .707 .84 r
.25078 .31926 m .23438 .31571 L .24093 .30248 L p F P
0 g
s
.717 .707 .84 r
.24093 .30248 m .25787 .30451 L .25078 .31926 L p F P
0 g
s
.748 .699 .805 r
.22609 .32941 m .21119 .32383 L .21859 .31188 L p F P
0 g
s
.748 .699 .805 r
.21859 .31188 m .23438 .31571 L .22609 .32941 L p F P
0 g
s
.942 .673 .499 r
.33423 .88388 m .32049 .85534 L .34871 .83606 L p F P
0 g
s
.946 .67 .482 r
.3333 .81118 m .34871 .83606 L .32049 .85534 L p F P
0 g
s
.91 .65 .534 r
.25737 .63685 m .24432 .61613 L .26537 .60482 L p F P
0 g
s
.916 .649 .518 r
.25128 .58649 m .26537 .60482 L .24432 .61613 L p F P
0 g
s
.865 .663 .627 r
.1998 .45042 m .18921 .4356 L .20332 .42616 L p F P
0 g
s
.873 .669 .623 r
.19222 .41275 m .20332 .42616 L .18921 .4356 L p F P
0 g
s
.624 .721 .916 r
.3715 .31273 m .35105 .31182 L .35597 .29351 L p F P
0 g
s
.635 .719 .908 r
.35105 .31182 m .33123 .31073 L .33627 .29318 L p F P
0 g
s
.635 .719 .908 r
.33627 .29318 m .35597 .29351 L .35105 .31182 L p F P
0 g
s
.647 .719 .901 r
.33123 .31073 m .31202 .30946 L .31711 .29277 L p F P
0 g
s
.647 .719 .901 r
.31711 .29277 m .33627 .29318 L .33123 .31073 L p F P
0 g
s
.612 .723 .924 r
.3926 .31345 m .3715 .31273 L .37624 .29375 L p F P
0 g
s
.624 .721 .916 r
.35597 .29351 m .37624 .29375 L .3715 .31273 L p F P
0 g
s
.658 .719 .894 r
.31202 .30946 m .2934 .308 L .29847 .29228 L p F P
0 g
s
.658 .719 .894 r
.29847 .29228 m .31711 .29277 L .31202 .30946 L p F P
0 g
s
.926 .658 .512 r
.28976 .7376 m .27623 .71352 L .30022 .69994 L p F P
0 g
s
.932 .655 .494 r
.28534 .67878 m .30022 .69994 L .27623 .71352 L p F P
0 g
s
.562 .756 .969 r
.66731 .33782 m .63712 .33899 L .64535 .31047 L p F P
0 g
s
.572 .749 .961 r
.61619 .31163 m .64535 .31047 L .63712 .33899 L p F P
0 g
s
.829 .676 .693 r
.19423 .38984 m .18358 .37752 L .19473 .36758 L p F P
0 g
s
.837 .684 .692 r
.18358 .35657 m .19473 .36758 L .18358 .37752 L p F P
0 g
s
.812 .683 .722 r
.19473 .36758 m .18358 .35657 L .1933 .34667 L p F P
0 g
s
.6 .726 .933 r
.41438 .31399 m .3926 .31345 L .3971 .29391 L p F P
0 g
s
.612 .723 .924 r
.37624 .29375 m .3971 .29391 L .3926 .31345 L p F P
0 g
s
.669 .72 .887 r
.2934 .308 m .27536 .30635 L .28033 .2917 L p F P
0 g
s
.669 .72 .887 r
.28033 .2917 m .29847 .29228 L .2934 .308 L p F P
0 g
s
.884 .656 .588 r
.20675 .4902 m .19583 .47393 L .2113 .46511 L p F P
0 g
s
.893 .661 .581 r
.1998 .45042 m .2113 .46511 L .19583 .47393 L p F P
0 g
s
.849 .672 .661 r
.19222 .41275 m .18206 .39913 L .19423 .38984 L p F P
0 g
s
.858 .679 .659 r
.18358 .37752 m .19423 .38984 L .18206 .39913 L p F P
0 g
s
.898 .65 .554 r
.2253 .55 m .21344 .53188 L .23113 .52267 L p F P
0 g
s
.906 .652 .542 r
.21852 .50645 m .23113 .52267 L .21344 .53188 L p F P
0 g
s
.727 .712 .836 r
.23438 .31571 m .21859 .31188 L .22451 .30025 L p F P
0 g
s
.727 .712 .836 r
.22451 .30025 m .24093 .30248 L .23438 .31571 L p F P
0 g
s
.798 .692 .749 r
.18961 .32779 m .20264 .33559 L .1933 .34667 L p F P
0 g
s
.777 .697 .776 r
.20264 .33559 m .18961 .32779 L .19698 .31789 L p F P
0 g
s
.777 .697 .776 r
.19698 .31789 m .21119 .32383 L .20264 .33559 L p F P
0 g
s
.587 .729 .942 r
.43686 .31434 m .41438 .31399 L .41859 .29398 L p F P
0 g
s
.6 .726 .933 r
.3971 .29391 m .41859 .29398 L .41438 .31399 L p F P
0 g
s
.68 .722 .881 r
.27536 .30635 m .25787 .30451 L .26266 .29104 L p F P
0 g
s
.68 .722 .881 r
.26266 .29104 m .28033 .2917 L .27536 .30635 L p F P
0 g
s
.757 .705 .803 r
.21119 .32383 m .19698 .31789 L .20341 .30775 L p F P
0 g
s
.757 .705 .803 r
.20341 .30775 m .21859 .31188 L .21119 .32383 L p F P
0 g
s
.82 .691 .721 r
.18162 .33703 m .1933 .34667 L .18358 .35657 L p F P
0 g
s
.798 .692 .749 r
.1933 .34667 m .18162 .33703 L .18961 .32779 L p F P
0 g
s
.873 .669 .623 r
.18921 .4356 m .17955 .42067 L .19222 .41275 L p F P
0 g
s
.882 .676 .619 r
.18206 .39913 m .19222 .41275 L .17955 .42067 L p F P
0 g
s
.574 .734 .951 r
.46006 .31451 m .43686 .31434 L .44072 .29397 L p F P
0 g
s
.587 .729 .942 r
.41859 .29398 m .44072 .29397 L .43686 .31434 L p F P
0 g
s
.692 .725 .876 r
.25787 .30451 m .24093 .30248 L .24546 .29029 L p F P
0 g
s
.692 .725 .876 r
.24546 .29029 m .26266 .29104 L .25787 .30451 L p F P
0 g
s
.551 .763 .976 r
.6985 .33638 m .66731 .33782 L .67551 .30912 L p F P
0 g
s
.562 .756 .969 r
.64535 .31047 m .67551 .30912 L .66731 .33782 L p F P
0 g
s
.916 .649 .518 r
.24432 .61613 m .23193 .5956 L .25128 .58649 L p F P
0 g
s
.924 .648 .5 r
.23792 .56821 m .25128 .58649 L .23193 .5956 L p F P
0 g
s
.736 .717 .833 r
.21859 .31188 m .20341 .30775 L .20861 .29782 L p F P
0 g
s
.736 .717 .833 r
.20861 .29782 m .22451 .30025 L .21859 .31188 L p F P
0 g
s
.893 .661 .581 r
.19583 .47393 m .18579 .45767 L .1998 .45042 L p F P
0 g
s
.902 .667 .573 r
.18921 .4356 m .1998 .45042 L .18579 .45767 L p F P
0 g
s
.858 .679 .659 r
.18206 .39913 m .17287 .38528 L .18358 .37752 L p F P
0 g
s
.867 .688 .658 r
.17389 .36488 m .18358 .37752 L .17287 .38528 L p F P
0 g
s
.837 .684 .692 r
.18358 .37752 m .17389 .36488 L .18358 .35657 L p F P
0 g
s
.846 .693 .692 r
.17334 .34519 m .18358 .35657 L .17389 .36488 L p F P
0 g
s
.82 .691 .721 r
.18358 .35657 m .17334 .34519 L .18162 .33703 L p F P
0 g
s
.906 .652 .542 r
.21344 .53188 m .20236 .51387 L .21852 .50645 L p F P
0 g
s
.915 .654 .529 r
.20675 .4902 m .21852 .50645 L .20236 .51387 L p F P
0 g
s
.946 .67 .482 r
.32049 .85534 m .30714 .8271 L .3333 .81118 L p F P
0 g
s
.95 .666 .462 r
.31832 .78646 m .3333 .81118 L .30714 .8271 L p F P
0 g
s
.56 .738 .959 r
.48402 .3145 m .46006 .31451 L .46353 .29387 L p F P
0 g
s
.574 .734 .951 r
.44072 .29397 m .46353 .29387 L .46006 .31451 L p F P
0 g
s
.932 .655 .494 r
.27623 .71352 m .26322 .6897 L .28534 .67878 L p F P
0 g
s
.937 .652 .474 r
.27105 .65774 m .28534 .67878 L .26322 .6897 L p F P
0 g
s
.703 .729 .871 r
.24093 .30248 m .22451 .30025 L .22869 .28946 L p F P
0 g
s
.703 .729 .871 r
.22869 .28946 m .24546 .29029 L .24093 .30248 L p F P
0 g
s
.806 .7 .748 r
.17737 .31958 m .18961 .32779 L .18162 .33703 L p F P
0 g
s
.785 .704 .775 r
.18961 .32779 m .17737 .31958 L .18347 .31158 L p F P
0 g
s
.785 .704 .775 r
.18347 .31158 m .19698 .31789 L .18961 .32779 L p F P
0 g
s
.766 .712 .802 r
.19698 .31789 m .18347 .31158 L .18883 .30333 L p F P
0 g
s
.766 .712 .802 r
.18883 .30333 m .20341 .30775 L .19698 .31789 L p F P
0 g
s
.829 .7 .722 r
.1708 .32697 m .18162 .33703 L .17334 .34519 L p F P
0 g
s
.806 .7 .748 r
.18162 .33703 m .1708 .32697 L .17737 .31958 L p F P
0 g
s
.54 .769 .982 r
.73072 .33466 m .6985 .33638 L .70672 .30756 L p F P
0 g
s
.551 .763 .976 r
.67551 .30912 m .70672 .30756 L .6985 .33638 L p F P
0 g
s
.882 .676 .619 r
.17955 .42067 m .17083 .40563 L .18206 .39913 L p F P
0 g
s
.892 .685 .616 r
.17287 .38528 m .18206 .39913 L .17083 .40563 L p F P
0 g
s
.546 .743 .968 r
.50875 .3143 m .48402 .3145 L .48706 .29369 L p F P
0 g
s
.56 .738 .959 r
.46353 .29387 m .48706 .29369 L .48402 .3145 L p F P
0 g
s
.746 .723 .831 r
.20341 .30775 m .18883 .30333 L .19321 .29519 L p F P
0 g
s
.746 .723 .831 r
.19321 .29519 m .20861 .29782 L .20341 .30775 L p F P
0 g
s
.714 .734 .867 r
.22451 .30025 m .20861 .29782 L .21234 .28853 L p F P
0 g
s
.714 .734 .867 r
.21234 .28853 m .22869 .28946 L .22451 .30025 L p F P
0 g
s
.902 .667 .573 r
.18579 .45767 m .17663 .44142 L .18921 .4356 L p F P
0 g
s
.911 .674 .567 r
.17955 .42067 m .18921 .4356 L .17663 .44142 L p F P
0 g
s
.924 .648 .5 r
.23193 .5956 m .22021 .57528 L .23792 .56821 L p F P
0 g
s
.931 .648 .482 r
.2253 .55 m .23792 .56821 L .22021 .57528 L p F P
0 g
s
.867 .688 .658 r
.17287 .38528 m .16464 .37121 L .17389 .36488 L p F P
0 g
s
.876 .698 .658 r
.16515 .35193 m .17389 .36488 L .16464 .37121 L p F P
0 g
s
.846 .693 .692 r
.17389 .36488 m .16515 .35193 L .17334 .34519 L p F P
0 g
s
.915 .654 .529 r
.20236 .51387 m .19208 .49598 L .20675 .4902 L p F P
0 g
s
.924 .658 .516 r
.19583 .47393 m .20675 .4902 L .19208 .49598 L p F P
0 g
s
.855 .703 .693 r
.16404 .33343 m .17334 .34519 L .16515 .35193 L p F P
0 g
s
.829 .7 .722 r
.17334 .34519 m .16404 .33343 L .1708 .32697 L p F P
0 g
s
.611 .744 .94 r
.31711 .29277 m .29847 .29228 L .30037 .27908 L p F P
0 g
s
.627 .745 .932 r
.29847 .29228 m .28033 .2917 L .28243 .27925 L p F P
0 g
s
.627 .745 .932 r
.28243 .27925 m .30037 .27908 L .29847 .29228 L p F P
0 g
s
.643 .747 .924 r
.28033 .2917 m .26266 .29104 L .26489 .27946 L p F P
0 g
s
.643 .747 .924 r
.26489 .27946 m .28243 .27925 L .28033 .2917 L p F P
0 g
s
.594 .744 .948 r
.33627 .29318 m .31711 .29277 L .31873 .27896 L p F P
0 g
s
.611 .744 .94 r
.30037 .27908 m .31873 .27896 L .31711 .29277 L p F P
0 g
s
.815 .709 .749 r
.16592 .31096 m .17737 .31958 L .1708 .32697 L p F P
0 g
s
.794 .713 .774 r
.17737 .31958 m .16592 .31096 L .17065 .3049 L p F P
0 g
s
.794 .713 .774 r
.17065 .3049 m .18347 .31158 L .17737 .31958 L p F P
0 g
s
.658 .749 .917 r
.26266 .29104 m .24546 .29029 L .24772 .2797 L p F P
0 g
s
.658 .749 .917 r
.24772 .2797 m .26489 .27946 L .26266 .29104 L p F P
0 g
s
.53 .748 .975 r
.53431 .31392 m .50875 .3143 L .51134 .29342 L p F P
0 g
s
.546 .743 .968 r
.48706 .29369 m .51134 .29342 L .50875 .3143 L p F P
0 g
s
.775 .72 .801 r
.18347 .31158 m .17065 .3049 L .17484 .2986 L p F P
0 g
s
.775 .72 .801 r
.17484 .2986 m .18883 .30333 L .18347 .31158 L p F P
0 g
s
.937 .652 .474 r
.26322 .6897 m .25074 .66618 L .27105 .65774 L p F P
0 g
s
.943 .648 .451 r
.25737 .63685 m .27105 .65774 L .25074 .66618 L p F P
0 g
s
.892 .685 .616 r
.17083 .40563 m .16307 .39049 L .17287 .38528 L p F P
0 g
s
.901 .695 .615 r
.16464 .37121 m .17287 .38528 L .16307 .39049 L p F P
0 g
s
.726 .74 .863 r
.20861 .29782 m .19321 .29519 L .1964 .28752 L p F P
0 g
s
.726 .74 .863 r
.1964 .28752 m .21234 .28853 L .20861 .29782 L p F P
0 g
s
.528 .775 .988 r
.76402 .33267 m .73072 .33466 L .73903 .30579 L p F P
0 g
s
.54 .769 .982 r
.70672 .30756 m .73903 .30579 L .73072 .33466 L p F P
0 g
s
.576 .744 .956 r
.35597 .29351 m .33627 .29318 L .33753 .27886 L p F P
0 g
s
.594 .744 .948 r
.31873 .27896 m .33753 .27886 L .33627 .29318 L p F P
0 g
s
.95 .666 .462 r
.30714 .8271 m .29417 .79921 L .31832 .78646 L p F P
0 g
s
.954 .661 .44 r
.3038 .76192 m .31832 .78646 L .29417 .79921 L p F P
0 g
s
.673 .753 .911 r
.24546 .29029 m .22869 .28946 L .23091 .27998 L p F P
0 g
s
.673 .753 .911 r
.23091 .27998 m .24772 .2797 L .24546 .29029 L p F P
0 g
s
.838 .71 .723 r
.16086 .3165 m .1708 .32697 L .16404 .33343 L p F P
0 g
s
.815 .709 .749 r
.1708 .32697 m .16086 .3165 L .16592 .31096 L p F P
0 g
s
.911 .674 .567 r
.17663 .44142 m .16838 .42519 L .17955 .42067 L p F P
0 g
s
.921 .682 .561 r
.17083 .40563 m .17955 .42067 L .16838 .42519 L p F P
0 g
s
.756 .731 .829 r
.18883 .30333 m .17484 .2986 L .17829 .29234 L p F P
0 g
s
.756 .731 .829 r
.17829 .29234 m .19321 .29519 L .18883 .30333 L p F P
0 g
s
.558 .745 .964 r
.37624 .29375 m .35597 .29351 L .35681 .27881 L p F P
0 g
s
.576 .744 .956 r
.33753 .27886 m .35681 .27881 L .35597 .29351 L p F P
0 g
s
.924 .658 .516 r
.19208 .49598 m .18261 .47824 L .19583 .47393 L p F P
0 g
s
.933 .663 .503 r
.18579 .45767 m .19583 .47393 L .18261 .47824 L p F P
0 g
s
.931 .648 .482 r
.22021 .57528 m .20919 .5552 L .2253 .55 L p F P
0 g
s
.938 .647 .462 r
.21344 .53188 m .2253 .55 L .20919 .5552 L p F P
0 g
s
.876 .698 .658 r
.16464 .37121 m .15741 .35693 L .16515 .35193 L p F P
0 g
s
.885 .709 .659 r
.1574 .33867 m .16515 .35193 L .15741 .35693 L p F P
0 g
s
.855 .703 .693 r
.16515 .35193 m .1574 .33867 L .16404 .33343 L p F P
0 g
s
.687 .757 .905 r
.22869 .28946 m .21234 .28853 L .21443 .2803 L p F P
0 g
s
.687 .757 .905 r
.21443 .2803 m .23091 .27998 L .22869 .28946 L p F P
0 g
s
.864 .714 .694 r
.15568 .32129 m .16404 .33343 L .1574 .33867 L p F P
0 g
s
.838 .71 .723 r
.16404 .33343 m .15568 .32129 L .16086 .3165 L p F P
0 g
s
.514 .753 .982 r
.56071 .31335 m .53431 .31392 L .5364 .29306 L p F P
0 g
s
.53 .748 .975 r
.51134 .29342 m .5364 .29306 L .53431 .31392 L p F P
0 g
s
.737 .746 .86 r
.19321 .29519 m .17829 .29234 L .18085 .28641 L p F P
0 g
s
.737 .746 .86 r
.18085 .28641 m .1964 .28752 L .19321 .29519 L p F P
0 g
s
.537 .746 .972 r
.3971 .29391 m .37624 .29375 L .37658 .2788 L p F P
0 g
s
.558 .745 .964 r
.35681 .27881 m .37658 .2788 L .37624 .29375 L p F P
0 g
s
.901 .695 .615 r
.16307 .39049 m .15627 .37525 L .16464 .37121 L p F P
0 g
s
.911 .707 .615 r
.15741 .35693 m .16464 .37121 L .15627 .37525 L p F P
0 g
s
.701 .762 .899 r
.21234 .28853 m .1964 .28752 L .19827 .28066 L p F P
0 g
s
.701 .762 .899 r
.19827 .28066 m .21443 .2803 L .21234 .28853 L p F P
0 g
s
.921 .682 .561 r
.16838 .42519 m .16104 .409 L .17083 .40563 L p F P
0 g
s
.931 .693 .557 r
.16307 .39049 m .17083 .40563 L .16104 .409 L p F P
0 g
s
.528 .775 .988 r
.73903 .30579 m .77249 .3038 L .76402 .33267 L p F P
0 g
s
.803 .722 .775 r
.15853 .29784 m .17065 .3049 L .16592 .31096 L p F P
0 g
s
.784 .728 .8 r
.17065 .3049 m .15853 .29784 L .16144 .29356 L p F P
0 g
s
.784 .728 .8 r
.16144 .29356 m .17484 .2986 L .17065 .3049 L p F P
0 g
s
.824 .719 .75 r
.15527 .30191 m .16592 .31096 L .16086 .3165 L p F P
0 g
s
.803 .722 .775 r
.16592 .31096 m .15527 .30191 L .15853 .29784 L p F P
0 g
s
.943 .648 .451 r
.25074 .66618 m .23883 .64298 L .25737 .63685 L p F P
0 g
s
.948 .644 .426 r
.24432 .61613 m .25737 .63685 L .23883 .64298 L p F P
0 g
s
.933 .663 .503 r
.18261 .47824 m .17398 .46065 L .18579 .45767 L p F P
0 g
s
.942 .669 .491 r
.17663 .44142 m .18579 .45767 L .17398 .46065 L p F P
0 g
s
.767 .739 .827 r
.17484 .2986 m .16144 .29356 L .16385 .28929 L p F P
0 g
s
.767 .739 .827 r
.16385 .28929 m .17829 .29234 L .17484 .2986 L p F P
0 g
s
.516 .748 .98 r
.41859 .29398 m .3971 .29391 L .39687 .27882 L p F P
0 g
s
.537 .746 .972 r
.37658 .2788 m .39687 .27882 L .3971 .29391 L p F P
0 g
s
.846 .721 .725 r
.1518 .30561 m .16086 .3165 L .15568 .32129 L p F P
0 g
s
.824 .719 .75 r
.16086 .3165 m .1518 .30561 L .15527 .30191 L p F P
0 g
s
.938 .647 .462 r
.20919 .5552 m .19887 .53538 L .21344 .53188 L p F P
0 g
s
.946 .647 .44 r
.20236 .51387 m .21344 .53188 L .19887 .53538 L p F P
0 g
s
.885 .709 .659 r
.15741 .35693 m .15117 .34244 L .1574 .33867 L p F P
0 g
s
.894 .722 .661 r
.15063 .3251 m .1574 .33867 L .15117 .34244 L p F P
0 g
s
.864 .714 .694 r
.1574 .33867 m .15063 .3251 L .15568 .32129 L p F P
0 g
s
.954 .661 .44 r
.29417 .79921 m .28163 .7717 L .3038 .76192 L p F P
0 g
s
.958 .655 .415 r
.28976 .7376 m .3038 .76192 L .28163 .7717 L p F P
0 g
s
.715 .768 .894 r
.1964 .28752 m .18085 .28641 L .1824 .28106 L p F P
0 g
s
.715 .768 .894 r
.1824 .28106 m .19827 .28066 L .1964 .28752 L p F P
0 g
s
.496 .758 .988 r
.58799 .31258 m .56071 .31335 L .56229 .29261 L p F P
0 g
s
.514 .753 .982 r
.5364 .29306 m .56229 .29261 L .56071 .31335 L p F P
0 g
s
.911 .707 .615 r
.15627 .37525 m .15046 .35994 L .15741 .35693 L p F P
0 g
s
.92 .72 .616 r
.15117 .34244 m .15741 .35693 L .15046 .35994 L p F P
0 g
s
.748 .754 .857 r
.17829 .29234 m .16385 .28929 L .16567 .28521 L p F P
0 g
s
.748 .754 .857 r
.16567 .28521 m .18085 .28641 L .17829 .29234 L p F P
0 g
s
.931 .693 .557 r
.16104 .409 m .15463 .39286 L .16307 .39049 L p F P
0 g
s
.94 .705 .554 r
.15627 .37525 m .16307 .39049 L .15463 .39286 L p F P
0 g
s
.873 .726 .697 r
.14828 .30876 m .15568 .32129 L .15063 .3251 L p F P
0 g
s
.846 .721 .725 r
.15568 .32129 m .14828 .30876 L .1518 .30561 L p F P
0 g
s
.607 .779 .963 r
.26489 .27946 m .24772 .2797 L .24759 .2712 L p F P
0 g
s
.629 .783 .955 r
.24772 .2797 m .23091 .27998 L .23105 .27227 L p F P
0 g
s
.629 .783 .955 r
.23105 .27227 m .24759 .2712 L .24772 .2797 L p F P
0 g
s
.492 .749 .986 r
.44072 .29397 m .41859 .29398 L .41772 .27889 L p F P
0 g
s
.516 .748 .98 r
.39687 .27882 m .41772 .27889 L .41859 .29398 L p F P
0 g
s
.942 .669 .491 r
.17398 .46065 m .16618 .44324 L .17663 .44142 L p F P
0 g
s
.951 .676 .479 r
.16838 .42519 m .17663 .44142 L .16618 .44324 L p F P
0 g
s
.584 .776 .971 r
.28243 .27925 m .26489 .27946 L .26441 .27031 L p F P
0 g
s
.607 .779 .963 r
.24759 .2712 m .26441 .27031 L .26489 .27946 L p F P
0 g
s
.649 .787 .948 r
.23091 .27998 m .21443 .2803 L .21476 .27352 L p F P
0 g
s
.649 .787 .948 r
.21476 .27352 m .23105 .27227 L .23091 .27998 L p F P
0 g
s
.558 .772 .978 r
.30037 .27908 m .28243 .27925 L .28152 .2696 L p F P
0 g
s
.584 .776 .971 r
.26441 .27031 m .28152 .2696 L .28243 .27925 L p F P
0 g
s
.948 .644 .426 r
.23883 .64298 m .22749 .62013 L .24432 .61613 L p F P
0 g
s
.953 .639 .398 r
.23193 .5956 m .24432 .61613 L .22749 .62013 L p F P
0 g
s
.668 .792 .94 r
.21443 .2803 m .19827 .28066 L .1987 .27495 L p F P
0 g
s
.668 .792 .94 r
.1987 .27495 m .21476 .27352 L .21443 .2803 L p F P
0 g
s
.729 .775 .89 r
.18085 .28641 m .16567 .28521 L .1668 .28151 L p F P
0 g
s
.729 .775 .89 r
.1668 .28151 m .1824 .28106 L .18085 .28641 L p F P
0 g
s
.946 .647 .44 r
.19887 .53538 m .18928 .51583 L .20236 .51387 L p F P
0 g
s
.953 .648 .418 r
.19208 .49598 m .20236 .51387 L .18928 .51583 L p F P
0 g
s
.812 .732 .776 r
.14711 .29038 m .15853 .29784 L .15527 .30191 L p F P
0 g
s
.794 .738 .8 r
.15853 .29784 m .14711 .29038 L .14862 .2882 L p F P
0 g
s
.794 .738 .8 r
.14862 .2882 m .16144 .29356 L .15853 .29784 L p F P
0 g
s
.833 .73 .752 r
.14542 .29244 m .15527 .30191 L .1518 .30561 L p F P
0 g
s
.812 .732 .776 r
.15527 .30191 m .14542 .29244 L .14711 .29038 L p F P
0 g
s
.894 .722 .661 r
.15117 .34244 m .14593 .32775 L .15063 .3251 L p F P
0 g
s
.903 .736 .665 r
.14486 .31122 m .15063 .3251 L .14593 .32775 L p F P
0 g
s
.873 .726 .697 r
.15063 .3251 m .14486 .31122 L .14828 .30876 L p F P
0 g
s
.94 .705 .554 r
.15463 .39286 m .14915 .37679 L .15627 .37525 L p F P
0 g
s
.95 .718 .553 r
.15046 .35994 m .15627 .37525 L .14915 .37679 L p F P
0 g
s
.92 .72 .616 r
.15046 .35994 m .14563 .34456 L .15117 .34244 L p F P
0 g
s
.929 .735 .619 r
.14593 .32775 m .15117 .34244 L .14563 .34456 L p F P
0 g
s
.531 .769 .985 r
.31873 .27896 m .30037 .27908 L .29894 .26906 L p F P
0 g
s
.558 .772 .978 r
.28152 .2696 m .29894 .26906 L .30037 .27908 L p F P
0 g
s
.777 .747 .826 r
.16144 .29356 m .14862 .2882 L .14989 .28602 L p F P
0 g
s
.777 .747 .826 r
.14989 .28602 m .16385 .28929 L .16144 .29356 L p F P
0 g
s
.855 .733 .727 r
.14364 .29428 m .1518 .30561 L .14828 .30876 L p F P
0 g
s
.833 .73 .752 r
.1518 .30561 m .14364 .29428 L .14542 .29244 L p F P
0 g
s
.687 .797 .933 r
.19827 .28066 m .1824 .28106 L .18285 .27656 L p F P
0 g
s
.687 .797 .933 r
.18285 .27656 m .1987 .27495 L .19827 .28066 L p F P
0 g
s
.477 .762 .993 r
.61619 .31163 m .58799 .31258 L .58904 .29207 L p F P
0 g
s
.496 .758 .988 r
.56229 .29261 m .58904 .29207 L .58799 .31258 L p F P
0 g
s
.951 .676 .479 r
.16618 .44324 m .15924 .42603 L .16838 .42519 L p F P
0 g
s
.96 .686 .469 r
.16104 .409 m .16838 .42519 L .15924 .42603 L p F P
0 g
s
.76 .762 .854 r
.16385 .28929 m .14989 .28602 L .15085 .28391 L p F P
0 g
s
.76 .762 .854 r
.15085 .28391 m .16567 .28521 L .16385 .28929 L p F P
0 g
s
.466 .75 .991 r
.46353 .29387 m .44072 .29397 L .43916 .27899 L p F P
0 g
s
.492 .749 .986 r
.41772 .27889 m .43916 .27899 L .44072 .29397 L p F P
0 g
s
.958 .655 .415 r
.28163 .7717 m .26951 .74459 L .28976 .7376 L p F P
0 g
s
.961 .648 .387 r
.27623 .71352 m .28976 .7376 L .26951 .74459 L p F P
0 g
s
.501 .766 .99 r
.33753 .27886 m .31873 .27896 L .31671 .2687 L p F P
0 g
s
.531 .769 .985 r
.29894 .26906 m .31671 .2687 L .31873 .27896 L p F P
0 g
s
.881 .739 .7 r
.14184 .29584 m .14828 .30876 L .14486 .31122 L p F P
0 g
s
.855 .733 .727 r
.14828 .30876 m .14184 .29584 L .14364 .29428 L p F P
0 g
s
.704 .803 .926 r
.1824 .28106 m .1668 .28151 L .16719 .27836 L p F P
0 g
s
.704 .803 .926 r
.16719 .27836 m .18285 .27656 L .1824 .28106 L p F P
0 g
s
.95 .718 .553 r
.14915 .37679 m .14463 .3608 L .15046 .35994 L p F P
0 g
s
.959 .734 .554 r
.14563 .34456 m .15046 .35994 L .14463 .3608 L p F P
0 g
s
.742 .782 .885 r
.16567 .28521 m .15085 .28391 L .15147 .28199 L p F P
0 g
s
.742 .782 .885 r
.15147 .28199 m .1668 .28151 L .16567 .28521 L p F P
0 g
s
.953 .648 .418 r
.18928 .51583 m .18042 .49659 L .19208 .49598 L p F P
0 g
s
.959 .649 .394 r
.18261 .47824 m .19208 .49598 L .18042 .49659 L p F P
0 g
s
.929 .735 .619 r
.14563 .34456 m .1418 .32911 L .14593 .32775 L p F P
0 g
s
.938 .75 .623 r
.14172 .31286 m .14593 .32775 L .1418 .32911 L p F P
0 g
s
.903 .736 .665 r
.14593 .32775 m .14172 .31286 L .14486 .31122 L p F P
0 g
s
.96 .686 .469 r
.15924 .42603 m .15317 .40902 L .16104 .409 L p F P
0 g
s
.969 .697 .461 r
.15463 .39286 m .16104 .409 L .15317 .40902 L p F P
0 g
s
.953 .639 .398 r
.22749 .62013 m .21675 .59766 L .23193 .5956 L p F P
0 g
s
.957 .634 .367 r
.22021 .57528 m .23193 .5956 L .21675 .59766 L p F P
0 g
s
.911 .751 .669 r
.14011 .29702 m .14486 .31122 L .14172 .31286 L p F P
0 g
s
.881 .739 .7 r
.14486 .31122 m .14011 .29702 L .14184 .29584 L p F P
0 g
s
.468 .762 .994 r
.35681 .27881 m .33753 .27886 L .33484 .26853 L p F P
0 g
s
.501 .766 .99 r
.31671 .2687 m .33484 .26853 L .33753 .27886 L p F P
0 g
s
.959 .734 .554 r
.14463 .3608 m .14105 .34491 L .14563 .34456 L p F P
0 g
s
.967 .75 .558 r
.1418 .32911 m .14563 .34456 L .14105 .34491 L p F P
0 g
s
.721 .809 .92 r
.1668 .28151 m .15147 .28199 L .15171 .28034 L p F P
0 g
s
.721 .809 .92 r
.15171 .28034 m .16719 .27836 L .1668 .28151 L p F P
0 g
s
.439 .75 .994 r
.48706 .29369 m .46353 .29387 L .46122 .27914 L p F P
0 g
s
.466 .75 .991 r
.43916 .27899 m .46122 .27914 L .46353 .29387 L p F P
0 g
s
.822 .743 .777 r
.13638 .28252 m .14711 .29038 L .14542 .29244 L closepath p F P
0 g
s
.804 .748 .801 r
.13638 .28252 m .14862 .2882 L .14711 .29038 L closepath p F P
0 g
s
.586 .82 .988 r
.23105 .27227 m .21476 .27352 L .21329 .26851 L p F P
0 g
s
.616 .826 .981 r
.21476 .27352 m .1987 .27495 L .19767 .27064 L p F P
0 g
s
.616 .826 .981 r
.19767 .27064 m .21329 .26851 L .21476 .27352 L p F P
0 g
s
.842 .742 .754 r
.13638 .28252 m .14542 .29244 L .14364 .29428 L closepath p F P
0 g
s
.787 .757 .825 r
.13638 .28252 m .14989 .28602 L .14862 .2882 L closepath p F P
0 g
s
.644 .832 .973 r
.1987 .27495 m .18285 .27656 L .18219 .27311 L p F P
0 g
s
.644 .832 .973 r
.18219 .27311 m .19767 .27064 L .1987 .27495 L p F P
0 g
s
.457 .765 .996 r
.64535 .31047 m .61619 .31163 L .61671 .29143 L p F P
0 g
s
.477 .762 .993 r
.58904 .29207 m .61671 .29143 L .61619 .31163 L p F P
0 g
s
.969 .697 .461 r
.15317 .40902 m .14796 .39225 L .15463 .39286 L p F P
0 g
s
.977 .71 .455 r
.14915 .37679 m .15463 .39286 L .14796 .39225 L p F P
0 g
s
.959 .649 .394 r
.18042 .49659 m .17232 .47767 L .18261 .47824 L p F P
0 g
s
.965 .65 .37 r
.17398 .46065 m .18261 .47824 L .17232 .47767 L p F P
0 g
s
.552 .813 .994 r
.24759 .2712 m .23105 .27227 L .22906 .26671 L p F P
0 g
s
.586 .82 .988 r
.21329 .26851 m .22906 .26671 L .23105 .27227 L p F P
0 g
s
.864 .746 .731 r
.13638 .28252 m .14364 .29428 L .14184 .29584 L closepath p F P
0 g
s
.938 .75 .623 r
.1418 .32911 m .13898 .31362 L .14172 .31286 L p F P
0 g
s
.945 .767 .63 r
.13853 .29778 m .14172 .31286 L .13898 .31362 L p F P
0 g
s
.911 .751 .669 r
.14172 .31286 m .13853 .29778 L .14011 .29702 L p F P
0 g
s
.772 .771 .852 r
.13638 .28252 m .15085 .28391 L .14989 .28602 L closepath p F P
0 g
s
.669 .838 .964 r
.18285 .27656 m .16719 .27836 L .16682 .27591 L p F P
0 g
s
.669 .838 .964 r
.16682 .27591 m .18219 .27311 L .18285 .27656 L p F P
0 g
s
.89 .753 .705 r
.13638 .28252 m .14184 .29584 L .14011 .29702 L closepath p F P
0 g
s
.961 .648 .387 r
.26951 .74459 m .25783 .71792 L .27623 .71352 L p F P
0 g
s
.962 .639 .354 r
.26322 .6897 m .27623 .71352 L .25783 .71792 L p F P
0 g
s
.514 .804 .998 r
.26441 .27031 m .24759 .2712 L .24502 .26523 L p F P
0 g
s
.552 .813 .994 r
.22906 .26671 m .24502 .26523 L .24759 .2712 L p F P
0 g
s
.431 .756 .995 r
.37658 .2788 m .35681 .27881 L .35337 .26853 L p F P
0 g
s
.468 .762 .994 r
.33484 .26853 m .35337 .26853 L .35681 .27881 L p F P
0 g
s
.755 .79 .881 r
.13638 .28252 m .15147 .28199 L .15085 .28391 L closepath p F P
0 g
s
.967 .75 .558 r
.14105 .34491 m .13844 .32912 L .1418 .32911 L p F P
0 g
s
.974 .768 .564 r
.13898 .31362 m .1418 .32911 L .13844 .32912 L p F P
0 g
s
.692 .843 .956 r
.16719 .27836 m .15171 .28034 L .15156 .27904 L p F P
0 g
s
.692 .843 .956 r
.15156 .27904 m .16682 .27591 L .16719 .27836 L p F P
0 g
s
.977 .71 .455 r
.14796 .39225 m .14364 .37572 L .14915 .37679 L p F P
0 g
s
.984 .724 .452 r
.14463 .3608 m .14915 .37679 L .14364 .37572 L p F P
0 g
s
.957 .634 .367 r
.21675 .59766 m .20661 .57559 L .22021 .57528 L p F P
0 g
s
.959 .627 .332 r
.20919 .5552 m .22021 .57528 L .20661 .57559 L p F P
0 g
s
.919 .766 .675 r
.13638 .28252 m .14011 .29702 L .13853 .29778 L closepath p F P
0 g
s
.737 .816 .914 r
.13638 .28252 m .15171 .28034 L .15147 .28199 L closepath p F P
0 g
s
.471 .794 .999 r
.28152 .2696 m .26441 .27031 L .26117 .26408 L p F P
0 g
s
.514 .804 .998 r
.24502 .26523 m .26117 .26408 L .26441 .27031 L p F P
0 g
s
.965 .65 .37 r
.17232 .47767 m .16498 .45909 L .17398 .46065 L p F P
0 g
s
.969 .653 .347 r
.16618 .44324 m .17398 .46065 L .16498 .45909 L p F P
0 g
s
.974 .768 .564 r
.13844 .32912 m .13678 .31345 L .13898 .31362 L p F P
0 g
s
.98 .786 .573 r
.13717 .29808 m .13898 .31362 L .13678 .31345 L p F P
0 g
s
.945 .767 .63 r
.13898 .31362 m .13717 .29808 L .13853 .29778 L p F P
0 g
s
.952 .784 .638 r
.13638 .28252 m .13853 .29778 L .13717 .29808 L closepath p F P
0 g
s
.984 .724 .452 r
.14364 .37572 m .1402 .35945 L .14463 .3608 L p F P
0 g
s
.99 .741 .453 r
.14105 .34491 m .14463 .3608 L .1402 .35945 L p F P
0 g
s
.713 .849 .947 r
.13638 .28252 m .15156 .27904 L .15171 .28034 L closepath p F P
0 g
s
.408 .749 .994 r
.51134 .29342 m .48706 .29369 L .48394 .27932 L p F P
0 g
s
.439 .75 .994 r
.46122 .27914 m .48394 .27932 L .48706 .29369 L p F P
0 g
s
.971 .661 .361 r
.32049 .85534 m .33423 .88388 L .31151 .89478 L p F P
0 g
s
.39 .748 .992 r
.39687 .27882 m .37658 .2788 L .37232 .26871 L p F P
0 g
s
.431 .756 .995 r
.35337 .26853 m .37232 .26871 L .37658 .2788 L p F P
0 g
s
.608 .873 .992 r
.18219 .27311 m .16682 .27591 L .1657 .27428 L p F P
0 g
s
.644 .881 .984 r
.16682 .27591 m .15156 .27904 L .15103 .27815 L p F P
0 g
s
.644 .881 .984 r
.15103 .27815 m .1657 .27428 L .16682 .27591 L p F P
0 g
s
.98 .786 .573 r
.13678 .31345 m .1361 .29791 L .13717 .29808 L p F P
0 g
s
.984 .805 .584 r
.13638 .28252 m .13717 .29808 L .1361 .29791 L closepath p F P
0 g
s
.99 .741 .453 r
.1402 .35945 m .13766 .34345 L .14105 .34491 L p F P
0 g
s
.995 .759 .458 r
.13844 .32912 m .14105 .34491 L .13766 .34345 L p F P
0 g
s
.423 .781 .996 r
.29894 .26906 m .28152 .2696 L .27754 .26326 L p F P
0 g
s
.471 .794 .999 r
.26117 .26408 m .27754 .26326 L .28152 .2696 L p F P
0 g
s
.566 .863 .996 r
.19767 .27064 m .18219 .27311 L .18042 .27088 L p F P
0 g
s
.608 .873 .992 r
.1657 .27428 m .18042 .27088 L .18219 .27311 L p F P
0 g
s
.676 .887 .976 r
.13638 .28252 m .15103 .27815 L .15156 .27904 L closepath p F P
0 g
s
.969 .653 .347 r
.16498 .45909 m .15841 .44088 L .16618 .44324 L p F P
0 g
s
.972 .657 .324 r
.15924 .42603 m .16618 .44324 L .15841 .44088 L p F P
0 g
s
.435 .768 .997 r
.67551 .30912 m .64535 .31047 L .64534 .2907 L p F P
0 g
s
.457 .765 .996 r
.61671 .29143 m .64534 .2907 L .64535 .31047 L p F P
0 g
s
.518 .85 .997 r
.21329 .26851 m .19767 .27064 L .1952 .26797 L p F P
0 g
s
.566 .863 .996 r
.18042 .27088 m .1952 .26797 L .19767 .27064 L p F P
0 g
s
.995 .759 .458 r
.13766 .34345 m .136 .32775 L .13844 .32912 L p F P
0 g
s
.998 .779 .467 r
.13678 .31345 m .13844 .32912 L .136 .32775 L p F P
0 g
s
.959 .627 .332 r
.20661 .57559 m .1971 .55394 L .20919 .5552 L p F P
0 g
s
.958 .619 .294 r
.19887 .53538 m .20919 .5552 L .1971 .55394 L p F P
0 g
s
.279 .768 .694 r
.13638 .28252 m .14744 .27828 L .14892 .27776 L closepath p F P
0 g
s
.48 .895 .904 r
.13638 .28252 m .14892 .27776 L .15013 .27772 L closepath p F P
0 g
s
0 0 0 r
.13638 .28252 m .14577 .27925 L .14744 .27828 L closepath p F P
0 g
s
.608 .915 .978 r
.13638 .28252 m .15013 .27772 L .15103 .27815 L closepath p F P
0 g
s
.079 0 0 r
.13638 .28252 m .14398 .28062 L .14577 .27925 L closepath p F P
0 g
s
.152 0 .051 r
.13638 .28252 m .14217 .28235 L .14398 .28062 L closepath p F P
0 g
s
.169 0 .169 r
.13638 .28252 m .1404 .28433 L .14217 .28235 L closepath p F P
0 g
s
.142 0 .24 r
.13638 .28252 m .13878 .28648 L .1404 .28433 L closepath p F P
0 g
s
.072 0 .272 r
.13638 .28252 m .13737 .2887 L .13878 .28648 L closepath p F P
0 g
s
0 0 .263 r
.13638 .28252 m .13624 .29087 L .13737 .2887 L closepath p F P
0 g
s
.959 .801 .361 r
.13638 .28252 m .13536 .29726 L .135 .29618 L closepath p F P
0 g
s
1 .821 .5 r
.13638 .28252 m .1361 .29791 L .13536 .29726 L closepath p F P
0 g
s
0 0 .198 r
.13638 .28252 m .13545 .29291 L .13624 .29087 L closepath p F P
0 g
s
.796 .698 .157 r
.13638 .28252 m .135 .29618 L .13503 .29471 L closepath p F P
0 g
s
0 0 .055 r
.13638 .28252 m .13503 .29471 L .13545 .29291 L closepath p F P
0 g
s
.998 .779 .467 r
.136 .32775 m .13524 .31235 L .13678 .31345 L p F P
0 g
s
1 .8 .482 r
.1361 .29791 m .13678 .31345 L .13524 .31235 L p F P
0 g
s
.962 .639 .354 r
.25783 .71792 m .24662 .69172 L .26322 .6897 L p F P
0 g
s
.961 .629 .317 r
.25074 .66618 m .26322 .6897 L .24662 .69172 L p F P
0 g
s
1 .8 .482 r
.13524 .31235 m .13536 .29726 L .1361 .29791 L p F P
0 g
s
.553 .901 .976 r
.1657 .27428 m .15103 .27815 L .15013 .27772 L p F P
0 g
s
.462 .832 .992 r
.22906 .26671 m .21329 .26851 L .21005 .26554 L p F P
0 g
s
.518 .85 .997 r
.1952 .26797 m .21005 .26554 L .21329 .26851 L p F P
0 g
s
.972 .657 .324 r
.15841 .44088 m .15262 .42305 L .15924 .42603 L p F P
0 g
s
.973 .663 .303 r
.15317 .40902 m .15924 .42603 L .15262 .42305 L p F P
0 g
s
.369 .764 .986 r
.31671 .2687 m .29894 .26906 L .29415 .26277 L p F P
0 g
s
.423 .781 .996 r
.27754 .26326 m .29415 .26277 L .29894 .26906 L p F P
0 g
s
.488 .878 .965 r
.18042 .27088 m .1657 .27428 L .16388 .27355 L p F P
0 g
s
.553 .901 .976 r
.15013 .27772 m .16388 .27355 L .1657 .27428 L p F P
0 g
s
.958 .774 .327 r
.13441 .31036 m .135 .29618 L .13536 .29726 L p F P
0 g
s
.958 .774 .327 r
.13536 .29726 m .13524 .31235 L .13441 .31036 L p F P
0 g
s
.383 .846 .86 r
.16388 .27355 m .15013 .27772 L .14892 .27776 L p F P
0 g
s
.345 .738 .984 r
.41772 .27889 m .39687 .27882 L .39171 .26908 L p F P
0 g
s
.39 .748 .992 r
.37232 .26871 m .39171 .26908 L .39687 .27882 L p F P
0 g
s
.397 .808 .978 r
.24502 .26523 m .22906 .26671 L .225 .26359 L p F P
0 g
s
.462 .832 .992 r
.21005 .26554 m .225 .26359 L .22906 .26671 L p F P
0 g
s
.973 .663 .303 r
.15262 .42305 m .14763 .40561 L .15317 .40902 L p F P
0 g
s
.972 .67 .286 r
.14796 .39225 m .15317 .40902 L .14763 .40561 L p F P
0 g
s
.958 .619 .294 r
.1971 .55394 m .18822 .53274 L .19887 .53538 L p F P
0 g
s
.955 .609 .253 r
.18928 .51583 m .19887 .53538 L .18822 .53274 L p F P
0 g
s
.959 .749 .3 r
.13461 .32505 m .13441 .31036 L .13524 .31235 L p F P
0 g
s
.959 .749 .3 r
.13524 .31235 m .136 .32775 L .13461 .32505 L p F P
0 g
s
.375 .746 .99 r
.5364 .29306 m .51134 .29342 L .50736 .27955 L p F P
0 g
s
.408 .749 .994 r
.48394 .27932 m .50736 .27955 L .51134 .29342 L p F P
0 g
s
.777 .652 .096 r
.13435 .30759 m .13503 .29471 L .135 .29618 L p F P
0 g
s
.777 .652 .096 r
.135 .29618 m .13441 .31036 L .13435 .30759 L p F P
0 g
s
.41 .845 .943 r
.1952 .26797 m .18042 .27088 L .17762 .27 L p F P
0 g
s
.488 .878 .965 r
.16388 .27355 m .17762 .27 L .18042 .27088 L p F P
0 g
s
.383 .846 .86 r
.14892 .27776 m .16143 .27376 L .16388 .27355 L p F P
0 g
s
0 0 0 r
.16143 .27376 m .14892 .27776 L .14744 .27828 L p F P
0 g
s
.972 .67 .286 r
.14763 .40561 m .14343 .3886 L .14796 .39225 L p F P
0 g
s
.97 .68 .275 r
.14364 .37572 m .14796 .39225 L .14343 .3886 L p F P
0 g
s
.961 .727 .281 r
.13562 .34023 m .13461 .32505 L .136 .32775 L p F P
0 g
s
.961 .727 .281 r
.136 .32775 m .13766 .34345 L .13562 .34023 L p F P
0 g
s
.971 .661 .361 r
.31151 .89478 m .29978 .8629 L .32049 .85534 L p F P
0 g
s
.969 .651 .329 r
.30714 .8271 m .32049 .85534 L .29978 .8629 L p F P
0 g
s
.97 .68 .275 r
.14343 .3886 m .14002 .37202 L .14364 .37572 L p F P
0 g
s
.967 .692 .269 r
.1402 .35945 m .14364 .37572 L .14002 .37202 L p F P
0 g
s
0 0 .136 r
.13507 .30414 m .13545 .29291 L .13503 .29471 L p F P
0 g
s
0 0 .136 r
.13503 .29471 m .13435 .30759 L .13507 .30414 L p F P
0 g
s
.307 .741 .969 r
.33484 .26853 m .31671 .2687 L .31102 .26261 L p F P
0 g
s
.369 .764 .986 r
.29415 .26277 m .31102 .26261 L .31671 .2687 L p F P
0 g
s
.964 .708 .271 r
.13742 .35589 m .13562 .34023 L .13766 .34345 L p F P
0 g
s
.964 .708 .271 r
.13766 .34345 m .1402 .35945 L .13742 .35589 L p F P
0 g
s
.27 .776 .793 r
.17762 .27 m .16388 .27355 L .16143 .27376 L p F P
0 g
s
.967 .692 .269 r
.14002 .37202 m .13742 .35589 L .1402 .35945 L p F P
0 g
s
.961 .629 .317 r
.24662 .69172 m .23589 .66602 L .25074 .66618 L p F P
0 g
s
.958 .616 .274 r
.23883 .64298 m .25074 .66618 L .23589 .66602 L p F P
0 g
s
0 0 0 r
.14744 .27828 m .15847 .2749 L .16143 .27376 L p F P
0 g
s
.069 0 0 r
.15847 .2749 m .14744 .27828 L .14577 .27925 L p F P
0 g
s
.323 .775 .954 r
.26117 .26408 m .24502 .26523 L .24006 .26212 L p F P
0 g
s
.397 .808 .978 r
.225 .26359 m .24006 .26212 L .24502 .26523 L p F P
0 g
s
.32 .799 .904 r
.21005 .26554 m .1952 .26797 L .19139 .26707 L p F P
0 g
s
.41 .845 .943 r
.17762 .27 m .19139 .26707 L .1952 .26797 L p F P
0 g
s
.412 .769 .995 r
.70672 .30756 m .67551 .30912 L .67498 .28987 L p F P
0 g
s
.435 .768 .997 r
.64534 .2907 m .67498 .28987 L .67551 .30912 L p F P
0 g
s
0 0 .28 r
.13653 .30019 m .13624 .29087 L .13545 .29291 L p F P
0 g
s
0 0 .28 r
.13545 .29291 m .13507 .30414 L .13653 .30019 L p F P
0 g
s
.955 .609 .253 r
.18822 .53274 m .18 .51202 L .18928 .51583 L p F P
0 g
s
.947 .598 .209 r
.18042 .49659 m .18928 .51583 L .18 .51202 L p F P
0 g
s
.069 0 0 r
.14577 .27925 m .15515 .27694 L .15847 .2749 L p F P
0 g
s
.192 0 0 r
.15515 .27694 m .14577 .27925 L .14398 .28062 L p F P
0 g
s
.765 .612 .045 r
.13436 .32115 m .13435 .30759 L .13441 .31036 L p F P
0 g
s
.765 .612 .045 r
.13441 .31036 m .13461 .32505 L .13436 .32115 L p F P
0 g
s
.018 0 .34 r
.13867 .29592 m .13737 .2887 L .13624 .29087 L p F P
0 g
s
.018 0 .34 r
.13624 .29087 m .13653 .30019 L .13867 .29592 L p F P
0 g
s
.192 0 0 r
.14398 .28062 m .1516 .27977 L .15515 .27694 L p F P
0 g
s
.244 0 .152 r
.1516 .27977 m .14398 .28062 L .14217 .28235 L p F P
0 g
s
.295 .723 .97 r
.43916 .27899 m .41772 .27889 L .41159 .26964 L p F P
0 g
s
.345 .738 .984 r
.39171 .26908 m .41159 .26964 L .41772 .27889 L p F P
0 g
s
.142 0 .347 r
.14139 .29153 m .13878 .28648 L .13737 .2887 L p F P
0 g
s
.142 0 .347 r
.13737 .2887 m .13867 .29592 L .14139 .29153 L p F P
0 g
s
.244 0 .152 r
.14217 .28235 m .14802 .28326 L .1516 .27977 L p F P
0 g
s
.248 0 .255 r
.14802 .28326 m .14217 .28235 L .1404 .28433 L p F P
0 g
s
.27 .776 .793 r
.16143 .27376 m .17392 .27051 L .17762 .27 L p F P
0 g
s
0 0 0 r
.17392 .27051 m .16143 .27376 L .15847 .2749 L p F P
0 g
s
.146 .686 .703 r
.19139 .26707 m .17762 .27 L .17392 .27051 L p F P
0 g
s
.215 0 .318 r
.14456 .28724 m .1404 .28433 L .13878 .28648 L p F P
0 g
s
.215 0 .318 r
.13878 .28648 m .14139 .29153 L .14456 .28724 L p F P
0 g
s
.239 .733 .916 r
.27754 .26326 m .26117 .26408 L .25525 .26113 L p F P
0 g
s
.323 .775 .954 r
.24006 .26212 m .25525 .26113 L .26117 .26408 L p F P
0 g
s
.248 0 .255 r
.1404 .28433 m .14456 .28724 L .14802 .28326 L p F P
0 g
s
.217 .738 .847 r
.225 .26359 m .21005 .26554 L .20518 .26477 L p F P
0 g
s
.32 .799 .904 r
.19139 .26707 m .20518 .26477 L .21005 .26554 L p F P
0 g
s
.947 .598 .209 r
.18 .51202 m .17243 .49179 L .18042 .49659 L p F P
0 g
s
.935 .586 .163 r
.17232 .47767 m .18042 .49659 L .17243 .49179 L p F P
0 g
s
.24 .712 .941 r
.35337 .26853 m .33484 .26853 L .32818 .26279 L p F P
0 g
s
.307 .741 .969 r
.31102 .26261 m .32818 .26279 L .33484 .26853 L p F P
0 g
s
.76 .58 .007 r
.13505 .33538 m .13436 .32115 L .13461 .32505 L p F P
0 g
s
.76 .58 .007 r
.13461 .32505 m .13562 .34023 L .13505 .33538 L p F P
0 g
s
.339 .741 .982 r
.56229 .29261 m .5364 .29306 L .53151 .27982 L p F P
0 g
s
.375 .746 .99 r
.50736 .27955 m .53151 .27982 L .5364 .29306 L p F P
0 g
s
0 0 .204 r
.13525 .31621 m .13507 .30414 L .13435 .30759 L p F P
0 g
s
0 0 .204 r
.13435 .30759 m .13436 .32115 L .13525 .31621 L p F P
0 g
s
.958 .616 .274 r
.23589 .66602 m .22564 .64084 L .23883 .64298 L p F P
0 g
s
.95 .599 .226 r
.22749 .62013 m .23883 .64298 L .22564 .64084 L p F P
0 g
s
.969 .651 .329 r
.29978 .8629 m .28838 .83156 L .30714 .8271 L p F P
0 g
s
.966 .639 .292 r
.29417 .79921 m .30714 .8271 L .28838 .83156 L p F P
0 g
s
0 0 0 r
.15847 .2749 m .16948 .2724 L .17392 .27051 L p F P
0 g
s
.187 0 0 r
.16948 .2724 m .15847 .2749 L .15515 .27694 L p F P
0 g
s
.935 .586 .163 r
.17243 .49179 m .16552 .47208 L .17232 .47767 L p F P
0 g
s
.918 .573 .117 r
.16498 .45909 m .17232 .47767 L .16552 .47208 L p F P
0 g
s
.764 .555 0 r
.13643 .35028 m .13505 .33538 L .13562 .34023 L p F P
0 g
s
.764 .555 0 r
.13562 .34023 m .13742 .35589 L .13643 .35028 L p F P
0 g
s
.107 .661 .769 r
.24006 .26212 m .225 .26359 L .21902 .26311 L p F P
0 g
s
.217 .738 .847 r
.20518 .26477 m .21902 .26311 L .225 .26359 L p F P
0 g
s
.146 .686 .703 r
.17392 .27051 m .1864 .26802 L .19139 .26707 L p F P
0 g
s
0 0 0 r
.20518 .26477 m .19139 .26707 L .1864 .26802 L p F P
0 g
s
.148 .679 .862 r
.29415 .26277 m .27754 .26326 L .27059 .26063 L p F P
0 g
s
.239 .733 .916 r
.25525 .26113 m .27059 .26063 L .27754 .26326 L p F P
0 g
s
0 0 .348 r
.13726 .31046 m .13653 .30019 L .13507 .30414 L p F P
0 g
s
0 0 .348 r
.13507 .30414 m .13525 .31621 L .13726 .31046 L p F P
0 g
s
.918 .573 .117 r
.16552 .47208 m .1593 .45291 L .16498 .45909 L p F P
0 g
s
.897 .559 .074 r
.15841 .44088 m .16498 .45909 L .1593 .45291 L p F P
0 g
s
.122 0 0 r
.1864 .26802 m .17392 .27051 L .16948 .2724 L p F P
0 g
s
.775 .539 0 r
.1385 .36583 m .13643 .35028 L .13742 .35589 L p F P
0 g
s
.775 .539 0 r
.13742 .35589 m .14002 .37202 L .1385 .36583 L p F P
0 g
s
.387 .768 .991 r
.73903 .30579 m .70672 .30756 L .70569 .28893 L p F P
0 g
s
.412 .769 .995 r
.67498 .28987 m .70569 .28893 L .70672 .30756 L p F P
0 g
s
.241 .704 .948 r
.46122 .27914 m .43916 .27899 L .43198 .27039 L p F P
0 g
s
.295 .723 .97 r
.41159 .26964 m .43198 .27039 L .43916 .27899 L p F P
0 g
s
.187 0 0 r
.15515 .27694 m .1645 .2756 L .16948 .2724 L p F P
0 g
s
.282 0 .091 r
.1645 .2756 m .15515 .27694 L .1516 .27977 L p F P
0 g
s
0 0 .258 r
.136 .32911 m .13525 .31621 L .13436 .32115 L p F P
0 g
s
0 0 .258 r
.13436 .32115 m .13505 .33538 L .136 .32911 L p F P
0 g
s
.167 .675 .902 r
.37232 .26871 m .35337 .26853 L .34565 .26331 L p F P
0 g
s
.24 .712 .941 r
.32818 .26279 m .34565 .26331 L .35337 .26853 L p F P
0 g
s
.95 .599 .226 r
.22564 .64084 m .2159 .61622 L .22749 .62013 L p F P
0 g
s
.937 .579 .172 r
.21675 .59766 m .22749 .62013 L .2159 .61622 L p F P
0 g
s
.897 .559 .074 r
.1593 .45291 m .15376 .4343 L .15841 .44088 L p F P
0 g
s
.871 .547 .035 r
.15262 .42305 m .15841 .44088 L .15376 .4343 L p F P
0 g
s
.794 .532 0 r
.14128 .38202 m .1385 .36583 L .14002 .37202 L p F P
0 g
s
.794 .532 0 r
.14002 .37202 m .14343 .3886 L .14128 .38202 L p F P
0 g
s
.073 0 .403 r
.1403 .30419 m .13867 .29592 L .13653 .30019 L p F P
0 g
s
.073 0 .403 r
.13653 .30019 m .13726 .31046 L .1403 .30419 L p F P
0 g
s
.871 .547 .035 r
.15376 .4343 m .1489 .41627 L .15262 .42305 L p F P
0 g
s
.844 .537 .002 r
.14763 .40561 m .15262 .42305 L .1489 .41627 L p F P
0 g
s
.818 .532 0 r
.14474 .39884 m .14128 .38202 L .14343 .3886 L p F P
0 g
s
.818 .532 0 r
.14343 .3886 m .14763 .40561 L .14474 .39884 L p F P
0 g
s
.844 .537 .002 r
.1489 .41627 m .14474 .39884 L .14763 .40561 L p F P
0 g
s
.282 0 .091 r
.1516 .27977 m .15923 .27996 L .1645 .2756 L p F P
0 g
s
.316 0 .234 r
.15923 .27996 m .1516 .27977 L .14802 .28326 L p F P
0 g
s
.197 .025 .408 r
.14422 .29769 m .14139 .29153 L .13867 .29592 L p F P
0 g
s
.197 .025 .408 r
.13867 .29592 m .1403 .30419 L .14422 .29769 L p F P
0 g
s
.301 .732 .97 r
.58904 .29207 m .56229 .29261 L .55644 .28013 L p F P
0 g
s
.339 .741 .982 r
.53151 .27982 m .55644 .28013 L .56229 .29261 L p F P
0 g
s
.966 .639 .292 r
.28838 .83156 m .27732 .80079 L .29417 .79921 L p F P
0 g
s
.959 .623 .251 r
.28163 .7717 m .29417 .79921 L .27732 .80079 L p F P
0 g
s
.006 0 0 r
.25525 .26113 m .24006 .26212 L .23291 .26207 L p F P
0 g
s
.107 .661 .769 r
.21902 .26311 m .23291 .26207 L .24006 .26212 L p F P
0 g
s
.316 0 .234 r
.14802 .28326 m .15393 .28527 L .15923 .27996 L p F P
0 g
s
.31 .035 .324 r
.15393 .28527 m .14802 .28326 L .14456 .28724 L p F P
0 g
s
.102 0 0 r
.21902 .26311 m .20518 .26477 L .19887 .26629 L p F P
0 g
s
0 0 0 r
.1864 .26802 m .19887 .26629 L .20518 .26477 L p F P
0 g
s
.053 .615 .792 r
.31102 .26261 m .29415 .26277 L .2861 .26062 L p F P
0 g
s
.148 .679 .862 r
.27059 .26063 m .2861 .26062 L .29415 .26277 L p F P
0 g
s
.271 .048 .38 r
.14884 .29128 m .14456 .28724 L .14139 .29153 L p F P
0 g
s
.271 .048 .38 r
.14139 .29153 m .14422 .29769 L .14884 .29128 L p F P
0 g
s
.31 .035 .324 r
.14456 .28724 m .14884 .29128 L .15393 .28527 L p F P
0 g
s
.122 0 0 r
.16948 .2724 m .18046 .27078 L .1864 .26802 L p F P
0 g
s
.282 0 0 r
.18046 .27078 m .16948 .2724 L .1645 .2756 L p F P
0 g
s
0 0 .3 r
.13731 .34284 m .136 .32911 L .13505 .33538 L p F P
0 g
s
0 0 .3 r
.13505 .33538 m .13643 .35028 L .13731 .34284 L p F P
0 g
s
.937 .579 .172 r
.2159 .61622 m .20667 .59218 L .21675 .59766 L p F P
0 g
s
.916 .554 .112 r
.20661 .57559 m .21675 .59766 L .20667 .59218 L p F P
0 g
s
0 0 .403 r
.13843 .32171 m .13726 .31046 L .13525 .31621 L p F P
0 g
s
0 0 .403 r
.13525 .31621 m .136 .32911 L .13843 .32171 L p F P
0 g
s
.231 0 0 r
.19887 .26629 m .1864 .26802 L .18046 .27078 L p F P
0 g
s
.09 .631 .85 r
.39171 .26908 m .37232 .26871 L .36346 .26418 L p F P
0 g
s
.167 .675 .902 r
.34565 .26331 m .36346 .26418 L .37232 .26871 L p F P
0 g
s
.184 .68 .917 r
.48394 .27932 m .46122 .27914 L .45291 .27133 L p F P
0 g
s
.241 .704 .948 r
.43198 .27039 m .45291 .27133 L .46122 .27914 L p F P
0 g
s
.282 0 0 r
.1645 .2756 m .17384 .27525 L .18046 .27078 L p F P
0 g
s
.352 0 .176 r
.17384 .27525 m .1645 .2756 L .15923 .27996 L p F P
0 g
s
0 0 .33 r
.1392 .3574 m .13731 .34284 L .13643 .35028 L p F P
0 g
s
0 0 .33 r
.13643 .35028 m .1385 .36583 L .1392 .3574 L p F P
0 g
s
.361 .766 .983 r
.77249 .3038 m .73903 .30579 L .73753 .2879 L p F P
0 g
s
.387 .768 .991 r
.70569 .28893 m .73753 .2879 L .73903 .30579 L p F P
0 g
s
.916 .554 .112 r
.20667 .59218 m .19797 .56874 L .20661 .57559 L p F P
0 g
s
.888 .525 .047 r
.1971 .55394 m .20661 .57559 L .19797 .56874 L p F P
0 g
s
.114 0 0 r
.27059 .26063 m .25525 .26113 L .24688 .26168 L p F P
0 g
s
.006 0 0 r
.23291 .26207 m .24688 .26168 L .25525 .26113 L p F P
0 g
s
.115 .016 .454 r
.14225 .31353 m .1403 .30419 L .13726 .31046 L p F P
0 g
s
.115 .016 .454 r
.13726 .31046 m .13843 .32171 L .14225 .31353 L p F P
0 g
s
.959 .623 .251 r
.27732 .80079 m .26661 .77063 L .28163 .7717 L p F P
0 g
s
.948 .604 .203 r
.26951 .74459 m .28163 .7717 L .26661 .77063 L p F P
0 g
s
.21 0 0 r
.23291 .26207 m .21902 .26311 L .21136 .26534 L p F P
0 g
s
.102 0 0 r
.19887 .26629 m .21136 .26534 L .21902 .26311 L p F P
0 g
s
0 .541 .708 r
.32818 .26279 m .31102 .26261 L .3018 .26111 L p F P
0 g
s
.053 .615 .792 r
.2861 .26062 m .3018 .26111 L .31102 .26261 L p F P
0 g
s
0 0 .447 r
.14005 .33392 m .13843 .32171 L .136 .32911 L p F P
0 g
s
0 0 .447 r
.136 .32911 m .13731 .34284 L .14005 .33392 L p F P
0 g
s
.352 0 .176 r
.15923 .27996 m .16688 .28122 L .17384 .27525 L p F P
0 g
s
.371 .059 .3 r
.16688 .28122 m .15923 .27996 L .15393 .28527 L p F P
0 g
s
0 0 .349 r
.14167 .37277 m .1392 .3574 L .1385 .36583 L p F P
0 g
s
0 0 .349 r
.1385 .36583 m .14128 .38202 L .14167 .37277 L p F P
0 g
s
.26 .72 .951 r
.61671 .29143 m .58904 .29207 L .58219 .28049 L p F P
0 g
s
.301 .732 .97 r
.55644 .28013 m .58219 .28049 L .58904 .29207 L p F P
0 g
s
.888 .525 .047 r
.19797 .56874 m .18981 .54595 L .1971 .55394 L p F P
0 g
s
.849 .49 0 r
.18822 .53274 m .1971 .55394 L .18981 .54595 L p F P
0 g
s
.231 0 0 r
.18046 .27078 m .19142 .27005 L .19887 .26629 L p F P
0 g
s
.357 0 .073 r
.19142 .27005 m .18046 .27078 L .17384 .27525 L p F P
0 g
s
.239 .082 .456 r
.14727 .30497 m .14422 .29769 L .1403 .30419 L p F P
0 g
s
.239 .082 .456 r
.1403 .30419 m .14225 .31353 L .14727 .30497 L p F P
0 g
s
.319 0 0 r
.21136 .26534 m .19887 .26629 L .19142 .27005 L p F P
0 g
s
.371 .059 .3 r
.15393 .28527 m .1599 .2884 L .16688 .28122 L p F P
0 g
s
.356 .099 .38 r
.1599 .2884 m .15393 .28527 L .14884 .29128 L p F P
0 g
s
.314 .107 .43 r
.15325 .29645 m .14884 .29128 L .14422 .29769 L p F P
0 g
s
.314 .107 .43 r
.14422 .29769 m .14727 .30497 L .15325 .29645 L p F P
0 g
s
.011 .579 .786 r
.41159 .26964 m .39171 .26908 L .38164 .26539 L p F P
0 g
s
.09 .631 .85 r
.36346 .26418 m .38164 .26539 L .39171 .26908 L p F P
0 g
s
.356 .099 .38 r
.14884 .29128 m .15325 .29645 L .1599 .2884 L p F P
0 g
s
0 0 .356 r
.14472 .38896 m .14167 .37277 L .14128 .38202 L p F P
0 g
s
0 0 .356 r
.14128 .38202 m .14474 .39884 L .14472 .38896 L p F P
0 g
s
.849 .49 0 r
.18981 .54595 m .18219 .5238 L .18822 .53274 L p F P
0 g
s
.801 .451 0 r
.18 .51202 m .18822 .53274 L .18333 .52549 L p F P
0 g
s
0 0 .353 r
.19498 .55471 m .18791 .53128 L .18951 .54362 L p F P
0 g
s
0 0 .353 r
.18951 .54362 m .18981 .54595 L p .19097 .54792 L F P
0 g
s
0 0 .353 r
.19097 .54792 m .19498 .55471 L .18951 .54362 L F
.801 .451 0 r
.18333 .52549 m .18219 .5238 L p .18151 .52015 L F P
0 g
s
.801 .451 0 r
.18 .51202 m .18333 .52549 L .18151 .52015 L F
.212 0 0 r
.2861 .26062 m .27059 .26063 L .26094 .26194 L p F P
0 g
s
.114 0 0 r
.24688 .26168 m .26094 .26194 L .27059 .26063 L p F P
0 g
s
.948 .604 .203 r
.26661 .77063 m .25627 .74111 L .26951 .74459 L p F P
0 g
s
.93 .581 .148 r
.25783 .71792 m .26951 .74459 L .25627 .74111 L p F P
0 g
s
.124 .65 .877 r
.50736 .27955 m .48394 .27932 L .47443 .27247 L p F P
0 g
s
.184 .68 .917 r
.45291 .27133 m .47443 .27247 L .48394 .27932 L p F P
0 g
s
.301 0 0 r
.24688 .26168 m .23291 .26207 L .22386 .26517 L p F P
0 g
s
.21 0 0 r
.21136 .26534 m .22386 .26517 L .23291 .26207 L p F P
0 g
s
.134 0 0 r
.34565 .26331 m .32818 .26279 L .31771 .26211 L p F P
0 g
s
0 .541 .708 r
.3018 .26111 m .31771 .26211 L .32818 .26279 L p F P
0 g
s
0 0 .352 r
.14834 .40594 m .14472 .38896 L .14474 .39884 L p F P
0 g
s
0 0 .352 r
.14474 .39884 m .1489 .41627 L .14834 .40594 L p F P
0 g
s
.801 .451 0 r
.18219 .5238 m .17513 .50234 L .18 .51202 L p F P
0 g
s
.746 .41 0 r
.17243 .49179 m .18 .51202 L .17513 .50234 L p F P
0 g
s
.146 .062 .495 r
.14453 .32394 m .14225 .31353 L .13843 .32171 L p F P
0 g
s
.146 .062 .495 r
.13843 .32171 m .14005 .33392 L .14453 .32394 L p F P
0 g
s
0 0 .481 r
.14212 .3471 m .14005 .33392 L .13731 .34284 L p F P
0 g
s
0 0 .481 r
.13731 .34284 m .1392 .3574 L .14212 .3471 L p F P
0 g
s
.357 0 .073 r
.17384 .27525 m .18318 .2759 L .19142 .27005 L p F P
0 g
s
.406 .05 .246 r
.18318 .2759 m .17384 .27525 L .16688 .28122 L p F P
0 g
s
0 0 .336 r
.15255 .42371 m .14834 .40594 L .1489 .41627 L p F P
0 g
s
0 0 .336 r
.1489 .41627 m .15376 .4343 L .15255 .42371 L p F P
0 g
s
.746 .41 0 r
.17513 .50234 m .16863 .48158 L .17243 .49179 L p F P
0 g
s
.684 .368 0 r
.16552 .47208 m .17243 .49179 L .16863 .48158 L p F P
0 g
s
.361 .766 .983 r
.73753 .2879 m .77056 .28675 L .77249 .3038 L p F P
0 g
s
0 0 .307 r
.15733 .44225 m .15255 .42371 L .15376 .4343 L p F P
0 g
s
0 0 .307 r
.15376 .4343 m .1593 .45291 L .15733 .44225 L p F P
0 g
s
.684 .368 0 r
.16863 .48158 m .16269 .46155 L .16552 .47208 L p F P
0 g
s
0 0 .267 r
.1593 .45291 m .16552 .47208 L .16269 .46155 L p F P
0 g
s
0 0 .267 r
.16269 .46155 m .15733 .44225 L .1593 .45291 L p F P
0 g
s
.389 0 .001 r
.22386 .26517 m .21136 .26534 L .20238 .27023 L p F P
0 g
s
.319 0 0 r
.19142 .27005 m .20238 .27023 L .21136 .26534 L p F P
0 g
s
.415 .006 .152 r
.20238 .27023 m .19142 .27005 L .18318 .2759 L p F P
0 g
s
.93 .581 .148 r
.25627 .74111 m .24631 .71225 L .25783 .71792 L p F P
0 g
s
.906 .551 .087 r
.24662 .69172 m .25783 .71792 L .24631 .71225 L p F P
0 g
s
.27 .128 .496 r
.15054 .31338 m .14727 .30497 L .14225 .31353 L p F P
0 g
s
.27 .128 .496 r
.14225 .31353 m .14453 .32394 L .15054 .31338 L p F P
0 g
s
.406 .05 .246 r
.16688 .28122 m .17454 .28356 L .18318 .2759 L p F P
0 g
s
.412 .119 .354 r
.17454 .28356 m .16688 .28122 L .1599 .2884 L p F P
0 g
s
.217 .705 .926 r
.64534 .2907 m .61671 .29143 L .60882 .28089 L p F P
0 g
s
.26 .72 .951 r
.58219 .28049 m .60882 .28089 L .61671 .29143 L p F P
0 g
s
.296 0 0 r
.3018 .26111 m .2861 .26062 L .2751 .26285 L p F P
0 g
s
.212 0 0 r
.26094 .26194 m .2751 .26285 L .2861 .26062 L p F P
0 g
s
0 0 .508 r
.14464 .36125 m .14212 .3471 L .1392 .3574 L p F P
0 g
s
0 0 .508 r
.1392 .3574 m .14167 .37277 L .14464 .36125 L p F P
0 g
s
0 .521 .712 r
.43198 .27039 m .41159 .26964 L .40021 .26696 L p F P
0 g
s
.011 .579 .786 r
.38164 .26539 m .40021 .26696 L .41159 .26964 L p F P
0 g
s
.374 0 0 r
.26094 .26194 m .24688 .26168 L .2364 .2658 L p F P
0 g
s
.301 0 0 r
.22386 .26517 m .2364 .2658 L .24688 .26168 L p F P
0 g
s
.347 .154 .471 r
.1578 .30278 m .15325 .29645 L .14727 .30497 L p F P
0 g
s
.347 .154 .471 r
.14727 .30497 m .15054 .31338 L .1578 .30278 L p F P
0 g
s
.412 .119 .354 r
.1599 .2884 m .16593 .29267 L .17454 .28356 L p F P
0 g
s
.392 .151 .425 r
.16593 .29267 m .1599 .2884 L .15325 .29645 L p F P
0 g
s
.166 .097 .528 r
.14714 .33543 m .14453 .32394 L .14005 .33392 L p F P
0 g
s
.166 .097 .528 r
.14005 .33392 m .14212 .3471 L .14714 .33543 L p F P
0 g
s
.216 0 0 r
.36346 .26418 m .34565 .26331 L .33385 .26362 L p F P
0 g
s
.134 0 0 r
.31771 .26211 m .33385 .26362 L .34565 .26331 L p F P
0 g
s
.392 .151 .425 r
.15325 .29645 m .1578 .30278 L .16593 .29267 L p F P
0 g
s
.063 .614 .828 r
.53151 .27982 m .50736 .27955 L .49657 .27381 L p F P
0 g
s
.124 .65 .877 r
.47443 .27247 m .49657 .27381 L .50736 .27955 L p F P
0 g
s
.906 .551 .087 r
.24631 .71225 m .23673 .68409 L .24662 .69172 L p F P
0 g
s
.871 .515 .019 r
.23589 .66602 m .24662 .69172 L .23673 .68409 L p F P
0 g
s
0 .005 .528 r
.14762 .37637 m .14464 .36125 L .14167 .37277 L p F P
0 g
s
0 .005 .528 r
.14167 .37277 m .14472 .38896 L .14762 .37637 L p F P
0 g
s
.415 .006 .152 r
.18318 .2759 m .1925 .27757 L .20238 .27023 L p F P
0 g
s
.446 .111 .303 r
.1925 .27757 m .18318 .2759 L .17454 .28356 L p F P
0 g
s
.442 0 .082 r
.2364 .2658 m .22386 .26517 L .21333 .27133 L p F P
0 g
s
.389 0 .001 r
.20238 .27023 m .21333 .27133 L .22386 .26517 L p F P
0 g
s
.459 .072 .218 r
.21333 .27133 m .20238 .27023 L .1925 .27757 L p F P
0 g
s
.871 .515 .019 r
.23673 .68409 m .22755 .65666 L .23589 .66602 L p F P
0 g
s
.826 .473 0 r
.22564 .64084 m .23589 .66602 L .22755 .65666 L p F P
0 g
s
.293 .164 .528 r
.15404 .32295 m .15054 .31338 L .14453 .32394 L p F P
0 g
s
.293 .164 .528 r
.14453 .32394 m .14714 .33543 L .15404 .32295 L p F P
0 g
s
.364 0 0 r
.31771 .26211 m .3018 .26111 L .28939 .26444 L p F P
0 g
s
.296 0 0 r
.2751 .26285 m .28939 .26444 L .3018 .26111 L p F P
0 g
s
0 .011 .541 r
.15105 .39245 m .14762 .37637 L .14472 .38896 L p F P
0 g
s
0 .011 .541 r
.14472 .38896 m .14834 .40594 L .15105 .39245 L p F P
0 g
s
.178 .125 .556 r
.15008 .348 m .14714 .33543 L .14212 .3471 L p F P
0 g
s
.178 .125 .556 r
.14212 .3471 m .14464 .36125 L .15008 .348 L p F P
0 g
s
.431 0 0 r
.2751 .26285 m .26094 .26194 L .24898 .26723 L p F P
0 g
s
.374 0 0 r
.2364 .2658 m .24898 .26723 L .26094 .26194 L p F P
0 g
s
.137 0 0 r
.45291 .27133 m .43198 .27039 L .4192 .26891 L p F P
0 g
s
0 .521 .712 r
.40021 .26696 m .4192 .26891 L .43198 .27039 L p F P
0 g
s
.446 .111 .303 r
.17454 .28356 m .18221 .28701 L .1925 .27757 L p F P
0 g
s
.444 .167 .398 r
.18221 .28701 m .17454 .28356 L .16593 .29267 L p F P
0 g
s
.173 .686 .896 r
.67498 .28987 m .64534 .2907 L .63639 .28135 L p F P
0 g
s
.217 .705 .926 r
.60882 .28089 m .63639 .28135 L .64534 .2907 L p F P
0 g
s
.287 0 0 r
.38164 .26539 m .36346 .26418 L .35024 .26565 L p F P
0 g
s
.216 0 0 r
.33385 .26362 m .35024 .26565 L .36346 .26418 L p F P
0 g
s
.826 .473 0 r
.22755 .65666 m .21878 .62998 L .22564 .64084 L p F P
0 g
s
.769 .423 0 r
.2159 .61622 m .22564 .64084 L .21878 .62998 L p F P
0 g
s
.371 .192 .504 r
.16247 .31029 m .1578 .30278 L .15054 .31338 L p F P
0 g
s
.371 .192 .504 r
.15054 .31338 m .15404 .32295 L .16247 .31029 L p F P
0 g
s
0 .008 .548 r
.15495 .40949 m .15105 .39245 L .14834 .40594 L p F P
0 g
s
0 .008 .548 r
.14834 .40594 m .15255 .42371 L .15495 .40949 L p F P
0 g
s
.444 .167 .398 r
.16593 .29267 m .17203 .29811 L .18221 .28701 L p F P
0 g
s
.419 .192 .462 r
.17203 .29811 m .16593 .29267 L .1578 .30278 L p F P
0 g
s
.003 .574 .772 r
.55644 .28013 m .53151 .27982 L .51937 .27536 L p F P
0 g
s
.063 .614 .828 r
.49657 .27381 m .51937 .27536 L .53151 .27982 L p F P
0 g
s
.419 .192 .462 r
.1578 .30278 m .16247 .31029 L .17203 .29811 L p F P
0 g
s
.769 .423 0 r
.21878 .62998 m .21042 .60408 L .2159 .61622 L p F P
0 g
s
.701 .367 0 r
.20667 .59218 m .2159 .61622 L .21042 .60408 L p F P
0 g
s
.482 .054 .15 r
.24898 .26723 m .2364 .2658 L .22429 .27336 L p F P
0 g
s
.442 0 .082 r
.21333 .27133 m .22429 .27336 L .2364 .2658 L p F P
0 g
s
.459 .072 .218 r
.1925 .27757 m .20182 .28027 L .21333 .27133 L p F P
0 g
s
.477 .16 .349 r
.20182 .28027 m .1925 .27757 L .18221 .28701 L p F P
0 g
s
0 0 .548 r
.1593 .42748 m .15495 .40949 L .15255 .42371 L p F P
0 g
s
0 0 .548 r
.15255 .42371 m .15733 .44225 L .1593 .42748 L p F P
0 g
s
.183 .145 .578 r
.15336 .36167 m .15008 .348 L .14464 .36125 L p F P
0 g
s
.183 .145 .578 r
.14464 .36125 m .14762 .37637 L .15336 .36167 L p F P
0 g
s
.308 .193 .555 r
.15775 .33367 m .15404 .32295 L .14714 .33543 L p F P
0 g
s
.308 .193 .555 r
.14714 .33543 m .15008 .348 L .15775 .33367 L p F P
0 g
s
.491 .125 .272 r
.22429 .27336 m .21333 .27133 L .20182 .28027 L p F P
0 g
s
.419 0 0 r
.33385 .26362 m .31771 .26211 L .30381 .2667 L p F P
0 g
s
.364 0 0 r
.28939 .26444 m .30381 .2667 L .31771 .26211 L p F P
0 g
s
0 0 .285 r
.19797 .56874 m .20667 .59218 L .20248 .57898 L p F P
0 g
s
.701 .367 0 r
.21042 .60408 m .20248 .57898 L .20667 .59218 L p F P
0 g
s
0 0 .54 r
.16411 .44641 m .1593 .42748 L .15733 .44225 L p F P
0 g
s
0 0 .54 r
.15733 .44225 m .16269 .46155 L .16411 .44641 L p F P
0 g
s
.474 0 .033 r
.28939 .26444 m .2751 .26285 L .26161 .26948 L p F P
0 g
s
.431 0 0 r
.24898 .26723 m .26161 .26948 L .2751 .26285 L p F P
0 g
s
0 0 .285 r
.20248 .57898 m .19498 .55471 L .19797 .56874 L p F P
0 g
s
0 0 .353 r
.18981 .54595 m .19797 .56874 L .19498 .55471 L p F P
0 g
s
0 0 .523 r
.16938 .46627 m .16411 .44641 L .16269 .46155 L p F P
0 g
s
0 0 .523 r
.16269 .46155 m .16863 .48158 L .16938 .46627 L p F P
0 g
s
.202 0 0 r
.47443 .27247 m .45291 .27133 L .43866 .27122 L p F P
0 g
s
.137 0 0 r
.4192 .26891 m .43866 .27122 L .45291 .27133 L p F P
0 g
s
0 0 .412 r
.18219 .5238 m .18981 .54595 L .18791 .53128 L p F P
0 g
s
.346 0 0 r
.40021 .26696 m .38164 .26539 L .36691 .26822 L p F P
0 g
s
.287 0 0 r
.35024 .26565 m .36691 .26822 L .38164 .26539 L p F P
0 g
s
.477 .16 .349 r
.18221 .28701 m .1899 .29159 L .20182 .28027 L p F P
0 g
s
.467 .206 .434 r
.1899 .29159 m .18221 .28701 L .17203 .29811 L p F P
0 g
s
0 0 .497 r
.17511 .48704 m .16938 .46627 L .16863 .48158 L p F P
0 g
s
0 0 .497 r
.16863 .48158 m .17513 .50234 L .17511 .48704 L p F P
0 g
s
.909 .576 .099 r
.29978 .8629 m .31151 .89478 L .29825 .89198 L p F P
0 g
s
0 0 .412 r
.18791 .53128 m .18129 .50872 L .18219 .5238 L p F P
0 g
s
0 0 .46 r
.17513 .50234 m .18219 .5238 L .18129 .50872 L p F P
0 g
s
0 0 .46 r
.18129 .50872 m .17511 .48704 L .17513 .50234 L p F P
0 g
s
.388 .222 .532 r
.16728 .31899 m .16247 .31029 L .15404 .32295 L p F P
0 g
s
.388 .222 .532 r
.15404 .32295 m .15775 .33367 L .16728 .31899 L p F P
0 g
s
.18 .158 .596 r
.15697 .37643 m .15336 .36167 L .14762 .37637 L p F P
0 g
s
.18 .158 .596 r
.14762 .37637 m .15105 .39245 L .15697 .37643 L p F P
0 g
s
.128 .663 .86 r
.70569 .28893 m .67498 .28987 L .66494 .28185 L p F P
0 g
s
.173 .686 .896 r
.63639 .28135 m .66494 .28185 L .67498 .28987 L p F P
0 g
s
.467 .206 .434 r
.17203 .29811 m .17819 .30472 L .1899 .29159 L p F P
0 g
s
.438 .226 .492 r
.17819 .30472 m .17203 .29811 L .16247 .31029 L p F P
0 g
s
.438 .226 .492 r
.16247 .31029 m .16728 .31899 L .17819 .30472 L p F P
0 g
s
.512 .106 .207 r
.26161 .26948 m .24898 .26723 L .23526 .27634 L p F P
0 g
s
.482 .054 .15 r
.22429 .27336 m .23526 .27634 L .24898 .26723 L p F P
0 g
s
.317 .215 .577 r
.1617 .34558 m .15775 .33367 L .15008 .348 L p F P
0 g
s
.317 .215 .577 r
.15008 .348 m .15336 .36167 L .1617 .34558 L p F P
0 g
s
0 .531 .709 r
.58219 .28049 m .55644 .28013 L .54288 .27713 L p F P
0 g
s
.003 .574 .772 r
.51937 .27536 m .54288 .27713 L .55644 .28013 L p F P
0 g
s
.491 .125 .272 r
.20182 .28027 m .21114 .28403 L .22429 .27336 L p F P
0 g
s
.499 .199 .388 r
.21114 .28403 m .20182 .28027 L .1899 .29159 L p F P
0 g
s
.909 .576 .099 r
.29825 .89198 m .28832 .85719 L .29978 .8629 L p F P
0 g
s
.879 .544 .042 r
.28838 .83156 m .29978 .8629 L .28832 .85719 L p F P
0 g
s
.461 0 0 r
.35024 .26565 m .33385 .26362 L .31839 .26965 L p F P
0 g
s
.419 0 0 r
.30381 .2667 m .31839 .26965 L .33385 .26362 L p F P
0 g
s
.516 .169 .317 r
.23526 .27634 m .22429 .27336 L .21114 .28403 L p F P
0 g
s
.171 .165 .609 r
.16093 .39229 m .15697 .37643 L .15105 .39245 L p F P
0 g
s
.171 .165 .609 r
.15105 .39245 m .15495 .40949 L .16093 .39229 L p F P
0 g
s
.507 .048 .099 r
.30381 .2667 m .28939 .26444 L .27431 .27257 L p F P
0 g
s
.474 0 .033 r
.26161 .26948 m .27431 .27257 L .28939 .26444 L p F P
0 g
s
.4 .247 .555 r
.17222 .32891 m .16728 .31899 L .15775 .33367 L p F P
0 g
s
.4 .247 .555 r
.15775 .33367 m .1617 .34558 L .17222 .32891 L p F P
0 g
s
.259 0 0 r
.49657 .27381 m .47443 .27247 L .4586 .27392 L p F P
0 g
s
.202 0 0 r
.43866 .27122 m .4586 .27392 L .47443 .27247 L p F P
0 g
s
.394 0 0 r
.4192 .26891 m .40021 .26696 L .38389 .27133 L p F P
0 g
s
.346 0 0 r
.36691 .26822 m .38389 .27133 L .40021 .26696 L p F P
0 g
s
.499 .199 .388 r
.1899 .29159 m .19761 .29731 L .21114 .28403 L p F P
0 g
s
.485 .238 .464 r
.19761 .29731 m .1899 .29159 L .17819 .30472 L p F P
0 g
s
.879 .544 .042 r
.28832 .85719 m .27865 .82322 L .28838 .83156 L p F P
0 g
s
.841 .507 0 r
.27732 .80079 m .28838 .83156 L .27865 .82322 L p F P
0 g
s
.155 .167 .62 r
.16522 .40925 m .16093 .39229 L .15495 .40949 L p F P
0 g
s
.155 .167 .62 r
.15495 .40949 m .1593 .42748 L .16522 .40925 L p F P
0 g
s
.321 .232 .596 r
.16587 .35866 m .1617 .34558 L .15336 .36167 L p F P
0 g
s
.321 .232 .596 r
.15336 .36167 m .15697 .37643 L .16587 .35866 L p F P
0 g
s
.452 .253 .518 r
.18441 .31253 m .17819 .30472 L .16728 .31899 L p F P
0 g
s
.452 .253 .518 r
.16728 .31899 m .17222 .32891 L .18441 .31253 L p F P
0 g
s
.485 .238 .464 r
.17819 .30472 m .18441 .31253 L .19761 .29731 L p F P
0 g
s
.535 .148 .255 r
.27431 .27257 m .26161 .26948 L .24625 .28028 L p F P
0 g
s
.512 .106 .207 r
.23526 .27634 m .24625 .28028 L .26161 .26948 L p F P
0 g
s
.084 .636 .818 r
.73753 .2879 m .70569 .28893 L .69454 .2824 L p F P
0 g
s
.128 .663 .86 r
.66494 .28185 m .69454 .2824 L .70569 .28893 L p F P
0 g
s
.841 .507 0 r
.27865 .82322 m .26925 .79008 L .27732 .80079 L p F P
0 g
s
.793 .463 0 r
.26661 .77063 m .27732 .80079 L .26925 .79008 L p F P
0 g
s
.516 .169 .317 r
.21114 .28403 m .22046 .28886 L .23526 .27634 L p F P
0 g
s
.516 .231 .42 r
.22046 .28886 m .21114 .28403 L .19761 .29731 L p F P
0 g
s
.132 .162 .626 r
.16986 .4273 m .16522 .40925 L .1593 .42748 L p F P
0 g
s
.132 .162 .626 r
.1593 .42748 m .16411 .44641 L .16986 .4273 L p F P
0 g
s
.109 0 0 r
.60882 .28089 m .58219 .28049 L .56715 .27913 L p F P
0 g
s
0 .531 .709 r
.54288 .27713 m .56715 .27913 L .58219 .28049 L p F P
0 g
s
.492 0 0 r
.36691 .26822 m .35024 .26565 L .33314 .27332 L p F P
0 g
s
.461 0 0 r
.31839 .26965 m .33314 .27332 L .35024 .26565 L p F P
0 g
s
.534 .204 .354 r
.24625 .28028 m .23526 .27634 L .22046 .28886 L p F P
0 g
s
.531 .094 .155 r
.31839 .26965 m .30381 .2667 L .28709 .27651 L p F P
0 g
s
.507 .048 .099 r
.27431 .27257 m .28709 .27651 L .30381 .2667 L p F P
0 g
s
.32 .243 .612 r
.17026 .37294 m .16587 .35866 L .15697 .37643 L p F P
0 g
s
.32 .243 .612 r
.15697 .37643 m .16093 .39229 L .17026 .37294 L p F P
0 g
s
.793 .463 0 r
.26925 .79008 m .26013 .75782 L .26661 .77063 L p F P
0 g
s
.734 .411 0 r
.25627 .74111 m .26661 .77063 L .26013 .75782 L p F P
0 g
s
.407 .265 .575 r
.1773 .34004 m .17222 .32891 L .1617 .34558 L p F P
0 g
s
.407 .265 .575 r
.1617 .34558 m .16587 .35866 L .1773 .34004 L p F P
0 g
s
.102 .152 .629 r
.17483 .44645 m .16986 .4273 L .16411 .44641 L p F P
0 g
s
.102 .152 .629 r
.16411 .44641 m .16938 .46627 L .17483 .44645 L p F P
0 g
s
.432 0 0 r
.43866 .27122 m .4192 .26891 L .40119 .27501 L p F P
0 g
s
.394 0 0 r
.38389 .27133 m .40119 .27501 L .4192 .26891 L p F P
0 g
s
.516 .231 .42 r
.19761 .29731 m .20534 .30419 L .22046 .28886 L p F P
0 g
s
.497 .263 .49 r
.20534 .30419 m .19761 .29731 L .18441 .31253 L p F P
0 g
s
.307 0 0 r
.51937 .27536 m .49657 .27381 L .47907 .27702 L p F P
0 g
s
.259 0 0 r
.4586 .27392 m .47907 .27702 L .49657 .27381 L p F P
0 g
s
0 0 .234 r
.24631 .71225 m .25627 .74111 L .2513 .72645 L p F P
0 g
s
.734 .411 0 r
.26013 .75782 m .2513 .72645 L .25627 .74111 L p F P
0 g
s
.065 .136 .628 r
.18014 .46668 m .17483 .44645 L .16938 .46627 L p F P
0 g
s
.065 .136 .628 r
.16938 .46627 m .17511 .48704 L .18014 .46668 L p F P
0 g
s
.462 .274 .539 r
.19069 .32156 m .18441 .31253 L .17222 .32891 L p F P
0 g
s
.462 .274 .539 r
.17222 .32891 m .1773 .34004 L .19069 .32156 L p F P
0 g
s
.497 .263 .49 r
.18441 .31253 m .19069 .32156 L .20534 .30419 L p F P
0 g
s
.551 .182 .295 r
.28709 .27651 m .27431 .27257 L .25727 .28522 L p F P
0 g
s
.535 .148 .255 r
.24625 .28028 m .25727 .28522 L .27431 .27257 L p F P
0 g
s
0 0 .234 r
.2513 .72645 m .24277 .696 L .24631 .71225 L p F P
0 g
s
0 0 .306 r
.23673 .68409 m .24631 .71225 L .24277 .696 L p F P
0 g
s
.314 .251 .625 r
.17489 .38842 m .17026 .37294 L .16093 .39229 L p F P
0 g
s
.314 .251 .625 r
.16093 .39229 m .16522 .40925 L .17489 .38842 L p F P
0 g
s
.02 .113 .622 r
.18579 .48799 m .18014 .46668 L .17511 .48704 L p F P
0 g
s
.02 .113 .622 r
.17511 .48704 m .18129 .50872 L .18579 .48799 L p F P
0 g
s
.534 .204 .354 r
.22046 .28886 m .2298 .29478 L .24625 .28028 L p F P
0 g
s
.528 .257 .447 r
.2298 .29478 m .22046 .28886 L .20534 .30419 L p F P
0 g
s
.516 .038 .059 r
.38389 .27133 m .36691 .26822 L .34809 .27771 L p F P
0 g
s
.492 0 0 r
.33314 .27332 m .34809 .27771 L .36691 .26822 L p F P
0 g
s
.547 .232 .386 r
.25727 .28522 m .24625 .28028 L .2298 .29478 L p F P
0 g
s
.041 .607 .773 r
.77056 .28675 m .73753 .2879 L .72526 .28301 L p F P
0 g
s
.084 .636 .818 r
.69454 .2824 m .72526 .28301 L .73753 .2879 L p F P
0 g
s
0 0 .306 r
.24277 .696 m .23454 .66649 L .23673 .68409 L p F P
0 g
s
0 0 .374 r
.22755 .65666 m .23673 .68409 L .23454 .66649 L p F P
0 g
s
.41 .28 .591 r
.18251 .35242 m .1773 .34004 L .16587 .35866 L p F P
0 g
s
.41 .28 .591 r
.16587 .35866 m .17026 .37294 L .18251 .35242 L p F P
0 g
s
0 .084 .61 r
.19177 .51037 m .18579 .48799 L .18129 .50872 L p F P
0 g
s
0 .084 .61 r
.18129 .50872 m .18791 .53128 L .19177 .51037 L p F P
0 g
s
.548 .131 .202 r
.33314 .27332 m .31839 .26965 L .29995 .28131 L p F P
0 g
s
.531 .094 .155 r
.28709 .27651 m .29995 .28131 L .31839 .26965 L p F P
0 g
s
.158 0 0 r
.63639 .28135 m .60882 .28089 L .59222 .28135 L p F P
0 g
s
.109 0 0 r
.56715 .27913 m .59222 .28135 L .60882 .28089 L p F P
0 g
s
0 0 .374 r
.23454 .66649 m .22661 .63795 L .22755 .65666 L p F P
0 g
s
0 0 .435 r
.21878 .62998 m .22755 .65666 L .22661 .63795 L p F P
0 g
s
0 .048 .592 r
.19809 .53382 m .19177 .51037 L .18791 .53128 L p F P
0 g
s
0 .048 .592 r
.18791 .53128 m .19498 .55471 L .19809 .53382 L p F P
0 g
s
0 0 .435 r
.22661 .63795 m .219 .6104 L .21878 .62998 L p F P
0 g
s
0 0 .488 r
.21042 .60408 m .21878 .62998 L .219 .6104 L p F P
0 g
s
0 .004 .566 r
.20473 .55831 m .19809 .53382 L .19498 .55471 L p F P
0 g
s
0 .004 .566 r
.19498 .55471 m .20248 .57898 L .20473 .55831 L p F P
0 g
s
0 0 .488 r
.219 .6104 m .2117 .58384 L .21042 .60408 L p F P
0 g
s
0 0 .532 r
.20248 .57898 m .21042 .60408 L .2117 .58384 L p F P
0 g
s
0 0 .532 r
.2117 .58384 m .20473 .55831 L .20248 .57898 L p F P
0 g
s
.304 .254 .636 r
.17974 .40511 m .17489 .38842 L .16522 .40925 L p F P
0 g
s
.304 .254 .636 r
.16522 .40925 m .16986 .4273 L .17974 .40511 L p F P
0 g
s
.528 .257 .447 r
.20534 .30419 m .21309 .31227 L .2298 .29478 L p F P
0 g
s
.506 .284 .511 r
.21309 .31227 m .20534 .30419 L .19069 .32156 L p F P
0 g
s
.468 .291 .558 r
.19704 .33183 m .19069 .32156 L .1773 .34004 L p F P
0 g
s
.468 .291 .558 r
.1773 .34004 m .18251 .35242 L .19704 .33183 L p F P
0 g
s
.461 0 0 r
.4586 .27392 m .43866 .27122 L .41886 .27926 L p F P
0 g
s
.432 0 0 r
.40119 .27501 m .41886 .27926 L .43866 .27122 L p F P
0 g
s
.347 0 0 r
.54288 .27713 m .51937 .27536 L .50011 .28054 L p F P
0 g
s
.307 0 0 r
.47907 .27702 m .50011 .28054 L .51937 .27536 L p F P
0 g
s
.506 .284 .511 r
.19069 .32156 m .19704 .33183 L .21309 .31227 L p F P
0 g
s
.562 .21 .33 r
.29995 .28131 m .28709 .27651 L .26833 .29117 L p F P
0 g
s
.551 .182 .295 r
.25727 .28522 m .26833 .29117 L .28709 .27651 L p F P
0 g
s
.409 .29 .606 r
.18785 .36606 m .18251 .35242 L .17026 .37294 L p F P
0 g
s
.409 .29 .606 r
.17026 .37294 m .17489 .38842 L .18785 .36606 L p F P
0 g
s
.547 .232 .386 r
.2298 .29478 m .23914 .30183 L .25727 .28522 L p F P
0 g
s
.536 .278 .471 r
.23914 .30183 m .2298 .29478 L .21309 .31227 L p F P
0 g
s
.289 .253 .644 r
.18482 .42302 m .17974 .40511 L .16986 .4273 L p F P
0 g
s
.289 .253 .644 r
.16986 .4273 m .17483 .44645 L .18482 .42302 L p F P
0 g
s
.555 .255 .413 r
.26833 .29117 m .25727 .28522 L .23914 .30183 L p F P
0 g
s
.533 .075 .111 r
.40119 .27501 m .38389 .27133 L .36325 .28285 L p F P
0 g
s
.516 .038 .059 r
.34809 .27771 m .36325 .28285 L .38389 .27133 L p F P
0 g
s
.56 .161 .243 r
.34809 .27771 m .33314 .27332 L .31292 .28701 L p F P
0 g
s
.548 .131 .202 r
.29995 .28131 m .31292 .28701 L .33314 .27332 L p F P
0 g
s
.041 .607 .773 r
.72526 .28301 m .75717 .28367 L .77056 .28675 L p F P
0 g
s
.47 .304 .574 r
.20346 .34336 m .19704 .33183 L .18251 .35242 L p F P
0 g
s
.47 .304 .574 r
.18251 .35242 m .18785 .36606 L .20346 .34336 L p F P
0 g
s
.201 0 0 r
.66494 .28185 m .63639 .28135 L .61815 .28382 L p F P
0 g
s
.158 0 0 r
.59222 .28135 m .61815 .28382 L .63639 .28135 L p F P
0 g
s
.27 .249 .65 r
.19013 .44215 m .18482 .42302 L .17483 .44645 L p F P
0 g
s
.27 .249 .65 r
.17483 .44645 m .18014 .46668 L .19013 .44215 L p F P
0 g
s
.536 .278 .471 r
.21309 .31227 m .22087 .32155 L .23914 .30183 L p F P
0 g
s
.511 .3 .53 r
.22087 .32155 m .21309 .31227 L .19704 .33183 L p F P
0 g
s
.405 .297 .618 r
.19333 .38097 m .18785 .36606 L .17489 .38842 L p F P
0 g
s
.405 .297 .618 r
.17489 .38842 m .17974 .40511 L .19333 .38097 L p F P
0 g
s
.511 .3 .53 r
.19704 .33183 m .20346 .34336 L .22087 .32155 L p F P
0 g
s
.483 0 0 r
.47907 .27702 m .4586 .27392 L .43691 .28412 L p F P
0 g
s
.461 0 0 r
.41886 .27926 m .43691 .28412 L .4586 .27392 L p F P
0 g
s
.569 .233 .359 r
.31292 .28701 m .29995 .28131 L .27942 .29815 L p F P
0 g
s
.562 .21 .33 r
.26833 .29117 m .27942 .29815 L .29995 .28131 L p F P
0 g
s
.247 .24 .654 r
.19567 .4625 m .19013 .44215 L .18014 .46668 L p F P
0 g
s
.247 .24 .654 r
.18014 .46668 m .18579 .48799 L .19567 .4625 L p F P
0 g
s
.38 0 0 r
.56715 .27913 m .54288 .27713 L .52176 .28447 L p F P
0 g
s
.347 0 0 r
.50011 .28054 m .52176 .28447 L .54288 .27713 L p F P
0 g
s
.555 .255 .413 r
.23914 .30183 m .2485 .31001 L .26833 .29117 L p F P
0 g
s
.541 .294 .491 r
.2485 .31001 m .23914 .30183 L .22087 .32155 L p F P
0 g
s
.561 .273 .436 r
.27942 .29815 m .26833 .29117 L .2485 .31001 L p F P
0 g
s
.545 .106 .155 r
.41886 .27926 m .40119 .27501 L .37864 .28875 L p F P
0 g
s
.533 .075 .111 r
.36325 .28285 m .37864 .28875 L .40119 .27501 L p F P
0 g
s
.398 .301 .628 r
.19894 .39717 m .19333 .38097 L .17974 .40511 L p F P
0 g
s
.398 .301 .628 r
.17974 .40511 m .18482 .42302 L .19894 .39717 L p F P
0 g
s
.568 .186 .277 r
.36325 .28285 m .34809 .27771 L .32601 .29363 L p F P
0 g
s
.56 .161 .243 r
.31292 .28701 m .32601 .29363 L .34809 .27771 L p F P
0 g
s
.47 .314 .587 r
.20994 .35617 m .20346 .34336 L .18785 .36606 L p F P
0 g
s
.47 .314 .587 r
.18785 .36606 m .19333 .38097 L .20994 .35617 L p F P
0 g
s
.218 .228 .656 r
.20143 .48407 m .19567 .4625 L .18579 .48799 L p F P
0 g
s
.218 .228 .656 r
.18579 .48799 m .19177 .51037 L .20143 .48407 L p F P
0 g
s
.541 .294 .491 r
.22087 .32155 m .22867 .33208 L .2485 .31001 L p F P
0 g
s
.513 .313 .546 r
.22867 .33208 m .22087 .32155 L .20346 .34336 L p F P
0 g
s
.513 .313 .546 r
.20346 .34336 m .20994 .35617 L .22867 .33208 L p F P
0 g
s
.185 .211 .654 r
.20742 .50687 m .20143 .48407 L .19177 .51037 L p F P
0 g
s
.185 .211 .654 r
.19177 .51037 m .19809 .53382 L .20742 .50687 L p F P
0 g
s
.239 0 0 r
.69454 .2824 m .66494 .28185 L .645 .28654 L p F P
0 g
s
.201 0 0 r
.61815 .28382 m .645 .28654 L .66494 .28185 L p F P
0 g
s
.388 .302 .637 r
.20469 .41467 m .19894 .39717 L .18482 .42302 L p F P
0 g
s
.388 .302 .637 r
.18482 .42302 m .19013 .44215 L .20469 .41467 L p F P
0 g
s
.574 .251 .384 r
.32601 .29363 m .31292 .28701 L .29057 .30619 L p F P
0 g
s
.569 .233 .359 r
.27942 .29815 m .29057 .30619 L .31292 .28701 L p F P
0 g
s
.146 .19 .65 r
.21364 .53089 m .20742 .50687 L .19809 .53382 L p F P
0 g
s
.146 .19 .65 r
.19809 .53382 m .20473 .55831 L .21364 .53089 L p F P
0 g
s
.499 .008 .021 r
.50011 .28054 m .47907 .27702 L .45538 .28958 L p F P
0 g
s
.483 0 0 r
.43691 .28412 m .45538 .28958 L .47907 .27702 L p F P
0 g
s
.561 .273 .436 r
.2485 .31001 m .25788 .31936 L .27942 .29815 L p F P
0 g
s
.543 .307 .508 r
.25788 .31936 m .2485 .31001 L .22867 .33208 L p F P
0 g
s
.467 .321 .599 r
.21648 .37029 m .20994 .35617 L .19333 .38097 L p F P
0 g
s
.467 .321 .599 r
.19333 .38097 m .19894 .39717 L .21648 .37029 L p F P
0 g
s
.564 .288 .456 r
.29057 .30619 m .27942 .29815 L .25788 .31936 L p F P
0 g
s
.406 0 0 r
.59222 .28135 m .56715 .27913 L .54406 .28885 L p F P
0 g
s
.38 0 0 r
.52176 .28447 m .54406 .28885 L .56715 .27913 L p F P
0 g
s
.101 .164 .642 r
.22008 .55613 m .21364 .53089 L .20473 .55831 L p F P
0 g
s
.101 .164 .642 r
.20473 .55831 m .2117 .58384 L .22008 .55613 L p F P
0 g
s
.573 .206 .307 r
.37864 .28875 m .36325 .28285 L .33923 .30119 L p F P
0 g
s
.568 .186 .277 r
.32601 .29363 m .33923 .30119 L .36325 .28285 L p F P
0 g
s
.554 .131 .193 r
.43691 .28412 m .41886 .27926 L .39429 .29545 L p F P
0 g
s
.545 .106 .155 r
.37864 .28875 m .39429 .29545 L .41886 .27926 L p F P
0 g
s
.05 .133 .631 r
.22674 .58259 m .22008 .55613 L .2117 .58384 L p F P
0 g
s
.05 .133 .631 r
.2117 .58384 m .219 .6104 L .22674 .58259 L p F P
0 g
s
0 0 .278 r
.28832 .85719 m .29825 .89198 L .29622 .87408 L p F P
0 g
s
.543 .307 .508 r
.22867 .33208 m .2365 .34386 L .25788 .31936 L p F P
0 g
s
.513 .322 .56 r
.2365 .34386 m .22867 .33208 L .20994 .35617 L p F P
0 g
s
.375 .3 .644 r
.21057 .43349 m .20469 .41467 L .19013 .44215 L p F P
0 g
s
.375 .3 .644 r
.19013 .44215 m .19567 .4625 L .21057 .43349 L p F P
0 g
s
.513 .322 .56 r
.20994 .35617 m .21648 .37029 L .2365 .34386 L p F P
0 g
s
0 .097 .614 r
.23362 .61026 m .22674 .58259 L .219 .6104 L p F P
0 g
s
0 .097 .614 r
.219 .6104 m .22661 .63795 L .23362 .61026 L p F P
0 g
s
0 0 .278 r
.29622 .87408 m .28769 .8371 L .28832 .85719 L p F P
0 g
s
0 0 .337 r
.27865 .82322 m .28832 .85719 L .28769 .8371 L p F P
0 g
s
0 .056 .592 r
.24072 .63914 m .23362 .61026 L .22661 .63795 L p F P
0 g
s
0 .056 .592 r
.22661 .63795 m .23454 .66649 L .24072 .63914 L p F P
0 g
s
0 0 .337 r
.28769 .8371 m .27936 .80123 L .27865 .82322 L p F P
0 g
s
0 0 .393 r
.26925 .79008 m .27865 .82322 L .27936 .80123 L p F P
0 g
s
0 .01 .565 r
.24803 .66921 m .24072 .63914 L .23454 .66649 L p F P
0 g
s
0 .01 .565 r
.23454 .66649 m .24277 .696 L .24803 .66921 L p F P
0 g
s
.462 .325 .609 r
.22309 .38573 m .21648 .37029 L .19894 .39717 L p F P
0 g
s
.462 .325 .609 r
.19894 .39717 m .20469 .41467 L .22309 .38573 L p F P
0 g
s
0 0 .393 r
.27936 .80123 m .27122 .76649 L .26925 .79008 L p F P
0 g
s
0 0 .444 r
.26013 .75782 m .26925 .79008 L .27122 .76649 L p F P
0 g
s
0 0 .531 r
.25555 .70047 m .24803 .66921 L .24277 .696 L p F P
0 g
s
0 0 .531 r
.24277 .696 m .2513 .72645 L .25555 .70047 L p F P
0 g
s
0 0 .444 r
.27122 .76649 m .26328 .7329 L .26013 .75782 L p F P
0 g
s
0 0 .491 r
.2513 .72645 m .26013 .75782 L .26328 .7329 L p F P
0 g
s
0 0 .491 r
.26328 .7329 m .25555 .70047 L .2513 .72645 L p F P
0 g
s
.576 .265 .405 r
.33923 .30119 m .32601 .29363 L .30178 .31531 L p F P
0 g
s
.574 .251 .384 r
.29057 .30619 m .30178 .31531 L .32601 .29363 L p F P
0 g
s
.564 .288 .456 r
.25788 .31936 m .26729 .32991 L .29057 .30619 L p F P
0 g
s
.544 .318 .523 r
.26729 .32991 m .25788 .31936 L .2365 .34386 L p F P
0 g
s
.359 .296 .649 r
.21658 .45363 m .21057 .43349 L .19567 .4625 L p F P
0 g
s
.359 .296 .649 r
.19567 .4625 m .20143 .48407 L .21658 .45363 L p F P
0 g
s
.272 0 0 r
.72526 .28301 m .69454 .2824 L .67284 .28951 L p F P
0 g
s
.239 0 0 r
.645 .28654 m .67284 .28951 L .69454 .2824 L p F P
0 g
s
.511 .037 .066 r
.52176 .28447 m .50011 .28054 L .4743 .29569 L p F P
0 g
s
.499 .008 .021 r
.45538 .28958 m .4743 .29569 L .50011 .28054 L p F P
0 g
s
.565 .3 .473 r
.30178 .31531 m .29057 .30619 L .26729 .32991 L p F P
0 g
s
.51 .329 .572 r
.24436 .35693 m .2365 .34386 L .21648 .37029 L p F P
0 g
s
.51 .329 .572 r
.21648 .37029 m .22309 .38573 L .24436 .35693 L p F P
0 g
s
.544 .318 .523 r
.2365 .34386 m .24436 .35693 L .26729 .32991 L p F P
0 g
s
.426 0 0 r
.61815 .28382 m .59222 .28135 L .56706 .29369 L p F P
0 g
s
.406 0 0 r
.54406 .28885 m .56706 .29369 L .59222 .28135 L p F P
0 g
s
.576 .223 .333 r
.39429 .29545 m .37864 .28875 L .35259 .30971 L p F P
0 g
s
.573 .206 .307 r
.33923 .30119 m .35259 .30971 L .37864 .28875 L p F P
0 g
s
.34 .289 .653 r
.22273 .47511 m .21658 .45363 L .20143 .48407 L p F P
0 g
s
.34 .289 .653 r
.20143 .48407 m .20742 .50687 L .22273 .47511 L p F P
0 g
s
.559 .152 .226 r
.45538 .28958 m .43691 .28412 L .41022 .30296 L p F P
0 g
s
.554 .131 .193 r
.39429 .29545 m .41022 .30296 L .43691 .28412 L p F P
0 g
s
.454 .327 .618 r
.22977 .40251 m .22309 .38573 L .20469 .41467 L p F P
0 g
s
.454 .327 .618 r
.20469 .41467 m .21057 .43349 L .22977 .40251 L p F P
0 g
s
.565 .3 .473 r
.26729 .32991 m .27672 .34169 L .30178 .31531 L p F P
0 g
s
.542 .325 .535 r
.27672 .34169 m .26729 .32991 L .24436 .35693 L p F P
0 g
s
.318 .279 .656 r
.22902 .49794 m .22273 .47511 L .20742 .50687 L p F P
0 g
s
.318 .279 .656 r
.20742 .50687 m .21364 .53089 L .22902 .49794 L p F P
0 g
s
.576 .277 .424 r
.35259 .30971 m .33923 .30119 L .31306 .32556 L p F P
0 g
s
.576 .265 .405 r
.30178 .31531 m .31306 .32556 L .33923 .30119 L p F P
0 g
s
.506 .334 .582 r
.25225 .37132 m .24436 .35693 L .22309 .38573 L p F P
0 g
s
.506 .334 .582 r
.22309 .38573 m .22977 .40251 L .25225 .37132 L p F P
0 g
s
.564 .309 .488 r
.31306 .32556 m .30178 .31531 L .27672 .34169 L p F P
0 g
s
.444 .327 .625 r
.23652 .42067 m .22977 .40251 L .21057 .43349 L p F P
0 g
s
.444 .327 .625 r
.21057 .43349 m .21658 .45363 L .23652 .42067 L p F P
0 g
s
.542 .325 .535 r
.24436 .35693 m .25225 .37132 L .27672 .34169 L p F P
0 g
s
.3 0 0 r
.75717 .28367 m .72526 .28301 L .70173 .29277 L p F P
0 g
s
.272 0 0 r
.67284 .28951 m .70173 .29277 L .72526 .28301 L p F P
0 g
s
.52 .062 .105 r
.54406 .28885 m .52176 .28447 L .49371 .30246 L p F P
0 g
s
.511 .037 .066 r
.4743 .29569 m .49371 .30246 L .52176 .28447 L p F P
0 g
s
.293 .266 .657 r
.23543 .52213 m .22902 .49794 L .21364 .53089 L p F P
0 g
s
.293 .266 .657 r
.21364 .53089 m .22008 .55613 L .23543 .52213 L p F P
0 g
s
.576 .236 .355 r
.41022 .30296 m .39429 .29545 L .36612 .31924 L p F P
0 g
s
.576 .223 .333 r
.35259 .30971 m .36612 .31924 L .39429 .29545 L p F P
0 g
s
.442 0 0 r
.645 .28654 m .61815 .28382 L .59082 .29901 L p F P
0 g
s
.426 0 0 r
.56706 .29369 m .59082 .29901 L .61815 .28382 L p F P
0 g
s
.562 .169 .255 r
.4743 .29569 m .45538 .28958 L .42645 .31133 L p F P
0 g
s
.559 .152 .226 r
.41022 .30296 m .42645 .31133 L .45538 .28958 L p F P
0 g
s
.264 .25 .656 r
.24198 .54768 m .23543 .52213 L .22008 .55613 L p F P
0 g
s
.264 .25 .656 r
.22008 .55613 m .22674 .58259 L .24198 .54768 L p F P
0 g
s
.433 .325 .631 r
.24333 .44021 m .23652 .42067 L .21658 .45363 L p F P
0 g
s
.433 .325 .631 r
.21658 .45363 m .22273 .47511 L .24333 .44021 L p F P
0 g
s
.564 .309 .488 r
.27672 .34169 m .28619 .35472 L .31306 .32556 L p F P
0 g
s
.538 .331 .547 r
.28619 .35472 m .27672 .34169 L .25225 .37132 L p F P
0 g
s
.5 .337 .591 r
.26017 .38704 m .25225 .37132 L .22977 .40251 L p F P
0 g
s
.5 .337 .591 r
.22977 .40251 m .23652 .42067 L .26017 .38704 L p F P
0 g
s
.574 .286 .44 r
.36612 .31924 m .35259 .30971 L .32442 .33695 L p F P
0 g
s
.576 .277 .424 r
.31306 .32556 m .32442 .33695 L .35259 .30971 L p F P
0 g
s
.538 .331 .547 r
.25225 .37132 m .26017 .38704 L .28619 .35472 L p F P
0 g
s
.232 .232 .653 r
.24866 .57462 m .24198 .54768 L .22674 .58259 L p F P
0 g
s
.232 .232 .653 r
.22674 .58259 m .23362 .61026 L .24866 .57462 L p F P
0 g
s
.561 .316 .501 r
.32442 .33695 m .31306 .32556 L .28619 .35472 L p F P
0 g
s
.419 .32 .636 r
.25021 .46116 m .24333 .44021 L .22273 .47511 L p F P
0 g
s
.419 .32 .636 r
.22273 .47511 m .22902 .49794 L .25021 .46116 L p F P
0 g
s
.196 .21 .648 r
.25548 .60294 m .24866 .57462 L .23362 .61026 L p F P
0 g
s
.196 .21 .648 r
.23362 .61026 m .24072 .63914 L .25548 .60294 L p F P
0 g
s
.526 .083 .14 r
.56706 .29369 m .54406 .28885 L .51365 .30993 L p F P
0 g
s
.52 .062 .105 r
.49371 .30246 m .51365 .30993 L .54406 .28885 L p F P
0 g
s
.3 0 0 r
.70173 .29277 m .73176 .29631 L .75717 .28367 L p F P
0 g
s
.575 .246 .374 r
.42645 .31133 m .41022 .30296 L .37983 .3298 L p F P
0 g
s
.576 .236 .355 r
.36612 .31924 m .37983 .3298 L .41022 .30296 L p F P
0 g
s
.493 .338 .599 r
.26813 .40414 m .26017 .38704 L .23652 .42067 L p F P
0 g
s
.493 .338 .599 r
.23652 .42067 m .24333 .44021 L .26813 .40414 L p F P
0 g
s
.157 .186 .64 r
.26242 .63265 m .25548 .60294 L .24072 .63914 L p F P
0 g
s
.157 .186 .64 r
.24072 .63914 m .24803 .66921 L .26242 .63265 L p F P
0 g
s
.563 .183 .28 r
.49371 .30246 m .4743 .29569 L .44302 .32057 L p F P
0 g
s
.562 .169 .255 r
.42645 .31133 m .44302 .32057 L .4743 .29569 L p F P
0 g
s
.561 .316 .501 r
.28619 .35472 m .2957 .36903 L .32442 .33695 L p F P
0 g
s
.533 .334 .557 r
.2957 .36903 m .28619 .35472 L .26017 .38704 L p F P
0 g
s
.455 0 0 r
.67284 .28951 m .645 .28654 L .61539 .30483 L p F P
0 g
s
.442 0 0 r
.59082 .29901 m .61539 .30483 L .645 .28654 L p F P
0 g
s
.533 .334 .557 r
.26017 .38704 m .26813 .40414 L .2957 .36903 L p F P
0 g
s
.404 .314 .64 r
.25716 .48355 m .25021 .46116 L .22902 .49794 L p F P
0 g
s
.404 .314 .64 r
.22902 .49794 m .23543 .52213 L .25716 .48355 L p F P
0 g
s
.113 .158 .63 r
.26949 .66377 m .26242 .63265 L .24803 .66921 L p F P
0 g
s
.113 .158 .63 r
.24803 .66921 m .25555 .70047 L .26949 .66377 L p F P
0 g
s
.572 .293 .455 r
.37983 .3298 m .36612 .31924 L .33586 .34952 L p F P
0 g
s
.574 .286 .44 r
.32442 .33695 m .33586 .34952 L .36612 .31924 L p F P
0 g
s
.557 .32 .513 r
.33586 .34952 m .32442 .33695 L .2957 .36903 L p F P
0 g
s
.066 .127 .617 r
.27669 .69628 m .26949 .66377 L .25555 .70047 L p F P
0 g
s
.066 .127 .617 r
.25555 .70047 m .26328 .7329 L .27669 .69628 L p F P
0 g
s
.484 .337 .605 r
.27612 .42265 m .26813 .40414 L .24333 .44021 L p F P
0 g
s
.484 .337 .605 r
.24333 .44021 m .25021 .46116 L .27612 .42265 L p F P
0 g
s
.015 .093 .601 r
.28402 .7302 m .27669 .69628 L .26328 .7329 L p F P
0 g
s
.015 .093 .601 r
.26328 .7329 m .27122 .76649 L .28402 .7302 L p F P
0 g
s
.386 .306 .643 r
.26418 .5074 m .25716 .48355 L .23543 .52213 L p F P
0 g
s
.386 .306 .643 r
.23543 .52213 m .24198 .54768 L .26418 .5074 L p F P
0 g
s
.529 .1 .17 r
.59082 .29901 m .56706 .29369 L .53416 .31811 L p F P
0 g
s
.526 .083 .14 r
.51365 .30993 m .53416 .31811 L .56706 .29369 L p F P
0 g
s
.573 .255 .391 r
.44302 .32057 m .42645 .31133 L .39373 .34143 L p F P
0 g
s
.575 .246 .374 r
.37983 .3298 m .39373 .34143 L .42645 .31133 L p F P
0 g
s
0 .055 .581 r
.29148 .76553 m .28402 .7302 L .27122 .76649 L p F P
0 g
s
0 .055 .581 r
.27122 .76649 m .27936 .80123 L .29148 .76553 L p F P
0 g
s
.557 .32 .513 r
.2957 .36903 m .30525 .38468 L .33586 .34952 L p F P
0 g
s
.527 .336 .565 r
.30525 .38468 m .2957 .36903 L .26813 .40414 L p F P
0 g
s
.527 .336 .565 r
.26813 .40414 m .27612 .42265 L .30525 .38468 L p F P
0 g
s
0 .015 .558 r
.29905 .80227 m .29148 .76553 L .27936 .80123 L p F P
0 g
s
0 .015 .558 r
.27936 .80123 m .28769 .8371 L .29905 .80227 L p F P
0 g
s
.562 .194 .302 r
.51365 .30993 m .49371 .30246 L .45994 .33072 L p F P
0 g
s
.563 .183 .28 r
.44302 .32057 m .45994 .33072 L .49371 .30246 L p F P
0 g
s
0 0 .531 r
.30675 .84043 m .29905 .80227 L .28769 .8371 L p F P
0 g
s
0 0 .531 r
.28769 .8371 m .29622 .87408 L .30675 .84043 L p F P
0 g
s
.366 .296 .645 r
.27127 .53273 m .26418 .5074 L .24198 .54768 L p F P
0 g
s
.366 .296 .645 r
.24198 .54768 m .24866 .57462 L .27127 .53273 L p F P
0 g
s
.473 .334 .611 r
.28415 .44259 m .27612 .42265 L .25021 .46116 L p F P
0 g
s
.473 .334 .611 r
.25021 .46116 m .25716 .48355 L .28415 .44259 L p F P
0 g
s
.464 0 .009 r
.70173 .29277 m .67284 .28951 L .64082 .31118 L p F P
0 g
s
.455 0 0 r
.61539 .30483 m .64082 .31118 L .67284 .28951 L p F P
0 g
s
.572 .293 .455 r
.33586 .34952 m .3474 .36332 L .37983 .3298 L p F P
0 g
s
.552 .324 .523 r
.3474 .36332 m .33586 .34952 L .30525 .38468 L p F P
0 g
s
.568 .298 .467 r
.39373 .34143 m .37983 .3298 L .3474 .36332 L p F P
0 g
s
.345 .284 .645 r
.27842 .55956 m .27127 .53273 L .24866 .57462 L p F P
0 g
s
.345 .284 .645 r
.24866 .57462 m .25548 .60294 L .27842 .55956 L p F P
0 g
s
.52 .337 .573 r
.31485 .40168 m .30525 .38468 L .27612 .42265 L p F P
0 g
s
.52 .337 .573 r
.27612 .42265 m .28415 .44259 L .31485 .40168 L p F P
0 g
s
.552 .324 .523 r
.30525 .38468 m .31485 .40168 L .3474 .36332 L p F P
0 g
s
.461 .331 .616 r
.29222 .464 m .28415 .44259 L .25716 .48355 L p F P
0 g
s
.461 .331 .616 r
.25716 .48355 m .26418 .5074 L .29222 .464 L p F P
0 g
s
.57 .261 .406 r
.45994 .33072 m .44302 .32057 L .40785 .35417 L p F P
0 g
s
.573 .255 .391 r
.39373 .34143 m .40785 .35417 L .44302 .32057 L p F P
0 g
s
.531 .115 .197 r
.61539 .30483 m .59082 .29901 L .55528 .32705 L p F P
0 g
s
.529 .1 .17 r
.53416 .31811 m .55528 .32705 L .59082 .29901 L p F P
0 g
s
.321 .271 .645 r
.28565 .58792 m .27842 .55956 L .25548 .60294 L p F P
0 g
s
.321 .271 .645 r
.25548 .60294 m .26242 .63265 L .28565 .58792 L p F P
0 g
s
.56 .204 .321 r
.53416 .31811 m .51365 .30993 L .47725 .34183 L p F P
0 g
s
.562 .194 .302 r
.45994 .33072 m .47725 .34183 L .51365 .30993 L p F P
0 g
s
.568 .298 .467 r
.3474 .36332 m .35906 .37838 L .39373 .34143 L p F P
0 g
s
.546 .325 .531 r
.35906 .37838 m .3474 .36332 L .31485 .40168 L p F P
0 g
s
.563 .302 .478 r
.40785 .35417 m .39373 .34143 L .35906 .37838 L p F P
0 g
s
.471 0 .043 r
.73176 .29631 m .70173 .29277 L .6672 .31808 L p F P
0 g
s
.464 0 .009 r
.64082 .31118 m .6672 .31808 L .70173 .29277 L p F P
0 g
s
.512 .336 .579 r
.32451 .42009 m .31485 .40168 L .28415 .44259 L p F P
0 g
s
.512 .336 .579 r
.28415 .44259 m .29222 .464 L .32451 .42009 L p F P
0 g
s
.448 .325 .62 r
.30034 .48691 m .29222 .464 L .26418 .5074 L p F P
0 g
s
.448 .325 .62 r
.26418 .5074 m .27127 .53273 L .30034 .48691 L p F P
0 g
s
.295 .255 .643 r
.29295 .61783 m .28565 .58792 L .26242 .63265 L p F P
0 g
s
.295 .255 .643 r
.26242 .63265 m .26949 .66377 L .29295 .61783 L p F P
0 g
s
.546 .325 .531 r
.31485 .40168 m .32451 .42009 L .35906 .37838 L p F P
0 g
s
.566 .266 .419 r
.47725 .34183 m .45994 .33072 L .42221 .36806 L p F P
0 g
s
.57 .261 .406 r
.40785 .35417 m .42221 .36806 L .45994 .33072 L p F P
0 g
s
.268 .238 .639 r
.30032 .64931 m .29295 .61783 L .26949 .66377 L p F P
0 g
s
.268 .238 .639 r
.26949 .66377 m .27669 .69628 L .30032 .64931 L p F P
0 g
s
.434 .319 .623 r
.3085 .51137 m .30034 .48691 L .27127 .53273 L p F P
0 g
s
.434 .319 .623 r
.27127 .53273 m .27842 .55956 L .3085 .51137 L p F P
0 g
s
.563 .302 .478 r
.35906 .37838 m .37083 .39475 L .40785 .35417 L p F P
0 g
s
.539 .326 .539 r
.37083 .39475 m .35906 .37838 L .32451 .42009 L p F P
0 g
s
.531 .127 .22 r
.64082 .31118 m .61539 .30483 L .57706 .33678 L p F P
0 g
s
.531 .115 .197 r
.55528 .32705 m .57706 .33678 L .61539 .30483 L p F P
0 g
s
.502 .333 .585 r
.33422 .43994 m .32451 .42009 L .29222 .464 L p F P
0 g
s
.502 .333 .585 r
.29222 .464 m .30034 .48691 L .33422 .43994 L p F P
0 g
s
.557 .304 .488 r
.42221 .36806 m .40785 .35417 L .37083 .39475 L p F P
0 g
s
.558 .211 .337 r
.55528 .32705 m .53416 .31811 L .49498 .35394 L p F P
0 g
s
.56 .204 .321 r
.47725 .34183 m .49498 .35394 L .53416 .31811 L p F P
0 g
s
.238 .219 .635 r
.30776 .6824 m .30032 .64931 L .27669 .69628 L p F P
0 g
s
.238 .219 .635 r
.27669 .69628 m .28402 .7302 L .30776 .6824 L p F P
0 g
s
.539 .326 .539 r
.32451 .42009 m .33422 .43994 L .37083 .39475 L p F P
0 g
s
.471 0 .043 r
.6672 .31808 m .69458 .32557 L .73176 .29631 L p F P
0 g
s
.418 .311 .625 r
.31671 .5374 m .3085 .51137 L .27842 .55956 L p F P
0 g
s
.418 .311 .625 r
.27842 .55956 m .28565 .58792 L .31671 .5374 L p F P
0 g
s
.206 .198 .629 r
.31527 .7171 m .30776 .6824 L .28402 .7302 L p F P
0 g
s
.206 .198 .629 r
.28402 .7302 m .29148 .76553 L .31527 .7171 L p F P
0 g
s
.492 .33 .589 r
.344 .46128 m .33422 .43994 L .30034 .48691 L p F P
0 g
s
.492 .33 .589 r
.30034 .48691 m .3085 .51137 L .344 .46128 L p F P
0 g
s
.561 .27 .43 r
.49498 .35394 m .47725 .34183 L .43681 .38316 L p F P
0 g
s
.566 .266 .419 r
.42221 .36806 m .43681 .38316 L .47725 .34183 L p F P
0 g
s
.557 .304 .488 r
.37083 .39475 m .38273 .41247 L .42221 .36806 L p F P
0 g
s
.531 .325 .546 r
.38273 .41247 m .37083 .39475 L .33422 .43994 L p F P
0 g
s
.172 .176 .621 r
.32286 .75346 m .31527 .7171 L .29148 .76553 L p F P
0 g
s
.172 .176 .621 r
.29148 .76553 m .29905 .80227 L .32286 .75346 L p F P
0 g
s
.551 .305 .496 r
.43681 .38316 m .42221 .36806 L .38273 .41247 L p F P
0 g
s
.531 .325 .546 r
.33422 .43994 m .344 .46128 L .38273 .41247 L p F P
0 g
s
.531 .138 .241 r
.6672 .31808 m .64082 .31118 L .59956 .34735 L p F P
0 g
s
.531 .127 .22 r
.57706 .33678 m .59956 .34735 L .64082 .31118 L p F P
0 g
s
.402 .302 .626 r
.32497 .56505 m .31671 .5374 L .28565 .58792 L p F P
0 g
s
.402 .302 .626 r
.28565 .58792 m .29295 .61783 L .32497 .56505 L p F P
0 g
s
.554 .217 .352 r
.57706 .33678 m .55528 .32705 L .51317 .36709 L p F P
0 g
s
.558 .211 .337 r
.49498 .35394 m .51317 .36709 L .55528 .32705 L p F P
0 g
s
.136 .151 .611 r
.33052 .79148 m .32286 .75346 L .29905 .80227 L p F P
0 g
s
.136 .151 .611 r
.29905 .80227 m .30675 .84043 L .33052 .79148 L p F P
0 g
s
.481 .326 .593 r
.35386 .48415 m .344 .46128 L .3085 .51137 L p F P
0 g
s
.481 .326 .593 r
.3085 .51137 m .31671 .5374 L .35386 .48415 L p F P
0 g
s
.384 .292 .627 r
.33328 .59437 m .32497 .56505 L .29295 .61783 L p F P
0 g
s
.384 .292 .627 r
.29295 .61783 m .30032 .64931 L .33328 .59437 L p F P
0 g
s
.551 .305 .496 r
.38273 .41247 m .39478 .4316 L .43681 .38316 L p F P
0 g
s
.523 .324 .551 r
.39478 .4316 m .38273 .41247 L .344 .46128 L p F P
0 g
s
.555 .272 .44 r
.51317 .36709 m .49498 .35394 L .4517 .39951 L p F P
0 g
s
.561 .27 .43 r
.43681 .38316 m .4517 .39951 L .49498 .35394 L p F P
0 g
s
.523 .324 .551 r
.344 .46128 m .35386 .48415 L .39478 .4316 L p F P
0 g
s
.544 .305 .504 r
.4517 .39951 m .43681 .38316 L .39478 .4316 L p F P
0 g
s
.469 .321 .596 r
.36379 .50862 m .35386 .48415 L .31671 .5374 L p F P
0 g
s
.469 .321 .596 r
.31671 .5374 m .32497 .56505 L .36379 .50862 L p F P
0 g
s
.365 .28 .626 r
.34165 .62539 m .33328 .59437 L .30032 .64931 L p F P
0 g
s
.365 .28 .626 r
.30032 .64931 m .30776 .6824 L .34165 .62539 L p F P
0 g
s
.53 .147 .259 r
.69458 .32557 m .6672 .31808 L .62283 .35879 L p F P
0 g
s
.531 .138 .241 r
.59956 .34735 m .62283 .35879 L .6672 .31808 L p F P
0 g
s
.55 .222 .365 r
.59956 .34735 m .57706 .33678 L .53185 .38133 L p F P
0 g
s
.554 .217 .352 r
.51317 .36709 m .53185 .38133 L .57706 .33678 L p F P
0 g
s
.544 .305 .504 r
.39478 .4316 m .40698 .45219 L .4517 .39951 L p F P
0 g
s
.514 .321 .556 r
.40698 .45219 m .39478 .4316 L .35386 .48415 L p F P
0 g
s
.514 .321 .556 r
.35386 .48415 m .36379 .50862 L .40698 .45219 L p F P
0 g
s
.345 .268 .625 r
.35007 .65815 m .34165 .62539 L .30776 .6824 L p F P
0 g
s
.345 .268 .625 r
.30776 .6824 m .31527 .7171 L .35007 .65815 L p F P
0 g
s
.456 .314 .599 r
.37381 .53473 m .36379 .50862 L .32497 .56505 L p F P
0 g
s
.456 .314 .599 r
.32497 .56505 m .33328 .59437 L .37381 .53473 L p F P
0 g
s
.549 .273 .449 r
.53185 .38133 m .51317 .36709 L .46688 .41717 L p F P
0 g
s
.555 .272 .44 r
.4517 .39951 m .46688 .41717 L .51317 .36709 L p F P
0 g
s
.537 .304 .51 r
.46688 .41717 m .4517 .39951 L .40698 .45219 L p F P
0 g
s
.324 .255 .623 r
.35856 .69272 m .35007 .65815 L .31527 .7171 L p F P
0 g
s
.324 .255 .623 r
.31527 .7171 m .32286 .75346 L .35856 .69272 L p F P
0 g
s
.53 .147 .259 r
.62283 .35879 m .64693 .37116 L .69458 .32557 L p F P
0 g
s
.546 .226 .377 r
.62283 .35879 m .59956 .34735 L .55106 .39672 L p F P
0 g
s
.55 .222 .365 r
.53185 .38133 m .55106 .39672 L .59956 .34735 L p F P
0 g
s
.505 .318 .561 r
.41936 .4743 m .40698 .45219 L .36379 .50862 L p F P
0 g
s
.505 .318 .561 r
.36379 .50862 m .37381 .53473 L .41936 .4743 L p F P
0 g
s
.537 .304 .51 r
.40698 .45219 m .41936 .4743 L .46688 .41717 L p F P
0 g
s
.443 .307 .601 r
.38392 .56254 m .37381 .53473 L .33328 .59437 L p F P
0 g
s
.443 .307 .601 r
.33328 .59437 m .34165 .62539 L .38392 .56254 L p F P
0 g
s
.301 .24 .62 r
.36711 .72913 m .35856 .69272 L .32286 .75346 L p F P
0 g
s
.301 .24 .62 r
.32286 .75346 m .33052 .79148 L .36711 .72913 L p F P
0 g
s
.543 .274 .457 r
.55106 .39672 m .53185 .38133 L .48239 .4362 L p F P
0 g
s
.549 .273 .449 r
.46688 .41717 m .48239 .4362 L .53185 .38133 L p F P
0 g
s
.529 .303 .516 r
.48239 .4362 m .46688 .41717 L .41936 .4743 L p F P
0 g
s
.429 .3 .602 r
.39413 .59211 m .38392 .56254 L .34165 .62539 L p F P
0 g
s
.429 .3 .602 r
.34165 .62539 m .35007 .65815 L .39413 .59211 L p F P
0 g
s
.495 .314 .564 r
.43192 .49799 m .41936 .4743 L .37381 .53473 L p F P
0 g
s
.495 .314 .564 r
.37381 .53473 m .38392 .56254 L .43192 .49799 L p F P
0 g
s
.529 .303 .516 r
.41936 .4743 m .43192 .49799 L .48239 .4362 L p F P
0 g
s
.541 .229 .387 r
.64693 .37116 m .62283 .35879 L .57085 .41333 L p F P
0 g
s
.546 .226 .377 r
.55106 .39672 m .57085 .41333 L .62283 .35879 L p F P
0 g
s
.415 .291 .603 r
.40445 .62351 m .39413 .59211 L .35007 .65815 L p F P
0 g
s
.415 .291 .603 r
.35007 .65815 m .35856 .69272 L .40445 .62351 L p F P
0 g
s
.521 .301 .521 r
.49825 .45667 m .48239 .4362 L .43192 .49799 L p F P
0 g
s
.543 .274 .457 r
.48239 .4362 m .49825 .45667 L .55106 .39672 L p F P
0 g
s
.537 .274 .464 r
.57085 .41333 m .55106 .39672 L .49825 .45667 L p F P
0 g
s
.484 .309 .567 r
.44468 .52334 m .43192 .49799 L .38392 .56254 L p F P
0 g
s
.484 .309 .567 r
.38392 .56254 m .39413 .59211 L .44468 .52334 L p F P
0 g
s
.521 .301 .521 r
.43192 .49799 m .44468 .52334 L .49825 .45667 L p F P
0 g
s
.4 .282 .603 r
.41488 .65681 m .40445 .62351 L .35856 .69272 L p F P
0 g
s
.4 .282 .603 r
.35856 .69272 m .36711 .72913 L .41488 .65681 L p F P
0 g
s
.541 .229 .387 r
.57085 .41333 m .59127 .43121 L .64693 .37116 L p F P
0 g
s
.474 .304 .57 r
.45766 .55041 m .44468 .52334 L .39413 .59211 L p F P
0 g
s
.474 .304 .57 r
.39413 .59211 m .40445 .62351 L .45766 .55041 L p F P
0 g
s
.513 .298 .525 r
.5145 .47865 m .49825 .45667 L .44468 .52334 L p F P
0 g
s
.537 .274 .464 r
.49825 .45667 m .5145 .47865 L .57085 .41333 L p F P
0 g
s
.53 .273 .471 r
.59127 .43121 m .57085 .41333 L .5145 .47865 L p F P
0 g
s
.513 .298 .525 r
.44468 .52334 m .45766 .55041 L .5145 .47865 L p F P
0 g
s
.463 .298 .572 r
.47088 .5793 m .45766 .55041 L .40445 .62351 L p F P
0 g
s
.463 .298 .572 r
.40445 .62351 m .41488 .65681 L .47088 .5793 L p F P
0 g
s
.504 .295 .529 r
.53116 .50222 m .5145 .47865 L .45766 .55041 L p F P
0 g
s
.53 .273 .471 r
.5145 .47865 m .53116 .50222 L .59127 .43121 L p F P
0 g
s
.504 .295 .529 r
.45766 .55041 m .47088 .5793 L .53116 .50222 L p F P
0 g
s
.25 Mabswid
.67289 0 m
.92709 .4142 L
s
.92709 .4142 m
1 .94791 L
s
1 .94791 m
.70699 .5859 L
s
.70699 .5859 m
.67289 0 L
s
.08839 .24566 m
0 .80425 L
s
0 .80425 m
.70699 .5859 L
s
.70699 .5859 m
.67289 0 L
s
.67289 0 m
.08839 .24566 L
s
.08839 .24566 m
.67289 0 L
s
.11815 .23315 m
.1232 .23841 L
s
[(0)] .10806 .22264 .95983 1 Mshowa
.30713 .15372 m
.3118 .15932 L
s
[(0.5)] .2978 .14253 .83328 1 Mshowa
.51161 .06778 m
.51581 .07373 L
s
[(1)] .5032 .05588 .70672 1 Mshowa
.125 Mabswid
.15479 .21775 m
.15778 .22094 L
s
.192 .20211 m
.19494 .20535 L
s
.22978 .18623 m
.23268 .18951 L
s
.26815 .17011 m
.271 .17342 L
s
.34673 .13708 m
.34948 .14048 L
s
.38696 .12017 m
.38965 .12362 L
s
.42784 .10299 m
.43048 .10648 L
s
.46938 .08553 m
.47197 .08906 L
s
.55453 .04974 m
.557 .05336 L
s
.59817 .0314 m
.60057 .03506 L
s
.64255 .01275 m
.64488 .01645 L
s
.25 Mabswid
0 .80425 m
.39963 1.08549 L
s
.02771 .82375 m
.02878 .81654 L
s
[(0)] .02556 .83816 .14903 -1 Mshowa
.182 .93234 m
.18272 .92509 L
s
[(0.5)] .18056 .94684 .09966 -1 Mshowa
.31445 1.02555 m
.31489 1.01828 L
s
[(1)] .31358 1.0401 .05969 -1 Mshowa
.125 Mabswid
.06057 .84688 m
.06117 .84255 L
s
.09238 .86926 m
.09294 .86493 L
s
.12319 .89095 m
.12371 .88661 L
s
.15305 .91196 m
.15352 .90762 L
s
.21008 .9521 m
.21048 .94774 L
s
.23733 .97127 m
.23769 .96692 L
s
.26379 .98989 m
.26411 .98553 L
s
.28948 1.00798 m
.28978 1.00362 L
s
.33872 1.04263 m
.33895 1.03827 L
s
.36233 1.05924 m
.36253 1.05488 L
s
.38529 1.0754 m
.38546 1.07103 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.44.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.44.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ListSurfaceOfRevolution[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["point",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["point",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "generate the surface of revolution of a curve specified by points",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ListSurfaceOfRevolution[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["point",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["point",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["theta", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["thetamax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "generate the surface of revolution over a given range for the angle of \
revolution",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.44.1"],

Cell["Surfaces of revolution from a list of data points.", "Caption",
 CellTags->"S5.44.1"],

Cell[TextData[{
 "We can also generate a surface of revolution from a curve specified by a \
list of data points. The points can lie in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " plane or in three\[Hyphen]dimensional space. "
}], "Text",
 CellTags->{"S5.44.1", "1.9"}],

Cell[TextData[{
 "Here is a list of data in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " plane."
}], "MathCaption",
 CellTags->{"S5.44.1", "1.10"}],

Cell["dat = Table[{n, n^3}, {n, 0, 1, .1}];", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.44.1"],

Cell[TextData[{
 "This gives the surface of revolution of ",
 StyleBox["dat", "MR"],
 " about the axis connecting the origin to point ",
 StyleBox["{1,", "MR"],
 " ",
 StyleBox["-1,", "MR"],
 " ",
 StyleBox["1}", "MR"],
 " ."
}], "MathCaption",
 CellTags->{"S5.44.1", "1.11"}],

Cell[CellGroupData[{

Cell["\<\
ListSurfaceOfRevolution[dat, {t, 0, Pi/2},
        RevolutionAxis -> {1, -1, 1},
        PlotRange -> All]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.44.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.28773 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.144129 1.30708 1.71846e-17 1.30708 [
[.3364 1.30047 -3.10038 0 ]
[.3364 1.30047 2.89962 9 ]
[.48836 1.26374 -12.0492 0 ]
[.48836 1.26374 11.9508 9 ]
[.64666 1.22546 -8.75759 0 ]
[.64666 1.22546 9.24241 9 ]
[.81172 1.18553 -11.2825 0 ]
[.81172 1.18553 12.7175 9 ]
[.98396 1.14385 -2.71608 0 ]
[.98396 1.14385 3.28392 9 ]
[.03709 1.09317 -13.1419 0 ]
[.03709 1.09317 10.8581 9 ]
[.12348 1.15722 -12.9211 0 ]
[.12348 1.15722 11.0789 9 ]
[.20452 1.2173 -12.7191 0 ]
[.20452 1.2173 11.2809 9 ]
[.28069 1.27378 -3.13338 0 ]
[.28069 1.27378 2.86662 9 ]
[.06628 .26741 -6 -2.7267 ]
[.06628 .26741 0 6.2733 ]
[.0395 .52386 -18 -2.88218 ]
[.0395 .52386 0 6.11782 ]
[.00918 .8143 -6 -3.05969 ]
[.00918 .8143 0 5.94031 ]
[ 0 0 0 0 ]
[ 1 1.28773 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.32213 1.28773 m
1 1.12332 L
s
.33695 1.28414 m
.33722 1.27598 L
s
[(0)] .3364 1.30047 .03346 -1 Mshowa
.48842 1.2474 m
.48846 1.23923 L
s
[(0.25)] .48836 1.26374 .0041 -1 Mshowa
.64622 1.20913 m
.646 1.20096 L
s
[(0.5)] .64666 1.22546 -0.02693 -1 Mshowa
.81074 1.16922 m
.81025 1.16107 L
s
[(0.75)] .81172 1.18553 -0.05979 -1 Mshowa
.98242 1.12758 m
.98165 1.11945 L
s
[(1)] .98396 1.14385 -0.09464 -1 Mshowa
.125 Mabswid
.36676 1.27691 m
.36689 1.27201 L
s
.3968 1.26962 m
.39691 1.26472 L
s
.4271 1.26227 m
.42718 1.25737 L
s
.45764 1.25487 m
.45769 1.24997 L
s
.51947 1.23987 m
.51946 1.23497 L
s
.55076 1.23228 m
.55072 1.22738 L
s
.58232 1.22463 m
.58225 1.21972 L
s
.61414 1.21691 m
.61404 1.21201 L
s
.67857 1.20128 m
.67841 1.19638 L
s
.7112 1.19337 m
.711 1.18847 L
s
.7441 1.18539 m
.74387 1.18049 L
s
.77728 1.17734 m
.77702 1.17244 L
s
.84449 1.16104 m
.84416 1.15615 L
s
.87853 1.15278 m
.87817 1.14789 L
s
.91286 1.14445 m
.91247 1.13957 L
s
.94749 1.13605 m
.94706 1.13117 L
s
.25 Mabswid
0 1.04816 m
.32213 1.28773 L
s
.03864 1.0769 m
.03941 1.06877 L
s
[(-0.6)] .03709 1.09317 .09516 -1 Mshowa
.12473 1.14093 m
.12536 1.13278 L
s
[(-0.4)] .12348 1.15722 .07676 -1 Mshowa
.2055 1.20099 m
.20599 1.19284 L
s
[(-0.2)] .20452 1.2173 .05993 -1 Mshowa
.28142 1.25746 m
.28178 1.24929 L
s
[(0)] .28069 1.27378 .04446 -1 Mshowa
.125 Mabswid
.06069 1.0933 m
.06113 1.08842 L
s
.08238 1.10943 m
.0828 1.10455 L
s
.10373 1.12531 m
.10413 1.12042 L
s
.1454 1.1563 m
.14576 1.15141 L
s
.16575 1.17143 m
.16608 1.16654 L
s
.18578 1.18633 m
.18609 1.18144 L
s
.22492 1.21543 m
.22519 1.21054 L
s
.24404 1.22966 m
.24429 1.22476 L
s
.26287 1.24366 m
.26311 1.23876 L
s
.01622 1.06023 m
.01671 1.05535 L
s
.29969 1.27105 m
.29989 1.26615 L
s
.3177 1.28443 m
.31788 1.27954 L
s
.25 Mabswid
.08315 .24536 m
0 1.04816 L
s
.08148 .26142 m
.08908 .25842 L
s
[(0)] .06628 .26741 1 -0.39407 Mshowa
.05487 .51833 m
.06256 .51557 L
s
[(0.5)] .0395 .52386 1 -0.35951 Mshowa
.02474 .80932 m
.03252 .80683 L
s
[(1)] .00918 .8143 1 -0.32007 Mshowa
.125 Mabswid
.07641 .31036 m
.08098 .30859 L
s
.07122 .36049 m
.0758 .35874 L
s
.06591 .41183 m
.0705 .41011 L
s
.06046 .46443 m
.06506 .46274 L
s
.04915 .5736 m
.05377 .57197 L
s
.04328 .63028 m
.04791 .62868 L
s
.03726 .68842 m
.0419 .68685 L
s
.03108 .74808 m
.03574 .74655 L
s
.01822 .87221 m
.0229 .87076 L
s
.01153 .93682 m
.01622 .9354 L
s
.00466 1.0032 m
.00936 1.00182 L
s
.25 Mabswid
.08315 .24536 m
0 1.04816 L
s
0 1.04816 m
.32213 1.28773 L
s
.32213 1.28773 m
.34963 .53042 L
s
.34963 .53042 m
.08315 .24536 L
s
.7024 0 m
.92242 .33359 L
s
.92242 .33359 m
1 1.12332 L
s
1 1.12332 m
.744 .83431 L
s
.744 .83431 m
.7024 0 L
s
.08315 .24536 m
0 1.04816 L
s
0 1.04816 m
.744 .83431 L
s
.744 .83431 m
.7024 0 L
s
.7024 0 m
.08315 .24536 L
s
.34963 .53042 m
.92242 .33359 L
s
.92242 .33359 m
1 1.12332 L
s
1 1.12332 m
.32213 1.28773 L
s
.32213 1.28773 m
.34963 .53042 L
s
0 0 m
1 0 L
1 1.28773 L
0 1.28773 L
closepath
clip
newpath
.5 Mabswid
.691 .47 .582 r
.32753 .50483 m .35525 .54774 L .35026 .54986 L closepath p F P
0 g
s
.679 .467 .591 r
.32753 .50483 m .35998 .54507 L .35525 .54774 L closepath p F P
0 g
s
.669 .466 .6 r
.32753 .50483 m .36437 .54187 L .35998 .54507 L closepath p F P
0 g
s
.66 .466 .611 r
.32753 .50483 m .36837 .5382 L .36437 .54187 L closepath p F P
0 g
s
.652 .468 .622 r
.32753 .50483 m .37195 .53408 L .36837 .5382 L closepath p F P
0 g
s
.645 .472 .634 r
.32753 .50483 m .37504 .52959 L .37195 .53408 L closepath p F P
0 g
s
.639 .477 .647 r
.32753 .50483 m .37761 .52477 L .37504 .52959 L closepath p F P
0 g
s
.635 .483 .659 r
.32753 .50483 m .37964 .51968 L .37761 .52477 L closepath p F P
0 g
s
.632 .491 .672 r
.32753 .50483 m .38109 .51439 L .37964 .51968 L closepath p F P
0 g
s
.63 .499 .685 r
.32753 .50483 m .38195 .50897 L .38109 .51439 L closepath p F P
0 g
s
.629 .509 .698 r
.32753 .50483 m .38221 .50347 L .38195 .50897 L closepath p F P
0 g
s
.629 .52 .711 r
.32753 .50483 m .38186 .49797 L .38221 .50347 L closepath p F P
0 g
s
.63 .532 .724 r
.32753 .50483 m .38091 .49254 L .38186 .49797 L closepath p F P
0 g
s
.633 .544 .736 r
.32753 .50483 m .37937 .48725 L .38091 .49254 L closepath p F P
0 g
s
.619 .498 .694 r
.43588 .5155 m .38195 .50897 L .38221 .50347 L p F P
0 g
s
.619 .498 .694 r
.38221 .50347 m .43668 .5046 L .43588 .5155 L p F P
0 g
s
.619 .51 .707 r
.43668 .5046 m .38221 .50347 L .38186 .49797 L p F P
0 g
s
.62 .488 .679 r
.4339 .52622 m .38109 .51439 L .38195 .50897 L p F P
0 g
s
.62 .488 .679 r
.38195 .50897 m .43588 .5155 L .4339 .52622 L p F P
0 g
s
.619 .51 .707 r
.38186 .49797 m .43627 .49367 L .43668 .5046 L p F P
0 g
s
.62 .522 .721 r
.43627 .49367 m .38186 .49797 L .38091 .49254 L p F P
0 g
s
.623 .479 .665 r
.43075 .53665 m .37964 .51968 L .38109 .51439 L p F P
0 g
s
.623 .479 .665 r
.38109 .51439 m .4339 .52622 L .43075 .53665 L p F P
0 g
s
.62 .522 .721 r
.38091 .49254 m .43467 .48284 L .43627 .49367 L p F P
0 g
s
.623 .535 .734 r
.43467 .48284 m .38091 .49254 L .37937 .48725 L p F P
0 g
s
.626 .471 .652 r
.42648 .54665 m .37761 .52477 L .37964 .51968 L p F P
0 g
s
.626 .471 .652 r
.37964 .51968 m .43075 .53665 L .42648 .54665 L p F P
0 g
s
.623 .535 .734 r
.37937 .48725 m .4319 .47225 L .43467 .48284 L p F P
0 g
s
.631 .464 .638 r
.42113 .55609 m .37504 .52959 L .37761 .52477 L p F P
0 g
s
.631 .464 .638 r
.37761 .52477 m .42648 .54665 L .42113 .55609 L p F P
0 g
s
.638 .459 .625 r
.41477 .56486 m .37195 .53408 L .37504 .52959 L p F P
0 g
s
.638 .459 .625 r
.37504 .52959 m .42113 .55609 L .41477 .56486 L p F P
0 g
s
.645 .455 .612 r
.40748 .57285 m .36837 .5382 L .37195 .53408 L p F P
0 g
s
.645 .455 .612 r
.37195 .53408 m .41477 .56486 L .40748 .57285 L p F P
0 g
s
.654 .453 .6 r
.39934 .57996 m .36437 .54187 L .36837 .5382 L p F P
0 g
s
.654 .453 .6 r
.36837 .5382 m .40748 .57285 L .39934 .57996 L p F P
0 g
s
.664 .453 .588 r
.39046 .58611 m .35998 .54507 L .36437 .54187 L p F P
0 g
s
.664 .453 .588 r
.36437 .54187 m .39934 .57996 L .39046 .58611 L p F P
0 g
s
.675 .455 .578 r
.38095 .5912 m .35525 .54774 L .35998 .54507 L p F P
0 g
s
.675 .455 .578 r
.35998 .54507 m .39046 .58611 L .38095 .5912 L p F P
0 g
s
.688 .458 .569 r
.37092 .59518 m .35026 .54986 L .35525 .54774 L p F P
0 g
s
.688 .458 .569 r
.35525 .54774 m .38095 .5912 L .37092 .59518 L p F P
0 g
s
.599 .476 .683 r
.48821 .52685 m .43588 .5155 L .43668 .5046 L p F P
0 g
s
.599 .476 .683 r
.43668 .5046 m .49011 .51081 L .48821 .52685 L p F P
0 g
s
.599 .488 .699 r
.49011 .51081 m .43668 .5046 L .43627 .49367 L p F P
0 g
s
.599 .488 .699 r
.43627 .49367 m .49024 .49464 L .49011 .51081 L p F P
0 g
s
.6 .502 .715 r
.49024 .49464 m .43627 .49367 L .43467 .48284 L p F P
0 g
s
.601 .464 .667 r
.48458 .54256 m .4339 .52622 L .43588 .5155 L p F P
0 g
s
.601 .464 .667 r
.43588 .5155 m .48821 .52685 L .48458 .54256 L p F P
0 g
s
.6 .502 .715 r
.43467 .48284 m .48861 .47854 L .49024 .49464 L p F P
0 g
s
.602 .517 .73 r
.48861 .47854 m .43467 .48284 L .4319 .47225 L p F P
0 g
s
.604 .454 .651 r
.47925 .55775 m .43075 .53665 L .4339 .52622 L p F P
0 g
s
.604 .454 .651 r
.4339 .52622 m .48458 .54256 L .47925 .55775 L p F P
0 g
s
.602 .517 .73 r
.4319 .47225 m .48523 .46269 L .48861 .47854 L p F P
0 g
s
.609 .446 .635 r
.47229 .57224 m .42648 .54665 L .43075 .53665 L p F P
0 g
s
.609 .446 .635 r
.43075 .53665 m .47925 .55775 L .47229 .57224 L p F P
0 g
s
.615 .439 .62 r
.46377 .58584 m .42113 .55609 L .42648 .54665 L p F P
0 g
s
.615 .439 .62 r
.42648 .54665 m .47229 .57224 L .46377 .58584 L p F P
0 g
s
.623 .433 .605 r
.45381 .59839 m .41477 .56486 L .42113 .55609 L p F P
0 g
s
.623 .433 .605 r
.42113 .55609 m .46377 .58584 L .45381 .59839 L p F P
0 g
s
.632 .429 .59 r
.44252 .60973 m .40748 .57285 L .41477 .56486 L p F P
0 g
s
.632 .429 .59 r
.41477 .56486 m .45381 .59839 L .44252 .60973 L p F P
0 g
s
.643 .428 .576 r
.43003 .61971 m .39934 .57996 L .40748 .57285 L p F P
0 g
s
.643 .428 .576 r
.40748 .57285 m .44252 .60973 L .43003 .61971 L p F P
0 g
s
.654 .428 .563 r
.4165 .62822 m .39046 .58611 L .39934 .57996 L p F P
0 g
s
.654 .428 .563 r
.39934 .57996 m .43003 .61971 L .4165 .62822 L p F P
0 g
s
.667 .43 .551 r
.40209 .63515 m .38095 .5912 L .39046 .58611 L p F P
0 g
s
.667 .43 .551 r
.39046 .58611 m .4165 .62822 L .40209 .63515 L p F P
0 g
s
.681 .434 .541 r
.38698 .64039 m .37092 .59518 L .38095 .5912 L p F P
0 g
s
.681 .434 .541 r
.38095 .5912 m .40209 .63515 L .38698 .64039 L p F P
0 g
s
.571 .441 .665 r
.53795 .54562 m .48821 .52685 L .49011 .51081 L p F P
0 g
s
.571 .441 .665 r
.49011 .51081 m .5418 .52485 L .53795 .54562 L p F P
0 g
s
.57 .455 .684 r
.5418 .52485 m .49011 .51081 L .49024 .49464 L p F P
0 g
s
.57 .455 .684 r
.49024 .49464 m .54337 .50375 L .5418 .52485 L p F P
0 g
s
.57 .471 .702 r
.54337 .50375 m .49024 .49464 L .48861 .47854 L p F P
0 g
s
.574 .428 .646 r
.53185 .56582 m .48458 .54256 L .48821 .52685 L p F P
0 g
s
.574 .428 .646 r
.48821 .52685 m .53795 .54562 L .53185 .56582 L p F P
0 g
s
.57 .471 .702 r
.48861 .47854 m .54263 .48258 L .54337 .50375 L p F P
0 g
s
.572 .487 .721 r
.54263 .48258 m .48861 .47854 L .48523 .46269 L p F P
0 g
s
.578 .417 .627 r
.52359 .58519 m .47925 .55775 L .48458 .54256 L p F P
0 g
s
.578 .417 .627 r
.48458 .54256 m .53185 .56582 L .52359 .58519 L p F P
0 g
s
.572 .487 .721 r
.48523 .46269 m .5396 .46159 L .54263 .48258 L p F P
0 g
s
.585 .408 .608 r
.51326 .6035 m .47229 .57224 L .47925 .55775 L p F P
0 g
s
.585 .408 .608 r
.47925 .55775 m .52359 .58519 L .51326 .6035 L p F P
0 g
s
.593 .4 .59 r
.50097 .62054 m .46377 .58584 L .47229 .57224 L p F P
0 g
s
.593 .4 .59 r
.47229 .57224 m .51326 .6035 L .50097 .62054 L p F P
0 g
s
.602 .394 .572 r
.48688 .63607 m .45381 .59839 L .46377 .58584 L p F P
0 g
s
.602 .394 .572 r
.46377 .58584 m .50097 .62054 L .48688 .63607 L p F P
0 g
s
.613 .39 .554 r
.47115 .64992 m .44252 .60973 L .45381 .59839 L p F P
0 g
s
.613 .39 .554 r
.45381 .59839 m .48688 .63607 L .47115 .64992 L p F P
0 g
s
.626 .389 .538 r
.45396 .6619 m .43003 .61971 L .44252 .60973 L p F P
0 g
s
.626 .389 .538 r
.44252 .60973 m .47115 .64992 L .45396 .6619 L p F P
0 g
s
.641 .39 .523 r
.43553 .67187 m .4165 .62822 L .43003 .61971 L p F P
0 g
s
.641 .39 .523 r
.43003 .61971 m .45396 .6619 L .43553 .67187 L p F P
0 g
s
.657 .393 .509 r
.41607 .67968 m .40209 .63515 L .4165 .62822 L p F P
0 g
s
.657 .393 .509 r
.4165 .62822 m .43553 .67187 L .41607 .67968 L p F P
0 g
s
.674 .399 .496 r
.39583 .68524 m .38698 .64039 L .40209 .63515 L p F P
0 g
s
.674 .399 .496 r
.40209 .63515 m .41607 .67968 L .39583 .68524 L p F P
0 g
s
.536 .411 .657 r
.59115 .5497 m .5418 .52485 L .54337 .50375 L p F P
0 g
s
.536 .411 .657 r
.54337 .50375 m .59539 .52409 L .59115 .5497 L p F P
0 g
s
.535 .428 .679 r
.59539 .52409 m .54337 .50375 L .54263 .48258 L p F P
0 g
s
.535 .428 .679 r
.54263 .48258 m .59683 .49813 L .59539 .52409 L p F P
0 g
s
.536 .446 .701 r
.59683 .49813 m .54263 .48258 L .5396 .46159 L p F P
0 g
s
.538 .396 .635 r
.58415 .57466 m .53795 .54562 L .5418 .52485 L p F P
0 g
s
.538 .396 .635 r
.5418 .52485 m .59115 .5497 L .58415 .57466 L p F P
0 g
s
.536 .446 .701 r
.5396 .46159 m .59546 .47214 L .59683 .49813 L p F P
0 g
s
.543 .382 .612 r
.57448 .59867 m .53185 .56582 L .53795 .54562 L p F P
0 g
s
.543 .382 .612 r
.53795 .54562 m .58415 .57466 L .57448 .59867 L p F P
0 g
s
.55 .37 .59 r
.56225 .62143 m .52359 .58519 L .53185 .56582 L p F P
0 g
s
.55 .37 .59 r
.53185 .56582 m .57448 .59867 L .56225 .62143 L p F P
0 g
s
.558 .359 .568 r
.54759 .64268 m .51326 .6035 L .52359 .58519 L p F P
0 g
s
.558 .359 .568 r
.52359 .58519 m .56225 .62143 L .54759 .64268 L p F P
0 g
s
.568 .351 .546 r
.53068 .66214 m .50097 .62054 L .51326 .6035 L p F P
0 g
s
.568 .351 .546 r
.51326 .6035 m .54759 .64268 L .53068 .66214 L p F P
0 g
s
.581 .346 .525 r
.51172 .67958 m .48688 .63607 L .50097 .62054 L p F P
0 g
s
.581 .346 .525 r
.50097 .62054 m .53068 .66214 L .51172 .67958 L p F P
0 g
s
.595 .342 .504 r
.49092 .69477 m .47115 .64992 L .48688 .63607 L p F P
0 g
s
.595 .342 .504 r
.48688 .63607 m .51172 .67958 L .49092 .69477 L p F P
0 g
s
.611 .342 .485 r
.46854 .70752 m .45396 .6619 L .47115 .64992 L p F P
0 g
s
.611 .342 .485 r
.47115 .64992 m .49092 .69477 L .46854 .70752 L p F P
0 g
s
.629 .344 .467 r
.44484 .71767 m .43553 .67187 L .45396 .6619 L p F P
0 g
s
.629 .344 .467 r
.45396 .6619 m .46854 .70752 L .44484 .71767 L p F P
0 g
s
.648 .349 .451 r
.4201 .72506 m .41607 .67968 L .43553 .67187 L p F P
0 g
s
.648 .349 .451 r
.43553 .67187 m .44484 .71767 L .4201 .72506 L p F P
0 g
s
.669 .357 .436 r
.39464 .7296 m .39583 .68524 L .41607 .67968 L p F P
0 g
s
.669 .357 .436 r
.41607 .67968 m .4201 .72506 L .39464 .7296 L p F P
0 g
s
.505 .381 .645 r
.64617 .55919 m .59539 .52409 L .59683 .49813 L p F P
0 g
s
.505 .381 .645 r
.59683 .49813 m .65144 .52878 L .64617 .55919 L p F P
0 g
s
.504 .4 .67 r
.65144 .52878 m .59683 .49813 L .59546 .47214 L p F P
0 g
s
.508 .364 .62 r
.63763 .5888 m .59115 .5497 L .59539 .52409 L p F P
0 g
s
.508 .364 .62 r
.59539 .52409 m .64617 .55919 L .63763 .5888 L p F P
0 g
s
.504 .4 .67 r
.59546 .47214 m .6534 .49794 L .65144 .52878 L p F P
0 g
s
.513 .348 .594 r
.62594 .61726 m .58415 .57466 L .59115 .5497 L p F P
0 g
s
.513 .348 .594 r
.59115 .5497 m .63763 .5888 L .62594 .61726 L p F P
0 g
s
.52 .334 .569 r
.61122 .64422 m .57448 .59867 L .58415 .57466 L p F P
0 g
s
.52 .334 .569 r
.58415 .57466 m .62594 .61726 L .61122 .64422 L p F P
0 g
s
.529 .322 .543 r
.59363 .66937 m .56225 .62143 L .57448 .59867 L p F P
0 g
s
.529 .322 .543 r
.57448 .59867 m .61122 .64422 L .59363 .66937 L p F P
0 g
s
.54 .312 .518 r
.57338 .6924 m .54759 .64268 L .56225 .62143 L p F P
0 g
s
.54 .312 .518 r
.56225 .62143 m .59363 .66937 L .57338 .6924 L p F P
0 g
s
.553 .305 .493 r
.5507 .713 m .53068 .66214 L .54759 .64268 L p F P
0 g
s
.553 .305 .493 r
.54759 .64268 m .57338 .6924 L .5507 .713 L p F P
0 g
s
.569 .3 .469 r
.52586 .73094 m .51172 .67958 L .53068 .66214 L p F P
0 g
s
.569 .3 .469 r
.53068 .66214 m .5507 .713 L .52586 .73094 L p F P
0 g
s
.586 .298 .446 r
.49914 .74596 m .49092 .69477 L .51172 .67958 L p F P
0 g
s
.586 .298 .446 r
.51172 .67958 m .52586 .73094 L .49914 .74596 L p F P
0 g
s
.606 .3 .425 r
.47086 .75787 m .46854 .70752 L .49092 .69477 L p F P
0 g
s
.606 .3 .425 r
.49092 .69477 m .49914 .74596 L .47086 .75787 L p F P
0 g
s
.628 .305 .405 r
.44136 .76651 m .44484 .71767 L .46854 .70752 L p F P
0 g
s
.628 .305 .405 r
.46854 .70752 m .47086 .75787 L .44136 .76651 L p F P
0 g
s
.651 .313 .387 r
.411 .77175 m .4201 .72506 L .44484 .71767 L p F P
0 g
s
.651 .313 .387 r
.44484 .71767 m .44136 .76651 L .411 .77175 L p F P
0 g
s
.676 .325 .372 r
.38016 .7735 m .39464 .7296 L .4201 .72506 L p F P
0 g
s
.676 .325 .372 r
.4201 .72506 m .411 .77175 L .38016 .7735 L p F P
0 g
s
.491 .361 .631 r
.70688 .57873 m .65144 .52878 L .6534 .49794 L p F P
0 g
s
.491 .361 .631 r
.6534 .49794 m .71432 .54318 L .70688 .57873 L p F P
0 g
s
.494 .343 .604 r
.69565 .61321 m .64617 .55919 L .65144 .52878 L p F P
0 g
s
.494 .343 .604 r
.65144 .52878 m .70688 .57873 L .69565 .61321 L p F P
0 g
s
.5 .326 .577 r
.68076 .64622 m .63763 .5888 L .64617 .55919 L p F P
0 g
s
.5 .326 .577 r
.64617 .55919 m .69565 .61321 L .68076 .64622 L p F P
0 g
s
.508 .312 .55 r
.66238 .67736 m .62594 .61726 L .63763 .5888 L p F P
0 g
s
.508 .312 .55 r
.63763 .5888 m .68076 .64622 L .66238 .67736 L p F P
0 g
s
.517 .3 .523 r
.64069 .70625 m .61122 .64422 L .62594 .61726 L p F P
0 g
s
.517 .3 .523 r
.62594 .61726 m .66238 .67736 L .64069 .70625 L p F P
0 g
s
.53 .29 .496 r
.61596 .73255 m .59363 .66937 L .61122 .64422 L p F P
0 g
s
.53 .29 .496 r
.61122 .64422 m .64069 .70625 L .61596 .73255 L p F P
0 g
s
.544 .283 .47 r
.58845 .75592 m .57338 .6924 L .59363 .66937 L p F P
0 g
s
.544 .283 .47 r
.59363 .66937 m .61596 .73255 L .58845 .75592 L p F P
0 g
s
.561 .278 .444 r
.55849 .77606 m .5507 .713 L .57338 .6924 L p F P
0 g
s
.561 .278 .444 r
.57338 .6924 m .58845 .75592 L .55849 .77606 L p F P
0 g
s
.58 .277 .42 r
.52642 .7927 m .52586 .73094 L .5507 .713 L p F P
0 g
s
.58 .277 .42 r
.5507 .713 m .55849 .77606 L .52642 .7927 L p F P
0 g
s
.601 .279 .397 r
.49262 .80563 m .49914 .74596 L .52586 .73094 L p F P
0 g
s
.601 .279 .397 r
.52586 .73094 m .52642 .7927 L .49262 .80563 L p F P
0 g
s
.624 .285 .376 r
.45749 .81465 m .47086 .75787 L .49914 .74596 L p F P
0 g
s
.624 .285 .376 r
.49914 .74596 m .49262 .80563 L .45749 .81465 L p F P
0 g
s
.649 .294 .357 r
.42146 .81962 m .44136 .76651 L .47086 .75787 L p F P
0 g
s
.649 .294 .357 r
.47086 .75787 m .45749 .81465 L .42146 .81962 L p F P
0 g
s
.676 .308 .341 r
.38497 .82045 m .411 .77175 L .44136 .76651 L p F P
0 g
s
.676 .308 .341 r
.44136 .76651 m .42146 .81962 L .38497 .82045 L p F P
0 g
s
.704 .325 .328 r
.34848 .8171 m .38016 .7735 L .411 .77175 L p F P
0 g
s
.704 .325 .328 r
.411 .77175 m .38497 .82045 L .34848 .8171 L p F P
0 g
s
.502 .34 .593 r
.76379 .65318 m .70688 .57873 L .71432 .54318 L p F P
0 g
s
.502 .34 .593 r
.71432 .54318 m .77939 .61303 L .76379 .65318 L p F P
0 g
s
.509 .325 .566 r
.74394 .69136 m .69565 .61321 L .70688 .57873 L p F P
0 g
s
.509 .325 .566 r
.70688 .57873 m .76379 .65318 L .74394 .69136 L p F P
0 g
s
.518 .312 .54 r
.72007 .7271 m .68076 .64622 L .69565 .61321 L p F P
0 g
s
.518 .312 .54 r
.69565 .61321 m .74394 .69136 L .72007 .7271 L p F P
0 g
s
.529 .301 .513 r
.69243 .75997 m .66238 .67736 L .68076 .64622 L p F P
0 g
s
.529 .301 .513 r
.68076 .64622 m .72007 .7271 L .69243 .75997 L p F P
0 g
s
.542 .293 .487 r
.66132 .78956 m .64069 .70625 L .66238 .67736 L p F P
0 g
s
.542 .293 .487 r
.66238 .67736 m .69243 .75997 L .66132 .78956 L p F P
0 g
s
.558 .287 .462 r
.6271 .81551 m .61596 .73255 L .64069 .70625 L p F P
0 g
s
.558 .287 .462 r
.64069 .70625 m .66132 .78956 L .6271 .81551 L p F P
0 g
s
.575 .285 .438 r
.59015 .83746 m .58845 .75592 L .61596 .73255 L p F P
0 g
s
.575 .285 .438 r
.61596 .73255 m .6271 .81551 L .59015 .83746 L p F P
0 g
s
.595 .285 .414 r
.5509 .85513 m .55849 .77606 L .58845 .75592 L p F P
0 g
s
.595 .285 .414 r
.58845 .75592 m .59015 .83746 L .5509 .85513 L p F P
0 g
s
.617 .289 .393 r
.5098 .86826 m .52642 .7927 L .55849 .77606 L p F P
0 g
s
.617 .289 .393 r
.55849 .77606 m .5509 .85513 L .5098 .86826 L p F P
0 g
s
.641 .297 .374 r
.46735 .87665 m .49262 .80563 L .52642 .7927 L p F P
0 g
s
.641 .297 .374 r
.52642 .7927 m .5098 .86826 L .46735 .87665 L p F P
0 g
s
.667 .309 .357 r
.42406 .88015 m .45749 .81465 L .49262 .80563 L p F P
0 g
s
.667 .309 .357 r
.49262 .80563 m .46735 .87665 L .42406 .88015 L p F P
0 g
s
.694 .324 .343 r
.38047 .87868 m .42146 .81962 L .45749 .81465 L p F P
0 g
s
.694 .324 .343 r
.45749 .81465 m .42406 .88015 L .38047 .87868 L p F P
0 g
s
.723 .344 .332 r
.33713 .8722 m .38497 .82045 L .42146 .81962 L p F P
0 g
s
.723 .344 .332 r
.42146 .81962 m .38047 .87868 L .33713 .8722 L p F P
0 g
s
.752 .368 .326 r
.29459 .86075 m .34848 .8171 L .38497 .82045 L p F P
0 g
s
.752 .368 .326 r
.38497 .82045 m .33713 .8722 L .29459 .86075 L p F P
0 g
s
.533 .338 .562 r
.8231 .75893 m .76379 .65318 L .77939 .61303 L p F P
0 g
s
.533 .338 .562 r
.77939 .61303 m .85025 .71415 L .8231 .75893 L p F P
0 g
s
.543 .327 .537 r
.79124 .80046 m .74394 .69136 L .76379 .65318 L p F P
0 g
s
.543 .327 .537 r
.76379 .65318 m .8231 .75893 L .79124 .80046 L p F P
0 g
s
.555 .319 .513 r
.75502 .83822 m .72007 .7271 L .74394 .69136 L p F P
0 g
s
.555 .319 .513 r
.74394 .69136 m .79124 .80046 L .75502 .83822 L p F P
0 g
s
.569 .314 .49 r
.71482 .87174 m .69243 .75997 L .72007 .7271 L p F P
0 g
s
.569 .314 .49 r
.72007 .7271 m .75502 .83822 L .71482 .87174 L p F P
0 g
s
.585 .311 .467 r
.67108 .90058 m .66132 .78956 L .69243 .75997 L p F P
0 g
s
.585 .311 .467 r
.69243 .75997 m .71482 .87174 L .67108 .90058 L p F P
0 g
s
.603 .311 .446 r
.6243 .92437 m .6271 .81551 L .66132 .78956 L p F P
0 g
s
.603 .311 .446 r
.66132 .78956 m .67108 .90058 L .6243 .92437 L p F P
0 g
s
.623 .314 .426 r
.575 .94275 m .59015 .83746 L .6271 .81551 L p F P
0 g
s
.623 .314 .426 r
.6271 .81551 m .6243 .92437 L .575 .94275 L p F P
0 g
s
.645 .321 .408 r
.52377 .95545 m .5509 .85513 L .59015 .83746 L p F P
0 g
s
.645 .321 .408 r
.59015 .83746 m .575 .94275 L .52377 .95545 L p F P
0 g
s
.669 .331 .392 r
.47121 .96225 m .5098 .86826 L .5509 .85513 L p F P
0 g
s
.669 .331 .392 r
.5509 .85513 m .52377 .95545 L .47121 .96225 L p F P
0 g
s
.695 .345 .379 r
.41796 .96299 m .46735 .87665 L .5098 .86826 L p F P
0 g
s
.695 .345 .379 r
.5098 .86826 m .47121 .96225 L .41796 .96299 L p F P
0 g
s
.721 .363 .369 r
.3647 .9576 m .42406 .88015 L .46735 .87665 L p F P
0 g
s
.721 .363 .369 r
.46735 .87665 m .41796 .96299 L .3647 .9576 L p F P
0 g
s
.749 .384 .363 r
.3121 .94607 m .38047 .87868 L .42406 .88015 L p F P
0 g
s
.749 .384 .363 r
.42406 .88015 m .3647 .9576 L .3121 .94607 L p F P
0 g
s
.777 .409 .36 r
.26085 .92848 m .33713 .8722 L .38047 .87868 L p F P
0 g
s
.777 .409 .36 r
.38047 .87868 m .3121 .94607 L .26085 .92848 L p F P
0 g
s
.805 .437 .362 r
.21164 .90501 m .29459 .86075 L .33713 .8722 L p F P
0 g
s
.805 .437 .362 r
.33713 .8722 m .26085 .92848 L .21164 .90501 L p F P
0 g
s
.57 .349 .541 r
.88617 .90521 m .8231 .75893 L .85025 .71415 L p F P
0 g
s
.57 .349 .541 r
.85025 .71415 m .92919 .85555 L .88617 .90521 L p F P
0 g
s
.582 .343 .519 r
.83792 .94985 m .79124 .80046 L .8231 .75893 L p F P
0 g
s
.582 .343 .519 r
.8231 .75893 m .88617 .90521 L .83792 .94985 L p F P
0 g
s
.597 .34 .499 r
.78496 .98893 m .75502 .83822 L .79124 .80046 L p F P
0 g
s
.597 .34 .499 r
.79124 .80046 m .83792 .94985 L .78496 .98893 L p F P
0 g
s
.613 .34 .479 r
.72784 1.02191 m .71482 .87174 L .75502 .83822 L p F P
0 g
s
.613 .34 .479 r
.75502 .83822 m .78496 .98893 L .72784 1.02191 L p F P
0 g
s
.632 .343 .461 r
.6672 1.04832 m .67108 .90058 L .71482 .87174 L p F P
0 g
s
.632 .343 .461 r
.71482 .87174 m .72784 1.02191 L .6672 1.04832 L p F P
0 g
s
.652 .348 .445 r
.60373 1.06776 m .6243 .92437 L .67108 .90058 L p F P
0 g
s
.652 .348 .445 r
.67108 .90058 m .6672 1.04832 L .60373 1.06776 L p F P
0 g
s
.673 .357 .43 r
.53815 1.0799 m .575 .94275 L .6243 .92437 L p F P
0 g
s
.673 .357 .43 r
.6243 .92437 m .60373 1.06776 L .53815 1.0799 L p F P
0 g
s
.696 .369 .418 r
.47126 1.08447 m .52377 .95545 L .575 .94275 L p F P
0 g
s
.696 .369 .418 r
.575 .94275 m .53815 1.0799 L .47126 1.08447 L p F P
0 g
s
.72 .384 .409 r
.40386 1.08132 m .47121 .96225 L .52377 .95545 L p F P
0 g
s
.72 .384 .409 r
.52377 .95545 m .47126 1.08447 L .40386 1.08132 L p F P
0 g
s
.745 .403 .403 r
.33683 1.07037 m .41796 .96299 L .47121 .96225 L p F P
0 g
s
.745 .403 .403 r
.47121 .96225 m .40386 1.08132 L .33683 1.07037 L p F P
0 g
s
.771 .425 .4 r
.27103 1.05165 m .3647 .9576 L .41796 .96299 L p F P
0 g
s
.771 .425 .4 r
.41796 .96299 m .33683 1.07037 L .27103 1.05165 L p F P
0 g
s
.797 .45 .401 r
.20734 1.02529 m .3121 .94607 L .3647 .9576 L p F P
0 g
s
.797 .45 .401 r
.3647 .9576 m .27103 1.05165 L .20734 1.02529 L p F P
0 g
s
.822 .478 .406 r
.14664 .99154 m .26085 .92848 L .3121 .94607 L p F P
0 g
s
.822 .478 .406 r
.3121 .94607 m .20734 1.02529 L .14664 .99154 L p F P
0 g
s
.847 .509 .414 r
.08978 .95077 m .21164 .90501 L .26085 .92848 L p F P
0 g
s
.847 .509 .414 r
.26085 .92848 m .14664 .99154 L .08978 .95077 L p F P
0 g
s
.25 Mabswid
.7024 0 m
.92242 .33359 L
s
.92242 .33359 m
1 1.12332 L
s
1 1.12332 m
.744 .83431 L
s
.744 .83431 m
.7024 0 L
s
.08315 .24536 m
0 1.04816 L
s
0 1.04816 m
.744 .83431 L
s
.744 .83431 m
.7024 0 L
s
.7024 0 m
.08315 .24536 L
s
0 1.04816 m
.32213 1.28773 L
s
.03864 1.0769 m
.03941 1.06877 L
s
[(-0.6)] .03709 1.09317 .09516 -1 Mshowa
.12473 1.14093 m
.12536 1.13278 L
s
[(-0.4)] .12348 1.15722 .07676 -1 Mshowa
.2055 1.20099 m
.20599 1.19284 L
s
[(-0.2)] .20452 1.2173 .05993 -1 Mshowa
.28142 1.25746 m
.28178 1.24929 L
s
[(0)] .28069 1.27378 .04446 -1 Mshowa
.125 Mabswid
.06069 1.0933 m
.06113 1.08842 L
s
.08238 1.10943 m
.0828 1.10455 L
s
.10373 1.12531 m
.10413 1.12042 L
s
.1454 1.1563 m
.14576 1.15141 L
s
.16575 1.17143 m
.16608 1.16654 L
s
.18578 1.18633 m
.18609 1.18144 L
s
.22492 1.21543 m
.22519 1.21054 L
s
.24404 1.22966 m
.24429 1.22476 L
s
.26287 1.24366 m
.26311 1.23876 L
s
.01622 1.06023 m
.01671 1.05535 L
s
.29969 1.27105 m
.29989 1.26615 L
s
.3177 1.28443 m
.31788 1.27954 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.44.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.44.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.44.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.44.1", "1.1"}],
    Cell[1923, 61, 624, 19, 56, "Text",
      CellTags->{"S5.44.1", "1.2"}],
    Cell[2550, 82, 8367, 260, 162, "DefinitionBox",
      CellTags->"S5.44.1"],
    Cell[10920, 344, 74, 1, 15, "Caption",
      CellTags->"S5.44.1"],
    Cell[10997, 347, 78, 1, 40, "MathCaption",
      CellTags->{"S5.44.1", "1.3"}],
    Cell[11078, 350, 94, 2, 28, "Input",
      CellTags->"S5.44.1"],
    Cell[11175, 354, 440, 17, 40, "MathCaption",
      CellTags->{"S5.44.1", "1.4"}],
    Cell[11640, 375, 123, 5, 45, "Input",
      CellTags->"S5.44.1"],
    Cell[11766, 382, 201422, 7981, 186, 132685, 7128, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.44.1"],
    Cell[213191, 8365, 182, 6, 25, "Output",
      CellTags->"S5.44.1"],
    Cell[213388, 8374, 178, 5, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.5"}],
    Cell[213591, 8383, 205, 7, 70, "Input",
      CellTags->"S5.44.1"],
    Cell[213799, 8392, 131849, 7077, 70, 131778, 7074, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.44.1"],
    Cell[345651, 15471, 182, 6, 70, "Output",
      CellTags->"S5.44.1"],
    Cell[345848, 15480, 608, 21, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.6"}],
    Cell[346481, 15505, 151, 5, 70, "Input",
      CellTags->"S5.44.1"],
    Cell[346635, 15512, 158285, 7985, 70, 158214, 7982, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.44.1"],
    Cell[504923, 23499, 182, 6, 70, "Output",
      CellTags->"S5.44.1"],
    Cell[505120, 23508, 2481, 78, 70, "DefinitionBox",
      CellTags->"S5.44.1"],
    Cell[507604, 23588, 95, 1, 70, "Caption",
      CellTags->"S5.44.1"],
    Cell[507702, 23591, 349, 11, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.7"}],
    Cell[508076, 23606, 169, 6, 70, "Input",
      CellTags->"S5.44.1"],
    Cell[508248, 23614, 160127, 8095, 70, 160056, 8092, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.44.1"],
    Cell[668378, 31711, 182, 6, 70, "Output",
      CellTags->"S5.44.1"],
    Cell[668575, 31720, 2887, 88, 70, "DefinitionBox",
      CellTags->"S5.44.1"],
    Cell[671465, 31810, 75, 1, 70, "Caption",
      CellTags->"S5.44.1"],
    Cell[671543, 31813, 147, 4, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.8"}],
    Cell[671715, 31821, 139, 5, 70, "Input",
      CellTags->"S5.44.1"],
    Cell[671857, 31828, 129944, 7007, 70, 129873, 7004, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.44.1"],
    Cell[801804, 38837, 182, 6, 70, "Output",
      CellTags->"S5.44.1"],
    Cell[802001, 38846, 3355, 99, 70, "DefinitionBox",
      CellTags->"S5.44.1"],
    Cell[805359, 38947, 91, 1, 70, "Caption",
      CellTags->"S5.44.1"],
    Cell[805453, 38950, 521, 16, 70, "Text",
      CellTags->{"S5.44.1", "1.9"}],
    Cell[805977, 38968, 398, 15, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.10"}],
    Cell[806378, 38985, 100, 2, 70, "Input",
      CellTags->"S5.44.1"],
    Cell[806481, 38989, 276, 11, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.11"}],
    Cell[806782, 39004, 177, 6, 70, "Input",
      CellTags->"S5.44.1"],
    Cell[806962, 39012, 25638, 1440, 70, 25567, 1437, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.44.1"],
    Cell[832603, 40454, 182, 6, 70, "Output",
      CellTags->"S5.44.1"]},
  "1.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.44.1", "1.1"}]},
  "1.2"->{
    Cell[1923, 61, 624, 19, 56, "Text",
      CellTags->{"S5.44.1", "1.2"}]},
  "1.3"->{
    Cell[10997, 347, 78, 1, 40, "MathCaption",
      CellTags->{"S5.44.1", "1.3"}]},
  "1.4"->{
    Cell[11175, 354, 440, 17, 40, "MathCaption",
      CellTags->{"S5.44.1", "1.4"}]},
  "1.5"->{
    Cell[213388, 8374, 178, 5, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.5"}]},
  "1.6"->{
    Cell[345848, 15480, 608, 21, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.6"}]},
  "1.7"->{
    Cell[507702, 23591, 349, 11, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.7"}]},
  "1.8"->{
    Cell[671543, 31813, 147, 4, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.8"}]},
  "1.9"->{
    Cell[805453, 38950, 521, 16, 70, "Text",
      CellTags->{"S5.44.1", "1.9"}]},
  "1.10"->{
    Cell[805977, 38968, 398, 15, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.10"}]},
  "1.11"->{
    Cell[806481, 38989, 276, 11, 70, "MathCaption",
      CellTags->{"S5.44.1", "1.11"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.44.1", 833436, 40480},
  {"1.1", 836964, 40570},
  {"1.2", 837058, 40573},
  {"1.3", 837147, 40576},
  {"1.4", 837243, 40579},
  {"1.5", 837341, 40582},
  {"1.6", 837440, 40585},
  {"1.7", 837541, 40588},
  {"1.8", 837642, 40591},
  {"1.9", 837742, 40594},
  {"1.10", 837837, 40597},
  {"1.11", 837940, 40600}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 144, 6, 36, "Subsection",
  CellTags->{"S5.44.1", "1.1"}],
Cell[1923, 61, 624, 19, 56, "Text",
  CellTags->{"S5.44.1", "1.2"}],
Cell[2550, 82, 8367, 260, 162, "DefinitionBox",
  CellTags->"S5.44.1"],
Cell[10920, 344, 74, 1, 15, "Caption",
  CellTags->"S5.44.1"],
Cell[10997, 347, 78, 1, 40, "MathCaption",
  CellTags->{"S5.44.1", "1.3"}],
Cell[11078, 350, 94, 2, 28, "Input",
  CellTags->"S5.44.1"],
Cell[11175, 354, 440, 17, 40, "MathCaption",
  CellTags->{"S5.44.1", "1.4"}],

Cell[CellGroupData[{
Cell[11640, 375, 123, 5, 45, "Input",
  CellTags->"S5.44.1"],
Cell[11766, 382, 201422, 7981, 186, 132685, 7128, "GraphicsData", \
"PostScript", "Graphics",
  CellTags->"S5.44.1"],
Cell[213191, 8365, 182, 6, 25, "Output",
  CellTags->"S5.44.1"]
}, Open  ]],
Cell[213388, 8374, 178, 5, 70, "MathCaption",
  CellTags->{"S5.44.1", "1.5"}],

Cell[CellGroupData[{
Cell[213591, 8383, 205, 7, 70, "Input",
  CellTags->"S5.44.1"],
Cell[213799, 8392, 131849, 7077, 70, 131778, 7074, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.44.1"],
Cell[345651, 15471, 182, 6, 70, "Output",
  CellTags->"S5.44.1"]
}, Open  ]],
Cell[345848, 15480, 608, 21, 70, "MathCaption",
  CellTags->{"S5.44.1", "1.6"}],

Cell[CellGroupData[{
Cell[346481, 15505, 151, 5, 70, "Input",
  CellTags->"S5.44.1"],
Cell[346635, 15512, 158285, 7985, 70, 158214, 7982, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.44.1"],
Cell[504923, 23499, 182, 6, 70, "Output",
  CellTags->"S5.44.1"]
}, Open  ]],
Cell[505120, 23508, 2481, 78, 70, "DefinitionBox",
  CellTags->"S5.44.1"],
Cell[507604, 23588, 95, 1, 70, "Caption",
  CellTags->"S5.44.1"],
Cell[507702, 23591, 349, 11, 70, "MathCaption",
  CellTags->{"S5.44.1", "1.7"}],

Cell[CellGroupData[{
Cell[508076, 23606, 169, 6, 70, "Input",
  CellTags->"S5.44.1"],
Cell[508248, 23614, 160127, 8095, 70, 160056, 8092, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.44.1"],
Cell[668378, 31711, 182, 6, 70, "Output",
  CellTags->"S5.44.1"]
}, Open  ]],
Cell[668575, 31720, 2887, 88, 70, "DefinitionBox",
  CellTags->"S5.44.1"],
Cell[671465, 31810, 75, 1, 70, "Caption",
  CellTags->"S5.44.1"],
Cell[671543, 31813, 147, 4, 70, "MathCaption",
  CellTags->{"S5.44.1", "1.8"}],

Cell[CellGroupData[{
Cell[671715, 31821, 139, 5, 70, "Input",
  CellTags->"S5.44.1"],
Cell[671857, 31828, 129944, 7007, 70, 129873, 7004, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.44.1"],
Cell[801804, 38837, 182, 6, 70, "Output",
  CellTags->"S5.44.1"]
}, Open  ]],
Cell[802001, 38846, 3355, 99, 70, "DefinitionBox",
  CellTags->"S5.44.1"],
Cell[805359, 38947, 91, 1, 70, "Caption",
  CellTags->"S5.44.1"],
Cell[805453, 38950, 521, 16, 70, "Text",
  CellTags->{"S5.44.1", "1.9"}],
Cell[805977, 38968, 398, 15, 70, "MathCaption",
  CellTags->{"S5.44.1", "1.10"}],
Cell[806378, 38985, 100, 2, 70, "Input",
  CellTags->"S5.44.1"],
Cell[806481, 38989, 276, 11, 70, "MathCaption",
  CellTags->{"S5.44.1", "1.11"}],

Cell[CellGroupData[{
Cell[806782, 39004, 177, 6, 70, "Input",
  CellTags->"S5.44.1"],
Cell[806962, 39012, 25638, 1440, 70, 25567, 1437, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.44.1"],
Cell[832603, 40454, 182, 6, 70, "Output",
  CellTags->"S5.44.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

