(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21911,        755]*)
(*NotebookOutlinePosition[     25253,        860]*)
(*  CellTagsIndexPosition[     24949,        844]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Algebra",
 StyleBox["`", "MB"],
 "SymmetricPolynomials",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.10.1", "1.1"}],

Cell[TextData[{
 "The package provides functions for generating elementary symmetric \
polynomials and for representing symmetric polynomials in terms of elementary \
symmetric polynomials. The Fundamental Theorem of Symmetric Polynomials says \
that every symmetric polynomial in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["x",
      "TI"], "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can be represented as a polynomial in elementary symmetric polynomials as \
follows: "
}], "Text",
 CellTags->{"S5.10.1", "1.2"}],

Cell[TextData[{
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["s",
      "TI"], "1"], "=", 
    SubscriptBox[
     StyleBox["x",
      "TI"], "1"], "+", 
    SubscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", "\[Ellipsis]", "+", 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["s",
      "TI"], "2"], "=", 
    SubscriptBox[
     StyleBox["x",
      "TI"], "1"], 
    SubscriptBox[
     StyleBox["x",
      "TI"], "2"], "+", 
    SubscriptBox[
     StyleBox["x",
      "TI"], "1"], 
    SubscriptBox[
     StyleBox["x",
      "TI"], "3"], "+", "\[Ellipsis]", "+", 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     RowBox[{
      StyleBox["n",
       "TI"], "-", "1"}]], 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\n  ",
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["s",
      "TI"], 
     StyleBox["n",
      "TI"]], "=", 
    SubscriptBox[
     StyleBox["x",
      "TI"], "1"], 
    SubscriptBox[
     StyleBox["x",
      "TI"], "2"], "\[CenterDot]", "\[Ellipsis]", "\[CenterDot]", 
    SubscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " "
}], "Text",
 CellTags->{"S5.10.1", "1.3"}],

Cell["\<\
When the ordering of variables is fixed, every polynomial can be uniquely \
represented as a sum of its symmetric part and the remainder as follows: \
\>", "Text",
 CellTags->{"S5.10.1", "1.4"}],

Cell[TextData[{
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       StyleBox["x",
        "TI"], "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["x",
        "TI"], 
       StyleBox["n",
        "TI"]]}], ")"}], "=", 
    StyleBox["p",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       StyleBox["s",
        "TI"], "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["s",
        "TI"], 
       StyleBox["n",
        "TI"]]}], ")"}], "+", 
    StyleBox["q",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       StyleBox["x",
        "TI"], "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["x",
        "TI"], 
       StyleBox["n",
        "TI"]]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " "
}], "Text",
 CellTags->{"S5.10.1", "1.5"}],

Cell[TextData[{
 "The polynomial ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is symmetric if and only if the remainder ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is zero. The uniqueness of this representation is guaranteed by requiring \
that ",
 Cell[BoxData[
  FormBox[
   StyleBox["q",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " does not contain descending monomials, where a monomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["c",
     "TI"], 
    SubsuperscriptBox[
     StyleBox["x",
      "TI"], "1", 
     SubscriptBox[
      StyleBox["e",
       "TI"], "1"]], "\[CenterDot]", "\[Ellipsis]", "\[CenterDot]", 
    SubsuperscriptBox[
     StyleBox["x",
      "TI"], 
     StyleBox["n",
      "TI"], 
     SubscriptBox[
      StyleBox["e",
       "TI"], 
      StyleBox["n",
       "TI"]]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is called descending iff ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["e",
      "TI"], "1"], "\[GreaterEqual]", "\[Ellipsis]", "\[GreaterEqual]", 
    SubscriptBox[
     StyleBox["e",
      "TI"], 
     StyleBox["n",
      "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.10.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SymmetricReduction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a pair of polynomials ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["f",
          "TI"], "=", 
         StyleBox["p",
          "TI"], "+", 
         StyleBox["q",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["p",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the symmetric part, and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["q",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is the remainder ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SymmetricReduction[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["s",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["s",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a pair of polynomials ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["p", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["q", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      ", where the elementary symmetric polynomials are replaced by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["s",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["s",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SymmetricPolynomial[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis] , ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["k", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["k",
          "TI"], "th"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" symmetric polynomial in variables ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.10.1"],

Cell["Symmetric polynomial functions. ", "Caption",
 CellTags->"S5.10.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.10.1", "1.7"}],

Cell["<<Algebra`SymmetricPolynomials`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.10.1"],

Cell["\<\
Here is the elementary symmetric polynomial of degree three in four \
variables. \
\>", "MathCaption",
 CellTags->{"S5.10.1", "1.8"}],

Cell[CellGroupData[{

Cell["SymmetricPolynomial[{x, y, z, t}, 3]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.10.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", " ", "x", " ", "y"}], "+", 
  RowBox[{"t", " ", "x", " ", "z"}], "+", 
  RowBox[{"t", " ", "y", " ", "z"}], "+", 
  RowBox[{"x", " ", "y", " ", "z"}]}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.10.1"]
}, Open  ]],

Cell["\<\
This gives the polynomial written in terms of elementary symmetric \
polynomials. The input polynomial is symmetric, so the remainder is zero. \
\>", "MathCaption",
 CellTags->{"S5.10.1", "1.9"}],

Cell[CellGroupData[{

Cell["\<\
SymmetricReduction[(x + y)^2 + (x + z)^2 + (z + y)^2,
        {x, y, z}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.10.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "y", "+", "z"}], ")"}], "2"]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "+", 
       RowBox[{"x", " ", "z"}], "+", 
       RowBox[{"y", " ", "z"}]}], ")"}]}]}], ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.10.1"]
}, Open  ]],

Cell["\<\
Here the elementary symmetric polynomials in the symmetric part of the input \
polynomial are replaced with the given variables. The polynomial is not \
symmetric, so the remainder is not zero. \
\>", "MathCaption",
 CellTags->{"S5.10.1", "1.10"}],

Cell[CellGroupData[{

Cell["SymmetricReduction[x^5 + y^5 + z^4, {x, y, z}, {s1, s2, s3}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.10.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["s1", "5"], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["s1", "3"], " ", "s2"}], "+", 
    RowBox[{"5", " ", "s1", " ", 
     SuperscriptBox["s2", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["s1", "2"], " ", "s3"}], "-", 
    RowBox[{"5", " ", "s2", " ", "s3"}]}], ",", 
   RowBox[{
    SuperscriptBox["z", "4"], "-", 
    SuperscriptBox["z", "5"]}]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.10.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.10.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.10.1", "1.1"}],
    Cell[1923, 61, 704, 20, 72, "Text",
      CellTags->{"S5.10.1", "1.2"}],
    Cell[2630, 83, 1727, 78, 96, "Text",
      CellTags->{"S5.10.1", "1.3"}],
    Cell[4360, 163, 204, 4, 40, "Text",
      CellTags->{"S5.10.1", "1.4"}],
    Cell[4567, 169, 966, 44, 24, "Text",
      CellTags->{"S5.10.1", "1.5"}],
    Cell[5536, 215, 1537, 58, 56, "Text",
      CellTags->{"S5.10.1", "1.6"}],
    Cell[7076, 275, 12281, 380, 160, "DefinitionBox",
      CellTags->"S5.10.1"],
    Cell[19360, 657, 73, 1, 15, "Caption",
      CellTags->"S5.10.1"],
    Cell[19436, 660, 78, 1, 40, "MathCaption",
      CellTags->{"S5.10.1", "1.7"}],
    Cell[19517, 663, 94, 2, 28, "Input",
      CellTags->"S5.10.1"],
    Cell[19614, 667, 143, 4, 40, "MathCaption",
      CellTags->{"S5.10.1", "1.8"}],
    Cell[19782, 675, 99, 2, 28, "Input",
      CellTags->"S5.10.1"],
    Cell[19884, 679, 248, 7, 70, "Output",
      CellTags->"S5.10.1"],
    Cell[20147, 689, 205, 4, 70, "MathCaption",
      CellTags->{"S5.10.1", "1.9"}],
    Cell[20377, 697, 143, 5, 70, "Input",
      CellTags->"S5.10.1"],
    Cell[20523, 704, 432, 15, 70, "Output",
      CellTags->"S5.10.1"],
    Cell[20970, 722, 257, 5, 70, "MathCaption",
      CellTags->{"S5.10.1", "1.10"}],
    Cell[21252, 731, 123, 2, 70, "Input",
      CellTags->"S5.10.1"],
    Cell[21378, 735, 505, 16, 70, "Output",
      CellTags->"S5.10.1"]},
  "1.1"->{
    Cell[1776, 53, 144, 6, 36, "Subsection",
      CellTags->{"S5.10.1", "1.1"}]},
  "1.2"->{
    Cell[1923, 61, 704, 20, 72, "Text",
      CellTags->{"S5.10.1", "1.2"}]},
  "1.3"->{
    Cell[2630, 83, 1727, 78, 96, "Text",
      CellTags->{"S5.10.1", "1.3"}]},
  "1.4"->{
    Cell[4360, 163, 204, 4, 40, "Text",
      CellTags->{"S5.10.1", "1.4"}]},
  "1.5"->{
    Cell[4567, 169, 966, 44, 24, "Text",
      CellTags->{"S5.10.1", "1.5"}]},
  "1.6"->{
    Cell[5536, 215, 1537, 58, 56, "Text",
      CellTags->{"S5.10.1", "1.6"}]},
  "1.7"->{
    Cell[19436, 660, 78, 1, 40, "MathCaption",
      CellTags->{"S5.10.1", "1.7"}]},
  "1.8"->{
    Cell[19614, 667, 143, 4, 40, "MathCaption",
      CellTags->{"S5.10.1", "1.8"}]},
  "1.9"->{
    Cell[20147, 689, 205, 4, 70, "MathCaption",
      CellTags->{"S5.10.1", "1.9"}]},
  "1.10"->{
    Cell[20970, 722, 257, 5, 70, "MathCaption",
      CellTags->{"S5.10.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.10.1", 22534, 771},
  {"1.1", 24003, 810},
  {"1.2", 24097, 813},
  {"1.3", 24186, 816},
  {"1.4", 24276, 819},
  {"1.5", 24365, 822},
  {"1.6", 24455, 825},
  {"1.7", 24546, 828},
  {"1.8", 24642, 831},
  {"1.9", 24739, 834},
  {"1.10", 24837, 837}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 144, 6, 36, "Subsection",
  CellTags->{"S5.10.1", "1.1"}],
Cell[1923, 61, 704, 20, 72, "Text",
  CellTags->{"S5.10.1", "1.2"}],
Cell[2630, 83, 1727, 78, 96, "Text",
  CellTags->{"S5.10.1", "1.3"}],
Cell[4360, 163, 204, 4, 40, "Text",
  CellTags->{"S5.10.1", "1.4"}],
Cell[4567, 169, 966, 44, 24, "Text",
  CellTags->{"S5.10.1", "1.5"}],
Cell[5536, 215, 1537, 58, 56, "Text",
  CellTags->{"S5.10.1", "1.6"}],
Cell[7076, 275, 12281, 380, 160, "DefinitionBox",
  CellTags->"S5.10.1"],
Cell[19360, 657, 73, 1, 15, "Caption",
  CellTags->"S5.10.1"],
Cell[19436, 660, 78, 1, 40, "MathCaption",
  CellTags->{"S5.10.1", "1.7"}],
Cell[19517, 663, 94, 2, 28, "Input",
  CellTags->"S5.10.1"],
Cell[19614, 667, 143, 4, 40, "MathCaption",
  CellTags->{"S5.10.1", "1.8"}],

Cell[CellGroupData[{
Cell[19782, 675, 99, 2, 28, "Input",
  CellTags->"S5.10.1"],
Cell[19884, 679, 248, 7, 70, "Output",
  CellTags->"S5.10.1"]
}, Open  ]],
Cell[20147, 689, 205, 4, 70, "MathCaption",
  CellTags->{"S5.10.1", "1.9"}],

Cell[CellGroupData[{
Cell[20377, 697, 143, 5, 70, "Input",
  CellTags->"S5.10.1"],
Cell[20523, 704, 432, 15, 70, "Output",
  CellTags->"S5.10.1"]
}, Open  ]],
Cell[20970, 722, 257, 5, 70, "MathCaption",
  CellTags->{"S5.10.1", "1.10"}],

Cell[CellGroupData[{
Cell[21252, 731, 123, 2, 70, "Input",
  CellTags->"S5.10.1"],
Cell[21378, 735, 505, 16, 70, "Output",
  CellTags->"S5.10.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

