(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27600,        864]*)
(*NotebookOutlinePosition[     30875,        967]*)
(*  CellTagsIndexPosition[     30595,        952]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Graphics",
 StyleBox["`", "MB"],
 "ThreeScript",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.45.1", "1.1"}],

Cell[TextData[{
 "3\[Hyphen]Script is a file format for transferring descriptions of three\
\[Hyphen]dimensional graphics objects from ",
 StyleBox["Mathematica", "TI"],
 " to other programs. All ",
 StyleBox["Mathematica", "TI"],
 " kernels have the ability to render three\[Hyphen]dimensional images into \
the PostScript page description language. For certain applications, it is \
desirable to have a description of the image that retains the \
three\[Hyphen]dimensional character that is lost when rendering into \
PostScript. The package ",
 StyleBox["Graphics`ThreeScript`", "MR"],
 " supplies a number of utilities for writing suitable ",
 StyleBox["Mathematica", "TI"],
 " objects into 3\[Hyphen]Script format files. "
}], "Text",
 CellTags->{"S5.45.1", "1.2"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.45.1", "1.3"}],

Cell["<<Graphics`ThreeScript`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.45.1"],

Cell[TextData[{
 "This constructs a ",
 StyleBox["Graphics3D", "MR"],
 " object. "
}], "MathCaption",
 CellTags->{"S5.45.1", "1.4"}],

Cell[CellGroupData[{

Cell["\<\
obj = Graphics3D[
   Polygon[{{0,0,0}, {0,1,0}, {0,1,1}}]]\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.45.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics3D", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.45.1"]
}, Open  ]],

Cell[TextData[{
 "This writes the 3\[Hyphen]Script format into the file ",
 StyleBox["object.ts", "MR"],
 ". Note that the filename is returned. "
}], "MathCaption",
 CellTags->{"S5.45.1", "1.5"}],

Cell[CellGroupData[{

Cell["ThreeScript[ \"object.ts\", obj]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.45.1"],

Cell[BoxData["\<\"object.ts\"\>"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.45.1"]
}, Open  ]],

Cell["This shows the contents of the file. ", "MathCaption",
 CellTags->{"S5.45.1", "1.6"}],

Cell[CellGroupData[{

Cell["!!object.ts", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.45.1"],

Cell["\<\
% Graphics3D objects boundingbox 0 0 0 0 1 1 viewpoint 1.3 -2.4 2. \
ambientlight 0 0 0 lightsources 1. 0. 1. 1 0 0 1. 1. 1. 0 1 0 0. 1. 1. 0 0 1 \
polygon 0 0 0 0 1 0 0 1 1\
\>", "Print",
 CellTags->"S5.45.1"]
}, Open  ]],

Cell[TextData[{
 "The 3\[Hyphen]Script format works with all three\[Hyphen]dimensional \
primitives and directives. This includes both ",
 StyleBox["Graphics3D", "MR"],
 " and ",
 StyleBox["SurfaceGraphics", "MR"],
 " objects. Note that in the 3\[Hyphen]Script format information such as \
coordinates appears below the command name. "
}], "Text",
 CellTags->{"S5.45.1", "1.7"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["polygon ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" \[Ellipsis] ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a polygon specified by any number of vertices ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["line ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["y",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" \[Ellipsis] ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a line that joins a sequence of points ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["point ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["z", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["a point ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["mesh ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "12"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" \[Ellipsis]  ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "21"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" \[Ellipsis]  ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], 
         StyleBox[
          RowBox[{"m", "n"}],
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["a smooth surface specified by an ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["m",
          "TI"], "\[Cross]", 
         StyleBox["n",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" array of height values ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["colormesh ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["m", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" \[Ellipsis]  ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["z",
          "TI"], 
         StyleBox[
          RowBox[{"m", "n"}],
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["g",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "11"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" \[Ellipsis] ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            StyleBox["m",
             "TI"], "-", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            StyleBox["n",
             "TI"], "-", "1"}], ")"}]}]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a smooth surface with colors specified for center of each patch",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["color ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "objects that follow have the specified RGB color ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.45.1"],

Cell["\<\
Standard 3\[Hyphen]Script descriptions of three\[Hyphen]dimensional objects.\
\>", "Caption",
 CellTags->"S5.45.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["boundingbox ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "ranges of coordinates of objects in the scene ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["viewpoint ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["yr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["zr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "default relative position from which to view the scene ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ambientlight ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "isotropic ambient light level ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["lightsources ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xd",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["yd",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["zd",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["g",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["xd",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["yd",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["zd",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["r",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["g",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" \[Ellipsis] ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "directions and colors of light sources ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.45.1"],

Cell["\<\
3\[Hyphen]Script commands used as global directives.\
\>", "Caption",
 CellTags->"S5.45.1"],

Cell[TextData[{
 "3\[Hyphen]Script is used by the ",
 StyleBox["Mathematica", "TI"],
 " command ",
 StyleBox["Live", "MR"],
 " that is available on platforms that support the GL library, such as \
Silicon Graphics computers. A 3\[Hyphen]Script format file is written and \
this is passed to an external renderer to process. An alternative method you \
can use to pass a three\[Hyphen]dimensional structure, or indeed any ",
 StyleBox["Mathematica", "TI"],
 " expression into an external program, is to use the ",
 StyleBox["MathLink", "TI"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "\[RegisteredTrademark]"], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " communications protocol. "
}], "Text",
 CellTags->{"S5.45.1", "1.8"}],

Cell[TextData[{
 "A complete description of the 3\[Hyphen]Script file format is contained in \
the Wolfram Research technical report, ",
 StyleBox["The 3\[Hyphen]Script File Format", "TI"],
 ", which can be found in the ",
 StyleBox["Mathematica", "TI"],
 " Information Center, at http://library.wolfram.com; search the collection \
for \[OpenCurlyQuote]threescript\[CloseCurlyQuote]. "
}], "Text",
 CellTags->{"S5.45.1", "1.9"}]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.45.1"->{
    Cell[1776, 53, 136, 6, 36, "Subsection",
      CellTags->{"S5.45.1", "1.1"}],
    Cell[1915, 61, 770, 16, 104, "Text",
      CellTags->{"S5.45.1", "1.2"}],
    Cell[2688, 79, 78, 1, 40, "MathCaption",
      CellTags->{"S5.45.1", "1.3"}],
    Cell[2769, 82, 86, 2, 28, "Input",
      CellTags->"S5.45.1"],
    Cell[2858, 86, 132, 5, 40, "MathCaption",
      CellTags->{"S5.45.1", "1.4"}],
    Cell[3015, 95, 129, 5, 45, "Input",
      CellTags->"S5.45.1"],
    Cell[3147, 102, 182, 6, 25, "Output",
      CellTags->"S5.45.1"],
    Cell[3344, 111, 196, 5, 40, "MathCaption",
      CellTags->{"S5.45.1", "1.5"}],
    Cell[3565, 120, 95, 2, 28, "Input",
      CellTags->"S5.45.1"],
    Cell[3663, 124, 90, 2, 25, "Output",
      CellTags->"S5.45.1"],
    Cell[3768, 129, 91, 1, 40, "MathCaption",
      CellTags->{"S5.45.1", "1.6"}],
    Cell[3884, 134, 74, 2, 28, "Input",
      CellTags->"S5.45.1"],
    Cell[3961, 138, 220, 5, 51, "Print",
      CellTags->"S5.45.1"],
    Cell[4196, 146, 378, 9, 56, "Text",
      CellTags->{"S5.45.1", "1.7"}],
    Cell[4577, 157, 13021, 399, 186, "DefinitionBox",
      CellTags->"S5.45.1"],
    Cell[17601, 558, 125, 3, 70, "Caption",
      CellTags->"S5.45.1"],
    Cell[17729, 563, 8535, 261, 70, "DefinitionBox",
      CellTags->"S5.45.1"],
    Cell[26267, 826, 101, 3, 70, "Caption",
      CellTags->"S5.45.1"],
    Cell[26371, 831, 781, 19, 70, "Text",
      CellTags->{"S5.45.1", "1.8"}],
    Cell[27155, 852, 429, 9, 70, "Text",
      CellTags->{"S5.45.1", "1.9"}]},
  "1.1"->{
    Cell[1776, 53, 136, 6, 36, "Subsection",
      CellTags->{"S5.45.1", "1.1"}]},
  "1.2"->{
    Cell[1915, 61, 770, 16, 104, "Text",
      CellTags->{"S5.45.1", "1.2"}]},
  "1.3"->{
    Cell[2688, 79, 78, 1, 40, "MathCaption",
      CellTags->{"S5.45.1", "1.3"}]},
  "1.4"->{
    Cell[2858, 86, 132, 5, 40, "MathCaption",
      CellTags->{"S5.45.1", "1.4"}]},
  "1.5"->{
    Cell[3344, 111, 196, 5, 40, "MathCaption",
      CellTags->{"S5.45.1", "1.5"}]},
  "1.6"->{
    Cell[3768, 129, 91, 1, 40, "MathCaption",
      CellTags->{"S5.45.1", "1.6"}]},
  "1.7"->{
    Cell[4196, 146, 378, 9, 56, "Text",
      CellTags->{"S5.45.1", "1.7"}]},
  "1.8"->{
    Cell[26371, 831, 781, 19, 70, "Text",
      CellTags->{"S5.45.1", "1.8"}]},
  "1.9"->{
    Cell[27155, 852, 429, 9, 70, "Text",
      CellTags->{"S5.45.1", "1.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.45.1", 28223, 880},
  {"1.1", 29747, 921},
  {"1.2", 29841, 924},
  {"1.3", 29931, 927},
  {"1.4", 30025, 930},
  {"1.5", 30120, 933},
  {"1.6", 30216, 936},
  {"1.7", 30311, 939},
  {"1.8", 30400, 942},
  {"1.9", 30491, 945}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 136, 6, 36, "Subsection",
  CellTags->{"S5.45.1", "1.1"}],
Cell[1915, 61, 770, 16, 104, "Text",
  CellTags->{"S5.45.1", "1.2"}],
Cell[2688, 79, 78, 1, 40, "MathCaption",
  CellTags->{"S5.45.1", "1.3"}],
Cell[2769, 82, 86, 2, 28, "Input",
  CellTags->"S5.45.1"],
Cell[2858, 86, 132, 5, 40, "MathCaption",
  CellTags->{"S5.45.1", "1.4"}],

Cell[CellGroupData[{
Cell[3015, 95, 129, 5, 45, "Input",
  CellTags->"S5.45.1"],
Cell[3147, 102, 182, 6, 25, "Output",
  CellTags->"S5.45.1"]
}, Open  ]],
Cell[3344, 111, 196, 5, 40, "MathCaption",
  CellTags->{"S5.45.1", "1.5"}],

Cell[CellGroupData[{
Cell[3565, 120, 95, 2, 28, "Input",
  CellTags->"S5.45.1"],
Cell[3663, 124, 90, 2, 25, "Output",
  CellTags->"S5.45.1"]
}, Open  ]],
Cell[3768, 129, 91, 1, 40, "MathCaption",
  CellTags->{"S5.45.1", "1.6"}],

Cell[CellGroupData[{
Cell[3884, 134, 74, 2, 28, "Input",
  CellTags->"S5.45.1"],
Cell[3961, 138, 220, 5, 51, "Print",
  CellTags->"S5.45.1"]
}, Open  ]],
Cell[4196, 146, 378, 9, 56, "Text",
  CellTags->{"S5.45.1", "1.7"}],
Cell[4577, 157, 13021, 399, 186, "DefinitionBox",
  CellTags->"S5.45.1"],
Cell[17601, 558, 125, 3, 70, "Caption",
  CellTags->"S5.45.1"],
Cell[17729, 563, 8535, 261, 70, "DefinitionBox",
  CellTags->"S5.45.1"],
Cell[26267, 826, 101, 3, 70, "Caption",
  CellTags->"S5.45.1"],
Cell[26371, 831, 781, 19, 70, "Text",
  CellTags->{"S5.45.1", "1.8"}],
Cell[27155, 852, 429, 9, 70, "Text",
  CellTags->{"S5.45.1", "1.9"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

