(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16924,        728]*)
(*NotebookOutlinePosition[     21549,        869]*)
(*  CellTagsIndexPosition[     21197,        851]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "DiscreteMath",
 StyleBox["`", "MB"],
 "Tree",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.22.1", "1.1"}],

Cell["\<\
This package introduces functions for creating, searching, and displaying \
trees represented as nested lists. Since trees are an efficient, basic tool \
for storing and manipulating data, the functions defined here are used in \
several other packages. \
\>", "Text",
 CellTags->{"S5.22.1", "1.2"}],

Cell["\<\
A tree is a standard data structure used in computer science and elsewhere \
for organizing information. Information in a tree is stored in nodes, \
starting with a root node and ending with terminal nodes called leaves. Nodes \
are linked to other nodes through branches. Leaves are nodes without any \
branches. The most common type of tree is the binary tree, in which each node \
has no more than two branches. \
\>", "Text",
 CellTags->{"S5.22.1", "1.3"}],

Cell[TextData[{
 "In this package, each node has the form ",
 StyleBox["{{", "MR"],
 StyleBox["expr", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["}, ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["branch",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["branch",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 ", where ",
 StyleBox["expr", "TI"],
 " is the information stored at the node, ",
 StyleBox["n", "TI"],
 " is a sequential number assigned to the node, and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["branch",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["branch",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are the branches associated with the node. A leaf is represented as ",
 StyleBox["{{", "MR"],
 StyleBox["expr", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["n", "TI"],
 StyleBox["}, {}, {}}", "MR"],
 " in which the branches are empty lists. "
}], "Text",
 CellTags->{"S5.22.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["MakeTree[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["create a tree containing the information in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["list", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TreeFind[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "return the position of the largest element less than or equal to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the list from which ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" was constructed ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.22.1"],

Cell["Generating and searching trees. ", "Caption",
 CellTags->"S5.22.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.22.1", "1.5"}],

Cell["<<DiscreteMath`Tree`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.22.1"],

Cell[TextData[{
 "Here is a simple tree with three nodes. Node number ",
 StyleBox["2", "MR"],
 " is the root node and contains the item ",
 StyleBox["e2", "MR"],
 ". The first branch is the node ",
 StyleBox["{{e1,", "MR"],
 " ",
 StyleBox["1},", "MR"],
 " ",
 StyleBox["{},", "MR"],
 " ",
 StyleBox["{}}", "MR"],
 " and the second branch is the node ",
 StyleBox["{{e3,", "MR"],
 " ",
 StyleBox["3},", "MR"],
 " ",
 StyleBox["{},", "MR"],
 " ",
 StyleBox["{}}", "MR"],
 ". Both of these nodes are leaves. "
}], "MathCaption",
 CellTags->{"S5.22.1", "1.6"}],

Cell[CellGroupData[{

Cell["MakeTree[{e1, e2, e3}]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.22.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.22.1"]
}, Open  ]],

Cell[TextData[{
 "Here is a tree with real values at the nodes. The root node contains the \
value ",
 StyleBox["5.46", "MR"],
 ", which is the median of the list. Other nodes are numbered in increasing \
order. "
}], "MathCaption",
 CellTags->{"S5.22.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
tree = MakeTree[{9.05, 6.48, 8.40, 5.46,
            2.43, 4.46, 2.03}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.22.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5.46`", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.43`", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2.03`", ",", "1"}], "}"}], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4.46`", ",", "3"}], "}"}], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"8.4`", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6.48`", ",", "5"}], "}"}], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"9.05`", ",", "7"}], "}"}], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.22.1"]
}, Open  ]],

Cell[TextData[{
 "This result indicates that node number ",
 StyleBox["5", "MR"],
 " contains the largest value less than or equal to ",
 StyleBox["6.5", "MR"],
 ". Equivalently, ",
 StyleBox["5", "MR"],
 " elements in the original list are smaller than ",
 StyleBox["6.5", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.22.1", "1.8"}],

Cell[CellGroupData[{

Cell["TreeFind[tree, 6.5]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.22.1"],

Cell[BoxData["5"], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.22.1"]
}, Open  ]],

Cell[TextData[{
 "A node number of ",
 StyleBox["0", "MR"],
 " is returned if all of the nodes are larger than the specified value. "
}], "MathCaption",
 CellTags->{"S5.22.1", "1.9"}],

Cell[CellGroupData[{

Cell["TreeFind[tree, 1.0]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.22.1"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.22.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["TreePlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["generate a graphical representation of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["tree", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ExprPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["generate a graphical representation of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" viewed as a tree ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.22.1"],

Cell["Graphical representations of trees. ", "Caption",
 CellTags->"S5.22.1"],

Cell[TextData[{
 "Graphical representations are very useful for understanding the structure \
of trees. The function ",
 StyleBox["TreePlot", "MR"],
 " produces a graphical representation of trees generated by ",
 StyleBox["MakeTree", "MR"],
 ". More generally, most ",
 StyleBox["Mathematica", "TI"],
 " expressions can be thought of as trees, with the head of an expression at \
each node and the arguments of expressions as branches. The function ",
 StyleBox["ExprPlot", "MR"],
 " generates a graphical representation of an expression viewed as a tree. "
}], "Text",
 CellTags->{"S5.22.1", "1.10"}],

Cell[TextData[{
 "Here is a graphical representation of a tree with ",
 StyleBox["10", "MR"],
 " nodes. "
}], "MathCaption",
 CellTags->{"S5.22.1", "1.11"}],

Cell[CellGroupData[{

Cell["TreePlot[MakeTree[Range[10]]]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.22.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.485367 0.271034 0.0147151 0.147151 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.21433 .01472 m
.7564 .01472 L
s
.21433 .01472 m
.21433 .16187 L
s
.7564 .01472 m
.7564 .16187 L
s
.08527 .16187 m
.3434 .16187 L
s
.08527 .16187 m
.08527 .30902 L
s
.3434 .16187 m
.3434 .30902 L
s
.02381 .30902 m
.14673 .30902 L
s
.02381 .30902 m
.02381 .45617 L
s
.14673 .30902 m
.14673 .45617 L
s
.28194 .30902 m
.40486 .30902 L
s
.28194 .30902 m
.28194 .45617 L
s
.40486 .30902 m
.40486 .45617 L
s
.37559 .45617 m
.43412 .45617 L
s
.37559 .45617 m
.37559 .60332 L
s
.43412 .45617 m
.43412 .60332 L
s
.62734 .16187 m
.88547 .16187 L
s
.62734 .16187 m
.62734 .30902 L
s
.88547 .16187 m
.88547 .30902 L
s
.56588 .30902 m
.6888 .30902 L
s
.56588 .30902 m
.56588 .45617 L
s
.6888 .30902 m
.6888 .45617 L
s
.65953 .45617 m
.71806 .45617 L
s
.65953 .45617 m
.65953 .60332 L
s
.71806 .45617 m
.71806 .60332 L
s
.82401 .30902 m
.94692 .30902 L
s
.82401 .30902 m
.82401 .45617 L
s
.94692 .30902 m
.94692 .45617 L
s
.91766 .45617 m
.97619 .45617 L
s
.91766 .45617 m
.91766 .60332 L
s
.97619 .45617 m
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.22.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.22.1"]
}, Open  ]],

Cell["\<\
Here is a similar plot of an expression containing nested functions. \
\>", "MathCaption",
 CellTags->{"S5.22.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
ExprPlot[f[g[x, y, z], g[x, y, h[x, y]],
 g[x, y]]]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.22.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.205479 0.0147151 0.196201 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.08904 .01472 m
.91096 .01472 L
s
.08904 .01472 m
.08904 .21092 L
s
.5 .01472 m
.5 .21092 L
s
.91096 .01472 m
.91096 .21092 L
s
.02381 .21092 m
.15427 .21092 L
s
.02381 .21092 m
.02381 .40712 L
s
.08904 .21092 m
.08904 .40712 L
s
.15427 .21092 m
.15427 .40712 L
s
.43477 .21092 m
.56523 .21092 L
s
.43477 .21092 m
.43477 .40712 L
s
.5 .21092 m
.5 .40712 L
s
.56523 .21092 m
.56523 .40712 L
s
.53417 .40712 m
.59629 .40712 L
s
.53417 .40712 m
.53417 .60332 L
s
.59629 .40712 m
.59629 .60332 L
s
.84573 .21092 m
.97619 .21092 L
s
.84573 .21092 m
.84573 .40712 L
s
.97619 .21092 m
.97619 .40712 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.22.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.22.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.22.1"->{
    Cell[1776, 53, 133, 6, 36, "Subsection",
      CellTags->{"S5.22.1", "1.1"}],
    Cell[1912, 61, 309, 6, 56, "Text",
      CellTags->{"S5.22.1", "1.2"}],
    Cell[2224, 69, 470, 8, 88, "Text",
      CellTags->{"S5.22.1", "1.3"}],
    Cell[2697, 79, 1341, 47, 72, "Text",
      CellTags->{"S5.22.1", "1.4"}],
    Cell[4041, 128, 2392, 75, 84, "DefinitionBox",
      CellTags->"S5.22.1"],
    Cell[6436, 205, 73, 1, 15, "Caption",
      CellTags->"S5.22.1"],
    Cell[6512, 208, 78, 1, 40, "MathCaption",
      CellTags->{"S5.22.1", "1.5"}],
    Cell[6593, 211, 83, 2, 28, "Input",
      CellTags->"S5.22.1"],
    Cell[6679, 215, 558, 23, 72, "MathCaption",
      CellTags->{"S5.22.1", "1.6"}],
    Cell[7262, 242, 85, 2, 28, "Input",
      CellTags->"S5.22.1"],
    Cell[7350, 246, 489, 18, 25, "Output",
      CellTags->"S5.22.1"],
    Cell[7854, 267, 263, 7, 52, "MathCaption",
      CellTags->{"S5.22.1", "1.7"}],
    Cell[8142, 278, 142, 5, 45, "Input",
      CellTags->"S5.22.1"],
    Cell[8287, 285, 1093, 38, 70, "Output",
      CellTags->"S5.22.1"],
    Cell[9395, 326, 336, 11, 70, "MathCaption",
      CellTags->{"S5.22.1", "1.8"}],
    Cell[9756, 341, 82, 2, 70, "Input",
      CellTags->"S5.22.1"],
    Cell[9841, 345, 74, 2, 70, "Output",
      CellTags->"S5.22.1"],
    Cell[9930, 350, 183, 5, 70, "MathCaption",
      CellTags->{"S5.22.1", "1.9"}],
    Cell[10138, 359, 82, 2, 70, "Input",
      CellTags->"S5.22.1"],
    Cell[10223, 363, 74, 2, 70, "Output",
      CellTags->"S5.22.1"],
    Cell[10312, 368, 1961, 62, 70, "DefinitionBox",
      CellTags->"S5.22.1"],
    Cell[12276, 432, 77, 1, 70, "Caption",
      CellTags->"S5.22.1"],
    Cell[12356, 435, 602, 13, 70, "Text",
      CellTags->{"S5.22.1", "1.10"}],
    Cell[12961, 450, 156, 5, 70, "MathCaption",
      CellTags->{"S5.22.1", "1.11"}],
    Cell[13142, 459, 92, 2, 70, "Input",
      CellTags->"S5.22.1"],
    Cell[13237, 463, 1708, 132, 70, 1637, 129, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.22.1"],
    Cell[14948, 597, 180, 6, 70, "Output",
      CellTags->"S5.22.1"],
    Cell[15143, 606, 132, 3, 70, "MathCaption",
      CellTags->{"S5.22.1", "1.12"}],
    Cell[15300, 613, 122, 5, 70, "Input",
      CellTags->"S5.22.1"],
    Cell[15425, 620, 1288, 96, 70, 1217, 93, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.22.1"],
    Cell[16716, 718, 180, 6, 70, "Output",
      CellTags->"S5.22.1"]},
  "1.1"->{
    Cell[1776, 53, 133, 6, 36, "Subsection",
      CellTags->{"S5.22.1", "1.1"}]},
  "1.2"->{
    Cell[1912, 61, 309, 6, 56, "Text",
      CellTags->{"S5.22.1", "1.2"}]},
  "1.3"->{
    Cell[2224, 69, 470, 8, 88, "Text",
      CellTags->{"S5.22.1", "1.3"}]},
  "1.4"->{
    Cell[2697, 79, 1341, 47, 72, "Text",
      CellTags->{"S5.22.1", "1.4"}]},
  "1.5"->{
    Cell[6512, 208, 78, 1, 40, "MathCaption",
      CellTags->{"S5.22.1", "1.5"}]},
  "1.6"->{
    Cell[6679, 215, 558, 23, 72, "MathCaption",
      CellTags->{"S5.22.1", "1.6"}]},
  "1.7"->{
    Cell[7854, 267, 263, 7, 52, "MathCaption",
      CellTags->{"S5.22.1", "1.7"}]},
  "1.8"->{
    Cell[9395, 326, 336, 11, 70, "MathCaption",
      CellTags->{"S5.22.1", "1.8"}]},
  "1.9"->{
    Cell[9930, 350, 183, 5, 70, "MathCaption",
      CellTags->{"S5.22.1", "1.9"}]},
  "1.10"->{
    Cell[12356, 435, 602, 13, 70, "Text",
      CellTags->{"S5.22.1", "1.10"}]},
  "1.11"->{
    Cell[12961, 450, 156, 5, 70, "MathCaption",
      CellTags->{"S5.22.1", "1.11"}]},
  "1.12"->{
    Cell[15143, 606, 132, 3, 70, "MathCaption",
      CellTags->{"S5.22.1", "1.12"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.22.1", 17547, 744},
  {"1.1", 20051, 811},
  {"1.2", 20145, 814},
  {"1.3", 20233, 817},
  {"1.4", 20321, 820},
  {"1.5", 20411, 823},
  {"1.6", 20506, 826},
  {"1.7", 20603, 829},
  {"1.8", 20699, 832},
  {"1.9", 20796, 835},
  {"1.10", 20893, 838},
  {"1.11", 20986, 841},
  {"1.12", 21085, 844}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 133, 6, 36, "Subsection",
  CellTags->{"S5.22.1", "1.1"}],
Cell[1912, 61, 309, 6, 56, "Text",
  CellTags->{"S5.22.1", "1.2"}],
Cell[2224, 69, 470, 8, 88, "Text",
  CellTags->{"S5.22.1", "1.3"}],
Cell[2697, 79, 1341, 47, 72, "Text",
  CellTags->{"S5.22.1", "1.4"}],
Cell[4041, 128, 2392, 75, 84, "DefinitionBox",
  CellTags->"S5.22.1"],
Cell[6436, 205, 73, 1, 15, "Caption",
  CellTags->"S5.22.1"],
Cell[6512, 208, 78, 1, 40, "MathCaption",
  CellTags->{"S5.22.1", "1.5"}],
Cell[6593, 211, 83, 2, 28, "Input",
  CellTags->"S5.22.1"],
Cell[6679, 215, 558, 23, 72, "MathCaption",
  CellTags->{"S5.22.1", "1.6"}],

Cell[CellGroupData[{
Cell[7262, 242, 85, 2, 28, "Input",
  CellTags->"S5.22.1"],
Cell[7350, 246, 489, 18, 25, "Output",
  CellTags->"S5.22.1"]
}, Open  ]],
Cell[7854, 267, 263, 7, 52, "MathCaption",
  CellTags->{"S5.22.1", "1.7"}],

Cell[CellGroupData[{
Cell[8142, 278, 142, 5, 45, "Input",
  CellTags->"S5.22.1"],
Cell[8287, 285, 1093, 38, 70, "Output",
  CellTags->"S5.22.1"]
}, Open  ]],
Cell[9395, 326, 336, 11, 70, "MathCaption",
  CellTags->{"S5.22.1", "1.8"}],

Cell[CellGroupData[{
Cell[9756, 341, 82, 2, 70, "Input",
  CellTags->"S5.22.1"],
Cell[9841, 345, 74, 2, 70, "Output",
  CellTags->"S5.22.1"]
}, Open  ]],
Cell[9930, 350, 183, 5, 70, "MathCaption",
  CellTags->{"S5.22.1", "1.9"}],

Cell[CellGroupData[{
Cell[10138, 359, 82, 2, 70, "Input",
  CellTags->"S5.22.1"],
Cell[10223, 363, 74, 2, 70, "Output",
  CellTags->"S5.22.1"]
}, Open  ]],
Cell[10312, 368, 1961, 62, 70, "DefinitionBox",
  CellTags->"S5.22.1"],
Cell[12276, 432, 77, 1, 70, "Caption",
  CellTags->"S5.22.1"],
Cell[12356, 435, 602, 13, 70, "Text",
  CellTags->{"S5.22.1", "1.10"}],
Cell[12961, 450, 156, 5, 70, "MathCaption",
  CellTags->{"S5.22.1", "1.11"}],

Cell[CellGroupData[{
Cell[13142, 459, 92, 2, 70, "Input",
  CellTags->"S5.22.1"],
Cell[13237, 463, 1708, 132, 70, 1637, 129, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.22.1"],
Cell[14948, 597, 180, 6, 70, "Output",
  CellTags->"S5.22.1"]
}, Open  ]],
Cell[15143, 606, 132, 3, 70, "MathCaption",
  CellTags->{"S5.22.1", "1.12"}],

Cell[CellGroupData[{
Cell[15300, 613, 122, 5, 70, "Input",
  CellTags->"S5.22.1"],
Cell[15425, 620, 1288, 96, 70, 1217, 93, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.22.1"],
Cell[16716, 718, 180, 6, 70, "Output",
  CellTags->"S5.22.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

