(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10823,        386]*)
(*NotebookOutlinePosition[     14451,        499]*)
(*  CellTagsIndexPosition[     14147,        483]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "LinearAlgebra",
 StyleBox["`", "MB"],
 "Tridiagonal",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.50.1", "1.1"}],

Cell["\<\
There are many numerical techniques for working with matrices of specific \
forms. Often these routines are far more efficient than the general case. \
Frequently, the best way to get an efficient general routine is to reduce the \
problem systematically to a special case that can be solved efficiently. \
\>", "Text",
 CellTags->{"S5.50.1", "1.2"}],

Cell[TextData[{
 "In addition, special forms of matrices often come up naturally in solving \
certain classes of problems. One very useful special type of matrix is the ",
 StyleBox["tridiagonal", "TI"],
 ". In these matrices all elements are zero except for elements on the main, \
super\[Hyphen], and subdiagonal. More precisely, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["m",
      "TI"], 
     RowBox[{
      StyleBox["i",
       "TI"], ",", 
      StyleBox["j",
       "TI"]}]], "=", "0"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["i",
     "TI"], "-", 
    StyleBox["j",
     "TI"], "\[VerticalSeparator]", ">", "1"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Tridiagonal matrices occur in a wide variety of applications, such as the \
construction of certain splines and the solution of boundary value problems. \
"
}], "Text",
 CellTags->{"S5.50.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["TridiagonalSolve[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["c", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["r", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["] ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["solve the matrix equation ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["m",
          "TI"], ".", 
         StyleBox["x",
          "TI"], "=", 
         StyleBox["r",
          "TI"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["m",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " is tridiagonal with sub\[Hyphen], main, and superdiagonals given by \
the lists ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["a",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["b",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["c",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", respectively",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.50.1"],

Cell["Solving matrix equations with tridiagonal matrices. ", "Caption",
 CellTags->"S5.50.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.50.1", "1.4"}],

Cell["<<LinearAlgebra`Tridiagonal`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.50.1"],

Cell["\<\
This defines the list that will give the nonzero diagonals of a matrix. \
\>", "MathCaption",
 CellTags->{"S5.50.1", "1.5"}],

Cell[CellGroupData[{

Cell["\<\
{a, b, c} =
    {{7, 1, 11}, {4, 8, 2, 12}, {5, 9, 3}}\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.50.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "1", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8", ",", "2", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "9", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.50.1"]
}, Open  ]],

Cell[TextData[{
 "Here is the matrix ",
 StyleBox["m", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " constructed from the list. "
}], "MathCaption",
 CellTags->{"S5.50.1", "1.6"}],

Cell[CellGroupData[{

Cell["\<\
m = Table[Switch[
  j-i, -1, a[[j]], 0, b[[j]], 1,
  c[[j-1]], _, 0], {i, 4}, {j, 4}]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.50.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8", ",", "9", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "11", ",", "12"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.50.1"]
}, Open  ]],

Cell[TextData[{
 "This displays the matrix using ",
 StyleBox["MatrixForm", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.50.1", "1.7"}],

Cell[CellGroupData[{

Cell["MatrixForm[%]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.50.1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4", "5", "0", "0"},
     {"7", "8", "9", "0"},
     {"0", "1", "2", "3"},
     {"0", "0", "11", "12"}
     }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[4]//MatrixForm= ",
 CellTags->"S5.50.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the vector ",
 StyleBox["x", "MR"],
 " that solves the equation ",
 StyleBox["m.x", "MR"],
 " ",
 StyleBox["==", "MR"],
 " ",
 StyleBox["{2,", "MR"],
 " ",
 StyleBox["3,", "MR"],
 " ",
 StyleBox["4,", "MR"],
 " ",
 StyleBox["5}", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.50.1", "1.8"}],

Cell[CellGroupData[{

Cell["TridiagonalSolve[a, b, c, {2, 3, 4, 5}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.50.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["28", "9"]}], ",", 
   FractionBox["26", "9"], ",", 
   FractionBox["5", "27"], ",", 
   FractionBox["20", "81"]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.50.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["TridiagonalSolve", "MR"],
 " uses Gaussian elimination and back substitution. No pivoting is done. If a \
pivot happens to be zero, this introduces an ",
 StyleBox["Infinity", "MR"],
 ". If the matrix is diagonally dominate, which is the case in certain \
applications, no pivoting is necessary. "
}], "Text",
 CellTags->{"S5.50.1", "1.9"}],

Cell["\<\
You can solve equations containing real and complex numbers as well as \
symbolic quantities. \
\>", "MathCaption",
 CellTags->{"S5.50.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
TridiagonalSolve[
  {2.2, 5.2},
  {4.3, 3.22, 2.1},
  {8.1 + I, 3.4},
  {1, 2.3 I , 3}]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.50.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.8856781544585755`"}], "+", 
    RowBox[{"0.3913128820828248`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"0.5594584105515094`", "\[InvisibleSpace]"}], "-", 
    RowBox[{"0.2768029387046489`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"0.043245840539119375`", "\[InvisibleSpace]"}], "+", 
    RowBox[{"0.6854168006019867`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.50.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.50.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.50.1", "1.1"}],
    Cell[1920, 61, 360, 6, 56, "Text",
      CellTags->{"S5.50.1", "1.2"}],
    Cell[2283, 69, 1070, 32, 88, "Text",
      CellTags->{"S5.50.1", "1.3"}],
    Cell[3356, 103, 3202, 100, 82, "DefinitionBox",
      CellTags->"S5.50.1"],
    Cell[6561, 205, 93, 1, 15, "Caption",
      CellTags->"S5.50.1"],
    Cell[6657, 208, 78, 1, 40, "MathCaption",
      CellTags->{"S5.50.1", "1.4"}],
    Cell[6738, 211, 91, 2, 28, "Input",
      CellTags->"S5.50.1"],
    Cell[6832, 215, 134, 3, 40, "MathCaption",
      CellTags->{"S5.50.1", "1.5"}],
    Cell[6991, 222, 125, 5, 45, "Input",
      CellTags->"S5.50.1"],
    Cell[7119, 229, 318, 10, 25, "Output",
      CellTags->"S5.50.1"],
    Cell[7452, 242, 200, 7, 40, "MathCaption",
      CellTags->{"S5.50.1", "1.6"}],
    Cell[7677, 253, 156, 6, 62, "Input",
      CellTags->"S5.50.1"],
    Cell[7836, 261, 417, 12, 25, "Output",
      CellTags->"S5.50.1"],
    Cell[8268, 276, 138, 5, 40, "MathCaption",
      CellTags->{"S5.50.1", "1.7"}],
    Cell[8431, 285, 76, 2, 70, "Input",
      CellTags->"S5.50.1"],
    Cell[8510, 289, 322, 11, 70, "Output",
      CellTags->"S5.50.1"],
    Cell[8847, 303, 321, 17, 70, "MathCaption",
      CellTags->{"S5.50.1", "1.8"}],
    Cell[9193, 324, 102, 2, 70, "Input",
      CellTags->"S5.50.1"],
    Cell[9298, 328, 252, 9, 70, "Output",
      CellTags->"S5.50.1"],
    Cell[9565, 340, 367, 8, 70, "Text",
      CellTags->{"S5.50.1", "1.9"}],
    Cell[9935, 350, 157, 4, 70, "MathCaption",
      CellTags->{"S5.50.1", "1.10"}],
    Cell[10117, 358, 158, 8, 70, "Input",
      CellTags->"S5.50.1"],
    Cell[10278, 368, 517, 14, 70, "Output",
      CellTags->"S5.50.1"]},
  "1.1"->{
    Cell[1776, 53, 141, 6, 36, "Subsection",
      CellTags->{"S5.50.1", "1.1"}]},
  "1.2"->{
    Cell[1920, 61, 360, 6, 56, "Text",
      CellTags->{"S5.50.1", "1.2"}]},
  "1.3"->{
    Cell[2283, 69, 1070, 32, 88, "Text",
      CellTags->{"S5.50.1", "1.3"}]},
  "1.4"->{
    Cell[6657, 208, 78, 1, 40, "MathCaption",
      CellTags->{"S5.50.1", "1.4"}]},
  "1.5"->{
    Cell[6832, 215, 134, 3, 40, "MathCaption",
      CellTags->{"S5.50.1", "1.5"}]},
  "1.6"->{
    Cell[7452, 242, 200, 7, 40, "MathCaption",
      CellTags->{"S5.50.1", "1.6"}]},
  "1.7"->{
    Cell[8268, 276, 138, 5, 40, "MathCaption",
      CellTags->{"S5.50.1", "1.7"}]},
  "1.8"->{
    Cell[8847, 303, 321, 17, 70, "MathCaption",
      CellTags->{"S5.50.1", "1.8"}]},
  "1.9"->{
    Cell[9565, 340, 367, 8, 70, "Text",
      CellTags->{"S5.50.1", "1.9"}]},
  "1.10"->{
    Cell[9935, 350, 157, 4, 70, "MathCaption",
      CellTags->{"S5.50.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.50.1", 11446, 402},
  {"1.1", 13194, 449},
  {"1.2", 13288, 452},
  {"1.3", 13376, 455},
  {"1.4", 13466, 458},
  {"1.5", 13561, 461},
  {"1.6", 13657, 464},
  {"1.7", 13753, 467},
  {"1.8", 13849, 470},
  {"1.9", 13946, 473},
  {"1.10", 14036, 476}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 141, 6, 36, "Subsection",
  CellTags->{"S5.50.1", "1.1"}],
Cell[1920, 61, 360, 6, 56, "Text",
  CellTags->{"S5.50.1", "1.2"}],
Cell[2283, 69, 1070, 32, 88, "Text",
  CellTags->{"S5.50.1", "1.3"}],
Cell[3356, 103, 3202, 100, 82, "DefinitionBox",
  CellTags->"S5.50.1"],
Cell[6561, 205, 93, 1, 15, "Caption",
  CellTags->"S5.50.1"],
Cell[6657, 208, 78, 1, 40, "MathCaption",
  CellTags->{"S5.50.1", "1.4"}],
Cell[6738, 211, 91, 2, 28, "Input",
  CellTags->"S5.50.1"],
Cell[6832, 215, 134, 3, 40, "MathCaption",
  CellTags->{"S5.50.1", "1.5"}],

Cell[CellGroupData[{
Cell[6991, 222, 125, 5, 45, "Input",
  CellTags->"S5.50.1"],
Cell[7119, 229, 318, 10, 25, "Output",
  CellTags->"S5.50.1"]
}, Open  ]],
Cell[7452, 242, 200, 7, 40, "MathCaption",
  CellTags->{"S5.50.1", "1.6"}],

Cell[CellGroupData[{
Cell[7677, 253, 156, 6, 62, "Input",
  CellTags->"S5.50.1"],
Cell[7836, 261, 417, 12, 25, "Output",
  CellTags->"S5.50.1"]
}, Open  ]],
Cell[8268, 276, 138, 5, 40, "MathCaption",
  CellTags->{"S5.50.1", "1.7"}],

Cell[CellGroupData[{
Cell[8431, 285, 76, 2, 70, "Input",
  CellTags->"S5.50.1"],
Cell[8510, 289, 322, 11, 70, "Output",
  CellTags->"S5.50.1"]
}, Open  ]],
Cell[8847, 303, 321, 17, 70, "MathCaption",
  CellTags->{"S5.50.1", "1.8"}],

Cell[CellGroupData[{
Cell[9193, 324, 102, 2, 70, "Input",
  CellTags->"S5.50.1"],
Cell[9298, 328, 252, 9, 70, "Output",
  CellTags->"S5.50.1"]
}, Open  ]],
Cell[9565, 340, 367, 8, 70, "Text",
  CellTags->{"S5.50.1", "1.9"}],
Cell[9935, 350, 157, 4, 70, "MathCaption",
  CellTags->{"S5.50.1", "1.10"}],

Cell[CellGroupData[{
Cell[10117, 358, 158, 8, 70, "Input",
  CellTags->"S5.50.1"],
Cell[10278, 368, 517, 14, 70, "Output",
  CellTags->"S5.50.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

