(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21842,        746]*)
(*NotebookOutlinePosition[     25587,        861]*)
(*  CellTagsIndexPosition[     25283,        845]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "NumericalMath",
 StyleBox["`", "MB"],
 "TrigFit",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.94.1", "1.1"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " function ",
 StyleBox["Fit", "MR"],
 " does linear least\[Hyphen]squares fitting to data. It allows any \
combination of basis functions. However, it is often the case that you want \
to do trigonometric fitting and it would be easier if you did not have to \
explicitly list the basis functions ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", 
     RowBox[{"2", 
      StyleBox["x",
       "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     RowBox[{"2", 
      StyleBox["x",
       "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". ",
 StyleBox["TrigFit", "MR"],
 " does this for you. "
}], "Text",
 CellTags->{"S5.94.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["TrigFit[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the least\[Hyphen]squares trigonometric fit to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" up to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"cos", 
         RowBox[{"(", 
          StyleBox[
           RowBox[{"n", "x"}],
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"sin", 
         RowBox[{"(", 
          StyleBox[
           RowBox[{"n", "x"}],
           "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", with fundamental period ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"2", "\[Pi]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TrigFit[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["L", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the least\[Hyphen]squares trigonometric fit to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" up to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"cos", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["n",
            "TI"], 
           StyleBox["x",
            "TI"], "/", 
           StyleBox["L",
            "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"sin", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["n",
            "TI"], 
           StyleBox["x",
            "TI"], "/", 
           StyleBox["L",
            "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", with fundamental period ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["L",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["TrigFit[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["n", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["x",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the least\[Hyphen]squares trigonometric fit to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["data", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" up to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"cos", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["n",
            "TI"], 
           RowBox[{"(", 
            RowBox[{
             StyleBox["x",
              "TI"], "-", 
             SubscriptBox[
              StyleBox["x",
               "TI"], "0"]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox[
              StyleBox["x",
               "TI"], "1"], "-", 
             SubscriptBox[
              StyleBox["x",
               "TI"], "0"]}], ")"}]}], ")"}]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"sin", 
         RowBox[{"(", 
          RowBox[{"2", "\[Pi]", 
           StyleBox["n",
            "TI"], 
           RowBox[{"(", 
            RowBox[{
             StyleBox["x",
              "TI"], "-", 
             SubscriptBox[
              StyleBox["x",
               "TI"], "0"]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox[
              StyleBox["x",
               "TI"], "1"], "-", 
             SubscriptBox[
              StyleBox["x",
               "TI"], "0"]}], ")"}]}], ")"}]}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", with fundamental period ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["x",
           "TI"], "1"], "-", 
         SubscriptBox[
          StyleBox["x",
           "TI"], "0"]}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.94.1"],

Cell["Fitting trigonometric series to data. ", "Caption",
 CellTags->"S5.94.1"],

Cell[TextData[{
 StyleBox["TrigFit", "MR"],
 " uses the function ",
 StyleBox["Fourier", "MR"],
 " to quickly find a least\[Hyphen]squares trigonometric fit to the data. In \
doing so it completely avoids casting the problem in terms of an \
overdetermined linear system and instead directly constructs the solution. It \
should be pointed out, however, that because ",
 StyleBox["TrigFit", "MR"],
 " is based on ",
 StyleBox["Fourier", "MR"],
 ", it must assume that the data come from equally spaced sample points and \
that the data cover exactly one period of a periodic function. Because of \
this restriction it was decided that ",
 StyleBox["TrigFit", "MR"],
 " should not accept data in the form of ordered pairs. It thus only accepts \
a list of numbers, which are assumed to be sampled with spacing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["period",
     "TI"], "/", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 StyleBox["period", "TI"],
 " is the period of the function and ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the number of elements in ",
 StyleBox["data", "TI"],
 ". Note that the first datum corresponds to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (default value 0). Because the function in question is assumed to be \
periodic, the first datum also corresponds to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (or ",
 Cell[BoxData[
  FormBox[
   StyleBox["L",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " if ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x",
     "TI"], "0"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is not specified) and the last datum corresponds to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["x",
      "TI"], "1"], "-", 
    StyleBox["p",
     "TI"], 
    StyleBox["e",
     "TI"], 
    StyleBox["r",
     "TI"], 
    StyleBox["i",
     "TI"], 
    StyleBox["o",
     "TI"], 
    StyleBox["d",
     "TI"], "/", 
    StyleBox["n",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.94.1", "1.3"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.94.1", "1.4"}],

Cell["<<NumericalMath`TrigFit`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.94.1"],

Cell[TextData[{
 "Start with some data. Note that the last datum is given by the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", "\[Pi]"}], "-", 
    RowBox[{"2", 
     RowBox[{"\[Pi]", "/", "7"}]}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", not ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.94.1", "1.5"}],

Cell["\<\
data = Table[1+2Sin[x]+3Cos[2x]+4 Sin[3x],
          {x, 0, 2Pi-2Pi/7, 2Pi/7}];\
\>", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.94.1"],

Cell["Find the constant term. ", "MathCaption",
 CellTags->{"S5.94.1", "1.6"}],

Cell[CellGroupData[{

Cell["TrigFit[data, 0, x]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.94.1"],

Cell[BoxData["1.0000000000000004`"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.94.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the least\[Hyphen]squares fit including only the fundamental \
frequency. Here you specify the period to be ",
 Cell[BoxData[
  FormBox[
   StyleBox["L",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " rather than the default of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.94.1", "1.7"}],

Cell[CellGroupData[{

Cell["TrigFit[data, 1, {x, L}]", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.94.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"1.0000000000000004`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"0.`", " ", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"2", " ", "\[Pi]", " ", "x"}], "L"], "]"}]}], "+", 
  RowBox[{"2.0000000000000004`", " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"2", " ", "\[Pi]", " ", "x"}], "L"], "]"}]}]}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.94.1"]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 StyleBox["Fit", "MR"],
 " to do the fitting, but it is slower and less convenient. "
}], "MathCaption",
 CellTags->{"S5.94.1", "1.8"}],

Cell[CellGroupData[{

Cell["\<\
Fit[Transpose[{Range[0, 2Pi-2Pi/7, 2Pi/7], data}],
             {1, Cos[x], Sin[x]}, x]\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.94.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"1.0000000000000004`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"3.83446314438503`*^-16", " ", 
   RowBox[{"Cos", "[", "x", "]"}]}], "+", 
  RowBox[{"2.0000000000000004`", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.94.1"]
}, Open  ]],

Cell[TextData[{
 "This gives the least\[Hyphen]squares fit including the first 3 overtones. \
In this case you have specified that the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["x",
       "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["x",
       "TI"], "1"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the interval covered by the data. "
}], "MathCaption",
 CellTags->{"S5.94.1", "1.9"}],

Cell[CellGroupData[{

Cell["TrigFit[data, 3, {x, x0, x1}]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.94.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"1.0000000000000004`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"0.`", " ", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"2", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x1"}]], "]"}]}], "+", 
  RowBox[{"3.000000000000001`", " ", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"4", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x1"}]], "]"}]}], "-", 
  RowBox[{"4.440892098500626`*^-16", " ", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"6", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x1"}]], "]"}]}], "+", 
  RowBox[{"2.0000000000000004`", " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"2", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x1"}]], "]"}]}], "+", 
  RowBox[{"0.`", " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"4", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x1"}]], "]"}]}], "+", 
  RowBox[{"4.`", " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"6", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x1"}]], "]"}]}]}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.94.1"]
}, Open  ]],

Cell[TextData[{
 "As with ",
 StyleBox["Fit", "MR"],
 ", it is often useful to discard the small terms using ",
 StyleBox["Chop", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.94.1", "1.10"}],

Cell[CellGroupData[{

Cell["Chop[%]", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.94.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"1.0000000000000004`", "\[InvisibleSpace]"}], "+", 
  RowBox[{"3.000000000000001`", " ", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"4", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x1"}]], "]"}]}], "+", 
  RowBox[{"2.0000000000000004`", " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"2", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x1"}]], "]"}]}], "+", 
  RowBox[{"4.`", " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"6", " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "x0"}], ")"}]}], 
     RowBox[{
      RowBox[{"-", "x0"}], "+", "x1"}]], "]"}]}]}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.94.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.94.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.94.1", "1.1"}],
    Cell[1916, 61, 1538, 55, 72, "Text",
      CellTags->{"S5.94.1", "1.2"}],
    Cell[3457, 118, 9429, 297, 192, "DefinitionBox",
      CellTags->"S5.94.1"],
    Cell[12889, 417, 79, 1, 15, "Caption",
      CellTags->"S5.94.1"],
    Cell[12971, 420, 2600, 87, 168, "Text",
      CellTags->{"S5.94.1", "1.3"}],
    Cell[15574, 509, 78, 1, 40, "MathCaption",
      CellTags->{"S5.94.1", "1.4"}],
    Cell[15655, 512, 87, 2, 28, "Input",
      CellTags->"S5.94.1"],
    Cell[15745, 516, 495, 16, 40, "MathCaption",
      CellTags->{"S5.94.1", "1.5"}],
    Cell[16243, 534, 150, 5, 45, "Input",
      CellTags->"S5.94.1"],
    Cell[16396, 541, 78, 1, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.6"}],
    Cell[16499, 546, 82, 2, 70, "Input",
      CellTags->"S5.94.1"],
    Cell[16584, 550, 92, 2, 70, "Output",
      CellTags->"S5.94.1"],
    Cell[16691, 555, 499, 15, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.7"}],
    Cell[17215, 574, 87, 2, 70, "Input",
      CellTags->"S5.94.1"],
    Cell[17305, 578, 412, 12, 70, "Output",
      CellTags->"S5.94.1"],
    Cell[17732, 593, 168, 5, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.8"}],
    Cell[17925, 602, 158, 5, 70, "Input",
      CellTags->"S5.94.1"],
    Cell[18086, 609, 305, 8, 70, "Output",
      CellTags->"S5.94.1"],
    Cell[18406, 620, 509, 16, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.9"}],
    Cell[18940, 640, 92, 2, 70, "Input",
      CellTags->"S5.94.1"],
    Cell[19035, 644, 1599, 52, 70, "Output",
      CellTags->"S5.94.1"],
    Cell[20649, 699, 193, 7, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.10"}],
    Cell[20867, 710, 70, 2, 70, "Input",
      CellTags->"S5.94.1"],
    Cell[20940, 714, 874, 28, 70, "Output",
      CellTags->"S5.94.1"]},
  "1.1"->{
    Cell[1776, 53, 137, 6, 36, "Subsection",
      CellTags->{"S5.94.1", "1.1"}]},
  "1.2"->{
    Cell[1916, 61, 1538, 55, 72, "Text",
      CellTags->{"S5.94.1", "1.2"}]},
  "1.3"->{
    Cell[12971, 420, 2600, 87, 168, "Text",
      CellTags->{"S5.94.1", "1.3"}]},
  "1.4"->{
    Cell[15574, 509, 78, 1, 40, "MathCaption",
      CellTags->{"S5.94.1", "1.4"}]},
  "1.5"->{
    Cell[15745, 516, 495, 16, 40, "MathCaption",
      CellTags->{"S5.94.1", "1.5"}]},
  "1.6"->{
    Cell[16396, 541, 78, 1, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.6"}]},
  "1.7"->{
    Cell[16691, 555, 499, 15, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.7"}]},
  "1.8"->{
    Cell[17732, 593, 168, 5, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.8"}]},
  "1.9"->{
    Cell[18406, 620, 509, 16, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.9"}]},
  "1.10"->{
    Cell[20649, 699, 193, 7, 70, "MathCaption",
      CellTags->{"S5.94.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.94.1", 22465, 762},
  {"1.1", 24310, 811},
  {"1.2", 24404, 814},
  {"1.3", 24494, 817},
  {"1.4", 24587, 820},
  {"1.5", 24683, 823},
  {"1.6", 24781, 826},
  {"1.7", 24877, 829},
  {"1.8", 24975, 832},
  {"1.9", 25072, 835},
  {"1.10", 25171, 838}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 137, 6, 36, "Subsection",
  CellTags->{"S5.94.1", "1.1"}],
Cell[1916, 61, 1538, 55, 72, "Text",
  CellTags->{"S5.94.1", "1.2"}],
Cell[3457, 118, 9429, 297, 192, "DefinitionBox",
  CellTags->"S5.94.1"],
Cell[12889, 417, 79, 1, 15, "Caption",
  CellTags->"S5.94.1"],
Cell[12971, 420, 2600, 87, 168, "Text",
  CellTags->{"S5.94.1", "1.3"}],
Cell[15574, 509, 78, 1, 40, "MathCaption",
  CellTags->{"S5.94.1", "1.4"}],
Cell[15655, 512, 87, 2, 28, "Input",
  CellTags->"S5.94.1"],
Cell[15745, 516, 495, 16, 40, "MathCaption",
  CellTags->{"S5.94.1", "1.5"}],
Cell[16243, 534, 150, 5, 45, "Input",
  CellTags->"S5.94.1"],
Cell[16396, 541, 78, 1, 70, "MathCaption",
  CellTags->{"S5.94.1", "1.6"}],

Cell[CellGroupData[{
Cell[16499, 546, 82, 2, 70, "Input",
  CellTags->"S5.94.1"],
Cell[16584, 550, 92, 2, 70, "Output",
  CellTags->"S5.94.1"]
}, Open  ]],
Cell[16691, 555, 499, 15, 70, "MathCaption",
  CellTags->{"S5.94.1", "1.7"}],

Cell[CellGroupData[{
Cell[17215, 574, 87, 2, 70, "Input",
  CellTags->"S5.94.1"],
Cell[17305, 578, 412, 12, 70, "Output",
  CellTags->"S5.94.1"]
}, Open  ]],
Cell[17732, 593, 168, 5, 70, "MathCaption",
  CellTags->{"S5.94.1", "1.8"}],

Cell[CellGroupData[{
Cell[17925, 602, 158, 5, 70, "Input",
  CellTags->"S5.94.1"],
Cell[18086, 609, 305, 8, 70, "Output",
  CellTags->"S5.94.1"]
}, Open  ]],
Cell[18406, 620, 509, 16, 70, "MathCaption",
  CellTags->{"S5.94.1", "1.9"}],

Cell[CellGroupData[{
Cell[18940, 640, 92, 2, 70, "Input",
  CellTags->"S5.94.1"],
Cell[19035, 644, 1599, 52, 70, "Output",
  CellTags->"S5.94.1"]
}, Open  ]],
Cell[20649, 699, 193, 7, 70, "MathCaption",
  CellTags->{"S5.94.1", "1.10"}],

Cell[CellGroupData[{
Cell[20867, 710, 70, 2, 70, "Input",
  CellTags->"S5.94.1"],
Cell[20940, 714, 874, 28, 70, "Output",
  CellTags->"S5.94.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

