(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     71919,       2095]*)
(*NotebookOutlinePosition[     79832,       2320]*)
(*  CellTagsIndexPosition[     79517,       2304]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "Units",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.62.1", "1.1"}],

Cell[TextData[{
 "There are many systems of units. The particular set of units that is used \
depends on factors as various as the field of study and the author\
\[CloseCurlyQuote]s country of origin. The function ",
 StyleBox["Convert", "MR"],
 " provides conversion between different units. "
}], "Text",
 CellTags->{"S5.62.1", "1.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Convert[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["old", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["newunits", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["convert ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["old", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to a form involving a combination of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["newunits", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Converting units. ", "Caption",
 CellTags->"S5.62.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.62.1", "1.3"}],

Cell["<<Miscellaneous`Units`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.62.1"],

Cell["This converts meters per second into miles per hour. ", "MathCaption",
 CellTags->{"S5.62.1", "1.4"}],

Cell[CellGroupData[{

Cell["Convert[12 Meter/Second, Mile/Hour]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"37500", " ", "Mile"}], 
  RowBox[{"1397", " ", "Hour"}]]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.62.1"]
}, Open  ]],

Cell["You have to give prefixes for units as separate words. ", "MathCaption",
 CellTags->{"S5.62.1", "1.5"}],

Cell[CellGroupData[{

Cell["Convert[3 Kilo Meter / Hour, Inch / Minute]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"250000", " ", "Inch"}], 
  RowBox[{"127", " ", "Minute"}]]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.62.1"]
}, Open  ]],

Cell[TextData[{
 "The conversion of temperature units is different from most other unit \
conversions, because it is not multiplicative. This is simply because the \
zeros of various systems are set at different values. For example, zero \
degrees Centigrade is the same as ",
 Cell[BoxData[
  FormBox["32", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees Fahrenheit. "
}], "Text",
 CellTags->{"S5.62.1", "1.6"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ConvertTemperature[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["temp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["oldunits", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["newunits", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["convert ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["temp", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" from the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["oldunits", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" scale to the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["newunits", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" scale",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Converting temperatures. ", "Caption",
 CellTags->"S5.62.1"],

Cell[TextData[{
 "This converts the temperature. ",
 StyleBox["Convert", "MR"],
 " only converts the units of temperature. "
}], "MathCaption",
 CellTags->{"S5.62.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
ConvertTemperature[20, Fahrenheit,
        Centigrade]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.62.1"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["20", "3"]}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.62.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Celsius",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Centigrade",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Fahrenheit",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kelvin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Rankine",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Temperature scales.", "Caption",
 CellTags->"S5.62.1"],

Cell[TextData[{
 "To organize the use of units, certain standardized systems have been \
developed. These include the International System (SI) and systems using \
particular metric units, such as the meter/kilogram/second system. The \
functions ",
 StyleBox["SI", "MR"],
 ", ",
 StyleBox["MKS", "MR"],
 ", and ",
 StyleBox["CGS", "MR"],
 " convert various units into the standard systems. "
}], "Text",
 CellTags->{"S5.62.1", "1.8"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["SI[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["convert ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to SI units (International System)",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["MKS[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["convert ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to MKS units (meter/kilogram/second)",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CGS[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["convert ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["expr", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to CGS units (centimeter/gram/second)",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Conversion of units into standard systems. ", "Caption",
 CellTags->"S5.62.1"],

Cell["The International Standard unit for pressure is the Pascal. ", \
"MathCaption",
 CellTags->{"S5.62.1", "1.9"}],

Cell[CellGroupData[{

Cell["SI[3 Atmosphere]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.62.1"],

Cell[BoxData[
 RowBox[{"303975.`", " ", "Pascal"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.62.1"]
}, Open  ]],

Cell["You can request information about any unit. ", "MathCaption",
 CellTags->{"S5.62.1", "1.10"}],

Cell[CellGroupData[{

Cell["?Pascal", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.62.1"],

Cell[BoxData["\<\"Pascal is the derived SI unit of pressure.\"\>"], "Print",
 CellTags->"S5.62.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Yocto", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "24"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Deca", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "1"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Zepto", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "21"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Hecto", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "2"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Atto", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "18"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kilo", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "3"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Femto", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "15"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mega", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "6"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Pico", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "12"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Giga", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "9"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Nano", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tera", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "12"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Micro", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Peta", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "15"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Milli", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "3"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Exa", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "18"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Centi", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "2"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Zetta", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "21"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Deci", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "1"}]], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Yotta", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[Cell[BoxData[
      FormBox[
       SuperscriptBox["10", "24"], TraditionalForm]], "InlineFormula",
      GridBoxOptions->{ColumnWidths->Automatic}],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox4Col",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["SI unit prefixes.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Abampere",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Abcoulomb",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Abfarad",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Abhenry",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Abmho",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Abohm",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Abvolt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Amp",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Biot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Coulomb",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Farad",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Gilbert",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Henry",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mho",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Ohm",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Siemens",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Statampere",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Statcoulomb",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Statfarad",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Stathenry",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Statohm",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Statvolt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Volt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Electrical units.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["AU",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bolt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cable",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Caliber",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Centimeter",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Chain",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cicero",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Cubit",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Didot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["DidotPoint",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Ell",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Fathom",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Feet",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Fermi",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Foot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Furlong",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Hand",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Inch",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["League",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["LightYear",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Link",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Meter",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Micron",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mil",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Mile",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["NauticalMile",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Parsec",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Perch",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Pica",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Point",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Pole",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PrintersPoint",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Rod",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Rope",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Skein",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Span",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Stadion",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Stadium",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["StatuteMile",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SurveyMile",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["XUnit",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Yard",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of length.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Baud",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bit",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Byte",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Nibble",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of information.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Century",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Day",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Decade",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Fortnight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Hour",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Millennium",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Minute",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Month",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Second",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SiderealSecond",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SiderealYear",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["TropicalYear",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Week",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Year",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of time.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["AMU",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["AtomicMassUnit",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Dalton",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Geepound",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Gram",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kilogram",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MetricTon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Quintal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Slug",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["SolarMass",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tonne",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of mass.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["AssayTon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["AvoirdupoisOunce",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["AvoirdupoisPound",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bale",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Carat",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Cental",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Drachma",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Grain",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GrossHundredweight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Hundredweight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Libra",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mina",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NetHundredweight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Obolos",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Ounce",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Pennyweight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Pondus",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Pound",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Shekel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ShortHundredweight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ShortTon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Stone",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Talent",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ton",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TroyOunce",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Wey",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of weight.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Dyne",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["GramWeight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["KilogramForce",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["KilogramWeight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Newton",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Poundal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["PoundForce",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["PoundWeight",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["TonForce",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of force.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Diopter",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kayser",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of inverse length.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Bag",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Barrel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["BoardFoot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bucket",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Bushel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Butt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cord",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Cup",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Drop",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ephah",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Fifth",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Firkin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["FluidDram",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["FluidOunce",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Gallon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Gill",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Hogshead",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Jeroboam",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Jigger",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Last",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Liter",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Magnum",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Minim",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Noggin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Omer",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Pint",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Pony",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Puncheon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Quart",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RegisterTon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Seam",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Shot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Stere",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tablespoon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Teaspoon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tun",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["UKGallon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UKPint",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["WineBottle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of volume.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Poise",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Reyn",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Rhes",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Stokes",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of viscosity.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Apostilb",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Candela",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Candle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["FootCandle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Hefner",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lambert",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Lumen",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lumerg",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Lux",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Nit",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Phot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Stilb",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Talbot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of types of luminous energy and intensity.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Becquerel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Curie",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["GrayDose",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Rad",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Roentgen",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Rontgen",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Rutherford",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of radiation.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["ArcMinute",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ArcSecond",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Circle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Degree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Grade",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Quadrant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Radian",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RightAngle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Steradian",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Angles.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["ChevalVapeur",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Horsepower",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Watt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of power.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Acre",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Are",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Barn",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Hectare",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Rood",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Section",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Township",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of area.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Dozen",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Gross",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Mole",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Amounts of substances.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Gal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Gravity",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Acceleration due to gravity.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["BohrMagneton",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Gauss",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Gamma",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Maxwell",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NuclearMagneton",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Oersted",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tesla",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Weber",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Magnetic units.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["ArcSecond",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["BakersDozen",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Circle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Degree",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Dozen",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Grade",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Gross",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Percent",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Quadrant",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["RightAngle",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Unit multipliers.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Atmosphere",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bar",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Barye",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["InchMercury",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["MillimeterMercury",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Pascal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Torr",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of pressure.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["BritishThermalUnit",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["BTU",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Calorie",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ElectronVolt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Erg",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Joule",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Rydberg",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Therm",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Units of energy.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Hertz",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Unit of frequency.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Knot",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Unit of speed.", "Caption",
 CellTags->"S5.62.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Denier",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.62.1"],

Cell["Unit of fineness for yarn or thread.", "Caption",
 CellTags->"S5.62.1"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.62.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.62.1", "1.1"}],
    Cell[1914, 61, 337, 7, 56, "Text",
      CellTags->{"S5.62.1", "1.2"}],
    Cell[2254, 70, 1366, 43, 46, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[3623, 115, 59, 1, 15, "Caption",
      CellTags->"S5.62.1"],
    Cell[3685, 118, 78, 1, 40, "MathCaption",
      CellTags->{"S5.62.1", "1.3"}],
    Cell[3766, 121, 85, 2, 28, "Input",
      CellTags->"S5.62.1"],
    Cell[3854, 125, 107, 1, 40, "MathCaption",
      CellTags->{"S5.62.1", "1.4"}],
    Cell[3986, 130, 98, 2, 28, "Input",
      CellTags->"S5.62.1"],
    Cell[4087, 134, 153, 5, 40, "Output",
      CellTags->"S5.62.1"],
    Cell[4255, 142, 109, 1, 40, "MathCaption",
      CellTags->{"S5.62.1", "1.5"}],
    Cell[4389, 147, 106, 2, 28, "Input",
      CellTags->"S5.62.1"],
    Cell[4498, 151, 155, 5, 40, "Output",
      CellTags->"S5.62.1"],
    Cell[4668, 159, 457, 10, 56, "Text",
      CellTags->{"S5.62.1", "1.6"}],
    Cell[5128, 171, 1842, 58, 64, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[6973, 231, 66, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[7042, 234, 174, 5, 41, "MathCaption",
      CellTags->{"S5.62.1", "1.7"}],
    Cell[7241, 243, 125, 5, 51, "Input",
      CellTags->"S5.62.1"],
    Cell[7369, 250, 113, 4, 38, "Output",
      CellTags->"S5.62.1"],
    Cell[7497, 257, 1050, 29, 86, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[8550, 288, 60, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[8613, 291, 435, 12, 76, "Text",
      CellTags->{"S5.62.1", "1.8"}],
    Cell[9051, 305, 2820, 90, 86, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[11874, 397, 84, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[11961, 400, 116, 2, 41, "MathCaption",
      CellTags->{"S5.62.1", "1.9"}],
    Cell[12102, 406, 79, 2, 31, "Input",
      CellTags->"S5.62.1"],
    Cell[12184, 410, 108, 3, 25, "Output",
      CellTags->"S5.62.1"],
    Cell[12307, 416, 99, 1, 41, "MathCaption",
      CellTags->{"S5.62.1", "1.10"}],
    Cell[12431, 421, 70, 2, 31, "Input",
      CellTags->"S5.62.1"],
    Cell[12504, 425, 98, 1, 21, "Print",
      CellTags->"S5.62.1"],
    Cell[12617, 429, 10003, 246, 234, "DefinitionBox4Col",
      CellTags->"S5.62.1"],
    Cell[22623, 677, 58, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[22684, 680, 4093, 110, 276, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[26780, 792, 58, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[26841, 795, 7269, 195, 464, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[34113, 992, 57, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[34173, 995, 850, 24, 66, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[35026, 1021, 62, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[35091, 1024, 2565, 69, 170, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[37659, 1095, 55, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[37717, 1098, 2065, 56, 150, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[39785, 1156, 55, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[39843, 1159, 4633, 123, 296, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[44479, 1284, 57, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[44539, 1287, 1745, 47, 128, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[46287, 1336, 56, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[46346, 1339, 520, 15, 44, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[46869, 1356, 65, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[46937, 1359, 6784, 182, 444, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[53724, 1543, 57, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[53784, 1546, 852, 24, 66, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[54639, 1572, 60, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[54702, 1575, 2390, 65, 170, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[57095, 1642, 89, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[57187, 1645, 1386, 38, 108, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[58576, 1685, 60, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[58639, 1688, 1730, 47, 128, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[60372, 1737, 48, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[60423, 1740, 710, 20, 66, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[61136, 1762, 56, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[61195, 1765, 1373, 38, 108, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[62571, 1805, 55, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[62629, 1808, 698, 20, 66, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[63330, 1830, 63, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[63396, 1833, 517, 15, 44, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[63916, 1850, 69, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[63988, 1853, 1546, 42, 108, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[65537, 1897, 56, 1, 17, "Caption",
      CellTags->"S5.62.1"],
    Cell[65596, 1900, 1883, 51, 70, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[67482, 1953, 58, 1, 70, "Caption",
      CellTags->"S5.62.1"],
    Cell[67543, 1956, 1392, 38, 70, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[68938, 1996, 59, 1, 70, "Caption",
      CellTags->"S5.62.1"],
    Cell[69000, 1999, 1545, 42, 70, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[70548, 2043, 57, 1, 70, "Caption",
      CellTags->"S5.62.1"],
    Cell[70608, 2046, 363, 11, 70, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[70974, 2059, 59, 1, 70, "Caption",
      CellTags->"S5.62.1"],
    Cell[71036, 2062, 362, 11, 70, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[71401, 2075, 55, 1, 70, "Caption",
      CellTags->"S5.62.1"],
    Cell[71459, 2078, 364, 11, 70, "DefinitionBox",
      CellTags->"S5.62.1"],
    Cell[71826, 2091, 77, 1, 70, "Caption",
      CellTags->"S5.62.1"]},
  "1.1"->{
    Cell[1776, 53, 135, 6, 36, "Subsection",
      CellTags->{"S5.62.1", "1.1"}]},
  "1.2"->{
    Cell[1914, 61, 337, 7, 56, "Text",
      CellTags->{"S5.62.1", "1.2"}]},
  "1.3"->{
    Cell[3685, 118, 78, 1, 40, "MathCaption",
      CellTags->{"S5.62.1", "1.3"}]},
  "1.4"->{
    Cell[3854, 125, 107, 1, 40, "MathCaption",
      CellTags->{"S5.62.1", "1.4"}]},
  "1.5"->{
    Cell[4255, 142, 109, 1, 40, "MathCaption",
      CellTags->{"S5.62.1", "1.5"}]},
  "1.6"->{
    Cell[4668, 159, 457, 10, 56, "Text",
      CellTags->{"S5.62.1", "1.6"}]},
  "1.7"->{
    Cell[7042, 234, 174, 5, 41, "MathCaption",
      CellTags->{"S5.62.1", "1.7"}]},
  "1.8"->{
    Cell[8613, 291, 435, 12, 76, "Text",
      CellTags->{"S5.62.1", "1.8"}]},
  "1.9"->{
    Cell[11961, 400, 116, 2, 41, "MathCaption",
      CellTags->{"S5.62.1", "1.9"}]},
  "1.10"->{
    Cell[12307, 416, 99, 1, 41, "MathCaption",
      CellTags->{"S5.62.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.62.1", 72542, 2111},
  {"1.1", 78563, 2270},
  {"1.2", 78657, 2273},
  {"1.3", 78745, 2276},
  {"1.4", 78840, 2279},
  {"1.5", 78936, 2282},
  {"1.6", 79032, 2285},
  {"1.7", 79122, 2288},
  {"1.8", 79218, 2291},
  {"1.9", 79308, 2294},
  {"1.10", 79406, 2297}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 135, 6, 36, "Subsection",
  CellTags->{"S5.62.1", "1.1"}],
Cell[1914, 61, 337, 7, 56, "Text",
  CellTags->{"S5.62.1", "1.2"}],
Cell[2254, 70, 1366, 43, 46, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[3623, 115, 59, 1, 15, "Caption",
  CellTags->"S5.62.1"],
Cell[3685, 118, 78, 1, 40, "MathCaption",
  CellTags->{"S5.62.1", "1.3"}],
Cell[3766, 121, 85, 2, 28, "Input",
  CellTags->"S5.62.1"],
Cell[3854, 125, 107, 1, 40, "MathCaption",
  CellTags->{"S5.62.1", "1.4"}],

Cell[CellGroupData[{
Cell[3986, 130, 98, 2, 28, "Input",
  CellTags->"S5.62.1"],
Cell[4087, 134, 153, 5, 40, "Output",
  CellTags->"S5.62.1"]
}, Open  ]],
Cell[4255, 142, 109, 1, 40, "MathCaption",
  CellTags->{"S5.62.1", "1.5"}],

Cell[CellGroupData[{
Cell[4389, 147, 106, 2, 28, "Input",
  CellTags->"S5.62.1"],
Cell[4498, 151, 155, 5, 40, "Output",
  CellTags->"S5.62.1"]
}, Open  ]],
Cell[4668, 159, 457, 10, 56, "Text",
  CellTags->{"S5.62.1", "1.6"}],
Cell[5128, 171, 1842, 58, 64, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[6973, 231, 66, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[7042, 234, 174, 5, 41, "MathCaption",
  CellTags->{"S5.62.1", "1.7"}],

Cell[CellGroupData[{
Cell[7241, 243, 125, 5, 51, "Input",
  CellTags->"S5.62.1"],
Cell[7369, 250, 113, 4, 38, "Output",
  CellTags->"S5.62.1"]
}, Open  ]],
Cell[7497, 257, 1050, 29, 86, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[8550, 288, 60, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[8613, 291, 435, 12, 76, "Text",
  CellTags->{"S5.62.1", "1.8"}],
Cell[9051, 305, 2820, 90, 86, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[11874, 397, 84, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[11961, 400, 116, 2, 41, "MathCaption",
  CellTags->{"S5.62.1", "1.9"}],

Cell[CellGroupData[{
Cell[12102, 406, 79, 2, 31, "Input",
  CellTags->"S5.62.1"],
Cell[12184, 410, 108, 3, 25, "Output",
  CellTags->"S5.62.1"]
}, Open  ]],
Cell[12307, 416, 99, 1, 41, "MathCaption",
  CellTags->{"S5.62.1", "1.10"}],

Cell[CellGroupData[{
Cell[12431, 421, 70, 2, 31, "Input",
  CellTags->"S5.62.1"],
Cell[12504, 425, 98, 1, 21, "Print",
  CellTags->"S5.62.1"]
}, Open  ]],
Cell[12617, 429, 10003, 246, 234, "DefinitionBox4Col",
  CellTags->"S5.62.1"],
Cell[22623, 677, 58, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[22684, 680, 4093, 110, 276, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[26780, 792, 58, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[26841, 795, 7269, 195, 464, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[34113, 992, 57, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[34173, 995, 850, 24, 66, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[35026, 1021, 62, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[35091, 1024, 2565, 69, 170, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[37659, 1095, 55, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[37717, 1098, 2065, 56, 150, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[39785, 1156, 55, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[39843, 1159, 4633, 123, 296, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[44479, 1284, 57, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[44539, 1287, 1745, 47, 128, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[46287, 1336, 56, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[46346, 1339, 520, 15, 44, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[46869, 1356, 65, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[46937, 1359, 6784, 182, 444, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[53724, 1543, 57, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[53784, 1546, 852, 24, 66, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[54639, 1572, 60, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[54702, 1575, 2390, 65, 170, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[57095, 1642, 89, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[57187, 1645, 1386, 38, 108, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[58576, 1685, 60, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[58639, 1688, 1730, 47, 128, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[60372, 1737, 48, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[60423, 1740, 710, 20, 66, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[61136, 1762, 56, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[61195, 1765, 1373, 38, 108, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[62571, 1805, 55, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[62629, 1808, 698, 20, 66, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[63330, 1830, 63, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[63396, 1833, 517, 15, 44, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[63916, 1850, 69, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[63988, 1853, 1546, 42, 108, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[65537, 1897, 56, 1, 17, "Caption",
  CellTags->"S5.62.1"],
Cell[65596, 1900, 1883, 51, 70, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[67482, 1953, 58, 1, 70, "Caption",
  CellTags->"S5.62.1"],
Cell[67543, 1956, 1392, 38, 70, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[68938, 1996, 59, 1, 70, "Caption",
  CellTags->"S5.62.1"],
Cell[69000, 1999, 1545, 42, 70, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[70548, 2043, 57, 1, 70, "Caption",
  CellTags->"S5.62.1"],
Cell[70608, 2046, 363, 11, 70, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[70974, 2059, 59, 1, 70, "Caption",
  CellTags->"S5.62.1"],
Cell[71036, 2062, 362, 11, 70, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[71401, 2075, 55, 1, 70, "Caption",
  CellTags->"S5.62.1"],
Cell[71459, 2078, 364, 11, 70, "DefinitionBox",
  CellTags->"S5.62.1"],
Cell[71826, 2091, 77, 1, 70, "Caption",
  CellTags->"S5.62.1"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

