(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    100450,       2802]*)
(*NotebookOutlinePosition[    121808,       3426]*)
(*  CellTagsIndexPosition[    119670,       3341]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["6.16 ", "HeadingNumber"],
 "*"
}], "Section",
 CellTags->{"S6.16.0", "0.1"}],

Cell[TextData[{
 "Appendix: How ",
 StyleBox["Mathematica", "TI"],
 " Packages Are Set Up "
}], "Text",
 CellTags->{"S6.16.0", "0.2"}],

Cell[TextData[{
 "This appendix discusses package contexts, loading packages, autoloading \
packages, and naming packages. Contexts in ",
 StyleBox["Mathematica", "TI"],
 " allow you to use the same symbol names for several different functions and \
to load and autoload packages in a system\[Hyphen]independent way. The \
discussion is illustrated using the standard add\[Hyphen]on packages, but it \
also applies to the ",
 StyleBox["Mathematica", "TI"],
 " Applications Library packages and ",
 StyleBox["Mathematica", "TI"],
 " packages you write and share with colleagues. The appendix concludes with \
a discussion of how to use the standard add\[Hyphen]on packages as building \
blocks for your own packages. "
}], "Text",
 CellTags->{"S6.16.0", "0.3"}],

Cell[CellGroupData[{

Cell["Contexts", "Subsection",
 CellTags->{"S6.16.1", "1.1"}],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica", "TI"],
 "\[ThinSpace]the mechanism of contexts is used to keep package symbols \
separate from symbols in the main session. The basic idea is that the ",
 StyleBox["full name", "TI"],
 " of any symbol is broken into two parts: a ",
 StyleBox["context", "TI"],
 " and a ",
 StyleBox["short name", "TI"],
 ". The full name is written as ",
 StyleBox["context", "TI"],
 StyleBox["`", "MR"],
 StyleBox["short", "TI"],
 ", where ",
 StyleBox["`", "MR"],
 " is the backquote or grave accent character, called a context mark in ",
 StyleBox["Mathematica", "TI"],
 ". "
}], "Text",
 CellTags->{"S6.16.1", "1.2"}],

Cell[TextData[{
 "Contexts in ",
 StyleBox["Mathematica", "TI"],
 " work somewhat like file directories in many operating systems. You can \
always specify a particular file by giving its complete name, including its \
directory. But at any given point, there is usually a current working \
directory, analogous to the current ",
 StyleBox["Mathematica", "TI"],
 " context. Variables that are in the current context can be specified just \
by giving their short names in the same way that files in the current working \
directory can be specified by just giving their short names. The global \
variable ",
 StyleBox["$Context", "MR"],
 " gives the current ",
 StyleBox["Mathematica", "TI"],
 " context. "
}], "Text",
 CellTags->{"S6.16.1", "1.3"}],

Cell[TextData[{
 "As is also the case with directories, contexts in ",
 StyleBox["Mathematica", "TI"],
 " can be hierarchical. For example, the full name of a symbol can involve a \
sequence of context names, as in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["`", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["`", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c",
     "TI"], "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["`", "MR"],
 StyleBox["name", "TI"],
 ". By convention, the symbols that are created by loading a standard ",
 StyleBox["Mathematica", "TI"],
 " package have a context whose name is related to the name of the package. \
As an example, loading the package ",
 StyleBox["Statistics`DescriptiveStatistics`", "MR"],
 " defines the symbol ",
 StyleBox["Statistics`DescriptiveStatistics`Skewness", "MR"],
 ", which you can then use to compute the skewness of a list of data. "
}], "Text",
 CellTags->{"S6.16.1", "1.4"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["<<", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["context", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["read in a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Mathematica", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" package corresponding to the specified context ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["<<", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["` \[Ellipsis]  `", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["c",
          "TI"], 
         StyleBox["n",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["read in a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Mathematica", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" package corresponding to a hierarchical context ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.16.1"],

Cell[TextData[{
 "Using contexts to specify a ",
 StyleBox["Mathematica", "SO"],
 " package. "
}], "Caption",
 CellTags->"S6.16.1"],

Cell["\<\
This loads a package for calculating descriptive statistics. \
\>", "MathCaption",
 CellTags->{"S6.16.1", "1.5"}],

Cell["<<Statistics`DescriptiveStatistics`", "Input",
 CellLabel->"In[1]:=",
 CellTags->"S6.16.1"],

Cell[TextData[{
 "The symbol ",
 StyleBox["Skewness", "MR"],
 " is in the context set up by the package. "
}], "MathCaption",
 CellTags->{"S6.16.1", "1.6"}],

Cell[CellGroupData[{

Cell["Context[Skewness]", "Input",
 CellLabel->"In[2]:=",
 CellTags->"S6.16.1"],

Cell[BoxData["\<\"Statistics`DescriptiveStatistics`\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellTags->"S6.16.1"]
}, Open  ]],

Cell["You can refer to the symbol using its short name. ", "MathCaption",
 CellTags->{"S6.16.1", "1.7"}],

Cell[CellGroupData[{

Cell["Skewness[{1., 2., 3., 4.}]", "Input",
 CellLabel->"In[3]:=",
 CellTags->"S6.16.1"],

Cell[BoxData["0.`"], "Output",
 CellLabel->"Out[3]=",
 CellTags->"S6.16.1"]
}, Open  ]],

Cell[TextData[{
 "The full names of symbols defined in packages can be quite long. In most \
cases, you will only need to use their short names. However, if two symbols \
with the same short name appear in two different packages, ",
 StyleBox["Mathematica", "TI"],
 " must decide which symbol to use. The decision is made using a list of \
contexts called the ",
 StyleBox["context search path", "TI"],
 ". The global variable ",
 StyleBox["$ContextPath", "MR"],
 " gives this list of contexts. "
}], "Text",
 CellTags->{"S6.16.1", "1.8"}],

Cell[TextData[{
 "When you type in a short name for a symbol, ",
 StyleBox["Mathematica", "TI"],
 " assumes that you want the symbol with that name whose context appears \
earliest in the context search path. As a result, symbols with the same short \
name whose contexts appear later in the context search path are effectively \
shadowed. To refer to these symbols, you need to use their full names. In \
such a case, ",
 StyleBox["Mathematica", "TI"],
 " will warn you when you read in the package that creates the overlap in \
short names. It will tell you which symbols will be shadowed by the new \
symbols that are being introduced. "
}], "Text",
 CellTags->{"S6.16.1", "1.9"}],

Cell["\<\
This reads in a package that contains specifications for various colors. \
\>", "MathCaption",
 CellTags->{"S6.16.1", "1.10"}],

Cell["<<Graphics`Colors`", "Input",
 CellLabel->"In[4]:=",
 CellTags->"S6.16.1"],

Cell[TextData[{
 "Warning messages are generated because symbols with the short name, such as \
",
 StyleBox["Gold", "MR"],
 ", occur in both packages we have loaded. "
}], "MathCaption",
 CellTags->{"S6.16.1", "1.11"}],

Cell[CellGroupData[{

Cell["<<Miscellaneous`ChemicalElements`", "Input",
 CellLabel->"In[5]:=",
 CellTags->"S6.16.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Titanium", "::", "\<\"shdw\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Symbol \\!\\(\\\"Titanium\\\"\\) appears in multiple \
contexts \\!\\({\\\"Miscellaneous`ChemicalElements`\\\", \\\"Graphics`Colors`\
\\\"}\\); definitions in context \
\\!\\(\\\"Miscellaneous`ChemicalElements`\\\"\\) may shadow or be shadowed by \
other definitions. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::shdw\\\"]\\)\"\>"}]], "Message",
 CellLabel->"From In[5]:=",
 CellTags->"S6.16.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cobalt", "::", "\<\"shdw\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Symbol \\!\\(\\\"Cobalt\\\"\\) appears in multiple \
contexts \\!\\({\\\"Miscellaneous`ChemicalElements`\\\", \\\"Graphics`Colors`\
\\\"}\\); definitions in context \
\\!\\(\\\"Miscellaneous`ChemicalElements`\\\"\\) may shadow or be shadowed by \
other definitions. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::shdw\\\"]\\)\"\>"}]], "Message",
 CellLabel->"From In[5]:=",
 CellTags->"S6.16.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Zinc", "::", "\<\"shdw\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Symbol \\!\\(\\\"Zinc\\\"\\) appears in multiple contexts \
\\!\\({\\\"Miscellaneous`ChemicalElements`\\\", \\\"Graphics`Colors`\\\"}\\); \
definitions in context \\!\\(\\\"Miscellaneous`ChemicalElements`\\\"\\) may \
shadow or be shadowed by other definitions. \\!\\(\\*ButtonBox[\\\"More\
\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::shdw\\\"]\\)\"\>"}]], "Message",
 CellLabel->"From In[5]:=",
 CellTags->"S6.16.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gold", "::", "\<\"shdw\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Symbol \\!\\(\\\"Gold\\\"\\) appears in multiple contexts \
\\!\\({\\\"Miscellaneous`ChemicalElements`\\\", \\\"Graphics`Colors`\\\"}\\); \
definitions in context \\!\\(\\\"Miscellaneous`ChemicalElements`\\\"\\) may \
shadow or be shadowed by other definitions. \\!\\(\\*ButtonBox[\\\"More\
\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::shdw\\\"]\\)\"\>"}]], "Message",
 CellLabel->"From In[5]:=",
 CellTags->"S6.16.1"]
}, Open  ]],

Cell[TextData[{
 "You can use the full name to distinguish between the two uses of ",
 StyleBox["Gold", "MR"],
 ". This gives a color specification. "
}], "MathCaption",
 CellTags->{"S6.16.1", "1.12"}],

Cell[CellGroupData[{

Cell["?Graphics`Colors`Gold", "Input",
 CellLabel->"In[6]:=",
 CellTags->"S6.16.1"],

Cell[BoxData[
 RowBox[{"\<\"Gold is a color given in the RGBColor system.\"\>", " ", 
  ButtonBox[
   StyleBox["More\[Ellipsis]",
    "SR"],
   Active->True,
   ButtonStyle->"AddOnsLink",
   ButtonData->"Graphics`Colors`"]}]], "Print",
 CellTags->{"Info3288981920-3960949", "S6.16.1"}]
}, Open  ]],

Cell["This gives the chemical element. ", "MathCaption",
 CellTags->{"S6.16.1", "1.13"}],

Cell[CellGroupData[{

Cell["?Miscellaneous`ChemicalElements`Gold", "Input",
 CellLabel->"In[7]:=",
 CellTags->"S6.16.1"],

Cell[BoxData[
 RowBox[{"\<\"Gold is a chemical element.\"\>", " ", 
  ButtonBox[
   StyleBox["More\[Ellipsis]",
    "SR"],
   Active->True,
   ButtonStyle->"AddOnsLink",
   ButtonData->"Miscellaneous`ChemicalElements`"]}]], "Print",
 CellTags->{"Info3288981920-6339177", "S6.16.1"}]
}, Open  ]],

Cell[TextData[{
 "Conflicts can occur not only between symbols in different packages, but \
also between symbols in packages and symbols that you introduce directly in \
your ",
 StyleBox["Mathematica", "TI"],
 " session. If you define a symbol in your current context, then this symbol \
will shadow any other symbol with the same short name in packages that you \
read in. The reason for this is that ",
 StyleBox["Mathematica", "TI"],
 " always searches for symbols in the current context before looking in \
contexts on the context search path. "
}], "Text",
 CellTags->{"S6.16.1", "1.14"}],

Cell[TextData[{
 StyleBox["$Context", "MR"],
 " is a global variable that gives the current context. The default context \
for ",
 StyleBox["Mathematica", "TI"],
 " sessions is ",
 StyleBox["Global`", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.16.1", "1.15"}],

Cell[CellGroupData[{

Cell["$Context", "Input",
 CellLabel->"In[8]:=",
 CellTags->"S6.16.1"],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellLabel->"Out[8]=",
 CellTags->"S6.16.1"]
}, Open  ]],

Cell[TextData[{
 "This defines a function ",
 StyleBox["Div", "MR"],
 " in the current context ",
 StyleBox["Global`", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.16.1", "1.16"}],

Cell["Div[f_] := 1/f", "Input",
 CellLabel->"In[9]:=",
 CellTags->"S6.16.1"],

Cell[TextData[{
 "Any other functions with the short name ",
 StyleBox["Div", "MR"],
 " will be shadowed by the one in your current context. "
}], "MathCaption",
 CellTags->{"S6.16.1", "1.17"}],

Cell[CellGroupData[{

Cell["<<Calculus`VectorAnalysis`", "Input",
 CellLabel->"In[10]:=",
 CellTags->"S6.16.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Div", "::", "\<\"shdw\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Symbol \\!\\(\\\"Div\\\"\\) appears in multiple contexts \
\\!\\({\\\"Calculus`VectorAnalysis`\\\", \\\"Global`\\\"}\\); definitions in \
context \\!\\(\\\"Calculus`VectorAnalysis`\\\"\\) may shadow or be shadowed \
by other definitions. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::shdw\\\"]\\)\"\>"}]], "Message",
 CellLabel->"From In[10]:=",
 CellTags->"S6.16.1"]
}, Open  ]],

Cell[TextData[{
 "This removes ",
 StyleBox["Div", "MR"],
 " completely from the current context. "
}], "MathCaption",
 CellTags->{"S6.16.1", "1.18"}],

Cell["Remove[Div]", "Input",
 CellLabel->"In[11]:=",
 CellTags->"S6.16.1"],

Cell[TextData[{
 "Now the ",
 StyleBox["Div", "MR"],
 " from the package is used. It computes the divergence of a given vector \
field in the Cartesian coordinate system. "
}], "MathCaption",
 CellTags->{"S6.16.1", "1.19"}],

Cell[CellGroupData[{

Cell["Div[{x, y^2, x}, Cartesian[x, y, z]]", "Input",
 CellLabel->"In[12]:=",
 CellTags->"S6.16.1"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "y"}]}]], "Output",
 CellLabel->"Out[12]=",
 CellTags->"S6.16.1"]
}, Open  ]],

Cell[TextData[{
 "Many ",
 StyleBox["Mathematica", "TI"],
 " users choose to load their favorite packages automatically at start\
\[Hyphen]up, and autoloading is discussed later in this section. If you \
autoload your packages at start\[Hyphen]up, you will not need to be concerned \
about using a package function in a ",
 StyleBox["Mathematica", "TI"],
 " session before actually reading in the package. If you mistakenly \
introduce a package function and do not apply ",
 StyleBox["Remove", "MR"],
 " to the function before loading the package, ",
 StyleBox["Mathematica", "TI"],
 " will warn you that the package function is being shadowed. ",
 StyleBox["Mathematica", "TI"],
 " will use your version of the function, rather than the one from the \
package. Applying ",
 StyleBox["Remove", "MR"],
 " after the package is loaded will remove your version of the function and \
allow you to use the package definition for the function. "
}], "Text",
 CellTags->{"S6.16.1", "1.20"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Remove[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\"]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "remove a function that has been introduced in error",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.16.1"],

Cell[TextData[{
 "Making sure that ",
 StyleBox["Mathematica", "SO"],
 " uses correct definitions from packages."
}], "Caption",
 CellTags->"S6.16.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading Packages", "Subsection",
 CellTags->{"S6.16.2", "2.1"}],

Cell[TextData[{
 "Contexts in ",
 StyleBox["Mathematica", "TI"],
 " are used to specify packages in a way that is independent of the \
particular computer system being used. From this point of view, loading a \
package is simply a way of making a particular context available. The global \
variable ",
 StyleBox["$Packages", "MR"],
 " gives a list of the contexts corresponding to all the packages that have \
been loaded in your current ",
 StyleBox["Mathematica", "TI"],
 " session. "
}], "Text",
 CellTags->{"S6.16.2", "2.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["<<", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["context", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" \[ThinSpace]or \[ThinSpace]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Get[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["context", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`\"]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["read in a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Mathematica", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" package corresponding to the specified context ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Needs[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["context", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`\"]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "read in the package if the specified context is not already in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["$Packages", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DeclarePackage[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["context", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`\", {\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["name",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\", \"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["name",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\", \[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["declare that ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Needs[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["context", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`\"]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[
      " should be automatically executed if a symbol with any of the names ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox["\[Null]", 
         StyleBox["i",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is used",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.16.2"],

Cell["Ways to load packages. ", "Caption",
 CellTags->"S6.16.2"],

Cell[TextData[{
 "You have already seen how to explicitly read in a package using the command \
",
 StyleBox["<<", "MR"],
 StyleBox["context", "TI"],
 StyleBox["`", "MR"],
 ", or equivalently, ",
 StyleBox["Get[\"", "MR"],
 StyleBox["context", "TI"],
 StyleBox["`\"]", "MR"],
 ". Often, however, you will want to read in a particular package only if it \
is needed. The command ",
 StyleBox["Needs[\"", "MR"],
 StyleBox["context", "TI"],
 StyleBox["`\"]", "MR"],
 " tells ",
 StyleBox["Mathematica", "TI"],
 " to read in a package if the context associated with that package is not \
already in the list ",
 StyleBox["$Packages", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.16.2", "2.3"}],

Cell[TextData[{
 "Some packages are not designed to be loaded twice and large packages may \
take a while to load. You should use ",
 StyleBox["Needs", "MR"],
 " if you are unsure whether you have loaded a particular package in your \
current session. Some packages are set up so that when they are loaded, other \
related packages are automatically loaded at the same time. Packages may have \
been loaded that you haven\[CloseCurlyQuote]t explicitly read in, so it is \
best to let ",
 StyleBox["Mathematica", "TI"],
 " decide which packages need loading. "
}], "Text",
 CellTags->{"S6.16.2", "2.4"}],

Cell[TextData[{
 "When you set up a large collection of ",
 StyleBox["Mathematica", "TI"],
 " packages, it is a good idea to create an initialization package or names \
file that contains a sequence of ",
 StyleBox["DeclarePackage", "MR"],
 " commands, specifying packages to load when particular names are used. \
Within a particular ",
 StyleBox["Mathematica", "TI"],
 " session, you then need to load explicitly only the initialization package. \
When you have done this, all the other packages will automatically be loaded \
if and when they are needed. Initialization packages and autoloading packages \
via the ",
 StyleBox["Autoload", "MR"],
 " directory are discussed in detail in the next section. "
}], "Text",
 CellTags->{"S6.16.2", "2.5"}],

Cell[TextData[{
 "The package context list initially contains only the ",
 StyleBox["Global`", "MR"],
 " and ",
 StyleBox["System`", "MR"],
 " contexts. Usually new symbols are introduced in the context ",
 StyleBox["Global`", "MR"],
 ". Built\[Hyphen]in symbols are in the context ",
 StyleBox["System`", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.16.2", "2.6"}],

Cell[CellGroupData[{

Cell["$Packages", "Input",
 CellLabel->"In[13]:=",
 CellTags->"S6.16.2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Calculus`VectorAnalysis`\"\>", 
   ",", "\<\"Miscellaneous`SIUnits`\"\>", ",", "\<\"Miscellaneous`Units`\"\>",
    ",", "\<\"Miscellaneous`ChemicalElements`\"\>", 
   ",", "\<\"Graphics`Colors`\"\>", ",", "\<\"DiscreteMath`Tree`\"\>", 
   ",", "\<\"Statistics`DataManipulation`\"\>", 
   ",", "\<\"Statistics`DescriptiveStatistics`\"\>", 
   ",", "\<\"GraphEdit`\"\>", ",", "\<\"Global`\"\>", 
   ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[13]=",
 CellTags->"S6.16.2"]
}, Open  ]],

Cell[TextData[{
 "This specifies that the symbols ",
 StyleBox["Div", "MR"],
 ", ",
 StyleBox["Grad", "MR"],
 ", and ",
 StyleBox["Curl", "MR"],
 " are defined in ",
 StyleBox["Calculus`VectorAnalysis`", "MR"],
 ". Now ",
 StyleBox["Needs[\"Calculus`VectorAnalysis`\"]", "MR"],
 " will be executed if any of these symbols are used. "
}], "MathCaption",
 CellTags->{"S6.16.2", "2.7"}],

Cell["\<\
DeclarePackage[\"Calculus`VectorAnalysis`\",
 {\"Div\", \"Grad\", \"Curl\"}]\
\>", "Input",
 CellLabel->"In[14]:=",
 CellTags->"S6.16.2"],

Cell[TextData[{
 "When you first use ",
 StyleBox["Grad", "MR"],
 ", ",
 StyleBox["Mathematica", "TI"],
 " automatically loads the package ",
 StyleBox["Calculus`VectorAnalysis`", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.16.2", "2.8"}],

Cell[CellGroupData[{

Cell["Grad[x^2 + y^2, Cartesian[x, y, z]]", "Input",
 CellLabel->"In[15]:=",
 CellTags->"S6.16.2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{"2", " ", "y"}], ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[15]=",
 CellTags->"S6.16.2"]
}, Open  ]],

Cell[TextData[{
 "The package\[CloseCurlyQuote]s context has been prepended to ",
 StyleBox["$Packages", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.16.2", "2.9"}],

Cell[CellGroupData[{

Cell["$Packages", "Input",
 CellLabel->"In[16]:=",
 CellTags->"S6.16.2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Calculus`VectorAnalysis`\"\>", 
   ",", "\<\"Miscellaneous`SIUnits`\"\>", ",", "\<\"Miscellaneous`Units`\"\>",
    ",", "\<\"Miscellaneous`ChemicalElements`\"\>", 
   ",", "\<\"Graphics`Colors`\"\>", ",", "\<\"DiscreteMath`Tree`\"\>", 
   ",", "\<\"Statistics`DataManipulation`\"\>", 
   ",", "\<\"Statistics`DescriptiveStatistics`\"\>", 
   ",", "\<\"GraphEdit`\"\>", ",", "\<\"Global`\"\>", 
   ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[16]=",
 CellTags->"S6.16.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Autoloading Packages", "Subsection",
 CellTags->{"S6.16.3", "3.1"}],

Cell[TextData[{
 "Explicit loading of packages is useful if you are trying to minimize the \
amount of memory used by your ",
 StyleBox["Mathematica", "TI"],
 " session or if you are in an early stage of package development. However, \
most users find that they use a particular set of packages often, and they \
want those packages to load automatically. "
}], "Text",
 CellTags->{"S6.16.3", "3.2"}],

Cell[CellGroupData[{

Cell["Initialization Packages", "Subsubsection",
 CellTags->{"S6.16.3", "3.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["<<", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dir", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["read in the initialization package from the directory ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["dir", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.16.3"],

Cell["Initializing all packages in a directory. ", "Caption",
 CellTags->"S6.16.3"],

Cell["\<\
If you frequently use many functions from different packages in the same \
standard package directory, you will find it convenient to load the \
initialization package from that directory. After you load the initialization \
package you can use any of the functions contained in packages included in \
the directory. You will not need to load each package separately. \
\>", "Text",
 CellTags->{"S6.16.3", "3.4"}],

Cell[TextData[{
 "For example, ",
 StyleBox["<<Graphics`", "MR"],
 " loads the initialization package ",
 StyleBox["Graphics`Kernel`init`", "MR"],
 " and makes all the functions provided in the ",
 StyleBox["Graphics", "MR"],
 " packages available in your current session. Using one of these functions \
will cause the appropriate package to be loaded if it has not been loaded \
already. An initialization package really consists of nothing more than a \
sequence of ",
 StyleBox["DeclarePackage", "MR"],
 " commands. "
}], "Text",
 CellTags->{"S6.16.3", "3.5"}],

Cell[TextData[{
 "This loads the ",
 StyleBox["Graphics`Kernel`init`", "MR"],
 " package. All the functions contained in ",
 StyleBox["Graphics", "MR"],
 " packages are now available for use. "
}], "MathCaption",
 CellTags->{"S6.16.3", "3.6"}],

Cell["<<Graphics`", "Input",
  CellLabel->"In[17]:=",
  CellTags->"S6.16.3"],

Cell[TextData[{
 "Since the ",
 StyleBox["Graphics`Graphics`", "MR"],
 " package defining ",
 StyleBox["BarChart", "MR"],
 " has not yet been loaded, using ",
 StyleBox["BarChart", "MR"],
 " will cause the package to load. "
}], "MathCaption",
 CellTags->{"S6.16.3", "3.7"}],

Cell[CellGroupData[{

Cell["BarChart[{1.2, 3.4, 2.2, 1.8}]", "Input",
  CellLabel->"In[18]:=",
  CellTags->"S6.16.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0952381 0.238095 0.0147151 0.173119 [
[.14286 .00222 -3 -9 ]
[.14286 .00222 3 0 ]
[.38095 .00222 -3 -9 ]
[.38095 .00222 3 0 ]
[.61905 .00222 -3 -9 ]
[.61905 .00222 3 0 ]
[.85714 .00222 -3 -9 ]
[.85714 .00222 3 0 ]
[-0.0125 .10127 -18 -4.5 ]
[-0.0125 .10127 0 4.5 ]
[-0.0125 .18783 -6 -4.5 ]
[-0.0125 .18783 0 4.5 ]
[-0.0125 .27439 -18 -4.5 ]
[-0.0125 .27439 0 4.5 ]
[-0.0125 .36095 -6 -4.5 ]
[-0.0125 .36095 0 4.5 ]
[-0.0125 .44751 -18 -4.5 ]
[-0.0125 .44751 0 4.5 ]
[-0.0125 .53407 -6 -4.5 ]
[-0.0125 .53407 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.14286 .01472 m
.14286 .02097 L
s
[(1)] .14286 .00222 0 1 Mshowa
.38095 .01472 m
.38095 .02097 L
s
[(2)] .38095 .00222 0 1 Mshowa
.61905 .01472 m
.61905 .02097 L
s
[(3)] .61905 .00222 0 1 Mshowa
.85714 .01472 m
.85714 .02097 L
s
[(4)] .85714 .00222 0 1 Mshowa
0 .01472 m
1 .01472 L
s
0 .10127 m
.00625 .10127 L
s
[(0.5)] -0.0125 .10127 1 0 Mshowa
0 .18783 m
.00625 .18783 L
s
[(1)] -0.0125 .18783 1 0 Mshowa
0 .27439 m
.00625 .27439 L
s
[(1.5)] -0.0125 .27439 1 0 Mshowa
0 .36095 m
.00625 .36095 L
s
[(2)] -0.0125 .36095 1 0 Mshowa
0 .44751 m
.00625 .44751 L
s
[(2.5)] -0.0125 .44751 1 0 Mshowa
0 .53407 m
.00625 .53407 L
s
[(3)] -0.0125 .53407 1 0 Mshowa
.125 Mabswid
0 .03203 m
.00375 .03203 L
s
0 .04934 m
.00375 .04934 L
s
0 .06665 m
.00375 .06665 L
s
0 .08396 m
.00375 .08396 L
s
0 .11859 m
.00375 .11859 L
s
0 .1359 m
.00375 .1359 L
s
0 .15321 m
.00375 .15321 L
s
0 .17052 m
.00375 .17052 L
s
0 .20515 m
.00375 .20515 L
s
0 .22246 m
.00375 .22246 L
s
0 .23977 m
.00375 .23977 L
s
0 .25708 m
.00375 .25708 L
s
0 .29171 m
.00375 .29171 L
s
0 .30902 m
.00375 .30902 L
s
0 .32633 m
.00375 .32633 L
s
0 .34364 m
.00375 .34364 L
s
0 .37826 m
.00375 .37826 L
s
0 .39558 m
.00375 .39558 L
s
0 .41289 m
.00375 .41289 L
s
0 .4302 m
.00375 .4302 L
s
0 .46482 m
.00375 .46482 L
s
0 .48214 m
.00375 .48214 L
s
0 .49945 m
.00375 .49945 L
s
0 .51676 m
.00375 .51676 L
s
0 .55138 m
.00375 .55138 L
s
0 .5687 m
.00375 .5687 L
s
0 .58601 m
.00375 .58601 L
s
0 .60332 m
.00375 .60332 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.04762 .01472 m
.04762 .22246 L
.2381 .22246 L
.2381 .01472 L
F
0 g
.5 Mabswid
.04762 .01472 m
.04762 .22246 L
.2381 .22246 L
.2381 .01472 L
.04762 .01472 L
s
1 0 0 r
.28571 .01472 m
.28571 .60332 L
.47619 .60332 L
.47619 .01472 L
F
0 g
.28571 .01472 m
.28571 .60332 L
.47619 .60332 L
.47619 .01472 L
.28571 .01472 L
s
1 0 0 r
.52381 .01472 m
.52381 .39558 L
.71429 .39558 L
.71429 .01472 L
F
0 g
.52381 .01472 m
.52381 .39558 L
.71429 .39558 L
.71429 .01472 L
.52381 .01472 L
s
1 0 0 r
.7619 .01472 m
.7619 .32633 L
.95238 .32633 L
.95238 .01472 L
F
0 g
.7619 .01472 m
.7619 .32633 L
.95238 .32633 L
.95238 .01472 L
.7619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[2]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00>Oooool3o`0003_ooooo1Ol0000kooooo`?o0000
?_ooool3o`0002Gooooo000jooooo`03o`000?oooooooooo03_ooooo00Co0000oooooooooooo0000
>_ooool01Ol0003ooooooooooooooooo000003kooooo00?o0000ooooooooool09?ooool003[ooooo
00?o0000ooooooooool0??ooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo03Wooooo
1Ol0000Uooooo`00>_ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03_ooooo0_l0
000looooo`04o`000?ooooooooooo`0002Kooooo000jooooo`03o`000?oooooooooo03[ooooo00Go
0000ooooooooooooooooo`00000nooooo`03o`000?oooooooooo03[ooooo00?o0000ooooool00000
9_ooool003Wooooo0_l0000looooo`05o`000?ooooooooooooooool00000>_ooool01Ol0003ooooo
oooooooooooo000003gooooo0_l0000Vooooo`00>_ooool00ol0003oooooooooo`0kooooo`?o0000
??ooool3o`0003oooooo00?o0000ooooooooool09?ooool001Gooooo00?o0000ooooooooool0oooo
ool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo
0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooooooo`0000co0000
000Eooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003ooooooooo
o`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0
000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003ooooooooo
o`0;ooooo`005Oooool00ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000
ooooooooool02_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000
ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000
ooooooooool02oooool001Gooooo00?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool0
0003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:oooo
o`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool0
0003o`000?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo
0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000oooooooo
ool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo
0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool2o`0000[ooooo00?o0000ool00?oo0000
<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0
2_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000
<?oo00000ol0003oooooooooo`0;ooooo`005Oooool00ol0003oooooooooo`09ooooo`03o`000?oo
003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000_ool00003o`000?oo
oooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo
003oo`00033oo`0000?o0000ooooooooool02oooool001Gooooo00?o0000ooooooooool02Oooool0
0ol0003oo`00ool0000`ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000;ooo0000
0ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool0
0ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo
00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00
02ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo
00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool2o`0000[o
oooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002oo
o`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wo
oooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00
ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003ooooo
ooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02oooool001Gooooo00?o
0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00[ooooo00?o
0000ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o
0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo000E
ooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:
ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`
ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;
ooooo`005Oooool00ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000oooo
ooooool02_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool0
0?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000oooo
ooooool02oooool001Gooooo0_l0000:ooooo`03o`000?oo003oo`00033oo`0000?o0000oooooooo
ool02_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo
0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000oooooooo
ool02oooool001Gooooo00?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`00
0?oooooooooo00[ooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`00
0?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`00
0?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo
00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_oo
ool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo
00000ol0003oooooooooo`0;ooooo`005Oooool00ol0003oooooooooo`09ooooo`03o`000?oo003o
o`00033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000_ool00003o`000?oooooo
oooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003o
o`00033oo`0000?o0000ooooooooool02oooool001Gooooo0_l0000:ooooo`03o`000?oo003oo`00
033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo
00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00
033oo`0000?o0000ooooooooool02oooool001Gooooo00?o0000ooooooooool02Oooool00ol0003o
o`00ool0000`ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000;ooo00000ol0003o
ooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003o
o`00ool0000`ool00003o`000?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo00Wooooo
00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002ooo`00
00?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo
00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`000_ooool2o`0000Cooooo00?o
0000ooooooooool00_ooool3o`0000Gooooo00?o0000ooooooooool02Oooool00ol0003oo`00ool0
000`ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000;ooo00000ol0003ooooooooo
o`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003oo`00ool0
000`ool00003o`000?oooooooooo00_ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Go
0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo0000
<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0
2_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000
<?oo00000ol0003oooooooooo`0;ooooo`0000Goooooo`000?ooooooooooo`00000;ooooo`03o`00
0?oooooooooo00;ooooo0_l0000:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool0
2_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000
<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool0
2oooool00005ooooool0003oooooooooool000002oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:ooooo`03o`00
0?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`00
0?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`0000Go
ooooo`000?ooooooooooo`000007ooooo`Co00001Oooool00ol0003oooooooooo`09ooooo`03o`00
0?oo003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000_ool00003o`00
0?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`00
0?oo003oo`00033oo`0000?o0000ooooooooool02oooool00005ooooool0003oooooooooool00000
1oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo0000
<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0
2_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000
<?oo00000ol0003oooooooooo`0;ooooo`000_ooool2o`0000Sooooo1Ol00004ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo
003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oo
oooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool2
o`0000[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003o
o`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooo
oooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool00ol0
003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0
003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0
003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02oooool001Go
oooo00?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00[o
oooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033o
o`0000?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00_o
oooo000Eooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003ooooo
ooooo`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00
ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003ooooo
ooooo`0;ooooo`005Oooool2o`0000[ooooo00?o0000ool00?oo0000<?oo00000ol0003ooooooooo
o`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0
000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003ooooooooo
o`0;ooooo`005Oooool00ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000
ooooooooool02_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000
ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000
ooooooooool02oooool001Gooooo00?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool0
0003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:oooo
o`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool0
0003o`000?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo
0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000oooooooo
ool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo
0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool00ol0003oooooooooo`09ooooo`03o`00
0?oo003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000_ool00003o`00
0?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`00
0?oo003oo`00033oo`0000?o0000ooooooooool02oooool001Gooooo0_l0000:ooooo`03o`000?oo
003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000_ool00003o`000?oo
oooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo
003oo`00033oo`0000?o0000ooooooooool02oooool001Gooooo00?o0000ooooooooool02Oooool0
0ol0003oo`00ool0000`ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000;ooo0000
0ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool0
0ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo
00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00
02ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo
00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool00ol0003o
ooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0003o
o`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003o
ooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02oooool001Gooooo
0_l0000:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00
ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003ooooo
ooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02oooool001Gooooo00?o
0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00[ooooo00?o
0000ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o
0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo000E
ooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:
ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`
ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;
ooooo`003Oooool3o`0000Gooooo00?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool0
0003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:oooo
o`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool0
0003o`000?oooooooooo00_ooooo000>ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo
0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000oooooooo
ool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo000>ooooo`03o`00
0?oooooooooo00Cooooo0_l0000:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool0
2_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000
<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool0
2oooool000kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`09ooooo`03o`000?oo
003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000_ool00003o`000?oo
oooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo
003oo`00033oo`0000?o0000ooooooooool02oooool000kooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02_ooool0
0ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo0000
0ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02oooool0
00gooooo0_l00006ooooo`03o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0
003oooooooooo`0:ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0
003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0
003oooooooooo`0;ooooo`003_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002oo
o`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wo
oooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool2o`0000[ooooo
00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`0002ooo`00
00?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo
00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool00ol0003ooooooooo
o`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0
000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003ooooooooo
o`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02oooool001Gooooo00?o0000
ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00[ooooo00?o0000
ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000
ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo000Eoooo
o`03o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0:oooo
o`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool0
0003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;oooo
o`005Oooool2o`0000[ooooo=?l0000<ooooo`03o`000?oo003oo`0002ooo`0000?o0000oooooooo
ool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo
0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool00ol0003oooooooooo`19ooooo`03o`00
0?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`00
0?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Ooo
ool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_oo
ool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo
00000ol0003oooooooooo`0;ooooo`005Oooool00ol0003oooooooooo`19ooooo`03o`000?oo003o
o`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooo
oooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool00ol0
003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0
003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0
003oooooooooo`0;ooooo`005Oooool2o`0004[ooooo00?o0000ool00?oo0000;ooo00000ol0003o
ooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003o
o`00ool0000`ool00003o`000?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo04Wooooo
00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`00
00?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo
000Eooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003ooooooooo
o`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003oo`00ool0
000`ool00003o`000?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo04Wooooo00?o0000
ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000
ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo000Eoooo
o`;o0000B_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool0
0?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000oooo
ooooool02oooool001Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003
o`000?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03
o`000?oo003oo`00033oo`0000?o0000ooooooooool02oooool001Gooooo00?o0000ooooooooool0
BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000
<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool0
2oooool00004ooooool0003o0000o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo
00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo
00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo003oo`00033oo`00
00?o0000ooooooooool02oooool000;ooooo00?o0000ooooooooool01oooool01Ol0003ooooooooo
oooooooo000000Cooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`00
0?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`00
0?oo003oo`00033oo`0000?o0000ooooooooool02oooool000;ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`02ooooo`;o0000B_ooool00ol0003oo`00ool0000_ool00003o`000?oo
oooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`000?oo
003oo`00033oo`0000?o0000ooooooooool02oooool000;ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo0000
0ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool0
0ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo0002ooooo`03o`000?oooooooooo
00Oooooo1?l00005ooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0
003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0
003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo00000ooooooo0000o`000009ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003
o`000?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03
o`000?oo003oo`00033oo`0000?o0000ooooooooool02oooool000;ooooo00?o0000ooooooooool0
1oooool5o`0000Cooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`00
0?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooo`03o`00
0?oo003oo`00033oo`0000?o0000ooooooooool02oooool001Gooooo0_l0001:ooooo`03o`000?oo
003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oo
oooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool0
0ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool0
0ol0003oo`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo0000
0ol0003oooooooooo`0;ooooo`005Oooool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`00
02ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo
00Wooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`0;ooooo`005Oooool00ol0003o
ooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003o
o`00ool0000`ool00003o`000?oooooooooo00Wooooo00?o0000ool00?oo0000<?oo00000ol0003o
ooooooooo`0;ooooo`005Oooool2o`0004[ooooo00?o0000ool00?oo0000;ooo00000ol0003ooooo
ooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003oo`00
ool0000`ool00003o`000?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo04Wooooo00?o
0000ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o
0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo000E
ooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:
ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003oo`00ool0000`
ool00003o`000?oooooooooo00_ooooo000Eooooo`03o`000?oooooooooo04Wooooo00?o0000ool0
0?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000oooo
ooooool02Oooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo00_ooooo000Eooooo`03
o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03
o`000?oo003oo`00033oo`0000?o0000ooooooooool02Oooool00ol0003oo`00ool0000`ool00003
o`000?oooooooooo00_ooooo000Eooooo`;o0000B_ooool00ol0003oo`00ool0000_ool00003o`00
0?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`09ooooocCo0000
3Oooool001Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oo
oooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`1:ooooo`005Oooool0
0ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool0
0ol0003oo`00ool0000`ool00003o`000?oooooooooo04[ooooo000Eooooo`03o`000?oooooooooo
04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00
033oo`0000?o0000ooooooooool0B_ooool001Gooooo0_l0001:ooooo`03o`000?oo003oo`0002oo
o`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo04[o
oooo000Eooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003ooooo
ooooo`0:ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool0B_ooool001Gooooo00?o
0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o
0000ool00?oo0000<?oo00000ol0003oooooooooo`1:ooooo`003?ooool5o`0000Cooooo00?o0000
ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000
ool00?oo0000<?oo00000ol0003oooooooooo`1:ooooo`003Oooool01?l0003oooooooooool00004
ooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:
ooooo`03o`000?oo003oo`00033oo`0000?o0000ooooooooool0B_ooool000kooooo00?o0000oooo
ooooool01?ooool2o`0004[ooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:oooo
o`03o`000?oo003oo`00033oo`0000?o0000ooooooooool0B_ooool000oooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000oooooooo
ool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo04[ooooo000<ooooo`05o`00
0?ooooooooooooooool000001?ooool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002oo
o`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`000?oooooooooo04[o
oooo000<ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`19ooooo`03
o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003
o`000?oooooooooo04[ooooo000=ooooo`?o00001Oooool00ol0003oooooooooo`19ooooo`03o`00
0?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool00ol0003oo`00ool0000`ool00003o`00
0?oooooooooo04[ooooo000Eooooo`;o0000B_ooool00ol0003oo`00ool0000_ool00003o`000?oo
oooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003oooooooooo`1:ooooo`005Oooool0
0ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool02_ooool0
0ol0003oo`00ool0000`ool00003o`000?oooooooooo04[ooooo000Eooooo`03o`000?oooooooooo
04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`0:ooooo`03o`000?oo003oo`00
033oo`0000?o0000ooooooooool0B_ooool001Gooooo00?o0000ooooooooool0BOooool00ol0003o
o`00ool0000_ool00003o`000?oooooooooo00[ooooo00?o0000ool00?oo0000<?oo00000ol0003o
ooooooooo`1:ooooo`005Oooool2o`0004[ooooo00?o0000ool00?oo0000;ooo00000ol0003ooooo
ooooo`0:ooooocCo0000C?ooool001Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0
000_ool00003o`000?oooooooooo08[ooooo000Eooooo`03o`000?oooooooooo04Wooooo00?o0000
ool00?oo0000;ooo00000ol0003oooooooooo`2:ooooo`005Oooool00ol0003oooooooooo`19oooo
o`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool001Gooooo00?o0000oooooooo
ool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo08[ooooo000Eooooo`;o0000
B_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo08[ooooo000Eooooo`03o`000?oo
oooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`2:ooooo`005Oooool0
0ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool0
01Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo
08[ooooo000Eooooo`;o0000B_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo08[o
oooo000Eooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003ooooo
ooooo`2:ooooo`005Oooool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o
0000ooooooooool0R_ooool000Go00000oooool00ol0003oooooooooo`02ooooo`?o00001Oooool0
0ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool0
0005ooooool0003oooooooooool000001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo08[ooooo0002
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_ooool2o`0004[ooooo00?o0000
ool00?oo0000;ooo00000ol0003oooooooooo`2:ooooo`000oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool0
0003o`000?oooooooooo08[ooooo00001Ol0003ooooooooooooooooo000000Oooooo1?l00005oooo
o`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`2:oooo
o`0000Go0000ooooooooooooooooo`000007ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo08[ooooo00001?oooooo
0000o`000?l00008ooooo`Go00001?ooool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`00
02ooo`0000?o0000ooooooooool0R_ooool001Gooooo0_l0001:ooooo`03o`000?oo003oo`0002oo
o`0000?o0000ooooooooool0R_ooool001Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00
ool0000_ool00003o`000?oooooooooo08[ooooo000Eooooo`03o`000?oooooooooo04Wooooo00?o
0000ool00?oo0000;ooo00000ol0003oooooooooo`2:ooooo`005Oooool00ol0003oooooooooo`19
ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool001Gooooo0_l0001:oooo
o`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool001Gooooo00?o0000oooooooo
ool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo08[ooooo000Eooooo`03o`00
0?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`2:ooooo`005Ooo
ool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_oo
ool001Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooo
oooo08[ooooo000Eooooo`;o0000B_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo
08[ooooo000Eooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003o
ooooooooo`2:ooooo`005Oooool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`00
00?o0000ooooooooool0R_ooool001Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0
000_ool00003o`000?oooooooooo08[ooooo000Eooooo`;o0000B_ooool00ol0003oo`00ool0000_
ool00003o`000?oooooooooo08[ooooo000Eooooo`03o`000?oooooooooo04Wooooo00?o0000ool0
0?oo0000;ooo00000ol0003oooooooooo`2:ooooo`005Oooool00ol0003oooooooooo`19ooooo`03
o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool000gooooo0ol00005ooooo`03o`00
0?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`2:ooooo`003?oo
ool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0BOooool00ol0003oo`00
ool0000_ool00003o`000?oooooooooo08[ooooo000@ooooo`03o`000?oooooooooo00;ooooo0_l0
001:ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool000kooooo0_l00005
ooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`2:
ooooo`004?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo04Wooooo00?o0000ool0
0?oo0000;ooo00000ol0003oooooooooo`2:ooooo`003?ooool01Ol0003ooooooooooooooooo0000
00Cooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo
08[ooooo000=ooooo`?o00001Oooool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002oo
o`0000?o0000ooooooooool0R_ooool001Gooooo0_l0001:ooooo`03o`000?oo003oo`0002ooo`00
00?o0000ooooooooool0R_ooool001Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0
000_ool00003o`000?oooooooooo08[ooooo000Eooooo`03o`000?oooooooooo04Wooooo00?o0000
ool00?oo0000;ooo00000ol0003oooooooooo`2:ooooo`005Oooool00ol0003oooooooooo`19oooo
o`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool001Gooooo0_l0001:ooooo`03
o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool001Gooooo00?o0000ooooooooool0
BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo08[ooooo000Eooooo`03o`000?oo
oooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003oooooooooo`2:ooooo`005Oooool0
0ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o0000ooooooooool0R_ooool0
01Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo
08[ooooo000Eooooo`;o0000B_ooool00ol0003oo`00ool0000_ool00003o`000?oooooooooo08[o
oooo000Eooooo`03o`000?oooooooooo04Wooooo00?o0000ool00?oo0000;ooo00000ol0003ooooo
ooooo`2:ooooo`005Oooool00ol0003oooooooooo`19ooooo`03o`000?oo003oo`0002ooo`0000?o
0000ooooooooool0R_ooool001Gooooo00?o0000ooooooooool0BOooool00ol0003oo`00ool0000_
ool00003o`000?oooooooooo08[ooooo000Eooooo`;o0000B_oooolco`0008cooooo000Eooooo`03
o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Ooo
ool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool0
0?oooooo8Oooool00?oooooo8Oooool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {0.0629221, -0.314942, \
0.0158087, 0.0217421}},
  CellTags->"S6.16.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[18]=",
  CellTags->"S6.16.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Autoload Directory", "Subsubsection",
 CellTags->{"S6.16.3", "3.8"}],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica", "TI"],
 " distribution typically includes the standard add\[Hyphen]on packages \
described in this book, placed in the ",
 StyleBox["AddOns/StandardPackages/", "MR"],
 " subdirectory of your main ",
 StyleBox["Mathematica", "TI"],
 " directory. Additional add\[Hyphen]ons, created by users and developers or \
purchased separately from Wolfram Research, are generally placed in \
subdirectories of the ",
 StyleBox["$BaseDirectory", "MR"],
 " or the ",
 StyleBox["$UserBaseDirectory", "MR"],
 ", depending on whether the packages are to be made available to all users \
of this copy of ",
 StyleBox["Mathematica", "TI"],
 ", or only a single user. These symbols evaluate to the actual directory on \
your system where add\[Hyphen]ons should be placed. See ",
 ButtonBox["Appendix A.8.2",
  ButtonStyle->"MainBookLink",
  ButtonData->{"A.8.2", None}],
 " of the ",
 StyleBox["Mathematica", "TI"],
 " book for more information on these directories. ",
 StyleBox["Mathematica", "TI"],
 " application packages, such as ",
 StyleBox["Electrical Engineering", "TI"],
 ", are usually installed in an ",
 StyleBox["Applications", "MR"],
 " subdirectory. An ",
 StyleBox["Autoload", "MR"],
 " subdirectory provides another way to autoload packages. "
}], "Text",
 CellTags->{"S6.16.3", "3.9"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["$BaseDirectory", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "global location to place add\[Hyphen]ons",
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["$UserBaseDirectory", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "personal location to place add\[Hyphen]ons",
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Applications/", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["name", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["/", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "subdirectory for a named application within an add\[Hyphen]ons \
directory",
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Autoload/", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["name", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["/", "MR",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "subdirectory in which to place an initialization file so that it is \
loaded when ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox["Mathematica", "TI",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}],
      StyleBox[" is started ",
       GridBoxOptions->{RowLines->{False, True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{False, True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->{False, True, False},
 RowSpacings->0.4},
 CellTags->"S6.16.3"],

Cell[TextData[{
 "Directories for ",
 StyleBox["Mathematica", "SO"],
 " packages. "
}], "Caption",
 CellTags->"S6.16.3"],

Cell[TextData[{
 "If you would like ",
 StyleBox["Mathematica", "TI"],
 " to automatically load the initialization file for a directory of packages \
whenever you start the kernel, then you should copy the initialization file \
out of the location in the main ",
 StyleBox["Mathematica", "TI"],
 " layout into the appropriate ",
 StyleBox["Autoload", "MR"],
 " subdirectory of an add\[Hyphen]ons directory. For example, you might copy \
",
 StyleBox["$TopDirectory/AddOns/StandardPackages/Graphics/Kernel/init.m", 
  "MR"],
 " into ",
 StyleBox["$BaseDirectory/Autoload/Graphics/Kernel/init.m", "MR"],
 " so that all graphics packages will load as needed. If you have the ",
 StyleBox["Electrical Engineering", "TI"],
 " application, you might copy ",
 StyleBox["$BaseDirectory/Applications/EE/Kernel/init.m", "MR"],
 " into ",
 StyleBox["$UserBaseDirectory/Autoload/EE/Kernel/init.m", "MR"],
 " so that the ",
 StyleBox["Electrical Engineering", "TI"],
 " application will load as needed for your own sessions. Effective use of \
the ",
 StyleBox["Autoload", "MR"],
 " directory allows you to create a version of ",
 StyleBox["Mathematica", "TI"],
 " tailored to your needs. "
}], "Text",
 CellTags->{"S6.16.3", "3.10"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Advanced Topic: Package File Names", "Subsection",
 CellTags->{"S6.16.4", "4.1"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[".mx", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["file in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["DumpSave", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" format ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[".m", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["file in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Mathematica", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" source format ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["/Kernel/init.m", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "kernel initialization file for a particular directory ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["/init.m", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "default initialization file for a particular directory ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.16.4"],

Cell[TextData[{
 "The typical sequence of files looked for by ",
 StyleBox["<<", "MR"],
 StyleBox["name", "TI"],
 StyleBox["`", "MR"],
 ". "
}], "Caption",
 CellTags->"S6.16.4"],

Cell[TextData[{
 "To take advantage of loading packages using contexts, you should know how \
",
 StyleBox["Get", "MR"],
 " and related ",
 StyleBox["Mathematica", "TI"],
 " functions translate names of the form ",
 StyleBox["name", "TI"],
 StyleBox["`", "MR"],
 " into particular file names. ",
 StyleBox["<<", "MR"],
 StyleBox["name", "TI"],
 StyleBox["`", "MR"],
 " first tries to load ",
 StyleBox["name", "TI"],
 StyleBox[".mx", "MR"],
 ", the preferred name for a ",
 StyleBox["Mathematica", "TI"],
 " expression dump. If there is no ",
 StyleBox["name", "TI"],
 StyleBox[".mx", "MR"],
 ", ",
 StyleBox["<<", "MR"],
 StyleBox["name", "TI"],
 StyleBox["`", "MR"],
 " tries to load ",
 StyleBox["name", "TI"],
 StyleBox[".m", "MR"],
 ", the preferred name for a ",
 StyleBox["Mathematica", "TI"],
 " source file or package. If there is no ",
 StyleBox["name", "TI"],
 StyleBox[".m", "MR"],
 ", ",
 StyleBox["<<", "MR"],
 StyleBox["name", "TI"],
 StyleBox["`", "MR"],
 " tries to load the file ",
 StyleBox["name", "TI"],
 StyleBox["/Kernel/init.m", "MR"],
 ", the preferred name for a kernel initialization package for the directory \
",
 StyleBox["name", "TI"],
 ". If there is no ",
 StyleBox["name", "TI"],
 StyleBox["/Kernel/init.m", "MR"],
 ", ",
 StyleBox["<<", "MR"],
 StyleBox["name", "TI"],
 StyleBox["`", "MR"],
 " tries to load the file ",
 StyleBox["name", "TI"],
 StyleBox["/init.m", "MR"],
 ", the default initialization package for the directory ",
 StyleBox["name", "TI"],
 ". "
}], "Text",
 CellTags->{"S6.16.4", "4.2"}],

Cell[TextData[{
 "The names of the source files for the standard packages have the ",
 StyleBox[".m", "MR"],
 " extension, and you are encouraged to name your package source files using \
this extension as well. "
}], "Text",
 CellTags->{"S6.16.4", "4.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Advanced Topic: Basing New Packages on the Standard ",
 StyleBox["Mathematica", "SBO"],
 " Packages"
}], "Subsection",
 CellTags->{"S6.16.5", "5.1"}],

Cell[TextData[{
 "There is a standard sequence of ",
 StyleBox["Mathematica", "TI"],
 " commands that is typically used to set up the contexts in a package. These \
commands set the values of ",
 StyleBox["$Context", "MR"],
 " and ",
 StyleBox["$ContextPath", "MR"],
 " so that the new symbols which are introduced are created in the \
appropriate contexts. "
}], "Text",
 CellTags->{"S6.16.5", "5.2"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BeginPackage[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Package", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`\"]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Package", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to be the current context, and put only ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["System`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" on the context search path ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["::usage = \"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["text", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "introduce the objects intended for export (and no others) ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Begin[\"`Private`\"]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the current context to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Package", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`Private`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["args", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["] = ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", \[Ellipsis]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the main body of definitions in the package ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["End[ ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["revert to the previous context (here ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Package", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[") ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EndPackage[ ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["end the package, prepending the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Package", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to the context search path ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.16.5"],

Cell["\<\
The standard sequence of context control commands in a package. \
\>", "Caption",
 CellTags->"S6.16.5"],

Cell[TextData[{
 "When you write a package that uses symbols provided by one of the standard \
packages, you need to be aware of auxiliary packages automatically loaded via \
a multiargument ",
 StyleBox["BeginPackage", "MR"],
 ". A few directories have a ",
 StyleBox["Common", "MR"],
 " subdirectory for auxiliary packages containing shared symbols. For \
example, the package ",
 StyleBox["Statistics`ConfidenceIntervals`", "MR"],
 " automatically loads ",
 StyleBox["Statistics`Common`PopulationsCommon`", "MR"],
 " using the ",
 StyleBox["BeginPackage", "MR"],
 " function. "
}], "Text",
 CellTags->{"S6.16.5", "5.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["BeginPackage[\"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Package", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`\", \"", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["Needed",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["`\", \[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["begin a package, specifying that contexts in addition to ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["System`", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" are needed ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S6.16.5"],

Cell[TextData[{
 "Specifying interdependence of packages using ",
 StyleBox["BeginPackage", "MR"],
 ". "
}], "Caption",
 CellTags->"S6.16.5"],

Cell[TextData[{
 StyleBox["$ContextPath", "MR"],
 " is a global variable that gives a list of contexts to search in trying to \
find a symbol. "
}], "MathCaption",
 CellTags->{"S6.16.5", "5.4"}],

Cell[CellGroupData[{

Cell["$ContextPath", "Input",
 CellLabel->"In[19]:=",
 CellTags->"S6.16.5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Graphics`Graphics`\"\>", 
   ",", "\<\"Utilities`FilterOptions`\"\>", 
   ",", "\<\"Graphics`Common`GraphicsCommon`\"\>", 
   ",", "\<\"Graphics`ThreeScript`\"\>", 
   ",", "\<\"Graphics`SurfaceOfRevolution`\"\>", 
   ",", "\<\"Graphics`Spline`\"\>", ",", "\<\"Graphics`Shapes`\"\>", 
   ",", "\<\"Graphics`Polyhedra`\"\>", ",", "\<\"Graphics`PlotField`\"\>", 
   ",", "\<\"Graphics`PlotField3D`\"\>", 
   ",", "\<\"Graphics`ParametricPlot3D`\"\>", 
   ",", "\<\"Graphics`MultipleListPlot`\"\>", ",", "\<\"Graphics`Legend`\"\>",
    ",", "\<\"Graphics`InequalityGraphics`\"\>", 
   ",", "\<\"Graphics`ImplicitPlot`\"\>", ",", "\<\"Graphics`Graphics3D`\"\>",
    ",", "\<\"Graphics`FilledPlot`\"\>", 
   ",", "\<\"Graphics`ContourPlot3D`\"\>", 
   ",", "\<\"Graphics`ComplexMap`\"\>", ",", "\<\"Graphics`Arrow`\"\>", 
   ",", "\<\"Graphics`ArgColors`\"\>", ",", "\<\"Graphics`Animation`\"\>", 
   ",", "\<\"Calculus`VectorAnalysis`\"\>", 
   ",", "\<\"Miscellaneous`ChemicalElements`\"\>", 
   ",", "\<\"Miscellaneous`Units`\"\>", ",", "\<\"Miscellaneous`SIUnits`\"\>",
    ",", "\<\"Graphics`Colors`\"\>", 
   ",", "\<\"Statistics`DescriptiveStatistics`\"\>", 
   ",", "\<\"Statistics`DataManipulation`\"\>", 
   ",", "\<\"DiscreteMath`Tree`\"\>", ",", "\<\"GraphEdit`\"\>", 
   ",", "\<\"Global`\"\>", ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[19]=",
 CellTags->"S6.16.5"]
}, Open  ]],

Cell[TextData[{
 "This loads the standard package ",
 StyleBox["Statistics`ConfidenceIntervals`", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.16.5", "5.5"}],

Cell["<<Statistics`ConfidenceIntervals`", "Input",
 CellLabel->"In[20]:=",
 CellTags->"S6.16.5"],

Cell[TextData[{
 "The context for the auxiliary package ",
 StyleBox["PopulationsCommon", "MR"],
 " was automatically added to ",
 StyleBox["$ContextPath", "MR"],
 " when the package ",
 StyleBox["ConfidenceIntervals", "MR"],
 " was loaded. "
}], "MathCaption",
 CellTags->{"S6.16.5", "5.6"}],

Cell[CellGroupData[{

Cell["$ContextPath", "Input",
 CellLabel->"In[21]:=",
 CellTags->"S6.16.5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Statistics`ConfidenceIntervals`\"\>", 
   ",", "\<\"Statistics`Common`PopulationsCommon`\"\>", 
   ",", "\<\"Statistics`NormalDistribution`\"\>", 
   ",", "\<\"Statistics`Common`DistributionsCommon`\"\>", 
   ",", "\<\"Graphics`Graphics`\"\>", ",", "\<\"Utilities`FilterOptions`\"\>",
    ",", "\<\"Graphics`Common`GraphicsCommon`\"\>", 
   ",", "\<\"Graphics`ThreeScript`\"\>", 
   ",", "\<\"Graphics`SurfaceOfRevolution`\"\>", 
   ",", "\<\"Graphics`Spline`\"\>", ",", "\<\"Graphics`Shapes`\"\>", 
   ",", "\<\"Graphics`Polyhedra`\"\>", ",", "\<\"Graphics`PlotField`\"\>", 
   ",", "\<\"Graphics`PlotField3D`\"\>", 
   ",", "\<\"Graphics`ParametricPlot3D`\"\>", 
   ",", "\<\"Graphics`MultipleListPlot`\"\>", ",", "\<\"Graphics`Legend`\"\>",
    ",", "\<\"Graphics`InequalityGraphics`\"\>", 
   ",", "\<\"Graphics`ImplicitPlot`\"\>", ",", "\<\"Graphics`Graphics3D`\"\>",
    ",", "\<\"Graphics`FilledPlot`\"\>", 
   ",", "\<\"Graphics`ContourPlot3D`\"\>", 
   ",", "\<\"Graphics`ComplexMap`\"\>", ",", "\<\"Graphics`Arrow`\"\>", 
   ",", "\<\"Graphics`ArgColors`\"\>", ",", "\<\"Graphics`Animation`\"\>", 
   ",", "\<\"Calculus`VectorAnalysis`\"\>", 
   ",", "\<\"Miscellaneous`ChemicalElements`\"\>", 
   ",", "\<\"Miscellaneous`Units`\"\>", ",", "\<\"Miscellaneous`SIUnits`\"\>",
    ",", "\<\"Graphics`Colors`\"\>", 
   ",", "\<\"Statistics`DescriptiveStatistics`\"\>", 
   ",", "\<\"Statistics`DataManipulation`\"\>", 
   ",", "\<\"DiscreteMath`Tree`\"\>", ",", "\<\"GraphEdit`\"\>", 
   ",", "\<\"Global`\"\>", ",", "\<\"System`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[21]=",
 CellTags->"S6.16.5"]
}, Open  ]],

Cell[TextData[{
 "You can request all symbols from the  ",
 StyleBox["Statistics`Common`PopulationsCommon`", "MR"],
 "   context. "
}], "MathCaption",
 CellTags->{"S6.16.5", "5.7"}],

Cell[CellGroupData[{

Cell["Names[\"Statistics`Common`PopulationsCommon`*\"]", "Input",
 CellLabel->"In[22]:=",
 CellTags->"S6.16.5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"EqualVariances\"\>", ",", "\<\"KnownStandardDeviation\"\>", 
   ",", "\<\"KnownVariance\"\>"}], "}"}]], "Output",
 CellLabel->"Out[22]=",
 CellTags->"S6.16.5"]
}, Open  ]],

Cell[TextData[{
 "You can determine the context of a particular symbol by applying the ",
 StyleBox["Context", "MR"],
 " function or by locating the symbol in the index of this book. "
}], "MathCaption",
 CellTags->{"S6.16.5", "5.8"}],

Cell[CellGroupData[{

Cell["{Context[MeanCI], Context[KnownVariance]}", "Input",
 CellLabel->"In[23]:=",
 CellTags->"S6.16.5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Statistics`ConfidenceIntervals`\"\>", 
   ",", "\<\"Statistics`Common`PopulationsCommon`\"\>"}], "}"}]], "Output",
 CellLabel->"Out[23]=",
 CellTags->"S6.16.5"]
}, Open  ]],

Cell[TextData[{
 "Here is the confidence interval for the mean of the data set ",
 StyleBox["{-1.,", "MR"],
 " ",
 StyleBox["0.,", "MR"],
 " ",
 StyleBox["1.}", "MR"],
 ", where the default option setting ",
 StyleBox["KnownVariance", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["None", "MR"],
 " specifies that the population variance is to be estimated from the data. "
}], "MathCaption",
 CellTags->{"S6.16.5", "5.9"}],

Cell[CellGroupData[{

Cell["MeanCI[{-1., 0., 1.}]", "Input",
 CellLabel->"In[24]:=",
 CellTags->"S6.16.5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.4841377117503307`"}], ",", "2.4841377117503307`"}], 
  "}"}]], "Output",
 CellLabel->"Out[24]=",
 CellTags->"S6.16.5"]
}, Open  ]],

Cell[TextData[{
 "Here is the confidence interval for the mean of the data when the \
population variance is known to be ",
 Cell[BoxData[
  FormBox["1.", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", a machine\[Hyphen]precision number. Both symbols ",
 StyleBox["MeanCI", "MR"],
 " and ",
 StyleBox["KnownVariance", "MR"],
 " are recognized because their contexts are on ",
 StyleBox["$ContextPath", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S6.16.5", "5.10"}],

Cell[CellGroupData[{

Cell["MeanCI[{-1., 0., 1.}, KnownVariance -> 1.]", "Input",
 CellLabel->"In[25]:=",
 CellTags->"S6.16.5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.1315857340761715`"}], ",", "1.1315857340761715`"}], 
  "}"}]], "Output",
 CellLabel->"Out[25]=",
 CellTags->"S6.16.5"]
}, Open  ]],

Cell[TextData[{
 "When loading a standard package into a session, there is no need to be \
concerned about the existence of an auxiliary package, or the specific \
contexts of the symbols introduced by the load. However, if you would like to \
use ",
 StyleBox["BeginPackage", "MR"],
 " to base a package of your own on symbols from a standard package, then the \
contexts of the symbols are important. Consider the example packages ",
 StyleBox["myPackage1.m", "MR"],
 " and ",
 StyleBox["myPackage2.m", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.16.5", "5.11"}],

Cell[" ", "ProgramTop",
 CellTags->{"S6.16.5", "5.12"}],

Cell["\<\
BeginPackage[\"myPackage1`\", \"Statistics`ConfidenceIntervals`\"]

myMeanCI::usage = \"myMeanCI[list] gives my value for MeanCI.\"

Begin[\"`Private`\"]

myMeanCI[list_] := MeanCI[list, KnownVariance -> 1.]

End[ ]

EndPackage[ ]\
\>", "Program",
 CellTags->{"S6.16.5", "5.13"}],

Cell[TextData[StyleBox[" ", "MR"]], "ProgramBottom",
 CellTags->{"S6.16.5", "5.14"}],

Cell[TextData[{
 "The sample package ",
 StyleBox["myPackage1.m", "MR"],
 ". "
}], "Caption",
 CellTags->"S6.16.5"],

Cell[TextData[{
 "In the first example package ",
 StyleBox["myPackage1.m", "MR"],
 ", the ",
 StyleBox["BeginPackage", "MR"],
 " statement calls ",
 StyleBox["Needs", "MR"],
 " on the standard package ",
 StyleBox["ConfidenceIntervals", "MR"],
 ". The function ",
 StyleBox["myMeanCI", "MR"],
 " is defined in terms of the package symbols ",
 StyleBox["MeanCI", "MR"],
 " and ",
 StyleBox["KnownVariance", "MR"],
 ". You probably won\[CloseCurlyQuote]t want to create a package solely for \
the sake of hardwiring an option value for a function, but this example \
illustrates the general situation of using symbols defined in other packages \
in your own package definitions. "
}], "Text",
 CellTags->{"S6.16.5", "5.15"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.16.5", "5.16"}],

Cell["<<myPackage1`", "Input",
 CellLabel->"In[26]:=",
 CellTags->"S6.16.5"],

Cell[TextData[{
 "This applies the package function ",
 StyleBox["myMeanCI", "MR"],
 " to the data set. "
}], "MathCaption",
 CellTags->{"S6.16.5", "5.17"}],

Cell[CellGroupData[{

Cell["myMeanCI[{-1., 0., 1.}]", "Input",
 CellLabel->"In[27]:=",
 CellTags->"S6.16.5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.4841377117503307`"}], ",", "2.4841377117503307`"}], 
  "}"}]], "Output",
 CellLabel->"Out[27]=",
 CellTags->"S6.16.5"]
}, Open  ]],

Cell[TextData[{
 "Unfortunately, since the auxiliary package was not specified in ",
 StyleBox["BeginPackage", "MR"],
 ", the symbol ",
 StyleBox["KnownVariance", "MR"],
 " in the definition for ",
 StyleBox["myMeanCI", "MR"],
 " has context ",
 StyleBox["myPackage1`Private`", "MR"],
 " rather than context ",
 StyleBox["Statistics`Common`PopulationsCommon`", "MR"],
 ". The context ",
 StyleBox["myPackage1`Private`", "MR"],
 " is not on ",
 StyleBox["$ContextPath", "MR"],
 " after the package is loaded, so the option setting ",
 StyleBox["myPackage1`Private`KnownVariance", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["1.", "MR"],
 " is not recognized and the default ",
 StyleBox["KnownVariance", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["None", "MR"],
 " is used. Rather than the interval obtained using the option setting ",
 StyleBox["KnownVariance", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["1.", "MR"],
 ", ",
 StyleBox["myMeanCI", "MR"],
 " gives the same confidence interval as the default ",
 StyleBox["MeanCI", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.16.5", "5.18"}],

Cell[TextData[{
 "This example shows that when you want to use symbols from the standard \
packages in your own package, you should determine the specific context for \
each symbol you need, and include those contexts in the ",
 StyleBox["BeginPackage", "MR"],
 " statement of your package. The second example package does just that. "
}], "Text",
 CellTags->{"S6.16.5", "5.19"}],

Cell[" ", "ProgramTop",
 CellTags->{"S6.16.5", "5.20"}],

Cell["\<\
BeginPackage[\"myPackage2`\", \"Statistics`ConfidenceIntervals`\",
 \"Statistics`Common`PopulationsCommon`\"]

myMeanCI::usage = \"myMeanCI[list] gives my value for MeanCI.\"

Begin[\"`Private`\"]

myMeanCI[list_] := MeanCI[list, KnownVariance -> 1.]

End[ ]

EndPackage[ ]\
\>", "Program",
 CellTags->{"S6.16.5", "5.21"}],

Cell[TextData[StyleBox[" ", "MR"]], "ProgramBottom",
 CellTags->{"S6.16.5", "5.22"}],

Cell[TextData[{
 "The sample package ",
 StyleBox["myPackage2.m", "MR"],
 ". "
}], "Caption",
 CellTags->"S6.16.5"],

Cell[TextData[{
 "In the second example package ",
 StyleBox["myPackage2.m", "MR"],
 ", the ",
 StyleBox["BeginPackage", "MR"],
 " statement calls ",
 StyleBox["Needs", "MR"],
 " on both the ",
 StyleBox["ConfidenceIntervals", "MR"],
 " package and the auxiliary package ",
 StyleBox["PopulationsCommon", "MR"],
 ". This is necessary for ",
 StyleBox["Mathematica", "TI"],
 " to correctly interpret all the standard package symbols used in the ",
 StyleBox["myPackage2.m", "MR"],
 ". "
}], "Text",
 CellTags->{"S6.16.5", "5.23"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S6.16.5", "5.24"}],

Cell[CellGroupData[{

Cell["<<myPackage2`", "Input",
 CellLabel->"In[28]:=",
 CellTags->"S6.16.5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"myMeanCI", "::", "\<\"shdw\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Symbol \\!\\(\\\"myMeanCI\\\"\\) appears in multiple \
contexts \\!\\({\\\"myPackage2`\\\", \\\"myPackage1`\\\"}\\); definitions in \
context \\!\\(\\\"myPackage2`\\\"\\) may shadow or be shadowed by other \
definitions. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::shdw\\\"]\\)\"\>"}]], "Message",
 CellLabel->"From In[28]:=",
 CellTags->"S6.16.5"]
}, Open  ]],

Cell[TextData[{
 "Now ",
 StyleBox["myMeanCI", "MR"],
 " implements ",
 StyleBox["KnownVariance", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["1.", "MR"],
 " as desired. "
}], "MathCaption",
 CellTags->{"S6.16.5", "5.25"}],

Cell[CellGroupData[{

Cell["myMeanCI[{-1., 0., 1.}]", "Input",
 CellLabel->"In[29]:=",
 CellTags->"S6.16.5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.1315857340761715`"}], ",", "1.1315857340761715`"}], 
  "}"}]], "Output",
 CellLabel->"Out[29]=",
 CellTags->"S6.16.5"]
}, Open  ]],

Cell[TextData[{
 "Auxiliary packages are usually employed to allow two or more packages to \
share symbols without shadowing. Symbol shadowing can be useful when it warns \
you that two symbols with the same name, but different purposes, occur in \
your session. However, in the case of standard packages from a single \
subdirectory (such as ",
 StyleBox["Statistics", "MR"],
 "), the packages are meant to work together and shadowing is undesirable. "
}], "Text",
 CellTags->{"S6.16.5", "5.26"}],

Cell["\<\
In this book, symbols introduced by an auxiliary package are documented both \
with the standard packages that load the auxiliary package and in a separate \
section devoted to the auxiliary package. \
\>", "Text",
 CellTags->{"S6.16.5", "5.27"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S6.16.0"->{
    Cell[1776, 53, 103, 4, 61, "Section",
      CellTags->{"S6.16.0", "0.1"}],
    Cell[1882, 59, 134, 5, 24, "Text",
      CellTags->{"S6.16.0", "0.2"}],
    Cell[2019, 66, 760, 15, 120, "Text",
      CellTags->{"S6.16.0", "0.3"}]},
  "0.1"->{
    Cell[1776, 53, 103, 4, 61, "Section",
      CellTags->{"S6.16.0", "0.1"}]},
  "0.2"->{
    Cell[1882, 59, 134, 5, 24, "Text",
      CellTags->{"S6.16.0", "0.2"}]},
  "0.3"->{
    Cell[2019, 66, 760, 15, 120, "Text",
      CellTags->{"S6.16.0", "0.3"}]},
  "S6.16.1"->{
    Cell[2804, 85, 61, 1, 36, "Subsection",
      CellTags->{"S6.16.1", "1.1"}],
    Cell[2868, 88, 653, 20, 72, "Text",
      CellTags->{"S6.16.1", "1.2"}],
    Cell[3524, 110, 747, 17, 120, "Text",
      CellTags->{"S6.16.1", "1.3"}],
    Cell[4274, 129, 1268, 36, 120, "Text",
      CellTags->{"S6.16.1", "1.4"}],
    Cell[5545, 167, 2930, 91, 102, "DefinitionBox",
      CellTags->"S6.16.1"],
    Cell[8478, 260, 131, 5, 15, "Caption",
      CellTags->"S6.16.1"],
    Cell[8612, 267, 123, 3, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.5"}],
    Cell[8738, 272, 97, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[8838, 276, 156, 5, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.6"}],
    Cell[9019, 285, 79, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[9101, 289, 113, 2, 25, "Output",
      CellTags->"S6.16.1"],
    Cell[9229, 294, 104, 1, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.7"}],
    Cell[9358, 299, 88, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[9449, 303, 75, 2, 25, "Output",
      CellTags->"S6.16.1"],
    Cell[9539, 308, 539, 12, 88, "Text",
      CellTags->{"S6.16.1", "1.8"}],
    Cell[10081, 322, 683, 13, 120, "Text",
      CellTags->{"S6.16.1", "1.9"}],
    Cell[10767, 337, 136, 3, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.10"}],
    Cell[10906, 342, 80, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[10989, 346, 219, 6, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.11"}],
    Cell[11233, 356, 95, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[11331, 360, 582, 12, 61, "Message",
      CellTags->"S6.16.1"],
    Cell[11916, 374, 578, 12, 61, "Message",
      CellTags->"S6.16.1"],
    Cell[12497, 388, 572, 11, 61, "Message",
      CellTags->"S6.16.1"],
    Cell[13072, 401, 572, 11, 61, "Message",
      CellTags->"S6.16.1"],
    Cell[13659, 415, 201, 5, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.12"}],
    Cell[13885, 424, 83, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[13971, 428, 285, 8, 21, "Print",
      CellTags->{"Info3288981920-3960949", "S6.16.1"}],
    Cell[14271, 439, 88, 1, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.13"}],
    Cell[14384, 444, 98, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[14485, 448, 282, 8, 21, "Print",
      CellTags->{"Info3288981920-6339177", "S6.16.1"}],
    Cell[14782, 459, 594, 12, 104, "Text",
      CellTags->{"S6.16.1", "1.14"}],
    Cell[15379, 473, 264, 9, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.15"}],
    Cell[15668, 486, 70, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[15741, 490, 87, 2, 25, "Output",
      CellTags->"S6.16.1"],
    Cell[15843, 495, 182, 7, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.16"}],
    Cell[16028, 504, 76, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[16107, 508, 193, 5, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.17"}],
    Cell[16325, 517, 89, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[16417, 521, 548, 11, 61, "Message",
      CellTags->"S6.16.1"],
    Cell[16980, 535, 150, 5, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.18"}],
    Cell[17133, 542, 74, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[17210, 546, 223, 6, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.19"}],
    Cell[17458, 556, 99, 2, 28, "Input",
      CellTags->"S6.16.1"],
    Cell[17560, 560, 119, 4, 25, "Output",
      CellTags->"S6.16.1"],
    Cell[17694, 567, 983, 21, 136, "Text",
      CellTags->{"S6.16.1", "1.20"}],
    Cell[18680, 590, 884, 27, 46, "DefinitionBox",
      CellTags->"S6.16.1"],
    Cell[19567, 619, 150, 5, 15, "Caption",
      CellTags->"S6.16.1"]},
  "1.1"->{
    Cell[2804, 85, 61, 1, 36, "Subsection",
      CellTags->{"S6.16.1", "1.1"}]},
  "1.2"->{
    Cell[2868, 88, 653, 20, 72, "Text",
      CellTags->{"S6.16.1", "1.2"}]},
  "1.3"->{
    Cell[3524, 110, 747, 17, 120, "Text",
      CellTags->{"S6.16.1", "1.3"}]},
  "1.4"->{
    Cell[4274, 129, 1268, 36, 120, "Text",
      CellTags->{"S6.16.1", "1.4"}]},
  "1.5"->{
    Cell[8612, 267, 123, 3, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.5"}]},
  "1.6"->{
    Cell[8838, 276, 156, 5, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.6"}]},
  "1.7"->{
    Cell[9229, 294, 104, 1, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.7"}]},
  "1.8"->{
    Cell[9539, 308, 539, 12, 88, "Text",
      CellTags->{"S6.16.1", "1.8"}]},
  "1.9"->{
    Cell[10081, 322, 683, 13, 120, "Text",
      CellTags->{"S6.16.1", "1.9"}]},
  "1.10"->{
    Cell[10767, 337, 136, 3, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.10"}]},
  "1.11"->{
    Cell[10989, 346, 219, 6, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.11"}]},
  "1.12"->{
    Cell[13659, 415, 201, 5, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.12"}]},
  "Info3288981920-3960949"->{
    Cell[13971, 428, 285, 8, 21, "Print",
      CellTags->{"Info3288981920-3960949", "S6.16.1"}]},
  "1.13"->{
    Cell[14271, 439, 88, 1, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.13"}]},
  "Info3288981920-6339177"->{
    Cell[14485, 448, 282, 8, 21, "Print",
      CellTags->{"Info3288981920-6339177", "S6.16.1"}]},
  "1.14"->{
    Cell[14782, 459, 594, 12, 104, "Text",
      CellTags->{"S6.16.1", "1.14"}]},
  "1.15"->{
    Cell[15379, 473, 264, 9, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.15"}]},
  "1.16"->{
    Cell[15843, 495, 182, 7, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.16"}]},
  "1.17"->{
    Cell[16107, 508, 193, 5, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.17"}]},
  "1.18"->{
    Cell[16980, 535, 150, 5, 40, "MathCaption",
      CellTags->{"S6.16.1", "1.18"}]},
  "1.19"->{
    Cell[17210, 546, 223, 6, 56, "MathCaption",
      CellTags->{"S6.16.1", "1.19"}]},
  "1.20"->{
    Cell[17694, 567, 983, 21, 136, "Text",
      CellTags->{"S6.16.1", "1.20"}]},
  "S6.16.2"->{
    Cell[19754, 629, 69, 1, 36, "Subsection",
      CellTags->{"S6.16.2", "2.1"}],
    Cell[19826, 632, 529, 13, 88, "Text",
      CellTags->{"S6.16.2", "2.2"}],
    Cell[20358, 647, 4780, 146, 160, "DefinitionBox",
      CellTags->"S6.16.2"],
    Cell[25141, 795, 64, 1, 15, "Caption",
      CellTags->"S6.16.2"],
    Cell[25208, 798, 685, 22, 72, "Text",
      CellTags->{"S6.16.2", "2.3"}],
    Cell[25896, 822, 602, 12, 88, "Text",
      CellTags->{"S6.16.2", "2.4"}],
    Cell[26501, 836, 751, 16, 120, "Text",
      CellTags->{"S6.16.2", "2.5"}],
    Cell[27255, 854, 368, 11, 72, "MathCaption",
      CellTags->{"S6.16.2", "2.6"}],
    Cell[27648, 869, 72, 2, 28, "Input",
      CellTags->"S6.16.2"],
    Cell[27723, 873, 530, 11, 105, "Output",
      CellTags->"S6.16.2"],
    Cell[28268, 887, 383, 13, 72, "MathCaption",
      CellTags->{"S6.16.2", "2.7"}],
    Cell[28654, 902, 147, 5, 45, "Input",
      CellTags->"S6.16.2"],
    Cell[28804, 909, 242, 9, 56, "MathCaption",
      CellTags->{"S6.16.2", "2.8"}],
    Cell[29071, 922, 98, 2, 28, "Input",
      CellTags->"S6.16.2"],
    Cell[29172, 926, 177, 6, 25, "Output",
      CellTags->"S6.16.2"],
    Cell[29364, 935, 167, 5, 40, "MathCaption",
      CellTags->{"S6.16.2", "2.9"}],
    Cell[29556, 944, 72, 2, 28, "Input",
      CellTags->"S6.16.2"],
    Cell[29631, 948, 530, 11, 105, "Output",
      CellTags->"S6.16.2"]},
  "2.1"->{
    Cell[19754, 629, 69, 1, 36, "Subsection",
      CellTags->{"S6.16.2", "2.1"}]},
  "2.2"->{
    Cell[19826, 632, 529, 13, 88, "Text",
      CellTags->{"S6.16.2", "2.2"}]},
  "2.3"->{
    Cell[25208, 798, 685, 22, 72, "Text",
      CellTags->{"S6.16.2", "2.3"}]},
  "2.4"->{
    Cell[25896, 822, 602, 12, 88, "Text",
      CellTags->{"S6.16.2", "2.4"}]},
  "2.5"->{
    Cell[26501, 836, 751, 16, 120, "Text",
      CellTags->{"S6.16.2", "2.5"}]},
  "2.6"->{
    Cell[27255, 854, 368, 11, 72, "MathCaption",
      CellTags->{"S6.16.2", "2.6"}]},
  "2.7"->{
    Cell[28268, 887, 383, 13, 72, "MathCaption",
      CellTags->{"S6.16.2", "2.7"}]},
  "2.8"->{
    Cell[28804, 909, 242, 9, 56, "MathCaption",
      CellTags->{"S6.16.2", "2.8"}]},
  "2.9"->{
    Cell[29364, 935, 167, 5, 40, "MathCaption",
      CellTags->{"S6.16.2", "2.9"}]},
  "S6.16.3"->{
    Cell[30210, 965, 73, 1, 36, "Subsection",
      CellTags->{"S6.16.3", "3.1"}],
    Cell[30286, 968, 400, 8, 72, "Text",
      CellTags->{"S6.16.3", "3.2"}],
    Cell[30711, 980, 79, 1, 34, "Subsubsection",
      CellTags->{"S6.16.3", "3.3"}],
    Cell[30793, 983, 984, 31, 46, "DefinitionBox",
      CellTags->"S6.16.3"],
    Cell[31780, 1016, 83, 1, 15, "Caption",
      CellTags->"S6.16.3"],
    Cell[31866, 1019, 423, 7, 72, "Text",
      CellTags->{"S6.16.3", "3.4"}],
    Cell[32292, 1028, 563, 14, 88, "Text",
      CellTags->{"S6.16.3", "3.5"}],
    Cell[32858, 1044, 243, 7, 56, "MathCaption",
      CellTags->{"S6.16.3", "3.6"}],
    Cell[33104, 1053, 76, 2, 28, "Input",
      CellTags->"S6.16.3"],
    Cell[33183, 1057, 274, 9, 56, "MathCaption",
      CellTags->{"S6.16.3", "3.7"}],
    Cell[33482, 1070, 95, 2, 28, "Input",
      CellTags->"S6.16.3"],
    Cell[33580, 1074, 32828, 615, 184, 3256, 244, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S6.16.3"],
    Cell[66411, 1691, 178, 5, 25, "Output",
      CellTags->"S6.16.3"],
    Cell[66638, 1702, 74, 1, 34, "Subsubsection",
      CellTags->{"S6.16.3", "3.8"}],
    Cell[66715, 1705, 1334, 34, 168, "Text",
      CellTags->{"S6.16.3", "3.9"}],
    Cell[68052, 1741, 3260, 88, 146, "DefinitionBox",
      CellTags->"S6.16.3"],
    Cell[71315, 1831, 120, 5, 15, "Caption",
      CellTags->"S6.16.3"],
    Cell[71438, 1838, 1221, 30, 184, "Text",
      CellTags->{"S6.16.3", "3.10"}]},
  "3.1"->{
    Cell[30210, 965, 73, 1, 36, "Subsection",
      CellTags->{"S6.16.3", "3.1"}]},
  "3.2"->{
    Cell[30286, 968, 400, 8, 72, "Text",
      CellTags->{"S6.16.3", "3.2"}]},
  "3.3"->{
    Cell[30711, 980, 79, 1, 34, "Subsubsection",
      CellTags->{"S6.16.3", "3.3"}]},
  "3.4"->{
    Cell[31866, 1019, 423, 7, 72, "Text",
      CellTags->{"S6.16.3", "3.4"}]},
  "3.5"->{
    Cell[32292, 1028, 563, 14, 88, "Text",
      CellTags->{"S6.16.3", "3.5"}]},
  "3.6"->{
    Cell[32858, 1044, 243, 7, 56, "MathCaption",
      CellTags->{"S6.16.3", "3.6"}]},
  "3.7"->{
    Cell[33183, 1057, 274, 9, 56, "MathCaption",
      CellTags->{"S6.16.3", "3.7"}]},
  "3.8"->{
    Cell[66638, 1702, 74, 1, 34, "Subsubsection",
      CellTags->{"S6.16.3", "3.8"}]},
  "3.9"->{
    Cell[66715, 1705, 1334, 34, 168, "Text",
      CellTags->{"S6.16.3", "3.9"}]},
  "3.10"->{
    Cell[71438, 1838, 1221, 30, 184, "Text",
      CellTags->{"S6.16.3", "3.10"}]},
  "S6.16.4"->{
    Cell[72708, 1874, 87, 1, 36, "Subsection",
      CellTags->{"S6.16.4", "4.1"}],
    Cell[72798, 1877, 2923, 92, 108, "DefinitionBox",
      CellTags->"S6.16.4"],
    Cell[75724, 1971, 177, 7, 15, "Caption",
      CellTags->"S6.16.4"],
    Cell[75904, 1980, 1541, 57, 136, "Text",
      CellTags->{"S6.16.4", "4.2"}],
    Cell[77448, 2039, 256, 6, 40, "Text",
      CellTags->{"S6.16.4", "4.3"}]},
  "4.1"->{
    Cell[72708, 1874, 87, 1, 36, "Subsection",
      CellTags->{"S6.16.4", "4.1"}]},
  "4.2"->{
    Cell[75904, 1980, 1541, 57, 136, "Text",
      CellTags->{"S6.16.4", "4.2"}]},
  "4.3"->{
    Cell[77448, 2039, 256, 6, 40, "Text",
      CellTags->{"S6.16.4", "4.3"}]},
  "S6.16.5"->{
    Cell[77741, 2050, 167, 5, 54, "Subsection",
      CellTags->{"S6.16.5", "5.1"}],
    Cell[77911, 2057, 402, 11, 56, "Text",
      CellTags->{"S6.16.5", "5.2"}],
    Cell[78316, 2070, 5840, 181, 204, "DefinitionBox",
      CellTags->"S6.16.5"],
    Cell[84159, 2253, 113, 3, 15, "Caption",
      CellTags->"S6.16.5"],
    Cell[84275, 2258, 623, 16, 104, "Text",
      CellTags->{"S6.16.5", "5.3"}],
    Cell[84901, 2276, 1497, 45, 64, "DefinitionBox",
      CellTags->"S6.16.5"],
    Cell[86401, 2323, 141, 5, 15, "Caption",
      CellTags->"S6.16.5"],
    Cell[86545, 2330, 194, 5, 56, "MathCaption",
      CellTags->{"S6.16.5", "5.4"}],
    Cell[86764, 2339, 75, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[86842, 2343, 1436, 27, 249, "Output",
      CellTags->"S6.16.5"],
    Cell[88293, 2373, 160, 5, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.5"}],
    Cell[88456, 2380, 96, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[88555, 2384, 292, 9, 56, "MathCaption",
      CellTags->{"S6.16.5", "5.6"}],
    Cell[88872, 2397, 75, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[88950, 2401, 1651, 30, 313, "Output",
      CellTags->"S6.16.5"],
    Cell[90616, 2434, 181, 5, 56, "MathCaption",
      CellTags->{"S6.16.5", "5.7"}],
    Cell[90822, 2443, 111, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[90936, 2447, 203, 5, 25, "Output",
      CellTags->"S6.16.5"],
    Cell[91154, 2455, 234, 5, 56, "MathCaption",
      CellTags->{"S6.16.5", "5.8"}],
    Cell[91413, 2464, 104, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[91520, 2468, 204, 5, 41, "Output",
      CellTags->"S6.16.5"],
    Cell[91739, 2476, 429, 15, 72, "MathCaption",
      CellTags->{"S6.16.5", "5.9"}],
    Cell[92193, 2495, 84, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[92280, 2499, 177, 6, 25, "Output",
      CellTags->"S6.16.5"],
    Cell[92472, 2508, 504, 14, 72, "MathCaption",
      CellTags->{"S6.16.5", "5.10"}],
    Cell[93001, 2526, 105, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[93109, 2530, 177, 6, 25, "Output",
      CellTags->"S6.16.5"],
    Cell[93301, 2539, 561, 13, 88, "Text",
      CellTags->{"S6.16.5", "5.11"}],
    Cell[93865, 2554, 55, 1, 20, "ProgramTop",
      CellTags->{"S6.16.5", "5.12"}],
    Cell[93923, 2557, 289, 13, 179, "Program",
      CellTags->{"S6.16.5", "5.13"}],
    Cell[94215, 2572, 84, 1, 8, "ProgramBottom",
      CellTags->{"S6.16.5", "5.14"}],
    Cell[94302, 2575, 115, 5, 15, "Caption",
      CellTags->"S6.16.5"],
    Cell[94420, 2582, 723, 20, 104, "Text",
      CellTags->{"S6.16.5", "5.15"}],
    Cell[95146, 2604, 79, 1, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.16"}],
    Cell[95228, 2607, 76, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[95307, 2611, 156, 5, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.17"}],
    Cell[95488, 2620, 86, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[95577, 2624, 177, 6, 25, "Output",
      CellTags->"S6.16.5"],
    Cell[95769, 2633, 1112, 39, 136, "Text",
      CellTags->{"S6.16.5", "5.18"}],
    Cell[96884, 2674, 379, 7, 72, "Text",
      CellTags->{"S6.16.5", "5.19"}],
    Cell[97266, 2683, 55, 1, 20, "ProgramTop",
      CellTags->{"S6.16.5", "5.20"}],
    Cell[97324, 2686, 332, 14, 194, "Program",
      CellTags->{"S6.16.5", "5.21"}],
    Cell[97659, 2702, 84, 1, 8, "ProgramBottom",
      CellTags->{"S6.16.5", "5.22"}],
    Cell[97746, 2705, 115, 5, 15, "Caption",
      CellTags->"S6.16.5"],
    Cell[97864, 2712, 529, 17, 72, "Text",
      CellTags->{"S6.16.5", "5.23"}],
    Cell[98396, 2731, 79, 1, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.24"}],
    Cell[98500, 2736, 76, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[98579, 2740, 536, 11, 47, "Message",
      CellTags->"S6.16.5"],
    Cell[99130, 2754, 230, 11, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.25"}],
    Cell[99385, 2769, 86, 2, 28, "Input",
      CellTags->"S6.16.5"],
    Cell[99474, 2773, 177, 6, 25, "Output",
      CellTags->"S6.16.5"],
    Cell[99666, 2782, 497, 9, 88, "Text",
      CellTags->{"S6.16.5", "5.26"}],
    Cell[100166, 2793, 256, 5, 56, "Text",
      CellTags->{"S6.16.5", "5.27"}]},
  "5.1"->{
    Cell[77741, 2050, 167, 5, 54, "Subsection",
      CellTags->{"S6.16.5", "5.1"}]},
  "5.2"->{
    Cell[77911, 2057, 402, 11, 56, "Text",
      CellTags->{"S6.16.5", "5.2"}]},
  "5.3"->{
    Cell[84275, 2258, 623, 16, 104, "Text",
      CellTags->{"S6.16.5", "5.3"}]},
  "5.4"->{
    Cell[86545, 2330, 194, 5, 56, "MathCaption",
      CellTags->{"S6.16.5", "5.4"}]},
  "5.5"->{
    Cell[88293, 2373, 160, 5, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.5"}]},
  "5.6"->{
    Cell[88555, 2384, 292, 9, 56, "MathCaption",
      CellTags->{"S6.16.5", "5.6"}]},
  "5.7"->{
    Cell[90616, 2434, 181, 5, 56, "MathCaption",
      CellTags->{"S6.16.5", "5.7"}]},
  "5.8"->{
    Cell[91154, 2455, 234, 5, 56, "MathCaption",
      CellTags->{"S6.16.5", "5.8"}]},
  "5.9"->{
    Cell[91739, 2476, 429, 15, 72, "MathCaption",
      CellTags->{"S6.16.5", "5.9"}]},
  "5.10"->{
    Cell[92472, 2508, 504, 14, 72, "MathCaption",
      CellTags->{"S6.16.5", "5.10"}]},
  "5.11"->{
    Cell[93301, 2539, 561, 13, 88, "Text",
      CellTags->{"S6.16.5", "5.11"}]},
  "5.12"->{
    Cell[93865, 2554, 55, 1, 20, "ProgramTop",
      CellTags->{"S6.16.5", "5.12"}]},
  "5.13"->{
    Cell[93923, 2557, 289, 13, 179, "Program",
      CellTags->{"S6.16.5", "5.13"}]},
  "5.14"->{
    Cell[94215, 2572, 84, 1, 8, "ProgramBottom",
      CellTags->{"S6.16.5", "5.14"}]},
  "5.15"->{
    Cell[94420, 2582, 723, 20, 104, "Text",
      CellTags->{"S6.16.5", "5.15"}]},
  "5.16"->{
    Cell[95146, 2604, 79, 1, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.16"}]},
  "5.17"->{
    Cell[95307, 2611, 156, 5, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.17"}]},
  "5.18"->{
    Cell[95769, 2633, 1112, 39, 136, "Text",
      CellTags->{"S6.16.5", "5.18"}]},
  "5.19"->{
    Cell[96884, 2674, 379, 7, 72, "Text",
      CellTags->{"S6.16.5", "5.19"}]},
  "5.20"->{
    Cell[97266, 2683, 55, 1, 20, "ProgramTop",
      CellTags->{"S6.16.5", "5.20"}]},
  "5.21"->{
    Cell[97324, 2686, 332, 14, 194, "Program",
      CellTags->{"S6.16.5", "5.21"}]},
  "5.22"->{
    Cell[97659, 2702, 84, 1, 8, "ProgramBottom",
      CellTags->{"S6.16.5", "5.22"}]},
  "5.23"->{
    Cell[97864, 2712, 529, 17, 72, "Text",
      CellTags->{"S6.16.5", "5.23"}]},
  "5.24"->{
    Cell[98396, 2731, 79, 1, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.24"}]},
  "5.25"->{
    Cell[99130, 2754, 230, 11, 40, "MathCaption",
      CellTags->{"S6.16.5", "5.25"}]},
  "5.26"->{
    Cell[99666, 2782, 497, 9, 88, "Text",
      CellTags->{"S6.16.5", "5.26"}]},
  "5.27"->{
    Cell[100166, 2793, 256, 5, 56, "Text",
      CellTags->{"S6.16.5", "5.27"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S6.16.0", 101130, 2820},
  {"0.1", 101375, 2827},
  {"0.2", 101466, 2830},
  {"0.3", 101554, 2833},
  {"S6.16.1", 101648, 2836},
  {"1.1", 105290, 2931},
  {"1.2", 105383, 2934},
  {"1.3", 105472, 2937},
  {"1.4", 105563, 2940},
  {"1.5", 105655, 2943},
  {"1.6", 105751, 2946},
  {"1.7", 105847, 2949},
  {"1.8", 105943, 2952},
  {"1.9", 106033, 2955},
  {"1.10", 106126, 2958},
  {"1.11", 106225, 2961},
  {"1.12", 106324, 2964},
  {"Info3288981920-3960949", 106441, 2967},
  {"1.13", 106552, 2970},
  {"Info3288981920-6339177", 106668, 2973},
  {"1.14", 106779, 2976},
  {"1.15", 106873, 2979},
  {"1.16", 106972, 2982},
  {"1.17", 107071, 2985},
  {"1.18", 107170, 2988},
  {"1.19", 107269, 2991},
  {"1.20", 107368, 2994},
  {"S6.16.2", 107465, 2997},
  {"2.1", 108866, 3034},
  {"2.2", 108961, 3037},
  {"2.3", 109052, 3040},
  {"2.4", 109143, 3043},
  {"2.5", 109234, 3046},
  {"2.6", 109326, 3049},
  {"2.7", 109424, 3052},
  {"2.8", 109522, 3055},
  {"2.9", 109619, 3058},
  {"S6.16.3", 109720, 3061},
  {"3.1", 111205, 3099},
  {"3.2", 111300, 3102},
  {"3.3", 111390, 3105},
  {"3.4", 111488, 3108},
  {"3.5", 111579, 3111},
  {"3.6", 111671, 3114},
  {"3.7", 111769, 3117},
  {"3.8", 111867, 3120},
  {"3.9", 111966, 3123},
  {"3.10", 112061, 3126},
  {"S6.16.4", 112160, 3129},
  {"4.1", 112572, 3140},
  {"4.2", 112668, 3143},
  {"4.3", 112762, 3146},
  {"S6.16.5", 112857, 3149},
  {"5.1", 117034, 3256},
  {"5.2", 117131, 3259},
  {"5.3", 117223, 3262},
  {"5.4", 117316, 3265},
  {"5.5", 117414, 3268},
  {"5.6", 117512, 3271},
  {"5.7", 117610, 3274},
  {"5.8", 117708, 3277},
  {"5.9", 117806, 3280},
  {"5.10", 117906, 3283},
  {"5.11", 118007, 3286},
  {"5.12", 118101, 3289},
  {"5.13", 118199, 3292},
  {"5.14", 118297, 3295},
  {"5.15", 118397, 3298},
  {"5.16", 118492, 3301},
  {"5.17", 118591, 3304},
  {"5.18", 118691, 3307},
  {"5.19", 118787, 3310},
  {"5.20", 118880, 3313},
  {"5.21", 118978, 3316},
  {"5.22", 119076, 3319},
  {"5.23", 119176, 3322},
  {"5.24", 119270, 3325},
  {"5.25", 119369, 3328},
  {"5.26", 119470, 3331},
  {"5.27", 119563, 3334}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 103, 4, 61, "Section",
  CellTags->{"S6.16.0", "0.1"}],
Cell[1882, 59, 134, 5, 24, "Text",
  CellTags->{"S6.16.0", "0.2"}],
Cell[2019, 66, 760, 15, 120, "Text",
  CellTags->{"S6.16.0", "0.3"}],

Cell[CellGroupData[{
Cell[2804, 85, 61, 1, 36, "Subsection",
  CellTags->{"S6.16.1", "1.1"}],
Cell[2868, 88, 653, 20, 72, "Text",
  CellTags->{"S6.16.1", "1.2"}],
Cell[3524, 110, 747, 17, 120, "Text",
  CellTags->{"S6.16.1", "1.3"}],
Cell[4274, 129, 1268, 36, 120, "Text",
  CellTags->{"S6.16.1", "1.4"}],
Cell[5545, 167, 2930, 91, 102, "DefinitionBox",
  CellTags->"S6.16.1"],
Cell[8478, 260, 131, 5, 15, "Caption",
  CellTags->"S6.16.1"],
Cell[8612, 267, 123, 3, 40, "MathCaption",
  CellTags->{"S6.16.1", "1.5"}],
Cell[8738, 272, 97, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[8838, 276, 156, 5, 40, "MathCaption",
  CellTags->{"S6.16.1", "1.6"}],

Cell[CellGroupData[{
Cell[9019, 285, 79, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[9101, 289, 113, 2, 25, "Output",
  CellTags->"S6.16.1"]
}, Open  ]],
Cell[9229, 294, 104, 1, 40, "MathCaption",
  CellTags->{"S6.16.1", "1.7"}],

Cell[CellGroupData[{
Cell[9358, 299, 88, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[9449, 303, 75, 2, 25, "Output",
  CellTags->"S6.16.1"]
}, Open  ]],
Cell[9539, 308, 539, 12, 88, "Text",
  CellTags->{"S6.16.1", "1.8"}],
Cell[10081, 322, 683, 13, 120, "Text",
  CellTags->{"S6.16.1", "1.9"}],
Cell[10767, 337, 136, 3, 40, "MathCaption",
  CellTags->{"S6.16.1", "1.10"}],
Cell[10906, 342, 80, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[10989, 346, 219, 6, 56, "MathCaption",
  CellTags->{"S6.16.1", "1.11"}],

Cell[CellGroupData[{
Cell[11233, 356, 95, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[11331, 360, 582, 12, 61, "Message",
  CellTags->"S6.16.1"],
Cell[11916, 374, 578, 12, 61, "Message",
  CellTags->"S6.16.1"],
Cell[12497, 388, 572, 11, 61, "Message",
  CellTags->"S6.16.1"],
Cell[13072, 401, 572, 11, 61, "Message",
  CellTags->"S6.16.1"]
}, Open  ]],
Cell[13659, 415, 201, 5, 56, "MathCaption",
  CellTags->{"S6.16.1", "1.12"}],

Cell[CellGroupData[{
Cell[13885, 424, 83, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[13971, 428, 285, 8, 21, "Print",
  CellTags->{"Info3288981920-3960949", "S6.16.1"}]
}, Open  ]],
Cell[14271, 439, 88, 1, 40, "MathCaption",
  CellTags->{"S6.16.1", "1.13"}],

Cell[CellGroupData[{
Cell[14384, 444, 98, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[14485, 448, 282, 8, 21, "Print",
  CellTags->{"Info3288981920-6339177", "S6.16.1"}]
}, Open  ]],
Cell[14782, 459, 594, 12, 104, "Text",
  CellTags->{"S6.16.1", "1.14"}],
Cell[15379, 473, 264, 9, 56, "MathCaption",
  CellTags->{"S6.16.1", "1.15"}],

Cell[CellGroupData[{
Cell[15668, 486, 70, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[15741, 490, 87, 2, 25, "Output",
  CellTags->"S6.16.1"]
}, Open  ]],
Cell[15843, 495, 182, 7, 40, "MathCaption",
  CellTags->{"S6.16.1", "1.16"}],
Cell[16028, 504, 76, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[16107, 508, 193, 5, 56, "MathCaption",
  CellTags->{"S6.16.1", "1.17"}],

Cell[CellGroupData[{
Cell[16325, 517, 89, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[16417, 521, 548, 11, 61, "Message",
  CellTags->"S6.16.1"]
}, Open  ]],
Cell[16980, 535, 150, 5, 40, "MathCaption",
  CellTags->{"S6.16.1", "1.18"}],
Cell[17133, 542, 74, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[17210, 546, 223, 6, 56, "MathCaption",
  CellTags->{"S6.16.1", "1.19"}],

Cell[CellGroupData[{
Cell[17458, 556, 99, 2, 28, "Input",
  CellTags->"S6.16.1"],
Cell[17560, 560, 119, 4, 25, "Output",
  CellTags->"S6.16.1"]
}, Open  ]],
Cell[17694, 567, 983, 21, 136, "Text",
  CellTags->{"S6.16.1", "1.20"}],
Cell[18680, 590, 884, 27, 46, "DefinitionBox",
  CellTags->"S6.16.1"],
Cell[19567, 619, 150, 5, 15, "Caption",
  CellTags->"S6.16.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19754, 629, 69, 1, 36, "Subsection",
  CellTags->{"S6.16.2", "2.1"}],
Cell[19826, 632, 529, 13, 88, "Text",
  CellTags->{"S6.16.2", "2.2"}],
Cell[20358, 647, 4780, 146, 160, "DefinitionBox",
  CellTags->"S6.16.2"],
Cell[25141, 795, 64, 1, 15, "Caption",
  CellTags->"S6.16.2"],
Cell[25208, 798, 685, 22, 72, "Text",
  CellTags->{"S6.16.2", "2.3"}],
Cell[25896, 822, 602, 12, 88, "Text",
  CellTags->{"S6.16.2", "2.4"}],
Cell[26501, 836, 751, 16, 120, "Text",
  CellTags->{"S6.16.2", "2.5"}],
Cell[27255, 854, 368, 11, 72, "MathCaption",
  CellTags->{"S6.16.2", "2.6"}],

Cell[CellGroupData[{
Cell[27648, 869, 72, 2, 28, "Input",
  CellTags->"S6.16.2"],
Cell[27723, 873, 530, 11, 105, "Output",
  CellTags->"S6.16.2"]
}, Open  ]],
Cell[28268, 887, 383, 13, 72, "MathCaption",
  CellTags->{"S6.16.2", "2.7"}],
Cell[28654, 902, 147, 5, 45, "Input",
  CellTags->"S6.16.2"],
Cell[28804, 909, 242, 9, 56, "MathCaption",
  CellTags->{"S6.16.2", "2.8"}],

Cell[CellGroupData[{
Cell[29071, 922, 98, 2, 28, "Input",
  CellTags->"S6.16.2"],
Cell[29172, 926, 177, 6, 25, "Output",
  CellTags->"S6.16.2"]
}, Open  ]],
Cell[29364, 935, 167, 5, 40, "MathCaption",
  CellTags->{"S6.16.2", "2.9"}],

Cell[CellGroupData[{
Cell[29556, 944, 72, 2, 28, "Input",
  CellTags->"S6.16.2"],
Cell[29631, 948, 530, 11, 105, "Output",
  CellTags->"S6.16.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30210, 965, 73, 1, 36, "Subsection",
  CellTags->{"S6.16.3", "3.1"}],
Cell[30286, 968, 400, 8, 72, "Text",
  CellTags->{"S6.16.3", "3.2"}],

Cell[CellGroupData[{
Cell[30711, 980, 79, 1, 34, "Subsubsection",
  CellTags->{"S6.16.3", "3.3"}],
Cell[30793, 983, 984, 31, 46, "DefinitionBox",
  CellTags->"S6.16.3"],
Cell[31780, 1016, 83, 1, 15, "Caption",
  CellTags->"S6.16.3"],
Cell[31866, 1019, 423, 7, 72, "Text",
  CellTags->{"S6.16.3", "3.4"}],
Cell[32292, 1028, 563, 14, 88, "Text",
  CellTags->{"S6.16.3", "3.5"}],
Cell[32858, 1044, 243, 7, 56, "MathCaption",
  CellTags->{"S6.16.3", "3.6"}],
Cell[33104, 1053, 76, 2, 28, "Input",
  CellTags->"S6.16.3"],
Cell[33183, 1057, 274, 9, 56, "MathCaption",
  CellTags->{"S6.16.3", "3.7"}],

Cell[CellGroupData[{
Cell[33482, 1070, 95, 2, 28, "Input",
  CellTags->"S6.16.3"],
Cell[33580, 1074, 32828, 615, 184, 3256, 244, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S6.16.3"],
Cell[66411, 1691, 178, 5, 25, "Output",
  CellTags->"S6.16.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[66638, 1702, 74, 1, 34, "Subsubsection",
  CellTags->{"S6.16.3", "3.8"}],
Cell[66715, 1705, 1334, 34, 168, "Text",
  CellTags->{"S6.16.3", "3.9"}],
Cell[68052, 1741, 3260, 88, 146, "DefinitionBox",
  CellTags->"S6.16.3"],
Cell[71315, 1831, 120, 5, 15, "Caption",
  CellTags->"S6.16.3"],
Cell[71438, 1838, 1221, 30, 184, "Text",
  CellTags->{"S6.16.3", "3.10"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[72708, 1874, 87, 1, 36, "Subsection",
  CellTags->{"S6.16.4", "4.1"}],
Cell[72798, 1877, 2923, 92, 108, "DefinitionBox",
  CellTags->"S6.16.4"],
Cell[75724, 1971, 177, 7, 15, "Caption",
  CellTags->"S6.16.4"],
Cell[75904, 1980, 1541, 57, 136, "Text",
  CellTags->{"S6.16.4", "4.2"}],
Cell[77448, 2039, 256, 6, 40, "Text",
  CellTags->{"S6.16.4", "4.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[77741, 2050, 167, 5, 54, "Subsection",
  CellTags->{"S6.16.5", "5.1"}],
Cell[77911, 2057, 402, 11, 56, "Text",
  CellTags->{"S6.16.5", "5.2"}],
Cell[78316, 2070, 5840, 181, 204, "DefinitionBox",
  CellTags->"S6.16.5"],
Cell[84159, 2253, 113, 3, 15, "Caption",
  CellTags->"S6.16.5"],
Cell[84275, 2258, 623, 16, 104, "Text",
  CellTags->{"S6.16.5", "5.3"}],
Cell[84901, 2276, 1497, 45, 64, "DefinitionBox",
  CellTags->"S6.16.5"],
Cell[86401, 2323, 141, 5, 15, "Caption",
  CellTags->"S6.16.5"],
Cell[86545, 2330, 194, 5, 56, "MathCaption",
  CellTags->{"S6.16.5", "5.4"}],

Cell[CellGroupData[{
Cell[86764, 2339, 75, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[86842, 2343, 1436, 27, 249, "Output",
  CellTags->"S6.16.5"]
}, Open  ]],
Cell[88293, 2373, 160, 5, 40, "MathCaption",
  CellTags->{"S6.16.5", "5.5"}],
Cell[88456, 2380, 96, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[88555, 2384, 292, 9, 56, "MathCaption",
  CellTags->{"S6.16.5", "5.6"}],

Cell[CellGroupData[{
Cell[88872, 2397, 75, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[88950, 2401, 1651, 30, 313, "Output",
  CellTags->"S6.16.5"]
}, Open  ]],
Cell[90616, 2434, 181, 5, 56, "MathCaption",
  CellTags->{"S6.16.5", "5.7"}],

Cell[CellGroupData[{
Cell[90822, 2443, 111, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[90936, 2447, 203, 5, 25, "Output",
  CellTags->"S6.16.5"]
}, Open  ]],
Cell[91154, 2455, 234, 5, 56, "MathCaption",
  CellTags->{"S6.16.5", "5.8"}],

Cell[CellGroupData[{
Cell[91413, 2464, 104, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[91520, 2468, 204, 5, 41, "Output",
  CellTags->"S6.16.5"]
}, Open  ]],
Cell[91739, 2476, 429, 15, 72, "MathCaption",
  CellTags->{"S6.16.5", "5.9"}],

Cell[CellGroupData[{
Cell[92193, 2495, 84, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[92280, 2499, 177, 6, 25, "Output",
  CellTags->"S6.16.5"]
}, Open  ]],
Cell[92472, 2508, 504, 14, 72, "MathCaption",
  CellTags->{"S6.16.5", "5.10"}],

Cell[CellGroupData[{
Cell[93001, 2526, 105, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[93109, 2530, 177, 6, 25, "Output",
  CellTags->"S6.16.5"]
}, Open  ]],
Cell[93301, 2539, 561, 13, 88, "Text",
  CellTags->{"S6.16.5", "5.11"}],
Cell[93865, 2554, 55, 1, 20, "ProgramTop",
  CellTags->{"S6.16.5", "5.12"}],
Cell[93923, 2557, 289, 13, 179, "Program",
  CellTags->{"S6.16.5", "5.13"}],
Cell[94215, 2572, 84, 1, 8, "ProgramBottom",
  CellTags->{"S6.16.5", "5.14"}],
Cell[94302, 2575, 115, 5, 15, "Caption",
  CellTags->"S6.16.5"],
Cell[94420, 2582, 723, 20, 104, "Text",
  CellTags->{"S6.16.5", "5.15"}],
Cell[95146, 2604, 79, 1, 40, "MathCaption",
  CellTags->{"S6.16.5", "5.16"}],
Cell[95228, 2607, 76, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[95307, 2611, 156, 5, 40, "MathCaption",
  CellTags->{"S6.16.5", "5.17"}],

Cell[CellGroupData[{
Cell[95488, 2620, 86, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[95577, 2624, 177, 6, 25, "Output",
  CellTags->"S6.16.5"]
}, Open  ]],
Cell[95769, 2633, 1112, 39, 136, "Text",
  CellTags->{"S6.16.5", "5.18"}],
Cell[96884, 2674, 379, 7, 72, "Text",
  CellTags->{"S6.16.5", "5.19"}],
Cell[97266, 2683, 55, 1, 20, "ProgramTop",
  CellTags->{"S6.16.5", "5.20"}],
Cell[97324, 2686, 332, 14, 194, "Program",
  CellTags->{"S6.16.5", "5.21"}],
Cell[97659, 2702, 84, 1, 8, "ProgramBottom",
  CellTags->{"S6.16.5", "5.22"}],
Cell[97746, 2705, 115, 5, 15, "Caption",
  CellTags->"S6.16.5"],
Cell[97864, 2712, 529, 17, 72, "Text",
  CellTags->{"S6.16.5", "5.23"}],
Cell[98396, 2731, 79, 1, 40, "MathCaption",
  CellTags->{"S6.16.5", "5.24"}],

Cell[CellGroupData[{
Cell[98500, 2736, 76, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[98579, 2740, 536, 11, 47, "Message",
  CellTags->"S6.16.5"]
}, Open  ]],
Cell[99130, 2754, 230, 11, 40, "MathCaption",
  CellTags->{"S6.16.5", "5.25"}],

Cell[CellGroupData[{
Cell[99385, 2769, 86, 2, 28, "Input",
  CellTags->"S6.16.5"],
Cell[99474, 2773, 177, 6, 25, "Output",
  CellTags->"S6.16.5"]
}, Open  ]],
Cell[99666, 2782, 497, 9, 88, "Text",
  CellTags->{"S6.16.5", "5.26"}],
Cell[100166, 2793, 256, 5, 56, "Text",
  CellTags->{"S6.16.5", "5.27"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

