(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     73300,       2474]*)
(*NotebookOutlinePosition[     78980,       2643]*)
(*  CellTagsIndexPosition[     78515,       2621]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Calculus",
 StyleBox["`", "MB"],
 "VariationalMethods",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.15.1", "1.1"}],

Cell[TextData[{
 "The basic problem of the calculus of variations is to determine the \
function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " that extremizes a functional ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["F",
     "TI"], "=", 
    SubsuperscriptBox["\[Integral]", 
     StyleBox[
      RowBox[{"x", "m", "i", "n"}],
      "TI"], 
     StyleBox[
      RowBox[{"x", "m", "a", "x"}],
      "TI"]], 
    StyleBox["f",
     "TI"], 
    RowBox[{"[", 
     RowBox[{
      StyleBox["u",
       "TI"], 
      RowBox[{"(", 
       StyleBox["x",
        "TI"], ")"}], ",", 
      SuperscriptBox[
       StyleBox["u",
        "TI"], "\[Prime]"], 
      RowBox[{"(", 
       StyleBox["x",
        "TI"], ")"}], ",", 
      StyleBox["x",
       "TI"]}], "]"}], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". In general, there can be more than one independent variable and the \
integrand ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " can depend on several functions and their higher derivatives. "
}], "Text",
 CellTags->{"S5.15.1", "1.2"}],

Cell[TextData[{
 "The extremal functions are solutions of the Euler(\[Hyphen]Lagrange) \
equations that are obtained by setting the first variational derivatives of \
the functional ",
 Cell[BoxData[
  FormBox[
   StyleBox["F",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with respect to each function equal to zero. Since many ordinary and \
partial differential equations that occur in physics and engineering can be \
derived as the Euler equations for appropriate functionals, variational \
methods are of general utility. "
}], "Text",
 CellTags->{"S5.15.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["VariationalD[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], VariationalD[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the first variational derivative of the functional ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["F",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" defined by the integrand ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" depends on one function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and one independent variable ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" or several independent variables ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["x",
          "TI"], ",", 
         StyleBox["y",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VariationalD[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["v", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give a list of the first variational derivatives of the functional ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        StyleBox["F",
         "TI"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" defined by the integrand ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" depends on several functions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["u",
          "TI"], ",", 
         StyleBox["v",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and several independent variables ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["x",
          "TI"], ",", 
         StyleBox["y",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EulerEquations[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], EulerEquations[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the Euler equation for the integrand ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" depends on one function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and one independent variable ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" or several independent variables ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["x",
          "TI"], ",", 
         StyleBox["y",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["EulerEquations[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["v", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], \[Ellipsis] }, {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] }]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give a list of the Euler equations for the integrand ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" depends on several functions ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["u",
          "TI"], ",", 
         StyleBox["v",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and several independent variables ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["x",
          "TI"], ",", 
         StyleBox["y",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.15.1"],

Cell["First variational derivatives and Euler equations. ", "Caption",
 CellTags->"S5.15.1"],

Cell[TextData[{
 StyleBox["VariationalD", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " gives the first variational derivatives of a functional ",
 Cell[BoxData[
  FormBox[
   StyleBox["F",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " defined by the integrand ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " may depend on several functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u",
     "TI"], ",", 
    StyleBox["v",
     "TI"], ",", 
    StyleBox["w",
     "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "; their derivatives of arbitrary order; and variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], ",", 
    StyleBox["y",
     "TI"], ",", 
    StyleBox["z",
     "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[ThinSpace]. ",
 StyleBox["EulerEquations", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " returns the Euler(\[Hyphen]Lagrange) equations given the integrand ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Again ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " may depend on several functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u",
     "TI"], ",", 
    StyleBox["v",
     "TI"], ",", 
    StyleBox["w",
     "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "; their derivatives of arbitrary order; and variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x",
     "TI"], ",", 
    StyleBox["y",
     "TI"], ",", 
    StyleBox["z",
     "TI"], "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[ThinSpace]. "
}], "Text",
 CellTags->{"S5.15.1", "1.4"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.15.1", "1.5"}],

Cell["<<Calculus`VariationalMethods`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.15.1"],

Cell[TextData[{
 "This is the first variational derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["F",
     "TI"], "=", 
    SubsuperscriptBox["\[Integral]", 
     StyleBox[
      RowBox[{"x", "m", "i", "n"}],
      "TI"], 
     StyleBox[
      RowBox[{"x", "m", "a", "x"}],
      "TI"]], 
    StyleBox["y",
     "TI"], 
    RowBox[{"(", 
     StyleBox["x",
      "TI"], ")"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       StyleBox["y",
        "TI"], "\[Prime]"], 
      SuperscriptBox[
       RowBox[{"(", 
        StyleBox["x",
         "TI"], ")"}], "2"]}]], "\[DifferentialD]", 
    StyleBox["x",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.15.1", "1.6"}],

Cell[CellGroupData[{

Cell["VariationalD[y[x] Sqrt[1+y'[x]^2], y[x], x]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.15.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "2"], "-", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], " ", 
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "2"]}], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.15.1"]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is the Lagrangian for the simple pendulum and ",
 StyleBox["EulerEquations", "MR"],
 " gives the pendulum equation. "
}], "MathCaption",
 CellTags->{"S5.15.1", "1.7"}],

Cell[CellGroupData[{

Cell["\<\
EulerEquations[
  m l^2 theta'[t]^2/2+m g l Cos[theta[t]],
    theta[t], t]\
\>", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.15.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "l"}], " ", "m", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"g", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"theta", "[", "t", "]"}], "]"}]}], "+", 
     RowBox[{"l", " ", 
      RowBox[{
       SuperscriptBox["theta", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.15.1"]
}, Open  ]],

Cell[TextData[{
 "This package defines several coordinates systems as well as the ",
 StyleBox["Grad", "MR"],
 " function. "
}], "MathCaption",
 CellTags->{"S5.15.1", "1.8"}],

Cell["<<Calculus`VectorAnalysis`", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.15.1"],

Cell[TextData[{
 "The default coordinate system is set to Cartesian and the coordinates are \
set to ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.15.1", "1.9"}],

Cell["SetCoordinates[Cartesian[x, y, z]];", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.15.1"],

Cell["\<\
This generates Laplace\[CloseCurlyQuote]s equation. \
\>", "MathCaption",
 CellTags->{"S5.15.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
EulerEquations[
 Grad[phi[x,y,z]].Grad[phi[x,y,z]]/2,
    phi[x,y,z], {x,y,z}]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.15.1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["phi", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["phi", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], "-", 
   RowBox[{
    SuperscriptBox["phi", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}]}], "\[Equal]", "0"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.15.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["FirstIntegrals[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], FirstIntegrals[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", {", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["v", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["] , \[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give first integrals when the integrand ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is independent of one or more of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["],", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["v", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["], \[Ellipsis] }", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", or independent of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["FirstIntegral[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["first integral associated with the variable ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" (appears in the output of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["FirstIntegrals", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[") ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.15.1"],

Cell["First integrals. ", "Caption",
 CellTags->"S5.15.1"],

Cell[TextData[{
 "When there is only one independent variable ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 StyleBox["FirstIntegrals", "MR"],
 " gives conserved quantities in the following cases: \
(1)\[NonBreakingSpace]if ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " does not depend on a coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " explicitly, it is referred to as an ignorable coordinate and the \
corresponding Euler equation possesses an obvious first integral (a conserved \
generalized momentum), and (2)\[NonBreakingSpace]if ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " depends on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["u",
     "TI"], ",", 
    StyleBox["v",
     "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and their first derivatives only and has no explicit ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " dependence, ",
 StyleBox["FirstIntegrals", "MR"],
 " also returns the first integral corresponding to the Hamiltonian. "
}], "Text",
 CellTags->{"S5.15.1", "1.11"}],

Cell[TextData[{
 "The Lagrangian for central force motion has an ignorable coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (angular momentum conservation) and is independent of time ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " (energy conservation). ",
 StyleBox["FirstIntegrals", "MR"],
 " yields both the first integral corresponding to coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the first integral corresponding to the Hamiltonian. "
}], "MathCaption",
 CellTags->{"S5.15.1", "1.12"}],

Cell[CellGroupData[{

Cell["\<\
FirstIntegrals[m(r'[t]^2+r[t]^2 phi'[t]^2)/
 2-U[r], {r[t],phi[t]}, t]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.15.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"FirstIntegral", "[", "phi", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", "m"}], " ", 
     SuperscriptBox[
      RowBox[{"r", "[", "t", "]"}], "2"], " ", 
     RowBox[{
      SuperscriptBox["phi", "\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"FirstIntegral", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"U", "[", "r", "]"}]}], "+", 
       RowBox[{"m", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"r", "[", "t", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["phi", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "2"]}], "+", 
          SuperscriptBox[
           RowBox[{
            SuperscriptBox["r", "\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "2"]}], ")"}]}]}], 
      ")"}]}]}]}], "}"}]], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.15.1"]
}, Open  ]],

Cell[TextData[{
 "The Ritz variational principle affords a powerful technique for the \
approximate solution of (1)\[NonBreakingSpace]eigenvalue problems ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["A",
     "TB"], 
    StyleBox["u",
     "TI"], "=", "\[Lambda]", 
    StyleBox["w",
     "TI"], 
    StyleBox["u",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["A",
    "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is an operator and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["w",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x",
       "TI"], ",", 
      StyleBox["y",
       "TI"], ",", "\[Ellipsis]"}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a weight function and (2)\[NonBreakingSpace]problems of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["B",
     "TB"], 
    StyleBox["u",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x",
       "TI"], ",", 
      StyleBox["y",
       "TI"], ",", "\[Ellipsis]"}], ")"}], "=", 
    StyleBox["h",
     "TI"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x",
       "TI"], ",", 
      StyleBox["y",
       "TI"], ",", "\[Ellipsis]"}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["B",
    "TB"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is a positive definite operator and ",
 Cell[BoxData[
  FormBox[
   StyleBox["h",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is given. A judicious choice for the trial function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["u",
      "TI"], 
     StyleBox["t",
      "TI"]], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x",
       "TI"], ",", 
      StyleBox["y",
       "TI"], ",", "\[Ellipsis]"}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " that satisfies boundary conditions and depends on variational parameters \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     StyleBox["a",
      "TI"], ",", 
     StyleBox["b",
      "TI"], ",", "\[Ellipsis]"}], "}"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " must be given in both cases. For (1) ",
 StyleBox["VariationalBound[{", "MR"],
 StyleBox["f", "TI"],
 StyleBox[",", "MR"],
 StyleBox["g", "TI"],
 StyleBox["}, ", "MR"],
 StyleBox["u", "TI"],
 StyleBox["[", "MR"],
 StyleBox["x", "TI"],
 StyleBox[",", "MR"],
 StyleBox["y", "TI"],
 StyleBox[",\[Ellipsis] ],", "MR"],
 " ",
 StyleBox["{{", "MR"],
 StyleBox["x", "TI"],
 StyleBox[",", "MR"],
 StyleBox["xmin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["xmax", "TI"],
 StyleBox["}, {", "MR"],
 StyleBox["y", "TI"],
 StyleBox[",", "MR"],
 StyleBox["ymin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["ymax", "TI"],
 StyleBox["},\[Ellipsis] }, ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["u",
     "TI"], 
    StyleBox["t",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", {", "MR"],
 StyleBox["a", "TI"],
 StyleBox[",", "MR"],
 StyleBox["amin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["amax", "TI"],
 StyleBox["}, {", "MR"],
 StyleBox["b", "TI"],
 StyleBox[",", "MR"],
 StyleBox["bmin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["bmax", "TI"],
 StyleBox["}, \[Ellipsis] ]", "MR"],
 " extremizes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       StyleBox[
        RowBox[{"x", "m", "i", "n"}],
        "TI"], 
       StyleBox[
        RowBox[{"x", "m", "a", "x"}],
        "TI"]], "\[DifferentialD]", 
      StyleBox["x",
       "TI"], 
      SubsuperscriptBox["\[Integral]", 
       StyleBox[
        RowBox[{"y", "m", "i", "n"}],
        "TI"], 
       StyleBox[
        RowBox[{"y", "m", "a", "x"}],
        "TI"]], "\[DifferentialD]", 
      StyleBox["y",
       "TI"], "\[Ellipsis]", 
      StyleBox["f",
       "TI"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       StyleBox[
        RowBox[{"x", "m", "i", "n"}],
        "TI"], 
       StyleBox[
        RowBox[{"x", "m", "a", "x"}],
        "TI"]], "\[DifferentialD]", 
      StyleBox["x",
       "TI"], 
      SubsuperscriptBox["\[Integral]", 
       StyleBox[
        RowBox[{"y", "m", "i", "n"}],
        "TI"], 
       StyleBox[
        RowBox[{"y", "m", "a", "x"}],
        "TI"]], "\[DifferentialD]", 
      StyleBox["y",
       "TI"], "\[Ellipsis]", 
      StyleBox["g",
       "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f",
     "TI"], "=", 
    StyleBox["u",
     "TI"], 
    StyleBox["A",
     "TB"], 
    StyleBox["u",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["g",
     "TI"], "=", 
    StyleBox["u",
     "TI"], 
    StyleBox["w",
     "TI"], 
    StyleBox["u",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". The result is an upper bound on the corresponding eigenvalue and optimal \
values for the parameters. For (2) ",
 StyleBox["VariationalBound[", "MR"],
 StyleBox["f", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["u", "TI"],
 StyleBox["[", "MR"],
 StyleBox["x", "TI"],
 StyleBox[",", "MR"],
 StyleBox["y", "TI"],
 StyleBox[",\[Ellipsis] ], {{", "MR"],
 StyleBox["x", "TI"],
 StyleBox[",", "MR"],
 StyleBox["xmin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["xmax", "TI"],
 StyleBox["},{", "MR"],
 StyleBox["y", "TI"],
 StyleBox[",", "MR"],
 StyleBox["ymin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["ymax", "TI"],
 StyleBox["},\[Ellipsis] }, ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["u",
     "TI"], 
    StyleBox["t",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", {", "MR"],
 StyleBox["a", "TI"],
 StyleBox[",", "MR"],
 StyleBox["amin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["amax", "TI"],
 StyleBox["},", "MR"],
 " ",
 StyleBox["{", "MR"],
 StyleBox["b", "TI"],
 StyleBox[",", "MR"],
 StyleBox["bmin", "TI"],
 StyleBox[",", "MR"],
 StyleBox["bmax", "TI"],
 StyleBox["}, \[Ellipsis] ]", "MR"],
 " extremizes the functional ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["F",
     "TI"], "=", 
    SubsuperscriptBox["\[Integral]", 
     StyleBox[
      RowBox[{"x", "m", "i", "n"}],
      "TI"], 
     StyleBox[
      RowBox[{"x", "m", "a", "x"}],
      "TI"]], "\[DifferentialD]", 
    StyleBox["x",
     "TI"], 
    SubsuperscriptBox["\[Integral]", 
     StyleBox[
      RowBox[{"y", "m", "i", "n"}],
      "TI"], 
     StyleBox[
      RowBox[{"y", "m", "a", "x"}],
      "TI"]], "\[DifferentialD]", 
    StyleBox["y",
     "TI"], "\[Ellipsis]", 
    StyleBox["f",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["f",
     "TI"], "=", 
    StyleBox["u",
     "TI"], 
    StyleBox["B",
     "TB"], 
    StyleBox["u",
     "TI"], " ", "-", "2", 
    StyleBox["u",
     "TI"], 
    StyleBox["h",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and yields the value of the functional and the optimal parameters. ",
 StyleBox["VariationalBound", "MR"],
 " can also be used to extremize general functionals given appropriate trial \
functions. ",
 StyleBox["NVariationalBound", "MR"],
 " performs the same functions as ",
 StyleBox["VariationalBound", "MR"],
 " numerically. It uses the internal function ",
 StyleBox["FindMinimum", "MR"],
 " and has the same options and input format for parameters. "
}], "Text",
 CellTags->{"S5.15.1", "1.13"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["VariationalBound[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},\[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], 
         StyleBox["t",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["amin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["amax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["bmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["bmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},\[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give an upper bound for the eigenvalue and the optimal values of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["a",
          "TI"], ",", 
         StyleBox["b",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the range ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["{", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"{", 
         RowBox[{
          StyleBox["a",
           "TI"], 
          StyleBox["m",
           "TI"], 
          StyleBox["i",
           "TI"], 
          StyleBox["n",
           "TI"], ",", 
          StyleBox["a",
           "TI"], 
          StyleBox["m",
           "TI"], 
          StyleBox["a",
           "TI"], 
          StyleBox["x",
           "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"{", 
         RowBox[{
          StyleBox["b",
           "TI"], 
          StyleBox["m",
           "TI"], 
          StyleBox["i",
           "TI"], 
          StyleBox["n",
           "TI"], ",", 
          StyleBox["b",
           "TI"], 
          StyleBox["m",
           "TI"], 
          StyleBox["a",
           "TI"], 
          StyleBox["x",
           "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[ThinSpace]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["}", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["VariationalBound[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},\[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], 
         StyleBox["t",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["amin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["amax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["bmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["bmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},\[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the value of the functional and optimal values of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["a",
          "TI"], ",", 
         StyleBox["b",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NVariationalBound[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["g", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},\[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], 
         StyleBox["t",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["amin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["amax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["bmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["bmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},\[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "evaluate numerically an upper bound for the eigenvalue and the optimal \
values of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["a",
          "TI"], ",", 
         StyleBox["b",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the range ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["{", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"{", 
         RowBox[{
          StyleBox["a",
           "TI"], 
          StyleBox["m",
           "TI"], 
          StyleBox["i",
           "TI"], 
          StyleBox["n",
           "TI"], ",", 
          StyleBox["a",
           "TI"], 
          StyleBox["m",
           "TI"], 
          StyleBox["a",
           "TI"], 
          StyleBox["x",
           "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"{", 
         RowBox[{
          StyleBox["b",
           "TI"], 
          StyleBox["m",
           "TI"], 
          StyleBox["i",
           "TI"], 
          StyleBox["n",
           "TI"], ",", 
          StyleBox["b",
           "TI"], 
          StyleBox["m",
           "TI"], 
          StyleBox["a",
           "TI"], 
          StyleBox["x",
           "TI"]}], "}"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[ThinSpace]",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{"\[Ellipsis]", " "}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["}", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" given initial values ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["a",
           "TI"], "0"], ",", 
         SubscriptBox[
          StyleBox["b",
           "TI"], "0"], ",", "\[Ellipsis]"}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["NVariationalBound[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["u", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",\[Ellipsis] ], {{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["x", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["xmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["y", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ymax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},\[Ellipsis] }, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["u",
          "TI"], 
         StyleBox["t",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"},
    {Cell[TextData[{
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["a", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["a",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["amin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["amax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["b", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["b",
          "TI"], "0"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["bmin", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["bmax", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["},\[Ellipsis] ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "evaluate numerically the value of the functional and optimal values of \
",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         StyleBox["a",
          "TI"], ",", 
         StyleBox["b",
          "TI"], ",", "\[Ellipsis]"}], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" given initial values ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        RowBox[{
         SubscriptBox[
          StyleBox["a",
           "TI"], "0"], ",", 
         SubscriptBox[
          StyleBox["b",
           "TI"], "0"], ",", "\[Ellipsis]"}], TraditionalForm]], 
       "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.15.1"],

Cell["Ritz variational bounds. ", "Caption",
 CellTags->"S5.15.1"],

Cell[TextData[{
 "A trial (wave) function for the 2s state of the hydrogen atom with one node \
at ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " yields the exact energy in units of Rydbergs. Note that the volume element \
",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["r",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is included in functional parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["f",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["g",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and the default range for the parameters is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], ")"}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.15.1", "1.14"}],

Cell[CellGroupData[{

Cell["\<\
VariationalBound[{(-u[r] D[r^2 u'[r],r]/r^2-2u[r]^2/r)r^2,
u[r]^2 r^2},u[r],
{r,0,Infinity},(a-r)E^(-b r),{a},{b}]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.15.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.25`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "2.`"}], ",", 
     RowBox[{"b", "\[Rule]", "0.5`"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.15.1"]
}, Open  ]],

Cell[TextData[{
 "The problem of the torsion of a rod of square cross section involves \
solving ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Del]", "2"], 
    StyleBox["u",
     "TI"], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " vanishes on the boundary. ",
 StyleBox["VariationalBound", "MR"],
 " gives optimal values of parameters for the approximate solution. "
}], "MathCaption",
 CellTags->{"S5.15.1", "1.15"}],

Cell[CellGroupData[{

Cell["\<\
VariationalBound[-u[x,y](D[u[x,y],{x,2}]+
   D[u[x,y],{y,2}]) -2u[x,y],u[x,y],
{{x,-a,a},{y,-a,a}},
(x^2-a^2)(y^2-a^2)(a1+a2(x^2+y^2)),
{a1},{a2}]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.15.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.5615724027276375`"}], " ", 
    SuperscriptBox["a", "4"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a1", "\[Rule]", 
      FractionBox["0.2921931407942238`", 
       SuperscriptBox["a", "2"]]}], ",", 
     RowBox[{"a2", "\[Rule]", 
      FractionBox["0.05922833935018051`", 
       SuperscriptBox["a", "4"]]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.15.1"]
}, Open  ]],

Cell[TextData[{
 "The ground state energy of the one\[Hyphen]dimensional quantum anharmonic \
oscillator is determined for the given trial (wave) function by ",
 StyleBox["NVariationalBound", "MR"],
 ". Note that the default range for the parameters is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], ")"}], 
   TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the initial values are specified. "
}], "MathCaption",
 CellTags->{"S5.15.1", "1.16"}],

Cell[CellGroupData[{

Cell["\<\
NVariationalBound[
 {u'[x]^2+(x^2+x^4)u[x]^2/4, u[x]^2},
    u[x], {x,-Infinity,Infinity},
    E^(-a x^2)(1+b x^2), {a,0.5},{b,0.1}]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.15.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8041748174596697`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", "0.7413598014999996`"}], ",", 
     RowBox[{"b", "\[Rule]", "0.3655562010111997`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.15.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.15.1"->{
    Cell[1776, 53, 143, 6, 36, "Subsection",
      CellTags->{"S5.15.1", "1.1"}],
    Cell[1922, 61, 1406, 54, 58, "Text",
      CellTags->{"S5.15.1", "1.2"}],
    Cell[3331, 117, 623, 14, 72, "Text",
      CellTags->{"S5.15.1", "1.3"}],
    Cell[3957, 133, 15344, 469, 288, "DefinitionBox",
      CellTags->"S5.15.1"],
    Cell[19304, 604, 92, 1, 15, "Caption",
      CellTags->"S5.15.1"],
    Cell[19399, 607, 2308, 84, 88, "Text",
      CellTags->{"S5.15.1", "1.4"}],
    Cell[21710, 693, 78, 1, 40, "MathCaption",
      CellTags->{"S5.15.1", "1.5"}],
    Cell[21791, 696, 93, 2, 28, "Input",
      CellTags->"S5.15.1"],
    Cell[21887, 700, 793, 33, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.6"}],
    Cell[22705, 737, 106, 2, 70, "Input",
      CellTags->"S5.15.1"],
    Cell[22814, 741, 629, 21, 70, "Output",
      CellTags->"S5.15.1"],
    Cell[23458, 765, 332, 11, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.7"}],
    Cell[23815, 780, 146, 6, 70, "Input",
      CellTags->"S5.15.1"],
    Cell[23964, 788, 443, 15, 70, "Output",
      CellTags->"S5.15.1"],
    Cell[24422, 806, 174, 5, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.8"}],
    Cell[24599, 813, 89, 2, 70, "Input",
      CellTags->"S5.15.1"],
    Cell[24691, 817, 585, 22, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.9"}],
    Cell[25279, 841, 98, 2, 70, "Input",
      CellTags->"S5.15.1"],
    Cell[25380, 845, 115, 3, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.10"}],
    Cell[25520, 852, 149, 6, 70, "Input",
      CellTags->"S5.15.1"],
    Cell[25672, 860, 820, 29, 70, "Output",
      CellTags->"S5.15.1"],
    Cell[26507, 892, 5001, 155, 70, "DefinitionBox",
      CellTags->"S5.15.1"],
    Cell[31511, 1049, 58, 1, 70, "Caption",
      CellTags->"S5.15.1"],
    Cell[31572, 1052, 1565, 49, 70, "Text",
      CellTags->{"S5.15.1", "1.11"}],
    Cell[33140, 1103, 765, 19, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.12"}],
    Cell[33930, 1126, 141, 5, 70, "Input",
      CellTags->"S5.15.1"],
    Cell[34074, 1133, 1142, 36, 70, "Output",
      CellTags->"S5.15.1"],
    Cell[35231, 1172, 8134, 322, 70, "Text",
      CellTags->{"S5.15.1", "1.13"}],
    Cell[43368, 1496, 25763, 818, 70, "DefinitionBox",
      CellTags->"S5.15.1"],
    Cell[69134, 2316, 66, 1, 70, "Caption",
      CellTags->"S5.15.1"],
    Cell[69203, 2319, 1122, 38, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.14"}],
    Cell[70350, 2361, 185, 6, 70, "Input",
      CellTags->"S5.15.1"],
    Cell[70538, 2369, 260, 9, 70, "Output",
      CellTags->"S5.15.1"],
    Cell[70813, 2381, 655, 21, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.15"}],
    Cell[71493, 2406, 217, 8, 70, "Input",
      CellTags->"S5.15.1"],
    Cell[71713, 2416, 467, 15, 70, "Output",
      CellTags->"S5.15.1"],
    Cell[72195, 2434, 555, 14, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.16"}],
    Cell[72775, 2452, 204, 7, 70, "Input",
      CellTags->"S5.15.1"],
    Cell[72982, 2461, 290, 9, 70, "Output",
      CellTags->"S5.15.1"]},
  "1.1"->{
    Cell[1776, 53, 143, 6, 36, "Subsection",
      CellTags->{"S5.15.1", "1.1"}]},
  "1.2"->{
    Cell[1922, 61, 1406, 54, 58, "Text",
      CellTags->{"S5.15.1", "1.2"}]},
  "1.3"->{
    Cell[3331, 117, 623, 14, 72, "Text",
      CellTags->{"S5.15.1", "1.3"}]},
  "1.4"->{
    Cell[19399, 607, 2308, 84, 88, "Text",
      CellTags->{"S5.15.1", "1.4"}]},
  "1.5"->{
    Cell[21710, 693, 78, 1, 40, "MathCaption",
      CellTags->{"S5.15.1", "1.5"}]},
  "1.6"->{
    Cell[21887, 700, 793, 33, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.6"}]},
  "1.7"->{
    Cell[23458, 765, 332, 11, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.7"}]},
  "1.8"->{
    Cell[24422, 806, 174, 5, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.8"}]},
  "1.9"->{
    Cell[24691, 817, 585, 22, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.9"}]},
  "1.10"->{
    Cell[25380, 845, 115, 3, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.10"}]},
  "1.11"->{
    Cell[31572, 1052, 1565, 49, 70, "Text",
      CellTags->{"S5.15.1", "1.11"}]},
  "1.12"->{
    Cell[33140, 1103, 765, 19, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.12"}]},
  "1.13"->{
    Cell[35231, 1172, 8134, 322, 70, "Text",
      CellTags->{"S5.15.1", "1.13"}]},
  "1.14"->{
    Cell[69203, 2319, 1122, 38, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.14"}]},
  "1.15"->{
    Cell[70813, 2381, 655, 21, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.15"}]},
  "1.16"->{
    Cell[72195, 2434, 555, 14, 70, "MathCaption",
      CellTags->{"S5.15.1", "1.16"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.15.1", 73923, 2490},
  {"1.1", 76953, 2569},
  {"1.2", 77047, 2572},
  {"1.3", 77137, 2575},
  {"1.4", 77227, 2578},
  {"1.5", 77319, 2581},
  {"1.6", 77415, 2584},
  {"1.7", 77513, 2587},
  {"1.8", 77611, 2590},
  {"1.9", 77708, 2593},
  {"1.10", 77807, 2596},
  {"1.11", 77906, 2599},
  {"1.12", 78001, 2602},
  {"1.13", 78102, 2605},
  {"1.14", 78198, 2608},
  {"1.15", 78300, 2611},
  {"1.16", 78401, 2614}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 143, 6, 36, "Subsection",
  CellTags->{"S5.15.1", "1.1"}],
Cell[1922, 61, 1406, 54, 58, "Text",
  CellTags->{"S5.15.1", "1.2"}],
Cell[3331, 117, 623, 14, 72, "Text",
  CellTags->{"S5.15.1", "1.3"}],
Cell[3957, 133, 15344, 469, 288, "DefinitionBox",
  CellTags->"S5.15.1"],
Cell[19304, 604, 92, 1, 15, "Caption",
  CellTags->"S5.15.1"],
Cell[19399, 607, 2308, 84, 88, "Text",
  CellTags->{"S5.15.1", "1.4"}],
Cell[21710, 693, 78, 1, 40, "MathCaption",
  CellTags->{"S5.15.1", "1.5"}],
Cell[21791, 696, 93, 2, 28, "Input",
  CellTags->"S5.15.1"],
Cell[21887, 700, 793, 33, 70, "MathCaption",
  CellTags->{"S5.15.1", "1.6"}],

Cell[CellGroupData[{
Cell[22705, 737, 106, 2, 70, "Input",
  CellTags->"S5.15.1"],
Cell[22814, 741, 629, 21, 70, "Output",
  CellTags->"S5.15.1"]
}, Open  ]],
Cell[23458, 765, 332, 11, 70, "MathCaption",
  CellTags->{"S5.15.1", "1.7"}],

Cell[CellGroupData[{
Cell[23815, 780, 146, 6, 70, "Input",
  CellTags->"S5.15.1"],
Cell[23964, 788, 443, 15, 70, "Output",
  CellTags->"S5.15.1"]
}, Open  ]],
Cell[24422, 806, 174, 5, 70, "MathCaption",
  CellTags->{"S5.15.1", "1.8"}],
Cell[24599, 813, 89, 2, 70, "Input",
  CellTags->"S5.15.1"],
Cell[24691, 817, 585, 22, 70, "MathCaption",
  CellTags->{"S5.15.1", "1.9"}],
Cell[25279, 841, 98, 2, 70, "Input",
  CellTags->"S5.15.1"],
Cell[25380, 845, 115, 3, 70, "MathCaption",
  CellTags->{"S5.15.1", "1.10"}],

Cell[CellGroupData[{
Cell[25520, 852, 149, 6, 70, "Input",
  CellTags->"S5.15.1"],
Cell[25672, 860, 820, 29, 70, "Output",
  CellTags->"S5.15.1"]
}, Open  ]],
Cell[26507, 892, 5001, 155, 70, "DefinitionBox",
  CellTags->"S5.15.1"],
Cell[31511, 1049, 58, 1, 70, "Caption",
  CellTags->"S5.15.1"],
Cell[31572, 1052, 1565, 49, 70, "Text",
  CellTags->{"S5.15.1", "1.11"}],
Cell[33140, 1103, 765, 19, 70, "MathCaption",
  CellTags->{"S5.15.1", "1.12"}],

Cell[CellGroupData[{
Cell[33930, 1126, 141, 5, 70, "Input",
  CellTags->"S5.15.1"],
Cell[34074, 1133, 1142, 36, 70, "Output",
  CellTags->"S5.15.1"]
}, Open  ]],
Cell[35231, 1172, 8134, 322, 70, "Text",
  CellTags->{"S5.15.1", "1.13"}],
Cell[43368, 1496, 25763, 818, 70, "DefinitionBox",
  CellTags->"S5.15.1"],
Cell[69134, 2316, 66, 1, 70, "Caption",
  CellTags->"S5.15.1"],
Cell[69203, 2319, 1122, 38, 70, "MathCaption",
  CellTags->{"S5.15.1", "1.14"}],

Cell[CellGroupData[{
Cell[70350, 2361, 185, 6, 70, "Input",
  CellTags->"S5.15.1"],
Cell[70538, 2369, 260, 9, 70, "Output",
  CellTags->"S5.15.1"]
}, Open  ]],
Cell[70813, 2381, 655, 21, 70, "MathCaption",
  CellTags->{"S5.15.1", "1.15"}],

Cell[CellGroupData[{
Cell[71493, 2406, 217, 8, 70, "Input",
  CellTags->"S5.15.1"],
Cell[71713, 2416, 467, 15, 70, "Output",
  CellTags->"S5.15.1"]
}, Open  ]],
Cell[72195, 2434, 555, 14, 70, "MathCaption",
  CellTags->{"S5.15.1", "1.16"}],

Cell[CellGroupData[{
Cell[72775, 2452, 204, 7, 70, "Input",
  CellTags->"S5.15.1"],
Cell[72982, 2461, 290, 9, 70, "Output",
  CellTags->"S5.15.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

