(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     86362,       2890]*)
(*NotebookOutlinePosition[    100863,       3313]*)
(*  CellTagsIndexPosition[     99648,       3261]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Calculus",
 StyleBox["`", "MB"],
 "VectorAnalysis",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.16.1", "1.1"}],

Cell["\<\
A three\[Hyphen]dimensional coordinate system assigns three numbers to each \
point in space. In defining a coordinate system, you have to make a choice \
about what to measure and how to measure it. Frequently, physical systems \
exhibit special symmetries or structures that make a particular coordinate \
system especially useful. In a mathematically elegant solution to problems \
related to these systems, often the main step is choosing the correct \
coordinates. \
\>", "Text",
 CellTags->{"S5.16.1", "1.2"}],

Cell[TextData[{
 "A variety of tools for doing calculus in various three\[Hyphen]dimensional \
coordinate systems are provided in this package. Because a given symbolic or \
numeric expression can mean different things in different coordinate systems, \
",
 StyleBox["Mathematica", "TI"],
 " must know what coordinate system you are using and what the coordinate \
variables are. The initial default coordinate system is ",
 StyleBox["Cartesian", "MR"],
 ", with coordinate variables ",
 StyleBox["Xx", "MR"],
 ", ",
 StyleBox["Yy", "MR"],
 ", and ",
 StyleBox["Zz", "MR"],
 ". If you frequently work in another system, it may be useful to change the \
default to that system using ",
 StyleBox["SetCoordinates", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.16.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["CoordinateSystem", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "the name of the default coordinate system",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Coordinates[ ]", "MR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the default variables in the default coordinate system",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Coordinates[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the default variables in the coordinate system ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SetCoordinates[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the default coordinate system to be ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with default variables",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SetCoordinates[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vars", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the default coordinate system to be ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with variables ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vars", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.16.1"],

Cell["Coordinate systems and coordinate variables. ", "Caption",
 CellTags->"S5.16.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.16.1", "1.4"}],

Cell["<<Calculus`VectorAnalysis`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.16.1"],

Cell["This resets the default coordinate system and variables. ", \
"MathCaption",
 CellTags->{"S5.16.1", "1.5"}],

Cell[CellGroupData[{

Cell["SetCoordinates[Paraboloidal[w1, w2, w3]]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"Paraboloidal", "[", 
  RowBox[{"w1", ",", "w2", ",", "w3"}], "]"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell["Here are the new defaults. ", "MathCaption",
 CellTags->{"S5.16.1", "1.6"}],

Cell[CellGroupData[{

Cell["{CoordinateSystem, Coordinates[ ]}", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Paraboloidal", ",", 
   RowBox[{"{", 
    RowBox[{"w1", ",", "w2", ",", "w3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "All coordinate systems can be viewed as arising from three \
one\[Hyphen]parameter families of surfaces. The three numbers assigned to \
each point (",
 StyleBox["i.e.", "TI"],
 ", its coordinates) simply tell you to which member of each family the point \
belongs. Members of these families are called ",
 StyleBox["coordinate surfaces", "TI"],
 ". In the simplest example, the ",
 StyleBox["Cartesian", "MR"],
 " system, the coordinate surfaces are members of families of planes parallel \
to the coordinate planes. In more complicated systems, the coordinate \
surfaces often belong to families of quadric surfaces such as ellipsoids, \
hyperboloids or elliptic paraboloids. In certain cases the families of \
coordinate surfaces depend on parameters such as focal distances or radii. In \
these cases the coordinate system as a whole depends on the parameters. These \
parameters are initially given default values and can be reset with ",
 StyleBox["SetCoordinates", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.16.1", "1.7"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Bipolar",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bispherical",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cartesian",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ConfocalEllipsoidal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["ConfocalParaboloidal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Conical",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cylindrical",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["EllipticCylindrical",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["OblateSpheroidal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ParabolicCylindrical",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Paraboloidal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["ProlateSpheroidal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Spherical",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Toroidal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.16.1"],

Cell["Coordinate systems.", "Caption",
 CellTags->"S5.16.1"],

Cell[TextData[{
 "There are often conflicting definitions of a particular coordinate system \
in the literature. When you use a coordinate system with this package, you \
should look at the definition given below to make sure it is what you want. \
The easiest way to check the definition of a coordinate system used in the \
package is to use ",
 StyleBox["CoordinatesToCartesian[", "MR"],
 StyleBox["pt", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["coordsys", "TI"],
 StyleBox["]", "MR"],
 " as described below. This will give you the formulas for the transformation \
into Cartesian coordinates. "
}], "Text",
 CellTags->{"S5.16.1", "1.8"}],

Cell[TextData[{
 "The ",
 StyleBox["Cartesian coordinate system", "TB"],
 " ",
 StyleBox["Cartesian[", "MR"],
 StyleBox["x", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["y", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["z", "TI"],
 StyleBox["]", "MR"],
 " is the standard rectangular coordinate system in three dimensions. "
}], "Text",
 CellTags->{"S5.16.1", "1.9"}],

Cell[TextData[{
 "The ",
 StyleBox["cylindrical coordinate system", "TB"],
 " ",
 StyleBox["Cylindrical[", "MR"],
 StyleBox["r", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["theta", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["z", "TI"],
 StyleBox["]", "MR"],
 " uses polar coordinates ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " to locate a point in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " plane and the coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " for the height of the point above the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " plane. "
}], "Text",
 CellTags->{"S5.16.1", "1.10"}],

Cell[TextData[{
 "In the ",
 StyleBox["spherical coordinate system", "TB"],
 " ",
 StyleBox["Spherical[", "MR"],
 StyleBox["r", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["theta", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["phi", "TI"],
 StyleBox["]", "MR"],
 ", the coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["r",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives the distance of the point from the origin, the coordinate ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives the angle measured from the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis, and the coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives the angle measured in the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "\[Hyphen]",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " plane from the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis, counterclockwise as viewed from the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis. "
}], "Text",
 CellTags->{"S5.16.1", "1.11"}],

Cell[TextData[{
 "In the ",
 StyleBox["parabolic cylindrical coordinate system", "TB"],
 " ",
 StyleBox["ParabolicCylindrical[", "MR"],
 StyleBox["u", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["v", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["z", "TI"],
 StyleBox["]", "MR"],
 ", varying only one of the coordinates ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " while coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is held constant produces opposite facing parabolas. The coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " specifies distances along the axis of common focus. "
}], "Text",
 CellTags->{"S5.16.1", "1.12"}],

Cell[TextData[{
 "In the ",
 StyleBox["paraboloidal coordinate system", "TB"],
 " ",
 StyleBox["Paraboloidal[", "MR"],
 StyleBox["u", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["v", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["phi", "TI"],
 StyleBox["]", "MR"],
 ", varying only one of the coordinates ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " while coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is held constant produces opposite facing parabolas. The coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " specifies rotations about their common bisectors. "
}], "Text",
 CellTags->{"S5.16.1", "1.13"}],

Cell[TextData[{
 "The ",
 StyleBox["elliptic cylindrical coordinate system", "TB"],
 " ",
 StyleBox["EllipticCylindrical[", "MR"],
 StyleBox["u", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["v", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["z", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["a", "TI"],
 StyleBox["]", "MR"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", is built around two foci separated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["a",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Holding coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " constant while varying the other coordinates produces a family of confocal \
ellipses. Fixing coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " produces a family of confocal hyperbolas. The coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " specifies distance along the axis of common focus. The default value for \
parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.16.1", "1.14"}],

Cell[TextData[{
 "The ",
 StyleBox["prolate spheroidal coordinate system", "TB"],
 " ",
 StyleBox["ProlateSpheroidal[", "MR"],
 StyleBox["xi", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["eta", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["phi", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["a", "TI"],
 StyleBox["]", "MR"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", is obtained by rotating elliptic cylindrical coordinates about the axis \
connecting the two foci. The coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " specifies the rotation. The default value for parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.16.1", "1.15"}],

Cell[TextData[{
 "The ",
 StyleBox["oblate spheroidal coordinate system", "TB"],
 " ",
 StyleBox["OblateSpheroidal[", "MR"],
 StyleBox["xi", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["eta", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["phi", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["a", "TI"],
 StyleBox["]", "MR"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", is obtained by rotating elliptic cylindrical coordinates about an axis \
perpendicular to the axis connecting the two foci. The coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " specifies the rotation. The default value for parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.16.1", "1.16"}],

Cell[TextData[{
 "The ",
 StyleBox["bipolar coordinate system", "TB"],
 " ",
 StyleBox["Bipolar[", "MR"],
 StyleBox["u", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["v", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["z", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["a", "TI"],
 StyleBox["]", "MR"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", is built around two foci separated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["a",
     "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". Holding coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["u",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " constant produces a family of circles that pass through both foci. Fixing \
coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["v",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " produces a family of degenerate ellipses about one of the foci. The \
coordinate ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " specifies distance along the axis of common focus. The default value for \
parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.16.1", "1.17"}],

Cell[TextData[{
 "The ",
 StyleBox["bispherical coordinate system", "TB"],
 " ",
 StyleBox["Bispherical[", "MR"],
 StyleBox["u", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["v", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["phi", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["a", "TI"],
 StyleBox["]", "MR"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", differs from the bipolar system only in that coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " measures an azimuthal angle. "
}], "Text",
 CellTags->{"S5.16.1", "1.18"}],

Cell[TextData[{
 "The ",
 StyleBox["toroidal coordinate system", "TB"],
 " ",
 StyleBox["Toroidal[", "MR"],
 StyleBox["u", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["v", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["phi", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["a", "TI"],
 StyleBox["]", "MR"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", is obtained by rotating bipolar coordinates about an axis perpendicular \
to the axis connecting the two foci. The coordinate ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " specifies the rotation. The default value for parameter ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "Text",
 CellTags->{"S5.16.1", "1.19"}],

Cell[TextData[{
 "In the ",
 StyleBox["conical coordinate system", "TB"],
 " ",
 StyleBox["Conical[", "MR"],
 StyleBox["lambda", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["mu", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["nu", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox["]", "MR"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the surfaces described by fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are spheres centered at the origin. Fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives cones with apexes at the origin and axes along the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis, and fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives cones with apexes at the origin and axes along the ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis. The default values for parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", respectively. "
}], "Text",
 CellTags->{"S5.16.1", "1.20"}],

Cell[TextData[{
 "In the ",
 StyleBox["confocal ellipsoidal coordinate system", "TB"],
 " ",
 StyleBox["ConfocalEllipsoidal[", "MR"],
 StyleBox["lambda", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["mu", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["nu", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["c", "TI"],
 StyleBox["]", "MR"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the surfaces described by fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are ellipsoids. Fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives hyperboloids of one sheet, and fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives hyperboloids of two sheets. The default values for parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", respectively. "
}], "Text",
 CellTags->{"S5.16.1", "1.21"}],

Cell[TextData[{
 "In the ",
 StyleBox["confocal paraboloidal coordinate system", "TB"],
 " ",
 StyleBox["ConfocalParaboloidal[", "MR"],
 StyleBox["lambda", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["mu", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["nu", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["a", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["b", "TI"],
 StyleBox["]", "MR"],
 ", parameterized by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", the surfaces described by fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are elliptic paraboloids extending in the negative ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " direction. Fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives hyperbolic paraboloids, and fixing coordinate ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " gives elliptic paraboloids extending in the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " direction. The default values for parameters ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " are ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ", respectively. "
}], "Text",
 CellTags->{"S5.16.1", "1.22"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CoordinateRanges[ ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the intervals over which each of the coordinate variables of the \
default coordinate system may range",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Parameters[ ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a list of the default parameter values for the default coordinate \
system",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ParameterRanges[ ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the intervals over which each of the parameters of the default \
coordinate system may range",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CoordinateRanges[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Parameters[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ParameterRanges[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the result for the coordinate system ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["SetCoordinates[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vars", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["param", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["set the default coordinate system to be ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" with variables ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["vars", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and parameter values ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["param", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.16.1"],

Cell["The range of coordinate variables and parameters. ", "Caption",
 CellTags->"S5.16.1"],

Cell[TextData[{
 "This gives the default coordinate variables and their ranges for the ",
 StyleBox["Conical", "MR"],
 " system. "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.23"}],

Cell[CellGroupData[{

Cell["\<\
{Coordinates[Conical],
        CoordinateRanges[Conical]}\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Llambda", ",", "Mmu", ",", "Nnu"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[Infinity]"}], "<", "Llambda", "<", "\[Infinity]"}], ",",
      
     RowBox[{"1", "<", 
      SuperscriptBox["Mmu", "2"], "<", "4"}], ",", 
     RowBox[{
      SuperscriptBox["Nnu", "2"], "<", "1"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "This means that the ",
 StyleBox["Bipolar", "MR"],
 " system has one parameter that must be a positive number. The default value \
of this parameter is ",
 StyleBox["1", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.24"}],

Cell[CellGroupData[{

Cell["\<\
{Parameters[Bipolar],
  ParameterRanges[Bipolar]}\
\>", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"0", "<", "#1", "<", "\[Infinity]"}]}], "}"}]], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "This resets the ",
 StyleBox["Bipolar", "MR"],
 " variables and parameter. "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.25"}],

Cell[CellGroupData[{

Cell["SetCoordinates[Bipolar[u, v, z, 2]]", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"Bipolar", "[", 
  RowBox[{"u", ",", "v", ",", "z", ",", "2"}], "]"}]], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "In the ",
 StyleBox["Conical", "MR"],
 " system there are two parameters, and the second must always be larger than \
the first. "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.26"}],

Cell[CellGroupData[{

Cell["\<\
{Parameters[Conical],
  ParameterRanges[Conical]}\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"0", "<", "#1", "<", "#2", "<", "\[Infinity]"}]}], "}"}]], "Output",\

 CellLabel->"Out[7]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["CoordinatesToCartesian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the Cartesian coordinates of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is given in the default coordinate system",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CoordinatesToCartesian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the Cartesian coordinates of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is given in the coordinate system ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CoordinatesFromCartesian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the default system coordinates of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is given in Cartesian coordinates",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CoordinatesFromCartesian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" coordinates of ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is given in Cartesian coordinates",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.16.1"],

Cell["Converting to and from Cartesian coordinates. ", "Caption",
 CellTags->"S5.16.1"],

Cell[TextData[{
 "This gives Cartesian coordinates of the point whose ",
 StyleBox["Spherical", "MR"],
 " coordinates are ",
 StyleBox["{1,", "MR"],
 " ",
 StyleBox["Pi/2,", "MR"],
 " ",
 StyleBox["Pi/4}", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.27"}],

Cell[CellGroupData[{

Cell["\<\
CoordinatesToCartesian[{1, Pi/2, Pi/4},
  Spherical]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   FractionBox["1", 
    SqrtBox["2"]], ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell["\<\
You get the general coordinate transformation formula when you give the \
variables in symbolic form. \
\>", "MathCaption",
 CellTags->{"S5.16.1", "1.28"}],

Cell[CellGroupData[{

Cell["\<\
CoordinatesToCartesian[{u, v, phi},
  Paraboloidal]\
\>", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"u", " ", "v", " ", 
    RowBox[{"Cos", "[", "phi", "]"}]}], ",", 
   RowBox[{"u", " ", "v", " ", 
    RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["u", "2"], "-", 
      SuperscriptBox["v", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "Here are the formulas for changing from ",
 StyleBox["Cartesian", "MR"],
 " to ",
 StyleBox["Bispherical", "MR"],
 " coordinates. "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.29"}],

Cell[CellGroupData[{

Cell["\<\
CoordinatesFromCartesian[{x, y, z},
  Bispherical]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"Re", "[", 
     RowBox[{"ArcCot", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}]], "-", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}], "]"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"Im", "[", 
     RowBox[{"ArcCot", "[", 
      RowBox[{
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}]], "-", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}], "]"}]}], ",", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "The standard vector product operations, such as the dot and cross product, \
are usually defined and computed in the Cartesian coordinate system. If you \
have vectors given in a different coordinate system, you can compute vector \
products using ",
 StyleBox["DotProduct", "MR"],
 ", ",
 StyleBox["CrossProduct", "MR"],
 ", and ",
 StyleBox["ScalarTripleProduct", "MR"],
 ". These functions convert the given vectors into Cartesian coordinates and \
then compute the products using the standard definitions. "
}], "Text",
 CellTags->{"S5.16.1", "1.30"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["DotProduct[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["compute the dot product of the vectors ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" and ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" given in default coordinates",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["CrossProduct[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "compute the cross product of the vectors given in default coordinates",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ScalarTripleProduct[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "3"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "compute the scalar triple product of the vectors given in default \
coordinates",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["DotProduct[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["CrossProduct[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "1"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["v",
          "TI"], "2"], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",  etc. ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the result when the vectors are given in the coordinate system ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.16.1"],

Cell["Computing vector products in various coordinate systems. ", "Caption",
 CellTags->"S5.16.1"],

Cell[TextData[{
 "This sets the default coordinate system to ",
 StyleBox["ParabolicCylindrical", "MR"],
 " with default variables. "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.31"}],

Cell[CellGroupData[{

Cell["SetCoordinates[ParabolicCylindrical[ ]]", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"ParabolicCylindrical", "[", 
  RowBox[{"Uu", ",", "Vv", ",", "Zz"}], "]"}]], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "This converts the vectors from the default system to ",
 StyleBox["Cartesian", "MR"],
 " coordinates and then computes the scalar product. "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.32"}],

Cell[CellGroupData[{

Cell["DotProduct[{1.2, 1.1, 0}, {5.4, -2, 1.2}]", "Input",
 CellLabel->"In[12]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"-", "12.809300000000002`"}]], "Output",
 CellLabel->"Out[12]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell["\<\
Viewed geometrically, the scalar triple product gives the volume of the \
parallelepiped spanned by the three vectors. \
\>", "MathCaption",
 CellTags->{"S5.16.1", "1.33"}],

Cell[CellGroupData[{

Cell["\<\
ScalarTripleProduct[{1, 0, 0}, {0, 1, 0},
         {0, 0, 1}, Cartesian]\
\>", "Input",
 CellLabel->"In[13]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[13]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ArcLengthFactor[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["z",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the derivative of the arc length along the curve parameterized by \
",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the default coordinate system",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ArcLengthFactor[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["x",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["y",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox[
        SubscriptBox[
         StyleBox["f",
          "TI"], 
         StyleBox["z",
          "TI"]], TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}, ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["t", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the derivative in the coordinate system ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.16.1"],

Cell["Differential arc length element. ", "Caption",
 CellTags->"S5.16.1"],

Cell[TextData[{
 "In Cartesian coordinates the differential arc length element is just ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      StyleBox["d",
       "TI"], 
      SuperscriptBox[
       StyleBox["x",
        "TI"], "2"], "+", 
      StyleBox["d",
       "TI"], 
      SuperscriptBox[
       StyleBox["y",
        "TI"], "2"], "+", 
      StyleBox["d",
       "TI"], 
      SuperscriptBox[
       StyleBox["z",
        "TI"], "2"]}], ")"}], 
    RowBox[{"1", "/", "2"}]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". When you compute an integral along a parameterized curve in another \
coordinate system, you need to use the form appropriate to the coordinate \
system. To get the integral along the curve, you must plug the \
parameterization into the arc length element, compute the appropriate \
derivatives, and then integrate with respect to the parameter. The function \
",
 StyleBox["ArcLengthFactor", "MR"],
 " takes the parameterization as an argument and returns the formula for the \
derivative of the arc length along the curve. "
}], "Text",
 CellTags->{"S5.16.1", "1.34"}],

Cell["This gives the parameterization of an ascending helix. ", "MathCaption",
 CellTags->{"S5.16.1", "1.35"}],

Cell[CellGroupData[{

Cell["param = {Cos[t], Sin[t], t}", "Input",
 CellLabel->"In[14]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", "t", "]"}], ",", 
   RowBox[{"Sin", "[", "t", "]"}], ",", "t"}], "}"}]], "Output",
 CellLabel->"Out[14]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "This means that the derivative of the arc length, with respect to ",
 Cell[BoxData[
  FormBox[
   StyleBox["t",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " along the helix, is ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". If we think of the parameterization as describing the motion of a \
particle in ",
 StyleBox["Cartesian", "MR"],
 " coordinates, this just means that the speed of the particle is ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.36"}],

Cell[CellGroupData[{

Cell["\<\
ArcLengthFactor[
        param, t, Cartesian] //Simplify\
\>", "Input",
 CellLabel->"In[15]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 CellLabel->"Out[15]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell["\<\
Here is a scalar\[Hyphen]valued function on three space. \
\>", "MathCaption",
 CellTags->{"S5.16.1", "1.37"}],

Cell["f[{x_, y_, z_}] := x^2 y^2 z", "Input",
 CellLabel->"In[16]:= ",
 CellTags->"S5.16.1"],

Cell["This gives the integral of the function along the helix. ", \
"MathCaption",
 CellTags->{"S5.16.1", "1.38"}],

Cell[CellGroupData[{

Cell["\<\
Integrate[ f[param] ArcLengthFactor[
        param, t, Cartesian], {t, 0, 2 Pi}] // Simplify\
\>", "Input",
 CellLabel->"In[17]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], 
  RowBox[{"2", " ", 
   SqrtBox["2"]}]]], "Output",
 CellLabel->"Out[17]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "The derivative of a coordinate transformation is the matrix of its partial \
derivatives. In the case of three\[Hyphen]dimensional coordinate systems this \
is always a three by three matrix. This matrix is sometimes called the ",
 StyleBox["Jacobian matrix", "TI"],
 ". The determinant of this matrix is called the ",
 StyleBox["Jacobian determinant", "TI"],
 " of the transformation, or else just the ",
 StyleBox["Jacobian", "TI"],
 ". This determinant measures how infinitesimal volumes change under the \
transformation. For this reason, the Jacobian determinant is the \
multiplicative factor needed to adjust the differential volume form when you \
change coordinates. "
}], "Text",
 CellTags->{"S5.16.1", "1.39"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["JacobianMatrix[ ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the derivative matrix of the transformation from the default \
coordinate system to Cartesian coordinates using the default variables",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["JacobianMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the derivative at the point ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is given in the default system",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["JacobianMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "give the derivative of the transformation from the coordinate system ",
       
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" to Cartesian coordinates ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["JacobianMatrix[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the derivative at the point ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", where ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" is given in the coordinate system ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["JacobianDeterminant[ ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["JacobianDeterminant[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",  etc. ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give the determinant of the Jacobian matrix",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ScaleFactors[ ]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["ScaleFactors[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["pt", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[",  etc. ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "give a list of the scale factors",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.16.1"],

Cell["\<\
The transformation matrix derivative, its determinant, and scale factors. \
\>", "Caption",
 CellTags->"S5.16.1"],

Cell[TextData[{
 "This is the matrix of partial derivatives of the transformation from ",
 StyleBox["Spherical", "MR"],
 " to ",
 StyleBox["Cartesian", "MR"],
 " coordinates. "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.40"}],

Cell[CellGroupData[{

Cell["JacobianMatrix[Spherical[r, theta, phi]]", "Input",
 CellLabel->"In[18]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "phi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "phi", "]"}], " ", 
      RowBox[{"Cos", "[", "theta", "]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "r"}], " ", 
      RowBox[{"Sin", "[", "phi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "phi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}], ",", 
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "theta", "]"}], " ", 
      RowBox[{"Sin", "[", "phi", "]"}]}], ",", 
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "phi", "]"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "theta", "]"}], ",", 
     RowBox[{
      RowBox[{"-", "r"}], " ", 
      RowBox[{"Sin", "[", "theta", "]"}]}], ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[18]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell["\<\
The determinant of the derivative of the coordinate transformation gives the \
infinitesimal change in volume. \
\>", "MathCaption",
 CellTags->{"S5.16.1", "1.41"}],

Cell[CellGroupData[{

Cell["JacobianDeterminant[Spherical[r, theta, phi]]", "Input",
 CellLabel->"In[19]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"Sin", "[", "theta", "]"}]}]], "Output",
 CellLabel->"Out[19]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "This triple integral computes the integral of the function ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["r",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " over a solid sphere of radius ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " using spherical coordinates. Note that the Jacobian is included in the \
integrand, because the integral is expressed in ",
 StyleBox["Spherical", "MR"],
 " coordinates. "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.42"}],

Cell[CellGroupData[{

Cell["\<\
Integrate[r^2 JacobianDeterminant[
        Spherical[r, theta, phi]],
    {r, 0, 2}, {theta, 0, Pi},
    {phi, -Pi, Pi}]\
\>", "Input",
 CellLabel->"In[20]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 FractionBox[
  RowBox[{"128", " ", "\[Pi]"}], "5"]], "Output",
 CellLabel->"Out[20]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["Div[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the divergence of the vector field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the default coordinate system",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Curl[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the curl of the vector field ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the default coordinate system",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Grad[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the gradient of the scalar function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the default coordinate system",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Laplacian[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the Laplacian of the scalar function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the default coordinate system",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Biharmonic[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the Laplacian of the Laplacian of the scalar function ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" in the default coordinate system",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Div[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Curl[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["f", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", etc. ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["give the result if the coordinate system is ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["coordsys", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.16.1"],

Cell["Common differential operations. ", "Caption",
 CellTags->"S5.16.1"],

Cell[TextData[{
 "As is the case with the vector products discussed above, the common \
differential operations in three dimensions are defined in terms of ",
 StyleBox["Cartesian", "MR"],
 " coordinates. If you are working in another coordinate system and you wish \
to compute these quantities, you must, in principle, first transform into the \
",
 StyleBox["Cartesian", "MR"],
 " system and then do the calculation. When you specify the coordinate system \
in functions like ",
 StyleBox["Laplacian", "MR"],
 ", ",
 StyleBox["Grad", "MR"],
 ", and so on, this transformation is done automatically. "
}], "Text",
 CellTags->{"S5.16.1", "1.43"}],

Cell["Here is the usual gradient. ", "MathCaption",
 CellTags->{"S5.16.1", "1.44"}],

Cell[CellGroupData[{

Cell["Grad[5 x^2 y^3 z^4, Cartesian[x, y, z]]", "Input",
 CellLabel->"In[21]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"10", " ", "x", " ", 
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"15", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "2"], " ", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"20", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["z", "3"]}]}], "}"}]], "Output",
 CellLabel->"Out[21]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell[TextData[{
 "This gradient is different, because we are treating the function as being \
in ",
 StyleBox["ProlateSpheroidal", "MR"],
 " coordinates with the (nonstandard) variables ",
 StyleBox["x", "MR"],
 ", ",
 StyleBox["y", "MR"],
 ", and ",
 StyleBox["z", "MR"],
 ". "
}], "MathCaption",
 CellTags->{"S5.16.1", "1.45"}],

Cell[CellGroupData[{

Cell["\<\
Grad[5 x^2 y^3 z^4,
        ProlateSpheroidal[x, y, z]]\
\>", "Input",
 CellLabel->"In[22]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"10", " ", "x", " ", 
     SuperscriptBox["y", "3"], " ", 
     SuperscriptBox["z", "4"]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "y", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Sinh", "[", "x", "]"}], "2"]}]]], ",", 
   FractionBox[
    RowBox[{"15", " ", 
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["y", "2"], " ", 
     SuperscriptBox["z", "4"]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "y", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Sinh", "[", "x", "]"}], "2"]}]]], ",", 
   RowBox[{"20", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "3"], " ", 
    SuperscriptBox["z", "3"], " ", 
    RowBox[{"Csc", "[", "y", "]"}], " ", 
    RowBox[{"Csch", "[", "x", "]"}]}]}], "}"}]], "Output",
 CellLabel->"Out[22]= ",
 CellTags->"S5.16.1"]
}, Open  ]],

Cell["\<\
If you give an unknown function, the result is returned in symbolic form.\
\>", "MathCaption",
 CellTags->{"S5.16.1", "1.46"}],

Cell[CellGroupData[{

Cell["\<\
Curl[{f[r, theta, phi], g[r, theta, phi],
          h[r, theta, phi]}, Cylindrical[r, theta, phi]]\
\>", "Input",
 CellLabel->"In[23]:= ",
 CellTags->"S5.16.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "r"}], " ", 
      RowBox[{
       SuperscriptBox["g", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["h", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}], "r"], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "-", 
    RowBox[{
     SuperscriptBox["h", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}], ",", 
   RowBox[{
    FractionBox["1", "r"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"g", "[", 
       RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "theta", ",", "phi"}], "]"}], "+", 
      RowBox[{"r", " ", 
       RowBox[{
        SuperscriptBox["g", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"r", ",", "theta", ",", "phi"}], "]"}]}]}], ")"}]}]}], 
  "}"}]], "Output",
 CellLabel->"Out[23]= ",
 CellTags->"S5.16.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.16.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.16.1", "1.1"}],
    Cell[1918, 61, 525, 9, 88, "Text",
      CellTags->{"S5.16.1", "1.2"}],
    Cell[2446, 72, 768, 20, 104, "Text",
      CellTags->{"S5.16.1", "1.3"}],
    Cell[3217, 94, 3656, 107, 166, "DefinitionBox",
      CellTags->"S5.16.1"],
    Cell[6876, 203, 86, 1, 15, "Caption",
      CellTags->"S5.16.1"],
    Cell[6965, 206, 78, 1, 40, "MathCaption",
      CellTags->{"S5.16.1", "1.4"}],
    Cell[7046, 209, 89, 2, 28, "Input",
      CellTags->"S5.16.1"],
    Cell[7138, 213, 113, 2, 40, "MathCaption",
      CellTags->{"S5.16.1", "1.5"}],
    Cell[7276, 219, 103, 2, 28, "Input",
      CellTags->"S5.16.1"],
    Cell[7382, 223, 148, 4, 25, "Output",
      CellTags->"S5.16.1"],
    Cell[7545, 230, 81, 1, 40, "MathCaption",
      CellTags->{"S5.16.1", "1.6"}],
    Cell[7651, 235, 97, 2, 28, "Input",
      CellTags->"S5.16.1"],
    Cell[7751, 239, 192, 6, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[7958, 248, 1045, 20, 70, "Text",
      CellTags->{"S5.16.1", "1.7"}],
    Cell[9006, 270, 2648, 69, 70, "DefinitionBox",
      CellTags->"S5.16.1"],
    Cell[11657, 341, 60, 1, 70, "Caption",
      CellTags->"S5.16.1"],
    Cell[11720, 344, 640, 14, 70, "Text",
      CellTags->{"S5.16.1", "1.8"}],
    Cell[12363, 360, 358, 13, 70, "Text",
      CellTags->{"S5.16.1", "1.9"}],
    Cell[12724, 375, 1415, 53, 70, "Text",
      CellTags->{"S5.16.1", "1.10"}],
    Cell[14142, 430, 1670, 57, 70, "Text",
      CellTags->{"S5.16.1", "1.11"}],
    Cell[15815, 489, 1064, 37, 70, "Text",
      CellTags->{"S5.16.1", "1.12"}],
    Cell[16882, 528, 1009, 33, 70, "Text",
      CellTags->{"S5.16.1", "1.13"}],
    Cell[17894, 563, 1677, 58, 70, "Text",
      CellTags->{"S5.16.1", "1.14"}],
    Cell[19574, 623, 1077, 36, 70, "Text",
      CellTags->{"S5.16.1", "1.15"}],
    Cell[20654, 661, 1100, 36, 70, "Text",
      CellTags->{"S5.16.1", "1.16"}],
    Cell[21757, 699, 1658, 59, 70, "Text",
      CellTags->{"S5.16.1", "1.17"}],
    Cell[23418, 760, 712, 25, 70, "Text",
      CellTags->{"S5.16.1", "1.18"}],
    Cell[24133, 787, 1067, 36, 70, "Text",
      CellTags->{"S5.16.1", "1.19"}],
    Cell[25203, 825, 2176, 73, 70, "Text",
      CellTags->{"S5.16.1", "1.20"}],
    Cell[27382, 900, 2289, 79, 70, "Text",
      CellTags->{"S5.16.1", "1.21"}],
    Cell[29674, 981, 2197, 73, 70, "Text",
      CellTags->{"S5.16.1", "1.22"}],
    Cell[31874, 1056, 5125, 155, 70, "DefinitionBox",
      CellTags->"S5.16.1"],
    Cell[37002, 1213, 91, 1, 70, "Caption",
      CellTags->"S5.16.1"],
    Cell[37096, 1216, 181, 5, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.23"}],
    Cell[37302, 1225, 128, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[37433, 1232, 459, 15, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[37907, 1250, 251, 8, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.24"}],
    Cell[38183, 1262, 120, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[38306, 1269, 188, 6, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[38509, 1278, 145, 5, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.25"}],
    Cell[38679, 1287, 98, 2, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[38780, 1291, 150, 4, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[38945, 1298, 199, 6, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.26"}],
    Cell[39169, 1308, 120, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[39292, 1315, 226, 8, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[39533, 1326, 5302, 163, 70, "DefinitionBox",
      CellTags->"S5.16.1"],
    Cell[44838, 1491, 87, 1, 70, "Caption",
      CellTags->"S5.16.1"],
    Cell[44928, 1494, 269, 11, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.27"}],
    Cell[45222, 1509, 123, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[45348, 1516, 201, 8, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[45564, 1527, 165, 4, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.28"}],
    Cell[45754, 1535, 122, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[45879, 1542, 419, 14, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[46313, 1559, 200, 7, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.29"}],
    Cell[46538, 1570, 122, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[46663, 1577, 721, 24, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[47399, 1604, 573, 13, 70, "Text",
      CellTags->{"S5.16.1", "1.30"}],
    Cell[47975, 1619, 7714, 234, 70, "DefinitionBox",
      CellTags->"S5.16.1"],
    Cell[55692, 1855, 98, 1, 70, "Caption",
      CellTags->"S5.16.1"],
    Cell[55793, 1858, 184, 5, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.31"}],
    Cell[56002, 1867, 103, 2, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[56108, 1871, 157, 4, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[56280, 1878, 209, 5, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.32"}],
    Cell[56514, 1887, 105, 2, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[56622, 1891, 110, 3, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[56747, 1897, 182, 4, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.33"}],
    Cell[56954, 1905, 144, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[57101, 1912, 75, 2, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[57191, 1917, 4538, 145, 70, "DefinitionBox",
      CellTags->"S5.16.1"],
    Cell[61732, 2064, 74, 1, 70, "Caption",
      CellTags->"S5.16.1"],
    Cell[61809, 2067, 1172, 34, 70, "Text",
      CellTags->{"S5.16.1", "1.34"}],
    Cell[62984, 2103, 110, 1, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.35"}],
    Cell[63119, 2108, 91, 2, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[63213, 2112, 192, 6, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[63420, 2121, 741, 22, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.36"}],
    Cell[64186, 2147, 128, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[64317, 2154, 86, 3, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[64418, 2160, 120, 3, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.37"}],
    Cell[64541, 2165, 92, 2, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[64636, 2169, 114, 2, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.38"}],
    Cell[64775, 2175, 164, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[64942, 2182, 159, 6, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[65116, 2191, 739, 14, 70, "Text",
      CellTags->{"S5.16.1", "1.39"}],
    Cell[65858, 2207, 6024, 183, 70, "DefinitionBox",
      CellTags->"S5.16.1"],
    Cell[71885, 2392, 123, 3, 70, "Caption",
      CellTags->"S5.16.1"],
    Cell[72011, 2397, 227, 7, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.40"}],
    Cell[72263, 2408, 104, 2, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[72370, 2412, 1095, 34, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[73480, 2449, 174, 4, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.41"}],
    Cell[73679, 2457, 109, 2, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[73791, 2461, 155, 5, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[73961, 2469, 616, 17, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.42"}],
    Cell[74602, 2490, 192, 7, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[74797, 2499, 124, 4, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[74936, 2506, 6283, 195, 70, "DefinitionBox",
      CellTags->"S5.16.1"],
    Cell[81222, 2703, 73, 1, 70, "Caption",
      CellTags->"S5.16.1"],
    Cell[81298, 2706, 647, 15, 70, "Text",
      CellTags->{"S5.16.1", "1.43"}],
    Cell[81948, 2723, 83, 1, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.44"}],
    Cell[82056, 2728, 103, 2, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[82162, 2732, 473, 15, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[82650, 2750, 329, 12, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.45"}],
    Cell[83004, 2766, 127, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[83134, 2773, 943, 31, 70, "Output",
      CellTags->"S5.16.1"],
    Cell[84092, 2807, 136, 3, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.46"}],
    Cell[84253, 2814, 170, 5, 70, "Input",
      CellTags->"S5.16.1"],
    Cell[84426, 2821, 1908, 65, 70, "Output",
      CellTags->"S5.16.1"]},
  "1.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.16.1", "1.1"}]},
  "1.2"->{
    Cell[1918, 61, 525, 9, 88, "Text",
      CellTags->{"S5.16.1", "1.2"}]},
  "1.3"->{
    Cell[2446, 72, 768, 20, 104, "Text",
      CellTags->{"S5.16.1", "1.3"}]},
  "1.4"->{
    Cell[6965, 206, 78, 1, 40, "MathCaption",
      CellTags->{"S5.16.1", "1.4"}]},
  "1.5"->{
    Cell[7138, 213, 113, 2, 40, "MathCaption",
      CellTags->{"S5.16.1", "1.5"}]},
  "1.6"->{
    Cell[7545, 230, 81, 1, 40, "MathCaption",
      CellTags->{"S5.16.1", "1.6"}]},
  "1.7"->{
    Cell[7958, 248, 1045, 20, 70, "Text",
      CellTags->{"S5.16.1", "1.7"}]},
  "1.8"->{
    Cell[11720, 344, 640, 14, 70, "Text",
      CellTags->{"S5.16.1", "1.8"}]},
  "1.9"->{
    Cell[12363, 360, 358, 13, 70, "Text",
      CellTags->{"S5.16.1", "1.9"}]},
  "1.10"->{
    Cell[12724, 375, 1415, 53, 70, "Text",
      CellTags->{"S5.16.1", "1.10"}]},
  "1.11"->{
    Cell[14142, 430, 1670, 57, 70, "Text",
      CellTags->{"S5.16.1", "1.11"}]},
  "1.12"->{
    Cell[15815, 489, 1064, 37, 70, "Text",
      CellTags->{"S5.16.1", "1.12"}]},
  "1.13"->{
    Cell[16882, 528, 1009, 33, 70, "Text",
      CellTags->{"S5.16.1", "1.13"}]},
  "1.14"->{
    Cell[17894, 563, 1677, 58, 70, "Text",
      CellTags->{"S5.16.1", "1.14"}]},
  "1.15"->{
    Cell[19574, 623, 1077, 36, 70, "Text",
      CellTags->{"S5.16.1", "1.15"}]},
  "1.16"->{
    Cell[20654, 661, 1100, 36, 70, "Text",
      CellTags->{"S5.16.1", "1.16"}]},
  "1.17"->{
    Cell[21757, 699, 1658, 59, 70, "Text",
      CellTags->{"S5.16.1", "1.17"}]},
  "1.18"->{
    Cell[23418, 760, 712, 25, 70, "Text",
      CellTags->{"S5.16.1", "1.18"}]},
  "1.19"->{
    Cell[24133, 787, 1067, 36, 70, "Text",
      CellTags->{"S5.16.1", "1.19"}]},
  "1.20"->{
    Cell[25203, 825, 2176, 73, 70, "Text",
      CellTags->{"S5.16.1", "1.20"}]},
  "1.21"->{
    Cell[27382, 900, 2289, 79, 70, "Text",
      CellTags->{"S5.16.1", "1.21"}]},
  "1.22"->{
    Cell[29674, 981, 2197, 73, 70, "Text",
      CellTags->{"S5.16.1", "1.22"}]},
  "1.23"->{
    Cell[37096, 1216, 181, 5, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.23"}]},
  "1.24"->{
    Cell[37907, 1250, 251, 8, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.24"}]},
  "1.25"->{
    Cell[38509, 1278, 145, 5, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.25"}]},
  "1.26"->{
    Cell[38945, 1298, 199, 6, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.26"}]},
  "1.27"->{
    Cell[44928, 1494, 269, 11, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.27"}]},
  "1.28"->{
    Cell[45564, 1527, 165, 4, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.28"}]},
  "1.29"->{
    Cell[46313, 1559, 200, 7, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.29"}]},
  "1.30"->{
    Cell[47399, 1604, 573, 13, 70, "Text",
      CellTags->{"S5.16.1", "1.30"}]},
  "1.31"->{
    Cell[55793, 1858, 184, 5, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.31"}]},
  "1.32"->{
    Cell[56280, 1878, 209, 5, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.32"}]},
  "1.33"->{
    Cell[56747, 1897, 182, 4, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.33"}]},
  "1.34"->{
    Cell[61809, 2067, 1172, 34, 70, "Text",
      CellTags->{"S5.16.1", "1.34"}]},
  "1.35"->{
    Cell[62984, 2103, 110, 1, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.35"}]},
  "1.36"->{
    Cell[63420, 2121, 741, 22, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.36"}]},
  "1.37"->{
    Cell[64418, 2160, 120, 3, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.37"}]},
  "1.38"->{
    Cell[64636, 2169, 114, 2, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.38"}]},
  "1.39"->{
    Cell[65116, 2191, 739, 14, 70, "Text",
      CellTags->{"S5.16.1", "1.39"}]},
  "1.40"->{
    Cell[72011, 2397, 227, 7, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.40"}]},
  "1.41"->{
    Cell[73480, 2449, 174, 4, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.41"}]},
  "1.42"->{
    Cell[73961, 2469, 616, 17, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.42"}]},
  "1.43"->{
    Cell[81298, 2706, 647, 15, 70, "Text",
      CellTags->{"S5.16.1", "1.43"}]},
  "1.44"->{
    Cell[81948, 2723, 83, 1, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.44"}]},
  "1.45"->{
    Cell[82650, 2750, 329, 12, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.45"}]},
  "1.46"->{
    Cell[84092, 2807, 136, 3, 70, "MathCaption",
      CellTags->{"S5.16.1", "1.46"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.16.1", 86985, 2906},
  {"1.1", 95202, 3119},
  {"1.2", 95296, 3122},
  {"1.3", 95384, 3125},
  {"1.4", 95474, 3128},
  {"1.5", 95569, 3131},
  {"1.6", 95665, 3134},
  {"1.7", 95760, 3137},
  {"1.8", 95851, 3140},
  {"1.9", 95942, 3143},
  {"1.10", 96034, 3146},
  {"1.11", 96128, 3149},
  {"1.12", 96222, 3152},
  {"1.13", 96316, 3155},
  {"1.14", 96410, 3158},
  {"1.15", 96504, 3161},
  {"1.16", 96598, 3164},
  {"1.17", 96692, 3167},
  {"1.18", 96786, 3170},
  {"1.19", 96879, 3173},
  {"1.20", 96973, 3176},
  {"1.21", 97067, 3179},
  {"1.22", 97161, 3182},
  {"1.23", 97255, 3185},
  {"1.24", 97355, 3188},
  {"1.25", 97455, 3191},
  {"1.26", 97555, 3194},
  {"1.27", 97655, 3197},
  {"1.28", 97756, 3200},
  {"1.29", 97856, 3203},
  {"1.30", 97956, 3206},
  {"1.31", 98050, 3209},
  {"1.32", 98150, 3212},
  {"1.33", 98250, 3215},
  {"1.34", 98350, 3218},
  {"1.35", 98445, 3221},
  {"1.36", 98545, 3224},
  {"1.37", 98646, 3227},
  {"1.38", 98746, 3230},
  {"1.39", 98846, 3233},
  {"1.40", 98940, 3236},
  {"1.41", 99040, 3239},
  {"1.42", 99140, 3242},
  {"1.43", 99241, 3245},
  {"1.44", 99335, 3248},
  {"1.45", 99434, 3251},
  {"1.46", 99535, 3254}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 139, 6, 36, "Subsection",
  CellTags->{"S5.16.1", "1.1"}],
Cell[1918, 61, 525, 9, 88, "Text",
  CellTags->{"S5.16.1", "1.2"}],
Cell[2446, 72, 768, 20, 104, "Text",
  CellTags->{"S5.16.1", "1.3"}],
Cell[3217, 94, 3656, 107, 166, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[6876, 203, 86, 1, 15, "Caption",
  CellTags->"S5.16.1"],
Cell[6965, 206, 78, 1, 40, "MathCaption",
  CellTags->{"S5.16.1", "1.4"}],
Cell[7046, 209, 89, 2, 28, "Input",
  CellTags->"S5.16.1"],
Cell[7138, 213, 113, 2, 40, "MathCaption",
  CellTags->{"S5.16.1", "1.5"}],

Cell[CellGroupData[{
Cell[7276, 219, 103, 2, 28, "Input",
  CellTags->"S5.16.1"],
Cell[7382, 223, 148, 4, 25, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[7545, 230, 81, 1, 40, "MathCaption",
  CellTags->{"S5.16.1", "1.6"}],

Cell[CellGroupData[{
Cell[7651, 235, 97, 2, 28, "Input",
  CellTags->"S5.16.1"],
Cell[7751, 239, 192, 6, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[7958, 248, 1045, 20, 70, "Text",
  CellTags->{"S5.16.1", "1.7"}],
Cell[9006, 270, 2648, 69, 70, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[11657, 341, 60, 1, 70, "Caption",
  CellTags->"S5.16.1"],
Cell[11720, 344, 640, 14, 70, "Text",
  CellTags->{"S5.16.1", "1.8"}],
Cell[12363, 360, 358, 13, 70, "Text",
  CellTags->{"S5.16.1", "1.9"}],
Cell[12724, 375, 1415, 53, 70, "Text",
  CellTags->{"S5.16.1", "1.10"}],
Cell[14142, 430, 1670, 57, 70, "Text",
  CellTags->{"S5.16.1", "1.11"}],
Cell[15815, 489, 1064, 37, 70, "Text",
  CellTags->{"S5.16.1", "1.12"}],
Cell[16882, 528, 1009, 33, 70, "Text",
  CellTags->{"S5.16.1", "1.13"}],
Cell[17894, 563, 1677, 58, 70, "Text",
  CellTags->{"S5.16.1", "1.14"}],
Cell[19574, 623, 1077, 36, 70, "Text",
  CellTags->{"S5.16.1", "1.15"}],
Cell[20654, 661, 1100, 36, 70, "Text",
  CellTags->{"S5.16.1", "1.16"}],
Cell[21757, 699, 1658, 59, 70, "Text",
  CellTags->{"S5.16.1", "1.17"}],
Cell[23418, 760, 712, 25, 70, "Text",
  CellTags->{"S5.16.1", "1.18"}],
Cell[24133, 787, 1067, 36, 70, "Text",
  CellTags->{"S5.16.1", "1.19"}],
Cell[25203, 825, 2176, 73, 70, "Text",
  CellTags->{"S5.16.1", "1.20"}],
Cell[27382, 900, 2289, 79, 70, "Text",
  CellTags->{"S5.16.1", "1.21"}],
Cell[29674, 981, 2197, 73, 70, "Text",
  CellTags->{"S5.16.1", "1.22"}],
Cell[31874, 1056, 5125, 155, 70, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[37002, 1213, 91, 1, 70, "Caption",
  CellTags->"S5.16.1"],
Cell[37096, 1216, 181, 5, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.23"}],

Cell[CellGroupData[{
Cell[37302, 1225, 128, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[37433, 1232, 459, 15, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[37907, 1250, 251, 8, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.24"}],

Cell[CellGroupData[{
Cell[38183, 1262, 120, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[38306, 1269, 188, 6, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[38509, 1278, 145, 5, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.25"}],

Cell[CellGroupData[{
Cell[38679, 1287, 98, 2, 70, "Input",
  CellTags->"S5.16.1"],
Cell[38780, 1291, 150, 4, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[38945, 1298, 199, 6, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.26"}],

Cell[CellGroupData[{
Cell[39169, 1308, 120, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[39292, 1315, 226, 8, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[39533, 1326, 5302, 163, 70, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[44838, 1491, 87, 1, 70, "Caption",
  CellTags->"S5.16.1"],
Cell[44928, 1494, 269, 11, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.27"}],

Cell[CellGroupData[{
Cell[45222, 1509, 123, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[45348, 1516, 201, 8, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[45564, 1527, 165, 4, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.28"}],

Cell[CellGroupData[{
Cell[45754, 1535, 122, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[45879, 1542, 419, 14, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[46313, 1559, 200, 7, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.29"}],

Cell[CellGroupData[{
Cell[46538, 1570, 122, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[46663, 1577, 721, 24, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[47399, 1604, 573, 13, 70, "Text",
  CellTags->{"S5.16.1", "1.30"}],
Cell[47975, 1619, 7714, 234, 70, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[55692, 1855, 98, 1, 70, "Caption",
  CellTags->"S5.16.1"],
Cell[55793, 1858, 184, 5, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.31"}],

Cell[CellGroupData[{
Cell[56002, 1867, 103, 2, 70, "Input",
  CellTags->"S5.16.1"],
Cell[56108, 1871, 157, 4, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[56280, 1878, 209, 5, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.32"}],

Cell[CellGroupData[{
Cell[56514, 1887, 105, 2, 70, "Input",
  CellTags->"S5.16.1"],
Cell[56622, 1891, 110, 3, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[56747, 1897, 182, 4, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.33"}],

Cell[CellGroupData[{
Cell[56954, 1905, 144, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[57101, 1912, 75, 2, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[57191, 1917, 4538, 145, 70, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[61732, 2064, 74, 1, 70, "Caption",
  CellTags->"S5.16.1"],
Cell[61809, 2067, 1172, 34, 70, "Text",
  CellTags->{"S5.16.1", "1.34"}],
Cell[62984, 2103, 110, 1, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.35"}],

Cell[CellGroupData[{
Cell[63119, 2108, 91, 2, 70, "Input",
  CellTags->"S5.16.1"],
Cell[63213, 2112, 192, 6, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[63420, 2121, 741, 22, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.36"}],

Cell[CellGroupData[{
Cell[64186, 2147, 128, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[64317, 2154, 86, 3, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[64418, 2160, 120, 3, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.37"}],
Cell[64541, 2165, 92, 2, 70, "Input",
  CellTags->"S5.16.1"],
Cell[64636, 2169, 114, 2, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.38"}],

Cell[CellGroupData[{
Cell[64775, 2175, 164, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[64942, 2182, 159, 6, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[65116, 2191, 739, 14, 70, "Text",
  CellTags->{"S5.16.1", "1.39"}],
Cell[65858, 2207, 6024, 183, 70, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[71885, 2392, 123, 3, 70, "Caption",
  CellTags->"S5.16.1"],
Cell[72011, 2397, 227, 7, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.40"}],

Cell[CellGroupData[{
Cell[72263, 2408, 104, 2, 70, "Input",
  CellTags->"S5.16.1"],
Cell[72370, 2412, 1095, 34, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[73480, 2449, 174, 4, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.41"}],

Cell[CellGroupData[{
Cell[73679, 2457, 109, 2, 70, "Input",
  CellTags->"S5.16.1"],
Cell[73791, 2461, 155, 5, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[73961, 2469, 616, 17, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.42"}],

Cell[CellGroupData[{
Cell[74602, 2490, 192, 7, 70, "Input",
  CellTags->"S5.16.1"],
Cell[74797, 2499, 124, 4, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[74936, 2506, 6283, 195, 70, "DefinitionBox",
  CellTags->"S5.16.1"],
Cell[81222, 2703, 73, 1, 70, "Caption",
  CellTags->"S5.16.1"],
Cell[81298, 2706, 647, 15, 70, "Text",
  CellTags->{"S5.16.1", "1.43"}],
Cell[81948, 2723, 83, 1, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.44"}],

Cell[CellGroupData[{
Cell[82056, 2728, 103, 2, 70, "Input",
  CellTags->"S5.16.1"],
Cell[82162, 2732, 473, 15, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[82650, 2750, 329, 12, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.45"}],

Cell[CellGroupData[{
Cell[83004, 2766, 127, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[83134, 2773, 943, 31, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]],
Cell[84092, 2807, 136, 3, 70, "MathCaption",
  CellTags->{"S5.16.1", "1.46"}],

Cell[CellGroupData[{
Cell[84253, 2814, 170, 5, 70, "Input",
  CellTags->"S5.16.1"],
Cell[84426, 2821, 1908, 65, 70, "Output",
  CellTags->"S5.16.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

