(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5897,        193]*)
(*NotebookOutlinePosition[      8181,        268]*)
(*  CellTagsIndexPosition[      7955,        255]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "WorldData",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.63.1", "1.1"}],

Cell[TextData[{
 "The package ",
 StyleBox["Miscellaneous`WorldData`", "MR"],
 " is used by the package ",
 StyleBox["Miscellaneous`WorldPlot`", "MR"],
 " and is automatically loaded when you load ",
 StyleBox["Miscellaneous`WorldPlot`", "MR"],
 ". Most users do not need to be aware of it, but if you want to expand on \
the list of countries ",
 StyleBox["WorldPlot", "MR"],
 " knows about you will want to update ",
 StyleBox["Miscellaneous`WorldData`", "MR"],
 " as well as ",
 StyleBox["Miscellaneous`WorldNames`", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.63.1", "1.2"}],

Cell[TextData[{
 StyleBox["WorldPlot", "MR"],
 " works by creating a ",
 StyleBox["Mathematica", "TI"],
 " graphics object that represents the map. Each country on the map is given \
as a ",
 StyleBox["Polygon", "MR"],
 " primitive. To make a map from a list of countries, ",
 StyleBox["Mathematica", "TI"],
 " must know the vertices of these polygons for each country in your list. \
These data are contained in the package ",
 StyleBox["Miscellaneous`WorldData`", "MR"],
 ". As noted previously, the vertex data are given as ordered pairs of \
latitude and longitude expressed in minutes. By convention, latitudes north \
of the equator are positive while those to the south are negative, and \
longitudes east of Greenwich are positive and those to the west are negative. \
"
}], "Text",
 CellTags->{"S5.63.1", "1.3"}],

Cell[TextData[{
 "The vertex data for a country is attached to ",
 StyleBox["WorldData", "MR"],
 " of the name of that country. The data are in the form of a list of lists \
of points. This is so multiple polygons can be specified for each country. "
}], "Text",
 CellTags->{"S5.63.1", "1.4"}],

Cell[TextData[{
 "You can specify your own database of geographic coordinates by setting the \
",
 StyleBox["WorldPlot", "MR"],
 " options ",
 StyleBox["WorldDatabase", "MR"],
 " and ",
 StyleBox["WorldCountries", "MR"],
 ". The setting for ",
 StyleBox["WorldDatabase", "MR"],
 " is the name of the function that is applied to a country name to yield its \
polygonal vertices. It defaults to ",
 StyleBox["WorldData", "MR"],
 ". ",
 StyleBox["WorldCountries", "MR"],
 " is set to a list of accepted country names, and defaults to ",
 StyleBox["World", "MR"],
 " (from the ",
 StyleBox["Miscellaneous`WorldNames`", "MR"],
 " package). ",
 StyleBox["Miscellaneous`WorldData`", "MR"],
 " contains all of the ",
 StyleBox["WorldData[\"", "MR"],
 StyleBox["countryname", "TI"],
 StyleBox["\"]", "MR"],
 " rules that ",
 StyleBox["WorldPlot", "MR"],
 " has access to. "
}], "Text",
 CellTags->{"S5.63.1", "1.5"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.63.1", "1.6"}],

Cell["<<Miscellaneous`WorldData`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.63.1"],

Cell["\<\
Here is the list of the vertices of the polygon that give the map of Ireland. \
\
\>", "MathCaption",
 CellTags->{"S5.63.1", "1.7"}],

Cell[CellGroupData[{

Cell["WorldData[\"Ireland\"]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.63.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3245", ",", 
      RowBox[{"-", "376"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3131", ",", 
      RowBox[{"-", "382"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3087", ",", 
      RowBox[{"-", "586"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3131", ",", 
      RowBox[{"-", "628"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3160", ",", 
      RowBox[{"-", "524"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3246", ",", 
      RowBox[{"-", "607"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3303", ",", 
      RowBox[{"-", "435"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3266", ",", 
      RowBox[{"-", "489"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3245", ",", 
      RowBox[{"-", "376"}]}], "}"}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.63.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.63.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.63.1", "1.1"}],
    Cell[1918, 61, 575, 16, 88, "Text",
      CellTags->{"S5.63.1", "1.2"}],
    Cell[2496, 79, 821, 18, 120, "Text",
      CellTags->{"S5.63.1", "1.3"}],
    Cell[3320, 99, 293, 6, 40, "Text",
      CellTags->{"S5.63.1", "1.4"}],
    Cell[3616, 107, 907, 29, 104, "Text",
      CellTags->{"S5.63.1", "1.5"}],
    Cell[4526, 138, 78, 1, 40, "MathCaption",
      CellTags->{"S5.63.1", "1.6"}],
    Cell[4607, 141, 89, 2, 28, "Input",
      CellTags->"S5.63.1"],
    Cell[4699, 145, 142, 4, 40, "MathCaption",
      CellTags->{"S5.63.1", "1.7"}],
    Cell[4866, 153, 85, 2, 28, "Input",
      CellTags->"S5.63.1"],
    Cell[4954, 157, 915, 32, 57, "Output",
      CellTags->"S5.63.1"]},
  "1.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.63.1", "1.1"}]},
  "1.2"->{
    Cell[1918, 61, 575, 16, 88, "Text",
      CellTags->{"S5.63.1", "1.2"}]},
  "1.3"->{
    Cell[2496, 79, 821, 18, 120, "Text",
      CellTags->{"S5.63.1", "1.3"}]},
  "1.4"->{
    Cell[3320, 99, 293, 6, 40, "Text",
      CellTags->{"S5.63.1", "1.4"}]},
  "1.5"->{
    Cell[3616, 107, 907, 29, 104, "Text",
      CellTags->{"S5.63.1", "1.5"}]},
  "1.6"->{
    Cell[4526, 138, 78, 1, 40, "MathCaption",
      CellTags->{"S5.63.1", "1.6"}]},
  "1.7"->{
    Cell[4699, 145, 142, 4, 40, "MathCaption",
      CellTags->{"S5.63.1", "1.7"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.63.1", 6520, 209},
  {"1.1", 7298, 230},
  {"1.2", 7392, 233},
  {"1.3", 7481, 236},
  {"1.4", 7571, 239},
  {"1.5", 7659, 242},
  {"1.6", 7750, 245},
  {"1.7", 7845, 248}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 139, 6, 36, "Subsection",
  CellTags->{"S5.63.1", "1.1"}],
Cell[1918, 61, 575, 16, 88, "Text",
  CellTags->{"S5.63.1", "1.2"}],
Cell[2496, 79, 821, 18, 120, "Text",
  CellTags->{"S5.63.1", "1.3"}],
Cell[3320, 99, 293, 6, 40, "Text",
  CellTags->{"S5.63.1", "1.4"}],
Cell[3616, 107, 907, 29, 104, "Text",
  CellTags->{"S5.63.1", "1.5"}],
Cell[4526, 138, 78, 1, 40, "MathCaption",
  CellTags->{"S5.63.1", "1.6"}],
Cell[4607, 141, 89, 2, 28, "Input",
  CellTags->"S5.63.1"],
Cell[4699, 145, 142, 4, 40, "MathCaption",
  CellTags->{"S5.63.1", "1.7"}],

Cell[CellGroupData[{
Cell[4866, 153, 85, 2, 28, "Input",
  CellTags->"S5.63.1"],
Cell[4954, 157, 915, 32, 57, "Output",
  CellTags->"S5.63.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

