(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5687,        179]*)
(*NotebookOutlinePosition[      7740,        246]*)
(*  CellTagsIndexPosition[      7558,        235]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "WorldNames",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.64.1", "1.1"}],

Cell[TextData[{
 "The package ",
 StyleBox["Miscellaneous`WorldNames`", "MR"],
 " is used by the package ",
 StyleBox["Miscellaneous`WorldPlot`", "MR"],
 " and is automatically loaded when you load ",
 StyleBox["Miscellaneous`WorldPlot`", "MR"],
 ". Most users do not need to be aware of it, but if you want to expand on \
the list of countries ",
 StyleBox["WorldPlot", "MR"],
 " knows about, you will want to update ",
 StyleBox["Miscellaneous`WorldNames`", "MR"],
 " as well as ",
 StyleBox["Miscellaneous`WorldData`", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.64.1", "1.2"}],

Cell[TextData[{
 "The names of the countries that ",
 StyleBox["WorldPlot", "MR"],
 " recognizes are specified using the option ",
 StyleBox["WorldCountries", "MR"],
 ". The setting for this option is the name of the ",
 StyleBox["Mathematica", "TI"],
 " list that contains the allowable country names. The default value is ",
 StyleBox["World", "MR"],
 ", which is a list given in the package ",
 StyleBox["Miscellaneous`WorldNames`", "MR"],
 ". This package also defines major geographical areas of the world, such as \
continents, as ",
 StyleBox["Mathematica", "TI"],
 " lists containing the country names. "
}], "Text",
 CellTags->{"S5.64.1", "1.3"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Africa",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Asia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Europe",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["MiddleEast",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["NorthAmerica",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Oceania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["SouthAmerica",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["World",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.64.1"],

Cell[TextData[{
 StyleBox["Mathematica", "SO"],
 " lists containing country names."
}], "Caption",
 CellTags->"S5.64.1"],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.64.1", "1.4"}],

Cell["<<Miscellaneous`WorldNames`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.64.1"],

Cell[TextData[{
 "Here the symbol ",
 StyleBox["NorthAmerica", "MR"],
 " is a list of strings containing the countries of the North American \
continent. "
}], "MathCaption",
 CellTags->{"S5.64.1", "1.5"}],

Cell[CellGroupData[{

Cell["NorthAmerica // InputForm", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.64.1"],

Cell["\<\
{\"USA\", \"Canada\", \"Mexico\", \"Greenland\",   \"Bermuda\", \"Cuba\", \
\"Jamaica\", \"Haiti\", \"Belize\",   \"Dominican Republic\", \"El \
Salvador\",   \"Guatemala\", \"Honduras\", \"Nicaragua\",   \"Costa Rica\", \
\"Panama\", \"Puerto Rico\"}\
\>", "Output",
 CellLabel->"Out[2]//InputForm= ",
 CellTags->"S5.64.1"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.64.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.64.1", "1.1"}],
    Cell[1919, 61, 577, 16, 88, "Text",
      CellTags->{"S5.64.1", "1.2"}],
    Cell[2499, 79, 655, 16, 88, "Text",
      CellTags->{"S5.64.1", "1.3"}],
    Cell[3157, 97, 1547, 42, 108, "DefinitionBox",
      CellTags->"S5.64.1"],
    Cell[4707, 141, 120, 4, 15, "Caption",
      CellTags->"S5.64.1"],
    Cell[4830, 147, 78, 1, 40, "MathCaption",
      CellTags->{"S5.64.1", "1.4"}],
    Cell[4911, 150, 90, 2, 28, "Input",
      CellTags->"S5.64.1"],
    Cell[5004, 154, 205, 6, 56, "MathCaption",
      CellTags->{"S5.64.1", "1.5"}],
    Cell[5234, 164, 88, 2, 28, "Input",
      CellTags->"S5.64.1"],
    Cell[5325, 168, 334, 7, 90, "Output",
      CellTags->"S5.64.1"]},
  "1.1"->{
    Cell[1776, 53, 140, 6, 36, "Subsection",
      CellTags->{"S5.64.1", "1.1"}]},
  "1.2"->{
    Cell[1919, 61, 577, 16, 88, "Text",
      CellTags->{"S5.64.1", "1.2"}]},
  "1.3"->{
    Cell[2499, 79, 655, 16, 88, "Text",
      CellTags->{"S5.64.1", "1.3"}]},
  "1.4"->{
    Cell[4830, 147, 78, 1, 40, "MathCaption",
      CellTags->{"S5.64.1", "1.4"}]},
  "1.5"->{
    Cell[5004, 154, 205, 6, 56, "MathCaption",
      CellTags->{"S5.64.1", "1.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.64.1", 6310, 195},
  {"1.1", 7081, 216},
  {"1.2", 7175, 219},
  {"1.3", 7264, 222},
  {"1.4", 7353, 225},
  {"1.5", 7448, 228}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 140, 6, 36, "Subsection",
  CellTags->{"S5.64.1", "1.1"}],
Cell[1919, 61, 577, 16, 88, "Text",
  CellTags->{"S5.64.1", "1.2"}],
Cell[2499, 79, 655, 16, 88, "Text",
  CellTags->{"S5.64.1", "1.3"}],
Cell[3157, 97, 1547, 42, 108, "DefinitionBox",
  CellTags->"S5.64.1"],
Cell[4707, 141, 120, 4, 15, "Caption",
  CellTags->"S5.64.1"],
Cell[4830, 147, 78, 1, 40, "MathCaption",
  CellTags->{"S5.64.1", "1.4"}],
Cell[4911, 150, 90, 2, 28, "Input",
  CellTags->"S5.64.1"],
Cell[5004, 154, 205, 6, 56, "MathCaption",
  CellTags->{"S5.64.1", "1.5"}],

Cell[CellGroupData[{
Cell[5234, 164, 88, 2, 28, "Input",
  CellTags->"S5.64.1"],
Cell[5325, 168, 334, 7, 90, "Output",
  CellTags->"S5.64.1"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

