(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    417555,      22625]*)
(*NotebookOutlinePosition[    430295,      22985]*)
(*  CellTagsIndexPosition[    429283,      22944]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Miscellaneous",
 StyleBox["`", "MB"],
 "WorldPlot",
 StyleBox["`", "MB"]
}], "Subsection",
 CellTags->{"S5.65.1", "1.1"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["WorldPlot[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["countrylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["generate a map of the countries named in ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["countrylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldPlot[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["countrylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", RandomColors}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "color the countries with randomly chosen colors ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldPlot[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["countrylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", RandomGrays}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "use randomly chosen gray levels",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell["Displaying a map. ", "Caption",
 CellTags->"S5.65.1"],

Cell[TextData[{
 "To make a map of an entire continent, you can give the name of the \
continent in place of the list of country names. Thus, for example, ",
 StyleBox["WorldPlot[Oceania]", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " is equivalent to ",
 StyleBox["WorldPlot[{\"Indonesia\",\"Papua", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["New", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["Guinea\",\"Fiji\",\"Australia\",\"New", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 " ",
 StyleBox["Zealand\"}]", "MR",
  GridBoxOptions->{RowLines->False,
  RowSpacings->0.4}],
 ". The names of the countries that can be mapped are listed at the end of \
this section. Note that the names of countries are strings. This means they \
must be surrounded by quotes when you use them in a list of countries. \
However, the continent names represent lists and therefore are not strings \
but symbols. They should not be put in quotes. "
}], "Text",
 CellTags->{"S5.65.1", "1.2"}],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"S5.65.1", "1.3"}],

Cell["<<Miscellaneous`WorldPlot`", "Input",
 CellLabel->"In[1]:= ",
 CellTags->"S5.65.1"],

Cell["\<\
This gives a map of Africa with all countries drawn as white with black \
outlines. \
\>", "MathCaption",
 CellTags->{"S5.65.1", "1.4"}],

Cell[CellGroupData[{

Cell["WorldPlot[ Africa ]", "Input",
 CellLabel->"In[2]:= ",
 CellTags->"S5.65.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.000198413 0.5 0.000198413 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.001 w
[ ] 0 setdash
.2619 .02381 m
.2619 .03333 L
.2619 .04286 L
.2619 .05238 L
.2619 .0619 L
.2619 .07143 L
.2619 .08095 L
.2619 .09048 L
.2619 .1 L
.2619 .10952 L
.2619 .11905 L
.2619 .12857 L
.2619 .1381 L
.2619 .14762 L
.2619 .15714 L
.2619 .16667 L
.2619 .17619 L
.2619 .18571 L
.2619 .19524 L
.2619 .20476 L
.2619 .21429 L
.2619 .22381 L
.2619 .23333 L
.2619 .24286 L
.2619 .25238 L
.2619 .2619 L
.2619 .27143 L
.2619 .28095 L
.2619 .29048 L
.2619 .3 L
.2619 .30952 L
.2619 .31905 L
.2619 .32857 L
.2619 .3381 L
.2619 .34762 L
.2619 .35714 L
.2619 .36667 L
.2619 .37619 L
.2619 .38571 L
.2619 .39524 L
.2619 .40476 L
.2619 .41429 L
.2619 .42381 L
.2619 .43333 L
.2619 .44286 L
.2619 .45238 L
.2619 .4619 L
.2619 .47143 L
.2619 .48095 L
.2619 .49048 L
Mistroke
.2619 .5 L
.2619 .50952 L
.2619 .51905 L
.2619 .52857 L
.2619 .5381 L
.2619 .54762 L
.2619 .55714 L
.2619 .56667 L
.2619 .57619 L
.2619 .58571 L
.2619 .59524 L
.2619 .60476 L
.2619 .61429 L
.2619 .62381 L
.2619 .63333 L
.2619 .64286 L
.2619 .65238 L
.2619 .6619 L
.2619 .67143 L
.2619 .68095 L
.2619 .69048 L
.2619 .7 L
.2619 .70952 L
.2619 .71905 L
.2619 .72857 L
.2619 .7381 L
.2619 .74762 L
.2619 .75714 L
.2619 .76667 L
.2619 .77619 L
.2619 .78571 L
.2619 .79524 L
.2619 .80476 L
.2619 .81429 L
.2619 .82381 L
.2619 .83333 L
.2619 .84286 L
.2619 .85238 L
.2619 .8619 L
.2619 .87143 L
.2619 .88095 L
.2619 .89048 L
.2619 .9 L
.2619 .90952 L
.2619 .91905 L
.2619 .92857 L
.2619 .9381 L
.2619 .94762 L
.2619 .95714 L
.2619 .96667 L
Mistroke
.2619 .97619 L
.2619 .97619 L
Mfstroke
.61905 .02381 m
.61905 .03333 L
.61905 .04286 L
.61905 .05238 L
.61905 .0619 L
.61905 .07143 L
.61905 .08095 L
.61905 .09048 L
.61905 .1 L
.61905 .10952 L
.61905 .11905 L
.61905 .12857 L
.61905 .1381 L
.61905 .14762 L
.61905 .15714 L
.61905 .16667 L
.61905 .17619 L
.61905 .18571 L
.61905 .19524 L
.61905 .20476 L
.61905 .21429 L
.61905 .22381 L
.61905 .23333 L
.61905 .24286 L
.61905 .25238 L
.61905 .2619 L
.61905 .27143 L
.61905 .28095 L
.61905 .29048 L
.61905 .3 L
.61905 .30952 L
.61905 .31905 L
.61905 .32857 L
.61905 .3381 L
.61905 .34762 L
.61905 .35714 L
.61905 .36667 L
.61905 .37619 L
.61905 .38571 L
.61905 .39524 L
.61905 .40476 L
.61905 .41429 L
.61905 .42381 L
.61905 .43333 L
.61905 .44286 L
.61905 .45238 L
.61905 .4619 L
.61905 .47143 L
.61905 .48095 L
.61905 .49048 L
Mistroke
.61905 .5 L
.61905 .50952 L
.61905 .51905 L
.61905 .52857 L
.61905 .5381 L
.61905 .54762 L
.61905 .55714 L
.61905 .56667 L
.61905 .57619 L
.61905 .58571 L
.61905 .59524 L
.61905 .60476 L
.61905 .61429 L
.61905 .62381 L
.61905 .63333 L
.61905 .64286 L
.61905 .65238 L
.61905 .6619 L
.61905 .67143 L
.61905 .68095 L
.61905 .69048 L
.61905 .7 L
.61905 .70952 L
.61905 .71905 L
.61905 .72857 L
.61905 .7381 L
.61905 .74762 L
.61905 .75714 L
.61905 .76667 L
.61905 .77619 L
.61905 .78571 L
.61905 .79524 L
.61905 .80476 L
.61905 .81429 L
.61905 .82381 L
.61905 .83333 L
.61905 .84286 L
.61905 .85238 L
.61905 .8619 L
.61905 .87143 L
.61905 .88095 L
.61905 .89048 L
.61905 .9 L
.61905 .90952 L
.61905 .91905 L
.61905 .92857 L
.61905 .9381 L
.61905 .94762 L
.61905 .95714 L
.61905 .96667 L
Mistroke
.61905 .97619 L
.61905 .97619 L
Mfstroke
.97619 .02381 m
.97619 .03333 L
.97619 .04286 L
.97619 .05238 L
.97619 .0619 L
.97619 .07143 L
.97619 .08095 L
.97619 .09048 L
.97619 .1 L
.97619 .10952 L
.97619 .11905 L
.97619 .12857 L
.97619 .1381 L
.97619 .14762 L
.97619 .15714 L
.97619 .16667 L
.97619 .17619 L
.97619 .18571 L
.97619 .19524 L
.97619 .20476 L
.97619 .21429 L
.97619 .22381 L
.97619 .23333 L
.97619 .24286 L
.97619 .25238 L
.97619 .2619 L
.97619 .27143 L
.97619 .28095 L
.97619 .29048 L
.97619 .3 L
.97619 .30952 L
.97619 .31905 L
.97619 .32857 L
.97619 .3381 L
.97619 .34762 L
.97619 .35714 L
.97619 .36667 L
.97619 .37619 L
.97619 .38571 L
.97619 .39524 L
.97619 .40476 L
.97619 .41429 L
.97619 .42381 L
.97619 .43333 L
.97619 .44286 L
.97619 .45238 L
.97619 .4619 L
.97619 .47143 L
.97619 .48095 L
.97619 .49048 L
Mistroke
.97619 .5 L
.97619 .50952 L
.97619 .51905 L
.97619 .52857 L
.97619 .5381 L
.97619 .54762 L
.97619 .55714 L
.97619 .56667 L
.97619 .57619 L
.97619 .58571 L
.97619 .59524 L
.97619 .60476 L
.97619 .61429 L
.97619 .62381 L
.97619 .63333 L
.97619 .64286 L
.97619 .65238 L
.97619 .6619 L
.97619 .67143 L
.97619 .68095 L
.97619 .69048 L
.97619 .7 L
.97619 .70952 L
.97619 .71905 L
.97619 .72857 L
.97619 .7381 L
.97619 .74762 L
.97619 .75714 L
.97619 .76667 L
.97619 .77619 L
.97619 .78571 L
.97619 .79524 L
.97619 .80476 L
.97619 .81429 L
.97619 .82381 L
.97619 .83333 L
.97619 .84286 L
.97619 .85238 L
.97619 .8619 L
.97619 .87143 L
.97619 .88095 L
.97619 .89048 L
.97619 .9 L
.97619 .90952 L
.97619 .91905 L
.97619 .92857 L
.97619 .9381 L
.97619 .94762 L
.97619 .95714 L
.97619 .96667 L
Mistroke
.97619 .97619 L
.97619 .97619 L
Mfstroke
.02381 .14286 m
.03333 .14286 L
.04286 .14286 L
.05238 .14286 L
.0619 .14286 L
.07143 .14286 L
.08095 .14286 L
.09048 .14286 L
.1 .14286 L
.10952 .14286 L
.11905 .14286 L
.12857 .14286 L
.1381 .14286 L
.14762 .14286 L
.15714 .14286 L
.16667 .14286 L
.17619 .14286 L
.18571 .14286 L
.19524 .14286 L
.20476 .14286 L
.21429 .14286 L
.22381 .14286 L
.23333 .14286 L
.24286 .14286 L
.25238 .14286 L
.2619 .14286 L
.27143 .14286 L
.28095 .14286 L
.29048 .14286 L
.3 .14286 L
.30952 .14286 L
.31905 .14286 L
.32857 .14286 L
.3381 .14286 L
.34762 .14286 L
.35714 .14286 L
.36667 .14286 L
.37619 .14286 L
.38571 .14286 L
.39524 .14286 L
.40476 .14286 L
.41429 .14286 L
.42381 .14286 L
.43333 .14286 L
.44286 .14286 L
.45238 .14286 L
.4619 .14286 L
.47143 .14286 L
.48095 .14286 L
.49048 .14286 L
Mistroke
.5 .14286 L
.50952 .14286 L
.51905 .14286 L
.52857 .14286 L
.5381 .14286 L
.54762 .14286 L
.55714 .14286 L
.56667 .14286 L
.57619 .14286 L
.58571 .14286 L
.59524 .14286 L
.60476 .14286 L
.61429 .14286 L
.62381 .14286 L
.63333 .14286 L
.64286 .14286 L
.65238 .14286 L
.6619 .14286 L
.67143 .14286 L
.68095 .14286 L
.69048 .14286 L
.7 .14286 L
.70952 .14286 L
.71905 .14286 L
.72857 .14286 L
.7381 .14286 L
.74762 .14286 L
.75714 .14286 L
.76667 .14286 L
.77619 .14286 L
.78571 .14286 L
.79524 .14286 L
.80476 .14286 L
.81429 .14286 L
.82381 .14286 L
.83333 .14286 L
.84286 .14286 L
.85238 .14286 L
.8619 .14286 L
.87143 .14286 L
.88095 .14286 L
.89048 .14286 L
.9 .14286 L
.90952 .14286 L
.91905 .14286 L
.92857 .14286 L
.9381 .14286 L
.94762 .14286 L
.95714 .14286 L
.96667 .14286 L
Mistroke
.97619 .14286 L
.97619 .14286 L
Mfstroke
.02381 .5 m
.03333 .5 L
.04286 .5 L
.05238 .5 L
.0619 .5 L
.07143 .5 L
.08095 .5 L
.09048 .5 L
.1 .5 L
.10952 .5 L
.11905 .5 L
.12857 .5 L
.1381 .5 L
.14762 .5 L
.15714 .5 L
.16667 .5 L
.17619 .5 L
.18571 .5 L
.19524 .5 L
.20476 .5 L
.21429 .5 L
.22381 .5 L
.23333 .5 L
.24286 .5 L
.25238 .5 L
.2619 .5 L
.27143 .5 L
.28095 .5 L
.29048 .5 L
.3 .5 L
.30952 .5 L
.31905 .5 L
.32857 .5 L
.3381 .5 L
.34762 .5 L
.35714 .5 L
.36667 .5 L
.37619 .5 L
.38571 .5 L
.39524 .5 L
.40476 .5 L
.41429 .5 L
.42381 .5 L
.43333 .5 L
.44286 .5 L
.45238 .5 L
.4619 .5 L
.47143 .5 L
.48095 .5 L
.49048 .5 L
Mistroke
.5 .5 L
.50952 .5 L
.51905 .5 L
.52857 .5 L
.5381 .5 L
.54762 .5 L
.55714 .5 L
.56667 .5 L
.57619 .5 L
.58571 .5 L
.59524 .5 L
.60476 .5 L
.61429 .5 L
.62381 .5 L
.63333 .5 L
.64286 .5 L
.65238 .5 L
.6619 .5 L
.67143 .5 L
.68095 .5 L
.69048 .5 L
.7 .5 L
.70952 .5 L
.71905 .5 L
.72857 .5 L
.7381 .5 L
.74762 .5 L
.75714 .5 L
.76667 .5 L
.77619 .5 L
.78571 .5 L
.79524 .5 L
.80476 .5 L
.81429 .5 L
.82381 .5 L
.83333 .5 L
.84286 .5 L
.85238 .5 L
.8619 .5 L
.87143 .5 L
.88095 .5 L
.89048 .5 L
.9 .5 L
.90952 .5 L
.91905 .5 L
.92857 .5 L
.9381 .5 L
.94762 .5 L
.95714 .5 L
.96667 .5 L
Mistroke
.97619 .5 L
.97619 .5 L
Mfstroke
.02381 .85714 m
.03333 .85714 L
.04286 .85714 L
.05238 .85714 L
.0619 .85714 L
.07143 .85714 L
.08095 .85714 L
.09048 .85714 L
.1 .85714 L
.10952 .85714 L
.11905 .85714 L
.12857 .85714 L
.1381 .85714 L
.14762 .85714 L
.15714 .85714 L
.16667 .85714 L
.17619 .85714 L
.18571 .85714 L
.19524 .85714 L
.20476 .85714 L
.21429 .85714 L
.22381 .85714 L
.23333 .85714 L
.24286 .85714 L
.25238 .85714 L
.2619 .85714 L
.27143 .85714 L
.28095 .85714 L
.29048 .85714 L
.3 .85714 L
.30952 .85714 L
.31905 .85714 L
.32857 .85714 L
.3381 .85714 L
.34762 .85714 L
.35714 .85714 L
.36667 .85714 L
.37619 .85714 L
.38571 .85714 L
.39524 .85714 L
.40476 .85714 L
.41429 .85714 L
.42381 .85714 L
.43333 .85714 L
.44286 .85714 L
.45238 .85714 L
.4619 .85714 L
.47143 .85714 L
.48095 .85714 L
.49048 .85714 L
Mistroke
.5 .85714 L
.50952 .85714 L
.51905 .85714 L
.52857 .85714 L
.5381 .85714 L
.54762 .85714 L
.55714 .85714 L
.56667 .85714 L
.57619 .85714 L
.58571 .85714 L
.59524 .85714 L
.60476 .85714 L
.61429 .85714 L
.62381 .85714 L
.63333 .85714 L
.64286 .85714 L
.65238 .85714 L
.6619 .85714 L
.67143 .85714 L
.68095 .85714 L
.69048 .85714 L
.7 .85714 L
.70952 .85714 L
.71905 .85714 L
.72857 .85714 L
.7381 .85714 L
.74762 .85714 L
.75714 .85714 L
.76667 .85714 L
.77619 .85714 L
.78571 .85714 L
.79524 .85714 L
.80476 .85714 L
.81429 .85714 L
.82381 .85714 L
.83333 .85714 L
.84286 .85714 L
.85238 .85714 L
.8619 .85714 L
.87143 .85714 L
.88095 .85714 L
.89048 .85714 L
.9 .85714 L
.90952 .85714 L
.91905 .85714 L
.92857 .85714 L
.9381 .85714 L
.94762 .85714 L
.95714 .85714 L
.96667 .85714 L
Mistroke
.97619 .85714 L
.97619 .85714 L
Mfstroke
1 g
.36448 .93968 m
.2619 .92659 L
.23552 .91766 L
.24782 .88214 L
.21647 .87738 L
.21865 .86865 L
.15873 .84187 L
.15873 .82937 L
.15873 .8248 L
.20476 .79762 L
.2619 .75992 L
.3125 .72798 L
.40476 .77996 L
.37381 .81131 L
.3754 .85992 L
.35119 .90337 L
.36448 .93968 L
F
.41885 .43016 m
.40774 .42738 L
.42619 .35952 L
.40198 .29464 L
.42679 .29365 L
.54147 .29008 L
.52381 .30754 L
.52381 .34524 L
.54782 .34524 L
.54742 .37063 L
.52579 .37063 L
.52123 .41329 L
.47619 .40357 L
.46409 .41369 L
.45853 .42996 L
.41885 .43036 L
F
.28135 .57401 m
.29444 .57579 L
.30437 .63988 L
.29048 .64147 L
.27341 .63095 L
.28135 .57401 L
F
.5627 .2881 m
.5119 .28194 L
.5 .2381 L
.5 .20516 L
.50774 .18056 L
.53333 .19464 L
.56567 .19444 L
.61171 .23571 L
.5627 .2881 L
F
.22996 .6129 m
.19623 .62421 L
.21468 .66071 L
.2619 .67857 L
.26468 .67857 L
.29048 .64167 L
.27341 .63095 L
.25992 .63254 L
.22817 .63095 L
.22996 .6129 L
F
.60734 .46726 m
.6121 .44702 L
.62579 .47143 L
.60734 .46726 L
F
.37877 .52798 m
.37798 .54921 L
.36429 .55734 L
.37857 .58095 L
.40337 .58433 L
.43631 .6377 L
.42937 .65575 L
.44861 .61885 L
.42798 .61468 L
.44643 .58968 L
.43353 .57202 L
.45476 .52639 L
.42024 .52579 L
.39683 .52579 L
.37877 .52798 L
F
.44643 .58968 m
.48313 .59563 L
.53294 .63036 L
.53433 .62996 L
.54187 .60377 L
.58869 .55972 L
.52778 .54921 L
.49048 .55913 L
.48373 .54147 L
.45933 .54147 L
.45476 .52639 L
.43353 .57202 L
.44643 .58968 L
F
.54762 .73214 m
.45238 .77976 L
.44048 .77381 L
.45238 .74226 L
.44623 .70119 L
.42421 .66329 L
.42937 .65575 L
.44861 .61885 L
.42798 .61468 L
.44643 .58968 L
.48313 .59563 L
.53294 .63036 L
.52183 .65238 L
.53492 .68512 L
.54762 .6869 L
.54762 .73214 L
F
.39484 .45298 m
.40516 .44028 L
.41766 .44484 L
.45119 .45337 L
.48373 .54147 L
.45933 .54147 L
.45476 .52639 L
.42024 .52579 L
.41865 .51468 L
.43452 .51111 L
.43393 .47738 L
.3998 .47222 L
.39484 .45298 L
F
.77718 .6371 m
.76806 .6373 L
.7752 .65139 L
.75913 .6371 L
.77321 .63095 L
.77718 .6371 L
F
.68591 .7754 m
.64683 .85238 L
.66964 .83016 L
.67817 .85179 L
.67738 .85099 L
.66984 .87163 L
.66925 .87302 L
.56131 .87679 L
.55952 .7619 L
.66587 .75893 L
.68591 .7754 L
F
.37857 .5119 m
.37877 .52798 L
.39683 .52579 L
.39702 .5119 L
.37857 .5119 L
F
.69603 .67103 m
.70238 .70317 L
.72163 .71468 L
.73472 .67956 L
.7752 .65139 L
.76984 .64663 L
.72421 .67421 L
.69603 .67103 L
F
.69603 .67103 m
.72421 .67421 L
.76984 .64663 L
.75913 .6371 L
.77321 .63095 L
.78591 .60714 L
.83313 .59524 L
.79702 .55833 L
.76071 .54742 L
.73234 .54087 L
.68968 .55496 L
.65456 .59444 L
.67004 .6256 L
.69226 .65119 L
.69603 .67103 L
F
.37857 .5119 m
.36567 .49246 L
.39484 .45298 L
.3998 .47222 L
.43393 .47738 L
.43452 .51111 L
.41865 .51468 L
.42024 .52579 L
.39683 .52579 L
.39702 .5119 L
.37857 .5119 L
F
.225 .56052 m
.2619 .56687 L
.27619 .57262 L
.2619 .62619 L
.26091 .62738 L
.2619 .63214 L
.26012 .63254 L
.22817 .63095 L
.22996 .6129 L
.225 .56052 L
F
.10357 .60754 m
.08313 .63036 L
.09861 .65099 L
.12679 .64841 L
.12659 .64762 L
.15496 .64762 L
.16687 .62083 L
.16706 .62103 L
.16111 .59008 L
.13968 .60099 L
.12837 .61905 L
.10357 .60754 L
F
.0629 .64663 m
.08333 .64246 L
.07738 .63492 L
.08313 .63036 L
.09861 .65099 L
.0629 .64663 L
F
.17222 .55179 m
.225 .56052 L
.225 .56052 L
.22996 .6129 L
.22996 .6129 L
.19623 .6244 L
.19623 .62421 L
.16706 .62103 L
.16706 .62103 L
.16111 .59008 L
.16111 .59008 L
.17242 .55179 L
F
.75675 .48016 m
.72857 .44444 L
.66567 .4881 L
.67897 .52282 L
.66667 .5502 L
.68968 .55496 L
.73234 .54087 L
.76091 .54742 L
.7498 .53373 L
.75675 .48016 L
F
.125 .58254 m
.17222 .55179 L
.16111 .59008 L
.13968 .60099 L
.125 .58254 L
F
.39921 .89484 m
.45139 .87282 L
.49206 .86052 L
.52044 .89226 L
.56131 .87679 L
.55952 .7619 L
.55952 .7619 L
.55952 .7381 L
.54762 .73214 L
.45238 .77976 L
.44008 .77361 L
.40476 .77996 L
.37381 .81131 L
.3754 .85992 L
.39921 .89484 L
F
.77758 .23968 m
.79187 .2625 L
.79127 .30734 L
.83333 .32421 L
.84861 .35774 L
.8631 .31766 L
.85278 .31488 L
.82302 .20258 L
.78651 .20298 L
.77758 .23968 L
F
.65456 .3871 m
.67063 .38413 L
.67798 .3623 L
.67341 .34107 L
.68948 .32282 L
.68194 .29603 L
.67302 .32639 L
.65734 .33313 L
.65456 .3871 L
F
.3125 .72798 m
.2619 .75992 L
.20476 .79762 L
.18353 .79762 L
.19643 .68452 L
.125 .68631 L
.11845 .6754 L
.11607 .67579 L
.12679 .64841 L
.12659 .64762 L
.15496 .64762 L
.16706 .62103 L
.19623 .62421 L
.21468 .66071 L
.2619 .67857 L
.26468 .67857 L
.30813 .6871 L
.3125 .72798 L
F
.05893 .74722 m
.06905 .74067 L
.06508 .69107 L
.10258 .69087 L
.11845 .6752 L
.125 .68631 L
.19643 .68452 L
.18353 .79762 L
.20476 .79762 L
.15873 .825 L
.15873 .80952 L
.11905 .80952 L
.10595 .77262 L
.10714 .75397 L
.05893 .74722 L
F
.23571 .91786 m
.19742 .92758 L
.1877 .91687 L
.15139 .8875 L
.14008 .84901 L
.10496 .82937 L
.15873 .82937 L
.15873 .84187 L
.21865 .86865 L
.21647 .87738 L
.24782 .88214 L
.23571 .91786 L
F
.74325 .3752 m
.74603 .31806 L
.67341 .26647 L
.68452 .2131 L
.65258 .19524 L
.65357 .18036 L
.64444 .18056 L
.64246 .19107 L
.63452 .23313 L
.65516 .26151 L
.65456 .30099 L
.62401 .31389 L
.65734 .33313 L
.67302 .32639 L
.68194 .29603 L
.68948 .32282 L
.67341 .34107 L
.67798 .3623 L
.74325 .3752 L
F
.40198 .29464 m
.43492 .22996 L
.43393 .2246 L
.45813 .15972 L
.5 .16151 L
.5 .20516 L
.5 .2381 L
.5119 .28194 L
.5627 .2881 L
.54147 .29008 L
.42679 .29365 L
.40198 .29464 L
F
.44008 .77361 m
.40456 .77996 L
.3125 .72798 L
.30813 .6871 L
.26468 .67857 L
.29048 .64167 L
.30437 .63988 L
.30476 .63929 L
.32004 .66409 L
.37659 .65238 L
.42421 .66329 L
.44623 .70119 L
.45238 .74226 L
.44008 .77361 L
F
.36409 .55714 m
.33452 .55079 L
.3248 .57024 L
.29425 .57579 L
.30437 .63988 L
.30476 .63929 L
.32004 .66409 L
.37659 .65238 L
.42421 .66329 L
.42956 .65556 L
.43631 .6377 L
.40337 .58433 L
.37857 .58095 L
.36409 .55714 L
F
.45813 .15972 m
.47996 .09325 L
.5 .08552 L
.59405 .10675 L
.65357 .18036 L
.64444 .18056 L
.62877 .18095 L
.64246 .19087 L
.63452 .23313 L
.61151 .23591 L
.56567 .19444 L
.53333 .19464 L
.50774 .18056 L
.5 .20516 L
.5 .16151 L
.45813 .15972 L
F
.60357 .15933 m
.58353 .14722 L
.59643 .13492 L
.6125 .1506 L
.60357 .15933 L
F
.61429 .48353 m
.60734 .46726 L
.62579 .47143 L
.6248 .4873 L
.61429 .48353 L
F
.06508 .69127 m
.05317 .6756 L
.06468 .66171 L
.09762 .65933 L
.0625 .65556 L
.07877 .65278 L
.0629 .64663 L
.09861 .65099 L
.12679 .64841 L
.11607 .67579 L
.11845 .6752 L
.10258 .69087 L
.06508 .69107 L
F
.10357 .60754 m
.1252 .58254 L
.13988 .60099 L
.12837 .61905 L
.10357 .60754 L
F
.75655 .48016 m
.83274 .55317 L
.87401 .6244 L
.86647 .64286 L
.79663 .62401 L
.77718 .6371 L
.77679 .63671 L
.77321 .63095 L
.78591 .60714 L
.83313 .59524 L
.79702 .55833 L
.76071 .54742 L
.7498 .53373 L
.75655 .48016 L
F
.72163 .71468 m
.70119 .7623 L
.68591 .7754 L
.66587 .75893 L
.55952 .7619 L
.55952 .7381 L
.54762 .73214 L
.54762 .6869 L
.53492 .68512 L
.52183 .65238 L
.53294 .63036 L
.53433 .62996 L
.54187 .60377 L
.58869 .55972 L
.62937 .54147 L
.66667 .5502 L
.68968 .55496 L
.65456 .59444 L
.67004 .6256 L
.69226 .65119 L
.70238 .70317 L
.72163 .71468 L
F
.64444 .18056 m
.64246 .19107 L
.62877 .18095 L
.64444 .18056 L
F
.74325 .3752 m
.72361 .42798 L
.72857 .44444 L
.66567 .4881 L
.6248 .4873 L
.62579 .47143 L
.6121 .44702 L
.62817 .40258 L
.65456 .3879 L
.67063 .38413 L
.67817 .3623 L
.74325 .3752 L
F
.06468 .66171 m
.07976 .66012 L
.0625 .65516 L
.0625 .65556 L
.09762 .65933 L
.06468 .66171 L
F
.27619 .57262 m
.28155 .57401 L
.27282 .63095 L
.25992 .63254 L
.2619 .63214 L
.26091 .62738 L
.2619 .62619 L
.27619 .57262 L
F
.36448 .93968 m
.39345 .94147 L
.38095 .90675 L
.39921 .89484 L
.3754 .85992 L
.35119 .90337 L
.36448 .93968 L
F
.62937 .54147 m
.63452 .5252 L
.61429 .48353 L
.6248 .4873 L
.66567 .4881 L
.67897 .52282 L
.66667 .5502 L
.62937 .54147 L
F
.10496 .82937 m
.05893 .74722 L
.10714 .75397 L
.10595 .77262 L
.11905 .80952 L
.15873 .80952 L
.15873 .825 L
.15873 .82937 L
.10496 .82937 L
F
.41885 .43016 m
.40714 .43115 L
.41786 .44484 L
.45119 .45337 L
.48373 .54147 L
.49048 .55913 L
.52778 .54921 L
.58869 .55972 L
.62937 .54147 L
.63452 .5252 L
.61429 .48353 L
.60754 .46746 L
.6121 .44702 L
.62817 .40258 L
.5996 .38968 L
.5996 .3625 L
.61667 .35536 L
.61667 .33988 L
.58571 .3623 L
.54742 .37063 L
.52579 .37063 L
.52123 .41329 L
.47619 .40357 L
.46409 .41369 L
.45853 .42996 L
.41885 .43016 L
F
.62817 .40258 m
.5996 .38968 L
.5996 .3625 L
.61667 .35536 L
.61667 .33988 L
.58571 .3623 L
.54742 .37063 L
.54782 .34524 L
.52381 .34524 L
.52381 .30754 L
.54147 .29008 L
.5627 .2881 L
.58512 .2881 L
.62401 .31389 L
.65734 .33313 L
.65456 .3871 L
.65456 .3879 L
.62817 .40238 L
F
.63452 .23313 m
.61151 .23591 L
.5627 .2881 L
.58512 .2881 L
.62401 .31389 L
.65456 .30099 L
.65516 .26151 L
.63452 .23313 L
F
0 g
.36448 .93968 m
.2619 .92659 L
.23552 .91766 L
.24782 .88214 L
.21647 .87738 L
.21865 .86865 L
.15873 .84187 L
.15873 .82937 L
.15873 .8248 L
.20476 .79762 L
.2619 .75992 L
.3125 .72798 L
.40476 .77996 L
.37381 .81131 L
.3754 .85992 L
.35119 .90337 L
.36448 .93968 L
s
.41885 .43016 m
.40774 .42738 L
.42619 .35952 L
.40198 .29464 L
.42679 .29365 L
.54147 .29008 L
.52381 .30754 L
.52381 .34524 L
.54782 .34524 L
.54742 .37063 L
.52579 .37063 L
.52123 .41329 L
.47619 .40357 L
.46409 .41369 L
.45853 .42996 L
.41885 .43036 L
s
.28135 .57401 m
.29444 .57579 L
.30437 .63988 L
.29048 .64147 L
.27341 .63095 L
.28135 .57401 L
s
.5627 .2881 m
.5119 .28194 L
.5 .2381 L
.5 .20516 L
.50774 .18056 L
.53333 .19464 L
.56567 .19444 L
.61171 .23571 L
.5627 .2881 L
s
.22996 .6129 m
.19623 .62421 L
.21468 .66071 L
.2619 .67857 L
.26468 .67857 L
.29048 .64167 L
.27341 .63095 L
.25992 .63254 L
.22817 .63095 L
.22996 .6129 L
s
.60734 .46726 m
.6121 .44702 L
.62579 .47143 L
.60734 .46726 L
s
.37877 .52798 m
.37798 .54921 L
.36429 .55734 L
.37857 .58095 L
.40337 .58433 L
.43631 .6377 L
.42937 .65575 L
.44861 .61885 L
.42798 .61468 L
.44643 .58968 L
.43353 .57202 L
.45476 .52639 L
.42024 .52579 L
.39683 .52579 L
.37877 .52798 L
s
.44643 .58968 m
.48313 .59563 L
.53294 .63036 L
.53433 .62996 L
.54187 .60377 L
.58869 .55972 L
.52778 .54921 L
.49048 .55913 L
.48373 .54147 L
.45933 .54147 L
.45476 .52639 L
.43353 .57202 L
.44643 .58968 L
s
.54762 .73214 m
.45238 .77976 L
.44048 .77381 L
.45238 .74226 L
.44623 .70119 L
.42421 .66329 L
.42937 .65575 L
.44861 .61885 L
.42798 .61468 L
.44643 .58968 L
.48313 .59563 L
.53294 .63036 L
.52183 .65238 L
.53492 .68512 L
.54762 .6869 L
.54762 .73214 L
s
.39484 .45298 m
.40516 .44028 L
.41766 .44484 L
.45119 .45337 L
.48373 .54147 L
.45933 .54147 L
.45476 .52639 L
.42024 .52579 L
.41865 .51468 L
.43452 .51111 L
.43393 .47738 L
.3998 .47222 L
.39484 .45298 L
s
.77718 .6371 m
.76806 .6373 L
.7752 .65139 L
.75913 .6371 L
.77321 .63095 L
.77718 .6371 L
s
.68591 .7754 m
.64683 .85238 L
.66964 .83016 L
.67817 .85179 L
.67738 .85099 L
.66984 .87163 L
.66925 .87302 L
.56131 .87679 L
.55952 .7619 L
.66587 .75893 L
.68591 .7754 L
s
.37857 .5119 m
.37877 .52798 L
.39683 .52579 L
.39702 .5119 L
.37857 .5119 L
s
.69603 .67103 m
.70238 .70317 L
.72163 .71468 L
.73472 .67956 L
.7752 .65139 L
.76984 .64663 L
.72421 .67421 L
.69603 .67103 L
s
.69603 .67103 m
.72421 .67421 L
.76984 .64663 L
.75913 .6371 L
.77321 .63095 L
.78591 .60714 L
.83313 .59524 L
.79702 .55833 L
.76071 .54742 L
.73234 .54087 L
.68968 .55496 L
.65456 .59444 L
.67004 .6256 L
.69226 .65119 L
.69603 .67103 L
s
.37857 .5119 m
.36567 .49246 L
.39484 .45298 L
.3998 .47222 L
.43393 .47738 L
.43452 .51111 L
.41865 .51468 L
.42024 .52579 L
.39683 .52579 L
.39702 .5119 L
.37857 .5119 L
s
.225 .56052 m
.2619 .56687 L
.27619 .57262 L
.2619 .62619 L
.26091 .62738 L
.2619 .63214 L
.26012 .63254 L
.22817 .63095 L
.22996 .6129 L
.225 .56052 L
s
.10357 .60754 m
.08313 .63036 L
.09861 .65099 L
.12679 .64841 L
.12659 .64762 L
.15496 .64762 L
.16687 .62083 L
.16706 .62103 L
.16111 .59008 L
.13968 .60099 L
.12837 .61905 L
.10357 .60754 L
s
.0629 .64663 m
.08333 .64246 L
.07738 .63492 L
.08313 .63036 L
.09861 .65099 L
.0629 .64663 L
s
.17222 .55179 m
.225 .56052 L
.225 .56052 L
.22996 .6129 L
.22996 .6129 L
.19623 .6244 L
.19623 .62421 L
.16706 .62103 L
.16706 .62103 L
.16111 .59008 L
.16111 .59008 L
.17242 .55179 L
s
.75675 .48016 m
.72857 .44444 L
.66567 .4881 L
.67897 .52282 L
.66667 .5502 L
.68968 .55496 L
.73234 .54087 L
.76091 .54742 L
.7498 .53373 L
.75675 .48016 L
s
.125 .58254 m
.17222 .55179 L
.16111 .59008 L
.13968 .60099 L
.125 .58254 L
s
.39921 .89484 m
.45139 .87282 L
.49206 .86052 L
.52044 .89226 L
.56131 .87679 L
.55952 .7619 L
.55952 .7619 L
.55952 .7381 L
.54762 .73214 L
.45238 .77976 L
.44008 .77361 L
.40476 .77996 L
.37381 .81131 L
.3754 .85992 L
.39921 .89484 L
s
.77758 .23968 m
.79187 .2625 L
.79127 .30734 L
.83333 .32421 L
.84861 .35774 L
.8631 .31766 L
.85278 .31488 L
.82302 .20258 L
.78651 .20298 L
.77758 .23968 L
s
.65456 .3871 m
.67063 .38413 L
.67798 .3623 L
.67341 .34107 L
.68948 .32282 L
.68194 .29603 L
.67302 .32639 L
.65734 .33313 L
.65456 .3871 L
s
.3125 .72798 m
.2619 .75992 L
.20476 .79762 L
.18353 .79762 L
.19643 .68452 L
.125 .68631 L
.11845 .6754 L
.11607 .67579 L
.12679 .64841 L
.12659 .64762 L
.15496 .64762 L
.16706 .62103 L
.19623 .62421 L
.21468 .66071 L
.2619 .67857 L
.26468 .67857 L
.30813 .6871 L
.3125 .72798 L
s
.05893 .74722 m
.06905 .74067 L
.06508 .69107 L
.10258 .69087 L
.11845 .6752 L
.125 .68631 L
.19643 .68452 L
.18353 .79762 L
.20476 .79762 L
.15873 .825 L
.15873 .80952 L
.11905 .80952 L
.10595 .77262 L
.10714 .75397 L
.05893 .74722 L
s
.23571 .91786 m
.19742 .92758 L
.1877 .91687 L
.15139 .8875 L
.14008 .84901 L
.10496 .82937 L
.15873 .82937 L
.15873 .84187 L
.21865 .86865 L
.21647 .87738 L
.24782 .88214 L
.23571 .91786 L
s
.74325 .3752 m
.74603 .31806 L
.67341 .26647 L
.68452 .2131 L
.65258 .19524 L
.65357 .18036 L
.64444 .18056 L
.64246 .19107 L
.63452 .23313 L
.65516 .26151 L
.65456 .30099 L
.62401 .31389 L
.65734 .33313 L
.67302 .32639 L
.68194 .29603 L
.68948 .32282 L
.67341 .34107 L
.67798 .3623 L
.74325 .3752 L
s
.40198 .29464 m
.43492 .22996 L
.43393 .2246 L
.45813 .15972 L
.5 .16151 L
.5 .20516 L
.5 .2381 L
.5119 .28194 L
.5627 .2881 L
.54147 .29008 L
.42679 .29365 L
.40198 .29464 L
s
.44008 .77361 m
.40456 .77996 L
.3125 .72798 L
.30813 .6871 L
.26468 .67857 L
.29048 .64167 L
.30437 .63988 L
.30476 .63929 L
.32004 .66409 L
.37659 .65238 L
.42421 .66329 L
.44623 .70119 L
.45238 .74226 L
.44008 .77361 L
s
.36409 .55714 m
.33452 .55079 L
.3248 .57024 L
.29425 .57579 L
.30437 .63988 L
.30476 .63929 L
.32004 .66409 L
.37659 .65238 L
.42421 .66329 L
.42956 .65556 L
.43631 .6377 L
.40337 .58433 L
.37857 .58095 L
.36409 .55714 L
s
.45813 .15972 m
.47996 .09325 L
.5 .08552 L
.59405 .10675 L
.65357 .18036 L
.64444 .18056 L
.62877 .18095 L
.64246 .19087 L
.63452 .23313 L
.61151 .23591 L
.56567 .19444 L
.53333 .19464 L
.50774 .18056 L
.5 .20516 L
.5 .16151 L
.45813 .15972 L
s
.60357 .15933 m
.58353 .14722 L
.59643 .13492 L
.6125 .1506 L
.60357 .15933 L
s
.61429 .48353 m
.60734 .46726 L
.62579 .47143 L
.6248 .4873 L
.61429 .48353 L
s
.06508 .69127 m
.05317 .6756 L
.06468 .66171 L
.09762 .65933 L
.0625 .65556 L
.07877 .65278 L
.0629 .64663 L
.09861 .65099 L
.12679 .64841 L
.11607 .67579 L
.11845 .6752 L
.10258 .69087 L
.06508 .69107 L
s
.10357 .60754 m
.1252 .58254 L
.13988 .60099 L
.12837 .61905 L
.10357 .60754 L
s
.75655 .48016 m
.83274 .55317 L
.87401 .6244 L
.86647 .64286 L
.79663 .62401 L
.77718 .6371 L
.77679 .63671 L
.77321 .63095 L
.78591 .60714 L
.83313 .59524 L
.79702 .55833 L
.76071 .54742 L
.7498 .53373 L
.75655 .48016 L
s
.72163 .71468 m
.70119 .7623 L
.68591 .7754 L
.66587 .75893 L
.55952 .7619 L
.55952 .7381 L
.54762 .73214 L
.54762 .6869 L
.53492 .68512 L
.52183 .65238 L
.53294 .63036 L
.53433 .62996 L
.54187 .60377 L
.58869 .55972 L
.62937 .54147 L
.66667 .5502 L
.68968 .55496 L
.65456 .59444 L
.67004 .6256 L
.69226 .65119 L
.70238 .70317 L
.72163 .71468 L
s
.64444 .18056 m
.64246 .19107 L
.62877 .18095 L
.64444 .18056 L
s
.74325 .3752 m
.72361 .42798 L
.72857 .44444 L
.66567 .4881 L
.6248 .4873 L
.62579 .47143 L
.6121 .44702 L
.62817 .40258 L
.65456 .3879 L
.67063 .38413 L
.67817 .3623 L
.74325 .3752 L
s
.06468 .66171 m
.07976 .66012 L
.0625 .65516 L
.0625 .65556 L
.09762 .65933 L
.06468 .66171 L
s
.27619 .57262 m
.28155 .57401 L
.27282 .63095 L
.25992 .63254 L
.2619 .63214 L
.26091 .62738 L
.2619 .62619 L
.27619 .57262 L
s
.36448 .93968 m
.39345 .94147 L
.38095 .90675 L
.39921 .89484 L
.3754 .85992 L
.35119 .90337 L
.36448 .93968 L
s
.62937 .54147 m
.63452 .5252 L
.61429 .48353 L
.6248 .4873 L
.66567 .4881 L
.67897 .52282 L
.66667 .5502 L
.62937 .54147 L
s
.10496 .82937 m
.05893 .74722 L
.10714 .75397 L
.10595 .77262 L
.11905 .80952 L
.15873 .80952 L
.15873 .825 L
.15873 .82937 L
.10496 .82937 L
s
.41885 .43016 m
.40714 .43115 L
.41786 .44484 L
.45119 .45337 L
.48373 .54147 L
.49048 .55913 L
.52778 .54921 L
.58869 .55972 L
.62937 .54147 L
.63452 .5252 L
.61429 .48353 L
.60754 .46746 L
.6121 .44702 L
.62817 .40258 L
.5996 .38968 L
.5996 .3625 L
.61667 .35536 L
.61667 .33988 L
.58571 .3623 L
.54742 .37063 L
.52579 .37063 L
.52123 .41329 L
.47619 .40357 L
.46409 .41369 L
.45853 .42996 L
.41885 .43016 L
s
.62817 .40258 m
.5996 .38968 L
.5996 .3625 L
.61667 .35536 L
.61667 .33988 L
.58571 .3623 L
.54742 .37063 L
.54782 .34524 L
.52381 .34524 L
.52381 .30754 L
.54147 .29008 L
.5627 .2881 L
.58512 .2881 L
.62401 .31389 L
.65734 .33313 L
.65456 .3871 L
.65456 .3879 L
.62817 .40238 L
s
.63452 .23313 m
.61151 .23591 L
.5627 .2881 L
.58512 .2881 L
.62401 .31389 L
.65456 .30099 L
.65516 .26151 L
.63452 .23313 L
s
.97619 .97619 m
.97619 .97619 L
.97619 .96667 L
.97619 .95714 L
.97619 .94762 L
.97619 .9381 L
.97619 .92857 L
.97619 .91905 L
.97619 .90952 L
.97619 .9 L
.97619 .89048 L
.97619 .88095 L
.97619 .87143 L
.97619 .8619 L
.97619 .85238 L
.97619 .84286 L
.97619 .83333 L
.97619 .82381 L
.97619 .81429 L
.97619 .80476 L
.97619 .79524 L
.97619 .78571 L
.97619 .77619 L
.97619 .76667 L
.97619 .75714 L
.97619 .74762 L
.97619 .7381 L
.97619 .72857 L
.97619 .71905 L
.97619 .70952 L
.97619 .7 L
.97619 .69048 L
.97619 .68095 L
.97619 .67143 L
.97619 .6619 L
.97619 .65238 L
.97619 .64286 L
.97619 .63333 L
.97619 .62381 L
.97619 .61429 L
.97619 .60476 L
.97619 .59524 L
.97619 .58571 L
.97619 .57619 L
.97619 .56667 L
.97619 .55714 L
.97619 .54762 L
.97619 .5381 L
.97619 .52857 L
.97619 .51905 L
Mistroke
.97619 .50952 L
.97619 .5 L
.97619 .49048 L
.97619 .48095 L
.97619 .47143 L
.97619 .4619 L
.97619 .45238 L
.97619 .44286 L
.97619 .43333 L
.97619 .42381 L
.97619 .41429 L
.97619 .40476 L
.97619 .39524 L
.97619 .38571 L
.97619 .37619 L
.97619 .36667 L
.97619 .35714 L
.97619 .34762 L
.97619 .3381 L
.97619 .32857 L
.97619 .31905 L
.97619 .30952 L
.97619 .3 L
.97619 .29048 L
.97619 .28095 L
.97619 .27143 L
.97619 .2619 L
.97619 .25238 L
.97619 .24286 L
.97619 .23333 L
.97619 .22381 L
.97619 .21429 L
.97619 .20476 L
.97619 .19524 L
.97619 .18571 L
.97619 .17619 L
.97619 .16667 L
.97619 .15714 L
.97619 .14762 L
.97619 .1381 L
.97619 .12857 L
.97619 .11905 L
.97619 .10952 L
.97619 .1 L
.97619 .09048 L
.97619 .08095 L
.97619 .07143 L
.97619 .0619 L
.97619 .05238 L
.97619 .04286 L
Mistroke
.97619 .03333 L
.97619 .02381 L
Mfstroke
.97619 .02381 m
.97619 .02381 L
.96667 .02381 L
.95714 .02381 L
.94762 .02381 L
.9381 .02381 L
.92857 .02381 L
.91905 .02381 L
.90952 .02381 L
.9 .02381 L
.89048 .02381 L
.88095 .02381 L
.87143 .02381 L
.8619 .02381 L
.85238 .02381 L
.84286 .02381 L
.83333 .02381 L
.82381 .02381 L
.81429 .02381 L
.80476 .02381 L
.79524 .02381 L
.78571 .02381 L
.77619 .02381 L
.76667 .02381 L
.75714 .02381 L
.74762 .02381 L
.7381 .02381 L
.72857 .02381 L
.71905 .02381 L
.70952 .02381 L
.7 .02381 L
.69048 .02381 L
.68095 .02381 L
.67143 .02381 L
.6619 .02381 L
.65238 .02381 L
.64286 .02381 L
.63333 .02381 L
.62381 .02381 L
.61429 .02381 L
.60476 .02381 L
.59524 .02381 L
.58571 .02381 L
.57619 .02381 L
.56667 .02381 L
.55714 .02381 L
.54762 .02381 L
.5381 .02381 L
.52857 .02381 L
.51905 .02381 L
Mistroke
.50952 .02381 L
.5 .02381 L
.49048 .02381 L
.48095 .02381 L
.47143 .02381 L
.4619 .02381 L
.45238 .02381 L
.44286 .02381 L
.43333 .02381 L
.42381 .02381 L
.41429 .02381 L
.40476 .02381 L
.39524 .02381 L
.38571 .02381 L
.37619 .02381 L
.36667 .02381 L
.35714 .02381 L
.34762 .02381 L
.3381 .02381 L
.32857 .02381 L
.31905 .02381 L
.30952 .02381 L
.3 .02381 L
.29048 .02381 L
.28095 .02381 L
.27143 .02381 L
.2619 .02381 L
.25238 .02381 L
.24286 .02381 L
.23333 .02381 L
.22381 .02381 L
.21429 .02381 L
.20476 .02381 L
.19524 .02381 L
.18571 .02381 L
.17619 .02381 L
.16667 .02381 L
.15714 .02381 L
.14762 .02381 L
.1381 .02381 L
.12857 .02381 L
.11905 .02381 L
.10952 .02381 L
.1 .02381 L
.09048 .02381 L
.08095 .02381 L
.07143 .02381 L
.0619 .02381 L
.05238 .02381 L
.04286 .02381 L
Mistroke
.03333 .02381 L
.02381 .02381 L
Mfstroke
.02381 .02381 m
.02381 .03333 L
.02381 .04286 L
.02381 .05238 L
.02381 .0619 L
.02381 .07143 L
.02381 .08095 L
.02381 .09048 L
.02381 .1 L
.02381 .10952 L
.02381 .11905 L
.02381 .12857 L
.02381 .1381 L
.02381 .14762 L
.02381 .15714 L
.02381 .16667 L
.02381 .17619 L
.02381 .18571 L
.02381 .19524 L
.02381 .20476 L
.02381 .21429 L
.02381 .22381 L
.02381 .23333 L
.02381 .24286 L
.02381 .25238 L
.02381 .2619 L
.02381 .27143 L
.02381 .28095 L
.02381 .29048 L
.02381 .3 L
.02381 .30952 L
.02381 .31905 L
.02381 .32857 L
.02381 .3381 L
.02381 .34762 L
.02381 .35714 L
.02381 .36667 L
.02381 .37619 L
.02381 .38571 L
.02381 .39524 L
.02381 .40476 L
.02381 .41429 L
.02381 .42381 L
.02381 .43333 L
.02381 .44286 L
.02381 .45238 L
.02381 .4619 L
.02381 .47143 L
.02381 .48095 L
.02381 .49048 L
Mistroke
.02381 .5 L
.02381 .50952 L
.02381 .51905 L
.02381 .52857 L
.02381 .5381 L
.02381 .54762 L
.02381 .55714 L
.02381 .56667 L
.02381 .57619 L
.02381 .58571 L
.02381 .59524 L
.02381 .60476 L
.02381 .61429 L
.02381 .62381 L
.02381 .63333 L
.02381 .64286 L
.02381 .65238 L
.02381 .6619 L
.02381 .67143 L
.02381 .68095 L
.02381 .69048 L
.02381 .7 L
.02381 .70952 L
.02381 .71905 L
.02381 .72857 L
.02381 .7381 L
.02381 .74762 L
.02381 .75714 L
.02381 .76667 L
.02381 .77619 L
.02381 .78571 L
.02381 .79524 L
.02381 .80476 L
.02381 .81429 L
.02381 .82381 L
.02381 .83333 L
.02381 .84286 L
.02381 .85238 L
.02381 .8619 L
.02381 .87143 L
.02381 .88095 L
.02381 .89048 L
.02381 .9 L
.02381 .90952 L
.02381 .91905 L
.02381 .92857 L
.02381 .9381 L
.02381 .94762 L
.02381 .95714 L
.02381 .96667 L
Mistroke
.02381 .97619 L
.02381 .97619 L
Mfstroke
.02381 .97619 m
.03333 .97619 L
.04286 .97619 L
.05238 .97619 L
.0619 .97619 L
.07143 .97619 L
.08095 .97619 L
.09048 .97619 L
.1 .97619 L
.10952 .97619 L
.11905 .97619 L
.12857 .97619 L
.1381 .97619 L
.14762 .97619 L
.15714 .97619 L
.16667 .97619 L
.17619 .97619 L
.18571 .97619 L
.19524 .97619 L
.20476 .97619 L
.21429 .97619 L
.22381 .97619 L
.23333 .97619 L
.24286 .97619 L
.25238 .97619 L
.2619 .97619 L
.27143 .97619 L
.28095 .97619 L
.29048 .97619 L
.3 .97619 L
.30952 .97619 L
.31905 .97619 L
.32857 .97619 L
.3381 .97619 L
.34762 .97619 L
.35714 .97619 L
.36667 .97619 L
.37619 .97619 L
.38571 .97619 L
.39524 .97619 L
.40476 .97619 L
.41429 .97619 L
.42381 .97619 L
.43333 .97619 L
.44286 .97619 L
.45238 .97619 L
.4619 .97619 L
.47143 .97619 L
.48095 .97619 L
.49048 .97619 L
Mistroke
.5 .97619 L
.50952 .97619 L
.51905 .97619 L
.52857 .97619 L
.5381 .97619 L
.54762 .97619 L
.55714 .97619 L
.56667 .97619 L
.57619 .97619 L
.58571 .97619 L
.59524 .97619 L
.60476 .97619 L
.61429 .97619 L
.62381 .97619 L
.63333 .97619 L
.64286 .97619 L
.65238 .97619 L
.6619 .97619 L
.67143 .97619 L
.68095 .97619 L
.69048 .97619 L
.7 .97619 L
.70952 .97619 L
.71905 .97619 L
.72857 .97619 L
.7381 .97619 L
.74762 .97619 L
.75714 .97619 L
.76667 .97619 L
.77619 .97619 L
.78571 .97619 L
.79524 .97619 L
.80476 .97619 L
.81429 .97619 L
.82381 .97619 L
.83333 .97619 L
.84286 .97619 L
.85238 .97619 L
.8619 .97619 L
.87143 .97619 L
.88095 .97619 L
.89048 .97619 L
.9 .97619 L
.90952 .97619 L
.91905 .97619 L
.92857 .97619 L
.9381 .97619 L
.94762 .97619 L
.95714 .97619 L
.96667 .97619 L
Mistroke
.97619 .97619 L
.97619 .97619 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400?l00000o`00003oooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`00@?oooon[
o`00047ooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0?Oooool00ol0
003oooooooooo`0mooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oo
oooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oo
oooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0?Oooool00ol0003ooooo
ooooo`0mooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o
0000ooooooooool0?Oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oooooo0010
ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0m
ooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000oooo
ooooool0?Oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oooooo0010ooooo`03
o`000?oooooooooo02Oooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0mooooo`03
o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0
?Oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oo
oooooooo02Oooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0mooooo`03o`000?oo
oooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0?Oooool0
0ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo
02Oooooo00?o0000ooooooooool09_ooool5o`0001;ooooo00?o0000ooooooooool0?Oooool00ol0
003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo02Co
oooo0_l00005ooooo`Co00003_ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oo
oooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool09?ooool00ol0003ooooo
ooooo`08ooooo`Go00002Oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oooooo
0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool09?ooool00ol0003ooooooooo
o`0=ooooo`Co00001Oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oooooo0010
ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0B
ooooo`;o00000oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oooooo0010oooo
o`03o`000?oooooooooo02Oooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0Coooo
o`05o`000?ooooooooooooooool00000?oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0
003oooooooooo`0Wooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool05?ooool01?l0
003oooooooooool0000oooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo
02Oooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooo0000
03oooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool09oooool00ol0003o
ooooooooo`0Rooooo`03o`000?oooooooooo01Oooooo0_l0000oooooo`03o`000?oooooooooo03oo
oooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool08_ooool00ol0003ooooo
ooooo`0Dooooo`;o000000?oooooo`000?l00000?oooool00ol0003oooooooooo`0oooooo`00@?oo
oom@o`0001Gooooo00Go0000oooooooooooo0000ooooo`11o`00047ooooo0010ooooo`03o`000?oo
oooooooo02Oooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0Booooo`;o00000ooo
ool00ol0003oooooo`00000nooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooo
oooo02Oooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0Eooooo`;o000000Gooooo
o`000?ooooooooooo`00000mooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooo
oooo02Oooooo00?o0000ooooooooool08Oooool8o`0001;ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0jooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo
02Oooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
01Gooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003o
ooooooooo`0Wooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0Fooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool0?oooool0043ooooo
00?o0000ooooooooool09oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool05oooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo03oooooo
0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool08?ooool00ol0003ooooooooo
o`05ooooo`?o00005?ooool5o`0003Wooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000
ooooooooool09oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Kooooo0_l00000
1?oooooo0000o`000?l0000Cooooo`?o0000>Oooool00ol0003oooooooooo`0oooooo`00@?ooool0
0ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool01_ooool2
o`0000Cooooo1ol0000=ooooo`?o0000>?ooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0
003oooooooooo`0Wooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00Co0000oooooooooooo0000=oooool0
0ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo
01kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
00Wooooo00Co0000oooooooooooooooo0_l0000Cooooo`So00006_ooool00ol0003oooooooooo`0o
ooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01gooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool06?ooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03
o`000?oooooooooo01gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0oooooo`00
@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
5oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oo
oooooooo01cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0oooooo`00@?ooool0
0ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00?o00001oooool00ol0003oooooooooo`0?
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0o
ooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01cooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0Aooooo`;o00000_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000oooooooo
ool06oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`00
0?oooooooooo02Oooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo013ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Fooooo`03o`00
0?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool06_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooo
oooo02Oooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool02Oooool01?l0003oooooooooool0000Dooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0oooooo`00@?ooool0
0ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool03Oooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00_l0000C
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0o
ooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Sooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool05Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00cooooo00?o0000ooooooooool00oooool2o`00013ooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`00
0?oooooooooo02Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0@ooooo`Ko0000
1?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0
?oooool0043ooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo00_ooooo5?l0000;ooooo`03o`000?oooooooooo00Kooooo0_l0000=ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0oooooo`00@?ooool0
0ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Kooooo3ol0000:ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo01Cooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool09oooool00ol0
003oooooooooo`0Fooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool02Oooool2o`00
00Oooooo0_l00004ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0?oooool0043o
oooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01?o
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`02ooooo`;o00001Oooool2o`0000Oo
oooo0_l00009ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool05?ooool00ol0003o
ooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Oooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`0>ooooo`04o`000?oooooo0000o`0000Oo
oooo00?o0000ooooool000002?ooool00ol0003oooooooooo`06ooooo`;o00002Oooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo
00?o0000ooooooooool05oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00oooooo
0_l00008ooooo`03o`000?oooooo000000Wooooo00?o0000ooooooooool01oooool3o`0000Kooooo
0ol0000Cooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017ooooo0_l0
0005ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool02_ooool3o`0000Gooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003ooooooooo
o`0Wooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`0Cooooo`;o00000_ooool2o`0000;ooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0=ooooo`05o`000?ooooooooooooooool000005?ooool00ol0003oooooooooo`0oooooo`00@?oo
ool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`0Eooooo`;o00000oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00gooooo00Go0000ooooooooooooooooo`00000Dooooo`03o`000?oooooooooo03oooooo
0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool06Oooool00ol0003ooooooooo
o`0@ooooo`03o`000?oooooooooo00gooooo0_l00006ooooo`05o`000?ooooooooooooooool00000
2oooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`0001Cooooo00?o0000oooooooo
ool0?oooool0043ooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Jooooo`03o`00
0?oooooooooo00oooooo1_l00009ooooo`03o`000?oooooo000000Kooooo00Co0000oooooooooooo
00003?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo000001Gooooo00?o0000oooooooo
ool0?oooool0043ooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Jooooo`03o`00
0?oooooooooo01Cooooo00?o0000ooooooooool01Oooool2o`0000;ooooo00?o0000ooooooooool0
1?ooool01?l0003oooooooooool0000<ooooo`03o`000?oooooooooo00kooooo00?o0000ooooool0
00005Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`00
0?oooooooooo01[ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`04ooooo`04o`00
0?ooooooooooooooo`;o00001_ooool01Ol0003ooooooooooooooooo000000_ooooo00?o0000oooo
ooooool03oooool2o`0001Gooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000oooooooo
ool09oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool00_ooool3o`0000;ooooo0_l00008ooooo`04o`000?ooooooooooooooo`?o00002Oooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0?oooool0043o
oooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooool000000_l00005ooooo`03o`000?oooooooooo00Oooooo00Go0000oooooooo
ooooooooo`000002ooooo`Co00001Oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo
03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool06_ooool00ol0003o
ooooooooo`0@ooooo`Go00002?ooool00ol0003oooooooooo`07ooooo`05o`000?oooooooooooooo
ool000001_ooool4o`000003ooooool0003ooooo02Oooooo00?o0000ooooooooool0?oooool0043o
oooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`00
00_ooooo0_l0000Xooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oo
oooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool01oooool01?l0003oooooo`000?l0000<ooooo`03o`000?oooooooooo
02Kooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool09oooool00ol0003o
ooooooooo`0Iooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool02_ooool2o`0000Oo
oooo0ol0000=ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0?oooool0043ooooo
00?o0000ooooooooool09oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo013ooooo
00?o0000ooooooooool03Oooool2o`0000?ooooo0_l0000@ooooo`03o`000?oooooooooo02Oooooo
00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool09oooool00ol0003ooooooooo
o`0Iooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooo`00
000Aooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000
ooooooooool09oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Wooooo1Ol00003
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0X
ooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000oooo
ooooool06?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo1?l0000Boooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0ooooo
o`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Sooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool0:Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`00
0?oooooooooo01Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Iooooo`03o`00
0?oooooooooo013ooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`0oooooo`00@?oo
ool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Oooooo2ol0000Looooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0oooooo`00@?ooool0
0ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Oooooo00?o0000ooooool000000ol0000P
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0o
ooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Oooooo0_l0000Toooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`0ooooo
o`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Oooooo00?o0000ooooool0
00000_l0000Qooooo`03o`000?oooooooooo013ooooo0_l0000[ooooo`03o`000?oooooooooo03oo
oooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool05_ooool00ol0003ooooo
ooooo`03ooooo`?o00007Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo000002_ooooo
00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool09oooool00ol0003ooooooooo
o`0Eooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool06_ooool00ol0003ooooooooo
o`0?ooooo`05o`000?ooooooooooooooool00000:_ooool00ol0003oooooooooo`0oooooo`00@?oo
ool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0Iooooo`03o`000?oooooo000000kooooo0_l00005ooooo`03o`000?oo
oooooooo02Oooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool09oooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooo000000Wooooo00?o0000ooooooooool06?ooool4
o`0000cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooo
oooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool04oooool00ol0
003oooooooooo`04o`0000Kooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`02o`00
00Wooooo0_l0000:ooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool0?oooool0043o
oooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Go
oooo0ol00003ooooo`03o`000?oooooooooo01Wooooo00Co0000oooooooooooo00002?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0?oooool0043o
oooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Hooooo`?o00002?ooool00ol0003o
ooooooooo`0<ooooo`;o00009Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003ooooo
ooooo`0Wooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooool000002?l0000?ooooo`03o`00
0?oooooo000002Cooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool09ooo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03Ooo
ool01?l0003oooooooooool0000Sooooo`03o`000?oooooooooo03oooooo0010ooooocko00002ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0<ooooo`04o`000?ooooooooooooooobCo0000@Oooool0043ooooo00?o
0000ooooooooool09oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01oooooo00?o
0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0B
ooooo`Go00001?ooool2o`0000Kooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0N
ooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000oooo
ooooool04_ooool01Ol0003ooooooooooooooooo000000;ooooo0_l00008ooooo`03o`000?oooooo
oooo01Wooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0
003oooooooooo`0Wooooo`03o`000?oooooooooo01;ooooo00Go0000ooooooooooooooooo`000002
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0L
ooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000oooo
ooooool04_ooool?o`0000?ooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Koooo
o`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`0;ooooo`05o`000?ooooooooooooooool000006oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0Jooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oo
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo000000Co
00006?ooool4o`0000Gooooo00?o0000ooooooooool01oooool6o`0000[ooooo00?o0000oooooooo
ool06Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo01Cooooo0_l00004ooooo`?o00000_ooool00ol0003oooooooooo`04ooooo`?o0000
1Oooool4o`0000Sooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0oooooo`00@?oo
ool00ol0003oooooooooo`0Fooooo`Go00003?ooool00ol0003oooooooooo`0:ooooo`Co00000ooo
ool2o`0000_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`Ko00002_oo
ool00ol0003oooooooooo`07ooooo`Co00000_ooool3o`0000cooooo0ol00006ooooo`03o`000?oo
oooooooo01Oooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool05Oooool0
0ol0003oooooo`000003ooooo`Go00001oooool00ol0003oooooooooo`0:ooooo`04o`000?oooooo
ooooooooo`?o00003Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo000000;o00001_oo
ool5o`0000?ooooo0_l0000>ooooo`;o00004_ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo01Kooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool05?ooool0
1?l0003oooooooooool00008ooooo`Go00000_ooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`06ooooo`;o00003_oo
ool3o`00017ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo01Kooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool04_ooool2
o`0000;ooooo00?o0000ooooooooool02?ooool01?l0003oooooooooooooool5o`0000Wooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01Kooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool05Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06
ooooo`?o00000oooool4o`0000Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0F
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01_ooool2o`000004ooooool0003o0000o`0000cooooo1?l00006ooooo`03o`000?oooooo
oooo01Gooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`06ooooo`;o000000?oooooo`000?ooool04Oooool2o`0000Gooooo00?o0000oooo
ooooool04oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01Wooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo03oooooo0010ooooo`03
o`000?oooooooooo00kooooo00?o0000ooooool000000oooool2o`0000cooooo00?o0000oooooooo
ool01?ooool2o`0000;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`04ooooo`Go
00003oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01_ooooo00Go0000oooooooo
ooooooooo`00000Eooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo00go
oooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000003?ooool00ol0003ooooooooo
o`04ooooo`;o00000_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool00_ooool4o`0000[ooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`0Kooooo`?o00000oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo03oooooo0010
ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00oooool01?l0003oooooooooool0
000<ooooo`03o`000?oooooooooo00Cooooo0_l00003ooooo`03o`000?oooooooooo01;ooooo00Go
0000ooooooooooooooooo`000009ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0Fooooo`Go00001_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo00_ooooo0_l00004ooooo`05o`000?oo
ooooooooooooool000003?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000000?ooooo
00?o0000ooooooooool04_ooool01?l0003oooooooooool0000;ooooo`;o00001Oooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo01?ooooo0_l0000<ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`02o`000003ooooool0003ooooo00Cooooo00?o0000ooooooooool02?ooool2o`0000Gooooo
00?o0000ooooool000000oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo000000gooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo01?ooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo03oooooo
0010ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo0ol000000ooooooo0000ooooo`04ooooo`;o00001?oo
ool00ol0003oooooooooo`0Cooooo`Ko00002oooool2o`0000;ooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00_ooooo2?l00003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000001?ooool0
0ol0003oooooooooo`0Dooooo`05o`000?ooooooooooooooool000003Oooool2o`0001Oooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`03o`0000_ooooo00?o0000ooooooooool03ooo
ool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`Co00000_ooool4
o`0000Cooooo00?o0000ooooooooool05?ooool00ol0003oooooo`00000?ooooo`03o`000?oooooo
oooo01Gooooo00?o0000ooooooooool03oooool2o`0000;ooooo00Co0000oooooooooooooooo0ol0
0008ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000
ooooooooool01_ooool2o`0000gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05
ooooo`?o00000oooool01Ol0003ooooooooooooooooo000001Kooooo00?o0000ooooool000003ooo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00gooooo00?o0000ooooool000000_l0
0007ooooo`?o00001Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo03oooooo0010
ooooo`03o`000?oooooooooo00Kooooo0ol0000<ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool03?ooool4o`0001Oooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0H
ooooo`03o`000?oooooooooo00_ooooo1Ol0000;ooooo`?o000000?oooooo`000?ooool04Oooool0
0ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`04ooooo`Co000000?oooooo`00
0?ooool01?ooool6o`0000Wooooo00?o0000ooooooooool02oooool01?l0003oooooooooool0000F
ooooo`;o00003oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00_ooooo0_l0000@
ooooo`;o00004_ooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`06oooo
o`[o00003_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool01oooool5o`0000Oooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Koooo
o`03o`000?oooooooooo00Wooooo00Co0000ooooool0003o00008oooool00ol0003oooooooooo`0o
ooooo`00@?ooool00ol0003oooooooooo`04ooooo`Co00001oooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool01?l0003oooooooooooooool5
o`0000Gooooo1?l00002ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool06oooool0
0ol0003oooooooooo`07ooooo`;o000000?oooooo`000?ooool09?ooool00ol0003oooooooooo`0o
ooooo`00@?ooool00ol0003oooooooooo`04ooooo`Oo00000oooool00ol0003oooooooooo`0>oooo
o`;o00002Oooool00ol0003oooooooooo`05ooooo`?o00003_ooool2o`0001;ooooo00?o0000oooo
ooooool06_ooool00ol0003oooooooooo`05ooooo`;o000000?oooooo`000?l000009_ooool00ol0
003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool04?ooool3o`0000Gooooo00?o0000ooooooooool06?ooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool00oooool01?l0003o
ooooooooool0000Xooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool02?ooool2o`0001Gooooo0ol00002ooooo`03o`000?oooooooooo01Wo
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Kooooo`Ko00000_ooool00ol0003o
ooooooooo`0Wooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool02?ooool2o`0001Sooooo1_l0000Hooooo`03o`000?oooooooooo013ooooo
00?o0000ooooooooool06_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02Sooooo
00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00ko00004?ooool4o`0001Gooooo00?o0000ooooooooool03ooo
ool4o`0001Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Xooooo`03o`000?oo
oooooooo03oooooo0010ooooo`03o`000?oooooooooo00Cooooo2?l0000@ooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo01Oooooo0_l00004ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0?oooool0
043ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
01Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo
03oooooo0010ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`0Hooooo`;o00000oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo03oo
oooo0010ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05?ooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`0Jooooo`?o0000;?ooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`0Eooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool07?ooool00ol0003ooooooooo
o`0Zooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01Gooooo00?o0000
ooooooooool04?ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo02[ooooo00?o0000
ooooooooool0?oooool0043ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Coooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`0ooooo
o`00@?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool04Oooool3o`0001Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Kooooo`03
o`000?oooooooooo02_ooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo013ooooo00Co0000oooooooooooo
oooo0_l0000Eooooo`03o`000?oooooooooo00kooooo0ol0000Kooooo`03o`000?oooooooooo02co
oooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool01?ooool2o`0001Gooooo
00?o0000ooooooooool03_ooool2o`0000Kooooo0_l0000Cooooo`03o`000?oooooooooo00cooooo
0_l00003ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0;?ooool00ol0003ooooo
ooooo`0oooooo`00@?ooool00ol0003oooooooooo`03ooooo`Ko00004Oooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo00Sooooo0_l0000Aooooo`03o`000?oooooooooo00Wooooo0ol0
0005ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0;?ooool00ol0003ooooooooo
o`0oooooo`00@?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo1?l0000=
ooooo`03o`000?oooooooooo00cooooo0_l0000=ooooo`;o00003_ooool00ol0003oooooooooo`08
ooooo`;o00002?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo02gooooo00?o0000
ooooooooool0?oooool0043ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01_ooool2o`0000[ooooo00?o0000oooo
ooooool01oooool:o`0000Kooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`0ooooo
o`00@?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`09ooooo`;o00004oooool2o`0000_ooooo00?o0000oooooooo
ool01?ooool2o`0000cooooo2_l0000:ooooo`04o`000?ooooooooooooooo`;o0000<?ooool00ol0
003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`07ooooo`;o00005oooool2o`0000So
oooo00?o0000ooooooooool00_ooool3o`0000kooooo00?o0000ooooooooool04_ooool00ol0003o
ooooo`00000booooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool06Oooool2o`0000?ooooo1Ol000000ooooooo0000o`00000Aooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0oooooo`00@?oo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`04ooooo`;o00007_ooool3o`0000Gooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool0?ooo
ool0043ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool00oooool2o`0001oooooo00?o0000ooooooooool06_ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool0?oooool0
043ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo
01_ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo
03oooooo0010ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`09ooooo`Go00008?ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0Oooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0cooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool00_ooool8o`0000?ooooo0_l0000Qooooo`03o`000?oooooooooo01kooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo03oooooo0010
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool01?l0003oooooo`000?l0
000Rooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`0dooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool02?ooool2o`0002Cooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`0?
ooooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo02?ooooo00?o0000oooo
ooooool07oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo03Gooooo00?o0000oooo
ooooool0?oooool0043ooooo00?o0000ooooooooool02oooool;o`0002Gooooo00?o0000oooooooo
ool07oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo000003Kooooo00?o0000oooooooo
ool0?oooool0043ooooo00?o0000ooooooooool03Oooool3o`0000Gooooo00?o0000ooooooooool0
8oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00kooooo0ol0000fooooo`03o`00
0?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo013ooooo0_l00003ooooo`;o00009Ooo
ool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo00gooooo0_l00002ooooo`03o`000?oo
oooooooo03?ooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`02ooooo`;o00008oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooo
oooo00gooooo00Go0000ooooooooooooooooo`00000eooooo`03o`000?oooooooooo03oooooo0010
ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01?ooool3o`00023ooooo00?o0000
ooooooooool07_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool0<_ooool00ol0003oooooooooo`0oooooo`00@?oooolFo`0000Wooooo0_l0000Noooo
o`03o`000?oooooooooo01kooooo00?o0000ooooooooool04_oooolfo`00047ooooo0010ooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool02?ooool2o`0001cooooo00?o0000oooooooo
ool04?ooool3o`0000_ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0cooooo`03
o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooo000000gooooo1?l00003ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0cooooo`03o`00
0?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0Gooooo`04o`000?ooooooooooo`0000[ooooo0ol00008ooooo`03o`00
0?oooooooooo00Kooooo5Ol0000fooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oo
oooooooo01Cooooo00?o0000ooooooooool02?ooool7o`0001Cooooo00Go0000oooooooooooooooo
o`000007ooooo`;o00003?ooool00ol0003oooooooooo`02ooooo`?o00002oooool00ol0003ooooo
ooooo`0mooooo`03o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo01Cooooo00?o
0000ooooooooool03_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00?ooooo00Co
0000oooooooooooooooo0ol0000?ooooo`04o`000?oooooo0000o`0000kooooo00?o0000oooooooo
ool0?Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`03ooooo`04o`00
0?oooooo0000o`0001?ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0mooooo`03
o`000?oooooooooo03oooooo0010ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Cooooo0_l0000Vooooo`03o`00
0?oooooooooo03gooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool05ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0?ooo
ool0043ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooo
oooo03gooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool06Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0Wooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0?oooool0043o
oooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`04ooooo`Go00004_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0?Oooool00ol0003o
ooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00?o0000
1Oooool5o`0000kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Vooooo`03o`00
0?oooooooooo03gooooo00?o0000ooooooooool0?oooool0043ooooo00?o0000ooooooooool07?oo
ool2o`0000Wooooo00Co0000oooooooooooooooo1ol00007ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool09_ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03oooooo
0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool02?ooool6o`000003ooooool0
003ooooo00Cooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0mooooo`03o`000?oo
oooooooo03oooooo0010ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool03_ooool8
o`0002Oooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0
003oooooooooo`0Wooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0?Oooool00ol0
003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo03go
oooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003ooooo
ooooo`0Wooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0?Oooool00ol0003ooooo
ooooo`0oooooo`00@?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo03gooooo00?o
0000ooooooooool0?Oooool00ol0003oooooooooo`0oooooo`00@?ooool00ol0003oooooooooo`0W
ooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0o
ooooo`00@?oooon[o`00047ooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo003o
ooooobgooooo0000\
\>"],
 ImageRangeCache->{{{0, 299}, {179, 0}} -> {-3009.42, -2520.02, 28.1567, \
28.1567}},
 CellTags->"S5.65.1"],

Cell[BoxData["\<\"-WorldGraphics-\"\>"], "Output",
 CellLabel->"Out[2]= ",
 CellTags->"S5.65.1"]
}, Open  ]],

Cell["\<\
Here is a map of the world with each country colored with a randomly chosen \
gray level. \
\>", "MathCaption",
 CellTags->{"S5.65.1", "1.5"}],

Cell[CellGroupData[{

Cell["WorldPlot[{World, RandomGrays}]", "Input",
 CellLabel->"In[3]:= ",
 CellTags->"S5.65.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 4.40917e-05 0.25 4.40917e-05 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
.001 w
[ ] 0 setdash
.02381 .0119 m
.02381 .02143 L
.02381 .03095 L
.02381 .04048 L
.02381 .05 L
.02381 .05952 L
.02381 .06905 L
.02381 .07857 L
.02381 .0881 L
.02381 .09762 L
.02381 .10714 L
.02381 .11667 L
.02381 .12619 L
.02381 .13571 L
.02381 .14524 L
.02381 .15476 L
.02381 .16429 L
.02381 .17381 L
.02381 .18333 L
.02381 .19286 L
.02381 .20238 L
.02381 .2119 L
.02381 .22143 L
.02381 .23095 L
.02381 .24048 L
.02381 .25 L
.02381 .25952 L
.02381 .26905 L
.02381 .27857 L
.02381 .2881 L
.02381 .29762 L
.02381 .30714 L
.02381 .31667 L
.02381 .32619 L
.02381 .33571 L
.02381 .34524 L
.02381 .35476 L
.02381 .36429 L
.02381 .37381 L
.02381 .38333 L
.02381 .39286 L
.02381 .40238 L
.02381 .4119 L
.02381 .42143 L
.02381 .43095 L
.02381 .44048 L
.02381 .45 L
.02381 .45952 L
.02381 .46905 L
.02381 .47857 L
Mistroke
.02381 .4881 L
.02381 .4881 L
Mfstroke
.10317 .0119 m
.10317 .02143 L
.10317 .03095 L
.10317 .04048 L
.10317 .05 L
.10317 .05952 L
.10317 .06905 L
.10317 .07857 L
.10317 .0881 L
.10317 .09762 L
.10317 .10714 L
.10317 .11667 L
.10317 .12619 L
.10317 .13571 L
.10317 .14524 L
.10317 .15476 L
.10317 .16429 L
.10317 .17381 L
.10317 .18333 L
.10317 .19286 L
.10317 .20238 L
.10317 .2119 L
.10317 .22143 L
.10317 .23095 L
.10317 .24048 L
.10317 .25 L
.10317 .25952 L
.10317 .26905 L
.10317 .27857 L
.10317 .2881 L
.10317 .29762 L
.10317 .30714 L
.10317 .31667 L
.10317 .32619 L
.10317 .33571 L
.10317 .34524 L
.10317 .35476 L
.10317 .36429 L
.10317 .37381 L
.10317 .38333 L
.10317 .39286 L
.10317 .40238 L
.10317 .4119 L
.10317 .42143 L
.10317 .43095 L
.10317 .44048 L
.10317 .45 L
.10317 .45952 L
.10317 .46905 L
.10317 .47857 L
Mistroke
.10317 .4881 L
.10317 .4881 L
Mfstroke
.18254 .0119 m
.18254 .02143 L
.18254 .03095 L
.18254 .04048 L
.18254 .05 L
.18254 .05952 L
.18254 .06905 L
.18254 .07857 L
.18254 .0881 L
.18254 .09762 L
.18254 .10714 L
.18254 .11667 L
.18254 .12619 L
.18254 .13571 L
.18254 .14524 L
.18254 .15476 L
.18254 .16429 L
.18254 .17381 L
.18254 .18333 L
.18254 .19286 L
.18254 .20238 L
.18254 .2119 L
.18254 .22143 L
.18254 .23095 L
.18254 .24048 L
.18254 .25 L
.18254 .25952 L
.18254 .26905 L
.18254 .27857 L
.18254 .2881 L
.18254 .29762 L
.18254 .30714 L
.18254 .31667 L
.18254 .32619 L
.18254 .33571 L
.18254 .34524 L
.18254 .35476 L
.18254 .36429 L
.18254 .37381 L
.18254 .38333 L
.18254 .39286 L
.18254 .40238 L
.18254 .4119 L
.18254 .42143 L
.18254 .43095 L
.18254 .44048 L
.18254 .45 L
.18254 .45952 L
.18254 .46905 L
.18254 .47857 L
Mistroke
.18254 .4881 L
.18254 .4881 L
Mfstroke
.2619 .0119 m
.2619 .02143 L
.2619 .03095 L
.2619 .04048 L
.2619 .05 L
.2619 .05952 L
.2619 .06905 L
.2619 .07857 L
.2619 .0881 L
.2619 .09762 L
.2619 .10714 L
.2619 .11667 L
.2619 .12619 L
.2619 .13571 L
.2619 .14524 L
.2619 .15476 L
.2619 .16429 L
.2619 .17381 L
.2619 .18333 L
.2619 .19286 L
.2619 .20238 L
.2619 .2119 L
.2619 .22143 L
.2619 .23095 L
.2619 .24048 L
.2619 .25 L
.2619 .25952 L
.2619 .26905 L
.2619 .27857 L
.2619 .2881 L
.2619 .29762 L
.2619 .30714 L
.2619 .31667 L
.2619 .32619 L
.2619 .33571 L
.2619 .34524 L
.2619 .35476 L
.2619 .36429 L
.2619 .37381 L
.2619 .38333 L
.2619 .39286 L
.2619 .40238 L
.2619 .4119 L
.2619 .42143 L
.2619 .43095 L
.2619 .44048 L
.2619 .45 L
.2619 .45952 L
.2619 .46905 L
.2619 .47857 L
Mistroke
.2619 .4881 L
.2619 .4881 L
Mfstroke
.34127 .0119 m
.34127 .02143 L
.34127 .03095 L
.34127 .04048 L
.34127 .05 L
.34127 .05952 L
.34127 .06905 L
.34127 .07857 L
.34127 .0881 L
.34127 .09762 L
.34127 .10714 L
.34127 .11667 L
.34127 .12619 L
.34127 .13571 L
.34127 .14524 L
.34127 .15476 L
.34127 .16429 L
.34127 .17381 L
.34127 .18333 L
.34127 .19286 L
.34127 .20238 L
.34127 .2119 L
.34127 .22143 L
.34127 .23095 L
.34127 .24048 L
.34127 .25 L
.34127 .25952 L
.34127 .26905 L
.34127 .27857 L
.34127 .2881 L
.34127 .29762 L
.34127 .30714 L
.34127 .31667 L
.34127 .32619 L
.34127 .33571 L
.34127 .34524 L
.34127 .35476 L
.34127 .36429 L
.34127 .37381 L
.34127 .38333 L
.34127 .39286 L
.34127 .40238 L
.34127 .4119 L
.34127 .42143 L
.34127 .43095 L
.34127 .44048 L
.34127 .45 L
.34127 .45952 L
.34127 .46905 L
.34127 .47857 L
Mistroke
.34127 .4881 L
.34127 .4881 L
Mfstroke
.42063 .0119 m
.42063 .02143 L
.42063 .03095 L
.42063 .04048 L
.42063 .05 L
.42063 .05952 L
.42063 .06905 L
.42063 .07857 L
.42063 .0881 L
.42063 .09762 L
.42063 .10714 L
.42063 .11667 L
.42063 .12619 L
.42063 .13571 L
.42063 .14524 L
.42063 .15476 L
.42063 .16429 L
.42063 .17381 L
.42063 .18333 L
.42063 .19286 L
.42063 .20238 L
.42063 .2119 L
.42063 .22143 L
.42063 .23095 L
.42063 .24048 L
.42063 .25 L
.42063 .25952 L
.42063 .26905 L
.42063 .27857 L
.42063 .2881 L
.42063 .29762 L
.42063 .30714 L
.42063 .31667 L
.42063 .32619 L
.42063 .33571 L
.42063 .34524 L
.42063 .35476 L
.42063 .36429 L
.42063 .37381 L
.42063 .38333 L
.42063 .39286 L
.42063 .40238 L
.42063 .4119 L
.42063 .42143 L
.42063 .43095 L
.42063 .44048 L
.42063 .45 L
.42063 .45952 L
.42063 .46905 L
.42063 .47857 L
Mistroke
.42063 .4881 L
.42063 .4881 L
Mfstroke
.5 .0119 m
.5 .02143 L
.5 .03095 L
.5 .04048 L
.5 .05 L
.5 .05952 L
.5 .06905 L
.5 .07857 L
.5 .0881 L
.5 .09762 L
.5 .10714 L
.5 .11667 L
.5 .12619 L
.5 .13571 L
.5 .14524 L
.5 .15476 L
.5 .16429 L
.5 .17381 L
.5 .18333 L
.5 .19286 L
.5 .20238 L
.5 .2119 L
.5 .22143 L
.5 .23095 L
.5 .24048 L
.5 .25 L
.5 .25952 L
.5 .26905 L
.5 .27857 L
.5 .2881 L
.5 .29762 L
.5 .30714 L
.5 .31667 L
.5 .32619 L
.5 .33571 L
.5 .34524 L
.5 .35476 L
.5 .36429 L
.5 .37381 L
.5 .38333 L
.5 .39286 L
.5 .40238 L
.5 .4119 L
.5 .42143 L
.5 .43095 L
.5 .44048 L
.5 .45 L
.5 .45952 L
.5 .46905 L
.5 .47857 L
Mistroke
.5 .4881 L
.5 .4881 L
Mfstroke
.57937 .0119 m
.57937 .02143 L
.57937 .03095 L
.57937 .04048 L
.57937 .05 L
.57937 .05952 L
.57937 .06905 L
.57937 .07857 L
.57937 .0881 L
.57937 .09762 L
.57937 .10714 L
.57937 .11667 L
.57937 .12619 L
.57937 .13571 L
.57937 .14524 L
.57937 .15476 L
.57937 .16429 L
.57937 .17381 L
.57937 .18333 L
.57937 .19286 L
.57937 .20238 L
.57937 .2119 L
.57937 .22143 L
.57937 .23095 L
.57937 .24048 L
.57937 .25 L
.57937 .25952 L
.57937 .26905 L
.57937 .27857 L
.57937 .2881 L
.57937 .29762 L
.57937 .30714 L
.57937 .31667 L
.57937 .32619 L
.57937 .33571 L
.57937 .34524 L
.57937 .35476 L
.57937 .36429 L
.57937 .37381 L
.57937 .38333 L
.57937 .39286 L
.57937 .40238 L
.57937 .4119 L
.57937 .42143 L
.57937 .43095 L
.57937 .44048 L
.57937 .45 L
.57937 .45952 L
.57937 .46905 L
.57937 .47857 L
Mistroke
.57937 .4881 L
.57937 .4881 L
Mfstroke
.65873 .0119 m
.65873 .02143 L
.65873 .03095 L
.65873 .04048 L
.65873 .05 L
.65873 .05952 L
.65873 .06905 L
.65873 .07857 L
.65873 .0881 L
.65873 .09762 L
.65873 .10714 L
.65873 .11667 L
.65873 .12619 L
.65873 .13571 L
.65873 .14524 L
.65873 .15476 L
.65873 .16429 L
.65873 .17381 L
.65873 .18333 L
.65873 .19286 L
.65873 .20238 L
.65873 .2119 L
.65873 .22143 L
.65873 .23095 L
.65873 .24048 L
.65873 .25 L
.65873 .25952 L
.65873 .26905 L
.65873 .27857 L
.65873 .2881 L
.65873 .29762 L
.65873 .30714 L
.65873 .31667 L
.65873 .32619 L
.65873 .33571 L
.65873 .34524 L
.65873 .35476 L
.65873 .36429 L
.65873 .37381 L
.65873 .38333 L
.65873 .39286 L
.65873 .40238 L
.65873 .4119 L
.65873 .42143 L
.65873 .43095 L
.65873 .44048 L
.65873 .45 L
.65873 .45952 L
.65873 .46905 L
.65873 .47857 L
Mistroke
.65873 .4881 L
.65873 .4881 L
Mfstroke
.7381 .0119 m
.7381 .02143 L
.7381 .03095 L
.7381 .04048 L
.7381 .05 L
.7381 .05952 L
.7381 .06905 L
.7381 .07857 L
.7381 .0881 L
.7381 .09762 L
.7381 .10714 L
.7381 .11667 L
.7381 .12619 L
.7381 .13571 L
.7381 .14524 L
.7381 .15476 L
.7381 .16429 L
.7381 .17381 L
.7381 .18333 L
.7381 .19286 L
.7381 .20238 L
.7381 .2119 L
.7381 .22143 L
.7381 .23095 L
.7381 .24048 L
.7381 .25 L
.7381 .25952 L
.7381 .26905 L
.7381 .27857 L
.7381 .2881 L
.7381 .29762 L
.7381 .30714 L
.7381 .31667 L
.7381 .32619 L
.7381 .33571 L
.7381 .34524 L
.7381 .35476 L
.7381 .36429 L
.7381 .37381 L
.7381 .38333 L
.7381 .39286 L
.7381 .40238 L
.7381 .4119 L
.7381 .42143 L
.7381 .43095 L
.7381 .44048 L
.7381 .45 L
.7381 .45952 L
.7381 .46905 L
.7381 .47857 L
Mistroke
.7381 .4881 L
.7381 .4881 L
Mfstroke
.81746 .0119 m
.81746 .02143 L
.81746 .03095 L
.81746 .04048 L
.81746 .05 L
.81746 .05952 L
.81746 .06905 L
.81746 .07857 L
.81746 .0881 L
.81746 .09762 L
.81746 .10714 L
.81746 .11667 L
.81746 .12619 L
.81746 .13571 L
.81746 .14524 L
.81746 .15476 L
.81746 .16429 L
.81746 .17381 L
.81746 .18333 L
.81746 .19286 L
.81746 .20238 L
.81746 .2119 L
.81746 .22143 L
.81746 .23095 L
.81746 .24048 L
.81746 .25 L
.81746 .25952 L
.81746 .26905 L
.81746 .27857 L
.81746 .2881 L
.81746 .29762 L
.81746 .30714 L
.81746 .31667 L
.81746 .32619 L
.81746 .33571 L
.81746 .34524 L
.81746 .35476 L
.81746 .36429 L
.81746 .37381 L
.81746 .38333 L
.81746 .39286 L
.81746 .40238 L
.81746 .4119 L
.81746 .42143 L
.81746 .43095 L
.81746 .44048 L
.81746 .45 L
.81746 .45952 L
.81746 .46905 L
.81746 .47857 L
Mistroke
.81746 .4881 L
.81746 .4881 L
Mfstroke
.89683 .0119 m
.89683 .02143 L
.89683 .03095 L
.89683 .04048 L
.89683 .05 L
.89683 .05952 L
.89683 .06905 L
.89683 .07857 L
.89683 .0881 L
.89683 .09762 L
.89683 .10714 L
.89683 .11667 L
.89683 .12619 L
.89683 .13571 L
.89683 .14524 L
.89683 .15476 L
.89683 .16429 L
.89683 .17381 L
.89683 .18333 L
.89683 .19286 L
.89683 .20238 L
.89683 .2119 L
.89683 .22143 L
.89683 .23095 L
.89683 .24048 L
.89683 .25 L
.89683 .25952 L
.89683 .26905 L
.89683 .27857 L
.89683 .2881 L
.89683 .29762 L
.89683 .30714 L
.89683 .31667 L
.89683 .32619 L
.89683 .33571 L
.89683 .34524 L
.89683 .35476 L
.89683 .36429 L
.89683 .37381 L
.89683 .38333 L
.89683 .39286 L
.89683 .40238 L
.89683 .4119 L
.89683 .42143 L
.89683 .43095 L
.89683 .44048 L
.89683 .45 L
.89683 .45952 L
.89683 .46905 L
.89683 .47857 L
Mistroke
.89683 .4881 L
.89683 .4881 L
Mfstroke
.97619 .0119 m
.97619 .02143 L
.97619 .03095 L
.97619 .04048 L
.97619 .05 L
.97619 .05952 L
.97619 .06905 L
.97619 .07857 L
.97619 .0881 L
.97619 .09762 L
.97619 .10714 L
.97619 .11667 L
.97619 .12619 L
.97619 .13571 L
.97619 .14524 L
.97619 .15476 L
.97619 .16429 L
.97619 .17381 L
.97619 .18333 L
.97619 .19286 L
.97619 .20238 L
.97619 .2119 L
.97619 .22143 L
.97619 .23095 L
.97619 .24048 L
.97619 .25 L
.97619 .25952 L
.97619 .26905 L
.97619 .27857 L
.97619 .2881 L
.97619 .29762 L
.97619 .30714 L
.97619 .31667 L
.97619 .32619 L
.97619 .33571 L
.97619 .34524 L
.97619 .35476 L
.97619 .36429 L
.97619 .37381 L
.97619 .38333 L
.97619 .39286 L
.97619 .40238 L
.97619 .4119 L
.97619 .42143 L
.97619 .43095 L
.97619 .44048 L
.97619 .45 L
.97619 .45952 L
.97619 .46905 L
.97619 .47857 L
Mistroke
.97619 .4881 L
.97619 .4881 L
Mfstroke
.02381 .0119 m
.03333 .0119 L
.04286 .0119 L
.05238 .0119 L
.0619 .0119 L
.07143 .0119 L
.08095 .0119 L
.09048 .0119 L
.1 .0119 L
.10952 .0119 L
.11905 .0119 L
.12857 .0119 L
.1381 .0119 L
.14762 .0119 L
.15714 .0119 L
.16667 .0119 L
.17619 .0119 L
.18571 .0119 L
.19524 .0119 L
.20476 .0119 L
.21429 .0119 L
.22381 .0119 L
.23333 .0119 L
.24286 .0119 L
.25238 .0119 L
.2619 .0119 L
.27143 .0119 L
.28095 .0119 L
.29048 .0119 L
.3 .0119 L
.30952 .0119 L
.31905 .0119 L
.32857 .0119 L
.3381 .0119 L
.34762 .0119 L
.35714 .0119 L
.36667 .0119 L
.37619 .0119 L
.38571 .0119 L
.39524 .0119 L
.40476 .0119 L
.41429 .0119 L
.42381 .0119 L
.43333 .0119 L
.44286 .0119 L
.45238 .0119 L
.4619 .0119 L
.47143 .0119 L
.48095 .0119 L
.49048 .0119 L
Mistroke
.5 .0119 L
.50952 .0119 L
.51905 .0119 L
.52857 .0119 L
.5381 .0119 L
.54762 .0119 L
.55714 .0119 L
.56667 .0119 L
.57619 .0119 L
.58571 .0119 L
.59524 .0119 L
.60476 .0119 L
.61429 .0119 L
.62381 .0119 L
.63333 .0119 L
.64286 .0119 L
.65238 .0119 L
.6619 .0119 L
.67143 .0119 L
.68095 .0119 L
.69048 .0119 L
.7 .0119 L
.70952 .0119 L
.71905 .0119 L
.72857 .0119 L
.7381 .0119 L
.74762 .0119 L
.75714 .0119 L
.76667 .0119 L
.77619 .0119 L
.78571 .0119 L
.79524 .0119 L
.80476 .0119 L
.81429 .0119 L
.82381 .0119 L
.83333 .0119 L
.84286 .0119 L
.85238 .0119 L
.8619 .0119 L
.87143 .0119 L
.88095 .0119 L
.89048 .0119 L
.9 .0119 L
.90952 .0119 L
.91905 .0119 L
.92857 .0119 L
.9381 .0119 L
.94762 .0119 L
.95714 .0119 L
.96667 .0119 L
Mistroke
.97619 .0119 L
.97619 .0119 L
Mfstroke
.02381 .09127 m
.03333 .09127 L
.04286 .09127 L
.05238 .09127 L
.0619 .09127 L
.07143 .09127 L
.08095 .09127 L
.09048 .09127 L
.1 .09127 L
.10952 .09127 L
.11905 .09127 L
.12857 .09127 L
.1381 .09127 L
.14762 .09127 L
.15714 .09127 L
.16667 .09127 L
.17619 .09127 L
.18571 .09127 L
.19524 .09127 L
.20476 .09127 L
.21429 .09127 L
.22381 .09127 L
.23333 .09127 L
.24286 .09127 L
.25238 .09127 L
.2619 .09127 L
.27143 .09127 L
.28095 .09127 L
.29048 .09127 L
.3 .09127 L
.30952 .09127 L
.31905 .09127 L
.32857 .09127 L
.3381 .09127 L
.34762 .09127 L
.35714 .09127 L
.36667 .09127 L
.37619 .09127 L
.38571 .09127 L
.39524 .09127 L
.40476 .09127 L
.41429 .09127 L
.42381 .09127 L
.43333 .09127 L
.44286 .09127 L
.45238 .09127 L
.4619 .09127 L
.47143 .09127 L
.48095 .09127 L
.49048 .09127 L
Mistroke
.5 .09127 L
.50952 .09127 L
.51905 .09127 L
.52857 .09127 L
.5381 .09127 L
.54762 .09127 L
.55714 .09127 L
.56667 .09127 L
.57619 .09127 L
.58571 .09127 L
.59524 .09127 L
.60476 .09127 L
.61429 .09127 L
.62381 .09127 L
.63333 .09127 L
.64286 .09127 L
.65238 .09127 L
.6619 .09127 L
.67143 .09127 L
.68095 .09127 L
.69048 .09127 L
.7 .09127 L
.70952 .09127 L
.71905 .09127 L
.72857 .09127 L
.7381 .09127 L
.74762 .09127 L
.75714 .09127 L
.76667 .09127 L
.77619 .09127 L
.78571 .09127 L
.79524 .09127 L
.80476 .09127 L
.81429 .09127 L
.82381 .09127 L
.83333 .09127 L
.84286 .09127 L
.85238 .09127 L
.8619 .09127 L
.87143 .09127 L
.88095 .09127 L
.89048 .09127 L
.9 .09127 L
.90952 .09127 L
.91905 .09127 L
.92857 .09127 L
.9381 .09127 L
.94762 .09127 L
.95714 .09127 L
.96667 .09127 L
Mistroke
.97619 .09127 L
.97619 .09127 L
Mfstroke
.02381 .17063 m
.03333 .17063 L
.04286 .17063 L
.05238 .17063 L
.0619 .17063 L
.07143 .17063 L
.08095 .17063 L
.09048 .17063 L
.1 .17063 L
.10952 .17063 L
.11905 .17063 L
.12857 .17063 L
.1381 .17063 L
.14762 .17063 L
.15714 .17063 L
.16667 .17063 L
.17619 .17063 L
.18571 .17063 L
.19524 .17063 L
.20476 .17063 L
.21429 .17063 L
.22381 .17063 L
.23333 .17063 L
.24286 .17063 L
.25238 .17063 L
.2619 .17063 L
.27143 .17063 L
.28095 .17063 L
.29048 .17063 L
.3 .17063 L
.30952 .17063 L
.31905 .17063 L
.32857 .17063 L
.3381 .17063 L
.34762 .17063 L
.35714 .17063 L
.36667 .17063 L
.37619 .17063 L
.38571 .17063 L
.39524 .17063 L
.40476 .17063 L
.41429 .17063 L
.42381 .17063 L
.43333 .17063 L
.44286 .17063 L
.45238 .17063 L
.4619 .17063 L
.47143 .17063 L
.48095 .17063 L
.49048 .17063 L
Mistroke
.5 .17063 L
.50952 .17063 L
.51905 .17063 L
.52857 .17063 L
.5381 .17063 L
.54762 .17063 L
.55714 .17063 L
.56667 .17063 L
.57619 .17063 L
.58571 .17063 L
.59524 .17063 L
.60476 .17063 L
.61429 .17063 L
.62381 .17063 L
.63333 .17063 L
.64286 .17063 L
.65238 .17063 L
.6619 .17063 L
.67143 .17063 L
.68095 .17063 L
.69048 .17063 L
.7 .17063 L
.70952 .17063 L
.71905 .17063 L
.72857 .17063 L
.7381 .17063 L
.74762 .17063 L
.75714 .17063 L
.76667 .17063 L
.77619 .17063 L
.78571 .17063 L
.79524 .17063 L
.80476 .17063 L
.81429 .17063 L
.82381 .17063 L
.83333 .17063 L
.84286 .17063 L
.85238 .17063 L
.8619 .17063 L
.87143 .17063 L
.88095 .17063 L
.89048 .17063 L
.9 .17063 L
.90952 .17063 L
.91905 .17063 L
.92857 .17063 L
.9381 .17063 L
.94762 .17063 L
.95714 .17063 L
.96667 .17063 L
Mistroke
.97619 .17063 L
.97619 .17063 L
Mfstroke
.02381 .25 m
.03333 .25 L
.04286 .25 L
.05238 .25 L
.0619 .25 L
.07143 .25 L
.08095 .25 L
.09048 .25 L
.1 .25 L
.10952 .25 L
.11905 .25 L
.12857 .25 L
.1381 .25 L
.14762 .25 L
.15714 .25 L
.16667 .25 L
.17619 .25 L
.18571 .25 L
.19524 .25 L
.20476 .25 L
.21429 .25 L
.22381 .25 L
.23333 .25 L
.24286 .25 L
.25238 .25 L
.2619 .25 L
.27143 .25 L
.28095 .25 L
.29048 .25 L
.3 .25 L
.30952 .25 L
.31905 .25 L
.32857 .25 L
.3381 .25 L
.34762 .25 L
.35714 .25 L
.36667 .25 L
.37619 .25 L
.38571 .25 L
.39524 .25 L
.40476 .25 L
.41429 .25 L
.42381 .25 L
.43333 .25 L
.44286 .25 L
.45238 .25 L
.4619 .25 L
.47143 .25 L
.48095 .25 L
.49048 .25 L
Mistroke
.5 .25 L
.50952 .25 L
.51905 .25 L
.52857 .25 L
.5381 .25 L
.54762 .25 L
.55714 .25 L
.56667 .25 L
.57619 .25 L
.58571 .25 L
.59524 .25 L
.60476 .25 L
.61429 .25 L
.62381 .25 L
.63333 .25 L
.64286 .25 L
.65238 .25 L
.6619 .25 L
.67143 .25 L
.68095 .25 L
.69048 .25 L
.7 .25 L
.70952 .25 L
.71905 .25 L
.72857 .25 L
.7381 .25 L
.74762 .25 L
.75714 .25 L
.76667 .25 L
.77619 .25 L
.78571 .25 L
.79524 .25 L
.80476 .25 L
.81429 .25 L
.82381 .25 L
.83333 .25 L
.84286 .25 L
.85238 .25 L
.8619 .25 L
.87143 .25 L
.88095 .25 L
.89048 .25 L
.9 .25 L
.90952 .25 L
.91905 .25 L
.92857 .25 L
.9381 .25 L
.94762 .25 L
.95714 .25 L
.96667 .25 L
Mistroke
.97619 .25 L
.97619 .25 L
Mfstroke
.02381 .32937 m
.03333 .32937 L
.04286 .32937 L
.05238 .32937 L
.0619 .32937 L
.07143 .32937 L
.08095 .32937 L
.09048 .32937 L
.1 .32937 L
.10952 .32937 L
.11905 .32937 L
.12857 .32937 L
.1381 .32937 L
.14762 .32937 L
.15714 .32937 L
.16667 .32937 L
.17619 .32937 L
.18571 .32937 L
.19524 .32937 L
.20476 .32937 L
.21429 .32937 L
.22381 .32937 L
.23333 .32937 L
.24286 .32937 L
.25238 .32937 L
.2619 .32937 L
.27143 .32937 L
.28095 .32937 L
.29048 .32937 L
.3 .32937 L
.30952 .32937 L
.31905 .32937 L
.32857 .32937 L
.3381 .32937 L
.34762 .32937 L
.35714 .32937 L
.36667 .32937 L
.37619 .32937 L
.38571 .32937 L
.39524 .32937 L
.40476 .32937 L
.41429 .32937 L
.42381 .32937 L
.43333 .32937 L
.44286 .32937 L
.45238 .32937 L
.4619 .32937 L
.47143 .32937 L
.48095 .32937 L
.49048 .32937 L
Mistroke
.5 .32937 L
.50952 .32937 L
.51905 .32937 L
.52857 .32937 L
.5381 .32937 L
.54762 .32937 L
.55714 .32937 L
.56667 .32937 L
.57619 .32937 L
.58571 .32937 L
.59524 .32937 L
.60476 .32937 L
.61429 .32937 L
.62381 .32937 L
.63333 .32937 L
.64286 .32937 L
.65238 .32937 L
.6619 .32937 L
.67143 .32937 L
.68095 .32937 L
.69048 .32937 L
.7 .32937 L
.70952 .32937 L
.71905 .32937 L
.72857 .32937 L
.7381 .32937 L
.74762 .32937 L
.75714 .32937 L
.76667 .32937 L
.77619 .32937 L
.78571 .32937 L
.79524 .32937 L
.80476 .32937 L
.81429 .32937 L
.82381 .32937 L
.83333 .32937 L
.84286 .32937 L
.85238 .32937 L
.8619 .32937 L
.87143 .32937 L
.88095 .32937 L
.89048 .32937 L
.9 .32937 L
.90952 .32937 L
.91905 .32937 L
.92857 .32937 L
.9381 .32937 L
.94762 .32937 L
.95714 .32937 L
.96667 .32937 L
Mistroke
.97619 .32937 L
.97619 .32937 L
Mfstroke
.02381 .40873 m
.03333 .40873 L
.04286 .40873 L
.05238 .40873 L
.0619 .40873 L
.07143 .40873 L
.08095 .40873 L
.09048 .40873 L
.1 .40873 L
.10952 .40873 L
.11905 .40873 L
.12857 .40873 L
.1381 .40873 L
.14762 .40873 L
.15714 .40873 L
.16667 .40873 L
.17619 .40873 L
.18571 .40873 L
.19524 .40873 L
.20476 .40873 L
.21429 .40873 L
.22381 .40873 L
.23333 .40873 L
.24286 .40873 L
.25238 .40873 L
.2619 .40873 L
.27143 .40873 L
.28095 .40873 L
.29048 .40873 L
.3 .40873 L
.30952 .40873 L
.31905 .40873 L
.32857 .40873 L
.3381 .40873 L
.34762 .40873 L
.35714 .40873 L
.36667 .40873 L
.37619 .40873 L
.38571 .40873 L
.39524 .40873 L
.40476 .40873 L
.41429 .40873 L
.42381 .40873 L
.43333 .40873 L
.44286 .40873 L
.45238 .40873 L
.4619 .40873 L
.47143 .40873 L
.48095 .40873 L
.49048 .40873 L
Mistroke
.5 .40873 L
.50952 .40873 L
.51905 .40873 L
.52857 .40873 L
.5381 .40873 L
.54762 .40873 L
.55714 .40873 L
.56667 .40873 L
.57619 .40873 L
.58571 .40873 L
.59524 .40873 L
.60476 .40873 L
.61429 .40873 L
.62381 .40873 L
.63333 .40873 L
.64286 .40873 L
.65238 .40873 L
.6619 .40873 L
.67143 .40873 L
.68095 .40873 L
.69048 .40873 L
.7 .40873 L
.70952 .40873 L
.71905 .40873 L
.72857 .40873 L
.7381 .40873 L
.74762 .40873 L
.75714 .40873 L
.76667 .40873 L
.77619 .40873 L
.78571 .40873 L
.79524 .40873 L
.80476 .40873 L
.81429 .40873 L
.82381 .40873 L
.83333 .40873 L
.84286 .40873 L
.85238 .40873 L
.8619 .40873 L
.87143 .40873 L
.88095 .40873 L
.89048 .40873 L
.9 .40873 L
.90952 .40873 L
.91905 .40873 L
.92857 .40873 L
.9381 .40873 L
.94762 .40873 L
.95714 .40873 L
.96667 .40873 L
Mistroke
.97619 .40873 L
.97619 .40873 L
Mfstroke
.02381 .4881 m
.03333 .4881 L
.04286 .4881 L
.05238 .4881 L
.0619 .4881 L
.07143 .4881 L
.08095 .4881 L
.09048 .4881 L
.1 .4881 L
.10952 .4881 L
.11905 .4881 L
.12857 .4881 L
.1381 .4881 L
.14762 .4881 L
.15714 .4881 L
.16667 .4881 L
.17619 .4881 L
.18571 .4881 L
.19524 .4881 L
.20476 .4881 L
.21429 .4881 L
.22381 .4881 L
.23333 .4881 L
.24286 .4881 L
.25238 .4881 L
.2619 .4881 L
.27143 .4881 L
.28095 .4881 L
.29048 .4881 L
.3 .4881 L
.30952 .4881 L
.31905 .4881 L
.32857 .4881 L
.3381 .4881 L
.34762 .4881 L
.35714 .4881 L
.36667 .4881 L
.37619 .4881 L
.38571 .4881 L
.39524 .4881 L
.40476 .4881 L
.41429 .4881 L
.42381 .4881 L
.43333 .4881 L
.44286 .4881 L
.45238 .4881 L
.4619 .4881 L
.47143 .4881 L
.48095 .4881 L
.49048 .4881 L
Mistroke
.5 .4881 L
.50952 .4881 L
.51905 .4881 L
.52857 .4881 L
.5381 .4881 L
.54762 .4881 L
.55714 .4881 L
.56667 .4881 L
.57619 .4881 L
.58571 .4881 L
.59524 .4881 L
.60476 .4881 L
.61429 .4881 L
.62381 .4881 L
.63333 .4881 L
.64286 .4881 L
.65238 .4881 L
.6619 .4881 L
.67143 .4881 L
.68095 .4881 L
.69048 .4881 L
.7 .4881 L
.70952 .4881 L
.71905 .4881 L
.72857 .4881 L
.7381 .4881 L
.74762 .4881 L
.75714 .4881 L
.76667 .4881 L
.77619 .4881 L
.78571 .4881 L
.79524 .4881 L
.80476 .4881 L
.81429 .4881 L
.82381 .4881 L
.83333 .4881 L
.84286 .4881 L
.85238 .4881 L
.8619 .4881 L
.87143 .4881 L
.88095 .4881 L
.89048 .4881 L
.9 .4881 L
.90952 .4881 L
.91905 .4881 L
.92857 .4881 L
.9381 .4881 L
.94762 .4881 L
.95714 .4881 L
.96667 .4881 L
Mistroke
.97619 .4881 L
.97619 .4881 L
Mfstroke
.056 g
.66213 .34418 m
.66949 .34524 L
.67403 .34938 L
.67928 .34846 L
.6877 .35176 L
.68964 .34705 L
.69819 .3485 L
.69727 .34797 L
.68951 .34647 L
.68492 .33999 L
.68342 .33448 L
.6765 .33258 L
.67526 .32897 L
.66102 .32901 L
.66362 .33205 L
.66027 .33748 L
.66213 .34418 L
F
.63 g
.55295 .35498 m
.55123 .36071 L
.55335 .36248 L
.55551 .35807 L
.55295 .35498 L
F
.36 g
.5228 .34771 m
.5 .3448 L
.49414 .34281 L
.49687 .33492 L
.4899 .33386 L
.49039 .33192 L
.47707 .32597 L
.47707 .32319 L
.47707 .32218 L
.4873 .31614 L
.5 .30776 L
.51124 .30066 L
.53175 .31221 L
.52487 .31918 L
.52522 .32998 L
.51984 .33964 L
.5228 .34771 L
F
.871 g
.50463 .36243 m
.50397 .3627 L
.50392 .3627 L
.50463 .36243 L
F
.859 g
.53488 .23448 m
.53241 .23386 L
.53651 .21878 L
.53113 .20437 L
.53664 .20414 L
.56213 .20335 L
.5582 .20723 L
.5582 .21561 L
.56354 .21561 L
.56345 .22125 L
.55864 .22125 L
.55763 .23073 L
.54762 .22857 L
.54493 .23082 L
.54369 .23444 L
.53488 .23452 L
F
.585 g
.06221 .02509 m
.13307 .02522 L
.09793 .02707 L
.08541 .03536 L
.11927 .03651 L
.08704 .04096 L
.08285 .04603 L
.1045 .04427 L
.11499 .04683 L
.10758 .04863 L
.14158 .05295 L
.19832 .05467 L
.20203 .05198 L
.23382 .05062 L
.22703 .0552 L
.23761 .05525 L
.22685 .05754 L
.26349 .05794 L
.28783 .05683 L
.30441 .05498 L
.32121 .05732 L
.32138 .06129 L
.32147 .07262 L
.33867 .0806 L
.34996 .08188 L
.33889 .07478 L
.32668 .07169 L
.32747 .06847 L
.33765 .06332 L
.33933 .05326 L
.294 .04943 L
.2754 .04669 L
.29555 .04255 L
.28391 .04061 L
.29854 .03999 L
.2881 .03845 L
.30507 .03593 L
.3459 .03034 L
.41949 .03717 L
.40683 .04405 L
.46371 .05437 L
.45529 .05481 L
.46865 .06142 L
.48435 .06296 L
.48408 .06107 L
.5 .06085 L
.52297 .06464 L
.5619 .0634 L
.58986 .06878 L
.60181 .06481 L
.60873 .06874 L
.63448 .07235 L
.63748 .07544 L
.65022 .07262 L
.67729 .07068 L
.68426 .07072 L
.67989 .06424 L
.68889 .06142 L
.706 .06728 L
.70886 .06975 L
.73342 .07531 L
.73704 .07319 L
.76464 .07632 L
.78801 .07297 L
.8 .07615 L
.81155 .0728 L
.84224 .07266 L
.8582 .07535 L
.88457 .07271 L
.89162 .06905 L
.92068 .06667 L
.95185 .06041 L
.92923 .05203 L
.94255 .04202 L
.92328 .04118 L
.92116 .03862 L
.97619 .03065 L
.97619 .02113 L
.97619 .0119 L
.97619 .0119 L
.97619 .0119 L
.96667 .0119 L
.95714 .0119 L
.94762 .0119 L
.9381 .0119 L
.92857 .0119 L
.91905 .0119 L
.90952 .0119 L
.9 .0119 L
.89048 .0119 L
.88095 .0119 L
.87143 .0119 L
.8619 .0119 L
.85238 .0119 L
.84286 .0119 L
.83333 .0119 L
.82381 .0119 L
.81429 .0119 L
.80476 .0119 L
.79524 .0119 L
.78571 .0119 L
.77619 .0119 L
.76667 .0119 L
.75714 .0119 L
.74762 .0119 L
.7381 .0119 L
.72857 .0119 L
.71905 .0119 L
.70952 .0119 L
.7 .0119 L
.69048 .0119 L
.68095 .0119 L
.67143 .0119 L
.6619 .0119 L
.65238 .0119 L
.64286 .0119 L
.63333 .0119 L
.62381 .0119 L
.61429 .0119 L
.60476 .0119 L
.59524 .0119 L
.58571 .0119 L
.57619 .0119 L
.56667 .0119 L
.55714 .0119 L
.54762 .0119 L
.5381 .0119 L
.52857 .0119 L
.51905 .0119 L
.50952 .0119 L
.5 .0119 L
.49048 .0119 L
.48095 .0119 L
.47143 .0119 L
.4619 .0119 L
.45238 .0119 L
.44286 .0119 L
.43333 .0119 L
.42381 .0119 L
.41429 .0119 L
.40476 .0119 L
.39524 .0119 L
.38571 .0119 L
.37619 .0119 L
.36667 .0119 L
.35714 .0119 L
.34762 .0119 L
.3381 .0119 L
.32857 .0119 L
.31905 .0119 L
.30952 .0119 L
.3 .0119 L
.29048 .0119 L
.28095 .0119 L
.27143 .0119 L
.2619 .0119 L
.25238 .0119 L
.24286 .0119 L
.23333 .0119 L
.22381 .0119 L
.21429 .0119 L
.20476 .0119 L
.19524 .0119 L
.18571 .0119 L
.17619 .0119 L
.16667 .0119 L
.15714 .0119 L
.14762 .0119 L
.1381 .0119 L
.12857 .0119 L
.11905 .0119 L
.10952 .0119 L
.1 .0119 L
.09048 .0119 L
.08095 .0119 L
.07143 .0119 L
.0619 .0119 L
.05238 .0119 L
.04286 .0119 L
.03333 .0119 L
.02381 .0119 L
.02381 .0119 L
.02381 .02113 L
.02381 .03065 L
.06217 .02509 L
.06221 .02509 L
F
.24599 .05811 m
.22937 .05913 L
.23854 .06058 L
.24599 .05811 L
F
.3093 .05785 m
.31019 .06058 L
.29982 .06098 L
.31323 .0623 L
.30935 .06728 L
.31989 .06049 L
.3093 .05785 L
F
.30723 .04524 m
.30238 .04347 L
.28611 .04555 L
.30723 .04524 L
F
.34224 .03858 m
.34074 .03563 L
.32509 .03748 L
.34224 .03858 L
F
.743 g
.34603 .16415 m
.34519 .15886 L
.35009 .15238 L
.34572 .14819 L
.33496 .14735 L
.33519 .14202 L
.32769 .14193 L
.33179 .13726 L
.32813 .13713 L
.32646 .13091 L
.32121 .12831 L
.3261 .12465 L
.31742 .11768 L
.31896 .11142 L
.3097 .11248 L
.30534 .11896 L
.3119 .13219 L
.30917 .13814 L
.3153 .15944 L
.31332 .16715 L
.31927 .17844 L
.32227 .18964 L
.32478 .19237 L
.32985 .18951 L
.33086 .1918 L
.3343 .19118 L
.34722 .18338 L
.34497 .17773 L
.35295 .17782 L
.35556 .18236 L
.35767 .17822 L
.34753 .16997 L
.34603 .16415 L
F
.31847 .11071 m
.32769 .10542 L
.31843 .10507 L
.31843 .10481 L
.31847 .11071 L
F
.391 g
.6142 .35736 m
.61909 .35899 L
.62262 .35666 L
.62562 .3541 L
.62372 .35335 L
.62213 .35467 L
.61856 .35485 L
.6142 .35736 L
F
.357 g
.88263 .14859 m
.87976 .14718 L
.87134 .1496 L
.869 .15498 L
.8653 .15966 L
.86199 .15661 L
.86446 .16398 L
.85966 .15745 L
.85392 .16477 L
.84709 .16671 L
.83329 .16451 L
.8175 .16023 L
.81204 .15701 L
.80454 .15904 L
.80617 .16561 L
.79934 .18082 L
.8022 .18086 L
.8 .18607 L
.80168 .19228 L
.80904 .19577 L
.82019 .19832 L
.82522 .2067 L
.82743 .20269 L
.82703 .20732 L
.83135 .20877 L
.83338 .21323 L
.83708 .2131 L
.83818 .20873 L
.8399 .21093 L
.84444 .2093 L
.84312 .21327 L
.84656 .21781 L
.85101 .21777 L
.84916 .22037 L
.85904 .21746 L
.86239 .2172 L
.85833 .21036 L
.87063 .20313 L
.87491 .2097 L
.87601 .22081 L
.87857 .21772 L
.88038 .21195 L
.88457 .21041 L
.88699 .20004 L
.89361 .19643 L
.89586 .19034 L
.89894 .19039 L
.90454 .18307 L
.90639 .17385 L
.8974 .15547 L
.89581 .15022 L
.88721 .14643 L
.88263 .14859 L
F
.90485 .18183 m
.90547 .18466 L
.90485 .18183 L
F
.88563 .1358 m
.8828 .14237 L
.89246 .14162 L
.89149 .13576 L
.88563 .13585 L
F
.84638 .21843 m
.84493 .22037 L
.84771 .22011 L
.84638 .21843 L
F
.381 g
.52575 .37575 m
.53452 .37566 L
.5366 .37901 L
.54541 .37703 L
.54264 .37399 L
.53629 .3731 L
.52769 .37399 L
.5254 .37451 L
.52522 .37504 L
.52575 .37575 L
F
.929 g
.61856 .35485 m
.62213 .35467 L
.62372 .35335 L
.62213 .35273 L
.61856 .35485 L
F
.62562 .3541 m
.62262 .35666 L
.61909 .35899 L
.62447 .3578 L
.62249 .36063 L
.62659 .35904 L
.62853 .36067 L
.63333 .35644 L
.62932 .35172 L
.62734 .35476 L
.62562 .3541 L
F
.175 g
.6336 .3194 m
% vacuous filled polygon
newpath
.858 g
.74392 .30595 m
.74202 .31063 L
.73611 .31336 L
.73973 .30917 L
.73554 .30798 L
.73549 .31689 L
.73391 .32046 L
.7377 .31689 L
.74444 .31623 L
.74118 .31252 L
.74237 .31071 L
.74414 .31252 L
.74497 .30816 L
.74392 .30595 L
F
.894 g
.56217 .39272 m
.56698 .39325 L
.56966 .39691 L
.57434 .39819 L
.57932 .39771 L
.58391 .39206 L
.58369 .38774 L
.57231 .38646 L
.56243 .38633 L
.56217 .39272 L
F
.278 g
.50675 .38514 m
.50895 .38593 L
.51592 .3843 L
.51623 .38263 L
.51539 .38104 L
.50675 .38514 L
F
.65 g
.26645 .2989 m
.26477 .29206 L
.2642 .29713 L
.26645 .2989 L
F
.2 g
.50432 .26645 m
.50723 .26684 L
.50944 .28108 L
.50635 .28144 L
.50256 .2791 L
.50432 .26645 L
F
.179 g
.3287 .33549 m
% vacuous filled polygon
newpath
.854 g
.73523 .32227 m
.7381 .32491 L
.74246 .32346 L
.73523 .32227 L
F
.903 g
.31596 .22103 m
.31834 .21693 L
.31614 .2037 L
.32227 .18964 L
.32478 .19237 L
.32985 .18951 L
.33086 .1918 L
.3343 .19118 L
.33664 .19802 L
.34612 .19665 L
.34802 .20185 L
.34568 .20692 L
.34083 .20697 L
.34004 .21349 L
.32963 .21702 L
.3272 .22112 L
.3269 .22438 L
.31596 .22103 L
F
.856 g
.54929 .36243 m
.5433 .36689 L
.54259 .3679 L
.5422 .36949 L
.54885 .36918 L
.54974 .36874 L
.54929 .36243 L
F
.818 g
.56684 .20291 m
.55556 .20154 L
.55291 .1918 L
.55291 .18448 L
.55463 .17901 L
.56032 .18214 L
.5675 .1821 L
.57773 .19127 L
.56684 .20291 L
F
.419 g
.35882 .16076 m
.36433 .17059 L
.36623 .16944 L
.36226 .1649 L
.37103 .17451 L
.37103 .18294 L
.39162 .19184 L
.39647 .20322 L
.39687 .21371 L
.39705 .21631 L
.39907 .21631 L
.40758 .22791 L
.40631 .2362 L
.39418 .24246 L
.38153 .24127 L
.38201 .24537 L
.37615 .2481 L
.37055 .24528 L
.36856 .2429 L
.36927 .24528 L
.36583 .24528 L
.36548 .24757 L
.36054 .24577 L
.36803 .25309 L
.36327 .26067 L
.36049 .25617 L
.35551 .25617 L
.35062 .25516 L
.34325 .25366 L
.34215 .2616 L
.33933 .26376 L
.33726 .26129 L
.33364 .25944 L
.32857 .26133 L
.33228 .25569 L
.3231 .25322 L
.31521 .25454 L
.31715 .25172 L
.31468 .25154 L
.31495 .23884 L
.30714 .23642 L
.30419 .23007 L
.30635 .22513 L
.31345 .22504 L
.31314 .22086 L
.31596 .22103 L
.3269 .22438 L
.3272 .22112 L
.32963 .21702 L
.34004 .21349 L
.34083 .20697 L
.34568 .20692 L
.34802 .20185 L
.34612 .19665 L
.3466 .19158 L
.35225 .19105 L
.35344 .1866 L
.35648 .18638 L
.35556 .18236 L
.35767 .17822 L
.34753 .16997 L
.3578 .16521 L
.35882 .16076 L
F
.37196 .24929 m
.36671 .24515 L
.36618 .24947 L
.37196 .24929 L
F
.703 g
.80181 .26213 m
.80428 .26287 L
.80428 .26292 L
.80181 .26213 L
F
.80463 .26296 m
.80432 .26274 L
.80463 .26296 L
F
.8 g
.57562 .36574 m
.57412 .36107 L
.56971 .36036 L
.56067 .35939 L
.56001 .36702 L
.57562 .36574 L
F
.188 g
.4929 .27509 m
.48541 .2776 L
.48951 .28571 L
.5 .28968 L
.50062 .28968 L
.50635 .28148 L
.50256 .2791 L
.49956 .27945 L
.4925 .2791 L
.4929 .27509 L
F
.059 g
.76124 .27738 m
.75855 .29383 L
.75631 .29616 L
.75309 .2922 L
.74934 .29224 L
.7489 .30128 L
.74392 .30591 L
.74497 .30816 L
.75168 .32041 L
.75697 .32165 L
.75754 .32465 L
.75966 .32443 L
.76116 .31843 L
.75802 .31332 L
.76164 .31376 L
.76759 .30705 L
.76477 .30384 L
.76759 .30705 L
.76477 .30384 L
.75754 .29907 L
.76173 .29334 L
.75974 .28995 L
.76367 .28131 L
.76124 .27738 L
F
.832 g
.57676 .24272 m
.57782 .23823 L
.58086 .24365 L
.57676 .24272 L
F
.941 g
.54101 .26993 m
.54916 .27125 L
.56023 .27897 L
.56054 .27888 L
.56221 .27306 L
.57262 .26327 L
.55908 .26093 L
.55079 .26314 L
.54929 .25922 L
.54387 .25922 L
.54286 .25586 L
.53814 .26601 L
.54101 .26993 L
F
.603 g
.53183 .23673 m
.53228 .2347 L
.53461 .23774 L
.53183 .23673 L
F
.316 g
.77632 .27756 m
.77227 .28078 L
.77072 .28585 L
.77835 .28796 L
.78452 .28889 L
.78452 .28267 L
.78003 .28086 L
.77632 .27756 L
F
.44 g
.52597 .25622 m
.52579 .26093 L
.52275 .26274 L
.52593 .26799 L
.53144 .26874 L
.53876 .2806 L
.53721 .28461 L
.54149 .27641 L
.5369 .27549 L
.54101 .26993 L
.53814 .26601 L
.54286 .25586 L
.53519 .25573 L
.52998 .25573 L
.52597 .25622 L
F
.584 g
.17531 .37963 m
.19039 .37963 L
.19303 .37963 L
.22487 .37963 L
.24286 .37963 L
.26301 .37698 L
.27743 .3731 L
.28197 .3638 L
.28135 .36257 L
.28122 .36027 L
.29123 .36354 L
.29083 .36402 L
.29083 .36446 L
.29947 .36768 L
.30595 .36909 L
.31085 .36909 L
.31195 .36984 L
.31684 .37557 L
.32222 .36953 L
.32615 .36975 L
.3287 .37191 L
.32822 .36997 L
.33236 .37002 L
.32491 .3675 L
.32681 .36499 L
.33871 .36975 L
.3362 .37138 L
.33135 .37125 L
.32888 .37628 L
.32315 .37698 L
.33011 .37831 L
.32685 .38034 L
.31138 .37368 L
.31552 .37729 L
.31199 .37813 L
.31565 .37734 L
.32945 .38311 L
.34092 .3828 L
.35287 .38814 L
.35247 .3907 L
.34647 .39347 L
.34017 .39092 L
.34559 .39347 L
.34828 .3944 L
.33946 .3955 L
.33545 .40004 L
.32848 .4097 L
.32522 .40428 L
.32011 .40498 L
.31649 .40282 L
.31958 .40489 L
.31208 .40891 L
.31649 .41111 L
.3093 .41332 L
.29339 .4149 L
.29215 .40507 L
.2974 .40141 L
.29594 .39722 L
.28898 .39458 L
.29012 .38417 L
.28338 .38805 L
.28228 .3959 L
.27403 .39546 L
.26499 .40035 L
.25428 .40053 L
.25053 .40472 L
.24921 .41005 L
.26023 .41684 L
.2519 .4198 L
.26724 .4198 L
.26975 .42257 L
.25794 .42447 L
.26878 .4228 L
.27857 .42509 L
.27456 .42703 L
.28439 .42725 L
.28483 .43302 L
.27363 .43483 L
.26971 .42791 L
.26468 .43316 L
.26124 .43051 L
.25419 .4343 L
.24982 .44048 L
.24462 .43554 L
.253 .43157 L
.24744 .42892 L
.24652 .42615 L
.24555 .42919 L
.24114 .43135 L
.24286 .42888 L
.22954 .42906 L
.219 .43236 L
.2131 .43038 L
.2205 .43157 L
.21627 .42553 L
.20877 .42989 L
.1955 .42937 L
.19581 .43219 L
.17108 .43347 L
.1705 .43558 L
.16817 .43338 L
.16138 .43673 L
.15397 .43347 L
.14691 .43223 L
.15697 .43589 L
.14802 .43377 L
.14242 .43161 L
.12694 .43426 L
.12698 .40952 L
.14162 .4082 L
.15604 .39793 L
.15595 .39255 L
.15882 .39167 L
.16049 .38854 L
.16473 .38854 L
.16168 .38668 L
.16195 .38536 L
.1698 .3847 L
.17526 .37959 L
F
.15168 .39317 m
.14894 .39087 L
.14797 .3933 L
.15168 .39317 L
F
.16279 .38413 m
.17315 .37778 L
.16274 .38413 L
F
.18325 .44586 m
.19493 .4444 L
.17513 .43805 L
.16667 .44039 L
.16989 .44665 L
.1832 .44586 L
F
.19683 .44206 m
.2127 .44184 L
.21468 .43942 L
.21407 .44405 L
.22169 .44149 L
.23289 .43558 L
.22778 .43201 L
.21803 .43386 L
.20022 .43113 L
.18933 .43519 L
.20507 .43607 L
.18898 .43677 L
.19559 .43924 L
.18492 .43964 L
.18955 .4429 L
.19683 .44206 L
F
.28038 .42174 m
.2858 .41786 L
.27451 .41698 L
.26936 .41821 L
.2735 .42438 L
.28038 .42174 L
F
.22359 .44453 m
.22147 .44272 L
.21684 .4444 L
.22359 .44453 L
F
.24109 .43488 m
.24727 .43166 L
.23695 .43223 L
.24109 .43488 L
F
.35287 .38655 m
.3496 .38108 L
.35348 .37972 L
.35851 .38038 L
.35802 .37571 L
.36023 .37725 L
.35957 .37341 L
.35648 .37672 L
.35348 .37399 L
.35247 .37685 L
.34312 .37597 L
.34286 .37676 L
.347 .38183 L
.35287 .38651 L
F
.34043 .37394 m
.33823 .3709 L
.3418 .37152 L
.33726 .37152 L
.34043 .37394 L
F
.32213 .43064 m
.33792 .42628 L
.33188 .42165 L
.32976 .42553 L
.31869 .4254 L
.32174 .42337 L
.32901 .4164 L
.31746 .41865 L
.32522 .41367 L
.31111 .4168 L
.30106 .4205 L
.29365 .42041 L
.29515 .42319 L
.30057 .42121 L
.3056 .42315 L
.31151 .42447 L
.31689 .4261 L
.30692 .42659 L
.29722 .43175 L
.29096 .43699 L
.28585 .43444 L
.26742 .4358 L
.26305 .43805 L
.26186 .44017 L
.27209 .44541 L
.27037 .43779 L
.27332 .44286 L
.28316 .44506 L
.2858 .44017 L
.29612 .44246 L
.30137 .43832 L
.30586 .43779 L
.30974 .43933 L
.30789 .43686 L
.31076 .43523 L
.31517 .43752 L
.31746 .43519 L
.31473 .43395 L
.32337 .43342 L
.3164 .43219 L
.32213 .43064 L
F
.24846 .44581 m
.26138 .4455 L
.25115 .44043 L
.24846 .44581 L
F
.18611 .45467 m
.19339 .45287 L
.18166 .45053 L
.17451 .45128 L
.18611 .45467 L
F
.22566 .45992 m
.23761 .45591 L
.22271 .45728 L
.22566 .45992 L
F
.23444 .45273 m
.24175 .44872 L
.22809 .44987 L
.23051 .45225 L
.23444 .45273 L
F
.223 g
.56349 .30159 m
.54233 .31217 L
.53968 .31085 L
.54233 .30384 L
.54096 .29471 L
.53607 .28629 L
.53721 .28461 L
.54149 .27641 L
.5369 .27549 L
.54101 .26993 L
.54916 .27125 L
.56023 .27897 L
.55776 .28386 L
.56067 .29114 L
.56349 .29153 L
.56349 .30159 L
F
.387 g
.31376 .20146 m
.31098 .16362 L
.30507 .15123 L
.30873 .14052 L
.30794 .13228 L
.30494 .1269 L
.30379 .12884 L
.29974 .12663 L
.30287 .12619 L
.30631 .12302 L
.30251 .12297 L
.30238 .1172 L
.30542 .1123 L
.30829 .11301 L
.30569 .10979 L
.31093 .11076 L
.30631 .10917 L
.31186 .11019 L
.30917 .10877 L
.31896 .11142 L
.3097 .11248 L
.30534 .11896 L
.3119 .13219 L
.30917 .13814 L
.3153 .15944 L
.31332 .16715 L
.31927 .17844 L
.32227 .18964 L
.31614 .2037 L
.31376 .20146 L
F
.32262 .10423 m
.31914 .10463 L
.32262 .10423 L
F
.31905 .10459 m
.31989 .1026 L
.31473 .10406 L
.31909 .10459 L
F
.31843 .10481 m
.30948 .10578 L
.31746 .10591 L
.31371 .11041 L
.31847 .11071 L
.31843 .10481 L
F
.3045 .13523 m
.30556 .13929 L
.3045 .13523 L
F
.265 g
.82901 .35608 m
.82059 .35243 L
.82244 .35582 L
.8224 .35842 L
.81711 .35578 L
.8116 .35128 L
.81464 .34881 L
.8246 .34894 L
.81556 .34277 L
.82249 .33395 L
.81645 .33558 L
.82244 .33192 L
.81786 .32989 L
.8231 .32906 L
.81861 .322 L
.81508 .31918 L
.81001 .31248 L
.80234 .30891 L
.8 .31111 L
.8004 .30869 L
.79533 .30692 L
.79193 .3067 L
.79078 .30353 L
.79061 .30481 L
.79087 .30683 L
.78567 .30701 L
.78602 .30675 L
.77914 .31133 L
.77019 .30926 L
.76759 .30705 L
.76164 .31376 L
.75802 .31332 L
.76116 .31843 L
.75966 .32443 L
.75754 .32465 L
.75419 .32795 L
.74246 .32346 L
.7381 .32491 L
.73523 .32227 L
.7332 .32372 L
.71433 .32989 L
.70741 .33607 L
.71032 .33638 L
.70873 .33986 L
.71217 .34286 L
.70586 .34392 L
.69727 .34797 L
.69815 .3485 L
.69577 .35595 L
.71235 .36124 L
.71129 .36878 L
.71843 .3694 L
.71966 .37491 L
.72668 .37487 L
.73104 .37989 L
.73236 .38007 L
.74048 .37421 L
.73995 .36989 L
.75238 .36711 L
.75498 .36305 L
.75498 .3631 L
.7784 .36041 L
.79136 .36283 L
.79621 .36561 L
.7963 .36931 L
.8172 .37346 L
.81332 .37698 L
.80578 .37668 L
.80877 .38183 L
.81543 .38232 L
.81755 .38959 L
.82284 .39131 L
.83232 .39034 L
.83739 .38175 L
.84568 .37928 L
.84652 .37619 L
.85644 .37769 L
.85216 .36936 L
.84643 .36861 L
.8455 .36221 L
.82901 .35608 L
F
.78986 .30287 m
.79352 .30282 L
.79242 .29969 L
.78752 .29894 L
.7899 .30287 L
F
.726 g
.31133 .28135 m
.30194 .27945 L
.29696 .27094 L
.29533 .27293 L
.29396 .26914 L
.29621 .26036 L
.29149 .25379 L
.30084 .24974 L
.30705 .24356 L
.31455 .24303 L
.31292 .23999 L
.31495 .23884 L
.31468 .25154 L
.31715 .25172 L
.31521 .25454 L
.3231 .25322 L
.3205 .25736 L
.32156 .2664 L
.30952 .26856 L
.30586 .27429 L
.31133 .28135 L
F
.328 g
.52954 .23955 m
.53183 .23673 L
.53461 .23774 L
.54206 .23964 L
.54929 .25922 L
.54387 .25922 L
.54286 .25586 L
.53519 .25573 L
.53483 .25326 L
.53836 .25247 L
.53823 .24497 L
.53064 .24383 L
.52954 .23955 L
F
.109 g
.2787 .27888 m
.28157 .27531 L
.28069 .27125 L
.27337 .27619 L
.27332 .27928 L
.2787 .27888 L
F
.615 g
.48007 .26151 m
.4918 .26345 L
.4918 .26345 L
.4929 .27509 L
.4929 .27509 L
.48541 .27765 L
.48541 .2776 L
.47892 .2769 L
.47892 .2769 L
.4776 .27002 L
.4776 .27002 L
.48011 .26151 L
F
.526 g
.54934 .36208 m
.53854 .36984 L
.53699 .37037 L
.54158 .37116 L
.54374 .37328 L
.54727 .37108 L
.54987 .37147 L
.54974 .36874 L
.54885 .36918 L
.5422 .36949 L
.54259 .3679 L
.5433 .36689 L
.54929 .36243 L
.54934 .36208 L
F
.149 g
.27535 .30798 m
.28536 .31142 L
.2955 .30754 L
.30388 .3034 L
.29506 .30331 L
.28338 .31001 L
.27535 .30798 L
F
.255 g
.59149 .34436 m
.58739 .34145 L
.58536 .34277 L
.59149 .34436 L
F
.712 g
.54369 .37743 m
.547 .38073 L
.55057 .38197 L
.53924 .38457 L
.53201 .38311 L
.5366 .37901 L
.54369 .37743 L
F
.669 g
.52293 .39524 m
.52152 .39969 L
.52632 .40093 L
.52183 .40031 L
.52791 .40273 L
.525 .39502 L
.52293 .39528 L
F
.331 g
.61451 .28047 m
.61248 .28051 L
.61407 .28364 L
.61049 .28047 L
.61362 .2791 L
.61451 .28047 L
F
.836 g
.31014 .30212 m
.31927 .29921 L
.3101 .29775 L
.31014 .30212 L
F
.009 g
.28748 .24109 m
.28898 .24466 L
.28593 .24387 L
.28593 .24727 L
.29149 .25379 L
.30084 .24974 L
.29092 .23677 L
.28708 .23827 L
.28748 .24109 L
F
.869 g
.59422 .3112 m
.58554 .32831 L
.59061 .32337 L
.5925 .32817 L
.59233 .328 L
.59065 .33258 L
.59052 .33289 L
.56653 .33373 L
.56614 .3082 L
.58977 .30754 L
.59422 .3112 L
F
.144 g
.26764 .28554 m
.26164 .28638 L
.26362 .28818 L
.26764 .28554 L
F
.778 g
.52593 .25265 m
.52597 .25622 L
.52998 .25573 L
.53003 .25265 L
.52593 .25265 L
F
.177 g
.59647 .28801 m
.59788 .29515 L
.60216 .29771 L
.60507 .2899 L
.61407 .28364 L
.61287 .28258 L
.60273 .28871 L
.59647 .28801 L
F
.928 g
.57416 .40736 m
.57302 .40295 L
.56376 .40309 L
.56208 .40666 L
.57416 .40736 L
F
.54 g
.59647 .28801 m
.60273 .28871 L
.61287 .28258 L
.61049 .28047 L
.61362 .2791 L
.61645 .27381 L
.62694 .27116 L
.61892 .26296 L
.61085 .26054 L
.60454 .25908 L
.59506 .26221 L
.58726 .27099 L
.5907 .27791 L
.59563 .2836 L
.59647 .28801 L
F
.462 g
.33854 .11239 m
.34334 .11402 L
.33854 .11239 L
F
.34202 .11213 m
.34727 .11323 L
.34202 .11213 L
F
.737 g
.97046 .20406 m
.97275 .20238 L
.9709 .20168 L
F
.344 g
.56393 .42412 m
.56733 .42183 L
.55582 .41605 L
.55666 .41027 L
.56054 .4082 L
.57372 .41023 L
.58355 .41645 L
.57676 .43263 L
.57663 .43267 L
.57381 .43541 L
.56812 .4325 L
.5545 .43267 L
.56393 .42412 L
F
.318 g
.51993 .36583 m
.51966 .36574 L
.51958 .3657 L
.51027 .36521 L
.50851 .36226 L
.50463 .36243 L
.50397 .3627 L
.49533 .36481 L
.49705 .37253 L
.48735 .37835 L
.49643 .37866 L
.49489 .38157 L
.5 .38051 L
.50675 .38514 L
.51539 .38104 L
.51684 .38086 L
.52178 .37954 L
.52006 .37588 L
.51578 .37227 L
.51861 .37152 L
.51993 .36583 L
F
.075 g
.3567 .26415 m
.35996 .26442 L
.36327 .26067 L
.36049 .25617 L
.35551 .25617 L
.3567 .26415 L
F
.472 g
.52593 .25265 m
.52306 .24832 L
.52954 .23955 L
.53064 .24383 L
.53823 .24497 L
.53836 .25247 L
.53483 .25326 L
.53519 .25573 L
.52998 .25573 L
.53003 .25265 L
.52593 .25265 L
F
.618 g
.45617 .28593 m
.45952 .28558 L
.45569 .28448 L
.45569 .28457 L
.46349 .28541 L
.45617 .28593 L
F
.989 g
.60582 .36477 m
.61627 .36301 L
.62249 .36063 L
.62447 .3578 L
.61909 .35899 L
.6142 .35736 L
.60988 .35983 L
.60582 .36477 L
F
.966 g
.51905 .39083 m
.52601 .39162 L
.52293 .39528 L
.525 .39502 L
.525 .39506 L
.52884 .39272 L
.53774 .39215 L
.53765 .39268 L
.53924 .38457 L
.53201 .38311 L
.5366 .37901 L
.53452 .37566 L
.52575 .37575 L
.52531 .37575 L
.52006 .37588 L
.52178 .37954 L
.51684 .38086 L
.51623 .38263 L
.51592 .38426 L
.51905 .39083 L
F
.857 g
.4918 .26345 m
.5 .26486 L
.50317 .26614 L
.5 .27804 L
.49978 .27831 L
.5 .27937 L
.4996 .27945 L
.4925 .2791 L
.4929 .27509 L
.4918 .26345 L
F
.093 g
.4858 .34568 m
.48576 .34563 L
.4858 .34563 L
F
.84 g
.56887 .35776 m
.5627 .35772 L
.55974 .35705 L
.55957 .35278 L
.56367 .35106 L
.5601 .34938 L
.56138 .34638 L
.55582 .35013 L
.55877 .35101 L
.56146 .35093 L
.55392 .35392 L
.55295 .35498 L
.55551 .35807 L
.56067 .35939 L
.56975 .36036 L
.56887 .35776 L
F
.711 g
.40525 .42496 m
.41407 .43153 L
.428 .43131 L
.44101 .43519 L
.42275 .43624 L
.43276 .43854 L
.42434 .44083 L
.44295 .43642 L
.43241 .44153 L
.42738 .44431 L
.44577 .44431 L
.44149 .44731 L
.44978 .44705 L
.44065 .44885 L
.44885 .44947 L
.44056 .45326 L
.45207 .45357 L
.44171 .45551 L
.45736 .46296 L
.44378 .46314 L
.46786 .46587 L
.43527 .46305 L
.44101 .46715 L
.43325 .46693 L
.41362 .46609 L
.44361 .46852 L
.40613 .46892 L
.4321 .47033 L
.41265 .47121 L
.3765 .46962 L
.39444 .46869 L
.37897 .46896 L
.38192 .46627 L
.36808 .46592 L
.34502 .4672 L
.35066 .46517 L
.34092 .46675 L
.32593 .45935 L
.30785 .45767 L
.32522 .45503 L
.3112 .45384 L
.31878 .45128 L
.34105 .4511 L
.35212 .43964 L
.35829 .4414 L
.36645 .43655 L
.35547 .4369 L
.36715 .43523 L
.35877 .43078 L
.36733 .42972 L
.35785 .42866 L
.36517 .42963 L
.3575 .42787 L
.36675 .42769 L
.35723 .42743 L
.35851 .42487 L
.36772 .4272 L
.35855 .42456 L
.36627 .42385 L
.36093 .4228 L
.36243 .41984 L
.36772 .4216 L
.36649 .41768 L
.3724 .41089 L
.38038 .4119 L
.38064 .40891 L
.38598 .40899 L
.38765 .41332 L
.38585 .41601 L
.39123 .42227 L
.40525 .42496 L
F
.35635 .43602 m
.36287 .43422 L
.35829 .43316 L
.35635 .43602 L
F
.145 g
.26477 .29206 m
.26662 .29158 L
.26362 .28818 L
.26164 .28638 L
.25595 .28849 L
.25732 .2925 L
.26076 .29259 L
.2593 .29713 L
.2642 .29713 L
.26477 .29206 L
F
.423 g
.46481 .2739 m
.46027 .27897 L
.46371 .28355 L
.46997 .28298 L
.46993 .2828 L
.47623 .2828 L
.47888 .27685 L
.47892 .2769 L
.4776 .27002 L
.47284 .27244 L
.47033 .27646 L
.46481 .2739 L
F
.508 g
.45578 .28258 m
.46032 .28166 L
.45899 .27998 L
.46027 .27897 L
.46371 .28355 L
.45578 .28258 L
F
.875 g
.34854 .26451 m
.34475 .26689 L
.34528 .26949 L
.34131 .27257 L
.33761 .26574 L
.33933 .26376 L
.34215 .2616 L
.34325 .25366 L
.35062 .25516 L
.34643 .26058 L
.34854 .26451 L
F
.136 g
.31014 .29771 m
.30295 .29877 L
.3086 .29903 L
.30569 .30225 L
.31019 .30212 L
.31014 .29771 L
F
.554 g
.26662 .29158 m
.28007 .28968 L
.26905 .28435 L
.26764 .28554 L
.26362 .28818 L
.26662 .29158 L
F
.365 g
.56058 .37685 m
.5586 .37809 L
.54541 .37703 L
.54264 .37399 L
.54727 .37108 L
.55362 .372 L
.56058 .37685 L
F
.097 g
.44347 .41892 m
.43638 .4216 L
.44259 .42315 L
.4351 .42328 L
.43884 .42575 L
.44422 .4224 L
.45723 .42601 L
.46393 .42319 L
.45194 .4179 L
.44347 .41892 L
F
.958 g
.73554 .30798 m
.73254 .3093 L
.72862 .30287 L
.71239 .29153 L
.71124 .27954 L
.71019 .27421 L
.70362 .27222 L
.69392 .29369 L
.6929 .30891 L
.69078 .30608 L
.68713 .30481 L
.68241 .30899 L
.68651 .31111 L
.68042 .31287 L
.6881 .31459 L
.68391 .32143 L
.69021 .32399 L
.69757 .33219 L
.69943 .33541 L
.69563 .34167 L
.70586 .34392 L
.71217 .34286 L
.70873 .33986 L
.71032 .33638 L
.70741 .33607 L
.71437 .32989 L
.71182 .32628 L
.71896 .32275 L
.73104 .31971 L
.7332 .32372 L
.73523 .32227 L
.74246 .32346 L
.75419 .32795 L
.75754 .32465 L
.75697 .32165 L
.75168 .32041 L
.74497 .30816 L
.74414 .31252 L
.74237 .31071 L
.74118 .31252 L
.74444 .31623 L
.7377 .31689 L
.73391 .32046 L
.73549 .31689 L
.73554 .30798 L
F
.626 g
.75194 .26473 m
.75798 .26389 L
.77231 .25185 L
.77099 .25066 L
.77443 .25075 L
.77615 .24727 L
.77654 .24268 L
.78064 .24145 L
.77985 .23457 L
.7769 .2343 L
.76878 .24149 L
.75194 .26473 L
F
.76243 .24533 m
.7616 .24757 L
.76243 .24533 L
F
.78011 .24608 m
.78179 .2418 L
.77813 .24453 L
.78016 .24603 L
F
.79008 .25547 m
.78867 .24868 L
.79162 .24211 L
.79594 .24056 L
.80326 .23893 L
.80688 .24061 L
.80745 .24528 L
.8119 .25295 L
.81486 .2526 L
.80961 .25952 L
.81107 .26102 L
.80653 .26155 L
.80392 .25547 L
.7925 .25225 L
.79008 .25547 L
F
.79074 .22928 m
.80309 .22676 L
.80273 .22937 L
.79369 .23298 L
.78316 .23435 L
.77835 .2321 L
.79074 .22928 L
F
.79877 .23175 m
.80194 .23161 L
.79881 .23175 L
F
.80287 .22857 m
.80613 .22778 L
.80287 .22862 L
F
.80776 .22826 m
.80692 .22641 L
.8078 .22826 L
F
.8101 .22782 m
.81481 .22782 L
.80966 .22588 L
.8101 .22782 L
F
.8149 .22504 m
.81962 .22359 L
.8149 .22504 L
F
.81817 .22813 m
.8254 .22817 L
.82015 .22632 L
.8172 .22654 L
.81821 .22813 L
F
.82928 .22848 m
.83104 .22795 L
.82928 .22848 L
F
.83095 .22496 m
.83677 .22778 L
.83108 .22716 L
.82663 .22257 L
.83095 .22496 L
F
.84828 .23117 m
.84691 .22879 L
.84828 .23117 L
F
.81636 .23514 m
.8142 .2418 L
.81755 .2519 L
.83135 .25397 L
.8287 .25097 L
.81812 .25093 L
.81922 .2463 L
.82659 .24797 L
.8209 .24524 L
.82513 .23836 L
.82152 .23836 L
.81949 .24308 L
.81839 .2384 L
.81764 .23523 L
F
.82685 .24656 m
.82487 .24616 L
.82685 .24652 L
F
.82914 .24563 m
.83153 .24502 L
.82914 .24563 L
F
.83179 .24528 m
.83426 .24519 L
.83179 .24528 L
F
.82465 .23779 m
.8235 .23576 L
.82465 .23779 L
F
.82562 .23836 m
.82491 .23496 L
.82557 .23836 L
F
.83369 .24175 m
.83664 .24109 L
.83369 .24175 L
F
.83911 .24242 m
.84546 .24171 L
.84612 .23977 L
.8384 .24056 L
.83911 .24242 L
F
.85586 .23563 m
.85538 .23351 L
.85586 .23563 L
F
.84101 .25053 m
.8384 .25053 L
.83977 .24757 L
.83748 .2511 L
.83876 .25582 L
.83765 .25243 L
.84101 .25053 L
F
.86653 .23047 m
.86746 .22862 L
.86415 .22769 L
.86658 .23047 L
F
.87302 .22584 m
.87077 .22914 L
.8675 .22804 L
.86526 .23571 L
.85441 .23981 L
.85414 .24224 L
.85159 .2392 L
.84907 .24264 L
.85432 .24444 L
.84643 .24621 L
.85035 .24907 L
.85511 .24621 L
.85745 .24109 L
.86468 .24612 L
.87302 .24312 L
.87302 .24312 L
.87302 .22584 L
F
.824 g
.66301 .31667 m
.65287 .31781 L
.64211 .32063 L
.63263 .32923 L
.6284 .32928 L
.62011 .33986 L
.62262 .34471 L
.61852 .34832 L
.61852 .35489 L
.62213 .35273 L
.62734 .35476 L
.62932 .35172 L
.63519 .34718 L
.64259 .34881 L
.65132 .35128 L
.65758 .34846 L
.66213 .34418 L
.66027 .33748 L
.66362 .33205 L
.66102 .32901 L
.66755 .32178 L
.66301 .31667 L
F
.635 g
.62685 .32941 m
.6284 .32928 L
.62011 .33986 L
.62262 .34471 L
.61852 .34832 L
.61204 .34815 L
.60847 .34105 L
.60265 .33827 L
.60397 .33527 L
.6183 .32725 L
.62315 .32698 L
.62685 .32941 L
F
.221 g
.48342 .39308 m
.48316 .38805 L
.47416 .38611 L
.47231 .38805 L
.4769 .38933 L
.47324 .39312 L
.48082 .39563 L
.47844 .394 L
.48342 .39308 L
F
.282 g
.59052 .33289 m
.59286 .33757 L
.594 .33792 L
.59422 .33796 L
.59436 .33796 L
.59431 .33646 L
.59387 .33333 L
.5925 .32817 L
.59233 .328 L
.59065 .33258 L
.59052 .33289 L
F
.507 g
.53629 .37063 m
.53245 .37024 L
.53276 .36698 L
.54899 .35617 L
.54396 .35608 L
.5425 .35031 L
.54145 .35591 L
.52937 .36217 L
.52672 .36645 L
.51993 .36583 L
.51861 .37152 L
.52769 .37403 L
.53629 .3731 L
.53629 .37063 L
F
.54131 .35119 m
.5399 .34696 L
.53285 .35 L
.54131 .35119 L
F
.52447 .35913 m
.52341 .35287 L
.52152 .35776 L
.52447 .35913 L
F
.56 g
.29268 .29832 m
% vacuous filled polygon
newpath
.749 g
.84828 .33585 m
.8466 .33981 L
.84281 .33823 L
.84568 .33201 L
.84828 .33585 L
F
.85608 .34017 m
.8519 .33651 L
.84925 .33818 L
.85608 .34012 L
F
.87337 .35961 m
.87584 .35463 L
.87125 .34295 L
.86733 .34153 L
.86204 .34281 L
.85917 .33845 L
.85802 .34184 L
.84625 .33977 L
.85207 .34414 L
.86182 .34881 L
.86653 .34885 L
.87337 .35961 L
F
.87553 .37041 m
.88034 .36667 L
.88576 .36473 L
.87892 .36089 L
.8716 .36261 L
.87354 .36058 L
.87046 .35966 L
.87407 .36451 L
.87557 .37037 L
F
.83937 .32108 m
.8377 .319 L
.83937 .32103 L
F
.664 g
.5925 .32769 m
.59255 .32817 L
.59387 .33333 L
.59431 .33646 L
.60265 .33832 L
.60397 .33527 L
.59788 .33333 L
.59921 .32937 L
.5925 .32769 L
F
.517 g
.6302 .37266 m
.63545 .37465 L
.64065 .37244 L
.64087 .36993 L
.63642 .36777 L
.63285 .3679 L
.63977 .36032 L
.64815 .35979 L
.64815 .36905 L
.6552 .37037 L
.66446 .36508 L
.67967 .35922 L
.68386 .35935 L
.68787 .3619 L
.69669 .36429 L
.70701 .36323 L
.71235 .36124 L
.71129 .36878 L
.71843 .3694 L
.71966 .37491 L
.72668 .37487 L
.73104 .37989 L
.73232 .37998 L
.72099 .38347 L
.71023 .38607 L
.7045 .39383 L
.69713 .39228 L
.68686 .39586 L
.66292 .39312 L
.66107 .38435 L
.64317 .38523 L
.6351 .38655 L
.62394 .38073 L
.6302 .37266 L
F
.594 g
.60996 .24559 m
.6037 .23765 L
.58973 .24735 L
.59268 .25507 L
.58995 .26116 L
.59506 .26221 L
.60454 .25908 L
.61089 .26054 L
.60842 .2575 L
.60996 .24559 L
F
.892 g
.62809 .32553 m
.62685 .32941 L
.62315 .32698 L
.62809 .32553 L
F
.571 g
.69621 .35459 m
.6892 .35379 L
.68404 .35564 L
.69312 .35829 L
.68845 .35877 L
.68787 .3619 L
.69669 .36429 L
.70701 .36323 L
.71235 .36124 L
.69577 .35595 L
.69621 .35459 L
F
.678 g
.76477 .30384 m
.76759 .30705 L
.77019 .30926 L
.77293 .30516 L
.77685 .30467 L
.77482 .30106 L
.7843 .29255 L
.78452 .28889 L
.77835 .28796 L
.77703 .2963 L
.77354 .29877 L
.76698 .29647 L
.76795 .30176 L
.76477 .30384 L
F
.882 g
.56376 .40309 m
.57302 .40295 L
.57434 .39819 L
.56966 .39691 L
.56521 .39916 L
.55644 .39828 L
.55666 .40132 L
.56455 .40141 L
.56376 .40309 L
F
.747 g
.59515 .34167 m
.59286 .33757 L
.594 .33792 L
.59422 .33796 L
.59515 .34167 L
F
.148 g
.46958 .26834 m
.48007 .26151 L
.4776 .27002 L
.47284 .27244 L
.46958 .26834 L
F
.169 g
.53051 .33774 m
.54211 .33285 L
.55115 .33011 L
.55745 .33717 L
.56653 .33373 L
.56614 .3082 L
.56614 .3082 L
.56614 .30291 L
.56349 .30159 L
.54233 .31217 L
.53959 .3108 L
.53175 .31221 L
.52487 .31918 L
.52522 .32998 L
.53051 .33774 L
F
.008 g
.5254 .37451 m
.52522 .37509 L
.52522 .37504 L
.5254 .37451 L
F
.612 g
.55644 .39828 m
.56521 .39916 L
.56966 .39691 L
.56698 .39325 L
.56217 .39272 L
.56036 .39295 L
.56054 .39489 L
.55631 .39638 L
.55644 .39828 L
F
.594 g
.51623 .38263 m
.51684 .38086 L
.51539 .38108 L
.51623 .38263 L
F
.804 g
.55432 .36049 m
.55617 .36168 L
.56045 .36173 L
.56067 .35935 L
.55551 .35807 L
.55432 .36049 L
F
.911 g
.61459 .19215 m
.61777 .19722 L
.61764 .20719 L
.62698 .21093 L
.63038 .21839 L
.6336 .20948 L
.63131 .20886 L
.62469 .18391 L
.61658 .18399 L
.61459 .19215 L
F
.653 g
.58726 .22491 m
.59083 .22425 L
.59246 .2194 L
.59145 .21468 L
.59502 .21063 L
.59334 .20467 L
.59136 .21142 L
.58787 .21292 L
.58726 .22491 L
F
.969 g
.79008 .25547 m
.7925 .25225 L
.80392 .25547 L
.80653 .26155 L
.81111 .26102 L
.81556 .26415 L
.81076 .26552 L
.80992 .26852 L
.80463 .26296 L
.80432 .26274 L
.80428 .26287 L
.80181 .26213 L
.79484 .2571 L
.79466 .25357 L
.79008 .25547 L
F
.7649 .26698 m
.76795 .2575 L
.77385 .25335 L
.77593 .25384 L
.77368 .2627 L
.77011 .26649 L
.76759 .2649 L
.7649 .26698 L
F
.98 g
.51124 .30066 m
.5 .30776 L
.4873 .31614 L
.48258 .31614 L
.48545 .29101 L
.46958 .2914 L
.46812 .28898 L
.46759 .28907 L
.46997 .28298 L
.46993 .2828 L
.47623 .2828 L
.47892 .2769 L
.48541 .2776 L
.48951 .28571 L
.5 .28968 L
.50062 .28968 L
.51027 .29158 L
.51124 .30066 L
F
.276 g
.45489 .30494 m
.45714 .30348 L
.45626 .29246 L
.46459 .29242 L
.46812 .28893 L
.46958 .2914 L
.48545 .29101 L
.48258 .31614 L
.4873 .31614 L
.47707 .32222 L
.47707 .31878 L
.46825 .31878 L
.46534 .31058 L
.46561 .30644 L
.45489 .30494 L
F
.432 g
.24303 .31869 m
.24105 .30979 L
.24638 .29951 L
.25877 .29938 L
.25829 .29991 L
.26102 .30564 L
.26953 .30719 L
.2664 .2989 L
.2642 .29713 L
.2593 .29713 L
.26076 .29259 L
.25732 .2925 L
.25595 .28849 L
.25454 .2899 L
.25595 .28849 L
.24903 .29347 L
.24131 .29224 L
.22623 .2985 L
.22103 .30269 L
.22033 .30961 L
.21058 .31781 L
.20326 .32663 L
.20084 .33263 L
.19568 .33452 L
.20141 .32482 L
.21027 .3112 L
.20344 .31543 L
.19572 .32337 L
.19824 .32544 L
.19017 .33607 L
.19652 .33655 L
.21151 .33289 L
.21821 .33408 L
.22474 .3276 L
.23325 .32747 L
.23787 .31984 L
.24303 .31869 L
F
.687 g
.57055 .37765 m
.57482 .37738 L
.5784 .37394 L
.57451 .37028 L
.57055 .37765 L
F
.473 g
.51971 .36574 m
.51953 .36565 L
.51953 .3657 L
.51966 .36574 L
F
.716 g
.73241 .38007 m
.74048 .37421 L
.73995 .36989 L
.75238 .36711 L
.75498 .36305 L
.77844 .36041 L
.79136 .36283 L
.79621 .36561 L
.7963 .36931 L
.8172 .37346 L
.81332 .37698 L
.80578 .37668 L
.80877 .38183 L
.78717 .38051 L
.77332 .3828 L
.76173 .38796 L
.7575 .38157 L
.7444 .38457 L
.73241 .38007 L
F
.683 g
.49418 .34286 m
.48567 .34502 L
.48351 .34264 L
.47544 .33611 L
.47293 .32756 L
.46512 .32319 L
.47707 .32319 L
.47707 .32597 L
.49039 .33192 L
.4899 .33386 L
.49687 .33492 L
.49418 .34286 L
F
.023 g
.60697 .22227 m
.60758 .20957 L
.59145 .1981 L
.59392 .18624 L
.58682 .18228 L
.58704 .17897 L
.58501 .17901 L
.58457 .18135 L
.5828 .1907 L
.58739 .197 L
.58726 .20578 L
.58047 .20864 L
.58787 .21292 L
.59136 .21142 L
.59334 .20467 L
.59502 .21063 L
.59145 .21468 L
.59246 .2194 L
.60697 .22227 L
F
.956 g
.53113 .20437 m
.53845 .18999 L
.53823 .1888 L
.54361 .17438 L
.55291 .17478 L
.55291 .18448 L
.55291 .1918 L
.55556 .20154 L
.56684 .20291 L
.56213 .20335 L
.53664 .20414 L
.53113 .20437 L
F
.122 g
.71433 .32989 m
.7332 .32372 L
.73104 .31971 L
.71896 .32275 L
.71182 .32628 L
.71433 .32989 L
F
.791 g
.50891 .38589 m
.51252 .39012 L
.51909 .39087 L
.51592 .38426 L
.50891 .38589 L
F
.451 g
.96036 .13973 m
.95692 .14286 L
.95362 .13955 L
.94109 .12773 L
.95181 .12862 L
.95101 .13161 L
.95556 .13386 L
.95225 .13545 L
.95701 .13554 L
.96036 .13973 L
F
.96808 .14502 m
.96358 .1399 L
.96389 .14365 L
.95979 .14572 L
.96283 .15194 L
.95688 .15895 L
.96561 .15044 L
.97235 .15026 L
.96808 .14502 L
F
.278 g
.28007 .28968 m
.2787 .27888 L
.27332 .27928 L
.26896 .2843 L
.28007 .28968 L
F
.24 g
.53959 .3108 m
.5317 .31221 L
.51124 .30066 L
.51027 .29158 L
.50062 .28968 L
.50635 .28148 L
.50944 .28108 L
.50952 .28095 L
.51292 .28646 L
.52549 .28386 L
.53607 .28629 L
.54096 .29471 L
.54233 .30384 L
.53959 .3108 L
F
.043 g
.52271 .2627 m
.51614 .26129 L
.51398 .26561 L
.50719 .26684 L
.50944 .28108 L
.50952 .28095 L
.51292 .28646 L
.52549 .28386 L
.53607 .28629 L
.53726 .28457 L
.53876 .2806 L
.53144 .26874 L
.52593 .26799 L
.52271 .2627 L
F
.303 g
.83959 .35216 m
.8373 .35507 L
.84572 .3619 L
.8455 .36221 L
.82901 .35608 L
.83241 .3522 L
.82981 .35084 L
.83519 .35009 L
.83959 .35216 L
F
.109 g
.58144 .43461 m
.58219 .43593 L
.57698 .43748 L
.57315 .43814 L
.56711 .43774 L
.54788 .43338 L
.53488 .42637 L
.52526 .41869 L
.53029 .41874 L
.51821 .41645 L
.51345 .41451 L
.51803 .41367 L
.51376 .41164 L
.52037 .41199 L
.51371 .41045 L
.51878 .41005 L
.51371 .40741 L
.51746 .40362 L
.52795 .40842 L
.53025 .40604 L
.5321 .41821 L
.55445 .43267 L
.56812 .4325 L
.57381 .43541 L
.57663 .43267 L
.57676 .43263 L
.58161 .43466 L
F
.56574 .46257 m
.56327 .45948 L
.54705 .46199 L
.56574 .46257 L
F
.52826 .46041 m
.53439 .45688 L
.54577 .45745 L
.53593 .45648 L
.54325 .45256 L
.55701 .45838 L
.54312 .46182 L
.54352 .45873 L
.52826 .46041 L
F
.232 g
.64048 .294 m
.65291 .30018 L
.6582 .30877 L
.64974 .31481 L
.64771 .31129 L
.64991 .3082 L
.63752 .30026 L
.64048 .294 L
F
.432 g
.66301 .31667 m
.67646 .31645 L
.68042 .31287 L
.6881 .31459 L
.68391 .32143 L
.69021 .32399 L
.69757 .33219 L
.69943 .33541 L
.69563 .34167 L
.70586 .34392 L
.69727 .34797 L
.68951 .34647 L
.68492 .33999 L
.68342 .33448 L
.6765 .33258 L
.67526 .32897 L
.66102 .32901 L
.66755 .32178 L
.66301 .31667 L
F
.709 g
.28157 .27531 m
.28827 .27451 L
.2888 .27478 L
.29533 .27297 L
.29396 .26914 L
.29334 .27262 L
.28959 .27363 L
.28942 .2735 L
.28721 .26918 L
.28069 .27125 L
.28157 .27531 L
F
.304 g
.87302 .24312 m
.89017 .23417 L
.88937 .23025 L
.89916 .22293 L
.89078 .22328 L
.88232 .23016 L
.87601 .22822 L
.87919 .2261 L
.87302 .22584 L
.87302 .24312 L
F
.9026 .23902 m
.89956 .23399 L
.8925 .23549 L
.89929 .23549 L
.9026 .23902 L
F
.322 g
.35556 .18236 m
.35295 .17782 L
.34497 .17773 L
.34722 .18338 L
.33426 .19118 L
.33664 .19802 L
.34612 .19665 L
.3466 .19158 L
.35225 .19105 L
.35344 .1866 L
.35648 .18638 L
.35556 .18236 L
F
.778 g
.31376 .20146 m
.29819 .21252 L
.29162 .22729 L
.28523 .23413 L
.28748 .24109 L
.28708 .23827 L
.29092 .23677 L
.30084 .24974 L
.30705 .24356 L
.31455 .24303 L
.31292 .23999 L
.31495 .23884 L
.30714 .23642 L
.30419 .23007 L
.30635 .22513 L
.31345 .22504 L
.31314 .22086 L
.31596 .22103 L
.31834 .21693 L
.31614 .2037 L
.31376 .20146 L
F
.74 g
.8235 .29868 m
.82112 .29043 L
.82262 .28699 L
.82787 .28646 L
.82826 .2832 L
.82416 .28695 L
.82434 .28483 L
.81914 .28651 L
.81689 .29317 L
.81905 .29903 L
.82354 .29868 L
F
.8261 .28329 m
.82822 .28104 L
.8261 .28329 L
F
.81843 .28576 m
.82156 .2847 L
.82041 .28236 L
.81847 .28576 L
F
.83188 .27593 m
.83496 .26922 L
.83386 .26658 L
.83245 .26918 L
.83175 .26477 L
.8272 .27068 L
.82244 .26878 L
.82646 .27306 L
.8272 .27108 L
.83205 .27381 L
.83188 .27597 L
F
.82919 .27672 m
.82751 .27579 L
.82923 .27672 L
F
.82681 .27879 m
.82597 .27407 L
.82381 .27601 L
.82681 .27879 L
F
.82284 .28148 m
.82584 .28034 L
.82257 .2776 L
.82284 .28148 L
F
.81618 .2802 m
.81671 .27778 L
.81001 .27205 L
.81618 .28016 L
F
.324 g
.53765 .39268 m
.5519 .39409 L
.56217 .39272 L
.56243 .38629 L
.55966 .37985 L
.53924 .38457 L
.53765 .39268 L
F
.046 g
.48038 .34837 m
.47641 .34837 L
.47487 .35243 L
.47685 .36102 L
.48364 .36001 L
.48038 .34837 L
F
.346 g
.32205 .29863 m
% vacuous filled polygon
newpath
.053 g
.63549 .31512 m
.63558 .31918 L
.63448 .31548 L
.63549 .31512 L
F
.851 g
.57848 .36962 m
.57562 .36574 L
.56001 .36698 L
.55362 .372 L
.56058 .37685 L
.57055 .37765 L
.57451 .37028 L
.57848 .36962 L
F
.33 g
.97619 .43097 m
.96592 .43488 L
.95119 .43466 L
.95137 .43188 L
.92972 .4343 L
.92606 .43131 L
.9213 .43735 L
.90353 .43726 L
.89224 .44131 L
.88329 .43959 L
.88871 .44131 L
.88849 .4414 L
.87209 .44286 L
.87046 .43907 L
.8466 .43713 L
.81384 .44462 L
.80022 .44444 L
.80057 .44211 L
.79444 .44541 L
.77795 .44255 L
.80084 .44947 L
.79392 .45304 L
.77531 .45564 L
.7705 .45207 L
.76142 .45238 L
.76504 .44885 L
.76138 .45176 L
.72716 .44766 L
.72959 .44308 L
.72959 .4455 L
.71301 .44462 L
.72002 .43541 L
.72028 .43973 L
.70772 .44153 L
.70172 .43937 L
.70754 .43752 L
.69974 .43933 L
.69841 .44281 L
.69621 .43629 L
.69524 .43289 L
.70538 .43228 L
.70913 .42875 L
.70251 .4325 L
.69048 .42518 L
.68245 .42672 L
.69352 .42914 L
.69268 .44233 L
.6825 .44224 L
.67623 .43796 L
.68161 .43073 L
.67209 .43325 L
.6578 .43078 L
.64078 .43219 L
.62584 .4269 L
.61883 .42817 L
.62169 .43113 L
.61675 .42976 L
.61689 .42425 L
.60542 .42359 L
.60714 .42072 L
.59749 .42244 L
.59929 .41883 L
.59347 .42019 L
.59193 .42077 L
.59039 .42513 L
.58435 .42769 L
.60044 .42482 L
.60944 .42778 L
.58144 .43461 L
.58161 .43466 L
.57676 .43263 L
.58355 .41645 L
.57368 .41023 L
.58003 .40864 L
.57416 .40736 L
.57302 .40295 L
.57434 .39819 L
.57932 .39771 L
.58391 .39206 L
.58369 .38774 L
.58964 .38673 L
.60467 .381 L
.60564 .37641 L
.60123 .37465 L
.60419 .37465 L
.59982 .37346 L
.60203 .37178 L
.59678 .36953 L
.60582 .36477 L
.61627 .36301 L
.62249 .36063 L
.62659 .35904 L
.62853 .36067 L
.6235 .36777 L
.6302 .37266 L
.62394 .38073 L
.6351 .38655 L
.64317 .38523 L
.66107 .38435 L
.66292 .39312 L
.68686 .39586 L
.69713 .39228 L
.7045 .39383 L
.71023 .38607 L
.72099 .38347 L
.73104 .37989 L
.73241 .38007 L
.7444 .38457 L
.7575 .38157 L
.76173 .38796 L
.77332 .3828 L
.78717 .38051 L
.80877 .38183 L
.81543 .38232 L
.81755 .38959 L
.82284 .39131 L
.83232 .39034 L
.83739 .38175 L
.84568 .37928 L
.84652 .37619 L
.85644 .37769 L
.85216 .36936 L
.84643 .36861 L
.8455 .36221 L
.84577 .36186 L
.84577 .36186 L
.84577 .36186 L
.84872 .36464 L
.8575 .36508 L
.87086 .37817 L
.87412 .39096 L
.86971 .39369 L
.86327 .39162 L
.86437 .39369 L
.85772 .39533 L
.8772 .4067 L
.89581 .40811 L
.9045 .40582 L
.91054 .40653 L
.90802 .40842 L
.91662 .41349 L
.92425 .4134 L
.92363 .41027 L
.92707 .41173 L
.93192 .41548 L
.93823 .41521 L
.91257 .39991 L
.91442 .38461 L
.92888 .39489 L
.93214 .39868 L
.9284 .40362 L
.93289 .40882 L
.94766 .41036 L
.9504 .40851 L
.96821 .41631 L
.97381 .41477 L
.97138 .4205 L
.96146 .42112 L
.97482 .42147 L
.97619 .42309 L
.97619 .42309 L
.97619 .42309 L
.97619 .43097 L
F
.02381 .42309 m
.02597 .42571 L
.04184 .41997 L
.04272 .42381 L
.05101 .42496 L
.04052 .4276 L
.03845 .4254 L
.02381 .43097 L
.02381 .43097 L
.02381 .42309 L
.02381 .42309 L
F
.55631 .39638 m
.56054 .39489 L
.56036 .39295 L
.55194 .39409 L
.55622 .39537 L
.55631 .39638 L
F
.87522 .39061 m
.87588 .37138 L
.87994 .37266 L
.87897 .38064 L
.88294 .37866 L
.87835 .39321 L
.87522 .39061 L
F
.91067 .38241 m
.91287 .38435 L
.91067 .38241 L
F
.87341 .44546 m
.87959 .44396 L
.87346 .44546 L
F
.88757 .44996 m
.89934 .44877 L
.88757 .44996 L
F
.86993 .44788 m
.88016 .44824 L
.88466 .44978 L
.86702 .45163 L
.86221 .44912 L
.87055 .44793 L
F
.76314 .45622 m
.77875 .45767 L
.77081 .46014 L
.7631 .45622 L
F
.76314 .45966 m
.75802 .46208 L
.74563 .46045 L
.7631 .45966 L
F
.63598 .4399 m
.64224 .44392 L
.64965 .44356 L
.65247 .43713 L
.63598 .43995 L
F
.65075 .44757 m
.64299 .44409 L
.68122 .45357 L
.65071 .44757 L
F
.664 g
.57831 .24634 m
.57676 .24272 L
.58086 .24365 L
.58064 .24718 L
.57831 .24634 L
F
.03 g
.5328 .36618 m
.5328 .36618 L
% vacuous filled polygon
newpath
.895 g
.5925 .32769 m
.59145 .32429 L
.60366 .30582 L
.61318 .29334 L
.61772 .29603 L
.62059 .28995 L
.63752 .30026 L
.64991 .3082 L
.64771 .31129 L
.64506 .30996 L
.63536 .31305 L
.63549 .31512 L
.63448 .31548 L
.62809 .32553 L
.62315 .32698 L
.6183 .32725 L
.60397 .33527 L
.59788 .33333 L
.59921 .32937 L
.5925 .32769 L
F
.208 g
.45626 .2925 m
.45362 .28902 L
.45617 .28593 L
.46349 .28541 L
.45569 .28457 L
.4593 .28395 L
.45578 .28258 L
.46371 .28355 L
.46997 .28298 L
.46759 .28907 L
.46812 .28893 L
.46459 .29242 L
.45626 .29246 L
F
.873 g
.54934 .36208 m
.54929 .36243 L
.54974 .36874 L
.54987 .37147 L
.55362 .372 L
.56001 .36698 L
.56045 .36173 L
.55617 .36168 L
.55432 .36049 L
.55335 .36248 L
.55123 .36071 L
.54934 .36208 L
F
.579 g
.46481 .2739 m
.46962 .26834 L
.47288 .27244 L
.47033 .27646 L
.46481 .2739 L
F
.617 g
.77509 .25366 m
.77509 .25366 L
% vacuous filled polygon
newpath
.969 g
.55966 .37985 m
.55057 .38197 L
.547 .38073 L
.54369 .37743 L
.54541 .37703 L
.5586 .37809 L
.55966 .37985 L
F
.83 g
.53699 .37037 m
.53629 .37063 L
.53629 .3731 L
.54264 .37399 L
.54374 .37328 L
.54158 .37116 L
.53699 .37037 L
F
.276 g
.60992 .24559 m
.62685 .26182 L
.63602 .27765 L
.63435 .28175 L
.61883 .27756 L
.61451 .28047 L
.61442 .28038 L
.61362 .2791 L
.61645 .27381 L
.62694 .27116 L
.61892 .26296 L
.61085 .26054 L
.60842 .2575 L
.60992 .24559 L
F
.508 g
.54361 .17438 m
.54846 .15961 L
.55291 .15789 L
.57381 .16261 L
.58704 .17897 L
.58501 .17901 L
.58153 .1791 L
.58457 .18131 L
.5828 .1907 L
.57769 .19131 L
.5675 .1821 L
.56032 .18214 L
.55463 .17901 L
.55291 .18448 L
.55291 .17478 L
.54361 .17438 L
F
.737 g
.57593 .17429 m
.57147 .1716 L
.57434 .16887 L
.57791 .17235 L
.57593 .17429 L
F
.398 g
.83519 .35009 m
.8347 .3407 L
.84242 .34387 L
.83959 .35216 L
.83519 .35009 L
F
.568 g
.50851 .36226 m
.5 .35569 L
.49969 .353 L
.5 .35216 L
.49436 .34718 L
.4858 .34563 L
.48038 .34837 L
.48364 .36001 L
.47685 .36102 L
.47544 .36393 L
.4791 .36583 L
.49533 .36481 L
.50392 .3627 L
.50463 .36243 L
.50851 .36226 L
F
.204 g
.71111 .27011 m
.71287 .2657 L
.71662 .26927 L
.71142 .27584 L
.71327 .275 L
.71111 .27011 L
F
.415 g
.60216 .29771 m
.59762 .30829 L
.59422 .3112 L
.58977 .30754 L
.56614 .3082 L
.56614 .30291 L
.56349 .30159 L
.56349 .29153 L
.56067 .29114 L
.55776 .28386 L
.56023 .27897 L
.56054 .27888 L
.56221 .27306 L
.57262 .26327 L
.58166 .25922 L
.58995 .26116 L
.59506 .26221 L
.58726 .27099 L
.5907 .27791 L
.59563 .2836 L
.59788 .29515 L
.60216 .29771 L
F
.619 g
.3567 .26415 m
.34854 .26451 L
.34643 .26058 L
.35062 .25516 L
.35556 .25617 L
.3567 .26415 L
F
.828 g
.58501 .17901 m
.58457 .18135 L
.58153 .1791 L
.58501 .17901 L
F
.879 g
.53025 .40604 m
.53519 .39638 L
.54193 .39837 L
.54281 .40511 L
.54872 .40644 L
.54237 .40741 L
.55049 .40802 L
.54586 .4153 L
.56393 .42412 L
.5545 .43267 L
.5321 .41821 L
.53025 .40604 L
F
.369 g
.51861 .37152 m
.52769 .37403 L
.5254 .37451 L
.52522 .37509 L
.52531 .37575 L
.52006 .37588 L
.51578 .37227 L
.51861 .37152 L
F
.273 g
.59502 .34506 m
.59515 .34167 L
.59436 .33796 L
.59431 .33646 L
.60265 .33832 L
.60847 .34105 L
.61204 .34819 L
.597 .34744 L
.59502 .34506 L
F
.775 g
.82086 .31645 m
.82275 .31614 L
.81936 .30802 L
.81777 .31248 L
.82086 .31645 L
F
.028 g
.67928 .34841 m
.68047 .35062 L
.67879 .35445 L
.68408 .3575 L
.68404 .35564 L
.6892 .35379 L
.69621 .35459 L
.69815 .3485 L
.68964 .34705 L
.6877 .35176 L
.67928 .34841 L
F
.039 g
.60697 .22227 m
.6026 .23399 L
.6037 .23765 L
.58973 .24735 L
.58064 .24718 L
.58086 .24365 L
.57782 .23823 L
.58139 .22835 L
.58726 .22509 L
.59083 .22425 L
.5925 .2194 L
.60697 .22227 L
F
.61 g
.77227 .28078 m
.76684 .28347 L
.76526 .28576 L
.7623 .27743 L
.76565 .26896 L
.77011 .26649 L
.76759 .2649 L
.7649 .26698 L
.76001 .27174 L
.76124 .27738 L
.76367 .28131 L
.75974 .28995 L
.76173 .29334 L
.75754 .29907 L
.76477 .30384 L
.76795 .30176 L
.76698 .29647 L
.77354 .29877 L
.77703 .2963 L
.77835 .28796 L
.77072 .28585 L
.77227 .28078 L
F
.744 g
.50317 .26614 m
.50437 .26645 L
.50243 .2791 L
.49956 .27945 L
.5 .27937 L
.49978 .27831 L
.5 .27804 L
.50317 .26614 L
F
.133 g
.5228 .34771 m
.52923 .3481 L
.52646 .34039 L
.53051 .33774 L
.52522 .32998 L
.51984 .33964 L
.5228 .34771 L
F
.831 g
.59502 .34506 m
.59528 .34771 L
.58677 .34528 L
.57853 .34555 L
.5724 .34705 L
.57496 .34797 L
.5694 .35123 L
.57187 .35172 L
.56918 .35569 L
.57835 .35895 L
.59246 .36138 L
.60988 .35983 L
.61856 .35485 L
.61852 .34832 L
.61204 .34815 L
.597 .34744 L
.59502 .34506 L
F
.56887 .35776 m
.56927 .35595 L
.57668 .35847 L
.57412 .36107 L
.56971 .36036 L
.56887 .35776 L
F
.737 g
.63977 .36032 m
.64489 .35855 L
.63946 .35701 L
.64259 .34881 L
.65132 .35128 L
.65758 .34846 L
.66213 .34418 L
.66949 .34524 L
.67403 .34938 L
.66817 .35344 L
.6597 .35952 L
.6552 .36332 L
.64815 .35979 L
.63977 .36032 L
F
.165 g
.63549 .31512 m
.64317 .31384 L
.64912 .3198 L
.64974 .31481 L
.64771 .31129 L
.64506 .30996 L
.63536 .31305 L
.63549 .31512 L
F
.516 g
.48677 .40511 m
.49202 .40511 L
.48876 .40212 L
.49519 .40238 L
.49026 .39819 L
.5 .39224 L
.50035 .39175 L
.5 .39162 L
.50467 .38884 L
.50101 .38611 L
.50062 .38422 L
.48699 .38382 L
.49369 .3869 L
.48862 .38668 L
.48752 .38981 L
.49277 .39109 L
.49202 .39546 L
.48642 .39511 L
.48695 .39885 L
.48461 .3963 L
.48677 .40511 L
F
.48082 .39568 m
.48347 .39308 L
.48342 .39312 L
.47844 .394 L
.48082 .39568 L
F
.862 g
.19017 .33607 m
.18973 .3373 L
.18091 .34145 L
.17597 .34925 L
.17879 .35057 L
.17275 .353 L
.17147 .36111 L
.17178 .37244 L
.17006 .37804 L
.17526 .37743 L
.17443 .37465 L
.17526 .37959 L
.17531 .37963 L
.19039 .37963 L
.19303 .37963 L
.22487 .37963 L
.24286 .37963 L
.26301 .37698 L
.27743 .3731 L
.28197 .3638 L
.28135 .36257 L
.28122 .36027 L
.29123 .36354 L
.29083 .36402 L
.29083 .36446 L
.29947 .36768 L
.30595 .36909 L
.31085 .36909 L
.31195 .36984 L
.31684 .37557 L
.32222 .36953 L
.31283 .36393 L
.31265 .3634 L
.31186 .35983 L
.31182 .35979 L
.31186 .35983 L
.30992 .3593 L
.30516 .35847 L
.30357 .35719 L
.30198 .35304 L
.3015 .35582 L
.30044 .35529 L
.3015 .35172 L
.30062 .35057 L
.29907 .34824 L
.29987 .35044 L
.29832 .3519 L
.29938 .35472 L
.2981 .35066 L
.29625 .35265 L
.29612 .35291 L
.29594 .35097 L
.29824 .3481 L
.29555 .34872 L
.29934 .34669 L
.30022 .34466 L
.29912 .34713 L
.297 .34511 L
.2996 .34422 L
.29616 .344 L
.29806 .34228 L
.2922 .33959 L
.28602 .3347 L
.28439 .33126 L
.28827 .32086 L
.28549 .31645 L
.27862 .32914 L
.26847 .33011 L
.26614 .33038 L
.26318 .32985 L
.26076 .32976 L
.26358 .3295 L
.26345 .32654 L
.25185 .32937 L
.2519 .32932 L
.24202 .32372 L
.24303 .31869 L
.23787 .31984 L
.23325 .32747 L
.22474 .3276 L
.21821 .33408 L
.21151 .33289 L
.19652 .33655 L
.19017 .33607 L
F
.15608 .39793 m
.15428 .39489 L
.1534 .39841 L
.15009 .39749 L
.14198 .40732 L
.14246 .40397 L
.13095 .40886 L
.10922 .41213 L
.1041 .40833 L
.09793 .40683 L
.10516 .4127 L
.09405 .40534 L
.08086 .39815 L
.0679 .39497 L
.0836 .40212 L
.08523 .40648 L
.07632 .40578 L
.07099 .40516 L
.07174 .41058 L
.06702 .4082 L
.06733 .41111 L
.06345 .41257 L
.06032 .41292 L
.06504 .41724 L
.07368 .41803 L
.07412 .42178 L
.0552 .42368 L
.06539 .42619 L
.07196 .42456 L
.07015 .42712 L
.0761 .42566 L
.05864 .43082 L
.07213 .43571 L
.08607 .43889 L
.12694 .43426 L
.12698 .40952 L
.14162 .4082 L
.15604 .39793 L
F
.08779 .30362 m
.09048 .30168 L
.08818 .30004 L
.08779 .30362 L
F
.09453 .40344 m
.097 .40194 L
.09048 .40172 L
.09453 .40344 L
F
.907 g
.58166 .25922 m
.5828 .2556 L
.57831 .24634 L
.58064 .24718 L
.58973 .24735 L
.59268 .25507 L
.58995 .26116 L
.58166 .25922 L
F
.889 g
.56243 .38633 m
.57231 .38646 L
.58369 .38774 L
.58964 .38673 L
.60467 .381 L
.60564 .37641 L
.60123 .37465 L
.59797 .37399 L
.59211 .37218 L
.59621 .36914 L
.58898 .36755 L
.58593 .37011 L
.58933 .37152 L
.58413 .37244 L
.58399 .375 L
.57848 .36962 L
.57451 .37028 L
.5784 .37394 L
.57482 .37738 L
.57055 .37765 L
.56058 .37685 L
.5586 .37809 L
.55966 .37985 L
.56243 .38633 L
F
.008 g
.35882 .16071 m
.347 .15873 L
.34603 .16415 L
.34753 .17002 L
.3578 .16521 L
.35882 .16071 L
F
.125 g
.64815 .35979 m
.64815 .36905 L
.6552 .37037 L
.66446 .36508 L
.67967 .35922 L
.68386 .35935 L
.68787 .3619 L
.68845 .35877 L
.69312 .35829 L
.68404 .35564 L
.68408 .3575 L
.67879 .35445 L
.68047 .35062 L
.67928 .34841 L
.67403 .34938 L
.66817 .35344 L
.6597 .35952 L
.6552 .36332 L
.64815 .35979 L
F
.509 g
.34131 .27257 m
.33699 .27266 L
.33902 .27496 L
.33329 .27672 L
.33638 .27844 L
.32782 .27654 L
.31931 .27826 L
.31477 .28228 L
.31534 .28025 L
.31063 .27857 L
.31049 .27394 L
.31133 .28135 L
.30586 .27429 L
.30952 .26856 L
.32156 .2664 L
.3205 .25736 L
.3231 .25322 L
.33228 .25569 L
.32857 .26133 L
.33364 .25944 L
.33726 .26129 L
.33933 .26376 L
.33761 .26574 L
.34131 .27257 L
F
.321 g
.77632 .27743 m
.77738 .27266 L
.77994 .27646 L
.78188 .27535 L
.78902 .281 L
.78823 .29034 L
.78197 .29647 L
.77985 .30185 L
.78567 .30701 L
.78602 .30675 L
.77914 .31133 L
.77019 .30926 L
.77293 .30516 L
.77685 .30467 L
.77482 .30106 L
.7843 .29255 L
.78452 .28889 L
.78452 .28267 L
.78003 .28086 L
.77632 .27743 L
F
.804 g
.46512 .32319 m
.45489 .30494 L
.46561 .30644 L
.46534 .31058 L
.46825 .31878 L
.47707 .31878 L
.47707 .32222 L
.47707 .32319 L
.46512 .32319 L
F
.71 g
.61772 .29603 m
.61318 .29339 L
.61521 .2836 L
.62884 .28713 L
.64043 .294 L
.63752 .30026 L
.62059 .28995 L
.61772 .29603 L
F
.89 g
.53488 .23448 m
.53228 .2347 L
.53466 .23774 L
.54206 .23964 L
.54929 .25922 L
.55079 .26314 L
.55908 .26093 L
.57262 .26327 L
.58166 .25922 L
.5828 .2556 L
.57831 .24634 L
.57681 .24277 L
.57782 .23823 L
.58139 .22835 L
.57504 .22549 L
.57504 .21944 L
.57884 .21786 L
.57884 .21442 L
.57196 .2194 L
.56345 .22125 L
.55864 .22125 L
.55763 .23073 L
.54762 .22857 L
.54493 .23082 L
.54369 .23444 L
.53488 .23448 L
F
.493 g
.58139 .22835 m
.57504 .22549 L
.57504 .21944 L
.57884 .21786 L
.57884 .21442 L
.57196 .2194 L
.56345 .22125 L
.56354 .21561 L
.5582 .21561 L
.5582 .20723 L
.56213 .20335 L
.56684 .20291 L
.57183 .20291 L
.58047 .20864 L
.58787 .21292 L
.58726 .22491 L
.58726 .22509 L
.58139 .22831 L
F
.924 g
.5828 .1907 m
.57769 .19131 L
.56684 .20291 L
.57183 .20291 L
.58047 .20864 L
.58726 .20578 L
.58739 .197 L
.5828 .1907 L
F
0 g
.97619 .4881 m
.97619 .4881 L
.97619 .47857 L
.97619 .46905 L
.97619 .45952 L
.97619 .45 L
.97619 .44048 L
.97619 .43095 L
.97619 .42143 L
.97619 .4119 L
.97619 .40238 L
.97619 .39286 L
.97619 .38333 L
.97619 .37381 L
.97619 .36429 L
.97619 .35476 L
.97619 .34524 L
.97619 .33571 L
.97619 .32619 L
.97619 .31667 L
.97619 .30714 L
.97619 .29762 L
.97619 .2881 L
.97619 .27857 L
.97619 .26905 L
.97619 .25952 L
.97619 .25 L
.97619 .24048 L
.97619 .23095 L
.97619 .22143 L
.97619 .2119 L
.97619 .20238 L
.97619 .19286 L
.97619 .18333 L
.97619 .17381 L
.97619 .16429 L
.97619 .15476 L
.97619 .14524 L
.97619 .13571 L
.97619 .12619 L
.97619 .11667 L
.97619 .10714 L
.97619 .09762 L
.97619 .0881 L
.97619 .07857 L
.97619 .06905 L
.97619 .05952 L
.97619 .05 L
.97619 .04048 L
.97619 .03095 L
Mistroke
.97619 .02143 L
.97619 .0119 L
Mfstroke
.97619 .0119 m
.97619 .0119 L
.96667 .0119 L
.95714 .0119 L
.94762 .0119 L
.9381 .0119 L
.92857 .0119 L
.91905 .0119 L
.90952 .0119 L
.9 .0119 L
.89048 .0119 L
.88095 .0119 L
.87143 .0119 L
.8619 .0119 L
.85238 .0119 L
.84286 .0119 L
.83333 .0119 L
.82381 .0119 L
.81429 .0119 L
.80476 .0119 L
.79524 .0119 L
.78571 .0119 L
.77619 .0119 L
.76667 .0119 L
.75714 .0119 L
.74762 .0119 L
.7381 .0119 L
.72857 .0119 L
.71905 .0119 L
.70952 .0119 L
.7 .0119 L
.69048 .0119 L
.68095 .0119 L
.67143 .0119 L
.6619 .0119 L
.65238 .0119 L
.64286 .0119 L
.63333 .0119 L
.62381 .0119 L
.61429 .0119 L
.60476 .0119 L
.59524 .0119 L
.58571 .0119 L
.57619 .0119 L
.56667 .0119 L
.55714 .0119 L
.54762 .0119 L
.5381 .0119 L
.52857 .0119 L
.51905 .0119 L
Mistroke
.50952 .0119 L
.5 .0119 L
.49048 .0119 L
.48095 .0119 L
.47143 .0119 L
.4619 .0119 L
.45238 .0119 L
.44286 .0119 L
.43333 .0119 L
.42381 .0119 L
.41429 .0119 L
.40476 .0119 L
.39524 .0119 L
.38571 .0119 L
.37619 .0119 L
.36667 .0119 L
.35714 .0119 L
.34762 .0119 L
.3381 .0119 L
.32857 .0119 L
.31905 .0119 L
.30952 .0119 L
.3 .0119 L
.29048 .0119 L
.28095 .0119 L
.27143 .0119 L
.2619 .0119 L
.25238 .0119 L
.24286 .0119 L
.23333 .0119 L
.22381 .0119 L
.21429 .0119 L
.20476 .0119 L
.19524 .0119 L
.18571 .0119 L
.17619 .0119 L
.16667 .0119 L
.15714 .0119 L
.14762 .0119 L
.1381 .0119 L
.12857 .0119 L
.11905 .0119 L
.10952 .0119 L
.1 .0119 L
.09048 .0119 L
.08095 .0119 L
.07143 .0119 L
.0619 .0119 L
.05238 .0119 L
.04286 .0119 L
Mistroke
.03333 .0119 L
.02381 .0119 L
Mfstroke
.02381 .0119 m
.02381 .02143 L
.02381 .03095 L
.02381 .04048 L
.02381 .05 L
.02381 .05952 L
.02381 .06905 L
.02381 .07857 L
.02381 .0881 L
.02381 .09762 L
.02381 .10714 L
.02381 .11667 L
.02381 .12619 L
.02381 .13571 L
.02381 .14524 L
.02381 .15476 L
.02381 .16429 L
.02381 .17381 L
.02381 .18333 L
.02381 .19286 L
.02381 .20238 L
.02381 .2119 L
.02381 .22143 L
.02381 .23095 L
.02381 .24048 L
.02381 .25 L
.02381 .25952 L
.02381 .26905 L
.02381 .27857 L
.02381 .2881 L
.02381 .29762 L
.02381 .30714 L
.02381 .31667 L
.02381 .32619 L
.02381 .33571 L
.02381 .34524 L
.02381 .35476 L
.02381 .36429 L
.02381 .37381 L
.02381 .38333 L
.02381 .39286 L
.02381 .40238 L
.02381 .4119 L
.02381 .42143 L
.02381 .43095 L
.02381 .44048 L
.02381 .45 L
.02381 .45952 L
.02381 .46905 L
.02381 .47857 L
Mistroke
.02381 .4881 L
.02381 .4881 L
Mfstroke
.02381 .4881 m
.03333 .4881 L
.04286 .4881 L
.05238 .4881 L
.0619 .4881 L
.07143 .4881 L
.08095 .4881 L
.09048 .4881 L
.1 .4881 L
.10952 .4881 L
.11905 .4881 L
.12857 .4881 L
.1381 .4881 L
.14762 .4881 L
.15714 .4881 L
.16667 .4881 L
.17619 .4881 L
.18571 .4881 L
.19524 .4881 L
.20476 .4881 L
.21429 .4881 L
.22381 .4881 L
.23333 .4881 L
.24286 .4881 L
.25238 .4881 L
.2619 .4881 L
.27143 .4881 L
.28095 .4881 L
.29048 .4881 L
.3 .4881 L
.30952 .4881 L
.31905 .4881 L
.32857 .4881 L
.3381 .4881 L
.34762 .4881 L
.35714 .4881 L
.36667 .4881 L
.37619 .4881 L
.38571 .4881 L
.39524 .4881 L
.40476 .4881 L
.41429 .4881 L
.42381 .4881 L
.43333 .4881 L
.44286 .4881 L
.45238 .4881 L
.4619 .4881 L
.47143 .4881 L
.48095 .4881 L
.49048 .4881 L
Mistroke
.5 .4881 L
.50952 .4881 L
.51905 .4881 L
.52857 .4881 L
.5381 .4881 L
.54762 .4881 L
.55714 .4881 L
.56667 .4881 L
.57619 .4881 L
.58571 .4881 L
.59524 .4881 L
.60476 .4881 L
.61429 .4881 L
.62381 .4881 L
.63333 .4881 L
.64286 .4881 L
.65238 .4881 L
.6619 .4881 L
.67143 .4881 L
.68095 .4881 L
.69048 .4881 L
.7 .4881 L
.70952 .4881 L
.71905 .4881 L
.72857 .4881 L
.7381 .4881 L
.74762 .4881 L
.75714 .4881 L
.76667 .4881 L
.77619 .4881 L
.78571 .4881 L
.79524 .4881 L
.80476 .4881 L
.81429 .4881 L
.82381 .4881 L
.83333 .4881 L
.84286 .4881 L
.85238 .4881 L
.8619 .4881 L
.87143 .4881 L
.88095 .4881 L
.89048 .4881 L
.9 .4881 L
.90952 .4881 L
.91905 .4881 L
.92857 .4881 L
.9381 .4881 L
.94762 .4881 L
.95714 .4881 L
.96667 .4881 L
Mistroke
.97619 .4881 L
.97619 .4881 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.65.1"],

Cell[BoxData["\<\"-WorldGraphics-\"\>"], "Output",
 CellLabel->"Out[3]= ",
 CellTags->"S5.65.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["WorldPlot[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["countrylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["colorfunc", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["color the countries as specified by ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["colorfunc", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldPlot[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["countrylist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["colorlist", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "color the countries using the list of color directives ",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell["Specifying the color gray level of maps. ", "Caption",
 CellTags->"S5.65.1"],

Cell[TextData[{
 "When you make a map, you can specify the color of each country in several \
ways. The first is to give an explicit list of graphics directives such as ",
 StyleBox["GrayLevel", "MR"],
 ", ",
 StyleBox["RGBColor", "MR"],
 ", or ",
 StyleBox["Hue", "MR"],
 ". The ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " element in this list specifies the color of the map of the ",
 Cell[BoxData[
  FormBox[
   StyleBox["n",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " element in your list of country names. You can also specify the colors by \
defining your own color function. This color function must take names of \
countries as arguments and return a color directive. Perhaps the simplest way \
to create maps with colors is to specify the color function as ",
 StyleBox["RandomColors", "MR"],
 " or ",
 StyleBox["RandomGrays", "MR"],
 ". These two functions use random numbers to assign a color or gray level to \
each country on your list. "
}], "Text",
 CellTags->{"S5.65.1", "1.6"}],

Cell["Here is a simple color function. ", "MathCaption",
 CellTags->{"S5.65.1", "1.7"}],

Cell["\<\
shadefunc[country_] :=
   Switch[country, \"Canada\", GrayLevel[0],
                   \"Mexico\", GrayLevel[.3],
                   _,  GrayLevel[.6]]\
\>", "Input",
 CellLabel->"In[4]:= ",
 CellTags->"S5.65.1"],

Cell["\<\
The color function causes Canada to be drawn black, Mexico dark gray, and \
other countries a lighter gray. \
\>", "MathCaption",
 CellTags->{"S5.65.1", "1.8"}],

Cell[CellGroupData[{

Cell["WorldPlot[{NorthAmerica, shadefunc}]", "Input",
 CellLabel->"In[5]:= ",
 CellTags->"S5.65.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .52941 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.97619 9.33707e-05 0.012605 9.33707e-05 [
[ 0 0 0 0 ]
[ 1 .52941 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .52941 L
0 .52941 L
closepath
clip
newpath
0 g
.001 w
[ ] 0 setdash
.13585 .01261 m
.13585 .02157 L
.13585 .03053 L
.13585 .0395 L
.13585 .04846 L
.13585 .05742 L
.13585 .06639 L
.13585 .07535 L
.13585 .08431 L
.13585 .09328 L
.13585 .10224 L
.13585 .1112 L
.13585 .12017 L
.13585 .12913 L
.13585 .1381 L
.13585 .14706 L
.13585 .15602 L
.13585 .16499 L
.13585 .17395 L
.13585 .18291 L
.13585 .19188 L
.13585 .20084 L
.13585 .2098 L
.13585 .21877 L
.13585 .22773 L
.13585 .23669 L
.13585 .24566 L
.13585 .25462 L
.13585 .26359 L
.13585 .27255 L
.13585 .28151 L
.13585 .29048 L
.13585 .29944 L
.13585 .3084 L
.13585 .31737 L
.13585 .32633 L
.13585 .33529 L
.13585 .34426 L
.13585 .35322 L
.13585 .36218 L
.13585 .37115 L
.13585 .38011 L
.13585 .38908 L
.13585 .39804 L
.13585 .407 L
.13585 .41597 L
.13585 .42493 L
.13585 .43389 L
.13585 .44286 L
.13585 .45182 L
Mistroke
.13585 .46078 L
.13585 .46975 L
.13585 .47871 L
.13585 .48768 L
.13585 .49664 L
.13585 .5056 L
.13585 .51457 L
.13585 .51681 L
Mfstroke
.30392 .01261 m
.30392 .02157 L
.30392 .03053 L
.30392 .0395 L
.30392 .04846 L
.30392 .05742 L
.30392 .06639 L
.30392 .07535 L
.30392 .08431 L
.30392 .09328 L
.30392 .10224 L
.30392 .1112 L
.30392 .12017 L
.30392 .12913 L
.30392 .1381 L
.30392 .14706 L
.30392 .15602 L
.30392 .16499 L
.30392 .17395 L
.30392 .18291 L
.30392 .19188 L
.30392 .20084 L
.30392 .2098 L
.30392 .21877 L
.30392 .22773 L
.30392 .23669 L
.30392 .24566 L
.30392 .25462 L
.30392 .26359 L
.30392 .27255 L
.30392 .28151 L
.30392 .29048 L
.30392 .29944 L
.30392 .3084 L
.30392 .31737 L
.30392 .32633 L
.30392 .33529 L
.30392 .34426 L
.30392 .35322 L
.30392 .36218 L
.30392 .37115 L
.30392 .38011 L
.30392 .38908 L
.30392 .39804 L
.30392 .407 L
.30392 .41597 L
.30392 .42493 L
.30392 .43389 L
.30392 .44286 L
.30392 .45182 L
Mistroke
.30392 .46078 L
.30392 .46975 L
.30392 .47871 L
.30392 .48768 L
.30392 .49664 L
.30392 .5056 L
.30392 .51457 L
.30392 .51681 L
Mfstroke
.47199 .01261 m
.47199 .02157 L
.47199 .03053 L
.47199 .0395 L
.47199 .04846 L
.47199 .05742 L
.47199 .06639 L
.47199 .07535 L
.47199 .08431 L
.47199 .09328 L
.47199 .10224 L
.47199 .1112 L
.47199 .12017 L
.47199 .12913 L
.47199 .1381 L
.47199 .14706 L
.47199 .15602 L
.47199 .16499 L
.47199 .17395 L
.47199 .18291 L
.47199 .19188 L
.47199 .20084 L
.47199 .2098 L
.47199 .21877 L
.47199 .22773 L
.47199 .23669 L
.47199 .24566 L
.47199 .25462 L
.47199 .26359 L
.47199 .27255 L
.47199 .28151 L
.47199 .29048 L
.47199 .29944 L
.47199 .3084 L
.47199 .31737 L
.47199 .32633 L
.47199 .33529 L
.47199 .34426 L
.47199 .35322 L
.47199 .36218 L
.47199 .37115 L
.47199 .38011 L
.47199 .38908 L
.47199 .39804 L
.47199 .407 L
.47199 .41597 L
.47199 .42493 L
.47199 .43389 L
.47199 .44286 L
.47199 .45182 L
Mistroke
.47199 .46078 L
.47199 .46975 L
.47199 .47871 L
.47199 .48768 L
.47199 .49664 L
.47199 .5056 L
.47199 .51457 L
.47199 .51681 L
Mfstroke
.64006 .01261 m
.64006 .02157 L
.64006 .03053 L
.64006 .0395 L
.64006 .04846 L
.64006 .05742 L
.64006 .06639 L
.64006 .07535 L
.64006 .08431 L
.64006 .09328 L
.64006 .10224 L
.64006 .1112 L
.64006 .12017 L
.64006 .12913 L
.64006 .1381 L
.64006 .14706 L
.64006 .15602 L
.64006 .16499 L
.64006 .17395 L
.64006 .18291 L
.64006 .19188 L
.64006 .20084 L
.64006 .2098 L
.64006 .21877 L
.64006 .22773 L
.64006 .23669 L
.64006 .24566 L
.64006 .25462 L
.64006 .26359 L
.64006 .27255 L
.64006 .28151 L
.64006 .29048 L
.64006 .29944 L
.64006 .3084 L
.64006 .31737 L
.64006 .32633 L
.64006 .33529 L
.64006 .34426 L
.64006 .35322 L
.64006 .36218 L
.64006 .37115 L
.64006 .38011 L
.64006 .38908 L
.64006 .39804 L
.64006 .407 L
.64006 .41597 L
.64006 .42493 L
.64006 .43389 L
.64006 .44286 L
.64006 .45182 L
Mistroke
.64006 .46078 L
.64006 .46975 L
.64006 .47871 L
.64006 .48768 L
.64006 .49664 L
.64006 .5056 L
.64006 .51457 L
.64006 .51681 L
Mfstroke
.80812 .01261 m
.80812 .02157 L
.80812 .03053 L
.80812 .0395 L
.80812 .04846 L
.80812 .05742 L
.80812 .06639 L
.80812 .07535 L
.80812 .08431 L
.80812 .09328 L
.80812 .10224 L
.80812 .1112 L
.80812 .12017 L
.80812 .12913 L
.80812 .1381 L
.80812 .14706 L
.80812 .15602 L
.80812 .16499 L
.80812 .17395 L
.80812 .18291 L
.80812 .19188 L
.80812 .20084 L
.80812 .2098 L
.80812 .21877 L
.80812 .22773 L
.80812 .23669 L
.80812 .24566 L
.80812 .25462 L
.80812 .26359 L
.80812 .27255 L
.80812 .28151 L
.80812 .29048 L
.80812 .29944 L
.80812 .3084 L
.80812 .31737 L
.80812 .32633 L
.80812 .33529 L
.80812 .34426 L
.80812 .35322 L
.80812 .36218 L
.80812 .37115 L
.80812 .38011 L
.80812 .38908 L
.80812 .39804 L
.80812 .407 L
.80812 .41597 L
.80812 .42493 L
.80812 .43389 L
.80812 .44286 L
.80812 .45182 L
Mistroke
.80812 .46078 L
.80812 .46975 L
.80812 .47871 L
.80812 .48768 L
.80812 .49664 L
.80812 .5056 L
.80812 .51457 L
.80812 .51681 L
Mfstroke
.02381 .01261 m
.03277 .01261 L
.04174 .01261 L
.0507 .01261 L
.05966 .01261 L
.06863 .01261 L
.07759 .01261 L
.08655 .01261 L
.09552 .01261 L
.10448 .01261 L
.11345 .01261 L
.12241 .01261 L
.13137 .01261 L
.14034 .01261 L
.1493 .01261 L
.15826 .01261 L
.16723 .01261 L
.17619 .01261 L
.18515 .01261 L
.19412 .01261 L
.20308 .01261 L
.21204 .01261 L
.22101 .01261 L
.22997 .01261 L
.23894 .01261 L
.2479 .01261 L
.25686 .01261 L
.26583 .01261 L
.27479 .01261 L
.28375 .01261 L
.29272 .01261 L
.30168 .01261 L
.31064 .01261 L
.31961 .01261 L
.32857 .01261 L
.33754 .01261 L
.3465 .01261 L
.35546 .01261 L
.36443 .01261 L
.37339 .01261 L
.38235 .01261 L
.39132 .01261 L
.40028 .01261 L
.40924 .01261 L
.41821 .01261 L
.42717 .01261 L
.43613 .01261 L
.4451 .01261 L
.45406 .01261 L
.46303 .01261 L
Mistroke
.47199 .01261 L
.48095 .01261 L
.48992 .01261 L
.49888 .01261 L
.50784 .01261 L
.51681 .01261 L
.52577 .01261 L
.53473 .01261 L
.5437 .01261 L
.55266 .01261 L
.56162 .01261 L
.57059 .01261 L
.57955 .01261 L
.58852 .01261 L
.59748 .01261 L
.60644 .01261 L
.61541 .01261 L
.62437 .01261 L
.63333 .01261 L
.6423 .01261 L
.65126 .01261 L
.66022 .01261 L
.66919 .01261 L
.67815 .01261 L
.68711 .01261 L
.69608 .01261 L
.70504 .01261 L
.71401 .01261 L
.72297 .01261 L
.73193 .01261 L
.7409 .01261 L
.74986 .01261 L
.75882 .01261 L
.76779 .01261 L
.77675 .01261 L
.78571 .01261 L
.79468 .01261 L
.80364 .01261 L
.81261 .01261 L
.82157 .01261 L
.83053 .01261 L
.8395 .01261 L
.84846 .01261 L
.85742 .01261 L
.86639 .01261 L
.87535 .01261 L
.88431 .01261 L
.89328 .01261 L
.90224 .01261 L
.9112 .01261 L
Mistroke
.92017 .01261 L
.92017 .01261 L
Mfstroke
.02381 .18067 m
.03277 .18067 L
.04174 .18067 L
.0507 .18067 L
.05966 .18067 L
.06863 .18067 L
.07759 .18067 L
.08655 .18067 L
.09552 .18067 L
.10448 .18067 L
.11345 .18067 L
.12241 .18067 L
.13137 .18067 L
.14034 .18067 L
.1493 .18067 L
.15826 .18067 L
.16723 .18067 L
.17619 .18067 L
.18515 .18067 L
.19412 .18067 L
.20308 .18067 L
.21204 .18067 L
.22101 .18067 L
.22997 .18067 L
.23894 .18067 L
.2479 .18067 L
.25686 .18067 L
.26583 .18067 L
.27479 .18067 L
.28375 .18067 L
.29272 .18067 L
.30168 .18067 L
.31064 .18067 L
.31961 .18067 L
.32857 .18067 L
.33754 .18067 L
.3465 .18067 L
.35546 .18067 L
.36443 .18067 L
.37339 .18067 L
.38235 .18067 L
.39132 .18067 L
.40028 .18067 L
.40924 .18067 L
.41821 .18067 L
.42717 .18067 L
.43613 .18067 L
.4451 .18067 L
.45406 .18067 L
.46303 .18067 L
Mistroke
.47199 .18067 L
.48095 .18067 L
.48992 .18067 L
.49888 .18067 L
.50784 .18067 L
.51681 .18067 L
.52577 .18067 L
.53473 .18067 L
.5437 .18067 L
.55266 .18067 L
.56162 .18067 L
.57059 .18067 L
.57955 .18067 L
.58852 .18067 L
.59748 .18067 L
.60644 .18067 L
.61541 .18067 L
.62437 .18067 L
.63333 .18067 L
.6423 .18067 L
.65126 .18067 L
.66022 .18067 L
.66919 .18067 L
.67815 .18067 L
.68711 .18067 L
.69608 .18067 L
.70504 .18067 L
.71401 .18067 L
.72297 .18067 L
.73193 .18067 L
.7409 .18067 L
.74986 .18067 L
.75882 .18067 L
.76779 .18067 L
.77675 .18067 L
.78571 .18067 L
.79468 .18067 L
.80364 .18067 L
.81261 .18067 L
.82157 .18067 L
.83053 .18067 L
.8395 .18067 L
.84846 .18067 L
.85742 .18067 L
.86639 .18067 L
.87535 .18067 L
.88431 .18067 L
.89328 .18067 L
.90224 .18067 L
.9112 .18067 L
Mistroke
.92017 .18067 L
.92017 .18067 L
Mfstroke
.02381 .34874 m
.03277 .34874 L
.04174 .34874 L
.0507 .34874 L
.05966 .34874 L
.06863 .34874 L
.07759 .34874 L
.08655 .34874 L
.09552 .34874 L
.10448 .34874 L
.11345 .34874 L
.12241 .34874 L
.13137 .34874 L
.14034 .34874 L
.1493 .34874 L
.15826 .34874 L
.16723 .34874 L
.17619 .34874 L
.18515 .34874 L
.19412 .34874 L
.20308 .34874 L
.21204 .34874 L
.22101 .34874 L
.22997 .34874 L
.23894 .34874 L
.2479 .34874 L
.25686 .34874 L
.26583 .34874 L
.27479 .34874 L
.28375 .34874 L
.29272 .34874 L
.30168 .34874 L
.31064 .34874 L
.31961 .34874 L
.32857 .34874 L
.33754 .34874 L
.3465 .34874 L
.35546 .34874 L
.36443 .34874 L
.37339 .34874 L
.38235 .34874 L
.39132 .34874 L
.40028 .34874 L
.40924 .34874 L
.41821 .34874 L
.42717 .34874 L
.43613 .34874 L
.4451 .34874 L
.45406 .34874 L
.46303 .34874 L
Mistroke
.47199 .34874 L
.48095 .34874 L
.48992 .34874 L
.49888 .34874 L
.50784 .34874 L
.51681 .34874 L
.52577 .34874 L
.53473 .34874 L
.5437 .34874 L
.55266 .34874 L
.56162 .34874 L
.57059 .34874 L
.57955 .34874 L
.58852 .34874 L
.59748 .34874 L
.60644 .34874 L
.61541 .34874 L
.62437 .34874 L
.63333 .34874 L
.6423 .34874 L
.65126 .34874 L
.66022 .34874 L
.66919 .34874 L
.67815 .34874 L
.68711 .34874 L
.69608 .34874 L
.70504 .34874 L
.71401 .34874 L
.72297 .34874 L
.73193 .34874 L
.7409 .34874 L
.74986 .34874 L
.75882 .34874 L
.76779 .34874 L
.77675 .34874 L
.78571 .34874 L
.79468 .34874 L
.80364 .34874 L
.81261 .34874 L
.82157 .34874 L
.83053 .34874 L
.8395 .34874 L
.84846 .34874 L
.85742 .34874 L
.86639 .34874 L
.87535 .34874 L
.88431 .34874 L
.89328 .34874 L
.90224 .34874 L
.9112 .34874 L
Mistroke
.92017 .34874 L
.92017 .34874 L
Mfstroke
.02381 .51681 m
.03277 .51681 L
.04174 .51681 L
.0507 .51681 L
.05966 .51681 L
.06863 .51681 L
.07759 .51681 L
.08655 .51681 L
.09552 .51681 L
.10448 .51681 L
.11345 .51681 L
.12241 .51681 L
.13137 .51681 L
.14034 .51681 L
.1493 .51681 L
.15826 .51681 L
.16723 .51681 L
.17619 .51681 L
.18515 .51681 L
.19412 .51681 L
.20308 .51681 L
.21204 .51681 L
.22101 .51681 L
.22997 .51681 L
.23894 .51681 L
.2479 .51681 L
.25686 .51681 L
.26583 .51681 L
.27479 .51681 L
.28375 .51681 L
.29272 .51681 L
.30168 .51681 L
.31064 .51681 L
.31961 .51681 L
.32857 .51681 L
.33754 .51681 L
.3465 .51681 L
.35546 .51681 L
.36443 .51681 L
.37339 .51681 L
.38235 .51681 L
.39132 .51681 L
.40028 .51681 L
.40924 .51681 L
.41821 .51681 L
.42717 .51681 L
.43613 .51681 L
.4451 .51681 L
.45406 .51681 L
.46303 .51681 L
Mistroke
.47199 .51681 L
.48095 .51681 L
.48992 .51681 L
.49888 .51681 L
.50784 .51681 L
.51681 .51681 L
.52577 .51681 L
.53473 .51681 L
.5437 .51681 L
.55266 .51681 L
.56162 .51681 L
.57059 .51681 L
.57955 .51681 L
.58852 .51681 L
.59748 .51681 L
.60644 .51681 L
.61541 .51681 L
.62437 .51681 L
.63333 .51681 L
.6423 .51681 L
.65126 .51681 L
.66022 .51681 L
.66919 .51681 L
.67815 .51681 L
.68711 .51681 L
.69608 .51681 L
.70504 .51681 L
.71401 .51681 L
.72297 .51681 L
.73193 .51681 L
.7409 .51681 L
.74986 .51681 L
.75882 .51681 L
.76779 .51681 L
.77675 .51681 L
.78571 .51681 L
.79468 .51681 L
.80364 .51681 L
.81261 .51681 L
.82157 .51681 L
.83053 .51681 L
.8395 .51681 L
.84846 .51681 L
.85742 .51681 L
.86639 .51681 L
.87535 .51681 L
.88431 .51681 L
.89328 .51681 L
.90224 .51681 L
.9112 .51681 L
Mistroke
.92017 .51681 L
.92017 .51681 L
Mfstroke
.6 g
.32007 .19486 m
.31914 .19748 L
.30047 .20626 L
.29001 .22278 L
.29599 .22558 L
.28319 .23072 L
.28049 .2479 L
.28114 .2719 L
.2775 .28375 L
.28852 .28245 L
.28674 .27656 L
.28852 .28702 L
.28861 .28711 L
.32054 .28711 L
.32614 .28711 L
.39356 .28711 L
.43165 .28711 L
.47432 .28151 L
.50486 .2733 L
.51447 .25359 L
.51317 .25098 L
.51289 .24613 L
.53408 .25303 L
.53324 .25406 L
.53324 .255 L
.55154 .26181 L
.56527 .2648 L
.57563 .2648 L
.57796 .26639 L
.58833 .27852 L
.59972 .26573 L
.57983 .25387 L
.57946 .25275 L
.57778 .24519 L
.57768 .2451 L
.57778 .24519 L
.57367 .24407 L
.56359 .2423 L
.56022 .23959 L
.55686 .23081 L
.55584 .23669 L
.55359 .23557 L
.55584 .22801 L
.55397 .22558 L
.5507 .22063 L
.55238 .2253 L
.54911 .22838 L
.55135 .23436 L
.54865 .22577 L
.54472 .22997 L
.54444 .23053 L
.54407 .22642 L
.54893 .22035 L
.54323 .22166 L
.55126 .21737 L
.55313 .21307 L
.55079 .2183 L
.54631 .21401 L
.55182 .21214 L
.54454 .21167 L
.54855 .20803 L
.53613 .20233 L
.52306 .19197 L
.51961 .18469 L
.52782 .16265 L
.52194 .15331 L
.50738 .18021 L
.4859 .18226 L
.48095 .18282 L
.4747 .1817 L
.46956 .18151 L
.47554 .18095 L
.47526 .1747 L
.4507 .18067 L
.45079 .18058 L
.42988 .16872 L
.43203 .15808 L
.4211 .1605 L
.4113 .17666 L
.39328 .17694 L
.37946 .19066 L
.36527 .18814 L
.33352 .19589 L
.32007 .19486 L
F
.2479 .32586 m
.24407 .31942 L
.2422 .32689 L
.2352 .32493 L
.21802 .34575 L
.21905 .33866 L
.19468 .34902 L
.14865 .35593 L
.13782 .3479 L
.12474 .34472 L
.14006 .35714 L
.11653 .34155 L
.08861 .32633 L
.06116 .31961 L
.0944 .33473 L
.09785 .34398 L
.07899 .34248 L
.06769 .34118 L
.06928 .35266 L
.05929 .34762 L
.05994 .35378 L
.05173 .35686 L
.0451 .35761 L
.05509 .36676 L
.07339 .36844 L
.07432 .37638 L
.03427 .38039 L
.05584 .38571 L
.06975 .38226 L
.06592 .38768 L
.07852 .38459 L
.04155 .39552 L
.07012 .40588 L
.09963 .41261 L
.18618 .4028 L
.18627 .35042 L
.21727 .34762 L
.24781 .32586 L
F
.10327 .12614 m
.10896 .12204 L
.10411 .11858 L
.10327 .12614 L
F
.11755 .33754 m
.12278 .33436 L
.10896 .33389 L
.11755 .33754 L
F
0 g
.28861 .28711 m
.32054 .28711 L
.32614 .28711 L
.39356 .28711 L
.43165 .28711 L
.47432 .28151 L
.50486 .2733 L
.51447 .25359 L
.51317 .25098 L
.51289 .24613 L
.53408 .25303 L
.53324 .25406 L
.53324 .255 L
.55154 .26181 L
.56527 .2648 L
.57563 .2648 L
.57796 .26639 L
.58833 .27852 L
.59972 .26573 L
.60803 .2662 L
.61345 .27077 L
.61242 .26667 L
.6212 .26676 L
.60542 .26144 L
.60943 .25612 L
.63464 .2662 L
.62932 .26965 L
.61905 .26937 L
.61382 .28002 L
.60168 .28151 L
.61643 .28431 L
.60952 .28861 L
.57675 .27451 L
.58553 .28217 L
.57806 .28394 L
.58581 .28226 L
.61503 .29449 L
.63931 .29384 L
.66461 .30514 L
.66377 .31055 L
.65107 .31643 L
.63772 .31102 L
.64921 .31643 L
.6549 .31839 L
.63623 .32073 L
.62773 .33035 L
.61298 .35079 L
.60607 .33931 L
.59524 .3408 L
.58758 .33623 L
.59412 .34062 L
.57824 .34911 L
.58758 .35378 L
.57236 .35845 L
.53866 .36181 L
.53604 .34099 L
.54715 .33324 L
.54407 .32437 L
.52932 .31877 L
.53175 .29673 L
.51746 .30495 L
.51513 .32157 L
.49767 .32063 L
.47852 .331 L
.45584 .33137 L
.4479 .34024 L
.4451 .35154 L
.46844 .36592 L
.45079 .37218 L
.48329 .37218 L
.48861 .37806 L
.46359 .38207 L
.48655 .37852 L
.50728 .38338 L
.49879 .38749 L
.51961 .38796 L
.52054 .40019 L
.49683 .40401 L
.48852 .38936 L
.47787 .40047 L
.47059 .39486 L
.45565 .40289 L
.44641 .41597 L
.43539 .40551 L
.45313 .39711 L
.44136 .3915 L
.4394 .38562 L
.43735 .39206 L
.42801 .39664 L
.43165 .39141 L
.40345 .39178 L
.38114 .39879 L
.36863 .39458 L
.38431 .39711 L
.37535 .38431 L
.35948 .39356 L
.33137 .39244 L
.33203 .39841 L
.27965 .40112 L
.27843 .4056 L
.27348 .40093 L
.2591 .40803 L
.24342 .40112 L
.22848 .39851 L
.24977 .40626 L
.23081 .40177 L
.21895 .3972 L
.18618 .4028 L
.18627 .35042 L
.21727 .34762 L
.24781 .32586 L
.24762 .31447 L
.25369 .31261 L
.25724 .30598 L
.2662 .30598 L
.25976 .30205 L
.26032 .29925 L
.27694 .29785 L
.28852 .28702 L
F
.23856 .31578 m
.23277 .31092 L
.23072 .31606 L
.23856 .31578 L
F
.26209 .29664 m
.28403 .28319 L
.262 .29664 L
F
.30542 .42736 m
.33016 .42428 L
.28824 .41083 L
.27031 .41578 L
.27712 .42904 L
.30532 .42736 L
F
.33417 .41933 m
.36779 .41886 L
.37199 .41373 L
.37068 .42353 L
.38683 .41811 L
.41055 .4056 L
.39972 .39804 L
.37908 .40196 L
.34136 .39617 L
.3183 .40476 L
.35163 .40663 L
.31755 .40812 L
.33156 .41335 L
.30896 .41419 L
.31877 .4211 L
.33417 .41933 L
F
.51111 .37628 m
.5226 .36807 L
.49869 .3662 L
.48777 .36881 L
.49655 .38189 L
.51111 .37628 L
F
.39085 .42456 m
.38637 .42073 L
.37656 .42428 L
.39085 .42456 L
F
.42792 .40411 m
.44099 .39729 L
.41914 .39851 L
.42792 .40411 L
F
.66461 .30177 m
.6577 .2902 L
.66592 .2873 L
.67656 .2887 L
.67554 .2788 L
.68021 .28207 L
.6788 .27395 L
.67227 .28095 L
.66592 .27516 L
.66377 .28123 L
.64398 .27937 L
.64342 .28105 L
.65219 .29178 L
.66461 .30168 L
F
.63828 .27507 m
.63361 .26863 L
.64118 .26993 L
.63156 .26993 L
.63828 .27507 L
F
.59953 .39514 m
.63296 .3859 L
.62017 .3761 L
.61569 .38431 L
.59225 .38403 L
.59869 .37974 L
.6141 .36499 L
.58964 .36975 L
.60607 .3592 L
.57619 .36583 L
.5549 .37367 L
.53922 .37348 L
.54239 .37937 L
.55387 .37516 L
.56452 .37927 L
.57703 .38207 L
.58842 .38553 L
.56732 .38655 L
.54678 .39748 L
.53352 .40859 L
.52269 .40317 L
.48366 .40607 L
.47442 .41083 L
.4719 .41531 L
.49356 .42642 L
.48992 .41027 L
.49617 .42101 L
.51699 .42568 L
.5226 .41531 L
.54444 .42017 L
.55556 .41139 L
.56508 .41027 L
.5733 .41354 L
.56937 .40831 L
.57544 .40486 L
.58478 .40971 L
.58964 .40476 L
.58385 .40215 L
.60215 .40103 L
.58739 .39841 L
.59953 .39514 L
F
.44351 .42726 m
.47087 .42661 L
.44921 .41587 L
.44351 .42726 L
F
.31148 .44603 m
.32689 .4422 L
.30205 .43725 L
.28693 .43884 L
.31148 .44603 L
F
.39524 .45714 m
.42054 .44865 L
.38898 .45154 L
.39524 .45714 L
F
.41382 .44192 m
.42932 .43343 L
.40037 .43585 L
.40551 .4409 L
.41382 .44192 L
F
.3 g
.43203 .15808 m
.42782 .13922 L
.43912 .11746 L
.46536 .11718 L
.46433 .1183 L
.47012 .13044 L
.48814 .13371 L
.48151 .11615 L
.47684 .11242 L
.46648 .11242 L
.46956 .1028 L
.46228 .10261 L
.45938 .09412 L
.4564 .09711 L
.45938 .09412 L
.44472 .10467 L
.42838 .10205 L
.39645 .11531 L
.38543 .12418 L
.38394 .13884 L
.36331 .15621 L
.34781 .17488 L
.34267 .18758 L
.33175 .1916 L
.34388 .17106 L
.36265 .1422 L
.34818 .15117 L
.33184 .16797 L
.33716 .17236 L
.32007 .19486 L
.33352 .19589 L
.36527 .18814 L
.37946 .19066 L
.39328 .17694 L
.4113 .17666 L
.4211 .1605 L
.43203 .15808 L
F
.6 g
.77554 .3831 m
.79421 .39701 L
.82372 .39655 L
.85126 .40476 L
.81261 .407 L
.8338 .41186 L
.81597 .41671 L
.85537 .40738 L
.83305 .41821 L
.82241 .42409 L
.86134 .42409 L
.85229 .43044 L
.86984 .42988 L
.85051 .43371 L
.86788 .43501 L
.85033 .44304 L
.8747 .4437 L
.85275 .44781 L
.8859 .46359 L
.85714 .46396 L
.90812 .46975 L
.83912 .46377 L
.85126 .47246 L
.83483 .47199 L
.79328 .47021 L
.85677 .47535 L
.7774 .47619 L
.8324 .47918 L
.79122 .48105 L
.71466 .47768 L
.75266 .47572 L
.71989 .47628 L
.72614 .47059 L
.69683 .46984 L
.64799 .47255 L
.65994 .46825 L
.63931 .47162 L
.60756 .45593 L
.56928 .45238 L
.60607 .44678 L
.57638 .44426 L
.59244 .43884 L
.63959 .43847 L
.66303 .41419 L
.6761 .41793 L
.69337 .40766 L
.67012 .4084 L
.69486 .40486 L
.67712 .39542 L
.69524 .39318 L
.67516 .39094 L
.69066 .393 L
.67442 .38926 L
.69402 .38889 L
.67386 .38833 L
.67656 .38291 L
.69608 .38786 L
.67666 .38226 L
.693 .38077 L
.6817 .37852 L
.68487 .37227 L
.69608 .376 L
.69346 .36769 L
.70598 .35331 L
.72288 .35546 L
.72344 .34911 L
.73473 .3493 L
.73828 .35845 L
.73445 .36415 L
.74585 .3774 L
.77554 .3831 L
F
.67199 .40654 m
.68581 .40271 L
.6761 .40047 L
.67199 .40654 L
F
.61345 .19365 m
% vacuous filled polygon
newpath
.50047 .13539 m
.52166 .14267 L
.54314 .13445 L
.56088 .12568 L
.5422 .12549 L
.51746 .13968 L
.50047 .13539 L
F
.53716 .11494 m
% vacuous filled polygon
newpath
.57414 .11363 m
.55892 .11587 L
.57087 .11643 L
.56471 .12325 L
.57423 .12297 L
.57414 .11363 L
F
.48161 .11615 m
.47806 .10168 L
.47684 .11242 L
.48161 .11615 L
F
.57414 .12297 m
.59346 .11681 L
.57404 .11373 L
.57414 .12297 L
F
.48413 .08786 m
.47143 .08964 L
.47563 .09346 L
.48413 .08786 L
F
.47806 .10168 m
.48198 .10065 L
.47563 .09346 L
.47143 .08964 L
.45938 .09412 L
.46228 .10261 L
.46956 .1028 L
.46648 .11242 L
.47684 .11242 L
.47806 .10168 L
F
.48198 .10065 m
.51046 .09664 L
.48711 .08534 L
.48413 .08786 L
.47563 .09346 L
.48198 .10065 L
F
.51046 .09664 m
.50756 .07376 L
.49617 .0746 L
.48693 .08525 L
.51046 .09664 L
F
.50756 .07376 m
.51363 .0662 L
.51176 .05761 L
.49627 .06807 L
.49617 .0746 L
.50756 .07376 L
F
.51363 .0662 m
.52782 .06452 L
.52894 .06508 L
.54276 .06125 L
.53987 .05313 L
.53856 .0605 L
.53063 .06265 L
.53025 .06237 L
.52558 .05322 L
.51176 .05761 L
.51363 .0662 L
F
.59935 .11559 m
% vacuous filled polygon
newpath
0 g
.92017 .51681 m
.92017 .51457 L
.92017 .5056 L
.92017 .49664 L
.92017 .48768 L
.92017 .47871 L
.92017 .46975 L
.92017 .46078 L
.92017 .45182 L
.92017 .44286 L
.92017 .43389 L
.92017 .42493 L
.92017 .41597 L
.92017 .407 L
.92017 .39804 L
.92017 .38908 L
.92017 .38011 L
.92017 .37115 L
.92017 .36218 L
.92017 .35322 L
.92017 .34426 L
.92017 .33529 L
.92017 .32633 L
.92017 .31737 L
.92017 .3084 L
.92017 .29944 L
.92017 .29048 L
.92017 .28151 L
.92017 .27255 L
.92017 .26359 L
.92017 .25462 L
.92017 .24566 L
.92017 .23669 L
.92017 .22773 L
.92017 .21877 L
.92017 .2098 L
.92017 .20084 L
.92017 .19188 L
.92017 .18291 L
.92017 .17395 L
.92017 .16499 L
.92017 .15602 L
.92017 .14706 L
.92017 .1381 L
.92017 .12913 L
.92017 .12017 L
.92017 .1112 L
.92017 .10224 L
.92017 .09328 L
.92017 .08431 L
Mistroke
.92017 .07535 L
.92017 .06639 L
.92017 .05742 L
.92017 .04846 L
.92017 .0395 L
.92017 .03053 L
.92017 .02157 L
.92017 .01261 L
Mfstroke
.92017 .01261 m
.92017 .01261 L
.9112 .01261 L
.90224 .01261 L
.89328 .01261 L
.88431 .01261 L
.87535 .01261 L
.86639 .01261 L
.85742 .01261 L
.84846 .01261 L
.8395 .01261 L
.83053 .01261 L
.82157 .01261 L
.81261 .01261 L
.80364 .01261 L
.79468 .01261 L
.78571 .01261 L
.77675 .01261 L
.76779 .01261 L
.75882 .01261 L
.74986 .01261 L
.7409 .01261 L
.73193 .01261 L
.72297 .01261 L
.71401 .01261 L
.70504 .01261 L
.69608 .01261 L
.68711 .01261 L
.67815 .01261 L
.66919 .01261 L
.66022 .01261 L
.65126 .01261 L
.6423 .01261 L
.63333 .01261 L
.62437 .01261 L
.61541 .01261 L
.60644 .01261 L
.59748 .01261 L
.58852 .01261 L
.57955 .01261 L
.57059 .01261 L
.56162 .01261 L
.55266 .01261 L
.5437 .01261 L
.53473 .01261 L
.52577 .01261 L
.51681 .01261 L
.50784 .01261 L
.49888 .01261 L
.48992 .01261 L
Mistroke
.48095 .01261 L
.47199 .01261 L
.46303 .01261 L
.45406 .01261 L
.4451 .01261 L
.43613 .01261 L
.42717 .01261 L
.41821 .01261 L
.40924 .01261 L
.40028 .01261 L
.39132 .01261 L
.38235 .01261 L
.37339 .01261 L
.36443 .01261 L
.35546 .01261 L
.3465 .01261 L
.33754 .01261 L
.32857 .01261 L
.31961 .01261 L
.31064 .01261 L
.30168 .01261 L
.29272 .01261 L
.28375 .01261 L
.27479 .01261 L
.26583 .01261 L
.25686 .01261 L
.2479 .01261 L
.23894 .01261 L
.22997 .01261 L
.22101 .01261 L
.21204 .01261 L
.20308 .01261 L
.19412 .01261 L
.18515 .01261 L
.17619 .01261 L
.16723 .01261 L
.15826 .01261 L
.1493 .01261 L
.14034 .01261 L
.13137 .01261 L
.12241 .01261 L
.11345 .01261 L
.10448 .01261 L
.09552 .01261 L
.08655 .01261 L
.07759 .01261 L
.06863 .01261 L
.05966 .01261 L
.0507 .01261 L
.04174 .01261 L
Mistroke
.03277 .01261 L
.02381 .01261 L
Mfstroke
.02381 .01261 m
.02381 .02157 L
.02381 .03053 L
.02381 .0395 L
.02381 .04846 L
.02381 .05742 L
.02381 .06639 L
.02381 .07535 L
.02381 .08431 L
.02381 .09328 L
.02381 .10224 L
.02381 .1112 L
.02381 .12017 L
.02381 .12913 L
.02381 .1381 L
.02381 .14706 L
.02381 .15602 L
.02381 .16499 L
.02381 .17395 L
.02381 .18291 L
.02381 .19188 L
.02381 .20084 L
.02381 .2098 L
.02381 .21877 L
.02381 .22773 L
.02381 .23669 L
.02381 .24566 L
.02381 .25462 L
.02381 .26359 L
.02381 .27255 L
.02381 .28151 L
.02381 .29048 L
.02381 .29944 L
.02381 .3084 L
.02381 .31737 L
.02381 .32633 L
.02381 .33529 L
.02381 .34426 L
.02381 .35322 L
.02381 .36218 L
.02381 .37115 L
.02381 .38011 L
.02381 .38908 L
.02381 .39804 L
.02381 .407 L
.02381 .41597 L
.02381 .42493 L
.02381 .43389 L
.02381 .44286 L
.02381 .45182 L
Mistroke
.02381 .46078 L
.02381 .46975 L
.02381 .47871 L
.02381 .48768 L
.02381 .49664 L
.02381 .5056 L
.02381 .51457 L
.02381 .51681 L
Mfstroke
.02381 .51681 m
.03277 .51681 L
.04174 .51681 L
.0507 .51681 L
.05966 .51681 L
.06863 .51681 L
.07759 .51681 L
.08655 .51681 L
.09552 .51681 L
.10448 .51681 L
.11345 .51681 L
.12241 .51681 L
.13137 .51681 L
.14034 .51681 L
.1493 .51681 L
.15826 .51681 L
.16723 .51681 L
.17619 .51681 L
.18515 .51681 L
.19412 .51681 L
.20308 .51681 L
.21204 .51681 L
.22101 .51681 L
.22997 .51681 L
.23894 .51681 L
.2479 .51681 L
.25686 .51681 L
.26583 .51681 L
.27479 .51681 L
.28375 .51681 L
.29272 .51681 L
.30168 .51681 L
.31064 .51681 L
.31961 .51681 L
.32857 .51681 L
.33754 .51681 L
.3465 .51681 L
.35546 .51681 L
.36443 .51681 L
.37339 .51681 L
.38235 .51681 L
.39132 .51681 L
.40028 .51681 L
.40924 .51681 L
.41821 .51681 L
.42717 .51681 L
.43613 .51681 L
.4451 .51681 L
.45406 .51681 L
.46303 .51681 L
Mistroke
.47199 .51681 L
.48095 .51681 L
.48992 .51681 L
.49888 .51681 L
.50784 .51681 L
.51681 .51681 L
.52577 .51681 L
.53473 .51681 L
.5437 .51681 L
.55266 .51681 L
.56162 .51681 L
.57059 .51681 L
.57955 .51681 L
.58852 .51681 L
.59748 .51681 L
.60644 .51681 L
.61541 .51681 L
.62437 .51681 L
.63333 .51681 L
.6423 .51681 L
.65126 .51681 L
.66022 .51681 L
.66919 .51681 L
.67815 .51681 L
.68711 .51681 L
.69608 .51681 L
.70504 .51681 L
.71401 .51681 L
.72297 .51681 L
.73193 .51681 L
.7409 .51681 L
.74986 .51681 L
.75882 .51681 L
.76779 .51681 L
.77675 .51681 L
.78571 .51681 L
.79468 .51681 L
.80364 .51681 L
.81261 .51681 L
.82157 .51681 L
.83053 .51681 L
.8395 .51681 L
.84846 .51681 L
.85742 .51681 L
.86639 .51681 L
.87535 .51681 L
.88431 .51681 L
.89328 .51681 L
.90224 .51681 L
.9112 .51681 L
Mistroke
.92017 .51681 L
.92017 .51681 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.65.1"],

Cell[BoxData["\<\"-WorldGraphics-\"\>"], "Output",
 CellLabel->"Out[5]= ",
 CellTags->"S5.65.1"]
}, Open  ]],

Cell[TextData[{
 "A map is simply the representation of a portion of the Earth\
\[CloseCurlyQuote]s surface on a flat page. Since the Earth is nearly \
spherical, this representation requires that we adopt some scheme for taking \
the surface of a spherical object and representing it as a flat \
two\[Hyphen]dimensional image. These schemes are called ",
 StyleBox["projections", "TI"],
 ". By their very nature, all projections give rise to certain distortions. \
Various projections have been developed that preserve certain properties of \
the surface of the Earth while distorting others. An ",
 StyleBox["equal\[Hyphen]area", "TI"],
 " projection has the property that two regions that have the same area on \
the map have the same area on the globe. A projection is called ",
 StyleBox["conformal", "TI"],
 " if it preserves angular relationships and therefore directions. An ",
 StyleBox["azimuthal", "TI"],
 " projection preserves true directions from a central point. "
}], "Text",
 CellTags->{"S5.65.1", "1.9"}],

Cell[TextData[{
 "The projection for a map is specified by the option ",
 StyleBox["WorldProjection", "MR"],
 ". You can define your own projection by giving a pure function of two \
arguments. For example, the default setting for ",
 StyleBox["WorldProjection", "MR"],
 " is ",
 StyleBox["Equirectangular", "MR"],
 ", which as a pure function is given as ",
 StyleBox["WorldProjection", "MR"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["({#2,", "MR"],
 " ",
 StyleBox["#1}&)", "MR"],
 ". The parentheses around the pure function ensure that ",
 StyleBox["Mathematica", "TI"],
 " recognizes it as a single expression. If you define your own projections, \
it is important to remember that the coordinates in the database are given in \
minutes. This means that you must convert them to radians before using a \
built\[Hyphen]in ",
 StyleBox["Mathematica", "TI"],
 " trigonometric function. Also, the coordinates of the boundaries of \
countries are given as pairs with the latitude first. "
}], "Text",
 CellTags->{"S5.65.1", "1.10"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Albers",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Equirectangular",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["LambertAzimuthal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["LambertCylindrical",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Mercator",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mollweide",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Orthographic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Sinusoidal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell["Projections.", "Caption",
 CellTags->"S5.65.1"],

Cell[TextData[{
 "You can also give the name of a projection as a value for the option ",
 StyleBox["WorldProjection", "MR"],
 ". Many of the standard projections are included in this package. These are \
described below. "
}], "Text",
 CellTags->{"S5.65.1", "1.11"}],

Cell[TextData[{
 "The simplest projection is the ",
 StyleBox["equirectangular projection", "TB"],
 " ",
 StyleBox["Equirectangular", "MR"],
 ". This projection simply takes the latitude as the ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " coordinate and the longitude as the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " coordinate. This projection does not preserve angles or area. ",
 StyleBox["Equirectangular", "MR"],
 " is the default setting for ",
 StyleBox["WorldProjection", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.65.1", "1.12"}],

Cell[TextData[{
 "The ",
 StyleBox["Lambert cylindrical projection", "TB"],
 " ",
 StyleBox["LambertCylindrical", "MR"],
 " is just an equirectangular projection with the spacing between parallels \
adjusted so the projection is equal area. This projection is sometimes called \
the ",
 StyleBox["cylindrical equal\[Hyphen]area projection", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.65.1", "1.13"}],

Cell[TextData[{
 "In the ",
 StyleBox["Lambert azimuthal projection", "TB"],
 " ",
 StyleBox["LambertAzimuthal", "MR"],
 " the globe is projected onto a plane that is tangential to the globe at one \
point, and then the spacing of parallel circles around the projection point \
is adjusted to make it equal area. This projection gives true directions from \
the center point and is sometimes called the ",
 StyleBox["azimuthal equal\[Hyphen]area projection", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.65.1", "1.14"}],

Cell[TextData[{
 "Another azimuthal projection is the orthographic projection. ",
 StyleBox["Orthographic", "MR"],
 " specifies a projection of the sphere with the projection point at \
infinity. The result looks like a view of the planet as seen from very far \
away. The projection preserves neither area nor angles. "
}], "Text",
 CellTags->{"S5.65.1", "1.15"}],

Cell[TextData[{
 "The ",
 StyleBox["sinusoidal projection", "TB"],
 " ",
 StyleBox["Sinusoidal", "MR"],
 " belongs to the class of pseudo\[Hyphen]cylindrical projections, that is, \
parallels are straight lines, meridians are curved, and their spacing is \
adjusted to make it equal area. "
}], "Text",
 CellTags->{"S5.65.1", "1.16"}],

Cell[TextData[{
 "The most popular equal\[Hyphen]area projection for world maps is the ",
 StyleBox["Mollweide projection", "TB"],
 " ",
 StyleBox["Mollweide", "MR"],
 ". The adjustment used to achieve equal areas is fairly sophisticated and \
involves the solution of a trigonometric equation. This projection is \
sometimes also called ",
 StyleBox["elliptical", "TI"],
 " or ",
 StyleBox["homolographic", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.65.1", "1.17"}],

Cell[TextData[{
 "The ",
 StyleBox["Mercator projection", "TB"],
 " ",
 StyleBox["Mercator", "MR"],
 " is a cylindrical projection that preserves angles but is not equal area. \
It is produced by adjusting a cylindrical projection that is projected from \
the center of the Earth. This projection is particularly useful for \
navigation, as a straight line on the map corresponds to a fixed directional \
bearing. "
}], "Text",
 CellTags->{"S5.65.1", "1.18"}],

Cell[TextData[{
 "A conic projection is produced by projecting the surface of the Earth onto \
a cone that is tangential to the Earth along a circle. The ",
 StyleBox["Albers conic projection", "TB"],
 " ",
 StyleBox["Albers", "MR"],
 " is a conic projection that is adjusted to make it equal area. Unlike the \
other projections, ",
 StyleBox["Albers", "MR"],
 " requires you to specify additional information. This takes the form of ",
 StyleBox["Albers[", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["par",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["par",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["]", "MR"],
 ". The two parallels you specify are the parallels along which the scale is \
correct. A good projection for the United States is ",
 StyleBox["Albers[20,", "MR"],
 " ",
 StyleBox["60]", "MR"],
 ". The Albers conic projection is sometimes called the ",
 StyleBox["Albers equal\[Hyphen]area projection", "TI"],
 ". "
}], "Text",
 CellTags->{"S5.65.1", "1.19"}],

Cell["\<\
The sinusoidal projection gives little distortion near the equator and the \
prime meridian, and is therefore very good for showing Africa. \
\>", "MathCaption",
 CellTags->{"S5.65.1", "1.20"}],

Cell[CellGroupData[{

Cell["\<\
WorldPlot[{Africa, RandomGrays},
      WorldProjection -> Sinusoidal]\
\>", "Input",
 CellLabel->"In[6]:= ",
 CellTags->"S5.65.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.000198413 0.5 0.000198413 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.001 w
[ ] 0 setdash
.2619 .02381 m
.2619 .03333 L
.2619 .04286 L
.2619 .05238 L
.2619 .0619 L
.2619 .07143 L
.2619 .08095 L
.2619 .09048 L
.2619 .1 L
.2619 .10952 L
.2619 .11905 L
.2619 .12857 L
.2619 .1381 L
.2619 .14762 L
.2619 .15714 L
.2619 .16667 L
.2619 .17619 L
.2619 .18571 L
.2619 .19524 L
.2619 .20476 L
.2619 .21429 L
.2619 .22381 L
.2619 .23333 L
.2619 .24286 L
.2619 .25238 L
.2619 .2619 L
.2619 .27143 L
.2619 .28095 L
.2619 .29048 L
.2619 .3 L
.2619 .30952 L
.2619 .31905 L
.2619 .32857 L
.2619 .3381 L
.2619 .34762 L
.2619 .35714 L
.2619 .36667 L
.2619 .37619 L
.2619 .38571 L
.2619 .39524 L
.2619 .40476 L
.2619 .41429 L
.2619 .42381 L
.2619 .43333 L
.2619 .44286 L
.2619 .45238 L
.2619 .4619 L
.2619 .47143 L
.2619 .48095 L
.2619 .49048 L
Mistroke
.2619 .5 L
.2619 .50952 L
.2619 .51905 L
.2619 .52857 L
.2619 .5381 L
.2619 .54762 L
.2619 .55714 L
.2619 .56667 L
.2619 .57619 L
.2619 .58571 L
.2619 .59524 L
.2619 .60476 L
.2619 .61429 L
.2619 .62381 L
.2619 .63333 L
.2619 .64286 L
.2619 .65238 L
.2619 .6619 L
.2619 .67143 L
.2619 .68095 L
.2619 .69048 L
.2619 .7 L
.2619 .70952 L
.2619 .71905 L
.2619 .72857 L
.2619 .7381 L
.2619 .74762 L
.2619 .75714 L
.2619 .76667 L
.2619 .77619 L
.2619 .78571 L
.2619 .79524 L
.2619 .80476 L
.2619 .81429 L
.2619 .82381 L
.2619 .83333 L
.2619 .84286 L
.2619 .85238 L
.2619 .8619 L
.2619 .87143 L
.2619 .88095 L
.2619 .89048 L
.2619 .9 L
.2619 .90952 L
.2619 .91905 L
.2619 .92857 L
.2619 .9381 L
.2619 .94762 L
.2619 .95714 L
.2619 .96667 L
Mistroke
.2619 .97619 L
.2619 .97619 L
Mfstroke
.53549 .02381 m
.53867 .03333 L
.5418 .04286 L
.54487 .05238 L
.54788 .0619 L
.55084 .07143 L
.55374 .08095 L
.55659 .09048 L
.55938 .1 L
.56211 .10952 L
.56478 .11905 L
.56739 .12857 L
.56995 .1381 L
.57244 .14762 L
.57487 .15714 L
.57724 .16667 L
.57955 .17619 L
.5818 .18571 L
.58399 .19524 L
.58611 .20476 L
.58817 .21429 L
.59017 .22381 L
.5921 .23333 L
.59397 .24286 L
.59577 .25238 L
.59751 .2619 L
.59918 .27143 L
.60079 .28095 L
.60233 .29048 L
.6038 .3 L
.60521 .30952 L
.60655 .31905 L
.60783 .32857 L
.60903 .3381 L
.61017 .34762 L
.61124 .35714 L
.61225 .36667 L
.61318 .37619 L
.61405 .38571 L
.61484 .39524 L
.61557 .40476 L
.61623 .41429 L
.61682 .42381 L
.61734 .43333 L
.6178 .44286 L
.61818 .45238 L
.61849 .4619 L
.61873 .47143 L
.61891 .48095 L
.61901 .49048 L
Mistroke
.61905 .5 L
.61901 .50952 L
.61891 .51905 L
.61873 .52857 L
.61849 .5381 L
.61818 .54762 L
.6178 .55714 L
.61734 .56667 L
.61682 .57619 L
.61623 .58571 L
.61557 .59524 L
.61484 .60476 L
.61405 .61429 L
.61318 .62381 L
.61225 .63333 L
.61124 .64286 L
.61017 .65238 L
.60903 .6619 L
.60783 .67143 L
.60655 .68095 L
.60521 .69048 L
.6038 .7 L
.60233 .70952 L
.60079 .71905 L
.59918 .72857 L
.59751 .7381 L
.59577 .74762 L
.59397 .75714 L
.5921 .76667 L
.59017 .77619 L
.58817 .78571 L
.58611 .79524 L
.58399 .80476 L
.5818 .81429 L
.57955 .82381 L
.57724 .83333 L
.57487 .84286 L
.57244 .85238 L
.56995 .8619 L
.56739 .87143 L
.56478 .88095 L
.56211 .89048 L
.55938 .9 L
.55659 .90952 L
.55374 .91905 L
.55084 .92857 L
.54788 .9381 L
.54487 .94762 L
.5418 .95714 L
.53867 .96667 L
Mistroke
.53549 .97619 L
.53549 .97619 L
Mfstroke
.80908 .02381 m
.81544 .03333 L
.82169 .04286 L
.82783 .05238 L
.83386 .0619 L
.83977 .07143 L
.84558 .08095 L
.85127 .09048 L
.85685 .1 L
.86231 .10952 L
.86765 .11905 L
.87288 .12857 L
.87799 .1381 L
.88297 .14762 L
.88784 .15714 L
.89258 .16667 L
.8972 .17619 L
.9017 .18571 L
.90607 .19524 L
.91032 .20476 L
.91444 .21429 L
.91843 .22381 L
.92229 .23333 L
.92603 .24286 L
.92964 .25238 L
.93311 .2619 L
.93646 .27143 L
.93967 .28095 L
.94276 .29048 L
.9457 .3 L
.94852 .30952 L
.9512 .31905 L
.95375 .32857 L
.95616 .3381 L
.95844 .34762 L
.96058 .35714 L
.96259 .36667 L
.96446 .37619 L
.96619 .38571 L
.96778 .39524 L
.96924 .40476 L
.97056 .41429 L
.97174 .42381 L
.97278 .43333 L
.97369 .44286 L
.97445 .45238 L
.97508 .4619 L
.97556 .47143 L
.97591 .48095 L
.97612 .49048 L
Mistroke
.97619 .5 L
.97612 .50952 L
.97591 .51905 L
.97556 .52857 L
.97508 .5381 L
.97445 .54762 L
.97369 .55714 L
.97278 .56667 L
.97174 .57619 L
.97056 .58571 L
.96924 .59524 L
.96778 .60476 L
.96619 .61429 L
.96446 .62381 L
.96259 .63333 L
.96058 .64286 L
.95844 .65238 L
.95616 .6619 L
.95375 .67143 L
.9512 .68095 L
.94852 .69048 L
.9457 .7 L
.94276 .70952 L
.93967 .71905 L
.93646 .72857 L
.93311 .7381 L
.92964 .74762 L
.92603 .75714 L
.92229 .76667 L
.91843 .77619 L
.91444 .78571 L
.91032 .79524 L
.90607 .80476 L
.9017 .81429 L
.8972 .82381 L
.89258 .83333 L
.88784 .84286 L
.88297 .85238 L
.87799 .8619 L
.87288 .87143 L
.86765 .88095 L
.86231 .89048 L
.85685 .9 L
.85127 .90952 L
.84558 .91905 L
.83977 .92857 L
.83386 .9381 L
.82783 .94762 L
.82169 .95714 L
.81544 .96667 L
Mistroke
.80908 .97619 L
.80908 .97619 L
Mfstroke
.05571 .14286 m
.06396 .14286 L
.0722 .14286 L
.08045 .14286 L
.0887 .14286 L
.09695 .14286 L
.1052 .14286 L
.11344 .14286 L
.12169 .14286 L
.12994 .14286 L
.13819 .14286 L
.14643 .14286 L
.15468 .14286 L
.16293 .14286 L
.17118 .14286 L
.17943 .14286 L
.18767 .14286 L
.19592 .14286 L
.20417 .14286 L
.21242 .14286 L
.22067 .14286 L
.22891 .14286 L
.23716 .14286 L
.24541 .14286 L
.25366 .14286 L
.2619 .14286 L
.27015 .14286 L
.2784 .14286 L
.28665 .14286 L
.2949 .14286 L
.30314 .14286 L
.31139 .14286 L
.31964 .14286 L
.32789 .14286 L
.33614 .14286 L
.34438 .14286 L
.35263 .14286 L
.36088 .14286 L
.36913 .14286 L
.37737 .14286 L
.38562 .14286 L
.39387 .14286 L
.40212 .14286 L
.41037 .14286 L
.41861 .14286 L
.42686 .14286 L
.43511 .14286 L
.44336 .14286 L
.45161 .14286 L
.45985 .14286 L
Mistroke
.4681 .14286 L
.47635 .14286 L
.4846 .14286 L
.49284 .14286 L
.50109 .14286 L
.50934 .14286 L
.51759 .14286 L
.52584 .14286 L
.53408 .14286 L
.54233 .14286 L
.55058 .14286 L
.55883 .14286 L
.56708 .14286 L
.57532 .14286 L
.58357 .14286 L
.59182 .14286 L
.60007 .14286 L
.60831 .14286 L
.61656 .14286 L
.62481 .14286 L
.63306 .14286 L
.64131 .14286 L
.64955 .14286 L
.6578 .14286 L
.66605 .14286 L
.6743 .14286 L
.68255 .14286 L
.69079 .14286 L
.69904 .14286 L
.70729 .14286 L
.71554 .14286 L
.72378 .14286 L
.73203 .14286 L
.74028 .14286 L
.74853 .14286 L
.75678 .14286 L
.76502 .14286 L
.77327 .14286 L
.78152 .14286 L
.78977 .14286 L
.79802 .14286 L
.80626 .14286 L
.81451 .14286 L
.82276 .14286 L
.83101 .14286 L
.83926 .14286 L
.8475 .14286 L
.85575 .14286 L
.864 .14286 L
.87225 .14286 L
Mistroke
.88049 .14286 L
.88049 .14286 L
Mfstroke
.02381 .5 m
.03333 .5 L
.04286 .5 L
.05238 .5 L
.0619 .5 L
.07143 .5 L
.08095 .5 L
.09048 .5 L
.1 .5 L
.10952 .5 L
.11905 .5 L
.12857 .5 L
.1381 .5 L
.14762 .5 L
.15714 .5 L
.16667 .5 L
.17619 .5 L
.18571 .5 L
.19524 .5 L
.20476 .5 L
.21429 .5 L
.22381 .5 L
.23333 .5 L
.24286 .5 L
.25238 .5 L
.2619 .5 L
.27143 .5 L
.28095 .5 L
.29048 .5 L
.3 .5 L
.30952 .5 L
.31905 .5 L
.32857 .5 L
.3381 .5 L
.34762 .5 L
.35714 .5 L
.36667 .5 L
.37619 .5 L
.38571 .5 L
.39524 .5 L
.40476 .5 L
.41429 .5 L
.42381 .5 L
.43333 .5 L
.44286 .5 L
.45238 .5 L
.4619 .5 L
.47143 .5 L
.48095 .5 L
.49048 .5 L
Mistroke
.5 .5 L
.50952 .5 L
.51905 .5 L
.52857 .5 L
.5381 .5 L
.54762 .5 L
.55714 .5 L
.56667 .5 L
.57619 .5 L
.58571 .5 L
.59524 .5 L
.60476 .5 L
.61429 .5 L
.62381 .5 L
.63333 .5 L
.64286 .5 L
.65238 .5 L
.6619 .5 L
.67143 .5 L
.68095 .5 L
.69048 .5 L
.7 .5 L
.70952 .5 L
.71905 .5 L
.72857 .5 L
.7381 .5 L
.74762 .5 L
.75714 .5 L
.76667 .5 L
.77619 .5 L
.78571 .5 L
.79524 .5 L
.80476 .5 L
.81429 .5 L
.82381 .5 L
.83333 .5 L
.84286 .5 L
.85238 .5 L
.8619 .5 L
.87143 .5 L
.88095 .5 L
.89048 .5 L
.9 .5 L
.90952 .5 L
.91905 .5 L
.92857 .5 L
.9381 .5 L
.94762 .5 L
.95714 .5 L
.96667 .5 L
Mistroke
.97619 .5 L
.97619 .5 L
Mfstroke
.05571 .85714 m
.06396 .85714 L
.0722 .85714 L
.08045 .85714 L
.0887 .85714 L
.09695 .85714 L
.1052 .85714 L
.11344 .85714 L
.12169 .85714 L
.12994 .85714 L
.13819 .85714 L
.14643 .85714 L
.15468 .85714 L
.16293 .85714 L
.17118 .85714 L
.17943 .85714 L
.18767 .85714 L
.19592 .85714 L
.20417 .85714 L
.21242 .85714 L
.22067 .85714 L
.22891 .85714 L
.23716 .85714 L
.24541 .85714 L
.25366 .85714 L
.2619 .85714 L
.27015 .85714 L
.2784 .85714 L
.28665 .85714 L
.2949 .85714 L
.30314 .85714 L
.31139 .85714 L
.31964 .85714 L
.32789 .85714 L
.33614 .85714 L
.34438 .85714 L
.35263 .85714 L
.36088 .85714 L
.36913 .85714 L
.37737 .85714 L
.38562 .85714 L
.39387 .85714 L
.40212 .85714 L
.41037 .85714 L
.41861 .85714 L
.42686 .85714 L
.43511 .85714 L
.44336 .85714 L
.45161 .85714 L
.45985 .85714 L
Mistroke
.4681 .85714 L
.47635 .85714 L
.4846 .85714 L
.49284 .85714 L
.50109 .85714 L
.50934 .85714 L
.51759 .85714 L
.52584 .85714 L
.53408 .85714 L
.54233 .85714 L
.55058 .85714 L
.55883 .85714 L
.56708 .85714 L
.57532 .85714 L
.58357 .85714 L
.59182 .85714 L
.60007 .85714 L
.60831 .85714 L
.61656 .85714 L
.62481 .85714 L
.63306 .85714 L
.64131 .85714 L
.64955 .85714 L
.6578 .85714 L
.66605 .85714 L
.6743 .85714 L
.68255 .85714 L
.69079 .85714 L
.69904 .85714 L
.70729 .85714 L
.71554 .85714 L
.72378 .85714 L
.73203 .85714 L
.74028 .85714 L
.74853 .85714 L
.75678 .85714 L
.76502 .85714 L
.77327 .85714 L
.78152 .85714 L
.78977 .85714 L
.79802 .85714 L
.80626 .85714 L
.81451 .85714 L
.82276 .85714 L
.83101 .85714 L
.83926 .85714 L
.8475 .85714 L
.85575 .85714 L
.864 .85714 L
.87225 .85714 L
Mistroke
.88049 .85714 L
.88049 .85714 L
Mfstroke
.341 g
.3439 .93968 m
.2619 .92659 L
.24031 .91766 L
.24997 .88214 L
.22325 .87738 L
.22482 .86865 L
.17142 .84187 L
.17053 .82937 L
.17021 .8248 L
.21012 .79762 L
.2619 .75992 L
.3097 .72798 L
.3929 .77996 L
.36236 .81131 L
.35996 .85992 L
.33603 .90337 L
.3439 .93968 L
F
.617 g
.41803 .43016 m
.40691 .42738 L
.42272 .35952 L
.39568 .29464 L
.4193 .29365 L
.52833 .29008 L
.51345 .30754 L
.5171 .34524 L
.54049 .34524 L
.5423 .37063 L
.52106 .37063 L
.51914 .41329 L
.47405 .40357 L
.46247 .41369 L
.4575 .42996 L
.41803 .43036 L
F
.719 g
.28123 .57401 m
.29424 .57579 L
.30348 .63988 L
.28986 .64147 L
.2732 .63095 L
.28123 .57401 L
F
.896 g
.5483 .2881 m
.49924 .28194 L
.48266 .2381 L
.4781 .20516 L
.48127 .18056 L
.50659 .19464 L
.5357 .19444 L
.58578 .23571 L
.5483 .2881 L
F
.302 g
.2304 .6129 m
.19732 .62421 L
.21599 .66071 L
.2619 .67857 L
.26459 .67857 L
.28986 .64167 L
.2732 .63095 L
.25996 .63254 L
.22879 .63095 L
.2304 .6129 L
F
.007 g
.60694 .46726 m
.61105 .44702 L
.62547 .47143 L
.60694 .46726 L
F
.975 g
.37867 .52798 m
.37767 .54921 L
.36392 .55734 L
.37775 .58095 L
.40229 .58433 L
.43277 .6377 L
.42502 .65575 L
.44578 .61885 L
.42563 .61468 L
.44484 .58968 L
.43258 .57202 L
.45462 .52639 L
.42012 .52579 L
.39673 .52579 L
.37867 .52798 L
F
.763 g
.44484 .58968 m
.48096 .59563 L
.528 .63036 L
.5294 .62996 L
.53863 .60377 L
.58744 .55972 L
.52709 .54921 L
.48962 .55913 L
.48332 .54147 L
.45896 .54147 L
.45462 .52639 L
.43258 .57202 L
.44484 .58968 L
F
.472 g
.53123 .73214 m
.43658 .77976 L
.42628 .77381 L
.44049 .74226 L
.43827 .70119 L
.41958 .66329 L
.42502 .65575 L
.44578 .61885 L
.42563 .61468 L
.44484 .58968 L
.48096 .59563 L
.528 .63036 L
.51537 .65238 L
.52493 .68512 L
.53696 .6869 L
.53123 .73214 L
F
.271 g
.39453 .45298 m
.40461 .44028 L
.41715 .44484 L
.45075 .45337 L
.48332 .54147 L
.45896 .54147 L
.45462 .52639 L
.42012 .52579 L
.41861 .51468 L
.4345 .51111 L
.43383 .47738 L
.39969 .47222 L
.39453 .45298 L
F
.81 g
.76681 .6371 m
.75784 .6373 L
.76261 .65139 L
.74912 .6371 L
.76382 .63095 L
.76681 .6371 L
F
.247 g
.65182 .7754 m
.59659 .85238 L
.6228 .83016 L
.62403 .85179 L
.62358 .85099 L
.61078 .87163 L
.60984 .87302 L
.51678 .87679 L
.53785 .7619 L
.63711 .75893 L
.65182 .7754 L
F
.61 g
.37855 .5119 m
.37867 .52798 L
.39673 .52579 L
.397 .5119 L
.37855 .5119 L
F
.363 g
.68246 .67103 m
.68298 .70317 L
.69904 .71468 L
.71843 .67956 L
.76261 .65139 L
.75815 .64663 L
.70921 .67421 L
.68246 .67103 L
F
.921 g
.68246 .67103 m
.70921 .67421 L
.75815 .64663 L
.74912 .6371 L
.76382 .63095 L
.77946 .60714 L
.82758 .59524 L
.79507 .55833 L
.75951 .54742 L
.7315 .54087 L
.68829 .55496 L
.65081 .59444 L
.66314 .6256 L
.68173 .65119 L
.68246 .67103 L
F
.24 g
.37855 .5119 m
.36567 .49246 L
.39453 .45298 L
.39969 .47222 L
.43383 .47738 L
.4345 .51111 L
.41861 .51468 L
.42012 .52579 L
.39673 .52579 L
.397 .5119 L
.37855 .5119 L
F
.485 g
.22515 .56052 m
.2619 .56687 L
.27611 .57262 L
.2619 .62619 L
.26093 .62738 L
.2619 .63214 L
.26015 .63254 L
.22879 .63095 L
.2304 .6129 L
.22515 .56052 L
F
.854 g
.10554 .60754 m
.08639 .63036 L
.1026 .65099 L
.12997 .64841 L
.12974 .64762 L
.15746 .64762 L
.16835 .62083 L
.16855 .62103 L
.16199 .59008 L
.14102 .60099 L
.1304 .61905 L
.10554 .60754 L
F
.6 g
.06748 .64663 m
.08721 .64246 L
.08098 .63492 L
.08639 .63036 L
.1026 .65099 L
.06748 .64663 L
F
.436 g
.17248 .55179 m
.22515 .56052 L
.22515 .56052 L
.2304 .6129 L
.2304 .6129 L
.19732 .6244 L
.19732 .62421 L
.16855 .62103 L
.16855 .62103 L
.16199 .59008 L
.16199 .59008 L
.17268 .55179 L
F
.774 g
.75654 .48016 m
.72702 .44444 L
.66561 .4881 L
.67873 .52282 L
.66557 .5502 L
.68829 .55496 L
.7315 .54087 L
.75971 .54742 L
.74921 .53373 L
.75654 .48016 L
F
.964 g
.126 .58254 m
.17248 .55179 L
.16199 .59008 L
.14102 .60099 L
.126 .58254 L
F
.107 g
.37684 .89484 m
.42378 .87282 L
.46066 .86052 L
.47885 .89226 L
.51678 .87679 L
.53785 .7619 L
.53785 .7619 L
.54158 .7381 L
.53123 .73214 L
.43658 .77976 L
.42594 .77361 L
.3929 .77996 L
.36236 .81131 L
.35996 .85992 L
.37684 .89484 L
F
.511 g
.74048 .23968 m
.76006 .2625 L
.77029 .30734 L
.81446 .32421 L
.8359 .35774 L
.84174 .31766 L
.83115 .31488 L
.77051 .20258 L
.73755 .20298 L
.74048 .23968 L
F
.433 g
.6492 .3871 m
.66475 .38413 L
.66953 .3623 L
.66229 .34107 L
.67514 .32282 L
.6633 .29603 L
.65977 .32639 L
.64557 .33313 L
.6492 .3871 L
F
.347 g
.3097 .72798 m
.2619 .75992 L
.21012 .79762 L
.19087 .79762 L
.19881 .68452 L
.13008 .68631 L
.12317 .6754 L
.12089 .67579 L
.12997 .64841 L
.12974 .64762 L
.15746 .64762 L
.16855 .62103 L
.19732 .62421 L
.21599 .66071 L
.2619 .67857 L
.26459 .67857 L
.30641 .6871 L
.3097 .72798 L
F
.388 g
.07212 .74722 m
.08093 .74067 L
.07275 .69107 L
.10878 .69087 L
.12316 .6752 L
.13008 .68631 L
.19881 .68452 L
.19087 .79762 L
.21012 .79762 L
.17022 .825 L
.16917 .80952 L
.13351 .80952 L
.11824 .77262 L
.11775 .75397 L
.07212 .74722 L
F
.615 g
.24048 .91786 m
.20968 .92758 L
.20113 .91687 L
.16875 .8875 L
.15568 .84901 L
.1229 .82937 L
.17053 .82937 L
.17142 .84187 L
.22482 .86865 L
.22325 .87738 L
.24997 .88214 L
.24048 .91786 L
F
.131 g
.73522 .3752 m
.72891 .31806 L
.64953 .26647 L
.64769 .2131 L
.61423 .19524 L
.61135 .18036 L
.60325 .18056 L
.60409 .19107 L
.60637 .23313 L
.63136 .26151 L
.63797 .30099 L
.61061 .31389 L
.64557 .33313 L
.65977 .32639 L
.6633 .29603 L
.67514 .32282 L
.66229 .34107 L
.66953 .3623 L
.73522 .3752 L
F
.34 g
.39568 .29464 m
.42154 .22996 L
.4201 .2246 L
.43422 .15972 L
.47128 .16151 L
.4781 .20516 L
.48266 .2381 L
.49924 .28194 L
.5483 .2881 L
.52833 .29008 L
.4193 .29365 L
.39568 .29464 L
F
.413 g
.42594 .77361 m
.39271 .77996 L
.3097 .72798 L
.30641 .6871 L
.26459 .67857 L
.28986 .64167 L
.30348 .63988 L
.30387 .63929 L
.31837 .66409 L
.37374 .65238 L
.41958 .66329 L
.43827 .70119 L
.44049 .74226 L
.42594 .77361 L
F
.852 g
.36373 .55714 m
.33432 .55079 L
.32447 .57024 L
.29405 .57579 L
.30348 .63988 L
.30387 .63929 L
.31837 .66409 L
.37374 .65238 L
.41958 .66329 L
.42522 .65556 L
.43277 .6377 L
.40229 .58433 L
.37775 .58095 L
.36373 .55714 L
F
.659 g
.43422 .15972 m
.44233 .09325 L
.45738 .08552 L
.54036 .10675 L
.61135 .18036 L
.60325 .18056 L
.58936 .18095 L
.60404 .19087 L
.60637 .23313 L
.58563 .23591 L
.5357 .19444 L
.50659 .19464 L
.48127 .18056 L
.4781 .20516 L
.47128 .16151 L
.43422 .15972 L
F
.07 g
.56183 .15933 m
.54147 .14722 L
.54965 .13492 L
.5675 .1506 L
.56183 .15933 L
F
.604 g
.61418 .48353 m
.60694 .46726 L
.62547 .47143 L
.62474 .4873 L
.61418 .48353 L
F
.605 g
.07277 .69127 m
.06005 .6756 L
.0702 .66171 L
.10208 .65933 L
.06766 .65556 L
.08334 .65278 L
.06748 .64663 L
.1026 .65099 L
.12997 .64841 L
.12089 .67579 L
.12316 .6752 L
.10878 .69087 L
.07275 .69107 L
F
.049 g
.10554 .60754 m
.1262 .58254 L
.14122 .60099 L
.1304 .61905 L
.10554 .60754 L
F
.706 g
.75634 .48016 m
.831 .55317 L
.86386 .6244 L
.85326 .64286 L
.78781 .62401 L
.76681 .6371 L
.76648 .63671 L
.76382 .63095 L
.77946 .60714 L
.82758 .59524 L
.79507 .55833 L
.75951 .54742 L
.74921 .53373 L
.75634 .48016 L
F
.683 g
.69904 .71468 m
.66911 .7623 L
.65182 .7754 L
.63711 .75893 L
.53785 .7619 L
.54158 .7381 L
.53123 .73214 L
.53696 .6869 L
.52493 .68512 L
.51537 .65238 L
.528 .63036 L
.5294 .62996 L
.53863 .60377 L
.58744 .55972 L
.62869 .54147 L
.66557 .5502 L
.68829 .55496 L
.65081 .59444 L
.66314 .6256 L
.68173 .65119 L
.68298 .70317 L
.69904 .71468 L
F
.365 g
.60325 .18056 m
.60409 .19107 L
.58936 .18095 L
.60325 .18056 L
F
.564 g
.73522 .3752 m
.72104 .42798 L
.72702 .44444 L
.66561 .4881 L
.62474 .4873 L
.62547 .47143 L
.61105 .44702 L
.62445 .40258 L
.64927 .3879 L
.66475 .38413 L
.66972 .3623 L
.73522 .3752 L
F
.852 g
.0702 .66171 m
.08476 .66012 L
.06764 .65516 L
.06766 .65556 L
.10208 .65933 L
.0702 .66171 L
F
.083 g
.27611 .57262 m
.28143 .57401 L
.27262 .63095 L
.25996 .63254 L
.2619 .63214 L
.26093 .62738 L
.2619 .62619 L
.27611 .57262 L
F
.929 g
.3439 .93968 m
.36685 .94147 L
.36041 .90675 L
.37684 .89484 L
.35996 .85992 L
.33603 .90337 L
.3439 .93968 L
F
.79 g
.62869 .54147 m
.63427 .5252 L
.61418 .48353 L
.62474 .4873 L
.66561 .4881 L
.67873 .52282 L
.66557 .5502 L
.62869 .54147 L
F
.888 g
.1229 .82937 m
.07212 .74722 L
.11775 .75397 L
.11824 .77262 L
.13351 .80952 L
.16917 .80952 L
.17022 .825 L
.17053 .82937 L
.1229 .82937 L
F
.976 g
.41803 .43016 m
.4064 .43115 L
.41735 .44484 L
.45075 .45337 L
.48332 .54147 L
.48962 .55913 L
.52709 .54921 L
.58744 .55972 L
.62869 .54147 L
.63427 .5252 L
.61418 .48353 L
.60715 .46746 L
.61105 .44702 L
.62445 .40258 L
.5952 .38968 L
.59276 .3625 L
.60872 .35536 L
.60694 .33988 L
.57914 .3623 L
.5423 .37063 L
.52106 .37063 L
.51914 .41329 L
.47405 .40357 L
.46247 .41369 L
.4575 .42996 L
.41803 .43016 L
F
.418 g
.62445 .40258 m
.5952 .38968 L
.59276 .3625 L
.60872 .35536 L
.60694 .33988 L
.57914 .3623 L
.5423 .37063 L
.54049 .34524 L
.5171 .34524 L
.51345 .30754 L
.52833 .29008 L
.5483 .2881 L
.56965 .2881 L
.61061 .31389 L
.64557 .33313 L
.6492 .3871 L
.64927 .3879 L
.62443 .40238 L
F
.357 g
.60637 .23313 m
.58563 .23591 L
.5483 .2881 L
.56965 .2881 L
.61061 .31389 L
.63797 .30099 L
.63136 .26151 L
.60637 .23313 L
F
0 g
.80908 .97619 m
.80908 .97619 L
.81544 .96667 L
.82169 .95714 L
.82783 .94762 L
.83386 .9381 L
.83977 .92857 L
.84558 .91905 L
.85127 .90952 L
.85685 .9 L
.86231 .89048 L
.86765 .88095 L
.87288 .87143 L
.87799 .8619 L
.88297 .85238 L
.88784 .84286 L
.89258 .83333 L
.8972 .82381 L
.9017 .81429 L
.90607 .80476 L
.91032 .79524 L
.91444 .78571 L
.91843 .77619 L
.92229 .76667 L
.92603 .75714 L
.92964 .74762 L
.93311 .7381 L
.93646 .72857 L
.93967 .71905 L
.94276 .70952 L
.9457 .7 L
.94852 .69048 L
.9512 .68095 L
.95375 .67143 L
.95616 .6619 L
.95844 .65238 L
.96058 .64286 L
.96259 .63333 L
.96446 .62381 L
.96619 .61429 L
.96778 .60476 L
.96924 .59524 L
.97056 .58571 L
.97174 .57619 L
.97278 .56667 L
.97369 .55714 L
.97445 .54762 L
.97508 .5381 L
.97556 .52857 L
.97591 .51905 L
Mistroke
.97612 .50952 L
.97619 .5 L
.97612 .49048 L
.97591 .48095 L
.97556 .47143 L
.97508 .4619 L
.97445 .45238 L
.97369 .44286 L
.97278 .43333 L
.97174 .42381 L
.97056 .41429 L
.96924 .40476 L
.96778 .39524 L
.96619 .38571 L
.96446 .37619 L
.96259 .36667 L
.96058 .35714 L
.95844 .34762 L
.95616 .3381 L
.95375 .32857 L
.9512 .31905 L
.94852 .30952 L
.9457 .3 L
.94276 .29048 L
.93967 .28095 L
.93646 .27143 L
.93311 .2619 L
.92964 .25238 L
.92603 .24286 L
.92229 .23333 L
.91843 .22381 L
.91444 .21429 L
.91032 .20476 L
.90607 .19524 L
.9017 .18571 L
.8972 .17619 L
.89258 .16667 L
.88784 .15714 L
.88297 .14762 L
.87799 .1381 L
.87288 .12857 L
.86765 .11905 L
.86231 .10952 L
.85685 .1 L
.85127 .09048 L
.84558 .08095 L
.83977 .07143 L
.83386 .0619 L
.82783 .05238 L
.82169 .04286 L
Mistroke
.81544 .03333 L
.80908 .02381 L
Mfstroke
.80908 .02381 m
.80908 .02381 L
.80178 .02381 L
.79449 .02381 L
.78719 .02381 L
.7799 .02381 L
.7726 .02381 L
.76531 .02381 L
.75801 .02381 L
.75071 .02381 L
.74342 .02381 L
.73612 .02381 L
.72883 .02381 L
.72153 .02381 L
.71424 .02381 L
.70694 .02381 L
.69964 .02381 L
.69235 .02381 L
.68505 .02381 L
.67776 .02381 L
.67046 .02381 L
.66317 .02381 L
.65587 .02381 L
.64857 .02381 L
.64128 .02381 L
.63398 .02381 L
.62669 .02381 L
.61939 .02381 L
.6121 .02381 L
.6048 .02381 L
.59751 .02381 L
.59021 .02381 L
.58291 .02381 L
.57562 .02381 L
.56832 .02381 L
.56103 .02381 L
.55373 .02381 L
.54644 .02381 L
.53914 .02381 L
.53184 .02381 L
.52455 .02381 L
.51725 .02381 L
.50996 .02381 L
.50266 .02381 L
.49537 .02381 L
.48807 .02381 L
.48077 .02381 L
.47348 .02381 L
.46618 .02381 L
.45889 .02381 L
Mistroke
.45159 .02381 L
.4443 .02381 L
.437 .02381 L
.4297 .02381 L
.42241 .02381 L
.41511 .02381 L
.40782 .02381 L
.40052 .02381 L
.39323 .02381 L
.38593 .02381 L
.37864 .02381 L
.37134 .02381 L
.36404 .02381 L
.35675 .02381 L
.34945 .02381 L
.34216 .02381 L
.33486 .02381 L
.32757 .02381 L
.32027 .02381 L
.31297 .02381 L
.30568 .02381 L
.29838 .02381 L
.29109 .02381 L
.28379 .02381 L
.2765 .02381 L
.2692 .02381 L
.2619 .02381 L
.25461 .02381 L
.24731 .02381 L
.24002 .02381 L
.23272 .02381 L
.22543 .02381 L
.21813 .02381 L
.21084 .02381 L
.20354 .02381 L
.19624 .02381 L
.18895 .02381 L
.18165 .02381 L
.17436 .02381 L
.16706 .02381 L
.15977 .02381 L
.15247 .02381 L
.14517 .02381 L
.13788 .02381 L
.13058 .02381 L
.12329 .02381 L
.11599 .02381 L
.1087 .02381 L
.1014 .02381 L
.0941 .02381 L
Mistroke
.08681 .02381 L
.07951 .02381 L
Mfstroke
.07951 .02381 m
.07739 .03333 L
.07531 .04286 L
.07326 .05238 L
.07125 .0619 L
.06928 .07143 L
.06735 .08095 L
.06545 .09048 L
.06359 .1 L
.06177 .10952 L
.05999 .11905 L
.05825 .12857 L
.05654 .1381 L
.05488 .14762 L
.05326 .15714 L
.05168 .16667 L
.05014 .17619 L
.04864 .18571 L
.04718 .19524 L
.04577 .20476 L
.04439 .21429 L
.04306 .22381 L
.04177 .23333 L
.04053 .24286 L
.03933 .25238 L
.03817 .2619 L
.03705 .27143 L
.03598 .28095 L
.03495 .29048 L
.03397 .3 L
.03303 .30952 L
.03214 .31905 L
.03129 .32857 L
.03049 .3381 L
.02973 .34762 L
.02901 .35714 L
.02834 .36667 L
.02772 .37619 L
.02714 .38571 L
.02661 .39524 L
.02613 .40476 L
.02569 .41429 L
.02529 .42381 L
.02495 .43333 L
.02464 .44286 L
.02439 .45238 L
.02418 .4619 L
.02402 .47143 L
.0239 .48095 L
.02383 .49048 L
Mistroke
.02381 .5 L
.02383 .50952 L
.0239 .51905 L
.02402 .52857 L
.02418 .5381 L
.02439 .54762 L
.02464 .55714 L
.02495 .56667 L
.02529 .57619 L
.02569 .58571 L
.02613 .59524 L
.02661 .60476 L
.02714 .61429 L
.02772 .62381 L
.02834 .63333 L
.02901 .64286 L
.02973 .65238 L
.03049 .6619 L
.03129 .67143 L
.03214 .68095 L
.03303 .69048 L
.03397 .7 L
.03495 .70952 L
.03598 .71905 L
.03705 .72857 L
.03817 .7381 L
.03933 .74762 L
.04053 .75714 L
.04177 .76667 L
.04306 .77619 L
.04439 .78571 L
.04577 .79524 L
.04718 .80476 L
.04864 .81429 L
.05014 .82381 L
.05168 .83333 L
.05326 .84286 L
.05488 .85238 L
.05654 .8619 L
.05825 .87143 L
.05999 .88095 L
.06177 .89048 L
.06359 .9 L
.06545 .90952 L
.06735 .91905 L
.06928 .92857 L
.07125 .9381 L
.07326 .94762 L
.07531 .95714 L
.07739 .96667 L
Mistroke
.07951 .97619 L
.07951 .97619 L
Mfstroke
.07951 .97619 m
.08681 .97619 L
.0941 .97619 L
.1014 .97619 L
.1087 .97619 L
.11599 .97619 L
.12329 .97619 L
.13058 .97619 L
.13788 .97619 L
.14517 .97619 L
.15247 .97619 L
.15977 .97619 L
.16706 .97619 L
.17436 .97619 L
.18165 .97619 L
.18895 .97619 L
.19624 .97619 L
.20354 .97619 L
.21084 .97619 L
.21813 .97619 L
.22543 .97619 L
.23272 .97619 L
.24002 .97619 L
.24731 .97619 L
.25461 .97619 L
.2619 .97619 L
.2692 .97619 L
.2765 .97619 L
.28379 .97619 L
.29109 .97619 L
.29838 .97619 L
.30568 .97619 L
.31297 .97619 L
.32027 .97619 L
.32757 .97619 L
.33486 .97619 L
.34216 .97619 L
.34945 .97619 L
.35675 .97619 L
.36404 .97619 L
.37134 .97619 L
.37864 .97619 L
.38593 .97619 L
.39323 .97619 L
.40052 .97619 L
.40782 .97619 L
.41511 .97619 L
.42241 .97619 L
.4297 .97619 L
.437 .97619 L
Mistroke
.4443 .97619 L
.45159 .97619 L
.45889 .97619 L
.46618 .97619 L
.47348 .97619 L
.48077 .97619 L
.48807 .97619 L
.49537 .97619 L
.50266 .97619 L
.50996 .97619 L
.51725 .97619 L
.52455 .97619 L
.53184 .97619 L
.53914 .97619 L
.54644 .97619 L
.55373 .97619 L
.56103 .97619 L
.56832 .97619 L
.57562 .97619 L
.58291 .97619 L
.59021 .97619 L
.59751 .97619 L
.6048 .97619 L
.6121 .97619 L
.61939 .97619 L
.62669 .97619 L
.63398 .97619 L
.64128 .97619 L
.64857 .97619 L
.65587 .97619 L
.66317 .97619 L
.67046 .97619 L
.67776 .97619 L
.68505 .97619 L
.69235 .97619 L
.69964 .97619 L
.70694 .97619 L
.71424 .97619 L
.72153 .97619 L
.72883 .97619 L
.73612 .97619 L
.74342 .97619 L
.75071 .97619 L
.75801 .97619 L
.76531 .97619 L
.7726 .97619 L
.7799 .97619 L
.78719 .97619 L
.79449 .97619 L
.80178 .97619 L
Mistroke
.80908 .97619 L
.80908 .97619 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.65.1"],

Cell[BoxData["\<\"-WorldGraphics-\"\>"], "Output",
 CellLabel->"Out[6]= ",
 CellTags->"S5.65.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldBorders", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["style to display borders of countries; with ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", no borders are drawn ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldCountries", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["World", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "name of the list of allowable country names ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldDatabase", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["WorldData", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "name of the database containing polygon data for countries ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldToGraphics", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["whether to return a standard ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["Graphics", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Some options for ",
 StyleBox["WorldPlot", "MR"],
 "."
}], "Caption",
 CellTags->"S5.65.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["option name", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["default value", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldBackground", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "style to use for the background polygon ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldClipping", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Full", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "specify what happens to lines or polygons that are partially outside \
the plot range",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldFrame", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["style to use for the frame around the map; with ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["None", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", no boundary is drawn ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldFrameParts", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["{1,", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1,", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1,", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["1}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "what parts of the frame to draw",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldGrid", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "locations of parallels and meridians to be drawn",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldGridBehind", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["whether the grid is drawn behind (",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[") or in front (",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[") of the countries",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldGridStyle", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Thickness[.001]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox["style for the grid",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldPoints", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["100", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "number of divisions used in plotting grid lines and clipping polygons ",
      
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldProjection", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Equirectangular", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "function to use for the projection ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldRange", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["Automatic", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "portion of the surface of the Earth to be drawn; specifications must \
be of form ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["{", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["minlat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["maxlat", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["minlong", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["maxlong", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[Cell[BoxData[
       FormBox["}", TraditionalForm]], "InlineFormula",
       GridBoxOptions->{ColumnWidths->Automatic}],
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldRotatedRange", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["False", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox[
      "coordinate system to which the range specification is applied; with ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["True", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", it is applied to the system resulting from ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["WorldRotation", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["WorldRotation", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["{0,", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["0,", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}],
      StyleBox["0}", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->{True, False},
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "rotation to be applied to coordinates before projection ",
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->{True, False},
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
 GridBoxOptions->{RowLines->{True, False},
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "More options for ",
 StyleBox["WorldPlot", "MR"],
 ". These options can also be used in ",
 StyleBox["WorldGraphics", "MR"],
 "."
}], "Caption",
 CellTags->"S5.65.1"],

Cell[TextData[{
 "To specify how the borders of countries are to be drawn, you set the ",
 StyleBox["WorldBorders", "MR"],
 " option. The settings for this option can be ",
 StyleBox["None", "MR"],
 ", ",
 StyleBox["Automatic", "MR"],
 ", or a style list. With the setting ",
 StyleBox["Automatic", "MR"],
 " the borders are drawn with the style ",
 StyleBox["{GrayLevel[0],", "MR"],
 " ",
 StyleBox["Thickness[.001]}", "MR"],
 " unless a style list for the shading of the countries is given. If this is \
the case, no borders are drawn. "
}], "Text",
 CellTags->{"S5.65.1", "1.21"}],

Cell[TextData[{
 "The style of the frame around the map is controlled by the ",
 StyleBox["WorldFrame", "MR"],
 " option. To determine which portion of the frame is to be drawn, specify ",
 StyleBox["WorldFrameParts -> {", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["s",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["s",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["s",
     "TI"], "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["s",
     "TI"], "4"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 ". Each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["s",
     "TI"], 
    StyleBox["i",
     "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " is either ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " or ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and specifies whether a portion of the frame is drawn (",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ") or not (",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 "). The sides are ordered clockwise, with the eastern side given first. "
}], "Text",
 CellTags->{"S5.65.1", "1.22"}],

Cell[TextData[{
 StyleBox["WorldGrid", "MR"],
 " controls the drawing of parallels and meridians. A setting for this option \
of the form ",
 StyleBox["WorldGrid->{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["deg",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["deg",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 " specifies the spacing of the latitude and longitude lines that are drawn \
beginning with the equator or a prime meridian. A setting of ",
 StyleBox["WorldGrid->", "MR"],
 StyleBox["deg", "TI"],
 " is the same as ",
 StyleBox["WorldGrid->{", "MR"],
 StyleBox["deg", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["deg", "TI"],
 StyleBox["}", "MR"],
 ". You can explicitly specify which latitude and longitude lines you want \
drawn with ",
 StyleBox["WorldGrid->{{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["lat",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["lat",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", \[Ellipsis] }, {", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["lat",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["lat",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", \[Ellipsis] }}", "MR"],
 ". The default setting ",
 StyleBox["Automatic", "MR"],
 " is equivalent to ",
 StyleBox["WorldGrid->30", "MR"],
 ". Note that all settings are given in degrees. "
}], "Text",
 CellTags->{"S5.65.1", "1.23"}],

Cell[TextData[{
 "One of the most time\[Hyphen]intensive parts of the plot is clipping \
polygons or lines that are partially outside the plot range. The way this \
clipping is done is determined by the option ",
 StyleBox["WorldClipping", "MR"],
 ". The default setting ",
 StyleBox["Full", "MR"],
 " causes these objects to be properly clipped at the edge of the plot range. \
To save rendering time you can reset this option at ",
 StyleBox["Simple", "MR"],
 ", which causes objects outside the plot range to not be rendered, or ",
 StyleBox["None", "MR"],
 ", which causes the entire object to be rendered. "
}], "Text",
 CellTags->{"S5.65.1", "1.24"}],

Cell["\<\
In this map of Africa the background is light gray, there are no grid lines, \
and the frame around the map is somewhat thicker than usual. \
\>", "MathCaption",
 CellTags->{"S5.65.1", "1.25"}],

Cell[CellGroupData[{

Cell["\<\
afmap = WorldPlot[Africa,
   WorldBackground -> GrayLevel[0.7],
   WorldGrid -> None,
   WorldFrame -> Thickness[.012],
   WorldProjection -> LambertCylindrical]\
\>", "Input",
 CellLabel->"In[7]:= ",
 CellTags->"S5.65.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.44627 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.000198413 0.723136 0.000198413 [
[ 0 0 0 0 ]
[ 1 1.44627 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.44627 L
0 1.44627 L
closepath
clip
newpath
.7 g
.97619 1.41184 m
.97619 1.41184 L
.97619 1.40031 L
.97619 1.38865 L
.97619 1.37686 L
.97619 1.36495 L
.97619 1.35291 L
.97619 1.34074 L
.97619 1.32846 L
.97619 1.31606 L
.97619 1.30354 L
.97619 1.29091 L
.97619 1.27816 L
.97619 1.26532 L
.97619 1.25236 L
.97619 1.2393 L
.97619 1.22614 L
.97619 1.21288 L
.97619 1.19953 L
.97619 1.18609 L
.97619 1.17255 L
.97619 1.15893 L
.97619 1.14522 L
.97619 1.13143 L
.97619 1.11756 L
.97619 1.10361 L
.97619 1.08959 L
.97619 1.07549 L
.97619 1.06133 L
.97619 1.0471 L
.97619 1.03281 L
.97619 1.01846 L
.97619 1.00405 L
.97619 .98959 L
.97619 .97507 L
.97619 .96051 L
.97619 .9459 L
.97619 .93124 L
.97619 .91655 L
.97619 .90182 L
.97619 .88705 L
.97619 .87225 L
.97619 .85742 L
.97619 .84257 L
.97619 .82769 L
.97619 .81279 L
.97619 .79788 L
.97619 .78294 L
.97619 .768 L
.97619 .75305 L
.97619 .7381 L
.97619 .72314 L
.97619 .70818 L
.97619 .69322 L
.97619 .67827 L
.97619 .66333 L
.97619 .6484 L
.97619 .63348 L
.97619 .61858 L
.97619 .60371 L
.97619 .58885 L
.97619 .57402 L
.97619 .55922 L
.97619 .54446 L
.97619 .52972 L
.97619 .51503 L
.97619 .50037 L
.97619 .48576 L
.97619 .4712 L
.97619 .45668 L
.97619 .44222 L
.97619 .42781 L
.97619 .41346 L
.97619 .39917 L
.97619 .38494 L
.97619 .37078 L
.97619 .35669 L
.97619 .34266 L
.97619 .32872 L
.97619 .31485 L
.97619 .30106 L
.97619 .28735 L
.97619 .27372 L
.97619 .26019 L
.97619 .24674 L
.97619 .23339 L
.97619 .22013 L
.97619 .20697 L
.97619 .19391 L
.97619 .18096 L
.97619 .16811 L
.97619 .15537 L
.97619 .14273 L
.97619 .13022 L
.97619 .11781 L
.97619 .10553 L
.97619 .09337 L
.97619 .08133 L
.97619 .06941 L
.97619 .05762 L
.97619 .04596 L
.97619 .03444 L
.97619 .03444 L
.97619 .03444 L
.96667 .03444 L
.95714 .03444 L
.94762 .03444 L
.9381 .03444 L
.92857 .03444 L
.91905 .03444 L
.90952 .03444 L
.9 .03444 L
.89048 .03444 L
.88095 .03444 L
.87143 .03444 L
.8619 .03444 L
.85238 .03444 L
.84286 .03444 L
.83333 .03444 L
.82381 .03444 L
.81429 .03444 L
.80476 .03444 L
.79524 .03444 L
.78571 .03444 L
.77619 .03444 L
.76667 .03444 L
.75714 .03444 L
.74762 .03444 L
.7381 .03444 L
.72857 .03444 L
.71905 .03444 L
.70952 .03444 L
.7 .03444 L
.69048 .03444 L
.68095 .03444 L
.67143 .03444 L
.6619 .03444 L
.65238 .03444 L
.64286 .03444 L
.63333 .03444 L
.62381 .03444 L
.61429 .03444 L
.60476 .03444 L
.59524 .03444 L
.58571 .03444 L
.57619 .03444 L
.56667 .03444 L
.55714 .03444 L
.54762 .03444 L
.5381 .03444 L
.52857 .03444 L
.51905 .03444 L
.50952 .03444 L
.5 .03444 L
.49048 .03444 L
.48095 .03444 L
.47143 .03444 L
.4619 .03444 L
.45238 .03444 L
.44286 .03444 L
.43333 .03444 L
.42381 .03444 L
.41429 .03444 L
.40476 .03444 L
.39524 .03444 L
.38571 .03444 L
.37619 .03444 L
.36667 .03444 L
.35714 .03444 L
.34762 .03444 L
.3381 .03444 L
.32857 .03444 L
.31905 .03444 L
.30952 .03444 L
.3 .03444 L
.29048 .03444 L
.28095 .03444 L
.27143 .03444 L
.2619 .03444 L
.25238 .03444 L
.24286 .03444 L
.23333 .03444 L
.22381 .03444 L
.21429 .03444 L
.20476 .03444 L
.19524 .03444 L
.18571 .03444 L
.17619 .03444 L
.16667 .03444 L
.15714 .03444 L
.14762 .03444 L
.1381 .03444 L
.12857 .03444 L
.11905 .03444 L
.10952 .03444 L
.1 .03444 L
.09048 .03444 L
.08095 .03444 L
.07143 .03444 L
.0619 .03444 L
.05238 .03444 L
.04286 .03444 L
.03333 .03444 L
.02381 .03444 L
.02381 .03444 L
.02381 .04596 L
.02381 .05762 L
.02381 .06941 L
.02381 .08133 L
.02381 .09337 L
.02381 .10553 L
.02381 .11781 L
.02381 .13022 L
.02381 .14273 L
.02381 .15537 L
.02381 .16811 L
.02381 .18096 L
.02381 .19391 L
.02381 .20697 L
.02381 .22013 L
.02381 .23339 L
.02381 .24674 L
.02381 .26019 L
.02381 .27372 L
.02381 .28735 L
.02381 .30106 L
.02381 .31485 L
.02381 .32872 L
.02381 .34266 L
.02381 .35669 L
.02381 .37078 L
.02381 .38494 L
.02381 .39917 L
.02381 .41346 L
.02381 .42781 L
.02381 .44222 L
.02381 .45668 L
.02381 .4712 L
.02381 .48576 L
.02381 .50037 L
.02381 .51503 L
.02381 .52972 L
.02381 .54446 L
.02381 .55922 L
.02381 .57402 L
.02381 .58885 L
.02381 .60371 L
.02381 .61858 L
.02381 .63348 L
.02381 .6484 L
.02381 .66333 L
.02381 .67827 L
.02381 .69322 L
.02381 .70818 L
.02381 .72314 L
.02381 .7381 L
.02381 .75305 L
.02381 .768 L
.02381 .78294 L
.02381 .79788 L
.02381 .81279 L
.02381 .82769 L
.02381 .84257 L
.02381 .85742 L
.02381 .87225 L
.02381 .88705 L
.02381 .90182 L
.02381 .91655 L
.02381 .93124 L
.02381 .9459 L
.02381 .96051 L
.02381 .97507 L
.02381 .98959 L
.02381 1.00405 L
.02381 1.01846 L
.02381 1.03281 L
.02381 1.0471 L
.02381 1.06133 L
.02381 1.07549 L
.02381 1.08959 L
.02381 1.10361 L
.02381 1.11756 L
.02381 1.13143 L
.02381 1.14522 L
.02381 1.15893 L
.02381 1.17255 L
.02381 1.18609 L
.02381 1.19953 L
.02381 1.21288 L
.02381 1.22614 L
.02381 1.2393 L
.02381 1.25236 L
.02381 1.26532 L
.02381 1.27816 L
.02381 1.29091 L
.02381 1.30354 L
.02381 1.31606 L
.02381 1.32846 L
.02381 1.34074 L
.02381 1.35291 L
.02381 1.36495 L
.02381 1.37686 L
.02381 1.38865 L
.02381 1.40031 L
.02381 1.41184 L
.02381 1.41184 L
.02381 1.41184 L
.03333 1.41184 L
.04286 1.41184 L
.05238 1.41184 L
.0619 1.41184 L
.07143 1.41184 L
.08095 1.41184 L
.09048 1.41184 L
.1 1.41184 L
.10952 1.41184 L
.11905 1.41184 L
.12857 1.41184 L
.1381 1.41184 L
.14762 1.41184 L
.15714 1.41184 L
.16667 1.41184 L
.17619 1.41184 L
.18571 1.41184 L
.19524 1.41184 L
.20476 1.41184 L
.21429 1.41184 L
.22381 1.41184 L
.23333 1.41184 L
.24286 1.41184 L
.25238 1.41184 L
.2619 1.41184 L
.27143 1.41184 L
.28095 1.41184 L
.29048 1.41184 L
.3 1.41184 L
.30952 1.41184 L
.31905 1.41184 L
.32857 1.41184 L
.3381 1.41184 L
.34762 1.41184 L
.35714 1.41184 L
.36667 1.41184 L
.37619 1.41184 L
.38571 1.41184 L
.39524 1.41184 L
.40476 1.41184 L
.41429 1.41184 L
.42381 1.41184 L
.43333 1.41184 L
.44286 1.41184 L
.45238 1.41184 L
.4619 1.41184 L
.47143 1.41184 L
.48095 1.41184 L
.49048 1.41184 L
.5 1.41184 L
.50952 1.41184 L
.51905 1.41184 L
.52857 1.41184 L
.5381 1.41184 L
.54762 1.41184 L
.55714 1.41184 L
.56667 1.41184 L
.57619 1.41184 L
.58571 1.41184 L
.59524 1.41184 L
.60476 1.41184 L
.61429 1.41184 L
.62381 1.41184 L
.63333 1.41184 L
.64286 1.41184 L
.65238 1.41184 L
.6619 1.41184 L
.67143 1.41184 L
.68095 1.41184 L
.69048 1.41184 L
.7 1.41184 L
.70952 1.41184 L
.71905 1.41184 L
.72857 1.41184 L
.7381 1.41184 L
.74762 1.41184 L
.75714 1.41184 L
.76667 1.41184 L
.77619 1.41184 L
.78571 1.41184 L
.79524 1.41184 L
.80476 1.41184 L
.81429 1.41184 L
.82381 1.41184 L
.83333 1.41184 L
.84286 1.41184 L
.85238 1.41184 L
.8619 1.41184 L
.87143 1.41184 L
.88095 1.41184 L
.89048 1.41184 L
.9 1.41184 L
.90952 1.41184 L
.91905 1.41184 L
.92857 1.41184 L
.9381 1.41184 L
.94762 1.41184 L
.95714 1.41184 L
.96667 1.41184 L
.97619 1.41184 L
.97619 1.41184 L
F
1 g
.36448 1.36694 m
.2619 1.35038 L
.23552 1.33896 L
.24782 1.29249 L
.21647 1.28614 L
.21865 1.27443 L
.15873 1.23793 L
.15873 1.22063 L
.15873 1.21427 L
.20476 1.17594 L
.2619 1.12161 L
.3125 1.07461 L
.40476 1.15065 L
.37381 1.19534 L
.3754 1.26262 L
.35119 1.32046 L
.36448 1.36694 L
F
.41885 .61362 m
.40774 .60928 L
.42619 .50403 L
.40198 .40541 L
.42679 .40393 L
.54147 .39857 L
.52381 .42482 L
.52381 .48212 L
.54782 .48212 L
.54742 .52115 L
.52579 .52115 L
.52123 .5873 L
.47619 .57217 L
.46409 .58792 L
.45853 .61331 L
.41885 .61393 L
F
.28135 .83916 m
.29444 .84195 L
.30437 .94132 L
.29048 .94376 L
.27341 .92757 L
.28135 .83916 L
F
.5627 .39561 m
.5119 .38642 L
.5 .32177 L
.5 .27429 L
.50774 .2395 L
.53333 .25934 L
.56567 .25906 L
.61171 .31831 L
.5627 .39561 L
F
.22996 .89967 m
.19623 .91716 L
.21468 .97326 L
.2619 1.00044 L
.26468 1.00044 L
.29048 .94407 L
.27341 .92757 L
.25992 .93002 L
.22817 .92757 L
.22996 .89967 L
F
.60734 .67173 m
.6121 .64 L
.62579 .67827 L
.60734 .67173 L
F
.37877 .76707 m
.37798 .80036 L
.36429 .8131 L
.37857 .85 L
.40337 .85526 L
.43631 .93797 L
.42937 .96567 L
.44861 .90888 L
.42798 .90243 L
.44643 .8636 L
.43353 .83606 L
.45476 .76458 L
.42024 .76364 L
.39683 .76364 L
.37877 .76707 L
F
.44643 .8636 m
.48313 .87287 L
.53294 .92666 L
.53433 .92604 L
.54187 .88551 L
.58869 .81683 L
.52778 .80036 L
.49048 .8159 L
.48373 .78823 L
.45933 .78823 L
.45476 .76458 L
.43353 .83606 L
.44643 .8636 L
F
.54762 1.08079 m
.45238 1.15037 L
.44048 1.14178 L
.45238 1.09573 L
.44623 1.0346 L
.42421 .97719 L
.42937 .96567 L
.44861 .90888 L
.42798 .90243 L
.44643 .8636 L
.48313 .87287 L
.53294 .92666 L
.52183 .96051 L
.53492 1.01036 L
.54762 1.01307 L
.54762 1.08079 L
F
.39484 .64933 m
.40516 .62944 L
.41766 .63659 L
.45119 .64995 L
.48373 .78823 L
.45933 .78823 L
.45476 .76458 L
.42024 .76364 L
.41865 .7462 L
.43452 .74059 L
.43393 .68761 L
.3998 .67951 L
.39484 .64933 L
F
.77718 .93705 m
.76806 .93736 L
.7752 .95899 L
.75913 .93705 L
.77321 .92757 L
.77718 .93705 L
F
.68591 1.14407 m
.64683 1.25236 L
.66964 1.22173 L
.67817 1.25155 L
.67738 1.25046 L
.66984 1.27843 L
.66925 1.2803 L
.56131 1.28535 L
.55952 1.1245 L
.66587 1.12016 L
.68591 1.14407 L
F
.37857 .74184 m
.37877 .76707 L
.39683 .76364 L
.39702 .74184 L
.37857 .74184 L
F
.69603 .98899 m
.70238 1.03758 L
.72163 1.05482 L
.73472 1.00195 L
.7752 .95899 L
.76984 .95169 L
.72421 .99381 L
.69603 .98899 L
F
.69603 .98899 m
.72421 .99381 L
.76984 .95169 L
.75913 .93705 L
.77321 .92757 L
.78591 .89074 L
.83313 .87225 L
.79702 .81465 L
.76071 .79756 L
.73234 .7873 L
.68968 .80937 L
.65456 .87102 L
.67004 .91931 L
.69226 .95869 L
.69603 .98899 L
F
.37857 .74184 m
.36567 .71129 L
.39484 .64933 L
.3998 .67951 L
.43393 .68761 L
.43452 .74059 L
.41865 .7462 L
.42024 .76364 L
.39683 .76364 L
.39702 .74184 L
.37857 .74184 L
F
.225 .81807 m
.2619 .828 L
.27619 .83699 L
.2619 .92023 L
.26091 .92206 L
.2619 .92941 L
.26012 .93002 L
.22817 .92757 L
.22996 .89967 L
.225 .81807 L
F
.10357 .89136 m
.08313 .92666 L
.09861 .95838 L
.12679 .95443 L
.12659 .95321 L
.15496 .95321 L
.16687 .91195 L
.16706 .91226 L
.16111 .86422 L
.13968 .8812 L
.12837 .90919 L
.10357 .89136 L
F
.0629 .95169 m
.08333 .94529 L
.07738 .93369 L
.08313 .92666 L
.09861 .95838 L
.0629 .95169 L
F
.17222 .8044 m
.225 .81807 L
.225 .81807 L
.22996 .89967 L
.22996 .89967 L
.19623 .91747 L
.19623 .91716 L
.16706 .91226 L
.16706 .91226 L
.16111 .86422 L
.16111 .86422 L
.17242 .8044 L
F
.75675 .69197 m
.72857 .63597 L
.66567 .70444 L
.67897 .75897 L
.66667 .80192 L
.68968 .80937 L
.73234 .7873 L
.76091 .79756 L
.7498 .7761 L
.75675 .69197 L
F
.125 .85247 m
.17222 .8044 L
.16111 .86422 L
.13968 .8812 L
.125 .85247 L
F
.39921 1.30929 m
.45139 1.28003 L
.49206 1.26343 L
.52044 1.30589 L
.56131 1.28535 L
.55952 1.1245 L
.55952 1.1245 L
.55952 1.08959 L
.54762 1.08079 L
.45238 1.15037 L
.44008 1.14149 L
.40476 1.15065 L
.37381 1.19534 L
.3754 1.26262 L
.39921 1.30929 L
F
.77758 .32408 m
.79187 .35756 L
.79127 .42452 L
.83333 .45005 L
.84861 .50129 L
.8631 .44011 L
.85278 .43591 L
.82302 .27061 L
.78651 .27118 L
.77758 .32408 L
F
.65456 .54661 m
.67063 .542 L
.67798 .50831 L
.67341 .47574 L
.68948 .44794 L
.68194 .4075 L
.67302 .45336 L
.65734 .46363 L
.65456 .54661 L
F
.3125 1.07461 m
.2619 1.12161 L
.20476 1.17594 L
.18353 1.17594 L
.19643 1.00946 L
.125 1.01216 L
.11845 .99562 L
.11607 .99623 L
.12679 .95443 L
.12659 .95321 L
.15496 .95321 L
.16706 .91226 L
.19623 .91716 L
.21468 .97326 L
.2619 1.00044 L
.26468 1.00044 L
.30813 1.01337 L
.3125 1.07461 L
F
.05893 1.10303 m
.06905 1.09339 L
.06508 1.01936 L
.10258 1.01906 L
.11845 .99532 L
.125 1.01216 L
.19643 1.00946 L
.18353 1.17594 L
.20476 1.17594 L
.15873 1.21455 L
.15873 1.19282 L
.11905 1.19282 L
.10595 1.14005 L
.10714 1.11291 L
.05893 1.10303 L
F
.23571 1.33921 m
.19742 1.35164 L
.1877 1.33794 L
.15139 1.2996 L
.14008 1.24775 L
.10496 1.22063 L
.15873 1.22063 L
.15873 1.23793 L
.21865 1.27443 L
.21647 1.28614 L
.24782 1.29249 L
.23571 1.33921 L
F
.74325 .52819 m
.74603 .44072 L
.67341 .36343 L
.68452 .28564 L
.65258 .26019 L
.65357 .23922 L
.64444 .2395 L
.64246 .25429 L
.63452 .31456 L
.65516 .3561 L
.65456 .41495 L
.62401 .43441 L
.65734 .46363 L
.67302 .45336 L
.68194 .4075 L
.68948 .44794 L
.67341 .47574 L
.67798 .50831 L
.74325 .52819 L
F
.40198 .40541 m
.43492 .30995 L
.43393 .3022 L
.45813 .21053 L
.5 .21299 L
.5 .27429 L
.5 .32177 L
.5119 .38642 L
.5627 .39561 L
.54147 .39857 L
.42679 .40393 L
.40198 .40541 L
F
.44008 1.14149 m
.40456 1.15065 L
.3125 1.07461 L
.30813 1.01337 L
.26468 1.00044 L
.29048 .94407 L
.30437 .94132 L
.30476 .94041 L
.32004 .9784 L
.37659 .96051 L
.42421 .97719 L
.44623 1.0346 L
.45238 1.09573 L
.44008 1.14149 L
F
.36409 .81279 m
.33452 .80285 L
.3248 .83327 L
.29425 .84195 L
.30437 .94132 L
.30476 .94041 L
.32004 .9784 L
.37659 .96051 L
.42421 .97719 L
.42956 .96537 L
.43631 .93797 L
.40337 .85526 L
.37857 .85 L
.36409 .81279 L
F
.45813 .21053 m
.47996 .12142 L
.5 .1114 L
.59405 .13907 L
.65357 .23922 L
.64444 .2395 L
.62877 .24005 L
.64246 .25401 L
.63452 .31456 L
.61151 .3186 L
.56567 .25906 L
.53333 .25934 L
.50774 .2395 L
.5 .27429 L
.5 .21299 L
.45813 .21053 L
F
.60357 .20998 m
.58353 .19337 L
.59643 .17666 L
.6125 .19798 L
.60357 .20998 L
F
.61429 .69727 m
.60734 .67173 L
.62579 .67827 L
.6248 .70319 L
.61429 .69727 L
F
.06508 1.01966 m
.05317 .99592 L
.06468 .97477 L
.09762 .97113 L
.0625 .96537 L
.07877 .96112 L
.0629 .95169 L
.09861 .95838 L
.12679 .95443 L
.11607 .99623 L
.11845 .99532 L
.10258 1.01906 L
.06508 1.01936 L
F
.10357 .89136 m
.1252 .85247 L
.13988 .8812 L
.12837 .90919 L
.10357 .89136 L
F
.75655 .69197 m
.83274 .80658 L
.87401 .91747 L
.86647 .9459 L
.79663 .91686 L
.77718 .93705 L
.77679 .93644 L
.77321 .92757 L
.78591 .89074 L
.83313 .87225 L
.79702 .81465 L
.76071 .79756 L
.7498 .7761 L
.75655 .69197 L
F
.72163 1.05482 m
.70119 1.12508 L
.68591 1.14407 L
.66587 1.12016 L
.55952 1.1245 L
.55952 1.08959 L
.54762 1.08079 L
.54762 1.01307 L
.53492 1.01036 L
.52183 .96051 L
.53294 .92666 L
.53433 .92604 L
.54187 .88551 L
.58869 .81683 L
.62937 .78823 L
.66667 .80192 L
.68968 .80937 L
.65456 .87102 L
.67004 .91931 L
.69226 .95869 L
.70238 1.03758 L
.72163 1.05482 L
F
.64444 .2395 m
.64246 .25429 L
.62877 .24005 L
.64444 .2395 L
F
.74325 .52819 m
.72361 .61021 L
.72857 .63597 L
.66567 .70444 L
.6248 .70319 L
.62579 .67827 L
.6121 .64 L
.62817 .57063 L
.65456 .54784 L
.67063 .542 L
.67817 .50831 L
.74325 .52819 L
F
.06468 .97477 m
.07976 .97235 L
.0625 .96476 L
.0625 .96537 L
.09762 .97113 L
.06468 .97477 L
F
.27619 .83699 m
.28155 .83916 L
.27282 .92757 L
.25992 .93002 L
.2619 .92941 L
.26091 .92206 L
.2619 .92023 L
.27619 .83699 L
F
.36448 1.36694 m
.39345 1.36918 L
.38095 1.32485 L
.39921 1.30929 L
.3754 1.26262 L
.35119 1.32046 L
.36448 1.36694 L
F
.62937 .78823 m
.63452 .76271 L
.61429 .69727 L
.6248 .70319 L
.66567 .70444 L
.67897 .75897 L
.66667 .80192 L
.62937 .78823 L
F
.10496 1.22063 m
.05893 1.10303 L
.10714 1.11291 L
.10595 1.14005 L
.11905 1.19282 L
.15873 1.19282 L
.15873 1.21455 L
.15873 1.22063 L
.10496 1.22063 L
F
.41885 .61362 m
.40714 .61517 L
.41786 .63659 L
.45119 .64995 L
.48373 .78823 L
.49048 .8159 L
.52778 .80036 L
.58869 .81683 L
.62937 .78823 L
.63452 .76271 L
.61429 .69727 L
.60754 .67204 L
.6121 .64 L
.62817 .57063 L
.5996 .5506 L
.5996 .50861 L
.61667 .49763 L
.61667 .47393 L
.58571 .50831 L
.54742 .52115 L
.52579 .52115 L
.52123 .5873 L
.47619 .57217 L
.46409 .58792 L
.45853 .61331 L
.41885 .61362 L
F
.62817 .57063 m
.5996 .5506 L
.5996 .50861 L
.61667 .49763 L
.61667 .47393 L
.58571 .50831 L
.54742 .52115 L
.54782 .48212 L
.52381 .48212 L
.52381 .42482 L
.54147 .39857 L
.5627 .39561 L
.58512 .39561 L
.62401 .43441 L
.65734 .46363 L
.65456 .54661 L
.65456 .54784 L
.62817 .57032 L
F
.63452 .31456 m
.61151 .3186 L
.5627 .39561 L
.58512 .39561 L
.62401 .43441 L
.65456 .41495 L
.65516 .3561 L
.63452 .31456 L
F
0 g
.001 w
[ ] 0 setdash
.36448 1.36694 m
.2619 1.35038 L
.23552 1.33896 L
.24782 1.29249 L
.21647 1.28614 L
.21865 1.27443 L
.15873 1.23793 L
.15873 1.22063 L
.15873 1.21427 L
.20476 1.17594 L
.2619 1.12161 L
.3125 1.07461 L
.40476 1.15065 L
.37381 1.19534 L
.3754 1.26262 L
.35119 1.32046 L
.36448 1.36694 L
s
.41885 .61362 m
.40774 .60928 L
.42619 .50403 L
.40198 .40541 L
.42679 .40393 L
.54147 .39857 L
.52381 .42482 L
.52381 .48212 L
.54782 .48212 L
.54742 .52115 L
.52579 .52115 L
.52123 .5873 L
.47619 .57217 L
.46409 .58792 L
.45853 .61331 L
.41885 .61393 L
s
.28135 .83916 m
.29444 .84195 L
.30437 .94132 L
.29048 .94376 L
.27341 .92757 L
.28135 .83916 L
s
.5627 .39561 m
.5119 .38642 L
.5 .32177 L
.5 .27429 L
.50774 .2395 L
.53333 .25934 L
.56567 .25906 L
.61171 .31831 L
.5627 .39561 L
s
.22996 .89967 m
.19623 .91716 L
.21468 .97326 L
.2619 1.00044 L
.26468 1.00044 L
.29048 .94407 L
.27341 .92757 L
.25992 .93002 L
.22817 .92757 L
.22996 .89967 L
s
.60734 .67173 m
.6121 .64 L
.62579 .67827 L
.60734 .67173 L
s
.37877 .76707 m
.37798 .80036 L
.36429 .8131 L
.37857 .85 L
.40337 .85526 L
.43631 .93797 L
.42937 .96567 L
.44861 .90888 L
.42798 .90243 L
.44643 .8636 L
.43353 .83606 L
.45476 .76458 L
.42024 .76364 L
.39683 .76364 L
.37877 .76707 L
s
.44643 .8636 m
.48313 .87287 L
.53294 .92666 L
.53433 .92604 L
.54187 .88551 L
.58869 .81683 L
.52778 .80036 L
.49048 .8159 L
.48373 .78823 L
.45933 .78823 L
.45476 .76458 L
.43353 .83606 L
.44643 .8636 L
s
.54762 1.08079 m
.45238 1.15037 L
.44048 1.14178 L
.45238 1.09573 L
.44623 1.0346 L
.42421 .97719 L
.42937 .96567 L
.44861 .90888 L
.42798 .90243 L
.44643 .8636 L
.48313 .87287 L
.53294 .92666 L
.52183 .96051 L
.53492 1.01036 L
.54762 1.01307 L
.54762 1.08079 L
s
.39484 .64933 m
.40516 .62944 L
.41766 .63659 L
.45119 .64995 L
.48373 .78823 L
.45933 .78823 L
.45476 .76458 L
.42024 .76364 L
.41865 .7462 L
.43452 .74059 L
.43393 .68761 L
.3998 .67951 L
.39484 .64933 L
s
.77718 .93705 m
.76806 .93736 L
.7752 .95899 L
.75913 .93705 L
.77321 .92757 L
.77718 .93705 L
s
.68591 1.14407 m
.64683 1.25236 L
.66964 1.22173 L
.67817 1.25155 L
.67738 1.25046 L
.66984 1.27843 L
.66925 1.2803 L
.56131 1.28535 L
.55952 1.1245 L
.66587 1.12016 L
.68591 1.14407 L
s
.37857 .74184 m
.37877 .76707 L
.39683 .76364 L
.39702 .74184 L
.37857 .74184 L
s
.69603 .98899 m
.70238 1.03758 L
.72163 1.05482 L
.73472 1.00195 L
.7752 .95899 L
.76984 .95169 L
.72421 .99381 L
.69603 .98899 L
s
.69603 .98899 m
.72421 .99381 L
.76984 .95169 L
.75913 .93705 L
.77321 .92757 L
.78591 .89074 L
.83313 .87225 L
.79702 .81465 L
.76071 .79756 L
.73234 .7873 L
.68968 .80937 L
.65456 .87102 L
.67004 .91931 L
.69226 .95869 L
.69603 .98899 L
s
.37857 .74184 m
.36567 .71129 L
.39484 .64933 L
.3998 .67951 L
.43393 .68761 L
.43452 .74059 L
.41865 .7462 L
.42024 .76364 L
.39683 .76364 L
.39702 .74184 L
.37857 .74184 L
s
.225 .81807 m
.2619 .828 L
.27619 .83699 L
.2619 .92023 L
.26091 .92206 L
.2619 .92941 L
.26012 .93002 L
.22817 .92757 L
.22996 .89967 L
.225 .81807 L
s
.10357 .89136 m
.08313 .92666 L
.09861 .95838 L
.12679 .95443 L
.12659 .95321 L
.15496 .95321 L
.16687 .91195 L
.16706 .91226 L
.16111 .86422 L
.13968 .8812 L
.12837 .90919 L
.10357 .89136 L
s
.0629 .95169 m
.08333 .94529 L
.07738 .93369 L
.08313 .92666 L
.09861 .95838 L
.0629 .95169 L
s
.17222 .8044 m
.225 .81807 L
.225 .81807 L
.22996 .89967 L
.22996 .89967 L
.19623 .91747 L
.19623 .91716 L
.16706 .91226 L
.16706 .91226 L
.16111 .86422 L
.16111 .86422 L
.17242 .8044 L
s
.75675 .69197 m
.72857 .63597 L
.66567 .70444 L
.67897 .75897 L
.66667 .80192 L
.68968 .80937 L
.73234 .7873 L
.76091 .79756 L
.7498 .7761 L
.75675 .69197 L
s
.125 .85247 m
.17222 .8044 L
.16111 .86422 L
.13968 .8812 L
.125 .85247 L
s
.39921 1.30929 m
.45139 1.28003 L
.49206 1.26343 L
.52044 1.30589 L
.56131 1.28535 L
.55952 1.1245 L
.55952 1.1245 L
.55952 1.08959 L
.54762 1.08079 L
.45238 1.15037 L
.44008 1.14149 L
.40476 1.15065 L
.37381 1.19534 L
.3754 1.26262 L
.39921 1.30929 L
s
.77758 .32408 m
.79187 .35756 L
.79127 .42452 L
.83333 .45005 L
.84861 .50129 L
.8631 .44011 L
.85278 .43591 L
.82302 .27061 L
.78651 .27118 L
.77758 .32408 L
s
.65456 .54661 m
.67063 .542 L
.67798 .50831 L
.67341 .47574 L
.68948 .44794 L
.68194 .4075 L
.67302 .45336 L
.65734 .46363 L
.65456 .54661 L
s
.3125 1.07461 m
.2619 1.12161 L
.20476 1.17594 L
.18353 1.17594 L
.19643 1.00946 L
.125 1.01216 L
.11845 .99562 L
.11607 .99623 L
.12679 .95443 L
.12659 .95321 L
.15496 .95321 L
.16706 .91226 L
.19623 .91716 L
.21468 .97326 L
.2619 1.00044 L
.26468 1.00044 L
.30813 1.01337 L
.3125 1.07461 L
s
.05893 1.10303 m
.06905 1.09339 L
.06508 1.01936 L
.10258 1.01906 L
.11845 .99532 L
.125 1.01216 L
.19643 1.00946 L
.18353 1.17594 L
.20476 1.17594 L
.15873 1.21455 L
.15873 1.19282 L
.11905 1.19282 L
.10595 1.14005 L
.10714 1.11291 L
.05893 1.10303 L
s
.23571 1.33921 m
.19742 1.35164 L
.1877 1.33794 L
.15139 1.2996 L
.14008 1.24775 L
.10496 1.22063 L
.15873 1.22063 L
.15873 1.23793 L
.21865 1.27443 L
.21647 1.28614 L
.24782 1.29249 L
.23571 1.33921 L
s
.74325 .52819 m
.74603 .44072 L
.67341 .36343 L
.68452 .28564 L
.65258 .26019 L
.65357 .23922 L
.64444 .2395 L
.64246 .25429 L
.63452 .31456 L
.65516 .3561 L
.65456 .41495 L
.62401 .43441 L
.65734 .46363 L
.67302 .45336 L
.68194 .4075 L
.68948 .44794 L
.67341 .47574 L
.67798 .50831 L
.74325 .52819 L
s
.40198 .40541 m
.43492 .30995 L
.43393 .3022 L
.45813 .21053 L
.5 .21299 L
.5 .27429 L
.5 .32177 L
.5119 .38642 L
.5627 .39561 L
.54147 .39857 L
.42679 .40393 L
.40198 .40541 L
s
.44008 1.14149 m
.40456 1.15065 L
.3125 1.07461 L
.30813 1.01337 L
.26468 1.00044 L
.29048 .94407 L
.30437 .94132 L
.30476 .94041 L
.32004 .9784 L
.37659 .96051 L
.42421 .97719 L
.44623 1.0346 L
.45238 1.09573 L
.44008 1.14149 L
s
.36409 .81279 m
.33452 .80285 L
.3248 .83327 L
.29425 .84195 L
.30437 .94132 L
.30476 .94041 L
.32004 .9784 L
.37659 .96051 L
.42421 .97719 L
.42956 .96537 L
.43631 .93797 L
.40337 .85526 L
.37857 .85 L
.36409 .81279 L
s
.45813 .21053 m
.47996 .12142 L
.5 .1114 L
.59405 .13907 L
.65357 .23922 L
.64444 .2395 L
.62877 .24005 L
.64246 .25401 L
.63452 .31456 L
.61151 .3186 L
.56567 .25906 L
.53333 .25934 L
.50774 .2395 L
.5 .27429 L
.5 .21299 L
.45813 .21053 L
s
.60357 .20998 m
.58353 .19337 L
.59643 .17666 L
.6125 .19798 L
.60357 .20998 L
s
.61429 .69727 m
.60734 .67173 L
.62579 .67827 L
.6248 .70319 L
.61429 .69727 L
s
.06508 1.01966 m
.05317 .99592 L
.06468 .97477 L
.09762 .97113 L
.0625 .96537 L
.07877 .96112 L
.0629 .95169 L
.09861 .95838 L
.12679 .95443 L
.11607 .99623 L
.11845 .99532 L
.10258 1.01906 L
.06508 1.01936 L
s
.10357 .89136 m
.1252 .85247 L
.13988 .8812 L
.12837 .90919 L
.10357 .89136 L
s
.75655 .69197 m
.83274 .80658 L
.87401 .91747 L
.86647 .9459 L
.79663 .91686 L
.77718 .93705 L
.77679 .93644 L
.77321 .92757 L
.78591 .89074 L
.83313 .87225 L
.79702 .81465 L
.76071 .79756 L
.7498 .7761 L
.75655 .69197 L
s
.72163 1.05482 m
.70119 1.12508 L
.68591 1.14407 L
.66587 1.12016 L
.55952 1.1245 L
.55952 1.08959 L
.54762 1.08079 L
.54762 1.01307 L
.53492 1.01036 L
.52183 .96051 L
.53294 .92666 L
.53433 .92604 L
.54187 .88551 L
.58869 .81683 L
.62937 .78823 L
.66667 .80192 L
.68968 .80937 L
.65456 .87102 L
.67004 .91931 L
.69226 .95869 L
.70238 1.03758 L
.72163 1.05482 L
s
.64444 .2395 m
.64246 .25429 L
.62877 .24005 L
.64444 .2395 L
s
.74325 .52819 m
.72361 .61021 L
.72857 .63597 L
.66567 .70444 L
.6248 .70319 L
.62579 .67827 L
.6121 .64 L
.62817 .57063 L
.65456 .54784 L
.67063 .542 L
.67817 .50831 L
.74325 .52819 L
s
.06468 .97477 m
.07976 .97235 L
.0625 .96476 L
.0625 .96537 L
.09762 .97113 L
.06468 .97477 L
s
.27619 .83699 m
.28155 .83916 L
.27282 .92757 L
.25992 .93002 L
.2619 .92941 L
.26091 .92206 L
.2619 .92023 L
.27619 .83699 L
s
.36448 1.36694 m
.39345 1.36918 L
.38095 1.32485 L
.39921 1.30929 L
.3754 1.26262 L
.35119 1.32046 L
.36448 1.36694 L
s
.62937 .78823 m
.63452 .76271 L
.61429 .69727 L
.6248 .70319 L
.66567 .70444 L
.67897 .75897 L
.66667 .80192 L
.62937 .78823 L
s
.10496 1.22063 m
.05893 1.10303 L
.10714 1.11291 L
.10595 1.14005 L
.11905 1.19282 L
.15873 1.19282 L
.15873 1.21455 L
.15873 1.22063 L
.10496 1.22063 L
s
.41885 .61362 m
.40714 .61517 L
.41786 .63659 L
.45119 .64995 L
.48373 .78823 L
.49048 .8159 L
.52778 .80036 L
.58869 .81683 L
.62937 .78823 L
.63452 .76271 L
.61429 .69727 L
.60754 .67204 L
.6121 .64 L
.62817 .57063 L
.5996 .5506 L
.5996 .50861 L
.61667 .49763 L
.61667 .47393 L
.58571 .50831 L
.54742 .52115 L
.52579 .52115 L
.52123 .5873 L
.47619 .57217 L
.46409 .58792 L
.45853 .61331 L
.41885 .61362 L
s
.62817 .57063 m
.5996 .5506 L
.5996 .50861 L
.61667 .49763 L
.61667 .47393 L
.58571 .50831 L
.54742 .52115 L
.54782 .48212 L
.52381 .48212 L
.52381 .42482 L
.54147 .39857 L
.5627 .39561 L
.58512 .39561 L
.62401 .43441 L
.65734 .46363 L
.65456 .54661 L
.65456 .54784 L
.62817 .57032 L
s
.63452 .31456 m
.61151 .3186 L
.5627 .39561 L
.58512 .39561 L
.62401 .43441 L
.65456 .41495 L
.65516 .3561 L
.63452 .31456 L
s
.012 w
.97619 1.41184 m
.97619 1.41184 L
.97619 1.40031 L
.97619 1.38865 L
.97619 1.37686 L
.97619 1.36495 L
.97619 1.35291 L
.97619 1.34074 L
.97619 1.32846 L
.97619 1.31606 L
.97619 1.30354 L
.97619 1.29091 L
.97619 1.27816 L
.97619 1.26532 L
.97619 1.25236 L
.97619 1.2393 L
.97619 1.22614 L
.97619 1.21288 L
.97619 1.19953 L
.97619 1.18609 L
.97619 1.17255 L
.97619 1.15893 L
.97619 1.14522 L
.97619 1.13143 L
.97619 1.11756 L
.97619 1.10361 L
.97619 1.08959 L
.97619 1.07549 L
.97619 1.06133 L
.97619 1.0471 L
.97619 1.03281 L
.97619 1.01846 L
.97619 1.00405 L
.97619 .98959 L
.97619 .97507 L
.97619 .96051 L
.97619 .9459 L
.97619 .93124 L
.97619 .91655 L
.97619 .90182 L
.97619 .88705 L
.97619 .87225 L
.97619 .85742 L
.97619 .84257 L
.97619 .82769 L
.97619 .81279 L
.97619 .79788 L
.97619 .78294 L
.97619 .768 L
.97619 .75305 L
Mistroke
.97619 .7381 L
.97619 .72314 L
.97619 .70818 L
.97619 .69322 L
.97619 .67827 L
.97619 .66333 L
.97619 .6484 L
.97619 .63348 L
.97619 .61858 L
.97619 .60371 L
.97619 .58885 L
.97619 .57402 L
.97619 .55922 L
.97619 .54446 L
.97619 .52972 L
.97619 .51503 L
.97619 .50037 L
.97619 .48576 L
.97619 .4712 L
.97619 .45668 L
.97619 .44222 L
.97619 .42781 L
.97619 .41346 L
.97619 .39917 L
.97619 .38494 L
.97619 .37078 L
.97619 .35669 L
.97619 .34266 L
.97619 .32872 L
.97619 .31485 L
.97619 .30106 L
.97619 .28735 L
.97619 .27372 L
.97619 .26019 L
.97619 .24674 L
.97619 .23339 L
.97619 .22013 L
.97619 .20697 L
.97619 .19391 L
.97619 .18096 L
.97619 .16811 L
.97619 .15537 L
.97619 .14273 L
.97619 .13022 L
.97619 .11781 L
.97619 .10553 L
.97619 .09337 L
.97619 .08133 L
.97619 .06941 L
.97619 .05762 L
Mistroke
.97619 .04596 L
.97619 .03444 L
Mfstroke
.97619 .03444 m
.97619 .03444 L
.96667 .03444 L
.95714 .03444 L
.94762 .03444 L
.9381 .03444 L
.92857 .03444 L
.91905 .03444 L
.90952 .03444 L
.9 .03444 L
.89048 .03444 L
.88095 .03444 L
.87143 .03444 L
.8619 .03444 L
.85238 .03444 L
.84286 .03444 L
.83333 .03444 L
.82381 .03444 L
.81429 .03444 L
.80476 .03444 L
.79524 .03444 L
.78571 .03444 L
.77619 .03444 L
.76667 .03444 L
.75714 .03444 L
.74762 .03444 L
.7381 .03444 L
.72857 .03444 L
.71905 .03444 L
.70952 .03444 L
.7 .03444 L
.69048 .03444 L
.68095 .03444 L
.67143 .03444 L
.6619 .03444 L
.65238 .03444 L
.64286 .03444 L
.63333 .03444 L
.62381 .03444 L
.61429 .03444 L
.60476 .03444 L
.59524 .03444 L
.58571 .03444 L
.57619 .03444 L
.56667 .03444 L
.55714 .03444 L
.54762 .03444 L
.5381 .03444 L
.52857 .03444 L
.51905 .03444 L
Mistroke
.50952 .03444 L
.5 .03444 L
.49048 .03444 L
.48095 .03444 L
.47143 .03444 L
.4619 .03444 L
.45238 .03444 L
.44286 .03444 L
.43333 .03444 L
.42381 .03444 L
.41429 .03444 L
.40476 .03444 L
.39524 .03444 L
.38571 .03444 L
.37619 .03444 L
.36667 .03444 L
.35714 .03444 L
.34762 .03444 L
.3381 .03444 L
.32857 .03444 L
.31905 .03444 L
.30952 .03444 L
.3 .03444 L
.29048 .03444 L
.28095 .03444 L
.27143 .03444 L
.2619 .03444 L
.25238 .03444 L
.24286 .03444 L
.23333 .03444 L
.22381 .03444 L
.21429 .03444 L
.20476 .03444 L
.19524 .03444 L
.18571 .03444 L
.17619 .03444 L
.16667 .03444 L
.15714 .03444 L
.14762 .03444 L
.1381 .03444 L
.12857 .03444 L
.11905 .03444 L
.10952 .03444 L
.1 .03444 L
.09048 .03444 L
.08095 .03444 L
.07143 .03444 L
.0619 .03444 L
.05238 .03444 L
.04286 .03444 L
Mistroke
.03333 .03444 L
.02381 .03444 L
Mfstroke
.02381 .03444 m
.02381 .04596 L
.02381 .05762 L
.02381 .06941 L
.02381 .08133 L
.02381 .09337 L
.02381 .10553 L
.02381 .11781 L
.02381 .13022 L
.02381 .14273 L
.02381 .15537 L
.02381 .16811 L
.02381 .18096 L
.02381 .19391 L
.02381 .20697 L
.02381 .22013 L
.02381 .23339 L
.02381 .24674 L
.02381 .26019 L
.02381 .27372 L
.02381 .28735 L
.02381 .30106 L
.02381 .31485 L
.02381 .32872 L
.02381 .34266 L
.02381 .35669 L
.02381 .37078 L
.02381 .38494 L
.02381 .39917 L
.02381 .41346 L
.02381 .42781 L
.02381 .44222 L
.02381 .45668 L
.02381 .4712 L
.02381 .48576 L
.02381 .50037 L
.02381 .51503 L
.02381 .52972 L
.02381 .54446 L
.02381 .55922 L
.02381 .57402 L
.02381 .58885 L
.02381 .60371 L
.02381 .61858 L
.02381 .63348 L
.02381 .6484 L
.02381 .66333 L
.02381 .67827 L
.02381 .69322 L
.02381 .70818 L
Mistroke
.02381 .72314 L
.02381 .7381 L
.02381 .75305 L
.02381 .768 L
.02381 .78294 L
.02381 .79788 L
.02381 .81279 L
.02381 .82769 L
.02381 .84257 L
.02381 .85742 L
.02381 .87225 L
.02381 .88705 L
.02381 .90182 L
.02381 .91655 L
.02381 .93124 L
.02381 .9459 L
.02381 .96051 L
.02381 .97507 L
.02381 .98959 L
.02381 1.00405 L
.02381 1.01846 L
.02381 1.03281 L
.02381 1.0471 L
.02381 1.06133 L
.02381 1.07549 L
.02381 1.08959 L
.02381 1.10361 L
.02381 1.11756 L
.02381 1.13143 L
.02381 1.14522 L
.02381 1.15893 L
.02381 1.17255 L
.02381 1.18609 L
.02381 1.19953 L
.02381 1.21288 L
.02381 1.22614 L
.02381 1.2393 L
.02381 1.25236 L
.02381 1.26532 L
.02381 1.27816 L
.02381 1.29091 L
.02381 1.30354 L
.02381 1.31606 L
.02381 1.32846 L
.02381 1.34074 L
.02381 1.35291 L
.02381 1.36495 L
.02381 1.37686 L
.02381 1.38865 L
.02381 1.40031 L
Mistroke
.02381 1.41184 L
.02381 1.41184 L
Mfstroke
.02381 1.41184 m
.03333 1.41184 L
.04286 1.41184 L
.05238 1.41184 L
.0619 1.41184 L
.07143 1.41184 L
.08095 1.41184 L
.09048 1.41184 L
.1 1.41184 L
.10952 1.41184 L
.11905 1.41184 L
.12857 1.41184 L
.1381 1.41184 L
.14762 1.41184 L
.15714 1.41184 L
.16667 1.41184 L
.17619 1.41184 L
.18571 1.41184 L
.19524 1.41184 L
.20476 1.41184 L
.21429 1.41184 L
.22381 1.41184 L
.23333 1.41184 L
.24286 1.41184 L
.25238 1.41184 L
.2619 1.41184 L
.27143 1.41184 L
.28095 1.41184 L
.29048 1.41184 L
.3 1.41184 L
.30952 1.41184 L
.31905 1.41184 L
.32857 1.41184 L
.3381 1.41184 L
.34762 1.41184 L
.35714 1.41184 L
.36667 1.41184 L
.37619 1.41184 L
.38571 1.41184 L
.39524 1.41184 L
.40476 1.41184 L
.41429 1.41184 L
.42381 1.41184 L
.43333 1.41184 L
.44286 1.41184 L
.45238 1.41184 L
.4619 1.41184 L
.47143 1.41184 L
.48095 1.41184 L
.49048 1.41184 L
Mistroke
.5 1.41184 L
.50952 1.41184 L
.51905 1.41184 L
.52857 1.41184 L
.5381 1.41184 L
.54762 1.41184 L
.55714 1.41184 L
.56667 1.41184 L
.57619 1.41184 L
.58571 1.41184 L
.59524 1.41184 L
.60476 1.41184 L
.61429 1.41184 L
.62381 1.41184 L
.63333 1.41184 L
.64286 1.41184 L
.65238 1.41184 L
.6619 1.41184 L
.67143 1.41184 L
.68095 1.41184 L
.69048 1.41184 L
.7 1.41184 L
.70952 1.41184 L
.71905 1.41184 L
.72857 1.41184 L
.7381 1.41184 L
.74762 1.41184 L
.75714 1.41184 L
.76667 1.41184 L
.77619 1.41184 L
.78571 1.41184 L
.79524 1.41184 L
.80476 1.41184 L
.81429 1.41184 L
.82381 1.41184 L
.83333 1.41184 L
.84286 1.41184 L
.85238 1.41184 L
.8619 1.41184 L
.87143 1.41184 L
.88095 1.41184 L
.89048 1.41184 L
.9 1.41184 L
.90952 1.41184 L
.91905 1.41184 L
.92857 1.41184 L
.9381 1.41184 L
.94762 1.41184 L
.95714 1.41184 L
.96667 1.41184 L
Mistroke
.97619 1.41184 L
.97619 1.41184 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.65.1"],

Cell[BoxData["\<\"-WorldGraphics-\"\>"], "Output",
 CellLabel->"Out[7]= ",
 CellTags->"S5.65.1"]
}, Open  ]],

Cell[TextData[{
 "As noted previously, a projection is a scheme for transforming latitudes \
and longitudes on the Earth into ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " coordinates on a flat page. Each projection involves certain fixed \
geometric choices. For example, the Lambert azimuthal projection projects the \
surface of the Earth onto a plane that is tangent at one point. When you \
specify ",
 StyleBox["LambertAzimuthal", "MR"],
 " as the projection, this point is fixed at zero degrees latitude and \
longitude. You can change the choice of this point by setting the ",
 StyleBox["WorldRotation", "MR"],
 " option. "
}], "Text",
 CellTags->{"S5.65.1", "1.26"}],

Cell[TextData[{
 "A value for ",
 StyleBox["WorldRotation", "MR"],
 " must be a list of three numbers ",
 StyleBox["{", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["deg",
     "TI"], "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["deg",
     "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox[", ", "MR"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["deg",
     "TI"], "3"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 StyleBox["}", "MR"],
 " with the first two between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["180", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and the last between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "180"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " and ",
 Cell[BoxData[
  FormBox["180", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 ". To understand the effect of these numbers, you can imagine the globe in a \
standard ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     StyleBox["x",
      "TI"], ",", 
     StyleBox["y",
      "TI"], ",", 
     StyleBox["z",
      "TI"]}], ")"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " coordinate system with the positive ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis coming out of the North Pole and the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis through the equator at the Prime Meridian. The three numbers give the \
amount of rotation (in degrees) of three sequential rotations. The first is \
about the ",
 Cell[BoxData[
  FormBox[
   StyleBox["y",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis, the second is about the ",
 Cell[BoxData[
  FormBox[
   StyleBox["z",
    "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " axis, and the third is about the North Pole in the position where it is ",
 StyleBox["after", "TI"],
 " the first two rotations. "
}], "Text",
 CellTags->{"S5.65.1", "1.27"}],

Cell[TextData[{
 "This setting for ",
 StyleBox["WorldRotation", "MR"],
 " causes the Earth to be rotated by ",
 Cell[BoxData[
  FormBox["90", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees before the projection is applied. The result is a view of the \
Northern Hemisphere centered at the North Pole. "
}], "MathCaption",
 CellTags->{"S5.65.1", "1.28"}],

Cell[CellGroupData[{

Cell["\<\
WorldPlot[{World, RandomGrays},
   WorldRotation -> {90, 0, 0},
   WorldRange -> {{0, 90}, {-180, 180}},
   WorldProjection -> LambertAzimuthal]\
\>", "Input",
 CellLabel->"In[8]:= ",
 CellTags->"S5.65.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.336718 0.5 0.336718 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.001 w
[ ] 0 setdash
.5 .97619 m
.5 .961 L
.5 .94535 L
.5 .92926 L
.5 .91275 L
.5 .89584 L
.5 .87853 L
.5 .86084 L
.5 .84281 L
.5 .82443 L
.5 .80573 L
.5 .78673 L
.5 .76745 L
.5 .74791 L
.5 .72812 L
.5 .7081 L
.5 .68788 L
.5 .66748 L
.5 .64691 L
.5 .62619 L
.5 .60535 L
.5 .5844 L
.5 .56338 L
.5 .54229 L
.5 .52115 L
.5 .5 L
.5 .5 L
s
.2619 .91239 m
.2695 .89924 L
.27732 .88568 L
.28537 .87175 L
.29362 .85745 L
.30208 .8428 L
.31074 .82781 L
.31958 .8125 L
.3286 .79688 L
.33779 .78096 L
.34713 .76477 L
.35663 .74832 L
.36627 .73162 L
.37605 .71469 L
.38594 .69756 L
.39595 .68022 L
.40606 .66271 L
.41626 .64504 L
.42655 .62722 L
.43691 .60928 L
.44733 .59123 L
.4578 .5731 L
.46831 .55489 L
.47886 .53662 L
.48942 .51832 L
.5 .5 L
.5 .5 L
s
.08761 .7381 m
.10076 .7305 L
.11432 .72268 L
.12825 .71463 L
.14255 .70638 L
.1572 .69792 L
.17219 .68926 L
.1875 .68042 L
.20312 .6714 L
.21904 .66221 L
.23523 .65287 L
.25168 .64337 L
.26838 .63373 L
.28531 .62395 L
.30244 .61406 L
.31978 .60405 L
.33729 .59394 L
.35496 .58374 L
.37278 .57345 L
.39072 .56309 L
.40877 .55267 L
.4269 .5422 L
.44511 .53169 L
.46338 .52114 L
.48168 .51058 L
.5 .5 L
.5 .5 L
s
.02381 .5 m
.039 .5 L
.05465 .5 L
.07074 .5 L
.08725 .5 L
.10416 .5 L
.12147 .5 L
.13916 .5 L
.15719 .5 L
.17557 .5 L
.19427 .5 L
.21327 .5 L
.23255 .5 L
.25209 .5 L
.27188 .5 L
.2919 .5 L
.31212 .5 L
.33252 .5 L
.35309 .5 L
.37381 .5 L
.39465 .5 L
.4156 .5 L
.43662 .5 L
.45771 .5 L
.47885 .5 L
.5 .5 L
.5 .5 L
s
.08761 .2619 m
.10076 .2695 L
.11432 .27732 L
.12825 .28537 L
.14255 .29362 L
.1572 .30208 L
.17219 .31074 L
.1875 .31958 L
.20312 .3286 L
.21904 .33779 L
.23523 .34713 L
.25168 .35663 L
.26838 .36627 L
.28531 .37605 L
.30244 .38594 L
.31978 .39595 L
.33729 .40606 L
.35496 .41626 L
.37278 .42655 L
.39072 .43691 L
.40877 .44733 L
.4269 .4578 L
.44511 .46831 L
.46338 .47886 L
.48168 .48942 L
.5 .5 L
.5 .5 L
s
.2619 .08761 m
.2695 .10076 L
.27732 .11432 L
.28537 .12825 L
.29362 .14255 L
.30208 .1572 L
.31074 .17219 L
.31958 .1875 L
.3286 .20312 L
.33779 .21904 L
.34713 .23523 L
.35663 .25168 L
.36627 .26838 L
.37605 .28531 L
.38594 .30244 L
.39595 .31978 L
.40606 .33729 L
.41626 .35496 L
.42655 .37278 L
.43691 .39072 L
.44733 .40877 L
.4578 .4269 L
.46831 .44511 L
.47886 .46338 L
.48942 .48168 L
.5 .5 L
.5 .5 L
s
.5 .02381 m
.5 .039 L
.5 .05465 L
.5 .07074 L
.5 .08725 L
.5 .10416 L
.5 .12147 L
.5 .13916 L
.5 .15719 L
.5 .17557 L
.5 .19427 L
.5 .21327 L
.5 .23255 L
.5 .25209 L
.5 .27188 L
.5 .2919 L
.5 .31212 L
.5 .33252 L
.5 .35309 L
.5 .37381 L
.5 .39465 L
.5 .4156 L
.5 .43662 L
.5 .45771 L
.5 .47885 L
.5 .5 L
.5 .5 L
s
.7381 .08761 m
.7305 .10076 L
.72268 .11432 L
.71463 .12825 L
.70638 .14255 L
.69792 .1572 L
.68926 .17219 L
.68042 .1875 L
.6714 .20312 L
.66221 .21904 L
.65287 .23523 L
.64337 .25168 L
.63373 .26838 L
.62395 .28531 L
.61406 .30244 L
.60405 .31978 L
.59394 .33729 L
.58374 .35496 L
.57345 .37278 L
.56309 .39072 L
.55267 .40877 L
.5422 .4269 L
.53169 .44511 L
.52114 .46338 L
.51058 .48168 L
.5 .5 L
.5 .5 L
s
.91239 .2619 m
.89924 .2695 L
.88568 .27732 L
.87175 .28537 L
.85745 .29362 L
.8428 .30208 L
.82781 .31074 L
.8125 .31958 L
.79688 .3286 L
.78096 .33779 L
.76477 .34713 L
.74832 .35663 L
.73162 .36627 L
.71469 .37605 L
.69756 .38594 L
.68022 .39595 L
.66271 .40606 L
.64504 .41626 L
.62722 .42655 L
.60928 .43691 L
.59123 .44733 L
.5731 .4578 L
.55489 .46831 L
.53662 .47886 L
.51832 .48942 L
.5 .5 L
.5 .5 L
s
.97619 .5 m
.961 .5 L
.94535 .5 L
.92926 .5 L
.91275 .5 L
.89584 .5 L
.87853 .5 L
.86084 .5 L
.84281 .5 L
.82443 .5 L
.80573 .5 L
.78673 .5 L
.76745 .5 L
.74791 .5 L
.72812 .5 L
.7081 .5 L
.68788 .5 L
.66748 .5 L
.64691 .5 L
.62619 .5 L
.60535 .5 L
.5844 .5 L
.56338 .5 L
.54229 .5 L
.52115 .5 L
.5 .5 L
.5 .5 L
s
.91239 .7381 m
.89924 .7305 L
.88568 .72268 L
.87175 .71463 L
.85745 .70638 L
.8428 .69792 L
.82781 .68926 L
.8125 .68042 L
.79688 .6714 L
.78096 .66221 L
.76477 .65287 L
.74832 .64337 L
.73162 .63373 L
.71469 .62395 L
.69756 .61406 L
.68022 .60405 L
.66271 .59394 L
.64504 .58374 L
.62722 .57345 L
.60928 .56309 L
.59123 .55267 L
.5731 .5422 L
.55489 .53169 L
.53662 .52114 L
.51832 .51058 L
.5 .5 L
.5 .5 L
s
.7381 .91239 m
.7305 .89924 L
.72268 .88568 L
.71463 .87175 L
.70638 .85745 L
.69792 .8428 L
.68926 .82781 L
.68042 .8125 L
.6714 .79688 L
.66221 .78096 L
.65287 .76477 L
.64337 .74832 L
.63373 .73162 L
.62395 .71469 L
.61406 .69756 L
.60405 .68022 L
.59394 .66271 L
.58374 .64504 L
.57345 .62722 L
.56309 .60928 L
.55267 .59123 L
.5422 .5731 L
.53169 .55489 L
.52114 .53662 L
.51058 .51832 L
.5 .5 L
.5 .5 L
s
.5 .97619 m
.5 .961 L
.5 .94535 L
.5 .92926 L
.5 .91275 L
.5 .89584 L
.5 .87853 L
.5 .86084 L
.5 .84281 L
.5 .82443 L
.5 .80573 L
.5 .78673 L
.5 .76745 L
.5 .74791 L
.5 .72812 L
.5 .7081 L
.5 .68788 L
.5 .66748 L
.5 .64691 L
.5 .62619 L
.5 .60535 L
.5 .5844 L
.5 .56338 L
.5 .54229 L
.5 .52115 L
.5 .5 L
.5 .5 L
s
.5 .97619 m
.5 .97619 L
.4701 .97525 L
.44032 .97244 L
.41077 .96776 L
.38158 .96123 L
.35285 .95288 L
.3247 .94275 L
.29725 .93087 L
.27059 .91729 L
.24484 .90206 L
.2201 .88525 L
.19646 .86691 L
.17403 .84713 L
.15287 .82597 L
.13309 .80354 L
.11475 .7799 L
.09794 .75516 L
.08271 .72941 L
.06913 .70275 L
.05725 .6753 L
.04712 .64715 L
.03877 .61842 L
.03224 .58923 L
.02756 .55968 L
.02475 .5299 L
.02381 .5 L
.02475 .4701 L
.02756 .44032 L
.03224 .41077 L
.03877 .38158 L
.04712 .35285 L
.05725 .3247 L
.06913 .29725 L
.08271 .27059 L
.09794 .24484 L
.11475 .2201 L
.13309 .19646 L
.15287 .17403 L
.17403 .15287 L
.19646 .13309 L
.2201 .11475 L
.24484 .09794 L
.27059 .08271 L
.29725 .06913 L
.3247 .05725 L
.35285 .04712 L
.38158 .03877 L
.41077 .03224 L
.44032 .02756 L
Mistroke
.4701 .02475 L
.5 .02381 L
.5299 .02475 L
.55968 .02756 L
.58923 .03224 L
.61842 .03877 L
.64715 .04712 L
.6753 .05725 L
.70275 .06913 L
.72941 .08271 L
.75516 .09794 L
.7799 .11475 L
.80354 .13309 L
.82597 .15287 L
.84713 .17403 L
.86691 .19646 L
.88525 .2201 L
.90206 .24484 L
.91729 .27059 L
.93087 .29725 L
.94275 .3247 L
.95288 .35285 L
.96123 .38158 L
.96776 .41077 L
.97244 .44032 L
.97525 .4701 L
.97619 .5 L
.97525 .5299 L
.97244 .55968 L
.96776 .58923 L
.96123 .61842 L
.95288 .64715 L
.94275 .6753 L
.93087 .70275 L
.91729 .72941 L
.90206 .75516 L
.88525 .7799 L
.86691 .80354 L
.84713 .82597 L
.82597 .84713 L
.80354 .86691 L
.7799 .88525 L
.75516 .90206 L
.72941 .91729 L
.70275 .93087 L
.6753 .94275 L
.64715 .95288 L
.61842 .96123 L
.58923 .96776 L
.55968 .97244 L
Mistroke
.5299 .97525 L
.5 .97619 L
.5 .97619 L
.5 .97619 L
Mfstroke
.5 .83672 m
.5 .83672 L
.47886 .83605 L
.4578 .83406 L
.43691 .83075 L
.41626 .82614 L
.39595 .82024 L
.37605 .81307 L
.35663 .80467 L
.33779 .79507 L
.31958 .7843 L
.30208 .77241 L
.28537 .75945 L
.2695 .74546 L
.25454 .7305 L
.24055 .71463 L
.22759 .69792 L
.2157 .68042 L
.20493 .66221 L
.19533 .64337 L
.18693 .62395 L
.17976 .60405 L
.17386 .58374 L
.16925 .56309 L
.16594 .5422 L
.16395 .52114 L
.16328 .5 L
.16395 .47886 L
.16594 .4578 L
.16925 .43691 L
.17386 .41626 L
.17976 .39595 L
.18693 .37605 L
.19533 .35663 L
.20493 .33779 L
.2157 .31958 L
.22759 .30208 L
.24055 .28537 L
.25454 .2695 L
.2695 .25454 L
.28537 .24055 L
.30208 .22759 L
.31958 .2157 L
.33779 .20493 L
.35663 .19533 L
.37605 .18693 L
.39595 .17976 L
.41626 .17386 L
.43691 .16925 L
.4578 .16594 L
Mistroke
.47886 .16395 L
.5 .16328 L
.52114 .16395 L
.5422 .16594 L
.56309 .16925 L
.58374 .17386 L
.60405 .17976 L
.62395 .18693 L
.64337 .19533 L
.66221 .20493 L
.68042 .2157 L
.69792 .22759 L
.71463 .24055 L
.7305 .25454 L
.74546 .2695 L
.75945 .28537 L
.77241 .30208 L
.7843 .31958 L
.79507 .33779 L
.80467 .35663 L
.81307 .37605 L
.82024 .39595 L
.82614 .41626 L
.83075 .43691 L
.83406 .4578 L
.83605 .47886 L
.83672 .5 L
.83605 .52114 L
.83406 .5422 L
.83075 .56309 L
.82614 .58374 L
.82024 .60405 L
.81307 .62395 L
.80467 .64337 L
.79507 .66221 L
.7843 .68042 L
.77241 .69792 L
.75945 .71463 L
.74546 .7305 L
.7305 .74546 L
.71463 .75945 L
.69792 .77241 L
.68042 .7843 L
.66221 .79507 L
.64337 .80467 L
.62395 .81307 L
.60405 .82024 L
.58374 .82614 L
.56309 .83075 L
.5422 .83406 L
Mistroke
.52114 .83605 L
.5 .83672 L
.5 .83672 L
.5 .83672 L
Mfstroke
.5 .6743 m
.5 .6743 L
.48906 .67395 L
.47815 .67292 L
.46734 .67121 L
.45665 .66882 L
.44614 .66577 L
.43584 .66206 L
.42579 .65771 L
.41603 .65274 L
.40661 .64716 L
.39755 .64101 L
.3889 .6343 L
.38068 .62706 L
.37294 .61932 L
.3657 .6111 L
.35899 .60245 L
.35284 .59339 L
.34726 .58397 L
.34229 .57421 L
.33794 .56416 L
.33423 .55386 L
.33118 .54335 L
.32879 .53266 L
.32708 .52185 L
.32605 .51094 L
.3257 .5 L
.32605 .48906 L
.32708 .47815 L
.32879 .46734 L
.33118 .45665 L
.33423 .44614 L
.33794 .43584 L
.34229 .42579 L
.34726 .41603 L
.35284 .40661 L
.35899 .39755 L
.3657 .3889 L
.37294 .38068 L
.38068 .37294 L
.3889 .3657 L
.39755 .35899 L
.40661 .35284 L
.41603 .34726 L
.42579 .34229 L
.43584 .33794 L
.44614 .33423 L
.45665 .33118 L
.46734 .32879 L
.47815 .32708 L
Mistroke
.48906 .32605 L
.5 .3257 L
.51094 .32605 L
.52185 .32708 L
.53266 .32879 L
.54335 .33118 L
.55386 .33423 L
.56416 .33794 L
.57421 .34229 L
.58397 .34726 L
.59339 .35284 L
.60245 .35899 L
.6111 .3657 L
.61932 .37294 L
.62706 .38068 L
.6343 .3889 L
.64101 .39755 L
.64716 .40661 L
.65274 .41603 L
.65771 .42579 L
.66206 .43584 L
.66577 .44614 L
.66882 .45665 L
.67121 .46734 L
.67292 .47815 L
.67395 .48906 L
.6743 .5 L
.67395 .51094 L
.67292 .52185 L
.67121 .53266 L
.66882 .54335 L
.66577 .55386 L
.66206 .56416 L
.65771 .57421 L
.65274 .58397 L
.64716 .59339 L
.64101 .60245 L
.6343 .6111 L
.62706 .61932 L
.61932 .62706 L
.6111 .6343 L
.60245 .64101 L
.59339 .64716 L
.58397 .65274 L
.57421 .65771 L
.56416 .66206 L
.55386 .66577 L
.54335 .66882 L
.53266 .67121 L
.52185 .67292 L
Mistroke
.51094 .67395 L
.5 .6743 L
.5 .6743 L
.5 .6743 L
Mfstroke
.5 .5 m
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
Mistroke
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
Mistroke
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
Mfstroke
.541 g
.76997 .3521 m
.77495 .3663 L
.77132 .37797 L
.77709 .38673 L
.77671 .40445 L
.78684 .40504 L
.78895 .42213 L
.78948 .42008 L
.78784 .40444 L
.79682 .39138 L
.8058 .38465 L
.80359 .36936 L
.8089 .36408 L
.79471 .33574 L
.79232 .34359 L
.77961 .34234 L
.76997 .3521 L
F
.588 g
.598 .231 m
.5911 .24083 L
.59347 .24549 L
.60029 .2385 L
.598 .231 L
F
.802 g
.54507 .20256 m
.5 .19339 L
.48799 .18971 L
.49327 .1741 L
.47817 .1727 L
.47897 .16888 L
.44828 .16069 L
.44748 .15546 L
.44719 .15355 L
.46972 .13943 L
.5 .12261 L
.52893 .11073 L
.57675 .13891 L
.55816 .14866 L
.55557 .1691 L
.54135 .18595 L
.54507 .20256 L
F
.226 g
.50828 .2289 m
.50709 .22941 L
.50701 .2294 L
.50828 .2289 L
F
.567 g
.69258 .29469 m
.69677 .30334 L
.70471 .30472 L
.71233 .30533 L
.71097 .30165 L
.70697 .3013 L
.70198 .29673 L
.69258 .29469 L
F
.571 g
.54123 .25961 m
.55511 .26223 L
.5567 .26975 L
.5712 .2695 L
.56872 .26219 L
.55913 .25775 L
.54497 .25658 L
.5411 .257 L
.54064 .25803 L
.54123 .25961 L
F
.346 g
.70198 .29673 m
.70697 .3013 L
.71097 .30165 L
.70977 .2986 L
.70198 .29673 L
F
.71233 .30533 m
.70471 .30472 L
.69677 .30334 L
.70539 .30881 L
.69874 .31008 L
.70619 .31337 L
.70608 .31821 L
.71833 .31938 L
.72061 .30743 L
.71353 .30863 L
.71233 .30533 L
F
.518 g
.77447 .27375 m
% vacuous filled polygon
newpath
.425 g
.88043 .51461 m
.87198 .50963 L
.86699 .4952 L
.87477 .50403 L
.87693 .49364 L
.86038 .49381 L
.85357 .49023 L
.86043 .49906 L
.86135 .51515 L
.86851 .5075 L
.87179 .51049 L
.86829 .51468 L
.87627 .51709 L
.88043 .51461 L
F
.888 g
.58309 .3089 m
.58863 .31264 L
.5885 .32119 L
.59269 .3264 L
.59887 .32865 L
.61028 .32155 L
.6148 .31364 L
.60173 .30317 L
.58881 .29671 L
.58309 .3089 L
F
.98 g
.50998 .27589 m
.51314 .27772 L
.5237 .27516 L
.52453 .27172 L
.5236 .2683 L
.50998 .27589 L
F
.954 g
.10664 .48821 m
.09432 .49233 L
.10334 .494 L
.10664 .48821 L
F
.573 g
.51282 .05051 m
.52141 .0515 L
.52644 .07588 L
.51777 .07603 L
.50723 .0717 L
.51282 .05051 L
F
.805 g
.20618 .36143 m
% vacuous filled polygon
newpath
.051 g
.85022 .49338 m
.84525 .5 L
.84788 .51002 L
.85022 .49338 L
F
.685 g
.58666 .24299 m
.57387 .24848 L
.57212 .25014 L
.57057 .25308 L
.58155 .25582 L
.58326 .25544 L
.58666 .24299 L
F
.634 g
.12952 .20083 m
.13957 .19631 L
.13976 .21533 L
.12883 .21759 L
.11975 .22994 L
.10988 .24146 L
.09573 .25948 L
.10502 .26888 L
.10387 .278 L
.09732 .28151 L
.08955 .28981 L
.08553 .30497 L
.08228 .29082 L
.06677 .31491 L
.0597 .33844 L
.05762 .33122 L
.05467 .33835 L
.05242 .33743 L
.05242 .33743 L
.05725 .3247 L
.06913 .29725 L
.08271 .27059 L
.09794 .24484 L
.11475 .2201 L
.12952 .20083 L
F
.807 g
.91701 .68639 m
.91281 .69264 L
.91274 .69261 L
.91701 .68639 L
F
.91223 .69354 m
.91295 .69285 L
.91223 .69354 L
F
.144 g
.62654 .26775 m
.62871 .25811 L
.62225 .25319 L
.60809 .24453 L
.60099 .25839 L
.62654 .26775 L
F
.241 g
.47963 .06528 m
.45857 .07107 L
.47116 .08408 L
.5 .09004 L
.50167 .09004 L
.51777 .07611 L
.50723 .0717 L
.49876 .07225 L
.47883 .07217 L
.47963 .06528 L
F
.831 g
.92628 .56561 m
.89896 .55418 L
.89557 .54775 L
.90354 .54004 L
.90432 .53005 L
.88824 .52772 L
.88051 .51462 L
.87627 .51709 L
.85237 .53165 L
.84873 .54364 L
.84291 .54423 L
.84268 .54908 L
.8534 .55418 L
.86394 .54813 L
.86188 .55667 L
.87154 .57323 L
.87864 .56733 L
.87154 .57323 L
.87864 .56733 L
.88998 .5503 L
.89859 .56265 L
.90533 .55829 L
.91854 .57129 L
.92628 .56561 L
F
.944 g
.61862 .07226 m
.64075 .08136 L
.66585 .10481 L
.66672 .10501 L
.67502 .0978 L
.70969 .09632 L
.67431 .0757 L
.64967 .0702 L
.64745 .06269 L
.63172 .0577 L
.63026 .05165 L
.61214 .06379 L
.61862 .07226 L
F
.881 g
.91736 .60755 m
.91471 .59511 L
.90707 .589 L
.89851 .6084 L
.89221 .62404 L
.90255 .62731 L
.90916 .61617 L
.91736 .60755 L
F
.014 g
.57951 .0405 m
.57768 .04792 L
.56815 .04936 L
.5761 .05941 L
.59181 .06369 L
.60769 .08806 L
.6018 .09372 L
.61704 .08317 L
.60475 .07829 L
.61862 .07226 L
.61214 .06379 L
.63026 .05165 L
.60746 .04543 L
.59179 .04201 L
.57951 .0405 L
F
.813 g
.30161 .62753 m
.28993 .60719 L
.28809 .60351 L
.27116 .55706 L
.26602 .52956 L
.25867 .49824 L
.25194 .47451 L
.23391 .46457 L
.23127 .46534 L
.22662 .46498 L
.23604 .44829 L
.23687 .44917 L
.23775 .44934 L
.24744 .43609 L
.25318 .42618 L
.25569 .41826 L
.25775 .41698 L
.27161 .41339 L
.26334 .40052 L
.26641 .39461 L
.27224 .39258 L
.26828 .39162 L
.27141 .38537 L
.26134 .39466 L
.258 .38954 L
.27594 .37563 L
.27687 .38094 L
.27293 .38802 L
.28052 .39617 L
.2781 .40512 L
.28516 .39622 L
.28681 .40262 L
.26492 .42043 L
.2742 .41662 L
.27397 .42247 L
.27436 .41646 L
.29375 .40147 L
.30122 .38585 L
.32005 .37686 L
.32418 .38036 L
.32456 .39052 L
.31547 .39524 L
.32393 .39154 L
.32753 .38949 L
.32343 .40085 L
.3294 .41005 L
.34413 .42676 L
.33197 .42542 L
.33095 .4317 L
.32505 .43412 L
.33054 .43222 L
.33552 .44347 L
.34167 .44038 L
.34354 .44941 L
.34244 .4668 L
.32148 .4639 L
.31523 .45593 L
.30613 .45572 L
.29879 .46368 L
.27755 .4581 L
.28396 .46919 L
.30015 .47298 L
.29805 .48381 L
.30784 .49609 L
.30841 .50965 L
.31762 .51371 L
.32914 .51435 L
.34318 .50173 L
.34989 .50993 L
.34965 .49471 L
.35577 .49253 L
.35975 .50367 L
.35621 .49347 L
.36188 .48475 L
.36573 .48876 L
.36721 .48015 L
.37972 .48167 L
.38264 .4909 L
.36735 .49316 L
.37865 .49778 L
.37285 .50055 L
.38128 .50605 L
.39499 .50839 L
.38459 .51322 L
.37537 .50733 L
.36998 .51244 L
.36404 .51385 L
.37072 .51401 L
.37585 .51712 L
.37032 .51638 L
.37264 .52761 L
.38179 .53438 L
.37911 .54033 L
.37979 .53368 L
.3682 .54092 L
.37932 .54412 L
.38259 .555 L
.38806 .55216 L
.40033 .56808 L
.4044 .56583 L
.4015 .57009 L
.41051 .56992 L
.40863 .57887 L
.41044 .58489 L
.41117 .57366 L
.41229 .58193 L
.41205 .58846 L
.42516 .59248 L
.39138 .63413 L
.37696 .62506 L
.34885 .62691 L
.3402 .63432 L
.33624 .63245 L
.32962 .63472 L
.32592 .62991 L
.32549 .63577 L
.32307 .63716 L
.31507 .62861 L
.30157 .62763 L
F
.34503 .63791 m
.34398 .64397 L
.34865 .64147 L
.34503 .63791 L
F
.32026 .63775 m
.30024 .63247 L
.3203 .63781 L
F
.41878 .54639 m
.41256 .54136 L
.40698 .55995 L
.41461 .56204 L
.42462 .55236 L
.4188 .54641 L
F
.40738 .5424 m
.403 .53264 L
.39751 .533 L
.40731 .53027 L
.40048 .52704 L
.38605 .52208 L
.37925 .52766 L
.38515 .5342 L
.38447 .54979 L
.39621 .55388 L
.39298 .54212 L
.39941 .55251 L
.40212 .54578 L
.40634 .55213 L
.41116 .54595 L
.40738 .5424 L
F
.35485 .48222 m
.34728 .47572 L
.344 .48699 L
.34631 .49244 L
.35992 .48926 L
.35485 .48222 L
F
.40663 .52412 m
.40314 .52647 L
.40751 .52833 L
.40663 .52412 L
F
.38349 .5161 m
.37593 .51202 L
.37827 .52022 L
.38349 .5161 L
F
.3173 .37498 m
.30508 .37269 L
.30606 .36613 L
.31171 .36059 L
.30345 .35544 L
.30812 .35453 L
.30114 .3506 L
.30369 .35868 L
.29628 .35937 L
.30025 .36408 L
.29068 .37571 L
.29188 .37692 L
.30425 .37689 L
.31723 .37493 L
F
.28486 .37737 m
.27761 .37749 L
.28165 .37292 L
.27794 .37952 L
.28486 .37737 L
F
.38302 .45091 m
.38042 .43444 L
.3689 .43478 L
.3756 .44026 L
.3713 .44939 L
.36828 .44512 L
.35743 .4324 L
.35724 .4452 L
.35039 .4336 L
.35127 .44995 L
.35603 .46196 L
.35416 .469 L
.36035 .46887 L
.35739 .46281 L
.36273 .4593 L
.36714 .4549 L
.37214 .45147 L
.37024 .46029 L
.37891 .47126 L
.38909 .47847 L
.3829 .48135 L
.38449 .4958 L
.38934 .49916 L
.39397 .50003 L
.40571 .49365 L
.38893 .49379 L
.40016 .49246 L
.40566 .48669 L
.39529 .48335 L
.40157 .4774 L
.39362 .47166 L
.3934 .46819 L
.39746 .46652 L
.3919 .46616 L
.38917 .46299 L
.39501 .46151 L
.39083 .45809 L
.38755 .45915 L
.389 .45235 L
.3844 .45655 L
.38302 .45091 L
F
.40674 .5083 m
.40569 .50033 L
.39482 .50748 L
.40674 .5083 L
F
.43498 .53552 m
.42976 .53411 L
.42816 .54204 L
.4316 .54447 L
.43498 .53552 L
F
.43928 .5148 m
.42955 .51139 L
.43393 .51748 L
.43928 .5148 L
F
.42291 .51413 m
.41355 .51156 L
.4174 .51874 L
.42225 .51634 L
.42291 .51413 L
F
.495 g
.65809 .14493 m
.60178 .14506 L
.5962 .14097 L
.606 .13032 L
.60706 .11351 L
.59804 .0958 L
.6018 .09372 L
.61704 .08317 L
.60475 .07829 L
.61862 .07226 L
.64075 .08136 L
.66585 .10481 L
.65625 .10999 L
.65874 .12481 L
.66542 .12847 L
.65809 .14493 L
F
.496 g
.73449 .66036 m
.74932 .65089 L
.74167 .65033 L
.73725 .64749 L
.74688 .64177 L
.75986 .63691 L
.76137 .64448 L
.75109 .6612 L
.77092 .65193 L
.77834 .67325 L
.78227 .66046 L
.78173 .67525 L
.79028 .66861 L
.78564 .67941 L
.80245 .67768 L
.81117 .67319 L
.82795 .66842 L
.84208 .65433 L
.84067 .64742 L
.8444 .65011 L
.85224 .6397 L
.85566 .63192 L
.86211 .6312 L
.86006 .62999 L
.85634 .62935 L
.86027 .61694 L
.86045 .61793 L
.85728 .59919 L
.86626 .57874 L
.87154 .57323 L
.86188 .55667 L
.86394 .54813 L
.8534 .55418 L
.84268 .54908 L
.84291 .54423 L
.83752 .53597 L
.84788 .51002 L
.84525 .5 L
.85022 .49338 L
.84733 .48878 L
.83158 .44758 L
.81713 .4349 L
.81773 .44111 L
.81041 .4391 L
.80591 .44716 L
.8014 .43493 L
.78948 .42008 L
.78892 .42204 L
.77332 .42163 L
.7697 .45374 L
.75423 .45456 L
.75483 .46675 L
.74382 .47021 L
.74502 .4815 L
.73504 .48905 L
.73476 .49112 L
.74706 .50388 L
.75597 .50313 L
.76053 .52463 L
.76829 .53002 L
.76821 .53001 L
.76567 .57235 L
.75389 .59308 L
.74553 .59904 L
.73844 .59634 L
.71554 .62394 L
.71223 .61491 L
.71825 .60449 L
.70656 .60396 L
.70091 .61244 L
.68612 .6076 L
.67918 .61211 L
.67348 .62428 L
.68353 .64099 L
.67945 .65417 L
.68343 .65936 L
.6704 .66883 L
.68766 .67571 L
.69533 .6695 L
.70627 .6768 L
.73449 .66036 L
F
.86404 .62939 m
.86088 .63817 L
.86719 .63753 L
.87272 .62604 L
.864 .62949 L
F
.388 g
.09788 .36402 m
.08708 .38833 L
.06959 .39865 L
.07178 .40402 L
.06471 .40655 L
.05208 .39686 L
.03873 .40881 L
.03895 .38088 L
.03895 .38088 L
.04712 .35285 L
.05242 .33743 L
.05242 .33743 L
.05467 .33835 L
.05762 .33122 L
.0597 .33844 L
.06677 .31491 L
.06979 .32487 L
.08464 .32753 L
.07568 .36213 L
.08169 .37516 L
.09788 .36402 L
.09788 .36402 L
F
.606 g
.64198 .04547 m
.64745 .06269 L
.63172 .0577 L
.63026 .05165 L
.60746 .04543 L
.6073 .04135 L
.61825 .04275 L
.6191 .03894 L
.6191 .03894 L
.64198 .04547 L
F
.555 g
.0739 .45258 m
.06883 .44375 L
.06172 .44541 L
.06791 .46726 L
.07316 .46778 L
.0739 .45258 L
F
.542 g
.43998 .04618 m
.47542 .04606 L
.47542 .04606 L
.47963 .06528 L
.47963 .06528 L
.45858 .07115 L
.45857 .07107 L
.44011 .07205 L
.44011 .07205 L
.43467 .0611 L
.43467 .0611 L
.44012 .04616 L
F
.815 g
.58696 .24234 m
.56441 .25215 L
.56162 .25256 L
.56863 .25611 L
.57086 .26129 L
.57779 .25868 L
.58165 .26083 L
.58326 .25544 L
.58155 .25582 L
.57057 .25308 L
.57212 .25014 L
.57387 .24848 L
.58666 .24299 L
.58696 .24234 L
F
.801 g
.1245 .4666 m
.1338 .44287 L
.13145 .41694 L
.1293 .39464 L
.12364 .41633 L
.13049 .4473 L
.1245 .4666 L
F
.504 g
.67453 .24685 m
.67074 .23742 L
.66582 .23736 L
.67453 .24685 L
F
.379 g
.56835 .2695 m
.57126 .27759 L
.57564 .28176 L
.55774 .28198 L
.54791 .2765 L
.5567 .26975 L
.56835 .2695 L
F
.13 g
.5306 .29925 m
.52739 .30833 L
.533 .31189 L
.52759 .30969 L
.53426 .31603 L
.53342 .29923 L
.53059 .29934 L
F
.972 g
.79208 .18988 m
.78785 .18605 L
.78742 .19303 L
.78376 .18225 L
.79187 .18646 L
.79208 .18988 L
F
.87 g
.13176 .37869 m
.13483 .3548 L
.12423 .37633 L
.13176 .37869 L
F
.572 g
.03099 .41761 m
.03873 .40881 L
.03895 .38088 L
.03895 .38088 L
.03877 .38158 L
.03224 .41077 L
.03099 .41761 L
F
.986 g
.71608 .19837 m
.68118 .21377 L
.69596 .21219 L
.69428 .22219 L
.69415 .22169 L
.68609 .22686 L
.68552 .22719 L
.63952 .20284 L
.65915 .1587 L
.7109 .18655 L
.71608 .19837 L
F
.731 g
.08307 .48423 m
.08424 .50073 L
.08743 .49532 L
.08307 .48423 L
F
.039 g
.58034 .03487 m
.57951 .0405 L
.59179 .04201 L
.59289 .03721 L
.58034 .03487 L
F
.992 g
.74541 .16794 m
.74088 .18034 L
.74694 .19084 L
.76171 .18495 L
.78742 .19303 L
.78625 .18944 L
.75814 .17932 L
.74541 .16794 L
F
.042 g
.58329 .34356 m
.58648 .33458 L
.5761 .32987 L
.57118 .33604 L
.58329 .34356 L
F
.666 g
.74541 .16794 m
.75814 .17932 L
.78625 .18944 L
.78376 .18225 L
.79187 .18646 L
.80391 .18548 L
.82825 .20427 L
.82173 .1777 L
.80677 .1581 L
.79379 .14382 L
.76797 .13027 L
.74068 .12915 L
.74244 .14438 L
.74811 .16037 L
.74541 .16794 L
F
.23 g
.55775 .37129 m
.56276 .36813 L
.55708 .35209 L
.56243 .34082 L
.56822 .33837 L
.57996 .34876 L
.58259 .36567 L
.55944 .39285 L
.5593 .39288 L
.55449 .39708 L
.55336 .38938 L
.54308 .38539 L
.55775 .37129 L
F
.171 g
.53465 .23798 m
.53422 .23774 L
.53408 .23763 L
.51799 .23505 L
.51524 .22885 L
.50828 .2289 L
.50709 .22941 L
.49179 .23375 L
.49512 .2495 L
.48011 .26233 L
.4944 .26221 L
.49218 .26833 L
.5 .26599 L
.50998 .27589 L
.5236 .2683 L
.52587 .26817 L
.5338 .26641 L
.53215 .25851 L
.5261 .25027 L
.53093 .24926 L
.53465 .23798 L
F
.623 g
.13238 .23454 m
.13853 .22695 L
.13976 .21533 L
.12883 .21759 L
.11975 .22994 L
.13238 .23454 L
F
.482 g
.58034 .03487 m
.57561 .02985 L
.57561 .02985 L
.58923 .03224 L
.61842 .03877 L
.6191 .03894 L
.6191 .03894 L
.61825 .04275 L
.6073 .04135 L
.60746 .04543 L
.59179 .04201 L
.59289 .03721 L
.58034 .03487 L
.58034 .03487 L
F
.842 g
.38123 .10076 m
.38993 .09763 L
.37923 .09871 L
.37927 .09886 L
.40042 .09459 L
.38123 .10076 L
F
.565 g
.67128 .29588 m
.68743 .30557 L
.69874 .31008 L
.70539 .30881 L
.69677 .30334 L
.69258 .29469 L
.68334 .29302 L
.67128 .29588 L
F
.068 g
.52662 .28929 m
.53599 .29239 L
.53059 .29934 L
.53342 .29923 L
.5334 .29932 L
.5394 .29538 L
.55165 .29687 L
.55126 .29792 L
.55774 .28198 L
.54791 .2765 L
.5567 .26975 L
.55511 .26223 L
.54123 .25961 L
.54053 .2595 L
.53215 .25851 L
.5338 .26641 L
.52587 .26817 L
.52453 .27172 L
.52371 .27506 L
.52662 .28929 L
F
.94 g
.47542 .04606 m
.5 .04771 L
.50943 .04992 L
.5 .06983 L
.49938 .07028 L
.5 .0721 L
.49888 .07225 L
.47883 .07217 L
.47963 .06528 L
.47542 .04606 L
F
.027 g
.47149 .19648 m
.47139 .1964 L
.47148 .19639 L
F
.764 g
.6232 .24779 m
.61286 .2429 L
.60834 .23951 L
.61133 .23145 L
.61996 .23141 L
.61489 .22558 L
.61955 .22108 L
.60656 .22384 L
.61126 .2276 L
.61614 .22945 L
.60046 .22964 L
.598 .231 L
.60029 .2385 L
.60809 .24453 L
.62232 .25322 L
.6232 .24779 L
F
.564 g
.41851 .38708 m
.4329 .39461 L
.44264 .38847 L
.45563 .39181 L
.44408 .39994 L
.45296 .40101 L
.44994 .40819 L
.45801 .39376 L
.45557 .40705 L
.45532 .41399 L
.46606 .40921 L
.46599 .41632 L
.47043 .41403 L
.46683 .41965 L
.47167 .41926 L
.4705 .42865 L
.4762 .42727 L
.4729 .43303 L
.48452 .44643 L
.47993 .44839 L
.48962 .45178 L
.47698 .44942 L
.48236 .45699 L
.47997 .45751 L
.47365 .45888 L
.4842 .45951 L
.47528 .46533 L
.48291 .46444 L
.47957 .46856 L
.47016 .47186 L
.47237 .46696 L
.46957 .47036 L
.46597 .46553 L
.46237 .46827 L
.46041 .47582 L
.45759 .47188 L
.45892 .47641 L
.44184 .47386 L
.43561 .47986 L
.43299 .47026 L
.42804 .47574 L
.42409 .4701 L
.42895 .45912 L
.41124 .43991 L
.41688 .43864 L
.41209 .42749 L
.40771 .43449 L
.41021 .42523 L
.39841 .4245 L
.40105 .41741 L
.39423 .4224 L
.39974 .41871 L
.39265 .42162 L
.39734 .41497 L
.39174 .42125 L
.38793 .41703 L
.39708 .41364 L
.38742 .41659 L
.39063 .41 L
.3857 .41251 L
.38153 .40744 L
.38776 .40582 L
.38044 .40133 L
.37346 .38699 L
.38113 .38202 L
.37677 .37727 L
.38129 .37315 L
.38898 .3787 L
.39151 .38426 L
.40459 .39069 L
.41851 .38708 L
F
.40652 .43283 m
.40639 .42643 L
.40235 .42792 L
.40652 .43283 L
F
.561 g
.09432 .49233 m
.09359 .48735 L
.08743 .49532 L
.08424 .50073 L
.08826 .51618 L
.09521 .51225 L
.0952 .50306 L
.10335 .50681 L
.10334 .494 L
.09432 .49233 L
F
.897 g
.39942 .07451 m
.38895 .08605 L
.40025 .09132 L
.41701 .08657 L
.41683 .0863 L
.43411 .0832 L
.43997 .07199 L
.44011 .07205 L
.43467 .0611 L
.42164 .06737 L
.4158 .07539 L
.39942 .07451 L
F
.792 g
.37851 .09549 m
.39027 .09049 L
.38593 .08868 L
.38895 .08605 L
.40025 .09132 L
.37851 .09549 L
F
.694 g
.11912 .25501 m
.11647 .26666 L
.12097 .26758 L
.1195 .28017 L
.10424 .28407 L
.10387 .278 L
.10502 .26888 L
.09573 .25948 L
.10988 .24146 L
.11029 .25696 L
.11912 .25501 L
F
.989 g
.12419 .3762 m
.12058 .39466 L
.12522 .38075 L
.12858 .38963 L
.13179 .37858 L
.12419 .3762 L
F
.911 g
.09359 .48735 m
.09298 .45099 L
.08117 .48025 L
.08307 .48423 L
.08743 .49532 L
.09359 .48735 L
F
.061 g
.59402 .27743 m
.59013 .27859 L
.5712 .2695 L
.56872 .26219 L
.57779 .25868 L
.58716 .26394 L
.59402 .27743 L
F
.655 g
.44449 .35812 m
.44029 .3662 L
.44706 .36697 L
.44067 .37001 L
.44601 .37352 L
.44791 .36489 L
.46187 .36847 L
.46628 .36095 L
.45182 .35316 L
.44449 .35812 L
F
.997 g
.87693 .49364 m
.8743 .48628 L
.88559 .47585 L
.90086 .43136 L
.92091 .42465 L
.92931 .42004 L
.9287 .40076 L
.88586 .38424 L
.85872 .38976 L
.86209 .38317 L
.86137 .37369 L
.85008 .36526 L
.84991 .37609 L
.84162 .36336 L
.84506 .38186 L
.82962 .37687 L
.82984 .39219 L
.81951 .41249 L
.81451 .41798 L
.80059 .41352 L
.8014 .43493 L
.80591 .44716 L
.81041 .4391 L
.81773 .44111 L
.81713 .4349 L
.8316 .44768 L
.8375 .44089 L
.84658 .45601 L
.85474 .48348 L
.84733 .48878 L
.85022 .49338 L
.84788 .51002 L
.83752 .53597 L
.84291 .54423 L
.84873 .54364 L
.85237 .53165 L
.87627 .51709 L
.86829 .51468 L
.87179 .51049 L
.86851 .5075 L
.86135 .51515 L
.86043 .49906 L
.85357 .49023 L
.86038 .49381 L
.87693 .49364 L
F
.869 g
.95062 .54127 m
.94998 .55937 L
.96127 .60593 L
.96401 .6023 L
.96143 .61277 L
.9623 .61418 L
.9623 .61418 L
.96776 .58923 L
.96997 .57669 L
.96997 .57669 L
.95062 .54127 L
.95062 .54127 L
F
.9403 .65722 m
.94965 .65676 L
.94965 .65676 L
.94275 .6753 L
.93087 .70275 L
.92333 .71805 L
.92333 .71805 L
.91672 .72064 L
.91283 .72899 L
.91063 .70953 L
.90644 .71233 L
.91185 .69969 L
.92412 .69672 L
.94252 .66604 L
.9403 .65722 L
.9403 .65722 L
F
.91324 .73662 m
.90967 .73684 L
.88375 .77121 L
.89235 .76714 L
.91009 .73916 L
.911 .74049 L
.911 .74049 L
.91324 .73662 L
F
.86994 .79851 m
.87501 .79211 L
.8752 .79323 L
.8752 .79323 L
.87607 .79211 L
.87607 .79211 L
.87607 .78927 L
.86772 .78781 L
.87408 .78843 L
.86994 .79851 L
.86994 .79851 L
F
.395 g
.81747 .32847 m
.80347 .30877 L
.78485 .29088 L
.75864 .284 L
.75244 .27692 L
.72524 .27789 L
.72198 .28824 L
.71111 .28741 L
.70186 .29673 L
.70977 .2986 L
.71353 .30863 L
.72061 .30743 L
.73494 .31043 L
.7413 .32404 L
.74689 .34089 L
.7581 .34837 L
.76997 .3521 L
.77961 .34234 L
.79232 .34359 L
.79471 .33574 L
.81384 .34238 L
.81747 .32847 L
F
.497 g
.74997 .27453 m
.75244 .27692 L
.72524 .27789 L
.72198 .28824 L
.71111 .28741 L
.70207 .27832 L
.706 .26303 L
.70016 .25105 L
.70603 .24828 L
.73977 .25784 L
.74777 .26529 L
.74997 .27453 L
F
.02 g
.47734 .2936 m
.4758 .28312 L
.46229 .28092 L
.46036 .2854 L
.46727 .28696 L
.46354 .29568 L
.47448 .29939 L
.47084 .2964 L
.47734 .2936 L
F
.639 g
.68552 .22719 m
.68447 .23752 L
.68605 .23949 L
.68638 .23983 L
.68661 .23999 L
.68824 .23756 L
.69101 .23206 L
.69428 .22219 L
.69415 .22169 L
.68609 .22686 L
.68552 .22719 L
F
.224 g
.56034 .25281 m
.55423 .25056 L
.55618 .24414 L
.59016 .2308 L
.58124 .22779 L
.58182 .21589 L
.57681 .22614 L
.55232 .23332 L
.54613 .24103 L
.53465 .23798 L
.53093 .24926 L
.54495 .25666 L
.55913 .25775 L
.56034 .25281 L
F
.57912 .21696 m
.57867 .20809 L
.5637 .21066 L
.57912 .21696 L
F
.54468 .22568 m
.5447 .21292 L
.53971 .22213 L
.54468 .22568 L
F
.874 g
.11354 .42044 m
% vacuous filled polygon
newpath
.537 g
.74223 .71544 m
.73874 .70766 L
.74626 .7036 L
.75153 .7161 L
.74223 .71544 L
F
.72481 .72169 m
.73608 .72027 L
.73746 .71393 L
.72487 .72175 L
F
.67379 .71564 m
.67643 .72636 L
.69805 .73883 L
.70599 .73572 L
.71237 .72655 L
.7226 .72863 L
.71963 .72221 L
.73929 .70716 L
.72489 .71032 L
.70456 .71758 L
.69763 .72378 L
.67379 .71564 L
F
.65711 .70073 m
.65521 .71181 L
.64976 .72051 L
.66422 .71978 L
.67241 .70891 L
.67231 .71431 L
.67784 .71219 L
.66658 .70867 L
.65711 .70085 L
F
.77673 .71841 m
.78222 .71773 L
.77679 .71847 L
F
.797 g
.69482 .22143 m
.69436 .22225 L
.69101 .23206 L
.68824 .23756 L
.70011 .25112 L
.70603 .24828 L
.69803 .23721 L
.70498 .23286 L
.69482 .22143 L
F
.659 g
.6895 .33652 m
.69185 .34574 L
.70068 .34969 L
.70504 .34689 L
.70393 .33818 L
.69985 .33359 L
.71956 .33355 L
.72931 .34533 L
.71365 .35589 L
.71781 .3674 L
.73508 .37588 L
.75738 .39558 L
.75991 .40282 L
.75749 .41142 L
.75754 .42785 L
.76396 .4451 L
.7697 .45374 L
.75423 .45456 L
.75483 .46675 L
.74382 .47021 L
.74502 .4815 L
.73504 .48905 L
.73494 .49104 L
.72639 .47434 L
.71865 .45934 L
.70101 .4547 L
.70172 .44412 L
.69034 .43309 L
.68254 .40123 L
.69744 .39003 L
.68161 .36862 L
.6722 .36088 L
.67039 .34027 L
.6895 .33652 L
F
.806 g
.76834 .10662 m
.76875 .11666 L
.75631 .12001 L
.76797 .13027 L
.79379 .14382 L
.80687 .15819 L
.80449 .14952 L
.8146 .14253 L
.8146 .14253 L
.80354 .13309 L
.7799 .11475 L
.76834 .10662 L
F
.598 g
.75736 .27164 m
.74997 .27453 L
.74777 .26529 L
.75736 .27164 L
F
.77 g
.7762 .42167 m
.77379 .40848 L
.76703 .40052 L
.76741 .41825 L
.76383 .41036 L
.75749 .41142 L
.75754 .42785 L
.76396 .4451 L
.7697 .45374 L
.77332 .42163 L
.7762 .42167 L
F
.895 g
.87864 .56733 m
.87154 .57323 L
.86626 .57874 L
.87212 .58705 L
.8706 .59688 L
.87825 .59349 L
.88622 .62153 L
.89221 .62404 L
.89851 .6084 L
.88514 .60116 L
.88305 .59126 L
.89069 .57535 L
.88084 .57598 L
.87864 .56733 L
F
.242 g
.5761 .32987 m
.58648 .33458 L
.59269 .3264 L
.5885 .32119 L
.58122 .32301 L
.57153 .31686 L
.56943 .32299 L
.57847 .32702 L
.5761 .32987 L
F
.036 g
.6837 .24685 m
.68447 .23752 L
.68605 .23949 L
.68638 .23983 L
.6837 .24685 L
F
.873 g
.41098 .06244 m
.43998 .04618 L
.43467 .0611 L
.42164 .06737 L
.41098 .06244 L
F
.102 g
.56407 .186 m
.5905 .18266 L
.611 .18363 L
.619 .20123 L
.63952 .20284 L
.65915 .1587 L
.65915 .1587 L
.66324 .14992 L
.65809 .14493 L
.60178 .14506 L
.59601 .14084 L
.57675 .13891 L
.55816 .14866 L
.55557 .1691 L
.56407 .186 L
F
.547 g
.5411 .257 m
.54062 .25812 L
.54064 .25803 L
.5411 .257 L
F
.048 g
.57153 .31686 m
.58122 .32301 L
.5885 .32119 L
.58863 .31264 L
.58309 .3089 L
.58063 .30835 L
.57925 .31223 L
.57283 .31305 L
.57153 .31686 L
F
.962 g
.52453 .27172 m
.52587 .26817 L
.52359 .26839 L
.52453 .27172 L
F
.042 g
.59651 .24232 m
.59878 .24577 L
.60588 .24874 L
.60812 .24445 L
.60029 .2385 L
.59651 .24232 L
F
.093 g
.9403 .65722 m
.94252 .66604 L
.92412 .69672 L
.91185 .69969 L
.90638 .71245 L
.8955 .72179 L
.90034 .70811 L
.89706 .70363 L
.91223 .69354 L
.91295 .69285 L
.91281 .69264 L
.91701 .68639 L
.93271 .67001 L
.93816 .67156 L
.9403 .65722 L
F
.94179 .57896 m
.9553 .59084 L
.95785 .61006 L
.95556 .61612 L
.94333 .60603 L
.93961 .59424 L
.94368 .58745 L
.94179 .57896 L
F
.647 g
.52893 .11073 m
.5 .12261 L
.46972 .13943 L
.45852 .14055 L
.46093 .09425 L
.41887 .10124 L
.41416 .09786 L
.41278 .09831 L
.41701 .08657 L
.41683 .0863 L
.43411 .0832 L
.44011 .07205 L
.45857 .07107 L
.47116 .08408 L
.5 .09004 L
.50167 .09004 L
.52754 .09432 L
.52893 .11073 L
F
.395 g
.38783 .13425 m
.39253 .13007 L
.38473 .1117 L
.40623 .10588 L
.41414 .09778 L
.41887 .10124 L
.46093 .09425 L
.45852 .14055 L
.46972 .13943 L
.44721 .15364 L
.44623 .14721 L
.4258 .15093 L
.41564 .1375 L
.41456 .12991 L
.38783 .13425 L
F
.031 g
.14573 .54434 m
.12988 .55125 L
.10964 .54011 L
.10742 .50811 L
.10841 .50934 L
.11873 .50222 L
.12203 .48096 L
.10664 .48833 L
.10334 .494 L
.10335 .50681 L
.0952 .50306 L
.09521 .51225 L
.08826 .51618 L
.09091 .51989 L
.08826 .51618 L
.09821 .53421 L
.0983 .55491 L
.11662 .59192 L
.12731 .60301 L
.14 .6013 L
.16167 .61914 L
.18331 .62902 L
.19603 .62955 L
.20395 .63826 L
.18173 .63422 L
.15028 .62396 L
.16352 .63663 L
.18448 .64724 L
.18569 .64038 L
.21184 .64756 L
.20677 .63497 L
.18816 .60768 L
.18592 .59314 L
.17007 .58257 L
.16571 .56397 L
.14958 .55602 L
.14573 .54434 L
F
.453 g
.6077 .28556 m
.61396 .2882 L
.62244 .28475 L
.62045 .27504 L
.6077 .28556 L
F
.424 g
.53429 .23775 m
.53401 .23753 L
.534 .23762 L
.53422 .23774 L
F
.521 g
.73476 .49119 m
.74706 .50388 L
.75597 .50313 L
.76053 .52463 L
.76829 .53002 L
.76565 .57242 L
.75389 .59308 L
.74553 .59904 L
.73844 .59634 L
.71554 .62394 L
.71223 .61491 L
.71825 .60449 L
.70656 .60396 L
.72185 .57444 L
.72306 .5528 L
.71577 .53392 L
.7299 .52959 L
.72534 .50938 L
.73476 .49119 L
F
.493 g
.48808 .18979 m
.4711 .1952 L
.46625 .19097 L
.44779 .18058 L
.43956 .16522 L
.42051 .16066 L
.44748 .15546 L
.44828 .16069 L
.47897 .16888 L
.47817 .1727 L
.49327 .1741 L
.48808 .18979 L
F
.715 g
.83158 .44758 m
.84733 .48878 L
.85474 .48348 L
.84658 .45601 L
.8375 .44089 L
.83158 .44758 L
F
.896 g
.51308 .27762 m
.51765 .28686 L
.52667 .28939 L
.52371 .27506 L
.51308 .27762 L
F
.87 g
.09298 .45099 m
.0739 .45258 L
.07316 .46778 L
.08108 .48049 L
.09298 .45099 L
F
.473 g
.59601 .14084 m
.57665 .13889 L
.52893 .11073 L
.52754 .09432 L
.50167 .09004 L
.51777 .07611 L
.52644 .07588 L
.5267 .07566 L
.53538 .0859 L
.57031 .08578 L
.59804 .0958 L
.60706 .11351 L
.606 .13032 L
.59601 .14084 L
F
.859 g
.56803 .04927 m
.54868 .04446 L
.54153 .05086 L
.52128 .05149 L
.52644 .07588 L
.5267 .07566 L
.53538 .0859 L
.57031 .08578 L
.59804 .0958 L
.60194 .09367 L
.60769 .08806 L
.59181 .06369 L
.5761 .05941 L
.56803 .04927 L
F
.013 g
.72891 .68121 m
.72699 .67418 L
.70649 .67751 L
.70627 .6768 L
.73449 .66036 L
.73717 .67011 L
.7423 .66757 L
.7374 .67695 L
.72891 .68121 L
F
.768 g
.56049 .39846 m
.5595 .40124 L
.55443 .40221 L
.55127 .40214 L
.5477 .39939 L
.53756 .38509 L
.53106 .36741 L
.52536 .34929 L
.53032 .35031 L
.5189 .34345 L
.51434 .33876 L
.51943 .33748 L
.51523 .33265 L
.52241 .33422 L
.51541 .33009 L
.52119 .32986 L
.516 .32359 L
.52129 .31598 L
.53208 .32801 L
.53569 .32351 L
.53234 .34956 L
.54304 .38538 L
.55336 .38938 L
.55449 .39708 L
.5593 .39288 L
.55944 .39285 L
.56056 .39861 L
F
.5238 .4486 m
.52573 .44198 L
.51769 .44485 L
.5238 .4486 L
F
.51139 .43964 m
.51557 .43255 L
.52021 .43512 L
.51646 .43186 L
.52217 .42442 L
.52421 .4387 L
.51636 .44404 L
.51844 .43754 L
.51139 .43964 L
F
.926 g
.82172 .25845 m
.83105 .29153 L
.82456 .3111 L
.80414 .29945 L
.80687 .29171 L
.81463 .29307 L
.80809 .25915 L
.82172 .25845 L
F
.812 g
.81747 .32847 m
.8318 .35711 L
.84162 .36336 L
.84506 .38186 L
.82962 .37687 L
.82984 .39219 L
.81951 .41249 L
.81451 .41798 L
.80059 .41352 L
.8014 .43493 L
.78948 .42008 L
.78784 .40444 L
.79682 .39138 L
.8058 .38465 L
.80359 .36936 L
.8089 .36408 L
.79471 .33574 L
.81384 .34238 L
.81747 .32847 L
F
.051 g
.06883 .44375 m
.07041 .42451 L
.07112 .42309 L
.07185 .40404 L
.06471 .40655 L
.07005 .40953 L
.06962 .42049 L
.06931 .42095 L
.06106 .42602 L
.06172 .44541 L
.06883 .44375 L
F
.958 g
.83304 .7104 m
.84886 .7128 L
.85186 .71944 L
.84483 .73201 L
.84892 .73609 L
.84968 .72306 L
.85253 .72545 L
.85754 .71173 L
.85046 .70057 L
.83853 .7002 L
.83297 .7105 L
F
.85212 .73101 m
.85208 .73808 L
.85212 .73101 L
F
.85966 .71073 m
.8568 .71907 L
.86191 .71846 L
.85959 .71083 L
F
.85336 .75159 m
.85722 .76546 L
.86269 .76545 L
.86163 .75954 L
.86879 .76209 L
.86832 .74548 L
.87853 .73546 L
.86619 .74146 L
.86776 .74511 L
.85599 .75408 L
.8533 .75154 L
F
.85666 .74451 m
.86065 .74143 L
.85659 .74462 L
F
.8575 .73693 m
.86552 .73934 L
.86612 .73235 L
.8575 .73693 L
F
.85966 .72503 m
.8568 .73318 L
.86571 .72793 L
.85966 .72503 L
F
.87112 .71011 m
.87399 .71346 L
.8917 .70116 L
.87118 .71015 L
F
.079 g
.55126 .29792 m
.56899 .30643 L
.58309 .3089 L
.58885 .29663 L
.59027 .28261 L
.55774 .28198 L
.55126 .29792 L
F
.639 g
.46134 .20299 m
.45357 .2041 L
.4519 .21257 L
.4583 .2291 L
.47026 .22546 L
.46134 .20299 L
F
.731 g
.1366 .34774 m
% vacuous filled polygon
newpath
.505 g
.78354 .27217 m
.77773 .2771 L
.7815 .27069 L
.78354 .27217 L
F
.655 g
.62697 .27709 m
.62654 .26775 L
.60102 .2583 L
.58716 .26394 L
.59402 .27743 L
.6077 .28556 L
.62045 .27504 L
.62697 .27709 L
F
.117 g
.70651 .67762 m
.69879 .67784 L
.68754 .68841 L
.65295 .68347 L
.63228 .6658 L
.63332 .65748 L
.64285 .65489 L
.63878 .65269 L
.64291 .644 L
.60855 .64189 L
.58883 .6515 L
.58224 .66071 L
.57514 .66249 L
.57606 .65756 L
.56283 .65155 L
.55519 .6547 L
.55811 .66081 L
.55345 .65912 L
.546 .65301 L
.53974 .65535 L
.57871 .67638 L
.58935 .70698 L
.56259 .69397 L
.55609 .68756 L
.55745 .67611 L
.54906 .66705 L
.53195 .66778 L
.5296 .67225 L
.50831 .65775 L
.50253 .66128 L
.50472 .64884 L
.51432 .64688 L
.50132 .6468 L
.5 .6433 L
.5 .6433 L
.5 .62619 L
.5 .62614 L
.5 .62614 L
.50797 .61735 L
.51939 .6165 L
.52024 .62251 L
.53588 .61333 L
.54073 .61862 L
.53976 .60493 L
.55184 .59973 L
.55444 .58804 L
.56171 .58776 L
.55648 .58675 L
.5565 .5865 L
.56348 .57742 L
.56966 .58311 L
.58503 .57396 L
.58447 .54612 L
.58863 .53851 L
.59324 .54077 L
.58804 .53433 L
.59733 .5262 L
.57834 .53442 L
.57249 .52797 L
.56979 .51749 L
.57802 .51694 L
.57822 .51213 L
.58556 .51537 L
.57957 .51232 L
.58932 .49355 L
.59948 .49441 L
.59416 .49471 L
.59493 .48414 L
.61563 .48614 L
.60625 .48746 L
.60096 .47949 L
.60468 .47439 L
.60956 .47761 L
.60443 .47299 L
.5968 .47406 L
.61018 .46875 L
.61711 .46598 L
.62044 .47359 L
.62861 .47512 L
.61945 .47143 L
.63198 .45712 L
.62639 .4514 L
.62454 .46228 L
.59677 .47011 L
.59473 .46361 L
.60175 .456 L
.61798 .45388 L
.60987 .44888 L
.60923 .43604 L
.59891 .42605 L
.59966 .40889 L
.59338 .40635 L
.5905 .41261 L
.58968 .40757 L
.59812 .39904 L
.59113 .39082 L
.5964 .38713 L
.58678 .38421 L
.59293 .37904 L
.58651 .37797 L
.58455 .37812 L
.57799 .3851 L
.57041 .38681 L
.58584 .38999 L
.58797 .4001 L
.56049 .39846 L
.56056 .39861 L
.55944 .39285 L
.58259 .36567 L
.57992 .34874 L
.5879 .34927 L
.58329 .34356 L
.58648 .33458 L
.59269 .3264 L
.59887 .32865 L
.61028 .32155 L
.6148 .31364 L
.62321 .31652 L
.64841 .32039 L
.65568 .31403 L
.65246 .30672 L
.6562 .30973 L
.65216 .30336 L
.65716 .30289 L
.653 .29386 L
.67128 .29588 L
.68743 .30557 L
.69874 .31008 L
.70619 .31337 L
.70608 .31821 L
.68941 .3214 L
.6895 .33652 L
.67039 .34027 L
.6722 .36088 L
.68161 .36862 L
.69744 .39003 L
.68254 .40123 L
.69034 .43309 L
.70172 .44412 L
.70101 .4547 L
.71865 .45934 L
.72639 .47434 L
.73504 .48905 L
.73476 .49119 L
.72534 .50938 L
.7299 .52959 L
.71577 .53392 L
.72306 .5528 L
.72185 .57444 L
.70656 .60396 L
.70091 .61244 L
.68612 .6076 L
.67918 .61211 L
.67348 .62428 L
.68353 .64099 L
.67945 .65417 L
.68343 .65936 L
.6704 .66883 L
.68766 .67571 L
.69533 .6695 L
.70627 .6768 L
.70651 .67762 L
.70651 .67762 L
F
.5 .6433 m
.49804 .6376 L
.48219 .649 L
.48236 .64064 L
.47514 .63701 L
.48531 .63268 L
.48667 .63765 L
.5 .62614 L
.5 .62614 L
.5 .62619 L
.5 .6433 L
F
.57283 .31305 m
.57925 .31223 L
.58063 .30835 L
.56905 .30645 L
.5735 .311 L
.57283 .31305 L
F
.63153 .66734 m
.65542 .69952 L
.64846 .70149 L
.63985 .68728 L
.63728 .69425 L
.62474 .66564 L
.63153 .66734 L
F
.59637 .70889 m
.59168 .70657 L
.59637 .70889 L
F
.55922 .57352 m
.55814 .57852 L
.5592 .57354 L
F
.54664 .57046 m
.54231 .57616 L
.54664 .57046 L
F
.55745 .56806 m
.55227 .57115 L
.5482 .56988 L
.5533 .56074 L
.55898 .56306 L
.55711 .56822 L
F
.56972 .51163 m
.56506 .51788 L
.56057 .51328 L
.56973 .51161 L
F
.56222 .51038 m
.55722 .50757 L
.56125 .50305 L
.56223 .51036 L
F
.58331 .43349 m
.57888 .4422 L
.58226 .44569 L
.59519 .43967 L
.58324 .43355 L
F
.57525 .4511 m
.57885 .44281 L
.5712 .47195 L
.57524 .45108 L
F
.849 g
.5566 .24257 m
.5566 .24257 L
% vacuous filled polygon
newpath
.89 g
.69482 .22143 m
.69655 .21473 L
.74069 .20471 L
.77406 .20387 L
.77944 .21564 L
.79249 .21341 L
.80809 .25915 L
.81463 .29307 L
.80687 .29171 L
.80519 .28498 L
.78635 .26949 L
.78354 .27217 L
.7815 .27069 L
.75736 .27164 L
.74777 .26529 L
.73977 .25784 L
.70603 .24828 L
.69803 .23721 L
.70498 .23286 L
.69482 .22143 L
F
.402 g
.38476 .11177 m
.37614 .10797 L
.38123 .10076 L
.40042 .09459 L
.37927 .09886 L
.38859 .09506 L
.37851 .09549 L
.40025 .09132 L
.41701 .08657 L
.41278 .09831 L
.41414 .09778 L
.40623 .10588 L
.38473 .1117 L
F
.342 g
.58696 .24234 m
.58666 .24299 L
.58326 .25544 L
.58165 .26083 L
.58716 .26394 L
.60102 .2583 L
.60588 .24874 L
.59878 .24577 L
.59651 .24232 L
.59347 .24549 L
.5911 .24083 L
.58696 .24234 L
F
.963 g
.39942 .07451 m
.4111 .06241 L
.42176 .06735 L
.4158 .07539 L
.39942 .07451 L
F
.02 g
.95647 .61367 m
.95647 .61367 L
% vacuous filled polygon
newpath
.929 g
.59027 .28261 m
.57564 .28176 L
.57126 .27759 L
.56835 .2695 L
.5712 .2695 L
.59013 .27859 L
.59027 .28261 L
F
.483 g
.56162 .25256 m
.56034 .25281 L
.55913 .25775 L
.56872 .26219 L
.57086 .26129 L
.56863 .25611 L
.56162 .25256 L
F
.95 g
.82651 .15338 m
.83955 .19373 L
.83679 .2313 L
.82835 .23205 L
.80432 .1948 L
.79208 .18988 L
.792 .1896 L
.79187 .18646 L
.80391 .18548 L
.82825 .20427 L
.82173 .1777 L
.80677 .1581 L
.80449 .14952 L
.81454 .14248 L
.81454 .14248 L
.82597 .15287 L
.82651 .15338 L
F
.671 g
.7374 .67695 m
.75291 .68726 L
.73822 .69591 L
.72891 .68121 L
.7374 .67695 L
F
.9 g
.51524 .22885 m
.5 .21513 L
.49941 .20973 L
.5 .20805 L
.48876 .19832 L
.47148 .19639 L
.46134 .20299 L
.47026 .22546 L
.4583 .2291 L
.45674 .23534 L
.46367 .2382 L
.49179 .23375 L
.50701 .2294 L
.50828 .2289 L
.51524 .22885 L
F
.526 g
.93657 .42145 m
.94468 .42532 L
.94053 .43717 L
.92722 .42403 L
.92952 .42902 L
.93657 .42145 L
F
.969 g
.74694 .19084 m
.72601 .19898 L
.71608 .19837 L
.7109 .18655 L
.65915 .1587 L
.66324 .14992 L
.65809 .14493 L
.66542 .12847 L
.65874 .12481 L
.65625 .10999 L
.66585 .10481 L
.66672 .10501 L
.67502 .0978 L
.70969 .09632 L
.73677 .10387 L
.75631 .12001 L
.76797 .13027 L
.74068 .12915 L
.74244 .14438 L
.74811 .16037 L
.74088 .18034 L
.74694 .19084 L
F
.91 g
.13238 .23454 m
.11912 .25501 L
.11029 .25696 L
.10988 .24146 L
.11983 .22983 L
.13238 .23454 L
F
.447 g
.53569 .32351 m
.54616 .30474 L
.55365 .31104 L
.55074 .32517 L
.55662 .32997 L
.54887 .32974 L
.55748 .33385 L
.54772 .34711 L
.55775 .37129 L
.54308 .38539 L
.53234 .34956 L
.53569 .32351 L
F
.33 g
.53093 .24926 m
.54495 .25666 L
.5411 .257 L
.54062 .25812 L
.54053 .2595 L
.53215 .25851 L
.5261 .25027 L
.53093 .24926 L
F
.179 g
.67955 .25211 m
.6837 .24685 L
.68661 .23999 L
.68824 .23756 L
.70011 .25112 L
.706 .26303 L
.70201 .27838 L
.67996 .25827 L
.67955 .25211 L
F
.437 g
.80873 .68759 m
.80685 .69174 L
.82403 .69252 L
.8189 .68498 L
.80873 .68759 L
F
.791 g
.77717 .3867 m
.77397 .39051 L
.76564 .39042 L
.76356 .40189 L
.76703 .40052 L
.77379 .40848 L
.7762 .42167 L
.78892 .42204 L
.78684 .40504 L
.77671 .40445 L
.77717 .3867 L
F
.941 g
.91471 .59511 m
.91328 .57934 L
.91017 .57429 L
.92574 .56857 L
.93816 .58055 L
.93961 .59424 L
.94368 .58745 L
.94179 .57896 L
.93625 .56351 L
.92628 .56561 L
.91854 .57129 L
.90533 .55829 L
.89859 .56265 L
.88998 .5503 L
.87864 .56733 L
.88084 .57598 L
.89069 .57535 L
.88305 .59126 L
.88514 .60116 L
.89851 .6084 L
.90707 .589 L
.91471 .59511 L
F
.588 g
.50943 .04992 m
.51295 .05052 L
.50685 .0717 L
.49876 .07225 L
.5 .0721 L
.49938 .07028 L
.5 .06983 L
.50943 .04992 L
F
.901 g
.54507 .20256 m
.55751 .20552 L
.55475 .1895 L
.56407 .186 L
.55557 .1691 L
.54135 .18595 L
.54507 .20256 L
F
.811 g
.67955 .25211 m
.6769 .25667 L
.66557 .24308 L
.6511 .23492 L
.63889 .23167 L
.64253 .23567 L
.62987 .23646 L
.6337 .23947 L
.62555 .24429 L
.63753 .25807 L
.65661 .27593 L
.68334 .29302 L
.70198 .29673 L
.71111 .28741 L
.70207 .27832 L
.67996 .25827 L
.67955 .25211 L
F
.6232 .24779 m
.62546 .24484 L
.63532 .25571 L
.62871 .25811 L
.62225 .25319 L
.6232 .24779 L
F
.599 g
.71956 .33355 m
.72796 .33899 L
.72454 .32905 L
.7413 .32404 L
.74689 .34089 L
.7581 .34837 L
.76997 .3521 L
.77495 .3663 L
.77132 .37797 L
.75914 .37118 L
.74088 .36297 L
.73013 .35989 L
.72931 .34533 L
.71956 .33355 L
F
.625 g
.78354 .27217 m
.79664 .2854 L
.79553 .3034 L
.80414 .29945 L
.80687 .29171 L
.80519 .28498 L
.78635 .26949 L
.78354 .27217 L
F
.881 g
.48413 .31865 m
.49042 .31821 L
.48603 .31207 L
.49404 .31221 L
.48736 .30361 L
.5 .29059 L
.50049 .28957 L
.5 .28929 L
.50668 .28354 L
.50149 .2777 L
.50092 .27373 L
.48054 .27373 L
.49082 .27955 L
.48342 .27952 L
.48236 .28621 L
.4899 .28842 L
.48934 .29768 L
.48181 .29747 L
.4832 .30533 L
.47965 .30021 L
.48413 .31865 L
F
.47449 .29948 m
.4774 .2936 L
.47735 .2937 L
.47084 .2964 L
.47449 .29948 L
F
.882 g
.21184 .64756 m
.21441 .6473 L
.23045 .65952 L
.24882 .65992 L
.24814 .65384 L
.2585 .66106 L
.27341 .65389 L
.2923 .64045 L
.30343 .6362 L
.29779 .63006 L
.29369 .63432 L
.30157 .62763 L
.30161 .62753 L
.28993 .60719 L
.28809 .60351 L
.27116 .55706 L
.26602 .52956 L
.25867 .49824 L
.25194 .47451 L
.23391 .46457 L
.23127 .46534 L
.22662 .46498 L
.23604 .44829 L
.23687 .44917 L
.23775 .44934 L
.24744 .43609 L
.25318 .42618 L
.25569 .41826 L
.25775 .41698 L
.27161 .41339 L
.26334 .40052 L
.24682 .41159 L
.2457 .41153 L
.23838 .41051 L
.23827 .41056 L
.23838 .41051 L
.23624 .41353 L
.23202 .42138 L
.22873 .42349 L
.2199 .42416 L
.22505 .4265 L
.22351 .42815 L
.2171 .42437 L
.21445 .42544 L
.20918 .42722 L
.21383 .42679 L
.21592 .4304 L
.2219 .4298 L
.21342 .43023 L
.21646 .43463 L
.21692 .43499 L
.21306 .43446 L
.20853 .42877 L
.20851 .43422 L
.20634 .42596 L
.20289 .42325 L
.20708 .4266 L
.20217 .42978 L
.20173 .42425 L
.19966 .43094 L
.19726 .42639 L
.18946 .4371 L
.17772 .44828 L
.17059 .45077 L
.15237 .43891 L
.14311 .44401 L
.16491 .46291 L
.16504 .48547 L
.16537 .49065 L
.16423 .49717 L
.16406 .50254 L
.16356 .49628 L
.15789 .49652 L
.16402 .52232 L
.16393 .52222 L
.15547 .54546 L
.14573 .54434 L
.14958 .55602 L
.16571 .56397 L
.17007 .58257 L
.18592 .59314 L
.18816 .60768 L
.20677 .63497 L
.21184 .64756 L
F
.34881 .62686 m
.34544 .63286 L
.35186 .62885 L
.35326 .63337 L
.37534 .62611 L
.36989 .6308 L
.38699 .63232 L
.4108 .64119 L
.4115 .65115 L
.41622 .65746 L
.41524 .64246 L
.41884 .66242 L
.42763 .68311 L
.4416 .69507 L
.42758 .67398 L
.42939 .66461 L
.43867 .6699 L
.44428 .67321 L
.44704 .66188 L
.45066 .66835 L
.45209 .66226 L
.45707 .66041 L
.46057 .66052 L
.4581 .65024 L
.45016 .64598 L
.45238 .63816 L
.47079 .63899 L
.46301 .63146 L
.45624 .6331 L
.4595 .62831 L
.45343 .6296 L
.47119 .62315 L
.46371 .60995 L
.45655 .59978 L
.42516 .59248 L
.39138 .63413 L
.37696 .62506 L
.34885 .62691 L
F
.34229 .8512 m
.33458 .85153 L
.3387 .85669 L
.34229 .8512 L
F
.4165 .66578 m
.41232 .66723 L
.4194 .67128 L
.4165 .66578 L
F
.116 g
.73677 .10387 m
.74278 .1007 L
.74005 .08874 L
.74005 .08874 L
.75516 .09794 L
.76834 .10662 L
.76834 .10662 L
.76875 .11666 L
.75631 .12001 L
.73677 .10387 L
.73677 .10387 L
F
.675 g
.58881 .29671 m
.60173 .30317 L
.6148 .31364 L
.62321 .31652 L
.64841 .32039 L
.65568 .31403 L
.65246 .30672 L
.64909 .30239 L
.64347 .29371 L
.6527 .29263 L
.64444 .28287 L
.63724 .28444 L
.64042 .28998 L
.63212 .28691 L
.62916 .29128 L
.62697 .27709 L
.62045 .27504 L
.62244 .28475 L
.61396 .2882 L
.6077 .28556 L
.59402 .27743 L
.59013 .27859 L
.59027 .28261 L
.58881 .29671 L
F
.879 g
.72931 .34533 m
.71365 .35589 L
.71781 .3674 L
.73508 .37588 L
.75738 .39558 L
.75991 .40282 L
.75749 .41142 L
.76383 .41036 L
.76741 .41825 L
.76703 .40052 L
.76356 .40189 L
.76564 .39042 L
.77397 .39051 L
.77717 .3867 L
.77132 .37797 L
.75914 .37118 L
.74088 .36297 L
.73013 .35989 L
.72931 .34533 L
F
.444 g
.1195 .28017 m
.11351 .29117 L
.11973 .28791 L
.11465 .3038 L
.12131 .29737 L
.10755 .31769 L
.10067 .34109 L
.10257 .35548 L
.09984 .35277 L
.09272 .36438 L
.08513 .36226 L
.09788 .36402 L
.08169 .37516 L
.07568 .36213 L
.08464 .32753 L
.06979 .32487 L
.06677 .31491 L
.08228 .29082 L
.08553 .30497 L
.08955 .28981 L
.09732 .28151 L
.10387 .278 L
.10424 .28407 L
.1195 .28017 L
F
.775 g
.91758 .60761 m
.92462 .61259 L
.91649 .61798 L
.91674 .62384 L
.90133 .64015 L
.88664 .63275 L
.88134 .61356 L
.87355 .60559 L
.86027 .61694 L
.86045 .61793 L
.85728 .59919 L
.86626 .57874 L
.87212 .58705 L
.8706 .59688 L
.87825 .59349 L
.88622 .62153 L
.89221 .62404 L
.90255 .62731 L
.90916 .61617 L
.91758 .60761 L
F
.103 g
.42051 .16066 m
.38783 .13425 L
.41456 .12991 L
.41564 .1375 L
.4258 .15093 L
.44623 .14721 L
.44721 .15364 L
.44748 .15546 L
.42051 .16066 L
F
.91 g
.77944 .21564 m
.774 .20393 L
.78979 .19516 L
.81136 .22646 L
.82165 .25835 L
.80809 .25915 L
.79249 .21341 L
.77944 .21564 L
F
.534 g
.64198 .04547 m
.64745 .06269 L
.64967 .0702 L
.67431 .0757 L
.70969 .09632 L
.73677 .10387 L
.74278 .1007 L
.74005 .08874 L
.74005 .08874 L
.72941 .08271 L
.70275 .06913 L
.6753 .05725 L
.64715 .04712 L
.64198 .04547 L
F
0 g
.5 .5 m
.5 .5 L
.5 .52115 L
.5 .54229 L
.5 .56338 L
.5 .5844 L
.5 .60535 L
.5 .62619 L
.5 .64691 L
.5 .66748 L
.5 .68788 L
.5 .7081 L
.5 .72812 L
.5 .74791 L
.5 .76745 L
.5 .78673 L
.5 .80573 L
.5 .82443 L
.5 .84281 L
.5 .86084 L
.5 .87853 L
.5 .89584 L
.5 .91275 L
.5 .92926 L
.5 .94535 L
.5 .961 L
.5 .97619 L
s
.5 .97619 m
.5 .97619 L
.5 .97619 L
.5299 .97525 L
.55968 .97244 L
.58923 .96776 L
.61842 .96123 L
.64715 .95288 L
.6753 .94275 L
.70275 .93087 L
.72941 .91729 L
.75516 .90206 L
.7799 .88525 L
.80354 .86691 L
.82597 .84713 L
.84713 .82597 L
.86691 .80354 L
.88525 .7799 L
.90206 .75516 L
.91729 .72941 L
.93087 .70275 L
.94275 .6753 L
.95288 .64715 L
.96123 .61842 L
.96776 .58923 L
.97244 .55968 L
.97525 .5299 L
.97619 .5 L
.97525 .4701 L
.97244 .44032 L
.96776 .41077 L
.96123 .38158 L
.95288 .35285 L
.94275 .3247 L
.93087 .29725 L
.91729 .27059 L
.90206 .24484 L
.88525 .2201 L
.86691 .19646 L
.84713 .17403 L
.82597 .15287 L
.80354 .13309 L
.7799 .11475 L
.75516 .09794 L
.72941 .08271 L
.70275 .06913 L
.6753 .05725 L
.64715 .04712 L
.61842 .03877 L
.58923 .03224 L
Mistroke
.55968 .02756 L
.5299 .02475 L
.5 .02381 L
.4701 .02475 L
.44032 .02756 L
.41077 .03224 L
.38158 .03877 L
.35285 .04712 L
.3247 .05725 L
.29725 .06913 L
.27059 .08271 L
.24484 .09794 L
.2201 .11475 L
.19646 .13309 L
.17403 .15287 L
.15287 .17403 L
.13309 .19646 L
.11475 .2201 L
.09794 .24484 L
.08271 .27059 L
.06913 .29725 L
.05725 .3247 L
.04712 .35285 L
.03877 .38158 L
.03224 .41077 L
.02756 .44032 L
.02475 .4701 L
.02381 .5 L
.02475 .5299 L
.02756 .55968 L
.03224 .58923 L
.03877 .61842 L
.04712 .64715 L
.05725 .6753 L
.06913 .70275 L
.08271 .72941 L
.09794 .75516 L
.11475 .7799 L
.13309 .80354 L
.15287 .82597 L
.17403 .84713 L
.19646 .86691 L
.2201 .88525 L
.24484 .90206 L
.27059 .91729 L
.29725 .93087 L
.3247 .94275 L
.35285 .95288 L
.38158 .96123 L
.41077 .96776 L
Mistroke
.44032 .97244 L
.4701 .97525 L
.5 .97619 L
.5 .97619 L
Mfstroke
.5 .97619 m
.5 .961 L
.5 .94535 L
.5 .92926 L
.5 .91275 L
.5 .89584 L
.5 .87853 L
.5 .86084 L
.5 .84281 L
.5 .82443 L
.5 .80573 L
.5 .78673 L
.5 .76745 L
.5 .74791 L
.5 .72812 L
.5 .7081 L
.5 .68788 L
.5 .66748 L
.5 .64691 L
.5 .62619 L
.5 .60535 L
.5 .5844 L
.5 .56338 L
.5 .54229 L
.5 .52115 L
.5 .5 L
.5 .5 L
s
.5 .5 m
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
Mistroke
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
Mistroke
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.65.1"],

Cell[BoxData["\<\"-WorldGraphics-\"\>"], "Output",
 CellLabel->"Out[8]= ",
 CellTags->"S5.65.1"]
}, Open  ]],

Cell[TextData[{
 StyleBox["WorldPlot", "MR"],
 " works by creating a ",
 StyleBox["Mathematica", "TI"],
 " graphics object that represents the map. Each country on the map is given \
as a ",
 StyleBox["Polygon", "MR"],
 " primitive. To make a map from a list of countries, ",
 StyleBox["Mathematica", "TI"],
 " must know the vertices of these polygons for each country in your list. \
These data are contained in the package ",
 StyleBox["Miscellaneous`WorldData`", "MR"],
 ", which is automatically loaded when ",
 StyleBox["Miscellaneous`WorldPlot`", "MR"],
 "is loaded. As noted above, the vertex data are given as ordered pairs of \
latitude and longitude expressed in minutes. By convention, latitudes north \
of the equator are positive while those to the south are negative, and \
longitudes east of Greenwich are positive and those to the west are negative. \
"
}], "Text",
 CellTags->{"S5.65.1", "1.29"}],

Cell[TextData[{
 "You can specify your own database of geographic coordinates by setting the \
option ",
 StyleBox["WorldDatabase", "MR"],
 ". The setting for this option is the name of the function that is applied \
to a country name to yield its polygonal vertices. The names of the countries \
that appear in your database are specified using the option ",
 StyleBox["WorldCountries", "MR"],
 ". The setting for this option is the name of the ",
 StyleBox["Mathematica", "TI"],
 " list that contains the allowable country names. The default value is ",
 StyleBox["World", "MR"],
 ", which is a list given in the package ",
 StyleBox["Miscellaneous`WorldNames`", "MR"],
 ". This package is also automatically loaded when you load ",
 StyleBox["Miscellaneous`WorldPlot`", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.65.1", "1.30"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["WorldGraphics[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["primitives", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["options", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "a graphics object representing a planetary map",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Show[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["wg", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["options", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["display a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["WorldGraphics", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object using the options specified",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["Graphics[WorldGraphics[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["primitives", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["options", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["convert a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["WorldGraphics", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object to a ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["Graphics", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" object",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Creating and displaying ",
 StyleBox["WorldGraphics", "MR"],
 " objects. "
}], "Caption",
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Built\[Hyphen]in ",
 StyleBox["Mathematica", "TI"],
 " functions like ",
 StyleBox["Plot", "MR"],
 " and ",
 StyleBox["ListPlot", "MR"],
 " work by building up a ",
 StyleBox["Graphics", "MR"],
 " object, and then displaying it. The resulting ",
 StyleBox["Graphics", "MR"],
 " object can be manipulated and redisplayed using various options. ",
 StyleBox["WorldPlot", "MR"],
 " works in a very similar way, creating a ",
 StyleBox["WorldGraphics", "MR"],
 " object and then displaying it. A ",
 StyleBox["WorldGraphics", "MR"],
 " object is essentially a ",
 StyleBox["Graphics", "MR"],
 " object that has been adapted to work with geographic data. All coordinates \
given in the primitives ",
 StyleBox["Polygon", "MR"],
 ", ",
 StyleBox["Line", "MR"],
 ", ",
 StyleBox["Point", "MR"],
 ", and ",
 StyleBox["Text", "MR"],
 " are given as ",
 StyleBox["{", "MR"],
 StyleBox["lat", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["long", "TI"],
 StyleBox["}", "MR"],
 " with the latitude and longitude given in minutes of an arc. You can \
convert data given in degrees and minutes into minutes using the function ",
 StyleBox["ToMinutes", "MR"],
 ". Thus ",
 StyleBox["Point[ToMinutes[{{41,", "MR"],
 " ",
 StyleBox["49},", "MR"],
 " ",
 StyleBox["-{87,", "MR"],
 " ",
 StyleBox["37}}]]", "MR"],
 " represents a point displayed at the location of Chicago, Illinois, which \
is at latitude ",
 Cell[BoxData[
  FormBox["41", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees, ",
 Cell[BoxData[
  FormBox["49", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " seconds North and longitude ",
 Cell[BoxData[
  FormBox["87", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " degrees, ",
 Cell[BoxData[
  FormBox["37", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{ColumnWidths->Automatic}],
 " minutes West. Before a ",
 StyleBox["WorldGraphics", "MR"],
 " object is displayed, it is internally converted to a standard ",
 StyleBox["Graphics", "MR"],
 " object using the projection specified by the value of ",
 StyleBox["WorldProjection", "MR"],
 ". "
}], "Text",
 CellTags->{"S5.65.1", "1.31"}],

Cell["\<\
Here is the list of the vertices of the polygon that give the map of Ireland. \
\
\>", "MathCaption",
 CellTags->{"S5.65.1", "1.32"}],

Cell[CellGroupData[{

Cell["WorldData[\"Ireland\"]", "Input",
 CellLabel->"In[9]:= ",
 CellTags->"S5.65.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3245", ",", 
      RowBox[{"-", "376"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3131", ",", 
      RowBox[{"-", "382"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3087", ",", 
      RowBox[{"-", "586"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3131", ",", 
      RowBox[{"-", "628"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3160", ",", 
      RowBox[{"-", "524"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3246", ",", 
      RowBox[{"-", "607"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3303", ",", 
      RowBox[{"-", "435"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3266", ",", 
      RowBox[{"-", "489"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3245", ",", 
      RowBox[{"-", "376"}]}], "}"}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[9]= ",
 CellTags->"S5.65.1"]
}, Open  ]],

Cell["\<\
This is a list of the latitude and longitude in minutes of two cities in \
Africa. \
\>", "MathCaption",
 CellTags->{"S5.65.1", "1.33"}],

Cell[CellGroupData[{

Cell["\<\
{capetown, cairo}  = ToMinutes[
   {{{-33, -56}, {18, 22}},
     {{30, 3}, {31, 15}}}]\
\>", "Input",
 CellLabel->"In[10]:= ",
 CellTags->"S5.65.1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2036"}], ",", "1102"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1803", ",", "1875"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[10]= ",
 CellTags->"S5.65.1"]
}, Open  ]],

Cell[TextData[{
 "You can combine maps with ",
 StyleBox["WorldGraphics", "MR"],
 " objects using ",
 StyleBox["Show", "MR"],
 ". The map of Africa given by ",
 StyleBox["afmap", "MR"],
 " was defined above. "
}], "MathCaption",
 CellTags->{"S5.65.1", "1.34"}],

Cell[CellGroupData[{

Cell["\<\
Show[{afmap,
 WorldGraphics[
 {Dashing[{0.05, 0.03}],
 Line[{capetown, cairo}]}]}]\
\>", "Input",
 CellLabel->"In[11]:= ",
 CellTags->"S5.65.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.44627 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.000198413 0.723136 0.000198413 [
[ 0 0 0 0 ]
[ 1 1.44627 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.44627 L
0 1.44627 L
closepath
clip
newpath
.7 g
.97619 1.41184 m
.97619 1.41184 L
.97619 1.40031 L
.97619 1.38865 L
.97619 1.37686 L
.97619 1.36495 L
.97619 1.35291 L
.97619 1.34074 L
.97619 1.32846 L
.97619 1.31606 L
.97619 1.30354 L
.97619 1.29091 L
.97619 1.27816 L
.97619 1.26532 L
.97619 1.25236 L
.97619 1.2393 L
.97619 1.22614 L
.97619 1.21288 L
.97619 1.19953 L
.97619 1.18609 L
.97619 1.17255 L
.97619 1.15893 L
.97619 1.14522 L
.97619 1.13143 L
.97619 1.11756 L
.97619 1.10361 L
.97619 1.08959 L
.97619 1.07549 L
.97619 1.06133 L
.97619 1.0471 L
.97619 1.03281 L
.97619 1.01846 L
.97619 1.00405 L
.97619 .98959 L
.97619 .97507 L
.97619 .96051 L
.97619 .9459 L
.97619 .93124 L
.97619 .91655 L
.97619 .90182 L
.97619 .88705 L
.97619 .87225 L
.97619 .85742 L
.97619 .84257 L
.97619 .82769 L
.97619 .81279 L
.97619 .79788 L
.97619 .78294 L
.97619 .768 L
.97619 .75305 L
.97619 .7381 L
.97619 .72314 L
.97619 .70818 L
.97619 .69322 L
.97619 .67827 L
.97619 .66333 L
.97619 .6484 L
.97619 .63348 L
.97619 .61858 L
.97619 .60371 L
.97619 .58885 L
.97619 .57402 L
.97619 .55922 L
.97619 .54446 L
.97619 .52972 L
.97619 .51503 L
.97619 .50037 L
.97619 .48576 L
.97619 .4712 L
.97619 .45668 L
.97619 .44222 L
.97619 .42781 L
.97619 .41346 L
.97619 .39917 L
.97619 .38494 L
.97619 .37078 L
.97619 .35669 L
.97619 .34266 L
.97619 .32872 L
.97619 .31485 L
.97619 .30106 L
.97619 .28735 L
.97619 .27372 L
.97619 .26019 L
.97619 .24674 L
.97619 .23339 L
.97619 .22013 L
.97619 .20697 L
.97619 .19391 L
.97619 .18096 L
.97619 .16811 L
.97619 .15537 L
.97619 .14273 L
.97619 .13022 L
.97619 .11781 L
.97619 .10553 L
.97619 .09337 L
.97619 .08133 L
.97619 .06941 L
.97619 .05762 L
.97619 .04596 L
.97619 .03444 L
.97619 .03444 L
.97619 .03444 L
.96667 .03444 L
.95714 .03444 L
.94762 .03444 L
.9381 .03444 L
.92857 .03444 L
.91905 .03444 L
.90952 .03444 L
.9 .03444 L
.89048 .03444 L
.88095 .03444 L
.87143 .03444 L
.8619 .03444 L
.85238 .03444 L
.84286 .03444 L
.83333 .03444 L
.82381 .03444 L
.81429 .03444 L
.80476 .03444 L
.79524 .03444 L
.78571 .03444 L
.77619 .03444 L
.76667 .03444 L
.75714 .03444 L
.74762 .03444 L
.7381 .03444 L
.72857 .03444 L
.71905 .03444 L
.70952 .03444 L
.7 .03444 L
.69048 .03444 L
.68095 .03444 L
.67143 .03444 L
.6619 .03444 L
.65238 .03444 L
.64286 .03444 L
.63333 .03444 L
.62381 .03444 L
.61429 .03444 L
.60476 .03444 L
.59524 .03444 L
.58571 .03444 L
.57619 .03444 L
.56667 .03444 L
.55714 .03444 L
.54762 .03444 L
.5381 .03444 L
.52857 .03444 L
.51905 .03444 L
.50952 .03444 L
.5 .03444 L
.49048 .03444 L
.48095 .03444 L
.47143 .03444 L
.4619 .03444 L
.45238 .03444 L
.44286 .03444 L
.43333 .03444 L
.42381 .03444 L
.41429 .03444 L
.40476 .03444 L
.39524 .03444 L
.38571 .03444 L
.37619 .03444 L
.36667 .03444 L
.35714 .03444 L
.34762 .03444 L
.3381 .03444 L
.32857 .03444 L
.31905 .03444 L
.30952 .03444 L
.3 .03444 L
.29048 .03444 L
.28095 .03444 L
.27143 .03444 L
.2619 .03444 L
.25238 .03444 L
.24286 .03444 L
.23333 .03444 L
.22381 .03444 L
.21429 .03444 L
.20476 .03444 L
.19524 .03444 L
.18571 .03444 L
.17619 .03444 L
.16667 .03444 L
.15714 .03444 L
.14762 .03444 L
.1381 .03444 L
.12857 .03444 L
.11905 .03444 L
.10952 .03444 L
.1 .03444 L
.09048 .03444 L
.08095 .03444 L
.07143 .03444 L
.0619 .03444 L
.05238 .03444 L
.04286 .03444 L
.03333 .03444 L
.02381 .03444 L
.02381 .03444 L
.02381 .04596 L
.02381 .05762 L
.02381 .06941 L
.02381 .08133 L
.02381 .09337 L
.02381 .10553 L
.02381 .11781 L
.02381 .13022 L
.02381 .14273 L
.02381 .15537 L
.02381 .16811 L
.02381 .18096 L
.02381 .19391 L
.02381 .20697 L
.02381 .22013 L
.02381 .23339 L
.02381 .24674 L
.02381 .26019 L
.02381 .27372 L
.02381 .28735 L
.02381 .30106 L
.02381 .31485 L
.02381 .32872 L
.02381 .34266 L
.02381 .35669 L
.02381 .37078 L
.02381 .38494 L
.02381 .39917 L
.02381 .41346 L
.02381 .42781 L
.02381 .44222 L
.02381 .45668 L
.02381 .4712 L
.02381 .48576 L
.02381 .50037 L
.02381 .51503 L
.02381 .52972 L
.02381 .54446 L
.02381 .55922 L
.02381 .57402 L
.02381 .58885 L
.02381 .60371 L
.02381 .61858 L
.02381 .63348 L
.02381 .6484 L
.02381 .66333 L
.02381 .67827 L
.02381 .69322 L
.02381 .70818 L
.02381 .72314 L
.02381 .7381 L
.02381 .75305 L
.02381 .768 L
.02381 .78294 L
.02381 .79788 L
.02381 .81279 L
.02381 .82769 L
.02381 .84257 L
.02381 .85742 L
.02381 .87225 L
.02381 .88705 L
.02381 .90182 L
.02381 .91655 L
.02381 .93124 L
.02381 .9459 L
.02381 .96051 L
.02381 .97507 L
.02381 .98959 L
.02381 1.00405 L
.02381 1.01846 L
.02381 1.03281 L
.02381 1.0471 L
.02381 1.06133 L
.02381 1.07549 L
.02381 1.08959 L
.02381 1.10361 L
.02381 1.11756 L
.02381 1.13143 L
.02381 1.14522 L
.02381 1.15893 L
.02381 1.17255 L
.02381 1.18609 L
.02381 1.19953 L
.02381 1.21288 L
.02381 1.22614 L
.02381 1.2393 L
.02381 1.25236 L
.02381 1.26532 L
.02381 1.27816 L
.02381 1.29091 L
.02381 1.30354 L
.02381 1.31606 L
.02381 1.32846 L
.02381 1.34074 L
.02381 1.35291 L
.02381 1.36495 L
.02381 1.37686 L
.02381 1.38865 L
.02381 1.40031 L
.02381 1.41184 L
.02381 1.41184 L
.02381 1.41184 L
.03333 1.41184 L
.04286 1.41184 L
.05238 1.41184 L
.0619 1.41184 L
.07143 1.41184 L
.08095 1.41184 L
.09048 1.41184 L
.1 1.41184 L
.10952 1.41184 L
.11905 1.41184 L
.12857 1.41184 L
.1381 1.41184 L
.14762 1.41184 L
.15714 1.41184 L
.16667 1.41184 L
.17619 1.41184 L
.18571 1.41184 L
.19524 1.41184 L
.20476 1.41184 L
.21429 1.41184 L
.22381 1.41184 L
.23333 1.41184 L
.24286 1.41184 L
.25238 1.41184 L
.2619 1.41184 L
.27143 1.41184 L
.28095 1.41184 L
.29048 1.41184 L
.3 1.41184 L
.30952 1.41184 L
.31905 1.41184 L
.32857 1.41184 L
.3381 1.41184 L
.34762 1.41184 L
.35714 1.41184 L
.36667 1.41184 L
.37619 1.41184 L
.38571 1.41184 L
.39524 1.41184 L
.40476 1.41184 L
.41429 1.41184 L
.42381 1.41184 L
.43333 1.41184 L
.44286 1.41184 L
.45238 1.41184 L
.4619 1.41184 L
.47143 1.41184 L
.48095 1.41184 L
.49048 1.41184 L
.5 1.41184 L
.50952 1.41184 L
.51905 1.41184 L
.52857 1.41184 L
.5381 1.41184 L
.54762 1.41184 L
.55714 1.41184 L
.56667 1.41184 L
.57619 1.41184 L
.58571 1.41184 L
.59524 1.41184 L
.60476 1.41184 L
.61429 1.41184 L
.62381 1.41184 L
.63333 1.41184 L
.64286 1.41184 L
.65238 1.41184 L
.6619 1.41184 L
.67143 1.41184 L
.68095 1.41184 L
.69048 1.41184 L
.7 1.41184 L
.70952 1.41184 L
.71905 1.41184 L
.72857 1.41184 L
.7381 1.41184 L
.74762 1.41184 L
.75714 1.41184 L
.76667 1.41184 L
.77619 1.41184 L
.78571 1.41184 L
.79524 1.41184 L
.80476 1.41184 L
.81429 1.41184 L
.82381 1.41184 L
.83333 1.41184 L
.84286 1.41184 L
.85238 1.41184 L
.8619 1.41184 L
.87143 1.41184 L
.88095 1.41184 L
.89048 1.41184 L
.9 1.41184 L
.90952 1.41184 L
.91905 1.41184 L
.92857 1.41184 L
.9381 1.41184 L
.94762 1.41184 L
.95714 1.41184 L
.96667 1.41184 L
.97619 1.41184 L
.97619 1.41184 L
F
1 g
.36448 1.36694 m
.2619 1.35038 L
.23552 1.33896 L
.24782 1.29249 L
.21647 1.28614 L
.21865 1.27443 L
.15873 1.23793 L
.15873 1.22063 L
.15873 1.21427 L
.20476 1.17594 L
.2619 1.12161 L
.3125 1.07461 L
.40476 1.15065 L
.37381 1.19534 L
.3754 1.26262 L
.35119 1.32046 L
.36448 1.36694 L
F
.41885 .61362 m
.40774 .60928 L
.42619 .50403 L
.40198 .40541 L
.42679 .40393 L
.54147 .39857 L
.52381 .42482 L
.52381 .48212 L
.54782 .48212 L
.54742 .52115 L
.52579 .52115 L
.52123 .5873 L
.47619 .57217 L
.46409 .58792 L
.45853 .61331 L
.41885 .61393 L
F
.28135 .83916 m
.29444 .84195 L
.30437 .94132 L
.29048 .94376 L
.27341 .92757 L
.28135 .83916 L
F
.5627 .39561 m
.5119 .38642 L
.5 .32177 L
.5 .27429 L
.50774 .2395 L
.53333 .25934 L
.56567 .25906 L
.61171 .31831 L
.5627 .39561 L
F
.22996 .89967 m
.19623 .91716 L
.21468 .97326 L
.2619 1.00044 L
.26468 1.00044 L
.29048 .94407 L
.27341 .92757 L
.25992 .93002 L
.22817 .92757 L
.22996 .89967 L
F
.60734 .67173 m
.6121 .64 L
.62579 .67827 L
.60734 .67173 L
F
.37877 .76707 m
.37798 .80036 L
.36429 .8131 L
.37857 .85 L
.40337 .85526 L
.43631 .93797 L
.42937 .96567 L
.44861 .90888 L
.42798 .90243 L
.44643 .8636 L
.43353 .83606 L
.45476 .76458 L
.42024 .76364 L
.39683 .76364 L
.37877 .76707 L
F
.44643 .8636 m
.48313 .87287 L
.53294 .92666 L
.53433 .92604 L
.54187 .88551 L
.58869 .81683 L
.52778 .80036 L
.49048 .8159 L
.48373 .78823 L
.45933 .78823 L
.45476 .76458 L
.43353 .83606 L
.44643 .8636 L
F
.54762 1.08079 m
.45238 1.15037 L
.44048 1.14178 L
.45238 1.09573 L
.44623 1.0346 L
.42421 .97719 L
.42937 .96567 L
.44861 .90888 L
.42798 .90243 L
.44643 .8636 L
.48313 .87287 L
.53294 .92666 L
.52183 .96051 L
.53492 1.01036 L
.54762 1.01307 L
.54762 1.08079 L
F
.39484 .64933 m
.40516 .62944 L
.41766 .63659 L
.45119 .64995 L
.48373 .78823 L
.45933 .78823 L
.45476 .76458 L
.42024 .76364 L
.41865 .7462 L
.43452 .74059 L
.43393 .68761 L
.3998 .67951 L
.39484 .64933 L
F
.77718 .93705 m
.76806 .93736 L
.7752 .95899 L
.75913 .93705 L
.77321 .92757 L
.77718 .93705 L
F
.68591 1.14407 m
.64683 1.25236 L
.66964 1.22173 L
.67817 1.25155 L
.67738 1.25046 L
.66984 1.27843 L
.66925 1.2803 L
.56131 1.28535 L
.55952 1.1245 L
.66587 1.12016 L
.68591 1.14407 L
F
.37857 .74184 m
.37877 .76707 L
.39683 .76364 L
.39702 .74184 L
.37857 .74184 L
F
.69603 .98899 m
.70238 1.03758 L
.72163 1.05482 L
.73472 1.00195 L
.7752 .95899 L
.76984 .95169 L
.72421 .99381 L
.69603 .98899 L
F
.69603 .98899 m
.72421 .99381 L
.76984 .95169 L
.75913 .93705 L
.77321 .92757 L
.78591 .89074 L
.83313 .87225 L
.79702 .81465 L
.76071 .79756 L
.73234 .7873 L
.68968 .80937 L
.65456 .87102 L
.67004 .91931 L
.69226 .95869 L
.69603 .98899 L
F
.37857 .74184 m
.36567 .71129 L
.39484 .64933 L
.3998 .67951 L
.43393 .68761 L
.43452 .74059 L
.41865 .7462 L
.42024 .76364 L
.39683 .76364 L
.39702 .74184 L
.37857 .74184 L
F
.225 .81807 m
.2619 .828 L
.27619 .83699 L
.2619 .92023 L
.26091 .92206 L
.2619 .92941 L
.26012 .93002 L
.22817 .92757 L
.22996 .89967 L
.225 .81807 L
F
.10357 .89136 m
.08313 .92666 L
.09861 .95838 L
.12679 .95443 L
.12659 .95321 L
.15496 .95321 L
.16687 .91195 L
.16706 .91226 L
.16111 .86422 L
.13968 .8812 L
.12837 .90919 L
.10357 .89136 L
F
.0629 .95169 m
.08333 .94529 L
.07738 .93369 L
.08313 .92666 L
.09861 .95838 L
.0629 .95169 L
F
.17222 .8044 m
.225 .81807 L
.225 .81807 L
.22996 .89967 L
.22996 .89967 L
.19623 .91747 L
.19623 .91716 L
.16706 .91226 L
.16706 .91226 L
.16111 .86422 L
.16111 .86422 L
.17242 .8044 L
F
.75675 .69197 m
.72857 .63597 L
.66567 .70444 L
.67897 .75897 L
.66667 .80192 L
.68968 .80937 L
.73234 .7873 L
.76091 .79756 L
.7498 .7761 L
.75675 .69197 L
F
.125 .85247 m
.17222 .8044 L
.16111 .86422 L
.13968 .8812 L
.125 .85247 L
F
.39921 1.30929 m
.45139 1.28003 L
.49206 1.26343 L
.52044 1.30589 L
.56131 1.28535 L
.55952 1.1245 L
.55952 1.1245 L
.55952 1.08959 L
.54762 1.08079 L
.45238 1.15037 L
.44008 1.14149 L
.40476 1.15065 L
.37381 1.19534 L
.3754 1.26262 L
.39921 1.30929 L
F
.77758 .32408 m
.79187 .35756 L
.79127 .42452 L
.83333 .45005 L
.84861 .50129 L
.8631 .44011 L
.85278 .43591 L
.82302 .27061 L
.78651 .27118 L
.77758 .32408 L
F
.65456 .54661 m
.67063 .542 L
.67798 .50831 L
.67341 .47574 L
.68948 .44794 L
.68194 .4075 L
.67302 .45336 L
.65734 .46363 L
.65456 .54661 L
F
.3125 1.07461 m
.2619 1.12161 L
.20476 1.17594 L
.18353 1.17594 L
.19643 1.00946 L
.125 1.01216 L
.11845 .99562 L
.11607 .99623 L
.12679 .95443 L
.12659 .95321 L
.15496 .95321 L
.16706 .91226 L
.19623 .91716 L
.21468 .97326 L
.2619 1.00044 L
.26468 1.00044 L
.30813 1.01337 L
.3125 1.07461 L
F
.05893 1.10303 m
.06905 1.09339 L
.06508 1.01936 L
.10258 1.01906 L
.11845 .99532 L
.125 1.01216 L
.19643 1.00946 L
.18353 1.17594 L
.20476 1.17594 L
.15873 1.21455 L
.15873 1.19282 L
.11905 1.19282 L
.10595 1.14005 L
.10714 1.11291 L
.05893 1.10303 L
F
.23571 1.33921 m
.19742 1.35164 L
.1877 1.33794 L
.15139 1.2996 L
.14008 1.24775 L
.10496 1.22063 L
.15873 1.22063 L
.15873 1.23793 L
.21865 1.27443 L
.21647 1.28614 L
.24782 1.29249 L
.23571 1.33921 L
F
.74325 .52819 m
.74603 .44072 L
.67341 .36343 L
.68452 .28564 L
.65258 .26019 L
.65357 .23922 L
.64444 .2395 L
.64246 .25429 L
.63452 .31456 L
.65516 .3561 L
.65456 .41495 L
.62401 .43441 L
.65734 .46363 L
.67302 .45336 L
.68194 .4075 L
.68948 .44794 L
.67341 .47574 L
.67798 .50831 L
.74325 .52819 L
F
.40198 .40541 m
.43492 .30995 L
.43393 .3022 L
.45813 .21053 L
.5 .21299 L
.5 .27429 L
.5 .32177 L
.5119 .38642 L
.5627 .39561 L
.54147 .39857 L
.42679 .40393 L
.40198 .40541 L
F
.44008 1.14149 m
.40456 1.15065 L
.3125 1.07461 L
.30813 1.01337 L
.26468 1.00044 L
.29048 .94407 L
.30437 .94132 L
.30476 .94041 L
.32004 .9784 L
.37659 .96051 L
.42421 .97719 L
.44623 1.0346 L
.45238 1.09573 L
.44008 1.14149 L
F
.36409 .81279 m
.33452 .80285 L
.3248 .83327 L
.29425 .84195 L
.30437 .94132 L
.30476 .94041 L
.32004 .9784 L
.37659 .96051 L
.42421 .97719 L
.42956 .96537 L
.43631 .93797 L
.40337 .85526 L
.37857 .85 L
.36409 .81279 L
F
.45813 .21053 m
.47996 .12142 L
.5 .1114 L
.59405 .13907 L
.65357 .23922 L
.64444 .2395 L
.62877 .24005 L
.64246 .25401 L
.63452 .31456 L
.61151 .3186 L
.56567 .25906 L
.53333 .25934 L
.50774 .2395 L
.5 .27429 L
.5 .21299 L
.45813 .21053 L
F
.60357 .20998 m
.58353 .19337 L
.59643 .17666 L
.6125 .19798 L
.60357 .20998 L
F
.61429 .69727 m
.60734 .67173 L
.62579 .67827 L
.6248 .70319 L
.61429 .69727 L
F
.06508 1.01966 m
.05317 .99592 L
.06468 .97477 L
.09762 .97113 L
.0625 .96537 L
.07877 .96112 L
.0629 .95169 L
.09861 .95838 L
.12679 .95443 L
.11607 .99623 L
.11845 .99532 L
.10258 1.01906 L
.06508 1.01936 L
F
.10357 .89136 m
.1252 .85247 L
.13988 .8812 L
.12837 .90919 L
.10357 .89136 L
F
.75655 .69197 m
.83274 .80658 L
.87401 .91747 L
.86647 .9459 L
.79663 .91686 L
.77718 .93705 L
.77679 .93644 L
.77321 .92757 L
.78591 .89074 L
.83313 .87225 L
.79702 .81465 L
.76071 .79756 L
.7498 .7761 L
.75655 .69197 L
F
.72163 1.05482 m
.70119 1.12508 L
.68591 1.14407 L
.66587 1.12016 L
.55952 1.1245 L
.55952 1.08959 L
.54762 1.08079 L
.54762 1.01307 L
.53492 1.01036 L
.52183 .96051 L
.53294 .92666 L
.53433 .92604 L
.54187 .88551 L
.58869 .81683 L
.62937 .78823 L
.66667 .80192 L
.68968 .80937 L
.65456 .87102 L
.67004 .91931 L
.69226 .95869 L
.70238 1.03758 L
.72163 1.05482 L
F
.64444 .2395 m
.64246 .25429 L
.62877 .24005 L
.64444 .2395 L
F
.74325 .52819 m
.72361 .61021 L
.72857 .63597 L
.66567 .70444 L
.6248 .70319 L
.62579 .67827 L
.6121 .64 L
.62817 .57063 L
.65456 .54784 L
.67063 .542 L
.67817 .50831 L
.74325 .52819 L
F
.06468 .97477 m
.07976 .97235 L
.0625 .96476 L
.0625 .96537 L
.09762 .97113 L
.06468 .97477 L
F
.27619 .83699 m
.28155 .83916 L
.27282 .92757 L
.25992 .93002 L
.2619 .92941 L
.26091 .92206 L
.2619 .92023 L
.27619 .83699 L
F
.36448 1.36694 m
.39345 1.36918 L
.38095 1.32485 L
.39921 1.30929 L
.3754 1.26262 L
.35119 1.32046 L
.36448 1.36694 L
F
.62937 .78823 m
.63452 .76271 L
.61429 .69727 L
.6248 .70319 L
.66567 .70444 L
.67897 .75897 L
.66667 .80192 L
.62937 .78823 L
F
.10496 1.22063 m
.05893 1.10303 L
.10714 1.11291 L
.10595 1.14005 L
.11905 1.19282 L
.15873 1.19282 L
.15873 1.21455 L
.15873 1.22063 L
.10496 1.22063 L
F
.41885 .61362 m
.40714 .61517 L
.41786 .63659 L
.45119 .64995 L
.48373 .78823 L
.49048 .8159 L
.52778 .80036 L
.58869 .81683 L
.62937 .78823 L
.63452 .76271 L
.61429 .69727 L
.60754 .67204 L
.6121 .64 L
.62817 .57063 L
.5996 .5506 L
.5996 .50861 L
.61667 .49763 L
.61667 .47393 L
.58571 .50831 L
.54742 .52115 L
.52579 .52115 L
.52123 .5873 L
.47619 .57217 L
.46409 .58792 L
.45853 .61331 L
.41885 .61362 L
F
.62817 .57063 m
.5996 .5506 L
.5996 .50861 L
.61667 .49763 L
.61667 .47393 L
.58571 .50831 L
.54742 .52115 L
.54782 .48212 L
.52381 .48212 L
.52381 .42482 L
.54147 .39857 L
.5627 .39561 L
.58512 .39561 L
.62401 .43441 L
.65734 .46363 L
.65456 .54661 L
.65456 .54784 L
.62817 .57032 L
F
.63452 .31456 m
.61151 .3186 L
.5627 .39561 L
.58512 .39561 L
.62401 .43441 L
.65456 .41495 L
.65516 .3561 L
.63452 .31456 L
F
0 g
.001 w
[ ] 0 setdash
.36448 1.36694 m
.2619 1.35038 L
.23552 1.33896 L
.24782 1.29249 L
.21647 1.28614 L
.21865 1.27443 L
.15873 1.23793 L
.15873 1.22063 L
.15873 1.21427 L
.20476 1.17594 L
.2619 1.12161 L
.3125 1.07461 L
.40476 1.15065 L
.37381 1.19534 L
.3754 1.26262 L
.35119 1.32046 L
.36448 1.36694 L
s
.41885 .61362 m
.40774 .60928 L
.42619 .50403 L
.40198 .40541 L
.42679 .40393 L
.54147 .39857 L
.52381 .42482 L
.52381 .48212 L
.54782 .48212 L
.54742 .52115 L
.52579 .52115 L
.52123 .5873 L
.47619 .57217 L
.46409 .58792 L
.45853 .61331 L
.41885 .61393 L
s
.28135 .83916 m
.29444 .84195 L
.30437 .94132 L
.29048 .94376 L
.27341 .92757 L
.28135 .83916 L
s
.5627 .39561 m
.5119 .38642 L
.5 .32177 L
.5 .27429 L
.50774 .2395 L
.53333 .25934 L
.56567 .25906 L
.61171 .31831 L
.5627 .39561 L
s
.22996 .89967 m
.19623 .91716 L
.21468 .97326 L
.2619 1.00044 L
.26468 1.00044 L
.29048 .94407 L
.27341 .92757 L
.25992 .93002 L
.22817 .92757 L
.22996 .89967 L
s
.60734 .67173 m
.6121 .64 L
.62579 .67827 L
.60734 .67173 L
s
.37877 .76707 m
.37798 .80036 L
.36429 .8131 L
.37857 .85 L
.40337 .85526 L
.43631 .93797 L
.42937 .96567 L
.44861 .90888 L
.42798 .90243 L
.44643 .8636 L
.43353 .83606 L
.45476 .76458 L
.42024 .76364 L
.39683 .76364 L
.37877 .76707 L
s
.44643 .8636 m
.48313 .87287 L
.53294 .92666 L
.53433 .92604 L
.54187 .88551 L
.58869 .81683 L
.52778 .80036 L
.49048 .8159 L
.48373 .78823 L
.45933 .78823 L
.45476 .76458 L
.43353 .83606 L
.44643 .8636 L
s
.54762 1.08079 m
.45238 1.15037 L
.44048 1.14178 L
.45238 1.09573 L
.44623 1.0346 L
.42421 .97719 L
.42937 .96567 L
.44861 .90888 L
.42798 .90243 L
.44643 .8636 L
.48313 .87287 L
.53294 .92666 L
.52183 .96051 L
.53492 1.01036 L
.54762 1.01307 L
.54762 1.08079 L
s
.39484 .64933 m
.40516 .62944 L
.41766 .63659 L
.45119 .64995 L
.48373 .78823 L
.45933 .78823 L
.45476 .76458 L
.42024 .76364 L
.41865 .7462 L
.43452 .74059 L
.43393 .68761 L
.3998 .67951 L
.39484 .64933 L
s
.77718 .93705 m
.76806 .93736 L
.7752 .95899 L
.75913 .93705 L
.77321 .92757 L
.77718 .93705 L
s
.68591 1.14407 m
.64683 1.25236 L
.66964 1.22173 L
.67817 1.25155 L
.67738 1.25046 L
.66984 1.27843 L
.66925 1.2803 L
.56131 1.28535 L
.55952 1.1245 L
.66587 1.12016 L
.68591 1.14407 L
s
.37857 .74184 m
.37877 .76707 L
.39683 .76364 L
.39702 .74184 L
.37857 .74184 L
s
.69603 .98899 m
.70238 1.03758 L
.72163 1.05482 L
.73472 1.00195 L
.7752 .95899 L
.76984 .95169 L
.72421 .99381 L
.69603 .98899 L
s
.69603 .98899 m
.72421 .99381 L
.76984 .95169 L
.75913 .93705 L
.77321 .92757 L
.78591 .89074 L
.83313 .87225 L
.79702 .81465 L
.76071 .79756 L
.73234 .7873 L
.68968 .80937 L
.65456 .87102 L
.67004 .91931 L
.69226 .95869 L
.69603 .98899 L
s
.37857 .74184 m
.36567 .71129 L
.39484 .64933 L
.3998 .67951 L
.43393 .68761 L
.43452 .74059 L
.41865 .7462 L
.42024 .76364 L
.39683 .76364 L
.39702 .74184 L
.37857 .74184 L
s
.225 .81807 m
.2619 .828 L
.27619 .83699 L
.2619 .92023 L
.26091 .92206 L
.2619 .92941 L
.26012 .93002 L
.22817 .92757 L
.22996 .89967 L
.225 .81807 L
s
.10357 .89136 m
.08313 .92666 L
.09861 .95838 L
.12679 .95443 L
.12659 .95321 L
.15496 .95321 L
.16687 .91195 L
.16706 .91226 L
.16111 .86422 L
.13968 .8812 L
.12837 .90919 L
.10357 .89136 L
s
.0629 .95169 m
.08333 .94529 L
.07738 .93369 L
.08313 .92666 L
.09861 .95838 L
.0629 .95169 L
s
.17222 .8044 m
.225 .81807 L
.225 .81807 L
.22996 .89967 L
.22996 .89967 L
.19623 .91747 L
.19623 .91716 L
.16706 .91226 L
.16706 .91226 L
.16111 .86422 L
.16111 .86422 L
.17242 .8044 L
s
.75675 .69197 m
.72857 .63597 L
.66567 .70444 L
.67897 .75897 L
.66667 .80192 L
.68968 .80937 L
.73234 .7873 L
.76091 .79756 L
.7498 .7761 L
.75675 .69197 L
s
.125 .85247 m
.17222 .8044 L
.16111 .86422 L
.13968 .8812 L
.125 .85247 L
s
.39921 1.30929 m
.45139 1.28003 L
.49206 1.26343 L
.52044 1.30589 L
.56131 1.28535 L
.55952 1.1245 L
.55952 1.1245 L
.55952 1.08959 L
.54762 1.08079 L
.45238 1.15037 L
.44008 1.14149 L
.40476 1.15065 L
.37381 1.19534 L
.3754 1.26262 L
.39921 1.30929 L
s
.77758 .32408 m
.79187 .35756 L
.79127 .42452 L
.83333 .45005 L
.84861 .50129 L
.8631 .44011 L
.85278 .43591 L
.82302 .27061 L
.78651 .27118 L
.77758 .32408 L
s
.65456 .54661 m
.67063 .542 L
.67798 .50831 L
.67341 .47574 L
.68948 .44794 L
.68194 .4075 L
.67302 .45336 L
.65734 .46363 L
.65456 .54661 L
s
.3125 1.07461 m
.2619 1.12161 L
.20476 1.17594 L
.18353 1.17594 L
.19643 1.00946 L
.125 1.01216 L
.11845 .99562 L
.11607 .99623 L
.12679 .95443 L
.12659 .95321 L
.15496 .95321 L
.16706 .91226 L
.19623 .91716 L
.21468 .97326 L
.2619 1.00044 L
.26468 1.00044 L
.30813 1.01337 L
.3125 1.07461 L
s
.05893 1.10303 m
.06905 1.09339 L
.06508 1.01936 L
.10258 1.01906 L
.11845 .99532 L
.125 1.01216 L
.19643 1.00946 L
.18353 1.17594 L
.20476 1.17594 L
.15873 1.21455 L
.15873 1.19282 L
.11905 1.19282 L
.10595 1.14005 L
.10714 1.11291 L
.05893 1.10303 L
s
.23571 1.33921 m
.19742 1.35164 L
.1877 1.33794 L
.15139 1.2996 L
.14008 1.24775 L
.10496 1.22063 L
.15873 1.22063 L
.15873 1.23793 L
.21865 1.27443 L
.21647 1.28614 L
.24782 1.29249 L
.23571 1.33921 L
s
.74325 .52819 m
.74603 .44072 L
.67341 .36343 L
.68452 .28564 L
.65258 .26019 L
.65357 .23922 L
.64444 .2395 L
.64246 .25429 L
.63452 .31456 L
.65516 .3561 L
.65456 .41495 L
.62401 .43441 L
.65734 .46363 L
.67302 .45336 L
.68194 .4075 L
.68948 .44794 L
.67341 .47574 L
.67798 .50831 L
.74325 .52819 L
s
.40198 .40541 m
.43492 .30995 L
.43393 .3022 L
.45813 .21053 L
.5 .21299 L
.5 .27429 L
.5 .32177 L
.5119 .38642 L
.5627 .39561 L
.54147 .39857 L
.42679 .40393 L
.40198 .40541 L
s
.44008 1.14149 m
.40456 1.15065 L
.3125 1.07461 L
.30813 1.01337 L
.26468 1.00044 L
.29048 .94407 L
.30437 .94132 L
.30476 .94041 L
.32004 .9784 L
.37659 .96051 L
.42421 .97719 L
.44623 1.0346 L
.45238 1.09573 L
.44008 1.14149 L
s
.36409 .81279 m
.33452 .80285 L
.3248 .83327 L
.29425 .84195 L
.30437 .94132 L
.30476 .94041 L
.32004 .9784 L
.37659 .96051 L
.42421 .97719 L
.42956 .96537 L
.43631 .93797 L
.40337 .85526 L
.37857 .85 L
.36409 .81279 L
s
.45813 .21053 m
.47996 .12142 L
.5 .1114 L
.59405 .13907 L
.65357 .23922 L
.64444 .2395 L
.62877 .24005 L
.64246 .25401 L
.63452 .31456 L
.61151 .3186 L
.56567 .25906 L
.53333 .25934 L
.50774 .2395 L
.5 .27429 L
.5 .21299 L
.45813 .21053 L
s
.60357 .20998 m
.58353 .19337 L
.59643 .17666 L
.6125 .19798 L
.60357 .20998 L
s
.61429 .69727 m
.60734 .67173 L
.62579 .67827 L
.6248 .70319 L
.61429 .69727 L
s
.06508 1.01966 m
.05317 .99592 L
.06468 .97477 L
.09762 .97113 L
.0625 .96537 L
.07877 .96112 L
.0629 .95169 L
.09861 .95838 L
.12679 .95443 L
.11607 .99623 L
.11845 .99532 L
.10258 1.01906 L
.06508 1.01936 L
s
.10357 .89136 m
.1252 .85247 L
.13988 .8812 L
.12837 .90919 L
.10357 .89136 L
s
.75655 .69197 m
.83274 .80658 L
.87401 .91747 L
.86647 .9459 L
.79663 .91686 L
.77718 .93705 L
.77679 .93644 L
.77321 .92757 L
.78591 .89074 L
.83313 .87225 L
.79702 .81465 L
.76071 .79756 L
.7498 .7761 L
.75655 .69197 L
s
.72163 1.05482 m
.70119 1.12508 L
.68591 1.14407 L
.66587 1.12016 L
.55952 1.1245 L
.55952 1.08959 L
.54762 1.08079 L
.54762 1.01307 L
.53492 1.01036 L
.52183 .96051 L
.53294 .92666 L
.53433 .92604 L
.54187 .88551 L
.58869 .81683 L
.62937 .78823 L
.66667 .80192 L
.68968 .80937 L
.65456 .87102 L
.67004 .91931 L
.69226 .95869 L
.70238 1.03758 L
.72163 1.05482 L
s
.64444 .2395 m
.64246 .25429 L
.62877 .24005 L
.64444 .2395 L
s
.74325 .52819 m
.72361 .61021 L
.72857 .63597 L
.66567 .70444 L
.6248 .70319 L
.62579 .67827 L
.6121 .64 L
.62817 .57063 L
.65456 .54784 L
.67063 .542 L
.67817 .50831 L
.74325 .52819 L
s
.06468 .97477 m
.07976 .97235 L
.0625 .96476 L
.0625 .96537 L
.09762 .97113 L
.06468 .97477 L
s
.27619 .83699 m
.28155 .83916 L
.27282 .92757 L
.25992 .93002 L
.2619 .92941 L
.26091 .92206 L
.2619 .92023 L
.27619 .83699 L
s
.36448 1.36694 m
.39345 1.36918 L
.38095 1.32485 L
.39921 1.30929 L
.3754 1.26262 L
.35119 1.32046 L
.36448 1.36694 L
s
.62937 .78823 m
.63452 .76271 L
.61429 .69727 L
.6248 .70319 L
.66567 .70444 L
.67897 .75897 L
.66667 .80192 L
.62937 .78823 L
s
.10496 1.22063 m
.05893 1.10303 L
.10714 1.11291 L
.10595 1.14005 L
.11905 1.19282 L
.15873 1.19282 L
.15873 1.21455 L
.15873 1.22063 L
.10496 1.22063 L
s
.41885 .61362 m
.40714 .61517 L
.41786 .63659 L
.45119 .64995 L
.48373 .78823 L
.49048 .8159 L
.52778 .80036 L
.58869 .81683 L
.62937 .78823 L
.63452 .76271 L
.61429 .69727 L
.60754 .67204 L
.6121 .64 L
.62817 .57063 L
.5996 .5506 L
.5996 .50861 L
.61667 .49763 L
.61667 .47393 L
.58571 .50831 L
.54742 .52115 L
.52579 .52115 L
.52123 .5873 L
.47619 .57217 L
.46409 .58792 L
.45853 .61331 L
.41885 .61362 L
s
.62817 .57063 m
.5996 .5506 L
.5996 .50861 L
.61667 .49763 L
.61667 .47393 L
.58571 .50831 L
.54742 .52115 L
.54782 .48212 L
.52381 .48212 L
.52381 .42482 L
.54147 .39857 L
.5627 .39561 L
.58512 .39561 L
.62401 .43441 L
.65734 .46363 L
.65456 .54661 L
.65456 .54784 L
.62817 .57032 L
s
.63452 .31456 m
.61151 .3186 L
.5627 .39561 L
.58512 .39561 L
.62401 .43441 L
.65456 .41495 L
.65516 .3561 L
.63452 .31456 L
s
.5 Mabswid
[ .05 .03 ] 0 setdash
.48056 .12503 m
.63393 1.25966 L
s
.012 w
[ ] 0 setdash
.97619 1.41184 m
.97619 1.41184 L
.97619 1.40031 L
.97619 1.38865 L
.97619 1.37686 L
.97619 1.36495 L
.97619 1.35291 L
.97619 1.34074 L
.97619 1.32846 L
.97619 1.31606 L
.97619 1.30354 L
.97619 1.29091 L
.97619 1.27816 L
.97619 1.26532 L
.97619 1.25236 L
.97619 1.2393 L
.97619 1.22614 L
.97619 1.21288 L
.97619 1.19953 L
.97619 1.18609 L
.97619 1.17255 L
.97619 1.15893 L
.97619 1.14522 L
.97619 1.13143 L
.97619 1.11756 L
.97619 1.10361 L
.97619 1.08959 L
.97619 1.07549 L
.97619 1.06133 L
.97619 1.0471 L
.97619 1.03281 L
.97619 1.01846 L
.97619 1.00405 L
.97619 .98959 L
.97619 .97507 L
.97619 .96051 L
.97619 .9459 L
.97619 .93124 L
.97619 .91655 L
.97619 .90182 L
.97619 .88705 L
.97619 .87225 L
.97619 .85742 L
.97619 .84257 L
.97619 .82769 L
.97619 .81279 L
.97619 .79788 L
.97619 .78294 L
.97619 .768 L
.97619 .75305 L
Mistroke
.97619 .7381 L
.97619 .72314 L
.97619 .70818 L
.97619 .69322 L
.97619 .67827 L
.97619 .66333 L
.97619 .6484 L
.97619 .63348 L
.97619 .61858 L
.97619 .60371 L
.97619 .58885 L
.97619 .57402 L
.97619 .55922 L
.97619 .54446 L
.97619 .52972 L
.97619 .51503 L
.97619 .50037 L
.97619 .48576 L
.97619 .4712 L
.97619 .45668 L
.97619 .44222 L
.97619 .42781 L
.97619 .41346 L
.97619 .39917 L
.97619 .38494 L
.97619 .37078 L
.97619 .35669 L
.97619 .34266 L
.97619 .32872 L
.97619 .31485 L
.97619 .30106 L
.97619 .28735 L
.97619 .27372 L
.97619 .26019 L
.97619 .24674 L
.97619 .23339 L
.97619 .22013 L
.97619 .20697 L
.97619 .19391 L
.97619 .18096 L
.97619 .16811 L
.97619 .15537 L
.97619 .14273 L
.97619 .13022 L
.97619 .11781 L
.97619 .10553 L
.97619 .09337 L
.97619 .08133 L
.97619 .06941 L
.97619 .05762 L
Mistroke
.97619 .04596 L
.97619 .03444 L
Mfstroke
.97619 .03444 m
.97619 .03444 L
.96667 .03444 L
.95714 .03444 L
.94762 .03444 L
.9381 .03444 L
.92857 .03444 L
.91905 .03444 L
.90952 .03444 L
.9 .03444 L
.89048 .03444 L
.88095 .03444 L
.87143 .03444 L
.8619 .03444 L
.85238 .03444 L
.84286 .03444 L
.83333 .03444 L
.82381 .03444 L
.81429 .03444 L
.80476 .03444 L
.79524 .03444 L
.78571 .03444 L
.77619 .03444 L
.76667 .03444 L
.75714 .03444 L
.74762 .03444 L
.7381 .03444 L
.72857 .03444 L
.71905 .03444 L
.70952 .03444 L
.7 .03444 L
.69048 .03444 L
.68095 .03444 L
.67143 .03444 L
.6619 .03444 L
.65238 .03444 L
.64286 .03444 L
.63333 .03444 L
.62381 .03444 L
.61429 .03444 L
.60476 .03444 L
.59524 .03444 L
.58571 .03444 L
.57619 .03444 L
.56667 .03444 L
.55714 .03444 L
.54762 .03444 L
.5381 .03444 L
.52857 .03444 L
.51905 .03444 L
Mistroke
.50952 .03444 L
.5 .03444 L
.49048 .03444 L
.48095 .03444 L
.47143 .03444 L
.4619 .03444 L
.45238 .03444 L
.44286 .03444 L
.43333 .03444 L
.42381 .03444 L
.41429 .03444 L
.40476 .03444 L
.39524 .03444 L
.38571 .03444 L
.37619 .03444 L
.36667 .03444 L
.35714 .03444 L
.34762 .03444 L
.3381 .03444 L
.32857 .03444 L
.31905 .03444 L
.30952 .03444 L
.3 .03444 L
.29048 .03444 L
.28095 .03444 L
.27143 .03444 L
.2619 .03444 L
.25238 .03444 L
.24286 .03444 L
.23333 .03444 L
.22381 .03444 L
.21429 .03444 L
.20476 .03444 L
.19524 .03444 L
.18571 .03444 L
.17619 .03444 L
.16667 .03444 L
.15714 .03444 L
.14762 .03444 L
.1381 .03444 L
.12857 .03444 L
.11905 .03444 L
.10952 .03444 L
.1 .03444 L
.09048 .03444 L
.08095 .03444 L
.07143 .03444 L
.0619 .03444 L
.05238 .03444 L
.04286 .03444 L
Mistroke
.03333 .03444 L
.02381 .03444 L
Mfstroke
.02381 .03444 m
.02381 .04596 L
.02381 .05762 L
.02381 .06941 L
.02381 .08133 L
.02381 .09337 L
.02381 .10553 L
.02381 .11781 L
.02381 .13022 L
.02381 .14273 L
.02381 .15537 L
.02381 .16811 L
.02381 .18096 L
.02381 .19391 L
.02381 .20697 L
.02381 .22013 L
.02381 .23339 L
.02381 .24674 L
.02381 .26019 L
.02381 .27372 L
.02381 .28735 L
.02381 .30106 L
.02381 .31485 L
.02381 .32872 L
.02381 .34266 L
.02381 .35669 L
.02381 .37078 L
.02381 .38494 L
.02381 .39917 L
.02381 .41346 L
.02381 .42781 L
.02381 .44222 L
.02381 .45668 L
.02381 .4712 L
.02381 .48576 L
.02381 .50037 L
.02381 .51503 L
.02381 .52972 L
.02381 .54446 L
.02381 .55922 L
.02381 .57402 L
.02381 .58885 L
.02381 .60371 L
.02381 .61858 L
.02381 .63348 L
.02381 .6484 L
.02381 .66333 L
.02381 .67827 L
.02381 .69322 L
.02381 .70818 L
Mistroke
.02381 .72314 L
.02381 .7381 L
.02381 .75305 L
.02381 .768 L
.02381 .78294 L
.02381 .79788 L
.02381 .81279 L
.02381 .82769 L
.02381 .84257 L
.02381 .85742 L
.02381 .87225 L
.02381 .88705 L
.02381 .90182 L
.02381 .91655 L
.02381 .93124 L
.02381 .9459 L
.02381 .96051 L
.02381 .97507 L
.02381 .98959 L
.02381 1.00405 L
.02381 1.01846 L
.02381 1.03281 L
.02381 1.0471 L
.02381 1.06133 L
.02381 1.07549 L
.02381 1.08959 L
.02381 1.10361 L
.02381 1.11756 L
.02381 1.13143 L
.02381 1.14522 L
.02381 1.15893 L
.02381 1.17255 L
.02381 1.18609 L
.02381 1.19953 L
.02381 1.21288 L
.02381 1.22614 L
.02381 1.2393 L
.02381 1.25236 L
.02381 1.26532 L
.02381 1.27816 L
.02381 1.29091 L
.02381 1.30354 L
.02381 1.31606 L
.02381 1.32846 L
.02381 1.34074 L
.02381 1.35291 L
.02381 1.36495 L
.02381 1.37686 L
.02381 1.38865 L
.02381 1.40031 L
Mistroke
.02381 1.41184 L
.02381 1.41184 L
Mfstroke
.02381 1.41184 m
.03333 1.41184 L
.04286 1.41184 L
.05238 1.41184 L
.0619 1.41184 L
.07143 1.41184 L
.08095 1.41184 L
.09048 1.41184 L
.1 1.41184 L
.10952 1.41184 L
.11905 1.41184 L
.12857 1.41184 L
.1381 1.41184 L
.14762 1.41184 L
.15714 1.41184 L
.16667 1.41184 L
.17619 1.41184 L
.18571 1.41184 L
.19524 1.41184 L
.20476 1.41184 L
.21429 1.41184 L
.22381 1.41184 L
.23333 1.41184 L
.24286 1.41184 L
.25238 1.41184 L
.2619 1.41184 L
.27143 1.41184 L
.28095 1.41184 L
.29048 1.41184 L
.3 1.41184 L
.30952 1.41184 L
.31905 1.41184 L
.32857 1.41184 L
.3381 1.41184 L
.34762 1.41184 L
.35714 1.41184 L
.36667 1.41184 L
.37619 1.41184 L
.38571 1.41184 L
.39524 1.41184 L
.40476 1.41184 L
.41429 1.41184 L
.42381 1.41184 L
.43333 1.41184 L
.44286 1.41184 L
.45238 1.41184 L
.4619 1.41184 L
.47143 1.41184 L
.48095 1.41184 L
.49048 1.41184 L
Mistroke
.5 1.41184 L
.50952 1.41184 L
.51905 1.41184 L
.52857 1.41184 L
.5381 1.41184 L
.54762 1.41184 L
.55714 1.41184 L
.56667 1.41184 L
.57619 1.41184 L
.58571 1.41184 L
.59524 1.41184 L
.60476 1.41184 L
.61429 1.41184 L
.62381 1.41184 L
.63333 1.41184 L
.64286 1.41184 L
.65238 1.41184 L
.6619 1.41184 L
.67143 1.41184 L
.68095 1.41184 L
.69048 1.41184 L
.7 1.41184 L
.70952 1.41184 L
.71905 1.41184 L
.72857 1.41184 L
.7381 1.41184 L
.74762 1.41184 L
.75714 1.41184 L
.76667 1.41184 L
.77619 1.41184 L
.78571 1.41184 L
.79524 1.41184 L
.80476 1.41184 L
.81429 1.41184 L
.82381 1.41184 L
.83333 1.41184 L
.84286 1.41184 L
.85238 1.41184 L
.8619 1.41184 L
.87143 1.41184 L
.88095 1.41184 L
.89048 1.41184 L
.9 1.41184 L
.90952 1.41184 L
.91905 1.41184 L
.92857 1.41184 L
.9381 1.41184 L
.94762 1.41184 L
.95714 1.41184 L
.96667 1.41184 L
Mistroke
.97619 1.41184 L
.97619 1.41184 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{300, 180},
 ImageCacheValid->False,
 CellTags->"S5.65.1"],

Cell[BoxData["\<\"-WorldGraphics-\"\>"], "Output",
 CellLabel->"Out[11]= ",
 CellTags->"S5.65.1"]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["ToMinutes[", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["deg", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[{
      StyleBox["convert ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["deg", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" into minutes",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ToMinutes[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["deg", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "convert when the argument is in degrees and minutes",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[{
      StyleBox["ToMinutes[{", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["deg", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["min", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[", ", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["sec", "TI",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox["}]", "MR",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}],
      StyleBox[" ",
       GridBoxOptions->{RowLines->False,
       RowSpacings->0.4}]
     }],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox[
     "convert when the argument is in degrees, minutes, and seconds",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell["Converting into minutes. ", "Caption",
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Giving the name of the continent is the same as giving the list of names of \
countries in that continent. ",
 StyleBox["World", "MR"],
 " gives the list of all the countries in the world. As previously noted, the \
names of countries are strings and need to be included in quotes. The names \
of continents are symbols and do not require quotes. The following countries \
can be given: "
}], "Text",
 CellTags->{"S5.65.1", "1.35"}],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Belize",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bermuda",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Canada",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Costa Rica",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cuba",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Dominican Republic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["El Salvador",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Greenland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Guatemala",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Haiti",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Honduras",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Jamaica",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Mexico",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Nicaragua",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Panama",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Puerto Rico",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["USA",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["NorthAmerica", "MR"],
 "."
}], "Caption",
 CellTags->"S5.65.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Albania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Andorra",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Austria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Belarus",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Belgium",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bosnia and Herzegovina",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Bulgaria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Croatia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cyprus",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Czech Republic",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Denmark",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Estonia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Finland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["France",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Germany",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Gibraltar",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Greece",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Hungary",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Iceland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ireland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Italy",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Latvia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Liechtenstein",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lithuania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Luxembourg",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Macedonia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Moldova",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Monaco",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Netherlands",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Norway",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Poland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Portugal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Romania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Russia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["San Marino",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Serbia and Montenegro",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Slovakia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Slovenia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Spain",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Sweden",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Switzerland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Turkey",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Ukraine",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["United Kingdom",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["Europe", "MR"],
 "."
}], "Caption",
 CellTags->"S5.65.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Argentina",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bolivia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Brazil",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Chile",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Colombia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ecuador",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["French Guiana",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Guyana",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Paraguay",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Peru",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Suriname",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Uruguay",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Venezuela",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["SouthAmerica", "MR"],
 "."
}], "Caption",
 CellTags->"S5.65.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Australia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Fiji",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Indonesia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["New Zealand",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Papua New Guinea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["Oceania", "MR"],
 "."
}], "Caption",
 CellTags->"S5.65.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Afghanistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Armenia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Azerbaijan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bahrain",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Bangladesh",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Bhutan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Brunei",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Burma",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cambodia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["China",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Georgia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["India",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Indonesia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Iran",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Iraq",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Israel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Japan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Jordan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Kazakhstan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Kuwait",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Kyrgyzstan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Laos",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Lebanon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Malaysia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Mongolia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Nepal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["North Korea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Oman",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Pakistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Philippines",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Qatar",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Russia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Saudi Arabia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Singapore",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["South Korea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Sri Lanka",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Syria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Taiwan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tajikistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Thailand",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Turkey",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Turkmenistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Uzbekistan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Vietnam",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["Asia", "MR"],
 "."
}], "Caption",
 CellTags->"S5.65.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Bahrain",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Egypt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Iran",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Iraq",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Israel",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Jordan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Kuwait",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lebanon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Oman",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Qatar",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Saudi Arabia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Syria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Turkey",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["UAE",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Yemen",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["MiddleEast", "MR"],
 "."
}], "Caption",
 CellTags->"S5.65.1"],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["Algeria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Angola",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Benin",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Botswana",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Burkina",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Burundi",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cameroon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["CAR",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Chad",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Congo",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Cote d\[CloseCurlyQuote]Ivoire",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Djibouti",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Egypt",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Equatorial Guinea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Eritrea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ethiopia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Gabon",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Ghana",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Guinea",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Guinea\[Hyphen]Bissau",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Kenya",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Lesotho",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Liberia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Libya",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Madagascar",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Malawi",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Mali",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mauritania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Morocco",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Mozambique",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Namibia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Niger",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Nigeria",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Rwanda",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Senegal",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Sierra Leone",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Somalia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["South Africa",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Sudan",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Swaziland",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Tanzania",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["The Gambia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Togo",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Tunisia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Uganda",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Western Sahara",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Zaire",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], Cell[TextData[StyleBox["Zambia",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]},
    {Cell[TextData[StyleBox["Zimbabwe",
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}]],
      GridBoxOptions->{RowLines->False,
      RowSpacings->0.4}], "\[Null]"}
    },
   ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{RowLines->False,
 RowSpacings->0.4},
 CellTags->"S5.65.1"],

Cell[TextData[{
 "Countries in the list ",
 StyleBox["Africa", "MR"],
 "."
}], "Caption",
 CellTags->"S5.65.1"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{33, 1280}, {0, 1002}},
WindowSize->{550, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.65.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.65.1", "1.1"}],
    Cell[1918, 61, 2407, 73, 124, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[4328, 136, 59, 1, 15, "Caption",
      CellTags->"S5.65.1"],
    Cell[4390, 139, 1086, 28, 120, "Text",
      CellTags->{"S5.65.1", "1.2"}],
    Cell[5479, 169, 78, 1, 40, "MathCaption",
      CellTags->{"S5.65.1", "1.3"}],
    Cell[5560, 172, 89, 2, 28, "Input",
      CellTags->"S5.65.1"],
    Cell[5652, 176, 146, 4, 40, "MathCaption",
      CellTags->{"S5.65.1", "1.4"}],
    Cell[5823, 184, 82, 2, 28, "Input",
      CellTags->"S5.65.1"],
    Cell[5908, 188, 71885, 2770, 186, 33942, 2297, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"S5.65.1"],
    Cell[77796, 2960, 96, 2, 25, "Output",
      CellTags->"S5.65.1"],
    Cell[77907, 2965, 152, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.5"}],
    Cell[78084, 2973, 94, 2, 70, "Input",
      CellTags->"S5.65.1"],
    Cell[78181, 2977, 78895, 5430, 70, 78824, 5427, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.65.1"],
    Cell[157079, 8409, 96, 2, 70, "Output",
      CellTags->"S5.65.1"],
    Cell[157190, 8414, 2180, 67, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[159373, 8483, 82, 1, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[159458, 8486, 1433, 38, 70, "Text",
      CellTags->{"S5.65.1", "1.6"}],
    Cell[160894, 8526, 87, 1, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.7"}],
    Cell[160984, 8529, 222, 7, 70, "Input",
      CellTags->"S5.65.1"],
    Cell[161209, 8538, 170, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.8"}],
    Cell[161404, 8546, 99, 2, 70, "Input",
      CellTags->"S5.65.1"],
    Cell[161506, 8550, 26001, 1683, 70, 25930, 1680, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.65.1"],
    Cell[187510, 10235, 96, 2, 70, "Output",
      CellTags->"S5.65.1"],
    Cell[187621, 10240, 1022, 18, 70, "Text",
      CellTags->{"S5.65.1", "1.9"}],
    Cell[188646, 10260, 1037, 26, 70, "Text",
      CellTags->{"S5.65.1", "1.10"}],
    Cell[189686, 10288, 1579, 42, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[191268, 10332, 53, 1, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[191324, 10335, 267, 6, 70, "Text",
      CellTags->{"S5.65.1", "1.11"}],
    Cell[191594, 10343, 733, 23, 70, "Text",
      CellTags->{"S5.65.1", "1.12"}],
    Cell[192330, 10368, 397, 11, 70, "Text",
      CellTags->{"S5.65.1", "1.13"}],
    Cell[192730, 10381, 515, 12, 70, "Text",
      CellTags->{"S5.65.1", "1.14"}],
    Cell[193248, 10395, 364, 7, 70, "Text",
      CellTags->{"S5.65.1", "1.15"}],
    Cell[193615, 10404, 334, 9, 70, "Text",
      CellTags->{"S5.65.1", "1.16"}],
    Cell[193952, 10415, 464, 13, 70, "Text",
      CellTags->{"S5.65.1", "1.17"}],
    Cell[194419, 10430, 459, 11, 70, "Text",
      CellTags->{"S5.65.1", "1.18"}],
    Cell[194881, 10443, 1197, 34, 70, "Text",
      CellTags->{"S5.65.1", "1.19"}],
    Cell[196081, 10479, 203, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.20"}],
    Cell[196309, 10487, 140, 5, 70, "Input",
      CellTags->"S5.65.1"],
    Cell[196452, 10494, 25613, 1745, 70, 25542, 1742, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.65.1"],
    Cell[222068, 12241, 96, 2, 70, "Output",
      CellTags->"S5.65.1"],
    Cell[222179, 12246, 4719, 139, 70, "DefinitionBox3Col",
      CellTags->"S5.65.1"],
    Cell[226901, 12387, 109, 5, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[227013, 12394, 14543, 428, 70, "DefinitionBox3Col",
      CellTags->"S5.65.1"],
    Cell[241559, 12824, 184, 7, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[241746, 12833, 583, 16, 70, "Text",
      CellTags->{"S5.65.1", "1.21"}],
    Cell[242332, 12851, 1831, 60, 70, "Text",
      CellTags->{"S5.65.1", "1.22"}],
    Cell[244166, 12913, 1997, 66, 70, "Text",
      CellTags->{"S5.65.1", "1.23"}],
    Cell[246166, 12981, 656, 14, 70, "Text",
      CellTags->{"S5.65.1", "1.24"}],
    Cell[246825, 12997, 203, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.25"}],
    Cell[247053, 13005, 232, 8, 70, "Input",
      CellTags->"S5.65.1"],
    Cell[247288, 13015, 31916, 2080, 70, 31845, 2077, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.65.1"],
    Cell[279207, 15097, 96, 2, 70, "Output",
      CellTags->"S5.65.1"],
    Cell[279318, 15102, 918, 24, 70, "Text",
      CellTags->{"S5.65.1", "1.26"}],
    Cell[280239, 15128, 2602, 86, 70, "Text",
      CellTags->{"S5.65.1", "1.27"}],
    Cell[282844, 15216, 400, 10, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.28"}],
    Cell[283269, 15230, 215, 7, 70, "Input",
      CellTags->"S5.65.1"],
    Cell[283487, 15239, 54399, 3899, 70, 54328, 3896, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.65.1"],
    Cell[337889, 19140, 96, 2, 70, "Output",
      CellTags->"S5.65.1"],
    Cell[338000, 19145, 913, 20, 70, "Text",
      CellTags->{"S5.65.1", "1.29"}],
    Cell[338916, 19167, 829, 18, 70, "Text",
      CellTags->{"S5.65.1", "1.30"}],
    Cell[339748, 19187, 3445, 107, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[343196, 19296, 129, 5, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[343328, 19303, 2224, 70, 70, "Text",
      CellTags->{"S5.65.1", "1.31"}],
    Cell[345555, 19375, 143, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.32"}],
    Cell[345723, 19383, 85, 2, 70, "Input",
      CellTags->"S5.65.1"],
    Cell[345811, 19387, 915, 32, 70, "Output",
      CellTags->"S5.65.1"],
    Cell[346741, 19422, 146, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.33"}],
    Cell[346912, 19430, 158, 6, 70, "Input",
      CellTags->"S5.65.1"],
    Cell[347073, 19438, 251, 9, 70, "Output",
      CellTags->"S5.65.1"],
    Cell[347339, 19450, 260, 9, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.34"}],
    Cell[347624, 19463, 154, 7, 70, "Input",
      CellTags->"S5.65.1"],
    Cell[347781, 19472, 31998, 2086, 70, 31927, 2083, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S5.65.1"],
    Cell[379782, 21560, 97, 2, 70, "Output",
      CellTags->"S5.65.1"],
    Cell[379894, 21565, 3021, 94, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[382918, 21661, 66, 1, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[382987, 21664, 450, 9, 70, "Text",
      CellTags->{"S5.65.1", "1.35"}],
    Cell[383440, 21675, 3101, 83, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[386544, 21760, 117, 5, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[386664, 21767, 7720, 204, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[394387, 21973, 111, 5, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[394501, 21980, 2411, 65, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[396915, 22047, 117, 5, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[397035, 22054, 1059, 29, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[398097, 22085, 112, 5, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[398212, 22092, 7682, 204, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[405897, 22298, 109, 5, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[406009, 22305, 2725, 74, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[408737, 22381, 115, 5, 70, "Caption",
      CellTags->"S5.65.1"],
    Cell[408855, 22388, 8570, 227, 70, "DefinitionBox",
      CellTags->"S5.65.1"],
    Cell[417428, 22617, 111, 5, 70, "Caption",
      CellTags->"S5.65.1"]},
  "1.1"->{
    Cell[1776, 53, 139, 6, 36, "Subsection",
      CellTags->{"S5.65.1", "1.1"}]},
  "1.2"->{
    Cell[4390, 139, 1086, 28, 120, "Text",
      CellTags->{"S5.65.1", "1.2"}]},
  "1.3"->{
    Cell[5479, 169, 78, 1, 40, "MathCaption",
      CellTags->{"S5.65.1", "1.3"}]},
  "1.4"->{
    Cell[5652, 176, 146, 4, 40, "MathCaption",
      CellTags->{"S5.65.1", "1.4"}]},
  "1.5"->{
    Cell[77907, 2965, 152, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.5"}]},
  "1.6"->{
    Cell[159458, 8486, 1433, 38, 70, "Text",
      CellTags->{"S5.65.1", "1.6"}]},
  "1.7"->{
    Cell[160894, 8526, 87, 1, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.7"}]},
  "1.8"->{
    Cell[161209, 8538, 170, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.8"}]},
  "1.9"->{
    Cell[187621, 10240, 1022, 18, 70, "Text",
      CellTags->{"S5.65.1", "1.9"}]},
  "1.10"->{
    Cell[188646, 10260, 1037, 26, 70, "Text",
      CellTags->{"S5.65.1", "1.10"}]},
  "1.11"->{
    Cell[191324, 10335, 267, 6, 70, "Text",
      CellTags->{"S5.65.1", "1.11"}]},
  "1.12"->{
    Cell[191594, 10343, 733, 23, 70, "Text",
      CellTags->{"S5.65.1", "1.12"}]},
  "1.13"->{
    Cell[192330, 10368, 397, 11, 70, "Text",
      CellTags->{"S5.65.1", "1.13"}]},
  "1.14"->{
    Cell[192730, 10381, 515, 12, 70, "Text",
      CellTags->{"S5.65.1", "1.14"}]},
  "1.15"->{
    Cell[193248, 10395, 364, 7, 70, "Text",
      CellTags->{"S5.65.1", "1.15"}]},
  "1.16"->{
    Cell[193615, 10404, 334, 9, 70, "Text",
      CellTags->{"S5.65.1", "1.16"}]},
  "1.17"->{
    Cell[193952, 10415, 464, 13, 70, "Text",
      CellTags->{"S5.65.1", "1.17"}]},
  "1.18"->{
    Cell[194419, 10430, 459, 11, 70, "Text",
      CellTags->{"S5.65.1", "1.18"}]},
  "1.19"->{
    Cell[194881, 10443, 1197, 34, 70, "Text",
      CellTags->{"S5.65.1", "1.19"}]},
  "1.20"->{
    Cell[196081, 10479, 203, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.20"}]},
  "1.21"->{
    Cell[241746, 12833, 583, 16, 70, "Text",
      CellTags->{"S5.65.1", "1.21"}]},
  "1.22"->{
    Cell[242332, 12851, 1831, 60, 70, "Text",
      CellTags->{"S5.65.1", "1.22"}]},
  "1.23"->{
    Cell[244166, 12913, 1997, 66, 70, "Text",
      CellTags->{"S5.65.1", "1.23"}]},
  "1.24"->{
    Cell[246166, 12981, 656, 14, 70, "Text",
      CellTags->{"S5.65.1", "1.24"}]},
  "1.25"->{
    Cell[246825, 12997, 203, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.25"}]},
  "1.26"->{
    Cell[279318, 15102, 918, 24, 70, "Text",
      CellTags->{"S5.65.1", "1.26"}]},
  "1.27"->{
    Cell[280239, 15128, 2602, 86, 70, "Text",
      CellTags->{"S5.65.1", "1.27"}]},
  "1.28"->{
    Cell[282844, 15216, 400, 10, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.28"}]},
  "1.29"->{
    Cell[338000, 19145, 913, 20, 70, "Text",
      CellTags->{"S5.65.1", "1.29"}]},
  "1.30"->{
    Cell[338916, 19167, 829, 18, 70, "Text",
      CellTags->{"S5.65.1", "1.30"}]},
  "1.31"->{
    Cell[343328, 19303, 2224, 70, 70, "Text",
      CellTags->{"S5.65.1", "1.31"}]},
  "1.32"->{
    Cell[345555, 19375, 143, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.32"}]},
  "1.33"->{
    Cell[346741, 19422, 146, 4, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.33"}]},
  "1.34"->{
    Cell[347339, 19450, 260, 9, 70, "MathCaption",
      CellTags->{"S5.65.1", "1.34"}]},
  "1.35"->{
    Cell[382987, 21664, 450, 9, 70, "Text",
      CellTags->{"S5.65.1", "1.35"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.65.1", 418178, 22641},
  {"1.1", 425873, 22835},
  {"1.2", 425967, 22838},
  {"1.3", 426059, 22841},
  {"1.4", 426154, 22844},
  {"1.5", 426250, 22847},
  {"1.6", 426348, 22850},
  {"1.7", 426442, 22853},
  {"1.8", 426540, 22856},
  {"1.9", 426639, 22859},
  {"1.10", 426735, 22862},
  {"1.11", 426832, 22865},
  {"1.12", 426927, 22868},
  {"1.13", 427023, 22871},
  {"1.14", 427119, 22874},
  {"1.15", 427215, 22877},
  {"1.16", 427310, 22880},
  {"1.17", 427405, 22883},
  {"1.18", 427501, 22886},
  {"1.19", 427597, 22889},
  {"1.20", 427694, 22892},
  {"1.21", 427796, 22895},
  {"1.22", 427892, 22898},
  {"1.23", 427989, 22901},
  {"1.24", 428086, 22904},
  {"1.25", 428182, 22907},
  {"1.26", 428284, 22910},
  {"1.27", 428380, 22913},
  {"1.28", 428477, 22916},
  {"1.29", 428580, 22919},
  {"1.30", 428676, 22922},
  {"1.31", 428772, 22925},
  {"1.32", 428869, 22928},
  {"1.33", 428971, 22931},
  {"1.34", 429073, 22934},
  {"1.35", 429175, 22937}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 139, 6, 36, "Subsection",
  CellTags->{"S5.65.1", "1.1"}],
Cell[1918, 61, 2407, 73, 124, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[4328, 136, 59, 1, 15, "Caption",
  CellTags->"S5.65.1"],
Cell[4390, 139, 1086, 28, 120, "Text",
  CellTags->{"S5.65.1", "1.2"}],
Cell[5479, 169, 78, 1, 40, "MathCaption",
  CellTags->{"S5.65.1", "1.3"}],
Cell[5560, 172, 89, 2, 28, "Input",
  CellTags->"S5.65.1"],
Cell[5652, 176, 146, 4, 40, "MathCaption",
  CellTags->{"S5.65.1", "1.4"}],

Cell[CellGroupData[{
Cell[5823, 184, 82, 2, 28, "Input",
  CellTags->"S5.65.1"],
Cell[5908, 188, 71885, 2770, 186, 33942, 2297, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"S5.65.1"],
Cell[77796, 2960, 96, 2, 25, "Output",
  CellTags->"S5.65.1"]
}, Open  ]],
Cell[77907, 2965, 152, 4, 70, "MathCaption",
  CellTags->{"S5.65.1", "1.5"}],

Cell[CellGroupData[{
Cell[78084, 2973, 94, 2, 70, "Input",
  CellTags->"S5.65.1"],
Cell[78181, 2977, 78895, 5430, 70, 78824, 5427, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S5.65.1"],
Cell[157079, 8409, 96, 2, 70, "Output",
  CellTags->"S5.65.1"]
}, Open  ]],
Cell[157190, 8414, 2180, 67, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[159373, 8483, 82, 1, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[159458, 8486, 1433, 38, 70, "Text",
  CellTags->{"S5.65.1", "1.6"}],
Cell[160894, 8526, 87, 1, 70, "MathCaption",
  CellTags->{"S5.65.1", "1.7"}],
Cell[160984, 8529, 222, 7, 70, "Input",
  CellTags->"S5.65.1"],
Cell[161209, 8538, 170, 4, 70, "MathCaption",
  CellTags->{"S5.65.1", "1.8"}],

Cell[CellGroupData[{
Cell[161404, 8546, 99, 2, 70, "Input",
  CellTags->"S5.65.1"],
Cell[161506, 8550, 26001, 1683, 70, 25930, 1680, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.65.1"],
Cell[187510, 10235, 96, 2, 70, "Output",
  CellTags->"S5.65.1"]
}, Open  ]],
Cell[187621, 10240, 1022, 18, 70, "Text",
  CellTags->{"S5.65.1", "1.9"}],
Cell[188646, 10260, 1037, 26, 70, "Text",
  CellTags->{"S5.65.1", "1.10"}],
Cell[189686, 10288, 1579, 42, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[191268, 10332, 53, 1, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[191324, 10335, 267, 6, 70, "Text",
  CellTags->{"S5.65.1", "1.11"}],
Cell[191594, 10343, 733, 23, 70, "Text",
  CellTags->{"S5.65.1", "1.12"}],
Cell[192330, 10368, 397, 11, 70, "Text",
  CellTags->{"S5.65.1", "1.13"}],
Cell[192730, 10381, 515, 12, 70, "Text",
  CellTags->{"S5.65.1", "1.14"}],
Cell[193248, 10395, 364, 7, 70, "Text",
  CellTags->{"S5.65.1", "1.15"}],
Cell[193615, 10404, 334, 9, 70, "Text",
  CellTags->{"S5.65.1", "1.16"}],
Cell[193952, 10415, 464, 13, 70, "Text",
  CellTags->{"S5.65.1", "1.17"}],
Cell[194419, 10430, 459, 11, 70, "Text",
  CellTags->{"S5.65.1", "1.18"}],
Cell[194881, 10443, 1197, 34, 70, "Text",
  CellTags->{"S5.65.1", "1.19"}],
Cell[196081, 10479, 203, 4, 70, "MathCaption",
  CellTags->{"S5.65.1", "1.20"}],

Cell[CellGroupData[{
Cell[196309, 10487, 140, 5, 70, "Input",
  CellTags->"S5.65.1"],
Cell[196452, 10494, 25613, 1745, 70, 25542, 1742, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.65.1"],
Cell[222068, 12241, 96, 2, 70, "Output",
  CellTags->"S5.65.1"]
}, Open  ]],
Cell[222179, 12246, 4719, 139, 70, "DefinitionBox3Col",
  CellTags->"S5.65.1"],
Cell[226901, 12387, 109, 5, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[227013, 12394, 14543, 428, 70, "DefinitionBox3Col",
  CellTags->"S5.65.1"],
Cell[241559, 12824, 184, 7, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[241746, 12833, 583, 16, 70, "Text",
  CellTags->{"S5.65.1", "1.21"}],
Cell[242332, 12851, 1831, 60, 70, "Text",
  CellTags->{"S5.65.1", "1.22"}],
Cell[244166, 12913, 1997, 66, 70, "Text",
  CellTags->{"S5.65.1", "1.23"}],
Cell[246166, 12981, 656, 14, 70, "Text",
  CellTags->{"S5.65.1", "1.24"}],
Cell[246825, 12997, 203, 4, 70, "MathCaption",
  CellTags->{"S5.65.1", "1.25"}],

Cell[CellGroupData[{
Cell[247053, 13005, 232, 8, 70, "Input",
  CellTags->"S5.65.1"],
Cell[247288, 13015, 31916, 2080, 70, 31845, 2077, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.65.1"],
Cell[279207, 15097, 96, 2, 70, "Output",
  CellTags->"S5.65.1"]
}, Open  ]],
Cell[279318, 15102, 918, 24, 70, "Text",
  CellTags->{"S5.65.1", "1.26"}],
Cell[280239, 15128, 2602, 86, 70, "Text",
  CellTags->{"S5.65.1", "1.27"}],
Cell[282844, 15216, 400, 10, 70, "MathCaption",
  CellTags->{"S5.65.1", "1.28"}],

Cell[CellGroupData[{
Cell[283269, 15230, 215, 7, 70, "Input",
  CellTags->"S5.65.1"],
Cell[283487, 15239, 54399, 3899, 70, 54328, 3896, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.65.1"],
Cell[337889, 19140, 96, 2, 70, "Output",
  CellTags->"S5.65.1"]
}, Open  ]],
Cell[338000, 19145, 913, 20, 70, "Text",
  CellTags->{"S5.65.1", "1.29"}],
Cell[338916, 19167, 829, 18, 70, "Text",
  CellTags->{"S5.65.1", "1.30"}],
Cell[339748, 19187, 3445, 107, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[343196, 19296, 129, 5, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[343328, 19303, 2224, 70, 70, "Text",
  CellTags->{"S5.65.1", "1.31"}],
Cell[345555, 19375, 143, 4, 70, "MathCaption",
  CellTags->{"S5.65.1", "1.32"}],

Cell[CellGroupData[{
Cell[345723, 19383, 85, 2, 70, "Input",
  CellTags->"S5.65.1"],
Cell[345811, 19387, 915, 32, 70, "Output",
  CellTags->"S5.65.1"]
}, Open  ]],
Cell[346741, 19422, 146, 4, 70, "MathCaption",
  CellTags->{"S5.65.1", "1.33"}],

Cell[CellGroupData[{
Cell[346912, 19430, 158, 6, 70, "Input",
  CellTags->"S5.65.1"],
Cell[347073, 19438, 251, 9, 70, "Output",
  CellTags->"S5.65.1"]
}, Open  ]],
Cell[347339, 19450, 260, 9, 70, "MathCaption",
  CellTags->{"S5.65.1", "1.34"}],

Cell[CellGroupData[{
Cell[347624, 19463, 154, 7, 70, "Input",
  CellTags->"S5.65.1"],
Cell[347781, 19472, 31998, 2086, 70, 31927, 2083, "GraphicsData", \
"PostScript", "Graphics",
  ImageCacheValid->False,
  CellTags->"S5.65.1"],
Cell[379782, 21560, 97, 2, 70, "Output",
  CellTags->"S5.65.1"]
}, Open  ]],
Cell[379894, 21565, 3021, 94, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[382918, 21661, 66, 1, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[382987, 21664, 450, 9, 70, "Text",
  CellTags->{"S5.65.1", "1.35"}],
Cell[383440, 21675, 3101, 83, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[386544, 21760, 117, 5, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[386664, 21767, 7720, 204, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[394387, 21973, 111, 5, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[394501, 21980, 2411, 65, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[396915, 22047, 117, 5, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[397035, 22054, 1059, 29, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[398097, 22085, 112, 5, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[398212, 22092, 7682, 204, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[405897, 22298, 109, 5, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[406009, 22305, 2725, 74, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[408737, 22381, 115, 5, 70, "Caption",
  CellTags->"S5.65.1"],
Cell[408855, 22388, 8570, 227, 70, "DefinitionBox",
  CellTags->"S5.65.1"],
Cell[417428, 22617, 111, 5, 70, "Caption",
  CellTags->"S5.65.1"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

