(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    126948,       2697]*)
(*NotebookOutlinePosition[    144461,       3148]*)
(*  CellTagsIndexPosition[    143382,       3113]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "A definite integral ",
  StyleBox["(TraditionalForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Definite Integral", "G.1.1"}],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{\(\[Integral]\_0\%1\(\(\( log\^16\)(
                    t)\)\/\@\(1 - t\^2\)\) \[DifferentialD]t\), " ", "=", 
          
          RowBox[{\(\(1\/131072\) \[Pi]\ \(\(log\^16\)(4)\)\), 
            "+", \(\(5\/16384\) \[Pi]\^3\ \(\(log\^14\)(4)\)\), "+", 
            RowBox[{\(105\/2048\), "\[Pi]", " ", \(\(log\^13\)(4)\), " ", 
              TagBox[
                RowBox[{"\[Zeta]", "(", 
                  TagBox["3",
                    (Editable -> True)], ")"}],
                InterpretTemplate[ Zeta[ #]&]]}], 
            "+", \(\(1729\/98304\) \[Pi]\^5\ \(\(log\^12\)(4)\)\), "+", 
            RowBox[{\(1365\/1024\), \(\(log\^11\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{\(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"18", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(715\/49152\), \(\(log\^10\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{\(55\ \[Pi]\^7\), "+", 
                  RowBox[{"6048", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}]}], ")"}]}], 
            "+", 
            RowBox[{\(5005\/2048\), \(\(log\^9\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"19", " ", \(\[Pi]\^5\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"180", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"3240", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(143\/65536\), \(\(log\^8\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{\(11813\ \[Pi]\^9\), "+", 
                  RowBox[{"604800", " ", \(\[Pi]\^3\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"21772800", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(2145\/512\), \(\(log\^7\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"275", " ", \(\[Pi]\^7\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"10080", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "3"]}], "+", 
                  RowBox[{"2394", " ", \(\[Pi]\^5\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"22680", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"428400", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(4095\/16384\), \(\(log\^6\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{\(2117\ \[Pi]\^11\), "+", 
                  RowBox[{"93632", " ", \(\[Pi]\^5\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"1774080", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"15966720", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["5",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"31933440", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(3003\/2048\), \(\(log\^5\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"11813", " ", \(\[Pi]\^9\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"201600", " ", \(\[Pi]\^3\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "3"]}], "+", 
                  RowBox[{"99000", " ", \(\[Pi]\^7\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"10886400", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"861840", " ", \(\[Pi]\^5\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"8568000", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"168739200", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["11",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(3\/32768\), \(\(log\^4\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{\(64604977\ \[Pi]\^13\), "+", 
                  RowBox[{"2642640000", " ", \(\[Pi]\^7\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"48432384000", " ", "\[Pi]", "  ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "4"]}], "+", 
                  RowBox[{"46010764800", " ", \(\[Pi]\^5\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"217945728000", " ", \(\[Pi]\^3\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["5",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"435891456000", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"7846046208000", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"8233505280000", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(4095\/1024\), \(\(log\^3\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"31755", " ", \(\[Pi]\^11\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"468160", " ", \(\[Pi]\^5\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "3"]}], "+", 
                  RowBox[{"259886", " ", \(\[Pi]\^9\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"13305600", " ", \(\[Pi]\^3\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"239500800", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["5",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"2178000", " ", \(\[Pi]\^7\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"239500800", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"19896800", " ", \(\[Pi]\^5\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"206236800", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["11",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"4191264000", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["13",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(5\/49152\), \(\(log\^2\)(4)\), " ", 
              RowBox[{"(", 
                RowBox[{\(263101079\ \[Pi]\^15\), "+", 
                  RowBox[{"10216638432", " ", \(\[Pi]\^9\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"87178291200", " ", \(\[Pi]\^3\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "4"]}], "+", 
                  RowBox[{"171243072000", " ", \(\[Pi]\^7\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"6276836966400", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "3"], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"745374389760", " ", \(\[Pi]\^5\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["5",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"1490748779520", " ", \(\[Pi]\^5\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"14122883174400", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"127105948569600", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["7",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"14820309504000", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"266765571072000", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"291872918937600", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["11",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(9\/2048\), \(log(4)\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"64604977", " ", \(\[Pi]\^13\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"880880000", " ", \(\[Pi]\^7\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "3"]}], "+", 
                  RowBox[{"9686476800", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "5"]}], "+", 
                  RowBox[{"520146900", " ", \(\[Pi]\^11\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"23005382400", " ", \(\[Pi]\^5\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"217945728000", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["5",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"1307674368000", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["5",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "3"]}], "+", 
                  RowBox[{"4256932680", " ", \(\[Pi]\^9\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"217945728000", " ", \(\[Pi]\^3\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"7846046208000", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"37437400000", " ", \(\[Pi]\^7\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"4116752640000", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"356583427200", " ", \(\[Pi]\^5\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["11",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"3814050240000", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["13",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"79346774707200", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["15",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}], "+", 
            RowBox[{\(7\/6684672\), 
              RowBox[{"(", 
                RowBox[{\(19449462373\ \[Pi]\^17\), "+", 
                  RowBox[{"727611206400", " ", \(\[Pi]\^11\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"5363540582400", " ", \(\[Pi]\^5\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "4"]}], "+", 
                  RowBox[{"11909681372160", " ", \(\[Pi]\^9\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"203249958912000", " ", \(\[Pi]\^3\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "3"], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"49905123840000", " ", \(\[Pi]\^7\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["5",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"5487748890624000", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"], " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["5",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"99810247680000", " ", \(\[Pi]\^7\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"3658499260416000", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["3",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "3"], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"868893574348800", " ", \(\[Pi]\^5\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"4115811667968000", " ", \(\[Pi]\^3\), " ", 
                    SuperscriptBox[
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["7",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "2"]}], "+", 
                  RowBox[{"911801899008000", " ", \(\[Pi]\^5\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"8638123253760000", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"155486218567680000", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["7",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["9",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"9451123089408000", " ", \(\[Pi]\^3\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["11",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"170120215609344000", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["11",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"192071211171840000", " ", "\[Pi]", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]], " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["13",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}]}]}],
        HoldForm], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  LineBreakWithin->Automatic,
  FontSize->10,
  FontWeight->"Plain",
  CellTags->{"Definite Integral", "G.1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "A Pisot number ",
  StyleBox["(TraditionalForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Pisot Number", "G.1.2"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(\((\@\(2\/\(27 + 3 \@ 69\)\)\%3 + \(1\/3\) \@\(\(27 + 3 \@ \
69\)\/2\)\%3)\)\^30000\),
          FontSize->12], 
        RowBox[{
          StyleBox["=",
            FontSize->12], 
          "5043165960656654932150594692427574810776102746808935031678444677128\
757182264862106103980765819340682753857825408213309478700354777871766946859877\
182545765655157863751804030841080877201973602630453775992992526007874643437115\
478340662656654242263167137970470876460028676595720882553729941413991192954257\
293905515987341623164931728987789298548218169139563816353624128215994510253193\
649036511102215152338143645279048930913371354240272588991921619868232355282955\
810598732001078755504975632193024344987469732081489429513875050815089544676150\
938253329884107629370887783660465530686857728553866459504826468144393019990165\
743377364065922255679117090517971285490773119127788881441087366597038621740186\
411069175749952023659419640302178959561265901520782425747790756781859047252118\
783439795010489532686142903402653847407905146487735500216875475845252225041904\
360870681078279227104457227362368796693241733784161166959198410304677682964919\
409043870523002732003770237480443431032331691094261441144380298348751920199059\
562790511888049750265002682883521913896858496289686123578807667253851478579344\
449553914415375194372851217961223158428624231899492121175279814486360858048056\
575120864817906982359465546791033345570306144306889182376593558188718231183977\
511187240921162728629126713811608658037408930071516876158725341127622968866605\
210362611399728215256794224599912431852531227205445323135206226637942724364187\
507359956181911218068991795777326796261608752343775804668422381361446090681588\
594231684449905631308569143981611046414359764645058273105320423572778055041510\
761287441331660970400343561555943556993103725670073628460112439243800517211794\
664815158651771479160942653186737535761672899827891567658199185014614703946969\
879000550578218043674277377855307965292573100704405035528657706565889113413367\
817192934796097513499651992416721568858204193236978264956752167858467613016650\
514975083735547048453768089171065791820462966374091485132898737129287935143459\
175813721830821381768374444936696984757491555027227218191496737306894525429493\
301724974763488028789233809728809898199416269816627876644539316701546354316106\
609944787820220498246818854200290468467630982622988930679820858730060272235476\
735450044805739148100924911019338705887449906544811444564378814239220572668180\
278032797347013668175334692909590627108897158421082548983131341387676127885490\
486578249126248836394203188792652324856135704773997090467104480778132423835257\
758424180335745170573652705419795069195190885851098538390625498507467309419611\
165780838698713310344086360548451070819222570296482527242703056995074918767257\
414142822271890334717277643954342541859509907472906259527629621846811719367901\
786024179895120064929613306517810763374494997293082055502432076618464586027616\
119815676773736360189991491957175057346133494837930827478266538261093888716461\
076377076699523221210638410121119502728028192147321213391939138517117401805454\
360045347532235299958021923292027677884065299422286086252105068056807793476844\
454728320229479895050738642250650424537785366800824269336818816623176949556726\
361708670651772685686418825606961363993789380923630615342066499106771216678307\
265280650651154307878220861870678168941097431704060159606780139617770602048383\
255107304641825616786778667766641145888295077288459709643465468572600850673752\
055883218340619680664771369547546505826597221827875270380133508853607738471589\
700951963694066449868459559318968227624570572944412896668467196250357904359310\
094303613350580572837195254247505334922434012206891543167881708739008884991490\
588279135076804550682803394454230822114888818737649635439941364151152126830053\
340927532304714488156842955217262531239581967894186558682010795291845929630207\
675781253.\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000013089481144651747951"}]}], 
      TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  LineIndent->0,
  FontWeight->"Plain",
  CellTags->{"Pisot Number", "G.1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Product of two five-dimensional totally antisymmetric tensors ",
  StyleBox["(StandardForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Antisymmetric Tensors", "G.1.3"}],

Cell[BoxData[
    TagBox[\(\[CurlyEpsilon]\_\(\[Alpha]\[InvisibleComma]\[Beta]\
\[InvisibleComma]\[Rho]\[InvisibleComma]\[Sigma]\[InvisibleComma]\[Tau]\)\ \
\[CurlyEpsilon]\_\(\[Kappa]\[InvisibleComma]\[Lambda]\[InvisibleComma]\[Mu]\
\[InvisibleComma]\[Nu]\[InvisibleComma]\[Xi]\)\  = \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Kappa]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Kappa]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Kappa]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Kappa]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Kappa]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Kappa]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Kappa]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Kappa]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Kappa]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Kappa]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Lambda]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Lambda]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Lambda]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Lambda]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Lambda]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Lambda]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Lambda]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Lambda]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Lambda]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Mu]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\
\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Mu]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Mu]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\
\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Mu]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Mu]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Mu]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Mu]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Mu]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Mu]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Nu]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\
\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Nu]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Nu]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\
\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Nu]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Nu]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Nu]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Nu]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Nu]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Xi]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Xi]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Nu]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Xi]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\
\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Xi]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Xi]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\
\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Xi]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Xi]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) + \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Xi]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Mu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) - \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Xi]\) + \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) - \
\[Delta]\_\(\[Alpha]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Rho]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\
\[InvisibleComma]\[Xi]\) - \[Delta]\_\(\[Alpha]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Beta]\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Rho]\
\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\[InvisibleComma]\[Nu]\)\ \
\[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\) + \[Delta]\_\(\[Alpha]\
\[InvisibleComma]\[Kappa]\)\ \[Delta]\_\(\[Beta]\[InvisibleComma]\[Lambda]\)\ \
\[Delta]\_\(\[Rho]\[InvisibleComma]\[Mu]\)\ \[Delta]\_\(\[Sigma]\
\[InvisibleComma]\[Nu]\)\ \[Delta]\_\(\[Tau]\[InvisibleComma]\[Xi]\)\),
      HoldForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  LineSpacing->{1.55, 0},
  LineIndent->0,
  FontWeight->"Roman",
  CellTags->{"Antisymmetric Tensors", "G.1.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Trigonometric formulas ",
  StyleBox["(TraditionalForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Trigonometric Formulas", "G.1.4"}],

Cell[BoxData[
    FormBox[
      TagBox[\(\(-\(\(sin(\[Pi]\/7)\)\/\(\(sin\^2\)(\(2\ \[Pi]\)\/7)\)\)\) + \
\(sin(\(3\ \[Pi]\)\/7)\)\/\(\(sin\^2\)(\[Pi]\/7)\) + \(sin(\(2\ \[Pi]\)\/7)\)\
\/\(\(sin\^2\)(\(3\ \[Pi]\)\/7)\) = 2\ \@7\),
        HoldForm], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontSize->10,
  FontWeight->"Plain",
  CellTags->{"Trigonometric Formulas", "G.1.4"}],

Cell[BoxData[
    FormBox[
      TagBox[\(\(\(sin\^2\)(\[Pi]\/7)\)\/\(\(sin\^4\)(\(2\ \[Pi]\)\/7)\) + \(\
\(sin\^2\)(\(3\ \[Pi]\)\/7)\)\/\(\(sin\^4\)(\[Pi]\/7)\) + \(\(sin\^2\)(\(2\ \
\[Pi]\)\/7)\)\/\(\(sin\^4\)(\(3\ \[Pi]\)\/7)\) = 28\),
        HoldForm], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontSize->10,
  FontWeight->"Plain",
  CellTags->{"Trigonometric Formulas", "G.1.4"}],

Cell[BoxData[
    FormBox[
      TagBox[\(\(\(\(\(sin\^2\)(\[Pi]\/7)\)\/\(\(sin\^4\)(\(2\ \
\[Pi]\)\/7)\)\) \((\(4\ \(sin(\[Pi]\/7)\)\)\/\(sin(\(2\ \[Pi]\)\/7)\) - \(2\ \
\(sin(\(3\ \[Pi]\)\/7)\)\)\/\(sin(\[Pi]\/7)\))\)\(\ \)\) + \
\(\(\(\(sin\^2\)(\(3\ \[Pi]\)\/7)\)\/\(\(sin\^4\)(\[Pi]\/7)\)\) \((\(2\ \
\(sin(\(2\ \[Pi]\)\/7)\)\)\/\(sin(\(3\ \[Pi]\)\/7)\) + \(4\ \(sin(\(3\ \
\[Pi]\)\/7)\)\)\/\(sin(\[Pi]\/7)\))\)\(\ \)\) - \(\(\(\(sin\^2\)(\(2\ \[Pi]\)\
\/7)\)\(\ \)\)\/\(\(sin\^4\)(\(3\ \[Pi]\)\/7)\)\) \((\(2\ \(sin(\[Pi]\/7)\)\)\
\/\(sin(\(2\ \[Pi]\)\/7)\) + \(4\ \(sin(\(2\ \[Pi]\)\/7)\)\)\/\(sin(\(3\ \
\[Pi]\)\/7)\))\) = 280\),
        HoldForm], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontSize->10,
  FontWeight->"Plain",
  CellTags->{"Trigonometric Formulas", "G.1.4"}],

Cell[BoxData[
    FormBox[
      TagBox[\(cos(\[Pi]\/17) = \(1\/8\) \@\(2\ \((2\ \@\(\@\(\(\ \)\(\(17 \
\((17 - \@17)\)\)\/2\)\) - \@\(\(17 - \@17\)\/2\) - 4\ \@\(34 + 2\ \@17\) + 3\
\ \@17 + 17\) + \@\(34 - 2\ \@17\) + \@17 + 15)\)\)\),
        HoldForm], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontSize->10,
  FontWeight->"Plain",
  CellTags->{"Trigonometric Formulas", "G.1.4"}],

Cell[BoxData[
    FormBox[
      TagBox[\(tan(\[Pi]\/120) = \@\(\(8 - \@\(2\ \((2 - \@3)\)\ \((3 - \
\@5)\)\) - \@\(2\ \((2 + \@3)\)\ \((5 + \@5)\)\)\)\/\(8 + \@\(2\ \((2 - \
\@3)\)\ \((3 - \@5)\)\) + \@\(2\ \((2 + \@3)\)\ \((5 + \@5)\)\)\)\)\),
        HoldForm], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontSize->10,
  FontWeight->"Plain",
  CellTags->{"Trigonometric Formulas", "G.1.4"}],

Cell[BoxData[
    FormBox[
      TagBox[\(cos(\[Pi]\/240) = 
          1\/16\ \((\@\(2 - \@\(2 + \@2\)\)\ \((\@\(2\ \((5 + \@5)\)\) + \@3 \
- \@15)\) + \@\(\@\(2 + \@2\) + 2\)\ \((\@\(6\ \((5 + \@5)\)\) + \@5 - 
                      1)\))\)\),
        HoldForm], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontSize->10,
  FontWeight->"Plain",
  CellTags->{"Trigonometric Formulas", "G.1.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            TagBox[\(\[Pi]\/4 = \(cot\^\(-1\)\)(2) + \(cot\^\(-1\)\)(3)\),
              HoldForm], 
            
            TagBox[\(\[Pi]\/4 = \(cot\^\(-1\)\)(2) + \(cot\^\(-1\)\)(
                    5) + \(cot\^\(-1\)\)(8)\),
              HoldForm]},
          {
            
            TagBox[\(\[Pi]\/4 = 
                2 \(\( cot\^\(-1\)\)(3)\) + \(cot\^\(-1\)\)(7)\),
              HoldForm], 
            
            TagBox[\(\[Pi]\/4 = 
                3 \(\( cot\^\(-1\)\)(4)\) + \(cot\^\(-1\)\)(99\/5)\),
              HoldForm]},
          {
            
            TagBox[\(\[Pi]\/4 = 
                4 \(\( cot\^\(-1\)\)(5)\) - \(cot\^\(-1\)\)(239)\),
              HoldForm], 
            
            TagBox[\(\[Pi]\/4 = 
                4 \(\( cot\^\(-1\)\)(5)\) - \(cot\^\(-1\)\)(
                    70) + \(cot\^\(-1\)\)(99)\),
              HoldForm]},
          {
            
            TagBox[\(\[Pi]\/4 = 
                5 \(\( cot\^\(-1\)\)(6)\) - \(cot\^\(-1\)\)(
                    503\/16) - \(cot\^\(-1\)\)(117)\),
              HoldForm], 
            
            TagBox[\(\[Pi]\/4 = 
                5 \(\( cot\^\(-1\)\)(7)\) + 2 \(\( cot\^\(-1\)\)(79\/3)\)\),
              HoldForm]},
          {
            
            TagBox[\(\[Pi]\/4 = 
                6 \(\( cot\^\(-1\)\)(8)\) + \(cot\^\(-1\)\)(99\/5) - 
                  3 \(\( cot\^\(-1\)\)(268)\)\),
              HoldForm], 
            TagBox[
              
              TagBox[\(\[Pi]\/4 = 
                  8\ \(\(cot\^\(-1\)\)(10)\) - \(cot\^\(-1\)\)(239) - 
                    4\ \(\(cot\^\(-1\)\)(515)\)\),
                HoldForm],
              HoldForm]},
          {
            
            TagBox[\(\[Pi]\/4 = 
                8 \(\( cot\^\(-1\)\)(10)\) - 
                  2 \(\( cot\^\(-1\)\)(452761\/2543)\) - \(cot\^\(-1\)\)(
                    1393)\),
              HoldForm], 
            
            TagBox[\(\[Pi]\/4 = 
                8 \(\( cot\^\(-1\)\)(10)\) - \(cot\^\(-1\)\)(
                    100) - \(cot\^\(-1\)\)(515) - \(cot\^\(-1\)\)(
                    371498882\/3583)\),
              HoldForm]},
          {
            
            TagBox[\(\[Pi]\/4 = 
                12 \(\( cot\^\(-1\)\)(18)\) + 3 \(\( cot\^\(-1\)\)(70)\) + 
                  5 \(\( cot\^\(-1\)\)(99)\) + 8 \(\( cot\^\(-1\)\)(307)\)\),
              HoldForm], 
            
            TagBox[\(\[Pi]\/4 = 
                12 \(\( cot\^\(-1\)\)(18)\) + 8 \(\( cot\^\(-1\)\)(99)\) + 
                  3 \(\( cot\^\(-1\)\)(239)\) + 8 \(\( cot\^\(-1\)\)(307)\)\),
              
              HoldForm]}
          }], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontSize->11,
  FontWeight->"Plain",
  GridBoxOptions->{ColumnSpacings->2,
  ColumnAlignments->{Left}},
  CellTags->{"Trigonometric Formulas", "G.1.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Some definite integrals ",
  StyleBox["(TraditionalForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{\(\[Integral]\_0\%1\(\(\( log\^3\)(
                  x)\)\ \@\(1 - x\)\) \[DifferentialD]x\), "=", 
          RowBox[{\(-\(2\/27\)\), " ", 
            RowBox[{"(", 
              RowBox[{
              "640", "-", \(24\ \[Pi]\^2\), "-", \(312\ \(log(4)\)\), 
                "+", \(9\ \[Pi]\^2\ \(log(4)\)\), 
                "+", \(72\ \(\(log\^2\)(4)\)\), "-", \(9\ \(\(log\^3\)(4)\)\),
                 "-", 
                RowBox[{"108", " ", 
                  TagBox[
                    RowBox[{"\[Zeta]", "(", 
                      TagBox["3",
                        (Editable -> True)], ")"}],
                    InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}]}],
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Plain",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{\(\[Integral]\_0\%1\(\(\( sin\^\(-1\)\)(x)\)\^5\/x\) \
\[DifferentialD]x\), "=", 
          RowBox[{\(\(\(\ \)\(\[Pi]\)\)\/64\), " ", 
            StyleBox[
              RowBox[{"(", 
                RowBox[{\(2\ \[Pi]\^4\ \(log(2)\)\), "-", 
                  RowBox[{"30", " ", \(\[Pi]\^2\), " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["3",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}], "+", 
                  RowBox[{"225", " ", 
                    TagBox[
                      RowBox[{"\[Zeta]", "(", 
                        TagBox["5",
                          (Editable -> True)], ")"}],
                      InterpretTemplate[ Zeta[ #]&]]}]}], ")"}],
              SpanMaxSize->Automatic]}]}],
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  SpanMaxSize->Infinity,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      TagBox[\(\[Integral]\_0\%1\( 
                  1\/\(\(x\)\(\ \)\)\^2\) \(\((\(1\/x\) \(log(\(1 + x\)\/\(1 \
- x\))\) - 2)\)\^2\) \[DifferentialD]x = \(2\/9\) \((\[Pi]\^2\  - \ 6)\)\),
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        TagBox[\(\(\[Integral]\_0\%\[Infinity]\( 
                    1\/\((x\^2 + 2\ y\ \(cos(t)\)\ x + y\^2)\)\^2\) \
\[DifferentialD]y\)\(=\)\),
          HoldForm], \(1\/\(4  x\^3\)\), 
        " ", \(\(csc\^3\)(
          t)\), \((2 \(\( tan\^\(-1\)\)(tan(t\/2))\) + \(tan\^\(-1\)\)(
              tan(t)) - sin(2  t))\)}], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{\(\[Integral]\_0\%\(\[Pi]\/2\)\((\(log(
                      sin(x))\)\ x\^2 + \(log(
                      cos(x))\)\ x)\) \[DifferentialD]x\), "=", 
          RowBox[{\(1\/48\), " ", 
            RowBox[{"(", 
              
              RowBox[{\(\(-6\)\ \[Pi]\^2\ \(log(2)\)\), 
                "-", \(\[Pi]\^3\ \(log(4)\)\), "-", 
                RowBox[{"21", " ", 
                  TagBox[
                    RowBox[{"\[Zeta]", "(", 
                      TagBox["3",
                        (Editable -> True)], ")"}],
                    InterpretTemplate[ Zeta[ #]&]]}], "+", 
                RowBox[{"9", " ", "\[Pi]", " ", 
                  TagBox[
                    RowBox[{"\[Zeta]", "(", 
                      TagBox["3",
                        (Editable -> True)], ")"}],
                    InterpretTemplate[ Zeta[ #]&]]}]}], ")"}]}]}],
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            
            TagBox[\(\[Integral]\_0\%1\(\@\( 1 - x\)\ \(cos(
                        2\ x)\)\ \[ExponentialE]\^x\) \[DifferentialD]x = 
                1\/100\ \[ImaginaryI]\ \(\(\[ExponentialE]\^\(\(-2\) \
\[ImaginaryI]\)\)\((\)\(\(20  \[ImaginaryI]\ \[ExponentialE]\^\(2  \
\[ImaginaryI]\)\)\(+\)\)\)\),
              
              HoldForm], \((4 + 
                3  \[ImaginaryI])\), \(\@\(1 - 2  \[ImaginaryI]\)\), 
            "\[ExponentialE]", \(\@\[Pi]\), \(erf(\@\(1 - 2  \[ImaginaryI]\))\
\)}], "-", \(\((4 - 
                3  \[ImaginaryI])\) \(\@\(1 + 
                  2  \[ImaginaryI]\)\) \(\[ExponentialE]\^\(1 + 
                  4  \[ImaginaryI]\)\) \(\@\[Pi]\) \(erf(\@\(1 + 2  \
\[ImaginaryI]\))\)\)}], ")"}], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{\(\[Integral]\_0\%\[Infinity]\(\(\( J\_2\)(x)\)\^2\ \
\[ExponentialE]\^\(-x\)\) \[DifferentialD]x\), "=", 
          RowBox[{\(3\/8\), " ", 
            TagBox[
              RowBox[{\(\(\(\[ThinSpace]\)\(\_2\)\) F\_1\), "(", 
                RowBox[{
                  RowBox[{
                    TagBox[\(5\/2\),
                      (Editable -> True)], ",", 
                    TagBox[\(5\/2\),
                      (Editable -> True)]}], ";", 
                  TagBox["5",
                    (Editable -> True)], ";", 
                  TagBox[\(-4\),
                    (Editable -> True)]}], ")"}],
              InterpretTemplate[ Hypergeometric2F1[ #, #2, #3, #4]&]]}]}],
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{\(\[Integral]\_0\%\[Infinity]\( \[ExponentialE]\^\(-x\^3\)\ \
\(sin(x)\)\) \[DifferentialD]x\), "=", 
          RowBox[{
            RowBox[{\(1\/3\), " ", \(\[CapitalGamma](2\/3)\), " ", 
              TagBox[
                RowBox[{\(\(\(\[ThinSpace]\)\(\_0\)\) F\_3\), "(", 
                  RowBox[{
                    TagBox[
                      InterpretationBox["\[InvisibleSpace]",
                        {}],
                      (Editable -> False)], ";", 
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[\(1\/2\),
                            (Editable -> True)], ",", 
                          TagBox[\(2\/3\),
                            (Editable -> True)], ",", 
                          TagBox[\(7\/6\),
                            (Editable -> True)]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      (Editable -> False)], ";", 
                    TagBox[\(-\(1\/11664\)\),
                      (Editable -> True)]}], ")"}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&]]}], "-", 
            RowBox[{\(1\/54\), " ", \(\[CapitalGamma](1\/3)\), " ", 
              TagBox[
                RowBox[{\(\(\(\[ThinSpace]\)\(\_0\)\) F\_3\), "(", 
                  RowBox[{
                    TagBox[
                      InterpretationBox["\[InvisibleSpace]",
                        {}],
                      (Editable -> False)], ";", 
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[\(5\/6\),
                            (Editable -> True)], ",", 
                          TagBox[\(4\/3\),
                            (Editable -> True)], ",", 
                          TagBox[\(3\/2\),
                            (Editable -> True)]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      (Editable -> False)], ";", 
                    TagBox[\(-\(1\/11664\)\),
                      (Editable -> True)]}], ")"}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&]]}], "+", 
            RowBox[{\(1\/360\), " ", 
              TagBox[
                RowBox[{\(\(\(\[ThinSpace]\)\(\_1\)\) F\_4\), "(", 
                  RowBox[{
                    TagBox[
                      TagBox[
                        TagBox["1",
                          (Editable -> True)],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      (Editable -> False)], ";", 
                    TagBox[
                      TagBox[
                        RowBox[{
                          TagBox[\(7\/6\),
                            (Editable -> True)], ",", 
                          TagBox[\(4\/3\),
                            (Editable -> True)], ",", 
                          TagBox[\(5\/3\),
                            (Editable -> True)], ",", 
                          TagBox[\(11\/6\),
                            (Editable -> True)]}],
                        InterpretTemplate[ {
                          SlotSequence[ 1]}&]],
                      (Editable -> False)], ";", 
                    TagBox[\(-\(1\/11664\)\),
                      (Editable -> True)]}], ")"}],
                InterpretTemplate[ HypergeometricPFQ[ #, #2, #3]&]]}]}]}],
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{\(\[Integral]\_0\%\[Infinity]\( \[ExponentialE]\^\(\(-x\)\ \
\(sinh(u)\)\)\ \(\(J\_m\)(x)\)\) \[DifferentialD]x\), "=", 
          RowBox[{"If", "[", 
            RowBox[{\(Re[m] > \(-1\)\[Wedge]Re[sinh(u)] > 0\), ",", " ", 
              
              RowBox[{\(-\(\(\(2\)\(\ \)\(\[ExponentialE]\^u\)\(\ \)\(\((\(\
\[ExponentialE]\^u\)(
                                1 - \[ExponentialE]\^\(\(-2\) u\)))\)\^\(-m\)\
\)\(\ \)\)\/\(1 - \[ExponentialE]\^\(2\ u\)\)\)\), 
                TagBox[
                  RowBox[{\(\(\(\[ThinSpace]\)\(\_2\)\) F\_1\), 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          TagBox[\(\(m\/2\)\(+\)\),
                            (Editable -> True)], 
                          TagBox[\(1\/2\),
                            (Editable -> True)]}], ",", 
                        RowBox[{
                          TagBox[\(m\/2 + 1\),
                            (Editable -> True)], ";", 
                          TagBox[\(m + 1\),
                            (Editable -> True)], ";", 
                          
                          TagBox[\(-\(\(4\ \[ExponentialE]\^\(\(-2\)\ u\)\)\/\
\((1 - \[ExponentialE]\^\(\(-2\)\ u\))\)\^2\)\),
                            (Editable -> True)]}]}], ")"}]}],
                  InterpretTemplate[ Hypergeometric2F1[ #, #2, #3, #4]&]]}], 
              ",", 
              RowBox[{
                SubsuperscriptBox["\[Integral]", "0", 
                  InterpretationBox["\[Infinity]",
                    DirectedInfinity[ 
                    1]]], \(\(\[ExponentialE]\^\(\(-x\)\ \(sinh(u)\)\)\ \(\(J\
\_m\)(x)\)\) \[DifferentialD]x\)}]}], "]"}]}],
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      TagBox[\(\[Integral]\_0\%\[Infinity]\(\( Ai(x)\)\^2\ \
\(Ai(\(-x\))\)\^2\) \[DifferentialD]x = 1\/\(24\ \[Pi]\)\),
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}],

Cell[BoxData[
    FormBox[
      TagBox[\(\[Integral]\_0\%\[Infinity]\( 
                t\ \(\(Y\_0\)(t)\)\ \(\(J\_0\)(t)\)\ \(\(I\_2\)(
                  t)\)\ \(\(K\_2\)(
                  t)\)\) \[DifferentialD]t = \(1\/\(8  \[Pi]\)\) \((16 \( log(
                    2)\) + \[Pi] - 8)\)\),
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{15.875, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"More Definite Integrals", "G.1.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Generating functions for partitions ",
  StyleBox["(StandardForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Partitions", "G.1.6"}],

Cell[BoxData[
    \(\[Product]\+\(n = 1\)\%\[Infinity]\((1 - 
            x\^n)\) = \(\[Sum]\+\(k = \
\(-\[Infinity]\)\)\%\[Infinity]\((\(-1\))\)\^k\ x\^\(\(3  k\^2 + k\)\/2\)\
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \(\[Product]\+\(n = 1\)\%\[Infinity]\((1 \
- x\^n)\)\^3\) = \[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\((4  k + 
                1)\)\ x\^\(2  k\^2 + k\)\)\)], "Input",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  UnderoverscriptBoxOptions->{LimitsPositioning->True},
  CellTags->{"Partitions", "G.1.6"}],

Cell[BoxData[
    RowBox[{
      StyleBox[
        FractionBox[
          RowBox[{
            StyleBox[\(\[Product]\+\(n = 1\)\%\[Infinity]\),
              SpanMaxSize->1,
              UnderoverscriptBoxOptions->{LimitsPositioning->False}], 
            StyleBox[\(\((1 - x\^n)\)\^2\),
              UnderoverscriptBoxOptions->{LimitsPositioning->False}]}], 
          
          StyleBox[\(\[Product]\+\(n = 1\)\%\[Infinity]\((1 - 
                  x\^\(2  n\))\)\),
            UnderoverscriptBoxOptions->{LimitsPositioning->False}]],
        UnderscriptBoxOptions->{LimitsPositioning->True}], "=", 
      RowBox[{
        RowBox[{\(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\), 
          
          RowBox[{\(\((\(-1\))\)\^k\), " ", \(x\^\(k\^2\)\), "                    ",
             
            FractionBox[
              StyleBox[
                RowBox[{
                  UnderoverscriptBox[
                    StyleBox["\[Product]",
                      SpanMinSize->1], \(n = 1\), 
                    "\[Infinity]"], \(\((1 - x\^\(2\ n\))\)\^2\)}],
                SpanMaxSize->1,
                UnderoverscriptBoxOptions->{LimitsPositioning->False}], 
              StyleBox[\(\[Product]\+\(n = 1\)\%\[Infinity]\((1 - x\^n)\)\),
                UnderoverscriptBoxOptions->{LimitsPositioning->False}]]}]}], 
        "=", \(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity] x\^\(2\ k\^2 + k\
\)\)}]}]], "Input",
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  UnderoverscriptBoxOptions->{LimitsPositioning->True},
  CellTags->{"Partitions", "G.1.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Surface area of an ellipsoid ",
  StyleBox["(StandardForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Ellipsoid Surface Area", "G.1.7"}],

Cell[BoxData[
    TagBox[
      RowBox[{
        TagBox[\(\[Integral]\_0\%\(2\ \[Pi]\)\(\[Integral]\_0\%\[Pi]\( 
                    Sin[\[Theta]]\ \@\(b\^2\ c\^2\ Sin[\[Theta]]\^2\ Cos[\
\[Phi]]\^2 + a\^2\ c\^2\ Sin[\[Theta]]\^2\ Sin[\[Phi]]\^2 + a\^2\ b\^2\ Cos[\
\[Theta]]\^2\)\) \[DifferentialD]\[Theta] \[DifferentialD]\[Phi]\)\),
          HoldForm], 
        "=", \(2\ \[Pi]\ \((c\^2 + \(b\ c\^2\)\/\@\(a\^2 - c\^2\)\ EllipticF[\
\[Theta], m] + b\ \@\(a\^2 - c\^2\)\ EllipticE[\[Theta], m])\)\)}],
      HoldForm]], "Output",
  CellMargins->{{24.625, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  CellTags->{"Ellipsoid Surface Area", "G.1.7"}],

Cell[BoxData[
    TagBox[\(m = \(a\^2\ \((b\^2 - c\^2)\)\)\/\(b\^2\ \((a\^2 - c\^2)\)\); \
\[Theta] = 
        ArcSin[\@\(1 - c\^2\/a\^2\)] /; 
          a \[GreaterEqual] b \[GreaterEqual] c\),
      HoldForm]], "Output",
  CellMargins->{{15.625, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  CellTags->{"Ellipsoid Surface Area", "G.1.7"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Iterated radical identities ",
  StyleBox["(StandardForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Iterated Radical Identities", "G.1.8"}],

Cell[BoxData[
    TagBox[\(\@\(6 + \@\(6 + \@\(6 + \@\(6 + \@\(6 + \@\(6 + \@\(6 + \
\[Ellipsis]\)\)\)\)\)\)\) = 3\),
      HoldForm]], "Output",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  CellTags->{"Iterated Radical Identities", "G.1.8"}],

Cell[BoxData[
    TagBox[\(2\/\@2\ 2\/\@\(2 + \@2\)\ \(2\/\@\(2 + \@\(2 + \@2\)\)\) \(2\/\@\
\(2 + \@\(2 + \@\(2 + \@2\)\)\)\) \[Ellipsis] = \[Pi]\/2\),
      HoldForm]], "Output",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  CellTags->{"Iterated Radical Identities", "G.1.8"}],

Cell[BoxData[
    TagBox[
      RowBox[{\(\@\(1 + \@\(1 + \@\(1 + \@\(1 + \@\(1 + \[Ellipsis]\)\)\)\)\)\
\), "=", 
        RowBox[{"1", "+", 
          FractionBox["1", 
            StyleBox[
              RowBox[{"1", "+", 
                FractionBox["1", 
                  StyleBox[
                    RowBox[{"1", "+", 
                      FractionBox["1", 
                        StyleBox[
                          RowBox[{"1", "+", 
                            FractionBox["1", 
                              StyleBox[\(1 + \[Ellipsis]\),
                                ScriptLevel->0]]}],
                          ScriptLevel->0]]}],
                    ScriptLevel->0]]}],
              ScriptLevel->0]]}]}],
      HoldForm]], "Output",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  CellTags->{"Iterated Radical Identities", "G.1.8"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Polylogarithm identities ",
  StyleBox["(StandardForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Polylogarithm Identities", "G.1.9"}],

Cell[BoxData[
    TagBox[\(2\ PolyLog[2, \(5 - \@5\)\/\(5 + \@5\)] + 
          Log[\(5 - \@5\)\/\(5 + \@5\)]\ Log[
              1 - \(5 - \@5\)\/\(5 + \@5\)] - \(2\ \[Pi]\^2\)\/15 = 0\),
      HoldForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Polylogarithm Identities", "G.1.9"}],

Cell[BoxData[
    TagBox[\(PolyLog[2, 1\/4] + 2\ PolyLog[2, 1\/3] + Log[4\/3]\ Log[2] + 
          Log[3\/2]\ Log[3] - \[Pi]\^2\/6 = 0\),
      HoldForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Polylogarithm Identities", "G.1.9"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Heisenberg-Euler Lagrangian from quantum electrodynamics ",
  StyleBox["(TraditionalForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Heisenberg-Euler Lagrangian", "G.1.10"}],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[ScriptCapitalL]\_eff\), "=", 
        RowBox[{
          RowBox[{\(1\/2\), 
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox[
                  StyleBox["E",
                    FontFamily->"Times",
                    FontSize->12,
                    FontWeight->"Bold",
                    FontSlant->"Italic",
                    FontTracking->"Plain"], "2"], "-", 
                SuperscriptBox[
                  StyleBox["B",
                    FontSize->12,
                    FontWeight->"Bold",
                    FontSlant->"Italic"], "2"]}], ")"}]}], " ", "-", 
          RowBox[{\(1\/\(8  \[Pi]\^2\)\), 
            RowBox[{\(\[Integral]\+\[CapitalGamma]\), 
              RowBox[{\(\[ExponentialE]\^\(\(-m\^2\) u\)\/u\^3\), 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      SuperscriptBox[
                        StyleBox["e",
                          "MagicInlineCellMarker"], "2"], 
                      StyleBox[" ",
                        "MagicInlineCellMarker"], 
                      SuperscriptBox[
                        StyleBox["u",
                          "MagicInlineCellMarker"], \(\(2\)\(\ \)\)], 
                      StyleBox[
                        RowBox[{"\[LeftBracketingBar]", 
                          RowBox[{
                            StyleBox["E",
                              FontFamily->"Times",
                              FontSize->12,
                              FontWeight->"Bold",
                              FontSlant->"Italic",
                              FontTracking->"Plain"], "\[CenterDot]", 
                            StyleBox["B",
                              FontSize->12,
                              FontWeight->"Bold",
                              FontSlant->"Italic"]}], 
                          "\[RightBracketingBar]"}],
                        FontFamily->"Times",
                        FontSize->12,
                        FontWeight->"Plain",
                        FontSlant->"Plain",
                        FontTracking->"Plain"], " ", 
                      FractionBox[
                        RowBox[{"Re", "[", 
                          RowBox[{"cosh", 
                            RowBox[{"(", 
                              RowBox[{"e", " ", "u", " ", 
                                SqrtBox[
                                  RowBox[{"2", 
                                    RowBox[{"(", 
                                      RowBox[{
                                        SuperscriptBox[
                                        StyleBox["B",
                                        FontSize->12,
                                        FontWeight->"Bold",
                                        FontSlant->"Italic"], "2"], "-", 
                                        SuperscriptBox[
                                        StyleBox["E",
                                        FontFamily->"Times",
                                        FontSize->12,
                                        FontWeight->"Bold",
                                        FontSlant->"Italic",
                                        FontTracking->"Plain"], "2"], "+", 
                                        RowBox[{"\[ImaginaryI]", " ", 
                                        RowBox[{
                                        StyleBox["E",
                                        FontFamily->"Times",
                                        FontSize->12,
                                        FontWeight->"Bold",
                                        FontSlant->"Italic",
                                        FontTracking->"Plain"], 
                                        "\[CenterDot]", 
                                        StyleBox["B",
                                        FontSize->12,
                                        FontWeight->"Bold",
                                        FontSlant->"Italic"]}]}]}], 
                                      ")"}]}]]}], ")"}]}], "]"}], 
                        RowBox[{"Im", "[", 
                          RowBox[{"cosh", 
                            RowBox[{"(", 
                              RowBox[{"e", " ", "u", " ", 
                                SqrtBox[
                                  RowBox[{"2", 
                                    RowBox[{"(", 
                                      RowBox[{
                                        SuperscriptBox[
                                        StyleBox["B",
                                        FontSize->12,
                                        FontWeight->"Bold",
                                        FontSlant->"Italic"], "2"], "-", 
                                        SuperscriptBox[
                                        StyleBox["E",
                                        FontFamily->"Times",
                                        FontSize->12,
                                        FontWeight->"Bold",
                                        FontSlant->"Italic",
                                        FontTracking->"Plain"], "2"], "+", 
                                        RowBox[{"\[ImaginaryI]", " ", 
                                        RowBox[{
                                        StyleBox["E",
                                        FontFamily->"Times",
                                        FontSize->12,
                                        FontWeight->"Bold",
                                        FontSlant->"Italic",
                                        FontTracking->"Plain"], 
                                        "\[CenterDot]", 
                                        StyleBox["B",
                                        FontSize->12,
                                        FontWeight->"Bold",
                                        FontSlant->"Italic"]}]}]}], 
                                      ")"}]}]]}], ")"}]}], "]"}]]}], "-", "1",
                     "+", 
                    RowBox[{\(2\/3\), " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "MagicInlineCellMarker"], "2"], 
                      StyleBox[" ",
                        "MagicInlineCellMarker"], 
                      SuperscriptBox[
                        StyleBox["u",
                          "MagicInlineCellMarker"], \(\(2\)\(\ \)\)], " ", 
                      RowBox[{"(", 
                        RowBox[{
                          SuperscriptBox[
                            StyleBox["E",
                              FontFamily->"Times",
                              FontSize->12,
                              FontWeight->"Bold",
                              FontSlant->"Italic",
                              FontTracking->"Plain"], "2"], "-", 
                          SuperscriptBox[
                            StyleBox["B",
                              FontSize->12,
                              FontWeight->"Bold",
                              FontSlant->"Italic"], "2"]}], ")"}]}]}], " ", 
                  ")"}], \(\[DifferentialD]u\)}]}]}]}]}], 
      TraditionalForm]], "Output",
  Editable->True,
  WindowClickSelect->True,
  ShowCellBracket->True,
  CellMargins->{{10, Inherited}, {1, 4}},
  Evaluatable->False,
  FontWeight->"Plain",
  CellTags->{"Heisenberg-Euler Lagrangian", "G.1.10"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Diagram from homological algebra  ",
  StyleBox["(TraditionalForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Homological Algebra", "G.1.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {\(X\^\(p - 1\)\), 
            StyleBox[\(\[LongRightArrow]\&\(\[Xi]\^p\)\),
              SpanMinSize->2,
              SpanMaxSize->2], \(X\^p\), 
            StyleBox[\(\[LongRightArrow]\&\(\[Nu]\^p\)\),
              SpanMinSize->2,
              SpanMaxSize->2], 
            AdjustmentBox["X",
              BoxMargins->{{-0.379446, 0.379446}, {0, 0}}], 
            StyleBox[\(\[DoubleLongRightArrow]\&\(\[Eta]\_p\)\),
              SpanMinSize->2,
              SpanMaxSize->2], \(X\_p\), 
            StyleBox[\(\[DoubleLongRightArrow]\&\(\[Xi]\_p\)\),
              SpanMinSize->2,
              SpanMaxSize->2], \(X\_\(p + 1\)\)},
          {
            RowBox[{"\[DownArrow]", 
              AdjustmentBox[\(\[Kappa]\^\(p - 1\)\),
                BoxMargins->{{1.05164, -1.05164}, {0, 0}}]}], 
            StyleBox[" ",
              SpanMinSize->1.7,
              SpanMaxSize->1.7], 
            RowBox[{"\[DownArrow]", 
              AdjustmentBox[\(\[Kappa]\^p\),
                BoxMargins->{{1.05164, -1.05164}, {0, 0}}]}], 
            StyleBox[" ",
              SpanMinSize->1.7,
              SpanMaxSize->1.7], 
            StyleBox[
              AdjustmentBox[
                RowBox[{"\[DownArrow]", 
                  SuperscriptBox["\[Kappa]", 
                    StyleBox["a",
                      ShowContents->False]]}],
                BoxMargins->{{-0.075117, 0.075117}, {0, 0}}],
              SpanMinSize->1.7,
              SpanMaxSize->1.7], " ", 
            StyleBox[\(\[LeftBracketingBar]\[RightBracketingBar]\),
              SpanMinSize->1.7,
              SpanMaxSize->1.7], 
            StyleBox[" ",
              SpanMinSize->1.7,
              SpanMaxSize->1.7], 
            StyleBox[\(\[LeftBracketingBar]\[RightBracketingBar]\),
              SpanMinSize->1.7,
              SpanMaxSize->1.7]},
          {\(X\_\(-\[Infinity]\)\%\(p - 1\)\), 
            StyleBox["\[LongRightArrow]",
              SpanMaxSize->2], \(X\_\(-\[Infinity]\)\%p\), 
            StyleBox[\(\[LongRightArrow]\&\[Nu]\_\(-\[Infinity]\)\%p\),
              SpanMinSize->2,
              SpanMaxSize->2], \(X\_\(-\[Infinity]\)\), 
            
            StyleBox[\(\[DoubleLongRightArrow]\&\(\[Eta]\_\(\(-\[Infinity]\), 
                      p\)\)\),
              SpanMinSize->2,
              SpanMaxSize->2], \(X\_p\), 
            StyleBox[\(\[DoubleLongRightArrow]\&\(\[Xi]\_p\)\),
              SpanMinSize->2,
              SpanMaxSize->2], \(X\_\(p + 1\)\)},
          {
            StyleBox[\(\[LeftBracketingBar]\[RightBracketingBar]\),
              SpanMinSize->1.7,
              SpanMaxSize->1.7], " ", 
            StyleBox[\(\[LeftBracketingBar]\[RightBracketingBar]\),
              SpanMinSize->1.7,
              SpanMaxSize->1.7], " ", 
            RowBox[{
              StyleBox["\[UpArrow]",
                SpanMinSize->1.7,
                SpanMaxSize->1.7], 
              StyleBox[\(\[Lambda]\&_\),
                SpanMinSize->1,
                SpanMaxSize->1]}], 
            StyleBox[" ",
              SpanMinSize->1.7,
              SpanMaxSize->1.7], 
            RowBox[{"\[UpArrow]", 
              AdjustmentBox[\(\[Lambda]\_p\),
                BoxMargins->{{0.676056, -0.676056}, {0, 0}}]}], 
            StyleBox[" ",
              SpanMinSize->1.7,
              SpanMaxSize->1.7], 
            RowBox[{"\[UpArrow]", 
              AdjustmentBox[\(\[Lambda]\_\(p + 1\)\),
                BoxMargins->{{1.05164, -1.05164}, {0, 0}}]}]},
          {\(X\_\(-\[Infinity]\)\%\(p - 1\)\), 
            StyleBox[\(\[LongRightArrow]\&\[Xi]\_\(-\[Infinity]\)\%p\),
              SpanMinSize->2,
              SpanMaxSize->2], \(X\_\(-\[Infinity]\)\%p\), 
            
            StyleBox[\(\[LongRightArrow]\&\[Nu]\_\(-\[Infinity]\)\%\(\
\[Infinity], p\)\),
              SpanMinSize->2,
              SpanMaxSize->2], \(\((X\_\(-\[Infinity]\))\)\^\[Infinity]\), 
            
            StyleBox[\(\[DoubleLongRightArrow]\&\[Eta]\_\(\(-\[Infinity]\), p\
\)\%\[Infinity]\),
              SpanMinSize->2,
              SpanMaxSize->2], \(X\_p\%\[Infinity]\), 
            
            StyleBox[\(\[DoubleLongRightArrow]\&\(\(\ \ \ \)\(\[Xi]\_p\%\(\(\
\[Infinity]\)\(\ \ \)\)\)\)\),
              SpanMinSize->2,
              SpanMaxSize->2], \(X\_\(p + 1\)\%\[Infinity]\)}
          }], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontWeight->"Plain",
  CellTags->{"Homological Algebra", "G.1.11"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Sums involving zeta functions ",
  StyleBox["(TraditionalForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Zeta Functions", "G.1.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              RowBox[{
                StyleBox[\(\[Sum]\+\(k = 2\)\%\[Infinity]\),
                  SpanMinSize->2], 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      TagBox[
                        RowBox[{"\[Zeta]", "(", 
                          TagBox["k",
                            (Editable -> True)], ")"}],
                        InterpretTemplate[ Zeta[ #]&]], "-", "1"}], ")"}], 
                  " ", \(x\^k\)}]}], "=", 
              RowBox[{\(-x\), " ", 
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      TagBox["\[Psi]",
                        PolyGamma], "(", \(2 - x\), ")"}], "+", 
                    TagBox["\[Gamma]",
                      EulerGamma], "-", "1"}], ")"}]}]}], 
            RowBox[{"         ", 
              TagBox[
                TagBox[
                  RowBox[{
                    RowBox[{
                      StyleBox[\(\[Sum]\+\(k = 2\)\%\[Infinity]\),
                        
                        SpanMinSize->
                          2], \(\(\((\(-1\))\)\^k\/2\^k\) \(\[Zeta](k)\)\)}], 
                    "=", \(1 - log(2)\)}],
                  HoldForm],
                HoldForm]}]}
          }], TraditionalForm]], "FlushInput",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  FontWeight->"Roman",
  UnderoverscriptBoxOptions->{LimitsPositioning->False},
  GridBoxOptions->{ColumnAlignments->{Left}},
  CellTags->{"Zeta Functions", "G.1.12"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Green's function for the Laplace operator on a rectangle with homogeneous \
Dirichlet boundary conditions ",
  StyleBox["(TraditionalForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Green's Function", "G.1.13"}],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{
          RowBox[{"G", 
            RowBox[{"(", 
              RowBox[{"x", ",", 
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], ",", "y", ",", 
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None]}], ")"}]}], "=", 
          RowBox[{\(1\/\(2  \[Pi]\)\), "Re", 
            RowBox[{"(", 
              RowBox[{"log", 
                RowBox[{"(", 
                  FractionBox[
                    RowBox[{\(\[CurlyTheta]\_1\), 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(\(\(\[Pi]\)\(\ \)\)\/\(4\ a\)\), 
                            RowBox[{"(", 
                              RowBox[{"x", "+", \(\[ImaginaryI]\ y\), "+", 
                                SuperscriptBox["x", "\[Prime]",
                                  MultilineFunction->None], "-", 
                                RowBox[{"\[ImaginaryI]", " ", 
                                  SuperscriptBox["y", "\[Prime]",
                                    MultilineFunction->None]}]}], ")"}]}], 
                          ",", \(\[ExponentialE]\^\(-\(\(a\ \
\[Pi]\)\/b\)\)\)}], ")"}], " ", \(\[CurlyTheta]\_1\), 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(\[Pi]\/\(4\ a\)\), " ", 
                            RowBox[{"(", 
                              RowBox[{"x", "+", \(\[ImaginaryI]\ y\), "-", 
                                SuperscriptBox["x", "\[Prime]",
                                  MultilineFunction->None], "+", 
                                RowBox[{"\[ImaginaryI]", " ", 
                                  SuperscriptBox["y", "\[Prime]",
                                    MultilineFunction->None]}]}], ")"}]}], 
                          ",", \(\[ExponentialE]\^\(-\(\(a\ \
\[Pi]\)\/b\)\)\)}], ")"}]}], 
                    RowBox[{\(\[CurlyTheta]\_1\), 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(\[Pi]\/\(4\ a\)\), " ", 
                            RowBox[{"(", 
                              RowBox[{"x", "+", \(\[ImaginaryI]\ y\), "-", 
                                SuperscriptBox["x", "\[Prime]",
                                  MultilineFunction->None], "-", 
                                RowBox[{"\[ImaginaryI]", " ", 
                                  SuperscriptBox["y", "\[Prime]",
                                    MultilineFunction->None]}]}], ")"}]}], 
                          ",", \(\[ExponentialE]\^\(-\(\(a\ \
\[Pi]\)\/b\)\)\)}], ")"}], " ", \(\[CurlyTheta]\_1\), 
                      RowBox[{"(", 
                        RowBox[{
                          RowBox[{\(\[Pi]\/\(4\ a\)\), " ", 
                            RowBox[{"(", 
                              RowBox[{"x", "+", \(\[ImaginaryI]\ y\), "+", 
                                SuperscriptBox["x", "\[Prime]",
                                  MultilineFunction->None], "+", 
                                RowBox[{"\[ImaginaryI]", " ", 
                                  SuperscriptBox["y", "\[Prime]",
                                    MultilineFunction->None]}]}], ")"}]}], 
                          ",", \(\[ExponentialE]\^\(-\(\(a\ \
\[Pi]\)\/b\)\)\)}], ")"}]}]], ")"}]}], ")"}]}]}],
        HoldForm], TraditionalForm]], "Output",
  CellMargins->{{15.8125, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  CellTags->{"Green's Function", "G.1.13"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Nontrivial square root of an identity matrix ",
  StyleBox["(TraditionalForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Matrix Square Root", "G.1.14"}],

Cell[BoxData[
    FormBox[
      TagBox[
        RowBox[{
          SqrtBox[
            RowBox[{"(", GridBox[{
                  {"1", "0", "0", "0", "0", "0", "0", "0", "0"},
                  {"0", "1", "0", "0", "0", "0", "0", "0", "0"},
                  {"0", "0", "1", "0", "0", "0", "0", "0", "0"},
                  {"0", "0", "0", "1", "0", "0", "0", "0", "0"},
                  {"0", "0", "0", "0", "1", "0", "0", "0", "0"},
                  {"0", "0", "0", "0", "0", "1", "0", "0", "0"},
                  {"0", "0", "0", "0", "0", "0", "1", "0", "0"},
                  {"0", "0", "0", "0", "0", "0", "0", "1", "0"},
                  {"0", "0", "0", "0", "0", "0", "0", "0", "1"}
                  },
                ColumnAlignments->{Decimal}], ")"}]], "=", 
          RowBox[{"(", GridBox[{
                {"\[Gamma]", "\[Beta]", "\[Delta]", "\[Epsilon]", "\[Alpha]", 
                  "\[Epsilon]", "\[Delta]", "\[Beta]", "\[Gamma]"},
                {"\[Beta]", "\[Epsilon]", "\[Epsilon]", "\[Beta]", 
                  "0", \(-\[Beta]\), \(-\[Epsilon]\), \(-\[Epsilon]\), \(-\
\[Beta]\)},
                {"\[Delta]", "\[Epsilon]", 
                  "\[Gamma]", \(-\[Beta]\), \(-\[Alpha]\), \(-\[Beta]\), 
                  "\[Gamma]", "\[Epsilon]", "\[Delta]"},
                {"\[Epsilon]", "\[Beta]", \(-\[Beta]\), \(-\[Epsilon]\), "0", 
                  "\[Epsilon]", "\[Beta]", \(-\[Beta]\), \(-\[Epsilon]\)},
                {"\[Alpha]", "0", \(-\[Alpha]\), "0", "\[Alpha]", 
                  "0", \(-\[Alpha]\), "0", "\[Alpha]"},
                {"\[Epsilon]", \(-\[Beta]\), \(-\[Beta]\), "\[Epsilon]", 
                  "0", \(-\[Epsilon]\), "\[Beta]", 
                  "\[Beta]", \(-\[Epsilon]\)},
                {"\[Delta]", \(-\[Epsilon]\), "\[Gamma]", 
                  "\[Beta]", \(-\[Alpha]\), "\[Beta]", 
                  "\[Gamma]", \(-\[Epsilon]\), "\[Delta]"},
                {"\[Beta]", \(-\[Epsilon]\), "\[Epsilon]", \(-\[Beta]\), "0", 
                  "\[Beta]", \(-\[Epsilon]\), "\[Epsilon]", \(-\[Beta]\)},
                {"\[Gamma]", \(-\[Beta]\), "\[Delta]", \(-\[Epsilon]\), 
                  "\[Alpha]", \(-\[Epsilon]\), "\[Delta]", \(-\[Beta]\), 
                  "\[Gamma]"}
                }], ")"}]}],
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{16.4375, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Plain",
  CellTags->{"Matrix Square Root", "G.1.14"}],

Cell[BoxData[
    FormBox[
      TagBox[\(\[Alpha] = 1\/\@5, \ \[Beta] = 
          1\/2\ \@\(\(5 - \@5\)\/10\), \ \[Gamma] = \(\(-1\) + \@5\)\/\(4\ \
\@5\), \ \[Delta] = \(1 + \@5\)\/\(4\ \@5\), \ \[Epsilon] = 
          1\/2\ \@\(\(5 + \@5\)\/10\)\),
        HoldForm], TraditionalForm]], "Input",
  CellMargins->{{16.4375, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Plain",
  CellTags->{"Matrix Square Root", "G.1.14"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Some indefinite integrals ",
  StyleBox["(StandardForm)", "MB"]
}], "LineHead",
  Editable->True,
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],

Cell[BoxData[
    StyleBox[
      TagBox[\(\[Integral]\(\(Log[\(-1\) + x]\ Log[
                      1 + x]\)\/x\^4\) \[DifferentialD]x = \(1\/\(6\ x\^3\)\) \
\((x\ \((2\ x - Log[\(-1\) + x] + 2  x\ Log[\(-1\) + x] - 
                      x\^2\ Log[\(-1\) + x] - x\^2\ Log[\(-x\)] + 
                      x\^2\ Log[x] - 2\ x\^2\ Log[1 - x]\ Log[x] + 
                      2\ x\^2\ Log[\(-1\) + x]\ Log[x] - 
                      2 \( x\^2\) Log[\(-1\) + x] 
                        Log[\(1 + x\)\/2])\) + \((x\ \((1 + x)\)\^2 + 
                      2\ x\^3\ Log[\(1 - x\)\/2] - 2\ Log[\(-1\) + x])\)\ Log[
                    1 + x] + 
                2  x\^3\ \((\(-PolyLog[2, 1\/2 - x\/2]\) + 
                      PolyLog[2, \(-x\)] - PolyLog[2, x] + 
                      PolyLog[2, \(1 + x\)\/2])\))\)\),
        HoldForm],
      FontFamily->"Courier",
      FontSize->12,
      FontWeight->"Roman",
      FontSlant->"Plain",
      FontTracking->"Plain",
      PrivateFontOptions->{"FontPostScriptName"->Automatic}]], "Input",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],

Cell[BoxData[
    TagBox[\(\[Integral]\(Tan[x]\^a\) \[DifferentialD]x = \(-\(1\/2\)\) 
          Beta[Cos[x]\^2, \ \(1 - a\)\/2, \(1 + a\)\/2] 
          Cos[x] \(\((Cos[x]\^2)\)\^\(\(\(-1\) + a\)\/2\)\) 
          Sin[x] \(\((Sin[x]\^2)\)\^\(\(\(-1\) - a\)\/2\)\) Tan[x]\^2\),
      HoldForm]], "Input",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Indefinite Integrals", "G.1.15"}],

Cell[BoxData[
    TagBox[\(\[Integral]Log[Sin[x] + Tan[x]] \[DifferentialD]x = \(I\/2\) 
            x\^2 - x\ Log[1 - E\^\(I\ x\)] - 3\ x\ Log[1 + E\^\(I\ x\)] + 
          x\ Log[1 + E\^\(2\ I\ x\)] + x\ Log[Sin[x] + Tan[x]] + 
          3\ I\ PolyLog[2, \(-E\^\(I\ x\)\)] + I\ PolyLog[2, E\^\(I\ x\)] - 
          I\/2\ I\ PolyLog[2, \(-E\^\(2\ I\ x\)\)]\),
      HoldForm]], "Input",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Indefinite Integrals", "G.1.15"}],

Cell[BoxData[
    TagBox[\(\[Integral]\(\(1 + 
                  x\)\/\(x \@\(\((x - a)\)\ \((x - b)\)\ \((x - c)\)\)\)\) \
\[DifferentialD]x = \(2\ \((b - c)\)\ \(\@\(\(a - x\)\/\(a - c\)\)\) \@\(\(\(\
\((b - x)\) \((\(-c\) + x)\)\)\/\((b - c)\)\^2\)\(\ \)\)\)\/\(c\ \
\@\(\((\(-a\) + x)\)\ \((\(-b\) + x)\)\ \((\(-c\) + x)\)\)\)\ \((c\ EllipticF[
                  ArcSin[\@\(\(\(-c\) + x\)\/\(b - c\)\)], \(b - c\)\/\(a - c\
\)] + EllipticPi[1 - b\/c, 
                ArcSin[\@\(\(\(-c\) + x\)\/\(b - c\)\)], \(b - c\)\/\(a - \
c\)])\)\),
      HoldForm]], "Input",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Indefinite Integrals", "G.1.15"}],

Cell[BoxData[
    TagBox[\(\[Integral]\(x\^p\ Sin[
                x]\) \[DifferentialD]x = \(-\(I\/2\)\)\ \((\(-\((\(-I\)\ x)\)\
\^\(\(-1\) - p\)\)\ x\^\(1 + p\)\ Gamma[
                  1 + p, \(-I\)\ x] + \((I\ x)\)\^\(\(-1\) - p\)\ x\^\(1 + \
p\)\ Gamma[1 + p, I\ x])\)\),
      HoldForm]], "Input",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Indefinite Integrals", "G.1.15"}],

Cell[BoxData[
    TagBox[\(\[Integral]\(\(x\ ArcTan[x\/a]\)\/\(x\^2 + 
                  a\^2\)\) \[DifferentialD]x = 
        1\/2\ \((I\ ArcTan[x]\^2\  - 
              2\ ArcTan[x]\ Log[1 + E\^\(2  I\ ArcTan[x]\)] + 
              I\ PolyLog[2, \(-E\^\(2  I\ ArcTan[x]\)\)])\)\),
      HoldForm]], "Input",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Indefinite Integrals", "G.1.15"}],

Cell[BoxData[
    TagBox[\(\[Integral]\(Cos[
                  x]\/\(Sin[x]\^6\ Sin[2\ x]\^\(3\/2\)\)\) \[DifferentialD]x \
= \ 1\/390\ Csc[x]\^7\ \(\@Sin[2\ x]\) \((\(-77\) + 86\ Csc[2  x] - 
              28\ Cos[4  x] + 4\ Cos[6  x])\)\),
      HoldForm]], "Input",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Indefinite Integrals", "G.1.15"}],

Cell[BoxData[
    TagBox[\(\[Integral]\(\(x\ ArcSec[
                    x]\)\/\@\(x\^2 - 1\)\) \[DifferentialD]x = \@\(x\^2 - 1\)\
\ ArcSec[x] - \(x\ \@\(\(x\^2 - 1\)\/x\^2\)\ Log[x]\)\/\@\(x\^2 - 1\)\),
      HoldForm]], "Input",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Indefinite Integrals", "G.1.15"}],

Cell[BoxData[
    TagBox[\(\[Integral]\(x\^2\) 
            Tan[x]\ \[DifferentialD]x = \(\(\(I\)\(\ \)\)\/3\) x\^3 - 
          x\^2\ Log[1 + E\^\(2\ I\ x\)] + 
          I\ x\ PolyLog[2, \(-E\^\(2\ I\ x\)\)] - 
          1\/2\ PolyLog[3, \(-E\^\(2\ I\ x\)\)]\),
      HoldForm]], "Input",
  CellMargins->{{14.25, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  FontWeight->"Roman",
  CellTags->{"Indefinite Integrals", "G.1.15"}]
}, Closed]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{31, 1152}, {0, 848}},
Editable->True,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{557, 448},
WindowMargins->{{-3, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Definite Integral"->{
    Cell[1776, 53, 204, 7, 50, "LineHead",
      Evaluatable->False,
      CellTags->{"Definite Integral", "G.1.1"}],
    Cell[1983, 62, 36503, 771, 638, "FlushInput",
      Evaluatable->False,
      CellTags->{"Definite Integral", "G.1.1"}]},
  "G.1.1"->{
    Cell[1776, 53, 204, 7, 50, "LineHead",
      Evaluatable->False,
      CellTags->{"Definite Integral", "G.1.1"}],
    Cell[1983, 62, 36503, 771, 638, "FlushInput",
      Evaluatable->False,
      CellTags->{"Definite Integral", "G.1.1"}]},
  "Pisot Number"->{
    Cell[38523, 838, 194, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Pisot Number", "G.1.2"}],
    Cell[38720, 847, 6102, 87, 821, "FlushInput",
      Evaluatable->False,
      CellTags->{"Pisot Number", "G.1.2"}]},
  "G.1.2"->{
    Cell[38523, 838, 194, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Pisot Number", "G.1.2"}],
    Cell[38720, 847, 6102, 87, 821, "FlushInput",
      Evaluatable->False,
      CellTags->{"Pisot Number", "G.1.2"}]},
  "Antisymmetric Tensors"->{
    Cell[44859, 939, 247, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Antisymmetric Tensors", "G.1.3"}],
    Cell[45109, 948, 29258, 413, 461, "FlushInput",
      Evaluatable->False,
      CellTags->{"Antisymmetric Tensors", "G.1.3"}]},
  "G.1.3"->{
    Cell[44859, 939, 247, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Antisymmetric Tensors", "G.1.3"}],
    Cell[45109, 948, 29258, 413, 461, "FlushInput",
      Evaluatable->False,
      CellTags->{"Antisymmetric Tensors", "G.1.3"}]},
  "Trigonometric Formulas"->{
    Cell[74404, 1366, 212, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[74619, 1375, 435, 11, 52, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[75057, 1388, 443, 11, 52, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[75503, 1401, 842, 17, 52, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[76348, 1420, 442, 11, 77, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[76793, 1433, 450, 11, 77, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[77246, 1446, 449, 12, 58, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[77698, 1460, 2947, 84, 176, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}]},
  "G.1.4"->{
    Cell[74404, 1366, 212, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[74619, 1375, 435, 11, 52, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[75057, 1388, 443, 11, 52, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[75503, 1401, 842, 17, 52, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[76348, 1420, 442, 11, 77, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[76793, 1433, 450, 11, 77, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[77246, 1446, 449, 12, 58, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}],
    Cell[77698, 1460, 2947, 84, 176, "FlushInput",
      Evaluatable->False,
      CellTags->{"Trigonometric Formulas", "G.1.4"}]},
  "More Definite Integrals"->{
    Cell[80682, 1549, 214, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[80899, 1558, 935, 22, 80, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[81837, 1582, 1125, 27, 48, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[82965, 1611, 421, 9, 46, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[83389, 1622, 555, 13, 47, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[83947, 1637, 1124, 27, 48, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[85074, 1666, 1012, 23, 80, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[86089, 1691, 948, 23, 45, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[87040, 1716, 3721, 84, 82, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[90764, 1802, 1962, 42, 83, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[92729, 1846, 351, 8, 45, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[93083, 1856, 499, 11, 45, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}]},
  "G.1.5"->{
    Cell[80682, 1549, 214, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[80899, 1558, 935, 22, 80, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[81837, 1582, 1125, 27, 48, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[82965, 1611, 421, 9, 46, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[83389, 1622, 555, 13, 47, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[83947, 1637, 1124, 27, 48, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[85074, 1666, 1012, 23, 80, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[86089, 1691, 948, 23, 45, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[87040, 1716, 3721, 84, 82, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[90764, 1802, 1962, 42, 83, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[92729, 1846, 351, 8, 45, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}],
    Cell[93083, 1856, 499, 11, 45, "Input",
      Evaluatable->False,
      CellTags->{"More Definite Integrals", "G.1.5"}]},
  "Partitions"->{
    Cell[93619, 1872, 210, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Partitions", "G.1.6"}],
    Cell[93832, 1881, 580, 11, 58, "Input",
      Evaluatable->False,
      CellTags->{"Partitions", "G.1.6"}],
    Cell[94415, 1894, 1627, 37, 74, "Input",
      Evaluatable->False,
      CellTags->{"Partitions", "G.1.6"}]},
  "G.1.6"->{
    Cell[93619, 1872, 210, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Partitions", "G.1.6"}],
    Cell[93832, 1881, 580, 11, 58, "Input",
      Evaluatable->False,
      CellTags->{"Partitions", "G.1.6"}],
    Cell[94415, 1894, 1627, 37, 74, "Input",
      Evaluatable->False,
      CellTags->{"Partitions", "G.1.6"}]},
  "Ellipsoid Surface Area"->{
    Cell[96079, 1936, 215, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Ellipsoid Surface Area", "G.1.7"}],
    Cell[96297, 1945, 665, 13, 83, "Output",
      Evaluatable->False,
      CellTags->{"Ellipsoid Surface Area", "G.1.7"}],
    Cell[96965, 1960, 355, 8, 49, "Output",
      Evaluatable->False,
      CellTags->{"Ellipsoid Surface Area", "G.1.7"}]},
  "G.1.7"->{
    Cell[96079, 1936, 215, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Ellipsoid Surface Area", "G.1.7"}],
    Cell[96297, 1945, 665, 13, 83, "Output",
      Evaluatable->False,
      CellTags->{"Ellipsoid Surface Area", "G.1.7"}],
    Cell[96965, 1960, 355, 8, 49, "Output",
      Evaluatable->False,
      CellTags->{"Ellipsoid Surface Area", "G.1.7"}]},
  "Iterated Radical Identities"->{
    Cell[97357, 1973, 219, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Iterated Radical Identities", "G.1.8"}],
    Cell[97579, 1982, 282, 6, 71, "Output",
      Evaluatable->False,
      CellTags->{"Iterated Radical Identities", "G.1.8"}],
    Cell[97864, 1990, 317, 6, 74, "Output",
      Evaluatable->False,
      CellTags->{"Iterated Radical Identities", "G.1.8"}],
    Cell[98184, 1998, 889, 23, 114, "Output",
      Evaluatable->False,
      CellTags->{"Iterated Radical Identities", "G.1.8"}]},
  "G.1.8"->{
    Cell[97357, 1973, 219, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Iterated Radical Identities", "G.1.8"}],
    Cell[97579, 1982, 282, 6, 71, "Output",
      Evaluatable->False,
      CellTags->{"Iterated Radical Identities", "G.1.8"}],
    Cell[97864, 1990, 317, 6, 74, "Output",
      Evaluatable->False,
      CellTags->{"Iterated Radical Identities", "G.1.8"}],
    Cell[98184, 1998, 889, 23, 114, "Output",
      Evaluatable->False,
      CellTags->{"Iterated Radical Identities", "G.1.8"}]},
  "Polylogarithm Identities"->{
    Cell[99110, 2026, 213, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Polylogarithm Identities", "G.1.9"}],
    Cell[99326, 2035, 359, 9, 44, "FlushInput",
      Evaluatable->False,
      CellTags->{"Polylogarithm Identities", "G.1.9"}],
    Cell[99688, 2046, 308, 8, 36, "FlushInput",
      Evaluatable->False,
      CellTags->{"Polylogarithm Identities", "G.1.9"}]},
  "G.1.9"->{
    Cell[99110, 2026, 213, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Polylogarithm Identities", "G.1.9"}],
    Cell[99326, 2035, 359, 9, 44, "FlushInput",
      Evaluatable->False,
      CellTags->{"Polylogarithm Identities", "G.1.9"}],
    Cell[99688, 2046, 308, 8, 36, "FlushInput",
      Evaluatable->False,
      CellTags->{"Polylogarithm Identities", "G.1.9"}]},
  "Heisenberg-Euler Lagrangian"->{
    Cell[100033, 2059, 252, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Heisenberg-Euler Lagrangian", "G.1.10"}],
    Cell[100288, 2068, 7504, 153, 52, "Output",
      Evaluatable->False,
      CellTags->{"Heisenberg-Euler Lagrangian", "G.1.10"}]},
  "G.1.10"->{
    Cell[100033, 2059, 252, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Heisenberg-Euler Lagrangian", "G.1.10"}],
    Cell[100288, 2068, 7504, 153, 52, "Output",
      Evaluatable->False,
      CellTags->{"Heisenberg-Euler Lagrangian", "G.1.10"}]},
  "Homological Algebra"->{
    Cell[107829, 2226, 221, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Homological Algebra", "G.1.11"}],
    Cell[108053, 2235, 4563, 112, 136, "FlushInput",
      Evaluatable->False,
      CellTags->{"Homological Algebra", "G.1.11"}]},
  "G.1.11"->{
    Cell[107829, 2226, 221, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Homological Algebra", "G.1.11"}],
    Cell[108053, 2235, 4563, 112, 136, "FlushInput",
      Evaluatable->False,
      CellTags->{"Homological Algebra", "G.1.11"}]},
  "Zeta Functions"->{
    Cell[112653, 2352, 212, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Zeta Functions", "G.1.12"}],
    Cell[112868, 2361, 1616, 43, 42, "FlushInput",
      Evaluatable->False,
      CellTags->{"Zeta Functions", "G.1.12"}]},
  "G.1.12"->{
    Cell[112653, 2352, 212, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Zeta Functions", "G.1.12"}],
    Cell[112868, 2361, 1616, 43, 42, "FlushInput",
      Evaluatable->False,
      CellTags->{"Zeta Functions", "G.1.12"}]},
  "Green's Function"->{
    Cell[114521, 2409, 290, 8, 52, "LineHead",
      Evaluatable->False,
      CellTags->{"Green's Function", "G.1.13"}],
    Cell[114814, 2419, 3578, 69, 63, "Output",
      Evaluatable->False,
      CellTags->{"Green's Function", "G.1.13"}]},
  "G.1.13"->{
    Cell[114521, 2409, 290, 8, 52, "LineHead",
      Evaluatable->False,
      CellTags->{"Green's Function", "G.1.13"}],
    Cell[114814, 2419, 3578, 69, 63, "Output",
      Evaluatable->False,
      CellTags->{"Green's Function", "G.1.13"}]},
  "Matrix Square Root"->{
    Cell[118429, 2493, 231, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Matrix Square Root", "G.1.14"}],
    Cell[118663, 2502, 2473, 46, 156, "Input",
      Evaluatable->False,
      CellTags->{"Matrix Square Root", "G.1.14"}],
    Cell[121139, 2550, 453, 10, 62, "Input",
      Evaluatable->False,
      CellTags->{"Matrix Square Root", "G.1.14"}]},
  "G.1.14"->{
    Cell[118429, 2493, 231, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Matrix Square Root", "G.1.14"}],
    Cell[118663, 2502, 2473, 46, 156, "Input",
      Evaluatable->False,
      CellTags->{"Matrix Square Root", "G.1.14"}],
    Cell[121139, 2550, 453, 10, 62, "Input",
      Evaluatable->False,
      CellTags->{"Matrix Square Root", "G.1.14"}]},
  "Indefinite Integrals"->{
    Cell[121629, 2565, 211, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[121843, 2574, 1171, 24, 177, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[123017, 2600, 458, 9, 42, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[123478, 2611, 541, 10, 75, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[124022, 2623, 723, 14, 120, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[124748, 2639, 458, 10, 41, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[125209, 2651, 463, 10, 56, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[125675, 2663, 422, 9, 57, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[126100, 2674, 385, 8, 70, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[126488, 2684, 444, 10, 41, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}]},
  "G.1.15"->{
    Cell[121629, 2565, 211, 7, 36, "LineHead",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[121843, 2574, 1171, 24, 177, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[123017, 2600, 458, 9, 42, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[123478, 2611, 541, 10, 75, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[124022, 2623, 723, 14, 120, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[124748, 2639, 458, 10, 41, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[125209, 2651, 463, 10, 56, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[125675, 2663, 422, 9, 57, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[126100, 2674, 385, 8, 70, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}],
    Cell[126488, 2684, 444, 10, 41, "Input",
      Evaluatable->False,
      CellTags->{"Indefinite Integrals", "G.1.15"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Definite Integral", 127711, 2719},
  {"G.1.1", 127968, 2726},
  {"Pisot Number", 128232, 2733},
  {"G.1.2", 128481, 2740},
  {"Antisymmetric Tensors", 128746, 2747},
  {"G.1.3", 129015, 2754},
  {"Trigonometric Formulas", 129301, 2761},
  {"G.1.4", 130346, 2786},
  {"More Definite Integrals", 131409, 2811},
  {"G.1.5", 132928, 2848},
  {"Partitions", 134452, 2885},
  {"G.1.6", 134805, 2895},
  {"Ellipsoid Surface Area", 135175, 2905},
  {"G.1.7", 135564, 2915},
  {"Iterated Radical Identities", 135975, 2925},
  {"G.1.8", 136509, 2938},
  {"Polylogarithm Identities", 137062, 2951},
  {"G.1.9", 137464, 2961},
  {"Heisenberg-Euler Lagrangian", 137888, 2971},
  {"G.1.10", 138170, 2978},
  {"Homological Algebra", 138465, 2985},
  {"G.1.11", 138736, 2992},
  {"Zeta Functions", 139015, 2999},
  {"G.1.12", 139274, 3006},
  {"Green's Function", 139543, 3013},
  {"G.1.13", 139802, 3020},
  {"Matrix Square Root", 140073, 3027},
  {"G.1.14", 140458, 3037},
  {"Indefinite Integrals", 140857, 3047},
  {"G.1.15", 142114, 3078}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 204, 7, 50, "LineHead",
  Evaluatable->False,
  CellTags->{"Definite Integral", "G.1.1"}],
Cell[1983, 62, 36503, 771, 638, "FlushInput",
  Evaluatable->False,
  CellTags->{"Definite Integral", "G.1.1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[38523, 838, 194, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Pisot Number", "G.1.2"}],
Cell[38720, 847, 6102, 87, 821, "FlushInput",
  Evaluatable->False,
  CellTags->{"Pisot Number", "G.1.2"}]
}, Closed]],

Cell[CellGroupData[{
Cell[44859, 939, 247, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Antisymmetric Tensors", "G.1.3"}],
Cell[45109, 948, 29258, 413, 461, "FlushInput",
  Evaluatable->False,
  CellTags->{"Antisymmetric Tensors", "G.1.3"}]
}, Closed]],

Cell[CellGroupData[{
Cell[74404, 1366, 212, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Trigonometric Formulas", "G.1.4"}],
Cell[74619, 1375, 435, 11, 52, "FlushInput",
  Evaluatable->False,
  CellTags->{"Trigonometric Formulas", "G.1.4"}],
Cell[75057, 1388, 443, 11, 52, "FlushInput",
  Evaluatable->False,
  CellTags->{"Trigonometric Formulas", "G.1.4"}],
Cell[75503, 1401, 842, 17, 52, "FlushInput",
  Evaluatable->False,
  CellTags->{"Trigonometric Formulas", "G.1.4"}],
Cell[76348, 1420, 442, 11, 77, "FlushInput",
  Evaluatable->False,
  CellTags->{"Trigonometric Formulas", "G.1.4"}],
Cell[76793, 1433, 450, 11, 77, "FlushInput",
  Evaluatable->False,
  CellTags->{"Trigonometric Formulas", "G.1.4"}],
Cell[77246, 1446, 449, 12, 58, "FlushInput",
  Evaluatable->False,
  CellTags->{"Trigonometric Formulas", "G.1.4"}],
Cell[77698, 1460, 2947, 84, 176, "FlushInput",
  Evaluatable->False,
  CellTags->{"Trigonometric Formulas", "G.1.4"}]
}, Closed]],

Cell[CellGroupData[{
Cell[80682, 1549, 214, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[80899, 1558, 935, 22, 80, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[81837, 1582, 1125, 27, 48, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[82965, 1611, 421, 9, 46, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[83389, 1622, 555, 13, 47, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[83947, 1637, 1124, 27, 48, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[85074, 1666, 1012, 23, 80, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[86089, 1691, 948, 23, 45, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[87040, 1716, 3721, 84, 82, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[90764, 1802, 1962, 42, 83, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[92729, 1846, 351, 8, 45, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}],
Cell[93083, 1856, 499, 11, 45, "Input",
  Evaluatable->False,
  CellTags->{"More Definite Integrals", "G.1.5"}]
}, Closed]],

Cell[CellGroupData[{
Cell[93619, 1872, 210, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Partitions", "G.1.6"}],
Cell[93832, 1881, 580, 11, 58, "Input",
  Evaluatable->False,
  CellTags->{"Partitions", "G.1.6"}],
Cell[94415, 1894, 1627, 37, 74, "Input",
  Evaluatable->False,
  CellTags->{"Partitions", "G.1.6"}]
}, Closed]],

Cell[CellGroupData[{
Cell[96079, 1936, 215, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Ellipsoid Surface Area", "G.1.7"}],
Cell[96297, 1945, 665, 13, 83, "Output",
  Evaluatable->False,
  CellTags->{"Ellipsoid Surface Area", "G.1.7"}],
Cell[96965, 1960, 355, 8, 49, "Output",
  Evaluatable->False,
  CellTags->{"Ellipsoid Surface Area", "G.1.7"}]
}, Closed]],

Cell[CellGroupData[{
Cell[97357, 1973, 219, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Iterated Radical Identities", "G.1.8"}],
Cell[97579, 1982, 282, 6, 71, "Output",
  Evaluatable->False,
  CellTags->{"Iterated Radical Identities", "G.1.8"}],
Cell[97864, 1990, 317, 6, 74, "Output",
  Evaluatable->False,
  CellTags->{"Iterated Radical Identities", "G.1.8"}],
Cell[98184, 1998, 889, 23, 114, "Output",
  Evaluatable->False,
  CellTags->{"Iterated Radical Identities", "G.1.8"}]
}, Closed]],

Cell[CellGroupData[{
Cell[99110, 2026, 213, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Polylogarithm Identities", "G.1.9"}],
Cell[99326, 2035, 359, 9, 44, "FlushInput",
  Evaluatable->False,
  CellTags->{"Polylogarithm Identities", "G.1.9"}],
Cell[99688, 2046, 308, 8, 36, "FlushInput",
  Evaluatable->False,
  CellTags->{"Polylogarithm Identities", "G.1.9"}]
}, Closed]],

Cell[CellGroupData[{
Cell[100033, 2059, 252, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Heisenberg-Euler Lagrangian", "G.1.10"}],
Cell[100288, 2068, 7504, 153, 52, "Output",
  Evaluatable->False,
  CellTags->{"Heisenberg-Euler Lagrangian", "G.1.10"}]
}, Closed]],

Cell[CellGroupData[{
Cell[107829, 2226, 221, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Homological Algebra", "G.1.11"}],
Cell[108053, 2235, 4563, 112, 136, "FlushInput",
  Evaluatable->False,
  CellTags->{"Homological Algebra", "G.1.11"}]
}, Closed]],

Cell[CellGroupData[{
Cell[112653, 2352, 212, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Zeta Functions", "G.1.12"}],
Cell[112868, 2361, 1616, 43, 42, "FlushInput",
  Evaluatable->False,
  CellTags->{"Zeta Functions", "G.1.12"}]
}, Closed]],

Cell[CellGroupData[{
Cell[114521, 2409, 290, 8, 52, "LineHead",
  Evaluatable->False,
  CellTags->{"Green's Function", "G.1.13"}],
Cell[114814, 2419, 3578, 69, 63, "Output",
  Evaluatable->False,
  CellTags->{"Green's Function", "G.1.13"}]
}, Closed]],

Cell[CellGroupData[{
Cell[118429, 2493, 231, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Matrix Square Root", "G.1.14"}],
Cell[118663, 2502, 2473, 46, 156, "Input",
  Evaluatable->False,
  CellTags->{"Matrix Square Root", "G.1.14"}],
Cell[121139, 2550, 453, 10, 62, "Input",
  Evaluatable->False,
  CellTags->{"Matrix Square Root", "G.1.14"}]
}, Closed]],

Cell[CellGroupData[{
Cell[121629, 2565, 211, 7, 36, "LineHead",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],
Cell[121843, 2574, 1171, 24, 177, "Input",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],
Cell[123017, 2600, 458, 9, 42, "Input",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],
Cell[123478, 2611, 541, 10, 75, "Input",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],
Cell[124022, 2623, 723, 14, 120, "Input",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],
Cell[124748, 2639, 458, 10, 41, "Input",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],
Cell[125209, 2651, 463, 10, 56, "Input",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],
Cell[125675, 2663, 422, 9, 57, "Input",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],
Cell[126100, 2674, 385, 8, 70, "Input",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}],
Cell[126488, 2684, 444, 10, 41, "Input",
  Evaluatable->False,
  CellTags->{"Indefinite Integrals", "G.1.15"}]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

