(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    170071,       5112]*)
(*NotebookOutlinePosition[    528806,      15820]*)
(*  CellTagsIndexPosition[    526482,      15763]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["", "Section",
  CellMargins->{{0, 0}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->1,
  "GroupIconTopMargin"->1},
  CellGroupingRules->"SectionGrouping",
  FontSize->9],

Cell["\<\
These cells are here with the correct cell tags so they can copied \
when the help browser loads just a subsection of the documentation. This \
means the titles can always be open.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Notation, Symbolize and InfixNotation", "Subsection",
  CellTags->"Notation:S1"],

Cell["Notation", "Subsubsection",
  CellTags->"Notation:S1.1"],

Cell["Symbolize", "Subsubsection",
  CellTags->"Notation:S1.2"],

Cell["Infix Notation", "Subsubsection",
  CellTags->"Notation:S1.3"],

Cell["Entering Notations", "Subsubsection",
  CellTags->"Notation:S1.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Precedence of Operators in Notations", "Subsection",
  CellTags->"Notation:S2"],

Cell["How Precedence is determined", "Subsubsection",
  CellTags->"Notation:S2.1"],

Cell["Parentheses in Notations", "Subsubsection",
  CellTags->"Notation:S2.2"],

Cell["Changing Precedences in Notations", "Subsubsection",
  CellTags->"Notation:S2.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Options and Auxiliary Functions", "Subsection",
  CellTags->"Notation:S3"],

Cell[TextData[{
  "The option ",
  StyleBox["Action", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S3.1"],

Cell[TextData[{
  "The option ",
  StyleBox["WorkingForm", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S3.2"],

Cell[TextData[{
  "The option",
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["AutoLoadNotationPalette", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S3.3"],

Cell[TextData[{
  "The function ",
  StyleBox["ClearNotations[]", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S3.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Complex Patterns and Advanced Features", "Subsection",
  CellTags->"Notation:S4"],

Cell["Note: This section is intended for advanced users.", "Subsubsection",
  CellTags->{
  "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
    "Notation:S4.6"}],

Cell["Tag boxes", "Subsubsection",
  CellTags->"Notation:S4.2"],

Cell[TextData[{
  "The tag ",
  StyleBox["NotationBoxTag", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S4.3"],

Cell[TextData[{
  "Complex Patterns and the tag ",
  StyleBox["NotationPatternTag", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S4.4"],

Cell[TextData[{
  "The tag ",
  StyleBox["NotationMadeBoxesTag", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S4.5"],

Cell[TextData[{
  "Changing precedences and the ",
  StyleBox["TagBox", "RM"],
  " option ",
  StyleBox["SyntaxForm", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S4.6"]
}, Closed]],

Cell[CellGroupData[{

Cell["Advice and Suggested Guidelines", "Subsection",
  CellTags->"Notation:S5"],

Cell["Build up notations in stages", "Subsubsection",
  CellTags->"Notation:S5.1"],

Cell["Don't alter too much", "Subsubsection",
  CellTags->"Notation:S5.2"],

Cell["Follow existing conventions where possible", "Subsubsection",
  CellTags->"Notation:S5.3"],

Cell["Parse without evaluation where possible", "Subsubsection",
  CellTags->"Notation:S5.4"],

Cell["\<\
Internal and External representations which are structurally \
different\
\>", "Subsubsection",
  CellTags->"Notation:S5.5"],

Cell["Updates and Expanded Documentation", "Subsubsection",
  CellTags->"Notation:S5.6"],

Cell["Jason Harris, November 1997.", "Subsubsection",
  CellTags->"Notation:S5.7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Utilities`Notation`", "Section",
  CellGroupingRules->"SectionGrouping",
  CellTags->"NotationDocumentation"],

Cell[TextData[{
  "The ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package allows you to extend ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " so it understands and functions correctly with new typeset notations.  \
The package ",
  StyleBox["Notation.m", "MR"],
  " consists of three main utility functions: ",
  StyleBox["Symbolize,", "MR"],
  " ",
  StyleBox["Notation", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  ". ",
  StyleBox["Symbolize", "MR"],
  " forces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to treat composite box structures internally as single symbols.  ",
  StyleBox["Notation", "MR"],
  " forces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to treat classes of composite box structures internally as a class of \
full-form expressions. ",
  StyleBox["InfixNotation", "MR"],
  " forces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to treat a composite expression as an infix operator."
}], "Text",
  CellTags->"NotationDocumentation"],

Cell[TextData[{
  "Without the definitions provided in this package, it is necessary to \
define new notations by constructing explicit ",
  StyleBox["MakeExpression", "MR"],
  " and ",
  StyleBox["MakeBoxes", "MR"],
  " rules. These rules have to be written in terms of full box structures \
that are generally long and visually unintuitive. Also, in creating a new \
notation, there are several nontrivial programming issues that must be taken \
into consideration. Hence, in the interests of readability and ease of use, \
it is desirable to be able to introduce new notations easily, intuitively, \
and graphically. The ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package provides this functionality."
}], "Text",
  CellTags->"NotationDocumentation"],

Cell[TextData[{
  "You should be aware that in this version of the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package, unlike some previous versions, all notations must be entered \
through the notation palette or through input aliases. (See ",
  ButtonBox["EnteringNotations",
    ButtonData:>{"Notation:Documentation:Entering Notations", 
      "Must use palette"},
    ButtonStyle->"DemosLink"],
  ".) Also this version of the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package automatically adds the new notation styles into the current style \
sheet, as well as generating an updated notebook if necessary."
}], "Text",
  CellTags->"NotationDocumentation"],

Cell[CellGroupData[{

Cell["Notation, Symbolize and InfixNotation", "SubsectionIcon",
  CellTags->"NotationDocumentation"],

Cell[CellGroupData[{

Cell["Notation", "SubsubsectionIcon",
  CellTags->{"Notation:S1", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Notation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                  "external", " ", "\[DoubleLongLeftRightArrow]", " ", 
                    "internal"}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"set", " "}],
                  SingleLetterItalics->False], 
                StyleBox["external",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"to", " ", "be", " ", "parsed", " ", "to"}], 
                    " "}],
                  SingleLetterItalics->False], 
                StyleBox["internal",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", "and", " "}],
                  SingleLetterItalics->False], 
                StyleBox["internal",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"to", " ", "be", " ", "formatted", " ", "as"}], 
                    " "}],
                  SingleLetterItalics->False], 
                StyleBox["external",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Notation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                  "external", " ", "\[DoubleLongRightArrow]", " ", 
                    "internal"}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"set", " "}],
                  SingleLetterItalics->False], 
                StyleBox["external",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"to", " ", "be", " ", "parsed", " ", "to"}], 
                    " "}],
                  SingleLetterItalics->False], 
                StyleBox["internal",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Notation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                  "external", " ", "\[DoubleLongLeftArrow]", " ", 
                    "internal"}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"set", " "}],
                  SingleLetterItalics->False], 
                StyleBox["internal",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"to", " ", "be", " ", "formatted", " ", "as"}], 
                    " "}],
                  SingleLetterItalics->False], 
                StyleBox["external",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Notation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["notation",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{
                    RowBox[{"define", " ", "a", " ", "notation"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["notation",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"with", " ", "the", " ", "options"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RemoveNotation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["notation",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{
                    RowBox[{"remove", " ", "the", " ", "notation"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["notation",
                  FontSlant->"Italic"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{
  "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation", 
    "NotationDocumentation"}],

Cell["Syntax of notation declarations.", "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[TextData[{
  StyleBox["Notation", "MR"],
  " takes both an external representation and an internal representation as \
arguments.  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " translates any input matching the external representation into the \
corresponding internal representation and, reciprocally, formats any \
expression matching the internal representation into the corresponding \
external representation.  In this context, representation means a composite \
structure made up of boxes representing some \"notation\"."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell["This loads the package. ", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"<<", "Utilities`Notation`"}]], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[TextData[{
  "The following declares a new notation for ",
  StyleBox["gplus", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"x_", " ", 
              SubscriptBox["\[CirclePlus]", "n_"], " ", "y_"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"gplus", "[", 
              RowBox[{"x_", ",", "y_", ",", "n_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[TextData[{
  "Any input matching  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x_", " ", 
          RowBox[{
            SubscriptBox["\[CirclePlus]", "n_"], " ", "y_"}]}], 
        TraditionalForm]]],
  " is now interpreted as ",
  StyleBox["gplus[x,y,n]", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"a", " ", 
        SubscriptBox["\[CirclePlus]", 
          RowBox[{"n", "+", "m"}]], " ", "b"}], " ", "//", " ", 
      "FullForm"}]], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"gplus", "[", 
          RowBox[{"a", ",", "b", ",", 
            RowBox[{"Plus", "[", 
              RowBox[{"m", ",", "n"}], "]"}]}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[3]//FullForm=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "Any ",
  StyleBox["gplus", "MR"],
  " expression is now formatted in the new notation."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"gplus", "[", 
      RowBox[{"\[Alpha]", ",", " ", "\[Beta]", ",", " ", "\[CapitalGamma]"}], 
      "]"}]], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"\[Alpha]", " ", 
        SubscriptBox["\[CirclePlus]", "\[CapitalGamma]"], " ", "\[Beta]"}], 
      " "}]], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "Notations defined using ",
  Cell[BoxData[
      FormBox["\[DoubleLongLeftRightArrow]", TraditionalForm]]],
  " in their definition both parse and format expressions according to the \
given notation. However, you can restrict the notation to only parsing or \
only formatting by using ",
  Cell[BoxData[
      FormBox["\[DoubleLongRightArrow]", TraditionalForm]]],
  " or ",
  Cell[BoxData[
      FormBox["\[DoubleLongLeftArrow]", TraditionalForm]]],
  " respectively, instead of ",
  Cell[BoxData[
      FormBox["\[DoubleLongLeftRightArrow]", TraditionalForm]]],
  " in your notation statements."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[TextData[{
  "This defines a notation for the parsing of a hypothetical ",
  StyleBox["DomainIntegral", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
            RowBox[{"f_", " ", 
              RowBox[{"\[CapitalDifferentialD]", "x_"}]}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", 
        " ", 
        TagBox[
          RowBox[{"DomainIntegral", "[", 
            RowBox[{"f_", ",", "x_"}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[TextData[{
  StyleBox["DomainIntegrals", "MR"],
  " are now parsable."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
      RowBox[{
        RowBox[{
          RowBox[{"\[Delta]", "'"}], "[", "x", "]"}], 
        RowBox[{"\[CapitalDifferentialD]", "x"}]}]}]], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"DomainIntegral", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["\[Delta]", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], ",", "x"}], 
      "]"}]], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "The following defines an output format for ",
  StyleBox["Derivative", "MR"],
  " objects that looks more like that of traditional mathematics."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[{
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          FractionBox[
            RowBox[{"\[PartialD]", 
              RowBox[{"f_", "[", "x_", "]"}]}], 
            RowBox[{"\[PartialD]", "x_"}]],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftArrow]", 
        " ", 
        TagBox[
          RowBox[{
            RowBox[{
              RowBox[{"Derivative", "[", "1", "]"}], "[", "f_", "]"}], "[", 
            "x_", "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          FractionBox[
            RowBox[{
              SuperscriptBox["\[PartialD]", "n_"], 
              RowBox[{"f_", "[", "x_", "]"}]}], 
            RowBox[{"\[PartialD]", 
              SuperscriptBox["x_", "n_"]}]],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftArrow]", 
        " ", 
        TagBox[
          RowBox[{
            RowBox[{
              RowBox[{"Derivative", "[", "n_", "]"}], "[", "f_", "]"}], "[", 
            "x_", "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]}], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell["\<\
Derivatives are now formatted according to the new derivative \
notation.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubscriptBox["\[CapitalGamma]", "\[Alpha]"], "'"}], "[", "t", 
          "]"}], ",", " ", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{"z", "+", "r"}], ")"}], "'"}], "'"}], "[", "q", 
          "]"}]}], "}"}]], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        FractionBox[
          RowBox[{"\[PartialD]", 
            RowBox[{
              SubscriptBox["\[CapitalGamma]", "\[Alpha]"], "[", "t", "]"}]}], 
          
          RowBox[{"\[PartialD]", "t"}]], ",", 
        FractionBox[
          RowBox[{
            SuperscriptBox["\[PartialD]", "2"], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"r", "+", "z"}], ")"}], "[", "q", "]"}]}], 
          RowBox[{"\[PartialD]", 
            SuperscriptBox["q", "2"]}]]}], "}"}]], "Output",
  CellLabel->"Out[9]=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],

Cell["\<\
To allow the previous output to be used as input you can define an \
interpretation of partial derivatives.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[{
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", "f_"}], 
              RowBox[{"\[PartialD]", "x_"}]], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", 
        " ", 
        TagBox[
          RowBox[{"D", "[", 
            RowBox[{"f_", ",", "x_"}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            FractionBox[
              RowBox[{
                SuperscriptBox["\[PartialD]", "n_"], "f_"}], 
              RowBox[{"\[PartialD]", 
                SuperscriptBox["x_", "n_"]}]], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", 
        " ", 
        TagBox[
          RowBox[{"D", "[", 
            RowBox[{"f_", ",", 
              RowBox[{"{", 
                RowBox[{"x_", ",", "n_"}], "}"}]}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]}], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell["You can now use these new notations for derivatives.", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    FractionBox[
      RowBox[{"\[PartialD]", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["y", "2"], "+", 
            RowBox[{"2", "y"}], "+", " ", 
            RowBox[{"Sin", "[", "y", "]"}], "+", 
            RowBox[{"f", "[", "y", "]"}]}], ")"}]}], 
      RowBox[{"\[PartialD]", "y"}]]], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"2", "+", 
      RowBox[{"2", " ", "y"}], "+", 
      RowBox[{"Cos", "[", "y", "]"}], "+", 
      FractionBox[
        RowBox[{"\[PartialD]", 
          RowBox[{"f", "[", "y", "]"}]}], 
        RowBox[{"\[PartialD]", "y"}]]}]], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],

Cell["\<\
You should define your notations in such a way that they both parse \
and format,  since users will generally expect this functionality.\
\>", \
"Text",
  Background->GrayLevel[1],
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[TextData[{
  "The following notation both formats and parses arrows overscripted by ",
  StyleBox["Apply", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"a_", " ", 
              OverscriptBox["\[LongRightArrow]", 
                RowBox[{" ", "Apply", " "}]], " ", "b_"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{"MyApply", "[", 
            RowBox[{"a_", ",", "b_"}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell["\<\
Simple rules like linearity can now be entered in a visually \
intuitive way.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"a_", " ", 
        OverscriptBox["\[LongRightArrow]", 
          RowBox[{" ", "Apply", " "}]], " ", 
        RowBox[{"(", 
          RowBox[{"b_", " ", "+", " ", "c_"}], ")"}]}], " ", ":=", " ", 
      RowBox[{
        RowBox[{"a", " ", 
          OverscriptBox["\[LongRightArrow]", 
            RowBox[{" ", "Apply", " "}]], " ", "b"}], " ", "+", " ", 
        RowBox[{"a", " ", 
          OverscriptBox["\[LongRightArrow]", 
            RowBox[{" ", "Apply", " "}]], " ", "c"}]}]}]], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a", 
      OverscriptBox["\[LongRightArrow]", 
        RowBox[{" ", "Apply", " "}]], 
      RowBox[{"(", 
        RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], "+", " ", 
          FractionBox[
            RowBox[{
              SuperscriptBox["\[PartialD]", "2"], 
              RowBox[{"f", "[", "x", "]"}]}], 
            RowBox[{"\[PartialD]", 
              SuperscriptBox["x", "2"]}]]}], ")"}]}]], "Input",
  CellLabel->"In[15]:=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"a", " ", 
          OverscriptBox["\[LongRightArrow]", 
            RowBox[{" ", "Apply", " "}]], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], " "}], "+", 
      RowBox[{
        RowBox[{"a", " ", 
          OverscriptBox["\[LongRightArrow]", 
            RowBox[{" ", "Apply", " "}]], " ", 
          FractionBox[
            RowBox[{
              SuperscriptBox["\[PartialD]", "2"], 
              RowBox[{"f", "[", "x", "]"}]}], 
            RowBox[{"\[PartialD]", 
              SuperscriptBox["x", "2"]}]]}], " "}]}]], "Output",
  CellLabel->"Out[15]=",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "You may at first feel that having underscores on both sides of a ",
  StyleBox["Notation", "MR"],
  " statement is somewhat unsettling.  However, notational transformations \
usually work in both directions, therefore having underscores on both sides \
of a notation statement is natural, and soon becomes intuitive."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolize", "SubsubsectionIcon",
  CellTags->{"Notation:S1", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Symbolize",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["compositeBoxes",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"treat", " "}],
                  SingleLetterItalics->False], 
                StyleBox["compositeBoxes",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"as", " ", "a", " ", "symbol"}]}],
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Symbolize",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["compositeBoxes",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"treat", " "}],
                  SingleLetterItalics->False], 
                StyleBox["compositeBoxes",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{
                    "as", " ", "a", " ", "symbol", " ", "with", " ", "the", 
                      " ", "options"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RemoveSymbolize",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["compositeBoxes",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{
                    RowBox[{
                    "remove", " ", "the", " ", "treatment", " ", "of"}], 
                    " "}],
                  SingleLetterItalics->False], 
                StyleBox["compositeBoxes",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"as", " ", "a", " ", "symbol"}]}],
                  SingleLetterItalics->False]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GeneratedCell->True,
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{
  "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize", 
    "NotationDocumentation"}],

Cell["Syntax of symbolization declarations.", "Caption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[TextData[{
  StyleBox["Symbolize", "MR"],
  " is used to treat a class of composite boxes internally as symbols. It is \
sometimes necessary and desirable to be able to symbolize composite objects; \
for example, to be able to attach rules to a composite object, it must be \
treated as a symbol."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell["\<\
This declares that the composite object \[ScriptCapitalD]\[ScriptO]\
\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD] should be treated as a \
symbol.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Symbolize", "[", 
      TagBox[
        TagBox[
          StyleBox[
            RowBox[{
            "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\
\[ScriptN]", "\[PartialD]"}],
            ZeroWidthTimes->True],
          DomainD],
        NotationBoxTag,
        TagStyle->"NotationTemplateStyle"], "]"}]], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[TextData[{
  "The package has created a ",
  StyleBox["FullForm", "MR"],
  " name for the composite symbol \[ScriptCapitalD]\[ScriptO]\[ScriptM]\
\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD]."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      TagBox[
        StyleBox[
          RowBox[{
          "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
", "\[PartialD]"}],
          ZeroWidthTimes->True],
        DomainD], 
      StyleBox[
        RowBox[{
          StyleBox["/",
            ZeroWidthTimes->True], "/"}]], "FullForm"}]], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
PartialD",
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[17]//FullForm=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}]
}, Closed]],

Cell["\<\
You can now attach rules to the composite symbol \[ScriptCapitalD]\
\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD].\
\>", \
"MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      TagBox[
        StyleBox[
          RowBox[{
          "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
", "\[PartialD]"}],
          ZeroWidthTimes->True],
        DomainD], "/:", 
      RowBox[{
        SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
        RowBox[{
          RowBox[{
            TagBox[
              StyleBox[
                RowBox[{
                "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\
\[ScriptN]", "\[PartialD]"}],
                ZeroWidthTimes->True],
              DomainD], "[", 
            RowBox[{"f_", ",", "x_"}], "]"}], 
          RowBox[{"\[CapitalDifferentialD]", "x_"}]}]}], " ", ":=", " ", 
      "f"}]], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[TextData[{
  "The above rule for \[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\
\[ScriptI]\[ScriptN]\[PartialD] is now tried before the rules of ",
  StyleBox["DomainIntegrals", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
      RowBox[{
        RowBox[{
          TagBox[
            StyleBox[
              RowBox[{
              "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\
\[ScriptN]", "\[PartialD]"}],
              ZeroWidthTimes->True],
            DomainD], " ", "[", 
          RowBox[{
            RowBox[{"\[Delta]", "[", "x", "]"}], ",", "x"}], "]"}], 
        RowBox[{"\[CapitalDifferentialD]", "x"}]}]}]], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"\[Delta]", "[", "x", "]"}]], "Output",
  CellLabel->"Out[19]=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  StyleBox["Symbolize", "MR"],
  " also symbolizes classes of expressions, for example, to symbolize all \
objects subscripted by ",
  StyleBox["Rule", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Symbolize", "[", 
      TagBox[
        SubscriptBox["expr_", "Rule"],
        NotationBoxTag,
        TagStyle->"NotationTemplateStyle"], "]"}]], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[TextData[{
  "Anything subscripted by ",
  StyleBox["Rule", "MR"],
  " is now treated as a symbol."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["MyDistribute", "Rule"], " ", "//", "FullForm"}]], "Input",\

  CellLabel->"In[21]:=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox["MyDistribute\[UnderBracket]Subscript\[UnderBracket]Rule",
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[21]//FullForm=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "You can use symbolized box structures as pattern variables in definitions. \
This lets you create formulas in a more familiar notation. However, you must \
use pattern expressions of the form ",
  StyleBox["CompositePatternVariable",
    FontSlant->"Italic"],
  " : ",
  StyleBox["PatternContent",
    FontSlant->"Italic"],
  " otherwise ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " may interpret the pattern expression as ",
  StyleBox["CompositePatternVariable",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      FormBox["\[Star]", TraditionalForm]]],
  " ",
  StyleBox["PatternContent",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell["\<\
This defines the transmission coefficient for an incident wave \
packet on a potential step under certain conditions.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Symbolize", "[", 
      TagBox[
        SubscriptBox["k", "_"],
        NotationBoxTag,
        TagStyle->"NotationTemplateStyle"], "]"}]], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"transmissionCoefficient", "[", 
        RowBox[{
          RowBox[{
            SubscriptBox["k", "1"], ":", "_"}], ",", 
          RowBox[{
            SubscriptBox["k", "2"], " ", ":", "_"}]}], "]"}], ":=", " ", 
      RowBox[{"1", "-", 
        FractionBox[
          RowBox[{"4", " ", 
            SubscriptBox["k", "1"], 
            SubscriptBox["k", "2"]}], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["k", "1"], "+", 
                SubscriptBox["k", "2"]}], ")"}], "2"]]}]}]], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Infix Notation", "SubsubsectionIcon",
  CellTags->{"Notation:S1", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["InfixNotation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["infixOp",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["prefixHead",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"treat", " "}],
                  SingleLetterItalics->False], 
                StyleBox["infixOp",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{
                    "as", " ", "an", " ", "infix", " ", "operator", " ", 
                      "representing", " ", "the", " ", "function"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["prefixHead",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["InfixNotation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["infixOp",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["prefixHead",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"treat", " "}],
                  SingleLetterItalics->False], 
                StyleBox["infixOp",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{
                    "as", " ", "an", " ", "infix", " ", "operator", " ", 
                      "representing", " ", "the", " ", "function"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["prefixHead",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"with", " ", "the", " ", "options"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RemoveInfixNotation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["infixOp",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["prefixHead",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{
                    RowBox[{
                    "remove", " ", "the", " ", "composite", " ", "infix", " ",
                       "operator"}], "  "}],
                  SingleLetterItalics->False], 
                StyleBox["infixOp",
                  FontSlant->"Italic"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GeneratedCell->True,
  GridBoxOptions->{ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Right, Left}},
  CellTags->{
  "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation", 
    "NotationDocumentation"}],

Cell["Syntax of infix notation declarations.", "Caption",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[TextData[{
  StyleBox["InfixNotation", "MR"],
  " is used to treat a composite box structure as an infix operator.  ",
  StyleBox["InfixNotation", "MR"],
  " requires both a composite box object which will represent the infix \
operator and a symbol which will be the full form head of the expression. A \
simple parallel of this duality in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is that the infix notation ",
  StyleBox["+", "MR"],
  " has the full form head ",
  StyleBox["Plus", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[TextData[{
  "This declares that the composite object ",
  Cell[BoxData[
      SubscriptBox["+", 
        RowBox[{"{", "}"}]]]],
  " should act as the infix form of ",
  StyleBox["Join", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"InfixNotation", "[", 
      RowBox[{
        TagBox[
          SubscriptBox["+", 
            RowBox[{"{", "}"}]],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], ",", 
        TagBox["Join",
          Identity]}], "]"}]], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], " ", 
      SubscriptBox["+", 
        RowBox[{"{", "}"}]], " ", 
      RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], " ", 
      SubscriptBox["+", 
        RowBox[{"{", "}"}]], " ", 
      RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}]}]], "Input",
  CellLabel->"In[24]:=",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
      "}"}]], "Output",
  CellLabel->"Out[24]=",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "The infix notation ",
  Cell[BoxData[
      SubscriptBox["+", 
        RowBox[{"{", "}"}]]]],
  " both parses input and formats output."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"HoldForm", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], " ", 
        SubscriptBox["+", 
          RowBox[{"{", "}"}]], " ", 
        RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}], " ", 
        SubscriptBox["+", 
          RowBox[{"{", "}"}]], " ", 
        RowBox[{"{", 
          RowBox[{"e", ",", "f"}], "}"}]}], "]"}]], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      RowBox[{
        RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], 
        SubscriptBox["+", 
          RowBox[{"{", "}"}]], 
        RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}], 
        SubscriptBox["+", 
          RowBox[{"{", "}"}]], 
        RowBox[{"{", 
          RowBox[{"e", ",", "f"}], "}"}]}],
      HoldForm]], "Output",
  CellLabel->"Out[25]=",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "An advantage of using ",
  StyleBox["InfixNotation", "MR"],
  " over that of using ",
  StyleBox["Notation", "MR"],
  " to define an infix operator is that ",
  StyleBox["InfixNotation", "MR"],
  " parses an expression into a flat internal form without evaluation. \
Although this is a subtle difference, it is an important one (see ",
  ButtonBox["ring operations",
    ButtonData:>{"Notation Documentation", "Ring Operations"},
    ButtonStyle->"DemosLink"],
  " and ",
  ButtonBox["parsing without evaluation",
    ButtonData:>{"Notation Documentation", "Parse without evaluation"},
    ButtonStyle->"DemosLink"],
  ".)"
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[TextData[{
  StyleBox["InfixNotation", "MR"],
  " parses input to a flat expression."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FullForm", " ", "[", 
      RowBox[{"Hold", "[", 
        RowBox[{"a", " ", 
          SubscriptBox["+", 
            RowBox[{"{", "}"}]], " ", "b", " ", 
          SubscriptBox["+", 
            RowBox[{"{", "}"}]], " ", "c", " ", 
          SubscriptBox["+", 
            RowBox[{"{", "}"}]], " ", "d"}], "]"}], "]"}]], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Hold", "[", 
          RowBox[{"Join", "[", 
            RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[26]//FullForm=",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "The function ",
  StyleBox["InfixNotation",
    FontFamily->"Courier"],
  " can be compared to using the infix form of functions ~",
  Cell[BoxData[
      FormBox["\[ScriptF]", TraditionalForm]]],
  "~ (cf. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Book  ",
  ButtonBox["2.1.3)",
    ButtonData:>{"2.1.3", "3.3"},
    ButtonStyle->"MainBookLink"]
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Entering Notations", "SubsubsectionIcon",
  CellTags->{"Notation:S1", "NotationDocumentation"}],

Cell[TextData[{
  "When defining your own notations it is ",
  StyleBox["critically",
    FontSlant->"Italic"],
  " important to use the ",
  ButtonBox["notation templates",
    ButtonData:>{
      FrontEnd`ToFileName[ {$TopDirectory, "AddOns", "ExtraPackages", 
        "Utilities", "Palettes", "English", "NotationPalette.nb"}], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->"Show Palette"],
  ". The notation templates are contained in the notation palette shown \
below."
}], "Text",
  CellTags->{
  "Must use palette", "Notation:Documentation:Entering Notations", 
    "Notation:S1", "Notation:S1.4", "NotationDocumentation"}],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonNote->"\[EscapeKey]note\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonNote->"\[EscapeKey]note>\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonNote->"\[EscapeKey]note<\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"Symbolize", "[", 
              TagBox["\[SelectionPlaceholder]",
                NotationBoxTag,
                TagStyle->"NotationTemplateStyle"], "]"}],
            ButtonNote->"\[EscapeKey]symb\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"InfixNotation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]"}],
               "]"}],
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]infixnote\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"AddInputAlias", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]"}],
               "]"}],
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]addia\[EscapeKey]"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"Full", " ", "Notation", " ", "Palette"}],
              FontFamily->"Helvetica",
              FontColor->GrayLevel[1]],
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`NotebookClose[ 
                  FrontEnd`ButtonNotebook[ ]], 
                FrontEnd`NotebookOpen[ 
                  
                  FrontEnd`ToFileName[ {$TopDirectory, "AddOns", 
                    "ExtraPackages", "Utilities", "Palettes", "English", 
                    "FullNotationPalette.nb"}]]}]&),
            ButtonStyle->None,
            Background->RGBColor[0.100008, 0.100008, 0.4],
            ButtonNote->"Switch to FullNotationPalette"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\[Placeholder]"]]], "Input",
  Editable->False,
  Active->True,
  Evaluatable->False,
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],

Cell[TextData[{
  "The reason for this restriction is that the templates pasted into a \
notebook contain essential tag boxes embedded in the correct way. These \
embedded tag boxes allow ",
  StyleBox["Notation", "MR"],
  " , ",
  StyleBox["Symbolize", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  " to properly group and parse the new notation being defined. Further, they \
allow these functions to get the styling information of the new notation so \
that the output is formatted with the same spacing, sizes, adjustments, etc. \
as the input."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],

Cell["A blank notation template looks like the following.", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox["\[Placeholder]",
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox["\[Placeholder]",
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],

Cell[TextData[{
  "Advanced note: You can circumvent using the notation palette by wrapping \
the corresponding literal box structures in a ",
  ButtonBox["NotationBoxTag[]",
    ButtonData:>{"Notation:Definition:NotationBoxTag", 
      "The tag NotationBoxTag"},
    ButtonStyle->"DemosLink"],
  "."
}], "Caption",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " it is possible to create input aliases for any notation or expression you \
want.  The normal interface to these input aliases is rather cumbersome and \
so the notation package contains the function ",
  StyleBox["AddInputAlias", "MR"],
  " to facilitate adding input aliases to the current notebook.  Each of the \
common templates has an alias associated with it for easy entry. For instance \
typing \[EscapeKey]",
  StyleBox["notation", "SR"],
  "\[EscapeKey] in an input cell will enter the notation template ",
  Cell[BoxData[
      StyleBox[
        RowBox[{"Notation", "[", 
          RowBox[{
            TagBox["\[Placeholder]",
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], " ", 
            "\[DoubleLongLeftRightArrow]", " ", 
            TagBox["\[Placeholder]",
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], "]"}],
        "Input"]]],
  StyleBox[".", "Input"]
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],

Cell["\<\
Add an input alias for apply statements to the current \
notebook.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"AddInputAlias", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"\[Placeholder]", " ", 
              OverscriptBox["\[LongRightArrow]", 
                RowBox[{" ", "Apply", " "}]], " ", "\[Placeholder]"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], ",", "\"\<apply\>\""}], 
      "]"}]], "Input",
  CellLabel->"In[27]:=",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],

Cell[TextData[{
  "Now that we have created this alias we can enter \"apply\" templates by \
simply typing \[EscapeKey]",
  StyleBox["apply", "SR"],
  "\[EscapeKey]."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Precedence of Operators in Notations", "SubsectionIcon",
  CellTags->"NotationDocumentation"],

Cell[CellGroupData[{

Cell["How Precedence is determined", "SubsubsectionIcon",
  CellTags->{"Notation:S2", "NotationDocumentation"}],

Cell[TextData[{
  "The precedence of any new notation or operator is determined by examining \
the components from which it is constructed. For instance, ",
  Cell[BoxData[
      SubscriptBox["+", "\[ScriptCapitalR]"]]],
  "  is grouped according to the precedence of +, the operator ",
  Cell[BoxData[
      SubscriptBox["\[CirclePlus]", "n"]]],
  "is grouped according to the precedence of ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[CirclePlus]", "\[Null]"], TraditionalForm]]],
  ", and the mapping ",
  Cell[BoxData[
      OverscriptBox["\[LongRightArrow]", 
        RowBox[{"  ", "myApply", "  "}]]]],
  " is grouped according to the precedence of \[LongRightArrow]. Generally \
the grouping behavior of positioning boxes is determined by the \"base \
element\". For instance, the expression ",
  StyleBox["SubscriptBox[", "MR"],
  StyleBox["symb",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["sub",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " is grouped according to ",
  StyleBox["symb",
    FontSlant->"Italic"],
  ". But for some other structural boxes the grouping behavior of surrounding \
elements is not affected by the behavior of the contents of the box. The \
precedence of compound objects is determined according to the following \
table"
}], "Text",
  CellTags->{
  "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
    "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"type", " ", "of", " ", "box"}],
              FontSlant->"Italic"], 
            StyleBox["behavior",
              FontSlant->"Italic"]},
          {
            StyleBox[
              RowBox[{
              "AdjustmentBox", ",", " ", "ErrorBox", ",", " ", "StyleBox", 
                ",", " ", "SubscriptBox", ",", " ", "SuperscriptBox", ",", 
                " ", "SubsuperscriptBox", ",", " ", "UnderscriptBox", ",", 
                "OverscriptBox", ",", " ", "UnderoverscriptBox", ",", " ", 
                "TagBox"}],
              "MR"], 
            StyleBox[
              RowBox[{
                RowBox[{
                "These", " ", "box", " ", "structures", " ", "do", " ", "not",
                   " ", "isolate", " ", "their", " ", "contents", " ", "from",
                   " ", "the", " ", "outside"}], ";", " ", 
                RowBox[{
                "the", " ", "contents", " ", "of", " ", "these", " ", "boxes",
                   " ", "can", " ", "affect", " ", "the", " ", "grouping", 
                  " ", "of", " ", "surrounding", " ", "elements"}]}],
              SingleLetterItalics->False]},
          {
            StyleBox[
              RowBox[{
              "ButtonBox", ",", " ", "FormBox", ",", " ", "FractionBox", ",", 
                "FrameBox", ",", " ", "GridBox", ",", " \t", 
                "InterpretationBox", ",", " ", "RowBox", ",", " ", 
                "RadicalBox", ",", " ", "SqrtBox"}],
              "MR"], 
            StyleBox[
              RowBox[{
                RowBox[{
                "These", " ", "box", " ", "structures", " ", "isolate", " ", 
                  "their", " ", "contents", " ", "from", " ", "the", " ", 
                  "outside"}], ";", " ", 
                RowBox[{
                "the", " ", "contents", " ", "of", " ", "these", " ", "boxes",
                   " ", "do", " ", "not", " ", "affect", " ", "the", " ", 
                  "grouping", " ", "of", " ", "surrounding", " ", 
                  "elements"}]}],
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->1.8,
  ColumnWidths->0.5,
  RowLines->{True, False}},
  CellTags->{
  "List of Boxes", "Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell["The standard boxes and their relationship to precedence.", "Caption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[TextData[{
  "The design decision of making the precedence of new compound operators \
correspond to their constituents makes intuitive sense and generally leads to \
notations that are consistent. For instance, consider a possible notation for \
addition and multiplication over a ring ",
  Cell[BoxData[
      RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"\[ScriptCapitalR]", ",", 
          RowBox[{
            SubscriptBox["+", "\[ScriptCapitalR]"], 
            RowBox[{",", 
              SubscriptBox["*", "\[ScriptCapitalR]"]}]}]}], 
        "\[RightAngleBracket]"}]]],
  "."
}], "Text",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell["\<\
This defines a notation for ring addition and ring \
multiplication.\
\>", "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[BoxData[{
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{"a_", " ", 
            SubscriptBox["+", "\[ScriptCapitalR]"], " ", "b_"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], "  ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"RingPlus", "[", 
              RowBox[{"a_", ",", "b_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"a_", " ", 
              SubscriptBox["*", "\[ScriptCapitalR]"], " ", "b_"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"RingTimes", "[", 
              RowBox[{"a_", ",", "b_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]}], "Input",
  CellLabel->"In[28]:=",
  CellTags->{
  "Ring Operations", "Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " now can parse and format expressions containing ring additions and \
multiplications."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"x", " ", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", 
      RowBox[{"y", " ", 
        SubscriptBox["*", "\[ScriptCapitalR]"], " ", "z"}]}]], "Input",
  CellLabel->"In[30]:=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"x", " ", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", 
      RowBox[{
        RowBox[{"y", " ", 
          SubscriptBox["*", "\[ScriptCapitalR]"], " ", "z"}], 
        " "}]}]], "Output",
  CellLabel->"Out[30]=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FullForm", " ", "@", " ", "%"}]], "Input",
  CellLabel->"In[31]:=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"RingPlus", "[", 
          RowBox[{"x", ",", 
            RowBox[{"RingTimes", "[", 
              RowBox[{"y", ",", "z"}], "]"}]}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[31]//FullForm=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "The ring multiplication operator ",
  Cell[BoxData[
      SubscriptBox["*", "\[ScriptCapitalR]"]]],
  " has a higher precedence than the ring addition operator ",
  Cell[BoxData[
      SubscriptBox["+", "\[ScriptCapitalR]"]]],
  " because ",
  StyleBox["*", "Input"],
  " has a higher precedence than ",
  StyleBox["+", "Input"],
  " . Moreover, the notation is automatically set up to parenthesize the \
expression appropriately to maintain the correct structure."
}], "Text",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell["\<\
The output has the correct formatting, styling, spacing, and \
parenthesization.\
\>", "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"RingTimes", "[", 
          RowBox[{
            RowBox[{"RingPlus", "[", 
              RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}],
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Input",
  CellLabel->"In[32]:=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"(", 
          RowBox[{"x", " ", 
            SubscriptBox["+", "\[ScriptCapitalR]"], " ", "y"}], ")"}], " ", 
        SubscriptBox["*", "\[ScriptCapitalR]"], " ", "z"}], " "}]], "Output",
  CellLabel->"Out[32]=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]],

Cell["\<\
However the above notation for ring addition and ring \
multiplication is still somewhat limited.\
\>", "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"RingPlus", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
  CellLabel->"In[33]:=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"RingPlus", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
  CellLabel->"Out[33]=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "The above ",
  StyleBox["Notation", "MR"],
  " statement can be removed and an ",
  StyleBox["InfixNotation", "MR"],
  " can be used instead."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[BoxData[{
    RowBox[{"RemoveNotation", "[", 
      RowBox[{
        TagBox[
          RowBox[{"a_", " ", 
            SubscriptBox["+", "\[ScriptCapitalR]"], " ", "b_"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], "  ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"RingPlus", "[", 
              RowBox[{"a_", ",", "b_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"RemoveNotation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"a_", " ", 
              SubscriptBox["*", "\[ScriptCapitalR]"], " ", "b_"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"RingTimes", "[", 
              RowBox[{"a_", ",", "b_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"InfixNotation", "[", 
      RowBox[{
        TagBox[
          SubscriptBox["+", "\[ScriptCapitalR]"],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], ",", 
        TagBox["RingPlus",
          Identity]}], "]"}], "\n", 
    RowBox[{"InfixNotation", "[", 
      RowBox[{
        TagBox[
          SubscriptBox["*", "\[ScriptCapitalR]"],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], ",", 
        TagBox["RingTimes",
          Identity]}], "]"}]}], "Input",
  CellLabel->"In[34]:=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[TextData[{
  "Now ",
  Cell[BoxData[
      SubscriptBox["+", "\[ScriptCapitalR]"]]],
  " and ",
  Cell[BoxData[
      SubscriptBox["*", "\[ScriptCapitalR]"]]],
  " act as true infix operators for ",
  StyleBox["RingPlus", "MR"],
  " and ",
  StyleBox["RingTimes", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", "b", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", "c", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", 
      RowBox[{"d", " ", 
        SubscriptBox["*", "\[ScriptCapitalR]"], " ", "e"}]}]], "Input",
  CellLabel->"In[38]:=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"a", 
      SubscriptBox["+", "\[ScriptCapitalR]"], "b", 
      SubscriptBox["+", "\[ScriptCapitalR]"], "c", 
      SubscriptBox["+", "\[ScriptCapitalR]"], 
      RowBox[{"d", 
        SubscriptBox["*", "\[ScriptCapitalR]"], "e"}]}]], "Output",
  CellLabel->"Out[38]=",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Parentheses in Notations", "SubsubsectionIcon",
  CellTags->{"Notation:S2", "NotationDocumentation"}],

Cell[TextData[{
  "It is important to point out that bracketing expressions by using ",
  StyleBox["{}", "MR"],
  ",",
  StyleBox["()", "MR"],
  ",",
  StyleBox["\[LeftAngleBracket]\[RightAngleBracket]", "MR"],
  ",",
  StyleBox["[]", "MR"],
  ",",
  StyleBox["|", "MR"],
  " or other braces in a notation not only changes the grouping of the \
notation but requires the brackets to be literally present in the input \
expression."
}], "Text",
  CellTags->{
  "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
    "NotationDocumentation"}],

Cell["The following defines a notation that uses parentheses.", "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          SubscriptBox[
            RowBox[{"(", "expr___", ")"}], "\[DoubleStruckCapitalS]"],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{"Semantic", "[", "expr___", "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[39]:=",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox[
        RowBox[{"(", 
          RowBox[{"a", ",", "b", ",", "c"}], ")"}], 
        "\[DoubleStruckCapitalS]"], "//", "FullForm"}]], "Input",
  CellLabel->"In[40]:=",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Semantic", "[", 
          RowBox[{"a", ",", "b", ",", "c"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[40]//FullForm=",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "Without parentheses input is not recognized as a ",
  StyleBox["Semantic", "MR"],
  " wrapper."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["H", "\[DoubleStruckCapitalS]"], " ", "//", 
      "FullForm"}]], "Input",
  CellLabel->"In[41]:=",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Subscript", "[", 
          RowBox[{"H", ",", "\[DoubleStruckCapitalS]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[41]//FullForm=",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Changing Precedences in Notations", "SubsubsectionIcon",
  CellTags->{"Notation:S2", "NotationDocumentation"}],

Cell[TextData[{
  "You can isolate the elements around an operator or expression by \
surrounding the operator or expression with a box structure that isolates its \
contents (cf. the ",
  ButtonBox["table above",
    ButtonData:>{"Notation:Documentation:Precedence", "List of Boxes"},
    ButtonStyle->"DemosLink"],
  "). The box structure typically used to do this encapsulation / isolation \
is the ",
  ButtonBox["TagBox",
    ButtonData:>"TagBox",
    ButtonStyle->"RefGuideLink",
    ButtonSource->ButtonData],
  ". Furthermore it is possible to change the precedence of an operator \
through the use of the ",
  StyleBox["TagBox", "MR"],
  " option ",
  ButtonBox["SyntaxForm",
    ButtonData:>{"Notation Documentation", 
      "Changing precedences and the option SyntaxForm"},
    ButtonStyle->"DemosLink"],
  ". More will be said on this later in the section ",
  StyleBox["Complex Patterns and Advanced Features",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{
  "Notation:S2", "Notation:S2.3", 
    "Notation:Documentation:Changing Precedences", "NotationDocumentation"}],

Cell[TextData[{
  "The underlying box structure of \[ScriptCapitalD]\[ScriptO]\[ScriptM]\
\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD] has an embedded ",
  StyleBox["TagBox", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ToBoxes", " ", "@", " ", 
      TagBox[
        StyleBox[
          RowBox[{
          "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
", "\[PartialD]"}],
          ZeroWidthTimes->True],
        DomainD]}]], "Input",
  CellLabel->"In[42]:=",
  CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"TagBox", "[", 
      RowBox[{
        RowBox[{"StyleBox", "[", 
          RowBox[{
            RowBox[{"RowBox", "[", 
              RowBox[{"{", 
                
                RowBox[{"\<\"\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\
\[ScriptI]\[ScriptN]\"\>", ",", "\<\"\[PartialD]\"\>"}], "}"}], "]"}], ",", 
            RowBox[{"ZeroWidthTimes", "\[Rule]", "True"}]}], "]"}], ",", 
        "DomainD"}], "]"}]], "Output",
  CellLabel->"Out[42]=",
  CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "The embedded ",
  StyleBox["TagBox", "MR"],
  " in ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
          "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
", "\[PartialD]"}],
          ZeroWidthTimes->True], TraditionalForm]]],
  " is necessary for several reasons: to contain the ",
  StyleBox["StyleBox", "MR"],
  " asserting ",
  StyleBox["ZeroWidthTimes", "MR"],
  ", to suppress the natural prefix operator grouping of ",
  Cell[BoxData[
      FormBox["\[PartialD]", TraditionalForm]]],
  ", and to allow the parsing and formatting rules to act on an encapsulated \
unit."
}], "Text",
  CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Options and Auxiliary Functions", "SubsectionIcon",
  CellTags->"NotationDocumentation"],

Cell[TextData[{
  StyleBox["Notation", "MR"],
  " , ",
  StyleBox["Symbolize", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  " have several options that modify their behavior. These notation functions \
all take the options ",
  StyleBox["WorkingForm", "MR"],
  " and ",
  StyleBox["Action", "MR"],
  ". In addition the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package has a local option ",
  StyleBox["AutoLoadNotationPalette", "MR"],
  " which affects the loading of the palette. Finally, the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package has a function which clears all notations, symbolizations, and \
infix notations defined so far."
}], "Text",
  CellTags->{
  "Notation:Documentation:Options", "Notation:S3", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[TextData[{
  "The option ",
  StyleBox["Action", "RM"]
}], "SubsubsectionIcon",
  CellTags->{"Notation:S3", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"option", " ", "name"}],
              FontSlant->"Italic"], 
            StyleBox[
              RowBox[{"possible", " ", "values"}],
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["Action",
              "MR"], 
            StyleBox["CreateNotationRules",
              "MR"], 
            StyleBox[
              RowBox[{
              "notations", " ", "are", " ", "entered", " ", "into", " ", 
                "the", " ", "system"}],
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["RemoveNotationRules",
              "MR"], 
            StyleBox[
              RowBox[{
              "notations", " ", "are", " ", "removed", " ", "from", " ", 
                "the", " ", "system"}],
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["PrintNotationRules",
              "MR"], 
            StyleBox[
              RowBox[{
              "cells", " ", "containing", " ", "the", " ", "rules", " ", 
                "defining", " ", "the", " ", "given", " ", "notation", " ", 
                "are", " ", "pasted", " ", "into", " ", "the", " ", "current",
                 " ", "notebook"}],
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{True, False}},
  CellTags->{
  "Notation:Definition:Action", "Notation:S3", "Notation:S3.1", 
    "NotationDocumentation"}],

Cell[TextData[{
  "The ",
  StyleBox["Action", "MR"],
  " option and  its possible values."
}], "Caption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[TextData[{
  "The ",
  StyleBox["Notation", "MR"],
  ", ",
  StyleBox["Symbolize", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  " option ",
  StyleBox["Action", "MR"],
  " determines what a notation statement does with the rules it generates. \
The default value of the ",
  StyleBox["Action", "MR"],
  " option is ",
  StyleBox["CreateNotationRules", "MR"],
  ", which causes the generated notation rules to be entered into the \
system."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell["\<\
This creates a notation for pure functions more in keeping with \
that of traditional mathematics.\
\>", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        RowBox[{
          TagBox[
            RowBox[{" ", 
              SubscriptBox[
                RowBox[{"(", 
                  RowBox[{"x_", " ", 
                    StyleBox["\[RightTeeArrow]",
                      SpanMinSize->1], " ", "body_"}], ")"}], "&"], " "}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"], " ", 
          "\[DoubleLongLeftRightArrow]", " ", 
          TagBox[
            RowBox[{"Function", "[", 
              RowBox[{"x_", ",", "body_"}], "]"}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"]}], " ", ",", "\n", "\t    ", 
        RowBox[{"Action", " ", "\[Rule]", " ", "CreateNotationRules"}]}], 
      "]"}]], "Input",
  CellLabel->"In[43]:=",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell["Pure functions now use this new notation.", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
        RowBox[{
          SuperscriptBox["x", "2"], "+", "1"}]}], "]"}]], "Input",
  CellLabel->"In[44]:=",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{" ", 
      SubscriptBox[
        RowBox[{"(", 
          RowBox[{"x", " ", 
            StyleBox["\[RightTeeArrow]",
              SpanMinSize->1], " ", 
            RowBox[{
              SuperscriptBox["x", "2"], "+", "1"}]}], ")"}], "&"], 
      " "}]], "Output",
  CellLabel->"Out[44]=",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "If the ",
  StyleBox["Action", "MR"],
  " option is set to ",
  StyleBox["RemoveNotationRules", "MR"],
  ", then the notation rules are removed from the system. Using the option \
value ",
  StyleBox["RemoveNotationRules", "MR"],
  " in a notation statement is equivalent to using the appropriate ",
  StyleBox["RemoveNotation", "MR"],
  ", ",
  StyleBox["RemoveSymbolize", "MR"],
  " or ",
  StyleBox["RemoveInfixNotation", "MR"],
  " statement."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell["This removes the above notation from the system.", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        RowBox[{
          TagBox[
            RowBox[{" ", 
              SubscriptBox[
                RowBox[{"(", 
                  RowBox[{"x_", " ", 
                    StyleBox["\[RightTeeArrow]",
                      SpanMinSize->1], " ", "body_"}], ")"}], "&"], " "}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"], " ", 
          "\[DoubleLongLeftRightArrow]", " ", 
          TagBox[
            RowBox[{"Function", "[", 
              RowBox[{"x_", ",", "body_"}], "]"}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"]}], " ", ",", "\n", "\t    ", 
        RowBox[{"Action", " ", "\[Rule]", " ", "RemoveNotationRules"}]}], 
      "]"}]], "Input",
  CellLabel->"In[45]:=",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell["Now the special notation for functions is no longer defined.", \
"MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
        RowBox[{
          SuperscriptBox["x", "2"], "+", "1"}]}], "]"}]], "Input",
  CellLabel->"In[46]:=",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
        RowBox[{
          SuperscriptBox["x", "2"], "+", "1"}]}], "]"}]], "Output",
  CellLabel->"Out[46]=",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "By setting the option ",
  StyleBox["Action", "MR"],
  " to ",
  StyleBox["PrintNotationRules", "MR"],
  ", you can view the rules generated by a notation statement. Examining the \
",
  StyleBox["MakeExpression", "MR"],
  " and ",
  StyleBox["MakeBoxes", "MR"],
  " rules is often useful to give you an idea of the underlying box \
structures that are used in your notation statement."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[TextData[{
  "This prints the ",
  StyleBox["MakeExpression", "MR"],
  " and ",
  StyleBox["MakeBoxes", "MR"],
  " rules corresponding to the given ",
  StyleBox["Notation", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        RowBox[{
          TagBox[
            RowBox[{" ", 
              SubscriptBox[
                RowBox[{"(", 
                  RowBox[{"x_", " ", 
                    StyleBox["\[RightTeeArrow]",
                      SpanMinSize->1], " ", "body_"}], ")"}], "&"], " "}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"], " ", 
          "\[DoubleLongLeftRightArrow]", " ", 
          TagBox[
            RowBox[{"Function", "[", 
              RowBox[{"x_", ",", "body_"}], "]"}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"]}], " ", ",", "\n", "\t    ", 
        RowBox[{"Action", " ", "\[Rule]", " ", "PrintNotationRules"}]}], 
      "]"}]], "Input",
  CellLabel->"In[47]:=",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeExpression", "[", 
        RowBox[{
          RowBox[{"SubscriptBox", "[", 
            RowBox[{
              RowBox[{"RowBox", "[", 
                RowBox[{"{", 
                  RowBox[{"\"\<(\>\"", ",", 
                    RowBox[{"RowBox", "[", 
                      RowBox[{"{", 
                        RowBox[{
                        "x_", ",", "\"\<\[RightTeeArrow]\>\"", ",", "body_"}],
                         "}"}], "]"}], ",", "\"\<)\>\""}], "}"}], "]"}], ",", 
              "\"\<&\>\""}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
      RowBox[{"MakeExpression", "[", 
        RowBox[{
          RowBox[{"RowBox", "[", 
            RowBox[{"{", 
              RowBox[{"\"\<Function\>\"", ",", "\"\<[\>\"", ",", 
                RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                    RowBox[{"x", ",", "\"\<,\>\"", ",", "body"}], "}"}], 
                  "]"}], ",", "\"\<]\>\""}], "}"}], "]"}], ",", 
          "StandardForm"}], "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeBoxes", "[", 
        RowBox[{
          RowBox[{"Function", "[", 
            RowBox[{"x_", ",", "body_"}], "]"}], ",", "StandardForm"}], "]"}],
       ":=", 
      RowBox[{"RowBox", "[", 
        RowBox[{"{", 
          RowBox[{"\"\< \>\"", ",", 
            RowBox[{"SubscriptBox", "[", 
              RowBox[{
                RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                    RowBox[{"\"\<(\>\"", ",", 
                      RowBox[{"RowBox", "[", 
                        RowBox[{"{", 
                          RowBox[{
                            RowBox[{"Parenthesize", "[", 
                              RowBox[{
                              "x", ",", "StandardForm", ",", 
                                "RightTeeArrow"}], "]"}], ",", "\"\< \>\"", 
                            ",", 
                            RowBox[{"StyleBox", "[", 
                              RowBox[{"\"\<\[RightTeeArrow]\>\"", ",", 
                                RowBox[{"SpanMinSize", "\[Rule]", "1.`"}]}], 
                              "]"}], ",", "\"\< \>\"", ",", 
                            RowBox[{"Parenthesize", "[", 
                              RowBox[{
                              "body", ",", "StandardForm", ",", 
                                "RightTeeArrow"}], "]"}]}], "}"}], "]"}], 
                      ",", "\"\<)\>\""}], "}"}], "]"}], ",", "\"\<&\>\""}], 
              "]"}], ",", "\"\< \>\""}], "}"}], "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The option ",
  StyleBox["WorkingForm", "RM"]
}], "SubsubsectionIcon",
  CellTags->{"Notation:S3", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"option", " ", "name"}],
              "Text",
              FontSlant->"Italic"], 
            StyleBox[
              RowBox[{"possible", " ", "values"}],
              "Text",
              FontSlant->"Italic"], 
            StyleBox["effect",
              "Text",
              FontSlant->"Italic"]},
          {
            StyleBox["WorkingForm",
              "MR"], 
            StyleBox["StandardFrom",
              "MR"], 
            RowBox[{
              StyleBox["notations",
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["symbolizations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["infix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["notations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["defined",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["StandardForm",
                  "MR"]}]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["TraditionalForm",
              "MR"], 
            RowBox[{
              StyleBox["notations",
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["symbolizations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["infix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["notations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["defined",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["TraditionalForm",
                  "MR"]}]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Automatic",
              "MR"], 
            RowBox[{
              StyleBox["notations",
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["symbolizations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["infix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["notations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["defined",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["DefaultOutputFormatType",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.2, 0.25, 0.55},
  RowLines->{True, False}},
  CellTags->{
  "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2", 
    "NotationDocumentation"}],

Cell[TextData[{
  "The ",
  StyleBox["WorkingForm", "MR"],
  " option and some of  its possible values."
}], "Caption",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell[TextData[{
  "The option ",
  StyleBox["WorkingForm", "MR"],
  " specifies the ",
  StyleBox["form",
    FontSlant->"Italic"],
  " or ",
  StyleBox["environment",
    FontSlant->"Italic"],
  " the ",
  StyleBox["Notation", "MR"],
  ", ",
  StyleBox["Symbolize", "MR"],
  " or ",
  StyleBox["InfixNotation", "MR"],
  " statement is generated in. The typical values of ",
  StyleBox["WorkingForm", "MR"],
  " are ",
  StyleBox["StandardForm", "MR"],
  " or ",
  StyleBox["TraditionalForm", "MR"],
  "; any notations created would only apply in ",
  StyleBox["StandardForm", "MR"],
  " or ",
  StyleBox["TraditionalForm", "MR"],
  " (respectively). However, ",
  StyleBox["WorkingForm", "MR"],
  " can be set to any form you define, for instance ",
  StyleBox["LogicForm", "MR"],
  ", ",
  StyleBox["PhysicsForm", "MR"],
  " etc."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell[TextData[{
  "When the option ",
  StyleBox["WorkingForm", "MR"],
  " is set to ",
  StyleBox["Automatic", "MR"],
  " the ",
  StyleBox["Notation", "MR"],
  ", ",
  StyleBox["Symbolize", "MR"],
  " or ",
  StyleBox["InfixNotation", "MR"],
  " statement will be created in the ",
  StyleBox["DefaultOutputFormatType", "MR"],
  ". This form is show in the menu item ",
  StyleBox["Default Output Format Type",
    FontFamily->"Helvetica"],
  " under the menu ",
  StyleBox["Cell",
    FontFamily->"Helvetica"],
  "."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell[TextData[{
  "This creates ",
  StyleBox["TraditionalForm", "MR"],
  " notations for the vector calculus functions ",
  StyleBox["Div", "MR"],
  ", ",
  StyleBox["Curl", "MR"],
  " and the wrapper ",
  StyleBox["Vector", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell[BoxData[{
    FormBox[
      RowBox[{"Notation", "[", " ", 
        RowBox[{
          RowBox[{
            TagBox[
              RowBox[{"\[Del]", 
                RowBox[{".", "a_"}]}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], "  ", 
            "\[DoubleLongLeftRightArrow]", "  ", 
            TagBox[
              RowBox[{"Div", "[", "a_", "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], " ", ",", 
          RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], 
        "]"}], TraditionalForm], "\n", 
    FormBox[
      FormBox[
        RowBox[{"Notation", "[", " ", 
          RowBox[{
            RowBox[{
              TagBox[
                RowBox[{"\[Del]", 
                  RowBox[{"\[Cross]", " ", "a__"}]}],
                NotationBoxTag,
                TagStyle->"NotationTemplateStyle"], "  ", 
              "\[DoubleLongLeftRightArrow]", "  ", 
              TagBox[
                RowBox[{"Curl", "[", "a__", "]"}],
                NotationBoxTag,
                TagStyle->"NotationTemplateStyle"]}], " ", ",", 
            RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}],
           "]"}],
        "TraditionalForm"], TraditionalForm], "\n", 
    FormBox[
      RowBox[{"Notation", "[", "  ", 
        RowBox[{
          RowBox[{
            TagBox[
              OverscriptBox["a_", "\[RightVector]"],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], "  ", 
            "\[DoubleLongLeftRightArrow]", "  ", 
            TagBox[
              RowBox[{"Vector", "[", "a_", "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], " ", ",", 
          RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], 
        "]"}], TraditionalForm]}], "Input",
  CellLabel->"In[48]:=",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell["These notations behave as expected.", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Del]", 
          RowBox[{"\[Cross]", " ", 
            OverscriptBox["a", "\[RightVector]"]}]}], " ", "//", 
        "TraditionalForm"}], TraditionalForm]], "Input",
  CellLabel->"In[51]:=",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Del]", 
        RowBox[{"\[Cross]", " ", 
          OverscriptBox["a", "\[RightVector]"]}]}], 
      TraditionalForm]], "Output",
  CellLabel->"Out[51]//TraditionalForm=",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FullForm", " ", "@", " ", "%"}]], "Input",
  CellLabel->"In[52]:=",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Curl", "[", 
          RowBox[{"Vector", "[", "a", "]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[52]//FullForm=",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Del]", 
          RowBox[{".", 
            RowBox[{"\[Del]", 
              RowBox[{"\[Cross]", " ", 
                OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
                OverscriptBox["b", "\[RightVector]"]}]}]}]}], " ", "+", " ", 
        RowBox[{"\[Del]", 
          RowBox[{".", 
            RowBox[{"(", 
              RowBox[{
                OverscriptBox["a", "\[RightVector]"], "+", 
                OverscriptBox["b", "\[RightVector]"]}], ")"}]}]}]}], 
      TraditionalForm]], "Input",
  CellLabel->"In[53]:=",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"Div", "[", 
        RowBox[{"Curl", "[", 
          RowBox[{
            RowBox[{"Vector", "[", "a", "]"}], "\[Cross]", 
            RowBox[{"Vector", "[", "b", "]"}]}], "]"}], "]"}], "+", 
      RowBox[{"Div", "[", 
        RowBox[{
          RowBox[{"Vector", "[", "a", "]"}], "+", 
          RowBox[{"Vector", "[", "b", "]"}]}], "]"}]}]], "Output",
  CellLabel->"Out[53]=",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The option ",
  StyleBox["AutoLoadNotationPalette", "RM"]
}], "SubsubsectionIcon",
  CellTags->{"Notation:S3", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              "Text",
              FontSlant->"Italic"], 
            StyleBox[
              RowBox[{"possible", " ", "values"}],
              "Text",
              FontSlant->"Italic"], 
            StyleBox["effect",
              "Text",
              FontSlant->"Italic"]},
          {
            StyleBox["AutoLoadNotationPalette",
              "MR"], 
            StyleBox[
              RowBox[{
                StyleBox["True",
                  "MR"], 
                StyleBox[
                  RowBox[{",", " "}],
                  SingleLetterItalics->False], 
                StyleBox["undefined",
                  FontSlant->"Italic"]}],
              "Text"], 
            RowBox[{
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["notation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["palette",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["will",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["loaded",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["when",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Notation",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["package",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["loads",
                SingleLetterItalics->False]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              "MR"], 
            RowBox[{
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["notation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["palette",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["will",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["not",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["loaded",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["when",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Notation",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["package",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["loads",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GeneratedCell->True,
  GridBoxOptions->{ColumnWidths->{0.29, 0.27, 0.44},
  RowLines->{True, False}},
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],

Cell["The option AutoLoadNotationPalette and its behavior.", "Caption",
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],

Cell[TextData[{
  "If you are designing a package you may want to hide the ",
  ButtonBox["notation palette",
    ButtonData:>{
      FrontEnd`ToFileName[ {$TopDirectory, "AddOns", "ExtraPackages", 
        "Utilities", "Palettes", "English", "NotationPalette.nb"}], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->"Show Palette"],
  " when the user loads the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package so as not to confuse them. You can set the boolean variable ",
  StyleBox["AutoLoadNotationPalette", "MR"],
  " inside your package to achieve this. If ",
  StyleBox["AutoLoadNotationPalette", "MR"],
  " has been set to ",
  StyleBox["False", "MR"],
  " then the notation palette will not be loaded when the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package is loaded. If the value is undefined or ",
  StyleBox["True", "MR"],
  ", the notation palette will be loaded when the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package loads. In input form the statement would look like the \
following."
}], "text",
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],

Cell[TextData[{
  "Statement forcing the notation palette not to load when the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package loads."
}], "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
    "Utilities`Notation`AutoLoadNotationPalette", " ", "=", " ", 
      "False"}]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The function ",
  StyleBox["ClearNotations[]", "RM"]
}], "SubsubsectionIcon",
  CellTags->{"Notation:S3", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox[
                RowBox[{"ClearNotations", 
                  StyleBox["[",
                    "MR"], 
                  StyleBox["]",
                    "MR"]}],
                "TraditionalForm"],
              "MR"], 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{"ClearNotations", "[", "]"}],
                  "MR"], " ", 
                StyleBox[
                  RowBox[{"c", 
                    StyleBox["lears",
                      SingleLetterItalics->False]}]], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["notations",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                "symbolizations", " ", "and", " ", "infix", " ", 
                  "notations"}],
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.29, 0.71},
  ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],

Cell["Syntax of clear notations.", "Caption",
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],

Cell[TextData[{
  "If you would like to re-enter a set of notations or would like to make a \
\"clean start\" you can use the ",
  StyleBox["ClearNotations[]", "MR"],
  " command to erase all notations, symbolizations and infix notations \
present in the system. Using ",
  StyleBox["ClearNotations[]", "MR"],
  " should not affect other packages or definitions you have made to ",
  StyleBox["MakeExpression", "MR"],
  " or ",
  StyleBox["MakeBoxes", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],

Cell["Wipe all notations, symbolizations and infix notations.", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"ClearNotations", "[", "]"}]], "Input",
  CellLabel->"In[54]:=",
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Complex Patterns and Advanced Features", "SubsectionIcon",
  CellTags->"NotationDocumentation"],

Cell["This section is intended for advanced users.", "Subsubsection",
  CellGroupingRules->"NormalGrouping",
  CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"}],

Cell[TextData[{
  "Due to the complex inner workings of the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package it is helpful to outline some of the more advanced features and \
structures of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end and how they relate to the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package. The following sections give a small overview of the \
functionality of tag boxes the specific tags used by the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package and the tag box option SyntaxForm."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.1", "Notation:Documentation:Advanced Features", 
    "NotationDocumentation"}],

Cell[TextData[{
  "The reader should be familiar with the concepts in section ",
  ButtonBox["2.9 Textual Input and Output",
    ButtonData:>{"2.9", None},
    ButtonStyle->"MainBookLink"],
  " and moreover understand the following sections: ",
  ButtonBox["2.9.3 The Representation of Textual Forms",
    ButtonData:>{"2.9.3", None},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["2.9.4 The Interpretation of Textual Forms",
    ButtonData:>{"2.9.4", None},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["2.9.10 Representing Textual Forms by Boxes",
    ButtonData:>{"2.9.10", None},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["2.9.12 String Representation of Boxes",
    ButtonData:>{"2.9.12", None},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["2.9.13 Converting between Strings, Boxes, and Expressions",
    ButtonData:>{"2.9.13", None},
    ButtonStyle->"MainBookLink"],
  ", and ",
  ButtonBox["2.9.17 Advanced Topic: Low-Level Input and Output Rules",
    ButtonData:>{"2.9.17", None},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text",
  CellTags->"NotationDocumentation"],

Cell[CellGroupData[{

Cell["Tag boxes", "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],

Cell[TextData[{
  "A ",
  StyleBox["TagBox", "MR"],
  " is a box structure just like",
  Cell[BoxData[
      RowBox[{" ", 
        ButtonBox["RowBox",
          ButtonData:>"RowBox",
          ButtonStyle->"RefGuideLink",
          ButtonSource->ButtonData]}]]],
  ", ",
  ButtonBox["SubscriptBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["GridBox",
    ButtonStyle->"RefGuideLink"],
  ". It is used to change the structure of an expression or indicate a \
grouping or interpretation of a subexpression at an underlying level. To \
illustrate tag boxes consider the following input which contains an embedded \
",
  StyleBox["TagBox", "MR"],
  "."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
    "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      SuperscriptBox["x", "2"],
      foo]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[TextData[{
  "All ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input and output is made up of box structures at a low level. When ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " receives input, these box structures are parsed into internal \
expressions, which can be thought of as full form expressions. Internal \
evaluation then takes place, and finally the internal structures are \
transformed back into box structures for displaying in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end.We can reveal how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sees this input at a low level by using the ",
  StyleBox["Show Expression",
    FontFamily->"Helvetica"],
  " command under the ",
  StyleBox["Format",
    FontFamily->"Helvetica"],
  " menu."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[TextData[{
  "Here is the underlying representation of the expression above in terms of \
boxes, displayed using the ",
  StyleBox["Show Expression", "SR"],
  " menu item located under the ",
  StyleBox["Format", "SR"],
  " menu. "
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      SuperscriptBox["x", "2"],
      foo]], "Input"],

Cell[TextData[{
  "The above expression contains a subexpression ",
  StyleBox["TagBox[SuperscriptBox[\"x\", \"2\"],foo]]", "MR"],
  ". It is important to note that this box expression as normally viewed in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks visually like ",
  Cell[BoxData[
      TagBox[
        SuperscriptBox["x", "2"],
        foo]]],
  " even though it has an embedded ",
  StyleBox["TagBox", "MR"],
  ". Information contained in the tag is visually hidden from the user. When \
an expression containing a ",
  StyleBox["TagBox", "MR"],
  " is input into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " the default interpretation of the subexpression surrounded by the ",
  StyleBox["TagBox", "MR"],
  " is to wrap the ",
  StyleBox["TagBox", "MR"],
  " name around the parsed subexpression, in this case to wrap foo around \
x^2."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[TextData[{
  "The embedded ",
  StyleBox["TagBox", "MR"],
  " tag ",
  StyleBox["foo", "MR"],
  " has no special parsing behavior associated with it."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    TagBox[
      SuperscriptBox["x", "2"],
      foo]], "Input",
  CellLabel->"In[55]:=",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"foo", "[", 
      SuperscriptBox["x", "2"], "]"}]], "Output",
  CellLabel->"Out[55]=",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "However you can define your own rules for the way specific tag boxes are \
parsed. For instance by using the low level function ",
  StyleBox["MakeExpression", "MR"],
  " we can change how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will parse expressions containing ",
  StyleBox["TagBoxes", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[TextData[{
  "By defining a new rule for ",
  StyleBox["MakeExpression", "MR"],
  " we can change how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will parse expressions containing a ",
  StyleBox["TagBox", "MR"],
  " with the tag ",
  StyleBox["literalBoxes", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"MakeExpression", "[", 
        RowBox[{
          RowBox[{"TagBox", "[", 
            RowBox[{"expr_", ",", "literalBoxes"}], "]"}], ",", "form_"}], 
        "]"}], ":=", 
      RowBox[{"HoldComplete", "[", "expr", "]"}]}]], "Input",
  CellLabel->"In[56]:=",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[TextData[{
  "The embedded ",
  StyleBox["TagBox", "MR"],
  " tag ",
  StyleBox["literalBoxes", "MR"],
  " now has the special parsing behavior associated with it to just return \
the boxes."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    TagBox[
      SuperscriptBox["x", "2"],
      literalBoxes]], "Input",
  CellLabel->"In[57]:=",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"SuperscriptBox", "[", 
      RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}]], "Output",
  CellLabel->"Out[57]=",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "Knowing that special behaviors can be set up for specific tags we can now \
examine the tags defined by the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package. The ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package defines three tags that have special behaviors: ",
  StyleBox["NotationBoxTag", "MR"],
  ", ",
  StyleBox["NotationPatternTag", "MR"],
  ", and ",
  StyleBox["NotationMadeBoxesTag", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The tag ",
  StyleBox["NotationBoxTag", "RM"]
}], "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],

Cell[TextData[{
  StyleBox["NotationBoxTag", "MR"],
  " is a tag used by the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package to grab box structures before they can be parsed by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". In fact ",
  StyleBox["NotationBoxTag", "MR"],
  " acts rather like the tag ",
  StyleBox["literalBoxes", "MR"],
  " defined above. All ",
  StyleBox["Notation", "MR"],
  " , ",
  StyleBox["Symbolize", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  " templates on the ",
  ButtonBox["notation palette",
    ButtonData:>{
      FrontEnd`ToFileName[ {$TopDirectory, "AddOns", "ExtraPackages", 
        "Utilities", "Palettes", "English", "NotationPalette.nb"}], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->"Show Palette"],
  " contain tag boxes with an embedded ",
  StyleBox["NotationBoxTag", "MR"],
  ". The embedded ",
  StyleBox["TagBox", "MR"],
  " ensures that the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package can obtain the correct parsing information and retain the proper \
styling and grouping information."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag", 
    "NotationDocumentation"}],

Cell[TextData[{
  "An expression containing an embedded ",
  StyleBox["NotationBoxTag", "MR"],
  " tag."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      TagBox[
        SuperscriptBox["x", "2"],
        NotationBoxTag,
        TagStyle->"NotationTemplateStyle"], "//", "FullForm"}]], "Input",
  CellLabel->"In[58]:=",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"NotationBoxTag", "[", 
          RowBox[{"SuperscriptBox", "[", 
            RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[58]//FullForm=",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "We can avoid using notation templates if we wrap raw box structures with a \
",
  StyleBox["NotationBoxTag", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Symbolize", "[", " ", 
      RowBox[{"NotationBoxTag", " ", "[", " ", 
        RowBox[{"SubscriptBox", "[", 
          RowBox[{"\"\<fub\>\"", ",", "\"\<_\>\""}], "]"}], " ", "]"}], " ", 
      "]"}]], "Input",
  CellLabel->"In[59]:=",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["fub", "1"], "//", "FullForm"}]], "Input",
  CellLabel->"In[60]:=",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox["fub\[UnderBracket]Subscript\[UnderBracket]1",
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[60]//FullForm=",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Complex Patterns and the tag ",
  StyleBox["NotationPatternTag", "RM"]
}], "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],

Cell[TextData[{
  "For normal purposes it is usually sufficient that the patterns present in \
",
  StyleBox["Notation", "MR"],
  " and ",
  StyleBox["Symbolize", "MR"],
  " statements are simple patterns. However, it is sometimes necessary or \
desirable to use more complicated patterns in notations. For example, a \
notation might only be valid when a certain pattern is a number. To allow \
more complex patterns you can embed a ",
  StyleBox["NotationPatternTag", "MR"],
  " tag box inside a notation statement. It is critical that any notation you \
define which uses a complex pattern has an embedded ",
  StyleBox["NotationPatternTag", "MR"],
  ", otherwise the pattern will be treated as a verbatim expression and not \
function as a pattern.  The notation palette has a button labeled \
InsertPatternWrapper which will embed a ",
  StyleBox["NotationPatternTag", "MR"],
  " around the selection, as well as tint the background of the selection to \
indicate that a complex pattern is present."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag", 
    "NotationDocumentation"}],

Cell[TextData[{
  "This creates a ",
  StyleBox["TraditionalForm", "MR"],
  " notation that only functions with numbers."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[
      RowBox[{"Notation", "[", 
        RowBox[{
          RowBox[{
            TagBox[
              SubscriptBox["\[CapitalGamma]", 
                TagBox[
                  RowBox[{"a_", "?", "StringNumericQ"}],
                  NotationPatternTag,
                  TagStyle->"NotationPatternWrapperStyle"]],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], " ", 
            "\[DoubleLongLeftRightArrow]", " ", 
            TagBox[
              RowBox[{"foo", "[", 
                TagBox[
                  RowBox[{"a_", "?", "NumericQ"}],
                  NotationPatternTag,
                  TagStyle->"NotationPatternWrapperStyle"], "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], ",", " ", 
          RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], 
        "]"}], TraditionalForm]], "Input",
  CellLabel->"In[61]:=",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell["\<\
It must also be pointed out that the pattern matching on the \
external representation is performed on the box structures, so usually you \
will have to make small transformations to convert box structures into normal \
expressions. Pattern matching on the internal representation follows \
conventional pattern matching.\
\>", "Text",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell["\<\
This defines a function analogous to NumericQ that operates on box \
structures.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"StringNumericQ", " ", "[", " ", "any___", "]"}], " ", ":=", 
      " ", 
      RowBox[{"NumericQ", " ", "[", " ", 
        RowBox[{"ToExpression", " ", "[", " ", "any", "]"}], "]"}]}]], "Input",\

  CellLabel->"In[62]:=",
  CellTags->{
  "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
    "NotationDocumentation"}],

Cell["\<\
Now only input which matches the above pattern will be interpreted \
as a foo object.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["\[CapitalGamma]", "\[Pi]"], " ", "+", 
        SubscriptBox["\[CapitalGamma]", "h"]}], TraditionalForm]], "Input",
  CellLabel->"In[63]:=",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"foo", "[", "\[Pi]", "]"}], "+", 
      SubscriptBox["\[CapitalGamma]", "h"]}]], "Output",
  CellLabel->"Out[63]=",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}]
}, Closed]],

Cell["\<\
Reciprocally only foo objects with numerical arguments will be \
formatted using the notation.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"foo", "[", "\[Pi]", "]"}], "+", 
        RowBox[{"foo", "[", "h", "]"}]}], " ", "//", 
      "TraditionalForm"}]], "Input",
  CellLabel->"In[64]:=",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"foo", 
          RowBox[{"(", "h", ")"}]}], "+", 
        SubscriptBox["\[CapitalGamma]", "\[Pi]"]}], 
      TraditionalForm]], "Output",
  CellLabel->"Out[64]//TraditionalForm=",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "You should be careful to avoid unwanted evaluation through testing \
functions when parsing expressions (see ",
  ButtonBox["parsing without evaluation",
    ButtonData:>{"Notation Documentation", "Parse without evaluation"},
    ButtonStyle->"DemosLink"],
  ".)"
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[TextData[{
  "We can examine the form of the rules created by using the option ",
  StyleBox["Action", "MR"],
  " \[Rule] ",
  StyleBox["PrintNotationRules", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{"Notation", "[", 
        RowBox[{
          RowBox[{
            TagBox[
              SubscriptBox["\[CapitalGamma]", 
                TagBox[
                  RowBox[{"a_", "?", "StringNumericQ"}],
                  NotationPatternTag,
                  TagStyle->"NotationPatternWrapperStyle"]],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], " ", 
            "\[DoubleLongLeftRightArrow]", " ", 
            TagBox[
              RowBox[{"foo", "[", 
                TagBox[
                  RowBox[{"a_", "?", "NumericQ"}],
                  NotationPatternTag,
                  TagStyle->"NotationPatternWrapperStyle"], "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], ",", " ", 
          RowBox[{"Action", " ", "\[Rule]", " ", "PrintNotationRules"}]}], 
        "]"}], TraditionalForm]], "Input",
  CellLabel->"In[65]:=",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeExpression", "[", 
        RowBox[{
          RowBox[{"SubscriptBox", "[", 
            RowBox[{"\"\<\[CapitalGamma]\>\"", ",", 
              RowBox[{"a_", "?", "StringNumericQ"}]}], "]"}], ",", 
          "StandardForm"}], "]"}], ":=", 
      RowBox[{"MakeExpression", "[", 
        RowBox[{
          RowBox[{"RowBox", "[", 
            RowBox[{"{", 
              RowBox[{
              "\"\<foo\>\"", ",", "\"\<[\>\"", ",", "a", ",", "\"\<]\>\""}], 
              "}"}], "]"}], ",", "StandardForm"}], "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeBoxes", "[", 
        RowBox[{
          RowBox[{"foo", "[", 
            RowBox[{"a_", "?", "NumericQ"}], "]"}], ",", "StandardForm"}], 
        "]"}], ":=", 
      RowBox[{"SubscriptBox", "[", 
        RowBox[{"\"\<\[CapitalGamma]\>\"", ",", 
          RowBox[{
          "Utilities`Notation`Private`makeEvaluatedRowBoxOfBoxes", "[", 
            RowBox[{
              RowBox[{"{", "a", "}"}], ",", "StandardForm", ",", "None"}], 
            "]"}]}], "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "We can see that the patterns ",
  StyleBox["a_?StringNumericQ", "MR"],
  " and ",
  StyleBox["a_?NumericQ", "MR"],
  " do not appear literally since they were surrounded by a ",
  StyleBox["NotationPatternTag", "MR"],
  " in the notation statement."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The tag ",
  StyleBox["NotationMadeBoxesTag", "RM"]
}], "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],

Cell[TextData[{
  "The tag ",
  StyleBox["NotationMadeBoxesTag", "MR"],
  " is intended for advanced users. It is used to indicate that box \
processing and formatting has already been done and that the Notation package \
should not perform any processing. Typically you would use this tag for \
surrounding your own functions that return expressions that have already been \
turned into boxes or parsed into expressions. To illustrate the tag ",
  StyleBox["NotationMadeBoxesTag", "MR"],
  " we can examine a notation statement that might be part of a number of \
statements used to create a notation for Tensors."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.5", "Notation:Definition:NotationMadeBoxesTag", 
    "NotationDocumentation"}],

Cell[TextData[{
  "An example notation for formatting tensors containing the tag ",
  StyleBox["NotationMadeBoxesTag", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{" ", 
      RowBox[{"Notation", "[", 
        RowBox[{
          RowBox[{
            TagBox[
              TagBox[
                RowBox[{
                  StyleBox["\[CapitalGamma]_",
                    FontWeight->"Bold"], 
                  TagBox[
                    RowBox[{"createGridBox", "[", "inds_", "]"}],
                    NotationMadeBoxesTag,
                    TagStyle->"NotationMadeBoxesWrapperStyle"]}],
                Tensor],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], " ", 
            "\[DoubleLongLeftArrow]", " ", 
            TagBox[
              RowBox[{"Tensor", "[", 
                RowBox[{"\[CapitalGamma]_", ",", 
                  TagBox[
                    RowBox[{"inds_", "?", "validIndiciesQ"}],
                    NotationPatternTag,
                    TagStyle->"NotationPatternWrapperStyle"]}], "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], ",", 
          RowBox[{"Action", " ", "\[Rule]", " ", "PrintNotationRules"}]}], 
        "]"}]}]], "Input",
  CellLabel->"In[66]:=",
  CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeBoxes", "[", 
        RowBox[{
          RowBox[{"Tensor", "[", 
            RowBox[{"\[CapitalGamma]_", ",", 
              RowBox[{"inds_", "?", "validIndiciesQ"}]}], "]"}], ",", 
          "StandardForm"}], "]"}], ":=", 
      RowBox[{"TagBox", "[", 
        RowBox[{
          RowBox[{"RowBox", "[", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"StyleBox", "[", 
                  RowBox[{
                    RowBox[{"MakeBoxes", "[", 
                      RowBox[{"\[CapitalGamma]", ",", "StandardForm"}], "]"}],
                     ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], 
                  "]"}], ",", 
                RowBox[{"createGridBox", "[", "inds", "]"}]}], "}"}], "]"}], 
          ",", "Tensor"}], "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "We can see from the internal definition returned that there is no further \
processing of the expression ",
  StyleBox["createGridBox[inds]", "MR"],
  ", i.e. it is not surrounded by a ",
  StyleBox["MakeBoxes[...,StandardForm]", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Changing precedences and the ",
  StyleBox["TagBox", "RM"],
  " option ",
  StyleBox["SyntaxForm", "RM"]
}], "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],

Cell[TextData[{
  "Using the option ",
  StyleBox["SyntaxForm", "MR"],
  " you can change the precedence of an expression containing a ",
  StyleBox["TagBox", "MR"],
  ". A tag box containing a ",
  StyleBox["SyntaxForm", "MR"],
  " option will look like ",
  StyleBox["TagBox[", "MR"],
  " ",
  StyleBox["box structure",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["tag",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["SyntaxForm", "MR"],
  " \[Rule] ",
  StyleBox["string",
    FontSlant->"Italic"],
  StyleBox["],", "MR"],
  " where ",
  StyleBox["string",
    FontSlant->"Italic"],
  " is a string indicating the operator on which the precedence of the tag \
box is modeled. The following examples illustrate the ",
  StyleBox["SyntaxForm", "MR"],
  " option . "
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.6", 
    "Changing precedences and the option SyntaxForm", 
    "Notation:Documentation:SyntaxForm", "NotationDocumentation"}],

Cell["\<\
An expression which uses the arrow \[LongLeftRightArrow] with \
standard precedences.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"a", "+", 
        RowBox[{"b", " ", "\[LongLeftRightArrow]", " ", "c"}]}], "//", 
      "FullForm"}]], "Input",
  CellLabel->"In[67]:=",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Plus", "[", 
          RowBox[{"a", ",", 
            RowBox[{"LongLeftRightArrow", "[", 
              RowBox[{"b", ",", "c"}], "]"}]}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[67]//FullForm=",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}]
}, Closed]],

Cell["\<\
We can define a new notation for a composite arrow \
\[LongLeftRightArrow] surrounded by a TagBox that has the SyntaxForm option \
set to a low precedence.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{"a_", " ", 
            TagBox["\[LongLeftRightArrow]",
              Identity,
              SyntaxForm->","], "b_"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", 
        " ", 
        TagBox[
          RowBox[{"LongLeftRightArrow", "[", 
            RowBox[{"a_", ",", "b_"}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[68]:=",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell["This new composite arrow has a low precedence.", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"(", " ", 
        RowBox[{
          RowBox[{"a", " ", "+", " ", "b"}], " ", 
          TagBox["\[LongLeftRightArrow]",
            Identity,
            SyntaxForm->","], "c"}], ")"}], "//", "FullForm"}]], "Input",
  CellLabel->"In[69]:=",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"LongLeftRightArrow", "[", 
          RowBox[{
            RowBox[{"Plus", "[", 
              RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[69]//FullForm=",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}]
}, Closed]],

Cell["\<\
We can illustrate the underlying groupings of the expressions above \
in the following table.\
\>", "Text",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"visual", " ", "form", " ", "of", " ", "expression"}],
              FontSlant->"Italic"], 
            StyleBox["grouping",
              FontSlant->"Italic"], 
            StyleBox[
              RowBox[{"box", " ", "form", " ", "of", " ", "expression"}],
              FontSlant->"Italic"]},
          {
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox["+",
                    "MR"], 
                  StyleBox["b",
                    SingleLetterItalics->False], " ", 
                  StyleBox["\[LongLeftRightArrow]",
                    SingleLetterItalics->False], " ", 
                  StyleBox["c",
                    SingleLetterItalics->False]}],
                "TraditionalForm"],
              "TI"], 
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox["+",
                    SingleLetterItalics->False], 
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  StyleBox["b",
                    SingleLetterItalics->False], " ", 
                  StyleBox["\[LongLeftRightArrow]",
                    SingleLetterItalics->False], " ", 
                  StyleBox["c",
                    SingleLetterItalics->False], 
                  StyleBox[")",
                    SingleLetterItalics->False]}],
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["Cell",
                    SingleLetterItalics->False], "[", 
                  RowBox[{
                    StyleBox["BoxData",
                      SingleLetterItalics->False], 
                    StyleBox["[",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["RowBox",
                        SingleLetterItalics->False], 
                      StyleBox["[",
                        SingleLetterItalics->False], 
                      RowBox[{
                        RowBox[{
                          StyleBox["{",
                            SingleLetterItalics->False], 
                          RowBox[{"\"\<a\>\"", 
                            StyleBox[
                              RowBox[{",", " "}],
                              SingleLetterItalics->False], "\"\<+\>\"", 
                            StyleBox[
                              RowBox[{",", " ", "\n"}],
                              SingleLetterItalics->False], 
                            StyleBox["      ",
                              SingleLetterItalics->False], 
                            StyleBox["RowBox",
                              SingleLetterItalics->False], 
                            StyleBox[
                              RowBox[{"[", "{"}],
                              SingleLetterItalics->False], "\"\<b\>\"", 
                            StyleBox[
                              RowBox[{",", " "}],
                              SingleLetterItalics->False], "\"\< \>\"", 
                            StyleBox[
                              RowBox[{",", " "}],
                              SingleLetterItalics->False], 
                            "\"\<\[LongLeftRightArrow]\>\"", 
                            StyleBox[
                              RowBox[{",", " "}],
                              SingleLetterItalics->False], "\"\< \>\"", 
                            StyleBox[
                              RowBox[{",", " "}],
                              SingleLetterItalics->False], "\"\<c\>\"", 
                            StyleBox[
                              RowBox[{
                                RowBox[{
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{
                                        RowBox[{"}", "]"}], "}"}], "]"}], 
                                    "]"}], ","}], " "}],
                              SingleLetterItalics->False], 
                            "\"\<Input\>\""}]}], "]"}]}]}]}],
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox["+",
                    "MR"], 
                  StyleBox["b",
                    SingleLetterItalics->False], 
                  StyleBox["  ",
                    SingleLetterItalics->False], 
                  TagBox["\[LongLeftRightArrow]",
                    Identity], " ", 
                  StyleBox["c",
                    SingleLetterItalics->False]}],
                "TraditionalForm"],
              "TI"], 
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox[
                    RowBox[{"(", 
                      RowBox[{"a", "+", "b"}], ")"}],
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  TagBox["\[LongLeftRightArrow]",
                    Identity,
                    SyntaxForm->","], " ", 
                  StyleBox["c",
                    SingleLetterItalics->False]}],
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["Cell",
                    SingleLetterItalics->False], "[", 
                  RowBox[{
                    StyleBox["BoxData",
                      SingleLetterItalics->False], 
                    StyleBox["[",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["RowBox",
                        SingleLetterItalics->False], 
                      StyleBox["[",
                        SingleLetterItalics->False], 
                      RowBox[{
                        StyleBox["{",
                          SingleLetterItalics->False], 
                        RowBox[{
                          StyleBox["RowBox",
                            SingleLetterItalics->False], 
                          StyleBox["[",
                            SingleLetterItalics->False], 
                          RowBox[{
                            RowBox[{
                              StyleBox["{",
                                SingleLetterItalics->False], 
                              RowBox[{
                                RowBox[{"\"\<a\>\"", 
                                  StyleBox[
                                    RowBox[{",", " "}],
                                    SingleLetterItalics->False], "\"\<+\>\"", 
                                  
                                  StyleBox[
                                    RowBox[{",", " "}],
                                    SingleLetterItalics->False], "\"\<b\>\"", 
                                  
                                  StyleBox[
                                    RowBox[{
                                      RowBox[{
                                        RowBox[{"}", "]"}], ","}], " "}],
                                    SingleLetterItalics->False], "\"\<  \>\"",
                                   
                                  StyleBox[
                                    RowBox[{",", " ", "\n"}],
                                    SingleLetterItalics->False], 
                                  StyleBox["      ",
                                    SingleLetterItalics->False], 
                                  RowBox[{
                                    StyleBox["TagBox",
                                      SingleLetterItalics->False], "[", 
                                    RowBox[{"\"\<\[LongLeftRightArrow]\>\"", 
                                      StyleBox[",",
                                        SingleLetterItalics->False], 
                                      StyleBox["Identity",
                                        SingleLetterItalics->False], 
                                      StyleBox[",",
                                        SingleLetterItalics->False], 
                                      RowBox[{
                                        StyleBox["SyntaxForm",
                                        SingleLetterItalics->False], " ", 
                                        StyleBox["->",
                                        SingleLetterItalics->False], " ", 
                                        "\"\<,\>\""}]}], 
                                    StyleBox["]",
                                      SingleLetterItalics->False]}]}], 
                                StyleBox[",",
                                  SingleLetterItalics->False], 
                                StyleBox[" ",
                                  SingleLetterItalics->False], "\n", 
                                "            ", 
                                RowBox[{"\"\< \>\"", 
                                  StyleBox[
                                    RowBox[{",", " "}],
                                    SingleLetterItalics->False], "\"\<c\>\"", 
                                  
                                  StyleBox[
                                    RowBox[{
                                      RowBox[{
                                        RowBox[{
                                        RowBox[{"}", "]"}], "]"}], ","}], 
                                      " "}],
                                    SingleLetterItalics->False], 
                                  "\"\<Input\>\""}]}]}], "]"}]}]}]}]}]}],
                "StandardForm"],
              "Text"]}
          }], NotebookDefault]], "OptionBox3Col",
  GeneratedCell->True,
  AutoStyleOptions->{"UnmatchedBracketStyle"->None},
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.2, 0.14, 0.66},
  RowLines->{True, False}},
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell["\<\
A table illustrating the precedences and grouping of expressions \
with and without precedence changing tag boxes.\
\>", "Caption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[TextData[{
  "The ",
  StyleBox["SyntaxForm", "MR"],
  " option value can be any operator string valid in ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " that is, any operator contained in the ",
  StyleBox["UnicodeCharacters.tr", "MR"],
  " file. The ",
  StyleBox["SyntaxForm", "MR"],
  " value can also include symbols before and after the operator to indicate \
whether the precedence is that of a prefix operator, an infix operator, or a \
postfix operator. Some typical values for the ",
  StyleBox["SyntaxForm", "MR"],
  " option are given in the table below."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["SyntaxForm",
                "MR"], 
              StyleBox[" ",
                FontSlant->"Italic"], 
              StyleBox["value",
                FontSlant->"Italic"]}], 
            StyleBox[
              RowBox[{"precedence", " ", "behavior"}],
              FontSlant->"Italic"]},
          {
            StyleBox[
              FormBox["\"\<*\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "the", " ", 
              StyleBox["operator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["times",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<a\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbol",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<a+b\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["an",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["infix",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["plus",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<\[ForAll]\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<\[Integral]\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["an",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["integrate",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<\[Union] a\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["prefix",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["union",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\< \>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["white",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["space",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.3, 0.7},
  ColumnAlignments->{Left},
  RowLines->{True, False}},
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[TextData[{
  "Typical ",
  StyleBox["SyntaxForm", "MR"],
  " values and their associated precedence behaviors."
}], "Caption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Advice and Suggested Guidelines", "SubsectionIcon",
  CellTags->"NotationDocumentation"],

Cell[TextData[{
  "The following are some issues and considerations to be aware of when using \
the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package and/or designing notations."
}], "Text",
  CellTags->{
  "Notation:S5", "Notation:Documentation:Guidelines", "NotationDocumentation"}
    ],

Cell[CellGroupData[{

Cell["Build up notations in stages", "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],

Cell[TextData[{
  "It is intrinsically difficult to debug something you cannot see; \
therefore, it is best to build up notations, seeing if something works or \
where a mistake has been made. It is harder to find errors if you enter a \
whole complex notation before testing it. Many notational problems will \
usually be revealed by examining the full form of an expression or its \
internal structure via ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"\[CommandKey]", "-", "\[ShiftKey]", "-"}]}], 
        TraditionalForm]]],
  "e."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Don't alter too much", "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],

Cell[TextData[{
  "You should try not to alter too much. For example, changing commas to \
vertical separators is strongly discouraged. The more notational oddities \
present in the system, the higher the chance that one notation will adversely \
interact with another giving unexpected results. Some parsers have mechanisms \
to detect conflicts in a given grammar but the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package does not."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Follow existing conventions where possible", "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],

Cell[TextData[{
  "Where possible, you should follow standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conventions or follow the conventions of a given field. Inventing your \
own individual nonstandard notation is discouraged since such notations are \
necessarily unrecognizable to other users. Even if a notation has an \
historical origin and is not as intuitive as other possible notations the \
author could invent, it is usually better, where possible, to use the \
historical notation. Admittedly, however, it is sometimes difficult to \
resolve the inconsistencies present in a certain notation with the desire to \
have a uniform notation."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Parse without evaluation where possible", "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],

Cell["\<\
When designing notations it is desirable to be able to parse an \
expression to its correct full form without evaluation. This is not always \
possible for complex notations where there is no direct correspondence \
between an external form and an internal form. However, for the cases when it \
is possible there should be no side effects from evaluation.\
\>", "Text",
  CellTags->{
  "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
    "NotationDocumentation"}],

Cell["\<\
The following notation does not depend on evaluation in order to \
behave correctly.\
\>", "MathCaption",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          OverscriptBox["\[ScriptCapitalH]_", "^"],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{"Operator", "[", "\[ScriptCapitalH]_", "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[70]:=",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Hold", "[", 
        OverscriptBox["L", "^"], "]"}], "//", "FullForm"}]], "Input",
  CellLabel->"In[71]:=",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Hold", "[", 
          RowBox[{"Operator", "[", "L", "]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[71]//FullForm=",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}]
}, Closed]],

Cell[TextData[{
  "A common instance of unwanted evaluation comes from testing functions used \
in ",
  ButtonBox["complex pattern matching",
    ButtonData:>{"Notation:Definition:NotationPatternTag", 
      "Complex Patterns"},
    ButtonStyle->"DemosLink"],
  ". If possible you should design testing functions to hold their \
arguments."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],

Cell[TextData[{
  "The notation defined using the testing function ",
  ButtonBox["StringNumericQ",
    ButtonData:>{"Notation:Documentation:SyntaxForm", 
      "Complex Patterns:testing function"},
    ButtonStyle->"DemosLink"],
  " evaluates its arguments, which can lead to unpredictable results."
}], "MathCaption",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{"Hold", "[", 
        SubscriptBox["\[CapitalGamma]", 
          RowBox[{"Print", "[", "\"\<Oops...\>\"", "]"}]], "]"}], 
      TraditionalForm]], "Input",
  CellLabel->"In[72]:=",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],

Cell[BoxData["\<\"Oops...\"\>"], "Print",
  CellLabel->"From In[72]:=",
  CellTags->"NotationDocumentation"],

Cell[BoxData[
    RowBox[{"Hold", "[", 
      SubscriptBox["\[CapitalGamma]", 
        RowBox[{"Print", "[", "\<\"Oops...\"\>", "]"}]], "]"}]], "Output",
  CellLabel->"Out[72]=",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Internal and External representations which are structurally \
different\
\>", "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],

Cell[TextData[{
  "In cases when a conventional notation does not easily equate to an \
internal form in ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " it is suggested that you have the notation take the conventional form to \
the internal ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " name appended by \"",
  StyleBox["Typeset", "MR"],
  "\". For example the ",
  StyleBox["MeijerG", "MR"],
  " function should have the ",
  StyleBox["TraditionalForm", "MR"]
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{
          SubsuperscriptBox["G", 
            RowBox[{"p", ",", "\[MediumSpace]", "q"}], 
            RowBox[{"m", ",", "\[MediumSpace]", "n"}]], "(", 
          RowBox[{"\[Xi]", "\[VerticalSeparator]", GridBox[{
                {
                  RowBox[{
                    SubscriptBox["a", "1"], ",", "...", 
                    RowBox[{",", 
                      SubscriptBox["a", "p"]}]}]},
                {
                  RowBox[{
                    SubscriptBox["b", "1"], ",", "...", 
                    RowBox[{",", 
                      SubscriptBox["b", "q"]}]}]}
                }]}], ")"}], " ", " "}], TraditionalForm]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],

Cell[TextData[{
  "But the ",
  StyleBox["FullForm", "MR"],
  " of the ",
  StyleBox["MeijerG", "MR"],
  " function in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has the following form."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],

Cell[BoxData[
    RowBox[{
      StyleBox["MeijerG",
        "MR"], 
      StyleBox["[",
        "MR"], 
      RowBox[{
        RowBox[{
          StyleBox["{",
            "MR"], 
          RowBox[{
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                FormBox[
                  SubscriptBox["a", "1"],
                  "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", " ", 
                FormBox[
                  SubscriptBox["a", "n"],
                  "TraditionalForm"]}], 
              StyleBox["}",
                "MR"]}], 
            StyleBox[",",
              "MR"], 
            StyleBox[" ",
              "MR"], 
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                FormBox[
                  SubscriptBox["a", 
                    RowBox[{"n", "+", "1"}]],
                  "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", " ", 
                FormBox[
                  SubscriptBox["a", "p"],
                  "TraditionalForm"]}], 
              StyleBox["}",
                "MR"]}]}], 
          StyleBox["}",
            "MR"]}], 
        StyleBox[",",
          "MR"], " ", 
        RowBox[{
          StyleBox["{",
            "MR"], 
          RowBox[{
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                FormBox[
                  SubscriptBox["b", "1"],
                  "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", " ", 
                FormBox[
                  SubscriptBox["b", "m"],
                  "TraditionalForm"]}], 
              StyleBox["}",
                "MR"]}], 
            StyleBox[",",
              "MR"], 
            StyleBox[" ",
              "MR"], 
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                FormBox[
                  SubscriptBox["b", 
                    RowBox[{"m", "+", "1"}]],
                  "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", " ", 
                FormBox[
                  SubscriptBox["b", "q"],
                  "TraditionalForm"]}], 
              StyleBox["}",
                "MR"]}]}], 
          StyleBox["}",
            "MR"]}], 
        StyleBox[",",
          "MR"], " ", 
        FormBox["\[Xi]",
          "TraditionalForm"]}], 
      StyleBox["]",
        "MR"]}]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],

Cell[TextData[{
  "Therefore it is necessary to verify that the ",
  Cell[BoxData[
      FormBox["m", TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox["p", TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox["q", TraditionalForm]]],
  " are numbers having the right values before it is even ",
  StyleBox["possible",
    FontSlant->"Italic"],
  " to construct the internal form of the ",
  StyleBox["MeijerG", "MR"],
  " function. It is not possible to convert from the conventional form to the \
internal form ",
  StyleBox["without",
    FontSlant->"Italic"],
  " evaluation."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],

Cell[TextData[{
  "Therefore, in this case, we should take the traditional ",
  StyleBox["MeijerG", "MR"],
  " box structure to a ",
  StyleBox["MeijerGTypeset[{{", "MR"],
  Cell[BoxData[
      FormBox["m", TraditionalForm]]],
  ",",
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox["},{", "MR"],
  Cell[BoxData[
      FormBox["p", TraditionalForm]]],
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox["q", TraditionalForm]]],
  StyleBox["}},{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox["a", "1"], TraditionalForm]]],
  StyleBox[",", "MR"],
  "...",
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox["a", "p"], TraditionalForm]]],
  StyleBox["},{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox["b", "1"], TraditionalForm]]],
  StyleBox[",", "MR"],
  "...",
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox["b", "q"], TraditionalForm]]],
  StyleBox["}}]", "MR"],
  ". Then evaluation takes this to the internal ",
  StyleBox["MeijerG", "MR"],
  " function once it is has been established that it is possible to construct \
it."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],

Cell[TextData[{
  "Another possible case of this is taking a ",
  StyleBox["tensor",
    FontSlant->"Italic"],
  " defined using a ",
  StyleBox["GridBox", "MR"],
  " to the expression ",
  StyleBox["TensorTypeset", "MR"],
  ". Then evaluation takes this to an internal form ",
  StyleBox["Tensor", "MR"],
  ", provided that the structure is valid, that is, the tensor does not have \
a contravariant and covariant index in the same column, etc."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],

Cell[BoxData[
    StyleBox[GridBox[{
          {" ", 
            StyleBox["Boxes",
              FontWeight->"Bold"], " "},
          {
            StyleBox["MakeBoxes",
              "MR"], 
            RowBox[{"\[UpArrow]", "\[DownArrow]"}], 
            StyleBox["MakeExpression",
              "MR"]},
          {" ", 
            StyleBox["Typeset",
              FontWeight->"Bold"], " "},
          {
            StyleBox["Formatting",
              "TI",
              FontSlant->"Italic"], 
            RowBox[{"\[UpArrow]", "\[DownArrow]"}], 
            StyleBox["Evaluation",
              "TI",
              FontSlant->"Italic"]},
          {" ", 
            StyleBox["FullForm",
              FontWeight->"Bold"], " "}
          },
        ColumnSpacings->0,
        ColumnAlignments->{Right, Center, Left}],
      SpanMinSize->4]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}]
}, Closed]],

Cell["Jason Harris (jasonh@wolfram.com), April 2003.", "SubsubsectionIcon",
  CellTags->{"Notation:S5", "Notation:S5.6", "NotationDocumentation"}]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 828}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
WindowSize->{544, 610},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{2, Automatic},
PrivateNotebookOptions->{"ShortBoxForm"->False},
InputAliases->{
  "pattwrap"->TagBox[ 
      "\[Placeholder]", NotationPatternTag, TagStyle -> 
        "NotationPatternWrapperStyle"], 
    "madeboxeswrap"->TagBox[ 
      "\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
        "NotationMadeBoxesWrapperStyle"], "apply"->RowBox[ {
        RowBox[ {"\[Placeholder]", " ", 
          OverscriptBox[ "\[LongRightArrow]", 
            RowBox[ {" ", "Apply", " "}]], " ", "\[Placeholder]"}], " "}], 
    "notation"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", " ",
           
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation>"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation<"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "symb"->RowBox[ {"Symbolize", "[", 
        TagBox[ 
        "\[Placeholder]", NotationBoxTag, TagStyle -> 
          "NotationTemplateStyle"], "]"}], 
    "infixnotation"->RowBox[ {"InfixNotation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "addia"->RowBox[ {"AddInputAlias", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "pattwraper"->TagBox[ 
      "\[Placeholder]", NotationPatternTag, TagStyle -> 
        "NotationPatternWrapperStyle"], 
    "madeboxeswraper"->TagBox[ 
      "\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
        "NotationMadeBoxesWrapperStyle"]},
SpellingDictionaries->{"CorrectWords"->{
  "typset", "gplus", 
    "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
    "foo"}},
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions for On-line Help", "Subtitle"],
  
  Cell["\<\
These styles are carefully tuned for all aspects of the online \
help. It's recommended that they remain unchanged.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ShowCellBracket->False,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Brackets"],
    PageWidth->WindowWidth,
    ShowCellBracket->True,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ShowCellBracket->False,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "SlideShow"],
    PageWidth->WindowWidth,
    ScrollingOptions->{"PagewiseDisplay"->True},
    ShowCellBracket->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ShowAutoStyles->False,
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}],
  
  Cell[StyleData[All, "EnhancedPrintout"],
    PageWidth->PaperWidth,
    ShowCellBracket->True,
    ScriptMinSize->5,
    FontFamily->"Palatino",
    PrivateFontOptions->{"FontType"->"Outline"}],
  
  Cell[StyleData[All, "EnhancedPrintoutNonGray"],
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ScriptMinSize->5,
    FontFamily->"Palatino",
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
  The options defined for the style below will be used at the \
Notebook level.  \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True},
    CellLabelAutoDelete->False,
    CellFrameLabelMargins->6,
    StyleMenuListing->None],
  
  Cell[StyleData["Notebook", "Printout"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2003 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True}],
  
  Cell[StyleData["Notebook", "EnhancedPrintout"],
    PageFooters->{{None, None, None}, {None, None, None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{False, False},
    PrintingOptions->{"PrintingMargins"->{{54, 54}, {36, 72}},
    "PageSize"->{594, 657},
    "PrintRegistrationMarks"->True,
    "FirstPageHeader"->False,
    "FacingPages"->True,
    "FirstPageFace"->Right}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Chapter"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{27, 27}, {10, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24,
    FontWeight->"Plain",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Chapter", "Presentation"],
    FontSize->36],
  
  Cell[StyleData["Chapter", "Printout"],
    CellMargins->{{2, 10}, {6, 30}},
    FontSize->14],
  
  Cell[StyleData["Chapter", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {6, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->14,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Chapter", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {6, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellMargins->{{27, 27}, {12, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Section", "Presentation"],
    FontSize->30],
  
  Cell[StyleData["Section", "SlideShow"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {5, 0}},
    PageBreakBelow->False,
    CellFrameMargins->{{36, 36}, {Inherited, 15}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.408011, 0.440726, 0.8]],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->18],
  
  Cell[StyleData["Section", "EnhancedPrintout"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, 2}, {5, 30}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Section", "EnhancedPrintoutNonGray"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {5, 30}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->None,
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CellFrameLabelMargins->6,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Subsection", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["Subsection", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {5, 24}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {5, 20}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Subsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {5, 20}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Subsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionColor"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.297993, 0, 0.454994]],
  
  Cell[StyleData["SubsubsectionColor", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsectionColor", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{46, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->8},
    CellGroupingRules->{"SectionGrouping", 40},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsectionIcon", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["SubsectionIcon", "Printout"],
    CellDingbat->"\[FilledSquare]",
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{16, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{46, 27}, {0, 8}},
    CellElementSpacings->{"ClosedGroupTopMargin"->4},
    CellGroupingRules->{"SectionGrouping", 50},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsubsectionIcon", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsectionIcon", "Printout"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{27, 27}, {0, 8}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", 
                BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    ParagraphSpacing->{0, 8},
    FontSize->12],
  
  Cell[StyleData["Text", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Text", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}},
    Hyphenation->False,
    FontSize->14],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["Text", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Text", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CompactText"],
    CellMargins->{{27, 27}, {0, 8}},
    Hyphenation->True,
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["CompactText", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["CompactText", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8],
  
  Cell[StyleData["CompactText", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["CompactText", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Compact12Text"],
    CellMargins->{{27, 27}, {0, 8}},
    Hyphenation->True,
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None],
  
  Cell[StyleData["Compact12Text", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Compact12Text", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Compact12Text", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Compact12Text", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextSans"],
    CellMargins->{{27, 27}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["TextSans", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["TextSans", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontSize->8],
  
  Cell[StyleData["TextSans", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Frutiger 55 Roman",
    FontSize->8],
  
  Cell[StyleData["TextSans", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    Hyphenation->True,
    FontFamily->"Frutiger 55 Roman",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedText"],
    CellMargins->{{66, 4}, {4, 4}},
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedText", "Printout"],
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedText", "EnhancedPrintout"],
    CellMargins->{{16, 4}, {2, 4}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    ParagraphIndent->-18,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote"],
    CellMargins->{{88, 4}, {4, 0}},
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTextNote", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndentedText"],
    CellMargins->{{66, 4}, {0, 6}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["IndentedText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["IndentedText", "SlideShow"],
    CellMargins->{{80, 24}, {5, 5}},
    Hyphenation->False,
    FontSize->13],
  
  Cell[StyleData["IndentedText", "Printout"],
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["IndentedText", "EnhancedPrintout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["IndentedText", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedList"],
    CellMargins->{{58, 4}, {4, 4}},
    CellFrameLabels->{{Cell[ 
            TextData[ {
              StyleBox[ 
                CounterBox[ "ItemizedList"], "TB"], 
              StyleBox[ ".", "TB"]}], CellBaseline -> Baseline, CellSize -> {
            24, Inherited}, TextAlignment -> Right], Inherited}, {
        Inherited, Inherited}},
    LineSpacing->{1, 3},
    CounterIncrements->"ItemizedList",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedList", "Printout"],
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedList", "EnhancedPrintout"],
    CellMargins->{{9, 4}, {2, 4}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedList", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedSubList"],
    CellMargins->{{92, 4}, {4, 4}},
    CellFrameLabels->{{Cell[ 
            TextData[ {
              StyleBox[ 
                CounterBox[ "ItemizedSubList"], "TB"], 
              StyleBox[ ".", "TB"]}], CellBaseline -> Baseline, CellSize -> {
            24, Inherited}, TextAlignment -> Right], Inherited}, {
        Inherited, Inherited}},
    CounterIncrements->"ItemizedSubList",
    StyleMenuListing->None,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["ItemizedSubList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedSubList", "Printout"],
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedSubList", "EnhancedPrintout"],
    CellMargins->{{26, 4}, {2, 4}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedSubList", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedSubListNote"],
    CellMargins->{{110, 4}, {4, 4}},
    CounterIncrements->"ItemizedSubList",
    StyleMenuListing->None,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["ItemizedSubListNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedSubListNote", "Printout"],
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ItemizedSubListNote", "EnhancedPrintout"],
    CellMargins->{{56, 4}, {2, 4}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedSubListNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{48, 4}, {2, 4}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BulletedList"],
    CellMargins->{{76, 4}, {4, 4}},
    CellFrameLabels->{{
      Cell[ "\[Bullet]", "BulletedList", CellBaseline -> Baseline], 
          Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 3},
    CounterIncrements->"BulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["BulletedList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BulletedList", "Printout"],
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["BulletedList", "EnhancedPrintout"],
    CellMargins->{{26, 4}, {2, 4}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BulletedList", "EnhancedPrintoutNonGray"],
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListNote"],
    CellMargins->{{88, 4}, {4, 0}},
    LineSpacing->{1, 2},
    CounterIncrements->"ListNote",
    StyleMenuListing->None],
  
  Cell[StyleData["ListNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListNote", "Printout"],
    CellMargins->{{34, 4}, {4, 1}},
    Hyphenation->True,
    FontSize->10],
  
  Cell[StyleData["ListNote", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ListNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {4, 1}},
    Hyphenation->True,
    LineSpacing->{1, 1},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MathCaption"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{27, 12}, {2, 24}},
    PageBreakBelow->False,
    CellFrameMargins->{{8, 8}, {8, 2}},
    CellFrameColor->GrayLevel[0.700008],
    CellFrameLabelMargins->4,
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8},
    FontColor->GrayLevel[0.2]],
  
  Cell[StyleData["MathCaption", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MathCaption", "SlideShow"],
    ShowCellBracket->False,
    CellMargins->{{36, 36}, {6, 6}}],
  
  Cell[StyleData["MathCaption", "Printout"],
    CellMargins->{{9, 0}, {0, 14}},
    Hyphenation->True,
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["MathCaption", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {0, 14}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["MathCaption", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {0, 14}},
    Hyphenation->True,
    FontFamily->"Palatino",
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{27, 27}, {0, 8}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"SmallText",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    FontSize->7],
  
  Cell[StyleData["SmallText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7],
  
  Cell[StyleData["SmallText", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {3, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Input", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {0, 6}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {4, 8}},
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Input", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9],
  
  Cell[StyleData["Input", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9],
  
  Cell[StyleData["Input", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->StandardForm],
  
  Cell[StyleData["Output", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Output", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {6, 0}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {8, 4}},
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Output", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9],
  
  Cell[StyleData["Output", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9],
  
  Cell[StyleData["Output", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InputOnly"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {8, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["InputOnly", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["InputOnly", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {6, 6}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["InputOnly", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["InputOnly", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["InputOnly", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  
  Cell[StyleData["Message", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Message", "SlideShow"],
    CellMargins->{{100, 50}, {6, 6}},
    FontSize->10,
    FontColor->RGBColor[0.699992, 0.4, 0]],
  
  Cell[StyleData["Message", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Message", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Message", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Print", "SlideShow"],
    CellMargins->{{100, 50}, {6, 6}}],
  
  Cell[StyleData["Print", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontSize->9],
  
  Cell[StyleData["Print", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier Std",
    FontSize->9],
  
  Cell[StyleData["Print", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier Std",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultFormatTypeForOutput,
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["Graphics", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Graphics", "SlideShow"],
    ShowCellBracket->True,
    CellMargins->{{100, 50}, {6, 0}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {4, 4}},
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Graphics", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontSize->9],
  
  Cell[StyleData["Graphics", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{32, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontFamily->"Courier Std",
    FontSize->9],
  
  Cell[StyleData["Graphics", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{32, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontFamily->"Courier Std",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["CellLabel", "SlideShow"],
    FontColor->RGBColor[0.699992, 0.4, 0]],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->8,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->8,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Name"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  
  Cell[StyleData["Name", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["Name", "Printout"],
    FontSize->7,
    FontSlant->"Oblique",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Name", "EnhancedPrintout"],
    FontFamily->"Frutiger 56 Italic",
    FontSize->7,
    FontSlant->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Name", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 56 Italic",
    FontSize->7,
    FontSlant->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlinks", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks. The others point to the various sections of the help \
browser. These styles will modify individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["Hyperlink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["Hyperlink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLinkMR"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLinkMR", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLinkMR", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLinkMR", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLink", "EnhancedPrintout"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLink", "EnhancedPrintoutNonGray"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLinkText"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Times",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLinkText", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLinkText", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLinkText", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLink", "EnhancedPrintout"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLink", "EnhancedPrintoutNonGray"],
    FontFamily->"WRICourier",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["GettingStartedLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["GettingStartedLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DemosLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["DemosLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["DemosLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["DemosLink", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TourLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["TourLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["TourLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["TourLink", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLinkMR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLinkMR", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MasterIndexLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MasterIndexLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MasterIndexLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MasterIndexLink", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JT"],
    StyleMenuListing->None,
    FontFamily->"JFontText"],
  
  Cell[StyleData["JT", "Printout"]],
  
  Cell[StyleData["JT", "EnhancedPrintout"]],
  
  Cell[StyleData["JT", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JS"],
    StyleMenuListing->None,
    FontFamily->"JFontSans"],
  
  Cell[StyleData["JS", "Printout"]],
  
  Cell[StyleData["JS", "EnhancedPrintout"]],
  
  Cell[StyleData["JS", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JSB"],
    StyleMenuListing->None,
    FontFamily->"JFontSansBold"],
  
  Cell[StyleData["JSB", "Printout"]],
  
  Cell[StyleData["JSB", "EnhancedPrintout"]],
  
  Cell[StyleData["JSB", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["RM", "Printout"]],
  
  Cell[StyleData["RM", "EnhancedPrintout"]],
  
  Cell[StyleData["RM", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["BF", "Printout"]],
  
  Cell[StyleData["BF", "EnhancedPrintout"]],
  
  Cell[StyleData["BF", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["IT", "Printout"]],
  
  Cell[StyleData["IT", "EnhancedPrintout"]],
  
  Cell[StyleData["IT", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TR", "Printout"]],
  
  Cell[StyleData["TR", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TR", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSlant->"Italic"],
  
  Cell[StyleData["TI", "Printout"]],
  
  Cell[StyleData["TI", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TI", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TB", "Printout"]],
  
  Cell[StyleData["TB", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TB", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["TBI", "Printout"]],
  
  Cell[StyleData["TBI", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TBI", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MR"],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MR", "Printout"]],
  
  Cell[StyleData["MR", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["MR", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MO", "Printout"],
    FontSlant->"Oblique"],
  
  Cell[StyleData["MO", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"],
  
  Cell[StyleData["MO", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MB"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MB", "Printout"]],
  
  Cell[StyleData["MB", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["MB", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MBO"],
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MBO", "Printout"],
    FontSlant->"Oblique"],
  
  Cell[StyleData["MBO", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"],
  
  Cell[StyleData["MBO", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSlant->"Oblique"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SR", "Printout"]],
  
  Cell[StyleData["SR", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["SR", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO", "EnhancedPrintout"],
    FontFamily->"Frutiger 56 Italic",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 56 Italic",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SB", "Printout"],
    StyleMenuListing->None],
  
  Cell[StyleData["SB", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"],
  
  Cell[StyleData["SB", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SBColor"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBColor", "Printout"],
    StyleMenuListing->None],
  
  Cell[StyleData["SBColor", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"],
  
  Cell[StyleData["SBColor", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SBO", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SBO", "EnhancedPrintout"],
    FontFamily->"Frutiger 66 BoldItalic",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 66 BoldItalic",
    FontWeight->"Plain",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["M4"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"],
  
  Cell[StyleData["M4", "Printout"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"],
  
  Cell[StyleData["M4", "EnhancedPrintout"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"],
  
  Cell[StyleData["M4", "EnhancedPrintoutNonGray"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Mathematica4",
    CharacterEncoding->"Mathematica4"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintout"],
    StyleMenuListing->None,
    FontFamily->"Frutiger 56 Italic",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO10", "EnhancedPrintoutNonGray"],
    StyleMenuListing->None,
    FontFamily->"Frutiger 56 Italic",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["S9"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "Printout"],
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->9,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["S10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "Printout"],
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB9"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Bold",
    PrivateFontOptions->{"OperatorSubstitution"->False}],
  
  Cell[StyleData["SB9", "Printout"],
    FontSize->7],
  
  Cell[StyleData["SB9", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->7,
    FontWeight->"Plain"],
  
  Cell[StyleData["SB9", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->7,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["SB10", "Printout"],
    FontSize->8],
  
  Cell[StyleData["SB10", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->8,
    FontWeight->"Plain"],
  
  Cell[StyleData["SB10", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontSize->8,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MR10"],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    SingleLetterItalics->False,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MR10", "Printout"],
    FontSize->7],
  
  Cell[StyleData["MR10", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->7],
  
  Cell[StyleData["MR10", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1MR", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1MR", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1MR", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallCaps"],
    StyleMenuListing->None,
    Magnification->0.8],
  
  Cell[StyleData["SmallCaps", "Printout"]],
  
  Cell[StyleData["SmallCaps", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["SmallCaps", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["KeyboardChars"],
    StyleMenuListing->None,
    FontSize->12],
  
  Cell[StyleData["KeyboardChars", "Printout"],
    FontSize->10],
  
  Cell[StyleData["KeyboardChars", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["KeyboardChars", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Emphasis Boxes and Pictures", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Box"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["Box", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Box", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Box", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Box", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DoubleBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->2,
    RowAlignments->Top}],
  
  Cell[StyleData["DoubleBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DoubleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["DoubleBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["DoubleBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["1ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["1ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["1ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["1ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["1ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    SingleLetterItalics->False,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.31, 0.67}}],
  
  Cell[StyleData["2ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.46}],
  
  Cell[StyleData["2ColumnEvenBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnEvenBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnEvenBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnEvenBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnSmallBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.35,
    ColumnAlignments->{Right, Left}}],
  
  Cell[StyleData["2ColumnSmallBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnSmallBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnSmallBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.32}],
  
  Cell[StyleData["3ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnSmallBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.24,
    ColumnAlignments->{Right, Center, Left}}],
  
  Cell[StyleData["3ColumnSmallBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnSmallBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnSmallBox", "EnhancedPrintoutNonGray"],
    CellFrame->0.5,
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    SingleLetterItalics->False,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.13, 0.35, 0.13, 0.35}}],
  
  Cell[StyleData["4ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["4ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["4ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["4ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.202}],
  
  Cell[StyleData["5ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["5ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["5ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["5ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->9,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],
  
  Cell[StyleData["6ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["6ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["6ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["6ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FramedBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["FramedBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FramedBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["FramedBox", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["FramedBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox3Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.35, 0.2, 0.45},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox3Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox3Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox3Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox3Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox4Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.15, 0.35, 0.15, 0.35},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox4Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox4Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox4Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox4Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox5Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->0.2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox5Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox5Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox5Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox5Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox6Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox6Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox6Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox6Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox6Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TopBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 2}},
    Background->GrayLevel[1]],
  
  Cell[StyleData["MiddleBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]],
  
  Cell[StyleData["MiddleBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BottomBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BottomBox", "Printout"],
    CellMargins->{{2, 0}, {0, -5}},
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}],
  
  Cell[StyleData["BottomBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, -5}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}],
  
  Cell[StyleData["BottomBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, -5}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 12}, {-2, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopSpanBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TopSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-2, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopSpanBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {-4, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopSpanBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {-4, 8}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, 0}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpanBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-5, 0}},
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpanBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {-7, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpanBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {-7, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Picture"],
    CellMargins->{{27, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Picture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Picture", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.65],
  
  Cell[StyleData["Picture", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.65],
  
  Cell[StyleData["Picture", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.65]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OpenCloseItemizedPicture"],
    CellMargins->{{88, 4}, {4, 4}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["OpenCloseItemizedPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["OpenCloseItemizedPicture", "Printout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedPicture"],
    CellMargins->{{88, 4}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedPicture", "Printout"],
    CellMargins->{{77, 2}, {4, -4}},
    Magnification->0.5],
  
  Cell[StyleData["ItemizedPicture", "EnhancedPrintout"],
    CellMargins->{{78, 2}, {12, -6}},
    Magnification->0.5],
  
  Cell[StyleData["ItemizedPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{75, 2}, {4, -6}},
    Magnification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListGraphic"],
    CellMargins->{{88, 4}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ListGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListGraphic", "Printout"],
    CellMargins->{{77, 2}, {4, -4}},
    Magnification->0.5],
  
  Cell[StyleData["ListGraphic", "EnhancedPrintout"],
    CellMargins->{{78, 2}, {12, -6}},
    Magnification->0.5],
  
  Cell[StyleData["ListGraphic", "EnhancedPrintoutNonGray"],
    CellMargins->{{75, 2}, {4, -6}},
    Magnification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListNoteBox"],
    CellFrame->0.5,
    CellMargins->{{88, 12}, {8, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ListNoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListNoteBox", "Printout"],
    CellMargins->{{77, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ListNoteBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ListNoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{77, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureGroup"],
    CellMargins->{{41, 4}, {0, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureGroup", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureGroup", "Printout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["PictureGroup", "EnhancedPrintout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False],
  
  Cell[StyleData["PictureGroup", "EnhancedPrintoutNonGray"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Sound"],
    ShowCellBracket->True,
    CellMargins->{{27, Inherited}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["Sound", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Sound", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Sound", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Sound", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Caption"],
    CellMargins->{{27, 4}, {0, 3}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["Caption", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["Caption", "Printout"],
    CellMargins->{{2, 4}, {2, 0}},
    FontSize->7],
  
  Cell[StyleData["Caption", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {2, 2}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->7],
  
  Cell[StyleData["Caption", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {2, -2}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Tables", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.34, 0.64},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->0.49,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnEvenTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnEvenTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnEvenTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["2ColumnEvenTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["3ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9],
  
  Cell[StyleData["3ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{27, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    AutoSpacing->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["InlineFormula", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["InlineFormula", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineOutput"],
    CellMargins->{{27, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["InlineOutput", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5],
  
  Cell[StyleData["InlineOutput", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5],
  
  Cell[StyleData["InlineOutput", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{66, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    UnderoverscriptBoxOptions->{LimitsPositioning->True},
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DisplayFormula", "Printout"]],
  
  Cell[StyleData["DisplayFormula", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["DisplayFormula", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayMath"],
    CellMargins->{{66, 10}, {7, 7}},
    Evaluatable->False,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input"],
  
  Cell[StyleData["DisplayMath", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DisplayMath", "Printout"],
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["DisplayMath", "EnhancedPrintout"],
    CellMargins->{{39, 0}, {4, 6}},
    FontFamily->"WRICourier",
    FontSize->9],
  
  Cell[StyleData["DisplayMath", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 0}, {4, 6}},
    FontFamily->"WRICourier",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedEquation"],
    CellMargins->{{66, 10}, {7, 7}},
    CellFrameLabels->{{None, Cell[ 
            TextData[ {"(", 
              CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LanguageCategory->"Formula",
    CounterIncrements->"NumberedEquation",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedEquation", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedEquation", "Printout"],
    CellMargins->{{39, 55}, {0, 10}},
    FontSize->10],
  
  Cell[StyleData["NumberedEquation", "EnhancedPrintout"],
    CellMargins->{{39, 55}, {0, 10}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["NumberedEquation", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 55}, {0, 10}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["EquationNumber"],
    CellMargins->{{27, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1.83, 0},
    LanguageCategory->"Formula"],
  
  Cell[StyleData["EquationNumber", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["EquationNumber", "Printout"],
    LineSpacing->{1.7, 0}],
  
  Cell[StyleData["EquationNumber", "EnhancedPrintout"],
    LineSpacing->{1.7, 0},
    FontFamily->"Palatino"],
  
  Cell[StyleData["EquationNumber", "EnhancedPrintoutNonGray"],
    LineSpacing->{1.7, 0},
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellMargins->{{27, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    ShowSpecialCharacters->Automatic,
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontSize->9.5],
  
  Cell[StyleData["Program", "EnhancedPrintout"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontFamily->"WRICourier",
    FontSize->9.5],
  
  Cell[StyleData["Program", "EnhancedPrintoutNonGray"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontFamily->"WRICourier",
    FontSize->9.5]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Unique Help Browser Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell["\<\
Standard Styles
\
\>", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InspectorLevel1"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 10}, {2, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-38,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel1", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["InspectorLevel1", "SlideShow"],
    HyphenationOptions->{"HyphenationCharacter"->"-"}],
  
  Cell[StyleData["InspectorLevel1", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InspectorLevel2"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel2", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["InspectorLevel2", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel2", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectName"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellGroupingRules->{"SectionGrouping", 50},
    CellFrameMargins->{{27, 12}, {3, 15}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold",
    Background->RGBColor[0.960784, 0.878431, 0.666667]],
  
  Cell[StyleData["ObjectName", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["ObjectName", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubObjectNameClosed"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {1, 10}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectNameClosed", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["SubObjectNameClosed", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectNameClosed", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubObjectName"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectName", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["SubObjectName", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{90, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["SubObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupObjectName"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectName", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["GroupObjectName", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectName", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupObjectNameClosed"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 14}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->{"SectionGrouping", 80},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectNameClosed", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["GroupObjectNameClosed", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectNameClosed", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectNameWarningMessages"],
    CellMargins->{{27, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 65},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectNameWarningMessages", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["ObjectNameWarningMessages", "SlideShow"],
    CellMargins->{{10, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 65},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectNameWarningMessages", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Command"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->{{27, 12}, {3, 15}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    CounterIncrements->"Section",
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold",
    Background->RGBColor[0.960784, 0.878431, 0.666667]],
  
  Cell[StyleData["Command", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["Command", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CharacterName"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->{{27, 27}, {8, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["CharacterName", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CharacterName", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CharacterName", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Usage"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->{{27, 27}, {8, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    Hyphenation->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["Usage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Usage", "SlideShow"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{72, 4}, {0, 4}},
    CellFrameMargins->5,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None],
  
  Cell[StyleData["Usage", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ErrorMessage"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    ShowCellBracket->True,
    CellMargins->{{27, 4}, {0, 4}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    CellFrameMargins->5,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["ErrorMessage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ErrorMessage", "SlideShow"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[StyleData["ErrorMessage", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notes"],
    CellMargins->{{27, 27}, {0, 8}},
    CellHorizontalScrolling->True,
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Notes", "SlideShow"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NotesList"],
    CellMargins->{{20, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NotesList", "SlideShow"],
    CellMargins->{{82, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Printout"],
    CellMargins->{{12, 0}, {2, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ReferenceSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 30},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["ReferenceSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["ReferenceSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Reference"],
    CellMargins->{{10, 4}, {0, 8}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    Hyphenation->True,
    ParagraphSpacing->{0, 8},
    FontSize->12],
  
  Cell[StyleData["Reference", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Reference", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}},
    Hyphenation->False,
    FontSize->14],
  
  Cell[StyleData["Reference", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->10],
  
  Cell[StyleData["Reference", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Reference", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["ExampleSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["ExampleSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleText"],
    CellMargins->{{27, 40}, {0, 18}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["ExampleText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ExampleText", "Printout"],
    CellMargins->{{2, 80}, {0, 8}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSubsection"],
    ShowCellBracket->True,
    CellMargins->{{27, 4}, {0, 16}},
    CellGroupingRules->{"SectionGrouping", 80},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["ExampleSubsection", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["ExampleSubsection", "Printout"],
    CellMargins->{{12, 0}, {0, 16}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MessagesSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{27, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["MessagesSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["MessagesSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TemplateSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{27, 4}, {0, 10}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->True},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold"],
  
  Cell[StyleData["TemplateSection", "Presentation"],
    FontSize->20],
  
  Cell[StyleData["TemplateSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LineHead"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{27, 4}, {8, 18}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["LineHead", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["LineHead", "Printout"],
    CellMargins->{{2, 0}, {8, 18}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushInput"],
    CellMargins->{{27, 4}, {1, 4}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["FlushInput", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FlushInput", "Printout"],
    CellMargins->{{2, 0}, {1, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushOutput"],
    CellMargins->{{27, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->StandardForm,
    StyleMenuListing->None],
  
  Cell[StyleData["FlushOutput", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FlushOutput", "Printout"],
    CellMargins->{{2, Inherited}, {Inherited, Inherited}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DialogItem"],
    CellDingbat->"\[EmptyDiamond]",
    CellMargins->{{27, 4}, {0, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["DialogItem", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["DialogItem", "Printout"],
    CellMargins->{{12, 0}, {0, 12}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupDivider"],
    CellMargins->{{27, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->{"TitleGrouping", 0},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[StyleData["GroupDivider", "Presentation"],
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Highlight"],
    CellFrame->0.5,
    CellMargins->{{27, 4}, {0, 18}},
    CellFrameColor->GrayLevel[0.800015],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    Background->GrayLevel[0.950011]],
  
  Cell[StyleData["Highlight", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Highlight", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserNotes"],
    CellFrame->{{3, 0}, {0, 0}},
    CellMargins->{{27, 4}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["UserNotes", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["UserNotes", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8],
  
  Cell[StyleData["UserNotes", "EnhancedPrintout"],
    CellMargins->{{0, 0}, {0, 4}},
    LineSpacing->{1, 3},
    FontFamily->"Frutiger 55 Roman",
    FontSize->8],
  
  Cell[StyleData["UserNotes", "EnhancedPrintoutNonGray"],
    CellMargins->{{0, 0}, {0, 4}},
    LineSpacing->{1, 3},
    FontFamily->"Frutiger 55 Roman",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MoreInfo"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["MoreInfo", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["MoreInfo", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserTips"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    Background->RGBColor[0.964706, 0.929412, 0.839216]],
  
  Cell[StyleData["UserTips", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["UserTips", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8,
    Background->GrayLevel[0.700008]],
  
  Cell[StyleData["UserTips", "EnhancedPrintout"],
    CellMargins->{{0, 0}, {0, 4}},
    CellFrameColor->GrayLevel[0],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontFamily->"Frutiger 55 Roman",
    FontSize->8,
    Background->GrayLevel[0.700008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Theorem"],
    CellFrame->{{4, 0}, {0, 0}},
    CellMargins->{{27, 62}, {0, 14}},
    CellFrameMargins->4,
    CellFrameColor->RGBColor[0, 0, 0.8],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8}],
  
  Cell[StyleData["Theorem", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Theorem", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    CellFrameMargins->3,
    CellFrameColor->GrayLevel[0.8],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Commentary"],
    CellFrame->{{2, 0}, {0, 0}},
    CellMargins->{{36, 10}, {7, 7}},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CellFrameColor->RGBColor[0, 0.2, 1],
    LineSpacing->{1, 3},
    FontSlant->"Italic"],
  
  Cell[StyleData["Commentary", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Commentary", "Printout"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontSize->10],
  
  Cell[StyleData["Commentary", "EnhancedPrintout"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Commentary", "EnhancedPrintoutNonGray"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Level1Icon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["Level1Icon", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Level1Icon", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Level2Icon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["Level2Icon", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Level2Icon", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CopyrightHead"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CopyrightHead", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CopyrightHead", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Copyright"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["Copyright", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["Copyright", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["Copyright", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Frutiger 55 Roman",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RegisterSubsection"],
    CellDingbat->None,
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 45},
    CellFrameLabelMargins->6,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontSize->16],
  
  Cell[StyleData["RegisterSubsection", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["RegisterSubsection", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 12}},
    FontSize->12],
  
  Cell[StyleData["RegisterSubsection", "Printout"],
    CellMargins->{{9, 0}, {5, 24}},
    FontSize->12],
  
  Cell[StyleData["RegisterSubsection", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {5, 20}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12],
  
  Cell[StyleData["RegisterSubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {5, 20}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RegisterSubsubsection"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", 
                BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["RegisterSubsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["RegisterSubsubsection", "Printout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontSize->10],
  
  Cell[StyleData["RegisterSubsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["RegisterSubsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RegisterText"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["RegisterText", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["RegisterText", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["RegisterText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CaptionHead"],
    CellMargins->{{27, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CaptionHead", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["CaptionHead", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["CaptionHead", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CaptionText"],
    CellMargins->{{66, 4}, {0, 8}},
    PageBreakAbove->False,
    StyleMenuListing->None],
  
  Cell[StyleData["CaptionText", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["CaptionText", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->8],
  
  Cell[StyleData["CaptionText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BulletText"],
    CellMargins->{{76, 4}, {4, 4}},
    CellFrameLabels->{{
      Cell[ "\[Bullet]", "BulletText", CellBaseline -> Baseline], 
          Inherited}, {Inherited, Inherited}},
    Hyphenation->False,
    LineSpacing->{1, 3},
    CounterIncrements->"BulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["BulletText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BulletText", "Printout"],
    FontSize->10],
  
  Cell[StyleData["BulletText", "EnhancedPrintout"],
    CellMargins->{{16, 4}, {2, 4}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BulletText", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["HelpLabels"],
    CellMargins->{{88, 4}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["HelpLabels", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["HelpLabels", "Printout"],
    CellMargins->{{34, 2}, {6, 6}},
    FontSize->10],
  
  Cell[StyleData["HelpLabels", "EnhancedPrintout"],
    CellMargins->{{34, 2}, {6, 6}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Manual.nb Merge", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell["Function List", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionName"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{24, 10}, {10, 12}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->14,
    FontWeight->"Bold",
    CellTags->"FunctionName"],
  
  Cell[StyleData["FunctionName", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["FunctionName", "Printout"],
    CellMargins->{{9, 0}, {10, 10}},
    FontSize->12],
  
  Cell[StyleData["FunctionName", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {10, 10}},
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["FunctionName", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {10, 10}},
    FontFamily->"Courier",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionSubsection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{36, 10}, {0, 6}},
    CellGroupingRules->{"SectionGrouping", 60},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontWeight->"Bold",
    CellTags->"FunctionSubsection"],
  
  Cell[StyleData["FunctionSubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionSubsection", "Printout"],
    CellMargins->{{30, 0}, {0, 6}}],
  
  Cell[StyleData["FunctionSubsection", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->11],
  
  Cell[StyleData["FunctionSubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescription"],
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["FunctionDescription", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescription", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescription", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescription", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuled"],
    CellFrame->{{0, 0}, {0.25, 0.25}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuled", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescriptionRuled", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuleTop"],
    CellFrame->{{0, 0}, {0, 0.25}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuleBottom"],
    CellFrame->{{0, 0}, {0.25, 0}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionExample"],
    CellMargins->{{36, 10}, {4, 0}},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["FunctionExample", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["FunctionExample", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->9],
  
  Cell[StyleData["FunctionExample", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontFamily->"Palatino",
    FontSize->9],
  
  Cell[StyleData["FunctionExample", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionTextNote"],
    CellMargins->{{36, 4}, {0, 4}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0, 4},
    LineIndent->0,
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionTextNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FunctionTextNote", "Printout"],
    CellMargins->{{36, 4}, {0, 4}},
    FontSize->9],
  
  Cell[StyleData["FunctionTextNote", "EnhancedPrintout"],
    CellMargins->{{36, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["FunctionTextNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{36, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnFunctionTable"],
    CellMargins->{{36, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnFunctionTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnFunctionTable", "Printout"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Browser Emulation", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextNormal"],
    CellMargins->{{12, 10}, {7, 7}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["TextNormal", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TextNormal", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BrowserEmulation"],
    CellMargins->{{12, 1}, {7, 24}},
    CellGroupingRules->{"SectionGrouping", 70},
    LineSpacing->{1, 3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    GridBoxOptions->{ColumnWidths->0.25,
    ColumnAlignments->{Left},
    GridFrame->True,
    GridFrameMargins->0.5,
    ColumnLines->True}],
  
  Cell[StyleData["BrowserEmulation", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BrowserEmulation", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CategoryDefs"],
    CellMargins->{{300, 10}, {7, 7}},
    LineSpacing->{1, 3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    Background->RGBColor[1, 0.8, 0.6],
    GridBoxOptions->{ColumnAlignments->{Left},
    GridFrame->False,
    RowLines->True,
    ColumnLines->True}],
  
  Cell[StyleData["CategoryDefs", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CategoryDefs", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category1"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{12, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    StyleMenuListing->None,
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Category1", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["Category1", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category2"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{85, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    StyleMenuListing->None,
    FontSize->14,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 0.500008]],
  
  Cell[StyleData["Category2", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["Category2", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category3"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{157, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.2, 0, 0.4]],
  
  Cell[StyleData["Category3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Category3", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category4"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{230, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 80},
    StyleMenuListing->None,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0.300008, 0.4]],
  
  Cell[StyleData["Category4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Category4", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Misc", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.25,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["4ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["4ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["4ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["4ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.2,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["5ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["5ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["5ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["5ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.16,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["6ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["6ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["6ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["6ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["7ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.14,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["7ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["7ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["7ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["7ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["8ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.12,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["8ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["8ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["8ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["8ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ABItemizedText"],
    CellMargins->{{20, 4}, {0, 5}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    ParagraphIndent->-21,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ABItemizedText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ABItemizedText", "Printout"],
    ParagraphIndent->-21,
    FontSize->11],
  
  Cell[StyleData["ABItemizedText", "EnhancedPrintout"],
    ParagraphIndent->-21,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ABItemizedText", "EnhancedPrintoutNonGray"],
    ParagraphIndent->-21,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ChapNumber"],
    CellMargins->{{27, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->42,
    FontWeight->"Plain",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["ChapNumber", "Presentation"],
    FontSize->63],
  
  Cell[StyleData["ChapNumber", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->36],
  
  Cell[StyleData["ChapNumber", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->36,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["ChapNumber", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->36,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ChapTitle"],
    CellMargins->{{27, Inherited}, {80, 10}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["ChapTitle", "Presentation"],
    FontSize->54],
  
  Cell[StyleData["ChapTitle", "Printout"],
    CellMargins->{{2, 10}, {80, 6}},
    FontSize->30],
  
  Cell[StyleData["ChapTitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {80, 6}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["ChapTitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {80, 6}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemDingbat"],
    CellSize->{22, 14},
    TextAlignment->Right,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["ItemDingbat", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemDingbat", "Printout"],
    CellSize->{22, 13.125}],
  
  Cell[StyleData["ItemDingbat", "EnhancedPrintout"],
    CellSize->{22, 11}],
  
  Cell[StyleData["ItemDingbat", "EnhancedPrintoutNonGray"],
    CellSize->{22, 11}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item1"],
    CellMargins->{{19, 4}, {4, 4}},
    ParagraphIndent->-22,
    CounterIncrements->"Item1",
    StyleMenuListing->None],
  
  Cell[StyleData["Item1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item1", "Printout"],
    CellMargins->{{12, 0}, {2, 4}},
    FontSize->10],
  
  Cell[StyleData["Item1", "EnhancedPrintout"],
    CellMargins->{{16, 0}, {2, 4}},
    FontSize->10],
  
  Cell[StyleData["Item1", "EnhancedPrintoutNonGray"],
    CellMargins->{{16, 0}, {2, 4}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item1Continued"],
    CellMargins->{{41, 4}, {4, 1}},
    CounterIncrements->"Item1Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item1Continued", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item1Continued", "Printout"],
    CellMargins->{{34, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item1Continued", "EnhancedPrintout"],
    CellMargins->{{39, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item1Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 0}, {4, 1}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item2"],
    CellMargins->{{32, 4}, {4, 4}},
    ParagraphIndent->-22,
    CounterIncrements->"Item2",
    StyleMenuListing->None],
  
  Cell[StyleData["Item2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item2", "Printout"],
    CellMargins->{{26, 0}, {4, 4}},
    ParagraphIndent->-22,
    FontSize->10],
  
  Cell[StyleData["Item2", "EnhancedPrintout"],
    CellMargins->{{29, 0}, {2, 4}},
    ParagraphIndent->-22,
    FontSize->10],
  
  Cell[StyleData["Item2", "EnhancedPrintoutNonGray"],
    CellMargins->{{29, 0}, {2, 4}},
    ParagraphIndent->-22,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item2Continued"],
    CellMargins->{{54, 4}, {4, 1}},
    CounterIncrements->"Item2Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item2Continued", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item2Continued", "Printout"],
    CellMargins->{{27, 0}, {4, 1}}],
  
  Cell[StyleData["Item2Continued", "EnhancedPrintout"],
    CellMargins->{{52, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item2Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{52, 0}, {4, 1}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item3"],
    CellMargins->{{45, 4}, {4, 4}},
    ParagraphIndent->-23,
    CounterIncrements->"Item3",
    StyleMenuListing->None],
  
  Cell[StyleData["Item3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item3", "Printout"],
    CellMargins->{{27, 0}, {2, 4}}],
  
  Cell[StyleData["Item3", "EnhancedPrintout"],
    CellMargins->{{42, 0}, {2, 4}},
    FontSize->10],
  
  Cell[StyleData["Item3", "EnhancedPrintoutNonGray"],
    CellMargins->{{42, 0}, {2, 4}},
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item3Continued"],
    CellMargins->{{67, 4}, {4, 1}},
    CounterIncrements->"Item3Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item3Continued", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Item3Continued", "Printout"],
    CellMargins->{{27, 0}, {4, 1}}],
  
  Cell[StyleData["Item3Continued", "EnhancedPrintout"],
    CellMargins->{{65, 0}, {4, 1}},
    FontSize->10],
  
  Cell[StyleData["Item3Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{65, 0}, {4, 1}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedBulletText"],
    CellMargins->{{19, 4}, {0, 5}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedBulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedBulletText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedBulletText", "Printout"],
    ParagraphIndent->-20,
    FontSize->11],
  
  Cell[StyleData["ItemizedBulletText", "EnhancedPrintout"],
    ParagraphIndent->-19,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedBulletText", "EnhancedPrintoutNonGray"],
    ParagraphIndent->-19,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NoteBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {8, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["NoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NoteBox", "Printout"],
    CellMargins->{{2, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["NoteBox", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["NoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBox"],
    CellFrame->0.5,
    CellMargins->{{41, 4}, {8, 2}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ItemizedNoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedNoteBox", "Printout"],
    CellMargins->{{39, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedNoteBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedNoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {6, 2}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{37, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameMargins->{{8, 8}, {0, 8}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["ItemizedTopBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTopBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedTopBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {0, 6}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedTopBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {0, 6}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedBottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{37, 4}, {4, 0}},
    CellHorizontalScrolling->True,
    CellFrameMargins->{{8, 8}, {8, 0}},
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["ItemizedBottomBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedBottomBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedBottomBox", "EnhancedPrintout"],
    CellMargins->{{39, 4}, {6, 0}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedBottomBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 4}, {6, 0}},
    CellFrameColor->GrayLevel[0],
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpacedBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpacedBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleSpacedBox", "Printout"],
    CellMargins->{{2, 0}, {0, 0}},
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpacedBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpacedBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 0}},
    CellFrameColor->GrayLevel[0],
    FontFamily->"Palatino",
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNote"],
    CellMargins->{{41, 4}, {0, 12}},
    Hyphenation->True,
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedNote", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedNote", "Printout"],
    CellMargins->{{38, 4}, {0, 9}},
    FontSize->11],
  
  Cell[StyleData["ItemizedNote", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 0}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 0}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBelow"],
    CellMargins->{{41, 4}, {0, 8}},
    Hyphenation->True,
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedNoteBelow", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedNoteBelow", "Printout"],
    CellMargins->{{38, 4}, {0, 12}},
    FontSize->11],
  
  Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 8}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 8}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextBelowPic"],
    CellMargins->{{19, 4}, {0, 8}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextBelowPic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTextBelowPic", "Printout"],
    CellMargins->{{20, 4}, {2, 12}},
    ParagraphIndent->-18,
    FontSize->11],
  
  Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintout"],
    CellMargins->{{20, 4}, {2, 12}},
    ParagraphIndent->-17,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintoutNonGray"],
    CellMargins->{{20, 4}, {2, 12}},
    ParagraphIndent->-17,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote2"],
    CellMargins->{{41, 4}, {0, 4}},
    Hyphenation->True,
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedTextNote2", "Printout"],
    CellMargins->{{38, 4}, {0, 2}},
    FontSize->11],
  
  Cell[StyleData["ItemizedTextNote2", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 2}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote2", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 2}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem1"],
    CellMargins->{{48, 4}, {4, 4}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"NumberedItem1",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedItem1", "Printout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["NumberedItem1", "EnhancedPrintout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["NumberedItem1", "EnhancedPrintoutNonGray"],
    CellMargins->{{12, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem2"],
    CellMargins->{{71, 4}, {3, 3}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-21,
    CounterIncrements->"NumberedItem2",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedItem2", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem2", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem2", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem3"],
    CellMargins->{{94, 4}, {2, 2}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"NumberedItem3",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["NumberedItem3", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem3", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem3", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}},
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageHeaderBold"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["PageHeaderBold", "Printout"]],
  
  Cell[StyleData["PageHeaderBold", "EnhancedPrintout"],
    FontFamily->"Frutiger"],
  
  Cell[StyleData["PageHeaderBold", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SingleRowTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["SingleRowTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SingleRowTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["SingleRowTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["SingleRowTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsubsection"],
    CellMargins->{{27, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Subsubsubsection", "Printout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontSize->10],
  
  Cell[StyleData["Subsubsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Subsubsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 8}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{27, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    FontSize->21],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {8, 10}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{27, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontSize->24],
  
  Cell[StyleData["Subtitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {10, 15}},
    FontFamily->"Frutiger 55 Roman",
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextBelow"],
    CellMargins->{{27, 4}, {0, 14}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    Hyphenation->True,
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontSize->12],
  
  Cell[StyleData["TextBelow", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TextBelow", "Printout"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    FontSize->10],
  
  Cell[StyleData["TextBelow", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["TextBelow", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{27, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    FontSize->54],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->30],
  
  Cell[StyleData["Title", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30.5,
    FontWeight->"Plain"],
  
  Cell[StyleData["Title", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->30.5,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Undersubsection"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm]},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Undersubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Undersubsection", "Printout"],
    CellMargins->{{2, 0}, {7, 10}},
    FontSize->10],
  
  Cell[StyleData["Undersubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {7, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["Undersubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {7, 8}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SectionFirst"],
    CellMargins->{{27, 27}, {12, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SectionFirst", "Presentation"],
    FontSize->30],
  
  Cell[StyleData["SectionFirst", "Printout"],
    CellMargins->{{2, 0}, {0, 6}},
    PageBreakBelow->False,
    FontSize->18],
  
  Cell[StyleData["SectionFirst", "EnhancedPrintout"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {5, 6}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["SectionFirst", "EnhancedPrintoutNonGray"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {5, 6}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Frutiger 65 Bold",
    FontSize->16,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionFirst"],
    CellDingbat->None,
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsectionFirst", "Presentation"],
    FontSize->24],
  
  Cell[StyleData["SubsectionFirst", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 6}},
    FontSize->12],
  
  Cell[StyleData["SubsectionFirst", "Printout"],
    CellMargins->{{9, 0}, {5, 6}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontSize->12],
  
  Cell[StyleData["SubsectionFirst", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {5, 6}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["SubsectionFirst", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {5, 6}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->12,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionFirst"],
    CellMargins->{{27, 27}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["SubsubsectionFirst", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsectionFirst", "Printout"],
    CellMargins->{{2, 0}, {3, 3}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontSize->10],
  
  Cell[StyleData["SubsubsectionFirst", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 3}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["SubsubsectionFirst", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 3}},
    CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsubsectionFirst"],
    CellMargins->{{10, 4}, {0, 12}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubsubsubsectionFirst", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["SubsubsubsectionFirst", "Printout"],
    CellMargins->{{2, 0}, {3, 3}},
    FontSize->10],
  
  Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {3, 3}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {3, 3}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell["Spacer Cell", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Spacer"],
    CellMargins->{{10, 10}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->1},
    CellOpen->False,
    StyleMenuListing->None],
  
  Cell[StyleData["Spacer", "Printout"],
    CellOpen->True,
    FontSize->3]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DiscretionaryHyphen"],
    StyleMenuListing->None,
    FontSize->0.0625,
    FontColor->GrayLevel[1]],
  
  Cell[StyleData["DiscretionaryHyphen", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintout"],
    FontSize->10,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintoutNonGray"],
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller1"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller1", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.63],
  
  Cell[StyleData["PictureSmaller1", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.63],
  
  Cell[StyleData["PictureSmaller1", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.63]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller2"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller2", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.61],
  
  Cell[StyleData["PictureSmaller2", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.61],
  
  Cell[StyleData["PictureSmaller2", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.61]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller3"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller3", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.59],
  
  Cell[StyleData["PictureSmaller3", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.59],
  
  Cell[StyleData["PictureSmaller3", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.59]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller4"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller4", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.57],
  
  Cell[StyleData["PictureSmaller4", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.57],
  
  Cell[StyleData["PictureSmaller4", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.57]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller5"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller5", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.55],
  
  Cell[StyleData["PictureSmaller5", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.55],
  
  Cell[StyleData["PictureSmaller5", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.55]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureSmaller6"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureSmaller6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureSmaller6", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.53],
  
  Cell[StyleData["PictureSmaller6", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.53],
  
  Cell[StyleData["PictureSmaller6", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.53]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPicture"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPicture", "Printout"],
    CellMargins->{{55, Inherited}, {8, -4}},
    Magnification->0.65],
  
  Cell[StyleData["ItemPicture", "EnhancedPrintout"],
    CellMargins->{{60, Inherited}, {10, -3}},
    Magnification->0.65],
  
  Cell[StyleData["ItemPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{60, Inherited}, {10, -3}},
    Magnification->0.65]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller1"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller1", "Printout"],
    CellMargins->{{56, Inherited}, {9, -3}},
    Magnification->0.63],
  
  Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintout"],
    CellMargins->{{63, Inherited}, {10, -3}},
    Magnification->0.63],
  
  Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintoutNonGray"],
    CellMargins->{{63, Inherited}, {10, -3}},
    Magnification->0.63]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller2"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller2", "Printout"],
    CellMargins->{{58, Inherited}, {8, -4}},
    Magnification->0.61],
  
  Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintout"],
    CellMargins->{{65, Inherited}, {11, -3}},
    Magnification->0.61],
  
  Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintoutNonGray"],
    CellMargins->{{65, Inherited}, {11, -3}},
    Magnification->0.61]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller3"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller3", "Printout"],
    CellMargins->{{61, Inherited}, {10, -2}},
    Magnification->0.59],
  
  Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintout"],
    CellMargins->{{67, Inherited}, {11, -3}},
    Magnification->0.59],
  
  Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintoutNonGray"],
    CellMargins->{{67, Inherited}, {11, -3}},
    Magnification->0.59]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller4"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller4", "Printout"],
    CellMargins->{{63, Inherited}, {10, -2}},
    Magnification->0.57],
  
  Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintout"],
    CellMargins->{{69, Inherited}, {12, -4}},
    Magnification->0.57],
  
  Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintoutNonGray"],
    CellMargins->{{69, Inherited}, {12, -4}},
    Magnification->0.57]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller5"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller5", "Printout"],
    CellMargins->{{65, Inherited}, {11, -2}},
    Magnification->0.55],
  
  Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintout"],
    CellMargins->{{71, Inherited}, {13, -2}},
    Magnification->0.55],
  
  Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintoutNonGray"],
    CellMargins->{{71, Inherited}, {13, -2}},
    Magnification->0.55]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureSmaller6"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureSmaller6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureSmaller6", "Printout"],
    CellMargins->{{67, Inherited}, {12, -2}},
    Magnification->0.53],
  
  Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintout"],
    CellMargins->{{74, Inherited}, {13, -3}},
    Magnification->0.53],
  
  Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintoutNonGray"],
    CellMargins->{{74, Inherited}, {13, -3}},
    Magnification->0.53]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger1"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger1", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.68],
  
  Cell[StyleData["PictureBigger1", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.68],
  
  Cell[StyleData["PictureBigger1", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.68]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger2"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger2", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.71],
  
  Cell[StyleData["PictureBigger2", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.71],
  
  Cell[StyleData["PictureBigger2", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.71]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger3"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger3", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.74],
  
  Cell[StyleData["PictureBigger3", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.74],
  
  Cell[StyleData["PictureBigger3", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.74]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger4"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger4", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.77],
  
  Cell[StyleData["PictureBigger4", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.77],
  
  Cell[StyleData["PictureBigger4", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.77]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger5"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger5", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.8],
  
  Cell[StyleData["PictureBigger5", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.8],
  
  Cell[StyleData["PictureBigger5", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureBigger6"],
    CellMargins->{{10, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureBigger6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureBigger6", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.83],
  
  Cell[StyleData["PictureBigger6", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.83],
  
  Cell[StyleData["PictureBigger6", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {4, 2}},
    Magnification->0.83]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger1"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger1", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger1", "Printout"],
    CellMargins->{{50, Inherited}, {9, -3}},
    Magnification->0.68],
  
  Cell[StyleData["ItemPictureBigger1", "EnhancedPrintout"],
    CellMargins->{{57, Inherited}, {10, -3}},
    Magnification->0.68],
  
  Cell[StyleData["ItemPictureBigger1", "EnhancedPrintoutNonGray"],
    CellMargins->{{57, Inherited}, {10, -3}},
    Magnification->0.68]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger2"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger2", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger2", "Printout"],
    CellMargins->{{48, Inherited}, {8, -4}},
    Magnification->0.71],
  
  Cell[StyleData["ItemPictureBigger2", "EnhancedPrintout"],
    CellMargins->{{54, Inherited}, {10, -3}},
    Magnification->0.71],
  
  Cell[StyleData["ItemPictureBigger2", "EnhancedPrintoutNonGray"],
    CellMargins->{{54, Inherited}, {10, -3}},
    Magnification->0.71]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger3"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger3", "Printout"],
    CellMargins->{{46, Inherited}, {10, -2}},
    Magnification->0.74],
  
  Cell[StyleData["ItemPictureBigger3", "EnhancedPrintout"],
    CellMargins->{{52, Inherited}, {10, -3}},
    Magnification->0.74],
  
  Cell[StyleData["ItemPictureBigger3", "EnhancedPrintoutNonGray"],
    CellMargins->{{52, Inherited}, {10, -3}},
    Magnification->0.74]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger4"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger4", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger4", "Printout"],
    CellMargins->{{45, Inherited}, {10, -2}},
    Magnification->0.77],
  
  Cell[StyleData["ItemPictureBigger4", "EnhancedPrintout"],
    CellMargins->{{50, Inherited}, {10, -3}},
    Magnification->0.77],
  
  Cell[StyleData["ItemPictureBigger4", "EnhancedPrintoutNonGray"],
    CellMargins->{{50, Inherited}, {10, -3}},
    Magnification->0.77]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger5"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger5", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger5", "Printout"],
    CellMargins->{{43, Inherited}, {11, -2}},
    Magnification->0.8],
  
  Cell[StyleData["ItemPictureBigger5", "EnhancedPrintout"],
    CellMargins->{{49, Inherited}, {10, -3}},
    Magnification->0.8],
  
  Cell[StyleData["ItemPictureBigger5", "EnhancedPrintoutNonGray"],
    CellMargins->{{49, Inherited}, {10, -3}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemPictureBigger6"],
    CellMargins->{{41, Inherited}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemPictureBigger6", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemPictureBigger6", "Printout"],
    CellMargins->{{43, Inherited}, {12, -2}},
    Magnification->0.83],
  
  Cell[StyleData["ItemPictureBigger6", "EnhancedPrintout"],
    CellMargins->{{46, Inherited}, {8, -2}},
    Magnification->0.83],
  
  Cell[StyleData["ItemPictureBigger6", "EnhancedPrintoutNonGray"],
    CellMargins->{{46, Inherited}, {8, -2}},
    Magnification->0.83]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ScreenGraphic"],
    CellMargins->{{12, Inherited}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ScreenGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ScreenGraphic", "Printout"],
    CellMargins->{{2, Inherited}, {0, 8}}],
  
  Cell[StyleData["ScreenGraphic", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False],
  
  Cell[StyleData["ScreenGraphic", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrintGraphic"],
    CellMargins->{{12, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False,
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PrintGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PrintGraphic", "Printout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->2,
    "ClosedCellHeight"->2},
    CellOpen->False],
  
  Cell[StyleData["PrintGraphic", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->12},
    CellOpen->True],
  
  Cell[StyleData["PrintGraphic", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {0, 8}},
    CellElementSpacings->{"CellMinHeight"->12},
    CellOpen->True]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallTextSans"],
    CellMargins->{{10, 4}, {8, 8}},
    TextJustification->1,
    Hyphenation->True,
    LineSpacing->{1, 2},
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallTextSans", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["SmallTextSans", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->7],
  
  Cell[StyleData["SmallTextSans", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, -2},
    FontFamily->"Frutiger 55 Roman",
    FontSize->7]
  }, Closed]]
  }, Closed]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["AuthorTools", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BilateralCell"],
    CellMargins->{{27, 4}, {0, 8}},
    StyleMenuListing->None,
    FontSize->12,
    GridBoxOptions->{ColumnWidths->{0.33, 0.6},
    RowAlignments->Top,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BilateralCell", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BilateralCell", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}},
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["BilateralCell", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->10],
  
  Cell[StyleData["BilateralCell", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BilateralCell", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RuledPageBreak"],
    CellFrame->{{0, 0}, {0.25, 0}},
    CellMargins->{{27, 4}, {12, 0}},
    CellFrameMargins->{{0, 0}, {1, 0}},
    FontSize->8],
  
  Cell[StyleData["RuledPageBreak", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["RuledPageBreak", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}}],
  
  Cell[StyleData["RuledPageBreak", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    PageBreakBelow->True,
    FontSize->1],
  
  Cell[StyleData["RuledPageBreak", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    PageBreakBelow->True],
  
  Cell[StyleData["RuledPageBreak", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    PageBreakBelow->True]
  }, Closed]],
  
  Cell[StyleData["PaletteTitle"],
    CellFrame->{{0, 0}, {1, 0}},
    CellMargins->{{4, 0}, {Inherited, 0}},
    StyleMenuListing->None,
    ButtonStyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->RGBColor[0, 0.32549, 0.537255],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #2]}]&),
    ButtonEvaluator->None,
    ButtonStyle->"PaletteButton",
    ButtonMargins->3}],
  
  Cell[StyleData["PaletteButton"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonEvaluator->"Local",
    Active->True,
    ButtonMargins->6,
    Background->RGBColor[0.329412, 0.584314, 0.694118]}],
  
  Cell[StyleData["PaletteButton2"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    ButtonBoxOptions->{ButtonEvaluator->"Local",
    Active->True,
    ButtonMargins->4,
    Background->RGBColor[0.537255, 0.72549, 0.843137]}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Outline Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline1"],
    CellMargins->{{27, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    ParagraphIndent->-38,
    CounterIncrements->"Outline1",
    FontSize->18,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],
  
  Cell[StyleData["Outline1", "Presentation"],
    FontSize->27],
  
  Cell[StyleData["Outline1", "Printout"],
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline2"],
    CellMargins->{{57, 10}, {6, 6}},
    CellGroupingRules->{"SectionGrouping", 60},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontSize->15,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}],
  
  Cell[StyleData["Outline2", "Presentation"],
    FontSize->23],
  
  Cell[StyleData["Outline2", "Printout"],
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline3"],
    CellMargins->{{87, 10}, {5, 5}},
    CellGroupingRules->{"SectionGrouping", 70},
    ParagraphIndent->-21,
    CounterIncrements->"Outline3",
    FontSize->12,
    CounterBoxOptions->{CounterFunction:>Identity}],
  
  Cell[StyleData["Outline3", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Outline3", "Printout"],
    CounterBoxOptions->{CounterFunction:>Identity}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline4"],
    CellMargins->{{117, 10}, {4, 4}},
    CellGroupingRules->{"SectionGrouping", 80},
    ParagraphIndent->-18,
    CounterIncrements->"Outline4",
    FontSize->10,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["Outline4", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["Outline4", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Slide Show Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowNavigationBar"],
    Editable->False,
    CellFrame->True,
    CellMargins->{{0, 0}, {3, 3}},
    CellElementSpacings->{"CellMinHeight"->0.8125},
    CellGroupingRules->{"SectionGrouping", 30},
    CellFrameMargins->False,
    CellFrameColor->GrayLevel[1],
    CellFrameLabelMargins->False,
    TextAlignment->Center,
    CounterIncrements->"SlideShowNavigationBar",
    StyleMenuListing->None,
    FontSize->10,
    Background->GrayLevel[0.8],
    Magnification->1,
    GridBoxOptions->{GridBaseline->Center,
    RowSpacings->0,
    ColumnSpacings->0,
    ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
    RowAlignments->Baseline,
    ColumnAlignments->{
      Center, Center, Center, Center, Center, Center, Right, Center}}],
  
  Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
    Deletable->False,
    ShowCellBracket->False,
    CellMargins->{{-1, -1}, {-1, -1}},
    PageBreakAbove->True,
    CellFrameMargins->{{1, 1}, {0, 0}}],
  
  Cell[StyleData["SlideShowNavigationBar", "Printout"],
    CellMargins->{{18, 4}, {4, 4}},
    LineSpacing->{1, 3},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{0, 0}, {10, 0}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CellFrameMargins->{{12, 4}, {6, 12}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Plain",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.408011, 0.440726, 0.8]],
  
  Cell[StyleData["SlideShowSection", "Presentation"],
    FontSize->27],
  
  Cell[StyleData["SlideShowSection", "SlideShow"],
    ShowCellBracket->False,
    PageBreakAbove->True],
  
  Cell[StyleData["SlideShowSection", "Printout"],
    CellMargins->{{18, 30}, {0, 30}},
    CellFrameMargins->5,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideHyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontSize->26,
    FontColor->GrayLevel[0.400015],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMinHeight->0.85,
    ButtonMargins->0.5,
    ButtonNote->None}],
  
  Cell[StyleData["SlideHyperlink", "SlideShow"]],
  
  Cell[StyleData["SlideHyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideTOCLink"],
    CellMargins->{{24, Inherited}, {Inherited, Inherited}},
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMargins->1.5,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["SlideTOCLink", "SlideShow"]],
  
  Cell[StyleData["SlideTOCLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideTOC"],
    CellDingbat->"\[Bullet]",
    CellMargins->{{18, Inherited}, {Inherited, Inherited}},
    StyleMenuListing->None,
    FontFamily->"Helvetica"],
  
  Cell[StyleData["SlideTOC", "SlideShow"],
    FontSize->14],
  
  Cell[StyleData["SlideTOC", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Title Page, Contents, and Index", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsTitle"],
    CellMargins->{{21, 4}, {12, 24}},
    FontFamily->"Helvetica",
    FontSize->24,
    FontWeight->"Bold",
    FontColor->RGBColor[0.592157, 0.313726, 0.313726]],
  
  Cell[StyleData["ContentsTitle", "Presentation"],
    FontSize->36],
  
  Cell[StyleData["ContentsTitle", "Printout"],
    CellMargins->{{12, 0}, {102, 89}},
    PageBreakBelow->False,
    FontSize->30.5,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["ContentsTitle", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {15, 30}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->30.5,
    FontWeight->"Plain",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsSection"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{35, 4}, {3, 18}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ContentsSection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ContentsSection", "Printout"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["ContentsSection", "EnhancedPrintout"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->11,
    FontWeight->"Plain"],
  
  Cell[StyleData["ContentsSection", "EnhancedPrintoutNonGray"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->11,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{20, 4}, {5, 20}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["IndexSection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["IndexSection", "Printout"],
    CellMargins->{{12, 0}, {5, 20}},
    PageBreakBelow->False,
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Contents"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{50, 4}, {0, 5}},
    CellGroupingRules->{"SectionGrouping", 90},
    StyleMenuListing->None],
  
  Cell[StyleData["Contents", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Contents", "Printout"],
    CellMargins->{{40, 4}, {0, 5}},
    FontSize->11],
  
  Cell[StyleData["Contents", "EnhancedPrintout"],
    CellMargins->{{40, 5}, {0, 5}},
    FontFamily->"Palatino",
    FontSize->11],
  
  Cell[StyleData["Contents", "EnhancedPrintoutNonGray"],
    CellMargins->{{40, 5}, {0, 5}},
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Index"],
    CellMargins->{{21, 4}, {0, 0}},
    ParagraphIndent->-48,
    StyleMenuListing->None],
  
  Cell[StyleData["Index", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Index", "Printout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontSize->9],
  
  Cell[StyleData["Index", "EnhancedPrintout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->9],
  
  Cell[StyleData["Index", "EnhancedPrintoutNonGray"],
    CellMargins->{{13, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSubentry"],
    CellMargins->{{36, 4}, {0, 0}},
    ParagraphIndent->-48],
  
  Cell[StyleData["IndexSubentry", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["IndexSubentry", "Printout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontSize->9],
  
  Cell[StyleData["IndexSubentry", "EnhancedPrintout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Index2Column"],
    CellMargins->{{21, 4}, {0, 8}},
    ParagraphIndent->-20,
    TabSpacings->1,
    StyleMenuListing->None,
    FontSize->10,
    GridBoxOptions->{ColumnWidths->0.5,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["Index2Column", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["Index2Column", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->8],
  
  Cell[StyleData["Index2Column", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {1, 1}},
    LineSpacing->{1, 0.2},
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["Index2Column", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {1, 1}},
    LineSpacing->{1, 0.2},
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Leader"],
    TabFilling->".",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Plain"],
  
  Cell[StyleData["Leader", "Printout"],
    FontSize->10],
  
  Cell[StyleData["Leader", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LeaderNoDots"],
    TabFilling->" ",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Plain"],
  
  Cell[StyleData["LeaderNoDots", "Printout"],
    FontSize->10],
  
  Cell[StyleData["LeaderNoDots", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["PageLink", "Printout"],
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["PageLink", "EnhancedPrintout"],
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCPage"],
    CellSize->{22, Inherited},
    TextAlignment->Right,
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Plain"],
  
  Cell[StyleData["TOCPage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCPage", "Printout"],
    FontSize->10],
  
  Cell[StyleData["TOCPage", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCTitle"],
    CellMargins->{{20, 0}, {1, 8}},
    CellGroupingRules->{"SectionGrouping", 70},
    TabSpacings->46,
    CounterIncrements->"TOCTitle",
    CounterAssignments->{{"TOCSection", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["TOCTitle", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCTitle", "Printout"],
    CellMargins->{{12, 0}, {1, 8}},
    PageBreakBelow->False,
    TabSpacings->47.4,
    FontSize->11],
  
  Cell[StyleData["TOCTitle", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {2, 10}},
    PageBreakBelow->False,
    TabSpacings->49.3,
    FontFamily->"Frutiger 65 Bold",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSection"],
    CellMargins->{{48, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 75},
    TabSpacings->42.9,
    CounterIncrements->"TOCSection",
    CounterAssignments->{{"TOCSubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->12],
  
  Cell[StyleData["TOCSection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSection", "Printout"],
    CellMargins->{{30, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->12],
  
  Cell[StyleData["TOCSection", "EnhancedPrintout"],
    CellMargins->{{26, 0}, {1, 3}},
    PageBreakBelow->False,
    TabSpacings->46.45,
    FontFamily->"Frutiger",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsection"],
    CellMargins->{{76, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 80},
    TabSpacings->39.8,
    CounterIncrements->"TOCSubsection",
    CounterAssignments->{{"TOCSubsubsection", 0}},
    FontSize->12],
  
  Cell[StyleData["TOCSubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsection", "Printout"],
    CellMargins->{{70, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->10],
  
  Cell[StyleData["TOCSubsection", "EnhancedPrintout"],
    CellMargins->{{38, 0}, {1, 1}},
    PageBreakBelow->False,
    TabSpacings->45.15,
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsubsection"],
    CellMargins->{{104, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 85},
    TabSpacings->36.7,
    CounterIncrements->"TOCSubsubsection",
    FontSize->12],
  
  Cell[StyleData["TOCSubsubsection", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsubsection", "Printout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->9],
  
  Cell[StyleData["TOCSubsubsection", "EnhancedPrintout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCTitleDingbat"],
    CellSize->{34, Inherited},
    TextAlignment->Right],
  
  Cell[StyleData["TOCTitleDingbat", "EnhancedPrintout"],
    FontFamily->"Frutiger",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSectionDingbat"],
    CellSize->{38, Inherited},
    TextAlignment->Right],
  
  Cell[StyleData["TOCSectionDingbat", "EnhancedPrintout"],
    FontFamily->"Frutiger",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsectionDingbat"],
    CellSize->{54, Inherited},
    TextAlignment->Right],
  
  Cell[StyleData["TOCSubsectionDingbat", "EnhancedPrintout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCTitleCondensed"],
    CellMargins->{{20, 0}, {1, 8}},
    CellGroupingRules->{"SectionGrouping", 70},
    TabSpacings->50.4,
    CounterIncrements->"TOCTitleCondensed",
    CounterAssignments->{{"TOCSectionCondensed", 0}, {
        "TOCSubsectionCondensed", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["TOCTitleCondensed", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCTitleCondensed", "Printout"],
    CellMargins->{{12, 0}, {1, 8}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["TOCTitleCondensed", "EnhancedPrintout"],
    CellMargins->{{12, 0}, {1, 8}},
    PageBreakBelow->False,
    FontFamily->"Frutiger 65 Bold",
    FontSize->11,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSectionCondensed"],
    CellMargins->{{48, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 75},
    TabSpacings->47.4,
    CounterIncrements->"TOCSectionCondensed",
    CounterAssignments->{{"TOCSubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold",
    FontColor->GrayLevel[0.2]],
  
  Cell[StyleData["TOCSectionCondensed", "Presentation"],
    FontSize->15],
  
  Cell[StyleData["TOCSectionCondensed", "Printout"],
    CellMargins->{{36, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["TOCSectionCondensed", "EnhancedPrintout"],
    CellMargins->{{36, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsectionCondensed"],
    PageWidth->470,
    CellMargins->{{76, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 80},
    TextJustification->1,
    Hyphenation->True,
    FontSize->12],
  
  Cell[StyleData["TOCSubsectionCondensed", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsectionCondensed", "Printout"],
    CellMargins->{{72, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->10],
  
  Cell[StyleData["TOCSubsectionCondensed", "EnhancedPrintout"],
    CellMargins->{{72, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TOCSubsubsectionCondensed"],
    CellMargins->{{104, 0}, {1, 1}},
    CellGroupingRules->{"SectionGrouping", 85},
    TabSpacings->39.3,
    CounterIncrements->"TOCSubsubsectionCondensed",
    FontSize->12],
  
  Cell[StyleData["TOCSubsubsectionCondensed", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TOCSubsubsectionCondensed", "Printout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontSize->9],
  
  Cell[StyleData["TOCSubsubsectionCondensed", "EnhancedPrintout"],
    CellMargins->{{96, 0}, {1, 1}},
    PageBreakBelow->False,
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TitlePageGraphic"],
    CellMargins->{{0, 0}, {100, 20}},
    Evaluatable->False,
    PageBreakBelow->False,
    TextAlignment->Center],
  
  Cell[StyleData["TitlePageGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TitlePageGraphic", "Printout"],
    CellMargins->{{0, 0}, {230, 88}}],
  
  Cell[StyleData["TitlePageGraphic", "EnhancedPrintout"],
    CellMargins->{{0, 0}, {230, 88}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TitlePageLogo"],
    CellMargins->{{0, 0}, {0, 0}}],
  
  Cell[StyleData["TitlePageLogo", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TitlePageLogo", "Printout"]],
  
  Cell[StyleData["TitlePageLogo", "EnhancedPrintout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Horizontal Lines", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Line1"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{10, 4}, {-16, 9}},
    StyleMenuListing->None,
    FontSize->2],
  
  Cell[StyleData["Line1", "Presentation"],
    FontSize->3],
  
  Cell[StyleData["Line1", "Printout"],
    CellMargins->{{2, 0}, {-16, 9}}]
  }, Closed]],
  
  Cell["\<\

The item above is horizontal 0.5 pt line\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramTop"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{10, 4}, {-18, 18}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramTop", "Presentation"],
    FontSize->6],
  
  Cell[StyleData["ProgramTop", "Printout"],
    CellMargins->{{2, 0}, {-18, 18}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramTop line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramBottom"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{10, 4}, {-10, -2}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramBottom", "Presentation"],
    FontSize->6],
  
  Cell[StyleData["ProgramBottom", "Printout"],
    CellMargins->{{2, 0}, {-10, -2}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramBottom line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SessionLabel"],
    CellFrame->{{0.5, 0}, {0, 0.5}},
    CellMargins->{{10, 4}, {-4, 18}},
    LineSpacing->{1, 0},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SessionLabel", "Presentation"],
    FontSize->14],
  
  Cell[StyleData["SessionLabel", "Printout"],
    CellMargins->{{2, 0}, {-4, 18}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Page Headers and Footers", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageHeader"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageHeader", "Printout"]],
  
  Cell[StyleData["PageHeader", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["PageHeader", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Bold"],
  
  Cell[StyleData["PageNumber", "Printout"]],
  
  Cell[StyleData["PageNumber", "EnhancedPrintout"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"],
  
  Cell[StyleData["PageNumber", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 65 Bold",
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageFooter"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6],
  
  Cell[StyleData["PageFooter", "Printout"]],
  
  Cell[StyleData["PageFooter", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["PageFooter", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["For compatibility", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontSlant->"Italic"],
  
  Cell[StyleData["Header", "Printout"]],
  
  Cell[StyleData["Header", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman",
    FontSlant->"Plain"],
  
  Cell[StyleData["Header", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman",
    FontSlant->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Footer"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6],
  
  Cell[StyleData["Footer", "Printout"]],
  
  Cell[StyleData["Footer", "EnhancedPrintout"],
    FontFamily->"Frutiger 55 Roman"],
  
  Cell[StyleData["Footer", "EnhancedPrintoutNonGray"],
    FontFamily->"Frutiger 55 Roman"]
  }, Closed]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    Hyphenation->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["CellExpression", "EnhancedPrintout"],
    FontFamily->"Courier Std",
    FontSize->10],
  
  Cell[StyleData["CellExpression", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InputForm"],
    InputAutoReplacements->{},
    AllowInlineCells->False,
    Hyphenation->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["InputForm", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["InputForm", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["OutputForm", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["StandardForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm", "EnhancedPrintout"],
    FontFamily->"Courier Std"],
  
  Cell[StyleData["StandardForm", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier Std"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notation Package Styles", "Section",
    GeneratedCell->True,
    CellTags->"NotationPackage"],
  
  Cell["\<\
The cells below define certain styles needed by the Notation \
package. These styles serve to make visible otherwise invisible \
tagboxes.\
\>", "Text",
    GeneratedCell->True,
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationTemplateStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 1, 0.850004],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationPatternWrapperStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.900008, 0.979995],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationMadeBoxesWrapperStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[0.900008, 0.889998, 1],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Notation:S1"->{
    Cell[2212, 69, 86, 1, 48, "Subsection",
      CellTags->"Notation:S1"],
    Cell[8123, 288, 91, 1, 24, "SubsubsectionIcon",
      CellTags->{"Notation:S1", "NotationDocumentation"}],
    Cell[8217, 291, 5264, 157, 148, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation", 
        "NotationDocumentation"}],
    Cell[13484, 450, 122, 1, 27, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[13609, 453, 628, 12, 100, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14240, 467, 118, 1, 56, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14361, 470, 161, 3, 38, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14525, 475, 186, 5, 56, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14714, 482, 641, 17, 39, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[15358, 501, 371, 12, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[15754, 517, 280, 7, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16037, 526, 370, 10, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16422, 539, 196, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16643, 548, 237, 5, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16883, 555, 254, 6, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[17152, 564, 700, 17, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[17855, 583, 211, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[18069, 590, 658, 17, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[18730, 609, 165, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[18920, 617, 329, 8, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[19252, 627, 317, 8, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[19584, 638, 253, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[19840, 645, 1342, 38, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[21185, 685, 175, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[21385, 693, 474, 14, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[21862, 709, 655, 18, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[22532, 730, 209, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[22744, 736, 1269, 36, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24016, 774, 146, 1, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24187, 779, 435, 11, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24625, 792, 359, 9, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24999, 804, 261, 6, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[25263, 812, 214, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[25480, 819, 648, 17, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[26131, 838, 179, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[26313, 844, 632, 15, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[26970, 863, 540, 14, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[27513, 879, 694, 18, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[28222, 900, 419, 7, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[28678, 912, 92, 1, 20, "SubsubsectionIcon",
      CellTags->{"Notation:S1", "NotationDocumentation"}],
    Cell[28773, 915, 2815, 85, 114, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize", 
        "NotationDocumentation"}],
    Cell[31591, 1002, 127, 1, 15, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[31721, 1005, 385, 7, 56, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[32109, 1014, 255, 5, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[32367, 1021, 453, 13, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[32823, 1036, 284, 6, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[33132, 1046, 449, 14, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[33584, 1062, 301, 8, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[33900, 1073, 234, 5, 24, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[34137, 1080, 829, 24, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[34969, 1106, 287, 6, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[35281, 1116, 600, 16, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[35884, 1134, 161, 3, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36060, 1140, 270, 7, 40, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36333, 1149, 278, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36614, 1158, 194, 5, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36833, 1167, 203, 5, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[37039, 1174, 270, 6, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[37324, 1183, 742, 23, 68, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[38069, 1208, 219, 4, 60, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[38291, 1214, 271, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[38565, 1223, 694, 19, 43, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[39296, 1247, 97, 1, 20, "SubsubsectionIcon",
      CellTags->{"Notation:S1", "NotationDocumentation"}],
    Cell[39396, 1250, 3583, 106, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation", 
        "NotationDocumentation"}],
    Cell[42982, 1358, 128, 1, 70, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[43113, 1361, 602, 15, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[43718, 1378, 294, 9, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[44015, 1389, 378, 11, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[44418, 1404, 446, 13, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[44867, 1419, 223, 5, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[45105, 1427, 245, 7, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[45375, 1438, 505, 14, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[45883, 1454, 478, 15, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[46376, 1472, 725, 18, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[47104, 1492, 180, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[47309, 1500, 453, 11, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[47765, 1513, 345, 9, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[48125, 1525, 469, 15, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[48631, 1545, 101, 1, 20, "SubsubsectionIcon",
      CellTags->{"Notation:S1", "NotationDocumentation"}],
    Cell[48735, 1548, 638, 16, 70, "Text",
      CellTags->{
      "Must use palette", "Notation:Documentation:Entering Notations", 
        "Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[49376, 1566, 3478, 88, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[52857, 1656, 641, 14, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[53501, 1672, 145, 1, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[53649, 1675, 431, 11, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[54083, 1688, 386, 9, 70, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[54472, 1699, 1109, 27, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[55584, 1728, 168, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[55755, 1734, 486, 12, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[56244, 1748, 249, 6, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}]},
  "Notation:S1.1"->{
    Cell[2301, 72, 62, 1, 46, "Subsubsection",
      CellTags->"Notation:S1.1"],
    Cell[8217, 291, 5264, 157, 148, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation", 
        "NotationDocumentation"}],
    Cell[13484, 450, 122, 1, 27, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[13609, 453, 628, 12, 100, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14240, 467, 118, 1, 56, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14361, 470, 161, 3, 38, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14525, 475, 186, 5, 56, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14714, 482, 641, 17, 39, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[15358, 501, 371, 12, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[15754, 517, 280, 7, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16037, 526, 370, 10, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16422, 539, 196, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16643, 548, 237, 5, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16883, 555, 254, 6, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[17152, 564, 700, 17, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[17855, 583, 211, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[18069, 590, 658, 17, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[18730, 609, 165, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[18920, 617, 329, 8, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[19252, 627, 317, 8, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[19584, 638, 253, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[19840, 645, 1342, 38, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[21185, 685, 175, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[21385, 693, 474, 14, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[21862, 709, 655, 18, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[22532, 730, 209, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[22744, 736, 1269, 36, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24016, 774, 146, 1, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24187, 779, 435, 11, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24625, 792, 359, 9, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24999, 804, 261, 6, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[25263, 812, 214, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[25480, 819, 648, 17, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[26131, 838, 179, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[26313, 844, 632, 15, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[26970, 863, 540, 14, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[27513, 879, 694, 18, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[28222, 900, 419, 7, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]},
  "Notation:S1.2"->{
    Cell[2366, 75, 63, 1, 46, "Subsubsection",
      CellTags->"Notation:S1.2"],
    Cell[28773, 915, 2815, 85, 114, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize", 
        "NotationDocumentation"}],
    Cell[31591, 1002, 127, 1, 15, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[31721, 1005, 385, 7, 56, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[32109, 1014, 255, 5, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[32367, 1021, 453, 13, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[32823, 1036, 284, 6, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[33132, 1046, 449, 14, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[33584, 1062, 301, 8, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[33900, 1073, 234, 5, 24, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[34137, 1080, 829, 24, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[34969, 1106, 287, 6, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[35281, 1116, 600, 16, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[35884, 1134, 161, 3, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36060, 1140, 270, 7, 40, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36333, 1149, 278, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36614, 1158, 194, 5, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36833, 1167, 203, 5, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[37039, 1174, 270, 6, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[37324, 1183, 742, 23, 68, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[38069, 1208, 219, 4, 60, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[38291, 1214, 271, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[38565, 1223, 694, 19, 43, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}]},
  "Notation:S1.3"->{
    Cell[2432, 78, 68, 1, 46, "Subsubsection",
      CellTags->"Notation:S1.3"],
    Cell[39396, 1250, 3583, 106, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation", 
        "NotationDocumentation"}],
    Cell[42982, 1358, 128, 1, 70, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[43113, 1361, 602, 15, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[43718, 1378, 294, 9, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[44015, 1389, 378, 11, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[44418, 1404, 446, 13, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[44867, 1419, 223, 5, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[45105, 1427, 245, 7, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[45375, 1438, 505, 14, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[45883, 1454, 478, 15, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[46376, 1472, 725, 18, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[47104, 1492, 180, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[47309, 1500, 453, 11, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[47765, 1513, 345, 9, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[48125, 1525, 469, 15, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}]},
  "Notation:S1.4"->{
    Cell[2503, 81, 72, 1, 46, "Subsubsection",
      CellTags->"Notation:S1.4"],
    Cell[48735, 1548, 638, 16, 70, "Text",
      CellTags->{
      "Must use palette", "Notation:Documentation:Entering Notations", 
        "Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[49376, 1566, 3478, 88, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[52857, 1656, 641, 14, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[53501, 1672, 145, 1, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[53649, 1675, 431, 11, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[54083, 1688, 386, 9, 70, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[54472, 1699, 1109, 27, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[55584, 1728, 168, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[55755, 1734, 486, 12, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[56244, 1748, 249, 6, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}]},
  "Notation:S2"->{
    Cell[2612, 87, 85, 1, 48, "Subsection",
      CellTags->"Notation:S2"],
    Cell[56666, 1765, 111, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S2", "NotationDocumentation"}],
    Cell[56780, 1768, 1434, 37, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
        "NotationDocumentation"}],
    Cell[58217, 1807, 2380, 53, 70, "DefinitionBox",
      CellTags->{
      "List of Boxes", "Notation:S2", "Notation:S2.1", 
        "NotationDocumentation"}],
    Cell[60600, 1862, 146, 1, 70, "Caption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[60749, 1865, 675, 15, 70, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[61427, 1882, 170, 4, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[61600, 1888, 1158, 32, 70, "Input",
      CellTags->{
      "Ring Operations", "Notation:S2", "Notation:S2.1", 
        "NotationDocumentation"}],
    Cell[62761, 1922, 248, 6, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63034, 1932, 281, 6, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63318, 1940, 317, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63672, 1953, 165, 3, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63840, 1958, 369, 10, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[64224, 1971, 567, 14, 70, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[64794, 1987, 182, 4, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65001, 1995, 385, 11, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65389, 2008, 343, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65747, 2019, 199, 4, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65971, 2027, 197, 4, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[66171, 2033, 198, 4, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[66384, 2040, 251, 7, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[66638, 2049, 1665, 47, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[68306, 2098, 371, 13, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[68702, 2115, 390, 8, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[69095, 2125, 366, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[69510, 2139, 107, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S2", "NotationDocumentation"}],
    Cell[69620, 2142, 560, 17, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
        "NotationDocumentation"}],
    Cell[70183, 2161, 149, 1, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[70335, 2164, 548, 14, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[70908, 2182, 283, 7, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71194, 2191, 298, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71507, 2202, 204, 5, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71736, 2211, 216, 5, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71955, 2218, 311, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[72315, 2232, 116, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S2", "NotationDocumentation"}],
    Cell[72434, 2235, 1094, 28, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.3", 
        "Notation:Documentation:Changing Precedences", 
        "NotationDocumentation"}],
    Cell[73531, 2265, 274, 6, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[73830, 2275, 362, 10, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[74195, 2287, 554, 13, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[74764, 2303, 726, 21, 70, "Text",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}]},
  "Notation:S2.1"->{
    Cell[2700, 90, 82, 1, 46, "Subsubsection",
      CellTags->"Notation:S2.1"],
    Cell[56780, 1768, 1434, 37, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
        "NotationDocumentation"}],
    Cell[58217, 1807, 2380, 53, 70, "DefinitionBox",
      CellTags->{
      "List of Boxes", "Notation:S2", "Notation:S2.1", 
        "NotationDocumentation"}],
    Cell[60600, 1862, 146, 1, 70, "Caption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[60749, 1865, 675, 15, 70, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[61427, 1882, 170, 4, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[61600, 1888, 1158, 32, 70, "Input",
      CellTags->{
      "Ring Operations", "Notation:S2", "Notation:S2.1", 
        "NotationDocumentation"}],
    Cell[62761, 1922, 248, 6, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63034, 1932, 281, 6, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63318, 1940, 317, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63672, 1953, 165, 3, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63840, 1958, 369, 10, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[64224, 1971, 567, 14, 70, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[64794, 1987, 182, 4, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65001, 1995, 385, 11, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65389, 2008, 343, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65747, 2019, 199, 4, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65971, 2027, 197, 4, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[66171, 2033, 198, 4, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[66384, 2040, 251, 7, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[66638, 2049, 1665, 47, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[68306, 2098, 371, 13, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[68702, 2115, 390, 8, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[69095, 2125, 366, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]},
  "Notation:S2.2"->{
    Cell[2785, 93, 78, 1, 46, "Subsubsection",
      CellTags->"Notation:S2.2"],
    Cell[69620, 2142, 560, 17, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
        "NotationDocumentation"}],
    Cell[70183, 2161, 149, 1, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[70335, 2164, 548, 14, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[70908, 2182, 283, 7, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71194, 2191, 298, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71507, 2202, 204, 5, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71736, 2211, 216, 5, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71955, 2218, 311, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}]},
  "Notation:S2.3"->{
    Cell[2866, 96, 87, 1, 46, "Subsubsection",
      CellTags->"Notation:S2.3"],
    Cell[72434, 2235, 1094, 28, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.3", 
        "Notation:Documentation:Changing Precedences", 
        "NotationDocumentation"}],
    Cell[73531, 2265, 274, 6, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[73830, 2275, 362, 10, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[74195, 2287, 554, 13, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[74764, 2303, 726, 21, 70, "Text",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}]},
  "Notation:S3"->{
    Cell[2990, 102, 80, 1, 48, "Subsection",
      CellTags->"Notation:S3"],
    Cell[75636, 2333, 783, 23, 70, "Text",
      CellTags->{
      "Notation:Documentation:Options", "Notation:S3", 
        "NotationDocumentation"}],
    Cell[76444, 2360, 138, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S3", "NotationDocumentation"}],
    Cell[76585, 2366, 1723, 47, 70, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:Action", "Notation:S3", "Notation:S3.1", 
        "NotationDocumentation"}],
    Cell[78311, 2415, 177, 5, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[78491, 2422, 537, 17, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[79031, 2441, 200, 4, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[79234, 2447, 874, 22, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80111, 2471, 135, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80271, 2476, 248, 6, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80522, 2484, 389, 11, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80926, 2498, 549, 16, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[81478, 2516, 142, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[81623, 2519, 874, 22, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[82500, 2543, 156, 2, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[82681, 2549, 248, 6, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[82932, 2557, 249, 6, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[83196, 2566, 488, 13, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[83687, 2581, 281, 9, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[83993, 2594, 873, 22, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[84869, 2618, 1148, 26, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[86020, 2646, 1623, 34, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[87692, 2686, 143, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S3", "NotationDocumentation"}],
    Cell[87838, 2692, 5644, 152, 70, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2", 
        "NotationDocumentation"}],
    Cell[93485, 2846, 190, 5, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[93678, 2853, 915, 33, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[94596, 2888, 602, 21, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[95201, 2911, 328, 11, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[95532, 2924, 1966, 51, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[97501, 2977, 129, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[97655, 2982, 323, 8, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[97981, 2992, 286, 7, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[98304, 3004, 165, 3, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[98472, 3009, 294, 8, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[98803, 3022, 668, 17, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[99474, 3041, 489, 12, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[100012, 3059, 155, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S3", "NotationDocumentation"}],
    Cell[100170, 3065, 4592, 127, 70, "DefinitionBox3Col",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[104765, 3194, 142, 1, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[104910, 3197, 1135, 28, 70, "text",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[106048, 3227, 240, 6, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[106291, 3235, 212, 5, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[106540, 3245, 150, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S3", "NotationDocumentation"}],
    Cell[106693, 3251, 1493, 41, 70, "DefinitionBox",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[108189, 3294, 116, 1, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[108308, 3297, 547, 13, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[108858, 3312, 149, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[109010, 3315, 161, 3, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}]},
  "Notation:S3.1"->{
    Cell[3073, 105, 109, 4, 46, "Subsubsection",
      CellTags->"Notation:S3.1"],
    Cell[76585, 2366, 1723, 47, 70, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:Action", "Notation:S3", "Notation:S3.1", 
        "NotationDocumentation"}],
    Cell[78311, 2415, 177, 5, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[78491, 2422, 537, 17, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[79031, 2441, 200, 4, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[79234, 2447, 874, 22, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80111, 2471, 135, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80271, 2476, 248, 6, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80522, 2484, 389, 11, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80926, 2498, 549, 16, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[81478, 2516, 142, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[81623, 2519, 874, 22, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[82500, 2543, 156, 2, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[82681, 2549, 248, 6, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[82932, 2557, 249, 6, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[83196, 2566, 488, 13, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[83687, 2581, 281, 9, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[83993, 2594, 873, 22, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[84869, 2618, 1148, 26, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[86020, 2646, 1623, 34, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}]},
  "Notation:S3.2"->{
    Cell[3185, 111, 114, 4, 46, "Subsubsection",
      CellTags->"Notation:S3.2"],
    Cell[87838, 2692, 5644, 152, 70, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2", 
        "NotationDocumentation"}],
    Cell[93485, 2846, 190, 5, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[93678, 2853, 915, 33, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[94596, 2888, 602, 21, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[95201, 2911, 328, 11, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[95532, 2924, 1966, 51, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[97501, 2977, 129, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[97655, 2982, 323, 8, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[97981, 2992, 286, 7, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[98304, 3004, 165, 3, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[98472, 3009, 294, 8, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[98803, 3022, 668, 17, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[99474, 3041, 489, 12, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}]},
  "Notation:S3.3"->{
    Cell[3302, 117, 167, 6, 46, "Subsubsection",
      CellTags->"Notation:S3.3"],
    Cell[100170, 3065, 4592, 127, 70, "DefinitionBox3Col",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[104765, 3194, 142, 1, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[104910, 3197, 1135, 28, 70, "text",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[106048, 3227, 240, 6, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[106291, 3235, 212, 5, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}]},
  "Notation:S3.4"->{
    Cell[3472, 125, 121, 4, 46, "Subsubsection",
      CellTags->"Notation:S3.4"],
    Cell[106693, 3251, 1493, 41, 70, "DefinitionBox",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[108189, 3294, 116, 1, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[108308, 3297, 547, 13, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[108858, 3312, 149, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[109010, 3315, 161, 3, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}]},
  "Notation:S4"->{
    Cell[3630, 134, 87, 1, 48, "Subsection",
      CellTags->"Notation:S4"],
    Cell[109324, 3327, 179, 2, 70, "Subsubsection",
      CellGroupingRules->"NormalGrouping",
      CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"}],
    Cell[109506, 3331, 714, 19, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.1", 
        "Notation:Documentation:Advanced Features", "NotationDocumentation"}],
    
    Cell[111366, 3387, 92, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[111461, 3390, 787, 25, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
        "NotationDocumentation"}],
    Cell[112251, 3417, 172, 5, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[112426, 3424, 898, 24, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[113327, 3450, 326, 8, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[113738, 3465, 962, 27, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[114703, 3494, 245, 7, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[114973, 3505, 175, 5, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[115151, 3512, 184, 4, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[115350, 3519, 422, 11, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[115775, 3532, 382, 12, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[116160, 3546, 371, 9, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[116534, 3557, 286, 8, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[116845, 3569, 184, 5, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[117032, 3576, 210, 4, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[117257, 3583, 537, 16, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[117831, 3604, 143, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[117977, 3610, 1236, 37, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag",
         "NotationDocumentation"}],
    Cell[119216, 3649, 194, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[119435, 3658, 268, 7, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[119706, 3667, 361, 9, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120082, 3679, 230, 6, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120315, 3687, 332, 7, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120672, 3698, 184, 4, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120859, 3704, 258, 6, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[121166, 3716, 168, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[121337, 3722, 1137, 23, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.4", 
        "Notation:Definition:NotationPatternTag", "NotationDocumentation"}],
    Cell[122477, 3747, 211, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[122691, 3754, 1021, 25, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[123715, 3781, 416, 7, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[124134, 3790, 182, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[124319, 3796, 379, 10, 70, "Input",
      CellTags->{
      "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
        "NotationDocumentation"}],
    Cell[124701, 3808, 187, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[124913, 3816, 274, 6, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125190, 3824, 227, 5, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125432, 3832, 196, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125653, 3840, 278, 7, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125934, 3849, 309, 8, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[126258, 3860, 365, 8, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[126626, 3870, 265, 7, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[126916, 3881, 1019, 25, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[127938, 3908, 680, 16, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[128621, 3926, 629, 15, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[129265, 3944, 351, 9, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[129653, 3958, 149, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[129805, 3964, 750, 14, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.5", 
        "Notation:Definition:NotationMadeBoxesTag", "NotationDocumentation"}],
    
    Cell[130558, 3980, 221, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[130804, 3989, 1204, 30, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[132011, 4021, 960, 23, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[132986, 4047, 344, 8, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[133367, 4060, 202, 6, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[133572, 4068, 993, 34, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.6", 
        "Changing precedences and the option SyntaxForm", 
        "Notation:Documentation:SyntaxForm", "NotationDocumentation"}],
    Cell[134568, 4104, 187, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[134780, 4112, 249, 6, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[135032, 4120, 374, 10, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[135421, 4133, 257, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[135681, 4140, 626, 17, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[136310, 4159, 140, 1, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[136475, 4164, 353, 9, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[136831, 4175, 374, 10, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[137220, 4188, 188, 4, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[137411, 4194, 10333, 230, 70, "OptionBox3Col",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[147747, 4426, 212, 4, 70, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[147962, 4432, 667, 16, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[148632, 4450, 6945, 200, 70, "DefinitionBox",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[155580, 4652, 202, 5, 70, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}]},
  "Notation:S4.2"->{
    Cell[3720, 137, 182, 3, 46, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[3905, 142, 63, 1, 46, "Subsubsection",
      CellTags->"Notation:S4.2"],
    Cell[111461, 3390, 787, 25, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
        "NotationDocumentation"}],
    Cell[112251, 3417, 172, 5, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[112426, 3424, 898, 24, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[113327, 3450, 326, 8, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[113738, 3465, 962, 27, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[114703, 3494, 245, 7, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[114973, 3505, 175, 5, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[115151, 3512, 184, 4, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[115350, 3519, 422, 11, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[115775, 3532, 382, 12, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[116160, 3546, 371, 9, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[116534, 3557, 286, 8, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[116845, 3569, 184, 5, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[117032, 3576, 210, 4, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[117257, 3583, 537, 16, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}]},
  "Notation:S4.3"->{
    Cell[3720, 137, 182, 3, 46, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[3971, 145, 114, 4, 46, "Subsubsection",
      CellTags->"Notation:S4.3"],
    Cell[117977, 3610, 1236, 37, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag",
         "NotationDocumentation"}],
    Cell[119216, 3649, 194, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[119435, 3658, 268, 7, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[119706, 3667, 361, 9, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120082, 3679, 230, 6, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120315, 3687, 332, 7, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120672, 3698, 184, 4, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120859, 3704, 258, 6, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}]},
  "Notation:S4.4"->{
    Cell[3720, 137, 182, 3, 46, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[4088, 151, 139, 4, 46, "Subsubsection",
      CellTags->"Notation:S4.4"],
    Cell[121337, 3722, 1137, 23, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.4", 
        "Notation:Definition:NotationPatternTag", "NotationDocumentation"}],
    Cell[122477, 3747, 211, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[122691, 3754, 1021, 25, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[123715, 3781, 416, 7, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[124134, 3790, 182, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[124319, 3796, 379, 10, 70, "Input",
      CellTags->{
      "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
        "NotationDocumentation"}],
    Cell[124701, 3808, 187, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[124913, 3816, 274, 6, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125190, 3824, 227, 5, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125432, 3832, 196, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125653, 3840, 278, 7, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125934, 3849, 309, 8, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[126258, 3860, 365, 8, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[126626, 3870, 265, 7, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[126916, 3881, 1019, 25, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[127938, 3908, 680, 16, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[128621, 3926, 629, 15, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[129265, 3944, 351, 9, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}]},
  "Notation:S4.5"->{
    Cell[3720, 137, 182, 3, 46, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[4230, 157, 120, 4, 46, "Subsubsection",
      CellTags->"Notation:S4.5"],
    Cell[129805, 3964, 750, 14, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.5", 
        "Notation:Definition:NotationMadeBoxesTag", "NotationDocumentation"}],
    
    Cell[130558, 3980, 221, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[130804, 3989, 1204, 30, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[132011, 4021, 960, 23, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[132986, 4047, 344, 8, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}]},
  "Notation:S4.6"->{
    Cell[3720, 137, 182, 3, 46, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[4353, 163, 173, 6, 46, "Subsubsection",
      CellTags->"Notation:S4.6"],
    Cell[133572, 4068, 993, 34, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.6", 
        "Changing precedences and the option SyntaxForm", 
        "Notation:Documentation:SyntaxForm", "NotationDocumentation"}],
    Cell[134568, 4104, 187, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[134780, 4112, 249, 6, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[135032, 4120, 374, 10, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[135421, 4133, 257, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[135681, 4140, 626, 17, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[136310, 4159, 140, 1, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[136475, 4164, 353, 9, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[136831, 4175, 374, 10, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[137220, 4188, 188, 4, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[137411, 4194, 10333, 230, 70, "OptionBox3Col",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[147747, 4426, 212, 4, 70, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[147962, 4432, 667, 16, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[148632, 4450, 6945, 200, 70, "DefinitionBox",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[155580, 4652, 202, 5, 70, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}]},
  "Notation:S5"->{
    Cell[4563, 174, 80, 1, 48, "Subsection",
      CellTags->"Notation:S5"],
    Cell[155928, 4666, 303, 9, 70, "Text",
      CellTags->{
      "Notation:S5", "Notation:Documentation:Guidelines", 
        "NotationDocumentation"}],
    Cell[156256, 4679, 111, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[156370, 4682, 646, 14, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"}],
    Cell[157053, 4701, 103, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[157159, 4704, 531, 10, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"}],
    Cell[157727, 4719, 125, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[157855, 4722, 751, 13, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"}],
    Cell[158643, 4740, 122, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[158768, 4743, 487, 9, 70, "Text",
      CellTags->{
      "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
        "NotationDocumentation"}],
    Cell[159258, 4754, 186, 4, 70, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[159447, 4760, 516, 13, 70, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[159988, 4777, 220, 5, 70, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[160211, 4784, 296, 8, 70, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[160522, 4795, 423, 10, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[160948, 4807, 390, 8, 70, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[161363, 4819, 292, 7, 70, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[161769, 4832, 249, 5, 70, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[162067, 4843, 163, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[162233, 4849, 568, 16, 84, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[162804, 4867, 811, 20, 56, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[163618, 4889, 285, 10, 36, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[163906, 4901, 2533, 86, 57, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[166442, 4989, 739, 24, 68, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[167184, 5015, 1212, 42, 84, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[168399, 5059, 529, 13, 84, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[168931, 5074, 951, 30, 158, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[169897, 5107, 146, 1, 36, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "Notation:S5.6", "NotationDocumentation"}]},
  "Notation:S5.1"->{
    Cell[4646, 177, 82, 1, 46, "Subsubsection",
      CellTags->"Notation:S5.1"],
    Cell[156370, 4682, 646, 14, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"}]},
  "Notation:S5.2"->{
    Cell[4731, 180, 74, 1, 46, "Subsubsection",
      CellTags->"Notation:S5.2"],
    Cell[157159, 4704, 531, 10, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"}]},
  "Notation:S5.3"->{
    Cell[4808, 183, 96, 1, 46, "Subsubsection",
      CellTags->"Notation:S5.3"],
    Cell[157855, 4722, 751, 13, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"}]},
  "Notation:S5.4"->{
    Cell[4907, 186, 93, 1, 46, "Subsubsection",
      CellTags->"Notation:S5.4"],
    Cell[158768, 4743, 487, 9, 70, "Text",
      CellTags->{
      "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
        "NotationDocumentation"}],
    Cell[159258, 4754, 186, 4, 70, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[159447, 4760, 516, 13, 70, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[159988, 4777, 220, 5, 70, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[160211, 4784, 296, 8, 70, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[160522, 4795, 423, 10, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[160948, 4807, 390, 8, 70, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[161363, 4819, 292, 7, 70, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[161769, 4832, 249, 5, 70, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}]},
  "Notation:S5.5"->{
    Cell[5003, 189, 134, 4, 46, "Subsubsection",
      CellTags->"Notation:S5.5"],
    Cell[162233, 4849, 568, 16, 84, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[162804, 4867, 811, 20, 56, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[163618, 4889, 285, 10, 36, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[163906, 4901, 2533, 86, 57, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[166442, 4989, 739, 24, 68, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[167184, 5015, 1212, 42, 84, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[168399, 5059, 529, 13, 84, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[168931, 5074, 951, 30, 158, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}]},
  "Notation:S5.6"->{
    Cell[5140, 195, 88, 1, 46, "Subsubsection",
      CellTags->"Notation:S5.6"],
    Cell[169897, 5107, 146, 1, 36, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "Notation:S5.6", "NotationDocumentation"}]},
  "Notation:S5.7"->{
    Cell[5231, 198, 82, 1, 46, "Subsubsection",
      CellTags->"Notation:S5.7"]},
  "NotationDocumentation"->{
    Cell[5362, 205, 115, 2, 38, "Section",
      CellGroupingRules->"SectionGrouping",
      CellTags->"NotationDocumentation"],
    Cell[5480, 209, 1034, 34, 120, "Text",
      CellTags->"NotationDocumentation"],
    Cell[6517, 245, 766, 16, 120, "Text",
      CellTags->"NotationDocumentation"],
    Cell[7286, 263, 687, 16, 88, "Text",
      CellTags->"NotationDocumentation"],
    Cell[7998, 283, 100, 1, 36, "SubsectionIcon",
      CellTags->"NotationDocumentation"],
    Cell[8123, 288, 91, 1, 24, "SubsubsectionIcon",
      CellTags->{"Notation:S1", "NotationDocumentation"}],
    Cell[8217, 291, 5264, 157, 148, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation", 
        "NotationDocumentation"}],
    Cell[13484, 450, 122, 1, 27, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[13609, 453, 628, 12, 100, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14240, 467, 118, 1, 56, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14361, 470, 161, 3, 38, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14525, 475, 186, 5, 56, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[14714, 482, 641, 17, 39, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[15358, 501, 371, 12, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[15754, 517, 280, 7, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16037, 526, 370, 10, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16422, 539, 196, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16643, 548, 237, 5, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[16883, 555, 254, 6, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[17152, 564, 700, 17, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[17855, 583, 211, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[18069, 590, 658, 17, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[18730, 609, 165, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[18920, 617, 329, 8, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[19252, 627, 317, 8, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[19584, 638, 253, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[19840, 645, 1342, 38, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[21185, 685, 175, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[21385, 693, 474, 14, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[21862, 709, 655, 18, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[22532, 730, 209, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[22744, 736, 1269, 36, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24016, 774, 146, 1, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24187, 779, 435, 11, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24625, 792, 359, 9, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[24999, 804, 261, 6, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[25263, 812, 214, 5, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[25480, 819, 648, 17, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[26131, 838, 179, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[26313, 844, 632, 15, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[26970, 863, 540, 14, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[27513, 879, 694, 18, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[28222, 900, 419, 7, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
    Cell[28678, 912, 92, 1, 20, "SubsubsectionIcon",
      CellTags->{"Notation:S1", "NotationDocumentation"}],
    Cell[28773, 915, 2815, 85, 114, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize", 
        "NotationDocumentation"}],
    Cell[31591, 1002, 127, 1, 15, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[31721, 1005, 385, 7, 56, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[32109, 1014, 255, 5, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[32367, 1021, 453, 13, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[32823, 1036, 284, 6, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[33132, 1046, 449, 14, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[33584, 1062, 301, 8, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[33900, 1073, 234, 5, 24, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[34137, 1080, 829, 24, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[34969, 1106, 287, 6, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[35281, 1116, 600, 16, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[35884, 1134, 161, 3, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36060, 1140, 270, 7, 40, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36333, 1149, 278, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36614, 1158, 194, 5, 44, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[36833, 1167, 203, 5, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[37039, 1174, 270, 6, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[37324, 1183, 742, 23, 68, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[38069, 1208, 219, 4, 60, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[38291, 1214, 271, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[38565, 1223, 694, 19, 43, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
    Cell[39296, 1247, 97, 1, 20, "SubsubsectionIcon",
      CellTags->{"Notation:S1", "NotationDocumentation"}],
    Cell[39396, 1250, 3583, 106, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation", 
        "NotationDocumentation"}],
    Cell[42982, 1358, 128, 1, 70, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[43113, 1361, 602, 15, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[43718, 1378, 294, 9, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[44015, 1389, 378, 11, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[44418, 1404, 446, 13, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[44867, 1419, 223, 5, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[45105, 1427, 245, 7, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[45375, 1438, 505, 14, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[45883, 1454, 478, 15, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[46376, 1472, 725, 18, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[47104, 1492, 180, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[47309, 1500, 453, 11, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[47765, 1513, 345, 9, 70, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[48125, 1525, 469, 15, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
    Cell[48631, 1545, 101, 1, 20, "SubsubsectionIcon",
      CellTags->{"Notation:S1", "NotationDocumentation"}],
    Cell[48735, 1548, 638, 16, 70, "Text",
      CellTags->{
      "Must use palette", "Notation:Documentation:Entering Notations", 
        "Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[49376, 1566, 3478, 88, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[52857, 1656, 641, 14, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[53501, 1672, 145, 1, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[53649, 1675, 431, 11, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[54083, 1688, 386, 9, 70, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[54472, 1699, 1109, 27, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[55584, 1728, 168, 4, 70, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[55755, 1734, 486, 12, 70, "Input",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[56244, 1748, 249, 6, 70, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
    Cell[56542, 1760, 99, 1, 26, "SubsectionIcon",
      CellTags->"NotationDocumentation"],
    Cell[56666, 1765, 111, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S2", "NotationDocumentation"}],
    Cell[56780, 1768, 1434, 37, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
        "NotationDocumentation"}],
    Cell[58217, 1807, 2380, 53, 70, "DefinitionBox",
      CellTags->{
      "List of Boxes", "Notation:S2", "Notation:S2.1", 
        "NotationDocumentation"}],
    Cell[60600, 1862, 146, 1, 70, "Caption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[60749, 1865, 675, 15, 70, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[61427, 1882, 170, 4, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[61600, 1888, 1158, 32, 70, "Input",
      CellTags->{
      "Ring Operations", "Notation:S2", "Notation:S2.1", 
        "NotationDocumentation"}],
    Cell[62761, 1922, 248, 6, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63034, 1932, 281, 6, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63318, 1940, 317, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63672, 1953, 165, 3, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[63840, 1958, 369, 10, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[64224, 1971, 567, 14, 70, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[64794, 1987, 182, 4, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65001, 1995, 385, 11, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65389, 2008, 343, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65747, 2019, 199, 4, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[65971, 2027, 197, 4, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[66171, 2033, 198, 4, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[66384, 2040, 251, 7, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[66638, 2049, 1665, 47, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[68306, 2098, 371, 13, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[68702, 2115, 390, 8, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[69095, 2125, 366, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
    Cell[69510, 2139, 107, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S2", "NotationDocumentation"}],
    Cell[69620, 2142, 560, 17, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
        "NotationDocumentation"}],
    Cell[70183, 2161, 149, 1, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[70335, 2164, 548, 14, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[70908, 2182, 283, 7, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71194, 2191, 298, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71507, 2202, 204, 5, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71736, 2211, 216, 5, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[71955, 2218, 311, 8, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
    Cell[72315, 2232, 116, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S2", "NotationDocumentation"}],
    Cell[72434, 2235, 1094, 28, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.3", 
        "Notation:Documentation:Changing Precedences", 
        "NotationDocumentation"}],
    Cell[73531, 2265, 274, 6, 70, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[73830, 2275, 362, 10, 70, "Input",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[74195, 2287, 554, 13, 70, "Output",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[74764, 2303, 726, 21, 70, "Text",
      CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
    Cell[75539, 2330, 94, 1, 26, "SubsectionIcon",
      CellTags->"NotationDocumentation"],
    Cell[75636, 2333, 783, 23, 70, "Text",
      CellTags->{
      "Notation:Documentation:Options", "Notation:S3", 
        "NotationDocumentation"}],
    Cell[76444, 2360, 138, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S3", "NotationDocumentation"}],
    Cell[76585, 2366, 1723, 47, 70, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:Action", "Notation:S3", "Notation:S3.1", 
        "NotationDocumentation"}],
    Cell[78311, 2415, 177, 5, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[78491, 2422, 537, 17, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[79031, 2441, 200, 4, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[79234, 2447, 874, 22, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80111, 2471, 135, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80271, 2476, 248, 6, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80522, 2484, 389, 11, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[80926, 2498, 549, 16, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[81478, 2516, 142, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[81623, 2519, 874, 22, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[82500, 2543, 156, 2, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[82681, 2549, 248, 6, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[82932, 2557, 249, 6, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[83196, 2566, 488, 13, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[83687, 2581, 281, 9, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[83993, 2594, 873, 22, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[84869, 2618, 1148, 26, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[86020, 2646, 1623, 34, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
    Cell[87692, 2686, 143, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S3", "NotationDocumentation"}],
    Cell[87838, 2692, 5644, 152, 70, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2", 
        "NotationDocumentation"}],
    Cell[93485, 2846, 190, 5, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[93678, 2853, 915, 33, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[94596, 2888, 602, 21, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[95201, 2911, 328, 11, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[95532, 2924, 1966, 51, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[97501, 2977, 129, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[97655, 2982, 323, 8, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[97981, 2992, 286, 7, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[98304, 3004, 165, 3, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[98472, 3009, 294, 8, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[98803, 3022, 668, 17, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[99474, 3041, 489, 12, 70, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
    Cell[100012, 3059, 155, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S3", "NotationDocumentation"}],
    Cell[100170, 3065, 4592, 127, 70, "DefinitionBox3Col",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[104765, 3194, 142, 1, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[104910, 3197, 1135, 28, 70, "text",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[106048, 3227, 240, 6, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[106291, 3235, 212, 5, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
    Cell[106540, 3245, 150, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S3", "NotationDocumentation"}],
    Cell[106693, 3251, 1493, 41, 70, "DefinitionBox",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[108189, 3294, 116, 1, 70, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[108308, 3297, 547, 13, 70, "Text",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[108858, 3312, 149, 1, 70, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[109010, 3315, 161, 3, 70, "Input",
      CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
    Cell[109220, 3324, 101, 1, 26, "SubsectionIcon",
      CellTags->"NotationDocumentation"],
    Cell[109324, 3327, 179, 2, 70, "Subsubsection",
      CellGroupingRules->"NormalGrouping",
      CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"}],
    Cell[109506, 3331, 714, 19, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.1", 
        "Notation:Documentation:Advanced Features", "NotationDocumentation"}],
    
    Cell[110223, 3352, 1118, 31, 70, "Text",
      CellTags->"NotationDocumentation"],
    Cell[111366, 3387, 92, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[111461, 3390, 787, 25, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
        "NotationDocumentation"}],
    Cell[112251, 3417, 172, 5, 70, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[112426, 3424, 898, 24, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[113327, 3450, 326, 8, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[113738, 3465, 962, 27, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[114703, 3494, 245, 7, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[114973, 3505, 175, 5, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[115151, 3512, 184, 4, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[115350, 3519, 422, 11, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[115775, 3532, 382, 12, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[116160, 3546, 371, 9, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[116534, 3557, 286, 8, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[116845, 3569, 184, 5, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[117032, 3576, 210, 4, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[117257, 3583, 537, 16, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
    Cell[117831, 3604, 143, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[117977, 3610, 1236, 37, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag",
         "NotationDocumentation"}],
    Cell[119216, 3649, 194, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[119435, 3658, 268, 7, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[119706, 3667, 361, 9, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120082, 3679, 230, 6, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120315, 3687, 332, 7, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120672, 3698, 184, 4, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[120859, 3704, 258, 6, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
    Cell[121166, 3716, 168, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[121337, 3722, 1137, 23, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.4", 
        "Notation:Definition:NotationPatternTag", "NotationDocumentation"}],
    Cell[122477, 3747, 211, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[122691, 3754, 1021, 25, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[123715, 3781, 416, 7, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[124134, 3790, 182, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[124319, 3796, 379, 10, 70, "Input",
      CellTags->{
      "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
        "NotationDocumentation"}],
    Cell[124701, 3808, 187, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[124913, 3816, 274, 6, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125190, 3824, 227, 5, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125432, 3832, 196, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125653, 3840, 278, 7, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[125934, 3849, 309, 8, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[126258, 3860, 365, 8, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[126626, 3870, 265, 7, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[126916, 3881, 1019, 25, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[127938, 3908, 680, 16, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[128621, 3926, 629, 15, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[129265, 3944, 351, 9, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
    Cell[129653, 3958, 149, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[129805, 3964, 750, 14, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.5", 
        "Notation:Definition:NotationMadeBoxesTag", "NotationDocumentation"}],
    
    Cell[130558, 3980, 221, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[130804, 3989, 1204, 30, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[132011, 4021, 960, 23, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[132986, 4047, 344, 8, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
    Cell[133367, 4060, 202, 6, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S4", "NotationDocumentation"}],
    Cell[133572, 4068, 993, 34, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.6", 
        "Changing precedences and the option SyntaxForm", 
        "Notation:Documentation:SyntaxForm", "NotationDocumentation"}],
    Cell[134568, 4104, 187, 4, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[134780, 4112, 249, 6, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[135032, 4120, 374, 10, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[135421, 4133, 257, 5, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[135681, 4140, 626, 17, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[136310, 4159, 140, 1, 70, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[136475, 4164, 353, 9, 70, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[136831, 4175, 374, 10, 70, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[137220, 4188, 188, 4, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[137411, 4194, 10333, 230, 70, "OptionBox3Col",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[147747, 4426, 212, 4, 70, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[147962, 4432, 667, 16, 70, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[148632, 4450, 6945, 200, 70, "DefinitionBox",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[155580, 4652, 202, 5, 70, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
    Cell[155831, 4663, 94, 1, 26, "SubsectionIcon",
      CellTags->"NotationDocumentation"],
    Cell[155928, 4666, 303, 9, 70, "Text",
      CellTags->{
      "Notation:S5", "Notation:Documentation:Guidelines", 
        "NotationDocumentation"}],
    Cell[156256, 4679, 111, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[156370, 4682, 646, 14, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"}],
    Cell[157053, 4701, 103, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[157159, 4704, 531, 10, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"}],
    Cell[157727, 4719, 125, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[157855, 4722, 751, 13, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"}],
    Cell[158643, 4740, 122, 1, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[158768, 4743, 487, 9, 70, "Text",
      CellTags->{
      "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
        "NotationDocumentation"}],
    Cell[159258, 4754, 186, 4, 70, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[159447, 4760, 516, 13, 70, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[159988, 4777, 220, 5, 70, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[160211, 4784, 296, 8, 70, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[160522, 4795, 423, 10, 70, "Text",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[160948, 4807, 390, 8, 70, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[161363, 4819, 292, 7, 70, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[161658, 4828, 108, 2, 70, "Print",
      CellTags->"NotationDocumentation"],
    Cell[161769, 4832, 249, 5, 70, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
    Cell[162067, 4843, 163, 4, 70, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "NotationDocumentation"}],
    Cell[162233, 4849, 568, 16, 84, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[162804, 4867, 811, 20, 56, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[163618, 4889, 285, 10, 36, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[163906, 4901, 2533, 86, 57, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[166442, 4989, 739, 24, 68, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[167184, 5015, 1212, 42, 84, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[168399, 5059, 529, 13, 84, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[168931, 5074, 951, 30, 158, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
    Cell[169897, 5107, 146, 1, 36, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "Notation:S5.6", "NotationDocumentation"}]},
  "Notation:Definition:Notation"->{
    Cell[8217, 291, 5264, 157, 148, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation", 
        "NotationDocumentation"}],
    Cell[39396, 1250, 3583, 106, 70, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation", 
        "NotationDocumentation"}]},
  "Notation:Definition:Symbolize"->{
    Cell[28773, 915, 2815, 85, 114, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize", 
        "NotationDocumentation"}]},
  "Must use palette"->{
    Cell[48735, 1548, 638, 16, 70, "Text",
      CellTags->{
      "Must use palette", "Notation:Documentation:Entering Notations", 
        "Notation:S1", "Notation:S1.4", "NotationDocumentation"}]},
  "Notation:Documentation:Entering Notations"->{
    Cell[48735, 1548, 638, 16, 70, "Text",
      CellTags->{
      "Must use palette", "Notation:Documentation:Entering Notations", 
        "Notation:S1", "Notation:S1.4", "NotationDocumentation"}]},
  "Notation:Documentation:Precedence"->{
    Cell[56780, 1768, 1434, 37, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
        "NotationDocumentation"}]},
  "List of Boxes"->{
    Cell[58217, 1807, 2380, 53, 70, "DefinitionBox",
      CellTags->{
      "List of Boxes", "Notation:S2", "Notation:S2.1", 
        "NotationDocumentation"}]},
  "Ring Operations"->{
    Cell[61600, 1888, 1158, 32, 70, "Input",
      CellTags->{
      "Ring Operations", "Notation:S2", "Notation:S2.1", 
        "NotationDocumentation"}]},
  "Notation:Documentation:Parentheses"->{
    Cell[69620, 2142, 560, 17, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
        "NotationDocumentation"}]},
  "Notation:Documentation:Changing Precedences"->{
    Cell[72434, 2235, 1094, 28, 70, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.3", 
        "Notation:Documentation:Changing Precedences", 
        "NotationDocumentation"}]},
  "Notation:Documentation:Options"->{
    Cell[75636, 2333, 783, 23, 70, "Text",
      CellTags->{
      "Notation:Documentation:Options", "Notation:S3", 
        "NotationDocumentation"}]},
  "Notation:Definition:Action"->{
    Cell[76585, 2366, 1723, 47, 70, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:Action", "Notation:S3", "Notation:S3.1", 
        "NotationDocumentation"}]},
  "Notation:Definition:WorkingForm"->{
    Cell[87838, 2692, 5644, 152, 70, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2", 
        "NotationDocumentation"}]},
  "Notation:S4.1"->{
    Cell[109324, 3327, 179, 2, 70, "Subsubsection",
      CellGroupingRules->"NormalGrouping",
      CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"}],
    Cell[109506, 3331, 714, 19, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.1", 
        "Notation:Documentation:Advanced Features", 
        "NotationDocumentation"}]},
  "Notation:Documentation:Advanced Features"->{
    Cell[109506, 3331, 714, 19, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.1", 
        "Notation:Documentation:Advanced Features", 
        "NotationDocumentation"}]},
  "Notation:Documentation:TagBoxes"->{
    Cell[111461, 3390, 787, 25, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
        "NotationDocumentation"}]},
  "Notation:Documentation:NotationBoxTag"->{
    Cell[117977, 3610, 1236, 37, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag",
         "NotationDocumentation"}]},
  "Notation:Definition:NotationPatternTag"->{
    Cell[121337, 3722, 1137, 23, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.4", 
        "Notation:Definition:NotationPatternTag", "NotationDocumentation"}]},
  "Complex Patterns:testing function"->{
    Cell[124319, 3796, 379, 10, 70, "Input",
      CellTags->{
      "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
        "NotationDocumentation"}]},
  "Notation:Definition:NotationMadeBoxesTag"->{
    Cell[129805, 3964, 750, 14, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.5", 
        "Notation:Definition:NotationMadeBoxesTag", 
        "NotationDocumentation"}]},
  "Changing precedences and the option SyntaxForm"->{
    Cell[133572, 4068, 993, 34, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.6", 
        "Changing precedences and the option SyntaxForm", 
        "Notation:Documentation:SyntaxForm", "NotationDocumentation"}]},
  "Notation:Documentation:SyntaxForm"->{
    Cell[133572, 4068, 993, 34, 70, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.6", 
        "Changing precedences and the option SyntaxForm", 
        "Notation:Documentation:SyntaxForm", "NotationDocumentation"}]},
  "Notation:Documentation:Guidelines"->{
    Cell[155928, 4666, 303, 9, 70, "Text",
      CellTags->{
      "Notation:S5", "Notation:Documentation:Guidelines", 
        "NotationDocumentation"}]},
  "Parse without evaluation"->{
    Cell[158768, 4743, 487, 9, 70, "Text",
      CellTags->{
      "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
        "NotationDocumentation"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Notation:S1", 417438, 13785},
  {"Notation:S1.1", 428446, 13974},
  {"Notation:S1.2", 433068, 14053},
  {"Notation:S1.3", 435899, 14102},
  {"Notation:S1.4", 437874, 14137},
  {"Notation:S2", 439316, 14164},
  {"Notation:S2.1", 444373, 14256},
  {"Notation:S2.2", 447395, 14311},
  {"Notation:S2.3", 448519, 14332},
  {"Notation:S3", 449297, 14348},
  {"Notation:S3.1", 455274, 14452},
  {"Notation:S3.2", 457744, 14495},
  {"Notation:S3.3", 459484, 14526},
  {"Notation:S3.4", 460239, 14540},
  {"Notation:S4", 460960, 14553},
  {"Notation:S4.2", 469870, 14711},
  {"Notation:S4.3", 472047, 14751},
  {"Notation:S4.4", 473353, 14776},
  {"Notation:S4.5", 475937, 14823},
  {"Notation:S4.6", 476885, 14843},
  {"Notation:S5", 479118, 14883},
  {"Notation:S5.1", 482621, 14947},
  {"Notation:S5.2", 482845, 14952},
  {"Notation:S5.3", 483069, 14957},
  {"Notation:S5.4", 483293, 14962},
  {"Notation:S5.5", 484535, 14985},
  {"Notation:S5.6", 485684, 15007},
  {"Notation:S5.7", 485920, 15012},
  {"NotationDocumentation", 486032, 15015},
  {"Notation:Definition:Notation", 521052, 15631},
  {"Notation:Definition:Symbolize", 521445, 15640},
  {"Must use palette", 521648, 15645},
  {"Notation:Documentation:Entering Notations", 521898, 15650},
  {"Notation:Documentation:Precedence", 522140, 15655},
  {"List of Boxes", 522335, 15660},
  {"Ring Operations", 522521, 15665},
  {"Notation:Documentation:Parentheses", 522720, 15670},
  {"Notation:Documentation:Changing Precedences", 522945, 15675},
  {"Notation:Documentation:Options", 523176, 15681},
  {"Notation:Definition:Action", 523363, 15686},
  {"Notation:Definition:WorkingForm", 523582, 15691},
  {"Notation:S4.1", 523789, 15696},
  {"Notation:Documentation:Advanced Features", 524198, 15705},
  {"Notation:Documentation:TagBoxes", 524427, 15711},
  {"Notation:Documentation:NotationBoxTag", 524644, 15716},
  {"Notation:Definition:NotationPatternTag", 524869, 15721},
  {"Complex Patterns:testing function", 525090, 15726},
  {"Notation:Definition:NotationMadeBoxesTag", 525313, 15731},
  {"Changing precedences and the option SyntaxForm", 525557, 15737},
  {"Notation:Documentation:SyntaxForm", 525831, 15743},
  {"Notation:Documentation:Guidelines", 526105, 15749},
  {"Parse without evaluation", 526293, 15754}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 204, 6, 13, "Section",
  CellGroupingRules->"SectionGrouping"],
Cell[1983, 61, 204, 4, 40, "Text"],

Cell[CellGroupData[{
Cell[2212, 69, 86, 1, 48, "Subsection",
  CellTags->"Notation:S1"],
Cell[2301, 72, 62, 1, 46, "Subsubsection",
  CellTags->"Notation:S1.1"],
Cell[2366, 75, 63, 1, 46, "Subsubsection",
  CellTags->"Notation:S1.2"],
Cell[2432, 78, 68, 1, 46, "Subsubsection",
  CellTags->"Notation:S1.3"],
Cell[2503, 81, 72, 1, 46, "Subsubsection",
  CellTags->"Notation:S1.4"]
}, Closed]],

Cell[CellGroupData[{
Cell[2612, 87, 85, 1, 48, "Subsection",
  CellTags->"Notation:S2"],
Cell[2700, 90, 82, 1, 46, "Subsubsection",
  CellTags->"Notation:S2.1"],
Cell[2785, 93, 78, 1, 46, "Subsubsection",
  CellTags->"Notation:S2.2"],
Cell[2866, 96, 87, 1, 46, "Subsubsection",
  CellTags->"Notation:S2.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[2990, 102, 80, 1, 48, "Subsection",
  CellTags->"Notation:S3"],
Cell[3073, 105, 109, 4, 46, "Subsubsection",
  CellTags->"Notation:S3.1"],
Cell[3185, 111, 114, 4, 46, "Subsubsection",
  CellTags->"Notation:S3.2"],
Cell[3302, 117, 167, 6, 46, "Subsubsection",
  CellTags->"Notation:S3.3"],
Cell[3472, 125, 121, 4, 46, "Subsubsection",
  CellTags->"Notation:S3.4"]
}, Closed]],

Cell[CellGroupData[{
Cell[3630, 134, 87, 1, 48, "Subsection",
  CellTags->"Notation:S4"],
Cell[3720, 137, 182, 3, 46, "Subsubsection",
  CellTags->{
  "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
    "Notation:S4.6"}],
Cell[3905, 142, 63, 1, 46, "Subsubsection",
  CellTags->"Notation:S4.2"],
Cell[3971, 145, 114, 4, 46, "Subsubsection",
  CellTags->"Notation:S4.3"],
Cell[4088, 151, 139, 4, 46, "Subsubsection",
  CellTags->"Notation:S4.4"],
Cell[4230, 157, 120, 4, 46, "Subsubsection",
  CellTags->"Notation:S4.5"],
Cell[4353, 163, 173, 6, 46, "Subsubsection",
  CellTags->"Notation:S4.6"]
}, Closed]],

Cell[CellGroupData[{
Cell[4563, 174, 80, 1, 48, "Subsection",
  CellTags->"Notation:S5"],
Cell[4646, 177, 82, 1, 46, "Subsubsection",
  CellTags->"Notation:S5.1"],
Cell[4731, 180, 74, 1, 46, "Subsubsection",
  CellTags->"Notation:S5.2"],
Cell[4808, 183, 96, 1, 46, "Subsubsection",
  CellTags->"Notation:S5.3"],
Cell[4907, 186, 93, 1, 46, "Subsubsection",
  CellTags->"Notation:S5.4"],
Cell[5003, 189, 134, 4, 46, "Subsubsection",
  CellTags->"Notation:S5.5"],
Cell[5140, 195, 88, 1, 46, "Subsubsection",
  CellTags->"Notation:S5.6"],
Cell[5231, 198, 82, 1, 46, "Subsubsection",
  CellTags->"Notation:S5.7"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5362, 205, 115, 2, 38, "Section",
  CellGroupingRules->"SectionGrouping",
  CellTags->"NotationDocumentation"],
Cell[5480, 209, 1034, 34, 120, "Text",
  CellTags->"NotationDocumentation"],
Cell[6517, 245, 766, 16, 120, "Text",
  CellTags->"NotationDocumentation"],
Cell[7286, 263, 687, 16, 88, "Text",
  CellTags->"NotationDocumentation"],

Cell[CellGroupData[{
Cell[7998, 283, 100, 1, 36, "SubsectionIcon",
  CellTags->"NotationDocumentation"],

Cell[CellGroupData[{
Cell[8123, 288, 91, 1, 24, "SubsubsectionIcon",
  CellTags->{"Notation:S1", "NotationDocumentation"}],
Cell[8217, 291, 5264, 157, 148, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation", 
    "NotationDocumentation"}],
Cell[13484, 450, 122, 1, 27, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[13609, 453, 628, 12, 100, "Text",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[14240, 467, 118, 1, 56, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[14361, 470, 161, 3, 38, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[14525, 475, 186, 5, 56, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[14714, 482, 641, 17, 39, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[15358, 501, 371, 12, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[15754, 517, 280, 7, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[16037, 526, 370, 10, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],
Cell[16422, 539, 196, 5, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[16643, 548, 237, 5, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[16883, 555, 254, 6, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],
Cell[17152, 564, 700, 17, 70, "Text",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[17855, 583, 211, 5, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[18069, 590, 658, 17, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[18730, 609, 165, 4, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[18920, 617, 329, 8, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[19252, 627, 317, 8, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],
Cell[19584, 638, 253, 5, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[19840, 645, 1342, 38, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[21185, 685, 175, 4, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[21385, 693, 474, 14, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[21862, 709, 655, 18, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],
Cell[22532, 730, 209, 4, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[22744, 736, 1269, 36, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[24016, 774, 146, 1, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[24187, 779, 435, 11, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[24625, 792, 359, 9, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],
Cell[24999, 804, 261, 6, 70, "Text",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[25263, 812, 214, 5, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[25480, 819, 648, 17, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[26131, 838, 179, 4, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[26313, 844, 632, 15, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[26970, 863, 540, 14, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}],
Cell[27513, 879, 694, 18, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],
Cell[28222, 900, 419, 7, 70, "Text",
  CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[28678, 912, 92, 1, 20, "SubsubsectionIcon",
  CellTags->{"Notation:S1", "NotationDocumentation"}],
Cell[28773, 915, 2815, 85, 114, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize", 
    "NotationDocumentation"}],
Cell[31591, 1002, 127, 1, 15, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[31721, 1005, 385, 7, 56, "Text",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[32109, 1014, 255, 5, 44, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[32367, 1021, 453, 13, 26, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[32823, 1036, 284, 6, 44, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[33132, 1046, 449, 14, 26, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[33584, 1062, 301, 8, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}]
}, Closed]],
Cell[33900, 1073, 234, 5, 24, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[34137, 1080, 829, 24, 41, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[34969, 1106, 287, 6, 44, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[35281, 1116, 600, 16, 41, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[35884, 1134, 161, 3, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}]
}, Closed]],
Cell[36060, 1140, 270, 7, 40, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[36333, 1149, 278, 7, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[36614, 1158, 194, 5, 44, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[36833, 1167, 203, 5, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[37039, 1174, 270, 6, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}]
}, Closed]],
Cell[37324, 1183, 742, 23, 68, "Text",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[38069, 1208, 219, 4, 60, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[38291, 1214, 271, 7, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}],
Cell[38565, 1223, 694, 19, 43, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[39296, 1247, 97, 1, 20, "SubsubsectionIcon",
  CellTags->{"Notation:S1", "NotationDocumentation"}],
Cell[39396, 1250, 3583, 106, 70, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation", 
    "NotationDocumentation"}],
Cell[42982, 1358, 128, 1, 70, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
Cell[43113, 1361, 602, 15, 70, "Text",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
Cell[43718, 1378, 294, 9, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
Cell[44015, 1389, 378, 11, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[44418, 1404, 446, 13, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
Cell[44867, 1419, 223, 5, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}]
}, Closed]],
Cell[45105, 1427, 245, 7, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[45375, 1438, 505, 14, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
Cell[45883, 1454, 478, 15, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}]
}, Closed]],
Cell[46376, 1472, 725, 18, 70, "Text",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
Cell[47104, 1492, 180, 4, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[47309, 1500, 453, 11, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}],
Cell[47765, 1513, 345, 9, 70, "Output",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}]
}, Closed]],
Cell[48125, 1525, 469, 15, 70, "Text",
  CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[48631, 1545, 101, 1, 20, "SubsubsectionIcon",
  CellTags->{"Notation:S1", "NotationDocumentation"}],
Cell[48735, 1548, 638, 16, 70, "Text",
  CellTags->{
  "Must use palette", "Notation:Documentation:Entering Notations", 
    "Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
Cell[49376, 1566, 3478, 88, 70, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
Cell[52857, 1656, 641, 14, 70, "Text",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
Cell[53501, 1672, 145, 1, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
Cell[53649, 1675, 431, 11, 70, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
Cell[54083, 1688, 386, 9, 70, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
Cell[54472, 1699, 1109, 27, 70, "Text",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
Cell[55584, 1728, 168, 4, 70, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
Cell[55755, 1734, 486, 12, 70, "Input",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}],
Cell[56244, 1748, 249, 6, 70, "Text",
  CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[56542, 1760, 99, 1, 26, "SubsectionIcon",
  CellTags->"NotationDocumentation"],

Cell[CellGroupData[{
Cell[56666, 1765, 111, 1, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S2", "NotationDocumentation"}],
Cell[56780, 1768, 1434, 37, 70, "Text",
  CellTags->{
  "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
    "NotationDocumentation"}],
Cell[58217, 1807, 2380, 53, 70, "DefinitionBox",
  CellTags->{
  "List of Boxes", "Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[60600, 1862, 146, 1, 70, "Caption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[60749, 1865, 675, 15, 70, "Text",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[61427, 1882, 170, 4, 70, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[61600, 1888, 1158, 32, 70, "Input",
  CellTags->{
  "Ring Operations", "Notation:S2", "Notation:S2.1", 
    "NotationDocumentation"}],
Cell[62761, 1922, 248, 6, 70, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[63034, 1932, 281, 6, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[63318, 1940, 317, 8, 70, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[63672, 1953, 165, 3, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[63840, 1958, 369, 10, 70, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]],
Cell[64224, 1971, 567, 14, 70, "Text",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[64794, 1987, 182, 4, 70, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[65001, 1995, 385, 11, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[65389, 2008, 343, 8, 70, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]],
Cell[65747, 2019, 199, 4, 70, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[65971, 2027, 197, 4, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[66171, 2033, 198, 4, 70, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]],
Cell[66384, 2040, 251, 7, 70, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[66638, 2049, 1665, 47, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[68306, 2098, 371, 13, 70, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[68702, 2115, 390, 8, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}],
Cell[69095, 2125, 366, 8, 70, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[69510, 2139, 107, 1, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S2", "NotationDocumentation"}],
Cell[69620, 2142, 560, 17, 70, "Text",
  CellTags->{
  "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
    "NotationDocumentation"}],
Cell[70183, 2161, 149, 1, 70, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
Cell[70335, 2164, 548, 14, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[70908, 2182, 283, 7, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
Cell[71194, 2191, 298, 8, 70, "Output",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}]
}, Closed]],
Cell[71507, 2202, 204, 5, 70, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[71736, 2211, 216, 5, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}],
Cell[71955, 2218, 311, 8, 70, "Output",
  CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[72315, 2232, 116, 1, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S2", "NotationDocumentation"}],
Cell[72434, 2235, 1094, 28, 70, "Text",
  CellTags->{
  "Notation:S2", "Notation:S2.3", 
    "Notation:Documentation:Changing Precedences", "NotationDocumentation"}],
Cell[73531, 2265, 274, 6, 70, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[73830, 2275, 362, 10, 70, "Input",
  CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}],
Cell[74195, 2287, 554, 13, 70, "Output",
  CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}]
}, Closed]],
Cell[74764, 2303, 726, 21, 70, "Text",
  CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[75539, 2330, 94, 1, 26, "SubsectionIcon",
  CellTags->"NotationDocumentation"],
Cell[75636, 2333, 783, 23, 70, "Text",
  CellTags->{
  "Notation:Documentation:Options", "Notation:S3", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[76444, 2360, 138, 4, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S3", "NotationDocumentation"}],
Cell[76585, 2366, 1723, 47, 70, "DefinitionBox3Col",
  CellTags->{
  "Notation:Definition:Action", "Notation:S3", "Notation:S3.1", 
    "NotationDocumentation"}],
Cell[78311, 2415, 177, 5, 70, "Caption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[78491, 2422, 537, 17, 70, "Text",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[79031, 2441, 200, 4, 70, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[79234, 2447, 874, 22, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[80111, 2471, 135, 1, 70, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[80271, 2476, 248, 6, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[80522, 2484, 389, 11, 70, "Output",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}]
}, Closed]],
Cell[80926, 2498, 549, 16, 70, "Text",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[81478, 2516, 142, 1, 70, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[81623, 2519, 874, 22, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[82500, 2543, 156, 2, 70, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[82681, 2549, 248, 6, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[82932, 2557, 249, 6, 70, "Output",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}]
}, Closed]],
Cell[83196, 2566, 488, 13, 70, "Text",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[83687, 2581, 281, 9, 70, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[83993, 2594, 873, 22, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[84869, 2618, 1148, 26, 70, "Output",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}],
Cell[86020, 2646, 1623, 34, 70, "Output",
  CellTags->{"Notation:S3", "Notation:S3.1", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[87692, 2686, 143, 4, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S3", "NotationDocumentation"}],
Cell[87838, 2692, 5644, 152, 70, "DefinitionBox3Col",
  CellTags->{
  "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2", 
    "NotationDocumentation"}],
Cell[93485, 2846, 190, 5, 70, "Caption",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
Cell[93678, 2853, 915, 33, 70, "Text",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
Cell[94596, 2888, 602, 21, 70, "Text",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
Cell[95201, 2911, 328, 11, 70, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
Cell[95532, 2924, 1966, 51, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
Cell[97501, 2977, 129, 1, 70, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[97655, 2982, 323, 8, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
Cell[97981, 2992, 286, 7, 70, "Output",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[98304, 3004, 165, 3, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
Cell[98472, 3009, 294, 8, 70, "Output",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[98803, 3022, 668, 17, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}],
Cell[99474, 3041, 489, 12, 70, "Output",
  CellTags->{"Notation:S3", "Notation:S3.2", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[100012, 3059, 155, 4, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S3", "NotationDocumentation"}],
Cell[100170, 3065, 4592, 127, 70, "DefinitionBox3Col",
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
Cell[104765, 3194, 142, 1, 70, "Caption",
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
Cell[104910, 3197, 1135, 28, 70, "text",
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
Cell[106048, 3227, 240, 6, 70, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}],
Cell[106291, 3235, 212, 5, 70, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S3", "Notation:S3.3", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[106540, 3245, 150, 4, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S3", "NotationDocumentation"}],
Cell[106693, 3251, 1493, 41, 70, "DefinitionBox",
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
Cell[108189, 3294, 116, 1, 70, "Caption",
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
Cell[108308, 3297, 547, 13, 70, "Text",
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
Cell[108858, 3312, 149, 1, 70, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}],
Cell[109010, 3315, 161, 3, 70, "Input",
  CellTags->{"Notation:S3", "Notation:S3.4", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[109220, 3324, 101, 1, 26, "SubsectionIcon",
  CellTags->"NotationDocumentation"],
Cell[109324, 3327, 179, 2, 70, "Subsubsection",
  CellGroupingRules->"NormalGrouping",
  CellTags->{"Notation:S4.1", "Notation:S4", "NotationDocumentation"}],
Cell[109506, 3331, 714, 19, 70, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.1", "Notation:Documentation:Advanced Features", 
    "NotationDocumentation"}],
Cell[110223, 3352, 1118, 31, 70, "Text",
  CellTags->"NotationDocumentation"],

Cell[CellGroupData[{
Cell[111366, 3387, 92, 1, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],
Cell[111461, 3390, 787, 25, 70, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes", 
    "NotationDocumentation"}],
Cell[112251, 3417, 172, 5, 70, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
Cell[112426, 3424, 898, 24, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
Cell[113327, 3450, 326, 8, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
Cell[113656, 3460, 79, 3, 70, "Input"],
Cell[113738, 3465, 962, 27, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
Cell[114703, 3494, 245, 7, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[114973, 3505, 175, 5, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
Cell[115151, 3512, 184, 4, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}]
}, Closed]],
Cell[115350, 3519, 422, 11, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
Cell[115775, 3532, 382, 12, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
Cell[116160, 3546, 371, 9, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
Cell[116534, 3557, 286, 8, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[116845, 3569, 184, 5, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}],
Cell[117032, 3576, 210, 4, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}]
}, Closed]],
Cell[117257, 3583, 537, 16, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[117831, 3604, 143, 4, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],
Cell[117977, 3610, 1236, 37, 70, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag", 
    "NotationDocumentation"}],
Cell[119216, 3649, 194, 5, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[119435, 3658, 268, 7, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
Cell[119706, 3667, 361, 9, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}]
}, Closed]],
Cell[120082, 3679, 230, 6, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
Cell[120315, 3687, 332, 7, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[120672, 3698, 184, 4, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}],
Cell[120859, 3704, 258, 6, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.3", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[121166, 3716, 168, 4, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],
Cell[121337, 3722, 1137, 23, 70, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag", 
    "NotationDocumentation"}],
Cell[122477, 3747, 211, 5, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
Cell[122691, 3754, 1021, 25, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
Cell[123715, 3781, 416, 7, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
Cell[124134, 3790, 182, 4, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
Cell[124319, 3796, 379, 10, 70, "Input",
  CellTags->{
  "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4", 
    "NotationDocumentation"}],
Cell[124701, 3808, 187, 4, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[124913, 3816, 274, 6, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
Cell[125190, 3824, 227, 5, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}]
}, Closed]],
Cell[125432, 3832, 196, 4, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[125653, 3840, 278, 7, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
Cell[125934, 3849, 309, 8, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}]
}, Closed]],
Cell[126258, 3860, 365, 8, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
Cell[126626, 3870, 265, 7, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[126916, 3881, 1019, 25, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
Cell[127938, 3908, 680, 16, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}],
Cell[128621, 3926, 629, 15, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}]
}, Closed]],
Cell[129265, 3944, 351, 9, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.4", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[129653, 3958, 149, 4, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],
Cell[129805, 3964, 750, 14, 70, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.5", "Notation:Definition:NotationMadeBoxesTag", 
    "NotationDocumentation"}],
Cell[130558, 3980, 221, 5, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[130804, 3989, 1204, 30, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}],
Cell[132011, 4021, 960, 23, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}]
}, Closed]],
Cell[132986, 4047, 344, 8, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.5", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[133367, 4060, 202, 6, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S4", "NotationDocumentation"}],
Cell[133572, 4068, 993, 34, 70, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.6", 
    "Changing precedences and the option SyntaxForm", 
    "Notation:Documentation:SyntaxForm", "NotationDocumentation"}],
Cell[134568, 4104, 187, 4, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[134780, 4112, 249, 6, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
Cell[135032, 4120, 374, 10, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}]
}, Closed]],
Cell[135421, 4133, 257, 5, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
Cell[135681, 4140, 626, 17, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
Cell[136310, 4159, 140, 1, 70, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[136475, 4164, 353, 9, 70, "Input",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
Cell[136831, 4175, 374, 10, 70, "Output",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}]
}, Closed]],
Cell[137220, 4188, 188, 4, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
Cell[137411, 4194, 10333, 230, 70, "OptionBox3Col",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
Cell[147747, 4426, 212, 4, 70, "Caption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
Cell[147962, 4432, 667, 16, 70, "Text",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
Cell[148632, 4450, 6945, 200, 70, "DefinitionBox",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}],
Cell[155580, 4652, 202, 5, 70, "Caption",
  CellTags->{"Notation:S4", "Notation:S4.6", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[155831, 4663, 94, 1, 26, "SubsectionIcon",
  CellTags->"NotationDocumentation"],
Cell[155928, 4666, 303, 9, 70, "Text",
  CellTags->{
  "Notation:S5", "Notation:Documentation:Guidelines", 
    "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[156256, 4679, 111, 1, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],
Cell[156370, 4682, 646, 14, 70, "Text",
  CellTags->{"Notation:S5", "Notation:S5.1", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[157053, 4701, 103, 1, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],
Cell[157159, 4704, 531, 10, 70, "Text",
  CellTags->{"Notation:S5", "Notation:S5.2", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[157727, 4719, 125, 1, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],
Cell[157855, 4722, 751, 13, 70, "Text",
  CellTags->{"Notation:S5", "Notation:S5.3", "NotationDocumentation"}]
}, Closed]],

Cell[CellGroupData[{
Cell[158643, 4740, 122, 1, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],
Cell[158768, 4743, 487, 9, 70, "Text",
  CellTags->{
  "Notation:S5", "Notation:S5.4", "Parse without evaluation", 
    "NotationDocumentation"}],
Cell[159258, 4754, 186, 4, 70, "MathCaption",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
Cell[159447, 4760, 516, 13, 70, "Input",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[159988, 4777, 220, 5, 70, "Input",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
Cell[160211, 4784, 296, 8, 70, "Output",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}]
}, Closed]],
Cell[160522, 4795, 423, 10, 70, "Text",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
Cell[160948, 4807, 390, 8, 70, "MathCaption",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],

Cell[CellGroupData[{
Cell[161363, 4819, 292, 7, 70, "Input",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}],
Cell[161658, 4828, 108, 2, 70, "Print",
  CellTags->"NotationDocumentation"],
Cell[161769, 4832, 249, 5, 70, "Output",
  CellTags->{"Notation:S5", "Notation:S5.4", "NotationDocumentation"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[162067, 4843, 163, 4, 70, "SubsubsectionIcon",
  CellTags->{"Notation:S5", "NotationDocumentation"}],
Cell[162233, 4849, 568, 16, 84, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
Cell[162804, 4867, 811, 20, 56, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
Cell[163618, 4889, 285, 10, 36, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
Cell[163906, 4901, 2533, 86, 57, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
Cell[166442, 4989, 739, 24, 68, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
Cell[167184, 5015, 1212, 42, 84, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
Cell[168399, 5059, 529, 13, 84, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}],
Cell[168931, 5074, 951, 30, 158, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5", "NotationDocumentation"}]
}, Closed]],
Cell[169897, 5107, 146, 1, 36, "SubsubsectionIcon",
  CellTags->{"Notation:S5", "Notation:S5.6", "NotationDocumentation"}]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

