(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13984,        308]*)
(*NotebookOutlinePosition[     15071,        348]*)
(*  CellTagsIndexPosition[     15027,        344]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Create\ Text\ Field\),
            ButtonFunction:>NotebookApply[ 
                InputNotebook[ ], 
                BoxData[ 
                  RowBox[ {
                    StyleBox[ 
                      FrameBox[ 
                      "\[SelectionPlaceholder]", BoxFrame -> True, BoxMargins -> 
                        {{0.3, 0.3}, {1, 0.5}}], "DemonstrationTextField", 
                      Editable -> True, Background -> RGBColor[ 1, 0.6, 0.6]]
                    , "\[InvisibleSpace]"}]], Placeholder],
            ButtonEvaluator->Automatic]},
        {
          ButtonBox[\(Create\ Popup\ Menu\),
            ButtonFunction:>CompoundExpression[ 
                NotebookApply[ 
                  InputNotebook[ ], 
                  BoxData[ 
                    RowBox[ {
                      StyleBox[ 
                        FrameBox[ 
                          GridBox[ {{
                            ButtonBox[ 
                            "\[SelectionPlaceholder]", ButtonData :> "newid", 
                              ButtonSource -> ButtonContents]}, {
                            ButtonBox[ 
                            "\[Placeholder]", ButtonData :> "newid", 
                              ButtonSource -> ButtonContents]}}, GridBaseline -> 
                            {Baseline, {1, 1}}, RowSpacings -> 0, 
                            ColumnSpacings -> 0, GridDefaultElement :> 
                            ButtonBox[ 
                            "\\[Placeholder]", ButtonData :> "newid", 
                              ButtonSource -> ButtonContents]], BoxFrame -> 
                          True, BoxMargins -> False], 
                        "DemonstrationPopupMenu", Background -> RGBColor[ 
                        1, 0.6, 0.6]], "\[InvisibleSpace]"}]]], 
                SelectionMove[ 
                  InputNotebook[ ], All, Cell], 
                Set[ Demo`Private`thecell, 
                  NotebookRead[ 
                    InputNotebook[ ]]], 
                Set[ Demo`Private`ids, 
                  Cases[ Demo`Private`thecell, Blank[ ][ ButtonData, 
                      Pattern[ Demo`Private`s, 
                        Blank[ String]]] -> Demo`Private`s, Infinity]], 
                Set[ Demo`Private`ids, 
                  StringJoin[ "ID", 
                    ToString[ 
                      Plus[ 
                        Max[ {0, 
                          Map[ ToExpression[ 
                              StringDrop[ #, 2]]&, 
                            Select[ Demo`Private`ids, MatchQ[ 
                                Characters[ #], {"I", "D", 
                                PatternTest[ 
                                  BlankSequence[ ], DigitQ]}]&]]}], 1]]]], 
                NotebookWrite[ 
                  InputNotebook[ ], 
                  ReplaceAll[ 
                  Demo`Private`thecell, "newid" -> Demo`Private`ids], All]],
            ButtonEvaluator->Automatic]},
        {
          ButtonBox[\(Add\ Popup\ Item\),
            ButtonFunction:>FrontEndExecute[ {
                FrontEnd`FrontEndToken[ 
                  InputNotebook[ ], "NewRow"]}],
            ButtonEvaluator->None]},
        {
          ButtonBox["Activate",
            ButtonFunction:>CompoundExpression[ 
                SelectionMove[ 
                  InputNotebook[ ], All, Cell], 
                Set[ Demo`Private`cell, 
                  NotebookRead[ 
                    InputNotebook[ ]]], 
                If[ 
                  SameQ[ Demo`Private`cell, {}], 
                  Return[ ]], 
                NotebookWrite[ 
                  InputNotebook[ ], 
                  Cell[ 
                    ReplaceAll[ 
                      ReplaceAll[ 
                        First[ Demo`Private`cell], StyleBox[ 
                          FrameBox[ 
                            Pattern[ Demo`Private`g, 
                              GridBox[ {{
                                ButtonBox[ 
                                  Pattern[ Demo`Private`c, 
                                    Blank[ ]], 
                                  BlankNullSequence[ ]]}, 
                                BlankNullSequence[ ]}, 
                                BlankNullSequence[ ]]], 
                            BlankNullSequence[ ]], "DemonstrationPopupMenu", 
                          Pattern[ Demo`Private`opts, 
                            BlankNullSequence[ ]]] :> StyleBox[ 
                          FrameBox[ 
                            RowBox[ {Demo`Private`c, 
                              InterpretationBox[ 
                                ButtonBox[ 
                                "\[FilledDownTriangle]", Active -> True, 
                                  Background -> GrayLevel[ 0.6], ButtonData -> 
                                  Demo`Private`g], 
                                Sequence[ ], Editable -> True]}], BoxFrame -> 
                            True, 
                            If[ 
                              UnsameQ[ 
                                Complement[ 
                                  Cases[ 
                                  Demo`Private`c, Pattern[ Demo`Private`h, 
                                      Blank[ ]][ 
                                      BlankSequence[ ]] -> Demo`Private`h, 
                                    Infinity], {BoxData, RowBox, List}], {}], 
                              BoxMargins -> {{0.3, 0}, {0.9, 0.5}}, 
                              BoxMargins -> {{0.3, 0}, {0, 0}}]], 
                          "DemonstrationPopupMenu", Demo`Private`opts]], 
                      StyleBox[ 
                        Pattern[ Demo`Private`c, 
                          Blank[ ]], "DemonstrationPopupMenu", 
                        Pattern[ Demo`Private`opts, 
                          BlankNullSequence[ ]]] :> StyleBox[ 
                      Demo`Private`c, "DemonstrationPopupMenu", 
                        Apply[ Sequence, 
                          Prepend[ 
                            Select[ {Demo`Private`opts}, UnsameQ[ 
                                First[ #], Active]&], Active -> True]]]], 
                    Apply[ Sequence, 
                      Rest[ Demo`Private`cell]]], All], 
                SetOptions[ 
                  NotebookSelection[ 
                    InputNotebook[ ]], ButtonBoxOptions -> {Active -> True, 
                  ButtonEvaluator -> Automatic, ButtonFunction :> Function[ 
                  {Demo`Private`contents, Demo`Private`idorgrid}, 
                    CompoundExpression[ 
                      SelectionMove[ 
                        ButtonNotebook[ ], All, ButtonCell], 
                      Set[ Demo`Private`cell, 
                        NotebookRead[ 
                          ButtonNotebook[ ]]], 
                      Set[ Demo`Private`framepos, 
                        First[ 
                          Sort[ 
                            Position[ Demo`Private`cell, 
                              FrameBox[ 
                                PatternTest[ 
                                  Blank[ ], 
                                  Function[ {Demo`Private`x}, 
                                    Not[ 
                                      FreeQ[ 
                                        Unevaluated[ Demo`Private`x], 
                                        Demo`Private`idorgrid]], {HoldAll}]]
                                , 
                                BlankNullSequence[ ]]], OrderedQ[ {
                              Length[ #2], 
                              Length[ #]}]&]]], 
                      If[ 
                        UnsameQ[ 
                          Head[ Demo`Private`idorgrid], GridBox], 
                        Set[ Demo`Private`newframe, 
                          FrameBox[ 
                            RowBox[ {
                              If[ 
                                SameQ[ 
                                  Head[ Demo`Private`contents], BoxData], 
                                First[ Demo`Private`contents], 
                                Demo`Private`contents], 
                              With[ {
                                Set[ Demo`Private`thegrid, 
                                  First[ 
                                    Cases[ 
                                      Part[ Demo`Private`cell, 
                                        Apply[ 
                                        Sequence, Demo`Private`framepos]], 
                                      Blank[ GridBox], Infinity]]]}, 
                                InterpretationBox[ 
                                  ButtonBox[ 
                                  "\[FilledDownTriangle]", Active -> True, 
                                    Background -> GrayLevel[ 0.6], ButtonData -> 
                                    Demo`Private`thegrid], 
                                  Sequence[ ], Editable -> True]]}], BoxFrame -> 
                            True, 
                            If[ 
                              UnsameQ[ 
                                Complement[ 
                                  Cases[ 
                                  Demo`Private`contents, Pattern[ 
                                    Demo`Private`h, 
                                      Blank[ ]][ 
                                      BlankSequence[ ]] -> Demo`Private`h, 
                                    Infinity], {BoxData, RowBox, List}], {}], 
                              BoxMargins -> {{0.3, 0}, {0.9, 0.5}}, 
                              BoxMargins -> {{0.3, 0}, {0, 0}}]]], 
                        Set[ Demo`Private`newframe, 
                          FrameBox[ 
                          Demo`Private`idorgrid, BoxFrame -> True, BoxMargins -> 
                            False]]], 
                      NotebookWrite[ 
                        ButtonNotebook[ ], 
                        ReplacePart[ 
                        Demo`Private`cell, Demo`Private`newframe, 
                          Demo`Private`framepos], All]]]}]],
            ButtonEvaluator->Automatic]},
        {
          ButtonBox["Deactivate",
            ButtonFunction:>CompoundExpression[ 
                SelectionMove[ 
                  InputNotebook[ ], All, Cell], 
                Set[ Demo`Private`cell, 
                  NotebookRead[ 
                    InputNotebook[ ]]], 
                If[ 
                  SameQ[ Demo`Private`cell, {}], 
                  Return[ ]], 
                NotebookWrite[ 
                  InputNotebook[ ], 
                  Cell[ 
                    ReplaceAll[ 
                      First[ Demo`Private`cell], StyleBox[ 
                        Pattern[ Demo`Private`c, 
                          Blank[ ]], "DemonstrationPopupMenu", 
                        Pattern[ Demo`Private`opts, 
                          BlankNullSequence[ ]]] :> StyleBox[ 
                      Demo`Private`c, "DemonstrationPopupMenu", 
                        Apply[ Sequence, 
                          Prepend[ 
                            Select[ {Demo`Private`opts}, UnsameQ[ 
                                First[ #], Active]&], Active -> False]]]], 
                    Apply[ Sequence, 
                      Rest[ Demo`Private`cell]]], All], 
                SetOptions[ 
                  NotebookSelection[ 
                    InputNotebook[ ]], ButtonBoxOptions -> {Active -> False}]]
              ,
            ButtonEvaluator->Automatic]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->{False, True, True, False},
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 712}},
Editable->False,
WindowToolbars->{},
PageWidth->368,
WindowSize->{Fit, Fit},
WindowMargins->{{Automatic, 105}, {Automatic, 2}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
WindowTitle->"Demo Maker",
ScrollingOptions->{"PagewiseScrolling"->True},
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1718, 49, 12262, 257, 91, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

