(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28715,        713]*)
(*NotebookOutlinePosition[     30079,        761]*)
(*  CellTagsIndexPosition[     29988,        755]*)
(*WindowFrame->Palette*)



Notebook[{
Cell["\<\
BeginPackage[\"Miscellaneous`ChemicalElements`\",
   \"Miscellaneous`Units`\", \"Miscellaneous`SIUnits`\"]
ElementReport::usage = \"ElementReport[element] outputs a formatted
report on the named element to the current input notebook.
ElementReport[notebook, element] outputs the report to the named notebook.\";
Begin[\"`Private`\"]
spf1 = (Head[General::spell]=!=$Off);
spf2 = (Head[General::spell1]=!=$Off);
Off[General::spell];Off[General::spell1];
AtomicWeightUnstable[name_Symbol, number_] :=
    If[TrueQ[$PeriodicTableDemo],
       {StyleBox[
       RowBox[{\"(\", integerizeToString[number], \")\"}],
       FontColor -> RGBColor[0.6,0,0]], number},
\tMessage[AtomicWeight::unstable, name]; number
    ];
MeltingPointException[name_Symbol, mp_, form_?StringQ] :=
    If[TrueQ[$PeriodicTableDemo],
       {RowBox[{integerizeToString[mp], \" \", \"K\", \" \", 
       StyleBox[RowBox[{\"(\", form, \" \", \"form\", \")\"}],
         FontColor -> RGBColor[0.4,0.2,0.6]]}], mp Kelvin},
\t(Message[MeltingPoint::form, name, form]; mp Kelvin)
    ];
BoilingPointException[name_Symbol, bp_, form_?StringQ] :=
    If[TrueQ[$PeriodicTableDemo],
        {RowBox[{integerizeToString[bp], \" \", \"K\", \" \", 
        StyleBox[RowBox[{\"(\", form,\" \", \"form \", \")\"}],
        FontColor -> RGBColor[0.4,0.2,0.6]]}], mp Kelvin},
\t(Message[BoilingPoint::form, name, form]; bp Kelvin)
    ];
HeatOfFusionException[name_Symbol, hof_, form_?StringQ] :=
    If[TrueQ[$PeriodicTableDemo],
        {RowBox[{integerizeToString[hof], \"\[Times]\", \
SuperscriptBox[\"10\",\"3\"], \" \",
            \"J\", \" \", SuperscriptBox[\"M\", RowBox[{\"-\", \"1\"}]], \" \
\",
            StyleBox[RowBox[{\"(\", form, \" \", \"form\", \")\"}],
         FontColor -> RGBColor[0.4,0.2,0.6]]}], hof Kilo Joule / Mole},
\t(Message[HeatOfFusion::form, name, form]; hof Kilo Joule / Mole)
    ];
HeatOfVaporizationException[name_Symbol, hov_, form_?StringQ] :=
    If[TrueQ[$PeriodicTableDemo],
        {RowBox[{integerizeToString[hov], \"\[Times]\", \
SuperscriptBox[\"10\",\"3\"], \" \",
            \"J\", \" \", SuperscriptBox[\"M\", RowBox[{\"-\", \"1\"}]], \" \
\",
            StyleBox[RowBox[{\"(\", form,\" \", \"form\", \")\"}],
         FontColor -> RGBColor[0.4,0.2,0.6]]}], hov Kilo Joule / Mole},
\t(Message[HeatOfVaporization::form, name, form]; hov Kilo Joule / Mole)
    ];
DensityException[name_Symbol, den_, temp_?NumberQ] :=
    If[TrueQ[$PeriodicTableDemo],
    {RowBox[{integerizeToString[den], \" \", \"kg\", \" \", \
SuperscriptBox[\"m\",
      RowBox[{\"-\", \"3\"}]], \" \", StyleBox[RowBox[{
      \"(\", \"at\", integerizeToString[temp], \" \", \"K\", \")\"}],
         FontColor -> RGBColor[0.4,0.2,0.6]]}],
      den Kilogram/(Meter)^3},
\t(Message[Density::temp, name, temp]; den Kilogram/(Meter)^3)
    ];
DensityException[name_Symbol, den_, form_?StringQ] :=
    If[TrueQ[$PeriodicTableDemo],
    {RowBox[{integerizeToString[den], \" \", \"kg\", \" \", \
SuperscriptBox[\"m\",
      RowBox[{\"-\", \"3\"}]], \" \", StyleBox[RowBox[{\"(\", form, \" \", \
\"form\", \")\"}],
         FontColor -> RGBColor[0.4,0.2,0.6]]}],
      den Kilogram/(Meter)^3},
\t(Message[Density::form, name, form]; den Kilogram/(Meter)^3)
    ];
DensityException[name_Symbol, den_, temp_?NumberQ, form_?StringQ] :=
    If[TrueQ[$PeriodicTableDemo],
     {RowBox[{integerizeToString[den], \" \", \"kg\", \" \", \
SuperscriptBox[\"m\",
      RowBox[{\"-\", \"3\"}]], \" \", 
      StyleBox[RowBox[{\"(\",form, \"form\", \" \", \"at\",
         integerizeToString[temp], \" \", \"K\", \")\"}],
         FontColor -> RGBColor[0.4,0.2,0.6]]}],
      den Kilogram/(Meter)^3},
\t (Message[Density::tempform, name, temp, form]; den Kilogram/(Meter)^3)
    ];
ThermalConductivityException[name_Symbol, tc_, form_?StringQ] :=
    If[TrueQ[$PeriodicTableDemo],
    {RowBox[{integerizeToString[tc], \" \", \"W\", SuperscriptBox[\"m\",
        RowBox[{\"-\", \"1\"}]], SuperscriptBox[\"K\",
        RowBox[{\"-\", \"1\"}]], \" \", StyleBox[RowBox[{
         \"(\", form, \" \", \"form\", \")\"}],
         FontColor -> RGBColor[0.4,0.2,0.6]]}], tc Watt/(Meter Kelvin)},
\t(Message[ThermalConductivity::form, name, form]; tc Watt/(Meter Kelvin))
    ];
integerizeToString[n_] := ToString[If[Round[n] == n, Round[n], n]];
BuildBoxes[value:{__Integer}] := RowBox[Join[{\"{\"},
    Drop[Flatten[value/.s_Integer :> Sequence @@
    {ToString[s], \",\"}], -1], {\"}\"}]];
BuildBoxes[Unknown] = Unknown;
BuildBoxes[{}] = RowBox[{\"{\",\"}\"}];
BuildBoxes[{value:(_RowBox | _StyleBox), _}] := value;
BuildBoxes[value_String] := value;
BuildBoxes[value:(_Integer | _Real)] := ToString[If[Round[value] == value,
    Round[value], value]];
BuildBoxes[value_] := 
    RowBox[{integerizeToString[
        First[Cases[value, _Real | _Integer, Infinity]]],
    If[Not[FreeQ[value, Kilo]], Sequence @@ {\"\[Times]\", \
SuperscriptBox[\"10\",
      \"3\"], \" \"}, \" \"], FormatUnits[value/.{p_Power :> p,
      _Real -> 1, _Integer -> 1, Kilo -> 1}]}];
FormatUnits[s_Symbol] := s/.{Watt -> \"W\", Meter -> \"m\", Kilogram -> \
\"kg\",
    Kelvin -> \"K\", Joule -> \"J\", Mole -> \"mol\"};
FormatUnits[HoldPattern[Times[s__Symbol, p__Power]]] :=
RowBox[Drop[Flatten[{Map[Sequence @@ {FormatUnits[#], \" \"}&, {s}],
   Apply[(Sequence @@ {SuperscriptBox[FormatUnits[#1], ToString[#2]], \" \
\"})&,
   {p}, {1}]}], -1]];
FormatUnits[HoldPattern[Times[s__Symbol]]] :=
RowBox[Drop[Flatten[Map[Sequence @@ {FormatUnits[#], \" \"}&, {s}]], -1]];
FormatElectronConfiguration[Unknown] := Unknown;
FormatElectronConfiguration[config_] :=
  RowBox[MapIndexed[Function[{c, l}, 
      RowBox[Append[MapThread[RowBox[{ToString[First[l]],
         SuperscriptBox[#1, ToString[#2]]}]&,
         {Take[{\"s\",\"p\",\"d\",\"f\"},Length[c]], c}],
        \" \"]]], config]];
ElementReport[theElement_] :=
   ElementReport[InputNotebook[], theElement];
ElementReport[nb_NotebookObject, theElement_Symbol] :=
Block[{$MessageFlags,$PeriodicTableValues, $UnknownMessages},
$UnknownMessages = {Unevaluated[MeltingPoint::unknown],
    Unevaluated[BoilingPoint::unknown],
    Unevaluated[HeatOfFusion::unknown],
    Unevaluated[HeatOfVaporization::unknown],
    Unevaluated[Density::unknown],
    Unevaluated[ThermalConductivity::unknown],
    Unevaluated[ElectronConfiguration::unknown],
    Unevaluated[AtomicWeight::unknown]};
$MessageFlags = Map[TrueQ[Head[Evaluate[#]] =!= $Off]&,
   $UnknownMessages];
Map[Off, $UnknownMessages];
$PeriodicTableDemo = True;
 $PeriodicTableValues = MapThread[Rule, {#,Map[(#[theElement])&, #]}&[
   {Abbreviation, AtomicNumber, AtomicWeight, StableIsotopes,
    ElectronConfiguration, MeltingPoint, BoilingPoint, HeatOfFusion,
    HeatOfVaporization, Density, ThermalConductivity}]
];
SelectionMove[nb, After, Cell];
NotebookWrite[nb, BoxData[InterpretationBox @@ {StyleBox[
GridBox[{
   {GridBox[{{AdjustmentBox[StyleBox[
     RowBox[{ToString[theElement], \" \", \"(\",
       Abbreviation/.$PeriodicTableValues, \")\"}],
     FontFamily -> Helvetica, FontWeight -> \"Bold\",
     FontColor -> GrayLevel[1]],
     BoxMargins->{{0.3, 0.2}, {0, 0.6}}],
     AdjustmentBox[StyleBox[
       ToString[AtomicNumber/.$PeriodicTableValues],
     FontFamily -> Helvetica, FontWeight -> \"Bold\",
     FontColor -> GrayLevel[1]],
     BoxMargins->{{0.3, 0.2}, {0, 0.6}}]}},
     System`ColumnWidths -> {15, 5},
     ColumnAlignments -> {Left, Right}
     ]},
{
StyleBox[GridBox[Join[
 {{StyleBox[GridBox[Join[
\t Apply[{AdjustmentBox[StyleBox[RowBox[Append[#1, BuildBoxes[#2]]],
\t          FontFamily -> \"Helvetica\", FontWeight -> \"Plain\",
\t          FontSize -> Smaller], BoxMargins -> {{0.3, 0.2},{0,0.5}}]}&,
\t Select[
\t   {{{\"Atomic\", \" \", \"Number\",\" \", \":\", \" \"}, AtomicNumber},
\t    {{\"Atomic\",\" \",\"Weight\", \" \", \":\", \" \"}, AtomicWeight},
\t    {{\"Stable\",\" \",\"Isotopes\",\" \", \":\",\" \"}, StableIsotopes}}/.
\t      $PeriodicTableValues,
\t    (Last[#] =!= Unknown)&],
\t  {1}],
 If[(ElectronConfiguration/.$PeriodicTableValues) =!= Unknown,
 {{StyleBox[GridBox[
     {{AdjustmentBox[StyleBox[RowBox[{\"Electron\", \" \", \
\"Configuration\"}],
         FontFamily -> \"Helvetica\", FontWeight -> \"Plain\",
\t          FontSize -> Smaller], BoxMargins -> {{0.3, 0.2},{0,0.6}}]},
      {AdjustmentBox[
      StyleBox[Insert[FormatElectronConfiguration[ElectronConfiguration/.
                   $PeriodicTableValues], \"  \", {1,1}],
          FontFamily -> \"Helvetica\", FontWeight -> \"Plain\",
\t          FontSize -> Smaller], BoxMargins -> {{0.3, 0.2},{0.6, 0}}]}},
        System`ColumnWidths->22,
        ColumnAlignments->{Left}
   ], Background->RGBColor[0.8, 0.8, 1]]}},
   {}
  ]
\t  ],
                System`ColumnWidths->22,
                ColumnAlignments->{Left}
\t], Background->RGBColor[0.2, 0.8, 1]]}},
 Apply[{AdjustmentBox[StyleBox[RowBox[Append[#1, BuildBoxes[#2]]],
           FontFamily -> \"Helvetica\", FontWeight -> \"Plain\",
\t          FontSize -> Smaller], BoxMargins -> {{0.3, 0.2},{0.4,0.1}}]}&,
 Select[
   {{{\"Density\", \" \", \":\", \" \"}, Density},
    {{\"Thermal\",\" \",\"Conductivity\", \" \", \":\", \" \"}, \
ThermalConductivity},
    {{\"Melting\",\" \",\"Point\",\" \", \":\",\" \"}, MeltingPoint},
    {{\"Heat\", \" \", \"of\", \" \", \"Fusion\", \" \", \":\", \" \"}, \
HeatOfFusion},
    {{\"Boiling\",\" \",\"Point\",\" \", \":\",\" \"}, BoilingPoint},
    {{\"Heat\", \" \", \"of\", \" \", \"Vaporization\", \" \", \":\", \" \"}, \
HeatOfVaporization}}/.
      $PeriodicTableValues,
    (Last[#] =!= Unknown)&],
  {1}]
],
                System`ColumnWidths->22,
                ColumnAlignments->{Left},
                GridFrame -> False],
           Background -> RGBColor[0, 1, 1]]
}},
                System`ColumnWidths->22,
                ColumnAlignments->{Left},
                GridFrame -> {{3,0},{0,0}},
                System`GridFrameMargins -> {{0,0},{0,0}}],
FontFamily->\"Courier\", Background -> GrayLevel[0]],
 $PeriodicTableValues/.{{_RowBox, v_} :> v, {_StyleBox, v_} :> v}}
]
];
$PeriodicTableDemo = False;
SelectionMove[nb, After, Cell];
MapThread[If[#1, On[#2]]&, {$MessageFlags, $UnknownMessages}];
];
ElementReport[nb_, x_String] := Module[
\t\t   {i=Flatten[Position[ElementAbbreviations,ToString[x]]]},
                   ElementReport[nb, Elements[[ i[[1]] ]] ] /;
\t\t       !SameQ[i,{}]
                 ];
$PeriodicTableDemoCodePatch = True;
If[spf1, On[General::spell]];
If[spf2, On[General::spell1]];
End[]
EndPackage[]

\
\>", "Input",
  PageWidth->WindowWidth,
  CellElementSpacings->{"ClosedCellHeight"->0.5},
  CellOpen->False,
  GeneratedCell->True,
  CellTags->"ThePeriodicTableCodePatch"],

Cell[BoxData[
    StyleBox[GridBox[{
          {
            ButtonBox["H",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"1 - Hydrogen"], "", "", "", "", "", "", "", "", 
            "", "", "", "", "", "", "", "", 
            ButtonBox["He",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"2 - Helium"]},
          {
            ButtonBox["Li",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"3 - Lithium"], 
            ButtonBox["Be",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"4 - Beryllium"], "", "", " ", 
            StyleBox[" ",
              ButtonBoxOptions->{ButtonFunction:>(NotebookWrite[ 
                  SelectedNotebook[ ], 
                  ToString[ 
                    AtomicFunction[ 
                      First[ #]]], After]&),
              ButtonEvaluator->Automatic}], " ", " ", " ", "", "", "", 
            ButtonBox["B",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"5 - Boron"], 
            ButtonBox["C",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"6 - Carbon"], 
            ButtonBox["N",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"7 - Nitrogen"], 
            ButtonBox["O",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"8 - Oxygen"], 
            ButtonBox["F",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"9 - Fluorine"], 
            ButtonBox["Ne",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"10 - Neon"]},
          {
            ButtonBox["Na",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"11 - Sodium"], 
            ButtonBox["Mg",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"12 - Magnesium"], "", "", "", "", "", "", "", "", 
            "", "", 
            ButtonBox["Al",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"13 - Aluminium"], 
            ButtonBox["Si",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"14 - Silicon"], 
            ButtonBox["P",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"15 - Phosphorus"], 
            ButtonBox["S",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"16 - Sulfur"], 
            ButtonBox["Cl",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"17 - Chlorine"], 
            ButtonBox["Ar",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"18 - Argon"]},
          {
            ButtonBox["K",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"19 - Potassium"], 
            ButtonBox["Ca",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"20 - Calcium"], 
            ButtonBox["Sc",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"21 - Scandium"], 
            ButtonBox["Ti",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"22 - Titanium"], 
            ButtonBox["V",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"23 - Vanadium"], 
            ButtonBox["Cr",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"24 - Chromium"], 
            ButtonBox["Mn",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"25 - Manganese"], 
            ButtonBox["Fe",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"26 - Iron"], 
            ButtonBox["Co",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"27 - Cobalt"], 
            ButtonBox["Ni",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"28 - Nickel"], 
            ButtonBox["Cu",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"29 - Copper"], 
            ButtonBox["Zn",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"30 - Zinc"], 
            ButtonBox["Ga",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"31 - Gallium"], 
            ButtonBox["Ge",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"32 - Germanium"], 
            ButtonBox["As",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"33 - Arsenic"], 
            ButtonBox["Se",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"34 - Selenium"], 
            ButtonBox["Br",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"35 - Bromine"], 
            ButtonBox["Kr",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"36 - Krypton"]},
          {
            ButtonBox["Rb",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"37 - Rubidium"], 
            ButtonBox["Sr",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"38 - Strontium"], 
            ButtonBox["Y",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"39 - Yttrium"], 
            ButtonBox["Zr",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"40 - Zirconium"], 
            ButtonBox["Nb",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"41 - Niobium"], 
            ButtonBox["Mo",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"42 - Molybdenum"], 
            ButtonBox["Tc",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"43 - Technetium"], 
            ButtonBox["Ru",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"44 - Ruthenium"], 
            ButtonBox["Rh",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"45 - Rhodium"], 
            ButtonBox["Pd",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"46 - Palladium"], 
            ButtonBox["Ag",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"47 - Silver"], 
            ButtonBox["Cd",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"48 - Cadmium"], 
            ButtonBox["In",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"49 - Indium"], 
            ButtonBox["Sn",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"50 - Tin"], 
            ButtonBox["Sb",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"51 - Antimony"], 
            ButtonBox["Te",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"52 - Tellurium"], 
            ButtonBox["I",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"53 - Iodine"], 
            ButtonBox["Xe",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"54 - Xenon"]},
          {
            ButtonBox["Cs",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"55 - Caesium"], 
            ButtonBox["Ba",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"56 - Barium"], 
            ButtonBox["Lu",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"71 - Lutetium"], 
            ButtonBox["Hf",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"72 - Hafnium"], 
            ButtonBox["Ta",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"73 - Tantalum"], 
            ButtonBox["W",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"74 - Tungsten"], 
            ButtonBox["Re",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"75 - Rhenium"], 
            ButtonBox["Os",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"76 - Osmium"], 
            ButtonBox["Ir",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"77 - Iridium"], 
            ButtonBox["Pt",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"78 - Platinum"], 
            ButtonBox["Au",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"79 - Gold"], 
            ButtonBox["Hg",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"80 - Mercury"], 
            ButtonBox["Tl",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"81 - Thallium"], 
            ButtonBox["Pb",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"82 - Lead"], 
            ButtonBox["Bi",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"83 - Bismuth"], 
            ButtonBox["Po",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"84 - Polonium"], 
            ButtonBox["At",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"85 - Astatine"], 
            ButtonBox["Rn",
              Background->RGBColor[0.8, 1, 1],
              ButtonNote->"86 - Radon"]},
          {
            ButtonBox["Fr",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"87 - Francium"], 
            ButtonBox["Ra",
              Background->RGBColor[0.8, 1, 0.8],
              ButtonNote->"88 - Radium"], 
            ButtonBox["Lr",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"103 - Lawrencium"], 
            ButtonBox["Rf",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"104 - Rutherfordium"], 
            ButtonBox["Db",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"105 - Dubnium"], 
            ButtonBox["Sg",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"106 - Seaborgium"], 
            ButtonBox["Bh",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"107 - Bohrium"], 
            ButtonBox["Hs",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"108 - Hassium"], 
            ButtonBox["Mt",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"109 - Meitnerium"], 
            ButtonBox["Uun",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"110 - Ununnilium"], 
            ButtonBox["Uuu",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"111 - Unununium"], 
            ButtonBox["Uub",
              Background->RGBColor[1, 1, 0.8],
              ButtonNote->"112 - Ununbium"], "", "", "", "", "", ""},
          {"", "", 
            ButtonBox["La",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"57 - Lanthanum"], 
            ButtonBox["Ce",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"58 - Cerium"], 
            ButtonBox["Pr",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"59 - Praseodymium"], 
            ButtonBox["Nd",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"60 - Neodymium"], 
            ButtonBox["Pm",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"61 - Promethium"], 
            ButtonBox["Sm",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"62 - Samarium"], 
            ButtonBox["Eu",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"63 - Europium"], 
            ButtonBox["Gd",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"64 - Gadolinium"], 
            ButtonBox["Tb",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"65 - Terbium"], 
            ButtonBox["Dy",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"66 - Dysprosium"], 
            ButtonBox["Ho",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"67 - Holmium"], 
            ButtonBox["Er",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"68 - Erbium"], 
            ButtonBox["Tm",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"69 - Thulium"], 
            ButtonBox["Yb",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"70 - Ytterbium"], " ", ""},
          {"", "", 
            ButtonBox["Ac",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"89 - Actinium"], 
            ButtonBox["Th",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"90 - Thorium"], 
            ButtonBox["Pa",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"91 - Protactinium"], 
            ButtonBox["U",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"92 - Uranium"], 
            ButtonBox["Np",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"93 - Neptunium"], 
            ButtonBox["Pu",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"94 - Plutonium"], 
            ButtonBox["Am",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"95 - Americium"], 
            ButtonBox["Cm",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"96 - Curium"], 
            ButtonBox["Bk",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"97 - Berkelium"], 
            ButtonBox["Cf",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"98 - Californium"], 
            ButtonBox["Es",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"99 - Einsteinium"], 
            ButtonBox["Fm",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"100 - Fermium"], 
            ButtonBox["Md",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"101 - Mendelevium"], 
            ButtonBox["No",
              Background->RGBColor[1, 0.8, 0.8],
              ButtonNote->"102 - Nobelium"], " ", ""}
          },
        RowSpacings->{0, 0, 0, 0, 0, 0, 1, 0},
        RowsEqual->True,
        ColumnsEqual->True],
      ButtonBoxOptions->{ButtonFunction:>(CompoundExpression[ 
          Needs[ "Miscellaneous`ChemicalElements`"], 
          If[ 
            Not[ 
              ValueQ[ 
              Miscellaneous`ChemicalElements`Private`$\
PeriodicTableDemoCodePatch]], 
            CompoundExpression[ 
              NotebookFind[ 
                ButtonNotebook[ ], "ThePeriodicTableCodePatch", All, CellTags]
              , 
              Set[ 
              Miscellaneous`ChemicalElements`Private`oldce, 
                $CharacterEncoding], 
              Set[ $CharacterEncoding, "Unicode"], 
              Set[ Miscellaneous`ChemicalElements`Private`stream, 
                StringToStream[ 
                  First[ 
                    Cases[ 
                      NotebookRead[ 
                        ButtonNotebook[ ]], 
                      Blank[ String], Infinity]]]], 
              ReadList[ 
              Miscellaneous`ChemicalElements`Private`stream, Expression], 
              Close[ Miscellaneous`ChemicalElements`Private`stream]]], 
          Set[ 
          $CharacterEncoding, Miscellaneous`ChemicalElements`Private`oldce], 
          Miscellaneous`ChemicalElements`ElementReport[ 
            First[ #]]]&),
      ButtonEvaluator->Automatic},
      GridBoxOptions->{RowSpacings->0,
      ColumnSpacings->0}]], NotebookDefault,
  CellFrame->True,
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  CellFrameMargins->{{0, 0}, {15, 5}},
  CellFrameColor->RGBColor[0.6, 0.4, 0.6],
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold"]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 712}},
Editable->False,
WindowToolbars->{},
PageWidth->753,
WindowSize->{Fit, FitAll},
WindowMargins->{{Automatic, 104}, {Automatic, 1}},
WindowFrame->"Palette",
WindowElements->"StatusArea",
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
WindowMovable->True,
WindowTitle->"Periodic Table of the Elements",
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 256}},
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Background->RGBColor[0.6, 0.4, 0.6],
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ThePeriodicTableCodePatch"->{
    Cell[1718, 49, 10710, 247, 0, "Input",
      CellOpen->False,
      CellTags->"ThePeriodicTableCodePatch"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ThePeriodicTableCodePatch", 29850, 747}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1718, 49, 10710, 247, 0, "Input",
  CellOpen->False,
  CellTags->"ThePeriodicTableCodePatch"],
Cell[12431, 298, 16280, 413, 199, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

