(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14382,        329]*)
(*NotebookOutlinePosition[     17289,        416]*)
(*  CellTagsIndexPosition[     17245,        412]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          StyleBox[GridBox[{
                {
                  ButtonBox[
                    StyleBox["c",
                      FontSlant->"Italic"],
                    ButtonData:>"SpeedOfLight",
                    ButtonNote->"SpeedOfLight"], 
                  ButtonBox["\[HBar]",
                    ButtonData:>"PlanckConstantReduced",
                    ButtonNote->"PlanckConstantReduced"], 
                  ButtonBox[
                    StyleBox["e",
                      FontSlant->"Italic"],
                    ButtonData:>"ElectronCharge",
                    ButtonNote->"ElectronCharge"], 
                  ButtonBox["G",
                    ButtonData:>"GravitationalConstant",
                    ButtonNote->"GravitationalConstant"]},
                {
                  ButtonBox[\(\[Epsilon]\_0\),
                    ButtonData:>"VacuumPermittivity",
                    ButtonNote->"VacuumPermittivity"], 
                  ButtonBox[\(\[Mu]\_0\),
                    ButtonData:>"VacuumPermeability",
                    ButtonNote->"VacuumPermeability"], 
                  ButtonBox["k",
                    ButtonData:>"BoltzmannConstant",
                    ButtonNote->"BoltzmannConstant"], 
                  ButtonBox["\[Sigma]",
                    ButtonData:>"StefanConstant",
                    ButtonNote->"StefanConstant"]},
                {
                  ButtonBox[\(N\_A\),
                    ButtonData:>"AvogadroConstant",
                    ButtonNote->"AvogadroConstant"], 
                  ButtonBox["R",
                    ButtonData:>"MolarGasConstant",
                    ButtonNote->"MolarGasConstant"], 
                  ButtonBox[\(V\_m\),
                    ButtonData:>"MolarVolume",
                    ButtonNote->"MolarVolume"], 
                  ButtonBox[\(c\_s\),
                    ButtonData:>"SpeedOfSound",
                    ButtonNote->"SpeedOfSound"]},
                {
                  ButtonBox["\[Alpha]",
                    ButtonData:>"FineStructureConstant",
                    ButtonNote->"FineStructureConstant"], 
                  ButtonBox[\(a\_0\),
                    ButtonData:>"BohrRadius",
                    ButtonNote->"BohrRadius"], 
                  ButtonBox[\(R\_\[Infinity]\),
                    ButtonData:>"RydbergConstant",
                    ButtonNote->"RydbergConstant"], 
                  ButtonBox[\(r\_e\),
                    ButtonData:>"ClassicalElectronRadius",
                    ButtonNote->"ClassicalElectronRadius"]},
                {
                  ButtonBox[\(m\_e\),
                    ButtonData:>"ElectronMass",
                    ButtonNote->"ElectronMass"], 
                  ButtonBox[\(m\_p\),
                    ButtonData:>"ProtonMass",
                    ButtonNote->"ProtonMass"], 
                  ButtonBox[
                    StyleBox["amu",
                      FontFamily->"Helvetica",
                      FontSize->10],
                    ButtonData:>"AtomicMassUnit",
                    ButtonNote->"AtomicMassUnit"], 
                  ButtonBox[\(\[Mu]\_B\),
                    ButtonData:>"BohrMagneton",
                    ButtonNote->"BohrMagneton"]},
                {
                  ButtonBox["g",
                    ButtonData:>"AccelerationDueToGravity",
                    ButtonNote->"AccelerationDueToGravity"], 
                  ButtonBox[\(m\_\[CirclePlus]\),
                    ButtonData:>"EarthMass",
                    ButtonNote->"EarthMass"], 
                  ButtonBox[\(r\_\[CirclePlus]\),
                    ButtonData:>"EarthRadius",
                    ButtonNote->"EarthRadius"], 
                  ButtonBox[\(r\_\[CircleDot]\),
                    ButtonData:>"SolarRadius",
                    ButtonNote->"SolarRadius"]}
                },
              RowSpacings->0,
              ColumnSpacings->0,
              ColumnWidths->2.6,
              RowLines->{False, False, True, False, True, True, False},
              RowsEqual->True,
              ColumnsEqual->True,
              GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]],
            GridBoxOptions->{GridFrameMargins->False}]},
        {
          ButtonBox[
            StyleBox[\(\ \ \(\ \ Paste\ Form\)\),
              FontFamily->"Helvetica",
              FontSize->10,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontVariations->{"Underline"->False,
              "Outline"->False,
              "Shadow"->False}],
            ButtonFunction:>Function[ {FE`Private`thePCCell}, 
                CompoundExpression[ 
                  SelectionMove[ 
                    ButtonNotebook[ ], All, ButtonCell], 
                  NotebookWrite[ 
                    ButtonNotebook[ ], 
                    ReplaceAll[ 
                    FE`Private`thePCCell, {Pattern[ FE`Private`b, 
                        Blank[ ][ ButtonFunction, 
                          Blank[ ]]] :> FE`Private`b, "\[FilledCircle]" :> 
                      " ", RowBox[ {
                        BlankNullSequence[ ], "Form", 
                        BlankNullSequence[ ]}] :> RowBox[
                       {"\[FilledCircle]", " ", "Paste", " ", "Form"}]}]], 
                  SetOptions[ 
                    ButtonNotebook[ ], ButtonBoxOptions -> {ButtonSource -> 
                    ButtonContents, ButtonEvaluator -> Automatic, 
                    ButtonFunction :> (CompoundExpression[ 
                      Needs[ "Miscellaneous`PhysicalConstants`"], 
                      Needs[ "Miscellaneous`Units`"], 
                      NotebookWrite[ 
                        InputNotebook[ ], 
                        BoxData[ 
                          Function[ {FE`Private`expr}, 
                            InterpretationBox[ FE`Private`expr, 
                              Symbol[ #2]]][ 
                            If[ 
                              SameQ[ 
                                Head[ #], BoxData], 
                              First[ #], #]]]]]&)}]]],
            ButtonEvaluator->Automatic,
            ButtonSource->Cell]},
        {
          ButtonBox[
            StyleBox[\(\ \ \(\ \ Paste\ Symbol\)\),
              FontFamily->"Helvetica",
              FontSize->10,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontVariations->{"Underline"->False,
              "Outline"->False,
              "Shadow"->False}],
            ButtonFunction:>Function[ {FE`Private`thePCCell}, 
                CompoundExpression[ 
                  SelectionMove[ 
                    ButtonNotebook[ ], All, ButtonCell], 
                  NotebookWrite[ 
                    ButtonNotebook[ ], 
                    ReplaceAll[ 
                    FE`Private`thePCCell, {Pattern[ FE`Private`b, 
                        Blank[ ][ ButtonFunction, 
                          Blank[ ]]] :> FE`Private`b, "\[FilledCircle]" :> 
                      " ", RowBox[ {
                        BlankNullSequence[ ], "Symbol", 
                        BlankNullSequence[ ]}] :> RowBox[
                       {"\[FilledCircle]", " ", "Paste", " ", "Symbol"}]}]], 
                  SetOptions[ 
                    ButtonNotebook[ ], ButtonBoxOptions -> {ButtonSource -> 
                    ButtonContents, ButtonEvaluator -> Automatic, 
                    ButtonFunction :> (CompoundExpression[ 
                      Needs[ "Miscellaneous`PhysicalConstants`"], 
                      Needs[ "Miscellaneous`Units`"], 
                      NotebookWrite[ 
                        InputNotebook[ ], 
                        BoxData[ 
                          RowBox[ {" ", #2, " "}]]]]&)}]]],
            ButtonEvaluator->Automatic,
            ButtonSource->Cell]},
        {
          ButtonBox[
            StyleBox[\(\[FilledCircle]\ Paste\ Value\),
              FontFamily->"Helvetica",
              FontSize->10,
              FontWeight->"Plain",
              FontSlant->"Plain",
              FontTracking->"Plain",
              FontVariations->{"Underline"->False,
              "Outline"->False,
              "Shadow"->False}],
            ButtonFunction:>Function[ {FE`Private`thePCCell}, 
                CompoundExpression[ 
                  SelectionMove[ 
                    ButtonNotebook[ ], All, ButtonCell], 
                  NotebookWrite[ 
                    ButtonNotebook[ ], 
                    ReplaceAll[ 
                    FE`Private`thePCCell, {Pattern[ FE`Private`b, 
                        Blank[ ][ ButtonFunction, 
                          Blank[ ]]] :> FE`Private`b, "\[FilledCircle]" :> 
                      " ", RowBox[ {
                        BlankNullSequence[ ], "Value", 
                        BlankNullSequence[ ]}] :> RowBox[
                       {"\[FilledCircle]", " ", "Paste", " ", "Value"}]}]], 
                  SetOptions[ 
                    ButtonNotebook[ ], ButtonBoxOptions -> {ButtonSource -> 
                    ButtonContents, ButtonEvaluator -> Automatic, 
                    ButtonFunction :> (CompoundExpression[ 
                      Needs[ "Miscellaneous`PhysicalConstants`"], 
                      Needs[ "Miscellaneous`Units`"], 
                      NotebookWrite[ 
                        InputNotebook[ ], 
                        ReplaceAll[ 
                          ReplaceAll[ 
                            Switch[ #2, "BohrMagneton", 
                              Symbol[ "Miscellaneous`Units`Convert"][ 
                                Times[ 1, 
                                  Symbol[ 
                                  "Miscellaneous`Units`BohrMagneton"]], 
                                Times[ 
                                  Symbol[ "Miscellaneous`SIUnits`Joule"], 
                                  Power[ 
                                    Symbol[ "Miscellaneous`SIUnits`Tesla"],
                                     -1]]], "AtomicMassUnit", 
                              Symbol[ "Miscellaneous`Units`Convert"][ 
                                Times[ 1, 
                                  Symbol[ 
                                  "Miscellaneous`Units`AtomicMassUnit"]], 
                                Symbol[ "Miscellaneous`SIUnits`Kilogram"]], 
                              Blank[ ], 
                              ToExpression[ #2]], HoldPattern[ 
                              Times[ 
                                PatternTest[ 
                                  Pattern[ FE`Private`n, 
                                    Blank[ ]], NumericQ], 
                                Pattern[ FE`Private`r, 
                                  BlankNullSequence[ ]]]] :> BoxData[ 
                              RowBox[ {
                                StyleBox[ 
                                  If[ 
                                    Greater[ 
                                      Length[ {FE`Private`n}], 1], 
                                    MakeBoxes[ 
                                      Times[ FE`Private`n]], 
                                    MakeBoxes[ FE`Private`n]], NumberMarks -> 
                                  False], 
                                If[ 
                                  Greater[ 
                                    Length[ {FE`Private`r}], 1], 
                                  MakeBoxes[ 
                                    Times[ FE`Private`r]], 
                                  MakeBoxes[ FE`Private`r]]}]]], FractionBox[ 
                          "1", 
                            Pattern[ FE`Private`n, 
                              Blank[ ]]] :> SuperscriptBox[ 
                          FE`Private`n, "-1"]]]]&)}]]],
            ButtonEvaluator->Automatic,
            ButtonSource->Cell]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->{True, False},
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Times"]
},
FrontEndVersion->"Microsoft Windows 3.0 Beta 3",
ScreenRectangle->{{0, 1024}, {0, 712}},
WindowToolbars->{},
PageWidth->357,
WindowSize->{Fit, Fit},
WindowMargins->{{Automatic, 5}, {Automatic, 2}},
WindowFrame->"Palette",
WindowElements->"StatusArea",
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
WindowTitle->"Constants",
ScrollingOptions->{"PagewiseScrolling"->True},
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
FontWeight->"Plain",
Background->GrayLevel[0.8],
Magnification->1,
ButtonBoxOptions->{ButtonFunction:>(CompoundExpression[ 
    Needs[ "Miscellaneous`PhysicalConstants`"], 
    Needs[ "Miscellaneous`Units`"], 
    NotebookWrite[ 
      InputNotebook[ ], 
      ReplaceAll[ 
        ReplaceAll[ 
          Switch[ #2, "BohrMagneton", 
            Symbol[ "Miscellaneous`Units`Convert"][ 
              Times[ 1, 
                Symbol[ "Miscellaneous`Units`BohrMagneton"]], 
              Times[ 
                Symbol[ "Miscellaneous`SIUnits`Joule"], 
                Power[ 
                  Symbol[ "Miscellaneous`SIUnits`Tesla"], -1]]], 
            "AtomicMassUnit", 
            Symbol[ "Miscellaneous`Units`Convert"][ 
              Times[ 1, 
                Symbol[ "Miscellaneous`Units`AtomicMassUnit"]], 
              Symbol[ "Miscellaneous`SIUnits`Kilogram"]], 
            Blank[ ], 
            ToExpression[ #2]], HoldPattern[ 
            Times[ 
              PatternTest[ 
                Pattern[ FE`Private`n, 
                  Blank[ ]], NumericQ], 
              Pattern[ FE`Private`r, 
                BlankNullSequence[ ]]]] :> BoxData[ 
            RowBox[ {
              StyleBox[ 
                If[ 
                  Greater[ 
                    Length[ {FE`Private`n}], 1], 
                  MakeBoxes[ 
                    Times[ FE`Private`n]], 
                  MakeBoxes[ FE`Private`n]], NumberMarks -> False], 
              If[ 
                Greater[ 
                  Length[ {FE`Private`r}], 1], 
                MakeBoxes[ 
                  Times[ FE`Private`r]], 
                MakeBoxes[ FE`Private`r]]}]]], FractionBox[ "1", 
          Pattern[ FE`Private`n, 
            Blank[ ]]] :> SuperscriptBox[ FE`Private`n, "-1"]]]]&),
ButtonEvaluator->Automatic,
ButtonSource->ButtonContents}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 12668, 278, 199, NotebookDefault,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

